CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20170205   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P26    CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:34.807576Z    ORIGINAL_HEADER      6CTD,20250210CCHSIOWB
#Removed 'CTDFLUOR_TSG' as it's filled with -999
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2017-06-29. CTD data from cruise 18DD20170205, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20170205. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2017-001/index.php. 
#
# The information in this file for the cruise 2017-001 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-0036.ctd
#
# Start of originator file comment header
#
#*2017/06/29 15:26:50.02
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2017/02/10 06:17:38.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 198
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : CE9F1F72
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            0.3            202.1
#       2 Temperature:CTD               deg_C_(ITS90)   5.6248         6.8697
#       3 Salinity:CTD                  PSS-78          32.78          33.8432
#       4 Sigma-t:CTD                   kg/m^3          25.7461        26.7106
#       5 Oxygen:Dissolved:CTD:Volume   ml/l            3.4            6.87
#       6 Oxygen:Dissolved:CTD:Mass     µmol/kg         147.7          299
#       7 Fluorescence:CTD:Seapoint     mg/m^3          0.66E-01       1.162
#       8 PAR:CTD                       µE/m^2/sec      0              0.3
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        7  F       ' '     2
#       6  -99   ' '        6  F       ' '     1
#       7  -99   ' '        8  F       ' '     3
#       8  -99   ' '        7  F       ' '     1
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2017-001
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P21
#    EVENT NUMBER        : 36
#    LATITUDE            :  49  38.00000 N  ! (deg min)
#    LONGITUDE           : 139  39.97000 W  ! (deg min)
#    WATER DEPTH         : 3961
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    The descent rate of the CTD was very noisy with some complete reversals
#	of direction.
#    CTDEDIT was used to remove many records corrupted by shed wakes;
#	salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Fluorescence and PAR data are nominal and unedited except that some records were
#	removed in editing temperature and salinity and a large spike in
#	fluorescence was removed from file 0032.
#
#    The Transmissivity channel was removed because of frequent shifts in values during
#	casts and large variations between values during repeat casts.
#	The data are available, by request, from the chief scientist.
#
#    NOTE: While the Fluorescence:CTD data are expressed in concentration units, they
#	do not always compare well to extracted chlorophyll samples, particularly for
#	casts far from shore. It is recommended that users check extracted chlorophyll
#	values where available.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in Sea-Bird
#	Application Note #64-2, June 2012 revision (Sea-Bird_64-2_Jun2012.pdf), except 
#	that a small offset in the fit was allowed.
#
#    The Dissolved Oxygen sensor used in files 0001, 0002 and 0016 malfunctioned so the 
#	Oxygen:Dissolved:CTD channels were removed from those files.
#
#    The Oxygen:Dissolved:CTD sensor has a fairly long response time so data accuracy 
#	is not as high when it is in motion as it is during stops for bottles. This will be
#	especially true when vertical dissolved oxygen gradients are large. To get an estimate
#	of the accuracy of the Oxygen:Dissolved:CTD data during downcasts (after recalibration)
#	a rough comparison was made between downcast Oxygen:Dissolved:CTD data and upcast 
#	titrated samples. Some of the difference will be due to problems with flushing of 
#	Niskin bottles and/or analysis errors, so the following statement likely underestimates 
#	Oxygen:Dissolved:CTD accuracy.
#
#    Downcast (CTD files) Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.25 ml/l from 0 to 125 dbar.
#	±0.2 ml/l from 125 to 400 dbar.
#	±0.1 ml/l from 400 to 600 dbar.
#	±0.05 ml/l from 600 to 1500 dbar.
#	Low by up to 0.08 ml/l below 1500 dbar.
#
#    For details on the processing see document: 2017-001-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5--- --6-- ---7--- --8---
#!Pressu Temperat Salinity Sigma-t: Oxygen Oxyge Fluores PAR:  
#!re:CTD ure:CTD  :CTD     CTD      :Disso n:Dis cence:  CTD   
#!                                  lved:  solve CTD:          
#!                                  CTD:   d:CTD Seapoin       
#!                                  Volume :Mass t             
#!------ -------- -------- -------- ------ ----- ------- ------
#*END OF HEADER
     WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @F         data_max      @F         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     6  2   pressure                	long_name         pressure   positive      down   units         decibar    data_min      ?333333   data_max      @N   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      6  h   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      
     temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?,<   data_max      @]/w   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       6     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      
     salinity                	long_name         salinity   units         PSS-78     data_min      @@\j~#   data_max      @AI   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      6  <   salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      
 &T   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @/   data_max      @s        C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        6 3   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      
 i   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?(\)   data_max      ??|hs   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      6 w|   CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      
    PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       6    PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d      
 4   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min               data_max               C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     6    CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d      
 4   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( B\   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( B   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      )   data_max      )   C_format      %10d       B   latitude               	long_name         latitude   units         	degrees_N      data_min      @I ;'j   data_max      @I ;'j   C_format      %9.4f          B   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      bE   data_max      bE   C_format      %9.4f          B   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d        B   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min        e   data_max        e   C_format      %4d        B@F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      @F      ?333333@       @333333@      @      @      @      @       @"      @$333333@%      @*333333@+@0@1      @2      @3      @4      @5      @6@7      @8      @9      @:      @;      @<      @=      @>      @?@@@@     @A      @A     @B      @B     @C      @C     @D      @D     @D33333@E     @F      @F     @G@Gs33333@H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M@M     @N      @N     @O      @O     @O     @P`     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @Rl@R     @S      @S@     @S     @S@T      @T@     @T     @T     @U      @U@     @U     @U     @U33333@V333333@Vfffff@V     @W      @W@     @W     @W     @X      @X@     @Xl@Y@Y@     @Y     @Y@Z      @ZFfffff@Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\@]      @]@     @]     @]     @^      @^@     @^     @^     @^@_S33333@`      @`      @`@     @``     @`     @`     @`33333@`33333@a#33333@a<@a`     @a     @a     @a     @a     @b      @b@b<@b@b     @b     @b     @c      @c      @c@     @cS33333@cfffff@c     @d      @d      @d<@dfffff@d     @d     @e      @e      @e@     @e`     @e     @e     @efffff@f@f      @f@     @f`     @f     @f     @f     @f     @g      @g33333@gp     @g     @g     @g     @g     @h      @h      @h@     @hY@h陙@i      @i      @i@     @ifffff@i33333@j      @j      @j@     @jS33333@j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k33333@l	@l      @l@     @l`     @l     @l33333@l     @m@m      @mFfffff@m`     @m     @m     @m@m     @m@n      @n@     @n`     @n     @n     @n     @n     @o      @offfff@oc33333@o     @o     @o     @o     @p      @p     @p      @pD@pP     @p`     @pp     @p     @p     @p@pfffff@p     @p     @p     @q      @q     @qT@q`     @qp     @q     @q     @q     @q     @q     @q     @q@q     @qfffff@r     @r      @r0     @r@     @rK33333@r33333@r     @r     @r     @r     @r     @r@r陙@sfffff@s     @s      @s0     @s@     @sP     @s\@s@s     @s     @s     @s     @sfffff@t33333@t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t@t@t     @t     @t     @u      @u	@u!@u0     @u@     @uP     @u`     @up     @u     @u@u     @u     @u     @u     @u     @v      @v     @v@vA@vL@v`     @vp     @v     @v     @vfffff@v     @v     @v33333@v@v     @w      @w     @w      @w0     @w@     @wH     @wq@wfffff@w     @w     @w     @wə@wᙙ@w     @x      @x     @x!@x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x@x33333@x     @x     @x     @x@y@y      @y0     @y>fffff@yP     @y`     @yp     @y     @y     @y@yfffff@y     @y     @yfffff@z@z     @z      @z0     @z@     @zP     @z`     @zp     @z|@z33333@z     @z     @z     @z     @z     @z     @z@{fffff@{      @{+33333@{A@{P     @{`     @{p     @{     @{     @{     @{     @{     @{љ@{33333@|@|      @|0     @|@     @|P     @|`     @|p     @|~fffff@|     @|     @|     @|@}     @}      @}0     @}@     @}P     @}`     @}vfffff@}     @}     @}     @}@}33333@}     @}     @~      @~     @~      @~0     @~<@~p     @~     @~     @~@~@~     @~     @~     @~     @      @33333@1@@     @P     @`     @q@     @33333@     @     @     @񙙙@ @     @     @33333@(@0     @8     @@     @H     @P     @X     @\@rfffff@x     @     @     @     @     @     @     @     @     @     @     @     @     @ᙙ@     @     @     @      @     @33333@#33333@(     @0     @8     @@     @H     @L@W33333@`     @h     @p     @x     @~fffff@@     @     @     @     @     @     @     @     @     @     @噙@@     @      @     @     @     @!@(     @0     @8     @@     @H     @P     @Vfffff@l     @p     @t@     @     @     @     @     @@@     @     @     @     @     @     @@33333@     @      @(     @0     @8     @@     @H     @O33333@p@x     @     @     @     @     @     @     @33333@     @     @     @     @     @33333@      @     @     @33333@      @(     @8@@     @H     @P     @X     @`     @g33333@p     @x     @     @     @33333@     @     @     @     @     @     @     @     @33333@     @     @     @     @      @     @     @     @      @(     @0     @A@H     @O33333@X@`     @h     @o33333@x     @     @     @     @     @     @     @fffff@@33333@fffff@@     @     @     @     @     @@@#33333@(     @0     @8     @@     @H     @P     @T     @h@p     @x     @     @@     @fffff@     @     @     @     @     @     @33333@     @     @     @      @     @     @     @@&fffff@@     @H     @P     @X     @`     @h     @m@fffff@     @     @     @     @     @33333@33333@     @     @     @fffff@@      @     @     @     @@(@0     @5@C33333@H     @P     @X     @`     @h     @p     @w33333@33333@33333@fffff@     @     @     @     @     @     @͙@ᙙ@     @     @     @      @@fffff@)@0     @8     @@     @Ffffff@Rfffff@X     @`     @k33333@p     @x     @     @     @     @@@     @     @     @     @     @@@     @33333@     @     @      @     @
@     @#33333@&fffff@0     @8     @@     @H     @P     @X     @_33333@h     @nfffff@     @     @     @33333@@fffff@33333@     @     @     @     @     @     @@33333@     @     @      @(     @0     @8     @S33333@X     @`     @h     @p     @x     @     @@     @     @     @     @     @     @     @33333@     @     @     @fffff@@     @     @@+33333@0     @8     @@     @H     @Nfffff@Y@`     @k33333@p     @x     @     @     @     @     @     @fffff@@@     @     @     @     @     @     @      @     @fffff@      @(     @/33333@;33333@@     @H     @P     @X     @p@x     @     @     @     @     @@@     @ř@љ@     @     @     @     @fffff@fffff@     @     @     @@+33333@0     @8     @@     @H     @P     @X     @`     @ffffff@p     @x     @     @fffff@@     @@33333@     @     @     @     @     @     @@      @     @     @     @@*fffff@0     @8     @@@G33333@P     @X     @`     @h     @p     @w33333@     @     @     @     @     @     @@@     @     @     @fffff@     @     @      @     @     @     @33333@@ fffff@$     @(     @,     @0     @2@=33333@@     @D     @Ffffff@P     @T     @X     @\     @`     @d     @h     @jfffff@x     @|     @     @     @     @     @@33333@     @     @     @     @     @     @33333@fffff@     @Ǚ@fffff@     @     @fffff@fffff@     @     @     @      @     @@fffff@     @     @33333@@      @$     @(     @,     @.@8@<     @@     @D     @H     @L     @P     @R@\fffff@`     @d     @h     @l     @p     @r     @|fffff@33333@     @     @     @     @     @     @     @     @     @     @fffff@33333@     @     @     @     @     @Ǚ@     @י@     @     @     @     @     @fffff@     @     @     @      @     @     @     @     @@ @$     @(     @,     @0     @3@8fffff@@@D     @H     @L     @P     @T     @X     @\     @`     @bfffff@m33333@p     @t     @x     @|     @~@@     @     @     @     @     @33333@@     @     @     @@     @     @     @fffff@͙@     @     @33333@     @     @     @fffff@񙙙@33333@@      @     @     @     @     @     @33333@@%33333@(     @,     @0     @4     @8     @:fffff@A@D     @H     @L     @Tfffff@X     @\     @`     @d     @h     @k@x     @|     @     @     @     @     @@fffff@@     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @fffff@陙@     @     @     @     @     @      @@
33333@     @     @     @@$@(     @,     @0     @4     @8     @A@D     @H     @L     @P     @U@X     @[33333@dfffff@h     @l     @p     @t     @x     @|     @fffff@fffff@fffff@     @     @     @     @     @     @     @@fffff@33333@     @     @     @     @     @     @     @     @     @     @     @33333@	33333@     @     @     @     @     @@-33333@0     @4     @8     @:@E33333@H     @L     @P     @T     @X     @Zfffff@i33333@l     @p     @t     @x     @|     @~@@     @     @     @@33333@     @     @     @     @@     @     @     @     @     @     @fffff@33333@     @     @     @     @     @     @     @     @fffff@33333@      @     @     @     @     @     @@ @$     @(     @,     @0     @4     @8     @<     @@fffff@B@X     @\     @`     @bfffff@t@vfffff@|fffff@     @     @     @     @     @     @     @fffff@fffff@     @     @     @     @33333@     @     @@ٙ@     @     @     @     @     @     @fffff@33333@      @33333@fffff@
fffff@33333@     @     @     @      @$     @'@0@4     @8     @<     @@     @D     @F@Tfffff@X     @\     @`     @d     @h     @jfffff@xfffff@|     @     @     @     @33333@@     @     @     @fffff@fffff@@     @     @     @     @     @fffff@fffff@     @@     @     @     @     @     @     @󙙙@fffff@     @     @     @     @     @"     @$     @'33333@-33333@0     @2     @<fffff@@     @D     @H     @L     @P     @R@`@d     @h     @l     @p     @}@     @@33333@33333@33333@     @     @     @     @     @     @     @     @     @Ǚ@љ@     @     @     @33333@     @     @     @     @     @      @     @@@     @@(fffff@,     @0     @<@@     @D     @H     @L     @N@X@\     @e@h     @l     @p     @t     @x     @{@@     @     @     @33333@@     @     @     @     @     @33333@@     @     @     @     @     @     @     @33333@     @     @     @     @@@      @     @     @     @33333@@     @      @$     @(     @,     @0     @4     @6@Dfffff@H     @L     @P     @T     @X     @Zfffff@m33333@p     @t     @v@fffff@     @     @     @     @     @     @     @33333@     @     @     @˙@fffff@     @     @     @     @@fffff@     @      @     @     @     @     @     @     @33333@%33333@(     @,     @0     @4     @8     @<     @?@L@P     @T     @X     @\     @`     @dfffff@pfffff@t     @x     @|     @     @fffff@     @33333@     @     @     @     @     @     @fffff@fffff@     @     @     @     @     @     @     @33333@fffff@33333@     @     @     @     @     @     @fffff@fffff@     @     @     @     @     @ fffff@"fffff@(     @*fffff@0@4     @8     @;33333@Lfffff@P     @T     @V     @\fffff@`     @d     @h     @p     @t     @x     @|     @     @     @     @33333@fffff@     @     @@@     @     @     @     @     @     @     @     @     @     @     @     @     @񙙙@     @      @     @     @     @ @$     @(     @,     @133333@4     @8     @<     @@     @D     @H     @K@X     @\     @`     @d     @h     @l     @p     @t     @x     @z@@     @     @@@     @     @     @     @     @33333@@     @     @     @     @     @33333@@ݙ@     @     @     @33333@     @     @@     @     @     @     @33333@ @$     @(     @+33333@2     @4     @8     @<     @@     @D     @H     @L     @O@\@`     @d     @h     @l     @o@|@     @     @     @33333@@fffff@     @     @     @     @     @fffff@     @     @     @Ǚ@     @     @     @     @fffff@噙@     @     @     @     @     @     @      @33333@33333@@33333@      @$     @(     @,     @0     @4@933333@:     @@fffff@C33333@I33333@L     @N                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @W&@W>6z@V+J@V8YJ@Vaf@W@W@W@W@W      @X_F@XbM@XbM@Y+@Xe+@Y+@Y+@YJE@Yb}@Yb}@Yb}@Ye+a@Y>BZ@Y_o@Z6C@Zu%F@Zu%F@ZkP|@ZkP|@Z6C@W&@WO;d@WsPH@U*0@Qu@PbM@P*0U@QN;6@Q@Q4J@P{@P@QN;5@P$tT@Q_p@Q@Q_p@P`A7@Q@RnO@P$tT@P|@O\(@RsP@S*0U2@Sa@O@Stj~@Qhr @QR@QX@R:)y@F]cf@?˒:)@:~@<쿱[@=Vl!@;lC@;J#9@9(@6ȴ9X@6E@/O
M@0D@2{m@ A7K@a@N@JL@Q_@҉@'/W@@iDg8@h	ԕ@|@]cA@+I@z@\1&@SZ@M:@Hp:@GzH@GK]d@H@Dtj@>($x@<쿱[@<Q@:)_@8F@8)@8F@9D@=b@>"@@     @?@?@A7Kƨ@Ao hی@B@Q@^@vȴ9@C\N@Rm@]/w@\wkP@VR<6@L@9"`@t@
O;dZ@#x@2W@@%1@҈p;@6C@A [@xF@tj~@@\(@{s@r ě@eS@^ ѷY@WsPH@6}Vl@ A7K@X@
5Xy>@g8}@D@e+@Ϫ͟@2m\@حV@U@b}V@wkP@Vϫ@ڹZ@|@@o @˒:*@ NU@.H@$xG@\(@C%@p
(@l"h	ԕ@@Mj@$@҉@Zc@~$t@sPH@ae@R<64@B@4n@<쿱[@1iB@-
qv@wkP@T`d@͞@1&y@1.@fA@j~@Q@"wkQ@U=@	^5?}@YJ@ C@|hs@1@@Ձ$/@n.@&@s33333@Qhr @A [7@?$tS@>"@;m]@&x@&@n@Z@˒:*@Q@0U2a|@@1@حV@Ov_خ@kP|@`d@%1@A [@6@hr Ĝ@XPH@WsPH@TZ@=ڹZ@2-V@'8}H@=K^@zH@o i@a@N@	k~@KƧ@
W'@#S&@7Xe@0:~ @+Q@$@"h	ԕ@@@VϪ@2W@R<6@m\@pD@tSMj@uXy=@˒:)@PH@D@Z@fA@ԕ*1@T`d@eO@lC@!.I@E@Vϫ@Q@
=q@6@Ϫ͞@&@N;6@z^5?|@w+@u?|h@q-@n1@mB@dtSM@a@N@Vl!-@NT@KC%@GzH@B\(@=p
=@:G{@%S@҈p;@S@&@\(@E84@m\@#x@"`@-
@)@|@Vϫ@VϪ@ۋq
@`A7L@bM@~($x@@&I@Ňݗ@F]c@a@N@)^@ߤ?@D@0U2a|@L/{J@tSM@Q_@sP@˒:*@wKƧ@m\@`d8@Vt@MjOv@HK]c@C%2@@4m@:S&@6Fs@0D@&1.@iB@>BZ@sPH@&@0
)@y=c@@H@9Xb@ 4m9@쿱[@n.@m\@Z@-w1@'RT`@U=@/w@ؓtj@@4n@H˒@sg@g	@'@+a@TɆ@tSM@Z1@@4@.H@R<6@@N@kP|@%@%@:)z@-@@C@˒:)@~
(@}p
=@zG{@x}H@v_ح@t֡a@s33333@q@mhr!@j~"@i*0U2a@gfA@eu@bwkQ@a|Q@_vȴ9@^iB@\>@\]ce@\(\@\C,zx@\C,zx@\N;@\C,zx@[S@ZY@Y0
)@X_F@WXe,@WsPH@V@V@VϪ͟@W
=p@WO;d@W+j@XU@X_F@W>6z@TE@O
M;@L@FFs@En/@ES&@EQ@DS@C,zxl@Ao hی@?b}V@:C\@7Xe@5!R@3@)rGE@"}Vm@!'R@!@N@حV@?@ -
@iB@vȴ@>6z@=K@~($x@#@?@,zxl@ 4m9@GE85@VϪ@ڹ@ӎMj@@ěS@s@@S&@1@1&y@0
@TɅ@1@tj@n@4J@bM@'/W@(@&I@u%F
@~"@{~$@weں@tD@r{m@o@nt@kP{@ix@e+a@_Ft@\?@ZQ_@T,<@OAs@?@9Y}@3g	l@.1@,>B[@'/V@_o@4J@\(@
L/{@1&x@+I@$/@ݗ@@      @1@@iDg8@rGE@+a@(\@H@/{J#@ʌL_@ɅoiD@s@
L/@g8}@,zxl@C@XbM@W@O
M@@zxl"h@h	ԕ@ae@䎊r@u@S@_o@@@*0@nO@$tT@rGE9@C%@n/@u%F
@zC\@w+@x-
@xF]d@uY|@lVϪ@glC@cZ@_;dZ@ZY@UfA@O͞@Np:~@I@D2W@<64@9#w@74m@5?|h@+6z@!ae@%@-V@C,zx@L_@nO@
	 @
.2@
@
څݘ@
҈p:@
ΤT@
@
]cf@
n@
^5?|@
*0@
#@
4m9@
4m9@
}E@
}Vl!@
}!.H@
|Q@
vȴ9X@
jJL@
]cA @
Zc	@
W
=p@
Rp:@
Q_p@
L_@
J#9@
G)^@
A7Kƨ@
;dZ@
5sg@
+I^@
&L/{J@
$xF@
 ěT@
u"@
@
N;6@
L_@
&I@
{J#9@
 ѷX@m\@b}V@xl"h
@8Y@ۋq
@@e@5?|@/w@$@6@e+@;5X@8YK@<64@#w@3@B@@ae@[6@6C@$tS@nO@xF]@$/@%2@M:@M:@x-
@o4֡a@iDg8~@glC@hr Ĝ@iB@ix@jfB@glC@g8}H@_o@Yb}@Vaf@Vt@L/{J#@;5Xy@2m\@+6z@$?@"wkQ@!ae@!-w1@!-w1@Ov_خ@Q@@@N;6@!R<@p:@&I@M:@u%F
@.H@l"h	@Y|@@s@4֡a@O;@ᰉ'@lC@S@d8@Gz@ᰉ'R@|Q@҈p@
qu@e@C,@]ce@՛=K@R@H@+@/{J#@ɺ^5?}@C@?@O
M@6z@\)@Xy=@e+a@$/@=p
@S&@:S@qu!S@lVϪ@jfB@hۋq
@eO
@be+@Y|@L_@I@;dZ@0 ě@(@&x@!.H@-V@6C@R<6@'/@ hۋq@
#x@
>B@
"`@
	k~@
ȴ9X@
{m@
.2@
"h	ԕ@
ᰉ'@
,<@
䎊qj@
u!@
ߤ?@
҈p@
ce@
ҽ<64@
@
ȴ9Xb@
E84@
Ƨ-@
@
5Xy@
4m@
m8@
I^@
U=@
$/@
tj~@
S&@
:)y@
$tT@
)^@
bM@
-
q@
~($x@
'RTa@
ݗ+@
7KƧ@
ԕ*@
n/@
nP@
IQ@
~"@
|#x@
|hr@
~\N<@
 ѷ@
~"@
nt@
h@
fA@
cZ@
a|Q@
\]ce@
Y|@
Sa@O@
U2a|@
@6@
&L/{J@
 'RT`@
ᰉ@
	'RTa@
n/@
@	E@	73@	䎊q@	-V@	"h	ԕ@	B@	x@	Q@	A@	M@	
qu@	>@	Q_@	
=p@	т@	̘_@	E84@	C@	@	64@	XbM@	&@	
=p@	
=p@	xF@	?@	?@	
=p@	F
L0@	tSM@	@@	-
q@	+I@	{J#9@	rGE85@	jg	@	ffffff@	bC,@	WsPH@	U2a|@	TE@	T*1@	P`A7@	M%@	K)^	@	K:)z@	H@	F]cf@	A@	7rG@	2m\@	.1@	,1&y@	&x@	!ae@	[@	vȴ@	+j@	bM@	@	o @	o @	\(@	
(@	
@	ߤ?@	
ڹY@	ݗ+@	ݗ@.H@PH@rGE8@j~@C,z@>@D*@>6z@t@Ʌoi@ѷX@]cA@@Z@}H@r@a@@@xF@.H@Q@PH@O;d@R<6@*0@L_@tj@@N@qu"@7KƧ@@{J#9@hۋq@.H@}!.H@~($x@u%F
@I^5@tj~@aGz@\(\@Y+@UϪ͞@SZ@SZ@SZ@Ov_ح@Ks@Gy@<Z@;/V@8YJ@.zG@#9@ 'RT`@ 'RT`@vȴ9@U=@1&@"h	ԕ@qu!@vȴ@kP|@6C@@@u%@}H@@@ 4m9@H˒@F@!R@A [@حV@>@c	@ڹY@+@s@]cA@@\(@64@dZ@.H@1&@,<@҉@=p
@K]d@$/@~"@{m]@xl"h	@tD@o@kP{@b}Vm@\?@ZY@Y|@XD*@XD*@Np:~@KƧ@G@@F?@C\N@C$@B@8)@0'RT@/v@,<쿱@+I^@*d7@)^@($xG@&x@%@O;d@!.H@{m@A [@䎊qj@M@҈p;@ ѷY@]ce@E@)^	@s@@S&@}H@C-@}H@E@3@&x@zxl"@U=@9@,=@zG@bM@qiC@@     @IQ@|hr@x-
@w+@x73@wkP@v+jg@sMjO@cZ@ae@^҈p;@[$@XbM@Vaf@T*1@T,<@SMj@QN;5@P|@NT@M@Ov_ح@M:@JW'@F
L/@D2W@B\(@A@>ߤ?@9#w@5'0@49XbN@4J@1[W>6@/{J#:@-
qv@(TɅ@(TɅ@(TɅ@'RT`e@&@!ae@,<@ݗ+k@~($x@>B@"`@F@rGE@	@Q_@Ϫ͟@t@Ʌoi@2a|@E@2a|@E@@&@䎊@N;5@m@Ϫ͞@5Xy>@)^	@ɺ^5?}@ȴ9Xb@o i@p
=@֡a@o@Vϫ@<쿱@lD@S@9@1&@u%F@,<@_o@Xe,@@Xe,@Xe,@R<6@zG@zG@*0U2@-
q@I^5?@C%@qiC@p:@ݗ@ѷX@~$t@}E@|PH@x73@w+@w1@sMjO@p@d%1@]+j@YJE@RT`d@O
M;@OAs@M5Xy>@JD@JL_@IoiD@F-@Dg8}@ATɅo@>vȴ9X@<64@:S&@8YJ@333333@12W@0 ě@0 ě@/O
M@,>B[@+I^@*0U2a|@#n.3@"`A@!R<6@ [6@qu!@$/@ݗ+k@hr @$tT@C%@	ԕ*@	7KƧ@p:@+I@@E@F]d@_ح@iB@8Y@!-w@!-w@g	@A [@ޞ@>@y=c@m@_o @̘_@n@*0@&IR@n@|hs@p
=@)y@W@2W@ ě@<쿱@^@ěT@1&@qu!@tj@@ᰉ@Fs@*0U2@@N@n@@-
q@C%@k~(@ݗ@IQ@~($x@}!.H@|?@{~$@rGE85@kC]@gfA@cS@^iB@^ ѷY@]cA @]/w@UϪ͞@LcA \@Gy@B\(@?H˒:@>ߤ?@>BZc @=<64@:S&@7Xe@6}Vl@6E@333333@0 ě@)lD@%S@#
=p@!ae@쿱[W@!-w1@}H@S@O;d@sh@҉@u@
=p
@#@ݗ+@n/@@4n@o hی@:S@ ѷX@"@C\@ȴ9X@SMj@
=q@!-w@C,z@g	@r Ĝ@+a@ᰉ'R@ߤ?@5?|@/w@]ce@]ce@]ce@>@1'@@2a|@*0U@#9@Q@ȴ9Xb@@]cf@n@@@C@K]@#w@2W@O
M@>B[@1@RT`e@%@wkP@[@wkP@e+a@:)y@	 @p:@ѷX@xl"h	@tj~@tD@aGz@^@QN;5@M@K]cA@J#9@G)^@E84֡@B74@As@A [7@C$@A [7@=b@;dZ@6}Vl@)*0U2a@#S&@[@1&@,<@$tS@Ov_@L_@sP@Mj@@L_@C%@JM@o hی@s@#@GE85@A [@:~ @@O;@!-w@P{@c	@VϪ@JL@Dg8~@r Ĝ@,<@`A7L@@N@حV@o@/w@"`B@D*@ק&@Ϫ͞@E@ԕ*1@@&@҈p:@As@ɺ^5?}@y@Zc@TɅo@
(@BZc @K]@A@~@^5?|@D@#w@C-@m\@a|Q@&x@zG@U=@-@xF@n.3@R<6@u@,=@Ov_خ@,=@S@@PH@L_@:)y@nO@Mj@!R<@@eO@+I@ݗ@tj@:S@b}V@z>B@v_ح@u!.@uY|@u%F
L@poiDg8@mhr!@kC]@cS@`A7K@_o@_Ft@_;dZ@^҈p;@[6@Z1'@Zݘ@Zݘ@ZQ_@WsPH@U2a|@T`d@SMj@RT`d@R䎊@R䎊@UϪ͞@U2a|@T`d@SMj@Rm@P|@Np:~@L@HK]c@E@Ca@N@?|hs@=K]@;5Xy@>
(@<64@74m@4m8@2m\@2a|Q@.zG@',@#
=p@#n.3@"3@!R<6@ 	k@ [6@쿱[W@}H@,<@@R<6@$/@*0U2@@L_@1&x@YJ@$/@I^5@($x@PH@s@(@-
@73@!.I@_ح@1@_ح@+jg@!.@Y|@SMj@8Y@C]@fB@ۋq
@	k@A@Z1@C,@Gz@?@Ϫ͞@䎊@N;5@ѷX@т@
M;@jOv@)^	@ʌL_@@@K]c@ěS@Zc@6@Z@Q@4K@}Vl@3@ᰊ@{J#:@B@w1@0U2a|@IQ@u@tSM@tSM@wk@3@-w1@IQ@$/@rGE9@ ѷ@@4n@$/@hۋq@.H@}E@~($x@~($x@|?@zG{@sg@m8Y@iB@gfA@ffffff@c	@_?@]cA @\?@\?@\N;@\>@\N;@ZY@W>6z@QR@N_o @K]cA@JW'@J#9@I^5?}@J#9@H9Xb@GE84@Ca@N@A@@NU@<Z@;dZ@9D@6E@5?|h@4֡a@2m\@1o@/r@-U=@,>B[@,q@,q@*0
@Q@+J@҉@@@@ߤ?@!R<@҈@'/@C%@
L/{@	 ѷ@1&x@eO@
qiC@
=p
@u%F@@o h@n.@ ?@ G{@ F@ 	k~@ 䎊q@ GE85@ D@ c	@ C@ Q@ B@ fffff@ @N@ ҈p;@ ڹY@ +@ t@ &@ |@ v_ح@ H@ v_ح@ 
M;@ @ ɺ^5?}@ )^@ 
L/@ m\@ *0@ @ 6@ 6z@ Y}@ )@ }H@ a|Q@ ͞&@ d7@ ^@ &@ TɆ@ wk@ S&@ 9@ xF@ S&@ -w1@ !-w1@ Ov_خ@ =K^@ @ tj@ PH@ tj@ $tS@ sh@ @ sP@ hr @ @ qi@ Vu@ o @ \(@ Vu@ @ qu"@ ҈@ ڹY@ L/{@ p:@ @ IQ@ {~$@ vȴ9X@ u%F
L@ sg@ r䎊q@ pD@ o hۋ@ nO;@ iB@ g	k@ f1.@ eO
@ ceO@ aGz@ ^҈p;@ \N;@ V8YJ@ QR@ P{@ P*0U@ O;dZ@ KƧ@ JD@ IQ@ H@ H˒:*@ H@ Fs@ E84֡@ C@ As@ @C@ @NU@ >BZc @ =b@ =p
=@ =K]@ ;5Xy@ ;dZ@ ;/V@ <64@ ;/V@ :^5?|@ 9Y}@ 8Q@ 7KƧ@ 1o@ 0{@ 0 ě@ /O
M@ -U=@ -V@ -V@ -V@ +6z@ +I^@ )lD@ 'RT`e@ $tSM@ !R<6@ tj@ O;d@ R<6@ Ov_@ Ov_@ ݗ+k@ :)y@ rGE9@ !R<@ 
M:@ 
qu"@ 	 ѷ@ ݗ+@ $/@ S&@ ?@ ?@ ?$tS?>B?-
?C\?!-w2?MjO?l?g	?,<                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @@\#@@\C@@\C@@\#@@\#@@\?@@\?@@\C@@\C@@\#      @@\?@@\?@@\?@@\#@@\C@@\#@@\C@@\qj@@\C@@\#@@\C@@\C@@\#@@\#@@\qj@@\C@@\C@@\C@@\C@@\#@@\zG@@\zG@@\o h@@\~($x@@\wkP@@\wkP@@\tSM@@\zG@@\~($x@@\tSM@@\zG@@\~($x@@\zG@@\wkP@@\wkP@@\wkP@@\zG@@\~($x@@\zG@@\tSM@@\tSM@@\tSM@@\wkP@@\wkP@@\q@@\m8@@\tSM@@\zG@@\wkP@@\zG@@\q@@\wkP@@\tSM@@\q@@\j~#@@\tSM@@\tSM@@\tSM@@\tSM@@\o h@@\~($x@@\q@@\zG@@\o h@@\zG@@\o h@@\_@@\*1@@\N;@@\qj@@\zG@@\C@@\N;@@\*1@@\_@@\S@@\1&@@\3@@\*1@@\zG@@\zG@@\tSM@@\j~#@@\j~#@@\#@@\S@@\_@@\*1@@\qj@@\N;@@\C@@\_@@\3@@\[W?@@\Z@@\JM@@\D@@]K]@@]\@@](@@]L_@@`@@q*0U2a@@@@/V@@+J@@w1@@eں@@ݘ@@Vϫ@@m8@@ش9Xb@@x@@ڶ}Vm@@ߤ@@@wkP@@ܬ1&@@Z@@5Xy>@@4֡a@@߮zH@@:~ @@ව4m@@rGE@@JE@@'RTa@@Zc@@⟾vȴ@@74@@tj~@@J@@wkP@@3@@7@@D@@hr@@䲕@@g	l@@=K^@@m\@@qiC@@ⅇݘ@@Q@@JM@@4K@@"@@+I@@+I@@+I@@H˒:@@
M;@@@@af@@,<@@椨T@@+I@@;dZ@@_F@@NU@@73@@A7K@@}H@@+j@@$xG@@-
q@@@@-@@حV@@r@@|hs@@eں@@H˒:@@˒:)@@@@@@,<@@%2@@C]@@6@@m]@@a@O@@*0U2@@*0U2@@*0U2@@달q@@@@g	l@@,zxl@@u%@@ ѷ@@sP@@䎊q@@C%@@Z@@&@@&@@)^	@@PH@@)^	@@m\@@74@@'/@@s@@s@@C,z@@PH@@@N@@F]c@@E@@@@빌~($@@믷@@q@@a@@@@@|@@\N@@?@@q@@섵?@@C@@V@@+j@@z@@1@@1@@8}H@@>6z@@{J#:@@!-w1@@8}H@@KƧ@@YJ@@Ov_خ@@
(@@+jg@@H@@m\@@d8@@TɅo@@^5?}@@"`@@R@@-@@=p
@@d7@@a|Q@@Zc@@{m@@~"@@qiC@@G{@@䎊q@@G{@@҉@@a@N@@qu!@@qu!@@Q@@:)z@@:)z@@a@O@@
=p@@tj@@?@@I^5?@@]ce@@q@@#@@쿱[@@:@@(@@/w@@5Xy>@@O;dZ@@$/@@@@8Y@@b@@
qv@@ ѷY@@.2@@H@@_ح@@p:~@@O;@@"@@'/W@@.H@@.H@@>6z@@E84@@_o@@_o@@˒:)@@rG@@Vϫ@@	ԕ+@@u!@@|@@-
@@ѷX@@@@ۋq
@@`A7@@p:@@)^@@PH@@@@-w1@@A [@@TɅo@@x@@2W@@@@Y}@@.H@@s@@lD@@n@@#9@@=p
@@nO@@wkQ@@L/{@@wkQ@@C,z@@U=@@5Xy@@Q@@҈@@1&y@@L_@@7@@u"@@:@@m\@@!R@@v@@O
@@+j@@+j@@Xy=@@U=@@U=@@-V@@\(@@4K@@1.@@8YJ@@Vu@@qi@@$t@@af@@m\@@m\@@@@'/W@@E84@@\(@@&@@͞@@䎊r@A 1&x@A Xy=@A 4m@A C@A#w@A7KƧ@AXbM@Ao hی@Ao@An.@AB@A'R@A@A@AN;6@A>BZ@An@A)y@A=p
@Ad7@A0
@A<64@AC,@A҉@A/V@Ag	l@AxF]@AeO@Aq@A҈@AL_@AM:@Ag8}@AY|@Ap
=@Aw1@A$/@A+j@Ash@A8Y@Aᰉ@Ap:~@Aaf@A2X@At@AXe,@A$tS@AkP@A-V@A?@A[W>@A&@Ar@AحV@A䎊r@A@ANU@AoiDg8@An@A-
@A@@A	@A	0
)@A	XbM@A	@A
s@A
0U2a|@A
Q_@A
u%F
@A
S&@A
fB@A
74@AI^@Au%@A&@AeO@A@Am]@AE@A~($@AƧ@A@Atj@A/{J#@AI^5?@Aj~#@Ao h@AC@A3@A1&@AZ@AZ@A
K]@A
2a|@A
B@A
S&@A
zxl"h@A
!R@AOv_@AE@As@A$t@A@Aߤ?@A!-w1@AiDg8@Aeں@A&@AkP@A?@A͞@Ar@Ao @A@@A ě@A4m9@AD*@Al"h	@A'RT@A@@ArGE@A#w@A0
)@A7KƧ@AGz@AQ@ATɅo@Ae+a@Ax@AB@A_o@Ae@Au%F@A1'@A-V@A6C@A=p
@AJL@AZc@Ad7@AqiC@Ap:@Aᰊ@AS&@AS&@A@AG{@AD@A&@A6z@A6z@A@N@AP{@A@A$@Awk@Am]@Aa@@A҈@A1&y@A"h	ԕ@A%1@AC,zx@Am8@AzG@A~($x@A?@AɅoi@AE@A'0@Au@Aqu"@AB@AL_@Aw1@AE@Au@AH@AiB@A}Vl@A@Aaf@Aߤ?@AϪ͟@AXe,@AkP@Ar@A3@A@A@A+@A+@A@@A1&x@AU2a|@AQ@AQ@A_F@A|@An@A˒:*@A@A@A4m@A@APH@A$/@A	k~@A@N@A#w@ADg8~@A^@AoiD@An.@AB@A'R@A^5?}@A@A2W@Aᰉ'@A-@A.H@An@AOv`@A&IR@A1'@A#9@A0U2a|@Ad7@A@4@AwkQ@Ag	@AW@AG{@AC,@Ac	@Am@Am\@A҉@A"`B@A6z@AZ@Ag	l@An.3@A@A@Aa@O@A%2@Atj@A/{J#@Am8@Am8@AcA \@Ao h@A?@A1&@A@A֡a@A>B[@AZ@A֡a@AZ@A:@A/w@A84֡@AIQ@AL_@AY|@AVl!@A\@Ap
=@A$/@Ahr!@AU=@A@A\(@Ab@Aڹ@A4K@A($x@A+jg@A8YJ@AE@A\N<@A'@AQ@AA@AMj@A@A@A,@A.H@A8}H@A8}H@A{J#:@A;dZ@A @A bM@A }H@A *0@A >BZc@A :~ @A u!@A {@A )^@A `A7@A 4֡b@A 	k@A!JE@A!ae@A!@A!|@A!o@A"n@A"䎊@A"1'@A"䎊@A")y@A"=p
@A"Q_@A"{m@A"L_@A"<64@A"sP@A"c	@A"m@A#I^@A#s@A#	@A#)^	@A#S@A#~$@A#q@A#Mj@A#:)z@A#A@A#*0U2@A#~($@A#5Xy@A#Q@A#A [@A#@A$n.@A$ߤ@@A$ߤ@@A$1&y@A$L_@A$C,zx@A$`d@A$?@A$#@A$*1@A$_@A$@A$[W?@A$Z@A$JM@A%Q@A%O;dZ@A%\@A%`A7L@A%m\@A%m\@A%sg@A%w1@A%zxl"h@A%O
@A%v@A%U=@A%1@A%-V@A%@A%@A%
qv@A%S@A%oiDg@A%oiDg@A%ᰉ@A%
qv@A%oiDg@A&BZc @A&Ov_خ@A&\N<@A&p:~@A&vȴ9X@A&}Vl@A&IQ@A&@A&O;@A&x@A'As@A'O
M@A'lC@A'-V@A'3@A'r@A'@A'@A'-@A'rGE9@A(F]d@A(	ԕ+@A(@A(bM@A(6@A('RT`@A(-
q@A(73@A(H@A(Q@A(y=c@A(n@A(tj@A(9Xb@A()@A(ěT@A()^@A)@A)=b@A)0
)@A)0
)@A)0
)@A)-w1@A)4J@A)-w1@A)-w1@A)XbM@A)rGE8@A)o@A)n.@A)e@A)lD@A*u%F@A*1'@A*6C@A*@4n@A*GE85@A*GE85@A*Q_@A*a|Q@A*h	ԕ@A*h	ԕ@A*{m@A*~"@A*S&@A* ě@A*@A*͞&@A*`A@A*G{@A*C,@A+S&@A+nP@A+9@A+W>6z@A+Z@A+Z@A+a@N@A+jf@A+qu!@A+tj~@A+xF]@A+Q@A+Mj@A+:)z@A+*0U2@A+~($@A+a@O@A+a@@A+C]@A,/{J#@A,9XbN@A,9XbN@A,<쿱@A,<쿱@A,?@A,VϪ@A,wkP@A,#@A,TɆ@A,Z@A,?@A,>B[@A,Z@A,Z@A,e@A,>@A-K]@A-V@A-'0@A-V@A-*0@A-*0@A-+a@A-5Xy>@A-<64@A-<64@A-IQ@A-B@A-O;dZ@A-S&@A-F
L0@A-IQ@A-p
=@A-@A-\(@A-cA @A-b@A-,=@A-S@A-S@A-oiDg@A-ڹ@A.
L/@A..2@A..2@A.5?|@A._ح@A.p:~@A.%@A.}Vl@A.IQ@A.}Vl@A.qi@A.vȴ9X@A.$t@A.$t@A.Fs@A.Fs@A.O;@A.Fs@A.$t@A.Q@A.A@A.+@A.C-@A.@A/
=p@A/4֡a@A/E84@A/H˒:@A/RT`e@A/RT`e@A/kP@A/ݗ+@A/@A/kP@A/͞@A/r@A/3@A0F]d@A0 ě@A0$xG@A0:~ @A0NU@A0Q@A0U2a|@A0u!@A0n@A0'RT@A0@A0U@A0TɅ@A0F@A0@A0C@A04֡b@A0\)@A0`A7@A1@N@A1_p@A10
)@A1-w1@A17KƧ@A1:S@A1A [@A1e+a@A1|Q@A1b}@A1~($@A1~($@A1@A1R<6@A1@A1l@A1D@A1o@A23@A2C\@A2T`d@A2ݘ@A2ᰊ@A2S&@A2ᰊ@A2wkQ@A2Y@A2sP@A2fB@A2~@A3҉@A3s@A3C,z@A3s@A3"`B@A3&@A333333@A3@N@A3C%@A3a@N@A3qu!@A3:)z@A3ߤ@A3@A35Xy@A3a@@A3|@A3lC@A3A [@A3@A3A [@A3@A3@A4n.@A464@A4<쿱@A4?@A4M:@A4VϪ@A4`d@A4j~#@A4j~#@A4g8}@A4wkP@A4tSM@A4zG@A4?@A4?@A4?@A4N;@A4S@A43@A4TɆ@A41&@A4?@A4@A4֡a@A4>B[@A4/@A4u"@A4JM@A4e@A5:@A5V@A5V@A5'0@A5V@A5Q@A5/w@A5F
L0@A5Y|@A5+j@A5+j@A5@A58YK@A5?@A6_o @A6u@A6zG@A6u@A6@A6u@A6u@A6@A6Ov_@A6!R<@A6$/@A6.2@A6.2@A61.@A68YJ@A6?@A6BZc @A6L/{J@A6R<6@A6l!-@A6qi@A6Fs@A6,<@A6@A66z@A6&I@A6&I@A6Ϫ͟@A6C-@A6C-@A61@A6쿱[W@A6Mj@A6x@A6x@A6Mj@A6Fs@A6"@A6!.I@A7
M;@A7)^@A7v@A7v@A7!-w1@A7.H@A7As@A7E84@A7H˒:@A7RT`e@A7Xe,@A7Xe,@A7Xe,@A7lC@A7y@A7@A7[W>@A7o @A7@A7@A7حV@A7@@A7rG@A7-@A7+j@A7#@A8	ԕ+@A8bM@A86@A8 ě@A8*0@A84m9@A8A7K@A8H@A8K]c@A8Q@A8Q@A8[6@A8hۋq@A8l"h	@A8˒:*@A8˒:*@A8YJ@A8'RT@A8@A8U@A8{@A89Xb@A84m@A8F@A8F@A8D@A8F@A8ۋq
@A8C@A8PH@A9rGE@A9@N@A9=b@A9=b@A94J@A94J@A9:S@A9TɅo@A9hr @A9hr @A9oiD@A9R<6@A9l@A9'R@A9'R@A9_o@A9ԕ*@A9"`@A9@A9ᰉ'@A9@A:s@A:s@A:s@A:䎊@A:&IR@A:JL@A:Q_@A:T`d@A:h	ԕ@A:d7@A:h	ԕ@A:nO@A:xl"h
@A:u%F
@A:u%F
@A:ݘ@A:L_@A:wkQ@A:0
@A:@A:<64@A:)_@A:)_@A:W@A:W@A: ѷ@A;I^@A;'/@A;PH@A;/V@A;33333@A;/V@A;6z@A;J#9@A;dZ@A;g	l@A;qu!@A;@A;Q@A;eO@A;$@A;wk@A;*0U2@A;*0U2@A;q@A;@A;6@A;ݗ+k@A;g@A;C]@A;$@A<n.@A<1&y@A<xF@A<ߤ@@A<Q@A<tj@A<"h	ԕ@A<(\@A<I^5?@A<I^5?@A<M:@A<PH@A<`d@A<]ce@A<`d@A<j~#@A<q@A<~($x@A<#@A<N;@A<C@A<S@A<S@A<S@A<3@A<?@A<#x@A<j~@A<[W?@A<7@A<Ʌoi@A<Ʌoi@A<Ʌoi@A<Ʌoi@A<*0@A<֡a@A<u"@A<Z@A<e@A<E@A<E@A<E@A=o i@A<>@A=o i@A=u@A=qu"@A=2a|@A=?|h@A=F
L0@A=IQ@A=O;dZ@A=\@A=jOv@A=m\@A=jOv@A=m\@A=w1@A=ݗ@A=@A=-V@A=cA @A=?@A=,=@A=ᰉ@A>!R<@A>+jg@A>R<6@A>YJ@A>c	@A>_ح@A>l!-@A>p:~@A>z@A>vȴ9X@A>%@A>IQ@A>@A>Fs@A>Fs@A>,<@A>@A>A@A>C-@A>x@A>"@A? hۋ@A? hۋ@A>!.I@A?@A?@A?Xe@A?v@A?!-w1@A?.H@A?As@A?U=@A?iDg8@A?v_ح@A?sPH@A?sPH@A?v_ح@A?|hs@A?{J#:@A?	@A?4m@A?&@A?@A?ݗ+@A?ݗ+@A?kP@A?	k@A?[W>@A?3@A?3@A?vȴ9@A?o @A?˒:)@A?+@A?;dZ@A?;dZ@A?@@A?;dZ@A?@@A?@@A?+j@A@
qu@A@bM@A@ ě@A@$xG@A@1&x@A@:~ @A@1&x@A@>BZc@A@D*@A@H@A@H@A@NU@A@Q@A@eO@A@oiDg8@A@oiDg8@A@y=c@A@n@A@-
@A@@A@-
@A@u%F@A@U@A@d8@A@d8@A@d8@A@4m@A@)@A@p:@A@)^@A@D@A@p:@A@e+@A@@A@@A@	k@A@PH@AA ѷ@AA	k~@AArGE@AA@N@AA-w1@AA:S@AA7KƧ@AA7KƧ@AA7KƧ@AATɅo@AAQ@AATɅo@AAu!S@AA@AA7Kƨ@AA~($@AA7Kƨ@AA~($@AA@AA@AA@AAR<6@AAu@AA(@AAB@AA'R@AA|@AA^5?}@AA^5?}@AA@AA'R@AAX@AAX@AA^5?}@AAD@AA2W@AA_o@AAN;6@AA@AA@AA-@ABn@AB	 @AB@ABs@ABe+@AB#9@AB-V@AB0U2a|@AB6C@ABC\@ABa|Q@ABqiC@ABkP|@ABnO@ABqiC@ABxl"h
@ABu%F
@AB~"@ABݘ@AB\(@ABwkQ@ABS&@AB@ABY@ABn@AB͞&@AB,<@AB ѷ@AB,<@ABD@ABm@ABm\@ACI^@ACI^@ACu%@ACu%@AC'/@ACs@ACnP@AC'/@ACnP@ACs@ACs@ACC,z@AC)^	@AC6z@AC9@ACC%@ACJ#9@ACMjO@ACZ@ACW>6z@ACdZ@ACtj~@ACq@AC:)z@AC$@ACMj@ACA@ACS@ACq@ACm]@AC@ACm]@ACE@AC6@AC5Xy@AC@AC5Xy@ACݗ+k@ACC]@AC$@ACg@ACs@ADn.@AD1&y@ADߤ@@ADxF@AD(\@AD9XbN@AD?@AD<쿱@AD?@ADFs@ADI^5?@ADPH@ADSMj@ADj~#@AD#@ADzxl"@AD@AD@AD@AD#x@AD[W?@AD[W?@AD7@AD?@AD?@AD֡a@AD@ADhr@ADe@AD>@AE'0@AEu@AEqu"@AE!.H@AEQ@AE!.H@AEQ@AEQ@AE%F
L@AE5Xy>@AES&@AEY|@AEfA@AE`A7L@AEce@AEjOv@AE\@AEp
=@AEsg@AE$/@AEM:@AEڹZ@AEhr!@AEO
@AEv@AE1@AE-V@AE-V@AEn/@AE\(@AEcA @AEϪ͞@AE8YK@AE
qv@AE
qv@AES@AF_o @AF!R<@AF$/@AF.2@AF.2@AF($x@AF5?|@AF8YJ@AFBZc @AFBZc @AFE@AFE@AFH@AFL/{J@AFOv_خ@AFE@AFH@AFVu@AFVu@AF_ح@AFfffff@AFvȴ9X@AF}Vl@AF%@AF%@AF@AFO;@AF,<@AF-@AF}Vl@AF2X@AF'@AF&I@AFA@AF+@AF1@AF쿱[W@AF!.I@AG hۋ@AG@AG
=p@AG@AG
M;@AG)^@AG)^@AG!-w1@AG+I@AG'/W@AG+I@AG.H@AG>6z@AGAs@AGE84@AGRT`e@AGRT`e@AG_o@AGiDg8@AG	@AG|hs@AG{J#:@AG&@AGkP@AG-V@AGkP@AGkP@AG$tS@AG$tS@AG?@AGzH@AG[W>@AG3@AG/V@AG@AGvȴ9@AG@AG˒:)@AG˒:)@AG+@AGfA@AG@AG;dZ@AG@AGrG@AGVϫ@AG@@AG@AGrG@AG@@AG@AG-@AG䎊r@AGrGE9@AH	ԕ+@AH*0U@AH$xG@AH4m9@AH73@AH4m9@AH73@AH:~ @AHK]c@AHH@AH_F@AH_F@AH_F@AHbM@AHoiDg8@AHu!@AH|@AH@AHu%F@AH
=q@AH@AH@AH{@AH9Xb@AH)@AH)@AHTɅ@AH
(@AHTɅ@AH@@AH)^@AHp:@AHF@AHۋq
@AHۋq
@AHe+@AHe+@AH`A7@AH@AH{@AH4֡b@AH4֡b@AH\)@AH\)@AH	k@AH\)@AH	k@AI	k~@AI@N@AI@AI@N@AI+@AI@AI [7@AI#w@AI#w@AI&x@AI#w@AI&x@AI4J@AI=b@AIDg8~@AI^@AI^@AIe+a@AIe+a@AIe+a@AIo hی@AIrGE8@AI|Q@AIb}@AI@AI@AIR<6@AIu@AI@AI@AI'RTa@AI'RTa@AI(@AI'R@AIX@AI|@AI'R@AID@AI2W@AI@AIo@AI                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @r     @rfffff@r     @r陙@r     @r     @rfffff@rfffff@rfffff@r           @rfffff@rfffff@r񙙙@rfffff@r33333@r     @r@r33333@r@r     @r     @r33333@rfffff@r     @r@r33333@r@r@rfffff@r33333@r@r陙@rfffff@r33333@r     @r     @r     @r@r33333@r񙙙@r     @r@r33333@r     @rfffff@rfffff@r陙@r     @rfffff@rfffff@r@r񙙙@r     @rfffff@r񙙙@r@r33333@r33333@r@r33333@r@r33333@r     @r33333@rᙙ@r@r陙@r@rfffff@r33333@r@r@r33333@r33333@r     @r     @r@r陙@r     @r33333@r     @r񙙙@r@s      @r@rfffff@r33333@r33333@r33333@r@r񙙙@r@r@s      @s     @s      @s      @s      @s      @r񙙙@r@r@r@r33333@r@rfffff@r@r     @r33333@r@rfffff@r     @q陙@pљ@o@m33333@l@     @kFfffff@j@jS33333@j陙@jVfffff@i     @i<@h@h陙@h     @ifffff@i&fffff@h陙@h@h@h@h33333@h     @h33333@hvfffff@hl@hi@h@h	@g陙@g33333@g33333@g@g@g33333@g     @g33333@g     @g@g     @g#33333@f@fc33333@e@e@ey@effffff@ec33333@ep     @e     @efffff@e     @e`     @e#33333@dfffff@d@d@d     @dl@dffffff@ds33333@dc33333@dL@d333333@d&fffff@d      @d      @d&fffff@d)@d      @c33333@c33333@cC33333@b33333@a33333@a33333@a|@as33333@avfffff@a33333@afffff@a33333@ac33333@a@     @afffff@a@afffff@`@`@`@`fffff@`     @`fffff@`fffff@`fffff@`@`fffff@`33333@`y@`<@`      @`	@_@_@_@_fffff@_33333@_&fffff@^@^@^     @^Ffffff@^      @^      @]@]ٙ@]     @]@     @]fffff@\33333@\y@\9@\33333@\&fffff@[33333@[fffff@[33333@[s33333@[`     @[S33333@[y@[S33333@[33333@Zfffff@Z33333@Zl@ZFfffff@Z@Yٙ@Yfffff@Y     @Yffffff@YL@YFfffff@Y9@Y&fffff@Y33333@Y      @Xfffff@X@Xfffff@X@X@X@Xl@X,@X      @Wfffff@Wfffff@W     @W@W     @W@Wl@WL@W9@W@W33333@V@V     @V33333@Vy@Vffffff@VS33333@V`     @V9@V33333@Vfffff@V      @U33333@Uٙ@Ufffff@U     @U     @U33333@Uffffff@UFfffff@U9@U      @U@U      @Ufffff@T33333@T33333@T@T33333@T@T33333@Tffffff@T&fffff@Sfffff@S     @S33333@Sy@S`     @SS33333@SL@S9@S&fffff@Sfffff@R33333@Rٙ@R     @R33333@R@R@R@R@Rs33333@Rs33333@RY@R@     @R&fffff@R33333@R33333@Q@Qfffff@Ql@Qffffff@Qffffff@Qffffff@Q333333@Q      @P@P@Py@Pffffff@Pl@Pffffff@Pffffff@Pl@Py@P`     @Pl@PS33333@P@     @P,@P&fffff@P@Pfffff@Offfff@O     @O     @O33333@Offfff@O     @Offffff@Offffff@O&fffff@O@N@N33333@Ns33333@N@NL@N@M33333@M     @M@M@Ms33333@Ms33333@M     @M     @Ms33333@MY@M@     @M333333@M&fffff@M&fffff@M@M@Lfffff@L@L33333@L@Ls33333@LL@L333333@L@     @L&fffff@L@L@K33333@K33333@Ks33333@K333333@K@J33333@Jٙ@J33333@Jfffff@J@J@JY@J&fffff@J      @Ifffff@Is33333@I@     @I333333@I333333@Iffffff@IL@I&fffff@I      @Hfffff@Hٙ@H33333@HY@HL@HL@H&fffff@G33333@G33333@G     @Gs33333@GL@G&fffff@G@G@Fٙ@F     @F@Fs33333@Fs33333@FY@F@     @F&fffff@F&fffff@F&fffff@E33333@F333333@E33333@E     @E@E@Efffff@E@Es33333@Effffff@Es33333@EL@E@     @E333333@E&fffff@E@E@Dfffff@D     @D33333@D33333@Ds33333@DL@D@D      @D@C@C     @C     @C33333@C     @C     @C     @C@C33333@C@CL@C333333@C@     @C333333@C@B33333@B33333@B@B@B     @Bfffff@B     @B@B@Bfffff@B     @Bs33333@Bs33333@Bs33333@Bs33333@BL@BL@BL@BL@B@     @B@     @B@     @B@B&fffff@B&fffff@B      @B@B      @B@B      @A33333@A33333@Aٙ@A     @A     @A     @Afffff@A33333@Afffff@A33333@A@Afffff@A     @Affffff@AY@Affffff@AL@AL@A@     @A&fffff@A@@33333@A@A      @A@@33333@@fffff@@     @@s33333@@     @@s33333@@Y@@L@@@@@@@?@?@?@?@?33333@?@?33333@?ffffff@?ffffff@?333333@?L@?ffffff@?ffffff@?ffffff@?L@>33333@>33333@>fffff@>     @>ffffff@>     @>333333@>     @>ffffff@>@>      @>@>@>      @=fffff@=fffff@>      @=33333@=     @=@=     @=@=33333@=L@=ffffff@=     @=333333@=L@<fffff@=      @<fffff@<fffff@<@<33333@<     @<@<33333@<ffffff@<ffffff@<333333@<L@<333333@<ffffff@<@<@;fffff@;@<      @<ffffff@<333333@<333333@<     @<     @<333333@<L@<333333@<333333@<@;33333@;@;fffff@;33333@;ffffff@;ffffff@;     @;ffffff@;ffffff@;333333@;333333@;L@;333333@;333333@;333333@;      @;@;333333@;333333@;333333@;      @;      @;333333@;L@;@;333333@;333333@;@;333333@;333333@;333333@;333333@;333333@;333333@;L@;333333@;L@;@;     @;333333@;L@;L@;333333@;@;@;@;@;@;L@;      @:@:333333@:@:@:333333@9fffff@9fffff@:@:333333@:      @933333@933333@9@933333@9@9     @9L@9     @9333333@9@9333333@9333333@9333333@9      @9333333@9@8fffff@8fffff@8fffff@8     @833333@8@833333@8@8333333@8fffff@833333@833333@8@8L@8L@8L@8333333@8ffffff@8333333@8L@8     @7fffff@7fffff@8@8@8@8@8      @733333@733333@7@7@733333@8      @7fffff@7fffff@7L@7333333@7L@7L@7ffffff@7@733333@7     @7@6fffff@6@6fffff@6fffff@6fffff@6fffff@6fffff@6@6@633333@6@6@6@6333333@6L@6ffffff@633333@633333@6ffffff@6     @6     @6     @6333333@6@6L@6@6ffffff@6L@6ffffff@6L@6L@6L@6333333@533333@5ffffff@5L@5333333@433333@4     @4L@4@4@4ffffff@4@4fffff@4fffff@4fffff@4@4     @4ffffff@4@4333333@4ffffff@4333333@4@3fffff@3@3@333333@3@3     @3@333333@3fffff@4@4@3fffff@3fffff@4@4L@4333333@4333333@333333@3333333@2@2     @2L@133333@1L@133333@1@133333@1@1@1@1L@1333333@1      @0fffff@1L@1      @0@0@0fffff@1      @1L@0fffff@0@1      @1333333@0fffff@0@033333@0@0@033333@0@1      @0@033333@1@1      @0fffff@0fffff@0fffff@033333@0     @033333@0fffff@1333333@0@0@1      @1      @0fffff@033333@0fffff@0@0@0@0fffff@033333@0@0     @033333@1      @0fffff@0fffff@1      @1      @0fffff@0fffff@033333@0@0fffff@0@033333@033333@0@0fffff@0fffff@0fffff@0@0@0@0@033333@0@0@0@0@0fffff@0     @033333@0@033333@033333@0@0@0@0@033333@0@0@033333@0@033333@033333@0@0@0@0@0@033333@0@0@033333@0@1      @0@0@033333@0     @0@0@0     @0ffffff@0     @0ffffff@0@033333@0@0@0ffffff@0     @0ffffff@0     @0     @0     @0@0ffffff@0@0     @0ffffff@0333333@0     @0     @0@/@0     @0ffffff@0L@0      @0      @0333333@0L@0L@0ffffff@0@0L@0L@0L@0ffffff@0@033333@0@0ffffff@0      @0      @0L@0     @0ffffff@0ffffff@0ffffff@0@0ffffff@0333333@0     @0@0L@0     @0L@0L@0L@0@0ffffff@0@0@0ffffff@0L@0ffffff@0@0@0ffffff@0L@0     @0fffff@0@0L@0L@0     @0ffffff@0@0@0ffffff@0333333@0L@0@1      @033333@0ffffff@0     @033333@0fffff@0@0     @0fffff@0     @0L@0     @0@033333@0fffff@0@0@0ffffff@033333@0@0@0@0@0     @0@0     @0333333@0ffffff@0fffff@0fffff@0fffff@0ffffff@0@033333@0     @0@0     @0fffff@0@0@0L@0ffffff@033333@0@033333@0@0fffff@0@0fffff@0@033333@033333@0fffff@033333@033333@0@033333@033333@033333@0ffffff@033333@033333@0fffff@0@0@0@033333@033333@0@0@0     @033333@0@1      @0@033333@0fffff@0@033333@0fffff@0fffff@0ffffff@0L@0@0L@0ffffff@0fffff@1333333@0@0     @0fffff@1      @0ffffff@0ffffff@0@033333@033333@0@1@0@0     @0     @0@0fffff@033333@1      @1L@0     @0@0@0@033333@0     @033333@0@0@0     @033333@0@0fffff@033333@0@0@0@033333@033333@033333@033333@033333@0     @033333@033333@0@0@033333@0@033333@0@033333@033333@033333@033333@033333@033333@033333@0@0@1@0fffff@0fffff@1      @1L@1333333@0fffff@033333@1      @1333333@1ffffff@133333@2@133333@1     @1L@1@2      @2      @1     @1ffffff@1fffff@1@2      @1@133333@1@1@133333@1@1@1     @1@1@2@1fffff@1fffff@2@2333333@1fffff@1fffff@1fffff@2@2@2      @2@2333333@2     @233333@2     @2@2@233333@3@233333@2@3333333@3ffffff@2fffff@3@3333333@3@3L@3     @3333333@3L@3ffffff@3333333@3@333333@333333@333333@3@3@4333333@4L@4@3@3fffff@4ffffff@433333@433333@5@5333333@5@5@4fffff@5@5333333@5333333@5@5ffffff@5ffffff@5@6@5@6      @6ffffff@6L@6@6333333@6333333@6333333@6333333@6L@6     @6L@6     @6@7L@6fffff@6fffff@7333333@7@7333333@7     @7     @733333@7     @7@8@7@8333333@8333333@733333@7fffff@8@8333333@833333@8333333@8ffffff@8L@8ffffff@8L@8      @8      @8     @8@8L@8ffffff@833333@8@8     @8333333@8ffffff@8     @833333@8     @8@833333@8@9333333@8fffff@833333@8ffffff@8     @9      @8@8@8fffff@8@8L@8ffffff@8@8@8333333@8@833333@8ffffff@8333333@8     @8     @8@833333@9     @8@8     @8fffff@9333333@9@9333333@9@9      @8fffff@9L@9L@9@9L@9333333@9@9333333@9L@9     @9333333@9@:@:333333@933333@:@:      @:@9fffff@9@:      @9fffff@9fffff@:333333@:     @:ffffff@:L@:      @:      @:333333@:     @:333333@:333333@:333333@:     @:@:L@:@:333333@:L@:L@:ffffff@:     @:     @:ffffff@:ffffff@:     @:     @:L@:     @:@:@:     @:ffffff@:@:@:L@:@;333333@;@:@:@;333333@:fffff@;@:33333@:@:@;      @:     @:fffff@;@;333333@:@:333333@:     @:fffff@;333333@;@:fffff@;@;ffffff@;333333@;333333@;@;ffffff@;ffffff@;333333@;L@;@;fffff@;@<      @;fffff@;@;@<      @;ffffff@;fffff@<333333@<333333@;fffff@;fffff@<@<      @<@<L@<ffffff@<333333@<L@<333333@<ffffff@<ffffff@<@<@<L@<L@<@<fffff@=      @=L@=ffffff@=@=L@=     @=33333@=33333@=33333@=33333@=L@=     @=@=ffffff@=L@=@=L@=@=33333@>@>333333@>L@>L@>L@>333333@>     @>@>ffffff@>@?333333@?     @?@?@?@@      @?fffff@?@@@@@@@?fffff@@@@&fffff@@      @@@@&fffff@@@     @@s33333@@L@@333333@@L@@ffffff@@     @@L@@Y@@@@@@s33333@@     @@@@33333@@33333@@s33333@@@@33333@@ffffff@@333333@@@@     @@ٙ@@@@ٙ@A      @A333333@A@     @A@     @A@     @A@     @A@     @A@     @A@     @AL@AL@A@     @A@     @A333333@A&fffff@A@     @Affffff@A@A@A     @A     @A@Aٙ@A     @B@Afffff@Aٙ@A33333@A33333@B&fffff@B      @B@BL@B333333@B&fffff@B@     @BL@B@Bfffff@B@B     @BY@B@B@Bfffff@B33333@B33333@C      @B33333@Bfffff@Bfffff@Bٙ@B33333@C@Bfffff@C&fffff@CL@C@C@Cٙ@Cffffff@C@Cfffff@C@C@C@C33333@Cfffff@C33333@C     @C33333@C     @C@C33333@Cfffff@Cfffff@C33333@D      @Cfffff@Cٙ@Cfffff@Cfffff@D      @D@D&fffff@D333333@D&fffff@D@D&fffff@Dffffff@DY@DY@Ds33333@D@D@Dfffff@Dfffff@Dٙ@D@D     @Dٙ@D33333@Dٙ@Dٙ@E&fffff@E@E333333@Es33333@E@E@E     @EY@F      @E@Efffff@E@E     @E33333@E     @Efffff@E@F&fffff@F333333@Eٙ@Eٙ@Efffff@Efffff@E@F@F@F@F      @F@F&fffff@F@     @FL@F@     @F@Fs33333@Fffffff@Fffffff@Fffffff@F@Fffffff@Ffffff@F@F     @F@Ffffff@F33333@F     @F33333@G&fffff@Ffffff@F33333@G@G&fffff@G333333@G333333@GY@GY@G     @G@G     @G@G     @Gfffff@G     @GY@G@G     @G33333@H@G33333@Gfffff@Gfffff@G                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ?E?`A7L??|hs?9XbN? ěT?䛥S?(\)?1&x?r ě?A7Kƨ?9XbN?S?-V?QR?bM?+?(\)?
=p?1&x?|hr?Ƨ-?
=p?      ?bM?1&x?-V?-V?(\)?QR?lC?
=p?tj?9XbM?-V?QR?-V?;dZ?tj~?      ?lC?S?lC?zG?-V?bM?1&x? ěT?I^5?}?bM?Ƨ-?I^5?}?I^5?}?tj?bM?O;dZ?Ƨ-?bM?
=p?;dZ?+?lC?;dZ?;dZ?(\)?I^5?}?S?zG?+?(\)?lC?S?Q?+?-V?tj~?C$?\(\?
=p
?o?\(?7KƧ?hr!?9XbN?1&y?\(\?޸Q?j~"?߾vȴ9X?vȴ9X?O;dZ?(\)?(\)?I^5?"`B?ٺ^5?|?ٙ?xF?1&x?׍O;dZ?vȴ?;dZ?"`?vȴ9X?֗O;d?vȴ9X?$/?E?աo?zG{?Z1'?ԛS?ԋC%?tj?C$?ЃnP?Vu?+J?S?zG{?M?7KƧ?hr!?vȴ9?+?E??|hs?E??|hs?+?j~#?E?tj~?$/?tj~? ě?-V?-V?Q? ě?Q?Q?Q?nO;?nO;?tj~?nO;?Q?hr Ĝ?&x?`A7L?lD?E? ě?&x?
=p?bM? ěT? ěT?`A7L?bM? ěT?bM?
=p?
=p?&x?bM?
=p?lD?&x?-V?lD?&x?`A7L?`A7L?
=p?vȴ9X? ěT?bM?`A7L? ěT?vȴ9X?;dZ?;dZ? ěT?`A7L?;dZ? ěT? ěT? ěT?bM? ěT?;dZ? ěT? ěT? ěT?
=p? ěT?bM? ěT?bM?vȴ9X?
=p? ěT? ěT? ěT?bM?lD?-V?
=p?;dZ?;dZ?vȴ9X? ěT? ěT?;dZ?bM?
=p? ěT?vȴ9X?bM? ěT?vȴ9X? ěT?bM?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?Q?;dZ?Q?Q?Q?Q?Q?;dZ?Q?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?Q?Q?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?Q?Q?;dZ?Q?Q?;dZ?Q?;dZ?Q?Q?;dZ?Q?;dZ?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?
=p?bM?Q?Q?;dZ?Q?vȴ9X?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?Q?Q?;dZ?Q?;dZ?Q?;dZ?Q?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?vȴ9X?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?vȴ9X?;dZ?vȴ9X?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?5?|h?;dZ?Q?vȴ9X?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?Q?;dZ?5?|h?Q?Q?;dZ?;dZ?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?Q?Q?vȴ9X?vȴ9X?;dZ?Q?;dZ?vȴ9X?;dZ?5?|h?Q?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ? ěT?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?Q?Q?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?vȴ9X?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?vȴ9X?Q?Q?5?|h?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?Q?;dZ?Q?;dZ?vȴ9X?;dZ?Q?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X? ěT?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?vȴ9X?vȴ9X?;dZ?Q?vȴ9X?Q?vȴ9X?;dZ? ěT?vȴ9X?Q?Q?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?`A7L?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ? ěT?Q?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?Q?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?Q?vȴ9X?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?Q?Q?;dZ?;dZ?Q?;dZ?Q?Q?Q?;dZ?vȴ9X?Q?Q?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?vȴ9X?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?Q?;dZ?Q?;dZ?Q?Q?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?vȴ9X?Q?;dZ?Q?Q?Q?Q?;dZ?vȴ9X?;dZ?;dZ?Q?5?|h?Q?Q?5?|h?Q?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?Q?Q?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?Q?Q?Q?vȴ9X?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?Q?Q?5?|h?Q?;dZ?Q?;dZ?Q?Q?Q?;dZ?;dZ?Q?Q?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?Q?Q?Q?5?|h?Q?;dZ?;dZ?Q?Q?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?Q?Q?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?5?|h?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?Q?;dZ?5?|h?Q?;dZ?;dZ?Q?Q?Q?Q?5?|h?Q?Q?5?|h?5?|h?;dZ?;dZ?Q?Q?Q?5?|h?5?|h?;dZ?Q?5?|h?Q?5?|h?;dZ?Q?5?|h?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?;dZ?Q?Q?;dZ?Q?Q?Q?;dZ?5?|h?Q?Q?;dZ?Q?Q?Q?5?|h?5?|h?5?|h?5?|h?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?5?|h?Q?5?|h?Q?Q?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?Q?5?|h?Q?Q?5?|h?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?5?|h?5?|h?5?|h?Q?5?|h?Q?5?|h?Q?Q?5?|h?Q?5?|h?Q?Q?Q?;dZ?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?5?|h?5?|h?Q?5?|h?5?|h?;dZ?;dZ?5?|h?-V?5?|h?Q?5?|h?Q?5?|h?Q?Q?5?|h?5?|h?5?|h?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?5?|h?5?|h?-V?-V?Q?5?|h?5?|h?5?|h?5?|h?-V?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?Q?-V?5?|h?Q?Q?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?Q?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?Q?Q?5?|h?-V?5?|h?5?|h?Q?Q?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?-V?5?|h?Q?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?-V?-V?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?Q?5?|h?5?|h?/v?-V?5?|h?Q?5?|h?Q?5?|h?-V?5?|h?5?|h?5?|h?Q?5?|h?5?|h?/v?-V?-V?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?/v?/v?-V?-V?5?|h?-V?Q?-V?/v?-V?5?|h?/v?-V?5?|h?5?|h?5?|h?5?|h?1&y?5?|h?5?|h?/v?/v?-V?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?Q?-V?-V?5?|h?/v?/v?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?/v?/v?-V?-V?5?|h?5?|h?/v?/v?-V?5?|h?5?|h?-V?-V?5?|h?5?|h?-V?/v?5?|h?5?|h?5?|h?/v?5?|h?5?|h?5?|h?5?|h?5?|h?1&y?-V?-V?/v?/v?/v?/v?5?|h?/v?-V?/v?1&y?-V?5?|h?/v?/v?/v?1&y?-V?-V?/v?1&y?/v?/v?-V?-V?5?|h?5?|h?5?|h?5?|h?/v?/v?/v?5?|h?-V?/v?/v?-V?/v?-V?/v?-V?/v?-V?/v?1&y?-V?/v?/v?/v?/v?1&y?/v?/v?/v?5?|h?5?|h?/v?-V?-V?/v?/v?/v?/v?/v?/v?/v?1&y?/v?-V?5?|h?-V?/v?/v?/v?1&y?/v?-V?-V?5?|h?/v?/v?/v?/v?-V?/v?1&y?/v?/v?/v?-V?-V?1&y?/v?1&y?/v?-V?/v?/v?/v?1&y?1&y?1&y?1&y?1&y?1&y?/v?1&y?5?|h?/v?1&y?1&y?1&y?5?|h?/v?/v?/v?/v?1&y?1&y?-V?/v?/v?/v?1&y?/v?1&y?1&y?/v?/v?/v?1&y?/v?/v?/v?1&y?1&y?1&y?1&y?-V?/v?-V?1&y?/v?1&y?/v?/v?/v?/v?1&y?/v?/v?/v?1&y?1&y?/v?1&y?1&y?1&y?/v?1&y?/v?/v?1&y?1&y?1&y?1&y?1&y?1&y?/v?1&y?1&y?1&y?1&y?1&y?-V?/v?/v?/v?1&y?1&y?1&y?(\)?(\)?(\)?1&y?1&y?1&y?/v?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?(\)?(\)?(\)?1&y?1&y?1&y?1&y?/v?1&y?1&y?(\)?1&y?(\)?1&y?1&y?1&y?/v?1&y?1&y?1&y?1&y?/v?(\)?(\)?(\)?1&y?1&y?1&y?/v?/v                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	P26                                     1                                       )BH3e