CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20170205   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P8     CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:35.118138Z    ORIGINAL_HEADER      6CTD,20250210CCHSIOWB
#Removed 'CTDFLUOR_TSG' as it's filled with -999
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2017-06-29. CTD data from cruise 18DD20170205, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20170205. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2017-001/index.php. 
#
# The information in this file for the cruise 2017-001 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-0036.ctd
#
# Start of originator file comment header
#
#*2017/06/29 15:26:50.02
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2017/02/10 06:17:38.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 198
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : CE9F1F72
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            0.3            202.1
#       2 Temperature:CTD               deg_C_(ITS90)   5.6248         6.8697
#       3 Salinity:CTD                  PSS-78          32.78          33.8432
#       4 Sigma-t:CTD                   kg/m^3          25.7461        26.7106
#       5 Oxygen:Dissolved:CTD:Volume   ml/l            3.4            6.87
#       6 Oxygen:Dissolved:CTD:Mass     µmol/kg         147.7          299
#       7 Fluorescence:CTD:Seapoint     mg/m^3          0.66E-01       1.162
#       8 PAR:CTD                       µE/m^2/sec      0              0.3
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        7  F       ' '     2
#       6  -99   ' '        6  F       ' '     1
#       7  -99   ' '        8  F       ' '     3
#       8  -99   ' '        7  F       ' '     1
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2017-001
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P21
#    EVENT NUMBER        : 36
#    LATITUDE            :  49  38.00000 N  ! (deg min)
#    LONGITUDE           : 139  39.97000 W  ! (deg min)
#    WATER DEPTH         : 3961
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    The descent rate of the CTD was very noisy with some complete reversals
#	of direction.
#    CTDEDIT was used to remove many records corrupted by shed wakes;
#	salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Fluorescence and PAR data are nominal and unedited except that some records were
#	removed in editing temperature and salinity and a large spike in
#	fluorescence was removed from file 0032.
#
#    The Transmissivity channel was removed because of frequent shifts in values during
#	casts and large variations between values during repeat casts.
#	The data are available, by request, from the chief scientist.
#
#    NOTE: While the Fluorescence:CTD data are expressed in concentration units, they
#	do not always compare well to extracted chlorophyll samples, particularly for
#	casts far from shore. It is recommended that users check extracted chlorophyll
#	values where available.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in Sea-Bird
#	Application Note #64-2, June 2012 revision (Sea-Bird_64-2_Jun2012.pdf), except 
#	that a small offset in the fit was allowed.
#
#    The Dissolved Oxygen sensor used in files 0001, 0002 and 0016 malfunctioned so the 
#	Oxygen:Dissolved:CTD channels were removed from those files.
#
#    The Oxygen:Dissolved:CTD sensor has a fairly long response time so data accuracy 
#	is not as high when it is in motion as it is during stops for bottles. This will be
#	especially true when vertical dissolved oxygen gradients are large. To get an estimate
#	of the accuracy of the Oxygen:Dissolved:CTD data during downcasts (after recalibration)
#	a rough comparison was made between downcast Oxygen:Dissolved:CTD data and upcast 
#	titrated samples. Some of the difference will be due to problems with flushing of 
#	Niskin bottles and/or analysis errors, so the following statement likely underestimates 
#	Oxygen:Dissolved:CTD accuracy.
#
#    Downcast (CTD files) Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.25 ml/l from 0 to 125 dbar.
#	±0.2 ml/l from 125 to 400 dbar.
#	±0.1 ml/l from 400 to 600 dbar.
#	±0.05 ml/l from 600 to 1500 dbar.
#	Low by up to 0.08 ml/l below 1500 dbar.
#
#    For details on the processing see document: 2017-001-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5--- --6-- ---7--- --8---
#!Pressu Temperat Salinity Sigma-t: Oxygen Oxyge Fluores PAR:  
#!re:CTD ure:CTD  :CTD     CTD      :Disso n:Dis cence:  CTD   
#!                                  lved:  solve CTD:          
#!                                  CTD:   d:CTD Seapoin       
#!                                  Volume :Mass t             
#!------ -------- -------- -------- ------ ----- ------- ------
#*END OF HEADER
     WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @V        data_max      @V        C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     =  2   pressure                	long_name         pressure   positive      down   units         decibar    data_min      @   data_max      @Zfffff   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      =  p|   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      h     temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?sh   data_max      @ ̲   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       =  |   temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      h     salinity                	long_name         salinity   units         PSS-78     data_min      @@<   data_max      @AML_   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      = 
|   salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      h H   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @&333333   data_max      @r>fffff   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        = W|   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      h    CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?(\)   data_max      ?(\)   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      = |   CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      h    PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min                 data_max      @H&fffff   C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       = |   PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d      h /   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min               data_max               C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     = >|   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d      h |   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( |   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         (    time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      *%   data_max      *%   C_format      %10d          latitude               	long_name         latitude   units         	degrees_N      data_min      @Hh̢   data_max      @Hh̢   C_format      %9.4f             	longitude                  	long_name         	longitude      units         	degrees_E      data_min      `o?R&   data_max      `o?R&   C_format      %9.4f             	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d           	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min         m   data_max         m   C_format      %4d        @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @V     @@      @      @      @      @ 333333@!@$      @&      @(333333@)@,      @.      @0@0fffff@2      @3      @4@5      @5fffff@7      @8      @9      @:      @;      @<      @<fffff@>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @Efffff@F33333@G      @G     @H      @H     @I      @I     @J@Js33333@K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @Rfffff@S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @Vy@V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[fffff@[@     @[     @[     @\      @\@     @\@]      @]@     @]     @]     @^      @^@     @^y@^     @_      @_@     @_     @_     @`      @`      @`@     @`i@`     @`     @`     @`     @a      @a      @a9@ac33333@a     @a     @a     @a     @b      @b@b@     @b`     @b     @b     @b     @bٙ@c#33333@c@     @c`     @c     @c     @c     @cfffff@d)@d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @eVfffff@e@e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f@f@g<@g`     @g     @g     @g     @gfffff@h	@h      @h@     @h`     @h     @h     @h33333@h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j@jFfffff@j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @k@l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @ms33333@m33333@m     @m     @n      @n      @n@     @n`     @nfffff@n     @n     @o      @o      @o9@o`     @o     @o     @o     @o     @p      @p     @p&fffff@p.fffff@p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @qfffff@q@q     @q     @q     @q     @r      @r     @r      @r.fffff@rH     @rP     @r`     @rp     @r     @r     @rfffff@rfffff@r     @r     @r     @r     @s      @s$@s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s33333@sfffff@s     @t      @t     @t      @t0     @t@     @ta@tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @uq@uy@u@u     @u     @u     @u     @u@v33333@v     @v      @v0     @v@     @vP     @va@vnfffff@v     @v     @v     @v     @v     @v@v33333@v     @w      @w     @w@w333333@w<@wS33333@w`     @wp     @w     @w     @w     @w     @w33333@w     @w     @w     @wfffff@x     @x      @x1@x>fffff@xNfffff@x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yNfffff@y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z@z@z     @z     @z     @z     @z陙@{33333@{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{fffff@{fffff@{     @{     @{     @|@|33333@|#33333@|0     @|@     @|P     @|`     @|p     @|@|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}\@}p     @}     @}     @}     @}     @}     @}     @}@}񙙙@~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @A@Nfffff@`     @p     @     @     @     @     @     @љ@     @     @      @     @     @     @      @(     @0@8     @@     @H     @P     @[33333@_33333@h     @p     @x     @     @     @     @     @fffff@fffff@     @     @     @     @33333@fffff@     @     @     @     @      @     @     @@"fffff@(     @0     @8     @<@H     @P     @X     @`     @h     @m@y@     @     @     @     @     @     @     @33333@33333@     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @H@P     @X     @`     @h     @p@x     @@     @     @     @     @     @     @     @     @     @     @     @@     @     @@33333@     @     @     @@+33333@0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @33333@@     @     @     @33333@     @     @     @     @     @      @     @     @     @      @(     @0     @8@?33333@H     @P     @X     @`     @h     @p     @x     @     @     @     @     @33333@33333@     @     @     @@     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @33333@љ@     @     @     @     @     @      @     @     @     @      @(     @0@8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @      @     @33333@     @      @(     @0     @8     @@     @H     @P     @Zfffff@`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @ @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @@     @     @     @     @     @     @@     @     @     @     @      @     @     @!@(     @0     @8     @@     @H     @Nfffff@Y@`@h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @,     @9@@     @H     @P     @X     @`     @h     @p     @vfffff@@     @     @     @     @     @     @     @     @     @     @     @     @     @@fffff@fffff@     @     @     @      @(     @0     @9@@     @H     @P     @X     @`     @h     @p     @x     @     @@33333@     @     @     @     @     @     @     @     @     @     @     @fffff@     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h@p     @x     @     @     @     @@33333@     @     @     @     @     @     @     @     @33333@     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @33333@@     @     @     @     @     @     @     @     @     @     @fffff@@     @     @      @(     @0     @8     @Bfffff@H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @33333@33333@     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @@@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @+@133333@4     @8     @<     @@     @D     @H     @L     @Nfffff@T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @@@     @     @     @     @     @     @     @     @     @     @     @     @ @     @     @     @     @     @     @     @      @#33333@)33333@,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @33333@33333@     @     @     @     @     @     @     @     @@@     @     @     @     @     @љ@     @     @     @     @     @     @     @     @     @33333@@      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @G@L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @󙙙@     @      @     @     @     @     @     @     @     @33333@$@(     @,     @0     @4     @8     @<     @@     @Dfffff@F@Lfffff@P     @T     @X     @\     @`     @d     @h     @l     @q@t     @x     @|     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @@33333@     @     @     @     @     @     @fffff@     @     @     @     @     @     @      @@     @     @     @     @     @     @      @$     @(     @,     @0     @8     @<     @@     @D     @H     @L     @P     @T     @W33333@`     @d     @h     @l     @p     @t     @x     @|     @     @fffff@@     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @@     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @:@@     @D     @H     @J@P@T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @zfffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @@      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @K@P     @T     @X     @Z@`     @d     @h     @l     @p     @t     @x     @|     @fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @㙙@     @     @     @     @     @      @	@     @     @     @     @     @     @$fffff@(     @,     @0     @4     @8     @<     @@     @D     @H     @J@Q@T     @X     @\     @`     @d     @h     @p@t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@@     @     @     @     @     @     @     @     @     @     @     @     @33333@@      @     @     @     @     @33333@@     @      @$     @(     @+@0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @s33333@y33333@|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@fffff@     @     @     @     @     @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @O@X     @\     @`     @d     @h     @l     @p     @t     @x     @{33333@     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @@fffff@     @     @     @     @     @     @     @33333@fffff@     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,@0     @4     @8     @<     @@     @D     @H     @L     @P     @U33333@X     @\     @`     @d     @h     @l     @p     @s33333@xfffff@|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @󙙙@33333@     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @_33333@e@h     @l     @p     @t     @x     @z@fffff@     @     @     @     @     @fffff@     @     @     @     @     @     @@@@     @     @     @     @     @ә@fffff@     @ߙ@fffff@     @     @     @     @     @     @      @     @     @
fffff@33333@     @     @     @      @$     @(     @,     @0     @4     @8     @>     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @jfffff@o@t     @x     @|     @     @     @     @     @     @@33333@     @     @     @     @     @     @     @@33333@     @     @     @     @     @     @     @     @     @     @     @     @     @@     @      @     @     @     @     @     @     @     @      @"@(     @,     @0     @4     @8     @<fffff@?@D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @33333@@     @     @     @@fffff@     @     @     @@33333@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @fffff@
33333@     @     @     @     @      @$     @'@0@4     @8     @<     @@     @B@H     @L     @P     @T     @X     @Zfffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @ $/@ %zxl"h@ &1.@ &fffff@ &]cf@ &,<@ $o h@ #,zxl@ "Zc@ "`A@ "C,@ b}V@ [W>@  -
@  
qu@ |hs@ U=@ .H@ !-w1@ Ft@ Ft@ m\@ 6z@ BZc @ ,=@ [@ hr@ Z@ 1&@ wkP@ N;@ wkP@ ?@ 1&@ p
=@ 
(@ v@ }H@ v@ }H@ hr@ c	@ )_@ >B@ 6C@ 1'@ +@ @@ +@ kP@ YJ@ #w@ @@ }H@ )@ JE@ JE@ b}@ 	k~@ )@ y=c@ F]d@ >6z@ \(@ sg@ 3@ #@ =K@ _ح@ O;d@ _o@ C\@ W>6z@ ҈p;@ %O
@ 1@ ES@ bwkQ@ '/@ 䎊q@ S&@ ˒:)@ TɅo@ ̲@ NU@ &x@ ᰊ@ o h@ ae@ r䎊@ m5Xy>@ pU2a|@ rT`d@ rᰊ@ qo@ ]p
=@ G&@ @	k@ /o @ $JM@  u!@  d8@ !Gz@ !-w1@ [@ )^@As@cA @~
(@t֡a@^@9rGE8@	@y=c@a@O@T@	Q@F]d@U=@&@	k@qu!@qu!@wkP@"`B@ݗ+k@vȴ9X@n@dqj@Sa@O@Fs@8-
@)@#A [@u%@&IR@u%F@ڹZ@z@C\@lC@u!@u%F
@cA [@^쿱[W@[=K^@Vt@Rn@n.@0U2a|@Gz@=K^@T`d@K]c@o i@-V@\@*0U2a@xF@@N@@@4n@Y|@;J#9@.c	@ ěT@@Z@ ѷ@Fs@1&y@حV@0
)@1&x@{~$@qo@ZkP|@?H˒:@+jf@}H@KƧ@?@iB@Z@حV@D@F]c@'0@@{@&I@|PH@uY|@or@ezxl"h@J	 @2GE85@$/@҈p;@ݗ@ރ%@n.@&x@҈p@[@(@]cf@sMjO@jfB@fA@W@71@@S&@1@o@O;@\)@h	ԕ@Ov_@ȴ9Xb@IQ@$t@l"h	@	k@%2@.H@}ڹZ@{A@sߤ@`[6@[6@UL_@>ߤ?@e+a@*0U2@zH@33333@Ov`@Q_@;5X@tj@
(@\)@af@Fs@~m\@xQ@ffffff@TO
M@I^5?}@<Q@:xl"h
@;dZ@3PH@)ᰉ'@%`A7L@쿱[W@6@PH@
jOv@	Q@K]d@Q@n.@C@,=@@@҈p:@ҽ<64@T`d@_p@˒:*@@d8@qu!@@7KƧ@4m9@}K]@rW@Z1'@Y@SMj@RS&@R:)y@Q4J@LI^5?@K)^	@H˒:*@Gݗ+@ATɅo@>ߤ?@<쿱[@/Vϫ@b}V@@%1@C,zx@cA \@JM@JM@(@C,zx@@>@>BZc@ce@@N@@bwkQ@O;dZ@As@@hۋq@!ae@Mj@@3@33333@-V@(@0
@b@<64@6+jg@EoiDg@H@I@Kq@L_@I^5?}@8l"h	@䎊r@rGE9@n.@(@ ě@e+a@sP@E@
5Xy>@*0U@Xe,@-V@Q_@y=c@+j@+j@ A7K@_o@T`d@`A7@:)z@p:~@I^5?@	 ѷ@ݗ@      @D@w1@}Vm@o@_F@n@}H˒@fIQ@`A7K@X*0@/4֡a@(\)@%u@"wkQ@ ѷY@u%@+J@@L_@
qu"@R@tj~@:)y@eO@33333@dZ@2W@	k~(@	7KƧ@
	 @	@	 ѷ@*0@Q@xl"h
@ߤ?@,zxl@ 6@$t@r@iDg8@!-w@Ov`@d8@?@u%@ݗ+k@*0U@O;dZ@D@Țu%F@āo h@4֡b@/@wkP@kP{@d?@_䎊r@^҈p;@ZkP|@W@Qhr @R:)y@U2a|@W&@NMj@>
(@8YJ@8-
@84֡b@8l"h	@7kP@5%F
L@1[W>6@,q@',@$7@!Gz@iB@_F@E@E@Ʌoi@a@O@X@҈@
L/{@	@	@_o@@ ѷ@@^5?|@֡a@@A [@-V@}Vl@\@$xG@Gz@޸Q@޸Q@=K^@Xe,@sP@p:~@@̲@7KƧ@@@)^@m\@Y}@eں@'0@U2a|@d7@fffff@+a@wkQ@o@䎊r@쿱[W@N;@bM@@N@Mj@:)z@L/{@D@7KƧ@g8}@n.@|hs@|Q@xYJ@wkP@wXe@q-@j͞&@eO
@bh	ԕ@_?@^iB@\ߤ@@[qu!@Y_o@Xe+@U2a|@MM:@Hp:@>vȴ9X@6_ح@(>BZc@"C,@+j@O
M@ߊ	@/w@حU@ќu@Vu@C%@p:@%2@0
@'/W@f1.@ceO@^쿱[W@[=K^@U=K@RS&@\C,zx@`d8@aae@Z1'@S@N@Q4J@NT@A [7@8YJ@6_ح@-U=@(@&L/{J@IQ@u@+J@O
M@@N@Ʌoi@{@	Q@Fs@@s@@|hs@=b@@b}V@Zc@@_o @q@-@hr@Y}@@`A@	 @rG@֡a@?|h@!-w2@g@B@fA@RT`e@1.@e+@(\@PH@Ϫ͞@m@T`d@n@䎊@p:@X@-
q@jOv@O;dZ@cA \@qiC@]cf@4m@}Vl!@tSMj@rm\@r-V@ql@nO;@kU=@f'@`
qu@\>@[$@[=K^@[=K^@Z,<@Y0
)@WO;d@Vaf@S҉@P|@N;5X@K'/@H9Xb@Hu%F@D*0@?H˒:@;A@:S&@9=b@7eں@4D@2W@2-V@1-@1u!S@0:~ @.2X@.c	@-(@)ᰉ'@%S@"C,@"h	ԕ@ 	k@حV@5?|@]ce@JE@+j@zG@Vu@q@'/@˒:*@o h@&IR@Fs@@8Y@hr!@~"@8}H@5?|@Q_@8YJ@m@@7Kƨ@@64@4m@a|Q@V@Xy=@u"@*0U2@:)y@I^5?@M:@{lC@t!-w2@nO;@YJE@OAs@L/{J#@I@G@@Fs@As@>6z@;dZ@7rG@1o@.2X@,<쿱@',@$TɆ@ [6@6C@)^@!R<@eO@n.@ hۋq@b}V@H˒@lC@>B@F@!R@D@l@C\@!-w@	k@@ⶮ}Vm@W>6z@|@p:~@ΤT@@s@Ƨ@TɅo@4K@U2a|@ ě@'RT@Vϫ@d7@h	ԕ@u%F@Q@}H@qu!@Ov_@q@4m9@|#x@{lC@zxl"h
@zG{@z@y(@u!.@jJL@bM@^iB@]/w@Xe+@U2a|@GE84@7Xe@2W@,zxl"@%zxl"h@#n.3@#9@!ae@!-w1@S&@u@u@'/@&I@$/@
F]d@
u!S@
fB@
d8@
D*@
+@
@
Ƨ-@
74@
K]@
D@
)y@
YJ@
YJ@
3@
4m@
Xe@
)y@
|@
m\@
2X@
ae@
,<@
vȴ@
PH@
@
q@
IQ@
{J#9@
t!-w2@
f,<@
N_o @
)*0U2a@
wkP@m]@F]d@#@8Y@`A7L@|@jOv@sPH@W>6z@ԕ*1@~($@@ ѷ@u%F
L@l!-w@kC,z@iB@Y|@M@IoiD@C@H˒:*@J#9@Jn@Jn@N+@O͞@O͞@E@C,zx@_o@@4n@xl"h
@!-w2@Q@	ԕ+@حV@ݗ+j@bM@E@v_ح@@)^@Zc@ߤ?@BZc @b@쿱[@A@#w@Vϫ@U2a|@&x@ ě@B@6z@@S@u@wkQ@R<6@o@U=@-V@Q@6C@tj@@@R<6@ݗ+k@:)y@4J@bM@\(@\(@\(@Mj@=p
@y=b@sE@nO;@mhr!@l!-w@m\@l!-w@lVϪ@kQ@jJL@gfA@eڹ@eO
@d%1@b}Vm@`d8@^ ѷY@[6@["`B@Y>BZ@Y+@XD*@W>6z@Vaf@UϪ͞@U2a|@Rm@QN;5@O͞@N_o @L@L_@L_@L/{J#@IQ@B@1o@.zG@䎊r@Vu@
L/{@n/@:S@ ѷX@
˒:)@
"@ IQ@
rGE8@
>BZc@
+a@
e@
E@
Ʌoi@
ק&@
6@
Gz@
|Q@
҈p;@
Õ$@
j~#@
@
@
74@
6@
쿱[@
)_@
)y@
m8@
w1@
'@
@
wkQ@
Xe,@
rGE9@
@
 ѷ@
$/@
sg@
r ě@
p@
jOv`@
b@4@
_?@
Zc	@
T`d@
O
M;@
NT@
L/{J#@
GzH@
GE84@
F]cf@
Em\@
BZc@
<Z@
6z@
1-@
1-@
1-@
12W@
2a|Q@
333333@
/v@
+6z@
(Xy=@
%S@
"wkQ@
 -
@
-V@
kP|@
$/@

M:@
	 ѷ@
%2@	>B@	A [@	hr!@		ԕ+@	唯O
@	8YJ@	а{@	;dZ@	䎊@	Ϫ͞@	Ϫ͟@	"`B@	|Q@	%1@	A7K@	حV@	x@	"h	ԕ@	oiDg8@	+@
{J#9@
q@
#@
Fs@

qu"@
Fs@
nO@
q@
@4n@	lC@	?@	˒:)@	b}V@	C\@	SMj@	fffff@	2a|@	m@	т@	+@	jOv@	:@	cA \@	]cf@	j~#@	/V@	D@	YJ@	m\@	O
M@	y@	@	$xG@	3@	u%@	@	y=b@	m(@	XbM@	O;dZ@	O
M;@	E@	B\(@	D2W@	A7Kƨ@	>6z@	=<64@	<64@	7rG@	49XbN@	3g	l@	,<쿱@	%S@	 	k@	!-w1@	Ov_خ@	wkP@	6C@	)^@	'/W@	Vu@	F]c@SMj@fB@@N@ܑN;@b}@y=c@>6z@l!-@m@
M;@@?@|hs@5Xy@XbM@'0@9XbN@m\@ᰊ@v@U=@V@IQ@0
)@@*0U2@-
q@'/W@M:@=p
@7KƧ@eO@YJ@{J#9@@4n@ѷX@b}V@xF]d@jg	@b@4@_حV@_حV@^ ѷY@["`B@QN;5@Eo i@D*0@C$@>
(@%F
L0@Fs@@?@ ѷ@ hۋq@>B@Q@҈p@ڹY@`A7@`A7@p:~@Ƨ-@[W>@6z@Vϫ@wkQ@}H@S@_o@+j@ݗ+k@M:@ԕ*@k~(@?@hۋq@|Q@y=b@xF]d@y	k~@y=b@w+@vFs@t#@poiDg8@l[W?@l"h	ԕ@kC,z@kP{@kQ@kQ@k~($@kQ@ix@ae@]+j@R䎊@Em\@A@3g	l@1-@12W@2-V@2-V@1&x@/r@/v@!ae@$tS@_o@oiDg@@$/@nP@I^5@{J#9@      @.H@C\@	k~@F]d@ȴ9X@SMj@䎊q@
=q@4֡a@C\@\@쿱[W?@fB@(\@ҽ<64@jOv@s@ȴ9Xb@Ƨ-@]cf@š@\(@NU@<64@3@[W>6@*0U2a@-@Xy=@zxl"h@wkQ@S&@ae@o@,=@[@wkP@ߤ@@C,zx@S@=K^@_o@_o@PH@+J@*0@L_@+J@+J@@hۋq@|Q@h	ԕ+@_Ft@W
=p@^ ѷY@_Ft@]ce@Y>BZ@Vt@UϪ͞@Sa@O@R<64@P`A7@T`d@T,<@PH@PH@JL_@6z@*d7@#
=p@R<6@O
M@
O;dZ@	 ѷ@_o@?@@n.@m\@C\@=b@
=q@C@8Y@ hۋ@oiDg8@-V@VϪ@"h	ԕ@JL@]ce@_p@H@*0U@*0U@Ƨ@ʌL_@sg@y@1@TɆ@u@/@/@n.3@h	ԕ@䎊r@[@_o@kP|@*0U2@u%F@ݗ@?@o hی@~($x@b}V@~$t@|hr@z@uY|@u%F
L@qA [@o4֡a@o4֡a@j~"@lVϪ@lVϪ@\]ce@S&@R䎊@Ov_ح@O͞@KƧ@I@H9Xb@IoiD@IoiD@G@@G)^@Em\@Dg8}@A7Kƨ@@n@<Z@<j~#@+U=@'RT`e@!-w1@Fs@@@nP@hr@J#9@!R@ ě@@D@@iDg8@ hۋ@8Y@!-w@JL@ᰉ'@	ԕ+@,<@7@e+@$@,<@_o @s@?@7Kƨ@[W>@4֡b@rG@?|h@33333@W@33333@ᰊ@zG@I^@&@}H@N;6@qu"@&I@xF]d@l!-w@eO
@^@Y+@R<64@Np:~@Ks@IoiD@H˒:*@HK]c@Gy@Ca@N@A@3|@/v@.}Vl@-V@,q@+jf@',@wkP@@N@@I^5@~$@rGE8@"`@	k~@1@1@Fs@D@iDg8@g	@,<@@4@ۋq@bM@Ϫ͞@s@8YK@n@j~#@#w@|@{@r@}Vl@w1@h	ԕ@[@kP|@+j@Xe,@*0@@N@S&@:)y@o @(@7KƧ@n/@@%2@@~m\@~\N<@}E@}E@}H˒@~\N<@{lC@zC\@xF@r ě@l[W?@kQ@kP{@jg	@jOv`@jJL@jfB@jJL@g	k@f,<@cA [@ZY@TɅoi@T`d@T*1@M:@E@C$@@6@8Q@12W@/O
M@-V@($xG@$TɆ@vȴ9@@Ov_@@N@*0U2@-
q@@
L/{@YJ@ ѷ@@4n@o hی@ 4m9@#x@oiDg8@eO@e+@Ft@cA @>@>@ܑN;@(\@/w@(\@>BZ@Ϫ͞@Ƨ@n@@ɺ^5?}@ɅoiD@@ȴ9Xb@)^@)^@s@s@m\@@6@
(@n.@'0@r@
qv@<쿱@zxl"@<쿱@lD@/V@h	ԕ@Ov_خ@,=@}H@wkP@=K^@6C@PH@*0@ᰉ@Fs@@N@S&@u@@&I@ ѷ@ ѷ@F]c@nP@ ѷ@x73@poiDg8@o-V@o@nt@l!-w@g8}H@SZ@K)^	@E@?|hs@=v@;/V@8)@5?|h@5Xy=@2W@,<쿱@ -
@U=@}H@	ԕ*@@oiDg@JM@tj@%2@nP@o hی@ ѷX@˒:)@H˒@hr@#x@PH@>B@C\@+@	k~@Fs@iB@ hۋ@VϪ@	ԕ+@8}H@Z1@ߤ?@>@>BZ@fA@ӎMj@т@;5X@͞%@˒:)z@ʌL_@@ɅoiD@Q@Q@@˒:*@@?@š@
L/@ěS@a@N@C@6@|hs@dZ@}H@?|h@v@w1@1&y@d7@@IQ@TɆ@TɆ@9@o@U=@wkP@@@zG@hr @ڹY@o hی@|?@z@x73@tj~@rs@kC]@bC,@\>@QX@F?@BZc@@4m@=<64@5?@/{J#:@.2X@.H@-U=@)^@$/@"h	ԕ@ߤ@@$/@*0U2@u@bM@4J@Mj@~($x@'/@
	 @	ԕ*@	 ѷ@p:@	k~(@
	 @+I@YJ@n/@Q@tj@u%F
@$/@ ѷX@$/@I^5@ "@ lC@ s@ 	k~@ ȴ9X@ {m@ @ c	@ \@ hr!@ \@ 쿱[W?@ 빌~($@ ~"@ >BZc@ ,<@ 䎊qj@ @4@ ҈p@ ݗ+j@ حU@ 8YJ@ ՛=K@ Ʌoi@ l!-@ 
=p@ >6z@ ԕ*1@ ӎMj@ а{@ ͞%@ cA \@ 5Xy>@ ̘_@ @ E84@ 84֡@ @ Z@ 64@ )_@ )@ 4K@ U=@ U=@ \)@ R<6@ ,<@ *0@ -
q@  ѷ@ 1&x@ K]d@ M:@ u%F
@ $/@      @ }E@ {m]@ y=b@ r䎊q@ k~($@ irGE@ g@ eڹ@ dZ1@ [W>6z@ W@ Vl!-@ U2a|@ Q_p@ N+@ M@ K]cA@ I@ H9Xb@ H@ F]cf@ DS@ BZc@ A@ >ߤ?@ ;/V@ 2W@ -U=@ +I^@ &x@ !.H@  'RT`@ kP|@ +j@ @ @ @ $tS@ $tS@ +J@ sP@ \(@ 	7KƧ@ $/@ tj@ I^5@  ѷX?$tS?E?m\?!.H?PH?C\?-
?l?C\?x?>BZc?䎊qj?҈p;?ݗ+j?"`B??m?????6?[W>?ߤ??Z?)?}Vl?'0?m\?{?Xy=?ae?u"?kP|?u%F???Fs?:)y?\(?ڹY?+I???xF]d?u!R?qiB?oiDg8?k~($?hۋq
?dZ1?^?T`d?N;5X?M?L_?KƧ?MjOv?I^5?}?:~?5Xy=?2a|Q?1-?1o?.H?&x?!R<6?}H?[?PH??zG?4J?Vu?Vu?Vu?
M:?"`?oiDg8?C]?C,z?C,z?rGE?lC?,<?ߤ????a@O?*0U?͞%?_o ?+?͞%?͞%?cA \?)^	??o i?2W??v?j~#?/V?A?)_?~($?#w?#w?rG?E?9XbN?|?g	l?m\?-V?2W?B?͞&?-?S?zxl"h?wkQ?3?	k?IQ?,<?R<6?ݗ+k?S&?hr ?\(?q?&I?nP?{J#9?r ě?q?o hۋ?lC?l"h	ԕ?jfB?j~"?g8}H?e+a?c	?c	?c	?c	?ae?ae?bM?a|Q?a@N?`A7K?^?Zݘ?W&?W>6z?Vt?R<64?N;5X?K]cA?I^5?}?I^5?}?H?Fs?E?C\N?A [7???:~?1-?0
(?)y?Ov_خ?sh                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @@<!-w@@<JM@@<@@<@@<hr@@=:@@=Q@@=(@@=5Xy>@@=!.H@@=%F
L@@=?|h@@=Y|@@=p
=@@=m\@@=sg@@=p
=@@=w1@@=w1@@=}H@@=}H@@=}H@@=}H@@=ݗ@@=ݗ@@=$/@@=$/@@=M:@@=ݗ@@=!R@@=ڹZ@@=+j@@=Xy=@@=-V@@=8Y@@=@@=@@=8YK@@=8YK@@=8YK@@=@@=Ϫ͞@@=n/@@=8Y@@=Ϫ͞@@=@@=b@@=?@@=ᰉ@@=oiDg@@>_o @@>@@>$/@@>.2@@>H@@>_ح@@>s@@>vȴ9X@@>z@@>vȴ9X@@>z@@>vȴ9X@@>s@@>l!-@@>iB@@>_ح@@>fffff@@>vȴ9X@@>%@@>-@@>!.I@@?
M;@@?,@@?ݗ+@@AGz@@D!-w@@IoiD@@PQ@@_Xe,@@u8YK@@Ov_خ@@~"@@N;5@@(@@:@@Vϫ@@y@@~$@@hr@@@@BZc @@rGE9@@_o@@)y@@M@@
L/@@	@@&I@@ʜwkQ@@Z@@˜ߤ@@$@@VϪ@@B@@θQ@@@N@@{@@˒:*@@Xy=@@|@@|Q@@lC@@
L/@@փ%@@@@v_ح@@׾vȴ9@@ѷX@@ُo@@	 @@Zc@@~@@tj~@@xF@@V@@E@@
M;@@e+@@ ě@@C]@@2W@@M:@@C@@#x@@JM@@sh@@@@o@@?@@;dZ@@4m9@@@@@馵(@@@4@@wkQ@@ ě@@W@@S&@@wkP@@?@@7@@@@*0@@!-w@@%F
L@@5Xy>@@B@@L_@@Vl!@@\@@zxl"h@@-V@@!.@@Vu@@c	@@,<@@-@@,<@@&I@@Q@@Mj@@+I@@;dZ@@iDg8@@v_ح@@lC@@&@@?@@-V@@[W>@@	k@@zH@@/V@@ﴢ3@@r@@-@@حV@@fA@@rG@@@@rG@@#@@F]d@@F]d@@}H@@A7K@@NU@@r Ĝ@@u!@@)@@p:@@)^@@)^@@@@@@@@ [7@@ae@@e+a@@[W>6@@rGE8@@'RTa@@ԕ*@@>BZ@@䎊@@3@@JL@@xl"h
@@qiC@@@4@@ᰊ@@S&@@L/{@@ڹY@@fB@@74@@~@@I^@@u%@@33333@@C%@@C%@@=K^@@dZ@@ߤ@@A@@*0U2@@C]@@C]@@$@@J@@1&y@@C,zx@@#@@cA \@@o h@@*1@@3@@/@@2a|@@}H@@zxl"h@@ݗ@@hr!@@%@@@@Ϫ͞@@!.@@
L/@@@@?@@Vu@@c	@@iB@@m\@@x@@C-@@@@@@Fs@@"@@)^@@KƧ@@lC@@eں@@;dZ@@.H@@+I@@_o@@o@@|hs@@$tS@@ݗ+@@$tS@@-V@@kP@@-V@@&@@/V@@@@rG@@@@@-@@rGE9@@rG@@@@&@@y@@Xe,@@eں@@4m@@3@@@@˒:)@@O;d@@|hs@@䎊r@@D*@@1&x@@l"h	@@D*@@+j@@䎊r@@-@@1&x@@-
q@@*0@@4m9@@NU@@Xy=@@IQ@@e+@@@@"`@@>B@@C,zx@@@@!-w@@+a@@2a|@@IQ@@IQ@@!.H@@o i@@S@@`d@@PH@@~($x@@%1@@]ce@@
qv@@vȴ9X@@qi@@2X@@Fs@@1@@&I@@@@4֡a@@	@@?@@͞@@&@@zH@@?@@?@@-V@@@@sPH@@+I@@.H@@!-w1@@>6z@@@@ߤ?@@'@@Q@@҈p;@@Xe@@Fs@@"@@4֡a@@1@@RT`e@@sPH@@o@@ݗ+@@3@@+j@A -
q@A K]c@A >BZc@A l"h	@A IQ@A PH@AJE@A@Au@A'RTa@A(@A(@A^5?}@Ao@A_o@A-@A䎊@A䎊@AQ_@A@4@AS&@Aݘ@Aݘ@A0
@Ag	@AY@A,<@AG{@AfB@Ac	@Am\@AI^@A҉@A74@A҉@AC,z@A9@AC%@A@N@AP{@Ajf@A6@Aݗ+k@An.@A(\@AC,zx@AVϪ@Aq@Ao h@A3@A@A[W?@A֡a@A@AK]@A84֡@AL_@AjOv@A!R@AE@A$/@A($x@A8YJ@AR<6@AIQ@A@A hۋ@A
M;@A,@A;dZ@AXe,@A{J#:@Ar@A'RT`@An@AIQ@A
(@A)^@AD@A҈p@A	_p@A	rGE8@A	@A	'R@A	@A	2W@A	ԕ*@A	>BZ@A	ᰉ'@A	.H@A
@A
#9@A
xl"h
@A
W@A
fB@Au%@A6z@A@A6@A
=p@A@A!-w2@A,<@AI^5?@A]ce@AtSM@ATɆ@A>B[@A
o i@A
2a|@A
5Xy>@A
L_@A
ce@A
$/@A
!R@A
O
@A
-V@A

qv@At@A+jg@A%@A@A1@A hۋ@AXe@A,@A1@A;dZ@AE84@AE84@ART`e@Ab}V@A	k@Ao @A     @A@A'RT`@A@A3@A$tS@Aݗ+@A?@A&@AkP@Aݗ+@AO;d@A|hs@A'/W@A]cf@A2X@Aaf@AO;@AFs@AO;@A2X@A hۋ@A!-w1@AKƧ@A;dZ@A+I@A>6z@AE84@AsPH@A͞@AK]d@A@A@AK]d@ArG@ArGE9@A䎊r@A@AbM@A:~ @A[6@AeO@A|@AU@Ae+@A\)@A	k~@A$/@AQ@A@A|@Aԕ*@AI^5@AZc@A^5?|@A^5?|@A{m@Ad7@AC\@A@AY}@A.H@AI^5@Ae+@A0U2a|@AJL@Axl"h
@A~"@Ap:@AL/{@A}Vm@AW@AڹY@AfB@Ac	@AC,@Ac	@Ac	@A~@AC,z@A9@A@N@AJ#9@AMjO@AdZ@AMj@Am]@An.@AL_@A%1@A,<@AC,zx@AcA \@Azxl"@AJM@A+a@AL_@Ap
=@Azxl"h@Aݗ@A@AU=@A@A8Y@A8YK@A
qv@AC\@A
L/@AzG@A?@AFs@Am\@A쿱[W@A)^@A1@AU=@Ay@A&@A	@A$tS@A?@A3@Ao @A;dZ@A
qu@AD*@Al"h	@Ar Ĝ@A|@A-
@Ad8@A4m@Ap:@A@ArGE@ATɅo@Au!S@Ab}@A@A2W@Ao@A䎊@A=p
@AJL@AJL@A^5?|@AqiC@AwkQ@A}Vm@A)_@AsP@A'/@A/V@A6z@AC%@AW>6z@Aqu!@AQ@Aߤ@A@A$@A@AL_@A/{J#@APH@Aq@A?@A>B[@Ao i@AV@AQ@A%F
L@A/w@AB@AL_@A\@AjOv@A$/@AڹZ@Ahr!@AXy=@A-V@A8Y@A
qv@AzG@A($x@ABZc @Afffff@AiB@Ap:~@As@Aqi@A@A}Vl@AA@A@A
M;@A1@AKƧ@AXe,@AXe,@A\(@ART`e@A_o@AiDg8@Ay@A&@A͞@A@@A 
qu@A  ě@A  ě@A  ě@A  ě@A }H@A -
q@A K]c@A bM@A y=c@A u%F@A @@A @A!_p@A!N;5@A!^@A!k~(@A!x@A!b}@A!7Kƨ@A!@A!^5?}@A"	 @A"Q_@A"a|Q@A"d7@A"xl"h
@A"@4@A"@A",<@A"ڹY@A"fB@A"c	@A"m@A"c	@A"D@A"~@A#)^	@A#)^	@A#@N@A#n.3@A#@A#q@A#wk@A#@A#~($@A#|@A#$@A$@A$9XbN@A$64@A$9XbN@A$Fs@A$M:@A$PH@A$Z1@A$SMj@A$]ce@A$Z1@A$cA \@A$VϪ@A$q@A$q@A$?@A$j~@A$*0@A$Z@A$>B[@A$u"@A$!-w@A%o i@A%u@A%!.H@A%?|h@A%L_@A%<64@A%Vl!@A%fA@A%p
=@A%}H@A%%@A%Xy=@A%H˒@A%E@A&Ov_@A&H@A&L/{J@A&;5X@A&E@A&L/{J@A&YJ@A&_ح@A&YJ@A&YJ@A&c	@A&+J@A&qi@A&@A&@A&}Vl@A&@A&ߤ?@A&+@A&C-@A&ߤ?@A&x@A&1@A&1@A&ߤ?@A&ߤ?@A&!.I@A'+I@A'+I@A'O
M@A'_o@A'sPH@A'&@A'͞@A'fA@A'-@A(F]d@A(}H@A(*0@A(-
q@A(1&x@A(:~ @A(H@A(YJ@A(n@A(|@A('RT@A(@A()@A()^@A(`A7@A(@A(PH@A)$/@A)@N@A)#w@A)*0U2a@A)7KƧ@A)A [@A)N;5@A)N;5@A)^@A)o hی@A)x@A)@A)7Kƨ@A)o@A)@A)@A)@A)n.@A)R@A*@A*0U2a|@A*@4n@A*M@A*M@A*T`d@A*a|Q@A*xl"h
@A*p:@A*vȴ@A* ě@A*}Vm@A*@A*`A@A*G{@A*D@A+҉@A+'/@A+C,z@A+"`B@A+)^	@A+33333@A+9@A+F]c@A+J#9@A+]cA@A+qu!@A+~$@A+eO@A+$@A+$@A+:)z@A+A@A+q@A+ݗ+k@A+\N@A+\N@A,n.@A,J@A,xF@A,"h	ԕ@A,Fs@A,I^5?@A,SMj@A,?@A,@A,/@A,>@A-[@A-%F
L@A-`A7L@A-m\@A-hr!@A-@A-(@A-ڹ@A. ѷY@A-S@A-ᰉ@A-ᰉ@A.t@A.
L/@A.t@A.
(@A.4K@A.!R<@A.E@A.\N<@A.z@A.+J@A.,<@A.+@A.C-@A.x@A/@A/>6z@A/Xe,@A/U=@A/\(@A/eں@A/sPH@A/v_ح@A/4m@A/O;d@A/-V@A/$tS@A/kP@A/zH@A/&@A/zH@A/r@A/@A/fA@A/rGE9@A0	ԕ+@A0}H@A0*0@A0-
q@A0>BZc@A0D*@A0|@A0IQ@A0U@A0)@A0ěT@A0p:@A0D@A0҈p@A0e+@A0@A04֡b@A0$tT@A1_p@A1*0U2a@A1:S@A1Gz@A1Gz@A1Gz@A1Q@A1XbM@A1|Q@A1n.@A1B@A1y@A1@A1-@A1Y}@A1Y}@A2#9@A23@A2@4n@A2JL@A2kP|@A2vȴ@A2}Vm@A2<64@A2ڹY@A3	@A333333@A3=K^@A3C%@A3F]c@A3F]c@A3]cA@A3n.3@A3@A3Mj@A3Z@A3g@A3g@A3A [@A3s@A4n.@A4n.@A41&y@A4L_@A49XbN@A49XbN@A4<쿱@A4<쿱@A4SMj@A4`d@A4wkP@A4zG@A4~($x@A4N;@A4#x@A4?@A4Z@A4*0@A4@A4֡a@A4@A4>@A5*0@A5+a@A55Xy>@A52a|@A55Xy>@A5?|h@A5S&@A5Y|@A5m\@A5fA@A5sg@A5!R@A5v@A5-V@A5\(@A5cA @A5ڹ@A5E@A5E@A6
L/@A61.@A6L/{J@A6c	@A6p:~@A6IQ@A6%@A6@A6Fs@A6T@A6}Vl@A6Q@A6ߤ?@A6ߤ?@A6Q@A6ߤ?@A6t@A6A@A6҈p;@A6+@A6Fs@A7@A7
=p@A7+I@A7Xe,@A7RT`e@A7b}V@A7iDg8@A7lC@A7sPH@A7v_ح@A7y@A7|hs@A7{J#:@A7O;d@A7@A7ݗ+@A7kP@A7͞@A7@A7@A7fA@A7+@A7fA@A7@A7rGE9@A7䎊r@A7-@A7-@A7-@A8
qu@A8$xG@A873@A8K]c@A8A7K@A8H@A8K]c@A8_F@A8_F@A8bM@A8hۋq@A8bM@A8hۋq@A8oiDg8@A8y=c@A8'RT@A8@A8d8@A89Xb@A8)@A8ěT@A8ѷX@A8҈p@A8C@A8PH@A9	k~@A9@A9@A9rGE@A9@N@A9_p@A9 [7@A9 [7@A9#w@A9-w1@A97KƧ@A9=b@A9Dg8~@A9Q@A9TɅo@A9e+a@A9e+a@A9hr @A9hr @A9k~(@A9k~(@A9k~(@A9u!S@A9u!S@A9b}@A9R<6@A9'RTa@A9(@A9n.@A9'RTa@A9n.@A9B@A9X@A9'R@A92W@A9"`@A9e@A9@A9>BZ@A9R@A9@A9lD@A9Y}@A9.H@A:n@A:s@A:e+@A:䎊@A:䎊@A:)y@A:-V@A:3@A:=p
@A:6C@A::)y@A:C\@A:GE85@A:d7@A:{m@A:{m@A:{m@A:ݘ@A:ݘ@A:p:@A:L_@A:\(@A:S&@A:S&@A:\(@A:\(@A:@A:,<@A: ѷ@A:䎊q@A:fB@A:䎊q@A:G{@A:䎊q@A:䎊q@A:G{@A:ڹY@A:G{@A: ѷ@A: ѷ@A:G{@A:fB@A:fB@A:c	@A:~@A;"`B@A;C,z@A;/V@A;9@A;MjO@A;qu!@A;{J#9@A;~($@A;
=p@A;$@A;Q@A;Q@A;ݗ+k@A;A [@A<1&y@A<J@A<@A<L_@A<@A<ߤ@@A<1&y@A<@A<L_@A<!-w2@A<Z1@A<zG@A<?@A<zxl"@A<@A</@A<D@A<e@A<E@A=:@A=o i@A=u@A=(@A=B@A=p
=@A=ݗ@A=$/@A=zxl"h@A=p
=@A=zxl"h@A=!R@A=ڹZ@A=ݗ@A=sh@A=\(@A=8Y@A=8Y@A=8Y@A=@A=@A>_o @A>1.@A>.2@A>.2@A>+jg@A>+jg@A>.2@A>1.@A>5?|@A>;5X@A>BZc @A>E@A>H@A>Ov_خ@A>\N<@A>fffff@A>fffff@A>s@A>vȴ9X@A>s@A>vȴ9X@A>IQ@A>%@A>Fs@A>O;@A>,<@A>af@A>af@A>}Vl@A>6z@A>-@A>҈p;@A>@A>Mj@A>!.I@A>!.I@A?
=p@A?v@A?Xe@A?@A?Xe@A?!-w1@A?'/W@A?.H@A?4֡a@A?;dZ@A?>6z@A?H˒:@A?RT`e@A?{J#:@A?ݗ+@A??@A?@A?@A?䎊r@A?Vϫ@A@     @A@*0U@A@6@A@ ě@A@ ě@A@ ě@A@$xG@A@*0@A@-
q@A@1&x@A@73@A@>BZc@A@A7K@A@73@A@D*@A@H@A@NU@A@[6@A@oiDg8@A@˒:*@A@'RT@A@n@A@'RT@A@|@A@y=c@A@u!@A@u!@A@y=c@A@u!@A@u!@A@u!@A@|@A@n@A@˒:*@A@'RT@A@@A@u%F@A@@A@
=q@A@
=q@A@{@A@4m@A@p:@A@C@A@4֡b@A@$tT@AA	k~@AA@AA [7@AA=b@AAGz@AAQ@AAJE@AAGz@AADg8~@AAGz@AAQ@AAJE@AATɅo@AAQ@AAXbM@AATɅo@AA^@AArGE8@AAx@AAx@AAx@AAx@AA|Q@AA|Q@AAb}@AA~($@AA@AAb}@AAoiD@AA7Kƨ@AAR<6@AA'RTa@AA'RTa@AA(@AA|@AAX@AA@AAo@AA_o@AAԕ*@AAe@AAԕ*@AAs@ABI^5@AB	 @ABs@AB@ABe+@AB䎊@AB䎊@AB&IR@AB&IR@AB0U2a|@AB:)y@AB=p
@ABGE85@ABGE85@ABC\@ABW'@ABT`d@ABT`d@ABT`d@ABT`d@ABT`d@AB^5?|@AB^5?|@ABa|Q@ABxl"h
@AB@4@ABp:@ABL_@ABᰊ@ABL_@AB\(@ABS&@ABᰊ@ABS&@AB@AB ě@AB@AB,<@AB,<@ABsP@ABc	@ACI^@AC'/@ACnP@AC)^	@AC9@AC9@ACF]c@ACS@AC]cA@ACg	l@AC{J#9@AC@ACq@ACU=@ACA@ACA@ACwk@AC*0U2@ACm]@ACm]@ACm]@ACE@AC|@ACa@@AC$@ACs@AC\N@ACs@ACs@ADxF@ADn.@ADJ@ACs@ADJ@ADxF@AD(\@AD%1@AD(\@AD,<@AD,<@AD/{J#@AD64@AD9XbN@AD?@AD9XbN@AD9XbN@AD<쿱@ADC,zx@ADFs@ADPH@AD]ce@ADq@AD#@ADS@ADN;@AD*1@AD*1@ADS@AD쿱[@ADzxl"@ADO
M@AD@AD?@AD#x@AD#x@ADj~@AD[W?@AD?@AD?@ADɅoi@AD*0@ADZ@AD֡a@ADZ@AD>B[@AD!-w@ADe@AD>@ADE@AE:@AEo i@AE'0@AE[@AEu@AE*0@AEqu"@AE!.H@AE!.H@AE84֡@AEF
L0@AEL_@AEVl!@AE`A7L@AEjOv@AEڹZ@AE$/@AEO
@AE%@AEU=@AEn/@AE\(@AEb@AEb@AES@AEoiDg@AE!.@AF ѷY@AF_o @AEڹ@AF_o @AF
L/@AF
(@AFzG@AFu@AFzG@AFzG@AF@AF@AFu@AF@AFOv_@AF($x@AF$/@AF($x@AF5?|@AF8YJ@AF;5X@AFE@AFH@AFR<6@AFVu@AFYJ@AF_ح@AFiB@AF_ح@AFc	@AFfffff@AFl!-@AFp:~@AFl!-@AFiB@AFl!-@AFp:~@AFvȴ9X@AFvȴ9X@AFs@AFs@AFvȴ9X@AFz@AF}Vl@AFz@AFIQ@AF@AF@AF$t@AFaf@AF-@AF-@AF}Vl@AF'@AF'@AF@AF@AF&I@AFȴ9X@AFt@AF+@AFC-@AFC-@AFx@AG@AGXe@AG!-w1@AG'/W@AG+I@AG4֡a@AG4֡a@AG8}H@AG>6z@AGKƧ@AG_o@AGlC@AGsPH@AGsPH@AGv_ح@AG4m@AG&@AGO;d@AGO;d@AG@AGkP@AG&@AG?@AGzH@AG[W>@AG[W>@AGr@AGvȴ9@AG+@AG@AG@@AG@AG@AG@AGrG@AGVϫ@AGVϫ@AG@AG@AG@AGrG@AG@AGVϫ@AG@AG䎊r@AG+j@AGVϫ@AG䎊r@AG䎊r@AG#@AHF]d@AH	ԕ+@AH
qu@AH*0U@AH6@AH6@AH6@AH6@AH}H@AH}H@AH$xG@AH$xG@AH$xG@AH$xG@AH*0@AH-
q@AH1&x@AH:~ @AH73@AH:~ @AH:~ @AH:~ @AH1&x@AH73@AH>BZc@AH>BZc@AHD*@AHD*@AHD*@AHH@AHQ@AHH@AHNU@AHU2a|@AHXy=@AHeO@AHl"h	@AHoiDg8@AHu!@AHy=c@AH˒:*@AHtj@AH@AH-
@AHTɅ@AH@@AHěT@AH)^@AHۋq
@AHۋq
@AHe+@AH{@AH$tT@AH\)@AHPH@AIrGE@AI@AI#w@AI4J@AIA [@AIA [@AIN;5@AIN;5@AIQ@AIo hی@AIb}@AIoiD@AIoiD@AIR<6@AI'RTa@AI(@AIB@AIB@AI|@AIX@AI@AI2W@AI_o@AIԕ*@AIN;6@AIᰉ'@AI-@AI.H@AJu%F@AJI^5@AJOv`@AJe+@AJ&IR@AJ0U2a|@AJ=p
@AJ3@AJ6C@AJ0U2a|@AJ6C@AJ6C@AJ@4n@AJQ_@AJZc@AJ^5?|@AJa|Q@AJh	ԕ@AJh	ԕ@AJnO@AJ{m@AJnO@AJqiC@AJu%F
@AJu%F
@AJxl"h
@AJ@4@AJp:@AJ\(@AJL_@AJ\(@AJwkQ@AJwkQ@AJvȴ@AJ@AJY@AJY@AJY@AJ<64@AJ@AJ)_@AJW@AJW@AJ,<@AJڹY@AJ ѷ@AJsP@AJ ѷ@AJC,@AJ~@AJ74@AJ~@AJ~@AJm\@AKI^@AKS&@AKu%@AKu%@AKnP@AKPH@AKC,z@AK&@AK/V@AK33333@AK6z@AK9@AK=K^@AK@N@AKF]c@AKW>6z@AKa@N@AKa@N@AKdZ@AKdZ@AKa@N@AKg	l@AK{J#9@AKeO@AKeO@AKeO@AKeO@AKMj@AK$@AKU=@AKS@AKS@AKq@AK@AK@AK~($@AKZ@AK6@AK6@AK6@AKݗ+k@AKg@AKA [@AKC]@AKA [@AK$@AKs@AK@ALJ@ALxF@ALQ@AL%1@AL!-w2@ALtj@AL"h	ԕ@AL"h	ԕ@AL!-w2@AL(\@AL(\@AL/{J#@AL,<@AL/{J#@AL64@AL<쿱@AL9XbN@AL9XbN@AL<쿱@AL9XbN@ALC,zx@ALC,zx@AL?@ALC,zx@ALC,zx@ALFs@ALM:@ALM:@ALM:@ALSMj@ALM:@ALM:@ALVϪ@ALZ1@AL]ce@AL]ce@ALcA \@ALj~#@ALj~#@ALq@ALtSM@ALzG@AL~($x@AL?@AL?@AL?@AL#@ALqj@AL*1@AL쿱[@ALTɆ@ALO
M@ALO
M@AL?@AL#x@AL[W?@AL?@AL[W?@AL7@AL@AL@AL@AL?@AL@ALɅoi@AL@AL@ALZ@ALZ@ALZ@ALu"@ALZ@ALu"@ALZ@ALhr@AL!-w@AL!-w@AL>@AL>@ALE@AM:@AM:@AMo i@AMK]@AMV@AM'0@AMQ@AMQ@AM(@AM<64@AML_                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @r>fffff@r,@r.fffff@r+33333@r)@r#33333@rfffff@r!@rfffff@rfffff@r@r33333@rfffff@r@r33333@r     @rfffff@r@r     @r	@r33333@r     @r@r     @rfffff@r33333@rfffff@r     @rfffff@rfffff@r     @r@r@qfffff@r33333@r33333@r@r@rfffff@r33333@r     @r@r     @r@rfffff@rfffff@r@rfffff@rfffff@r@rfffff@r     @r33333@r     @r	@r	@r	@r     @rfffff@r	@r     @r     @r@r     @r33333@r33333@r33333@r33333@rfffff@r@r      @r      @q33333@qfffff@q     @qfffff@qS33333@pfffff@offfff@ms33333@k33333@jffffff@h@h#33333@g@g33333@g33333@h      @h      @h#33333@hfffff@g     @g     @gp     @gl@gc33333@gI@f@fVfffff@fffffff@fi@fY@fS33333@f9@f0     @f      @f33333@f33333@e@e33333@efffff@e     @eL@e0     @e#33333@efffff@e	@e      @d@e      @e33333@e     @e33333@e@e@efffff@e@d@dfffff@d@dfffff@d     @d     @dfffff@d@d     @d@d33333@d33333@d@d@dfffff@d@d     @d     @d     @dٙ@d33333@d     @dvfffff@dl@dl@dp     @ds33333@di@dP     @dP     @dP     @dC33333@d<@d9@dfffff@c@c@c陙@cfffff@c     @cL@c@     @c@     @cC33333@cVfffff@c\@cI@c<@c&fffff@c      @b33333@b@b\@bI@b<@b333333@b      @bfffff@b	@a     @a33333@a     @afffff@a@a     @a     @a@ay@ac33333@a0     @a33333@`33333@`@`c33333@`S33333@`Vfffff@`P     @`9@`fffff@_33333@_33333@_ffffff@_Y@_      @^fffff@^Y@]@]     @]S33333@]L@]Ffffff@]333333@]      @\@\@\fffff@\@\l@\@     @\33333@[33333@[33333@[@[fffff@[33333@[ffffff@[@     @[fffff@Z@Zfffff@Z@ZL@Z33333@Zfffff@Yfffff@Y33333@Y33333@Y33333@YL@Y@Yfffff@X@X     @Xl@X@     @Xfffff@Xfffff@X      @W@W     @W@W33333@Wy@Wffffff@WS33333@W9@W      @V     @V@V@V     @V     @V     @Vy@Vl@V@     @V@V@V      @V33333@V@U@U@U33333@Ufffff@U     @U@Us33333@Ul@Uy@U`     @US33333@US33333@UFfffff@U9@U,@U,@U,@UFfffff@Us33333@U33333@Ufffff@U@U33333@Us33333@U,@U&fffff@US33333@Ul@US33333@UFfffff@U33333@T@T33333@Tٙ@T@T@T33333@Tfffff@T@T@Ty@T`     @T9@S33333@S@S333333@Rs33333@Qfffff@Pٙ@P@P@P33333@P@P     @P@P@Q      @Q33333@Q@Q      @Q      @Q@Pl@Offfff@O&fffff@Nfffff@NY@N@     @Ns33333@N@NL@Mfffff@Mfffff@Ms33333@MY@M     @M     @MY@M     @Mffffff@M     @Mfffff@N      @Ns33333@N@N@N@N@     @NY@N@     @N333333@N@Mٙ@N      @M@M@M     @Ms33333@Mffffff@M&fffff@L33333@L     @LL@L333333@L&fffff@L      @K     @K@J@J     @J@J@J@Jfffff@Jfffff@J     @JL@J@I33333@I@Ifffff@I     @I@I     @I33333@I     @I@     @I@     @I@I@I&fffff@I@I@I      @I      @I@I&fffff@I@H@H     @Hfffff@Hfffff@HY@H&fffff@Gfffff@G@Gfffff@Gfffff@G@Gs33333@GL@G@     @G&fffff@G&fffff@G@F33333@Fٙ@F@F@F33333@F@E     @E@E@E     @Effffff@E@E      @D@D@D     @D@DY@DL@D      @Cs33333@CL@CL@C@C      @C@C      @B@Bffffff@Bffffff@BL@B333333@B&fffff@B333333@B@     @B333333@B@B@A@As33333@A@     @A@A@@ٙ@@@@ffffff@@Y@@L@@L@@      @@@@@?fffff@?ffffff@?      @>fffff@>@>@>@>     @>@>L@>      @=@=@=@=ffffff@<fffff@<     @<333333@<      @;33333@;@;@;33333@;@;@;@;L@;333333@;      @:     @:     @:@:@;L@;@;@;333333@;ffffff@;L@;ffffff@;@;33333@<L@<fffff@<fffff@<fffff@=L@=@<@<@<@<ffffff@<333333@;fffff@<      @<@<@;@;     @;     @;     @;ffffff@;ffffff@;333333@;L@;ffffff@;@;@:@:33333@:fffff@:@:ffffff@:ffffff@:@:333333@9@9@9333333@9      @833333@8     @8L@8L@8L@8ffffff@833333@9333333@9     @9L@9@9333333@9333333@8fffff@8fffff@8fffff@833333@833333@8@8@8@8@8ffffff@8L@8     @8@8ffffff@8ffffff@8@8333333@8333333@8      @8@8333333@7fffff@7@7ffffff@7ffffff@7L@7L@7333333@6fffff@6@6ffffff@6333333@6L@5fffff@5fffff@533333@5@5fffff@5@5fffff@5fffff@5     @5ffffff@5ffffff@5ffffff@5333333@5      @433333@4@4ffffff@4@433333@4L@4L@4      @4      @4@333333@3@3fffff@3@3     @3L@3ffffff@3      @3333333@3L@2@2fffff@2fffff@2@2     @2     @2@2L@2L@2L@2      @1fffff@1@2      @1@133333@1     @1     @1ffffff@1     @1ffffff@1L@1333333@1@1@0fffff@1      @1333333@0@033333@0@0@0@0@0     @0L@0333333@0333333@0L@0333333@0L@0333333@0@0      @0@0      @0      @0      @/@/@/@/@/@/333333@/      @/      @/333333@/      @/      @.@/      @/      @.@.ffffff@.@-@-@.      @-@-@.      @-@.      @.      @.      @-@-333333@-ffffff@-333333@-      @-333333@-@-333333@,@-      @-      @-      @-333333@,@,@,333333@,      @,      @,      @+@+ffffff@,      @+@+ffffff@+ffffff@+333333@*ffffff@+333333@+      @*@*@+      @*      @*@*ffffff@*@*ffffff@*@*ffffff@*@*@*@*333333@*ffffff@*ffffff@)@)@*ffffff@*ffffff@*      @*      @*      @)@)@)333333@*333333@)@)@*      @*      @)@*      @)@)@*      @*      @)@)@)ffffff@)@)@)333333@)@*      @)@)@)@*      @*333333@*      @*333333@*@*@*333333@*      @*@*      @)ffffff@*      @)@)@*@*@*@*@*ffffff@*@*@*@*ffffff@*333333@*@*ffffff@*333333@*ffffff@*ffffff@*@*ffffff@*333333@*@*@*@*@+333333@+333333@*@*ffffff@*@*      @*      @*333333@*      @)ffffff@)@)@)@)@*      @)@)@)@)333333@)333333@)333333@)333333@)ffffff@)ffffff@)333333@(@)333333@)      @(@)      @)      @)      @(@(@(@)      @(@(@(ffffff@(@(@(@(@(ffffff@(@(@(333333@(333333@(@'@'@(333333@(333333@(      @(      @(      @(      @'@(      @'@'ffffff@'@'@'ffffff@(      @'ffffff@'ffffff@'@'ffffff@'ffffff@'@'@'      @&@'333333@'333333@'ffffff@'333333@'ffffff@'333333@'      @'333333@'ffffff@'@'@'ffffff@'333333@'@'333333@'333333@'333333@'333333@'      @'ffffff@'      @'ffffff@'333333@'      @&@&@&ffffff@&333333@'333333@&@&@&@&@'      @'      @&@'333333@&@&@&@'      @&@&@&@&ffffff@'      @&@&@&@&@'333333@&@&@'      @'ffffff@'      @&ffffff@'333333@'333333@'333333@'      @&@&@'      @'@'333333@&@&@'333333@'333333@'333333@'      @'ffffff@'333333@'ffffff@'333333@&@'333333@'333333@'333333@'333333@'333333@'@'333333@'@'333333@'      @'ffffff@'333333@'      @'@'ffffff@'ffffff@'333333@'@'333333@'333333@'@'ffffff@'@'@'333333@'333333@'@'@(      @'ffffff@'ffffff@'@'@'@(      @'@'@(      @'@(333333@(333333@'@(@(@(@(ffffff@(ffffff@)333333@(      @(@)333333@(@(@(@(@(ffffff@)ffffff@(@(ffffff@)333333@(@)333333@)ffffff@)333333@(@)      @)333333@)@)333333@)ffffff@)ffffff@)@)333333@)333333@)@)@)ffffff@)@)@)ffffff@*      @*      @*333333@*@*      @)@*@*333333@)@*@*@+@+333333@*@*@+ffffff@+333333@+ffffff@*@+ffffff@+ffffff@*@+      @+ffffff@+333333@+333333@+333333@+333333@+333333@+333333@,      @+@,333333@,      @,      @+@,      @+@,@,@,@,      @,ffffff@,333333@,@,ffffff@,333333@,@,@-333333@,@,@-      @,@,@-ffffff@-ffffff@,@-333333@-ffffff@-333333@-ffffff@-@-333333@-ffffff@-ffffff@-@-@-@-333333@-@-@-ffffff@-ffffff@-ffffff@-ffffff@-@.ffffff@.      @-ffffff@.      @.@.      @.@.ffffff@.@.@.@.333333@/      @/      @.ffffff@.@.@.ffffff@/      @.@/      @.@/333333@/333333@/@/333333@.@.ffffff@.333333@/ffffff@/333333@/333333@/      @/333333@/333333@/@/333333@/333333@/333333@/@/@/333333@/@0@0333333@/@/      @/@/@0333333@/@0      @/@/@0333333@0@0333333@/@0@0L@0L@0      @0L@0ffffff@0L@0L@0@0     @0@0     @0ffffff@0L@0L@0@0@0L@033333@0@0fffff@0@0fffff@0@0fffff@1      @033333@1      @0L@0@1@0@0     @0     @0@1      @0fffff@1@1@1     @1ffffff@1333333@1     @1L@133333@2      @2333333@2@1fffff@1fffff@2      @2     @2333333@2L@2L@2333333@2333333@2      @2333333@2L@2ffffff@2ffffff@2ffffff@233333@2fffff@3333333@3ffffff@3ffffff@3@3     @3L@3@333333@3@3@4@4L@4@4ffffff@4ffffff@4L@4     @4@4     @4     @433333@4fffff@4@4@4fffff@5@5333333@5      @5L@5@4fffff@5333333@5@5     @5     @533333@5L@533333@5@5@5@5@5@5@533333@5fffff@5@533333@6@6      @5fffff@5fffff@6@6@6333333@6@6ffffff@6@6ffffff@6@6@6fffff@6@7@6fffff@6fffff@7      @6@6fffff@7333333@7ffffff@633333@7333333@7333333@7ffffff@7@7@7     @733333@8333333@8ffffff@8L@833333@8@8@9@8fffff@8@8fffff@9      @8fffff@8@9      @9@8@8fffff@8fffff@8fffff@9@9     @9ffffff@9L@9@933333@9333333@9     @9@9@9     @9     @9     @9@9333333@9     @9     @9@933333@933333@9fffff@933333@9@9fffff@9fffff@:      @:L@:ffffff@:@:@:     @:@;      @;333333@;L@;333333@;@:fffff@;333333@;@;      @;333333@;333333@;     @;@;ffffff@;@;333333@;ffffff@;@;fffff@;33333@;33333@;33333@;     @;@;fffff@;33333@;     @;@<@;@;@<L@<@<      @<      @<33333@<333333@<@<L@<33333@<@<fffff@<@<33333@=      @=333333@<@=      @<@=L@=ffffff@=@=L@=333333@=     @=ffffff@=     @=ffffff@=L@=     @=L@=L@=@=L@=@=@=33333@=@>      @>@>@>@=@>@=fffff@>333333@>L@>ffffff@>33333@>fffff@>33333@>@>@?      @>fffff@>fffff@?333333@?@?     @?L@?L@@      @@@@&fffff@@&fffff@@&fffff@@Y@@@@Y@@L@@Y@@333333@@@     @@L@@s33333@@@@     @@     @@     @@@@@@     @@ٙ@@ٙ@@@@@@fffff@@ٙ@@     @@fffff@@fffff@@@A      @A&fffff@@33333@A@A333333@@fffff@@33333@A@A@A333333@A&fffff@A@     @AY@A@     @As33333@A@A     @A@A     @A@A@A@A@A@Aٙ@Afffff@Afffff@A     @Afffff@A     @A33333@A     @Afffff@Aٙ@Afffff@Aٙ@Afffff@B&fffff@B&fffff@B      @A@A33333@B&fffff@B&fffff@B@B@     @B&fffff@B&fffff@B@     @BY@Bs33333@B@B     @Bfffff@B@Bfffff@Bfffff@B33333@C      @C&fffff@B33333@C&fffff@C&fffff@CL@CL@C     @Cs33333@C@     @CY@C@Cfffff@Cfffff@CY@C@Cs33333@Cfffff@C@C     @C@C@C@C@C@C33333@C     @C@C33333@C     @Cٙ@Cٙ@Cٙ@D@D      @C33333@D&fffff@D333333@D@D&fffff@D@D&fffff@D      @D@D      @D333333@D333333@D@D@D     @D@     @D@D&fffff@D@     @DL@D333333@Ds33333@Ds33333@D@D@D@     @D     @D@D33333@D     @Ds33333@D@D@Dfffff@Dfffff@D33333@Dٙ@E@E@E@Effffff@E@     @E&fffff@EL@EY@E     @Es33333@E     @E33333@E     @Efffff@E     @F      @Eٙ@F@F333333@E33333@Efffff@F&fffff@F&fffff@F@F@     @F&fffff@FL@F@     @FY@F     @Fffffff@Fs33333@Fffffff@Fffffff@F@Fs33333@F@F@Fs33333@FY@Fffffff@F@F33333@F@Fs33333@F33333@F     @F     @Ffffff@Ffffff@Ffffff@Ffffff@Fٙ@F33333@F     @F33333@F33333@F     @F33333@F     @Ffffff@Ffffff@Fٙ@F33333@F33333@F     @G@G333333@G&fffff@G333333@GL@G      @G@G333333@G&fffff@G@G&fffff@G333333@G@G333333@GL@GL@GL@GY@GY@GY@Gs33333@G     @G@G     @G@G@Gfffff@G     @Gfffff@H@H@H      @H333333@HL@Hffffff@Hffffff@H@     @Hs33333@HY@H@H     @Hfffff@H@H33333@H33333@I      @H33333@H33333@Hfffff@I      @I@     @IY@I333333@Iffffff@IY@Is33333@IY@Ifffff@I33333@Ifffff@I     @I     @Ifffff@I@I33333@J      @I@I33333@Ifffff@J@J@     @J@JY@J&fffff@J@     @J333333@J333333@JL@Jffffff@Jffffff@Jffffff@Js33333@J     @J     @Jffffff@J33333@K@Jfffff@Jfffff@Jfffff@J33333@J     @Jfffff@K      @K      @K      @K      @K      @Jfffff@J33333@K      @K333333@K      @K      @K333333@K@     @K&fffff@K@KY@K@Ks33333@K333333@K@K@Ks33333@K     @Kfffff@Kfffff@K@K@Kfffff@K     @Kfffff@Kٙ@Kٙ@K33333@K33333@K33333@K@L333333@L      @L@L@     @LL@L333333@L@     @L&fffff@L     @L     @Lfffff@Ls33333@LL@LL@Ls33333@L@Lfffff@Lfffff@Lfffff@L     @L@L@Lfffff@L@Lfffff@M@M      @M      @M@     @ML@M&fffff@M&fffff@M@     @M@M     @Ms33333@M     @M@M33333@M@Ms33333@M33333@M@Mfffff@M@M     @M     @Mٙ@M33333@M@Mfffff@N      @Mٙ@M33333@N      @N@NL@N&fffff@M33333@N@N&fffff@N@N@N@N@N@N@N&fffff@N@N333333@NL@N@NY@Nffffff@NY@N&fffff@N333333@Ns33333@NY@NL@Ns33333@N@Nfffff@Nfffff@Nffffff@N@N@N     @N33333@N     @O@N@N33333@N33333@O&fffff@N33333@O@O&fffff@O@OL@O333333@O@O&fffff@O333333@O@O&fffff@OL@O@O333333@O&fffff@O@     @OL@O&fffff@O&fffff@Offffff@OL@Os33333@O@O@O@OY@Os33333@OY@O@Os33333@Os33333@O@Offfff@O     @Oٙ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ?lD?7KƧ?^5?|?^5?|?+J?$/?o?M?Q?zG?Vt?柾vȴ9?+I^?I^5?`A7?Gz?+?柾vȴ9?Q?dZ1?睲-V?(\)?睲-V?tj~?\(\?n?Gz?KƧ?-?E?"`A?l?E?\(\?Q?+?ffffff?旍O;d?I^5??I^5??5?|h?"`B?nO;?旍O;d?+I?Q?I^5??I^5?旍O;d?旍O;d?I^5??-V?lD?XbM?7KƧ?$/?S?$/?&x?O;dZ?\(?\(?/w?/w?䛥S?Vu?bM?\(?E?9XbN?䛥S?tj~?
=p
?nO?zG?p
=q?;dZ?݁$/?`A7L?lC?;dZ?I^5?}?ə?
=p
?$/?zG{?nO;?Q? ěT?nP?"`?;dZ?vȴ9X?hr!?/v?(\)?Gz?+J?
=p
?tj?$/?$/?tj??|hs?\(?j~#?j~#?tj~?tj?zG{?9XbM?+?tj~?9XbM?l?-V?nO;?lD?-V?-V?tj~?E?hr Ĝ?Q?lD?`A7L?&x?vȴ9X?vȴ9X?vȴ9X?bM? ěT?&x? ěT?;dZ?bM?Q? ěT?Q?5?|h?;dZ?;dZ?;dZ?;dZ?;dZ?5?|h?Q?Q?-V?;dZ?5?|h?-V?-V?-V?5?|h?5?|h?5?|h?5?|h?Q?-V?-V?;dZ?Q?Q?5?|h?5?|h?5?|h?;dZ?bM?5?|h?5?|h?Q?Q?5?|h?;dZ?Q?Q?;dZ?Q?Q?Q?5?|h?5?|h?Q?5?|h?/v?5?|h?Q?Q?;dZ?;dZ?Q?Q?Q?5?|h?vȴ9X?Q?5?|h?Q?Q?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?vȴ9X?Q?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?Q?Q?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?Q?;dZ?Q?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?Q?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?Q?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?Q?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?Q?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ? ěT?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?Q?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?Q?;dZ?vȴ9X? ěT?;dZ?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?Q?;dZ?bM?vȴ9X? ěT?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X? ěT?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ? ěT? ěT?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ? ěT?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ? ěT?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?Q?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?Q?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?Q?vȴ9X?;dZ?vȴ9X? ěT?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?Q?Q?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?Q?5?|h?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?Q?Q?Q?;dZ?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?;dZ?Q?5?|h?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?Q?Q?Q?;dZ?;dZ?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?5?|h?Q?;dZ?Q?Q?Q?Q?Q?;dZ?Q?5?|h?Q?Q?;dZ?Q?5?|h?Q?Q?Q?Q?Q?Q?5?|h?5?|h?Q?Q?;dZ?Q?Q?5?|h?Q?5?|h?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?5?|h?5?|h?Q?Q?5?|h?Q?Q?Q?5?|h?5?|h?Q?Q?5?|h?5?|h?Q?5?|h?5?|h?5?|h?Q?5?|h?5?|h?Q?5?|h?5?|h?Q?Q?Q?5?|h?Q?Q?Q?Q?5?|h?5?|h?Q?Q?5?|h?5?|h?Q?Q?5?|h?5?|h?Q?Q?Q?Q?Q?Q?5?|h?5?|h?Q?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?Q?Q?Q?Q?Q?5?|h?5?|h?Q?Q?5?|h?5?|h?5?|h?5?|h?/v?Q?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?Q?5?|h?-V?5?|h?Q?Q?5?|h?Q?5?|h?5?|h?-V?-V?5?|h?Q?5?|h?Q?Q?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?-V?Q?5?|h?Q?Q?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?Q?5?|h?-V?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?-V?5?|h?/v?5?|h?Q?5?|h?5?|h?5?|h?Q?Q?Q?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?-V?Q?-V?5?|h?5?|h?5?|h?5?|h?Q?5?|h?-V?-V?Q?Q?5?|h?5?|h?5?|h?Q?-V?5?|h?Q?5?|h?-V?-V?-V?5?|h?5?|h?5?|h?/v?5?|h?-V?-V?-V?-V?5?|h?-V?-V?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?/v?-V?-V?/v?-V?/v?/v?/v?-V?-V?1&y?5?|h?-V?/v?5?|h?-V?/v?/v?/v?/v?-V?/v?/v?-V?-V?-V?5?|h?-V?1&y?/v?/v?-V?/v?/v?-V?-V?/v?-V?5?|h?5?|h?-V?5?|h?-V?5?|h?/v?-V?-V?5?|h?5?|h?/v?-V?-V?-V?-V?-V?5?|h?/v?/v?-V?/v?/v?-V?/v?5?|h?-V?5?|h?-V?-V?-V?1&y?5?|h?-V?-V?/v?-V?/v?/v?/v?-V?/v?5?|h?5?|h?/v?/v?/v?-V?-V?/v?-V?-V?-V?5?|h?5?|h?/v?-V?1&y?-V?-V?/v?-V?/v?-V?/v?1&y?/v?/v?/v?/v?-V?/v?-V?-V?5?|h?-V?/v?-V?-V?-V?/v?/v?/v?/v?1&y?/v?-V?/v?1&y?/v?1&y?1&y?/v?/v?/v?/v?/v?/v?1&y?-V?-V?/v?/v?-V?-V?/v?/v?/v?/v?1&y?1&y?/v?-V?/v?1&y?/v?/v?-V?-V?/v?-V?-V?/v?/v?/v?/v?-V?/v?1&y?-V?1&y?-V?-V?1&y?-V?-V?1&y?1&y?-V?/v?-V?-V?1&y?/v?/v?1&y?/v?-V?1&y?/v?/v?1&y?1&y?/v?/v?/v?1&y?(\)?/v?1&y?/v?/v?/v?1&y?1&y?1&y?1&y?1&y?/v?/v?/v?1&y?/v?1&y?1&y?1&y?-V?/v?-V?1&y?/v?1&y?1&y?1&y?1&y?/v?/v?1&y?1&y?1&y?-V?1&y?1&y?/v?1&y?1&y?(\)?1&y?1&y?1&y?/v?1&y?1&y?1&y?1&y?1&y?1&y?(\)?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?/v?1&y?/v?/v?/v?1&y?(\)?1&y?1&y?/v?1&y?-V?/v?/v?1&y?1&y?1&y?1&y?/v?1&y?1&y?1&y?(\)?1&y?1&y?1&y?/v?1&y?/v?1&y?1&y?/v?(\)?1&y?1&y?/v?1&y?(\)?1&y?1&y?1&y?1&y?1&y?1&y?1&y?/v?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?/v                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @H@H&fffff@Cffffff@A@>     @;333333@9ffffff@7ffffff@5@3@3@3L@2     @1333333@1fffff@2@1ffffff@.@,@*@+333333@+      @)333333@'ffffff@&ffffff@$@"@"      @!333333@@@@      @@@@333333@@      @333333@ffffff@      @
@@333333@	@333333@@      @333333@ffffff@@ ?ffffff??333333??      ?      ?ffffff??333333?񙙙?񙙙?      ?      ???陙?陙?ffffff?ffffff?333333?333333?333333?      ?      ?      ?      ?ٙ?ٙ?ٙ?ٙ?333333?333333?333333?333333?333333?333333?333333?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə????????????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	P8                                      1                                       *%BCD z3 m