CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20140212   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P4     CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:40.643919Z    ORIGINAL_HEADER      CTD,20250204CCHSIOWB
#Renamed 'CTDFLUOR_TSG' to 'CTDFLUOR' with units 'MG/M^3'
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20210615CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2014-07-09. CTD data from cruise 18DD20140212, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20140212. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2014-01/donneesctddata/2014-01-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2014-01/index.php. 
#
# The information in this file for the cruise 2014-01 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2014-01/donneesctddata/2014-01-0082.ctd
#
# Start of originator file comment header
#
#*2014/07/09 16:08:49.62
#*IOS HEADER VERSION 1.10 2011/10/26 2011/10/26
#
#*FILE
#    START TIME          : UTC 2014/02/23 16:30:20.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 2081
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : ACD38923
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            3              2104
#       2 Temperature:CTD               deg_C_(ITS90)   1.8242         7.9261
#       3 Salinity:CTD                  PSS-78          32.3708        34.6182
#       4 Sigma-t:CTD                   kg/m^3          25.2476        27.7052
#       5 Transmissivity:CTD            %/m             61.5           68.4
#       6 Oxygen:Dissolved:CTD:Volume   ml/l            0.2            6.7
#       7 Oxygen:Dissolved:CTD:Mass     µmol/kg         8.5            291.8
#       8 Fluorescence:CTD:Wetlabs      mg/m^3          0.86E-01       1.414
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        6  F       ' '     1
#       6  -99   ' '        7  F       ' '     2
#       7  -99   ' '        6  F       ' '     1
#       8  -99   ' '        8  F       ' '     3
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2014-01
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P5
#    EVENT NUMBER        : 82
#    LATITUDE            :  48  41.45000 N  ! (deg min)
#    LONGITUDE           : 127  10.04000 W  ! (deg min)
#    WATER DEPTH         : 2098
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0550
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    CTDEDIT was used to remove some records near the surface and many
#	records corrupted by shed wakes; salinity was cleaned.
#
#    Data Processing Notes:
#    ----------------------
#    Transmissivity, Fluorescence and PAR data are nominal and unedited except that
#	some records were removed in editing temperature and salinity.
#
#    For details on how the transmissivity calibration parameters were calculated
#	see the document Transmissivity_Calculation.pdf.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in the Sea-Bird
#	Application Note #64-2 of June 2012 (Sea-Bird_64-2_Jun2012.pdf), except that 
#	a small offset in the fit was allowed.
#
#    The Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.8 ml/l from 0 to 100 dbar.
#	±0.6 ml/l from 100 dbar to 300 dbar.
#	±0.2 ml/l from 300 dbar to 800 dbar.
#	±0.05 ml/l below 800 dbar.
#
#    The primary Salinity:CTD channel was used for events 0041 and 0043, so 
#	it was recalibrated to match the secondary channel which was selected for
#	all other casts.
#
#    For details on the processing see the report: 2014-01-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5-- --6--- --7-- ---8---
#!Pressu Temperat Salinity Sigma-t: Trans Oxygen Oxyge Fluores
#!re:CTD ure:CTD  :CTD     CTD      missi :Disso n:Dis cence: 
#!                                  vity: lved:  solve CTD:   
#!                                  CTD   CTD:   d:CTD Wetlabs
#!                                        Volume :Mass        
#!------ -------- -------- -------- ----- ------ ----- -------
#*END OF HEADER
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @*         data_max      @*         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     (0  .L   pressure                	long_name         pressure   positive      down   units         decibar    data_min                 data_max      @x        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      (0  V|   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      
  ~   temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      @ᰉ'R   data_max      @ zQ_   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       (0     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      
     salinity                	long_name         salinity   units         PSS-78     data_min      @@%F
L   data_max      @A>iB   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      (0     salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      
  $   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @   data_max      @r#33333   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        (0  0   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      
 `   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?+   data_max      ?KƧ   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      (0 l   CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      
 G   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       (0 Q   PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d      
 y   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min                 data_max      @Q&fffff   C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     (0    CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d      
    station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         (     cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( H   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      k   data_max      k   C_format      %10d       p   latitude               	long_name         latitude   units         	degrees_N      data_min      @HSI'>   data_max      @HSI'>   C_format      %9.4f          t   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      _vȴ   data_max      _vȴ   C_format      %9.4f          x   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3P   data_max      3P   C_format      %8d        |   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d        @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @*              ?      @      @      @      @      @      @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @0     @4     @8     @<     @@     @D     @H     @L     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           @F
L/@F
L/@E84֡@ES&@EQ@Eo i@D*0@DJM@ES&@Em\@E84֡@E84֡@Em\@E@ES&@EQ@ES&@E@F
L/@F
L/@F?@ES&@E@F
L/@En/@En/@DS@DJM@D*0@DJM@Eo i@EQ@Eo i@DS@D*0@J	 @JL_@P)^@TzG@U=K@cwk@}p
=@L_@b}@8Y@u@ F
L0@ ~($@ )7KƧ@ En/@ a7Kƨ@ vE@ zQ_@ sߤ@ fx@ a@N@ V@ H	ԕ+@ F-@ GK]d@ H˒:*@ I*0U2a@ Iԕ*@ JڹY@ KƧ@ Lzxl"@ EQ@ 3g@ 2S&@ 1N;5@ *JL@ %S@ #Z@ !-w1@ vȴ9@ iB@ >@ /V@ #x@ eں@ GE85@ 
C\@ )^@s@.H@ +a@ 	*0U2a@ 

qv@ u!S@ Q_@ u!S@ S@ @E@O;@ⶮ}Vm@6@ᰉ@ѷX@m\@C,z@)y@Vϫ@\(@ 
=p
@唯O
@D@/V@m8@S&@vȴ9X@  hۋq@ Zc@ /{J#@ c	@ 
0U2a|@V@VϪ͟@S@[6@_حV@e`A7L@nH@|PH@JM@s@sP@}Vm@ۋq
@ᰉ'@t@oiDg8@{@2W@g	l@֡a@3@쿱[@=b@{m@Z@|64@jJL@JڹY@A [7@*JL@"}Vm@@,zxl@z@JL@'RT`@ҽ<64@-
@ěT@4J@$/@rW@=H˒@..2@+jf@'@$7@"wkQ@"3@ d8@O
M@m\@!.H@1@.H@ۥS@Xe,@'/W@g8}@m]@#w@ᰉ'@`A@@\(@{5Xy@or@`	k@NT@6C-@&L/{J@!@N@u%@Ʌoi@8YK@ hۋ@҈p@ܑN;@@qiC@64@ ě@eO@R<6@fA@N;6@Vu@ԕ*@:S@4m9@rGE85@k~($@kjf@lq@mV@m\@m(@e`A7L@[q@S@N@KC%@D2W@=b@1[W>6@IQ@ݘ@)^@
:@]cf@[W>@!-w2@D*@_o @y@@@@RS&@B@0U2a|@)*0U2a@-V@(@@&@Ʌoi@O;d@PH@!'R@3@@6@B\(@B ѷ@>($x@6+jg@)y@"e+@C,zx@@	'RTa@_o@&I@Q@nP@ n@BZc @dZ@)@ȴ9X@PH@
(@C@JL@e@ڹY@@@RT`e@xF@S@d8@wkP@@@@@y=c@ݘ@y=c@>6z@n@]cA@˒:*@tSMj@sg	l@q2W@pD@oiDg8@nH@lVϪ@dZ1@]IQ@TE@Hu%F@9D@2{m@0
=q@.zG@,1&y@)@',@'/V@%@%u@!e@e+@l!-@<64@
@@^5?|@iDg8@唯O
@c	@'/W@2W@$t@s@#w@SMj@[W?@@$xG@x@ڹ@Z1@Gz@1'@T@74@wKƧ@rm\@oVϫ@l>B[@ix@h@ae@W@M(@IoiD@B@A7Kƨ@ATɅo@A$/@?H˒:@43@/iDg8@+C,z@*Ov`@'-@ [6@Ʌoi@	 ѷ@@74@!-w2@\)@e@}H@
M;@n.@v@r Ĝ@TɆ@1@IQ@@@L_@@ݗ+@ѷX@u\(@sg@h>BZc@_?@Zݘ@V@S҉@PbM@Dg8}@873@"e+@4J@҈@	'RTa@o h@2W@%2@74@@4n@$/@Zc@ 4m@ 4m@@
(@?@3@ ě@1@o@o@Z@̲@҈@ˬq@ԕ*@@y@š@©@	k~@Ft@H@7Kƨ@y#w@Ye+a@N+@EoiDg@8-
@.t@$TɆ@l!-@$tT@
#9@ ѷX@\(@tSM@?@/w@ ѷY@Ƨ@YJ@ hۋ@[W?@C]@jf@U=@\)@O
@Gz@Q@ߤ@@_o@e+@)^@=p
@@_o@Q@@{s@u?@rm\@o{J#:@n2X@hXy=@f@eڹ@be+@[$@Xe+@WO;d@TzG@QX@JD@GK]d@ES&@?$tS@9D@5?|h@0 ě@*fB@&x@$qj@"wkQ@af@
=p
@K]c@2W@.H@b@n.@)_@)_@73@\(@ᰊ@fB@e@"`B@_o@l!-@@rGE9@*0@hr@Fs@o@I^@^@Z1@kP|@fA@C%@tj@zG{@p'RT@ix@cn.3@Zvȴ@O\(@H1&x@Eݗ@C%2@=!.H@6_ح@+~($@S@2a|@;5X@+@cA \@	@84֡@O
M@fB@ae@,<@և+J@|@̲@y@F]c@/V@{m@r@x@	ԕ+@wkP@+@tj~@@ѷX@qiB@dTɆ@]ce@M(@H@Gy@Ca@N@;s@3MjO@.1@-U=@*0U2a|@,q@(>BZc@#S@҉@Vl!@1&y@Y|@Y}@{@`A@҈p;@ܑN;@ڹY@>BZ@ֻ@zG@nO@sP@nO@"@{@0
@O
@(\@䎊@@҈@@mw1@W+j@U2a|@TZ@Uᰉ@`[6@fIQ@l"h	ԕ@n1@w+@,zxl@@
L/@@F]c@n.@hۋq@{A@q[W>6@f'@R䎊@C,zxl@&fffff@ ѷY@$/@*0
@.2X@3ߤ@74m@7Xe@7KƧ@8)@3MjO@)B@!Gz@ ѷY@/w@(\@JE@`d@hr @H@qi@
O;dZ@L_@C%@	Q@1&x@-@
L/@@$t@)_@2W@>B[@V@@C,@(\@+j@R@*0U@~($x@xF]@84֡@C\@SMj@&x@C@wkQ@=K^@+@b}@tj@af@Ʌoi@*0U2@X@(@ڹY@n/@TɅo@vC-@vC-@wKƧ@v4K@tm8@q2W@n2X@mhr!@j0
@iDg8~@iB@iy@j0U2a|@ix@eڹ@cS&@\1&@Qhr @=b@6!.I@9~($@2ᰊ@-8Y@+U=@#	@5?|@qi@xF]@@n.@eں@{@U=@fB@RT`e@lC@ڹ@`A7L@F
L0@u@@e@tSM@䎊qj@?@3@䎊r@;dZ@ݗ+j@ڟvȴ@Ϫ͟@՛=K@@&@H@ϐ@cA \@H˒:@@+j@҈p;@u%F@'/W@@Q@6@~"@@$/@:S@|Z@s33333@lzxl"@de@^iB@bh	ԕ@^쿱[W@^Q@ceO@][@VOv_@KC%@EQ@7Xe@*0@$/@p
=@}H@ߊ	@*0@ѷX@\(@@xF]@W'@	 @ɠ'RTa@@Ǔݗ+@żn/@\(@|hs@ߤ?@C\@(@"`@C\@F@ߤ@U2a|@t@zxl"@!-w@O;@Vϫ@ ě@iDg8@1@q@~($@"h	ԕ@(@"h	ԕ@~($@fB@͞&@Ov`@	ԕ+@zxl"h@|Q@ce@(\@vȴ@U@R<6@L_@Mj@u@)^@@p:~@jOv@5Xy>@qu"@@qu"@@~($x@'RTa@Zc@|n.@{m]@u?@p
=q@ql@kQ@irGE@glC@fL/{J@dxF@\]ce@Y+@W>6z@WsPH@T`d@TO
M@S&@RnO@QN;5@Oo @KC%@GK]d@C\N@@IQ@>
(@:G{@5%F
L@..2@',@"`A@쿱[W@O
M@fA@R<6@n@
@S&@@PH@!.@4֡a@>BZ@sPH@š@S&@)_@j~#@b@}H@y=b@kC]@c	@["`B@L/{J#@@NU@$?@ݗ+k@L_@($x@%1@,<@@2W@)@Xe@vȴ9X@84֡@̘_@W>6z@%2@'/@N;6@@N@
L/{@@C@	k@唯O
@e@A7K@حU@2a|@ӎMj@*0U@ɅoiD@|hs@^5?|@Y}@)@֡a@|@a|Q@V@wkQ@,<@N;6@@M:@Fs@|hr@v!.I@tD@sE@rs@`u!@U=K@T,<@XU@T,<@Ov_ح@G@@E84֡@;A@5?|h@+a@@+6z@(\)@$xF@U=@6C@sh@O
M@Fs@$/@
l@
8YK@
[@
wkP@
wkP@
@
Xe,@
@N@
҉@
ݗ+k@
Z@
@
hr @
M:@
~"@
y	k~@
y"`@
w1@
vFs@
u!.@
u%F
L@
pD@
p@
oiDg8@
gfA@
f1.@
poiDg8@
rs@
r䎊q@
r䎊q@
m\@
bC,@
[$@
T,<@
MjOv@
IQ@
?@
6}Vl@
64K@
6E@
9XbM@
:~@
:~@
<j~#@
;dZ@
9Y}@
9XbM@
74m@
6z@
5'0@
2W@
0U2a|@
.2X@
*0
@
U=@
tj@
O
M@
rGE9@

O;dZ@
	 @
I^5@ڹZ@_ح@j~@GE85@(@g	@rGE@fA@ڹ@A@Z1@	@ⶮ}Vm@6@l!-@ӎMj@ȴ9Xb@vȴ9X@#w@/V@TɆ@TɆ@h	ԕ@Ov_خ@Q@_F@S&@K]d@{s@tj~@qu!S@mC\@h@h@h@eO
@_o@XD*@TE@R<64@Ov_ح@Gy@?[W>@6E@/O
M@&IQ@@4n@J#9@C]@;dZ@n@Zc@S@@w1@o-V@kQ@cS@M%@HK]c@F-@C@B&IR@@n@=<64@8}H@5Xy=@3ߤ@0U2a|@/r@.}Vl@,1&y@(\)@$TɆ@%@u%F@ ѷ@
!.I@
{m@
 hۋ@
P{@
B@
Dg8~@
ۋq
@
빌~($@
 hۋ@

=q@
A [@
GE85@
SMj@
#@
Fs@
+@
	k~@
E@
C\@
@
S@
Ft@
>6z@
|@
ʌL_@
74@
TɅo@
b@
4K@
a|Q@
H@
͞&@
wkQ@
[6@
-
@
'RT`@
)^@
$tS@
yrGE8@
u\(@
tj~@
kQ@
^5?|@
PH@
C\N@
C$@
As@
B\(@
B@
ATɅo@
5?|h@
%u@
u%@
6C@
@@
$/@
*0@
sP@
n@
$tT@
4J@
n@
҉@
*0U2@
S&@
:)y@
hr @
n@
\(@
L_@
q@
xF]@

qiC@

=p
@
	'RTa@

=p
@
u%F@	.H@	\(@	A [@	JL@	@N@	Ƨ@	o i@	&IR@	n@	[W>@	<64@	쿱[@	n.@	C-@	9XbN@	֡a@	33333@	ᰊ@	a|Q@	
(@	r@	lD@	@	^@	$xG@	RT`e@	tSM@	-
@	L_@	~($x@	#@	 ѷ@	hۋq@	~$t@	}Vl!@	y	k~@	h>BZc@	Ov_ح@	M:@	Ks@	Fs@	A [7@	?|hs@	>vȴ9X@	>
(@	=v@	=<64@	;/V@	9~($@	:^5?|@	5sg@	7Xe@	6z@	5Xy=@	3ߤ@	0 ě@	-
qv@	+6z@	(@	&L/{J@	#
=p@	Q@	Fs@	'/W@	YJ@	 hۋq@-
@\(@SMj@D@@8Y@fA@
qu@>6z@E@`d@:@@ɺ^5?}@)^@J@0U2a|@
qv@u"@҉@C%@n/@{J#9@y"`@jfB@[6@XbM@F
L/@;5Xy@8Q@&IQ@&IQ@e+a@SMj@m@O
M@vȴ9@hr @'/@Q@4m9@}ڹZ@|?@{J#9@w+@qiB@dZ1@I@73@!-w1@+j@
=p
@Fs@M:@E@F]d@iDg8@7@ᰉ'R@@4                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @@%F
L@@˒:)@@$ߤ@@@$/{J#@@$`d@@$o h@@$~($x@@$wkP@@$N;@@$zxl"@@$Z@@$E@@$D@@$@@$Z@@$>@@$e@@$e@@$hr@@$hr@@$/@@%o i@@$Z@@$@@$D@@%K]@@%@@&E@@&1.@@&BZc @@&IQ@@&ߤ?@@'@@'As@@'U=@@('RT@@(U@@)JE@@)iB@@*I^5@@+P{@@-H˒@@.'@@/o@@0-
@@3|@@73@@9-w1@@AJE@@H     @@Py=c@@[n.3@@o!-w1@@ub@@z~"@@}u@@vȴ9@@@4@@u"@@m\@@b}V@@@@@r Ĝ@@	k~@@[W>6@@#9@@PH@@hۋq@@Q_@@[W?@@?@@l@@Ƨ@@IQ@@As@@-
q@@U@@҉@@o@@A [@@Ov`@@ ě@@C%@@Ʌoi@@쿱[W@@@@:~ @@4֡b@@u!S@@1&y@@S&@@I^@@~@@@@©@@p:@@vȴ@@33333@@cA \@@%F
L@@A@@@@rGE8@@I^5@@g@@̋C@@>@@A@@Ѡ'RTa@@ҟvȴ@@u%@@MjO@@Ӣwk@@O;dZ@@b@@ ѷY@@fA@@}H@@4K@@&I@@'/W@@׍O;d@@1&x@@rGE@@٣n.@@Ov`@@n@@+a@@l!-@@@@[6@@Zc@@L/{@@`A@@]cA@@*0U2@@2W@@֡a@@$t@@'/W@@@@rG@@D*@@Dg8~@@ԕ*@@MjO@@JM@@T@@ߤ?@@As@@ݗ+@@rG@@Xy=@@_p@@u@@N;6@@I^5@@kP|@@Ƨ@@n.@@Z1@@TɆ@@[W?@@/@@Z@@hr@@Vl!@@C\@@
L/@@H@@+J@@af@@-@@@@@@&I@@A@@Ϫ͟@@Ϫ͟@@҈p;@@1@@1@@ߤ?@@Ϫ͟@@&I@@ȴ9X@@6z@@'@@m\@@Ϫ͟@@Xe@@y@@ݗ+@@ݗ+@@[W>@@@@4m9@@eO@@r Ĝ@@eO@@|@@{@@\)@@[W>6@@o@@#9@@͞&@@D@@҉@@nP@@nP@@,zxl@@6z@@@@m]@@~($@@5Xy@@lC@@$@@(\@@`d@@]ce@@j~#@@tSM@@o h@@C@@3@@N;@@wkP@@q@@m8@@M:@@|@@6z@@PH@@G{@@G{@@nP@@=K^@@F]c@@@N@@MjO@@\N@@xF@@]ce@@>@@!R@@H˒@@oiDg@@@@$/@@?@@H@@R<6@@_ح@@p:~@@iB@@iB@@s@@l!-@@iB@@s@@IQ@@@@O;@@af@@6z@@@@@@T@@af@@Fs@@'@@1@@쿱[W@@1@@]cf@@]cf@@ȴ9X@@t@@C-@@)^@@.H@@>6z@@E84@@E84@@Xe,@@b}V@@b}V@@\(@@\(@@Xe,@@_o@@b}V@@b}V@@b}V@@b}V@@lC@@sPH@@v_ح@@y@@4m@@4m@@$tS@@zH@@͞@@/V@@vȴ9@@+@@@@fA@@fA@@حV@@@@@@rG@@#@A F]d@A 	ԕ+@A *0U@A  ě@A 1&x@A :~ @A A7K@A A7K@A H@A H@A Q@A [6@A hۋq@A hۋq@A YJ@A IQ@A 
(@A 4m@A 
(@A TɅ@A )^@A p:@A ѷX@A @A ѷ@A@A#w@A*0U2a@A0
)@A0
)@A-w1@A7KƧ@AJE@ATɅo@Ae+a@A^@Ahr @Ax@Ab}@A7Kƨ@A|Q@A|Q@A@A@Au@Al@AB@A@AB@AX@A'RTa@A(@Al@A^5?}@AD@Ay@A"`@AiB@AI^5@A0U2a|@A0U2a|@AqiC@A~"@A@4@Ap:@A0
@AL/{@A'/@A&@A=K^@AS@AdZ@Ag	l@A~$@A{J#9@A~$@AQ@AQ@AeO@AeO@AQ@AQ@A~$@AQ@Aq@AMj@A@A~$@A*0U2@AQ@A/{J#@AFs@ASMj@AZ1@AtSM@A?@AN;@A쿱[@AO
M@A*0@A'0@Aqu"@AF
L0@A!R@A
qv@AC\@Au@AH@AYJ@AiB@Afffff@AiB@Afffff@AOv_خ@AVu@Ac	@As@A@A@A҈p;@Aȴ9X@A2X@A-@A-@A}Vl@A2X@A'@Am\@A҈p;@A+@AC-@AC-@A]cf@AMj@A
=p@A@Av@A!-w1@A$tS@ART`e@A\(@AlC@Av_ح@AsPH@A&@AO;d@A@A$tS@AzH@AzH@Ar@A/V@A˒:)@A@A+j@A     @A     @A@A*0@AK]c@AbM@Au!@Au!@Atj@A)^@AѷX@Ap:@A҈p@Ae+@A	@A	@A	@A	#w@A	Gz@A	^@A	|Q@A	'R@A	ᰉ'@A
u%F@A
n@A
s@A
1'@A
-V@A
W'@A
kP|@A
{m@A
S&@A
@A
 ě@A
,<@A
䎊q@A
m@A	@A9@AW>6z@An.3@A~$@Awk@AZ@A
=p@Aݗ+k@Aݗ+k@AlC@A$@A$@A(\@AcA \@Aq@A#@AO
M@A/@A!-w@A
Q@A
w1@A
$/@A
-V@A
?@A
(@A
L/@A@A+jg@A;5X@A_ح@AiB@AiB@AiB@AiB@As@Ap:~@Ap:~@As@Aqi@AIQ@A}Vl@Az@AYJ@ABZc @A;5X@AOv_خ@AE@A8YJ@A5?|@A5?|@Afffff@A'@Ax@A쿱[W@A]cf@A@A2X@A hۋ@Ar@AحV@A˒:)@A@@A䎊r@A#@A     @AbM@A6@AoiDg8@A4m@A)^@A\)@APH@A$/@A@A@A	k~@A	k@A	k@A_p@A	k@A@A@A@AѷX@AGz@A|Q@Ao@AlD@A^5?|@A<64@A:)z@A@A/{J#@APH@APH@A64@A`d@Aj~#@Ag8}@A]ce@ASMj@A?@A(\@AcA \@Azxl"@Aj~@A>B[@Ae@AK]@A[@A%F
L@A/w@A/w@AF
L0@AS&@AVl!@AY|@AjOv@A$/@A!R@Ahr!@A%@A@A1@AU=@A@A@A\(@A@A
qv@Aᰉ@A ѷY@A$/@A.2@A8YJ@A\N<@As@A$t@Aaf@At@A҈p;@Aߤ?@Aȴ9X@A1@A
=p@AKƧ@AU=@AH˒:@AAs@AKƧ@A_o@Av_ح@A&@Ar@A@Ao @AfA@A-@A@A*0U@A
qu@AbM@A'RT`@A73@AeO@Atj@ATɅ@Aۋq
@A҈p@A@AA [@AQ@AXbM@A[W>6@Au!S@A@Al@AN;6@A	 @Aa|Q@AkP|@A^5?|@A\(@AS&@A}Vm@AC,@As@AS@Aa@N@Aqu!@A$@A5Xy@Ag@AC]@As@An.@AJ@A1&y@AJ@A@A@Aߤ@@AL_@A@AxF@AL_@Aߤ@@Aߤ@@A@A%1@A2W@AFs@AM:@A]ce@AcA \@A_@A쿱[@A@ATɆ@Aqj@AS@Ao i@A84֡@AIQ@AL_@Azxl"h@Ahr!@AU=@A
qv@Aڹ@A
L/@Au@A
(@A ѷY@AoiDg@A ѷY@A.2@AYJ@A,<@AMj@A!.I@A+I@A!-w1@A,@A,@A]cf@AIQ@Al!-@Ac	@A@A@AO
M@Ao@A?@A;dZ@A-@ArGE9@A#@A      @A 	ԕ+@A >BZc@A |@A d8@A ěT@A \)@A!+@A!+@A! [7@A!*0U2a@A!4J@A!:S@A!A [@A!JE@A!ae@A!b}@A!l@A!y@A!"`@A!R@A"@A"1'@A"-V@A"L_@A"0
@A"S&@A"g	@A"}Vm@A",<@A"c	@A"m\@A#҉@A#)^	@A#,zxl@A#@N@A#J#9@A#g	l@A#qu!@A#Mj@A#6@A#5Xy@A#5Xy@A#҈@A#g@A#A [@A#@A$n.@A$xF@A$L_@A$,<@A$M:@A$#@A$7@A$j~@A$hr@A%V@A%V@A%5Xy>@A%84֡@A%Vl!@A%jOv@A%M:@A%sh@A%@A%S@A%oiDg@A&
(@A&4K@A&;5X@A&Vu@A&iB@A&z@A&}Vl@A&m\@A&t@A&m\@A&&I@A&m\@A&+@A&ߤ?@A&쿱[W@A&!.I@A&@A' hۋ@A'@A'Xe,@A'&@A'$tS@A'zH@A'@A'fA@A'Vϫ@A(     @A'@A'rG@A'@A'#@A(bM@A( ě@A(4m9@A(r Ĝ@A(U2a|@A(:~ @A(4m9@A(*0@A(6@A( ě@A(-
q@A(bM@A(y=c@A({@A(ۋq
@A(@A)+@A)#w@A)XbM@A)[W>6@A)|Q@A)'R@A)ᰉ'@A*6C@A+I^@A+9@A+eO@A+|@A,n.@A,I^5?@A,tSM@A,o h@A,#@A,o h@A,*1@A,O
M@A,@A,?@A,7@A,/@A,E@A-*0@A-[@A-%F
L@A-(@A-/w@A-+a@A-B@A-\@A-ce@A-jOv@A-sg@A-ݗ@A-O
@A-=K@A-+j@A-hr!@A-hr!@A-O
@A-1@A-sh@A-\(@A.($x@A.?@A.L/{J@A.fffff@A.p:~@A.%@A.@A.$t@A.Fs@A.@A.m\@A.t@A.ߤ?@A.x@A.x@A.@A/+I@A/>6z@A/H˒:@A/U=@A/Xe,@A/eں@A/iDg8@A/iDg8@A/o@A/o@A/v_ح@A/{J#:@A/&@A/-V@A/?@A/?@A/	k@A/kP@A/-V@A/O;d@A/-V@A/[W>@A/@A/Vϫ@A/Vϫ@A06@A0*0@A0-
q@A0Q@A0Xy=@A0_F@A0|@A0tj@A0u%F@A0d8@A0{@A04m@A0)^@A0D@A0҈p@A0e+@A0҈p@A0e+@A0e+@A0@A0$tT@A1 [7@A1 [7@A1#w@A1*0U2a@A1=b@A1Dg8~@A1N;5@A1Q@A1hr @A1@A1~($@A1@A1R<6@A1u@A1R<6@A1o@A1@A1n.@A1'RTa@A1(@A1B@A1X@A1^5?}@A1@A1y@A1y@A1_o@A1o@A1o@A1ԕ*@A1ԕ*@A1iB@A1@A2u%F@A2I^5@A2)y@A20U2a|@A20U2a|@A23@A2=p
@A2C\@A2Q_@A2Zc@A2u%F
@A2\(@A20
@A2@A2Y@A2W@A2sP@A2c	@A3'/@A3)^	@A333333@A3@N@A3MjO@A3a@N@A3~$@A3eO@A3q@A3q@A3@A3]cA@A3P{@A3a@N@A3q@A3q@A41&y@A4"h	ԕ@A4tj@A4Q@A464@A4wkP@A4TɆ@A5K]@A5V@A5V@A5u@A5*0@A5*0@A5Q@A584֡@A5B@A5O;dZ@A5`A7L@A5fA@A5ce@A5m\@A5zxl"h@A5$/@A5O
@A5!R@A5hr!@A5v@A5@A5-V@A58Y@A5cA @A5E@A5ڹ@A6@A6($x@A6+jg@A6.2@A68YJ@A6H@A6Ov_خ@A6H@A6Vu@A6fffff@A6T@A6}Vl@A6@A6ȴ9X@A6ȴ9X@A6+@A6@A6"@A7
M;@A7@A7
=p@A7v@A7$tS@A7.H@A7;dZ@A7U=@A7\(@A7KƧ@A7RT`e@A7|hs@A7$tS@A7	k@A7͞@A7	k@A7r@A7@A7-@A8	ԕ+@A8@A8	ԕ+@A8
qu@A8bM@A8bM@A8*0@A8K]c@A8[6@A8Xy=@A8_F@A8l"h	@A8oiDg8@A8oiDg8@A8y=c@A8y=c@A8|@A8y=c@A8|@A8r Ĝ@A8|@A8|@A8|@A8YJ@A8'RT@A8@A8@A8YJ@A8@A8@A8-
@A8-
@A8-
@A8
=q@A8)@A8)@A8ěT@A8ۋq
@A8$tT@A9@N@A9rGE@A9+@A9+@A9@A9@A9@A9&x@A9-w1@A9*0U2a@A90
)@A94J@A9:S@A97KƧ@A9:S@A9Gz@A9JE@A9Gz@A9JE@A9Dg8~@A9N;5@A9XbM@A9k~(@A9|Q@A9oiD@A9@A9o@A9@A9u@A9n.@A9o@A9>BZ@A9>BZ@A:n@A:n@A:n@A:	 @A:n@A:n@A:u%F@A:n@A:I^5@A:@A:-V@A:)y@A:I^5@A:e+@A:#9@A:䎊@A:-V@A:-V@A:3@A::)y@A:=p
@A:@4n@A:Q_@A:W'@A:^5?|@A:{m@A:p:@A:\(@A:wkQ@A:0
@A:L/{@A:L/{@A: ě@A:<64@A:n@A:,<@A:sP@A:,<@A:ڹY@A:䎊q@A:fB@A:m@A;	@A;&@A;@N@A;S@A;dZ@A;g	l@A;jf@A;jf@A;~$@A;$@A;E@A;E@A;Q@A;C]@A;C]@A<@A<tj@A<,<@A<#@A<7@A<e@A='0@A=qu"@A=/w@A=IQ@A=L_@A=L_@A=O;dZ@A=L_@A=Vl!@A=\@A=zxl"h@A=v@A=@A=(@A=E@A>
L/@A>@A>u@A>.2@A>?@A>R<6@A>c	@A>fffff@A>iB                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @qA@q33333@r@r#33333@r@r@r!@r!@r33333@rfffff@r     @r@r!@r      @r!@rfffff@r@r@r@r!@r!@rfffff@r      @r!@r33333@r	@rfffff@rfffff@r	@r@qfffff@q33333@q@q񙙙@qfffff@q@q@q@qᙙ@qᙙ@qfffff@qA@q	@p@q     @q8     @qQ@qY@n     @l     @k@jl@j6fffff@j     @j33333@j      @j      @i     @i33333@ifffff@i@i     @i     @ifffff@i33333@g@gC33333@fə@fc33333@f33333@eə@e@e     @ffffff@f33333@d0     @cfffff@cc33333@bfffff@b     @b     @b33333@bFfffff@b#33333@bFfffff@b     @b     @bfffff@b      @a@a     @a33333@avfffff@ay@a@a@afffff@`@`fffff@`fffff@`33333@`@`c33333@`fffff@`@`@`33333@`@     @`9@`@     @`<@`6fffff@_33333@_      @^33333@\33333@\@\@\fffff@\@\@\33333@]      @]`     @^fffff@^&fffff@]     @^fffff@]fffff@]fffff@]33333@]@]l@]333333@],@]@]fffff@]Y@]Y@]`     @]l@\33333@\33333@[fffff@Y33333@Xfffff@Xs33333@X&fffff@Wfffff@W@X33333@X9@X&fffff@X      @X      @X@W@W     @W     @W     @W@W@W@W     @W     @W     @W     @W,@V@Vٙ@V@Vfffff@V@V     @V@V@Vs33333@V@     @V333333@Vl@VY@XY@Yfffff@Y      @Yy@Yl@YY@Y9@Yfffff@Y33333@X     @Xfffff@X     @X@XS33333@XS33333@XL@W     @W@W     @W9@W333333@V     @V`     @U     @U      @U&fffff@T33333@U      @T33333@Tfffff@Tfffff@T33333@T33333@T33333@T33333@T     @T@Ty@T     @T     @Tfffff@Ty@T@T@T@T@T     @Tfffff@U33333@U@V&fffff@V@VFfffff@Vy@VS33333@V     @Vffffff@VY@Vl@Vs33333@V@T@S@S`     @S@     @R@S      @Sfffff@SFfffff@Sy@Sl@S@R     @R@S&fffff@Sfffff@R     @S@     @Sfffff@R33333@S@Sfffff@R@R@Rfffff@Rٙ@Rfffff@R33333@R     @R33333@Rfffff@Rfffff@R`     @Rfffff@Rfffff@R33333@R33333@RY@Rfffff@R@     @RY@RS33333@R,@RY@R,@R333333@R9@R33333@RFfffff@R,@R      @R      @R333333@R,@Q@Q@Q@Q     @Q@Qfffff@Rfffff@Qfffff@Qٙ@Q@Q@Qfffff@Q@Q     @Q33333@Q33333@QL@Q@Q33333@Qfffff@Q,@Q9@Q&fffff@Q      @Q&fffff@Q333333@Qfffff@Q      @P@Q@P33333@Q33333@Q      @P     @P@Pfffff@P@Pl@Pٙ@P@Py@P@P     @PY@PFfffff@P@     @P@PL@P,@P      @P33333@P&fffff@P      @P@P@     @O@Oٙ@O33333@Nfffff@P      @Pfffff@OY@O@Oٙ@Offfff@O@N@OY@N     @OL@OY@Nfffff@Nfffff@O333333@N     @N33333@N@Nffffff@Ns33333@M33333@Mfffff@Mffffff@MY@M33333@Mffffff@M@M@ML@M333333@LY@L@     @L&fffff@Kfffff@Kٙ@L&fffff@K33333@L@     @Ks33333@L333333@K33333@Kfffff@LL@L@Kfffff@K33333@L      @L@Kfffff@K33333@KY@K      @Jٙ@JL@K     @J@Jٙ@J     @J333333@J@Ifffff@I     @I&fffff@I     @I     @I&fffff@Ifffff@Gfffff@Gs33333@Gs33333@Gfffff@GL@G@     @Gs33333@G     @G     @G     @G@F     @F@Ffffff@Fٙ@Fs33333@F     @F@Ffffff@G&fffff@FY@F333333@F@F33333@E33333@Es33333@G      @FL@F333333@F     @Eٙ@Efffff@F@Es33333@Eٙ@E&fffff@E&fffff@F      @E     @Es33333@Es33333@Efffff@EY@Dfffff@EL@E     @D@E@Dfffff@Dٙ@D@EL@Dfffff@D@D@D@     @D333333@C     @D@D&fffff@C     @D@     @D333333@C@DL@DL@C     @Cfffff@B@C@B@B@B33333@Bٙ@B@B@B     @Bfffff@Bfffff@B     @BL@B&fffff@A@B&fffff@A     @A@     @BL@A@B@A33333@@ٙ@@fffff@A@@@A@@33333@@s33333@AL@A      @@33333@@33333@@fffff@@@?     @?@@      @@L@?33333@?     @?333333@?333333@>ffffff@?@>@=@>@=33333@=@>@>@=@>      @>ffffff@>      @=@=     @=@=@=ffffff@<@<@=L@=@<33333@<ffffff@=      @<@;fffff@<@<L@<L@;L@<      @;     @;ffffff@;33333@;L@:@;      @:@9333333@:      @9333333@:     @:ffffff@9@:333333@9ffffff@9@8L@8@8@8ffffff@9@8     @7fffff@8L@833333@8fffff@8ffffff@8fffff@8      @8L@7fffff@6      @7333333@5@7     @5L@4fffff@5@6@5@6L@5     @5L@4@5333333@5L@5      @533333@4@433333@5      @4@4L@4     @4@4L@4@4     @4     @433333@4fffff@4     @4      @4333333@4333333@4333333@3@4333333@4333333@4333333@4333333@333333@3@3@4L@4      @3L@3      @3@333333@3L@4@2@2@3@2fffff@2@1L@2@1@1@2@2@233333@2L@1ffffff@2@1@/ffffff@1@1fffff@1@1fffff@1@033333@1333333@2      @1@0      @1@.@1      @0@0@1333333@1      @0@/333333@0ffffff@0     @0L@0L@.ffffff@/ffffff@0333333@-      @/@-@.      @/      @-@/@,333333@-333333@+@+ffffff@/333333@)333333@,@-333333@+333333@+ffffff@-333333@,@,@+ffffff@-      @,ffffff@+ffffff@-ffffff@+333333@,ffffff@+@+      @,      @+ffffff@,      @*@,ffffff@*ffffff@*@*@+333333@+ffffff@)ffffff@*333333@*@)ffffff@*333333@)      @*@(      @*333333@)      @)@*ffffff@*      @(333333@)@&@*      @*      @(333333@)ffffff@(@'@%@*      @'ffffff@)ffffff@(      @+ffffff@(ffffff@'@)      @&@)@'ffffff@(      @(@'333333@(      @(      @(      @(      @'@&@'ffffff@&@'@&ffffff@&@%@&ffffff@&@&@&@&      @(      @&@$@%@)ffffff@&ffffff@&ffffff@%333333@'      @$@$333333@%ffffff@&      @%@$@&      @%      @$333333@&@%      @"      @)      @#@$@$@%@$ffffff@%333333@$@$333333@&@%333333@$333333@$ffffff@#@$ffffff@$      @&      @#@$333333@%@%@$      @#333333@$333333@&@!@'333333@333333@%      @&333333@!@$      @#@"ffffff@#ffffff@"      @'333333@ @#@#@"ffffff@(333333@       @"@$@#@#333333@#ffffff@$@#@#@"@%      @#      @$      @"333333@#ffffff@#@"      @&@"      @!@"@#333333@#@"@"@$      @#      @$      @"@#333333@$333333@#@#ffffff@#      @#      @$ffffff@#      @!@"@%333333@$      @$      @#ffffff@"@$ffffff@$@&ffffff@)      @!@'@$      @$      @$      @$      @$      @%333333@#333333@$@#@$@%      @$@$333333@"@%333333@%@"      @"333333@&@(@ ffffff@"@#333333@'333333@@%ffffff@$@'      @#333333@$333333@$@#@&333333@#ffffff@&      @$@$@$@#@$@$@%ffffff@$@$333333@%@$ffffff@#      @&@$@#@$      @$@$@#@&      @$@%333333@"@%@$@%      @%333333@$@$      @%ffffff@#ffffff@$@(      @'ffffff@$333333@#333333@&@&ffffff@%      @"@$@%@$@&      @$@$@%@%333333@#ffffff@'333333@$@%@&@%@$ffffff@%@$@&@%333333@%333333@%@%333333@%@&333333@%      @$ffffff@&      @%@%@%      @&      @%@%@%@%@%@&      @%ffffff@&ffffff@%@%      @%333333@&      @&ffffff@%ffffff@(@#ffffff@'333333@&@$ffffff@$@&@&@%      @&333333@&ffffff@'@%333333@$@)@#333333@%333333@&@&@&@&@&      @'333333@&ffffff@&ffffff@&ffffff@'      @&ffffff@&@'ffffff@(ffffff@'      @(333333@'ffffff@'      @'      @'      @&ffffff@(      @&@'@'@&@&@'      @'      @*@&333333@*333333@&@(ffffff@*ffffff@(333333@)@(ffffff@(ffffff@(ffffff@(ffffff@)@*333333@(      @)@)      @)333333@(@)333333@)@(ffffff@(@)@)      @)      @)      @-333333@'@-@*@&@,ffffff@)ffffff@*ffffff@)@,@)ffffff@-ffffff@+@)      @+333333@+      @+@-      @+      @+333333@*@+333333@*@+      @-333333@,@)@,ffffff@+@+@+@+@,@.      @)      @0333333@)333333@,@,@,ffffff@-ffffff@-ffffff@-      @-@,@.      @,@-ffffff@,@.333333@-@.      @-@+@.@.      @,ffffff@.@-ffffff@-@-      @0      @/@-@-@-@-      @-ffffff@,@.333333@-      @.ffffff@-ffffff@-@-@-@-@-@-@.@/@-333333@.333333@.@/333333@.@.@-@-@/333333@.      @/      @-@.ffffff@.ffffff@.ffffff@.ffffff@/@.@.@.@-333333@0L@.@/333333@0@,      @0     @0@.@/333333@.@1     @0333333@/@.      @0@/@0@/@0@0@1@-@.@1     @.      @/@0L@1L@0333333@0@.      @0fffff@0ffffff@0@0333333@0333333@0333333@0@0@/      @-@2L@1      @0      @1333333@0@0@1      @033333@0@1fffff@0@1@0fffff@0fffff@1fffff@1fffff@1      @4@0333333@1@2ffffff@2333333@1@2@3      @2@2@3333333@3@3@3ffffff@4fffff@3L@2333333@3fffff@4333333@3@3ffffff@5      @533333@3fffff@333333@433333@4ffffff@4@5@5L@4333333@6      @5333333@5L@5L@4fffff@4@6                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ?KƧ?zG?Vt?p
=q?hr Ĝ?tj?+?9XbM?1&x?\(\?/w?lC?9XbM?;dZ?^5?|?QR?GzH?\(\?+?333333?^5?|?n?lC?m?+J?lC?-V?Vt?I^5?}?j~"?Gz?Vu?
=p
?Q?9XbN?zG{?$/?QR?+?I^5?xF?Ƨ-?◍O;d?Gz?vȴ9X?lC?Q?`A7K?x?/v?1&x?1&?hr Ĝ?+I^?ԋC%?"`A?щ7KƧ?1&x?ΗO;d?xF?bM?7KƧ?1&?1&?n?r ě?bM?Ƈ+I?tj?tj?+I^?ěS?
=p?333333?\(?      ?hr Ĝ?Q?Q?Q?&x?      ?      ?E?n?nP?1&y?      ?vȴ9X?p
=q?lC?(\)? ěT?&x?j~"?-V?1&?Q?      ?      ?"`?lC?lC?lC?"`?&x?p
=q?lC?-V?lC?lC?lC?lC?lC?lC?hr!?-V?lC?lC?-V?hr!?lC?lC?-V?lC?lC?lC?lC?lC?lC?"`B?+?+?E?lC?lC?lC?lC?lC?lC?lC?+?Gz?lC?+J?^5?|?"`B?+J?S?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?QR?"`B?"`B?^5?|?lC?hr!?hr!?lC?lC?QR?lC?lC?lC?+?/v?E?lC?lC?"`A?vȴ9?lC?Gz?lC?dZ1?tj~?lC?vȴ9?E?lC?lC?lC?lC?p
=q?lC?lC?lC?lC?p
=q?hr!?lC?lC?lC?lC?lC?lC?lC?1&?lC?lC?lC?lC?lC?lC??lC?lC?lC?lC?"`B?lC?lC?lC?"`B?+??lC?lC?lC?tj~?vȴ9?lC?lC?lC?lC?E?"`B?lC?lC?lC?lC?lC?lC?lC?lC?lC?E?+?+?+?dZ1?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?dZ1?E?lC?lC?lC?lC?p
=q?p
=q?lC?lC?lC?1&y?hr!?lC?lC?lC?E?1&y?lC?Gz?^5?|?lC?"`A?^5?|?lC?lC?lC?lC?lC?lC?lC?lC?lC?vȴ9X?j~"?lC?E?1&y?lC?-V?+J?lC?lC?lC?-V?lC?lC?lC?-V?Q?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?Q?1&y?E?hr!?      ?      ?      ?      ?|hr?lC?lC?lC?-V?      ?      ?j~"?lC?lC?lC?dZ1?+?"`B?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?vȴ9X?hr!?lC?lC?lC?lC?lC?"`?1&y?      ?"`?lC?(\)?|hr?lC?-V?vȴ9?Gz?lC?lC?lC?lC?p
=q?lC?(\)?nP?
=p?-V?hr!?lC?lC?lC?E?hr!?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?vȴ9X?1&y?-V?5?|h?lC?lC?p
=q?"`?lC?lC?lC?lC?lC?lC?lC?lC?lC?hr!?      ?hr!?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?;dZ?p
=q?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?j~"?      ?j~"?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?vȴ9X?      ?      ?"`?lC?"`?tj~?vȴ9X?(\)?lC?E?E?lC?/v?lC?lC?lC?lC?lC?lC?lC?;dZ?/v?-V?GzH?p
=q?"`?/v?lC?lC?lC?lC?lC?      ?lC?      ?/v?lC?lC?p
=q?-V?p
=q?(\)?lC?hr!?-V?5?|h?j~"?vȴ9X?lC?lC?lC?lC?"`?lC?lC?lC?;dZ?lC?lC?Q?      ?      ?lC?lC?lC?lC?lC?lC?(\)?;dZ?lC?      ?lC?lC?lC?lC?Q?p
=q?lC?vȴ9X?lC?lC?lC?vȴ9X?j~"?"`?p
=q?lC?5?|h?1&y?lC?hr!?vȴ9X?-V?      ?      ?      ?lC?lC?E?5?|h?-V?vȴ9X?lC?lC?      ?      ?      ?hr!?lC?lC?"`?      ?      ?      ?      ?      ?/v?lC?|hr?(\)?lC?vȴ9X?lC?(\)?-V?1&y?5?|h?lC?5?|h?vȴ9X?"`?lC?E?"`?      ?-V?vȴ9X?p
=q?hr!?"`?A7Kƨ?lC?lC?lC?lC?vȴ9X?(\)?p
=q?Q?lC?lC?lC?lC?lC?|hr?      ?"`?lC?lC?lC?lC?lC?lC?(\)?      ?lC?lC?vȴ9X?1&y?5?|h?"`?(\)?lC?lC?lC?lC?lC?lC?      ?hr!?lC?lC?lC?lC?lC?lC?lC?lC?"`?      ?-V?vȴ9X?E?p
=q?;dZ?1&y?-V?lC?lC?1&y?vȴ9X?p
=q?E?lC?"`?      ?&x?hr!?p
=q?|hr?(\)?vȴ9X?1&y?lC?;dZ?vȴ9X?lC?5?|h?      ?      ?Q?lC?lC?lC?lC?lC?vȴ9X?bM?-V?E?(\)?;dZ?(\)?      ?      ?      ?      ?p
=q?p
=q?vȴ9X?p
=q?      ?      ?      ?      ?`A7L?bM?/v?5?|h?vȴ9X?lC?lC?E?      ?      ?"`?lC?lC?lC?-V?      ?      ?Q?lC?lC?lC?lC?lC?lC?lC?lC?lC?Q?      ?      ?      ?5?|h?1&y?      ?5?|h?j~"?      ?
=p?ěS?/v?      ?      ?      ?vȴ9X?E?;dZ?lC?hr!?;dZ?lC?lC?lC?lC?lC?lC?      ?      ?      ?Q?5?|h?p
=q?      ?      ?      ?      ?      ?      ?lC?"`?      ?      ?|hr?(\)?j~"?Q?5?|h?"`?      ?      ?lC?lC?lC?lC?|hr?5?|h?lC?j~"?E?      ?      ?      ?"`?lC?E?      ?      ?vȴ9X?lC?vȴ9X?      ?"`?lC?1&y?;dZ?lC?|hr?j~"?lC?lC?"`?      ?      ?j~"?lC?lC?lC?lC?lC?lC?lC?lC?5?|h?|hr?lC?;dZ?1&y?lC?lC?lC?lC?lC?lC?lC?p
=q?      ?      ?      ?      ?vȴ9X?E?"`?lC?lC? ěT?      ?5?|h?-V?/v?      ?lC?lC?lC?|hr?      ?      ?      ?Q?lC?vȴ9X?hr!?lC?p
=q?      ?      ?      ?;dZ?|hr?bM?      ?      ?-V?"`?lC?lC?lC?lC?p
=q?      ?j~"?-V?      ?      ?lC?Q?|hr?lC?hr!?Q?lC?E?vȴ9X?Q?1&y?      ?"`?j~"?      ?      ?$/?;dZ?lC?vȴ9X?vȴ9X?      ?      ?      ?vȴ9X?lC?"`?-V?lC?lC?lC?lC?hr!?j~"?lC?"`?1&y?p
=q?      ?lC?lC?lC?      ?      ?      ?      ?Q?$/?lC?lC?lC?|hr?Q?lC?      ?1&y?;dZ?1&y?lC?;dZ?j~"?lC?bM?|hr?/v?-V?1&y?vȴ9X? ěT?bM?lC?Q?lC?hr Ĝ?-V?Q?      ?      ?      ?E?      ?hr Ĝ? ěT?lC?vȴ9X?1&y?      ?1&y?A7Kƨ?-V?lC?5?|h?lC?vȴ9X?      ?      ?      ?      ?lC?lC?lC?lC?lC?lC?lC?lC?(\)?      ?;dZ?p
=q?      ?      ?`A7L? ěT?bM?vȴ9X?      ?;dZ?5?|h?5?|h?lC?Q?      ?-V?      ?      ?      ?"`?1&y?-V?;dZ?1&y?lC?hr!?      ?E?lC?lC?Q?      ?      ?Q?lC?"`?E?/v?      ?lC?Q?      ?"`?lC?vȴ9X?1&y?      ?Q?5?|h?      ?      ?      ?|hr?p
=q?E?1&y?      ?      ?      ?;dZ?1&y?vȴ9X?lC?lC?p
=q?Q?p
=q?      ?      ?1&y?5?|h?-V?      ?      ?      ?      ?      ?      ?      ?      ?      ?lC?-V?5?|h?lC?vȴ9X?      ?      ?      ?      ?      ?vȴ9X?lC?lC?Q?5?|h?5?|h?      ?lC?      ?      ?-V?-V?lC?lC?"`?/v?      ?p
=q?5?|h?/v?/v?p
=q?E?      ?hr!?lC?lC?/v?Q?lC?(\)?|hr?/v?      ?      ?      ?lC?lC?lC?vȴ9X?lC?"`?5?|h?lC? ěT?A7Kƨ?
=p?1&y?lC?lC?vȴ9X?      ?1&y?      ?      ?1&y?p
=q?E?E?;dZ?&x?;dZ?lC?vȴ9X?-V?      ?|hr?-V?/v?      ?hr Ĝ?`A7L?lC?vȴ9X?      ?      ?      ?      ?      ?n?
=p?1&y?lC?lC?lC?lC?lC?-V?|hr?lC?E?      ?      ?lC?lC?lC?lC?lC?lC?hr!?Q?lC?vȴ9X?hr!?ěS?lC?"`?lC?lC?lC?lC?lC?lC?lC?      ?(\)?lC?lC?1&y?      ?1&y?      ?vȴ9X?lC?lC?lC?lC?lC?lC?|hr?E?lC?lC?5?|h?      ?      ?p
=q?p
=q?      ?      ?      ?      ?      ?      ?p
=q?p
=q?5?|h?lC?lC?      ?lD?lC?|hr?1&y?p
=q?      ?      ?-V?lC?E?lC?/v?p
=q?vȴ9X?vȴ9X?      ?lC?"`?      ?vȴ9X                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	        @@N@N@Offfff@O@Oٙ@Oٙ@O@Oٙ@Oٙ@Oٙ@Offfff@Oٙ@Oٙ@Oٙ@Oٙ@Oٙ@Oٙ@Oٙ@Oٙ@O@Oٙ@Offfff@Offfff@Oٙ@Oٙ@Offfff@O33333@O33333@O33333@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P      @P&fffff@P,@P,@P333333@P9@PL@PS33333@PY@PY@P`     @P`     @Pl@Pfffff@P33333@P@P@P@P     @P     @P@P@P@P@P@P@P@P@P@Pfffff@P@P@P33333@P@P33333@P@P     @P@P33333@Pfffff@P@Py@Py@Py@PS33333@P9@P&fffff@Pfffff@P      @O33333@Pfffff@P33333@P@P      @P9@P&fffff@P@P      @Offfff@O@O33333@Offfff@O     @O@Os33333@O@Offfff@O33333@O33333@Pfffff@O@O     @O@O33333@P      @Pfffff@P@P&fffff@P333333@P333333@P      @OL@O      @N33333@N33333@O      @O&fffff@O&fffff@OL@O     @O@O33333@Oٙ@P      @P      @P      @Pfffff@Pfffff@P@P9@P@     @PFfffff@PL@PL@PFfffff@Pffffff@P@P     @Pfffff@P@Pfffff@Pffffff@P`     @PY@PY@PS33333@PS33333@PS33333@P`     @P`     @PY@P`     @Pffffff@Pffffff@Pl@Pl@Ps33333@Py@Py@Py@Ps33333@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Py@Py@Py@Pl@Pl@Pl@Ps33333@Py@Pfffff@P33333@P     @P@P     @P@P@P@P     @P     @P     @P     @P     @P     @Pfffff@P     @P     @P     @P     @P@P33333@P33333@P@P     @P@P@P     @P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P33333@P33333@P@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P33333@P@P     @P     @P33333@P@Pfffff@P     @P     @P@P@P@P@P     @Pfffff@Pfffff@P     @P     @P     @P@P33333@P@P     @P@P@P@P@P     @P     @P     @P@Pfffff@P@P33333@P33333@P@Pfffff@P33333@P@P33333@P@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P33333@P33333@P33333@P33333@P@P33333@P33333@P@P@P@P     @P@P     @P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P33333@P@P@P     @P     @P@P33333@P33333@P@P     @P     @P@P     @P     @P     @P     @P     @P     @P     @P@P33333@P     @P     @P     @P     @P     @P33333@P@P33333@P@P@P@P@P@P33333@P@P@P@P@P@P     @P     @P@P@P@P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@P@P@P33333@P     @P@P@P@P@P@P@Pfffff@Pfffff@Pfffff@P     @P     @P@P@P33333@Pٙ@Pٙ@Pٙ@P33333@P33333@P33333@Pٙ@Pٙ@Pٙ@P@P33333@P     @Pٙ@P     @P     @Pٙ@Pٙ@Pٙ@Pfffff@P     @Pٙ@Pٙ@Pٙ@P33333@P33333@Pٙ@P33333@P@P@P33333@P33333@Pٙ@P     @P     @Pfffff@P@Pfffff@Pfffff@P@P     @Pfffff@P33333@P@P33333@P@P@Q      @Qfffff@Qfffff@Q@Q@Qfffff@Q@Q@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Qfffff@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q33333@Q33333@Q33333@Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q@Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q33333@Q@Q33333@Q33333@Q33333@Q33333@Q@Q@Q@Q@Qfffff@Qfffff@Qfffff@Q      @Q      @P@Q      @Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Q@Q@Q@Q@Q@Q@Q@Q33333@Q33333@Q@Q@Q33333@Q@Q@Q@Q@Q33333@Q33333@Q33333@Q@Q33333@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Qfffff@Qfffff@Qfffff@Qfffff@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q33333@Q@Q@Qfffff@Qfffff@Q@Qfffff@Qfffff@Qfffff@Q      @Q      @Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Q      @P@P@P@P@P@P@P33333@P33333@P33333@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P@P33333@P33333@P33333@P@P33333@P33333@P33333@P@P@P33333@P@P@Q      @Qfffff@Q      @P@P@P@P@P@P@P@Q      @Q@Qfffff@Qfffff@Qfffff@Q      @P@P@P@Q      @Q      @P@P@P@Q      @Q      @Q      @Q      @P@P@P@Q      @Q      @P@Q      @Qfffff@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Qfffff@Qfffff@Q@Q@Q@Q@Q@Q@Q@Qfffff@Q@Q33333@Q33333@Q@Q@Q33333@Q@Q@Q@Q@Q33333@Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q      @Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q@Q@Q@Q      @Q      @Q@Q@Q      @Q&fffff@Q      @Q      @Q@Q      @Q      @Q&fffff@Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q&fffff@Q      @Q      @Q&fffff@Q33333@Q@Q@Q      @Q      @Q      @Q&fffff@Q&fffff@Q&fffff@Q      @Q@Q@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q      @Q&fffff@Q&fffff@Q      @Q      @Q      @Q      @Q      @Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q      @Q      @Q      @Q      @Q@Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q@Q@Q@Q@Q      @Q      @Q@Q@Q@Q      @Q      @Q      @Q      @Q@Q@Q@Q@Q@Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q&fffff@Q      @Q      @Q      @Q&fffff@Q&fffff@Q      @Q      @Q&fffff@Q&fffff@Q      @Q      @Q&fffff@Q&fffff@Q      @Q      @Q      @Q@Q@Q@Q33333@Q@Qfffff@Qfffff@Qfffff@Qfffff@Q      @P@P@P@P@P@Q      @P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Q      @Q      @Q      @Q      @Qfffff@Q      @P33333@P@P@P@P@P@P@P@P@P@Q      @Q      @Q      @Q      @Q      @Q      @P@Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q      @P@Qfffff@Q@Qfffff@Qfffff@Qfffff@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Qfffff@Q      @Q@Q@Q@Q@Qfffff@P33333@Qfffff@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q33333@Q33333@Q@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q@Q@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q33333@Q@Q@Q@Q@Q@Q@Q@Q      @Q      @P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@Q      @P@Q      @Q      @Q      @Q      @Q      @Q      @P@P@Q      @Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Q@Q@Q@Q@Q@Q@Q@Qfffff@Qfffff@Qfffff@Qfffff@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Q      @Q      @Q      @Q      @P@P@P@Q      @P@P@P@P@P@P@P@P@P@P@P@P33333@P@Q      @Q      @Q      @Q      @Q      @P@P@P@P@P@P@P@Q      @Q      @Q      @P@Q      @Q      @P@P@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P     @Pٙ@Pٙ@P     @Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@P33333@P     @Pٙ@P33333@P33333@P@P@P@P@P@P@P@P@Pfffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      P4                                      1                                       kBBIT3P