CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20120522   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P22    CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:48.306678Z    ORIGINAL_HEADER      sCTD,20250210CCHSIOWB
#Renamed 'CTDFLUOR_TSG' to 'CTDFLUOR_ALT_1' with units 'MG/M^3'
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2018-11-29. CTD data from cruise 18DD20120522, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20120522. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2012-12/index.php. 
#
# The information in this file for the cruise 2012-12 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-0072.ctd
#
# Start of originator file comment header
#
#*2018/11/29 14:22:51.16
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2012/06/01 08:02:46.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 2006
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : C44EDC1F
#    NUMBER OF CHANNELS  : 9
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            2.3            2006.7
#       2 Temperature:CTD               deg_C_(ITS90)   1.9166         6.6907
#       3 Salinity:CTD                  PSS-78          32.6639        34.5892
#       4 Sigma-t:CTD                   kg/m^3          25.6458        27.6748
#       5 Transmissivity:CTD            %/m             61.4           67.9
#       6 Oxygen:Dissolved:CTD:Volume   ml/l            0.41           7.23
#       7 Oxygen:Dissolved:CTD:Mass     µmol/kg         17.9           314.7
#       8 Fluorescence:CTD:Seapoint     mg/m^3          0.24E-01       0.74
#       9 Fluorescence:CTD:Wetlabs      mg/m^3          0.102          1.096
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        6  F       ' '     1
#       6  -99   ' '        7  F       ' '     2
#       7  -99   ' '        6  F       ' '     1
#       8  -99   ' '        8  F       ' '     3
#       9  -99   ' '        8  F       ' '     3
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2012-12
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P24
#    EVENT NUMBER        : 72
#    LATITUDE            :  49  50.17000 N  ! (deg min)
#    LONGITUDE           : 142  40.04000 W  ! (deg min)
#    WATER DEPTH         : 3989
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    CTDEDIT was used to remove surface records and records corrupted by shed
#	wakes; salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Transmissivity, Fluorescence and PAR data are nominal and unedited except
#	that some records were removed in editing temperature and salinity.
#
#    For details on how the transmissivity calibration parameters were calculated
#	see the document Transmissivity_Calculation.pdf.
#
#    The Oxygen:Dissolved:CTD calibration was done using the method described in 
#	the Sea-Bird Application Note #64-2 (Sea-Bird_64-2_Jun2012.pdf).
#
#    The Oxygen:Dissolved:CTD data are considered, roughly, to be:
#	±0.1 ml/l from 0 to 125 dbar.
#	±0.06 ml/l from 125 to 500 dbar.
#	±0.04 ml/l from 500 to 2000 dbar.
#	±0.02 ml/l below 2000 dbar.
#
#    For details on the processing see processing report: 2012-12-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5-- --6--- --7-- ---8--- ---9---
#!Pressu Temperat Salinity Sigma-t: Trans Oxygen Oxyge Fluores Fluores
#!re:CTD ure:CTD  :CTD     CTD      missi :Disso n:Dis cence:  cence: 
#!                                  vity: lved:  solve CTD:    CTD:   
#!                                  CTD   CTD:   d:CTD Seapoin Wetlabs
#!                                        Volume :Mass t              
#!------ -------- -------- -------- ----- ------ ----- ------- -------
#*END OF HEADER
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @Q        data_max      @Q        C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     <  .    pressure                	long_name         pressure   positive      down   units         decibar    data_min      @ffffff   data_max      @c33333   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      <  j   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      $  0   temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?͞%   data_max      @!.   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       <  T   temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      $     salinity                	long_name         salinity   units         PSS-78     data_min      @@RG{   data_max      @AKdZ   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      <     salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      $ >   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @,   data_max      @s   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        < M   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      $ 4   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?S   data_max      ?$/   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      < X   CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      $    PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       <    PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d      $ !   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min      @O@        data_max      @Q         C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     < 0   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d      $ m8   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( |\   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( |   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      '   data_max      '   C_format      %10d       |   latitude               	long_name         latitude   units         	degrees_N      data_min      @Hٞ   data_max      @Hٞ   C_format      %9.4f          |   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      aJb#   data_max      aJb#   C_format      %9.4f          |   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d        |   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d        |@Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @ffffff@      @      @      @       @"      @$      @%@(      @*      @,      @.      @0      @1      @2      @3      @3fffff@5      @6      @7      @7@:@;      @<      @=      @>      @?      @@      @A@A     @B      @B     @C      @C     @D      @D     @E      @E     @Eٙ@F     @G      @G     @H      @H     @I      @I     @Ifffff@Jfffff@K      @K     @K33333@M@M     @N      @N     @O      @O@Offfff@P@     @P     @P     @Q      @QFfffff@Q@Q     @R      @R@     @R     @R     @S      @S@     @S     @Sfffff@T@T@     @T     @T     @U      @U@     @U     @U     @Vfffff@V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Xfffff@YS33333@Y     @Y     @Z      @Z@     @Z     @Z     @[fffff@[      @[fffff@[     @\      @\@     @\@\@]      @]@     @]     @]     @^      @^@     @^     @^     @^@_@_     @`      @`      @`@     @`c33333@`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a33333@b      @b@b@     @b`     @b     @b     @b     @b     @c      @c33333@cL@c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d33333@d33333@d陙@e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f@f@f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @h@h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j33333@j33333@k      @k      @k@     @k`     @k     @k     @k     @k     @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @mi@m     @m33333@m     @m     @n      @n      @n@     @n`     @ns33333@nfffff@n     @o      @o      @o@     @o`     @o     @o@o33333@p      @p     @p      @p1@p@     @pP     @p`     @pp     @p     @p     @pfffff@p     @p@p     @pfffff@p     @q      @q     @q      @q+33333@qFfffff@qNfffff@q^fffff@qp     @q     @q@q     @q     @q     @q     @qfffff@r@r     @r!@r0     @r<@rS33333@r`     @rp     @r@r     @r     @r     @r     @r     @r     @rfffff@s@s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s@sfffff@s     @s     @s     @sᙙ@s     @t      @tfffff@t      @t0     @t@     @tP     @ta@tp     @t     @t     @t     @t     @t     @t     @t@t@u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u@u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vS33333@v`     @vp     @v     @v     @v     @v     @v     @v     @vᙙ@vfffff@w      @w     @w      @w0     @w>fffff@wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w񙙙@x      @x     @x      @x0     @x@     @xQ@xY@xx     @x     @x     @x     @x     @x@x     @x     @x     @y      @y     @y      @y1@yA@yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @yᙙ@y     @z      @z0     @z@     @zP     @za@zi@zfffff@z     @z     @z     @z     @z     @z񙙙@z@{@{      @{0     @{@     @{P     @{`     @{l@{     @{     @{     @{     @{fffff@{@{     @|      @|     @|      @|0     @|@     @|L@|p     @|     @|     @|     @|     @|     @|     @|     @|񙙙@|     @}@}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}ᙙ@}33333@~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~fffff@~     @~     @~     @~љ@~     @~     @      @     @      @0     @@     @P     @`     @p     @     @@     @     @     @33333@fffff@     @      @     @     @     @      @(     @1@8     @@     @G33333@P     @X     @`     @h     @p     @x     @     @     @     @fffff@@     @     @     @     @     @     @     @     @     @fffff@      @     @     @     @      @(     @0     @8     @=@I@O33333@X     @`     @h     @p     @x     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @@33333@      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @33333@     @     @     @     @     @     @     @     @     @ՙ@     @     @     @     @      @     @     @     @      @(     @-@8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @@@     @     @     @     @     @     @     @     @     @     @33333@@     @     @     @      @(     @0     @8     @@     @G33333@P@X     @`     @h     @m@zfffff@     @     @     @     @     @     @     @@     @@     @     @     @     @     @      @     @"fffff@(     @0     @8     @@     @H     @P     @X     @^fffff@p     @x     @     @     @     @     @     @     @@fffff@fffff@     @     @     @     @     @     @     @      @     @     @     @fffff@(@0     @8     @@     @H     @P     @X     @`     @h@m@w33333@@     @     @     @     @     @     @     @     @     @     @     @@@      @     @     @     @      @(     @0     @5@K33333@P     @X     @`     @h     @p     @x     @|@     @     @     @     @     @     @fffff@     @@     @     @     @     @     @      @     @     @@      @(     @0     @8     @@     @H     @P     @X     @`     @g33333@p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @@@     @     @      @(     @0@8     @@     @H     @P     @X@`     @h     @p     @x     @@fffff@33333@     @     @     @     @     @@     @     @     @     @     @@     @      @     @     @     @      @(     @0     @733333@@     @H     @P     @X     @`     @h     @p     @w33333@     @     @@@@     @     @     @     @     @@@     @     @     @      @     @     @     @      @'33333@:fffff@@     @H     @P     @X     @`     @h     @nfffff@x     @     @     @     @     @     @     @@fffff@     @     @     @     @     @     @     @      @     @     @     @      @(     @/33333@8     @@     @G33333@P     @X     @_33333@h     @p     @x     @     @     @     @     @@33333@     @     @     @@33333@     @     @     @     @     @      @     @33333@33333@      @(     @0@8@@     @H     @P     @X     @_33333@h     @p     @x     @     @     @fffff@     @     @     @     @     @     @     @     @     @fffff@33333@     @     @      @     @     @     @ @$     @0@8     @@     @H     @P     @X     @`     @h     @p     @{33333@     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @ @@fffff@     @      @'33333@0     @8     @@     @H@L@[33333@`     @h     @p     @x     @33333@     @fffff@     @     @     @     @     @     @     @fffff@@     @     @      @     @@     @     @     @     @@      @$     @(     @,     @0     @4     @8fffff@:fffff@@     @D     @H     @K@T     @X     @\     @`     @d     @g@k@p     @t     @w@     @     @     @     @fffff@fffff@@     @     @     @fffff@@     @     @     @     @     @33333@     @     @     @     @     @     @     @     @33333@fffff@     @     @     @      @     @     @fffff@fffff@     @     @     @      @$     @(     @+@/@4     @8     @<     @@     @D     @Ffffff@Lfffff@P     @T     @X     @\     @`     @b@h@k@p     @t     @x     @{@fffff@     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @Ù@     @     @     @     @fffff@     @fffff@癙@     @@     @     @     @      @     @     @33333@@     @     @      @$     @(     @+@1@4     @8     @;33333@@     @D     @H     @L     @P     @T     @X     @Z@a33333@d     @h     @l     @p     @t     @x     @|     @~@33333@     @     @     @33333@33333@     @     @     @fffff@     @     @     @     @     @     @     @     @     @     @ә@     @     @     @     @     @fffff@     @     @     @     @      @     @@@     @     @     @     @ fffff@"fffff@(fffff@+@0     @4     @8     @<     @@     @C33333@H     @L@P     @T     @X     @\     @`     @d     @h     @l     @p@t     @x     @|     @     @     @     @fffff@fffff@     @fffff@     @     @     @     @     @     @     @     @33333@Ù@     @     @     @     @     @     @     @@33333@     @     @     @     @      @@     @     @     @     @fffff@      @$     @(     @+@0     @4     @8     @<     @@     @D     @Hfffff@Lfffff@P     @T     @X     @\     @`     @dfffff@hfffff@l     @p     @t     @x     @|     @     @fffff@fffff@     @@     @     @     @     @     @@@     @33333@@     @     @     @     @     @     @     @     @fffff@33333@     @     @     @     @     @     @      @     @     @     @     @fffff@     @     @      @$     @(     @,     @0     @4     @8     @<fffff@@     @D     @H     @L     @P     @T     @X     @\     @`     @dfffff@h     @l     @p     @s@x     @|     @     @     @     @fffff@33333@     @     @     @     @     @     @@@     @     @     @     @Ù@     @     @@fffff@     @     @     @     @     @33333@     @     @     @      @     @     @     @     @     @     @@      @$     @(     @,     @0     @4fffff@6fffff@<fffff@@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @r@xfffff@|     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @33333@fffff@Ǚ@˙@     @     @     @     @     @     @癙@     @     @@     @      @     @     @     @     @     @33333@33333@      @$     @(     @,     @0     @4     @8     @@     @D     @H     @K33333@O@T     @X     @\fffff@`fffff@d     @h     @l     @p     @t     @x     @{@     @     @@     @     @     @     @fffff@fffff@     @     @     @fffff@@     @     @     @     @     @˙@     @fffff@fffff@ۙ@     @     @     @     @     @     @     @@      @     @     @     @     @     @     @@%33333@(     @,     @0     @4     @8fffff@;33333@H     @L     @P     @T     @X     @\     @_@i33333@l     @p     @t     @x     @|     @     @@     @     @     @fffff@     @     @     @     @     @     @     @     @     @fffff@33333@fffff@     @     @     @     @     @     @癙@     @     @     @     @     @      @     @@     @     @     @     @     @      @$     @'33333@-@0fffff@3@8     @<     @@     @D     @H     @L     @Pfffff@Rfffff@X@\     @`     @d     @h     @k33333@q33333@t     @x     @|     @     @     @     @     @     @@     @     @     @     @     @     @@     @     @     @     @     @     @@fffff@     @     @     @㙙@     @     @     @     @     @33333@ @     @     @     @     @     @     @     @33333@$@(     @,     @0     @4     @8     @<     @@fffff@Bfffff@Lfffff@P     @T     @X     @\     @`     @c@h     @l     @pfffff@t     @w@|     @     @     @     @     @     @     @     @@fffff@     @     @     @     @     @     @@     @     @     @fffff@fffff@     @     @     @     @     @     @     @@@     @     @      @     @     @     @@     @     @      @$     @(     @,     @0     @4     @733333@<@@     @D     @H     @L     @P     @T     @X     @a@d     @h     @l     @q33333@t     @x     @|     @33333@@     @     @     @@     @     @     @     @fffff@     @@     @     @     @     @     @     @     @fffff@fffff@@     @     @33333@     @     @     @     @33333@33333@     @     @     @     @     @fffff@      @#@'@,     @0     @4     @8fffff@;@@     @D     @G@K@P     @T     @Xfffff@Zfffff@`fffff@d     @h     @l     @p     @t     @x     @{@@     @     @     @     @     @     @     @     @     @fffff@     @     @     @fffff@@     @fffff@     @     @     @     @     @     @     @     @@fffff@     @     @      @     @     @     @     @     @fffff@!33333@$     @(     @,     @0     @333333@<fffff@@     @D     @Hfffff@K33333@T@X     @\     @`     @d     @h     @l     @n@x@|     @     @     @     @fffff@@@     @     @     @     @     @     @     @     @33333@fffff@     @     @     @     @ә@ٙ@     @     @     @     @     @@     @     @      @     @     @     @     @fffff@33333@"     @$     @(     @,     @0     @4     @8     @:@@@D     @H     @L     @P     @T     @X     @\     @`fffff@d     @h     @l     @p     @t     @x     @|     @     @     @     @     @33333@33333@     @@@@     @     @     @fffff@fffff@@     @     @Ǚ@͙@     @     @     @     @     @     @     @     @     @     @     @     @      @33333@     @     @     @     @     @     @33333@(fffff@,     @0     @4     @8     @<     @@     @D     @F@M33333@P     @T     @X     @\fffff@`     @c33333                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 @o@2W@䎊q@D@!.@Xy=@!-w2@W@@t@8Y@VϪ@zG@u!@@@ᰉ@L_@2a|@E@L_@L_@Z@O
M@ݗ+k@tj~@<64@u@u@|@*0U@@@p:~ @g	@+@@C@|#x@	k~(@Ƨ-@-
q@.H@y#w@rGE85@i^@`[6@["`B@Gݗ+@ -
@r Ĝ@ǮzH@&x@^5?|@ěS@a@O@յsh@E@*0U@C,zx@o-V@Q_p@)lD@ 4m9@@N@U=@@gfA@C@j~#@qu"@V+J@F
L/@?|hs@.t@#Z@@U2a|@zS&@{@F]c@J@ߤ?@@&IR@U=@\@zxl"@o@[W>@y@@N@A [@Y}@ ѷX@@?@(r Ĝ@.H@,VϪ@	@!@N@(r Ĝ@4֡a@6_ح@5!.@*Ov`@(@'@'&@+jf@+C,z@0@=<64@>m\@G#@M5Xy>@Nqi@NMj@SMj@i*0U2a@n.2@p
(@s33333@x-
@s|@b`A@TZ@Ov_ح@Iԕ*@>\N<@%@>6z@`A7@	Q@s@@nP@&IR@	k~(@2ᰊ@(@#S@!Gz@,<@+j@bM@T`d@@	k@;5X@YJ@š@E84@ѷX@84֡@©@dZ@5Xy@xl"h
@	k~@ȴ9X@ߤ@!-w@u%@y~($@h>BZc@aR<6@\u"@Rp:@$%1@r@㢜wk@e+@hr @Ňݗ@[W>@m]@[W?@cA \@}H˒@xF@qiB@ffffff@][@SZ@O'/W@J	 @F@B&IR@Bu%F
@@n@5Y|@ ěT@5?|@1o@حV@eں@xF]@	k~(@g8}@@{J#9@K]d@g8}@{J#9@\(@v@|@}Vl@C]@JL@|Q@ݲ-V@E@*0@Vu@IQ@2W@-@/@-@n.3@{@JM@u!.@s|@}v@
qu@fA@l@!-w2@Y|@!.@eں@=b@m\@xl"h
@m8@+a@o@%@&@T`d@v_ح@(@@oiD@
L/@8YK@)^@oiDg@YJ@tj@&IR@&IR@ [7@}H˒@yY}@vC-@t9XbN@sE@rs@nO;@kU=@jJL@ilD@ix@h$xG@g@eu@`-
@Z6C@W@U2a|@RsP@M:@LcA \@LcA \@L~($x@J=p
@F&I@E8YK@C@Bu%F
@@C@?$tS@=v@;5Xy@:^5?|@84֡b@873@5Xy=@4SMj@3E@3PH@1l@-U=@-(@-V@*͞&@'	k@%u@$/@$?@#S&@"3@Ov_خ@+j@/w@u"@q@Ϫ͟@Ʌoi@`d@Z@@Mj@
@҈@@]cf@$/@@$/@n.@KƧ@m\@iDg8@U=@F
L0@ޞ@+j@L_@sP@T`d@\(@Ίqi@_o @̲@ڹY@k~(@&I@*0@nP@7Kƨ@[W>@ڹZ@s@)@Y|@u!S@-V@(@͞&@@@TɅ@8}H@F
L0@C,@[6@Ov_خ@Ϫ͟@sP@)^	@'RTa@Fs@*0@@o hی@IQ@     @~BZc @y	k~@sg@sMjO@sMjO@sPH@p
(@lVϪ@j͞&@fA@dxF@cn.3@bM@`[6@_!-w1@^@^%@ZQ_@V+J@Sݗ+k@S&@RS&@QR@Ov_ح@Np:~@JL/{@IQ@G#@F&I@EQ@D*0@?b}V@;5Xy@84֡b@5sg@1-@-U=@%S@"@4@䎊r@@As@
@@
n@˒:*@#@)^@?@@ 6@(@䎊qj@e+@|Q@d8@$@sPH@՛=K@K]c@s@&IR@K]@4K@{@q@&@/@?@n.3@[6@	@[@@@tj~@hr @bM@~($x@$/@v_ح@ql@nc	@j~"@ix@f1.@`҈p@ZQ_@W
=p@QN;5@O;dZ@L/{J#@K]cA@Jn@I@@n@:^5?|@4m8@.1@(Xy=@$?@kP|@@R<6@$/@4J@	'RTa@u%F@ݗ@ IQ@m\@PH@ ě@	@cA @c	@K]c@j~#@C-@v@zxl"@TɅ@-@wk@S@Fs@O
M@zG@@=p
@b}V@yrGE8@ql@q@o hۋ@nc	@o hۋ@aGz@[$@[6@[6@ZQ_@Rm@MjOv@I@Em\@DS@F-@Dg8}@7Xe@49XbN@0'RT@'/V@䎊r@S@҉@!R<@
ڹY@#@
F@
j~@
GE85@
@
O;@
~"@
,<@
(\@
֡af@
Z@
|@
:@
#9@
ȴ9Xb@
s@
m\@
s@
[W>@
<64@
~($@
v@
U=@
&@
`A@
o@
Q@
S&@
Q@
~\N<@
v+jg@
qA [@
mhr!@
lVϪ@
hۋq
@
cA [@
ae@
_?@
\N;@
T`d@
P`A7@
P*0U@
G@@
A [7@
0{@
*0
@
)@
($xG@
vȴ9@
_o@
0
)@
҉@
)^@

qu"@
eO@
ݗ+@
ݗ+@
#@
_o@
%2@=b@!R@GE85@iB@@C@唯O
@e@>BZ@As@s@E84@š@ [7@6@dZ@n.@rG@ߤ@zG@U=@U=@U=@I^@*0U2a@h	ԕ@$tS@~($x@_o@JM@F]c@˒:)@xF@sg@p@m\@cS@Y+@TɅoi@PH@DS@<64@9~($@6z@+U=@#wk@!.H@!-w1@R<6@u@)^@@#@o h@ 4m9@73@!-w2@O;@	ԕ+@2a|@)^@|hs@)_@֡a@[W>6@{J#:@r@r@tSM@Ov_خ@[@u"@[@u"@IQ@[@e+a@sP@ߤ?@qiC@o h@@I^5@{s@qiB@jg	@iDg8~@h>BZc@eڹ@e`A7L@d%1@`d8@]+j@XU@T*1@S&@Rp:@P`A7@J#9@Ca@N@?@>
(@:~@:)y@9#w@7rG@6C-@4J@1&x@.1@,q@)y@$tSM@ [6@,<@ݗ+k@Mj@@
=p
@nP@
lC@
1@
PH@
!-w@
VϪ@
@4@
c	@
حU@
Ϫ͞@
ѷX@
@
)^	@
6@
U2a|@
*0U2a@
wk@
ae@
ae@
o@
}H@
0
)@
*0U2@
qi@
I^5?@
xF]@
+I@
}E@
{lC@
zG{@
zG{@
zC\@
xF@
xl"h	@
x-
@
w+@
r ě@
lVϪ@
jOv`@
`
qu@
[W>6z@
XU@
TɅoi@
SZ@
H@
@C@
;5Xy@
9#w@
4J@
2a|Q@
0 ě@
+jf@
'RT`e@
#n.3@
 [6@
Ov_خ@
e+a@
:)y@

=p
@
?@
 4m9@	@	+jg@	j~@	GE85@	(@	8}H@	cA @	6@	+@	Ϫ͞@	т@	˒:)z@	\(@	6@	6z@	A@	J@	o@	y@	,@	S@	ěT@	Q@	@N@	'/W@	@	q@	@	I^5@	|Q@	x73@	o@	kP{@	hۋq
@	de@	`u!@	Y>BZ@	UϪ͞@	R<64@	PH@	Ks@	H˒:*@	F]cf@	C,zxl@	<쿱[@	73@	64K@	4J@	.2X@	,>B[@	$/@	U=@	=K^@	sh@	@	1&x@	 hۋq@$t@!.@@Ov`@e@A7K@$@8YJ@N;5@s@K]c@\(@<64@n.@^5?|@D@YJ@4K@{@d7@'RT`@@Mj@&I@S&@o h@b}V@~$t@}Vl!@mC\@g	k@eڹ@d%1@\N;@UϪ͞@QX@O͞@L@IQ@F?@D2W@A7Kƨ@8)@7rG@5'0@*d7@!R<6@!R<6@Ov_خ@,=@IQ@ߤ@@+j@Ov_@zG@bM@
L/{@o hی@C\@	k~@-
@Fs@GE85@u!S@@D@
=q@O;@C\@Q@~"@B@fA@|Q@sPH@ԕ*1@@Zc@H˒:@j~#@dZ@Y}@)@?@v@d7@\)@@@x@u@[6@%@Q@@҉@)^@@M:@҈@YJ@hۋq@}E@}E@.H@~\N<@}E@}Vl!@|hr@|PH@{s@zxl"h
@y"`@{s@v+jg@qA [@j~"@fA@eO
@b@4@`u!@_;dZ@_Ft@\]ce@U2a|@QR@I^5?}@F]cf@Em\@C$@B@=p
=@5sg@.1@*d7@'-@$tSM@쿱[W@u%F@*0@+j@\(@n/@rGE8@j~@
=q@@8Y@빌~($@>BZc@e+@A7K@iB@/w@6@1'@+@@Õ$@p
=@C-@sg@o@V@0U2a|@u@wkQ@-w1@䎊r@1&@*0@@\(@C%@=p
@@{J#9@xF@v!.I@tD@sPH@o-V@jg	@e@b}Vm@^҈p;@\>@W@TɅoi@RT`d@NT@K:)z@I^5?}@H@F]cf@B@@NU@?@=<64@9XbM@6C-@3ߤ@-V@'/V@&'@$tSM@ 'RT`@u@ߤ@@6C@@@R<6@ݗ+k@Vu@K]d@ݗ@F]c@.H@E@m]@(@(@rGE8@=b@F]d@!R@A [@VϪ@Ov`@Dg8~@Z@cA @حU@E@R@_o @̘_@n@W'@Ƨ@W'@@K]c@NU@Z@S&@m8@o@
(@{J#:@0
@1@3@C,zx@@$/@N;6@'/W@ ѷ@?@@4n@IQ@     @}ڹZ@zC\@tj~@kQ@k~($@iDg8~@bM@\>@Y+@W&@Vt@Sa@O@R䎊@Q_p@P{@Np:~@NT@Np:~@MjOv@K)^	@J#9@H˒:*@E84֡@C\N@=b@;5Xy@8Q@5'0@-w1@)*0U2a@&L/{J@#
=p@#S&@"3@!o@䎊r@1&@wkP@@+J@ݗ+k@:)y@hr @$tT@Vu@
@
qu"@I^5?@
L/{@	'RTa@K]d@&I@&I@F]c@#x@"`@(@"`@F@kP@E@C,z@fffff@@4@A7K@o@/w@>BZ@`d@T`d@H@cA \@s@n.@S&@z@W@U2a|@r@r@H@0
@'@[6@=K^@tj@sh@҉@҉@Mj@@q@q@'RTa@@Q@o h@u%F
@|PH@xF@vȴ9X@sg@rs@nO;@lC@ix@f,<@cZ@a'R@_Ft@]/w@Zݘ@Y>BZ@Y+@YJE@W&@U2a|@SZ@Rm@Rm@R䎊@QN;5@P`A7@OAs@M5Xy>@JL_@IQ@E8YK@D2W@Ca@N@B&IR@@4m@?@@4m@@n@?@<n.@73@5sg@49XbN@3|@2a|Q@0U2a|@.2X@+U=@*0U2a|@)@'RT`e@$TɆ@"wkQ@ 	k@!-w1@kP|@O
M@$tT@!R<@
O;dZ@p:@m\@hr@~$@xl"h
@@-
@!R@䎊q@쿱[W?@ۋq
@1.@e+@u!@o@iB@5?|@]ce@څݘ@l!-@,<@|@ΤT@_o @cA \@@
L/@@64@)_@64@D@}Vl@ ě@w1@zxl"@q@͞&@TɅ@/V@@TɆ@tSM@ae@u%F@u@qu"@q@qiC@u%F@ݗ@%2@I^5@IQ@.H@~$t@b}V@y"`@tD@poiDg8@lVϪ@iB@fA@e`A7L@bM@_حV@^@\N;@[6@[$@[6@ZY@Y|@XU@UϪ͞@SZ@Q_p@O
M;@MjOv@M:@L_@Jn@H@Eo i@B74@As@B&IR@A [7@?@;dZ@9#w@8}H@64K@333333@0'RT@.}Vl@*͞&@$?@Ov_خ@[@ߤ@@qu!@u%@C,zx@S@kP|@Xe,@zG@nO@rGE9@\(@
@
O;dZ@~($x@	ԕ*@YJ@$/@oiDg@@$t@hr@F@#@u!S@@(@"h	ԕ@"h	ԕ@Ov`@1.@حV@Q_@>6z@@;dZ@5Xy>@@̘_@@cA \@ǮzH@4m@vȴ9X@
(@~@E@J@a|Q@-@-V@-@a|Q@-V@J@m\@o@{J#:@zG@I^@*0U2a@RT`e@&@IQ@1@.H@,=@[@1&@C,zx@=K^@0
)@@n@!R<@q@qiC@=p
@ԕ*@ ѷ@#@_o@YJ@JM@ݗ@u%F
@~m\@{s@vFs@u%F
L@tj~@tj~@t#@t#@sE@r䎊q@q@o hۋ@m(@kQ@gfA@f,<@eڹ@e@d%1@_حV@YJE@W
=p@VϪ͟@U=K@UfA@Vt@S@O;dZ@LcA \@K)^	@K)^	@I^5?}@I@H@GE84@F]cf@F]cf@F-@F]cf@F
L/@Eo i@D2W@C,zxl@?[W>@<쿱[@;A@9D@64K@0'RT@-
qv@*0U2a|@($xG@%F
L0@#S&@vȴ9@Q@u%@vȴ@tj@@ᰉ@L_@O
M@:)y@xF]@@ݗ@ ѷ@"@\(@!-w2@E@MjO@@PH@D@Q@ᰉ'@@A@Z1@Z@A [@C,@|Q@Ft@]ce@حU@D*@D*@2a|@R@_o @D@@@
L/@Õ$@TɅo@C@ߤ?@v@p
=@p
=@K]@Z@쿱[@j~#@/V@}H@sg@9XbN@a|Q@1&y@*0U2a@-@x@	@kP|@_o@@+j@sh@Fs@N;6@bM@ߤ?@~($x@u%F@&I@tj@@4n@IQ@.H@~"@}E@vȴ9X@sMjO@r ě@ql@p:~ @lC@j~"@irGE@gfA@glC@glC@g@e`A7L@de@dZ1@bM@a@N@_حV@]+j@Zc	@Xy=c@V8YJ@UfA@RT`d@Np:~@I@G@@E@Eo i@DS@Ca@N@B&IR@@6@?[W>@?@7rG@1o@-w1@,1&y@)@&L/{J@%S@$xF@!.H@vȴ9@Q@_F@ᰉ@*0@@nO@rGE9@
@҈@1&x@Q@o hی@$/@ ?@ xl"h
@ 	k~@ -
@ +@ !.I@ -
@ 1@ _ح@ _ح@ \(@ D@ 唯O
@ M@ e@ 
qu@ ;dZ@  ѷY@ >@ c	@ bM@ ֡af@ t@ E@ ΤT@ @ ȴ9Xb@ y@ 84֡@ 74@ &IR@ TɅo@ H˒:@ 6z@ <64@ 5Xy@ sg@ >B[@ '@ IQ@ L/{J@ @ /V@ ,@ IQ@ L/{J@ @ F
L0@ /@ zxl"h@ zxl"h@ F
L0@ u@ u@ zxl"h@ u@ F
L0@ S@ S@ IQ@ @ zxl"h@ u@ F
L0@ zxl"h@ F
L0@ wkQ@ 3@ kP|@ R<6@ Z@ O
M@ Fs@ S&@ )^@ rGE9@ !R<@ I^5?@ L/{@ p:@ u%F@ 1&x@ #@ YJ@ o h@ nP@  ѷ@ @4n@ }H˒@ z@ yrGE8@ v!.I@ tj~@ m8Y@ j~"@ ix@ irGE@ eڹ@ e@ dqj@ dqj@ b@4@ ^ ѷY@ ]/w@ \(\@ [q@ \N;@ Zݘ@ Vl!-@ QX@ M5Xy>@ I^5?}@ H9Xb@ Fs@ Eo i@ C\N@ B\(@ B&IR@ As@ ATɅo@ B\(@ @C@ >6z@ >vȴ9X@ >
(@ =p
=@ <j~#@ 9XbM@ 74m@ 6}Vl@ 333333@ -
qv@ ,q@ *0
@ (\)@ '-@ &x@ U=@ ,=@ u"@ wkP@ u%F@ @ u%F@ @ @@ Ov_@ @ zG@ sP@ hr @ @ '/W@ 
M:@ L_@ xF]@ C%@ 
ڹY@ ݗ+@ %2@ u%F
@ :S?E?#x?C\?+jg?!-w2?VϪ??Z?Z?C,?
qu?iB?iB?ݗ+j?$?ڹY?+?حU?b}?䎊?ȴ9Xb?n?<64?
(?n.?Y}?g	l?r?q?TɅ?&?&?u???n.3?3?vȴ9?'RT`?IQ?S?0
)?+j?Fs?eO?ݗ?M:??o hی?zG{?tj~?qiB?q?m\?jfB?iB?hr Ĝ?g	k?e+a?`A7K?\>?\N;?[W>6z?Zc	?[W>6z?\(\?\N;?\(\?[W>6z?YJE?Xy=c?S?QR?RT`d?N;5X?KƧ?K]cA?I^5?}?H?E???>BZc ?=b?=K]?;5Xy?:S&?;dZ?;5Xy?;dZ?:S&?9XbM?84֡b?:)y?9D?9XbM?8}H?3ߤ?0U2a|?.H?-
qv?.2X?,zxl"?,<쿱?,zxl"?,zxl"?*0
?$xF?䎊r?PH?*0??u???Vu??
=p
?	k~(?	 ѷ?	k~(?
=p
?
L/{?	ԕ*?K]d?$/?n/?tj?      ?ڹZ?>B?rGE8?-
?eں?䎊q?C\?C,z?`A7L?ᰉ'R?ߤ??
qu? ѷY?"`B?b}?D*?D*?+?D*?
=p?҈p:?N;5?As?͞%                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 @@Rm@@Rm@@RG{@@Rm@@R74@@R~@@S҉@@S'/@@SnP@@S'/@@Ss@@SnP@@Ss@@SPH@@SnP@@S҉@@S'/@@SnP@@S'/@@SnP@@Su%@@SnP@@S'/@@Ss@@SPH@@SPH@@SC,z@@SPH@@S	@@S"`B@@S&@@S)^	@@S9@@S@@T*1@@U:@@U8YK@@W@@W?@@XXy=@@Xu!@@Xu!@@X|@@Xn@@XYJ@@X|@@Xr Ĝ@@XѷX@@X4֡b@@X|@@XbM@@W@@X'RT`@@XbM@@XѷX@@X{@@X$tT@@Y	k~@@XbM@@W@@@Wo@@X
qu@@X-
@@XPH@@YrGE8@@Z&IR@@ZS&@@[I^@@[@@\*0@@\TɆ@@\qj@@\o h@@]K]@@]:@@]F
L0@@]C\@@`oiDg8@@c
=p@@d1&@@e$/@@f\N<@@fm\@@i^@@kA@@l#@@n;5X@@pIQ@@vm\@@z6C@@Mj@@*0@@)y@@j~#@@o@@$/@@q@@C-@@Xy=@@O;@@I^5@@1&y@@hr!@@#@@n@@YJ@@U=@@C\@@jf@@U=@@-
@@S&@@.H@@҉@@?@@hr@@S&@@p
=      @@+@@ѩl@@GE85@@)^	@@L_@@־ߤ?@@@@+I@@.H@@b}V@@+j@@+j@@*0U@@ [7@@h	ԕ@@	@@ۯ@@Ƨ@@܁o h@@qu"@@䎊r@@@@9Xb@@TɅ@@ěT@@ව4m@@{@@{@@C@@=b@@e@@@4n@@a|Q@@L/{@@,<@@g	l@@Q@@A [@@҈@@҈@@!-w2@@Fs@@q@@zG@@'0@@Q@@o i@@Z@@/@@Z@@JM@@+j@@hr!@@!R@@ڹZ@@垃%@@Xy=@@帺@@!.@@+jg@@+jg@@c	@@҈p;@@@@RT`e@@_o@@KƧ@@H˒:@@>6z@@Xe,@@	k@@˒:)@@-
q@@'RT`@@NU@@*0U2a@@e+a@@ ѷ@@s@@e+@@Ov`@@#9@@:)y@@fB@@달q@@뢜wk@@믷@@1&y@@q@@쿱[@@1&@@첕@@Ʌoi@@*0@@>B[@@'0@@Y|@@p
=@@hr!@@=K@@hr!@@H˒@@\(@@+j@@zxl"h@@Y|@@m\@@Xy=@@+J@@+@@.H@@@@-
q@@eO@@y=c@@@@ѷX@@x@@R@@6C@@C\@@a|Q@@\(@@S&@@vȴ@@>B@@n@@C,@@m\@@S&@@)^	@@@N@@a@N@@wk@@҈@@ߤ@@@SMj@@O
M@@?@@u"@@K]@@u@@2a|@@fA@@hr!@@@@v@@n/@@@@,=@@ڹ@@vȴ9X@@Ϫ͟@@1@@.H@@o@@zH@@@@@rG@@@@@@[6@@r Ĝ@@@@d8@@@@@F@@`A7@@PH@@+@@ [7@@XbM@@u@@^5?}@@_o@@"`@@Y}@@M@@a|Q@@kP|@@\(@@S&@@@@W@@I^@@,zxl@@W>6z@@Q@@eO@@Q@@Q@@m]@@\N@@%1@@C,zx@@VϪ@@m8@@wkP@@C@@@@>@@<64@@jOv@@hr!@@-V@@n/@@b@@!R<@@YJ@@$t@@@@Xe,@@3@@fA@@+j@@rGE9@A *0@A 4m9@A :~ @A H@A u!@A -
@A 
(@A ҈p@A PH@A+@A7KƧ@A^@Ab}@Au@A_o@An@A1'@A3@AW'@Ap:@AL_@Aᰊ@AY@A ѷ@AI^@A"`B@AMjO@A@An.@A*1@ATɆ@A֡a@Ae@Aqu"@A%F
L@A2a|@A/w@AfA@A=K@A
qv@A
qv@AS@A(@Au@A_ح@As@AQ@Ax@A@A hۋ@A.H@AO
M@AO
M@AXe,@A?@AfA@A+j@A@A@A*0U@A1&x@A*0@AYJ@A-
@A
=q@Ad8@A4m@A4m@A	 [7@A	:S@A	e+a@A	@A	D@A	lD@A
M@A
{m@A
`A@A=K^@Aq@A:)z@A$@Aq@AE@A|@Aݗ+k@A$@AJ@AI^5?@A*0@Ahr@A>@AE@A
o i@A
Q@A
5Xy>@A
<64@A
=K@A
Xy=@A
@A
ᰉ@A!R<@A8YJ@AL/{J@Afffff@Ap:~      @A%@AFs@AFs@A-@Am\@AC-@A쿱[W@AMj@A)^@A_o@AkP@AzH@A@A+@AfA@AVϫ@AbM@A4m9@AH@AeO@AeO@Au!@Au!@Ay=c@A'RT@AěT@A@A@A#w@A=b@AQ@A~($@Au@A(@A|@A"`@An@As@A)y@A=p
@A=p
@AM@Aݘ@A)_@AڹY@A䎊q@A=K^@Ajf@A@AA@A*0U2@Am]@AE@A6@A҈@An.@An.@Aߤ@@A!-w2@A?@A`d@AwkP@AC@AC@A*1@AN;@AC@A/@A/@A>B[@A>B[@A/@Ae@Au@A!.H@A2a|@A/w@A/w@AB@Azxl"h@AM:@A+j@A\(@AS@AE@AOv_@A($x@A5?|@AH@Aqi@A,<@AT@A6z@A2X@Aߤ?@A҈p;@A!.I@Av@A'/W@A1@AE84@AO
M@ART`e@A\(@A\(@Ao@Ay@A&@A-V@AK]d@A@A@@A-@A-@A     @A:~ @AoiDg8@A@A{@Ap:@A҈p@Ae+@A{@A ѷ@ArGE@A@A#w@AJE@A^@Ahr @AR<6@A'R@A.H@AI^5@As@AOv`@A@4n@AM@Aa|Q@A@4@Ap:@Avȴ@A}Vm@A}Vm@A}Vm@AY@A<64@A`A@AD@A'/@AC,z@AC,z@A"`B@A=K^@AZ@An.3@AMj@A~($@AƧ@A
=p@A%2@A$@As@Aߤ@@AxF@A"h	ԕ@A,<@AFs@ASMj@ASMj@AZ1@AVϪ@AcA \@AzG@A3@AZ@AJM@A!-w@A>@Au@A+a@A84֡@AB@AB@Asg@A@An/@A@A
(@A+jg@A.2@ABZc @Avȴ9X@A+J@Aqi@A,<@Aȴ9X@At@Am\@A쿱[W@A!.I@A
=p@A$tS@AO
M@AU=@AsPH@A4m@A@A }H@A -
q@A D*@A Xy=@A bM@A eO@A _F@A _F@A 
=q@A {@A 9Xb@A {@A {@A 9Xb@A 9Xb@A 4m@A TɅ@A ҈p@A 4֡b@A! ѷ@A!@A!&x@A!*0U2a@A!N;5@A!k~(@A!b}@A!|Q@A!@A!~($@A!@A!R<6@A!(@A!X@A!_o@A!iB@A!ᰉ'@A!e@A!@A"	 @A"䎊@A")y@A"&IR@A"=p
@A"@4n@A"GE85@A"JL@A"M@A"^5?|@A"kP|@A"xl"h
@A"@4@A"\(@A"L/{@A"}Vm@A"@A"c	@A"~@A#I^@A#s@A#,zxl@A#J#9@A#]cA@A#jf@A#~$@A#A@A#E@A#|@A#
=p@A#ݗ+k@A#g@A#@A#s@A$/{J#@A$q@A$o h@A$쿱[@A$쿱[@A$_@A$쿱[@A$1&@A$#x@A$@A$JM@A$>@A$>@A%V@A%/w@A%5Xy>@A%<64@A%2a|@A%5Xy>@A%B@A%B@A%F
L0@A%IQ@A%\@A%sg@A%w1@A%%@A%U=@A%n/@A%@A%@A%oiDg@A&_o @A&@A&($x@A&?@A&?@A&R<6@A&l!-@A&s@A&+J@A&O;@A&@A&'@A&Ϫ͟@A&@A&"@A'Xe@A''/W@A'.H@A'8}H@A'>6z@A'KƧ@A'iDg8@A'@A'$tS@A'-V@A'zH@A'@A'@A(     @A'#@A'rGE9@A(@A('RT`@A(73@A([6@A([6@A(bM@A(r Ĝ@A(n@A(IQ@A({@A(4m@A(
(@A(p:@A(D@A(4֡b@A(PH@A)+@A)&x@A)4J@A)Dg8~@A)Q@A)e+a@A)k~(@A)x@A)oiD@A)R<6@A)'RTa@A)'RTa@A)l@A)2W@A)@A)ᰉ'@A)R@A)Y}@A)-@A*#9@A*3@A*GE85@A*a|Q@A*qiC@A*ᰊ@A*L/{@A*vȴ@A*n@A*sP@A*fB@A*D@A+'/@A+	@A+6z@A+F]c@A+MjO@A+{J#9@A+eO@A+A@A+A@A+ߤ@A+ߤ@A+A@A+U=@A+Ƨ@A+Q@A+@A,@A,2W@A,PH@A,PH@A,PH@A,j~#@A,m8@A,wkP@A,j~@A,Ʌoi@A,@A,@A,e@A-u@A-qu"@A-*0@A-(@A-5Xy>@A-?|h@A-IQ@A-`A7L@A-}H@A-w1@A-!R@A-sh@A-Ϫ͞@A-@A-?@A-,=@A-(@A-oiDg@A._o @A.4K@A.4K@A.!R<@A.5?|@A.YJ@A.s@A.vȴ9X@A.s@A.IQ@A.$t@A.O;@A.$t@A.$t@A.O;@A.,<@A.O;@A.-@A.}Vl@A.2X@A.'@A.҈p;@A.Fs@A.!.I@A/$tS@A/>6z@A/As@A/U=@A/\(@A/b}V@A/iDg8@A/sPH@A/	@A/zH@A/?@A/-V@A/$tS@A/?@A/zH@A/vȴ9@A/@A/@A/@A/Vϫ@A/+j@A/#@A0@A0
qu@A0$xG@A04m9@A0A7K@A0:~ @A0K]c@A0NU@A0NU@A0Xy=@A0[6@A0eO@A0l"h	@A0l"h	@A0hۋq@A0eO@A0n@A0tj@A0{@A0)@A0TɅ@A0F@A0ѷX@A0F@A0)^@A04֡b@A0	k@A1	k~@A1#w@A1*0U2a@A1-w1@A10
)@A10
)@A1TɅo@A1e+a@A1rGE8@A1@A1R<6@A1n.@A1'R@A1^5?}@A1^5?}@A1ԕ*@A1lD@A2Ov`@A2=p
@A2@4n@A2C\@A2GE85@A2GE85@A2a|Q@A2h	ԕ@A2xl"h
@A2{m@A2ݘ@A2L_@A2\(@A2\(@A2}Vm@A2͞&@A2ڹY@A2c	@A2m\@A3S&@A3s@A3	@A3)^	@A36z@A3@N@A3F]c@A3J#9@A3S@A3g	l@A3~$@A3q@A3:)z@A3{J#9@A3~($@A3|@A3a@@A3a@@A3%2@A3lC@A3$@A4J@A4@A4Q@A4/{J#@A4<쿱@A4I^5?@A4M:@A4`d@A4m8@A4~($x@A4o h@A4~($x@A4zG@A4N;@A4_@A4쿱[@A4TɆ@A4@A4?@A4?@A4@A4e@A4>@A4E@A5u@A5qu"@A5!.H@A5%F
L@A5(@A5/w@A55Xy>@A5L_@A5\@A5fA@A5zxl"h@A5M:@A5ڹZ@A5hr!@A5hr!@A5hr!@A5hr!@A5!R@A5O
@A5@A5-V@A5\(@A5cA @A5cA @A5S@A5E@A6_o @A6@A6!R<@A6.2@A68YJ@A68YJ@A61.@A68YJ@A6;5X@A6BZc @A6BZc @A6fffff@A6iB@A6fffff@A6%@A6+J@A6@A6Fs@A6T@A62X@A6Q@A6A@A6Ϫ͟@A6C-@A6Fs@A6Fs@A7
M;@A7@A7Xe@A7!-w1@A7'/W@A71@A7>6z@A7Xe,@A7o@A7o@A7y@A7&@A7-V@A7&@A7zH@A73@A7r@A7r@A7/V@A7vȴ9@A7K]d@A7K]d@A7@A7fA@A7;dZ@A7;dZ@A7rG@A7-@A7Vϫ@A8F]d@A8	ԕ+@A8@A8'RT`@A8A7K@A8K]c@A8Q@A8U2a|@A8_F@A8bM@A8Xy=@A8hۋq@A8oiDg8@A8r Ĝ@A8˒:*@A8@A8-
@A8tj@A8tj@A8u%F@A8
=q@A8
=q@A8d8@A8U@A84m@A8)@A8ěT@A84m@A8)^@A8F@A84֡b@A84֡b@A8@A8@A8\)@A8	k@A9$/@A9_p@A9 [7@A90
)@A9=b@A9A [@A9JE@A9Q@A9hr @A9hr @A9hr @A9b}@A9n.@A9X@A9@A9o@A9N;6@A9"`@A9"`@A9ԕ*@A9ᰉ'@A9@A9.H@A:@A:Ov`@A:1'@A:0U2a|@A::)y@A:=p
@A:JL@A:Q_@A:M@A:JL@A:Q_@A:Zc@A:d7@A:h	ԕ@A:xl"h
@A:L_@A:\(@A:\(@A:ᰊ@A:S&@A: ě@A:}Vm@A:n@A:W@A:͞&@A:,<@A:ڹY@A:ڹY@A:䎊q@A:C,@A:c	@A:m@A:m\@A;I^@A;҉@A;S&@A:m\@A;u%@A;u%@A;҉@A;PH@A;"`B@A;)^	@A;,zxl@A;6z@A;=K^@A;=K^@A;=K^@A;C%@A;MjO@A;J#9@A;S@A;W>6z@A;dZ@A;n.3@A;qu!@A;n.3@A;xF]@A;xF]@A;@A;@A;eO@A;q@A;eO@A;U=@A;S@A;q@A;E@A;@A;6@A;a@@A;Q@A;҈@A;g@A;\N@A<!-w2@A<"h	ԕ@A<%1@A<"h	ԕ@A<"h	ԕ@A<(\@A<9XbN@A<Fs@A<Z1@A<cA \@A<j~#@A<q@A<q@A<zG@A<?@A<?@A<qj@A<*1@A<3@A<쿱[@A<O
M@A<O
M@A<@A<[W?@A<@A<֡a@A<D@A<!-w@A<hr@A<!-w@A<>@A<>@A=u@A=qu"@A=qu"@A=*0@A=%F
L@A=+a@A=/w@A=5Xy>@A=<64@A=5Xy>@A=B@A=Vl!@A=p
=@A=$/@A=M:@A=ڹZ@A=hr!@A==K@A=@A=v@A=v@A=U=@A=Xy=@A=1@A=8Y@A=8YK@A=?@A=(@A=oiDg@A=!.@A=ڹ@A>_o @A>
L/@A>4K@A>u@A>u@A>@A>Ov_@A>!R<@A>+jg@A>+jg@A>8YJ@A>5?|@A>?@A>E@A>H@A>H@A>R<6@A>_ح@A>iB@A>p:~@A>z@A>s@A>s@A>z@A>IQ@A>qi@A>$t@A>O;@A>,<@A>af@A>6z@A>Q@A>&I@A>]cf@A>1@A>1@A>쿱[W@A>Mj@A>@A>Fs@A>"@A?@A?
=p@A?)^@A?Xe@A?@A?Xe@A?,@A?$tS@A?'/W@A?1@A?1@A?8}H@A?8}H@A?>6z@A?RT`e@A?Xe,@A?o@A?4m@A?	@A?O;d@A?ݗ+@A?O;d@A?	@A?kP@A??@A?/V@A?o @A?˒:)@A?;dZ@A?-@A?䎊r@A?rGE9@A?rGE9@A?䎊r@A?rGE9@A@*0U@A@$xG@A@'RT`@A@-
q@A@:~ @A@H@A@K]c@A@Q@A@U2a|@A@Q@A@U2a|@A@Q@A@NU@A@Xy=@A@U2a|@A@[6@A@_F@A@eO@A@u!@A@y=c@A@y=c@A@oiDg8@A@|@A@y=c@A@'RT@A@@A@IQ@A@
=q@A@-
@A@@A@{@A@{@A@@@A@F@A@ѷX@A@@@A@ۋq
@A@҈p@A@҈p@A@@A@C@A@4֡b@A@C@A@4֡b@A@$tT@AA	k~@AA_p@AA&x@AA#w@AA#w@AA@AA-w1@AA*0U2a@AA0
)@AA-w1@AA4J@AAA [@AADg8~@AAGz@AAN;5@AAN;5@AA[W>6@AA^@AAk~(@AAx@AA7Kƨ@AAoiD@AAoiD@AA7Kƨ@AA@AAR<6@AAn.@AA'R@AAX@AAX@AA'R@AA^5?}@AAX@AA@AAD@AA@AAy@AAy@AAy@AAN;6@AA_o@AA_o@AAԕ*@AA@AAiB@AAR@AA-@ABn@ABOv`@AB䎊@AB&IR@AB)y@AB3@AB3@ABT`d@ABZc@AB^5?|@ABZc@ABh	ԕ@ABkP|@ABkP|@ABkP|@AB~"@ABݘ@ABvȴ@ABL/{@ABS&@AB ě@AB ě@AB ѷ@AB ѷ@AB ѷ@ABڹY@AB ѷ@AB ѷ@AB䎊q@AB~@ABD@ABm\@ACu%@AC'/@AC'/@ACu%@AC'/@ACC,z@AC&@AC,zxl@AC6z@AC/V@AC@N@ACMjO@AC]cA@ACjf@ACqu!@ACxF]@AC@ACQ@ACq@AC~$@AC:)z@ACMj@ACq@AC$@AC:)z@ACMj@ACMj@ACMj@ACwk@AC*0U2@ACE@ACE@AC~($@AC|@ACQ@ACa@@ACQ@ACA [@AD1&y@ADߤ@@ADxF@AD@ADL_@ADL_@AD%1@AD"h	ԕ@AD,<@AD64@ADFs@ADI^5?@ADPH@ADPH@AD]ce@AD]ce@ADSMj@ADtSM@ADN;@ADqj@ADqj@ADqj@ADN;@AD쿱[@ADzxl"@AD1&@AD@AD#x@AD#x@ADj~@ADj~@AD#x@ADj~@AD7@ADɅoi@ADZ@AD>B[@ADZ@AD@ADhr@AD!-w@ADE@AEo i@AE[@AEqu"@AE!.H@AEQ@AE+a@AE(@AE2a|@AE5Xy>@AE/w@AE2a|@AEO;dZ@AE\@AEfA@AEjOv@AEm\@AE}H@AEM:@AEڹZ@AE!R@AEO
@AE=K@AEU=@AE-V@AE-V@AEH˒@AE@AE@AE?@AE?@AE(@AEoiDg@AEC\@AEoiDg@AF4K@AF
(@AFzG@AF@AFu@AF@AFzG@AF!R<@AF!R<@AFOv_@AFu@AF+jg@AFVu@AFVu@AFYJ@AFc	@AFfffff@AFl!-@AFl!-@AFs@AFvȴ9X@AF+J@AF+J@AFqi@AFT@AF2X@AF}Vl@AF}Vl@AFQ@AFm\@AFȴ9X@AFt@AFA@AFm\@AF]cf@AF]cf@AF"@AG
M;@AG,@AG,@AGXe@AGXe@AG$tS@AG$tS@AG$tS@AG'/W@AG'/W@AG$tS@AG$tS@AG$tS@AG$tS@AG'/W@AG'/W@AG'/W@AG,@AG!-w1@AG'/W@AG'/W@AG'/W@AG+I@AG1@AG.H@AG1@AG1@AG4֡a@AG1@AG;dZ@AGXe,@AGb}V@AGlC@AGeں@AGiDg8@AGo@AGy@AGy@AG|hs@AG	@AGO;d@AG	@AGO;d@AGݗ+@AG@AGkP@AG	k@AG	k@AG	k@AGkP@AG3@AG@AG˒:)@AG˒:)@AG@AG@AGVϫ@AG-@AG-@AGrG@AHF]d@AH     @AG#@AH     @AH	ԕ+@AH@AH6@AH}H@AH6@AH$xG@AH4m9@AH>BZc@AHH@AHNU@AHU2a|@AHU2a|@AHU2a|@AHXy=@AHhۋq@AHl"h	@AHu!@AHoiDg8@AHoiDg8@AHl"h	@AHu!@AH˒:*@AHu!@AH˒:*@AHn@AH'RT@AH@AHYJ@AHIQ@AH@AH{@AH)@AHěT@AH@@AH)^@AH)^@AH4֡b@AH4֡b@AH4֡b@AH{@AH	k@AH$tT@AHPH@AI$/@AI ѷ@AI@AI@AI_p@AI+@AI@AI@AI@AI [7@AI&x@AI*0U2a@AI0
)@AI4J@AIA [@AIGz@AIJE@AIN;5@AIQ@AIJE@AI^@AI^@AIe+a@AIrGE8@AI|Q@AI@AI@AI@AIoiD@AIoiD@AI~($@AI@AI@AIo@AIR<6@AIo@AI@AIl@AI^5?}@AI@AI^5?}@AIo@AIy@AIN;6@AIԕ*@AI"`@AIiB@AIiB@AIiB@AIR@AIs@AI>BZ@AIR@AI@AIR@AI>BZ@AIs@AIlD@AJu%F@AJn@AJs@AJ)y@AJ&IR@AJ)y@AJ)y@AJ&IR@AJ6C@AJ=p
@AJ@4n@AJGE85@AJGE85@AJGE85@AJT`d@AJQ_@AJT`d@AJW'@AJd7@AJd7@AJa|Q@AJa|Q@AJd7@AJkP|@AJh	ԕ@AJh	ԕ@AJkP|@AJkP|@AJqiC@AJnO@AJݘ@AJ~"@AJ~"@AJݘ@AJݘ@AJ~"@AJ@4@AJ@4@AJS&@AJ0
@AJ0
@AJ0
@AJwkQ@AJS&@AJL/{@AJL/{@AJwkQ@AJwkQ@AJS&@AJvȴ@AJS&@AJS&@AJ@AJ ě@AJ>B@AJY@AJ<64@AJn@AJY@AJn@AJ@AJn@AJ)_@AJ)_@AJ͞&@AJڹY@AJ ѷ@AJG{@AJ ѷ@AJD@AJm@AJc	@AJfB@AJm@AJ74@AJ~@AJm\@AJm\@AJ74@AJD@AJ74@AJ~@AJ74@AJm\@AKu%@AKu%@AK҉@AK'/@AKPH@AK	@AK	@AK"`B@AK)^	@AK,zxl@AK/V@AK@N@AKF]c@AKJ#9@AKJ#9@AKP{@AKP{@AKW>6z@AKZ@AKS@AKW>6z@AKZ@AKZ@AK]cA@AK]cA@AKdZ@AKa@N                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 @s+33333@s1@s1@s1@s333333@s6fffff@s6fffff@s333333@s1@s)@s)@s1@s,@s&fffff@s&fffff@s,@s333333@s6fffff@s6fffff@s6fffff@s4@s1@s333333@s333333@s1@s333333@s333333@s1@s!@sfffff@s33333@s@s@s@sI@s@s33333@s\@s333333@sc33333@ss33333@s     @s@s33333@sx     @sffffff@sX     @s^fffff@si@snfffff@sp     @sh     @sc33333@sa@sY@sP     @sNfffff@s\@sY@sY@s[33333@sY@sS33333@s@r@r33333@r@s	@s!@s>fffff@sC33333@s6fffff@s+33333@r@r@rp     @ra@ra@rffffff@rh     @rp     @rfffff@r33333@q     @p@pvfffff@pQ@pI@pd@p33333@p񙙙@q;33333@qVfffff@qK33333@lə@lS33333@k@k33333@l	@lL@lY@l     @k@i     @i@ivfffff@iI@hp     @g33333@g33333@f@fٙ@f     @fə@f@ffffff@f@f陙      @e@e|@effffff@eY@eP     @eL@eL@e@     @e@efffff@d     @d33333@d     @dvfffff@di@dffffff@dY@d	@cy@cY@cVfffff@c\@ci@c     @c@c@c33333@b33333@b@bfffff@b33333@bl@bP     @b@     @b<@bFfffff@bY@bvfffff@b33333@b     @a@a     @a|@ay@a|@a@a33333@a33333@aə@a33333@afffff@`fffff@`33333@`     @``     @`333333@`     @`@`      @`C33333@`i@`     @^fffff@^@^33333@^33333@^33333@^@^@^@_@_33333@\fffff@\@\l@\@     @\333333@\9@\,@\@     @\33333@]fffff@]      @Z     @Zy@Zl@Zy@Z@Zfffff@Zٙ@Z@[33333@Yfffff@Ys33333@YS33333@Y9@Y&fffff@Y,@YFfffff@Ys33333@Yy@Xfffff@Xfffff@X`     @X,@X&fffff@XFfffff@Xs33333@X33333@Xfffff@X@Vfffff@Vfffff@Vfffff@V@     @V&fffff@Vy@V33333@W      @U@     @UFfffff@U@     @U9@U333333@U33333@T@T33333@T@T@T@T33333@T@T`     @Sfffff@S33333@S     @S33333@S@S@Sfffff@Ss33333@SFfffff@S&fffff@S@S@S      @R33333@R@S      @S33333@S33333@R333333@R9@RFfffff@R@     @R&fffff@Q@Qfffff@Q33333@Qs33333@QS33333@Q9@Q9@QFfffff@QS33333@Q`     @Q`     @P@Pfffff@P33333@P@P@P     @P33333@P     @Pffffff@PS33333@P9@P9@P@     @P@     @P@     @P      @O@O@O@O@O@Offfff@O     @O@     @Nfffff@Nfffff@N33333@N33333@O      @O      @O      @M@Mfffff@M@M     @M     @M     @Ms33333@M@     @ML@ML@M&fffff@Ls33333@LL@L@     @L333333@L&fffff@L&fffff@L@L@L&fffff@L333333@L333333@Ks33333@KY@KY@K333333@K@K      @J33333@J33333@J33333@J@J     @J33333@Jfffff@J     @JY@J333333@J@J      @I33333@I     @I@I@Ifffff@Ifffff@J@H@H@H@H     @Hfffff@I@I333333@I&fffff@HL@HL@H@     @H333333@H      @Gٙ@Gfffff@Gs33333@Gffffff@GY@GY@G@G     @G@F@F     @F     @F@F33333@F     @F     @F     @F     @F     @F     @F333333@F333333@F@     @FY@FL@FL@E333333@E@     @E333333@E@     @Effffff@E@E33333@E     @DL@Dffffff@Ds33333@D@D33333@D     @D     @D@D&fffff@D333333@DL@C@C@C@C&fffff@C&fffff@C&fffff@C@     @CY@Cffffff@B@B      @B      @A33333@A33333@B      @B@BL@BY      @Afffff@A@A@Affffff@As33333@AL@A@     @A@@ٙ@@     @@fffff@@fffff@@fffff@@fffff@@s33333@@Y@@@     @@333333@@333333@@333333@@333333@@&fffff@@&fffff@@      @?fffff@?@?@?@?     @?ffffff@?L@?L@?@?333333@?      @?@?      @?@?      @>fffff@>@>L@>L@>333333@>333333@=L@=@=@=@=@=@=      @=      @<@<33333@<fffff@<@<333333@<@;@;@;fffff@<      @<@<      @<@<333333@;     @;@;@;@;33333@;@;@;33333@;33333@;@;ffffff@;@:fffff@:@:33333@:33333@:fffff@:@:33333@:fffff@:@:@:@:@:     @:     @:@:@:@:ffffff@:L@:L@:333333@:333333@:333333@:333333@:@:      @:@:      @9fffff@9fffff@9fffff@9fffff@9@933333@9@9L@9      @8fffff@8fffff@8fffff@8fffff@8@8@833333@8     @8@8@833333@833333@8@8L@8333333@8333333@8@8@8@8@8L@8L@7@733333@7@733333@7@7@733333@733333@7@7@7@7@7@7ffffff@7ffffff@7ffffff@7L@7333333@7@7@7      @7333333@7@7333333@7      @7      @6fffff@6fffff@6fffff@6fffff@7      @6fffff@6fffff@6fffff@6fffff@6fffff@6@6L@6L@6@6@6333333@6@6333333@6@6      @533333@5@533333@5fffff@5fffff@5ffffff@5ffffff@5ffffff@5ffffff@5L@5ffffff@5@5     @5L@5L@4@433333@4fffff@433333@4fffff@4fffff@4@4fffff@4333333@4333333@4@4333333@4333333@4333333@4L@4ffffff@4L@3fffff@3fffff@3fffff@4      @3fffff@4      @4      @4      @3fffff@3fffff@3fffff@3@333333@3@3@3@3     @3     @3     @3     @3     @3@3@3L@3ffffff@3L@3L@3L@3L@3L@3L@3L@3L@3L@3L@3333333@3@3333333@3@3      @3@3@3@3333333@3@3333333@3@2fffff@2fffff@2@2fffff@2fffff@2fffff@2fffff@3      @3      @233333@233333@233333@2@2@233333@2@2fffff@2L@2     @2ffffff@2L@2     @2     @2L@2L@2L@2L@2L@2@2@2@2@2@2333333@2333333@2333333@2@2@2@2@2@2      @2      @2333333@2      @1fffff@1@1fffff@2      @1@1fffff@133333@1@133333@133333@1@1@133333@1     @1@1@1@1@1@1L@1     @1ffffff@1ffffff@1     @1L@1L@1L@1L@1L@1      @1@1333333@1@1333333@1L@1@1@1@1      @1      @1      @1@1@1      @1      @1      @0fffff@1      @1      @0fffff@0fffff@1      @0@0fffff@0@0fffff@033333@033333@0@0@0@0@0@0@0@033333@0@033333@0@0fffff@0@0@0@0     @0     @033333@033333@0@0ffffff@0@0ffffff@0ffffff@0ffffff@0ffffff@0     @0     @0ffffff@0L@0L@0L@0ffffff@0L@0L@0ffffff@0L@0L@0333333@0@0333333@0@0@0333333@0@0@0      @0      @0      @0      @0@0      @/@/@/ffffff@/@/@/@/@/@/@/@/ffffff@/ffffff@/ffffff@/ffffff@/333333@/333333@/333333@/333333@/333333@/333333@/      @/333333@.@.@.@.@/      @/      @.@.@.@.@.@/      @/      @.@.@/      @/      @.@.@.ffffff@.@.@.@.ffffff@.ffffff@.ffffff@.ffffff@.@.@.@.@.ffffff@.333333@.ffffff@.ffffff@.333333@.333333@.ffffff@.333333@.      @.333333@.333333@.      @-@-@.      @.      @.      @.      @-@-ffffff@-@-ffffff@-@-ffffff@-ffffff@-@-@-      @-333333@-ffffff@-333333@-333333@-ffffff@-      @-333333@-ffffff@-ffffff@-ffffff@-      @-      @-333333@-333333@-333333@-ffffff@-      @-333333@-333333@-      @-333333@-333333@-333333@-333333@-333333@-      @-ffffff@-      @-333333@-333333@-333333@,@,@-333333@,@,@-      @-333333@-      @,@-      @-333333@,@-      @-      @,@-333333@,@-333333@-      @,@,@-      @-      @,@-      @,@-      @-      @-      @-      @,@-333333@,@-      @-333333@-333333@,@-      @-      @-      @,@-      @-      @-      @,@,@,@-      @-      @-333333@,@-      @,@-      @,@,@,@,@-      @,@,@-      @,@,@,@,@,@,@,@-      @,@,@-333333@,@,@,@,@-      @,@,@-      @,@,@-333333@-      @,@,@,@,@-      @-ffffff@-333333@-333333@-      @,@-333333@-333333@-333333@-333333@-      @-      @-      @-333333@-333333@-333333@-333333@-      @-ffffff@-ffffff@-333333@-ffffff@-ffffff@-333333@-@-ffffff@-@-ffffff@-@-@-@-@-@-@-ffffff@-@.      @.      @-@-@.      @-@.333333@-@-@.      @.      @-@-@.333333@.ffffff@.333333@.333333@-@.333333@.ffffff@.@.@.333333@.ffffff@.@.@.ffffff@.@.ffffff@.@/      @.@.ffffff@.@.@.@.@.@.@/      @.@.@.@.@/      @/      @.@/      @/      @.@/      @/333333@/333333@/333333@/      @/ffffff@/333333@/333333@/@/ffffff@/@/@/ffffff@/@/@/@/@0@/@/@/@0      @0@0@0@0@0@0333333@0333333@0L@0L@0L@0L@0L@0     @0     @0ffffff@0ffffff@0ffffff@0     @0     @0ffffff@0@0@0ffffff@033333@0@0@033333@033333@033333@0@0fffff@0@0fffff@0fffff@0@0fffff@0fffff@1      @0fffff@0@0fffff@0fffff@0fffff@1      @1@0fffff@1@1@1333333@1333333@1      @0fffff@1@1L@1333333@1333333@1ffffff@1333333@1333333@1333333@1ffffff@1ffffff@1L@1     @1     @1L@1ffffff@1ffffff@1ffffff@1ffffff@1     @1@1@1@133333@133333@133333@2      @1fffff@1@2      @2      @1fffff@2      @2@2@2333333@2L@2L@2@2L@2ffffff@2ffffff@2ffffff@2L@2L@2ffffff@2     @2ffffff@2     @2@233333@2@2fffff@233333@233333@2@2@2fffff@2@3      @3@3@3      @3333333@3L@3@3@3L@3     @3L@3L@3@3@3@333333@333333@3fffff@3@333333@3fffff@3fffff@3@3fffff@4@4L@4@4333333@4L@4L@4ffffff@4ffffff@4L@4ffffff@4@4@4     @4     @4@4@433333@4@4@433333@433333@433333@4@4@5      @4fffff@5      @5@4fffff@4fffff@4fffff@5@5333333@5333333@5333333@5333333@5333333@5L@5ffffff@5     @5     @533333@533333@533333@5@5@5@533333@5@5@6      @5fffff@5@6      @6      @6      @6@6@6333333@6L@6L@6333333@6333333@6ffffff@6     @6     @6@6@6fffff@6@6@6@7      @7@7@7333333@7333333@7L@7ffffff@7ffffff@7ffffff@7     @7ffffff@733333@7     @733333@7     @7fffff@8@8      @7fffff@8      @8      @8@8@8      @8@8     @8L@8@8333333@8333333@8L@8L@8333333@8@8ffffff@8     @8@8@8@833333@8fffff@8@8@8     @9      @9      @8fffff@9@9333333@9      @9@9333333@9333333@9333333@9333333@9     @9L@9@933333@933333@9     @9     @9@9@9@933333@933333@933333@:@9fffff@9fffff@:      @:      @:333333@:L@:L@:L@:L@:ffffff@:ffffff@:     @:     @:33333@:@:@:33333@:33333@:@:@:@:fffff@:fffff@:fffff@;      @;@;      @:fffff@;@;@;333333@;333333@;L@;ffffff@;@;33333@;@;33333@;@;@;33333@;@<333333@<ffffff@<     @<333333@<333333@<333333@<@<333333@<@<@<@<@<@<@<@=333333@=ffffff@=L@=     @=     @=ffffff@=ffffff@=@=@=fffff@=fffff@=@=@>      @>      @>333333@>@>333333@>333333@>      @>@>     @>@>fffff@?      @>@>33333@>33333@>33333@>33333@?@?333333@?@?333333@?@?333333@?L@?@?L@?     @?33333@?33333@?@?33333@?fffff@?@?fffff@@@@&fffff@@&fffff@@333333@@@     @@333333@@@@Y@@Y@@ffffff@@s33333@@@@@@@@@@@@     @@ffffff@@     @@fffff@@     @@ٙ@@fffff@@     @@33333@@ٙ@A      @A      @A@A@A@@33333@A      @A@A@     @A@     @A333333@A@     @A333333@A333333@A333333@As33333@A@A@Afffff@A@A@A@A@A33333@A     @A33333@A     @Afffff@B      @B@B333333@B@B@B333333@B@     @BL@Bffffff@BY@B     @B     @Bs33333@B     @Bfffff@B     @B@Bٙ@B33333@B33333@B     @B33333@B@C      @C@C@C@C      @C      @C@C@C@C@C333333@CY@C@C@C@Cfffff@C@Cfffff@C33333@C@C@C33333@Cfffff@C33333@C33333@C33333@Cfffff@D@D@D@D&fffff@D@D333333@D@Dffffff@Ds33333@D@Dfffff@D33333@D33333@D@D     @D@D@Dfffff@D     @D33333@D@D33333@Dٙ@Dٙ@D     @D     @D     @D@D     @D33333@Dٙ@D@Dٙ@D@D     @Dٙ@Dٙ@Dfffff@D@D     @D33333@Dfffff@E      @E      @E333333@E&fffff@E@E@E@E@     @E@     @E333333@E@     @EL@Effffff@Es33333@Effffff@Effffff@EY@Es33333@E33333@Eٙ@Efffff@Eٙ@Eٙ@Eٙ@E33333@Eٙ@E33333@E@F      @F      @F      @F@     @FL@FL@FL@F333333@FY@F@F@Ffffff@Ffffff@F33333@F33333@F@F     @F@Ffffff@G      @G      @Ffffff@Ffffff@F33333@F33333@F33333@F33333@G&fffff@G@G&fffff@G@G      @G@     @GL@G@     @GY@Gs33333@GY@GY@Gs33333@G     @G@Gfffff@G@Gfffff@G33333@G33333@Gٙ@G@G     @Gfffff@G@Gٙ@G@G33333@Gfffff@Gٙ@H      @H      @H@H&fffff@H&fffff@H&fffff@H@     @HL@H333333@H333333@HY@HY@H     @H@H@Hfffff@H@Hfffff@H@H@H@H@H33333@Hfffff@H     @H     @I      @H33333@Hfffff@Hٙ@H@I@I&fffff@I333333@IY@I@     @I&fffff@I333333@I333333@IL@IY@IY@Iffffff@Is33333@IY@Is33333@Is33333@I@I@I@Ifffff@I33333@Ifffff@I33333@I@I@Iٙ@I33333@Ifffff@J@J      @Ifffff@J&fffff@J@J&fffff@J&fffff@J@J&fffff@J333333@JL@JL@JL@J@     @JL@JL@J@     @J@     @JL@JY@JL@Js33333@Js33333@Jffffff@J     @J     @J@J@J     @J@Jfffff@Jfffff@Jfffff@Jfffff@Jfffff@Jfffff@Jfffff@J@Jfffff@Jfffff@Jfffff@Jfffff@Jٙ@Jfffff@Jٙ@J@Jٙ@J@Jٙ@Jٙ@J@J33333@K      @K&fffff@K@K      @K      @K      @K@     @K&fffff@K&fffff@K&fffff@K@     @KL@K@     @KL@Kffffff@KL@KY@KY@Kffffff@KL@Kffffff@Kffffff@Ks33333@K     @K@K@K@Kfffff@K33333@Kfffff@K@K@Kٙ@K     @Kٙ@K33333@L      @K@Kٙ@K33333@K33333@K33333@L      @L      @L      @L&fffff@L&fffff@L&fffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 ?ffffff?1&x?\(\?n?bM?$/?~"?ڏ\(?bM?xF?7KƧ?ffffff?m?dZ1?"`A?+?ěS?QR?zG?nP?lC?QR?1&x?vȴ9X?+?9XbN?A7Kƨ?hr Ĝ? ě?$/?Q?`A7?E?zG?QR?o?ȴ9Xb?bM?Ƨ-?$/?-V?n?1&?n?(\)?$/?lC?;dZ?+I?;dZ?I^5?}?j~"?-V?E?E?nP?
=p?&x?E?j~"?nP?vȴ9X?+?|hr?r ě?"`B?+?Q?ěS?ָQ?vȴ9X?+?أ
=p?Ցhr ?E?zG?lC?lC?E?љ?љ?Ѻ^5?|?hr Ĝ?j~"?/v?̬1&y?ə?n?"`A?^5?|?ɺ^5?|?Ƈ+I?$/?+J?KƧ?Ƈ+I?tj?lC?lC?x?+?+?A7Kƨ?E?Õ$/?tj~?öE?Q?`A7?l?$/?nO?E?šo?+?+?Q?-V?-V?GzH?1&y?-V?S?° ě?&x?Q?öE?7KƧ?tj~?&x?I^5??bM?Õ$/?zG{?hr Ĝ?n?M?`A7L?"`?M?7KƧ?° ě?vȴ9X?;dZ?-V?-V?;dZ?      ?S?ěS?&x? ěT?n?GzH?A7Kƨ?
=p?nO;?nO?nP?-V?`A7L?l?
=p?`A7?I^5??7KƧ?      ?ěS?S?      ?Õ$/?° ě?`A7L?hr Ĝ?-V?l?`A7L?&x?`A7L?-V?tj?-V?° ě?lD?-V?GzH?hr Ĝ?-V?\(?&x?Q?7KƧ?\(?`A7?7KƧ?7KƧ?nP?vȴ9X?S?&x?Õ$/?
=p?ěS?
=p?ěS?-V?&x?Q?ěS?      ?333333?$/?\(?7KƧ?lD?S?tj? ěT?nO?n?° ě?M?hr Ĝ?$/?I^5??/w?\(?nO;?Q?
=p?l?° ě?7KƧ?`A7L?Q?nO;?nO;?n?I^5??+?n?
=p?Õ$/?lD?° ě?vȴ9X?`A7?`A7L?-V?\(?
=p?$/?$/?9XbM?|hr?\(?
=p?-V?\(?lD?\(?lD?I^5??ěS?&x?M?Q?bM?lD?ěS?tj?
=p?$/?|hr?`A7L?lD?° ě?n?\(?`A7?n?hr Ĝ?I^5??E?n?333333?
=p?I^5??tj~?I^5??`A7?nO?-V?nP?Õ$/?Õ$/?öE?-V?333333?n?ěS?\(?M?$/?hr Ĝ?+?-V?öE?Q?&x?S?\(?&x? ěT?° ě?`A7?-V?Q?vȴ9X?tj?`A7?M?Q?lD?nO;?333333?M?n?M?\(?Õ$/?hr Ĝ?      ?n?`A7?Q?M?&x?333333?° ě?      ?nO?333333?lD?
=p?7KƧ?° ě?`A7?+?l?nO?zG{?öE?ěS?tj~?Q?-V?° ě?;dZ?$/?S?I^5??\(?ěS?A7Kƨ?I^5??7KƧ?333333?Õ$/?-V?tj~?tj~?-V?Z1'?tj~?`A7?`A7L?nO;?-V?Q?-V?`A7?tj?7KƧ?7KƧ?9XbM?9XbM?GzH?n?l?nO;?-V?&x?9XbM?
=p?n?A7Kƨ?S?
=p?tj?° ě?M?`A7L?-V?&x?&x?-V?/w?tj~?öE?-V?-V?nO;?\(?$/?GzH?lD?-V?Q?zG{?Õ$/?-V?A7Kƨ?hr Ĝ?bM?l?7KƧ?Q?l?zG{?° ě?/w?`A7?lD?l?\(?bM?lD?-V?+?E?S?M?7KƧ?Z1'?lD?/w?333333?n?nO?tj~?`A7L?S? ěT?lD?333333?/w?nO?-V?-V?nO?° ě?tj~?n?GzH?nO?7KƧ?hr Ĝ?Õ$/?+?öE?° ě?tj~?nO;?
=p?S?tj~?l?Õ$/?l?+?S?Q?+?nO;?ěS?333333?I^5??nO?-V?nO?9XbM?zG{?nO;?
=p?Õ$/?
=p?l?nO;?öE?\(?S?ļj~#?&x?M?7KƧ?hr Ĝ?`A7L?I^5??Õ$/?Õ$/?Z1'?nP?S?tj~?Õ$/?\(?E?-V?-V?nO;?I^5??$/?I^5??n?lD?nO?+?n?`A7?S?-V?M?7KƧ?l?tj?tj~?-V?nP?lD?$/?Õ$/?7KƧ?GzH?n?\(?-V?`A7?M?nO;?7KƧ?GzH?GzH?`A7?n?tj?lD?7KƧ?GzH?7KƧ?l?Õ$/?l?l?n?° ě?-V?S?
=p?`A7?`A7?nO?bM?7KƧ?Q?öE?Q?nP?/w?Q?tj~?\(?ěS?lD?n?S?nO;?Õ$/?E?`A7?\(?Z1'?nO;?
=p?l?7KƧ?M?S?° ě?-V?lD?\(?S?l?S?šo?\(?I^5??° ě?S?nO;?nO;?&x?S?S?333333?`A7L?M?&x?ěS?p
=q?S?Õ$/?n?&x?Q?nO?-V?nO?E?E?M?nO;?&x?9XbM?S?n?E??|hs?`A7?tj?Z1'?S?Õ$/?9XbM?-V?-V?-V?-V?`A7?`A7K?\(?-V?lD?n?Q?Q?GzH?\(?n?lD?\(?šo?`A7?n?\(??|hs?ěS?333333?
=p?tj?
=p?\(?ěS?333333?Q?° ě?333333?I^5??° ě?ěS?Q?E?tj~?7KƧ?bM?Q?ěS?tj?`A7?`A7?n?hr Ĝ?tj?M?7KƧ?
=p?S?nO?hr Ĝ?tj?`A7??|hs?`A7?nO?M?ļj~#?&x?nO?Q?hr Ĝ?S?S?-V?nO;?333333?-V?bM?+?ļj~#?hr Ĝ?I^5??Õ$/?E??|hs?Z1'?-V?
=p?l?Õ$/?zG{?lD?&x?\(?7KƧ?$/?\(?GzH?+?Õ$/?
=p?&x?nO;?Q?l?S?`A7?&x?I^5???|hs?I^5??&x?S?+?° ě?Q?333333?S?S?öE?tj~?M?l??|hs?tj~?-V?I^5??° ě?+?\(?l?° ě?
=p?
=p?
=p?/w?333333?öE?333333?ěS?\(?M?l?ļj~#?Z1'?Z1'?° ě?`A7?GzH?n?I^5??zG{?-V?nO;?S?-V?Q?/w?° ě?-V?/w?-V?-V?+?I^5??S?-V?öE?° ě?nO;?333333?Õ$/?šo?9XbM?S?nO;?\(?l?bM?7KƧ?`A7?`A7?tj?333333?-V?I^5??333333?333333?Z1'?° ě?M?° ě?tj?nO?nO?zG{?
=p?`A7?Z1'?ěS?tj~?333333?hr Ĝ?nO?-V?$/?-V?GzH?šo?(\)?&x?-V?ěS?`A7?l?lD?ļj~#?n?333333?`A7L?
=p?9XbM?Õ$/?ěS?333333?Z1'?bM?nO;?-V?M?M?ěS?&x?l?tj?-V?`A7?-V?E?öE?hr Ĝ?\(?`A7?öE?9XbM?\(?l?S?nO?7KƧ?`A7?nO;?$/?/w?nO;?l?tj~?
=p?Q?E?M?I^5??333333?l?`A7?-V?\(?+?ěS?tj~?Z1'?-V?`A7L?-V?`A7?Õ$/?n?Z1'?tj~?7KƧ?`A7?M?tj~?S?GzH?I^5??l?M?nO?9XbM?Q?Õ$/?tj~?öE?l?S?Z1'?$/?\(?A7Kƨ?hr Ĝ?S?-V?
=p?+?I^5??nO?+?l?Ƨ-?M?l?E?
=p?S?Õ$/?° ě?lD?$/?E?GzH?7KƧ?E?`A7K?lD?-V?333333?9XbM?tj?Z1'?Õ$/?E?9XbM?öE?l?E?I^5??Õ$/?öE?tj?l?nO?I^5??tj~?zG{?Õ$/??|hs?Õ$/?öE?bM?$/?nO;?n?° ě?tj?öE?$/?Q?I^5??ěS?`A7?nO?Q?-V?Q?$/?
=p?öE?M?S?\(?
=p?nO?S?+?hr Ĝ?I^5??l?`A7L?tj?`A7?lD?333333?nO?9XbM?-V?nO?7KƧ?\(?Õ$/?öE?tj~?
=p?n?° ě?Q?n?333333?`A7?l?l??|hs?nO?Q?`A7K?Q?tj~?E?\(?333333?\(?9XbM?zG{?nO?-V?
=p?° ě?tj~?M?tj~?tj?Z1'?`A7?$/?      ?Ł$/?E?° ě?S?hr Ĝ?° ě?      ?nO?lD?hr Ĝ?lD?Õ$/?
=p?šo?$/?Q?-V?9XbM?\(?n?° ě?l?nO;?ļj~#?M?tj~?-V?+?7KƧ?Q?S?9XbM?GzH?S?S?+?M?I^5??nO?7KƧ?hr Ĝ?-V?7KƧ?333333?n?nO;?Z1'?tj?+?nO?zG{?Q?-V?° ě?I^5??-V?333333?tj~?nO?-V?öE?S?° ě?l?"`??|hs?&x?ěS?nO?-V?
=p?\(?l?tj~?+?hr Ĝ?tj~?° ě?I^5??Õ$/?n?7KƧ?333333?-V?Z1'?
=p?° ě?9XbM?I^5??zG{?333333?I^5??Õ$/?nO?öE?-V?öE?\(?333333?M?M?° ě?      ?-V?333333?7KƧ?öE?`A7?\(?nO?tj?&x?S?-V?-V?$/?|hr?nO;?ļj~#?S?S?E?S?l?tj~?öE?M?`A7?tj~?GzH?-V?$/?`A7?öE?\(?7KƧ?lD?l?hr Ĝ?-V?-V?hr Ĝ?\(?° ě?`A7?`A7?E?M?Q?n?333333?\(?+?\(?GzH?M?n?-V?-V?hr Ĝ?\(?tj?ěS?
=p?-V?Õ$/?S?\(?lD?Õ$/?
=p?nO?$/?tj~?tj?`A7?-V?
=p?Õ$/?M?
=p?° ě?S?GzH?nP?hr Ĝ?I^5??Q?ěS?nO;?+?\(?n?Õ$/?+?S?° ě?-V?nO?zG{?Õ$/?l?l?M?tj~?tj~?l?E?nO?Õ$/?l?-V?hr Ĝ?öE?S?nO?`A7?
=p?nO;?333333?Q?tj?ěS?-V?Õ$/?° ě?\(?tj~?l?S?n?nO;?-V?bM?nO?\(?n?`A7?7KƧ?333333?
=p?9XbM?`A7?GzH?S?7KƧ?7KƧ?tj~?Õ$/?tj?-V?l?nO?tj?$/?I^5??7KƧ?lD?Õ$/?nO;?I^5??nP?I^5??Õ$/?Ł$/?ļj~#?333333?-V?\(?ěS?° ě?nO?nO;?nO;?nO?
=p?7KƧ?-V?+?Q?S?Q?
=p?7KƧ?öE?vȴ9X?S?nO?hr Ĝ?tj~?nO;?n?/w?/w?I^5??ļj~#?GzH?-V?\(?333333?&x?S?j~"?&x?nO;?
=p?      ?° ě?GzH?tj~?\(?° ě?M?333333?M?&x?l?nO;?Q?nO;?I^5??M?`A7?`A7?GzH?-V?333333?Q?-V?Q?Q?ěS?I^5??`A7?-V?nP?$/?$/?\(?\(? ěT?Q?nO;?nO?öE?nP?nO;?nO;?-V?7KƧ?333333?tj?nO;?nO;?
=p?333333?A7Kƨ?I^5??nO?bM?333333?lD?hr Ĝ?I^5??Q?nO;?M?l?\(?M?`A7L?hr Ĝ? ěT?öE?Q?° ě?7KƧ?Q?\(?S?-V?A7Kƨ?ěS?Z1'?`A7L?hr Ĝ?9XbM?tj~?hr Ĝ?hr Ĝ?333333?n?öE?tj?
=p?I^5??hr Ĝ?nO;?lD?l?nO;?l?nP?I^5??A7Kƨ?GzH?`A7?Q?° ě?`A7?tj~?hr Ĝ?ěS?öE?`A7?M?$/?öE?&x?$/?\(?M?vȴ9X?nO;?tj?° ě?vȴ9X?      ?A7Kƨ?nO;?hr Ĝ?      ?;dZ?7KƧ?I^5??tj~?-V?-V?° ě?`A7L?Q?A7Kƨ?Q?Q?`A7?nO;? ěT?ěS?I^5??l?tj~?lD?5?|h?&x?-V?-V?&x?nO;?-V?E?öE?-V?° ě?hr Ĝ?lD?-V?öE?S?nO;?M?GzH?n?S?hr Ĝ?-V?ěS?\(?tj~?hr Ĝ?$/?l?$/?-V?lD?l?tj~?ěS?M?GzH?;dZ?I^5??n?-V?7KƧ?7KƧ?GzH?° ě?M?/w?
=p?
=p?lD?l?\(?° ě?`A7?S?° ě?A7Kƨ?$/?-V?-V?Õ$/?
=p?ěS?
=p?hr Ĝ?Õ$/?      ?-V?`A7L?`A7?`A7L?&x?
=p?Z1'?$/?° ě?A7Kƨ?nO;?S?n?° ě?333333?I^5??A7Kƨ?n?I^5??l?° ě?ěS?"`?`A7L?M?I^5??-V?nO;?n?7KƧ?$/?-V?7KƧ?A7Kƨ?7KƧ?I^5??n?9XbM?-V?A7Kƨ?&x?ěS?tj~?nO;?° ě?ěS?hr Ĝ?I^5??$/?hr Ĝ?-V?n?° ě?GzH?lD?333333?l?$/?S?n?\(?Q?Q?333333?nO;?-V?nO;?hr Ĝ?GzH?tj?-V?GzH?`A7?
=p?Q?|hr?7KƧ?hr Ĝ?$/?      ?n?tj~??|hs?° ě?+?E?lD?Q?M?\(?n?l?n?GzH?      ?Q?;dZ?`A7L?-V?-V?/w?
=p?lD?öE?A7Kƨ?ļj~#?S?A7Kƨ?A7Kƨ?hr Ĝ?nO;?&x?&x?&x? ěT?A7Kƨ?&x?333333?I^5?? ěT?5?|h?\(?n?hr Ĝ?\(?I^5??j~"?j~"?lD?Q?ěS?tj~?&x?hr Ĝ?`A7L?|hr?n?&x?5?|h?`A7L?      ?;dZ?
=p?\(?GzH?A7Kƨ?öE?/w?S?° ě?bM?lD?-V?nP?A7Kƨ?I^5??-V?n?/v?Q?$/?öE?bM? ěT?\(?ěS?n?&x?|hr?ěS?-V?n?&x?° ě?9XbM?
=p?$/?S?Q?A7Kƨ?      ?      ?\(?ěS?nO?tj~?`A7?nO;?|hr?Q?&x?`A7L?lD?7KƧ?hr Ĝ?7KƧ?Q?M?lD?ěS?° ě?Q?|hr?Q?$/?M?ěS?l?-V?nO?|hr?hr Ĝ?7KƧ?j~"?A7Kƨ?A7Kƨ?`A7?7KƧ?Q?ěS?A7Kƨ?vȴ9X?nO;?n?GzH?l?tj?\(?
=p?Q?° ě?\(?I^5??$/?7KƧ?;dZ?E?`A7L?&x?lD? ěT?hr!?-V?p
=q?bM?n?-V?-V?tj~?lD?Q?$/?&x?Q?
=p?&x?A7Kƨ?\(?-V? ěT?
=p?-V?`A7L?j~"?nP?hr Ĝ?lD?-V?hr Ĝ?&x?7KƧ?j~"?vȴ9X?$/?Q?$/?;dZ?M?      ?&x?bM?M?A7Kƨ?A7Kƨ?GzH?$/?"`?A7Kƨ?Q?lD?&x?-V?&x?bM?`A7L?333333?E?nO;?7KƧ?n?\(?
=p?lD?bM?&x?nP?lD?A7Kƨ?$/?333333?-V?-V?&x?GzH? ěT?-V?° ě?Q?l?lD?hr Ĝ?|hr?&x?GzH?vȴ9X?l?bM?Q?$/?tj~?l?hr!?nO;?nO;?lD?I^5??M?° ě?333333?`A7?A7Kƨ?A7Kƨ?bM?nP?Q? ěT?A7Kƨ?S?7KƧ?&x?-V?hr Ĝ?tj                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	@OY@Offffff@Os33333@O     @Os33333@Os33333@Os33333@Os33333@Os33333@O     @O     @Os33333@Os33333@Os33333@Offffff@Offffff@Offffff@Os33333@O     @Os33333@Os33333@O@O     @O     @O     @O     @O     @O     @O@O     @O@O@Os33333@O@O     @O@     @Os33333@Offfff@O     @O33333@O@Offfff@Offfff@Oٙ@Oٙ@Offfff@Pfffff@O33333@Pfffff@P@P33333@P      @P      @P&fffff@P&fffff@P&fffff@P,@P,@P9@P,@P&fffff@P&fffff@P333333@PFfffff@PL@PS33333@PY@Pffffff@Py@Pfffff@P@P33333@P33333@P33333@P@P@P@P     @Pfffff@P@P33333@P33333@P@P@P@P@P@P@P@P@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P@P@P@P@P@P     @P@P@P@P@P@P@P@P@P33333@P33333@P@P@P@P33333@P33333@P@P@P@P@P@P33333@Pfffff@P33333@P@P@P@P33333@P@P33333@P@P@P@P@P@P33333@P@P@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P     @P@P@P@P@P     @P     @P@P@P     @P     @P     @P     @P     @P@P33333@P@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P@P@P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@P@P33333@P@P@P@P@P@P@Pfffff@Pfffff@Pfffff@P@P@P@Pfffff@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@Pfffff@P     @P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P@P33333@P33333@P@P@P@P33333@Pٙ@Pٙ@Pٙ@P33333@Pٙ@P33333@Pٙ@Pٙ@Pٙ@P33333@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P@Pٙ@P33333@Pٙ@Pٙ@Pٙ@P33333@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @P     @P     @P     @P     @P     @Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@P     @P     @Pfffff@P     @P     @Pfffff@P     @P     @P     @Pfffff@P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@P@Pfffff@P@Pfffff@Pfffff@Pfffff@P     @P     @P@P@P@P@Pfffff@P@Pfffff@P@Pfffff@Pfffff@P@P@Pfffff@P@P@P@P@P@P@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@P@P@P@P@P@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@P@P@P@P@P@P@Pfffff@P@P@P@P@P@Pfffff@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@Pfffff@Pfffff@Pfffff@P@P@P@P@Pfffff@P@P@P@P@Pfffff@Pfffff@P@P@Pfffff@P@P@P@P@P@Pfffff@P@P@P@P@P@P@Pfffff@P@P@P@P@P@Pfffff@P@P@P@P@Pfffff@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@Pfffff@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P@P@P@P@P@P33333@P@Pfffff@P33333@P@P@P33333@P@P33333@P@P33333@P@P@P33333@P33333@P@P33333@P@P@P33333@P@P@P@P33333@P@P@P@P33333@P33333@P33333@P33333@P@P33333@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P@P@P33333@P33333@P@Pfffff@P@P@P@P33333@P@P@P@P@P@P@P@P33333@P33333@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@Pfffff@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@Pfffff@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@Pfffff@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P@P33333@P33333@P@P33333@P33333@P33333@P33333@P@P@P@P@P@P33333@P33333@P33333@P@P33333@P33333@P@P@P@P@P33333@P@P33333@P@P33333@P33333@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P33333@P33333@P33333@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P33333@P33333@P@P@P@P@P@P33333@P@P@P@P@P33333@P@P@P@P33333@P@P@P33333@P33333@P33333@P33333@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Q      @P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Q      @Q      @P@P@P@P@P@P@P@P@P@Q      @P@P@P@P@P@P@P@Q      @P@Q      @P@P@P@P@P@P@P@Q      @P@P@P@P@P@P@Q      @P@Q      @P@Q      @P@Q      @P@P@P@P@P@P@P@P@P@P@P@P@P@P@Q      @P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Q      @P@P@P@P@P@P@P@P@P@P@P@P@P@P@Q      @P@P@P@P@P@P@P@P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 P22                                     1                                       'BFS3Ҁ