CDF       
      time      pressure     latitude      	longitude         string_dimension   (         EXPOCODE      29AJ20160818   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    WOCE_ID       TAlPro     	DATA_TYPE         WOCE CTD   STATION_NUMBER        31     CAST_NUMBER       1      BOTTOM_DEPTH_METERS          
Creation_Time         2020-03-19T19:50:21.302886Z    ORIGINAL_HEADER      CTD,20200319CCHSIO
# Converted CTDOXY from ML/L to UMOL/KG using the following:
#     https://github.com/TEOS-10/GSW-Python, downloaded 2019-06-26
#     gsw.sigma0:  Calculates potential density anomaly with reference pressure of 0
#     dbar, this being this particular potential density minus 1000 kg/m^3.
#     This function has inputs of Absolute Salinity and Conservative
#     Temperature.  This function uses the computationally-efficient
#     75-term expression for specific volume in terms of SA, CT
#     and p (Roquet et al., 2015).
#     http://www.teos-10.org/pubs/gsw/html/gsw_sigma0.html 
#     Python equation used:
#         oxy_UMOL_per_KG = oxy_ML_per_L * 44.660 / ( (1000 +  gsw.sigma0(SA,CT)) / 1000. ) 
# Data source:  https://doi.pangaea.de/10.1594/PANGAEA.902330
# SHIP: RV Angeles Alvarino
# Cruise: MedSHIP cruise TalPro
# Region: Mediterranean Sea and Catalan Basin
# Ports: Palermo, Italy to Barcelona, Spain
# DATES: 20160818 - 20160829
# Chief Scientist: L.Jullion
# 43 stations
# Original file in AWI format. CCHDO Converted to Exchange format
# EVENT_CODE=unknown
# DATE: YYYYMMDD
# TIME: HHMM
# LATITUDE: degrees_North
# LONGITUDE: degrees_East
# STNNBR:  removed leading 0s from STNNBR
# CASTNO: not supplied by originator - CCHDO assigned all CASTNO=1 or CASTNO=2 for stations 11, 29
# CTDSAL: changed units from Practical to PSS-78.  Data values remain unchanged.
# CTDFLUOR: changed units from UG/L to MG/M3 as they are they are equivalent
# CCHDO added flags=2 for all parameters, as T.Tanhua notes all params are calibrated and CTDOXY calibrated with bottle samples
# Removed two test sample depths from event/station 004, dTalpro_Stn04_test_1db
# Data precision preserved as submitted.
# CTD: Who - T.Tanhua; Status - calibrated,final
#     Includes: CTDSAL, CTDOXY
#     CTDTMP NOTE: Used first occurrence of primary temperature sensor in original data file
#     CTDSAL NOTE: Used first occurrence of primary salinity sensor in original data
#     NOTE: Physical parameters temperature, salinity, oxygen, density, turbidity, chlorophyll, fluorescence are published on PANGAEA, DOI above.
# Fluorescence (CTDFLUOR): Who - T.Tanhua; Status -final
#        Instrument: WET Labs ECO-AFL/FL, FLNTURTD-2526
#        ScaleFactor: 1.00000000e+001
#        Dark Output: 0.0760
# Turbidity (CTDTURBDTY): Who - T.Tanhua; Status - final
#        Instrument: FLNTURTD-2526
#        ScaleFactor: 5.000000
#        Dark output Voltage: 0.070000
#
# Reference: Cruise report: https://epic.awi.de/id/eprint/49725/1/TAlPro_EUROFLEETS_cruise_report_V2.pdf
# CCHDO page: https://cchdo.ucsd.edu/cruise/29AJ20160818
# Metadata from original file
#     Event(s):     TAlPro-2016_031 (31) * LATITUDE: 42.280000 * LONGITUDE: 3.820000 * DATE/TIME: 2016-08-26T23:49:00 * CAMPAIGN: TAlPro-2016 * BASIS: Angeles Alvarino (URI: http://www.eurofleets.eu/np4/285.html) * DEVICE: CTD/Rosette (CTD-RO)
#     Citation: Tanhua, Toste (2019): Physical oceanography during MedSHIP cruise Talpro. PANGAEA, https://doi.org/10.1594/PANGAEA.902330
#     Abstract: The TAlPro cruise (Palermo - Barcelona, RV Angeles AlvariÃ±o, 18/-8/2016 - 29/08/2-16) occupied three hydrographic transects across the Tyrrhenian Sea, the western Mediterranean Sea and the Catalan Basin (Fig. 1) as part of the MedSHIP programme (Mediterranean Ship-based Hydrographic Investigations Program). A total of 43 stations were occupied during which physical (temperature, salinity, pressure, velocity), biogeochemical (oxygen, nutrients, carbonate system, dissolved Barium, oxygen and nitrogen isotopes) and anthropic (CFCs, SF6) parameters were measured in order to monitor the physical and biogeochemical state of the Mediterranean Sea.
#     Related to: Jullion, Loic (2016): TAlPro-2016: A Tyrrhenian Sea & Alger- provencal component of the MedSHIP Programme. hdl:10013/epic.5a866780-1f8a-45cf-8111-47b2b5dc29db
#     Parameter(s):
#         Event label (Event) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Sample code/label (Sample label) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Date/Time of event (Date/Time) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Latitude of event (Latitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Longitude of event (Longitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Pressure, water [dbar] (Press) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Digiquartz
#         Temperature, water [Â°C] (Temp) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: ITS-90
#         Oxygen, dissolved [ml/l] (DO) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 43
#         Turbidity (Nephelometric turbidity unit) [NTU] (Turbidity) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO
#         Fluorescence, chlorophyll [Âµg/l] (Fluores) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO-AFL/FL
#         Salinity (Sal) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Practical
#     License: Creative Commons Attribution 4.0 International (CC-BY-4.0)
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            pressure               	long_name         pressure   positive      down   units         decibar    data_min      @$         data_max      @        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      P  '   pressure_QC                	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d        F`   temperature                	long_name         temperature    units         ?C (ITS-90)    data_min      @*V!.I   data_max      @5Z   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       P  N4   temperature_QC                 	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d        m   salinity               	long_name         salinity   units         PSS-78     data_min      @B   data_max      @CNaf   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      P  uX   salinity_QC                	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d           oxygen                 	long_name         oxygen     units         ?mol/kg    data_min      @eQ~($   data_max      @o   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        P  |   	oxygen_QC                  	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d           CTDFLUOR               	long_name         CTDFLUOR   units         MG/M^3     data_min      6C-   data_max      ?_حV   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      P  à   CTDFLUOR_QC                	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d           	CTDTRBDTY                  	long_name         	CTDTRBDTY      units         NTU    data_min      ?   data_max      ?ٙ   C_format      %f     WHPO_Variable_Name        	CTDTRBDTY      OBS_QC_VARIABLE       CTDTRBDTY_QC     P     CTDTRBDTY_QC               	long_name         CTDTRBDTY_QC_flag      units         
woce_flags     C_format      %1d       
   time                	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      &+u   data_max      &+u   C_format      %10d          latitude               	long_name         latitude   units         	degrees_N      data_min      @E#
=p   data_max      @E#
=p   C_format      %9.4f             	longitude                  	long_name         	longitude      units         	degrees_E      data_min      @\(   data_max      @\(   C_format      %9.4f             	woce_date                   	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3:   data_max      3:   C_format      %8d           	woce_time                   	long_name         	WOCE time      units         hhmm UTC   data_min        	-   data_max        	-   C_format      %4d           station                	long_name         STATION    units         unspecified    C_format      %s        (    cast               	long_name         CAST   units         unspecified    C_format      %s        ( $@$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @5Z@5o@5X@5E?|h@55'0@5+:)z@5"e+@58Y@5Mj@5 ҈p@5>}Vl@52-V@4?|h@4_o @4+j@4M:@4)^	@4ZfB@3vYJ@2P{@2@2Z@1	@1PH@1b ѷ@1#{J#9@1҉@1TɅo@0Z@0N;5@0~($x@0 ѷ@0n@0TɅ@0a7Kƨ@0҈p;@0lC@0|@/a|Q@/$tT@/\u"@/&L/{J@/Xy=@.64@.a@N@.S@.~쿱[W@.ik~(@.TFs@.CA [@.4D@.'/V@.ce@.R@-JE@-/@-W>6z@-n.3@-{@-L_@-Q@-\)@-p@-a@-J0
@-?U=@-8}H@-2a|Q@--@-*fB@-(eO@-      @-;dZ@-84֡@,@,U=@,R<6@,73@,hr @,w1@,^@,Q@,#9@,@,b@,@,E@,H@,	ԕ+@,S&@,|u"@,z>B@,u$/@,ov@,jg	@,b@4@,]b@,Ye+a@,P{@,G)^@,<u"@,4!-w2@,,q@,)k~(@,'y@,&
L/@,K]@,+j@,MjO@,iB@,hr @,v@,C%@,lC@+\N<@+|@+D@+oiDg8@+B@+cA \@+=p
@+e+@+n.@+حU@+e+a@+KƧ@+և+J@+4K@+Y|@+Fs@+ҕᰊ@+c	@+̿[W?@+V@+B@+α2X@+̿[W?@+~($x@+a@@+ɅoiD@+Ǡ	k@+Fs@+m\@+tj@+tj@+xF@+a@N@+`A@+\(@+¶}Vm@+ѷX@+b}V@+|hs@+ߤ@@+6C@+*0@+fA@+af@+&@+@+PH@+)y@+e+@+=b@+D@+ݘ@+G{@+xl"h
@+-
@+L_@+p:@+T@+/@+oiD@+W'@+zH@+@+n.@+Xe@+Xe,@+L_@+4J@+$tT@+@+N;5@+)^@+%@+iDg8@+
M;@+T@+Dg8~@+M@+R<6@+n@+~Q@+|wkP@+{J#9@+|n.@+|64@+|C,zx@+|ߤ@@+z,<@+yD@+yXbM@+y#w@+y+@+xPH@+w+@+s@+p
=q@+o4֡a@+m@+k҈@+i ѷ@+h1&x@+h>BZc@+h>BZc@+k'/@+kC,z@+mw1@+l1&y@+j=p
@+iy@+i^5?}@+i7KƧ@+hr Ĝ@+g+I@+eO
@+e@+eu@+e+a@+e@+dJM@+dtj@+cF]c@+c9@+ceO@+c{J#9@+cn.3@+c{J#9@+ca@N@+c,zxl@+b\(@+ao@+],=@+]IQ@+\>@+\1&@+]!.H@+]p
=@+]p
=@+[6@+YXbM@+XD*@+W+@+W>6z@+Vt@+U*0@+T֡a@+TO
M@+Tj~@+R䎊q@+IDg8~@+E+a@+CS&@+B\(@+Be+@+B@4@+CS&@+E@+GE84@+G/V@+H$xG@+HK]c@+H˒:*@+Hp:@+IoiD@+IQ@+Hu%F@+IQ@+K]cA@+K:)z@+KQ@+K]cA@+Jg	@+JL_@+JJL@+Ik~(@+H9Xb@+H@+H@+H@+H@+HK]c@+HXy=@+H>BZc@+GfA@+F&I@+FFs@+G_o@+G_o@+GRT`e@+G_o@+Gݗ+@+GfA@+H	ԕ+@+H@+Hr Ĝ@+Hp:@+IrGE@+IQ@+Iԕ*@+J~"@+JfB@+KC,z@+KP{@+K~($@+KU=@+Lq@+Mqu"@+N.2@+N1@+Ov_ح@+OrGE9@+PbM@+P
=q@+Q2W@+Rs@+S&@+Sg	l@+S@+TJ@+U?|h@+UϪ͞@+VFs@+V@+VC-@+UXy=@+T3@+TSMj@+TɅoi@+TZ@+UϪ͞@+Vl!-@+Vz@+Vaf@+Vȴ9X@+W4m@+W>6z@+W4m@+W+@+V!.I@+V@+V+J@+UXy=@+U\(@+V_ح@+WXe@+V!.I@+VϪ͟@+V@+VE@+V+jg@+V8YJ@+VE@+VOv_@+U!R@+U?|h@+TɅoi@+Sg@+SZ@+S&@+Rn@+Q[W>6@+Q@+QN;6@+RnO@+R-V@+Qu@+QiB@+R䎊@+RT`d@+RT`d@+Q@+M@+MV@+K~($@+JW'@+JqiC@+JD@+K6z@+O-V@+M5Xy>@+M%@+M@+K]cA@+F,<@+D?@+CA [@+Cwk@+C	@+Bh	ԕ@+As@+@u!@+?$tS@+??@+?[W>@+?vȴ9@+?	@+>Q@+=H˒@+=H˒@+>m\@+@-
@+@҈p@+@ѷX@+@C@+B`A@+IB@+L>B[@+S҉@+S@+RT`d@+Rm\@+RsP@+Stj~@+T,<@+TJ@+U'0@+U?@+Weں@+WkP@+WXe@+U!.@+TD@+TFs@+Rm@+R ě@+R䎊@+QR@+P`A7@+NMj@+K҈@+J͞&@+Hۋq
@+FIQ@+E8YK@+E+a@+CZ@+Bu%F
@+A|Q@+?@+?@+>ߤ?@+>u@+=<64@+<PH@+<(\@+;m]@+;/V@+;s@+;u%@+;u%@+:vȴ@+:,<@+9+@+7KƧ@+7sPH@+7kP@+7kP@+73@+7@+7+@+7rG@+8F]d@+8}H@+7+j@+7rG@+8bM@+8F]d@+873@+8l"h	@+7@+4Ʌoi@+.1@+.p:~@+.p:~@+.O;@+.c	@+-:@+,@++C]@++C,z@+*g	@+)'RTa@+(ۋq
@+'-@+'ݗ+@+'@+ C@+u"@+wkP@+C,zx@+Q@+W>6z@+u%@+G{@+,<@+,<@+ݘ@+1@+n@+$tT@+@+rGE9@+
V@+1&y@+P{@+
~"@+
W'@+	'RTa@+9Xb@+u%F@+p:@+Xy=@+@+@+˒:*@+$xG@+y@+_o@+E84@+x@+JM@+a@N@+@+u%F
@+h	ԕ@+ ѷ@+&IR@+@+R<6@+ n@+ 'RT`@+ 
qu@+ 
qu@+ 6@+ 6@+ 'RT`@+ A7K@+ NU@+ [6@+ hۋq@+ hۋq@+ [6@+ A7K@+ A7K@+      @+ 
qu@+ 6@+ 'RT`@+ 'RT`@+ 'RT`@+ 6@+ 
qu@+ 
qu@+      @*[W>@*	@*U=@*b}V@*|hs@*	@*$tS@*$tS@*o@*@*b@*-V@*+j@*}H@*ڹZ@*p
=@*[@*u"@*u"@*hr@*u"@*u"@*>@*Z@*s@*,<@*)_@*>B@*xl"h
@*>BZ@*>BZ@*|@*e+a@*XbM@*=b@*=b@*4֡b@*l"h	@*73@*+@*4m@*!.I@*}Vl@*8YJ@*E@*ᰉ@*%F
L@*j~@*SMj@*J@*g@*@*@**0U2@**0U2@*ߤ@**0U2@*a@O@*ߤ@*Mj@*g	l@*@N@*sP@*S&@*{m@*{m@*nO@*p:@*ᰊ@*T`d@*R@*[W>6@*@*Vϫ@*s@*n@*W'@*lD@*Ov`@*	 @*lD@*^5?}@*k~(@*\)@*ۋq
@*r Ĝ@*1&x@*@*@*fA@*ݗ+@*	k@*8}H@*Fs@*A@*'@*'@*&I@*捸@*fffff@*$/@*@*oiDg@*8YK@*8YK@*n/@*@*8YK@*@*zxl"h@*+a@*TɆ@*\N@*a@N@*ⶮ}Vm@*@N@*($x@*64@*c	@*c	@*u%@*u%@*s@*c	@*)_@*ڹY@*G{@*"`B@*s@*~@*s@*)_@*,<@*,<@*ڬ>B@*G{@*kP|@*6C@*1'@*@*kP|@*Q_@*Y}@*e+a@*#w@*=b@*PH@*ؠ-
@*ؠ-
@*ؓtj@*rG@*׀4m@*״3@*+@*@*'0@*D@*m8@*ө*0U2@*&@*W@*T`d@*:)y@*s@*-@*т@*&x@*&x@*о
(@*@*@*;dZ@*rGE9@*@*@*rGE9@*;dZ@*iDg8@*t@*ΗO;@*̥zxl"@*cA \@*<쿱@*/{J#@*s@*a@@*P{@*)^	@*~"@*x@*@*Țu%F@*@@*
L/@*āo h@*A [@*%2@*%2@*@*üZ@*
=p@*ï@*@*@*ÈeO@*9@*\(@*7Kƨ@*-w1@*	k@*-w1@*@N@*IQ@*n@*vȴ9@*˒:)@*@*䎊r@*˒:)@*Ft@*%@*vȴ9X@*m\@*H˒:@*.H@*Ft@*,=@*v@*v@*p
=@*<64@*<64@*u"@*?@*lC@*~$@*qu!@*ݘ@*kP|@*)_@*J#9@*s@*/V@*,<@*D*@*>6z@*&@*3@*Q@*bM@*@*+j@*4m@*1@*D@*)^@*'RT@*|@*
=q@*@*v_ح@*\(@*'/W@*zG@*@*zxl"@*I^5?@*U=@*fB@*g	@*~"@*L_@*qiC@*=p
@*d7@*JL@**0U2a@*9Xb@*\)@**0U2a@*@*9Xb@*@*\)@* ѷ@*9Xb@*#@*K]d@*fA@*/V@*_o@*$/@*\N@*wkQ@*@*Gz@*6@*Q@*vȴ9X@*Ov_خ@*>@*W>6z@*xl"h
@*"`@*_o@*@*#w@*KƧ@*l!-@*Ϫ͞@*'0@*MjO@*N;6@*@*@*O;@*>B[@*fB@*qiC@*Q@*1&x@*8YK@*\(@*IQ@*[6@*~"@*~ߤ?@*~쿱[W@*~@*~iB@*~Q@*~Ov_خ@*~
(@*|#x@*|64@*{m]@*{~$@*{W>6z@*z~@*z6C@*xe+@*w3@*u\(@*sߤ@*rnO@*r䎊@*q4J@*poiDg8@*oo @*or@*oo @*o@*o{J#:@*np:~@*nVu@*nH@*n.2@*nzG@*m
qv@*n!R<@*m(@*m(@*n_o @*n.2@*nVu@*n;5X@*n;5X@*nO;@*nT@*n}Vl@*nc	@*nߤ?@*nt@*nH@*n;5X@*nzG@*n!R<@*kC]@*jd7@*i@*hu%F@*hۋq
@*h1&x@*gzH@*gRT`e@*glC@*g8}H@*f&I@*eO
@*eo i@*dM:@*c$@*cF]c@*b@*an.@*`҈p@*`A7K@*`'RT`@*`     @*_?@*_|hs@*_@*^m\@*^iB@*^Ov_خ@*^($x@*]b@*]p
=@*]<64@*][@*\#x@*\64@*[Q@*ZkP|@*Zݘ@*ZQ_@*Z)y@*ZQ_@*ZQ_@*Zxl"h
@*Z^5?|@*Z@*Y@*Y#w@*Xl"h	@*W@*W@*W@*W+@*W&@*W$tS@*WXe@*WXe@*V!.I@*XQ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          @CQ@C YJ@C ˒:*@C @C eO@C 6@B@Cu!S@C-V@C     @C@CQ@C64@CC]@C"`B@C#x@C@CA@C6@Cs@CoiDg8@C@Cqu"@C?@C<쿱@C?@CcA \@ClC@Cm]@CS@CPH@Cm@C)_@CnO@CI^5@C͞&@C)_@Cu%F
@CI^5@CnO@C0U2a|@CS&@C>B@Cm@CfB@C ѷ@C6z@C=K^@CP{@Ca@N@Cjf@C~$@C{J#9@Cq@C@Ctj@C(\@Cj~#@CZ@C>B[@C/@Cm\@C_o @C;5X@C҈p;@C.H@CKƧ@Cb}V@C|hs@C{J#:@C	@C/V@CD*@CIQ@CPH@Cae@Cԕ*@C)y@CqiC@Cݘ@CS&@C33333@C!-w2@CwkP@CTɆ@Cu@Cp
=@C8Y@C$/@C5?|@Cqi@C]cf@C$tS@C4m@C˒:)@C eO@C {@C 9Xb@C ۋq
@C!=b@C!o@C!s@C"Zc@C"wkQ@C"͞&@C#"`B@C#a@O@C#\N@C$1&@C%S@C&@C&%@C'!-w1@C'RT`e@C'4m@C'[W>@C($xG@C(:~ @C(eO@C(tj@C(@C(PH@C)_o@C*p:@C+@C,[W?@C,hr@C-u@C-<64@C-ce@C-M:@C-Ϫ͞@C.u@C.iB@C.t@C/v@C/eں@C/[W>@C/vȴ9@C/˒:)@C/;dZ@C/rG@C0bM@C0}H@C0 ě@C0$xG@C0H@C0Xy=@C0oiDg8@C0IQ@C0F@C0D@C0e+@C0ěT@C0U@C0'RT@C0-
@C09Xb@C0ۋq
@C0e+@C1#w@C1TɅo@C1~($@C1^5?}@C1e@C2M@C2u%F
@C20
@C2fB@C3jf@C4J@C4Z1@C4cA \@C5F
L0@C51@C6Ov_@C6H@C6qi@C6쿱[W@C74m@C7/V@C7#@C8F]d@C8     @C7+j@C8     @C8	ԕ+@C8˒:*@C8@C9&x@C97KƧ@C9Dg8~@C9A [@C9N;5@C97Kƨ@C9~($@C9@C:@C:1'@C:#9@C:nO@C:g	@C:@C:}Vm@C:@C:@C:@C:)_@C:͞&@C:C,@C;nP@C;6z@C;C%@C;MjO@C<9XbN@C<zG@C<o h@C<Z@C<JM@C=n/@C> ѷY@C=ڹ@C>_o @C>zG@C>Ov_@C>zG@C>($x@C>z@C>Q@C?H˒:@C?O;d@C@F]d@C@l"h	@C@r Ĝ@C@YJ@C@F@CA*0U2a@CADg8~@CAN;5@CAXbM@CAo hی@CAoiD@CA|@CAN;6@CBM@CBxl"h
@CBL_@CBS&@CBW@CB74@CCnP@CC)^	@CC33333@CC=K^@CCC%@CCC%@CCMjO@CC{J#9@CC@CCa@O@CC5Xy@CCQ@CC5Xy@CC6@CC|@CCA [@CD1&y@CDQ@CD64@CDS@CD@CEK]@CE(@CES&@CE}H@CE+j@CEn/@CE@CF ѷY@CF+jg@CFp:~@CFz@CFIQ@CFIQ@CFqi@CFaf@CF&I@CG hۋ@CG>6z@CGKƧ@CGXe,@CGb}V@CGsPH@CGy@CG|hs@CG4m@CG{J#:@CGr@CG@CGVϫ@CHF]d@CH@CHbM@CH$xG@CH>BZc@CHXy=@CHeO@CHU@CH`A7@CHPH@CI+@CI:S@CI[W>6@CIae@CIhr @CIo hی@CIb}@CI~($@CIN;6@CJn@CJ6C@CJW'@CJqiC@CJ\(@CJvȴ@CJ@CJڹY@CJfB@CKnP@CK&@CK)^	@CKC%@CKtj~@CKq@CKU=@CKq@CKZ@CKa@O@CK~($@CK6@CK5Xy@CK|@CKg@CKC]@CKA [@CK$@CK@CLxF@CLxF@CLtj@CL(\@CL(\@CL(\@CL,<@CL,<@CL64@CLPH@CLcA \@CLcA \@CLj~#@CLwkP@CL~($x@CLo h@CLo h@CLC@CL#@CL?@CLo h@CL~($x@CL?@CL?@CL?@CLzG@CLo h@CL?@CLC@CLTɆ@CL[W?@CL?@CLɅoi@CL@CLu"@CL@CL/@CL?@CLO
M@CLS@CLS@CLzxl"@CL@CL#x@CMu@CLE@CMV@CMu@CLD@CL?@CLO
M@CLzxl"@CL3@CLS@CL_@CLN;@CLo h@CLzG@CLzG@CLzG@CL~($x@CLwkP@CLj~#@CL`d@CLm8@CLqj@CLj~@CL?@CL7@CL7@CLD@CMݗ@CM@CNOv_خ@CNR<6@CN?@CNL/{J@CNH@CNOv_خ@CNVu@CN\N<@CNs@CN}Vl@CN@CN,<@CN,<@CNaf@CN,<@CNFs@CN$t@CNqi@CN+J@CNIQ@CNs@CN_ح@CN?@CN5?|@CNOv_@CN4K@CN_o @CNt@CME@CMᰉ@CM
qv@CM@CMcA @CM@CM\(@CM@CMU=@CMXy=@CM%@CM=K@CM=K@CM+j@CMO
@CMO
@CM!R@CM}H@CMM:@CM=K@CMH˒@CM,=@CM,=@CMS@CM,=@CM,=@CM,=@CM,=@CM,=@CMS@CM,=@CMS@CM,=@CM,=@CM?@CM-V@CMm\@CMce@CMfA@CMce@CM`A7L@CML_@CMIQ@CM<64@CM5Xy>@CM+a@CM*0@CMV@CMo i@CLE@CL!-w@CLTɆ@CLC@CL~($x@CLzG@CLtSM@CLj~#@CLcA \@CL]ce@CL]ce@CLZ1@CLSMj@CL!-w2@CKlC@CKQ@CK@CK6@CKMj@CKQ@CKxF]@CKjf@CKjf@CKa@N@CKZ@CKa@N@CK]cA@CKW>6z@CKZ@CKW>6z@CKdZ@CKdZ@CK]cA@CKZ@CKW>6z@CKP{@CK33333@CK"`B@CKs@CK'/@CKnP@CKs@CK'/@CKu%@CKS&@CJ~@CJ74@CJD@CJD@CJm@CJD@CJD@CJ74@CJD@CJD@CJ74@CJ74@CJ~@CJ~@CKI^@CKu%@CKu%@CKu%@CKS&@CKu%@CKu%@CKu%@CKu%@CKu%@CKu%@CKu%@CKS&@CKS&@CKI^@CKu%@CKS&@CKS&@CKI^@CKI^@CJm\@CJ74@CJ74@CJ74@CJD@CJD@CJ74@CJm@CJm@CJc	@CJc	@CJc	@CJC,@CJC,@CJfB@CJG{@CJG{@CJ ѷ@CJ ѷ@CJڹY@CJsP@CJsP@CJ`A@CJ`A@CJ`A@CJ`A@CJ`A@CJW@CJW@CJW@CJ)_@CJn@CJn@CJY@CJ<64@CJ}Vm@CJg	@CJ ě@CJ ě@CJ ě@CJg	@CJ}Vm@CJg	@CJg	@CJg	@CJ ě@CJg	@CJg	@CJ ě@CJ ě@CJ>B@CJ@CJ>B@CJL/{@CJS&@CJvȴ@CJvȴ@CJwkQ@CJwkQ@CJwkQ@CJ0
@CJS&@CJp:@CJp:@CJu%F
@CJM@CJ@4n@CJ6C@CJ3@CJ3@CJ0U2a|@CJ-V@CJ)y@CJ䎊@CJ1'@CJOv`@CJs@CJ@CJ@CJI^5@CJ	 @CJn@CJu%F@CI.H@CIlD@CIY}@CIY}@CIs@CIs@CI@CI@CIR@CIe@CIᰉ'@CIᰉ'@CIᰉ'@CIiB@CIiB@CIiB@CI"`@CI@CIԕ*@CIy@CID@CIX@CI'R@CI@CIu!S@CI[W>6@CIJE@CIDg8~@CIGz@CIDg8~@CIDg8~@CI:S@CI=b@CI:S@CI:S@CI=b@CI:S@CI7KƧ@CI:S@CI0
)@CI4J@CI0
)@CI-w1@CI-w1@CI&x@CI&x@CI@CI@CI#w@CI [7@CI_p@CI@N@CI@CI@CI$/@CI ѷ@CI ѷ@CH$tT@CH{@CH4֡b@CH4֡b@CHC@CH҈p@CHp:@CHěT@CH4m@CH{@CH@CH-
@CHIQ@CH@CHtj@CHtj@CHYJ@CHn@CH˒:*@CHu!@CHl"h	@CHhۋq@CHl"h	@CHhۋq@CHhۋq@CHhۋq@CHeO@CHbM@CHXy=@CHQ@CHK]c@CH1&x@CH-
q@CH*0@CH'RT`@CH$xG@CH ě@CH6@CH@CH@CGrGE9@CG䎊r@CGVϫ@CG;dZ@CG@CG[W>@CG&@CG͞@CG?@CG	k@CG?@CG	k@CG-V@CG-V@CGkP@CG$tS@CG@CG{J#:@CG|hs@CGsPH@CGsPH@CGsPH@CGlC@CGb}V@CGb}V@CGXe,@CGU=@CGU=@CGU=@CGU=@CGH˒:@CG;dZ@CG;dZ@CG>6z@CGE84@CGAs@CG>6z@CG+I@CG'/W@CG'/W@CG!-w1@CG,@CGv@CGXe@CG@CGFt@CG hۋ@CF!.I@CFMj@CFMj@CFMj@CF"@CFFs@CFFs@CF쿱[W@CFȴ9X@CFߤ?@CFߤ?@CF@CFȴ9X@CF@CF@CFߤ?@CF'@CF}Vl@CF+J@CFVu@CFR<6@CFL/{J@CFL/{J@CF?@CF8YJ@CF8YJ@CF1.@CFOv_@CF
(@CF
(@CFt@CEC\@CEoiDg@CE(@CES@CES@CES@CE?@CE?@CEb@CE@CE\(@CE\(@CE\(@CEH˒@CEn/@CEn/@CEn/@CEn/@CEsh@CEU=@CE@CEv@CE%@CE+j@CEݗ@CEfA@CEO;dZ@CEF
L0@CE<64@CE+a@CE*0@CE[@CEV@CDE@CDZ@CDZ@CD*0@CDɅoi@CD?@CD#x@CD3@CD*1@CD#@CD~($x@CDcA \@CDPH@CDC,zx@CD,<@CDQ@CDJ@CCC]@CClC@CCa@@CCZ@CCߤ@CCqu!@CCZ@CCP{@CC=K^@CC=K^@CC6z@CC/V@CC)^	@CC,zxl@CC&@CC"`B@CC҉@CCS&@CB~@CBD@CBm@CBC,@CB ѷ@CB͞&@CBY@CBwkQ@CB@4@CBnO@CBh	ԕ@CBZc@CBGE85@CB@4n@CB=p
@CB=p
@CB=p
@CB3@CB&IR@CB&IR@CB䎊@CB䎊@CBe+@CBOv`@CBOv`@CBs@CBs@CBs@CBs@CBs@CB@CBs@CBs@CBs@CB@CBI^5@CBs@CB@CB	 @CBn@CA.H@CA.H@CAᰉ'@CA_o@CA@CA'R@CA'R@CAn.@CA'RTa@CA@CA@CA@CA~($@CA|Q@CArGE8@CAe+a@CA^@CATɅo@CAJE@CA=b@CA4J@CA*0U2a@CA#w@CA@CA_p@CA+@CArGE@CA	k~@CA$/@CA ѷ@C@PH@C@	k@C@4֡b@C@4֡b@C@@C@e+@C@ۋq
@C@F@C@TɅ@C@
(@C@)@C@4m@C@4m@C@4m@C@)@C@9Xb@C@{@C@d8@C@
=q@C@@C@-
@C@'RT@C@'RT@C@'RT@C@YJ@C@|@C@y=c@C@y=c@C@u!@C@|                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          @ku%F
@k{@k$tS@lC%@l `d@lu@ky@kŮ1@ka@O@kБN;@kFs@ke+a@lWfA@lG+@km8@l]@l^}Vm@m-
@nG͞@n@nm@o/v@o"H@o*nO@o##w@o/)^	@o_E@o|@oU^5?}@oXq@oxE@oѷX@ou@on@o74@o33333@o@ok~(@oc5Xy>@o7;dZ@o,<@oQ@o1.@o@nߓ@nb@nΦL/{@nh	ԕ@n^5?|@nD@n䎊@ny:)z@nd{@nX$/@n1#w@nO;@mp
=@m     @mj~@mm\@mIQ@ma(@m=k~(@lC\@lZc@lwlC@l8Y@l	k@lW'@lsXy=@l\_o @l0C,@l*0U2a@ko hی@klC@k1.@kL_@kuFt@kr6C@kkA [@kp)^@kBe+@k?@k䎊@ke+@k.2@j#@k)@j$@j䎊q@j/w@jZ@j۳|@j*0U2a@joiD@j/@jeO@j#@jVϪ@jxD@jwjOv@jo	k~@jjF@jx'@j~?@j[4m@j*,<@j@iOv_خ@i^5?|@iMjO@irGE8@i˒:)@i$/@iMjO@i@j|@j
tj@i!R@i|hs@iʣ
=q@i҈p;@iZ@i:
qu@h'/W@i$t@i
$/@i	TɅo@iC@iO;@iG|@i^t@iNQ@i*_@h/w@hu@hB@hѤ?@hwkP@h|1@hZ)y@h>`d@h?@hUC\@hj*0@hh	 @h_[W>@hs"`B@hqvȴ9@h[@haV@hnD@hqr@h~$@hTɅo@hSMj@h($x@hèXy=@hPH@hm\@h+@h[W>@h@h.2@hт@hQ@hD*@hC,zx@hܕ*1@hƧ@h"`@hV@hx@h:~ @hI^5@hzG@h4m@h@h+a@h	ԕ+@hvx@hm+a@hky@hv䎊q@hn.@hMj@hqS&@hj^5?|@h`af@hYq@hQS&@hOg@h@S&@hBJ@hBn.@hG!R@h?6z@h4@h1O;dZ@h9v@h;S&@h/@h5rGE8@h@\(@h?+a@h?+a@h;:@h.~"@h'ڹZ@h?@h>B[@h#XbM@h!䎊r@hTɆ@h
JL@h9@h䎊q@g@@gS@g?@g䎊@g@gMj@g+jg@gU=@g hۋ@g䷀4m@g	 @gM@gߤ@@g\N@g@gFs@gJE@gI^@gߤ@g#@g_@gzG@gPH@geO@gux@gg@gbF]d@gjQ@goiB@gdTɅ@gf#9@gk'R@g]˒:)@gN%@gJVϪ@gHm@gKr@gH@gN~($x@gR@gUlC@gNxl"h
@gHx@gGQ@gK1@g_v@gdL/{@gZC@gZJM@g`wkP@gX!R<@g?!-w1@g$j~@g'@g*GE85@g=r@g&6@g4֡b@gڹZ@g;dZ@g3@g@g>6z@gb@gb@g@g{J#:@g
I^5?@g@frGE8@fE@fhr@fBZc @fs@f$/@fC,@f@4n@f@4n@f٣n.@f-@f+j@fg	l@fXe,@f!-w2@fB@f,<@f,<@fU=@fy@f˒:*@fXy=@f4֡a@fl!-@fu%@f|#@frp:@fy6@fx\N<@fu$@fqjf@fg[W>@fU@fKlC@f@W@fD!-w@f?e+a@f8r Ĝ@f*\(@fe@f"8YJ@f-TɅo@f$m\@f(\@f@f~($@f ѷX@f|@f&@f ߤ?@f	4J@fu%@f	33333@f$xG@f /@eR<6@e]ce@e$tS@ey@e#@eR<6@e	k@e$@e_o @eJM@e#9@e"`@eݗ+@e@e@efB@efB@eh	ԕ@e.H@e.H@eD@e$@eؐ$t@eeO@eܺ)@e߁@e`A7@eؐ-
@esPH@es@es@erGE8@e
(@eA [@eF@e,<@eSMj@e4֡b@e_p@eG{@e}H@e5Xy>@e`A7L@em8@ePH@eї$tS@eA@eܲ@e#w@e$/@ekP|@e&@e1@en.@e@eK]c@e.2@e)^@e	@eռn/@ej~@e@e!-w@e-V@e؂@4@esg@eɅoi@e@e@eVϪ@eȴ9X@edZ@eK]d@eo h@e䎊r@eqiC@e@e{rGE8@ee9@e\Z@e_͞@eh     @el*0@eq@eh     @em!R@et˒:*@em!R@efwkQ@ebqiC@eh     @ej?@ee7KƧ@ea@eia@N@efu%F@ee6z@eqsh@esPH@ex@et{m@eglD@el%1@eD@e2X@e\N<@enC,@e~1&x@eH˒@eZc@eݗ+@e@exaf@euQ@eZ1@e@eZ1@e}Vl@eJE@e:)z@e\)@eJE@e\)@eYJ@e [7@ettSM@en1@ebd7@eX6z@ea hۋ@ecy@eZߤ@@eX6z@e\Ϫ͟@ea hۋ@ecy@elQ@ee+I@ecy@e[rGE8@eQ~($@e_u@equ"@e?@e?@e@e҈@e!.I@etj@e_@e|Q@eѷX@e
L/@e(@e|@e3@e*0@e%F
L@eգn.@eL/{J@e!-w1@ehr @eZ@e@ehr @e=b@eS&@eZ@ehr @f O
M@f$@fq@f$Ʌoi@f$Ʌoi@f5sPH@f@\(@f6֡a@f&,<@f5rGE8@fD#x@f5rGE8@f*Vu@f'Mj@f26z@f88YJ@f/%2@f"     @fV@fqiC@f&*0@f5p
=@f(m@f#b}V@f4
qu@f9=K@f4
qu@f4I^5@f=o @fG}H@f<a|Q@f-v@f(@f6Z@f*SMj@f4xF@fG|hs@f:!.I@f$m\@fp:~@f!\N@f4xF@f+E@fp:~@f@f}Vm@f}Vm@f'0@fS&@f
a|Q@fXy=@f 0
@f|hs@f|hs@f&@fC@eDg8~@f
`d@f!.I@f!.I@f@fC]@f@f
'/W@fRT`e@f|Q@fѷX@fn.3@f5?|@e|@e@e`A7L@e{m@e3@e_@e_o@f	ԕ+@f\(@e;dZ@e&IR@elD@e禵(@eBZc @e҈p@e&I@e|@e7Kƨ@e&I@eO;@e@e4m9@e9Xb@e&@e`A@e%F
L@eO;dZ@eVϫ@e܈p:@e"@e	 @eՖR<6@e$tS@eΤT@eΤT@e_o @en@e/@eOv`@eC,@eǲ-V@e2a|@eJM@e-@eÆ&@eÆ&@eM@eJM@eJM@e-@e1@e1@eM@e#9@en.@e#9@e[@e_o@e1@e?@e[W>6@eۋq
@eL_@eΠ-
@eYJ@efB@e>BZc@ecA @e!.@eK]c@eL/{J@e ě@ecA @e+j@e)^@et@enP@e/w@e˒:)@eÄM:@enP@eK]c@eu!@e<64@e+j@enP@eK]c@e<64@eW@eÄM:@eu@eحV@eټn/@eF]d@eÃ{J#:@eXe,@e	k@eÃ{J#:@eحV@e䎊@eÃ{J#:@eÃ{J#:@e@e'RTa@eU=@e;5X@e:~ @eE@eÁ@e
=p@erGE@eH@e`A7@erGE@eǬq@e
=p@e
=p@eÁ@e-
@e`A7@ee+a@eՏo@ee+a@e`A7@eH@en.@e`A7@eǬq@eH@e)@eÁ@erGE@e
=p@e:S@eH@erGE@edZ@e:S@e@@eH@eW>6z@e{@eߤ@@e ѷY@e'/@e%2@e
(@e{@e+jg@e     @em@equ!@eF]c@eU2a|@eǫU=@e*0@eF@ec	@ed8@eߤ@e
(@ed8@eF]c@ed8@eٸ@ed8@equ!@ed8@e=K@eu@e73@e
qu@ebM@eE@eu@e~"@e
qu@e@e@e@eoiDg@e҉@f@fڹZ@e5Xy>@fsh@f@eL_@eS&@eZ@ekP@eS&@e}H@eG{@e6@e5Xy>@fڹZ@f 0
@e@e'0@f 0
@f|@fL/{@f
Q@e|hs@e`d@enO@f#@f#@f#@f`A7L@f;dZ@f	ԕ+@f{m@f3@f	@f7@f7@f_o@e'0@em8@f&IR@f{m@f`A@fL/{@f*0@f*0@f
Q_@f&IR@f&IR@f{m@f+j@f( ѷ@f(/@f p:@f%F
L@fzG@f
Xe@flC@f|@fiB@fiB@f$g	@f2*1@f'y@f/+@f8#9@fA@f@xl"h
@f:JM@f*@4n@f8#9@f?[@fA@f?[@f:JM@f8#9@f<M:@f6[W?@f8#9@f?@fGiDg8@fD3@fC>6z@f?@f3@fH@fNZc@fJ0U2a|@f9oiD@f6[W?@f3-@fKݗ+@fSrG@fYw1@fRݘ@fJ0U2a|@fC>6z@fD3@fH@fNZ1@fQ!-w1@f\=p
@f`h	ԕ@fgXe,@fru%F
@f_@f\<쿱@f`g8}@fhj~@fozH@fj!-w2@frtSM@frtSM@f~!-w@f/V@fe@fyeں@fv쿱[@f:@fqj@fqj@fGE85@f+I@fy@f
M;@fԕ*@fԕ*@fS@f@f}Vl@f!.I@fRT`e@f!.I@f@fȋC@fxF@fDg8~@f64@f64@f2W@fȋC@fa@O@f_ح@fa@O@f!.I@fo hی@fӦ(@f|Q@fC,zx@f|@fD@fD@fz@fR<6@f"@fA@fD@f줨T@fz@fm]@fA@fR<6@f$tS@fD@f@gx@fk~(@f줨T@fD@f"@fD@f@fR<6@fݗ+k@f]ce@f"@f"@g Ov`@g	_o@g/@fR@fD@g Ov`@g Ov`@gj~#@goiD@g
-@gM:@gj~#@g@g"h	ԕ@g3@g@giB@g'R@g&Fs@g"h	ԕ@g)@g2s@g&Fs@g%@g+!-w1@g3u!S@g+!-w1@g7'RTa@g9@g0}Vl@g0}Vl@g-lC@g)@gD䎊@gHJL@g!hr @g0}Vl@g7'RTa@gE{J#:@g=.H@g6<쿱@gE@gM@g?$@g9@g?$@gE@gK)^@gE@gB@gLtSM@gIB@gD!-w2@gHI^5?@gK)^@gIB@gK)^@gIB@gP쿱[@g[^5?}@gP쿱[@gP쿱[@gZVϪ@gWo@gRu%F                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ?IQ?xF]? ě?4m9?O;dZ?,<?,<쿱?2W?m8Y?SMj?As?K]c?˒:)z?
(?-
?4m9?[W>?H?c	?d7?+?	 ѷ?|Q?͞%??5Xy>?ɅoiD?L_?64K?Z?8}H?MjO?S?Ǡ	k?Ȱ{?|??حU?~$t?s?ξߤ??.H?!-w1?%F
L0?64K?Z?ңS&?F]cf?Ժ)_?Փ҉?'/?ԕ*1?RT`d?ֳg	l?n?RT`d?$xF?Zc	?҈p?ae?ߓݗ+k?T`d?+jg?Ƨ-?_حV?b}?o?oiDg?J#9???hۋq
?H˒:*?$?qiB??4֡a?ې?Q?b}V?ֹY}?^?5Xy=?RT`d?ӎMj?яo ?Q?vȴ9X?!-w2?φ&I?ЭU=?M:?PH?TɅo?ɩlD?Q?73?˩*0U2a?GE84?ĥzxl"h?M:?6?`d8?fA?vȴ9?5Xy>?B?Ƈ+I?Ł$/?fA?ơae?JL?&?ÎMj?K]d?|?Ÿ)?ɩlD?K]c?qiB?,<?!.H?а{?o?%1?Gz?^?ȧ,?8YK?C\?e+a?˒:)z?;dZ?\(\?u%F
?&?/V?+I?Xe+?Q?R<6??64K?{?ae?"`B?!.I?      ?hr Ĝ?4m8?ae?$tS?n?ݗ+j?2W?e?*0U2a?'RT?TɅoi??o??u%F
L?@4m?@N? ѷX?|hr?[W>6z?o?%2??Fs?D?O
M?o?`d8?C\N??u!?u%F?q?l!-w?ɅoiD?E?e+?6C-?:)y?-
?=K^?q?ȴ9Xb?tj~?W>6z?	 ?,<?Ϫ͞?n?*0
?N;6?cA \?tj~?L_?>BZc?sPH?bM?oiDg8?@?u%F?tj?$tSM??Zݘ?+I?1&y?Ϫ͞?Ϫ͞?sg?MjOv?j~#?,<?L_?ᰉ'?Z?IQ?)^	?xPH??Z?N;5X?ᰉ'?Ϫ͞?_o Z6C-?xtj~?~Ov_ح?҈?$/?u"?tj~?|??e+a?:)y?qu!S?fA?|??!-w1?htj~rnO;?3*0U2a?kP{?zG{?<64J6C-?<64?Ov_خ?Q_?$?bsPH?[Q_?}Z6C-?!-w1?2a|Q?$/eL_?s@NU?3*0U2a~Ov_حs@NU?s@NU?s*0U2a?}Z?,<?L_?|C,zxl?$tS?sg?ᰉ'?1&?+jg?|??ݗ?e+a?fA?n/?{qu!S?|C,zxl?{Q_?usgf?$tSo䎊q?Z6C-uL_ye+atZ?n/?vȴ9?},<?PbM?PH?W>6z?u!wXe+Կm}H˒?䎊q?䎊q?a@N?	 ҿrn/?usgdzG{?UL_J6C-xtj~?PH?1&?@?n?IQ?u%F?bM?Q_?ߤ??sg?Zݘ?~Ov_حtZq4Js*0U2a?xPH?y_o j6C-?{Q_?&?ᰉ'?*0?fǿpbM?vOv_خ??-
qv?Ϫ͞?E?IQ?bM?c	?Sٿfǿc*0U2a?~Ov_ح?ݗ+j?<64?tn?|C,zxl?}Z`bM?-
qv?Z?	 ?Ϫ͞?6C-?PbM?N;5?C,zxl???!-w1?s@NUC*0U2a?ݗ+j?N;5?=K^?Fs?+I?E?bn/j6C-?!-w1?gkQ_?O
M?~Ov_ح?~Q?Ϫ͞?hr Ĝ?0
(?O;dZ?iB?sPH??n?bM?	 ҿl1&yrnO;?s*0U2a]}H˒j6C-?nOv_ح?{Q_?=K]?sPH?J6C-?_Ft?Ϫ͞?`A7L?}Z?S&?<64bsPHrn/?S&?Fs?l?n??+I?vǿ*6C-?zvȴ9?!-w1?z6C-?}}H˒??sg?N;5XvOv_خ{Q_uL_o!-w1?n/?,<쿱?S*0U2a?u%?*0?R<64?tzG{?	 ?~Q?Z?Ϫ͞?|??dzG{Z6C-?$tS?xtj~rn/g?䎊q?-
qv?҈?UL_l1&y?*0?,<_!-w1ſ@bM?Xtj~S*0U2a??䎊q?$tSM?sg?p:?}ZV?u"?Fs?Z?|1&yRn/?쿱[W??*0
?},<?䎊q?0
(?"`A?!-w1?{qu!S?]}H˒q4J?~Q?*0?=K^?,<쿱?~Q_!-w1?ye+a?+?sg?O
M??S?kP{?$tS?ᰉ'?A*6C-?	 ?	 ?L_?₿UL_?ݗ+j?L_?F?w?	 ?Xe??4J?{Q_?*0U2?-V?hr Ĝ?xPH?|1&y?R<64?L_?߿rnO;q4J?-
qv?,<쿱?$tS[Q_?rnO;?x*0
?!-w1?u"?4J?bM?_Ft?ᰉ'?tj~ie+a?ku%Fku%F?䎊q?!-w1?u"uL_xPH?rnO;VǿrsPH?*0
?ᰉ'?{Q_?:6C-?{Q_?v+I??_Ft?L_?nO;?{qu!S?|1&y?hr Ĝ?`d8?ᰉ'?*0?N;5?N;5X?O
M?wXe+?}Z?{u%F?}Z?{Q_?s@NU*6C-?dzG{nOv_حfOv_خ?!-w1?*0U2a?ݗ+j?@NU?3*0U2a?S?fOv_خ?PbM?s*0U2a?{qu!S?!-w1?*0
?ye+a?vȴ9?IQ?}}H˒?},<?rsPHZ6C-?S&?l?䎊q?w[Q_?&?҈?@NU?*0U2a?tZ?H?0
(:6C-?Ov_خ?C,zxl?y_o ?{Q_?䎊q?Ov_خ?)^	?@NU?sPH?y_o PbM?b}V?J6C-?vȴ9??2a|Q?+IXtj~S*0U2a?}Z?Q_?Ov_ح?-
qv?l1&yXtj~?nO;?4J?}}H˒?A?MjOv?Z6C-?H?nO;?D*0?C,zxl?~Ov_ح?{qu!S?qu!S?PH?C,zxl???f?hr Ĝ?	 ?rsPH?vOv_خ?v+Iqu"y_o ?u%F
?~Ov_حkQ_?6C-?ie+a?usg?{Q_?ye+a?}}H˒?fOv_خ        ?)^	?n?tjxtj~|C,zxlv+Iku%F??PbMye+a?V?htj~a4J?},<?2a|Q?IQ?kQ_?rn/?qu"?}}H˒?Q?x*0
?usg?!-w1?O
M?1&y?3*0U2a?m}H˒?xtj~?~Q?tzG{?C*0U2az6C-?s*0U2a?*0U2?pbMs*0U2adzG{?xtj~?҈?S&?v+InOv_ح?rn/?{Q_Rn/?o!-w1?`A7L??y_o ?ye+a?	 ?{qu!S?c*0U2a?f?䎊r?s@NUtzG{j6C-?!-w1?,<쿱?$/?n/?~Q?<64??w?
=p
?>BZc?Ϫ͞?䎊q?+jg?A?"`A?:)y?|C,zxl?n?)^	dzG{?vOv_خ?},<?PH?O;dZ?ɅoiD?0
(?|C,zxl?Q?L_?vȴ9?)^	?!-w1?N;5?~Q?xPH?bM?bM?vOv_خXtj~?nO;?n/?䎊r?Fs?xtj~?hr Ĝ?tj~?M}H˒?4J?sPH?s*0U2a?-
qv?{u%F?vOv_خnOv_حa4J?{u%FeL_?l1&yku%F},<uL_?rsPH?-
qv?{qu!S?-
qv?%2?n?S?~Ov_ح?zG{?U=K?zG{?E?fA?ݗ+jV? ě?$/?S&?ݗ+j[Q_?PH?o!-w1?[Q_?S?ᰉ'?N;5?fA?+jg?u%gl1&y{u%F,<?sPH?ɅoiD?)^	rn/?c*0U2a?{u%F?u%?pbM?O
M??6C-?$/?	 ?kQ_?eL_?IQfOv_خ?nO;?)^	?nO;?tj?e+a?)^	?ZݘPbM?ye+a?zvȴ9j6C-nOv_ح?zG{?y=b?g?zG{?b}V?0
(?6C-?C,zxl?䎊r?T`do䎊q޿S*0U2a?:)y?$/?n?n/?Mj?sPHg?tndzG{?htj~?$tS?ɅoiD?ߤ??wXe+?vOv_خ?_!-w1ſx*0
q4Jp)^	?x*0
?_oҿf?T`d?x*0
vOv_خ?Mj?O;dZ?2a|Q?+I?vȴ9X?ᰉ'?ᰉ'?}H˒?xtj~?fOv_خ?ku%F?p:?	 ?tn?ye+a?-
qv?Zݘ?-
qv?p:?a4J?u%?a4J?Ov_خ?ߤ??p:?,<M}H˒?{u%F?{u%F?htj~?o!-w1?1&y?W>6z?}}H˒?p)^	?rn/?{u%F?z6C-uL_?Rn/?vǿ]}H˒?+I?_o ?q4J?S?>B?e+?!-w1?tZeL_?4J?|?f?+I?$tS?hr Ĝ?N;5?c*0U2a?},<?*0U2ao!-w1?fOv_خ??j6C-j6C-?z6C-?_o?Q?	 ?O
M?{u%F?kP{?j6C-Fǿm}H˒?m}H˒M}H˒?vȴ9?,<l1&y?O
M?sPH?nOv_ح?PH?S&?2a|Q?O;dZ?PH?J6C-?6C-?쿱[W?S*0U2a?tn?p)^	?`A7L?Z6C-?Ov_ح?tj?ᰉ'?qu!S?QV?zvȴ9?zvȴ9?ye+a?fOv_خ?kP{?:6C-?6C-?~Ov_ح?+?҈?Z?Xe+?zvȴ9                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ??????????????????????ə?????????????????????????????????????????????????????????????????????????????????????????????????????????????ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?333333?333333?333333?333333?333333?333333?333333?333333?333333?ٙ?ٙ?ٙ?ٙ?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????ə???????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          &+uB)@tz3:	-31                                      1                                       