CDF       
      time      pressure  x   latitude      	longitude         string_dimension   (         EXPOCODE      29AJ20160818   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    WOCE_ID       TAlPro     	DATA_TYPE         WOCE CTD   STATION_NUMBER        13     CAST_NUMBER       1      BOTTOM_DEPTH_METERS          
Creation_Time         2020-03-19T19:50:18.366440Z    ORIGINAL_HEADER      CTD,20200319CCHSIO
# Converted CTDOXY from ML/L to UMOL/KG using the following:
#     https://github.com/TEOS-10/GSW-Python, downloaded 2019-06-26
#     gsw.sigma0:  Calculates potential density anomaly with reference pressure of 0
#     dbar, this being this particular potential density minus 1000 kg/m^3.
#     This function has inputs of Absolute Salinity and Conservative
#     Temperature.  This function uses the computationally-efficient
#     75-term expression for specific volume in terms of SA, CT
#     and p (Roquet et al., 2015).
#     http://www.teos-10.org/pubs/gsw/html/gsw_sigma0.html 
#     Python equation used:
#         oxy_UMOL_per_KG = oxy_ML_per_L * 44.660 / ( (1000 +  gsw.sigma0(SA,CT)) / 1000. ) 
# Data source:  https://doi.pangaea.de/10.1594/PANGAEA.902330
# SHIP: RV Angeles Alvarino
# Cruise: MedSHIP cruise TalPro
# Region: Mediterranean Sea and Catalan Basin
# Ports: Palermo, Italy to Barcelona, Spain
# DATES: 20160818 - 20160829
# Chief Scientist: L.Jullion
# 43 stations
# Original file in AWI format. CCHDO Converted to Exchange format
# EVENT_CODE=unknown
# DATE: YYYYMMDD
# TIME: HHMM
# LATITUDE: degrees_North
# LONGITUDE: degrees_East
# STNNBR:  removed leading 0s from STNNBR
# CASTNO: not supplied by originator - CCHDO assigned all CASTNO=1 or CASTNO=2 for stations 11, 29
# CTDSAL: changed units from Practical to PSS-78.  Data values remain unchanged.
# CTDFLUOR: changed units from UG/L to MG/M3 as they are they are equivalent
# CCHDO added flags=2 for all parameters, as T.Tanhua notes all params are calibrated and CTDOXY calibrated with bottle samples
# Removed two test sample depths from event/station 004, dTalpro_Stn04_test_1db
# Data precision preserved as submitted.
# CTD: Who - T.Tanhua; Status - calibrated,final
#     Includes: CTDSAL, CTDOXY
#     CTDTMP NOTE: Used first occurrence of primary temperature sensor in original data file
#     CTDSAL NOTE: Used first occurrence of primary salinity sensor in original data
#     NOTE: Physical parameters temperature, salinity, oxygen, density, turbidity, chlorophyll, fluorescence are published on PANGAEA, DOI above.
# Fluorescence (CTDFLUOR): Who - T.Tanhua; Status -final
#        Instrument: WET Labs ECO-AFL/FL, FLNTURTD-2526
#        ScaleFactor: 1.00000000e+001
#        Dark Output: 0.0760
# Turbidity (CTDTURBDTY): Who - T.Tanhua; Status - final
#        Instrument: FLNTURTD-2526
#        ScaleFactor: 5.000000
#        Dark output Voltage: 0.070000
#
# Reference: Cruise report: https://epic.awi.de/id/eprint/49725/1/TAlPro_EUROFLEETS_cruise_report_V2.pdf
# CCHDO page: https://cchdo.ucsd.edu/cruise/29AJ20160818
# Metadata from original file
#     Event(s):     TAlPro-2016_013 (13) * LATITUDE: 41.880000 * LONGITUDE: 9.970000 * DATE/TIME: 2016-08-21T19:22:00 * CAMPAIGN: TAlPro-2016 * BASIS: Angeles Alvarino (URI: http://www.eurofleets.eu/np4/285.html) * DEVICE: CTD/Rosette (CTD-RO)
#     Citation: Tanhua, Toste (2019): Physical oceanography during MedSHIP cruise Talpro. PANGAEA, https://doi.org/10.1594/PANGAEA.902330
#     Abstract: The TAlPro cruise (Palermo - Barcelona, RV Angeles AlvariÃ±o, 18/-8/2016 - 29/08/2-16) occupied three hydrographic transects across the Tyrrhenian Sea, the western Mediterranean Sea and the Catalan Basin (Fig. 1) as part of the MedSHIP programme (Mediterranean Ship-based Hydrographic Investigations Program). A total of 43 stations were occupied during which physical (temperature, salinity, pressure, velocity), biogeochemical (oxygen, nutrients, carbonate system, dissolved Barium, oxygen and nitrogen isotopes) and anthropic (CFCs, SF6) parameters were measured in order to monitor the physical and biogeochemical state of the Mediterranean Sea.
#     Related to: Jullion, Loic (2016): TAlPro-2016: A Tyrrhenian Sea & Alger- provencal component of the MedSHIP Programme. hdl:10013/epic.5a866780-1f8a-45cf-8111-47b2b5dc29db
#     Parameter(s):
#         Event label (Event) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Sample code/label (Sample label) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Date/Time of event (Date/Time) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Latitude of event (Latitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Longitude of event (Longitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Pressure, water [dbar] (Press) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Digiquartz
#         Temperature, water [Â°C] (Temp) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: ITS-90
#         Oxygen, dissolved [ml/l] (DO) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 43
#         Turbidity (Nephelometric turbidity unit) [NTU] (Turbidity) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO
#         Fluorescence, chlorophyll [Âµg/l] (Fluores) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO-AFL/FL
#         Salinity (Sal) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Practical
#     License: Creative Commons Attribution 4.0 International (CC-BY-4.0)
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            pressure               	long_name         pressure   positive      down   units         decibar    data_min      @          data_max      @        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC        '   pressure_QC                	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d        B   temperature                	long_name         temperature    units         ?C (ITS-90)    data_min      @+"C,   data_max      @80U2a|   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC         I   temperature_QC                 	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d        e   salinity               	long_name         salinity   units         PSS-78     data_min      @C>BZ   data_max      @C^IQ   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC        lp   salinity_QC                	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d        0   oxygen                 	long_name         oxygen     units         ?mol/kg    data_min      @d'RT   data_max      @poiDg8   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC              	oxygen_QC                  	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d           CTDFLUOR               	long_name         CTDFLUOR   units         MG/M^3     data_min      *6C-   data_max      ?>BZ   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC           CTDFLUOR_QC                	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d        ͐   	CTDTRBDTY                  	long_name         	CTDTRBDTY      units         NTU    data_min      ?   data_max      ?         C_format      %f     WHPO_Variable_Name        	CTDTRBDTY      OBS_QC_VARIABLE       CTDTRBDTY_QC       Ԁ   CTDTRBDTY_QC               	long_name         CTDTRBDTY_QC_flag      units         
woce_flags     C_format      %1d        @   time                	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      &J   data_max      &J   C_format      %10d        0   latitude               	long_name         latitude   units         	degrees_N      data_min      @D
=q   data_max      @D
=q   C_format      %9.4f           4   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      @#
=q   data_max      @#
=q   C_format      %9.4f           8   	woce_date                   	long_name         	WOCE date      units         yyyymmdd UTC   data_min      35   data_max      35   C_format      %8d         <   	woce_time                   	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d         @   station                	long_name         STATION    units         unspecified    C_format      %s        (  D   cast               	long_name         CAST   units         unspecified    C_format      %s        (  l@       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             @8(\@80U2a|@8Mhr!@8쿱[W@8p:~@8Q@7-V@79XbN@7hU@7)#w@6\(@6ҜwkQ@6y@6eY|@5YJ@4l>B[@3&@3֡a@2$@2(tj@1hۋq@1	@16_ح@1,?@1<64@0ے:)z@0qu"@0s@0w@0f+jg@0EF
L0@0
d7@/C\@/q@/e@/o i@.xF]@.zxl"h
@.xF@.g8}H@.Vl!-@./rGE9@.*1@.iDg8@.S@-˒:)@-G{@-*0U2a@-̿[W?@-ѷX@-*0U2@-qj@-a@O@-#9@-IQ@-u%F
L@-qu!S@-oAs@-ks@-hTɅ@-`6@-X)@-RW@-MV@-Ffffff@-<1&@-@     @-E`A7L@-Be+@-AGz@-AGz@-A'R@-?@-6E@-2nO@--V@-ce@-}Vl@-S@,˒:)@,쿱[W@,($x@,ڹZ@,64@,S&@,b}@,sPH@,sh@,Z@,rGE9@,Ƨ@,@,@,fA@,ݗ+@,,@,思IQ@,8YK@,o i@,Gz@,䎊r@,߱[W>@,6@,I^5@,u@,A@,Dg8~@,-@,G{@,?|h@,;5X@,%2@,*0@,!.@,,<@,SMj@,Fs@,Fs@,SMj@,J@,
(@,1@,qiC@,I^@,`A7@,@,g	l@,{m@,-V@,a@@,O;dZ@,%@,.2@,\(@,
M;@,s@,'RTa@,7KƧ@,ۋq
@,>BZc@,$xG@,@,fA@,@@,	ԕ+@,$xG@,1&x@,-@,IQ@,`A7L@,$/@,/V@,$xG@,>BZc@,qiC@,zxl"@,r@,sP@,Z@,@,Fs@,ȴ9X@,!.I@,}Vl@,}Vl@,Fs@,_ح@,
=p@,+jg@,Xy=@,E@,j~@,#@,D@,*1@,&x@,R@,4֡a@,Ov`@,?@,$@,-@,1.@,o hی@,4m@,@,<64@,ڹZ@,\N<@,%@,u@,,=@,E@,Q@,˒:)@,حV@,	k@,C@,ѷX@, [7@,Gz@,ěT@,vȴ9@,\N<@,쿱[@,,<@,4֡b@,j~@,-
q@,O
M@,ߤ?@,5Xy>@,C,z@,@,qu"@,rGE@,wk@,@,4m9@,˒:)@,U=@,$tS@,|hs@,U=@,H˒:@,!-w1@,~m\@,}E@,}H˒@,}cA @,}E@,}b@,}<64@,{S@,w@,vl!-@,v4K@,tD@,uϪ͞@,t֡a@,sZ@,rn@,q2W@,qA [@,p
=q@,oVϫ@,nt@,m@,lzxl"@,kI^@,jqiC@,ioiD@,heO@,g	k@,gy@,glC@,g_o@,gy@,h@,hK]c@,h@,hp:@,h\)@,h@,h\)@,ik~(@,iB@,jOv`@,jڹY@,kxF]@,kC%@,i@,glC@,gy@,eڹ@,e+a@,bC,@,`ѷX@,`4m9@,`     @,_;dZ@,^쿱[W@,],=@,\?@,\n.@,[6@,[A@,[A@,[dZ@,Y(@,V@,Rm@,QR@,P@,Nߤ?@,M:@,M(@,M5Xy>@,M5Xy>@,Mqu"@,L<쿱@,Lq@,Lq@,L/{J#@,Ka@@,Jd7@,Gy@,E+a@,B}Vm@,Be+@,A@,ATɅo@,@u!@,?o@,> ѷY@,=K]@,<Z@,<wkP@,<PH@,<Q@,;dZ@,:C\@,9"`@,9(@,9	k~@,8F]d@,68YJ@,4D@,4!-w2@,3ݗ+k@,3|@,3g	l@,3Z@,2m\@,1N;6@,/͞@,-(@,-5Xy>@,,_@,,"h	ԕ@,+C]@,+C]@,+U=@,+6z@,*D@,*0
@,*L_@,*͞&@,*n@,*Ov`@,)'RTa@,(p:@,(K]c@,'-@,'K]d@,'	k@,',@,&,<@,&@,&IQ@,&$/@,%O
@,%zxl"h@,%Q@,#@,"3@,vȴ9@,J#9@,4m@,!R@,Mj@,@N@,33333@,@N@,@N@,䎊q@,s@,R@,[W>6@,'RT@,͞@, hۋ@,c	@,H@,!R<@,@,"h	ԕ@,a@@,jf@,
fB@,
L/{@,	lD@,	Dg8~@,	@,	*0U2a@,	rGE@,ۋq
@,TɅ@,p:@,@,	 ѷ@,	rGE@,	@,	@,	Dg8~@,	k~(@,	y@,
	 @,
JL@,
L_@,q@,

qv@,Vu@,
%@,]cA@,
d7@,
	 @,	x@,@,fA@,+I@,@,?@,1@,u@,S@,tj@,%2@,
=p@,A [@,
=p@,n.3@,s@,$/@,      @+.H@+!.H@+lC@+S&@+1'@+=b@+)@+y=c@+Q@+}H@+4m@+
=p@+ȴ9X@++J@+R<6@+Ϫ͞@+\(@+?@+?@+Ϫ͞@+\(@+\(@+Xy=@+!R@+=K@+=K@+=K@+!R@+j~@+Fs@+@+sP@+l@+{@+{@+|@+:~ @+-
q@+*0U@+v_ح@+1@+ߤ?@+qi@+T@+;5X@+\@+V@+:@+!-w@+C@+U=@+d7@+x@+Dg8~@+@+rGE@+@+u%F@+#@++I@+fffff@+ڹ@+7@+㯷@+`A@+@+䎊r@+|hs@+ޞ@+($x@+ݿH˒@+}H@+p
=@+IQ@+<64@+[@+K]@+ܹ#x@+C,zx@+lC@+~$@+s@+G{@+6C@+=b@+#w@+73@+և+J@+՛=K@+Ձ$/@+m8@+zG@+SMj@+9XbN@+,<@+@+Z@+яo@+bM@+*0U@+Ϫ͞@+v_ح@+Mj@+ΗO;@+_o @+O;dZ@+'/@+eO@++I@+_o@+fA@+$xG@+1&x@+y@+K]d@+@+@+,@+żn/@+g8}@+74@+&IR@+NU@+lC@+~@+>B@+)@+Xe@+8YJ@+J@+ᰊ@+R@+䎊@+X@+&x@+
(@+)^@+)^@+D@+{@+`A7@+:~ @+*0U@+-
q@+:~ @+o @+-V@+{J#:@+\(@+O
M@+ hۋ@+Vu@+jOv@+ڹY@+ԕ*@+ԕ*@+^5?}@+oiD@+k~(@+@+p:@+@+@+ۋq
@+@+@+$xG@+/V@+RT`e@+Fs@+A@+IQ@+L/{J@+s@+?@+$/@+@+
L/@+@+Q@+tj@+\N@+wk@+Zc@+'RT`@+حV@+
qu@+4m9@+     @+˒:)@+?@+;dZ@+\N<@+<64@+쿱[@+qu!@+^5?|@+_o@+(@+XbM@+0
)@+#w@+e+@+)@+D*@+*0@+bM@+F]d@+@++@++@++@+@+4m@+1@+C-@+4K@+?@+\(@+=K@+\(@+Ϫ͞@+Ϫ͞@+sg@+E@+֡a@+9XbN@+a@O@+a@O@+tj~@+҉@+-V@+o@+4J@+_p@+$tT@+@+{J#:@+;dZ@+Vϫ@+@+Vϫ@+͞@+\(@+iDg8@+O
M@+'/W@+
M;@+O;@+p:~@+qi@+(@+V@+B@+:@+:@+cA \@+҈@+jf@+C%@+C%@+C%@+]cA@+jf@+xF]@+xF]@+xF]@+xF]@+:)z@+q@+:)z@+jf@+6z@+C,z@+D@+͞&@+0
@+0
@+0
@+L_@+W'@+JL@+=p
@+0U2a|@+#9@+ᰉ'@+@+@+	ԕ+@+fA@+y@+y@+&@+ݗ+@+	k@+zH@+ݗ+@++I@+]cf@+?@+ڹ@+ڹ@+8YK@+oiDg@+$/@+L/{J@+L/{J@+?@+1.@+YJ@+s@+IQ@+-@+$/@+O
@+m\@+o i@+o i@++a@+JM@+*0@+tSM@+g8}@+?@+$@+S@+F]c@+9@+	@+	@+74@+@+Zc@+.H@+s@+s@+@+e@+o hی@+TɅo@+ѷX@+ѷX@+IQ@+4m9@+vȴ9@+U=@+~6z@+}v@+{5Xy@+{dZ@+{J#9@+z6C@+yXbM@+x_F@+wO;d@+v+jg@+s@+s&@+r{m@+qhr @+p`A7@+o;dZ@+oAs@+n+@+n.2@+l@+k҈@+j=p
@+h@+f1.@+dS@+c
=p@+bh	ԕ@+a [7@+`'RT`@+^
(@+\?@+[=K^@+\ߤ@@+[q@+XYJ@+Y#w@+Vz@+U$/@+SMjO@+RnO@+P{@+L"h	ԕ@+KI^@+I*0U2a@+H@+Eڹ@+D/@+D%1@+C,zxl@+A@N@+A@N@+>쿱[W@+<?@+;J#9@+;/V@+;=K^@+:c	@+:xl"h
@+9(@+9XbM@+9XbM@+8y=c@+7+j@+7&@+7O;d@+6@+6@+6Ov_@+5!.@+6_ح@+6af@+6+jg@+5$/@+4SMj@+4,<@+3E@+3ߤ@+3Z@+1X@+0U2a|@+/o @+/\(@+/O
M@+/4֡a@+.+@+.t@+.zG@+-@+,@++q@+*Ov`@+#S&@+#nP@+#S@+#wk@+#$@+#n.3@+#$@+#$@+#wk@+#a@N@+#	@+#S@+#a@N@+#S&@+"C,@+#wk                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        @C97KƧ@C9rGE@C5%F
L@C7/V@C9iB@C:S&@C7$tS@C/K]d@C-'0@C-*0@C,~($x@C+@N@C)"`@C(-
@C"h	ԕ@ClC@C1@C*0@Cs@Cqu"@C҈@CnP@C>BZ@C2W@CzG@C[W>@Ceں@C%@C@C
L/@C e+@C	k@CKƧ@CAs@C@@Cڹ@C *0@C!oiD@C#eO@C$g8}@C#g@C"1'@C"6C@C$,<@C%%F
L@C&8YJ@C)u!S@C*=p
@C+҈@C-'0@C.}Vl@C/?@C1_p@C2~"@C3@C5Y|@C5cA @C6!R<@C6O;@C7,@C8u%F@C:e+@C;҉@C;jf@C;33333@C<zxl"@C>'@C@{@CBn@CBxl"h
@CBG{@CBm@CCn.3@CDtj@CDM:@CD?@CE}H@CFaf@CGsPH@CGVϫ@CH@CH}H@CH73@CH˒:*@CH\)@CI4J@CIn.@CI-@CJI^5@CJJL@CJp:@CK)^	@CKS@CLxF@CLSMj@CL~($x@CL@CL@CM%F
L@CM!R@CM@CMᰉ@CNOv_خ@CN@COiDg8@CO3@CP	ԕ+@CP@COݗ+@COeں@CO
M;@CNߤ?@CO&@CO;dZ@CPbM@CP@CQ:S@CQXbM@CQe+a@CQ|Q@CQX@CQ_o@CQ>BZ@CR6C@CRsP@CSPH@CS)^	@CSC%@CSg	l@CS@CSC]@CT/{J#@CTVϪ@CTTɆ@CT!-w@CUu@CU'0@CU'0@CUV@CU*0@CU[@CU[@CU%F
L@CU5Xy>@CU?|h@CUB@CUVl!@CUfA@CUzxl"h@CUv@CUϪ͞@CUC\@CVu@CV\N<@CV@CW@CWv_ح@CX@CX
=q@CXC@CY [7@CYhr @CYo@CYl@CY'R@CYX@CYᰉ'@CZ0U2a|@CZC\@CZGE85@CZJL@CZJL@CZJL@CZJL@CZ@4n@CZ6C@CZ:)y@CZOv`@CY@CYԕ*@CY.H@CZC\@CZM@CZ)y@CZQ_@CZkP|@CZ@4@CZL_@CZvȴ@CZL/{@CZL/{@CZ}Vm@CZ@CZ䎊q@C[,zxl@C[jf@C[a@O@C[Ƨ@C[Q@C[lC@C[C]@C[\N@C\n.@C[s@C[$@C[lC@C[
=p@C[~($@C[wk@C[*0U2@C[q@C[$@C[@C\!-w2@C\9XbN@C\,<@C\!-w2@C\"h	ԕ@C\Q@C\tj@C\%1@C\o h@C\_@C\S@C\TɆ@C\1&@C\1&@C\@C\@C\D@C\e@C]*0@C]+a@C]/w@C]*0@C]*0@C][@C][@C]84֡@C]<64@C]5Xy>@C]+a@C]+a@C]+a@C]/w@C]%F
L@C]Q@C]!.H@C]!.H@C](@C]%F
L@C]+a@C]2a|@C]84֡@C]84֡@C]F
L0@C]F
L0@C]Y|@C]sg@C]ݗ@C]=K@C]Xy=@C]sh@C]S@C]!.@C^
(@C^u@C^5?|@C^H@C^\N<@C^c	@C^Vu@C^Ov_خ@C^Vu@C^Vu@C^\N<@C^\N<@C^\N<@C^_ح@C^p:~@C^}Vl@C^IQ@C^}Vl@C^}Vl@C^}Vl@C^z@C^}Vl@C^}Vl@C^}Vl@C^c	@C^;5X@C^
(@C^t@C]C\@C^
L/@C^t@C^ ѷY@C]ڹ@C]ڹ@C]ڹ@C]!.@C]!.@C]!.@C]E@C]ᰉ@C]S@C]@C]n/@C]-V@C]U=@C]v@C]@C]%@C]+j@C]O
@C]=K@C]=K@C]+j@C]=K@C]=K@C]=K@C]!R@C]!R@C]ڹZ@C]M:@C]}H@C]m\@C]ce@C]\@C]Vl!@C]S&@C]L_@C]L_@C]IQ@C]B@C]2a|@C]Q@C]qu"@C]*0@C]*0@C]*0@C][@C][@C][@C][@C]u@C]u@C]u@C]V@C]u@C]u@C]qu"@C]Q@C]!.H@C]Q@C]Q@C]!.H@C]!.H@C]Q@C]!.H@C]!.H@C]Q@C]Q@C]*0@C]'0@C\e@C\Z@C\*1@C\cA \@C\Fs@C\/{J#@C\,<@C\(\@C\(\@C\%1@C\"h	ԕ@C\!-w2@C\Q@C\Q@C\tj@C\tj@C\@C\@C\@C\ߤ@@C\1&y@C\J@C\J@C\n.@C[\N@C[\N@C[@C[s@C[s@C[$@C[$@C[$@C[A [@C[$@C[$@C[A [@C[A [@C[A [@C[A [@C[$@C[@C\ߤ@@C\tj@C\Q@C\%1@C\PH@C\tSM@C\wkP@C\m8@C\SMj@C\M:@C\Fs@C\<쿱@C\2W@C\(\@C\!-w2@C\Q@C\L_@C\@C\xF@C\n.@C\n.@C\xF@C\ߤ@@C\ߤ@@C\ߤ@@C\n.@C[@C[\N@C[A [@C[g@C[a@@C[Z@C[m]@C[*0U2@C[U=@C[A@C[:)z@C[Mj@C[q@C[@C[~$@C[xF]@C[~$@C[~$@C[Q@C[Mj@C[:)z@C[$@C[$@C[$@C[$@C[A@C[$@C[:)z@C[$@C[A@C[:)z@C[Mj@C[Q@C[~$@C[xF]@C[n.3@C[n.3@C[g	l@C[dZ@C[]cA@C[dZ@C[]cA@C[Z@C[S@C[S@C[Z@C[W>6z@C[W>6z@C[MjO@C[J#9@C[F]c@C[J#9@C[C%@C[9@C[,zxl@C["`B@C[&@C[	@C[C,z@C[C,z@C[PH@C[s@C[҉@CZm\@CZ~@CZc	@CZ䎊q@CZڹY@CZ͞&@CZ<64@CZg	@CZ@CZS&@CZ0
@CZ0
@CZS&@CZS&@CZ\(@CZL_@CZݘ@CZݘ@CZ~"@CZu%F
@CZqiC@CZkP|@CZh	ԕ@CZ^5?|@CZQ_@CZQ_@CZJL@CZ3@CZ-V@CZ#9@CZe+@CZe+@CZOv`@CZs@CZ@CZ@CZn@CYs@CYᰉ'@CYiB@CY"`@CY@CY_o@CYy@CY@CYX@CY@CYu!S@CYe+a@CYe+a@CYk~(@CYo hی@CYk~(@CYae@CYae@CYe+a@CY^@CYQ@CYDg8~@CY-w1@CY_p@CYrGE@CX{@CXěT@CX4m@CXU@CX-
@CX|@CXoiDg8@CXXy=@CXD*@CX:~ @CX:~ @CX4m9@CX'RT`@CX}H@CX6@CX ě@CX6@CX}H@CX6@CX
qu@CX
qu@CX
qu@CX	ԕ+@CXF]d@CX     @CX     @CWrGE9@CW䎊r@CW-@CW@CWfA@CW3@CW[W>@CW&@CW?@CW?@CW-V@CW$tS@CW$tS@CW@CWO;d@CW@CW@CW	@CW{J#:@CW|hs@CWy@CWsPH@CWo@CWlC@CWlC@CWeں@CWb}V@CWb}V@CW_o@CW\(@CWXe,@CWKƧ@CWE84@CWE84@CW8}H@CW$tS@CW)^@CW
M;@CW
M;@CW
=p@CWFt@CW@CW hۋ@CV"@CVx@CV]cf@CVϪ͟@CVm\@CVQ@CV2X@CV6z@CV-@CVT@CV@CV@CV,<@CV$t@CV$t@CVqi@CVqi@CVqi@CV+J@CVIQ@CVIQ@CVIQ@CVz@CVs@CVl!-@CVc	@CVfffff@CV_ح@CV_ح@CV\N<@CV\N<@CV\N<@CVR<6@CVL/{J@CVH@CV?@CV?@CV?@CV5?|@CV1.@CV($x@CVu@CVzG@CVzG@CV4K@CV
(@CUC\@CUڹ@CUڹ@CUڹ@CU!.@CU!.@CUoiDg@CU(@CUoiDg@CU(@CUᰉ@CUS@CU
qv@CU?@CU@CUcA @CU@CU\(@CU\(@CUH˒@CU-V@CUU=@CUXy=@CUXy=@CUXy=@CU@CU@CUv@CUv@CU@CU@CUv@CUv@CU@CU=K@CU+j@CUO
@CUO
@CU!R@CUڹZ@CUڹZ@CUݗ@CUڹZ@CU$/@CU$/@CU$/@CU$/@CU}H@CUw1@CUsg@CUfA@CUY|@CUY|@CUVl!@CUO;dZ@CUS&@CUL_@CUO;dZ@CUL_@CUO;dZ@CUIQ@CU?|h@CU5Xy>@CU2a|@CU2a|@CU/w@CU/w@CU2a|@CU/w@CU/w@CU+a@CU+a@CU+a@CU+a@CU+a@CU+a@CU!.H@CUqu"@CU*0@CUu@CUV@CUu@CUK]@CU'0@CUo i@CU:@CT>@CT!-w@CTD@CThr@CThr@CTJM@CT@CTu"@CT/@CT֡a@CTZ@CT*0@CT@CT@CTɅoi@CT?@CT7@CT#x@CT#x@CT@CT1&@CTzxl"@CT_@CT*1@CT?@CTj~#@CT`d@CT`d@CTM:@CT?@CT2W@CT"h	ԕ@CT1&y@CSg@CS҈@CS|@CSa@O@CSE@CSwk@CSߤ@CS:)z@CSq@CStj~@CSg	l@CSMjO@CS&@CSu%@CRD@CRC,@CRW@CR}Vm@CR@CRL_@CRu%F
@CRZc@CR^5?|@CRM@CR#9@CR#9@CRn@CQ@CQ_o@CQD@CQn.@CQhr @CQQ@CQ:S@CQ&x@CP)^@CP4֡b@CP@CPѷX@CP9Xb@CP{@CP-
@CPoiDg8@CP[6@CPXy=@CPU2a|@CPK]c@CPA7K@CP4m9@CP1&x@CP*0@CP}H@CP@CPbM@CP	ԕ+@CP     @CO#@CO䎊r@CO-@CO䎊r@CO䎊r@COVϫ@CO;dZ@CO@CO˒:)@CO@COvȴ9@COr@CO&@CO@CO{J#:@CO|hs@COy@COv_ح@COo@COo@COb}V@CO\(@COKƧ@CO>6z@CO,@CNߤ?@CNQ@CNQ@CNQ@CNQ@CN'@CN'@CN}Vl@CN2X@CN6z@CNT@CNT@CNT@CN,<@CNO;@CN,<                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        @jPZ@jKo hی@j^{m@jD@jD@j@k~($@k<-
q@kL#@k|&I@kl@k_F@lϪ͞@m6Ov`@o`@pi䎊r@pb@p|hs@p}wkQ@pz	@pƧ@pJL@pN;@pϪ͟@poiDg8@p?@p&x@pI^5?@pߤ?@p@pXy=@p҈p@pZc@pjs@pqi@oI^@ojf@o4K@oc$@oQ@n?@np
=@nL_F@nU\N@nmݗ@nQ@msg@mX?@l4K@liDg8@lJ#9@lFL_@lTɅ@k'/W@kt@k+@k?@khr @kTɅ@kq}H@kFVu@k41&x@jXe,@k@k(>@k*H@kEڹ@k#2a|@jɅoi@j'0@jzG@j ě@j}@jv_ح@iXe@hͥv@gp:@gb4֡b@g[-@g[W?@gᰉ@g>BZc@g@gm@g/@gQ@gwkQ@g
=p@gA7K@gD@gv@g ě@g~"@gC\@g}$/@gt}Vl@gm^5?}@g]@gJ~@gT}Vl@gV@gXF@g[A@gixF]@gl<쿱@goI^@ga@gJC-@g*쿱[W@g/[@gQ5Xy@g39@g#e@g@g/V@fn/@fC\@f|Q@f≠'RT@fOv_خ@f/w@feں@gS@g80
@gX'RT@gIAs@g "@g?|h@g1U=@gL     @g52W@g,	 @gkP|@gZc@g4K@g˒:*@g
p
=@g4m@g	E84@f`A7L@fq@g҈@gѷX@g(@g4m9@f%1@g 쿱[W@gD@g[W>@f<64@fj~@ftj~@fVϪ@f@f-@f	ԕ+@fVϫ@f/{J#@fܹ#x@fo@fSMj@fQ_@f	 @fѕ$@f\@f[W?@f*0U@fn@fe+a@f1&@fr Ĝ@f9XbN@f+jg@f%2@fqj@f8Y@f
qu@fbM@fèXy=@fR@f͞&@f@fS&@f.H@f>B@f~*0@fI^5@f6C@fxF@fxF@f}Vl@fsh@fQ_@f~%1@fq?@fX3@fE.H@fQzH@f`!-w@fbW'@f[eں@fU
=p@fM4m@fXwkQ@f^)y@f`@f\ěT@fTm8@fX@fIN;5@fMx@fTj~#@f7=K^@f#@f"d7@f%*0U2a@f4nO@fEXe@f1v@f'Vϫ@fA [@e@e>B[@f.2@fzH@fJL@fu%F
@f
@f}H@fcA \@eMj@eO;d@eE@e@e_o@eC@e]cA@eNU@erGE9@eر2X@eiB@ew1@e*0U@eدO
M@eY|@e撣S&@eg8}@e@eج>B@eƞ@edZ@eU2a|@e)y@eSMj@e͌~($@e*0U2@ea@@eD*@eu"@eƘ_@eƘ_@e%1@e҈p@e2W@e1.@eg@eYJ@ecA @eZ@eL_@e@eg	l@eXe,@eحV@e쿱[@e)@es@eQ@e7KƧ@e6@eC@e@eqi@e	ԕ+@e;dZ@eB@e*0@eAs@ezG@ezxl"@ez@e~NU@e?@e{&@e|@ez ě@ex
(@ewZ@e|@etS&@ec>BZ@etS&@em	k@etS&@enP@eu@el;5X@e[@ea,@eeGz@ejϪ͟@eirGE8@ef6z@eb˒:*@e_r@eS7KƧ@eWae@eeE84@eeDg8~@eXěT@eUڹ@eZ($x@eb|@eZ'RT`@eaPH@eQN;6@eJߤ?@eW^@eH@eEP{@eO	k~@eQ|@eTO;@eW]cA@eJ ѷ@eEO
M@eF@e8p:@e0y=c@eA"`B@eEMjO@eHzG@e?H˒@e8͞&@e;O
@e3>6z@e43@e-[W>@e)&@e3>6z@e?@e)Q@e-1@e8W@e8W@e?n/@eEJ#9@e3;dZ@e"N;@e,I^5?@e6u%F@e8ȴ9X@e7e+a@e(Ov_@e:~ @esg@e-V@ee@e@e@@ece@e84֡@dGE85@ece@eC,z@e˒:*@ewkQ@dU=@dq@eS@dp:~@dp:~@d҉@e_p@d@dD*@d@de+@de+@dm8@dߤ?@d'@e
쿱[W@e^@d	k~@dl!-@e	7Kƨ@d|@d	k~@d	k~@d'RT@d9Xb@e4J@eXe@dl!-@d{J#9@eTɅ@es@eC\@e?@e)xF]@e/$/@e(zG@e[6@e0U2a|@e"`@ewkP@eM:@e
'R@e
'R@e
@e=b@eQ@e
(@e!R<@e!R<@eb@eW@eF]d@e
@eW@eحV@e䎊@e$@es@eȴ9X@erGE@e
q@e'/@e䎊r@e䎊r@e䎊r@eY@e\(@de@e+I@d hۋ@du@eV@eO;d@e(I^5@em\@ep:~@e~($@e#ᰉ'@e!_p@eR<6@e6z@eěT@eq@eěT@e(xF@e#҈@e"}Vl@e"}Vl@e"|@e"|@e(	ԕ+@e%B@e_@e#;dZ@e*`A@e(	 @e.>@e,3@e**0@e3%F
L@eAK]@eE2a|@eAK]@e:Ov`@e:L_@eAFt@e?n.@e<]cf@e5g@e7N;5@e8{@e4YJ@e0[6@e3"`B@eG@eC5Xy@e;w1@eBhۋq@eE/V@e<ڹY@eBh	ԕ@eL ě@eE/w@eCo@e<+@e:@e>;5X@eG$@e^-V@e[eں@eIXbM@eC@e:4K@eA ѷ@ePI^5?@eA ѷ@e8U@eIXbM@eSrGE@eX@eQq@eM@eGE@eIW>6z@eAI^@eIVl!@eQU=@eL}H@eUfA@eSV@eE+a@eL1'@eZ     @eTqiC@eSV@e_O;d@ePFs@eLQ@eUԕ*@eY.H@eLQ@eCƧ@eJQ@ebSMj@eiE84@e`4֡b@e\ěT@e^($x@e^($x@e\ěT@eXu%F@eNG{@ePD*@e^($x@eY\N@e@m\@eCo @eL6@eW5Xy>@eX0
@eG@eLtj@e[^@eeXe@el	 @e\&I@eW4J@euD@eq$@e`C@e^$/@efy=c@eq$@enp:@ep2W@ew#w@ep1.@eg?@emjf@eq$@eq$@ep1.@efz@ec-V@e_eO@e`C,@ep1.@e~L_@el_o @ej
=q@ep1.@eqO
@eqO
@et[6@e|{@e?@ewk@ewk@emjOv@eg@e|{@euH˒@euH˒@et[6@euH˒@ew"`B@ei?|h@emiDg8@eyrG@e>BZc@eڹY@ew!.H@e| ě@e>BZc@ehۋq@e>BZc@exݘ@e| ě@e~s@ew!-w1@eyrG@e{KƧ@eu!S@eN;@e<쿱@etZ1@e~s@e'RTa@e.H@eg8}@e@e.H@e$@e$t@e ѷ@e-w1@e)^@en.@e@e;5X@e-w1@e@e`A7@e$t@eXbM@e@eH@eOv_@e@e ѷ@efffff@e`A7@eD@e@e`A7@eOv_@eq@e:S@eW>6z@es@ee+a@e
=p@e@es@e
=p@e䎊q@e'/@e9@e9@eU=@e䎊r@eY@eH@e'/@efA@efA@e͞@e84֡@e*0@em@e     @eV@ewkQ@efA@e#x@e͞@ece@e*0@ece@eV@e4m@e4m@e84֡@e!R@e@equ"@eT`d@eT`d@eS@eFs@eqiC@eb}V@e,<@e=K@e~"@eC-@es@eFs@e?@er@e.H@eq@eS@e.H@equ"@equ"@er@eT`d@e?@eb}V@e)y@eS@e.H@e)y@eb}V@e~($x@e~($x@eSMj@ev@eI^5@eX@em\@ep:~@e,<@ev@ev@e@eSMj@eSMj@ev@eᰉ'@ea@@e@ev@eᰉ'@e'/W@e'/W@e@e\N@e@eI^5@eZ@e҈p;@e҈p;@em\@e~($@e҈@eI^5@e@e`d@e_p@e\N@eěT@eDg8~@e64@exF@e@e2W@eDg8~@e҈@exF@eo hی@e҈@e҈p;@e`d@eDg8~@e}Vl@eDg8~@eR<6@eo hی@e҈@exF@ePH@e_ح@en.3@e
L/@e(@eC]@en.3@ePH@eBZc @el!-@eǥS@e@e(@e~@e~@eg	@eǥv@eg	@eVϫ@e@e ѷ@ezxl"h@e@eK]@ey@e$tS@e#@e$tS@eK]@eǤ?@eǣn.@eՆ&@eҿ[W?@eǣn.@e1@e_o@eJM@eΕ*1@eN;5@eg@eFt@eҾߤ?@e[W>6@eL/{J@eZ@eΓtj@ezG@eJM@e@efB@e!.@e/w@eҽ<64@e䎊@e+j@e@e@eu%F
@eK]c@eՄM:@e ě@eΒS&@eٮ1@eY|@e@eحV@eY|@eu%F
@ehr!@eF]d@eحV@eW@eحV@eF]d@eu@e@4@e,=@eW@e	@eJ#9@eQ@e琖@e%@e@e!-w@e@eQ@ebM@eeں@eW'@e:~ @e,@eQ@eVu@eMj@ee+a@en.@ee+a@eo h@eMj@e
=p@erGE@eȴ9X@en.@e,@eVϪ@ee+a@eMj@e,                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ?#?Fs?QR?Z?lD?m8Y?W>6z?	k~?l!-w?8YJ?_حV?J#9?>B[?_Ft?cA \?{m?($xG?R<6?Q?e+a?n?e+?wkQ?L_?C\N?)^?~"?˒:)?L_?U=?M:?nP?o?qu!S?h	ԕ+?!-w1?Ƨ-?Ȗ?)^?ͥu?:~?{m?ю!R<?һA?D?o hۋ?C\?׈eO?\(\?ޚ,<?zxl"h
??|hs?}Vl?(?t?5Xy>?_o?~$?ѷX?&?3?
M:?>BZ?dZ1?#?b}V?'0?틬q?b}Vm?2W?/v?C,zxl?2a|Q?Fs?oiDg8?-
?
qu"?ae?>6z?&IQ?s?m?sPH?Q_?Z1'?!-w1?l?C$?l!-w?L_?ɅoiD?ᇓݗ+?<쿱[?iB?_Ft???>6z?p:~?״3?_حV?#?Y|?}Vl!?Ժ)_?˒:)z?-
?JL_?!.H?-
qv?F]cf?e+a?>B?KƧ?L/{J#?K]d?u%??̼j~#?C]?C\N?L/{J#?u!?ᰉ'?N;5?"`B?$/?ݗ?lC?Ov_خ?,<?Xe?lD?-
?v??u!R?;dZ?|hr?Xe?Xe?v?1&y?ݗ?m\?R<6?'RT?=K]?c	?u?hr Ĝ?쿱[W??}H?u!R?}Vl?[W>6z?ݗ+j?S&?333333?Xe?sPH?n/M}H˒?$tSM?A?~Ov_ح?hr Ĝ?~Ov_ح?-
qv?eL_?ߤ??tj?fA?sg?L_?*0?sg?_o?*0U2a?*0?O
M?!-w1?vȴ9?sg?2a|Q?4J?A?tj?ᰉ'?ᰉ'?<64?tj~?uL_rsPH?w?ku%FkQ_?ߤ??sg?4J?bM?䎊q?|1&y?Rn/l1&y?vOv_خ?S&?L_?tj~ۿXtj~?ݗ+j?hr Ĝ?1&y?1&y?p)^	ku%F?pbMc*0U2a?Q?-
qv?bM?},<?n/?y_o fOv_خ?@NU?J6C-?l1&y?ݗ+j?n3*0U2a?q4J?:6C-o!-w1?usg?H?qu!S?䎊q?y_o ?}Z??S&?Zݘ?{u%F?zvȴ9?|C,zxl?J6C-?Z6C-?vǿj6C-htj~?c*0U2a?pbM?htj~?kQ_?{u%F?y_o J6C-?$/?حU?*0
?Ϫ͞?o!-w1ſrn/?wkP?0
(??A?*0U2a?m}H˒kQ_?u%F
?+?ye+a?v+I?xtj~?}}H˒?bM?ݗ?b}V?C,zxl?$tSM?Q?u"?u"g?H?Rn/?vȴ9X?O
M?hr Ĝku%FXtj~?tZ?},<?UL_?kP{?S?{qu!Stn?}H˒?+jg?N;5?{qu!S?N;5?hr Ĝ?sg?`A7L?n/?N;5?|1&y?[Q_fOv_خ?o䎊q?w?tj?hr Ĝ??	 ?4J?nO;?Mj?fA?Fs?uL_:6C-?V?vȴ9X?f?p)^	?vȴ9X??:6C-?u%?Ϫ͞?}Z?bM?hr Ĝ?$tS?}H˒?-
qv?4J?zG{?cA \?v?j6C-?䎊q?	 ??htj~vǿ{Q_?o!-w1?htj~?j6C-?*6C-wXe+?q4J?{Q_?|1&y?:)y?0
(?PbM?fA?Mjhtj~?wXe+?*6C-?ye+a?S?zG{?Z?2a|Q?nO;?Q?$tS?Mj?S&?Xe+?S&?tj~?_o?|1&y?[Q_*6C-?htj~pbM??a@N?L_?Z?4J?ᰉ'?bn/?},<?e+a?sPH?_!-w1?Z?lRn/?$?]ce?%2?l?Fs?L_?䎊q?}H˒?4J?䎊q?sPH?qu!S?:)yl1&yuL_q4J_!-w1?@NUPbM?4J?L_?hr Ĝ?S*0U2a?fOv_خ?x*0
?rn/qu"?)^	F?y_o ?usgo!-w1ſrnO;?$/?%2?,<?-V?tn?@bMbn/?₿{u%FC,zxl?}}H˒?~Ov_ح?䎊rC*0U2a?}Z?bM?u"?,<?rn/tzG{?bM?u%F
?]}H˒?E?{ſg?n/?ae?u%F_!-w1ſqu"?PbM?y_o ?{?҈ο]}H˒?S*0U2a?},<?|C,zxl?R<64?$/?+J?aenOv_حl1&y?C,zxl?hr Ĝ?Fs?ZݘM}H˒?m}H˒?N;5?
=p
?C,zxl?wkP?bM?xtj~?tzG{?o!-w1?Ϫ͞?	 ?tnx*0
?q4J?|C,zxl?},<?sPH?}}H˒?6C-?*6C-?䎊q??tj?Ϫ͞?tj~s@NU?:6C-?䎊q?wXe+Կ]}H˒?p:?	 ?uL_j6C-?bsPH?}H˒??sPH?Fs?y_o q4Jq4J?O;dZ?-VPbM?)^	?N;5bn/?Q_?!-w1?ghtj~?䎊q?!-w1?v+I?{qu!S?N;5?_o ?qu!S?T`d?bM?}}H˒?@bMM}H˒?)^	?!-w1?{ſeL_?usg?vǿRn/_!-w1?o!-w1ſ:6C-?@NU?nO;?Q?sg?hr Ĝ?qu"ku%F?o䎊q޿tZnOv_ح?|1&y?:)y?2a|Q?,<?l1&y?n?bM?6C-}Z?c*0U2a?Ov_ح?tZ?Q?Ϫ͞?tj~?|C,zxlrn/?@bM?vOv_خ?tzG{?z6C-UL_tzG{Z6C-?)^	?-
qv?!-w1?z6C-?Fs?L_?*0U2a?Fs?hr Ĝ?s*0U2a?x*0
?=K]?-V?u!fOv_خ??*0?!-w1?2a|Q?a@N?N;5?~Q_!-w1?Q?$/?f?z6C-?U=K?|C,zxl*6C-?UL_?v+I?}Z?y_o ?UL_tzG{zvȴ9?kQ_?`A7L?6C-?ᰉ'eL_?m}H˒UL_?`bM]}H˒n/	 ҿvOv_خ*6C-?	 ?whtj~?nOv_حie+a??tj~?ݗ+j@bMo!-w1ſpbMZ6C-?H?F?g?_!-w1ſwXe+?l1&y?R<64?O
M?*0U2a?zG{?tzG{rsPH?Q?$/?u"?l1&y?v+I?vOv_خ?tj~*6C-zvȴ93*0U2a?s*0U2a?qu"}Zie+a?$tS?e+a?a@N?4J?}Z?y_o ?{qu!S?*0?O
M?{Q_V?$/?iB?1&?ߤ?bsPH?	 ?y_o ?w?|C,zxl?Mj?{ſF?uL_?xPHc*0U2auL_?PbMkQ_?l1&y??O
M?	 ҿPbM?wXe+?	 ?sg?u%?vOv_خj6C-?߿gqu"?l??tZ`bM?u!?n?4J?=K]?:6C-?{Q_?0
(?hr Ĝo!-w1?fǿ:6C-?2a|Q?ᰉ'?Xe?xtj~ie+a?:6C-?₿_!-w1?y_o ?쿱[W??sPH?Q?u%F
?sPH?ݗ+j?Z?$tSM?m}H˒ku%F?xtj~?{qu!S?tj~??{u%F?rsPH_!-w1?@?`bMvOv_خtn?uL_?zG{?a@N?}H˒?htj~kQ_?l1&y?x*0
?L_?FspbM?tzG{?a4Ja4Jtn?@NU?)^	usg?:6C-?@NU?Fs?u%?v+I?*6C-nOv_ح?wXe+?{u%F?{qu!S?vOv_خ?rsPH?C,zxl?L_?fA?O
M?p:?U=?$/?tj~?ݗ?u!o!-w1ſg?쿱[W??:)y?wkP?*0?e+a?_Ft?n?vȴ9Xs@NUq4J?p)^	?},<UL_?!-w1?e+adzG{?|1&y?}Z?{Q_?tzG{?wXe+Կo!-w1?䎊q?W>6z?ᰉ'?C,zxl?rsPH?zG{?R<64?fA?u%?wXe+?}Z?1&y?rn/?u!?{u%F?y_o ?g?fOv_خ?@?Z?qu!S?xPH?vȴ9?Z?$/?ᰉ'?htj~?y_o ?uL_?y_o M}H˒?|C,zxl?ku%F?:)y?bn/?%2?~Ov_ح?sPH?rsPH?Q?&?fOv_خ?J6C-?O
M?ku%F?s@NU?Z@bM?䎊r?htj~nOv_ح?Z?wXe+?y_o ?w?+I                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ?????????????????????????????????????????????????????????ə???ə?ə???ə?ə??????ə?ə?ə?????????????      ?333333?????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        &JB'A3513                                      1                                       