CDF       
      time      pressure  i   latitude      	longitude         string_dimension   (         EXPOCODE      29AJ20160818   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    WOCE_ID       TAlPro     	DATA_TYPE         WOCE CTD   STATION_NUMBER        3      CAST_NUMBER       1      BOTTOM_DEPTH_METERS          
Creation_Time         2020-03-19T19:50:16.250958Z    ORIGINAL_HEADER      CTD,20200319CCHSIO
# Converted CTDOXY from ML/L to UMOL/KG using the following:
#     https://github.com/TEOS-10/GSW-Python, downloaded 2019-06-26
#     gsw.sigma0:  Calculates potential density anomaly with reference pressure of 0
#     dbar, this being this particular potential density minus 1000 kg/m^3.
#     This function has inputs of Absolute Salinity and Conservative
#     Temperature.  This function uses the computationally-efficient
#     75-term expression for specific volume in terms of SA, CT
#     and p (Roquet et al., 2015).
#     http://www.teos-10.org/pubs/gsw/html/gsw_sigma0.html 
#     Python equation used:
#         oxy_UMOL_per_KG = oxy_ML_per_L * 44.660 / ( (1000 +  gsw.sigma0(SA,CT)) / 1000. ) 
# Data source:  https://doi.pangaea.de/10.1594/PANGAEA.902330
# SHIP: RV Angeles Alvarino
# Cruise: MedSHIP cruise TalPro
# Region: Mediterranean Sea and Catalan Basin
# Ports: Palermo, Italy to Barcelona, Spain
# DATES: 20160818 - 20160829
# Chief Scientist: L.Jullion
# 43 stations
# Original file in AWI format. CCHDO Converted to Exchange format
# EVENT_CODE=unknown
# DATE: YYYYMMDD
# TIME: HHMM
# LATITUDE: degrees_North
# LONGITUDE: degrees_East
# STNNBR:  removed leading 0s from STNNBR
# CASTNO: not supplied by originator - CCHDO assigned all CASTNO=1 or CASTNO=2 for stations 11, 29
# CTDSAL: changed units from Practical to PSS-78.  Data values remain unchanged.
# CTDFLUOR: changed units from UG/L to MG/M3 as they are they are equivalent
# CCHDO added flags=2 for all parameters, as T.Tanhua notes all params are calibrated and CTDOXY calibrated with bottle samples
# Removed two test sample depths from event/station 004, dTalpro_Stn04_test_1db
# Data precision preserved as submitted.
# CTD: Who - T.Tanhua; Status - calibrated,final
#     Includes: CTDSAL, CTDOXY
#     CTDTMP NOTE: Used first occurrence of primary temperature sensor in original data file
#     CTDSAL NOTE: Used first occurrence of primary salinity sensor in original data
#     NOTE: Physical parameters temperature, salinity, oxygen, density, turbidity, chlorophyll, fluorescence are published on PANGAEA, DOI above.
# Fluorescence (CTDFLUOR): Who - T.Tanhua; Status -final
#        Instrument: WET Labs ECO-AFL/FL, FLNTURTD-2526
#        ScaleFactor: 1.00000000e+001
#        Dark Output: 0.0760
# Turbidity (CTDTURBDTY): Who - T.Tanhua; Status - final
#        Instrument: FLNTURTD-2526
#        ScaleFactor: 5.000000
#        Dark output Voltage: 0.070000
#
# Reference: Cruise report: https://epic.awi.de/id/eprint/49725/1/TAlPro_EUROFLEETS_cruise_report_V2.pdf
# CCHDO page: https://cchdo.ucsd.edu/cruise/29AJ20160818
# Metadata from original file
#     Event(s):     TAlPro-2016_003 (3) * LATITUDE: 38.520000 * LONGITUDE: 13.350000 * DATE/TIME: 2016-08-19T15:35:00 * CAMPAIGN: TAlPro-2016 * BASIS: Angeles Alvarino (URI: http://www.eurofleets.eu/np4/285.html) * DEVICE: CTD/Rosette (CTD-RO)
#     Citation: Tanhua, Toste (2019): Physical oceanography during MedSHIP cruise Talpro. PANGAEA, https://doi.org/10.1594/PANGAEA.902330
#     Abstract: The TAlPro cruise (Palermo - Barcelona, RV Angeles AlvariÃ±o, 18/-8/2016 - 29/08/2-16) occupied three hydrographic transects across the Tyrrhenian Sea, the western Mediterranean Sea and the Catalan Basin (Fig. 1) as part of the MedSHIP programme (Mediterranean Ship-based Hydrographic Investigations Program). A total of 43 stations were occupied during which physical (temperature, salinity, pressure, velocity), biogeochemical (oxygen, nutrients, carbonate system, dissolved Barium, oxygen and nitrogen isotopes) and anthropic (CFCs, SF6) parameters were measured in order to monitor the physical and biogeochemical state of the Mediterranean Sea.
#     Related to: Jullion, Loic (2016): TAlPro-2016: A Tyrrhenian Sea & Alger- provencal component of the MedSHIP Programme. hdl:10013/epic.5a866780-1f8a-45cf-8111-47b2b5dc29db
#     Parameter(s):
#         Event label (Event) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Sample code/label (Sample label) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Date/Time of event (Date/Time) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Latitude of event (Latitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Longitude of event (Longitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Pressure, water [dbar] (Press) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Digiquartz
#         Temperature, water [Â°C] (Temp) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: ITS-90
#         Oxygen, dissolved [ml/l] (DO) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 43
#         Turbidity (Nephelometric turbidity unit) [NTU] (Turbidity) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO
#         Fluorescence, chlorophyll [Âµg/l] (Fluores) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO-AFL/FL
#         Salinity (Sal) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Practical
#     License: Creative Commons Attribution 4.0 International (CC-BY-4.0)
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            pressure               	long_name         pressure   positive      down   units         decibar    data_min      @         data_max      @        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      3H  '   pressure_QC                	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d        ZX   temperature                	long_name         temperature    units         ?C (ITS-90)    data_min      @*C,zx   data_max      @;p:   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       3H  g,   temperature_QC                 	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d        t   salinity               	long_name         salinity   units         PSS-78     data_min      @B`A   data_max      @Cl쿱[   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      3H  H   salinity_QC                	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d        ڐ   oxygen                 	long_name         oxygen     units         ?mol/kg    data_min      @fSrGE9   data_max      @pAS&   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        3H  d   	oxygen_QC                  	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d          CTDFLUOR               	long_name         CTDFLUOR   units         MG/M^3     data_min      6C-   data_max      ?'/V   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      3H '   CTDFLUOR_QC                	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d       Z   	CTDTRBDTY                  	long_name         	CTDTRBDTY      units         NTU    data_min      ?   data_max      ?ə   C_format      %f     WHPO_Variable_Name        	CTDTRBDTY      OBS_QC_VARIABLE       CTDTRBDTY_QC     3H g   CTDTRBDTY_QC               	long_name         CTDTRBDTY_QC_flag      units         
woce_flags     C_format      %1d          time                	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      &'   data_max      &'   C_format      %10d          latitude               	long_name         latitude   units         	degrees_N      data_min      @CB\(   data_max      @CB\(   C_format      %9.4f             	longitude                  	long_name         	longitude      units         	degrees_E      data_min      @*33333   data_max      @*33333   C_format      %9.4f             	woce_date                   	long_name         	WOCE date      units         yyyymmdd UTC   data_min      33   data_max      33   C_format      %8d           	woce_time                   	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d           station                	long_name         STATION    units         unspecified    C_format      %s        (    cast               	long_name         CAST   units         unspecified    C_format      %s        ( @      @      @      @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              @;p:@:@:섵?@:_o@:ސ$t@:
(@:PH@:d7@:sg@9'0@8ao hی@75o i@6q@6![W>6@5@
qu@4t@4yD@4 ě@32W@33@3to h@368YJ@3_ح@2)@2@2z@2,(\@2	#w@1	k@1Üߤ@1/V@1@1y=c@1rG@1}(@1i'RTa@15Xy=@1)@0C\@0Ȍ@0u"@0
L/@0\(@0`6@0:qiC@0@ѷX@0Rh	ԕ@0S&@0Qhr @0Gy@0:@/\N@/ԕ*@/4K@/*1@/,zxl@/w3@/w4m@/b ѷ@/Yb}@/Rᰊ@/@.㕁$@.O
M@.r Ĝ@."`@.ěT@.+@.Q@.@@.o@.j~"@.hۋq
@.dxF@.]/w@.S@.K:)z@.=b@.3MjO@.+)^	@.-jOv@.1N;6@.5?|h@..c	@.74m@.D/@.DJM@.Vl!@-Ϫ͟@-[@-A [@-@-҈p;@-/V@-_F@-@-o@-~($@-$tS@-zC\@-sg@-lC@-i ѷ@-b3@-YrGE8@-M5Xy>@-A$/@-9"`@-;=K^@-9_o@-6_ح@-64K@-9+@-;u%@->҈p;@-@[6@-=v@-;J#9@-9XbM@-8bM@-5$/@-1@-.H@-0*0U@-1N;6@-4`d@-3|@-52a|@-7kP@-7Xe,@-8tj@-:>B@-<hr@-=+j@->@->쿱[W@-?@-@C@-CeO@-J	 @-IB@-Mhr!@-P'RT@-R:)y@-T,<@-VFs@-Xl"h	@-ZQ_@-\hr@-_H˒:@-`ěT@-cF]c@-dTɆ@-iB@-rs@-t3@-tD@-xtj@-|n.@-|?@-}/w@-;dZ@-     @-҈p@-@4n@- [7@-Ft@-IQ@-Zc@-M:@-E84@-TɅ@-Ov`@-I^@-1&y@-!-w@-@-p:~@-iDg8@--
q@-@-@--@-m@-҉@-@N@-MjO@-m@-sP@-҉@-MjO@-@N@-g	l@-E@-@-D@-!R@-8YJ@-z@-Ov_@-%F
L@-Ʌoi@-j~@-E@-$/@-R<6@-R<6@-E@-+J@-ȴ9X@-
=p@-$tS@-t@-֡a@-*0U2@-sP@-:)y@-2W@-X@-2W@-[W>6@-@-oiDg8@-rGE9@-Vϫ@-{J#:@-p:~@-:@-C@-ڹY@-x@-k~(@-K]c@->BZc@--@-s@-o i@-?@-tj@-Z@-F]c@-@4@-'R@--w1@-4m@-hۋq@-˒:)@-?@-	@-b}V@-;dZ@-}ce@-|n.@-z~@-yXbM@-xD*@-w@-wO;d@-vȴ9X@-u$/@-t,<@-rs@-p@-o;dZ@-o{J#:@-nO;@-lzxl"@-l<쿱@-kxF]@-jD@-jW'@-iᰉ'@-gfA@-fA@-eoiDg@-e@-e84֡@-d2W@-bwkQ@-`C@-]+j@-ZkP|@-Y|@-X_F@-W$tS@-V@-Vȴ9X@-U!.@-U$/@-UXy=@-U?|h@-T*1@-TzG@-T`d@-T9XbN@-Sߤ@-SZ@-T*1@-Xe+@-Y#w@-XYJ@-X}H@-Xy=c@-X73@-W1@-U!.@-U?@-U*0@-U2a|@-T֡a@-Rm\@-OrGE9@-Rᰊ@-T,<@-S@N@-P{@-Q2W@-S*0U2@-T!-w2@-XQ@-^u@-hۋq
@-lC@-nT@-oo @-oO
M@-n+@-o hۋ@-oO
M@-o{J#:@-o@-p@-p ě@-p:~ @-pD@-qX@-rn@-rS&@-r<64@-rm\@-sZ@-s@-s@-sߤ@-s@-s33333@-rm\@-rW@-rnO@-qu@-qhr @-qN;5@-p`A7@-o{J#:@-lI^5?@-jn@-ilD@-gE84@-en/@-a:S@-]E@-\1&@-][@-_Ft@-b&IR@-bu%F
@-bh	ԕ@-a@-`d8@-`'RT`@-^\N<@-Z)y@-TɅoi@-M@-K~($@-E@-Be+@-DM:@-H$xG@-KƧ@-Ov_ح@-P@-Qhr @-Q-@-P$tT@-OAs@-MjOv@-J#9@-G+I@-D2W@-<wkP@-:^5?|@-:1'@-9b}@-12W@-'E84@-%ڹ@-Q@-[@-"@--@-,cA \@-(ۋq
@-'-@-%S&@-!'R@-H˒:@-]ce@-ݘ@-\(@-`d@-Ʌoi@-4֡b@-tj@-33333@-Z@-@-0
)@-XbM@-YJ@-YJ@-1'@-tj@-4m@-=K@-m\@-
(@--
q@-oiDg8@-'RT@-bM@- ě@-@-ߤ?@-
@-zG@-c	@-qi@-4֡a@-bM@--V@-p:~@-C@-cA \@-
d7@-@-/V@-8}H@-L/{J@-`A7L@-7@-nP@-h	ԕ@-e@-@-M@-}Vm@-ae@,Z@,JE@,Q@,Xe,@,'0@,g	l@,&x@,H@,o @,
M;@,H@,zG@,_o @,T@,v_ح@,sg@,?@,@N@,m@,4J@,As@,p:~@,B@,a@@,=p
@,@@,S@,S&@,2W@,a@N@,\(@,3@,ᰉ'R@,NU@,U=@,5?|@,<64@,!.H@,/w@,hr@,]ce@,n.@,ڟvȴ@,C\@,G{@,s@,<64@,|Q@,&IR@,u%F
@,:S@,@,҈p;@,hr@,,<@,b}@,ٌ~($@,%F
L@,`d@,m8@,Լj~@,?@,@,XbM@,+@,y=c@,*0@,Ӂ@,
=p@,D*@,+j@,֡a@,4J@, ě@,)^@,ӎMj@,'0@,E@,D@,Fs@,s@,v_ح@,Ίqi@,͑hr!@,jOv@,V@,@,̿[W?@,̥zxl"@,q@,ᰉ'@,>BZc@,@,8YK@,&I@,L/{J@,$/@,Ƶ'@,y@,	ԕ+@,eO@,˒:*@,p:@,Dg8~@,E84@,F
L0@,a@N@,o@,@,PH@,wkP@,lC@,/V@,Q_@,y=c@,Ov_@,?|h@,D@,#@,Mj@,<64@,u!S@,hr @,hr @,_p@,v@,qi@,1&y@,Ov`@,eO@,&@,x@,@,S&@,o i@,M:@,a@N@, ѷ@,:S@,$tS@,b@,<64@,u"@,]ce@,,<@,)y@,1'@,_o@,Xe,@,=K@,`d@,:)y@,4J@,-
q@,'/W@,_o @,[W?@,g	@,x@,TɅ@,RT`e@,x@,x@,E84@,$xG@,d7@,n@,n@,=p
@,x@,x@,-@,L/{J@,1.@,oiDg@,o i@,7@,/@,/@,7@,o h@,o h@,tSM@,@,Gz@,4m9@,~6z@,}}H@,|64@,y(@,wXe,@,uᰉ@,tzG@,tSMj@,t,<@,s*0U2@,rᰊ@,q@,o͞@,n!R<@,j͞&@,h1&x@,en/@,cZ@,a:S@,_䎊r@,^($x@,[5Xy@,X@@,VE@,U!R@,TE@,SMjO@,Qu@,P{@,P*0U@,OO
M@,MM:@,K'/@,Iᰉ'@,G8}H@,F1.@,E8YK@,En/@,E8YK@,EF
L0@,Do h@,CF]c@,Bu%F
@,@d8@,?˒:)@,?$tS@,?!-w1@,>
(@,;dZ@,:c	@,:kP|@,:)y@,:@,9+@,6@,5$/@,3*0U2@,1iB@,0)^@,/Vϫ@,.Mj@,.ߤ?@,.t@,.Mj@,.p:~@,.H@,-@,,<쿱@,+I^@,)k~(@,(>BZc@,&L/{J@,%S@,%@,%@,%1@,$7@,#S&@,@,#x@,(\@,vȴ@,|@,#w@,e+@,tj@,+j@,&@,E@,'0@,{@,
U=@,~($@,P{@,P{@,'/@,@,n/@,*0@,7@,a@N@,e@+Ft@+5Xy@+6C@+F@+l"h	@+O;d@+
=p@+D@+m@+[W>6@+ hۋ@+L_@+W'@+oiD@+oiD@+K]c@+Fs@+
L/@+tSM@+o hی@+҈p@+NU@+حV@+cA @+n.@+qu!@+ڬ>B@+ڒS&@+څݘ@+֔Fs@+䎊q@+GE85@+n@+u!S@+ϝ-V@+
M;@+Vu@+
qv@+w1@+"h	ԕ@+ȴ9Xb@+fffff@+ěS@+\N@+h	ԕ@+@+[6@+[6@+҈p;@+p
=@+IQ@+6C@+~($@+E@+Ʌoi@+@+{@+
qv@+@+~($x@+Dg8~@+S@+M:@+tSM@+tSM@+Z1@+M:@+nP@+u!@+?@+IQ@+/V@+_o@+#w@+0
)@+U@+>6z@+R<6@+?@+Ϫ͞@+?|h@+E@+ᰊ@+:~ @+ߤ?@++@+a@@+L/{@+W'@+lD@+oiD@+p:@+9Xb@+,<@+oiDg@+`A7L@+
=p@+C,@+@+~$t@+~BZc @+~u@+|Z@+{A@+{qu!@+zC\@+y(@+xe+@+x@@+xbM@+v}Vl@+vl!-@+t3@+tFs@+rm\@+r-V@+qR@+qu!S@+oo @+nVu@+kC]@+jW'@+jd7@+j#9@+j#9@+i'RTa@+g_o@+dJM@+d?@+ca@N@+bwkQ@+aGz@+`[6@+_حV@+_U=@+^m\@+^($x@+^($x@+]+j@+]K]@+\C,zx@+[dZ@+ZC\@+Y0
)@+XQ@+U$/@+TɅoi@+TɅoi@+T3@+T9XbN@+S*0U2@+R{m@+Qo@+Qo@+Q4J@+P{@+PbM@+O;dZ@+M:@+LVϪ@+LL_@+K]cA@+K]cA@+K]cA@+K'/@+JOv`@+I@+H1&x@+F@+C
=p@+A.H@+A|Q@+Ao hی@+A:S@+@u!@+=[@+9>BZ@+9D@+9JE@+8F@+8@@+8e+@+8e+@+8PH@+8e+@+8U@+8@@+84֡b@+8U@+8D*@+7>6z@+4zG@+0{@+/-V@+/{J#:@+/O
M@+.2X@+.p:~@+..2@+-hr!@+,q@+,L_@+,VϪ@++]cA@+)*0U2a@+'	k@+%S@+%@+$o h@+"`A@+#9@+#nP@+"C,@+"74@+"74@+"@4@+"@4n@+!Gz@+@+"@+vȴ9X@+iB@+}H@+6@+)_@+@+JE@+F]d@+Xe,@+3@+#@+SMj@+`d@+`d@+9XbN@+,<@+,<@+|@+W@+:)y@+GE85@+-V@+䎊@+l@+U2a|@+:~ @+rGE9@+qi@+~($@+]cA@+6z@+jf@+]cA@+jf@+xF]@+Ƨ@+a@@+s@+1&y@+C]@+~($@+>BZc@+x@+-@+]cf@+x@+&I@+x@+Fs@+&I@+)^@+&I@+?@+I^5@+R<6@+:S@+ ҈p@+ 4m@+ ѷX@+ 4m@+ C@+ ѷX@+ A7K@*@*?@*Ov_خ@*cA @*v@*H˒@*cA @*+j@*K]@*#x@*hr@*64@*5Xy@*/V@*C\@*C\@*XbM@*JE@*@*\(@*Xy=@*\(@*Z@*@N@*S&@*o@*u!S@*hr @*u@*A [@*;dZ@*\(@* hۋ@*Vu@*/{J#@*xF]@*ڹY@*g	@*0
@*~"@*~"@*d7@*	 @*lD@*Xy=@*y@*,<@*思IQ@*$/@*1.@*?@*@*ڹ@*S@*
L/@*思IQ@*zxl"h@*7Kƨ@*$/@*$/@*҈p@*n@*A7K@*
qu@*!-w1@*.H@*b}V@*U=@*b}V@*ߊ	@*U=@*H˒:@*"@*ޞ@*ރ%@* ѷY@*u@*Ov_خ@*ރ%@*\N<@*\N<@*}H@*ݗ+j@*wkP@*64@*u%@*6C@*Q_@*y=c@*@*״3@*1@*Ϫ͟@*Y|@*ԕ*1@*ԇ#@*ԕ*1@*m8@*ԕ*1@*Z@*2a|@*sg@*Լj~@*sg@*Վ!R@*Fs@*g@*ݗ+k@*g@*|@*m@*W@*sP@*҉@*m\@*ңS&@*a|Q@*s@*ѩl@*u!S@*u!S@*4J@*{@*`A7@*D@*rGE9@*iDg8@*α2X@*;5X@*C\@*\@*V@*>B[@*5Xy>@*5Xy>@*ͫU=@*5Xy>@*>B[@*~($x@*<쿱@*]cA@*I^@*fB@*fB@*ʦL/{@*ʙ0
@*~"@*=p
@*	 @*rGE@* ѷ@* ѷ@* ѷ@* ѷ@*ȴ9Xb@*ȴ9Xb@*\)@*ȧ@*-@*#@*#@*K]c@*1&x@*>BZc@*#@*-@*-@*fA@*K]d@*ǻ/V@*@@*-@*@@*fA@*	ԕ+@*$xG@*>BZc@*K]c@*1&x@*$xG@*	ԕ+@*@@*#@*#@*@*$xG@*>BZc@*Xy=@*ȧ@*p:@*p:@*\)@*@*TɅ@*	ԕ+@*A@*s@*&I@*@*Ďqj@*āo h@*tSM@*ï@*74@*74@*9@*ÈeO@*S@*Õ$@*üZ@*A [@*%1@*%1@*xF@*%1@*\N@*A [@*¶}Vm@*C,@*`A@*u%F
@*3@*@*C@*حV@*4m9@*'RT`@*䎊r@*[W>@*	@*?@*H˒:@*$t@*E@*}H@*H˒@*IQ@*<64@*hr@*hr@*Z@*]ce@*C,zx@*64@*PH@*PH@*PH@*6@*c	@*~@*s@*6C@*U@*e+@*	k~@*0
)@*#w@*#w@*PH@*0
)@*=b@*#w@*rGE8@*XbM@*rGE8@*@*b}@*(@*rGE8@*)@*+j@*kP@*Xe@*&@*kP@*!.I@*l!-@*Ov_@*t@*4K@*+jg@*Ov_@*Ov_@*!.@*?@*!.@*sh@*Xy=@*?|h@*L_@*L_@*L_@*%F
L@**0@**0@*%F
L@**0@*%F
L@*2a|@*Y|@*Xy=@*sh@*=K@*Y|@*Y|@*E@**0@*%F
L@*'0@*D@*E@*Z@*Z@*Z@*E@*D@*D@*@*@**0U2@*|@*ݗ+k@*E@*&@*sP@*<64@*䎊q@*sP@*䎊q@*䎊q@*PH@*33333@*33333@*@N@*҉@*҉@*҉@*ᰊ@*GE85@*䎊@*-V@*䎊@*-@*N;6@*N;6@*X@*l@*2W@*N;6@*N;6@*R@*-@*s@*s@*n@*s@*R@*N;6@*hr @*hr @*hr @*o@*@*u!S@*o@*|@*bM@*bM@*bM@*bM@*U2a|@*rGE9@*@*;dZ@*;dZ@*O
M@*'/W@*O
M@*{J#:@*O
M@*4֡a@*\(@*{J#:@*iDg8@*O
M@*4֡a@*@*(@*C\@*zG@*@*@*C\@*Vu@*c	@*qi@*Vu@*!R<@*;5X@*!R<@*!R<@*;5X@*Vu@*;5X@*;5X@*;5X@*C\@*H@*.2@*_o @*(@*%@*qu"@*(@*B@*V@*@*!-w@*V@*(@*5Xy>@*(@*(@*>B[@*V@*5Xy>@*\@*5Xy>@*_@*I^5?@*҈@*Q@*C%@*L/{@*͞&@*n@*L/{@*W'@*L/{@*=p
@*0U2a|@*JL@*qiC@*L_@*	 @*ᰉ'@*y@*y@*^5?}@*^5?}@*ᰉ'@*lD@*lD@*@*y@*@*x@*@*@*B@*oiD@*k~(@*@*^@**0U2a@*@**0U2a@**0U2a@*7KƧ@*Q@*k~(@*Q@*7KƧ@*Dg8~@*7KƧ@*Dg8~@*\)@*p:@*@*u%F@*K]c@*fA@*@@*RT`e@*E84@*E84@*+I@*,@*Fs@*@*IQ@*,<@*L/{J@*L/{J@*YJ@*$/@*@*@*S@*oiDg@*ڹ@*n/@*m\@*S&@*Q@*84֡@*TɆ@*S@*e@*?@*qj@*7@*Z1@*2W@*tj@*tj@*?@*?@*M:@*tSM@*Z1@*tSM@*o h@*o h@*?@*2W@*tSM@*M:@*M:@*Z1@*M:@*M:@*M:@*o h@*tSM@*o h@*o h@*qj@*o h@*o h@*TɆ@*tSM@*tSM@*g8}@*g8}@*tSM@*o h@*g8}@*%1@*2W@*?@*Z1@*?@*Z1@*Z1@*\N@*{J#9@*	@*9@*,zxl@*,zxl@*F]c@*S@*F]c@*S@*n.3@*{J#9@*n.3@*F]c@*nP@*C,@*Zc@*-w1@*	k@*NU@*'RT`@*'RT`@*
qu@*4m9@*@*@*@*حV@*@*
qu@*6@*6@*6@*'RT`@*NU@*hۋq@*[6@*hۋq@*?@*m\@*6z@*$t@*vȴ9X@*iB@*iB@*6z@*iB@*u"@*]ce@*C,zx@*PH@*wkP@*N;@*쿱[@*쿱[@*1&@*
(                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         @BěT@C bM@B䎊r@C 'RT`@C 'RT@CrGE@C!-w@CH@C.H@B@B䛥S@B@BҬ>B@Be@BΤT@Bξߤ?@B˹~($@BȖ@Bz@BS&@Bƍ@Bl!-@B{m@Bˢwk@BOv`@B hۋ@Bqu!@B$@B`A@B	@B(@BD@BǾvȴ9@Bɳ|@BΗO;@Bд9Xb@BϾvȴ9@B@Bp
=@Bʽ<64@B̲@BRT`e@Bqu!@B)_@B#9@B،@BC@Bn.3@BzG@BVϪ@Bm]@B8YK@BXe,@BQ@BC@B"`B@BcA \@B.H@B@BTɅ@Bg	@B ě@Bc	@Ba@N@B:)z@B҈@BY|@B>6z@B@Bs@B~"@B6@B?|h@BA@B\(@B+j@Cᰉ'@CM@CL/{@Cqu!@Chr@C_o @CMj@C@C
=p@C-V@C7Kƨ@Cl"h	@Cy@C,<@C
ڹ@C@C͞@Cr Ĝ@CA [@ClD@C]cA@C%1@Cm8@C~($x@C`d@C9XbN@C쿱[@CZ@CO;dZ@Ct@CMj@C+j@CDg8~@Cu%F@CY@Cݗ+k@Cj~@CfA@C2X@C[W>@C @C {@C!u@C!N;6@C"1'@C",<@C#E@C%o i@C&c	@C'H˒:@C(H@C)>BZ@C+=K^@C+@C,M:@C-}H@C.af@C/ hۋ@C/	@C/@C0l"h	@C1	k~@C1s@C3~($@C4@C5p
=@C6fffff@C6A@C7y@C8IQ@C9TɅo@C9Y}@C:)_@C;Z@C;C]@C<Z@C=!R@C>Mj@C@NU@CA4J@CAy@CBS&@CC*0U2@CD%1@CE<64@CF+jg@CF2X@CG@CGvȴ9@CH
qu@CH-
@CI^@CJn@CJڹY@CKm]@CLL_@CLcA \@CL#x@CMm\@CNu@CN&I@CO+I@CO˒:)@CP@CP	k@CQ^@CQ.H@CRW'@CRnO@CRn@CSI^@CS	@CSF]c@CSq@CTxF@CTwkP@CT/@CUm\@CU@CVH@CV҈p;@CWO
M@CWsPH@CW&@CW@CW?@CW[W>@CWvȴ9@CW@@CX_F@CXěT@CX`A7@CY_p@CY[W>6@CYD@CZ䎊@CZY@C[	@C[dZ@C[$@C\`d@C\O
M@C\j~@C\@C\e@C][@C]S&@C]zxl"h@C]ڹZ@C]@C^u@C^%@C^6z@C_ hۋ@C_U=@C_kP@C_˒:)@C_;dZ@C_rGE9@C`6@C`4m9@C`Q@C`[6@C`l"h	@C`'RT@C`4m@C`F@C`PH@Ca4J@CaTɅo@Ca|Q@Ca~($@Cau@CaB@CaD@CbI^5@Cb3@CbM@CbqiC@Cb@4@Cbvȴ@Cb@Cb<64@Cb͞&@CbڹY@CcPH@Cc)^	@CcC%@CcA@Ccwk@Cc
=p@Ccg@Cdߤ@@Cd,<@Cd9XbN@CdwkP@CdTɆ@Cd1&@CdTɆ@Cdzxl"@Cd쿱[@Cd*1@Cd#@Cd~($x@Cdg8}@Cdj~#@Cdm8@Cd_@Cd/@Cd!-w@Ce:@Ce*0@Ce2a|@CeF
L0@Ce\@Cew1@Cezxl"h@Ce$/@CeM:@Ce@Cesh@Ce?@CfBZc @Cf\N<@Cfc	@CfiB@CfO;@CfQ@Cfȴ9X@CfA@Cf]cf@CfC-@Cf@CfFs@CfC-@Cfm\@Cg
=p@Cg+I@CgKƧ@Cg;dZ@Cgo@Cg?@Cg3@Ch4m9@ChѷX@Ci^5?}@Cj	 @Cj=p
@CjL_@Cjvȴ@Cjg	@CjsP@Cj䎊q@Cjc	@Cj74@Cku%@Ck҉@CknP@CkF]c@Ck~$@Ckq@Ck6@Ckݗ+k@CkC]@Cltj@Cl/{J#@Cl9XbN@Cl?@ClSMj@ClcA \@ClwkP@Cl?@ClN;@ClS@Cl쿱[@ClS@ClS@Clqj@ClwkP@Clq@ClwkP@Clj~#@ClZ1@Cl,<@ClJ@Ck@Cks@Cl"h	ԕ@Clg8}@ClwkP@Cl~($x@Clo h@ClzG@CltSM@ClZ1@Cl"h	ԕ@Ck
=p@Ck{J#9@Ck]cA@CkI^@Cj`A@Cj74@CkC%@Ck~$@Ckg@Ck@Cl2W@Cl]ce@Clg8}@ClZ1@Cl9XbN@Ck\N@Ck5Xy@CkeO@CkPH@Ck'/@Ck҉@Cj~@Cj~"@Cjn@Ci@Cib}@Cihr @Ci-@Cj)_@Cj>B@Cjݘ@CjqiC@CjGE85@Cj䎊@Ci-@Ciy@Cil@CirGE8@Cihr @Ci|Q@Ci_o@Cio@Ciu!S@Ci7Kƨ@Ciy@Cj	 @Cjs@Cj	 @Cj-V@CjZc@CjQ_@CjGE85@Cj3@Cj1'@CjI^5@Cjn@Cj	 @Cjn@Cju%F@Cju%F@Ci.H@Ci@Cis@CilD@Cjn@Cjs@Cj3@CjW'@Cja|Q@Cj^5?|@CjM@CjT`d@Cj@4n@Cj:)y@Cj=p
@Cj:)y@Cj0U2a|@Cj&IR@Cj䎊@CjOv`@Cjs@Cj	 @Cj	 @CjOv`@Cj1'@Cj@Cie@Ci2W@Ci|@Cin.@Cib}@Cie+a@CiDg8~@CiDg8~@Ci=b@Ci7KƧ@Ci*0U2a@Ci [7@Ci#w@Ci*0U2a@Ci:S@Ci^5?}@Ciy@Ci|@Ci'R@CiR<6@CioiD@Cix@Cihr @CiN;5@Ci7KƧ@Ci_p@Ci ѷ@Ch$tT@Ch\)@Ch{@ChPH@Ch$tT@Ch	k@ChC@Ch҈p@ChF@ChF@ChF@Chۋq
@ChD@Ch)^@ChF@ChD@Chۋq
@Ch`A7@Ch@Ci@CirGE8@Cib}@CioiD@CirGE8@Ciae@CiN;5@Ci0
)@Ci@N@Ci ѷ@Ci ѷ@ChTɅ@Ch)@Ch4m@Ch)@Chp:@Ch`A7@Ci+@Ci@N@Ci$/@Chۋq
@Chp:@Ci [7@Ci-w1@Ci&x@Ch$tT@ChD@Chp:@Chۋq
@Ci_p@Ci7KƧ@Ci4J@Ci4J@Ci*0U2a@Ci	k~@Ch@Chۋq
@Ch)^@Ch@@Ch)@Ch)@Ch4m@Ch{@ChU@Ch@Chu!@Ch_F@CheO@Chr Ĝ@Chhۋq@CheO@ChoiDg8@Ch|@ChYJ@Ch'RT@Ch@Ch@Ch-
@Ch'RT@Chl"h	@ChU2a|@ChA7K@Ch}H@Ch	ԕ+@Ch	ԕ+@Cg#@Cg䎊r@Cg@Cg˒:)@Cg͞@Cg	k@CgkP@Cg@Cg&@Cg|hs@Cgv_ح@CgsPH@Cgo@CgiDg8@CgXe,@CgRT`e@Cg4֡a@Cg'/W@Cg@Cg
M;@Cg@CfFs@Cf@Cf1@Cf]cf@CfϪ͟@Cft@Cf@Cf6z@CfFs@Cf@Cfqi@CfIQ@Cfp:~@Cfc	@Cfc	@Cf\N<@Cf?@Cf($x@Cfu@Cf ѷY@CeE@Ce,=@Ceb@Ce@Cen/@Cev@Ce+j@CeڹZ@Ce}H@Cew1@Cezxl"h@Ce}H@CeO
@Ce8Y@CecA @CecA @Ce\(@Cesh@Ce=K@Ce+j@CeO
@Cehr!@Ce!R@Ce}H@Cezxl"h@Cezxl"h@Cezxl"h@Cew1@Cesg@Cesg@Cep
=@Cece@Ce?|h@Ce5Xy>@Cequ"@Ce'0@Cde@CdZ@Cd#x@Cdzxl"@Cdqj@Cd#@Cdo h@CdzG@Cdg8}@CdVϪ@Cd?@Cd(\@Ccs@Cc
=p@Cc@Cc:)z@Ccn.3@Cc]cA@CcC%@CcPH@CbD@Cb`A@Cb@Cb}Vm@CbwkQ@Cbp:@Cb{m@CbnO@Cba|Q@CbC\@Cb䎊@CbI^5@Caᰉ'@Ca@CaN;6@Cao@Cay@Ca@Ca|@Can.@CaR<6@Ca|Q@Cao hی@Caae@Ca[W>6@CaJE@Ca&x@Ca [7@Ca@N@CarGE@Ca	k~@C`\)@C`D@C`ěT@C`d8@C`@C`|@C`l"h	@C`_F@C`U2a|@C`Xy=@C`U2a|@C`K]c@C`H@C`:~ @C`$xG@C`*0U@C`     @C_-@C_@C_+@C_K]d@C_o @C_@C_zH@C_ݗ+@C_Xe,@C_;dZ@C_.H@C_Xe@C_Ft@C^"@C^Fs@C^x@C^1@C^]cf@C^&I@C^}Vl@C^p:~@C^L/{J@C^($x@C^u@C^@C^4K@C](@C]\(@C]sh@C]-V@C]O
@C]M:@C]S&@C]+a@C][@C\>@C\!-w@C\u"@C\֡a@C\@C\*1@C\zG@C\VϪ@C\(\@C\ߤ@@C\n.@C[s@C[lC@C[a@@C[6@C[wk@C[xF]@C[qu!@C[g	l@C[W>6z@C[=K^@C["`B@C[nP@C[S&@C[S&@CZ~@CZn@CZ\(@CZ@4@CZ{m@CZnO@CZT`d@CZJL@CZ6C@CZ3@CZ&IR@CZs@CYiB@CY@CY'RTa@CY@CYb}@CYo hی@CYXbM@CYTɅo@CY4J@CY&x@CY [7@CX4֡b@CXe+@CX{@CX@CXYJ@CX_F@CX1&x@CX'RT`@CX
qu@CW;dZ@CWkP@CWݗ+@CWݗ+@CWO;d@CW	@CW{J#:@CWo@CWAs@CW;dZ@CWXe@CV"@CVC-@CV҈p;@CVϪ͟@CVm\@CV}Vl@CV,<@CVO;@CV@CV%@CVfffff@CVVu@CV1.@CV!R<@CVu@CU,=@CUb@CU@CU@CUn/@CU-V@CU1@CU!R@CU$/@CUw1@CU`A7L@CUL_@CUqu"@CUV@CU:@CTE@CT@CT֡a@CT@CT#x@CT@CT3@CTS@CTqj@CTzG@CTm8@CTPH@CTI^5?@CT2W@CT"h	ԕ@CT!-w2@CTL_@CSs@CS%2@CS~($@CS*0U2@CSwk@CSA@CSA@CSMj@CSjf@CSJ#9@CS9@CS)^	@CSPH@CSI^@CRD@CRC,@CR ѷ@CR,<@CRW@CR)_@CR<64@CRg	@CR@CRᰊ@CR@4@CRu%F
@CRa|Q@CR3@CR)y@CR)y@CR#9@CR1'@CRI^5@CQlD@CQ>BZ@CQ>BZ@CQiB@CQ@CQ_o@CQD@CQ@CQ~($@CQ7Kƨ@CQ|Q@CQx@CQx@CQo hی@CQ[W>6@CQJE@CQ:S@CQ+@CP\)@CPD@CPѷX@CPp:@CPěT@CP9Xb@CP|@CPQ@CPNU@CP>BZc@CP:~ @CP73@CP4m9@CP1&x@CP1&x@CP-
q@CP'RT`@CP*0@CP'RT`@CP$xG@CP6@CP@CO@CO?@CO@CO	@CO{J#:@COy@COsPH@COlC@CO_o@COO
M@COH˒:@COKƧ@CO8}H@COXe@CO hۋ@CNߤ?@CN+@CNߤ?@CN6z@CN}Vl@CN6z@CNaf@CNaf@CNaf@CNO;@CN@CNIQ@CNiB@CNYJ@CNR<6@CNL/{J@CN;5X@CNOv_@CN
(@CN ѷY@CMoiDg@CM?@CMcA @CMv@CM@CM=K@CM+j@CM+j@CMO
@CM!R@CMڹZ@CMM:@CMp
=@CMjOv@CMce@CMce@CM`A7L@CMVl!@CMB@CM<64@CM2a|@CMqu"@CL!-w@CLhr@CL@CL@CLu"@CLu"@CLZ@CL@CLZ@CL@CLZ@CLu"@CL>B[@CLTɆ@CL*1@CLC@CLqj@CLC@CL#@CL#@CL?@CLo h@CL?@CLzG@CLSMj@CL2W@CL(\@CL%1@CLtj@CLL_@CL@CL@CLL_@CLߤ@@CLn.@CK\N@CK@CKݗ+k@CK
=p@CKa@@CK|@CKa@@CK@CK6@CKE@CKZ@CKq@CKwk@CK$@CKeO@CKeO@CKxF]@CKqu!@CKS@CK9@CK33333@CK33333@CK&@CKS&@CJ~@CJfB@CJ䎊q@CJG{@CJG{@CJsP@CJ<64@CJY@CJ ě@CJS&@CJݘ@CJu%F
@CJh	ԕ@CJa|Q@CJa|Q@CJZc@CJZc@CJW'@CJQ_@CJM@CJ0U2a|@CJ#9@CJOv`@CJ@CJn@CJn@CJn@CIlD@CI-@CIlD@CI-@CIlD@CIe@CI|@CI(@CI(@CIn.@CIR<6@CI@CI~($@CIb}@CI|Q@CI|Q@CI|Q@CIx@CIx@CIo hی@CIrGE8@CIk~(@CIe+a@CI^@CIXbM@CI[W>6@CI[W>6@CI[W>6@CITɅo@CIN;5@CIA [@CIDg8~@CI0
)@CI*0U2a@CI+@CI	k~@CI	k~@CH`A7@CHۋq
@CHD@CH)^@CH@@CHU@CH-
@CHu%F@CHu%F@CHu%F@CHu%F@CH@CHIQ@CH-
@CHtj@CHIQ@CHIQ@CH'RT@CHn@CH˒:*@CH˒:*@CHy=c@CHl"h	@CHhۋq@CHhۋq@CHhۋq@CHhۋq@CHeO@CH[6@CHU2a|@CHK]c@CHH@CHH@CHA7K@CH:~ @CH:~ @CH4m9@CH'RT`@CH6@CH
qu@CH@CH     @CG+j@CGVϫ@CGrG@CGVϫ@CGrG@CG-@CG@CG;dZ@CG@CG@CGo @CG/V@CG3@CGr@CG[W>@CG[W>@CG͞@CG?@CG	k@CG@CGO;d@CG	@CGO;d@CG&@CG4m@CG4m@CG4m@CGy@CGo@CGo@CGlC@CGo@CGlC@CGlC@CGeں@CGeں@CGeں@CG_o@CG\(@CGXe,@CGXe,@CG\(@CGXe,@CGU=@CGXe,@CGU=@CGXe,@CGXe,@CGXe,@CGU=@CGO
M@CGO
M@CGO
M@CGO
M@CGKƧ@CGO
M@CGO
M@CGO
M@CGRT`e@CGO
M@CGO
M@CGU=@CGRT`e@CGH˒:@CG>6z@CG+I@CG$tS@CG'/W@CG@CF"@CF!.I@CF"@CFx@CF]cf@CF]cf@CFߤ?@CFC-@CF]cf@CFߤ?@CFߤ?@CFߤ?@CFC-@CFߤ?@CFߤ?@CFߤ?@CF]cf@CF+@CF&I@CFȴ9X@CF&I@CFQ@CF'@CF}Vl@CFO;@CFqi@CFFs@CF@CF+J@CF}Vl@CFIQ@CFz@CFs@CFfffff@CFYJ@CFVu@CFVu@CFOv_خ@CFL/{J@CFE@CFBZc @CF?@CF8YJ@CF5?|@CF.2@CF1.@CF.2@CF+jg@CF!R<@CF4K@CFzG@CFzG@CEڹ@CE(@CEᰉ@CEᰉ@CEᰉ@CEᰉ@CEᰉ@CES@CE,=@CES@CES@CE,=@CE
qv@CE
qv@CE,=@CE
qv@CE
qv@CE?@CEϪ͞@CEH˒@CE@CE1@CE@CE-V@CEXy=@CE@CE=K@CE+j@CEO
@CEO
@CEO
@CEhr!@CE!R@CEڹZ@CEݗ@CEM:@CEM:@CEzxl"h@CEzxl"h@CEw1@CEzxl"h@CEp
=@CEp
=@CEm\@CEm\@CEjOv@CEjOv@CEjOv@CEjOv@CEm\@CEm\@CEjOv@CEce@CEce@CEY|@CE\@CE\@CEY|@CES&@CEVl!@CES&@CES&@CEO;dZ@CEL_@CEL_@CEL_@CE5Xy>@CE/w@CE5Xy>@CE5Xy>@CE2a|@CE/w@CE!.H@CEQ@CEqu"@CEQ@CE*0@CEqu"@CE[@CEqu"@CE*0@CE[@CE*0@CEu@CEV@CEV@CEK]@CDE@CDE@CD>@CDe@CDe@CDD@CDhr@CDJM@CDhr@CDhr@CDJM@CD@CDJM@CDJM@CDJM@CD@CDZ@CDu"@CDu"@CD/@CD֡a@CD*0@CDZ@CDZ@CD@CD*0@CD@CD#x@CD#x@CD#x@CD#x@CD@CD@CDTɆ@CDzxl"@CDzxl"@CDzxl"@CDS@CDS@CD_@CDS@CDN;@CDN;@CDN;@CDN;@CDN;@CDC@CD?@CDtSM@CDq@CDq@CDq@CDj~#@CDj~#@CDj~#@CDq@CDq@CDq@CDj~#@CDg8}@CDcA \@CD`d@CDcA \@CD`d@CDcA \@CD]ce@CD`d@CDZ1@CDVϪ@CDZ1@CDZ1@CDPH@CDPH@CDM:@CDC,zx@CD?@CD?@CD<쿱@CD64@CD64@CD64@CD64@CD64@CD64@CD/{J#@CD,<@CD,<@CD/{J#@CD/{J#@CD(\@CD!-w2@CDQ@CD@CDxF@CDJ@CC\N@CCs@CC@CCA [@CCC]@CCA [@CCg@CClC@CClC@CCg@CCg@CCݗ+k@CCQ@CC
=p@CC
=p@CCa@@CC|@CCa@@CCa@@CCa@@CC5Xy@CC|@CCa@O@CCa@O@CCa@O@CCƧ@CCƧ@CCZ@CC6@CCZ@CC~($@CCE@CCm]@CCm]@CC@CCq@CCq@CCm]@CCq@CC*0U2@CC*0U2@CCwk@CCwk@CCU=@CCߤ@CCA@CC$@CC:)z@CCeO@CCQ@CCxF]@CCxF]@CCtj~@CCqu!@CCqu!@CCn.3@CCdZ@CCdZ@CCa@N@CC]cA@CCZ@CCZ@CCP{@CCMjO@CCJ#9@CCMjO@CCMjO@CCJ#9@CCC%@CC@N@CC=K^@CC9@CC9@CC,zxl@CC,zxl@CC/V@CC&@CC&@CC&@CC	@CCC,z@CCPH@CCPH@CCPH@CCPH@CCs@CCPH@CCnP@CCnP@CC'/@CCnP@CC҉@CCu%@CC҉@CCu%@CCu%@CCS&@CCS&@CCS&@CCI^@CCS&@CCI^@CCI^@CBm\@CCI^@CB~@CB~@CB~@CB74@CB74@CB74@CBm@CBm@CBc	@CBC,@CBfB@CBfB@CBfB@CBfB@CB䎊q@CB䎊q@CBG{@CBڹY@CB`A@CB͞&@CBW@CB)_@CB)_@CB)_@CB)_@CBn@CB@CB@CBn@CBn@CB<64@CBY@CBg	@CBL/{@CBS&@CBS&@CB@4@CB~"@CB{m@CB{m@CB{m@CBqiC@CBqiC@CBqiC@CBkP|@CBkP|@CBqiC@CBnO@CBnO@CBkP|@CBkP|@CBnO@CBkP|@CBnO@CBkP|@CBZc@CBM@CBJL@CBGE85@CBC\@CB@4n@CB@4n@CBC\@CB:)y@CB䎊@CBOv`@CB@CBs@CBs@CBs@CBs@CBI^5@CBI^5@CB䎊                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         @fSrGE9@i"'RT@i7KƧ@i!-w1@i%&@i|F@i\N<@jb`d@k@m2X@n@4@n'RT@o"h	ԕ@o۳|@p҈@p[W>6@o4֡b@o@p_o@p.H@p4֡a@p3!.H@p%1@p-	@p0g8}@p'8YJ@p!n.3@p $@p7hۋq@p52W@p9E@p7@p1p
=@pAS&@p( [7@pe+a@p)6C@psh@pH@o ѷ@o	 @oD@o1@o{lC@o@4n@oC\@oL/{J@om\@oݮ1@o}B@o.%1@ny=c@no h@nhr@nS&@ns@n٥v@n@n!R<@nu%F
@ndtSM@m7Kƨ@mӀ4m@m!R@n*0@m}H@m~($x@m	@n<쿱@msP@m|,<@moiDg8@n ě@n@mﯷ@mT@m҈p@m.H@m}o hی@mVu%F
@mG@mG@mk.H@m7KƧ@n>@oeO@oYJ@nXbM@m     @l4@kXy=@kxl"h
@ktTɆ@ko'/@k%F
L@k֡a@k@kA@kd7@kAs@kH˒@k!-w@k2X@kSMj@k'/@km4J@kh\)@koحV@kZ!-w@kA>BZ@k8$xG@k/@k!8YK@kA7K@k l!-@k`A7@k(@j
=p@kzH@j4m@j@j($x@jӶE@ja|Q@jA@j䎊r@j~)^@jg@j]W>6z@jbG{@jK=b@j,3@j)N;6@j/\@j+,zxl@jF
L0@j@N@js@iM:@i@is@i@izxl"h@iwk@i@i/V@iDg8~@i\N<@i84֡@i@iw1@iq#@iK)^@iLj~#@iXZ@iO#w@i;͞@i,^5?|@i46z@i&7@iT`d@h	k@iU=@h64@hhr @he+a@hs@h!-w2@h@hؼj~@hض}Vm@h{J#9@h@hƠ-
@hڹ@h0
)@h*0@hm8@hQ@h}Vm@h$xG@h1@hd8@hc	@hQ_@hNU@hS&@h ѷ@hE@h73@hq?@hw.H@hZ@h~@hw1@h{IQ@h~xF@h$@hk@hu@hr@hffffff@hpOv_@h-V@h+jg@hw'0@hd	k@hFhۋq@hUzH@hg^5?}@hfSMj@h`TɅ@hPbM@h<0
@hCݗ@hN쿱[@hNu%F@hB@h5R<6@h;#w@h=rG@h5:)z@h0 ѷY@h1b}V@h8T`d@h6c	@h.*1@h#sPH@h+y@h*_F@h#iDg8@hحV@h4m@hƧ@h*0U2@h
&x@hp:@h#\(@h0
)@h ě@h@h
,@h wkQ@ho@h_ح@h
+@g1@g0
)@g@g.2@ghr!@gc	@h C@g+j@g\N<@hᰉ@h
o i@g\)@g)^@g8YK@g84֡@gC,zx@gp:@gx@g%@gّhr!@gқS@gҚ,<@g@gPH@gݲm]@g@g$@g`A7@gֹY@g˝-V@gVl!@g䎊r@gϪ͟@gF]c@go@glD@gP{@gj~#@gg8}@gXbM@gOv_@g6z@g$tT@gm\@go hی@gC]@g(@g_F@g(@g2a|@gFt@gᰉ@grG@gh	ԕ@gYJ@gW@g/V@g%2@g?@gE@gD*@gѷX@gC%@g7@g҈p@gzxl"h@g$xG@gy=c@gM:@g@gN;@gB@g@gIQ@g@gȧ-@g2W@gN;6@g/@g#w@g"`B@ghr @g!R<@g [7@gg	l@gt@g	@gtj~@gMj@g{@gӸ@gE84@g҈@g5Xy>@gߤ?@gS@gϪ͞@gu%@gy=c@gM@g"h	ԕ@gZ@go i@gY}@gӮzH@gfA@g!-w2@gtj~@g1&@gdZ@gU2a|@gTɆ@gTɆ@g@gC,zx@g@gQ_@gAs@gPH@g$/@g+@g?@gC,@g[@g2X@gjOv@g@gu!@g.2@gحV@g)^@gtSM@g;dZ@gW'@gu@g     @gb}@gE@g64@gQ@g@g|e+@g7@g~u"@gsa@O@g~ ѷ@gzg	@gY^@gWs@g`M:@gOwk@g63@gVtj@grXy=@gkfA@g`JL@gc)^@gh쿱[@g]@gQ:@gGH˒:@g=o@g+@g,Z@gCqu"@gGF
L0@gHTɆ@g3a@@g.E@g<($x@g9a@N@gE
qv@g^҈p@g]{J#9@gP>@gHT@gJ_o @gC[@g3_o@g:ߤ?@g( ě@g.=p
@gKg	l@gEb@gCnP@g=M:@g7+j@g=M:@g6N;@g'JE@g,D@g:@g@H@g<}H@g<1'@g:Q@g<u@g@E@g6L_@g*xF@g,ѷX@g.5?|@g2_F@g(L/{@g'B@g+lC@g0"@g/R<6@g(T@g,A@g,A@gTɅ@gj~#@g
zG@g>BZc@g
(@g
(@g>BZc@gv_ح@g>BZ@fFs@gZ@g<쿱@g'RTa@f\)@f.2@gY}@g*u%F@g+e+a@g}H@g
@ge@g6z@g6z@grGE8@g
ߤ@@f{@f)_@fԕ*@f8}H@f\N@fae@foiDg8@fC\@f`A7L@g;dZ@f例(@ftj@fS@f&I@fC@fv@f҈p@f]cA@g@g@f1@f]cf@fwk@g M:@g@g=b@gQ@f
(@f/V@f
(@g K]c@ffB@f>B[@f}Vl@f+@fݒ:)z@f [7@f+@f@fYJ@f-w1@g쿱[@f$t@fbM@fVϪ@f-V@f䎊r@f:)y@f$tT@fc	@f˒:*@f=K@foiDg@fm\@fp
=@f
qu@fa|Q@fE@fv@fTɆ@f64@fSMj@f҈@f@f6C@fX@fR<6@f($x@fQ@f`A@fL/{@f@f`A7L@f{m@fm\@fL/{@fm\@f_F@f`A@f_F@flC@f|@f{J#9@fVϫ@f2a|@f[W>@f\(@fg@fć+J@fg@fN;5@fiB@fxF]@fĆYJ@fۋq
@fw1@fvȴ9@f@fwkP@fn@f"`@f@f@f ě@f<64@fsg@f/V@f;dZ@f!-w2@fe+a@fāo h@f,<@f)@fq@f+jg@f*0@fce@f*0@f!R@fce@fS@fO;d@fF
L0@f
M;@fQ@f,<@f6z@fa|Q@fkP@f(@fC@f0
@f7@fN;6@fP{@fP{@f(@f4m9@f'RT@fv@f]cA@f1.@f	k@fև+J@fg@fև+J@f[@fM@f[@f[@fjOv@fjOv@f[@f@fe@f@f\(@fZc@fL_@fe@fȢ3@f@f"h	ԕ@f@fȡaf@fӼZ@fnP@f>B[@f.H@fJL@f<64@fzH@fY}@fj~@fN;@f1@f,<@f`A7@fI^@fIQ@f\(@f䎊q@f$/@fd7@fZ@f8}H@f@f@f$tT@f@fp:~@f@f@fu@fm\@foiDg@f,<@fᰉ'@fo@fo @f6@fL_@fI^5@f~($x@fE84@f@f'/W@fI^5@fTɆ@f`d@f-@f-@f`d@f&x@fo hی@f6z@fڹ@fQ@f(@f\(@fc	@fPH@f`A@fsh@f&IR@fQ@f'RT`@fc	@f&@f(@f4m9@f	 @f쿱[W@f4J@f4J@f3@f$tS@f^5?|@flC@f|@f+@fT@fݗ+k@fm]@fl"h	@f+@f1.@f1&y@f-V@fϪ͞@f@f-V@fNU@f-@f\(@fJM@f1@f#9@fO
@f3@f@f"`@fM:@f@f"h	ԕ@fJ@f@N@fS&@f@f=b@fhۋq@f/V@fK]c@fS&@fo i@fحV@fhr!@fحV@fXe,@fu@fhr!@ffA@fu@fj~@f@f@fJE@f-w1@f쿱[@fB@f@f@f@f$@fq@f
=p@fe+a@f
=p@f,zxl@feO@fH@f9@f`A7@f-
@f}H@fH@f+a@fd7@f:@f䎊r@f1'@fZ@fqiC@f͞@fU=@fcA \@f#x@fTɅo@fqj@fQ@fQ@f$tT@fQ@f~($@f7KƧ@f@f@f=K@f@@fbM@f)^	@fbM@f73@fS&@fXy=@f-@fo @f}Vm@f6@f6@fS&@f҉@fo @fE@fE@fᰉ'@fTɆ@fRT`e@f'/W@f@fRT`e@f|hs@f?@fC\@f@fC@fRT`e@f?@f4֡a@f|Q@fC,zx@f4֡a@f
=p@f&x@fn.3@fC]@fߤ?@fBZc @f|Q@fqi@f@fBZc @ftj@fC,zx@fP{@fQ@f|Q@fBZc @f9Xb@fQ@fP{@fPH@f&@fBZc @fl!-@f@f\(@f&@f4m9@fP{@fC\@fTɅ@fu%@fA7K@fu%@f33333@fg	@f3@f ѷ@fϪ͞@fv@fVϫ@fv@f33333@fl"h	@fl"h	@f@f@4n@f2a|@f2a|@f2a|@frGE9@fᰊ@fkP|@f@f2a|@f$xG@fC,@fn@fݗ@fC,@fNU@fC,@fxl"h
@fxl"h
@fkP|@f+@fxl"h
@fM@f@f@fM@fM@fj~#@fN;5@fj~#@f#9@f-@f-@f[W>@fߤ?@f>6z@f0U2a|@f@fߤ?@f*1@f[W?@f2X@fx@fJM@fߤ?@f[W>@f3@f>6z@fwkP@f@f[W>6@fhr @f@f5Xy@fx@f[W>6@fߤ?@fݗ+@f'R@f"h	ԕ@fhr @fFs@f@N@f@fL/{J@f5Xy@fM:@f/{J#@f!-w1@fKƧ@fZ1@fL/{J@fvȴ9X@f=b@f@N@f@f=b@ftj@fcA @fQ@f/{J#@f/{J#@f=b@f@f@ft@flC@flC@fg	l@f@N@f@N@f=b@fg	l@f [7@ft@fvȴ9X@fJ@fQ@f@N@f@ft@fL/{J@ft@fȃ%@fJE@f̮}Vl@f.2@f-
@f@f!R<@f@N@f)^@f.2@fYJ@fYJ@ft@f:)z@fYJ@faf@fnP@fM:@fu!@fg	l@f-
@ft@f)^@fYJ@f\)@f.2@f.2@fżZ@f\)@fb@fnP@f:)z@f [7@fżZ@f [7@fżZ@f\)@f:)z@f=K^@fg	l@ft@fg	l@f\)@f:)z@f)^@f.2@f:)z@f.2@fżZ@f<쿱@f@f)^@f-
@fg	l@fJE@f [7@f\)@ffffff@fD@f [7@fJ#9@ftj~@f̭U@fJ#9@ftj~@f;5X@f:)z@f:)z@f@f;5X@ftj~@fJ#9@fXy=@ftj~@f ѷ@fD@f̭U@fӟU=@f ѷ@f$@f ѷ@fȃn@f̭U@fXy=@f4K@f@f4K@fżn/@f.2@f̭U@f4K@f;5X@fڐ$t@fڐ$t@fu!S@fD@f ѷ@fڐ$t@fڐ$t@ffffff@ffffff@f,=@ftj~@ffffff@fႩ@fႩ@fXbM@f4K@f-w1@f$@fD@fJ#9@f;5X@f-w1@f$@ffffff@f-w1@fڐ$t@f޻@f޻@f޻@f$@f@f@fXbM@fI^5?@ftSM@f-w1@fXbM@fB@fH@f$@ffffff@ffffff@fႩ@f$@f޻@ftSM@fB@f1@f@f ѷ@f ѷ@f ѷ@f ѷ@fXbM@f1@f@f$@fXbM@f1@ffffff@fڐ$t@fE@fq@f޻@fq@f`A7@f-w1@f޻@f-w1@f ѷ@fXbM@f޻@f
=p@f^5?}@f
=p@f$@f@fs@f@fӟU=@fႩ@f$@ffffff@f@f,<@fȴ9X@f
=p@fn.@fI^5?@fs@fH@f@fI^5?@fႩ@fႩ@frGE@fq@f޻@fq@fȴ9X@fXbM@fႩ@f@fn.@f:S@fH@fڐ$t@fXbM@f-w1@f1@f1@f@fn.@ftSM@fႩ@ftSM@ftSM@f)^@ftSM@ftSM@fȴ9X@fB@ffffff@fႩ@f:S@fs@f@f@fn.@fn.@f,@f:S@fs@fe+a@f:S@f!-w2@f1@f-w1@fႩ@fu%F@f)^@f
=p@frGE@f@f,<@fo@fn.@fn.@fo@fo@fe+a@f:S@fn.@f,<@fn.@fڐ$t@fڐ$t@f$@f쿱[@f@fn.@fo h@fȴ9X@ftSM@fI^5?@fMj@f1&@f^5?}@fI^5?@f)^@fVϪ@fȴ9X@f
=p@fn.@feں@f
=p@f,<@fMj@fu%F@feں@f^5?}@fo h@fo h@g @fo h@fH˒:@f;dZ@f!-w2@f:S@f^5?}@fo h@f,@fo h@g @fo h@fo@fo h@fe@f1&@fH˒:@fMj@f,<@fo h@fVϪ@f,<@fo@g:@g @fo h@gsPH@fo h@fȴ9X@f,<@ftSM@fI^5?@f^5?}@g @fe@fo h@gsPH@gsPH@fVϪ@f^5?}@g:@gd7@gVl!@g䎊q@g
䎊r@gsPH@fo@fȴ9X@f-V@fVϪ@f1&@gd7@g-V@g+a@g
䎊r@g:)y@fMj@fe@g֡a@fe@f󐖻@gsPH@gsPH@g֡a@g @g @gsPH@f,@fe@gsPH@g\(@g֡a@f/V@f1&@g֡a@gd7@g\(@g-V@g-V@g:@gsPH@fH˒:@g}H@g䎊q@g\(@g
䎊r@gd7@g	K]d@g-V@fe@f,@gsPH@g:@g:@g+a@g:@fH˒:@g\(@gVl!@g:@g֡a@g$/@gfA@gVl!@g @fH˒:@fe@gsPH@g:@g:@g+a@g+a@g
䎊r@g+a@g+a@g\(@g
䎊r@g\(@g:@gd7@g}H@g-V@gsPH@g	K]d@g$/@gU=@g$/@g}H@g:@gd7@g-V@g\(@gY@g\(@gVl!@g	K]d@g:)y@g:)y@g\(@g}H@gY@g}H@gVl!@gVl!@g
䎊r@g}H@g}H@g}H@g$/@g
䎊r@g\(@g䎊q@g}H@g䎊q@gU=@gU=@gU=@g
䎊r@g֡a@g}H@g'/@g'/@g䎊q@gVl!@gU=@g      @g'/@g$/@g$/@g+a@gVl!@g$/@g$/@gH@g}H@gY@g
䎊r@g}H@gY@g8YK@gY@g:@g'/@g,˒:*@g!ce@g$/@gd7@g+a@g'/@g  ѷY@g8YK@g!dZ@g      @gH@gVl!@g$*0@g      @g8YK@gVl!@gU=@g!ce@g(U2a|@gr Ĝ@gVl!@gVl!@gY@g$/@gIQ@g8YK@gH@g䎊q@g")_@g!dZ@g")_@gH@g$/@gr Ĝ@gU=@g}H@g!dZ@g)@g")_@g(U2a|@gH@f1&@g}H@g$/@gr Ĝ@g,˒:*@g,˒:*@g9@gU=@g"@@g")_@g8YK@g")_@g&m@g!dZ@g&{@g+C,z@g!ce@g9@g  ѷY@g!ce@g0d8@g0d8@g"@@g+C,z@g)@g8YK@g9@g&m@g&m@g      @g!dZ@g!ce@g!ce@g$*0@g/F]c@g/F]c@g-S@g,˒:*@g$*0@g!dZ@gU=@gIQ@g&m@g-S@g+C,z@g,˒:*@g/F]c@g-S@g,˒:*@g,˒:*@g/F]c@g/F]c@g-S@g2
(@g3qu!@g/F]c@g")_@g%!R@g-S@g0d8@g!dZ@g$+jg@g+C,z@g,˒:*@g-S@g(U2a|@g+C,z@g?A [@g>@g+C,z@g)@g$*0@g%!R@g(U2a|@g+C,z@g$*0@g4F@g2
(@g2
(@g8$tT@g)@g      @gwkQ@g/F]c@g?A [@g;Ƨ@g3qu!@g/F]c@g+C,z@g2
(@g=*0U2a@g?A [@g+C,z@g)@g-S@g3qu!@g,˒:*@g"@@g+C,z@g4F@g:c	@g:c	@g2
(@g0d8@g8$tT@g7ߤ@g2
(@g,˒:*@g$*0@g)@g7ߤ@g:c	@g;Ƨ@g:c	@g:c	@g:c	@g7ߤ@g0d8@g68YJ@gEb}@gBQ@g/F]c@g2
(@g=*0U2a@g=*0U2a@g>@g:c	@g7ߤ@g;Ƨ@g8$tT@g0d8@gBQ@gFC-@gIl@gBQ@g8$tT@g:c	@g>@gATɅo@g;Ƨ@g7ߤ@g2
(@g=*0U2a@gIl@g>@g:c	@gIl@gZSMj@gFC-@gBQ@gIl                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         ?sPH??|hs?XbM?m\?䎊qj?#?
=p
?+I?PH?@?Ov_خ?4֡a?6z?C,z?o hۋ?"`A?Fs?o hۋ?d7?,<?s?xF]?|?#?g	?ݗ+j?Xe+?oiDg?/V?>6z?>6z?#?QR??	k~(?s?n/?hr Ĝ??e+a?0
)?5Xy>?jfB?+?ŵsg?Ov_خ?.H?8YJ?ǍO;dZ?˥S?zxl"h
?͎!R<?(\)?φ&I?п[W>?ѫU=?W&?Ҟu?3ߤ?u%F
?C,z?Xy=c?Z?e+a?׷rG?b}?64K?ڳg	l?*0U2?'/V?ނ@4n?_o?܇#?\(?cA [?PH?E?ڍ?$/?ؘ_F?I^5??ܠ-
?ȴ9Xb?#wk?䎊r?!-w1?8YJ?tSMj?u!.?~($x?҈?ѿH˒:?eں?Ϫ͞&?g8}H?+?ˈeO?Ǳ[W>6?ƃ%2?ǻ/V?rGE9?F
L/?|??@4?/v?L_?҉?tj?c	??3ߤ?'??Vu?6z?Q?/w?\(?W&?bM?fA?zG{?N;5?n.3?ڹY?҈p;?K]d?IQ??vȴ9X?1&y?+jf?PH?qu!S?MjOv?<64?y=b?MjOv?vȴ9?!.H?Fs?z?حU?H?
=p
?j~#?Y}?ᰉ'?tj?/v?u%F
?o ? ěT?ᰉ'?ᰉ'?ᰉ'?ߤ?@bM?zG{?*0U2a?ݗ+j?,<쿱?L_?n?fA?fA?2a|Q?Fs?u"?䎊q?Z?حU?5?|h?8YJ?bn/?l1&y?=K^?tj~?sPH?Z?Mj?{qu!Ss*0U2al1&y?y_o ?u"?ᰉ'?Ϫ͞?Z?e+a?Xtj~s@NU6C-?m}H˒?3*0U2a?:)y?{qu!S?g?qu!S?S&?Zݘ*6C-fOv_خ?~Q?nO;?fA?sg?uL_?sg?Q_?~Q?~Ov_ح?A?{?1&y?$tSM?|C,zxl?4J?{qu!S?xPHq4Jusg?x*0
?u"?F?6C-?1&y?Ov_ح?Q?u"?bM?Z?tj?ᰉ'?$tShtj~?s*0U2aku%F?:)y?6C-?zvȴ9?	 ?S&?sPH?*0U2?Ϫ͞?1&y?$tS?sPH?qu"?m}H˒?<64?y_o htj~?!-w1?|C,zxl?~Ov_ح?bM?$tS?|??*0
?ye+a?{?~Ov_ح?hr Ĝ?$tSMo!-w1        ??hr Ĝ?+I?kP{?n/?ye+a?{Q_?_oҿF?rn/?y_o ?|1&y?-V?Ϫ͞?u%?|1&y?e+a?Q_qu"c*0U2a?{Q_?y_o o䎊q?m}H˒kQ_rnO;?u"?ɅoiD?L_?{Q_?xPH?|1&y?},<?Xtj~?l1&y?u!?a4J?u%fǿeL_?-
qv?4J?~Ov_ح?v?},<?{Q_M}H˒??$/?ߤ??ߤ??O
M?wkP?)^	?wXe+?tj~?l?*0U2a?*0U2a?v+I?n/V?bM?ᰉ'?u!?sPH?g?=K]?fA?Ϫ͞?kP{?)^	?{u%F?$tS?)^	?|1&y?o䎊q?n/?Q?rsPHrnO;kQ_?)^	?~Ov_حfOv_خ?wa4J?ߤ??Ϫ͞?@?*0?qu!S?zG{?	 ??)^	?PH?bMS*0U2a??hr Ĝ?*0U2a?*0U2a?@NU?҈?:)y?$/?hr Ĝ?Xtj~q4J?@NU?sg?*0
?rsPH?2a|Q?fA?l?zvȴ9nOv_حm}H˒kQ_tn?v?Q?ǿUL_p)^	rsPH?dzG{?u!?sg?F??u"?~Ov_ح?bM?@NU?,<쿱?a@N`bM?z6C-F?ɅoiD?_o ?@bM?htj~?Q?Z?*0U2?UL_?g?qu!S]}H˒?pbMtzG{?	 ?{ſj6C-?uL_gtzG{wXe+?6C-?ᰉ'?L_?ߤ??1&y?,<?n/?lJ6C-?Xe+?n/?A?Ϫ͞?#?sPHF?ݗ?*6C-?	 ?M}H˒?,<?sg?ߤ??bM?kP{?ݗ+js*0U2auL_[Q_?n?sPH?tj~?sPH?nO;?Fs?:)yS*0U2av?tn@bM?nOv_ح?{Q_?,<?S&?]}H˒?_o ?`A7L?usgS*0U2a?ye+a?S*0U2a?Mj?},<f?v??:)y?sg??zvȴ9?{qu!S?Q?~Ov_ح?!-w1?,<?}Z?A?|??tzG{?|C,zxl?z6C-?{u%F?wXe+?|1&yc*0U2a?kQ_M}H˒?S?rsPH?ie+a?|C,zxl?Q_?Z?Z        ?q4JPbM?s*0U2a3*0U2a?ݗPbM?p:?O
M@bMp)^	?rnO;?	 ?䎊q?4J?-
qv?Z?sPH?3*0U2a?rsPH[Q_?ݗ+j?*0U2a?sPH?A?Q?ZkQ_?z6C-?T`d?6C-?C*0U2a?`bM?V?bn/?},<?z6C-?,<?nO;?4J?tj~?l?|C,zxl?bM?+dzG{q4J?!-w1?UL_??	 ?ie+a?-V?:)y?|1&y?fA?䎊r?R<64?|??Xtj~?<64?hr Ĝ?tj~?tj~?҈?3*0U2a?IQ?E?sg?=K^?Z?@bM?c*0U2a?S?PH?䎊q?1&?n/?s@NU[Q_?~Q?R<64?ceO?$/?Mj?@NU?~Ov_حUL_??*0?S&?sg?Ov_ح?҈?},<?bM?u%?C,zxl?n/?L_?*0U2a?}ZZ6C-???Ov_خ?҈?nO;?*0?-
qv?*0U2?1&y?S*0U2ax*0
?ye+a?bM?&?q4JtZo!-w1?vOv_خc*0U2a?{u%F?Mj?Ov_خ?#?+I_!-w1ſrnO;?f?,<?%2?䎊q?,<?L_?ߤ??M}H˒?Q??)^	?zG{?L_?@NU?N;5?+I?zvȴ9?-
qvpbMl1&y?S*0U2a3*0U2a?j6C-?q4J?)^	??>6z?,<?tj~?S&¿UL_?T`d?Z6C-?v+I???~Ov_ح?*0U2?L_?ݗ+jku%F?uL_?}H˒j6C-?0
(?u!?+I?Zݘ?Fs?	 ?xPH?ye+a?N;5?)^	Z6C-?kQ_?!-w1?|C,zxl?~Ov_ح?y_o ?nOv_حtzG{?J6C-?Z?Mj?)^	bn/?|C,zxl?l?n/?z6C-?}}H˒??q4J?O
M?ᰉ'?	 ?V?q4J?$tS?L_?E?*0?@NU?{qu!Sj6C-l1&y?|?Z6C-?o䎊q?vOv_خPbM?ݗ+j?}}H˒rn/?xPH?+I?v+I?_o?$tSM?2a|Q?fA?ݗ+j?u"?)^	?䎊q?₿[Q_?+J?wkP?䎊q?}Z?|C,zxl?wXe+?u"?]}H˒?o䎊q?1&y?[Q_?Z?)^	bsPH?&?)^	?}}H˒?hr Ĝ?sPH?ǿ*6C-?@?$/?Ϫ͞?fA?kP{?O;dZ?bM?䎊q?O;dZ?l?|1&y?)^	?>BZc?O
M?*0U2a?)^	?Q_?Z?O;dZ?fOv_خ?|C,zxl?Z?ߤ??S*0U2a?bn/?fA?=K]̿q4J?S*0U2a?߿C*0U2a?ݗ+j?ᰉ'?Z?)^	?N;5X?sg?-
qv?C,zxl?U=K?},<?{qu!S?y=b?䎊r`bM?ݗ+j?l!-w?ߤ??hr Ĝ?x*0
_!-w1?ݗ+j?$/?zG{?sPH?fA?Z?e+a?-
qv?S*0U2apbM?rsPH?6C-:6C-?x*0
?ᰉ'?Q?}Z?:)y?O
M?tj~ۿ@bM?}Z?+?Z?)^	?hr Ĝ?!-w1?4J?T`d?fA?6C-??=K^?L_?vȴ9X?usg?ku%Fie+a?*0?҈?Z?Zݘ?nO;?ɅoiD?kP{?$/?@NU?nO;?*0
??PbM?F?}H˒?L_?ᰉ'?hr Ĝ?@NU?䎊q޿*6C-?_oҿ:6C-?u!?,<?l!-w?Z?]}H˒?p)^	?S&?$tS?A?*6C-?V?N;5?u"?:)y?{qu!S?x*0
?},<?~Q?sPHXtj~?rn/?}}H˒?~Q?{Q_?`A7L?_Ft?vȴ9X?ye+a?`bM?M}H˒?ye+a?{?}Z?tZXtj~?~Ov_ح?`d8?`d8?Fs?{u%FS*0U2a?O;dZ?qu!S??N;5?xPH?`bM?S?n?|1&y?	 ?S&?_oҿg?{qu!SbsPH?tZq4J?xPH?u"?!-w1?n/?e+a?~Ov_ح*6C-?nO;?$/?IQ?+I?{?|C,zxl?bM?L_?2a|Q?`d8?{qu!So!-w1ſrnO;?q4J?x*0
?0
(?%2?{Q_?|C,zxl?x*0
?J6C-?C*0U2a?_o ?L_?}H˒?_!-w1?tj~?Z?Zݘ?zvȴ9?z6C-?bMJ6C-ie+a?-V?Ϫ͞?ᰉ'?ᰉ'?ᰉ'?U=K?u"?䎊q?	 ?S&??!-w1?x*0
g?}ZbsPH?}Z?&?L_?tj~?tzG{*6C-?hr Ĝ?=K^?$/J6C-?}Z?rn/w`bM?n?n?n/?tj~?hr Ĝ?vȴ9?Z?)^	?䎊q?{Q_m}H˒s*0U2a?}Z?_Ft?3*0U2a?}}H˒?kQ_?3*0U2a?@NU?u"?:)y?<64:6C-?o䎊q?u"?!-w1?䎊r?_o ?Q?u%F?u%F
?$/?hr Ĝ?rn/Rn/?!-w1?!-w1??n/?N;5?ߤ??u%F
?6C-?ߤ??	 ?@?l!-w?u%F?ᰉ'?_o?sPH?{u%F?tZ?|1&y??{qu!S?n/?-
qv?<64?*0U2a??bM?_o?Q_?Q?)^	?{qu!S?hr Ĝ?)^	?hr Ĝ?)^	?{qu!S?|1&ybn/?sPH?tj~?$/?*0U2a?+I?N;5?{qu!S?)^	?},<3*0U2a?]}H˒?C,zxl?x*0
?}}H˒?	 ?vȴ9?N;5X?wXe+        ?nO;?S&?n?S&?&?҈?<64?2a|Q?Xe+?Xe?kP{?wXe+?xPH?{qu!S?rsPHnOv_حj6C-?n?)^	@bM?,<쿱?*0U2adzG{?Q:6C-?usg?$tS?+I?|C,zxl?vȴ9X?@NU?F?{Q_?!-w1?~Q?sPH?䎊r?y_o kQ_rn/?{Q_?`d8?sg?$tSM@bM?Xe+?=K]?)^	?gj6C-s*0U2aF?xPH?+I?$/?ᰉ'?`d8?:)y?a@N?2a|Q?[Q_??ᰉ'?ᰉ'?IQ?u"?$tS?hr Ĝ?~Q?+jg?,<?eL_?L_?sPH?{qu!S?sPH?&?$/?n?sg?tj~?bM?ɅoiD?y_o ?IQ?+?C,zxl?vȴ9X?x*0
?~Q?vȴ9?,<?+I?S&¿bn/?ye+aRn/?*0U2?O
M?-V?zvȴ9?[Q_?IQ?u%F?Ov_ح?ᰉ'?,<fOv_خ?䎊q?x*0
C*0U2a?+?8YJ?Z?S&?4J?tj~?R<64?nO;?bM?e+a?쿱[W??fA?0
(?z6C-?Fs?,<?ie+a?|?g?},<?N;5?}}H˒c*0U2a?v+I?"`A?=K]̿@bMnOv_ح?u"?O;dZ?,<?u%F?{Q_?|1&y?hr Ĝ?n?bMnOv_حku%F?~Ov_ح?-
qv?nO;?C*0U2a?H?O;dZ?_o?IQ?nO;?xtj~?_o ?|??)^	?)^	?Z?n/?v+I[Q_?u"?!-w1?,<쿱?O
M?$tSM?4J?$/?sg?x*0
?bn/?hr Ĝ?M}H˒?}Z?Ov_خ?$/?tj~?hr Ĝ?*0U2a?hr Ĝ?zvȴ9?{Q_?Xe?ݗ+jhtj~?eL_?},<?xtj~?{Q_?{qu!S?bsPH        ?w?ie+ax*0
6C-?N;5?䎊q?Z?2a|Q?O
MV?rn/Z6C-?PH?ߤ?        s@NU?sg?U=?C,zxl?vȴ9fǿc*0U2a?$tS?Fs?L_?Fs?O
M?a@N?L_?sPH?L_?$tSM?Q?_o ?䎊q?|??Ϫ͞?,<?UL_?bn/?!-w1?)^	?sg?sg?ᰉ'?ᰉ'?N;5M}H˒?sPH?N;5?	 ?&?*0
Fǿo䎊q?m}H˒?vȴ9X?sg?%2?-
qv?{u%F?tzG{?{Q_?	 ?s*0U2atZqu"?o䎊q?v?},<?n/? ѷX?tj~?A?{qu!S?6C-s@NU?3*0U2a?}}H˒?zG{?:)y?)^	?҈?ݗ+j?tj~?T`d?}}H˒?|C,zxlV?%2?pbM?n?u!?u"?Zݘ?䎊q?ku%F?nOv_ح?C,zxlie+a?:6C-?N;6?sPH?rsPH?z6C-?Mj?E?S*0U2a?ku%F?n/?_o?*0?$tS?6C-?htj~Rn/?vOv_خ?tzG{?	 ?₿ku%F?wXe+ԿeL_tZ?U=K?]ce?xtj~?L_?1&y?1&y?:)y?F?m}H˒?bsPH?䎊q޿bsPH?nO;?a@N?!-w1ſf?}}H˒?4J?$tS?4J?6C-?bM?+jg?}Z?j6C-?tn?L_?Ϫ͞?*0
?vȴ9?bM?4J?n/p)^	?N;5?*6C-?p)^	?|1&y?*0U2?tj~?v+I?=K]?	 ?},<?!-w1?bsPHXtj~?҈?*0U2a4J?}}H˒?p:?nO;?T`d?sPH?JD?}Z?a4J?҈?	 ?Y}?O
M?q4J?2a|Q?Xe????$/?sPHhtj~?{qu!S?~Ov_ح?bM?3*0U2a?+I?p)^	3*0U2a        vOv_خ?C*0U2a?n?}H˒fOv_خ?$/?=K^?O
M??҈?sg?Xe?V?,<?=K]?vȴ9X?=K^?ݗ?=K]?2a|Q?_o?-
qv?{u%F[Q_?N;5?@NU`bM?x*0
?䎊r?[Q_?2a|Q?)^	?N;5?zvȴ9?-
qv??+jg?2a|Q?ᰉ'?l?@NU?&`bM?zvȴ9?hr Ĝ?-
qvUL_?-V?kQ_?tn?J6C-?M}H˒?6C-?-
qv?vȴ9X???=K^?	 ҿbn/?wXe+?hr Ĝ?sPH?@NU?c*0U2a?	 ?Ϫ͞?u%F?UL_?O
M?}}H˒?sPH?tj?*0U2?qu!S?H?}}H˒?xtj~?tzG{j6C-?v+IS*0U2a?+?fA?sg?|C,zxl?T`d?sg?s*0U2a?htj~?vȴ9X?Q?4J?|C,zxl?-
qv?sg?ɅoiD?`A7L?J6C-?ݗ+j?sg?҈?:6C-?y_o ?<64?Ϫ͞?uL_?o䎊q?}Z?$tS?@NU?T`d?*6C-?Xe+?nO;?L_?{ſ`bM??bM?S&?L_?{qu!S?`A7L?L_?=K^?qu!S?u%F?1&y?|C,zxl?u"?u%F?PbM?<64?sg?PH                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         ????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????ə????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????ə?????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         &'B{AU333                                       1                                       