CDF       
      pressure  w   time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20140212   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P21    CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:40.875179Z    ORIGINAL_HEADER      CTD,20250204CCHSIOWB
#Renamed 'CTDFLUOR_TSG' to 'CTDFLUOR' with units 'MG/M^3'
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20210615CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2014-07-09. CTD data from cruise 18DD20140212, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20140212. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2014-01/donneesctddata/2014-01-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2014-01/index.php. 
#
# The information in this file for the cruise 2014-01 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2014-01/donneesctddata/2014-01-0082.ctd
#
# Start of originator file comment header
#
#*2014/07/09 16:08:49.62
#*IOS HEADER VERSION 1.10 2011/10/26 2011/10/26
#
#*FILE
#    START TIME          : UTC 2014/02/23 16:30:20.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 2081
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : ACD38923
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            3              2104
#       2 Temperature:CTD               deg_C_(ITS90)   1.8242         7.9261
#       3 Salinity:CTD                  PSS-78          32.3708        34.6182
#       4 Sigma-t:CTD                   kg/m^3          25.2476        27.7052
#       5 Transmissivity:CTD            %/m             61.5           68.4
#       6 Oxygen:Dissolved:CTD:Volume   ml/l            0.2            6.7
#       7 Oxygen:Dissolved:CTD:Mass     µmol/kg         8.5            291.8
#       8 Fluorescence:CTD:Wetlabs      mg/m^3          0.86E-01       1.414
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        6  F       ' '     1
#       6  -99   ' '        7  F       ' '     2
#       7  -99   ' '        6  F       ' '     1
#       8  -99   ' '        8  F       ' '     3
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2014-01
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P5
#    EVENT NUMBER        : 82
#    LATITUDE            :  48  41.45000 N  ! (deg min)
#    LONGITUDE           : 127  10.04000 W  ! (deg min)
#    WATER DEPTH         : 2098
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0550
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    CTDEDIT was used to remove some records near the surface and many
#	records corrupted by shed wakes; salinity was cleaned.
#
#    Data Processing Notes:
#    ----------------------
#    Transmissivity, Fluorescence and PAR data are nominal and unedited except that
#	some records were removed in editing temperature and salinity.
#
#    For details on how the transmissivity calibration parameters were calculated
#	see the document Transmissivity_Calculation.pdf.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in the Sea-Bird
#	Application Note #64-2 of June 2012 (Sea-Bird_64-2_Jun2012.pdf), except that 
#	a small offset in the fit was allowed.
#
#    The Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.8 ml/l from 0 to 100 dbar.
#	±0.6 ml/l from 100 dbar to 300 dbar.
#	±0.2 ml/l from 300 dbar to 800 dbar.
#	±0.05 ml/l below 800 dbar.
#
#    The primary Salinity:CTD channel was used for events 0041 and 0043, so 
#	it was recalibrated to match the secondary channel which was selected for
#	all other casts.
#
#    For details on the processing see the report: 2014-01-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5-- --6--- --7-- ---8---
#!Pressu Temperat Salinity Sigma-t: Trans Oxygen Oxyge Fluores
#!re:CTD ure:CTD  :CTD     CTD      missi :Disso n:Dis cence: 
#!                                  vity: lved:  solve CTD:   
#!                                  CTD   CTD:   d:CTD Wetlabs
#!                                        Volume :Mass        
#!------ -------- -------- -------- ----- ------ ----- -------
#*END OF HEADER
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @C        data_max      @C        C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     ;  .L   pressure                	long_name         pressure   positive      down   units         decibar    data_min      @         data_max      @`        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      ;  j   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d           temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?j~"   data_max      @ M   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       ;     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d        d   salinity                	long_name         salinity   units         PSS-78     data_min      @@9Y}   data_max      @AJnO   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      ;  T   salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d       ;   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @'   data_max      @r$   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        ; I   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d          CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?E   data_max      ?O;dZ   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      ;    CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d       \   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       ; L   PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d          	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min      @Nffffff   data_max      @Q,   C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     ; )   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d       e   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( t   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( t   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min         data_max         C_format      %10d       t   latitude               	long_name         latitude   units         	degrees_N      data_min      @HBB   data_max      @HBB   C_format      %9.4f          t   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      au\(   data_max      au\(   C_format      %9.4f          t   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3P   data_max      3P   C_format      %8d        t   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min        H   data_max        H   C_format      %4d        t@C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @      @      @      @      @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^@     @^     @^     @_      @_@     @_     @_     @`      @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @      @$     @(     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @0     @4     @8     @<     @@     @D     @H     @L     @T     @X     @\     @`     @d     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @      @(     @,     @0     @4     @8     @<     @@     @D     @H     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @@     @D     @H     @L     @P     @T     @X     @\     @`     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @@     @D     @H     @L     @P     @T     @X     @`     @d     @h     @l     @p     @t     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @D     @H     @L     @P     @T     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @d     @h     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @      @$     @(     @,     @0     @4     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            @ ?@ wkP@ 1&@ N;@ #x@ E@ U=@ Ft@ H˒:@ -
@ 7Kƨ@ n.@ |Q@ Gz@ TɅo@ R<6@ 'R@ n.@ @ @ .H@ I^5@ M@ e+@  [7@ 쿱[W@ ;dZ@ 䎊r@ 䎊r@      @      @ @ 
qu@ A7K@ 6@ @ @ @ NU@      @ @ حV@ 
qu@ 4m9@      @ @ 	@ $tS@ 	@      @ [6@ 
qu@ [W>@ vȴ9X@  ѷY@ ҈p;@ H˒:@ 	@ ?@ ˒:)@      @ 
qu@ 
qu@ 	@ @ $tS@ vȴ9@ @ 	@ |hs@ |hs@ H˒:@ q@ @ |@ @@ #w@ '0@ [W?@ 
M;@ i^5?}@ ߤ?@nt@+j@̈́M:@!-w2@0
(@	k@{m]@dtSM@GK]d@64K@q@n@jJL@A:S@	 @ɠ'RTa@>BZc@xYJ@H˒:*@	k~(@ӎMj@e@I^5@sg@^5?|@QN;6@F]c@3@qj@'RT@F@[6@"e+@>$t@JL/{@YJE@be+@nt@hۋq@Q_@,<@!.@~"@KƧ@|hs@*0@ƍ@
=p@6}Vl@KC%@@33333@ߤ@ߤ@m\@33333@C@
qv@C\@\@ce@[@@x@@N;@S@tj@*1@͞@n@}Vl!@mC\@g8}H@\>@Y>BZ@WsPH@Vaf@TFs@Ik~(@?.H@49XbN@*g	@&@ߤ@@b}V@c	@1.@xF]@g	l@7@*0U@\(@lzxl"@Ov_ح@+P{@O;d@)y@Ov`@iB@u%F@;dZ@R@b}V@tSM@@	 @NU@{/V@l"h	ԕ@d7@]}H@PbM@F@BZc@>m\@9#w@4֡a@1[W>6@(Xy=@	@&@@~@0U2a|@u"@@ԕ*1@73@	k@~"@U*0@JW'@CnP@5Y|@)Dg8~@#	@*1@A@t@l!-@84֡@\(@W@y@@/{J#@yY}@oO
M@U$/@;5Xy@,[W?@$tSM@(\@@m@?@3@a@@@ۥS@Țu%F@@@?@n.@4m@y(@wKƧ@s33333@cZ@H˒:*@C%2@:G{@"C,@䎊@s@@Z@)y@Q@C,z@3@ޞ@6C@sP@4J@/{J#@K]d@84֡@$/@j~#@^5?|@?|h@9@@@y=b@x73@rm\@oO
M@]/w@W$tS@S*0U2@Q@P*0U@Q_p@OAs@M(@H˒:*@?[W>@<j~#@9~($@3g@%zxl"h@حV@L_@'/@o hی@A@F]d@D@'RT@C]@RT`e@kP|@m@ϐ@p:~@:@@@5Xy@%F
L@j~@-V@Q_@kP|@Xe,@zG@*0U2@@T@cA \@{J#9@tSMj@pU2a|@kU=@g/V@f1.@a|Q@[=K^@Y+@Yb}@XPH@X*0@V+J@UϪ͞@U$/@U2a|@SMj@Q4J@R<64@O'/W@Mqu"@N!R<@P-
q@P`A7@Dg8}@:xl"h
@9XbM@74m@8l"h	@9rGE8@:^5?|@;J#9@<Q@<쿱[@=p
=@>($x@B@L@Uᰉ@]/w@]cA @]+j@]cA @[q@_!-w1@b3@jJL@vFs@z^5?|@}ڹZ@ [7@S&@
L/@a@N@Zc@{m]@vE@vȴ9X@w4m@vȴ9X@xl"h	@yrGE8@z)_@{A@|?@}K]@|j~#@}Vl!@~\N<@~\N<@~
(@~vȴ9X@ѷX@o hی@@@{J#9@@@&IR@IQ@~m\@}E@}p
=@}!.H@{lC@yXbM@w+@u!R@uXy=@u!R@t3@sg@sߤ@r{m@p'RT@nH@lzxl"@l1&y@kU=@j0U2a|@i*0U2a@hۋq
@hXy=@h>BZc@hXy=@h>BZc@g&@f1.@e`A7L@dZ1@cS&@d?@dtSM@b}Vm@aR<6@b3@b3@`[6@^%@]ce@]IQ@\?@[qu!@ZY@Y|@WsPH@T@R:)y@P)^@OrGE9@Ov_ح@N;5X@MO;dZ@M:@K]cA@J	 @IQ@J	 @I'RTa@IoiD@I7KƧ@Hp:@H˒:*@H@F$/@B@A@A:S@>6z@;lC@;~$@:~@8F]d@6z@5\(@5'0@3E@2a|Q@/@-hr!@,VϪ@+jf@)@'lC@&L/{J@$tSM@"@4@!R<6@!@N@ 'RT`@?@qu!@6@S@,<@JE@+j@Ʌoi@*0U2@X@@Mj@Ƨ@
W'@p:@@YJ@%2@:S@~$@D@@Q@+a@e@u!@ޞ@$@Q_@@ӎMj@Ϫ͞@5Xy>@@@6z@}H@&x@$xG@zxl"h@ae@Ov_خ@u%@҉@'/W@@Q@b}V@{m]@xF@uY|@sPH@o@k~($@hr Ĝ@cS@]+j@W&@V8YJ@Ks@@n@<쿱[@:)_@9Y}@84֡b@49XbN@-B@%S@!R<6@u%@Z@N;6@rGE9@
@I^5?@	ԕ*@M:@@$/@ڹZ@hr@(@hr!@e+@6@ӎMj@т@`A7@
M;@W'@Ƨ-@84֡@g8}@\(@TɅo@vȴ9X@W@a@@lD@/V@IQ@TɆ@h	ԕ@쿱[W@-V@Ov_خ@S@+j@*0U2@C%@hۋq@{lC@tSMj@p:~ @jg	@f1.@bM@Y+@M@JW'@A7Kƨ@<Z@9#w@1o@)y@$xF@!.H@-V@,<@@@@N@$tT@rGE9@!R<@@xF]@
qiC@	7KƧ@ݗ+@n/@{J#9@
#x@
(@
%F
L@
@
빌~($@
A [@
;dZ@
>@
sPH@
т@
*0U@
ΤT@
@
n@
A@
4m@
a|Q@
U=@
.H@
[@
sh@
@
@
qiC@
o hی@
{m]@
vFs@
rs@
mhr!@
iB@
`
qu@
Ov_ح@
Fs@
B&IR@
8YJ@
.zG@
)lD@
$TɆ@
쿱[W@
Ov_خ@
ᰉ@
S&@
@
	7KƧ@
oiDg@
S&@\N<@+@iB@JL@	@ޞ@b}@ԕ*1@s@ȴ9Xb@\N@ߤ?@j~#@Y}@}Vl@C-@W@U=@TɅ@/V@3@qu!@nO@@1&x@oiDg@M:@%2@ ѷ@4m9@|PH@xl"h	@qiB@j~"@g	k@b}Vm@TɅoi@QN;5@IQ@Em\@D*0@C$@?@4֡a@,q@#9@@ݗ+k@Mj@Fs@%2@@4n@.H@$t@PH@F]d@.2@g	@ۋq
@唯O
@S@҈p@ܑN;@c	@E@Ƨ@
L/@&IR@p
=@D@&x@/V@/V@/V@'@9@vȴ9@L_@S&@-
q@I^5?@p:@ݗ+@n/@n.@~($x@y"`@rs@h@d7@cZ@b}Vm@ceO@bM@be+@a|Q@`d8@be+@`
qu@W@NT@JL_@F?@@n@9~($@5'0@.2X@-w1@-
qv@*d7@%@4J@
	 @#@Fs@&I@_o@$/@nP@I^5@      @
PH@
G{@
F@
g@
8Y@
1.@
S@
r Ĝ@
ᰉ'R@
@
As@
˒:*@
7Kƨ@
H˒:@
<64@
Y}@
[W>6@
>B[@
6z@
n.3@
tj~@
#@
_o@
o h@
:S@
{~$@
{~$@
y"`@
w+@
n.2@
jJL@
g8}H@
cA [@
V8YJ@
QX@
JD@
C,zxl@
<n.@
43@
$/@
#n.3@
 -
@
6C@
hr @
Mj@
Mj@
'/W@
@
ߤ?@
Mj@
qi@
C%@
@	m]@	(@	rGE8@	!.@	s@	-V@	c	@	빌~($@	Ov`@	r Ĝ@	e@	>@	Z@	@	84֡@	74@	b@	~@	)@	Xy=@	33333@	'RT@	V@	TɅ@	'@	S&@	U=@	[@	qu!@	_o@	sh@	I^5?@	@4n@	|PH@	{~$@	|?@	}E@	}!.H@	|PH@	{m]@	u!R@	rs@	kP{@	g@	e`A7L@	be+@	a'R@	_o@	^@	]/w@	]/w@	\(\@	TɅoi@	R䎊@	Q_p@	L_@	E@	@n@	5'0@	,1&y@	)*0U2a@	&x@	&L/{J@	!o@	*0@	:)y@	xF]@	
	 @	u%F@	n/@~$@{m@C,z@e@ᰉ'R@ݗ+j@+@sPH@҈p:@Q@ǮzH@@@]cf@2W@@@쿱[@)y@Xy=@H@0
@TɅ@@
=p@[@u%@@O
M@hr @@@q@L/{@҈@q@=p
@#@@ݗ@S&@o hی@}H˒@yrGE8@u%F
L@sMjO@m\@e@aGz@`
qu@_?@Y>BZ@T,<@P*0U@H@G)^@HK]c@I@I@JL_@JL_@J#9@K)^	@L/{J#@H9Xb@*0
@%1@$TɆ@#wk@!R<6@ 'RT`@0
)@$tS@@qi@I^5?@{J#9@>B@(@!-w2@ ě@
=q@iDg8@4֡a@:~ @쿱[W?@빌~($@Dg8~@	ԕ+@%1@C,@|Q@
qu@"`B@`A7@@@?@@7Kƨ@@K]@K]@2W@1@$xG@@@Z@:)y@'/W@	 @'RTa@p:@ݗ@w1@r䎊q@mhr!@g8}H@cS@b}Vm@b@4@_;dZ@[q@Rm@L_@K]cA@JW'@H˒:*@D*0@D2W@A [7@<쿱[@7KƧ@49XbN@12W@-U=@($xG@䎊r@!-w1@}H@S@vȴ@_o@O;d@L_@Fs@)^@Mj@~($x@YJ@M:@@:S@($x@J#9@~$@hr@?@m]@J#9@-
@-V@	ԕ+@ڹ@@4@حV@$@حU@8YJ@l!-@҈p:@а{@̘_@ȴ9Xb@Ƨ-@,zxl@|hs@
(@j~#@dZ@#w@m8@W@1&y@/V@xF@-w1@C,zx@*0@zG@)^@'/W@_o@%2@:S@}E@x73@l"h	ԕ@ceO@`
qu@[6@W>6z@Xe+@ZY@["`B@[W>6z@\?@IoiD@ATɅo@:)_@4J@/{J#:@,q@)*0U2a@&x@$/@ 'RT`@:)y@Vu@
qu"@xF]@'/@	ԕ*@	 ѷ@K]d@_o@Q@:S@Q@!R@s@rGE@A [@
qu@ޞ@$@@fA@@т@@̘_@ΤT@:@@y@s@m\@2W@TɅo@BZc @p
=@dZ@S&@sg@-V@O
M@zG@U=@
qv@w1@w1@>B[@>B[@zxl"@/V@F
L0@TɆ@ae@vȴ9@쿱[W@%@쿱[W@,<@*0@@$/@qu"@eO@Fs@n/@@n.@}!.H@{~$@vFs@u!.@s@ql@o-V@mhr!@jJL@ffffff@dZ1@ae@a@N@_?@`u!@_?@[6@W>6z@T`d@N+@Ks@Gy@DS@As@=K]@9~($@8Q@6E@2a|Q@1-@.1@,q@)y@($xG@&IQ@$xF@!o@Q@1&@_F@@q@ݗ+@$/@?@u%F
@      @~$@+@%F
L@A [@C@䎊qj@|Q@
qu@W>6z@>BZ@>6z@,<@ӎMj@R@s@m\@s@@[W>@6z@vȴ9X@6z@ߤ?@BZc @Q@m\@w1@6z@RT`e@xF@o@%@ߤ@@6C@O;d@sh@O
M@@N@4J@4J@'RTa@?@IQ@b}V@~"@~($x@{lC@y=b@y=b@u!R@rGE85@p@kC]@jJL@jfB@jg	@jJL@h@fA@e@cA [@`A7K@]/w@\(\@[6@["`B@Zݘ@YJE@W&@Vt@P`A7@L_@JW'@H@Eo i@?[W>@:^5?|@2ᰊ@+U=@)y@)*0U2a@($xG@'-@'RT`e@&L/{J@)y@+a@@'RT`e@!.H@쿱[W@sh@bM@
(@ڹZ@>B@Y|@{m@iDg8@P{@ڹ@%1@e@ce@+@t@ҽ<64@т@;5X@˒:)z@@ǮzH@*0@n@ߤ?@j~#@)y@}H@}Vl@֡a@{@I^@TɅ@/V@u@IQ@@
=p@S&@h	ԕ@[6@Ov_خ@@@sh@hr @(@'/@	 @ݗ+@nP@˒:)@}!.H@v!.I@u\(@u\(@tSMj@p
=q@o-V@kC]@jJL@h@e`A7L@`d8@_Ft@]ce@ZY@T*1@S&@N+@IQ@F-@E84֡@Dg8}@B74@ATɅo@?@:)_@9#w@7Xe@5?|h@2m\@1&x@/O
M@*d7@'RT`e@$tSM@Q@@PH@*0@Ov_@tj~@bM@ߤ?@҈@	k~(@o h@F]c@ ѷX@.H@E@Q@(@(@-V@hr!@fB@r Ĝ@8}H@Z@ޞ@]ce@6@څݘ@ٳ|@bM@bM@t@fA@ҽ<64@`A7@˒:)z@ȴ9Xb@˒:*@ɺ^5?}@K]c@˒:*@@@m\@7Kƨ@6@[W>@<64@C-@ᰊ@U2a|@U=@B@q@U=@\)@&@TɆ@`A@ěT@u@1&@S@,<@u%F@@@vȴ@$tS@@R<6@sh@ݗ+k@u@-
q@(@qu"@q@ݗ+@nP@}E@}Vl!@}!.H@}!.H@|PH@x-
@u!.@v+jg@sE@nc	@j~"@g	k@d7@dqj@ceO@bC,@]cA @Xy=c@W&@W&@VϪ͟@UϪ͞@SMj@NT@L_@KƧ@I^5?}@G)^@D2W@C,zxl@@C@>vȴ9X@9#w@6z@49XbN@2-V@-U=@,zxl"@+jf@'&@&'@%u@#wk@䎊r@[@S@qu!@0
)@zG@N;6@Vu@
L/{@S&@F]c@{J#9@%2@@ IQ@hr@Vl!@s@hr@!R@GE85@oiDg8@O;@GE85@Q@Z1@ⶮ}Vm@҈p@
qu@҈p;@cA @ק&@ӎMj@T`d@`A7@Ϫ͞@ΤT@5Xy>@s@)^	@ɺ^5?}@]cf@NU@5Xy@Y}@}Vl@sg@E@3@m\@-V@2W@O
M@zG@V@d7@Xy=@
=p@.H@R<6@!-w1@Ov_خ@[@=K^@@O;d@Xe,@@Xe,@@Ov_@u@o @qi@ߤ?@M:@xF]@q@	 @@~"@~"@.H@.H@~$t@~($x@xF]d@u!.@u\(@v_ح@o hۋ@ix@gfA@f,<@d7@cA [@a'R@]cA @\]ce@Y>BZ@W>6z@TE@S@SMj@Q_p@N+@J#9@H˒:*@Fs@DS@B74@>
(@;/V@9~($@9#w@6C-@43@2ᰊ@0
(@.1@-w1@)y@(@'&@&IQ@#wk@IQ@vȴ@@@*0@O;d@@ᰉ@~($x@
L/{@	7KƧ@1&x@+I@o h@ ѷ@ $tS@ ($x@ ڹZ@ ($x@ $tS@ \N<@ PH@ "`@ kP@ !.@ GE85@ @ 쿱[W?@ ~"@ >BZc@ ڹ@ 䎊qj@ 	@ حV@ ҈p;@ ݗ+j@ b}@ >6z@ @ ҈p:@ R@ +@ jOv@ ˒:)z@ #9@ ǮzH@ m\@ g8}@ g8}@ 74@ 7Kƨ@ 6@ vȴ9X@ Z@ )_@ D@ #w@ XbM@ )@ 3@ }H@ Xe@ z@ Xy=@ ᰊ@ o@ {@ U2a|@ Vϫ@ B@ jf@ d7@ @ TɅ@ $xG@ &@ zxl"h@ TɆ@ /@ wkQ@ h	ԕ@ h	ԕ@ -V@ ߤ@@ vȴ@ @ Ov_@ zG@ *0U2@ )^@ ߤ?@ @ L_@ C%@ u%F@ o h@ @4n@ 4m9@ zxl"h
@ xl"h	@ u!R@ u%F
L@ t!-w2@ r ě@ p:~ @ l!-w@ kQ@ gfA@ d7@ c	@ `d8@ _Ft@ ^҈p;@ [q@ ZY@ ZQ_@ Y|@ Yb}@ Y+@ Y+@ Vaf@ Vt@ UϪ͞@ S&@ P*0U@ O;dZ@ O
M;@ M@ LcA \@ I@ F]cf@ E8YK@ E84֡@ C\N@ B@ B&IR@ As@ ?|hs@ =<64@ =p
=@ <Z@ <64@ 9XbM@ 6z@ 49XbN@ 0'RT@ .1@ /v@ .1@ .}Vl@ -U=@ ,zxl"@ +a@@ +a@@ +6z@ (TɅ@ '/V@ &'@ %1@ $xF@ u@ kP|@ 0
)@ zG@ bM@ qi@ 
@ @ 
qu"@ L_@ 
L/{@ 	ԕ*@ 	k~(@ o h@ %2@ @ @ nP@  ѷX?ڹZ?73?MjO?l?䎊q?䎊q?s?s?C]?(?hr!?JL?hr!?(?t?>BZc?,<?
qu??fA?,<?Ϫ͞?fA?䎊?͞%??)^?a@N?C?j~#?g	l?O
M? ě?>B[?Xy=?wkQ?-
?U=?IQ?wkP?҉?hr ?$tT?\(?~($x?	 ?YJ?Q???IQ?{m]?xF]d?w1?v_ح?qu!S?m\?j~"                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       @@:0U2a|@@:6C@@:3@@:3@@:3@@:6C@@:#9@@:&IR@@:&IR@@:&IR@@:0U2a|@@:0U2a|@@:-V@@:0U2a|@@:-V@@:)y@@:0U2a|@@:0U2a|@@:-V@@:0U2a|@@:3@@:-V@@:&IR@@:)y@@:)y@@:&IR@@:䎊@@:#9@@:)y@@:&IR@@:)y@@:)y@@:#9@@:&IR@@:-V@@:)y@@:)y@@:-V@@:&IR@@:)y@@:-V@@:)y@@:)y@@:&IR@@:)y@@:-V@@:&IR@@:&IR@@:&IR@@:#9@@:e+@@:&IR@@:)y@@:䎊@@:䎊@@:䎊@@:#9@@:䎊@@:䎊@@:#9@@:#9@@:䎊@@:&IR@@:#9@@:#9@@:#9@@:1'@@:䎊@@:䎊@@:䎊@@:1'@@:#9@@:Ov`@@:I^5@@:@@:I^5@@:	 @@9Y}@@:s@@:nO@@;s@@=}H@@?;dZ@@E*0@@ID@@L?@@N_ح@@O˒:)@@P˒:*@@Q@@Qs@@Rn@@RJL@@RwkQ@@R`A@@S"`B@@T<쿱@@U:@@UL_@@UjOv@@U`A7L@@U!R@@UVl!@@US@@Vqi@@Vx@@V($x@@X>BZc@@YB@@Y'RTa@@Y^5?}@@ZW'@@[Z@@^fffff@@cW>6z@@eM:@@f쿱[W@@i@@lL_@@n$t@@p$tT@@uM:@@wr@@zh	ԕ@@~'@@a|Q@@N;@@U=@@Fs@@)^@@-V@@x@@Z@@     @@@4n@@9@@@@1@@O
M@@s@@:)z@@4m@@}Vm@@Q@@@@2W@@RT`e@@ [7@@(@@M@@L/{@@\N@@8Y@@1&x@@6C@@PH@@zG@@/@@Vl!@@Ş%@@($x@@sPH@@r Ĝ@@lD@@{J#9@@zG@@5?|@@o@@Ұ ě@@	@@Ƨ@@?@@ռn/@@֍@@@@׊	@@y=c@@٭B@@Ov`@@G{@@ڳg	@@ڜwkQ@@ڳg	@@D@@ݗ+k@@?@@1&y@@s@@tj@@"h	ԕ@@9XbN@@j~#@@~($x@@ܕ*1@@ܞ쿱[@@ܿ[W?@@@@֡a@@@@hr@@>@@V@@qu"@@S&@@݁$/@@ݡ@@
qv@@E@@oiDg@@ڹ@@E@@z@@o@@ߚkP@@ߓݗ+@@߆&@@ߊ	@@߾vȴ9@@+@@6@@D*@@A7K@@'RT@@୫U@@ѷX@@@@@@0
)@@Dg8~@@^@@u!S@@|@@iB@@-@@u%F@@e+@@#9@@6C@@Q_@@a|Q@@u%F
@@kP|@@xl"h
@@ ě@@	@@)^	@@s@@PH@@9@@9@@@N@@jf@@*0U2@@S@@
=p@@,<@@Fs@@Fs@@g8}@@䎊qj@@N;@@쿱[@@D@@hr@@>@@V@@F
L0@@O;dZ@@sg@@p
=@@sg@@ڹZ@@唯O
@@唯O
@@
L/@@zG@@1.@@$t@@滘@@҈p;@@x@@)^@@|hs@@	k@@[W>@@r@@/V@@K]d@@˒:)@@حV@@@@A7K@@[6@@eO@@@@ۋq
@@	k@@#w@@o hی@@R<6@@X@@2W@@@@Y}@@	 @@-V@@d7@@꒣S&@@S&@@L/{@@ ě@@ ѷ@@&@@J#9@@J#9@@ݗ+k@@J@@\N@@"h	ԕ@@2W@@64@@?@@SMj@@cA \@@7@@+a@@}H@@@@@@n/@@?@@t@@zG@@?@@H@@R<6@@c	@@p:~@@+J@@-@@C-@@ hۋ@@x@@v@@eں@@ﴢ3@@F]d@@-
q@@@@@@rGE9@@*0@@eO@@-
@@@@4m@@ěT@@ۋq
@@\)@@	k~@@#w@@b}@@.H@@xl"h
@@0
@@`A@@~@@/V@@5Xy@@n.@@tj@@qj@@3@@zxl"@@7@@u@@F
L0@@\@@`A7L@@$/@@ݗ@@w1@@$/@@Ϫ͞@@zG@@8YJ@@fffff@@$t@@A@@]cf@@+I@@zH@@     @@@@*0U@@>BZc@@e+@@&x@@Dg8~@@n.@@.H@@qiC@@L/{@@qiC@@m\@@g	l@@@@q@@ߤ@@@@J@@Z1@@*1@@7@@֡a@@!-w@@K]@@*0@@?|h@@@@oiDg@@!R<@@c	@@IQ@@,<@@'@@҈p;@@Mj@@ hۋ@@
M;@@Xe@@!-w1@@;dZ@@KƧ@@_o@@y@@O;d@@o @A }H@A K]c@A _F@A ˒:*@A p:@A+@A=b@AN;5@Ak~(@An.@Ay@AlD@A@4n@AL_@A)_@AnP@A,zxl@A9@AZ@An.3@Atj~@Aq@AQ@A\N@Ag@An.@AL_@A(\@A/{J#@A64@A<쿱@A~($x@A@A:@A[@AS&@A%@AXy=@An/@A
(@A1.@A?@AVu@A}Vl@A-@Ax@A.H@AXe,@A4m@Ar@A-@A@A1&x@AbM@Ar Ĝ@AYJ@AIQ@A4֡b@A	@N@A	rGE@A	_p@A	7KƧ@A	^@A	u!S@A	X@A	ԕ*@A	lD@A
s@A
=p
@A
L_@A
 ě@A
,<@A
sP@A
m\@A)^	@AF]c@AxF]@AZ@AC]@AJ@A2W@AM:@AVϪ@A`d@A~($x@Aqj@A쿱[@A#x@A*0@Au"@A
K]@A
B@A
p
=@A
@A
?@A
(@A ѷY@A@A+jg@Ac	@Aqi@A,<@Aȴ9X@A1@A hۋ@A
=p@AXe@A'/W@A4֡a@AH˒:@AU=@AsPH@A-V@A@A@A@AH@AbM@AoiDg8@Ay=c@A˒:*@A-
@Ae+@A@N@A0
)@A^@Ab}@A@Au@A|@A^5?}@A_o@A-@Au%F@As@A)y@A0U2a|@AC\@A0
@AfB@As@AJ#9@AW>6z@Aa@N@An.3@A:)z@A*0U2@AE@AE@Aa@O@A5Xy@A҈@A2W@A`d@Aj~#@AzG@A?@Aqj@A쿱[@A@A#x@Aj~@A@Au"@AE@A/w@Aw1@A!R@A@A8YK@A!.@A@A1.@A\N<@A@A,<@AA@AC-@A쿱[W@AXe@A1@AH˒:@ART`e@Ao@A&@Aݗ+@AzH@Ar@A/V@Ao @A@A@A@ArG@A-@A#@A@A*0@AH@AXy=@Al"h	@AYJ@AU@A)@A)@A@@Aۋq
@A`A7@A\)@A	k~@A-w1@A7KƧ@A=b@ATɅo@Au!S@A@AB@Ao@Aᰉ'@As@Au%F@A0U2a|@AJL@A^5?|@AnO@A~"@A\(@A͞&@A'/@A33333@A@N@An.3@Aߤ@Aq@A6@Aa@@A|@AJ@Aߤ@@AL_@A/{J#@A9XbN@A9XbN@AVϪ@Aq@AC@ATɆ@A?@A>B[@AZ@A[@A(@A5Xy>@AB@AVl!@A\@Ace@Asg@Asg@AڹZ@AXy=@A-V@A-V@A8Y@A
qv@A ѷY@AzG@A$/@A1.@A8YJ@A;5X@AE@AVu@Ac	@Ap:~@Aqi@Aaf@A6z@A&I@AFs@A!.I@A,@A+I@A.H@A1@A;dZ@AlC@A&@A?@A˒:)@A@ArGE9@A @A  ě@A 'RT`@A 73@A 73@A A7K@A K]c@A oiDg8@A |@A |@A 'RT@A @A @A )@A )@A F@A PH@A!	k~@A!@N@A!#w@A!4J@A!TɅo@A!o hی@A!k~(@A!o hی@A!rGE8@A!b}@A!@A!o@A!ԕ*@A!ᰉ'@A!-@A!.H@A"n@A"@A"#9@A"0U2a|@A"=p
@A"W'@A"xl"h
@A"@4@A"ݘ@A"@4@A"@4@A"p:@A"p:@A"p:@A"\(@A"L_@A"wkQ@A"n@A"ڹY@A"G{@A"c	@A"74@A#s@A#33333@A#@N@A#F]c@A#J#9@A#dZ@A#$@A#@A#Q@A#%2@A#%2@A#%2@A#lC@A#lC@A#A [@A#@A$J@A$!-w2@A$%1@A$(\@A$(\@A$<쿱@A$M:@A$]ce@A$VϪ@A$m8@A$qj@A$zxl"@A$j~@A$/@A$>B[@A$@A$JM@A%'0@A%[@A%2a|@A%B@A%fA@A%ݗ@A%ڹZ@A%O
@A%%@A%-V@A%sh@A%\(@A%@A%(@A%C\@A& ѷY@A&4K@A&?@A&R<6@A&c	@A&}Vl@A&qi@A&af@A&]cf@A&C-@A&@A'@A'v@A'$tS@A''/W@A''/W@A''/W@A'1@A'1@A'8}H@A'H˒:@A'lC@A'v_ح@A'v_ح@A'|hs@A'	@A'	@A'ݗ+@A'-V@A'?@A'&@A'[W>@A'/V@A'حV@A'rGE9@A(6@A($xG@A(*0@A(A7K@A(NU@A(U2a|@A([6@A(hۋq@A(oiDg8@A(|@A(-
@A(-
@A(
=q@A(U@A(9Xb@A(4m@A()@A(p:@A({@A)rGE@A)#w@A)#w@A)#w@A)@A) [7@A)&x@A)*0U2a@A)=b@A)Gz@A)e+a@A)u!S@A)b}@A)oiD@A)@A)~($@A)@A)@A)R<6@A)'RTa@A)X@A)@A)@A)_o@A)>BZ@A)-@A*)y@A*@4n@A*M@A*T`d@A*W'@A*qiC@A*S&@A*>B@A*@A*n@A*W@A*`A@A*~@A+s@A+9@A+C%@A+MjO@A+Z@A+jf@A+qu!@A+@A+*0U2@A+*0U2@A+q@A+~($@A+a@O@A+@A+|@A+%2@A+g@A+s@A,L_@A,,<@A,9XbN@A,64@A,Fs@A,]ce@A,]ce@A,m8@A,tSM@A,o h@A,C@A,쿱[@A,zxl"@A,1&@A,#x@A,@A,7@A,֡a@A,u"@A,/@A,֡a@A,JM@A,!-w@A-K]@A-qu"@A-2a|@A-O;dZ@A-Vl!@A-fA@A-m\@A-M:@A-!R@A-O
@A-U=@A-@A-?@A-,=@A-ᰉ@A-(@A-!.@A-!.@A. ѷY@A-E@A-oiDg@A.t@A-C\@A. ѷY@A.
L/@A.+jg@A.;5X@A.?@A.c	@A.Fs@A.,<@A.ߤ?@A.ȴ9X@A.C-@A/)^@A/,@A/E84@A/E84@A/KƧ@A/KƧ@A/RT`e@A/\(@A/eں@A/b}V@A/sPH@A/sPH@A/O;d@A/$tS@A/kP@A/kP@A/kP@A//V@A/@A/vȴ9@A/fA@A/Vϫ@A/Vϫ@A/Vϫ@A0F]d@A0bM@A0*0U@A0$xG@A0-
q@A04m9@A01&x@A0A7K@A0K]c@A0Xy=@A0eO@A0oiDg8@A0n@A0-
@A0@A0d8@A09Xb@A04m@A0)@A0TɅ@A0ѷX@A0{@A1	k~@A1+@A1 [7@A1#w@A10
)@A1-w1@A10
)@A1Dg8~@A1XbM@A1ae@A1hr @A1u!S@A1~($@A1|@A1'R@A1@A12W@A1y@A1_o@A1"`@A1iB@A1e@A1s@A1-@A2u%F@A21'@A2&IR@A2)y@A2-V@A26C@A2a|Q@A2nO@A2u%F
@A2@4@A2{m@A2@4@A2@4@A2ᰊ@A2vȴ@A2@A2g	@A2n@A2͞&@A2͞&@A2,<@A2ڹY@A2fB@A2c	@A2m\@A3S&@A3u%@A3'/@A3	@A3&@A3/V@A36z@A3@N@A3Z@A3]cA@A3Mj@A3:)z@A3wk@A3E@A36@A3a@@A3ݗ+k@A3lC@A3g@A4tj@A4"h	ԕ@A464@A4Fs@A4SMj@A4tSM@A4C@A4N;@A4_@A4O
M@A4@A4#x@A4j~@A4[W?@A4Ʌoi@A5Q@A5(@A5<64@A5S&@A5jOv@A5fA@A5p
=@A5zxl"h@A5ڹZ@A5O
@A5U=@A5-V@A5@A5@A5Ϫ͞@A5b@A5S@A5(@A5!.@A5ڹ@A6
(@A6Ov_@A6zG@A64K@A6$/@A6.2@A6?@A6H@A6H@A6_ح@A6_ح@A6iB@A6p:~@A6z@A6z@A6IQ@A6+J@A6+J@A6Fs@A6O;@A6@A6@A6T@A6'@A6&I@A6@A6@A6A@A6ߤ?@A61@A6x@A61@A6쿱[W@A6Mj@A6@A6Fs@A6"@A6"@A7
M;@A7@A7)^@A7,@A7!-w1@A7+I@A7.H@A71@A7As@A7O
M@A7U=@A7b}V@A7y@A7|hs@A7y@A7{J#:@A7@A7O;d@A7$tS@A7?@A73@A7@A7fA@A7@A7rG@A7-@A7Vϫ@A7-@A7䎊r@A7+j@A7rGE9@A8     @A7rGE9@A8     @A8	ԕ+@A8bM@A8@A8*0@A84m9@A8A7K@A8H@A8U2a|@A8eO@A8oiDg8@A8y=c@A8|@A8-
@A8tj@A8u%F@A8-
@A8U@A8U@A8)@A8TɅ@A8@@A8p:@A8D@A8`A7@A9 ѷ@A9@N@A9@A9#w@A9&x@A94J@A9A [@A9XbM@A9^@A9hr @A9x@A97Kƨ@A9l@A9'R@A9'R@A9@A9D@A9N;6@A9ԕ*@A9"`@A9ᰉ'@A9s@A:I^5@A:Ov`@A:䎊@A:#9@A:䎊@A:#9@A:&IR@A:-V@A:-V@A:C\@A:M@A:W'@A:a|Q@A:u%F
@A:{m@A:~"@A:p:@A:0
@A:S&@A:g	@A:g	@A:Y@A:n@A:n@A:Y@A:`A@A:fB@A:C,@A:c	@A:m@A:m@A:74@A;I^@A;u%@A;'/@A;PH@A;	@A;)^	@A;33333@A;)^	@A;)^	@A;/V@A;9@A;=K^@A;@N@A;J#9@A;W>6z@A;Z@A;a@N@A;dZ@A;jf@A;n.3@A;qu!@A;jf@A;{J#9@A;Mj@A;$@A;*0U2@A;wk@A;m]@A;a@O@A;5Xy@A;lC@A;s@A<J@A<xF@A<ߤ@@A<xF@A<ߤ@@A<L_@A<ߤ@@A<@A<(\@A<2W@A<9XbN@A<SMj@A<`d@A<m8@A<S@A<TɆ@A<O
M@A<#x@A<7@A<Ʌoi@A<u"@A<u"@A<@A<>@A<E@A=V@A=qu"@A=qu"@A=%F
L@A=2a|@A=84֡@A=84֡@A=F
L0@A=IQ@A=S&@A=\@A=ce@A=p
=@A=m\@A=w1@A=M:@A=O
@A=Xy=@A=%@A=U=@A=-V@A=U=@A=sh@A=n/@A=H˒@A=n/@A=8Y@A=@A=b@A=(@A=oiDg@A=oiDg@A=C\@A> ѷY@A>4K@A>Ov_@A>.2@A>?@A>?@A>BZc @A>L/{J@A>YJ@A>_ح@A>iB@A>iB@A>s@A>s@A>%@A>%@A>@A>O;@A>-@A>6z@A>&I@A>A@A>Ϫ͟@A>]cf@A>]cf@A>C-@A>ߤ?@A>쿱[W@A>"@A>"@A?@A?
=p@A?
M;@A?v@A?,@A?$tS@A?+I@A?4֡a@A?RT`e@A?\(@A?eں@A?eں@A?iDg8@A?sPH@A?v_ح@A?|hs@A?&@A??@A?&@A?zH@A?[W>@A?3@A?r@A?/V@A?@A?K]d@A?@A?@A?@A?Vϫ@A?+j@A?rGE9@A@	ԕ+@A@*0U@A@*0U@A@@A@*0U@A@$xG@A@$xG@A@-
q@A@4m9@A@:~ @A@:~ @A@NU@A@Xy=@A@Xy=@A@NU@A@Xy=@A@Xy=@A@[6@A@bM@A@l"h	@A@r Ĝ@A@oiDg8@A@˒:*@A@-
@A@IQ@A@
=q@A@
=q@A@@A@U@A@{@A@
(@A@
(@A@TɅ@A@p:@A@p:@A@D@A@ۋq
@A@e+@A@e+@A@e+@A@4֡b@A@e+@A@4֡b@A@{@A@{@A@{@A@\)@AA ѷ@A@PH@AA@AA@AA_p@AA [7@AA-w1@AA:S@AA:S@AA:S@AA=b@AA=b@AAN;5@AATɅo@AATɅo@AA[W>6@AArGE8@AA|Q@AA~($@AA@AA~($@AAR<6@AAR<6@AAB@AA@AAy@AA@AAD@AA2W@AA_o@AAe@AA>BZ@AA>BZ@AA@AAY}@ABu%F@ABn@ABn@ABs@AB#9@AB3@AB:)y@AB@4n@ABM@ABQ_@ABW'@ABa|Q@ABd7@ABkP|@ABxl"h
@ABu%F
@ABݘ@ABL_@ABL_@ABᰊ@ABL/{@AB>B@ABY@AB@AB`A@ABsP@ABڹY@AB,<@ABG{@ABfB@ABm@ABc	@ABD@ABD@AC҉@AC'/@ACC,z@AC	@ACPH@AC,zxl@AC@N@ACC%@ACJ#9@ACP{@ACW>6z@ACa@N@ACqu!@ACxF]@AC~$@ACQ@ACQ@ACQ@ACq@ACq@ACq@AC$@ACU=@ACE@ACƧ@AC@AC
=p@ACa@@AC%2@AC҈@AC%2@AClC@AClC@ACC]@ACA [@ACs@ACs@AD1&y@ADtj@AD!-w2@ADQ@AD%1@AD%1@AD/{J#@AD2W@AD2W@AD<쿱@AD<쿱@AD?@AD?@AD?@ADC,zx@ADVϪ@AD]ce@ADcA \@AD]ce@ADcA \@ADm8@ADj~#@ADj~#@AD?@AD*1@AD*1@AD*1@AD*1@AD_@AD쿱[@AD1&@AD@AD?@AD@AD@AD֡a@AD>B[@ADu"@ADJM@ADJM@AD!-w@AE:@AEo i@AEK]@AE[@AE[@AEqu"@AEqu"@AEQ@AE(@AE84֡@AEB@AEIQ@AEL_@AES&@AE`A7L@AEfA@AEm\@AEm\@AEsg@AE}H@AEݗ@AE!R@AEO
@AE=K@AEXy=@AEU=@AEU=@AE@AE\(@AE8YK@AE@AEb@AE?@AEb@AE?@AES@AF ѷY@AFt@AFt@AF
(@AFzG@AFu@AFOv_@AF+jg@AF.2@AF1.@AF$/@AF.2@AF.2@AF5?|@AF?@AF?@AFBZc @AFR<6@AFYJ@AFc	@AFl!-@AFp:~@AFvȴ9X@AF}Vl@AFIQ@AF@AF,<@AF@AF6z@AF2X@AFQ@AFQ@AFQ@AFm\@AFȴ9X@AFA@AF+@AF]cf@AF1@AFx@AF1@AF@AFMj@AFFs@AF"@AG hۋ@AGFt@AG
M;@AG)^@AG
=p@AG)^@AGXe@AG)^@AGXe@AGv@AG!-w1@AG+I@AG'/W@AG'/W@AG.H@AG1@AG;dZ@AG>6z@AGAs@AGE84@AGE84@AGKƧ@AGH˒:@AGRT`e@AG_o@AGU=@AG_o@AGeں@AGiDg8@AGv_ح@AGo@AGv_ح@AG4m@AG{J#:@AG	@AG	@AG@AGkP@AG?@AG?@AG&@AG[W>@AGvȴ9@AGo @AG+@AG;dZ@AG@@AG䎊r@AGrG@AG-@AG+j@AG#@AH
qu@AH
qu@AH6@AH ě@AH*0@AH-
q@AH4m9@AH4m9@AH>BZc@AHA7K@AHD*@AHD*@AHD*@AHH@AHK]c@AHQ@AHXy=@AHXy=@AH_F@AHl"h	@AHoiDg8@AHu!@AH|@AHu!@AHn@AH'RT@AHtj@AH'RT@AH-
@AH@AHu%F@AH@AH
=q@AHU@AH@AHd8@AHU@AH4m@AHěT@AHp:@AHۋq
@AHe+@AHۋq
@AHD@AHۋq
@AHۋq
@AH`A7@AH@AH`A7@AH4֡b@AH{@AH{@AHPH@AHPH@AH$tT@AI+@AI&x@AI*0U2a@AI7KƧ@AI=b@AIGz@AIN;5@AIN;5@AIGz@AIN;5@AITɅo@AITɅo@AIXbM@AIae@AIhr @AIk~(@AIk~(@AIo hی@AIx@AIx@AI@AIoiD@AI~($@AIR<6@AI@AI@AI~($@AI'RTa@AI@AIR<6@AI'RTa@AIu@AIu@AI'RTa@AI'RTa@AI'RTa@AI'R@AI^5?}@AI@AI2W@AI_o@AIy@AIo@AI_o@AIԕ*@AIԕ*@AIiB@AIe@AIR@AI-@AIlD@AJn@AJI^5@AJ	 @AJe+@AJOv`@AJe+@AJ1'@AJ#9@AJ-V@AJ3@AJ0U2a|@AJ6C@AJ6C@AJ:)y@AJC\@AJGE85@AJ=p
@AJGE85@AJJL@AJQ_@AJW'@AJ^5?|@AJW'@AJa|Q@AJnO@AJkP|                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       @q@r      @qfffff@q     @q33333@q@qfffff@r      @q33333@r      @r@r     @q33333@r33333@q@r      @qfffff@r      @r      @qfffff@q@q@q33333@q     @q33333@qfffff@q33333@q33333@q     @q33333@q@q33333@q@q@q33333@q@q陙@q@q33333@q33333@r33333@q@q@q@r33333@q@r@r      @r      @q@q@qfffff@q@qfffff@r33333@qfffff@r      @q33333@q@q33333@q@r33333@rfffff@q@q33333@q     @r      @q@r33333@qfffff@r      @qfffff@q     @q33333@q     @q񙙙@qᙙ@q@q33333@q     @qt@p33333@p@q33333@qNfffff@q33333@q33333@q@qfffff@q@q@q@qfffff@q|@q     @r#33333@rfffff@q33333@q     @r@r$@q@q@q     @q33333@qfffff@r33333@r@qfffff@q@r@qٙ@q@qfffff@q33333@q@qfffff@qfffff@pfffff@p33333@pٙ@p@q33333@q!@pX     @p\@p0     @p33333@p!@pY@p;33333@n@n33333@n     @nfffff@n33333@o#33333@o33333@n     @mfffff@ml@mfffff@m     @mə@ms33333@lP     @l,@l,@l@lfffff@lfffff@k33333@kS33333@k0     @k@kFfffff@k0     @kI@j@jfffff@j@j33333@j     @jfffff@ifffff@iS33333@i,@i@hfffff@i&fffff@h     @h@h     @hfffff@hI@g@g33333@gvfffff@gP     @g     @g`     @gvfffff@g33333@g33333@g33333@fٙ@g	@g      @gfffff@g     @f@f     @f@f33333@f33333@f@fy@f@fp     @fi@f\@fP     @fI@fFfffff@eə@e     @efffff@e     @efffff@e@e33333@e@d@d@d33333@dfffff@dfffff@dI@d@c@c@cə@cfffff@cٙ@d      @cٙ@cl@cC33333@c&fffff@c     @b33333@bə@b     @b33333@b@b@b     @bfffff@bl@bI@b&fffff@a33333@a@a@a     @a     @a@a@ai@aFfffff@a33333@`33333@`33333@`@`     @`@`     @`fffff@`333333@`@`	@`33333@_@`#33333@`      @`333333@_S33333@_S33333@_@_S33333@_@_33333@_33333@_&fffff@^,@^&fffff@^@^y@^33333@]33333@]l@]33333@\@\fffff@\     @\fffff@\fffff@\     @\`     @\,@[33333@[     @[@[33333@[     @[33333@\&fffff@Zs33333@Z      @Z&fffff@Yfffff@Z@Yٙ@Z      @Yfffff@Zffffff@Y      @X     @Xٙ@Xfffff@Xfffff@Xfffff@X@X@Y33333@W33333@W     @Wy@W@     @W@W`     @Wfffff@W@W     @V33333@VY@Vy@V33333@V      @V      @V@V9@VS33333@U33333@Ufffff@U33333@U@Ufffff@U33333@U@U     @Ufffff@UY@U@Tfffff@T@T33333@T     @Tfffff@T@UY@T33333@Tffffff@Tffffff@Tffffff@T33333@TL@TS33333@TY@TL@TFfffff@S33333@T      @Sfffff@S@S33333@Sl@S33333@Ss33333@Sfffff@S`     @S33333@SY@R@R33333@R33333@S9@Rfffff@S      @S@Sfffff@R33333@R@Ry@Rl@RY@RFfffff@R33333@R@Ry@R9@Q@Q@Q     @Qfffff@Q33333@QS33333@QY@Qfffff@Q33333@P     @Qfffff@P33333@P@Ps33333@P     @P@Py@P,@Pfffff@Pffffff@OY@P@O@Os33333@Offfff@P      @Offfff@Nٙ@Nfffff@Nfffff@Ns33333@Nfffff@N@NY@NL@N     @N333333@N@     @Mfffff@M     @Mfffff@N333333@M@M     @Mfffff@Mffffff@M333333@M      @M@L@Lfffff@Lffffff@Ls33333@LY@LL@L@Kٙ@K@Kfffff@Ks33333@Ks33333@J33333@J33333@K@J@Jfffff@J     @K&fffff@Jffffff@J333333@J333333@Js33333@J@J@J     @J@J@Js33333@I     @I     @IL@I@I      @I&fffff@H     @H33333@HY@Hfffff@HY@HY@H@     @Gfffff@H@     @G33333@G@     @G33333@F@Gs33333@G@G@GY@G      @Ffffff@Fffffff@F@Fffffff@Efffff@F@E     @F33333@E33333@FY@E@F&fffff@E     @EL@E@D33333@E      @Effffff@Dffffff@E     @D@D33333@D@D      @DY@C33333@D     @D      @D@C@D333333@D@C33333@D@C@C@C@Cffffff@C333333@C@Bfffff@Cfffff@C      @Cffffff@C@Bfffff@B@     @Bٙ@Bfffff@C&fffff@B@Bfffff@Bٙ@B33333@B@     @B@     @Bs33333@B333333@B@B      @A@Afffff@A33333@A33333@As33333@Afffff@A@A&fffff@AL@@L@A@@ٙ@@33333@A@A333333@A@A      @@fffff@A      @@ٙ@A@     @@     @@L@@33333@@L@@333333@@ffffff@@L@@@?fffff@@s33333@?@@Y@@&fffff@?     @@@?fffff@?@?@?fffff@?33333@?333333@@@>@?333333@?333333@>fffff@>@?      @>333333@>@>L@>@=@=fffff@=@=33333@<33333@=fffff@>333333@=fffff@<@=33333@<@<@=@=L@=L@<L@<ffffff@<@<@<@<     @<@;@<@;fffff@<ffffff@<333333@<@<@;@;@;ffffff@:ffffff@;fffff@;fffff@;      @;@;fffff@;      @;@:@;ffffff@;fffff@;@;@:fffff@;@:@;L@:L@;333333@;L@:L@:fffff@:33333@:fffff@933333@:@:     @9ffffff@9@:ffffff@9fffff@8L@9@8@:      @7fffff@:333333@9L@8fffff@7@9L@8@9      @7L@833333@8@8     @8@7@8@7@8L@733333@8L@733333@7L@7@8333333@8333333@6@8@7L@7@7@7@7ffffff@7     @7@7ffffff@7333333@7     @6@7@5@7L@6fffff@7L@7L@6fffff@6@7@7      @533333@533333@7ffffff@5fffff@633333@6L@633333@6     @533333@8fffff@433333@6333333@6     @5     @6@5fffff@6333333@6L@6L@6L@6L@533333@7L@4@6      @5@5     @5@6L@6L@5L@4L@6ffffff@5ffffff@5@5ffffff@5@6      @5@5@6L@5L@6333333@7@6      @5@5L@6fffff@5ffffff@6      @5L@5fffff@5fffff@5@5fffff@5@433333@6333333@533333@433333@5fffff@5L@533333@5@4@5     @3ffffff@4fffff@6@433333@4fffff@5L@5L@5L@5L@5L@5L@533333@5      @5     @4fffff@6333333@4@4     @4fffff@5@333333@5fffff@4@5ffffff@5L@5@4@4@3fffff@4@6@3fffff@5ffffff@4     @4@4fffff@4@4fffff@4fffff@4fffff@4ffffff@4     @5@4fffff@5      @4@5     @4@5@5@5      @4@5@4fffff@4333333@4@5      @4@333333@5ffffff@3@5333333@2@4     @5ffffff@3@4      @4@3@4@4333333@3fffff@3      @1@4@3@4@3fffff@4L@4ffffff@4     @2ffffff@3fffff@333333@3@2@4@3L@2fffff@3@3L@3      @2ffffff@4333333@3@3      @2@333333@3@3ffffff@3ffffff@3ffffff@3ffffff@3ffffff@3333333@3fffff@3      @233333@3ffffff@233333@3333333@3333333@3333333@3333333@2@3     @233333@2@3@2L@2L@3@2     @2     @2fffff@3ffffff@2L@2fffff@2fffff@233333@2ffffff@3      @2L@2@133333@233333@3L@1333333@3      @3@2@2ffffff@2333333@2@2@1     @0L@1     @2      @2@1     @2     @1L@/@1fffff@1fffff@1fffff@1fffff@1fffff@1L@0@2      @1     @1      @1fffff@0@1333333@1      @1@1L@1L@1L@.@1@0ffffff@1@033333@0ffffff@0L@.333333@0fffff@0     @0@0     @,@0fffff@0     @0@.ffffff@1      @0      @0      @0333333@/@-@/      @-@/@/@/ffffff@-ffffff@/333333@0     @0fffff@0333333@/      @0@/@0@-ffffff@/@/@.ffffff@.@.@,@-ffffff@,ffffff@.@,      @-333333@033333@-      @,      @-333333@.ffffff@'@.@-      @,ffffff@/333333@-ffffff@-@.ffffff@-@,@-@-@-@.333333@,@0L@.      @-@-333333@/      @-@0@0      @0L@/      @.ffffff@0     @0@0@/@/ffffff@/@/@0L@/333333@/@/@.@0333333@/      @/@/@/@/@/@/@/@/@/@/333333@0@,      @0ffffff@-@/      @/333333@.@/@-      @/333333@/333333@/333333@/333333@-@,ffffff@0L@-      @/      @-ffffff@-      @.ffffff@-@-@.@-@-ffffff@.@.      @.      @.      @/333333@.333333@.@-@/333333@-333333@-@/333333@-@.333333@.333333@.@-@/      @.333333@)333333@.ffffff@,      @-@+ffffff@/@,@/      @-333333@+ffffff@(@-@+@-@-@.333333@1      @/@,333333@,@,@-333333@+@.333333@*@(@+@,      @+      @,@+333333@+ffffff@)ffffff@,@+333333@/      @*      @-@)@,ffffff@,ffffff@*@*      @/ffffff@,ffffff@*@+@,ffffff@,      @,      @-@.333333@,      @0333333@-      @,333333@+ffffff@/      @*@-@,@+ffffff@.@-333333@+ffffff@.ffffff@.      @'@*@.@,333333@-      @-ffffff@/333333@-333333@,@*@0@*@1     @*@.@+ffffff@-333333@/@+@-333333@/      @-@*@.@,ffffff@,ffffff@-      @-@,      @-      @-@-      @.      @-      @-@-333333@+333333@-@-@,@,@-333333@-333333@.333333@-ffffff@.333333@-ffffff@.ffffff@-333333@.      @0      @,      @/      @.      @0333333@.@-333333@/      @-@.ffffff@.ffffff@.ffffff@.ffffff@-ffffff@/333333@.ffffff@.ffffff@.ffffff@.ffffff@.ffffff@.ffffff@.ffffff@.ffffff@.ffffff@.ffffff@.ffffff@.@.@.@.@.@-@/      @.@.@.      @/333333@.@.@.@.@.@.@.ffffff@.@.@.@.@.@.@.@.@.@.@.@.@.@1fffff@.ffffff@0      @-@0@,@/333333@0fffff@.333333@,333333@0ffffff@0      @/ffffff@/@/333333@/333333@/ffffff@0     @/@/333333@133333@.      @.@0@0      @0@0      @/@0@0      @0      @/@033333@/@0@/@2@0@0ffffff@0      @0@1@0     @/@1@2L@0@0      @0fffff@0     @033333@033333@1ffffff@/@0fffff@1     @1L@/ffffff@0fffff@1L@/@1     @1ffffff@/@1@0@0@0@1@1L@1@1fffff@1@1@2      @1     @1@1333333@2ffffff@1@2333333@2333333@2ffffff@1fffff@3@2@133333@2ffffff@2@2     @2@2333333@2333333@2333333@2ffffff@1fffff@0     @3     @4@-@4@2L@2@3333333@3333333@2L@333333@2fffff@2@3ffffff@2@3fffff@3L@5      @1@2@4@3333333@2fffff@2333333@3@3@5L@1L@4333333@4      @3ffffff@5     @2@1@5ffffff@433333@3fffff@4     @4@4L@4      @4ffffff@4@5333333@4L@4L@4L@4L@5@4ffffff@5fffff@5@5      @5333333@5333333@433333@5      @5333333@5fffff@5@6fffff@6fffff@3fffff@7@5@633333@6@6fffff@5333333@7      @6@6ffffff@6@7      @6@6ffffff@7     @7333333@6333333@633333@7     @6@7@6ffffff@6@7@7@7     @7333333@7@7     @7@8     @5@8333333@8     @6fffff@7ffffff@8@7@9@7333333@8@8@7@7@8@733333@8ffffff@8@7fffff@9      @:L@8@8L@8@7@9333333@8fffff@9333333@8     @9fffff@:      @8      @9L@8     @9L@9@9fffff@8fffff@9fffff@9@:ffffff@9fffff@933333@9@9fffff@:ffffff@9ffffff@;@9L@:     @9fffff@9fffff@<     @:fffff@:     @:      @:33333@:     @:@:@<fffff@9@;333333@:     @:33333@;      @:@;      @;L@<333333@:fffff@:@;333333@;@;33333@;L@;ffffff@<333333@;@;     @;fffff@<L@<     @<@;@;333333@;@=33333@<     @=@=@>333333@:fffff@=ffffff@>333333@<@=L@<@<@<@<@<@<@<333333@=fffff@=33333@>ffffff@>      @=33333@=@@@?@=333333@?@>333333@?ffffff@=     @>33333@>L@?      @>L@>L@?@?ffffff@?@?L@>33333@>     @>333333@?     @?fffff@?@?@?     @?@<33333@?ffffff@?@?33333@?     @@     @@@?fffff@?fffff@@L@@@@@@333333@@@@@@333333@@@@Y@@L@@@@L@?@@33333@@ffffff@@@     @@333333@@@@33333@@33333@@33333@@@@@@     @AY      @A@@ffffff@@ٙ@B@@@Affffff@@fffff@@fffff@Affffff@A@     @A333333@Affffff@A      @B@As33333@AY@A@Aٙ@Affffff@Affffff@B      @B@A     @Afffff@Afffff@Afffff@B      @B     @A@     @Bffffff@B@A33333@A&fffff@C@A@B33333@Afffff@Bs33333@B     @B@B33333@BY@Bffffff@Bfffff@Bfffff@BY@D      @A33333@C@     @C@B@B33333@C     @C&fffff@Bٙ@Bٙ@C@B@Cffffff@C     @C@C333333@C@B33333@C33333@CL@C@D      @Cffffff@D@DY@C@     @D&fffff@D@C@C@Cٙ@DY@D@C@DL@D@     @D&fffff@C33333@Dfffff@Cs33333@D@     @E      @D@D333333@D333333@D333333@D@D@D@     @D     @Dffffff@Ds33333@D@D33333@D333333@Dffffff@Ds33333@D     @D     @D@E@Dfffff@Dfffff@Dٙ@E333333@Dٙ@Dfffff@Dٙ@D@EL@D     @Dٙ@E@D@E@     @Efffff@E&fffff@Dfffff@Eٙ@EL@E33333@E&fffff@E&fffff@E33333@D@Fٙ@E      @Eٙ@F&fffff@E@Efffff@E@F333333@Eٙ@F333333@E33333@Fٙ@E     @F@F@F33333@F@F&fffff@F33333@F@     @F     @Fs33333@F@     @FL@F33333@E33333@F@Ffffff@Fٙ@Eٙ@FY@F     @FL@G@Ffffff@F@F33333@F33333@Fٙ@G&fffff@F@Gٙ@Ffffff@G      @F33333@G@GL@G333333@G@G@GY@G      @G     @G@     @G333333@HL@G@     @GL@GL@G33333@Gffffff@HY@Gs33333@G@     @H&fffff@Gs33333@G@Gٙ@H333333@G     @I333333@H@G33333@H     @Gٙ@Gٙ@Hfffff@G@H@     @H     @Hٙ@G@I      @H     @H333333@I@     @HY@Hs33333@I&fffff@H@     @H@IY@H@IY@HY@H     @I@H&fffff@H@H33333@Hٙ@H33333@Hٙ@H@Iٙ@Hfffff@I      @Hfffff@Hfffff@Hfffff@Iٙ@I@Jffffff@I@I@Ifffff@HY@I33333@Iٙ@IY@Jfffff@IY@Js33333@Jٙ@I@     @Is33333@J@     @J&fffff@J&fffff@I33333@I33333@K333333@J&fffff@J&fffff@Ifffff@J      @I     @J@JL@J@Ifffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       ?zG?1&x?-V?O;dZ?bM?n?bM?dZ1?~"?+I^?O;dZ?vȴ??S?j~"?l?tj?nP?bM?nO;?      ?A7Kƨ? ěT?$/?I^5?nO?XbM?E?zG?KƧ?O;dZ?nO?lC?1&?l?x?+?1&y?j~#?`A7?C%?^5?|? ěT?xF?tj~?^5?|?KƧ?+I^??
=p?
=p?1&?Vt?Vt?ȴ9Xb?x?$/?;dZ?~"?Vt?$/?vȴ?zG?vȴ9?$/?Vu?vȴ?p
=q?-V?zG?$/???|hs?\(?l?vȴ?hr ?ěS?\(?`A7K?Ƨ-?x?Q?"`B?ěS?$/?;dZ?Vu?|hr?(\)?333333?xF?/v?1&?=p
=?1&?E?̬1&y?E?n?Q?Q?GzH?Q?šo?šo?E?lC?lC?^5?|?lC?lC?E?^5?|?vȴ9?Gz?lC?dZ1?vȴ9??lC?XbM?+?tj~?E?j~#?QR?XbM?bM?O;dZ?+I?+?lC?1&?QR?lC?+?$/?bM?KƧ?j~#?+?ȴ9Xb??|hs?ȴ9Xb?^5?|?\(?+J?lC?^5?|?\(?bM?
=p
?tj?"`B?+?"`B?+?+?O;dZ?KƧ?O;dZ?KƧ?tj~?lC?lC?p
=q?tj~?ȴ9Xb?S?+?tj~?"`B?+J?S?XbM?"`A?XbM?lC?E?+?lC?"`A?E?lC?"`A?+?E?S?"`A?dZ1?lC?lC?vȴ9?tj~?lC?E?lC?lC?S?+J?lC?lC?^5?|??QR?lC?S?lC?Gz?+?bM?lC?lC?S?+?QR?+??lC?lC?lC?lC?lC?lC?/v?"`B?^5?|?lC?lC?lC?-V?lC?1&y?lC?S?-V?1&?j~"?lC?lC?lC?S?(\)?-V?lC?lC?lC?Q?vȴ9?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?vȴ9?QR??lC?-V?lC?lC?lC?lC?lC?lC?lC?/v?lC?lC?lC?lC?lC?lC?/v?      ?lC?lC?1&y?vȴ9X???lC?lC?-V?vȴ9?+J?-V?      ?-V?lC?Q?lC?lC?lC?lC?lC?lC?lC?lC?lC?dZ1?QR?lC?lC?lC?+J?lC?lC?E?j~"?lC?lC?|hr?/v?1&y?lC?lC?/v?/v?lC?(\)?p
=q?lC?p
=q?-V?lC?lC?-V?lC?/v?/v?lC?lC?-V?Q?vȴ9X?/v?`A7L?lC?p
=q?(\)?lC?5?|h?      ?5?|h?lC?lC?lC?lC?lC?p
=q?E?lC?lC?lC?lC?lC?lC?lC?lC?j~"?-V?lC?lC?lC?bM?Gz?lC?lC?|hr?E?j~"?p
=q?lC?j~"?-V?"`?lC?lC?1&?j~"?;dZ?lC?lC?lC?lC?-V?lC?lC?lC?Q?lC?(\)?|hr?lC?lC?lC?lC?lC?lC?lC?vȴ9X?1&y?lC?lC?lC?p
=q?lC?lC?lC?bM?/v?hr!?p
=q?lC?1&y?j~"?"`?1&y?p
=q?lC?vȴ9X?lC?lC?lC?lC?lC?vȴ9X?E?1&y?-V?p
=q?lC?;dZ?5?|h?lC?lC?(\)?p
=q?lC?lC?Q?lC?lC?/v?-V?lC?lC?/v?      ?      ?vȴ9X?/v?/v?E?(\)?5?|h?n?;dZ?lC?lC?lC?lC?lC?vȴ9X?lC?lC?&x?1&y?lC?lC?lC?|hr?"`?;dZ?lC?/v?Q?hr!?vȴ9X?lC?lC?/v?hr!?lC?lC?lC?lC?lC?lC?vȴ9X?-V?lC?lC?lC?lC?(\)?E?p
=q?lC?(\)?p
=q?lC?lC?p
=q?lC?lC?lC?vȴ9X?j~"?lC?lC?lC?lC?-V?j~"?lC?5?|h?E?lC?lC?lC?lC?      ?5?|h?-V?/v?"`?(\)?lC?-V?vȴ9X?E?1&y?Q?/v?j~"?/v?hr!?hr!?lC?/v?hr!?(\)?5?|h?/v?vȴ9X?"`?E?/v?5?|h?      ?      ?lC?p
=q?hr!?lC?lC?lC?/v?5?|h?5?|h?j~"?      ?j~"?p
=q?E?"`?-V?j~"?lC?"`?      ?      ?/v?j~"?/v?hr!?-V?vȴ9X?lC?p
=q?/v?lC?-V?lC?lC?;dZ?lC?Q?      ?      ?      ?"`?lC?;dZ?(\)?Q?lC?/v?j~"?lC?/v?lC?vȴ9X?(\)?lC?lC?(\)?      ?Q?p
=q?p
=q?E?lC?(\)?vȴ9X?lC?vȴ9X?j~"?vȴ9X?5?|h?/v?      ?1&y?lC?/v?;dZ?lC?Q?lC?Q?-V?lC?p
=q?5?|h?1&y?;dZ?lC?vȴ9X?lC?Q?lC?lC?lC?lC?lC?Q?lC?lC?/v?      ?      ?lC?E?5?|h?p
=q?|hr?lC?"`?;dZ?lC?lC?lC?lC?lC?      ?      ?-V?5?|h?/v?p
=q?p
=q?p
=q?      ?GzH?hr!?lC?lC?lC?lC?1&y?p
=q?p
=q?"`?(\)?Q?lC?lC?lC?Q?      ?j~"?5?|h?(\)?      ?j~"?"`?(\)?      ?lC?lC?lC?lC?E?(\)?|hr?hr!?lC?lC?lC?lC?lC?vȴ9X?j~"?lC?Q?lC?lC?-V?hr!?lC?lC?lC?lC?vȴ9X?1&y?hr!?      ?lC?lC?A7Kƨ?-V?-V?5?|h?E?lC?lC?"`?Q?lC?lC?lC?lC?|hr?lC?E?lC?vȴ9X?      ?-V?lC?lC?(\)?;dZ?lC?E?      ?-V?5?|h?-V?"`?"`?"`?vȴ9X?lC?      ?      ?      ?lC?lC?lC?lC?vȴ9X?      ?vȴ9X?lC?      ?(\)?vȴ9X?      ?      ?GzH?      ?lC?lC?E?p
=q?-V?Q?E?E?-V?p
=q?"`?lC?/v?;dZ?lC?5?|h?lC?(\)?p
=q?      ?E?p
=q?      ?-V?Q?vȴ9X?j~"?lC?-V?|hr?lC?/v?      ?lC?&x?/v?lC?vȴ9X?      ?;dZ?lC?p
=q?/v?lC?lC?lC?lC?lC?lC?lC?lC?E?      ?      ?hr!?"`?lC?lC?-V?      ?hr!?GzH?E?ěS?      ?1&y?lC?lC?5?|h?j~"?E?lC?lC?lC?lC?vȴ9X?      ?/v?hr!?/v?vȴ9X?E?vȴ9X?E?nP?/v?hr!?/v?1&y?&x?lC?lC?lC?hr!?;dZ?lC?hr!?lC?lC?p
=q?p
=q?lC?lC?5?|h?;dZ?(\)?j~"?GzH?      ?lC?5?|h?-V?GzH?      ?      ?      ?      ?      ?      ?E?lC?lC?lC?lC?Q?1&y?lC?lC?lC?(\)?|hr?lC?/v?;dZ?lC?lC? ěT?;dZ?lC?/v?"`?lC?|hr?      ?      ?-V?      ?E?lC?E?lC?lC?lC?p
=q?5?|h?lC?lC?lC?lC?hr!?-V?lC?lC?vȴ9X?lC?-V?E?lC?lC?-V?Q?-V?nP?lC?Q?      ?      ?      ?(\)?-V?"`?5?|h?      ?      ?p
=q?      ?;dZ?lC?lC?lC?lC?5?|h?E?5?|h?/v?      ?      ?bM?n?lC?j~"?      ?1&y?1&y?"`?lC?lC?      ?-V?"`?      ?5?|h?lC?1&y?5?|h?lC?Q?p
=q?E?lC?lC?"`?lC?&x?      ?      ?hr!?Q?hr!?"`?lC?      ?      ?vȴ9X?lC?lC?vȴ9X?      ?Q?lC?-V?      ?lC?      ?j~"?lC?lC?vȴ9X?vȴ9X?Q?1&y?/v?1&y?vȴ9X?      ?vȴ9X?lC?lC?lC?-V?lC?lC?lC?p
=q?lC?p
=q?      ?      ?      ?"`?lC?lC?lC?1&y?      ?E?-V?vȴ9X?lC?p
=q?1&y?p
=q?GzH?hr!?7KƧ?|hr?lC?E?|hr?lC?      ?vȴ9X?lC?lC?;dZ?      ?      ?      ?E?lC?lC?"`?E?lC?lC?j~"?      ?(\)?lC?lC?lC?lC?lC?lC?|hr?      ?|hr?lC?lC?lC?lC?/v?E?lC?      ?      ?      ?-V?lC?lC?      ?-V?      ?lC?"`?hr!?      ?      ?(\)?lC?vȴ9X?5?|h?      ?1&y?-V?5?|h?lC?/v?/v?vȴ9X?lC?lC?      ?(\)?lC?lC?Q?lC?lC?lC?/v?      ?      ?/v?      ?E?      ?vȴ9X?E?(\)?E?;dZ?lC?lC?j~"?5?|h?lC?(\)?      ?p
=q?      ?lC?lC?      ?      ?p
=q?lC?-V?      ?      ?"`?/v?      ?|hr?lC?"`?      ?      ?      ?GzH?A7Kƨ?      ?lC?lC?      ?hr!?E?      ?p
=q?1&y?/v?Q?lC?Q?5?|h?p
=q?lC?lC?lC?E?E?/v?1&y?E?-V?j~"?p
=q?lC?ěS?lC?-V?      ?      ?      ?(\)?lC?      ?E?|hr?XbM?      ?      ?-V?lC?Q?lC?(\)?      ?n?hr!?lC?E?vȴ9X?p
=q?|hr?-V?-V?-V?/v?"`?lC?1&y?1&y?/v?E?lC?5?|h?/v?5?|h?|hr?lC?hr!?5?|h?lC?lC?lC?5?|h?1&y?lC?5?|h?bM?lC?lC?      ?1&y?;dZ?      ?lC?lC?Q?1&y?      ?      ?/v?Q?lC?hr!?-V?j~"?-V?lC?1&y?-V?lC?hr!?E?1&y?j~"?E?lC?lC?lC?lC?lC?lC?lC?lC? ěT?ěS?lC?Q?&x?p
=q?lC?hr!?      ?;dZ?hr!?"`?(\)?vȴ9X?/v?vȴ9X?p
=q?j~"?      ?      ?-V?lC?Q?lC?5?|h?lC?E?;dZ?lC?lC?lC?p
=q?j~"?/v?/v?lC?"`?      ?"`?-V?lC?lC?      ?-V?/v?lC?lC?hr!?vȴ9X?lC?E?lC?lC?lC?lC?      ?j~"?lC?lC?lC?"`?      ?(\)?lC?-V?lC?lC?;dZ?      ?p
=q?lC?lC?5?|h?p
=q?lC?lC?lC?p
=q?-V?lC?lC?lC?lC?5?|h?E?lC?lC?lC?lC?lC?5?|h?(\)?vȴ9X?lC?lC?E?      ?5?|h?/v?"`?lC?lC?"`?E?p
=q?hr!?E?;dZ?lC?      ?hr!?nP?-V?lC?lC?      ?"`?lC?vȴ9X?|hr?lC?lC?5?|h?lC?E?lC?lC?lC?5?|h?1&y?-V?1&y?-V?lC?E?lC?5?|h?vȴ9X?lC?lC?lC?j~"?1&y?E?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?E?hr!?p
=q?lC?hr!?lD?E?lC?lC?lC?lC?;dZ?;dZ?lC?lC?lC?p
=q?-V?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?-V?hr!?1&y?lC?"`?/v?lC?lC?lC?p
=q?1&y?S?dZ1?lC?lC?lC?5?|h?lC?|hr?lC?lC?lC?lC?-V?vȴ9X??S?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?(\)?"`?lC?lC?lC?lC?lC?lC?lC?lC?lC?/v?      ?-V?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?/v?lC?lC?lC?lC?lC?hr!?hr!?lC?E?lC?-V?lC?lC?-V?/v?lC?lC?E?vȴ9X?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?p
=q?p
=q?S?(\)?hr!?(\)?vȴ9X?p
=q?lC?lC?lC?vȴ9X?(\)?lC?/v?j~"?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?      ?-V??lC?lC?lC?"`?lC?lC?"`?E?lC?lC?lC?lC?lC?lC?lC?lC?lC?E?-V?-V?lC?lC?lC?lC?lC?lC?Gz?Gz?lC?lC?lC?lC?bM?dZ1?vȴ9X?(\)?lC?lC?"`B?lC?lC?lC?Q?1&y?1&y?-V?lC?lC?lC?lC?-V?E?lC?lC?-V?lC?lC?lC?lC?lC?(\)?dZ1?lC?lC?lC?lC?j~"?j~"?lC?"`B?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?j~"?E?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?Gz??"`?S?+?Gz?+?lC?lC?lC?/v?lC?1&y?E?vȴ9X?lC?lC?tj~?lC?lC?lC?"`?1&?"`A?lC?lC?lC?1&y?E?lC?lC?lC?lC?(\)?p
=q?lC?lC?lC?lC?5?|h?lC?lC?lC?lC?Q?lC?lC?lC?lC?lC?+?lC?lC?lC?lC?^5?|?lC?lC?lC?"`B?+?dZ1?lC?lC?lC?lC?lC?lC?-V?E?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?vȴ9X?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?p
=q?lC?lC?lC?lC?lC?lC?      ?lC?+?S?lC?lC?lC?lC?XbM?"`A?vȴ9?tj~?lC?lC?lC?lC?lC?lC?lC?      ?/v?Q?p
=q?lC?lC?lC?dZ1?QR?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?E?Gz?ěS?E?lC?lC?lC?lC?lC?lC?lC?lC?lC??lC?j~"?                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	@N33333@Nfffff@Nfffff@Nfffff@Nfffff@Nfffff@Nfffff@Nfffff@Nfffff@Nfffff@Nfffff@Nfffff@Nٙ@Nٙ@Nfffff@Nfffff@Nfffff@N     @Nfffff@Nٙ@Nfffff@Nfffff@Nfffff@Nٙ@Nfffff@Nfffff@Nٙ@Nfffff@Nfffff@Nfffff@N33333@Nffffff@Nfffff@Nٙ@Nٙ@Nfffff@N33333@Nfffff@Nٙ@Nٙ@Nٙ@N33333@Nfffff@Nfffff@Nfffff@Nٙ@Nٙ@Nfffff@N33333@Nfffff@N33333@N33333@Nfffff@Nfffff@Nfffff@Nfffff@Nfffff@Nfffff@Nٙ@Nfffff@Nfffff@Nfffff@Nfffff@Nfffff@Nfffff@Nfffff@Nfffff@Nfffff@Nfffff@Nfffff@Nfffff@Nfffff@Nfffff@Nfffff@Nfffff@Nfffff@N33333@N33333@N33333@N33333@O&fffff@OY@Offfff@Oٙ@P@P@     @Pl@Pfffff@P@Pl@Pl@P     @P     @P33333@P@P     @P@P     @Pfffff@P@P33333@P33333@Pٙ@Pٙ@Pٙ@Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@Pfffff@P@P@P@P@P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@Pfffff@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P@P@P@Pfffff@Pfffff@Pfffff@P@Pfffff@P     @Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P33333@Pٙ@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P@P@P@P@P@P@P@P@P@Q      @P@P@P@P@P@Q      @P@P@Q      @Qfffff@Qfffff@Qfffff@Qfffff@P@Q@Qfffff@Qfffff@Qfffff@Q@Q@Q      @P@Q@Qfffff@Qfffff@Qfffff@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q@Q33333@Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q33333@Q@Q33333@Q33333@Q33333@Q@Q@Q@Q@Q@Q@Q33333@Q33333@Q@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q33333@Q@Q@Q@Q@Q@Q33333@Q33333@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q33333@Q33333@Q@Q33333@Q33333@Q@Q33333@Q33333@Q33333@Q@Q33333@Q33333@Q@Q33333@Q@Q@Q@Q@Q@Q33333@Q33333@Q@Q33333@Q33333@Q33333@Q33333@Q@Q33333@Q33333@Q33333@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @P@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q@Q@Q      @Q      @Q@Q@Q      @Q      @Q      @Q@Q@Q      @Q@Q      @Q      @Q@Q      @Q      @Q      @Q      @Q@Q@Q@Q      @Q      @Q      @Q@Q      @Q@Q@Q@Q      @Q@Q@Q      @Q      @Q@Q      @Q@Q@Q33333@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q&fffff@Q&fffff@Q&fffff@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q&fffff@Q&fffff@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q&fffff@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q@Q@Q      @Q      @Q      @Q      @Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q@Q@Q@Q      @Q      @Q@Q@Q@Q@Q@Q      @Q@Q@Q@Q@Q      @Q@Q      @Q@Q@Q@Q@Q@Q@Q      @Q      @Q      @Q      @Q@Q@Q@Q@Q@Q@Q@Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q      @Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q@Q@Q      @Q      @Q@Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q@Q      @Q@Q@Q      @Q      @Q      @Q      @Q      @Q@Q@Q      @Q@Q@Q@Q@Q@Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q@Q@Q@Q@Q@Q@Q@Q      @Q@Q@Q@Q@Q@Q@Q      @Q@Q@Q      @Q@Q@Q      @Q      @Q      @Q      @Q@Q@Q@Q      @Q@Q@Q@Q@Q      @Q      @Q      @Q@Q      @Q      @Q@Q      @Q@Q@Q      @Q      @Q      @Q      @Q      @Q@Q@Q@Q@Q@Q@Q      @Q      @Q      @Q      @Q@Q@Q@Q      @Q      @Q      @Q      @Q      @Q@Q@Q@Q@Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q@Q@Q@Q@Q      @Q@Q      @Q@Q@Q      @Q      @Q      @Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q&fffff@Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q&fffff@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q@Q@Q      @Q      @Q      @Q@Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q&fffff@Q      @Q      @Q&fffff@Q&fffff@Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q      @Q&fffff@Q      @Q      @Q      @Q      @Q      @Q      @Q&fffff@Q&fffff@Q&fffff@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q      @Q      @Q      @Q&fffff@Q      @Q&fffff@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q&fffff@Q      @Q      @Q      @Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q      @Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q      @Q      @Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q@Q@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q,@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q,@Q,@Q,@Q,@Q,@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q,@Q,@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q,@Q,@Q&fffff@Q,@Q&fffff@Q,@Q,@Q&fffff@Q&fffff@Q&fffff@Q,@Q&fffff@Q&fffff@Q&fffff@Q,@Q,@Q,@Q&fffff@Q,@Q,@Q,@Q,@Q,@Q,@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q,@Q,@Q,@Q&fffff@Q@Q@Q&fffff@Q,@Q,@Q,@Q&fffff@Q&fffff@Q,@Q,@Q,@Q&fffff@Q&fffff@Q,@Q,@Q,@Q&fffff@Q&fffff@Q&fffff@Q,@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q,@Q,@Q,@Q,@Q,@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q,@Q,@Q,@Q,@Q,@Q,@Q&fffff@Q,@Q,@Q&fffff@Q,@Q,@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q,@Q,@Q,@Q&fffff@Q&fffff@Q,@Q&fffff@Q&fffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       P21                                     1                                       BF3PH