CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20120522   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P16    CAST_NUMBER       4      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:48.179368Z    ORIGINAL_HEADER      sCTD,20250210CCHSIOWB
#Renamed 'CTDFLUOR_TSG' to 'CTDFLUOR_ALT_1' with units 'MG/M^3'
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2018-11-29. CTD data from cruise 18DD20120522, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20120522. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2012-12/index.php. 
#
# The information in this file for the cruise 2012-12 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-0072.ctd
#
# Start of originator file comment header
#
#*2018/11/29 14:22:51.16
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2012/06/01 08:02:46.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 2006
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : C44EDC1F
#    NUMBER OF CHANNELS  : 9
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            2.3            2006.7
#       2 Temperature:CTD               deg_C_(ITS90)   1.9166         6.6907
#       3 Salinity:CTD                  PSS-78          32.6639        34.5892
#       4 Sigma-t:CTD                   kg/m^3          25.6458        27.6748
#       5 Transmissivity:CTD            %/m             61.4           67.9
#       6 Oxygen:Dissolved:CTD:Volume   ml/l            0.41           7.23
#       7 Oxygen:Dissolved:CTD:Mass     µmol/kg         17.9           314.7
#       8 Fluorescence:CTD:Seapoint     mg/m^3          0.24E-01       0.74
#       9 Fluorescence:CTD:Wetlabs      mg/m^3          0.102          1.096
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        6  F       ' '     1
#       6  -99   ' '        7  F       ' '     2
#       7  -99   ' '        6  F       ' '     1
#       8  -99   ' '        8  F       ' '     3
#       9  -99   ' '        8  F       ' '     3
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2012-12
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P24
#    EVENT NUMBER        : 72
#    LATITUDE            :  49  50.17000 N  ! (deg min)
#    LONGITUDE           : 142  40.04000 W  ! (deg min)
#    WATER DEPTH         : 3989
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    CTDEDIT was used to remove surface records and records corrupted by shed
#	wakes; salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Transmissivity, Fluorescence and PAR data are nominal and unedited except
#	that some records were removed in editing temperature and salinity.
#
#    For details on how the transmissivity calibration parameters were calculated
#	see the document Transmissivity_Calculation.pdf.
#
#    The Oxygen:Dissolved:CTD calibration was done using the method described in 
#	the Sea-Bird Application Note #64-2 (Sea-Bird_64-2_Jun2012.pdf).
#
#    The Oxygen:Dissolved:CTD data are considered, roughly, to be:
#	±0.1 ml/l from 0 to 125 dbar.
#	±0.06 ml/l from 125 to 500 dbar.
#	±0.04 ml/l from 500 to 2000 dbar.
#	±0.02 ml/l below 2000 dbar.
#
#    For details on the processing see processing report: 2012-12-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5-- --6--- --7-- ---8--- ---9---
#!Pressu Temperat Salinity Sigma-t: Trans Oxygen Oxyge Fluores Fluores
#!re:CTD ure:CTD  :CTD     CTD      missi :Disso n:Dis cence:  cence: 
#!                                  vity: lved:  solve CTD:    CTD:   
#!                                  CTD   CTD:   d:CTD Seapoin Wetlabs
#!                                        Volume :Mass t              
#!------ -------- -------- -------- ----- ------ ----- ------- -------
#*END OF HEADER
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @I         data_max      @I         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER       .    pressure                	long_name         pressure   positive      down   units         decibar    data_min      @ffffff   data_max      @{33333   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC        =   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d        M    temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      @6+jg   data_max      @0
   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC         Q    temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d        `   salinity                	long_name         salinity   units         PSS-78     data_min      @@[)^	   data_max      @AD   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC        d`   salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d        s   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @?fffff   data_max      @s`        C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC          w   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d        @   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?E   data_max      @7KƧ   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC            CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d           PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC            PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d            	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min      @M   data_max      @Pfffff   C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC          CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d        `   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         (  @   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         (  h   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min         data_max         C_format      %10d        Ő   latitude               	long_name         latitude   units         	degrees_N      data_min      @HI^5?   data_max      @HI^5?   C_format      %9.4f           Ŕ   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      `KƧ   data_max      `KƧ   C_format      %9.4f           Ř   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d         Ŝ   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min        ~   data_max        ~   C_format      %4d         Š@I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @ffffff@333333@      @       @"      @#@%@'@*      @,333333@.      @/@1      @2      @3      @4      @5      @6@7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @Afffff@B      @B@B33333@C     @D      @D     @Dٙ@E     @F      @F@F@G     @H      @H@I      @I     @J      @J     @K      @K     @L      @L     @L33333@M     @N      @N     @O@Os33333@P      @P@     @P     @P     @Q      @Q@     @Qfffff@R      @R@     @R     @R     @S      @S@     @S     @S     @T      @TFfffff@Ty@T     @U      @U@     @U     @U     @V      @V333333@V     @V     @W      @W@     @W     @W     @X      @X@     @Xy@X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^fffff@^@_9@_     @_     @`      @`#33333@`C33333@`\@`     @`     @`     @`     @a33333@a@a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @b@c#33333@c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d@d     @d     @e      @e      @e@     @e`     @e     @e     @e     @efffff@e@f      @f@     @f`     @f     @f     @f     @fٙ@g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h@h@     @h`     @h     @h     @h     @h33333@h     @i)@i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k@k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o@o     @p      @p     @p      @p0     @p>fffff@pc33333@pp     @p     @p     @p     @p     @p     @p@pfffff@p     @q      @q     @q      @q0     @q@     @qP     @q\@qt@q     @q     @q     @q@qfffff@q     @q     @q񙙙@r      @r     @r      @r0     @r@     @rP     @r`     @rq@r     @r     @r     @r     @r     @r     @rfffff@r33333@s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @t33333@t     @t      @t0     @t@     @tP     @t`     @tq@t@t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @ua@uk33333@ufffff@u     @u     @u     @u     @u     @ufffff@u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v~fffff@v     @v     @v     @v     @vљ@v     @v     @w      @w     @w      @w0     @w@     @wP     @wffffff@wp     @w     @w     @w     @w     @w     @wfffff@wᙙ@w     @x      @x     @xfffff@x0     @x@     @xP     @x^fffff@xt@x     @x     @x     @x     @x@xfffff@x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y@y     @y     @y     @y     @y     @y     @y     @z      @zfffff@zfffff@z0     @z@     @zQ@z`     @zp     @z     @z     @z     @zfffff@z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{fffff@{     @{     @{񙙙@|@|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|33333@|fffff@|     @|     @|     @|     @|     @|33333@}fffff@}      @}0     @}@     @}P     @}`     @}q@}     @}     @}fffff@}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @4@@     @P     @`     @p     @{33333                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                @*0U2a@ۋq
@B@Ov`@0
@@RT`e@@,@唯O
@@4@ⶮ}Vm@9@Ft@ ѷY@C,zx@6C@hr @}Vl@z@p@As@'/@nP@~@A7K@@<64@yrGE8@iy@\]ce@DS@:xl"h
@5Xy=@.1@)Dg8~@N;@tj~@sg@5!R@	k~@(\@$Z1@ĵ?@L_@iᰉ'@WsPH@SZ@NMj@K'/@F-@EQ@Do h@DM:@C%2@A@@IQ@<Z@7Xe@1&x@,VϪ@%zxl"h@u@͞@oiDg@@*0@t@3@+j@@}p
=@p ě@jJL@Zc	@حV@ݗ+k@{@nP@z@/w@䎊@-
q@˒:*@@4m@<#x@Ʌoi@H˒@|hs@@쿱[@~($@/V@<64@J#9@#@@@!R@A@\N<@ C@o i@?@@(	ԕ+@9~($@B@I ѷ@`[6@kC,z@o@tD@JM@6@,zxl@@ʌL_@Ϫ͟@?@޸Q@ߤ@@
=p@zG@Z@;dZ@/{J#@ڹY@ǮzH@~$@>BZc@Fs@sPH@cA [@VR<6@Rp:@P{@I7KƧ@?$tS@9XbM@3g	l@'	k@ߤ@@p:@E@?@#x@q@7@	 @j~"@3PH@nO@_ح@{@(@	ԕ+@n@E@'RT@0U2a|@=p
@o-V@fA@f@e1@de@ae@Mqu"@-hr!@҉@sg@e+a@т@@\N<@E@jf@N;@}<64@fx@[S@L@/r@
%@ IQ@g@C\@$xG@;dZ@*0@T`d@@Fs@~($@kP@@u!@|Q@q@a|Q@X_F@Q4J@Kq@C@:~@)lD@@g	l@Ov`@M@TɆ@ěT@	 @D@ΤT@N;5@@;5X@ɺ^5?}@ڹZ@@@k~($@WXe,@U*0@Q4J@L@GzH@Ao hی@(ۋq
@m@a|Q@@@'/W@ɅoiD@@t@@nO@w3@de@[W>6z@M@JL_@<?@2s@'lC@=K^@Mj@p:~@8YK@ȴ9X@
qv@@Z@@)_@F]d@eں@ߤ@>B[@Z@-w1@@)^	@_p@@\N@$tS@w+@o{J#:@h$xG@`u!@^Ov_خ@Y|@V8YJ@UL_@TFs@N+@KC%@A@.t@vȴ@
=p
@@
(@m]@Q@-@빌~($@&@Gz@iB@c	@b}@l!-@Fs@т@'/W@̈́M:@qiC@2W@H˒@64@>B@1@l@(@[6@1'@ݘ@_F@Xe,@=K@Z@hr @|@T@jOv@'/W@W'@?@n.@}E@}Vl!@x)@d7@[qu!@Zu%F@Y+@XU@XbM@WO;d@WsPH@W>6z@W>6z@VR<6@Sݗ+k@P{@M5Xy>@GzH@FYJ@E8YK@Ca@N@?H˒:@>
(@<Z@9=b@7eں@3MjO@.1@,1&y@(Xy=@'-@)lD@&fffff@%1@&'@%@$qj@#
=p@+j@Z@4J@R@{@qi@
L_@u%F@%2@@Zc@ NU@ 6@E@쿱[@lC@G{@Y}@}H@!R@J@E@E@|@W@s@@r@@-V@4֡a@ hۋ@!-w@a@@Q@Ov`@x@\)@	ԕ+@RT`e@A@'@fffff@@F
L0@n.3@e+@d8@iB@Q@"`B@,<@c	@1'@_F@@Ov_@а{@@k~(@E84@F]c@hۋq@6z@vȴ9X@BZc @p
=@!.H@Z@dZ@)_@Q@E@ ě@{m@W@GE85@2W@
qv@@8}H@`A@[6@'RT`@䎊r@-V@e+a@U@,<@o @%@Ƨ@ԕ*@oiD@K]c@$/@H˒:@~m\@}K]@{dZ@zxl"h
@z)y@yY}@xF@wkP@v+jg@r{m@lq@hXy=@eF
L0@dtSM@d%1@cwk@cS&@cS&@bM@_?@Y0
)@QN;5@OAs@N_o @KƧ@H9Xb@Gݗ+@F?@DJM@C\N@B@C{J#9@ATɅo@?˒:)@>BZc @9=b@6+jg                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                @@[q@@[eO@@[q@@[q@@[q@@[q@@[eO@@[eO@@[q@@[q@@[eO@@[eO@@[Mj@@[Mj@@[eO@@[q@@[q@@[Mj@@[U=@@[A@@[qu!@@[~$@@[J#9@@[@N@@[C%@@[F]c@@[MjO@@[F]c@@[9@@[,zxl@@[)^	@@[,zxl@@[)^	@@[/V@@[33333@@[9@@[=K^@@[33333@@[:)z@@\@@[@@[\N@@\SMj@@\*1@@\C@@\1&@@\?@@\[W?@@\@@\֡a@@\u"@@\@@\D@@\>@@]K]@@][@@]!.H@@]+a@@]<64@@]B@@]IQ@@]Y|@@]fA@@]zxl"h@@]}H@@]hr!@@]ݗ@@]ڹZ@@]+j@@]=K@@]v@@]@@]@@]@@]oiDg@@^.2@@^!R<@@^.2@@^?@@^_ح@@^p:~@@^s@@^l!-@@^}Vl@@^T@@^"@@_&@@`bM@@`u!@@`tj@@`C@@a@@aoiD@@b ѷ@@dSMj@@eS&@@io hی@@k҉@@k"`B@@m
qv@@xtj@@|TɆ@@'/W@@JE@@h	ԕ@@E@@n/@@ݗ+k@@_o @@{J#:@@1&@@af@@iDg8@@:~ @@?@@G{@@L/{J@@C,z@@α2X@@O
M@@ڹY@@!.I@@g@@_ح@@Ft@@>6z@@索3@@$xG@@NU@@tj@@@@@@n@@C,z@@F]c@@g	l@@jf@@tj~@@Q@@:)z@@A@@S@@빌~($@@a@@@
=p@@ݗ+k@@$@@g@@%2@@%2@@A [@@s@@s@@@@@@빌~($@@m]@@빌~($@@q@@ߤ@@U=@@믷@@S@@달q@@~$@@~$@@@@~$@@{J#9@@xF]@@@@qu!@@g	l@@a@N@@Z@@W>6z@@S@@MjO@@MjO@@g	l@@~$@@dZ@@J#9@@]cA@@g	l@@W>6z@@W>6z@@W>6z@@W>6z@@g	l@@xF]@@qu!@@jf@@S@@Z@@tj~@@tj~@@{J#9@@Mj@@Q@@{J#9@@n.3@@n.3@@n.3@@qu!@@xF]@@달q@@땁$@@m]@@|@@@@VϪ@@E@@qu"@@Z@@TɆ@@5Xy>@@m\@@w1@@hr!@@v@@H˒@@U=@@b@@b@@,=@@C\@@ڹ@@ڹ@@t@@ڹ@@
qv@@Ϫ͞@@E@@ڹ@@ڹ@@
L/@@E@@,=@@?@@_o @@4K@@($x@@BZc @@s@@O;@@@@'@@Ϫ͟@@쿱[W@@!.I@@+I@@As@@Xe,@@O
M@@vȴ9@@rGE9@@'RT`@@'RT`@@*0@@K]c@@r Ĝ@@@@p:@@4J@@k~(@@o@@ᰉ'@@e+@@#9@@)y@@)y@@^5?|@@kP|@@{m@@L/{@@n@@,<@@c	@@	@@6z@@@@\N@@cA \@@@@u"@@:@@V@@/w@@jOv@@+j@@8Y@@oiDg@@ڹ@@4K@@@@BZc @@Ov_خ@@fffff@@s@@}Vl@@af@@ߤ?@@'/W@@4֡a@@E84@@y@@o @@#@@{@@PH@@@@x@@7Kƨ@@R<6@@l@@|@@@@R@@s@@s@@#9@@0U2a|@@:)y@@Q_@@^5?|@@p:@@=K^@@{J#9@@@@Mj@@$@@ߤ@@U=@@ߤ@@m]@@q@@~($@@
=p@@@@%1@@j~#@@tSM@@~($x@@_@@S@@S@@zxl"@@@@j~@@Z@@>B[@@Z@@hr@@hr@@!.H@@\@@\@@+j@@@@@@S@@5?|@@'@@쿱[W@@ hۋ@@+I@@4m@@[W>@@/V@@rGE9@@rGE9@@rGE9@A Q@A @A )^@A ҈p@A {@A	k~@A+@A#w@A4J@Ae+a@A|Q@An.@Ay@A>BZ@AR@A-@As@As@Ae+@A1'@A#9@AM@Au%F
@A\(@AI^@A9@AP{@AP{@AW>6z@AW>6z@AdZ@Ajf@AxF]@AU=@A@A@Am]@AZ@A6@A~($@AE@AZ@A~($@A6@A~($@A5Xy@Atj@A9XbN@Aq@A#@A[W?@Ae@A*0@AB@Ace@Aw1@Ahr!@Ash@A@AC\@A4K@AOv_@A?@As@A@Aߤ?@A hۋ@Ay@Ao @AحV@A ě@A73@A:~ @AA7K@AeO@A-
@AěT@A	 ѷ@A	A [@A	Q@A	k~(@A	rGE8@A	o hی@A	7Kƨ@A	"`@A	>BZ@A	s@A
	 @A
Ov`@A
&IR@A
)y@A
3@A
C\@A
^5?|@A
xl"h
@A
L/{@A
 ѷ@A
D@AnP@AC,z@A"`B@A,zxl@A9@A@N@AP{@An.3@AE@AJ@AL_@A"h	ԕ@A/{J#@APH@AZ1@Am8@AwkP@A~($x@A#@AN;@A3@A#x@A7@AJM@AD                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                @r     @r33333@r33333@rfffff@r33333@r@r33333@r@r33333@r@r@r     @r񙙙@rfffff@r33333@r33333@r@rfffff@r33333@s33333@sfffff@s33333@s     @s	@sfffff@s@s33333@s(     @s,@s+33333@s&fffff@s$@s#33333@s(     @s,@s+33333@s@s     @s,@s8     @s;33333@s6fffff@sT@s`     @s`     @s^fffff@s\@sT@sL@sI@sFfffff@sD@sA@s>fffff@s>fffff@s;33333@s6fffff@s1@s(     @s      @s@sfffff@s@s     @s@s33333@s33333@sfffff@s33333@s@rfffff@r     @r33333@r33333@r33333@rfffff@r陙@r@rfffff@r33333@r񙙙@r񙙙@r@r     @r@rfffff@r@r     @rfffff@r33333@r@r@rVfffff@rfffff@r     @r      @q     @qə@qC33333@p陙@p     @pfffff@pl@o`     @n     @mvfffff@m6fffff@l33333@ly@l@     @l	@kfffff@k	@jl@i     @i@h@g     @f     @f#33333@e陙@efffff@e     @eə@e33333@e     @e     @e|@el@eS33333@e)@d@dfffff@d33333@d     @dٙ@d33333@d@dfffff@d@d     @d@d@d|@dp     @dc33333@dVfffff@d@     @d@cfffff@c     @cfffff@c@cfffff@c33333@cfffff@c33333@c     @cp     @cVfffff@c9@c,@c&fffff@c,@c0     @c,@c#33333@c@c33333@bfffff@b     @b     @b33333@b|@b     @bvfffff@bs33333@bffffff@b@b33333@a33333@a33333@a     @a33333@a@a@a@a33333@a|@a33333@a@a     @a33333@a@a|@a     @a33333@`     @`陙@`33333@`ٙ@`fffff@`@`@`@`s33333@`Ffffff@`,@`#33333@`@`33333@_ٙ@_@_     @_33333@_33333@_@_     @_@_&fffff@^@^ffffff@^9@^,@^@^@]@]ٙ@]     @]@\fffff@\     @\`     @\L@\,@\33333@[ٙ@[s33333@Z@Z@Z33333@Zy@Zffffff@ZL@Z&fffff@Y@Y@Y`     @Y&fffff@Y      @Y      @Y33333@Y333333@YFfffff@YS33333@Wfffff@W@W@W@W33333@W@X@X@Vfffff@V     @V@V33333@Vfffff@Vy@Vfffff@Vy@VY@Ufffff@U@U@U@U@U33333@Ufffff@U33333@T@Ty@T,@Tfffff@S33333@S@S@S     @Sl@S,@R@Rfffff@Rfffff@R33333@R33333@R     @Rfffff@Rs33333@Rffffff@RFfffff@R@Q@Q@Qfffff@Q33333@Qfffff@Qfffff@P33333@Pfffff@Q33333@Q9@Q9@PFfffff@P@     @P333333@P&fffff@P&fffff@P333333@P333333@P9@Offfff@O@O@O@Oٙ@Oٙ@O@Nfffff@N@N@N@N33333@N     @N     @N@N&fffff@N&fffff@N@N      @M33333@N      @M@Ms33333@Ms33333@M     @M     @M     @Ms33333@Mffffff@Mffffff@MY@M@     @M@M&fffff@M333333@M@     @ML@M333333@L333333@K33333@K33333@K33333@K@Kٙ@K@Jfffff@J@Js33333@Jffffff@Js33333@Jffffff@JY@J@     @I@I     @Is33333@Iffffff@IY@IY@Iffffff@Is33333@Iffffff@Hfffff@H@H@H     @Hs33333@Hs33333@HY@HY@HY@HL@H@     @H@Gfffff@Gs33333@GL@G333333@G333333@G333333@G333333@G@G@G@F33333@F33333@F33333@F33333@Fٙ@Fٙ@F33333@Ffffff@Fٙ@Ffffff@F33333@F33333@F33333@F@F     @FY@F@     @F&fffff@F      @Efffff@E     @E@Es33333@E333333@E&fffff@E&fffff@D33333@Dٙ@D@D@D@DL@DL@D@     @D@Cs33333@CY@C333333@C@C      @B33333@B33333@C@C@C@B@B@B@B&fffff@B&fffff@BL@BL@Afffff@A33333@Afffff@A@A@A@A     @As33333@As33333@AY@A@A      @A      @@33333@@33333@@33333@@fffff@@ٙ@@     @@     @@fffff@@s33333@@ffffff@@Y@@L@@L@@@     @@&fffff@@&fffff@@&fffff@@&fffff@@&fffff@@@     @@333333@?fffff@@      @@@@@@@@                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ?Q?^5?|?l?S?bM?$/?I^5?"`A?l?1&?5?|h?ȴ9Xb?m?홙?+?dZ1?-V?\(\?ȴ9Xb?Gz?QR?zG?C%?ffffff?QR?
=p?Ƨ-?ffffff?p
=q?\(??KƧ?S?j~#?tj?O;d?1&?tj~?+?9XbN@ Vu@1&x?"`B@ nO;@7KƧ@ Gz?;dZ?I^5??5?|h?Q?`A7K?Ƨ-?m?$/?o?+?zG?+?C%?I^5?$/?$/?bM?tj??vȴ9?/v?
=p
? ě?7KƧ?bM?7KƧ?zG{?ěS?tj?
=p
?Q?;dZ?vȴ9X?-?vȴ9X?dZ1?1&y?tj?\(?䛥S?`A7?ȴ9Xb?Q?⟾vȴ9?zG?7KƧ?"`?tj?ڟvȴ9?lC?j~"?ڰ ě?A7Kƨ?`A7L?ם-V?vȴ?E?ָQ?Լj~#?S?xF?nO;?~"?I^5??Гtj~?Ͼvȴ9X?$/?A7Kƨ?+?m??~"?~"?ǍO;dZ?
=p
?ǍO;dZ?KƧ?ȴ9Xb?E??|hs?Z1'?Ł$/?\(?ěS?9XbM?tj~?Õ$/?Ƨ-?\(?S?-V?° ě?nO;?\(?Ł$/?7KƧ?I^5??7KƧ?333333?`A7K?hr Ĝ?$/? ěT?bM?`A7?-V?`A7L?E?|hr?hr Ĝ?ěS?
=p?`A7?lD?A7Kƨ?-V?vȴ9X?;dZ?      ?p
=q?GzH?&x?GzH?A7Kƨ? ěT?      ?&x?-V?I^5??|hr?7KƧ?hr Ĝ?;dZ?Q?M?-V?
=p?;dZ?Q?&x?&x?bM?E?7KƧ?GzH?&x?
=p?A7Kƨ?A7Kƨ? ěT?`A7L?GzH?S?n?-V?
=p?Q?bM?GzH?`A7L?bM?vȴ9X?\(?nP?bM?GzH?&x?\(?`A7L?-V?5?|h?Q?bM?nP?7KƧ?7KƧ?;dZ?|hr?      ?nP?bM?$/?\(?&x?$/?`A7L?I^5??      ?7KƧ?`A7L?S?nO;?7KƧ?`A7L?n?I^5??S?nO;?      ?|hr?-V?`A7L?/v?
=p?7KƧ?A7Kƨ?nO;?\(?° ě?&x?7KƧ?Q?-V?
=p?p
=q?&x?-V?
=p?vȴ9X?M?nO;?nO;?`A7L?      ?hr Ĝ?Q?ěS?nO?/w?nO;?M?GzH?`A7?-V?S?M?A7Kƨ?&x?öE?nO;?GzH?$/?Q?`A7?GzH?`A7L?nO?l?`A7L?lD?bM?Q?GzH?9XbM?bM?&x?S?
=p?° ě?`A7L?$/?M?l?nO;?      ?GzH?M?vȴ9X?M?7KƧ?-V?GzH?M?$/?bM?7KƧ?A7Kƨ?öE?M?&x?nP?-V?l?
=p?`A7L?`A7?
=p?7KƧ?-V?      ?Q?-V?nO;?M?GzH?hr Ĝ?hr Ĝ?n?$/?GzH?`A7L?`A7?° ě?Q?M?hr Ĝ?$/?Q?M?tj~?333333?n?vȴ9X?Q?;dZ?n?nO?l?9XbM?M?M?nO;?Õ$/?`A7?Q?+?n?
=p?M?I^5??`A7L?lD?n?I^5??nO;?nO;?Q?öE?Q?`A7?hr Ĝ?n?GzH?`A7?7KƧ?M?vȴ9X?
=p?hr Ĝ?lD?nO?333333?öE?I^5??nO;?M?n?M?nO;?tj~?\(?hr Ĝ?l?l?;dZ?-V?GzH?-V?+?öE?Õ$/?n?\(?° ě?n?$/?M?-V?hr Ĝ?/w?tj~?lD?ěS?n?`A7?+?Q?nO;?nP?-V?`A7?M?S?Õ$/?nO?M?Õ$/? ěT?° ě?hr Ĝ?M?9XbM?9XbM?9XbM?E?+?S?° ě?M?° ě?n? ěT?-V?`A7?l?&x?
=p?n?\(?lD?vȴ9X?nO;?\(?n?-V?\(?Q?333333?hr!?lD?tj~?M?nO?Õ$/?° ě?\(?I^5??nO;?lD?tj~?nO?nO;?bM?A7Kƨ?bM?-V?Q?M?-V                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	@N@N@N@N@M@N      @M33333@Mfffff@M33333@Mٙ@N      @Mfffff@N@M33333@N@N@N@N      @MY@Mٙ@N      @Mfffff@M33333@Mfffff@Mfffff@Mfffff@Mfffff@N      @M33333@Mfffff@Mٙ@Mfffff@Mfffff@M@M     @M33333@M@M     @MY@Mffffff@M333333@M@     @M333333@M@     @M@M333333@Mffffff@M@Mٙ@N      @N@N333333@NY@Nffffff@Ns33333@Ns33333@N@N33333@N@Nٙ@N33333@O@O@O&fffff@OL@OY@O@O@O@O33333@O     @O@Oٙ@Offfff@O33333@Offfff@P33333@P      @P&fffff@P&fffff@P,@P,@P333333@P333333@P,@P9@P@     @PL@PY@P`     @P`     @Pl@Pffffff@Pffffff@Pl@Py@Py@Pfffff@Pfffff@Pfffff@P@P33333@P33333@P33333@P@P33333@P@P@P@P     @P     @P33333@Pfffff@Pfffff@Pfffff@P33333@Pfffff@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@Pfffff@P@P@P@P33333@P33333@Pfffff@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Py@P     @P@P@P@P@P@P@P33333@P33333@P@Pfffff@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P@P33333@P@P@P     @P@P     @P     @P     @P33333@P@P@P@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@Pfffff@P     @Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@Pٙ@P33333@P33333@P33333@P33333@P33333@P33333@Pٙ@P33333@Pٙ@P33333@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@P33333@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @P     @Pٙ@Pٙ@Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                P16                                     4                                       BE"N^3~