CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20120522   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P4     CAST_NUMBER       5      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:47.876943Z    ORIGINAL_HEADER      sCTD,20250210CCHSIOWB
#Renamed 'CTDFLUOR_TSG' to 'CTDFLUOR_ALT_1' with units 'MG/M^3'
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2018-11-29. CTD data from cruise 18DD20120522, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20120522. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2012-12/index.php. 
#
# The information in this file for the cruise 2012-12 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-0072.ctd
#
# Start of originator file comment header
#
#*2018/11/29 14:22:51.16
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2012/06/01 08:02:46.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 2006
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : C44EDC1F
#    NUMBER OF CHANNELS  : 9
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            2.3            2006.7
#       2 Temperature:CTD               deg_C_(ITS90)   1.9166         6.6907
#       3 Salinity:CTD                  PSS-78          32.6639        34.5892
#       4 Sigma-t:CTD                   kg/m^3          25.6458        27.6748
#       5 Transmissivity:CTD            %/m             61.4           67.9
#       6 Oxygen:Dissolved:CTD:Volume   ml/l            0.41           7.23
#       7 Oxygen:Dissolved:CTD:Mass     µmol/kg         17.9           314.7
#       8 Fluorescence:CTD:Seapoint     mg/m^3          0.24E-01       0.74
#       9 Fluorescence:CTD:Wetlabs      mg/m^3          0.102          1.096
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        6  F       ' '     1
#       6  -99   ' '        7  F       ' '     2
#       7  -99   ' '        6  F       ' '     1
#       8  -99   ' '        8  F       ' '     3
#       9  -99   ' '        8  F       ' '     3
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2012-12
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P24
#    EVENT NUMBER        : 72
#    LATITUDE            :  49  50.17000 N  ! (deg min)
#    LONGITUDE           : 142  40.04000 W  ! (deg min)
#    WATER DEPTH         : 3989
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    CTDEDIT was used to remove surface records and records corrupted by shed
#	wakes; salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Transmissivity, Fluorescence and PAR data are nominal and unedited except
#	that some records were removed in editing temperature and salinity.
#
#    For details on how the transmissivity calibration parameters were calculated
#	see the document Transmissivity_Calculation.pdf.
#
#    The Oxygen:Dissolved:CTD calibration was done using the method described in 
#	the Sea-Bird Application Note #64-2 (Sea-Bird_64-2_Jun2012.pdf).
#
#    The Oxygen:Dissolved:CTD data are considered, roughly, to be:
#	±0.1 ml/l from 0 to 125 dbar.
#	±0.06 ml/l from 125 to 500 dbar.
#	±0.04 ml/l from 500 to 2000 dbar.
#	±0.02 ml/l below 2000 dbar.
#
#    For details on the processing see processing report: 2012-12-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5-- --6--- --7-- ---8--- ---9---
#!Pressu Temperat Salinity Sigma-t: Trans Oxygen Oxyge Fluores Fluores
#!re:CTD ure:CTD  :CTD     CTD      missi :Disso n:Dis cence:  cence: 
#!                                  vity: lved:  solve CTD:    CTD:   
#!                                  CTD   CTD:   d:CTD Seapoin Wetlabs
#!                                        Volume :Mass t              
#!------ -------- -------- -------- ----- ------ ----- ------- -------
#*END OF HEADER
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @.         data_max      @.         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     (  .    pressure                	long_name         pressure   positive      down   units         decibar    data_min      @ffffff   data_max      @fffff   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      (  V   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      
0     temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      @ݗ+k   data_max      @&#nP   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       (     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      
0     salinity                	long_name         salinity   units         PSS-78     data_min      @?   data_max      @A=H˒   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      (     salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      
0     oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @!ffffff   data_max      @r        C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        (     	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      
0 p   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?5?|h   data_max      ?p
=q   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      ( "   CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      
0 K`   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       ( U   PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d      
0 ~P   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min      @N   data_max      @Pfffff   C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     (    CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d      
0 @   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( p   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         (    time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min         data_max         C_format      %10d          latitude               	long_name         latitude   units         	degrees_N      data_min      @HS-"   data_max      @HS-"   C_format      %9.4f             	longitude                  	long_name         	longitude      units         	degrees_E      data_min      _\(   data_max      _\(   C_format      %9.4f             	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d           	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d        @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @.      @ffffff@      @      @ffffff@@"      @$      @&      @(333333@*      @,333333@.      @0      @1      @2@3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @@33333@A     @B      @B     @C      @C     @D      @D     @D33333@E     @F      @F     @G@Gs33333@H      @H     @I      @I     @J      @J     @J33333@K     @L      @L     @M      @M@N      @Ns33333@O      @O     @P      @P@     @P     @P     @Q@Q9@Q     @Q     @R      @R@     @Rfffff@Rfffff@S@S@     @S     @S     @T      @T@     @T     @T     @Ufffff@U@     @U     @U     @V      @V@     @V     @Vfffff@V33333@W@     @W     @W     @X      @X@     @X     @X33333@Y      @Y@     @Y     @Y     @Z      @Z@     @Z33333@Z     @[      @[@     @[     @[     @\      @\&fffff@\33333@\     @]      @]@     @]     @]fffff@^      @^@     @^     @^     @_      @_Ffffff@_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a@a     @a     @a     @b33333@b33333@b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c|@c     @c     @c     @c@d&fffff@d@     @d`     @d     @d33333@d@d     @e      @e      @e@     @e`     @e     @e33333@e@e@f      @f      @f@     @f`     @f|@f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h33333@h      @h@     @h`     @h     @h@h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @jFfffff@j`     @j|@j     @j     @j33333@j33333@k      @k@     @k\@k@k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l@l@m      @m@     @m`     @m     @mfffff@m     @m     @n      @n      @n@     @nffffff@n     @n     @n     @n     @o      @o      @o@     @o`     @o|@o     @o     @o     @p33333@p     @p      @p0     @p@     @pQ@p`     @pp     @p     @p@p     @p     @p     @p     @p     @p񙙙@pfffff@q     @q      @q0     @q@     @qQ@qc33333@qp     @q     @q     @q     @q     @q33333@q     @q     @q@r      @r     @r!@r0     @r@     @rI@rc33333@rp     @r     @r     @r     @r@r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @sfffff@s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t@t     @t     @t     @t@t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @ufffff@u@u     @u     @u     @v     @v#33333@v333333@v@     @vT@v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w@w     @w      @w0     @wA@wQ@w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @xfffff@x0     @x@     @xP     @x\@xs33333@x     @x     @x     @x     @x     @xfffff@x     @x     @y33333@y     @y      @y0     @y@     @yP     @y`     @yp     @y@y     @y@y     @y     @y     @yfffff@y     @z      @z     @zfffff@z0     @z@     @zP     @z`     @zk33333@z@z     @z@z@z     @z     @z     @z     @{@{     @{      @{0     @{@     @{P     @{a@{l@{     @{     @{     @{fffff@{@{     @{     @{     @|      @|     @|@|1@|@     @|P     @|`     @|nfffff@|     @|     @|     @|     @|     @|     @|ᙙ@|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}fffff@}     @}     @}     @~@~fffff@~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~33333@~     @~     @~     @~     @~     @@     @      @0     @@     @Q@q@     @     @     @     @     @     @     @     @      @     @     @     @      @(@0@8     @@     @H     @P     @T@`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@fffff@     @     @     @      @(@0     @733333@@     @H     @P     @X@`     @h     @p     @x     @     @     @     @fffff@33333@     @     @     @     @     @     @     @     @     @     @     @      @@33333@     @      @(@/33333@8     @@     @H     @P     @X     @`     @h     @p     @x     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @@      @(     @0     @8     @@     @H     @P     @W33333@`     @h     @p     @x@@     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @      @     @     @     @@(     @0     @8@?33333@H     @P     @X     @`@g33333@p     @x     @     @@33333@@     @     @     @     @@fffff@33333@     @     @@33333@     @      @     @     @     @fffff@(     @0     @8     @@     @H     @P     @X     @`     @h@p     @x     @     @     @@@     @     @     @@     @     @     @     @@     @     @     @      @     @     @     @33333@'33333@0     @8     @@     @H     @Nfffff@W33333@`     @h     @p     @x@     @33333@     @     @     @     @fffff@fffff@     @     @     @     @     @33333@fffff@     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X@_33333@h     @p     @x     @     @     @     @     @@     @     @     @     @     @@     @     @     @33333@     @      @     @     @     @      @(     @0     @8@?33333@H     @P     @X     @`     @h     @x     @     @     @     @     @     @     @     @     @@33333@     @     @     @@     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @^fffff@h     @p     @x     @     @@     @     @     @     @     @@     @33333@     @     @     @@񙙙@     @      @     @     @     @@(     @0     @8     @@     @H@L     @X     @`     @h     @p     @x     @@@     @     @     @@     @     @     @     @@     @     @     @@     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X@`     @h     @p     @x     @     @     @     @@@     @     @     @     @     @@     @     @     @     @@ @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h@p     @x     @     @     @@     @     @     @     @     @     @     @     @33333@     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @33333@@     @     @     @     @     @     @@      @     @     @     @      @(     @0@733333@@     @H     @P     @X     @`     @h     @rfffff@x     @     @     @@@@     @     @@@     @     @     @     @     @     @     @      @     @     @     @      @(     @/33333@8     @@     @H     @P     @Vfffff@a@h     @p     @x     @~fffff@@     @     @     @     @@     @     @     @     @     @     @fffff@     @      @     @33333@     @     @fffff@     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @[33333@d     @h     @l     @pfffff@rfffff@x     @|     @     @     @     @     @33333@@     @     @     @     @     @fffff@     @     @     @     @     @fffff@@     @     @     @י@     @     @     @     @     @     @     @     @     @      @     @     @     @     @@     @     @ fffff@#@(     @,     @/@4     @8     @<     @@fffff@C@H     @L     @O@T     @X     @\     @`     @d     @f@l     @p     @t     @x     @|     @     @     @     @fffff@@     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @@     @     @     @     @     @@fffff@     @     @      @     @     @     @     @@     @     @      @$     @'@,     @0     @4     @8     @<     @@fffff@D@H     @L     @P     @T     @X     @[@`fffff@d     @h     @l     @p     @s@x     @|     @@     @@33333@@@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@@     @     @     @뙙@     @     @     @     @      @@     @     @fffff@@     @     @      @#33333@(fffff@,     @0     @4     @8     @;33333@@     @D     @H     @K33333@P@T     @X     @\fffff@_@d     @h     @l     @pfffff@t     @w@|     @~     @     @     @@     @     @     @     @@     @     @     @     @     @fffff@33333@     @     @     @     @     @     @ۙ@fffff@     @     @     @     @fffff@     @     @      @33333@     @     @     @33333@33333@     @      @#@(fffff@,     @0fffff@3@8     @<     @@     @D     @H     @L     @P     @T     @X     @[@_@d     @h     @k@p     @t     @vfffff@|fffff@     @@fffff@@fffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        @&쿱[@&N;@&K]@&IQ@&IQ@&5?|@& ěT@&#nP@&!.H@&($x@&:)y@&C@%\(@%w1@%?@%u%@%}H˒@%]!.H@%9D@%s@$~"@$}cA @$#@$
qu@$ȴ9X@$nT@$@#%zxl"h@"g8}@"ڹ@"H˒:@"QA [@"	ԕ*@!\(@!-@!lD@!D*@!fB@!u=K@!kI^@!dqj@!Xtj@!TE@!RW@!K6z@!Hp:@!ES&@!=H˒@!%84֡@! 6@!;dZ@!䎊r@!!@N@!!:S@!҈p;@!]ce@!q@!u%@!>BZ@!e+@!Xe,@!@ j~#@ rGE9@ vȴ9X@ @ ќu@ o @ t@ ͞%@ /{J#@ d7@ 6z@ {@ jOv@ N;6@ [W?@ F
L0@ W@ ڹ@ TFs@ 2sP@C%@>ߤ?@6@Ush@v4K@ ݗ+@ .H@ᰊ@g	@ tSM@ N;5@ zG@ eO@S&@4֡b@W@S@~6z@["`B@`҈p@d7@t#@ 
~"@ 
qiC@_ح@Q_@As@b}@ wkQ@ Fs@j~#@D*@l@wk@b}@[@+J@-@rGE85@g&@]}H@Mqu"@;lC@,[W?@$@8}H@Ʌoi@@($x@sg@4֡a@1&y@1.@ ѷY@ݘ@K]c@e@[6@VR<6@T*1@O;dZ@L_@D?@@6@=ڹZ@;dZ@873@6z@5!.@2-V@N;@
@]cf@2W@I^5@\N<@(@=b@O
M@+@A [@D@	k@s@b@YJ@*0@zH@|64@h	ԕ+@T@0D@e+@;5X@O
@{J#:@MjO@@l"h	ԕ@W@M(@I ѷ@=Vl!@7Xe@+~($@y@@L/{J@ԯO
M@!-w2@:~ @4m@	 @C-@-V@ڹ@u%F@Ϫ͟@R@rW@QN;6@>($x@Xe,@Ʌoi@An.@gRT`e@|@l@҈p@\N@y	k~@U*0@Iԕ*@=Vl!@ d8@쿱[W@.2X@.H@5!R@,C@T`d@j~@빌~($@ק&@($x@)y@sg@zG@Z@a@N@Vl!-@BI^5@4j~@ ѷY@fA@
W'@lC@Fs@g	l@Xy=@Q_@NU@|Q@iᰉ'@Hp:@A$/@9rGE8@"M@@cA \@o h@ [7@z@RT`e@+a@h	ԕ@|Q@[6@]ce@p:~@%2@C,zx@4m9@iᰉ'@ao@b`A@ZQ_@E8YK@:>B@,[W?@!.H@.H@E@'/@©@hۋq@n.@1@I^5?@`A7@jOv@2W@{m]@q[W>6@f'@^Q@^%@^쿱[W@Vaf@WO;d@W@Y|@][@cA [@^ ѷY@N;5X@K)^	@GzH@>\N<@?.H@;J#9@3MjO@..2@)ᰉ'@'/V@%F
L0@*g	@)^@(r Ĝ@',@*0U2a|@+jf@%S@Ϫ͞@	@TɅo@7Kƨ@$tS@ ѷX@ ѷX@n.@v@_ح@!R@|@@r@U=@B@_F@3@+jg@ȴ9X@Fs@ȴ9X@>B@-V@ae@6C@Ʌoi@_p@@z>B@ov@o@i*0U2a@u%F
L@H˒:@2a|@&@_o@>6z@@~6z@w4m@nt@TZ@GzH@=!.H@1&x@'@$e@%ڹ@!e@	@/w@qu!@2a|@u%F@~($@|@
=q@~"@@S@S@e@$xG@0U2a|@B@͞&@0U2a|@ۋq
@wkQ@,<@+j@2a|@sP@ѷX@т@;5X@D@ȴ9Xb@H˒:@^5?|@C-@MjO@A [@[W>6@\@	k@Q_@Ϫ͞@<64@\(@jOv@5Xy>@cA \@=p
@u%F@$/@n/@o h@Zc@~\N<@x}H@t9XbN@n}Vl@_vȴ9@V8YJ@RS&@QX@Gy@@NU@5?@/ hۋ@(\)@u@6C@Ʌoi@
5Xy>@p:@YJ@tj@2W@2W@{J#9@@ 4m9@!.H@(@C-@!-w2@m\@v@x@ߤ@@ҽ<64@O;dZ@Ƨ-@JM@s@H˒@~$@>B@(@rGE8@?@@t@y@҈p;@p:@}<64@vz@t9XbN@m\@be+@\ߤ@@Xtj@U*0@Q_p@M@JL/{@CF]c@@     @<64@73@6}Vl@4j~@1u!S@/{J#:@*~"@&,<@,<@O;d@hr @_@	Q@E84@-@Zc@g	l@C]@S@b}@حU@Ձ$/@nO@Mj@L_@YJ@:S@Q@ ě@-V@C]@IQ@Z1@A [@n.3@`A@҈p;@Ov_خ@ce@N;@wkP@|@$tS@*0U2@
M;@:)z@K]d@@I^5@|PH@s33333@p
=q@m(@j~"@g/V@a.H@`u!@]cA @X*0@V@TFs@RT`d@Q_p@FYJ@<Z@3E@2 ě@1&x@/@+~($@҈p;@*0@$tS@+J@$/@`d@*0U@m\@a@@Z@`A@3@o@R<6@o@e+@e+@.H@u!@'RT`@U=@o@ݗ+j@څݘ@Ϫ͟@䎊@Ж@5Xy>@)^	@ԕ*@@Zc@$tS@b@!.H@#x@m]@XbM@!R@ߤ@a|Q@l@w1@~"@>BZc@A [@[6@,=@]ce@l!-@<64@X@o @I^5?@'RTa@@E84@ݗ@a@N@|hs@|#x@{lC@zxl"h
@zC\@z^5?|@zxl"h
@zS&@z)y@yD@z@vFs@n2X@eڹ@a|Q@Zu%F@T*1@O@JڹY@F?@B@?$tS@>\N<@=v@=v@=K]@<쿱[@;J#9@:C\@9=b@84֡b@8}H@6C-@3MjO@1[W>6@.1@+Q@(ۋq
@#S@!@N@!-w1@ 	k@ -
@쿱[W@cA @|@@@O;d@Ϫ͞@`A7@qi@˒:*@@$t@
(@b@b@ڹZ@<64@J#9@XbM@Xy=@u!S@\)@M@쿱[W@1'@Ϫ͟@ӎMj@ңS&@\(@ξߤ?@(@]cA@ȴ9Xb@eO@y@y@?@JM@ߤ?@u!S@,<@e@Gz@ ѷY@E@X@
M;@@L_@@eO@$/@a@N@˒:)@xF@p{@o-V@m\@jfB@ilD@hTɅ@f'@cS@\N;@[$@XPH@MO;dZ@G#@@ѷX@>
(@=K]@:C\@4D@2W@-C\@)y@)Dg8~@(\)@)^@)^@)B@)y@)*0U2a@(ۋq
@)@)ᰉ'@(\)@(ۋq
@'fA@ u!@[@Q_@Ʌoi@$tT@;dZ@p:~@
M:@Ƨ@
ڹY@	ԕ*@&I@%2@TɅo@ߤ?@64@F]d@!.I@KƧ@+jg@Y|@SMj@-@w1@	k@n.3@ߊ	@cA @=K^@e+@bM@2a|@͸@Țu%F@@4n@s@!.@g@ᰊ@oiDg8@ ě@ ě@@zxl"@RT`e@@1@%1@bM@҉@R@|@!R<@]cA@@Fs@@M:@@@7Kƨ@$/@ [7@C@NU@.H@~\N<@|hr@{lC@{J#9@zC\@y~($@xYJ@xF]d@v!.I@rGE85@h@eS@d?@bM@`
qu@Z1'@SZ@O\(@N;5X@C@5!.@0
(@*d7@&@ d8@%@U@,<@hr @H@o @T@@	Q@F]c@C\@,<@Z@u!@5?|@6@֡af@˒:)z@5Xy@Xe@g	l@v@U=@@Q@[@e+a@sP@!R<@O;dZ@҈@_o@:S@r䎊q@]ce@Sa@O@P`A7@Ov_ح@IQ@B74@:S&@2ᰊ@0'RT@.2X@-V@&'@S@sP@~($x@eO@I^5@-
@s@(@`A7L@b}@m@т@5Xy>@ʌL_@,zxl@
(@A@#w@Q@YJ@4m@S@+j@4J@(@ԕ*@o h@{J#9@iDg8~@glC@eO
@`
qu@[6@TɅoi@H9Xb@:)y@73@7Xe@4J@12W@0
(@-U=@$?@U=@O;d@p:@
H˒@
F@
D@
@
t@
!-w@
C@
C@
!-w@
!-w@
(@
hr!@
Q@
>@
ӎMj@
@
@
NU@
6z@
/@
tj@
@
oiDg@
x-
@
sE@
qA [@
o hۋ@
jg	@
e`A7L@
dZ1@
cZ@
bC,@
ae@
a'R@
a'R@
be+@
ae@
be+@
ae@
a|Q@
^5?|@
TɅoi@
=K]@
0{@
*0
@
(TɅ@
'/V@
&L/{J@
$?@
"wkQ@
#
=p@
U=@
_o@
hr @
҈@
q@
%2@
@\@ק&@E@|@Ƨ@@84֡@g8}@7Kƨ@K]@'0@0
@
=p@䎊r@@@Vu@tj@u%F
L@o hۋ@dZ1@]cA @9~($@1o@.2X@*d7@%1@#n.3@ 	k@[@kP|@L_@	ԕ*@K]d@Fs@nP@m\@(@1@E@iB@ hۋ@!-w@唯O
@ѷX@ěS@
(@Y}@3@Xy=@2W@1@H@y@/@S@)^@L/{@Q@M:@IQ@vFs@n.2@jfB@irGE@be+@_;dZ@^҈p;@^ ѷY@Zc	@Yb}@XbM@W>6z@W&@W@P*0U@Gy@DS@B&IR@?|hs@=v@9D@-
qv@&IQ@"`A@!o@!-w1@U=@$tS@'/@YJ@nP@
G{@
%F
L@
@
ᰉ'@
@
eO@
5?|@
ڹY@
y=c@
>6z@
;dZ@
@
š@
NU@
p
=@
n.@
n.@
3@
'0@
2W@

(@
o@
y@
u@
?@
䎊r@
~($x@
ݗ@
@
@
~m\@
{m]@
mhr!@
d7@
[$@
WsPH@
Vt@
Sa@O@
R<64@
Rm@
RT`d@
E@
B74@
@n@
=b@
<쿱[@
8}H@
43@
.}Vl@
(TɅ@
$?@
 'RT`@
kP|@
nO@
\(@
ߤ?@
'/W@

(@
~($x@
@	@	!-w@	%1@	ڹY@	fA@	䎊@	5Xy>@	ɺ^5?}@	Q@	ߤ?@	D@	D@	~($@	֡a@	{J#:@	͞&@	d7@	*0U2a@	u@	@@	4J@	)^@	@	O;dZ@	C%@	p:@	u%F@	u%F@	1&x@	oiDg@	Q@	tj@	n.@	|Q@	{m]@	x-
@	wkP@	w1@	wkP@	vȴ9X@	vFs@	tD@	kC]@	\(\@	XD*@	UϪ͞@	Ks@	H@	N_o @	P{@	NT@	H@	B@	:S&@	-V@	(TɅ@	'&@	%S@	%S@	%S@	%1@	#S&@	쿱[W@	쿱[W@	쿱[W@	Q@	쿱[W@	%@	qu!@	@	u%F@	kP|@	u%@	vȴ@	_o@	@	kP|@	,<@	vȴ@	u%@	e+a@	\(@	u%F
@Vl!@~$@xl"h
@@@	k~@l"h	@+@+@_ح@E@B@`A7L@7@A [@1.@7@@4@S@C,@"`B@Ϫ͞@@6@|hs@@rG@1@<쿱@y@͞&@*0U2a@?@/@tSM@	@_o@u%F@+j@O;d@O;d@Xe,@+j@+j@*0@Ov_@*0@@o h@l!-w@b}Vm@+U=@
=p
@$tS@@䎊q@73@JL@@Ft@>6z@ӎMj@_p@Ϫ͟@حV@C,@d8@M@ܑN;@R@ҽ<64@ӎMj@As@5Xy>@s@@@6z@H˒:@|hs@4֡b@sg@J@?|h@^@wkQ@O;d@*0@Fs@@ݗ+k                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        @?@?حV@?@?@?@?@?	k@?a|Q@?nP@?tj@??@?,@?rGE8@?ɭB@?y@?F@?#@?Xe,@?&I@?@?ŵsh@?8YK@?@?
=p@?쿱[W@?@@?D@@bM@@v_ح@@-V@@$,<@@)@@1-@@9e+a@@:ڹY@@;~($@@=`A7L@@>p:~@@@4m@@B6C@@CnP@@DL_@@Dj~@@EV@@E}H@@G hۋ@@GsPH@@G&@@Gb}V@@GO
M@@Go@@GkP@@H
qu@@HѷX@@IQ@@IY}@@J6C@@JqiC@@Jn@@Jc	@@K	@@K҈@@K@@KxF]@@K/V@@KMj@@L[W?@@Mqu"@@MfA@@M\(@@N ѷY@@N$/@@P     @@Q|@@SW>6z@@Ub@@W4֡a@@X@@[%2@@]fA@@]o i@@\1&y@@Y~($@@W4m@@Yo hی@@_iDg8@@a^@@h\)@@lL_@@nBZc @@o_o@@t~($x@@x
=q@@yᰉ'@@|Q@@|Q@@|S@@}oiDg@@}
qv@@}v@@}+j@@~}Vl@@<64@@+J@@C,z@@jOv@@YJ@@IQ@@s@@$@@K]c@@JM@@@N@@C,zx@@qi@@쿱[W@@-
q@@J@@ԕ*@@\N@@zxl"h@@ߤ?@@@@C%@@Ŏ!R@@As@@@@8}H@@0
)@@ҹY@@7@@s@@.H@@׆&@@4m9@@	k@@ae@@~@@cA \@@*0@@S&@@ce@@ݸ@@?@@_ح@@ާ-@@t@@]cf@@!.I@@
M;@@Xe@@RT`e@@4J@@ⅇݘ@@m\@@,zxl@@=K^@@qu!@@㕁$@@㕁$@@S@@:)z@@Ƨ@@SMj@@wkP@@sg@@cA @@BZc @@m\@@椨T@@旍O;@@+J@@qi@@\N<@@.2@@t@@[W>@@eO@@_p@@_o@@C\@@xl"h
@@L/{@@Y@@꩓@@<64@@c	@@:)z@@2W@@q@@-V@@sg@@퇓ݗ@@t@@ hۋ@@Ft@@
=p@@ hۋ@@"@@"@@!.I@@1@@@@@@!.I@@,@@
(@@N;6@@҉@@*0@@cA @@!.@@(@@M:@@O;dZ@@[@@j~@@o i@@4K@@+jg@@ȴ9X@@@@@@1@@Fs@@C-@@ߤ?@@҈p;@@ߤ?@@ߤ?@@x@@Fs@@+@@Fs@@'/W@@o@@O;d@@[W>@@حV@@䎊r@@     @@:~ @@'RT@@҈p@@rGE@@(@@s@@-V@@Zc@@,<@@PH@@S@@ߤ@@~($@@A [@@(\@@<쿱@@I^5?@@M:@@Z1@@wkP@@O
M@@!-w@@5Xy>@@F
L0@@Y|@@ڹZ@@,=@@!R<@@($x@@?@@R<6@@ ѷY@@@@}H@@w1@@}H@@+j@@?@@%@@)^@@_o@@4m@@@@-V@@$tS@@{J#:@@[W>@@حV@@@A 
qu@A F]d@A @A 	ԕ+@A }H@A NU@A YJ@A y=c@A @@A@AR<6@A|@A"`@A"`@Ae@A@As@As@AZc@AS&@A,<@AP{@Ajf@A$@Aq@Am]@AE@Am]@Aq@A5Xy@An.@A\N@A64@AM:@AVϪ@AVϪ@A`d@Ao h@AɅoi@Ahr@Au@A[@A@AJM@A!-w@A:@A!.H@AY|@AjOv@Ace@AS&@AS&@AS&@Am\@AS&@A!.H@A%F
L@Ao i@AL_@A!R@A_ح@Avȴ9X@Aȴ9X@AMj@A@Ax@AFt@A1@A@A@Ax@AC-@AϪ͟@AA@A@A$tS@A+I@A+I@A+I@AAs@A\(@AU=@ART`e@A_o@A	@A͞@A/V@A@A-@A:~ @AH@AU2a|@Au!@A'RT@Au%F@A
(@ATɅ@ATɅ@A@@AѷX@AC@A{@A	@A	-w1@A	7KƧ@A	o hی@A	|Q@A	|Q@A	o@A	o@A	@A	'R@A	"`@A
e+@A
1'@A
:)y@A
JL@A
GE85@A
GE85@A
W'@A
h	ԕ@A
qiC@A
ݘ@A
p:@A
ᰊ@A
vȴ@A
g	@A
)_@A
@A
G{@AF]c@A]cA@AW>6z@AdZ@AA@AZ@A@A9XbN@Aj~#@A1&@A@A!-w@A
!.H@A
2a|@A
<64@A
L_@A
O;dZ@A
L_@A
IQ@A
S&@A
fA@A
}H@A
%@A
sh@A
H˒@A
n/@A

qv@A ѷY@A5?|@AL/{J@A\N<@As@Avȴ9X@A+J@A,<@A-@AT@A-@A6z@Aߤ?@A҈p;@Aߤ?@AFs@A'/W@A\(@A+@AVϫ@A	ԕ+@A4m9@Ar Ĝ@AYJ@Atj@AU@AěT@A҈p@A@A@N@A@A0
)@AGz@AXbM@Aae@Ax@AoiD@A(@AX@AlD@As@A:)y@AQ_@Aa|Q@AkP|@Au%F
@A0
@A~@AC,z@A9@Ag	l@Aa@N@Atj~@AQ@AA@A*0U2@A5Xy@AlC@AL_@A/{J#@A?@APH@AcA \@Aq@AtSM@AwkP@AzG@AN;@AN;@A*1@A*1@A쿱[@A1&@A#x@A?@A>B[@AJM@A:@Au@A!.H@AIQ@Azxl"h@Aݗ@A=K@A@Ash@A8YK@A
qv@AE@A
(@A
L/@AOv_@A+jg@A5?|@A%@A&I@AMj@A!.I@A hۋ@A
M;@A1@A&@A͞@AzH@AzH@A/V@Ao @A-@A4m9@Aۋq
@A ѷ@A@A@A+@A_p@A@A#w@A*0U2a@A0
)@A:S@A:S@AA [@AGz@ATɅo@Au!S@Ao@A@A2W@AiB@A>BZ@AY}@An@A6C@AM@A^5?|@Ad7@Ah	ԕ@Au%F
@A@4@A0
@A@Ag	@A}Vm@AsP@AG{@Am@APH@A/V@A=K^@AF]c@Atj~@AeO@A:)z@AU=@AE@A5Xy@A|@AQ@Ag@A\N@Atj@A"h	ԕ@A"h	ԕ@A,<@A(\@A(\@A,<@A,<@A,<@A/{J#@A,<@AC,zx@Am8@A*1@A3@AZ@AD@Au@A<64@Aݗ@Ash@Ab@Aᰉ@Aᰉ@AE@Aڹ@At@A
L/@A@Au@AOv_@A$/@A+jg@A?@AH@A_ح@Avȴ9X@A+J@A6z@AQ@A@A@A@Am\@AA@A쿱[W@A쿱[W@A"@AFt@A!-w1@A.H@AO
M@A4m@A&@A&@A	@A&@AO;d@AO;d@A	k@A͞@AK]d@A@A 6@A :~ @A Q@A r Ĝ@A YJ@A IQ@A 
=q@A {@A {@A )@A ѷX@A `A7@A ҈p@A e+@A e+@A @A \)@A! [7@A!e+a@A!B@A!@A!2W@A!@A!Y}@A!.H@A"I^5@A"@A"Ov`@A"䎊@A"䎊@A")y@A"6C@A"C\@A"{m@A"vȴ@A"wkQ@A"L/{@A"@A" ě@A"}Vm@A")_@A"G{@A#I^@A"m\@A#nP@A#C%@A#g	l@A#:)z@A#A@A#U=@A#Z@A#ݗ+k@A#lC@A$xF@A$%1@A$(\@A$(\@A$(\@A$(\@A$,<@A$,<@A$2W@A$9XbN@A$9XbN@A$2W@A$PH@A$`d@A$wkP@A$1&@A$?@A$7@A$/@A$E@A%:@A%'0@A%*0@A%qu"@A%!.H@A%+a@A%IQ@A%`A7L@A%zxl"h@A%ݗ@A%ݗ@A%hr!@A%hr!@A%hr!@A%hr!@A%O
@A%O
@A%@A%\(@A%,=@A&t@A&u@A&($x@A&;5X@A&Ov_خ@A&Vu@A&iB@A&T@A&ȴ9X@A&@A'v@A'$tS@A'1@A'8}H@A';dZ@A'>6z@A'>6z@A'E84@A'\(@A'|hs@A'&@A'&@A'kP@A(F]d@A( ě@A('RT`@A(4m9@A(H@A(l"h	@A(@A(-
@A({@A(
(@A(ěT@A(ѷX@A(ۋq
@A(e+@A(`A7@A(@A(C@A(	k@A(PH@A)	k~@A)_p@A) [7@A)#w@A)&x@A)0
)@A)7KƧ@A)Dg8~@A)o hی@A)'RTa@A)'RTa@A)(@A)B@A)^5?}@A)@A)e@A)>BZ@A)R@A*s@A*:)y@A*GE85@A*a|Q@A*nO@A*xl"h
@A*ᰊ@A*L/{@A*g	@A*`A@A* ѷ@A*G{@A*m\@A+PH@A+)^	@A+33333@A+C%@A+J#9@A+S@A+Z@A+]cA@A+dZ@A+n.3@A+Q@A+S@A+@A+~($@A+Z@A+6@A+a@@A+҈@A+҈@A+C]@A,J@A,ߤ@@A,xF@A,L_@A,Q@A,,<@A,I^5?@A,q@A,#@A,N;@A,*1@A,3@A,1&@A,[W?@A,@A,*0@A,֡a@A,>B[@A,JM@A-:@A-qu"@A-%F
L@A-+a@A-?|h@A-Y|@A-\@A-jOv@A-$/@A-%@A-U=@A-1@A-n/@A-n/@A-@A-ᰉ@A-(@A-oiDg@A-E@A-E@A-C\@A.1.@A.Ov_خ@A.\N<@A.c	@A.fffff@A.vȴ9X@A.$t@A.Q@A.Q@A.ߤ?@A.t@A.Ϫ͟@A.x@A/
M;@A/.H@A/1@A/.H@A/8}H@A/>6z@A/E84@A/KƧ@A/lC@A/lC@A/4m@A/͞@A/˒:)@A/@A/حV@A/@A/Vϫ@A/䎊r@A/䎊r@A/䎊r@A/-@A/-@A/䎊r@A/䎊r@A/rGE9@A0*0@A0H@A0bM@A0r Ĝ@A0@A0p:@A0҈p@A1rGE@A1+@A1=b@A1^@A1hr @A1o hی@A1u!S@A17Kƨ@A1@A1u@A1u@A1n.@A1B@A1B@A1'R@A1'R@A1'R@A1B@A1|@A1|@A1y@A1@A2=p
@A2W'@A2kP|@A2kP|@A2kP|@A2kP|@A2h	ԕ@A2h	ԕ@A2nO@A2xl"h
@A2@4@A2\(@A20
@A2vȴ@A2<64@A2n@A3I^@A3/V@A3/V@A39@A3@N@A3J#9@A3MjO@A3MjO@A3S@A3Z@A3n.3@A3Q@A3$@A3wk@A3m]@A3@A3\N@A41&y@A4Q@A4!-w2@A4,<@A4j~#@A4tSM@A4tSM@A4zG@A4?@A4#@A4#@A4_@A4쿱[@A4O
M@A47@A4?@A4Ʌoi@A4>B[@A4@A4!-w@A4D@A4>@A5:@A5K]@A5'0@A5!.H@A5L_@A5fA@A5m\@A5w1@A5zxl"h@A5$/@A5!R@A5O
@A5hr!@A5%@A5U=@A5\(@A5b@A5,=@A5(@A5S@A6t@A6@A6!R<@A6($x@A6$/@A68YJ@A6;5X@A6?@A6BZc @A6E@A6E@A6L/{J@A6L/{J@A6H@A6Ov_خ@A6fffff@A6p:~@A6vȴ9X@A6IQ@A6%@A6%@A6$t@A6af@A6}Vl@A6}Vl@A6'@A62X@A6ߤ?@A6]cf@A6Mj@A6!.I@A6!.I@A7Ft@A7
=p@A7Xe@A7'/W@A7.H@A7;dZ@A7KƧ@A7O
M@A7RT`e@A7\(@A7iDg8@A7lC@A7v_ح@A7{J#:@A7	@A7	@A7O;d@A7$tS@A7	k@A7&@A7zH@A7͞@A7@A7o @A7K]d@A7@A7䎊r@A7#@A8F]d@A8F]d@A8	ԕ+@A8
qu@A8-
q@A873@A8U2a|@A8[6@A8_F@A8bM@A8hۋq@A8l"h	@A8u!@A8YJ@A8'RT@A8-
@A8-
@A8tj@A8@A8u%F@A8@A8{@A84m@A8
(@A8)^@A8F@A8F@A8F@A8D@A8҈p@A8e+@A8PH@A9@A9@A94J@A9Dg8~@A9Q@A9XbM@A9e+a@A9ae@A9hr @A9@A9oiD@A97Kƨ@A9oiD@A9R<6@A9'RTa@A9(@A9l@A9|@A9D@A9iB@A9ᰉ'@A9ᰉ'@A9e@A9R@A9R@A9s@A9s@A9s@A9Y}@A9lD@A9-@A9.H@A:n@A:s@A:I^5@A:e+@A:1'@A:䎊@A:#9@A:e+@A:䎊@A:&IR@A:=p
@A:^5?|@A:d7@A:d7@A:xl"h
@A:xl"h
@A:nO@A:kP|@A:qiC@A:~"@A:ݘ@A:0
@A: ě@A:g	@A:g	@A:}Vm@A:}Vm@A:}Vm@A:Y@A:@A:W@A:W@A:W@A:W@A:)_@A:W@A:,<@A:,<@A:sP@A:sP@A:`A@A:,<@A:,<@A:ڹY@A:,<@A:ڹY@A:sP@A:,<@A: ѷ@A:~@A;҉@A;nP@A;nP@A;s@A;s@A;PH@A;PH@A;PH@A;	@A;	@A;"`B@A;)^	@A;@N@A;J#9@A;C%@A;F]c@A;@N@A;J#9@A;P{@A;J#9@A;MjO@A;]cA@A;qu!@A;q@A;eO@A;Mj@A;Mj@A;U=@A;m]@A;E@A;E@A;E@A;~($@A;a@O@A;a@O@A;a@O@A;
=p@A;ݗ+k@A;
=p@A;ݗ+k@A;Q@A;Q@A;Q@A;ݗ+k@A;ݗ+k@A;҈@A;%2@A;ݗ+k@A;%2@A<1&y@A<,<@A<C,zx@A<zxl"@A<u"@A<>@A=V@A<E@A=o i@A=!.H@A=qu"@A=84֡@A=B@A=B@A=F
L0@A=<64@A=+a@A=+a@A=/w@A=(@A=?|h@A=L_@A=IQ@A=O;dZ@A=L_@A=O;dZ@A=S&@A=fA@A=jOv@A=m\@A=m\@A=m\@A=zxl"h@A=}H@A=$/@A=M:@A=@A=Xy=@A=@A=H˒@A=n/@A=H˒@A=H˒                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        @rT@rT@rY@rVfffff@rS33333@r[33333@rY@rT@rX     @rQ@rK33333@rK33333@rT@r\@ra@rnfffff@r{33333@rfffff@r33333@r@r     @rfffff@ra@r33333@q     @qd@qP     @qP     @q0     @p33333@p@pfffff@p33333@pfffff@pfffff@p     @p{33333@p{33333@p@pfffff@pfffff@p@p     @p@pfffff@p@p33333@pfffff@pfffff@pљ@p     @p@p@p@p@pfffff@p     @p@p@p33333@p33333@pfffff@pfffff@p33333@p33333@p33333@p@p@p@p@p@p33333@o陙@offfff@o@op     @oL@o<@offfff@p@pfffff@q@p^fffff@offffff@o6fffff@o33333@o     @nfffff@my@kə@k33333@k     @l333333@ll@l)@k     @k     @kə@k33333@k陙@k@kfffff@h     @h      @g@h@     @h33333@hٙ@hfffff@h33333@efffff@efffff@f9@f@f33333@f33333@d     @d     @d     @d33333@d@     @c33333@ci@c      @bfffff@b<@bfffff@a陙@a@a33333@avfffff@al@ac33333@ap     @a33333@ap     @aI@aL@aP     @aP     @aC33333@a<@a9@a333333@a0     @a0     @a333333@a9@a9@a333333@afffff@`fffff@`@`33333@`@`     @`ٙ@afffff@a     @a)@avfffff@a@afffff@a333333@`@`     @a,@a&fffff@a#33333@a9@a     @by@b     @c&fffff@c9@c@b33333@bfffff@b     @b33333@bə@b@b33333@cfffff@c#33333@c@c     @c      @b33333@bi@bi@a@aP     @aC33333@aP     @aI@aY@a`     @avfffff@aə@b33333@bfffff@b&fffff@a@`ffffff@`vfffff@_333333@[33333@Y@Z33333@[@Zfffff@Zl@Z     @Z33333@[,@Y      @X     @X@W33333@Wٙ@Wfffff@W     @WY@W@     @WFfffff@W9@W@Vfffff@V@V@Vs33333@V@Uy@UL@U,@U      @U333333@U33333@T@Tfffff@Tfffff@T33333@Ts33333@T@     @T,@T&fffff@S     @S     @S@S`     @S@R33333@Rl@RL@RFfffff@R@     @R9@R@Q@Q33333@Q@Qfffff@Q`     @Q9@Q@Q      @P     @Pfffff@P@P@Pٙ@P     @P@P33333@P33333@P@Pl@P333333@O      @Nٙ@N@N@N@N@Ns33333@N@     @M33333@Mٙ@M@M@M     @M@Mffffff@M333333@M&fffff@L33333@LL@K@K@K     @Kffffff@K@     @K&fffff@K@K@Jٙ@Jffffff@I33333@I@Ifffff@Ifffff@I@I&fffff@I&fffff@I@I      @I      @Hٙ@H     @H@H     @Hs33333@HY@HY@H333333@H      @Gٙ@G@G     @Gs33333@Gffffff@Gffffff@Gffffff@GL@G@F33333@Fٙ@Fٙ@Ffffff@Fٙ@Fٙ@F@Ffffff@G      @G@G@G      @FY@FL@F333333@F@E@E     @Effffff@E@     @E333333@E&fffff@E&fffff@E@E@E&fffff@E&fffff@D33333@D     @D@D     @D     @D     @DY@DY@DL@DL@D&fffff@D@Cٙ@C33333@C33333@C     @C     @Cfffff@CY@Cffffff@CY@CY@CL@C      @C      @B33333@B33333@Bfffff@B     @Bfffff@Bfffff@B     @BL@BL@Bffffff@BY@B&fffff@B      @B      @B@B@B      @A@A@A@As33333@AY@AL@AY@AL@A@     @A&fffff@A&fffff@A&fffff@A&fffff@A@@@@fffff@@@@L@@      @?33333@?     @?L@?333333@>@>L@>      @>@>L@>@>      @=33333@=@=@=@=ffffff@=L@=333333@=333333@=333333@=L@=333333@<333333@<333333@<@<      @;@;33333@;@;     @;@;@;ffffff@;L@;@;      @:33333@:     @:L@9fffff@9@9ffffff@9L@9      @8@8fffff@833333@8ffffff@8333333@8L@8      @7fffff@733333@733333@7@733333@7     @7L@7333333@7333333@7L@7      @6L@6L@6L@6333333@6333333@6L@533333@5     @5@5@533333@5@5      @5      @5      @4fffff@5      @5      @4@4333333@4333333@4L@4@4@4      @4@3fffff@3@3@3fffff@3fffff@3fffff@3     @3ffffff@3ffffff@3ffffff@3L@3L@3333333@3      @2fffff@233333@233333@233333@233333@2     @2L@2L@2L@2L@2L@2333333@1@1     @1ffffff@1L@1L@1L@1      @0@0@0@033333@0     @0ffffff@0L@0333333@/@/333333@/      @.@.@.@.@.@.@.ffffff@.ffffff@.ffffff@.333333@.ffffff@.ffffff@.333333@.333333@.      @-@-@-ffffff@-ffffff@-@-333333@-      @,@-      @,@-      @,@,@,@,@,@,ffffff@,333333@,      @,333333@,      @+@+@+@+ffffff@+ffffff@+333333@+333333@+333333@+333333@+      @*@*@+      @*@*@*ffffff@*@*@*@*@*ffffff@*ffffff@*@*@*@*      @)@)@)ffffff@)ffffff@)ffffff@)333333@)      @(@(@(@(@(@(@(ffffff@(ffffff@(@(ffffff@(@(ffffff@(@(@(333333@(      @(      @(333333@(      @(      @'@'@'@'@'@'@'@'333333@'@'ffffff@'333333@'ffffff@'333333@'      @'      @'      @&@'      @'      @'      @&@&@&@&@&@&333333@&333333@&      @&      @&      @%@&      @&      @&      @&      @%@%@%@%@%@%@%333333@%333333@%333333@%      @$@%      @%      @$@$@$@$@$@$@$@$@$@$ffffff@$ffffff@$333333@$333333@$ffffff@$ffffff@$333333@$      @$      @$      @$      @$      @#@#@#@$      @#@#@#@#ffffff@#ffffff@#@#ffffff@#ffffff@#ffffff@#333333@#ffffff@#ffffff@#333333@#333333@#@#333333@#ffffff@#333333@#333333@#333333@#      @#333333@#333333@#      @#      @#      @#      @#      @"@#      @#      @#      @"@"@"@"@"@"@#      @"@"@"@"@"@"@"@"@"@"@"@"@"ffffff@"ffffff@"ffffff@"@"@"ffffff@"333333@"ffffff@"333333@"333333@"333333@"ffffff@"      @"ffffff@"333333@"      @"333333@"      @"      @"333333@"      @"      @"      @"333333@"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"333333@"      @"      @"333333@"      @"      @"      @"      @"      @!@"      @"      @!@!ffffff@"      @"      @"      @!@"      @"      @"      @"333333@"      @"      @!@"      @"      @!@!@!@"      @"333333@"      @!@"      @!@"      @"      @"      @"      @"333333@"      @"      @"      @"      @"      @"      @"      @"      @"333333@"      @"333333@"333333@"333333@"333333@"ffffff@"333333@"333333@"333333@"333333@"333333@"ffffff@"ffffff@"ffffff@"ffffff@"ffffff@"333333@"ffffff@"ffffff@"ffffff@"@"@"@"@"@"@"@"@"@"@"@"@"@"@"@"@"@#      @"@#      @#      @#      @#      @#333333@#333333@#333333@#333333@#333333@#333333@#ffffff@#333333@#333333@#333333@#333333@#ffffff@#ffffff@#333333@#ffffff@#ffffff@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@$      @$      @$      @$      @$@$@$333333@$      @$333333@%      @$@$@$@$@$@%      @$@$@$@$@%      @$@$@$@$@$@%      @%333333@%ffffff@%333333@%333333@%333333@%ffffff@%333333@%ffffff@%333333@%333333@%ffffff@%@%@%ffffff@%@&      @&      @&      @&      @&      @&      @&333333@&333333@&ffffff@&ffffff@&@&ffffff@&ffffff@&@&@&@&@'      @&@'333333@'333333@'333333@'333333@&@'@'@'@'@'@'@(      @(ffffff@(333333@(ffffff@(333333@(      @(333333@(@(333333@(ffffff@(ffffff@(@(ffffff@(@(@)      @)      @)333333@)333333@)      @)333333@)333333@)ffffff@)333333@)ffffff@)333333@)@)@)@)@)@)@*ffffff@*      @*      @*333333@*      @*333333@*ffffff@*ffffff@*@*ffffff@*ffffff@*ffffff@*ffffff@*@*@*@*@*ffffff@*@*@*@+333333@*@*@+      @+ffffff@+333333@+      @+      @+333333@+@+ffffff@+@+@,      @+@,      @,      @+@+@,ffffff@,333333@,      @,333333@,333333@,ffffff@,ffffff@,ffffff@,ffffff@,@,ffffff@,@,@,@,@,@,@-333333@,@-333333@-ffffff@-ffffff@-@-@-ffffff@-@.333333@.      @.      @.      @-@.      @.      @.      @.333333@.      @.      @.333333@.ffffff@.ffffff@.ffffff@.@.@.@/      @.@.ffffff@.@/333333@/333333@/333333@/ffffff@/      @/      @/@/@0      @/@/@/@0      @0      @0      @0@0      @0333333@0333333@0@0@0L@0L@0L@0ffffff@0L@0     @0ffffff@0     @0     @0     @0ffffff@0     @0ffffff@0@0@0     @0@0     @0@033333@0@0@033333@033333@033333@0fffff@1      @0fffff@0fffff@0fffff@0fffff@1      @1@1@0fffff@1      @1333333@1333333@1ffffff@1ffffff@1L@1333333@1ffffff@1ffffff@1ffffff@1ffffff@1ffffff@1ffffff@1ffffff@1ffffff@1ffffff@1     @1     @1     @1@1ffffff@1ffffff@1     @1@1ffffff@1     @1     @1@1@133333@1@133333@1@1@1@1fffff@1@1@1fffff@1fffff@1@1fffff@2      @1fffff@1fffff@1fffff@1fffff@1fffff@1fffff@2      @2      @2333333@2333333@2333333@2333333@2L@2333333@2L@2ffffff@2ffffff@2@2ffffff@2ffffff@2@2@233333@2@2@233333@233333@233333@2@2@2@2@2@233333@233333@2fffff@2fffff@3@3ffffff@3@4      @3fffff@3fffff@4      @4@4      @4      @4@4L@4333333@4333333@4333333@4333333@4333333@4L@4L@4L@4333333@4L@4L@4L@4ffffff@4@4     @4@4     @4     @4@4@433333@4@433333@4@433333@4@4fffff@4fffff@5      @4fffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ?ܛS?n?~"?I^5?}?KƧ?O;dZ?tj~?\(?KƧ?333333?Q?tj~?ݲ-V?۶E?
=p?I^5?}?$/?Q?E?$/?/w?GzH?Q?E?1&x?-V?xF?1&y?      ?7KƧ?O;dZ?r ě?旍O;d?+?Ƨ-?/v?Z1'?
=p?+?j~"?      ?nP?`A7K? ěT?p
=q?1&?(\)?o?E?tj? ěT?O;dZ?߾vȴ9X?ڏ\(?$/?1&x?1&x?֗O;d?KƧ?ָQ?Vu?Ԭ1&y?zG?m?Vu?A7Kƨ?tj?O;dZ?Ձ$/??|hs?bM?E?ԋC%?j~"?S?M?׮zG?GzH?ם-V?S?1&x?zG?o?5?|h?p
=q?S?I^5?\(?
=p?9XbM?׮zG? ěT?r ě?GzH?dZ1?~"?$/?ش9XbN?bM?333333?݁$/?I^5?}?`A7?$/?֗O;d?+?Vt?Vt?Z1'?$/?Q?\(?ΗO;d?lC?
=p?I^5?}?E??\(\?hr!?Ѻ^5?|?ӥS?^5?|?+?ΗO;d?θQ?/v?Vu?|hr?̋C%?+?"`B?r ě?^5?|?ʟvȴ9?^5?|?ļj~#?QR?ȓtj~?Ƈ+I?1&x?ȴ9XbN?bM?"`B?QR?E?tj?bM?1&x?xF?-V?r ě?S?Q?šo?tj?Q?zG{?tj?lC?bM?Ƈ+I?$/?tj?$/?Ƈ+I?\(?
=p?$/?333333?tj?Ł$/?öE?Ƈ+I?Z1'?`A7K?n?Q?$/?nO?ȴ9Xb?šo?Z1'?I^5??+?`A7?tj~?`A7?Q?Õ$/?lD?nO?lD?333333?tj~?° ě?-V?nO;?;dZ?I^5??ěS?$/?l?tj?&x?öE?GzH?öE?lD?S?I^5??/w?E?
=p?zG{?/w?333333?l?Q?° ě?\(?
=p?nO?Z1'?l?tj~?Ł$/?ěS?M?nO;?\(?-V?öE?Õ$/?S?-V?l?nO;?/w?S?+?° ě?I^5??ȴ9Xb?`A7?l?+?zG{?tj?° ě?S?333333?
=p?
=p?333333?zG{?Ł$/?333333?ěS?nO?S?E?l?nO?tj?n?öE?Q?9XbM?šo?ěS?+?\(?Õ$/?l?tj?ļj~#?tj?333333?öE?-V?M?
=p?-V?l?ěS?Ł$/?l?n?9XbM?7KƧ?\(?öE?tj?° ě?öE?9XbM?333333?l?-V?nO?Õ$/?`A7?
=p?`A7?ļj~#?öE?nO?l?-V?\(?7KƧ?ěS?E?zG{?Q?lD?nO?öE?l?333333?333333?° ě?S?I^5??S?`A7?M?9XbM?ěS?9XbM?+?GzH?9XbM?tj~?
=p?Q?° ě?E?l?hr Ĝ?nO;?I^5??Ł$/?-V?+?° ě?öE?A7Kƨ?-V?lD?I^5??S?tj~?l?\(?tj~?
=p?° ě?I^5??vȴ9X?S?nP?n?
=p?Q?tj~?`A7?Õ$/? ěT?"`?tj~?M?+?I^5??tj~?\(?
=p?hr Ĝ?° ě?° ě?nO?tj~?&x?Q?+?\(?`A7?-V?`A7?Q?GzH?\(?7KƧ?ěS?/w?I^5??-V?9XbM?n?A7Kƨ?lD?M?Z1'?9XbM?ěS?E?
=p?333333?nO?lD?+?nO;?Z1'?+?`A7L?lD?9XbM?GzH?nO?Õ$/?ļj~#?Z1'?+?&x?Õ$/?Q?x?tj~?-V?-V?tj~?n?
=p?n?S?Z1'?-V?tj?öE?nO;?333333?-V?M?l?\(?E?tj?öE??|hs?+?333333?`A7?Õ$/?l?nO?öE?° ě?`A7?öE?Q?S?`A7?tj~?° ě?333333?nO;?tj~?öE?GzH?333333?+?\(?+?9XbM?
=p?333333?GzH?S?ļj~#?nO?tj~?Ł$/?
=p?Õ$/?zG{?`A7K?\(?Õ$/?öE?Õ$/?333333?nO?/w?M?9XbM?tj?tj~?öE?Z1'?n?M?l?\(?`A7?`A7?`A7L?tj~?I^5??nO;?S?tj?l?° ě?öE?° ě?-V?7KƧ?I^5??ěS?7KƧ?5?|h?l?öE?ěS?$/?S?333333?öE?Z1'?öE?M?M?`A7?S?Õ$/?ěS?333333?l?nO?9XbM?l?° ě?Q?nO?E?Z1'?öE?l?Q?nO;?nO?nO?GzH?tj?zG{?zG{?tj~?`A7K?ěS?nO?333333?/w?\(?333333?° ě?I^5??9XbM?ěS?333333?n?\(?ffffff?+?S?Õ$/?I^5??$/?333333?E?n?tj~?nO;?333333?\(?tj~?tj~?nO?M?Z1'?Z1'?šo?l?nO?$/?`A7?öE?9XbM?9XbM?/w?
=p??|hs?I^5??hr Ĝ?\(?ěS?333333?tj?Z1'?Z1'?öE?Z1'?333333?Q?tj?
=p?zG{?Q?ěS?l?Õ$/?nO?zG{?E?ěS?9XbM?nO;?333333?Z1'?-V?333333?nO?nO?I^5??/w?333333?E?bM?šo?tj?\(?9XbM?S?+?zG{?;dZ?° ě?zG{?
=p?
=p?S?E?333333?l?tj~?Ƨ-?šo?333333?nO;?nO?tj~?
=p?ffffff?ěS?S?+?I^5??n?zG{?+?° ě?-V?nO;?öE?tj~?öE?Ł$/?ļj~#?ļj~#?ļj~#?
=p?9XbM?9XbM?
=p?9XbM?öE?S?tj?l?tj?nO;?zG{?-V?S?333333?9XbM?nO?ļj~#?tj?E?ěS?tj~?öE?Õ$/?E?x?
=p?9XbM?ěS?E?Q?9XbM?tj~?E?`A7?7KƧ?nO;?° ě?`A7?M?A7Kƨ?-V?`A7?$/?hr Ĝ?n?öE?° ě?Q?$/?S?/w?nO?l?l?`A7?tj~?hr Ĝ?-V?Õ$/?öE?+?S?tj?° ě?M?Q?lD?ěS?° ě?`A7L?öE?`A7K?tj~?l?333333??|hs?\(?-V?öE?šo?
=p?Z1'?l?+?333333?öE?S?S?° ě?333333?9XbM?Õ$/?\(?l?ěS?tj~?GzH?l?+?nO;?\(?+?333333?S?Õ$/?M?S?öE?7KƧ?`A7?Q?Õ$/?`A7?tj~?nO?l?M?`A7?zG{?tj?-V?öE?l?ěS?Q?ļj~#?-V?333333?nO?zG{?I^5??+?+?Q?tj?öE??|hs?
=p?ffffff?Q?/w?-V?-V?Q?öE?I^5??M?$/?ļj~#?
=p?tj?I^5??ěS?9XbM?nO;?öE?-V?nO;?E?Z1'?Z1'?\(?Õ$/?
=p?E?/w?ļj~#?Z1'?ěS?nO;?tj~?9XbM?ļj~#?Z1'?tj~?9XbM?Ƨ-?öE?öE?M?öE?nO;?$/?tj?tj~?ěS?7KƧ?Õ$/?/w?/w?nO?nO?n?zG{?\(?S?\(?\(?öE?n?333333?l?S?šo?333333?E?° ě?S?ļj~#?E?ļj~#?öE?Õ$/?`A7?
=p?nO;?° ě?`A7L?nO?öE?öE?+?ěS?333333?-V?333333?-V?9XbM?tj~?l?9XbM?öE?Õ$/?° ě?nO;?S?M?tj?S?M?S?-V?Q?\(?\(?l?° ě?° ě?Õ$/?`A7?nO;?`A7?333333?\(?hr Ĝ?nO;?hr Ĝ?`A7?&x?° ě?ļj~#?ļj~#??|hs?nO?ļj~#?
=p?° ě?tj~?öE?öE?+?`A7?S?7KƧ?tj?hr Ĝ?Õ$/?tj~?nO?ěS?l?-V?M?M?nO?\(?n?nP?ěS?+?S?9XbM?Ł$/?Õ$/?9XbM?`A7?ěS?$/?333333?
=p?+?nO;?Q?I^5??`A7?tj?-V?Õ$/?ěS?ěS?-V?Z1'?Q?l?`A7L?Õ$/?`A7?n?ěS?nO?9XbM?öE?
=p?-V?tj?Q?nO;?l?
=p?tj~?\(?7KƧ?zG{?`A7L?/w?333333?
=p?Õ$/?nO?ěS?E?nO?\(?lD? ěT?ěS?öE?° ě?nO;?M?S?hr Ĝ?zG{?
=p?-V?/w?ffffff?Ł$/??|hs?
=p?M?
=p?° ě?9XbM?Q?ěS?Z1'?
=p?Õ$/?`A7?E?+?333333?\(?l?šo?Q?ěS?nO;?nO?S?9XbM?Q?Õ$/?
=p?tj?ǍO;dZ?ěS?nO?tj?tj?I^5??333333?7KƧ?öE?S?l?lD?Õ$/?lD?S?hr Ĝ?-V?Q?+?Q?nO;?tj?tj?-V?GzH?nO;?$/?GzH?Ƨ-?öE?;dZ?nO?Õ$/?Q?öE?$/?333333?l?tj~?ļj~#?Õ$/?l?+?Z1'?
=p?9XbM?9XbM?E?7KƧ?Z1'?nO?+?tj?`A7K?M?E?`A7?tj~?`A7?
=p?l?`A7?S?l?l?° ě?tj?tj??|hs?+??|hs?l?l?S?tj?nO?S?ļj~#?zG{?tj~?/w?+?Z1'?° ě?Q?tj?7KƧ?`A7?° ě?tj~?nO;?lD?-V?° ě?Q?tj~?ěS?Q?`A7?/w?öE?9XbM?S?Õ$/?Q?zG{?öE?S?`A7?$/?+?Z1'?ěS?
=p?333333?333333?
=p?tj~?/w?zG{?Õ$/?° ě?
=p?M?Õ$/?-V?-V?nO?\(?\(?öE?S?ļj~#?nO?tj~?&x?`A7?öE?ļj~#?Z1'?+?`A7K?S?hr Ĝ?M?tj?
=p?E?tj?S?`A7?öE?I^5??l?
=p?Õ$/?° ě?
=p?Õ$/?+?9XbM?° ě?nP?$/?I^5??-V?Q?l?M?-V?\(?vȴ9X?nO;?/w?9XbM?hr Ĝ?E?vȴ9X?Q?lD?&x?Õ$/?tj~?9XbM?\(?° ě?öE?l?ļj~#?tj~?S?9XbM?333333?tj?-V?tj~?
=p?n?\(?tj?Z1'?šo?l?Z1'?ěS?-V?9XbM?`A7K??|hs?Z1'?9XbM?Ƈ+I?öE?
=p?E?ļj~#?Z1'?\(?Ł$/?ffffff?S?S?Ƈ+I?+?ěS?+?9XbM?KƧ?ffffff?ffffff?bM?tj?Ƨ-?$/?E?E?$/                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	@O@O      @Nfffff@O@N33333@O      @O      @O@O      @Nٙ@O      @O@O&fffff@O      @O@O333333@Ns33333@N@O      @O333333@O      @N     @O@     @Os33333@O     @Offfff@OY@OY@O@Os33333@OL@O@O     @Os33333@N@N@OY@O@OL@OY@Offffff@O@O33333@Oٙ@O33333@Offfff@O33333@O33333@P      @P@P@P      @P@Offfff@O@P@P      @P&fffff@P333333@P9@P9@P@     @PFfffff@PFfffff@PFfffff@PFfffff@P333333@P      @P333333@P333333@P      @P9@P,@P,@P9@P,@P@P33333@P@Offfff@Pfffff@Pfffff@Pfffff@O     @O@O@Offfff@O     @OY@O     @O@O     @O@     @OL@O     @Oٙ@Offfff@O     @Offfff@O@Offfff@O33333@Offfff@O     @O@Oٙ@Offfff@Offfff@O33333@O33333@O     @O@Offfff@O33333@Oٙ@Oٙ@O@P      @P333333@PL@PS33333@PL@P9@PL@PL@PFfffff@P333333@PFfffff@P9@PL@PFfffff@PFfffff@PL@PS33333@PY@PS33333@PL@PS33333@PS33333@P`     @PL@PY@PL@Pl@Pffffff@P`     @P`     @P`     @P`     @Pffffff@Pl@Pffffff@Pl@Pl@Pl@Pl@Pl@P`     @PY@PY@Pffffff@Pffffff@Pffffff@Py@Ps33333@Pl@P`     @Py@Ps33333@Py@Ps33333@Py@Py@Py@Pffffff@Ps33333@Py@P@P33333@P@P33333@P@P     @P     @Pfffff@P@P     @P     @P33333@Pfffff@P@Pffffff@P@Pfffff@P33333@Pfffff@P@P@P@P33333@P33333@P@P     @P     @Pfffff@P@Pfffff@P33333@P@P     @P     @Py@Py@Py@P     @Pfffff@Pfffff@P     @Pfffff@Ps33333@Pffffff@PS33333@Ps33333@Pl@Pl@P`     @N@O@P9@P333333@P333333@P333333@Pfffff@O33333@O     @O33333@O@O     @O     @Os33333@Os33333@Os33333@O@O@O     @O@P33333@P@Pfffff@P@P&fffff@P@P      @O33333@P      @Pfffff@Offfff@P      @P      @O     @O33333@P      @P@P@P&fffff@P333333@P@     @PS33333@PS33333@PY@PY@PY@P`     @P`     @P`     @PS33333@P`     @P`     @P`     @PY@Ps33333@Ps33333@Py@Py@Py@Ps33333@PS33333@P     @Py@Py@P     @Py@Py@Py@P     @P     @Py@Ps33333@Ps33333@Py@Py@Py@Py@Py@PFfffff@P&fffff@Py@Py@Py@Ps33333@P     @Pfffff@P33333@P33333@P@P@Py@Pfffff@Pfffff@P     @Pfffff@P@Pffffff@P@P     @P@P@P@P     @P@P33333@P33333@P@P@P     @Pfffff@Pfffff@P@P33333@Pfffff@P@P@P33333@P33333@P33333@P     @Pfffff@P@Pfffff@P@P33333@P     @P     @P     @P@P     @P     @P     @P     @P     @P     @P@P@P33333@P33333@Pfffff@Pfffff@P33333@P33333@P@Pfffff@Pfffff@Pfffff@P@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P@P@Pfffff@Pfffff@P@P33333@P33333@P@P     @P@P33333@P33333@P@P@P33333@P     @P     @P@P     @Pfffff@Pfffff@Pfffff@P@P     @Py@P     @Pfffff@Pfffff@P     @P33333@Pfffff@Pfffff@Pfffff@Pfffff@P@P33333@P@P@P@P@P     @P@P     @P     @Pfffff@P     @P@P     @Pfffff@P@P@P@P     @Pfffff@P     @Pfffff@Pfffff@P     @P     @Pfffff@P@Pfffff@P     @P     @Pfffff@P@P33333@Pfffff@Pfffff@P     @P@P     @P     @P     @Pfffff@P     @P     @Pfffff@P@P33333@P@P33333@P33333@P@P     @P     @P     @P     @Pfffff@P     @P@P@Pfffff@P     @Pfffff@P@P@Pfffff@P@P@P@P@P@Pfffff@P33333@P33333@P33333@Pٙ@Pfffff@P@Pٙ@P33333@P@Pٙ@P@P33333@P     @P     @P     @P33333@P@P33333@P33333@P33333@P33333@P33333@P@P@P@P     @P@P@P@P@P     @P@P     @P     @P     @P     @P@P     @P     @Pfffff@Pfffff@Pfffff@P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P     @Pfffff@P@P33333@P@P@P33333@P33333@P33333@P33333@P33333@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@P33333@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@P33333@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pfffff@P33333@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@P33333@Pfffff@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@P33333@Pٙ@P     @P     @Pٙ@P     @P     @P     @P33333@P     @P     @P     @Pٙ@P     @Pٙ@P     @Pٙ@P     @P     @P     @P     @P     @Pٙ@P     @P     @Pٙ@Pٙ@Pٙ@Pfffff@P     @P     @Pfffff@Pfffff@P     @P     @P     @P     @Pfffff@Pfffff@P     @Pٙ@P33333@P33333@Pٙ@P     @P     @P     @P     @P     @P     @P     @Pfffff@P     @Pfffff@P     @P     @P     @P     @P     @P     @Pfffff@Pfffff@P     @P     @P     @P     @P     @Pfffff@P     @P     @Pfffff@Pfffff@P     @Pfffff@Pٙ@Pfffff@P     @P     @P     @Pfffff@Pfffff@P     @Pٙ@P     @Pfffff@P     @Pfffff@P     @Pٙ@Pٙ@Pfffff@P     @P     @P     @Pfffff@P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @P     @P     @P     @P     @P33333@Pfffff@Pfffff@P     @P     @P     @P     @P     @P     @Pٙ@Pfffff@P     @Pfffff@P     @P     @P33333@P33333@P     @P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pٙ@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@P     @P     @Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P33333@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @P     @P     @P     @Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pٙ@P     @P     @P     @P     @P     @P     @Pٙ@Pfffff@Pfffff@P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@Pfffff@P     @Pfffff@P     @Pfffff@P     @P     @P     @Pٙ@P33333@P     @P     @P     @Pٙ@P     @P     @P     @P     @Pٙ@Pٙ@P     @Pٙ@Pٙ@P     @P     @Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@P33333@Pٙ@Pٙ@Pٙ@P@P@Pٙ@Pٙ@P33333@P33333@P33333@P@P33333@Pfffff@P@P33333@P33333@P33333@P@P@P33333@P33333@P@P@P33333@P@P@P@P@P@P@P33333@P@P     @P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P33333@P     @Pfffff@P@P@P@P@P     @Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @P@P     @P@P@P@P@P@P     @P@P@P33333@P     @P     @P@P@P@P33333@P@P33333@P33333@P33333@P33333@P@Pfffff@Pfffff@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@P     @Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P33333@P33333@P@P33333@P33333@P33333@P@P33333@P33333@P@P@P@P@P33333@P@P     @P@P33333@P@P     @P33333@P     @P33333@P     @P     @P33333@P     @P@P@P33333@P@P@P33333@P33333@P@P33333@P33333@P@P33333@P@P33333@P@P33333@P33333@P33333@P@P33333@P33333@P@P33333@Pfffff@P33333@P@P33333@P33333@P33333@P@P@P33333@P@P33333@P@P33333@Pfffff@P@P@Pfffff@P     @Ps33333@PY@PS33333@PFfffff@PS33333@PFfffff@PL@P@     @P9@P@     @P9@P@     @PFfffff@P@     @PFfffff@PFfffff@P@     @P9@P9@P333333@P9@P9@P9@P9@P,@P@     @P,@P@     @P@     @P@     @PFfffff@P@     @PL@PL@PL@P@     @PL@P9@PFfffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        P4                                      5                                       BBmT{3