CDF       
      pressure  T   time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20120522   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P4     CAST_NUMBER       2      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:47.835616Z    ORIGINAL_HEADER      sCTD,20250210CCHSIOWB
#Renamed 'CTDFLUOR_TSG' to 'CTDFLUOR_ALT_1' with units 'MG/M^3'
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2018-11-29. CTD data from cruise 18DD20120522, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20120522. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2012-12/index.php. 
#
# The information in this file for the cruise 2012-12 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-0072.ctd
#
# Start of originator file comment header
#
#*2018/11/29 14:22:51.16
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2012/06/01 08:02:46.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 2006
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : C44EDC1F
#    NUMBER OF CHANNELS  : 9
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            2.3            2006.7
#       2 Temperature:CTD               deg_C_(ITS90)   1.9166         6.6907
#       3 Salinity:CTD                  PSS-78          32.6639        34.5892
#       4 Sigma-t:CTD                   kg/m^3          25.6458        27.6748
#       5 Transmissivity:CTD            %/m             61.4           67.9
#       6 Oxygen:Dissolved:CTD:Volume   ml/l            0.41           7.23
#       7 Oxygen:Dissolved:CTD:Mass     µmol/kg         17.9           314.7
#       8 Fluorescence:CTD:Seapoint     mg/m^3          0.24E-01       0.74
#       9 Fluorescence:CTD:Wetlabs      mg/m^3          0.102          1.096
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        6  F       ' '     1
#       6  -99   ' '        7  F       ' '     2
#       7  -99   ' '        6  F       ' '     1
#       8  -99   ' '        8  F       ' '     3
#       9  -99   ' '        8  F       ' '     3
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2012-12
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P24
#    EVENT NUMBER        : 72
#    LATITUDE            :  49  50.17000 N  ! (deg min)
#    LONGITUDE           : 142  40.04000 W  ! (deg min)
#    WATER DEPTH         : 3989
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    CTDEDIT was used to remove surface records and records corrupted by shed
#	wakes; salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Transmissivity, Fluorescence and PAR data are nominal and unedited except
#	that some records were removed in editing temperature and salinity.
#
#    For details on how the transmissivity calibration parameters were calculated
#	see the document Transmissivity_Calculation.pdf.
#
#    The Oxygen:Dissolved:CTD calibration was done using the method described in 
#	the Sea-Bird Application Note #64-2 (Sea-Bird_64-2_Jun2012.pdf).
#
#    The Oxygen:Dissolved:CTD data are considered, roughly, to be:
#	±0.1 ml/l from 0 to 125 dbar.
#	±0.06 ml/l from 125 to 500 dbar.
#	±0.04 ml/l from 500 to 2000 dbar.
#	±0.02 ml/l below 2000 dbar.
#
#    For details on the processing see processing report: 2012-12-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5-- --6--- --7-- ---8--- ---9---
#!Pressu Temperat Salinity Sigma-t: Trans Oxygen Oxyge Fluores Fluores
#!re:CTD ure:CTD  :CTD     CTD      missi :Disso n:Dis cence:  cence: 
#!                                  vity: lved:  solve CTD:    CTD:   
#!                                  CTD   CTD:   d:CTD Seapoin Wetlabs
#!                                        Volume :Mass t              
#!------ -------- -------- -------- ----- ------ ----- ------- -------
#*END OF HEADER
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @"         data_max      @"         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER       .    pressure                	long_name         pressure   positive      down   units         decibar    data_min      @333333   data_max      @͙   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC        @   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d        S`   temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      @Q_   data_max      @&"u%F
   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC         X   temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d        j   salinity                	long_name         salinity   units         PSS-78     data_min      @?
=p   data_max      @AGz   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC        oP   salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d           oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @.ffffff   data_max      @r33333   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC             	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d        8   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?5?|h   data_max      @C%   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC           CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d           PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min                 data_max      @Z   C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC         (   PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d           	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min      @K   data_max      @P        C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC       p   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d           station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         (     cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         (     time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min       V   data_max       V   C_format      %10d           latitude               	long_name         latitude   units         	degrees_N      data_min      @HS"`B   data_max      @HS"`B   C_format      %9.4f              	longitude                  	long_name         	longitude      units         	degrees_E      data_min      _-   data_max      _-   C_format      %9.4f              	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d            	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d         @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @333333@333333@      @      @      @       @!@$@&      @(      @*      @,      @.      @0      @1@1fffff@3      @4      @5      @6      @7      @8@9      @9fffff@;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D@D     @E      @E     @F      @F     @G      @G     @H@H     @I      @I     @J      @J     @Jٙ@K@L      @L     @M      @M     @N      @N     @N33333@O     @P      @P@     @Pfffff@P     @Q      @Q@     @Q     @Q@Rfffff@R@     @R     @R     @S      @SFfffff@Sy@S     @T      @T@     @T     @T     @U      @U@     @U33333@U     @V      @V@     @V     @V     @V@WFfffff@W     @W     @W@XFfffff@X     @X     @Y      @YFfffff@Ys33333@Y     @Z      @Z@     @Z     @Z     @[fffff@[9@[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^9@^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @`@a      @a@     @a`     @a     @a33333@a@a@b      @b      @b@     @b`     @b     @b@b     @b     @c      @c      @c@     @c`     @c33333@c@c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @fvfffff@f@f     @f     @g      @g      @g@     @g`     @g     @g     @g33333@g@h      @h      @h@     @h`     @h33333@hfffff@h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j@j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k\@k33333@k     @k     @k     @l      @l      @l@     @l`     @l|@l@l@l     @m      @m      @m@     @m`     @m33333@m@m     @m     @n      @n#33333@n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @oY@o|@o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p@pfffff@p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q@q@q     @q     @q     @q     @r      @r     @r      @r0     @rA@rP     @r`     @rp     @r~fffff@r     @r     @r     @rfffff@r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @sfffff@s@s     @s     @s񙙙@sfffff@t     @t      @t.fffff@tFfffff@tP     @t`     @tp     @t     @t33333@tfffff@t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u@ufffff@u     @u     @u     @u     @ufffff@ufffff@v      @v     @v      @v0     @v@     @vQ@v`     @vp     @v     @v     @v     @v     @vfffff@v     @v     @v     @w      @w     @w@w333333@w@     @wP     @wa@wq@w     @w     @wfffff@w     @w     @w     @w33333@x@x     @x      @x0     @x@     @xP     @x^fffff@xp     @x     @x     @x@xfffff@x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zq@z~fffff@z     @z     @zfffff@z@z     @z     @z     @{@{     @{!@{.fffff@{@     @{P     @{a@{q@{     @{     @{     @{     @{33333@{@{     @{     @|      @|#33333@|0     @|<@|S33333@|`     @|p     @|fffff@|     @|@|@|     @|@|     @|񙙙@|fffff@}     @}      @}333333@}@     @}P     @}^fffff@}t@}~fffff@}     @}     @}     @}@}     @}     @}     @~      @~     @~33333@~D@~P     @~`     @~k33333@~     @~     @~     @~fffff@~33333@~     @~     @      @     @fffff@1@@     @P     @`     @p     @     @@     @     @@     @     @     @@     @     @     @      @(     @/33333@9@@     @H     @Nfffff@Y@`     @ffffff@p@x     @     @fffff@33333@     @     @     @     @     @fffff@     @     @@fffff@33333@     @     @33333@	@     @     @      @(     @0     @:fffff@@     @H     @P     @Vfffff@`     @h     @p     @x     @     @     @     @fffff@     @     @     @     @@     @     @     @     @     @     @     @      @     @     @     @      @(     @-@733333@?33333@H     @P     @X     @`     @g33333@s33333@x     @     @     @     @@fffff@     @     @     @     @fffff@͙                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @&"u%F
@&
͞&@%(@%glC@%Dtj@%9@%14J@%b}V@$쿱[W?@$H@$|hs@$@$t`d@$N_o @$(p:@$3@#Q@#%@"s@"$xF@!S&@!V@!-
@!@!6@!	ԕ+@!'RT`@!w@!orGE9@!oAs@!n+@!g+I@!S@N@!MB@!G+I@!<?@!4j~@!*=p
@!&,<@!*d7@!5?@!*0U2a|@!xl"h
@!p
=@!
=p@ s@ As@ PH@ ״3@ Ϫ͞@ Ǔݗ+@ üZ@ 74@ `A@ âwk@ ĨTɆ@ /@ 7@ 84֡@ ڹ@ Fs@ t@ о
(@ Ϫ͟@ ^@ q@ q@ 2X@ Vu@ a@@ u!@ Ů1@ vȴ9@ +j@ >BZ@ m8@ ;5X@ ,<@ ?@ \(@ vȴ9@ kP@ {m@ oiDg8@ @ 2X@ %@ :)z@ $@ |?@ p)^@ m%@ l[W?@ k)^	@ g+I@ ae@ ]Vl!@ V+J@ L[W?@ GfA@ <#x@ 0)^@ +xF]@ *=p
@ +j@ {@ 
8Y@ 	lD@ +a@|hs@73@hr!@Xe,@Țu%F@?@+jg@q@+a@A [@}Vm@
qu@b}@@#@84֡@yXbM@j͞&@^쿱[W@P$tT@I7KƧ@?H˒:@)^@_o @$/@2W@ޞ@}Vl@*0@lq@ZkP|@PH@B@2m\@,!-w@2a|Q@,zxl"@+P{@)^@"}Vm@qi@%F
L@$xG@n.3@u@u%@@8YJ@a@O@;dZ@$/@=b@8Y@y=c@o-V@Ye+a@Eݗ@%ڹ@%zxl"h@p:@TɆ@!R<@H˒@ᰉ'@*0U@}Vl!@bM@V+J@JڹY@(	ԕ+@%1@0
(@Q_p@`A7K@d?@^ ѷY@Rm@N_o @GK]d@C,zxl@;J#9@*JL@$@*1@rGE9@
n@ 4m9@>B@zxl"@,=@PH@D@҈p;@@oiD@4m9@`	k@ce@{J#:@u%F@'/W@ߤ?@E@zxl"@m@\(@b`A@B74@ ěT@䎊q@o@a@O@a@N@J#9@{J#:@~($@?@,=@u%@$@cA @
qu@U=@o@Ft@+j@Ft@Ov_خ@Y@Q@+j@@}Vl!@NMj@7KƧ@6+jg@4j~@0{@.c	@+~($@Ov_خ@*0@ ě@C\@C\@VϪ@-w1@qu!@څݘ@@@Q@!.@4֡a@U=@@}b@@6@$/@)@\(@C,z@@0U2a|@7@e+@E@_p@|hs@(@ᰊ@Q@a@@U=@{m@~($@fA@[@@_o @W'@y(@p{@u%F
L@w1@ [7@sg@rGE85@\(\@@     @2GE85@/O
M@-hr!@+Q@)x@'	k@%O
@#
=p@$e@-U=@12W@1[W>6@/v@vȴ9@Ƨ@쿱[@eں@2X@޸Q@ңS&@xF]@p:@M:@hr@)@1@1'@a@O@ѷX@xQ@rW@ql@q2W@r{m@rm\@q-@nO;@k~($@lq@m\@kC,z@\u"@Y@RsP@M5Xy>@JL/{@JW'@IQ@IQ@IQ@ES&@?|hs@:C\@9D@73@5\(@12W@+Q@&1.@$/@C,zx@e+@*0U2@sP@2a|@:)z@Xy=@r Ĝ@*0U2a@Ov`@VϪ@x@-w1@ce@t@ʌL_@b}V@A [@RT`e@C,@q@af@u%F@@|j~#@yXbM@w3@w3@w4m@u?|h@kjf@eS@cS@aGz@_!-w1@^҈p;@^%@^@^쿱[W@^%@Y0
)@O;dZ@OAs@O@Np:~@L~($x@K)^	@F
L/@;~$@5'0@4j~@2m\@1A [@0oiDg8@/4֡a@,1&y@(ۋq
@&,<@	@
D@)^@a@N@ C@E@/V@>B@C\@9XbN@L/{J@ⶮ}Vm@|Q@IQ@֡af@ϐ@K]d@ěS@Õ$@6@6z@!.@O;@ۋq
@+a@wkQ@=K^@@@U@ᰉ@ݗ+k@_p@͞@@@m\@ [7@~"@~BZc @}ڹZ@|j~#@usg@v}Vl@v}Vl@vȴ9X@tSMj@tD@o hۋ@kjf@hr Ĝ@fIQ@aR<6@],=@]}H@\?@\]ce@\]ce@ZY@Zݘ@Z6C@XPH@U*0@JڹY@B ѷ@=p
=@7rG@,1&y@"C,@+j@U@sh@,<@p:@$tT@
jOv@	7KƧ@:S@KƧ@1@+jg@2X@TɅ@,@u@-w1@ֻ@@nO@ѷX@ΤT@jOv@L_@ěS@!.H@)y@Q@F]d@-V@w1@q@C,z@ۋq
@$xG@	ԕ+@fA@'@`A7L@%1@Ft@"`B@@D*@fA@_p@I^5?@E84@S&@?@}<64@tm8@o4֡a@lq@h@f,<@fIQ@fL/{J@eF
L0@d%1@b3@_;dZ@ZQ_@WXe,@W
=p@Vaf@TFs@K)^	@GE84@F$/@DS@B@@C@?b}V@=ڹZ@=<64@<Q@;J#9@:xl"h
@4SMj@0 ě@+jf@)y@(\)@&A@%F
L0@%F
L0@#S@Q@@ߤ@@"`B@"`B@u%@qu!@=K^@ݘ@y=c@+J@b}@fA@nO@
O;dZ@@4n@ڹZ@@q@	k@h	ԕ@حV@[@Q_                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @?
=p@?%1@?o h@?TɆ@?9XbN@?9XbN@?*1@?Xy=@?k~(@?xF]@?V@?䎊r@?żn/@?n@?яo@?րIQ@?Z@@	-w1@@?@@-L_@@5b@@8hۋq@@9|Q@@;A@@<tSM@@=C\@@>ߤ?@@?+I@@?lC@@?sPH@@?|hs@@@ ě@@A@@Bp:@@CeO@@D,<@@DS@@EF
L0@@EO
@@FH@@G{J#:@@G1@@F@@G.H@@G$tS@@G{J#:@@HeO@@Ie@@K@N@@L?@@L7@@M2a|@@P-
@@Q^@@QR<6@@Q2W@@Qo@@Qy@@QD@@S"`B@@UjOv@@WkP@@W˒:)@@X@@[Z@@\VϪ@@\~($x@@^2X@@_KƧ@@`1&x@@b=p
@@f}Vl@@g8}H@@go@@h@@i ѷ@@ilD@@kߤ@@l?@@l?@@m<64@@oXe@@p>BZc@@pC@@q7KƧ@@q|Q@@q@@r:)y@@tJ@@v
(@@zS&@@{E@@|"h	ԕ@@|O
M@@}ڹ@@eں@@n.@@҈p;@@eO@@E@@xF]@@PH@@a@@@}Vl@@{J#9@@bM@@TɅo@@fB@@O
M@@z@@ݗ+@@XbM@@?@@8}H@@ԕ*@@u%@@?@@c	@@҈p;@@!-w1@@͞@@TɅ@@©@@n.3@@a@@@ŗ+j@@ǧ&@@-w1@@҉@@\N@@IQ@@*0U@@@N@@wkP@@Շݗ@@!R<@@Ft@@oiDg8@@TɅo@@D@@I^5?@@ݎ!R@@1@@>BZc@@@@@A [@@e+@@d7@@䎊q@@ߤ@@"h	ԕ@@#@@TɆ@@?@@@@o i@@*0@@84֡@@\@@嫟U=@@E@@滘@@E84@@Vϫ@@@@r Ĝ@@\)@@D@@-@@N;6@@y@@鰉'R@@l@@X@@N;6@@s@@)y@@W'@@믷@@C]@@섵?@@ ѷY@@4֡a@@@@-
@@=b@@ae@@7Kƨ@@B@@	 @@\(@@ ѷ@@'/@@Z@@*0U2@@J@@Z1@@Ʌoi@@<64@@@@H˒@@@@@@ᰉ@@+jg@@@@L/{J@@s@@O;@@O;@@af@@2X@@+@@)^@@Ft@@$tS@@)^@@&@@@@@-@@     @@}H@@73@@[6@@l"h	@@tj@@@@9Xb@@U@@@@IQ@@
=q@@d8@@@@{@@{@@)@@ěT@@@@@F@@C@@N;5@@I^5@@T`d@@T`d@@d7@@@4@@S&@@S&@@䎊q@@tj~@@ߤ@@A@@$@@wk@@@@
=p@@|@@Q@@ߤ@@@tj@@@@1&y@@ߤ@@@(\@@쿱[@@Z@@7@@7@@>@@!.H@@L_@@U=@@;5X@@qi@@t@@+I@@O
M@@iDg8@@ݗ+@@rG@@rGE9@A 4m9@A NU@A D*@A -
q@A 'RT`@A bM@A ˒:*@A Xy=@A 4m9@A _F@A |@A {@ADg8~@A[W>6@A@AA [@ATɅo@Ao hی@A|Q@A~($@AX@Aᰉ'@A@A@4n@Am@Atj~@AU=@A~($@A
=p@A1&y@A(\@A/{J#@A"h	ԕ@Aߤ@@A!-w2@A<쿱@A`d@A~($x@A쿱[@Au@A84֡@AjOv@AS&@AfA@AO;dZ@A`A7L@Ap
=@AڹZ@Ahr!@A@A8Y@A
qv@Aᰉ@AC\@Aڹ@A
L/@A.2@Al!-@Al!-@AiB@As@A@Aqi@A+J@AIQ@AIQ@AT@A!.I@AE84@Ay@AkP@A@ArG@A@AbM@A6@A}H@A@A
qu@AF]d@A*0U@A'RT`@A_F@AeO@Al"h	@AYJ@A'RT@A4֡b@A		k~@A	+@A	:S@A	[W>6@A	@A	@A	ԕ*@A	iB@A	iB@A	y@A	iB@A	.H@A
I^5@A
@A
@4n@A
T`d@A
d7@A
@4@A
)_@A
fB@A
74@A'/@A)^	@A,zxl@A,zxl@A)^	@A)^	@A/V@AZ@AQ@Aq@A$@Aa@O@AlC@A\N@A,<@AVϪ@AZ1@AVϪ@A]ce@Aj~#@Aq@A?@A3@Aj~@AɅoi@A!-w@A
Vl!@A
fA@A
p
=@A
zxl"h@A
ڹZ@A
O
@A
O
@A
O
@A
@A
E@A
C\@A
ڹ@A4K@A.2@AE@AiB@As@Avȴ9X@Aqi@A$t@Aߤ?@A+@AFs@AFt@A+I@A4֡a@A8}H@A4֡a@AiDg8@A{J#:@Aݗ+@A?@A3@A@A@A@A@AVϫ@AVϫ@ArGE9@A#@A䎊r@A+j@ArGE9@A     @A@A ě@A'RT`@A73@AD*@AbM@Au!@A˒:*@An@An@A'RT@A@Au%F@A-
@Ad8@A
(@A ѷ@A&x@A:S@ADg8~@Au@A2W@A"`@As@A	 @As@A䎊@A-V@AGE85@AZc@Aᰊ@A@An@AW@Am\@As@A	@A)^	@AF]c@AxF]@AQ@AeO@AMj@AU=@AS@Aq@A
=p@As@A1&y@Aߤ@@A@A<쿱@AFs@AI^5?@ASMj@A]ce@AZ1@A`d@Ag8}@Ag8}@Aj~#@AtSM@AN;@A3@ATɆ@A@A[W?@A/@A!-w@A>@Ao i@Ao i@A5Xy>@Am\@Aݗ@A=K@A@AH˒@AH˒@AH˒@A\(@A\(@AϪ͞@A?@At@A
(@A
L/@A4K@A+jg@AiB@As@Avȴ9X@A+J@A@A,<@AT@A2X@AQ@Aߤ?@A@Aȴ9X@A!.I@A@A8}H@AH˒:@AO
M@A\(@Aeں@A_o@Av_ح@AkP@A-V@AzH@AzH@A[W>@A3@A/V@Ao @A˒:)@A@A@@AحV@A+j@A@A1&x@AYJ@A-
@Ap:@A҈p@A ѷ@A@A&x@A4J@AGz                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @rd@rD@rd@r33333@r|@rnfffff@rq@rt@r{33333@rfffff@rfffff@r33333@r33333@rfffff@rt@qə@pfffff@p     @p@p     @p     @pfffff@p     @p     @p     @p33333@pfffff@p33333@p@p33333@p     @p     @p@p@p33333@p33333@p@pfffff@p@p33333@p33333@p@pfffff@p@p33333@p33333@p     @p33333@p     @pfffff@pfffff@p33333@pt@pvfffff@px     @py@pvfffff@pq@p1@offfff@o     @o@o@o6fffff@n@n33333@nə@n@ns33333@mffffff@mc33333@mvfffff@m33333@m|@m\@l@l@li@li@l|@lfffff@lfffff@l     @k     @k     @kfffff@k@k@k@k@j33333@j     @j@jc33333@i      @hfffff@i	@i333333@i     @h@f      @e     @e     @e@e33333@e\@e@d33333@dfffff@d\@d@c33333@c33333@cfffff@ci@cP     @cC33333@c)@b     @b33333@bfffff@b     @bfffff@b@bp     @b<@bfffff@a33333@a33333@al@aP     @a6fffff@a333333@as33333@a33333@a     @a@a@a33333@aP     @`fffff@`fffff@a@a)@a333333@a@`fffff@`33333@`@`33333@`@`33333@`     @`@`@`33333@`33333@`     @`@`@`fffff@`33333@a&fffff@aI@aS33333@a@a33333@a33333@b      @b@b<@b33333@c	@cfffff@b33333@bٙ@bfffff@b@_&fffff@^fffff@]      @\fffff@\ffffff@\L@\S33333@\ffffff@\,@[Ffffff@[fffff@Zfffff@Z33333@[fffff@[@Z@Z     @Y     @Y333333@Y@X@Xfffff@X@Xfffff@Xfffff@Xy@XFfffff@Wfffff@W     @W@W@W33333@Wy@W      @V33333@V33333@V@V@V@     @U&fffff@U33333@T33333@T@Tfffff@T@T@T@T@T@Tfffff@Tfffff@T@T@T33333@T33333@T@Tfffff@Tfffff@T     @Tٙ@T@T33333@Tffffff@T@     @T333333@T,@T@T      @T@S     @S     @R     @R@R33333@Rfffff@R     @Rs33333@Rl@R`     @R9@R@R33333@R@R33333@R      @Qfffff@Q     @Qy@Ql@QS33333@Q333333@Q33333@P     @P@P9@Offfff@OY@O&fffff@O      @Nٙ@N     @N@     @N      @N      @M33333@N      @M33333@M33333@M     @M@M     @Ms33333@ML@M      @L@L@L@L&fffff@L      @Kٙ@K     @Kfffff@K     @K@     @K      @J     @JL@Iٙ@I@Iffffff@I@     @I@I333333@I333333@I      @H     @Hs33333@HY@H&fffff@G33333@G33333@H      @H      @G      @G@G333333@GL@GY@GL@F     @F@F     @FY@FL@F333333@F@F&fffff@F@F      @E     @Efffff@E33333@Efffff@E@Es33333@E     @Es33333@E     @Effffff@EL@D     @D@Ds33333@D@     @D@D      @C33333@C@C@C@Cٙ@Cٙ@Cfffff@Cٙ@C@C@C@C33333@C     @C@Bٙ@Bfffff@Bٙ@Bfffff@B     @B@     @B      @B@B@B@B&fffff@B@A33333@Afffff@A@A     @A@A@A@     @A      @A      @A      @A      @@@@     @@33333@@     @@fffff@@@@ffffff@@L@@L@@333333@@&fffff@@@@      @?33333@?     @?     @?ffffff@?ffffff@?L@?333333@?      @>fffff@>@>@>333333@=33333@=@=@=ffffff@=L@=ffffff@=     @=ffffff@<@<33333@=      @<@<ffffff@<333333@<@;fffff@;@;fffff@;@;ffffff@;@;@;333333@;ffffff@;ffffff@:     @:@:33333@:@:     @:     @:ffffff@:333333@:333333@:333333@933333@9fffff@9fffff@933333@9@9     @9     @9ffffff@9ffffff@9ffffff@9ffffff@9@9333333@9L@9333333@8@8@833333@8@833333@833333@8@8     @8     @8@8@8@8      @8@8333333@8@6@7@7@6@6ffffff@6L@6L@6L@6L@6333333@5@533333@5@5@533333@5@533333@5L@5333333@5333333@5@5333333@5@5@4@433333@4@4@4@4@4L@4L@4ffffff@4L@4333333@4333333@4@4@4@4@4      @3@3@3@3@3@3@3      @3333333@3L@3L@3      @233333@233333@233333@2@2     @2ffffff@2ffffff@2ffffff@2ffffff@2ffffff@2333333@2@2333333@2@2@1fffff@133333@133333@1     @133333@1@1@1     @1ffffff@1     @1     @1ffffff@1     @1      @1      @0fffff@0fffff@033333@033333@0@033333@0@0     @0ffffff@0@0     @0     @0L@0L@0L@0L@0ffffff@0L@0ffffff@/@/@/@0      @0      @0      @.@.ffffff@.@.@.@.@.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ?1&?"`A?hr!?vȴ9X?\(?Z1'?C$?5?|h?xF?nO;?ffffff?
=p?
=p
?䛥S?j~#?O;dZ?n?5?|h@C%@dZ1@ I^5??-?-V?Ƨ-?Q?S?1&y?vȴ?M?xF?zG?C%?+J?+J?+J?O;dZ?xF??/v?hr ?+?`A7L?vȴ9X?nO;?nP?-V?Z1'?ؓtj~?=p
=?E?&x?ڏ\(?GzH?֧-?\(?Ձ$/?O;dZ?9XbM?+?333333?У
=p?hr Ĝ?Vt?;dZ?E?̋C%?Vt?Q?^5?|?Ƨ-?dZ1?"`B?l?=p
=?Ұ ě?Ƨ-?lC?xF?      ?ěS?щ7KƧ?I^5??ӶE?ҟvȴ9?E?7KƧ?XbM?n?ӅQ?1&x?n?r ě?ěS?nO;?lC?E?д9XbN?lC?-V?ҟvȴ9?\(?Гtj~?p
=q?(\)?hr!?\(\?A7Kƨ?Vt?bM?hr!?1&x?zG?͑hr ?=p
=?ȴ9XbN?̋C%?I^5?Ƨ-?1&?˥S?KƧ?dZ1?ǍO;dZ?Ƨ-?E?Ͳ-V?ɺ^5?|?$/?(\)?Gz?x?ǍO;dZ?ȴ9Xb?ǍO;dZ?S?šo?E?I^5?}?\(?ǍO;dZ?ȴ9Xb?+?bM?\(?tj?ǍO;dZ?QR?+I^?r ě?nO?Ƈ+I?+J?ə?$/?Ł$/?Ƈ+I?lC?šo?E?9XbM?`A7K?S?Ƈ+I?$/?öE?E?Q?nO;?\(?$/?ļj~#?Õ$/?/w?tj~?Q?° ě?GzH?I^5??$/?-V?lD?ļj~#?\(?\(?nO;?S?Õ$/?lD?A7Kƨ?
=p?° ě?Z1'?9XbM?ȴ9Xb?Q?
=p?zG{?ěS?333333?zG{?333333?-V?I^5??l?A7Kƨ?-V?nO;?nO;?nO;?&x?n?+?$/?ffffff?x?Ƈ+I?S?S?tj?ļj~#?öE?öE?Q?ěS?nO;?S?333333?nO;?zG{?-V?nO?$/?° ě?nO?tj~?-V?öE?\(?\(?l?zG{?$/?hr Ĝ?Q?ěS?S?S?GzH?n?° ě?nO;?M?nO?zG{?° ě?šo?Õ$/?M?9XbM?+?GzH?lD?l?tj?ļj~#?\(?
=p?l?M?Z1'?S?tj~?x?9XbM?9XbM?+?+?-V?l?x?
=p?nO;?
=p?\(?ěS?-V?ěS?M?öE?ǮzG?ļj~#?E?n?Õ$/?° ě?S?tj?tj~?S?I^5??nO;?`A7?Q?tj~?-V?tj~?Õ$/?-V?+?° ě?$/?nO;??|hs?S?I^5??M?lD?GzH?`A7L?tj?zG{?`A7?-V?hr Ĝ?Õ$/?-V?-V?9XbM?nO;?
=p?+?E?9XbM?
=p?tj?/w?+?Õ$/?`A7?lD?Z1'?Z1'?l?ļj~#?° ě?Q?Ł$/?Õ$/?M?$/?+?n?+?`A7?\(?öE?9XbM?-V?\(?/w?-V?S?tj~?S?Õ$/?n?I^5??öE??|hs?l?lD?-V?M?tj~?7KƧ?° ě?° ě?bM?S?zG{?-V?
=p?`A7??|hs?Õ$/?Õ$/?I^5??
=p?333333?° ě?M?-V?GzH?
=p?Õ$/?+?+?\(?S?`A7?öE?Q?-V?
=p?`A7?nO;?nO;?tj?Z1'?n?/w?333333?tj~?7KƧ??|hs?Q?Õ$/?
=p?tj?I^5??nO?öE??|hs?Õ$/?S?
=p?hr Ĝ?nO?nO;?I^5??9XbM?Õ$/?/w?öE?tj~?nO?ěS?nO?Z1'?I^5??`A7?nO;?S?ěS?-V?tj~?`A7L?tj~?Q?tj~?ěS?\(?\(?tj~?nP?hr Ĝ?zG{?n?öE?nO;?Ł$/?hr Ĝ?`A7?tj~?hr Ĝ?9XbM?tj~?9XbM?7KƧ?\(?ǍO;dZ?Q?ěS?tj?-V?ěS?E?333333?5?|h?~"?/w?l?nO?Õ$/?&x?333333?l?tj~?-V?
=p?zG{?tj?Õ$/?`A7?+?ěS?-V?Õ$/?nO;?I^5??GzH?M?nO?ěS?ěS?-V?\(?ļj~#?nO?tj?Z1'?nO;?ěS?Z1'?\(?333333?hr Ĝ?Z1'?Ł$/?S?tj?\(?`A7?tj~?öE?l?M?\(?l?-V?zG{?9XbM?333333??|hs?l?Q?`A7?Õ$/?ļj~#?333333?9XbM?/w?Õ$/?ěS?lC?`A7?/w?+?tj?/w?+?° ě?l?S?M?nO?Z1'?öE??|hs?ěS?tj?bM?l?öE?Õ$/?M?Õ$/?S?`A7?S?tj?Q?ffffff?
=p?
=p?Q?E?tj~?Z1'?x?šo?Z1'?ȴ9Xb?-V?lD?tj?ļj~#?Ł$/?`A7?I^5??Õ$/?\(?nO?nO?ffffff?$/                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @Y@Z@Tfffff@R@     @P@N333333@K@I@Gs33333@Dٙ@Afffff@?@=L@;333333@9     @8     @7     @6     @533333@4333333@1@.@-@-ffffff@-333333@-      @+@+333333@+@+333333@+ffffff@*333333@)      @)ffffff@)@*ffffff@+333333@)@&ffffff@'333333@)@)333333@'@&@%333333@$      @$@$@#@"      @ ffffff@@@ffffff@@@333333@@@ffffff@@@      @@@      @
@      @	@@@      @ffffff@@333333@@ @ @       ?ffffff???      ????333333?333333?񙙙?      ?      ???陙?陙?ffffff?ffffff?ffffff?333333?333333?      ?      ?      ?      ?ٙ?ٙ?ٙ?ٙ?333333?333333?333333?333333?333333?333333?ə?ə?ə?ə?ə?ə?ə?ə??????????????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @O     @O@Offffff@O@O@O333333@O&fffff@Nfffff@Nfffff@OL@O@O      @OY@OY@OY@N33333@O      @O333333@N@Lfffff@K@L     @Nfffff@N     @Nٙ@N@N@N33333@Mٙ@N333333@N@O@N33333@Nfffff@O      @Offffff@Offfff@O@O@Oٙ@Offfff@O@O@Oٙ@Pfffff@Pfffff@P@P33333@P@P,@P,@P      @P,@P,@P,@P333333@PFfffff@P,@P@     @PFfffff@PFfffff@P@P333333@PFfffff@PL@PFfffff@PFfffff@P9@P      @P@P      @O33333@O33333@Oٙ@Pfffff@P      @Pfffff@P      @O33333@O33333@O33333@P      @O33333@Oٙ@Offfff@O33333@O33333@P      @Oٙ@O33333@Oٙ@Oٙ@Offfff@O33333@Offfff@Oٙ@Oٙ@O@O     @O33333@O33333@O@O     @O     @O     @Offfff@O@O     @O     @O     @Offfff@Offfff@Oٙ@O33333@Pfffff@P@Pfffff@P@P33333@P33333@P@Pfffff@P@P@P@P33333@P      @P      @P,@P&fffff@P333333@P9@P,@P33333@P9@P@     @P9@PY@PY@PS33333@PL@PY@P`     @PY@P9@PY@Pffffff@Pl@Pffffff@Ps33333@Ps33333@Ps33333@Ps33333@Pl@Py@Pl@Pl@Pl@PY@PS33333@Ps33333@Ps33333@Ps33333@Ps33333@Ps33333@Py@Py@P     @P     @P     @Pfffff@P@Pfffff@P     @P@P33333@P33333@P33333@P33333@P@P33333@Pfffff@Py@Py@Ps33333@Py@Pl@Pffffff@Py@Py@Py@Ps33333@Pffffff@Py@Pffffff@Py@Py@Py@PY@Pl@Ps33333@Pffffff@Py@Py@Py@P`     @Pffffff@P`     @P`     @PY@PL@PL@PFfffff@PFfffff@P@     @P9@P      @Pfffff@Oٙ@O     @O@O     @O     @O@Oٙ@Oٙ@Offfff@Pfffff@P@Pfffff@P@Pfffff@P      @Offfff@Oٙ@O33333@Pfffff@Pfffff@Pfffff@P@P33333@P33333@P&fffff@P333333@P333333@P9@P@O33333@P,@P@P      @P@P33333@P@P33333@P33333@P@P33333@P      @O33333@P@P@P@P      @P      @P      @P333333@PFfffff@PL@PL@PS33333@PS33333@PS33333@PY@PY@P      @Pffffff@Pl@Pffffff@Pl@Ps33333@Py@Py@Py@Ps33333@Py@Py@Py@Py@Py@Py@Py@P     @P     @P     @P     @P     @Py@Py@Py@Py@Py@Py@Py@Py@P     @Py@P@P     @Pfffff@Pfffff@P@Pfffff@P     @P     @P33333@Pfffff@Py@Py@Py@Py@Pfffff@Pfffff@P33333@P@P     @P     @Py@Py@Py@P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@P     @Pfffff@Pfffff@Pfffff@P@P`     @Pffffff@Pfffff@Pfffff@P33333@P     @P     @P@P33333@P33333@P@P     @P     @P@P@P@P     @P@P@P33333@P@P@Pfffff@Pfffff@Pfffff@P@P@P     @P@P@P33333@P@Pfffff@P@Pfffff@Pfffff@Pfffff@P@P@P@P     @P@P33333@P@P     @P     @P     @P     @P     @P@P     @P     @P@P     @P@P33333@P33333@P     @P@P@P@Pfffff@P@P@Pfffff@P@P@P@P@P@P@P@P     @P@P     @P@P@P     @Pfffff@P     @Pfffff@Pfffff@P     @Pfffff@P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@Pfffff@P     @P     @Pfffff@P@P33333@P     @P     @P33333@P33333@P33333@P@Pfffff@P@P33333@P33333@P33333@P33333@P@P@P@P     @P@P     @P     @P@P@P@Pfffff@P@P@P@Pfffff@P@P33333@Pfffff@Pfffff@P     @P     @P     @P     @P@P@Pfffff@P33333@P33333@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@P@P@P@Pfffff@P     @P     @P     @P     @P@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P@P@P@P33333@P     @P33333@Pfffff@P     @P     @P     @P     @Pfffff@P@P@P@P@P@P     @P@P@Pfffff@P@P@P@Pfffff@Pfffff@Pfffff@P@Pfffff@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@Pfffff@P33333@P@P33333@P33333@P33333@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @P     @P     @Pٙ@Pٙ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    P4                                      2                                        VBBU?3ƀ