CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20170205   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P23    CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:34.765862Z    ORIGINAL_HEADER      6CTD,20250210CCHSIOWB
#Removed 'CTDFLUOR_TSG' as it's filled with -999
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2017-06-29. CTD data from cruise 18DD20170205, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20170205. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2017-001/index.php. 
#
# The information in this file for the cruise 2017-001 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-0036.ctd
#
# Start of originator file comment header
#
#*2017/06/29 15:26:50.02
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2017/02/10 06:17:38.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 198
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : CE9F1F72
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            0.3            202.1
#       2 Temperature:CTD               deg_C_(ITS90)   5.6248         6.8697
#       3 Salinity:CTD                  PSS-78          32.78          33.8432
#       4 Sigma-t:CTD                   kg/m^3          25.7461        26.7106
#       5 Oxygen:Dissolved:CTD:Volume   ml/l            3.4            6.87
#       6 Oxygen:Dissolved:CTD:Mass     µmol/kg         147.7          299
#       7 Fluorescence:CTD:Seapoint     mg/m^3          0.66E-01       1.162
#       8 PAR:CTD                       µE/m^2/sec      0              0.3
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        7  F       ' '     2
#       6  -99   ' '        6  F       ' '     1
#       7  -99   ' '        8  F       ' '     3
#       8  -99   ' '        7  F       ' '     1
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2017-001
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P21
#    EVENT NUMBER        : 36
#    LATITUDE            :  49  38.00000 N  ! (deg min)
#    LONGITUDE           : 139  39.97000 W  ! (deg min)
#    WATER DEPTH         : 3961
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    The descent rate of the CTD was very noisy with some complete reversals
#	of direction.
#    CTDEDIT was used to remove many records corrupted by shed wakes;
#	salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Fluorescence and PAR data are nominal and unedited except that some records were
#	removed in editing temperature and salinity and a large spike in
#	fluorescence was removed from file 0032.
#
#    The Transmissivity channel was removed because of frequent shifts in values during
#	casts and large variations between values during repeat casts.
#	The data are available, by request, from the chief scientist.
#
#    NOTE: While the Fluorescence:CTD data are expressed in concentration units, they
#	do not always compare well to extracted chlorophyll samples, particularly for
#	casts far from shore. It is recommended that users check extracted chlorophyll
#	values where available.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in Sea-Bird
#	Application Note #64-2, June 2012 revision (Sea-Bird_64-2_Jun2012.pdf), except 
#	that a small offset in the fit was allowed.
#
#    The Dissolved Oxygen sensor used in files 0001, 0002 and 0016 malfunctioned so the 
#	Oxygen:Dissolved:CTD channels were removed from those files.
#
#    The Oxygen:Dissolved:CTD sensor has a fairly long response time so data accuracy 
#	is not as high when it is in motion as it is during stops for bottles. This will be
#	especially true when vertical dissolved oxygen gradients are large. To get an estimate
#	of the accuracy of the Oxygen:Dissolved:CTD data during downcasts (after recalibration)
#	a rough comparison was made between downcast Oxygen:Dissolved:CTD data and upcast 
#	titrated samples. Some of the difference will be due to problems with flushing of 
#	Niskin bottles and/or analysis errors, so the following statement likely underestimates 
#	Oxygen:Dissolved:CTD accuracy.
#
#    Downcast (CTD files) Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.25 ml/l from 0 to 125 dbar.
#	±0.2 ml/l from 125 to 400 dbar.
#	±0.1 ml/l from 400 to 600 dbar.
#	±0.05 ml/l from 600 to 1500 dbar.
#	Low by up to 0.08 ml/l below 1500 dbar.
#
#    For details on the processing see document: 2017-001-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5--- --6-- ---7--- --8---
#!Pressu Temperat Salinity Sigma-t: Oxygen Oxyge Fluores PAR:  
#!re:CTD ure:CTD  :CTD     CTD      :Disso n:Dis cence:  CTD   
#!                                  lved:  solve CTD:          
#!                                  CTD:   d:CTD Seapoin       
#!                                  Volume :Mass t             
#!------ -------- -------- -------- ------ ----- ------- ------
#*END OF HEADER
     WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @D         data_max      @D         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     8(  2   pressure                	long_name         pressure   positive      down   units         decibar    data_min      ?333333   data_max      @`        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      8(  k   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d        4   temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?͞%   data_max      @&IR   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       8(  @   temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d        h   salinity                	long_name         salinity   units         PSS-78     data_min      @@mjOv   data_max      @AI   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      8(  t   salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d       /   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @-   data_max      @r   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        8( =   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d       u   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?S   data_max      ?Ƨ-   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      8(    CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d          PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min                 data_max      @qk33333   C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       8(    PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d       8   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min               data_max               C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     8( D   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d       Hl   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( Vx   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( V   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      )   data_max      )   C_format      %10d       V   latitude               	long_name         latitude   units         	degrees_N      data_min      @H-V   data_max      @H-V   C_format      %9.4f          V   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      aCy   data_max      aCy   C_format      %9.4f          V   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d        V   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d        V@D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      ?333333@       @@333333@      @      @ffffff@@"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @2@4      @5      @6      @7      @8      @9@:@;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G@G     @H      @H     @I      @I     @J      @J@K      @K     @L@L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P@Q      @Q@     @Q     @Q     @R      @R@     @R     @R@Sfffff@S@     @S     @S     @Tfffff@T9@T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @V@W9@W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Zfffff@Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\ffffff@]@]@     @]     @]     @^      @^@     @^     @^     @^fffff@_@`      @`      @`@     @``     @`p     @`@`@`     @a      @a      @a@     @a`     @a     @a     @a33333@a     @b      @b      @b@     @b`     @b     @b     @b     @b@c      @c      @c@     @c`     @c33333@c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d33333@e#33333@e@     @e`     @e     @e     @e     @fC33333@f`     @f     @f     @f     @f     @g      @g      @g@     @gVfffff@g33333@h      @h      @h@     @h`     @h     @h     @h33333@h     @i      @i@i@     @i`     @i     @ifffff@i33333@i     @i33333@jFfffff@j`     @j     @j     @j@j陙@k      @k      @k@     @k`     @k     @k     @k     @kٙ@l      @l      @l@     @l`     @l     @l     @l@l33333@l@m@m@     @m`     @m     @m@mə@m     @n      @n      @n@     @n`     @n     @n@n     @n     @o      @o@oFfffff@o`     @o     @o33333@o     @o     @p      @p     @p      @p+33333@pD@pP     @p`     @pl@pfffff@p     @p     @p     @p     @p     @p33333@p@q      @q     @q      @q0     @qA@qQ@q`     @qp     @q     @q     @q     @q@q     @q     @q     @r      @r     @r      @r)@r@     @rP     @r`     @rnfffff@r     @r     @r     @r     @r     @rfffff@r     @r     @s      @s     @s      @s)@sFfffff@sL@sa@snfffff@s     @s     @s     @sfffff@s33333@s     @s     @s     @t      @t     @t      @t4@t@     @tP     @t`     @tp     @t     @t     @t     @t@t@t     @t     @t     @u      @u     @u@u333333@u>fffff@uP     @u`     @up     @u~fffff@u@u     @u     @u     @ufffff@u     @v      @v     @v      @v+33333@vD@vP     @v`     @vp     @v|@v     @v     @v     @v     @vٙ@v     @w      @w     @w      @w0     @w@     @wP     @w`     @wk33333@w@w     @w     @w     @w     @w     @w񙙙@wfffff@x     @x      @x0     @x@     @xP     @x`     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y~fffff@y33333@y     @y     @y     @y     @y     @y     @y33333@z!@z0     @z@     @zP     @z`     @zp     @z     @z@z33333@z     @z     @z     @z33333@{      @{     @{      @{.fffff@{@     @{P     @{`     @{k33333@{@{33333@{33333@{     @{     @{     @{     @{     @{@|#33333@|.fffff@|@     @|P     @|`     @|p     @|{33333@|     @|     @|     @|fffff@|     @|     @|@}@}     @}      @}0     @}@     @}P     @}`     @}p     @}{33333@}     @}     @}     @}     @}fffff@~$@~0     @~A@~P     @~`     @~nfffff@~@~     @~     @~     @~     @~     @~fffff@@      @0     @@     @P     @\@@     @     @fffff@     @     @     @     @ @fffff@@     @      @(     @/33333@H     @P     @X     @`     @h     @p     @x     @@     @     @     @     @     @     @33333@     @     @     @     @     @     @@ @33333@     @     @      @(     @0     @8     @@     @H     @L@a@h     @p     @x     @|@     @     @fffff@     @     @     @     @     @     @@fffff@@     @      @     @     @     @ @$     @333333@8     @@     @H     @P     @X     @d     @h     @p     @{33333@     @fffff@33333@     @     @     @fffff@     @     @@љ@     @     @     @     @     @      @     @     @     @fffff@*fffff@0     @8     @@     @H     @P     @X     @`     @h     @     @     @     @     @     @     @     @     @     @fffff@      @     @     @@0@8     @@     @H     @`@h     @p     @x     @|@     @     @     @     @     @     @     @     @33333@ՙ@@     @     @     @      @     @     @33333@1@8     @@     @H     @Nfffff@p     @x     @     @     @fffff@@     @33333@     @     @     @     @     @fffff@33333@     @     @     @      @@@     @      @(     @0     @8     @H@P     @X     @]@i@p     @t@33333@     @     @     @@     @@     @     @     @     @     @     @홙@      @     @     @     @      @;33333@@     @H     @P     @X     @`     @h     @l@@     @     @     @     @@     @fffff@     @     @     @     @     @fffff@@fffff@     @     @     @      @(     @0     @8     @Bfffff@H     @Y@`     @h     @p     @x     @     @fffff@fffff@     @     @     @     @33333@     @     @     @@fffff@     @@     @      @(     @.fffff@:fffff@@     @H     @P     @X     @`     @h@l     @w33333@     @     @     @     @     @     @     @     @@ř@33333@     @     @     @     @     @fffff@     @      @(     @0     @8     @@@X@`     @h     @p     @x     @|@     @     @     @     @     @     @@ə@     @     @     @     @     @     @@@     @     @      @(     @0     @8     @@     @H     @P     @T     @d     @h     @p     @x     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @      @33333@     @      @(     @0     @8     @@     @H     @P     @Vfffff@k33333@p     @x     @     @     @     @     @33333@@@fffff@     @     @     @     @     @홙@@      @     @     @     @      @(@@@H     @P     @X     @`     @h     @p     @x     @@     @     @     @     @     @     @     @33333@ᙙ@     @     @     @ @@fffff@     @      @(     @.fffff@;33333@@     @H     @P     @X     @`     @h     @p     @vfffff@33333@     @     @     @     @     @     @     @@     @     @     @      @     @     @fffff@1@8     @@     @H     @P     @X@i@p     @x     @     @33333@33333@     @     @@@     @ՙ@@     @     @     @@fffff@     @     @fffff@     @     @@)33333@,     @0     @4     @8     @<     @@     @D     @G33333@Pfffff@T     @Vfffff@\     @`     @d     @lfffff@p     @s33333@y@|     @     @     @     @fffff@33333@     @     @     @     @@     @     @     @     @     @@33333@     @fffff@33333@     @     @     @     @뙙@@     @      @     @     @33333@     @     @      @$     @(     @,     @/@2@8@<     @@     @D     @H     @L     @Pfffff@T     @W33333@\fffff@`     @d     @h     @l     @p     @t     @x     @zfffff@fffff@     @     @     @     @     @     @     @     @fffff@@     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @@     @     @      @     @     @     @     @     @@$     @(     @,     @0     @4     @8     @<     @?33333@H     @P@T     @X     @\     @`     @c33333@l@p     @t     @x     @|     @~@33333@     @     @     @     @     @     @fffff@     @     @     @     @     @@33333@     @     @     @     @     @     @33333@     @     @     @     @33333@33333@      @33333@     @     @     @     @     @     @      @$     @(     @,     @.fffff@533333@8     @@     @D     @H     @L     @P     @T     @Xfffff@Z     @a@d     @h     @l     @p     @s@y@|     @     @     @     @     @@fffff@     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @     @     @fffff@@     @     @@fffff@      @     @     @     @fffff@fffff@     @     @      @$     @(     @,     @0     @4     @6fffff@@fffff@D     @H     @L     @P     @T     @V@]@`     @d     @h     @k33333@u33333@x     @|     @     @     @     @     @@@     @     @     @@     @     @     @     @     @     @     @     @@@     @     @     @     @     @     @@     @     @     @      @     @     @     @     @     @     @33333@      @$     @(     @,     @0     @4     @7@>     @@     @D     @Ffffff@L@P     @T     @X     @\     @`     @d     @g33333@t     @x     @|     @     @     @     @     @fffff@fffff@fffff@33333@@     @@     @     @     @     @@     @     @     @     @     @     @33333@@     @     @      @     @     @33333@     @     @     @      @$     @(     @*@4@8     @<     @@     @D     @F@Q33333@T     @X     @\     @`     @bfffff@h@l     @p     @t     @x     @|     @     @     @     @@@     @     @     @     @     @     @fffff@@     @     @     @fffff@@     @     @     @     @@噙@     @     @     @     @     @@      @     @     @@     @     @     @     @ fffff@"fffff@-33333@0     @4     @8     @<     @@     @D     @M33333@P     @T     @`fffff@d     @h     @l     @p     @t     @w@@     @     @     @     @33333@33333@     @@fffff@     @     @     @     @     @     @     @@     @     @     @     @     @     @     @33333@     @33333@@      @     @     @     @     @     @fffff@fffff@ fffff@$     @(     @,     @0     @4     @9@<     @@     @D     @H     @L     @Y@\     @`     @d     @h     @l     @}33333@     @     @33333@@     @fffff@@     @33333@     @     @     @@fffff@     @     @     @     @@33333@     @     @     @     @     @@	@     @     @     @     @     @      @#33333@(     @,     @0     @4     @8fffff@:@H@L     @P     @T     @X     @\     @^@hfffff@l     @p     @t     @x     @|     @     @     @33333@@     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @fffff@     @      @     @@33333@fffff@@      @$     @(     @,     @0     @3@933333@:     @@fffff@D     @H     @L     @P     @T     @W33333@a33333@d     @h     @l     @p     @t     @x     @|fffff@~     @fffff@     @     @     @     @33333@     @     @     @     @     @     @33333@     @     @     @     @     @@33333@fffff@     @     @      @     @@fffff@     @     @      @$     @(     @,     @0     @4     @7@;33333@@@D     @H     @L     @P     @T     @X     @Z@e@h     @l     @p     @t     @w@fffff@     @@     @     @     @     @     @33333@     @     @     @     @     @@33333@     @     @     @     @     @33333@33333@     @     @     @     @@fffff@fffff@     @     @     @     @     @      @"fffff@0fffff@4     @8     @<     @?@L     @O33333@U33333@X     @\     @`     @c33333@h     @l     @p     @s@x     @|     @     @     @@@     @     @     @     @@     @     @     @     @     @     @     @˙@@     @     @     @     @     @     @ fffff@     @     @
fffff@fffff@@      @$     @(     @,     @0     @4     @8     @<     @>fffff@H@L     @P     @T     @X     @\     @`     @dfffff@g@l     @p     @t     @x     @|     @     @     @fffff@     @     @33333@33333@     @     @     @     @     @     @fffff@fffff@     @     @     @     @     @     @     @     @     @     @     @@@      @     @     @     @fffff@     @33333@@      @$     @(     @,     @0     @4     @8     @:@H     @L     @P     @T     @X     @\     @`fffff@b     @l@p     @t     @x     @|     @     @@fffff@@     @     @     @     @33333@@     @     @     @     @@     @     @     @     @     @33333@     @     @     @33333@     @     @      @     @     @     @     @     @     @     @      @$     @&@8fffff@<     @@     @D     @H     @L     @P     @[33333@`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          @c	@"`B@ݘ@ݘ@Y@c	@Y@,<@6@$@Q@6@6@q@6@(\@1&@C,zx@ߤ@@/w@,=@u@cA @ce@ce@C,zx@wkP@C,zx@wkP@>@iB@%@Ov_خ@iB@U=@حV@䎊r@حV@حV@ [6@ -
@ u!@ 	k@!ae@!@N@!Gz@"e+@"@4@"C,@"}Vm@"wkQ@"M@"e+@"wkQ@"wkQ@"@4@#eO@#eO@#
=p@$xF@#
=p@#Z@#Z@#wk@#Z@#Z@$Z1@$Z1@$tSM@$?@$?@$tSM@%u@$tSM@#9@#eO@"`A@"}Vm@"}Vm@"}Vm@#9@#eO@#	@#S@#
=p@$?@$?@$?@$qj@$tSM@$tSM@#Z@#A [@$qj@$Z1@#A [@$%1@$tSM@$Z1@$TɆ@$e@%`A7L@%u@%F
L0@%ڹ@&L/{J@+U=@:C\@Vt@[W>6z@_vȴ9@cZ@d/@nc	@n@ߤ?@,"h	ԕ@;s@Eݗ@W@~"@&IR@@u%@䎊qj@[6@/w@R<6@(\@S&@@3@/@6C@ᰉ@nO@bM@YJ@Zu%F@XbM@Dtj@
M;@	@PH@'RT`@$/@[W>6@l!-@_@6@ka@@bC,@C@1[W>6@-V@
qiC@@%1@*0U@ʦL/{@:S@@Fs@`A7L@M:@sg@P)^@<j~#@2-V@,zxl@^5?|@g@䎊q@2X@F
L0@ܑN;@v_ح@Zc@~@jOv@~m\@q&x@d7@C\N@(	ԕ+@b}@_p@)@ ѷ@ ѷ@JM@ӎMj@}Vl@?@|Q@K]c@n@QX@>ߤ?@3MjO@1iB@(ۋq
@3@U2a|@JL@fffff@ܬ1&@qu!@t@#9@~$@'RT@(@=K^@JM@eO
@UfA@T*1@K'/@@4m9@-(@tj~@
qiC@
:@84֡@o@m]@d7@Y@ᰉ@*0U@:)z@@t#@j~"@[S@Xy=c@Em\@@     @8)@4!-w2@ݘ@;5X@ n@O;@u@wkQ@"`B@ƍ@˒:)@)@3@m\@a|Q@Vϫ@g	@e+@L_@[qu!@UϪ͞@@     @*0U2a|@!'R@W>6z@+@	 ѷ@\(@jf@(\@ ѷ@|Q@ߤ@@+j@sP@D@@4n@u%F
L@rm\@nt@\>@S@N@F-@84֡b@)lD@Ov_خ@b}@
@	@7Kƨ@|@C,z@xF@o@]ce@͞%@M:@iB@wk@;dZ@1&@>6z@qi@@_o@}H˒@tSMj@lC@c
=p@]-V@X_F@LcA \@H@HeO@Dtj@A:S@=p
=@<j~#@9D@1&x@,zxl"@)B@'-@"h	ԕ@I^5?@<64@^5?|@F]d@Y|@@x@F
L0@W>6z@Z@N;5@!R<@ ѷ@+I@@$t@(@3@9XbN@D@g	@@@IQ@Ϫ͟@:@D@^5?}@YJ@S@ѷX@~
(@~
(@~m\@}ڹZ@z>B@wKƧ@usg@r-V@or@irGE@^҈p;@XD*@M:@@hۋq@9	k~@3@1l@/v@+C,z@'/V@(	ԕ+@Q@8YJ@=K@Ʌoi@*0U2@S&@
(@
L_@p:@-@I^5@Z@}Vl@E@o@:~ @r@}Vl@ hۋ@\@Z1@
qu@ݗ+j@_p@Ίqi@qu"@̘_@W'@ ѷ@y@84֡@o i@\(@     @ڹZ@hr@m]@3@l@}Vl@\)@A@IQ@xF@`A@'R@'RT`@	k@3@҈p@o@5?|@>@U@ᰉ@_p@_o @n@1&x@JM@NU@~6z@yD@vz@t3@rᰊ@r-V@poiDg8@lq@ilD@h@h@hXy=@fx@cS@ae@][@YJE@W>6z@UL_@Sݗ+k@O
M;@MM:@LcA \@K)^	@IoiD@I7KƧ@I'RTa@J	 @K]cA@Gy@ES&@BI^5@@hۋq@74m@1u!S@0
=q@/Vϫ@/-V@.H@+6z@&'@#eO@vȴ9@5?|@>@u"@wkP@[@!-w1@ [6@JE@o @@)^	@g8}@nP@ IQ@E@G{@G{@	k~@
=q@@rGE8@u%F
@ IQ@?@a@N@O;@ѷX@_o @˒:)z@p:~@*0U@ҽ<64@d8@حV@S@@fffff@lC@lC@r Ĝ@r Ĝ@҈p@ۋq@ڹY@䎊@T`d@&@o i@^5?|@ߤ@g	l@a|Q@33333@'RT@{J#:@-V@9XbN@֡a@KƧ@A@v@d7@U=@{J#:@[W>6@J@sg@v@Ov_@@tSMj@_?@Vaf@D*0@2-V@+jf@#
=p@S@@҉@Vu@u%F@"@~$@!-w2@A [@g	@@N@]ce@څݘ@@2a|@m@䎊@_p@5Xy>@ɺ^5?}@g8}@74@m\@@D@33333@zxl"h@*0@'/W@M:@C%@{J#9@|?@s@q@m8Y@j~"@iB@eO
@`
qu@[6@B74@9XbM@6z@5sg@ 	k@@sh@@%2@
PH@
!-w2@
l@
!-w@
حV@
>@
"`B@
+@
sPH@
l!-@
2a|@
`d@
&@
@
_o @
K]c@
m\@
H˒:@
j~#@
~@
KƧ@
ߤ@
=p@
*0@
#@
nP@
{s@
a|Q@
^iB@
\N;@
ZQ_@
XD*@
VϪ͟@
U=K@
R<64@
MjOv@
I@
F
L/@
=v@
74m@
2W@
/v@
(\)@
vȴ9@
0
)@
nO@
@
	 ѷ@
YJ@
JM@
n/@$tS@xl"h
@!-w2@쿱[W?@
qu@ԕ*1@?@rG@Vϫ@1@2X@U=@I^@$xG@'@TɆ@S&@-V@@@sh@sP@bM@)^@@k~(@n/@@:S@y	k~@pD@jg	@hۋq
@eO
@[q@Y+@Vl!-@O;dZ@OAs@H@ATɅo@>BZc @;/V@8}H@12W@0'RT@-
qv@-V@+jf@)^@%S@(@!.H@0
)@:)y@C%@#@JM@˒:)@~$@-
@"`@_ح@C\@C,z@	k@M@1'@t@
=p@@p
=@Z@/V@^5?|@/V@-w1@wkP@0
)@@Z@O
M@O
M@sP@!R<@ڹY@_o@@x-
@t#@p
=q@irGE@cS@a'R@W@V8YJ@Rp:@K]cA@E8YK@ATɅo@<Z@:S&@8Q@5?|h@5?@74m@0{@)^@$tSM@䎊r@Q@tj@@N@
ڹY@_o@ݗ+@@ hۋq@
73@
ȴ9X@
D@
MjO@
C\@
쿱[W?@

qu@
 ѷY@
ٳ|@

=p@
8YJ@
Ʌoi@
@
cA \@
*0@
5Xy@
2W@
<쿱@
y@
@
9@
S@
e+a@
Ov_@
4J@
(@
'/@
Q@
@
@
~m\@
}H˒@
vFs@
sE@
mC\@
jJL@
jJL@
eڹ@
\>@
YJE@
U=K@
IQ@
B74@
>
(@
;dZ@
9Y}@
73@
43@
2W@
0'RT@
-U=@
,q@
*0
@
'&@
!R<6@
)^@
	7KƧ@
oiDg@
n.@
 IQ@	b}V@	b}V@	s@	eں@	%F
L@	s@	빌~($@	,<@	+a@	eO@	ޞ@	(\@	(\@	>6z@	*0U@	Q@	KƧ@	E@	[W>6@	>B[@	*0U2a@	Xy=@	L/{J@	tSM@	}H@	@	(@	$/@	w1@	nc	@	lVϪ@	kC]@	l"h	ԕ@	kQ@	kP{@	kQ@	ae@	_;dZ@	RT`d@	LcA \@	G)^@	>
(@	3g	l@	$tSM@	vȴ9@	_F@	Fs@	hr @	~($x@	1&x@H˒@!.I@D@PH@ᰉ'@`A7L@	k@A [@u!@bM@@@@74@E@<쿱@@[6@+J@Z@tj~@'/@7KƧ@Fs@~m\@z>B@z@yrGE8@x73@z@w+@v!.I@u%F
L@r䎊q@poiDg8@o@o-V@lVϪ@bM@_حV@U=K@M%@Ks@GE84@C$@BZc@A@@NU@;A@6E@0 ě@+a@@!o@ -
@wkP@,<@+J@sP@@@4n@ 4m9@"@ڹZ@xl"h
@#@Ov`@	ԕ+@A [@ڹY@1'@+@R@š@a@N@a@N@BZc @5Xy      @rG@Xy=@o@U2a|@O
M@S@/@.H@1&@@@sh@M:@eO@#@_o@nP@}E@w1@rs@l"h	ԕ@dZ1@c	@`
qu@^5?|@]+j@[6@\?@[W>6z@XbM@P`A7@K]cA@J#9@JW'@H@E@>BZc @<j~#@;dZ@84֡b@2a|Q@2m\@-w1@/O
M@2m\@$xF@!o@'-@-
qv@1o@43@4֡a@3ߤ@.}Vl@%F
L0@*0U2a|@#
=p@1&x@$tS@n/@҉@@O;d@ᰉ@!R<@u%F@oiDg@S&@@
L/{@C%@YJ@I^5@_ح@VϪ@Z1@ۋq@@@҈p:@a@O@Z@Z@a@O@
M;@]cA@ěS@74@2W@@S&@}Vl@Y}@D@
(@͞&@Xy=@x@L/{J@@L/{J@ae@PH@PH@0
)@nO@@	 @ݗ@$/@b}V@~"@tD@sE@sg@sg@t!-w2@sg@nt@jg	@jOv`@hۋq
@eڹ@ae@]+j@\(\@["`B@W&@Vl!-@T,<@N+@KƧ@ATɅo@5Xy=@5'0@4֡a@1[W>6@-B@(@%1@%zxl"h@%@1&@,<@_F@'/W@
@
qiC@@      @$t@Q@s@rGE8@Fs@Y|@#@ ě@l@~"@M@҈p;@/w@5?|@u!@|Q@|Q@>@1'@Z@Ϫ͞@;5X@̘_@cA \@#9@g8}@ߤ?@
(@6z@v@A@D@z@2X@,@-
@Q@Q@,=@Q@R<6@$/@$/@*0@*0U2@N;6@ڹY@{J#9@~"@}ڹZ@z@u!R@sPH@l"h	ԕ@jOv`@eڹ@c	@ae@a|Q@]+j@Zݘ@Xe+@WsPH@W>6z@TɅoi@QR@O
M;@Np:~@K)^	@Fs@B&IR@>
(@;dZ@5'0@5sg@5?|h@49XbN@3|@333333@1[W>6@*0U2a|@($xG@'-@&x@%zxl"h@"3@vȴ9@u"@u%F@PH@$tS@$/@sP@)^@@ߤ?@
qu"@xF]@S&@n.@ڹZ@?@lC@>B@(@	k~@F@(@=b@l"h	@+@_ح@%F
L@ ě@l@(@SMj@hr!@C]@B@r Ĝ@lC@eO@|Q@e@d8@;dZ@]ce@1'@1'@JE@D*@Ϫ͟@@As@@W'@
L/@TɅo@[W>@K]@YJ@J@ᰊ@v@\)@TɆ@3@o@-
@U=@,<@@u@@_o@|PH@{~$@w1@v+jg@sE@ql@poiDg8@p@o@o hۋ@m(@kC]@j~"@irGE@hۋq
@f,<@bC,@a@N@]ce@[6@Zݘ@UfA@T,<@Q@M:@JD@Eo i@B\(@As@8YJ@43@1[W>6@/r@/O
M@-
qv@*0
@*0U2a|@)^@(Xy=@%S@#wk@u"@6C@@~($x@n/@\N<@?@lC@F@D@D@s@C@唯O
@eO@u!@?@ٳ|@l!-@`d@ҽ<64@H@:@]cf@74@7Kƨ@64@XbM@rG@E@m8@
(@2X@a@@\)@S@3@@_F@O;d@ᰉ@:)y@u@@O;dZ@q@7KƧ@n/@S&@4m9@~$t@{m]@{J#9@y(@sE@p@ffffff@c	@^@["`B@[W>6z@Zc	@Y|@[W>6z@YJE@XU@W>6z@UϪ͞@Q_p@LcA \@GE84@E84֡@C,zxl@A7Kƨ@@C@@C@?[W>@;5Xy@9XbM@73@7KƧ@3g	l@1&x@.H@+a@@)y@%zxl"h@%F
L0@%F
L0@$tSM@%F
L0@u@wkP@S@qu!@vȴ@@O
M@$tT@@
=p
@eO@F]c@Vl!@PH@?@PH@xl"h
@!.I@-V@B@唯O
@ⶮ}Vm@d8@حV@ce@>BZ@Ϫ͟@@n@s@Õ$@?@g	l@ᰊ@Vϫ@w1@d7@'@/@wkQ@-w1@Ov_خ@_o@@@~($x@~($x@oiDg@%2@ ѷ@:S@~$t@}E@{m]@zG{@xl"h	@uY|@s@n.2@h@gfA@gfA@h>BZc@glC@e@a|Q@]/w@Yb}@NT@M5Xy>@Gy@DS@A7Kƨ@?|hs@>vȴ9X@:S&@9XbM@9XbM@84֡b@73@6}Vl@5Xy=@5'0@4m8@12W@/O
M@/O
M@-B@,1&y@+U=@+6z@)y@(\)@*0U2a|@(@',@&L/{J@$tSM@!ae@1&@6C@@L_@@4J@@qi@
qu"@$/@ hۋq@\N<@?@s@C\@	k~@+@Fs@l@@c	@Ov`@8}H@e@	@e@
qu@$@Q_@حU@+@حU@@fA@@a@O@As@@y@8YK@o i@*0@74@C@@@BZc @n.@^5?|@Q@KƧ@Xe@Xe@}Vl@|@o@V@jf@0U2a|@-@IQ@tSM@'RT`@u%F@@@@O;d@O;d@@$tS@*0@@N@sP@C%@+I@&I@ݗ@@}!.H@w+@w+@y=b@v+jg@tj~@r䎊q@rs@qiB@m8Y@l[W?@lVϪ@jg	@iᰉ'@d7@c	@b}Vm@c	@dZ1@_o@^iB@^ ѷY@^ ѷY@\>@[6@Vl!-@S&@Q@P{@O
M;@M@I@Fs@D2W@Ca@N@A@?|hs@;/V@:~@;dZ@8}H@4m8@0 ě@,q@*0U2a|@)y@!R<6@%@[@wkP@Q@@@@+J@nO@'/W@L_@
=p
@	ԕ*@u%F@_o@$/@M:@u%F
@:S@ hۋq@ "@ E@ Vl!@ ?@ xl"h
@ +jg@ %F
L@  ě@ oiDg8@ O;@ C@ g	@ rGE@ r Ĝ@ @ 1.@ eO@ iB@ څݘ@ >6z@ `d@ R@ ̘_@ #9@ Ƨ-@ 2W@ v@ n.@ dZ@ )y@ XbM@ Xy=@ a|Q@ -V@ &x@ v@ H@ zG@ U=@ a@@ d7@ lD@ y@ y@ ^@ ͞&@ d7@ @ xF@ 3@ ěT@ -
@ u%@ u%F@ $/@ tj~@ sP@ nO@ q@ 'RTa@ oiDg@ ݗ@ %2@ n.@ I^5@ o hی@ {~$@ v!.I@ t!-w2@ rGE85@ qu!S@ p:~ @ mhr!@ n.2@ m8Y@ lC@ kC,z@ jOv`@ irGE@ ffffff@ be+@ _حV@ ]ce@ \]ce@ Y>BZ@ XbM@ Xe+@ XU@ WsPH@ V8YJ@ UfA@ Rm@ NT@ IQ@ F
L/@ BZc@ B74@ Ca@N@ C$@ B@ A7Kƨ@ @n@ As@ >ߤ?@ =v@ <Z@ 8Q@ 5sg@ 5?|h@ 43@ 5sg@ 5sg@ 333333@ 1o@ 0 ě@ /r@ .H@ '/V@ &x@ %u@ #wk@ #9@ !.H@  	k@ vȴ9@ 쿱[W@ -V@ qu!@ ,<@ @ PH@ PH@ 0
)@ Ov_@ tj~@ nO@ '/W@ Vu@ @ '/@ 
=p
@ 	'RTa@ eO@ oiDg@ nP@ n.?"`?D?VϪ?rGE??S? ѷY?b}?͞%                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     @@mjOv@@mjOv@@msg@@mp
=@@msg@@mw1@@m}H@@mzxl"h@@mw1@@msg@@mzxl"h@@m$/@@m}H@@mzxl"h@@mzxl"h@@mzxl"h@@mw1@@mzxl"h@@m}H@@mp
=@@mzxl"h@@m!R@@m!R@@mhr!@@m%@@mݗ@@mM:@@mzxl"h@@m$/@@mݗ@@mU=@@m%@@m=K@@mXy=@@mϪ͞@@m?@@m?@@m
qv@@mS@@mb@@mb@@m?@@m(@@moiDg@@mᰉ@@mᰉ@@m,=@@m(@@m,=@@mᰉ@@mS@@mᰉ@@m(@@mᰉ@@m(@@mS@@m@@mϪ͞@@m?@@m
qv@@m,=@@m!.@@m!.@@m!.@@mC\@@moiDg@@mᰉ@@moiDg@@m(@@m!.@@mC\@@m!.@@n ѷY@@m(@@mb@@mϪ͞@@m8Y@@m8Y@@m\(@@mH˒@@mH˒@@mcA @@m8Y@@m@@m8YK@@m?@@m8YK@@m
qv@@m
qv@@m
qv@@mb@@m@@m8Y@@m@@mH˒@@m@@m\(@@m@@m8Y@@m@@mn/@@mH˒@@m8Y@@m8Y@@m@@m@@m!.@@n+@@q0
)@@q@@rOv`@@rp:@@rwkQ@@sI^@@t"h	ԕ@@{~($@@8Y@@@N@@ڹY@@z@@!R@@8}H@@/w@@F]d@@ըXy=@@րIQ@@t@@TɅ@@*0U2a@@ۈeO@@ާ-@@73@@~($@@C,z@@1&y@@䎊qj@@e@@唯O
@@Ov_خ@@2X@@1@@lC@@@@-@@+j@@u!@@ۋq
@@e+@@@@A [@@7Kƨ@@B@@Q_@@n@@G{@@m@@,zxl@@W>6z@@eO@@Mj@@ߤ@@Mj@@*0U2@@@@\N@@ߤ@@@%1@@(\@@$@@g8}@@zG@@zG@@tSM@@C@@_@@?@@j~@@#x@@Z@@(@@2a|@@(@@(@@<64@@/w@@/w@@K]@@Q@@:@@D@@>@@jOv@@L_@@Q@@L_@@ce@@ce@@zxl"h@@m\@@<64@@[@@Q@@S&@@\@@Y|@@O;dZ@@F
L0@@B@@84֡@@Q@@84֡@@L_@@O;dZ@@IQ@@IQ@@?|h@@`A7L@@-V@@!R<@@R<6@@ ѷY@@@@Ϫ͞@@4K@@1.@@@@.2@@($x@@1.@@u@@($x@@1.@@;5X@@($x@@4K@@,=@@S@@(@@ڹ@@4K@@($x@@1.@@?@@;5X@@+jg@@Ov_@@($x@@L/{J@@R<6@@H@@5?|@@L/{J@@H@@E@@BZc @@?@@l!-@@l!-@@c	@@l!-@@IQ@@Fs@@,<@@af@@x@@@@
M;@@)^@@v@@v@@_o@@b}V@@_o@@iDg8@@	@@$tS@@阮&@@zH@@حV@@rGE9@@
qu@@}H@@:~ @@U2a|@@˒:*@@˒:*@@IQ@@{@@ۋq
@@+@@&x@@7KƧ@@:S@@TɅo@@7Kƨ@@l@@s@@-V@@@4n@@@4n@@C\@@a|Q@@h	ԕ@@~"@@>B@@@@ڹY@@S&@@	@@J#9@@qu!@@~$@@{J#9@@Mj@@ߤ@@m]@@E@@6@@g@@s@@xF@@ߤ@@@!-w2@@*1@@?@@?@@/@@hr@@'0@@Q@@2a|@@p
=@@!R@@+j@@-V@@cA @@?@@oiDg@@4K@@1.@@BZc @@_ح@@vȴ9X@@,<@@}Vl@@A@@$tS@@b}V@@/V@@o @@rGE9@@'RT`@@-
q@@eO@@-
@@U@@4m@@{@@ [7@@JE@@XbM@@o hی@@x@@7Kƨ@@|@@@@	 @@Ov`@@#9@@C\@@C\@@kP|@@ݘ@@S&@@n@@/V@@W>6z@@Z@@W>6z@@dZ@@jf@@*0U2@@E@@@@a@@@n.@@2W@@wkP@@N;@@O
M@@TɆ@@?@@֡a@@V@@?|h@@fA@@p
=@@@@t@@u@@8YJ@@E@@YJ@@c	@@p:~@@$t@@ߤ?@@@@$tS@@>6z@@lC@@y@@&@@@@rG@A 6@A H@A _F@A @A 
(@A F@A [7@Aae@Ao@A@AR<6@AR<6@A@A@Au@An.@A"`@A.H@A@A=p
@AJL@AkP|@Ag	@AW@Am@Au%@As@A/V@Atj~@A$@Aq@AE@A~($@AQ@AQ@A,<@A~($x@A?@AZ@AE@A*0@Asg@AڹZ@A%@AU=@AcA @A8YK@AϪ͞@A@AH˒@A!.@Au@AVu@Afffff@A!.I@AKƧ@Av_ح@A&@A&@Aݗ+@A@A+j@A$xG@AD*@AU2a|@Ar Ĝ@AYJ@Atj@AěT@AU@Ae+@A	@A	@A	'RTa@A	^5?}@A
6C@A
JL@A
{m@A
wkQ@A
>B@A
 ě@A
͞&@AnP@AW>6z@AA@A
=p@AQ@A\N@AA [@AQ@AxF@A@A%1@Am8@A3@AZ@A
(@A
ce@A
M:@A
%@A
S@A
(@A!R<@A;5X@Al!-@AFs@AO;@A,<@AQ@Aߤ?@A@A@AϪ͟@AA@At@A҈p;@Ax@A@A'/W@A1@AAs@A_o@A|hs@A&@A@AA7K@AoiDg8@A˒:*@Au%F@ATɅ@A4֡b@A4֡b@A@A ѷ@A ѷ@A$/@A{@A	k@A-w1@AJE@Ax@AX@A@A&IR@A䎊@A:)y@AkP|@A{m@A@AW@Ac	@AC,z@A33333@A=K^@AP{@Aa@N@Ajf@AxF]@Atj~@Aq@Awk@AƧ@A5Xy@A|@As@A@A%1@AM:@AC@ATɆ@A1&@A@AD@AV@A84֡@AF
L0@AL_@A$/@An/@A ѷY@AOv_@A;5X@Aȴ9X@A@A@AFs@AO
M@Ao@Av_ح@A͞@A     @A1&x@AoiDg8@A'RT@A)^@APH@A@A_p@A*0U2a@A4J@A4J@A=b@AGz@AN;5@ADg8~@Ak~(@AoiD@A@Ao@AiB@Aᰉ'@AR@As@A3@AkP|@Avȴ@AY@A䎊q@AZ@An.3@Atj~@A~$@Aq@AeO@A$@AU=@AZ@AƧ@Aݗ+k@AxF@A!-w2@A2W@A9XbN@ASMj@Aq@AC@ATɆ@A*0@AZ@A>B[@Au"@A/@A>@AV@A/w@AO;dZ@A$/@AU=@AS@AOv_@AOv_خ@AR<6@AE@AL/{J@AVu@Ac	@Al!-@A}Vl@A}Vl@AFs@A-@A'@A&I@At@A҈p;@A@AFs@A
=p@AXe@AXe@A>6z@AlC@A	@A	@A$tS@Avȴ9@AK]d@A@A      @ArGE9@A *0U@A -
q@A 4m9@A NU@A l"h	@A r Ĝ@A u!@A n@A n@A YJ@A @A 
=q@A tj@A D@A e+@A! ѷ@A!@A!#w@A!*0U2a@A!0
)@A!:S@A!^@A!Gz@A!|Q@A!~($@A!~($@A!@A!'R@A!_o@A!ԕ*@A!s@A"#9@A"&IR@A"&IR@A":)y@A"C\@A"@4@A"0
@A"S&@A"n@A"n@A"͞&@A"W@A"W@A",<@A"fB@A"D@A#I^@A#	@A#@N@A#P{@A#a@N@A#xF]@A#eO@A#$@A#~($@A#@A#|@A#C]@A#\N@A$1&y@A$!-w2@A$!-w2@A$(\@A$C,zx@A$<쿱@A$SMj@A$SMj@A$m8@A$q@A$#@A$_@A$TɆ@A$[W?@A$/@A$JM@A$u"@A$D@A%:@A%(@A%(@A%/w@A%2a|@A%O;dZ@A%S&@A%ݗ@A%!R@A%@A%U=@A%U=@A%-V@A%@A%@A%oiDg@A&
L/@A&1.@A&E@A&H@A&Vu@A&iB@A&vȴ9X@A&%@A&@A&@A&}Vl@A&Q@A&t@A&A@A&Ϫ͟@A&ߤ?@A&ߤ?@A'@A'Ft@A',@A'.H@A'1@A'>6z@A'_o@A'b}V@A'iDg8@A'ݗ+@A'r@A'+@A'+@A'حV@A'@@A'-@A'-@A'rGE9@A'#@A(     @A(F]d@A(}H@A(4m9@A(oiDg8@A('RT@A(tj@A(@A(d8@A({@A(U@A(e+@A(e+@A(@A({@A) ѷ@A)+@A)@A)@N@A)-w1@A)7KƧ@A):S@A)N;5@A)e+a@A)x@A)'RTa@A)o@A)(@A)D@A)o@A)_o@A)N;6@A)@A)s@A*	 @A*-V@A*T`d@A*h	ԕ@A*ݘ@A*\(@A*S&@A*\(@A*ᰊ@A*0
@A*0
@A*Y@A*͞&@A*m\@A+u%@A+C,z@A+33333@A+C%@A+xF]@A+@A+q@A+:)z@A+$@A+Z@A+|@A+
=p@A+lC@A+A [@A+$@A,1&y@A,/{J#@A,PH@A,cA \@A,~($x@A,#@A,?@A,qj@A,o h@A,*1@A,TɆ@A,S@A,쿱[@A,3@A,?@A,?@A,֡a@A,!-w@A,>@A-o i@A-*0@A-qu"@A-Q@A-qu"@A-Q@A-2a|@A-+a@A-2a|@A-84֡@A-5Xy>@A-?|h@A-<64@A-B@A-O;dZ@A-jOv@A-m\@A-}H@A-Xy=@A-Xy=@A-1@A-@A-@A-cA @A-cA @A-
qv@A-E@A-C\@A.
L/@A.8YJ@A.8YJ@A.;5X@A.BZc @A._ح@A.iB@A.p:~@A.af@A.-@A.}Vl@A.}Vl@A.Q@A.A@A.@A.Fs@A/Ft@A/1@A/!-w1@A/$tS@A/As@A/eں@A/lC@A/sPH@A/{J#:@A/	      @A/kP@A/?@A/zH@A/3@A/vȴ9@A/fA@A/حV@A/@A0F]d@A0@A0     @A0 ě@A04m9@A04m9@A073@A0H@A0U2a|@A0l"h	@A0y=c@A0tj@A0U@A09Xb@A0
(@A0
(@A0TɅ@A0ѷX@A0҈p@A0`A7@A0{@A0PH@A1$/@A1$/@A1@A1@N@A1@A14J@A1:S@A1=b@A1N;5@A1hr @A1ae@A1rGE8@A1|Q@A1l@A1|@A12W@A1@A1Y}@A2I^5@A2	 @A2	 @A2	 @A2e+@A2@A26C@A23@A2s@A2)y@A21'@A2d7@A2S&@A2L/{@A2@A2wkQ@A20
@A2ᰊ@A2wkQ@A2g	@A2}Vm@A2)_@A2͞&@A2䎊q@A2C,@A2c	@A2D@A2c	@A274@A2m@A2m\@A3C,z@A3&@A3	@A3"`B@A3PH@A3s@A3'/@A3nP@A3nP@A3s@A3u%@A3'/@A333333@A3C%@A3=K^@A3=K^@A3J#9@A3:)z@A3*0U2@A3E@A3a@O@A3|@A3a@@A3Q@A3ݗ+k@A3@A41&y@A4J@A4xF@A4@A4Q@A4Q@A4!-w2@A4tj@A4tj@A4tj@A4Q@A4Q@A4%1@A42W@A49XbN@A4I^5?@A4PH@A4VϪ@A4`d@A4tSM@A4C@A4o h@A4#@A4C@A4*1@A4qj@A4zxl"@A47@A4?@A47@A4Z@A4Z@A4D@A5K]@A5V@A5!.H@A5%F
L@A55Xy>@A5IQ@A5ce@A5ce@A5sg@A5}H@A5M:@A5$/@A5ڹZ@A5hr!@A5%@A5U=@A5sh@A5@A5@A5n/@A5cA @A5S@A5!.@A6_o @A6
(@A6@A6($x@A6+jg@A6+jg@A65?|@A65?|@A6?@A6R<6@A6YJ@A6_ح@A6_ح@A6fffff@A6%@A6$t@A6Fs@A6@A6T@A6}Vl@A6@A6m\@A6t@A6m\@A6t@A6m\@A6m\@A6҈p;@A61@A61@A61@A6x@A6@A6Mj@A7)^@A7.H@A78}H@A7>6z@A7H˒:@A7Xe,@A7o@A7v_ح@A7|hs@A7	@A7kP@A7@A7-V@A7zH@A7/V@A7/V@A7vȴ9@A7K]d@A7˒:)@A7fA@A7@A7;dZ@A7rG@A7+j@A8@A8@A84m9@A8D*@A8NU@A8NU@A8U2a|@A8bM@A8hۋq@A8u!@A8@A8@A8'RT@A8@A8tj@A8d8@A8d8@A89Xb@A8
(@A8ěT@A8ѷX@A8F@A8҈p@A84֡b@A84֡b@A8\)@A8PH@A9	k~@A9_p@A9-w1@A9-w1@A90
)@A94J@A97KƧ@A9:S@A9A [@A9Gz@A9JE@A9JE@A9Gz@A9JE@A9Q@A9TɅo@A9XbM@A9ae@A9Dg8~@A9ae@A9k~(@A9rGE8@A9u!S@A9x@A9u!S@A9@A9R<6@A9@A9o@A9R<6@A9'RTa@A9l@A9'R@A9@A9_o@A9"`@A9y@A9iB@A9ᰉ'@A9e@A9@A9.H@A:n@A:	 @A:e+@A:#9@A:&IR@A:3@A:^5?|@A:h	ԕ@A:xl"h
@A:qiC@A:u%F
@A:xl"h
@A:~"@A:L_@A:\(@A:ᰊ@A:L/{@A:@A:W@A:sP@A:G{@A:c	@A:D@A:~@A:m\@A:~@A;S&@A;҉@A;nP@A;PH@A;"`B@A;)^	@A;/V@A;=K^@A;F]c@A;Z@A;W>6z@A;Z@A;~$@A;@A;Mj@A;wk@A;wk@A;m]@A;Z@A;6@A;҈@A;g@A;C]@A;$@A;$@A<1&y@A<L_@A<L_@A<Q@A<!-w2@A<2W@A<Fs@A<C,zx@A<M:@A<]ce@A<o h@A<C@A<S@A<zxl"@A<TɆ@A<@A<7@A<*0@A<Z@A<u"@A<hr@A<!-w@A<E@A='0@A=Q@A=%F
L@A=5Xy>@A=84֡@A=IQ@A=\@A=fA@A=m\@A=p
=@A=M:@A=!R@A=+j@A=U=@A=Xy=@A=@A=@A=H˒@A=Ϫ͞@A=S@A=b@A> ѷY@A>
(@A>
L/@A>4K@A>u@A>Ov_@A>Ov_@A>+jg@A>.2@A>;5X@A>L/{J@A>H@A>c	@A>c	@A>s@A>p:~@A>vȴ9X@A>$t@A>,<@A>@A>A@A>]cf@A>ߤ?@A>]cf@A>]cf@A>ߤ?@A>C-@A>C-@A>1@A>1@A>1@A>Fs@A?Ft@A?
M;@A?!-w1@A?'/W@A?$tS@A?$tS@A?!-w1@A?+I@A?1@A?4֡a@A?As@A?O
M@A?Xe,@A?eں@A?lC@A?v_ح@A?4m@A?&@A?4m@A?@A?@A?ݗ+@A?&@A?zH@A?[W>@A?zH@A?3@A?3@A?/V@A?vȴ9@A?K]d@A?@A?حV@A?@@A?䎊r@A?@A?-@A?-@A?-@A?rGE9@A@bM@A@}H@A@ ě@A@:~ @A@:~ @A@:~ @A@D*@A@K]c@A@U2a|@A@r Ĝ@A@r Ĝ@A@YJ@A@@A@@A@\)@A@PH@A@\)@AA	k~@AA$/@AA+@AA [7@AA-w1@AA4J@AA=b@AAN;5@AAae@AAo hی@AArGE8@AAu!S@AA~($@AA@AA@AAR<6@AAu@AAu@AAl@AA(@AAB@AAX@AA@AAԕ*@AAiB@AAe@AAe@AAᰉ'@AA>BZ@AA@AAlD@ABu%F@ABI^5@AB3@AB3@ABGE85@ABM@ABT`d@ABT`d@AB^5?|@ABkP|@ABnO@ABh	ԕ@ABnO@ABqiC@ABxl"h
@AB@4@AB~"@ABݘ@AB\(@AB0
@ABS&@ABwkQ@ABvȴ@ABS&@ABS&@AB@AB>B@AB}Vm@ABY@AB)_@AB)_@ABW@AB͞&@ABG{@ABG{@ABc	@AB74@ABD@AC'/@ACPH@AC	@AC	@AC6z@ACF]c@ACZ@ACZ@ACS@AC]cA@ACa@N@ACdZ@ACg	l@ACtj~@ACqu!@ACQ@ACMj@ACA@ACU=@ACwk@ACS@ACm]@AC~($@ACZ@ACZ@AC6@ACƧ@ACƧ@ACa@@ACݗ+k@AC%2@ACQ@AC%2@AC҈@AClC@AC%2@ACA [@AC$@AC\N@AC\N@ADn.@ADJ@ADxF@AD@AD!-w2@AD!-w2@AD%1@AD"h	ԕ@AD(\@AD2W@AD?@ADFs@ADPH@ADPH@ADVϪ@AD]ce@ADcA \@ADm8@ADtSM@ADo h@AD#@AD#@AD?@AD~($x@AD#@ADN;@ADS@ADN;@ADTɆ@AD?@AD?@AD7@AD֡a@AD>B[@AD/@AD>B[@AD>B[@ADu"@AD@ADhr@AD!-w@ADe@AEu@AE!.H@AE!.H@AE/w@AE/w@AE+a@AE/w@AE/w@AE5Xy>@AE2a|@AE?|h@AEL_@AES&@AES&@AEVl!@AEY|@AE\@AEce@AEfA@AEfA@AEw1@AEsg@AEݗ@AEO
@AEO
@AE+j@AE+j@AE%@AEH˒@AE\(@AE\(@AE8Y@AEϪ͞@AE@AE8YK@AEb@AE,=@AFt@AF
(@AF_o @AFt@AF
L/@AFOv_@AF$/@AF!R<@AF+jg@AF1.@AF8YJ@AFE@AF;5X@AFBZc @AFL/{J@AFH@AFL/{J@AFVu@AFYJ@AFYJ@AFc	@AFfffff@AFc	@AFfffff@AFl!-@AFz@AF}Vl@AF%@AF@AF@AF,<@AF,<@AFaf@AFaf@AFT@AF6z@AFQ@AFȴ9X@AFϪ͟@AFߤ?@AF1@AF쿱[W@AG@AG
=p@AG
M;@AGv@AG'/W@AG1@AG1@AG1@AG8}H@AGKƧ@AGO
M@AGRT`e@AGU=@AG\(@AGb}V@AGb}V@AGeں@AGlC@AGo@AGsPH@AGlC@AGlC@AGv_ح@AGlC@AGlC@AG4m@AG4m@AG&@AGO;d@AGO;d@AG?@AG/V@AGr@AG@AG@AGr@AG+@AG@AG@AGVϫ@AGVϫ@AGrGE9@AG䎊r@AG䎊r@AHF]d@AHbM@AH6@AH ě@AH$xG@AH'RT`@AH4m9@AH4m9@AH4m9@AH:~ @AH:~ @AH:~ @AHD*@AHH@AHXy=@AH_F@AHeO@AHoiDg8@AHl"h	@AHr Ĝ@AHoiDg8@AHr Ĝ@AHy=c@AH|@AH˒:*@AHn@AHtj@AH-
@AH9Xb@AH4m@AH{@AH9Xb@AH9Xb@AH4m@AH
(@AHTɅ@AHTɅ@AH)^@AH@@AH)^@AHD@AHۋq
@AH҈p@AH`A7@AH`A7@AH`A7@AH4֡b@AH4֡b@AH{@AH{@AH	k@AIrGE@AI@AIrGE@AI_p@AI@AI@AI#w@AI#w@AI-w1@AI-w1@AI7KƧ@AI7KƧ@AI=b@AIA [@AIA [@AI=b@AIDg8~@AITɅo@AITɅo@AI^@AIae@AIhr @AIk~(@AIo hی@AIrGE8@AIrGE8@AIx@AIoiD@AI~($@AI'RTa@AIB@AIB@AI|@AI|@AIX@AI2W@AI2W@AI                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     @rfffff@rfffff@r@r@r@r@r@r@r     @r33333@rfffff@rfffff@r33333@rfffff@r     @rfffff@r@rfffff@r@r33333@r33333@rfffff@r     @r@rfffff@r@rfffff@r@r@r     @r33333@r@rfffff@r33333@r@r@r33333@r@r@r@r@rfffff@rfffff@r     @r@r@r@rfffff@rfffff@r@r33333@r@r@r33333@r@rfffff@r     @rfffff@r@r33333@r33333@r@r@r@r@r     @r33333@r@r@r     @r33333@r33333@rfffff@rfffff@rfffff@rfffff@rfffff@r@r@r@rfffff@r33333@r     @r@r     @r@r@r33333@r     @rfffff@r     @r@r@r@r@rfffff@rfffff@r33333@r33333@r@r     @r@r33333@rfffff@r33333@r@rfffff@r~fffff@rnfffff@rc33333@rX     @rI@rC33333@rI@r)@q@q     @q9@p33333@pvfffff@o&fffff@l@l\@lfffff@kə@jp     @is33333@h     @h@iə@h33333@h|@hVfffff@h<@h#33333@hfffff@g     @g33333@g33333@g     @h33333@g33333@gfffff@g@g33333@gs33333@gc33333@gI@g<@g&fffff@g     @g33333@fə@ffffff@fC33333@f@e     @e@e     @ei@eVfffff@eL@eL@eL@e)@e@dfffff@d33333@d@d@dffffff@dI@d0     @d@d33333@d	@dfffff@d      @c@cfffff@cfffff@c     @c33333@cy@cs33333@cl@cffffff@cL@cC33333@c9@c0     @c#33333@c33333@c@b     @b33333@bfffff@b`     @bP     @b9@b#33333@b33333@afffff@afffff@aə@afffff@a     @a@a@a     @a@a33333@avfffff@al@a\@a@     @a@a33333@`@`fffff@`33333@`     @`33333@`@`33333@`l@`Vfffff@`333333@`@`	@_33333@_@_@_@_@_@_     @_@_     @_l@_`     @_,@_@^@^     @^@^     @^     @^fffff@^l@^`     @^Y@^L@^@     @^,@^      @^fffff@]     @]     @]`     @]&fffff@\33333@\@\33333@\y@\`     @\,@\      @[ٙ@[     @[y@[,@[@[fffff@Z@Z33333@Z@Z33333@Z@Z     @ZL@Z      @Y@Y@Y33333@Y`     @YS33333@Y@     @Y@     @Y@X33333@Xfffff@X@Xs33333@X`     @X,@Wfffff@Wl@WFfffff@W&fffff@W33333@W33333@W@W      @Vfffff@V@Vfffff@Vs33333@VS33333@VY@V&fffff@V@Vfffff@U33333@U     @U     @U33333@Ufffff@U@Ufffff@U     @U33333@Uy@UFfffff@U@T@T     @T@T     @Tfffff@T     @T`     @TS33333@T@     @T&fffff@Tfffff@T@S@S33333@Sfffff@S     @S@Sfffff@S33333@S     @Ss33333@S9@R@R     @R@R     @R@Rl@R,@Rfffff@R      @Qfffff@Q     @Q     @Q33333@Q@Qfffff@Q33333@Q     @Qy@Qy@Q@Q@Q@Q@Qfffff@Q     @Q@Q33333@Q     @Q`     @Q9@Q9@Q,@Q&fffff@Q&fffff@Q&fffff@Q@P@P33333@P@P33333@Pfffff@P33333@P@Pfffff@P@Pl@P9@P@Offfff@O@O@Offfff@Offffff@O333333@N33333@Nfffff@N33333@O      @N33333@N33333@Nffffff@N@M@Mٙ@Mfffff@Ms33333@M@     @M@L33333@Lfffff@Lٙ@L@LY@L&fffff@L@     @Kfffff@Ks33333@K&fffff@J33333@J@J33333@KL@KY@K@     @KL@KL@KL@K&fffff@K333333@K@Jfffff@J33333@J@Js33333@J     @J     @I33333@Ifffff@I@I@Iffffff@I     @Is33333@Is33333@I@Hfffff@Hfffff@H     @HY@Hs33333@Hs33333@HL@H@Gٙ@G     @G@G@G     @Gfffff@Gs33333@GL@G@     @G@F@F@Fs33333@FY@F&fffff@Fffffff@F@     @F@F@F      @Eٙ@E@E@Effffff@Effffff@E@     @E@D33333@D@Dfffff@D@DY@D&fffff@C33333@C33333@Cٙ@C     @C@Cfffff@CY@C@Bٙ@B     @Bs33333@B@B@B@B@B@Bfffff@B@     @B@A33333@A     @Affffff@A333333@A@@33333@@@@fffff@@     @@ffffff@@ffffff@@s33333@@s33333@@s33333@@     @@@@33333@@fffff@@fffff@@@@@@s33333@@L@@&fffff@@333333@@&fffff@@&fffff@?@?L@>fffff@>33333@>ffffff@>333333@=fffff@=@>333333@>L@>ffffff@>@>@>@?L@?333333@>fffff@>33333@>L@>L@>      @>      @=fffff@=@=33333@=ffffff@=@=     @=ffffff@=333333@=333333@=      @=      @=@=      @=333333@<@<@<fffff@<@<@<@<@<33333@<@<ffffff@<L@<      @<L@<L@<333333@<@;fffff@;fffff@;33333@;     @;      @:fffff@:fffff@;      @:@:     @:L@:@9@9@:@9fffff@9ffffff@9      @8fffff@9L@9L@9L@9L@9ffffff@8fffff@9      @9333333@9L@9333333@9333333@9@8fffff@8fffff@8fffff@9@9@9333333@8fffff@833333@8     @8ffffff@8ffffff@8L@8@7@7fffff@7fffff@7fffff@7fffff@7fffff@7@7@7@733333@7ffffff@7ffffff@7L@7L@7L@6fffff@6@6@6     @6@6@6333333@6     @6@6     @6333333@5fffff@6      @5@5@5fffff@533333@5@5@5     @533333@533333@5@5     @5ffffff@5ffffff@5L@4@5@5L@5L@5L@5      @4fffff@433333@4fffff@4@4     @4     @4     @4@4     @4L@4@4     @4L@4@4333333@4L@4333333@4L@4ffffff@4333333@4333333@3fffff@3fffff@4      @4@4      @4      @4      @3fffff@3@333333@3     @3fffff@333333@3@3L@3ffffff@3@3     @3     @3     @3ffffff@3ffffff@3333333@3333333@3@3@3      @3@3333333@2fffff@233333@2fffff@2@2@233333@2@2     @2@2fffff@2@233333@2     @2     @2ffffff@2@2     @2     @2333333@2      @2      @2      @1fffff@1@1fffff@1fffff@1@133333@1     @133333@1@133333@1@1@1fffff@1fffff@1@1ffffff@1     @1@1ffffff@1@1     @1ffffff@1ffffff@1L@1333333@1L@1333333@0fffff@1      @1L@1333333@0fffff@1@1@1      @0fffff@0@033333@0fffff@0fffff@0@1      @0@033333@033333@0@0fffff@1      @0fffff@033333@033333@1333333@033333@0L@0333333@0L@0ffffff@0     @0ffffff@0L@0333333@0     @0L@0333333@0      @0ffffff@0ffffff@0L@0      @0      @0L@0     @0L@0@0L@0333333@0L@/@/@/ffffff@/@0      @0      @/@/@/@/@/@/@/@0      @0@/@/ffffff@/ffffff@/333333@/ffffff@0@0L@0L@0333333@0333333@0@0@0333333@0333333@0L@0L@0333333@0      @0      @0L@0333333@/@0333333@0333333@0L@/ffffff@/333333@0@0      @0      @0@0333333@0L@0ffffff@0L@0ffffff@0L@0ffffff@0     @0     @0L@0ffffff@0     @0ffffff@0@/@/@0      @0@0L@0333333@0L@0L@0@1L@1ffffff@1@1@1333333@1L@1ffffff@1L@1ffffff@1@1fffff@2@1ffffff@1@1@1@133333@1     @1fffff@1fffff@133333@1@1     @2333333@133333@1ffffff@1fffff@1@1@133333@133333@1@1@1fffff@1fffff@1@1@1@1@1@133333@1ffffff@1fffff@2      @1     @1L@1     @1ffffff@1L@1ffffff@1@1@1ffffff@1L@1ffffff@1ffffff@133333@1@1     @1      @1@1L@1@1@1L@1333333@1L@1@1L@1L@1ffffff@1@1L@1      @1333333@1333333@1@1ffffff@1L@1L@1      @1@1L@1     @1ffffff@1      @1333333@1@0fffff@1333333@1      @1      @1333333@1L@1L@1333333@1@1333333@1333333@1     @0fffff@1333333@1333333@1      @0@0@0ffffff@0L@0L@/333333@.@.@/ffffff@/@/333333@.@/ffffff@0333333@0L@0L@/@/333333@/ffffff@/ffffff@/333333@.ffffff@-@.@0      @/@.ffffff@.333333@.333333@.333333@/333333@/@/@/@0L@0ffffff@0L@/@/@/@0L@0333333@0L@0L@0@033333@0fffff@1333333@0@0@0     @0     @0L@/@0333333@0333333@/ffffff@/ffffff@0      @0@0      @0@0      @0@0@/@0@0@033333@0@0     @033333@0fffff@0@1      @0@0@033333@033333@0@0@033333@0@0@0@0     @0     @0@0fffff@1L@1@0fffff@1333333@1333333@0@1      @1      @0fffff@1      @1      @033333@0fffff@0@0@1@1333333@0fffff@1@0fffff@0fffff@1@1      @0@0@0fffff@0fffff@1@0fffff@0fffff@0@033333@0@0     @0@0@0fffff@0@0L@0@1@0@0@0fffff@0     @0L@0     @0L@0     @0@0@1      @1@0fffff@0@1333333@0@1@1333333@1@1333333@1ffffff@1333333@0fffff@1@1333333@1333333@1@1333333@1      @1L@1333333@1@1333333@1333333@1@1@1@1333333@1333333@1333333@1333333@1333333@1333333@1@1@1@1333333@1L@1@1333333@1@1L@1333333@1      @033333@1333333@1ffffff@1ffffff@1@033333@1333333@1@0@0@0fffff@0@0fffff@1@0@0fffff@0fffff@0@0     @0     @0@0@033333@0@0@0@0@0fffff@0@0@0fffff@0@0@0fffff@0@0fffff@1      @033333@0fffff@0fffff@0fffff@0fffff@0@1      @1@1@0fffff@1333333@1333333@1      @0fffff@0fffff@0@0@1L@0@0fffff@0fffff@1@1      @1333333@1333333@1333333@1L@1L@1333333@1@1fffff@1     @1      @0@033333@1      @1L@1333333@1333333@1ffffff@1     @133333@133333@1@1@1@133333@1fffff@1@2      @1@1fffff@1ffffff@1@1fffff@2@1@1@1@1fffff@133333@133333@1@1     @1@133333@1fffff@1@1@1@1@2      @2333333@2L@2@1fffff@133333@1@133333@1fffff@1fffff@2      @1fffff@2@2333333@2L@1fffff@2L@2     @2     @2333333@2333333@2333333@2@2@2@233333@2ffffff@2     @2@2@2fffff@2@2@2fffff@2@2@3@2@2@3ffffff@3@2fffff@233333@3      @3L@3     @3     @3333333@3L@3L@3L@3333333@3L@3333333@3     @333333@3@3333333@3ffffff@3ffffff@3fffff@3fffff@3fffff@3@3@3fffff@4333333@4      @3fffff@4@4ffffff@4333333@4@4333333@4@4333333@4ffffff@4@4     @4L@4333333@5      @4fffff@4fffff@4@4     @433333@5L@5      @4@5@5333333@5ffffff@5333333@5@4@5333333@533333@5     @5@5@5@5@5333333@5@5     @5@533333@6@6@6@6333333@6      @5@5@6     @6333333@6ffffff@6L@6333333@6@6fffff@633333@6@7      @7      @6fffff@7      @7333333@7L@7ffffff@7ffffff@733333@7@7@7@7@7@7fffff@8333333@8L@7fffff@8@7fffff@8@8ffffff@8@8     @8     @8     @8     @8@9@9L@8fffff@9@9      @9      @9      @9ffffff@9     @9     @9@9     @9ffffff@9L@9ffffff@933333@:      @:333333@:ffffff@:L@:ffffff@;      @:fffff@:@:@:@;@:@:fffff@;@;      @:@;L@;333333@;     @;L@;L@;     @;ffffff@;333333@;333333@;L@;@;L@;     @;33333@;33333@;@;@;@;@;fffff@<@<333333@<      @<333333@<333333@<@<@<33333@<fffff@<33333@<fffff@<@=      @=     @=333333@=     @=@=333333@=ffffff@=@>      @=33333@>      @=@>      @=@=@=@=fffff@>L@>L@>33333@>@>     @>333333@>     @>@>@?      @>33333@>@>fffff@>fffff@?333333@?ffffff@?     @?@?ffffff@?333333@?      @?L@?L@?     @?     @@      @?     @?33333@@@@      @@@@@     @@&fffff@@ffffff@@@     @@&fffff@@333333@@&fffff@@L@@Y@@ffffff@@ffffff@@L@@Y@@ffffff@@s33333@@@@@A      @A@@33333@@fffff@@33333@@fffff@@@@     @A      @@33333@A@A@A@A333333@A@     @A@A&fffff@A333333@A     @Affffff@A@     @A&fffff@A@A@     @AY@A@A     @A@AL@AY@A     @A     @A33333@A     @A@A     @A33333@B      @A33333@A@A     @B&fffff@BY@BL@Bffffff@Bffffff@BY@BL@B@Bs33333@B@Bfffff@B33333@B33333@B33333@B@Bfffff@B@C@C@C@B33333@C@C333333@C      @C@C&fffff@C&fffff@C@C      @CL@CL@Cffffff@C@C&fffff@C@     @Cffffff@C33333@C@C@C@C@C     @C33333@Cٙ@C@C     @D&fffff@D333333@D&fffff@DY@DY@Dffffff@D@     @D@D@D     @D@D     @D@D@Dfffff@Dٙ@E      @D33333@D33333@E@Dٙ@E@Dfffff@D33333@D     @D33333@E      @E@E&fffff@E&fffff@E&fffff@EL@E333333@EL@Effffff@EY@EL@E@E@E@E@E@Eٙ@E     @Eٙ@F@Efffff@F@F&fffff@E33333@E33333@F&fffff@FL@Fffffff@FY@F@     @F333333@Fffffff@FY@F&fffff@F@F@Ffffff@F33333@F@F33333@F@Ffffff@F@F     @Fٙ@Ffffff@F@Fٙ@F33333@G      @G@G@G333333@Fٙ@G@Gffffff@Gffffff@GY@G333333@G333333@GL@GY@GY@GY@G     @G@G     @G@Gٙ@G     @G     @Gٙ@G33333@Gfffff@H      @Gfffff@G33333@H      @G33333@Gfffff@H333333@H&fffff@H333333@HL@HL@Hffffff@H@     @Hs33333@H@H@Hfffff@H@H@Hs33333@H@     @Hs33333@H33333@H     @H@H@H33333@H@I&fffff@I333333@I&fffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     ?ۥS?ڰ ě?xF?lC?ڏ\(?~"?r ě?-V?
=p?333333?܋C%?\(\?zG{?o?zG?O;dZ?zG{?QR?/w?5?|h?\(?
=p?I^5?~"?E?n?+?lC?j~"?+J?(\)?+J?蛥S?zG{?ěS?`A7K?tj?A7Kƨ?nP?I^5??ěS?(\)?O;dZ?E?ěS??|hs?A7Kƨ?畁$/?vȴ9X?I^5?I^5?}?QR?S?-V?1&x?1&y?Ƨ-?hr!?O;dZ?^5?|?C%?1&?&x?bM??1&y?hr!?睲-V?1&x?ěS?C$?Gz?E?XbM?$/?Vu?9XbN?9XbN?m?x?&x?p
=q?9XbN?5?|h?O;dZ?GzH?7KƧ?-V?O;dZ?bM? ěT?`A7K?lC?陙?zG?x? ě?-V?=p
=?Q?7KƧ?Q?1&?-V?$/?x??|hs?      ?|hr?C$?"`A? ě?tj~?
=p?GzH?tj?-V?ěS?I^5?}?Vt?׾vȴ9X?ЃnP?̋C%?;dZ?~"?Ł$/?`A7?vȴ9X?-V?p
=q?QR?E?\(?tj~?tj~?O;dZ?E?j~#?333333?Q?`A7L?nO;?Q?333333?hr Ĝ?l?hr Ĝ? ě?nO;?hr Ĝ?hr Ĝ?Q?`A7L?bM?&x?`A7L? ěT?`A7L?
=p? ěT?`A7L?`A7L?Q?`A7L?bM?Q? ěT?`A7L?&x?&x?`A7L? ěT? ěT?vȴ9X?vȴ9X?bM?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?Q?
=p?;dZ?;dZ?;dZ?hr Ĝ?&x?`A7L?-V?nO;?`A7L?
=p?&x? ěT?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ? ěT?;dZ?vȴ9X?vȴ9X? ěT? ěT? ěT? ěT?;dZ?bM? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?bM? ěT? ěT?`A7L?
=p?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?`A7L? ěT?
=p? ěT? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ? ěT? ěT? ěT? ěT? ěT?vȴ9X? ěT? ěT?bM?vȴ9X?bM?;dZ?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?Q?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?Q?Q?Q?5?|h?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?Q?vȴ9X?`A7L?Q?Q?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?Q?;dZ?Q?;dZ?;dZ?vȴ9X?Q?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?Q? ěT?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?5?|h?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?Q?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?Q?Q?Q?;dZ?Q?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?Q?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?vȴ9X?;dZ?Q?Q?;dZ?vȴ9X?vȴ9X?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?
=p?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?Q?;dZ?Q?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?Q?Q?;dZ?;dZ?Q?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?Q?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?Q?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?Q?Q?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?vȴ9X?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?Q?Q?Q?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?Q?Q?Q?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?Q?5?|h?;dZ?;dZ?;dZ?;dZ?5?|h?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?Q?5?|h?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?;dZ?;dZ?Q?;dZ?Q?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?vȴ9X?Q?5?|h?Q?Q?Q?;dZ?Q?Q?5?|h?Q?Q?;dZ?;dZ?Q?;dZ?5?|h?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?5?|h?5?|h?5?|h?;dZ?5?|h?5?|h?Q?5?|h?Q?Q?5?|h?5?|h?Q?Q?Q?;dZ?Q?5?|h?Q?Q?Q?5?|h?5?|h?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?5?|h?Q?Q?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?Q?Q?5?|h?Q?5?|h?5?|h?Q?Q?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?5?|h?-V?5?|h?Q?;dZ?;dZ?Q?Q?;dZ?Q?Q?;dZ?;dZ?Q?Q?Q?Q?Q?;dZ?Q?Q?5?|h?Q?Q?Q?;dZ?5?|h?5?|h?Q?;dZ?vȴ9X?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?5?|h?Q?;dZ?Q?;dZ?Q?5?|h?Q?;dZ?;dZ?Q?Q?Q?Q?Q?5?|h?5?|h?Q?Q?Q?;dZ?5?|h?Q?Q?5?|h?5?|h?Q?Q?5?|h?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?5?|h?5?|h?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?5?|h?Q?Q?Q?5?|h?5?|h?Q?5?|h?5?|h?Q?Q?Q?Q?Q?5?|h?Q?5?|h?Q?Q?Q?Q?Q?;dZ?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?5?|h?Q?5?|h?5?|h?5?|h?Q?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?Q?5?|h?Q?Q?Q?-V?/v?5?|h?5?|h?Q?Q?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?-V?5?|h?5?|h?5?|h?Q?5?|h?Q?-V?-V?5?|h?5?|h?Q?5?|h?5?|h?Q?Q?-V?5?|h?5?|h?5?|h?5?|h?Q?5?|h?Q?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?Q?Q?5?|h?Q?Q?Q?-V?-V?5?|h?Q?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?-V?-V?5?|h?5?|h?5?|h?5?|h?5?|h?/v?5?|h?5?|h?Q?5?|h?5?|h?/v?/v?5?|h?5?|h?5?|h?/v?-V?5?|h?5?|h?/v?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?1&y?/v?-V?-V?-V?5?|h?/v?5?|h?/v?/v?5?|h?Q?5?|h?5?|h?5?|h?-V?-V?/v?5?|h?5?|h?5?|h?5?|h?-V?/v?/v?5?|h?5?|h?5?|h?-V?-V?5?|h?Q?5?|h?/v?/v?/v?5?|h?5?|h?5?|h?5?|h?-V?/v?-V?5?|h?5?|h?-V?5?|h?-V?/v?5?|h?/v?/v?-V?/v?-V?5?|h?-V?-V?-V?-V?/v?/v?1&y?5?|h?/v?5?|h?5?|h?-V?/v?-V?5?|h?5?|h?-V?5?|h?-V?-V?-V?5?|h?5?|h?5?|h?Q?5?|h?/v?/v?5?|h?-V?5?|h?/v?-V?/v?/v?1&y?/v?/v?1&y?/v?1&y?-V?/v?/v?-V?-V?/v?/v?-V?5?|h?/v?/v?/v?-V?-V?/v?1&y?5?|h?1&y?/v?/v?1&y?-V?5?|h?5?|h?/v?5?|h?/v?/v?-V?1&y?1&y?-V?1&y?-V?-V?/v?/v?/v?/v?-V?-V?1&y?/v?/v?5?|h?5?|h?-V?/v?/v?/v?/v?/v?/v?/v?-V?-V?1&y?/v?-V?/v?/v?-V?1&y?-V?/v?/v?1&y?/v?/v?1&y?/v?/v?1&y?1&y?/v?/v?1&y?1&y?/v?-V?/v?/v?/v?-V?/v?/v?1&y?5?|h?/v?/v?/v?1&y?1&y?/v?1&y?/v?1&y?1&y?/v?1&y?1&y?1&y?1&y?1&y?1&y?1&y?/v?-V?1&y?1&y?1&y?1&y?/v?/v?1&y?1&y?1&y?/v?/v?/v?-V?1&y?/v?/v?/v?1&y?/v?/v?1&y?(\)?/v?1&y?/v?1&y?1&y?1&y?1&y?-V?1&y?(\)?1&y?/v?/v?1&y?1&y?/v?/v?1&y?/v?1&y?1&y?(\)?(\)?1&y?1&y?1&y?1&y?1&y?1&y?1&y?/v?1&y?1&y?1&y?/v?1&y?1&y?1&y?(\)?/v?1&y?1&y?(\)?1&y?1&y?S?1&y?/v?1&y?1&y?/v?1&y?1&y?1&y?/v?/v?1&y?1&y?/v?1&y?1&y?1&y?1&y?/v?1&y?(\)?1&y?1&y?(\)?(\)?1&y?/v?1&y?1&y?1&y?1&y?1&y?1&y?1&y?(\)?1&y?(\)?1&y?1&y?-V?(\)?1&y?(\)?(\)?1&y?1&y?1&y?(\)?1&y?1&y?(\)?1&y                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     @qk33333@o@k@gI@c33333@`     @\     @\`     @\33333@Y33333@W&fffff@UFfffff@S@Ry@QFfffff@Offfff@Ms33333@K@I@     @K@IY@H      @Fٙ@E     @E@Es33333@Efffff@D@     @BL@B&fffff@BY@A     @@fffff@?333333@>      @=333333@<@:@9ffffff@8L@7L@6@4@3fffff@3      @1@0@.@-      @+@*ffffff@)333333@(      @&@%@$@#@"@!@!      @ 333333@@333333@      @@333333@@ffffff@333333@ffffff@333333@ffffff@@@      @
@      @
ffffff@@333333@ffffff@@      @333333@ffffff@ @       @       ?ffffff??333333??      ?      ?ffffff???333333?333333?񙙙?񙙙?      ?      ???陙?陙?ffffff?ffffff?ffffff?333333?333333?333333?333333?      ?      ?      ?ٙ?ٙ?ٙ?ٙ?ٙ?333333?333333?333333?333333?333333?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?????????????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	P23                                     1                                       )BGh
3