CDF       
      pressure  Q   time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20170205   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P22    CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:34.751795Z    ORIGINAL_HEADER      6CTD,20250210CCHSIOWB
#Removed 'CTDFLUOR_TSG' as it's filled with -999
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2017-06-29. CTD data from cruise 18DD20170205, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20170205. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2017-001/index.php. 
#
# The information in this file for the cruise 2017-001 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-0036.ctd
#
# Start of originator file comment header
#
#*2017/06/29 15:26:50.02
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2017/02/10 06:17:38.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 198
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : CE9F1F72
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            0.3            202.1
#       2 Temperature:CTD               deg_C_(ITS90)   5.6248         6.8697
#       3 Salinity:CTD                  PSS-78          32.78          33.8432
#       4 Sigma-t:CTD                   kg/m^3          25.7461        26.7106
#       5 Oxygen:Dissolved:CTD:Volume   ml/l            3.4            6.87
#       6 Oxygen:Dissolved:CTD:Mass     µmol/kg         147.7          299
#       7 Fluorescence:CTD:Seapoint     mg/m^3          0.66E-01       1.162
#       8 PAR:CTD                       µE/m^2/sec      0              0.3
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        7  F       ' '     2
#       6  -99   ' '        6  F       ' '     1
#       7  -99   ' '        8  F       ' '     3
#       8  -99   ' '        7  F       ' '     1
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2017-001
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P21
#    EVENT NUMBER        : 36
#    LATITUDE            :  49  38.00000 N  ! (deg min)
#    LONGITUDE           : 139  39.97000 W  ! (deg min)
#    WATER DEPTH         : 3961
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    The descent rate of the CTD was very noisy with some complete reversals
#	of direction.
#    CTDEDIT was used to remove many records corrupted by shed wakes;
#	salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Fluorescence and PAR data are nominal and unedited except that some records were
#	removed in editing temperature and salinity and a large spike in
#	fluorescence was removed from file 0032.
#
#    The Transmissivity channel was removed because of frequent shifts in values during
#	casts and large variations between values during repeat casts.
#	The data are available, by request, from the chief scientist.
#
#    NOTE: While the Fluorescence:CTD data are expressed in concentration units, they
#	do not always compare well to extracted chlorophyll samples, particularly for
#	casts far from shore. It is recommended that users check extracted chlorophyll
#	values where available.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in Sea-Bird
#	Application Note #64-2, June 2012 revision (Sea-Bird_64-2_Jun2012.pdf), except 
#	that a small offset in the fit was allowed.
#
#    The Dissolved Oxygen sensor used in files 0001, 0002 and 0016 malfunctioned so the 
#	Oxygen:Dissolved:CTD channels were removed from those files.
#
#    The Oxygen:Dissolved:CTD sensor has a fairly long response time so data accuracy 
#	is not as high when it is in motion as it is during stops for bottles. This will be
#	especially true when vertical dissolved oxygen gradients are large. To get an estimate
#	of the accuracy of the Oxygen:Dissolved:CTD data during downcasts (after recalibration)
#	a rough comparison was made between downcast Oxygen:Dissolved:CTD data and upcast 
#	titrated samples. Some of the difference will be due to problems with flushing of 
#	Niskin bottles and/or analysis errors, so the following statement likely underestimates 
#	Oxygen:Dissolved:CTD accuracy.
#
#    Downcast (CTD files) Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.25 ml/l from 0 to 125 dbar.
#	±0.2 ml/l from 125 to 400 dbar.
#	±0.1 ml/l from 400 to 600 dbar.
#	±0.05 ml/l from 600 to 1500 dbar.
#	Low by up to 0.08 ml/l below 1500 dbar.
#
#    For details on the processing see document: 2017-001-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5--- --6-- ---7--- --8---
#!Pressu Temperat Salinity Sigma-t: Oxygen Oxyge Fluores PAR:  
#!re:CTD ure:CTD  :CTD     CTD      :Disso n:Dis cence:  CTD   
#!                                  lved:  solve CTD:          
#!                                  CTD:   d:CTD Seapoin       
#!                                  Volume :Mass t             
#!------ -------- -------- -------- ------ ----- ------- ------
#*END OF HEADER
     WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @C         data_max      @C         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     :  2   pressure                	long_name         pressure   positive      down   units         decibar    data_min      @	   data_max      @Zfffff   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      :  ml   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d           temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?S   data_max      @!@N   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       :     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d            salinity                	long_name         salinity   units         PSS-78     data_min      @@g|hs   data_max      @AJOv`   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      :     salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d       :L   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @1   data_max      @rfffff   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        : H   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d       x   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?(\)   data_max      ?5?|h   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      :    CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d       ̤   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min                 data_max                 C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       : H   PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d          	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min               data_max               C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     : $t   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d       ^   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( m   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( m   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      ).   data_max      ).   C_format      %10d       m   latitude               	long_name         latitude   units         	degrees_N      data_min      @Hى7Kƨ   data_max      @Hى7Kƨ   C_format      %9.4f          m   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      aZqx   data_max      aZqx   C_format      %9.4f          m   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d        m   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min        ~   data_max        ~   C_format      %4d        n @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @	@      @@      @@$      @%@*      @,      @.      @0      @2ffffff@3      @4      @5      @6      @7      @8      @8fffff@<@=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H@Hs33333@I      @I     @J      @J@Jٙ@K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @Qfffff@Rٙ@S      @S@     @S@S@S33333@T333333@Tfffff@T     @T@US33333@U@U     @V      @V@     @Vfffff@V     @W      @W@     @W     @W33333@Xfffff@X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @[@\L@\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`@a&fffff@a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @bY@b@b     @b     @b     @c      @c      @c9@c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d33333@də@d     @e      @e      @e@     @e`     @e     @e33333@eə@e     @f      @f      @f@     @f`     @f     @f33333@f     @g      @g      @g<@g`     @g     @g     @g33333@hfffff@h      @h@     @h`     @h|@h     @h     @h     @hfffff@ifffff@i     @i     @i     @j      @j      @j@     @jY@jfffff@j@j     @k      @k      @k<@k@k@k     @l      @l      @l@     @l`     @l     @lə@l@m      @m      @m@     @mS33333@m33333@m     @m     @m33333@n     @n@n@     @n`     @ny@nfffff@n     @n     @o      @o      @o@     @o`     @o     @o@o33333@o     @p      @p     @p      @p0     @p@     @pP     @p`     @ps33333@p~fffff@p     @p     @p     @p     @p     @p     @p     @q      @q@q1@q@     @qP     @q`     @qp     @q     @q     @qfffff@q@q33333@qfffff@q     @q     @r      @r     @r      @r1@r9@ra@rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s.fffff@sC33333@sP     @s`     @sp     @s     @s     @s     @s@s@s33333@s     @s     @t      @t     @t      @t1@tS33333@t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u@ufffff@u      @u0     @u@     @uP     @u`     @up     @u     @u     @ufffff@u@u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v@vfffff@v     @v     @v     @v     @v     @v     @vfffff@w333333@w@     @wP     @w`     @wq@w@w@w33333@w     @w     @w     @x      @x     @x      @x0     @x>fffff@xP     @x`     @xp     @x~fffff@x33333@x     @x     @x     @x     @x     @y      @y     @y@y@     @yP     @y`     @yp     @y{33333@yfffff@yfffff@y     @y     @yfffff@yᙙ@y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @zfffff@{@{     @{      @{0     @{@     @{P     @{`     @{k33333@{@{     @{     @{     @{     @{fffff@{     @{     @|      @|     @|@|6fffff@|@     @|P     @|`     @|p     @||@|@|@|     @|     @|     @|     @|     @}      @}     @}      @}6fffff@}>fffff@}P     @}`     @}p     @}     @}     @}     @}fffff@}љ@}     @}     @~      @~     @~      @~0     @~@     @~P     @~Y@~vfffff@~     @~     @~     @~     @~     @~љ@~     @      @     @      @0     @@     @P     @a@i@33333@     @     @     @     @     @     @@     @     @      @(     @0     @8     @?33333@K33333@P     @X     @`     @h     @p     @vfffff@     @     @     @     @@33333@     @     @     @     @     @     @fffff@     @     @     @      @     @     @     @(@0     @8     @@     @H     @P     @X     @`     @h     @p     @w33333@     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @      @     @     @     @     @)@0     @8     @@     @H     @Rfffff@X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @      @     @
@     @      @(     @0     @8     @@     @H     @P     @X     @`     @ffffff@q@w33333@     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @      @     @     @     @      @$     @0@8     @@     @H     @P     @X     @`     @d     @q@x     @     @     @     @     @@     @     @     @     @     @     @     @33333@@      @     @     @     @      @(     @0     @8     @@     @Jfffff@P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @      @     @     @     @      @%@:fffff@@     @H     @P     @X     @`     @h     @p     @x     @     @fffff@@     @     @     @     @     @     @     @     @fffff@     @     @     @      @33333@     @      @(     @0     @8     @@     @H     @P     @X     @`     @g33333@t     @x     @     @     @     @     @     @     @@@     @     @     @     @33333@33333@     @     @      @     @     @     @      @(     @0     @6fffff@I@P     @X     @`     @h     @p     @x     @|@@     @     @     @     @     @     @     @     @     @ݙ@     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @U@`@h     @p     @x     @     @     @     @fffff@     @     @     @33333@ə@     @     @     @     @     @     @ @     @@      @(     @0     @8     @@     @H     @P     @U@jfffff@p     @x     @@@@     @     @     @     @     @@     @     @ٙ@     @     @     @     @      @     @     @     @      @'33333@8@@     @H     @P     @X     @`     @h     @m@@     @     @     @     @     @     @     @ə@     @     @     @     @     @     @      @@      @(     @0     @8     @@     @H     @Nfffff@\     @`     @h     @p     @x     @     @     @@@     @     @     @     @     @     @     @     @@陙@     @fffff@      @     @     @     @      @(     @,     @A@H     @P     @X     @\@h@p     @x     @     @     @     @     @     @     @33333@@     @     @     @     @     @     @	@     @     @      @(     @0     @8     @@     @H     @P     @U@i@p     @x     @     @     @     @     @33333@33333@     @     @     @     @     @     @     @     @     @33333@	@     @     @      @(     @0     @8     @@     @H     @P     @U@`@h     @p     @x     @     @33333@     @     @     @     @     @     @     @     @@     @     @     @     @      @	33333@     @     @     @@     @      @$     @(     @,     @/@8@<     @@     @D     @H     @L     @P     @T     @X@\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @fffff@@     @@@     @     @     @     @     @     @     @@@     @     @     @     @     @     @     @     @@陙@     @     @     @     @     @     @     @     @     @     @     @     @     @      @$     @&fffff@-33333@0     @4     @8     @<     @@     @D     @F     @Pfffff@T     @X     @\     @`     @d     @h     @l     @o@xfffff@|     @     @     @     @     @     @     @     @@@     @     @     @     @     @     @@@     @     @fffff@fffff@ᙙ@     @     @     @fffff@fffff@33333@     @      @     @     @     @@@     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @F@P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @w33333@@     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @fffff@@     @     @     @     @     @     @     @     @@     @     @     @     @      @     @     @     @     @33333@     @     @      @$     @(fffff@+@0     @4     @8     @<     @@     @C33333@I@Lfffff@P     @T     @X     @\     @`     @d     @g@n     @p     @t     @xfffff@}@     @     @     @     @fffff@fffff@     @     @     @     @     @@     @     @     @     @     @     @     @     @     @ә@ݙ@     @     @     @     @     @@      @     @     @     @33333@@     @      @$     @(     @,     @/33333@4@8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @bfffff@h     @l     @pfffff@s@x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@33333@     @     @     @     @     @     @     @fffff@fffff@     @     @      @     @     @@     @     @     @      @$     @(@,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @d     @h     @l     @p     @t     @x     @|     @     @@@     @     @     @     @     @     @@33333@     @     @     @     @Ǚ@33333@     @     @     @     @     @33333@     @     @     @     @      @     @	@     @     @     @     @     @      @"fffff@)33333@,     @0     @4     @8     @:@H@L     @P     @T     @X     @\     @`     @d     @h     @j     @p@t     @x     @|     @     @     @@fffff@     @     @     @     @     @fffff@     @     @     @     @     @33333@@     @     @     @     @     @33333@     @@     @     @     @     @fffff@     @@     @     @     @     @     @     @     @ fffff@$     @(     @,     @0     @4     @733333@@     @D     @H     @L     @P     @T     @X     @\fffff@^     @h@l     @p     @t     @x     @zfffff@@     @     @     @     @33333@@@     @     @     @     @33333@@@     @     @     @     @     @     @     @fffff@     @     @     @fffff@     @     @     @     @     @     @33333@     @ fffff@$     @(     @,     @0     @4     @6@@     @D     @H     @L     @P     @T     @X     @\     @_@e33333@h     @l     @p     @t     @x     @|     @     @     @     @     @33333@     @     @     @     @@@fffff@33333@     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @33333@@      @     @     @fffff@     @@     @     @      @$     @)33333@,     @0     @4     @8     @;33333@A33333@D     @Ffffff@Lfffff@P     @T     @X     @\     @`     @d     @f@lfffff@q33333@t     @x     @|     @     @     @33333@@     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @     @33333@@     @     @33333@     @     @     @      @     @@33333@     @     @     @      @"fffff@-33333@0     @4     @8     @;33333@@fffff@C@I@L     @P     @T     @X     @\     @`     @d     @f     @m@p     @t     @x     @|     @~@@     @     @fffff@     @     @     @33333@     @     @     @@fffff@     @fffff@@     @     @     @י@@     @     @     @     @33333@@      @     @
@     @     @     @fffff@     @(     @,     @0     @4     @@@D     @H     @J@Y33333@\     @`     @b@hfffff@l     @pfffff@x     @|     @     @     @     @     @@33333@     @     @     @     @     @fffff@     @     @     @     @     @fffff@љ@     @     @     @     @     @fffff@홙@     @     @     @     @@     @@     @     @     @33333@     @      @$     @(     @,     @/33333@8     @<     @@     @D     @H     @L     @N     @U33333@X     @\     @^@h@l     @p     @rfffff@y@|     @     @     @     @     @     @fffff@33333@     @     @     @     @@@     @     @     @33333@     @     @     @     @33333@fffff@     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0@4     @8     @<     @@     @B@L     @P     @T     @X     @\     @_@l@p     @t     @xfffff@z     @33333@     @     @     @     @@@33333@     @     @     @     @     @     @@33333@     @     @     @     @     @     @     @     @@     @     @     @33333@33333@@     @     @     @fffff@     @!33333@$     @(     @,     @0     @4     @8     @<     @?33333@L@P     @T     @Xfffff@Z@e@h     @l     @p     @t     @v     @}@     @     @     @     @     @@     @@     @     @     @     @fffff@     @     @     @     @Ù@33333@     @     @     @     @fffff@     @     @     @33333@     @     @fffff@ @     @     @     @     @     @     @@      @$     @(     @,     @0     @4     @8     @:@Dfffff@H     @L     @P     @T     @Xfffff@Zfffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 @Fs@-@-@ݗ+@K]d@@@p:@@@p:~@!R<@T@@hr @H@@p:~@+@
M;@!R<@!R<@(@qu"@p:~@M:@@@@_@@@!R<@%@@(@_o @Vu@Vu@Mj@Mj@;dZ@R@4J@_p@n@4J@@E@af@Ov_@L_@fA@sh@@@@O
M@E@$/@@vȴ@6@ߤ@@"`B@Ft@iB@ěT@C,@?@IQ@@fB@a@@I^@1&y@%F
L@š@Ov_@,<@u@쿱[W@/w@$@䎊qj@C-@4SMj@DJM@C,z@H1&x@xl"h	@҈@U=@>B[@5Xy>@4m@!@N@p:@ȴ9X@>B[@zxl"h@e@[@m@@Õ$@'RT@c	@o@H@lzxl"@TE@9	k~@]ce@?@u!S@Ov`@d7@/V@S&@-
@_o@K]c@C]@JE@o i@eu@M:@:@*Ov`@@S@4֡b@C,z@߾vȴ9@o i@5?|@NU@t9XbN@n1@e`A7L@],=@^Ov_خ@\>@ZY@TZ@4j~@ݘ@1&x@?|h@Z@ʦL/{@o hی@($x@e@&@T@yD@h>BZc@Y|@S&@O@-U=@"}Vm@a@O@eO@73@g	@?@p:@YJ@-
@q@@s@ԕ*@$tS@x4֡b@Yb}@H˒:*@:>B@/@vȴ9@+j@$tT@s@-@ce@)^@@O
M@RT`e@@@Z@sPH@-V@0
)@-
q@4m9@p
(@h@KƧ@F&I@.}Vl@Ov_خ@sPH@
M:@n.@z@?@o@
=p@@I^5@Z@Ov_خ@@~6z@ilD@JqiC@9Y}@iB@$@@q@@~($@33333@8Y@>BZc@C,zx@y@G{@;dZ@+J@;dZ@@{lC@p
=q@l>B[@h$xG@a'R@RS&@A$/@4J@.H@(@#wk@حV@6@*0@
M:@u%F
@JL@>BZc@x@F
L0@e+@ڹY@@tj@p
=@Q@g@ hۋ@ڹ@-
@1'@{@	 @o hی@iDg8~@^@XbM@RS&@B&IR@-\@&1.@(\@1'@|@b}@@ݗ+k@n@-
q@cA \@?@ᰉ'@^@>BZc@'@u@ڟvȴ@PH@PH@
=p@Ʌoi@n@]cf@s@?|h@A [@1&y@rGE@S@
qu@W>6z@Ϫ͟@p:@R@4J@@s@|Z@yXbM@w3@vC-@t3@rW@oiDg8@mB@c
=p@Y0
)@Rm@P)^@Mqu"@EoiDg@Dtj@As@@hۋq@=ڹZ@84֡b@7+@7kP@6Fs@1l@+P{@)rGE@&,<@#S@!e@ [6@ ѷY@$@*0@'/W@)^	@	7KƧ@8YK@@&IR@YJ@SMj@-V@D@>B[@0
@^@,@`A@޸Q@6@t@E@ө*0U2@
M;@/{J#@#9@ǮzH@m\@Õ$@&IR@:S@m\@#x@/V@~($@}H@Y|@{@B@<쿱@U=@*0U2a@lC@S@
=p@	k@,=@S@S@,<@_F@bM@L_@nO@v_ح@xF]@Q@p:@E84@a@N@,zxl@I^5@6@~BZc @|#x@|Q@{A@|Q@yrGE8@p@hۋq
@f@ezxl"h@d%1@cZ@c	@`d8@^u@Y|@X*0@V@T*1@OrGE9@MM:@J=p
@HeO@E8YK@DJM@Dg8}@C{J#9@A [7@?.H@>ߤ?@>6z@?.H@>m\@>\N<@=ڹZ@<Q@9=b@64K@2m\@0 ě@,1&y@+P{@)@&'@$7@#wk@!.H@!'R@!|Q@!R<6@!Gz@?@+j@ߤ@@=K^@kP|@_o@b}@@@Ov_@4J@T@
D@+I@@$tS@J#9@	k~@kP@#@
=q@Z@|Q@|Q@Ϫ͞@т@䎊@;5X@@ǮzH@74@KƧ@Vϫ@1&y@\)@o@Q@@@zG@'/W@	 @o h@n.@|PH@y"`@x73@u!.@tD@pD@j~"@f,<@[6@ZQ_@Xe+@VϪ͟@SZ@P|@MjOv@A@>ߤ?@;dZ@9~($@5?|h@.H@+jf@(Xy=@"h	ԕ@U=@wkP@u%F@n@!R<@q@@Vl!@fA@M@ ѷY@2a|@_p@
M;@/{J#@)^	@C@rG@C-@a|Q@zG@^@-V@PH@R<6@ᰉ@sP@$tT@O;dZ@eO@o h@˒:)@}!.H@{m]@zC\@x-
@tSMj@o-V@k~($@hr Ĝ@d%1@c	@be+@b@4@b@4@be+@aGz@`
qu@]/w@Xe+@XD*@Rm@=K]@74m@3ߤ@*d7@#n.3@쿱[W@wkP@6C@_F@@@O
M@nO@ߤ?@F]c@
!.I@
!-w@
A@
%1@
Gz@
;dZ@
cA @
څݘ@
D*@
N;5@
ɺ^5?}@
L/@
7Kƨ@
E@
-V@
 ě@
<쿱@
0U2a|@
TɅ@
1@
Ov_خ@
u@
ݗ+@
:S@
}!.H@
weں@
v_ح@
lC@
jJL@
iDg8~@
gfA@
de@
`d8@
^҈p;@
XU@
UfA@
Sa@O@
R<64@
QX@
P|@
L@
JD@
F
L/@
C$@
A [7@
ATɅo@
ATɅo@
?[W>@
2m\@
-B@
%S@
 [6@
_F@
C%@
$/@
 ѷ@b}V@Vl!@s@!.I@ hۋ@C,z@S@e@e+@ᰉ'R@ᰉ'R@cA @>6z@N;5@t@|@͞%@̘_@)^	@W'@@E84@\N@<64@
(@zxl"@RT`e@S&@-
@Q@*0@tj~@rGE9@k~(@K]d@%2@tj@@:S@y(@u!R@qu!S@lVϪ@glC@a@N@\(\@W
=p@QN;5@Np:~@J#9@:)_@2-V@12W@.1@-V@,1&y@'-@%S@#S&@ [6@!-w1@n@qi@xF]@	k~(@nP@rGE8@:~ @C\@C@@C,@>@Ϫ͟@ʌL_@&IR@dZ@KƧ@9XbN@y@S&@-
@C,zx@tj~@7KƧ@IQ@˒:)@v_ح@qiB@qiB@o@jOv`@f1.@cA [@b@4@Z1'@WsPH@Q@L@JD@D*0@B@=p
=@9Y}@73@0'RT@+U=@*͞&@*0
@*d7@)lD@)y@)y@&@!ae@U=@O;d@n@Mj@
M:@
qu"@
	 @	'RTa@K]d@n/@
˒:)@
_ح@
-V@
g	@
A [@
ⶮ}Vm@
@N@
҈p;@
b}@
y=c@
D*@
@
֡af@
ԕ*1@
а{@
cA \@
)^	@
ʌL_@
@@
o i@
BZc @
dZ@
)_@
D@
}H@
}Vl@
U=@
F
L0@
n.3@
.H@
-w1@
-
@
!-w1@
}H@
vȴ@
@@
R<6@
sh@
$/@
tj~@
҉@
Mj@
xF]@
k~(@
K]d@
ݗ@
I^5@
{~$@
tj~@
ql@
m(@
_حV@
P*0U@
C,zxl@
=K]@
73@
2ᰊ@
-U=@
+6z@
#S&@
U=@
vȴ@
O
M@
o @
~($x@
JM@	.H@	J#9@	Y|@	GE85@	:~ @	(@	fA@	Gz@	>@	䎊@	:@	˒:)z@	ʌL_@	˒:*@	g8}@	n@	6@	 [7@	E@	1&y@	!-w1@	e+a@	sh@	hr @	o @	'RTa@	ѷX@	}!.H@	zG{@	x73@	v+jg@	r䎊q@	q@	o-V@	o-V@	l!-w@	kC]@	b@4@	_;dZ@	^҈p;@	]cA @	Vt@	Rp:@	Rp:@	R<64@	M5Xy>@	K)^	@	H˒:*@	F-@	E8YK@	ATɅo@	9~($@	6E@	2m\@	+jf@	&@	"3@	 	k@	 'RT`@	U=@	U=@	=K^@	҉@	
(@	u%F@	{J#9@	I^5@!-w@e+@ݗ+j@D*@p:~@̘_@)^	@n@@8YK@,zxl@g	l@'RT`@vȴ@u%F@ߤ@@Xe,@@#@ݗ@JM@YJ@oiDg@?@{J#9@ѷX@z>B@u\(@ql@m8Y@iB@e+a@bC,@`d8@[6@YJE@VϪ͟@Xy=c@W&@W@TE@NT@KƧ@Jn@IQ@Gy@GzH@A [7@64K@(@@@N@n@qi@
O;dZ@C%@K]d@{J#9@@$/@$tS@($x@C\@(@+a@d8@;dZ@/w@$@+@t@,<@_p@͞%@D@y@g8}@a@N@Zc@[W>@D@C-@4K@J@
(@{@w1@L/{J@.H@%@1&@S@$tS@N;6@u@u@S&@)^@@!R<@O;dZ@qu"@qu"@C%@	 @$/@{lC@o-V@l[W?@lC@kQ@ffffff@_Ft@[q@["`B@Y|@W&@T*1@O͞@L/{J#@I^5?}@Gy@E@@NU@9D@64K@2a|Q@0
(@/Vϫ@.H@-U=@-w1@-
qv@($xG@#9@!-w1@u@1&@0
)@n@-
q@#@K]d@+I@YJ@$/@n/@@ 4m9@-
@%F
L@@\@\@P{@r Ĝ@>@&@N;5@@@@@C@p
=@~@4֡b@rG@U2a|@zG@w1@>B[@U=@0U2a|@S@/@?@9@S&@-
@Ov_خ@O
M@S&@N;6@hr @@xF]@1&x@n/@o h@{~$@pD@jJL@e@cA [@c	@ae@_حV@[$@V8YJ@S@QN;5@P*0U@M:@K]cA@JW'@H9Xb@D2W@C,zxl@As@:)_@2-V@+a@@*0U2a|@&x@$xF@!-w1@!ae@PH@$/@o @
ڹY@1&x@_o@@$/@H˒@Vl!@?@#x@lC@s@SMj@iDg8@\@ⶮ}Vm@>@D*@>6z@`A7@
M;@@D@@@n@ɅoiD@@@@@ȴ9Xb@W'@)^@8YK@64@
(@͞&@$xG@!-w1@,=@C,zx@u%@vȴ@vȴ@@n@Mj@'/@'RTa@ݗ+@YJ@%2@o hی@}Vl!@{s@y(@vȴ9X@qA [@jOv`@ix@g8}H@be+@^ ѷY@^5?|@W
=p@M5Xy>@K)^	@HK]c@G)^@E@C\N@@6@=<64@:)_@4m8@1-@1[W>6@1&x@/r@.2X@)*0U2a@'-@"`A@C,zx@@@@+J@-
q@Vu@
O;dZ@
=p
@eO@1&x@ݗ@@@@4n@b}V@"@m\@m\@!.H@lC@G{@@ȴ9X@!.@!.I@\(@䎊q@oiDg8@4֡a@Dg8~@fffff@҈p@W>6z@y=c@
=p@ԕ*1@;dZ@m\@BZc @3@Xy=@m\@W@ᰊ@o@'RT@'RT@U2a|@-@O
M@
qv@a@@/V@R<6@1&@tj@_F@u%@@:)y@u@@~($x@I^5?@_o@hۋq@|hr@|PH@|?@}!.H@vȴ9X@nt@l!-w@l"h	ԕ@lC@l!-w@jJL@h>BZc@eO
@^҈p;@Vl!-@PH@L/{J#@F
L/@F
L/@Em\@Eo i@E84֡@D*0@B74@@NU@?@9Y}@-w1@*͞&@'&@&@$tSM@#wk@#n.3@u%@_F@$tS@tj~@
qu"@
=p
@K]d@&I@JM@@$/@Vl!@~$@+jg@@GE85@A [@C\@@>@b}@D*@@l!-@&@@*0@š@s@[W>@/V@sg@33333@w1@q@1&y@6z@RT`e@`A@.H@쿱[W@@\(@7KƧ@eO@+I@?@@%2@{J#9@ ѷ@hۋq@|Q@yrGE8@vȴ9X@tj~@s@qu!S@o4֡a@o4֡a@nt@nc	@mhr!@l[W?@jOv`@cA [@`
qu@_حV@]+j@Xy=c@U=K@SZ@R<64@QX@Q_p@O͞@O
M;@OAs@M%@H@F]cf@Fs@D*0@BZc@@C@?@<쿱[@<쿱[@:)_@9Y}@9#w@8Q@8Q@74m@6E@4J@1o@/r@/v@.zG@,>B[@,1&y@,q@+U=@*͞&@(Xy=@&@$tSM@!-w1@ߤ@@PH@+J@ݗ+k@hr @~($x@q@xF]@
=p
@	7KƧ@K]d@@F]c@ IQ@rGE8@_ح@D@oiDg8@B@@7@ⶮ}Vm@d8@5?|@]ce@T`d@cA \@v@#w@sg@|@&x@0
@@*0U2a@IQ@?@.H@	k@,=@u%@_o@@)^@~($x@eO@ݗ+@YJ@u%F
@b}V@}Vl!@|?@|Q@{~$@{J#9@{J#9@{J#9@z@yrGE8@xl"h	@r{m@o-V@mC\@hۋq
@f,<@de@ceO@]ce@]+j@Xe+@V8YJ@R<64@N_o @K:)z@K]cA@H˒:*@H˒:*@Gy@F?@E@BZc@?[W>@=<64@:)_@:S&@9~($@:^5?|@9XbM@74m@1o@-V@+a@@'RT`e@%F
L0@#
=p@#S&@"`A@"h	ԕ@"3@!.H@!-w1@vȴ9@1&@,<@kP|@0
)@@ᰉ@sh@+J@*0@Z@zG@Z@zG@rGE9@qi@
@
O;dZ@	7KƧ@K]d@u%F@ݗ@JM@M:@%2@@nP@ ѷX@#x@m]@s@F]d@Fs@!-w2@u!S@@c	@Ov`@	ԕ+@fffff@%1@@N@ ѷY@ۋq@t@@jOv@W'@W'@ɺ^5?}@ɅoiD@6@)y@C-@֡a@-V@[W>6@1@v@q@U=@0
@^@'@tSM@[6@1&@=K^@+j@ݗ+k@S&@sP@hr @\(@M:@q@=p
@eO@~m\@}!.H@|PH@{~$@xF@x73@wkP@vFs@vȴ9X@v_ح@u!.@u!R@u\(@t#@sE@r ě@p:~ @oiDg8@nt@nO;@mC\@lC@kC,z@j~"@g	k@fA@b}Vm@_?@\N;@Yb}@Vt@RT`d@P*0U@OAs@N+@Ks@IoiD@H@Fs@Eo i@C$@A [7@@4m@@n@@n@?[W>@?@>6z@=v@=K]@=K]@<n.@:S&@9#w@7Xe@3|@2m\@.1@.H@.H@,zxl"@*0
@#n.3@!.H@IQ@PH@N;6@
M:@
=p
@	k~(@	 ѷ@u%F@	7KƧ@1&x@ݗ@M:@u%F
@ PH@ J#9@ C\@ "`@ rGE8@ "`@ rGE8@ -
@ F]d@ _ح@ D@ E@ GE85@ @ c	@ fB@ x@ B@ Q@ JL@ B@ B@ rGE@ @ >BZc@ C@ fB@ rGE@ r Ĝ@ A [@ ⶮ}Vm@ حV@ ߤ?@ Ft@ /w@ ܑN;@ $@ 1'@ >BZ@ +@ حU@ fA@ ҈p:@ *0U@ ;5X@ 5Xy>@ :@ cA \@ W'@ ɅoiD@ E84@ 4m@ /V@ Y}@ rG@ ?@ '0@ 33333@ {@ v@ 2X@ B@ d7@ S@ .H@ 	k@ U=@ Ov_خ@ IQ@ qu!@ O;d@ *0@ L_@ sh@ L_@ @N@ u@ 4J@ 4J@ '/W@ ~($x@ #@ &I@ n/@ I^5@ hۋq@ }E@ }Vl!@ |?@ z@ v_ح@ sg@ ql@ l[W?@ ix@ hr Ĝ@ g@ fA@ cA [@ be+@ _?@ ^ ѷY@ ]ce@ \?@ [6@ Z1'@ W>6z@ V8YJ@ TE@ Rp:@ P`A7@ LcA \@ H@ H9Xb@ H˒:*@ G@@ GE84@ Eo i@ A [7@ >
(@ =p
=@ =<64@ =v@ =K]@ ;5Xy@ :^5?|@ 6}Vl@ 5?@ 3g	l@ 0 ě@ /{J#:@ .2X@ -w1@ +U=@ +6z@ +jf@ *0
@ )@ (\)@ ($xG@ &'@ $/@ &L/{J@ %F
L0@ #
=p@ "3@  ěT@  -
@ !ae@ vȴ9@ Ov_خ@ 1&@ Q@ qu!@ _F@ zG@ ҉@ S&@ :)y@ 4J@ \(@ 
qu"@ @ u%F@ n/@ M:@ {J#9@ u%F
@ @  hۋq@       ?.H?E?~$?rGE8?!.I?s?C\?fA?1.?ᰉ'R?ߤ????]ce?$?ۋq?Q_?>BZ?
=p?*0U?5Xy>?s?ȴ9Xb?y?@?74?/V?3?}Vl?zxl"h?-
?-V?S                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 @@g[W>@@g[W>@@g[W>@@g&@@g?@@gzH@@g&@@gkP@@gݗ+@@gO;d@@gݗ+@@gݗ+@@g@@g|hs@@g&@@g$tS@@g?@@g	k@@g-V@@g/V@@gvȴ9@@g@@g+@@h     @@g+j@@g+j@@grGE9@@g#@@g#@@h@@h@@h@@h@@h@@h@@h	ԕ+@@h@@h@@hbM@@h	ԕ+@@hF]d@@h     @@h@@h
qu@@hbM@@h
qu@@h	ԕ+@@h*0U@@h}H@@h ě@@h ě@@h ě@@h ě@@h ě@@h ě@@h ě@@h@@h@@h*0U@@h ě@@h-
q@@h4m9@@hA7K@@h>BZc@@hK]c@@hA7K@@h_F@@h˒:*@@h@@hU@@hۋq
@@h҈p@@h4֡b@@hp:@@h`A7@@i+@@i@@j@4n@@jxl"h
@@kI^@@kqu!@@kW>6z@@keO@@l?@@oXe,@@uڹ@@x@@Ϫ͟@@TɆ@@O;dZ@@Xy=@@R@@VϪ@@F]d@@ݗ@@fA@@>BZ@@wkP@@8}H@@_F@@e+a@@ҜwkQ@@zG@@p
=@@ֻ@@oiDg8@@hۋq@@ٜu@@ڕᰊ@@Fs@@݁$/@@ޚ,<@@D*@@B@@nP@@:)z@@eO@@a@O@@xF@@64@@O
M@@hr!@@H@@m\@@$tS@@*0@@bM@@-
@@艠'RT@@|@@y=c@@d8@@u%F@@-
@@l"h	@@u%F@@@@@҈p@@C@@$/@@_p@@	k~@@@@:S@@Dg8~@@e+a@@@@b}@@R<6@@oiD@@Dg8~@@JE@@邩@@oiD@@n.@@I^5@@-@@>BZ@@ԕ*@@ᰉ'@@lD@@d7@@ᰊ@@0
@@@4@@kP|@@Q_@@xl"h
@@ ѷ@@꩓@@3@@Q_@@~@@C,z@@C%@@W>6z@@S@@믷@@E@@|@@ݗ+k@@Q@@A [@@\N@@@@n.@@ݗ+k@@@@n.@@\N@@ߤ@@@s@@s@@C,zx@@쿱[W?@@u"@@D@@K]@@o i@@e@@Q@@!.H@@F
L0@@\@@jOv@@ce@@fA@@m\@@hr!@@hr!@@@@힃%@@=K@@U=@@=K@@w1@@\@@O;dZ@@$/@@퇓ݗ@@@@픯O
@@v@@@@1@@@@Ϫ͞@@Ϫ͞@@
qv@@
L/@@1.@@iB@@ߤ?@@Mj@@@@@@
M;@@+I@@'/W@@E84@@v_ح@@/V@@vȴ9@@@@rGE9@@@@bM@@6@@$xG@@*0@@D*@@˒:*@@9Xb@@TɅ@@@@@)^@@D@@{@@_p@@+@@:S@@Dg8~@@Q@@e+a@@oiD@@@@񰉠'R@@D@@X@@ԕ*@@0U2a|@@a|Q@@Zc@@a|Q@@{m@@ ѷ@@	@@&@@/V@@33333@@9@@=K^@@@N@@J#9@@]cA@@dZ@@ߤ@@a@@@lC@@,<@@M:@@#@@@@#x@@j~@@@@>B[@@@@(@@?|h@@M:@@+j@@-V@@H˒@@Ϫ͞@@E@@4K@@1.@@YJ@@YJ@@c	@@O;@@@@)^@@1@@;dZ@@As@@O
M@@eں@@	@@-V@@䎊r@@hۋq@@u%F@@@@@@@ ѷ@@@N@@#w@@-w1@@=b@@rGE8@@u!S@@b}@@~($@@2W@@e@@-@@s@@:)y@@C\@@T`d@@h	ԕ@@qiC@@ ě@@fB@@u%@@C,z@@C%@@P{@@dZ@@Ƨ@@C]@@@@(\@@M:@@cA \@@~($x@@3@@@@qu"@@5Xy>@@`A7L@@jOv@@hr!@@8Y@@8YK@@ᰉ@@C\@@u@@($x@@5?|@@Ov_خ@@%@@af@@Q@@ȴ9X@@ߤ?@@'/W@@|hs@@͞@@K]d@@;dZ@A 
qu@A 1&x@A NU@A _F@A _F@A tj@A @@A )^@A D@A	k~@A_p@A7KƧ@Ahr @Al@A"`@A	 @A1'@AQ_@A~"@A@4@A0
@AY@AfB@A)^	@A33333@A6z@A/V@AMjO@AQ@Aq@Aq@A$@A$@Aߤ@AU=@A*0U2@AƧ@As@AL_@A(\@AFs@A#@ATɆ@AD@A'0@A+a@A?|h@AIQ@AS&@Aw1@AڹZ@A!R@Ahr!@AڹZ@A=K@AU=@AH˒@A8YK@A ѷY@A!R<@AOv_خ@Aqi@A&I@AA@Ax@AFt@A$tS@A1@AO
M@Aeں@AsPH@AsPH@A&@A@A@A+j@A	ԕ+@A@A*0U@A@A4m9@Ahۋq@A4m@Ae+@A	#w@A	JE@A	b}@A	@A	D@A	@A	"`@A	ᰉ'@A
u%F@A
T`d@A
W'@A
Q_@A
@A
`A@A
,<@A
c	@Au%@AI^@A)^	@Aߤ@AZ@AQ@AC]@AL_@A/{J#@APH@Ag8}@AC@A@A֡a@AD@A
*0@A
%F
L@A
5Xy>@A
IQ@A
O;dZ@A
jOv@A
!R@A
n/@Au@A($x@A.2@A1.@AE@AYJ@A}Vl@A@A@A.H@A8}H@AKƧ@A4m@Aݗ+@A͞@A+@AVϫ@AF]d@AbM@AK]c@AeO@AoiDg8@A@A@@Aae@AoiD@A(@Ae@An@A@A#9@A0U2a|@AqiC@A0
@AwkQ@A}Vm@A͞&@A҉@AdZ@A@Aq@AQ@Awk@AS@AZ@A
=p@AA [@AxF@AQ@A%1@A(\@A/{J#@AFs@AcA \@A~($x@Aqj@Azxl"@A1&@A#x@A#x@A#x@A7@AɅoi@A@A>B[@AJM@AD@A'0@Azxl"h@Ahr!@A@AH˒@Aᰉ@AoiDg@A ѷY@A
L/@A
(@A
(@A@A$/@A$/@A1.@A;5X@A;5X@A?@AE@AH@AVu@A\N<@A_ح@Ap:~@Avȴ9X@Aqi@AQ@At@A1@A!-w1@A;dZ@AKƧ@AlC@A4m@A$tS@A	k@AK]d@ArGE9@A6@A73@AXy=@An@Au%F@A@@AF@AF@A҈p@Ae+@A4֡b@A	k~@A4J@AJE@ATɅo@A^@Ahr @ArGE8@A7Kƨ@AR<6@AX@Ao@A"`@AiB@AiB@A>BZ@A&IR@A@4n@Ah	ԕ@AS&@A䎊q@A&@A9@AF]c@AMjO@AW>6z@Aa@N@Aqu!@Awk@A~($@AC]@A@As@AJ@A\N@Aߤ@@A%1@AM:@AC,zx@AZ1@Am8@A~($x@A?@Aqj@A쿱[@Azxl"@A7@AE@AF
L0@AS&@Ace@Azxl"h@Ahr!@A=K@A1@AXy=@AH˒@A?@A
qv@AC\@AE@AoiDg@Aڹ@A_o @A
(@AzG@A+jg@AE@Afffff@A}Vl@A+J@A@Aaf@A'@AFs@Av@A!-w1@A4֡a@A>6z@AKƧ@Ab}V@Ao@Ay@A	@Aݗ+@Ar@AK]d@A@A@A+j@A *0U@A 4m9@A :~ @A >BZc@A [6@A r Ĝ@A -
@A 
=q@A ѷX@A! ѷ@A!+@A! [7@A!*0U2a@A!A [@A!^@A!ae@A!k~(@A!oiD@A!|@A!"`@A!@A"n@A"s@A"@A"e+@A"&IR@A"-V@A"6C@A":)y@A"^5?|@A"nO@A"\(@A"L/{@A">B@A"<64@A"@A"͞&@A" ѷ@A"C,@A#nP@A#)^	@A#)^	@A#,zxl@A#,zxl@A#/V@A#33333@A#6z@A#9@A#J#9@A#S@A#qu!@A#eO@A#:)z@A#:)z@A#wk@A#S@A#S@A#@A#~($@A#|@A#$@A$xF@A$!-w2@A$Fs@A$?@A$I^5?@A$PH@A$cA \@A$g8}@A$j~#@A$q@A$tSM@A$~($x@A$C@A$*1@A$S@A$TɆ@A$O
M@A$?@A$Z@A$֡a@A$>B[@A$/@A$Z@A$JM@A%(@A%/w@A%2a|@A%84֡@A%B@A%<64@A%F
L0@A%O;dZ@A%\@A%ce@A%m\@A%sg@A%m\@A%}H@A%w1@A%ڹZ@A%+j@A%%@A%U=@A%U=@A%@A%Ϫ͞@A%oiDg@A& ѷY@A&
(@A&H@A&@A&&I@A&҈p;@A&ߤ?@A&쿱[W@A&"@A'@A'+I@A';dZ@A'U=@A'o@A'y@A'&@A'	k@A'[W>@A'fA@A'@@A'Vϫ@A'䎊r@A'#@A(bM@A($xG@A(-
q@A(_F@A(u!@A(u!@A(y=c@A(n@A(-
@A(u%F@A(IQ@A(u%F@A(@@A(e+@A)rGE@A)&x@A)0
)@A)=b@A)A [@A)ae@A)|Q@A)7Kƨ@A)~($@A)u@A)'RTa@A)'R@A)'R@A)|@A)^5?}@A)ԕ*@A)e@A)e@A)@A)s@A)Y}@A*@A*1'@A*e+@A*)y@A*3@A*6C@A*C\@A*GE85@A*Q_@A*^5?|@A*{m@A*ݘ@A*S&@A* ě@A*@A*W@A*`A@A*,<@A*ڹY@A*G{@A*C,@A+҉@A+s@A+&@A+/V@A+,zxl@A+Q@A+wk@A+m]@A+@A+C]@A+$@A+\N@A+s@A+\N@A,1&y@A,@A,SMj@A,N;@A,_@A,N;@A,#@A,3@A,?@A,֡a@A,Z@A,/@A,/@A,/@A,u"@A,u"@A,D@A-o i@A-[@A-Q@A-/w@A-B@A-L_@A-S&@A-Vl!@A-m\@A-m\@A-zxl"h@A-w1@A-w1@A-zxl"h@A-M:@A-hr!@A-@A-v@A-v@A-U=@A-U=@A-\(@A-,=@A.zG@A.E@A.Vu@A.Ov_خ@A._ح@A._ح@A.vȴ9X@A.z@A.@A.@A.$t@A.Fs@A.O;@A.6z@A.҈p;@A.쿱[W@A.!.I@A.!.I@A/@A/)^@A/@A/,@A/'/W@A/8}H@A/;dZ@A/As@A/KƧ@A/Xe,@A/_o@A/_o@A/iDg8@A/4m@A/4m@A/&@A/O;d@A/$tS@A/$tS@A/	k@A/[W>@A/@A/+@A/fA@A/fA@A/Vϫ@A0	ԕ+@A0@A0F]d@A/#@A0@A0bM@A0*0U@A0*0U@A0@A06@A0}H@A0$xG@A0-
q@A0K]c@A0y=c@A0YJ@A0'RT@A0@A0@A04m@A0@@A0@@A0D@A0҈p@A0@A0	k@A0PH@A1 ѷ@A1@N@A1_p@A1-w1@A1Gz@A1N;5@A1[W>6@A1e+a@A1hr @A1hr @A1o hی@A1o hی@A1|Q@A1@A1@A1'RTa@A1n.@A1(@A1l@A1o@A1ԕ*@A1s@A1s@A1Y}@A1s@A1@A1lD@A2u%F@A2	 @A26C@A2=p
@A2JL@A2T`d@A2M@A2T`d@A2xl"h
@A2p:@A2L/{@A2@A2@A2)_@A2 ѷ@A2G{@A2fB@A2c	@A2~@A3I^@A3	@A3"`B@A3&@A3"`B@A3)^	@A3)^	@A3=K^@A3C%@A3@N@A3F]c@A3J#9@A3J#9@A3S@A3qu!@A3~$@A3~$@A3@A3Q@A3Mj@A3wk@A3*0U2@A3*0U2@A3a@O@A3%2@A3s@A4xF@A4ߤ@@A4@A4@A4tj@A4,<@A4C,zx@A4C,zx@A4PH@A4PH@A4]ce@A4`d@A4cA \@A4j~#@A4~($x@A4o h@A4?@A43@A4[W?@A4Z@A4Z@A4/@A4Z@A4JM@A4u"@A5K]@A5[@A5!.H@A52a|@A5<64@A5B@A5?|h@A5?|h@A5\@A5`A7L@A5fA@A5fA@A5jOv@A5p
=@A5$/@A5O
@A5U=@A5@A5Ϫ͞@A5
qv@A5S@A5E@A5ڹ@A6_o @A6
L/@A6
(@A64K@A6_o @A64K@A6zG@A6@A6Ov_@A6u@A6zG@A6!R<@A6$/@A6H@A6l!-@A6vȴ9X@A6IQ@A6af@A6af@A66z@A6}Vl@A66z@A6}Vl@A6@A6t@A6+@A6]cf@A6x@A6@A6Mj@A6Fs@A7@A7@A7,@A7$tS@A7.H@A7>6z@A7Xe,@A7Xe,@A7_o@A7sPH@A74m@A7|hs@A7@A73@A7/V@A7@A7K]d@A7˒:)@A7˒:)@A7;dZ@A7rG@A7-@A8 ě@A8*0U@A8@A8*0U@A8@A8}H@A873@A873@A8H@A8[6@A8hۋq@A8l"h	@A8y=c@A8'RT@A8@A8tj@A8u%F@A8u%F@A8@A8@A8{@A8{@A8U@A8)@A8ěT@A8TɅ@A8TɅ@A8@@A8)^@A8p:@A8F@A8`A7@A8ۋq
@A8҈p@A8`A7@A8C@A8{@A8PH@A9	k~@A9@N@A9&x@A97KƧ@A9A [@A9A [@A9JE@A9[W>6@A9|Q@A9o@A9'RTa@A9n.@A9'R@A9'R@A9X@A9X@A9@A9@A9D@A9^5?}@A9D@A9y@A9_o@A9"`@A9R@A9.H@A:I^5@A:@A:n@A:Ov`@A:#9@A:&IR@A:3@A:3@A:6C@A:C\@A:Zc@A:h	ԕ@A:h	ԕ@A:h	ԕ@A:a|Q@A:xl"h
@A:ᰊ@A:0
@A:wkQ@A:wkQ@A:0
@A:S&@A:@A:g	@A:@A:G{@A:c	@A;I^@A;nP@A;nP@A;PH@A;C,z@A;C,z@A;PH@A;	@A;)^	@A;/V@A;P{@A;tj~@A;xF]@A;~$@A;Q@A;eO@A;eO@A;q@A;*0U2@A;@A;m]@A;6@A;a@@A;҈@A;g@A;$@A;$@A;@A;\N@A<xF@A<Q@A<"h	ԕ@A<,<@A<,<@A<2W@A<?@A<M:@A<j~#@A<~($x@A<o h@A<?@A<C@A<*1@A<O
M@A<?@A<[W?@A<*0@A<֡a@A<@A<e@A<E@A=V@A=[@A=*0@A=qu"@A=+a@A=2a|@A=84֡@A=B@A=Vl!@A=}H@A=ڹZ@A=!R@A=O
@A==K@A=%@A=+j@A=%@A=%@A=v@A=@A=H˒@A=cA @A=Ϫ͞@A=8YK@A=8YK@A=S@A=S@A=,=@A=ᰉ@A=(@A=,=@A=E@A>
(@A>zG@A>@A>$/@A>1.@A>;5X@A>E@A>BZc @A>H@A>L/{J@A>R<6@A>R<6@A>R<6@A>YJ@A>fffff@A>l!-@A>p:~@A>vȴ9X@A>z@A>%@A>qi@A>+J@A>$t@A>Fs@A>O;@A>@A>T@A>@A>@A>T@A>2X@A>Q@A>&I@A>m\@A>ȴ9X@A>t@A>Ϫ͟@A>҈p;@A>҈p;@A>Ϫ͟@A>ߤ?@A>C-@A>쿱[W@A>!.I@A?
=p@A?)^@A?Xe@A?v@A?'/W@A?8}H@A?H˒:@A?8}H@A?E84@A?E84@A?KƧ@A?U=@A?_o@A?\(@A?|hs@A?4m@A?&@A?$tS@A?zH@A?r@A?r@A?K]d@A?+@A?حV@A?@A?#@A@ ě@A@A7K@A@H@A@Q@A@U2a|@A@bM@A@˒:*@A@|@A@y=c@A@YJ@A@tj@A@u%F@A@@A@
=q@A@{@A@4m@A@
(@A@ѷX@A@ۋq
@A@	k@A@4֡b@A@{@A@$tT@AA@AA	k~@AArGE@AA_p@AA_p@AA_p@AA_p@AA_p@AA [7@AA#w@AA*0U2a@AA:S@AA=b@AAGz@AA^@AAae@AAe+a@AAu!S@AA@AA7Kƨ@AAo@AAu@AA'RTa@AA'R@AA^5?}@AA2W@AA@AA2W@AAo@AA_o@AAN;6@AA"`@AAiB@AAR@AAs@AAs@AAY}@AA@AAlD@ABu%F@ABs@AB&IR@AB&IR@AB:)y@AB=p
@AB=p
@ABC\@AB@4n@AB=p
@ABGE85@ABM@ABQ_@ABQ_@ABa|Q@AB^5?|@ABa|Q@ABkP|@AB^5?|@ABu%F
@ABu%F
@ABu%F
@AB{m@AB{m@AB~"@AB{m@AB~"@AB\(@AB\(@ABᰊ@ABS&@ABL/{@AB>B@AB>B@ABg	@AB}Vm@AB}Vm@AB}Vm@ABY@AB<64@ABn@AB,<@AB,<@AB,<@ABG{@AB䎊q@ABC,@AB74@ABm\@ACu%@ACnP@ACs@ACC,z@AC"`B@AC,zxl@AC6z@AC=K^@ACS@ACW>6z@ACjf@ACqu!@ACqu!@AC@AC@ACwk@ACm]@ACm]@AC~($@AC5Xy@AC
=p@ACa@@AC|@AC
=p@AClC@AC҈@AClC@AClC@ACs@ADJ@ADߤ@@ADtj@ADQ@AD,<@AD/{J#@AD/{J#@AD2W@AD<쿱@ADFs@ADI^5?@ADM:@ADVϪ@ADwkP@ADzG@ADzG@ADzG@AD?@ADC@ADC@ADN;@ADqj@AD*1@AD*1@AD*1@AD_@ADS@AD쿱[@AD3@AD1&@AD1&@AD@AD@AD1&@AD?@AD7@AD?@AD@ADZ@AD֡a@ADJM@AD!-w@ADe@AEV@AEu@AEqu"@AEqu"@AEQ@AE+a@AE2a|@AE5Xy>@AE<64@AEF
L0@AEIQ@AEL_@AEO;dZ@AEVl!@AEO;dZ@AEVl!@AE\@AEVl!@AE\@AE`A7L@AEce@AEjOv@AEm\@AEm\@AEw1@AE$/@AEڹZ@AE+j@AEO
@AEO
@AE=K@AE%@AE-V@AE\(@AE@AEb@AEoiDg@AE!.@AFt@AF_o @AFzG@AFzG@AF
L/@AF
L/@AFzG@AF@AF!R<@AF1.@AF8YJ@AF;5X@AF?@AF?@AF?@AF?@AFBZc @AFBZc @AFL/{J@AFR<6@AFVu@AFYJ@AFYJ@AFc	@AFiB@AFp:~@AFl!-@AFl!-@AFvȴ9X@AFvȴ9X@AFz@AFvȴ9X@AFz@AFIQ@AFIQ@AFz@AFIQ@AFIQ@AFFs@AFFs@AFaf@AFaf@AF@AF-@AF-@AFT@AF}Vl@AF}Vl@AF}Vl@AF2X@AF&I@AFȴ9X@AFt@AF҈p;@AF҈p;@AFϪ͟@AFϪ͟@AFߤ?@AFߤ?@AFx@AG hۋ@AG@AGv@AG,@AG$tS@AG1@AG+I@AG4֡a@AG;dZ@AG>6z@AG>6z@AGH˒:@AG_o@AGlC@AGeں@AGlC@AGo@AGv_ح@AG{J#:@AG{J#:@AG@AG	@AG@AGݗ+@AGݗ+@AG-V@AG	k@AG-V@AG&@AGzH@AG3@AGo @AGK]d@AG@AGحV@AG@@AGrG@AGVϫ@AG䎊r@AG#@AHF]d@AH
qu@AH6@AH$xG@AH$xG@AH'RT`@AH1&x@AH1&x@AH:~ @AH4m9@AHD*@AHK]c@AHK]c@AHNU@AHQ@AH_F@AHbM@AHeO@AHhۋq@AHoiDg8@AHr Ĝ@AHYJ@AH'RT@AHYJ@AH-
@AH@AH@AH
=q@AHd8@AH{@AHd8@AH@AHU@AH{@AH9Xb@AHěT@AHp:@AH)^@AHۋq
@AHѷX@AHD@AH҈p@AHe+@AH`A7@AH@AHC@AH4֡b@AH{@AH\)@AH\)@AI ѷ@AHPH@AHPH@AH$tT@AI$/@AI@AIrGE@AIrGE@AI@N@AI+@AI_p@AI@AI-w1@AI#w@AI7KƧ@AIA [@AI7KƧ@AI=b@AIDg8~@AIGz@AIQ@AIXbM@AI^@AIe+a@AIk~(@AIrGE8@AIo hی@AIo hی@AIx@AIx@AIb}@AIb}@AI7Kƨ@AIoiD@AIo@AIo@AI@AI(@AIl@AI'R@AI'R@AI^5?}@AI^5?}@AI^5?}@AIX@AI@AI^5?}@AI@AI_o@AIN;6@AIN;6@AIԕ*@AI"`@AI"`@AIe@AIR@AI-@AJu%F@AJI^5@AJOv`@AJOv`@AJ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 @r@r@r@rfffff@r@r@r33333@r@r@rfffff@r33333@r     @r     @r@r@r     @r33333@rfffff@r     @r@rə@r@r33333@rљ@rfffff@rə@r@r@r     @rٙ@r     @r     @r@r     @rٙ@rfffff@r33333@r     @rfffff@rٙ@rٙ@rfffff@r     @rfffff@r33333@rٙ@rfffff@r33333@r     @rљ@r     @rfffff@rfffff@r     @r@r     @r33333@rfffff@r33333@rfffff@r@rfffff@r33333@r@r33333@rfffff@r@rљ@rə@rə@r     @rfffff@r@r33333@r     @rə@r     @r@r33333@r     @r33333@r@r@rvfffff@rl@r#33333@qfffff@p     @p     @n@m陙@mfffff@m@mffffff@l     @kٙ@k#33333@j33333@j@     @i@i33333@j0     @j<@i33333@i@iy@ii@iVfffff@i0     @i	@hfffff@h@h@hffffff@h6fffff@h@h     @h	@h@gfffff@g     @gfffff@g@g@gvfffff@gs33333@gC33333@g&fffff@g@g     @g33333@gfffff@g@g&fffff@g<@gI@g333333@g)@g@g     @g33333@ffffff@f33333@ffffff@ffffff@f@fFfffff@f33333@e33333@e陙@e@e@f33333@e陙@e@es33333@eC33333@e#33333@efffff@e	@d@ds33333@d@     @d@d     @d     @d     @d      @c     @c33333@c     @cfffff@cy@cC33333@c@b@bfffff@b33333@bp     @b9@b#33333@bfffff@b	@bfffff@a@a@b33333@a@a     @a33333@a33333@a@a@a     @aY@a,@`@`@`33333@`     @`33333@`|@`P     @`9@`)@`@`fffff@`	@_@_@_     @_@_fffff@_     @_Y@_@     @_Y@_Ffffff@_      @^ٙ@^33333@^`     @^L@^,@^33333@]33333@]33333@]@]@]s33333@]&fffff@\@\L@\fffff@[fffff@[33333@[33333@[@[y@[ffffff@[S33333@[      @Z@Z33333@Z33333@Zs33333@ZS33333@ZFfffff@ZL@Z,@Z@Z      @Yfffff@Y33333@Y     @Yffffff@Yffffff@YY@YS33333@Y@     @Y@Yfffff@Xfffff@X@X@Xfffff@Xfffff@Xffffff@XS33333@XL@X@Wٙ@Wfffff@Wy@WS33333@W33333@V@V33333@V@Vfffff@V@V33333@V33333@V@V@V     @V     @VL@V      @U@U33333@U@Ufffff@Ufffff@U@Us33333@U`     @US33333@U9@U333333@Ufffff@Ufffff@T33333@Tfffff@T     @T@T     @T33333@Tfffff@Ty@Tffffff@Tl@TY@T,@T33333@T@S@S33333@S@Sfffff@Sfffff@S@S33333@Sffffff@S@     @S@S33333@R33333@Rfffff@R33333@Rfffff@R33333@R     @R@R33333@R@Rs33333@RS33333@R@     @R&fffff@R33333@Rfffff@R      @Rfffff@Q@Qfffff@Q33333@Q@Q@Q`     @QFfffff@Q@     @Q@P     @P33333@P33333@P@Pfffff@P@P33333@Ps33333@P`     @PY@PY@PL@PFfffff@P&fffff@P@O33333@Offfff@O     @O@O     @O@Os33333@O@     @O@O@Nfffff@N     @N@Ns33333@NY@N333333@N@N      @M33333@M     @M@Ms33333@Mffffff@Ms33333@MY@MY@M333333@M@L33333@L@L     @L@L@L@L     @Lffffff@LL@LL@LY@L&fffff@L@L333333@L@K33333@Kffffff@K333333@Jfffff@Jfffff@J     @J@J     @Jffffff@J333333@J&fffff@J@I33333@I@Ifffff@IY@I@     @I@H@H33333@Hٙ@H@Hٙ@Hfffff@Hfffff@Hٙ@Hfffff@H@Hfffff@Hs33333@HL@H333333@H333333@Gfffff@H@Gfffff@Gfffff@G     @G     @Gffffff@G&fffff@G@G@G&fffff@G@G@F33333@F@F33333@F@F@F     @F@FL@F&fffff@F@E33333@E33333@Es33333@Es33333@E33333@Es33333@EL@EL@E@     @E&fffff@E      @E      @E333333@D33333@D@Dٙ@D33333@D@D@Ds33333@D@     @C33333@Cٙ@C33333@Cfffff@Cٙ@D@D333333@D&fffff@D@D@C33333@Cٙ@C33333@C     @Cfffff@C@Cs33333@CY@C      @B     @B     @B@Bfffff@B     @B@B333333@B      @A@A@A     @Aٙ@Afffff@A@As33333@A     @Affffff@As33333@AL@A@     @A333333@A&fffff@A@A      @@fffff@@s33333@@s33333@@@@s33333@@333333@@&fffff@@333333@@&fffff@@@@      @?fffff@@@?@?ffffff@?ffffff@?ffffff@?ffffff@?L@?      @>fffff@?      @>fffff@>@>@>fffff@?      @>33333@>@>     @>     @>     @>33333@>@>333333@>333333@>333333@>L@>333333@>L@>@>333333@>333333@>ffffff@>333333@>      @>333333@=fffff@=@=fffff@=@=33333@=@=33333@=fffff@=fffff@=fffff@=fffff@=fffff@>333333@>@?@>fffff@?@>fffff@>@?      @?@?      @?@>fffff@>ffffff@>ffffff@>ffffff@>333333@>333333@=fffff@>      @=fffff@>@=@=@=@=@=@=ffffff@=333333@=@=@=@=      @=      @<fffff@<@<@<     @<@<@<     @<333333@<     @<333333@<333333@<@<      @<@<      @;fffff@;     @;ffffff@;ffffff@:fffff@:33333@:fffff@:@:@:@:     @:     @:ffffff@:333333@:333333@:@:      @:      @9fffff@:      @:      @:@:@9@9@933333@9@9@9ffffff@9333333@9     @9@8@833333@8     @8ffffff@8L@8ffffff@8L@8L@8L@8L@8     @8ffffff@8L@8333333@8L@8ffffff@833333@8@8@8ffffff@8     @8     @8     @8L@8333333@8      @8@8      @7@7@7@7     @7ffffff@7ffffff@7L@7     @7ffffff@7L@7L@7L@7@7333333@7333333@7L@7ffffff@7      @6fffff@6@6@6@633333@6@6L@6L@6@6@6L@6@6@6     @6L@6333333@6@6ffffff@6ffffff@6ffffff@6L@6L@6      @6@6L@6@6333333@6@5fffff@5     @5@6@6333333@5fffff@533333@5fffff@5@5@5ffffff@5ffffff@5@5     @5@5fffff@5     @5     @5@533333@5@5@533333@5@5fffff@5@5@5@5@5     @5@5L@5@5333333@5     @5L@5L@5333333@5333333@5@5      @5      @5@5333333@5333333@5333333@5@5333333@5333333@5@5@5333333@4fffff@5      @5      @4fffff@5      @5@5      @5      @5333333@5@5L@5L@5      @5      @5      @5333333@5@5      @433333@4@433333@4fffff@4fffff@4@433333@433333@4@4@4@4@4@4ffffff@4333333@4     @4L@4L@4L@4L@4@3fffff@4@4@4      @3fffff@4@4      @4@3fffff@333333@3     @3@4      @4@3fffff@333333@3@3fffff@3@3@3fffff@3fffff@333333@3@3@3@3     @3ffffff@3     @3L@3     @3@3     @3     @333333@3@3ffffff@3@3L@3     @333333@3@3     @3333333@3L@3L@3ffffff@3L@3     @3ffffff@3L@3@3L@3@3L@2@3      @3L@3@3L@3L@3333333@3@3@3333333@3L@3L@3L@3L@3L@3333333@3333333@3333333@2fffff@233333@2@2@233333@2@2@3      @3L@233333@2ffffff@3      @3      @2fffff@3@2fffff@2@2fffff@3      @2@2@3@3@3@3      @3@3      @3      @3L@3@2fffff@2fffff@2fffff@2@3@3ffffff@2@3L@3@3      @2fffff@3@3L@3@2@2fffff@2fffff@2fffff@3@3L@3      @3L@3L@3333333@3@3333333@2fffff@2fffff@3      @3      @233333@2fffff@3@3      @2fffff@233333@2fffff@3      @2@3      @3      @3@3333333@2fffff@3@3@2@3@3333333@2fffff@3      @3@3@3@3@3333333@3333333@3      @2fffff@2fffff@2fffff@3      @3      @2@2@2@2@2fffff@2fffff@3      @2@3      @3333333@3      @2fffff@2@233333@233333@2     @2@2fffff@3      @2@2@233333@2     @2ffffff@2@2@2     @2ffffff@2@233333@2     @2333333@2ffffff@2333333@2ffffff@2     @2L@2333333@2333333@2ffffff@2L@2     @2ffffff@2L@2333333@2@2L@2L@2ffffff@2@2L@2ffffff@2L@2@2333333@2333333@2333333@2333333@2333333@2@2333333@2333333@2333333@2L@2@2@2333333@2     @2L@2@2333333@2ffffff@2L@2@2@1fffff@2333333@2@2L@2333333@2L@2@2L@2ffffff@2333333@1@1fffff@2@2     @2L@2@2L@2L@2L@2333333@2@1@2      @2@2333333@2@2@2L@2@2333333@1fffff@2      @2333333@1fffff@1fffff@2333333@2333333@2333333@2      @1fffff@2      @2@2L@2ffffff@2      @2L@2     @2@2      @2ffffff@2ffffff@2      @2      @2L@2@2333333@2L@2333333@2L@1fffff@1fffff@2      @1@2333333@1fffff@2      @1fffff@1@2      @2      @1@2@2333333@1fffff@1fffff@1@2      @1fffff@1@2      @1fffff@133333@133333@1@133333@1@2      @1fffff@1fffff@133333@2333333@2@133333@1@2@1fffff@1fffff@1@1fffff@2@2      @1fffff@2@1@1@2      @2333333@2333333@1@2333333@2      @1fffff@1fffff@133333@1fffff@2@1fffff@1fffff@1@2      @1@2@2@2333333@2      @1fffff@2      @1fffff@133333@1@2L@2     @2@2333333@2333333@2@1fffff@1@2333333@2@1fffff@2333333@1fffff@2      @1fffff@2ffffff@2      @1fffff@2@2333333@2@1@2      @2ffffff@2@1@133333@1fffff@2ffffff@2     @2      @2@2ffffff@2333333@2ffffff@2ffffff@2333333@2ffffff@2@2@2ffffff@2ffffff@2@2ffffff@2     @2@2     @2ffffff@2L@2     @233333@2@2     @2     @233333@3      @2@2L@2     @2     @233333@233333@2@2@2@2fffff@2@2@2     @3@3ffffff@2@2@3@2fffff@3@3333333@2fffff@3@2fffff@3333333@3ffffff@3L@3L@3     @3@3333333@3      @2fffff@3@4      @3@3     @3@3@3     @3L@3ffffff@3L@3ffffff@3     @3L@3L@3fffff@3L@3fffff@3@3L@3ffffff@3fffff@3@3ffffff@3@3fffff@3@333333@4      @3fffff@3     @4      @4ffffff@3fffff@4@4333333@4@4@4L@3fffff@3@333333@4333333@4     @4     @4     @4@4@4     @4@433333@4ffffff@4@4fffff@5L@5      @4@5      @5@5333333@5333333@5      @4fffff@5      @5333333@5@5333333@5      @5ffffff@5333333@4fffff@5@5     @5     @5L@5333333@5ffffff@5ffffff@5     @5@5333333@5ffffff@5@5@5@5@5     @5@5fffff@5@5@6@5fffff@5@6      @5fffff@6@6333333@6@6@6333333@6333333@6@5@6@6@6@6@6333333@6333333@6333333@6333333@6333333@6333333@6333333@6L@6333333@6ffffff@6ffffff@6ffffff@6L@6     @6     @633333@6@6@6@7      @633333@633333@6fffff@7      @6fffff@6fffff@7      @7      @7@7ffffff@7333333@7333333@7333333@7ffffff@7     @7ffffff@7     @733333@8      @8ffffff@8     @8@8333333@8@9333333@8fffff@8fffff@9L@9      @833333@8@9      @9L@9@9L@9ffffff@9@9     @9fffff@:      @9@9fffff@9fffff@:@:L@:      @:      @:      @:333333@:333333@:333333@9fffff@:      @:ffffff@:@9fffff@:333333@:@:@:@:@:@;      @:fffff@:fffff@;@;L@;@;ffffff@;     @;33333@;@;@;@;@;     @;@;fffff@;@;33333@;33333@;@<L@;fffff@;fffff@<333333@<@<333333@<@<L@<     @<ffffff@<333333@<333333@<@<ffffff@<33333@<@=@<33333@<33333@<@<@=      @<33333@<L@<fffff@<fffff@<fffff@=333333@=      @<@=      @=      @=333333@=L@=L@=ffffff@=     @=     @=@=     @=33333@=ffffff@=ffffff@=ffffff@=     @=@=@=fffff@>      @=@>333333@>@>@>ffffff@>     @>L@>@>@>@>@?333333@>@>@?      @?333333@?L@?     @?ffffff@?33333@?@?     @@      @?fffff@@      @@@@@@      @@@@&fffff@@ffffff@@Y@@L@@Y@@L@@L@@Y@@s33333@@@@@@@@fffff@@33333@@     @@@@33333@@33333@A&fffff@@fffff@@33333@A      @@ٙ@@     @A@A@A      @@ٙ@@ٙ@@33333@A@@33333@@fffff@A@A      @A@A@AY@A&fffff@A333333@AY@A@     @A333333@A@Affffff@A@A     @A     @A@A@A@A@A@Afffff@A     @A@A@Aٙ@Aٙ@Afffff@A     @Afffff@A33333@Aٙ@Aٙ@A33333@A33333@A33333@A33333@B      @Aٙ@B&fffff@B333333@B@     @B333333@B@B@B@     @Bffffff@B@B@Bffffff@Bfffff@B33333@B     @B33333@B     @Bfffff@Bٙ@Bfffff@Bٙ@C@C&fffff@C@C@CY@C333333@C      @C@C333333@C@     @CY@C333333@CL@C@C@CL@Cffffff@Cs33333@C@Cs33333@C     @C@C@C     @Cs33333@Cs33333@C     @Cs33333@C@Cfffff@C@C33333@C     @C33333@C33333@C@C33333@Cfffff@D@D@D      @C33333@C33333@Cfffff@C33333@C33333@D@D333333@D@     @D@     @D333333@DY@Dfffff@Ds33333@D@D@D@D33333@D33333@Dٙ@Dfffff@E      @D33333@E      @E@E@E333333@E&fffff@E333333@E333333@EY@E&fffff@EY@EL@EL@E333333@EY@E     @Es33333@Es33333@Effffff@EY@E@E@E33333@Effffff@E@E@E33333@F@F      @E@E     @E     @Efffff@F@F333333@F&fffff@F@FY@FL@Fs33333@F     @F@Ffffff@F@FY@F@F33333@F@F33333@G      @F33333@F33333@Fٙ@Ffffff@G@G@GL@G333333@G333333@G@G333333@G@     @G@     @GY@G333333@G@     @G     @G@G@Gs33333@Gfffff@Gfffff@GY@Gs33333@G33333@G     @G     @H      @G     @G     @H      @Gfffff@G     @G@G     @G@G@Gfffff@H@G@G33333@H@HL@H333333@H333333@H@     @H333333@H@H@HY@H     @H@H33333@H     @H@H@H     @H@H33333@Hٙ@H@H@H     @Hfffff@I@Hٙ@Hfffff@H33333@I      @I333333@H33333@I&fffff@I&fffff@I333333@H33333@IY@I@     @I@     @IY@IL@Iffffff@I     @I     @Iffffff@I@     @IY@I     @I                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 ?^5?|?m?1&y?o?Vu?E?O;dZ?+J?I^5??"`?n?+J?1&y?$/?5?|h?1&?lC?xF?j~"?GzH?1&y?Vu?zG?C%?      ?
=p?1&x?1&x?9XbM?j~#?1&y?+?1&y?\(\?      ??|hs?;dZ?tj~?hr!?QR?1&x?tj?홙?A7Kƨ?9XbM?
=p?+?;dZ?;dZ?|hr?S?O;dZ? ěT?S?^5?|?vȴ?zG{?S?+?(\)? ěT?A7Kƨ?Gz?"`A?"`?n?Gz?lC?vȴ?333333?Q?+?$/?E?333333?/w?;dZ?"`?E?^5?|?^5?|?GzH?9XbN?      ?1&x?l?\(?x?ěS?O;dZ?"`A?GzH?p
=q?(\)?ȴ9XbN?ȓtj~?Q?bM?;dZ?"`?/v?j~"?"`A?"`B?1&?QR?
=p
?+?ȴ9Xb?KƧ?j~#??|hs?9XbM??|hs?E?tj~?E?333333?l?E?Q?l?-V? ě?l?nO;?hr Ĝ?`A7L?&x?Q?&x?lD? ě?Q?hr Ĝ?nO;?nO;?lD?lD?333333?l?&x?hr Ĝ?-V?&x?hr Ĝ?Q?lD?lD?&x?hr Ĝ?&x?hr Ĝ?hr Ĝ?lD?Q?
=p?`A7L?&x?hr Ĝ?&x?
=p?&x?`A7L?
=p?
=p?hr Ĝ?hr Ĝ?`A7L?
=p?&x?&x?Q?hr Ĝ? ěT?&x?hr Ĝ?bM?vȴ9X?vȴ9X?
=p?vȴ9X?vȴ9X? ěT?bM?
=p?`A7L?bM?bM?bM?vȴ9X?bM?&x?
=p?
=p?`A7L?`A7L?
=p?`A7L?`A7L?&x?bM?
=p?bM? ěT?bM? ěT? ěT?
=p?
=p?
=p?`A7L? ěT?vȴ9X?bM?vȴ9X?bM?vȴ9X?Q?bM?bM? ěT? ěT?hr Ĝ?hr Ĝ?bM?bM? ěT? ěT?vȴ9X?
=p?vȴ9X?
=p? ěT? ěT? ěT?vȴ9X?vȴ9X?bM?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?`A7L? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?Q?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?bM? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ? ěT?vȴ9X? ěT?;dZ?Q?;dZ?Q?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?vȴ9X?bM?Q?hr Ĝ?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?Q?;dZ?vȴ9X?;dZ? ěT?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ? ěT?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ? ěT?Q?vȴ9X?vȴ9X?vȴ9X?;dZ?Q?
=p?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ? ěT?`A7L?;dZ?Q?;dZ?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?Q?;dZ?vȴ9X?&x?`A7L?
=p?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ? ěT?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?&x?`A7L?;dZ?vȴ9X?;dZ? ěT?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?Q?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ? ěT?;dZ?;dZ?;dZ?vȴ9X?Q?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ? ěT?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?Q?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?Q?Q?Q?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ? ěT?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?Q?Q?;dZ?;dZ? ěT?;dZ?Q?;dZ?Q?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?Q?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?5?|h?Q?Q?Q?Q?Q?5?|h?;dZ?;dZ?vȴ9X?;dZ?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?;dZ?;dZ?Q?Q?Q?Q?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?vȴ9X?Q?Q?;dZ?;dZ?Q?Q?Q?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?Q?Q?;dZ?;dZ?;dZ?Q?Q?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?5?|h?Q?Q?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?5?|h?5?|h?Q?;dZ?Q?Q?Q?Q?Q?;dZ?5?|h?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?;dZ?Q?Q?Q?Q?;dZ?Q?Q?;dZ?5?|h?Q?;dZ?;dZ?;dZ?Q?Q?5?|h?Q?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?Q?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?Q?Q?Q?Q?Q?Q?vȴ9X?Q?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?;dZ?Q?Q?Q?;dZ?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?;dZ?;dZ?Q?;dZ?;dZ?;dZ?5?|h?Q?Q?Q?Q?5?|h?5?|h?Q?Q?5?|h?Q?Q?Q?5?|h?5?|h?Q?;dZ?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?5?|h?5?|h?Q?;dZ?Q?Q?5?|h?5?|h?5?|h?Q?Q?Q?;dZ?5?|h?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?5?|h?Q?Q?Q?Q?Q?5?|h?Q?Q?5?|h?Q?5?|h?5?|h?5?|h?Q?5?|h?Q?;dZ?5?|h?5?|h?5?|h?Q?-V?Q?5?|h?Q?Q?5?|h?-V?5?|h?-V?5?|h?5?|h?Q?5?|h?-V?Q?5?|h?5?|h?Q?5?|h?5?|h?Q?5?|h?Q?5?|h?Q?Q?5?|h?5?|h?5?|h?5?|h?Q?5?|h?-V?;dZ?5?|h?5?|h?5?|h?Q?5?|h?5?|h?Q?-V?5?|h?Q?Q?5?|h?5?|h?5?|h?Q?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?/v?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?Q?5?|h?5?|h?-V?Q?5?|h?Q?Q?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?Q?-V?5?|h?5?|h?Q?5?|h?5?|h?-V?5?|h?5?|h?Q?Q?-V?5?|h?5?|h?5?|h?5?|h?-V?5?|h?-V?-V?5?|h?Q?Q?-V?5?|h?Q?Q?5?|h?Q?-V?-V?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?Q?/v?/v?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?-V?5?|h?-V?/v?-V?-V?5?|h?5?|h?-V?5?|h?-V?5?|h?5?|h?-V?-V?-V?-V?-V?5?|h?-V?/v?5?|h?5?|h?/v?5?|h?-V?/v?-V?/v?-V?-V?5?|h?5?|h?-V?-V?-V?-V?5?|h?/v?/v?/v?5?|h?/v?/v?-V?/v?5?|h?5?|h?-V?5?|h?5?|h?5?|h?-V?5?|h?/v?-V?-V?/v?-V?/v?5?|h?1&y?5?|h?/v?-V?/v?/v?/v?5?|h?/v?5?|h?-V?5?|h?-V?/v?/v?5?|h?1&y?/v?-V?5?|h?-V?/v?-V?-V?5?|h?5?|h?-V?5?|h?-V?1&y?/v?/v?-V?-V?-V?-V?/v?/v?/v?1&y?/v?/v?/v?-V?/v?1&y?/v?-V?/v?/v?-V?/v?1&y?/v?-V?/v?/v?/v?/v?/v?/v?5?|h?5?|h?-V?1&y?1&y?1&y?/v?/v?/v?-V?/v?/v?/v?-V?-V?-V?/v?1&y?/v?1&y?/v?/v?-V?/v?-V?/v?/v?/v?/v?-V?-V?1&y?/v?1&y?1&y?/v?/v?/v?-V?/v?/v?1&y?(\)?1&y?/v?/v?-V?/v?/v?1&y?1&y?1&y?/v?/v?/v?1&y?1&y?1&y?/v?/v?/v?/v?1&y?/v?1&y?1&y?/v?/v?-V?/v?1&y?-V?1&y?1&y?1&y?1&y?1&y?1&y?1&y?/v?1&y?-V?1&y?/v?/v?1&y?/v?/v?/v?/v?1&y?1&y?/v?1&y?1&y?1&y?1&y?1&y?5?|h?1&y?1&y?1&y?1&y?1&y?/v?1&y?/v?/v?1&y?1&y?(\)?1&y?1&y?/v?/v?1&y?1&y?1&y?1&y?1&y?1&y?1&y?/v?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?(\)?(\)?1&y?1&y?/v?1&y?1&y?1&y?1&y?/v?/v?1&y?1&y?/v?1&y?1&y?1&y?1&y?(\)?1&y?/v?1&y?/v?1&y?1&y?1&y?(\)?1&y?1&y?(\)?1&y?(\)?(\)?1&y?1&y?(\)?1&y?1&y?1&y?1&y?/v?1&y?1&y?1&y?1&y?(\)?(\)?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?(\)?(\)?/v?1&y?1&y?1&y?/v?/v?(\)?1&y?1&y?/v?(\)?(\)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	P22                                     1                                       ).BFJ3~