CDF       
      pressure  s   time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20170205   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P21    CAST_NUMBER       2      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:34.737278Z    ORIGINAL_HEADER      6CTD,20250210CCHSIOWB
#Removed 'CTDFLUOR_TSG' as it's filled with -999
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2017-06-29. CTD data from cruise 18DD20170205, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20170205. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2017-001/index.php. 
#
# The information in this file for the cruise 2017-001 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-0036.ctd
#
# Start of originator file comment header
#
#*2017/06/29 15:26:50.02
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2017/02/10 06:17:38.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 198
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : CE9F1F72
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            0.3            202.1
#       2 Temperature:CTD               deg_C_(ITS90)   5.6248         6.8697
#       3 Salinity:CTD                  PSS-78          32.78          33.8432
#       4 Sigma-t:CTD                   kg/m^3          25.7461        26.7106
#       5 Oxygen:Dissolved:CTD:Volume   ml/l            3.4            6.87
#       6 Oxygen:Dissolved:CTD:Mass     µmol/kg         147.7          299
#       7 Fluorescence:CTD:Seapoint     mg/m^3          0.66E-01       1.162
#       8 PAR:CTD                       µE/m^2/sec      0              0.3
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        7  F       ' '     2
#       6  -99   ' '        6  F       ' '     1
#       7  -99   ' '        8  F       ' '     3
#       8  -99   ' '        7  F       ' '     1
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2017-001
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P21
#    EVENT NUMBER        : 36
#    LATITUDE            :  49  38.00000 N  ! (deg min)
#    LONGITUDE           : 139  39.97000 W  ! (deg min)
#    WATER DEPTH         : 3961
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    The descent rate of the CTD was very noisy with some complete reversals
#	of direction.
#    CTDEDIT was used to remove many records corrupted by shed wakes;
#	salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Fluorescence and PAR data are nominal and unedited except that some records were
#	removed in editing temperature and salinity and a large spike in
#	fluorescence was removed from file 0032.
#
#    The Transmissivity channel was removed because of frequent shifts in values during
#	casts and large variations between values during repeat casts.
#	The data are available, by request, from the chief scientist.
#
#    NOTE: While the Fluorescence:CTD data are expressed in concentration units, they
#	do not always compare well to extracted chlorophyll samples, particularly for
#	casts far from shore. It is recommended that users check extracted chlorophyll
#	values where available.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in Sea-Bird
#	Application Note #64-2, June 2012 revision (Sea-Bird_64-2_Jun2012.pdf), except 
#	that a small offset in the fit was allowed.
#
#    The Dissolved Oxygen sensor used in files 0001, 0002 and 0016 malfunctioned so the 
#	Oxygen:Dissolved:CTD channels were removed from those files.
#
#    The Oxygen:Dissolved:CTD sensor has a fairly long response time so data accuracy 
#	is not as high when it is in motion as it is during stops for bottles. This will be
#	especially true when vertical dissolved oxygen gradients are large. To get an estimate
#	of the accuracy of the Oxygen:Dissolved:CTD data during downcasts (after recalibration)
#	a rough comparison was made between downcast Oxygen:Dissolved:CTD data and upcast 
#	titrated samples. Some of the difference will be due to problems with flushing of 
#	Niskin bottles and/or analysis errors, so the following statement likely underestimates 
#	Oxygen:Dissolved:CTD accuracy.
#
#    Downcast (CTD files) Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.25 ml/l from 0 to 125 dbar.
#	±0.2 ml/l from 125 to 400 dbar.
#	±0.1 ml/l from 400 to 600 dbar.
#	±0.05 ml/l from 600 to 1500 dbar.
#	Low by up to 0.08 ml/l below 1500 dbar.
#
#    For details on the processing see document: 2017-001-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5--- --6-- ---7--- --8---
#!Pressu Temperat Salinity Sigma-t: Oxygen Oxyge Fluores PAR:  
#!re:CTD ure:CTD  :CTD     CTD      :Disso n:Dis cence:  CTD   
#!                                  lved:  solve CTD:          
#!                                  CTD:   d:CTD Seapoin       
#!                                  Volume :Mass t             
#!------ -------- -------- -------- ------ ----- ------- ------
#*END OF HEADER
     WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @B        data_max      @B        C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     ;  2   pressure                	long_name         pressure   positive      down   units         decibar    data_min      ?ffffff   data_max      @X        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      ;  n|   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d           temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?2W   data_max      @u!.   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       ;     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d           salinity                	long_name         salinity   units         PSS-78     data_min      @@dn.   data_max      @AJ}Vm   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      ; |   salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d       ?   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @*   data_max      @r        C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        ; M   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d          CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?S   data_max      ?Z1'   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      ; |   CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d          PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min                 data_max      ?   C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       ;    PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d          	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min               data_max               C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     ; -|   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d       i   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( w   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( x$   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      )؅   data_max      )؅   C_format      %10d       xL   latitude               	long_name         latitude   units         	degrees_N      data_min      @HH   data_max      @HH   C_format      %9.4f          xP   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      auU\R.   data_max      auU\R.   C_format      %9.4f          xT   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d        xX   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d        x\@B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     @B     ?ffffff@       @@      @ffffff@@       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<@<fffff@>      @?      @@      @@     @A      @As33333@B      @B     @C@C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @Hfffff@I@J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @Ufffff@V      @V@     @V     @V     @Wfffff@WFfffff@W     @W     @X      @X9@Xfffff@X     @Y      @Y@     @Y     @Y     @Zfffff@Z@     @Z     @Z     @[      @[@     @[     @[     @[fffff@\L@\fffff@\     @]      @]@     @]     @]@^@^@     @^     @^     @_      @_@     @_     @_@`      @`      @`@     @``     @`y@`33333@`     @`     @a      @a      @aC33333@al@a33333@a     @a     @a     @b      @b      @b333333@bffffff@b     @b     @b33333@bٙ@c      @c      @c@     @c`     @c     @c     @c@c@d      @d      @d@     @d`     @d     @d     @d@d陙@e      @e      @e@     @e\@e     @e     @e     @e     @f33333@f&fffff@f@     @f`     @f     @f     @f     @f     @g      @g      @g<@g`     @g     @g     @g33333@g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i33333@i@j      @j      @j@     @j`     @j     @j@jfffff@j@k      @k      @k9@kc33333@k     @k@k33333@k陙@l      @l@lFfffff@l`     @l     @l     @l@l@m      @m      @m@     @m`     @mvfffff@m     @m     @n      @nfffff@n`     @n     @n     @nfffff@nfffff@o      @o      @o@     @oS33333@offfff@o     @o     @o     @o@p$@p0     @p@     @pP     @p`     @pp     @p|@p@p     @p     @p     @p     @p@qfffff@q     @q      @q0     @q@     @qP     @q`     @qnfffff@q@qfffff@q     @q     @q     @q33333@q񙙙@r      @r     @rfffff@r8     @r>fffff@rP     @r`     @rp     @r~fffff@rfffff@r     @r     @r     @r     @r     @s@s     @s      @s0     @s;33333@sVfffff@s`     @sp     @s@s     @s     @s     @s     @s     @s     @s     @t@t     @t      @t0     @t@     @tP     @t\@ts33333@t     @t     @t     @t@t@tfffff@t     @t     @u      @u@u&fffff@u0     @u@     @uP     @u^fffff@us33333@u     @ufffff@ufffff@u     @u     @u     @ufffff@u@v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w	@w#33333@w0     @w@     @wP     @w^fffff@w@w     @w     @w@w33333@w     @w     @w     @x      @x     @x      @x+33333@x>fffff@xP     @x`     @xnfffff@x~fffff@x     @x     @xfffff@x33333@xfffff@xfffff@x     @y      @y     @yfffff@yC33333@yP     @y`     @yp     @y~fffff@y     @y     @y     @y     @y     @y     @yfffff@zfffff@z      @z0     @z@     @zK33333@zc33333@zp     @z     @z@z33333@z     @z     @z     @z     @z33333@{@{      @{0     @{@     @{P     @{[33333@{s33333@{     @{     @{     @{fffff@{@{     @{     @{     @|      @|#33333@|0     @|@     @|P     @|`     @|nfffff@|fffff@|     @|     @|     @|     @|     @|@}33333@}     @}      @}0     @}>fffff@}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}33333@~@~      @~0     @~@     @~P     @~X     @~s33333@~     @~     @~     @~fffff@~fffff@~     @~     @~     @      @33333@&fffff@0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @33333@@      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @@     @     @     @ @*fffff@0     @8     @@     @H     @P     @X     @`     @h     @p     @{33333@     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @_33333@h@p     @x     @     @     @     @33333@@     @     @     @     @     @     @@@     @     @     @      @     @     @@      @(     @0     @8     @@     @H@P     @X     @`     @h     @p     @vfffff@     @     @     @     @fffff@     @     @     @     @     @33333@     @     @     @     @      @@@@33333@(     @0     @8     @@     @D     @X     @`     @h     @nfffff@x     @33333@@     @     @     @     @     @33333@@     @     @     @     @     @33333@
fffff@     @     @      @*fffff@0     @8     @@     @H     @P     @X     @`     @ffffff@p@x     @     @     @     @33333@     @     @     @     @     @ř@     @     @     @噙@񙙙@     @      @     @     @fffff@#33333@(     @0     @8     @@@H@O33333@X     @`     @h     @m@y@     @     @     @     @@@     @     @     @     @     @     @     @     @     @     @      @33333@@     @      @(     @0     @8     @@     @G33333@X@`     @h     @nfffff@@     @     @     @     @     @     @     @     @33333@     @     @     @     @홙@@      @     @     @     @      @(     @.fffff@733333@@     @H     @L@Y@`     @h     @p     @x     @@     @     @@     @     @     @     @@     @33333@fffff@     @      @     @     @     @"fffff@(     @0     @8     @@@D@S33333@X     @`     @h     @m@x     @     @     @     @@33333@     @     @     @@fffff@     @     @     @fffff@     @     @      @     @     @@      @(     @0     @8     @=@Rfffff@X     @`     @h     @p     @@@@     @     @     @     @fffff@     @     @     @     @     @     @     @     @      @     @     @     @      @(     @.fffff@:fffff@@     @H     @P     @X     @`     @l     @p     @x     @     @fffff@fffff@     @     @     @     @@     @fffff@fffff@     @     @     @     @      @33333@     @     @      @(     @2fffff@8     @>fffff@H     @P     @X     @\@i@p     @x     @     @     @     @     @     @@     @     @     @@ᙙ@     @     @     @ @     @     @     @      @(     @0     @8     @@     @Ffffff@P     @X     @`     @h     @p     @{33333@     @     @fffff@@     @     @     @     @     @     @     @     @     @     @     @     @      @fffff@33333@     @      @(     @,     @9@@     @G33333@Q@X     @`     @h     @p     @x     @     @@     @     @     @     @     @     @     @     @     @     @fffff@     @@@@     @     @     @ @,     @0     @8     @@     @H     @X@`     @h     @p     @u@fffff@     @@@     @     @     @     @     @     @@fffff@     @     @     @@@     @     @     @33333@@     @     @      @$     @(     @,     @0     @333333@933333@<     @@     @D     @Ffffff@M@P     @T     @X     @\     @_@dfffff@h     @l     @p     @t     @x     @{@fffff@     @     @     @33333@     @     @     @     @     @     @     @@     @fffff@fffff@     @     @     @ϙ@@     @     @     @     @     @@     @     @      @     @     @     @33333@@     @     @33333@$@(     @,     @0     @4     @8     @:     @A@D     @H     @Q33333@T     @X     @[33333@d@h     @l     @o33333@u@x     @{@@     @     @fffff@     @     @fffff@@     @     @     @     @@fffff@     @     @     @     @     @     @     @     @     @@fffff@     @뙙@@     @     @     @ fffff@fffff@	33333@     @fffff@     @     @     @      @$     @'@,     @0     @333333@8fffff@<     @@     @D     @H     @J@T@X     @\     @`     @bfffff@lfffff@p     @t     @w@     @     @     @33333@     @     @fffff@@     @     @@     @     @     @     @@     @     @fffff@fffff@33333@     @     @     @33333@     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @ fffff@"     @'@,     @0     @4     @8fffff@:     @A33333@D     @H     @L     @U@X     @Z@`@d     @h     @l     @p     @t     @x     @|     @     @     @fffff@@     @     @     @     @@33333@33333@@     @     @     @     @     @ə@     @     @ә@@     @     @     @     @     @@     @     @      @@     @     @     @@fffff@      @$     @(     @,     @0     @4     @6fffff@<     @@     @D     @H     @K33333@Tfffff@X     @\     @^@e@h     @l     @p@t     @x     @|     @fffff@33333@     @     @     @fffff@     @     @     @@@     @     @@@     @     @fffff@     @     @     @     @     @     @㙙@     @     @     @     @     @     @      @     @     @     @     @@@     @      @$     @(     @+@8     @<     @@     @D     @H     @J     @T     @W@]33333@`     @c@hfffff@l     @p     @t     @w@}33333@@     @@     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @     @33333@@     @     @     @     @     @@     @     @     @     @     @33333@     @      @"@)@,     @0     @4     @8     @:@@     @D     @H     @L     @P     @T     @W33333@]@`     @d     @h     @l     @o33333@s@x     @|     @fffff@33333@     @     @     @     @     @     @     @     @     @     @33333@@     @@     @     @     @     @33333@     @     @ߙ@     @     @     @     @fffff@@@      @     @     @     @     @@     @     @@,@0     @4     @8     @<     @@     @B@H     @L     @P     @T     @X     @\@`     @d     @h     @pfffff@t     @x     @{@@     @@33333@     @@     @     @     @fffff@@     @     @     @     @     @     @33333@fffff@     @     @     @     @     @     @뙙@     @     @     @@     @     @     @     @     @     @     @ fffff@$     @(     @,     @0     @4     @8     @;33333@Dfffff@H     @L     @P     @T     @Xfffff@[33333@`     @d     @g33333@p     @t     @x     @@     @     @33333@fffff@     @     @33333@33333@     @     @     @fffff@@     @fffff@     @     @     @     @     @     @@     @     @     @fffff@     @33333@      @     @     @     @     @     @      @)@,     @0     @333333@<fffff@@     @D     @H     @K33333@U33333@X     @[@e@hfffff@l     @p     @t     @x     @|     @fffff@     @     @     @     @33333@fffff@     @     @     @     @     @     @33333@33333@     @     @     @     @     @fffff@     @     @     @     @     @fffff@     @33333@@      @     @     @     @33333@@     @      @$     @(     @,     @.fffff@4fffff@8     @<     @@     @D     @I@L     @P     @T     @X     @\     @_@e33333@h     @l     @p     @tfffff@w@{33333@     @     @     @     @     @@     @     @     @     @@fffff@33333@@     @     @     @˙@@     @     @ߙ@     @     @33333@@     @      @     @@     @     @     @     @      @$     @(     @,     @0     @4     @733333@<@@     @D     @H     @L     @P     @T     @X     @\     @_@dfffff@h     @l     @p     @t     @v     @}@     @     @     @     @     @33333@@     @     @     @     @@     @     @     @     @     @Ù@33333@     @     @     @ᙙ@     @     @뙙@33333@     @     @     @fffff@@     @     @     @@@      @$     @'@-@0     @4     @8     @<     @?33333@D@H     @L     @Q33333@T     @X     @\     @`     @d     @h     @l     @u33333@x     @|     @     @     @fffff@33333@     @     @     @     @     @@33333@     @     @     @     @fffff@33333@33333@͙@     @     @     @     @     @     @     @     @fffff@     @     @     @      @     @     @33333@     @     @     @     @ fffff@$     @(     @+33333@/@4     @8     @<     @@     @D     @H     @J     @Q@T     @X     @\     @`     @d     @ffffff@p     @t     @x     @|     @33333@@     @     @33333@     @     @     @@     @@     @     @     @     @     @fffff@љ@     @     @     @     @33333@33333@     @     @     @     @     @      @     @33333@
@     @     @     @     @      @"fffff@,     @0     @2@8fffff@<     @@     @D     @F     @Lfffff@P     @T     @X     @\     @`     @dfffff@g@l     @p     @t     @w@|     @     @     @33333@     @     @33333@33333@     @     @     @@@     @     @fffff@@     @     @˙@ՙ@     @     @     @fffff@33333@     @33333@fffff@     @      @     @
@     @     @     @@$     @(     @,     @0     @9@<     @@     @D     @Hfffff@Lfffff@O@Tfffff@X                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        @qu!S@rᰊ@qiB@o{J#:@or@kU=@iB@i^@ka@@kP{@kjf@m8Y@nzG@n.2@nc	@nzG@n.2@nO;@p:~ @qiB@qu!S@oVϫ@or@oVϫ@o@oVϫ@p
(@q&x@qiB@r-V@q-@qiB@rs@q[W>6@pD@q@p
(@pD@p{@pD@pD@q&x@q&x@p
=q@oO
M@p'RT@p:~ @qu!S@qo@p{@q[W>6@qiB@qo@p
=q@nt@m
qv@mw1@mw1@m(@m\@mV@mV@l!-w@k6z@kC]@kQ@kP{@k6z@jfB@kI^@kC,z@kP{@kI^@jOv`@i^@h@g/V@g	k@h	ԕ+@hr Ĝ@hXy=@h$xG@hr Ĝ@h@g&@f1.@f@eS@fL/{J@eڹ@eS@f1.@f1.@f1.@eS@f@ffffff@ffffff@ffffff@f,<@fA@f'@fIQ@fIQ@fx@h@iB@jOv`@kP{@kQ@o4֡a@t֡a@z)y@{5Xy@@7KƧ@1@S@u!.@sg	l@kjf@f@aae@RS&@LI^5?@JqiC@=E@+C]@
D@V@-
@	k~@o@d7@ө*0U2@Ǔݗ+@m]@fA@}H@zH@:@C\N@
ڹY@,<@_ح@Z@l<쿱@fL/{J@[Q@V8YJ@H@>m\@1'@u%F@ݗ+k@,zxl@4K@M@N;@䎊@nP@$tS@`	k@=v@=K@+J@m@o @K]c@J#9@ɺ^5?}@Vl!@2W@A [@o@.2@A [@@M:@@{dZ@ilD@G_o@9#w@+6z@!-w1@-V@1&@e+a@m@&I@"`@)_@)@|Q@Ϫ͞@]cf@˒:)@@)^@,zxl@xYJ@uY|@lq@fA@QN;5@JqiC@D2W@3|@JE@~($x@[W>@!-w@ᰉ@oiDg@BZc @'RT@Ov_خ@+@R@gfA@B@<Z@<쿱[@:^5?|@84֡b@5Y|@)y@%S@#n.3@	@%@䎊r@҈p;@qu!@?@Y|@iB@ ě@@xl"h
@@-
@qiC@{m]@u?|h@rᰊ@qA [@j0U2a|@dxF@^Ov_خ@M(@6Fs@iB@y=c@*0U@1&x@7Kƨ@KƧ@c	@Ov`@fA@@4@?@iDg8@e+@s@t3@ka@@`A7K@X*0@U2a|@R<64@Ov_ح@Nqi@H1&x@F
L/@A$/@7Xe@-8Y@-V@y=c@*1@
@F@&x@[6@Ίqi@]cA@	 @żn/@@n.@E@:~ @3@S@b}@t@(@zH@sg	l@mhr!@ix@ZY@XU@U*0@QX@N+@JD@EoiDg@?[W>@:G{@9(@5?|h@.1@+C]@)@'	k@&L/{J@"wkQ@u@&@=K@N;5@	7KƧ@,zxl@j~#@kP@@a|Q@>BZc@A@@F
L0@A7K@ ѷY@Xe,@L_@s@hr@lC@4K@.2@"h	ԕ@C,@@&@ߤ?@L_@qiC@@E84@s@
L/@S@Zc@7Kƨ@o hی@:S@4m9@}E@w4m@or@mV@i*0U2a@d?@^ ѷY@[q@["`B@ZY@Z6C@XbM@P$tT@M5Xy>@I7KƧ@DJM@<?@=H˒@?b}V@?.H@;J#9@9D@73@43@49XbN@2-V@/iDg8@-V@*g	@$/@cA @Ov_خ@]ce@
#9@p:@
:@˒:*@)@'RT@C@8Y@͞&@唯O
@9@ae@[@ڹY@PH@*0@Fs@:)y@&@Ձ$/@R@qiC@ɅoiD@)^@\N@o hی@6@dZ@=b@+@}Vl@4K@!.@4K@D@ᰊ@oiDg8@zG@q@I^@IQ@?@eO@ěT@-V@N;@6@Y@vȴ@|@tj@
=p@$/@@@N@<64@tj~@䎊@_p@*1@N;6@9Xb@&IR@~vȴ9X@|Z@y	k~@xQ@xF]d@sg@m(@iy@^5?|@\wkP@Zc	@XPH@Y+@Z6C@\C,zx@["`B@RT`d@OrGE9@O@Kq@J	 @I@EoiDg@>$t@>\N<@B@@NU@>m\@@NU@BZc@Ao hی@?.H@>vȴ9X@=p
=@<#x@9"`@8Q@8}H@7rG@7KƧ@6C-@6ȴ9X@6Fs@6E@5sg@2-V@0U2a|@.1@-
qv@-B@,<쿱@+6z@(r Ĝ@'8}H@&IQ@(ۋq
@)y@*fB@+C,z@)ᰉ'@($xG@&fffff@%+a@$7@#A [@#S@!R<6@ 'RT`@ ѷY@=K^@U@O;d@fA@sP@v_ح@
W'@@@YJ@m\@M:@$@@I^5@:S@ C@.H@_ح@oiDg8@iDg8@VϪ@JL@S@>@c	@֡af@_o @[W>@E@ߤ@ ě@0
@zxl"h@쿱[W@*0U2@bM@-
q@'/W@ߤ?@O;dZ@=p
@oiDg@.H@}!.H@}!.H@zG{@u%F
L@o hۋ@b}Vm@^҈p;@^5?|@\N;@Yb}@O͞@Gy@DS@B74@@n@?@@6@A7Kƨ@>6z@;/V@.1@*0U2a|@',@&'@!R<6@PH@Z@N;6@@Vu@q@	7KƧ@hr@Y|@\@7@@N@ٳ|@Ϫ͟@@Ϫ͞@W'@:@@Zc@H˒:@Xe@@TɆ@9@[6@@qiC@#@@ѷX@~m\@~"@~($x@{lC@w1@rGE85@a@N@^5?|@\?@[6@QR@JD@Gy@@4m@;5Xy@9~($@73@43@.2X@!R<6@u@_o@$tS@Fs@
(@	ԕ*@@
s@
 ě@
JL@
d8@
]ce@
Ʌoi@
H@
p:~@
@
TɅo@
4K@
V@
%@
Q@
kP|@
e+a@
@
R<6@
S&@
'/W@
M:@
ݗ+@
}!.H@
y(@
ql@
m8Y@
jJL@
g	k@
\]ce@
U=K@
R<64@
N+@
I@
B\(@
;A@
5'0@
,1&y@
%S@
S@
-
q@
	 ѷ@
ݗ@
o hی@.H@~$@1@{m@D@iDg8@~"@Z1@m@*0U@_o @:@̘_@)^	@W'@@\N@4m@
(@1&y@&@3@IQ@vȴ@Fs@rGE9@ߤ?@ڹY@     @zxl"h
@t!-w2@o4֡a@l"h	ԕ@be+@^ ѷY@ZQ_@YJE@Xy=c@UϪ͞@O͞@GE84@<64@0{@',@!o@S@e+a@0
)@@tj~@\(@I^5?@YJ@tj@˒:)@l"h	@s@g	@唯O
@C,@>BZ@҈p:@`A7@@v@m\@jf@,@3@h	ԕ@@@Fs@-
q@C%@Fs@n.@}!.H@{s@x73@n.2@f1.@^ ѷY@Vt@T*1@Q@L/{J#@As@>BZc @6z@.2X@'/V@&@&@#wk@!-w1@C,zx@kP|@O;d@@
m\@
+@
!R@
j~@
!-w2@
䎊q@
iB@
"h	ԕ@
ۋq
@
lC@
ce@
҈p:@
_p@
`A7@
@
4֡b@
6z@
ae@
6C@
Xe,@
n/@
~$t@
|hr@
x-
@
ql@
j~"@
h@
b}Vm@
^@
[6@
Zc	@
ZQ_@
Y>BZ@
Yb}@
YJE@
Vaf@
RT`d@
PH@
C\N@
<Z@
6}Vl@
3g	l@
.zG@
&@
U=@
ߤ@@
Xe,@
Fs@
	ԕ*@
M:@
n.@
 ѷX@	H˒@	-
@	@	O;@	.2@	\@	Ov`@	1.@	%1@	حV@	ڹY@	>6z@	_p@	cA \@	)^	@	s@	˒:*@	š@	ěS@	a@N@	s@	@	
(@	dZ@	Y}@	YJ@	Q@	?|h@	r@	U=@	-@	TɆ@	?@	ěT@	u@	,=@	%@	u"@	@@	I^5?@	u%F@	Fs@	.H@	xF@	x73@	w1@	sE@	oiDg8@	k~($@	jJL@	irGE@	f,<@	^@	ZQ_@	T*1@	N+@	MjOv@	L/{J#@	J#9@	Gy@	A [7@	;5Xy@	6}Vl@	3ߤ@	12W@	/r@	-U=@	(TɅ@	#
=p@	䎊r@	%@	1&@	,<@	$tS@	@	N;6@	rGE9@	n.@F]d@g@@!-w@"h	ԕ@JL@ᰉ'@	k@唯O
@ᰉ'R@҈p;@Ϫ͟@N;5@v_ح@͞%@̘_@Ƨ@˒:*@n@n.@XbM@KƧ@z@a|Q@{J#:@-@.H@ěT@PH@qi@k~(@ݗ+@S&@IQ@y=b@w+@r ě@n.2@nc	@l"h	ԕ@a'R@\>@\]ce@\(\@[W>6z@YJE@U2a|@L/{J#@D2W@A7Kƨ@?[W>@B\(@A@?@8)@2m\@/{J#:@,zxl"@(@#S&@쿱[W@C,zx@O;d@Z@sP@
qu"@YJ@H˒@E@t@VϪ@B@	ԕ+@@Ft@$@b}@2a|@Ϫ͞@)^	@Ƨ-@TɅo@5Xy@E@a|Q@U2a|@U=@tSM@O
M@ڹY@1&x@o h@.H@w1@r䎊q@p@mhr!@kC,z@h	ԕ+@ceO@Vaf@N_o @JL_@H@E8YK@D*0@A [7@>
(@;dZ@6E@.1@#S&@,<@sh@)^@Mj@	ԕ*@_o@S&@˒:)@b}V@m\@"@73@j~@fB@@	ԕ+@A@唯O
@S@Gz@cA @@v_ح@ɺ^5?}@@@@@64@dZ@D@Xe@sg@{J#:@lD@x@tj@Fs@@@N@!R<@@y"`@w+@p
=q@ix@iB@h>BZc@h@h@hۋq
@iDg8~@irGE@h@kC,z@irGE@hr Ĝ@f,<@bM@_o@\>@\N;@[q@Y+@S&@Rm@R<64@O;dZ@N;5X@I@GE84@C$@B@Ca@N@B&IR@<64@;5Xy@:^5?|@9Y}@:)y@43@2m\@1[W>6@0{@/r@+a@@&L/{J@%u@)@'-@-V@*0@R<6@*0U2@:)y@qi@
qiC@%2@Vl!@+@!-w2@"h	ԕ@lC@W>6z@JE@֡af@E@|@]cA@84֡@@/V@?|h@2W@}Vl@U=@u@!-w1@_o@+j@@Ov_@n@ڹY@$/@F]c@˒:)@xF@wkP@v_ح@r{m@pD@o@h	ԕ+@a'R@a'R@a'R@`u!@`
qu@_?@[$@ZQ_@W>6z@SZ@M5Xy>@I@E@E8YK@Dg8}@Ca@N@As@@6@>6z@=b@;A@8)@6E@2-V@0{@*d7@'RT`e@"3@ [6@	@Q@vȴ@@L_@sP@!R<@
O;dZ@
qu"@L_@	ԕ*@@ IQ@\N<@?@!.@E@{m@D@C\@P{@ۋq
@@A [@ⶮ}Vm@ᰉ'R@@N@iB@c	@ק&@
M;@@)^	@@E84@?@84֡@ěS@5Xy@z@ߤ@ᰊ@q@/@o@[6@C,zx@Xe,@n@)^@M:@I^5?@L_@7KƧ@YJ@ ѷ@|hr@xl"h	@xF]d@rGE85@o@iᰉ'@hr Ĝ@gfA@g@eO
@d7@ceO@a|Q@\>@\?@]+j@]/w@Xy=c@S&@Q@Ov_ح@L@I^5?}@G)^@D2W@BZc@@C@>BZc @<64@:~@9~($@7Xe@2W@0U2a|@/O
M@-U=@+a@@(Xy=@$xF@!-w1@쿱[W@C,zx@*0@O;d@O;d@$tS@$tS@Xe,@O
M@tj~@N;6@rGE9@qi@n/@M:@ ѷ@ ѷX@b}V@m\@rGE8@Fs@ ě@O;@Ov`@r Ĝ@@eO@e@A7K@u!@ޞ@]ce@"`B@bM@Ϫ͞@,<@T`d@H@Ϫ͞@@Q@˒:*@@?@2W@TɅo@4m@z@?|h@a|Q@zxl"@͞&@/V@h	ԕ@[6@u@Q@6C@@$/@@@qi@M:@JM@@ѷX@}!.H@y=b@vFs@s@o@m(@kC]@ix@e`A7L@bC,@aGz@_?@^ ѷY@]ce@Xy=c@T`d@Q@O͞@Np:~@MjOv@JL_@G@@GE84@F]cf@Fs@Fs@E84֡@Ca@N@A@@4m@@NU@?[W>@7rG@7KƧ@6z@49XbN@333333@12W@1o@1-@1-@/Vϫ@,q@(TɅ@#9@ ěT@%@tj@tj@+j@@ᰉ@Z@nO@$tT@\(@@
qiC@	'RTa@
O;dZ@	ԕ*@S&@˒:)@ȴ9X@#@@MjO@ ě@oiDg8@C@g	@rGE@,<@䎊qj@eO@M@҈p;@?@1'@@8YJ@t@Ʌoi@R@͞%@cA \@]cA@ɅoiD@ǮzH@Ƨ-@84֡@@&IR@쿱[@A@~@)_@)_@)y@)@E@|@m\@&x@{J#:@H@/V@.H@[6@'RT`@	@Ov_خ@u"@Xe,@Ov_@zG@S&@bM@qi@O;dZ@҈@ԕ*@1&x@@F]c@hۋq@}H˒@{lC@{s@zC\@zxl"h
@zC\@y(@xl"h	@{m]@|Q@wkP@v+jg@mhr!@h>BZc@cS@\?@[$@Yb}@Vt@SMj@Rm@Rp:@QN;5@QN;5@PH@Np:~@L_@LcA \@JL_@GzH@D*0@C\N@Ca@N@C,zxl@ATɅo@=b@=p
=@:)y@73@7KƧ@6z@5?@6z@5sg@5?|h@4֡a@3ߤ@0U2a|@.zG@(\)@%zxl"h@%F
L0@#wk@ 	k@	@_F@Xe,@@ᰉ@@N@~($x@	7KƧ@ݗ@n.@$/@ 4m9@Vl!@hr@PH@PH@Q@lC@m]@>B@"`@	k~@ȴ9X@GE85@(@ᰉ'@8}H@,<@Z1@C,@Z1@Z@eO@C,@@N@iB@iB@JE@E@ӎMj@_p@ΤT@͞%@E84@2W@NU@H˒:@6z@BZc @K]@64@/V@)_@Q@sg@|@&x@[W>6@U2a|@r@H@>B[@y@x@x@'@S@S@?@	k@Q@IQ@[@1&@qu!@6C@$tS@L_@Z@zG@Fs@@N@nO@M:@n/@@4n@~($x@|Q@x-
@xF]d@weں@weں@v!.I@vFs@uY|@r䎊q@o-V@nt@l!-w@irGE@f,<@`d8      @\N;@[q@[W>6z@XD*@W
=p@S@R䎊@P{@O
M;@JL_@I^5?}@I^5?}@H@H@Fs@Eo i@C$@B@BZc@A@?@;dZ@84֡b@9#w@8YJ@8YJ@5sg@0{@.zG@+U=@*0U2a|@'&@$?@!o@U=@6C@tj@Z@:)y@@Vu@
O;dZ@'/@	7KƧ@F]c@ IQ@ \N<@ #x@ ?@ ~$@ rGE8@ j~@ A [@ 4֡a@ oiDg8@ 8Y@ Q@ rGE@ 7@ ߤ?@ $@ ٳ|@ e+@ c	@ y=c@ @ @ |@ т@ ͞%@ ʌL_@ Q@ ěS@ NU@ 
(@ 5Xy@ )_@ )y@ #w@ ?|h@ {@ O
M@ V@ U=@ 0U2a|@ L/{J@ F
L0@ u@ ?@ .H@ .H@ wk@ -
@ 쿱[W@ IQ@ O;d@ $/@ tj~@ hr @ Vu@ '/@ 7KƧ@ u%F@ &I@ JM@ u%F
@ ~"@ }Vl!@ xF@ xl"h	@ xF]d@ u!R@ rs@ q@ mC\@ k~($@ jg	@ iB@ g8}H@ de@ d%1@ bC,@ a'R@ `u!@ ]ce@ [q@ [6@ [6@ [W>6z@ Y+@ XbM@ WsPH@ Vt@ T*1@ Sa@O@ O͞@ M:@ L/{J#@ J#9@ G)^@ DS@ @C@ @4m@ <쿱[@ :~@ 73@ 6E@ 5sg@ 3|@ 2a|Q@ 0 ě@ .H@ -B@ +6z@ )@ $TɆ@ "wkQ@ "3@  -
@ 	@ IQ@ qu!@ 6C@ _o@ e+a@ @@ tj@ sh@ sP@ )^@ -
q@ o @ !R<@ 
M:@ 
M:@ ~($x@ q@ 
=p
@ eO@ JM@  ѷ@  IQ?lC?Y|?s?oiDg8??-V?VϪ?g	?x?,<?`A7L?ݗ+j?b}?
=p?E?䎊?*0U?_o ?s?)^?n?j~#?rG?4m?}Vl?E?E?E?-V?O
M?}Vl?U=?*0U2a?TɆ?wkQ?wkP???R<6??7KƧ?Q?nP?}H˒?xF?v_ح?u!R?u%F
L?tj~?sg?qiB?p
=q?l!-w?h	ԕ+?ceO?ceO?`A7K?_o?_Ft?_حV?_o?^?U2a|?RT`d?P{?PH?O
M;?M?H?E?BZc?<쿱[?=b?=K]?;5Xy?:S&?84֡b?64K?6C-?3ߤ?2W                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @@dn.@@dxF@@dߤ@@@d@@dL_@@dߤ@@@dߤ@@@dߤ@@@dߤ@@@dߤ@@@dߤ@@@dߤ@@@d@@dxF@@dxF@@dߤ@@@d@@d@@d!-w2@@dQ@@d!-w2@@d(\@@d,<@@d,<@@d,<@@d,<@@d%1@@d!-w2@@d"h	ԕ@@d!-w2@@d!-w2@@dQ@@dtj@@d"h	ԕ@@d(\@@d"h	ԕ@@d(\@@d%1@@d%1@@d(\@@d%1@@d%1@@d"h	ԕ@@d%1@@d2W@@d/{J#@@d/{J#@@d(\@@d%1@@d%1@@d(\@@d%1@@d(\@@d/{J#@@d<쿱@@d?@@d?@@dC,zx@@dFs@@dC,zx@@dC,zx@@dFs@@dC,zx@@dPH@@dI^5?@@dM:@@dPH@@dSMj@@dSMj@@dSMj@@dSMj@@dVϪ@@dZ1@@dcA \@@dg8}@@dm8@@dtSM@@dzG@@dwkP@@dq@@dq@@dq@@dq@@dwkP@@d?@@d*1@@d*1@@dN;@@d*1@@d_@@dS@@d*1@@d3@@d1&@@d#x@@dj~@@dO
M@@dj~@@dj~@@dj~@@dj~@@d[W?@@d#x@@d?@@dj~@@d@@d֡a@@d>B[@@dJM@@de@@eB@@e}H@@f@@fH@@f'@@g@@|q@@"`B@@rGE8@@@@p:@@0U2a|@@
=p@@zH@@4m9@@@@$/@@H@@Z@@0
)@@*0@@8}H@@y=c@@Q@@)_@@Z@@ӹ~($@@Ԅ?@@?|h@@iDg8@@=p
@@n@@ڂ@4@@,zxl@@ܯO
M@@L/{J@@rGE9@@IQ@@$tT@@R<6@@h	ԕ@@`A@@A [@@E@@Ov_@@1.@@思IQ@@"@@KƧ@@4m9@@ [7@@7KƧ@@A [@@\)@@	k~@@N;5@@x@@齥@@iB@@n@@n@@Ov`@@3@@0U2a|@@-V@@:)y@@M@@JL@@T`d@@ ě@@W@@`A@@s@@)^	@@҉@@s@@&@@	@@/V@@@N@@6z@@n.3@@n.3@@tj~@@{J#9@@@@Q@@U=@@6@@A@@:)z@@:)z@@6@@A [@@L_@@s@@$@@s@@%2@@a@@@lC@@ߤ@@@
=p@@ߤ@@S@@Q@@\N@@A [@@lC@@s      @@g@@s@@J@@xF@@\N@@\N@@g@@g@@tj@@!-w2@@64@@I^5?@@M:@@SMj@@I^5?@@2W@@!-w2@@%1@@<쿱@@64@@,<@@?@@Fs@@]ce@@cA \@@SMj@@m8@@~($x@@섵?@@C@@웥S@@zxl"@@hr@@e@@:@@'0@@*0@@*0@@+a@@L_@@S&@@S&@@Vl!@@w1@@sh@@u@@;5X@@BZc @@E@@L/{J@@\N<@@c	@@}Vl@@@@T@@-@@}Vl@@ߤ?@@m\@@"@@!.I@@Ft@@,@@E84@@\(@@&@@r@@vȴ9@@o @@@@rG@@Vϫ@@+j@@ ě@@[6@@@@tj@@
=q@@p:@@PH@@#w@@k~(@@񂩓@@@@@@R@@u%F@@#9@@T`d@@qiC@@S&@@@@ ě@@W@@䎊q@@c	@@m@@I^@@u%@@	@@6z@@MjO@@S@@tj~@@:)z@@@@|@@%2@@s@@ߤ@@@Fs@@PH@@Z1@@`d@@3@@?@@o i@@%F
L@@Y|@@}H@@O
@@
qv@@u@@BZc @@c	@@@@ hۋ@@8}H@@Xe,@@4m@@	k@@/V@@K]d@@+@@@@@#@@F]d@@	ԕ+@@	ԕ+@@@@-
q@@Xy=@@IQ@@9Xb@@TɅ@@`A7@@N;5@@k~(@@rGE8@@|Q@@@@u@@@@I^5@@Q_@@vȴ@@S&@@/V@@:)z@@lC@@J@@L_@@!-w2@@"h	ԕ@@%1@@Fs@@q@@o h@@3@@Z@@:@@`A7L@@+j@@n/@@ᰉ@@$/@@8YJ@@!R<@@R<6@@qi@@T@@'@@ߤ?@@,@@E84@@sPH@@fA@@rG@@@@䎊r@A 
qu@A }H@A 73@A >BZc@A Xy=@A [6@A -
@A )^@A 	k@ArGE@Ab}@A(@AD@A"`@Aᰉ'@Ae@Ae@An@AC\@AnO@AL_@AS&@AY@A&@AW>6z@Ajf@A5Xy@AL_@A64@ASMj@AC@A쿱[@AZ@A:@A/w@AY|@Aw1@A!R@A@A1@A8YK@Aڹ@AL/{J@A@AFs@A@A-@A*0U@AXy=@Ahۋq@Au!@AěT@A	Gz@A	k~(@A	^5?}@A	_o@A	@A	-@A
I^5@A
s@A
0U2a|@A
W'@A
p:@A
\(@A
vȴ@A
c	@AnP@A33333@AZ@AMj@A6@An.@AJ@A%1@A9XbN@Ao h@A_@A1&@A?@A[W?@AZ@A
u@A
2a|@A
?|h@A
IQ@A
Vl!@A
ce@A
@A
cA @A
ڹ@A+jg@AH@A\N<@AiB@Avȴ9X@AIQ@A+J@A@A}Vl@Aȴ9X@Ax@A)^@A.H@AU=@Ay@A?@A+@ArGE9@A	ԕ+@AbM@A ě@A*0@AA7K@AK]c@A[6@A@A)@AěT@A)^@A`A7@A*0U2a@Ahr @Ak~(@Ax@Ao@Al@A|@A^5?}@A2W@Aԕ*@Aᰉ'@A-@A&IR@AJL@AGE85@AT`d@Ah	ԕ@A@A͞&@A`A@AG{@As@Aqu!@Awk@Aq@A6@AlC@A!-w2@A,<@Am8@Ao h@A?@A#@AC@A*1@Azxl"@A7@Ahr@A>@AE@AK]@A+a@AS&@AO
@AU=@AU=@AH˒@A8Y@A!.@AzG@A@A!R<@A1.@A8YJ@A8YJ@A;5X@AR<6@AiB@AO;@A2X@Aȴ9X@AϪ͟@Ax@AXe@A.H@A8}H@AAs@ART`e@AlC@A|hs@A/V@A䎊r@A@A-
q@AD*@Ahۋq@Ay=c@AYJ@A-
@A
(@A
(@Aۋq
@A\)@A ѷ@A@AQ@Aae@Ak~(@ArGE8@Ao@A^5?}@A2W@AiB@AR@As@AY}@AlD@Au%F@AOv`@A&IR@A\(@Aᰊ@A0
@A>B@AG{@Au%@A'/@A)^	@A@N@AP{@A]cA@Ag	l@A@AZ@AƧ@Aݗ+k@AlC@A@A1&y@AL_@A"h	ԕ@A<쿱@AM:@A`d@A~($x@AC@AS@A1&@A#x@A@Ahr@Aqu"@A84֡@Ace@Ap
=@Asg@Azxl"h@AM:@A$/@AO
@A@A1@A@AS@A!.@A_o @A4K@Au@A.2@AL/{J@Al!-@As@AIQ@A$t@A2X@A]cf@AFt@A.H@A8}H@AU=@A	k@A?@AzH@A@ArG@A F]d@A }H@A -
q@A 4m9@A :~ @A Xy=@A y=c@A {@A )@A ěT@A )^@A ѷX@A F@A D@A e+@A {@A!#w@A!=b@A!Dg8~@A!hr @A!@A!R<6@A!'RTa@A!|@A!y@A!o@A!iB@A"u%F@A"#9@A":)y@A"@4n@A"T`d@A"xl"h
@A"ݘ@A"L/{@A"wkQ@A"S&@A">B@A"`A@A"fB@A"fB@A"䎊q@A"~@A#҉@A#)^	@A#,zxl@A#33333@A#P{@A#dZ@A#n.3@A#xF]@A#eO@A#q@A#$@A#E@A#6@A#ݗ+k@A#A [@A$n.@A$tj@A$,<@A$,<@A$?@A$m8@A$?@A$C@A$쿱[@A$@A$?@A$Z@A$u"@A$E@A$E@A%[@A%+a@A%B@A%?|h@A%L_@A%`A7L@A%p
=@A%O
@A%%@A%U=@A%@A%n/@A%Ϫ͞@A%ᰉ@A%,=@A%E@A%ڹ@A&4K@A&u@A&Ov_@A&;5X@A&BZc @A&L/{J@A&\N<@A&iB@A&+J@A&Fs@A&O;@A&,<@A&T@A&@A&T@A&}Vl@A&Q@A&@A&Ϫ͟@A&Fs@A&Fs@A' hۋ@A'!-w1@A'.H@A'As@A'E84@A'RT`e@A'_o@A'O;d@A'?@A'kP@A'	k@A'[W>@A'+@A'حV@A'Vϫ@A(@A(*0U@A($xG@A(:~ @A(A7K@A(A7K@A(K]c@A(Xy=@A(y=c@A(˒:*@A(@A(IQ@A(9Xb@A(
(@A(@@A(e+@A($tT@A)$/@A)rGE@A)#w@A)=b@A)Q@A)XbM@A)^@A)e+a@A)|Q@A)oiD@A)@A)u@A)(@A)@A)@A)2W@A)ԕ*@A)>BZ@A).H@A*&IR@A*C\@A*GE85@A*@4n@A*T`d@A*nO@A*@4@A*~"@A*@4@A*@4@A*vȴ@A*g	@A*g	@A*Y@A*Y@A*n@A* ѷ@A*䎊q@A*74@A+I^@A+I^@A+'/@A+s@A+PH@A+PH@A+s@A+s@A+&@A+)^	@A+J#9@A+tj~@A+eO@A+@A+Mj@A+$@A+*0U2@A+m]@A+E@A+a@O@A+Ƨ@A+ݗ+k@A+C]@A,ߤ@@A,Q@A,%1@A,,<@A,2W@A,Fs@A,VϪ@A,j~#@A,o h@A,qj@A,N;@A,N;@A,S@A,1&@A,?@A,[W?@A,*0@A,Z@A,֡a@A,֡a@A,/@A,@A,hr@A-qu"@A-84֡@A-2a|@A-?|h@A-F
L0@A-F
L0@A-L_@A-IQ@A-\@A-ce@A-m\@A-sg@A-O
@A-U=@A-\(@A-
qv@A-S@A-ᰉ@A-oiDg@A.4K@A.Ov_@A.!R<@A.($x@A.5?|@A.;5X@A.H@A.fffff@A.}Vl@A.}Vl@A.qi@A.2X@A.@A.Ϫ͟@A.+@A.x@A/ hۋ@A/$tS@A/'/W@A/>6z@A/E84@A/KƧ@A/y@A/v_ح@A/4m@A/{J#:@A/{J#:@A/	@A/-V@A/͞@A/͞@A/-V@A/	k@A/?@A//V@A/vȴ9@A/K]d@A/o @A/fA@A/@A/Vϫ@A0     @A0
qu@A0 ě@A073@A0H@A0U2a|@A0[6@A0l"h	@A0_F@A0u!@A0|@A0|@A0@A0U@A0{@A0ѷX@A0҈p@A0@A0@A0{@A1 ѷ@A1_p@A1*0U2a@A17KƧ@A1:S@A17KƧ@A1Gz@A1Dg8~@A1TɅo@A1rGE8@A17Kƨ@A1o@A1@A1@A1u@A1(@A1'RTa@A1l@A1(@A1X@A1B@A12W@A1_o@A1ԕ*@A1R@A1s@A1-@A2s@A2e+@A2#9@A2#9@A2&IR@A26C@A2)y@A26C@A2=p
@A2M@A2W'@A2^5?|@A2d7@A2xl"h
@A2u%F
@A2~"@A2S&@A2ᰊ@A2S&@A2<64@A2)_@A2ڹY@A2`A@A2,<@A2ڹY@A2G{@A2m@A2m\@A3'/@A3"`B@A3,zxl@A3/V@A3C%@A3MjO@A3P{@A3S@A3a@N@A3g	l      @A3A@A3wk@A3ݗ+k@A3lC@A3lC@A3C]@A4n.@A4!-w2@A49XbN@A4Fs@A4PH@A4j~#@A4m8@A4tSM@A4~($x@A4?@A4?@A4o h@A4?@A4C@A4~($x@A4qj@A4N;@A4S@A41&@A4j~@A4?@A4?@A4Ʌoi@A4Z@A4Z@A4@A4Z@A4!-w@A4>@A5'0@A5[@A5!.H@A5(@A5(@A5%F
L@A5B@A5?|h@A5B@A5B@A5O;dZ@A5O;dZ@A5Vl!@A5\@A5Vl!@A5ce@A5fA@A5p
=@A5}H@A5m\@A5sg@A5+j@A5=K@A5U=@A5sh@A5@A5H˒@A5Ϫ͞@A5S@A5oiDg@A6 ѷY@A6t@A6u@A6.2@A6H@A6L/{J@A6R<6@A6_ح@A6l!-@A6z@A6$t@A6-@A6}Vl@A6ߤ?@A6ȴ9X@A6]cf@A6C-@A6"@A7
M;@A7,@A7$tS@A7.H@A71@A7;dZ@A7O
M@A7_o@A7eں@A7sPH@A7&@A7	@A7	@A7-V@A7-V@A7-V@A7/V@A7@A7@A7+@A7fA@A7حV@A7fA@A7rG@A7-@A7+j@A8F]d@A8}H@A8}H@A84m9@A81&x@A8-
q@A81&x@A873@A8A7K@A8NU@A8Q@A8_F@A8oiDg8@A8oiDg8@A8|@A8˒:*@A8IQ@A8@A89Xb@A8
(@A8ěT@A8@@A8ѷX@A8@A8҈p@A8@A9 ѷ@A9 ѷ@A9$/@A8$tT@A9@N@A9 [7@A90
)@A94J@A9:S@A9N;5@A9^@A9Q@A9^@A9k~(@A9u!S@A9x@A9oiD@A9b}@A9~($@A9@A9@A9@A9u@A9(@A9@A9y@A9y@A9_o@A9ԕ*@A9@A9"`@A9e@A9lD@A:n@A:I^5@A:e+@A:3@A:=p
@A:@4n@A:C\@A:T`d@A:^5?|@A:qiC@A:@4@A:~"@A:ݘ@A:p:@A:L_@A:0
@A:L/{@A: ě@A:n@A:@A:ڹY@A:ڹY@A:D@A:m@A:D@A:m\@A;I^@A;S&@A;҉@A;҉@A;"`B@A;"`B@A;&@A;)^	@A;33333@A;@N@A;J#9@A;MjO@A;W>6z@A;]cA@A;g	l@A;n.3@A;xF]@A;xF]@A;Q@A;Mj@A;q@A;q@A;$@A;S@A;m]@A;m]@A;@A;~($@A;Ƨ@A;Q@A;ݗ+k@A;ݗ+k@A;lC@A;$@A;@A;@A;s@A<n.@A;s@A<1&y@A<J@A<ߤ@@A<@A<tj@A</{J#@A<<쿱@A<64@A<<쿱@A<Fs@A<C,zx@A<VϪ@A<cA \@A<j~#@A<wkP@A<C@A<?@A<N;@A<_@A<쿱[@A<TɆ@A<쿱[@A<O
M@A<?@A<#x@A<j~@A<@A<@A<Z@A<>B[@A</@A<Z@A<!-w@A<!-w@A<e@A<E@A<E@A='0@A=+a@A=+a@A=/w@A=84֡@A=IQ@A=S&@A=Y|@A=jOv@A=jOv@A=sg@A=zxl"h@A=$/@A=ڹZ@A=!R@A=hr!@A=v@A=%@A=Xy=@A=cA @A=8Y@A=cA @A=
qv@A=,=@A=(@A=!.@A>t@A>
(@A>4K@A>u@A>.2@A>1.@A>?@A>E@A>E@A>L/{J@A>R<6@A>c	@A>fffff@A>l!-@A>p:~@A>z@A>z@A>+J@A>qi@A>qi@A>+J@A>qi@A>O;@A>@A>-@A>-@A>-@A>}Vl@A>m\@A>ȴ9X@A>m\@A>t@A>t@A>+@A>+@A>Ϫ͟@A>+@A>ߤ?@A>x@A>"@A?Ft@A?)^@A?'/W@A?'/W@A?+I@A?+I@A?+I@A?4֡a@A?8}H@A?;dZ@A?E84@A?H˒:@A?O
M@A?U=@A?_o@A?RT`e@A?\(@A?eں@A?y@A?kP@A?	k@A?	k@A?	k@A?&@A?͞@A?vȴ9@A?@A?@A?˒:)@A?@A?@A?حV@A?@A?Vϫ@A?+j@A?#@A@F]d@A@F]d@A@	ԕ+@A@bM@A@ ě@A@'RT`@A@'RT`@A@4m9@A@4m9@A@4m9@A@:~ @A@K]c@A@H@A@Xy=@A@_F@A@_F@A@eO@A@bM@A@_F@A@hۋq@A@r Ĝ@A@oiDg8@A@u!@A@˒:*@A@YJ@A@@A@IQ@A@
(@A@9Xb@A@4m@A@)@A@
(@A@ěT@A@ѷX@A@D@A@`A7@A@e+@A@C@A@{@A@\)@A@\)@A@$tT@AA$/@AA	k~@AA+@AA [7@AA#w@AA0
)@AA0
)@AA4J@AA4J@AA4J@AA4J@AA=b@AA4J@AA4J@AAA [@AAJE@AAe+a@AArGE8@AAb}@AAR<6@AAR<6@AA'RTa@AAB@AA|@AA|@AA|@AA@AA@AAD@AA2W@AA_o@AAN;6@AA@AAᰉ'@AA@AAR@AAR@AAR@AAY}@AA.H@AA-@ABn@ABOv`@ABs@ABe+@AB䎊@AB䎊@ABe+@AB䎊@AB#9@AB&IR@AB-V@AB6C@ABGE85@ABW'@ABQ_@ABZc@ABa|Q@ABd7@AB@4@AB@4@AB@4@ABݘ@ABS&@AB>B@ABg	@AB<64@AB͞&@AB`A@AB͞&@ABsP@ABڹY@ABG{@ABG{@ABsP@ABڹY@ABG{@AB䎊q@ABfB@ABfB@ABC,@ACS&@ACs@ACC,z@AC&@AC&@AC,zxl@AC33333@AC)^	@AC/V@AC6z@AC6z@AC=K^@ACF]c@ACW>6z@ACS@ACdZ@ACdZ@ACqu!@ACqu!@AC@ACq@ACߤ@ACU=@ACwk@AC*0U2@AC*0U2@ACE@ACm]@ACZ@AC~($@ACa@O@AC@AC|@ACQ@AC҈@ACQ@ACݗ+k@AC%2@AClC@AC@AC$@AC@ACs@AC\N@ADn.@ADn.@ADߤ@@AD@ADtj@ADQ@AD!-w2@AD"h	ԕ@AD"h	ԕ@AD2W@AD9XbN@AD9XbN@AD9XbN@AD<쿱@AD<쿱@AD<쿱@ADI^5?@ADg8}@ADq@AD~($x@ADo h@ADN;@AD*1@ADC@AD*1@AD_@ADS@AD쿱[@AD1&@AD@AD?@ADj~@ADɅoi@ADZ@ADJM      @AD!-w@AD>@ADe@AEK]@AE'0@AEu@AE*0@AEQ@AE!.H@AE<64@AE2a|@AE/w@AE5Xy>@AE84֡@AE?|h@AEB@AEF
L0@AEIQ@AEL_@AEO;dZ@AEY|@AEce@AEm\@AEm\@AEp
=@AEjOv@AEsg@AEݗ@AE!R@AE=K@AEv@AEXy=@AE-V@AE-V@AEH˒@AE@AE8YK@AE
qv@AES@AEᰉ@AEoiDg@AE!.@AF ѷY@AF
L/@AF
L/@AF!R<@AF($x@AF($x@AF+jg@AF1.@AF8YJ@AFE@AFL/{J@AFYJ@AFR<6@AF\N<@AF_ح@AFiB@AFvȴ9X@AF%@AFFs@AFO;@AF,<@AFaf@AF@AF@AF6z@AFQ      @AF&I@AFȴ9X@AF҈p;@AF]cf@AFx@AF@AFFs@AF"@AG hۋ@AF"@AG
=p@AG,@AGv@AG!-w1@AG1@AG4֡a@AG;dZ@AGE84@AGAs@AGE84@AGKƧ@AGKƧ@AGE84@AGRT`e@AGXe,@AG_o@AGeں@AGv_ح@AGy@AG&@AGݗ+@AG@AG-V@AG$tS@AG	k@AG͞@AG3@AG/V@AG˒:)@AG@AG+@AG@AGحV@AG@AG-@AG䎊r@AGrGE9@AHF]d@AG+j@AH	ԕ+@AH*0U@AHF]d@AHbM@AH}H@AH}H@AH*0@AH-
q@AH1&x@AH1&x@AH-
q@AH:~ @AH>BZc@AH:~ @AH>BZc@AHD*@AHK]c@AHNU@AH_F@AHbM@AHhۋq@AHoiDg8@AHu!@AHn@AHYJ@AH@AH@AHIQ@AH
=q@AH
=q@AHU@AHU@AH)@AHTɅ@AH@@AH)^@AHѷX@AHe+@AH`A7@AH@AH4֡b@AH4֡b@AH	k@AH$tT@AH$tT@AI ѷ@AI$/@AI	k~@AI@AI@N@AI@AI#w@AI [7@AI#w@AI-w1@AI0
)@AI0
)@AI0
)@AI7KƧ@AI:S@AIA [@AIJE@AIJE@AIXbM@AI[W>6@AIhr @AIo hی@AIk~(@AIo hی@AIo hی@AI|Q@AIx@AI|Q@AI@AI@AIo@AIR<6@AI@AI@AI'RTa@AI(@AIl@AIB@AI'R@AI@AIy@AI_o@AI_o@AI_o@AIԕ*@AIN;6@AIo@AI@AIᰉ'@AI@AIe@AI>BZ@AIs@AI>BZ@AIs@AI.H@AJn@AI.H@AJI^5@AJOv`@AJ䎊@AJ#9@AJ)y@AJ0U2a|@AJ:)y@AJC\@AJ=p
@AJ6C@AJ=p
@AJ=p
@AJC\@AJJL@AJT`d@AJW'@AJa|Q@AJd7@AJd7@AJh	ԕ@AJ^5?|@AJd7@AJh	ԕ@AJu%F
@AJp:@AJ{m@AJ{m@AJ~"@AJݘ@AJp:@AJS&@AJS&@AJvȴ@AJ>B@AJvȴ@AJvȴ@AJS&@AJ@AJ@AJ@AJ}Vm@AJ}Vm                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @r     @rfffff@rfffff@r@r     @r@r@r@rfffff@r@r33333@r     @rfffff@r@r     @rfffff@r33333@rfffff@r     @r33333@r     @r33333@rfffff@r33333@r33333@r     @rfffff@r33333@r33333@r@r@r@r@rfffff@r33333@rfffff@rfffff@r@r@r@r@r@r@rfffff@r33333@rfffff@rfffff@rfffff@r33333@r33333@r     @r@r@rfffff@rfffff@r     @r@rfffff@rfffff@rfffff@r33333@rfffff@r     @r@r33333@r33333@r33333@r33333@rfffff@r     @r     @r@rfffff@r     @r33333@r@r@rfffff@r@r@r@r     @r@r@r@r33333@r33333@r33333@r@r@r@r33333@r     @r@r@r     @r     @r     @r@r@rfffff@r     @r@r33333@r33333@r     @r@r     @r     @r@r33333@r@r|@r|@r|@r      @q4@p@mfffff@k@kc33333@k`     @kc33333@kFfffff@kC33333@k@j@j33333@j|@j	@ivfffff@i@h@hS33333@hP     @hY@hp     @h@h@h9@g     @hfffff@h@i33333@i&fffff@i#33333@i#33333@i@h33333@hٙ@hfffff@h`     @h6fffff@g     @g33333@g@g@g@g`     @f@f@efffff@e@efffff@f     @f     @eə@effffff@d     @dy@c@c33333@c33333@c     @c陙@c@c33333@c@c     @cfffff@c     @cٙ@c@cvfffff@c\@cL@c@     @c<@cC33333@cC33333@c,@c#33333@c6fffff@c)@c      @bfffff@bfffff@b@b33333@b33333@by@bY@bY@bY@bS33333@b0     @b@bfffff@afffff@a     @a33333@a33333@a@     @`fffff@`33333@`fffff@a)@aC33333@a      @`      @_@_@`)@`@     @`333333@`@_@_33333@`fffff@`     @`#33333@`I@`i@`ffffff@`     @_     @_Ffffff@_333333@^33333@]@]33333@]ffffff@]&fffff@\@\     @\fffff@\@\fffff@\33333@\l@\Ffffff@\@[fffff@[@[@[l@[Y@[@     @[,@[@[      @Z@Zfffff@Z@Zy@Z33333@Zffffff@Z33333@Zfffff@Zfffff@Z      @Yfffff@Y@Y     @YS33333@Y,@Y@X@Xٙ@X     @X@Xs33333@X`     @X      @W33333@W@W     @WS33333@WFfffff@WY@WFfffff@W      @W      @Vfffff@V     @V33333@Vfffff@Vffffff@V9@V33333@V@U     @Us33333@U,@Ufffff@T33333@Tٙ@Tٙ@Tfffff@T33333@Tffffff@TY@TY@T@     @T&fffff@T&fffff@T,@T,@T9@T&fffff@T@S@Sٙ@S     @Sfffff@S@Sfffff@S33333@S     @S33333@S     @Sffffff@S`     @S`     @S`     @SFfffff@S@R@R@R@Rfffff@R33333@R@Rs33333@R33333@Q33333@QL@Q,@Q@Q33333@Q      @Q      @P@Q      @P@Pfffff@Pfffff@P33333@P33333@P@P@P@P@Ps33333@Pl@PY@P,@P@O@O@P      @O     @O     @OL@O      @N     @NL@N333333@N@M     @M@     @M@     @M&fffff@M@M      @M@M@Lfffff@Lٙ@L@L@LL@L@Kٙ@Kfffff@KY@K333333@K&fffff@K@J33333@J     @Jfffff@J@Jffffff@J@     @I33333@I     @I@I@I@Is33333@IY@Is33333@Iffffff@IL@I&fffff@H33333@H@Hٙ@H@H@H333333@H@Gfffff@Gfffff@G     @G33333@Gٙ@G33333@G     @GL@GL@G@     @F@F@F@FL@F333333@F      @E@E@Efffff@E@E     @EL@D33333@Dfffff@D@Dfffff@D@D33333@D@DL@D333333@C@CY@C      @B     @B33333@B     @B     @Bffffff@B&fffff@B@A33333@Aٙ@A@A@A@A33333@A@AL@A333333@AY@A@     @A333333@A      @@ٙ@@33333@@33333@@33333@@s33333@@s33333@@&fffff@@&fffff@@@?@?@?@?33333@?     @?L@?333333@?@>fffff@>@>@>@>ffffff@=fffff@=33333@=fffff@=@=     @=@=L@=     @=ffffff@=@=     @=333333@<fffff@<@<ffffff@<ffffff@<333333@;fffff@;@;33333@;ffffff@;     @;fffff@;     @;333333@;333333@;     @;ffffff@;      @:33333@:fffff@:33333@:     @:L@:333333@:      @:@:L@:      @9fffff@9fffff@:@:      @9@9L@9L@9     @9     @9@8fffff@9@8fffff@8@8     @8L@8L@8      @7fffff@8      @7@7@7     @7@7     @7L@7ffffff@7L@7ffffff@7L@7@7@7333333@7      @6fffff@633333@6@6     @6@6@6ffffff@6ffffff@6ffffff@5fffff@6@6333333@6      @6333333@6@6@5fffff@533333@533333@533333@533333@5ffffff@5ffffff@5ffffff@5ffffff@5@5      @5@5      @5      @4fffff@4@4ffffff@433333@4@4     @4L@4ffffff@4ffffff@4ffffff@4ffffff@4333333@3fffff@4333333@4333333@3@3fffff@3fffff@3@333333@3     @3@333333@3     @3     @3@3@333333@3@3     @3ffffff@3@3333333@2fffff@3      @3      @2@2@2@2@2@2@2     @2@2@2@2ffffff@2333333@2     @2ffffff@2ffffff@2@2L@2     @233333@2     @2@2L@2L@2L@2L@2333333@2L@2@2@2L@2333333@2333333@2L@2@2@2@133333@1fffff@2      @2      @2      @1fffff@1@2      @2      @133333@1@1fffff@1@1@1     @1ffffff@1@1     @1     @1333333@1333333@1@0fffff@1@1      @1333333@1      @0@033333@0@0@033333@0@033333@033333@0@0@033333@0ffffff@0@0@0     @0@0     @0L@0ffffff@0ffffff@0333333@0      @0L@0L@0333333@0      @/@0333333@/@0      @0@0@/@/@0@0333333@0ffffff@0     @0L@0     @0     @0ffffff@0333333@0333333@0333333@0@0L@0@0L@0L@0333333@0      @0L@0@0@0      @0@0@/@0333333@0L@0@0@0@/@/@0333333@0@/@/@0      @0      @0      @0@0@0@0      @/@0      @0      @0      @0      @0333333@0333333@0L@0L@0333333@0@/@/@0L@0@0@0@0      @0@0L@0L@0      @0      @0L@0      @0333333@0333333@0      @0      @0333333@0      @0333333@0L@0@0      @0333333@0L@0L@0L@0L@0L@0333333@0@0@0333333@0333333@/@0      @/@0      @/@/@/@/@/ffffff@0      @/ffffff@/@/333333@/@/@/@/@/@/333333@/333333@/ffffff@/@/333333@/333333@.@/333333@/333333@.@/333333@/      @.333333@.ffffff@.@.ffffff@.333333@-@.      @.      @-@-@.      @-@-@-ffffff@-      @,@-333333@-      @-333333@-333333@-      @-333333@-      @-333333@,@-ffffff@-333333@-333333@-      @-      @,@-ffffff@-ffffff@-ffffff@-ffffff@-ffffff@-333333@-ffffff@-333333@-333333@-333333@-333333@-      @-ffffff@-333333@,@,@,@,@-      @,@,@,@-      @,333333@,      @,333333@,ffffff@,ffffff@,ffffff@,@,@-ffffff@-      @,@,@-      @-333333@-333333@,@-      @,@-333333@-333333@-@,ffffff@,ffffff@-333333@-@-ffffff@,@,@,@,ffffff@+@,      @+ffffff@+333333@+@+@+ffffff@+@+@+@+333333@+@+ffffff@+@+@+@+@+@+@+ffffff@+ffffff@+@+ffffff@+      @*@+      @+ffffff@*@+      @+@+ffffff@+      @+ffffff@+333333@+333333@+333333@+ffffff@+@+@+ffffff@+@,      @,      @+@,      @+ffffff@+@,ffffff@+@+ffffff@+333333@+333333@+@+@,333333@,@+@,@,      @+@,333333@+@+@+@+@+@+@+@,333333@,      @+@,333333@,333333@,333333@,333333@,ffffff@,@,@-      @-333333@,@-333333@-ffffff@-      @-      @-333333@-@-@-@.      @.      @-@-333333@-ffffff@-@-@.@.333333@.333333@.ffffff@.@/      @/      @/333333@.@/      @/333333@.ffffff@.@.@.@.333333@/      @.@.@.@/      @.@.@.@.@/@.@/333333@.@.@/333333@/      @.      @/      @/333333@.@/333333@/ffffff@.@/      @.333333@-@.@.@.333333@.@.333333@.@.@.333333@.@.@.333333@.333333@.ffffff@.333333@.@.ffffff@.      @-@.ffffff@.@-@-@.333333@-@-@.@-@-ffffff@-@-@.333333@-@-ffffff@-@-@-@-@-@.      @-@-@-@.@.@.@.      @.ffffff@.333333@.333333@.@.ffffff@-@-@.@.@/      @.@.ffffff@.@/ffffff@.@.@.@/333333@/ffffff@/333333@/      @/333333@/333333@/333333@/      @/      @/333333@/@/      @/ffffff@/333333@/333333@/333333@/@.ffffff@.@/ffffff@/ffffff@/      @/@/@/@/333333@/@/ffffff@/ffffff@/@/@/@/@/ffffff@/@/ffffff@/@/@/@/ffffff@/ffffff@/ffffff@/@/333333@/@0L@/@0      @0      @/@0      @/@/@/ffffff@/@/@/ffffff@/@/@/@/@/@/@/@/@/333333@/ffffff@/@0@0333333@0      @/333333@0333333@0333333@/@0ffffff@0      @/@/@0@/@/@0@0L@0333333@0      @0333333@0333333@0ffffff@0333333@0L@0@0     @0333333@0     @0     @033333@0ffffff@0ffffff@0ffffff@0@0@1@0ffffff@033333@033333@0fffff@0@0fffff@033333@0fffff@0fffff@1@0fffff@0fffff@0fffff@1L@1333333@1333333@1@1333333@0fffff@1L@1@1@1L@0@1333333@1333333@1@1ffffff@0fffff@0fffff@033333@1@1@1ffffff@1@1ffffff@1ffffff@1     @1ffffff@1@1ffffff@1     @1@1@133333@1     @2      @1     @133333@1@1@1fffff@2      @2      @133333@1fffff@2333333@2333333@2333333@2@2@1fffff@2      @1@2      @2@2@2      @2333333@2L@2ffffff@2     @2L@2     @2ffffff@2L@2ffffff@2fffff@2@2     @233333@233333@2@2     @233333@233333@2@2     @2@233333@233333@2fffff@233333@233333@2fffff@2fffff@3      @3@3333333@2fffff@3333333@3L@3@3     @3ffffff@3@3     @3@3@3@3@333333@3@3@3@3fffff@4      @333333@3fffff@4@4@4L@4@3fffff@4333333@4     @4L@433333@4@4L@4     @4     @4L@4ffffff@4@4fffff@5@5@433333@5@5      @5@4@4fffff@5      @5@4fffff@4fffff@4fffff@5333333@5@5@5333333@5      @5L@5     @5ffffff@5@5333333@5333333@5L@5     @5ffffff@5@5@5     @533333@6      @5@5@5@533333@5fffff@6@6@6@6L@6ffffff@6      @6      @6ffffff@6     @6     @6ffffff@6@6L@7      @6@6fffff@6@6fffff@7333333@6@633333@6fffff@7      @7333333@7333333@7     @7     @7      @7333333@7L@7L@7@7333333@7     @7ffffff@7     @7fffff@7ffffff@7     @7     @7fffff@7fffff@7fffff@8@8@8333333@8L@7@7fffff@8L@8333333@8ffffff@8L@833333@8     @8ffffff@8@8L@8@8fffff@8fffff@8@833333@8fffff@9@9@8fffff@9333333@9333333@8fffff@9L@9333333@9      @9333333@9@9     @9L@9     @9L@9     @933333@9     @9@9fffff@9fffff@9@9fffff@:333333@:L@:333333@:L@:333333@:ffffff@:@9@:333333@;      @:33333@:     @:     @:33333@:@;333333@;      @:fffff@:fffff@;333333@;L@;ffffff@;333333@:fffff@;L@;@;ffffff@;ffffff@;      @;@;     @;     @;L@;     @;@;333333@;@<L@;fffff@;33333@;fffff@<333333@<L@;fffff@<      @<     @<     @<33333@=@<@=L@=      @=333333@<fffff@=333333@=333333@<fffff@=@=      @=333333@=      @=@=     @=@>      @=L@=@=@=     @=33333@>      @>@>      @=@>      @>      @>      @>333333@>33333@>@>333333@>fffff@>33333@>@?      @>@>fffff@?L@>fffff@?333333@?ffffff@?L@?333333@?L@?     @?@?@?@?fffff@@@@      @?@@      @@@?fffff@?fffff@@@@      @@@@&fffff@@333333@@@@&fffff@@@     @@Y@@Y@@Y@@ffffff@@@     @@@     @@L@@s33333@@@@s33333@@@@fffff@@     @@33333@@@@     @@33333@@fffff@@fffff@@@@fffff@@fffff@A      @@33333@@33333      @A333333@A&fffff@A@     @A@     @Affffff@Affffff@As33333@As33333@A@Afffff@Afffff@A33333@A@A     @A     @A@A     @A33333@A@Aٙ@Afffff@Aٙ@A33333@A33333@Afffff@B@A33333@A33333@B@B@B@     @B@B@B@     @Bfffff@BL@Bs33333@B@B@B33333@B     @B33333@Bfffff@B33333@C      @Bfffff@B33333@B33333@B33333@C      @C      @C@B33333@C333333@C      @C@C@     @CY@Cs33333@C@Cfffff@C     @C33333@C     @Cfffff@C@C@D            @C@Cٙ@Cٙ@D@D&fffff@DY@DY@DY@DL@DY@Dffffff@D@D33333@D@D@D33333@D@D@D@D33333@Dfffff@Dfffff@Dٙ@D     @E@E@     @E@E333333@E@E333333@E@     @E@     @E@EY@EY@E@Efffff@E@E@E     @E@E@E@Eٙ@E@F@Efffff@F333333@F@F333333@F@     @F@F@     @Fffffff@FL@FL@FY@F     @FL@F@     @F@     @Fffffff@Fs33333@Fs33333@F     @F@F@F@F33333@Ffffff@Ffffff@F@Ffffff@Fٙ@F33333@G@G333333@GY@G&fffff@G&fffff@Gs33333@G@G333333@G333333@GY@Gs33333@G@Gffffff@GL@G@Gfffff@Gfffff@Gٙ@G@Gٙ@H      @Gٙ@Gٙ@Gٙ@H@H@H&fffff@G33333@G@G33333@H&fffff@H&fffff@HY@H&fffff@HL@Hs33333@Hs33333@HL@H@H     @Hfffff@Hٙ@H33333@H     @H@H@H@Hٙ@H33333@Hٙ@I      @H33333@I@I      @I@I&fffff@I      @I@I&fffff@I&fffff@IL@Iffffff@IY@I     @Is33333@Is33333@IY@Ifffff@I     @Is33333@Is33333@Ifffff@Ifffff@Ifffff@I@I33333@I     @I@I@I33333@I@I     @J      @Ifffff@J@J333333@J@I33333@J&fffff@JY@Jffffff@JL@J@J@     @J@     @JY@JY@J     @Js33333@Js33333@Js33333@Js33333@J     @Jfffff@J     @J@J33333@Jfffff@Jfffff@Jfffff@J@J     @Jٙ@Jfffff@Jfffff@K      @Jٙ@J33333@KY                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ?1&?1&?(\)?E?I^5?? ěT?=p
=?(\)?Z1'?\(?$/?vȴ9X?
=p
?vȴ9X?lC?bM?=p
=?+I?+?ffffff?A7Kƨ?n?tj?$/?nP?vȴ9X?hr!?
=p?S?Vt?A7Kƨ?$/?-V?dZ1?Ƨ-?
=p?ffffff?zG?=p
=?zG?zG?-V?+?|hr?\(?I^5?1&?zG?
=p
?vȴ9?E?r ě?|hr?A7Kƨ?`A7L?ffffff?lC?Vt?S?ffffff?(\)?tj?
=p?tj?QR?M?O;dZ?/w?O;d?-V?ffffff?5?|h?vȴ9X?-?;dZ?;dZ?l?+I?+I^?ffffff?+I^?333333?333333?lC?ȴ9Xb?n?5?|h?E?lC?l?vȴ9X?S?E?tj~?x?n?+I?+?E?lC?-V?Vt?;dZ?n?^5?|?nO?~"?S?$/?;dZ?&x?tj~?Q?O;dZ?$/?I^5??E?p
=q?۶E?(\)?r ě?1&x?-V?tj~?öE?`A7L?lD?`A7L? ěT?lC?A7Kƨ?^5?|?1&?+J?QR?"`B?"`B?+J?
=p
?ȴ9Xb?
=p
?+?QR?E?E?O;dZ?$/?\(?+??|hs?zG{?9XbM?E?tj~?E?E?9XbM?nO;?333333?E?333333? ě? ě?333333? ě? ě?nO;?hr Ĝ?-V? ě?Q?hr Ĝ?333333?hr Ĝ?lD?lD?lD?nO;?-V?&x?Q?lD?lD?Q?333333?nO;?nO;?E?tj~?lD?
=p?-V?`A7L?&x?&x?`A7L?hr Ĝ?bM?`A7L?&x?`A7L?`A7L?
=p?
=p? ěT?`A7L?`A7L?`A7L?vȴ9X?vȴ9X?bM?
=p?;dZ? ěT?
=p?`A7L?
=p?`A7L?bM?&x?hr Ĝ?`A7L?Q?hr Ĝ?
=p?
=p?
=p?bM?bM?vȴ9X?`A7L?`A7L?
=p?vȴ9X?
=p?vȴ9X?&x? ěT? ěT?nO;?&x?bM?
=p?bM?`A7L?`A7L?
=p?bM?
=p?bM?&x?
=p?`A7L? ěT?vȴ9X?bM?vȴ9X? ěT?vȴ9X? ěT? ěT?
=p?`A7L?bM? ěT? ěT? ěT?vȴ9X?bM? ěT?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?lD?&x?bM?;dZ? ěT?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?Q?vȴ9X?;dZ?;dZ?bM?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ? ěT?bM?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X? ěT?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ? ěT?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?hr Ĝ?`A7L? ěT?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?Q?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?Q?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?bM?Q?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ? ěT?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?Q?vȴ9X?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?Q?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X? ěT?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ? ěT?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?Q?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?
=p?vȴ9X?;dZ? ěT?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?Q?vȴ9X?;dZ?;dZ?Q?vȴ9X?Q?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?vȴ9X?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?Q?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?vȴ9X?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?5?|h?Q?;dZ?vȴ9X?;dZ?Q?Q?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?Q?Q?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?Q?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?vȴ9X?;dZ?Q?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?Q?vȴ9X?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?Q?;dZ?Q?Q?Q?;dZ?Q?;dZ?5?|h?;dZ?Q?Q?Q?Q?;dZ?Q?Q?;dZ?;dZ?Q?Q?Q?Q?;dZ?Q?;dZ?Q?;dZ?Q?;dZ?Q?Q?;dZ?Q? ěT?;dZ?Q?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?Q?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?vȴ9X?;dZ?Q?Q?;dZ?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?;dZ?;dZ?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?;dZ?Q?5?|h?;dZ?Q?Q?Q?Q?;dZ?vȴ9X?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?5?|h?Q?Q?;dZ?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?;dZ?Q?5?|h?Q?5?|h?Q?Q?Q?;dZ?Q?Q?;dZ?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?5?|h?5?|h?Q?5?|h?Q?Q?5?|h?Q?5?|h?Q?Q?5?|h?Q?Q?5?|h?Q?Q?;dZ?Q?Q?Q?Q?5?|h?;dZ?Q?Q?Q?Q?5?|h?Q?Q?5?|h?5?|h?Q?Q?5?|h?5?|h?Q?5?|h?Q?Q?Q?5?|h?Q?5?|h?Q?5?|h?-V?Q?5?|h?5?|h?5?|h?Q?Q?Q?Q?Q?5?|h?5?|h?Q?5?|h?Q?5?|h?5?|h?5?|h?Q?Q?5?|h?Q?Q?-V?Q?5?|h?-V?5?|h?Q?5?|h?5?|h?Q?5?|h?Q?Q?5?|h?5?|h?Q?Q?5?|h?Q?Q?5?|h?5?|h?Q?Q?Q?Q?Q?Q?Q?5?|h?-V?-V?5?|h?Q?Q?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?-V?-V?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?-V?/v?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?Q?-V?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?/v?-V?5?|h?5?|h?-V?-V?-V?5?|h?5?|h?/v?-V?-V?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?-V?5?|h?5?|h?/v?-V?-V?5?|h?-V?5?|h?5?|h?5?|h?5?|h?Q?5?|h?-V?-V?5?|h?-V?5?|h?-V?/v?5?|h?5?|h?5?|h?-V?-V?-V?/v?-V?-V?-V?1&y?5?|h?5?|h?5?|h?5?|h?5?|h?-V?/v?-V?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?-V?-V?/v?-V?5?|h?5?|h?-V?5?|h?-V?/v?1&y?-V?-V?5?|h?-V?-V?/v?5?|h?5?|h?-V?-V?5?|h?5?|h?-V?-V?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?-V?-V?-V?/v?-V?5?|h?/v?-V?-V?5?|h?-V?-V?-V?-V?/v?/v?-V?-V?/v?-V?/v?5?|h?-V?Q?/v?-V?-V?5?|h?-V?5?|h?5?|h?/v?5?|h?-V?/v?-V?/v?/v?5?|h?-V?/v?-V?5?|h?1&y?/v?5?|h?-V?-V?-V?-V?/v?5?|h?-V?-V?/v?-V?1&y?/v?/v?/v?/v?/v?-V?/v?/v?-V?5?|h?/v?/v?/v?5?|h?-V?/v?/v?/v?-V?/v?/v?/v?/v?1&y?/v?/v?/v?/v?1&y?1&y?1&y?/v?/v?/v?/v?1&y?1&y?-V?1&y?1&y?/v?/v?-V?/v?/v?5?|h?5?|h?-V?/v?1&y?1&y?/v?1&y?/v?/v?1&y?1&y?/v?/v?/v?-V?1&y?/v?1&y?1&y?1&y?/v?1&y?/v?/v?1&y?-V?1&y?/v?1&y?1&y?1&y?/v?/v?/v?-V?1&y?1&y?/v?(\)?/v?1&y?1&y?/v?/v?/v?1&y?1&y?/v?1&y?/v?1&y?1&y?/v?1&y?1&y?/v?/v?/v?1&y?1&y?1&y?1&y?1&y?/v?/v?/v?1&y?/v?1&y?1&y?1&y?1&y?1&y?/v?1&y?1&y?(\)?1&y?1&y?1&y?/v?/v?1&y?1&y?/v?1&y?/v?/v?1&y?1&y?1&y?1&y?(\)?/v?-V?-V?/v?/v?1&y?(\)?(\)?1&y?1&y?1&y?/v?/v?1&y?1&y?/v?1&y?1&y?(\)?1&y?1&y?1&y?1&y?1&y?1&y?/v?1&y?1&y?1&y?(\)?1&y?1&y?1&y?1&y?1&y?(\)?1&y?1&y?1&y?1&y?(\)?/v?1&y?1&y?(\)?1&y?1&y?(\)?1&y?1&y?(\)?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?(\)?1&y?/v?1&y?(\)?(\)?(\)?(\)?1&y?1&y?(\)?(\)?(\)?(\)?(\)?1&y?(\)?1&y?1&y?1&y?1&y?(\)?1&y?(\)?(\)?(\)?1&y?(\)?(\)?1&y?S?(\)?1&y?1&y?1&y?1&y?1&y?(\)?S?(\)?1&y                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ???                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	P21                                     2                                       )؅BF3