CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20170205   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P19    CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:34.877228Z    ORIGINAL_HEADER      6CTD,20250210CCHSIOWB
#Removed 'CTDFLUOR_TSG' as it's filled with -999
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2017-06-29. CTD data from cruise 18DD20170205, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20170205. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2017-001/index.php. 
#
# The information in this file for the cruise 2017-001 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-0036.ctd
#
# Start of originator file comment header
#
#*2017/06/29 15:26:50.02
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2017/02/10 06:17:38.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 198
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : CE9F1F72
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            0.3            202.1
#       2 Temperature:CTD               deg_C_(ITS90)   5.6248         6.8697
#       3 Salinity:CTD                  PSS-78          32.78          33.8432
#       4 Sigma-t:CTD                   kg/m^3          25.7461        26.7106
#       5 Oxygen:Dissolved:CTD:Volume   ml/l            3.4            6.87
#       6 Oxygen:Dissolved:CTD:Mass     µmol/kg         147.7          299
#       7 Fluorescence:CTD:Seapoint     mg/m^3          0.66E-01       1.162
#       8 PAR:CTD                       µE/m^2/sec      0              0.3
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        7  F       ' '     2
#       6  -99   ' '        6  F       ' '     1
#       7  -99   ' '        8  F       ' '     3
#       8  -99   ' '        7  F       ' '     1
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2017-001
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P21
#    EVENT NUMBER        : 36
#    LATITUDE            :  49  38.00000 N  ! (deg min)
#    LONGITUDE           : 139  39.97000 W  ! (deg min)
#    WATER DEPTH         : 3961
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    The descent rate of the CTD was very noisy with some complete reversals
#	of direction.
#    CTDEDIT was used to remove many records corrupted by shed wakes;
#	salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Fluorescence and PAR data are nominal and unedited except that some records were
#	removed in editing temperature and salinity and a large spike in
#	fluorescence was removed from file 0032.
#
#    The Transmissivity channel was removed because of frequent shifts in values during
#	casts and large variations between values during repeat casts.
#	The data are available, by request, from the chief scientist.
#
#    NOTE: While the Fluorescence:CTD data are expressed in concentration units, they
#	do not always compare well to extracted chlorophyll samples, particularly for
#	casts far from shore. It is recommended that users check extracted chlorophyll
#	values where available.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in Sea-Bird
#	Application Note #64-2, June 2012 revision (Sea-Bird_64-2_Jun2012.pdf), except 
#	that a small offset in the fit was allowed.
#
#    The Dissolved Oxygen sensor used in files 0001, 0002 and 0016 malfunctioned so the 
#	Oxygen:Dissolved:CTD channels were removed from those files.
#
#    The Oxygen:Dissolved:CTD sensor has a fairly long response time so data accuracy 
#	is not as high when it is in motion as it is during stops for bottles. This will be
#	especially true when vertical dissolved oxygen gradients are large. To get an estimate
#	of the accuracy of the Oxygen:Dissolved:CTD data during downcasts (after recalibration)
#	a rough comparison was made between downcast Oxygen:Dissolved:CTD data and upcast 
#	titrated samples. Some of the difference will be due to problems with flushing of 
#	Niskin bottles and/or analysis errors, so the following statement likely underestimates 
#	Oxygen:Dissolved:CTD accuracy.
#
#    Downcast (CTD files) Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.25 ml/l from 0 to 125 dbar.
#	±0.2 ml/l from 125 to 400 dbar.
#	±0.1 ml/l from 400 to 600 dbar.
#	±0.05 ml/l from 600 to 1500 dbar.
#	Low by up to 0.08 ml/l below 1500 dbar.
#
#    For details on the processing see document: 2017-001-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5--- --6-- ---7--- --8---
#!Pressu Temperat Salinity Sigma-t: Oxygen Oxyge Fluores PAR:  
#!re:CTD ure:CTD  :CTD     CTD      :Disso n:Dis cence:  CTD   
#!                                  lved:  solve CTD:          
#!                                  CTD:   d:CTD Seapoin       
#!                                  Volume :Mass t             
#!------ -------- -------- -------- ------ ----- ------- ------
#*END OF HEADER
     WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @M        data_max      @M        C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     8  2   pressure                	long_name         pressure   positive      down   units         decibar    data_min      @    data_max      @\        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      8  k   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      ,  4   temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?8}H   data_max      @p:~   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       8  `   temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      ,     salinity                	long_name         salinity   units         PSS-78     data_min      @@i ѷ   data_max      @AJ`A   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      8  4   salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      , 1   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @-ffffff   data_max      @r33333   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        8 @   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      , x   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?S   data_max      ?5?|h   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      8    CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      ,    PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min                 data_max                 C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       8 Ͱ   PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d      , X   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min               data_max               C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     8    CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d      , M,   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( [X   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( [   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      )   data_max      )   C_format      %10d       [   latitude               	long_name         latitude   units         	degrees_N      data_min      @H ě   data_max      @H ě   C_format      %9.4f          [   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      a5\(   data_max      a5\(   C_format      %9.4f          [   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d        [   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min        0   data_max        0   C_format      %4d        [@M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @M     @ @@@@@      @       @"      @$      @&      @(      @*333333@,      @-@0      @1      @2      @3      @4      @5      @6      @6fffff@8@9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @As33333@B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @F33333@Gs33333@H      @H     @I      @I     @J      @J@K      @K     @L      @L     @L33333@M     @N      @N     @Nٙ@O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Qfffff@R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T,@T@T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X@Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[Ffffff@[y@[@\      @\@     @\     @\     @]      @]Ffffff@]     @]     @^      @^@     @^     @^     @^33333@_`     @_     @_     @`      @`      @`9@``     @`     @`     @`     @`     @a      @a      @a9@a`     @a     @a     @a     @a     @b      @b      @b@     @bc33333@by@b@b     @b     @c      @c      @cFfffff@cS33333@c33333@c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @e33333@e      @e6fffff@effffff@e     @e     @e     @e     @f      @f      @f9@fp     @f|@f     @f     @f     @g      @g      @gC33333@g\@g     @g     @h      @h      @hC33333@h`     @h     @h     @h     @h陙@i      @i      @i@     @i`     @i     @i     @i     @i     @i33333@j#33333@j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @kY@k@k     @k33333@k     @l      @l      @l@     @l`     @l     @lfffff@l@m      @m      @m@     @m     @m     @m     @m     @n      @n      @n@     @n`     @n|@n@n     @n     @o      @o      @o@     @o`     @offfff@o     @o     @p      @p     @p      @p0     @p@     @pL@p\@pvfffff@p~fffff@p     @p     @p     @p     @p     @p     @pfffff@p@q@q$@q0     @q@     @qP     @q`     @qp     @q@q@qfffff@q     @q     @q     @q     @q     @r      @r     @r      @r0     @rC33333@rP     @r`     @rp     @r     @r     @rfffff@rfffff@r     @rљ@r     @rfffff@s      @s     @s      @s)@s@     @sP     @s`     @sp     @s     @s33333@s33333@s     @s     @s     @s     @s     @t      @t     @tfffff@t1@t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t@t     @t     @u      @u     @u      @u0     @u@     @uQ@u`     @us33333@u     @u     @u     @u     @u     @u     @u     @u     @v@v      @v0     @v@     @vP     @v`     @vp     @v~fffff@v     @v     @v     @v     @v     @vᙙ@v     @w@w      @w0     @w@     @wP     @w`     @w     @w     @w     @w@w     @w     @w     @w33333@x      @x     @x      @x0     @x@     @xc33333@xq@x     @x     @x     @x     @x     @x     @x     @x񙙙@y33333@y      @y0     @y@     @yP     @y`     @ynfffff@yfffff@y     @y33333@y     @y     @y     @y     @yfffff@z@z     @z      @z0     @z@     @zQ@zY@zp     @z@z     @z     @z     @z     @z     @z@zfffff@{      @{33333@{#33333@{0     @{@     @{P     @{`     @{p     @{~fffff@{fffff@{     @{     @{     @{     @{񙙙@|      @|     @|      @|0     @|@     @|P     @|[33333@|t@|     @|     @|     @|     @|     @|     @|     @|񙙙@|     @}33333@}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}fffff@~      @~     @~!@~.fffff@~@     @~P     @~`     @~p     @~     @~fffff@~@~     @~     @~     @~     @      @     @      @0     @Ffffff@P     @`     @p     @     @     @     @     @     @ə@fffff@     @      @     @     @     @      @(     @/33333@Bfffff@H     @P     @X     @`     @h     @p     @x     @     @     @33333@@@33333@     @     @     @     @     @fffff@     @     @      @     @     @33333@!@'33333@0     @8     @@     @H     @O33333@`@g33333@p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @fffff@8@@     @H     @P     @X     @`     @e@q@x     @@     @     @     @     @     @     @@33333@     @     @     @     @     @@      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @l     @zfffff@     @     @     @     @     @     @     @@     @     @     @     @     @     @     @fffff@33333@     @     @     @      @(     @0     @;33333@@     @H     @P     @X     @`@h     @p     @x     @     @     @     @@     @     @     @     @     @     @͙@     @     @     @     @     @      @     @     @@@%@0@8     @@     @H     @P     @X     @`     @d@zfffff@     @     @     @     @     @     @     @@     @     @     @     @     @     @     @@@      @(     @0     @8     @@     @H     @Nfffff@bfffff@h     @p     @x     @     @     @     @     @33333@     @     @     @     @     @     @     @     @fffff@     @     @     @      @(     @-@@@H     @P     @X     @`     @h     @p     @x     @     @     @fffff@@     @     @     @@     @     @     @     @     @     @     @@	@     @     @      @(     @0     @8     @@     @H     @O33333@h@p     @x     @     @fffff@     @     @     @     @     @     @     @     @     @      @     @@(@0     @8     @@     @G33333@P@X     @^fffff@p     @x     @     @     @     @     @     @     @     @33333@@     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @w33333@@     @     @     @fffff@fffff@     @     @     @33333@fffff@     @     @     @     @33333@	@     @     @      @'33333@1@8     @@     @H     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @33333@fffff@33333@     @     @     @      @     @     @(     @0     @8     @@     @H     @P     @U@p@x     @     @     @     @     @@     @@     @     @     @     @     @     @@@     @     @     @      @(     @.fffff@8     @P@X     @`     @h     @p     @x     @}@33333@@     @     @     @     @     @     @33333@fffff@     @     @     @     @     @      @     @@     @33333@0     @8     @@     @H     @P     @h@nfffff@zfffff@     @     @     @fffff@33333@     @     @     @     @fffff@     @     @     @     @     @     @      @@@     @      @*fffff@/33333@8     @@     @H     @P     @X     @\@h@p     @x     @     @     @     @@@     @@@     @     @     @     @     @     @@     @	33333@     @     @     @@     @      @"fffff@(@,     @0     @4     @8     @<     @@     @D     @H     @J@Q@T     @X     @\     @`     @d     @f@l     @p     @t     @x     @|     @~     @fffff@     @     @     @     @     @     @fffff@     @     @     @     @     @     @33333@@     @     @33333@     @     @     @     @     @     @33333@fffff@     @@     @     @     @33333@$@(     @,     @0     @4     @8     @:fffff@E33333@H     @L     @P     @T     @W33333@\@`     @d     @hfffff@l     @p     @tfffff@x     @|     @     @fffff@     @     @     @     @     @     @     @     @33333@33333@     @@     @     @     @     @@     @ٙ@     @     @     @     @     @     @33333@fffff@ @     @     @     @     @     @     @     @@.     @0     @4     @8     @<     @?33333@J     @L     @P     @T     @X     @\     @h     @k33333@u33333@x     @|     @     @     @     @@     @     @     @     @     @     @@fffff@     @     @     @     @     @˙@@     @     @     @     @fffff@     @      @     @     @     @fffff@33333@      @$     @(     @+@933333@<     @@     @Bfffff@I33333@L     @P     @T     @X     @\     @`     @d     @ffffff@p     @t     @x     @|     @     @     @@33333@     @     @     @     @     @     @     @33333@     @     @     @33333@@@     @fffff@fffff@     @     @     @     @@@33333@      @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @A33333@D     @H     @L     @P     @T     @X     @\     @`     @c33333@lfffff@p     @t     @x     @|     @     @     @@@     @     @     @     @     @@     @@     @     @     @     @     @fffff@     @     @     @     @33333@     @     @     @     @      @     @     @
@33333@     @     @      @$     @(     @*     @6     @8     @<     @@     @D     @H     @J@T     @V@\@`     @d     @h     @k33333@q@t     @x     @|     @~fffff@fffff@     @fffff@@     @     @     @     @     @     @fffff@     @     @     @     @fffff@     @@     @     @     @33333@癙@     @     @     @     @     @     @     @     @     @@$@(     @,     @0     @4     @8     @E33333@H     @L     @P     @T     @X     @\     @^fffff@e@h     @l     @p     @t     @x     @33333@     @     @     @@fffff@     @     @     @     @     @     @     @     @     @33333@@     @     @     @     @     @     @     @ߙ@陙@     @     @     @33333@@@fffff@     @     @     @     @      @$     @(     @*@8fffff@<     @@     @D     @H     @T@X     @\     @`     @d     @h     @k@t@x     @|     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @fffff@33333@     @     @     @     @     @@     @     @     @     @     @     @     @fffff@33333@     @     @     @     @     @fffff@      @"     @(     @,     @0     @4     @8     @<     @@     @D     @F     @Q33333@T     @X     @\     @`     @d     @ffffff@u33333@x     @|     @     @     @     @@     @     @     @     @@@     @33333@     @     @     @     @33333@     @     @     @     @     @     @     @33333@     @      @     @fffff@fffff@     @     @     @@)@,     @0     @4     @8     @;33333@F     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @r@x@|     @     @     @     @     @     @     @     @33333@     @     @     @     @@     @     @     @     @     @33333@     @     @     @     @     @@33333@     @      @     @     @     @@@     @      @$     @(     @,     @0     @4     @6fffff@@     @D     @H     @L     @P     @T     @X     @Z     @`fffff@b@h     @l     @p     @t     @x     @|     @     @fffff@     @     @     @     @     @     @     @@fffff@     @     @     @     @fffff@͙@     @     @י@@     @     @     @@@      @     @     @     @     @     @     @@)@,     @0     @4     @8     @<     @@     @C@P@T     @X     @\     @`     @c33333@t     @x     @|     @     @     @     @33333@     @     @     @     @     @     @     @     @     @33333@     @     @     @     @ϙ@fffff@     @     @     @     @     @     @     @@@     @     @     @     @     @     @      @$     @(     @*fffff@8     @<     @@     @D     @H     @L     @Nfffff@\fffff@`     @d     @h     @l     @p     @s@@     @     @     @     @@     @     @     @     @     @33333@@     @     @     @     @     @ۙ@fffff@     @     @     @fffff@@     @     @     @     @     @     @      @"fffff@.     @0     @4     @8     @<     @>fffff@H@L     @P     @T     @X     @\     @^fffff@i33333@l     @p     @s33333@|     @     @     @     @     @@33333@     @     @     @     @     @     @33333@fffff@     @     @     @     @     @33333@fffff@     @     @     @     @     @     @@      @     @     @     @33333@33333@     @      @$     @(     @,     @.fffff@933333@<     @@     @E33333@H     @Lfffff@Nfffff@U@X     @\     @`     @d     @f@lfffff@p     @r@y@|     @     @     @     @     @     @     @     @     @fffff@33333@     @     @     @     @33333@ř@     @˙@ՙ@     @     @     @     @     @@33333@     @     @      @     @fffff@fffff@33333@     @     @     @      @$     @(     @*@533333@8     @<     @@     @D     @G33333@Tfffff@X     @\                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          @K]c@1&x@,zxl@,zxl@@C@[W>@hۋq@hۋq@NU@NU@     @     @@@     @6@6@n@s@@©@hۋq@hۋq@7Kƨ@{J#9@Q@*0@āo h@{J#9@@ěS@@7Kƨ@7Kƨ@@F]c@,zxl@74@{J#9@\N@tj@@{J#9@\(@nP@74@©@u%F
@o hی@o hی@@n.@4m9@NU@n@s@g8}@{J#9@©@n@ߤ?@ߤ?@IQ@:S@ [7@I^5@Zc@s@&IR@I^5@\(@u%F
@6@$tS@($x@hr@?@ڹZ@@lC@쿱[@@b}V@PH@S&@5Xy@?@j~#@쿱[@<64@p
=@b@($x@($x@\N<@6z@m\@|hs@4m9@$/@@a@N@84֡@8YK@oiDg@żn/@)^@Ǔݗ+@xF]@ϐ@@*0@ᰉ'R@iDg8@ݗ@C$@E@p:@M(@	@84֡@bM@L/{J@S&@	'RTa@	ԕ*@p:~@
%@l@㢜wk@>@@rGE9@ΤT@!R<@xF]@ěS@-
@ۋq
@#9@glC@DM:@49XbN@,q@6z@Z@n.@G{@'RT@d8@TɅo@bM@TE@<Q@,[W?@&A@
5Xy>@BZc @+jg@唯O
@6@+j@L_@(@'RT@C,z@U=@:@vFs@P|@H˒:*@D2W@&x@*0@A [@[6@iB@0
)@Z@$tS@$xG@[@p:~@~($x@=Vl!@1l@+jf@%S@p:@!.@8YJ@ө*0U2@n@ѷX@C@W>6z@H@As@|#x@dTɆ@OAs@Iԕ*@D?@Z@~($@ۋq
@'RT`@Zc@@N@=K@4m9@m(@aGz@OAs@+U=@Ov_@2W@o@@+I@a@N@S&@TɅ@x)@l>B[@bwkQ@^ ѷY@T,<@1&x@JE@&I@dZ@O;@x@	k@TɆ@ᰉ'R@,<@C%@)y@'RT@7@cA @%@N_o @<n.@%F
L0@sPH@'/W@tj@@ӎMj@/V@
=p@%@^5?}@Zc@|쿱[@x}H@pD@f'@YJE@JD@F?@7+@@:S@g	@eO@u@a@O@Q@tj@D@m8@-@ᰉ'@'RT`@v_ح@Q@?@~\N<@`A7K@TFs@HeO@4!-w2@@@N@
O;dZ@C%@Z@tSM@>6z@䎊@@&I@v@?@g	l@y@M@(\@Ʌoi@-
q@#9@y"`@pD@a@N@YJE@U*0@MO;dZ@Eݗ@@hۋq@9rGE8@..2@$qj@u@qu!@vȴ@y=c@ᰉ@*0U@	@o h@$@ C@K]@D@sg@[W>6@"h	ԕ@*0U2a@3@}H@ؓtj@҉@O;dZ@)^@K]@rG@E@a|Q@@@ڹ@h	ԕ@e@A7K@1&@6C@Ov_@%@|64@v+jg@tj~@p
=q@nO;@o hۋ@h	ԕ+@a|Q@ZQ_@UL_@S@Sa@O@Oo @L@Np:~@L/{J#@JqiC@H˒:*@MO;dZ@P{@C$@?[W>@:xl"h
@2m\@+I^@?@C,zxl@<Q@:>B@4J@-\@-
qv@+Q@$7@6@*0@ᰉ@}H@N;@*0@zG@H@
qu"@_@9Xb@-@.H@4֡b@j~@O;@C]@0
@0U2a|@@	ԕ+@`A7L@tSM@C,@;dZ@$@ٙ@bM@a@O@'/W@xF]@k~(@C@m]@^5?|@3@?@m8@{m@iB@o@VϪ@lC@8}H@@fffff@A [@.H@A7K@(\@Q@Q@_F@Ov_@@&@Ov_@&@:)y@$tT@H@ߤ?@_@q@K]c@JM@@4n@.H@|쿱[@{dZ@{J#9@zS&@v!.I@r䎊q@q&x@p'RT@oiDg8@nO;@kC,z@h\)@h@hr Ĝ@fIQ@cwk@ae@_حV@^쿱[W@^҈p;@^%@\u"@\]ce@ZQ_@ZQ_@Zݘ@ZkP|@Zu%F@Ye+a@YJE@W&@T*1@RT`d@MO;dZ@KxF]@I^5?}@H9Xb@Gݗ+@F@Em\@EoiDg@B\(@>6z@<Z@;lC@;5Xy@9XbM@71@6E@4m8@1[W>6@,[W?@)x@&A@$%1@#S&@"C,@"wkQ@!o@ A7K@
=p@@
=p@2a|@@@@Fs@`d@:)y@;dZ@T@@_@]cA@	ԕ*@@,zxl@$/@lC@>B@1@g	@u!@ٳ|@*0U@@Õ$@/V@z@ ě@1@S&@	k@+J@*0U2@=p
@@M:@tSMj@m\@m\@o4֡a@o hۋ@rs@v+jg@u%F
L@qiB@gfA@cZ@dZ1@]+j@Vt@L@N;5X@J#9@E8YK@As@=<64@;A@8YJ@5?@4m8@0
(@/{J#:@.1@,q@*0
@)*0U2a@%1@!ae@kP|@Ov_@҉@hr @rGE9@@	'RTa@1&x@&I@JM@%2@$/@\N<@PH@-
@@"h	ԕ@ᰉ'@,<@	@d8@iB@ܑN;@ܑN;@"`B@حU@m@As@]cA@@]cf@4m@-V@-@U=@)^@҈@7KƧ@u%F@&I@oiDg@ ѷ@~($x@yrGE8@x-
@u\(@qiB@o-V@g8}H@]+j@Y+@U2a|@P|@L_@J#9@?H˒:@8}H@3g	l@2a|Q@,zxl"@'RT`e@$/@$tSM@ 	k@%u@"h	ԕ@+j@@n/@ IQ@
G{@
Y|@
iDg8@
 hۋ@
@4@
ޞ@
]ce@
$@
1'@
@
2a|@
a@O@
,<@
m@
W'@
4m@
ߤ@
@
-w1@
ߤ@@
Xe,@
@
@
|PH@
y	k~@
t!-w2@
p
=q@
l!-w@
j~"@
c	@
ZQ_@
VϪ͟@
WsPH@
W&@
OAs@
N;5X@
N_o @
MjOv@
L@
Jn@
F?@
D*0@
Ca@N@
A [7@
;A@
2W@
($xG@
!-w1@
0
)@
Fs@
@
o h@
@=b@%F
L@ hۋ@Q@%1@ԕ*1@#9@m\@74@vȴ9X@b@v@/V@n.3@[@vȴ@tj@rGE9@JM@@zC\@qiB@l[W?@iᰉ'@]+j@ZY@V8YJ@S&@RT`d@RT`d@PH@N;5X@K:)z@F?@>vȴ9X@:^5?|@1o@)^@)*0U2a@zG@4J@I^5?@Fs@-
@"h	ԕ@(\@E@m@R@;dZ@;5X@2W@C@6z@64@D@?|h@'RT`@@qiC@&I@o h@ ѷ@~m\@y(@wkP@v+jg@sg@weں@v!.I@rs@]cA @P*0U@IoiD@BZc@Em\@Ca@N@7Xe@1-@(TɅ@!-w1@S@+j@@o h@ ѷX@n.@YJ@YJ@
xl"h
@
F]d@
Fs@
:~ @
@N@
Ϫ͞@
`A7@
̘_@
K]c@
74@
b@
#w@
4K@
|@
{@
<쿱@
/V@
tSM@

=p@
h	ԕ@
,=@
N;6@
qiC@
I^5@
zxl"h
@
w+@
qiB@
mhr!@
jOv`@
h	ԕ+@
Xe+@
Q@
P`A7@
PH@
KƧ@
H9Xb@
K:)z@
C$@
:^5?|@
8Q@
5sg@
2a|Q@
.1@
*0
@
'/V@
$?@
qu!@
!R<@
ݗ@
      @	.H@	Vl!@	?@	E@	Q@	ۋq
@	fA@	+a@	ⶮ}Vm@	ᰉ'R@	ce@	b}@	8YJ@	т@	ɺ^5?}@	84֡@	\(@	H˒:@	|hs@	Q@	B@	/V@	n.3@	䎊r@	Q@	@@	Q@	Ov_خ@	,=@	1&@	-
q@	7KƧ@	&I@	n/@	o hی@	{m]@	v+jg@	p
=q@	kQ@	h@	glC@	g@	cA [@	UfA@	L@	F]cf@	E@	C@	As@	@n@	@n@	?H˒:@	;dZ@	8Q@	64K@	0{@	&'@	!-w1@	IQ@	u@	=K^@	PH@	Mj@	%2@Q@{m@	ԕ+@eO@e+@@4@e+@e@Gz@@N@حV@ݗ+j@ڹY@b}@D*@#9@~($@3@zxl"@
=p@ae@zG@bM@~($x@xF]@ԕ*@oiDg@ݗ@?@u%F
@.H@|PH@yrGE8@x-
@zC\@y	k~@u!R@mhr!@kP{@irGE@eO
@_;dZ@[W>6z@["`B@Xy=c@VϪ͟@T`d@Rm@Q@Ov_ح@MjOv@JL_@J#9@H˒:*@E84֡@B74@A7Kƨ@?@=v@;dZ@:S&@9XbM@5?@2m\@12W@0 ě@(\)@!ae@Q@o @p:@"@MjO@(@P{@g	@B@rGE@rGE@r Ĝ@@e+@(\@+@Ϫ͞@E@,<@䎊@ΤT@ɺ^5?}@y@@K]@?|h@33333@a|Q@o@-V@o@x@xF@䎊r@u%F@@1&x@     @wkP@o4֡a@kP{@hۋq
@g8}H@e+a@ae@_o@]/w@\(\@ZY@S@M5Xy>@F]cf@As@?H˒:@<64@:)y@:)_@8}H@7rG@3g	l@+I^@)y@(Xy=@(\)@(@(\)@(\)@'RT`e@&@%S@%F
L0@#9@"h	ԕ@U=@C,zx@=K^@kP|@u%F@tj@$/@xF]@eO@n/@$t@xl"h
@g@hr!@ߤ?@iB@ݗ+j@"`B@@ΤT@s@#9@@8YK@\(@n@v@쿱[@KƧ@{@͞&@1@xF@`A@[6@u@Ov_@\(@+I@:S@}!.H@|PH@vȴ9X@qiB@mhr!@jJL@ffffff@d7@Vaf@Rm@SZ@I^5?}@C$@@n@?H˒:@9~($@8)@)*0U2a@!o@C,zx@kP|@+J@bM@'/W@I^5?@xF]@	ԕ*@	 ѷ@S&@hr@J#9@%F
L@u!S@.2@C@	ԕ+@ڹ@/w@b}@>6z@ҽ<64@͞%@]cA@E84@a@N@6@dZ@m8@U=@^@1@zxl"h@u@F
L0@zxl"h@S&@@+J@$/@O
M@zG@*0U2@rGE9@I^5?@q@C%@ԕ*@_o@~\N<@{J#9@y"`@x73@v!.I@u%F
L@sPH@qiB@l[W?@iDg8~@irGE@iDg8~@g	k@f,<@f1.@be+@aGz@\?@Zݘ@Y|@VϪ͟@UfA@S@L/{J#@IQ@@C@=b@;A@9D@7rG@2ᰊ@-
qv@,<쿱@,<쿱@)y@'&@&L/{J@$TɆ@Xe,@@	ԕ*@+I@+I@n/@@\N<@@rGE8@@@,<@%1@ᰉ'R@o@Q_@Ϫ͟@R@As@v_ح@As@;5X@y@m\@š@6@Y}@z@E@9XbN@W@-@L/{J@-w1@	@}H@Q@vȴ@*0@-
q@!R<@@I^5?@L_@L_@҈@xF]@'/@C%@p:@@JM@~"@}E@xl"h	@t!-w2@rs@q@o@nt@l"h	ԕ@iB@fA@b}Vm@^ ѷY@\]ce@^iB@Yb}@Vt@T`d@Sa@O@S&@N_o @MjOv@H˒:*@C@?@<n.@9~($@7KƧ@6E@6E@6z@5Xy=@/v@(\)@%F
L0@!ae@ -
@-V@vȴ@tj@Xe,@sP@	ԕ*@s@C\@P{@@ⶮ}Vm@iB@ܑN;@څݘ@>BZ@,<@
M;@D@E84@š@š@2W@a@N@TɅo@@v@쿱[@64@A@BZc @j~#@D@KƧ@J@{J#:@\)@&@-@TɅ@*0U2a@TɆ@vȴ9@Q@tj@O;d@ᰉ@@҉@tj~@O
M@tj~@zG@~($x@M:@b}V@~\N<@}ڹZ@|hr@y(@y(@}ڹZ@|Q@zxl"h
@u\(@t!-w2@q@oiDg8@oiDg8@oiDg8@o-V@o-V@o hۋ@m(@iDg8~@f,<@d%1@^iB@\?@\]ce@Zc	@Y|@V8YJ@Sa@O@P*0U@NT@MjOv@K]cA@G@@E8YK@@n@<쿱[@7KƧ@4m8@2-V@/O
M@-
qv@(@%S@%@[@u%@u%F@*0@N;6@rGE9@!R<@@L_@eO@tj@$/@.H@H˒@J#9@"h	ԕ@JL@ڹ@%1@eO@	@C,@eO@ޞ@1'@
=p@t@ԕ*1@Ʌoi@&@R@`A7@jOv@̘_@cA \@/{J#@ʌL_@Q@
L/@ߤ?@쿱[@)_@D@YJ@rG@4m@?|h@33333@{@U=@U=@d7@/V@F
L0@ěT@%@6C@PH@O;d@Ov_@+J@0
)@(@.H@|?@|PH@{~$@sg@m\@iDg8~@hr Ĝ@h	ԕ+@eڹ@cS@a|Q@^iB@\>@Zݘ@XD*@V8YJ@Rm@OAs@KƧ@IoiD@G)^@C@@n@=<64@:^5?|@6}Vl@3|@1[W>6@.}Vl@,>B[@+6z@($xG@'RT`e@%zxl"h@ [6@Ov_خ@1&@u%F@sh@sP@hr @!R<@I^5?@~($x@@C%@+I@$/@F]c@ ѷX@Vl!@~$@@+@!.@@:~ @P{@g	@rGE@	@حV@>@څݘ@l!-@ѷX@|@+@;5X@̘_@ɅoiD@@@
L/@\N@Õ$@C@[W>@BZc @@<64@D@Q@}H@z@3@{@q@@u@xF@1@vȴ9@1&@e+a@L_@N;6@Mj@M:@ڹY@p:@K]d@#@u%F
@~m\@}ڹZ@{lC@z>B@xF@weں@pD@p:~ @p@m8Y@l"h	ԕ@lVϪ@gfA@f,<@eڹ@dZ1@`d8@^҈p;@\(\@[q@Y|@UϪ͞@T`d@S&@RT`d@O;dZ@M5Xy>@K:)z@J#9@H9Xb@A [7@?H˒:@=<64@<Z@<n.@;dZ@:)_@9Y}@4J@1o@/Vϫ@.}Vl@,zxl"@*0U2a|@#S&@U=@IQ@qu!@@ݗ+k@!R<@p:@S&@@ hۋq@ $tS@ \N<@ hr@ lC@ xl"h
@ 1@ \(@ #@  ě@ :~ @ O;@ Ov`@ x@ Dg8~@ >BZc@ A@ Z@ @4@ A7K@ ;dZ@ ֡af@ t@ fA@ ,<@ @ ҈p:@ _p@ 
M;@ @ )^	@ ɅoiD@ @ 5Xy@ ^5?|@ 4֡b@ 3@ 2W@ 2W@ ͞&@ -@ IQ@ xF@ ěT@ Ov_خ@ S@ *0@ Fs@ \(@ Vu@ (@ xF]@ YJ@ ?@ ?@ %2@ :S@ b}V@ {~$@ z@ x73@ uY|@ sE@ sPH@ sPH@ q@ l!-w@ jg	@ jg	@ j~"@ hۋq
@ dqj@ b}Vm@ a'R@ a|Q@ _Ft@ \?@ \(\@ \(\@ ^ ѷY@ \?@ [$@ ZQ_@ XD*@ Xe+@ TE@ PH@ N_o @ JW'@ I@ Gy@ GE84@ F-@ E84֡@ B@ A@ >vȴ9X@ <j~#@ :^5?|@ 84֡b@ 74m@ 43@ 1&x@ .2X@ ,>B[@ ,1&y@ +6z@ *0
@ )^@ '/V@ &x@ &IQ@ &L/{J@ %zxl"h@ $?@ "`A@ !.H@ 	@ Q@ %@ Ov_خ@ u"@ qu!@ ,<@ 6C@ @@ O;d@ Z@ nO@ o @ 	ԕ*@ &I@ Fs@ &I@ @ ݗ@ ݗ@  IQ?E?!.H?s?+?MjO?D?+jg?s?C\?ᰉ'??u!?]ce?fA?fA?*0U?p:~?+?+?s?74?[W>?)_?E? ě?6z?Xy=?TɆ?n.3?	k?u%F??҉?N;6?Mj??qiC?ݗ?M:??4m9?b}V?~$t?|Q?zG{?sg?rGE85?qu!S?q?nO;?k~($?cA [?ae?_o?\N;?[6?Zc	?XbM?W>6z?T`d?N;5X?H?@NU?;dZ?8YJ?8}H                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     @@irGE@@i@N@@i#w@@i [7@@i+@@i@@i [7@@i&x@@i#w@@i@@i@@i@@i_p@@i@N@@i_p@@i_p@@i_p@@i@@i@@i#w@@i&x@@i [7@@i_p@@i@@i_p@@i [7@@i#w@@i#w@@i&x@@i#w@@i@@i#w@@i [7@@i@@i@@i@@i [7@@i#w@@i [7@@i_p@@i&x@@i [7@@i#w@@i#w@@i+@@i@N@@i+@@i+@@i@N@@i@N@@i@N@@i@@i@@irGE@@i@@i	k~@@i	k~@@i@@irGE@@i@N@@i@N@@i ѷ@@i$/@@i@@i@@i	k~@@i	k~@@i$/@@i	k~@@i@@i	k~@@i	k~@@i@@i$/@@i	k~@@i	k~@@i	k~@@i	k~@@irGE@@i	k~@@i_p@@i_p@@i@N@@i@N@@i@N@@i+@@i-w1@@i7KƧ@@i7KƧ@@i0
)@@i=b@@iDg8~@@iJE@@iGz@@iDg8~@@iJE@@iXbM@@iTɅo@@iae@@irGE8@@ix@@i7Kƨ@@i(@@iy@@i_o@@i@@iᰉ'@@iY}@@jI^5@@jd7@@j͞&@@kJ#9@@kZ@@l*1@@n
(@@qk~(@@|L_@@#9@@Ϫ͞@@rGE8@@@@b}@@jf@@ȝIQ@@@@΍@@Ϋ6z@@1&x@@a|Q@@zxl"h@@쿱[W@@׊	@@73@@A [@@S@@`d@@ܲ@@5Xy>@@Xe@@'RT@@䎊q@@?@@ ѷY@@;5X@@.2@@䎊r@@r Ĝ@@ѷX@@	k@@@@*0U2a@@Q@@2W@@&IR@@kP|@@ᰊ@@~"@@<64@@sP@@ ѷ@@C,z@@jf@@jf@@qu!@@qu!@@땁$@@Mj@@ߤ@@6@@m]@@C]@@J@@1&y@@\N@@%2@@Q@@SMj@@PH@@]ce@@`d@@wkP@@쎊qj@@3@@C@@#@@웥S@@_@@*1@@웥S@@TɆ@@쿱[@@?@@?@@쿱[@@j~@@첕@@첕@@TɆ@@3@@#x@@쿱[@@?@@1&@@?@@֡a@@>B[@@JM@@e@@>@@E@@'0@@V@@>@@o i@@<64@@!.H@@*0@@*0@@Q@@84֡@@+a@@+a@@%F
L@@!.H@@\@@p
=@@sg@@p
=@@$/@@Xy=@@n/@@@@Ϫ͞@@@@8Y@@cA @@@@S@@(@@(@@
qv@@E@@
L/@@
L/@@
L/@@BZc @@!R<@@!R<@@$/@@.2@@?@@E@@1.@@
(@@;5X@@\N<@@fffff@@s@@}Vl@@af@@-@@T@@@@z@@l!-@@@@,<@@'@@@@"@@쿱[W@@A@@1@@,@@1@@8}H@@1@@;dZ@@O
M@@iDg8@@sPH@@y@@sPH@@ݗ+@@o @@r@@@@#@@bM@@*0U@@D*@@A7K@@bM@@[6@@u!@@u!@@tj@@𭫟U@@TɅ@@ۋq
@@ ѷ@@=b@@e+a@@o hی@@u!S@@u@@R<6@@|@@2W@@"`@@.H@@1'@@3@@-V@@:)y@@kP|@@򅇓ݘ@@vȴ@@>B@@>B@@}Vm@@n@@fB@@I^@@"`B@@"`B@@6z@@F]c@@P{@@Z@@tj~@@q@@U=@@a@@@$@@tj@@M:@@N;@@?@@>@@Q@@[@@2a|@@\@@@@@@Ϫ͞@@4K@@.2@@c	@@Fs@@T@@
=p@@!-w1@@>6z@@O
M@@o@@v_ح@@y@@@@@
qu@@4m9@@H@@|@@tj@@ěT@@҈p@@@@+@@&x@@Dg8~@@B@@iB@@	 @@n@@-@@>BZ@@s@@S&@@C,z@@)^	@@&@@&@@9@@9@@=K^@@]cA@@Ƨ@@xF@@tSM@@?@@֡a@@:@@qu"@@Q@@?|h@@O;dZ@@Y|@@ڹZ@@O
@@@@n/@@
L/@@Ov_@@$/@@.2@@5?|@@L/{J@@Vu@@l!-@@s@@Fs@@2X@@ȴ9X@@Ϫ͟@@!.I@@!-w1@@E84@@eں@@@A 'RT`@A bM@A u%F@A 
(@A @@A ۋq
@A `A7@A `A7@A7KƧ@Ahr @Ax@A7Kƨ@A'RTa@A"`@An@A)y@Au%F
@A~"@A{m@AS&@A@A@A,<@A74@A&@A@N@AZ@A{J#9@A$@AS@AE@Ag@A,<@A]ce@AN;@A#x@A/@AZ@A/@AE@AF
L0@AfA@Aw1@Ahr!@A%@A?@Aڹ@A_o @A4K@A5?|@Al!-@AFs@A&I@A+@Aߤ?@AC-@A
M;@A@A8}H@A8}H@A;dZ@A>6z@AE84@AO
M@AU=@Ay@A[W>@AحV@A'RT`@AD*@Al"h	@A|@A@AU@ATɅ@Ap:@A	_p@A	ae@A	x@A	@A	@A	'RTa@A	@A	lD@A
6C@A
Q_@A
ݘ@A
S&@A
,<@A
m\@AS&@A҉@APH@A)^	@AF]c@A$@AE@Aa@@A1&y@A!-w2@A2W@APH@AZ1@Aj~#@A?@A7@Ae@A
qu"@A
qu"@A
5Xy>@A
B@A
IQ@A
w1@A
=K@A
@A
ڹ@A
L/@Ac	@A@A-@A'@At@Aߤ?@A hۋ@A@Ao@AlC@Av_ح@AO;d@AVϫ@A
qu@A'RT`      @AoiDg8@A@A\)@A$/@A [7@Ahr @Au@A^5?}@A_o@A"`@A@A-@Ae+@AW'@A{m@Aᰊ@A0
@AwkQ@AwkQ@A@A<64@AsP@Ac	@Am\@APH@A9@AS@Aqu!@AMj@Aߤ@Awk@AZ@AQ@AJ@A!-w2@A2W@A?@AFs@A]ce@AtSM@A~($x@A#@A*1@Azxl"@A1&@Aj~@A?@AZ@A:@Aqu"@A+a@A?|h@AS&@AjOv@AjOv@Aw1@Asg@A}H@AM:@A%@A@A?@A(@At@AOv_@AYJ@A+J@A'@A hۋ@A@A$tS@A'/W@A4֡a@A;dZ@AE84@A\(@Av_ح@A4m@A$tS@A&@A/V@Ao @A-@AF]d@AbM@A$xG@AK]c@AK]c@Al"h	@A'RT@AIQ@A)@Ae+@A	k@A$tT@APH@ArGE@A	k@A	k~@A:S@Aae@A~($@A'RTa@A@A@Ay@AiB@Au%F@As@Ae+@A䎊@A-V@AM@Ad7@AkP|@AkP|@Aݘ@AW@A䎊q@Am\@A@N@Ajf@Aqu!@An.3@AS@Am]@AZ@A@A҈@AA [@As@A@A]ce@A#@A_@A쿱[@A1&@A@Ahr@Ahr@Ahr@A:@Ao i@A[@A*0@Aqu"@A(@A?|h@Am\@A!R@A+j@A-V@A@AϪ͞@AoiDg@A_o @AOv_@A($x@A8YJ@AE@AYJ@Aqi@A6z@Aߤ?@Am\@Aߤ?@AFs@A)^@A1@A>6z@AU=@Ab}V@Aeں@A	@A/V@A@A;dZ@A#@A *0U@A  ě@A U2a|@A [6@A l"h	@A y=c@A ˒:*@A ˒:*@A YJ@A @A tj@A {@A p:@A D@A {@A!@A!#w@A!|Q@A!@A!R<6@A!(@A!@A!-@A"@4n@A"Zc@A"d7@A"d7@A"nO@A"qiC@A"wkQ@A" ě@A"<64@A"@A"@A" ѷ@A#"`B@A#P{@A#n.3@A#xF]@A#{J#9@A#Q@A#$@A#S@A#*0U2@A#q@A#E@A#@A#@A#a@O@A$ߤ@@A$9XbN@A$Fs@A$`d@A$~($x@A$wkP@A$*1@A$TɆ@A$7@A$/@A$Z@A$/@A$!-w@A%u@A%*0@A%[@A%V@A%V@A%<64@A%B@A%F
L0@A%}H@A%+j@A%sh@A%Ϫ͞@A%Ϫ͞@A%(@A&@A&Ov_@A&8YJ@A&R<6@A&_ح@A&_ح@A&iB@A&z@A&O;@A&,<@A&T@A&6z@A&Ϫ͟@A&Mj@A'
M;@A'4֡a@A'8}H@A'KƧ@A'\(@A'iDg8@A'sPH@A'&@A'/V@A'vȴ9@A'vȴ9@A'˒:)@A'@@A'o @A'@A'#@A(     @A(	ԕ+@A(
qu@A(@A( ě@A(*0@A(-
q@A(A7K@A(U2a|@A(Xy=@A(˒:*@A(@A(IQ@A(
=q@A(@@A(p:@A(p:@A(҈p@A(`A7@A(C@A(\)@A($tT@A($tT@A)$/@A) [7@A)=b@A)A [@A)Dg8~@A)Q@A)XbM@A)u!S@A)@A)o@A)l@A)'R@A)@A)y@A)X@A)X@A)X@A)D@A)ᰉ'@A)Y}@A*n@A*I^5@A*䎊@A*:)y@A*W'@A*qiC@A*~"@A*p:@A*S&@A*wkQ@A*@A*䎊q@A+S&@A+PH@A+PH@A+"`B@A+"`B@A+&@A+"`B@A+&@A+33333@A+6z@A+C%@A+J#9@A+dZ@A+tj~@A+{J#9@A+xF]@A+@A+Mj@A+S@A+Ƨ@A+
=p@A+C]@A,ߤ@@A,!-w2@A,%1@A,Q@A,"h	ԕ@A,"h	ԕ@A,(\@A,"h	ԕ@A,%1@A,/{J#@A,9XbN@A,<쿱@A,9XbN@A,]ce@A,qj@A,*1@A,1&@A,?@A,*0@A,hr@A-:@A-'0@A-'0@A-[@A-qu"@A-Q@A-!.H@A-+a@A-5Xy>@A-B@A-IQ@A-S&@A-L_@A-L_@A-Y|@A-m\@A-w1@A-}H@A-!R@A-=K@A-v@A-U=@A-U=@A-sh@A-H˒@A-8Y@A-8Y@A-cA @A-@A-?@A-
qv@A-,=@A-!.@A-C\@A. ѷY@A._o @A.t@A.4K@A.@A.u@A.$/@A.+jg@A.5?|@A.8YJ@A.R<6@A.iB@A.z@A.-@A.ߤ?@A.x@A/@A/Xe@A/!-w1@A/!-w1@A/$tS@A/4֡a@A/!-w1@A/'/W@A/4֡a@A/As@A/U=@A/o@A/lC@A/o@A/o@A/|hs@A/O;d@A/kP@A/?@A/zH@A/@@A/-@A/-@A/-@A/-@A/-@A/䎊r@A0$xG@A0*0@A073@A0U2a|@A0r Ĝ@A0-
@A0
=q@A0ěT@A0e+@A0@A04֡b@A0PH@A1@A1$/@A1rGE@A1_p@A1 [7@A1*0U2a@A1A [@A1XbM@A1o hی@A1b}@A1~($@A1o@A1u@A1@A1(@A1(@A1'R@A1N;6@A1iB@A1@A1@A1iB@A1"`@A1@A1e@A1R@A1R@A1R@A1Y}@A1-@A2n@A2@A2s@A2s@A2e+@A21'@A2#9@A2@4n@A2Q_@A2^5?|@A2u%F
@A2{m@A2S&@A2S&@A2`A@A2`A@A2m@A2fB@A2~@A3s@A3"`B@A3&@A3,zxl@A3,zxl@A39@A3F]c@A3P{@A3a@N@A3n.3@A3{J#9@A3A@A3*0U2@A3wk@A3*0U2@A3q@A3m]@A3a@@A3@A4xF@A4L_@A4,<@A4<쿱@A4I^5?@A4VϪ@A4`d@A4j~#@A4tSM@A4~($x@A4#x@A4[W?@A4Ʌoi@A4JM@A5o i@A5'0@A5V@A5qu"@A5qu"@A5L_@A5ce@A5p
=@A5w1@A5M:@A5=K@A5-V@A5H˒@A5@A5\(@A58Y@A58YK@A5oiDg@A5oiDg@A6@A6$/@A6.2@A6.2@A6;5X@A6BZc @A6iB@A6vȴ9X@A6vȴ9X@A6%@A6,<@A6ߤ?@A6Q@A6ߤ?@A6m\@A6Ϫ͟@A6x@A7
M;@A7
M;@A7Xe@A7,@A7Xe@A7v@A7v@A7!-w1@A7>6z@A7E84@A7KƧ@A7O
M@A7RT`e@A7b}V@A7sPH@A7v_ح@A7sPH@A7v_ح@A7y@A7|hs@A7&@A7&@A7zH@A7r@A7/V@A7@A7K]d@A7K]d@A7حV@A7䎊r@A7䎊r@A7䎊r@A7rGE9@A8     @A7#@A8
qu@A8@A8 ě@A8-
q@A8-
q@A873@A8:~ @A8A7K@A8_F@A8[6@A8˒:*@A8@A8@A8u%F@A8
=q@A8TɅ@A8e+@A8@A8@A8	k@A9@A9+@A9#w@A9N;5@A9k~(@A9@A9o@A9@A9n.@A9B@A9|@A92W@A92W@A9R@A9lD@A9.H@A:	 @A:@A:s@A:1'@A:䎊@A:C\@A:GE85@A:JL@A:Q_@A:^5?|@A:kP|@A:{m@A:{m@A:p:@A:S&@A:ᰊ@A:L_@A:0
@A:wkQ@A:g	@A:,<@A:c	@A:~@A;u%@A;&@A;=K^@A;]cA@A;n.3@A;tj~@A;tj~@A;xF]@A;xF]@A;{J#9@A;Q@A;Mj@A;$@A;A@A;Mj@A;wk@A;wk@A;%2@A;%2@A;@A<n.@A<1&y@A<J@A<Q@A<L_@A<"h	ԕ@A<!-w2@A<(\@A<2W@A<<쿱@A<Fs@A<M:@A<SMj@A<cA \@A<g8}@A<tSM@A<j~#@A<?@A<#@A<S@A<1&@A<@A<j~@A<7@A<@A<Ʌoi@A</@A<*0@A<>B[@A<hr@A<D@A<e@A=u@A=!.H@A=F
L0@A=O;dZ@A=F
L0@A=S&@A=S&@A=Vl!@A=IQ@A=IQ@A=B@A=Vl!@A=jOv@A=m\@A=p
=@A=w1@A=w1@A=hr!@A=%@A=U=@A=@A=n/@A=@A=@A=@A=b@A=ᰉ@A=!.@A>t@A>_o @A>
L/@A>@A>1.@A>8YJ@A>8YJ@A>8YJ@A>E@A>Ov_خ@A>c	@A>p:~@A>+J@A>%@A>@A>2X@A>@A>@A>ߤ?@A>ߤ?@A>@A>m\@A>t@A>Ϫ͟@A>Ϫ͟@A>]cf@A>x@A>C-@A>ߤ?@A>ߤ?@A>ߤ?@A>C-@A>x@A>Mj@A>Mj@A?Ft@A?)^@A?Xe@A?$tS@A?E84@A?O
M@A?U=@A?Xe,@A?U=@A?Xe,@A?Xe,@A?b}V@A?iDg8@A?lC@A?y@A?@A?$tS@A?ݗ+@A?kP@A?	k@A?zH@A?3@A?o @A?vȴ9@A?@A?K]d@A?@A?@A?Vϫ@A?+j@A@
qu@A@bM@A@@A@ ě@A@'RT`@A@73@A@4m9@A@U2a|@A@NU@A@Xy=@A@_F@A@eO@A@u!@A@|@A@˒:*@A@@A@-
@A@@A@-
@A@@A@d8@A@d8@A@)@A@@A@@A@	k@A@$tT@A@$tT@A@$tT@A@$tT@A@	k@AArGE@AA@AA#w@AA#w@AA*0U2a@AA-w1@AA0
)@AA:S@AAA [@AADg8~@AADg8~@AADg8~@AAA [@AAN;5@AAJE@AATɅo@AAhr @AArGE8@AAx@AA|Q@AAb}@AAb}@AA@AA@AA~($@AAn.@AAu@AA'RTa@AAn.@AAl@AA|@AAy@AAD@AAN;6@AA@AAiB@AAᰉ'@AA>BZ@AAᰉ'@AB	 @AB3@AB=p
@AB6C@AB:)y@ABQ_@ABh	ԕ@ABqiC@ABu%F
@ABu%F
@ABxl"h
@AB@4@ABL_@AB\(@AB0
@ABvȴ@ABS&@AB ě@ABY@AB<64@AB)_@ABW@ABsP@ABfB@ABc	@ABD@AB~@ACI^@AC'/@ACS&@AC"`B@AC"`B@AC)^	@AC33333@AC33333@AC33333@ACF]c@ACP{@ACP{@ACdZ@ACa@N@ACjf@ACqu!@AC~$@AC@AC@AC@ACQ@ACMj@ACMj@ACU=@ACS@AC@ACE@ACE@AC~($@AC@ACa@O@AC|@AClC@AClC@ACC]@ACs@ADn.@ADߤ@@AD@AD"h	ԕ@AD,<@AD<쿱@AD<쿱@AD<쿱@ADI^5?@ADPH@ADSMj@ADVϪ@ADcA \@AD`d@ADtSM@ADzG@ADtSM@ADq@ADwkP@AD?@AD#@ADC@ADqj@AD*1@ADzxl"@AD3@AD?@AD[W?@AD?@AD@ADZ@ADu"@AD>B[@ADJM@AD!-w@ADE@AEo i@AE'0@AEu@AE*0      @AE(@AE+a@AE2a|@AE5Xy>@AE5Xy>@AE84֡@AE?|h@AEO;dZ@AEO;dZ@AES&@AEY|@AE\@AEce@AEjOv@AEfA@AEjOv@AEjOv@AEzxl"h@AE}H@AE}H@AE$/@AEhr!@AEv@AE=K@AE%@AE%@AE@AEXy=@AEU=@AEU=@AEsh@AE@AEϪ͞@AEϪ͞@AEϪ͞@AEϪ͞@AEϪ͞@AE8YK@AE8YK@AE?@AE?@AE?@AES@AES@AE(@AEڹ@AF_o @AF
(@AF
(@AF.2@AFVu@AF8YJ@AFL/{J@AFOv_خ@AFYJ@AFfffff@AFfffff@AFl!-@AFl!-@AFp:~@AF%@AFIQ@AF%@AFqi@AF$t@AFO;@AF@AF-@AF6z@AF}Vl@AF'@AF@AFm\@AFm\@AFA@AF҈p;@AF쿱[W@AFx@AF@AF@AFMj@AFFs@AFFs@AG hۋ@AG@AG
=p@AG@AG8}H@AG>6z@AG;dZ@AG;dZ@AGKƧ@AGRT`e@AG\(@AGo@AGy@AG|hs@AG{J#:@AGO;d@AG$tS@AG-V@AG͞@AGr@AG@AGo @AGo @AG+@AG@AG@AGrG@AGrG@AGVϫ@AGrGE9@AH     @AH@AH
qu@AH@AH@AH}H@AH}H@AH*0@AH1&x@AH73@AH4m9@AH73@AH>BZc@AHH@AHNU@AHU2a|@AHXy=@AHbM@AHeO@AHhۋq@AHhۋq@AHoiDg8@AHhۋq@AHhۋq@AHl"h	@AHr Ĝ@AHr Ĝ@AH|@AH'RT@AH@AHIQ@AH-
@AH@AH{@AH
=q@AH{@AH9Xb@AHTɅ@AH)^@AH)^@AHѷX@AHۋq
@AHe+@AH4֡b@AHC@AHPH@AH$tT@AI	k~@AI	k~@AI	k~@AIrGE@AI@N@AI+@AI+@AI@AI@AI#w@AI&x@AI0
)@AI:S@AI7KƧ@AI:S@AI4J@AIA [@AIDg8~@AIA [@AIDg8~@AIN;5@AIN;5@AITɅo@AI^@AIrGE8@AIrGE8@AIb}@AI|Q@AIb}@AIb}@AI@AIoiD@AI@AIR<6@AI'RTa@AI'RTa@AI'RTa@AIl@AI(@AI'R@AIl@AI|@AI^5?}@AI@AIo@AIo@AI@AI"`@AIiB@AIiB@AIiB@AIᰉ'@AIe@AI@AIY}@AIY}@AJu%F@AJI^5@AJOv`@AJOv`@AJe+@AJ1'@AJ䎊@AJ-V@AJ6C@AJ@4n@AJC\@AJGE85@AJQ_@AJM@AJT`d@AJT`d@AJZc@AJZc@AJ^5?|@AJ^5?|@AJh	ԕ@AJd7@AJnO@AJqiC@AJ@4@AJu%F
@AJqiC@AJxl"h
@AJp:@AJL_@AJ\(@AJ0
@AJᰊ@AJ0
@AJwkQ@AJvȴ@AJS&@AJ@AJg	@AJ)_@AJW@AJ`A@AJ`A                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     @rfffff@r33333@r@r     @rfffff@r33333@r@r@r@r@r@r@r@r     @rfffff@r     @r@rfffff@r33333@r@r@r@r@r33333@r@rfffff@r@r@r33333@r@rfffff@r33333@r@r33333@r     @r@r33333@r     @r33333@rfffff@r33333@r@r@r@r     @r     @r     @rfffff@r33333@rfffff@r@r@r@r     @r33333@r     @r     @rfffff@r@r@r33333@r     @r     @rfffff@r@r     @r     @r@r@r@r     @r33333@r@r33333@r33333@r@r@r     @r@r33333@r     @r@rfffff@r@rfffff@rfffff@r@r33333@r@r     @rfffff@r@r@r     @r@rfffff@r@r@rfffff@r33333@rfffff@r@r     @r@r@r@r@rfffff@r     @r     @rfffff@r|@r{33333@rt@rc33333@r6fffff@q     @pnfffff@n@lٙ@k@k@k6fffff@ks33333@j     @j|@jffffff@jI@j333333@j@jfffff@i33333@i陙@iٙ@i@i33333@i@i@iVfffff@i,@i33333@hfffff@hfffff@h     @hp     @g@g33333@g@g|@gc33333@gP     @g9@g@g33333@g     @g33333@f     @f     @f     @f陙@f33333@f@fə@f33333@f@f@f|@fs33333@fc33333@fI@f)@f@e33333@eٙ@e     @efffff@e@ep     @eS33333@eFfffff@e<@e0     @e@efffff@d33333@d@d     @d|@ds33333@dY@d<@d@d@dfffff@d33333@c@c33333@c     @c@c     @cy@cY@cVfffff@cP     @cfffff@b@b33333@bfffff@b     @bl@bY@bI@b6fffff@b&fffff@b33333@a     @a@a33333@as33333@a`     @aVfffff@aC33333@aFfffff@aP     @a@`fffff@`     @`33333@`     @`     @`|@`S33333@`I@`<@`&fffff@`#33333@`)@`,@`9@`&fffff@_33333@_33333@_fffff@_fffff@_@_l@_333333@_      @^     @^     @^     @^y@^9@^@]33333@]fffff@]@]`     @]Ffffff@]9@],@]@]33333@]@]fffff@\@\fffff@\s33333@\,@[@[     @[33333@[     @[fffff@[y@[L@[@     @[,@[fffff@Z@Z33333@Zfffff@Z@Z@ZS33333@Z33333@Yfffff@Y@Y`     @Y,@Y33333@X@X33333@X     @Xfffff@X@Xs33333@Xffffff@XFfffff@X333333@X333333@X@Wfffff@W     @W     @W33333@Wffffff@W@     @W@V33333@V33333@V@V@V@Vfffff@Vl@V,@V@U@U33333@U@U     @U@Us33333@UL@US33333@UFfffff@U333333@U9@U333333@U      @U      @T@T@T@T     @Tl@TL@T9@T@S33333@Sfffff@S     @Sy@Sfffff@SS33333@S333333@S      @R@R     @R     @R33333@R33333@R@Rffffff@R@     @R33333@Q@Q@Qfffff@Q     @Q@Qs33333@QFfffff@Q&fffff@Q333333@Q33333@P@P     @Pٙ@Pfffff@Pfffff@Py@PY@P`     @Pffffff@P`     @PS33333@P@OY@O@O333333@OL@O333333@O@     @O333333@O@Nfffff@Nfffff@NL@Mfffff@M@Ms33333@MY@ML@ML@ML@Mffffff@Lfffff@Lfffff@L@Lfffff@L@L     @LY@L@     @L&fffff@L@L@L&fffff@L333333@L&fffff@L      @K33333@K@Ks33333@Ks33333@KL@K&fffff@J33333@J     @J33333@Js33333@J&fffff@I@Ifffff@I     @Ifffff@I     @I     @I333333@I      @H33333@I@Hfffff@H@Hs33333@H&fffff@H@     @H@     @H333333@HY@H&fffff@G33333@Gٙ@Gfffff@G@Gs33333@Gs33333@GY@GL@GL@G      @F@F@Fffffff@FY@FY@F@     @F&fffff@F@E33333@Efffff@Eٙ@E33333@E@Efffff@E@E     @Es33333@E@E@E@D33333@Dfffff@D33333@D@D     @D@D     @D@Dfffff@D33333@D@D@D@D@Dffffff@D&fffff@D      @D      @D@Cٙ@Cfffff@C33333@C@C@Cs33333@CL@C333333@C@Bٙ@B     @B33333@B33333@Bs33333@BL@BY@BL@B&fffff@A33333@B      @Afffff@A33333@A@A33333@A     @A     @A@As33333@As33333@AY@AY@A@     @A@A&fffff@A@@fffff@@     @@@@@@33333@@fffff@@fffff@@     @@Y@@L@@333333@@@?fffff@?@?     @?@?33333@?@?@?     @?ffffff@?L@?      @>33333@>      @>     @>333333@=@=     @=L@=      @<@<ffffff@<333333@<333333@;fffff@;33333@<L@;@<      @;ffffff@;L@;L@;L@;@;@;@;L@;@;@;@;@:33333@:     @:33333@:@:@:     @:333333@:L@:      @:      @:@9fffff@933333@9fffff@9@9     @9@933333@9@9     @9L@9L@9     @9     @9ffffff@9L@9@9      @8fffff@8fffff@8fffff@9      @9333333@9333333@8@8fffff@8     @8L@8     @8333333@8      @8L@7fffff@7@7     @7@7@733333@733333@7@7L@7ffffff@7ffffff@7ffffff@7L@7ffffff@7ffffff@7L@7333333@7@6fffff@6fffff@7@7@6fffff@6@633333@6@6@633333@6     @633333@6@6     @6L@6333333@6333333@6ffffff@6L@5fffff@6L@6333333@6@6L@6@6      @6333333@6      @533333@533333@5@5@5     @5333333@5333333@5333333@5L@5      @5      @5     @5L@4fffff@5@5333333@5@5333333@4fffff@4@433333@4ffffff@4333333@4L@4L@4@4     @4333333@4      @4      @4@4L@4L@3fffff@4333333@3fffff@3@4      @3fffff@3fffff@4@333333@3@3@3@3@3@3ffffff@3ffffff@3ffffff@3ffffff@3L@3ffffff@3ffffff@3     @3@3L@3L@233333@3      @3ffffff@3@233333@233333@2@3@233333@2@233333@2@2@2@2     @2ffffff@2L@2@2@2@2ffffff@2     @2333333@2333333@1fffff@1fffff@2333333@2@2      @1fffff@1fffff@1@1@1@2      @1fffff@1@1ffffff@1@133333@1@1@1     @1@1ffffff@1333333@1ffffff@1ffffff@1ffffff@1ffffff@1ffffff@1L@1L@1L@1333333@1     @1L@1@1333333@1@0fffff@0@0fffff@1@1333333@1      @0fffff@0fffff@1      @1      @1L@0fffff@0fffff@1L@1L@0@0fffff@0fffff@0@033333@1333333@033333@033333@0@0@0@0@0@0333333@0     @0L@0333333@0333333@0333333@/@0333333@0333333@0333333@0      @0@0333333@0      @0@0      @/@/@0      @/@0@/@0@0      @0@0      @/@0      @0@0      @0@0L@0L@0@0@0     @/@0333333@0ffffff@0333333@0333333@0333333@0333333@0ffffff@0      @0@0333333@0L@0ffffff@0     @0ffffff@0@0fffff@0@0@0     @0@0@0     @0@0@0     @0ffffff@0     @0@0@033333@0     @0@0L@0333333@/@/@0333333@0333333@0      @0333333@0      @/@/ffffff@/ffffff@/ffffff@/      @/ffffff@/ffffff@/333333@/@0333333@0@/ffffff@/333333@/@0333333@0@0333333@0     @0     @0@/@0333333@0ffffff@0L@0ffffff@0     @0ffffff@0ffffff@0ffffff@0@0@0L@0ffffff@0     @0333333@0@1      @0@0@033333@0fffff@0fffff@033333@1      @0fffff@1      @1      @1@0@0@0fffff@0@0fffff@0fffff@1@0fffff@0@0@0fffff@0fffff@0fffff@1@1      @1@0@1      @0fffff@0fffff@1      @0fffff@0fffff@0fffff@0@0fffff@0fffff@0@0fffff@0fffff@0fffff@1      @0fffff@0@0fffff@1      @0fffff@0@0fffff@1@0@033333@0@0@033333@0@0@0@033333@033333@0@033333@0fffff@0@0ffffff@0ffffff@0@0@0     @0@0@0     @0@033333@0ffffff@0     @0@0@033333@0@0     @0333333@0L@0     @0ffffff@0L@0L@0L@0ffffff@0L@0      @0L@0@0333333@0L@0333333@0@0@0L@0@/@0@0@0333333@0      @/@0L@0@0      @0@0333333@/@0L@0      @/@0      @0333333@0      @/@/@/@/@0      @/@/@0      @/@/@/@/@/@0      @/ffffff@/@0      @0      @/@/@/@0@0      @/@0      @/333333@/ffffff@.@/@/ffffff@/333333@/@/@/@/ffffff@/333333@/ffffff@/ffffff@/@/@/ffffff@/ffffff@/333333@/333333@/      @/      @/      @/@/@/      @.ffffff@.@/333333@/333333@/333333@/      @.@.ffffff@.ffffff@.ffffff@.@.@/      @/333333@.@.@.@.@.@/      @.@.ffffff@.@.@.333333@.      @.@.ffffff@.333333@.333333@.@.333333@.ffffff@.      @.ffffff@.@/      @.@.      @.333333@.ffffff@.@/ffffff@/333333@/      @.@.@/@/      @.ffffff@.@/      @.@/      @/      @/      @.@.@.@.@/      @.@/333333@/333333@.@/      @/      @/ffffff@/ffffff@/ffffff@/333333@/      @/333333@.@/333333@/333333@.@/333333@/      @/@/333333@/      @.      @.@/@/      @/      @/333333@/333333@/      @.@.@.@.@.@.@/      @/      @.ffffff@.333333@.333333@.ffffff@.@-@.333333@.ffffff@.333333@.@-@-ffffff@.ffffff@.333333@.@.      @.ffffff@.333333@.333333@.@.@.ffffff@.@/      @.@.@.@.@/333333@/333333@/      @.@.@/333333@/ffffff@/333333@.@/ffffff@.@/333333@/ffffff@.@.@.ffffff@/      @.@.@.ffffff@/      @/333333@.@.@.@.@/      @/333333@/@/@.@.ffffff@.ffffff@.@.@/333333@/      @/333333@/333333@/      @.@/333333@/333333@/ffffff@/333333@/ffffff@/@0      @/      @/333333@.@/@0      @0@/ffffff@/@/@/@/ffffff@/333333@0@0L@0     @0333333@0ffffff@0L@0ffffff@0     @0333333@0ffffff@0L@0     @033333@1@1@1333333@1L@1ffffff@1     @1@1ffffff@1@2@133333@133333@1@133333@1@2      @2      @1fffff@1fffff@1fffff@1@133333@133333@133333@1@1fffff@1fffff@2L@1@1@2@2333333@2@2@2333333@2ffffff@2L@2L@2333333@2L@2ffffff@2L@2L@2ffffff@2L@2@2@3      @3@3333333@2@233333@3      @2@2fffff@2fffff@2@2@2fffff@2fffff@2@2fffff@2fffff@2fffff@3@3333333@3      @2fffff@2@2fffff@3@3     @3ffffff@3L@3ffffff@3@3@3@3@333333@3fffff@333333@333333@4333333@4333333@4ffffff@3fffff@4ffffff@4333333@4ffffff@4@4@433333@4     @4fffff@5@5@4fffff@4fffff@433333@4@4@4@4fffff@5     @5@5@5L@5ffffff@5fffff@6@5fffff@6      @6      @5@5fffff@5@5fffff@6@6333333@6L@6333333@6     @6     @6     @6     @6ffffff@6L@6L@6@6@6fffff@633333@633333@6@6fffff@6@633333@633333@7333333@7      @7@6fffff@7@7ffffff@7ffffff@7ffffff@7     @7ffffff@7L@7ffffff@7fffff@733333@7fffff@7fffff@8333333@8     @833333@8L@8@8@9333333@9     @9     @9      @9@9@9333333@9@9333333@9L@9     @9     @9     @9@:      @9fffff@9fffff@:@9fffff@:333333@:@:ffffff@:333333@:@;@;L@:@;L@;L@;     @;@;33333@;     @;ffffff@;     @;@<      @<      @;@;@<333333@;fffff@<      @<@<333333@<ffffff@<L@<@<L@<     @<     @<33333@=      @<@=      @=333333@=333333@=333333@=333333@=ffffff@=@=L@=ffffff@=ffffff@=33333@>      @>L@>333333@>L@>L@>L@>     @>     @>ffffff@>     @>     @>ffffff@>     @>ffffff@?@?      @?L@?@?      @?@?     @?33333@?ffffff@@      @@@?fffff@@      @@333333@@@@      @@      @@@@@@&fffff@@L@@L@@ffffff@@s33333@@s33333@@ffffff@@s33333@@fffff@@     @@@@@@     @@@@@@fffff@@fffff@A@A@A      @A@A@A@A@A@A333333@A@     @As33333@Affffff@As33333@A     @A@A33333@Aٙ@A     @A@A33333@A     @A33333@B@A33333@Aٙ@A33333@B      @B&fffff@BY@B     @B@B333333@B@B33333@B@Bfffff@B33333@B@C@C@B33333@C@C@Bfffff@C@C@CL@C@     @CY@CL@Cffffff@Cffffff@Cs33333@C     @C@C@Cs33333@C33333@Cٙ@Cٙ@Cfffff@C     @Cٙ@D@D@C33333@Cٙ@D@C33333@C33333@D@D333333@D@D33333@D     @D@D@D@D     @D33333@D@E@E@E@E      @E@E&fffff@E@     @Effffff@Effffff@Effffff@Efffff@E@E@Efffff@E@E33333@E33333@F      @Eٙ@E     @F      @E     @F@F@Efffff@F@F&fffff@F&fffff@F@F@F@     @FL@Fffffff@Fs33333@FY@Fffffff@F     @Fs33333@Fffffff@F     @Fffffff@F333333@F@     @Ffffff@F33333@G      @F33333@G      @Fٙ@Ffffff@G@G333333@G@G@G@G@     @GL@GL@G@G@G@Gfffff@G     @G     @G@Gs33333@G@Gٙ@Gfffff@G@G     @G33333@G33333@G@G33333@G     @Gٙ@G@H@H&fffff@H@G33333@H      @H&fffff@G33333@H@HY@HY@HY@HY@HL@H@     @H@H     @Hfffff@H     @H     @Hfffff@Hٙ@H     @H33333@H@H@I      @Hٙ@I      @I&fffff@I333333@I333333@I&fffff@I@I@I&fffff@I@     @I@     @I333333@I     @I     @I&fffff@IL@Ifffff@Ifffff@Is33333@Ifffff@I     @Ifffff@J      @I@I33333@Iٙ@I     @I33333@J333333@J333333@JL@J333333@J@J@JL@JL@JY@Js33333@Jffffff@JL@JY@JY@J@Jfffff@J@J@Jfffff@J@J@J     @Jfffff@J     @Jٙ@J                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     ?$/?nO?|hr?E?lD?O;d?C$?1&?lC?S?-?$/?$/?xF??Z1'?Vu?&x?\(?GzH?O;dZ?vȴ9X?zG?E?5?|h?^5?|?^5?|?XbM?E?j~#?hr Ĝ?홙?Q?GzH?&x?$/?1&y?웥S?j~#?Vu?E?xF?5?|h?E?5?|h?-?1&y?`A7L?\(?GzH?S?/w?7KƧ?5?|h?$/?nP?-V??/w?E??ěS?1&x?`A7L??tj~?E?\(?nP?웥S?ěS?hr!?r ě?O;dZ?hr!?1&y?+?dZ1?+?Q?lC?nO?\(\?j~#?A7Kƨ?lC?Ƨ-?S? ěT?dZ1?I^5?C$?ꟾvȴ9?^5?|?333333?^5?|?-V?\(\?lC?"`A?"`?\(\?KƧ?333333? ě?nO;?+?E?lC?-V?hr Ĝ?/v?(\)?(\)?      ?n?|hr?j~"?lC?E?\(?Ͳ-V?1&x?x?`A7?nP?\(?Q?vȴ9X?E?^5?|?QR?KƧ?tj?
=p
?ȴ9Xb?KƧ?
=p
?+?\(?\(?E?\(?$/??|hs?+? ě? ě?333333?-V?Q? ě?l?+?Q?l?Q?l?-V?Q?Q?E?-V?Q?-V?tj~? ě?lD?Q?lD?-V?&x?`A7L?&x?`A7L? ěT?vȴ9X? ěT?bM?
=p?`A7L?`A7L?bM? ěT?
=p? ěT?vȴ9X?;dZ?`A7L?vȴ9X?`A7L?`A7L?bM?`A7L?&x?lD?bM?
=p?bM?`A7L?bM?bM? ěT?`A7L?`A7L? ěT?lD?hr Ĝ?&x? ěT?bM?bM?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?bM? ěT? ěT?
=p? ěT? ěT?
=p?vȴ9X?`A7L?`A7L?vȴ9X? ěT?bM?bM? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?bM? ěT?
=p? ěT? ěT?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?;dZ?;dZ?5?|h?;dZ?Q?;dZ?Q?vȴ9X?;dZ?;dZ? ěT?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?Q?;dZ?;dZ?Q?Q?Q?Q?vȴ9X?vȴ9X?;dZ?Q?vȴ9X?;dZ?Q?Q?Q?Q?5?|h?Q?5?|h?Q?Q?5?|h?5?|h?5?|h?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?Q?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?Q?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?5?|h?Q?;dZ?Q?;dZ?Q?vȴ9X?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?5?|h?Q?;dZ?;dZ?vȴ9X?;dZ?Q?Q?;dZ?Q?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?vȴ9X?Q?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?
=p?`A7L?
=p?bM?vȴ9X?vȴ9X?;dZ?;dZ?Q?;dZ?Q?Q?Q?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?Q?;dZ?Q?;dZ?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?Q?5?|h?Q?Q?Q?Q?vȴ9X?Q?Q?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?vȴ9X?Q?Q?;dZ?Q?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?Q?Q?Q?;dZ?;dZ?Q?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?5?|h?Q?Q?Q?;dZ?Q?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?Q?;dZ?vȴ9X?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?Q?Q?Q?;dZ?Q?Q?;dZ?Q?;dZ?Q?;dZ?Q?;dZ?Q?Q?;dZ?Q?Q?Q?;dZ?;dZ?Q?Q?Q?Q?Q?;dZ?Q?;dZ?Q?Q?Q?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?Q?Q?Q?;dZ?Q?Q?5?|h?Q?;dZ?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?5?|h?Q?;dZ?Q?Q?5?|h?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?;dZ?Q?Q?Q?;dZ?;dZ?Q?Q?Q?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?Q?;dZ?Q?Q?Q?Q?;dZ?;dZ?Q?5?|h?Q?Q?Q?;dZ?Q?;dZ?Q?5?|h?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?Q?;dZ?Q?Q?Q?Q?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?Q?Q?Q?Q?;dZ?;dZ?Q?Q?Q?Q?5?|h?Q?Q?Q?;dZ?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?;dZ?Q?Q?;dZ?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?;dZ?Q?Q?Q?Q?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?-V?Q?Q?Q?Q?;dZ?Q?Q?Q?;dZ?;dZ?Q?Q?;dZ?Q?5?|h?Q?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?5?|h?5?|h?Q?Q?;dZ?Q?Q?Q?Q?Q?5?|h?5?|h?5?|h?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?5?|h?5?|h?5?|h?Q?Q?Q?;dZ?Q?Q?5?|h?Q?Q?Q?Q?Q?;dZ?Q?;dZ?Q?Q?Q?Q?Q?5?|h?5?|h?;dZ?Q?5?|h?5?|h?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?;dZ?5?|h?;dZ?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?;dZ?Q?5?|h?5?|h?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?5?|h?;dZ?Q?5?|h?5?|h?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?5?|h?5?|h?Q?Q?;dZ?;dZ?Q?Q?Q?Q?Q?5?|h?Q?Q?5?|h?Q?5?|h?Q?Q?5?|h?Q?5?|h?5?|h?5?|h?Q?5?|h?Q?Q?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?Q?5?|h?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?5?|h?5?|h?Q?Q?5?|h?Q?5?|h?Q?Q?5?|h?;dZ?Q?Q?Q?Q?Q?Q?5?|h?5?|h?5?|h?5?|h?5?|h?Q?Q?Q?-V?5?|h?Q?Q?Q?Q?Q?5?|h?-V?/v?5?|h?Q?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?Q?5?|h?Q?Q?Q?Q?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?-V?5?|h?5?|h?/v?5?|h?5?|h?5?|h?-V?-V?-V?5?|h?-V?5?|h?5?|h?-V?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?/v?-V?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?-V?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?-V?-V?5?|h?-V?-V?-V?5?|h?5?|h?/v?5?|h?5?|h?5?|h?Q?Q?5?|h?5?|h?-V?/v?/v?-V?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?-V?-V?-V?5?|h?-V?/v?-V?5?|h?5?|h?-V?5?|h?Q?;dZ?-V?/v?5?|h?-V?-V?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?/v?/v?/v?5?|h?5?|h?-V?/v?1&y?/v?/v?-V?5?|h?-V?5?|h?5?|h?5?|h?-V?5?|h?-V?/v?/v?-V?Q?-V?-V?-V?5?|h?-V?5?|h?/v?/v?/v?/v?5?|h?5?|h?-V?-V?-V?5?|h?-V?/v?/v?/v?1&y?1&y?/v?/v?-V?-V?5?|h?5?|h?/v?1&y?/v?/v?-V?/v?/v?-V?5?|h?5?|h?/v?-V?/v?/v?/v?/v?-V?1&y?1&y?5?|h?/v?/v?5?|h?-V?/v?/v?1&y?5?|h?/v?/v?/v?-V?/v?-V?-V?1&y?-V?1&y?/v?/v?5?|h?5?|h?/v?/v?-V?/v?/v?/v?/v?/v?/v?1&y?/v?/v?/v?/v?-V?5?|h?5?|h?/v?1&y?1&y?/v?1&y?/v?1&y?1&y?1&y?/v?-V?1&y?1&y?/v?-V?1&y?1&y?1&y?1&y?1&y?/v?1&y?1&y?1&y?/v?/v?/v?1&y?1&y?/v?/v?1&y?/v?1&y?1&y?1&y?1&y?/v?1&y?/v?1&y?1&y?1&y?-V?1&y?1&y?/v?/v?1&y?1&y?1&y?1&y?1&y?1&y?/v?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?/v?1&y?1&y?/v?1&y?1&y?1&y?1&y?/v?1&y?1&y?1&y?-V?1&y?/v?1&y?1&y?1&y?1&y?1&y?/v?/v?1&y?/v?1&y?(\)?(\)?/v?/v?/v?1&y?1&y?1&y?1&y?1&y?/v?1&y?/v?1&y?1&y?1&y?1&y?-V?1&y?/v?1&y?1&y?/v?/v?1&y?1&y?(\)?/v?(\)?1&y?1&y?1&y?1&y?(\)?(\)?(\)?1&y?1&y?(\)?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?(\)?/v?1&y?1&y?1&y?1&y?1&y?1&y?(\)?(\)?1&y?1&y?1&y?1&y?(\)?(\)?1&y?(\)?1&y?1&y?/v?1&y?1&y?1&y?1&y?(\)?1&y?(\)?1&y?1&y?1&y?1&y?(\)?(\)?1&y?(\)?S?1&y?(\)?1&y?1&y?1&y?(\)?(\)?1&y?(\)?S?1&y?(\)?(\)?(\)?1&y?1&y?1&y?1&y?(\)?1&y?/v?(\)?1&y?(\)?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?(\)?1&y?1&y?1&y?1&y?1&y?(\)?1&y?1&y?1&y?(\)?1&y?1&y?(\)?(\)?S?(\)?1&y?S?(\)?(\)?(\)?(\)?(\)?(\)?1&y?(\)?(\)?1&y?(\)?(\)?(\)?(\)?(\)?(\)?(\)?(\)?(\)?(\)?(\)?1&y?(\)?(\)?1&y?(\)?(\)?(\)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	P19                                     1                                       )BF	30