CDF       
      pressure  _   time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20170205   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P14    CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:34.991581Z    ORIGINAL_HEADER      6CTD,20250210CCHSIOWB
#Removed 'CTDFLUOR_TSG' as it's filled with -999
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2017-06-29. CTD data from cruise 18DD20170205, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20170205. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2017-001/index.php. 
#
# The information in this file for the cruise 2017-001 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-0036.ctd
#
# Start of originator file comment header
#
#*2017/06/29 15:26:50.02
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2017/02/10 06:17:38.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 198
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : CE9F1F72
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            0.3            202.1
#       2 Temperature:CTD               deg_C_(ITS90)   5.6248         6.8697
#       3 Salinity:CTD                  PSS-78          32.78          33.8432
#       4 Sigma-t:CTD                   kg/m^3          25.7461        26.7106
#       5 Oxygen:Dissolved:CTD:Volume   ml/l            3.4            6.87
#       6 Oxygen:Dissolved:CTD:Mass     µmol/kg         147.7          299
#       7 Fluorescence:CTD:Seapoint     mg/m^3          0.66E-01       1.162
#       8 PAR:CTD                       µE/m^2/sec      0              0.3
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        7  F       ' '     2
#       6  -99   ' '        6  F       ' '     1
#       7  -99   ' '        8  F       ' '     3
#       8  -99   ' '        7  F       ' '     1
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2017-001
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P21
#    EVENT NUMBER        : 36
#    LATITUDE            :  49  38.00000 N  ! (deg min)
#    LONGITUDE           : 139  39.97000 W  ! (deg min)
#    WATER DEPTH         : 3961
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    The descent rate of the CTD was very noisy with some complete reversals
#	of direction.
#    CTDEDIT was used to remove many records corrupted by shed wakes;
#	salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Fluorescence and PAR data are nominal and unedited except that some records were
#	removed in editing temperature and salinity and a large spike in
#	fluorescence was removed from file 0032.
#
#    The Transmissivity channel was removed because of frequent shifts in values during
#	casts and large variations between values during repeat casts.
#	The data are available, by request, from the chief scientist.
#
#    NOTE: While the Fluorescence:CTD data are expressed in concentration units, they
#	do not always compare well to extracted chlorophyll samples, particularly for
#	casts far from shore. It is recommended that users check extracted chlorophyll
#	values where available.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in Sea-Bird
#	Application Note #64-2, June 2012 revision (Sea-Bird_64-2_Jun2012.pdf), except 
#	that a small offset in the fit was allowed.
#
#    The Dissolved Oxygen sensor used in files 0001, 0002 and 0016 malfunctioned so the 
#	Oxygen:Dissolved:CTD channels were removed from those files.
#
#    The Oxygen:Dissolved:CTD sensor has a fairly long response time so data accuracy 
#	is not as high when it is in motion as it is during stops for bottles. This will be
#	especially true when vertical dissolved oxygen gradients are large. To get an estimate
#	of the accuracy of the Oxygen:Dissolved:CTD data during downcasts (after recalibration)
#	a rough comparison was made between downcast Oxygen:Dissolved:CTD data and upcast 
#	titrated samples. Some of the difference will be due to problems with flushing of 
#	Niskin bottles and/or analysis errors, so the following statement likely underestimates 
#	Oxygen:Dissolved:CTD accuracy.
#
#    Downcast (CTD files) Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.25 ml/l from 0 to 125 dbar.
#	±0.2 ml/l from 125 to 400 dbar.
#	±0.1 ml/l from 400 to 600 dbar.
#	±0.05 ml/l from 600 to 1500 dbar.
#	Low by up to 0.08 ml/l below 1500 dbar.
#
#    For details on the processing see document: 2017-001-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5--- --6-- ---7--- --8---
#!Pressu Temperat Salinity Sigma-t: Oxygen Oxyge Fluores PAR:  
#!re:CTD ure:CTD  :CTD     CTD      :Disso n:Dis cence:  CTD   
#!                                  lved:  solve CTD:          
#!                                  CTD:   d:CTD Seapoin       
#!                                  Volume :Mass t             
#!------ -------- -------- -------- ------ ----- ------- ------
#*END OF HEADER
     WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @R@        data_max      @R@        C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     :  2   pressure                	long_name         pressure   positive      down   units         decibar    data_min      ?   data_max      @^        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      :  m   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d           temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?-w1   data_max      @ξߤ?   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       :     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d           salinity                	long_name         salinity   units         PSS-78     data_min      @@KQ   data_max      @AKS   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      : L   salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d       <D   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @)         data_max      @rY   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        : K   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d          CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?(\)   data_max      ?(\)   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      :    CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d       ϴ   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min                 data_max      ?   C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       : t   PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d       l   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min               data_max               C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     : (,   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d       c$   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( q   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( r   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      )   data_max      )   C_format      %10d       r4   latitude               	long_name         latitude   units         	degrees_N      data_min      @H-V   data_max      @H-V   C_format      %9.4f          r8   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      `VE   data_max      `VE   C_format      %9.4f          r<   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d        r@   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min        J   data_max        J   C_format      %4d        rD@R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     ?@ @@@@@      @       @"      @$      @%ffffff@*      @,      @.      @0      @1      @2      @3      @4      @5      @5fffff@7      @8      @9      @:      @;      @<      @=      @>      @>@@      @@     @A      @AY@B@B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @Gfffff@H@I      @I     @J      @J     @K      @K     @L      @L     @L33333@N@N     @O      @O     @P      @P&fffff@P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @TFfffff@T     @T     @U      @U@     @U     @U     @V      @V@     @Vs33333@Vٙ@W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z9@Zy@Z@[      @[@     @[     @[     @[@\9@\s33333@\@\@]@     @]     @]     @]33333@^`     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`@a	@a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @bY@b     @b     @b     @b     @c      @c      @c@     @cffffff@cs33333@c33333@c     @c     @d      @d      @d@     @d`     @d     @d@dfffff@d     @e      @e      @e@     @e`     @e     @e     @e@e     @f      @f      @f@     @fc33333@ffffff@f     @f     @g      @g      @g<@g     @g     @g     @g     @h      @h      @h<@hffffff@h     @h     @h     @h     @i      @i      @i<@il@i     @i     @i@ifffff@j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k@k@     @k`     @k     @k33333@k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l@m      @m      @m@     @m`     @m     @m     @m     @m     @n@n@n@     @n`     @n     @n     @nə@n33333@o      @o      @o@     @o`     @o     @o@offfff@o     @p      @p     @p      @p0     @p@     @pH     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q@q33333@q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r@r33333@r     @r     @r     @s      @s     @s!@s0     @s@     @sP     @sa@sp     @s     @s     @s     @s     @s@sfffff@sfffff@sfffff@t      @t     @t      @t.fffff@tP     @t`     @tp     @t     @t     @t@tfffff@t     @t     @t     @t     @u@u     @u$@u0     @u@     @uP     @u`     @up     @u@u     @u@u     @u     @u33333@v33333@v     @v      @v0     @vQ@v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w1@w@     @wK33333@wa@wp     @w     @w     @w@w     @w     @w33333@w     @w     @x      @x     @x      @x.fffff@xQ@x`     @xp     @x     @x     @x     @x     @x@x     @x     @y      @yfffff@y      @y0     @y@     @yP     @y`     @yp     @y@y     @y     @y     @y     @y     @y񙙙@y@zfffff@z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z@zfffff@z     @z     @z     @{      @{     @{@{333333@{>fffff@{P     @{`     @{p     @{     @{33333@{     @{     @{     @{ə@{33333@{     @|      @|     @|      @|0     @|>fffff@|P     @|`     @|p     @|{33333@|fffff@|     @|     @|     @|     @|     @|     @|     @}fffff@}      @}0     @}@     @}P     @}`     @}l@}     @}     @}     @}     @}     @}љ@}     @}fffff@~      @~     @~      @~0     @~@     @~P     @~a@~nfffff@~     @~     @~     @~     @~     @~     @~     @~񙙙@@     @      @0     @@     @P     @`     @p     @     @     @     @fffff@fffff@     @     @     @      @     @fffff@@      @(     @0     @8     @@     @H     @P     @X     @\     @h     @p     @x     @     @     @@     @     @     @     @     @@@     @     @     @     @     @     @      @fffff@@      @(     @0     @8     @@     @H     @Nfffff@[33333@`     @h     @p     @x     @     @     @33333@@     @     @     @     @     @     @     @     @     @     @     @      @     @     @fffff@#33333@(     @0     @8     @@     @D     @P@X     @`     @h     @p     @x     @     @     @@     @     @     @@@     @     @     @     @     @噙@33333@     @      @     @     @     @33333@333333@8     @@     @H     @P     @X     @`     @h     @p     @x     @     @33333@     @     @     @     @     @     @     @љ@     @     @     @     @     @      @     @     @     @fffff@)@0     @8     @@     @H     @P     @U@h     @p     @x     @     @@     @     @     @     @     @     @     @     @     @ٙ@     @     @     @     @      @@     @     @@)@0     @8     @@     @H     @Y@`     @h     @p     @x     @     @33333@33333@     @     @     @     @     @     @     @     @     @噙@fffff@     @      @     @     @     @      @(     @0     @A@H     @O33333@X     @`     @h     @p     @x     @~fffff@@     @     @     @     @     @     @͙@fffff@     @     @     @33333@33333@     @      @(     @0     @8     @<     @Q@X     @`     @ffffff@s33333@x     @     @     @     @     @     @     @     @fffff@@     @     @33333@ᙙ@     @     @     @      @     @     @     @      @9@@     @H     @P     @X     @^fffff@jfffff@p     @w33333@@     @     @     @33333@@33333@     @     @     @     @     @     @     @홙@@      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @jfffff@p     @x     @     @     @33333@     @     @     @     @     @@     @     @     @     @     @
fffff@     @     @fffff@)@0     @8     @@     @H@P     @X     @`     @h     @p     @     @     @     @fffff@     @     @     @     @     @     @     @@33333@     @     @     @      @     @33333@@      @(     @0     @8     @@     @H     @L     @Zfffff@`     @h     @p     @x     @     @     @     @     @     @     @33333@     @     @     @     @     @陙@     @     @      @     @     @     @      @%@9@@     @H     @P     @X@i@p     @x     @     @     @     @     @33333@     @     @     @fffff@33333@     @     @     @     @     @fffff@@     @     @      @(     @,     @;33333@@     @H     @P     @X     @^fffff@h     @p     @x     @33333@@     @     @     @     @     @     @     @     @     @     @     @     @fffff@      @     @     @     @      @(     @0     @8     @@     @D     @Rfffff@X     @`     @h     @p     @x     @     @     @     @     @     @     @     @@     @     @     @33333@      @     @     @     @@*fffff@0     @8     @@     @H     @P     @X     @k33333@p     @x     @     @fffff@     @     @     @     @     @     @     @     @噙@     @     @      @     @     @     @     @fffff@@     @      @$fffff@(     @,     @0     @333333@9@<     @@     @D     @H     @L     @P     @S33333@Y33333@\     @^@e@h     @l     @p     @t     @x     @|     @@fffff@     @fffff@     @     @     @fffff@     @@     @     @     @     @     @     @33333@     @     @     @     @     @     @     @fffff@fffff@33333@@@     @     @     @     @      @$     @(     @,     @0     @4     @6     @<@@     @C33333@M@P     @T     @X     @\     @`     @d     @h     @l     @p     @s@|fffff@     @     @     @     @     @     @     @     @fffff@     @33333@@     @     @     @     @33333@33333@     @     @     @     @     @     @     @     @癙@33333@     @     @     @     @      @     @     @     @     @     @fffff@      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @`     @d     @h     @l     @p     @t     @vfffff@     @     @     @     @     @     @     @     @     @     @     @@@     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @      @33333@	33333@     @     @     @     @     @      @$     @)33333@*@133333@4     @8     @<     @@     @D     @H     @L     @P     @T     @V@a33333@d     @h     @l     @p     @t     @x     @|     @     @     @33333@     @     @     @     @     @     @     @     @@     @     @     @     @     @fffff@@     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @33333@      @$     @(     @,     @/@4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\fffff@`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @33333@@     @     @     @     @     @fffff@     @fffff@     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @@     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @vfffff@}@     @     @     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @33333@@     @     @     @     @     @     @@     @     @     @      @     @     @     @fffff@33333@     @     @      @$     @(     @,     @.@8     @<     @@     @B@L     @P     @T     @X     @\     @`     @c@l@p     @t     @x     @|     @     @@@     @     @     @     @     @     @     @     @     @fffff@33333@     @     @     @     @     @     @     @ݙ@     @     @     @fffff@@     @     @     @      @@     @     @     @     @     @ fffff@"     @,@0     @4     @8     @;33333@H     @L     @P     @T     @X     @\     @`     @d     @ffffff@l@p     @t     @x     @|     @     @     @     @@@     @     @fffff@     @     @     @     @     @     @     @     @     @fffff@ə@     @     @     @     @     @     @     @     @     @     @     @     @ fffff@     @     @     @     @     @33333@     @      @$     @'@0     @4     @8     @<     @@     @B     @L     @P     @T     @X     @\     @`     @d     @ffffff@x     @|     @     @     @     @     @     @     @     @fffff@@     @     @fffff@     @     @     @     @     @     @@@fffff@     @     @     @     @     @@     @     @     @     @      @     @@     @     @     @     @      @)33333@,     @0     @4     @8     @;@H     @L     @P     @T     @X     @[@`     @d     @h     @l     @p     @t     @w@fffff@     @     @33333@fffff@     @     @     @33333@     @     @     @     @     @     @33333@     @     @     @     @     @     @fffff@33333@     @     @     @     @     @33333@@     @     @     @     @     @     @      @$     @(     @,     @0     @4     @6@D@H     @L     @P     @T     @`@d     @h     @l     @p     @r@y@|     @     @     @     @     @     @     @@@     @     @@@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @      @$     @(     @,     @0     @8@<     @@     @D     @I33333@L     @P     @T     @X     @\     @`     @bfffff@hfffff@l     @p     @t     @x     @|     @33333@fffff@     @     @     @     @     @     @33333@fffff@     @     @     @     @     @@     @     @     @     @     @     @fffff@     @@     @     @     @33333@@     @     @     @     @     @     @@)@,     @0     @4     @8     @;33333@D@H     @L     @P     @T@X     @\     @`     @d     @h     @l     @p     @t     @w33333@|     @     @     @     @     @fffff@fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @@fffff@     @     @     @@      @$     @(     @,     @/@4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @b     @l     @p     @t     @x     @|     @     @     @     @@     @     @     @     @     @     @     @fffff@fffff@@     @     @     @     @     @fffff@fffff@     @@     @     @     @     @     @     @     @      @     @@     @     @     @     @33333@$@(     @,     @0     @4     @8     @<     @@     @B@Hfffff@L     @P     @T     @X     @\     @`     @h@l     @p     @t     @x     @|     @33333@     @     @     @@     @     @     @     @     @     @     @@     @     @     @fffff@fffff@     @     @     @     @     @     @     @@33333@     @     @     @      @     @
33333@     @     @     @     @@*     @,     @0     @4     @8     @<     @>@I33333@L     @P     @T     @X     @\     @^                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @ěT@ěT@u!@ěT@'RT`@d8@-w1@ae@@N@o@@4@e@h	ԕ@o@o@e+@e+@ᰉ'R@R<6@e@	@?@F
L0@@@	ԕ+@TɅ@@\)@>BZc@&@,@	k@fA@>BZc@~"@1&y@1&y@C]@C]@1&y@C]@I^@fB@͞&@g	@0
@C,z@jf@P{@0U2a|@x@\)@r Ĝ@	ԕ+@&@fffff@1@u@䎊qj@?@Z@n.3@S&@9@C,@h	ԕ@e@-w1@@N@@N@@N@
qu@U=@쿱[W@u@ݗ+j@ce@>@u"@/w@ce@ݗ+j@IQ@u"@C,zx@ߤ@@/w@ݲ-V@쿱[W@[6@e@h	ԕ@A [@RT`e@\)@V@E@ 4m@N;5@6Fs@W@qA [@Z@_ح@)^@Ƨ@Vu@ξߤ?@'/@W'@#9@ԕ*@˒:*@o i@ [7@H˒@5Xy@E@	@tj~@G)^@)B@kP|@
@ 4m9@ ě@$xG@ޞ@e+@H@c	@p:@ [7@@xl"h	@kC,z@dtSM@W
=p@F&I@6Fs@)x@iB@
(@O
M@	k~@	 @:S@mV@W@Q@N;5X@4D@,C@&'@O;d@]cA@@Ov`@@_o@@-V@ěT@tj@@{J#9@[W>@u\(@fA@Nqi@7rG@&x@Ϫ͟@
=p
@D@+I@͞&@-V@o @l1&y@2m\@#
=p@e+a@#@K]@%F
L@fffff@n@@o@l!-@IQ@o@cS&@[qu!@;s@)ᰉ'@ hۋq@%1@fB@v_ح@aGz@S*0U2@Rm@En/@*JL@+j@	k~(@ C@@D*@̘_@	k~@ ě@}Vm@K]c@kP{@^쿱[W@S҉@;/V@2-V@-V@)lD@&,<@$@0
)@@!.@RT`e@9@,<@ξߤ?@Vl!@g@<쿱@RT`e@tj@
M;@vz@T*1@Ca@N@>
(@;m]@;/V@9"`@8l"h	@'	k@kP|@bM@
W'@E@C\@'@
=p@!-w1@6C@_p@/{J#@#w@	k@2a|@<64@y@ra|Q@oiDg8@m(@kjf@eڹ@a'R@aae@]+j@S*0U2@Ik~(@Eݗ@As@>
(@8YJ@1iB@,C@&fffff@"`A@ ҈p@o@iB@u"@>BZ@_F@@%2@Q@D@r Ĝ@߾vȴ9@e+a@ԕ*1@R@_o @ɅoiD@@s@/V@4K@4֡a@lD@e+@vȴ9@Q@@m@wXe@rW@p@ka@@i*0U2a@g8}H@I^5?}@;m]@%F
L0@ -
@u"@@)y@iB@fffff@u"@0
)@+j@+j@I^5?@n.@+jg@
(@*0U2a@wkQ@@ߤ@@\N@\u"@L@JL/{@1&x@-
qv@+C]@*fB@-V@-(@'&@ [6@	@҈p;@1&@u%@ݘ@$tS@hr @1&x@84֡@nP@ n@vȴ9X@p
=@)@Fs@%F
L@SMj@33333@GE85@{@v@v@iDg8@U=@,<@%1@ߊ	@sP@As@:@Ƨ@]cf@<64@}Vl@W@"h	ԕ@͞&@O
@,<@n@C%@@@u?@r{m@ql@nO;@lVϪ@hr Ĝ@c
=p@ae@Xy=c@TE@I^5?}@GK]d@Dtj@?b}V@8}H@2s@/ hۋ@.O;@)y@!|Q@ [6@	@S@>BZ@U@@E@@N@	ԕ*@      @KƧ@GE85@J@o@MjO@SMj@s@A [@2X@@3@|Q@ܬ1&@C,zx@Ϫ͞@nO@qu!@حU@ќu@ɅoiD@Ϫ͞@*0@ԕ*1@т@@g8}@b}V@j~#@RT`e@'R@-
@	@!-w1@Q@W>6z@y=c@Xe,@Xe,@+j@bM@+j@*0@R<6@:)y@|@bM@As@@xF]@u%F@84֡@{~$@o4֡a@nc	@m8Y@l!-w@l<쿱@k6z@j0U2a|@hۋq
@hr Ĝ@g	k@eO
@dZ1@cS@aGz@`-
@_?@^%@]-V@\ߤ@@YJE@W+j@WXe,@R䎊@J#9@GzH@F@DJM@>6z@1iB@*g	@)@(ۋq
@(Xy=@'-@&IQ@$/@!e@#	@!.H@ [6@u%@|@sh@4J@@o @
#9@S@/V@{@"h	ԕ@~"@A@wkQ@u%@e+a@Ϫ͞@*0U@ξߤ?@Ƨ@ԕ*@āo h@7Kƨ@@s@@$tS@>B@!.H@m\@XbM@!.@J@*0U2a@RT`e@&@RT`e@,@n.3@,=@N;@u%F@Fs@u@@rGE9@@=p
@zH@a@N@4m9@{/V@usg@j0
@eu@]}H@Uᰉ@S*0U2@P|@J=p
@Eݗ@B@As@64K@,VϪ@($xG@'&@'8}H@&IQ@#n.3@"3@iB@W>6z@t@a@O@*1@)^@
jOv@I^5?@:)z@
	 @	^5?}@K]c@@@+I@$/@
L/@n/@n/@ݗ@m\@o i@2W@tj@@j~@@N@t@˒:*@ěS@,zxl@)_@YJ@rG@?|h@1&y@Xy=@tSM@-w1@}H@qu!@R<6@qiC@n/@tj@I^5@zxl"h
@r{m@ql@ix@b}Vm@]cA @Vt@C\N@@6@>6z@<64@73@4֡a@0{@-U=@&IQ@ 	k@!-w1@ 'RT`@쿱[W@-V@C,zx@Fs@
(@ ѷ@$/@b}V@m\@PH@m]@G{@@SMj@u!S@t@C]@g	@ڹ@@N@҈p:@:@/{J#@W'@Ƨ-@&IR@D@ěT@C%@zG{@v_ح@qu!S@h>BZc@f,<@b}Vm@LcA \@%1@#S&@!-w1@1&@PH@Fs@@	ԕ*@
.H@
(@
g@
ڹ@
҈p;@
ΤT@
]cA@
84֡@
Q@
w1@
&@
xF@
TɆ@
$/@
M:@
=p
@
ݗ@
:S@
:S@
xl"h	@
iᰉ'@
dZ1@
["`B@
Q_p@
N;5X@
C@
?|hs@
8Q@
4m8@
2ᰊ@
.2X@
-w1@
)lD@
#n.3@
bM@
u%F@
YJ@
Q@
{J#9@~$@Y|@E@D@P{@lC@%1@ܑN;@bM@m@+@:@W'@vȴ9X@/V@C-@lD@!-w1@%@=K^@6C@PH@S&@o @!R<@L_@	 @ ѷ@eO@#@_o@tj@~m\@~m\@~"@}H˒@.H@vFs@e+a@cS@cS@a@N@Y+@N;5X@JL_@H@H@GE84@G)^@Fs@;A@+I^@#wk@wkP@tj@	7KƧ@{J#9@"@lC@l"h	@GE85@@(@>@T`d@W'@n@Xy=@V@R<6@Ov_@n/@}H˒@z>B@y	k~@u\(@p:~ @dZ1@W>6z@N_o @D*0@&@*0@*0U2@
O;dZ@
O;dZ@@'/@	k~(@F]c@
$t@
Vl!@
s@
@
-V@
Q@
x@
	k@
A [@
@N@
Ft@
@
&@
*0U@
@
*0@
@
K]@
Xe@
U=@

=p@
h	ԕ@
-
@
-V@
vȴ@
ݗ+k@
u@
@
YJ@
@
ѷX@
xF]d@
u%F
L@
qA [@
o@
ffffff@
]ce@
["`B@
Z1'@
Y|@
XU@
Vaf@
QX@
OAs@
JW'@
B@
<j~#@
84֡b@
12W@
)^@
($xG@
($xG@
'RT`e@
#n.3@
	@
%@
1&@
R<6@
@
:)y@
4J@
ߤ?@
	7KƧ@
I^5@	˒:)@	!.H@	~$@	(@	 ě@	oiDg8@	(@		ԕ+@	+a@	,<@	+a@	ᰉ'R@	u!@	҈p;@	/w@	
qu@	$@	Ʌoi@	ΤT@	̘_@	˒:)z@	D@	Ƨ@	/{J#@	˒:)z@	]cA@	@	y@	Õ$@	~($@	W@	r@	d7@	L/{J@	-
@		k@	Q@	,<@	$/@	@	@	k~(@	F]c@	hۋq@	|#x@	w+@	tSMj@	sMjO@	sMjO@	r䎊q@	j~"@	b}Vm@	ZY@	Y>BZ@	Y|@	VϪ͟@	Rp:@	O
M;@	M5Xy>@	Jn@	E@	<64@	;dZ@	9XbM@	43@	0
(@	/O
M@	)^@	$?@	U=@	O;d@	*0U2@	Mj@	L_@	~($x@	$/@	 ѷ@	      @hr@l"h	@t@B@Z@"`B@ѷX@+@͞%@cA \@Q@@6@S&@^5?|@D@~($@4֡b@ᰊ@Vϫ@
qv@0U2a|@-V@Z@)^@o @@@ߤ?@@L_@ڹY@ԕ*@k~(@#@S&@o hی@|?@eO
@be+@\(\@Vt@R䎊@Ks@D*0@B\(@*0U2a|@,=@u%F@@O
M@tj~@@N@L_@'/W@oiDg@\N<@@l"h	@!.I@@҈p@ݗ+j@ܑN;@+@a@O@@4m@v@3@a|Q@?|h@{@ ě@2X@H@
qv@w1@B@TɅ@/@_F@C%@k~(@%2@}ڹZ@x73@p
=q@l!-w@Xe+@Ov_ح@L@L@L/{J#@K]cA@K]cA@K)^	@Jn@L_@I@G)^@B@0'RT@%zxl"h@"wkQ@%@sh@hr @@C%@'/@?@ IQ@G{@=b@!.I@@-V@(@P{@x@A [@@N@>@1'@l!-@҈p:@*0U@ΤT@ΤT@+@jOv@/{J#@D@ɺ^5?}@@@o i@s@4m@jf@͞&@*0U2a@tSM@h	ԕ@	@}H@,<@@@+J@Z@bM@ڹY@}H˒@|Q@{~$@{~$@{J#9@zG{@y(@v_ح@tj~@r䎊q@qA [@o-V@mC\@lC@iᰉ'@b@4@a@N@aGz@`
qu@ZY@Rm@QN;5@N_o @I@Ca@N@:)_@6}Vl@-w1@(@ [6@ߤ@@u"@@S&@
M:@#@F]c@.H@($x@\N<@F@+jg@PH@s@D@O;@쿱[W?@JL@e@Z@e+@Gz@o@6@ק&@2a|@s@D@W'@g8}@H˒:@)y@#w@Q@}H@?@[W>6@>B[@zxl"@a@@lD@xF@u@vȴ@@@zG@Mj@Vu@@L_@ԕ*@o h@%2@˒:)@{~$@z>B@w+@cZ@XD*@WsPH@W>6z@WsPH@TE@Q@P{@R䎊@PH@OAs@NT@KƧ@K:)z@KƧ@JW'@IoiD@IQ@Dg8}@C@A@=<64@:)y@9XbM@5'0@*0
@IQ@_o@PH@PH@e+a@+j@R<6@rGE9@1&x@YJ@{J#9@@o hی@b}V@E@	k~@{m@8Y@빌~($@ᰉ'@B@@	k@lC@@fffff@1.@A [@d8@҈p;@cA @ ѷY@/w@ݗ+j@>@$@JE@Ϫ͟@l!-@՛=K@jOv@v@#w@?@֡a@3@|@33333@m8@g	l@-@U2a|@{J#:@}Vl@v@q@1&@$tS@rGE9@@{J#9@.H@u\(@p@o hۋ@n.2@m\@lVϪ@l"h	ԕ@jJL@g	k@ffffff@d7@a'R@_o@_;dZ@^@^ ѷY@\>@\?@ZQ_@XbM@UϪ͞@UfA@UϪ͞@T,<@Np:~@K:)z@H@F
L/@D2W@C\N@B74@=K]@9D@9#w@5Xy=@2m\@12W@.H@+a@@&L/{J@#n.3@!.H@%@kP|@*0U2@nO@@qi@q@+I@u%F
@˒:)@H˒@hr@=b@\(@D@䎊q@@C\@hr!@@	@d8@ޞ@+@֡af@2a|@ԕ*1@a@O@N;5@v_ح@Õ$@5Xy@4m@g	l@r@*0U2a@L/{J@!-w1@6C@_F@@@*0@Xe,@R<6@O
M@L_@&I@S&@n/@JM@tj@n.@4m9@~"@~\N<@}E@}Vl!@}!.H@}Vl!@|hr@|#x@{~$@yrGE8@t!-w2@n.2@jfB@jOv`@h>BZc@ceO@aGz@_حV@^iB@\>@\?@Y|@TE@RT`d@QN;5@O;dZ@L@LcA \@KƧ@H@DS@?H˒:@<64@:)y@:)y@:S&@:S&@8YJ@1-@-V@,1&y@*͞&@)lD@)@*0U2a|@)*0U2a@'/V@'RT`e@%S@,=@e+a@Fs@)^@\(@
(@C%@+I@S&@F]c@nP@@˒:)@G{@-
@F]d@!-w2@-V@C\@Dg8~@唯O
@%1@e@@N@ߤ?@?@ۋq@Q_@Q_@1'@JE@bM@l!-@fA@`A7@/{J#@n@]cf@ěS@
(@4֡b@J@v@lD@Xy=@\)@/V@TɆ@9@S&@S&@`A@R<6@ae@'RT`@쿱[W@S@qu!@@ᰉ@u@O;dZ@=p
@	 @n/@~($x@yrGE8@v!.I@t!-w2@jg	@fA@e@de@dqj@cZ@b}Vm@]ce@Vt@Rp:@RT`d@RT`d@RT`d@PH@PH@O;dZ@OAs@N_o @Fs@43@.zG@+I^@)lD@(@%F
L0@%F
L0@%u@%u@%u@$tSM@&@'RT`e@$/@u@L_@!R<@	ԕ*@K]d@$t@?@rGE8@F]d@kP@%F
L@SMj@D@fA@e@Gz@A7K@;dZ@iB@iB@ݗ+j@iB@ܑN;@ۋq@>BZ@JE@+@حU@t@v_ح@_o @s@ɅoiD@Ƨ-@m\@&IR@4m@
(@)@Vϫ@U=@$xG@U=@C,zx@qu!@u%F@*0@Xe,@L_@\(@(@L_@oiDg@:S@}E@}H˒@|hr@z>B@xF]d@v+jg@sE@poiDg8@nO;@n.2@mhr!@l[W?@kP{@h>BZc@f,<@f1.@_Ft@Xe+@Vaf@Q_p@P|@N_o @L/{J#@IoiD@E@BZc@>vȴ9X@73@43@0{@,>B[@*0
@)@(@&@!o@ ěT@Q@u%@*0@N;6@C%@p:@ݗ+@$/@o h@@4n@o hی@ $tS@ -
@ 䎊q@ iB@ D@ O;@ .2@ c	@ C\@ (@ "h	ԕ@ ~"@ Dg8~@ +a@ |Q@ 
qu@ ?@ e+@ @ >6z@ t@ ԕ*1@ T`d@ +@ 5Xy>@ cA \@ /{J#@ ˒:)z@ )^@ ,zxl@ s@ C@ n@ @ ^5?|@ E@ E@ z@ 4K@ 4K@ ?@ g	l@ v@ B@ ^@ /V@ IQ@ 1@ S@ S@ F
L0@ TɆ@ n.3@ -
@ u@ -V@ Ov_خ@ 1&@ ߤ@@ 6C@ Xe,@ Ov_@ $/@ u@ bM@ rGE9@ Mj@ (@ @ @ L_@ k~(@ Fs@ +I@ $/@ oiDg@ ?@ u%F
@ ѷX@ .H@ }E@ {~$@ z@ xl"h	@ wkP@ weں@ v!.I@ u!R@ tj~@ tSMj@ sPH@ qu!S@ p
=q@ n.2@ l[W?@ lC@ kC]@ kP{@ g	k@ b}Vm@ ae@ a|Q@ a@N@ _o@ ]/w@ YJE@ Vaf@ Vt@ Ov_ح@ M:@ KƧ@ Jn@ GzH@ A@ ?@ >ߤ?@ ;dZ@ 9~($@ 9XbM@ 8)@ 8}H@ 7Xe@ 5?@ 4֡a@ 5?|h@ 5'0@ 4m8@ 333333@ 1o@ /Vϫ@ .H@ -
qv@ ,q@ *0U2a|@ ',@ #n.3@ !ae@  -
@  'RT`@  -
@  -
@ u@ ߤ@@ 6C@ @ *0@ O;d@ @ Ov_@ sP@ rGE9@ ߤ?@ !R<@ 
@ 
O;dZ@ L_@ 
qiC@ Fs@ ?$tS?\(?D?t?C\?C,z?>BZc?e?%1?Gz?u!?
qu?;dZ? ѷY?ۋq?Q_?+?8YJ?ԕ*1?_o ?8YK??j~#?)_?Y}?)?rG?Xe?'0?g	l?{?O
M?1?zG?q?1&y?d7?&?zxl"h?-V?@?O;d?*0?tj~?Mj?L_?ڹY?oiDg??~$t?{m]?xl"h	?v_ح?vȴ9X?y(?zxl"h
?y(?zxl"h
?xl"h	?u%F
L?p:~ ?n.2?m8Y?l"h	ԕ?j~"?dZ1?^?]ce?[6?YJE?W>6z?U=K?SMj?Q?O;dZ?MjOv?L/{J#?JL_?I^5?}?H˒:*?E?C$?@NU?9D?73?5?|h?1o?/v?-w1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @@KQ@@Kg@@KA [@@KA [@@KA [@@K$@@K$@@K@@K@@KA [@@KC]@@K@@K$@@KA [@@KA [@@KA [@@Kg@@KA [@@KA [@@KC]@@KC]@@K@@L1&y@@LL_@@L!-w2@@L(\@@L?@@L<쿱@@L<쿱@@L,<@@L@@K\N@@L1&y@@LxF@@LL_@@LM:@@Lm8@@LS@@Lzxl"@@L1&@@L[W?@@LD@@M`A7L@@MM:@@MM:@@MO
@@MO
@@M!R@@M=K@@Mb@@N@@N$/@@N($x@@N.2@@N5?|@@N?@@NH@@NR<6@@N\N<@@N\N<@@Nfffff@@NiB@@NiB@@Nz@@N}Vl@@N%@@Nqi@@NO;@@NT@@N}Vl@@N6z@@N'@@Nߤ?@@O
=p@@O)^@@O+I@@O8}H@@OO
M@@O\(@@Oo@@OsPH@@Oy@@O|hs@@O$tS@@O3@@O䎊r@@P*0@@Pu!@@P-
@@PѷX@@Q#w@@QrGE8@@Qn.@@Ru%F@@R\(@@R<64@@Stj~@@U2a|@@W.H@@Z<64@@a'R@@f+J@@lxF@@sU=@@ hۋ@@?|h@@Z@@YJ@@~"@@H˒@@|@@4J@@N;6@@d7@@,<@@L/{J@@	@@rGE9@@xl"h
@@!R<@@s@@4֡a@@䎊q@@*1@@oiDg@@-V@@0
)@@d7@@Á@@%1@@*0U2a@@ˎMj@@@@A@@ hۋ@@+j@@XbM@@iB@@C,@@@@@@?@@֞@@rG@@؝IQ@@ۯ@@C\@@H@@4֡a@@حV@@䎊r@@$xG@@&x@@e+a@@7Kƨ@@	 @@~"@@C,@@㯷@@%2@@I^5?@@/w@@Ϫ͞@@BZc @@%@@x@@v@@4֡a@@y@@@@oiDg8@@$tT@@*0U2a@@e+a@@馵(@@䎊@@u%@@tj~@@땁$@@E@@!-w2@@>@@%F
L@@?|h@@sg@@p
=@@w1@@힃%@@ ѷY@@($x@@L/{J@@qi@@@@2X@@}Vl@@m\@@
=p@@,@@b}V@@r@@阮&@@-V@@[W>@@/V@@zH@@@@fA@@+@@ﴢ3@@?@@rG@@
qu@@bM@@*0U@@>BZc@@D*@@[6@@n@@𖻘@@-
@@)@@)@@{@@{@@
(@@@@C@@C@@ ѷ@@@N@@rGE@@$/@@7KƧ@@TɅo@@XbM@@e+a@@e+a@@hr @@oiD@@񰉠'R@@B@@ԕ*@@@@"`@@@@@@@@.H@@Ov`@@-V@@3@@@4n@@:)y@@M@@a|Q@@h	ԕ@@kP|@@{m@@@4@@wkQ@@}Vm@@W@@sP@@m\@@PH@@"`B@@)^	@@)^	@@9@@S@@S@@]cA@@{J#9@@wk@@~($@@~($@@@@҈@@%2@@%2@@g@@@@s@@\N@@J@@\N@@1&y@@ߤ@@@@@,<@@/{J#@@,<@@cA \@@g8}@@zG@@~($x@@qj@@쿱[@@Z@@@@@@o i@@Q@@5Xy>@@5Xy>@@IQ@@O;dZ@@L_@@F
L0@@sg@@b@@(@@oiDg@@ڹ@@
(@@;5X@@'@@
=p@@H˒:@@&@@&@@/V@@r Ĝ@@U@@
(@@҈p@@F@@e+@@$/@@e+a@@@@B@@iB@@lD@@s@@s@@6C@@p:@@^5?|@@@4n@@=p
@@䎊q@@m@@m\@@@N@@Q@@~($@@L_@@64@@?@@C,zx@@PH@@M:@@PH@@`d@@tSM@@C@@j~@@@@u@@84֡@@L_@@$/@@=K@@-V@@sh@@8Y@@@@,=@@ ѷY@@ ѷY@@ ѷY@@Ov_@@1.@@E@@l!-@@ߤ?@@ߤ?@@Fs@@ hۋ@@!-w1@@8}H@@E84@@eں@@	@@@@͞@@@A *0U@A A7K@A bM@A 'RT@A F@A F@A C@A $tT@A@N@A4J@A^@Ak~(@An.@Ao@A&IR@A0U2a|@AGE85@Ah	ԕ@A>B@AG{@A74@AS&@A&@A~$@A$@Aq@A5Xy@Aݗ+k@AC]@As@AJ@AL_@A64@Aq@A#@A#@Ao h@AzG@Ao h@Ao h@AN;@A3@ATɆ@A[W?@AZ@A>B[@A'0@A*0@A*0@AS&@A%@AXy=@A=K@A+j@AR<6@A@A@At@A1@A)^@A,@AAs@Aeں@AsPH@AsPH@Ay@A4m@A	@A@A6@ANU@AXy=@AU2a|@AXy=@A_F@Ahۋq@AU@A`A7@A{@A4֡b@A\)@A	$/@A	rGE@A	0
)@A	Dg8~@A	(@A
-V@A
6C@A
6C@A
@4n@A
JL@A
W'@A
kP|@A
~"@A
ݘ@A
ᰊ@A
>B@A
@A
,<@A
c	@A
74@A
m\@A҉@AnP@A	@A&@A33333@A6z@AJ#9@Aa@N@Aa@N@Atj~@A{J#9@Aq@A|@AC]@Ag@Ag@AC]@A$@As@Aߤ@@A`d@Aqj@AN;@Aqj@A*1@A1&@A?@AZ@A֡a@AZ@A
O;dZ@A
w1@A
U=@A
E@AOv_@A($x@AE@AYJ@AR<6@A_ح@A}Vl@AA@AϪ͟@A+@Aߤ?@AMj@AXe@A.H@AXe,@A$tS@A?@A/V@A     @AH@AXy=@A_F@Ahۋq@AC@A ѷ@A_p@AA [@ATɅo@Ak~(@Ao@Al@AD@A@A>BZ@An@A)y@A~"@A<64@AsP@A ѷ@AG{@AC,@AD@As@AC%@AF]c@Aa@N@Ag	l@AxF]@Awk@AƧ@A%2@An.@ASMj@A쿱[@AɅoi@AɅoi@AZ@A:@A!.H@A(@A84֡@AY|@AڹZ@A@Av@AH˒@Ab@A
qv@AS@Aᰉ@A(@Aڹ@A ѷY@A
L/@A
(@AzG@Au@A!R<@A+jg@A.2@A5?|@AE@AH@AH@A%@A@AϪ͟@A"@A hۋ@A,@A,@A+I@A'/W@A4֡a@AXe,@AlC@A4m@AO;d@A?@AzH@AK]d@AF]d@A ě@A73@AQ@A-
@AU@A4m@Aۋq
@A{@A ѷ@AJE@A~($@AR<6@Au@A(@A|@A^5?}@AN;6@Aᰉ'@AI^5@A&IR@A&IR@A)y@A0U2a|@A6C@A@4n@Ad7@A\(@A@A)_@A,<@A͞&@AG{@AC,@Am@A74@A9@AF]c@AP{@AZ@AZ@AdZ@AQ@A5Xy@AC]@Ag@As@An.@A1&y@AxF@AQ@A2W@APH@A]ce@A#@AN;@A3@AO
M@A*0@A/w@A5Xy>@A5Xy>@A<64@A`A7L@A$/@A+j@A@Aᰉ@AoiDg@A_o @AE@A%@Ax@AFs@A)^@A4֡a@AO
M@AH˒:@ART`e@ART`e@AO;d@A͞@AzH@A3@Ao @A@A F]d@A :~ @A A7K@A _F@A u%F@A {@A {@A $tT@A!rGE@A!#w@A!*0U2a@A!A [@A!A [@A!JE@A!^@A!@A!'R@A!^5?}@A!D@A!_o@A!>BZ@A!lD@A!.H@A"I^5@A"e+@A")y@A"6C@A"^5?|@A"nO@A"@4@A"S&@A"0
@A"wkQ@A",<@A" ѷ@A"c	@A#C,z@A#F]c@A#@N@A#W>6z@A#S@A#]cA@A#qu!@A#~$@A#eO@A#Mj@A#$@A#wk@A#ߤ@A#U=@A#S@A#@A#6@A#6@A#Z@A#6@A#6@A#a@@A$tj@A$%1@A$(\@A$C,zx@A$m8@A$1&@A$[W?@A$Ʌoi@A$*0@A$֡a@A$*0@A$>B[@A%'0@A%Vl!@A%m\@A%M:@A%M:@A%sh@A%8Y@A%Ϫ͞@A%@A%?@A%E@A%C\@A&4K@A&H@A&iB@A&}Vl@A&af@A&m\@A&Ϫ͟@A&Fs@A&Fs@A',@A'+I@A'.H@A'1@A'As@A'RT`e@A'_o@A'{J#:@A'$tS@A'3@A('RT`@A(bM@A(r Ĝ@A('RT@A(n@A(YJ@A(-
@A(tj@A(@A(9Xb@A(4m@A(ѷX@A(F@A({@A) ѷ@A)	k~@A)@A)+@A)#w@A)0
)@A)JE@A)e+a@A)k~(@A)7Kƨ@A)'RTa@A)|@A)_o@A)@A*@A*-V@A*3@A*:)y@A*JL@A*T`d@A*xl"h
@A*ݘ@A*ᰊ@A*>B@A*Y@A*͞&@A*m@A*74@A+'/@A+&@A+33333@A+C%@A+S@A+W>6z@A+g	l@A+g	l@A+g	l@A+{J#9@A+$@A+ݗ+k@A+@A,1&y@A,tj@A,/{J#@A,64@A,9XbN@A,64@A,2W@A,9XbN@A,?@A,C,zx@A,M:@A,`d@A,cA \@A,cA \@A,q@A,q@A,zG@A,C@A,qj@A,*1@A,N;@A,3@A,O
M@A,?@A,?@A,j~@A,?@A,7@A,֡a@A,u"@A,u"@A,@A,JM@A,Z@A,D@A-:@A-'0@A-*0@A-Q@A-(@A-5Xy>@A-5Xy>@A-84֡@A-<64@A-F
L0@A-Vl!@A-sg@A-@A-n/@A-8Y@A-@A-(@A-E@A-!.@A-ڹ@A.
L/@A.Ov_@A.1.@A.;5X@A.L/{J@A._ح@A.p:~@A.z@A.qi@A.@A.af@A.-@A.T@A.m\@A.ߤ?@A/Ft@A/
=p@A/Ft@A/Xe@A/'/W@A/>6z@A/As@A/KƧ@A/_o@A/{J#:@A/&@A/O;d@A/-V@A/&@A/3@A/@A/@A/rGE9@A0*0U@A06@A0'RT`@A0A7K@A0H@A0NU@A0[6@A0hۋq@A0y=c@A0'RT@A0{@A0TɅ@A0@@A0ۋq
@A0$tT@A1rGE@A1+@A1_p@A1 [7@A1&x@A17KƧ@A1Dg8~@A1A [@A1Gz@A1A [@A1Gz@A1ae@A1hr @A1rGE8@A1x@A1u@A1|@A1X@A1^5?}@A1B@A1'R@A1X@A1X@A1^5?}@A1@A1D@A12W@A1D@A1o@A1@A1>BZ@A2n@A2u%F@A2	 @A2䎊@A2-V@A2:)y@A2T`d@A2Zc@A2nO@A2ݘ@A2S&@A2wkQ@A2ᰊ@A2wkQ@A2 ě@A2L/{@A2L/{@A2n@A2,<@A2sP@A2sP@A2 ѷ@A3&@A333333@A39@A3=K^@A3J#9@A3S@A3jf@A3n.3@A3{J#9@A3A@A3S@A3*0U2@A3S@A3*0U2@A3@A3m]@A3E@A3~($@A3m]@A36@A35Xy@A3C]@A4/{J#@A464@A4%1@A4?@A4g8}@A4g8}@A4m8@A43@A4#x@A4[W?@A4[W?@A47@A4@A4?@A4?@A4Ʌoi@A4@A4>B[@A4*0@A4u"@A5qu"@A55Xy>@A55Xy>@A5?|h@A5Vl!@A5sg@A5sg@A5zxl"h@A5sg@A5!R@A5=K@A51@A5-V@A5n/@A5\(@A5@A5b@A5
qv@A5S@A5oiDg@A5C\@A6
(@A6!R<@A65?|@A6.2@A65?|@A6?@A68YJ@A68YJ@A6BZc @A6E@A6H@A6L/{J@A6E@A6Vu@A6c	@A6p:~@A6qi@A6%@A6qi@A6$t@A6,<@A6af@A6-@A66z@A6}Vl@A6'@A6@A6m\@A6A@A7 hۋ@A7@A6!.I@A6"@A6!.I@A7@A7
M;@A7@A7v@A7!-w1@A7$tS@A7'/W@A7+I@A74֡a@A78}H@A7O
M@A7RT`e@A7RT`e@A7RT`e@A7_o@A7y@A74m@A7O;d@A7@A7kP@A7vȴ9@A7vȴ9@A7@A7vȴ9@A7+@A7fA@A7fA@A7fA@A7;dZ@A7حV@A7@A7rG@A8     @A8
qu@A8@A8$xG@A8'RT`@A84m9@A84m9@A84m9@A84m9@A84m9@A8A7K@A8NU@A8[6@A8NU@A8U2a|@A8U2a|@A8hۋq@A8n@A8tj@A8-
@A8TɅ@A8F@A8`A7@A8	k@A9@A9rGE@A9rGE@A9rGE@A9_p@A9+@A9_p@A9+@A9_p@A9#w@A9A [@A9TɅo@A9^@A9XbM@A9e+a@A9rGE8@A9o hی@A9rGE8@A9b}@A9'RTa@A9l@A9l@A9|@A9|@A9l@A9D@A9"`@A9lD@A9.H@A9.H@A9.H@A:n@A:@A:s@A:䎊@A:䎊@A:@A:e+@A:&IR@A:0U2a|@A:0U2a|@A:6C@A:C\@A:C\@A:W'@A:T`d@A:^5?|@A:a|Q@A:a|Q@A:a|Q@A:a|Q@A:u%F
@A:0
@A:S&@A:@A:L/{@A:L/{@A:>B@A:}Vm@A:)_@A:䎊q@A:fB@A:c	@A:m@A:74@A:m\@A:m\@A;'/@A;"`B@A;33333@A;=K^@A;@N@A;F]c@A;C%@A;P{@A;F]c@A;P{@A;P{@A;P{@A;W>6z@A;]cA@A;g	l@A;qu!@A;jf@A;qu!@A;n.3@A;qu!@A;{J#9@A;@A;q@A;eO@A;Mj@A;wk@A;Ƨ@A;|@A;ݗ+k@A;҈@A;҈@A;%2@A;lC@A;%2@A;%2@A;C]@A;$@A;$@A;s@A;$@A;\N@A<L_@A<"h	ԕ@A<"h	ԕ@A<(\@A<Fs@A<M:@A<PH@A<cA \@A<j~#@A<m8@A<tSM@A<tSM@A<~($x@A<?@A<C@A<C@A<N;@A<S@A<TɆ@A<TɆ@A<TɆ@A<@A<@A<?@A<[W?@A<Ʌoi@A<*0@A<Z@A<Z@A<Z@A<Z@A<Z@A<E@A='0@A=*0@A=Q@A=qu"@A=5Xy>@A=F
L0@A=F
L0@A=O;dZ@A=`A7L@A=ce@A=jOv@A=jOv@A=w1@A=}H@A=$/@A=ڹZ@A=O
@A=Xy=@A=-V@A=sh@A=sh@A=H˒@A=cA @A=b@A=?@A=oiDg@A=,=@A=!.@A> ѷY@A>t@A>_o @A>
L/@A>@A>u@A>$/@A>.2@A>1.@A>E@A>L/{J@A>Vu@A>_ح@A>_ح@A>YJ@A>_ح@A>iB@A>Fs@A>af@A>T@A>}Vl@A>ߤ?@A>+@A>C-@A?@A?@A?@A? hۋ@A?
=p@A?
M;@A?
=p@A?)^@A?+I@A?1@A?8}H@A?8}H@A?>6z@A?>6z@A?E84@A?H˒:@A?O
M@A?RT`e@A?RT`e@A?RT`e@A?Xe,@A?Xe,@A?Xe,@A?Xe,@A?\(@A?\(@A?iDg8@A?o@A?|hs@A?|hs@A?{J#:@A?O;d@A?ݗ+@A?kP@A?$tS@A?	k@A?&@A?[W>@A?@A?@A?@A?˒:)@A?@A?fA@A?@A?;dZ@A?rG@A?+j@A@	ԕ+@A@
qu@A@
qu@A@     @A@F]d@A@
qu@A@$xG@A@-
q@A@1&x@A@-
q@A@4m9@A@:~ @A@4m9@A@:~ @A@>BZc@A@A7K@A@H@A@bM@A@oiDg8@A@n@A@@A@@A@@A@IQ@A@d8@A@9Xb@A@{@A@)@A@
(@A@ěT@A@F@A@@A@҈p@A@@A@PH@A@$tT@AA@AA_p@AA&x@AA#w@AA*0U2a@AA4J@AA:S@AA=b@AADg8~@AADg8~@AADg8~@AAJE@AAQ@AA[W>6@AAe+a@AAb}@AA~($@AAo@AAu@AAB@AA@AA@AAo@AAԕ*@AA>BZ@AAR@AA>BZ@AA@AAY}@ABu%F@AA.H@ABn@AA.H@ABn@ABI^5@AB	 @ABI^5@AB1'@AB&IR@AB#9@AB3@ABGE85@ABT`d@ABT`d@ABW'@ABa|Q@AB~"@ABݘ@AB\(@ABᰊ@AB}Vm@ABn@AB<64@ABn@AB@AB)_@AB`A@ABsP@ABC,@AB74@AB~@AB~@AB74@ABm\@ACS&@ACu%@ACu%@ACu%@AC	@ACMjO@ACdZ@ACn.3@ACn.3@ACn.3@AC{J#9@AC~$@AC~$@AC~$@AC@AC@AC~$@ACxF]@AC@ACA@AC@AC6@AC6@ACƧ@ACC]@ACg@AC$@AC@AC@ADn.@ADn.@ADxF@AD%1@AD,<@AD9XbN@AD?@AD?@ADC,zx@ADC,zx@ADM:@ADVϪ@ADM:@ADI^5?@ADPH@ADZ1@ADVϪ@AD]ce@AD]ce@ADm8@ADwkP@ADzG@ADo h@AD?@ADqj@AD*1@AD*1@AD쿱[@ADO
M@AD#x@AD7@AD>B[@ADe@ADE@AE:@ADE@AEo i@AEo i@AEV@AE(@AE5Xy>@AE2a|@AE?|h@AEL_@AEY|@AEVl!@AE\@AEce@AEm\@AEw1@AEp
=@AEM:@AE!R@AEhr!@AE!R@AEhr!@AEhr!@AE%@AE@AEsh@AEH˒@AE@AE@AE,=@AE,=@AEoiDg@AEE@AEC\@AF_o @AFzG@AFOv_@AF1.@AF8YJ@AFBZc @AFR<6@AF\N<@AF\N<@AF\N<@AF\N<@AFl!-@AFvȴ9X@AFIQ@AF%@AF$t@AFaf@AF6z@AF@AFQ@AF&I@AFm\@AFt@AFt@AF+@AF1@AF!.I@AG hۋ@AG@AF!.I@AG@AG
=p@AG
=p@AG
M;@AG)^@AG@AGXe@AG!-w1@AG1@AG.H@AG8}H@AG>6z@AGAs@AGE84@AGU=@AGU=@AGU=@AGeں@AG\(@AGeں@AGb}V@AGiDg8@AGv_ح@AG&@AGO;d@AG	@AG@AGݗ+@AG-V@AGzH@AGzH@AG͞@AG[W>@AGzH@AG[W>@AGr@AG@AGK]d@AG@AG@AG;dZ@AG@@AGحV@AG;dZ@AGrG@AG@AGVϫ@AG-@AGrGE9@AGrGE9@AH     @AHF]d@AHF]d@AH@AH	ԕ+@AH@AHbM@AH}H@AH$xG@AH'RT`@AH$xG@AH'RT`@AH*0@AH*0@AH-
q@AH73@AHD*@AHA7K@AHH@AHH@AHA7K@AHNU@AHXy=@AH_F@AH_F@AHeO@AHoiDg8@AHu!@AHy=c@AHy=c@AHy=c@AH˒:*@AHn@AH|@AHYJ@AH-
@AH-
@AHu%F@AH-
@AH-
@AH-
@AH@AH{@AH
(@AHěT@AH@@AH@@AH@@AHѷX@AHD@AHe+@AH@AH	k@AI ѷ@AI$/@AI$/@AI@AI [7@AI&x@AI-w1@AI4J@AIA [@AI4J@AI=b@AIDg8~@AIGz@AIJE@AIJE@AIGz@AIJE@AIQ@AITɅo@AI[W>6@AI^@AI[W>6@AIe+a@AIhr @AIo hی@AI|Q@AI@AI~($@AI~($@AIo@AI7Kƨ@AIo@AIu@AI'RTa@AIn.@AIn.@AIl@AIl@AI'R@AI|@AIy@AIo@AIy@AIo@AI_o@AIN;6@AI_o@AIԕ*@AIiB@AI>BZ@AIs@AJn@AJI^5@AJI^5@AJI^5@AJs@AJ1'@AJ䎊@AJ䎊@AJ)y@AJ)y@AJ-V@AJ0U2a|@AJ3@AJ3@AJ0U2a|@AJ6C@AJ=p
@AJC\@AJM@AJT`d@AJ^5?|@AJd7@AJh	ԕ@AJa|Q@AJh	ԕ@AJkP|@AJnO@AJu%F
@AJxl"h
@AJ{m@AJ{m@AJ~"@AJ@4@AJ~"@AJ@4@AJݘ@AJL_@AJ@4@AJᰊ@AJvȴ@AJL/{@AJvȴ@AJ@AJ ě@AJg	@AJg	@AJn@AJn@AJ)_@AJ͞&@AJ`A@AJsP@AJsP@AJ`A@AJsP@AJ,<@AJsP@AJsP@AJڹY@AJG{@AJG{@AJ䎊q@AJc	@AJm@AJD@AKI^@AKI^@AKS&@AKu%@AK҉@AKnP@AK҉@AKs@AKPH@AK"`B@AK	@AK&@AK&@AK&@AK)^	@AK,zxl@AK9@AKC%@AKC%@AKC%@AKF]c@AKJ#9@AKS                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @rA@rA@rS33333@rY@rFfffff@r@     @r@     @r>fffff@rA@rH     @rL@rP     @rNfffff@rP     @rP     @rK33333@rNfffff@rT@rY@rS33333@rS33333@rNfffff@rI@rFfffff@rI@rI@rD@rFfffff@rH     @rI@rH     @rFfffff@rH     @rI@rQ@rH     @rC33333@rFfffff@rC33333@rC33333@rD@rFfffff@rL@rP     @rNfffff@rP     @rS33333@rVfffff@rI@rA@r>fffff@rA@rC33333@rC33333@rFfffff@rNfffff@rNfffff@rC33333@rFfffff@rFfffff@rH     @rK33333@rK33333@rC33333@rC33333@rP     @rS33333@rL@rL@rL@rFfffff@rFfffff@r<@r4@r6fffff@r<@r@     @rH     @rC33333@r>fffff@r0     @r+33333@r)@r)@r+33333@r.fffff@r333333@r)@r!@r33333@r33333@r33333@r@rfffff@rfffff@q@q33333@q@q33333@qk33333@q33333@p     @p8     @oFfffff@nI@mC33333@lY@k`     @j@j@jfffff@jC33333@j)@j     @i33333@ifffff@i33333@ifffff@iL@h陙@h@h<@g     @g@g33333@gl@gL@g,@g     @f33333@f@f@fs33333@f6fffff@f@f33333@e@eٙ@e33333@e     @e33333@e|@ep     @e#33333@dfffff@d     @d@d`     @d@     @d#33333@dfffff@dfffff@d@c@c33333@c@cfffff@cfffff@cfffff@cfffff@cvfffff@cVfffff@c,@c	@b     @b@bə@b@bfffff@b@bs33333@bVfffff@b9@b)@b@bfffff@a33333@a@a@a|@ac33333@a	@`     @`fffff@`33333@`fffff@`fffff@`fffff@`33333@`vfffff@`Vfffff@`@     @`&fffff@`@`     @`fffff@_@_     @_`     @_,@_9@_L@_L@_Ffffff@_,@_33333@_fffff@^@^     @^     @^@^9@^fffff@]@]fffff@]s33333@],@\33333@\fffff@\fffff@\33333@\     @\l@\l@\     @\     @\Y@\9@\&fffff@\33333@[33333@[ٙ@[fffff@[     @[y@[Ffffff@[333333@[@     @[333333@[fffff@Zfffff@Z33333@Zl@ZS33333@ZS33333@ZL@ZY@Z@     @Z      @Z      @Y33333@Y     @Yfffff@Yfffff@Yfffff@Y@Y     @Ys33333@YS33333@Y@     @Y      @X@X33333@X33333@X@Xl@XL@XFfffff@XY@XL@XFfffff@X9@X      @W33333@W@W     @W@W33333@Wfffff@Wfffff@Wy@Ws33333@Wl@W`     @WY@W`     @WY@W@     @W333333@W      @Wfffff@W@V@V33333@V33333@V33333@V     @V`     @VS33333@V,@V33333@V      @U@Ufffff@U@U     @U33333@Ufffff@Ufffff@Ul@U9@U      @T33333@T     @Tfffff@T@T@S@Ss33333@S333333@S@S      @Rٙ@R     @RL@R&fffff@R@Rfffff@Rfffff@R      @Qٙ@Q     @Qs33333@QL@Q,@Q@Q&fffff@Q&fffff@Q33333@P33333@P33333@P@P@P     @PY@P@Oٙ@O@O333333@O@O      @O@O@O@O      @Nfffff@N@N@NY@N333333@NL@NL@M     @M@M     @MY@M&fffff@M333333@M@M@M&fffff@M      @M      @L33333@L33333@L@LL@L333333@L&fffff@L      @Kٙ@Kfffff@K@Kfffff@Ks33333@KL@K@     @K&fffff@K&fffff@J@J@JL@J@     @J&fffff@Ifffff@Ifffff@Ifffff@I@Is33333@IL@I&fffff@I@I@H     @Hs33333@H@     @H@Gfffff@G33333@G@Gs33333@GL@G333333@G@G      @G@F@F@F     @F     @F33333@F@Fs33333@FY@FL@FY@F     @Fs33333@Fffffff@FY@Fffffff@F333333@F&fffff@F&fffff@F&fffff@Efffff@Eٙ@E@E@Effffff@Es33333@Es33333@E333333@Dٙ@Ds33333@D@     @D&fffff@D      @C33333@Cfffff@Cٙ@Cfffff@Cfffff@C     @Cfffff@C@C@CL@C@B33333@Bfffff@Bٙ@B33333@B33333@B@B@Bs33333@BL@Bffffff@BY@BL@Bffffff@B333333@B      @Aٙ@A@A     @Affffff@As33333@AY@AL@A333333@AL@A@     @A&fffff@A&fffff@@33333@@33333@@33333@@33333@@ٙ@@fffff@@ٙ@@@@     @@@@ٙ@@     @@33333@@     @@ٙ@@     @@@@@@@@@@@@     @@@@@@Y@@&fffff@@@@      @?fffff@@@@@?fffff@?@?     @?ffffff@?ffffff@>fffff@>     @>L@>ffffff@>333333@>      @=fffff@>      @=fffff@=33333@=33333@=ffffff@=     @=333333@=@=@=@<fffff@<33333@<33333@<33333@<L@;@;ffffff@;L@;@;@:@:@:L@:L@:333333@:@9fffff@933333@9@9@933333@9ffffff@8fffff@8fffff@8fffff@9      @9@833333@8@833333@833333@833333@8fffff@8@8L@8333333@8L@8L@8333333@7fffff@7@7L@7L@7ffffff@7ffffff@7L@7333333@6@6fffff@6fffff@7      @6@6@6@6     @6@6ffffff@6@6@6@6     @6     @6     @6     @6ffffff@6L@6ffffff@6L@6@6ffffff@6333333@6@6333333@6      @5fffff@533333@5fffff@5@5@5fffff@533333@5@533333@5     @5ffffff@5     @5ffffff@5L@5333333@5L@5333333@4fffff@4@4@433333@4@4     @4L@4@4@3fffff@3@3fffff@3fffff@3fffff@3@3@3@333333@3ffffff@3L@3ffffff@3@3@3L@3333333@3@3L@3L@3333333@3@2fffff@3      @3      @2fffff@2@2@2@2ffffff@2@233333@2     @2ffffff@2@2L@2333333@2ffffff@2L@2@2     @2L@2@2L@2     @2L@2L@2333333@2L@2L@2L@2333333@2333333@2      @1fffff@1@133333@133333@1@1@1     @1L@1L@1333333@1@0fffff@1@1333333@1@1@1      @1@1      @0@0fffff@0fffff@0fffff@033333@0@0     @0ffffff@0ffffff@0333333@0L@033333@0ffffff@0@0@0@0      @0333333@0      @/@0@0@0      @0@/@/@/ffffff@/@/@/@/@/333333@/ffffff@/@/333333@/ffffff@/333333@/333333@/333333@/ffffff@/      @/      @.@/      @/      @.@.ffffff@.@/      @.ffffff@.@.@.@.333333@.@.@.333333@.@.@.@.333333@.333333@.ffffff@.      @.      @-ffffff@-333333@-      @-333333@-@-ffffff@-@-@-333333@,@-ffffff@-@-      @,@,@-      @-333333@,@,      @,333333@,@,@,ffffff@,@,@,@,@+@,      @,ffffff@,ffffff@,@,333333@,@,333333@,333333@+@,      @,      @+@,      @+ffffff@,      @+@+@,      @,      @+@+@+@+@+@+@+ffffff@+ffffff@+@+@+@+333333@+333333@+@+333333@+333333@+@+@+333333@*333333@*ffffff@*@*@+      @+333333@*ffffff@*      @*      @*      @*      @*      @*ffffff@*ffffff@*@)@*      @*ffffff@*@*333333@)@)@*      @*      @)@)@)@)@*333333@*333333@*ffffff@*      @)ffffff@)@*      @*333333@)@)@*      @)@*333333@)@)@)@)@)@)@)@)ffffff@)333333@)@)@*      @*      @)@*      @*      @)@)      @)@*      @)@)@)@)@)@)@*      @)@)@)@*      @)@)@)@)333333@)@)@)ffffff@)@)@)@)333333@)      @)333333@)ffffff@)@)ffffff@)@)ffffff@)@)ffffff@)ffffff@)@)@)333333@)ffffff@)ffffff@)@)ffffff@)ffffff@)@)@)333333@)333333@*      @)@)@)ffffff@)@*      @)ffffff@)ffffff@)ffffff@)@)@)ffffff@)ffffff@*      @)ffffff@)ffffff@)ffffff@)@)@)@)333333@)333333@)333333@)@)ffffff@)@)333333@)@)@)@)@)@)ffffff@)@)@)ffffff@)333333@)@)@)@)ffffff@)ffffff@)@)333333@)333333@)@)@)@)@)@)333333@)ffffff@)@)@*      @)@)ffffff@)ffffff@)@*      @)@)ffffff@*ffffff@)@*@*ffffff@*      @)ffffff@)@)@)@)@)@)@)@)@*      @*      @*333333@)@)@)@)@)@*      @)@*@*@*      @)@*ffffff@*@*333333@)@*333333@*ffffff@*333333@*@*@*      @+      @*@*@*@*@*@*@*@*@*@*@+      @*@*ffffff@*@+333333@*@*@*@+      @+333333@+333333@*@*ffffff@+333333@+333333@+      @+      @+333333@+      @+ffffff@*@+ffffff@+@+@+ffffff@+ffffff@+ffffff@+333333@+333333@+ffffff@+@+@+@+@+@,ffffff@,      @+      @+      @+@,ffffff@+@+333333@,      @,      @,      @,333333@,      @,      @,333333@,333333@,333333@,@,      @+@,ffffff@,@,ffffff@+@,333333@-      @-      @,@,@,@,@,@-      @,@,333333@,ffffff@-      @,@-      @,@,ffffff@,@,@,@-      @-      @-ffffff@-ffffff@-      @,ffffff@-      @-333333@,@,@,@,ffffff@,@,@,ffffff@,@,@,333333@,ffffff@-      @,@-      @,@,@,ffffff@,@-      @,@,ffffff@,@,@,@,@-333333@-      @,@,@-333333@-@-@.@.@.333333@.@.      @.      @.333333@.@.      @.333333@.ffffff@.@.@.ffffff@.@.@.ffffff@.ffffff@.ffffff@/333333@/      @/333333@.@.ffffff@.@.@/@/      @.@.@/      @/@/      @/      @/      @/ffffff@/@/@/333333@.@/ffffff@/@/333333@0@/ffffff@0      @0L@0333333@0@0@/333333@/@/@/ffffff@/@/333333@/333333@/@0333333@/@0333333@0     @0L@0L@0@0ffffff@0L@0ffffff@0     @0     @0@033333@0     @0fffff@0fffff@033333@1      @0@0fffff@0fffff@0fffff@0fffff@0fffff@0@1      @0@1333333@1333333@1      @0@0fffff@1333333@1333333@1ffffff@1ffffff@1L@1@1@1     @1@1ffffff@133333@1@1L@1333333@1@1@1@1     @1@2      @2      @133333@1@2333333@2333333@1ffffff@1fffff@2@2@2@1fffff@2      @2      @2      @2@2@2333333@2L@2     @2333333@2L@2ffffff@2L@2@2ffffff@2@2@2     @2@2L@233333@2     @233333@233333@2@2@2@2@233333@2fffff@3333333@3333333@3      @2fffff@2fffff@3333333@3     @3ffffff@3@3L@3ffffff@3333333@3333333@3     @3L@3@3@3333333@3333333@3333333@333333@333333@3fffff@333333@3@3ffffff@4      @4333333@4      @4      @4      @3@3@3@4ffffff@4      @4333333@4333333@4@433333@433333@4333333@4@5@5@5      @5@433333@4fffff@5333333@5L@5ffffff@5333333@5L@5ffffff@5L@5333333@5     @5@5333333@5L@4fffff@5ffffff@5@533333@5     @5L@533333@5fffff@5     @5     @533333@533333@5@533333@5fffff@533333@533333@5@6      @5fffff@6      @6      @5fffff@6L@6333333@5fffff@5@6333333@6     @6     @6@6     @6     @6L@6L@6L@6ffffff@6@6@6@6fffff@6fffff@7333333@7@7      @7      @7      @7     @733333@7L@7L@7@7fffff@733333@7fffff@7fffff@7     @733333@8@8@8@8@8333333@8333333@8333333@8ffffff@8@9@9      @9      @8@8fffff@9@9333333@9     @933333@9333333@9@:333333@9fffff@:L@:ffffff@:     @;L@;     @;333333@;333333@;ffffff@;33333@;@;fffff@;fffff@<      @;@<      @<ffffff@<333333@;@;33333@;@<333333@<33333@<33333@<@<@<     @<@=333333@=333333@=ffffff@=     @=@=     @=@=fffff@=@=@=@>333333@>ffffff@>33333@>     @>ffffff@>@>33333@>fffff@?      @?@>fffff@?333333@?333333@>@?      @?      @?     @?L@?     @?@?33333@?@?33333@?@?@?@@@@333333@@@?fffff@?fffff@@@@@@@@@     @@@     @@L@@ffffff@@     @@     @@s33333@@s33333@@     @@33333@@     @@@@33333@@ٙ@@fffff@A@A@@     @@ٙ@@ٙ@@ٙ@@fffff@@fffff@A@A      @A@A&fffff@@33333@@fffff@A333333@A333333@A&fffff@A@A&fffff@A&fffff@A@A@A&fffff@A333333@A      @A@A&fffff@Affffff@As33333@A@A@A     @A33333@A33333@Afffff@A33333@B@B@B&fffff@B@     @BL@B@B@B     @BL@BY@Bs33333@Bffffff@Bffffff@B@B     @B@Bfffff@B@B33333@Bٙ@C&fffff@C@     @Cs33333@C     @Cffffff@Cs33333@C33333@C     @C@C33333@C33333@C     @C     @D      @Cٙ@C33333@C     @Cfffff@D@     @D@     @Ds33333@Dffffff@D@D@DY@DY@D@Dfffff@D@D     @D@D     @D33333@Dfffff@Dٙ@D33333@D33333@E      @D33333@E      @E@E@E@E@E@E@E      @EL@E@     @E@E      @E@E&fffff@EL@Effffff@Effffff@EY@Es33333@E     @E@E33333@E     @E@Efffff@E@E@E     @E@E@E@Eٙ@E     @E@Eٙ@Eٙ@F@F      @Eٙ@Efffff@F@Eٙ@E     @Efffff@E33333@F      @F      @F@F&fffff@F&fffff@FL@FL@F@     @F@Fs33333@Fs33333@Fffffff@F     @F@F@F@F@Fs33333@F@Fffffff@F     @F@F@F@F@F@F33333@F33333@F     @Fٙ@G      @F33333@Ffffff@F33333@F33333@G&fffff@G@G@F33333@G333333@G333333@G333333@G&fffff@GL@Gffffff@GY@GY@Gffffff@Gffffff@G@Gfffff@Gffffff@Gs33333@Gs33333@G@G@Gٙ@Gٙ@H@H333333@H      @HY@HY@H333333@H333333@Hs33333@HL@H333333@HY@HY@H@     @Hffffff@H     @H@Hffffff@H@H@Hs33333@H     @H33333@H33333@Hٙ@H33333@H@H     @H33333@Hfffff@H33333@I      @I@I&fffff@I&fffff@I@Hٙ@H33333@I      @I@I@I&fffff@IL@IY@I33333@I     @Iffffff@I     @Ifffff@I33333@Iٙ@Ifffff@Ifffff@I33333@Iٙ@Iٙ@I@J      @I33333@Ifffff@J@I33333@J      @J&fffff@J@J@Js33333@J@     @J&fffff@Jffffff@JY@J@     @JY@J@J     @J333333@J@Jfffff@J@Js33333@Js33333@J@Js33333@J     @J     @J@Jfffff@J@J33333@Jfffff@Jٙ@K@J33333@J33333@K      @K&fffff@K@K@     @KY@K&fffff@K@     @K&fffff@K@K333333@K@K&fffff@K333333@KY@Ks33333@KY@K&fffff@K@KY@K33333@Ks33333@Ks33333@Kffffff@KY@K     @K33333@Ks33333@K@Kfffff@K33333@K@K33333@Kٙ@K@K@K     @K     @K@L      @L333333                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               ?nO?+?ffffff?ȴ9Xb?Q?~"?S?(\)?-?l?nO?Vt? ě?+I^?zG?+?~"?I^5??ȴ9Xb?"`A?I^5?ȴ9Xb?=p
=?\(?^5?|?+?ȴ9Xb?1&?m?Q?tj?~"?-V?hr ?-?C$?;dZ?ꗍO;d?=p
=?^5?|?ffffff?E?5?|h?\(?XbM?陙?E?ěS?I^5??ěS?r ě?      ?Q?Ƨ-?^5?|?^5?|?E?Q?1&?vȴ9X?n?+I?5?|h?tj?vȴ9X?^5?|?O;dZ??|hs?`A7K?\(?Q?E?ěS?E?
=p?bM?Z1'?      ?
=p?dZ1?S?+?Ƨ-?
=p
?C$?tj?=p
=?^5?|?vȴ9X?"`A?\(?=p
=?hr ?$/?`A7L?9XbM?tj?ߝ-V?\(\?ܛS?I^5??      ?Ƨ-?E?ϝ-V?/v?dZ1?ǮzG?/w?-V?p
=q?lC?vȴ9?j~"?dZ1?Gz?Gz?(\)?dZ1?E?bM?+?+?\(?tj?9XbM?$/??|hs?$/??|hs?j~#? ě? ě?E?E?nO;? ě?lD?l?333333?-V?lD?lD?Q?hr Ĝ?`A7L?
=p? ěT?
=p?Q?-V?`A7L?bM?&x?`A7L? ěT? ěT?vȴ9X?bM?bM? ěT?bM?
=p?bM? ěT? ěT?&x?
=p? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?Q?vȴ9X?vȴ9X? ěT?
=p?vȴ9X?bM?bM? ěT?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?;dZ?bM?vȴ9X?vȴ9X?vȴ9X? ěT?;dZ?vȴ9X?`A7L?bM?;dZ?vȴ9X?vȴ9X?vȴ9X?bM?Q?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?
=p? ěT?vȴ9X?vȴ9X?vȴ9X?
=p?bM?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X? ěT?;dZ?vȴ9X? ěT?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?bM?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X? ěT?;dZ?hr Ĝ?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ? ěT?;dZ?;dZ?vȴ9X? ěT?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ? ěT?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?Q?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X? ěT? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?bM?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X? ěT? ěT? ěT?;dZ?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?;dZ?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ? ěT?vȴ9X?vȴ9X? ěT? ěT? ěT?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ? ěT?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X? ěT?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X? ěT?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?Q?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ? ěT?;dZ?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?Q?vȴ9X?;dZ?Q?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?Q?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?vȴ9X?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?Q?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?5?|h?Q?Q?Q?;dZ?Q?Q?;dZ?Q?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?Q?Q?Q?vȴ9X?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?5?|h?Q?Q?Q?;dZ?;dZ?tj?tj~?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?;dZ?;dZ?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?;dZ?Q?;dZ?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?5?|h?Q?5?|h?Q?Q?Q?Q?Q?;dZ?Q?;dZ?Q?5?|h?5?|h?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?5?|h?;dZ?Q?;dZ?Q?Q?Q?5?|h?Q?;dZ?Q?5?|h?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?-V?5?|h?5?|h?5?|h?5?|h?5?|h?/v?5?|h?5?|h?5?|h?5?|h?5?|h?-V?-V?-V?5?|h?Q?Q?Q?5?|h?Q?;dZ?Q?5?|h?5?|h?Q?Q?Q?5?|h?Q?Q?5?|h?5?|h?5?|h?5?|h?Q?5?|h?Q?5?|h?Q?Q?Q?Q?5?|h?5?|h?Q?Q?Q?Q?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?Q?Q?5?|h?Q?5?|h?5?|h?-V?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?-V?5?|h?5?|h?5?|h?-V?-V?5?|h?5?|h?/v?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?/v?-V?5?|h?5?|h?5?|h?5?|h?-V?-V?-V?5?|h?5?|h?-V?/v?-V?/v?-V?5?|h?Q?5?|h?/v?/v?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?-V?-V?-V?5?|h?-V?/v?-V?5?|h?Q?5?|h?5?|h?5?|h?5?|h?-V?/v?Q?-V?-V?-V?-V?-V?-V?-V?5?|h?Q?5?|h?5?|h?-V?5?|h?5?|h?5?|h?-V?/v?-V?/v?-V?5?|h?-V?/v?/v?-V?/v?/v?-V?-V?/v?1&y?/v?5?|h?/v?-V?/v?5?|h?-V?5?|h?-V?/v?-V?5?|h?/v?/v?-V?1&y?/v?5?|h?/v?-V?/v?5?|h?-V?1&y?-V?-V?-V?-V?-V?/v?1&y?1&y?/v?-V?-V?/v?-V?-V?1&y?-V?-V?-V?1&y?-V?/v?/v?-V?-V?-V?/v?/v?5?|h?/v?5?|h?5?|h?5?|h?1&y?1&y?/v?-V?-V?-V?/v?-V?/v?/v?-V?1&y?/v?1&y?-V?5?|h?/v?-V?/v?/v?-V?/v?-V?-V?/v?-V?/v?/v?-V?-V?1&y?-V?/v?/v?5?|h?-V?/v?1&y?1&y?-V?1&y?1&y?-V?-V?/v?/v?/v?-V?/v?-V?/v?1&y?1&y?/v?-V?/v?1&y?1&y?/v?1&y?/v?-V?/v?1&y?1&y?/v?1&y?/v?/v?-V?/v?/v?-V?-V?/v?/v?/v?5?|h?/v?-V?1&y?1&y?1&y?/v?/v?1&y?1&y?/v?-V?-V?-V?-V?1&y?1&y?1&y?/v?1&y?/v?1&y?/v?/v?1&y?1&y?1&y?1&y?1&y?1&y?/v?1&y?-V?-V?5?|h?1&y?1&y?/v?/v?/v?/v?/v?1&y?1&y?1&y?/v?1&y?/v?/v?1&y?(\)?1&y?1&y?1&y?-V?/v?1&y?1&y?1&y?1&y?1&y?1&y?/v?1&y?/v?-V?/v?1&y?/v?1&y?1&y?(\)?(\)?1&y?1&y?/v?-V?/v?1&y?1&y?/v?1&y?1&y?1&y?1&y?1&y?(\)?1&y?1&y?1&y?-V?/v?1&y?1&y?1&y?1&y?/v?/v?1&y?1&y?1&y?1&y?/v?/v?/v?/v?1&y?(\)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               ???                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	P14                                     1                                       )BD|3J