CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20170205   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P5     CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:35.160444Z    ORIGINAL_HEADER      6CTD,20250210CCHSIOWB
#Removed 'CTDFLUOR_TSG' as it's filled with -999
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2017-06-29. CTD data from cruise 18DD20170205, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20170205. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2017-001/index.php. 
#
# The information in this file for the cruise 2017-001 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-0036.ctd
#
# Start of originator file comment header
#
#*2017/06/29 15:26:50.02
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2017/02/10 06:17:38.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 198
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : CE9F1F72
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            0.3            202.1
#       2 Temperature:CTD               deg_C_(ITS90)   5.6248         6.8697
#       3 Salinity:CTD                  PSS-78          32.78          33.8432
#       4 Sigma-t:CTD                   kg/m^3          25.7461        26.7106
#       5 Oxygen:Dissolved:CTD:Volume   ml/l            3.4            6.87
#       6 Oxygen:Dissolved:CTD:Mass     µmol/kg         147.7          299
#       7 Fluorescence:CTD:Seapoint     mg/m^3          0.66E-01       1.162
#       8 PAR:CTD                       µE/m^2/sec      0              0.3
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        7  F       ' '     2
#       6  -99   ' '        6  F       ' '     1
#       7  -99   ' '        8  F       ' '     3
#       8  -99   ' '        7  F       ' '     1
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2017-001
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P21
#    EVENT NUMBER        : 36
#    LATITUDE            :  49  38.00000 N  ! (deg min)
#    LONGITUDE           : 139  39.97000 W  ! (deg min)
#    WATER DEPTH         : 3961
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    The descent rate of the CTD was very noisy with some complete reversals
#	of direction.
#    CTDEDIT was used to remove many records corrupted by shed wakes;
#	salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Fluorescence and PAR data are nominal and unedited except that some records were
#	removed in editing temperature and salinity and a large spike in
#	fluorescence was removed from file 0032.
#
#    The Transmissivity channel was removed because of frequent shifts in values during
#	casts and large variations between values during repeat casts.
#	The data are available, by request, from the chief scientist.
#
#    NOTE: While the Fluorescence:CTD data are expressed in concentration units, they
#	do not always compare well to extracted chlorophyll samples, particularly for
#	casts far from shore. It is recommended that users check extracted chlorophyll
#	values where available.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in Sea-Bird
#	Application Note #64-2, June 2012 revision (Sea-Bird_64-2_Jun2012.pdf), except 
#	that a small offset in the fit was allowed.
#
#    The Dissolved Oxygen sensor used in files 0001, 0002 and 0016 malfunctioned so the 
#	Oxygen:Dissolved:CTD channels were removed from those files.
#
#    The Oxygen:Dissolved:CTD sensor has a fairly long response time so data accuracy 
#	is not as high when it is in motion as it is during stops for bottles. This will be
#	especially true when vertical dissolved oxygen gradients are large. To get an estimate
#	of the accuracy of the Oxygen:Dissolved:CTD data during downcasts (after recalibration)
#	a rough comparison was made between downcast Oxygen:Dissolved:CTD data and upcast 
#	titrated samples. Some of the difference will be due to problems with flushing of 
#	Niskin bottles and/or analysis errors, so the following statement likely underestimates 
#	Oxygen:Dissolved:CTD accuracy.
#
#    Downcast (CTD files) Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.25 ml/l from 0 to 125 dbar.
#	±0.2 ml/l from 125 to 400 dbar.
#	±0.1 ml/l from 400 to 600 dbar.
#	±0.05 ml/l from 600 to 1500 dbar.
#	Low by up to 0.08 ml/l below 1500 dbar.
#
#    For details on the processing see document: 2017-001-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5--- --6-- ---7--- --8---
#!Pressu Temperat Salinity Sigma-t: Oxygen Oxyge Fluores PAR:  
#!re:CTD ure:CTD  :CTD     CTD      :Disso n:Dis cence:  CTD   
#!                                  lved:  solve CTD:          
#!                                  CTD:   d:CTD Seapoin       
#!                                  Volume :Mass t             
#!------ -------- -------- -------- ------ ----- ------- ------
#*END OF HEADER
     WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @W        data_max      @W        C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     >  2   pressure                	long_name         pressure   positive      down   units         decibar    data_min      @         data_max      @[   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      >  ql   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d           temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?Ƨ-   data_max      @"~Q   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       >     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d            salinity                	long_name         salinity   units         PSS-78     data_min      @@>Fs   data_max      @AM'0   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      > 
   salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d       LL   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @$ffffff   data_max      @qk33333   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        > [   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d       x   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?1&y   data_max      ?Q   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      >    CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d          PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min                 data_max      ?ə   C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       > H   PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d       6   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min               data_max               C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     > Ft   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d          station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         (    cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         (    time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      *   data_max      *   C_format      %10d          latitude               	long_name         latitude   units         	degrees_N      data_min      @HXn   data_max      @HXn   C_format      %9.4f             	longitude                  	long_name         	longitude      units         	degrees_E      data_min      _ʪcI   data_max      _ʪcI   C_format      %9.4f             	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d           	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min        s   data_max        s   C_format      %4d         @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @W     @      @ffffff@      @ffffff@333333@ 333333@"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c33333@c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d33333@d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h@hfffff@h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k\@k33333@k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p1@p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @pfffff@q      @q     @q      @q0     @q@     @qP     @q`     @qq@q@q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r1@r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s>fffff@sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t^fffff@tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @vfffff@v     @v     @w      @w     @w$@w.fffff@w@     @wP     @w`     @wp     @w     @w     @w@w     @w     @w     @w     @w     @x      @x     @x33333@x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y33333@y33333@y     @y     @y     @y     @z      @z@z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{@{@{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|A@|P     @|^fffff@|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}fffff@}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @Ffffff@S33333@X@`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @Nfffff@[33333@`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @ݙ@陙@     @     @      @     @     @@fffff@(@0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @fffff@fffff@     @     @     @      @     @     @     @33333@(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @      @     @     @     @      @(     @/33333@:fffff@@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @33333@)@0     @8     @@     @H     @P     @X     @`     @h     @p     @w33333@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @33333@"fffff@(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @fffff@fffff@     @     @     @     @     @     @     @     @     @@@      @     @     @     @      @(     @0     @8     @@     @H     @O33333@`     @h     @p     @x     @     @     @@fffff@     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @2     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @k@q33333@t     @x     @|     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @.@5@8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @o@t     @x     @|     @     @     @     @     @     @     @     @     @     @@fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @@     @     @     @     @     @      @$     @(fffff@,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @@     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @     @     @     @fffff@@     @     @     @     @     @      @     @     @     @     @     @     @     @ @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @@@      @     @     @     @     @     @     @     @      @$     @(fffff@,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @     @@ @     @     @     @     @     @     @     @      @"@(@,     @0     @4     @8     @<     @@     @D     @H@L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @v@|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @33333@$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @[@`     @d     @h     @l     @p     @t     @x     @|     @33333@@     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @񙙙@     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @@@     @     @      @$     @(     @,     @0     @4     @733333@=@@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @@fffff@     @     @      @$     @(     @,     @0     @4     @6@<     @@     @D     @H     @L     @O@T     @X     @\     @_33333@c@h     @l     @p     @t     @x     @{@     @     @     @     @     @     @     @     @     @     @33333@fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @fffff@     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @Vfffff@\@`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @3@8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @fffff@     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @@33333@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @G33333@Lfffff@P     @T     @X     @[                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 @!qj@!?@!IQ@!,@!lC@!Dg8~@!*0U2a@!oiD@!0U2a|@!~"@!'/@!ڹY@!]cA@!jOv@!w1@!\@!w1@!jOv@!\@!Vu@!t@!qi@!2X@!jOv@!O;dZ@!\@!8Y@!q@!s@!/{J#@![W?@!iB@!j~@!+jg@!m8@!_ح@!|@!C\@!5Xy@!+j@!C,@!&I@!L_@!'RT@!Mj@!O;d@!W>6z@!$t@!@!	@!\N@!@!Ǡ	k@!D@!Vu@!У
=q@!2a|@!׍O;d@!˒:)@!m\@!u%F@!_@!4֡a@!)_@"p
=@"'@@",q@"1N;6@"9_o@"<u"@"P
=q@"\(\@"`	k@"h˒:*@"mU=@"u\(@"yJE@"{q@"|u"@"}[@"~Q@"~u@"v8YJ@"ks@"cZ@"[J#9@"S33333@"Rn@"QX@"P{@"PoiDg8@"P`A7@"OAs@"N2X@"OO
M@"OO
M@"Ks@"G,@"90
)@"D@!!.H@!*0@!ȴ9X@!3@!bM@!@!+@!n@!ʳg	@![6@!JE@!\(@!@!s@!     @!y=c@!X@!@!-w1@!v@!s@!n_o @!f'@!^Q@!XF]d@!O4֡a@!J0U2a|@!F@!@6@!7eں@!3g	l@!(˒:*@!1'@!)@!@ =K^@ sP@ tj~@ :)y@ E@ D@ a@@ 7Kƨ@ 䎊q@ ]cA@ u@ )^@ F]c@ q@ Q@ o hی@ *0U@ L_@ S@ m8@ zxl"@ e+@ u$/@ o\(@ l@ k~($@ kQ@ jD@ ix@ irGE@ fYJ@ b@ U*0@ JJL@ F?@ BC,@ BI^5@ @҈p@ 71@ 2<64@ /{J#:@ )ԕ*@ $e@ 	k~@ {@ 
D@ L/{J@ 
=p@ wkQ@ Zc@ @4@H˒@s@ߤ@iB@m\@|hs@D@[6@y@rm\@hr Ĝ@d?@]IQ@[=K^@ZQ_@Oo @/iDg8@&1.@o@1&@?@}H@fA@cA @;dZ@Õ$@s@n.3@?@?@f@[q@WO;d@QR@<hr@حV@zG@˒:*@Vl!@{@,@bM@7KƧ@@4n@.2@u!@$tS@;5X@@4n@tSMj@kC,z@c
=p@^%@MjOv@IoiD@@IQ@-
qv@%F
L0@䎊r@,<@Ʌoi@	 ѷ@#w@ٙ@lC@U@?@^Ov_خ@Ca@N@BZc@Bu%F
@@NU@@NU@=E@2a|Q@$7@#A [@#wk@#	@!'R@ -
@Ft@|@c	@-
@ؓtj@N;5@@!R@fB@n.3@|Q@6C@6@k6z@_?@XD*@OrGE9@;/V@"M@ݗ+@A [@_o@*0@żn/@P{@~6z@wkP@sg@mC\@ix@aGz@MM:@*JL@~$@@hr@-V@;5X@@weں@bC,@Y>BZ@L~($x@F-@=K]@73@/Vϫ@#eO@<64@m\@.H@(@W@8Y@C]@I^@$xG@u@C,@Ft@䎊@@dZ@~($@@O
M@n.@mU=@Zݘ@S&@Sa@O@QX@P-
q@N;5X@@hۋq@-w1@?@H@-@!.@|Q@sPH@N;5@ϐ@s@XbM@2W@%1@@z~@@*0U@hr @R@{@	 @Ƨ@
M;@*0@(\@qu!@0
)@rGE9@6@z@kC,z@V@V@>m\@L_@,zxl@
(@I^5?@$tT@v_ح@wrG@a'R@d7@y=c@D*@>@,<@&@͞@+@o h@~"@~6z@s@}E@x}H@ao@R䎊@Q@VR<6@FYJ@@n@@6@HK]c@/{J#:@$tS@
%@	^5?}@0@*0@@z>B@xl"h	@z~@{s@x}H@v!.I@u!.@sg	l@kP{@gRT`e@g-@b3@Z1'@P-
q@Gy@As@;lC@6}Vl@49XbN@2m\@1&x@0
=q@/{J#:@.}Vl@,C@)*0U2a@U@Y}@SMj@W@ ě@\@8}H@'RT`@1'@͸@˒:*@n.@vȴ9X@>B@4֡b@F@C-@Y|@m8@
=q@.2@zG@fB@ݘ@@|hs@r ě@^%@M:@=v@5?@2ᰊ@.t@(	ԕ+@Q@>6z@.H@ ѷY@;dZ@g8}@/V@
(@IQ@ ѷ@s@!R<@_p@Ft@ ě@KƧ@!-w2@-V@2X@x@TɆ@u"@m@/{J#@@k~(@˒:)z@~($x@˒:*@Ňݗ@ѷX@U=@a@N@k6z@@     @W@ѷX@wkP@_!-w1@C{J#9@-V@D*@qu!@6@-B@M%@n@xF]@ᰉ@
qu@e@-@ hۋ@g	l@Xe@+@zxl"@C@lC@sP@v!.I@GzH@n/@i^@ZY@[Q@Rp:@Iԕ*@ES&@E84֡@?|hs@8Q@2m\@Ov_خ@(ۋq
@}H@.H@73@s@n.@W@|@T@ ěT@-
qv@333333@C,zxl@E8YK@@C@=ڹZ@.H@*0
@ d8@[@U@Z@S&@hr @qi@Mj@{@҉@Ʌoi@&@sh@o @m\@!-w2@䎊qj@8F]d@H@9XbN@-@@1&@bM@$/@2a|@tj@M@ᰉ'@TɅ@~$t@hXy=@dTɆ@bwkQ@hr Ĝ@irGE@gfA@8}H@t@6@Eo i@JL_@Gݗ+@QN;6@`[6@t!-w2@vE@b`A@h$xG@iB@i*0U2a@cA [@Z,<@Qhr @DM:@@n@>6z@>BZc @;dZ@84֡b@:)_@<쿱[@71@2a|Q@#	@*0@Ov_@䎊@_@m]@Vϫ@;dZ@䎊r@rG@y@?@1&@ݗ@@
M:@v_ح@v_ح@@š@Z1@}E@t9XbN@p
=q@rs@n.2@l!-w@p
=q@q@nzG@tSMj@M:@R<6@6z@zH@s@nt@ql@g8}H@WXe,@X@@C@A:S@G@@TO
M@a@N@aGz@d7@r{m@z)y@wrG@x4֡b@z)y@JM@y~($@z>B@{/V@vE@uXy=@ql@p
=q@oO
M@mhr!@g	k@X@@JL/{@<j~#@.t@'-@#eO@Xe,@2a|@zG@*0U2@&@:)y@_@
	 @˒:*@p:@)^@	@?@@
:@
M:@L_@~($x@K]c@ NU@#x@4m@y@ֻ@C%@4m9@[W?@L_@q@84֡@^Ov_خ@QX@@hۋq@0{@)^@'lC@%ڹ@=!.H@Ik~(@K:)z@L@JL/{@G+I@>m\@9~($@/@%F
L0@!@N@t@ݗ+@H˒@1.@A7K@?@l!-@Ƨ@W'@ɺ^5?}@84֡@#w@2W@}Vl@V@RT`e@1&@PH@zG@*0U2@)^@M:@{s@s@kP{@fA@`A7K@OAs@I@>ߤ?@5'0@0'RT@.H@(Xy=@$xF@@@Mj@I^5?@_o@+I@_o@ݗ+@K]d@YJ@@n/@n/@{J#9@:S@$tS@"@ hۋq@b}V@lC@s@\@+I@xl"h
@҈p@TɅo@1&y@Ov_@v!.I@hۋq
@e`A7L@ae@\?@Z1'@V8YJ@TɅoi@Sa@O@Rm@NT@C@9XbM@0
(@+I^@($xG@#S&@u@PH@
@&I@n/@o h@%2@
˒:)@
+@
D@
\@
C@
빌~($@
~"@
ᰉ'@
g	@
r Ĝ@
	k@
唯O
@
e@
%1@
C,@
y=c@
̘_@
˒:*@
)^@
E84@
Ƨ-@
8YK@
Õ$@
vȴ9X@
C-@

qv@
lD@
a@@
r@
1@
q@
&@
=p@
[6@
Ov_خ@
_o@
@
n/@
r ě@
eڹ@
_o@
\N;@
Xe+@
UϪ͞@
O
M;@
JW'@
I^5?}@
H˒:*@
F-@
F
L/@
Eo i@
Eo i@
C$@
Ca@N@
B@
?@
;dZ@
73@
1[W>6@
.H@
+6z@
$/@
$/@!.H@ᰉ'R@]ce@@Q@v@Xy=@g	l@1&y@/V@`A@-w1@'RT`@'RT`@[@ᰉ@N;6@JM@yrGE8@weں@tD@r{m@ql@q@pD@oiDg8@mC\@nc	@nO;@o hۋ@oiDg8@o-V@poiDg8@sPH@qiB@qA [@r{m@sE@u\(@u!.@v_ح@v!.I@u\(@sPH@l!-w@jg	@jOv`@iᰉ'@jJL@kP{@k~($@l"h	ԕ@l"h	ԕ@l"h	ԕ@jOv`@h@glC@g@ffffff@e@e+a@e+a@d7@cA [@f,<@h	ԕ+@m\@jfB@e+a@d%1@e+a@g@	 @sh@L_@Fs@@*0@sP@nO@4J@%2@tSMj@e`A7L@bM@]cA @PH@G@@F?@E@Eo i@Eo i@C\N@B&IR@C$@Ca@N@?|hs@;5Xy@5'0@"3@u@$tSM@!ae@!-w1@䎊r@}H@6C@tj@O;d@@Ov_@I^5?@
	 @@@ hۋ@C\@B@lC@唯O
@%1@	@/w@څݘ@1'@b}@y=c@@m@ʌL_@,zxl@@^5?|@m8@
(@{J#:@2X@V@͞&@'@ěT@wkP@,<@Fs@Fs@kP{@`u!@Z1'@Gy@<Z@/r@+a@@ [6@[@IQ@sh@xF]@
qiC@	'RTa@@ 4m9@
~$@
O;@
ޞ@
ӎMj@
ΤT@
As@
ԕ*1@

=p@
Ϫ͟@
&@
*0U@
;5X@
R@
ק&@
>BZ@
+@
@
֡af@
т@
\N@
?@
'RT@
zG@
q@
L/{J@
u%@
*0@
\(@
ԕ*@
I^5@
uY|@
Xe+@
D*0@
)lD@
U=@
$/@
'/W@

ڹY@	@	\(@	:~ @	JL@		k@	@	C,@	ᰉ'R@	ߤ?@	(\@	څݘ@	l!-@	҈p:@	R@	v_ح@	@	ɅoiD@	ǮzH@	ǮzH@	y@	)^@	ěS@	@	7Kƨ@	BZc @	A@	A@	W@	B@	zxl"@	q@	RT`e@	1@	-
@	_o@	rGE9@	{J#9@	:S@	~($x@	{s@	vFs@	sPH@	o hۋ@	e@	T`d@	Ks@	KƧ@	K:)z@	IQ@	Em\@	Eo i@	C\N@	C@	D*0@	C\N@	A7Kƨ@	=K]@	6C-@	2a|Q@	1[W>6@	12W@	1-@	1[W>6@	/{J#:@	u@	N;6@	'/W@	'/W@	҈@		 ѷ@	ݗ+@	YJ@	%2@	nP@	I^5@	 IQ@E@ȴ9X@u!S@(@ۋq
@1.@5?|@As@?@84֡@*0@\N@p
=@0
@x@`A@!-w1@O;d@ѷX@vȴ9X@poiDg8@kC]@iB@gfA@Vt@M%@F?@@4m@7rG@/O
M@%F
L0@ 	k@}H@u"@*0U2@u%F
@ IQ@$t@G{@!.@%F
L@+jg@O;@>BZc@ݗ+j@҈p@e+@D@
L/@2W@XbM@r@1&y@lD@/V@u@쿱[W@e+a@qi@ݗ@@ѷX@.H@}!.H@y"`@n.2@kC,z@iDg8~@f,<@de@cS@^@Xy=c@QX@K]cA@HK]c@Fs@Fs@F-@A [7@:)y@:^5?|@6C-@4m8@3g	l@2-V@+U=@$?@S@tj~@rGE9@qi@!R<@!R<@
(@҈@҈@:S@!.@SMj@@iB@:~ @4֡a@!-w@Q@>BZc@>BZc@fA@,<@e@%1@e@o@Ϫ͞@՛=K@8YJ@D*@@D*@fA@`A7@+@̘_@@ǮzH@m\@@|hs@^5?|@H@͞&@TɅ@x@3@-V@O
M@4J@ߤ?@~($x@xF]@k~(@1&x@{~$@u!.@sPH@o-V@kC,z@jJL@UϪ͞@V8YJ@S@PH@OAs@N+@N;5X@Np:~@N;5X@N_o @NT@L_@Ks@F-@3ߤ@2a|Q@2a|Q@.1@/Vϫ@.1@-B@,>B[@,zxl"@&x@!ae@}H@e+a@tj~@@Vu@
M:@'/@	k~(@@nP@$/@b}V@PH@Q@_ح@oiDg8@빌~($@r Ĝ@8}H@唯O
@e@Z1@Z1@ⶮ}Vm@|Q@ᰉ'R@حV@Ft@iB@iB@5?|@"`B@ѷX@#9@84֡@@NU@쿱[@4֡b@֡a@1@d7@u@h	ԕ@	@u%@qu!@u%@vȴ@6C@Ov_@u@Vu@~($x@~($x@'/@I^5@zG{@y	k~@r ě@m8Y@m8Y@n.2@m(@l[W?@h@de@`d8@\(\@XbM@U2a|@TɅoi@Rp:@P`A7@P{@M%@Ks@K]cA@JD@I@IoiD@HK]c@GE84@E@B@>6z@0'RT@(@!ae@=K^@@+J@qi@eO@ 4m9@ݗ@F@>BZc@`A7L@Z1@@4@ ѷY@`d@*0U@)^	@2W@7Kƨ@NU@[W>@b@)@}H@4m@}Vl@E@g	l@U=@I^@@?@-w1@,=@C,zx@@@$tS@Ov_@@N@)^@Mj@@xF]@L/{@	 @'RTa@oiDg@F]c@IQ@.H@|PH@xl"h	@weں@v+jg@o4֡a@dZ1@bC,@g	k@a@N@\]ce@[$@Z1'@Y+@T`d@Q@OAs@MjOv@Ks@K]cA@H@Ca@N@B\(@B@@C@>
(@<64@9#w@6z@2m\@0{@,1&y@$/@"h	ԕ@䎊r@xF]@@ 4m9@#x@m]@m]@G{@j~@A@>@D*@H@@@@<64@}H@sg@1@@*0U2a@*0U2a@TɅ@TɅ@@x@/@.H@@+j@R<6@*0@zG@@N@1&x@{J#9@~\N<@y	k~@w1@u!R@p@gfA@de@d%1@ceO@be+@`
qu@]cA @]/w@[$@[$@ZQ_@Y|@YJE@Y+@Vt@S&@Q@PH@N;5X@L@K)^	@K]cA@F?@D*0@DS@DS@@NU@;dZ@9#w@8YJ@73@5?|h@2a|Q@/v@.zG@-U=@,zxl"@($xG@$tSM@ 	k@ 'RT`@%@Q@쿱[W@Ov_خ@IQ@u%@kP|@0
)@$tS@Z@\(@ ѷ@=b@g@u!S@-V@iDg8@hr!@C@C@C\@hr!@8Y@8Y@C\@C\@C\@4֡a@@8YJ@E@E@Ϫ͞@t@8YJ@t@䎊@+@Õ$@}H@}Vl@4K@?|h@?|h@3@g	l@[W>6@v@1&y@@?@쿱[W@-V@wkP@u%@Xe,@u@O;dZ@	 @ ѷ@K]d@?@F]c@nP@o hی@~"@|PH@sE@o4֡a@m(@^@Vl!-@UϪ͞@U=K@U=K@U2a|@U=K@U2a|@TE@SZ@QN;5@N;5X@M%@F]cf@BZc@:^5?|@1-@.2X@,zxl"@*0
@'/V@$TɆ@$TɆ@%u@%zxl"h@%1@%F
L0@$TɆ@$xF@#wk@#n.3@"wkQ@!ae@	@Q@Fs@$/@?@m]@s@@SMj@@hr!@~"@@Z1@حV@ܑN;@JE@Ϫ͞@a@O@*0U@D@@p
=@YJ@4m@}Vl@E@9XbN@|@33333@ߤ@a|Q@2W@ ě@Vϫ@{J#:@zG@6z@@x@wk@}H@sh@n@:)y@4J@bM@rGE9@o @\(@o @rGE9@ߤ?@@=p
@ԕ*@$/@˒:)@|Q@u!R@tSMj@kP{@irGE@d7@ae@a@N@a'R@_?@Z1'@W>6z@W
=p@SMj@SZ@QX@L/{J#@JW'@GE84@D*0@Ca@N@C$@@4m@?[W>@;5Xy@6C-@6z@6z@4m8@1o@,<쿱@)^@',@#9@!-w1@	@-V@,<@o @҈@
=p
@	 ѷ@+I@Q@%2@@{J#9@tj@@4n@ IQ@ IQ@      @      @ .H@ \N<@ Q@ C\@ +@ !.@ 
=q@ C@ 	ԕ+@ %1@ bM@ ;5X@ ɅoiD@ y@ 6@ 6@ vȴ9X@ )@ |@ m\@ }Vl@ R<6@ qu!@ vȴ@ 0
)@ _F@ @@ 0
)@ PH@ _F@ *0@ @ +J@ @ $tT@ {J#9@ }E@ {~$@ xl"h	@ wkP@ u\(@ u\(@ t#@ tSMj@ t!-w2@ t#@ u%F
L@ t!-w2@ tSMj@ s@ ql@ rGE85@ rGE85@ ql@ qA [@ o@ o hۋ@ mhr!@ m(@ m\@ mhr!@ kP{@ irGE@ g	k@ g8}H@ glC@ h	ԕ+@ h	ԕ+@ e@ `҈p@ ]+j@ \N;@ Y+@ W>6z@ H@ DS@ ATɅo@ ?[W>@ ?|hs@ >vȴ9X@ 8)@ [@ Q@ PH@ @ nO@ sP@ C%?ڹZ?rGE?`A7L?S?S?e+?u!? ѷY???
=p?,<?`A7?n?K]c?)^?8YK?8YK?2W??\(?74?74?\(?[W>?n.?sg?TɆ?ߤ@?_F?YJ?xF?xl"h	?u!.?qu!S?k~($?c	?]ce?Zc	?Vt?H˒:*?@NU?<64?4m8?'/V?Q?L_?4J?K]d? ѷX?C\?C\?C\?s?~$?~$?D?A [?-V?oiDg8??䎊q?MjO?MjO?䎊q?-V?Q?JL?fA?S???/w?$?ۋq?$?"`B?"`B?ڹY?ڹY?ڹY?+?حU?sPH??sPH?8YJ?8YJ?fA?fA?ԕ*1?a@O?,<?ԕ*1?ԕ*1?,<?҈p:?҈p:?|?ɅoiD??K]c?Ƨ-                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 @@>!.I@@>!.I@@>Fs@@>Fs@@? hۋ@@>!.I@@>!.I@@>"@@>!.I@@>!.I@@? hۋ@@? hۋ@@?Ft@@?Ft@@?Ft@@?
=p@@?Ft@@?Ft@@?@@?
=p@@?)^@@?@@?
M;@@?
=p@@?Ft@@?Xe@@?,@@?@@?v@@?v@@?.H@@?͞@@@$xG@@@l"h	@@@ ě@@@oiDg8@@@PH@@A#w@@Ao hی@@AiB@@Bm@@C*0U2@@D*0@@En/@@F\N<@@G>6z@@H73@@I+@@Io@@I-@@JJL@@J ě@@K&@@LxF@@L>@@M+j@@N҈p;@@O_o@@Q2W@@SP{@@T9XbN@@U2a|@@U8YK@@YXbM@@f'@@l2W@@nL/{J@@p>BZc@@t%1@@u1@@XbM@@H@@"h	ԕ@@a|Q@@3@@IQ@@+I@@Z@@Vl!@@fffff@@حV@@b@@
=q@@,zxl@@<64@@3@@s@@䎊@@䎊@@:)y@@T`d@@GE85@@@4@@\(@@{m@@{m@@m@@Á@@o i@@D@@9@@˲m]@@a@@@@@9XbN@@/@@($x@@1@@eں@@U2a|@@PH@@A [@@>BZ@@G{@@ӎMj@@cA \@@+a@@Ov_@@x@@@@*0U@@u!@@#w@@s@@ڜwkQ@@ێMj@@/{J#@@>B[@@ݞ%@@]cf@@+j@@ ѷ@@C\@@&@@a@@@L_@@g8}@@C@@!-w@@H˒@@s@@4֡a@@/V@@@@'RT`@@YJ@@H@@IQ@@oiD@@)y@@5Xy@@sh@@1.@@$/@@@@B@@D@@웥S@@wkP@@tSM@@q@@~($x@@C@@쿱[@@1&@@u"@@+a@@8YJ@@Ϫ͟@@Fs@@
=p@@)^@@,@@zH@@K]c@@hۋq@@u%F@@F@@oiD@@R@@n@@@4n@@d7@@ᰊ@@ ѷ@@F]c@@Mj@@|@@J@@g8}@@zxl"@@?@@7@@/@@H˒@@4K@@E@@fffff@@,<@@6z@@6z@@Q@@+I@@4֡a@@1@@$tS@@As@@+I@@+I@@KƧ@@v_ح@@$tS@@r@@˒:)@@K]d@@
qu@@-
@@@@-
@@)@@
=q@@)^@@҈p@@`A7@@`A7@@@@@@@@F@@@@@@_p@@+@@+@@rGE@@TɅo@@hr @@x@@b}@@@@B@@X@@o@@1'@@C\@@T`d@@nO@@xl"h
@@u%F
@@u%F
@@\(@@}Vm@@D@@I^@@I^@@C,z@@'/@@҉@@PH@@C,z@@	@@,zxl@@C%@@J#9@@W>6z@@Z@@]cA@@a@N@@qu!@@q@@q@@q@@a@O@@@@xF@@%2@@q@@5Xy@@A [@@/{J#@@C,zx@@PH@@(\@@Q@@J@@Ƨ@@A@@MjO@@S&@@u%@@"`B@@,<@@ ě@@~"@@qiC@@{m@@xl"h
@@xl"h
@@qiC@@W'@@s@@[W>6@@@@@TɅo@@-w1@@@N@@ae@@e@@@@y@@ᰉ'@@-V@@xl"h
@@L/{@@@@ ě@@ᰊ@@ ě@@n@@G{@@C,z@@C%@@n.3@@:)z@@wk@@@@Q@@5Xy@@@@C]@@9XbN@@VϪ@@/@@84֡@@:@@?@@!-w@@+a@@(@@2a|@@84֡@@B@@S&@@!R@@-V@@@@\(@@ᰉ@@E@@ڹ@@
L/@@t@@(@@@@-V@@%@@v@@oiDg@@Vu@@C-@@1@@As@@_o@@iDg8@@ݗ+@@vȴ9@A F]d@A :~ @A K]c@A Q@A D*@A  ě@A *0U@@@@?@@O;d@@vȴ9@@Ft@@@@Xe,@@l!-@@zxl"h@@`A7L@@<64@@qu"@@!R<@@?@@r@@o @@	k@@	k@@$tS@@kP@@lC@@_o@@_o@@ݗ+@@-V@A 
qu@@o @@@@o @A 
qu@@o @@r@@حV@A Xy=@A Xy=@A bM@A Xy=@A eO@Au@A?@AwkP@A~($x@A?@A7@AfA@A%@A+j@AO
@A+j@A%@AU=@AϪ͞@AC\@A@A;5X@AH@AiB@A}Vl@A$t@Aaf@A-@A2X@A2X@A@A@A&I@Am\@A]cf@A@AFt@A!.I@A hۋ@A!.I@A)^@AXe@A'/W@A>6z@Ab}V@Ao@AsPH@A{J#:@AO;d@A	@AkP@A-V@A&@Ar@A[W>@A3@Ar@A+@A@AVϫ@A#@A#@A     @AVϫ@ArG@A#@A6@A䎊r@A@A@A?@AkP@A-V@AkP@Avȴ9@A$xG@AU2a|@ATɅ@APH@A	*0U2a@A	Q@A	@A
wkQ@A
C,@AnP@A&@A/V@A6z@A@N@A=K^@A9@AJ#9@Ajf@A~$@A$@A~($@A@A6@A@A@A%2@A{J#9@A
@A	TɅo@ATɅ@A'/W@A+J@Au@Ap
=@A1@Aڹ@AzG@A'@A4m@AěT@A	@N@A	TɅo@A	R<6@A	D@A
Ov`@A
ݘ@A
Y@AI^@AF]c@A{J#9@A"h	ԕ@A"h	ԕ@AƧ@Aߤ@AU=@A
K]@A1&@Am8@A~($x@ASMj@A%1@AQ@A"h	ԕ@A!-w2@Ao h@A?@Ag8}@A@AZ@AVϪ@ASMj@A?@A쿱[@Am8@Ao h@A
5Xy>@A
%@A
,=@AzG@Aaf@A]cf@AsPH@A$tS@AzH@AzH@A&@Av_ح@AiDg8@A	k@ArGE9@AbM@A}H@A*0@A*0@AA7K@A_F@Ay=c@A@A@A9Xb@A)@A'RT@A
8Y@AFs@AlC@A@A%2@A64@AI^5?@Am8@AzG@AO
M@A
<64@A
=K@A
1@A
[@A
:@A
V@A
K]@A
+a@A
B@A
fA@A"@A{@Aԕ*@A74@A	@Am\@A9@AQ@AxF@A(\@An.@A64@AM:@Ao h@Ao h@AcA \@A쿱[@A?@A?@A*0@A@AJM@Ahr@Au@AB@A}H@AM:@A`A7L@A$/@AM:@Aw1@Ahr!@A%F
L@A/@A쿱[@ATɆ@AB@Ash@AIQ@AYJ@A@A?@A+J@A-@Aߤ?@A&I@A=K@AS&@A[W?@A?@A?@A#x@A?@A7@A֡a@Au"@A/@Aqu"@A}H@A\N<@AT@A
L/@A!R<@AcA @A
qv@AS@Aᰉ@AOv_@A
L/@A(@Au@A@A@A'/W@AH˒:@A@AA7K@AU2a|@Ahۋq@A-
@A@AJE@A@A^5?}@A_o@AlD@A&IR@A6C@AGE85@AJL@AT`d@AM@Ap:@Ag	@A'/@A,zxl@AS@Am]@Aa@@Ag@A$@Aߤ@@AFs@ASMj@Aj~#@Ao h@A쿱[@AZ@A%F
L@AIQ@Am\@AH˒@AS@A!.@AOv_@A.2@A!R<@A$/@A@A!.@Ab@A?@AϪ͞@AڹZ@AB@AK]@AK]@A֡a@A쿱[@A1&@A[W?@A#x@A#x@AD@A@Al!-@A}Vl@A@A'@A2X@A@A$t@Aaf@AO;@AO;@A+J@A}Vl@AYJ@AE@AR<6@AOv_خ@AVu@Afffff@A%@AFs@AFs@A$t@AO;@AO;@AO;@Aaf@Aaf@AT@A6z@A2X@AQ@Aȴ9X@AϪ͟@AC-@A hۋ@A!-w1@A1@Ao@A&@A?@A@AfA@AVϫ@A @A >BZc@A u!@A @A 9Xb@A `A7@A! ѷ@A!@N@A!:S@A!XbM@A![W>6@A!o hی@A!u!S@A!'RTa@A!l@A!B@A!y@A!lD@A"#9@A"@4n@A"a|Q@A"~"@A"`A@A#F]c@A#P{@A#J#9@A#,zxl@A#PH@A#nP@A#@N@A#]cA@A#]cA@A#n.3@A#eO@A#ߤ@A#@A#E@A#Z@A#6@A#
=p@A#@A$2W@A$?@A$C,zx@A$C,zx@A$C,zx@A$C,zx@A$PH@A$m8@A$~($x@A$~($x@A$o h@A$o h@A$C@A$3@A$@A$#x@A$[W?@A$7@A$7@A$Ʌoi@A$Ʌoi@A$@A$@A$֡a@A$>B[@A$>B[@A$Z@A%o i@A%5Xy>@A%F
L0@A%O;dZ@A%Vl!@A%`A7L@A%ce@A%1@A%cA @A%,=@A%!.@A%C\@A%!.@A%oiDg@A%E@A%C\@A&
L/@A&4K@A&zG@A&!R<@A&H@A&YJ@A&fffff@A&2X@A&@A'Ft@A'
M;@A',@A'1@A';dZ@A'KƧ@A'KƧ@A'O
M@A'\(@A'_o@A'b}V@A'b}V@A'o@A'sPH@A'v_ح@A'4m@A'ݗ+@A'?@A'vȴ9@A'˒:)@A'حV@A(73@A(Xy=@A(U2a|@A(d8@A(U@A(4m@A(@A(PH@A) ѷ@A)rGE@A)@A)rGE@A)rGE@A)@N@A)@N@A)rGE@A)+@A)*0U2a@A)A [@A)~($@A)o@A)ᰉ'@A)>BZ@A)Y}@A).H@A*n@A*n@A*Ov`@A*W'@A*a|Q@A*nO@A*kP|@A*u%F
@A*~"@A*p:@A*ڹY@A+)^	@A+Z@A+~$@A+$@A+Z@A+|@A+ݗ+k@A+ݗ+k@A+@A,ߤ@@A,%1@A,9XbN@A,I^5?@A,SMj@A,]ce@A,cA \@A,j~#@A,tSM@A,o h@A,C@A,3@A,O
M@A,#x@A,[W?@A,Ʌoi@A,Z@A,֡a@A,֡a@A,u"@A,D@A-o i@A-K]@A-<64@A-L_@A-Vl!@A-ce@A-p
=@A-sg@A-oiDg@A.($x@A.R<6@A.c	@A.p:~@A.s@A.%@A.+J@A.+J@A.O;@A.@A.@A.+J@A.+J@A.IQ@A.+J@A.qi@A.@A.$t@A.O;@A.+@A/'/W@A/;dZ@A/O
M@A/eں@A/o@A/	@A/ݗ+@A/-V@A/#@A0@A073@A0u!@A0ѷX@A1@N@A1_p@A1#w@A1#w@A1&x@A1A [@A1Dg8~@A1Dg8~@A1-w1@A14J@A17Kƨ@A1'R@A1X@A1D@A1y@A1o@A1"`@A1"`@A1iB@A1e@A1>BZ@A1R@A1lD@A2I^5@A2Ov`@A2e+@A2#9@A20U2a|@A26C@A2:)y@A2@4n@A26C@A2:)y@A2GE85@A2T`d@A2^5?|@A2^5?|@A2h	ԕ@A2~"@A2GE85@A2:)y@A26C@A2&IR@A2=p
@A2M@A2a|Q@A2a|Q@A2a|Q@A2^5?|@A2p:@A2wkQ@A2wkQ@A2vȴ@A2@A2}Vm@A2W@A2C,@A3s@A3F]c@A3a@N@A3jf@A3eO@A3U=@A3~($@A36@A3a@O@A3|@A3ݗ+k@A4Q@A42W@A4<쿱@A4?@A4Fs@A4PH@A4cA \@A4C@A4*1@A4zxl"@A4쿱[@A4O
M@A4[W?@A4?@A4Ʌoi@A4*0@A4֡a@A4u"@A4JM@A4!-w@A5K]@A5u@A5qu"@A5(@A52a|@A5Y|@A5fA@A5$/@A5M:@A5!R@A5=K@A5U=@A5sh@A5n/@A5@A5Ϫ͞@A5,=@A5!.@A5C\@A5ڹ@A6t@A64K@A6zG@A6zG@A6u@A6!R<@A61.@A6?@A6BZc @A6Ov_خ@A6YJ@A6Vu@A6p:~@A6}Vl@A6IQ@A6O;@A6+J@A6+J@A6@A6Fs@A6@A6@A6Q@A6&I@A6m\@A6҈p;@A6@A7)^@A6!.I@A7!-w1@A7.H@A7.H@A71@A74֡a@A78}H@A71@A71@A74֡a@A78}H@A71@A74֡a@A7E84@A7Xe,@A7lC@A7o@A7o@A7y@A7lC@A7y@A7r@A7@A7@A7حV@A7@A7@A7@A7rG@A7#@A7Vϫ@A7Vϫ@A7䎊r@A7䎊r@A7rGE9@A7+j@A7+j@A7+j@A8	ԕ+@A8*0@A8NU@A8l"h	@A8l"h	@A8r Ĝ@A8|@A8YJ@A8tj@A8YJ@A8n@A8YJ@A8@A8tj@A8@A8
=q@A8U@A8{@A89Xb@A8TɅ@A8)^@A8p:@A8ѷX@A8ۋq
@A8҈p@A8@A8`A7@A84֡b@A8C@A8$tT@A9@A9#w@A9-w1@A9*0U2a@A9&x@A9*0U2a@A9&x@A9 [7@A9+@A9_p@A9*0U2a@A9-w1@A9=b@A9-w1@A94J@A9Dg8~@A9N;5@A9Q@A9TɅo@A9XbM@A9^@A9hr @A9rGE8@A9~($@A9o@A9R<6@A9R<6@A9u@A9'RTa@A9u@A9X@A9X@A9@A9D@A9N;6@A9_o@A9N;6@A9"`@A9s@A:n@A:	 @A:Ov`@A:䎊@A:6C@A:@4n@A:6C@A::)y@A:3@A::)y@A:=p
@A:=p
@A:T`d@A:a|Q@A:a|Q@A:u%F
@A:@4@A:ݘ@A:ݘ@A:p:@A:0
@A:S&@A:S&@A:S&@A:<64@A:<64@A:n@A:n@A:)_@A:W@A:W@A:`A@A:sP@A:sP@A:ڹY@A:ڹY@A:G{@A:G{@A:C,@A:D@A;I^@A;u%@A;S&@A:m\@A:m\@A;I^@A;҉@A;s@A;C,z@A;	@A;&@A;)^	@A;,zxl@A;/V@A;9@A;C%@A;W>6z@A;]cA@A;a@N@A;g	l@A;jf@A;qu!@A;eO@A;Mj@A;A@A;ߤ@A;U=@A;q@A;E@A;a@O@A;a@@A;
=p@A;҈@A;g@A<J@A<tj@A<Q@A<!-w2@A<%1@A<,<@A<,<@A<%1@A<,<@A<,<@A<2W@A<,<@A<64@A<64@A<<쿱@A<m8@A<m8@A<wkP@A<q@A<m8@A<wkP@A<zG@A<~($x@A<~($x@A<C@A<_@A<3@A<#x@A<@A<j~@A<j~@A<[W?@A<Ʌoi@A<Ʌoi@A<Z@A</@A<Z@A<u"@A<JM@A<hr@A<>@A=K]@A=V@A=qu"@A=Q@A=!.H@A=!.H@A=%F
L@A=+a@A=/w@A=+a@A=+a@A=/w@A=84֡@A=5Xy>@A=2a|@A=2a|@A=?|h@A=S&@A=`A7L@A=m\@A=p
=@A=p
=@A=zxl"h@A=$/@A=ڹZ@A=1@A==K@A=Xy=@A=1@A=-V@A=\(@A=H˒@A=H˒@A=8Y@A=8Y@A=Ϫ͞@A=?@A=
qv@A=,=@A=S@A=ᰉ@A=C\@A>
(@A>
(@A>Ov_@A>($x@A>.2@A>+jg@A>5?|@A>8YJ@A>?@A>L/{J@A>Vu@A>c	@A>p:~@A>vȴ9X@A>z@A>}Vl@A>IQ@A>%@A>+J@A>qi@A>@A>Fs@A>$t@A>O;@A>,<@A>,<@A>@A>T@A>6z@A>A@A>C-@A>Fs@A?
M;@A?Ft@A?)^@A?'/W@A?.H@A?As@A?4֡a@A?\(@A?{J#:@A?y@A?{J#:@A?&@A?ݗ+@A?͞@A?[W>@A?@A?+@A?fA@A?حV@A?حV@A?@@A?Vϫ@A?䎊r@A?-@A?-@A?+j@A@F]d@A@	ԕ+@A@bM@A@bM@A@@A@}H@A@'RT`@A@*0@A@-
q@A@73@A@:~ @A@A7K@A@D*@A@K]c@A@NU@A@Xy=@A@_F@A@_F@A@_F@A@eO@A@oiDg8@A@u!@A@|@A@n@A@'RT@A@YJ@A@@A@IQ@A@{@A@{@A@
=q@A@9Xb@A@
(@A@TɅ@A@
(@A@TɅ@A@F@A@ۋq
@A@`A7@A@`A7@A@`A7@A@@A@\)@AA@AA ѷ@A@$tT@AA	k~@AA@N@AA+@AA@AA [7@AA-w1@AA-w1@AA:S@AAGz@AAJE@AAN;5@AArGE8@AAoiD@AAoiD@AA~($@AA@AA@AA@AA2W@AAD@AA_o@AAԕ*@AAᰉ'@AAs@AAlD@ABu%F@AB	 @ABOv`@AB䎊@AB-V@AB)y@AB0U2a|@AB-V@AB-V@AB0U2a|@AB3@AB:)y@ABC\@ABM@ABT`d@ABW'@ABZc@AB^5?|@ABZc@ABu%F
@AB@4@AB@4@ABL_@ABS&@ABwkQ@ABwkQ@AB@AB ě@AB}Vm@AB}Vm@AB}Vm@ABY@ABn@AB@AB)_@ABW@AB`A@AB)_@AB)_@AB͞&@AB,<@ABڹY@AB ѷ@ABG{@ABC,@ABC,@ABc	@ABc	@AB74@ACI^@ACI^@AB~@ACu%@ACs@ACC,z@ACPH@AC	@AC"`B@AC)^	@AC6z@AC@N@AC6z@AC9@ACJ#9@ACP{@ACZ@ACg	l@AC]cA@ACa@N@ACa@N@ACg	l@ACjf@ACqu!@ACqu!@ACxF]@AC~$@AC:)z@AC:)z@AC6@ACg@AC\N@ADxF@AD!-w2@ADߤ@@ADtj@AD"h	ԕ@AD%1@ADQ@AD%1@AD%1@AD%1@AD/{J#@AD64@AD2W@AD?@ADcA \@ADzxl"@ADTɆ@ADTɆ@ADzxl"@ADTɆ@ADTɆ@AD1&@AD?@AD?@AD/@ADD@ADD@ADe@AD>@ADD@AD>@ADe@ADE@AE:@AE'0@AEV@AE[@AE!.H@AE!.H@AE!.H@AE(@AE/w@AE?|h@AEIQ@AEF
L0@AEF
L0@AEL_@AES&@AES&@AEVl!@AEVl!@AEfA@AEm\@AEp
=@AE$/@AEݗ@AE@AEU=@AE1@AEU=@AE-V@AE@AEU=@AEsh@AE1@AE@AEn/@AEcA @AEcA @AEb@AES@AE!.@AF_o @AF
(@AFOv_@AFzG@AFOv_@AF$/@AF($x@AFOv_@AF!R<@AF$/@AF!R<@AF$/@AF($x@AF+jg@AF($x@AF+jg@AF($x@AF5?|@AF5?|@AFE@AFfffff@AFl!-@AFs@AFIQ@AFp:~@AFz@AFqi@AF+J@AF$t@AFO;@AFO;@AFT@AF6z@AF2X@AF@AFߤ?@AFm\@AFt@AF1@AF쿱[W@AFFs@AFFs@AF"@AF"@AG@AGFt@AGFt@AG
=p@AG
M;@AG)^@AGFt@AG
M;@AG
M;@AGXe@AGv@AG,@AG'/W@AG'/W@AG;dZ@AG\(@AGeں@AGb}V@AGiDg8@AGiDg8@AGlC@AGiDg8@AGiDg8@AGlC@AGiDg8@AGlC@AGsPH@AGy@AGy@AG{J#:@AG	@AGO;d@AG	k@AG	k@AGr@AGr@AGo @AGK]d@AG˒:)@AGK]d@AG˒:)@AG@AG@@AG@AGVϫ@AGrG@AG@AG䎊r@AG+j@AGrGE9@AH@AH	ԕ+@AH	ԕ+@AHbM@AH*0U@AH6@AH'RT`@AH'RT`@AH*0@AH73@AH73@AHD*@AHNU@AHU2a|@AH_F@AHeO@AHhۋq@AHoiDg8@AHr Ĝ@AH-
@AHtj@AH@AHu%F@AH-
@AH@AHd8@AHU@AHd8@AHU@AHd8@AH9Xb@AH9Xb@AH4m@AH)@AH)@AH)@AHěT@AH)^@AHp:@AHF@AH`A7@AH@AH	k@AH$tT@AI [7@AI:S@AIDg8~@AIDg8~@AI[W>6@AIae@AI^@AIk~(@AIx@AI|Q@AIoiD@AI(@AI^5?}@AI^5?}@AI@AI@AI@AI@AID@AI2W@AID@AIy@AIo@AIN;6@AIԕ*@AI-@AJI^5@AJ	 @AJOv`@AJ#9@AJ1'@AJe+@AJ䎊@AJ䎊@AJ#9@AJ&IR@AJ䎊@AJ#9@AJ&IR@AJ)y@AJ-V@AJ-V@AJ)y@AJ0U2a|@AJ0U2a|@AJ6C@AJ:)y@AJ=p
@AJ@4n@AJ@4n@AJ=p
@AJ@4n@AJJL@AJQ_@AJT`d@AJQ_@AJM@AJQ_@AJT`d@AJd7@AJkP|@AJqiC@AJu%F
@AJ{m@AJwkQ@AJL/{@AJ>B@AJ>B@AJg	@AJg	@AJ)_@AKu%@AKs@AKs@AKC,z@AK)^	@AK&@AK9@AKZ@AKqu!@AKxF]@AK{J#9@AK{J#9@AKxF]@AK~$@AK@AKQ@AKq@AKq@AK$@AKU=@AKU=@AKwk@AKS@AKS@AKq@AKq@AKq@AKq@AKq@AK@AKE@AK~($@AKa@O@AKQ@AK%2@AK%2@AK\N@ALߤ@@AL1&y@ALߤ@@ALL_@AL!-w2@AL(\@AL/{J#@AL64@AL<쿱@ALI^5?@ALVϪ@ALZ1@AL`d@ALm8@ALo h@ALC@ALqj@AL_@AL@AL1&@ALTɆ@ALO
M@AL1&@AL1&@AL1&@AL?@ALj~@AL[W?@AL[W?@AL[W?@ALj~@ALj~@ALj~@ALj~@AL?@AL@AL@AL@AL֡a@ALu"@ALu"@ALZ@ALZ@ALZ@AL@ALZ@AL@AL@ALJM@ALJM@ALJM@ALJM@ALJM@ALJM@ALhr@ALhr@ALhr@ALD@AL!-w@ALe@AL!-w@AL!-w@ALe@ALe@AL>@AL>@ALe@AMo i@AMK]@AMK]@AM'0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 @qk33333@qh     @qd@q`     @qY@qI@qH     @qNfffff@qNfffff@qH     @qD@qL@qQ@qP     @qNfffff@qL@qP     @qNfffff@qI@qI@qI@qFfffff@qH     @qP     @qNfffff@qL@qL@qH     @qD@qD@qC33333@q9@q6fffff@q1@q0     @q(     @q      @q@qfffff@q     @q33333@p@p     @pљ@p@pfffff@p     @p     @p@p33333@p     @pfffff@px     @pp     @pl@pc33333@pT@pA@p(     @p     @o@o33333@offfff@n@m@lٙ@l`     @l#33333@kə@k@j33333@i     @h33333@hVfffff@g@gfffff@f,@efffff@e|@ep     @e&fffff@d@dc33333@d&fffff@cfffff@c@c@c@c33333@cfffff@c     @c@cfffff@cfffff@c33333@c33333@c33333@cfffff@c`     @c@bfffff@b     @b33333@bfffff@b@b     @bfffff@b@bfffff@bvfffff@bc33333@bY@b<@b#33333@b33333@a33333@afffff@afffff@a@a     @a|@avfffff@ai@aP     @a)@afffff@`33333@`33333@`@`p     @`P     @`6fffff@`@_     @_@_@_fffff@_     @_@_33333@_333333@^     @^     @^33333@^33333@^fffff@^fffff@^33333@^@^fffff@^@]     @]S33333@]`     @]fffff@]@]ٙ@]33333@^      @^      @^fffff@^33333@]@]33333@]ٙ@]33333@]     @]@     @]      @]&fffff@],@]9@]9@]@\@\ٙ@\@\@\@\@\     @\     @\@\y@\33333@[@[&fffff@Zfffff@Z@Z@Z@[fffff@[@[&fffff@[      @Z33333@Z@Z     @Zs33333@Zffffff@Zffffff@Z`     @Z@     @Z@Z&fffff@Z9@ZL@Zffffff@Zl@ZS33333@Z@     @Z,@Z&fffff@Z@Zfffff@Y33333@Y33333@Y@Y     @Y33333@Y33333@Y@Y33333@Y@Y33333@Y33333@Y@Yfffff@Yy@Yy@Yfffff@Y     @Y33333@Y33333@Yl@Y@     @Y9@Y,@Y@Y@Y@Y@X33333@X     @Xfffff@X@X@X@X     @XY@X9@X      @X      @W@Wfffff@W     @W@W@Wfffff@Wfffff@W     @W@W33333@W33333@W     @Wfffff@W@W     @W     @WS33333@W333333@W@Wfffff@W      @Wfffff@V33333@V33333@V@V@Vfffff@V     @V@V     @V33333@Vfffff@Wfffff@W333333@WS33333@Wy@WY@Wy@Wfffff@Wfffff@W@W33333@W@W33333@Wfffff@W     @Wfffff@W33333@X9@X      @W33333@W@W@Wl@W333333@W@V@Vfffff@V     @VFfffff@V@V@V&fffff@V&fffff@V      @Uٙ@U     @Ufffff@U`     @US33333@U9@U@U@U33333@Ufffff@T     @T@Ts33333@T&fffff@Sٙ@Sfffff@S     @S@Sy@Sffffff@S`     @Sffffff@SY@S@     @S&fffff@S@R@R@R     @RY@R,@R,@R,@R,@R@     @RFfffff@RS33333@R333333@R      @Q@Q33333@QS33333@Q@     @Q,@Q,@Q33333@Q      @P@Pfffff@P     @P33333@P     @P     @P@P     @P     @P@P33333@Q      @P@Pfffff@Qfffff@Q9@Ql@Q     @Q@Q&fffff@PL@Oٙ@Offfff@O@O33333@O@Oٙ@P      @P      @P      @P33333@P      @O@O     @O     @OY@O333333@O333333@OL@O      @N33333@Nffffff@N333333@N&fffff@M     @L@Kfffff@Jfffff@Iٙ@IY@IY@I      @H@Hfffff@H     @Hfffff@Hfffff@H33333@H     @Hffffff@H333333@Gfffff@G     @G33333@G@Gs33333@GL@GL@GL@GL@GL@G&fffff@G@G&fffff@G      @F     @F@F@Fffffff@FY@FY@F&fffff@F@F@E33333@Efffff@Eٙ@E33333@E@E@Efffff@Efffff@Efffff@E@E@E@E     @EL@E@E      @D33333@D33333@D33333@Dfffff@D33333@Dfffff@Dfffff@D     @D     @D@D33333@D@D@Ds33333@DL@D&fffff@C     @C     @C     @C@     @C@B     @BY@B&fffff@A33333@Afffff@A     @A@A@A     @A     @As33333@AL@A&fffff@A333333@A@     @A@A@@fffff@@33333@@33333@@     @AY@B&fffff@C@D@D     @E@     @Eٙ@F      @F      @E@E@     @D     @CY@B33333@B     @B333333@B@Aٙ@Affffff@A&fffff@@ٙ@@@@Y@@&fffff@@      @@&fffff@@     @A&fffff@@@@@@@@&fffff@@L@@@@33333@@     @@33333@@@@Y@@L@@&fffff@@@@&fffff@@&fffff@@&fffff@@      @@&fffff@@@     @?@>@>      @=     @<fffff@<L@;     @;      @:@:@;L@;ffffff@;      @:fffff@:     @:ffffff@:@9@9fffff@:@9fffff@9@9@9ffffff@9L@9     @:      @;fffff@=@@     @@@@@@@@L@@@     @@@?@?L@>@>333333@>ffffff@>fffff@?L@?     @?@?      @>     @=L@;@9@8      @633333@6ffffff@6     @6      @5@5L@5L@5333333@5333333@5@5      @4@4@433333@4@4ffffff@4@4ffffff@4L@4L@4L@4@4@4      @3fffff@333333@4      @4@4     @4@4@433333@4@4L@333333@3333333@2fffff@3333333@3      @233333@2     @2@3ffffff@4@4@5      @5@5L@5L@5@5333333@5      @5      @4fffff@4@3fffff@3L@3     @3     @3@3fffff@4@4      @4      @4@4@4      @3@3@3L@233333@2333333@1fffff@1@1ffffff@1ffffff@1      @0fffff@0@0L@0     @0333333@0      @/@0@/@0      @0      @/@0@/333333@.@/      @.@.ffffff@.333333@.      @-@.ffffff@.333333@.      @-ffffff@-@-333333@-      @,@+@,      @+ffffff@,      @+ffffff@+333333@+      @+333333@+@+@,      @,333333@,      @,@-333333@-@-@-@.ffffff@/      @/333333@/333333@/333333@.@.      @-ffffff@,ffffff@,333333@+@,      @,@,333333@,@,@,@,ffffff@-      @-333333@-@-ffffff@-ffffff@-ffffff@-333333@-333333@-333333@-333333@-333333@-333333@-333333@-      @-333333@-333333@-333333@-333333@-333333@-333333@-ffffff@,@-333333@-333333@,@-      @,333333@+@,@,ffffff@,      @+@,      @,      @+333333@+ffffff@,      @+@+      @*@+      @*ffffff@*@*ffffff@*      @*@*ffffff@)@*      @*333333@*      @*333333@)      @)@)ffffff@)      @)      @(@(@)      @(@)333333@(@)ffffff@)333333@)ffffff@(@(@(@(@)      @)      @(@(@(@(@(@(ffffff@(ffffff@(@(@(@(@(@(@(      @)      @(@(      @)      @(333333@(@(ffffff@(333333@(ffffff@(ffffff@(ffffff@(      @(333333@(ffffff@(@(      @(      @(ffffff@(      @(333333@(      @(      @'@(@'ffffff@'ffffff@'@'@(      @'@'333333@(      @'@(      @'@'@'@'@'@'ffffff@'      @&@'ffffff@&@'333333@'@&@&@'333333@'ffffff@'      @'ffffff@&@'333333@&@'333333@'333333@'      @'333333@'      @&@&@'      @'      @&@'      @&@&@&@&ffffff@'      @&ffffff@&@&@&@&@&@&@&@&ffffff@&@&@&ffffff@&ffffff@&@&333333@&333333@&333333@&      @&@&      @&      @&      @&      @&      @&      @&      @&      @%@%ffffff@%333333@%@%ffffff@%      @%333333@%333333@%      @$@%ffffff@%@$@%333333@%333333@%333333@%      @%333333@%333333@$@%333333@%      @%333333@%      @%333333@$@%      @%      @%333333@$@%333333@%      @$@$@%ffffff@$@$@%      @%333333@%      @$ffffff@$@%@%333333@%      @$@%ffffff@$@%      @%@%333333@$ffffff@$@%@%ffffff@$ffffff@%      @%ffffff@%      @%@%333333@%333333@%333333@%333333@%      @%ffffff@%@%333333@%@%@%ffffff@%ffffff@%ffffff@%@%@&      @&      @&      @&      @%@&333333@&333333@%@%@&@&      @&ffffff@&@&ffffff@&ffffff@&      @%@&@&      @&@&      @&@&@&ffffff@&@&333333@&      @'333333@&@&      @&@&@&@&ffffff@&@&@&333333@&      @&333333@&      @&@&ffffff@&@&@&ffffff@&ffffff@&@&333333@&@&ffffff@'333333@&@&@&@&@&@&@'333333@'@'333333@'ffffff@'@'@'@(      @(333333@'@(333333@(333333@'@'@(333333@(ffffff@(333333@(ffffff@)      @(ffffff@(ffffff@(      @(333333@(@(@(@(ffffff@(333333@(333333@(ffffff@)      @(@(@)333333@)333333@)333333@)333333@)      @)      @)333333@)333333@)333333@)      @)      @)@)@)@)@)@)@)ffffff@*      @)@*      @)ffffff@)@*ffffff@*333333@)@)ffffff@*      @*ffffff@*      @*333333@*ffffff@*333333@*      @*333333@*333333@*333333@*ffffff@*ffffff@*      @*@*@*@*@+      @+      @+      @+      @*@*@+ffffff@*@+      @+      @*@+ffffff@+ffffff@+ffffff@+333333@+ffffff@+ffffff@+333333@+@+@+@,@,@+@+@,333333@,333333@,333333@,@,ffffff@,      @,ffffff@,ffffff@,      @,333333@,      @,333333@,@,@,@-      @-333333@,@,@,@,@-@-@,333333@+@,ffffff@,@-      @,@-      @-      @-333333@-333333@-333333@-333333@-      @-@-ffffff@,@-@-@-ffffff@-@-@-@-@.      @-@-@-@-@-ffffff@-@-@-@-@-@-@.      @-@.      @.ffffff@.      @.@.333333@/      @.      @.@/      @.@.@.@/ffffff@/333333@/      @/      @.@/333333@/333333@/      @/ffffff@/@/@/      @/@/@/@0333333@/@0@0@/@/@0      @0@0@0@0@0333333@0333333@0L@0@0     @0L@0@0L@0@0L@0ffffff@0ffffff@0ffffff@0@0     @0L@0ffffff@0@0@0L@033333@0@0fffff@0@0     @033333@0@033333@0@0@0@0@0@0fffff@0@0@1@1@1      @1@1333333@1@1333333@1@1333333@1L@1ffffff@1L@1L@1ffffff@1333333@1ffffff@133333@2      @133333@1     @133333@1fffff@2@2@133333@2      @1fffff@1fffff@1fffff@2ffffff@1fffff@2      @2333333@1@2@2333333@2     @2L@2ffffff@2     @2     @2     @2     @2     @2ffffff@2L@2@2@2@2     @2fffff@3@3      @2@2@2fffff@2@2fffff@3333333@3      @3      @3333333@3333333@3333333@3333333@3     @3@3      @3ffffff@3L@3333333@3L@3     @3ffffff@3ffffff@3ffffff@3ffffff@333333@3@3333333@3@3@333333@333333@3@3fffff@3@4@4ffffff@4@4      @4L@4333333@4L@4@4L@4L@4L@4@4@433333@4333333@433333@4@4@5@433333@4ffffff@5      @4fffff@4fffff@433333@4@4fffff@5      @4fffff@5333333@5     @5333333@5@5333333@5@5333333@5ffffff@5@5ffffff@5333333@5333333@5     @5     @5     @5     @5@6      @5@6333333@6ffffff@6      @6333333@6L@6333333@6     @6fffff@6@6fffff@7      @6fffff@7@7     @7L@7     @7     @7L@7     @7@7@733333@7@733333@7fffff@8      @8      @7fffff@8      @7fffff@7fffff@8@8@8333333@8@8L@8333333@8L@8ffffff@8L@8     @8     @8L@8ffffff@8L@833333@9333333@8@8fffff@8@8fffff@8fffff@8fffff@9@8fffff@9L@9@9L@9@9     @9333333@9@9ffffff@9     @9     @9333333@9     @:      @9@933333@9fffff@9@:      @:333333@933333@9fffff@:333333@:@:333333@:@:L@:333333@:     @:fffff@:@;333333@;ffffff@;@;@;      @;ffffff@;     @;@;@<      @;@<333333@<ffffff@;fffff@<@<L@<@<@<L@<L@<33333@<@<@<33333@<33333@<@<fffff@=      @<@<fffff@=L@=ffffff@=     @=ffffff@=     @=33333@=     @=@>      @=fffff@=fffff@=fffff@=@=@=fffff@>333333@=@>333333@>333333@>      @>333333@=fffff@>333333@>     @>33333@>L@>333333@>@>ffffff@>     @>     @>33333@>@>@>33333@>@?@?      @?      @>fffff@?333333@?333333@>fffff@?      @?333333@?ffffff@?     @?33333@?ffffff@?@@@?     @?     @@      @?@?@?@@      @?@@&fffff@@333333@@ffffff@@     @@ٙ@@33333@@     @@ٙ@A@@fffff@@     @@     @@     @@ٙ@A@A@@33333@A&fffff@Affffff@AY@A@Afffff@Afffff@A@A@Afffff@A     @A     @A     @Afffff@B&fffff@B333333@A33333@B@B@B      @Afffff@B@B333333@B@B333333@BL@BY@B333333@B@     @BY@Bffffff@BL@Bs33333@Bffffff@B     @B@B     @BL@B33333@B@Bfffff@B@B33333@B33333@Bfffff@B@C@C@Bfffff@C@C@C@C333333@C@B33333@B33333@C&fffff@CL@CL@CY@Cffffff@C@C@C33333@C33333@C@C@C33333@C@C@C@C33333@C     @Cfffff@C33333@C@Cfffff@Cfffff@Cٙ@C33333@C33333@Cٙ@DL@D333333@D@D@D&fffff@Dffffff@D333333@DY@DL@DL@D@D@D@Dfffff@Dfffff@D33333@Dٙ@D@E@D@Dٙ@Dٙ@E@E@E@Dٙ@E      @E@E      @E      @E@E      @E      @E@E@E&fffff@Effffff@E     @Es33333@E@E@E@E@E@E     @E@Efffff@E     @E@E     @Efffff@E33333@E     @E@Eٙ@F      @E33333@F&fffff@F@F@FL@F333333@F333333@F&fffff@FL@Fffffff@Fs33333@F@     @Fs33333@Fs33333@F@     @Fs33333@F@Fs33333@F@F33333@F@F@F@F33333@Ffffff@F@F     @Fٙ@G      @G      @Fٙ@G@G@G333333@G&fffff@Gffffff@Gs33333@G     @G     @G     @G@G     @Gffffff@Gfffff@G     @G     @Gs33333@G@G33333@G@G33333@G     @Gfffff@G33333@Gfffff@Gfffff@Gfffff@Gfffff@H      @H@H333333@HY@H@H     @Hfffff@Hfffff@H33333@Hٙ@Hٙ@H33333@Hfffff@I@IY@IL@I@     @Iffffff@I@     @I@     @I333333@IY@Iffffff@IL@I@     @IY@IY@Is33333@I33333@I@I@Ifffff@I@I33333@Iٙ@Iٙ@I@J@I@J      @I33333@Iٙ@Iٙ@I33333@J@I@I33333@J      @J      @I@J@J&fffff@J@I33333@J&fffff@J@J333333@J&fffff@J      @J@     @J@     @JL@JY@J@     @JY@Js33333@Js33333@J33333@Jٙ@Jfffff@Jٙ@Jfffff@Jfffff@K333333@Ks33333@K     @K     @Kffffff@Ks33333@K     @Kfffff@L      @L      @L      @L@L@L333333@LL@L@L@LY@L@     @LY@L@     @LY@Lffffff@L@     @L     @L@LL@LY@LL@LL@LY@Lffffff@L     @Lfffff@Lfffff@L@Lfffff@Lfffff@L     @M@M@M&fffff@M@M333333@MY@MY@Mffffff@M     @M     @Mffffff@Mffffff@Mfffff@M     @M@M@M33333@Mfffff@M33333@M33333@N&fffff@N&fffff@N      @Mfffff@M33333@NL@N&fffff@N&fffff@N@N@N&fffff@N&fffff@N@N333333@N&fffff@N@     @Ns33333@NL@N&fffff@N333333@N@     @Ns33333@N@     @NL@Nffffff@NY@N@     @NY@Nffffff@Ns33333@NL@N333333@Ns33333@N@Nffffff@Ns33333@N     @NL@NY@N     @Ns33333@NL@N@Ns33333@N     @Nffffff@N@N                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 ?$/?o?hr ?7KƧ?^5?|?`A7K?Q?xF?xF?&x?O;dZ?/v?^5?|?$/?p
=q??7KƧ?`A7L??|hs?&x?+J?/w?hr!?
=p?\(?&x?$/??|hs?$/?/v?XbM?Vu?hr!?nP?XbM?QR?ěS?r ě?(\)?睲-V?畁$/?+?C$?
=p
?畁$/?
=p
?nO;?lD?hr Ĝ?p
=q?-V?hr ?7KƧ?bM?I^5?}?|hr?S?^5?|?E?"`B?E?S?Z1'?
=p?E?ۥS?~"?ش9XbN?;dZ?ָQ?Ցhr ?ӅQ?nO?љ?GzH?Ͳ-V?ə?x?`A7K?Ł$/?9XbM?Q?nO;?"`?hr!?dZ1?dZ1??1&?"`A?"`A?dZ1?1&?bM?XbM?XbM?+J??XbM?^5?|?tj~?1&?E?KƧ?tj?$/?j~#?zG{?zG{?E?333333? ě?333333?l?tj~?-V?zG{?-V?hr Ĝ?l?hr Ĝ?nO;?&x?&x?`A7L?hr Ĝ?hr Ĝ?&x?vȴ9X? ěT? ěT?bM? ěT?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT?;dZ?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?Q?;dZ?Q?5?|h?Q?Q?Q?;dZ?Q?Q?Q?;dZ?5?|h?Q?Q?Q?;dZ?Q?Q?;dZ?Q?Q?Q?Q?Q?5?|h?Q?Q?5?|h?Q?Q?5?|h?5?|h?Q?5?|h?Q?;dZ?;dZ?Q?5?|h?;dZ?5?|h?Q?;dZ?;dZ?5?|h?;dZ?Q?Q?5?|h?5?|h?Q?Q?Q?;dZ?Q?5?|h?Q?Q?5?|h?Q?5?|h?5?|h?5?|h?Q?Q?5?|h?Q?Q?;dZ?Q?Q?Q?5?|h?Q?Q?-V?Q?Q?Q?Q?;dZ?Q?vȴ9X?5?|h?;dZ?Q?Q?;dZ?Q?;dZ?vȴ9X?;dZ?Q?Q?5?|h?;dZ?Q?Q?;dZ?Q?Q?Q?5?|h?Q?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?5?|h?Q?Q?Q?;dZ?vȴ9X?Q?;dZ?;dZ?vȴ9X?Q?vȴ9X?vȴ9X?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ? ěT?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?Q?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X? ěT?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ? ěT?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ? ěT?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?Q?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?;dZ?vȴ9X? ěT?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X? ěT?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?bM? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X? ěT?vȴ9X? ěT? ěT?;dZ? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X? ěT? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X? ěT? ěT?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X? ěT? ěT? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X? ěT? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X? ěT? ěT?bM?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?bM?vȴ9X?vȴ9X?vȴ9X?vȴ9X?bM?vȴ9X?bM? ěT?
=p? ěT?vȴ9X? ěT?bM?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ? ěT?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?Q?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?Q?;dZ?Q?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?5?|h?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?5?|h?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?;dZ?Q?Q?Q?;dZ?Q?Q?Q?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?Q?;dZ?Q?Q?Q?Q?;dZ?;dZ?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?Q?Q?Q?Q?5?|h?;dZ?Q?Q?Q?;dZ?Q?Q?;dZ?5?|h?Q?Q?;dZ?Q?;dZ?Q?Q?Q?;dZ?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?5?|h?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?5?|h?Q?Q?;dZ?Q?Q?Q?Q?;dZ?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?;dZ?Q?Q?5?|h?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?;dZ?Q?Q?5?|h?Q?Q?Q?;dZ?5?|h?Q?Q?Q?Q?5?|h?5?|h?Q?5?|h?Q?5?|h?Q?Q?Q?;dZ?Q?Q?Q?5?|h?5?|h?;dZ?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?5?|h?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?;dZ?Q?;dZ?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?Q?;dZ?Q?;dZ?Q?;dZ?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?5?|h?Q?;dZ?Q?Q?Q?Q?;dZ?Q?Q?5?|h?5?|h?Q?Q?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?Q?Q?Q?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?Q?Q?5?|h?5?|h?5?|h?5?|h?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?5?|h?5?|h?Q?5?|h?Q?5?|h?Q?Q?5?|h?5?|h?Q?Q?5?|h?Q?5?|h?5?|h?Q?Q?Q?Q?Q?5?|h?Q?5?|h?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?5?|h?Q?Q?5?|h?5?|h?5?|h?5?|h?Q?Q?5?|h?5?|h?Q?Q?Q?5?|h?5?|h?Q?Q?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?Q?-V?5?|h?5?|h?5?|h?-V?5?|h?5?|h?-V?-V?-V?/v?-V?5?|h?-V?5?|h?-V?/v?-V?-V?-V?-V?5?|h?5?|h?-V?/v?/v?5?|h?1&y?5?|h?-V?/v?/v?/v?-V?-V?-V?/v?-V?/v?-V?/v?-V?5?|h?/v?-V?/v?/v?-V?5?|h?-V?/v?-V?5?|h?-V?-V?1&y?/v?5?|h?5?|h?-V?5?|h?/v?/v?5?|h?5?|h?1&y?/v?1&y?1&y?-V?-V                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 ??ə?ə???                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	P5                                      1                                       *BBUT3s