CDF       
      pressure  4   time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20140212   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P11    CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:41.081859Z    ORIGINAL_HEADER      CTD,20250204CCHSIOWB
#Renamed 'CTDFLUOR_TSG' to 'CTDFLUOR' with units 'MG/M^3'
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20210615CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2014-07-09. CTD data from cruise 18DD20140212, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20140212. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2014-01/donneesctddata/2014-01-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2014-01/index.php. 
#
# The information in this file for the cruise 2014-01 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2014-01/donneesctddata/2014-01-0082.ctd
#
# Start of originator file comment header
#
#*2014/07/09 16:08:49.62
#*IOS HEADER VERSION 1.10 2011/10/26 2011/10/26
#
#*FILE
#    START TIME          : UTC 2014/02/23 16:30:20.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 2081
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : ACD38923
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            3              2104
#       2 Temperature:CTD               deg_C_(ITS90)   1.8242         7.9261
#       3 Salinity:CTD                  PSS-78          32.3708        34.6182
#       4 Sigma-t:CTD                   kg/m^3          25.2476        27.7052
#       5 Transmissivity:CTD            %/m             61.5           68.4
#       6 Oxygen:Dissolved:CTD:Volume   ml/l            0.2            6.7
#       7 Oxygen:Dissolved:CTD:Mass     µmol/kg         8.5            291.8
#       8 Fluorescence:CTD:Wetlabs      mg/m^3          0.86E-01       1.414
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        6  F       ' '     1
#       6  -99   ' '        7  F       ' '     2
#       7  -99   ' '        6  F       ' '     1
#       8  -99   ' '        8  F       ' '     3
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2014-01
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P5
#    EVENT NUMBER        : 82
#    LATITUDE            :  48  41.45000 N  ! (deg min)
#    LONGITUDE           : 127  10.04000 W  ! (deg min)
#    WATER DEPTH         : 2098
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0550
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    CTDEDIT was used to remove some records near the surface and many
#	records corrupted by shed wakes; salinity was cleaned.
#
#    Data Processing Notes:
#    ----------------------
#    Transmissivity, Fluorescence and PAR data are nominal and unedited except that
#	some records were removed in editing temperature and salinity.
#
#    For details on how the transmissivity calibration parameters were calculated
#	see the document Transmissivity_Calculation.pdf.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in the Sea-Bird
#	Application Note #64-2 of June 2012 (Sea-Bird_64-2_Jun2012.pdf), except that 
#	a small offset in the fit was allowed.
#
#    The Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.8 ml/l from 0 to 100 dbar.
#	±0.6 ml/l from 100 dbar to 300 dbar.
#	±0.2 ml/l from 300 dbar to 800 dbar.
#	±0.05 ml/l below 800 dbar.
#
#    The primary Salinity:CTD channel was used for events 0041 and 0043, so 
#	it was recalibrated to match the secondary channel which was selected for
#	all other casts.
#
#    For details on the processing see the report: 2014-01-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5-- --6--- --7-- ---8---
#!Pressu Temperat Salinity Sigma-t: Trans Oxygen Oxyge Fluores
#!re:CTD ure:CTD  :CTD     CTD      missi :Disso n:Dis cence: 
#!                                  vity: lved:  solve CTD:   
#!                                  CTD   CTD:   d:CTD Wetlabs
#!                                        Volume :Mass        
#!------ -------- -------- -------- ----- ------ ----- -------
#*END OF HEADER
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @S        data_max      @S        C_format      %f     WHPO_Variable_Name        EVENT_NUMBER       .L   pressure                	long_name         pressure   positive      down   units         decibar    data_min      ?         data_max      @        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC        G   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      h  a   temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      @
 ě   data_max      @   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC         g   temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      h     salinity                	long_name         salinity   units         PSS-78     data_min      @@4`d   data_max      @A$>   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC           salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      h     oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @&   data_max      @rT   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC             	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      h     CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?+I   data_max      ?j~#   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC           CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      h     PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC            PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d      h    	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min      @N   data_max      @Q         C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC         CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d      h !   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( ($   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( (L   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      W   data_max      W   C_format      %10d       (t   latitude               	long_name         latitude   units         	degrees_N      data_min      @HwO;d   data_max      @HwO;d   C_format      %9.4f          (x   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      `EM3H,   data_max      `EM3H,   C_format      %9.4f          (|   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3P   data_max      3P   C_format      %8d        (   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d        (@S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     @S     ?      @       @      @      @      @      @      @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         @a@N@o h@*0@84֡@Q@Q@Q@84֡@n/@oiDg@
L/@
L/@$/@$/@
L/@$/@@@ݗ@@84֡@*0@o h@*0@$/@?@a@N@[W>@|hs@}E@}Vl!@|Z@{lC@|Q@z)_@xl"h	@x-
@weں@t!-w2@or@oVϫ@pU2a|@oVϫ@o-V@mU=@l"h	ԕ@l"h	ԕ@l1&y@kI^@jd7@ilD@ilD@iy@iDg8~@i*0U2a@hTɅ@h@hTɅ@h@h@h@h@hr Ĝ@h	ԕ+@g8}H@glC@g	k@glC@g&@g&@gRT`e@f,<@eڹ@eO
@eF
L0@ezxl"h@eO
@e@ezxl"h@c
=p@bwkQ@bM@bM@be+@be+@bM@b@4@bh	ԕ@bwkQ@c	@bh	ԕ@_;dZ@.c	@BZc @lC@;/V@?@rGE9@5Xy>@حU@de@`A7K@]/w@[6@Zvȴ@Z6C@<쿱[@u@@PH@@fx@[Q@_o@fIQ@ -
@H@\N@+@\N@Q@@]ce@b}V@?@5Xy@7KƧ@.2@䎊q@!-w2@JE@͞&@"h	ԕ@{@-@g	l@	 @h	ԕ@|@1'@2m\@An.@_Ft@@@N@A@kP@Fs@@@F]c@H˒@,<@|hs@MO;dZ@U2a|@[S@b3@f,<@jg	@lzxl"@ql@C%@o@C@!-w2@E@MjO@zG@?@kU=@YJE@䎊@g	l@Ƨ@"h	ԕ@`d@~6z@UϪ͞@Eo i@B ѷ@2W@
W'@ڹY@=K^@iB@qu!@@
=p@Ye+a@I@@6@+j@Xe@sPH@©@!.H@1@Vϫ@C,z@r Ĝ@@N@M@wkQ@	@6@$/@@7Kƨ@}!.H@qu!S@],=@Z6C@Xy=c@XbM@P@<PH@%@_o@	k@ݲ-V@>BZ@$tS@֡af@ӎMj@R@rGE9@:@ȴ9Xb@Ňݗ@4m@/V@,@o i@g8}@gfA@49XbN@?b}V@H@KxF]@G+I@<?@7eں@,zxl"@O
M@@ק&@m\@
=p@`d@|Q@fA@V@Stj~@P@I@<PH@'	k@!-w1@@S&@-
q@qi@
=p
@D@0U2a|@9@@@\(@@$t@hr@m]@YJ@a|Q@x@9@e@Q@L_@%2@|64@iDg8~@VϪ͟@9D@?@0
)@u%@L_@2W@C@Ƨ-@y@cA \@`d8@[u%@nO;@c	@Ca@N@#
=p@&L/{J@ ѷY@
5Xy>@$tS@{@J#9@@ IQ@%F
L@
qv@I^@E@NU@@'R@5Xy>@@k~(@$/@}Vl!@r-V@u?@sg	l@yY}@x-
@g	k@S@N@KxF]@;A@3g@)@ -
@҉@
D@}Vl@O
M@`A@M:@rG@9XbN@JL@"`B@t@Fs@'/W@qiC@@@M:@˒:)@z^5?|@rGE85@sE@p ě@kC,z@ffffff@d7@h>BZc@j͞&@bM@`-
@Xtj@P*0U@>6z@+U=@&1.@+j@t@͞@@
	 @g8}@?@TɅ@u@@ΤT@̘_@K]c@$t@!.@-@O;@~($@@u!@(\@b}@2a|@Vu@7KƧ@ݗ+@Fs@?@@4n@IQ@{A@tJ@p{@nc	@bC,@^u@W>6z@L/{J#@?|hs@:~@84֡b@64K@5!R@5?|h@4j~@43@1@/-V@/ hۋ@..2@+jf@'fA@'	k@*0U2a|@%zxl"h@"C,@5?|@@fA@zG@Z@$/@)^	@8YK@g8}@o h@74@"@hr@4m@&x@@ߤ@'0@䎊q@A [@4֡a@y@*0U2a@RT`e@,<@F
L0@
=p@S&@ⶮ}Vm@.H@ce@6C@D*@8YJ@҈p:@~($x@K]c@ ѷ@$/@BZc @?@-
@l@P{@	k@,@TɆ@'R@o@ߤ@@Ϫ͟@䎊@rGE9@!R<@E84@~($x@vE@poiDg8@m(@jJL@glC@d?@`	k@^ ѷY@Zݘ@Vaf@T,<@Rn@P|@Oo @M5Xy>@JL/{@IQ@DM:@A [7@;5Xy@6C-@64K@6+jg@5!.@3E@.zG@+C,z@)y@(Xy=@!e@Q@0
)@bM@/{J#@eO@*0@&IR@쿱[@~($@Xy=@MjO@ ě@U2a|@C]@/@.H@@N@҈p;@Q@c	@PH@Xe,@fA@hr @ˬq@p:@_o@JM@ï@ ѷ@&IR@ [7@@v@<64@n.@)@ȴ9X@_ح@?|h@|@Vϫ@q@0U2a|@7@M@Q@ ѷY@-V@ߤ@@y=c@p:@͞@+@;5X@I^5?@:@L/{@@\(@JM@o i@g8}@@@,zxl@I^5@ [7@ѷX@n@     @}v@zG{@y	k~@xF]d@w4m@w1@qu!S@iB@eS@dqj@cn.3@b`A@b3@_o@Yb}@TO
M@O@Nqi@N_o @M@MO;dZ@Mqu"@MjOv@L@L@L@L@L@K:)z@G)^@En/@C@@NU@>($x@<?@9"`@6C-@3MjO@1u!S@1[W>6@0{@-8Y@䎊r@>BZ@8YJ@_o @q@
#9@	 ѷ@ 4m9@t@P{@Ov`@g	@fB@g	@Ov`@r Ĝ@r Ĝ@lC@rGE@|Q@څݘ@Q_@䎊@n@s@@NU@p
=@~@Y}@)@?|h@6z@u%@k~(@zC\@sg@qu!S@m\@e`A7L@`d8@_?@Zc	@U2a|@P|@L_@D*0@A@@NU@?@?H˒:@>
(@=p
=@=K]@=K]@@C@L_@d7@r䎊q@YJ@Xe,@'RTa@lVϪ@T,<@mhr!@sP@xF@ZY@C@1-@/v@0U2a|@*͞&@ 	k@:)y@:~@64K@/O
M@-V@43@/{J#:@%F
L0@#S&@)y@D2W@H@Eo i@F
L/@Gy@B@ATɅo@ATɅo@=b@-U=@Q@(@l"h	@ݗ+k@/v@73@73@2-V@0'RT@.zG@&L/{J@#9@@
qu"@u%F@@n.@Vl!@(@=b@!.@l@ᰉ'@Gz@@а{@@Q@)^@a@N@<64@~($@4֡b@4m@C-@[W>6@RT`e@h	ԕ@䎊r@}H@_F@ᰉ@O
M@ݗ+k@@zG@Z@҉@)^@҉@$/@쿱[W@U=@/@IQ@$xG@^@0
@lD@0
@6z@U=@a@@1&y@B@I^@=K^@:)y@_o@9@u%F@Z@'RTa@|?@xF]d@e@[$@XU@S&@F-@9Y}@3ߤ@-B@-B@!R<6@:)y@~($x@~($x@\(@@@YJ@
PH@
!.I@
oiDg8@
ᰉ'@
	k@
,<@
%1@
	@
(\@
=p@
cA \@
cA \@
*0@
XbM@
 ě                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @@4cA \@@4cA \@@4g8}@@4j~#@@4cA \@@4g8}@@4j~#@@4j~#@@4j~#@@4m8@@4g8}@@4cA \@@4g8}@@4g8}@@4cA \@@4cA \@@4g8}@@4j~#@@4q@@4g8}@@4cA \@@4`d@@4cA \@@4`d@@4cA \@@4j~#@@4wkP@@4?@@4#@@4#@@4?@@4#@@4#@@4?@@4C@@4qj@@4C@@4qj@@4N;@@4qj@@4#@@4N;@@4N;@@4qj@@4qj@@4qj@@4qj@@4qj@@4N;@@4qj@@4N;@@4N;@@4N;@@4_@@4*1@@4_@@4_@@4_@@4S@@4_@@4S@@4S@@43@@4zxl"@@4zxl"@@4TɆ@@43@@4zxl"@@43@@43@@4쿱[@@4TɆ@@4@@4@@4?@@4?@@41&@@4@@4?@@4[W?@@4?@@4j~@@4j~@@4j~@@47@@47@@4Ʌoi@@4@@4*0@@4/@@5:@@5Y|@@7?@@9o@@<"h	ԕ@@A#w@@C@@DɅoi@@G.H@@M8Y@@Q7Kƨ@@Qo@@Q@@Q(@@Q^5?}@@QD@@SI^@@Vqi@@WzH@@X}H@@Xe+@@[
=p@@]\@@_ hۋ@@a+@@ceO@@en/@@faf@@glC@@j~@@nOv_@@t2W@@x{@@{=K^@@@@p:@@3@@y@@S@@YJ@@\)@@n.3@@Z@@@@;5X@@}Vl@@e@@N;@@cA @@@@@u%F@@tSM@@F]d@@l@@q@@Fs@@F
L0@@_o @@L/{J@@Fs@@ [7@@@@.2@@q@@Z1@@@@ڹZ@@@@?@@z@@Ϫ͟@@.H@@@@ťv@@L/{J@@ƤT@@bM@@7@@@@@x@@Ѻ^5?}@@F]c@@ӥS@@Q@@
=p@@a@@@/{J#@@>@@fA@@՛=K@@b@@&I@@؉'RT@@@N@@|Q@@ԕ*@@:)y@@ڬ>B@@lC@@e@@Ov_خ@@KƧ@@@@+j@@
qu@@-
q@@'RT@@R<6@@ᦵ(@@^5?}@@^5?|@@g@@q@@C@@俱[W?@@O;dZ@@$/@@fffff@@@@"@@[W>@@-@@H@@r Ĝ@@`A7@@	 @@fB@@/V@@g	l@@@@Mj@@믷@@A [@@<쿱@@SMj@@VϪ@@]ce@@]ce@@g8}@@zG@@1&@@u"@@>B[@@'0@@ce@@B@@S@@5?|@@\N<@@vȴ9X@@+J@@+J@@qi@@$t@@}Vl@@%@@-@@6z@@Fs@@!-w1@@As@@b}V@@iDg8@@v_ح@@	@@{J#:@@?@@K]d@@@@@+j@@F]d@@@@}H@@NU@@u!@@y=c@@˒:*@@-
@@ ѷ@@$/@@@N@@_p@@*0U2a@@N;5@@7Kƨ@@l@@X@@o@@@@@@Y}@@o@@(@@N;5@@@@:S@@~($@@D@@"`@@@@~($@@7KƧ@@$/@@-
@@'RT@@*0U2a@@(@@@@@@n@@6C@@0U2a|@@-V@@0U2a|@@S&@@͞&@@I^@@PH@@&@@/V@@I^@@@@ᰊ@@򅇓ݘ@@vȴ@@~@@C,z@@"`B@@PH@@	@@jf@@Q@@a@O@@%2@@%2@@Z@@wk@@wk@@$@@s@@%2@@@@m]@@eO@@qu!@@g	l@@MjO@@dZ@@dZ@@tj~@@S@@a@O@@@@lC@@1&y@@Q@@/{J#@@Fs@@Fs@@`d@@!-w@@e@@Z@@>B[@@e@@%F
L@@fA@@$/@@sh@@@@U=@@U=@@?@@ᰉ@@@@Ov_خ@@}Vl@@+J@@,<@@}Vl@@@@t@@A@@A@@]cf@@ߤ?@@ߤ?@@+@@!.I@@,@@.H@@1@@;dZ@@RT`e@@eں@@o@@{J#:@@-V@@3@@˒:)@@Vϫ@@-@@䎊r@@rGE9@@	ԕ+@@'RT`@@73@@[6@@{@@ۋq
@@&x@@k~(@@@@Y}@@1'@@Zc@@nO@@qiC@@S&@@0
@@>B@@}Vm@@)_@@,<@@G{@@~@@~@@=K^@@A@@Z@@҈@@L_@@%1@@/{J#@@2W@@64@@zG@@qj@@쿱[@@S@@@@@@/w@@hr!@@U=@@8Y@@C\@@($x@@.2@@H@@_ح@@Fs@@T@@Ϫ͟@@C-@@!.I@@!-w1@@8}H@@E84@@U=@@@@[W>@@@@-@A }H@A D*@A _F@A 4m@A4J@Au!S@A@A^5?}@Ae+@AkP|@AS&@A0
@A}Vm@A,<@Ac	@AnP@A6z@A]cA@A{J#9@A$@A|@A$@Atj@A64@AVϪ@AtSM@Aqj@AO
M@A*0@AD@AQ@AIQ@Ace@A}H@A!R@A+j@A1@AcA @Ab@A4K@A1.@AiB@A,<@Aaf@AT@AT@A@AMj@A@A$tS@A4֡a@A|hs@A/V@A@A'RT`@ANU@AoiDg8@A-
@Ad8@AD@A4֡b@A	rGE@A	&x@A	-w1@A	Dg8~@A	k~(@A	B@A	D@A	y@A	e@A	lD@A
	 @A
Ov`@A
&IR@A
3@A
Zc@A
\(@A
>B@A
n@A
 ѷ@A
c	@A
74@A
~@AS&@Au%@AC,z@A"`B@A9@AdZ@A@AeO@A$@AS@A@AA [@Atj@AC@A?@Ae@A
K]@A
'0@A
[@A
%F
L@A
O;dZ@A
sg@A
$/@A
hr!@A
v@A
?@A_o @AzG@A($x@ABZc @AVu@Afffff@Al!-@As@Ap:~@Avȴ9X@A}Vl@A%@A$t@A6z@A҈p;@A@A@AXe@A$tS@A;dZ@A|hs@A+@A-@ArGE9@A     @A	ԕ+@A
qu@A ě@AU2a|@A-
@AѷX@AF@A`A7@AC@A{@A{@A{@A	k@A{@APH@A	k@APH@A	k~@A-w1@A:S@AJE@A|Q@AR<6@AB@Ao@A>BZ@An@As@As@As@A)y@AL_@A ě@A@A䎊q@A䎊q@A䎊q@AfB@A74@A&@A6z@A]cA@Aa@N@Aa@N@AdZ@Ajf@Aqu!@Ajf@An.3@Ajf@AQ@Awk@Aq@A|@AlC@A$@As@AJ@Aߤ@@AL_@AQ@AQ@A!-w2@A%1@A]ce@AC@ATɆ@A@A7@A@AZ@Ae@AE@AK]@Aqu"@A(@A2a|@AL_@A\@AjOv@Ap
=@Aw1@Aݗ@Ahr!@A+j@AU=@A8Y@AC\@As@Aߤ?@A'/W@A&@A$tS@A͞@AzH@A ě@A9Xb@A
=q@A@A@An@A˒:*@A-
@AU@A4m@A=b@Ahr @A[W>6@A*0U2a@A&x@A=b@A=b@AGz@Ab}@A@Au%F
@An@A͞&@AsP@AڹY@A ѷ@AڹY@A ѷ@Am@Au%@Am\@Am@Am@AW>6z@AƧ@AA [@As@Aߤ@@A%1@AFs@A`d@Ag8}@A#@A@A@A@AO
M@A?@AɅoi@A@AE@Au@A<64@AY|@Asg@A=K@A1@A\(@AϪ͞@A
qv@A_o @Au@A$/@A.2@A8YJ@AiB@Aȴ9X@A+@AϪ͟@Aߤ?@A!.I@Av@A.H@AE84@AKƧ@AH˒:@Ab}V@A{J#:@A+@A@A      @A [6@A y=c@A @A 
(@A p:@A 	k@A!@N@A!@A!+@A!@N@A!+@A!+@A!@A!rGE@A!+@A!7KƧ@A!o hی@A!l@A!@A"e+@A"=p
@A"Q_@A"a|Q@A"~"@A"vȴ@A"ᰊ@A"vȴ@A">B@A">B@A"vȴ@A"Y@A"C,@A#"`B@A#MjO@A#J#9@A#9@A#=K^@A#J#9@A#qu!@A#qu!@A#tj~@A#Q@A#$@A#m]@A#5Xy@A#|@A#ݗ+k@A#g@A#$@A$L_@A$!-w2@A$g8}@A$*1@A$j~@A$/@A$>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @rQ@r6fffff@rNfffff@rFfffff@rK33333@rI@rNfffff@rL@rQ@rQ@rI@rFfffff@rFfffff@rK33333@rL@rD@rS33333@rA@rT@rNfffff@rK33333@rT@rI@rH     @rFfffff@rH     @rQ@rD@rQ@rD@rFfffff@rNfffff@rC33333@rD@rFfffff@rC33333@rD@rC33333@r>fffff@rH     @r<@rC33333@rI@rI@r333333@r4@r1@r;33333@rD@rD@rFfffff@rFfffff@r@     @rA@rD@r;33333@r;33333@r6fffff@r$@r$@r8     @r;33333@r;33333@r<@r<@r4@r0     @r9@r<@r;33333@r<@r8     @r9@r;33333@r0     @r<@rfffff@r      @r$@r333333@r4@r4@r6fffff@r1@r)@r4@r4@r@r33333@qfffff@q@qx     @qA@q&fffff@p񙙙@p33333@p@p33333@p33333@p     @p     @p33333@p33333@p33333@p@pfffff@p@p@p33333@pt@pk33333@pC33333@p#33333@p@p@o     @o33333@o      @n@n6fffff@m     @mL@mfffff@lٙ@lL@l     @lfffff@k33333@k33333@k@k     @k     @k@kFfffff@k33333@j@jfffff@j@j9@ifffff@iL@h     @hə@h@hffffff@hvfffff@h`     @hY@h,@g     @gl@f     @f     @fi@fi@f@f`     @fL@f33333@efffff@e     @ey@es33333@eS33333@e@d@d@e0     @evfffff@e33333@e     @f@f,@fffffff@ffffff@ffffff@f@f@ffffff@ffffff@ffffff@f33333@f     @fY@f`     @fp     @f`     @fY@f@     @f,@f@efffff@efffff@e@e     @efffff@evfffff@eL@e@     @e,@e)@e33333@d     @də@d@d@d@di@d\@d9@d)@dfffff@cfffff@c|@cP     @c)@c33333@c@c@cfffff@b     @b陙@bٙ@bٙ@b33333@b@bfffff@b@bfffff@bfffff@b33333@bp     @bY@b6fffff@a@a@a33333@a@a@a     @afffff@a     @avfffff@aC33333@a0     @`@`     @`@`@`@`y@`@`s33333@`c33333@`Vfffff@`I@`C33333@`S33333@`6fffff@`,@`@_33333@_33333@_Ffffff@_333333@^33333@^`     @^@     @^,@^33333@^fffff@]@]ffffff@]l@]      @\33333@]@\ٙ@]&fffff@]l@]@]33333@^@]     @]      @]33333@\`     @\Y@\l@\@\fffff@\ٙ@\Y@\@     @\@[fffff@[33333@[l@[@     @[@Zfffff@Z@Z9@Y@Y@Y@Y@Yffffff@Y@Y33333@Z@Y@Yl@Y&fffff@Y,@X     @Xfffff@X@Xs33333@X333333@X33333@W33333@Wٙ@W@W     @W@W     @W     @Wl@W33333@W@Wfffff@W     @W@W     @WS33333@W33333@W@     @Wffffff@Wfffff@W      @W@W@Vٙ@V@Vfffff@V@V`     @VS33333@V333333@V33333@VS33333@V      @V333333@V33333@Vfffff@U@U@Ufffff@Uy@U9@U33333@U@Tfffff@T33333@T@T@Tfffff@TL@TS33333@T`     @T333333@TS33333@T      @TFfffff@T333333@T      @T&fffff@Tfffff@Tfffff@Tfffff@Sfffff@T@Sfffff@S     @S     @SS33333@S@Sffffff@Ss33333@S`     @Sfffff@S@     @S9@S&fffff@S      @Rfffff@R33333@Rffffff@Rs33333@R&fffff@R33333@Rfffff@Q@Q@Qٙ@Q@Qٙ@Q@Qfffff@Q@Q@Q@Qfffff@Qy@Qffffff@Q333333@Q33333@Qfffff@Qfffff@Q      @Qfffff@P33333@Pfffff@P@P@P@P33333@P     @Pfffff@PY@P      @P9@P      @O@O33333@O     @OY@OL@OY@O&fffff@O@O      @N@N33333@NL@N     @Nٙ@N@N&fffff@M@N@M33333@M     @M      @L33333@L     @L@L&fffff@Kٙ@Ks33333@KL@J33333@K&fffff@K333333@J@K&fffff@J@     @J@J     @J&fffff@J@J@     @I33333@I@Iٙ@Ifffff@I@Is33333@I&fffff@IY@IY@H33333@I@HL@Hٙ@H     @H@     @H333333@HL@Hs33333@H333333@Gfffff@Gfffff@Gٙ@G     @G@Gs33333@G333333@G     @Fٙ@G      @G     @F      @F     @F&fffff@FL@F@     @Efffff@Efffff@E33333@E@E     @E@E@E333333@E&fffff@E      @E@Dfffff@E@Dfffff@Dfffff@DL@D33333@Ds33333@D@C33333@Dffffff@D&fffff@D      @C@Dffffff@C&fffff@Dffffff@C@D      @Cs33333@C33333@C     @C@C&fffff@C@C      @B     @Cs33333@CL@B33333@Bfffff@B@     @BL@Aٙ@B@     @B      @A33333@Afffff@A@B@Affffff@A333333@Affffff@A&fffff@AL@A@@33333@A@     @@33333@@@A@     @A      @@@@fffff@@fffff@@@A&fffff@@ٙ@@L@@s33333@@s33333@?@@@     @@@?      @?L@>     @@333333@>L@>@?      @?      @>333333@=33333@=ffffff@>      @=fffff@=L@>33333@=ffffff@=     @>ffffff@>      @=L@=@=      @=33333@=33333@=      @<fffff@=fffff@;     @<33333@<33333@<      @;33333@;     @<@;@;@;@;ffffff@<@:@;ffffff@:fffff@;33333@:     @;333333@;ffffff@:ffffff@:@;ffffff@:@:@9fffff@:@:@:@:@:@9333333@:@:L@8@:      @:fffff@933333@9333333@:fffff@9@:      @9     @9      @9L@9     @8     @9      @9     @8@9     @9@8@9     @8333333@8fffff@7fffff@9      @9@7fffff@8fffff@8L@7@8     @7fffff@7ffffff@7@5ffffff@5@6@4     @6333333@3fffff@5      @3fffff@4     @3     @4L@433333@3fffff@4L@5333333@4ffffff@333333@4@3333333@4ffffff@3@4     @2@4@3@2@3@2@2      @1     @2@2@1333333@2333333@1@2     @2@1      @3ffffff@1@2ffffff@0ffffff@1ffffff@0@1@1      @/@1@/ffffff@0fffff@1@0@0@0fffff@0@0333333@033333@/@0@0     @/      @0333333@0@0333333@.      @0      @0      @0L@0L@0@.ffffff@/      @/333333@/ffffff@.@.@.@/      @/@/333333@.333333@-@+@,ffffff@-ffffff@.ffffff@-@+@-333333@*@+@+@*ffffff@,ffffff@)333333@+333333@+      @+ffffff@)@+      @+333333@+@*ffffff@)@)333333@+333333@*@*@)@(@*ffffff@*@)ffffff@'333333@)      @*      @)333333@*      @)ffffff@(      @*@*@&@)      @*333333@)333333@(@*333333@*      @)ffffff@)ffffff@)333333@'@)333333@)333333@'@*      @(      @)@(ffffff@)ffffff@)      @(@'@(                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ?M?7KƧ?\(?QR?Ƨ-?lD?-V?zG?5?|h?(\)?`A7L?nO;?o?lC?hr Ĝ?lD?1&y?1&?      ?zG?QR?I^5?}?-V?-V?Z1'?+I?+?"`B?񙙙?Z1'?lC?+J?j~#?\(?ěS?ȴ9Xb?QR?C%?+J?Q?tj~??Q?Z1'?      ?(\)?S?;dZ?E?=p
=?S?"`?/v?+?E?񙙙?5?|h?o?nO?dZ1?nO?=p
=?7KƧ?;dZ?$/?$/?\(?+I^?+J?Q?-?vȴ9X?"`? ěT?1&x?vȴ9X?A7Kƨ?\(?Gz?j~"?+I?ffffff?vȴ9?E?n?`A7?hr ?j~"?j~#?XbM?\(?O;dZ?bM?zG?ěS?1&x?hr Ĝ?E?lC?XbM?\(?=p
=?bM?Vt?+J?+J?bM?ϝ-V?lC?1&x?Ƨ-?+?ffffff?ȴ9Xb?Ł$/?Õ$/?I^5??ěS?|hr?lC?;dZ?&x?5?|h?lC?lC?lC?lC?lC?lC?tj~?1&?+??^5?|?+?^5?|?+?KƧ?XbM?"`B?+?^5?|?lC?^5?|?+?1&?+?"`A?+?+I?lC?S?S?QR?E?+J?^5?|?lC?lC?S?+?vȴ9?vȴ9?+J?+?Gz?XbM?+?+?+?dZ1?+?"`A?1&?+?+?vȴ9?bM?+?+?+?XbM?QR?+??"`B?lC?Gz?+?dZ1?lC?Gz?+?1&?lC?vȴ9???E??lC?lC?lC?"`B?"`B?+?+?"`B?lC?+?1&?E?XbM?+?p
=q?j~"?lC??Gz?lC??+?+J?lC?bM?Gz?lC?Gz??lC?lC?lC?S?bM?lC?lC?"`B?XbM?lC?E?+?1&?lC?lC?E?"`A??lC?tj~?+?vȴ9?tj~?lC?lC?vȴ9X?1&y?lC?(\)?E?lC?lC?lC??lC?/v?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?vȴ9X?1&y?lC?      ?dZ1?tj~?lC?lC?E?S?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?S?QR?1&y?Q?lC?lC?lC?lC?lC?vȴ9X?lC?j~"?p
=q?lC?lC?lC?lC?lC?lC?;dZ?lC?lC?1&y?-V?lC?lC?lC?Q?(\)?lC?Q?(\)?vȴ9X?lC?E?      ?j~"?lC?lC?lC?lC?lC?lC?lC?lC?(\)?Q?lC?lC?lC?lC?lC?|hr?lC?lC?lC?lC?vȴ9?XbM?lC?;dZ?lC?lC?lC?lC?5?|h?1&y?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?(\)?vȴ9X?lC?lC?lC?QR?S?vȴ9X?(\)?bM?      ?lC?lC?lC?lC?lC?lC?lC?lC?lC?Q?lC?lC?lC?lC?lC?5?|h?1&y?lC?lC?j~"?-V?lC?Q?lC?lC?lC?"`?j~"?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?;dZ?lC?j~"?"`?lC?lC?lC?vȴ9X?(\)?lC?lC?lC?lC?;dZ?lC?p
=q?-V?lC?"`?|hr?j~"?      ?vȴ9X?lC?E?j~"?      ?vȴ9X?lC?5?|h?/v?lC?lC?vȴ9X?/v?"`?      ?(\)?lC?lC?/v?vȴ9X?-V?-V?lC?lC?Q?lC?lC?lC?lC?/v?p
=q?Q?      ?(\)?|hr?lC?lC?"`?      ?      ?1&y?vȴ9X?(\)?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?;dZ?      ?      ?Q?hr!?;dZ?1&y?      ?|hr?lC?lC?5?|h?1&y?lC?;dZ?hr!?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?-V?5?|h?lC?lC?lC?lC?vȴ9?XbM?lC?lC?lC?lC?S?E?|hr?lC?lC?-V?-V?5?|h?/v?Q?;dZ?lC?lC?|hr?1&y?      ?Q?lC?lC?lC?j~"?      ?      ?vȴ9X?lC?lC?lC?;dZ?lC?hr!?      ?5?|h?lC?lC?lC?/v?      ?      ?1&y?lC?lC?|hr?|hr?lC?vȴ9X?lC?lC?lC?Q?1&y?(\)?Q?-V?/v?lC?lC?|hr?lC?vȴ9X?(\)?vȴ9X?lC?Q?      ?      ?      ?      ?/v?lC?lC?(\)?5?|h?lC?lC?lC?lC?lC?vȴ9X?1&y?      ?      ?"`?lC?lC?;dZ?E?lC?/v?-V?lC?lC?lC?lC?;dZ?lC?lC?lC?lC?1&y?      ?      ?|hr?lC?5?|h?vȴ9X?lC?lC?lC?"`?      ?      ?|hr?hr!?E?lC?Q?(\)?E?j~"?lC?;dZ?      ?      ?-V?lC?lC?vȴ9X?      ?vȴ9X?j~"?      ?"`?1&y?      ?E?lC?Q?-V?      ?lC?-V?      ?hr!?      ?      ?1&y?A7Kƨ?hr Ĝ?      ?p
=q?;dZ?Q?5?|h?/v?lC?lC?;dZ?(\)?lC?5?|h?lC?lC?"`?lC?|hr?      ?      ?      ?      ?E?lC?lC?;dZ?"`?Q?j~"?lC?|hr?      ?      ?p
=q?|hr?E?(\)?      ?5?|h?-V?      ?      ?      ?      ?|hr?lC?lC?5?|h?lC?E?vȴ9X?lC?lC?"`?lC?lC?;dZ?1&y?ěS?nP?p
=q?;dZ?lC?/v?5?|h?hr!?      ?      ?-V?1&y?-V?Q?p
=q?      ?      ?p
=q?nP?nP?      ?p
=q?      ?hr!?1&y?Q?lC?E?      ?GzH?lC?lC?lC?"`?p
=q?|hr?E?/v?j~"?      ? ěT?GzH?p
=q?      ?"`?lC?"`?
=p?"`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	@N@O      @O@O@O      @O      @N33333@O      @O      @O      @O      @O      @O      @O@O@O@O@O@O@N33333@N33333@O@O@O@O@N33333@N33333@O      @O      @O@O@O@O@O@O@O@O@O@O@O&fffff@O333333@O333333@O333333@O333333@O@     @O@     @O@     @OL@O@     @OL@OL@OY@OY@OY@Offffff@Os33333@Os33333@OY@Offffff@Os33333@Os33333@O     @O     @O@O@O@O@O@O@O@O@O@O@O@Offfff@Offfff@Offfff@O33333@O     @O@O@O     @O     @O     @O     @O@Oٙ@Oٙ@Oٙ@Offfff@P      @P@P33333@P,@P9@PFfffff@PY@Ps33333@Py@Pfffff@P33333@P@P     @P     @P     @P     @P     @Pfffff@P@Pfffff@P@P33333@Pٙ@P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P@P@P@P33333@P33333@P@P@P@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P33333@P33333@P33333@P@P@P@P@P33333@P33333@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P@P@P@P33333@P33333@P@P@P@P33333@P33333@P33333@P@P@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P33333@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P33333@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Qfffff@P33333@Pٙ@Qfffff@Q@Q@Qfffff@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q33333@Q@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q@Qfffff@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q@Q@Qfffff@Qfffff@Q@Q@Q@Q33333@Q33333@Q33333@Q33333@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q@Q33333@Q33333@Q33333@Q33333@Q@Q@Q@Q33333@Q33333@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q@Q33333@Q33333@Q33333@Q33333@Q@Q@Q33333@Q33333@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Qfffff@Qfffff@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@P33333@Qfffff@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q@Q@Q      @Q      @Q      @Q      @Q      @Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q@Q      @Q      @P@Qfffff@Q@Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Qfffff@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q@Q      @Q      @Q@Q      @Q      @Q      @Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q@Q@Q@Q@Q@Qfffff@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    P11                                     1                                       WBCj*i3P