CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20120522   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P13    CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:48.093081Z    ORIGINAL_HEADER      sCTD,20250210CCHSIOWB
#Renamed 'CTDFLUOR_TSG' to 'CTDFLUOR_ALT_1' with units 'MG/M^3'
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2018-11-29. CTD data from cruise 18DD20120522, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20120522. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2012-12/index.php. 
#
# The information in this file for the cruise 2012-12 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-0072.ctd
#
# Start of originator file comment header
#
#*2018/11/29 14:22:51.16
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2012/06/01 08:02:46.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 2006
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : C44EDC1F
#    NUMBER OF CHANNELS  : 9
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            2.3            2006.7
#       2 Temperature:CTD               deg_C_(ITS90)   1.9166         6.6907
#       3 Salinity:CTD                  PSS-78          32.6639        34.5892
#       4 Sigma-t:CTD                   kg/m^3          25.6458        27.6748
#       5 Transmissivity:CTD            %/m             61.4           67.9
#       6 Oxygen:Dissolved:CTD:Volume   ml/l            0.41           7.23
#       7 Oxygen:Dissolved:CTD:Mass     µmol/kg         17.9           314.7
#       8 Fluorescence:CTD:Seapoint     mg/m^3          0.24E-01       0.74
#       9 Fluorescence:CTD:Wetlabs      mg/m^3          0.102          1.096
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        6  F       ' '     1
#       6  -99   ' '        7  F       ' '     2
#       7  -99   ' '        6  F       ' '     1
#       8  -99   ' '        8  F       ' '     3
#       9  -99   ' '        8  F       ' '     3
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2012-12
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P24
#    EVENT NUMBER        : 72
#    LATITUDE            :  49  50.17000 N  ! (deg min)
#    LONGITUDE           : 142  40.04000 W  ! (deg min)
#    WATER DEPTH         : 3989
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    CTDEDIT was used to remove surface records and records corrupted by shed
#	wakes; salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Transmissivity, Fluorescence and PAR data are nominal and unedited except
#	that some records were removed in editing temperature and salinity.
#
#    For details on how the transmissivity calibration parameters were calculated
#	see the document Transmissivity_Calculation.pdf.
#
#    The Oxygen:Dissolved:CTD calibration was done using the method described in 
#	the Sea-Bird Application Note #64-2 (Sea-Bird_64-2_Jun2012.pdf).
#
#    The Oxygen:Dissolved:CTD data are considered, roughly, to be:
#	±0.1 ml/l from 0 to 125 dbar.
#	±0.06 ml/l from 125 to 500 dbar.
#	±0.04 ml/l from 500 to 2000 dbar.
#	±0.02 ml/l below 2000 dbar.
#
#    For details on the processing see processing report: 2012-12-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5-- --6--- --7-- ---8--- ---9---
#!Pressu Temperat Salinity Sigma-t: Trans Oxygen Oxyge Fluores Fluores
#!re:CTD ure:CTD  :CTD     CTD      missi :Disso n:Dis cence:  cence: 
#!                                  vity: lved:  solve CTD:    CTD:   
#!                                  CTD   CTD:   d:CTD Seapoin Wetlabs
#!                                        Volume :Mass t              
#!------ -------- -------- -------- ----- ------ ----- ------- -------
#*END OF HEADER
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @C         data_max      @C         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     >  .    pressure                	long_name         pressure   positive      down   units         decibar    data_min      @         data_max      @\        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      >  l   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d        `   temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?Ov_خ   data_max      @"BZc    C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       >     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d           salinity                	long_name         salinity   units         PSS-78     data_min      @@Ss   data_max      @AK@N   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      > 	P   salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d       G   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @&333333   data_max      @sq   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        > W   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d       8   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?(\)   data_max      @bM   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      >    CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d          PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       > (   PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d       2   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min      @Lffffff   data_max      @P   C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     > Bp   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d          station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         (    cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         (    time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min         data_max         C_format      %10d          latitude               	long_name         latitude   units         	degrees_N      data_min      @Ha   data_max      @Ha   C_format      %9.4f             	longitude                  	long_name         	longitude      units         	degrees_E      data_min      `uNzVC   data_max      `uNzVC   C_format      %9.4f             	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d           	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min        G   data_max        G   C_format      %4d        @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @C      @      @      @@      @@ 333333@"      @$      @&      @(      @*333333@,      @.      @/@1      @2      @3@4@5      @6      @7      @8      @9      @9fffff@;@<      @=      @=fffff@?      @@      @@     @A      @A     @B      @B     @C      @Cs33333@C33333@D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S@T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @Vfffff@V@W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @YFfffff@Yy@Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @aC33333@a`     @a     @a     @a     @a     @b      @b#33333@b<@b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f#33333@f@     @f`     @f     @f     @f     @f     @g      @g@g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l@m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n33333@o      @o      @o@     @o`     @o     @o     @o     @o@p      @p     @p      @p0     @pA@pNfffff@p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @rA@rP     @r`     @rp     @r@r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @sᙙ@sfffff@t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @vfffff@vᙙ@v     @w      @w     @w      @w0     @w@     @wNfffff@w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @zfffff@z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|Nfffff@|a@|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}@}fffff@}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @ᙙ@fffff@      @     @     @     @      @'33333@0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @/33333@8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @      @     @     @     @      @(     @0@8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @@@     @     @     @     @     @      @     @     @@      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8@@     @H     @P     @X     @`     @h@o33333@x     @     @     @     @@33333@     @     @     @     @     @33333@     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @33333@(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @u@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @33333@     @     @@33333@     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @@33333@     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @@      @     @     @     @      @(@0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @~fffff@33333@     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P@X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @      @     @
@     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @@      @     @     @     @     @fffff@     @     @      @$     @(     @,fffff@0     @4     @8     @<     @@     @D     @H     @K@P     @T     @X     @[@`     @d     @h     @l     @o@t@x     @|     @     @     @33333@@     @     @     @     @     @     @     @     @     @     @@fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @+@0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @Xfffff@[@`     @d     @h     @lfffff@p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@י@     @     @     @     @     @fffff@󙙙@     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @k@o@t     @x     @|     @     @     @     @     @     @     @     @     @@     @     @     @     @     @@     @     @     @     @fffff@     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @fffff@     @      @$     @(     @,fffff@133333@4     @8     @<     @@     @D     @F@L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @@      @$     @(     @,     @/@3@8     @<     @@     @D     @H     @Lfffff@P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @@     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @M33333@P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @fffff@@     @     @     @     @fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @ fffff@@     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @㙙@     @     @     @     @fffff@     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @c33333@hfffff@l     @p     @t     @w@~     @     @     @     @     @fffff@33333@     @     @     @     @fffff@33333@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @󙙙@     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @J@P@T     @X     @\     @_33333@d     @h     @l     @p     @t     @x     @|     @@     @     @     @@fffff@     @     @     @     @     @     @     @     @     @fffff@@Ù@     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @@     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @W@\     @`     @d     @hfffff@l@p     @t     @x     @|     @     @     @     @     @     @     @     @@     @     @fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @㙙@@     @     @     @     @     @      @@     @     @fffff@     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @fffff@˙@     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @pfffff@s@x     @|     @     @@33333@     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @U@X     @\     @`     @d     @h     @k@p     @t     @x     @|     @~fffff@@     @     @     @     @     @     @     @     @     @fffff@     @@     @     @     @     @     @͙@     @     @     @@     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @㙙@     @     @     @fffff@     @     @      @     @     @     @     @     @     @     @      @$     @(     @+@0     @4     @8     @<fffff@?33333@C@H     @L     @P     @T     @W@\     @`     @d     @hfffff@k@p     @t     @x     @|     @     @     @     @fffff@     @     @     @     @     @     @     @     @     @fffff@@     @     @     @     @     @     @     @     @     @     @     @     @@fffff@     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         @"BZc @"s@!\N<@!-
@!Q@!K]c@!+a@!ⶮ}Vm@!=K^@!҈p:@!cA \@!P{@!	 @!K]c@!?@!m\@!?@!@!@4@!ěT@!u!@!d8@!$/@!-
@!
qu@!b}V@!\N<@![@!PH@!5Xy@!Y@!U@!2a|@!hr!@!䎊r@!TɅo@!&
L/@ as@1@[S@҈@kP|@&I@xF@fA@[W>6z@B@4n@/v@?@kP|@
n@e@;5X@a@N@MjO@jOv@p
=q@XU@>\N<@$Z1@U=@X@XbM@^@L_@1@@@T@~BZc @WXe,@]ce@$/@Dg8~@U2a|@nO@~"@s@g@8l"h	@+P{@+j@rGE9@/V@֡af@Dg8~@䎊@}<64@\N;@5\(@+I@Zc@TɅo@L_@9XbN@'RT@_o @9rGE8@{@As@L_@/{J#@"wkQ@Q_@*0@
D@
=p
@s@,q@=H˒@QN;5@d7@sPH@rGE9@ө*0U2@ n@Z@}H@g8}@ -
@:xl"h
@\]ce@쿱[W@IQ@Y@5'0@Em\@Uᰉ@eO
@n.2@?@W>6z@x@_ح@PH@ɺ^5?}@҉@-w1@jf@-V@U=@ރ%@E@]cA@d8@|Q@bM@nO@Q@=K^@@D*@@ѷX@XbM@XbM@!.@!.I@D@K]@
(@b@vȴ9X@v@m\@/{J#@D@ɺ^5?}@Ňݗ@PH@'0@hr!@wk@]ce@>6z@@fA@rGE9@+I@s33333@Y+@6Fs@-C\@%+a@]cA@!.H@{@D*@̘_@)^@6z@5Xy@Xy=@O
M@rGE@S@3@JE@@f@[q@S&@8F]d@ 
qu@2X@0
)@͞%@Fs@kP|@Xe,@sP@zC\@ZQ_@F
L/@>($x@8)@6C-@/4֡a@&'@S@,<@@,@ߤ@@Ϫ͟@sP@Fs@j~@]ce@5Xy>@lC@O
M;@FFs@2m\@N;6@6z@Q@1@:@Q@a@@)^@8YK@~m\@{5Xy@m8Y@Rp:@H1&x@DS@A$/@;s@2W@-U=@*Ov`@&fffff@!-w1@y=c@p:@
@I^@@.H@Q@$tS@kU=@Xtj@I^5?}@7+@`A7@ IQ@͞&@ce@ ѷ@)y@!-w@ae@ěT@*0@'/W@}E@z>B@j0U2a|@_o@OrGE9@O@LL_@Ik~(@A:S@.t@!R<6@?@o@˒:*@u%F
@m\@C\@F@!.I@J@!-w2@@!-w@Ov`@M@vȴ9@@+J@w1@j͞&@c9@S҉@F-@A7Kƨ@(	ԕ+@*0@H@+@
ڹY@$/@KƧ@ڹZ@oiDg8@lC@-w1@D*@
M;@}!.H@irGE@f1.@nzG@nH@nc	@dTɆ@WO;d@P-
q@I7KƧ@F-@DJM@<Z@3E@+6z@$TɆ@#A [@C,zx@u@?@
=p@4J@7KƧ@Ňݗ@ĵ?@r Ĝ@S@*0@@q@ ѷ@˒:*@1&x@E84@.H@t3@m\@c9@V@O'/W@L@JD@H@FYJ@C,zxl@=Vl!@;A@:^5?|@<Z@6_ح@8l"h	@.1@0U2a|@3g@.2X@حV@ -
@!-w1@sh@C%@	oiD@zH@ hۋq@$tS@"@C\@73@3@YJ@}H@'0@oiDg8@:~ @
qv@@9@A [@L/{J@,<@'RT`@ңS&@*0@#x@dZ@/V@!.@ ě@q@*0U2a@lC@S@Z@wkQ@ߤ@@>BZ@D*@sh@p:@hr @@R@_p@v_ح@;5X@_@@_@]cA@^5?}@ڹY@L/{@'RTa@@\N@a@N@F]c@o i@@{lC@tD@ae@P)^@T`d@Rm@KƧ@;5Xy@2 ě@+P{@!-w1@҉@bM@
@@I^5?@
n@	^5?}@#@ݗ@u%F
@|hs@ hۋq@&IR@4֡b@m\@iB@g@6z@RT`e@fffff@+a@Z@ae@IQ@(\@6@W>6z@kP|@_o@ߤ@@ ѷY@M@思IQ@$xG@-@Xy=@ۋq
@Dg8~@y@Ov`@I^@1&y@c	@-V@-V@0U2a|@Xy=@ڹ@TɆ@`A@3@|Q@@N@ěT@A7K@u!@-
@[6@U=@حU@D*@+@ӎMj@$tT@$tT@(@˒:*@/V@z@A [@-V@I^@RT`e@'@A@+a@S&@.H@o@Gz@䎊r@u@&@@p:@N;5@M:@@@7Kƨ@@{5Xy@u?|h@r-V@pD@oiDg8@nc	@mhr!@ka@@jd7@irGE@fIQ@f@f@f@e1@ezxl"h@dqj@b`A@b3@`
qu@_حV@_Ft@^Q@^Ov_خ@]}H@Np:~@D*0@=p
=@5?@5!.@5Xy=@4֡a@3ߤ@4j~@5!.@5?@5\(@5Xy=@2m\@,"h	ԕ@%1@}H@U@$/@sh@$/@fA@䎊@*0U@o @'/W@Vu@:)z@)^	@
qiC@
L_@
ڹY@	^5?}@]cf@ C@l"h	@@-V@9XbN@sg@KƧ@'0@V@>B[@,@F
L0@F
L0@/@tSM@tSM@tSM@xF@9@ěT@eO@eڹ@]ce@VϪ͟@M%@M%@M:@K:)z@JD@HK]c@E@Dg8}@ATɅo@<Z@8}H@,<쿱@@+J@:)y@o h@m\@J#9@D@䎊q@GE85@u!S@ hۋ@%1@а{@Ƨ-@BZc @}H@m8@-@zxl"@'@+j@S&@!R<@L/{@_o@ݗ@o hی@{s@x-
@u%F
L@o4֡a@cA [@]cA @TɅoi@IoiD@J#9@JW'@I^5?}@B@ATɅo@84֡b@,1&y@:)y@
(@S&@
ȴ9X@
 hۋ@
䎊qj@
>@
՛=K@
@
o i@
&IR@
7Kƨ@
&IR@
Õ$@
7Kƨ@
vȴ9X@
~@
C-@
{@
zG@
\)@
	@
IQ@
@
@
u%F
@
{m]@
oiDg8@
o4֡a@
o hۋ@
l!-w@
l"h	ԕ@
jJL@
e`A7L@
U2a|@
N+@
NT@
K:)z@
D*0@
A@
<j~#@
73@
3|@
1[W>6@
/Vϫ@
.H@
,q@
)lD@
'RT`e@
"wkQ@
Q@
e+a@
ᰉ@
$/@
Z@
zG@
nO@
-
q@
@
҈@
+I@
Fs@
&I@
n/@
S&@
nP@
u%F
@
@$tS@(@!.@Y|@u!S@+@а{@@Ƨ@#9@ȴ9Xb@]cf@4m@K]@j~#@XbM@ߤ@RT`e@_F@u@'/@?@@~($x@|#x@{J#9@xl"h	@u!R@u%F
L@tD@s@oiDg8@kP{@h	ԕ+@d7@dqj@e`A7L@e+a@cZ@b@4@^5?|@Z1'@T*1@P|@Jn@GE84@E@Eo i@A7Kƨ@@n@?H˒:@;5Xy@6E@4֡a@1&x@.2X@+6z@$TɆ@Q@+J@*0@tj~@'/W@xF]@
=p
@YJ@PH@!-w2@C\@C,z@	k@7@
qu@1'@As@̘_@W'@ [7@A@#w@Xe@'0@3@|@g	l@'RT@@o@	@U=@u@kP|@*0@S&@@ ѷ@{J#9@wkP@sMjO@n.2@irGE@dqj@b@4@[$@XU@Vt@T,<@K)^	@HK]c@G@@?@/v@-V@-V@S&@1&x@
lC@
E@
A [@
4֡a@
O;@
C\@
8Y@
8Y@
!-w@
C,z@
ᰉ'@
	ԕ+@
u!@
6@
l!-@
т@
/{J#@
@
o i@
&IR@
4m@
6@
[W>@
ߤ?@
p
=@
j~#@
n.@
n.@
S&@
Xy=@
J@
'0@
'0@
?@
ߤ@
 ě@
0U2a|@
[6@
[@
6C@
@@
tj@
@
@
xF]@
ԕ*@
+I@
S&@
Q@
tj@
JM@
tj@
tj@
u%F
@
IQ@
4m9@
|Q@
weں@
uY|@
sMjO@
q@
g@
a|Q@
Z1'@
VϪ͟@
UfA@
TE@
Sa@O@
SMj@
Sa@O@
SMj@
Q@
H˒:*@
F]cf@
E84֡@
Ca@N@
9#w@
4J@
3g	l@
333333@
2a|Q@
1&x@
0U2a|@
-w1@
)lD@
($xG@
'&@
!o@
 -
@
U=@
@
!R<@
eO@
&I@
o h@
nP@
F]c@
u%F
@
$/@	b}V@	ڹZ@	lC@	Fs@	C,z@	 ѷY@	?@	y=c@	H@	Ϫ͞@	#9@	@	ǮzH@	š@	6@	p
=@	KƧ@	U=@	TɅ@	&@	9@	$tS@	L_@	ڹY@	u%F@	@	z>B@	vFs@	u!R@	uY|@	tD@	u!R@	qiB@	dZ1@	\>@	XD*@	TE@	M:@	F?@	C@	BZc@	A@	?[W>@	<쿱[@	84֡b@	0'RT@	*0
@	$/@	!R<6@	u@	ߤ@@	@	nO@	)^@	@	
@	 ѷX@	k~@iB@빌~($@+a@A [@Ft@c	@䎊@+@;5X@5Xy>@W'@?@,zxl@K]@'RT@RT`e@!-w1@*0U2@Vu@~($x@7KƧ@tj@~"@y(@sPH@jfB@iDg8~@g	k@e+a@_حV@\N;@Y+@W
=p@O
M;@K]cA@GzH@B&IR@?|hs@>vȴ9X@:^5?|@5'0@.2X@)*0U2a@&L/{J@ [6@ 'RT`@vȴ9@䎊r@䎊r@vȴ9@vȴ9@ 'RT`@ -
@ 	k@U=@_o@R<6@L_@L_@zG@nO@@@@JM@@4n@Y|@c	@>BZc@+a@S@Ft@حU@@+@Ƨ-@}H@U2a|@U=@-@IQ@tSM@Q@sP@@Vu@@L/{@k~(@n/@wkP@o hۋ@lC@jg	@iDg8~@hr Ĝ@glC@f,<@ffffff@d%1@be+@`҈p@^iB@[$@Xe+@Vt@QR@QN;5@M5Xy>@Ks@DS@@4m@@NU@@n@@n@@n@?[W>@?@?[W>@84֡b@333333@0{@0 ě@/Vϫ@.zG@,zxl"@+jf@+6z@*d7@)lD@*d7@)*0U2a@%F
L0@%@ᰉ@*0@4J@ߤ?@
M:@K]d@Q@F]c@˒:)@H˒@l"h	@MjO@Ov`@Gz@حV@$@sPH@N;5@5Xy>@]cf@s@n.@3@?|h@m\@Vϫ@F
L0@'RT`@qu!@*0@Mj@	 @ ѷ@Fs@o hی@I^5@}Vl!@|PH@xF@weں@tD@r ě@sE@rGE85@qA [@poiDg8@mhr!@lC@kP{@bM@\]ce@ZY@Y>BZ@Xe+@W@U2a|@L/{J#@B\(@@C@@6@<Z@9XbM@8Q@0'RT@)@[@@N@N;6@!R<@+I@?@@>B@\(@iB@쿱[W?@~"@7@@N@5?|@1'@ӎMj@_p@ΤT@p:~@ΤT@5Xy>@ɅoiD@84֡@ěS@ [7@A@Xy=@r@0U2a|@TɆ@
=p@-
@-
@'RT`@	@Ov_خ@,=@[@PH@Fs@@$tS@xl"h	@u%F
L@q@hۋq
@_حV@XbM@RT`d@PH@LcA \@GE84@Ca@N@B\(@BZc@@n@?@>ߤ?@<Z@:^5?|@84֡b@5Xy=@/Vϫ@/v@,q@,<쿱@*d7@%S@!ae@+J@
@ݗ@S&@JM@nP@ IQ@"@#x@m]@+jg@@4֡a@:~ @JL@fffff@Z@d8@ܑN;@bM@ԕ*1@т@jOv@)^@2W@&IR@j~#@3@|@ ě@1@zG@͞&@n.3@ěT@vȴ9@%@ߤ@@6C@O;d@bM@S&@|#x@z@u%F
L@sMjO@ql@mhr!@h>BZc@eڹ@d%1@dqj@b@4@ae@a|Q@`҈p@`d8@]/w@Xy=c@SMj@N;5X@LcA \@I@Gy@H˒:*@H˒:*@HK]c@G@@C@@6@>BZc @;/V@9Y}@9~($@7Xe@0{@.1@-V@,<쿱@(TɅ@#
=p@,=@_F@Xe,@Ov_@ᰉ@L_@@@N@nO@N;6@4J@bM@Vu@
M:@xF]@'/@+I@F]c@$t@ڹZ@	k~@-
@!.@MjO@{m@
=q@oiDg8@
=q@iDg8@r Ĝ@@唯O
@`A7L@䎊qj@e@҈p@ڹY@|@̘_@D@@Ƨ-@8YK@,zxl@@)_@}H@U=@IQ@/@9@-
@Q@-V@wkP@6C@ᰉ@Fs@n@C%@+I@YJ@Q@@weں@cS@\]ce@Y>BZ@U=K@OAs@I^5?}@As@?[W>@?|hs@?@>
(@;/V@6E@49XbN@12W@0 ě@/r@,zxl"@'-@ [6@S@_o@tj@@@O;d@R<6@
(@o hی@ 4m9@$tS@E@(@g@GE85@:~ @hr!@C@P{@"h	ԕ@JL@8}H@]ce@T`d@&@H@;dZ@:@D@ɺ^5?}@ɺ^5?}@K]c@ǮzH@Ƨ-@84֡@g8}@84֡@ěS@NU@K]@dZ@~($@Xe@{@B@-@9@9@n.3@`A@	k@ěT@-
@vȴ9@U=@IQ@Q@u%@=K^@_o@Xe,@+J@S&@bM@Mj@(@qu"@L_@C%@	 @u%F@oiDg@}Vl!@{~$@x-
@w1@u!.@sg@ql@o@nO;@nc	@nc	@nO;@nc	@nc	@n.2@m8Y@mhr!@mhr!@m\@m(@lVϪ@kC]@jg	@iB@gfA@d%1@b@4@b}Vm@bM@]/w@ZQ_@QX@O͞@M5Xy>@JL_@I^5?}@H@F-@E@B@>vȴ9X@<쿱[@;dZ@:~@84֡b@7KƧ@5'0@0 ě@*d7@)y@'/V@',@%zxl"h@쿱[W@PH@@
(@
	 @1&x@K]d@@@˒:)@Y|@䎊q@GE85@A [@@Ov`@e@%1@%1@Z@	@ⶮ}Vm@|Q@u!@ٳ|@2a|@՛=K@՛=K@2a|@Z@т@/{J#@K]c@s@84֡@a@N@Zc@NU@6z@BZc @K]@64@dZ@KƧ@W@ ě@U=@6z@9@,=@u"@ߤ@@qu!@,<@,<@,<@u%F@u%F@u%F@6C@6C@kP|@kP|@kP|@6C@u%F@_o@_o@_o@6C@_F@L_@S&@hr @@#@S&@@hۋq@{lC@u!.@rs@oiDg8@m8Y@kC,z@jOv`@gfA@g	k@glC@e@dZ1@ae@_;dZ@Z1'@V8YJ@R䎊@P*0U@L_@G@@D2W@C$@B\(@BZc@@NU@=<64@:)_@6}Vl@5sg@4m8@43@3ߤ@2m\@2a|Q@1[W>6@/O
M@,1&y@+6z@)y@'-@%S@$?@$xF@#S&@!.H@!-w1@vȴ9@kP|@ݗ+k@:)y@:)y@4J@rGE9@Mj@@K]d@Q@ ѷ@ .H@ #x@ l"h	@ !.@ !R@ Y|@ Y|@ #@ g@ E@ PH@ iB@ oiDg8@ :~ @  hۋ@ hr!@ 쿱[W?@ 빌~($@ g	@ x@ Dg8~@ @ 	k@ 唯O
@ Z@ Gz@ ߤ?@ iB@ ڹY@ T`d@ 
M;@ ΤT@ 5Xy>@ :@ @ #9@ ]cf@ 74@ TɅo@ TɅo@ TɅo@ Zc@ a@N@ @ C@ 
(@ A@ Y}@ #w@ #w@ 4֡b@ #w@ )@ 4m@ E@ ?@ ?|h@ W@ -@ U2a|@ O
M@ zG@ >B[@ I^@ \)@ Xy=@ -@ ,@ L/{J@ TɆ@ `A@ U=@ 1&@ vȴ@ @@ @ Fs@ )^@ qi@ L/{@ eO@ @ oiDg@ ݗ@ F]c@ ѷX@ :S@ ѷX@ ~$t@ {lC@ {s@ z>B@ zxl"h
@ y=b@ x-
@ vȴ9X@ u!R@ tSMj@ sMjO@ qA [@ o-V@ nt@ kQ@ jJL@ j~"@ iᰉ'@ iᰉ'@ ix@ hۋq
@ irGE@ h>BZc@ h	ԕ+@ fA@ dqj@ _?@ ]/w@ WsPH@ Rm@ P{@ KƧ@ H@ GzH@ F]cf@ F-@ Gy@ F]cf@ Gy@ F]cf@ G)^@ GE84@ G)^@ GE84@ G)^@ G)^@ Fs@ G)^@ G)^@ Em\@ Em\@ Em\@ D*0@ DS@ DS@ DS@ DS@ DS@ C$@ B74@ ?H˒:@ =<64@ <쿱[@ :S&@ 73@ 0U2a|@ /{J#:@ *͞&@ &x@ %S@ $?@ #n.3@  [6@ C,zx@ ,<@ vȴ@ _o@ e+a@ ᰉ@ nO@ bM@ Mj@ 
O;dZ@ 
L/{@ 	'RTa@ 	7KƧ@ 	 ѷ@ 	 ѷ@ u%F@ #@ oiDg@ Q@ nP?s?~$?E?rGE8?+?eں?+?73?73?eں?\(?E?䎊q?s?䎊q?{m?l??-V?t?hr!?1.?Gz?ݗ+j?Q_?Q_?Q_?fA?䎊?Ϫ͞??2W?2W?74?74?&IR??&IR?n?}Vl?{?'RT?}Vl?1?>B[??L/{J?3?S?+j?ݗ+k?tj~?hr ?q?'RTa?eO?%2?|??y(?y=b?sg?q?p
=q?p
=q?o?o hۋ?l!-w?lC?iB?e+a?_Ft?Zݘ?Vl!-?TɅoi?M?IQ?E?>6z?=K]?<64?;dZ?:~?2W?0
(?.H?,<쿱?+jf?*0
?*0
?*0U2a|?)y?)y?)^?)^?)^?(\)?(?($xG?'RT`e?%1?$tSM?#wk?"`A?Ov_خ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @@Tn.@@TL_@@TL_@@TxF@@Tn.@@TL_@@T@@TJ@@Tߤ@@@TJ@@T1&y@@TJ@@Tn.@@TxF@@TxF@@TxF@@Tn.@@TJ@@T1&y@@TJ@@TJ@@Tn.@@Tn.@@Tn.@@Tn.@@Tn.@@S\N@@Tn.@@S\N@@S\N@@S\N@@Ss@@S\N@@Ss@@TJ@@T,<@@T/@@UO
@@US@@UoiDg@@U?@@U\(@@U8Y@@VOv_@@ViB@@Vm\@@W hۋ@@W
M;@@WXe@@W$tS@@W8}H@@V"@@V҈p;@@V+@@W
=p@@W1@@WFt@@Vߤ?@@V$t@@V6z@@V҈p;@@Vx@@V]cf@@V"@@W
=p@@VA@@V'@@V-@@V@@VϪ͟@@VA@@VQ@@VQ@@Vqi@@Vfffff@@VYJ@@VR<6@@ViB@@V&I@@Wo@@W&@@W$tS@@W	k@@W$tS@@WsPH@@WRT`e@@W1@@WKƧ@@WKƧ@@WlC@@W˒:)@@XF]d@@Yhr @@ZM@@[m]@@\M:@@Zᰊ@@Ye@@YN;6@@Yᰉ'@@[A@@]O
@@]C\@@^zG@@_r@@`_F@@a+@@d?@@fYJ@@hѷX@@j3@@j,<@@ln.@@ov_ح@@rQ_@@uO
@@y:S@@{Q@@,@@g@@
=p@@	@@ڹ@@I^5@@#@@}Vl@@:S@@J@@+j@@s@@8YJ@@B@@zG@@4K@@ [7@@"@@S&@@2a|@@_ح@@@@D@@Ǵ3@@ [7@@'/@@͎!R@@bM@@6@@ؾ
(@@ٷX@@ڏ\(@@ۈeO@@ܘ_@@<64@@8YJ@@'RT`@@ae@@ԕ*@@I^5@@0U2a|@@Q_@@h	ԕ@@ⅇݘ@@@@@@@@:S@@B@@C,@@m8@@D@@M:@@u@@}Vl@@'@@Q@@҈p;@@
=p@@KƧ@@o @@ ě@@n@@n@@u%F@@TɅ@@
(@@4֡b@@+@@ [7@@ [7@@&x@@-w1@@Gz@@Q@@[W>6@@Q@@TɅo@@[W>6@@[W>6@@TɅo@@A [@@A [@@A [@@-w1@@+@@C@@@@ۋq
@@)@@{@@{@@4m@@u%F@@y=c@@l"h	@@bM@@eO@@[6@@Xy=@@K]c@@A7K@@D*@@1&x@@$xG@@ ě@@ ě@@'RT`@@$xG@@@@	ԕ+@@*0U@@Vϫ@@حV@@;dZ@@+@@ﴢ3@@͞@@?@@-V@@kP@@$tS@@{J#:@@v_ح@@sPH@@o@@sPH@@b}V@@_o@@b}V@@iDg8@@sPH@@sPH@@sPH@@y@@|hs@@4m@@{J#:@@v_ح@@v_ح@@ݗ+@@&@@y@@sPH@@iDg8@@U=@@E84@@E84@@RT`e@@RT`e@@KƧ@@RT`e@@U=@@O
M@@As@@4֡a@@+I@@>6z@@O
M@@H˒:@@;dZ@@>6z@@U=@@v_ح@@kP@@$tS@@ݗ+@@@@?@@	k@@ݗ+@@{J#:@@	k@@vȴ9@@ﴢ3@@阮&@@͞@@[W>@@o @@˒:)@@حV@@rG@@#@@
qu@@ ě@@ ě@@'RT`@@A7K@@oiDg8@@u!@@tj@@ěT@@҈p@@4֡b@@ [7@@@@	k~@@	k@@\)@@	k~@@	k~@@@@4֡b@@rGE@@-w1@@Gz@@JE@@e+a@@2W@@ԕ*@@=p
@@JL@@W'@@ᰊ@@L/{@@c	@@s@@	@@,zxl@@W>6z@@U=@@@@g@@L_@@#@@S@@wkP@@SMj@@M:@@<쿱@@M:@@N;@@hr@@V@@2a|@@Y|@@!R@@@@8Y@@Ϫ͞@@
qv@@($x@@p:~@@IQ@@$tS@@v_ح@@4m@@	@@ݗ+@@$tS@@@@O;d@@	k@@3@@@@n@@@@ěT@@D@@{@@+@@N;5@@rGE8@@x@@7Kƨ@@B@@^5?}@@^5?}@@o@@>BZ@@R@@.H@@GE85@@u%F
@@c	@@҉@@nP@@'/@@~@@D@@c	@@m@@u%@@s@@&@@/V@@g	l@@A@@a@@@$@@@@@@!-w2@@C,zx@@`d@@q@@~($x@@qj@@S@@zxl"@@*0@@u"@@@@!.H@@ce@@$/@@v@@8YK@@,=@@E@@
(@@iB@@@@A@@!.I@@'/W@@As@@RT`e@@sPH@@{J#:@@[W>@@䎊r@A 6@A A7K@A H@A oiDg8@A -
@A p:@A	k~@Ao@A@AN;6@A^5?}@A'R@AX@AI^5@Ap:@A0
@AL/{@A@A>B@A)_@AC,@A~@AS&@As@A,zxl@A@N@Aqu!@Aq@Awk@AQ@As@A,<@A2W@A<쿱@AI^5?@AZ1@A?@A5Xy>@AIQ@AO;dZ@AS&@A`A7L@A!R@AcA @AS@A$/@AFs@AFs@AFt@A
=p@AXe@Av@A8}H@AKƧ@ART`e@A_o@A4m@AkP@A/V@A+j@A*0@AQ@Al"h	@A
(@A\)@A	*0U2a@A	:S@A	JE@A	e+a@A	rGE8@A	x@A	x@A	@A
	 @A
C\@A
{m@A
ᰊ@A
}Vm@A
D@Au%@A)^	@An.3@A\N@AFs@Ag8}@AzG@Aqj@A#x@A*0@Ae@A
[@A
qu"@A
qu"@A
(@A
5Xy>@A
<64@A
\@A
zxl"h@A
!R@A
v@A
8Y@A
(@A($x@A;5X@AR<6@Ap:~@A-@A@At@A+@Aߤ?@A@A hۋ@A)^@A,@A;dZ@AE84@AE84@AE84@AH˒:@AO
M@A_o@AsPH@Ay@A@AO;d@Aݗ+@A$tS@A-V@A&@ArG@ArGE9@AbM@A4m9@AU2a|@A'RT@ATɅ@AC@A0
)@A:S@AN;5@ArGE8@Ax@A@A@AY}@A	 @A䎊@AZc@Axl"h
@Ap:@Aᰊ@A@A ѷ@A䎊q@AC,@AD@A'/@As@A33333@A6z@A9@AP{@Aqu!@A:)z@A|@An.@AJ@Am8@A#@A@Au@AVl!@AS&@AjOv@Asg@Ap
=@Ap
=@Azxl"h@Aw1@Azxl"h@Aw1@Aw1@AM:@AcA @AOv_@ABZc @Al!-@A2X@A+@AC-@AFs@A@A,@A1@A4֡a@AKƧ@A_o@Aeں@A$tS@A@ArG@A+j@A}H@A4m9@AXy=@AbM@AeO@AbM@AeO@Ay=c@Ae+@A+@A7KƧ@AA [@Ahr @A~($@A(@AD@Aᰉ'@A#9@A&IR@A6C@AGE85@AW'@A^5?|@AqiC@Ap:@A\(@Avȴ@Ag	@A,<@AfB@A'/@AC,z@AC,z@AC,z@APH@A"`B@A&@A6z@AW>6z@AMj@AMj@Am]@AC]@AL_@AI^5?@AzG@Azxl"@A#x@AZ@A֡a@A>B[@A@A>@A[@A+a@A?|h@AL_@A`A7L@Aw1@A=K@A8Y@A@A_o @A.2@AiB@Aqi@AQ@A'@A2X@A&I@Am\@A҈p;@A쿱[W@A4֡a@AKƧ@AKƧ@A_o@Ay@A&@A	k@A[W>@A/V@A˒:)@A@A@A@ArG@A䎊r@A 	ԕ+@A $xG@A *0@A 73@A 73@A A7K@A H@A NU@A U2a|@A U2a|@A l"h	@A |@A ˒:*@A y=c@A |@A |@A @A -
@A @A u%F@A d8@A 9Xb@A 
(@A F@A!4J@A!JE@A!Q@A!TɅo@A!^@A!hr @A!rGE8@A!~($@A!@A!@A!u@A!|@A!>BZ@A"1'@A"0U2a|@A"JL@A"kP|@A"u%F
@A"@4@A"ݘ@A"p:@A"ᰊ@A"S&@A"L/{@A"L/{@A"@A"<64@A"W@A"ڹY@A"c	@A"C,@A"fB@A"䎊q@A"c	@A"m@A#I^@A#'/@A#	@A#/V@A#F]c@A#S@A#W>6z@A#Z@A#jf@A#g	l@A#n.3@A#@A#$@A#A@A#*0U2@A#@A#a@O@A#ݗ+k@A#\N@A$xF@A$@A$@A$"h	ԕ@A$2W@A$2W@A$Fs@A$q@A$#@A$S@A$zxl"@A$1&@A$@A$Ʌoi@A$u"@A%o i@A%'0@A%*0@A%84֡@A%O;dZ@A%S&@A%Y|@A%ce@A%fA@A%fA@A%ce@A%w1@A%O
@A%Xy=@A%1@A%1@A%@A%@A%@A%S@A%E@A& ѷY@A&@A&?@A&L/{J@A&YJ@A&fffff@A&s@A&}Vl@A&qi@A&$t@A&@A&af@A&A@A&҈p;@A&҈p;@A&쿱[W@A')^@A'v@A'\(@A'O;d@A'[W>@A'حV@A'-@A'+j@A'rGE9@A'#@A(F]d@A(F]d@A(	ԕ+@A(
qu@A(bM@A(@A($xG@A(:~ @A(K]c@A(_F@A(r Ĝ@A(n@A(tj@A(@A({@A(4m@A()@A(ěT@A(TɅ@A(@@A(ѷX@A(D@A(D@A(e+@A) ѷ@A)+@A)#w@A)0
)@A)-w1@A):S@A)Dg8~@A)[W>6@A)e+a@A)k~(@A)|Q@A)oiD@A)@A)o@A)X@A)y@A)N;6@A)e@A)-@A).H@A*1'@A*=p
@A*M@A*Zc@A*xl"h
@A*S&@A*S&@A*͞&@A+I^@A+nP@A+PH@A+&@A+C%@A+@N@A+J#9@A+S@A+S@A+W>6z@A+a@N@A+a@N@A+]cA@A+dZ@A+tj~@A+S@A+q@A+S@A+@A+ݗ+k@A+A [@A+$@A+C]@A+$@A,n.@A,ߤ@@A,xF@A,1&y@A,L_@A,%1@A,2W@A,64@A,9XbN@A,Z1@A,o h@A,N;@A,_@A,3@A,TɆ@A,zxl"@A,1&@A,@A,#x@A,#x@A,[W?@A,Z@A,E@A-(@A-+a@A-84֡@A-Vl!@A-Vl!@A-ce@A-m\@A-sg@A-w1@A-M:@A-O
@A-1@A-@A-@A-Ϫ͞@A-?@A.
(@A.+jg@A..2@A..2@A.BZc @A._ح@A.fffff@A.l!-@A.l!-@A.iB@A.fffff@A.s@A.O;@A.}Vl@A.'@A.@A.ȴ9X@A.]cf@A.x@A.@A.Fs@A."@A/@A/)^@A/+I@A/;dZ@A/KƧ@A/O
M@A/\(@A/b}V@A/sPH@A/{J#:@A/4m@A/4m@A/{J#:@A/	k@A/3@A/o @A/fA@A/@@A/@@A/-@A0     @A06@A0 ě@A0 ě@A0}H@A0*0@A0:~ @A0D*@A0U2a|@A0u!@A0tj@A0U@A0
(@A0ěT@A0ěT@A0)^@A0҈p@A04֡b@A0$tT@A1@A1@A1-w1@A14J@A1e+a@A1o@A1u@A1(@A1'R@A1y@A1o@A1ԕ*@A1ᰉ'@A1e@A1e@A1Y}@A2n@A21'@A2-V@A26C@A2@4n@A2=p
@A2C\@A2C\@A2GE85@A2C\@A2@4n@A2@4n@A2@4n@A2C\@A2M@A2^5?|@A2h	ԕ@A2d7@A2d7@A2kP|@A2nO@A2{m@A2@4@A2ᰊ@A2S&@A2vȴ@A2W@A2ڹY@A2fB@A2m@A2D@A2m\@A3҉@A3C,z@A3/V@A3J#9@A3~$@A3q@A3A@A3q@A3~($@A3a@O@A3ݗ+k@A3$@A3s@A41&y@A4xF@A4L_@A4@A4"h	ԕ@A4PH@A4`d@A4`d@A4`d@A4g8}@A4g8}@A4j~#@A4m8@A4q@A4zG@A4wkP@A4zG@A4o h@A4#@A4C@A4_@A4@A4#x@A4?@A4Ʌoi@A4/@A4@A4JM@A4@A4Z@A4Z@A4JM@A4hr@A4hr@A5o i@A5V@A5V@A5u@A5*0@A5Q@A5Q@A5!.H@A5!.H@A5!.H@A5(@A5(@A5+a@A584֡@A5O;dZ@A5m\@A5m\@A5}H@A5$/@A5ݗ@A5+j@A5=K@A5v@A5H˒@A5@A5b@A5S@A6 ѷY@A6@A6u@A6Ov_@A6$/@A68YJ@A6BZc @A6Vu@A6iB@A6z@A6+J@A6qi@A6Fs@A6af@A6@A6t@A6]cf@A6쿱[W@A6"@A7 hۋ@A7
=p@A7@A7$tS@A7!-w1@A7.H@A7'/W@A74֡a@A7As@A7KƧ@A7O
M@A7H˒:@A7RT`e@A7U=@A7\(@A7b}V@A7b}V@A7lC@A7O;d@A7$tS@A7-V@A7kP@A7	k@A7	k@A7[W>@A7+@A7rG@A7rG@A7rG@A7䎊r@A7rGE9@A8F]d@A8}H@A8*0@A8U2a|@A8l"h	@A8oiDg8@A8˒:*@A8'RT@A8tj@A8-
@A8{@A84m@A8)^@A8F@A8F@A8`A7@A84֡b@A8	k@A9 ѷ@A9+@A9_p@A9#w@A9 [7@A9 [7@A9&x@A94J@A9:S@A9:S@A9Gz@A9[W>6@A9hr @A9u!S@A9@A9o@A9@A9R<6@A9R<6@A9@A9u@A9'RTa@A9n.@A9'RTa@A9'R@A9^5?}@A9ԕ*@A9Y}@A:u%F@A:@A:1'@A:6C@A:T`d@A:nO@A:ᰊ@A:vȴ@A:Y@A:W@A: ѷ@A:ڹY@A: ѷ@A:fB@A:C,@A:fB@A:fB@A:D@A:D@A:~@A;҉@A;u%@A;u%@A;I^@A;u%@A;'/@A;	@A;=K^@A;P{@A;dZ@A;dZ@A;dZ@A;jf@A;xF]@A;{J#9@A;Q@A;eO@A;ߤ@A;*0U2@A;q@A;*0U2@A;a@O@A;Ƨ@A;|@A;Q@A;%2@A;C]@A;@A;@A<J@A<tj@A<!-w2@A<%1@A<64@A<<쿱@A<Fs@A<PH@A<SMj@A<SMj@A<]ce@A<q@A<wkP@A<wkP@A<wkP@A<o h@A<#@A<N;@A<TɆ@A<Ʌoi@A<>B[@A<u"@A<D@A<!-w@A=:@A=V@A=Q@A=!.H@A=+a@A=+a@A=5Xy>@A=5Xy>@A=84֡@A=5Xy>@A=5Xy>@A=B@A=O;dZ@A=ce@A=w1@A=zxl"h@A=zxl"h@A=$/@A=}H@A=$/@A=}H@A=}H@A=!R@A==K@A=%@A=Xy=@A=U=@A=-V@A=H˒@A=b@A=?@A=S@A=,=@A=C\@A>
L/@A>u@A>($x@A>.2@A>1.@A>1.@A>8YJ@A>BZc @A>BZc @A>H@A>E@A>Ov_خ@A>R<6@A>c	@A>l!-@A>vȴ9X@A>vȴ9X@A>}Vl@A>%@A>qi@A>@A>@A>@A>,<@A>af@A>af@A>T@A>af@A>T@A>-@A>2X@A>2X@A>2X@A>2X@A>'@A>&I@A>A@A>x@A? hۋ@A? hۋ@A?Ft@A?)^@A?v@A?!-w1@A?+I@A?>6z@A?As@A?E84@A?eں@A?o@A?sPH@A?v_ح@A?y@A?4m@A?4m@A?{J#:@A?&@A?$tS@A?-V@A?	k@A?3@A?r@A?/V@A?/V@A?vȴ9@A?@@A@
qu@A@bM@A@@A@'RT`@A@>BZc@A@H@A@Xy=@A@Xy=@A@Xy=@A@_F@A@_F@A@l"h	@A@|@A@YJ@A@'RT@A@'RT@A@'RT@A@tj@A@@A@)@A@ěT@A@@@A@)^@A@@@A@F@A@D@A@	k@AA	k~@AA	k~@AA$/@AA	k~@AA+@AA*0U2a@AA*0U2a@AA4J@AA0
)@AA4J@AA=b@AA=b@AAA [@AAGz@AA^@AAk~(@AAhr @AAo hی@AAu!S@AAb}@AAb}@AA|Q@AAb}@AA@AA@AAoiD@AA~($@AA~($@AAoiD@AAR<6@AA@AA'RTa@AAn.@AAn.@AA'R@AA'R@AA^5?}@AAy@AA@AA_o@AAN;6@AA@AA"`@AA"`@AA"`@AA"`@AA"`@AAe@AAR@AA>BZ@AAR@AAs@AAY}@AAs@AA.H@ABu%F@ABn@ABn@ABn@ABn@AB	 @AB	 @AB@ABOv`@AB&IR@AB0U2a|@AB6C@AB:)y@AB=p
@ABC\@ABC\@ABM@ABQ_@ABW'@ABQ_@ABQ_@ABW'@ABZc@ABZc@ABZc@ABZc@AB^5?|@AB^5?|@ABa|Q@ABh	ԕ@ABkP|@ABqiC@AB{m@AB@4@ABᰊ@ABwkQ@ABᰊ@ABwkQ@AB>B@AB@ABn@AB@AB)_@ABW@ABW@ABsP@ABڹY@AB ѷ@AB ѷ@ABC,@ABD@ABD@ABD@ABm\@ABm\@AC҉@ACC,z@AC,zxl@AC)^	@AC/V@AC/V@AC6z@ACMjO@AC]cA@ACjf@AC~$@ACQ@ACQ@ACQ@ACq@AC:)z@ACwk@ACZ@ACƧ@ACƧ@AC@AC5Xy@AC҈@ACC]@ACg@ACg@ACA [@AC$@AC@ACs@ACs@AD@AD!-w2@AD!-w2@AD!-w2@AD!-w2@AD!-w2@AD%1@AD<쿱@ADI^5?@ADM:@ADPH@ADM:@ADVϪ@ADcA \@ADg8}@ADm8@ADm8@ADj~#@ADtSM@AD?@ADN;@AD*1@AD3@AD3@ADj~@ADɅoi@AD@AD@AD*0@AD*0@ADZ@ADZ@AD֡a@ADZ@ADZ@AD>B[@AD֡a@AD֡a@AD֡a@AD>B[@AD֡a@AD>B[@AD/@AD/@AD/@AD/@ADZ@AD@AD!-w@ADe@AEK]@AE[@AE*0@AEQ@AE!.H@AE2a|@AEIQ@AEVl!@AEY|@AEVl!@AE`A7L@AEfA@AEm\@AEp
=@AEp
=@AEsg@AEsg@AE$/@AEڹZ@AE+j@AE@AE1@AE-V@AEH˒@AE@AE@AEb@AE?@AE?@AES@AEᰉ@AE(@AE!.@AF ѷY@AF_o @AFt@AF_o @AF_o @AF
(@AF
(@AFzG@AFOv_@AF!R<@AF($x@AF($x@AF+jg@AF1.@AF8YJ@AF;5X@AF?@AFE@AFE@AFVu@AFiB@AFl!-@AFiB@AFp:~@AFs@AFz@AFIQ@AFqi@AF$t@AF,<@AF-@AF6z@AFQ@AFߤ?@AFߤ?@AFߤ?@AFm\@AFm\@AFȴ9X@AFt@AF҈p;@AF҈p;@AFϪ͟@AF҈p;@AF+@AFߤ?@AFߤ?@AF쿱[W@AF쿱[W@AF쿱[W@AF@AF@AFMj@AF"@AF!.I@AG
=p@AG
M;@AG)^@AGv@AG1@AG;dZ@AG;dZ@AGAs@AG>6z@AG>6z@AGE84@AG\(@AG_o@AG_o@AGeں@AGeں@AG_o@AG_o@AG_o@AG_o@AGlC@AGy@AG|hs@AG|hs@AG|hs@AG|hs@AG|hs@AG4m@AG	@AG&@AG&@AG	@AGݗ+@AGkP@AG-V@AGkP@AG	k@AG&@AG&@AG[W>@AGr@AGr@AG/V@AGr@AGvȴ9@AG@AG@AGحV@AG;dZ@AG@AG-@AG䎊r@AG#@AG#@AH
qu@AH*0U@AH6@AH@AH}H@AH'RT`@AH*0@AH-
q@AH-
q@AH73@AH:~ @AH>BZc@AH>BZc@AHA7K@AHH@AHK]c@AHK]c@AHNU@AHXy=@AH[6@AH_F@AHbM@AHbM@AHr Ĝ@AHu!@AHu!@AHu!@AHy=c@AHr Ĝ@AHy=c@AH|@AH˒:*@AH|@AHn@AH'RT@AH@AH-
@AH4m@AHěT@AH@@AHѷX@AHD@AH҈p@AH`A7@AHe+@AHe+@AH@AHe+@AH`A7@AH`A7@AHe+@AHe+@AHe+@AH`A7@AH@AHC@AH`A7@AH`A7@AHC@AHC@AHC@AHC@AH{@AH4֡b@AH4֡b@AH{@AH\)@AH	k@AH	k@AI ѷ@AI	k~@AI@AI@N@AI [7@AI7KƧ@AI4J@AIDg8~@AIJE@AIN;5@AIXbM@AI[W>6@AIhr @AIo hی@AIrGE8@AIrGE8@AIrGE8@AIu!S@AIoiD@AI~($@AIR<6@AIR<6@AIu@AI(@AI(@AIl@AIl@AIB@AIB@AI'R@AIX@AIX@AI@AIN;6@AIN;6@AI_o@AIN;6@AIԕ*@AI@AI@AI@AI@AI@AIe@AI>BZ@AIe@AI>BZ@AIe@AI>BZ@AIR@AI>BZ@AIR@AI@AIs@AI-@AJu%F@AJI^5@AJI^5@AJI^5@AJI^5@AJOv`@AJ1'@AJ#9@AJ0U2a|@AJ3@AJ0U2a|@AJ0U2a|@AJ6C@AJ:)y@AJ:)y@AJ6C@AJ=p
@AJQ_@AJT`d@AJT`d@AJQ_@AJQ_@AJT`d@AJ^5?|@AJd7@AJh	ԕ@AJxl"h
@AJ~"@AJ@4@AJ{m@AJݘ@AJ\(@AJ\(@AJS&@AJ0
@AJS&@AJ@AJ@AJg	@AJg	@AJg	@AJ}Vm@AJ}Vm@AJY@AJ<64@AJ@AJ)_@AJW@AJ`A@AJ ѷ@AJfB@AJfB@AJc	@AJm@AJ~@AKS&@AKu%@AK҉@AK҉@AK҉@AKs@AKC,z@AK"`B@AK"`B@AK"`B@AK"`B@AK)^	@AK)^	@AK)^	@AK)^	@AK,zxl@AK)^	@AK,zxl@AK,zxl@AK)^	@AK,zxl@AK/V@AK33333@AK9@AK6z@AK9@AK@N                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @r     @rfffff@r33333@r     @r@r     @r@rfffff@r@r@r@r@r@r@r@rfffff@r@r@r@r@r@r     @rfffff@r@rfffff@rfffff@r@r     @rfffff@r     @r@r@rfffff@rfffff@rfffff@rfffff@r33333@s1@sVfffff@snfffff@sq@sl@sl@snfffff@sl@sh     @sh     @sd@sT@s<@s,@s+33333@s!@s@s33333@rfffff@r@r33333@r@r@rfffff@rٙ@r33333@r     @rᙙ@rfffff@r     @rfffff@rљ@rfffff@r33333@r33333@r     @r33333@r     @r33333@rљ@rfffff@r     @rfffff@rfffff@r@r     @rfffff@r@rfffff@r33333@r     @r     @r     @r33333@r@rffffff@rffffff@r33333@rfffff@r33333@r     @rfffff@rx     @rffffff@r`     @rT@rL@r>fffff@r@qfffff@q@qfffff@q33333@q33333@q33333@qffffff@q;33333@q@pfffff@p33333@p@px     @pP     @p0     @p     @o陙@o     @oi@o0     @offfff@n@n6fffff@mə@m33333@mfffff@lfffff@lY@l9@lfffff@kٙ@kp     @j@j     @j@j33333@j9@i@hٙ@hfffff@h@h     @hp     @hL@h9@h)@h33333@hfffff@gfffff@g@g陙@g33333@g     @g@g     @g@gL@g0     @g33333@ffffff@f33333@f@f     @f     @fi@fp     @fi@fffffff@f\@f<@f33333@e@e陙@efffff@e     @eə@e@e     @efffff@e@e@efffff@e|@e|@el@ei@e`     @e`     @eS33333@eFfffff@e333333@e&fffff@e@d@d陙@d     @dfffff@d@d@d     @d@d@dfffff@dvfffff@dp     @di@dp     @dffffff@dVfffff@dL@dI@dC33333@d333333@d@d@dfffff@c@cfffff@cfffff@c33333@c     @c     @c\@cL@c<@c&fffff@c     @c@bfffff@bٙ@b     @b33333@bfffff@b     @bfffff@bfffff@b|@bp     @bffffff@b\@bL@b333333@b)@b#33333@b#33333@b33333@b	@b33333@b33333@a@a陙@a@ai@aY@aL@aC33333@a6fffff@afffff@`33333@`fffff@`fffff@`33333@`33333@`33333@`33333@`     @`vfffff@`i@`Y@`P     @`L@`C33333@`333333@`      @_     @_@_@_fffff@_@_y@_`     @_,@^33333@^`     @^Y@^l@^Y@^Ffffff@^,@^@^      @]     @]@]@]@]     @]y@]S33333@\@\@\y@\,@[@[@[s33333@[S33333@[L@[L@[Y@[Ffffff@[,@Z@Z@Z@Z     @ZL@Z,@Y@Yfffff@YY@Y,@Y@Yfffff@Xfffff@X33333@Xffffff@X&fffff@X33333@X      @W     @Wffffff@W@     @W@W      @V@Vl@Vy@Vy@Vs33333@Vs33333@VY@V@U     @U@U     @U@Uffffff@U@     @U333333@U,@U      @Ufffff@Tfffff@Tfffff@T33333@Tfffff@Tfffff@S@S@S33333@S@S@S     @Sfffff@S     @S     @SY@S@     @S333333@S&fffff@S@R33333@R33333@R33333@R@R33333@R@R@R@Rs33333@Rs33333@R`     @R333333@Q@Q     @Q     @Qy@Q     @Q33333@Q     @Q@Q@Q@Q33333@Qfffff@Qy@QS33333@Q@     @Q,@Q@Q@Q      @P@Pٙ@Pfffff@P@P33333@P@Pfffff@P@P     @Pl@Pffffff@PY@P&fffff@O33333@O33333@Offfff@O@Os33333@O@     @N@N     @N333333@M33333@M     @M@Ms33333@Mffffff@ML@M@L@L     @LL@L333333@L@Kfffff@Kfffff@K@J@J33333@J@J33333@K333333@K@J33333@J@Js33333@Jffffff@JY@JY@JL@J@J      @I33333@Ifffff@I@I     @Is33333@Iffffff@I@     @I@Hfffff@H     @H     @Hfffff@H@H@HL@Gfffff@Gfffff@G@G     @Gs33333@GY@G@F33333@F33333@F@E@Es33333@Effffff@Effffff@EY@E@     @E&fffff@E@E@D33333@D     @D@Ds33333@DL@D@C33333@Cs33333@C@     @C&fffff@C&fffff@C@C      @B@B     @B     @B@BY@A33333@A33333@A@As33333@AL@A333333@A&fffff@@33333@@@@&fffff@@      @@      @?fffff@?33333@?     @?@?      @?      @>fffff@>fffff@>@>33333@>@>     @>L@>333333@>@=33333@=ffffff@=L@=333333@=@<@<33333@<@<@<     @<ffffff@<L@<L@<333333@<@;fffff@<      @<      @;fffff@;fffff@;@;@;@;@;     @;@;@;     @;     @;ffffff@;ffffff@;     @;L@;      @:@:ffffff@:@9@9@933333@9ffffff@9ffffff@9333333@9      @8fffff@8fffff@8fffff@8@8ffffff@8L@8L@8@7fffff@7@7fffff@7@733333@7@7@7@7ffffff@7L@7333333@7333333@7      @7      @6fffff@6@6     @6L@5@5@5ffffff@5ffffff@5ffffff@5ffffff@5ffffff@5ffffff@5ffffff@5ffffff@5ffffff@5L@5ffffff@5L@5333333@5      @5      @433333@4ffffff@4ffffff@4     @4L@4L@4@4      @3fffff@3fffff@3fffff@3@333333@3@3@3@3ffffff@3ffffff@3L@3ffffff@3L@3L@3L@3333333@2fffff@2@2@2@2@2     @2ffffff@2L@2@2L@2ffffff@2333333@2@2@2      @1fffff@2      @1fffff@1fffff@1fffff@1@133333@133333@133333@133333@1@133333@1@133333@133333@1@1     @1@1@1L@1333333@1@1      @0fffff@0fffff@0fffff@0fffff@0@0@0@0@0@0@0@0     @0ffffff@0L@0L@0L@0333333@0      @0@/@0      @/@/@/@/@/ffffff@/@/333333@/333333@/333333@/333333@/      @/      @/      @.@/      @.@.@.@.@.@.@.@.@.@.ffffff@.@.@.ffffff@.@.@.333333@.ffffff@.333333@.ffffff@.ffffff@.333333@.ffffff@.333333@.333333@.333333@.333333@.333333@.      @.      @-@-@-@-@-@-@-@-ffffff@-@-ffffff@-@-@-ffffff@-333333@-333333@-333333@-      @-      @-      @,@,@-333333@,@,@-      @,@,@,@,@,@,@,@,@,ffffff@,@,@,@,@,@,@,ffffff@,@,333333@,ffffff@,ffffff@,333333@,333333@,333333@,333333@,333333@,      @,333333@,      @,      @,      @,      @,      @,      @,      @+@+@+@+@+333333@+@+@+@+ffffff@+ffffff@+333333@+ffffff@+ffffff@+333333@+333333@+333333@+333333@+333333@+333333@+333333@+      @+333333@+      @+      @+      @*@+      @*@*@*@*@*@*@*@*@*@*@*@*ffffff@*@*@*@*ffffff@*ffffff@*ffffff@*@*@*ffffff@*      @*333333@*      @*      @*      @*      @)@*      @)@)@*      @)@)@)@)@)@)@)@)@)@)ffffff@)@)@)ffffff@)@)ffffff@)ffffff@)ffffff@)333333@)ffffff@)333333@)ffffff@)333333@)333333@)      @)      @)      @(@(@(@(@(@)      @(@(@(@(@(@(@(ffffff@(ffffff@(ffffff@(@(      @(333333@(      @(      @'@'@'ffffff@'ffffff@'ffffff@'333333@'333333@'      @'ffffff@'      @'333333@'333333@'ffffff@&@'333333@'333333@'333333@'333333@'333333@'      @'      @'      @'      @'      @&@&@&@'      @'      @&@&@'      @&@&@'      @&@'      @&ffffff@&@&@&@&@&@&@&@&@&@&@&@&@&@&@&ffffff@&ffffff@&@&ffffff@&ffffff@&@&333333@&@&ffffff@&@&ffffff@&ffffff@&ffffff@&@&ffffff@&ffffff@&ffffff@&@&333333@&ffffff@&ffffff@&333333@&333333@&333333@&ffffff@&@&333333@&ffffff@&333333@&ffffff@&ffffff@&@&ffffff@&ffffff@&333333@&ffffff@&ffffff@&333333@&ffffff@&ffffff@&ffffff@&333333@&ffffff@&@&333333@&ffffff@&333333@&ffffff@&ffffff@&ffffff@&ffffff@&ffffff@&@&@&ffffff@&@&@&@&@&@&@&@&@&ffffff@&@&@&@&@&@&@&@&@'      @&@&@&@&@&@&@&@&@&@&@&@&@&@&@'      @'      @&@&@&@'333333@&@'      @&@'      @'333333@'      @'333333@'333333@'333333@'      @'      @'333333@'      @'333333@'      @'ffffff@'      @'333333@'333333@'      @'333333@'333333@'ffffff@'333333@'333333@'ffffff@'333333@'333333@'ffffff@'ffffff@'333333@'333333@'ffffff@'ffffff@'@'@'@'@'@'@'@'@'@'@'@'@(      @'@'@(      @'@(333333@(333333@(333333@(333333@(333333@(      @(333333@(333333@(ffffff@(333333@(      @(333333@(@(333333@(ffffff@(ffffff@(ffffff@(ffffff@(@(@(ffffff@(@(@(@(@(@(ffffff@(@(ffffff@(@(@(@(@(@)      @(@(@)      @(@(@(@)      @(@)      @(@(@)      @)333333@)      @)333333@)333333@)333333@)ffffff@)ffffff@)ffffff@)ffffff@)ffffff@)@)@)@)@)@)@)@*      @*333333@)@*      @*      @*      @*333333@*      @*@*ffffff@*333333@*333333@*@*@*ffffff@*@*@*@*@+      @*@*@*@*@*@+333333@+ffffff@+      @+      @+333333@+ffffff@+333333@+333333@+333333@+333333@+ffffff@+ffffff@+333333@+ffffff@+@+@+ffffff@+@,      @+@,      @+@,ffffff@,@,ffffff@,@,@,ffffff@,333333@,@-      @,@-333333@-333333@-      @-333333@-333333@-333333@-333333@-ffffff@-333333@-ffffff@-333333@-@-333333@-@-@-@-@.      @.      @.      @.333333@.      @.      @.      @.      @.333333@.333333@.ffffff@.@.@.@.@/333333@/333333@/333333@/@/@/@0@0@0      @0@0      @0333333@0333333@0L@0L@0333333@0333333@0L@0     @0333333@0L@0L@0L@0ffffff@0@0@0@0fffff@033333@0@0@0@0fffff@0@0fffff@1      @1      @1      @1      @1333333@1L@1333333@1L@1     @1     @1ffffff@1ffffff@1ffffff@1     @1@1@1     @1@133333@133333@1@133333@2      @1fffff@1fffff@2@2      @2      @2      @2@2333333@2ffffff@2     @2     @2@2@233333@233333@2@233333@3      @2fffff@2fffff@2fffff@3@3      @3      @3@3333333@3L@3ffffff@3L@3L@3L@3ffffff@3L@3ffffff@3L@3     @3     @333333@3@3@3@3fffff@3fffff@4      @4      @4@4333333@4L@4ffffff@4ffffff@4     @4     @4     @4     @4@4@4@4@4@433333@4fffff@5@5      @5      @5333333@5@5333333@5333333@5333333@5333333@5@5333333@5333333@5L@5333333@5L@5L@5L@5333333@5ffffff@5ffffff@5ffffff@5     @5@5fffff@533333@533333@5fffff@6      @6      @6333333@6333333@6L@6ffffff@6L@6     @6     @6@633333@6@6@6fffff@6fffff@6fffff@6fffff@7      @7333333@7      @7333333@7333333@7333333@7L@7     @7@7fffff@7fffff@8      @8333333@8333333@8333333@8ffffff@8L@8ffffff@8     @8     @833333@833333@8@833333@8fffff@8fffff@9@9333333@9333333@9L@9ffffff@9L@9ffffff@9@933333@9@933333@933333@9@:      @:      @:@:@:L@:333333@:333333@:333333@:333333@:@:     @:     @:33333@:33333@:33333@:@:@:@:33333@:fffff@:fffff@:@:fffff@:@:fffff@;      @;      @;      @;@;333333@;      @;L@;333333@;L@;     @;     @;ffffff@;ffffff@;     @;     @;     @;@;@;@;33333@;33333@;@;33333@;@;@<      @;fffff@;fffff@<      @<      @<      @<      @;fffff@<      @<@<333333@<333333@<L@<     @<ffffff@<     @<     @<     @<@<33333@<33333@<@<@<33333@<@<33333@<@<33333@<@<@<@<fffff@<@<fffff@=@=333333@=L@=333333@=L@=ffffff@=33333@=@=@=fffff@=33333@=@=fffff@=fffff@=@>      @=fffff@>333333@>@>L@>L@>L@>     @>@>@>33333@>33333@>@>@?      @?L@?     @?     @?     @?@?@?@?@@      @@@@@@@@&fffff@@@     @@L@@Y@@L@@ffffff@@Y@@Y@@ffffff@@     @@s33333@@@@@@@@@@33333@@@@fffff@@@@     @@fffff@@fffff@@ٙ@@33333@A      @A      @A      @@33333@A      @A&fffff@A&fffff@A333333@A@     @A@     @Affffff@As33333@A@A@A@A@A@A@A@A@A@A@A@Afffff@A@Afffff@Afffff@A@A33333@A@Afffff@A33333@A@A     @A@A33333@Aٙ@Afffff@A33333@B@B      @B@B&fffff@B333333@BL@B@     @B@     @BY@Bffffff@Bffffff@B     @BY@B     @B@B@B@B33333@B33333@B     @B@Bٙ@B33333@C      @C      @C      @C@C@C@C333333@C@     @C333333@C333333@C@     @CL@CL@CL@CY@CY@Cs33333@Cffffff@Cffffff@C@C@C     @C@C@Cfffff@Cfffff@Cfffff@C@Cٙ@C@Cٙ@Cfffff@Cfffff@D      @D@D@D&fffff@D333333@D333333@DY@DL@Dffffff@Dffffff@Ds33333@Ds33333@Dffffff@Ds33333@D@D     @D@D     @D@D@D33333@D33333@D33333@D33333@D33333@Dfffff@D33333@D@D@D     @Dٙ@D@E@E      @E@E&fffff@E&fffff@E&fffff@E&fffff@E333333@E@     @EY@EY@EY@EY@EL@EY@Effffff@Effffff@EY@Effffff@E@E@Efffff@E@Efffff@E@E@E@E@E@Efffff@E33333@E33333@E     @E@E@Eٙ@Efffff@Eٙ@Efffff@Eٙ@E33333@Efffff@Efffff@E33333@F@F&fffff@F333333@F333333@F@     @FL@Fffffff@FL@Fffffff@F     @F@F@F@Ffffff@F33333@F33333@F33333@F33333@Ffffff@F33333@F     @F     @F@Fٙ@Ffffff@Ffffff@Ffffff@F33333@G@G      @Ffffff@F33333@G&fffff@G&fffff@G@G&fffff@G333333@G333333@G333333@G&fffff@G333333@G@     @G333333@G@     @Gffffff@G     @G33333@Gfffff@G33333@Gfffff@Gٙ@G@Gٙ@Gfffff@Gٙ@Gٙ@Gٙ@G@Gfffff@G33333@Gٙ@G33333@Gٙ@H      @Gfffff@Gٙ@H      @H      @H      @H      @H@H      @H      @H      @H@H      @H@H&fffff@H333333@H@     @H333333@HY@Hffffff@H     @H@Hfffff@Hfffff@H33333@H     @H33333@Hٙ@Hٙ@Hٙ@Hfffff@I      @I      @I@I&fffff@I&fffff@I333333@IY@IL@IL@IL@I@     @Iffffff@IY@IY@Iffffff@I     @I@I     @I@Ifffff@I@Ifffff@Ifffff@Ifffff@Ifffff@I33333@Ifffff@I     @I33333@I@I     @I@I@I@I@Iٙ@Ifffff@Ifffff@I33333@J      @J@J@J      @J@J&fffff@J333333@JL@JL@J333333@J&fffff@JY@JY@JY@JY@JY@J     @J@J     @J     @J@J@Jfffff@Jfffff@J33333@Jٙ@Jfffff@J@Jٙ@J33333@K      @K      @K      @K      @K@K@K@     @K333333@K333333@K333333@K@     @KY@K@     @KY@KY@Kffffff@K     @K     @K@Kfffff@Kfffff@K33333@K@K@K@L      @Kfffff@Kٙ@L@L&fffff@L      @L&fffff@L333333@L333333@L&fffff@L333333@L&fffff@L333333@L333333@L333333@L@     @L@     @L333333@L@     @LL@LL@L@     @LY@LL@LY@LY@LY                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ?;dZ?QR?7KƧ?ӕ$/?(\)?/w?Ԭ1&y?աo?Ցhr ?֗O;d?$/?ם-V? ěT?M?۶E?/w?E?x?Q?`A7K?\(?S?lD?=p
=?1&x?j~#?S?l?Z1'?E?lC?I^5?}?E??|hs?|hr?E?hr!?XbM?C$?7KƧ?C$?lC?
=p@ Ƨ-@zG@dZ1@$/@XbM@A7Kƨ@bM@+@7KƧ@1&x@E@lC@$/@$/@\(\@ȴ9Xb@E@9XbM@ lC?xF?\(?dZ1?Q?hr Ĝ?GzH?~"?\(?9XbN?QR?x?o?$/?zG{?nO?I^5?}?$/?I^5?1&x?hr!?9XbM?ffffff?tj~?vȴ? ěT?nP?xF?5?|h?O;dZ?I^5?}?C$?"`B?$/?`A7L? ěT?-V?bM?      ?n?hr Ĝ?ڟvȴ9?M?x?O;dZ?E??|hs?hr!?lC?n?1&?7KƧ?ҏ\(?lC?щ7KƧ?Ͼvȴ9X?Vt?bM?O;dZ?I^5?}?n?͑hr ?Ͼvȴ9X?O;dZ?͑hr ?C$?/v?p
=q?=p
=?ǍO;dZ?x?xF?+?+?+I^?ȴ9Xb?Ƈ+I?zG{?S?ffffff?tj?šo?tj?tj?-V?S?hr Ĝ?GzH?-V?-V?7KƧ?&x?`A7L?n?$/?`A7L?I^5??`A7L? ěT?I^5??|hr?j~"?ěS?A7Kƨ?A7Kƨ?bM? ěT?;dZ?;dZ?vȴ9X?hr Ĝ?bM?A7Kƨ?-V?A7Kƨ?$/?      ?hr!?vȴ9X?(\)?GzH?|hr?5?|h?I^5??nP?`A7L?
=p?-V?GzH?bM?
=p?;dZ?E?`A7L?ěS?lD?M?Q?$/?hr!?`A7L?ěS?$/?hr!?|hr?A7Kƨ?hr!?A7Kƨ?hr Ĝ?-V?A7Kƨ? ěT?GzH?ěS?      ?j~"?`A7L?&x?
=p?7KƧ?"`?hr Ĝ?A7Kƨ?vȴ9X?bM?Q?
=p?hr!?p
=q?|hr?`A7?lD?|hr?A7Kƨ?M?nP?I^5??&x?hr Ĝ?&x?$/?`A7L?I^5??ěS?&x?nP?vȴ9X?      ?lD?\(?&x?hr Ĝ?7KƧ?|hr?hr Ĝ?$/?ěS?      ?vȴ9X?GzH?|hr?Q? ěT?-V?;dZ?&x?Q?bM?bM?hr Ĝ?
=p?A7Kƨ?      ?A7Kƨ?A7Kƨ?&x?n?      ?"`?S?vȴ9X?;dZ?`A7L?$/? ěT?A7Kƨ?I^5??7KƧ?n?GzH?GzH?`A7?333333?lD?
=p?-V?nO;?$/?lD?I^5??hr Ĝ?I^5??hr Ĝ?I^5??&x?&x?`A7L?lD?
=p?n?ěS?lD?A7Kƨ?$/?° ě?vȴ9X?A7Kƨ?GzH?hr Ĝ?bM?n?M?hr Ĝ?nP?7KƧ?p
=q?
=p?GzH?M?7KƧ?p
=q?ěS?lD?`A7L?GzH?-V?7KƧ?nO;?M?n?$/?-V?nO;?n?`A7L?vȴ9X?-V?Q?nO?nO;?`A7L?I^5??lD?"`?`A7?l?vȴ9X?;dZ?lD?n?$/?n?\(?nO;?Q?M?l?-V?l?-V?Q?333333?n?l?lD?n?&x?nO?`A7L?nO;?M?+?Q?l?nO;?M?M?GzH?M?M?`A7?Q?Õ$/?I^5??hr Ĝ?|hr?l?bM?M?7KƧ?`A7L?nO;?Z1'?\(?ěS?`A7?\(?$/?`A7L?nO;?nP?nO;?
=p?7KƧ?`A7?nO;?nO;?GzH?`A7?nO;?hr Ĝ?tj~?Q?hr Ĝ?`A7?$/?I^5??
=p?I^5??&x?nO;?GzH?I^5??`A7?nO;?vȴ9X?
=p?
=p?öE?-V?333333?hr Ĝ?7KƧ?M?ěS?nO;?nO?n?Q?E?
=p?nO?-V?7KƧ?Q?nO?tj~?7KƧ?hr Ĝ?lD?Q?hr Ĝ?° ě?M?`A7L?\(?\(?7KƧ?-V?+?\(?333333?I^5??S?M?nP?333333?lD?tj~?333333?l?öE?`A7L?`A7?° ě?I^5??tj?lD?&x?`A7?`A7?Q?-V?S?$/?\(?° ě?GzH?n?hr Ĝ?° ě?tj~?nP?$/?`A7?nO?tj~?hr Ĝ?n?`A7L?`A7L?lD?M?E?-V?n?\(?`A7?Q?`A7?lD?7KƧ?Q?hr Ĝ?/w?
=p?° ě?Q?hr Ĝ?I^5??Õ$/?Q?`A7L?`A7?M?I^5??tj?l?lD?GzH?333333?tj~?Õ$/?l?
=p?I^5??lD?
=p?nO?`A7?nO;?l?bM?+?tj~?I^5??M?nO?l?-V?9XbM?-V?hr Ĝ?\(?nP?S?l?nO?`A7?tj?-V?`A7?&x?nP?`A7?nO?nO?S?nO;?
=p?nO?° ě?
=p?M?9XbM?lD?l?
=p?tj~?S?° ě?nO;?+?lD?l?nO?tj?333333?nO;?° ě?bM?`A7?lD?nO?l?7KƧ?7KƧ?`A7?`A7?$/?S??|hs?GzH?GzH?/w?tj~?9XbM?hr Ĝ?S?Z1'?`A7?I^5??ěS?+?° ě?S?öE?Z1'?öE?M?tj~?`A7?tj?
=p?/w?tj~?GzH?I^5??öE?M?nO;?
=p?S?&x?Q?tj?S?7KƧ?I^5??7KƧ?
=p?nO?
=p?Q?nO;?S?zG{?šo?`A7?ěS?\(?\(?Z1'?\(?lD?7KƧ?-V?Q?nO?Õ$/?öE?nO?öE?S?333333?n?$/?333333?\(?öE?`A7L?öE?tj~?tj?tj?333333?+?l?+?ěS?öE?tj?öE?S?333333?Ł$/?tj~?nO?333333?`A7K?I^5??S?zG{?333333?Q?hr Ĝ?lD?E?tj~?
=p?`A7?M?Õ$/?M?lD?$/?\(?\(?° ě?/w?l?nO?
=p?öE?° ě?-V?\(?\(?-V?Z1'?tj?n?° ě?l?\(?\(?tj~?n?öE?öE?-V?l?9XbM?Q?+?nO?9XbM?zG{?9XbM?nO;?tj?`A7?ļj~#?Õ$/?l?n?hr Ĝ?`A7?-V?\(??|hs?Q?Õ$/?öE?° ě?hr Ĝ?GzH?ļj~#?Õ$/?nO?E?ļj~#?öE?333333?+?M?-V?
=p?° ě?+?
=p?lD?Z1'?
=p?`A7L?-V?9XbM?/w?+?öE?S?S?l?tj?n?Q?nO;?tj~?\(?333333?`A7?7KƧ?333333?`A7?333333?S?`A7?9XbM?\(?tj?° ě?\(?° ě?333333?
=p?zG{?Õ$/?l?ļj~#?n?+?/w?-V?
=p?+?+?-V?nO;?333333?333333?S?l?° ě?öE?+?nO?`A7?tj~?\(?M?ěS?lD?`A7?Z1'?-V?l?&x?nO?333333?`A7K?9XbM?° ě?GzH?S?-V?nO;?M?l?l?tj~?tj?l?nO?ļj~#?\(?Õ$/?S?\(?
=p?-V?l?öE?ěS?hr Ĝ?`A7?\(?9XbM?tj~?zG{?Õ$/?° ě?tj~?7KƧ?$/?nO;?S?E?Q?
=p?/w?zG{?
=p?
=p?nO?tj~?tj~?+?° ě?öE?
=p?\(?9XbM?S?öE?+?-V?Õ$/??|hs?S?öE?S?l?333333?nO;?tj?l?nO?° ě?\(?zG{?ěS?n?tj~?Õ$/?öE?tj?7KƧ?l?° ě?hr Ĝ?S?`A7?Q?Õ$/?l?+?tj~?$/?S?+?nO?Ł$/?ěS?I^5??n?nO;?ļj~#?° ě?333333?tj?tj?
=p?l?n?\(?tj~?l?ļj~#?+??|hs?-V?tj~?E?M?333333?tj?
=p?333333?ěS?$/?nO?nO;?Õ$/?tj~?ěS?° ě?nO?nO?nO?
=p?ěS?I^5??öE?Õ$/?° ě?bM?nO?+?tj~?nO?`A7?`A7?M?Õ$/?+?l?Q?`A7?\(?`A7?l?öE?333333?+?nO?$/?`A7?l?S?tj~?° ě?`A7?S?Õ$/?nO;?
=p?zG{?n?l?nO?Q?9XbM?
=p?zG{?° ě?`A7?333333?ļj~#?lD?ļj~#?nO?tj~?nO?7KƧ?öE?M?Õ$/?tj~?nO?ļj~#?ěS?`A7?° ě?9XbM?I^5??9XbM?I^5??
=p?öE?9XbM?`A7?&x?hr Ĝ?ěS?nO?tj?l?ěS?nO;?Q?+?+?ļj~#?\(?/w?S?-V?Õ$/?`A7?Q?n?nO?l?öE?+?+?Õ$/?Q?`A7?333333?
=p?M?l?Z1'?ěS?9XbM?Õ$/?° ě?lD?nO?E?ěS?\(?nO;?
=p?GzH?n?tj~?öE?333333?7KƧ?`A7?tj~?° ě?l?° ě?tj?tj?ěS?nO?ļj~#?tj~?tj~?S?öE?Z1'?tj?° ě?nO;?Õ$/?tj~?tj?öE?S?l?lD?öE?nO?&x?ļj~#?nO;?9XbM?S?I^5??S?S?S?Õ$/?`A7?`A7?l?`A7?333333?Q?\(?tj?I^5??
=p?9XbM?Q?M?nO;?l?ļj~#?ěS?`A7?l?+?l?\(?/w?öE?333333?S?hr Ĝ?l?lD?GzH?nO;?333333?nO?nO;?zG{?Õ$/?nO;?S?333333?nO;?\(?ěS?zG{?7KƧ?`A7?+?Z1'?Z1'?`A7?tj~?lD?`A7K?I^5??Õ$/?lD?nO?hr Ĝ?7KƧ?n?S?öE?nO?öE?GzH?tj?M?hr Ĝ?lD?7KƧ?-V?7KƧ?öE?M?Õ$/?M?
=p?hr Ĝ?Õ$/?I^5??nO?-V?I^5??GzH?\(?zG{?ļj~#?nO?öE?+?-V?° ě?Q?tj~?-V?lD?ěS?lD?M?M?-V? ěT?M?S?l?° ě?nO?9XbM?tj~?ļj~#?333333?l?Q?S?nO?tj~?-V?      ?\(?`A7?333333?`A7?Q?&x?S?I^5??nO;?S?S?Õ$/?S?
=p?ěS?9XbM?\(?`A7L?nO;?`A7??|hs?nO?n?7KƧ?Õ$/?nO?Õ$/?Q?nO;?lD?-V?GzH?° ě?+?nO;?&x?M?+?° ě?`A7?\(?nO?&x?I^5??I^5??n?M?hr Ĝ?ěS?&x?/w?7KƧ?zG{?l?\(?tj?M?nO;?lD?&x?`A7?9XbM?M?nO?333333?tj~?nO?Z1'?nP?
=p?tj~?`A7?öE?° ě?tj?tj~?\(?Q?Õ$/?nO;?GzH?\(?S?-V?° ě?n?ěS?ěS?`A7?7KƧ?° ě?S?\(?-V?9XbM?9XbM?\(?I^5??
=p?tj~?nO?tj~?$/?`A7K?tj?
=p?lD?bM?A7Kƨ?n?-V?-V?n?° ě?tj?n?      ?GzH?l?l?+?hr Ĝ?° ě?nP?S?Õ$/?`A7?GzH?333333?l?&x?n?\(?hr Ĝ?öE?+?M?nO;?GzH?333333?333333?nO?hr Ĝ?l?Q?-V?nO;?9XbM?S?S?hr Ĝ?-V?-V?nO?M?nO;?&x? ěT?-V?hr Ĝ?Õ$/?
=p?`A7?l?Õ$/?l?l?M?-V?M?M?n?I^5??tj~?tj~?Õ$/?öE?hr Ĝ?lD?ěS?      ?Q?bM?n?° ě?-V?Q?° ě?-V?° ě?nO;?-V?° ě?hr Ĝ?7KƧ?\(?9XbM?`A7?\(?n?nO?zG{?tj~?-V?° ě? ěT?nO;?\(?Õ$/?zG{?S?\(?n?M?S?I^5??l?tj~?$/?M?S?Q?\(?I^5??n?l?° ě?-V?+?Q?hr Ĝ?ěS?M?\(?&x?ěS?-V?      ?7KƧ?&x?Q?-V?l?A7Kƨ?Q?hr Ĝ?Q?I^5??S?Q?GzH?GzH?$/?I^5??tj~?7KƧ?l?öE?nO;?I^5??nO;?\(?° ě?n?&x?nO;?° ě?`A7?-V?M?° ě?l?7KƧ?Q?nO;?Q?-V?7KƧ?-V?-V?bM?n?GzH?`A7?Q?S?M?lD?nP?M?l?7KƧ?nO?n?7KƧ?7KƧ?nO?Õ$/?I^5??$/?bM?nO;?I^5??|hr?`A7?lD?`A7?Q?ěS?öE?hr Ĝ?nP?\(?M?l?-V?GzH?Q?nO;?l?`A7L?nO?l?M?&x?hr Ĝ?nO;?GzH?GzH?
=p?nO?lD?-V?° ě?bM?&x?tj~?`A7?\(?&x?-V?Õ$/?7KƧ?Õ$/?S?ļj~#?&x?M?vȴ9X?vȴ9X?n?bM?&x?&x?-V?nO?l?
=p?n?-V?° ě?Õ$/?&x?ěS?M?\(?nO?vȴ9X?`A7L?M?&x?ěS?7KƧ?`A7L?I^5??n?hr Ĝ?GzH?Q?nO?-V?&x?&x?333333?Q?A7Kƨ?A7Kƨ?S?`A7L?hr Ĝ?lD?nO?`A7L?nO;?
=p?n?      ?&x?nO;?n?|hr?lD?Q?|hr?      ?hr Ĝ?ěS?nP?M?|hr?`A7L?\(?nO?S?S?Q?tj~?&x?`A7L?n?n?`A7L?hr Ĝ?-V?7KƧ?nO;?M?M?A7Kƨ?I^5??333333? ěT?hr Ĝ? ěT?5?|h?° ě?öE?-V?$/?
=p?n?\(?nO?lD?`A7L?ěS?-V?`A7?A7Kƨ?I^5??nO;?tj?`A7K?lD?n?GzH?"`?$/?7KƧ? ěT?lD?-V?Q?bM?-V?-V?
=p?nO;?&x?|hr?n?M?Q?GzH?"`?lD?333333?
=p?7KƧ?nO;?M?/w?$/?ěS?A7Kƨ?      ?M?vȴ9X?hr Ĝ?GzH?
=p?nO;?`A7L?GzH?lD?333333?nO?lD?`A7L?7KƧ?nP?$/?n?lD?A7Kƨ?&x?I^5??-V?n?S?I^5??ěS?n?I^5??M?l?\(?GzH?      ?nP?n?Q?nO;?&x?
=p?ěS?-V?° ě?+?/w?S?° ě?nO?M?nP?ěS?-V?GzH?lD?A7Kƨ?öE?\(?nP?&x?hr Ĝ?`A7L?-V?"`?vȴ9X?tj~?bM?$/?lD?nP?|hr?A7Kƨ?° ě?M?Q?nO?-V?Q?S?M?° ě?hr Ĝ?GzH?I^5??Q?° ě?7KƧ?nP?Õ$/?$/?bM?n?nO;?$/?&x??|hs?nP?n?&x?A7Kƨ?nO;?ěS?;dZ?
=p?&x?lD?bM?/v?GzH?hr Ĝ?hr Ĝ?° ě?hr Ĝ?|hr?nP?$/?M?7KƧ?nO;?&x?\(?° ě?|hr?7KƧ?      ?ěS?;dZ?ěS? ěT?&x?M? ěT?nO?\(?`A7L?&x?Q?Q?|hr?bM?|hr?
=p?nO;?`A7L?nP?l?-V?`A7?`A7L?`A7?-V?GzH?&x?nO;?
=p?&x?9XbM?7KƧ?hr Ĝ?&x?7KƧ?hr Ĝ?7KƧ?nP?-V?333333?nP?hr Ĝ?Q?° ě?$/?A7Kƨ?Q?`A7L?lD?-V?nO?$/? ěT?hr Ĝ?333333?-V?° ě? ěT?&x?&x?GzH?ěS?Q?hr Ĝ?&x?Q?-V?bM?lD?hr Ĝ?GzH?"`?ěS?|hr?$/?° ě?hr Ĝ?
=p?`A7L?bM?5?|h?bM?GzH?"`?GzH?tj?lD?GzH?S?ěS?-V?nP?7KƧ?|hr?lD?n?-V?lD?l?hr Ĝ?`A7L?-V?$/?nO?`A7L?`A7L?n?      ?
=p?hr Ĝ?$/?`A7L?GzH?GzH?l?n?-V? ěT?Q?333333? ěT?vȴ9X?"`?`A7L?° ě? ěT?`A7L?
=p?7KƧ?`A7L?lD?ěS?|hr?A7Kƨ?1&y?Q?A7Kƨ?n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	@Nffffff@Nffffff@Nffffff@NY@NY@NL@NL@NL@N@     @N@     @NL@NL@N@     @NL@N@     @N@     @NL@NL@N@     @N@     @N@N&fffff@N@     @NL@NL@NL@N@     @N333333@N@     @N@     @N&fffff@N@     @N333333@N333333@N333333@N@Mٙ@MY@M333333@M@Lfffff@L@L@L33333@L33333@L@Lffffff@Ls33333@Ls33333@L     @Lfffff@Lٙ@L@Mffffff@M     @M33333@M33333@M33333@N@     @N     @N33333@N@Nٙ@Nfffff@O      @O@O333333@O@     @O@     @OL@Os33333@O@Offfff@Offfff@O@Oٙ@Oٙ@Oٙ@Oٙ@O33333@P      @Pfffff@P@P33333@P      @P&fffff@P&fffff@P,@P333333@P9@P@     @PFfffff@PFfffff@PS33333@PS33333@PS33333@PS33333@PY@PS33333@PS33333@PY@P`     @P`     @P`     @P`     @Pffffff@Pffffff@Pffffff@Pl@Pl@Pl@Pl@Pl@Pl@Pl@Ps33333@Py@Py@P     @Py@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@P33333@P33333@P@P     @P@P@P@P@P     @P     @P@P     @P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@P@P@Pfffff@P@P@Pfffff@P@P@Pfffff@P@P@P@P@P@P@P33333@P     @P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@Pfffff@P@P@P33333@P@Pfffff@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@Pfffff@P@P@P@P@P@P33333@P@P@P     @P     @P     @P     @P@P@P@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P33333@P     @P     @P     @P     @P     @Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P33333@P33333@P33333@P@P33333@P@P@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@Pٙ@Pٙ@Pٙ@P33333@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @P     @P     @P     @P     @P     @P     @Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@P     @P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P     @P@P@P@P@P@P@P@P@P@P     @P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P     @P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@Pfffff@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P     @Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P33333@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@Pfffff@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P33333@P@P33333@P33333@P@P33333@P33333@P@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@Pfffff@P@P@P@P@P@P33333@P33333@P@P@P@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@Pfffff@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P@P@P@P33333@P33333@P@P@P@P@P@P@P33333@P33333@P@P@P33333@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P33333@P@P@P33333@P@P@P@P@P33333@P@P@P33333@P@P33333@P@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P@P@P@P@P@P@P@P@P@P33333@P33333@P@P@P@P33333@P@P33333@P33333@P33333@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P@P@P@P@P33333@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P     @P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@O     @P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    P13                                     1                                       BD-t3G