CDF       
      time      pressure  T   latitude      	longitude         string_dimension   (         EXPOCODE      29AJ20160818   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    WOCE_ID       TAlPro     	DATA_TYPE         WOCE CTD   STATION_NUMBER        37     CAST_NUMBER       1      BOTTOM_DEPTH_METERS          
Creation_Time         2020-03-19T19:50:21.946062Z    ORIGINAL_HEADER      CTD,20200319CCHSIO
# Converted CTDOXY from ML/L to UMOL/KG using the following:
#     https://github.com/TEOS-10/GSW-Python, downloaded 2019-06-26
#     gsw.sigma0:  Calculates potential density anomaly with reference pressure of 0
#     dbar, this being this particular potential density minus 1000 kg/m^3.
#     This function has inputs of Absolute Salinity and Conservative
#     Temperature.  This function uses the computationally-efficient
#     75-term expression for specific volume in terms of SA, CT
#     and p (Roquet et al., 2015).
#     http://www.teos-10.org/pubs/gsw/html/gsw_sigma0.html 
#     Python equation used:
#         oxy_UMOL_per_KG = oxy_ML_per_L * 44.660 / ( (1000 +  gsw.sigma0(SA,CT)) / 1000. ) 
# Data source:  https://doi.pangaea.de/10.1594/PANGAEA.902330
# SHIP: RV Angeles Alvarino
# Cruise: MedSHIP cruise TalPro
# Region: Mediterranean Sea and Catalan Basin
# Ports: Palermo, Italy to Barcelona, Spain
# DATES: 20160818 - 20160829
# Chief Scientist: L.Jullion
# 43 stations
# Original file in AWI format. CCHDO Converted to Exchange format
# EVENT_CODE=unknown
# DATE: YYYYMMDD
# TIME: HHMM
# LATITUDE: degrees_North
# LONGITUDE: degrees_East
# STNNBR:  removed leading 0s from STNNBR
# CASTNO: not supplied by originator - CCHDO assigned all CASTNO=1 or CASTNO=2 for stations 11, 29
# CTDSAL: changed units from Practical to PSS-78.  Data values remain unchanged.
# CTDFLUOR: changed units from UG/L to MG/M3 as they are they are equivalent
# CCHDO added flags=2 for all parameters, as T.Tanhua notes all params are calibrated and CTDOXY calibrated with bottle samples
# Removed two test sample depths from event/station 004, dTalpro_Stn04_test_1db
# Data precision preserved as submitted.
# CTD: Who - T.Tanhua; Status - calibrated,final
#     Includes: CTDSAL, CTDOXY
#     CTDTMP NOTE: Used first occurrence of primary temperature sensor in original data file
#     CTDSAL NOTE: Used first occurrence of primary salinity sensor in original data
#     NOTE: Physical parameters temperature, salinity, oxygen, density, turbidity, chlorophyll, fluorescence are published on PANGAEA, DOI above.
# Fluorescence (CTDFLUOR): Who - T.Tanhua; Status -final
#        Instrument: WET Labs ECO-AFL/FL, FLNTURTD-2526
#        ScaleFactor: 1.00000000e+001
#        Dark Output: 0.0760
# Turbidity (CTDTURBDTY): Who - T.Tanhua; Status - final
#        Instrument: FLNTURTD-2526
#        ScaleFactor: 5.000000
#        Dark output Voltage: 0.070000
#
# Reference: Cruise report: https://epic.awi.de/id/eprint/49725/1/TAlPro_EUROFLEETS_cruise_report_V2.pdf
# CCHDO page: https://cchdo.ucsd.edu/cruise/29AJ20160818
# Metadata from original file
#     Event(s):     TAlPro-2016_037 (37) * LATITUDE: 40.400000 * LONGITUDE: 2.490000 * DATE/TIME: 2016-08-27T02:57:00 * CAMPAIGN: TAlPro-2016 * BASIS: Angeles Alvarino (URI: http://www.eurofleets.eu/np4/285.html) * DEVICE: CTD/Rosette (CTD-RO)
#     Citation: Tanhua, Toste (2019): Physical oceanography during MedSHIP cruise Talpro. PANGAEA, https://doi.org/10.1594/PANGAEA.902330
#     Abstract: The TAlPro cruise (Palermo - Barcelona, RV Angeles AlvariÃ±o, 18/-8/2016 - 29/08/2-16) occupied three hydrographic transects across the Tyrrhenian Sea, the western Mediterranean Sea and the Catalan Basin (Fig. 1) as part of the MedSHIP programme (Mediterranean Ship-based Hydrographic Investigations Program). A total of 43 stations were occupied during which physical (temperature, salinity, pressure, velocity), biogeochemical (oxygen, nutrients, carbonate system, dissolved Barium, oxygen and nitrogen isotopes) and anthropic (CFCs, SF6) parameters were measured in order to monitor the physical and biogeochemical state of the Mediterranean Sea.
#     Related to: Jullion, Loic (2016): TAlPro-2016: A Tyrrhenian Sea & Alger- provencal component of the MedSHIP Programme. hdl:10013/epic.5a866780-1f8a-45cf-8111-47b2b5dc29db
#     Parameter(s):
#         Event label (Event) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Sample code/label (Sample label) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Date/Time of event (Date/Time) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Latitude of event (Latitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Longitude of event (Longitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Pressure, water [dbar] (Press) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Digiquartz
#         Temperature, water [Â°C] (Temp) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: ITS-90
#         Oxygen, dissolved [ml/l] (DO) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 43
#         Turbidity (Nephelometric turbidity unit) [NTU] (Turbidity) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO
#         Fluorescence, chlorophyll [Âµg/l] (Fluores) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO-AFL/FL
#         Salinity (Sal) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Practical
#     License: Creative Commons Attribution 4.0 International (CC-BY-4.0)
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            pressure               	long_name         pressure   positive      down   units         decibar    data_min      @         data_max      @d        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      :  '   pressure_QC                	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d        a   temperature                	long_name         temperature    units         ?C (ITS-90)    data_min      @*>Q   data_max      @:zG   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       :  pX   temperature_QC                 	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d           salinity               	long_name         salinity   units         PSS-78     data_min      @C e+   data_max      @CJn   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      :     salinity_QC                	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d        @   oxygen                 	long_name         oxygen     units         ?mol/kg    data_min      @e   data_max      @qOv`   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        :    	oxygen_QC                  	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d       =   CTDFLUOR               	long_name         CTDFLUOR   units         MG/M^3     data_min      6C-   data_max      ?GzH   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      : L0   CTDFLUOR_QC                	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d          	CTDTRBDTY                  	long_name         	CTDTRBDTY      units         NTU    data_min      ?   data_max      ?ə   C_format      %f     WHPO_Variable_Name        	CTDTRBDTY      OBS_QC_VARIABLE       CTDTRBDTY_QC     : x   CTDTRBDTY_QC               	long_name         CTDTRBDTY_QC_flag      units         
woce_flags     C_format      %1d          time                	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      &,1   data_max      &,1   C_format      %10d          latitude               	long_name         latitude   units         	degrees_N      data_min      @D333333   data_max      @D333333   C_format      %9.4f             	longitude                  	long_name         	longitude      units         	degrees_E      data_min      @Q   data_max      @Q   C_format      %9.4f             	woce_date                   	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3;   data_max      3;   C_format      %8d           	woce_time                   	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d           station                	long_name         STATION    units         unspecified    C_format      %s        (    cast               	long_name         CAST   units         unspecified    C_format      %s        ( @      @      @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         @:zG@:zG@:ԕ*@:a@N@:`A7@:
(@:'RT`@:vȴ9@:~+@:}cA @:|PH@:v'@:t!-w2@:p҈p@:m(@:k'/@:hQ@:j^5?|@:WO;d@:LcA \@:3nP@:@9Vϫ@9`'RT`@8JW'@6!.I@5@5Eo i@5
C\@4:~ @41&x@4z^5?|@4KI^@4d8@3
L/@3x9Xb@3[W>6@2dg8}@1tj~@1np:~@17lC@1!R<6@0jOv@0Ϫ͟@0eݗ@0@/|]ce@/mV@/n.@.E@.4Z@-C\@-n/@-fYJ@-X*0@-@-
@-#w@-sP@-҉@-_p@,ߤ?@,@,ҕᰊ@,XbM@,B@,lC@,^5?}@,ov_ح@,VϪ͟@,	'RTa@,zH@,p:~@+U@+6z@+/V@+	 @+@+kP|@+1@+g	l@+}Vl@+Fs@+
(@+	k~@+Q@+"`B@+l!-@+e+@+!.H@+U@+@+@+|u"@+t*1@+$/@+͞&@+S&@+L_@+~($x@+u@+|ߤ@@+vaf@+kjf@+ao hی@+Y#w@+C%2@+3*0U2@+-jOv@+(TɅ@+!|Q@+u%F@+C-@+E@+PH@+s@++@+v_ح@+o @+2a|@+`d@+	 ѷ@+
͞&@+?@+S@+|Q@+      @*@*Y@*_F@*)_@+Z@+@+-@+)^	@+ hۋ@+6@+&IQ@+&@+'y@+(r Ĝ@+%F
L0@+&fffff@+$?@+')^@+#eO@+y=c@+u!S@+m@+`d@+>6z@+e+@+>B@+$@+n.@+%@+vȴ9@+U=@+=K@+U=@+?@+ NU@*q@*+@*_p@*
(@*Vϫ@*v@*t@*As@* ě@*U2a|@*@*[W>6@*hr @*`A7@*$tT@*`A7@*{@*`A7@*{@*{@*`A7@*_p@*$tT@*D@*-V@*"h	ԕ@*n@*]cA@*/{J#@*xF]@*k~(@*思IQ@*o i@*e@*o i@*o i@*Z1@*?@*E84@*@*@*`A@*唯O
@*zG@*O;d@*@*l"h	@*+@*0
)@*>BZ@*>B@*u%@*n.@*hr@*K]@*p
=@*b@*u@*@*Ft@*;dZ@*|hs@*H˒@*dZ@*8YJ@*~($x@*TɅ@*`A@*IQ@*n.@*ⶮ}Vm@*o i@*e@*,zxl@*Gz@*H˒:@*ߤ?@*.H@*߱[W>@*IQ@*@*Q@*Z@*C,@*⩓@*@*C,@*{J#9@*@*S@*7@*
L/@*Q@*n@*x@*@*jf@*jf@*I^@*C,z@*fB@*ڹY@*D@*]cA@*"h	ԕ@*L/{@*0U2a|@*g	@*zG@*v_ح@*𖻘@*D@*𖻘@*4֡a@*\(@*v@*v_ح@*-V@**0U@*'RT@*{@*𖻘@*As@*@*첕@*I^5?@*s@*U=@*g	@*g	@*C,z@*P{@*jf@*\@*C\@*v@*m\@*҉@*T`d@**0U@*iDg8@* hۋ@*2X@*t@*\(@*u@*s@*ᰊ@*?|h@*&@*C,zx@*%@*.H@*حV@+o hی@+s@+nP@+Z@+%2@+JM@+zxl"h@+S&@+zxl"h@+8YK@+lC@+	ԕ+@+	ԕ+@+K]d@+E84@+fffff@+@+1@+F
L0@+/@+S@+
=p@+}Vm@+M@+.H@+I^5@+3@+nP@+n.3@+9@+n.3@+$@+wk@+Z@+
=p@+A [@+Z@+%1@+*0@+Q@+1@+1@+`A7L@+m\@+@+1.@+Fs@+'@+s@+RT`e@+	ԕ+@+	ԕ+@+@@+oiDg@+ ѷ@+7Kƨ@+o hی@+Gz@+ ҈p@+ 6@*˒:)@*@*5?|@*E@*vȴ9X@*ߤ?@*b}V@*[W>@*@*䎊r@*˒:)@*?@*	@*쿱[W@*6z@*p
=@*6@*)_@*C\@*+@*@@*+@*-
@*$/@*Fs@*ݗ+k@*-
q@*!R<@*>B[@*>B[@*O;dZ@*5Xy>@*1&y@*g	@*@*ۋq
@*7KƧ@*r Ĝ@*eO@*r Ĝ@*@*TɅ@*ۋq
@*@*TɅ@*rGE@*Q@*oiD@*oiD@*Dg8~@*\)@*p:@*\)@*TɅ@*>BZc@*-@*y@*,@*捸@*
L/@*`A7L@*o h@*㢜wk@*⩓@*M@*Gz@*b}V@*Ov_خ@*ݿH˒@*݊ڹZ@*ܹ#x@*n.@*ۘA@*/V@*ٳ|@*״3@*
=p@*֮}Vl@*z@*E@*E@*_ح@*և+J@*և+J@*z@*֔Fs@*ȴ9X@*C-@*l!-@*ըXy=@*2a|@*ԕ*1@*g@*Ұ ě@*R@*т@*&x@*4J@*_p@*@*iDg8@*'/W@*ξߤ?@*C\@*"h	ԕ@*"h	ԕ@*VϪ@*fB@*ɓ@*rGE@**0U2a@*r Ĝ@*š@*ÈeO@*o@*4m@*b}V@*Ft@*ߤ?@*쿱[W@*vȴ9X@*ڹZ@*ߤ@@*/V@*^5?|@*@*rGE8@*	k~@*tj@*kP@*sPH@*af@**0@*9XbN@*@*a@O@*g	l@*m@*-V@*{@*U2a|@*-
q@* ě@*@*T@*p:~@*H@*8Y@*"h	ԕ@*Ƨ@*q@*Q@*jf@*d7@*@*fA@*RT`e@*x@*@*1.@*oiDg@*1@*n/@*e@*tj@*%2@*\N@*A [@*Z@*n.3@*74@*.H@*|Q@*Gz@* [7@*IQ@*'RT`@*6@*$tS@*U=@*!-w1@*҈p;@*%@*\N<@*,=@*<64@*wkP@*m]@*~$@*qu!@*c	@*Y@*^5?|@*"`@*JE@*tj@*l"h	@*}H@*sPH@*af@*+jg@*Ϫ͞@*L_@*E@*֡a@*֡a@*O
M@*O
M@*j~@*zG@*a@O@*tj~@*Mj@*PH@*<64@*-@*@*N;5@*@*Vϫ@*@*iDg8@*v_ح@*v_ح@*\(@*As@*'/W@*+@*}Vl@*Vu@*(@*@*!-w@*I^5?@*s@*a@@*]cA@*)^	@*n@*#9@*	 @*Q@*@*y@*]cf@*IQ@*?@*$/@*S@*@*@*@*JM@*A [@*wk@*wk@*F]c@*}Vm@*h	ԕ@*@4n@*R<6@*ěT@*n@*4m9@*@*U=@*~҈p;@*~\N<@*~ ѷY@*}}H@*}!.H@*|1&@*|?@*|N;@*|64@*|Q@*{A@*{~$@*{q@*{S@*{5Xy@*{5Xy@*{lC@*{lC@*{m]@*{dZ@*{J#9@*zu%F@*y~($@*yrGE8@*y~($@*y~($@*y#w@*xy=c@*xbM@*w3@*w4m@*w$tS@*vz@*vOv_@*vt@*v4K@*uXy=@*u'0@*t`d@*s|@*sZ@*rS&@*r{m@*rT`d@*q2W@*qu@*qA [@*qA [@*q4J@*p
(@*p`A7@*p{@*p`A7@*p{@*p
(@*p@*pbM@*p*0U@*oiDg8@*o hۋ@*n+@*nzG@*m@*mw1@*m5Xy>@*l>B[@*l_@*l1&y@*k҈@*k҈@*ks@*ks@*k҈@*kU=@*jڹY@*j~"@*j~"@*jg	@*jL_@*jqiC@*j=p
@*j	 @*iԕ*@*i'RTa@*iQ@*iDg8~@*iDg8~@*h9Xb@*h@*hK]c@*h@*h@*h$xG@*gfA@*g/V@*gy@*gy@*gE84@*g+I@*g,@*f&I@*f-@*f?@*f@*eoiDg@*eO
@*e`A7L@*e84֡@*eo i@*de@*dTɆ@*dtSM@*d?@*cA [@*cwk@*c{J#9@*c9@*b ѷ@*bwkQ@*bu%F
@*bu%F
@*bu%F
@*b@4@*bZc@*bh	ԕ@*b3@*ao@*aTɅo@*aGz@*a@N@*a$/@*`҈p@*`	k@*`ѷX@*`IQ@*`-
@*`-
@*`[6@*`6@*`
qu@*_U=@*^m\@*^Ov_خ@*^
(@*]b@*],=@*]E@*]cA @*\Z@*\?@*\wkP@*\wkP@*\PH@*\n.@*[$@*[s@*Zݘ@*Z6C@*Zu%F@*Y"`@*Yb}@*Ye+a@*YXbM@*Y0
)@*Y=b@*YJE@*Y0
)@*Y+@*Xe+@*XU@*XYJ@*X_F@*XF]d@*W+@*W3@*WXe,@*WXe@*W
=p@*W
=p@*VϪ͟@*Vaf@*Vz@*V_ح@*V4K@*UXy=@*U!R@*U$/@*U$/@*U!R@*Usg@*UL_@*U?|h@*U'0@*TE@*TE@*T֡a@*TɅoi@*TO
M@*TɅoi@*T֡a@*T֡a@*T֡a@*Tj~@*T*1@*T`d@*T,<@*T9XbN@*TFs@*T9XbN@*T,<@*T@*TJ@*Sg@*Sa@O@*Sg	l@*S@N@*S33333@*SPH@*S33333@*S&@*Rm\@*RGE85@*R䎊@*Rs@*Rn@*QR@*QiB@*Ql@*QA [@*PD@*P{@*P{@*P{@*P@*P'RT@*P@*P'RT@*P'RT@*P'RT@*PoiDg8@*PH@*OVϫ@*O͞@*OAs@*Nߤ?@*N2X@*Nߤ?@*Nߤ?@*Nߤ?@*Nߤ?@*N2X@*Nqi@*Nqi@*Nqi@*NVu@*NVu@*Nc	@*N;5X@*N.2@*N!R<@*N_o @*MC\@*M(@*M@*M%@*M%@*MM:@*Mw1@*M5Xy>@*L!-w@*LC@*Lq@*LI^5?@*LL_@*Ka@@*Kq@*Kq@*Kq@*KP{@*K6z@*K)^	@*K'/@*JD@*J͞&@*JL_@*J~"@*JW'@*JW'@*Iᰉ'@*Iy@*I@*I@*IoiD@*IoiD@*Ix@*Ik~(@*Ik~(@*I*0U2a@*Hۋq
@*H˒:*@*H˒:*@*HeO@*H>BZc@*GzH@*G/V@*G	k@*GzH@*G/V@*G@@*G#@*H@*H$xG@*G	k@*G	k@*GlC@*G8}H@*G8}H@*GE84@*FFs@*Fx@*FIQ@*Ffffff@*Fs@*Fs@*F1.@*F$/@*F$/@*Eݗ@*Ezxl"h@*Eo i@*Eu@*E+a@*E+a@*EQ@*D7@*DtSM@*DZ1@*D7@*Eo i@*DtSM@*DM:@*D2W@*D%1@*CA [@*C
=p@*C
=p@*C@*CZ@*C@*C@*CeO@*Ca@N@*Ca@N@*CS@*C,zxl@*C,zxl@*CF]c@*C,zxl@*B74@*B ѷ@*B@*B}Vm@*B@*B@*B}Vm@*B}Vm@*B}Vm@*B}Vm@*B@*B}Vm@*B`A@*B@*B@4@*BM@*BI^5@*Ae@*Ae@*As@*Ae@*Ae@*Ae@*As@*Ao@*A@*AR<6@*AR<6@*An.@*A@*A@*A'R@*An.@*A@*An.@*AR<6@*AR<6@*Aae@*Aae@*ATɅo@*Aae@*A-w1@*@ěT@*@ѷX@*@ѷX@*@҈p@*@	k@*A$/@*@҈p@*@ěT@*@n@*@hۋq@*@n@*@NU@*@A7K@*@4m9@*@4m9@*@6@*?䎊r@*?˒:)@*?|hs@*?;dZ@*?;dZ@*?;dZ@*?U=@*?b}V@*?U=@*?b}V@*?b}V@*?b}V@*?b}V@*?|hs@*?$tS@*??@*?$tS@*?H˒:@*?;dZ@*?.H@*?@*?@*?.H@*?.H@*?!-w1@*?!-w1@*?!-w1@*?!-w1@*?!-w1@*?!-w1@*?.H@*?;dZ@*?U=@*?U=@*?H˒:@*?H˒:@*?U=@*?b}V@*?H˒:@*?!-w1@*>"@*>"@*>ߤ?@*>ߤ?@*>"@*?Ft@*?@*?Ft@*>"@*>쿱[W@*>҈p;@*>m\@*>m\@*>Q@*>m\@*>m\@*>҈p;@*>m\@*>m\@*>ߤ?@*>ߤ?@*>ߤ?@*>쿱[W@*>"@*?Ft@*?@*?!-w1@*?@*?Ft@*?Ft@*?Ft@*>"@*>쿱[W@*>쿱[W@*>҈p;@*>ߤ?@*>"@*?Ft@*?Ft@*>"@*?Ft@*?.H@*?;dZ@*?;dZ@*?H˒:@*?b}V@*?	@*?|hs@*?	@*?|hs@*?|hs@*?	@*?$tS@*??@*?[W>@*?vȴ9@*?˒:)@*?حV@*?حV@*?@*?حV@*?@*?@*?@*?@*@     @*@
qu@*@4m9@*@A7K@*@A7K@*@hۋq@*@-
@*@-
@*@d8@*@4m@*@ěT@*@҈p@*@	k@*A$/@*A@N@*A-w1@*A:S@*ATɅo@*Aae@*A|Q@*Ao hی@*A|Q@*A7Kƨ@*A7Kƨ@*AR<6@*A'R@*A@*A@*Ae@*As@*A.H@*Ae@*Ae@*Ao@*An.@*AR<6@*AR<6@*A'R@*A'R@*A@*Ao@*Ao@*A'R@*A@*A@*Ae@*B3@*C	@*C{J#9@*C$@*C$@*C@*C
=p@*C@*C
=p@*C%2@*C%2@*C%2@*C%2@*C\N@*Dtj@*DxF@*Dtj@*C\N@*C@*Cn.3@*Cn.3@*C{J#9@*CeO@*C$@*C$@*CZ@*Cwk@*Cwk@*Cwk@*C@*C@*C
=p@*C%2@*C
=p@*C
=p@*C%2@*C%2@*Dtj@*D2W@*D?@*DZ1@*Do h@*DS@*DTɆ@*DTɆ@*D?@*D7@*DJM@*De@*Eu@*E+a@*EF
L0@*ES&@*E`A7L@*Em\@*Eݗ@*Eݗ@*EO
@*E@*En/@*E@*ES@*ES@*Eڹ@*F@*F$/@*F?@*FYJ@*FIQ@*F@*F-@*F'@*FA@*F]cf@*FFs@*Fx@*Fx@*FFs@*FFs@*G)^@*G,@*GE84@*GRT`e@*G_o@*GlC@*Gy@*Gݗ+@*G	k@*G/V@*GK]d@*GK]d@*GfA@*G@@*GK]d@*GK]d@*GfA@*G-@*H@*H$xG@*G-@*G#@*H@*H1&x@*HK]c@*HeO@*H˒:*@*H@*H9Xb@*HTɅ@*Hۋq
@*H@*I ѷ@*IrGE@*I*0U2a@*IDg8~@*I^@*Ik~(@*Ik~(@*IoiD@*IoiD@*IoiD@*IoiD@*I@*I@*Ix@*Ix@*Ix@*I@*I'RTa@*IoiD@*I*0U2a@*I@*I*0U2a@*IDg8~@*IoiD@*I^@*I^@*Ix@*IoiD@*IB@*Iy@*I@*JOv`@*JJL@*J~"@*J0
@*J0
@*JW'@*J=p
@*JqiC@*Jn@*JڹY@*JڹY@*JfB@*KI^@*JD@*KI^@*KC,z@*K)^	@*KC,z@*K)^	@*K)^	@*K'/@*K)^	@*K6z@*K6z@*KC%@*KP{@*Kjf@*KxF]@*K:)z@*K:)z@*Kq@*KƧ@*Ks@*L"h	ԕ@*LI^5?@*LVϪ@*Lq@*L~($x@*L_@*Lzxl"@*L@*L[W?@*L@*L!-w@*L!-w@*M:@*Mqu"@*M5Xy>@*MO;dZ@*M5Xy>@*M5Xy>@*M5Xy>@*MB@*MO;dZ@*MjOv@*MM:@*Mhr!@*M%@*MU=@*M8Y@*M8Y@*M@*M
qv@*M(@*MC\@*N_o @*N!R<@*N;5X@*NH@*NVu@*Np:~@*N}Vl@*Nqi@*NT@*N2X@*Nߤ?@*NT@*NT@*NT@*NO;@*NT@*Nߤ?@*Nt@*N1@*N+@*N+@*N1@*O hۋ@*O hۋ@*Nt@*N+@*Nt@*Nt@*Nt@*N+@*N1@*O hۋ@*Ov@*OAs@*O\(@*Ov_ح@*O{J#:@*O-V@*Oo @*O;dZ@*OrGE9@*O@*O@*O-V@*O͞@*O-V@*Or@*O@*OVϫ@*P@*P ě@*P-
q@*P-
q@*OrGE9@*OVϫ@*O͞@*OiDg8@*Ov_ح@*O{J#:@*Ov_ح@*O{J#:@*O@*O͞@*O͞@*Oo @*O@*OVϫ@*OrGE9@*OrGE9@*P*0U@*P ě@*P-
q@*P:~ @*PH@*PbM@*P|@*PoiDg8@*PoiDg8@*P|@*P@*P{@*P
(@*PD@*P`A7@*P$tT@*P$tT@*P$tT@*Q@*Q&x@*Q&x@*Q&x@*Q&x@*Q4J@*QN;5@*Q[W>6@*Qu!S@*Q@*Qo@*Qu@*QX@*Q2W@*QiB@*QN;6@*QiB@*QR@*Q-@*Rn@*Rs@*R䎊@*R-V@*R:)y@*RT`d@*RT`d@*RnO@*R{m@*Rp:@*Rp:@*Rᰊ@*RS&@*R ě@*RW@*R䎊q@*SPH@*SPH@*S҉@*S&@*S33333@*S33333@*S@N@*S@N@*SMjO@*SZ@*Stj~@*SMj@*Sߤ@*Sݗ+k@*TJ@*T!-w2@*T9XbN@*T,<@*T!-w2@*T@*T!-w2@*T9XbN@*T9XbN@*T,<@*T9XbN@*T9XbN@*T9XbN@*TSMj@*T`d@*T`d@*T`d@*Tm8@*Tm8@*TzG@*T#@*T3@*T3@*Tj~@*TɅoi@*TZ@*TD@*TE@*U%F
L@*U*0@*U*0@*U?|h@*UfA@*Usg@*U!R@*U$/@*U!R@*U=K@*UXy=@*Ush@*UϪ͞@*U\(@*U?@*U\(@*Uᰉ@*U!.@*Vt@*VOv_@*V8YJ@*VR<6@*V_ح@*Vz@*Vz@*Vz@*V+J@*VFs@*V}Vl@*V@*Vȴ9X@*VϪ͟@*V@*W
=p@*WXe@*W$tS@*W1@*W>6z@*WKƧ@*Weں@*W4m@*W4m@*WO;d@*W4m@*W4m@*WO;d@*WO;d@*WkP@*WO;d@*WkP@*WkP@*W3@*W@*W+@*W+@*W+@*W@*W@*WrG@*W@*W@*W+j@*XF]d@*XbM@*X*0@*XD*@*XD*@*XQ@*X_F@*Xl"h	@*Xy=c@*Xtj@*Xtj@*X-
@*X)@*XF@*XF@*XF@*X4֡b@*Y	k~@*Y#w@*Y0
)@*Y=b@*YJE@*Ye+a@*Yb}@*Y~($@*Y@*Y(@*Y|@*YD@*Y_o@*Y"`@*Y>BZ@*YY}@*YY}@*YY}@*Zu%F@*Zu%F@*Zu%F@*Z1'@*Z)y@*Z)y@*Z6C@*ZQ_@*Z^5?|@*ZkP|@*Zݘ@*Zݘ@*Zݘ@*Zvȴ@*Z>B@*Z)_@*Z,<@*Zc	@*Z~@*[u%@*["`B@*[=K^@*[J#9@*[W>6z@*[dZ@*[~$@*[A@*[S@*[6@*[5Xy@*[lC@*\n.@*\Q@*\(\@*\C,zx@*\PH@*\j~#@*\wkP@*\N;@*\쿱[@*\1&@*\?@*\Z@*\hr@*]K]@*][@*]/w@*]<64@*]Vl!@*]ce@*]ڹZ@*]ڹZ@*]v@*]H˒@*]cA @*],=@*]E@*^
(@*^u@*^BZc @*^Ov_خ@*^iB@*^vȴ9X@*^$t@*^$t@*^Q@*^m\@*^ߤ?@*^"@*_Ft@*_@*_;dZ@*_;dZ@*_H˒:@*_b}V@*_|hs@*_	@*_?@*_[W>@*_vȴ9@*_حV@*_䎊r@*`     @*`6@*`4m9@*`A7K@*`NU@*`hۋq@*`u!@*`-
@*`d8@*`4m@*`ѷX@*`C@*`	k@*a$/@*a [7@*a-w1@*a:S@*aGz@*ao hی@*a|Q@*aR<6@*an.@*a@*a@*ae@*as@*a.H@*b&IR@*b3@*b@4n@*bZc@*bu%F
@*b\(@*b\(@*bwkQ@*b@*b}Vm@*b`A@*bC,@*b74@*cS&@*c	@*c9@*cS@*ca@N@*cn.3@*c{J#9@*c$@*c@*c@*c
=p@*c%2@*c\N@*dtj@*d%1@*d2W@*dM:@*dZ1@*dtSM@*dqj@*dS@*d?@*d7@*d/@*dJM@*de@*eu@*eQ@*e84֡@*eS&@*e`A7L@*ezxl"h@*eO
@*e@*en/@*e@*e8YK@*eڹ@*f@*f$/@*f1.@*fL/{J@*ffffff@*fs@*fIQ@*f,<@*f'@*f&I@*fA@*fx@*g@*g)^@*g,@*g8}H@*gE84@*gRT`e@*glC@*g&@*g	k@*gzH@*g/V@*gfA@*g@@*g#@*h	ԕ+@*h$xG@*h1&x@*hK]c@*hXy=@*hr Ĝ@*h˒:*@*hu%F@*h@*hTɅ@*hp:@*h@*h\)@*i*0U2a                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @C@CR@C'R@CJE@CTɅo@C^@C|Q@C@Co@C(@C@C4J@C e+@Cb}@C@CM:@C\N<@Cs@C%2@C
O
@C;5X@C)^@C|hs@C+@C\(@C}H@C@C9Xb@C
m\@C~($x@C
Y|@CQ@C
Q@Ck~(@C:)z@C%2@CJ#9@C;dZ@CF@C
=p@CϪ͞@C+@C#S@C$PH@C#nP@CL_@CTɅ@CVu@C"qiC@C!	k~@C'/W@C7@Cw1@C[@CS&@CU=@Cx@Ct@C-@C"I^5@C"c	@C#PH@C#s@C$@C$7@C$쿱[@C$%1@C#a@N@C"xl"h
@C -
@C! ѷ@C"#9@C!7KƧ@C 'RT@C+@C?@Cr@C @C 	ԕ+@C 
qu@C K]c@C U2a|@C!'R@C"nO@C"0
@C"S&@C"@4@C#jf@C$(\@C$PH@C$I^5?@C#%2@C#J#9@C#C,z@C%2a|@C&H@C'-@C(H@C(4m@C(	k@C(4֡b@C(p:@C(73@C'@C'@C&Mj@C&?@C%?@C%ݗ@C%%F
L@C$e@C%[@C%<64@C%L_@C%zxl"h@C%fA@C%!R@C%@C&+J@C&vȴ9X@C%ڹ@C&?@C&Ov_@C&t@C&zG@C&@C&s@C&Vu@C&l!-@C&@C'eں@C'{J#:@C'3@C'-@C(Xy=@C)B@C*wkQ@C*>B@C*74@C+J#9@C+W>6z@C+q@C+m]@C,Q@C,M:@C+|@C+q@C+A [@C,M:@C,7@C-o i@C-L_@C-hr!@C-sh@C.
L/@C.L/{J@C.z@C.Vu@C.4K@C-?@C-ݗ@C-Vl!@C-(@C-(@C-L_@C-`A7L@C-hr!@C--V@C.
L/@C.Fs@C.2X@C/
M;@C/KƧ@C/	@C/@C04m9@C0d8@C0	k@C1N;5@C1(@C1"`@C2Ov`@C2M@C2@C2G{@C3	@C3=K^@C39@C3n.3@C35Xy@C3Q@C3
=p@C35Xy@C3%2@C4J@C41&y@C4"h	ԕ@C4PH@C4hr@C5`A7L@C5+j@C5@C6;5X@C6ߤ?@C8u%F@C8ۋq
@C8`A7@C8\)@C9 ѷ@C9 ѷ@C9+@C94J@C9Q@C9^5?}@C:h	ԕ@C:vȴ@C:sP@C:m\@C;nP@C;S@C;eO@C;wk@C;ݗ+k@C;lC@C;|@C;{J#9@C;PH@C;I^@C:)_@C:n@C:sP@C:c	@C;/V@C;@N@C;33333@C;PH@C;PH@C;6z@C;@C;U=@C;@C<`d@C<3@C<j~@C<u"@C=o i@C=Q@C=m\@C=n/@C=\(@C>+jg@C>fffff@C>@C>!.I@C?+I@C?'/W@C?o@C?K]d@C?#@C@bM@C@*0@C@K]c@C@[6@C@˒:*@C@{@C@e+@C@e+@C@PH@CA+@CAoiD@CAN;6@CBI^5@CB:)y@CBh	ԕ@CBu%F
@CBݘ@CBᰊ@CB͞&@CBm\@CCC,z@CCF]c@CCjf@CC:)z@CCMj@CC:)z@CC$@CC$@CCA@CCA@CCA@CCm]@CC5Xy@CCݗ+k@CC@CD64@CDI^5?@CDm8@CD@CDZ@CD!-w@CDe@CD>@CDe@CDe@CDe@CEo i@CE5Xy>@CE?|h@CEIQ@CEڹZ@CEϪ͞@CFL/{J@CF}Vl@CFqi@CF@CF+@CF1@CG@CGv@CG+I@CGeں@CG|hs@CG{J#:@CGkP@CG/V@CG䎊r@CH     @CH@CH	ԕ+@CH
qu@CH*0U@CH}H@CH*0@CH-
q@CH4m9@CH73@CH73@CH4m9@CH73@CH4m9@CH>BZc@CHNU@CHeO@CHy=c@CH˒:*@CH@CH-
@CHtj@CH@CH
=q@CH9Xb@CH
(@CHC@CI$/@CI@CI&x@CI0
)@CI-w1@CIA [@CITɅo@CIe+a@CI7Kƨ@CI@CI@CI|@CI2W@CIo@CI_o@CIB@CI~($@CI|Q@CI@CIb}@CI@CIx@CI|Q@CIo hی@CIo hی@CI@CI@CI'RTa@CI'R@CID@CI_o@CIN;6@CI@CIᰉ'@CIR@CIs@CIY}@CJu%F@CI.H@CIlD@CI-@CIR@CJu%F@CJn@CJu%F@CIԕ*@CIy@CI@CI@CIb}@CIhr @CIk~(@CIu!S@CIk~(@CI[W>6@CIJE@CI=b@CI7KƧ@CI=b@CIA [@CIA [@CIA [@CIA [@CIDg8~@CIN;5@CIQ@CITɅo@CIe+a@CIhr @CIk~(@CIo hی@CIo hی@CIrGE8@CIu!S@CIrGE8@CIrGE8@CIrGE8@CIrGE8@CIk~(@CIhr @CIe+a@CI^@CI[W>6@CIQ@CIGz@CIA [@CI7KƧ@CI-w1@CI [7@CI@N@CI@CI	k~@CI ѷ@CHPH@CH	k@CH	k@CH@CHD@CHp:@CH)^@CH@@CH@@CHěT@CHěT@CHTɅ@CHTɅ@CHTɅ@CHěT@CHěT@CH@@CH)^@CH@@CHTɅ@CH)@CH9Xb@CH@CH-
@CHIQ@CHu%F@CH@CH@CH'RT@CHn@CHYJ@CH|@CHoiDg8@CHXy=@CHXy=@CHXy=@CH>BZc@CH1&x@CH*0@CH'RT`@CH@CG䎊r@CGfA@CG@CGzH@CG	k@CG$tS@CGݗ+@CG@CGO;d@CGy@CGeں@CGXe,@CGRT`e@CGH˒:@CGE84@CG;dZ@CG4֡a@CG'/W@CG!-w1@CGv@CGFt@CF"@CF"@CF@CFx@CF1@CF]cf@CFȴ9X@CFȴ9X@CFm\@CF&I@CFQ@CF}Vl@CF}Vl@CFT@CFaf@CFqi@CF+J@CF%@CF%@CFz@CFp:~@CF_ح@CFL/{J@CFH@CFBZc @CF8YJ@CF5?|@CF.2@CF+jg@CF$/@CFOv_@CFzG@CF4K@CF
(@CF
L/@CF_o @CFt@CEC\@CEoiDg@CE,=@CE,=@CE
qv@CE?@CE8YK@CE@CEϪ͞@CE@CE8Y@CEH˒@CEn/@CE@CE-V@CEXy=@CE%@CEO
@CEhr!@CEhr!@CEݗ@CEݗ@CE$/@CEzxl"h@CEp
=@CEjOv@CEfA@CE`A7L@CEVl!@CEO;dZ@CEF
L0@CEB@CE84֡@CE5Xy>@CE2a|@CE2a|@CE+a@CE+a@CE+a@CE(@CE!.H@CEQ@CEqu"@CEu@CEV@CEK]@CE:@CD>@CDe@CDZ@CD/@CDu"@CDu"@CD/@CD>B[@CD֡a@CDZ@CD*0@CDɅoi@CD?@CD[W?@CD[W?@CD@CD1&@CDzxl"@CD쿱[@CDS@CD_@CDN;@CDC@CD#@CD~($x@CDwkP@CDcA \@CDZ1@CDPH@CDI^5?@CDM:@CDFs@CD?@CDC,zx@CD?@CD2W@CD,<@CD%1@CD"h	ԕ@CD!-w2@CDL_@CDߤ@@CDxF@CDJ@CC$@CCC]@CCC]@CC%2@CCݗ+k@CCa@@CC@CCƧ@CCa@O@CC~($@CCm]@CC@CCm]@CCq@CC*0U2@CCU=@CCU=@CCߤ@CCߤ@CCߤ@CCߤ@CCߤ@CCߤ@CCA@CCMj@CC:)z@CC~$@CCxF]@CCxF]@CCxF]@CCtj~@CCn.3@CCdZ@CC]cA@CCW>6z@CCW>6z@CCJ#9@CCC%@CCC%@CC=K^@CC=K^@CC33333@CC,zxl@CC"`B@CCPH@CCs@CCS&@CCS&@CBm\@CB~@CBD@CBm@CBc	@CBC,@CB䎊q@CBfB@CBG{@CBG{@CB ѷ@CB ѷ@CBsP@CBsP@CB`A@CB)_@CBn@CBY@CBg	@CB>B@CBL/{@CBvȴ@CBwkQ@CB0
@CB\(@CBL_@CBp:@CBp:@CBp:@CBݘ@CB@4@CBxl"h
@CBqiC@CBnO@CBnO@CBkP|@CBkP|@CBh	ԕ@CBd7@CB^5?|@CBZc@CBT`d@CBW'@CBQ_@CBJL@CBGE85@CBGE85@CB=p
@CB=p
@CB:)y@CB6C@CB0U2a|@CB-V@CB-V@CB)y@CB&IR@CB&IR@CB䎊@CB1'@CBOv`@CBs@CB@CB	 @CB	 @CBn@CBu%F@CA-@CA-@CAs@CAs@CAR@CA>BZ@CAᰉ'@CAiB@CA"`@CAN;6@CAN;6@CA_o@CA_o@CAy@CAo@CA2W@CA2W@CA@CAX@CAX@CA|@CA|@CAB@CAB@CAl@CA(@CA'RTa@CA'RTa@CAu@CA@CAR<6@CA~($@CA@CA|Q@CArGE8@CArGE8@CAu!S@CArGE8@CAk~(@CAae@CA[W>6@CA[W>6@CAXbM@CATɅo@CAQ@CAJE@CAA [@CA7KƧ@CA4J@CA-w1@CA*0U2a@CA&x@CA#w@CA [7@CA@CA@CA_p@CA+@CA+@CA@N@CA@CA	k~@CA	k~@C@$tT@C@PH@C@	k@C@\)@C@4֡b@C@C@C@C@C@@C@`A7@C@e+@C@҈p@C@҈p@C@ѷX@C@ѷX@C@p:@C@p:@C@)^@C@)^@C@ěT@C@ěT@C@
(@C@
(@C@
(@C@)@C@4m@C@4m@C@4m@C@9Xb@C@9Xb@C@9Xb@C@{@C@d8@C@@C@
=q@C@-
@C@
=q@C@
=q@C@-
@C@IQ@C@u%F@C@IQ@C@@C@-
@C@@C@'RT@C@'RT@C@'RT@C@YJ@C@n@C@y=c@C@y=c@C@u!@C@r Ĝ@C@oiDg8@C@oiDg8@C@l"h	@C@_F@C@_F@C@[6@C@[6@C@Q@C@U2a|@C@Q@C@Q@C@NU@C@NU@C@NU@C@NU@C@D*@C@A7K@C@>BZc@C@73@C@*0@C@-
q@C@*0@C@-
q@C@*0@C@*0@C@'RT`@C@$xG@C@$xG@C@}H@C@}H@C@}H@C@6@C@@C@@C@*0U@C@*0U@C@
qu@C@
qu@C@	ԕ+@C@@C@@C@@C?#@C?#@C?+j@C?䎊r@C?-@C?Vϫ@C?@C?@@C?@C?;dZ@C?@C?حV@C?@C?@C?+@C?+@C?K]d@C?o @C?@C?vȴ9@C?vȴ9@C?r@C?3@C?zH@C?zH@C?zH@C?zH@C?&@C?&@C?&@C?-V@C?-V@C?kP@C?kP@C?ݗ+@C?@C?&@C?{J#:@C?{J#:@C?4m@C?{J#:@C?&@C?&@C?{J#:@C?{J#:@C?|hs@C?|hs@C?y@C?sPH@C?v_ح@C?lC@C?lC@C?iDg8@C?b}V@C?b}V@C?_o@C?_o@C?Xe,@C?\(@C?U=@C?O
M@C?KƧ@C?E84@C?E84@C?E84@C?As@C?As@C?;dZ@C?8}H@C?1@C?8}H@C?;dZ@C?4֡a@C?+I@C?+I@C?+I@C?'/W@C?$tS@C?!-w1@C?!-w1@C?!-w1@C?,@C?v@C?@C?Xe@C?)^@C?@C?)^@C?
M;@C?
M;@C?
M;@C?Ft@C?Ft@C?@C?@C? hۋ@C>!.I@C>!.I@C>!.I@C>"@C>"@C>"@C>Fs@C>Fs@C>Fs@C>Mj@C>@C>x@C>1@C>1@C>C-@C>C-@C>C-@C>ߤ?@C>ߤ?@C>]cf@C>+@C>+@C>Ϫ͟@C>Ϫ͟@C>҈p;@C>҈p;@C>҈p;@C>A@C>҈p;@C>t@C>t@C>ȴ9X@C>m\@C>m\@C>&I@C>&I@C>ߤ?@C>@C>Q@C>Q@C>'@C>ߤ?@C>ߤ?@C>Q@C>Q@C>'@C>'@C>2X@C>2X@C>6z@C>6z@C>6z@C>-@C>T@C>af@C>af@C>,<@C>O;@C>,<@C>,<@C>,<@C>O;@C>Fs@C>Fs@C>Fs@C>Fs@C>Fs@C>$t@C>Fs@C>$t@C>@C>qi@C>qi@C>+J@C>qi@C>+J@C>%@C>%@C>%@C>IQ@C>%@C>%@C>IQ@C>%@C>IQ@C>}Vl@C>IQ@C>IQ@C>}Vl@C>}Vl@C>z@C>z@C>vȴ9X@C>vȴ9X@C>s@C>s@C>p:~@C>s@C>s@C>s@C>s@C>p:~@C>p:~@C>l!-@C>iB@C>iB@C>fffff@C>iB@C>iB@C>iB@C>fffff@C>fffff@C>c	@C>c	@C>_ح@C>_ح@C>c	@C>c	@C>c	@C>_ح@C>_ح@C>_ح@C>\N<@C>\N<@C>YJ@C>\N<@C>YJ@C>YJ@C>Vu@C>R<6@C>Vu@C>Vu@C>R<6@C>R<6@C>Vu@C>Vu@C>YJ@C>Vu@C>YJ@C>R<6@C>YJ@C>Vu@C>Vu@C>Vu@C>R<6@C>Vu@C>Vu@C>R<6@C>R<6@C>R<6@C>R<6@C>Vu@C>Vu@C>Vu@C>Ov_خ@C>Ov_خ@C>R<6@C>R<6@C>R<6@C>R<6@C>R<6@C>R<6@C>Vu@C>R<6@C>Ov_خ@C>Vu@C>R<6@C>Vu@C>R<6@C>YJ@C>Vu@C>YJ@C>Vu@C>YJ@C>Vu@C>YJ@C>YJ@C>Vu@C>Vu@C>Vu@C>Vu@C>Vu@C>Vu@C>Vu@C>Vu@C>Vu@C>Vu@C>Vu@C>Vu@C>Vu@C>Vu@C>R<6@C>Ov_خ@C>L/{J@C>H@C>L/{J@C>L/{J@C>L/{J@C>L/{J@C>L/{J@C>H@C>L/{J@C>H@C>L/{J@C>Ov_خ@C>_ح@C>fffff@C>fffff@C>fffff@C>fffff@C>fffff@C>iB@C>iB@C>iB@C>fffff@C>fffff@C>iB@C>iB@C>fffff@C>c	@C>c	@C>_ح@C>YJ@C>Vu@C>Vu@C>Vu@C>R<6@C>Vu@C>R<6@C>Vu@C>Vu@C>YJ@C>Vu@C>R<6@C>Vu@C>R<6@C>R<6@C>Vu@C>R<6@C>Ov_خ@C>R<6@C>Vu@C>R<6@C>R<6@C>R<6@C>YJ@C>Vu@C>Vu@C>YJ@C>Vu@C>YJ@C>YJ@C>YJ@C>Vu@C>Vu@C>Vu@C>Vu@C>Vu@C>YJ@C>YJ@C>Vu@C>YJ@C>Vu@C>Vu@C>YJ@C>Vu@C>YJ@C>Vu@C>Vu@C>YJ@C>YJ@C>YJ@C>\N<@C>\N<@C>\N<@C>_ح@C>\N<@C>\N<@C>\N<@C>\N<@C>\N<@C>\N<@C>YJ@C>\N<@C>\N<@C>YJ@C>\N<@C>\N<@C>\N<@C>\N<@C>\N<@C>_ح@C>\N<@C>_ح@C>_ح@C>_ح@C>_ح@C>\N<@C>YJ@C>\N<@C>YJ@C>\N<@C>\N<@C>\N<@C>YJ@C>YJ@C>YJ@C>\N<@C>\N<@C>\N<@C>_ح@C>_ح@C>\N<@C>_ح@C>_ح@C>_ح@C>c	@C>c	@C>_ح@C>\N<@C>_ح@C>_ح@C>_ح@C>_ح@C>_ح@C>\N<@C>_ح@C>_ح@C>\N<@C>YJ@C>Vu@C>Vu@C>\N<@C>Vu@C>R<6@C>Ov_خ@C>Ov_خ@C>R<6@C>Vu@C>R<6@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>R<6@C>Vu@C>Vu@C>\N<@C>_ح@C>_ح@C>\N<@C>YJ@C>Vu@C>YJ@C>YJ@C>\N<@C>\N<@C>\N<@C>YJ@C>YJ@C>\N<@C>\N<@C>\N<@C>YJ@C>\N<@C>YJ@C>YJ@C>YJ@C>Vu@C>Vu@C>Vu@C>Vu@C>Vu@C>Vu@C>Vu@C>Vu@C>Vu@C>YJ@C>\N<@C>\N<@C>\N<@C>_ح@C>_ح@C>c	@C>c	@C>_ح@C>_ح@C>c	@C>_ح@C>c	@C>c	@C>c	@C>c	@C>c	@C>iB@C>fffff@C>_ح@C>c	@C>c	@C>c	@C>c	@C>c	@C>c	@C>c	@C>_ح@C>c	@C>c	@C>c	@C>c	@C>c	@C>_ح@C>_ح@C>_ح@C>_ح@C>_ح@C>c	@C>_ح@C>_ح@C>c	@C>_ح@C>_ح@C>_ح@C>\N<@C>_ح@C>\N<@C>\N<@C>YJ@C>YJ@C>_ح@C>\N<@C>\N<@C>YJ@C>\N<@C>YJ@C>YJ@C>Vu@C>Vu@C>Vu@C>Vu@C>R<6@C>R<6@C>R<6@C>R<6@C>R<6@C>Ov_خ@C>R<6@C>R<6@C>R<6@C>Vu@C>YJ@C>Vu@C>R<6@C>Ov_خ@C>L/{J@C>L/{J@C>Ov_خ@C>L/{J@C>Ov_خ@C>L/{J@C>L/{J@C>Ov_خ@C>L/{J@C>Ov_خ@C>Ov_خ@C>H@C>H@C>E@C>;5X@C>;5X@C>;5X@C>;5X@C>;5X@C>;5X@C>;5X@C>;5X@C>;5X@C>;5X@C>8YJ@C>8YJ@C>;5X@C>8YJ@C>;5X@C>;5X@C>8YJ@C>;5X@C>8YJ@C>8YJ@C>;5X@C>;5X@C>8YJ@C>;5X@C>;5X@C>8YJ@C>;5X@C>;5X@C>8YJ@C>8YJ@C>5?|@C>5?|@C>8YJ@C>8YJ@C>8YJ@C>8YJ@C>5?|@C>8YJ@C>8YJ@C>8YJ@C>;5X@C>8YJ@C>5?|@C>5?|@C>5?|@C>8YJ@C>8YJ@C>8YJ@C>5?|@C>8YJ@C>8YJ@C>8YJ@C>5?|@C>5?|@C>8YJ@C>5?|@C>5?|@C>8YJ@C>5?|@C>1.@C>.2@C>1.@C>1.@C>1.@C>1.@C>8YJ@C>5?|@C>5?|@C>8YJ@C>8YJ@C>5?|@C>5?|@C>1.@C>1.@C>1.@C>1.@C>5?|@C>1.@C>.2@C>5?|@C>;5X@C>5?|@C>8YJ@C>;5X@C>8YJ@C>5?|@C>1.@C>5?|@C>5?|@C>.2@C>5?|@C>.2@C>1.@C>1.@C>1.@C>.2@C>+jg@C>+jg@C>.2@C>.2@C>1.@C>.2@C>.2@C>+jg@C>.2@C>1.@C>.2@C>.2@C>.2@C>+jg@C>($x@C>.2@C>.2@C>1.@C>1.@C>.2@C>.2@C>.2@C>.2@C>1.@C>.2@C>1.@C>.2@C>.2@C>.2@C>.2@C>.2@C>.2@C>.2@C>+jg@C>+jg@C>.2@C>1.@C>.2@C>.2@C>.2@C>.2@C>.2@C>.2@C>.2@C>+jg@C>.2@C>.2@C>.2@C>.2@C>+jg@C>+jg@C>+jg@C>+jg@C>+jg@C>($x@C>.2@C>+jg@C>+jg@C>+jg@C>($x@C>($x@C>$/@C>+jg@C>($x@C>+jg@C>($x@C>($x@C>$/@C>$/@C>($x@C>$/@C>$/@C>!R<@C>Ov_@C>!R<@C>!R<@C>!R<@C>Ov_@C>!R<@C>Ov_@C>!R<@C>!R<@C>!R<@C>Ov_@C>Ov_@C>!R<@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>!R<@C>Ov_@C>!R<@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>!R<@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>!R<@C>!R<@C>Ov_@C>Ov_@C>Ov_@C>u@C>Ov_@C>u@C>u@C>u@C>Ov_@C>u@C>u@C>u@C>u@C>u@C>Ov_@C>Ov_@C>u@C>@C>u@C>Ov_@C>u@C>@C>u@C>u@C>Ov_@C>!R<@C>u@C>!R<@C>u@C>Ov_@C>Ov_@C>!R<@C>Ov_@C>Ov_@C>Ov_@C>!R<@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>u@C>Ov_@C>Ov_@C>!R<@C>Ov_@C>Ov_@C>!R<@C>Ov_@C>Ov_@C>!R<@C>!R<@C>!R<@C>u@C>!R<@C>!R<@C>Ov_@C>Ov_@C>Ov_@C>!R<@C>Ov_@C>!R<@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>u@C>!R<@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>u@C>Ov_@C>Ov_@C>u@C>Ov_@C>u@C>Ov_@C>Ov_@C>Ov_@C>u@C>u@C>Ov_@C>u@C>u@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>u@C>u@C>Ov_@C>Ov_@C>Ov_@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>Ov_@C>u@C>@C>Ov_@C>u@C>u@C>@C>u@C>u@C>u@C>@C>Ov_@C>Ov_@C>u@C>u@C>@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>Ov_@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>Ov_@C>u@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>u@C>u@C>u@C>u@C>u@C>Ov_@C>u@C>Ov_@C>u@C>u@C>u@C>Ov_@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>Ov_@C>u@C>Ov_@C>u@C>u@C>u@C>u@C>u@C>Ov_@C>u@C>u@C>u@C>u@C>u@C>u@C>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @iv9Xb@iLe+@iYg	l@ia/V@i9H˒:@iE@iJ     @iowk@iw#@i\tj@ikjOv@io:)z@i@ie+a@in.@ig	@isP@iޞ쿱[@j6A7K@jg	@kI&@kԇ+J@llC@mQ@o~@p{@o؃n@nO
M@m<D@m]cf@n2]ce@o@n@otr Ĝ@o7-@p͞&@piDg8@nߍO;d@nGE85@pU=@q+@qn@qQ@qOv`@qq@p[6@pB_o @p\>6z@pjOv@pPH@p%2@o=@nߤ@n'RT@n@JM@mRT`e@mʩ@m~($@n=@nyzxl"h@nHߤ?@m4֡a@lW'@lmN;5@lRZ@lC,z@lu%F@l?@l1J#9@koiDg8@k7'0@j@jվvȴ9@j+a@kߤ@@k*oiDg8@k@kۋq
@jN;6@j!R<@j͞@j]cA@jՅoiD@kVl!@kQ@j
qu@jڹ@j/@jS@jO
M@j6z@jm,zxl@jm"`B@jk3@jN?@jgx@jw1@jr@jo@jj$xG@j@j|Q@jm]@jڕᰊ@j=b@k@k;\(@k_@kf͞&@kpYJ@kft@klVϪ@klSMj@kj쿱[W@kK]@k/V@kq@k-w1@kY@ks4J@k'@k-V@k5Xy@k!-w1@k=b@kn/@lI^@lE@l @l+@ks@k!-w@keں@kn.@k:S@kMkP@j@N@j,zxl@jOv_@j73@ju"@j|@j"@jhr @j`A7@kᰉ'@k,&IR@k>2W@k	k@j}H@jv@j&IR@jTɅ@jS&@jL/{J@jJ#9@j'/@ja@@jA [@jحV@jIQ@jrGE@j+jg@jb}@jߗ$tS@jjf@je@j)^@jK]d@je+@jwkP@j=b@joI^@jh
(@j[ڹZ@j<74@j/u@j!)^	@jO;@j0
)@jXbM@iVu@ia@@im8@i1@i ě@j*ȴ9X@jb}V@jXy=@j>4m9@j	jOv@jZc@j7=b@j;fA@jIQ@iߤ@iF]c@iu@i&IR@hZ1@hsy@h6@iv@i͒:)z@i{ߤ@hN;5@hw@h5Xy@he@hrG@hw1@h*0U@hKƧ@h-
@hߤ@@hvl!-@hnL_@hRL/{J@h>>B[@hEo@h<@h/!R@h:@h6|@h>`A@h`$/@h2W@hL/{J@h<64@hH@hdZ@hw~($@hL6z@h>)_@hEr@he*0U2@hXy=@h
L/@h|@hwk@hS&@ht@ifA@hm\@h0
@h4J@h]ce@h&@h1@h)@hY@h_p@hc	@hpL/{@g4m9@g'@gP{@g͞&@gt@gH˒:@g䎊r@g}H@gk4m@geA [@gE84@gߤ?@gAs@gl ѷ@gjOv`@geO@fݗ+k@fqx@fn ě@fg@ffW'@fu-V@f{+I@fdm@f_ae@f[5Xy>@f\_@ffPH@ft1.@fm?|h@fN{@f;>6z@f-Z@fC:)z@fT<쿱@fI [7@f;<64@f4I^5?@f0Ov_@f5U=@fB*0@f@?@f4Fs@f*@f$E@fR<6@f&_ح@f-O;dZ@f.@f.@f-O
M@f1&y@f-O
M@fK@fI[@f\YJ@f{@N@f@fIQ@f@@f'/@f#x@fc	@fƧ@f)^	@fqu"@f,<@f4֡b@f5Xy>@fr?@fttj@fn'RT@f\zG@fXOv_خ@f_A [@fh"@fog@fj[6@fd@f`3@fT!R<@f\vȴ9X@fcg	l@fUM:@fOY}@f=lC@f.-
@f;	@fBbM@f))^@f$@f&H@f)rGE@f'q@f"Ov_@f )@f Y@f֡a@fϪ͟@f@eb}V@el@e4m@ep:~@ep:~@e-@e'/W@e㙙@e|@eB@e4֡a@elD@e%1@es@e쿱[W@e+@fjOv@fݘ@f!.H@f'R@eۋq
@eiB@f 
(@f?@f&<쿱@f
u%F
@eZ1@e.2@e.2@eK]c@eu@eJL@eμj~@eXbM@eт@eOv_@e@eߤ@@eA [@e~$@ee+@eʌ@ea|Q@eZ@e|hs@e	ԕ+@e`A@e'RT@fs@f 
=q@f$p:@f S&@fᰊ@fC,@f/ᰉ@f8?@f4*0U@f&0U2a|@f_o@f?@f5Xy@fFs@f@f@eO
@eS&@e3@en@e3@e簉'R@eM:@eiB@e?|h@e@eڹY@eL_@e*0U@ew1@eiDg8@e3@e=b@et@e=b@e@eb@eu!@e.2@e4K@ebM@eeO@e՞%@e@e-V@e,@eVl!@e84֡@e9XbN@eVu@e՜ߤ@eƧ@eb}@ee+@e8YJ@eF@eS@eF]c@equ!@eqiC@em@e$tT@e܌@e)^	@e8Y@ea|Q@e(@e܌L_@exF@e64@enO@e'0@e'/W@e܊qi@eo hی@e5?|@e܊qi@eC]@eBZc @e4J@e&x@e{J#9@e7Kƨ@em]@e^@e쿱[W@eݗ+k@f2W@e@N@eݗ@f 
=q@f6@fg@ey=c@eݗ@f
#w@fwk@f
[6@fzG@f&!R<@fS&@fL_@fS&@fcA @f>BZc@fcA @f#Y|@fh	ԕ@f S&@f-nP@f(fB@f(fB@f8-
q@f?	@f<W'@f6W@f/حV@f N;@f.tSM@f5eں@f4u%F@f1;dZ@f*I^5?@f4u%F@fAe@f<VϪ@fH֡a@fVY@fOy@f@o h@fCGz@fGrGE8@fM hۋ@fCGz@f8+jg@fA%2@fKu@fOy@fYb}@fD6z@fD6z@fHϪ͟@fHϪ͟@f@IQ@fHϪ͟@fXQ@fSA [@fUTɅo@fYb}@fgae@fl@faa@@f_@fSoiDg@fXu@f]*0U2@f]*0U2@f_@f]*0U2@fQ)^	@f`oiDg8@fuDg8~@fuDg8~@fkq@f`oiDg8@fnR<6@feڹ@fa@fqPH@fv@fyn.3@fzѷX@f}A@f|4m9@fym\@fym\@f&@f'RT@f9Xb@fA7K@f(@f}+j@fym\@fk	@fj&IR@f~>@fVϫ@fl"h	@f$/@fNU@fkP|@f~>@f~>@f/@f\@fOv`@fR@f@4n@f2a|@f-V@f+@f/@fᰊ@f$xG@f+@f/@f_o@f-@f&@f@f[@f1@f@f3@fx@fx@f3@fwkP@fn@fn@fiDg8@f/{J#@f@fZ1@f?@f>BZ@f?@f	k@fo@fO
M@f!-w1@fZ1@f>BZ@fZ1@f+@fY}@fu!S@fu!S@fu!S@f<쿱@fY}@fY}@f@f1@fI^5?@f!-w2@f!-w2@f̻@fȐ$t@f!-w2@fς@fȐ$t@f ѷ@f$@fڞ쿱[@feں@f1@f1@fI^5?@f-w1@fI^5?@fo h@f^5?}@fȴ9X@f
=p@fρ@fOv_@fs@fӬq@fs@fe+a@fe+a@f@@fMj@fߤ@@fϪ͟@f@f@fGz@f6z@f幌~($@fd8@f
(@fF]c@fqu!@fTɅo@fA [@f@f*0U2a@f@f$tT@fF]c@f$tT@fF@fF@f*0U2a@fƧ@fC,z@f
(@g~$@fA [@f73@fS@gp:~@gp:~@g	a@@f4m@g u@g	a@@f4m@f@gE@g,<@g*0U2@gD*@foiDg@fS@g@gq@g4֡b@g	@g҉@gD*@g6z@g6z@fS&@g 6@gD*@g6z@gPH@g"ѷX@g 
L/@g_p@g
ڹ@gu%F@g_p@g 
L/@gěT@gěT@gPH@g$5?|@g 
L/@g	@gsh@g 
L/@g!n.3@g
qv@gc	@g 
L/@g(_ح@gPH@g`A7L@gPH@g+&@g4҈p@g%+j@g%+j@g/P{@g)\(@g+&@g+&@g"`A@g$5?|@g"`A@g)\(@g4҈p@g4҈p@g+&@g%+j@g&~@g+&@g$4m9@g*0@ghr@g,'RT@g;|@g,'RT@g&~@g3zxl"h@g>@gD$/@gBTɅ@g3zxl"h@g9u%@g6A7K@g6A7K@g9u%@g/O;dZ@g,p:@g7v@gD$xG@g4 ѷ@gEݗ@gI-V@g?C\@g6A7K@g=2a|@gO@N@gI-V@gEݗ@gI-V@gR_o @gSjf@gR_o @gO@N@gW$@gTp:@gP
=q@gO@N@gKs@gV1&x@gV1&x@gT͞&@gPS&@gPS&@gPS&@gT͞&@g[H˒@gT͞&@gSjOv@g[H˒@g^YJ@g[H˒@gWO
@g]"`B@g[H˒@gX74@gWO
@gSjOv@gPS&@gO?|h@gaMjO@gM@g]"`B@g^YJ@gb ě@gmcA @gX74@gaL_@gew1@go/V@gwQ@gfڹY@g]"`B@gfڹY@gfڹY@gaL_@gb ě@gaL_@gb ě@gq!.@gt
(@go/V@gmcA @gh>BZc@g_rG@gkS&@gi@gd*0U@gwQ@gv!R<@gq+j@go/w@gi@gm˒:)@gb ě@go/w@g{1@gv ě@gh=p
@gko i@go/w@gko i@gi	k@gm˒:)@gt<64@gwM:@g=K^@g.2@g-
q@g{1@g~u!@g}nP@gq+j@gzK]c@g}u@gv ě@gvȴ@gt<64@gx@gحV@g<64@g~u%F
@g~u%F
@g<64@g<64@gzJL@gv ě@g}u@g<64@gx@g{zH@gfA@g	@g<64@g{zH@g	@g,=@gF]d@gF]d@gfA@gF]d@gfA@g<64@g<64@gF]d@gQ@g@gQ@gsP@gbM@g-V@g!-w@g/V@g@g/V@gɅoi@g@gE@g$/@g:~ @gQ@gW'@gW'@geO@gsP@g%@g:~ @gIQ@g/V@g\(@g+a@g>B@gd7@g+a@g-V@gbM@gd7@g+a@g:)y@g:)y@gK]d@gK]d@gd7@g䎊q@g$/@g     @g䎊r@g+a@g}H@gK]d@g\(@gVl!@g\(@gce@g84֡@gVl!@g:@g䎊r@gfA@g84֡@gce@g84֡@gfA@gce@g4m@gfA@gqiC@gGE85@gwkQ@gce@g     @g     @gwkQ@g*0@gS@gm@g*0@gm@gm@gwkQ@gZ@g)_@g@@g73@g@@gF
L0@g
qu@g@@g@@g,<@gƩ@gƩ@g͛=K@gƩ@g,<@gbM@g͛=K@gF
L0@gce@gr@g?@gqu"@g@@g@@g,<@gԌ@g8Y@gԌ@gm\@g8Y@g
qu@gr@g,<@g͛=K@g͛=K@g͛=K@g,<@goiDg8@g6@gp
=@gض}Vm@gS@g}H@gڹ@gG{@gbM@g6@goiDg@gߨXy=@g҉@gض}Vm@g6@gS&@g͚kP@ga|Q@g}H@gߨXy=@g#@g0
@gߨXy=@g@gQ@g`A7L@g#@gߨXy=@gD*@gQ@g'RT`@g'RT`@gڹZ@g#@g5Xy>@gc	@g
qv@gsh@g
qv@gsh@gPH@g@g|hs@g0
@g@g'RT`@gL/{@h_F@g+j@gB@gQ@gsh@g*0@g	ԕ+@g4m9@g+j@g+j@gL/{@gQ_@g&IR@gB@g4m9@h ~@g4m9@g	ԕ+@g	ԕ+@gL/{@g+j@h&@h	P{@hA7K@h(@h\(@h%F
L@h@h
zxl"h@hϪ͞@hv@h ѷ@hv@hVϫ@h >@h%F
L@h
zxl"h@hu%@h	O;dZ@h%F
L@hl"h	@hl"h	@hl"h	@hϪ͞@h@hl"h	@hA7K@h^5?|@h@hrGE9@h#-V@hv@h ѷ@h%s@h\@h	O;dZ@hu%@hVϫ@h
zxl"h@hn@h#-V@h#-V@hn@h)@N@h274@h&y=c@h\@h+@hn@h\@h\@h\@h$xG@h C,@h%s@h'?@h%s@h,_o @h"NU@h$xG@h&xl"h
@h'@h%s@hᰊ@h+@h&xl"h
@h)?|h@h%[@h,@h7"`B@h7"`B@h,@h)?|h@h-jOv@h274@h1O
@h JM@h.͞&@h8YJ@h<{@h.͞&@h)?|h@h1O
@h5H˒@h>*0U@h1O
@h&@h01&x@h5H˒@h-jOv@h,@h1O
@h< ě@hC@hES&@hC@h< ě@h?w1@h7!.H@h< ě@h8ݘ@h1ݗ+@h4Zc@h1ݗ+@h< ě@h9rG@h7!.H@h8ݘ@h8ݘ@h9rG@hC@h8ݘ@h4Zc@hB>BZc@hMY|@hN<64@hK+j@hTK]c@hP ě@hJS&@hMY|@hP ě@hQM:@hYb@hU1@hJS&@hK+j@hJS&@hWnP@hTK]c@hU1@hP ě@hN<64@hRfB@hG˒:)@h;KƧ@h@>B[@hMY|@hN<64@hR@hWu@hXu%F
@hchr!@hb-
q@hQM:@hP䎊@hN<64@hN<64@hK+j@hKY}@hP ě@hUzH@hXu%F
@hUzH@hb-
q@hYحV@hWu@h\vȴ@hYحV@hI.H@hQ{J#:@hUzH@hXu%F
@h^F]d@hfXy=@hchr!@hQ{J#:@hTJL@h^F]d@hb-
q@hjn@h\vȴ@h[<64@hWu@hTJL@hgn/@hk,=@hdD@hb-
q@h`W@hgn/@h\vȴ@hUzH@hQ{J#:@h[<64@h`W@hb-
q@h_fA@hUzH@hYحV@hj@4@hj@4@hd!-w@hchr!@hfW'@hd!-w@h`Ʌoi@hfW'@hrsP@hk@hfW'@hb-V@hd!-w@h^u%F@hW)^@h^u%F@h`Ʌoi@hiQ@hmIQ@hmIQ@hiQ@hqsg@hrsP@hd!-w@hg/V@hj@4@hg/V@hk@hxd7@ht:)y@hj@4@hd!-w@hb-V@hiQ@hc@hp@hqsg@hxd7@hu-V@hqsPH@hxd7@ht:)y@hiQ@hb-V@h[;dZ@hb-V@hmH˒:@h}䎊r@hyK]d@hmH˒:@hke@hu-V@hi,@hfVϪ@hmH˒:@hqsPH@hu-V@hxd7@hxd7@h{+a@hw:@hmH˒:@hp@hU=@hGE85@h|qj@hp@hke@hqsPH@hyy@hyy@h|qj@h|qj@h|qj@h#x@h}s@hmH˒:@hr֡a@h{+I@h}s@h4m@h}s@h{+I@ht9XbN@hn6z@hxcA \@h#x@hGE85@h4m@hxcA \@h|qj@h{+I@h}s@h{+I@hjIQ@hjIQ@h|qj@hqiC@h|qj@hZ@h͞@h.H@h.H@hl@hU=@hS@h
M;@hyy@hb}@hC-@h}s@hyy@hb}@hFs@hQ@hFs@h
M;@hFs@hl@hl@hxc	@hb}@h.H@h?@hO;d@h8}H@h}A [@hl@hb}V@h)y@h8}H@h?@h.H@hxc	@hrϪ͟@hyƧ@hl@hԕ*@hb}@hC-@hl@h
M;@hTɅo@h}A [@hxc	@hl@hp:~@h}A [@hb}@h(\@hSMj@hm\@h,<@hC-@hQ@hTɅo@hb}@hFs@h*0U2@hv@h@h|@hQ@hae@h,<@h
M;@h(\@hX@h@huߤ@hQ@hQ@hyƧ@hE@h@h@hae@ha@@h*0U2@h*0U2@ha@@h,<@ha@@h4m@h|@h@h7KƧ@ha@@hu@hS@he+@hp:~@hp:~@h*0U2@h7KƧ@hp:~@h\N@h}oiDg@ht8YJ@h{)^	@h|@h\N@h~($@hp:~@hp:~@hE@h*0U2@h*0U2@hE@h|@h}oiDg@hae@h_p@h*0U2@h|@hE@hE@h{)^	@hS@h~$@h~$@h{)^	@h@h($x@h7KƧ@hu%F@ha@N@hE@hS@h*0U2@hp:~@he+@hoiDg8@hu%F@he+@h|@hu@h}oiDg@h|@h}H@h6z@hE@hR<6@hoiDg8@h|@h~$@hS@hy8Y@hu@hXy=@h6z@hڹ@hR<6@hu%F@h6@h҉@h6z@hu%F@hu%F@hu%F@hěT@h4֡b@hR<6@h($x@h҉@h6@hD*@ha@N@h4֡b@hq@hu%F@h($x@hěT@h6@h҉@hڹ@ha@N@h($x@hěT@hoiDg8@hS&@hoiDg8@h4֡b@h}Vm@hD*@h@hPH@h6@hD*@hoiDg8@h}H@hD*@h҉@hXy=@hyo @h}-@h@h#@h@hڹZ@h|@h'RT`@h'RT`@h@h'RT`@hڹZ@h`A7L@h@h@h`A7L@h0
@h`A7L@h5Xy>@hnO@h'0@h@hPH@h'RT`@h#@hڹZ@hC%@h@hC\@hnO@h0
@h@h|@hQ@hC\@hC\@h@h5Xy>@hPH@h
qv@hc	@h5Xy>@h'0@hڹZ@h#@h#@h`A7L@h`A7L@h@h&@h0
@h3@h+j@h;dZ@h#@hnO@h_@hlD@hC\@hRT`e@h'0@h@h_@hlD@h|hs@h|hs@h{'/W@hu@hu"@hm8@h;dZ@h*0@h4֡a@h|C@h?@hm8@h4֡a@h(@h|C@hߤ?@h|hs@h4֡a@h&IR@hN;6@h
=p@h(@h_o@hN;6@hߤ?@hC,zx@h
=p@hlD@hN;6@h_o@h7@hlD@htj@h(@h(@h|qi@htj@h_@h4֡a@h|Q@hvPH@hQ@h4֡a@h(@h|qi@hqn.3@hQ@hlD@h^@h&IR@h
=p@hQ@htj@h|qi@h'@hya@O@huA@huA@hj|@hrѷX@h}C]@h|qi@hQ@hrѷX@hiPH@hp
L/@hqn.3@hqn.3@hn@huA@huA@huA@hiPH@hqn.3@hmC%@huA@ht5?|@hiPH@hmC%@hQ@hߤ?@hiPH@hY@hj|@hrѷX@h}C]@hj|@h_a@N@h]ڹ@hmC%@ht5?|@h}C]@h|Q@hvPH@hrѷX@hQ@hn@hn@hQ@huA@hmC%@hvPH@huA@hx_ح@hqn.3@hk
qv@hgsh@hj|@hqn.3@hrѷX@hC,zx@hya@O@hdc	@hp
L/@hrѷX@hx_ح@hp
L/@h{&x@hya@O@hvPH@hcڹZ@h]ڹ@hj|@hqn.3@hqn.3@huA@hvPH@h|Q@hya@O@h|qi@hrѷX@huA@hvPH@hrѷX@hn@hya@O@hrѷX@hmC%@hya@O@hx_ح@hn@hqn.3@hx_ح@hqn.3@hp
L/@hya@O@hx_ح@huA@hx_ح@hx_ح@hfQ@hn@hmC%@hqn.3@h|Q@h{&x@hvPH@hvPH@hx_ح@hx_ح@h}C]@hx_ح@hmC%@h{&x@ht5?|@hya@O@h|qi@h{&x@hvPH@hj|@hj|@hiPH@h|qi@ht5?|@hn@hya@O@hp
L/@ht5?|@hya@O@h}C]@h}C]@h҈p@hvPH@hn@hmC%@htj@ht5?|@hx_ح@hn@hj|@ht5?|@huA@huA@ht5?|@h{&x@ht5?|@hmC%@hj|@hya@O@hx_ح@huA@hj|@hvPH@hQ@hx_ح@h{&x@hqn.3@hmC%@hvPH@h|qi@hmC%@h`@hj|@hvPH@h҈p@h{&x@h{&@h{&x@hvPH@ht5?|@hp
L/@hn@hqn.3@hx_ح@hx_F@hk
qv@huA@hqn.3@hp
L/@hn@hfQ@hvPH                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ?4m??N;5X?[W>6z?حU?C]?%1?3?#?tSMj?|?@N?
(?_o?64K?GzH?g8}H?+I^?`A7?ߤ@?[?-
?t?!.H? ѷX?䎊?$tS?q?o?'RT`?d7?*0U2a|?҈p?Ĭ1&y??ȉ'RTa?$tS?E?ǷrG?333333?s?zxl"h
?4J??ϚkP|? ěT?rGE8?u!.?Ёo hی??vȴ9X?ᰉ'?ҤTɆ?@?fA?ޔFs?jOv`?҈?g	?GzH?p:~ ?ȴ9Xb?/w?(\)?1o?ԕ*1?_o?u%F
L?m\?lD?zxl"h
?C\?1-?xF?(?0U2a|?;5Xy?T`d?C?vȴ9X?iB?|hr?e+?c	?8YJ?е??|Q?Ь1&y?vȴ9X??ʜwkP?[6?*0U2a|?T`d?,<?ūU=??8}H?żn.?Ÿ)?n?g	??åS?W>6z?/v?Ģ3?Z?>BZ?@NU?#9?½<64?xF]?åS?° ě?üZ?%1?#9??c	?6z?NT?l"h	ԕ?Fs?~($?l"h	ԕ?E?tj?O;dZ?E?GzH?|?o hی?cA \?GzH?-w1?N;5X?u?{J#9?Z?@?sg?dZ1?lC?sPH?=K^?4J?ae?ᰉ'?Ov_خ???m\???u!R?#?U=K?Ov_ح?u?-
qv?Ov_ح?+j???Q?vȴ9X?1&?S?U=?u!R?:)y?kP{?ᰉ'?$?_o ?+jg?ceO?sg?tj~?$tS?a@N?O
M?*0U2a?UL_?Q?ᰉ'?ᰉ'?$/?ɅoiD?=K]?{Q_?v+I?S*0U2a?M}H˒?sPH?|??n??E?Ϫ͞?+Xtj~?{?Z?N;5?Xe+?{qu!S?{u%F?bsPHF?vȴ9?T`dJ6C-?+I?4JRn/?vOv_خPbM?O
M?Z?2a|Q?$/?O
M?$/?*0?Q?}Z?U=K??l1&ya4J?{qu!S?Fs?nO;?}Z?{Q_Q_?bM?O
M?2a|Q?@?xPH?L_?҈?vȴ9X?bM?q4J?4J?tj~?u%F
:6C-?@NU?@NU?-
qv?zvȴ9htj~?:)y?sg?<64?*0
?|1&y?-
qv?4J?@?J6C-??}H˒?m}H˒?,<Rn/?S&?)^	?{u%F?䎊q?lM}H˒?N;5?*0U2a?$tS?)^	?vǿq4J?F?{u%F?M}H˒F?ݗ+j?E?4J?n?lkQ_uL_?nOv_ح?~Q?Xe?$/?$tSM6C-?sg?},<?[Q_?~Ov_ح?tj~?_o?Z?`A7L?rsPH@bM?,<쿱?sPHXtj~?a@N?ɅoiD?zG{?bM?wXe+?q4J?rsPH?kP{?!-w1?M}H˒?rnO;?y_o ?쿱[W??E?3*0U2a?-
qv?m}H˒?V?:)yfOv_خ?<64?+?-
qv?zvȴ9_!-w1?n/?L_?4J?z6C-?`A7L3*0U2a?sg?u%F
?S*0U2a?F?}H˒?Q_?w?}Z?xtj~?}H˒?U=?$tS?p)^	q4J?nOv_حqu"?w?䎊q?4J?        ?p:?N;5X?z6C-?z6C-?tn?nOv_حf?)^	?-
qv?uL_o䎊q?{qu!S?v+Io!-w1?҈?sg?A?!-w1?{Q_?ɅoiD?Xe?vȴ9?@?bn/J6C-?*0U2a?+jg?*6C-?Mj?Ov_خ?_FtRn/?T`dC*0U2a?q4J?}}H˒?l?sg?$/?e+??|??fA?N;5?tj~?ߤ?l1&yM}H˒?Xec*0U2a?҈?Z?҈?u%F
?vȴ9?y_o ?u"?ᰉ'?U=K?hr Ĝ?xtj~?{qu!S?fǿ:6C-?*0
?p:?n/?)^	?nO;?Fs?ݗ+jbn/?q4JfOv_خ?rsPH?hr Ĝ?~Q?C*0U2a?J6C-?*0
?c	?2a|Q?N;5?},<??v+IbsPH?usgV?҈?=K^?R<64?{u%F?:)y?sg?{qu!S?,<?PH?`d8?-V?,<?{qu!S?*0?Z?ᰉ'?l!-w?}H˒?ݗ+j?zvȴ9_!-w1?IQ?fOv_خ?u%F?O;dZa4Jo䎊q޿q4Jw@bM?S*0U2ap)^	kQ_?|1&y?~Q?Z?a@N?$/?}Z?}Z?:)yPbMtZ?a4J?}Z3*0U2as*0U2a?uL_?Q?-
qv??N;5X?{qu!S?䎊q?}ZrnO;?~Q?S&?҈?4J?!-w1?PbM?R<64?2a|Q?1&y?vȴ9?쿱[W??{qu!S?PH?hr Ĝ?u"?Fs?ݗ+j?vOv_خo䎊q?uL_dzG{?x*0
?N;5?hr ĜZ6C-?htj~?)^	?]}H˒nOv_ح?rnO;?sg?hr Ĝ?rnO;a4J?䎊q?~Ov_ح?hr Ĝ?$tS?~Ov_حfǿku%Fl1&y?u%F
?qu!S??Z6C-?4J?$/?-
qv?{qu!S?q4Jm}H˒q4J?rn/?rsPHs*0U2a?usg?|C,zxl?҈?M}H˒?fOv_خ?-
qv?c*0U2a?u%?vȴ9?쿱[W??{qu!S?|1&y?Ov_خ?2a|Q?H?_!-w1?Z?fA?ᰉ'?E?nO;?Mj?tj~?!-w1?$/M}H˒m}H˒?c*0U2a?|1&y?-
qv?{qu!S?tZ?Vǿ3*0U2a?0
(?fA?$tS?gfOv_خ?vOv_خ?usgusgpbM?H?[Q_?o䎊q޿fǿ)^	?-
qv?₿s*0U2azvȴ9@bM?S&?E?SٿS*0U2a?!-w1?)^	?Mj?!-w1?},<PbM??A?C*0U2anOv_ح?S&?:)y?{u%F?*0U2akQ_?C*0U2a?*0?䎊q޿Xtj~?{Q_?	 ?*0?2a|Q?sPH?N;5?},<J6C-s@NUzvȴ9?bsPH?:)y?~Q?,<?)^	?rnO;l1&y*6C-?Qku%Fc*0U2a?҈?FsF?o䎊q?sPH?ᰉ'?FǿvǿrnO;?@bM?!-w1?rn/ye+a        ?n/?}Z?|1&y?rsPHg?},<?},<C*0U2a?tn?Q?rn/?M}H˒?-
qv?IQ?},<?z6C-?vȴ9X?n/?R<64?H6C-?lXtj~?bM?6?F?zvȴ9?sPH?AXtj~?$/?:)y?}Z?Z?tzG{?U=K?Z6C-?{?tn?y_o ?bM?},<?hr Ĝ?䎊q?l?+jg?Q?@?$/?tj~?`bM?M}H˒ku%F?*6C-?	 ?o䎊q?UL_?n/[Q_?{qu!S?~Ov_ح?N;5??e+a?p:?L_?3*0U2a?O
M?L_?{qu!S?!-w1?2a|Q?ᰉ'?C,zxl]}H˒?_Ft?c	?S&?ݗ+j?@NU_!-w1ſpbM?vOv_خ?{Q_?+I?+J?{Q_v+I        ?tzG{?|1&y?g?*6C-uL_kQ_?u"?{u%Fo!-w1?&?(\)?C,zxl?$?sg?hr Ĝ?*0U2aC*0U2a??n?hr Ĝ?u"o䎊q?tzG{?rsPH?l1&y?>BZc?wkQ_?u"?uL_?uL_?V?U=K?]}H˒*6C-?p)^	?wXe+?usg?x*0
?pbM??&?n?8YJj6C-?uL_fOv_خ?n/Z6C-w?c*0U2a?w?tzG{?qu"?Q_?vȴ9?+jg?,<?Xe+?n?O
M?@NU?vOv_خuL_?nOv_ح?qu"?wXe+Կrn/?J6C-m}H˒xtj~?}H˒?4J?eL_?O
M?0
(?kQ_??@NU?*0?*0?vȴ9?@bMx*0
j6C-?usg?j6C-?	 ?u!{u%F?N;5kQ_?M}H˒tzG{?@bM?nOv_ح?o䎊q?vOv_خ?o!-w1ſie+a?fOv_خ?䎊q޿xtj~?c*0U2aVǿ},<ku%F?+?$tSbn/?tzG{?rn/{qu!S?M}H˒?䎊q?ݗ+j?tn?u%?ᰉ'?O;dZ?u!?y_o ?w?rnO;?Rn/{u%F?bsPHy_o },<v?v?4J?҈οfǿ|1&yvOv_خ??=K]?s@NUp)^	?fOv_خ?L_dzG{?䎊q?*0U2a?Zݘ?usg?tn?Zݘ?}}H˒?nOv_ح?bsPH{Q_F?PbM[Q_?nOv_ح?$tSp)^	?o!-w1?},<?L_?$tSdzG{?N;5Xf?*0U2?xPH?%2?s@NU?_!-w1ſvOv_خ},<PbM?g?qu"?A?wkP?hr Ĝ?IQnOv_ح?o䎊q޿s@NU?p)^	?vOv_خ?s*0U2a?v+I?rn/?ye+aku%F?F?rsPH?rn/eL_bMy_o htj~?tn?N;5?!-w1ſusg?tZ?!-w1?<64?ye+arn/|C,zxl?ᰉ'?rsPHp)^	?zG{?~Ov_حJ6C-?v?Xe+?`d8?Z?Q?wXe+?䎊q?_oҿuL_usg?+I??N;5kQ_S*0U2a?=K]?e+aS*0U2a?bsPH?*6C-?E?u%F
|1&yxtj~tzG{qu"?N;5X?$tS?Q?UL_?UL_V?A??-V?!-w1?e+a?ᰉ'?Q?~Q?u"?҈??}}H˒?~Q?N;5XfǿtZ?ie+a?Q_?$tSM?tZ?0
(?0
(?}H˒?	 ҿc*0U2a?bsPHc*0U2a?{?qu"?j6C-o䎊q?䎊q?@NUeL_?@?rnO;?V?ᰉ'?PH?ᰉ'bsPH?y_o ?fǿku%F?fǿqu"rnO;?@pbM?ku%F?tn?$tS?A?kQ_?s@NU?tn?x*0
?]}H˒nOv_ح?$tSM?}H˒?uL_?xPH?usg?v?|C,zxl?z6C-?usg?zvȴ9?wXe+ԿfOv_خ?PH?@?qu!S?L_?sgC*0U2a?_Ft?u%F
g?v?w?sPH?nO;?tj~?x*0
y_o },<?s*0U2aa4J?Q?:)yo!-w1?3*0U2a?wXe+ԿPbM{Q_J6C-?wXe+?s*0U2a?eL_q4J??ɅoiD?:)y`bM?y=b?Z6C-?ie+a?₿Z6C-rsPHw:6C-?6C-p)^	Xtj~?w?R<64?6C-y_o }}H˒?htj~xtj~v?rn/?+J?sgFǿx*0
?_!-w1?~Ov_حS*0U2aa4J?v+I?o!-w1ſtZo䎊q?nOv_ح?v+I?ye+a?Q?xtj~?߿j6C-s*0U2a?e+a?Q?tzG{?rsPH},<_Ft?o䎊q?6C-}ZfOv_خ?a4Js*0U2ap)^	o䎊q?m}H˒?ie+a?tzG{?{u%F?v+I?bM?Ϫ͞?fA?ᰉ'?ye+a?FǿnOv_ح?]}H˒?usg?M}H˒nOv_ح?Ov_حtn~Ov_ح?m}H˒?߿UL_?]}H˒tzG{?F?xPHfOv_خbsPH@bM},<?*6C-?vȴ9X?m}H˒?{qu!S?v?N;5?ݗ+j?	 ҿnOv_ح6C-?m}H˒?Z6C-UL_tZrsPH?4J?4J?c*0U2a?4J?fǿeL_?x*0
?{Q_?z6C-?{qu!S?}Z?{Q_?xPHnOv_ح?]}H˒?,<?s@NU?F?F?nOv_ح?$tSMuL_rnO;?xtj~?o!-w1ſtn?xtj~?xtj~ie+a?l1&y?tzG{ie+a?`bM?~Ov_حFǿ|1&y~Qa4J?|1&y?!-w1?a4J{u%Frn/?tzG{?rnO;xtj~?`bM?zvȴ9?S&?)^	?{Q_?e+a?{qu!S?fOv_خ?usg?$/?Fs?}H˒?v?xtj~?{u%F?+?zvȴ9?u"?@NU?~Ov_ح?~Ov_ح?H?tZusg?f?qu!S?u!?Rn/?f?H?_!-w1ſxPHtzG{zvȴ9l1&y?s*0U2apbM?j6C-?xtj~?Xe?*0U2aRn/M}H˒J6C-xtj~wXe+Կusg[Q_?a4Jl1&y?vOv_خ?rsPH?xtj~?n/?!-w1ſ_!-w1?uL_??|1&y?	 ?C*0U2a        ?l1&y?eL_eL_?	 ?nOv_حo䎊q?ye+a?rn/M}H˒?@NU?|1&y?y_o ?l?҈?*0U2a?ɅoiD?Fs?zvȴ9?}}H˒?4J?u%F
?	         ?xtj~?vȴ9?c*0U2atZPbM?xtj~?nOv_حie+a?|1&y?tj~?|C,zxl?wXe+Կo䎊q?nO;?q?u%F
?s@NUM}H˒c*0U2a?O;dZ?tj~?bsPH??wXe+Կ:6C-?Z?hr Ĝ?v+IrsPH?rn/?{qu!S?Mj?sg?u%F
?!-w1?~Ov_ح?{u%FPbM]}H˒?htj~?vOv_خ?bsPHx*0
m}H˒?s@NUl1&y?nOv_حrnO;s*0U2aku%F?ku%F?N;5X?Xtj~tnq4J?wXe+?Ov_ح?z6C-?ie+afOv_خ?eL_?s@NU`bM?$tSku%F?z6C-?҈?Z?Z?s@NU?u%?Xe+?|1&y?䎊q?*0?w?ye+a?tzG{?|1&y?hr Ĝ?xPH?{qu!S?z6C-c*0U2a?tn`bM?1&y?nOv_ح?]}H˒?u%?hr Ĝc*0U2a?tn?Vǿc*0U2a?usg?rnO;wXe+ԿeL_?+?qu!S*6C-rn/wXe+Կy_o wXe+?V?xtj~?Z6C-p)^	c*0U2a?nOv_حwqu"?y_o ?S&?-
qv?*0U2a?O
M?Q?IQ?:)y?kQ_?O;dZ?*0?-
qvwV?rn/?Z?ɅoiD?T`d?uL_?xPH?|1&y?y_o ?xtj~ku%F?)^	?`bM?nOv_ح?|C,zxl?*6C-rn/?Rn/?{u%F?tzG{?Fs?u"?ie+a{Q_o䎊q?{u%F?sPH?y_o ?tZl1&y?`bM?!-w1?v+I?ku%F?S*0U2a?v?fA?$/q4J]}H˒?4J?bM?Zݘ?tzG{?tzG{?|C,zxlM}H˒kQ_ku%F?o!-w1ſ:6C-?a4J?gm}H˒?wXe+?$/htj~?vOv_خ?Z6C-?wXe+?䎊q?ie+atZ?o!-w1ſpbM?g?{?pbM?Fǿc*0U2a?ie+a?+?L_Rn/?j6C-vOv_خ?tZ?rnO;?xtj~?|C,zxl?:)y?PbM?C,zxl?UL_ye+a?]}H˒?xtj~?z6C-?`bMeL_?UL_s@NUa4J?s*0U2ap)^	?vOv_خ?$tS?<64]}H˒?tzG{?$tS?sg?[Q_y_o |1&y?,<??|C,zxl?p)^	?x*0
?v?kQ_?O;dZ?U=o䎊q޿tn?ie+ao!-w1?l?fA?:)y?kQ_?tn?vOv_خ?S?N;5rnO;        ?w?M}H˒|C,zxl3*0U2a?,<s*0U2a?pbMo䎊q޿zvȴ9ye+a?[Q_?	 ?m}H˒?Rn/?Rn/PbMJ6C-~Ql1&y?:)y?hr Ĝo!-w1ſie+a?tZ?{qu!S?)^	bn/?PbM?`A7L?R<64?|C,zxl?xPH?*6C-PbM??0
(}}H˒o!-w1?ye+a?rnO;w?o!-w1ſo!-w1?q4JRn/?j6C-?y_o ?l1&y?|C,zxl?e+a?u"?Rn/?pbM*6C-?{ſku%Fbn/?n/?usg?T`d?4J?|C,zxl?tnZ6C-?S?W>6z?4J?uL_?s@NU?[Q_g?zvȴ9?y_o ?tj~?`A7Lc*0U2a?:)y?}Zrn/?ku%F?uL_?s*0U2a?vȴ9X?u%F
?}}H˒?z6C-?UL_a4J?pbM?4J?*0?*0U2a?hr Ĝ?vOv_خ?$tS?4J?T`d?n?Z?ᰉ'?=K^?Z?*0?x*0
Z6C-?y_o ?hr Ĝ?ɅoiD?T`d?@NU?n/l1&y?N;5?xtj~fǿxtj~x*0
~Q?	 ?+j?kP{?Fs?Q?sPH?Ov_ح?s*0U2a?gvOv_خ?s*0U2a?bM?Zݘ?)^	?o!-w1?xtj~??*0
?x*0
?IQ        ?y_o ?,<?u"?vOv_خ?vǿZ6C-?a4J6C-?q4J?vOv_خF?|??)^	?},<:6C-?z6C-?|??[Q_?},<C*0U2a?qu!S?Ov_ح?{u%F3*0U2a?x*0
?ye+a?htj~w?tZ?c*0U2atzG{?l1&y?䎊q?ߤ?J6C-?l1&y??N;5X?@bM?-V?tj~?$/?},<rn/?qu"??>6z?}Z?{qu!S?vȴ9X?sg?!-w1?uL_?zvȴ9o!-w1?v+IFǿm}H˒?sg?_o ?|C,zxl?vǿ6C-?qu!S??PbM?0
(?wZ6C-?f?m}H˒?}Zs*0U2az6C-?q4J?`A7L?Ov_خ?tZkQ_?tzG{PbM?ie+a?},<?wXe+?u%?{?fOv_خ?A?4J?$/?Ϫ͞?ᰉ'V?y_o ?Z?n?z6C-?PbM?tj~?|1&y?tZ?{u%F?4J?䎊q?kP{?`bMo䎊q?usg?vOv_خ?xtj~?{u%F?e+a?6C-?@NU?wkPku%F?ku%F?UL_?qu!S?w?`d8?-V?m}H˒3*0U2a?y_o ?tzG{?<64?hr Ĝ?3*0U2a*6C-?xtj~?|C,zxl?Mj?sPH?hr Ĝ?Xe+                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ?????????????????????????????????????ə????????????????????ə?ə?ə?ə?ə?ə?ə?ə???ə?ə?ə????????ə???????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    &,1B!@\)3;37                                      1                                       