CDF       
      time      pressure  k   latitude      	longitude         string_dimension   (         EXPOCODE      29AJ20160818   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    WOCE_ID       TAlPro     	DATA_TYPE         WOCE CTD   STATION_NUMBER        16     CAST_NUMBER       1      BOTTOM_DEPTH_METERS          
Creation_Time         2020-03-19T19:50:18.611739Z    ORIGINAL_HEADER      CTD,20200319CCHSIO
# Converted CTDOXY from ML/L to UMOL/KG using the following:
#     https://github.com/TEOS-10/GSW-Python, downloaded 2019-06-26
#     gsw.sigma0:  Calculates potential density anomaly with reference pressure of 0
#     dbar, this being this particular potential density minus 1000 kg/m^3.
#     This function has inputs of Absolute Salinity and Conservative
#     Temperature.  This function uses the computationally-efficient
#     75-term expression for specific volume in terms of SA, CT
#     and p (Roquet et al., 2015).
#     http://www.teos-10.org/pubs/gsw/html/gsw_sigma0.html 
#     Python equation used:
#         oxy_UMOL_per_KG = oxy_ML_per_L * 44.660 / ( (1000 +  gsw.sigma0(SA,CT)) / 1000. ) 
# Data source:  https://doi.pangaea.de/10.1594/PANGAEA.902330
# SHIP: RV Angeles Alvarino
# Cruise: MedSHIP cruise TalPro
# Region: Mediterranean Sea and Catalan Basin
# Ports: Palermo, Italy to Barcelona, Spain
# DATES: 20160818 - 20160829
# Chief Scientist: L.Jullion
# 43 stations
# Original file in AWI format. CCHDO Converted to Exchange format
# EVENT_CODE=unknown
# DATE: YYYYMMDD
# TIME: HHMM
# LATITUDE: degrees_North
# LONGITUDE: degrees_East
# STNNBR:  removed leading 0s from STNNBR
# CASTNO: not supplied by originator - CCHDO assigned all CASTNO=1 or CASTNO=2 for stations 11, 29
# CTDSAL: changed units from Practical to PSS-78.  Data values remain unchanged.
# CTDFLUOR: changed units from UG/L to MG/M3 as they are they are equivalent
# CCHDO added flags=2 for all parameters, as T.Tanhua notes all params are calibrated and CTDOXY calibrated with bottle samples
# Removed two test sample depths from event/station 004, dTalpro_Stn04_test_1db
# Data precision preserved as submitted.
# CTD: Who - T.Tanhua; Status - calibrated,final
#     Includes: CTDSAL, CTDOXY
#     CTDTMP NOTE: Used first occurrence of primary temperature sensor in original data file
#     CTDSAL NOTE: Used first occurrence of primary salinity sensor in original data
#     NOTE: Physical parameters temperature, salinity, oxygen, density, turbidity, chlorophyll, fluorescence are published on PANGAEA, DOI above.
# Fluorescence (CTDFLUOR): Who - T.Tanhua; Status -final
#        Instrument: WET Labs ECO-AFL/FL, FLNTURTD-2526
#        ScaleFactor: 1.00000000e+001
#        Dark Output: 0.0760
# Turbidity (CTDTURBDTY): Who - T.Tanhua; Status - final
#        Instrument: FLNTURTD-2526
#        ScaleFactor: 5.000000
#        Dark output Voltage: 0.070000
#
# Reference: Cruise report: https://epic.awi.de/id/eprint/49725/1/TAlPro_EUROFLEETS_cruise_report_V2.pdf
# CCHDO page: https://cchdo.ucsd.edu/cruise/29AJ20160818
# Metadata from original file
#     Event(s):     TAlPro-2016_016 (16) * LATITUDE: 42.600000 * LONGITUDE: 9.830000 * DATE/TIME: 2016-08-22T02:46:00 * CAMPAIGN: TAlPro-2016 * BASIS: Angeles Alvarino (URI: http://www.eurofleets.eu/np4/285.html) * DEVICE: CTD/Rosette (CTD-RO)
#     Citation: Tanhua, Toste (2019): Physical oceanography during MedSHIP cruise Talpro. PANGAEA, https://doi.org/10.1594/PANGAEA.902330
#     Abstract: The TAlPro cruise (Palermo - Barcelona, RV Angeles AlvariÃ±o, 18/-8/2016 - 29/08/2-16) occupied three hydrographic transects across the Tyrrhenian Sea, the western Mediterranean Sea and the Catalan Basin (Fig. 1) as part of the MedSHIP programme (Mediterranean Ship-based Hydrographic Investigations Program). A total of 43 stations were occupied during which physical (temperature, salinity, pressure, velocity), biogeochemical (oxygen, nutrients, carbonate system, dissolved Barium, oxygen and nitrogen isotopes) and anthropic (CFCs, SF6) parameters were measured in order to monitor the physical and biogeochemical state of the Mediterranean Sea.
#     Related to: Jullion, Loic (2016): TAlPro-2016: A Tyrrhenian Sea & Alger- provencal component of the MedSHIP Programme. hdl:10013/epic.5a866780-1f8a-45cf-8111-47b2b5dc29db
#     Parameter(s):
#         Event label (Event) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Sample code/label (Sample label) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Date/Time of event (Date/Time) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Latitude of event (Latitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Longitude of event (Longitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Pressure, water [dbar] (Press) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Digiquartz
#         Temperature, water [Â°C] (Temp) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: ITS-90
#         Oxygen, dissolved [ml/l] (DO) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 43
#         Turbidity (Nephelometric turbidity unit) [NTU] (Turbidity) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO
#         Fluorescence, chlorophyll [Âµg/l] (Fluores) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO-AFL/FL
#         Salinity (Sal) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Practical
#     License: Creative Commons Attribution 4.0 International (CC-BY-4.0)
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            pressure               	long_name         pressure   positive      down   units         decibar    data_min      @         data_max      @        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      X  '   pressure_QC                	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d        :h   temperature                	long_name         temperature    units         ?C (ITS-90)    data_min      @+8}H   data_max      @9lC   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       X  ?@   temperature_QC                 	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d        R   salinity               	long_name         salinity   units         PSS-78     data_min      @Cg	l   data_max      @C\L_   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      X  Wp   salinity_QC                	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d        j   oxygen                 	long_name         oxygen     units         ?mol/kg    data_min      @d_ح   data_max      @pC   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        X  o   	oxygen_QC                  	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d           CTDFLUOR               	long_name         CTDFLUOR   units         MG/M^3     data_min      3*0U2a   data_max      ?حU   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      X     CTDFLUOR_QC                	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d        (   	CTDTRBDTY                  	long_name         	CTDTRBDTY      units         NTU    data_min      ?   data_max      ?ə   C_format      %f     WHPO_Variable_Name        	CTDTRBDTY      OBS_QC_VARIABLE       CTDTRBDTY_QC     X      CTDTRBDTY_QC               	long_name         CTDTRBDTY_QC_flag      units         
woce_flags     C_format      %1d        X   time                	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      &   data_max      &   C_format      %10d        0   latitude               	long_name         latitude   units         	degrees_N      data_min      @EL   data_max      @EL   C_format      %9.4f           4   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      @#\)   data_max      @#\)   C_format      %9.4f           8   	woce_date                   	long_name         	WOCE date      units         yyyymmdd UTC   data_min      36   data_max      36   C_format      %8d         <   	woce_time                   	long_name         	WOCE time      units         hhmm UTC   data_min            data_max            C_format      %4d         @   station                	long_name         STATION    units         unspecified    C_format      %s        (  D   cast               	long_name         CAST   units         unspecified    C_format      %s        (  l@      @      @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                @9lC@9R<6@9M@9S&@9IQ@9S@9D@9m/w@9Jn@9ᰉ'@8k~(@8rGE@86z@8ߤ@@8hy=c@7eO@70C@6w1@5	@5')^@42@4@3)y@3W>6z@34Z@2A@2rW@2KJ#9@2ȴ9X@1S&@1;5X@1u%F@1uXy=@1:Q_@1@@0;dZ@0ߐ@0!R<@0Q@0p
qu@0T*0@07ݗ+@0*	 @0&IR@/cA @/䛥S@/F@/W'@/h@/9rGE8@/U2a|@.Ov_خ@.
L/@.V@.@. hۋ@.u%F@.F
L0@.i'RTa@.Yb}@.O@.E1@.8y=c@.0{@.b}V@.{m@.zH@-e+a@-H@-n@-Ϫ͞@-Ů1@-@-wkP@-X@-ݗ+@-84֡@-&IR@-A@-m\@-@-JL@-\@-C,z@-@-F
L0@-yXbM@-rnO@-qR@-o\(@-m
qv@-kQ@-hXy=@-f1.@-eڹ@-dqj@-bh	ԕ@-`ѷX@-^҈p;@-[6@-Y	k~@-T#@-QiB@-Nߤ?@-L[W?@-LI^5?@-HeO@-H@-K)^	@-K6z@-Gy@-HeO@-G_o@-C{J#9@-B}Vm@-De@-Cwk@-@ѷX@-=E@-=p
=@-<n.@-<hr@-<Q@-:^5?|@-9|@-8e+@-8*0@-7$tS@-5!.@-4SMj@-2{m@-2䎊@-2 ě@-?o@-Sg@-O͞@-H>BZc@-:^5?|@-*g	@-'8}H@-$qj@-&'@-%F
L0@-"I^5@-!o@-!o@-!e@-'&@-"@- NU@-E@-C,zx@-kP|@-YJ@-Xy=@-n.@-iB@-'_o@-.Mj@-5\(@-:S&@-@hۋq@-Be+@-@4m@-A@-9e+a@-4Ʌoi@-(p:@-C-@-C%@-fA@- [6@,$@,vȴ9X@,H˒@- 6@-#@-
fB@-v@-c	@-[W?@-	Dg8~@-@-?@-@--w1@- d8@,@,-V@,U=@,N;@,^5?|@,4֡b@,Ov_@,J@,Mj@,N;6@,;dZ@,@,S&@,F
L0@,&I@,zH@,*0U2a@,oiD@,S@,A7K@,ۘA@,#w@,֔Fs@,Ʌoi@,m@,iB@,oiDg8@,0U2a|@,s@,?@,nO@,\(@,@,@,!-w1@,1&@,(\@,K]@,
(@,ڹZ@,N;@,lC@,(@,R@,)^@,v@,U2a|@,-@, ě@,D@,v_ح@,+@,}Vl@,U=@,L_@,8}H@,}Vm@,n.@,hۋq@,~\N<@,~ ѷY@,}!.H@,{5Xy@,{s@,{s@,{W>6z@,y(@,x4֡b@,v+J@,tɅoi@,sa@O@,ra|Q@,q[W>6@,pbM@,nߤ?@,j#9@,g	k@,fA@,gRT`e@,g&@,g/V@,g@@,h	ԕ+@,hu%F@,h>BZc@,irGE@,hTɅ@,c9@,Tm8@,OiDg8@,LL_@,L1&y@,JqiC@,Hr Ĝ@,I@,NMj@,Nt@,Ks@,KQ@,K҈@,KC,z@,J0U2a|@,J͞&@,N_o @,T`d@,VFs@,WO;d@,Vaf@,V_ح@,UXy=@,R-V@,M@,JL/{@,C9@,B}Vm@,F1.@,O͞@,Sg	l@,S|@,]!.H@,`IQ@,bC,@,c,zxl@,b ѷ@,a7Kƨ@,`     @,^ߤ?@,]-V@,^%@,_|hs@,_.H@,^@,^6z@,^u@,^ ѷY@,]+j@,\N;@,[~$@,YY}@,Xe+@,XU@,Xtj@,W+@,WKƧ@,VϪ͟@,Vt@,T9XbN@,SZ@,RS&@,P`A7@,OiDg8@,N}Vl@,N!R<@,NzG@,MM:@,JfB@,JW'@,Hۋq
@,G_o@,FA@,EoiDg@,D2W@,B3@,@n@,?䎊r@,?H˒:@,=E@,=p
=@,=/w@,=[@,;q@,:,<@,:>B@,:@,9~($@,9e+a@,8@@,73@,7sPH@,7eں@,7sPH@,7KƧ@,6C-@,6ȴ9X@,6R<6@,5sh@,5Xy=@,5Xy=@,5=K@,5'0@,4Ʌoi@,4j~@,43@,3g@,3Mj@,333333@,2nO@,2n@,2n@,14J@,/Vϫ@,.H@,,q@,*D@,*n@,*Ov`@,(@,(˒:*@,'ݗ+@,%1@,%+a@,$?@,#eO@,"}Vm@,!@,!:S@, C@, -
@,˒:)@,!-w1@,\N<@,u@,,=@,b@,b@,-V@,v@,+j@,IQ@,j~#@,6@,u%@,>B@,)y@,Y}@,u%F@,0
)@,bM@,F]d@,bM@,bM@,3@,@,@,@,Ϫ͟@,ȴ9X@,l!-@,ᰉ@,fA@,*0@,*0@,*0@,'0@,'0@,E@,D@,'0@,*0@,'0@,j~@,3@,a@O@, ě@,l@,@,r@,'/W@,}Vl@,_o @,
U=@,
%@,
(@,C]@,P{@,I^@,)^	@,U=@,]cA@,
͞&@,
d7@,	ᰉ'@,@,K]c@,/V@,8}H@,/@,{J#9@,@,Zc@,@,-w1@, IQ@+	@+vȴ9X@++j@+[@+N;@+ߤ@@+m]@+W>6z@+Q_@+_o@+rGE8@+e+@+U@+#w@+rGE8@+@+~($@+@+@+PH@+Q@+eں@+R<6@+Ϫ͞@+L_@+,<@+@+m@+-@+-
q@+o @+@+r@+iDg8@+t@+Vu@+C\@+8Y@+5Xy>@+~($x@+q@+C,z@+JL@+ۋq
@+r Ĝ@+>BZc@+K]d@+lC@+&I@+1.@+8YK@+Q@+%1@+Z@+n.3@+S&@+@+Gz@+ව4m@+ߤ?@+޸Q@+ޫ6z@+ޞ@+E@+>@+u"@+?@+
(@+E@+64@+n.@+ۋq@+ۋq@+=K^@+)_@+u%F@+JE@+ؠ-
@+*0@+׀4m@+@+%F
L@+Fs@+ӎMj@+nO@+U2a|@+v@+V@+˅Q@+ ѷ@+Ǔݗ+@+)^@+tSM@+7Kƨ@+%@+/w@+6C@+}H@+R<6@+2a|@+䎊@+'/W@+xF]@+qiC@+^5?}@+\)@+u%F@+#@+&@+F
L0@+	@+4m@+!-w1@+6z@+
(@+u%@+D@+}H@+@+Ϫ͞@+$/@+*0@+m8@+E@+@N@+ ě@+䎊@+iB@+n@+u@+4J@+@+:@+/{J#@+L_@+"h	ԕ@+P{@+y@+8}H@+#9                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           @C0Q@C0:~ @C06@C0'RT`@C0-
q@C0*0@C/o@C.t@C-@C,!-w2@C*1'@C)iB@C)k~(@C)iB@C(l"h	@C#	@C)_@C1@C;dZ@CT`d@C4m@CeO@CϪ͟@C\N<@C
qu@C*0U@C$t@C
!.@C
v@C%1@Cg	l@Cs@Cȴ9X@C'@CT@C
=p@C@Cvȴ9@C@C	k@CRT`e@C˒:*@C>BZc@C*0@CNU@C#w@C)y@C(@C$tT@CDg8~@CrGE8@Cu@C@COv`@Cp:@CsP@CA@C1&@Cڹ@Caf@C,<@C}Vl@C}Vl@CE84@C|hs@CF]d@C@@C4J@C	k@C4֡b@CC@CrGE@CDg8~@CB@CM@CsP@Cg	l@Ca@O@Cs@Cm8@C1&@Cp
=@CBZc @CkP@C )@C!Y}@C"`A@C"m@C#Z@C%F
L0@C&]cf@C(
qu@C)@C*0U2a|@C+Mj@C,j~#@C-Q@C..2@C.+@C/>6z@C06@C1R@C2kP|@C3s@C4<쿱@C4u"@C58Y@C6]cf@C7r@C8˒:*@C9=b@C9X@C9e@C:>B@C;$@C<?@C=L_@C=@C>u@C>Mj@C?@@C@'RT@CA7KƧ@CAe+a@CA@CB~@CC~($@CD?@CDD@CE=K@CE!.@CFc	@CH*0U@CJ@CJ#9@CJ	 @CIx@CH$tT@CIx@CI@CJL_@CK@N@CKeO@CK҈@CLI^5?@CL7@CM(@CN$/@CN?@CNiB@CNvȴ9X@CN@CNߤ?@CN+@CO$tS@CO;dZ@CPn@CQ$/@CQ7Kƨ@CQ>BZ@CRd7@CRg	@CRsP@CSnP@CR͞&@CR@CR-V@CQ[W>6@CPěT@CP@CPl"h	@CP@@CQA [@CQGz@CQN;6@CRm\@CSjf@CT2W@CTN;@CUqu"@CUL_@CU?|h@CU5Xy>@CUF
L0@CUm\@CUw1@CUzxl"h@CUO
@CU(@CV@CV
L/@CV
L/@CV_o @CV
L/@CV
(@CV4K@CUC\@CU8YK@CVzG@CV+J@CV}Vl@CVm\@CVMj@CW.H@CW!-w1@CWFt@CW hۋ@CWFt@CW
M;@CW
=p@CW
M;@CW
=p@CW
=p@CVFs@CV]cf@CV2X@CVs@CVR<6@CVOv_@CUE@CU(@CU!.@CV
L/@CVVu@CV%@CVIQ@CVvȴ9X@CVvȴ9X@CVs@CV;5X@CV1.@CV.2@CV@CV]cf@CWXe@CW_o@CWiDg8@CWiDg8@CWlC@CWsPH@CW4m@CWlC@CWKƧ@CW;dZ@CW>6z@CWRT`e@CWeں@CWiDg8@CWeں@CWlC@CWv_ح@CW4m@CW4m@CW	@CWsPH@CWb}V@CWO
M@CWE84@CW1@CW'/W@CW)^@CV쿱[W@CVx@CVMj@CV"@CW
=p@CW,@CW!-w1@CW+I@CW>6z@CWE84@CW\(@CWb}V@CW>6z@CVQ@CVvȴ9X@CVOv_خ@CVH@CV.2@CV!R<@CVH@CW hۋ@CW;dZ@CW'/W@CW'/W@CWO
M@CWb}V@CWv_ح@CW$tS@CW-@CX@CX{@CYTɅo@CYhr @CYk~(@CYk~(@CYGz@CY:S@CY@CXۋq
@CXD@CY=b@CZe+@CZ^5?|@CZqiC@C[a@N@C[S@C[|@C[
=p@C[ݗ+k@C[a@@C[5Xy@C[@C[Z@C[
=p@C\n.@C\xF@C\1&y@C\ߤ@@C\xF@C\L_@C\L_@C\@C\1&y@C\J@C\n.@C[\N@C[\N@C[@C[@C[$@C[A [@C[g@C[%2@C[ݗ+k@C[Q@C[|@C[5Xy@C[@C[@C[Ƨ@C[Z@C[Z@C[@C[q@C[S@C[wk@C[ߤ@C[:)z@C[eO@C[eO@C[@C[~$@C[{J#9@C[{J#9@C[tj~@C[n.3@C[g	l@C[g	l@C[a@N@C[]cA@C[]cA@C[Z@C[S@C[P{@C[P{@C[P{@C[P{@C[MjO@C[MjO@C[F]c@C[C%@C[C%@C[C%@C[@N@C[=K^@C[=K^@C[9@C[=K^@C[@N@C[=K^@C[=K^@C[9@C[9@C[6z@C[/V@C[/V@C[/V@C[,zxl@C[33333@C[33333@C[33333@C[33333@C[/V@C[)^	@C[/V@C[33333@C[6z@C[6z@C[9@C[/V@C[/V@C[/V@C[,zxl@C[)^	@C["`B@C["`B@C[	@C["`B@C["`B@C["`B@C["`B@C[	@C[	@C[	@C[	@C["`B@C[	@C[	@C[	@C["`B@C[	@C[	@C["`B@C[&@C["`B@C[	@C[	@C[C,z@C[C,z@C[C,z@C[C,z@C[PH@C[s@C['/@C['/@C['/@C['/@C[҉@C[҉@C['/@C[҉@C[҉@C[҉@C[҉@C[҉@C['/@C['/@C['/@C['/@C[nP@C['/@C['/@C[nP@C['/@C['/@C[҉@C[҉@C[҉@C[u%@C[S&@C[҉@C[PH@C[)^	@C[33333@C[6z@C[33333@C[/V@C[,zxl@C[,zxl@C[,zxl@C[)^	@C['/@C[u%@C[S&@C[I^@C[I^@CZm\@CZ~@CZD@CZD@CZC,@CZC,@CZfB@CZG{@CZ ѷ@CZڹY@CZsP@CZ,<@CZ͞&@CZ)_@CZ@CZsP@CZ ѷ@CZ䎊q@CZC,@CZc	@CZm@CZc	@CZfB@CZ䎊q@CZڹY@CZڹY@CZ͞&@CZ)_@CZn@CZ}Vm@CZg	@CZL/{@CZS&@CZvȴ@CZvȴ@CZwkQ@CZ0
@CZS&@CZS&@CZ\(@CZL_@CZݘ@CZ~"@CZxl"h
@CZnO@CZd7@CZd7@CZ^5?|@CZW'@CZT`d@CZM@CZGE85@CZGE85@CZ=p
@CZ6C@CZ3@CZ0U2a|@CZ)y@CZ1'@CZe+@CZs@CZ	 @CZu%F@CZu%F@CY.H@CY-@CY@CYR@CYe@CY@CYR@CYiB@CY@CYN;6@CYԕ*@CY_o@CYo@CYD@CY^5?}@CY'R@CYl@CY'RTa@CY@CY@CYx@CYo hی@CYe+a@CYGz@CY4J@CY_p@CY$/@CX@CXD@CXp:@CXU@CX@CXl"h	@CXXy=@CX:~ @CX$xG@CX	ԕ+@CW#@CWfA@CW[W>@CW	@CWv_ح@CWlC@CWb}V@CW_o@CWU=@CWKƧ@CW1@CWXe@CW hۋ@CV쿱[W@CVC-@CV]cf@CVQ@CVT@CV@CVz@CVl!-@CVc	@CV\N<@CVOv_خ@CVE@CV?@CV8YJ@CV+jg@CV($x@CV$/@CV!R<@CVzG@CV ѷY@CU
qv@CUϪ͞@CUcA @CU8Y@CUn/@CUU=@CU}H@CUU=                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           @iK]c@i,<@i_ح@iC,@ixF@i)^@iu@j"Ov_خ@jd{@jx䎊@j($x@j	@jƿ[W?@k?˒:)@k&x@lqu"@mw1@n{o@ncA [@oQ@oBZc @oS&@oq͞@ooW>6z@oz)_@oF
L0@o0
@oo2W@oԕ*@phۋq@pC@oC,@o;dZ@ou"@o)^	@o	k@ogeO@o^4֡b@olvȴ@oLwkP@o^VϪ@oiO
M@ope+@oa@O@oKƧ@ov@o	ԕ+@o
=p@oR	ԕ+@o0YJ@o-q@o<҈p@oTg8}@o!.I@o1M:@nϪ͞@nvȴ@nL/{@naf@n$@nH˒:@nVu@ns@nrl"h	@nn3@nc$/@n6y=c@n(ݘ@n;oiDg@nIK]d@n2 ě@nj~#@moiDg8@m%1@m,@m 1.@lփ%@l.H@m͞&@lqi@l\N<@l-@k[6@kf
L/@k!,=@j@jg	l@j}Vl@j_@jڹ@j`r Ĝ@j5RT`e@jߤ?@i'@i"`@iO;dZ@i.H@ib}V@ivU@ielD@iH@i/zH@iC@hڹ@hs@hZc@h҈p;@hfA@h	k@h4֡b@hQ@hA [@hӥS@h:)y@h_o@h@hU=@h9Xb@hz$t@hzxl"h@hrGE8@hzy=c@hVu@hvD*@hh[6@hhPH@hkrGE@h_(@hM8YK@h=#w@h2F]d@h/8}H@hZc@h+jg@hE@h!@N@h$t@h?@h?@h)y@g+@g
M;@g쿱[W@gwkP@gd7@g@g.2@gԛS@gͦ(@gjOv@g
(@gE@gIQ@g}Vl@gTɅ@gN;5@gJM@g[W>@gxl"h
@gwxF]@go!.H@gN;@g{-V@gv
(@g҉@gxA@gۋq
@gXy=@gϪ͟@gϪ͟@g@gK]c@go h@gIQ@g#@gbvȴ9X@gEJ#9@gB~($x@g>Ov_خ@g7XbM@g7S@gA
M;@gC@g3&@g3"`B@g0Zc@g7KƧ@g:4K@g5%2@g-q@g4|@g-7Kƨ@gOv`@g?@g0M:@g"h	ԕ@g [7@g'䎊r@g. ѷ@g@g
ߤ?@g@g
Q@g1@g䎊q@gp:~@gl!-@g]ce@f"`@g>BZ@g+@g4K@f@g D@g C@g[W>@gɅoi@g@g-TɅo@g$PH@g"3@g"1.@g@g䎊@g1@ftj~@g
-
@g`A7@g4m@g}Vm@ge+@fB@fO
M@f"h	ԕ@fu!@f+I@fqu!@fշr@fS@f}Vm@fъڹZ@f+@f$/@fiB@fݗ+@fW@f)^@fܞ@fVu@fy@fϪ͟@fQ@fη4m@f҉@fε?@f@f@f_o@flD@f&IR@f^@fβ@f1&x@fÓݗ+@fw1@f*0U@fo i@f>B[@f@flC@f,=@fÑhr!@fɅoi@f{@fQ_@fiB@f"@f$tS@f]ce@fs@f1@f=K^@fE@f@@f~($@f?@f@fRT`e@f'@fn7@fUD@fC[W>@f#@f D@f>!-w2@f7,zxl@f1-V@f08YJ@f-o@f,
L/@f#3@f|@f]ce@es@e+@en@e"h	ԕ@e>6z@eơaf@e͓@eYJ@e-
q@e-
q@eu%F@e@e,zxl@e8YK@eH@erGE8@e9XbN@eߤ@@eC,z@eƧ@e@eSMj@eu%F@exF@e?@e?@eA@e@e
L/@e;dZ@e*0@eXe@eOv_خ@e-V@exl"h
@eM@e\(@ej~#@eL_@e>BZc@e=p
@e<쿱@e}Vl@e{:)z@efj~@ei@e,@eIQ@e@epqiC@elGE85@ebqj@e] hۋ@efQ@ewae@ez(\@eo@eeS@e\m\@ei}H@eXZ@e\E@eo҉@e\E@ehe+@et0
@elC\@elC\@ef?@e^`d@e\PH@ebqi@eeQ@em(@ei|Q@eIڹZ@eM3@e_\(@eZ4m9@eTzxl"@ebp:@e^^5?|@e_D@ePz@e:@4n@e;wk@e4 ě@e/!.H@e8>B[@e6@e6@e8+@e*!-w@e!-w2@eH@e"IQ@e)Mj@eqiC@e͞@e&)_@e-r@e*D@e&?@ea@@ep:~@ee+@ep:~@e(($x@e&ěT@e%a@N@eoiDg8@e҉@e&@e?@e
=p@e(@eC]@e	+j@e
PH@e@eO;dZ@ep:@eVϫ@e
@e^5?|@eO
M@e@e/@e/@e@e@e
D@e@N@ep:@e\N<@e#w@e]cf@eN;5@ejf@dݗ@e1.@ep:@d?@e[6@eᰉ@e	ݗ+@e@et@e
Z@dحV@dJL@e쿱[@e
!-w@e;dZ@d@e	o@eȴ9X@edZ@e	Mj@e
m@e8YJ@e@e
r@eb}V@e	~($@e҈@e	q@eu%F@e'RT`@e@dN;6@d|Q@d_ح@d9Xb@d|@dv@dO;dZ@dK]@dkP|@d_o@e1@e*1@e*1@eFs@eFs@e0
)@d?@dᰉ@dڹY@eQ@eg	l@e
1@e	M:@e ě@eY|@eu%F
@efA@e/V@e;dZ@ee+a@e;dZ@e
`A7@erGE@e@edZ@e     @e
Z@e+I@es@e)_@eD@eS@e?@eԕ*@e*0U2a@e@e%E84@e7KƧ@ea@@e6z@e
G{@e6@eu%F@e"|@esh@ee+@e@e5Xy>@eQ_@e%B@e#iB@e_o@e
҈p@e4J@e%1@eeO@eOv_خ@e!+@e&T@e*p:@e#?@e(_o @e*p:@e&T@e*p:@e(_o @e#?@eNU@eNU@eC,@e%?|h@e,1&x@eJM@e#@e)iDg8@e*@ex@ex@e
ۋq
@e0
)@e
(@e!R<@e
(@e ě@e>BZ@e
'RTa@e䎊@e.H@elC@dhr!@e
%@e+a@eK]d@eqj@eqj@e@eƧ@e73@e%6z@e!҉@eE@eu"@e&0
@e2W@e&@e.hr@e0Q_@e*&I@e҈p@e(@e*TɅ@e-eO@e&@e)\@e"kP|@eOv`@eR@e"kP|@e#+@e1[W>@e4xl"h
@e'-@e?@e!Ft@eO
M@e"j~#@e&ᰊ@eO
M@ex@ex@e,"h	ԕ@e?@e	k@e{@e"iB@e-oiD                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           ?+j?Xe+?_o?Vl!-?4J?ȴ9Xb?d7?m\?m\???sPH?u%F
???5?|h?Ov_خ?+?E?	k~(?PH?IQ?ߤ??d7?6?tj?A [7?,<?<64?>B?	k~?$tT?)^	?9XbM?~($x?-?Ov_خ?\(?e+?>B[?/v?J#9?Y|?˒:)?'/W?~$t?	k~?Z1'?`d8?Ę_F?g	?Ø@?{J#9?åS?ŵsg?E?䎊?:~?ȓtj~?PH?'/V?䎊qj?s?Ρae?ͼn.?.H?oiDg8?bM?Ж??Е*0?K]d?8YK?ӟU=?/{J#:?C,zxl?v_ح?)^??ج1&y?tj?\(?ف$/??qu!?{J#9?حU?e+?,<?쿱[W????ߤ??ۀ4m9?ؼj~#?u%F?-
?֌L_?"`A?p
=q?Xy=c??RT`d?ڹZ?:S?n?.2X?M:???+?VϪ͟?C\?π4m9?7KƧ?n?ɳ|?+I^?!-w2?+a@?Ɛ$tT?
qu?fA?z?qu!?öE?R<6?vȴ9X?7KƧ?H˒:?rGE?Xe,?|Q?M:?vȴ9X?N;6?D*?A [?H˒:*?حU? [6?6z?/Vϫ?j~"?#wk?o?*0?:)y?*0U2a?C,zxl?l!-w?R<64?u?ᰉ'?n?bM?-
qv?$tS?䎊r?L_?ᰉ'?䎊q?_Ft?$?(\)?sPH?{u%FS*0U2a?L_?Zݘ?xtj~o䎊q?}Z?vȴ9?bM??-
qv?䎊q?v+I?V?%2?Z?|??o䎊q?tzG{?nO;?}}H˒?~Ov_ح]}H˒?z6C-?zvȴ9?~Q?Xe?E˿@bM?rnO;?$tS?PHPbMw_!-w1?}Z?eL_vǿdzG{?N;5?Zݘ?)^	?a@N?ɅoiD?tZ?wXe+?,<?sPHfOv_خ?ݗ+j?IQ?vȴ9?u!?s@NU?vOv_خ?pbM?6C-?T`d?n?҈οFǿp)^	?q4J?},<?y_o ?y_o Xtj~?Xtj~?Q_?}H˒?-
qv?z6C-?ᰉ'?hr Ĝ?䎊q?rnO;eL_?{qu!S?:)ya4J?Ov_ح?*0?p:?E?`bM?c*0U2a?|1&y?l1&y_!-w1?usg?_Ft?_o?w?v?rsPH?~Q?},<?߿kQ_rn/?tzG{??qu!S?䎊q?}Z?~Q?},<?@bM?bn/?}}H˒?z6C-?*0?:)y?	 ?*0?ZݘJ6C-?䎊r?n/?n/?S&?L_?R<64?u"?bM?}Z?0
(?{?_Ft?Xe?s@NUfOv_خ?|C,zxl?䎊q?|1&y?xtj~?}}H˒ku%Fzvȴ9uL_?f?U=K?*0
?{?1&?>6z?$tSM?IQ?[Q_`bM?z6C-nOv_ح?vOv_خ?tnj6C-?tzG{m}H˒?PbMl1&y?f?T`d?A?@bM?kQ_?},<?]}H˒?F?zvȴ9?}Z?{qu!S?C*0U2am}H˒:6C-?}Z?{u%F?N;5?<64?}}H˒?uL_o!-w1?v+I?~Q?xtj~c*0U2a?usg?1&?usg?nOv_ح?UL_?u"?1&y?]}H˒?wXe+?Ov_ح?:)y?ݗ+j?N;5Xp)^	?Q?ɅoiD?sPH?wkP?N;5?u%F
?ae?ᰉ'?䎊q?sg?=K]?z6C-?{Q_?u"?ku%F?bn/?T`d??w?!-w1?,<쿱?,<쿱Xtj~?{?nOv_ح?+I?u%F
?!-w1?!-w1?U=K?}Z?bn/?~Q?	 ?)^	?|C,zxl?)^	?$tS?wx*0
tzG{wXe+ԿnOv_ح?䎊r?_Ft?nO;?bM?x*0
rsPH?3*0U2a?j6C-pbM?v?ᰉ'?=K^?&?{qu!S]}H˒?@NU?`d8c*0U2aj6C-?ye+a?<64?L_?*0?=K^?zG{?@NU?3*0U2a?Xe+?,<쿱?*0
?@?{u%F?{Q_?4J?a@N?zvȴ9kQ_?[Q_?bM?+I?xPHa4Jxtj~s*0U2a?䎊q?bM?ݗ+j?sPH?(\)?n/?|1&y?ye+a?ye+a?~Q?hr Ĝ?{Q_?N;53*0U2a?usg?|C,zxl?}}H˒?hr Ĝ?~Ov_ح?	 ?Xe+?_!-w1?+I?N;5?Fs?&?UL_?+j?E?Xtj~?bn/?4J?$/?=K]?_!-w1ſqu"s*0U2a{qu!Sq4J?@NU?4Jp)^	p)^	?kQ_?|C,zxl?xtj~pbMvOv_خ?kQ_?䎊q?O
M?Z?+jg?`A7L?ᰉ'?{qu!S?$tS?Xtj~p)^	?ie+a?{qu!S?bM?A?u%F?V?wXe+?uL_?!-w1ſZ6C-?u!?vȴ9?}Zq4JvOv_خ?:6C-?qu"?dzG{?*0
?bn/?Xe?v?x*0
?x*0
?wXe+Կo䎊q޿rn/?w?IQ?&?Z?qu!S?{u%F?qu!S?$tSM?C*0U2a?!-w1?䎊r?sPH?+Is@NU?*0
?=K]?|1&yS*0U2a?xPHpbMtn?*0U2a?*6C-?s@NU?f?*0U2?`d8?`d8?N;5X?dzG{?*6C-?C,zxl{qu!S?@NU?n/?~Q?*0?E?sg?҈?tZ?tj~?zG{?sg?JD?ᰉ'?sg?{Q_?bMrsPH?V?Q_?ݗ+j?R<64?wkP@bM?[Q_?l1&y?V?qu!S?`A7L?nO;j6C-?]}H˒?|C,zxl?{?j6C-?S?u"?Z?1&?	 ?ye+a?-
qv?N;5?{Q_?~Ov_ح?,<?L_?p)^	?+?*0?q4J?쿱[W?kQ_                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           ??????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????ə?????ə?ə?ə????ə?ə???ə?ə??ə?ə?ə?ə?ə?ə?ə?ə?ə????ə??ə?ə?ə?ə??ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?????????????????????????????????????????????????????????????????ə??????????????????????????????????????????????????????????????????????ə?ə??ə????????ə???????ə?ə?ə                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           &B*ffAG36 16                                      1                                       