CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20120522   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P9     CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:47.975586Z    ORIGINAL_HEADER      sCTD,20250210CCHSIOWB
#Renamed 'CTDFLUOR_TSG' to 'CTDFLUOR_ALT_1' with units 'MG/M^3'
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2018-11-29. CTD data from cruise 18DD20120522, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20120522. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2012-12/index.php. 
#
# The information in this file for the cruise 2012-12 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-0072.ctd
#
# Start of originator file comment header
#
#*2018/11/29 14:22:51.16
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2012/06/01 08:02:46.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 2006
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : C44EDC1F
#    NUMBER OF CHANNELS  : 9
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            2.3            2006.7
#       2 Temperature:CTD               deg_C_(ITS90)   1.9166         6.6907
#       3 Salinity:CTD                  PSS-78          32.6639        34.5892
#       4 Sigma-t:CTD                   kg/m^3          25.6458        27.6748
#       5 Transmissivity:CTD            %/m             61.4           67.9
#       6 Oxygen:Dissolved:CTD:Volume   ml/l            0.41           7.23
#       7 Oxygen:Dissolved:CTD:Mass     µmol/kg         17.9           314.7
#       8 Fluorescence:CTD:Seapoint     mg/m^3          0.24E-01       0.74
#       9 Fluorescence:CTD:Wetlabs      mg/m^3          0.102          1.096
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        6  F       ' '     1
#       6  -99   ' '        7  F       ' '     2
#       7  -99   ' '        6  F       ' '     1
#       8  -99   ' '        8  F       ' '     3
#       9  -99   ' '        8  F       ' '     3
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2012-12
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P24
#    EVENT NUMBER        : 72
#    LATITUDE            :  49  50.17000 N  ! (deg min)
#    LONGITUDE           : 142  40.04000 W  ! (deg min)
#    WATER DEPTH         : 3989
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    CTDEDIT was used to remove surface records and records corrupted by shed
#	wakes; salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Transmissivity, Fluorescence and PAR data are nominal and unedited except
#	that some records were removed in editing temperature and salinity.
#
#    For details on how the transmissivity calibration parameters were calculated
#	see the document Transmissivity_Calculation.pdf.
#
#    The Oxygen:Dissolved:CTD calibration was done using the method described in 
#	the Sea-Bird Application Note #64-2 (Sea-Bird_64-2_Jun2012.pdf).
#
#    The Oxygen:Dissolved:CTD data are considered, roughly, to be:
#	±0.1 ml/l from 0 to 125 dbar.
#	±0.06 ml/l from 125 to 500 dbar.
#	±0.04 ml/l from 500 to 2000 dbar.
#	±0.02 ml/l below 2000 dbar.
#
#    For details on the processing see processing report: 2012-12-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5-- --6--- --7-- ---8--- ---9---
#!Pressu Temperat Salinity Sigma-t: Trans Oxygen Oxyge Fluores Fluores
#!re:CTD ure:CTD  :CTD     CTD      missi :Disso n:Dis cence:  cence: 
#!                                  vity: lved:  solve CTD:    CTD:   
#!                                  CTD   CTD:   d:CTD Seapoin Wetlabs
#!                                        Volume :Mass t              
#!------ -------- -------- -------- ----- ------ ----- ------- -------
#*END OF HEADER
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @8         data_max      @8         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     >p  .    pressure                	long_name         pressure   positive      down   units         decibar    data_min      @ffffff   data_max      @X        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      >p  l   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d            temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?`A7   data_max      @%   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       >p     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d           salinity                	long_name         salinity   units         PSS-78     data_min      @?   data_max      @ALL_   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      >p    salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d       G   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @#ffffff   data_max      @sd   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        >p V   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d       $   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?"`B   data_max      @1r ě   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      >p    CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d       0   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       >p    PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d       1<   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min      @AL   data_max      @P   C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     >p @   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d       H   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         (    cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         (    time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min         data_max         C_format      %10d       4   latitude               	long_name         latitude   units         	degrees_N      data_min      @Hmhr!   data_max      @Hmhr!   C_format      %9.4f          8   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      `%Y_a   data_max      `%Y_a   C_format      %9.4f          <   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d        @   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min        R   data_max        R   C_format      %4d        D@8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @8      @ffffff@      @      @      @       @"      @$      @&      @(      @*      @,      @.      @0      @0fffff@2@3      @4      @5333333@6      @7      @8      @8fffff@:      @;      @<      @=      @>      @?      @@      @@s33333@A      @A     @B      @B@B33333@C     @D      @D     @E      @E@F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @Pfffff@P9@P     @P     @Q      @QFfffff@Qfffff@Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @Tfffff@T@U      @U@     @U     @U     @V      @V@     @V     @V     @W      @WFfffff@W     @W     @X      @X@     @X     @X     @Y      @Y@     @Yfffff@Yfffff@Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a33333@a@a@     @a`     @a     @a33333@a@a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e@e@     @e`     @e     @e33333@e@e     @f      @f      @fC33333@f\@f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @kC33333@k\@k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o33333@o@o@     @o`     @o     @o     @o     @o     @p@p     @p      @p0     @p@     @pP     @p`     @pnfffff@p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q^fffff@qp     @q     @q@q     @q     @q     @q     @q     @q     @r      @r     @r@r1@r@     @rP     @r`     @rp     @r@rfffff@r     @r     @r     @r     @r     @r     @s@sfffff@s      @s0     @s@     @sP     @s`     @sp     @s@s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @ta@tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u@ufffff@u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @ufffff@v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @vfffff@v     @v     @w      @w@w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x@x@x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @yfffff@y     @y     @y     @y     @y@z@z      @z.fffff@z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{&fffff@{0     @{@     @{P     @{`     @{p     @{@{     @{fffff@{     @{     @{     @{     @{񙙙@{fffff@|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|љ@|fffff@|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}@}fffff@}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~@~@~     @~     @~     @~     @      @     @      @.fffff@@     @P     @`     @p     @     @@     @     @     @     @     @fffff@@     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @33333@     @     @     @     @     @     @     @     @     @     @     @     @     @@33333@      @     @     @@33333@(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @@      @(     @0     @8     @@     @H     @O33333@[33333@`     @h     @p     @x     @~fffff@33333@     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @@33333@     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @@33333@      @     @@     @      @(     @0     @8     @@     @H     @P     @X@_33333@h     @p     @x     @     @33333@33333@33333@     @     @     @@     @     @     @     @     @     @     @@33333@     @     @     @      @(     @.fffff@8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @@33333@      @(     @0     @8     @@     @H@P     @X     @`     @h     @p     @y@     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @fffff@@     @     @     @     @     @     @     @     @     @33333@      @     @     @@33333@(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @33333@     @@     @     @     @     @     @     @     @     @     @     @33333@     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X@`     @h     @p     @x     @     @@     @     @     @     @     @     @     @@     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @O33333@X     @`     @h     @p     @x@33333@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @@33333@      @(     @0     @8     @@     @H@O33333@X     @`     @h     @p     @x@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @ @%@0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @@     @     @     @     @@     @     @     @     @      @fffff@     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @      @33333@33333@     @      @(     @0     @8@@     @H     @P     @X     @`     @h     @p@x@     @     @     @     @     @@@     @     @     @     @@     @@     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X@`     @h     @p     @x     @     @     @@33333@     @     @     @     @     @     @33333@     @     @     @     @@      @     @     @     @     @     @     @fffff@@$     @(     @,     @0     @4fffff@6fffff@<fffff@@     @D     @H     @K33333@P     @U@X     @\     @`     @d     @h     @lfffff@o@t     @x     @|     @     @     @@     @     @     @     @33333@33333@@     @     @     @fffff@     @     @     @     @fffff@˙@     @     @fffff@ۙ@     @     @     @뙙@@     @     @     @      @     @     @     @     @     @@     @      @$     @(fffff@,     @/@4     @8     @<     @@     @D     @H@K@P     @T     @X     @\     @`fffff@dfffff@h     @l     @p     @t     @x     @|     @     @     @     @     @     @fffff@@     @     @     @     @     @     @@     @     @     @     @@     @     @     @     @     @     @@     @     @     @     @     @     @@@     @     @     @@     @     @      @$     @(     @,     @/@4     @8     @<     @@     @D     @G@L     @P     @T     @Xfffff@\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @@     @     @     @     @     @@     @     @     @     @     @     @     @fffff@˙@     @     @     @@fffff@     @     @     @33333@     @     @     @      @     @     @@     @     @     @     @      @$     @(     @,     @0     @4     @8     @;@@     @D     @H     @Lfffff@Pfffff@T     @X     @\     @`     @dfffff@g@l     @p     @t     @x     @}@     @     @     @     @     @     @fffff@@     @     @     @@@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @@     @     @      @$     @(fffff@,@0     @4     @8     @<     @@     @D     @H     @J@P     @T     @X     @\     @`     @d     @h     @k@pfffff@t     @x     @|     @     @33333@33333@     @     @     @     @@     @     @33333@@     @     @     @     @     @     @     @     @     @fffff@י@     @     @     @     @@     @     @     @     @ fffff@     @     @     @     @     @     @fffff@      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @W33333@[@`     @d     @h     @l     @p     @s@x@|     @     @     @     @fffff@@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @י@     @     @     @     @     @     @     @     @     @      @     @     @fffff@@     @     @     @      @#@(     @,     @0     @3@933333@<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @u33333@x     @|     @     @     @fffff@     @     @     @     @     @     @     @     @     @     @     @fffff@@     @     @     @     @     @@fffff@     @     @     @     @     @     @33333@     @     @      @     @fffff@
fffff@fffff@     @     @     @      @$     @(     @*fffff@0     @4     @8     @<     @@     @Dfffff@G@L     @P     @T     @X     @\     @`fffff@c@h     @l     @pfffff@t     @x     @|     @     @     @fffff@@     @     @     @     @33333@     @     @     @     @     @fffff@fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @fffff@     @     @     @33333@fffff@      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @S@X     @\     @`     @d     @h     @l     @nfffff@t@x     @|     @     @fffff@fffff@@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @33333@fffff@      @     @     @     @     @     @33333@fffff@      @$     @(     @,     @0     @4     @8     @:@@     @D     @H     @L     @P     @S@Y33333@\     @`     @d     @h     @l     @o33333@u33333@x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @fffff@ә@     @     @     @     @     @     @@@     @     @      @fffff@33333@     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x@|     @     @     @     @fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @㙙@癙@     @     @     @     @     @      @fffff@	33333@     @     @     @     @@      @$     @(     @,     @0     @4     @8     @<     @@     @Dfffff@H     @L     @P     @Tfffff@X     @\     @`     @d     @g@l     @p     @t     @x     @|     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @33333@@     @      @$     @(fffff@0@4     @8     @<     @?33333@F     @H     @L     @P     @T     @X     @\     @_@d@h     @l     @p     @t     @xfffff@}@     @     @     @     @     @     @fffff@@     @     @     @33333@@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@@      @     @     @@     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @ϙ@     @     @     @     @     @     @뙙@     @     @     @      @fffff@@     @     @     @     @     @      @$     @(     @+@0     @4     @8     @<fffff@>@D@H     @L     @P     @T     @W@\@`     @d     @h     @l     @n@tfffff@x     @|     @     @     @     @33333@fffff@     @     @     @     @     @     @fffff@@     @     @     @     @fffff@Ǚ@     @     @     @     @     @     @     @癙@     @     @     @fffff@@      @     @     @     @     @     @     @     @      @$     @&fffff@,fffff@0     @4     @8     @<     @>@Dfffff@H     @L     @P     @T     @X                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @%@%m]@%^5?|@%$tS@%z@%1@%C-@%@%O;d@%@%Q@%_F@%U@%4֡b@%e+@%PH@%YJ@%l"h	@%~($@%@% ѷY@%=K^@%A [@%#9@%L/{J@%$?@$*ڹY@#̿[W?@#^ߤ?@"&@"n/@"s҉@"V8YJ@"8Q@"$?@"
n@![6@!\@!7+j@!4m@!8}H@ PH@ <64@ oiDg@ {m@ %2@ w@ o4֡a@ ao@ K:)z@ @'RT`@ /r@ 'y@  	k@ u@ G{@ }Vl@ ?|h@ Z@ |@ ͞@ *0U@ 
(@ o@ o @ 
D@ 	B@ 7Kƨ@Ov_خ@:)y@$/@hۋq@KƧ@|@+6z@حV@4֡a@@     @ix@GzH@l!-@
(@@N@;5X@ɺ^5?}@A [@@w+@v4K@-hr!@֡a@PH@{m@GE85@g@F@?@o@o hی@^%@f'@yXbM@@@'/W@@(@A7K@tj~@$tS@sP@.H@-w1@"wkQ@W&@TɅo@gfA@TZ@?@0oiDg8@	@@L_@'/W@	@9Xb@N;5@*0@F]c@唯O
@[6@حU@4J@1&x@($x@!R@C,z@e@C,zx@@7KƧ@Q@zS&@q2W@k6z@bC,@[q@S@C@9D@1@*d7@e+@JM@YJ@?@!R@9XbN@8Y@1.@ݗ+k@s@{J#9@Õ$@I^5@-
@P{@3@҈p;@}H@u%F@g8}@~6z@mC\@`A7K@\]ce@N!R<@An.@8Q@3g	l@Q@C%@s@@!-w1@xF]@Ƨ@I^5?@xF]@@E@JL@(\@@L_@Ʌoi@a@O@T`d@)^@#9@~BZc @tj~@jOv`@Np:~@'&@s@v@쿱[W@8YJ@̘_@A@'R@IQ@y(@],=@Jn@>BZc @%`A7L@"`A@c	@
n@
ڹY@g8}@dZ@@#@lD@*1@cwk@DS@/v@%O
@N;@(\@cA \@hr@j~@]ce@ϐ@(@7KƧ@š@o hی@+@U=@
qv@ hۋ@Ov`@?@vC-@_حV@VOv_@G)^@7+@+U=@!o@حV@*0@*0@:)y@	k~(@nP@u%F
@($x@@@͞%@ǮzH@ڹZ@wk@)^@ݗ@ [7@tj@Q@K]d@@p:~ @^҈p;@^Ov_خ@[Q@Y@VR<6@F?@BZc@QN;6@VR<6@a@N@_Ft@Zvȴ@S*0U2@8F@3E@0@/4֡a@-
qv@-hr!@,>B[@,q@˒:*@?@JE@af@˒:)@C-@Xy=@
M;@=p
@u%F
@G{@'RT`@9Xb@y~($@d/@Z,<@J#9@<n.@/r@%@I^5?@\N<@YJ@+@j~@PH@iDg8@d7@zxl"h@JE@L_@C@Y}@Xe@a|Q@U2a|@C\@@qiC@|PH@qo@jd7@cwk@[$@XbM@TɅoi@P)^@Hp:@F@B@4n@@NU@@6@?H˒:@B\(@MjOv@]ce@h	ԕ+@p
(@n2X@`'RT`@6!.I@.1@(>BZc@`A7@ ѷX@_ح@@C,@]cf@K]d@!R<@]cA@W'@ˬq@Ƨ-@8YK@JM@84֡@ ѷ@.H@ ѷY@C]@_ح@y@Q@ȴ9Xb@M:@H˒@5Xy@dZ@D@ hۋ@$xG@fffff@wk@cA @[@PH@sh@5?|@5?|@o @I^5?@ ѷ@Fs@oiDg@?@g8}@g8}@ ѷ@a@N@F]c@g8}@]cf@=p
@vȴ@K]c@S&@Y@wkP@[6@?@҈p;@ ѷY@JE@&@6C@+@=K@JE@vȴ@R<6@Z@@N@X@;dZ@O;dZ@@{m]@[W>@n@|?@s@kjf@g/V@`'RT`@WsPH@G_o@2{m@"C,@l@!R<@ [7@m]@4K@g	l@A [@RT`e@-w1@U@tj~@`A7@@n@:)y@O;d@+J@Xe,@@@vFs@r ě@l<쿱@h@cwk@_䎊r@Xy=c@K)^	@Ks@]IQ@W@JڹY@D2W@?|hs@.t@%@y=c@*1@*0U2@`A7@\(@?@y@?@zG@
M;@YJ@64@	ԕ+@-V@@PH@
qu@#w@ěT@_p@@
5Xy>@@	 ѷ@t@[@Ov_خ@C,zx@e+a@&@+@@b}V@&x@O
M@@Vϫ@@N@p:~@̲@ʌL_@˒:)@b@䎊q@1.@L_@Y0
)@En/@IQ@I@N+@NMj@XD*@Zݘ@_?@U2a|@P`A7@N;5X@NT@L@H@4#@3g@:C\@5!R@-\@kP|@t@X@Fs@tj@{J#9@@Vl!@o@思IQ@u"@~($x@Õ$@Z@1&y@%@6C@@bM@T`d@*0U@҈@M:@y~($@~"@y#w@ov@eS@WsPH@Gy@Eݗ@U2a|@bC,@dTɆ@iy@i@jOv`@iB@be+@S*0U2@G@@<쿱[@L@En/@0
=q@_p@@H˒@~$@>B@#@fB@kP|@C%@$/@b}V@eں@|@q@=p
@k~(@C%@qiC@.H@x)@vFs@tD@or@ka@@kP{@kC]@cS@[$@HeO@Ao hی@?[W>@=K]@:~@8}H@7kP@74m@74m@7KƧ@6Fs@6E@4m8@-hr!@%F
L0@"3@"wkQ@#eO@$e@&,<@',@'	k@'-@'lC@*~"@2s@4SMj@4j~@2s@.1@.H@-
qv@*g	@&A@%ڹ@$/@$TɆ@$e@N;@@@af@Fs@T`d@n@S&@tj~@m@-
q@@/{J#@'/@	@]cf@?@g8}@Zc@hr@#x@#x@"`@C\@G{@PH@$tS@I^5@\(@\(@,zxl@@nP@@@2W@84֡@?@bM@Mj@-V@,<쿱@;5Xy@C@GzH@KƧ@M@M@L_@N!R<@DJM@Q@],=@d?@Stj~@dTɆ@qiB@u'0@v4K@u?|h@sPH@kC]@k6z@fx@KxF]@A [7@L/{J#@QX@S&@S&@QR@NVu@LI^5?@KxF]@JqiC@J#9@J	 @J#9@DS@C@@ѷX@71@?@@@&@ ѷY@JE@
%@@ hۋq@L/{J@Q@6z@U=@o@b}V@{~$@oiDg8@u!.@:S@mC\@QR@Q@:)y@}H@!-w1@3ߤ@B&IR@oiDg@4֡a@G{@1-@_حV@@6@%F
L0@1o@1-@*0
@$TɆ@$xF@$tSM@sP@唯O
@"`B@e+@eO@唯O
@fB@PH@C\@҈p@JE@`A7@D@@N@'/@@     @}Vl!@{lC@{m]@{s@z>B@zC\@tj~@sMjO@tj~@xl"h	@y=b@zxl"h
@z@o-V@h@ffffff@d%1@[q@T*1@L/{J#@Gy@D2W@@C@>
(@8Q@2ᰊ@+a@@'RT`e@$xF@	@%@,=@=K^@Xe,@L_@zG@*0U2@n@o @ߤ?@u%F@@
E@
G{@
xl"h
@
=b@
	k~@
73@
Fs@
@
	ԕ+@
ڹ@
,<@
,<@
Z1@
҈p;@
=p@
As@
s@
|@
{J#:@
xF@
u%F@
'RTa@
@
hۋq@
:S@
|hr@
}E@
|PH@
p
=q@
g8}H@
`
qu@
Zݘ@
Rp:@
L/{J#@
I^5?}@
G@@
D*0@
@n@
<64@
.2X@
'/V@
&x@
$TɆ@
U=@
"3@
&@
 ěT@
U=@
,=@
,<@
ݗ+k@

qu"@˒:)@+@!.I@\(@Y|@ ě@C\@VϪ@C\@fB@u!@Q_@t@Ϫ͞@˒:*@74@6z@C-@?|h@g	l@>B[@@/V@zxl"h@vȴ9@Q@-
@R<6@~($x@H˒:*@$/@l"h	@iB@@7Kƨ@ǮzH@˒:*@Ƨ-@C@[W>@BZc @z@&x@'@n.3@%@$/@@@qi@M:@@ߤ?@҉@0
)@tj@$tS@*0@S@.H@IQ@1@h	ԕ@	@Q@@'/@YJ@ ѷ@tj@@k~(@\(@Z@҈@k~(@&I@u%F
@@4n@u%F
@@M:@n@rGE9@u%F
@de@OAs@'RT`e@@
L/{@S&@o h@!R<@4J@&I@      @
˒:)@
	k~@
@N@
>6z@
p:~@
o i@
ᰊ@

qv@
6z@
\)@
9@
tj@
R<6@
+J@
Ov_@
nO@
u@
$tT@
)^@
bM@
qi@
M:@
L_@
xF]@
qiC@
+I@
@
IQ@
.H@
~$t@
~m\@
}ڹZ@
}ڹZ@
v!.I@
poiDg8@
kC]@
h>BZc@
h	ԕ+@
e@
ffffff@
nt@
lVϪ@
m\@
mC\@
n.2@
p:~ @
qu!S@
rGE85@
iB@
]+j@
_;dZ@
QR@
S&@
YJE@
\]ce@
ZQ_@
Yb}@
eڹ@
[W>6z@
Yb}@
Sa@O@
P{@
L_@
K)^	@
6C-@
.1@
1o@
(@
74m@
B\(@
H˒:*@
HK]c@
DS@
?@
,>B[@
#9@
 	k@
u@
PH@
@
YJ@	@	sPH@	
M;@	@	6z@	
(@	a@@	v@	a|Q@	a|Q@	Xy=@	&@	'@	x@	1@	'RT`@	R<6@	Q@		@	%@	C,zx@	[@	Q@	vȴ@	tj@	ߤ?@	lVϪ@	P{@	M:@	C,zxl@	@6@	C,zxl@	?[W>@	>6z@	?H˒:@	=<64@	<j~#@	;5Xy@	;/V@	9XbM@	4m8@	1-@	/r@	/{J#:@	/{J#:@	/v@	.2X@	-w1@	*d7@	%zxl"h@	&@	*d7@	&x@	*0
@	(@	(@	.2X@	.zG@	-V@	
qu"@	&I@m\@>B@.H@s@Vl!@($x@E@Vl!@xl"h
@rGE8@Q@ܑN;@"`B@Q_@y=c@>6z@`d@т@;5X@ʌL_@a@N@[W>@BZc @/V@|@a@@&@ae@qu!@e+a@zG@@N@nO@)^@~($x@b}V@yrGE8@v+jg@tSMj@n.2@kC]@iDg8~@hۋq
@irGE@iDg8~@iDg8~@f,<@`҈p@W
=p@R䎊@P|@N+@N_o @M:@K:)z@I^5?}@HK]c@F
L/@D*0@?@4J@*0U2a|@&'@%F
L0@$tSM@#S&@vȴ9@Ov_@˒:)@-V@빌~($@JL@r Ĝ@+a@Gz@d8@ޞ@>BZ@`A7@5Xy>@ȴ9Xb@g8}@6@ߤ?@5Xy@^5?|@Q@g	l@U2a|@}Vl@I^@u@xF@
=p@n.3@S&@Q@e+a@ᰉ@҉@-
q@qu"@	 @eO@S&@u%F
@n.@~$t@{J#9@xF@sg@o hۋ@mhr!@kC,z@jJL@iDg8~@cZ@_Ft@Zݘ@XU@QN;5@NT@LcA \@Gy@@n@:)_@9#w@7KƧ@5'0@3g	l@,q@&IQ@&L/{J@%S@#n.3@"`A@"h	ԕ@"3@!ae@&x@43@4J@2ᰊ@1o@.1@(@#S&@$/@"3@!.I@ hۋ@1.@ce@ۋq@ᰉ'R@>@ce@Ft@`A7L@#@hr@ hۋq@s@Fs@GE85@ hۋ@\@fB@r Ĝ@䎊qj@Gz@ ѷY@Q_@>6z@]cf@@v@
(@~($@}Vl@ߤ@2W@
(@L/{J@vȴ9@쿱[W@	@%@,=@6C@*0@@ݗ+k@ߤ?@M:@(@@qu"@xF]@ ѷ@I^5@vȴ9X@sg@p:~ @b}Vm@UfA@QR@Np:~@M%@I^5?}@K]cA@E8YK@>ߤ?@<64@:)y@:)y@:^5?|@9D@7rG@2-V@wkP@@\(@u%F@hr@!.@o@fA@]ce@iB@ۋq
@ⶮ}Vm@@4@>BZ@Ϫ͟@;dZ@
L/@?@I^5@u%F
L@j~"@hۋq
@jOv`@jfB@bM@]+j@\(\@ZY@Zݘ@\(\@m(@b}V@o4֡a@\(\@SMj@K:)z@F
L/@G@@Eo i@B\(@B74@<n.@12W@+U=@$tSM@ 'RT`@wkP@tj@*0@q@
=p
@҈@
L/{@C%@L_@@!R<@I^5?@
=p
@
qiC@%2@"`@PH@@!-w@
qu@ hۋ@l@iB@@-V@-V@O;@C,z@e+@?|h@0U2a|@IQ@ae@䎊r@%@$tS@Fs@n@qi@(@=p
@4m9@y=b@u%F
L@s@rs@poiDg8@nt@mhr!@m\@hۋq
@f,<@de@ae@\N;@XbM@TɅoi@QR@P*0U@K)^	@H9Xb@B74@9Y}@5?@3ߤ@,zxl"@*͞&@'&@#9@-V@u%F@*0@!R<@	7KƧ@_o@ݗ@@E@l"h	@C@fB@fA@1.@Z@o@5?|@ce@6@֡af@,<@_p@@,zxl@Zc@@|hs@
(@K]@쿱[@Y}@Xy=@J@33333@a|Q@W@{@{J#:@zG@q@@`A@C,zx@e+a@sh@:)y@\(@@qiC@YJ@I^5@$tS@|hr@{s@{s@{s@zxl"h
@y=b@xl"h	@sE@m(@jfB@jJL@iB@h	ԕ+@ffffff@dZ1@ceO@`҈p@_;dZ@[$@N_o @J#9@Fs@C$@B&IR@@NU@=<64@6}Vl@0
(@0U2a|@-w1@*͞&@*͞&@*0U2a|@)y@)@'-@'RT`e@#wk@ 'RT`@-V@vȴ@sh@)^@
@'/@Fs@S&@rGE8@ hۋ@빌~($@ۋq
@e@Z1@A [@S@@4@e+@ᰉ'R@Ft@֡af@_p@@@ߤ?@A@S&@)y@Y}@#w@Xe@֡a@r@x@TɆ@3@	@u"@@@Ov_@Z@:)y@!R<@q@L_@7KƧ@4m9@{J#9@w+@uY|@r{m@p@nO;@m8Y@ae@[$@Z1'@Y|@XU@V8YJ@S&@O;dZ@L/{J#@Jn@F
L/@C$@B@>6z@<쿱[@;5Xy@:S&@9~($@4֡a@2m\@333333@0U2a|@)lD@!-w1@@n@rGE9@ߤ?@L_@S&@@"@Q@~$@~$@>B@@+@GE85@C]@JL@rGE@,<@ᰉ'R@ߤ?@ޞ@c	@e+@l!-@2a|@m@т@а{@*0U@@cA \@@]cf@ěS@\(@7Kƨ@n@|hs@<64@^5?|@Q@3@4m@'0@1@jf@lD@$xG@tSM@-
@-V@PH@@qi@q@=p
@ ѷ@eO@+I@@hۋq@~$t@}H˒@|#x@{m]@z>B@xF]d@tj~@poiDg8@p@nO;@l!-w@jfB@g	k@e+a@dZ1@cA [@cZ@c	@cA [@c	@_?@[$@VϪ͟@T`d@QR@N;5X@Ks@DS@A@=v@:~@9D@84֡b@8YJ@2-V@0 ě@.zG@)^@'/V@&L/{J@"`A@Q@1&@PH@@$/@S&@N;6@)^@bM@-
q@rGE9@bM@)^@$tT@)^@u@-
q@@?@u%F
@o hی@ $t@ PH@ kP@ +jg@ j~@ g@ @ GE85@ D@ t@ Ov`@ 1.@ `A7L@ %1@ 	@ ⶮ}Vm@ C,@ d8@ ]ce@ 1'@ l!-@ @ R@ _p@ cA \@ D@ ɅoiD@ @ ȴ9Xb@ ?@ o i@ ěS@ *0@ *0@ Õ$@ 4m@ 64@ Z@ /V@ ~@ ~@ )@ 3@ Xy=@ 'RT@ 
qv@ V@ V@ >B[@ <쿱@ U=@ jf@ a@@ a@@ ͞&@ '@ 1@ ,<@ *0@ *0@ O
M@ :)y@ -
q@ @ @ qu"@ I^5?@ ҈@ q@ '/@ qiC@ 'RTa@  ѷ@ K]d@ _o@ +I@ o h@ o hی@      @ }E@ |hr@ |hr@ {lC@ {s@ {~$@ {m]@ {J#9@ {~$@ {lC@ y=b@ sE@ o-V@ kP{@ f,<@ fA@ eO
@ cZ@ ae@ _حV@ ^ ѷY@ ]cA @ ["`B@ Y>BZ@ YJE@ XU@ XD*@ XD*@ WsPH@ Sa@O@ N+@ K]cA@ H˒:*@ Fs@ Em\@ C@ B\(@ A7Kƨ@ @NU@ >6z@ <Z@ 9~($@ 333333@ ,>B[@ +U=@ *0
@ %F
L0@ #9@ #9@ "`A@  	k@ u@ e+a@ +j@ Ov_@ *0@ tj~@ n@ n@ hr @ $tT@ u@ hr @ 4J@ \(@ qi@ 
(@ 
qu"@ ?Fs?C,z??䎊qj?ߤ??حU?sPH?E?ԕ*1?,<?a@O?m?N;5????Z?}Vl?lD?u?	k?U=?쿱[W??$/?qi?C%?C%?~($x?C%?#?+I?Q??o hی?}H˒?zG{?y(?xF]d?sg?r ě?p:~ ?kP{?c	?Y|?S&?JD?F]cf?C\N?As?A7Kƨ?A7Kƨ?@4m?@NU??|hs???=b?=p
=?<64?:S&?:~?:S&?9D?5Xy=?2a|Q?/v?-
qv?)y?#9?!-w1?!-w1?1&?C,zx?*0?nO?ߤ??҈?I^5??I^5??	ԕ*?      ?#x?>B?"`?!.I?Y|?g	?%1?҈p?҈p;?$?`A7                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              @?@?@?'RT`@?-
q@?'RT`@?*0U@?
qu@?'RT`@?@?*0U@?'RT`@?'RT`@?A7K@?NU@?'RT@?-
@?u!@?ѷX@?2W@?ƻ@?_F@?ڹY@?     @?W@??@?S@@lD@@@@$#x@@/䎊r@@9o@@:74@@<D@@>}Vl@@@*0U@@AiB@@D1&@@Hr Ĝ@@KxF]@@Ltj@@L3@@Mqu"@@N@@N}Vl@@Nm\@@O)^@@ORT`e@@O4m@@OحV@@P ě@@PA7K@@P[6@@Pr Ĝ@@Pn@@P@@P4m@@PTɅ@@Pp:@@P@@Q+@@Q7KƧ@@QDg8~@@Qk~(@@Q~($@@QX@@QX@@Q_o@@Q>BZ@@R#9@@RC\@@Ra|Q@@Rxl"h
@@RwkQ@@S"`B@@TQ@@TC@@T~($x@@To h@@Tq@@TzG@@T>B[@@UfA@@U+j@@U!.@@Vu@@V!R<@@V@@V]cf@@Vm\@@Vm\@@W@@WrGE9@@WrG@@WVϫ@@W䎊r@@WrGE9@@X1&x@@Yᰉ'@@Z\(@@\Fs@@^A@@`d8@@d*0@@gO
M@@hl"h	@@i$/@@nqi@@tߤ@@@y@@.H@@ԕ*@@6z@@cA \@@#w@@w1@@[@@Q@@ ě@@u%F@@/@@_o@@xl"h
@@b@@4m@@_@@	 @@u%@@Q@@@@ ѷ@@=p
@@J@@8YK@@
qu@@@4n@@ݗ+k@@ڹ@@8}H@@-
q@@|Q@@u%@@ہ@@O;dZ@@}Vl@@o@@*0U@@@@+@@~"@@P{@@C,zx@@K]@@E@@Ϫ͟@@_o@@y@@4m@@琖@@@@@>BZc@@	k@@x@@7Kƨ@@oiD@@R<6@@I^5@@꩓@@m@@m\@@I^@@C,z@@Q@@xF@@O
M@@>@@*0@@+j@@Ϫ͞@@ڹ@@4K@@\N<@@IQ@@IQ@@x@@&@@vȴ9@@ﴢ3@@[W>@@r@@;dZ@@*0U@@Q@@y=c@@|@@˒:*@@˒:*@@n@@YJ@@@@
=q@@p:@@`A7@@@N@@@@u%F@@.H@@@@@@=p
@@^5?|@@^5?|@@nO@@ ě@@҉@@s@@~@@	@@F]c@@dZ@@g	l@@9@@dZ@@{J#9@@Q@@qu!@@@N@@D@@`A@@<64@@S&@@S&@@򅇓ݘ@@~"@@p:@@@@>B@@>B@@ ѷ@@䎊q@@C,@@m@@D@@PH@@9@@C%@@F]c@@Ƨ@@9XbN@@tSM@@C,zx@@Q@@"h	ԕ@@M:@@N;@@JM@@hr@@E@@!.H@@/w@@F
L0@@$/@@n/@@H˒@@b@@M:@@fA@@fA@@=K@@jOv@@2a|@@K]@@E@@[@@/w@@<64@@S&@@ڹZ@@ce@@m\@@}H@@w1@@ݗ@@hr!@@%@@E@@qi@@@@E84@@H˒:@@b}V@@.H@@$tS@@@@)^@@@@@@ hۋ@@,@@C-@@+@@kP@@˒:)@@-@@@@     @@fA@@@@;dZ@@$xG@@$xG@@@@4m@@-
@@|@@l"h	@@U2a|@@73@@-
q@@D*@@K]c@@Q@@u!@@tj@@tj@@@@u%F@@
=q@@4m@@9Xb@@A [@@k~(@@u@@_o@@e@@&IR@@u%F
@@)_@@S&@@fB@@)_@@>B@@ᰊ@@p:@@@4@@xl"h
@@a|Q@@nO@@S&@@vȴ@@g	@@ ѷ@@'/@@xF]@@L_@@N;@@K]@@`A7L@@sg@@Vl!@@IQ@@B@@qu"@@(@@%F
L@@Xy=@@8Y@@ݗ@@ڹ@@iB@@Ϫ͟@@.H@@o@@sPH@@/V@@Vϫ@A 	ԕ+@A 1&x@@K]d@@@@A 'RT@A PH@AB@Aԕ*@AR@AR@A.H@A@As@A)y@AC\@A3@A:)y@A@4n@A6C@A6C@A3@A)y@A@AC,@A`A@AfB@AS&@Am\@Am\@AS&@AS&@A҉@A,zxl@AP{@AdZ@Ajf@A@A@A>B[@A#x@A(@Av@AϪ͞@A+jg@A%@Aaf@A&I@Aȴ9X@Am\@At@At@Am\@Aߤ?@A.H@Av_ح@A{J#:@A	@Aݗ+@AkP@Ar@A@A*0U@A>BZc@AD*@Ay=c@Al"h	@Al"h	@AIQ@A҈p@A`A7@A	@N@A	@A		k~@A˒:*@A@A4m@A{J#:@A	k@A@A;dZ@A	ԕ+@AbM@A@A@A}H@A73@AeO@AѷX@A	0
)@A	TɅo@A	k~(@A	7Kƨ@A	~($@A	XbM@A	N;5@A	e+a@A	o hی@A	u!S@A	b}@A	l@A	@A	y@A
~"@A
@A
S&@A
ݘ@A
~"@A
0
@A
\(@A
\(@A
g	@A
ڹY@A
fB@A
m@A
c	@A
sP@A
fB@A
W@A
ڹY@A
C,@AS&@AnP@A33333@AW>6z@AQ@A~($@A!-w2@A
F
L0@Avȴ9X@Av@A$tS@A4֡a@AsPH@A@AA7K@AXy=@Ay=c@A˒:*@A@A-
@A9Xb@ATɅ@A
(@Ae+@A	k@A@N@A*0U2a@A@A_p@A_p@A@A=b@A(@A@AoiD@Ae+@An@ATɅ@APH@A&x@A:S@A@AN;6@As@A)y@AJL@AkP|@A@4@Ap:@AL_@AT`d@Ad7@A)_@AI^@A)^	@A'/@Am\@AI^@AS&@A҉@Au%@AS&@APH@AnP@Ac	@AڹY@A@A ě@AL/{@Aᰊ@A~"@Axl"h
@AkP|@A{m@A0
@AL/{@A ě@AY@A>B@A74@AF]c@AMjO@AS@AW>6z@AJ#9@AJ#9@AE@A"h	ԕ@AtSM@A#x@AJM@Ae@Ao i@AE@Ae@AɅoi@AɅoi@A$/@An/@A(@AXy=@A!R@A$/@Asg@A}H@A}H@A`A7L@AVl!@A+a@A'0@AE@Ao i@A5Xy>@Ap
=@A!R@AH˒@A!.@Aڹ@Aڹ@AE@AE@AC\@Aڹ@A
L/@A1.@Ac	@A6z@Am\@Ax@A@Av@A.H@AKƧ@A	@A@Aݗ+@AkP@A	k@Ar@AK]d@A+j@AXy=@A_F@AQ@AU2a|@AbM@Ar Ĝ@A
=q@AF@A{@A	k@A+@A-w1@AoiD@A2W@Ay@AY}@Au%F@Au%F@As@A)y@A)y@Aa|Q@Aa|Q@Ad7@AkP|@A@AG{@AD@APH@A)^	@A6z@AC%@AZ@A$@Aa@@An.@A1&y@Atj@AQ@A2W@A9XbN@AI^5?@A]ce@A`d@Am8@Ao h@A#@A*1@A1&@A?@AD@AQ@A<64@A?|h@AF
L0@AIQ@AS&@AY|@A`A7L@Asg@A}H@A$/@A@A,=@AH@A2X@A$tS@AlC@Aݗ+@A3@A+@A䎊r@A @A 9Xb@A -
@A @A!A [@A!n.@A!7Kƨ@A!-@A"T`d@A"{m@A"<64@A"sP@A"ڹY@A"C,@A#u%@A#nP@A",<@A"@A#PH@A#MjO@A#Z@A#qu!@A#@A#q@A#~($@A#@A#
=p@A$xF@A$2W@A$PH@A$zG@A$wkP@A$?@A$?@A$m8@A$I^5?@A$`d@A$#@A$Z@A$D@A$1&@A$#@A$쿱[@A$L_@A$xF@A$VϪ@A$tSM@A$g8}@A$Fs@A$C,zx@A$2W@A$I^5?@A$tSM@A$`d@A$C,zx@A$I^5?@A$SMj@A$,<@A$C,zx@A$C@A$[W?@A$qj@A$cA \@A$~($x@A%2a|@A%ᰉ@A%8YK@A%@A%@A%?@A%
qv@A%8YK@A%?@A%8YK@A%b@A%w1@A%}H@A%hr!@A%-V@A%8Y@A%?@A%C\@A&zG@A&$/@A&1.@A&1.@A&($x@A%ڹ@A%ᰉ@A%oiDg@A%ᰉ@A%oiDg@A%E@A%oiDg@A%!.@A& ѷY@A&t@A&$/@A&8YJ@A&R<6@A&p:~@A&+J@A&Fs@A&ߤ?@A&&I@A&҈p;@A&]cf@A&1@A&Fs@A&!.I@A''/W@A'As@A'H˒:@A'E84@A'As@A'O
M@A'eں@A'O;d@A'?@A'vȴ9@A'@A'@A';dZ@A'-@A(     @A(@A(
qu@A(bM@A('RT`@A(*0@A(-
q@A(K]c@A(hۋq@A(˒:*@A('RT@A(n@A('RT@A(-
@A(tj@A(-
@A(U@A(ěT@A(ѷX@A(F@A(D@A(`A7@A($tT@A)_p@A)#w@A)XbM@A)@A)u@A)|@A)y@A).H@A).H@A*n@A*@A*s@A*1'@A*#9@A*&IR@A*&IR@A*3@A*6C@A*C\@A*@4n@A*@4n@A*C\@A*^5?|@A*xl"h
@A*vȴ@A*0
@A*@4@A*L_@A*>B@A*Y@A*@A+I^@A+PH@A+,zxl@A+/V@A+33333@A+=K^@A+dZ@A+dZ@A+a@N@A+g	l@A+jf@A+dZ@A+n.3@A+tj~@A+{J#9@A+eO@A+S@A+m]@A+Z@A+Q@A+s@A,J@A,J@A,ߤ@@A,L_@A,Q@A,Q@A,!-w2@A,"h	ԕ@A,"h	ԕ@A,,<@A,,<@A,2W@A,9XbN@A,VϪ@A,]ce@A,n.@A+S@A+a@N@A+33333@A+S&@A+C,z@A+9@A+C%@A+C%@A+F]c@A+ߤ@A+@A+a@O@A+|@A+%2@A+g@A,1&y@A,I^5?@A,Z1@A,j~#@A,tSM@A,?@A,*1@A,zxl"@A,Ʌoi@A,!-w@A-V@A-[@A-[@A-/w@A-zxl"h@A-Xy=@A-\(@A-8Y@A-n/@A-U=@A-@A-1@A-@A-Ϫ͞@A-?@A-(@A-(@A. ѷY@A.%@A.-@A.t@A.C-@A.1@A.C-@A.1@A.Fs@A/!-w1@A/As@A/\(@A/4m@A/eں@A/|hs@A/_o@A/U=@A/8}H@A/;dZ@A/4֡a@A/lC@A/kP@A/?@A/	k@A/͞@A/˒:)@A/;dZ@A/fA@A/@A/;dZ@A/fA@A/@A/fA@A/@A/@@A/@@A/@A/rG@A/+j@A0     @A/#@A0F]d@A0	ԕ+@A0
qu@A0bM@A0*0U@A0*0U@A0bM@A06@A0}H@A0*0@A01&x@A0-
q@A0*0@A01&x@A073@A073@A0Q@A0_F@A0l"h	@A0y=c@A0YJ@A0IQ@A04m@A0{@A0@A0\)@A0	k@A0PH@A1@A1@A1#w@A17KƧ@A1*0U2a@A1A [@A1hr @A1k~(@A1@A1o@A1o@A1@A1|@A1D@A1s@A1s@A1s@A1s@A1-@A1Y}@A1@A2s@A2@A2^5?|@A2p:@A2@A2Y@A2,<@A2sP@A2sP@A2ڹY@A2 ѷ@A2c	@A2䎊q@A2C,@A2,<@A2n@A20
@A2>B@A2W@A2ڹY@A274@A3u%@A3,zxl@A39@A3F]c@A3W>6z@A3dZ@A3dZ@A3dZ@A3g	l@A3tj~@A3~($@A36@A3a@@A3C]@A3s@A4@A4%1@A4%1@A42W@A4(\@A4xF@A3Q@A3҈@A3g@A4n.@A4"h	ԕ@A4I^5?@A4]ce@A4~($x@A4#@A4#@A4#@A4#@A4N;@A4S@A4S@A4쿱[@A4S@A43@A4zxl"@A41&@A41&@A4j~@A4@A4D@A5*0@A5+a@A5F
L0@A5L_@A5jOv@A5U=@A5\(@A5\(@A5v@A5sh@A51@A5-V@A5sh@A5n/@A58Y@A58Y@A5cA @A5Ϫ͞@A5b@A5b@A5(@A5oiDg@A5oiDg@A5oiDg@A5E@A5oiDg@A5C\@A6zG@A6
(@A6!R<@A61.@A6;5X@A6E@A6Vu@A6_ح@A6l!-@A6z@A6Fs@A6@A6af@A6-@A66z@A6@A6t@A6ߤ?@A7 hۋ@A7
=p@A7
M;@A7
=p@A7)^@A7@A7$tS@A7$tS@A7'/W@A7!-w1@A7!-w1@A7.H@A7H˒:@A7&@A7-V@A7[W>@A7r@A7o @A7@A7حV@A7@A7@A7@A7-@A7rGE9@A8F]d@A8 ě@A8'RT`@A8-
q@A81&x@A873@A84m9@A8D*@A8_F@A8bM@A8[6@A8Xy=@A8bM@A8hۋq@A8oiDg8@A8oiDg8@A8l"h	@A8u!@A8tj@A8@A8U@A89Xb@A89Xb@A84m@A8ěT@A8ѷX@A8D@A8ۋq
@A8ۋq
@A8e+@A8@A8C@A8C@A8C@A8@A8{@A8$tT@A9	k~@A9rGE@A9@N@A9@N@A9@A9 [7@A9*0U2a@A9-w1@A94J@A90
)@A9A [@A9Dg8~@A9Q@A9XbM@A9^@A9hr @A9e+a@A9k~(@A9hr @A9x@A9@A97Kƨ@A9o@A9l@A9'R@A9X@A9D@A9_o@A9ᰉ'@A9e@A9R@A9Y}@A9lD@A:Ov`@A:&IR@A:-V@A:-V@A:6C@A:6C@A:=p
@A:@4n@A:GE85@A:h	ԕ@A:g	@A:W@A:͞&@A:͞&@A:W@A:,<@A:,<@A:䎊q@A:C,@A:S&@A:@A:@A:͞&@A:)_@A:͞&@A:W@A:͞&@A:,<@A:m@A;)^	@A;W>6z@A;tj~@A;~$@A;eO@A;Mj@A;ߤ@A;U=@A;S@A;q@A;@A;E@A;Z@A;a@O@A;5Xy@A;5Xy@A;@A;|@A;ݗ+k@A;C]@A;A [@A;s@A;@A;A [@A<tj@A<64@A<64@A<9XbN@A<<쿱@A<<쿱@A<I^5?@A<Fs@A<I^5?@A<SMj@A<`d@A<g8}@A<g8}@A<`d@A<cA \@A<q@A<o h@A<zxl"@A<#x@A<#x@A<?@A<JM@A<>@A<>@A<>@A<>@A<e@A<E@A=*0@A=(@A=/w@A=+a@A=+a@A=/w@A=/w@A=5Xy>@A=84֡@A=IQ@A=O;dZ@A=S&@A=F
L0@A=5Xy>@A=/w@A=qu"@A=*0@A=F
L0@A=S&@A=+j@A=%@A=@A=O
@A=+j@A=+j@A=M:@A=v@A=IQ@A=/w@A=<64@A=?|h@A=F
L0@A=IQ@A=O;dZ@A=L_@A=IQ@A=F
L0@A=IQ@A=Vl!@A=!R@A=,=@A=,=@A=8YK@A=@A=@A=8Y@A=S@A=!.@A=oiDg@A=ᰉ@A=oiDg@A=!.@A=!.@A=ڹ@A=C\@A=E@A=C\@A>
L/@A>4K@A>4K@A>;5X@A>\N<@A>fffff@A>iB@A>p:~@A>+J@A>@A>Fs@A>$t@A>@A>Ϫ͟@A>҈p;@A>҈p;@A>ȴ9X@A>҈p;@A?@A?$tS@A?'/W@A?+I@A?.H@A?.H@A?.H@A?8}H@A?+I@A>쿱[W@A>]cf@A>C-@A>ߤ?@A>+@A>x@A>1@A>x@A>x@A>1@A>C-@A>쿱[W@A?@A?Ft@A?Ft@A?
M;@A?
=p@A?)^@A?Xe@A?,@A?!-w1@A?4֡a@A?8}H@A?E84@A?RT`e@A?iDg8@A?{J#:@A?	@A?ݗ+@A?	@A?ݗ+@A?kP@A?zH@A?o @A?K]d@A?˒:)@A?@A?fA@A?@@A?rGE9@A@
qu@A@bM@A@}H@A@'RT`@A@73@A@73@A@A7K@A@K]c@A@Xy=@A@r Ĝ@A@'RT@A@@A@tj@A@u%F@A@@A@{@A@{@A@{@A@4m@A@@@A@F@A@D@A@4֡b@A@\)@A@{@A@	k@AA$/@AA	k~@AA$/@AA$/@AA+@AA#w@AA&x@AA&x@AA [7@AA0
)@AA4J@AA4J@AA7KƧ@AA:S@AA=b@AAXbM@AAe+a@AArGE8@AA|Q@AA@AA~($@AA~($@AA@AAu@AAB@AA|@AAX@AA^5?}@AA^5?}@AA|@AAX@AA@AAD@AAN;6@AA"`@AA"`@AA@AAiB@AAe@AA>BZ@AAR@AAs@AAlD@AAlD@AA.H@AB)y@AB0U2a|@AB6C@AB:)y@AB@4n@AB@4n@ABC\@ABW'@ABd7@ABa|Q@ABh	ԕ@ABkP|@ABnO@ABh	ԕ@ABh	ԕ@ABqiC@ABqiC@ABqiC@AB{m@ABݘ@ABL_@ABp:@ABS&@AB>B@AB}Vm@AB}Vm@ABY@ABn@ABG{@ABc	@ABc	@ABD@AB~@AB74@AB74@AB~@ACI^@ACS&@ABm\@ACu%@ACPH@AC&@AC=K^@ACS@ACZ@ACZ@ACZ@AC]cA@AC]cA@ACdZ@ACg	l@ACQ@AC$@ACߤ@ACߤ@ACߤ@ACwk@AC*0U2@ACm]@ACm]@ACE@ACZ@AC@AC5Xy@AC@ACa@@ACC]@ACA [@AC$@AC\N@ADn.@ADxF@ADJ@AD@AD2W@AD<쿱@AD9XbN@AD64@AD64@AD<쿱@ADI^5?@ADPH@ADVϪ@ADZ1@ADj~#@AD]ce@ADm8@ADq@ADwkP@ADwkP@ADwkP@ADzG@AD~($x@AD#@AD#@ADN;@AD3@AD?@ADɅoi@ADZ@ADZ@ADu"@ADJM@AE:@AEV@AEV@AE[@AE[@AEu@AE'0@AEu@AE*0@AE(@AE2a|@AE84֡@AE5Xy>@AE<64@AEF
L0@AES&@AEVl!@AE`A7L@AEfA@AEjOv@AEjOv@AEp
=@AEm\@AEzxl"h@AEw1@AEzxl"h@AE$/@AEݗ@AE!R@AEhr!@AE=K@AE%@AE@AEU=@AE1@AEsh@AE@AEn/@AEn/@AE\(@AEb@AE?@AE
qv@AE?@AEᰉ@AEC\@AF ѷY@AF_o @AFu@AF($x@AF.2@AF5?|@AF8YJ@AF8YJ@AF8YJ@AFBZc @AFL/{J@AFL/{J@AFL/{J@AFOv_خ@AFVu@AFVu@AF_ح@AFc	@AFs@AFp:~@AFvȴ9X@AF}Vl@AF}Vl@AFqi@AFFs@AFO;@AFFs@AF,<@AFO;@AF$t@AFFs@AFaf@AF-@AF@AFߤ?@AFm\@AFA@AFt@AF쿱[W@AF"@AG hۋ@AG@AGFt@AG hۋ@AG@AG@AG@AGXe@AG$tS@AG'/W@AG.H@AG;dZ@AGE84@AGH˒:@AGU=@AGRT`e@AGU=@AGXe,@AGXe,@AG_o@AGeں@AGb}V@AGb}V@AGeں@AGlC@AGo@AGo@AGeں@AGo@AG{J#:@AG$tS@AGkP@AGkP@AG	k@AG	k@AG[W>@AG/V@AG/V@AGr@AGr@AG@AGo @AG+@AGfA@AG+@AG@AGحV@AG;dZ@AG@AG@@AGrG@AG-@AG䎊r@AH     @AH@AHbM@AH*0U@AH6@AH$xG@AH6@AH ě@AH ě@AH'RT`@AH ě@AH6@AH'RT`@AH*0@AH*0@AH1&x@AH>BZc@AHA7K@AHD*@AHD*@AHD*@AHH@AHK]c@AHNU@AH[6@AHbM@AHbM@AHbM@AHeO@AHbM@AHhۋq@AHhۋq@AHhۋq@AHl"h	@AHoiDg8@AHu!@AHn@AHu%F@AH
=q@AHd8@AH@AH9Xb@AH{@AHU@AH
(@AH)@AH
(@AH)@AH4m@AHěT@AHTɅ@AH@@AH@@AH@@AH)^@AH)^@AHѷX@AHD@AHۋq
@AHe+@AHe+@AH`A7@AH@AHC@AH@AHC@AH4֡b@AH`A7@AHC@AH\)@AI$/@AIrGE@AI@AI0
)@AI*0U2a@AI0
)@AI4J@AI7KƧ@AI=b@AIDg8~@AIDg8~@AIN;5@AIN;5@AIQ@AIQ@AITɅo@AIQ@AIXbM@AIae@AIo hی@AIu!S@AI|Q@AIb}@AIoiD@AI7Kƨ@AIo@AI~($@AI@AIR<6@AIu@AI(@AI@AIo@AIN;6@AIN;6@AI"`@AIᰉ'@AIR@AIY}@AIlD@AJu%F@AJ@AJOv`@AJe+@AJ1'@AJ䎊@AJ䎊@AJ#9@AJ#9@AJ&IR@AJ#9@AJ#9@AJ#9@AJ)y@AJ0U2a|@AJ3@AJ=p
@AJa|Q@AJnO@AJ@4@AJ@4@AJp:@AJ\(@AJᰊ@AJ\(@AJwkQ@AJwkQ@AJvȴ@AJwkQ@AJvȴ@AJwkQ@AJvȴ@AJ>B@AJn@AJ,<@AJڹY@AJfB@AJfB@AJfB@AJm@AJ74@AJ~@AKS&@AKu%@AKS&@AKI^@AKu%@AK'/@AKnP@AKs@AKnP@AKC,z@AK	@AK"`B@AK	@AK&@AK)^	@AK)^	@AK33333@AK=K^@AKF]c@AKP{@AKZ@AK]cA@AKg	l@AKjf@AKjf@AKqu!@AKn.3@AKtj~@AKqu!@AKqu!@AKqu!@AKtj~@AK{J#9@AK{J#9@AK{J#9@AK~$@AK{J#9@AK{J#9@AKQ@AKMj@AKMj@AKMj@AK:)z@AKU=@AKS@AKS@AK*0U2@AK*0U2@AKq@AK~($@AK6@AKa@O@AKƧ@AK6@AKƧ@AKa@@AKQ@AKݗ+k@AK҈@AK%2@AK%2@AK$@ALn.@ALn.@ALJ@ALxF@ALL_                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              @r@r@r@r@r@r      @r@r@rfffff@r!@r)@r(     @r$@r!@r      @r      @r,@r.fffff@r.fffff@r0     @r1@r333333@qfffff@rfffff@r񙙙@s)@sS33333@sP     @sA@sQ@sd@sP     @s>fffff@s@r@s!@s	@s	@s33333@rfffff@s      @r@s33333@sfffff@sfffff@r@r陙@r     @rfffff@r@r     @rfffff@rfffff@r@r     @rfffff@rfffff@r@r@r33333@r@r@r33333@r@r     @r     @r     @r33333@r@r@rt@r[33333@rNfffff@rQ@r\@ra@r`     @r\@rH     @r+33333@r$@r(     @r)@r$@r      @r     @r33333@rfffff@r33333@r@r!@r(     @rfffff@r33333@q@r@qfffff@qfffff@q     @qa@q!@q@qfffff@p@pfffff@p8     @n@m@l@l&fffff@kvfffff@j@i     @h@h33333@hp     @hI@h,@h33333@gfffff@g`     @g      @f     @f@     @e陙@e33333@e@e@e@es33333@e\@e6fffff@d33333@d33333@di@dL@d333333@d33333@c     @c@ci@c@     @c     @b@bٙ@b33333@bfffff@by@bY@b@     @b<@bC33333@bC33333@bI@bFfffff@b@     @b333333@b      @b@b@b	@bfffff@bfffff@a     @afffff@a@aə@aə@a     @a     @ai@aL@a<@a)@a33333@`fffff@`33333@`     @`     @`33333@`@`fffff@`33333@`33333@`fffff@`@`     @`@`p     @`S33333@`Ffffff@`C33333@`Ffffff@`Ffffff@`Ffffff@`<@`9@`,@`&fffff@`fffff@_     @_      @^@^fffff@^     @^@^ffffff@^L@^S33333@^fffff@]     @]33333@]     @]@]     @]Ffffff@]&fffff@]L@]Ffffff@]      @]@]@],@]s33333@]     @]33333@]@^      @]@]@]     @]@]fffff@]     @]Y@]333333@]      @]&fffff@]@\@\fffff@\fffff@\@\     @\fffff@[@[@     @[&fffff@[33333@[fffff@Z     @Z@Z333333@Yfffff@Y@Y33333@Y33333@Y@Y33333@YFfffff@Xfffff@X     @X@Xٙ@Xfffff@X@X@X@Yfffff@Y      @X@Xfffff@Xٙ@X@X@Xl@Xffffff@Xffffff@X`     @XS33333@X&fffff@W     @WY@V33333@V     @V33333@Vl@VY@Vffffff@Vffffff@Vl@Vl@Vl@VS33333@VY@VL@Vfffff@Ufffff@U@Us33333@UFfffff@U33333@U@U@U@T@Tٙ@Tٙ@T33333@Tffffff@T9@T&fffff@T&fffff@T@T@T      @Sfffff@S@S33333@S33333@S33333@Sfffff@S     @S@Sfffff@Sl@SL@R33333@R33333@RS33333@RFfffff@R333333@R      @Q@Qfffff@Qfffff@Q33333@Q     @Q@Q     @Q33333@Rfffff@R@R@R      @Q33333@Q33333@Q     @Qy@QS33333@Q      @P33333@Pffffff@Oٙ@O@O@O     @O     @O@O@Offffff@Nfffff@N@N@Nfffff@N@     @Ms33333@L@Lffffff@LL@L&fffff@K@K@KY@Kffffff@Kfffff@Ks33333@J@Iٙ@I     @IL@I@     @I333333@I333333@I@I      @Hٙ@H33333@H     @Hٙ@H@H     @Hfffff@Hs33333@H@G33333@Gfffff@Gfffff@G     @G@G@G@Gfffff@G@G@G@GL@G@Ffffff@FL@F&fffff@F@Efffff@Eٙ@Es33333@D     @DY@DL@DL@DL@D&fffff@D@D      @C33333@Cfffff@Cfffff@C@Cfffff@C@Cffffff@C333333@C@B33333@B@Bfffff@B@Bffffff@BY@B@     @B@B@B@Afffff@A33333@A@A     @B@B333333@B333333@B&fffff@B@B      @Aٙ@A33333@A33333@A33333@Afffff@A@As33333@A@@33333@@ٙ@@     @@fffff@@@@fffff@@fffff@@fffff@@fffff@@@@@@s33333@@L@@333333@?@?ffffff@?L@?333333@?L@?L@?333333@>fffff@>33333@>33333@>33333@>@>ffffff@>L@>L@>L@>L@>      @>@>      @=@=@=333333@=      @<@<333333@;      @9fffff@9@9      @8fffff@8@8L@7fffff@7@7ffffff@7ffffff@7L@7L@7@7@7      @6@6@6@6     @6     @6     @6     @6     @6@5fffff@5fffff@6@6L@6@6333333@6@6333333@6      @5@5L@5333333@5@4@4@4@4@4@4@4     @4333333@4@4      @4@4333333@4333333@4333333@4333333@4L@4333333@4333333@4L@4L@4ffffff@4@4@4@4@5      @5      @4fffff@5      @4fffff@433333@4@4@4@4L@4333333@4333333@4@4333333@4      @333333@333333@4      @4      @3fffff@2     @2     @2@2@2@233333@1fffff@1@133333@133333@2      @2@2@2L@2333333@2333333@2L@2ffffff@233333@233333@2@2fffff@2@2@2ffffff@2L@2L@2@2333333@2L@2333333@2L@2333333@2333333@2      @2      @1fffff@133333@1@1@1@1     @1ffffff@1L@1333333@1L@1@1333333@1@1      @1      @0@033333@0@0@0@0@0     @0L@0L@0@0333333@0      @/@/ffffff@/333333@/      @.@/333333@/      @.@.@.@.@.@.@.@.      @-@-@-@-@-ffffff@-ffffff@-333333@,@,@,@,@,333333@,333333@,333333@,ffffff@,      @,      @,      @,      @,      @+@+@+@+ffffff@+      @+333333@+ffffff@+333333@+      @+      @+333333@+      @*@+      @*@*ffffff@*      @)ffffff@)333333@(@(@(@(333333@(333333@'@'333333@'333333@'333333@'333333@&@&ffffff@&ffffff@&333333@%@%333333@%333333@%      @%333333@$@$@%      @%      @%333333@$@$@$@$@$@$@$@$ffffff@$ffffff@$333333@$      @$      @#@$      @$      @$333333@$ffffff@$333333@$333333@$      @$      @$      @$      @$333333@$@$@%      @$@$@$@$@%      @%      @$@%      @%      @%333333@%333333@%ffffff@%333333@%333333@%      @$@%333333@%333333@$@$ffffff@$333333@$333333@$ffffff@$      @$333333@$333333@$333333@$333333@$333333@$ffffff@$@$@$@$@$@$333333@$333333@$333333@$333333@$333333@$333333@$333333@$ffffff@$@$@$@$@$@$@$@$@$@$@$@$@$333333@$333333@$333333@$ffffff@$ffffff@$      @$      @$      @$      @$333333@$ffffff@$      @#@$      @$      @$333333@$      @$      @#@$      @$      @$      @#@$      @$      @#@$      @$      @#@#@#ffffff@$      @#@#@$      @$      @#@#@#@$      @$      @#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#ffffff@#@#@#@#@#@#@#ffffff@#@#@#@#@#@#@#@#@#@#@$      @#@#@#@#@#ffffff@#@#@#@$      @#@#@#@#@#ffffff@#@#@#@#ffffff@#@#@#@#@#@#@#@#@#@#@#@$      @#@#@#@#@#@#@$      @$      @$      @$333333@$333333@$333333@$333333@$333333@$333333@$      @$333333@$      @$333333@$      @$333333@$      @$333333@$333333@$ffffff@$333333@$      @$ffffff@$333333@$333333@$      @$333333@$ffffff@$ffffff@$      @$ffffff@$333333@$      @$333333@$333333@$      @$333333@$ffffff@$ffffff@$ffffff@$333333@$ffffff@$333333@$@$ffffff@$      @$333333@$ffffff@$ffffff@$ffffff@$ffffff@$ffffff@$ffffff@$333333@$ffffff@$ffffff@$ffffff@$@$@$@$ffffff@$ffffff@$@$@$@$333333@$@$@$@$@$@$@$@$@$@$@$@$@%      @$@$@$@$@%      @%      @$@%      @$@%333333@%333333@%      @$@%      @%      @%      @%      @%      @%      @%      @%      @%      @%      @$@%@%333333@%333333@%ffffff@%333333@%333333@%@%333333@%333333@%333333@%ffffff@%333333@%ffffff@%ffffff@%ffffff@%ffffff@%ffffff@%@%333333@%@%@%@%@%@%@%@%@%@%@%@%@%@&      @&      @&      @&      @&333333@&@&333333@&@&ffffff@&ffffff@&333333@&ffffff@&ffffff@&ffffff@&ffffff@&ffffff@&ffffff@&ffffff@&@&ffffff@&@&@&@&@&@&@&@&@'      @&@&@'      @'333333@&@'333333@'333333@'      @'333333@'ffffff@'333333@'333333@'333333@'333333@'ffffff@'ffffff@'ffffff@'333333@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@(      @(333333@(      @'@(333333@(@(@(@(@(@(@(@(@(@(@(@)      @)      @(@)333333@)333333@(@(@(@)333333@)333333@)333333@)333333@)333333@)ffffff@)333333@)      @)ffffff@)ffffff@)ffffff@)333333@)@)@)@)@)@)@)@*333333@)@*      @*      @*333333@*ffffff@*ffffff@*@*@*ffffff@*@*@*@+      @*@*@*@+333333@+333333@+333333@+@+@+@+@+@+@+@+@,      @,      @,      @,333333@,333333@,333333@,333333@,@,ffffff@,ffffff@,@,ffffff@,@,@,@,@,@,@,@,@,@-333333@-      @-333333@-333333@-333333@-333333@-ffffff@-ffffff@-@-ffffff@-@-@-333333@-@-ffffff@-@-@-@-@-ffffff@-@.333333@-@-@-@.      @.      @.      @.      @.      @.333333@.333333@.ffffff@.ffffff@.@.@.@.@.@.@.@/      @/      @/      @/      @/ffffff@/333333@/ffffff@/ffffff@/ffffff@0      @/@/@0      @0@/@0@0@0333333@0L@0     @0     @0     @0@0@0     @0@0@0     @0@0     @0@0@0     @0@0@0     @033333@0fffff@1      @1333333@1333333@1L@1ffffff@1333333@1L@1     @1@1@1@1@1@1     @1@133333@133333@133333@1     @1     @2      @1fffff@133333@1fffff@2@2333333@2@2      @2333333@2333333@2L@2ffffff@2ffffff@2ffffff@2ffffff@2@2     @2@233333@2     @2@233333@233333@233333@2@2fffff@3L@3L@3L@3333333@3ffffff@3ffffff@3     @3@3@3@3@3@3@333333@3@3@333333@4      @3@333333@3     @3     @333333@3@333333@3fffff@4@4333333@4333333@4L@4333333@4@4333333@4@3     @333333@333333@3@333333@3@333333@333333@3@333333@4      @4@4@433333@4ffffff@4@4     @4ffffff@4@4fffff@4@433333@4@433333@433333@433333@4@4@4@4fffff@5      @4fffff@5333333@5L@5ffffff@5L@5ffffff@5@5@533333@5@533333@5@6333333@6333333@6      @6@6@6@633333@7      @6fffff@6fffff@6@6fffff@633333@6ffffff@6333333@6L@6ffffff@6L@6ffffff@6L@6     @6ffffff@6ffffff@6L@6L@6     @6@6     @6@633333@633333@633333@6@6fffff@6fffff@6fffff@7      @7      @7333333@7ffffff@7ffffff@7ffffff@7     @7ffffff@7ffffff@7@7fffff@8@8      @7fffff@7fffff@8      @8      @8     @8     @8ffffff@8     @8@8     @8@9      @9333333@9ffffff@9333333@9L@9333333@9333333@9@933333@9@9@9@9fffff@:@:@:ffffff@:ffffff@:     @:L@:     @:     @:     @:@:33333@:33333@:fffff@:@:@:@:@;      @;      @:fffff@:fffff@:fffff@;L@;ffffff@;     @;33333@;33333@;@;@;33333@<      @;fffff@<      @<@<333333@<333333@<333333@<@<333333@<ffffff@<L@<ffffff@<     @<     @<     @<     @<@<     @<33333@<@<fffff@<@<fffff@=L@=L@=ffffff@=     @=     @=ffffff@=@=33333@=fffff@=@=fffff@=fffff@=@=@=@=@>333333@>@>@>@>@>@>@>     @>ffffff@>     @>     @>@?333333@?@?L@?L@?ffffff@?     @?L@?     @?ffffff@?ffffff@?@?@?fffff@@      @@@@333333@@333333@@&fffff@@333333@@&fffff@@333333@@@     @@s33333@@     @@s33333@@s33333@@ffffff@@ffffff@@@@@@@@     @@33333@@fffff@@33333@@33333@@fffff@A      @@33333@A      @A      @A@A@A      @A@AL@AL@AL@Affffff@AL@AL@Affffff@A     @A@A@A@A     @As33333@A33333@Afffff@A33333@A     @A     @A     @A@Afffff@A33333@B@B@B@     @BL@B@     @BY@Bs33333@B     @Bffffff@Bs33333@B@B@B33333@B     @B@B33333@B33333@B     @Bٙ@Bfffff@Bٙ@B     @B33333@C      @C@C@C      @C@C@C&fffff@C333333@C@C333333@C@     @CY@CL@CL@Cs33333@CY@Cs33333@C     @C     @C@C@C@Cfffff@Cfffff@C33333@C33333@C33333@Cٙ@Cfffff@D      @C33333@Cfffff@Cfffff@D333333@D@     @D333333@D@     @D333333@DL@Dffffff@Ds33333@D     @Dffffff@Dffffff@D@D@Ds33333@D     @D@D33333@D33333@D33333@D33333@Dfffff@D33333@Dٙ@Dٙ@Dٙ@Dٙ@Dfffff@Dٙ@Dfffff@D33333@E&fffff@E333333@E@E&fffff@E@E@Es33333@E     @E@E     @E     @E@Efffff@Efffff@E33333@E@Efffff@E33333@Efffff@Eٙ@Eٙ@F      @F&fffff@F@F333333@F333333@F333333@F333333@F333333@F333333@F@     @FL@F333333@F333333@F333333@FL@F     @F     @F@F@F     @F@F@F33333@F     @F     @F33333@F@F     @F33333@G      @Fٙ@F33333@G      @G      @G      @G      @G&fffff@G&fffff@G333333@G@     @Gffffff@GY@G@     @G333333@GY@Gs33333@Gs33333@G@G@Gs33333@Gs33333@Gffffff@G@G@G     @G@G@Gfffff@G     @G33333@G33333@G     @G     @Gٙ@G33333@H      @H      @H      @G33333@Gfffff@G33333@H      @H@H@H      @H@HY@HY@H     @Hs33333@Hffffff@Hffffff@Hs33333@H     @H@Hs33333@H@H@H     @H33333@H@H33333@H33333@H33333@H33333@H33333@Hٙ@H@Hٙ@Hfffff@Hfffff@Hfffff@Hٙ@Hfffff@Hfffff@I      @Hfffff@Hٙ@I      @I@I333333@I@     @I333333@IL@IY@IY@Iffffff@Is33333@Is33333@I     @I@Ifffff@I@I@I@Ifffff@Ifffff@I33333@I@Iٙ@Ifffff@Ifffff@Ifffff@I33333@J@J      @J      @J      @J@JL@JL@JY@Jffffff@J     @J@Jfffff@J@Jfffff@Jfffff@J     @J@Jٙ@J@Jٙ@Jfffff@Jfffff@K      @J33333@Jfffff@K@J33333@J33333@K      @K@K&fffff@K&fffff@K333333@K333333@K333333@K@K@K@K@K@K@K@Kfffff@K33333@K@K     @Kٙ@Kٙ@K33333@L@L&fffff@L@L&fffff@L@L@L     @L     @Lffffff@LY@LL@LL@Lfffff@L@L     @Ls33333@L     @L     @L     @L@Lfffff@L@L33333@L33333@Lfffff@L33333@M      @M@M@M333333@M&fffff@M&fffff@M&fffff@M333333@M@     @MY@ML@M333333@M@     @ML@ML@MY@Mffffff@ML@Mffffff@Mffffff@MY@Ms33333@M     @M     @Ms33333@M@M@M33333@Mfffff@M@M     @M@Mٙ@M33333@M@M@Mfffff@M@N@N&fffff@N@N&fffff@N@N@N333333@NY@Ns33333@Ns33333@Ns33333@Ns33333                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ?lC?땁$/?      ?+?bM?+J?\(?bM?m?C%?E?vȴ9X?;dZ?1&?      ?zG?tj?ȴ9Xb?&x?$/?O;d?ȴ9Xb?Q?tj?333333?I^5??Z1'?vȴ9X@j~#@bM@ E@"j~#@$Y@'E@'Q@)V@,-@0h9Xb@0G+I@,kI^@/5?|@0$/@0bI^5@0-V@1r ě@-+@*}E@)O;dZ@*
n@&{lC@$|hs@#M@ bM@$/@;dZ@E@nP@1'@O;dZ@O;dZ@O;dZ@|hr@(\)@nP@S@A7Kƨ@I^5?}@1&y@vȴ9X?~"?Gz?I^5??bM?m?+I^?S?p
=q??|hs?333333?vȴ9X?I^5?}?C$?"`B?1&y?Z1'?$/?~"?tj?E?;dZ?-V?ȴ9Xb?֧-?ٺ^5?|?ؓtj~?և+I?Vu?ȴ9Xb?A7Kƨ?/v?Z1'?ӅQ?Ұ ě?ӅQ?ӥS?+?+J?r ě?+J?p
=q?͑hr ??̬1&y?xF?I^5?+?1&x?Ƈ+I?E?ǍO;dZ?
=p
?$/?1&x?\(?
=p
??|hs?333333?\(?`A7?`A7?zG{?
=p
?l?S?`A7?&x?lD?&x?GzH?7KƧ?° ě?hr Ĝ?-V?
=p?n?"`?j~"?7KƧ?333333?&x?vȴ9X?nP?5?|h?M?vȴ9X?bM?bM?A7Kƨ?bM? ěT?$/?A7Kƨ?-V?nP?`A7L?5?|h?nP?I^5??&x?vȴ9X?ěS?1&y?5?|h?dZ1?bM?
=p?nP?`A7L?7KƧ?|hr?A7Kƨ?
=p?GzH?dZ1?ěS?|hr?
=p?nO? ěT?`A7L?-V?7KƧ?hr!?vȴ9X?"`?lD?I^5??I^5??ěS?GzH?$/?A7Kƨ?$/?A7Kƨ?7KƧ?bM?GzH? ěT?GzH?GzH?lD?`A7L?-V?A7Kƨ?GzH?bM?nO;?5?|h?-V?\(?Q?$/?7KƧ?GzH?bM?;dZ?nO;?° ě?n?      ?A7Kƨ?      ?7KƧ?$/?l?hr Ĝ?A7Kƨ?nP?° ě?
=p?° ě?A7Kƨ?I^5??lD?$/?A7Kƨ?      ?-V?GzH?
=p?"`?`A7L? ěT?7KƧ?vȴ9X?&x?bM?      ?nP?tj~?I^5??ěS?A7Kƨ?-V?nP?I^5??I^5??GzH?I^5??lD?`A7?Q?GzH?GzH?n?\(?vȴ9X?-V?n?Q?° ě?I^5??I^5??n?vȴ9X?tj?öE?hr Ĝ?333333?I^5??M?I^5??lD?n?l?lD?-V?° ě?-V?      ?7KƧ?$/?&x?bM?M?&x?GzH?&x?S?° ě?n?l?Õ$/?I^5??7KƧ?ěS?
=p?-V?$/?\(?;dZ?I^5??ěS?7KƧ?lD?ěS?I^5??Z1'?Q?Q?Z1'?S?I^5??lD?hr Ĝ?333333?"`?Q?vȴ9X?I^5??$/?nP?`A7?öE?° ě?`A7?-V?7KƧ?GzH?l?`A7?nO;?nO?-V?+?$/?&x?`A7?&x?$/?l?tj~?\(?n?lD?A7Kƨ?nO?lD?`A7L?Q?bM?hr Ĝ?nO?\(?7KƧ?-V?GzH?nP?I^5??l?öE?nO;?I^5??tj~?l?nP?lD?lD?
=p?-V?\(?`A7?\(?&x?tj~?`A7?hr Ĝ?
=p?Õ$/?n?Q?tj~?+?S?+?n?\(?nO?E?$/?-V?7KƧ?bM?lD?`A7?1&y?      ?$/?nO?S?S?S?-V?I^5??I^5??l?tj~?ļj~#?333333?&x?A7Kƨ?n?Õ$/?`A7?I^5??-V?lD?° ě?
=p?nP?`A7?9XbM?l?ěS?`A7?nO?ļj~#?Õ$/?vȴ9X?S?\(?öE?9XbM?nO;?vȴ9X?Õ$/?Õ$/?Q?nO?333333?nO;?Õ$/?`A7?lD?-V?S?&x?l?Q?vȴ9X? ěT?M?ļj~#?S?Q?-V?-V?
=p?
=p?A7Kƨ?GzH?I^5??I^5??nO;?Q?M?\(?
=p?\(?n?Õ$/?zG{?`A7?° ě?nO;?l?bM?-V?lD?hr Ĝ?S?l?7KƧ?hr Ĝ?E?Q?7KƧ?° ě?
=p?M?Q?333333?nO;?
=p?nO?-V?l?
=p?nO?$/?I^5??nO?I^5??nO;?n?GzH?Õ$/?° ě?nO;?hr Ĝ?nO;?nO;?5?|h?bM?nP?
=p?lD?-V?nO;?`A7?Q?333333?333333?`A7?I^5??° ě?° ě?GzH?öE?nO?GzH?nO;?I^5??lD?Q?&x?S?ȴ9Xb?hr Ĝ?`A7?ļj~#?&x?° ě?9XbM?hr Ĝ?7KƧ?-V?
=p?+?S?ļj~#?\(?S?      ?+?lD?nO;?I^5??hr Ĝ?n?9XbM?nO?9XbM?Õ$/?7KƧ?Q?GzH?-V?`A7?Õ$/?I^5??tj?hr Ĝ?
=p?I^5??n?lD?
=p?\(?I^5??tj~?333333?
=p?GzH?`A7?M?
=p?+?+?tj~?Z1'?Q?bM?° ě?lD?/w?Õ$/?$/?$/?M?333333?\(?333333?öE?tj~?n?E?`A7?-V?-V?hr Ĝ?      ?l?9XbM?Õ$/?Õ$/?/w?
=p?M?333333?      ?hr Ĝ?l?\(?nP?
=p?Q?zG{?M?$/??|hs?M?ļj~#?Õ$/?-V?lD?;dZ?Q?° ě?E?
=p?° ě?nO;?-V?lD?S?"`?n?nO;?\(?tj~?333333?hr Ĝ?Q?tj?
=p?M?-V?l?S?l?lD?+?Õ$/?9XbM?$/?I^5??nO?&x?S?+?nO;?nO;?\(?-V?zG{?I^5??-V?nO;?7KƧ?tj~?-V?tj?nO?tj?zG{?Q?° ě?hr Ĝ?M?tj~?Z1'?öE?+?Z1'?A7Kƨ?&x?öE?-V?+?E?tj~?E?n?333333?nO;?+?l?`A7?333333?ļj~#?333333?Z1'?öE?S?l?Q?Q?`A7?° ě?nO;?;dZ?ěS?7KƧ?-V?lD?öE?Z1'?\(?-V?tj?\(?&x?I^5??nO;?lD?333333?S?tj~?S?\(?n?+?ļj~#?öE??|hs?-V?l?n?S?S?-V?+?ěS?zG{?nO;?`A7?lD?M?333333?-V?nO?GzH?° ě?zG{?° ě?Õ$/?
=p?333333?+?+?l?-V?l?9XbM?hr Ĝ?l?tj~?nO;?tj?S?I^5??`A7L?Õ$/?nO?\(?I^5??\(?Z1'?n?ěS?° ě?333333?nO;?tj~?lD?zG{?nO;?$/?333333?/w?tj~?333333?nO?-V?nO;?M?7KƧ?-V?zG{?E?ěS?&x?Ł$/?nO?tj?nO?zG{?+?° ě?l?&x?öE?E?n?S?S?tj~?S??|hs?tj~?Õ$/?tj?`A7?S?`A7?333333?šo?
=p?7KƧ?
=p?E?`A7?333333?tj?+?ěS?Õ$/?Õ$/?/w?Õ$/?tj~?\(?`A7?Q?S?333333?333333?+?`A7L?-V?333333?S?zG{?l?n?ěS?9XbM?tj?nP??|hs?l?A7Kƨ?hr Ĝ?`A7K?Q?nO?-V?\(?S?hr Ĝ?333333?l?&x?lD?-V?-V?&x?nO;?+?
=p?M?nO?nP?° ě?öE?öE?zG{?lD?nO?-V?S?öE?ļj~#?
=p?zG{?öE?`A7?nO?S?9XbM?
=p?nO;?nO;?7KƧ?
=p?+?I^5??hr Ĝ?nO?n?ļj~#?tj~?333333?Õ$/?nO?333333?Õ$/?Õ$/?nO;?GzH?lD?/w?n?GzH?S?&x?\(?° ě?hr Ĝ?l?l?7KƧ?GzH?Q?ěS?ļj~#?öE?333333?-V?/w?S?&x?&x?zG{?Õ$/?vȴ9X?-V?n?-V?7KƧ?-V?öE?° ě?`A7?7KƧ?Q?nO?-V?lD?ļj~#?\(?nO;?tj~?l?n?333333?° ě?ļj~#?öE?\(?7KƧ?
=p?&x?GzH?tj~?° ě?I^5??l?Q?Z1'?S?I^5??tj~?GzH?S?
=p?+?l?nO?333333?M?+?nO?\(?&x?S?tj~?`A7L?tj?lD?
=p?\(?A7Kƨ?hr Ĝ?+?S?ļj~#?nO?nO?nO;?ěS?M?-V?ěS?° ě?tj?/w?Q?nO?l?\(?tj?tj~?\(?+?I^5??nO?+?
=p?ěS?$/?l?öE?nO;?tj~?° ě?n?333333?Q?nO?`A7K?öE?nO?-V?`A7L?hr Ĝ?`A7?Õ$/?nO;?-V?tj~?nO;?
=p?Õ$/?333333?      ?bM?Õ$/?Q?zG{?zG{?x?ěS?l?S?ȴ9Xb?
=p?I^5??\(?nO?tj~?333333?n?S?ļj~#?tj~?° ě?nO;?&x?Q?tj~?S?333333?`A7?° ě?333333?l?S?° ě?Õ$/?9XbM?9XbM?+?Z1'?
=p?`A7K?öE?I^5??-V?hr Ĝ?Õ$/?9XbM?&x?S?7KƧ?° ě?S?Õ$/?tj~?7KƧ?° ě?S?`A7L?GzH?333333?° ě?Q?Õ$/?l?nO;?E?S?zG{?l?tj?7KƧ?tj~?S?I^5??9XbM?$/?ěS?
=p?9XbM?`A7?hr Ĝ?-V?
=p?-V?n?Õ$/?333333?hr Ĝ?+?`A7?nO;?hr Ĝ?9XbM?$/?nO?9XbM?\(?öE?`A7L?M?šo?Õ$/?tj~?+?tj?hr Ĝ?-V?tj~?tj?öE?lD?-V?l?nO;?-V?nO?I^5??zG{?9XbM?\(?zG{?333333?Q?nO?-V?lD?tj?Õ$/?l?hr Ĝ?S?333333?tj~?I^5??ěS?333333?nO?-V?-V?S?ěS?° ě?`A7?+?$/?A7Kƨ?tj~?zG{?\(?9XbM?tj?`A7L?\(?`A7L?tj?tj?333333??|hs?l?Q?Õ$/?333333?A7Kƨ?l?hr Ĝ?nP?bM?\(?+?+?I^5??&x?lD?S?l?n?lD?nO;?+?l?\(?nO?+?Q?
=p?tj?tj~?S?° ě?-V?`A7?Õ$/?`A7?l?;dZ?Õ$/?tj?l?I^5??GzH?° ě?tj~?333333?° ě?GzH?hr Ĝ?7KƧ?`A7?M?S?Q?zG{?9XbM?tj?I^5??333333?\(?333333?I^5??`A7?nO?&x?+?`A7K?`A7?9XbM?l?šo?
=p?l?+?I^5??-V?öE?$/?nO?bM?öE?nO;?nO;?öE?nO;?Q?&x?`A7?`A7?Q?GzH?nO?lD?|hr?nO;?+?`A7?l?-V?S?öE?zG{?n?nO;?-V?\(?ěS?tj~?° ě?I^5??n?-V?nO;?tj?n?-V?\(?GzH?I^5??I^5??&x?nO?ěS?&x?\(?öE?S?ěS?tj?öE?
=p?S?ļj~#?S?Õ$/?nO;?ěS?tj~?/w?I^5??tj?+?M?\(?hr Ĝ?tj?333333?zG{?`A7?I^5??M?I^5??n?-V?l?M?-V?I^5??7KƧ?M?tj~?\(?nO;?`A7?-V?-V?`A7?Z1'?ěS?-V?nO?öE?nO?`A7K?Z1'?öE?9XbM?lD?n?M?° ě?vȴ9X?hr Ĝ?nO;?\(?I^5??\(?l?+?l?7KƧ?n?Z1'?nO?M?° ě?Z1'?\(?lD?bM?M?`A7L?hr Ĝ?`A7?\(?Õ$/?tj?
=p?+?333333?nO?$/?S?lD?I^5??nO?333333?nO;?tj?n?hr Ĝ?GzH?7KƧ?7KƧ?vȴ9X?A7Kƨ?A7Kƨ?I^5??tj?Z1'?`A7?l?
=p?\(?-V?lD?nO?\(?Q?hr Ĝ?I^5??\(?+?I^5??bM?S?nP?nO?nO;?n?n?\(?tj~?I^5??+?Q?
=p??|hs?\(?-V?S?öE?n?vȴ9X?hr Ĝ?l?$/?öE?Q?7KƧ?-V?Z1'?-V?A7Kƨ?I^5??tj?M?GzH?° ě?GzH?nO?`A7?n?Z1'?l?
=p?Õ$/?nO;?-V?`A7?333333?\(?Z1'?tj~?nO;?l?333333?-V?ěS?I^5??I^5??M?`A7L?`A7?7KƧ?+?Õ$/?tj~?nO;?7KƧ?lD?$/?GzH?° ě?GzH?öE?nO;?-V?I^5??vȴ9X?333333?-V?vȴ9X?E?-V?tj~?M?
=p?Q?n?
=p?nO;?Õ$/?Õ$/?nO?I^5??\(?\(?l?nO;?7KƧ?-V?tj~?A7Kƨ?ěS?"`?$/?° ě?l?
=p?ěS?hr Ĝ?GzH?nP?vȴ9X?-V?n? ěT?;dZ?GzH?S?GzH?\(?&x?Q?"`?`A7L?M?
=p?`A7?A7Kƨ?I^5??+?vȴ9X? ěT?7KƧ?M?-V?° ě?M?n?
=p?tj~?M?&x?nO?lD?Q?Õ$/?Q?GzH?9XbM?I^5??nO?7KƧ?`A7?9XbM?\(?7KƧ?S?GzH?nO;?-V?$/?333333?Q?S?\(?l?|hr?I^5??lD?Q?A7Kƨ?9XbM?M?° ě?9XbM?nO;?/w?&x?-V?Õ$/?nO;? ěT?
=p?$/? ěT?hr Ĝ?Q?`A7L?nO;?lD?M?nO?M?nO?+?7KƧ?nO;?Q?M?l?n?Q?nO?
=p?vȴ9X?$/?l?
=p?333333?A7Kƨ?n?$/?nP?hr Ĝ?&x?nO;?-V?tj?`A7?M?
=p?5?|h?Q?      ?E?\(?;dZ?bM?"`?|hr?-V?GzH?A7Kƨ?Q?Q?S?M?A7Kƨ?/v?hr!?hr Ĝ?° ě?hr Ĝ?M?lD?\(?hr Ĝ?l?$/?`A7?nP?n?A7Kƨ?Q?$/?
=p?A7Kƨ?bM?hr Ĝ?bM?nO;?5?|h?M?&x?lD?Õ$/?lD?hr Ĝ?öE?Q?l?l?;dZ?;dZ?-V?lD?`A7?`A7L?\(?$/?bM?|hr?Q?bM?A7Kƨ?n?`A7?nO;?I^5??nP?-V?I^5??° ě?`A7L?Q?GzH?GzH?vȴ9X?j~"?p
=q?"`B?-V?hr!?A7Kƨ?lD?nP?ȴ9Xb?5?|h?l?7KƧ?A7Kƨ?I^5??333333?A7Kƨ?A7Kƨ?;dZ?`A7L?n?|hr?ěS?GzH?"`?hr Ĝ?"`?vȴ9X?vȴ9X?
=p?M?&x?A7Kƨ?      ?&x?\(?vȴ9X?nO?A7Kƨ?° ě?|hr?° ě?Q?I^5??lD?-V?hr Ĝ?
=p?7KƧ?Q?`A7L?7KƧ?S?hr Ĝ?nO?GzH?ěS?bM?nO?+?GzH?I^5??E?M?hr Ĝ?° ě?M?nO?
=p?nO;?nP?n?S?$/?I^5?? ěT?vȴ9?n?-V?nP?n?n?vȴ9X?&x?
=p?nP?Õ$/?7KƧ?Q?`A7L?nO;?$/?$/?bM?n?`A7L?M?A7Kƨ?hr Ĝ?ěS?nP?hr Ĝ?$/?nO?öE?A7Kƨ?GzH?I^5??-V?tj~?-V?Q?333333?hr Ĝ?öE?nO?`A7L?hr Ĝ?bM?Q?l?p
=q?$/?hr Ĝ?&x?tj?nO;?
=p?-V?I^5??+?`A7L?M?`A7?$/?"`?&x?M?vȴ9X?n?hr Ĝ?GzH?nP?Õ$/?S?-V?nP?|hr?GzH?7KƧ?GzH?
=p?-V?E?-V?nO;?nO?Q?333333?bM?GzH?vȴ9X?nO;?A7Kƨ?
=p?bM?bM?&x?Q?-V?|hr?&x?`A7?|hr?n?7KƧ?A7Kƨ?lD?;dZ?ěS?Q?\(?nP?j~"?7KƧ?;dZ?A7Kƨ?nP?I^5??7KƧ?Q?
=p?A7Kƨ?l?5?|h?n?$/?vȴ9X?-V?9XbM?&x?Q?nP?vȴ9X?&x?hr Ĝ?S?ļj~#?Z1'?\(?n?ěS?lD? ěT?A7Kƨ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	@L&fffff@L      @L@L333333@K33333@L333333@L@K33333@L@L@L@L@L      @L@L      @Kfffff@L@K33333@L      @K33333@K@K@Kfffff@Kٙ@Kٙ@K33333@Lffffff@L@K@K      @I@G@D      @Bfffff@Bs33333@A33333@B@Bs33333@B333333@Bs33333@As33333@AL@B@A     @A@C@     @Bٙ@Cffffff@Cfffff@D333333@D     @E&fffff@Fs33333@H      @I333333@Ifffff@J     @Ks33333@K@L@     @M      @L&fffff@M@M@Lfffff@Mffffff@M@     @M333333@Mfffff@M@N&fffff@NY@Nffffff@Nٙ@O@OL@O     @P33333@P@O     @P      @P33333@P      @P333333@PL@PL@PL@PFfffff@PS33333@P@     @PY@Pffffff@Pl@Ps33333@Pl@Pl@Pl@Pl@Ps33333@Py@Py@Pffffff@Ps33333@Py@Py@Py@Pfffff@Pfffff@P@PY@PS33333@Pfffff@P@P33333@P33333@P@P33333@P     @P     @P     @P@P33333@Pfffff@P     @Pfffff@Pfffff@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@Pfffff@P@P     @P@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@Pfffff@P@P@P@P@P@P33333@P33333@Pfffff@P@P33333@P33333@P@P@P33333@P33333@P@Pfffff@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P33333@P@P@P@P@P33333@P@P33333@P@P@P33333@P33333@P33333@P33333@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@Pfffff@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P     @P     @P@P@P@P33333@P     @P@P@P@P@P@P@P@P     @P     @P33333@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@P@P@P@Pfffff@P@P@P@P     @Pfffff@Pfffff@P@P@Ps33333@P33333@Pfffff@P@P@Pfffff@Pfffff@P     @P@P@P33333@P@P@P@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P@P@Pٙ@Pٙ@P33333@P@P33333@P33333@P33333@P33333@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pfffff@P33333@P33333@P33333@Pٙ@Pٙ@Pٙ@P@P33333@Pٙ@Pٙ@Pٙ@P@Pٙ@P33333@P     @Pٙ@Pٙ@Pٙ@P@Pٙ@Pٙ@P33333@Pٙ@Pٙ@P33333@P33333@Pٙ@Pٙ@Pٙ@P     @Pٙ@P     @Pٙ@P     @P     @P     @Pٙ@Pٙ@P@Ps33333@P     @P     @P@P33333@P     @P     @Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@P@Pٙ@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @Pٙ@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@PS33333@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pٙ@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pٙ@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pٙ@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@P     @Pfffff@Pfffff@Pٙ@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pٙ@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @P     @P     @Pfffff@P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @P     @P     @P     @P     @Pfffff@P     @P     @P     @P     @P     @P     @P     @Pٙ@Pfffff@P     @P     @P     @Pfffff@P     @P     @Pfffff@P     @Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@P     @Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@P     @Pٙ@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pٙ@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pٙ@Pٙ@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@Pfffff@Pfffff@P     @P@P@P@Pfffff@P@Pfffff@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@Pfffff@P@P@P@Pfffff@P@P@Pfffff@Pfffff@P@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@Pfffff@P@P@P@P@P@Pfffff@Pfffff@P@P@P     @Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P@P@P@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@Pfffff@P@Pfffff@P@P@P@P@P@P@Pfffff@P@Pfffff@P@P@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@P@P@Pfffff@Pfffff@P@P@P@P@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@Pfffff@Pfffff@P@P@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@P@P@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@P@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@Pfffff@P33333@P33333@P33333@P33333@P@P@P@P@P@P@P@Pfffff@P@P33333@P33333@P@P33333@P33333@P33333@P33333@P@P@P@P     @P@P33333@P@P@P33333@P@P@P@P@P@P33333@P@P@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P@P@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P@P@P@P33333@P33333@P33333@P@P33333@P@P33333@P@P@P@P@P@P@P33333@P33333@P33333@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@Pٙ@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P33333@P@P@P@P@P33333@P@P@P@P@P@P@P@P33333@P33333@P@P33333@P33333@P@P@P@P33333@P33333@P@P33333@P@P33333@P@P@P@P@P33333@P@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P33333@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P33333@P33333@P@P33333@P@P@P33333@P@P@P@P@P@P33333@P@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P@P@P@P33333@P@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P@P@P33333@P33333@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              P9                                      1                                       BCl*3R