CDF       
      pressure  T   time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20170205   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P25    CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:34.793486Z    ORIGINAL_HEADER      6CTD,20250210CCHSIOWB
#Removed 'CTDFLUOR_TSG' as it's filled with -999
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2017-06-29. CTD data from cruise 18DD20170205, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20170205. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2017-001/index.php. 
#
# The information in this file for the cruise 2017-001 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-0036.ctd
#
# Start of originator file comment header
#
#*2017/06/29 15:26:50.02
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2017/02/10 06:17:38.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 198
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : CE9F1F72
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            0.3            202.1
#       2 Temperature:CTD               deg_C_(ITS90)   5.6248         6.8697
#       3 Salinity:CTD                  PSS-78          32.78          33.8432
#       4 Sigma-t:CTD                   kg/m^3          25.7461        26.7106
#       5 Oxygen:Dissolved:CTD:Volume   ml/l            3.4            6.87
#       6 Oxygen:Dissolved:CTD:Mass     µmol/kg         147.7          299
#       7 Fluorescence:CTD:Seapoint     mg/m^3          0.66E-01       1.162
#       8 PAR:CTD                       µE/m^2/sec      0              0.3
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        7  F       ' '     2
#       6  -99   ' '        6  F       ' '     1
#       7  -99   ' '        8  F       ' '     3
#       8  -99   ' '        7  F       ' '     1
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2017-001
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P21
#    EVENT NUMBER        : 36
#    LATITUDE            :  49  38.00000 N  ! (deg min)
#    LONGITUDE           : 139  39.97000 W  ! (deg min)
#    WATER DEPTH         : 3961
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    The descent rate of the CTD was very noisy with some complete reversals
#	of direction.
#    CTDEDIT was used to remove many records corrupted by shed wakes;
#	salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Fluorescence and PAR data are nominal and unedited except that some records were
#	removed in editing temperature and salinity and a large spike in
#	fluorescence was removed from file 0032.
#
#    The Transmissivity channel was removed because of frequent shifts in values during
#	casts and large variations between values during repeat casts.
#	The data are available, by request, from the chief scientist.
#
#    NOTE: While the Fluorescence:CTD data are expressed in concentration units, they
#	do not always compare well to extracted chlorophyll samples, particularly for
#	casts far from shore. It is recommended that users check extracted chlorophyll
#	values where available.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in Sea-Bird
#	Application Note #64-2, June 2012 revision (Sea-Bird_64-2_Jun2012.pdf), except 
#	that a small offset in the fit was allowed.
#
#    The Dissolved Oxygen sensor used in files 0001, 0002 and 0016 malfunctioned so the 
#	Oxygen:Dissolved:CTD channels were removed from those files.
#
#    The Oxygen:Dissolved:CTD sensor has a fairly long response time so data accuracy 
#	is not as high when it is in motion as it is during stops for bottles. This will be
#	especially true when vertical dissolved oxygen gradients are large. To get an estimate
#	of the accuracy of the Oxygen:Dissolved:CTD data during downcasts (after recalibration)
#	a rough comparison was made between downcast Oxygen:Dissolved:CTD data and upcast 
#	titrated samples. Some of the difference will be due to problems with flushing of 
#	Niskin bottles and/or analysis errors, so the following statement likely underestimates 
#	Oxygen:Dissolved:CTD accuracy.
#
#    Downcast (CTD files) Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.25 ml/l from 0 to 125 dbar.
#	±0.2 ml/l from 125 to 400 dbar.
#	±0.1 ml/l from 400 to 600 dbar.
#	±0.05 ml/l from 600 to 1500 dbar.
#	Low by up to 0.08 ml/l below 1500 dbar.
#
#    For details on the processing see document: 2017-001-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5--- --6-- ---7--- --8---
#!Pressu Temperat Salinity Sigma-t: Oxygen Oxyge Fluores PAR:  
#!re:CTD ure:CTD  :CTD     CTD      :Disso n:Dis cence:  CTD   
#!                                  lved:  solve CTD:          
#!                                  CTD:   d:CTD Seapoin       
#!                                  Volume :Mass t             
#!------ -------- -------- -------- ------ ----- ------- ------
#*END OF HEADER
     WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @E        data_max      @E        C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     :  2   pressure                	long_name         pressure   positive      down   units         decibar    data_min      ?ٙ   data_max      @N   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      :  m   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d        $   temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?E   data_max      @4SMj   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       :     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d        l   salinity                	long_name         salinity   units         PSS-78     data_min      @@^}Vl   data_max      @AI_o   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      :     salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d       :   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @/   data_max      @s33333   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        : I\   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d          CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?(\)   data_max      ?   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      :    CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d       D   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min                 data_max      ?ə   C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       :    PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d          	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min               data_max               C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     : %4   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d       _   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( n|   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( n   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      )   data_max      )   C_format      %10d       n   latitude               	long_name         latitude   units         	degrees_N      data_min      @I  ě   data_max      @I  ě   C_format      %9.4f          n   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      aX%[\   data_max      aX%[\   C_format      %9.4f          n   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d        n   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d        n@E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     @E     ?ٙ?陙@       @@333333@      @      @      @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @4fffff@6ffffff@633333@8      @9      @:      @;      @<@=      @=@?@@      @@     @A      @A     @B      @B@B33333@C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J@J@K      @K     @L      @L     @M      @M     @N      @N@O@O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @Rl@R@S      @S@     @S     @S     @S@T33333@T     @U      @U@     @U     @U     @V      @V@     @V     @Vfffff@W@W9@W     @W     @X      @X@     @X     @X     @Yfffff@Y9@Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @\@]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`|@`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c33333@c`     @c     @c     @c     @c     @c@d`     @d     @d     @d     @d33333@e	@e      @e@     @e`     @e     @e     @f@f      @f@     @f`     @f     @f     @f     @f     @f@gFfffff@g`     @g     @g     @g     @g     @h      @h#33333@h333333@h@h     @h     @h     @i      @i      @i@     @i`     @i     @ifffff@j	@j      @j@     @j`     @j     @j     @j@j     @k      @k      @k33333@k     @k     @k     @l      @l      @l@     @l\@l     @m      @m      @m@     @m`     @m     @m     @m     @m     @m@nffffff@n     @n     @n     @n     @o      @o      @o9@o`     @oy@o@o     @o     @p      @p     @p      @p0     @p@     @pP     @p[33333@pk33333@p@p     @p     @p     @p     @p     @q#33333@q0     @q@     @qP     @qa@qfffff@q     @q     @q     @q     @q     @q     @r@r33333@rQ@r`     @rp     @r     @r     @r     @r@r@rљ@r     @s33333@s     @s      @s0     @s@     @sNfffff@sx     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t@     @tP     @t`     @tp     @t     @t     @t33333@t33333@t     @t     @t     @u      @u     @u!@u)@uQ@u`     @up     @u     @u     @u     @u     @u     @ufffff@u     @v      @v     @v      @v.fffff@vS33333@v^fffff@vp     @v     @v     @v     @v@vfffff@v     @v     @v     @w      @w     @w!@w0     @w@     @wP     @w`     @wp     @w     @w     @w33333@w@w@w     @w     @w     @x      @x     @x      @x0     @x@     @xNfffff@xh     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @xfffff@y@yfffff@y0     @y@     @yP     @y`     @yp     @y|@yfffff@y     @y     @y33333@y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @za@zs33333@zy@z@z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{fffff@{fffff@{     @{     @{     @{     @|33333@|     @|      @|0     @|@     @|P     @|`     @|k33333@|fffff@|     @|     @|     @|     @|     @|fffff@|     @}      @}     @}      @}0     @}@     @}P     @}^fffff@}p     @}     @}     @}@}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~K33333@~^fffff@~p     @~     @~     @~     @~     @~     @~     @~ٙ@~     @~fffff@     @      @0     @@     @P     @a@q@     @     @     @     @     @     @     @񙙙@@@     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @fffff@@     @     @     @     @     @     @     @     @     @     @33333@@     @     @      @(     @0     @8     @=@I@P     @X     @`     @h     @p     @x     @fffff@     @     @     @fffff@fffff@     @     @     @     @     @     @     @     @     @      @33333@33333@     @      @(     @0     @8     @@     @H     @P     @W33333@c33333@h     @p     @x     @     @     @     @@@     @     @     @     @     @     @     @     @     @33333@     @      @fffff@33333@     @      @(     @0     @8     @@     @H     @O33333@X     @`     @h     @o33333@x     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @     @@@     @      @(     @0     @8     @<     @P@X     @`     @h     @p     @x     @     @     @     @     @     @@33333@     @     @     @     @     @     @     @     @     @      @     @     @     @!@(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @33333@     @     @     @     @     @     @     @     @@     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @d@p     @x     @     @     @     @     @     @     @     @33333@33333@     @     @     @     @     @@     @     @      @(     @0     @8     @@     @Ffffff@P     @X     @`     @h     @p     @x     @     @     @33333@fffff@     @     @     @     @     @     @     @     @     @33333@     @@      @     @     @     @      @(     @/33333@Bfffff@H     @P     @X     @\@p@x     @     @     @     @     @     @     @     @     @     @͙@     @     @     @     @      @     @     @     @      @(     @0     @733333@@     @H     @P     @X@_33333@jfffff@p     @x     @33333@@@fffff@     @33333@     @     @33333@     @     @     @     @33333@     @     @      @     @     @     @      @(     @.fffff@@     @H     @P     @X     @`     @h     @p     @x     @@@     @     @     @     @     @     @     @     @     @@     @     @      @     @     @     @33333@0@8     @<@I@P     @X     @`     @h     @p     @x     @33333@33333@     @     @     @     @     @     @     @     @     @33333@     @     @     @      @     @     @     @@8     @@     @H     @P     @X     @`     @h     @p     @w33333@~fffff@@     @     @     @     @     @     @     @     @@     @     @     @     @     @33333@@     @     @      @(     @0     @8     @@     @Ffffff@Rfffff@X     @`     @h     @p     @x     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @fffff@ @     @     @     @      @(     @0     @8     @@     @H     @P     @Zfffff@`     @h     @p     @x     @     @     @     @@     @@@     @     @     @陙@     @     @fffff@@     @     @      @(     @0     @8     @@     @H     @Nfffff@`@h     @p     @x     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @ fffff@fffff@@     @     @     @     @     @@%33333@(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @Tfffff@X     @\     @`     @d     @h     @l     @p     @t     @x     @{33333@33333@@     @     @     @@@     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @33333@     @     @     @뙙@     @     @     @     @      @     @     @@     @     @     @      @$     @(     @,     @0     @333333@=33333@@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @o@t     @x     @|     @     @     @     @     @@33333@     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @33333@fffff@@     @     @      @     @     @     @     @     @     @     @fffff@$     @(     @,     @0     @4     @8     @<     @@     @D     @Hfffff@Lfffff@Nfffff@T@X     @\     @`     @c33333@i33333@l@p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@˙@     @     @     @     @     @     @     @     @fffff@fffff@     @     @      @     @     @     @     @     @     @33333@ @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @Pfffff@T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @~fffff@@     @     @     @     @     @     @     @     @@@fffff@     @     @     @     @     @     @     @     @     @     @ۙ@     @     @     @     @     @     @     @     @33333@33333@
33333@     @     @     @     @      @$     @(     @,     @0     @4     @6     @@@D     @H     @L     @P     @T     @Xfffff@Z     @hfffff@l     @p     @t     @x     @zfffff@@     @     @     @@@     @     @     @     @     @     @     @33333@     @@@     @     @     @     @     @     @     @ߙ@@     @     @     @     @     @      @@
     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @;33333@@@D     @H     @L     @P     @T     @X     @[33333@dfffff@h     @l     @p     @t     @x     @|     @fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @fffff@     @ᙙ@     @     @     @     @     @     @     @      @     @     @
@     @     @     @      @$     @,     @0     @4     @8     @<     @@     @D     @L@P     @T     @X     @\     @`     @d     @h     @j     @t     @x     @|     @     @     @     @     @fffff@     @     @     @33333@     @     @     @     @     @     @Ù@ə@˙@     @     @     @     @     @     @癙@33333@     @     @     @      @@     @     @     @     @     @      @$     @(     @,     @/33333@8@<     @@     @D     @H     @L     @P     @T     @X     @[@d@h     @l     @p     @t     @x     @|     @     @     @     @@     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @fffff@fffff@     @     @     @     @     @@      @     @     @     @     @     @     @ @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @N     @T     @X     @\     @`     @d     @h     @l     @o33333@y33333@|     @     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @@@     @     @fffff@fffff@ fffff@$fffff@(fffff@+@5@8     @<     @@     @D     @H     @L     @P     @R     @]33333@`     @d     @h     @n     @p     @t     @x     @|     @     @@     @     @     @     @     @     @     @     @fffff@     @     @     @     @fffff@@33333@     @     @     @     @     @fffff@@     @     @      @     @     @     @33333@@     @      @$     @(     @,fffff@.fffff@<@@     @D     @H     @L     @P     @T     @W@b     @d     @h     @l     @p     @t     @x     @|     @     @     @@33333@     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @fffff@33333@     @     @㙙@     @     @     @     @     @     @@     @     @     @     @     @ fffff@"fffff@(fffff@-33333@0     @4     @8     @<     @@     @D     @H     @L     @N     @Xfffff@\     @`     @b@l@p     @t     @x     @|     @33333@33333@     @     @     @     @     @     @@33333@     @     @     @     @     @@fffff@     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @      @     @     @     @     @     @      @$     @'@,     @0     @4     @6fffff@E@H     @L     @P     @T     @X     @\     @^@h@l     @p     @t     @x     @z@33333@     @     @     @     @     @     @     @     @@33333@     @     @     @     @     @     @     @     @ՙ@     @     @     @     @     @     @     @󙙙@ @     @     @     @     @     @!33333@$     @(     @,     @0     @4     @6fffff@D@H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @@     @     @     @@fffff@     @     @     @@     @     @fffff@@     @     @     @33333@fffff@     @     @      @     @     @     @     @     @fffff@!@$     @(     @,     @0     @4     @8     @:@I@L     @P     @T     @X     @\fffff@`     @d     @f     @p@t     @x     @|     @     @33333@@@     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @@	33333@     @     @     @     @     @@$fffff@(     @,     @/33333@4@8     @<     @@     @D     @H     @L     @N                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @+@ߤ?@As@'/W@\(@\(@;dZ@As@@\(@\(@@v_ح@'/W@
M;@'/W@As@@rGE9@)^@`A7@$tT@{@`A7@4J@u@N;6@X@hr @@@n@S&@҉@@N@nO@䎊@S&@m@p:@nO@䎊@n@N;6@u@X@hr @4J@4J@4J@u@u@hr @N;6@T`d@<64@<64@<64@<64@p:@T`d@nO@m@Mj@,<@`d@a@O@Z@@N@@N@@Mj@҉@҉@*0U2@Ʌoi@$/@$/@fA@O
M@`d@@,<@O
M@*0@2a|@*0@L_@*0@E@Z@Z@L_@$/@ᰉ@Ov_@Ov_@Ϫ͞@sh@fA@t@+J@@af@@@@af@sPH@@@&@@@&@sPH@O;d@@&@&@6@@Q_@^Q@u%@Xe,@a@O@+6z@4SMj@333333@"h	ԕ@qu!@2a|@*0U2@
O;dZ@	 ѷ@Ʌoi@~($x@P{@@@@@@J#9@}Vl@tj~@jd7@LI^5?@B&IR@>6z@2{m@=K@
jOv@@g@_p@8YK@D@a@@ae@@rm\@rW@w4m@zC\@x4֡b@n2X@\]ce@QN;6@=E@-U=@&@1@\@B@Ov`@RT`e@qu!@hr @ƍ@C@7@@$/@&@:)y@-
q@I^5?@$/@s@>6z@-C\@
5Xy>@lC@]cA@u!S@-@-V@`d@o @fx@WO;d@L_@@4m@7rG@+P{@iB@K]c@F]c@m\@ߊ	@Ʌoi@+I@.H@=b@O
M@-@RT`e@ߤ?@Q@g8}@|64@m(@_vȴ9@de@jfB@`d8@W
=p@1iB@,>B[@+Q@(r Ĝ@Ϫ͟@ߤ@S@v_ح@)@E@@qj@,=@@O;dZ@p
=q@hTɅ@eu@U*0@8-
@'/V@sP@a@N@E@73@:~ @0U2a|@W@TɅ@
=p@䎊r@+j@]cf@l!-w@Y>BZ@5?@ u!@nO@ݗ@.H@"@'RT`@-V@b}@Xe,@
=p@@L_@eO@g8}@IQ@sPH@mB@g&@ceO@`
qu@[6@D?@=<64@5!.@.2X@'8}H@"3@Ov_خ@C,zx@e+@Mj@Vu@H˒@u!S@:~ @VϪ@@思IQ@e@Z@@յsh@Xe,@L_@hr @̈́M:@ΤT@`A7@ΤT@Q@.2@A@ce@T`d@-
q@͞@[W>@tj~@n}Vl@k6z@ix@irGE@h@cwk@dTɆ@eF
L0@eO
@eu@dqj@dZ1@cA [@c	@bC,@a-w1@_حV@a-w1@^%@Z6C@Z6C@Zݘ@W&@WO;d@Xe+@Ye+a@T@LL_@F&I@@n@@IQ@F]cf@DS@?$tS@?$tS@7eں@333333@1@0'RT@-\@*d7@%F
L0@ 	k@ -
@	@}H@>@?@!-w1@&IQ@,VϪ@12W@4m8@6+jg@-
qv@حV@Q_@+J@t@o @!R<@@@
%@'/W@-
q@H@_o @C%@
O;dZ@
@C\@{m@iB@{@A [@
=q@1@x@L/{J@u@@R<6@5?|@Z1@㢜wk@u@߾vȴ9@?@`A7L@qu!@m@jOv@@Q@C@/V@kP@֡a@|@m\@j~@[W>6@O
M@Q@y@@IQ@o@?@qu!@zG@\(@As@(@'/W@R@'/W@q@Ƨ@5Xy>@5Xy>@4J@R@tj~@@*0U@T@'/@*0@&IR@|hs@}v@vz@u?|h@tSMj@q[W>6@f'@a-w1@]ce@[Q@ZY@ZkP|@Yb}@XbM@SZ@JqiC@G@@Dtj@Bu%F
@@     @>
(@;/V@8F]d@4#@3PH@1iB@1o@1[W>6@1-@2-V@2-V@1-@1[W>6@.O;@,q@&L/{J@$qj@"h	ԕ@]ce@kP|@U@af@*0U2@䎊@)^@*0U@#@oiDg@84֡@%2@$tS@F@Q@JL@`A7L@唯O
@7@唯O
@Gz@ce@ڹY@+@As@74@dZ@3@3@Q@-V@vȴ@*0@_F@+J@ݗ+k@)^@҈@1&x@n.@t#@o4֡a@nO;@nc	@qA [@r{m@r ě@nO;@d7@^ ѷY@\>@T,<@TɅoi@L@H9Xb@G@@L@JD@Fs@DS@C,zxl@@C@8}H@7Xe@43@49XbN@/Vϫ@&IQ@쿱[W@wkP@@@@*0@$tS@@N@hr @-
q@o @
ڹY@C\@~"@,<@唯O
@@4@m@;5X@@š@\N@7Kƨ@/V@4m@'0@v@@tSM@	@:)y@@ ѷ@oiDg@$/@I^5@~m\@z@t!-w2@r{m@p@mhr!@hr Ĝ@g8}H@bC,@Zݘ@W
=p@J#9@?@=<64@7KƧ@2a|Q@/O
M@-U=@-V@[@=K^@O
M@:)y@$tT@	k~(@@@
hr@
oiDg8@
C@
@
Z@
@N@
o@
/w@
ڹY@
Ʌoi@
jOv@
˒:*@
s@
@
&IR@
4m@
|hs@
K]@
#w@
q@
ěT@
vȴ@
oiDg@
}H˒@
xl"h	@
tSMj@
qiB@
o hۋ@
m(@
iB@
XU@
Vl!-@
T*1@
S&@
R<64@
P*0U@
H9Xb@
Em\@
B74@
6z@
.zG@
*0U2a|@
!o@
tj@
PH@
Z@
n@
o @

qu"@
{J#9@m\@s@+@!R@ ě@c	@VϪ@8}H@A [@M@iB@"`B@Q_@bM@8YJ@`d@T`d@E84@@p
=@/V@Q@3@4K@zxl"h@IQ@zG@@qu"@҈@ ѷ@F]c@˒:)@jg	@\]ce@W@U2a|@Rp:@JL_@=b@=K]@<n.@:)y@/Vϫ@(TɅ@&'@ [6@Xe,@L_@O
M@tj~@N;6@
O;dZ@	 ѷ@@@@ IQ@m\@~$@eں@C\@唯O
@@4@sPH@v_ح@s@ [7@64@Y}@I^@-@IQ@u@.H@%@6C@O
M@'/@S&@hۋq@zC\@xF]d@vFs@pD@nc	@kC]@e@a@N@]ce@[$@Xe+@T`d@Q_p@Np:~@IQ@G@@Em\@Ca@N@ATɅo@?H˒:@?H˒:@<64@73@43@0
(@-B@+jf@)@(Xy=@&@쿱[W@$tS@sP@rGE9@u%F@o hی@
-
@
u!S@
4֡a@
"h	ԕ@
A [@
|Q@
ݗ+j@
1'@
>6z@
ԕ*1@
*0U@
@
H˒:@
,@
R<6@
,<@
+j@
qi@
'RTa@
Q@
     @
yrGE8@
vȴ9X@
tj~@
s@
qu!S@
j~"@
d%1@
be+@
`d8@
`d8@
XbM@
JD@
H@
C,zxl@
A [7@
?@
=<64@
9#w@
5sg@
'-@
ߤ@@
*0U2@
S&@
hr @
!R<@

L/{@
p:@
oiDg@
@4n@
 4m9@	Vl!@	m\@	>B@	-
@	\(@	E@	MjO@	:~ @	쿱[W?@	Dg8~@	حU@	R@	;dZ@	s@	E84@	NU@	)y@	Xe@	֡a@	a@@	@	IQ@	R<6@	u%@	PH@	+j@	sh@	ݗ+k@	S&@	'/W@	'/W@	+I@	{J#9@	n.@	}ڹZ@	yrGE8@	v_ح@	u!R@	t!-w2@	rGE85@	qA [@	p:~ @	nO;@	mhr!@	m8Y@	k~($@	jOv`@	de@	`A7K@	[q@	Vt@	QN;5@	O
M;@	MjOv@	L/{J#@	J#9@	H˒:*@	GzH@	D2W@	@n@	=v@	9D@	4J@	0
(@	,>B[@	)@	)*0U2a@	&IQ@		@	R<6@	hr @	~($x@	
L/{@	ݗ+@	o hی@E@?@Q@H˒@F]d@D@iDg8@JL@8}H@	@;dZ@W>6z@JE@8YJ@@W'@ȴ9Xb@@S&@4֡b@Q@}Vl@ߤ@zG@Xy=@h	ԕ@vȴ9@IQ@u%@@@Fs@nO@ڹY@oiDg@?@n.@vȴ9X@q@l"h	ԕ@iᰉ'@irGE@g	k@ceO@_o@[q@WsPH@R䎊@P|@Ks@IoiD@H@F]cf@C$@B@?H˒:@64K@12W@-w1@*d7@%zxl"h@!.H@Ov_خ@@O;d@L_@Z@S&@Vu@L_@oiDg@ IQ@$t@~$@-
@ȴ9X@!.I@ȴ9X@Y|@g@A [@C@hr!@Dg8~@ⶮ}Vm@e@|Q@b}@fA@҈p:@͞%@m\@[W>@64@}H@sg@W@-@U2a|@1@U=@U=@q@L/{J@3@	k@'RT`@S@@@ᰉ@Fs@nO@S&@ڹY@u%F
@4m9@xl"h	@sg@qu!S@k~($@h>BZc@g@de@^҈p;@[$@Zc	@Z1'@W>6z@N+@GE84@?|hs@74m@64K@1o@-B@'&@#wk@-V@u%F@$tS@@@@zG@u@@
M:@	ԕ*@u%F@tj@o hی@ 4m9@xl"h
@kP@E@iDg8@쿱[W?@fB@B@r Ĝ@lC@,<@Z1@Ft@>@ݗ+j@ޞ@ܑN;@bM@а{@jOv@5Xy>@s@#9@@@@ߤ?@KƧ@?|h@O
M@/V@xF@ěT@쿱[W@,=@Ov_خ@wkP@u%F@@PH@@O
M@nO@Vu@L/{@#@oiDg@}E@tj~@r{m@m(@jOv`@hr Ĝ@e+a@cS@`
qu@\(\@Z1'@Xe+@W
=p@VϪ͟@Vaf@Sa@O@O
M;@L@KƧ@Em\@?|hs@>ߤ?@<64@<Z@;5Xy@7rG@5Xy=@4m8@2W@2-V@.1@,<쿱@(Xy=@&@vȴ9@,<@@rGE9@~($x@	'RTa@&I@?@:S@ڹZ@F]d@!-w2@{m@@(@Q@JL@@Z1@حV@?@D*@ӎMj@т@ѷX@`A7@`A7@As@@)^	@Ƨ-@@~@Y}@YJ@C-@3@{@a@@@,@?@`A@.H@o@ěT@%@O;d@ݗ+k@҉@:)y@u@=p
@Fs@@@n/@o h@     @y(@w1@u!R@tSMj@o@kC]@l"h	ԕ@c	@XD*@T,<@RT`d@Q@O;dZ@M%@IoiD@A7Kƨ@>ߤ?@=b@=K]@;dZ@9Y}@84֡b@6}Vl@49XbN@/r@,1&y@(TɅ@'&@&x@"`A@쿱[W@%@S@@@sP@-
q@q@p:@tj@n.@m]@+jg@ ě@t@빌~($@8}H@䎊qj@eO@	@C,@|Q@ ѷY@ڹY@حU@E@҈p:@ɅoiD@
L/@Ƨ-@\N@@C@4֡b@C-@֡a@O
M@2X@w1@*0U2a@
=p@-V@e+a@+J@ݗ+k@҉@nO@hr @O;dZ@	 @k~(@nP@{lC@xF@vFs@v+jg@u\(@u\(@rGE85@pD@nc	@kQ@dqj@`d8@]cA @[$@ZY@Y|@RT`d@QR@Q_p@OAs@H˒:*@E8YK@C$@B74@ATɅo@?H˒:@>6z@>BZc @<Z@9Y}@8YJ@74m@3g	l@)*0U2a@%F
L0@"`A@ 'RT`@-V@wkP@u%F@*0@O;d@$/@@N@bM@Mj@!R<@'/@
=p
@ݗ+@F]c@ hۋq@.H@($x@s@eں@Y|@j~@D@ hۋ@VϪ@P{@ۋq
@+a@ޞ@>@6@W>6z@Q_@D*@sPH@8YJ@`d@&@Ϫ͞@)^	@]cA@˒:)z@)^	@]cA@@g8}@s@@5Xy@D@D@D@C-@J@o@zG@0U2a|@L/{J@1@n.3@	@wkP@,<@Xe,@R<6@Fs@$tT@o @@@C%@ԕ*@ݗ+@YJ@S&@tj@$/@˒:)@{J#9@r{m@p
=q@oiDg8@ix@glC@fA@eO
@cS@c	@]ce@\(\@[6@ZY@Y+@W@Vaf@TɅoi@SZ@QX@M@Ks@G)^@D2W@B&IR@@6@=p
=@;5Xy@:)_@9D@5?|h@4m8@3g	l@2W@12W@0
(@/v@+I^@"h	ԕ@	@u@ߤ@@qu!@=K^@@Xe,@zG@:)y@Mj@
@JM@ ѷX@hr@PH@xl"h
@kP@_ح@#@䎊q@O;@@ڹ@A [@ۋq@b}@ק&@t@m@As@:@ʌL_@˒:*@ěS@&IR@@@}Vl@'0@9XbN@m\@O
M@w1@lD@*0U2a@S@
=p@3@	k@,=@=K^@@0
)@Xe,@ᰉ@Fs@ݗ+k@*0U2@nO@bM@Vu@M:@~($x@=p
@7KƧ@p:@eO@ݗ@o hی@~"@|?@zC\@vȴ9X@sMjO@poiDg8@p@o-V@oiDg8@nt@nc	@m\@kP{@jOv`@iDg8~@fA@eO
@cZ@b}Vm@a@N@_حV@]ce@W
=p@Ov_ح@JL_@F-@D*0@ATɅo@=b@>vȴ9X@=<64@:)_@9D@7Xe@1-@0'RT@.2X@-B@*͞&@(TɅ@'&@#S&@U=@Ov_خ@wkP@@Xe,@sh@4J@'/@u%F@$/@@I^5@H˒@hr@H˒@G{@73@Y|@SMj@PH@{m@iDg8@빌~($@Q@C]@C]@fB@>BZc@fffff@8}H@7@|Q@ޞ@]ce@ڹY@e+@sPH@l!-@a@O@R@䎊@v_ح@*0@@S&@}H@Xe@E@?|h@9XbN@J@m\@-@o@'RT@1@0
@L/{J@S&@.H@1&@kP|@Xe,@@xF]@ ѷ@p:@+I@S&@%2@b}V@}ڹZ@|PH@z@xl"h	@xF]d@v_ح@u\(@u%F
L@s@ql@mC\@kP{@glC@eO
@dZ1@d%1@b}Vm@_Ft@]+j@]ce@Xy=c@W@W@W@W>6z@TɅoi@S&@Q_p@P*0U@O͞@J#9@H˒:*@F
L/@E84֡@?@>BZc @<Z@<64@9D@9#w@6C-@6z@43@3ߤ@2m\@12W@.2X@)y@'-@'-@%u@"3@-V@u"@ߤ@@PH@PH@PH@_F@$tS@$/@zG@ݗ+k@ݗ+k@@N@hr @rGE9@Mj@@~($x@L_@҈@
L/{@_o@$/@{J#9@@ $tS@ $t@ J#9@ "`@ 1@ Y|@ D@ A [@ \@ JL@ @ lC@ fffff@ ,<@ `A7L@ +a@ 7@ A [@ C,@ e+@ ҈p;@ $@ ٳ|@ e+@ >6z@ E@ ,<@ m@ ҽ<64@ ҈p:@ Ϫ͞@ ˒:)z@ ɅoiD@ @ K]c@ @@ @@ y@ E84@ @ ǮzH@ @ 4m@ H˒:@ Z@ 5Xy@ ~@ )@ ?@ Xy=@ '0@ g	l@ 2W@ 
(@ ᰊ@ &x@ 
qv@ 6z@ lD@ Xy=@ RT`e@ ?@ S&@ 3@ R<6@ [6@ Q@ Ov_خ@ u"@ 1&@ qu!@ _F@ @ sh@ L_@ O
M@ zG@ ҉@ N;6@ -
q@ qi@ @ C%@ Fs@ tj@ F]c@ :S@ }H˒@ |?@ {J#9@ z@ u!R@ sMjO@ rGE85@ p
=q@ kC,z@ iB@ irGE@ g8}H@ f,<@ d%1@ _o@ ]cA @ ]/w@ \>@ \]ce@ ZY@ YJE@ W>6z@ Vl!-@ Xy=c@ W@ Vl!-@ U2a|@ SZ@ OAs@ M5Xy>@ JD@ KƧ@ K)^	@ IoiD@ GzH@ Fs@ F?@ E@ B@ BZc@ @C@ <쿱[@ ;/V@ 73@ 5?@ 1o@ /Vϫ@ ,q@ +jf@ *0
@ '/V@ "3@ !-w1@ Ov_خ@ wkP@ ߤ@@ ߤ@@ S@ kP|@ @ +J@ $/@ *0U2@ :)y@ N;6@ $tT@ hr @ rGE9@ 
M:@ L_@ 
ڹY@ oiDg@ ?@ @ @ o hی@ n.@ @4n@ I^5?\N<?!.H?PH?~$?䎊q?1.?`A7L?Z?҈p???ۋq?b}?+?D*?E                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @@^}Vl@@^'@@^m\@@^m\@@^m\@@^ȴ9X@@^t@@^m\@@^ȴ9X@@^ȴ9X@@^ȴ9X@@^m\@@^t@@^ȴ9X@@^t@@^t@@^m\@@^m\@@^ȴ9X@@^t@@^ȴ9X@@^A@@^t@@^ȴ9X@@^ȴ9X@@^t@@^ȴ9X@@^m\@@^t@@^ȴ9X@@^ȴ9X@@^ߤ?@@^&I@@^&I@@^m\@@^ȴ9X@@^ȴ9X@@^t@@^ȴ9X@@^m\@@^ȴ9X@@^m\@@^&I@@^t@@^ȴ9X@@^ȴ9X@@^ȴ9X@@^t@@^ȴ9X@@^m\@@^m\@@^ȴ9X@@^ȴ9X@@^m\@@^&I@@^@@^ߤ?@@^&I@@^ߤ?@@^&I@@^m\@@^ȴ9X@@^ߤ?@@^ߤ?@@^&I@@^&I@@^&I@@^&I@@^&I@@^&I@@^m\@@^m\@@^&I@@^&I@@^ߤ?@@^&I@@^@@^&I@@^ߤ?@@^m\@@^&I@@^@@^ߤ?@@^ߤ?@@^@@^ߤ?@@^ߤ?@@^@@^&I@@^m\@@^&I@@^ߤ?@@^@@^ߤ?@@^ߤ?@@^@@^&I@@^ȴ9X@@^ȴ9X@@^A@@^t@@^Ϫ͟@@^҈p;@@^҈p;@@^҈p;@@^Ϫ͟@@^]cf@@^ߤ?@@^x@@^x@@^x@@^]cf@@^"@@^ߤ?@@^Ϫ͟@@^҈p;@@^҈p;@@^t@@^ȴ9X@@_E84@@q7KƧ@@4K@@W>6z@@ѷX@@u!S@@C,z@@n.3@@@@#w@@1'@@T`d@@߱[W>@@k~(@@'/@@@@垃%@@2X@@$xG@@	k~@@Q@@b}@@ᰉ'@@Q_@@齥@@ae@@o hی@@k~(@@e+a@@TɅo@@	k@@{@@&x@@e+a@@N;5@@rGE8@@@@'RTa@@B@@n.@@B@@_o@@Y}@@	 @@Ov`@@e+@@M@@nO@@꩓@@ڹY@@꩓@@T`d@@h	ԕ@@꒣S&@@>B@@fB@@C,z@@)^	@@9@@C%@@9@@MjO@@S@@S@@P{@@W>6z@@g	l@@{J#9@@@@a@O@@Ƨ@@
=p@@g@@L_@@tj@@ߤ@@@ߤ@@@C]@@lC      @@M:@@SMj@@M:@@VϪ@@]ce@@j~#@@m8@@SMj@@C,zx@@*1@@#@@#@@zG@@~($x@@tSM@@]ce@@VϪ@@섵?@@~($x@@o h@@#@@웥S@@>B[@@?|h@@($x@@p:~@@iB@@Fs@@qi@@%@@+J@@Fs@@$t@@fffff@@l!-@@@@x@@!.I@@@@@@8}H@@;dZ@@O
M@@b}V@@U=@@H˒:@@U=@@	k@@#@@	ԕ+@@#@@     @@-@@;dZ@@NU@@A7K@@73@@*0@@@@[6@@[6@@hۋq@@|@@u!@@[6@@A7K@@-
q@@'RT`@@𖻘@@
=q@@4m@@@@@
(@@F@@C@@C@@C@@_p@@TɅo@@o hی@@񂩓@@~($@@@@R<6@@_o@@Ov`@@=p
@@d7@@򅇓ݘ@@wkQ@@>B@@n@@,<@@m\@@=K^@@\N@@s@@A [@@@@@@!-w2@@`d@@e@@'0@@m\@@+j@@U=@@1@@@@!R<@@iB@@@@T@@A@@t@@&I@@'@@&I@@y@@vȴ9@@@@˒:)@@@@䎊r@@D*@@Xy=@@9Xb@@4֡b@@@@rGE@@ [7@@=b@@Gz@@TɅo@@ae@@k~(@@o hی@@x@@o hی@@R<6@@@@N;6@@ᰉ'@@s@@䎊@@@4n@@JL@@}Vm@@Y@@g	@@ᰊ@@S&@@sP@@nP@@&@@"`B@@"`B@@fB@@D@@~@@74@@c	@@~@@u%@@s@@33333@@6z@@33333@@@N@@n.3@@q@@Q@@PH@@g8}@@~($x@@cA \@@64@@Q@@L_@@1&y@@1&y@@Q@@C,zx@@I^5?@@cA \@@tSM@@*1@@j~@@*0@@u"@@Z@@@@IQ@@H˒@@\(@@Ϫ͞@@cA @@8YK@@,=@@$/@@?@@_ح@@vȴ9X@@@@ߤ?@@|hs@@/V@@+j@A *0U@A 73@A oiDg8@A tj@A n@A {@A `A7@A \)@ArGE@A:S@Ab}@A'RTa@Al@A@A@A"`@A@A䎊@A3@AW'@Au%F
@A@4@A0
@A>B@AڹY@APH@A@N@Ajf@AxF]@AU=@A@A64@A?@AtSM@AwkP@A쿱[@Au"@Au@A!.H@A+a@A2a|@A`A7L@Azxl"h@Ahr!@An/@A1.@A+J@A+J@AO;@A}Vl@A
=p@AH˒:@A	@AO;d@A$tS@A-V@A?@Ar@A@A@A-
q@AXy=@AeO@A|@A
=q@Ap:@A4֡b@A		k~@A	rGE@A	&x@A	:S@A	:S@A	Dg8~@A	N;5@A	Gz@A	Q@A	TɅo@A	x@A	u@A	s@A
	 @A
)y@A
a|Q@A
xl"h
@A
L_@A
wkQ@A
Y@A
@A
`A@A
sP@A)^	@A9@A@N@A@N@AZ@An.3@AS@A*0U2@AZ@A~($@A6@A6@A|@Ag@A@A\N@A2W@Am8@AN;@A@A
IQ@A
L_@A
Vl!@A
jOv@A
M:@A
+j@A
H˒@A
!.@A
L/@A5?|@AL/{J@AFs@Aȴ9X@A]cf@AC-@Aߤ?@A1@A쿱[W@AFs@AFt@A'/W@AE84@AH˒:@Ao@Ao@A$tS@A+@A
qu@A'RT`@AeO@A-
@AU@A{@A@@AF@A)^@Ae+@AC@A$/@AN;5@A~($@A@Ae@A.H@A䎊@A-V@A3@A:)y@AC\@AC\@AZc@AW@As@A)^	@A6z@AS@Aq@Aߤ@Am]@AE@Aa@O@A|@A҈@A$@AJ@A(\@ASMj@AtSM@A?@Au"@AE@Aqu"@A/w@A/w@AL_@AY|@Ap
=@A}H@Ahr!@A=K@Av@AH˒@A8Y@A
qv@AS@AE@ABZc @AE@AOv_خ@Afffff@AiB@AiB@Afffff@A-@A2X@A'@Aߤ?@Am\@Am\@AA@A@A)^@A,@A;dZ@AH˒:@Ay@AO;d@A͞@Avȴ9@Ao @AحV@ArGE9@A@A-
q@AD*@AXy=@AbM@Ahۋq@Au!@A|@A@A)^@A	k@A+@AQ@Ak~(@A@AB@A|@A@AD@A_o@A1'@A3@AC\@AM@AM@Aa|Q@Aݘ@AL_@Avȴ@A䎊q@A~@Au%@A,zxl@Aqu!@A@A~$@A:)z@Awk@Aq@A|@A҈@AlC@A$@A\N@AxF@Atj@A,<@A64@AC,zx@AM:@A`d@Am8@AzG@A#@Aqj@A_@A쿱[@A?@A>B[@AJM@AD@Ae@Ae@Ao i@AL_@Ace@Asg@A$/@Aw1@A$/@AڹZ@A=K@A\(@A_o @A5?|@A8YJ@A?@AE@AiB@A@A}Vl@A6z@A'@A@A@AXe@A,@A>6z@AKƧ@AH˒:@ART`e@AU=@AsPH@Aݗ+@A͞@A?@A?@A3@Avȴ9@A+@A;dZ@A }H@A :~ @A :~ @A hۋq@A -
@A 4m@A ěT@A D@A ҈p@A!_p@A!*0U2a@A!0
)@A!7KƧ@A!:S@A!Gz@A!XbM@A!rGE8@A!~($@A!'RTa@A!^5?}@A!N;6@A!@A!ᰉ'@A!lD@A"s@A"䎊@A"3@A"M@A"T`d@A"Zc@A"h	ԕ@A"u%F
@A"L_@A"S&@A"S&@A"@A"}Vm@A"<64@A"W@A"W@A",<@A"ڹY@A"c	@A"~@A#'/@A#C,z@A#&@A#,zxl@A#33333@A#@N@A#Z@A#{J#9@A#Q@A#Mj@A#q@A#6@A#%2@A$J@A$1&y@A$Q@A$<쿱@A$Fs@A$Z1@A$cA \@A$wkP@A$o h@A$qj@A$3@A$Ʌoi@A%*0@A%!.H@A%?|h@A%B@A%sg@A%ڹZ@A%+j@A%U=@A%@A%@A%S@A%
qv@A%ᰉ@A&_o @A&@A&$/@A&.2@A&($x@A&H@A&s@A&}Vl@A&@A&Fs@A&O;@A&@A&}Vl@A&2X@A&ߤ?@A')^@A''/W@A'4֡a@A';dZ@A'KƧ@A'O
M@A'_o@A'iDg8@A'v_ح@A'v_ح@A'&@A'kP@A'͞@A'[W>@A'@A'K]d@A'o @A'fA@A';dZ@A'@A('RT`@A(>BZc@A(D*@A(Xy=@A(eO@A(|@A('RT@A(-
@A(IQ@A(p:@A(p:@A(ۋq
@A({@A)	k~@A)@A)rGE@A)+@A)@A)@A)4J@A)7KƧ@A)TɅo@A)[W>6@A)ae@A)o hی@A)|Q@A)~($@A)o@A)R<6@A)(@A)l@A)l@A)B@A)B@A)'R@A)^5?}@A)@A)N;6@A)>BZ@A)Y}@A*	 @A*1'@A*#9@A*&IR@A*3@A*=p
@A*@4n@A*GE85@A*T`d@A*d7@A*nO@A*xl"h
@A*ݘ@A*S&@A*S&@A*g	@A* ě@A*n@A*G{@A*~@A+'/@A+PH@A+C,z@A+"`B@A+9@A+MjO@A+MjO@A+P{@A+P{@A+g	l@A+tj~@A+eO@A+U=@A+S@A+~($@A+a@O@A+|@A+|@A+a@@A,ߤ@@A,xF@A,J@A,!-w2@A,9XbN@A,I^5?@A,Fs@A,I^5?@A,PH@A,g8}@A,?@A,*1@A,S@A,zxl"@A,1&@A,#x@A,7@A,Ʌoi@A,Z@A,!-w@A,e@A-:@A-[@A-!.H@A-5Xy>@A-?|h@A-B@A-O;dZ@A-fA@A-ce@A-p
=@A-w1@A-ڹZ@A-M:@A-hr!@A-%@A-%@A-v@A-1@A--V@A-cA @A-,=@A-oiDg@A-!.@A. ѷY@A.
(@A.u@A.8YJ@A.Vu@A._ح@A.p:~@A.p:~@A.vȴ9X@A.IQ@A.+J@A.Fs@A.@A.@A.2X@A.2X@A.m\@A.A@A.҈p;@A.+@A.ߤ?@A.C-@A.Mj@A/v@A/!-w1@A/8}H@A/KƧ@A/O
M@A/b}V@A/lC@A/v_ح@A/	@A/&@A/r@A/vȴ9@A/˒:)@A/+@A/حV@A/fA@A/;dZ@A/rG@A/Vϫ@A/-@A/rGE9@A0	ԕ+@A0}H@A0@A0}H@A073@A04m9@A0>BZc@A0D*@A0D*@A0Q@A0NU@A0l"h	@A0˒:*@A0n@A0IQ@A0@A0@A0ѷX@A0@@A0ѷX@A0F@A0@A0{@A0C@A0C@A0PH@A1rGE@A1-w1@A1Dg8~@A1TɅo@A1[W>6@A1hr @A1b}@A1R<6@A1'RTa@A1X@A1^5?}@A1o@A1o@A1y@A1y@A1N;6@A1@A1ᰉ'@A1e@A1s@A1.H@A2I^5@A21'@A21'@A20U2a|@A26C@A2:)y@A2M@A2Zc@A2^5?|@A2^5?|@A2h	ԕ@A2h	ԕ@A2nO@A2~"@A2L_@A2ᰊ@A2S&@A2wkQ@A2S&@A2Y@A2`A@A2G{@A2 ѷ@A2fB@A2c	@A2D@A2~@A3҉@A3"`B@A3)^	@A3@N@A3Z@A3g	l@A3qu!@A3{J#9@A3Q@A3q@A3Mj@A3ߤ@A3wk@A3q@A3@A3~($@A3Ƨ@A3Q@A3
=p@A3
=p@A3C]@A4ߤ@@A4L_@A4ߤ@@A4Q@A4,<@A49XbN@A4<쿱@A4?@A4M:@A4m8@A4?@A4#@A4*1@A4*1@A4_@A43@A41&@A41&@A4?@A4[W?@A4*0@A4>B[@A4JM@A4e@A4E@A5'0@A5[@A5*0@A5Q@A5%F
L@A5/w@A584֡@A5IQ@A5L_@A5`A7L@A5p
=@A5$/@A5O
@A5v@A51@A5n/@A5n/@A5cA @A5@A5
qv@A5(@A5E@A5!.@A6_o @A6zG@A6@A6u@A6.2@A68YJ@A6?@A6R<6@A6c	@A6iB@A6iB@A6l!-@A6fffff@A6l!-@A6z@A6IQ@A6@A6-@A62X@A6'@A6@A6ߤ?@A6t@A6Ϫ͟@A61@A6@A6Mj@A7 hۋ@A7@A7
=p@A7
=p@A7)^@A7@A71@A7;dZ@A7;dZ@A7As@A7As@A7Xe,@A7eں@A7eں@A7eں@A7iDg8@A7lC@A7|hs@A7ݗ+@A7$tS@A7-V@A7?@A7[W>@A7/V@A7@A7حV@A8     @A8@A8
qu@A8bM@A8bM@A86@A8'RT`@A8D*@A8H@A8NU@A8K]c@A8Q@A8[6@A8_F@A8bM@A8oiDg8@A8y=c@A8YJ@A8@A8-
@A8-
@A8
=q@A8{@A8U@A8)@A8TɅ@A8ѷX@A8҈p@A8{@A8{@A8$tT@A9@A9@A97KƧ@A9:S@A9A [@A9Q@A9^@A9hr @A9e+a@A9k~(@A9k~(@A9u!S@A9@A97Kƨ@A9@A9u@A9B@A9D@A9ԕ*@A9y@A9ԕ*@A9N;6@A9>BZ@A9.H@A9.H@A:n@A:e+@A:@A:䎊@A:3@A:@4n@A:M@A:W'@A:Zc@A:nO@A:u%F
@A:u%F
@A:u%F
@A:ݘ@A:S&@A:\(@A:vȴ@A:Y@A:n@A:@A:W@A:W@A:͞&@A:sP@A: ѷ@A: ѷ@A:C,@A;S&@A;nP@A;s@A;C,z@A;	@A;)^	@A;33333@A;9@A;=K^@A;C%@A;W>6z@A;]cA@A;dZ@A;n.3@A;qu!@A;tj~@A;~$@A;{J#9@A;~$@A;eO@A;q@A;eO@A;$@A;Z@A;Ƨ@A;a@@A;
=p@A;$@A;g@A;C]@A;$@A;@A;\N@A<J@A<1&y@A<@A<!-w2@A<tj@A<tj@A<Q@A<,<@A<64@A<9XbN@A<?@A<C,zx@A<PH@A<VϪ@A<Z1@A<VϪ@A<q@A<tSM@A<wkP@A<zG@A<C@A<S@A<3@A<3@A<1&@A<@A<#x@A<j~@A<?@A<*0@A<*0@A<>B[@A<JM@A<hr@A<hr@A<D@A<D@A<E@A=u@A=*0@A=Q@A=%F
L@A=2a|@A=+a@A=+a@A=<64@A=B@A=IQ@A=Y|@A=ce@A=sg@A=p
=@A=}H@A=ݗ@A=!R@A=+j@A=Xy=@A=Xy=@A=1@A=@A=@A=H˒@A=8Y@A=cA @A=Ϫ͞@A=b@A=?@A=
qv@A=S@A=ᰉ@A=(@A>_o @A>u@A>Ov_@A>!R<@A>5?|@A>;5X@A>?@A>E@A>H@A>H@A>iB@A>c	@A>c	@A>iB@A>p:~@A>s@A>z@A>IQ@A>+J@A>@A>,<@A>T@A>'@A>@A>ߤ?@A>ȴ9X@A>A@A>҈p;@A>Ϫ͟@A>]cf@A>쿱[W@A>쿱[W@A>Mj@A>Fs@A>"@A>!.I@A>!.I@A?)^@A?'/W@A?4֡a@A?4֡a@A?;dZ@A?>6z@A?;dZ@A?E84@A?KƧ@A?RT`e@A?\(@A?lC@A?b}V@A?{J#:@A?$tS@A?&@A?	k@A?͞@A?r@A?r@A?/V@A?@A?˒:)@A?@A?@A?䎊r@A@@A@bM@A@@A@6@A@ ě@A@1&x@A@:~ @A@A7K@A@H@A@Xy=@A@Xy=@A@bM@A@eO@A@y=c@A@n@A@n@A@'RT@A@@A@u%F@A@@A@{@A@4m@A@TɅ@A@@@A@ěT@A@p:@A@ۋq
@A@҈p@A@e+@A@@A@C@A@\)@A@\)@A@{@A@\)@A@PH@AA$/@AA@AA@AA@AA [7@AA@N@AA_p@AA&x@AA4J@AAA [@AADg8~@AAN;5@AAXbM@AAae@AAk~(@AAo hی@AAo hی@AArGE8@AAu!S@AAu!S@AAx@AA@AA~($@AA7Kƨ@AA'RTa@AA@AAn.@AA(@AA(@AAB@AA@AAN;6@AAR@AA-@ABn@ABu%F@AB@ABe+@AB#9@AB1'@AB)y@AB&IR@AB0U2a|@AB:)y@ABC\@ABJL@ABQ_@ABW'@AB^5?|@ABh	ԕ@ABnO@AB~"@AB@4@ABݘ@ABᰊ@AB0
@ABwkQ@AB@ABW@AB`A@AB`A@ABڹY@ABsP@ABC,@ABm@ABm@AB~@AB~@AC҉@AC҉@AC'/@ACPH@AC"`B@AC)^	@AC,zxl@AC)^	@AC)^	@AC,zxl@AC6z@AC=K^@ACC%@ACJ#9@ACP{@ACZ@AC]cA@ACdZ@ACg	l@ACjf@ACn.3@AC{J#9@AC@ACxF]@ACQ@AC*0U2@AC@AC@ACa@@ACa@@AC
=p@ACQ@AC҈@ACݗ+k@AC҈@AClC@AC%2@ACC]@AC@AD1&y@ADL_@ADtj@ADQ@AD(\@AD(\@AD?@ADVϪ@ADj~#@ADq@ADg8}@ADq@ADwkP@ADwkP@AD#@AD*1@ADC@AD_@AD3@AD_@AD3@ADzxl"@ADO
M@AD@AD#x@AD?@ADɅoi@AD>B[@AD/@AD@ADZ@ADZ@ADe@AEo i@ADe@AEV@AEu@AEV@AEV@AE[@AEQ@AEQ@AE(@AE(@AE/w@AE<64@AE<64@AEF
L0@AEO;dZ@AEY|@AE`A7L@AEfA@AEfA@AEm\@AEsg@AE}H@AEzxl"h@AE}H@AEM:@AEݗ@AE!R@AEO
@AEv@AE@AEv@AE-V@AEH˒@AE@AEcA @AE@AEb@AE?@AE?@AE
qv@AES@AE(@AE(@AEoiDg@AEᰉ@AEoiDg@AE!.@AEڹ@AEڹ@AFt@AF_o @AF
L/@AF4K@AF4K@AFu@AFu@AF+jg@AF5?|@AF8YJ@AF?@AFE@AFH@AFOv_خ@AFR<6@AF\N<@AFfffff@AFvȴ9X@AFIQ@AFIQ@AF%@AF+J@AF%@AFFs@AFqi@AF@AF$t@AFO;@AF,<@AFaf@AF2X@AFQ@AF2X@AFQ@AFm\@AFt@AFȴ9X@AFȴ9X@AFȴ9X@AFA@AFߤ?@AFC-@AF1@AF쿱[W@AFMj@AF@AF@AFMj@AF쿱[W@AF@AG hۋ@AG
=p@AG
M;@AG)^@AGv@AGXe@AG$tS@AG.H@AG+I@AG.H@AG8}H@AG;dZ@AGAs@AG8}H@AG>6z@AGRT`e@AGRT`e@AGU=@AG\(@AGeں@AGo@AGlC@AGlC@AGo@AG|hs@AG4m@AGy@AG&@AG&@AG	@AG@AGO;d@AGݗ+@AG$tS@AG-V@AG	k@AG?@AG?@AGzH@AG3@AG/V@AGK]d@AGfA@AGحV@AG@AGحV@AG䎊r@AGVϫ@AG+j@AG+j@AH	ԕ+@AHbM@AH*0U@AH6@AH-
q@AH$xG@AH*0@AH1&x@AH:~ @AH73@AHK]c@AHNU@AHU2a|@AHU2a|@AHXy=@AHU2a|@AHbM@AHeO@AHl"h	@AHbM@AHhۋq@AHhۋq@AHr Ĝ@AH|@AH˒:*@AHYJ@AH-
@AH@AH@AHIQ@AH
=q@AH
=q@AH-
@AH
=q@AHU@AH)@AH
(@AHěT@AHTɅ@AHѷX@AHF@AHe+@AH	k@AH{@AH\)@AH\)@AH$tT@AI@N@AI@N@AI [7@AI#w@AI&x@AI#w@AI&x@AI#w@AI7KƧ@AI:S@AI:S@AIGz@AIGz@AIN;5@AIN;5@AIGz@AIQ@AI[W>6@AI[W>6@AIae@AIrGE8@AIo hی@AIu!S@AIb}@AI@AI@AIb}@AI|Q@AI7Kƨ@AI7Kƨ@AI~($@AI7Kƨ@AI@AIB@AIB@AIB@AI|@AI^5?}@AI^5?}@AID@AID@AID@AI_o                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @s33333@s     @s@r     @s      @s      @r     @r񙙙@rfffff@r33333@r陙@rfffff@r33333@r33333@rfffff@r@r33333@rfffff@rfffff@r     @rfffff@r33333@r     @r@rfffff@r@r񙙙@r     @rfffff@r@r񙙙@rfffff@r@r33333@r@r33333@r     @r33333@r     @rfffff@r@r@rfffff@r     @r     @rfffff@r陙@r33333@r     @r陙@r陙@r@r陙@r陙@r33333@r33333@r@r@rfffff@r@r     @r@r     @rfffff@rfffff@r     @r@r33333@r33333@rfffff@r     @r@r33333@rfffff@r     @rᙙ@r     @rᙙ@rᙙ@r     @r陙@r陙@r     @rfffff@rfffff@r     @r     @r陙@r     @r陙@rfffff@r33333@rfffff@r33333@r@rfffff@rfffff@r     @r33333@r     @r     @r陙@r陙@r陙@r     @rfffff@r33333@r@r33333@r     @r     @rٙ@rfffff@r@r@rfffff@r33333@r33333@rfffff@r     @r     @p@o33333@n)@l33333@jfffff@j     @ifffff@i     @i     @ifffff@ifffff@i     @ip     @iY@i333333@i33333@h@h@h@h@hfffff@h@hə@h@hfffff@h@hfffff@h@h33333@h@h33333@h@hfffff@hc33333@hL@h9@h,@h,@h33333@h33333@g@g@gٙ@g     @gfffff@gs33333@gVfffff@g@     @g0     @g@g      @f33333@f@f33333@f     @fs33333@fc33333@fffffff@fc33333@fI@f)@f33333@ffffff@e@e@efffff@e     @e@e|@eFfffff@e     @dٙ@d@dfffff@dp     @d`     @dY      @d@c陙@c33333@c@c33333@cl@cY@cFfffff@c9@c#33333@cfffff@bfffff@b@b33333@b33333@b33333@bfffff@b     @bl@bVfffff@b<@b      @a陙@a     @a<@`     @`ٙ@aFfffff@a@`@`     @`|@`c33333@`Ffffff@`&fffff@_fffff@_@_     @_fffff@_s33333@_S33333@_      @^fffff@^33333@^@^     @^`     @^33333@^     @^,@]33333@]@]l@]S33333@]      @\fffff@\@\@\`     @\333333@[@[     @[S33333@[      @Z@Z33333@Z@Z@Y     @Yfffff@Y     @Yffffff@YS33333@Y@     @Y9@Y,@Y&fffff@Y@Y33333@X@X     @X@Xy@Xl@XY@X333333@W@W     @W33333@W     @Wffffff@WFfffff@W9@W      @W@W33333@Vٙ@V@Vfffff@VS33333@V@     @V@     @V,@V@U     @Ufffff@U@U33333@Ufffff@Ufffff@U33333@Us33333@UFfffff@U@T@Tfffff@T     @T@T@T@TS33333@T&fffff@Tfffff@S@Tfffff@Sfffff@S     @S@Sfffff@Sfffff@S@Sfffff@Sfffff@S33333@Sfffff@S     @S@S     @Sy@S     @Sy@Sffffff@S`     @SY@SY@S`     @Sffffff@S333333@S&fffff@S33333@S      @S      @R@Rfffff@Rٙ@R33333@Rfffff@R@Rfffff@R33333@Rfffff@Rfffff@Rfffff@R33333@R@R@Ry@Rs33333@Rfffff@Rfffff@Ry@Rffffff@R`     @RY@RY@RS33333@RFfffff@R@     @R333333@R@     @R333333@R33333@R@R33333@R@Rfffff@Rfffff@Q33333@Qfffff@Q@Q     @Q     @Q     @Q@Ql@QS33333@QS33333@QFfffff@QFfffff@Q333333@Q@Q@Q      @Qfffff@P@Pfffff@Pfffff@P@P     @P33333@Py@Pffffff@Pffffff@PS33333@P9@P&fffff@Pfffff@O@O33333@O@OY@OY@Offffff@OL@O@     @O&fffff@N33333@N@Nfffff@N33333@Ns33333@NY@N@M33333@M@M@M@Ms33333@MY@ML@M@     @M333333@M@M@     @M&fffff@L33333@L33333@L33333@L33333@L     @L     @Ls33333@LL@L@L      @K@K     @KY@K@     @K      @J33333@J33333@J     @J33333@Jfffff@Js33333@JL@J333333@J@J      @I@I33333@I@Is33333@IL@I@     @I@H33333@I@I      @Hfffff@H@H33333@Hfffff@Hfffff@Hfffff@Hfffff@H     @H333333@H333333@H@Gٙ@G     @G33333@Gfffff@Gs33333@G@G@G@Gs33333@GL@GY@GL@G@F33333@Ffffff@Fٙ@F@F     @F33333@F@F@F     @F@F@Fs33333@F&fffff@F&fffff@F@E@E@E@Es33333@Es33333@E@E     @E@EL@E@E@E@Dfffff@Dfffff@D@D     @D     @Dٙ@D33333@Dfffff@Dfffff@D@D@D@D     @D@Dffffff@DL@D@C33333@Cfffff@Cٙ@C     @Cٙ@C@C@Cٙ@C     @C@CY@C@C@     @C333333@C333333@C@C@C@C      @C@B33333@B@B@B@B     @B@Bs33333@B@B     @BY@BL@B@B@B@     @B&fffff@B@B@B      @Aٙ@A33333@A     @Afffff@A33333@A@A33333@A33333@Afffff@As33333@As33333@Affffff@AY@As33333@Affffff@AY@AL@A@     @A333333@A@     @A&fffff@A@A&fffff@A@A@A@@33333@@ٙ@@@@ٙ@@     @@fffff@@33333@@33333@@@@s33333@@ffffff@@s33333@@Y@@L@@L@@L@@@     @@333333@@&fffff@@@@@@      @@@@@@@@      @@      @?33333@?@?L@>fffff@>@>L@>ffffff@>ffffff@>@>      @>333333@>      @>333333@=fffff@=     @=L@=     @=ffffff@=333333@<fffff@=@<fffff@<33333@<@<ffffff@<333333@<ffffff@<      @<      @<@;33333@;fffff@;fffff@;@;@;@;@;fffff@;333333@;ffffff@;     @;333333@;     @;ffffff@;@:33333@:fffff@;333333@:fffff@:@:@:33333@:@:@:fffff@:@:L@:ffffff@:333333@:@:333333@:333333@:      @:333333@:L@9fffff@9@9fffff@9@9@9ffffff@9333333@9@9@9     @9333333@9      @8fffff@8fffff@8@8fffff@9      @8fffff@9333333@9      @8fffff@9      @8fffff@8@8     @8@8@8@833333@833333@8@833333@8ffffff@8333333@8      @8333333@8ffffff@8L@7fffff@7@7fffff@8@8333333@7fffff@8@8      @8@8      @7@7fffff@7@7ffffff@7L@7L@7     @7ffffff@7L@7ffffff@7333333@7L@7333333@7L@7333333@6fffff@7ffffff@7333333@6fffff@7@6fffff@7      @7      @6@6fffff@6@6     @6@6@633333@6@6     @6@6     @6ffffff@6L@6333333@6ffffff@6@6ffffff@6L@6      @5@5fffff@6      @6L@6L@6333333@6      @5@5fffff@6@533333@533333@5fffff@5@533333@5@533333@5fffff@5@5@5     @5     @5     @5333333@5L@5333333@4fffff@5L@5L@5@5@5     @5L@5ffffff@5ffffff@5      @5L@5     @5     @5L@5@4fffff@4fffff@4@433333@5      @4fffff@433333@433333@4@4@4@433333@4ffffff@4     @4@4ffffff@4L@4L@4L@4      @4@4333333@4333333@4ffffff@4ffffff@4L@4@4      @3fffff@333333@3@3fffff@3fffff@4      @4@4@4@4@4      @4      @4      @3fffff@333333@333333@3@3@3@3@3fffff@3fffff@3fffff@3fffff@4      @333333@3     @3@3fffff@3fffff@4333333@333333@3L@3L@3@3@3     @3@333333@3L@3L@3     @3     @3@3     @3     @3     @3     @3@3@3@3@3ffffff@3@3ffffff@3ffffff@3L@3      @3      @3333333@3@3ffffff@3ffffff@3333333@3333333@3@3333333@3L@3L@3L@3L@3L@3L@3     @3L@3L@3ffffff@3L@3@3@3333333@3ffffff@3ffffff@3333333@3     @3ffffff@3     @3@3     @3@3@3@3@3@333333@3@3@4333333@4      @4      @3fffff@3@3fffff@3fffff@4@3@3@333333@4      @4333333@4      @333333@3fffff@3@3L@3ffffff@3     @3ffffff@3L@3@3L@333333@3L@333333@3     @3333333@3ffffff@3     @3@3ffffff@3333333@3      @3@233333@2@233333@233333@2@2@233333@2ffffff@2@2@233333@2     @2ffffff@2L@2@2ffffff@233333@2@2ffffff@2L@2     @2     @2ffffff@2ffffff@2L@2     @2ffffff@2L@2L@233333@2     @2@2@2L@2ffffff@2ffffff@233333@2@2     @2     @233333@2@2L@2ffffff@2     @2fffff@233333@233333@233333@2@2@233333@2@2@2@2@2fffff@233333@2@2@2@233333@3      @3      @2fffff@2@2@233333@2@233333@2@2@233333@2fffff@2@2@2@2@233333@233333@2@2     @2L@2L@233333@2@2     @2L@2      @1fffff@2@2333333@2333333@2333333@2333333@2333333@2      @2      @2      @1fffff@1@133333@2      @2@1fffff@1@1@1ffffff@1ffffff@1     @1@1333333@1     @1     @1L@1L@1ffffff@1@133333@1@133333@133333@1@1fffff@1333333@1      @0fffff@0@1      @0fffff@033333@0@033333@1333333@1333333@1@1@1@033333@033333@0@0L@0@0@0     @0     @0@0     @0333333@0     @0@0@0     @0@0@0L@0ffffff@0@0     @0L@0     @0     @0L@0     @0@0ffffff@0ffffff@0L@0     @0ffffff@0@0L@0L@0333333@0333333@0L@0333333@0333333@0L@0@0@033333@0ffffff@0333333@0      @0@0L@033333@0@0     @0     @0ffffff@0333333@0@/@0333333@0ffffff@0ffffff@0ffffff@0     @0L@0333333@0ffffff@0ffffff@0ffffff@0ffffff@0     @0@0@0ffffff@0     @0ffffff@0@0@033333@0     @0ffffff@0     @0     @0     @0ffffff@0@0@0@0@0@0     @0     @0ffffff@0     @0@033333@033333@0@0ffffff@0fffff@0fffff@033333@0@0@0     @0@0     @0@0fffff@033333@033333@1@1L@033333@0fffff@1@1      @0fffff@1333333@1ffffff@1@033333@0ffffff@0@1@1ffffff@1@1      @1@1L@1@1@1      @0fffff@0@0fffff@1      @1      @1@1      @0fffff@1@1ffffff@1@1@1L@1333333@1333333@1333333@1L@1333333@1L@1     @1ffffff@1@1ffffff@1@1ffffff@1333333@1@1@1@1@133333@1@1@1ffffff@1ffffff@1@1fffff@1@1     @133333@133333@1@1@1fffff@1fffff@2333333@2@1fffff@1fffff@1fffff@1fffff@2333333@2      @1fffff@2      @2333333@1fffff@2@2@2L@2@2333333@1@1fffff@2@2@233333@233333@2     @2ffffff@2ffffff@2@2     @2@2@2fffff@3      @2@2@2@2@233333@2@2@2fffff@3@2@2@3@3333333@2fffff@2fffff@3@2@2fffff@233333@2fffff@2fffff@2fffff@2@2fffff@2@3      @2fffff@3      @3      @2fffff@3@3@3      @3333333@3333333@3      @3      @3333333@3ffffff@3333333@3L@3     @3L@3333333@3L@3333333@3L@3ffffff@3L@3@3333333@3@3333333@3     @3@333333@3@3@3     @333333@4      @4333333@4333333@3fffff@3@4333333@3fffff@4333333@4333333@4333333@4@4@4      @4@4333333@4@4ffffff@4L@4333333@4@4@4L@4     @4     @4L@4ffffff@4ffffff@4@4@433333@4fffff@4@4@4@433333@433333@4@4fffff@5333333@5L@5     @5ffffff@5      @5ffffff@5ffffff@5333333@5     @533333@5fffff@5fffff@5     @5@6      @5fffff@5     @5fffff@6@6333333@6      @6L@6L@6     @6@6@6@6fffff@6fffff@7333333@7@6     @6fffff@7333333@7@7333333@7      @7333333@7333333@7ffffff@7@7@7ffffff@7     @7@7fffff@7@7fffff@7@8333333@8L@8     @8@8      @8L@8L@8ffffff@8L@8333333@8L@8ffffff@8     @8@8fffff@8333333@8L@8fffff@8@8     @8@9333333@9@9@8@9@9333333@9333333@9L@9      @9@9@9333333@9@9333333@9L@9ffffff@9L@9333333@9ffffff@9ffffff@9ffffff@9@9@9@:@:      @:@:ffffff@:     @:@:@:@:33333@:@;@;      @;      @:fffff@;      @;333333@;L@;ffffff@;L@;L@;33333@<@;@;33333@;@;@;@;33333@;fffff@<333333@<@<ffffff@<     @<     @<@<L@<L@<@<33333@<@<     @<33333@<@<@<@<@<@=      @=333333@=ffffff@=333333@=33333@=33333@=@=ffffff@=     @=@=fffff@>L@>L@>@>     @>     @?      @>fffff@>fffff@>     @>fffff@?333333@>33333@>fffff@?@?     @?L@?333333@?L@?L@?L@?333333@?     @@      @@&fffff@@333333@@@     @@ffffff@@@@s33333@@ffffff@@s33333@@s33333@@s33333@@@@@@s33333@@ffffff@@     @@@@s33333@@fffff@@ٙ@@33333@@ٙ@@     @@     @@ٙ@A@A&fffff@A      @A@A@A@     @A&fffff@A@A@A@     @A@A&fffff@Affffff@Affffff@A@A     @AL@AL@As33333@A@A33333@A     @Afffff@A33333@A33333@A@A     @A33333@A     @A@B      @B333333@B&fffff@B&fffff@B333333@BL@B@     @B333333@B@     @BL@BL@BY@Bffffff@BY@BL@B     @B@B@Bffffff@BL@BL@B     @B33333@B@B     @B@B@Bfffff@Bٙ@C      @Bfffff@Bٙ@Bfffff@Bfffff@Bfffff@C      @C&fffff@C@C@C@C333333@CL@C@     @CL@CL@CL@C@C@     @Cffffff@C     @C@C@C33333@Cfffff@C     @C33333@C@C33333@C     @Cfffff@Cfffff@C@C33333@D@D      @D      @Cٙ@D      @D&fffff@D      @D      @D@     @DL@D@D&fffff@D&fffff@D@D@D@DL@Ds33333@D333333@DL@D     @Dfffff@D@D@D@D33333@D33333@D33333@D33333@Dfffff@Dfffff@D@Dfffff@Dٙ@E@E@E&fffff@E&fffff@E@E&fffff@E@Dٙ@Dٙ@E&fffff@EY@EL@E&fffff@E@E333333@EY@Effffff@E@E@E     @E@E@E33333@Eٙ@E@E@F@F@     @F@F@F@F333333@F333333@F333333@F@     @FY@F@F33333@Fffffff@FL@F@     @FL@FY@Fffffff@F@F@F     @Fs33333@F33333@F@F33333@F     @F     @F@F@F33333@G      @F33333@F33333@G@G      @G@G@     @GY@G     @G     @Gffffff@G@G     @Gfffff@G33333@G33333@G     @G@Gٙ@H      @G     @Gfffff@Gٙ@Gٙ@Gfffff@Gٙ@H      @H&fffff@H@H      @H@G33333@H@H333333@HY@H@HL@HY@HL@H     @H@Hfffff@H33333@H@Hfffff@H     @H@Hfffff@H     @I@     @I&fffff@I      @H@I@I333333                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ?-V?"`B?n?hr ?~"?O;dZ?^5?|?lC?Vt?^5?|?tj?O;dZ?噙?$/?-V?E?M?Gz?lC?^5?|?p
=q?=p
=?p
=q?=p
=?m?/v?GzH?p
=q?lD?\(?-V?\(?$/?$/?$/?n?xF?n?tj?"`B?`A7K?o?hr ?^5?|?$/?hr Ĝ?p
=q?hr ?p
=q?o?zG?噙?XbM?I^5??M?XbM?lD?$/?lD?~"?n?S?I^5??\(?+?7KƧ?S?$/?lD?`A7K?Gz?lC?x?hr Ĝ?噙?`A7K?"`B?XbM?n?7KƧ?lD?"`B?n?+J?1&?\(?+J?\(?GzH?$/?`A7K?tj?1&?zG?lD?GzH?hr Ĝ?hr Ĝ??|hs?/v?GzH?hr Ĝ?Q?^5?|?tj?O;dZ?`A7L?p
=q?E?^5?|?Vu?p
=q?`A7L?Q?ȴ9Xb?O;dZ?hr Ĝ?p
=q?"`B?nO??bM?zG{?"`?n?hr!?ǮzG?/w?Z1'?
=p?E?dZ1?XbM??ȴ9Xb?$/?$/?zG{?$/?+?9XbM?333333?E?nO;?nO;?tj~? ě?nO;?l?lD?-V?lD?Q?E?l? ě?nO;?Q?Q? ě?nO;?-V?-V?-V?nO;? ě?-V?hr Ĝ?Q?Q?hr Ĝ?lD?
=p?-V?lD?&x?`A7L?hr Ĝ?hr Ĝ?lD?hr Ĝ?&x? ěT?bM?`A7L?`A7L?`A7L?`A7L?`A7L?`A7L?`A7L? ěT? ěT?bM?
=p?bM? ěT? ěT?vȴ9X?;dZ?vȴ9X?;dZ? ěT?;dZ?Q?vȴ9X?;dZ? ěT? ěT?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?&x?bM?;dZ?vȴ9X?vȴ9X?vȴ9X?bM?;dZ?vȴ9X? ěT?bM?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?bM?vȴ9X?
=p?;dZ?;dZ? ěT? ěT? ěT?Q? ěT? ěT?vȴ9X?;dZ?;dZ?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?;dZ?;dZ? ěT?bM?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?zG{?`A7L?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?Q?5?|h?Q?Q?Q?Q?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?5?|h?Q?;dZ?;dZ?Q?Q?Q?Q?Q?Q?;dZ?vȴ9X?;dZ?Q?vȴ9X?Q?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?Q?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ? ěT?;dZ?Q?Q?
=p?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?&x? ěT?vȴ9X?;dZ? ěT?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?;dZ?vȴ9X?Q?;dZ?;dZ?Q?;dZ?vȴ9X?
=p?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?vȴ9X?;dZ?&x?vȴ9X?Q?Q?vȴ9X?;dZ?vȴ9X?Q?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?vȴ9X? ěT?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X? ěT?;dZ?;dZ?Q?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X? ěT?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?&x? ěT?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?vȴ9X?-V?`A7L?;dZ?Q?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?vȴ9X?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?5?|h?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?Q?Q?Q?5?|h?Q?5?|h?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?Q?Q?vȴ9X?Q?Q?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?Q?Q?Q?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?Q?Q?;dZ?vȴ9X?;dZ?Q?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?vȴ9X?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?Q?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?Q?Q?Q?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?5?|h?;dZ?;dZ?Q?5?|h?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?Q?Q?Q?Q?;dZ?;dZ?Q?;dZ?Q?/v?5?|h?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?Q?5?|h?;dZ?vȴ9X?;dZ?Q?Q?Q?5?|h?;dZ?Q?;dZ?Q?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?vȴ9X?vȴ9X?Q?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?Q?vȴ9X?;dZ?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?;dZ?Q?5?|h?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?;dZ?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?5?|h?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?;dZ?Q?;dZ?Q?Q?Q?Q?;dZ?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?5?|h?5?|h?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?5?|h?5?|h?5?|h?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?5?|h?Q?Q?5?|h?5?|h?5?|h?Q?5?|h?5?|h?Q?Q?Q?Q?5?|h?Q?;dZ?Q?5?|h?Q?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?/v?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?-V?5?|h?/v?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?-V?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?-V?5?|h?Q?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?/v?-V?/v?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?/v?-V?5?|h?5?|h?-V?/v?5?|h?5?|h?-V?5?|h?5?|h?-V?/v?-V?Q?5?|h?5?|h?5?|h?5?|h?-V?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?1&y?/v?5?|h?-V?5?|h?/v?-V?5?|h?5?|h?5?|h?/v?/v?5?|h?/v?/v?5?|h?/v?/v?/v?/v?5?|h?-V?-V?/v?-V?5?|h?5?|h?5?|h?-V?/v?5?|h?5?|h?/v?-V?-V?/v?5?|h?/v?/v?1&y?/v?-V?5?|h?-V?5?|h?/v?/v?/v?1&y?1&y?-V?5?|h?-V?/v?-V?-V?5?|h?/v?-V?-V?-V?-V?/v?/v?-V?-V?-V?-V?5?|h?/v?/v?5?|h?-V?1&y?1&y?5?|h?5?|h?/v?-V?/v?/v?/v?/v?/v?/v?/v?-V?/v?1&y?/v?/v?/v?-V?/v?5?|h?-V?/v?-V?/v?5?|h?5?|h?/v?-V?/v?-V?-V?-V?1&y?/v?/v?/v?-V?/v?-V?5?|h?-V?-V?/v?-V?-V?/v?/v?/v?-V?/v?/v?5?|h?/v?5?|h?/v?/v?/v?1&y?1&y?/v?5?|h?-V?/v?/v?1&y?1&y?1&y?5?|h?1&y?1&y?1&y?/v?/v?/v?/v?/v?/v?/v?/v?/v?1&y?/v?-V?-V?/v?1&y?1&y?1&y?/v?-V?1&y?/v?/v?/v?-V?-V?1&y?/v?/v?1&y?1&y?/v?/v?1&y?-V?1&y?/v?-V?1&y?1&y?/v?1&y?/v?/v?1&y?1&y?1&y?/v?/v?1&y?/v?/v?/v?1&y?/v?1&y?1&y?1&y?/v?1&y?1&y?1&y?1&y?/v?1&y?/v?1&y?/v?-V?5?|h?-V?1&y?1&y?1&y?1&y?1&y?1&y?/v?1&y?1&y?1&y?1&y?(\)?/v?1&y?1&y?1&y?/v?1&y?/v?1&y?-V?/v?1&y?1&y?/v?/v?1&y?(\)?1&y?/v?(\)?(\)?/v?1&y?1&y?1&y?/v?1&y?1&y?/v?/v?1&y?1&y?1&y?1&y?(\)?1&y?(\)?1&y?1&y?1&y?1&y?(\)?(\)?1&y?(\)?1&y?1&y?/v?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?(\)?(\)?1&y?1&y?(\)?1&y?1&y?1&y?1&y?(\)?1&y?1&y?(\)?1&y?1&y?1&y?/v?1&y?1&y?/v?1&y?(\)?(\)?/v?1&y?1&y?1&y?(\)?(\)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ?ə?ə??                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	P25                                     1                                       )BH3