CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20170205   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P24    CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:34.779918Z    ORIGINAL_HEADER      6CTD,20250210CCHSIOWB
#Removed 'CTDFLUOR_TSG' as it's filled with -999
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2017-06-29. CTD data from cruise 18DD20170205, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20170205. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2017-001/index.php. 
#
# The information in this file for the cruise 2017-001 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-0036.ctd
#
# Start of originator file comment header
#
#*2017/06/29 15:26:50.02
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2017/02/10 06:17:38.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 198
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : CE9F1F72
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            0.3            202.1
#       2 Temperature:CTD               deg_C_(ITS90)   5.6248         6.8697
#       3 Salinity:CTD                  PSS-78          32.78          33.8432
#       4 Sigma-t:CTD                   kg/m^3          25.7461        26.7106
#       5 Oxygen:Dissolved:CTD:Volume   ml/l            3.4            6.87
#       6 Oxygen:Dissolved:CTD:Mass     µmol/kg         147.7          299
#       7 Fluorescence:CTD:Seapoint     mg/m^3          0.66E-01       1.162
#       8 PAR:CTD                       µE/m^2/sec      0              0.3
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        7  F       ' '     2
#       6  -99   ' '        6  F       ' '     1
#       7  -99   ' '        8  F       ' '     3
#       8  -99   ' '        7  F       ' '     1
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2017-001
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P21
#    EVENT NUMBER        : 36
#    LATITUDE            :  49  38.00000 N  ! (deg min)
#    LONGITUDE           : 139  39.97000 W  ! (deg min)
#    WATER DEPTH         : 3961
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    The descent rate of the CTD was very noisy with some complete reversals
#	of direction.
#    CTDEDIT was used to remove many records corrupted by shed wakes;
#	salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Fluorescence and PAR data are nominal and unedited except that some records were
#	removed in editing temperature and salinity and a large spike in
#	fluorescence was removed from file 0032.
#
#    The Transmissivity channel was removed because of frequent shifts in values during
#	casts and large variations between values during repeat casts.
#	The data are available, by request, from the chief scientist.
#
#    NOTE: While the Fluorescence:CTD data are expressed in concentration units, they
#	do not always compare well to extracted chlorophyll samples, particularly for
#	casts far from shore. It is recommended that users check extracted chlorophyll
#	values where available.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in Sea-Bird
#	Application Note #64-2, June 2012 revision (Sea-Bird_64-2_Jun2012.pdf), except 
#	that a small offset in the fit was allowed.
#
#    The Dissolved Oxygen sensor used in files 0001, 0002 and 0016 malfunctioned so the 
#	Oxygen:Dissolved:CTD channels were removed from those files.
#
#    The Oxygen:Dissolved:CTD sensor has a fairly long response time so data accuracy 
#	is not as high when it is in motion as it is during stops for bottles. This will be
#	especially true when vertical dissolved oxygen gradients are large. To get an estimate
#	of the accuracy of the Oxygen:Dissolved:CTD data during downcasts (after recalibration)
#	a rough comparison was made between downcast Oxygen:Dissolved:CTD data and upcast 
#	titrated samples. Some of the difference will be due to problems with flushing of 
#	Niskin bottles and/or analysis errors, so the following statement likely underestimates 
#	Oxygen:Dissolved:CTD accuracy.
#
#    Downcast (CTD files) Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.25 ml/l from 0 to 125 dbar.
#	±0.2 ml/l from 125 to 400 dbar.
#	±0.1 ml/l from 400 to 600 dbar.
#	±0.05 ml/l from 600 to 1500 dbar.
#	Low by up to 0.08 ml/l below 1500 dbar.
#
#    For details on the processing see document: 2017-001-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5--- --6-- ---7--- --8---
#!Pressu Temperat Salinity Sigma-t: Oxygen Oxyge Fluores PAR:  
#!re:CTD ure:CTD  :CTD     CTD      :Disso n:Dis cence:  CTD   
#!                                  lved:  solve CTD:          
#!                                  CTD:   d:CTD Seapoin       
#!                                  Volume :Mass t             
#!------ -------- -------- -------- ------ ----- ------- ------
#*END OF HEADER
     WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @E         data_max      @E         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     0  2   pressure                	long_name         pressure   positive      down   units         decibar    data_min      ?333333   data_max      @fffff   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      0  O   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d        kD   temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      @u   data_max      @ n   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       0  rP   temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d           salinity                	long_name         salinity   units         PSS-78     data_min      @@iX   data_max      @A.   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      0     salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d           oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @)   data_max      @r   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        0     	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d           CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?5?|h   data_max      ?tj~   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      0     CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d        4   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min                 data_max                 C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       0  @   PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d       p   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min               data_max               C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     0 "|   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d       >   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( E   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( E   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      )V   data_max      )V   C_format      %10d       F   latitude               	long_name         latitude   units         	degrees_N      data_min      @H>p   data_max      @H>p   C_format      %9.4f          F   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      aO;dZ   data_max      aO;dZ   C_format      %9.4f          F   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d        F   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min        N   data_max        N   C_format      %4d        F@E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      @E      ?333333?ffffff@@@      @@@ 333333@!@$@&      @'@*      @,      @.      @0      @1      @133333@3ffffff@4      @5      @6      @7      @8      @9      @:@:@<333333@=      @>      @?      @@      @@     @@ٙ@A33333@B      @B     @C      @C     @D      @D     @F&fffff@F     @G      @G     @H      @H     @I      @Is33333@J@     @J     @K      @K     @L      @L@L33333@M     @N      @N     @O      @O     @Offfff@P     @Q      @Q@     @Q     @Q     @R      @R,@S      @S@     @S     @S     @S@TS33333@Tl@T     @U      @U@     @U     @U     @Ufffff@VFfffff@V     @V     @W      @W@     @W     @W     @X      @X@     @X     @Xfffff@Y@Y@     @Y     @Y     @Z      @Z@     @Zy@Z@[      @[@     @[     @[     @\      @\@     @\     @\     @]      @],@]y@]ٙ@^      @^@     @^     @^     @^33333@_fffff@_     @`      @`      @`C33333@`P     @`33333@`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a@a     @b      @b      @b9@bl@b     @b     @b     @b     @b@c@     @c\@c@c     @c     @d      @d      @d6fffff@d     @d     @d     @d     @e      @e      @e@     @eY@e@e     @e     @e     @f      @f      @f@     @fVfffff@f     @f33333@f@gFfffff@g`     @g     @g33333@g@g     @h      @h      @h@     @hP     @hfffff@hfffff@hٙ@i      @iC33333@i`     @i     @ifffff@i@i     @i@j)@j@     @j`     @j     @j     @j     @j@j@k@k@     @k`     @k     @k@lfffff@l      @l@     @l`     @l     @l     @l     @l@mc33333@m     @m     @m     @m     @mfffff@n0     @n@     @n`     @n     @n     @n@o,@o@     @o`     @o     @o     @o     @o     @offfff@pfffff@p      @p0     @p@     @pP     @p`     @pp     @p     @p     @pfffff@p33333@p     @p     @p     @q      @q     @q      @q1@q>fffff@qK33333@qs33333@q     @q     @q     @q     @q     @q     @q@r@r!@r0     @r>fffff@rP     @r`     @rp     @r     @r     @r@r     @r@r     @r     @r     @s      @s@sfffff@s0     @sC33333@sP     @s`     @sp     @s     @s     @s     @sfffff@s     @s     @s     @sfffff@t0     @t@     @tP     @t[33333@t@t     @t     @t     @t     @t     @t     @t陙@u     @u      @u0     @u@     @uP     @u`     @unfffff@u     @u     @u     @u     @u     @u     @v      @v     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @vfffff@vfffff@v     @w      @w     @w      @w0     @w;33333@w`     @wp     @w     @w     @w     @w     @w     @w     @w     @x33333@x     @x      @x0     @x@     @xP     @x`     @xp     @x{33333@x@x     @x     @x     @x     @x陙@y      @y     @yfffff@y.fffff@y@     @yP     @ya@yp     @y     @y     @y     @y@y@y@y     @z      @z     @z!@z(     @zQ@z`     @zp     @z     @z@z     @z     @z     @z     @z     @{!@{.fffff@{@     @{P     @{`     @{p     @{     @{33333@{     @{     @{     @{     @{     @|      @|     @|33333@|H     @|Nfffff@|`     @|p     @|     @|     @|     @|@|     @|ə@|fffff@|     @}      @}     @}      @}0     @}Vfffff@}`     @}nfffff@}~fffff@}     @}     @}     @}     @}     @}ٙ@~@~     @~      @~0     @~@     @~P     @~vfffff@~     @~     @~     @~     @~@~ᙙ@~     @      @     @      @0     @<@a@p     @     @     @     @@     @     @      @     @     @@"fffff@(     @0     @8     @<@Jfffff@P     @X     @h     @p     @x     @     @     @     @33333@fffff@     @     @     @ř@љ@     @33333@     @     @     @      @     @     @fffff@      @(     @0     @8     @@     @H     @P     @bfffff@h     @p     @x     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @	@     @     @      @(     @0     @P@X     @`     @h     @p     @x     @     @     @@@fffff@     @     @     @     @ٙ@     @     @@33333@     @     @fffff@!@(     @0     @8     @>fffff@P     @X     @`     @h     @@     @     @     @33333@     @     @@     @@     @     @     @33333@@@@     @     @      @(     @0     @733333@K33333@P     @X     @`     @h     @p     @vfffff@@     @     @     @     @     @     @ə@͙@fffff@     @     @33333@     @      @     @     @@      @'33333@0@8     @@     @E@Q@X     @`     @h     @p     @t@fffff@     @33333@@     @     @     @     @     @     @@@fffff@     @     @     @      @     @     @     @      @1@8     @@     @H     @P     @X     @`     @e@y@     @     @     @     @     @fffff@@33333@     @     @     @     @fffff@     @fffff@     @      @     @     @     @      @(     @0     @6fffff@@@H     @P     @X     @`     @h     @p     @t@     @@     @     @     @     @     @     @fffff@fffff@     @     @     @@33333@     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @x     @     @     @     @     @     @33333@@     @     @     @     @     @     @     @@fffff@     @      @(     @0     @5@Q@X     @`     @h     @p     @fffff@     @     @     @fffff@@     @     @@     @33333@      @     @     @     @@4     @8     @@     @H     @P     @X     @`@d@x@     @@33333@fffff@     @     @     @     @͙@33333@     @     @     @      @     @     @fffff@*fffff@0     @8     @@     @H     @P     @X     @l     @p     @x     @     @     @     @     @@     @     @     @     @     @     @ᙙ@     @     @     @      @     @fffff@ @(     @0     @8     @@     @H     @P     @X     @\@i@p     @x     @     @     @     @     @@33333@     @     @     @     @33333@@     @     @      @     @     @@(@0     @8     @?33333@Nfffff@X     @`     @h     @p     @x     @|@33333@     @     @     @     @     @     @@33333@     @     @     @     @     @     @	@     @     @      @(     @0     @8     @@     @H     @P     @X     @\     @i@o33333@x     @     @     @     @     @     @@@     @     @     @     @     @     @      @     @     @     @      @'33333@@@H     @P     @X     @`     @ffffff@fffff@     @     @fffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @2-V@2 ě@2W@1-@2s@1-@2m\@2䎊q@2䎊q@2 ě@3E@4D@5!R@5Xy=@5\(@5?@5\(@5\(@64K@6Fs@64K@6+jg@64K@6E@6+jg@5?@64K@6E@6Fs@6C-@71@7eں@7kP@74m@6C-@8YJ@8)@8F@8)@9	k~@8)@84֡b@9#w@9#w@9=b@9	k~@84֡b@84֡b@8F@9XbM@9(@9Y}@9"`@9rGE8@9=b@9D@:C\@:S&@:~@;s@;s@:)_@<n.@<PH@<?@<#x@<hr@<#x@<64@=p
=@=p
=@=Vl!@<#x@<?@<#x@<쿱[@=<64@=H˒@>BZc @>\N<@>\N<@>\N<@>"@>vȴ9X@>$t@>6z@>BZc @>($x@>vȴ9X@>\N<@>($x@>6z@>"@?@>vȴ9X@>\N<@>ߤ?@?|hs@@n@GK]d@P|@Q4J@QN;5@PbM@Stj~@U$/@ZQ_@d%1@h@m
qv@ql@@m\@#9@sh@+@m\@hr@ n@YJ@iDg8@VϪ@	ԕ+@fffff@p:@n.@t@+@@u'0@GzH@OrGE9@NMj@Ao hی@!e@&@^5?|@޸Q@cA \@'0@x@҈p;@O;dZ@r䎊q@g,@PbM@-B@@K]c@@T`d@ ѷ@g8}@iB@<쿱@C,z@Xy=@
=p@u!@$tT@u%F@@iDg8~@G@@*JL@@S@JE@bM@A [@`A@n@dZ1@Z,<@@NU@873@Ʌoi@_o@A@a|Q@\@@%1@`d@_vȴ9@74m@%O
@vȴ@@!R<@PH@"`@A [@PH@Ϫ͞@
(@\@e@ߤ@@H˒:@r䎊q@i^@_o@Sݗ+k@NT@B ѷ@(\)@N;5@_o @˒:*@O
M@C,@ө*0U2@˒:)@\N@y(@usg@r-V@mC\@hTɅ@w+@tm8@Y|@B&IR@5Y|@"@4@ڹY@҈p:@Q@ěS@©@ ѷ@	k~@8}H@S&@jOv@@?@ѷX@}K]@rs@h$xG@j͞&@eS@S&@K҈@C,zxl@4!-w2@+P{@"M@vȴ@
@"@ 4m@ܬ1&@$tT@@v@@P{@L/{@}H˒@TZ@@6@8F@1A [@(>BZc@҉@N;5@	ԕ*@C-@u@,<@>6z@ֻ@R@As@@Fs@?@s@Z@}Vl@rGE@o@@I^5?@D@]cA@y=b@sߤ@p
=q@mC\@jOv`@ao@^iB@a'R@$tSM@"C,@*0@@@nP@($x@J#9@^@R<6@,=@ܬ1&@u%F@T`d@	 @&x@e@]ce@kP|@Xe,@@{J#9@74@u!.@u%F
L@u'0@r-V@n}Vl@h@gRT`e@fA@d?@\wkP@Z,<@S@P`A7@M%@L_@JL_@;A@5%F
L@2s@0:~ @0 ě@/r@/v@)Dg8~@'@&IQ@"M@vȴ9@kP|@Fs@S&@:)y@nO@hr @s@s@%2@@s@ 4m@j~#@4K@J@@A [@w1@P{@x@u@e+@	k@
qu@ߊ	@wkP@@L_@a@O@N;6@N;5@Ƨ@s@JM@@$t@m8@{J#:@zG@C@Q@-
@iB@1'@@@$tS@$/@As@W'@@@C@~vȴ9X@}<64@z)_@x4֡b@x73@v4K@uY|@r䎊q@q2W@p@l[W?@l1&y@ka@@kI^@j0U2a|@kI^@j0
@iDg8~@f'@eڹ@e+a@cZ@cS@a.H@a-w1@_U=@^5?|@[$@ZY@XD*@W>6z@Vl!-@U$/@T,<@R:)y@Q_p@NT@Kq@H@CF]c@As@@ѷX@?@;m]@:G{@:@9"`@9=b@7+@6C-@5sg@3g	l@-C\@&A@$TɆ@$?@Q@u%F@>6z@l!-@=K@Ʌoi@<64@xF]@8YK@u%F
@o hی@?@Fs@s@O;@唯O
@>BZ@`d@š@m8@m8@?|h@3@3@֡a@9XbN@|@a|Q@33333@ᰊ@q@tSM@-w1@Ov_خ@u"@_F@~($x@@o h@{J#9@@ ѷ@@n.@o hی@ѷX@{s@v_ح@pD@lC@glC@d7@ceO@Y+@W&@W
=p@Vt@U=K@L_@D2W@A [7@>
(@;A@5Xy=@3ߤ@1o@,zxl"@'-@IQ@
qu"@
ڹY@
=p
@?@($x@C\@xl"h
@	k~@F@eں@@-V@\@Ov`@B@	k@
qu@1'@t@*0U@;5X@)^	@C@
(@Q@[W>6@*0U2a@F
L0@@@L_@bM@sMjO@l[W?@jOv`@g@b@4@cS@Yb}@TɅoi@QX@Rp:@T`d@R<64@P`A7@Ov_ح@M5Xy>@N;5X@E84֡@9XbM@6C-@2m\@/v@'-@ 'RT`@u@PH@_F@+j@ݗ+k@rGE9@L_@
ڹY@	k~(@
qiC@
@

qu@
֡af@
a@O@
\N@
p
=@
)y@
}Vl@
3@
33333@
[W>6@
U=@
3@
@
@N@
-
q@
$tT@
'RTa@
u%F@
@4n@
{m]@
s@
o@
nc	@
l[W?@
h	ԕ+@
eڹ@
Zc	@
O͞@
Gy@
@6@
>vȴ9X@
=v@
=p
=@
<Z@
;5Xy@
9XbM@
5Xy=@
4m8@
-U=@
+I^@
)^@
'&@
'-@
&IQ@
#wk@
O;d@
Z@
o @
	k~(@
$/@"`@ ě@iDg8@.2@JL@@N@D*@fA@䎊@p:~@D@4m@C@H˒:@rG@?|h@E@2X@S@@N@)^@(@M:@ڹY@qiC@L/{@=p
@n/@n.@$tS@{J#9@|?@tD@nO;@kC,z@]+j@WsPH@TE@UfA@T`d@S@P|@I@ATɅo@?@=K]@<j~#@8YJ@-w1@-V@'&@!ae@rGE9@	'RTa@@I^5@ ѷX@ڹZ@@#@s@@c	@쿱[W?@fB@䎊qj@A [@䎊qj@ᰉ'R@䎊qj@e@Z1@ᰉ'R@bM@a@O@R@/{J#@s@̘_@ɺ^5?}@@ʌL_@y@a@N@<64@?|h@ ě@'RT`@PH@@ԕ*@k~(@n.@qA [@g8}H@_حV@_Ft@_Ft@ATɅo@49XbN@.zG@)*0U2a@*0U2a|@tj@hr @
M:@n/@
$tS@
Y|@
iB@
쿱[W?@
JL@
+a@
S@
c	@
sPH@
Ϫ͞@
@
_p@
v_ح@
˒:*@
@
j~#@
KƧ@
sg@
'0@
m\@
ᰊ@
-@
r@
>B[@
L/{J@

=p@
S&@
wk@
'RT`@
IQ@
qu!@
e+a@
Xe,@
sP@
*0@
qu"@
I^5@
|hr@
x-
@
poiDg8@
l!-w@
E@
GE84@
HK]c@
H@
DS@
?|hs@
5'0@
-V@
&IQ@
$TɆ@
Q@
e+a@
$tS@
sh@
n/@
@4n@
 IQ@	$tS@
 ѷX@
u%F@

L/{@
ݗ@
Q@
%2@	?@	1@	䎊q@	D@	8Y@	ᰉ'@	x@	
qu@	ڹY@	a@O@	;dZ@	
M;@	;5X@	ɅoiD@	y@	NU@	}H@	g	l@	o@	v@	B@	a@@	-@	9@	ߤ@@	zG@	nO@	xF]@	 ѷ@	$/@	IQ@	}E@	v!.I@	r{m@	qu!S@	oiDg8@	h	ԕ+@	a@N@	_حV@	XbM@	SMj@	OAs@	K:)z@	H9Xb@	Eo i@	As@	=v@	<j~#@	;A@	6}Vl@	3g	l@	/v@	+jf@	(TɅ@	$/@	U=@	=K^@	kP|@	@	O
M@	S&@	hr @	@	ߤ?@	
(@	
qiC@		7KƧ@$t@xl"h
@!.@GE85@빌~($@	ԕ+@]ce@@䎊@;dZ@5Xy>@@š@NU@Y}@[W>6@-@RT`e@1@wkP@@nO@u                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @@i@@i^5?}@@iX@@i^5?}@@i_o@@iy@@iD@@iy@@i2W@@iy@@i2W@@i@@i@@i@@iD@@iD@@iy@@iD@@i^5?}@@i^5?}@@i@@iy@@iD@@iD@@i2W@@iy@@iy@@i2W@@iD@@i2W@@iD@@i@@i2W@@iD@@i2W@@iX@@i^5?}@@i^5?}@@i@@iX@@i@@i@@i^5?}@@i^5?}@@i@@iD@@iD@@iD@@i@@i_o@@iy@@iy@@iy@@iy@@io@@iy@@i_o@@io@@io@@i2W@@iy@@i2W@@i2W@@i@@iX@@i2W@@i2W@@iy@@io@@iy@@io@@iy@@iԕ*@@i"`@@iiB@@iiB@@i"`@@i"`@@i"`@@i"`@@iᰉ'@@i>BZ@@iiB@@iN;6@@i@@i>BZ@@ie@@iiB@@i@@i@@i"`@@ie@@ie@@i"`@@iN;6@@iN;6@@iᰉ'@@iᰉ'@@iY}@@j>B@@k~$@@k:)z@@kMj@@kg	l@@kߤ@@k5Xy@@l<쿱@@m/w@@m+j@@n.2@@nqi@@oXe@@v]cf@@JM@@~($@@e@@(\@@$tS@@n@@͸@@о
(@@u%F
@@Q@@Թ#x@@ڶ}Vm@@`A7L@@ߊ	@@ᙙ@@⒣S&@@n.3@@䎊qj@@7@@+a@@`A7L@@E@@BZc @@%@@m\@@Xe,@@@@hۋq@@TɅ@@7KƧ@@@@'RTa@@s@@꒣S&@@ꟾvȴ@@<64@@m@@9@@33333@@P{@@@@Q@@@@eO@@달q@@Q@@A@@U=@@a@O@@a@@@\N@@Q@@I^5?@@SMj@@64@@"h	ԕ@@zG@@`d@@<쿱@@#@@섵?@@?@@u"@@Z@@u"@@@@u"@@Z@@>B[@@*0@@#x@@N;@@TɆ@@*0@@@@?@@j~@@/@@u"@@@@֡a@@*0@@@@7@@֡a@@e@@hr@@o i@@K]@@u@@!.H@@Q@@o i@@<64@@Y|@@IQ@@S&@@p
=@@S&@@F
L0@@?|h@@}H@@p
=@@sg@@p
=@@Vl!@@zxl"h@@\@@sh@@E@@?@@-V@@=K@@+j@@!R@@!R@@픯O
@@힃%@@+j@@hr!@@sh@@
qv@@ڹ@@!.@@(@@ڹ@@ ѷY@@zG@@Ov_@@c	@@+J@@)^@@Ft@@!-w1@@4֡a@@+I@@8}H@@+I@@1@@.H@@As@@$tS@@@@$tS@@&@@;dZ@@rGE9@@+j@@+@@F]d@@@@
qu@@*0@@U2a|@@-
@@d8@@ěT@@C@@	k~@@$/@@@N@@_p@@ [7@@&x@@-w1@@A [@@=b@@JE@@e+a@@k~(@@b}@@x@@R<6@@(@@l@@iB@@	 @@I^5@@e+@@T`d@@C,z@@I^@@u%@@6z@@qu!@@n.3@@Q@@ߤ@@m]@@~($@@~($@@lC@@1&y@@2W@@<쿱@@2W@@9XbN@@?@@`d@@JM@@84֡@@L_@@F
L0@@`A7L@@,=@@@@.2@@@@$t@@O;@@&I@@
=p@@v_ح@@	@@kP@@+@@H@@U2a|@@tj@@d8@@ěT@@)^@@$tT@@7Kƨ@@D@@N;6@@>BZ@@s@@lD@@@@JL@@a|Q@@kP|@@S&@@}Vm@@fB@@9@@F]c@@MjO@@J#9@@S@@Q@@a@O@@5Xy@@Q@@ݗ+k@@$@@(\@@Z1@@q@@j~#@@wkP@@N;@@j~@@>B[@@V@@/w@@5Xy>@@<64@@L_@@O
@@,=@@
L/@@@@.2@@?@@vȴ9X@@Fs@@@@-@@҈p;@@@@As@@KƧ@@Xe,@@_o@@䎊r@A 
qu@A 4m9@A D*@A bM@A 9Xb@A#w@A:S@Ao@A@A'R@AN;6@A>BZ@A@A&IR@A:)y@AQ_@Aa|Q@AL_@Avȴ@A<64@Am@A~@AI^@A҉@APH@AC,z@A"`B@A6z@Aa@N@Ajf@Atj~@AeO@AMj@A*0U2@A~($@A҈@A@Atj@A"h	ԕ@A<쿱@AM:@AZ1@Ag8}@AwkP@AC@A_@A#x@AJM@A+a@A}H@Ahr!@Av@A@Aڹ@A4K@AOv_@A$/@A5?|@AE@AR<6@Az@AO;@A1@A8}H@AKƧ@AO
M@Ar@A@A#@A	ԕ+@A*0U@A6@A73@AYJ@A)^@APH@A	@N@A	A [@A	k~(@A	o@A	l@A	e@A
0U2a|@A
M@A
S&@A'/@AnP@AC,z@A	@AC,z@APH@AC,z@A	@A)^	@A	@A&@AC%@AxF]@AQ@A:)z@Awk@A@A@A`d@AI^5?@AVϪ@A]ce@AVϪ@AcA \@Aq@Am8@AtSM@A쿱[@A*0@AE@A
[@A
%F
L@A
B@A
m\@A
+j@A
=K@A
@A
Xy=@A
U=@A
?@A4K@A.2@Ac	@Ac	@Az@Az@AIQ@A$t@A-@A
M;@AU=@AXe,@Ab}V@AO;d@Ar@A@AK]d@A;dZ@A@A+j@AbM@A@A}H@A73@AK]c@A[6@A@A)^@A4֡b@A$/@A@N@A&x@A=b@ATɅo@Ao hی@A7Kƨ@Au@A"`@Au%F@A)y@A:)y@A@A͞&@A ѷ@A~@APH@As@Ag	l@AA@Aa@O@AC]@AQ@A?@AM:@AZ1@A#@A#@A7@A!-w@A>@Au@A%F
L@A<64@AY|@Ahr!@AO
@A+j@Av@A@A
qv@Aڹ@A ѷY@A_o @A_o @AIQ@At@A]cf@Aߤ?@AXe,@Aݗ+@A$tS@A͞@Ar@A@AfA@AVϫ@A*0@AH@A_F@A-
@ATɅ@AC@A\)@A@N@A-w1@A[W>6@Ao hی@ArGE8@Au!S@Ab}@AR<6@A@A)y@A:)y@A~"@AL_@A0
@Avȴ@A>B@Ag	@A͞&@Ac	@Am\@AMjO@Ajf@AxF]@A~$@A@AeO@AMj@A5Xy@A$@AJ@A<쿱@A`d@AzG@A_@Azxl"@A쿱[@A?@A֡a@Ae@A>@Ao i@A[@AQ@AB@AL_@AO;dZ@A\@AfA@Azxl"h@A+j@A%@AoiDg@AC\@A
L/@A4K@A($x@A.2@A($x@A1.@ABZc @AVu@AVu@As@Ap:~@A+J@Aaf@A6z@Aߤ?@AMj@A hۋ@AFt@AFt@A
=p@A!-w1@A+I@A>6z@AAs@AKƧ@AO
M@Aeں@A|hs@AkP@A3@AfA@A bM@A 73@A @A )@A ěT@A F@A p:@A D@A e+@A C@A C@A 4֡b@A \)@A!@N@A!+@A!@A!-w1@A!:S@A!=b@A!A [@A!ae@A!@A!o@A!@A!B@A!o@A!@A!ᰉ'@A!ᰉ'@A!e@A!Y}@A!lD@A!Y}@A!Y}@A!lD@A"-V@A"#9@A")y@A"C\@A"@4n@A"ݘ@A"}Vm@A",<@A"m@A#	@A#5Xy@A#Z@A#5Xy@A#҈@A$xF@A$,<@A$zG@A$S@A$TɆ@A$j~@A$֡a@A%V@A%[@A%%F
L@A%!.H@A%2a|@A%L_@A%p
=@A%ڹZ@A%%@A%sh@A%H˒@A%\(@A&
L/@A&+jg@A&BZc @A&R<6@A&c	@A&iB@A&s@A&vȴ9X@A&IQ@A&@A&af@A&&I@A&t@A&҈p;@A&ߤ?@A&1@A&@A&Fs@A&!.I@A' hۋ@A'Xe@A'v@A'4֡a@A'U=@A'RT`e@A'Xe,@A'|hs@A'3@A'-@A'Vϫ@A'䎊r@A'rGE9@A'#@A(F]d@A(@A(F]d@A(}H@A(*0@A(A7K@A(D*@A(K]c@A(NU@A('RT@A(-
@A(d8@A(9Xb@A(@@A({@A) [7@A)0
)@A)0
)@A)=b@A)e+a@A)rGE8@A)u!S@A)|Q@A)o@A)@A)n.      @A)ᰉ'@A)>BZ@A)@A)s@A*n@A*1'@A*-V@A*GE85@A*kP|@A*~"@A*@4@A*L_@A*ᰊ@A*wkQ@A*L/{@A*}Vm@A*W@A*䎊q@A*C,@A*~@A+C,z@A+"`B@A+&@A+/V@A+P{@A+dZ@A+g	l@A+n.3@A+@A+U=@A+q@A+@A+
=p@A+%2@A+C]@A+@A,1&y@A,L_@A,,<@A,/{J#@A,9XbN@A,PH@A,`d@A,q@A,?@A,qj@A,S@A,@A,?@A,?@A,u"@A,/@A,@A,hr@A,D@A,e@A,e@A-'0@A-'0@A-84֡@A-B@A-Vl!@A-\@A-zxl"h@A-ڹZ@A-n/@A-cA @A-
qv@A-S@A-oiDg@A-!.@A.t@A.$/@A.;5X@A.YJ@A.z@A.l!-@A.p:~@A.T@A.2X@A.@A.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @r@r33333@r@rfffff@r@r@r@rfffff@r@r@rfffff@rfffff@r33333@r33333@rfffff@r     @rfffff@rfffff@r@r@r@r@r@rfffff@r     @r     @r33333@r33333@r@rfffff@r33333@r33333@r@r@rfffff@r@r33333@r@rfffff@r@r@r     @r33333@r@r33333@rfffff@rfffff@r     @rfffff@r@r@r@rfffff@r     @rfffff@r     @rfffff@rfffff@r@r33333@r@r@r@r     @r@r@r@r@r     @r@rfffff@rfffff@rfffff@rfffff@r33333@r@rfffff@r     @r@rfffff@rfffff@r33333@r33333@r33333@r@rfffff@r@r33333@rfffff@r33333@r@r33333@r     @rfffff@rfffff@r     @r@rfffff@r@r@rfffff@r@r33333@r@r|@rt@rl@rc33333@r^fffff@rX     @rY@r^fffff@qfffff@q#33333@p@m@l333333@kə@j     @j9@i     @ifffff@ifffff@ifffff@ifffff@i@h     @hfffff@hs33333@hs33333@h@hs33333@hY@hp     @h@h33333@h@hfffff@h33333@hy@hS33333@h)@h	@g@g     @g33333@g33333@g`     @gFfffff@g&fffff@g@ffffff@f     @fə@f@f33333@ffffff@f@f33333@f33333@f@fs33333@fFfffff@f33333@e@efffff@e\@e,@e@efffff@d@dfffff@d\@d<@d@d	@cfffff@cfffff@c@cfffff@c@cfffff@c333333@c33333@b     @bffffff@bC33333@b,@b      @b@b#33333@b33333@a@aٙ@afffff@a@a33333@a@a@a33333@al@aL@a@     @a9@a6fffff@a,@a@a      @`fffff@`     @`33333@`33333@`fffff@`@`ffffff@`I@`0     @`#33333@`      @`@`fffff@`@`33333@_@_@_     @_@^33333@^33333@^     @^ffffff@^`     @^ffffff@^l@^L@^,@^33333@^      @]fffff@]ٙ@]ٙ@]     @]fffff@]33333@]s33333@]S33333@]@     @]      @]fffff@\@\ٙ@\     @\@\l@\&fffff@\33333@\      @[fffff@[     @[     @[ffffff@[L@Z     @Zffffff@Z&fffff@Y@Y@Y@Y33333@Yy@YS33333@Y33333@X     @X@X33333@Xfffff@X     @Xfffff@X@X@X33333@X     @Xffffff@XFfffff@X,@X      @Wٙ@W@W33333@Wfffff@Wfffff@Wy@W`     @WY@W333333@W33333@W33333@Vy@V333333@V      @V@Ufffff@U@U33333@U33333@U     @U@Uy@US33333@U@     @U333333@U      @T@T     @Ty@T@     @T      @S@Sٙ@S33333@S@S     @S33333@S     @Sffffff@S@     @S@     @S@     @S333333@S333333@S@R@R33333@R33333@R     @R     @Rs33333@R,@R@Rfffff@Q@R      @Q@Qfffff@Q     @Q     @Q33333@Qfffff@Q33333@Qy@QY@QL@QL@QS33333@QFfffff@Q333333@Q@P@Qfffff@Q33333@P33333@P@P33333@Pfffff@Pfffff@P33333@P33333@P     @PS33333@P333333@P&fffff@P,@P,@P@O33333@Oٙ@O     @O@Os33333@O     @Offffff@O&fffff@N@N@Nfffff@Ns33333@N333333@N@M@Mfffff@Mffffff@M@Lٙ@L     @Lfffff@L     @LL@L      @Kfffff@K@Ks33333@KL@K&fffff@K@K@K      @J33333@Jfffff@J33333@J@Js33333@JL@J333333@JL@J@     @Jffffff@JL@J@     @J@I33333@I33333@I@I@I     @I33333@I@I@Iffffff@IL@I@     @I333333@I&fffff@I@I@Hfffff@H@H@H     @H@Hffffff@HY@H&fffff@H&fffff@H      @Gfffff@G@G@G33333@G33333@Gfffff@Gfffff@G@Gffffff@GL@G333333@G@F33333@F     @F@Fs33333@Fs33333@Fs33333@FY@F@E33333@E     @E@E33333@E@Es33333@Es33333@E@D33333@Dٙ@D@Dffffff@DY@D@D     @Dffffff@DL@D@     @Ds33333@DL@D@     @D333333@D333333@D&fffff@D@C33333@D      @D      @C33333@C     @C@C     @C     @C@C     @C@C@C@Cs33333@CL@C@     @C&fffff@C@B33333@C@C@Bfffff@B@Bfffff@B33333@B@B@Bs33333@BY@BY@BL@B&fffff@B&fffff@B@     @B&fffff@B@Afffff@A@A     @A33333@Afffff@A     @Affffff@Afffff@A     @AY@AY@A@     @AL@A333333@A@     @A&fffff@A@     @A@     @A&fffff@A@A@@fffff@@ٙ@@@@@@@@     @@ffffff@@L@@@     @@333333@?@?ffffff@?ffffff@>fffff@>fffff@>@>33333@>33333@>     @>333333@=33333@=ffffff@=ffffff@=333333@=333333@<fffff@<fffff@=      @<@<@<333333@<ffffff@<@<ffffff@<333333@<@<@<333333@<L@<333333@;33333@;@;ffffff@;@;333333@;L@;L@:fffff@;@:@:@:33333@:     @:33333@:33333@:ffffff@:333333@:@:      @:@9ffffff@9ffffff@9L@9L@9@9@9ffffff@9333333@9333333@9     @9L@9ffffff@9ffffff@9L@9@8fffff@9      @833333@8L@8333333@8L@8ffffff@8@7@7     @7L@7L@7333333@7@7L@7333333@7      @6fffff@6@633333@633333@633333@6fffff@6fffff@6fffff@6@6fffff@6@6     @6fffff@7333333@7L@7333333@7      @6@6fffff@7333333@7@7L@7333333@7L@7333333@6@6fffff@633333@6@7      @7      @6fffff@6fffff@6@6fffff@7      @6fffff@6fffff@6@6@7      @6@7      @7      @7      @6fffff@6@6@6fffff@7      @6@6fffff@6fffff@6@6     @6L@5fffff@5      @4@433333@5      @4fffff@5      @5L@5L@5L@5L@5L@5      @5      @5      @5333333@433333@433333@433333@4@4L@4      @4      @4@4      @4      @3@3@3fffff@3fffff@3fffff@3fffff@3@4     @4@433333@4@433333@4@4@4@4fffff@4@3333333@2@2@3333333@3ffffff@3@3     @3333333@2@2L@2L@233333@233333@2@2L@2      @2@2@2333333@1fffff@133333@133333@1ffffff@1     @1     @1333333@033333@0@0@0     @0@0     @0     @0L@/@0@0      @/@/@/@/@0@0333333@0@/ffffff@/@0      @0      @0      @/@/@0333333@0@/@0      @0333333@0333333@0ffffff@0@0fffff@0fffff@1@0fffff@0@033333@0@0@0@0@033333@0L@/      @-@.@/@/333333@.@.      @-ffffff@-333333@-@-      @-@-333333@-ffffff@-333333@-      @-      @-      @,@,ffffff@,      @+@,333333@+@,      @,@,@,@,      @,@,@,@,333333@,@,333333@,@,ffffff@,ffffff@,      @,      @,ffffff@,      @,333333@,333333@+@+@+@,333333@,      @+@+333333@+@+      @+ffffff@+ffffff@+333333@+      @+333333@*@*@*@+      @*@*@+      @+      @*@*ffffff@*ffffff@*ffffff@+      @*@+333333@*@*      @+      @*@*@*ffffff@*@*      @)@*      @*ffffff@*      @*      @*      @*@*@*ffffff@*333333                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ?Q?;dZ?Z1'??|hs?-V?I^5?}?333333?Q?      ?|hr?+?KƧ?|hr?bM?dZ1?lC?E?$/?tj~?$/?+?9XbM?E?Gz?+?vȴ9X?nO?
=p
?KƧ?E?vȴ9X?lC?zG?lC?ꗍO;d?l?;dZ?S? ě?ꗍO;d?"`A?-V?9XbM?(\)?\(?\(?Q?$/?I^5??+?`A7?j~"? ěT?`A7?;dZ?A7Kƨ?`A7?=p
=?lC?vȴ?C$?ȴ9Xb?C$?`A7?x?zG?
=p?dZ1?+I?333333?vȴ?Gz?n?+I?lC?ffffff?vȴ9X?ȴ9Xb?1&x?C$?
=p?땁$/?ffffff?\(?-V?1&?o?vȴ9X?n?-?-V?nO;?~"?"`B?\(?333333?\(?E?ꟾvȴ9?"`A?tj?ěS?(\)?QR?j~#?tj~?GzH??+?Z1'?1&x?=p
=?9XbM?7KƧ?ڰ ě?tj?Q?vȴ9X?I^5?}?lC?Õ$/?-V?vȴ9X?-V?dZ1?+J?
=p
?\(?+?tj~?nO;?nO;?nO;?Q?l? ě?l?333333?&x? ě?333333?lD?333333?Q? ě?hr Ĝ?Q?
=p?&x?
=p?&x?-V?Q?&x?&x?
=p?hr Ĝ?hr Ĝ?`A7L? ěT?`A7L? ěT?`A7L?bM? ěT?`A7L?&x? ěT?&x?333333?lD?`A7L?`A7L? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?bM?
=p?bM? ěT?vȴ9X?;dZ?;dZ?bM?vȴ9X?vȴ9X?&x?lD?`A7L? ěT?vȴ9X? ěT?`A7L? ěT?`A7L?`A7L? ěT?vȴ9X?;dZ?vȴ9X? ěT?bM?Q?`A7L?
=p?`A7L?bM? ěT?vȴ9X? ěT?`A7L?vȴ9X?
=p?&x?bM? ěT?&x?lD?bM?bM?bM? ěT?vȴ9X?
=p?bM?bM? ěT? ěT?bM? ěT?;dZ?;dZ?vȴ9X? ěT?;dZ?;dZ?vȴ9X? ěT? ěT? ěT?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?Q?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?Q?;dZ?;dZ?vȴ9X?Q?Q?vȴ9X?vȴ9X?;dZ?Q?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?vȴ9X?Q?;dZ?Q?;dZ?;dZ?Q?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?bM?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?&x?
=p?vȴ9X?vȴ9X?vȴ9X?Q?Q?Q?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?Q?vȴ9X?Q?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?Q?Q?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?Q?;dZ?Q?vȴ9X?;dZ?bM?Q?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?Q?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?vȴ9X?Q?Q?Q?Q?;dZ?;dZ?;dZ?5?|h?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?vȴ9X?vȴ9X?;dZ?Q?;dZ?;dZ?Q?vȴ9X?Q?Q?Q?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?5?|h?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ? ěT?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?Q?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?Q?Q?Q?Q?vȴ9X?vȴ9X?;dZ?Q?;dZ?vȴ9X?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?Q?vȴ9X?vȴ9X?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?5?|h?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?Q?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?5?|h?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?Q?Q?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?Q?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	P24                                     1                                       )VBGY3N