CDF       
      pressure  _   time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20170205   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P17    CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:34.905702Z    ORIGINAL_HEADER      6CTD,20250210CCHSIOWB
#Removed 'CTDFLUOR_TSG' as it's filled with -999
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2017-06-29. CTD data from cruise 18DD20170205, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20170205. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2017-001/index.php. 
#
# The information in this file for the cruise 2017-001 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-0036.ctd
#
# Start of originator file comment header
#
#*2017/06/29 15:26:50.02
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2017/02/10 06:17:38.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 198
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : CE9F1F72
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            0.3            202.1
#       2 Temperature:CTD               deg_C_(ITS90)   5.6248         6.8697
#       3 Salinity:CTD                  PSS-78          32.78          33.8432
#       4 Sigma-t:CTD                   kg/m^3          25.7461        26.7106
#       5 Oxygen:Dissolved:CTD:Volume   ml/l            3.4            6.87
#       6 Oxygen:Dissolved:CTD:Mass     µmol/kg         147.7          299
#       7 Fluorescence:CTD:Seapoint     mg/m^3          0.66E-01       1.162
#       8 PAR:CTD                       µE/m^2/sec      0              0.3
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        7  F       ' '     2
#       6  -99   ' '        6  F       ' '     1
#       7  -99   ' '        8  F       ' '     3
#       8  -99   ' '        7  F       ' '     1
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2017-001
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P21
#    EVENT NUMBER        : 36
#    LATITUDE            :  49  38.00000 N  ! (deg min)
#    LONGITUDE           : 139  39.97000 W  ! (deg min)
#    WATER DEPTH         : 3961
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    The descent rate of the CTD was very noisy with some complete reversals
#	of direction.
#    CTDEDIT was used to remove many records corrupted by shed wakes;
#	salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Fluorescence and PAR data are nominal and unedited except that some records were
#	removed in editing temperature and salinity and a large spike in
#	fluorescence was removed from file 0032.
#
#    The Transmissivity channel was removed because of frequent shifts in values during
#	casts and large variations between values during repeat casts.
#	The data are available, by request, from the chief scientist.
#
#    NOTE: While the Fluorescence:CTD data are expressed in concentration units, they
#	do not always compare well to extracted chlorophyll samples, particularly for
#	casts far from shore. It is recommended that users check extracted chlorophyll
#	values where available.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in Sea-Bird
#	Application Note #64-2, June 2012 revision (Sea-Bird_64-2_Jun2012.pdf), except 
#	that a small offset in the fit was allowed.
#
#    The Dissolved Oxygen sensor used in files 0001, 0002 and 0016 malfunctioned so the 
#	Oxygen:Dissolved:CTD channels were removed from those files.
#
#    The Oxygen:Dissolved:CTD sensor has a fairly long response time so data accuracy 
#	is not as high when it is in motion as it is during stops for bottles. This will be
#	especially true when vertical dissolved oxygen gradients are large. To get an estimate
#	of the accuracy of the Oxygen:Dissolved:CTD data during downcasts (after recalibration)
#	a rough comparison was made between downcast Oxygen:Dissolved:CTD data and upcast 
#	titrated samples. Some of the difference will be due to problems with flushing of 
#	Niskin bottles and/or analysis errors, so the following statement likely underestimates 
#	Oxygen:Dissolved:CTD accuracy.
#
#    Downcast (CTD files) Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.25 ml/l from 0 to 125 dbar.
#	±0.2 ml/l from 125 to 400 dbar.
#	±0.1 ml/l from 400 to 600 dbar.
#	±0.05 ml/l from 600 to 1500 dbar.
#	Low by up to 0.08 ml/l below 1500 dbar.
#
#    For details on the processing see document: 2017-001-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5--- --6-- ---7--- --8---
#!Pressu Temperat Salinity Sigma-t: Oxygen Oxyge Fluores PAR:  
#!re:CTD ure:CTD  :CTD     CTD      :Disso n:Dis cence:  CTD   
#!                                  lved:  solve CTD:          
#!                                  CTD:   d:CTD Seapoin       
#!                                  Volume :Mass t             
#!------ -------- -------- -------- ------ ----- ------- ------
#*END OF HEADER
     WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @O        data_max      @O        C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     :  2   pressure                	long_name         pressure   positive      down   units         decibar    data_min      ?ٙ   data_max      @^fffff   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      :  m   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d           temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?+   data_max      @ M(   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       :     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d           salinity                	long_name         salinity   units         PSS-78     data_min      @@B   data_max      @AJ:)y   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      : L   salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d       <D   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @*         data_max      @r{33333   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        : K   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d          CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?(\)   data_max      ?XbM   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      :    CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d       ϴ   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min                 data_max      ?   C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       : t   PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d       l   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min               data_max               C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     : (,   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d       c$   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( q   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( r   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      )D   data_max      )D   C_format      %10d       r4   latitude               	long_name         latitude   units         	degrees_N      data_min      @H:p   data_max      @H:p   C_format      %9.4f          r8   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      `U\R.   data_max      `U\R.   C_format      %9.4f          r<   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d        r@   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min        L   data_max        L   C_format      %4d        rD@O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     @O     ?ٙ?@@      @      @      @      @      @       @"      @$      @&333333@(333333@)@,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @9fffff@;      @<      @=@=fffff@>fffff@@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F@F     @G      @G     @H      @H     @I      @I     @J      @J@     @J33333@K     @L      @L     @M      @M     @N@N@     @O333333@Os33333@P      @P@     @P     @P     @Q      @Qfffff@Q     @R      @R      @R33333@R     @S      @S@     @S     @S     @T      @T@     @T     @Tfffff@UY@U     @U     @V      @V@     @V     @V     @V@W@X      @X@     @X     @Xfffff@YY@Y     @Y     @Z      @Z@     @Z     @Z     @[      @[Ffffff@[     @[     @\      @\@     @\     @\     @]fffff@]@     @]     @]@^Ffffff@^     @^     @_      @_,@_ٙ@`      @`      @`9@`fffff@`     @`     @`     @`@a,@a<@a`     @a|@a     @a     @a     @a@b,@b@     @b`     @b     @b     @b     @b     @b@c)@c@     @c`     @c     @c     @c33333@c     @c@d      @d@     @d`     @d|@d     @d     @d     @e      @e      @eC33333@e`     @e     @e     @e     @e     @f      @f#33333@f<@f`     @f     @ffffff@f     @f     @g      @g      @g@     @g`     @g     @g33333@g     @g@h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i@i     @i     @j      @j      @j@     @j`     @j     @j@jə@j     @k      @k@k@     @k`     @k33333@k     @k     @k     @l      @l@lI@l`     @l     @l     @l     @l     @m      @m      @m9@mffffff@m     @m     @m     @m     @n      @n      @n@     @n`     @ny@n     @n     @n     @o      @o      @o@     @o`     @o|@o     @o     @o     @p      @p     @p      @p333333@p@     @pP     @pa@pp     @p     @p     @p     @p     @p33333@p     @p     @p     @q      @q     @q33333@q4@q9@qS33333@q^fffff@qp     @q     @q     @q     @q33333@q@q     @qfffff@q     @r      @r     @r      @r.fffff@r@     @rP     @r`     @rp     @r     @r     @rfffff@rfffff@rfffff@r     @r     @r     @s      @s     @s      @s)@sC33333@sP     @s`     @snfffff@s     @s     @s     @s     @sљ@s     @s     @t      @t     @t      @t0     @t;33333@tT@t`     @tp     @t     @t     @t     @t     @t     @t33333@t33333@tfffff@u     @u      @u0     @u@     @uP     @u`     @up     @u@u     @u     @u     @u     @u     @u     @u     @v      @vfffff@v      @v0     @v@     @vP     @v`     @vp     @v@v33333@v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wL@w^fffff@wp     @w     @w     @w     @w33333@wfffff@w     @w     @w陙@x      @x     @xfffff@x.fffff@x@     @xP     @xa@xp     @x~fffff@x     @x     @x     @x     @x33333@x@x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y@y     @yfffff@y     @y     @y     @y     @y     @z      @z     @zfffff@z1@z@     @zP     @z`     @zp     @z     @z     @z     @z@z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{\@{nfffff@{     @{     @{     @{     @{     @{33333@{@{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|~fffff@|     @|     @|     @|     @|@|@|     @}      @}     @}      @}0     @}>fffff@}P     @}`     @}p     @}     @}     @}     @}@}fffff@}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~\@~p     @~     @~     @~     @~     @~     @~     @~ٙ@~fffff@      @     @      @.fffff@@     @P     @`     @nfffff@|@@fffff@     @     @     @     @     @fffff@     @     @     @33333@)@0     @8     @@     @H     @P     @X     @]@rfffff@x     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @      @     @     @     @      @(     @0     @8     @A@H     @P     @X     @`     @h     @nfffff@vfffff@@     @     @     @     @33333@     @     @     @     @     @     @     @     @     @@      @     @     @@!@(     @0     @8     @@     @D@Rfffff@X     @`     @h     @p@x     @     @     @33333@33333@     @     @     @     @     @     @     @     @     @33333@     @     @      @     @     @fffff@ @(     @0     @8     @@     @H     @P     @W33333@d     @h     @p     @vfffff@     @     @     @     @     @     @     @     @fffff@     @@     @     @     @     @     @      @     @@      @(     @0     @8     @<@Jfffff@P     @X     @`     @h     @q@x     @     @     @     @     @     @     @33333@     @     @     @     @ՙ@@     @     @     @      @33333@fffff@     @      @(     @0@733333@@     @H     @P     @X     @`     @g33333@q@x     @     @     @     @     @     @     @@fffff@     @     @     @     @     @     @     @     @      @33333@     @     @      @(     @0     @8     @=@I@P     @X     @`     @g33333@p     @x     @     @     @     @@33333@     @     @     @     @     @     @fffff@33333@     @     @     @      @33333@fffff@@      @(     @0     @8     @<@Jfffff@P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @@     @     @     @     @     @     @     @fffff@33333@      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @nfffff@zfffff@     @     @@@     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @*fffff@0     @8     @@     @H     @P     @W33333@`     @h     @p     @x     @     @     @     @@fffff@@     @     @     @     @     @     @     @     @     @33333@     @     @     @ @$@1@8     @@     @H     @P     @X     @`     @g33333@s33333@x     @     @     @     @@@     @     @     @@     @     @     @     @@@      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @s33333@x     @     @     @     @@     @     @     @fffff@     @     @     @     @     @     @     @ @     @     @     @      @(     @.fffff@8     @@     @H     @P     @X     @`     @h     @o33333@fffff@     @     @fffff@     @     @     @33333@     @     @     @fffff@陙@     @     @      @     @fffff@@      @(     @0     @8     @@     @H     @P     @W33333@`@h     @p     @x     @     @     @@@@     @33333@33333@     @     @     @     @     @fffff@33333@     @     @     @      @(     @0     @8     @K33333@P     @X     @`     @h     @p     @x     @|     @@     @     @     @     @     @     @     @͙@fffff@     @     @     @fffff@	@     @     @      @(     @0     @8     @@     @Ffffff@Rfffff@`     @h     @p     @x     @     @     @     @@     @     @     @     @     @     @     @     @ݙ@33333@33333@      @     @     @     @     @     @!33333@$     @(     @,     @1@4     @8     @<     @@     @D     @H     @K33333@P     @R@Xfffff@\     @`     @d     @h     @l     @p     @s33333@}33333@     @     @     @     @     @fffff@fffff@     @     @     @     @     @@     @     @     @fffff@     @     @     @     @     @     @@홙@     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @+33333@0     @3@7@<     @@     @D     @H     @L     @P     @T     @]@`     @d     @f@q@t     @x     @|     @     @     @     @     @fffff@@     @     @     @     @     @     @     @     @     @     @@fffff@     @     @     @     @     @     @@     @      @     @     @
fffff@33333@     @     @     @      @$     @(     @533333@8     @<     @@     @C@I@L     @P     @X@\     @`     @d     @h     @lfffff@nfffff@y33333@|     @     @     @     @     @fffff@fffff@     @     @     @     @     @     @     @33333@fffff@     @     @     @33333@噙@     @     @     @󙙙@33333@      @     @     @     @33333@@     @      @$     @(     @0@4fffff@733333@;@@     @D     @H     @L     @P     @S@`@d     @h     @l     @p     @t     @v@fffff@     @     @     @     @     @     @33333@     @     @     @     @     @@@Ǚ@@     @     @     @     @     @33333@fffff@     @     @      @@     @     @     @     @     @@%33333@(     @,     @0     @4     @6     @<     @@@Lfffff@P     @T     @X     @\     @h     @l     @p     @t     @x     @|     @@33333@     @     @     @     @     @@     @     @     @     @     @     @     @33333@     @     @     @     @fffff@홙@     @     @     @     @@@     @@     @     @     @     @      @$     @133333@4     @8     @<     @@     @B     @P@T     @X     @\     @`     @d     @ffffff@t@x     @|     @     @     @     @     @     @33333@@     @     @     @     @33333@     @     @     @     @     @     @י@     @     @     @     @     @fffff@33333@     @     @@@     @@     @     @     @     @      @"@(@+@133333@4     @8     @<     @@     @Bfffff@H     @L     @P     @T     @X     @\     @_33333@h@l     @p     @t     @x     @|     @@@     @     @     @     @33333@@     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @      @,     @0     @4     @8     @;@@     @D     @G@M@P     @T     @X     @\     @`     @b@hfffff@l     @p     @t     @x     @zfffff@33333@     @     @     @     @     @     @fffff@fffff@     @     @     @     @fffff@@     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @      @     @
33333@     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @S33333@\@`     @d     @h     @l     @p     @t     @x     @z@     @     @     @@fffff@     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @fffff@@㙙@fffff@     @     @     @     @     @      @     @     @     @     @fffff@     @      @$     @(     @,     @0     @4     @8     @@@D     @H     @L     @P     @T     @X     @\     @`     @b     @h     @k@p     @t     @x     @|     @     @33333@@     @     @     @     @     @     @     @     @33333@33333@33333@33333@33333@     @     @     @     @     @     @     @     @     @33333@     @     @     @     @33333@@      @     @     @     @     @     @@     @      @$     @(     @,     @0     @4     @8     @<     @?@Dfffff@H     @L     @P     @T     @X     @\     @`     @d     @m@p     @t     @x     @|     @     @     @     @33333@@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @뙙@@     @     @fffff@@     @     @     @     @     @     @     @      @$     @(     @,     @0     @2fffff@<@@     @D     @H     @L     @P     @T     @V@a@d     @h     @l     @p     @t     @x     @|     @     @     @33333@     @     @     @     @     @     @     @     @@@     @     @     @     @     @     @     @     @     @fffff@ᙙ@     @     @     @     @     @     @     @      @     @@fffff@     @     @     @      @$     @(     @,     @0     @4     @8     @;@>fffff@Dfffff@H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @@     @     @     @@     @@     @     @     @     @@@     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @      @33333@fffff@@     @     @     @      @$     @(     @,     @0     @5@6@=33333@@     @D     @H     @L     @P     @T     @dfffff@h     @l     @p     @t     @w33333@33333@     @     @     @     @     @fffff@fffff@     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @33333@     @     @      @     @     @     @     @     @@ @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @Lfffff@P     @T     @X     @\     @`     @d     @h     @jfffff@p     @t     @x     @|     @     @     @     @     @     @     @     @     @@fffff@     @     @     @     @     @     @     @     @     @     @fffff@ۙ@     @     @     @     @     @     @     @     @33333@	@     @     @     @     @     @      @$     @(     @,     @0     @2fffff@:     @<     @@     @D     @H     @L     @P     @T     @W@]33333@^fffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @҉@sP@ӎMj@tj~@a@O@Ʌoi@Ʌoi@E@L_@՛=K@fA@L_@L_@L_@յsh@Ϫ͞@ᰉ@ᰉ@8YJ@Ϫ͟@
=p@
=p@$tS@sPH@׍O;d@ק&@@bM@+j@+j@*0@ؓtj@حU@حU@@@حU@@@e+a@JE@0
)@JE@e+a@e+a@0
)@+@ٳ|@>BZ@JE@ק&@$tS@֡af@՛=K@Ʌoi@Ʌoi@ԕ*1@L_@t@Ov_@Ϫ͞@@@Z@@ө*0U2@Fs@Ʌoi@zG@Fs@,<@ө*0U2@:)y@:)y@ѷX@ќu@$tT@Ж@ξߤ?@@cA \@҈@Ƨ@˒:)z@C%@xF]@D@D@D@D@=p
@ɅoiD@7KƧ@ ѷ@ȴ9Xb@˒:*@K]c@@#@_o@_o@_o@_o@@ԕ*@#9@ԕ*@Q@s@T`d@bM@@N@o@҈p;@)^	@F&I@@N@@ @ ;S@ Bu%F
@ ?˒:)@ M(@ LL_@ C
=p@ 8F]d@ 0{@ %O
@ <64@ b}@ 8YJ@ H@l@l!-@W'@{m@vȴ@eO@@^ ѷY@Z6C@V8YJ@RS&@GzH@?b}V@8)@-B@$7@]ce@|@@Y|@6z@!R<@ hۋ@~($@fB@a@@@TɆ@$tS@H˒:@kjf@],=@LcA \@B@4n@=<64@5?|h@&fffff@L_@
D@@@@#@	@N;5@,zxl@\N<@!R@Q@rGE85@fL/{J@a|Q@Xtj@H@=<64@-
qv@o@_p@@n/@\(@iB@ ѷY@$tS@յsh@N;6@#x@xF@Ϫ͟@@k6z@Zu%F@H9Xb@>BZc @8-
@-B@$e@!ae@!-w1@-V@Y@Z@!R<@q@ݗ+@JM@Q@;dZ@(@Q@*0@cA \@     @t3@cZ@T@L@2-V@'&@$xF@(\@hr @qi@ڹZ@d7@F
L0@$tS@\)@쿱[W@Z@}v@]+j@S@N@QR@JL_@B\(@?$tS@<hr@4m8@+P{@o@m\@T`d@[W>@U=@*0@9Xb@n1@]cA @L~($x@5?@(r Ĝ@"M@{@K]@wkP@T`d@~$@fB@g/V@TO
M@=v@*fB@!Gz@Ov_@\(@
n@I^5@m\@K]@=b@!-w@߾vȴ9@>BZ@S&@$xG@Z@n@sߤ@hXy=@eS@Oo @Kq@E8YK@?|hs@7KƧ@+C]@@
jOv@@E@ᰉ'@/@o@ce@e+a@#9@-V@HeO@;A@m@@Z@%F
L@GE85@1@5?|@҉@eں@o@Xe,@cA \@u'0@_o@XbM@K'/@G)^@C@BI^5@?|hs@<Z@8}H@3ߤ@-V@'RT`e@5?|@`d@rGE9@-@쿱[@g	l@쿱[W@Z@'/@\(@3@=K@:@˒:*@p:@vFs@ffffff@KƧ@B74@:)_@3E@.O;@-(@,"h	ԕ@$qj@vȴ9@C,zx@Z@tj~@E84@@Fs@Ίqi@)^@D@r Ĝ@T@@7Kƨ@w3@j0
@g/V@eO
@bwkQ@[S@V@S&@O\(@L_@I@>$t@73@5'0@,[W?@$tS@	@PH@ᰉ'@&@C,@ߊ	@}H@C,zx@c	@ٙ@PH@l!-@R<6@՛=K@ԯO
M@@N@hr @o @As@͞%@@ڹY@š@o hی@H˒:@"`@?|h@l@C\@jf@g	@IQ@`A@@tj@Mj@T`d@)^@s@+I@g8}@o h@Zc@@xF@qu!S@irGE@b}Vm@a'R@`ěT@`'RT`@]/w@]}H@]cA @Y>BZ@TFs@K҈@DS@@6@:xl"h
@5!R@49XbN@3|@12W@.H@%ڹ@ -
@-V@)^@_o@S@o hی@ 4m@ ѷX@ 4m@m\@쿱[@z@쿱[W?@x@M@ݲ-V@ؓtj@y=c@bM@t@ӎMj@L_@o hی@b@l"h	@J@{m@oiDg8@ hۋ@v@1@8Y@>B[@U=@Ov`@fA@|Q@u%F@$tS@$tS@@
=p@@a@O@@Vu@jOv@s@M:@qu"@L/{@I^5?@Vu@jOv@/{J#@,zxl@{A@w4m@p{@`A7K@^҈p;@W+j@Rm@JڹY@F]cf@D2W@DS@D?@DJM@B&IR@;J#9@1[W>6@(Xy=@"3@!@N@+j@,<@+@y=c@y=c@@tj~@
5Xy>@	^5?}@9Xb@+I@Q@ n@MjO@a@@fffff@n.3@R<6@Ov_@@s@]cA@W'@ɠ'RTa@@@s@Ňݗ@a@N@ߤ?@)y@KƧ@C-@1@!-w2@(@L/{J@
=p@}Vm@[@E@zH@n/@ݗ@JM@2W@@~m\@|Q@weں@u?|h@qu!S@q@q@p{@or@k6z@e1@c9@\?@\?@_U=@`ěT@_o@]ce@\1&@^ ѷY@ae@f@eF
L0@d/@dtSM@d?@a'R@\N;@U2a|@I@C@A@>vȴ9X@;/V@6}Vl@5\(@5'0@3g@4!-w2@3|@3@2ᰊ@0:~ @.H@,q@*d7@)y@($xG@&'@%zxl"h@!'R@Ov_خ@n@1&x@@>BZc@@A [@ԕ*1@_o @Z@C-@<64@74@ߤ?@6@@XbM@a|Q@
qv@0U2a|@*0U2a@TɅ@-@-@x@@S&@vȴ9@wkQ@e+a@@y	k~@f,<@dZ1@ffffff@eO
@f1.@e`A7L@dqj@gfA@eO
@]cA @P{@B&IR@:)_@12W@6C@@u%F@u%F@@#@o h@A [@Ʌoi@K]c@2W@ [7@~@S@,<@Xe,@:)y@_o@y	k~@n.2@_Ft@\?@Xe+@PH@M:@KƧ@JD@E@Dg8}@D2W@C\N@C\N@C\N@Dg8}@BZc@B\(@B&IR@@n@As@?|hs@<n.@7rG@ 	k@
GE85@
>BZ@
@
s@
ɅoiD@
L/@
o i@
g8}@
g8}@
Zc@
ߤ?@
A@
YJ@
z@
4K@
?@
g	l@
ᰊ@
&x@
 ě@
}Vl@
q@
lD@
/@
[6@
$tS@
\(@
n/@
x73@
v!.I@
vȴ9X@
uY|@
rs@
lVϪ@
glC@
cS@
`҈p@
]ce@
T,<@
K:)z@
E@
?@
=v@
=K]@
74m@
3ߤ@
,zxl"@
&@
!o@
!-w1@
IQ@
0
)@
sh@
4J@
	 @"@+jg@@7@C,@@4@҈p;@e+@H@n@E84@5Xy@z@?|h@{@%@*0U2@C%@{J#9@vȴ9X@s@sg@r ě@rGE85@ql@poiDg8@qu!S@qA [@n.2@h>BZc@de@_حV@]+j@[6@W
=p@VϪ͟@Q@Jn@G)^@C@@n@9~($@.}Vl@ݗ+k@Mj@
qu"@ݗ+@l@Q@C,z@fffff@eO@֡af@m@䎊@*0U@;dZ@+@/{J#@#9@y@@Zc@Zc@&IR@@vȴ9X@BZc @[W>@ߤ?@
(@@4m@33333@2W@&x@&x@ ě@r@O
M@zG@zG@
qv@6z@\)@L/{J@wk@ěT@kP|@qiC@ѷX@~($x@v_ح@rGE85@oiDg8@mC\@lVϪ@jg	@ix@fA@dqj@\N;@W@R<64@OAs@L/{J#@JD@I@GzH@F?@@C@:S&@74m@73@7KƧ@9XbM@73@7rG@49XbN@+U=@vȴ9@sh@nO@!R<@ݗ+@%2@@
"@
xl"h
@
x@
1.@
Z@
R@
;dZ@
̘_@
m\@
Õ$@
2W@
@
g8}@
\(@
&IR@
[W>@
dZ@
)_@
Xe@
-@
U2a|@
O
M@
w1@
q@
{J#:@
I^@
x@
zxl"h@
TɆ@
ae@
u@
1&@
@
Fs@
N;6@
O;dZ@
k~(@
M:@
}E@
u%F
L@
kQ@
ae@
ZY@
S@
R䎊@
N+@
I@
Gy@
D*0@
Ca@N@
>6z@
9Y}@
73@
0{@
+I^@
$?@
$?@
 'RT`@
쿱[W@
Q@
%@
Q@
!-w1@
%@
IQ@
qu!@
0
)@
zG@
'/W@

M:@
L_@
n/@
?@	$t@	G{@	Fs@	.2@		k@	e+@	"`B@	`A7@	ߤ@	Ov_خ@	M:@	S&@	     @	yrGE8@	u!.@	s@	oiDg8@	iB@	h>BZc@	eڹ@	eO
@	eO
@	d%1@	b@4@	^iB@	\?@	[q@	Y|@	XbM@	T*1@	O
M;@	MjOv@	F]cf@	@n@	6E@	,>B[@	+a@@	)@	)lD@	%u@	쿱[W@	0
)@	*0@	Fs@	@	#@	nP@حV@|@:@]cA@@˒:*@)^@ěS@#w@J@o@
(@v@V@V@IQ@,<@0
)@PH@@sh@@@N@҉@sP@*0U2@sP@1&x@JM@?@~$t@|Q@{s@r ě@poiDg8@l"h	ԕ@j~"@hۋq
@e@bC,@`d8@[$@T,<@N;5X@H@E84֡@Ca@N@ATɅo@>vȴ9X@9Y}@84֡b@6C-@+jf@&x@#S&@u@u%@kP|@=K^@tj@$/@	 ѷ@b}V@73@ڹ@ߤ?@ce@ڹY@t@2a|@ԕ*1@m@m@ӎMj@`A7@v_ح@As@@N;5@l!-@ΤT@6z@n.3@䎊r@쿱[W@@N@bM@'/W@'/W@O;dZ@ڹY@eO@oiDg@{J#9@~$t@y	k~@sPH@o4֡a@a@N@]/w@Xe+@W>6z@T`d@QN;5@O
M;@G@@C$@B74@ATɅo@?[W>@=<64@:~@8)@64K@49XbN@43@3ߤ@1[W>6@-
qv@-
qv@#9@,=@C,zx@@@+J@ᰉ@n@hr @rGE9@-
q@\(@Mj@'/@	k~(@1&x@ݗ+@ IQ@l"h	@!.I@!R@.2@fA@Z1@Gz@څݘ@Ϫ͟@Ϫ͟@8YJ@Ϫ͞@2a|@a@O@]cf@[W>@Y}@XbM@Q@zxl"@$xG@tSM@u@7KƧ@?@JM@o h@xF@k~($@eڹ@d7@cA [@b}Vm@ae@_حV@^@U=K@M5Xy>@Jn@H9Xb@@4m@=b@<쿱[@:)_@2W@.}Vl@&@@
(@
=p
@@˒:)@H˒@PH@l"h	@\(@PH@
=q@:~ @.2@@O;@C]@1.@?@ҽ<64@т@;dZ@@ʌL_@2W@D@3@
(@1&y@lD@/V@TɆ@hr @L/{@YJ@Fs@Fs@}H˒@nc	@bC,@aGz@]cA @[$@[$@T`d@Q@O
M;@MjOv@L_@K:)z@K:)z@M@R䎊@JW'@C@64K@/{J#:@*0
@$/@kP|@u@ߤ?@@C%@~($x@
qiC@
=p
@	k~(@p:@
qiC@
=p
@p:@eO@_o@ ѷ@:S@m\@Vl!@kP@u!S@빌~($@1.@Gz@2a|@As@/V@4m@4m@4m@KƧ@?|h@m8@2W@r@zG@U=@/V@wkQ@sP@qu"@qiC@}!.H@y	k~@v!.I@sE@r ě@o4֡a@iB@hr Ĝ@gfA@f,<@ffffff@eO
@e`A7L@e@eO
@cA [@YJE@RT`d@PH@HK]c@C$@B74@ATɅo@=b@9~($@8Q@49XbN@.zG@%u@䎊r@u@u"@O;d@R<6@zG@:)y@@eO@K]d@_o@Fs@JM@nP@o hی@\N<@m]@@+@#@{m@iDg8@	ԕ+@Z@A [@Ft@ce@/w@ۋq@@T`d@Ƨ@,zxl@S&@KƧ@z@z@2W@U=@jf@6z@d7@*0U2a@F
L0@쿱[W@Q@0
)@O;d@@҉@bM@q@M:@@@4m9@w+@rGE85@o@mC\@kC]@hr Ĝ@g8}H@glC@fA@f,<@a|Q@\?@\>@\>@_Ft@]+j@]ce@\?@Y>BZ@TE@SMj@Rp:@Rp:@RT`d@QN;5@OAs@N+@I@BZc@@4m@<64@2W@/v@+U=@'RT`e@ ěT@쿱[W@PH@ݗ+k@u@qi@ݗ+@ݗ@o h@@I^5@ hۋq@m\@	k~@:~ @"h	ԕ@C,z@~"@x@@,<@7@Z1@1.@唯O
@Z@ߤ?@ޞ@5?|@ce@ܑN;@څݘ@>BZ@1'@e+@fA@ӎMj@ѷX@+@Ƨ@n@@@ȴ9Xb@ȴ9Xb@@ǮzH@8YK@84֡@BZc @)_@4m@'0@|@zxl"@a@@0
@I^@0
@lD@^@,@?@[6@}H@=K^@e+a@tj@Z@҉@hr @Mj@M:@ԕ*@#@$/@tj@˒:)@xF]d@p@kP{@h@hۋq
@h	ԕ+@e`A7L@a|Q@_o@["`B@P*0U@N+@M@K:)z@HK]c@GE84@E@C$@ATɅo@ATɅo@@6@>ߤ?@>BZc @=b@=<64@<j~#@;5Xy@:)_@9XbM@84֡b@64K@4m8@0 ě@.2X@.zG@,>B[@-w1@-U=@+jf@+a@@+U=@+I^@)lD@'&@%u@"h	ԕ@"3@vȴ9@0
)@@$tS@*0@҉@o @Vu@
O;dZ@
@
M:@
O;dZ@
=p
@K]d@ݗ@S&@o h@%2@oiDg@n/@u%F
@$/@˒:)@$t@PH@Q@J#9@_ح@t@(@ᰉ'@,<@ⶮ}Vm@d8@u!@d8@u!@҈p@҈p@حV@;dZ@ce@Q_@JE@y=c@ٳ|@JE@+@@Ϫ͟@Ϫ͞@ԕ*1@Z@҈p:@_p@Ƨ@]cf@m\@a@N@)_@m8@m\@&x@v@H@2X@1@}Vl@>B[@<쿱@jf@0U2a|@y@Xy=@RT`e@wk@S&@h	ԕ@.H@-
@-
@!-w1@}H@wkP@@@sh@@N@-
q@bM@I^5?@C%@u%F@nP@:S@$/@}E@{lC@zxl"h
@x-
@v!.I@u%F
L@r䎊q@qA [@^5?|@]cA @_;dZ@_?@`d8@`u!@`҈p@`d8@`u!@_?@XD*@YJE@Q@N;5X@M5Xy>@L/{J#@K]cA@Jn@I^5?}@H@I@D*0@D2W@Eo i@E@Em\@C,zxl@B74@B\(@As@@4m@BZc@ATɅo@A [7@A7Kƨ@A7Kƨ@A [7@@C@?|hs@9Y}@3|@333333@3|@.1@#n.3@ 	k@vȴ9@쿱[W@쿱[W@U=@Ov_خ@}H@u"@[@Q@ [6@䎊r@䎊r@U=@U=@U=@Ov_خ@-V@[@C,zx@S@,<      @\(@Vu@	ԕ*@#@@ ?@ m]@ @ -
@ ȴ9X@ \(@ !.@ E@ GE85@ @ C\@ .2@ ~"@ Ov`@ >BZc@ Dg8~@ B@ B@ Ov`@ Ov`@ x@ x@ Dg8~@ fA@ c	@ 1'@ b}@ e+@ Z@ m@ ҽ<64@ m@ ҈p:@ а{@ +@ jOv@ cA \@ #9@ @ @@ Ƨ-@ š@ g8}@ ,zxl@ @ ߤ?@ 64@ )_@ 4m@ o@ }Vl@ U=@ *0U2a@ /V@ S@ TɆ@ R<6@ vȴ9@ tj@ S&@ ߤ?@ M:@ L_@ '/@ ԕ*@ u%F@ {J#9@ b}V@ }Vl!@ {m]@ zxl"h
@ zC\@ x73@ vFs@ uY|@ r{m@ p
=q@ nt@ m8Y@ l!-w@ lC@ l"h	ԕ@ jg	@ jJL@ ix@ glC@ e+a@ ^ ѷY@ ZY@ XU@ W@ Vl!-@ Vt@ U=K@ TɅoi@ SMj@ R<64@ Rp:@ RT`d@ QN;5@ Np:~@ L_@ Jn@ H˒:*@ Dg8}@ 9Y}@ 8Q@ 7rG@ 7rG@ 6z@ 5?@ 4֡a@ 3g	l@ 2a|Q@ 12W@ 1o@ 1&x@ /Vϫ@ -
qv@ -w1@ +a@@ (Xy=@ '/V@ &IQ@ &@ $/@ !-w1@ !-w1@ !ae@ 쿱[W@ Q@ u"@ Q@ @ ҉@ \(@ @ 
qu"@ C%@ u%F@ ݗ+@ 1&x@ K]d@ 1&x@ +I@ o hی?PH?"`?s?hr!?x??҈p?҈p;?iB???b}?ԕ*1?ѷX?ѷX?Ϫ͞?+                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @@B@@BG{@@B䎊q@@BG{@@BG{@@BG{@@BfB@@BC,@@B䎊q@@B䎊q@@BfB@@BfB@@B䎊q@@B䎊q@@BG{@@B䎊q@@BC,@@BfB@@B䎊q@@B䎊q@@B䎊q@@BfB@@BC,@@BC,@@BC,@@BC,@@B䎊q@@BC,@@BC,@@Bc	@@BfB@@B䎊q@@BfB@@Bc	@@BC,@@Bc	@@BC,@@BC,@@Bc	@@BC,@@BC,@@Bc	@@BC,@@Bc	@@Bc	@@BC,@@Bc	@@BC,@@BD@@B74@@B~@@Bm\@@Bm\@@B~@@C҉@@B~@@B74@@B74@@B~@@B~@@CI^@@B~@@CI^@@CI^@@B~@@B~@@Bm\@@Bm\@@CI^@@Bm\@@CS&@@CS&@@C҉@@C҉@@Cu%@@Cu%@@C'/@@Cs@@CPH@@CC,z@@CC,z@@C	@@C"`B@@C&@@C,zxl@@C,zxl@@C/V@@C,zxl@@C9@@C=K^@@CC%@@CP{@@CZ@@Ca@N@@CdZ@@Cjf@@Cn.3@@CQ@@CMj@@Cߤ@@Cq@@CƧ@@DL_@@DM:@@D`d@@DQ@@D_@@E@@F\N<@@G_o@@G4m@@G
M;@@J~"@@P9Xb@@XIQ@@v҈p;@@`d@@8YK@@'R@@ߤ@@TɅo@@fB@@u"@@O;@@{@@D@@Fs@@u"@@fA@@}H@@u@@eO@@g8}@@
(@@	k@@ۋq
@@N;5@@Q@@M:@@o h@@O
M@@2a|@@=K@@S@@,<@@1@@rGE9@@Dg8~@@)y@@W@@9@@ĵ?@@ſH˒@@?@@S@@S@@C\@@zG@@Ɗqi@@ǚkP@@ȷ4m@@ɅoiD@@M@@`A@@"`B@@a@@@̛S@@zxl"h@@ڹ@@?@@L/{J@@Ίqi@@φ&@@Ъd8@@хoiD@@:)y@@҅ݘ@@&@@%F
L@@S@@p:~@@m\@@8}H@@-@@؃n@@0
)@@ٰ'R@@@4n@@nO@@ڹY@@I^@@ۅQ@@tj@@?@@C,zx@@`d@@o i@@oiDg@@5?|@@޻@@U=@@߮zH@@
qu@@D*@@U2a|@@@@ۋq
@@C@@$tT@@ ѷ@@@N@@-w1@@[W>6@@u!S@@x@@7Kƨ@@ὥ@@͞&@@P{@@㋬q@@@@C]@@Q@@SMj@@䛥S@@/@@?|h@@zxl"h@@垃%@@嫟U=@@8YK@@_o @@4K@@fffff@@旍O;@@,<@@C-@@$tS@@[W>@@حV@@$xG@@tj@@@@u%F@@F@@+@@@@@@0
)@@=b@@k~(@@D@@=p
@@a|Q@@qiC@@W@@ڹY@@	@@6z@@Z@@빌~($@@@@|@@|@@믷@@eO@@q@@a@@@a@@@|@@@@Q@@Z1@@*1@@TɆ@@#x@@@@'0@@Q@@[@@!.H@@84֡@@B@@?|h@@zxl"h@@=K@@1@@-V@@cA @@
qv@@,=@@,=@@,=@@
qv@@
qv@@
qv@@,=@@Ϫ͞@@v@@U=@@H˒@@H˒@@cA @@cA @@cA @@8YK@@?@@8YK@@($x@@R<6@@z@@vȴ9X@@_ح@@\N<@@R<6@@p:~@@}Vl@@ȴ9X@@쿱[W@@)^@@.H@@y@@iDg8@@U=@@_o@@kP@@阮&@@/V@@vȴ9@@K]d@@@@;dZ@@+j@@
qu@@6@@A7K@@eO@@oiDg8@@u%F@@𭫟U@@@@@@@@@@ѷX@@*0U2a@@Dg8~@@Dg8~@@[W>6@@ae@@u!S@@hr @@^@@R<6@@^5?}@@D@@D@@D@@_o@@_o@@@@^5?}@@iB@@e@@>BZ@@y@@@@䎊@@&IR@@W'@@Y@@L/{@@`A@@~@@s@@33333@@C%@@S@@]cA@@jf@@xF]@@A@@*0U2@@m]@@6@@5Xy@@%2@@$@@J@@Q@@I^5?@@wkP@@/@@[@@[@@F
L0@@Vl!@@\@@fA@@}H@@ݗ@@!R@@%@@%@@v@@U=@@@@\(@@Ϫ͞@@8YK@@b@@S@@ᰉ@@ڹ@@zG@@u@@8YJ@@YJ@@O;@@-@@ߤ?@@t@@Fs@@,@@U=@@ݗ+@@˒:)@@@@@+j@@Xy=@@
=q@@`A7@@{@@rGE@@0
)@@e+a@@u@@.H@@nO@@wkQ@@@@)_@@m@@s@@W>6z@@$@@@@$@@J@@tj@@ߤ@@@J@@1&y@@J@@1&y@@@@lC@@҈@@a@@@a@O@@6@@
=p@@C]@@g@@g@@g@@@@$@@L_@@cA \@@S@@@@u"@@K]@@'0@@'0@@Q@@<64@@m\@@@@
qv@@t@@$/@@+jg@@?@@Ov_خ@@Ov_خ@@Ov_خ@@YJ@@fffff@@s@@}Vl@@@@A@@E84@@O;d@@$tS@@?@@͞@@r@@-@A 6@A *0@A >BZc@A _F@A U@A `A7@A 4֡b@Ak~(@A.H@A@AOv`@A3@AGE85@A:)y@A=p
@AY@AW@AsP@A ѷ@AnP@A&@A@N@AS@A]cA@A]cA@An.3@AQ@Am]@A|@A҈@A%2@A\N@APH@ATɆ@A[W?@A?@AJM@AF
L0@AM:@Aݗ@AO
@At@AYJ@A@A&I@A&I@A&I@Aȴ9X@A"@A4m@Ao @AحV@A;dZ@A-@A@A6@A1&x@A>BZc@AQ@Ar Ĝ@AěT@A	$/@A	+@A	:S@A	e+a@A	@A	@A	s@A	lD@A
-V@A
u%F
@A
74@Au%@A҉@AnP@A	@AC%@Ag	l@AQ@A~($@A%2@AJ@AxF@Aߤ@@AL_@A9XbN@Am8@ATɆ@A?@A
Q@A
S&@A
p
=@A
ݗ@A
hr!@A
ڹZ@A
M:@A
!R@A
cA @A ѷY@AOv_@Au@A5?|@A
(@AR<6@AYJ@Al!-@As@A@AFs@A4֡a@Aeں@A$tS@A-V@A[W>@A@A/V@Avȴ9@Ao @A@A@A+j@AF]d@A6@A6@A*0@A73@AK]c@Ahۋq@Ar Ĝ@AYJ@A
=q@A@@A`A7@A4֡b@A\)@A [7@A4J@Ak~(@AR<6@A@A1'@AC\@Ah	ԕ@AL_@AW@AC,@Am\@AnP@APH@AC,z@A	@A"`B@A,zxl@A)^	@A6z@A=K^@A=K^@An.3@AU=@A@A]ce@Aj~#@AcA \@Am8@Aj~#@Aj~#@Am8@AcA \@Am8@A#@A@Au@A2a|@AVl!@A1@AXy=@AXy=@Ash@A@A
(@AzG@A!R<@AR<6@AiB@Az@A+J@A,<@A1@A)^@Av@A>6z@AlC@Aݗ+@AحV@A@AbM@A'RT`@A_F@Al"h	@Ar Ĝ@A'RT@A@A{@AU@AU@A{@A9Xb@A{@A@@A@@AD@A`A7@Ae+@A@AGz@ATɅo@A~($@AY}@A@4n@AnO@A~"@Axl"h
@A{m@Axl"h
@Axl"h
@A~"@AL_@Aᰊ@Avȴ@A@A ě@A ě@A<64@An@A@A͞&@A`A@AڹY@A䎊q@Ac	@AI^@As@A6z@AMjO@Aqu!@AE@Aa@O@Aa@O@Aݗ+k@A@A!-w2@A2W@A?@AM:@A`d@A?@Azxl"@A?@AZ@A/@AZ@Au@AQ@A?|h@A`A7L@Asg@Aݗ@AڹZ@A+j@AXy=@A@A?@A!.@Au@A!R<@AVu@A\N<@A_ح@AiB@AIQ@A@A'@Aȴ9X@A1@A"@A hۋ@A
M;@AO
M@AlC@A&@A͞@ArGE9@ArGE9@A䎊r@A#@A      @A F]d@A F]d@A F]d@A 	ԕ+@A *0U@A *0@A 4m9@A A7K@A H@A Q@A [6@A hۋq@A r Ĝ@A 'RT@A tj@A u%F@A @A 
(@A {@A![W>6@A!o hی@A!rGE8@A!~($@A!"`@A!Y}@A!Y}@A"n@A"e+@A"C\@A"Q_@A"T`d@A"^5?|@A"^5?|@A"a|Q@A"nO@A"u%F
@A"p:@A"\(@A"ᰊ@A"0
@A"0
@A"0
@A"S&@A"L/{@A"vȴ@A"L/{@A">B@A"L/{@A"n@A")_@A"͞&@A"sP@A",<@A"ڹY@A"ڹY@A"ڹY@A"䎊q@A"G{@A"G{@A"m@A"~@A#I^@A#u%@A#s@A#&@A#a@N@A#@A#ߤ@A#~($@A#6@A#5Xy@A#|@A#a@@A#҈@A#%2@A#g@A#@A$Q@A$,<@A$<쿱@A$I^5?@A$VϪ@A$cA \@A$g8}@A$j~#@A$q@A$#@A$zxl"@A$@A$O
M@A$?@A$@A$j~@A$?@A$[W?@A$/@A%K]@A%/w@A%84֡@A%F
L0@A%fA@A%jOv@A%$/@A%M:@A%hr!@A%Ϫ͞@A%?@A&!R<@A&!R<@A&!R<@A&1.@A&BZc @A&L/{J@A&H@A&Ov_خ@A&L/{J@A&Vu@A&Vu@A&\N<@A&p:~@A&p:~@A&IQ@A&@A&$t@A&Fs@A&,<@A&T@A&,<@A&-@A&@A&@A&@A&ȴ9X@A&ߤ?@A&]cf@A&1@A&"@A'@A'Xe@A'$tS@A'8}H@A'E84@A'b}V@A'@A'&@A'K]d@A'@A'fA@A'@A'+j@A(F]d@A(bM@A( ě@A(-
q@A(4m9@A(4m9@A(K]c@A(bM@A(|@A(@A(@A(tj@A(tj@A(@A(tj@A(tj@A(@A(IQ@A(-
@A(U@A(
(@A()^@A(p:@A(D@A(`A7@A(C@A(	k@A) ѷ@A)+@A)4J@A)Gz@A)TɅo@A)rGE8@A)u@A)R@A*0U2a|@A*a|Q@A*qiC@A*@4@A*S&@A*L/{@A* ě@A*)_@A*,<@A*`A@A*G{@A*䎊q@A*G{@A*䎊q@A*C,@A+u%@A+s@A+҉@A+҉@A+PH@A+)^	@A+33333@A+9@A+MjO@A+dZ@A+q@A+S@A+S@A+S@A+q@A+6@A+|@A+lC@A+A [@A+$@A,!-w2@A,%1@A,64@A,쿱[@A,*0@A,Z@A,Z@A,>B[@A,u"@A,Z@A,!-w@A-[@A-(@A-2a|@A-+a@A-/w@A-84֡@A-5Xy>@A-m\@A-sg@A-w1@A-w1@A-$/@A-!R@A-ڹZ@A-hr!@A-O
@A-=K@A-O
@A-O
@A-H˒@A-cA @A-cA @A-@A-
qv@A-S@A-!.@A-ڹ@A.4K@A.
(@A.4K@A.Ov_@A..2@A.+jg@A.;5X@A.Vu@A.fffff@A.z@A.@A.O;@A.O;@A.af@A.Q@A.ߤ?@A.ߤ?@A.C-@A.Fs@A/Ft@A/Xe@A/$tS@A/$tS@A/,@A/.H@A/8}H@A/b}V@A/{J#:@A/	k@A/fA@A/+j@A/rGE9@A0@A06@A0*0U@A0@A0 ě@A0'RT`@A06@A0-
q@A04m9@A01&x@A073@A01&x@A0$xG@A0A7K@A0{@A0p:@A0F@A0D@A1@N@A1#w@A1*0U2a@A10
)@A14J@A1A [@A1JE@A1XbM@A1hr @A1u!S@A1~($@A1'R@A1o@A2s@A2&IR@A2:)y@A2@4n@A2C\@A2JL@A2Zc@A2~"@A2wkQ@A2wkQ@A2L/{@A2g	@A2<64@A2)_@A2,<@A2c	@A2D@A2m@A274@A3I^@A3s@A3PH@A3F]c@A3g	l@A3jf@A3qu!@A3{J#9@A3@A3@A3$@A3:)z@A3A@A3$@A3ߤ@A3A@A3*0U2@A3S@A3@A36@A3Q@A4n.@A4J@A4@A4C,zx@A4q@A4qj@A4쿱[@A4u"@A5K]@A5o i@A5'0@A5K]@A5V@A5qu"@A5<64@A5B@A5\@A5Y|@A5fA@A5O
@A5Xy=@A5@A6 ѷY@A6!R<@A61.@A68YJ@A6BZc @A6_ح@A6}Vl@A6Fs@A6,<@A6O;@A6@A6@A6T@A6T@A6m\@A6]cf@A6]cf@A6C-@A6Fs@A6!.I@A7
=p@A7v@A7$tS@A71@A7H˒:@A7sPH@A7	@A7-V@A7[W>@A7r@A7@A7o @A7@A7@A7;dZ@A7@A7rG@A7Vϫ@A7-@A7-@A7#@A8$xG@A8*0@A8D*@A8D*@A8D*@A8K]c@A8U2a|@A8y=c@A8@A8u%F@A8
=q@A8U@A89Xb@A8{@A8ěT@A8e+@A8{@A8$tT@A8\)@A9 ѷ@A9 [7@A9Dg8~@A9TɅo@A9Q@A9^@A9[W>6@A9[W>6@A9|Q@A9b}@A9oiD@A9oiD@A9@A9~($@A9~($@A9oiD@A9|Q@A9@A9n.@A92W@A9o@A9N;6@A9ᰉ'@A9lD@A:@A:	 @A:s@A:e+@A:䎊@A:#9@A:#9@A:#9@A:#9@A:䎊@A:)y@A:&IR@A:)y@A:0U2a|@A::)y@A:=p
@A:C\@A:GE85@A:T`d@A:h	ԕ@A:u%F
@A:{m@A:{m@A:vȴ@A:<64@A:C,@A:74@A:m@A:m@A:C,@A:74@A:D@A;S&@A;u%@A;'/@A;nP@A;	@A;)^	@A;P{@A;Z@A;g	l@A;U=@A;wk@A;U=@A;U=@A;S@A;q@A;a@O@A;Ƨ@A;@A;5Xy@A;|@A;|@A;|@A;|@A;|@A;Q@A;$@A<1&y@A<!-w2@A<%1@A<2W@A<,<@A<?@A<C,zx@A<M:@A<Z1@A<VϪ@A<g8}@A<~($x@A<#@A<C@A<S@A<쿱[@A<1&@A<TɆ@A<?@A<[W?@A<7@A<Ʌoi@A<Z@A<Ʌoi@A<*0@A<֡a@A<>B[@A<u"@A<hr@A<!-w@A='0@A=u@A=[@A=!.H@A=5Xy>@A=?|h@A=5Xy>@A=S&@A=S&@A=S&@A=S&@A=`A7L@A=p
=@A=+j@A=%@A=Xy=@A=1@A=-V@A=sh@A=Ϫ͞@A=@A=@A=8YK@A=8YK@A=?@A=ᰉ@A=C\@A>t@A>
L/@A>
(@A>4K@A>Ov_@A>$/@A>.2@A>BZc @A>E@A>H@A>R<6@A>_ح@A>p:~@A>s@A>vȴ9X@A>IQ@A>+J@A>@A>qi@A>$t@A>$t@A>af@A>}Vl@A>}Vl@A>2X@A>-@A>2X@A>}Vl@A>}Vl@A>'@A>t@A>+@A>҈p;@A>҈p;@A>҈p;@A>+@A>ߤ?@A>]cf@A>Mj@A?@A?
=p@A?Xe@A?+I@A?4֡a@A?>6z@A?KƧ@A?iDg8@A?iDg8@A?sPH@A?{J#:@A?@A?	k@A?[W>@A?r@A?/V@A?/V@A?K]d@A?o @A?@A?;dZ@A?#@A@@A@*0U@A@bM@A@@A@@A@}H@A@'RT`@A@-
q@A@'RT`@A@*0@A@1&x@A@:~ @A@>BZc@A@D*@A@H@A@D*@A@NU@A@NU@A@K]c@A@U2a|@A@_F@A@hۋq@A@hۋq@A@r Ĝ@A@|@A@|@A@YJ@A@'RT@A@'RT@A@n@A@'RT@A@@A@-
@A@tj@A@IQ@A@{@A@4m@A@ěT@A@ěT@A@҈p@A@D@A@e+@A@e+@A@@A@@A@C@A@{@A@PH@AA@AA [7@AA [7@AA-w1@AA-w1@AADg8~@AAGz@AAJE@AATɅo@AAXbM@AAk~(@AAe+a@AAk~(@AAhr @AAx@AAo@AAl@AAX@AAD@AA@AA2W@AAN;6@AA"`@AAᰉ'@AAY}@AB1'@AB)y@AB)y@AB3@AB@4n@ABC\@ABGE85@ABQ_@ABM@ABM@ABT`d@ABZc@AB^5?|@ABa|Q@ABd7@ABh	ԕ@ABkP|@ABkP|@ABqiC@ABqiC@ABxl"h
@AB{m@ABp:@ABS&@ABS&@AB@AB>B@AB}Vm@AB)_@AB)_@ABW@AB`A@ABڹY@AB ѷ@AB䎊q@ABfB@ABfB@ABfB@AB䎊q@AB ѷ@ABfB@ABc	@ABc	@AB74@ACS&@ACS&@ACI^@AC҉@AC҉@ACC,z@AC33333@AC9@AC9@AC9@ACC%@ACZ@ACa@N@ACdZ@ACn.3@ACqu!@ACtj~@AC~$@AC~$@ACQ@ACeO@ACU=@ACS@ACE@ACE@ACƧ@AC|@AC5Xy@ACa@@AC|@AC
=p@AC
=p@AC
=p@ACݗ+k@ACC]@ADn.@AD1&y@ADxF@ADxF@AD@ADtj@ADL_@ADtj@AD!-w2@AD!-w2@AD%1@AD,<@AD/{J#@AD?@ADSMj@ADVϪ@ADVϪ@ADm8@ADo h@AD#@AD*1@AD_@AD_@ADN;@AD_@AD_@AD3@AD3@ADzxl"@ADTɆ@ADTɆ@ADO
M@AD@AD[W?@AD7@AD#x@AD[W?@ADɅoi@AD7@AD?@AD*0@ADZ@ADu"@ADJM@ADhr@ADE@AD!-w@ADE@AEo i@AEV@AE*0@AEQ@AE!.H@AE2a|@AE/w@AE2a|@AE84֡@AEB@AEF
L0@AEL_@AES&@AE}H@AEݗ@AEzxl"h@AE}H@AEw1@AEzxl"h@AEw1@AEw1@AE}H@AEݗ@AEO
@AE=K@AE-V@AE@AEn/@AEn/@AEH˒@AEn/@AE\(@AE8Y@AE@AE8YK@AEb@AE@AEϪ͞@AE@AEb@AEb@AE
qv@AE
qv@AEᰉ@AE@AE,=@AE,=@AE
qv@AES@AEᰉ@AEᰉ@AEoiDg@AF ѷY@AF
(@AF4K@AF@AF($x@AFBZc @AFBZc @AFL/{J@AFR<6@AFL/{J@AFOv_خ@AFVu@AFR<6@AFYJ@AFYJ@AFL/{J@AFL/{J@AFH@AFR<6@AFVu@AFVu@AFOv_خ@AF\N<@AFc	@AF_ح@AFfffff@AFfffff@AFfffff      @AFFs@AF@AF,<@AF-@AFm\@AFm\@AFm\@AFt@AFϪ͟@AF+@AFߤ?@AF+@AFC-@AF1@AF쿱[W@AFFs@AFFs@AG hۋ@AG hۋ@AGFt@AG@AG hۋ@AG@AGFt@AGFt@AGFt@AGFt@AG
=p@AG
=p@AG>6z@AG8}H@AG8}H@AG;dZ@AGO
M@AGH˒:@AGKƧ@AGH˒:@AGKƧ@AGRT`e@AGeں@AGXe,@AGeں@AGeں@AGiDg8@AGsPH@AGv_ح@AGv_ح@AG4m@AG4m@AGO;d@AG@AG$tS@AG$tS@AG&@AGr@AG@AGK]d@AG+@AG@AG@AG@@AG@AGVϫ@AHF]d@AHbM@AH6@AH ě@AH$xG@AH*0@AH1&x@AH4m9@AH>BZc@AHQ@AHXy=@AH[6@AHbM@AH_F@AHhۋq@AHoiDg8@AHr Ĝ@AH|@AHn@AHYJ@AH'RT@AH@AH@AH-
@AH-
@AH@AH@AH-
@AHd8@AH
(@AHěT@AH)^@AHp:@AHp:@AHF@AHD@AHD@AHۋq
@AHۋq
@AHe+@AH҈p@AH`A7@AH@AH\)@AH	k@AH$tT@AI	k~@AI*0U2a@AI-w1@AI0
)@AI0
)@AI7KƧ@AI:S@AI=b@AIA [@AIGz@AIJE@AIN;5@AIN;5@AIQ@AI[W>6@AI[W>6@AIhr @AIhr @AIk~(@AIo hی@AIo hی@AI|Q@AIb}@AIb}@AIb}@AIoiD@AI7Kƨ@AIo@AI@AIu@AIl@AIX@AI^5?}@AIX@AI@AIԕ*@AIN;6@AI_o@AIN;6@AIԕ*@AI@AIiB@AI@AI@AI.H@AJn@AJI^5@AJs@AJ1'@AJ1'@AJ䎊@AJ&IR@AJ&IR@AJ)y@AJ0U2a|@AJ6C@AJ6C@AJ:)y                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @ry@rq@rh     @ry@rx     @rq@ri@rh     @rc33333@r\@rVfffff@rd@ri@r`     @r\@r[33333@r\@ra@rp     @ri@ri@rd@r`     @rd@rk33333@ri@r`     @rc33333@ri@rl@rl@rl@rp     @rnfffff@rh     @rc33333@rffffff@r`     @rc33333@rffffff@ri@rnfffff@rq@rt@rp     @rh     @ri@ri@rffffff@rd@ri@rh     @rc33333@ri@r{33333@rd@r`     @r`     @r`     @ra@ri@rl@rd@rd@rc33333@ra@rc33333@rc33333@ri@rh     @rd@r`     @r`     @rP     @rP     @rS33333@rT@rY@rc33333@rffffff@rffffff@ri@rh     @rK33333@rI@rL@rT@r[33333@r^fffff@r\@rY@rT@rX     @r[33333@r\@r[33333@r^fffff@r\@r\@r\@r[33333@rY@rT@rQ@rNfffff@rT@rP     @r@     @r333333@r(     @r     @rfffff@q     @qX     @pfffff@m333333@hə@eٙ@d@c@f#33333@də@cp     @c@c@bfffff@b\@b@b#33333@b`     @afffff@a@a\@a@     @a,@a#33333@a&fffff@a@afffff@a      @`fffff@`@`@`     @`     @`fffff@`@`     @`@`@`@`|@`Ffffff@`9@`6fffff@`6fffff@`6fffff@`#33333@`@`      @_@_fffff@_@_y@_y@_y@_ffffff@_Y@_S33333@_L@_Ffffff@_Ffffff@_`     @_@`0     @`y@`y@`C33333@_     @_@_33333@_     @_@_33333@_     @_@_     @_@_fffff@_     @_y@_     @_     @_l@_L@_@     @_S33333@_Ffffff@_,@_@^@^@^@^@^33333@^33333@_fffff@_      @^33333@^33333@^33333@_      @_fffff@^33333@^33333@^fffff@^33333@^fffff@^@^@^33333@^     @^     @^fffff@^     @^fffff@^33333@^fffff@^fffff@^fffff@^y@^     @^y@^ffffff@^L@^333333@^@]@]s33333@]9@]      @]&fffff@],@]9@]S33333@]Y@]l@]@]@]     @]@]y@]Y@]9@]      @\@\33333@\@\     @\fffff@\     @\33333@\33333@\     @],@]@^fffff@^,@^Ffffff@^     @^     @^s33333@^,@]@]@]s33333@]Ffffff@]fffff@\33333@\     @\33333@\@\ٙ@\ٙ@\@\fffff@\S33333@\333333@\@\fffff@\fffff@\333333@\Ffffff@\Y@\L@\S33333@\`     @\     @\@\@\     @\ٙ@\@\@\@\@\33333@\33333@\@[ٙ@[33333@[@[@[y@[ffffff@[ffffff@[@Zfffff@Z@ZY@Z      @Z      @Y     @Yfffff@Y@Y@Y33333@Y     @Yl@Yffffff@Yl@YY@Y333333@Y      @Y      @X@X@X33333@X     @Xl@XL@X333333@X      @X33333@W@W@Wfffff@W`     @WFfffff@W9@W333333@W@     @V     @Vfffff@V@V@V     @V     @V33333@V@V     @V     @Vl@Vffffff@VY@VFfffff@V,@Vfffff@U     @U33333@U     @UFfffff@U      @U@U@T@Tٙ@T33333@T@T33333@T     @T33333@Tfffff@Tffffff@T`     @TS33333@TS33333@TFfffff@T&fffff@T33333@S     @S     @SL@S,@S@Sfffff@Sfffff@R@R33333@R33333@Rfffff@R@R@Rٙ@Rٙ@Rfffff@R     @R     @R@R33333@Rfffff@Rfffff@R33333@Rfffff@Rffffff@Rffffff@RL@R333333@R      @Q@Q     @Q@Qfffff@Qfffff@Ql@QFfffff@Q9@Q,@Q33333@Pٙ@P@P33333@P     @Ps33333@Pffffff@PY@P`     @Pfffff@Os33333@O&fffff@O@O@Nٙ@Nfffff@Ns33333@N&fffff@M33333@M@M33333@M@M     @M@Mfffff@M@M@Ms33333@Mffffff@ML@Mffffff@Mffffff@M333333@M&fffff@M@     @M&fffff@M      @M&fffff@M&fffff@M&fffff@L@LY@L@     @L@L      @Kٙ@K@Kٙ@K33333@K     @KL@J33333@Jٙ@J33333@Jfffff@J@J@J@J@JY@Jffffff@J     @Jffffff@J@     @J&fffff@J      @I@IY@IL@IL@I@I@H33333@H@H@H     @Hfffff@H     @HL@HL@H      @G@G@Gffffff@Gs33333@G     @G     @G&fffff@G@F33333@F     @F33333@Ffffff@F     @F     @Fs33333@Fffffff@Fffffff@Fffffff@Fffffff@F333333@F@E33333@E@Efffff@Es33333@E333333@E@E@Dٙ@D33333@D@D@Dffffff@D&fffff@C33333@C     @C@C     @Cs33333@Cs33333@C@B33333@B@B@B33333@B     @Bfffff@B33333@B@B@BY@BL@Aٙ@A     @Afffff@AY@Affffff@A@     @@33333@A      @A      @@33333@@33333@@     @@@@@@33333@@ffffff@@333333@@333333@@&fffff@@@@      @?@?fffff@?fffff@?fffff@?@?     @?     @>fffff@>@>L@>L@>L@>ffffff@>333333@>@>333333@>L@>      @=@=@=33333@=33333@=ffffff@=L@=L@=@<33333@<fffff@<     @;fffff@;@<      @;33333@;     @;L@;L@;333333@;333333@;333333@;     @;L@;ffffff@;L@;333333@;@;      @;      @;333333@;ffffff@;33333@;33333@;33333@;33333@;@;     @;333333@;333333@;@:33333@:L@9@9@9ffffff@9L@9@9333333@9      @9333333@8fffff@8fffff@9@9@9333333@9@8fffff@9      @8fffff@8@8L@8@8L@8@8      @8333333@8@8333333@8L@8333333@8@733333@7ffffff@7@7     @7ffffff@7L@7333333@7ffffff@7L@7333333@7@7ffffff@7     @7ffffff@7ffffff@7L@7L@7L@7333333@7333333@7      @6fffff@7@7      @633333@6@6@6     @6     @6ffffff@6@6ffffff@6333333@6L@6L@6L@6333333@6333333@6L@6ffffff@6333333@6      @6333333@6@6      @5fffff@5fffff@5ffffff@5@533333@533333@5@5@5fffff@6      @6@5@533333@6@5fffff@5@5     @6@5@5fffff@5@5@533333@533333@533333@5@5     @5@5@5     @5ffffff@5     @5ffffff@5      @5@5333333@5333333@4fffff@4@4fffff@5      @4@4@4@4@4@4     @4@4333333@4333333@4     @4@4@4     @4333333@4L@4      @4      @4333333@3fffff@3@4      @4333333@4      @4      @333333@3fffff@333333@3@3@3@3@3@3@3ffffff@3ffffff@3@3ffffff@3L@3     @3     @3L@3     @3     @3L@3333333@3L@3L@3L@3333333@3ffffff@3ffffff@3     @3L@3      @2fffff@3333333@3333333@3L@3      @2     @3      @2@2@2@2ffffff@233333@233333@2ffffff@2     @2ffffff@2     @2ffffff@2     @2ffffff@2333333@2ffffff@2L@2      @2      @2L@2@2L@2L@2ffffff@2     @2333333@2333333@2L@2333333@2@2@2L@2333333@2@2333333@2@2@2333333@2333333@2333333@2333333@2L@2333333@1fffff@133333@1fffff@1fffff@1@1fffff@133333@1@1fffff@133333@1fffff@133333@1ffffff@1     @133333@133333@1@1ffffff@1ffffff@1     @1ffffff@1ffffff@1ffffff@1@1fffff@1fffff@1@1L@1     @1@1fffff@1@1     @1@1ffffff@1     @1@1     @1ffffff@1L@1@1@1333333@1@1@1@0fffff@033333@0fffff@0fffff@0@0fffff@1      @033333@0@033333@0@0@033333@0@0@0     @0@0fffff@0@0@0@0@033333@0     @0@0@0ffffff@033333@033333@0@0@0     @0     @0     @0fffff@0@0     @0ffffff@0@033333@0     @0@0      @0333333@0     @0     @0     @0     @0L@0333333@0ffffff@0@0@0L@0ffffff@0ffffff@033333@0@0     @0ffffff@0L@0     @0ffffff@0ffffff@0@0      @0L@0ffffff@/@0L@0     @0L@0L@0L@0L@0      @0333333@0L@0@0333333@0@0      @/ffffff@/@0L@/@/@0      @0      @/@/@/      @0      @0@/ffffff@/@/@/@/@/@/@/@/ffffff@/@/@/@0      @/@/@/@/333333@/ffffff@/ffffff@/333333@/ffffff@/@/@/@/333333@/ffffff@/@0@0      @/@/333333@/333333@/ffffff@/@/@/333333@/@/ffffff@/333333@/ffffff@/@/ffffff@/      @/ffffff@/@/@/333333@.@.@/333333@/333333@/      @/333333@/ffffff@/@/333333@/ffffff@/ffffff@/ffffff@/@/ffffff@/ffffff@/333333@/333333@/@/      @/@/333333@0      @/@/ffffff@.@.@/      @/333333@/333333@/333333@/333333@/333333@.@/333333@/      @.@.@.@.ffffff@.ffffff@.@.333333@.@.@.ffffff@.@.333333@-@.ffffff@.@.@.      @.333333@.@.      @-@.      @.@.      @-@-ffffff@-333333@-333333@-@-ffffff@-ffffff@-@-@-ffffff@-@-333333@-      @,@,@-      @-333333@-333333@,@,@,@,@,@,@,@+@,@,333333@,333333@,ffffff@,333333@,ffffff@,333333@,333333@,333333@,      @,      @,333333@+@+@,ffffff@+@+@+@+@+@+@,      @,@,333333@,      @,333333@+@,      @+@+ffffff@+333333@+      @+ffffff@+@+333333@*@+333333@+333333@*ffffff@+      @+      @+333333@+333333@+333333@+333333@*@+      @+      @*@*@*@*@*      @*333333@+      @*ffffff@*ffffff@+      @*@*@+      @+333333@+333333@*@*@+      @+      @+333333@+ffffff@+ffffff@*@+333333@+333333@+333333@+      @+333333@+ffffff@+ffffff@+333333@+@+333333@+@,ffffff@,ffffff@,      @+@+@+@,      @+@+@,333333@,      @+@+@,ffffff@,      @,333333@,333333@+ffffff@+333333@,ffffff@,333333@-      @-      @,@,@,@,ffffff@,@-@.      @-ffffff@-333333@-333333@-@-@-ffffff@-@-333333@-@.      @-@-ffffff@-333333@-@-333333@-@.333333@/      @.      @-@/      @/333333@.ffffff@-@.      @.@.@.@.@/ffffff@.@/      @.333333@.333333@.333333@.ffffff@.@/333333@/      @/ffffff@/ffffff@/      @/333333@/@0      @/@/@/@0      @0333333@0L@/@/ffffff@0333333@0333333@0333333@/@0L@0ffffff@0@0ffffff@0@0L@0@0ffffff@0@0fffff@0@0@0fffff@0@0@0@0fffff@0@0@0@0@0@0fffff@0ffffff@1@1     @1@1@1      @1333333@1333333@1ffffff@133333@133333@1L@133333@133333@1@1@1@1@133333@133333@133333@133333@133333@133333@133333@133333@2      @1@1fffff@1fffff@2@2333333@2@2      @2ffffff@2L@2L@2      @2333333@2fffff@233333@2     @2fffff@3      @2fffff@2@3333333@2fffff@3      @2fffff@3      @3@3ffffff@3333333@3333333@3333333@3L@3@3ffffff@3@3ffffff@3@333333@3@333333@3@3@333333@3fffff@3@4      @4@333333@4      @4L@4@4333333@4L@4ffffff@4      @3fffff@4     @4L@4@4ffffff@4@4ffffff@4     @433333@433333@433333@4ffffff@4333333@4ffffff@4@4@433333@4@4fffff@5@4fffff@5ffffff@533333@5     @5@6      @5     @5@5@533333@5fffff@5fffff@6      @6333333@6333333@6L@6333333@6333333@6@6L@6     @6     @6@6ffffff@6L@6     @6fffff@6     @6@7      @6     @7      @6fffff@7333333@6fffff@633333@6fffff@7@7333333@7      @7333333@7ffffff@7333333@7333333@7      @7L@7@7@7@7L@7fffff@7333333@7     @7fffff@8      @7@8@7fffff@8333333@8ffffff@8      @8      @8333333@8@8      @8333333@8L@8ffffff@8333333@8@8333333@8     @8@8     @8fffff@8fffff@8fffff@9333333@9@8fffff@9      @9ffffff@933333@9@9@9@:      @:333333@:333333@:ffffff@:L@:333333@:L@:L@:ffffff@:33333@:     @:33333@:@:@;      @;@;      @:fffff@:@:fffff@;      @;333333@;@;@;333333@;@;L@;     @;@;ffffff@;L@;333333@;L@;ffffff@;     @;     @;     @;@;     @<      @<      @;@;33333@;fffff@<333333@<     @<ffffff@<333333@<33333@<     @<     @<     @<@<@<L@<@<fffff@=@<fffff@<@<@<@=      @<@<@=      @=@=333333@=     @=33333@=@=ffffff@>      @>333333@>L@=@=fffff@>      @>@>      @>@>@>333333@>ffffff@>@>     @>333333@>L@>333333@>ffffff@>@>L@>     @>     @>@>@>@?@?      @>fffff@@      @?@?33333@?fffff@@@@      @?33333@?@@@?33333@?@@@@@@@@@@@@333333@@333333@@333333@@@@&fffff@@@     @@@     @@&fffff@@&fffff@@L@@@@ffffff@@ffffff@@     @@@@@@@@fffff@@fffff@@fffff@@33333@@@@fffff@@fffff@A&fffff@A@@fffff@A      @A@     @AY@A333333@A@     @A333333@A333333@Affffff@Affffff@Affffff@A@     @A@A&fffff@AL@A     @A33333@A33333@A@Afffff@A@A     @A     @Afffff@A     @A@A33333@A     @Afffff@A@A     @A@A33333@A@A@A     @A@A@Afffff@B      @Aٙ@A@B@B@B      @BL@Bs33333@Bffffff@B     @B@B@B33333@B@B     @B     @Bfffff@B@Bffffff@Bffffff@BY@BL@BY@Bfffff@B@B@Bfffff@B      @B@Bfffff@B@B33333@C      @C333333@C@     @C333333@C@     @CL@Cffffff@CY@Cs33333@C@     @Cs33333@Cfffff@C     @Cffffff@CY@C33333@C33333@C@Cfffff@C@C@C@C33333@Cfffff@Cfffff@Cfffff@D@D      @C33333@C33333@D@C33333@Cfffff@D@D@D      @D@D333333@D333333@D333333@C33333@D      @D@DL@Dffffff@DY@D@     @DY@Dffffff@D33333@D@Dfffff@D33333@Dٙ@D@Dfffff@E@E      @E@E333333@EL@Effffff@E@E@E@E@E33333@Eٙ@Eٙ@Efffff@E@E     @E@F@F333333@F      @E33333@F&fffff@F@     @F@     @FL@FL@F&fffff@F&fffff@FY@FY@F     @F@     @FL@Fs33333@Fٙ@F@Fٙ@F     @F@F33333@Ffffff@G      @G      @G@F33333@F33333@Fٙ@G      @G@Gffffff@G&fffff@G@     @Gs33333@Gs33333@G333333@GY@G@G     @G33333@Gs33333@G33333@G@G33333@G@G     @G@G@H&fffff@H&fffff@G33333@H@Gfffff@Gٙ@H@H333333@G33333@H      @H&fffff@HY@HL@H@     @HY@H     @H     @H@Hfffff@Hs33333@HL@HY@Hfffff@H33333@Hٙ@Hfffff@H@Hٙ@I      @H     @H33333@I      @I@     @IY@I@I      @I@     @Iffffff@I&fffff@IL                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               ?XbM?
=p
?
=p
?ꟾvȴ9?j~"?QR?Z1'?"`?O;dZ?KƧ?vȴ?O;dZ? ě?Ƨ-?1&y?"`A?ffffff?ꟾvȴ9?띲-V?C$?Z1'?=p
=?x?hr ?S?dZ1?"`A?+I? ě?-V?I^5?~"?n?-?lC?KƧ?`A7?S?KƧ?ȴ9Xb?
=p
?ffffff?Q?lD?KƧ?
=p
?tj~?I^5?Vt??|hs?E?\(?XbM?^5?|?/w?Vu?\(?$/?+J?bM?A7Kƨ?畁$/?Ƨ-?zG?;dZ?333333?1&y?7KƧ?zG{?lC?+?"`?333333?1&x?"`A?E?vȴ9X? ě?333333?nO;?旍O;d?
=p?5?|h?S?+I?"`?x?Vt?Q?n?M?n?-V?`A7?\(?zG?M?p
=q?`A7K?XbM?hr Ĝ?^5?|?hr ?QR?nP?tj?1&y?j~"?"`?\(?Vu?/v?I^5?}?(\)?٩lD?/v?QR?dZ1?\(?öE?l?`A7L?5?|h?(\)?E?ȴ9Xb?+I??|hs?+??|hs?\(?nO;?nO;?-V?lD?&x?&x?
=p?Q?`A7L?bM? ěT?vȴ9X?;dZ?vȴ9X?;dZ? ěT? ěT?;dZ?vȴ9X?vȴ9X?Q?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?Q?;dZ?Q? ěT?;dZ?vȴ9X?5?|h?Q?;dZ?;dZ? ěT?vȴ9X?Q?5?|h?;dZ?5?|h?Q? ěT?Q?5?|h?5?|h?-V?Q?;dZ?;dZ?Q?Q?5?|h?Q?-V?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?Q?5?|h?Q?5?|h?5?|h?-V?Q?Q?Q? ěT?Q?5?|h?5?|h?Q?Q?Q?/v?1&y?/v?/v?5?|h?5?|h?5?|h?5?|h?Q?-V?vȴ9X?;dZ?Q?-V?-V?-V?5?|h?-V?/v?5?|h?5?|h?/v?-V?/v?-V?-V?5?|h?/v?-V?5?|h?5?|h?-V?1&y?-V?Q?-V?5?|h?5?|h?-V?5?|h?Q?-V?-V?5?|h?/v?/v?-V?-V?/v?Q?/v?5?|h?-V?5?|h?5?|h?-V?-V?5?|h?5?|h?-V?-V?-V?-V?/v?-V?Q?5?|h?Q?5?|h?-V?-V?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?Q?Q?Q?5?|h?Q?5?|h?5?|h?Q?Q?5?|h?-V?-V?5?|h?Q?Q?5?|h?5?|h?Q?-V?5?|h?5?|h?Q?Q?-V?5?|h?5?|h?5?|h?5?|h?Q?5?|h?Q?Q?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?Q?Q?Q?5?|h?Q?Q?Q?Q?5?|h?5?|h?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?5?|h?Q?Q?Q?Q?Q?;dZ?;dZ?Q?Q?;dZ?Q?Q?Q?;dZ?5?|h?5?|h?;dZ?Q?;dZ?;dZ?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?5?|h?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?Q?;dZ?Q?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?vȴ9X?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?Q?Q?Q?vȴ9X?vȴ9X?vȴ9X?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?`A7L?\(?&x?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?vȴ9X?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?;dZ?;dZ?Q?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?Q?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?Q?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?5?|h?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?Q?Q?Q?Q?Q?;dZ?5?|h?;dZ?Q?5?|h?Q?;dZ?Q?Q?Q?;dZ?Q?5?|h?Q?Q?;dZ?;dZ?Q?;dZ?Q?Q?Q?;dZ?;dZ?Q?5?|h?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?5?|h?Q?Q?Q?Q?;dZ?Q?;dZ?Q?;dZ?vȴ9X?Q?5?|h?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?Q?Q?;dZ?Q?Q?;dZ?Q?;dZ?Q?Q?Q?vȴ9X?;dZ?Q?Q?Q?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?;dZ?5?|h?5?|h?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?5?|h?;dZ?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?5?|h?-V?5?|h?;dZ?Q?5?|h?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?5?|h?5?|h?;dZ?5?|h?5?|h?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?5?|h?Q?Q?Q?5?|h?Q?Q?Q?5?|h?5?|h?5?|h?5?|h?5?|h?Q?Q?5?|h?Q?Q?Q?Q?5?|h?Q?Q?5?|h?Q?Q?Q?Q?5?|h?Q?Q?;dZ?Q?Q?5?|h?5?|h?Q?Q?5?|h?;dZ?5?|h?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?5?|h?5?|h?5?|h?Q?5?|h?Q?5?|h?5?|h?5?|h?Q?5?|h?Q?5?|h?Q?5?|h?-V?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?-V?-V?Q?Q?-V?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?/v?Q?Q?Q?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?-V?Q?Q?5?|h?Q?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?Q?5?|h?Q?5?|h?5?|h?-V?-V?5?|h?5?|h?-V?5?|h?Q?/v?/v?5?|h?5?|h?-V?-V?5?|h?5?|h?5?|h?/v?/v?5?|h?5?|h?Q?-V?5?|h?/v?5?|h?5?|h?5?|h?-V?5?|h?5?|h?-V?5?|h?5?|h?Q?-V?/v?/v?Q?-V?5?|h?5?|h?/v?5?|h?-V?Q?Q?Q?5?|h?5?|h?5?|h?-V?5?|h?-V?5?|h?5?|h?/v?5?|h?5?|h?-V?/v?5?|h?/v?5?|h?-V?5?|h?5?|h?-V?-V?/v?/v?-V?-V?5?|h?-V?/v?-V?/v?5?|h?-V?-V?Q?-V?5?|h?/v?/v?5?|h?-V?-V?5?|h?/v?5?|h?/v?-V?-V?-V?5?|h?1&y?/v?/v?-V?5?|h?5?|h?/v?-V?/v?5?|h?-V?5?|h?-V?/v?5?|h?/v?5?|h?5?|h?/v?-V?1&y?-V?Q?5?|h?-V?5?|h?/v?/v?-V?-V?/v?-V?-V?-V?/v?-V?5?|h?-V?-V?5?|h?/v?/v?/v?5?|h?-V?5?|h?5?|h?/v?5?|h?-V?/v?/v?5?|h?5?|h?/v?/v?/v?-V?1&y?/v?/v?-V?/v?-V?/v?-V?/v?5?|h?1&y?/v?/v?/v?/v?1&y?-V?/v?-V?1&y?/v?/v?/v?/v?-V?-V?-V?1&y?1&y?/v?/v?-V?/v?1&y?/v?/v?/v?/v?/v?/v?1&y?-V?/v?5?|h?5?|h?/v?-V?5?|h?/v?5?|h?/v?/v?/v?/v?/v?5?|h?5?|h?-V?/v?5?|h?5?|h?/v?/v?1&y?1&y?/v?/v?/v?/v?/v?/v?/v?/v?(\)?-V?-V?1&y?/v?/v?1&y?/v?/v?1&y?1&y?1&y?1&y?/v?-V?/v?1&y?-V?-V?1&y?-V?-V?-V?/v?1&y?1&y?/v?/v?/v?1&y?/v?/v?/v?/v?/v?/v?/v?(\)?1&y?/v?/v?/v?/v?1&y?1&y?/v?/v?1&y?/v?/v?1&y?1&y?-V?/v?-V?-V?1&y?1&y?1&y?/v?-V?-V?-V?-V?-V?1&y?1&y?1&y?1&y?1&y?/v?1&y?1&y?1&y?/v?-V?1&y?1&y?/v?/v?/v?/v?/v?/v?1&y?(\)?(\)?1&y?1&y?1&y?1&y?(\)?1&y?1&y?1&y?1&y?1&y?/v?-V?1&y?1&y?(\)?1&y?1&y?1&y?/v?(\)?1&y?1&y?1&y?(\)?(\)?1&y?1&y?/v?(\)?(\)?1&y?1&y?/v?1&y?(\)?1&y?1&y?1&y?1&y?(\)?1&y?1&y?(\)?1&y?1&y?(\)?1&y?(\)?1&y?1&y?1&y?1&y?(\)?1&y?/v?1&y?1&y?1&y?1&y?/v?1&y?1&y?1&y?1&y?1&y?1&y?(\)?/v?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?(\)?1&y?1&y?(\)?(\)?1&y?(\)?(\)?1&y?(\)?(\)?1&y?(\)?1&y?1&y?(\)?1&y?1&y?1&y?(\)?(\)?1&y?1&y?/v?1&y?1&y?(\)?(\)?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?(\)?(\)?1&y                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               ?                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	P17                                     1                                       )DBEf:3L