CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20170205   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P16    CAST_NUMBER       2      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:34.933592Z    ORIGINAL_HEADER      6CTD,20250210CCHSIOWB
#Removed 'CTDFLUOR_TSG' as it's filled with -999
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2017-06-29. CTD data from cruise 18DD20170205, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20170205. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2017-001/index.php. 
#
# The information in this file for the cruise 2017-001 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-0036.ctd
#
# Start of originator file comment header
#
#*2017/06/29 15:26:50.02
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2017/02/10 06:17:38.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 198
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : CE9F1F72
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            0.3            202.1
#       2 Temperature:CTD               deg_C_(ITS90)   5.6248         6.8697
#       3 Salinity:CTD                  PSS-78          32.78          33.8432
#       4 Sigma-t:CTD                   kg/m^3          25.7461        26.7106
#       5 Oxygen:Dissolved:CTD:Volume   ml/l            3.4            6.87
#       6 Oxygen:Dissolved:CTD:Mass     µmol/kg         147.7          299
#       7 Fluorescence:CTD:Seapoint     mg/m^3          0.66E-01       1.162
#       8 PAR:CTD                       µE/m^2/sec      0              0.3
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        7  F       ' '     2
#       6  -99   ' '        6  F       ' '     1
#       7  -99   ' '        8  F       ' '     3
#       8  -99   ' '        7  F       ' '     1
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2017-001
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P21
#    EVENT NUMBER        : 36
#    LATITUDE            :  49  38.00000 N  ! (deg min)
#    LONGITUDE           : 139  39.97000 W  ! (deg min)
#    WATER DEPTH         : 3961
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    The descent rate of the CTD was very noisy with some complete reversals
#	of direction.
#    CTDEDIT was used to remove many records corrupted by shed wakes;
#	salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Fluorescence and PAR data are nominal and unedited except that some records were
#	removed in editing temperature and salinity and a large spike in
#	fluorescence was removed from file 0032.
#
#    The Transmissivity channel was removed because of frequent shifts in values during
#	casts and large variations between values during repeat casts.
#	The data are available, by request, from the chief scientist.
#
#    NOTE: While the Fluorescence:CTD data are expressed in concentration units, they
#	do not always compare well to extracted chlorophyll samples, particularly for
#	casts far from shore. It is recommended that users check extracted chlorophyll
#	values where available.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in Sea-Bird
#	Application Note #64-2, June 2012 revision (Sea-Bird_64-2_Jun2012.pdf), except 
#	that a small offset in the fit was allowed.
#
#    The Dissolved Oxygen sensor used in files 0001, 0002 and 0016 malfunctioned so the 
#	Oxygen:Dissolved:CTD channels were removed from those files.
#
#    The Oxygen:Dissolved:CTD sensor has a fairly long response time so data accuracy 
#	is not as high when it is in motion as it is during stops for bottles. This will be
#	especially true when vertical dissolved oxygen gradients are large. To get an estimate
#	of the accuracy of the Oxygen:Dissolved:CTD data during downcasts (after recalibration)
#	a rough comparison was made between downcast Oxygen:Dissolved:CTD data and upcast 
#	titrated samples. Some of the difference will be due to problems with flushing of 
#	Niskin bottles and/or analysis errors, so the following statement likely underestimates 
#	Oxygen:Dissolved:CTD accuracy.
#
#    Downcast (CTD files) Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.25 ml/l from 0 to 125 dbar.
#	±0.2 ml/l from 125 to 400 dbar.
#	±0.1 ml/l from 400 to 600 dbar.
#	±0.05 ml/l from 600 to 1500 dbar.
#	Low by up to 0.08 ml/l below 1500 dbar.
#
#    For details on the processing see document: 2017-001-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5--- --6-- ---7--- --8---
#!Pressu Temperat Salinity Sigma-t: Oxygen Oxyge Fluores PAR:  
#!re:CTD ure:CTD  :CTD     CTD      :Disso n:Dis cence:  CTD   
#!                                  lved:  solve CTD:          
#!                                  CTD:   d:CTD Seapoin       
#!                                  Volume :Mass t             
#!------ -------- -------- -------- ------ ----- ------- ------
#*END OF HEADER
     WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @Q         data_max      @Q         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     f0  2   pressure                	long_name         pressure   positive      down   units         decibar    data_min      @          data_max      @33333   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      f0     pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d        D   temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?+J   data_max      @7KƧ   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       f0    temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d           salinity                	long_name         salinity   units         PSS-78     data_min      @@B䎊q   data_max      @AUv   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      f0    salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d          oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @)         data_max      @r   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        f0 H   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d       ~x   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?+J   data_max      ?"`A   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      f0    CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d       4   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       f0    PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d       }   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min               data_max               C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     f0 |   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d          station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( 8   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( `   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      )e   data_max      )e   C_format      %10d          latitude               	long_name         latitude   units         	degrees_N      data_min      @H>=ć   data_max      @H>=ć   C_format      %9.4f             	longitude                  	long_name         	longitude      units         	degrees_E      data_min      `\(   data_max      `\(   C_format      %9.4f             	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d           	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d        @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @       @333333@333333@@      @      @@"@$      @&      @(      @*      @+@/@1333333@2      @3      @4      @5      @6      @6@8ffffff@9      @:      @;      @<      @=      @>@@&fffff@@     @A      @A     @B      @B     @Bfffff@C     @C33333@D     @E      @E     @F      @Fs33333@G     @H      @H     @I      @I     @J@J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P9@P@P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @Tfffff@T@     @T     @T33333@U@U@     @U     @U     @V      @V@     @Vfffff@V     @W      @W@     @W     @W     @W@X@     @X     @X     @Y      @Y@     @Yfffff@Y@Z      @Z9@Z33333@Z     @[      @[@     @[     @[     @\      @\Ffffff@\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_@`fffff@`#33333@`@     @``     @`33333@`     @`     @a      @a      @a<@a     @a     @a     @aٙ@b	@b@b<@b`     @b     @b     @b     @bfffff@cfffff@c      @c@     @c`     @c     @c     @c     @dfffff@d      @d@     @d`     @d     @d     @d     @d@e&fffff@e@     @e`     @e     @e     @e     @e     @efffff@f,@f@     @f`     @f     @f     @f     @f     @g33333@g@g@     @g`     @g     @g@g@g     @h      @h      @h@     @h`     @h     @i      @i      @i@     @i`     @i     @i     @i     @ifffff@j      @j@     @j`     @j     @j     @j     @j33333@k	@k      @k@     @k`     @k     @k     @k33333@k@l      @l      @lC33333@l`     @l     @l     @l33333@lfffff@m      @m      @m@     @mS33333@mfffff@m     @m     @m     @n      @n      @n@     @n`     @ny@n@n     @o      @o      @o@     @o\@offfff@o     @p      @p     @p      @p0     @p<@pX     @p`     @pp     @py@p33333@p     @p     @p     @p     @p     @pfffff@qfffff@q      @q0     @q@     @qP     @q^fffff@qfffff@q     @q     @q     @q     @q     @q     @q@r     @r      @r0     @r@     @rP     @r`     @rk33333@r@r     @r     @r     @rfffff@rfffff@s      @s     @s      @s0     @s@     @sK33333@s33333@s     @s     @s33333@sfffff@s     @s     @t      @t     @tfffff@tP     @t`     @tp     @t~fffff@tfffff@tfffff@t     @t     @t     @t     @t񙙙@t33333@ufffff@u      @u0     @u@     @uP     @uY@up     @u     @u     @u     @u     @u     @ufffff@u񙙙@v      @v     @v      @v1@v@     @vP     @v`     @vp     @v     @vfffff@v     @v     @v     @v     @v     @w      @wfffff@w      @w0     @w@     @wP     @w`     @wnfffff@w@w     @wfffff@w     @w     @w     @w     @w     @x      @x0     @x@     @xP     @x`     @xnfffff@xfffff@x     @x     @x     @x     @x     @x     @xfffff@y&fffff@y0     @y@     @yP     @y`     @yp     @y@yfffff@y     @y     @y     @y     @y     @yfffff@z      @z@z(     @z0     @z@     @zP     @z`     @zp     @z     @z     @z@zfffff@z     @z     @z     @{      @{@{(     @{0     @{@     @{P     @{`     @{p     @{     @{@{33333@{     @{     @{     @{     @|      @|     @|      @|,@|@     @|P     @|`     @|p     @|     @|33333@|@|     @|     @|     @|     @|     @}      @}fffff@}0     @}@     @}P     @}`     @}p     @}     @}@}fffff@}     @}     @}     @}     @}     @~      @~      @~4@~@     @~P     @~`     @~nfffff@~     @~     @~     @~     @~     @~陙@fffff@$@0     @@     @P     @`     @p     @{33333@fffff@     @     @     @33333@@񙙙@      @     @     @     @      @$@333333@8     @<     @I@P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@     @      @     @     @     @      @&fffff@:fffff@@     @H     @X     @`     @h     @p     @x     @     @fffff@     @     @     @     @     @     @     @@33333@     @     @     @33333@     @33333@@ @(     @0     @8@@     @H     @P     @W33333@d     @ffffff@q@x     @     @     @     @     @     @     @@33333@33333@     @     @     @     @fffff@      @     @     @fffff@(     @0     @8     @@     @H     @Nfffff@bfffff@h     @p     @x     @     @     @@     @     @     @33333@fffff@     @     @     @     @     @      @     @
@!@(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @vfffff@fffff@     @@     @     @     @     @     @     @     @@@     @     @     @      @     @     @!@(     @0     @8     @@     @H     @M@`@h     @p     @x     @     @     @     @33333@     @     @     @     @     @љ@     @     @     @     @     @@     @     @      @(     @0     @8     @@     @E@[33333@`     @h     @p     @x     @     @@33333@     @     @     @     @     @     @     @     @     @홙@ @     @     @     @      @%@0@8     @@     @H     @P     @X     @\@k33333@p     @x     @     @     @@     @     @     @     @     @     @͙@ᙙ@     @     @     @@	@     @@      @(     @0     @8     @@     @H     @Zfffff@`     @h     @p     @x     @33333@     @     @     @     @     @     @@     @     @     @@@     @     @     @      @(     @2fffff@4@H@P     @X     @`     @h     @p     @x     @33333@@     @     @     @     @@@     @     @     @     @     @ @     @     @     @33333@+33333@-@:fffff@@     @H     @P     @X     @`     @h     @nfffff@@     @     @     @     @33333@fffff@     @     @     @     @     @     @33333@     @     @     @      @'33333@8@@     @H     @P     @X     @`     @ffffff@x     @@     @     @     @33333@@33333@     @     @     @     @ՙ@33333@     @     @     @      @     @     @"fffff@(     @0     @8     @@     @H     @L@a@h     @p     @x     @     @     @     @     @     @fffff@33333@     @     @     @     @     @     @     @     @fffff@@     @      @&fffff@1@8     @@     @H     @Nfffff@X@`     @h     @p     @u@@     @     @fffff@33333@     @     @     @     @     @     @     @33333@     @     @     @      @     @     @@0@8     @@     @H     @P     @X     @]@k33333@p     @x     @     @     @     @     @     @     @fffff@     @     @     @@ٙ@     @     @     @     @      @33333@@     @     @(@0     @8     @@     @H     @P     @X     @\@k33333@p     @x     @     @     @     @     @     @     @@     @     @     @ݙ@33333@     @ fffff@     @     @     @     @     @     @     @      @#33333@(     @,     @0     @4     @733333@@fffff@D     @H     @L     @P     @R@\     @`     @d     @h     @k33333@u@x     @|     @     @     @     @     @     @     @     @     @     @fffff@33333@     @     @     @fffff@@     @33333@33333@     @     @     @     @     @fffff@癙@fffff@     @     @     @     @33333@@     @     @@fffff@33333@      @$     @(     @,     @0     @4     @@     @D     @H     @Lfffff@N@U@X     @[@`     @d     @h     @l     @nfffff@t     @x     @zfffff@     @     @     @     @     @     @     @     @     @     @33333@@     @     @     @     @fffff@     @     @33333@33333@     @     @     @@fffff@33333@@      @     @     @     @     @     @@     @      @"fffff@,     @0     @4     @733333@=33333@?33333@E33333@H     @L     @P     @T     @X     @\     @`     @c@pfffff@t     @x     @|     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @33333@     @     @33333@     @     @     @     @     @     @@     @@@     @     @     @     @     @     @"     @$     @+@0     @4     @8     @<     @@     @B@Lfffff@P     @Tfffff@X     @\fffff@_@hfffff@l     @p     @t     @x     @|     @     @33333@33333@     @fffff@     @     @     @     @     @     @     @@     @     @     @     @     @     @33333@     @     @     @     @     @     @뙙@@fffff@     @     @@     @     @     @     @     @     @@%33333@(     @,     @0     @4     @7@A@D     @H     @L     @U@X     @\     @`     @d     @h@l     @p     @t     @x     @|     @33333@@     @     @     @     @     @fffff@     @     @     @     @33333@fffff@     @     @     @     @     @     @     @癙@񙙙@     @     @     @      @     @     @@     @     @@(fffff@,     @0     @4     @8     @;33333@D@F@M33333@P     @T     @X     @\     @`     @d     @h     @k33333@tfffff@v@}33333@     @     @     @     @     @     @33333@     @     @     @     @     @fffff@     @fffff@     @     @fffff@fffff@@     @י@     @     @     @33333@     @     @      @     @	@     @     @33333@     @     @      @$     @(     @,     @4@8     @<     @@     @C33333@P@T     @X     @\     @`     @d     @h     @k@x     @|     @     @fffff@33333@     @     @     @     @fffff@@     @     @     @fffff@     @     @33333@@     @˙@     @     @     @ۙ@     @     @     @     @     @     @33333@ fffff@     @     @     @@     @     @      @$     @,@0     @4     @8     @<     @H     @L     @P     @T     @X     @\     @_33333@h     @l     @p     @t     @w@@fffff@     @     @33333@     @     @     @     @fffff@     @     @     @     @     @     @     @33333@fffff@     @     @     @     @     @fffff@     @@     @@@     @     @     @     @@(fffff@,     @.@8fffff@<     @@     @D     @H     @L     @N     @Xfffff@\     @`     @d     @h     @k@v     @x     @|     @     @     @     @     @     @     @     @     @     @@@     @     @fffff@     @     @@33333@     @     @     @     @     @     @33333@     @     @     @ fffff@@     @     @     @     @@     @33333@$fffff@(     @,     @0     @4     @8     @:     @@     @D     @H     @L     @P     @T     @V     @`     @d     @h     @l     @p     @t     @x     @     @     @     @     @     @     @33333@@     @@     @     @     @     @33333@@     @     @     @     @33333@@     @     @     @33333@@      @     @     @     @@@     @     @      @$     @(fffff@133333@4     @8     @<     @@     @D     @H     @T     @X     @\     @`     @d     @h     @tfffff@x     @|     @     @     @@fffff@     @     @     @@fffff@     @     @     @     @@33333@     @     @     @     @י@     @     @     @     @     @     @     @     @     @@     @     @     @     @     @33333@)33333@,     @0     @4     @8     @:@@     @D     @H     @L     @P     @T     @X     @\     @e@h     @l     @o33333@y33333@|     @     @@@     @fffff@     @     @     @     @fffff@     @     @     @     @fffff@@     @     @     @@@     @     @     @     @     @     @     @ @     @     @     @fffff@@     @      @$     @(@,     @0     @4     @8     @:fffff@Dfffff@H     @L     @P     @T     @X     @\     @`     @l     @p     @t     @xfffff@{@     @     @     @33333@@     @     @     @     @     @     @     @     @     @     @@     @     @     @     @@fffff@     @@     @      @     @     @     @     @     @     @     @      @$     @(     @,     @.fffff@<fffff@@     @D     @H     @Lfffff@N@T     @\fffff@`     @d     @h     @k@z     @|     @fffff@     @     @     @@     @     @     @     @     @     @     @fffff@     @     @33333@˙@fffff@     @     @     @     @癙@@     @@33333@     @     @     @     @     @@)@,     @0     @333333@=@@     @D     @G@Q33333@T     @X     @\     @`     @j     @l     @p     @s@x@|     @     @     @     @     @fffff@33333@     @     @     @     @     @@@     @fffff@     @     @     @     @fffff@fffff@33333@fffff@癙@     @     @     @     @     @      @     @     @     @     @fffff@@      @$     @&fffff@,@0     @4     @8     @<     @@     @D     @H     @L     @O@\     @`     @d     @h     @l     @p     @t     @v@|     @     @     @@     @     @     @     @     @     @     @@fffff@     @     @     @     @     @     @33333@@     @33333@񙙙@     @     @fffff@      @33333@@     @     @	@@     @     @     @     @     @     @33333@@     @      @"     @$     @&     @(     @*     @+@0     @2     @4     @6     @8     @:     @<     @=     @@fffff@B     @D     @F     @H     @I33333@L33333@N     @P     @R     @T     @U     @X@Z33333@\     @]@`     @b     @d     @f     @h     @i@m     @m@p     @r     @t     @v     @x     @z     @~@     @     @33333@     @     @33333@     @     @     @33333@     @     @     @     @     @33333@@     @     @     @@@     @     @     @     @     @     @     @     @33333@fffff@33333@     @     @     @     @33333@֙@     @     @     @33333@♙@     @33333@fffff@     @     @     @     @     @@fffff@     @     @33333@33333@ @     @     @@
33333@     @     @     @     @     @     @     @33333@     @     @      @"33333@$     @&     @(     @*     @,     @.33333@0     @2     @4     @633333@8     @9@<     @>     @@     @B     @D     @F     @H     @J     @L     @N33333@O33333@T     @V     @X     @Z     @\     @]@bfffff@d     @f     @h     @i@n     @p     @q33333@tfffff@v     @x     @z     @|     @}@@     @     @     @     @     @@@     @     @     @     @33333@     @     @@@     @@     @     @     @     @@     @     @     @33333@Ù@33333@     @     @     @     @fffff@fffff@     @     @     @@33333@     @     @@     @     @     @     @     @     @      @     @     @33333@	     @
     @     @     @     @33333@@     @     @     @@$fffff@&33333@(     @.fffff@0     @2     @4     @:fffff@<     @>     @@     @B     @D     @F     @H     @J     @L     @N33333@P     @R     @T     @V     @X     @Z     @\     @^     @_33333@d@f     @h     @j     @k@r     @t     @v     @w@~fffff@     @     @     @     @@fffff@     @     @     @@@     @     @     @     @     @     @@@     @     @     @     @     @fffff@     @33333@ř@@     @     @@     @     @     @     @     @     @     @33333@33333@     @     @     @뙙@33333@     @     @     @33333@     @     @      @     @     @     @	     @
     @@     @     @     @     @     @33333@@     @     @      @"     @$     @&     @(     @)@.@0     @2     @4     @6     @733333@<fffff@>     @@     @B     @D     @E33333@L     @N     @P     @R     @S@V@X     @Y@^fffff@`     @b     @d     @f     @h     @i@r     @t     @v33333@w@~@     @     @fffff@@     @     @     @     @     @     @     @     @     @     @@fffff@     @     @     @33333@     @     @fffff@fffff@     @     @@     @     @     @͙@33333@     @@     @     @     @33333@@     @33333@     @     @@     @     @     @     @     @@     @     @     @@@fffff@     @
     @33333@
     @fffff@     @     @     @33333@@     @      @"     @$     @&     @(     @)@0@2     @4     @533333@:fffff@<     @>     @@     @A33333@F@H     @J     @L     @N     @P     @Q33333@V@X     @Yfffff@^33333@`     @b     @d     @f     @h     @i33333@n33333@p     @r     @s@z33333@|     @~     @     @     @33333@@     @33333@@33333@     @     @33333@fffff@@@     @     @     @@33333@     @     @     @     @fffff@33333@     @33333@     @     @     @     @33333@ޙ@     @     @     @     @     @     @33333@fffff@     @     @     @ fffff@     @     @     @@     @     @     @@@     @     @     @      @"     @(fffff@*     @,     @.     @0     @2     @8fffff@:     @<     @=@B@D     @F     @H     @J     @L     @N33333@O     @T@V     @X     @Z     @\     @]fffff@`@b     @c33333@f33333@h     @j     @k@rfffff@t     @v     @x     @y@fffff@@@     @     @     @     @     @     @33333@@     @     @     @     @     @@fffff@     @@fffff@     @     @     @33333@@@     @     @     @     @33333@fffff@     @     @     @     @     @     @     @33333@     @33333@     @晙@     @     @fffff@fffff@@     @     @     @     @33333@ @33333@@     @     @
     @     @
@     @     @     @     @@@      @"     @$     @%@,     @.     @0     @1@6@8     @:     @<     @>     @@     @A     @H     @J     @L     @N     @Offfff@V     @X     @Z     @[33333@^@`     @b     @c@h33333@j     @l     @n     @p     @r     @s33333@xfffff@z     @|     @~     @     @     @fffff@fffff@     @     @33333@fffff@     @     @fffff@     @     @     @     @     @     @     @@@     @     @     @33333@     @fffff@     @fffff@ę@     @     @33333@@     @     @     @     @     @     @     @     @ݙ@33333@33333@33333@왙@     @     @33333@fffff@@     @     @     @     @      @@     @     @     @
     @33333@
     @@     @     @     @     @     @@ fffff@"     @$33333@%@+     @,     @.     @0     @2     @4     @8@:     @<     @>     @@     @B     @D     @Efffff@J@L     @N     @P     @R     @Sfffff@X@Z     @\     @^     @`     @b     @cfffff@f     @h     @j     @l     @n     @p     @r     @t     @v     @x     @z     @|     @~     @@33333@     @     @     @@     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @@33333@     @     @     @     @     @     @@Ι@     @     @     @     @fffff@@     @     @@     @     @     @     @     @     @33333@@     @     @     @     @     @     @@     @
     @     @33333@@     @     @     @     @     @@"fffff@$     @&     @'@.fffff@0     @1fffff@6@8     @:     @<     @>     @@     @B     @D     @J33333@L     @N     @P33333@R33333@S@V     @X     @Z     @[@`@b     @d33333@e@h     @j     @l     @n     @p     @r     @s@z33333@|33333@}fffff@     @     @     @     @33333@@     @     @33333@     @@     @     @     @     @@     @     @     @     @@33333@     @     @     @     @     @     @     @     @     @     @     @     @@33333@     @     @fffff@33333@     @     @     @     @     @     @     @     @     @33333@@     @     @     @      @     @33333@33333@fffff@
     @     @     @     @     @     @     @     @     @@$     @&     @(33333@*     @,     @-@0     @2     @4     @6     @8     @:     @<     @>     @@     @F33333@H     @J     @L     @N     @P     @Q@Zfffff@\     @^     @d@f     @h     @i@n@p     @r     @t     @v33333@w33333@z@|     @~     @     @     @     @     @     @fffff@     @33333@@@     @     @     @     @     @     @     @     @33333@33333@@     @     @     @33333@     @@     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @33333@     @@     @     @     @     @     @     @     @@     @     @     @ 33333@@     @     @     @
     @     @
@     @     @     @     @     @     @33333@33333@@"     @$     @&     @(     @)@,     @.     @0     @2     @4     @6     @833333@:     @<     @>     @@33333@B33333@D     @F     @H     @I@L     @N     @P33333@Q33333@Tfffff@V     @X     @Z     @\     @^33333@_@b     @d     @f     @h     @j33333@l     @n     @p     @r     @t33333@v33333@x     @z     @|     @~     @     @     @     @@     @     @     @     @     @     @@fffff@     @     @     @     @     @@@33333@@     @     @     @     @     @33333@@     @     @     @     @     @     @fffff@     @     @@     @     @33333@@     @     @     @     @     @33333@@     @     @@@     @     @     @     @     @ 33333@33333@     @     @@
     @     @     @     @     @33333@     @     @     @33333@@      @"     @$     @&     @(33333@)@,     @.     @0     @2     @3@6     @8     @:     @<33333@>33333@?@B     @D     @F     @H33333@J     @L     @N     @P     @R     @T     @V     @X     @Z33333@[@^fffff@`     @b     @d     @f     @h     @i@l     @n     @p     @r     @t33333@v     @x     @z     @|     @}fffff@fffff@     @     @     @     @     @33333@     @     @     @     @     @33333@     @@@     @     @     @     @@     @     @33333@@@     @     @     @     @33333@@     @     @33333@@     @     @     @     @љ@     @     @     @     @33333@33333@     @     @     @33333@     @     @     @     @     @     @󙙙@     @     @     @     @     @ 33333@@     @     @     @
     @     @33333@     @     @     @     @     @33333@@     @ 33333@"     @$     @&33333@(     @)@,     @.     @0     @2     @433333@6     @8     @:     @<     @>     @@     @B     @D33333@E@H     @J     @L     @N     @P     @R33333@S@Vfffff@X     @Z     @\     @^     @`     @b     @d     @f     @h     @j     @l     @n     @p33333@q@t     @v     @x     @z     @|     @~     @     @     @@     @     @     @     @33333@33333@     @     @     @     @     @     @@     @     @     @     @     @     @33333@@     @     @     @     @     @     @     @     @33333@     @     @     @33333@33333@˙@33333@33333                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @@4m@>($x@$e@@1&x@ hۋq@:S@hr@@.H@o h@tj@J#9@4֡b@YJ@l"h	@)@F@)@F@	k~@~($@(@XbM@	k~@)@YJ@YJ@)@)@4֡b@F@)@rG@4m@!R@SMj@9XbN@SMj@|@iB@A [@@t@zG@zxl"@C]@P{@fB@0
@~"@JL@lD@@ᰉ'@0U2a|@d7@Ov`@x@^@^@^@^@x@^@x@x@ᰉ'@Ov`@0U2a|@y@y@x@ᰉ'@ᰉ'@B@@@@ᰉ'@lD@Ov`@Ov`@0U2a|@~"@0U2a|@0U2a|@0U2a|@d7@0
@6z@Q@C]@H@[W>6@PH@C%@2GE85@@IQ@\>@R<6@>@fffff@Xy=@0
@iB@tj@1'@-U=@333333@6_ح@71@5?@7KƧ@5Xy=@ߤ@@+@ۋq
@ěS@R@x4֡b@irGE@.H@>BZ@@y=c@҈@weں@bh	ԕ@L~($x@9rGE8@nP@'0@思IQ@D@t@Z@Z@p:~@@|64@tJ@oiDg8@^쿱[W@!R<6@H@cA \@
(@%1@?@74@ᰊ@>BZc@A [@R<6@"`B@&I@r䎊q@PbM@DM:@9"`@ᰉ@(@1@6C@Z@XbM@Gz@Xe,@@vC-@mU=@l<쿱@bC,@Bu%F
@
qiC@
=p@+I@74@\@ڹ@-w1@@E@D@,zxl@_p@j~@o@=K@tD@rs@j~"@e`A7L@F-@5?|h@&1.@$?@?@@@	k~@-V@l@/w@ק&@T`d@(@ǮzH@lC@qj@@n.@v+jg@de@be+@`[6@`u!@_U=@^iB@[$@N!R<@4#@%ڹ@!R<6@Q@@҉@X@|@)^@@?@C,@n@ĵ?@˒:)@][@Np:~@H@@     @6_ح@/{J#:@"wkQ@PH@nO@
%@ ѷX@e+a@ǮzH@F
L0@%@~m\@w+@5?|h@)Dg8~@$7@"C,@u%F@p:~@D@jf@A@A [@>@sPH@Vu@ʦL/{@Ϫ͟@)^	@9Xb@s@@$/@~vȴ9X@P|@Gݗ+@5%F
L@!|Q@>@q@	^5?}@@\(@v@-@ hۋ@e@ۥS@,<@ݗ+k@ҽ<64@&IR@D@@a@@0
@@:@;5X@@YJ@,zxl@E84@$/@S&@C@yY}@w3@nO;@kP{@k6z@j~"@h$xG@f1.@Ye+a@R䎊@P*0U@N!R<@H9Xb@A7Kƨ@<Z@9#w@5Y|@0'RT@+I^@(r Ĝ@$%1@!-w1@,=@qu!@Q_@_o@)^@_o @_@]cA@
W'@	'RTa@@@@˒:*@zH@@8YK@@ C@/V@D@Dg8~@,<@1@	@ʦL/{@ѷX@v@n.@C\@kP@V@U=@ߤ@@0
)@+J@Z@zG@@W'@K]c@1&x@o i@n@}E@xF@vE@wkP@x)@{lC@{dZ@w4m@sg	l@qiB@n2X@hۋq
@glC@gRT`e@f@e1@be+@^쿱[W@],=@W@Nqi@Jn@F&I@A@An.@An.@BI^5@B&IR@?[W>@>\N<@<hr@9rGE8@2{m@.O;@,<쿱@+C,z@'&@&IQ@%ڹ@%@%1@%zxl"h@%F
L0@%+a@$tSM@#n.3@"`A@ A7K@,=@@9Xb@@PH@~@-
@eں@Fs@SMj@J@s@ hۋ@2X@}Vl@H@@
=q@@t@҉@o @҈@o i@oiDg@Zc@@xl"h
@3@J@$xG@wkQ@Y@fA@p:~@#@y@o i@S&@Q@g8}@I^5@7Kƨ@@wKƧ@ka@@b`A@bM@W@TZ@RsP@QX@Q_p@Ov_ح@N;5X@MjOv@L@H@F
L/@?$tS@=ڹZ@=ڹZ@<hr@<PH@:>B@9(@8YJ@8F]d@7KƧ@74m@6Fs@0
(@($xG@$Z1@!-w1@?@?@_F@Ʌoi@n@bM@
%@_@u%F@)^@YJ@$/@Fs@x@x@e@ ѷY@$@6@6@W>6z@1'@Ϫ͟      @*0@7Kƨ@Q@}Vl@,@n.3@
=p@tj@)^@@vFs@kP{@ZQ_@Y+@T,<@F
L/@@4m@=<64@8)@6E@2W@/Vϫ@+a@@*d7@䎊r@*0@@@N@hr @L_@_o@@@I^5@$/@nP@lC@j~@B@o@+@&@Ϫ͞@/{J#@@&IR@64@ᰊ@q@<쿱@͞&@TɅ@x@@TɆ@`A@ěT@@N@qiC@qiC@4m9@{s@t#@s@tj~@p
=q@iᰉ'@dZ1@Yb}@QN;5@N+@<쿱[@3|@.1@,q@(TɅ@&IQ@%1@&@$/@U=@=K^@tj@zG@o @'/W@C%@Q@
˒:)@
>B@
F@
1@
\(@
\(@
%F
L@
빌~($@
d8@
(\@
y=c@
&@
`A7@
,zxl@
dZ@

(@
0
@
@
wk@
h	ԕ@
u"@
,<@
N;6@
eO@
~m\@
x73@
vȴ9X@
qiB@
n.2@
m(@
jJL@
bC,@
Zc	@
QX@
N+@
Np:~@
M@
I^5?}@
Gy@
+I^@
4J@
{J#9@@-
@73@eں@Y|@MjO@B@(\@D*@Ϫ͟@8YJ@Z@&@s@D@g	l@	@sh@ݗ+k@hr @ԕ*@{J#9@{J#9@tj@r{m@p
=q@o hۋ@jJL@`d8@]+j@XU@Rm@RT`d@N;5X@I@Eo i@D2W@>6z@0'RT@&'@&x@$/@ ěT@qu!@*0@zG@u@Mj@
@
O;dZ@
L/{@&I@Q@ ѷX@PH@{m@!-w@y=c@ԕ*1@E@@&@|@+@j~#@)y@9XbN@<쿱@/V@'@-
@ᰉ@!R<@@xF]@1&x@$/@u!R@hۋq
@cS@^@TɅoi@2a|Q@)lD@',@$tSM@!o@1&@C,zx@6C@S@wkP@wkP@,<@u%@S@_o@S@=K^@6C@*0U2@&I@ ѷ@
-V@
Z1@
ۋq@
H@
_o @
v_ح@
@
8YK@
@
6z@
Z@
4m@
a@N@
쿱[@
|@
u@
)^@
rGE9@
Vu@
q@
k~(@
qu"@
k~(@
n.@
{s@
u\(@
tD@
r{m@
p@
kQ@
ffffff@
a@N@
ZQ_@
U2a|@
F?@
<j~#@
9Y}@
4J@
/O
M@
+U=@
!-w1@
C,zx@
@@
_F@
sh@
nO@
)^@
Z@

=p
@

	 @

qiC@

	 @

=p
@
C%@

=p
@
#@
 hۋq@	!-w@	@4@	e+@	jOv@	@	ěS@	@	@	6z@	vȴ9X@	4֡b@	?@	a|Q@	H@	@	?@	/@	u%@	zG@		 @	 ѷ@	eO@	#@	YJ@	ݗ@	M:@	@	o h@	o hی@	.H@	~\N<@	}H˒@	|hr@	{m]@	w+@	r䎊q@	p@	^҈p;@	Zݘ@	W&@	Vt@	NT@	F-@	F-@	Fs@	Em\@	5?@	1-@	0
(@	+U=@	+jf@	+I^@	&@		@	O
M@	@+jg@@8Y@(@A@e@ܑN;@:@cA \@@n.@|@zxl"@,@%@~($x@hۋq@w+@t#@sPH@nO;@kC]@k~($@irGE@eO
@d%1@be+@]/w@["`B@Y+@P{@D*0@=p
=@5?@4J@2a|Q@.2X@.}Vl@+I^@%F
L0@#n.3@U=@u"@Ov_@eO@nP@+@_ح@s@(@>BZc@1.@A [@Ft@t@҈p:@ΤT@[W>@o@r@>B[@`A@ae@	@wkP@qu!@@_F@L_@O
M@*0U2@҉@n@S&@$tT@-
q@\(@@ԕ*@'/W@\(@eO@IQ@vȴ9X@tj~@gfA@cS@c	@b@4@`҈p@XU@Q_p@M%@IQ@E8YK@B74@:S&@84֡b@64K@-U=@+I^@*0
@)^@(Xy=@&'@#n.3@ ěT@u@Q@qu!@@sh@*0U2@hr @
qiC@K]d@oiDg@@b}V@lC@PH@(@rGE@fA@ڹ@A [@ᰉ'R@ ѷY@ٳ|@
=p@֡af@Ϫ͞@ɺ^5?}@@Y}@A@
(@~($@YJ@C-@E@?|h@m8@m8@9XbN@J@|@J@g	l@&x@H@\)@\)@@!-w1@,<@Fs@ ѷ@|PH@r ě@w+@y(@}ڹZ@b}V@~\N<@z@qA [@p:~ @o4֡a@m(@d7@]/w@Z1'@RT`d@LcA \@A [7@;/V@;dZ@8Q@1[W>6@.1@,<쿱@)lD@)^@%S@"`A@IQ@e+a@@Ov_@ݗ+k@
ڹY@n/@_o@=b@1@1@C\@8Y@\@C]@ۋq
@fffff@Z1@	@d8@sPH@:@)^@84֡@*0@8YK@@ [7@7Kƨ@C@7Kƨ@7Kƨ@s@&IR@74@a@N@o i@C@[W>@K]@^5?|@~($@XbM@XbM@}H@3@Q@3@v@I^@/@tSM@9@o@	k@Ov_خ@wkP      @I^5?@}ڹZ@{~$@x73@u\(@r{m@m\@cA [@Ks@@C@/{J#:@+I^@+I^@*0U2a|@(TɅ@'-@($xG@$tSM@쿱[W@@Q@@4n@$/@xl"h
@+@@e@u!@ݗ+j@]ce@ܑN;@>BZ@D*@>6z@8YJ@fA@E@&@҈p:@ѷX@`A7@|@N;5@p:~@jOv@s@]cA@ȴ9Xb@m\@84֡@g8}@@74@@&IR@TɅo@4m@@6z@vȴ9X@vȴ9X@
(@~($@#w@YJ@)@Q@}Vl@-V@v@V@zxl"@lD@y@IQ@zxl"h@?@Q@tj~@҉@\(@xF]@C%@ݗ+@$/@$/@ݗ@o h@@u%F
@zC\@y	k~@x-
@w1@uY|@t!-w2@sPH@o4֡a@kP{@h@fA@e+a@cZ@bM@\?@Xy=c      @P`A7@N+@N_o @KƧ@JL_@H9Xb@E8YK@C\N@@4m@<n.@9XbM@8YJ@3ߤ@0 ě@/{J#:@'&@&L/{J@#
=p@!ae@1&@S@u%F@kP|@0
)@PH@+j@@$tS@sh@$/@Fs@:)y@K]d@tj@	k~@PH@t@8Y@"h	ԕ@C,z@B@A [@@4@҈p@ ѷY@ܑN;@6@ڹY@+@sPH@t@@_p@p:~@˒:)z@)^	@y@6z@64@/V@)_@Xe@sg@'0@'0@YJ@3@|@|@g	l@U2a|@v@w1@B@͞&@tSM@1&@@@@L/{@@@ ѷ@u%F
@n.@4m9@~"@}!.H@z>B@vȴ9X@tj~@sPH@p@n.2@irGE@de@c	@ceO@_o@ZQ_@Xy=c@TɅoi@PH@K:)z@I@I@GzH@Eo i@Eo i@Eo i@E84֡@Eo i@DS@H@F
L/@Em\@Eo i@DS@C$@B74@GE84@C,zxl@@C@?@;5Xy@;/V@:~@:)y@9D@43@1[W>6@)@!o@!-w1@IQ@Ov_@҉@S&@$tT@)^@rGE9@)^@-
q@o @@	'RTa@n.@xl"h
@C\@\(@䎊q@8Y@fA@+a@M@$@֡af@Z@;5X@jOv@jOv@jOv@:@W'@@@Ƨ-@ěS@NU@n.@Q@4K@C-@ᰊ@Vϫ@H@ߤ@@O;d@$tS@nO@Mj@qu"@#@p:@oiDg@     @}ڹZ@u!.@nO;@h	ԕ+@e@eڹ@\?@^5?|@\(\@Y+@UfA@Q@RT`d@QX@R䎊@R䎊@QR@QR@S&@S&@T,<@S@Q@K)^	@JW'@F-@D*0@DS@Ca@N@?H˒:@=p
=@=p
=@:)y@4J@1o@0{@/r@-U=@+jf@)@"3@_o@e+a@+j@O;d@nO@@'/@
=p
@	ԕ*@_o@{J#9@C\@P{@fffff@%1@e+@d8@Gz@cA @b}@e+@@՛=K@`A7@
M;@]cA@@@TɅo@~@YJ@z@m8@a@@S@S&@`A@R<6@'RT`@Ov_خ@IQ@[@qu!@0
)@Z@ݗ+k@S&@sP@ᰉ@Z@*0U2@҈@ݗ+@nP@~($x@}!.H@{s@xF]d@sg@kP{@irGE@dqj@ae@a@N@_Ft@\]ce@[W>6z@ZY@Zݘ@Y|@Yb}@W@U=K@S&@QX@QX@QX@O;dZ@I^5?}@HK]c@GzH@F?@Em\@As@?|hs@<64@6C-@2ᰊ@0{@1[W>6@,zxl"@,zxl"@,>B[@,zxl"@+a@@%S@"`A@!o@ [6@%@C,zx@S@O
M@@N@hr @bM@bM@'/W@~($x@#@K]d@ݗ+@@Q@?@@u%F
@ lC@ eں@ !.I@ \(@ SMj@ {m@ g@ D@ \@ Dg8~@ @ fffff@ 䎊qj@ %1@ Z@ S@ A7K@ ݗ+j@ "`B@ bM@ حU@ D*@ sPH@ ֡af@ @ Ϫ͟@ l!-@ Ϫ͞@ 
=p@ @ @ ̘_@ s@ Ƨ@ ˒:)z@ ]cA@ ]cA@ )^	@ W'@ ?@ a@N@ 7Kƨ@ Y}@ m\@ v@ O
M@ zxl"@ zxl"@ zxl"@ <쿱@ y@ -@ S@ 
=p@ O;d@ Ov_@ L_@ @ tj~@ Xe,@ Mj@ K]d@ S&@ {J#9@ Q@      @ ~m\@ zC\@ xF@ qiB@ o4֡a@ n.2@ m\@ kC,z@ iᰉ'@ iᰉ'@ ix@ cS@ a|Q@ _حV@ ]ce@ Y+@ L_@ HK]c@ D2W@ >BZc @ 8YJ@ 7KƧ@ 64K@ 5?@ 6z@ 7KƧ@ 6C-@ 2W@ 12W@ 1[W>6@ 0
(@ 0 ě@ ,>B[@ +jf@ *d7@ )lD@ )*0U2a@ &x@ &x@ &@ 'RT`e@ #wk@ !ae@ vȴ9@ U=@ !-w1@ ,=@ -V@ !-w1@ !-w1@ !o@ U=@ 6C@ *0@ +J@ Z@ @ *0U2@ N;6@ -
q@ sP@ n@ hr @ )^@ @ Mj@ rGE9@ \(@ ߤ?@ 
M:@ @ I^5?@ 
qu"@ xF]@ 
ڹY@ 	 ѷ@ tj@  ѷ?.H?>B?rGE8?1.?u!?fA??\(?\(?a@N?n?vȴ9X?n.?<64?j~#?A?~($?Q?Xe?'0?g	l?{?O
M?&?TɆ???-
?C%?&I?oiDg?Q?{J#9?M:??4m9?{m]?oiDg8?k~($?jOv`?hۋq
?iB?jfB?kP{?hۋq
?eڹ?cA [?ceO?e+a?ceO?`d8?\(\?Vt?SMj?Q?M?Fs?@NU???@4m?@NU?=p
=?;dZ?>BZc ?<64?:S&?9D?9D?9D?9XbM?:~?=p
=?<64?;5Xy?;dZ?:S&?9XbM?:)y?8YJ?6z?4m8?1&x?-
qv?)^?&IQ?#wk?!-w1?Ov_خ?6C??)^?'/?ڹZ?~$?>B?rGE8?73?!.I?Y|?!-w2?-
?!.H?"`?Y|?D?#?Y|?#?#?E?{m?4֡a?rGE?҈p??8YJ?,<?m?䎊?N;5?E?ѷX?_o ?_o ?2W?/V?~($?4m?rG?3?2W?O
M?lD?TɅ?&?'?S?TɆ?o?vȴ9?%?%?IQ?u"?ߤ@?u%F?Fs?S&?L_?C%????O;dZ?'RTa?7KƧ?p:?'RTa?%2?|Q?v_ح?s?oiDg8?nO;?lC?l"h	ԕ?iDg8~?e+a?_حV?\N;?Xe+?Vl!-?Vl!-?Vl!-?U=K?U=K?TɅoi?S?R<64?Q?S?S&?Q?Q?Q_p?P{?K]cA?J#9?KƧ?I^5?}?H?H˒:*?J#9?I^5?}?JL_?JL_?KƧ?I^5?}?H˒:*?GzH?D*0?D*0?E84֡?Dg8}?@4m?:)y?4J?1&x?-
qv?*0U2a|?$tSM? [6?*0??zG?4J??Vu?	 ѷ?u%F
? hۋq?~$?"`?rGE8?Fs?E?䎊q?MjO?(?C\?c	?C\?,<?Z?e??e?%1?%1?%1?Gz?]ce?
=p?`A7?͞%???8YK?m\?n.?)_?sg?9XbN?9XbN?|?g	l?'RT?U=?q?1&y?-?n.3?wkQ?'RT`?'RT`?vȴ9?%?=K^?=K^?S?ߤ@?vȴ9?ߤ@?kP|?$tS?Fs?-
q?YJ?oiDg?&I?&I?oiDg?ݗ+??L_?&I??b}V?r ě?rGE85?p:~ ?nO;?m\?lC?n.2?kP{?hۋq
?g	k?g	k?iDg8~?ffffff?eڹ?g	k?ffffff?g8}H?fA?ffffff?e+a?e+a?]ce?Q?N;5X?L/{J#?H?GzH?O
M;?L/{J#?JD?I^5?}?H?GE84?Fs?BZc????|hs?As?<쿱[?9D?9XbM?73?73?84֡b?5?|h?1-?-
qv?&IQ?"`A?Xe,?L_?@N?
L/{?o h??Fs?䎊q?D?-V?hr!?S?C,?ᰉ'R?u!?]ce?ڹY?Q_?D*?Ϫ͞?Ϫ͞?8YJ?Ϫ͞?䎊?͞%??@?ěS?&IR?&IR?C?C?C?[W>?ߤ??Z?ߤ??j~#?)_?n.?'0?r?>B[?,?-
?wkP?IQ?u?U=?U=?U=?'RT`?'RT`?vȴ9?
=p?
=p?wkQ?o?-
?u?ߤ@?=K^?kP|?u?$/?҉?N;6?-
q?-
q??	 ?+I?{J#9???@4n?$/?~"?u!R?m8Y?iDg8~?e+a?d7?ae?a|Q?a@N?ae?bM?a|Q?_Ft?^?XbM?Vt?U=K?Vt?U=K?U=K?W&?W>6z?U2a|?TɅoi?Vt?T`d?QR?U2a|?Q?M?L/{J#?K]cA?IQ?H˒:*?C,zxl?C,zxl?B?C,zxl?As?@NU?????<쿱[?9D?:)y?9D?6C-?4m8?4J?3ߤ?2a|Q?/Vϫ?/v?-w1?+a@?(\)?'RT`e?%1?$tSM?	?[?6C?*0??L_????u?bM?
qu"?	 ѷ?u%F?S&?u%F
?F]c?u%F
?n.? hۋq?.H?.H?E?m\?m\?!.H?~$?"`?\(?Fs?Fs?D?C]?>BZc?C,?$?sPH?N;5?+?+??s?n?Ƨ-?2W?TɅo??6?[W>?[W>?vȴ9X?<64?)_?r?U=?͞&?*0U2a?'?-?,?u?S&?wkP?ᰉ??nP?zG{?wkP?v_ح?v_ح?vȴ9X?vȴ9X?u!.?sg?l!-w?iB?hr Ĝ?g8}H?e+a?d7?dZ1?dZ1?ceO?`d8?_Ft?_o?`A7K?`A7K?a@N?`A7K?]cA ?[W>6z?VϪ͟?R<64?RT`d?P{?K]cA?GzH???=K]?<64?;5Xy?;5Xy?=p
=?<쿱[?;5Xy?8}H?64K?8}H?73?8YJ?9XbM?8YJ?84֡b?73?6z?7KƧ?333333?3ߤ?3ߤ?0U2a|?.H?/v?.H?-
qv?-w1?-
qv?.2X?.2X?-
qv?-w1?-V?-
qv?-
qv?,zxl"?,<쿱?+I^?*0
?(\)?&x?#wk?!-w1?"h	ԕ?Q?[?Q?C,zx?C,zx?Q?_o?Xe,?Ov_?nO?'/W?	k~(?u%F
? hۋq?.H?~$?73?+jg?#?Y|?\(?\(?D?!-w2?D?oiDg8?t?hr!?VϪ?Q?lC?fA?
qu?҈p;?ݗ+j?]ce?]ce?]ce?;dZ? ѷY?/w?ۋq?+?D*?E?ѷX?N;5?|?p:~?_o ?As?˒:)z?s??2W?74?\(?&IR?[W>?TɅo?#w?rG?}Vl?[W>6?'RT? ě?>B[?1&y?1&y?lD?Xy=?u?u???wkQ?-
?	k?-
?쿱[W?u%F??*0?҉?$/?O
M?:)y?-
q?Mj?O;dZ??!R<??L_?qiC?YJ?Q?%2?~$t?|Q?y(?u%F
L?iB?eڹ?d7?`d8?`A7K?`A7K?a@N?a|Q?_حV?]cA ?a|Q?`A7K?^5?|?[W>6z?Z1'?W&?Vl!-?NT?O
M;?O
M;?H?Fs?Fs?Dg8}?C,zxl?B?@4m??|hs?@NU?????@4m?D*0?B?>BZc ?=b?;dZ?:S&?7KƧ?2a|Q?-w1?(?&x?$tSM?$tSM?$xF?#wk?$xF?$xF?$tSM?&IQ?'RT`e?'RT`e?'RT`e?&x?'/V?'/V?)^?)^?+I^?+I^?*0U2a|?,<쿱?0U2a|?.2X?-w1?,<쿱?+I^?*0U2a|?(\)?($xG?&x?'RT`e?&IQ?%1?&?$/?%F
L0?!R<6?!-w1?䎊r?	?[?Q?qu!?_o?tj?Ov_??sh?4J????Vu?
qu"?
M:?
L/{?_o?Fs??$/?? hۋq?? ѷ?:S?E?s?eں?Fs?rGE8?+?Y|?E?!-w2??C,z?>BZc?`A7L?S?҈p?
qu?u!?u!?ݗ+j?/w?ݗ+j???"`B?Q_?+?ߤ??D*?Ϫ͞?,<?ԕ*1?a@O?m?䎊?fA?a@O?䎊?҈p:?m?m?m?m?䎊?ѷX?ѷX?As?+?Ϫ͞?*0U?*0U?*0U?ѷX?ԕ*1?҈p:?`A7?`A7?Ϫ͞?N;5?҈p:?Ϫ͞?|?`A7?|?N;5?ԕ*1?ѷX?҈p:?As?W'?ɅoiD???a@N?Ƨ-?o i?o i?2W???a@N?a@N?&IR??C?vȴ9X?j~#?'0?'RT?zG?B?>B[?͞&?lD?d7?*0U2a?*0U2a?TɅ?lD?*0U2a?-?TɅ?lD?lD?d7??TɅ????lD?U=?>B[?͞&?zxl"h?n.3?ae?wkP?=K^???kP|??wkP?u%F?+j?$tS?R<6?R<6?ᰉ?*0?O
M?tj~?$/?$/?ᰉ?Fs?:)y?o ?Mj?qi?$tT?qi?qi?qi??#?ݗ+?&I?'RTa?7KƧ?'RTa?p:?p:?+I?p:?eO?ݗ+?YJ???%2??~$t?~"?}Vl!?{J#9?|??{J#9?{J#9?z?zxl"h
?y(?zxl"h
?|Q?{J#9?zG{?zxl"h
?zxl"h
?{m]?|hr?|Q?|??}H˒?|Q?zG{?xl"h	?u!R?r ě?qu!S?p:~ ?o hۋ?m8Y?m8Y?m\?l!-w?m8Y?nO;?n.2?lC?j~"?jOv`?jOv`?iDg8~?iDg8~?iDg8~?hr Ĝ?g8}H?g8}H?fA?eO
?eڹ?eڹ?eڹ?hr Ĝ?h	ԕ+?ffffff?fA?ffffff?e+a?e+a?e+a?bM?bM?ae?c	?_o?^?^5?|?`A7K?c	?`A7K?_حV?^5?|?^5?|?a@N?`d8?_o?_حV?_o?_o?ae?`A7K?`A7K?_Ft?^5?|?_Ft?\N;?\N;?^5?|?a|Q?a@N?^?`A7K?a|Q?a@N?ae?`d8?_حV?_حV?\N;?Xy=c?XbM?VϪ͟?Y|?W>6z?W>6z?YJE?^5?|?]ce?\>?\>?]cA ?\N;?\(\?^5?|?_o?\N;?\N;?[6?Xy=c?Xy=c?Z1'?Y|?VϪ͟?W>6z?Vl!-?TɅoi?VϪ͟?U=K?U2a|?TɅoi?S?S&?TɅoi?TɅoi?S?S?T`d?S&?TɅoi?PH?O;dZ?PH?PH?N;5X?N;5X?M?M?O
M;?I^5?}?H˒:*?F]cf?H?H?JL_?F
L/?D*0?D*0?E84֡?A7Kƨ???=b?9D?84֡b?6C-?6C-?64K?6C-?:S&?7KƧ?9XbM?73?7KƧ?7KƧ?5?|h?7KƧ?:)y?6C-?64K?8}H?7KƧ?5?|h?4m8?4J?4֡a?8}H?8YJ?6C-?64K?4֡a?4J?6C-?73?84֡b?4֡a?64K?8YJ?6C-?6z?64K?5Xy=?6z?73?73?73?7KƧ?84֡b?;5Xy?;dZ?;dZ?:~?:S&?:S&?;dZ?>6z?>6z?=b?=K]?;dZ?:S&?84֡b?=b?=p
=?=p
=?=K]?:~?9XbM?8}H?5Xy=?5Xy=?8YJ?8}H?7KƧ?6C-?5Xy=?73?7KƧ?7KƧ?7KƧ?6C-?6z?8YJ?;dZ?8}H?6z?5?|h?4m8?4m8?4m8?5?|h?3ߤ?4֡a?4m8?333333?333333?4֡a?8YJ?6C-?5Xy=?4J?1-?1&x?2a|Q?6C-?64K?2W?3ߤ?4m8?3ߤ?3ߤ?333333?3ߤ?2W?2a|Q?2a|Q?2a|Q?4m8?.H?,<쿱?-V?,<쿱?,zxl"?1-?/Vϫ?+a@?+a@?,<쿱?,<쿱?/Vϫ?.H?.2X?-V?-w1?,zxl"?-V?.2X?/v?.H?+jf?*0
?*0U2a|?)y?+jf?*0
?)^?)y?)^?(\)?(?+jf?)y?)^?(?(\)?($xG?)^?)^?(\)?)y?)^?)^?(?'/V?'/V?'RT`e?)y?,<쿱?(\)?(\)?(?'/V?&x?%F
L0?$xF?Ov_خ?e+a?e+a?e+a?PH?C,zx?	?[?C,zx?C,zx?qu!?Q?}H?PH?Xe,??tj?tj?*0?tj???*0?tj??+J?PH?vȴ?e+a?e+a?PH?tj?e+a?Q?u%?vȴ?6C?1&?[?}H?Ov_خ?,=?[?Q?	?,=?,=?,=?!-w1?#9?!R<6?"h	ԕ?!.H?!.H?$tSM?$xF?"`A?"h	ԕ?"`A?#wk?#9?&IQ?&IQ?'RT`e?'/V?'/V?($xG?'RT`e?($xG?'RT`e?&?&?&x?&?%F
L0?&IQ?&IQ?&IQ?'RT`e?&x?'RT`e?+jf?*0
?($xG?'RT`e?&IQ?'/V?&IQ?&x?'RT`e?&x?%F
L0?%1?)y?+I^?(\)?%1?%1?'/V?+I^?(\)?'RT`e?&IQ?$/?$/?%F
L0?$xF?$tSM?$tSM?%1?%1?$/?#9?#9?"h	ԕ?!R<6?"h	ԕ?$tSM?%F
L0?	?	?䎊r?C,zx?Q?C,zx?C,zx?Q?"`A?"h	ԕ? ěT?䎊r?,=?!-w1?$tSM?"`A?䎊r?Q?!-w1? ěT?}H?,=?Ov_خ?Ov_خ? [6?$tSM?#wk?"h	ԕ?!.H?!-w1?!-w1?"`A?&x?($xG?$/?$xF?"`A?$tSM?($xG?($xG?$tSM?$xF?#9?!.H?$/?&x?'/V?&x?&x?%1?'RT`e?+I^?+jf?)y?)^?)y?*0
?,zxl"?-
qv?-w1?,<쿱?,zxl"?,<쿱?+jf?+I^?-
qv?/{J#:?/v?,<쿱?*0
?)^?)^?+a@?,<쿱?)y?(\)?)^?)^?)^?+I^?-
qv?-V?-V?,<쿱?,<쿱?+a@?,<쿱?/v?/v?-V?-V?-V?-V?-w1?-w1?-V?/Vϫ?333333?2a|Q?1o?1o?1o?1-?6z?5Xy=?4m8?4J?333333?2a|Q?4m8?9D?8YJ?7KƧ?64K?5Xy=?5Xy=?4֡a?64K?64K?6C-?5Xy=?6z?7KƧ?8}H?6C-?6z?73?:)y?84֡b?73?8YJ?:)y?:)y?8YJ?;5Xy                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @@BfB@@Bc	@@BC,@@B䎊q@@BC,@@Bc	@@Bm@@CI^@@Bm\@@B~@@CS&@@CI^@@CI^@@CnP@@C&@@C)^	@@C6z@@CJ#9@@CMjO@@CP{@@CS@@CP{@@Ca@N@@Cjf@@Cn.3@@Ctj~@@CQ@@C@@CMj@@C:)z@@C$@@Cwk@@C@@C5Xy@@C҈@@DL_@@D/{J#@@D9XbN@@D<쿱@@D?@@DVϪ@@DZ1@@D]ce@@Dj~#@@DtSM@@DzG@@D?@@Do h@@D#@@Dqj@@Dqj@@Dqj@@DN;@@DS@@D_@@D_@@DS@@D쿱[@@DTɆ@@Dzxl"@@DTɆ@@Dzxl"@@D1&@@DO
M@@D1&@@D1&@@DTɆ@@DO
M@@D@@D?@@D?@@DɅoi@@D@@D֡a@@D֡a@@D!-w@@EK]@@E'0@@E*0@@E*0@@Equ"@@E*0@@Equ"@@E*0@@Equ"@@E5Xy>@@E?|h@@EB@@EB@@EF
L0@@EVl!@@EfA@@E!R@@Fu@@FFs@@Fߤ?@@JnO@@QJE@@SdZ@@W?@@a@@n_o @@p4m9@@p
(@@q7KƧ@@r>B@@v@@{I^@@XbM@@$@@zG@@
(@@h	ԕ@@I^5?@@"@@4K@@o hی@@ߤ@@@	 @@b}@@j~@@IQ@@(@@-
q@@&IR@@Mj@@ơaf@@ ѷ@@T`d@@˜ߤ@@7@@ϻ/V@@ ѷ@@Ѱ'R@@Ձ$/@@"@@.H@@lC@@@@-@@H@@،@@)^@@٠'RTa@@,<@@7@@@@ݼn/@@
(@@.2@@1@@)^@@RT`e@@y@@߀4m@@ߧ&@@@@F@@D@@s@@kP|@@6z@@lC@@C]@@"h	ԕ@@/{J#@@K]@@fA@@S&@@\(@@$/@@Ov_@@8YJ@@t@@"@@U=@@{J#:@@fA@@rG@@y=c@@n@@-
@@譫U@@跀4m@@ѷX@@e+@@n@@u%F@@s@@~"@@,<@@,<@@ ѷ@@u%@@MjO@@W>6z@@J#9@@P{@@g	l@@ߤ@@뢜wk@@ݗ+k@@g@@lC@@J@@xF@@1&y@@!-w2@@xF@@<쿱@@Fs@@]ce@@<쿱@@#@@_@@?@@3@@쿱[@@웥S@@쿱[@@?@@j~@@7@@Ʌoi@@*0@@>B[@@@@JM@@hr@@!-w@@!.H@@Q@@u@@+a@@/w@@!.H@@1@@@@1@@@@b@@t@@($x@@Vu@@_ح@@Vu@@c	@@O;@@m\@@A@@Mj@@.H@@H˒:@@4m@@#@@*0U@@+j@@-@@+j@@l"h	@@4m@@)^@@@@@TɅ@@)^@@ěT@@ ѷ@@:S@@R@@-@@s@@@@.H@@-@@-V@@͞&@@sP@@S&@@F]c@@9@@~($@@|@@%2@@s@@Q@@SMj@@q@@[W?@@/@@?@@'0@@!.H@@hr!@@E@@
L/@@?@@5?|@@$/@@$/@@;5X@@BZc @@l!-@@p:~@@@@ߤ?@@쿱[W@@'/W@@\(@@sPH@@͞@@@@;dZ@@rG@@#@@@@-
@@4m@@)^@@`A7@@#w@@b}@@'R@@iB@@lD@@Ov`@@C\@@u%F
@@S&@@S&@@`A@@C,@@m@@~@@tj~@@q@@:)z@@ߤ@@S@@m]@@6@@5Xy@@|@@a@@@%2@@$@@n.@@@@%1@@M:@@C@@O
M@@[W?@@[W?@@@@m\@@%@@\(@@
qv@@4K@@BZc @@$t@@Mj@@
=p@@'/W@@>6z@@H˒:@@H˒:@@RT`e@@[W>@@vȴ9@@@A      @A *0U@A Q@A YJ@A 
=q@A 
(@A @@A \)@ArGE@A_p@AA [@AJE@Au!S@A)y@AJL@Ah	ԕ@AL_@AS&@A\(@Ap:@A<64@AF]c@Aq@Aa@@As@AC,zx@AC,zx@AC,zx@A]ce@ASMj@AcA \@AtSM@Ao h@AS@A@A>@A/w@A\(@AC\@A!R<@A+jg@A+jg@A1.@A;5X@A?@A?@ABZc @AL/{J@AOv_خ@Al!-@Aqi@Aȴ9X@A+I@Ab}V@Ay@A&@A-V@AzH@Avȴ9@ArG@AVϫ@A
qu@A ě@A-
q@A1&x@A4m9@A'RT`@A1&x@A-
@A	rGE@A	0
)@A	=b@A	A [@A	u!S@A	7Kƨ@A	@A	@A
n@A
1'@A
nO@A
G{@A
m\@A33333@Ag	l@Aݗ+k@AJ@Ag8}@A/@A
'0@A
[@A
Q@A
<64@A
L_@A
m\@A
}H@A
ڹZ@A
O
@A
U=@A

qv@A
b@A
oiDg@A
ڹ@AzG@A5?|@AL/{J@A_ح@Ap:~@A}Vl@A]cf@AXe@A'/W@A'/W@A.H@A8}H@AH˒:@A_o@AiDg8@Ay@A&@AkP@Ar@A-@A*0U@A1&x@AK]c@AU2a|@Ay=c@A@Ad8@Aۋq
@A@A4J@A=b@A^@Aae@Aae@A@A_o@Ae+@AOv`@A0U2a|@AZc@AnO@AkP|@AkP|@AnO@AqiC@A~"      @Ac	@AS&@A9@Aa@N@AQ@A$@A$@A5Xy@As@ASMj@A_@A>B[@A\@AO;dZ@AfA@A,=@A!.@AzG@A5?|@A?@AR<6@A_ح@Al!-@AiB@Aaf@A'@A@A&I@Aȴ9X@At@Aߤ?@A@A쿱[W@AFs@AFs@A hۋ@AKƧ@A|hs@A˒:)@A@A+j@AbM@A$xG@A4m9@A:~ @AeO@A|@Ad8@ATɅ@A)@Ap:@AC@AC@A4֡b@APH@A$tT@A$/@AN;5@A|Q@Au@AiB@A.H@AQ_@Ad7@A^5?|@A\(@A@AfB@APH@A33333@AMjO@Aq@A@Aa@O@A@Aݗ+k@Ag@AC]@Ag@AA [@AJ@A!-w2@A/{J#@A<쿱@AVϪ@A]ce@Ag8}@A?@A쿱[@A#x@Aj~@A[W?@A?@A?@A*0@Ae@A(@A5Xy>@AIQ@A\@Aw1@AXy=@A\(@A(@A_o @Au@A$/@A+jg@AL/{J@AOv_خ@A}Vl@AT@AA@A1@Ax@A
M;@Av@Av@A'/W@A>6z@A_o@A	@A	@AO;d@Aݗ+@A?@AzH@A @A [6@A YJ@A {@A {@A 9Xb@A )@A ěT@A )^@A!A [@A!TɅo@A!XbM@A![W>6@A!TɅo@A!e+a@A!o hی@A!o@A!X@A!@A"@A")y@A")y@A"3@A"JL@A"^5?|@A"Zc@A"a|Q@A"ᰊ@A"S&@A"S&@A"vȴ@A"@A" ѷ@A"c	@A#u%@A#҉@A#PH@A#9@A#@N@A#J#9@A#S@A#g	l@A#A@A#ߤ@A#q@A#6@A#ݗ+k@A#@A$1&y@A$ߤ@@A$L_@A$L_@A$tj@A$(\@A$/{J#@A$64@A$I^5?@A$tSM@A$*1@A$?@A$@A$hr@A$/@A$Z@A$u"@A$u"@A$JM@A$e@A$e@A%K]@A%qu"@A%!.H@A%(@A%5Xy>@A%?|h@A%B@A%IQ@A%IQ@A%\@A%ce@A%%@A%n/@A%\(@A%8YK@A&$/@A&Fs@A&-@A&'@A&}Vl@A&t@A&Mj@A'Xe@A')^@A'Xe@A',@A'@A'$tS@A'8}H@A'As@A'RT`e@A'b}V@A'4m@A'$tS@A'/V@A'حV@A'rG@A( ě@A(U2a|@A(NU@A(hۋq@A(l"h	@A(YJ@A(r Ĝ@A(YJ@A('RT@A(@A(@A(tj@A(@A(-
@A(ěT@A)#w@A)@A)@A) [7@A)#w@A)-w1@A)-w1@A)0
)@A)A [@A)ae@A)ae@A)ae@A)ae@A)e+a@A)o hی@A)b}@A)R<6@A)|@A)'R@A)iB@A)iB@A)>BZ@A)Y}@A).H@A*I^5@A*0U2a|@A*:)y@A*=p
@A*:)y@A*C\@A*T`d@A*^5?|@A*d7@A*ᰊ@A*S&@A*S&@A*ᰊ@A*ᰊ@A*0
@A*0
@A*>B@A*,<@A+҉@A+)^	@A+Z@A+Z@A+dZ@A+n.3@A+xF]@A+~$@A+q@A+:)z@A+q@A+m]@A+E@A+Z@A+@A+5Xy@A+a@@A+C]@A+\N@A,tj@A,tj@A,"h	ԕ@A,!-w2@A,"h	ԕ@A,%1@A,,<@A,2W@A,<쿱@A,C,zx@A,C,zx@A,Fs@A,M:@A,SMj@A,Z1@A,cA \@A,tSM@A,wkP@A,1&@A,#x@A,[W?@A,@A,Z@A-K]@A-'0@A-'0@A-V@A-IQ@A-S&@A-Y|@A-`A7L@A-jOv@A-jOv@A-sg@A-zxl"h@A-%@A-@A-,=@A-oiDg@A-E@A-oiDg@A-ڹ@A.t@A._o @A.L/{J@A.E@A.R<6@A.fffff@A.p:~@A.z@A.vȴ9X@A.vȴ9X@A.2X@A.A@A.Ϫ͟@A.Ϫ͟@A.]cf@A.x@A.Mj@A.Mj@A."@A/Ft@A/Ft@A/
=p@A/)^@A/,@A/'/W@A/As@A/b}V@A/4m@A/$tS@A/-V@A//V@A/[W>@A/3@A/vȴ9@A/fA@A/;dZ@A/rG@A0     @A06@A0>BZc@A0U2a|@A0l"h	@A0u!@A0|@A0-
@A0u%F@A0
=q@A0d8@A0ěT@A0F@A0C@A04֡b@A0$tT@A1	k~@A1rGE@A1@A1@N@A1@N@A1@A1#w@A1@A1#w@A10
)@A10
)@A14J@A17KƧ@A1:S@A1Dg8~@A1:S@A1Dg8~@A1Gz@A1Gz@A1Q@A1[W>6@A1N;5@A1N;5@A1e+a@A1|Q@A1n.@A1'R@A1N;6@A1"`@A1@A1"`@A1"`@A1.H@A2	 @A2@A2&IR@A2)y@A2-V@A2Q_@A2W'@A2d7@A2xl"h
@A2~"@A2ݘ@A2@4@A2@4@A2p:@A2S&@A2wkQ@A2wkQ@A2>B@A2S&@A2 ě@A2g	@A2<64@A2͞&@A2sP@A2 ѷ@A2fB@A2fB@A2m@A2~@A3nP@A3"`B@A3/V@A39@A39@A39@A3J#9@A3W>6z@A3g	l@A3jf@A3qu!@A3eO@A3ߤ@A36@A3ݗ+k@A3ݗ+k@A3s@A3A [@A3$@A3\N@A3s@A4n.@A41&y@A4L_@A4@A4L_@A4L_@A4tj@A4%1@A4<쿱@A4M:@A4wkP@A4#@A4_@A4_@A4TɆ@A4?@A4[W?@A4֡a@A4@A5'0@A5o i@A5*0@A5?|h@A5B@A5S&@A5ce@A5`A7L@A5jOv@A5}H@A5@A5n/@A5\(@A58YK@A5S@A6zG@A6u@A6_o @A6zG@A6+jg@A6+jg@A61.@A6;5X@A6E@A6\N<@A6fffff@A6z@A6qi@A6Fs@A6O;@A6,<@A6'@A6m\@A6Ϫ͟@A6!.I@A6"@A7@A7$tS@A7!-w1@A7,@A7$tS@A7.H@A7>6z@A7H˒:@A7E84@A7O
M@A7sPH@A7O;d@A7	k@A7	k@A7-V@A7$tS@A7&@A7[W>@A7͞@A73@A7zH@A7[W>@A73@A7[W>@A7[W>@A7zH@A7zH@A73@A7/V@A7o @A7˒:)@A7+@A7@A7+@A7fA@A7حV@A7حV@A7rG@A7䎊r@A7rGE9@A8@A8@A8}H@A8$xG@A8$xG@A8'RT`@A81&x      @A8_F@A8˒:*@A8YJ@A8-
@A8u%F@A8
=q@A8)@A8p:@A84֡b@A9	k~@A9N;5@A9^@A9[W>6@A9[W>6@A9hr @A9hr @A9hr @A9b}@A9@A9|@A9lD@A:u%F@A:	 @A:&IR@A:-V@A:=p
@A:W'@A:kP|@A:xl"h
@A:{m@A:@4@A:p:@A:S&@A:vȴ@A:0
@A:vȴ@A:vȴ@A:>B@A: ě@A:g	@A:}Vm@A:Y@A:@A:@A:)_@A:,<@A:,<@A: ѷ@A:C,@A:c	@A:D@A:D@A:74@A:~@A:m\@A;I^@A;S&@A;S&@A;҉@A;'/@A;'/@A;nP@A;&@A;	@A;&@A;"`B@A;)^	@A;/V@A;@N@A;F]c@A;MjO@A;J#9@A;S@A;W>6z@A;jf@A;g	l@A;g	l@A;{J#9@A;U=@A;U=@A;S@A;m]@A;E@A;a@O@A;@A;@A;5Xy@A;5Xy@A;|@A;
=p@A;\N@A;s@A;@A;s@A<J@A<n.@A<ߤ@@A<@A<"h	ԕ@A<%1@A<%1@A<,<@A</{J#@A</{J#@A<<쿱@A<M:      @A<]ce@A<]ce@A<]ce@A<m8@A<tSM@A<q@A<wkP@A<~($x@A<#@A<*1@A<쿱[@A<쿱[@A<@A<#x@A<[W?@A<u"@A<u"@A<Z@A<hr@A=o i@A='0@A=V@A=*0@A=[@A=*0@A=Q@A=!.H@A=!.H@A=(@A=(@A=+a@A=2a|@A=Vl!@A=$/@A=ݗ@A=+j@A=v@A=Xy=@A=1@A=sh@A=8Y@A=8Y@A=@A=@A=8YK@A=?@A=S@A=S@A=C\@A=C\@A>t@A>_o @A>
L/@A>_o @A>4K@A>$/@A>$/@A>8YJ@A>8YJ@A>?@A>BZc @A>R<6@A>R<6@A>Vu@A>Vu@A>YJ@A>_ح@A>\N<@A>_ح@A>_ح@A>iB@A>l!-@A>s@A>vȴ9X@A>z@A>Fs@A>T@A>-@A>m\@A>Ϫ͟@A>Fs@A>"@A>@A>Mj@A>"@A>"@A>"@A>!.I@A?
=p@A?@A?v@A?'/W@A?'/W@A?1@A?;dZ@A?H˒:@A?KƧ@A?H˒:@A?_o@A?iDg8@A?o@A?v_ح@A?4m@A?$tS@A?-V@A?kP@A??@A?͞@A?&@A?͞@A?zH@A?&@A?͞@A?ݗ+@A?͞@A?͞@A?zH@A?[W>@A?[W>@A?3@A?[W>@A?3@A?r@A?vȴ9@A?˒:)@A?˒:)@A?˒:)@A?@A?@A?@A?Vϫ@A?#@A@@A@bM@A@'RT`@A@73@A@:~ @A@>BZc@A@K]c@A@H@A@U2a|@A@K]c@A@Q@A@Q@A@Q@A@_F@A@YJ@A@YJ@A@@A@@A@U@A@U@A@
(@A@ěT@A@@@A@D@A@C@A@	k@AA ѷ@AA ѷ@AA	k~@AA$/@AA	k~@AA@AA [7@AA#w@AA-w1@AA7KƧ@AADg8~@AAGz@AAQ@AAN;5@AA[W>6@AA^@AAe+a@AA(@AAB@AAn.@AA'R@AA@AAy@AA"`@AAN;6@AAs@AAY}@AAlD@AB@AB䎊@AB6C@AB=p
@AB@4n@AB^5?|@ABT`d@ABZc@ABkP|@AB@4@ABp:@AB@4@ABݘ@AB@4@ABݘ@ABp:@ABp:@ABݘ@ABݘ@AB@4@AB@4@ABp:@ABwkQ@ABS&@AB@AB}Vm@AB}Vm@ABn@AB@AB͞&@AB`A@AB ѷ@ABc	@ABm@ABD@AB74@ABm\@ACI^@AC'/@AC	@AC9@AC9@AC@N@ACF]c@ACP{@ACdZ@ACjf@ACqu!@ACn.3@ACxF]@ACeO@ACa@O@ACƧ@ACQ@AC%2@AClC@ACA [@AC@AC@ADJ@AD1&y@ADxF@AD@AD!-w2@AD(\@AD64@AD?@ADSMj@ADcA \@AD`d@ADcA \@ADtSM@AD3@AD?@AD?@AD?@AD?@AD#x@ADj~@AD@AD7@AD?@AD@AD>B[@AD>B[@AD>B[@AD>B[@AD>B[@AD>B[@ADZ@AD>@ADE@AE'0@AEqu"@AE!.H@AE(@AE+a@AE84֡@AES&@AEO;dZ@AE`A7L@AEfA@AEjOv@AE$/@AEw1@AEzxl"h@AE}H@AE$/@AE$/@AEM:@AEM:@AEhr!@AE+j@AE=K@AE+j@AE=K@AE%@AE1@AE-V@AE-V@AEsh@AEsh@AE8Y@AE@AE?@AE,=@AEoiDg@AEE@AE!.@AF_o @AF_o @AFt@AF_o @AF4K@AF!R<@AF$/@AF($x@AF+jg@AF1.@AF5?|@AF?@AFOv_خ@AFR<6@AF\N<@AF\N<@AFfffff@AF_ح@AFl!-@AFz@AFz@AF}Vl@AFIQ@AF+J@AF%@AF+J@AF@AF6z@AF@AF2X@AF@AF@AF&I@AFߤ?@AFt@AFA@AFߤ?@AFx@AF쿱[W@AFx@AF@AFMj@AFFs@AF"@AG@AG
=p@AG)^@AGXe@AGXe@AGv@AG,@AG$tS@AG$tS@AG!-w1@AG.H@AG!-w1@AG1@AG>6z@AGAs@AGE84@AGH˒:@AGH˒:@AGH˒:@AGKƧ@AGO
M@AGU=@AGb}V@AGiDg8@AGlC@AG&@AG@AG-V@AG-V@AG͞@AGzH@AG͞@AGzH@AG3@AGvȴ9@AG@AGK]d@AG䎊r@AG䎊r@AG+j@AG䎊r@AG-@AHF]d@AH@AH6@AH@AH'RT`@AH ě@AH*0@AH4m9@AHH@AHK]c@AH[6@AHbM@AHhۋq@AHhۋq@AHr Ĝ@AHr Ĝ@AHu!@AHy=c@AH@AH@AHtj@AH-
@AH{@AH)^@AHۋq
@AH`A7@AH4֡b@AI_p@AI@AI@N@AIrGE@AI@N@AIrGE@AI@N@AI&x@AI*0U2a@AI*0U2a@AI*0U2a@AI-w1@AI:S@AI:S@AIDg8~@AI=b@AIDg8~@AIGz@AIN;5@AIN;5@AIQ@AIXbM@AIae@AIae@AIhr @AIe+a@AIk~(@AIk~(@AIk~(@AIe+a@AIk~(@AIo hی@AIx@AIb}@AIo@AI7Kƨ@AI~($@AI7Kƨ@AIo@AIR<6@AIR<6@AIu@AI@AI@AIR<6@AI@AIo@AI@AI'RTa@AIu@AI'RTa@AI(@AI'RTa@AIn.@AI(@AIB@AI^5?}@AI@AIo@AIo@AI_o@AI>BZ@AIR@AJI^5@AJs@AJ䎊@AJ䎊@AJ䎊@AJ#9@AJ-V@AJ3@AJ3@AJ3@AJ3@AJ6C@AJ=p
@AJ@4n@AJGE85@AJC\@AJC\@AJM@AJa|Q@AJW'@AJ^5?|@AJh	ԕ@AJL_@AJ\(@AJL_@AJS&@AJS&@AJS&@AJᰊ@AJ0
@AJvȴ@AJg	@AJY@AJY@AJn@AJY@AJY@AJ<64@AJn@AJ@AJ@AJ)_@AJW@AJW@AJ͞&@AJڹY@AJG{@AJ ѷ@AJfB@AJD@AJm\@AKS&@AJm\@AJm\@AJm\@AKu%@AK҉@AKS&@AKu%@AKnP@AK҉@AK'/@AK'/@AKnP@AK'/@AK҉@AK'/@AKnP@AK'/@AKPH@AKs@AKnP@AKPH@AKPH@AK"`B@AK"`B@AK)^	@AK/V@AK6z@AK=K^@AK=K^@AKC%@AKMjO@AKS@AKZ@AK]cA@AK~$@AK~$@AK~$@AK~$@AK@AK@AKQ@AKeO@AKQ@AK~$@AK@AKeO@AK@AKeO@AKeO@AKq@AKMj@AKMj@AK:)z@AK$@AKwk@AKm]@AK6@AK6@AKa@O@AKƧ@AKƧ@AK5Xy@AKƧ@AKƧ@AKa@@AKa@@AK҈@AKC]@AKC]@AKA [@AK@AK$@AK@AK\N@AL1&y@ALߤ@@ALߤ@@ALߤ@@AL@AL@ALtj@ALQ@ALQ@AL!-w2@ALtj@AL"h	ԕ@AL%1@AL%1@AL,<@AL2W@AL<쿱@AL?@AL9XbN@AL9XbN@AL9XbN@AL<쿱@ALC,zx@ALC,zx@ALFs@ALC,zx@ALPH@ALVϪ@ALVϪ@AL`d@ALj~#@ALj~#@ALcA \@ALm8@ALtSM@ALwkP@ALo h@ALC@ALqj@ALN;@AL_@ALC@AL*1@AL*1@AL_@AL*1@ALS@ALS@AL쿱[@ALS@AL쿱[@AL쿱[@ALzxl"@AL쿱[@AL1&@AL1&@ALTɆ@ALO
M@AL1&@ALO
M@AL?@AL@AL@AL1&@ALO
M@AL?@AL?@AL?@AL#x@ALj~@ALj~@ALj~@AL[W?@ALɅoi@ALZ@AL/@ALu"@AL@ALu"@ALD@ALE@AM:@ALE@AMK]@AM'0@AM'0@AMu@AMQ@AM!.H@AM+a@AM(@AM+a@AM/w@AM2a|@AM2a|@AM<64@AM?|h@AM<64@AM84֡@AM<64@AMIQ@AMS&@AMO;dZ@AMO;dZ@AML_@AMO;dZ@AMO;dZ@AMO;dZ@AM\@AM`A7L@AMfA@AMp
=@AMzxl"h@AM$/@AM!R@AM}H@AM!R@AMݗ@AM+j@AM%@AM%@AM%@AM=K@AM@AMXy=@AMU=@AMU=@AM1@AMsh@AMsh@AM@AMn/@AMn/@AM@AMH˒@AM\(@AM\(@AM\(@AMn/@AM8Y@AM8Y@AMcA @AMϪ͞@AMϪ͞@AMS@AM,=@AMᰉ@AMS@AM,=@AMS@AM?@AM
qv@AMᰉ@AM(@AMC\@AN ѷY@AMڹ@ANt@AN
L/@AN
(@AN
(@AN
(@ANzG@ANzG@AN@ANu@ANu@ANOv_@ANu@ANOv_@ANOv_@ANu@ANOv_@ANOv_@ANOv_@AN!R<@AN+jg@AN;5X@AN?@AN;5X@ANH@ANL/{J@ANR<6@ANR<6@ANVu@ANYJ@ANOv_خ@ANOv_خ@ANYJ@AN\N<@AN\N<@AN\N<@AN_ح@ANfffff@ANiB@ANiB@ANiB@ANl!-@ANp:~@ANvȴ9X@ANvȴ9X@ANz@ANIQ@ANqi@ANO;@AN,<@ANaf@ANT@AN}Vl@AN2X@ANȴ9X@ANȴ9X@ANA@ANt@ANA@AN1@ANC-@ANC-@ANx@AN@ANMj@ANFs@ANFs@AN"@ANFs@AN!.I@AN"@AO@AO
M;@AO
=p@AO@AOv@AOv@AOXe@AO,@AO,@AOv@AO,@AO,@AO$tS@AO!-w1@AO'/W@AO$tS@AO'/W@AO8}H@AO8}H@AO;dZ@AOE84@AOU=@AORT`e@AOU=@AOU=@AORT`e@AORT`e@AORT`e@AORT`e@AORT`e@AORT`e@AORT`e@AOU=@AOU=@AORT`e@AOXe,@AOU=@AOXe,@AO\(@AO\(@AO_o@AOiDg8@AOeں@AOiDg8@AOlC@AOlC@AOsPH@AOv_ح@AOy@AO{J#:@AO{J#:@AO4m@AO{J#:@AO4m@AO&@AOݗ+@AOݗ+@AO	k@AO&@AO͞@AO[W>@AOzH@AOzH@AO&@AO&@AOzH@AO3@AO3@AO/V@AO/V@AOvȴ9@AOvȴ9@AOvȴ9@AO@AO@AOo @AOo @AOK]d@AOvȴ9@AOK]d@AO˒:)@AOK]d@AO˒:)@AO@AOfA@AOfA@AOحV@AOحV@AO;dZ@AO@@AO;dZ@AO;dZ@AO@@AO@AO@AOrG@AOVϫ@AO䎊r@AO䎊r@AO#@AO+j@AO+j@AO#@AO#@AO#@APF]d@AP
qu@AP@APF]d@AP
qu@AP
qu@APbM@APbM@AP6@AP*0@AP*0@AP$xG@AP}H@AP$xG@AP$xG@AP'RT`@AP'RT`@AP-
q@AP4m9@AP1&x@AP73@AP4m9@AP73@AP>BZc@APA7K@AP:~ @APA7K@APD*@APH@APD*@APNU@APH@APNU@APNU@APQ@APU2a|@APQ@APQ@APU2a|@AP[6@AP_F@APl"h	@APoiDg8@APr Ĝ@AP|@APn@AP@APn@AP'RT@AP-
@APtj@AP-
@APu%F@AP-
@APIQ@AP-
@AP-
@APIQ@AP-
@AP
=q@APd8@AP)@AP
(@AP)@AP
(@APěT@APěT@APTɅ@APěT@APp:@APѷX@APF@APe+@AQ ѷ@AP	k@APPH@AQ ѷ@APPH@AP$tT@AP$tT@AQ ѷ@AQ$/@AQrGE@AQ+@AQrGE@AQ+@AQ_p@AQ_p@AQ@AQ@N@AQ_p@AQ [7@AQ [7@AQ#w@AQ@AQ#w@AQ [7@AQ#w@AQ*0U2a@AQ0
)@AQ-w1@AQ7KƧ@AQ7KƧ@AQ4J@AQDg8~@AQA [@AQN;5@AQQ@AQQ@AQTɅo@AQXbM@AQTɅo@AQTɅo@AQTɅo@AQ[W>6@AQ^@AQ^@AQ^@AQ[W>6@AQXbM@AQ[W>6@AQ^@AQae@AQe+a@AQ^@AQe+a@AQhr @AQhr @AQhr @AQo hی@AQk~(@AQo hی@AQrGE8@AQrGE8@AQrGE8@AQo hی@AQo hی@AQu!S@AQx@AQrGE8@AQ|Q@AQx@AQx@AQ|Q@AQ|Q@AQ|Q@AQb}@AQ|Q@AQoiD@AQoiD@AQoiD@AQ7Kƨ@AQ~($@AQo@AQ~($@AQ@AQ@AQ@AQR<6@AQu@AQ|@AQl@AQl@AQ|@AQX@AQX@AQ@AQD@AQD@AQ2W@AQ2W@AQo@AQ2W@AQo@AQ_o@AQԕ*@AQԕ*@AQ"`@AQ@AQԕ*@AQiB@AQᰉ'@AQᰉ'@AQ>BZ@AQ>BZ@AQ>BZ@AQR@AQ@AQR@AQ>BZ@AQ@AQ@AQs@AQ-@AQY}@AQ.H@AQlD@AR	 @ARu%F@ARn@AR	 @ARI^5@ARI^5@ARn@AR@AR䎊@ARe+@AROv`@ARe+@AR1'@AR@AR&IR@AR#9@AR#9@AR)y@AR-V@AR3@AR6C@AR3@AR6C@AR6C@AR=p
@AR=p
@AR=p
@AR@4n@ARGE85@ARGE85@ARJL@ARGE85@ARJL@ARQ_@ART`d@ART`d@AR^5?|@AR^5?|@ARZc@AR^5?|@ARa|Q@AR^5?|@ARd7@ARa|Q@ARa|Q@ARZc@ARd7@ARd7@ARkP|@ARqiC@ARkP|@AR{m@AR{m@AR~"@AR@4@ARS&@ARwkQ@AR0
@ARvȴ@ARL/{@ARS&@ARvȴ@ARvȴ@ARvȴ@ARL/{@ARvȴ@ARS&@AR@ARL/{@AR@AR ě@ARg	@ARn@AR<64@AR<64@ARY@ARW@AR@ARW@ARW@AR͞&@AR͞&@AR`A@AR͞&@AR,<@AR͞&@AR`A@ARW@ARW@ARsP@ARsP@ARsP@ARڹY@ARG{@ARC,@ARc	@ARc	@ARm@AR~@ARD@AR~@AR~@AR~@AR74@AR~@AR~@AR~@AR74@ARm\@ARm\@ARD@ARm\@AR74@AR74@AR~@AR~@AR~@AR74@ARm@AR74@AR~@ARm\@ARm\@ARm\@ARm\@ASI^@ASI^@ARm\@ASI^@ASI^@ASS&@ASu%@AS҉@AS҉@AS҉@AS҉@AS҉@ASnP@ASnP@ASs@ASs@ASPH@ASC,z@AS	@ASC,z@AS&@AS)^	@AS33333@AS"`B@AS)^	@AS,zxl@AS/V@AS33333@AS33333@AS6z@AS6z@AS9@AS=K^@ASF]c@AS6z@AS=K^@AS@N@ASC%@ASF]c@ASP{@ASP{@ASMjO@ASMjO@ASP{@ASP{@ASW>6z@ASZ@ASdZ@ASdZ@ASdZ@ASdZ@ASn.3@ASn.3@ASn.3@ASjf@ASqu!@ASxF]@ASxF]@ASxF]@ASxF]@ASxF]@AS~$@AStj~@AS{J#9@AS@ASQ@AS{J#9@ASQ@ASeO@ASQ@AS~$@ASeO@ASq@ASeO@ASeO@ASeO@ASeO@ASeO@ASq@ASeO@ASMj@AS:)z@ASMj@ASMj@ASMj@AS:)z@AS$@AS$@ASeO@AS:)z@AS:)z@AS$@ASA@AS$@ASMj@ASA@AS$@ASA@ASߤ@AS$@ASA@AS$@AS$@ASߤ@ASS@ASwk@AS*0U2@ASq@ASq@AS*0U2@AS*0U2@AS@AS@AS@AS@AS@ASm]@ASE@AS~($@ASE@ASZ@AS6@ASƧ@AS5Xy@AS@AS
=p@AS5Xy@ASa@@AS|@AS
=p@ASa@@AS
=p@ASa@@ASQ@ASQ@ASQ@ASQ@ASQ@AS
=p@AS
=p@AS
=p@ASQ@ASQ@ASQ@ASQ@AS
=p@ASa@@ASݗ+k@AS҈@ASlC@ASg@ASA [@AS$@ASA [@AS$@AS@AS@AS$@ASs@AS\N@ASs@AS@ASs@AS@AS\N@ATn.@ATJ@ATn.@ATn.@ATn.@ATn.@ATJ@ATxF@ATxF@ATxF@ATn.@AT1&y@ATxF@ATߤ@@AT1&y@AT@AT@ATL_@ATxF@ATL_@ATL_@AT@AT@ATL_@ATtj@ATtj@ATtj@AT@ATtj@ATQ@ATQ@AT!-w2@AT%1@AT(\@AT(\@AT(\@AT,<@AT(\@AT/{J#@AT,<@AT,<@AT,<@AT%1@AT(\@AT/{J#@AT,<@AT/{J#@AT,<@AT%1@AT,<@AT,<@AT64@AT/{J#@AT2W@AT<쿱@AT<쿱@AT<쿱@ATC,zx@AT?@ATI^5?@ATM:@ATI^5?@ATFs@ATI^5?@ATFs@ATI^5?@ATM:@ATI^5?@ATPH@ATSMj@ATPH@ATVϪ@ATSMj@ATPH@ATSMj@AT]ce@ATZ1@ATVϪ@ATZ1@AT`d@AT]ce@AT]ce@ATVϪ@ATZ1@AT]ce@AT`d@AT]ce@AT`d@ATcA \@AT`d@ATcA \@ATg8}@ATg8}@ATcA \@ATj~#@ATm8@ATq@ATj~#@ATg8}@ATm8@ATj~#@ATq@ATj~#@ATm8@ATm8@ATq@ATq@ATtSM@ATq@ATm8@ATwkP@ATwkP@ATzG@AT~($x@ATzG@ATzG@ATzG@ATzG@ATwkP@ATzG@AT~($x@ATwkP@ATwkP@ATzG@ATtSM@ATzG@ATo h@AT~($x@ATo h@AT#@AT#@ATC@AT#@ATN;@ATqj@ATC@ATo h@AT?@AT?@AT?@AT#@ATC@ATC@AT#@ATo h@ATC@ATC@ATqj@ATN;@AT*1@ATN;@ATqj@ATN;@AT*1@AT_@AT쿱[@AT_@ATS@AT쿱[@ATS@AT쿱[@AT쿱[@AT쿱[@AT쿱[@AT3@AT쿱[@AT쿱[@AT쿱[@AT_@AT쿱[@ATzxl"@ATzxl"@AT1&@AT1&@AT1&@ATTɆ@AT1&@ATO
M@AT?@AT?@AT#x@AT#x@AT#x@AT@ATj~@AT[W?@AT[W?@AT7@AT7@AT?@AT@AT֡a@AT@ATZ@ATZ@AT>B[@AT>B[@ATZ@AT*0@AT*0@AT>B[@ATZ@AT֡a@AT>B[@AT>B[@ATZ@AT>B[@AT/@AT/@AT֡a@AT/@ATZ@ATu"@ATZ@AT>B[@AT/@ATZ@ATu"@AT@ATZ@ATZ@ATZ@ATZ@AT@ATJM@ATZ@ATu"@ATu"@AT@ATJM@AT@ATu"@ATZ@AT@ATJM@ATZ@ATZ@ATZ@ATZ@ATJM@AT@ATJM@AT@ATu"@ATZ@ATZ@AT@ATJM@AThr@AThr@ATJM@ATJM@ATJM@AThr@AThr@ATD@AT!-w@ATe@AT>@ATD@AThr@ATD@AT!-w@ATE@AT!-w@AT!-w@AT>@ATe@AT>@AT>@ATe@AT!-w@ATE@ATE@AU:@AUo i@AU:@AU:@AU:@AU:@AT>@AU:@AUo i@AU'0@AU:@AU:@AU:@AUo i@AUo i@AU'0@AU'0@AUV@AUK]@AUK]@AU'0@AUu@AU'0@AU'0@AU'0@AU'0@AU'0@AU'0@AUu@AUu@AU*0@AUV@AU*0@AUqu"@AU*0@AUqu"@AU*0@AUu@AU*0@AUqu"@AUQ@AUQ@AUQ@AU[@AUQ@AU*0@AU!.H@AUQ@AUQ@AUQ@AUqu"@AU*0@AU!.H@AU!.H@AU(@AU(@AU+a@AU+a@AU(@AU(@AU(@AU(@AU+a@AU/w@AU(@AU+a@AU/w@AU/w@AU2a|@AU2a|@AU/w@AU2a|@AU2a|@AU2a|@AU+a@AU2a|@AU2a|@AU84֡@AU84֡@AU<64@AU5Xy>@AU2a|@AU5Xy>@AU2a|@AU<64@AU84֡@AU<64@AUB@AUB@AUF
L0@AUB@AUIQ@AUL_@AUO;dZ@AUL_@AUB@AUO;dZ@AUL_@AUO;dZ@AUS&@AUS&@AUS&@AUO;dZ@AUVl!@AUY|@AUO;dZ@AUVl!@AUVl!@AUVl!@AUVl!@AUY|@AU\@AUY|@AUVl!@AU`A7L@AUY|@AUY|@AU\@AU\@AU\@AU\@AU\@AUVl!@AU\@AU`A7L@AU`A7L@AUVl!@AUVl!@AU\@AUY|@AU\@AU`A7L@AUY|@AUY|@AU\@AU\@AU`A7L@AU\@AUY|@AU\@AUY|@AU\@AU\@AUY|@AU`A7L@AU`A7L@AU`A7L@AU`A7L@AU\@AU\@AUY|@AU\@AU\@AU`A7L@AU`A7L@AU`A7L@AUce@AU\@AU\@AU\@AU`A7L@AU`A7L@AUce@AUfA@AU`A7L@AUce@AUfA@AU`A7L@AUfA@AUce@AU\@AUce@AUce@AUce@AUjOv@AUce@AUjOv@AUfA@AUfA@AUjOv@AUm\@AUm\@AUm\@AUm\@AUm\@AUm\@AUm\@AUm\@AUce@AUm\@AUce@AUp
=@AUw1@AUsg@AUp
=@AUm\@AUsg@AUw1@AUsg@AUsg@AUm\@AUsg@AUzxl"h@AUzxl"h@AUzxl"h@AU}H@AUsg@AUzxl"h@AUM:@AU$/@AUw1@AU$/@AUM:@AUM:@AUݗ@AU$/@AUzxl"h@AU}H@AUM:@AUM:@AUݗ@AUڹZ@AU$/@AUM:@AUݗ@AU!R@AUڹZ@AU$/@AUڹZ@AU!R@AUڹZ@AU!R@AUݗ@AUݗ@AUڹZ@AUM:@AUhr!@AU!R@AUڹZ@AU!R@AUM:@AUݗ@AU!R@AUڹZ@AU!R@AUhr!@AUM:@AUݗ@AU!R@AUڹZ@AUhr!@AUO
@AUhr!@AUڹZ@AUhr!@AU!R@AU!R@AUO
@AU!R@AUݗ@AUM:@AU!R@AUڹZ@AUhr!@AU!R@AUڹZ@AUڹZ@AU!R@AUhr!@AUڹZ@AUhr!@AUO
@AUhr!@AU!R@AU!R@AU!R@AUO
@AUO
@AUO
@AUO
@AUO
@AU!R@AUO
@AUO
@AU+j@AU=K@AU%@AUO
@AUhr!@AU+j@AUO
@AUO
@AU+j@AU=K@AU=K@AUO
@AU+j@AU=K@AU%@AU%@AU%@AU%@AU%@AU@AU=K@AU+j@AUO
@AU=K@AU=K@AU+j@AU%@AUhr!@AUhr!@AU+j@AU+j@AU=K@AU=K@AU=K@AU+j@AU=K@AU%@AU%@AU%@AU=K@AU@AU%@AU@AU@AUv@AU@AU@AU%@AU@AUv@AU@AU%@AU@AUv@AU@AU@AU%@AUv@AU                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @r@r@r33333@r     @r     @r33333@rfffff@r@r@r@rfffff@r     @r{33333@r~fffff@r|@r~fffff@r     @r~fffff@rx     @rvfffff@rx     @r|@ry@rvfffff@rq@rp     @rx     @r|@rd@rc33333@ra@rd@rk33333@rnfffff@rp     @ri@ri@rT@rI@rP     @r[33333@rk33333@rffffff@rd@ri@rl@rc33333@rffffff@ri@rnfffff@rh     @rd@r^fffff@r\@r^fffff@r^fffff@r^fffff@r[33333@r^fffff@rh     @rh     @rd@rc33333@r\@r[33333@r^fffff@r^fffff@r^fffff@rT@rVfffff@r\@r[33333@r[33333@r^fffff@r\@r[33333@rT@rX     @rT@rT@rS33333@rVfffff@rVfffff@r[33333@rX     @rVfffff@rX     @rY@rT@rT@rP     @rT@rT@rK33333@rD@r6fffff@r      @q     @q^fffff@q333333@pfffff@o33333@o#33333@nfffff@n@n@nfffff@m@mfffff@l33333@lFfffff@k     @kfffff@k33333@kC33333@jc33333@ifffff@h@h\@g@gY@g6fffff@f33333@f)@efffff@e     @e33333@e33333@d     @d33333@d@d0     @c@cٙ@c@c33333@c@c|@cvfffff@ci@cc33333@c\@cY@c9@b@bfffff@bə@b33333@b33333@b@b@b     @b     @bs33333@bvfffff@bl@b`     @bVfffff@b6fffff@b@bfffff@b      @a@aٙ@a33333@a33333@aə@a33333@a33333@a33333@al@a`     @ai@ap     @aS33333@a@`@`     @`33333@`33333@`33333@`@`@`@`@`33333@`333333@`fffff@_fffff@_fffff@_,@^33333@^33333@^@^33333@^fffff@^l@^333333@^&fffff@^@^33333@^33333@]@]     @]@]fffff@]@]@]@]y@]Ffffff@]33333@\33333@\ٙ@\fffff@\     @\fffff@\@\fffff@\@\33333@\@\Y@\&fffff@\&fffff@\33333@\fffff@\fffff@[@[@\@\fffff@[fffff@[     @[     @[l@[fffff@Z     @Z333333@Z      @Y@Y@Y@Z      @Yٙ@Y@Y@Y     @Y,@Xٙ@X@XY@X      @X      @Xfffff@W     @WS33333@W33333@V33333@V@W9@V33333@V     @VFfffff@V9@V      @V33333@V33333@U@UY@U@U33333@U@Ufffff@U@T33333@Ty@T&fffff@S@Sٙ@S@S@S     @Sffffff@SL@S9@S&fffff@S      @R     @R     @R@R33333@Ry@R@Q33333@Qfffff@Q33333@Qfffff@Q@Q33333@Q@Q     @Q@Qffffff@QL@Q      @Qfffff@Pfffff@P33333@Qfffff@P33333@P@P     @Ps33333@Pl@PL@P      @Oٙ@O     @O@O@Nٙ@Offffff@N33333@N@N333333@M33333@M     @M     @Ms33333@MY@M@     @ML@M@L33333@Lfffff@L     @L     @L@L     @L@L     @LY@LL@L@     @LL@L&fffff@L@K33333@K@K@KY@K@     @K&fffff@K&fffff@J@J@JL@J@Ifffff@Iٙ@Ifffff@IY@I@I@Hfffff@H@H@Hfffff@H33333@HY@HL@H@     @H&fffff@H@G33333@Gfffff@G@G@G     @Gs33333@Gffffff@GL@G@F33333@F@FL@E33333@Efffff@F      @F      @E33333@Efffff@Efffff@Effffff@E@D     @D@D     @D33333@D     @D     @Ds33333@Ds33333@Dffffff@D@     @D333333@D@Cfffff@CL@C      @C      @C      @B33333@B33333@B33333@C      @B33333@C@B33333@Bfffff@Bfffff@Bfffff@B     @B&fffff@B&fffff@B      @Aٙ@A33333@Aٙ@Aٙ@Afffff@Afffff@A33333@A@Affffff@As33333@A@A@As33333@AL@A333333@A@@33333@A      @@@@     @@fffff@@@@s33333@@ffffff@@@     @@&fffff@?fffff@?@?ffffff@?L@>33333@>333333@=@=L@=333333@=L@=L@=ffffff@=L@=L@=     @=L@=33333@=@=L@=L@=ffffff@=L@<fffff@<@<@<@<     @<L@<L@<      @;@;@;fffff@;@;@;@;@;ffffff@;     @;333333@;333333@:@:fffff@:@:@:@:L@:ffffff@:ffffff@:L@:@:@933333@9@933333@933333@9     @9333333@9333333@9333333@9333333@9      @8@833333@8fffff@9            @833333@8@833333@8     @8L@8@8L@8      @7fffff@733333@7L@6fffff@733333@7L@6fffff@6@6@633333@6333333@6L@6ffffff@6L@6333333@6L@6ffffff@6L@6333333@6      @6333333@6L@6L@6333333@6L@6@6      @6L@6@5@5L@5L@5     @5L@5ffffff@5ffffff@5333333@5L@4fffff@5      @5@4@433333@4@433333@4@4fffff@4fffff@4@4@4ffffff@4L@4@4@4@3fffff@333333@333333@3@3L@3ffffff@3L@3@3333333@3      @2@233333@2@2fffff@2fffff@2     @2@2@2fffff@2     @2@2@2@2@233333@2L@2@2@2L@2ffffff@2ffffff@2ffffff@2L@2333333@2      @2333333@2@1fffff@1fffff@133333@1     @1ffffff@133333@133333@1     @133333@1     @1L@1     @1L@1L@1333333@1L@1333333@1333333@1333333@1      @1      @1      @1      @033333@0fffff@0fffff@0fffff@1      @0fffff@033333@0@033333@0@033333@0L@0     @0ffffff@0L@0L@0333333@0333333@0333333@0L@/@0333333@0ffffff@0@0      @0@/@/@0333333@0@/@/@0      @0333333@0333333@/@/@/ffffff@0      @/@/@/@/@/333333@/@/ffffff@/333333@/333333@/ffffff@/ffffff@/@/333333@/333333@/ffffff@/ffffff@/      @.@/333333@/@/ffffff@/333333@/      @.ffffff@.@.@.ffffff@.@.333333@.@/      @.333333@/333333@.@.@/333333@/      @/      @/ffffff@/333333@/333333@.@/333333@/333333@/ffffff@/333333@.@.@/      @/333333@/333333@/333333@.@-@.      @.ffffff@-@-@.333333@.333333@-@-ffffff@-333333@-333333@-@.      @-@-333333@,@,ffffff@,      @,@,@,@,@,@,@,@,ffffff@,333333@,ffffff@,@,@-333333@,@,@,@,@,@,ffffff@,@,@,@,@,@,@,@,@-333333@,@,@,@,ffffff@,@,@,@,@,@,@-      @-      @,@-      @-      @,@-      @,@-      @,@-333333@,333333@,333333@,@,ffffff@,333333@,@-333333@,@+@,      @+@,333333@,333333@,333333@,ffffff@,ffffff@,@,@,333333@,@,333333@,      @+@,333333@,@,ffffff@,333333@,ffffff@,ffffff@,      @,333333@,@,@,333333@,333333@,ffffff@,333333@,333333@,      @,333333@,      @,333333@,333333@,333333@+@,      @+@,333333@+@,      @,      @+@,      @+@+@+ffffff@+ffffff@+@+@+@+@+@+@+ffffff@,333333@,ffffff@+@+@+333333@,      @,ffffff@,@,333333@+@,333333@,      @,333333@,333333@,ffffff@,ffffff@,@,ffffff@,@,ffffff@,@-333333@,@,@,@,@,@,@,@-      @,ffffff@,333333@,@,ffffff@,@-333333@-      @,@,@,ffffff@,333333@,@,ffffff@-      @+@,      @,ffffff@,      @+@,333333@,ffffff@,@,ffffff@,333333@,@,333333@,@,      @+ffffff@,@,333333@+ffffff@,      @,@,@,333333@+@,@,@,ffffff@,@,@,ffffff@,333333@-      @-333333@,      @+@+@,@,ffffff@,ffffff@,ffffff@,ffffff@,      @-      @,ffffff@,      @,ffffff@,@,ffffff@,@,      @+@,333333@,      @,333333@,333333@,333333@,@,ffffff@,ffffff@,333333@+@-      @,ffffff@,      @,@-333333@,@,ffffff@,333333@-333333@-333333@-333333@,@,@-333333@-333333@,ffffff@-      @-      @,ffffff@-      @-333333@-333333@-333333@,@-      @,@,@-333333@-333333@,@-      @,@,@,@,@,      @,333333@,333333@,@,@,ffffff@,333333@,333333@,      @,333333@,      @+@+333333@*@+      @*@*333333@+333333@+      @+ffffff@+@,333333@+@+@+333333@*@)@*      @*@)@)      @*333333@*      @*333333@*333333@)@)ffffff@)@)@)@)ffffff@)@*@*@*      @*@*ffffff@*ffffff@*333333@*ffffff@*      @)@*      @*ffffff@*333333@)@)@)@*      @)@*@*333333@*      @)@)@)@*@*ffffff@*      @*      @*ffffff@*ffffff@*333333@*@*      @*@*@*@*333333@*ffffff@*      @*@*ffffff@*ffffff@*      @*@*ffffff@*@*333333@*333333@*@*@*@*@*@*@*@+      @*@*ffffff@*@*@*@*333333      @*@*@+      @+333333@+@+@*@+333333@,ffffff@,ffffff@,      @,ffffff@,ffffff@,      @,@-      @,333333@,      @,@,@,@,@,@,333333@,ffffff@,333333@,@-      @-333333@-333333@-333333@,@,@-333333@-ffffff@,@-      @-333333@-333333@-      @-      @,@-333333@-333333@-      @-      @-      @-333333@,@-      @-333333@-333333@-ffffff@-333333@-      @-333333@-@-333333@,@-ffffff@-333333@-@-ffffff@-333333@-333333@-333333@-333333@-333333@-      @-      @-333333@-333333@-ffffff@-333333@-ffffff@-ffffff@-ffffff@.ffffff@.      @.ffffff@.333333@.333333@.      @.333333@.@.ffffff@.ffffff@.@.@.@.      @-@.333333@.@.@.ffffff@.      @/      @.@.333333@.@.@.@/333333@/ffffff@/      @/      @/      @/@0ffffff@/ffffff@/333333@/333333@/ffffff@/@0333333@0@/@/333333@0      @0@0@0@0@0     @0@0     @0333333@/@0      @0333333@0     @0@0@0ffffff@0     @0@0@0fffff@0     @0@1@1      @0fffff@1L@1      @1L@0fffff@1@1333333@1333333@1333333@1333333@1333333@1L@1     @1L@1333333@1L@1333333@1333333@1333333@1ffffff@1@1@1@1     @1@1     @133333@1@133333@1fffff@1     @1ffffff@133333@2@2333333@1fffff@2@1fffff@1fffff@2      @2@2@2     @2@2     @2     @2     @2     @2@2@2fffff@2     @3      @3333333@2@2@3@3333333@3333333@3L@3     @3      @3333333@3L@3@3@3@3fffff@4      @3fffff@4      @3fffff@4      @3@3@4      @3@333333@4333333@4      @4@4      @3fffff@4      @4@3fffff@3fffff@4      @4      @4L@4L@4@4     @4333333@4@4333333@4@4L@4ffffff@5      @5333333@5L@5333333@4fffff@4@5@5ffffff@5ffffff@5L@5333333@5L@5L@6      @6      @5fffff@5fffff@6333333@6333333@6L@6@633333@6fffff@6@6     @6@7      @6fffff@7333333@7      @6fffff@6fffff@6fffff@7L@7L@6fffff@7      @7@7333333@7@7     @7fffff@8L@8     @8     @8@8     @8fffff@833333@9      @9      @9@9     @9L@9      @8fffff@9     @9fffff@9fffff@:      @:333333@:333333@9fffff@9@:      @:333333@:ffffff@:      @:333333@:@:333333@:333333@:333333@:333333@:L@:     @:@:33333@:     @:@:@:fffff@;      @:@:@:33333@;L@;L@;@;333333@;33333@<      @;@<      @<@<333333@<     @<@<     @<33333@<@=@=@=@=     @=@=@=@=@=@>      @>@>L@>L@>     @>333333@>ffffff@>     @>@>@>fffff@?      @>fffff@?      @?@?33333@?33333@@      @@@@&fffff@@@@@@      @?@?@@@@333333@@Y@@@     @@@     @@@     @@ffffff@@Y@@ffffff@@ffffff@@     @@@@fffff@@@@     @@@A      @A@A333333@A&fffff@AL@A@     @AL@AL@A333333@A&fffff@A&fffff@A@     @A333333@A333333@A@     @AY@A@     @A@     @AY@A@A@A     @Affffff@A@A@A     @A@B@A33333@A33333@A@B@B333333@B@B@BL@Bffffff@Bs33333@Bffffff@BL@Bffffff@B     @Bfffff@B33333@B@B@B@B33333@B     @B33333@B33333@Bfffff@C      @Bٙ@B     @Bfffff@B@Bfffff@Bٙ@B33333@C&fffff@C&fffff@C&fffff@C333333@Cffffff@Cffffff@C     @C     @C@Cs33333@C     @C@C@C@C33333@C@Cfffff@C33333@C@C@Cfffff@Cfffff@C@C33333@C33333@C33333@C33333@Cfffff@D@D@D      @D@D@D@D      @D&fffff@D&fffff@D333333@D333333@D@Dfffff@Dffffff@D     @Dٙ@D     @D@D@D33333@D33333@D33333@D33333@D@Dfffff@E@E@E@E@     @EL@EY@Effffff@E@     @E     @E@Eٙ@E@E     @E33333@E33333@F      @F@F@F@     @F@F333333@FL@FY@Fffffff@FY@F@F@F33333@G@G&fffff@G&fffff@GY@GL@G333333@G@G      @G&fffff@GL@GY@GY@GY@G&fffff@G333333@Gs33333@GL@G     @Gfffff@G@G     @G@Gfffff@G@Gfffff@G33333@G     @G33333@Gٙ@Gfffff@Gfffff@G     @Gfffff@H      @G@Gٙ@Gfffff@H333333@H@Gfffff@H      @H&fffff@H@     @H333333@H&fffff@H@H333333@HL@HL@HL@H@     @HY@Hs33333@HY@Hffffff@H     @Hffffff@HY@Hs33333@H@Hfffff@H     @H@Hfffff@I@I&fffff@IL@IL@IY@Is33333@Is33333@Iffffff@Ifffff@I@Is33333@Iffffff@Is33333@I     @I     @I     @I@Is33333@I     @Ifffff@I@Iffffff@I     @Iٙ@J@     @J333333@J      @I33333@J@JL@J@     @JL@JY@Js33333@J     @J     @Jfffff@J@Js33333@JY@J     @J     @JY@JL@JY@J@J33333@J33333@K@J@K333333@K@Jfffff@J33333@K&fffff@K333333@K333333@K@K@K333333@K@     @K@     @K@K@K333333@Kffffff@K@     @K&fffff@K      @K&fffff@KL@K&fffff@K&fffff@KY@Kffffff@Kffffff@KY@Ks33333@K@     @KY@Kٙ@Kfffff@K     @Kfffff@K@K@Kfffff@K@Kfffff@Kٙ@K33333@Kٙ@K33333@L@L      @L@L@L@Kfffff@L@LY@LY@L@L@L@     @LL@LL@L333333@LY@Lffffff@L     @L33333@Lfffff@L@L@L@L     @L     @L     @L@Lfffff@M@M&fffff@M@M@M@M&fffff@M      @M@ML@MY@M@M@     @Mffffff@Mffffff@M@     @M     @ML@Ms33333@Ms33333@ML@M@Mfffff@M@Ms33333@Mffffff@Mfffff@Mٙ@Ms33333@M@Mٙ@M     @Mfffff@M33333@M     @M@N      @N      @N      @N@Mfffff@N@N@N333333@NY@N@     @NY@Ns33333@N333333@NY@Nffffff@Nffffff@Nfffff@Ns33333@Ns33333@Nffffff@Nffffff@Ns33333@N333333@Nffffff@N@NL@NY@Ns33333@N@N@N@N@Nfffff@Ns33333@Nffffff@N     @N     @NY@N@N     @N@N@N@Nfffff@Nٙ@O@Nfffff@Nfffff@O&fffff@O&fffff@O&fffff@Offffff@Offffff@O@     @OL@O&fffff@O@     @Offffff@Os33333@O     @Os33333@O     @O@O     @O33333@Offfff@O@O     @Oٙ@O@O33333@P@P@O33333@Pfffff@P      @O33333@Pfffff@P      @O33333@O33333@P      @P9@P@     @P&fffff@P      @P,@PS33333@P9@PFfffff@P`     @PL@PY@Pfffff@PY@Py@PS33333@PFfffff@Ps33333@Py@Ps33333@P33333@Py@Pfffff@P33333@P@P33333@Py@Pfffff@P33333@P@P@P@P33333@P     @Pfffff@P@P     @Pfffff@P@P33333@P33333@P     @Pfffff@P@P     @P@P@P@Pfffff@P@Pfffff@P@Pfffff@P33333@P@P@Pfffff@P@P@P33333@Qfffff@P33333@Q33333@Q@Q@Qfffff@Qfffff@Q@Q,@Q33333@Qfffff@Q      @Q333333@Q,@Q,@Q      @Q33333@Q33333@Q      @QY@Q`     @QY@QL@Q9@Q&fffff@QL@Q9@QS33333@QS33333@Qffffff@QY@Qffffff@Qfffff@Q33333@Q@Q33333@Q     @Qfffff@Q33333@Q@Q@Q@Q33333@Qfffff@Qٙ@Q33333@Q33333@R@R33333@R@R@R@R@R@R      @R@R&fffff@R33333@R33333@Rfffff@Q@R      @R@     @RFfffff@RS33333@RL@R@     @R333333@RFfffff@R@     @R9@RL@R333333@R,@RL@Rs33333@Ry@R@R33333@R     @Rfffff@R33333@R     @Ry@Rfffff@R@Ry@Rfffff@Rfffff@R     @R33333@R33333@R@Rfffff@R33333@R@R@R33333@R     @R     @Rfffff@R33333@Rfffff@R@R33333@R@R@R@R     @R33333@R33333@R     @R     @R33333@R@R33333@Rfffff@Rfffff@S      @R33333@Rfffff@R@S@S@S@S@Sfffff@S33333@S,@S      @S      @Sfffff@S@S@S      @S33333@S,@S&fffff@S@S@     @S333333@S      @S@S@     @SFfffff@S@     @SFfffff@S`     @SFfffff@SL@SS33333@S@     @S9@SS33333@Sy@Sffffff@Sffffff@Sl@Ss33333@S`     @Sfffff@Sfffff@S     @Sfffff@Sy@Ss33333@Sfffff@S33333@Sfffff@S@S@Sy@S@S     @S@S@S@S@S33333@S@S     @S33333@S     @S     @Sfffff@S33333@S@Sfffff@Sٙ@S@S@Sfffff@S33333@Tfffff@S33333@S33333@Sfffff@S33333@T      @Sٙ@S     @Sfffff@S33333@S33333@S33333@T33333@T@T,@T      @T      @T      @T33333@T      @T9@TY@TY@TS33333@T`     @T`     @TY@Tl@Ts33333@T`     @TY@T`     @Tfffff@T33333@T33333@Tfffff@Tfffff@Tfffff@T@Tfffff@T33333@Tfffff@T@Ufffff@U@Ufffff@U@U33333@Ufffff@U&fffff@U33333@U333333@U@U333333@U,@U,@U      @U,@U333333@U333333@UFfffff@U333333@U,@U,@U@     @U@     @UFfffff@UFfffff@U@     @U@     @US33333@UY@U`     @U@     @U`     @Uy@Us33333@U`     @Us33333@Ufffff@Ufffff@U     @Ul@U     @U@U33333@U33333@Ufffff@Ufffff@U@Ufffff@Ufffff@U@U@U@U33333@U33333@U@U     @Ufffff@U33333@Ufffff@Ufffff@Uٙ@U@U     @U@U@Uٙ@U@U     @Ufffff@U@Uٙ@Uٙ@U33333@U@V      @Ufffff@U@U@U33333@Ufffff@U@U@U@Uٙ@Uٙ@U     @Ufffff@V      @V,@V&fffff@Vfffff@V33333@V33333@Vl@V     @VFfffff@V@     @V`     @VS33333@V&fffff@V33333@V,@V,@V@     @VS33333@VS33333@VFfffff@V     @Vy@V     @V     @Vfffff@V@V     @V33333@V@V@Vl@Vffffff@V@V33333@V     @Vfffff@V@Vfffff@V     @V33333@V@Vfffff@V33333@V@V@V     @Vٙ@V@V@V33333@V     @V@W      @Wfffff@W@V33333@V@V33333@W@W&fffff@W,@W      @W,@W33333@V@V@W,@WL@W9@W      @W,@W@W9@WS33333@W@     @W,@W333333@W9@WS33333@WY@W`     @W`     @WL@Wl@W`     @WY@Wffffff@Wy@W     @Wfffff@W     @W@W33333@W@W     @W33333@W@W     @W33333@Wٙ@W     @W@Wfffff@W@X      @W     @W33333@Wٙ@W@Xfffff@Xfffff@W     @W     @W     @X@X33333@X@X      @X@X33333@X@XFfffff@X,@X33333@X      @X,@XFfffff@X@X33333@X,@X@     @X`     @Xy@XS33333@XY@X`     @Xl@Xl@X     @Xs33333@Xffffff@Xs33333@X@Xffffff@X     @Xs33333@Xffffff@X`     @XS33333@X`     @Xl@Xffffff@Xl@Xs33333@X`     @XS33333@XS33333@XY@XL@Xffffff@X     @Xl@X`     @Xffffff@Xl@Xffffff@Xy@X     @Xfffff@X33333@Xfffff@Xfffff@Xs33333@Xfffff@X33333@Xfffff@Xfffff@X     @Xfffff@X     @Xfffff@X@Xfffff@X     @X33333@X     @X     @Xٙ@Xfffff@X33333@X     @Xٙ@X33333@X@X@X@Xfffff@Xfffff@X33333@Y33333@Y33333@Y      @X@Xٙ@Y      @Yfffff@Y33333@Y9@Y,@Y,@Y,@Y&fffff@Y9@Y@     @Y@     @Y@     @Y,@YY@Yffffff@YL@Ys33333@Yl@Y@     @YY@Y`     @YL@YS33333@Yl@Y`     @Y@YY@Y`     @Y     @Yy@Yl@Ys33333@Y@Yy@Yffffff@Yy@Ys33333@Yl@Yy@Yfffff@Yy@Yffffff@Y@Y@Y     @Y     @Yy@Y     @Y33333@Y33333@Y     @Y     @Yfffff@Y     @Y     @Yy@Y33333@Y33333@Y     @Y     @Y@Y@Y33333@Yy@Y@Y33333@Yfffff@Yfffff@Yfffff@Y@Y@Yfffff@Y     @Y@Y@Y@Y@Y@Y@Y@Y33333@Y     @Y     @Yٙ@Y33333@Y     @Y@Zfffff@Z      @Y@Zfffff@Z@Zfffff@Y@Z&fffff@Z      @Z@Z      @Yfffff@Z&fffff@Z@Z333333@Z33333@Yٙ@Y33333@Z      @Y33333@Z33333@Z,@Z,@Z      @Z&fffff@ZY@ZS33333@Z&fffff@Z      @ZS33333@ZS33333@ZL@Z@     @ZFfffff@ZY@Z@     @Zl@Zffffff@Z333333@Z&fffff@ZFfffff@ZS33333@ZS33333@Z`     @Z`     @Zs33333@Z@     @ZL@Zfffff@Zl@Z`     @ZS33333@Z`     @Zl@Z     @Zy@Zffffff@Zffffff@Zy@Zy@Zfffff@Z@Zfffff@Z     @Z     @Zs33333@Z     @Zfffff@Zfffff@Z     @Zfffff@Z@Zfffff@Z     @Z@Zfffff@Zfffff@Zfffff@Z@Z33333@Z33333@Z     @Z@Zfffff@Z@Z33333@Z@Z     @Zfffff@Z33333@Z@Zfffff@Zٙ@Z@Z     @Z     @Zٙ@Z@Z@Z@Z     @Z@[      @Z33333@Z33333@Z33333@Z     @Zfffff@Z33333@[fffff@Zfffff@Z33333@Z@[fffff@Zfffff@[      @Z33333@[@[@[fffff@[      @Z33333@[@[&fffff@[fffff@Z@[33333@[,@[@Z@[@Z@[@[&fffff@[@[@[&fffff@[@[@[@[&fffff@[9@[33333@Z@Z33333@[fffff@[33333@[@[&fffff@[,@[L@[L@[@     @[@[&fffff@[`     @[S33333@[&fffff@[&fffff@[@     @[9@Z33333@[      @[9@[Y@[`     @[      @[@[`     @[L@[Ffffff@[S33333@[ffffff@[l@[l@[333333@[l@[`     @[L@[`     @[`     @[l@[ffffff@[L@[ffffff@[Y@[l@[`     @[ffffff@[`     @[l@[ffffff@[Y@[y@[@[`     @[@[`     @[fffff@[@[     @[@[@[ffffff@[s33333@[fffff@[33333@[fffff@[@[l@[     @[@[fffff@[fffff@[33333@[     @[     @[@[@[fffff@[33333@[     @[@[@[@[33333@[@[fffff@[33333@[     @[33333@[@[@[@[@\      @[fffff@[ٙ@[ٙ@[     @[@[@[@[@[fffff@[fffff@[     @[@[fffff@\      @[@\      @[@[33333@\33333@[@[33333@\      @\      @[@\@\@\      @[@[33333@\@\33333@[33333@\@\      @\fffff@[fffff@[@\fffff@[33333@\@\33333@[@[33333@\      @\fffff@[@[@\      @\fffff@\      @\,@\33333@\@\@\@\      @\,@\@\,@\333333@\,@\&fffff@\,@\333333@\      @\333333@\Y@\      @\      @\333333@\&fffff@\      @\      @\L@\@\9@\9@\,@\9@\@     @\9@\@     @\@     @\9@\      @\9@\Ffffff@\9@\@\      @\Ffffff@\@     @\9@\L@\@     @\`     @\L@\l@\333333@\@     @\L@\Y@\@     @\@     @\,@\@     @\L@\Ffffff@\l@\l@\s33333@\333333@\L@\Y@\L@\y@\Y@\`     @\ffffff@\s33333@\l@\     @\l@\Ffffff@\     @\s33333@\l@\l@\Ffffff@\Y@\y@\y@\     @\s33333@\y@\fffff@\s33333@\9@\l@\@\fffff@\fffff@\y@\     @\@\@\l@\@\     @\     @\@\     @\ffffff@\@\33333@\fffff@\`     @\@\@\     @\fffff@\     @\ٙ@\@\@\fffff@\fffff@\@\@\fffff@\     @\     @\fffff@\@\@\ٙ@\@\     @\33333@\fffff@\@\33333@\@\@\@\     @\fffff@\33333@\@\fffff@\@\     @\33333@\     @\ٙ@\ٙ@\@\33333@\@]      @\     @\33333@\     @\@\     @\fffff@\@\33333@]      @\@\@\fffff@\fffff@\ٙ@\33333@\@\fffff@]fffff@\@\ٙ@\ٙ@\@\@\fffff@\33333@\     @\@\@\fffff@\fffff@\@\33333@\     @\33333@\@\ٙ@]fffff@\@\@]      @\fffff@\fffff@]@\     @\     @]      @\     @\fffff@]      @\     @\33333@\@\@\     @\     @\@\@\ٙ@]fffff@]fffff@]      @]33333@\     @]@]@\@]33333@]33333@\33333@]@\@\@]@]      @]9@]9@\33333@]      @]      @]333333@]@]333333@]9@]Ffffff@]@     @],@]Ffffff@]L@],@\@\@]33333@]@]L@]      @]33333@]33333@]L@]&fffff@]L@]333333@]&fffff@]@]L@]@]@]33333@]@]      @]      @]9@]      @]@]33333@]@],@]@     @],@],@]@     @]&fffff@]333333@]&fffff@],@]9@]9@],@]L@]Ffffff@]9@]     @]`     @]fffff@\33333@]@     @]@     @]9@]333333@]      @]9@]L@]ffffff@]L@]Ffffff@]`     @]@     @]@     @]S33333@]9@]@     @]`     @]`     @]ffffff@]      @]`     @]l@]S33333@]l@]`     @]L@]S33333@]l@]S33333@]S33333@]Y@],@]l@]@     @]S33333@]l@]     @]33333@]@     @]@]y@]`     @]ffffff@]l@]L@]S33333@]`     @]9@]L@],@]L@]Y@]S33333@]L@]`     @]L@]Ffffff@]Y@]L@]Y@],@]L@]`     @]Ffffff@]l@]l@]`     @]Y@]Ffffff@]ffffff@]l@]`     @]@]l@]@     @]`     @]Y@]      @]@     @]ffffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ?ە$/?C$?Q?+?ݑhr ?E?lC?hr Ĝ?^5?|?E?j~"?hr!?$/?1&y?5?|h?-V?zG?O;dZ?
=p?      ?ěS??hr ?^5?|?lC?^5?|?"`?"`A?zG?1&x?1&x?A7Kƨ?$/?$/?^5?|? ě?"`A?I^5?Q?+I?zG?nP?ěS?vȴ9?1&?tj?+?-V?x?`A7?
=p
?=p
=?x?Q?5?|h?nO;?lC?홙?+J?hr!?/v?O;dZ?nP?Z1'?9XbN?j~"?E?hr ?\(?A7Kƨ?|hr?tj~?+?1&?^5?|?E?I^5?}?C%?j~"?j~"?zG?O;dZ?Ƨ-?O;dZ?+?nP?Ƨ-?+?KƧ?+?nO?+?旍O;d?"`B?E?hr Ĝ? ěT?^5?|?zG{?m?ى7KƧ?j~"?"`A?щ7KƧ?1&?У
=p?Vu?lC?ffffff?Ł$/?Õ$/?nO;?      ?vȴ9X?-V?j~"?^5?|?+I?+I??|hs?9XbM?333333?-V?&x?`A7L?lD?hr Ĝ?`A7L?vȴ9X?
=p?lD?
=p? ěT?`A7L?bM?vȴ9X?
=p?vȴ9X?Q?;dZ?Q? ěT? ěT?vȴ9X? ěT?Q?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?;dZ?;dZ?;dZ?;dZ?Q?bM?vȴ9X?;dZ?;dZ?;dZ?Q?Q?;dZ?5?|h?5?|h?vȴ9X?;dZ? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?
=p?
=p?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?bM?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?Q?Q?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?bM?vȴ9X?bM?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X? ěT?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?;dZ?vȴ9X? ěT?;dZ?vȴ9X? ěT?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X? ěT? ěT? ěT?vȴ9X?;dZ?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X?;dZ?vȴ9X? ěT?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X? ěT? ěT? ěT?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ? ěT? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?bM?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X? ěT?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X? ěT?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?vȴ9X?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?Q?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?5?|h?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?vȴ9X?;dZ?Q?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?Q?Q?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?Q?Q?Q?;dZ?Q?Q?;dZ?Q?Q?Q?;dZ?Q?Q?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?;dZ?;dZ?Q?Q?Q?Q?5?|h?5?|h?Q?Q?Q?-V?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?5?|h?5?|h?5?|h?Q?Q?5?|h?;dZ?Q?;dZ?Q?Q?Q?5?|h?5?|h?Q?;dZ?Q?Q?5?|h?Q?Q?Q?Q?Q?;dZ?Q?Q?5?|h?5?|h?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?5?|h?Q?Q?;dZ?Q?Q?Q?vȴ9X?5?|h?Q?Q?Q?Q?Q?Q?Q?;dZ?5?|h?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?5?|h?-V?5?|h?5?|h?5?|h?Q?Q?5?|h?5?|h?Q?Q?Q?Q?/v?5?|h?5?|h?Q?Q?Q?Q?5?|h?Q?5?|h?5?|h?5?|h?Q?Q?Q?Q?5?|h?Q?5?|h?5?|h?Q?-V?5?|h?Q?Q?5?|h?5?|h?5?|h?Q?5?|h?Q?5?|h?5?|h?Q?Q?Q?5?|h?5?|h?5?|h?5?|h?-V?5?|h?-V?-V?5?|h?5?|h?5?|h?Q?5?|h?-V?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?Q?Q?5?|h?Q?;dZ?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?/v?/v?/v?/v?-V?5?|h?-V?5?|h?-V?/v?-V?Q? ěT?-V?1&y?1&y?/v?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?-V?Q?;dZ?Q?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?-V?/v?-V?-V?/v?/v?-V?5?|h?5?|h?5?|h?-V?-V?-V?5?|h?/v?-V?/v?5?|h?-V?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?-V?5?|h?5?|h?5?|h?/v?-V?-V?5?|h?5?|h?-V?5?|h?-V?-V?-V?-V?5?|h?5?|h?5?|h?-V?5?|h?-V?/v?1&y?-V?Q?5?|h?-V?-V?5?|h?/v?/v?5?|h?/v?/v?-V?1&y?1&y?5?|h?-V?/v?-V?-V?/v?1&y?-V?-V?1&y?/v?5?|h?-V?-V?/v?5?|h?/v?/v?-V?/v?/v?-V?-V?5?|h?-V?/v?1&y?5?|h?1&y?-V?1&y?-V?/v?/v?/v?/v?/v?/v?/v?1&y?/v?/v?/v?1&y?-V?5?|h?/v?1&y?1&y?1&y?/v?/v?-V?/v?5?|h?/v?-V?-V?1&y?/v?/v?/v?1&y?-V?5?|h?-V?1&y?/v?/v?/v?1&y?1&y?1&y?/v?/v?-V?/v?/v?1&y?/v?5?|h?/v?1&y?/v?/v?-V?/v?1&y?1&y?/v?/v?/v?/v?/v?1&y?/v?1&y?1&y?1&y?-V?-V?1&y?(\)?(\)?1&y?1&y?/v?1&y?1&y?1&y?1&y?1&y?/v?1&y?/v?/v?/v?/v?/v?1&y?/v?/v?/v?1&y?-V?/v?-V?-V?1&y?1&y?1&y?1&y?/v?1&y?/v?(\)?1&y?/v?1&y?1&y?1&y?(\)?/v?(\)?/v?1&y?1&y?1&y?1&y?/v?1&y?1&y?1&y?1&y?1&y?/v?1&y?/v?1&y?/v?(\)?1&y?(\)?(\)?/v?1&y?/v?/v?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?(\)?(\)?1&y?1&y?/v?1&y?1&y?/v?1&y?/v?1&y?1&y?1&y?1&y?/v?/v?(\)?(\)?1&y?1&y?/v?1&y?1&y?1&y?1&y?/v?1&y?1&y?/v?1&y?1&y?1&y?1&y?1&y?(\)?1&y?1&y?1&y?1&y?1&y?1&y?1&y?/v?1&y?1&y?1&y?1&y?1&y?/v?(\)?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?/v?1&y?1&y?1&y?1&y?(\)?1&y?(\)?1&y?1&y?1&y?(\)?1&y?(\)?1&y?1&y?1&y?(\)?(\)?1&y?(\)?1&y?(\)?(\)?(\)?(\)?1&y?1&y?1&y?1&y?1&y?(\)?1&y?1&y?1&y?(\)?1&y?1&y?1&y?(\)?(\)?1&y?1&y?(\)?(\)?1&y?1&y?1&y?1&y?1&y?(\)?(\)?1&y?(\)?1&y?1&y?1&y?1&y?(\)?1&y?(\)?1&y?(\)?S?(\)?1&y?(\)?(\)?(\)?1&y?1&y?1&y?/v?(\)?(\)?(\)?(\)?(\)?1&y?1&y?1&y?(\)?(\)?(\)?1&y?(\)?1&y?(\)?1&y?1&y?(\)?(\)?1&y?1&y?1&y?(\)?(\)?(\)?1&y?(\)?(\)?1&y?(\)?(\)?(\)?(\)?(\)?(\)?1&y?(\)?1&y?(\)?S?1&y?(\)?(\)?(\)?(\)?(\)?(\)?1&y?1&y?(\)?(\)?(\)?(\)?(\)?(\)?(\)?1&y?1&y?(\)?(\)?(\)?1&y?1&y?S?(\)?(\)?1&y?(\)?S?(\)?(\)?(\)?(\)?(\)?(\)?S?(\)?(\)?(\)?1&y?(\)?(\)?(\)?(\)?(\)?(\)?(\)?1&y?(\)?(\)?(\)?(\)?(\)?(\)?1&y?(\)?(\)?(\)?(\)?S?(\)?(\)?(\)?1&y?(\)?S?S?1&y?(\)?S?(\)?(\)?1&y?S?(\)?1&y?(\)?S?(\)?(\)?(\)?(\)?(\)?(\)?S?(\)?(\)?S?(\)?S?S?S?(\)?(\)?(\)?(\)?(\)?(\)?(\)?(\)?(\)?1&y?(\)?S?S?S?S?1&y?(\)?(\)?1&y?1&y?1&y?(\)?S?(\)?(\)?(\)?S?S?S?(\)?(\)?(\)?S?(\)?(\)?(\)?S?(\)?S?(\)?S?S?S?S?S?(\)?S?S?S?S?S?(\)?S?(\)?(\)?(\)?(\)?(\)?S?(\)?S?S?S?(\)?S?(\)?(\)?S?(\)?S?(\)?(\)?(\)?(\)?(\)?(\)?(\)?(\)?S?(\)?(\)?1&y?S?(\)?(\)?(\)?(\)?S?S?(\)?S?S?S?S?"`A?S?S?S?"`A?(\)?(\)?(\)?(\)?(\)?S?S?S?(\)?(\)?(\)?1&y?(\)?S?S?S?(\)?(\)?S?S?S?S?S?S?(\)?(\)?S?S?S?S?S?S?S?S?(\)?S?(\)?S?S?(\)?S?S?S?S?"`A?S?S?S?S?S?S?S?"`A?S?S?(\)?(\)?S?S?S?S?(\)?(\)?"`A?S?S?S?S?S?S?(\)?S?S?S?S?S?S?S?(\)?(\)?S?S?S?S?(\)?S?(\)?S?S?S?S?S?S?(\)?S?S?"`A?S?S?S?S?S?S?S?S?S?vȴ9?"`A?"`A?S?S?"`A?S?S?S?S?S?S?S?S?"`A?S?"`A?S?S?S?S?S?S?S?S?S?S?"`A?"`A?S?"`A?S?S?"`A?S?S?"`A?"`A?S?S?S?(\)?S?S?S?S?S?S?S?S?S?S?S?"`A?S?S?S?S?S?"`A?S?"`A?"`A?"`A?(\)?"`A?S?S?S?S?"`A?S?S?S?"`A?"`A?S?S?S?S?S?1&?vȴ9?"`A?S?"`A?S?S?S?S?"`A?S?(\)?S?"`A?"`A?S?(\)?S?S?S?S?S?"`A?"`A?"`A?"`A?S?S?"`A?"`A?"`A?"`A?"`A?"`A?"`A?S?S?"`A?"`A?"`A?"`A?"`A?vȴ9?1&?"`A?"`A?"`A?S?"`A?S?S?S?"`A?"`A?"`A?"`A?S?"`A?"`A?S?S?"`A?1&?1&?vȴ9?"`A?S?S?S?"`A?S?"`A?vȴ9?"`A?S?1&?"`A?vȴ9?"`A?"`A?"`A?"`A?S?"`A?vȴ9?"`A?vȴ9?"`A?"`A?"`A?S?"`A?"`A?"`A?"`A?"`A?"`A?"`A?"`A?vȴ9?S?S?S?"`A?"`A?"`A?vȴ9?vȴ9?"`A?"`A?"`A?"`A?"`A?vȴ9?1&?"`A?vȴ9?vȴ9?vȴ9?"`A?"`A?vȴ9?vȴ9?"`A?1&?vȴ9?vȴ9?"`A?"`A?"`A?vȴ9?vȴ9?"`A?vȴ9?"`A?vȴ9?"`A?1&?"`A?"`A?S?"`A?vȴ9?vȴ9?"`A?vȴ9?"`A?"`A?"`A?vȴ9?vȴ9?1&?"`A?"`A?vȴ9?vȴ9?"`A?"`A?vȴ9?vȴ9?"`A?vȴ9?vȴ9?1&?1&?"`A?"`A?vȴ9?"`A?vȴ9?"`A?"`A?"`A?"`A?"`A?"`A?"`A?vȴ9?1&?vȴ9?vȴ9?vȴ9?vȴ9?"`A?"`A?S?1&?vȴ9?vȴ9?vȴ9?vȴ9?vȴ9?vȴ9?vȴ9?vȴ9?S?"`A?S?S?S?"`A?"`A?vȴ9?"`A?vȴ9?S?1&?"`A?S?vȴ9?vȴ9?vȴ9?S?vȴ9?"`A?vȴ9?vȴ9?1&?"`A?"`A?"`A?1&?1&?1&?"`A?"`A?"`A?"`A?"`A?1&?vȴ9?"`A?"`A?1&?vȴ9?"`A?vȴ9?"`A?1&?1&?1&?vȴ9?1&?vȴ9?"`A?"`A?vȴ9?vȴ9?"`A?S?"`A?"`A?1&?"`A?1&?"`A?vȴ9?1&?vȴ9?"`A?"`A?1&?vȴ9?1&?vȴ9?vȴ9?1&?"`A?"`A?vȴ9?vȴ9?vȴ9??1&?S?vȴ9?vȴ9?"`A?1&?vȴ9?"`A?vȴ9?vȴ9?1&?"`A?"`A?"`A?vȴ9?1&?1&?"`A?1&?1&?"`A?"`A?"`A?vȴ9?1&?1&?1&?1&?1&?vȴ9?"`A?vȴ9?1&?1&?1&?1&?1&?1&?1&?vȴ9?1&?1&?vȴ9?"`A?1&?vȴ9?"`A?1&?vȴ9?vȴ9?"`A?1&?1&?1&?1&?vȴ9?1&?"`A?vȴ9?"`A?1&??1&?1&?1&?vȴ9?1&?1&?vȴ9?"`A?1&?vȴ9?vȴ9?vȴ9?vȴ9?1&?1&?1&?1&??vȴ9?vȴ9?1&?1&?"`A?1&?"`A??vȴ9?1&??1&?1&???1&?"`A?1&?1&?1&?1&?vȴ9?1&?1&?1&?1&?vȴ9?vȴ9?vȴ9?1&?"`A?vȴ9?vȴ9?1&?1&?1&?1&?1&?1&?vȴ9?"`A?vȴ9?1&?vȴ9?1&?1&??1&?1&?1&?1&?1&?1&??"`A?1&?vȴ9?"`A?1&?1&?1&?1&??1&?1&?1&?"`A?vȴ9?"`A?1&?1&?1&?1&?1&?1&??1&?1&?1&?"`A?1&?vȴ9?1&?vȴ9??1&?1&?1&?"`A?1&?1&?1&?1&?"`A?1&???"`A?"`A?vȴ9?1&??vȴ9?1&?1&?1&?1&?1&?vȴ9?1&?1&??vȴ9?vȴ9?1&?1&?vȴ9?vȴ9?1&?1&?1&??1&?1&?vȴ9?1&?1&?1&?1&?1&??1&?vȴ9?"`A???1&?1&?1&?1&?1&?1&????"`A?1&??vȴ9?"`A?"`A?vȴ9?1&??1&??1&?1&?1&?1&?vȴ9?1&?vȴ9?1&?1&?1&?1&?1&?1&?1&?1&?1&?vȴ9????1&??1&?1&?"`A?"`A?vȴ9?1&??1&??1&?vȴ9?vȴ9??vȴ9?1&?1&?1&??1&?1&?1&?1&?"`A?1&?1&?1&??1&??1&?1&??vȴ9?"`A?vȴ9?1&?1&?1&?1&?"`A?1&??1&?1&?1&?"`A?1&??1&?1&?"`A??1&?1&?1&?1&??1&???1&?1&?vȴ9?1&?1&?1&?1&?1&?1&?1&??1&?vȴ9??1&?1&?1&?vȴ9?"`A??1&?vȴ9?1&?1&?vȴ9?1&?vȴ9?1&?1&?vȴ9?1&?1&?1&?1&????1&?1&?vȴ9?1&?1&?1&???vȴ9?1&?1&?1&??1&??1&?1&??1&?1&???vȴ9?1&?1&?1&?1&??1&??1&?1&?1&?1&?1&???1&????1&?1&?1&?1&?vȴ9?1&?vȴ9?vȴ9?1&?vȴ9?1&??1&?vȴ9?vȴ9?vȴ9???1&?1&?1&?1&?1&?1&?+J??1&?1&?vȴ9?1&???1&?1&???1&?1&??1&???1&??1&??1&?1&?1&?+J?1&?1&?1&?1&??1&?1&?1&?1&?1&?1&??1&?1&?1&?1&?1&?vȴ9?1&?1&??1&???????1&?1&??+J?vȴ9?1&????vȴ9?1&?1&?1&?1&??1&?vȴ9?vȴ9?1&?1&??1&?????1&?1&?1&?1&?1&?vȴ9???1&?vȴ9?1&??vȴ9?1&???1&?1&?1&?1&?1&?vȴ9??1&??1&?1&?1&?1&?1&???1&???1&??1&?1&?1&?1&???????1&?1&?1&??1&?1&?1&?1&?1&?vȴ9??1&???1&?1&?1&?1&?1&?1&?????????1&?1&?1&??+J??1&?1&?1&?1&?vȴ9?1&??????1&?1&?1&??1&???1&???+J??+J????1&?1&?1&??1&?1&?1&?1&?1&???1&?1&?????1&?1&??1&???1&?1&?1&???1&?1&?1&??1&?1&?1&?1&?1&?1&???1&?1&?????+J??+J????1&?vȴ9???1&?1&??1&??????+J?1&?1&??+J?+J?1&?1&???1&?1&?1&??1&?1&???+J                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	P16                                     2                                       )eBE!3