CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20170205   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P4     CAST_NUMBER       7      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:35.174498Z    ORIGINAL_HEADER      6CTD,20250210CCHSIOWB
#Removed 'CTDFLUOR_TSG' as it's filled with -999
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2017-06-29. CTD data from cruise 18DD20170205, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20170205. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2017-001/index.php. 
#
# The information in this file for the cruise 2017-001 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-0036.ctd
#
# Start of originator file comment header
#
#*2017/06/29 15:26:50.02
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2017/02/10 06:17:38.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 198
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : CE9F1F72
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            0.3            202.1
#       2 Temperature:CTD               deg_C_(ITS90)   5.6248         6.8697
#       3 Salinity:CTD                  PSS-78          32.78          33.8432
#       4 Sigma-t:CTD                   kg/m^3          25.7461        26.7106
#       5 Oxygen:Dissolved:CTD:Volume   ml/l            3.4            6.87
#       6 Oxygen:Dissolved:CTD:Mass     µmol/kg         147.7          299
#       7 Fluorescence:CTD:Seapoint     mg/m^3          0.66E-01       1.162
#       8 PAR:CTD                       µE/m^2/sec      0              0.3
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        7  F       ' '     2
#       6  -99   ' '        6  F       ' '     1
#       7  -99   ' '        8  F       ' '     3
#       8  -99   ' '        7  F       ' '     1
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2017-001
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P21
#    EVENT NUMBER        : 36
#    LATITUDE            :  49  38.00000 N  ! (deg min)
#    LONGITUDE           : 139  39.97000 W  ! (deg min)
#    WATER DEPTH         : 3961
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    The descent rate of the CTD was very noisy with some complete reversals
#	of direction.
#    CTDEDIT was used to remove many records corrupted by shed wakes;
#	salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Fluorescence and PAR data are nominal and unedited except that some records were
#	removed in editing temperature and salinity and a large spike in
#	fluorescence was removed from file 0032.
#
#    The Transmissivity channel was removed because of frequent shifts in values during
#	casts and large variations between values during repeat casts.
#	The data are available, by request, from the chief scientist.
#
#    NOTE: While the Fluorescence:CTD data are expressed in concentration units, they
#	do not always compare well to extracted chlorophyll samples, particularly for
#	casts far from shore. It is recommended that users check extracted chlorophyll
#	values where available.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in Sea-Bird
#	Application Note #64-2, June 2012 revision (Sea-Bird_64-2_Jun2012.pdf), except 
#	that a small offset in the fit was allowed.
#
#    The Dissolved Oxygen sensor used in files 0001, 0002 and 0016 malfunctioned so the 
#	Oxygen:Dissolved:CTD channels were removed from those files.
#
#    The Oxygen:Dissolved:CTD sensor has a fairly long response time so data accuracy 
#	is not as high when it is in motion as it is during stops for bottles. This will be
#	especially true when vertical dissolved oxygen gradients are large. To get an estimate
#	of the accuracy of the Oxygen:Dissolved:CTD data during downcasts (after recalibration)
#	a rough comparison was made between downcast Oxygen:Dissolved:CTD data and upcast 
#	titrated samples. Some of the difference will be due to problems with flushing of 
#	Niskin bottles and/or analysis errors, so the following statement likely underestimates 
#	Oxygen:Dissolved:CTD accuracy.
#
#    Downcast (CTD files) Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.25 ml/l from 0 to 125 dbar.
#	±0.2 ml/l from 125 to 400 dbar.
#	±0.1 ml/l from 400 to 600 dbar.
#	±0.05 ml/l from 600 to 1500 dbar.
#	Low by up to 0.08 ml/l below 1500 dbar.
#
#    For details on the processing see document: 2017-001-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5--- --6-- ---7--- --8---
#!Pressu Temperat Salinity Sigma-t: Oxygen Oxyge Fluores PAR:  
#!re:CTD ure:CTD  :CTD     CTD      :Disso n:Dis cence:  CTD   
#!                                  lved:  solve CTD:          
#!                                  CTD:   d:CTD Seapoin       
#!                                  Volume :Mass t             
#!------ -------- -------- -------- ------ ----- ------- ------
#*END OF HEADER
     WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @X        data_max      @X        C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     (  2   pressure                	long_name         pressure   positive      down   units         decibar    data_min      ?         data_max      @        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      (  [   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      
(  $   temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      @   data_max      @#r{m   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       (  L   temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      
(     salinity                	long_name         salinity   units         PSS-78     data_min      @@AA [   data_max      @A=U=   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      (     salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      
(     oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @$         data_max      @qfffff   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        (     	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      
( |   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?5?|h   data_max      ?Q   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      ( &   CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      
( OD   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min                 data_max      @\l   C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       ( Yl   PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d      
(    	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min               data_max               C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     ( 4   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d      
(    station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         (    cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( $   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      *M   data_max      *M   C_format      %10d       L   latitude               	long_name         latitude   units         	degrees_N      data_min      @HSC%   data_max      @HSC%   C_format      %9.4f          P   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      _%1   data_max      _%1   C_format      %9.4f          T   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d        X   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min        =   data_max        =   C_format      %4d        \@X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     @X     ?      @       @333333@      @      @      @333333@"ffffff@$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @Bfffff@D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @N@O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @Ufffff@U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @dy@d@d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g@g33333@h      @h      @h@     @h`     @h     @h     @h     @h     @h@i      @i@     @i`     @i     @i     @i     @i     @j      @j#33333@j<@j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @nVfffff@n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p\@pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @qfffff@qfffff@qfffff@q     @q     @q     @q     @r      @r     @r      @r0     @r<@rQ@r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t񙙙@u      @ufffff@u      @u0     @u@     @uP     @u`     @up     @u     @u     @u@u33333@u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @va@vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w~fffff@w33333@w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xNfffff@xt@x     @x     @x     @x     @x     @x     @x     @x񙙙@x@y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @zљ@zᙙ@z     @{      @{     @{      @{0     @{@     @{P     @{`     @{q@{     @{fffff@{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|Q@|`     @|p     @|     @|     @|     @|     @|     @|     @|fffff@|񙙙@}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~~fffff@~fffff@~     @~@~љ@~     @~     @      @     @      @0     @@     @P     @`     @i@fffff@fffff@     @     @     @     @     @     @      @fffff@     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h@p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @ᙙ@     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @M@X     @`     @h     @p     @x     @     @     @     @     @     @     @@@     @     @     @     @33333@fffff@     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @     @     @33333@	@     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @33333@     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @ՙ@33333@     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @fffff@@     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @I@P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@fffff@      @     @     @     @      @(     @0     @8     @@     @H     @L     @Y@`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @%@2fffff@8     @@     @H     @P     @X     @`     @h     @p     @x     @~fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @fffff@fffff@     @     @     @     @     @     @     @fffff@fffff@     @     @     @      @     @     @     @      @(     @0     @8     @@     @G33333@Rfffff@X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@ @     @     @     @      @(     @0     @4@C33333@H     @P     @X     @`     @h     @p     @x     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @g@k@p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @33333@fffff@     @     @      @$     @(     @,     @0     @4     @933333@<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @      @     @     @     @     @     @     @@      @$     @(     @,     @0     @4     @8     @;33333@?@D     @H     @L     @P     @T     @X     @\     @`     @d     @ffffff@lfffff@p     @t     @x     @|     @     @     @     @     @     @@@     @     @     @     @@fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @@$fffff@(     @,     @0     @4     @8     @<     @A@D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @33333@33333@     @     @     @     @     @     @     @33333@@     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @33333@     @     @     @     @      @$     @(     @,     @0     @4     @8     @@@D     @H     @K33333@Q@T     @Vfffff@e33333@g@lfffff@p     @t     @x     @~     @     @     @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         @!>@!cA @!64@!,<@!W>6z@!^5?|@!Q_@!wkP@!?@!?@!u"@!u"@!j~#@!(\@!?@!J#9@!"`B@!u%@!/V@!s@!,<@!e+a@!+@!F@!tj@!b}@!rGE8@!rGE8@!b}@!+@!	k~@!PH@!b}@!6C@!qu!@!6@!J#9@!~$@!G{@!c	@!s@!JE@!Q@!+@!_F@!73@!iDg8@!C\@!5Xy>@!M:@!(@!5Xy>@!N;5@!a|Q@!.H@!	k~@!1&y@"C@"q@"=H˒@"G)^@"D7@"WKƧ@"oo @"u!@"
qu@#Ʌoi@#Eu@#\#x@#dS@#r{m@#i ѷ@#j͞&@#+P{@#\N@":)z@"p:~@"XbM@"[W?@"S&@"tj@"w3@"^iB@"G@@"8}H@""@4@"`d@"Vu@" ěT@!k~(@!ۘA@!n@!
qv@!#9@!@4@!)_@!}Vl@!MjO@!-@! ě@!s@!˒:*@!o i@!hۋq@!33333@!~ߤ?@!|64@!x*0@!sݗ+k@!o@!j	 @!gfA@!\PH@!>$t@!Fs@!_@!zxl"@!I^5?@!
~"@!	'RTa@ E@ ~@ S&@ "`@ @@ @ O
M@ cA @ _o@ E@ K]c@  [7@ ҈p@ I^5@ u!@ حV@ 6z@ Q@ Ϫ͟@ X@ &x@ @ O;@ g	@ |>@ xbM@ rn@ h	ԕ+@ YD@ SMj@ N+@ J~"@ IoiD@ Iԕ*@ I7KƧ@ C{J#9@ >BZc @ 71@ /iDg8@ -C\@ ,@ 'zH@ 'E84@ '+I@ &@ %u@ "&IR@ "3@ "e+@ U=@ 3@ m@ C]@ 	^5?}@ L/{J@@k~(@ѷX@PH@s@j~#@C\@F]d@%F
L@!-w1@<64@o i@cn.3@R䎊@Kq@G#@DJM@?H˒:@<64@8Q@4SMj@..2@vȴ@H@@o hی@G{@!.I@䎊q@"h	ԕ@A@n.3@;dZ@u%F@а{@#@@bM@@v+jg@q@f@X_F@DJM@1iB@&A@>@͞@)^@F]d@a|Q@@Ϫ͟@ǮzH@Zc@\(@䎊q@	ԕ+@PH@H@gRT`e@QN;6@5Xy=@"}Vm@F]c@rGE8@sg@3@y@Y|@@
=p@U@@K]c@|쿱[@oVϫ@T`d@..2@(@(@&L/{J@_p@?@?@2X@oiDg8@A [@hr!@wkQ@ݲ-V@՛=K@ɅoiD@Y}@s@iDg8@r@@ݗ+k@@tj~@k6z@dtSM@U=K@K'/@4m8@-w1@+a@@)@'-@%@$qj@$7@"e+@}H@Xe,@&I@"@F@v@>BZc@F
L0@e+@o@o@$@䎊@a@N@m8@-@zG@I^@@fffff@@F
L0@%1@3@e+@҈p@C,@3@`A@R<6@}Vm@Gz@,=@qu!@Y@,<@,<@Q@6@Q_@y=c@b}@b}@PH@R<6@ݗ+k@|@v_ح@\(@!R<@%@p:~@@s@o hۋ@d?@`A7K@],=@P{@?@5!.@)B@!'R@@(@D*@ڹY@M:@rG@ᰉ'@e+@fA@䎊@rGE9@O;dZ@ԕ*@hۋq@r{m@dtSM@[=K^@N_o @J	 @A$/@6}Vl@_F@Xe,@@@S&@n@}H@/@:)y@yY}@OrGE9@',@~($x@!.H@+@?@ [7@|@zG@0
@%1@+j@Y@+J@[W>@gfA@_	@WO;d@W@L_@@NU@,"h	ԕ@$tT@xl"h
@@"`B@N;6@҈@S&@TɅo@6z@H˒@	k~@jf@Ov_خ@zG@v_ح@g8}@yXbM@v+jg@t3@p'RT@j~"@aR<6@O;dZ@Dg8}@8l"h	@0{@!@N@*0@@@E@qu"@74@H˒:@1@m8@䎊q@u!S@Vϫ@hr!@/@iB@L_@9Xb@@\N@$/@hۋq@}v@wkP@o@_	@6Fs@@v@쿱[@Xe@3@@A@@>B@H˒@,zxl@|@ݲ-V@u"@ۥS@Ϫ͞@nO@As@p:@"@j~@	k@t@r Ĝ@L_@~$@ߤ@vȴ@Ush@KxF]@F-@F
L/@F?@Gݗ+@FFs@D2W@@IQ@=v@=!.H@<64@;/V@:G{@:^5?|@9~($@9=b@8F@873@73@7KƧ@7Xe@4֡a@3ߤ@3g	l@3PH@1-@*d7@(@(	ԕ+@$7@U=@zG@l!-@'lC@(ۋq
@',@',@&x@(Xy=@.zG@:xl"h
@K)^	@TzG@Qu@@4m@2{m@@E@D@}H@j~@x@䎊qj@u!@Ov_خ@ܑN;@0
)@Mj@Q@/V@"`@S&@j~@g	@tSM@!-w1@Q@qu!@qu!@6@c	@
=p@S&@ [7@rᰊ@g/V@X_F@R䎊@Q@N_o @Ik~(@<64@.2X@!Gz@5?|@8YJ@m@
M;@_@
O;dZ@~($x@xF]@)^	@
=p
@	@S&@4֡b@ hۋ@Q@`A7L@߾vȴ9@u%@c	@1'@6C@Q_@څݘ@c	@՛=K@ξߤ?@(@p:@}Vl@@8}H@/@7@W>6z@@:)y@N;5@
M;@S&@}K]@zxl"h
@tD@s33333@s33333@qu!S@ov@mB@j0U2a|@g	k@eO
@b`A@`	k@`'RT`@^Ov_خ@]ce@^ ѷY@[qu!@XU@XPH@Vaf@V8YJ@VOv_@VR<6@V@WsPH@V+J@SMj@P{@O@N_o @LL_@I@I@I^5?}@Hp:@H˒:*@F@=H˒@9(@7Xe@5!R@5!R@5?@5!.@4m8@-hr!@)Dg8~@#Z@5?|@y=c@T`d@As@_o @@$/@n.@($x@lC@C\@GE85@7@PH@;dZ@Fs@Q@%2@©@xl"h
@W@H@P{@JL@ᰉ'@+a@ߤ@@*0U2@L_@7KƧ@z>B@nt@k6z@iDg8~@h@kU=@o4֡a@ql@r-V@q2W@wKƧ@xF]d@xF]d@x}H@x-
@y	k~@u!.@sߤ@s33333@rm\@p
=q@j~"@g&@dZ1@ae@_حV@\>@X_F@WsPH@V@Vt@O;dZ@LL_@H@Fs@GzH@C@?@8}H@9rGE8@"e+@kP|@@@
D@P{@e@;dZ@,<@$tS@ֻ@bM@D*@+j@ќu@ʌL_@$tS@Vl!@YJ@!.@2X@.H@+j@_F@sP@'/@]cf@YJ@@$/@{dZ@r{m@l!-w@l1&y@irGE@h@gfA@g@fA@f'@ezxl"h@dtSM@bh	ԕ@[$@VR<6@U2a|@RnO@NVu@JL/{@J#9@I@I7KƧ@Kq@Kq@JW'@Eo i@;~$@64K@4֡a@3|@2W@2s@0
=q@/iDg8@..2@-C\@)Dg8~@$/@#S&@ 	k@ [6@Ft@u"@PH@bM@*0@bM@
=p@8YJ@Ϫ͞@fA@Fs@sP@@fA@m@bM@!R<@u%F@S@Q@!.I@D@SMj@쿱[W?@ۋq
@>BZc@,<@ ѷY@т@6@ߤ?@BZc @5Xy@|@}Vl@vȴ@tj~@ߤ?@C%@&I@@M:@@y	k~@o4֡a@mhr!@kC]@h>BZc@ceO@a|Q@[q@R䎊@M@H9Xb@E8YK@Dg8}@B74@:S&@'&@=K^@@?@B@+a@Ft@|@@Ƨ@@쿱[@3@a@@zxl"h@䎊r@u%F@nO;@hr Ĝ@bC,@\?@XU@TɅoi@P*0U@E8YK@>6z@;dZ@7Xe@(Xy=@ ěT@:)y@Q@
F]d@
D@
,<@
ۋq@
څݘ@
bM@
|hs@
'RT`@
*0@
hr @
k~(@
Q@
$/@
~($x@
|PH@
yrGE8@
v!.I@
s@
rs@
o hۋ@
l"h	ԕ@
j~"@
iB@
hr Ĝ@
d7@
ae@
^@
ZY@
R<64@
M%@
J#9@
F]cf@
?|hs@
9XbM@
43@
1-@
$tSM@
@
@
YJ@
 hۋq@
 4m9@
o hی@?@@쿱[W?@@N@iB@>6z@`A7@\N@p
=@64@j~#@~@Q@}H@rG@Xe@Vϫ@V@0U2a|@0U2a|@0
@	k@	 @n.2@U2a|@JL_@6}Vl@333333@-B@+jf@+6z@+6z@*͞&@&L/{J@!ae@PH@u%@*0@@[@S@S@vȴ@u%@kP|@@zG@u@\(@
M:@u%F@JM@@$t@H˒@ڹZ@#x@xl"h
@xl"h
@ ě@@唯O
@7@Z1@	@M@|Q@ޞ@e+@*0U@y@r@U=@1@9@ߤ@@(@@~m\@|?@zC\@x-
@w1@vȴ9X@v_ح@tj~@ql@l"h	ԕ@h	ԕ+@_حV@YJE@KƧ@C$@C,zxl@H˒:*@PH@Rm@P`A7@O;dZ@K]cA@@n@>
(@5'0@3|@5'0@/O
M@&'@쿱[W@+J@*0U2@$tT@rGE9@o @\(@!R<@
O;dZ@@q@u%F@_o@K]d@1&x@#@
$tS@
m\@
lC@
1@
쿱[W?@
lC@
唯O
@
%1@
@4@

qu@
N;5@
84֡@
 [7@
p
=@
rG@
}Vl@
m\@
{J#:@
lD@
/V@

=p@
u@
$tS@
M:@
oiDg@
}!.H@
w+@
oiDg8@
l"h	ԕ@
ix@
irGE@
hۋq
@
h@
g	k@
dZ1@
a|Q@
^iB@
[$@
YJE@
H@
I^5?}@
BZc@
;/V@
64K@
43@
3g	l@
0'RT@
$/@
IQ@
S@
*0@
*0@
Fs@
ݗ+k@
tj~@
sP@
4J@
I^5?@
'/@

ڹY@

	 @
	k~(@
eO@
Fs@
$/@
n/@
?@
F]c@
 ѷX@	H˒@	xl"h
@	+@	j~@	{m@	C,z@	C,@	ٳ|@	@	A@	#w@	Q@	>B[@	?@	S@	*0@	҉@	rGE9@	ߤ?@	I^5?@	k~(@	1&x@	$/@	ѷX@	ѷX@	:S@	z@	w1@	v+jg@	uY|@	nt@	kC]@	k~($@	kC,z@	h@	ffffff@	d%1@	b@4@	^5?|@	W
=p@	H9Xb@	-U=@	&L/{J@		@	$tS@		 ѷ@	K]d@	%2@!.I@+a@M@>@H˒:@4K@-V@U=@1&@6C@O
M@@nO@rGE9@!R<@L/{@u%F@#@K]d@?@     @}E@}Vl!@{s@x-
@p
=q@l[W?@j~"@fA@b}Vm@`d8@_حV@]cA @Zc	@Vl!-@S@RT`d@QN;5@N+@Ks@B74@>ߤ?@:)y@64K@1-@/Vϫ@&IQ@"3@!o@ 'RT`@wkP@@sP@bM@҈@nP@@:S@.H@PH@Q@+a@	@6@䎊@m\@C@b@j~#@~@)@U=@e+a@u@C%@}H˒@{m]@uY|@p
=q@h@`
qu@[$@W
=p@Q_p@M%@LcA \@KƧ@GzH@DS@BZc@=b@8)@8}H@6}Vl@3g	l@/Vϫ@(@u@_o@Ov_@)^@'/W@C%@
=p
@	 ѷ@	'RTa@1&x@@?@@#x@!-w@حV@ٳ|@a@O@cA \@#9@@W'@C-@ߤ@RT`e@-w1@	@'RT`@.H@!-w1@vȴ@                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @@AA [@@ADg8~@@AXbM@@AGz@@AGz@@ADg8~@@ATɅo@@AR<6@@A(@@Al@@A'R@@A^5?}@@A@@A@@A2W@@A|@@AB@@A|@@AB@@A|@@Al@@Au@@A@@A@@AR<6@@An.@@A'RTa@@A(@@An.@@Au@@A@@AR<6@@An.@@A'R@@A2W@@Ay@@AD@@A@@A@@AD@@Ay@@AX@@A'R@@AX@@A^5?}@@AD@@ArGE8@@A^@@A[W>6@@A^@@A^@@Au!S@@A>BZ@@B@@C9@@Esg@@JqiC@@MY|@@McA @@QX@@SS@@T?@@W hۋ@@YB@@cZ@@fqi@@oH˒:@@w8}H@@}/w@@?@@&x@@s@@1&@@"`@@u@@O;@@@@>B@@C,zx@@O
@@-
q@@n.3@@64@@'0@@]cf@@I^5@@q@@Z1@@Q@@'R@@hr@@($x@@ƾߤ?@@fA@@TɅo@@qiC@@m@@Z@@ˈeO@@Ƨ@@9XbN@@̎qj@@hr@@zxl"h@@U=@@I^5@@0U2a|@@ҏ\(@@I^@@Ӂ@@SMj@@ԋC@@Z@@ո@@ֱ2X@@$xG@@ԕ*@@҉@@%2@@D@@߱[W>@@r Ĝ@@{@@@@#w@@u!S@@)y@@{J#9@@쿱[@@5?|@@U=@@'RT`@@ěT@@@@B@@ᰉ'@@s@@GE85@@g	@@m\@@u%@@PH@@,zxl@@S@@C]@@/{J#@@wkP@@u"@@zxl"h@@1@@,=@@($x@@5?|@@Ov_خ@@%@@'@@C-@@Ft@@H˒:@@O
M@@_o@@lC@@lC@@lC@@sPH@@|hs@@kP@@阮&@@/V@@@@A7K@@'RT@@4m@@ěT@@D@@^@@ᰉ'@@@@I^5@@1'@@Ov`@@&IR@@0U2a|@@@4n@@L_@@L/{@@D@@$@@Ƨ@@%2@@A [@@\N@@L_@@tj@@,<@@<쿱@@SMj@@3@@@@>@@V@@(@@5Xy>@@IQ@@`A7L@@}H@@ݗ@@O
@@Xy=@@cA @@$/@@s@@@@x@@)^@@,@@>6z@@b}V@@ݗ+@@K]d@@@@	ԕ+@@73@@D*@@oiDg8@@YJ@@@@F@@PH@@rGE@@JE@@Gz@@^@@b}@@~($@@o@@R@@1'@@Zc@@ڹY@@`A@@G{@@G{@@S&@@{J#9@@m]@@a@O@@wk@@@@|@@1&y@@?@@SMj@@o h@@?@@?@@zG@@zG@@tSM@@qj@@N;@@qj@@N;@@쿱[@@TɆ@@?@@j~@@Ʌoi@@D@@>@@K]@@*0@@2a|@@\@@m\@@M:@@O
@@n/@@@@b@@C\@@t@@ڹ@@ ѷY@@
L/@@4K@@($x@@+jg@@E@@R<6@@\N<@@fffff@@s@@s@@vȴ9X@@s@@vȴ9X@@IQ@@qi@@@@,<@@}Vl@@2X@@'@@}Vl@@@@@@@@&I@@ߤ?@@&I@@m\@@ȴ9X@@m\@@m\@@ȴ9X@@t@@A@@t@@t@@t@@A@@ȴ9X@@ȴ9X@@t@@A@@A@@t@@ȴ9X@@ȴ9X@@t@@t@@t@@A@@t@@A@@t@@҈p;@@ȴ9X@@҈p;@@ȴ9X@@A@@+@@1@@ߤ?@@C-@@C-@@ߤ?@@Mj@@@@Mj@@ߤ?@@+@@'@@@@m\@@t@@ߤ?@@T@@O;@@@@$t@@Fs@@Fs@@O;@@af@@af@@O;@@$t@@@@,<@@qi@@6z@@6z@@ȴ9X@@1@@C-@@ߤ?@@쿱[W@@"@@@@
=p@@;dZ@@4֡a@@4֡a@@E84@@K]d@@@@حV@@;dZ@@fA@@K]d@@@@[W>@@K]d@@fA@@+@@͞@@?@@kP@@$tS@@{J#:@@4m@@@A *0@A Q@A eO@A r Ĝ@A 'RT@A @A @A u%F@A 
=q@A d8@A 9Xb@A `A7@A@N@AJE@Ao hی@Au@A|@Al@AX@Ao@Aᰉ'@A"`@AI^5@AQ_@Ap:@A@AnP@AZ@AQ@A$@AZ@AɅoi@A*0@AɅoi@A#x@A@A?@Aj~@AɅoi@AZ@A>B[@A>B[@AJM@Ahr@Ae@A>@Ao i@A'0@AV@AV@AK]@A/w@A*0@A?@A/@Ahr@AZ@AJM@A!-w@A!-w@A@Ahr@A!-w@AE@Au@A?|h@AIQ@AIQ@AY|@AM:@Azxl"h@AڹZ@A%@Ash@AS@A+jg@A1@A'RT`@AbM@A-
q@A@A'/W@A.H@A1@A8}H@AKƧ@A_o@AlC@Av_ح@Ay@A?@AzH@A͞@AzH@A/V@A+@AحV@AحV@A@A+j@A     @A	ԕ+@A*0U@A4m9@ANU@A_F@Ahۋq@Au!@A4m@AѷX@A$tT@A	N;5@A	hr @A	[W>6@A	~($@A
GE85@A
}Vm@A
͞&@A
C,@A	@AP{@A$@A@AɅoi@A
Vl!@A
hr!@A
O
@A
ڹZ@A
fA@A
b@AzG@A1.@AR<6@A}Vl@At@A+@Aߤ?@Aߤ?@A@A@A$tS@A\(@A\(@AO
M@Aݗ+@ArGE9@AVϫ@A
qu@A-
q@A4m9@A:~ @A:~ @AD*@AoiDg8@A
=q@A-w1@A|Q@A^5?}@A1'@A0U2a|@A:)y@AW'@A@4@AC,@AF]c@AMj@A*0U2@Aa@@A$@A%1@A2W@A,<@A2W@A?@AFs@AI^5?@A`d@Am8@A쿱[@A*0@AJM@Ao i@Aqu"@A/w@A/w@A5Xy>@A84֡@A<64@A84֡@A84֡@AY|@Aw1@Aw1@Azxl"h@Asg@A$/@AU=@An/@AH˒@A@AcA @AϪ͞@A@A!.@A?@Ap:~@A$t@A}Vl@Aaf@AT@A6z@A@At@AFs@A,@A4֡a@ART`e@AXe,@Ab}V@A\(@Ab}V@Aeں@Av_ح@A	@AO;d@A-V@A	k@A&@A&@A&@AzH@A/V@A˒:)@A;dZ@A@A@A䎊r@A+j@A䎊r@ArGE9@ArGE9@ArGE9@A@AeO@Atj@A-
@Ad8@A@AU@A@Ad8@A4m@A)^@A`A7@A@AQ@A|Q@Ao@AR<6@A|@AD@Ao@Aᰉ'@AR@A-@AOv`@AC\@A{m@A0
@A@AW@Ag	@A ě@A}Vm@AW@A ѷ@Ac	@AC,@Ac	@AS&@A9@AC%@AMjO@AZ@An.3@AxF]@Aqu!@An.3@Atj~@AMj@Aa@O@AlC@As@Atj@AcA \@AtSM@Aq@AzG@AC@Azxl"@AZ@Ahr@AD@Ae@A:@A/w@AB@AY|@Am\@Aw1@AM:@A=K@A%@A@A@A1@A@A@A@A@Ash@A@A=K@A%@Aݗ@Ap
=@AjOv@A?|h@AQ@A!.H@AV@AK]@A[@A`A7L@Am\@A$/@Aݗ@A!R@AڹZ@Ahr!@A!R@Ahr!@AO
@A+j@A1@An/@AcA @AS@A
(@A!R<@A.2@A8YJ@AH@Afffff@AT@Am\@At@AC-@AC-@AMj@A@A@AMj@A@A;dZ@AXe,@AlC@A4m@A-V@A[W>@A@A@A 	ԕ+@A 	ԕ+@A -
q@A D*@A H@A K]c@A bM@A -
@A d8@A TɅ@A 4m@A TɅ@A ěT@A ѷX@A ۋq
@A `A7@A @A!0
)@A!|Q@A!@A!X@A!y@A!s@A"䎊@A"L/{@A"`A@A"͞&@A",<@A"m@A#u%@A#'/@A#C,z@A#,zxl@A#C%@A#tj~@A$xF@A$<쿱@A$SMj@A$`d@A$zG@A$C@A$_@A$3@A$TɆ@A$1&@A$?@A$Ʌoi@A$/@A$@A%o i@A%84֡@A%m\@A%sg@A%w1@A%$/@A%@A%?@A&@A&BZc @A&YJ@A&p:~@A&+J@A&+J@A&O;@A&6z@A&A@A'@A'@A'!-w1@A'E84@A'Xe,@A'b}V@A'y@A'O;d@A'&@A'˒:)@A'حV@A'@A';dZ@A'#@A(U2a|@A('RT@A()^@A)=b@A)oiD@A)~($@A)'RTa@A)_o@A)"`@A)"`@A)R@A)lD@A*Ov`@A*6C@A*a|Q@A*M@A*vȴ@A+S&@A+'/@A+C,z@A+,zxl@A+9@A+P{@A+Z@A+Q@A+S@A+@A+~($@A+҈@A,L_@A,"h	ԕ@A,I^5?@A,q@A,?@A,쿱[@A,j~@A,#x@A,?@A-*0@A-`A7L@A-p
=@A-$/@A-+j@A-v@A-1@A-@A-H˒@A-8Y@A-cA @A-?@A-?@A-,=@A-(@A-E@A-C\@A-C\@A._o @A.
(@A.Ov_@A.Ov_@A.8YJ@A.E@A.R<6@A.\N<@A.p:~@A.%@A.@A.,<@A.ߤ?@A.C-@A/ hۋ@A/Xe@A/+I@A/$tS@A/$tS@A/1@A/;dZ@A/b}V@A/|hs@A/	@A/kP@A/͞@A/+@A/@A/@@A/;dZ@A/@@A/Vϫ@A/-@A/Vϫ@A/䎊r@A0@A06@A06@A0}H@A06@A0A7K@A0|@A0ěT@A0{@A1@A1XbM@A1TɅo@A1hr @A1k~(@A1o hی@A1k~(@A1o hی@A1b}@A1~($@A1n.@A1'RTa@A1(@A1n.@A1@A1'RTa@A1n.@A1n.@A1'RTa@A1(@A1'R@A1^5?}@A12W@A12W@A1ԕ*@A1e@A1ᰉ'@A1e@A1@A1s@A1Y}@A1Y}@A1.H@A2u%F@A2s@A2-V@A2-V@A2-V@A20U2a|@A26C@A23@A2:)y@A2@4n@A2M@A2kP|@A2L_@A2}Vm@A2<64@A2W@A2`A@A2 ѷ@A2m\@A3C,z@A3"`B@A3,zxl@A3,zxl@A36z@A39@A39@A3@N@A3F]c@A3P{@A3Z@A3g	l@A3~$@A3Mj@A3q@A3|@A3\N@A4tj@A4C,zx@A4]ce@A4m8@A4wkP@A4C@A4?@A4#x@A4#x@A4#x@A4#x@A4@A4@A47@A4O
M@A4zxl"@A4O
M@A4?@A4#x@A4#x@A4[W?@A4?@A4Ʌoi@A4Z@A4D@A4!-w@A5[@A5!.H@A5(@A5\@A5\@A5m\@A5w1@A5ݗ@A5O
@A5+j@A5=K@A5%@A5=K@A5n/@A5Ϫ͞@A58YK@A5
qv@A5ᰉ@A5ᰉ@A5oiDg@A5E@A5C\@A6 ѷY@A6t@A6
L/@A6@A6+jg@A68YJ@A6E@A6Vu@A6l!-@A6c	@A6l!-@A6l!-@A6l!-@A6l!-@A6l!-@A6vȴ9X@A6IQ@A6%@A6%@A6+J@A6,<@A6$t@A6@A6-@A62X@A6Q@A6ߤ?@A6ȴ9X@A6ߤ?@A6Mj@A6"@A7Ft@A7)^@A7Xe@A7)^@A7Xe@A7v@A7,@A71@A74֡a@A71@A7;dZ@A7;dZ@A7>6z@A7E84@A7E84@A7H˒:@A7KƧ@A7O
M@A7Xe,@A7b}V@A7lC@A7sPH@A7	@A7&@A7@A7͞@A7vȴ9@A7+@A7rGE9@A7rGE9@A8     @A8bM@A8*0@A8A7K@A8H@A8[6@A8bM@A8eO@A8hۋq@A8oiDg8@A8u!@A8y=c@A8n@A8YJ@A8|@A8n@A8YJ@A8YJ@A8@A8@A84m@A8ěT@A84m@A8TɅ@A8@@A8ěT@A8p:@A8F@A8`A7@A9	k~@A9A [@A9N;5@A9^@A9rGE8@A9@A9@A9@A9B@A9ᰉ'@A9"`@A9e@A:#9@A:)y@A:Q_@A:d7@A:qiC@A:xl"h
@A:\(@A:L_@A:ᰊ@A:wkQ@A:vȴ@A:@A: ě@A:}Vm@A:g	@A:<64@A:W@A:`A@A:sP@A:sP@A: ѷ@A:c	@A:m@A:74@A:~@A;S&@A;nP@A;s@A;҉@A;nP@A;"`B@A;&@A;,zxl@A;,zxl@A;33333@A;@N@A;S@A;n.3@A;dZ@A;jf@A;tj~@A;tj~@A;@A;Q@A;eO@A;eO@A;eO@A;q@A;eO@A;q@A;Mj@A;:)z@A;:)z@A;Mj@A;q@A;:)z@A;~$@A;tj~@A;n.3@A;jf@A;n.3@A;{J#9@A;Q@A;eO@A;eO@A;Mj@A;:)z@A;ߤ@A;q@A;m]@A;Ƨ@A;a@O@A;Ƨ@A;
=p@A;҈@A;C]@A;@A;\N@A<J@A<!-w2@A<!-w2@A<%1@A<(\@A<64@A<C,zx@A<Fs@A<SMj@A<cA \@A<cA \@A<j~#@A<wkP@A<zG@A<C@A<S@A<3@A<zxl"@A<1&@A<zxl"@A<?@A<j~@A<j~@A<[W?@A<Ʌoi@A<?@A<@A<>B[@A<Z@A=o i@A=qu"@A=%F
L@A=+a@A=?|h@A=?|h@A=?|h@A=B@A=!R@A=ݗ@A=v@A=+j@A==K@A=v@A=+j@A=%@A=v@A=U=                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @q33333@qfffff@q@q@q     @qy@q{33333@qd@ql@qp     @qp     @qp     @qvfffff@qvfffff@qp     @q{33333@qy@qq@qd@qk33333@ql@qp     @qt@qs33333@qx     @q@q@q@q@qx     @qk33333@qnfffff@qy@q@q@q33333@q     @q@q@q     @qfffff@q     @q     @q     @q~fffff@q@qy@qnfffff@qp     @qq@ql@qd@qh     @qi@qT@q)@p@p@p33333@p[33333@p;33333@p4@p      @o     @n@n	@m@l&fffff@kffffff@j     @j@     @i     @h     @h	@g     @gl@gL@g<@g<@g6fffff@g33333@f     @f@fc33333@f@e     @e\@e33333@də@dffffff@dfffff@c陙@c@cfffff@c33333@c|@ci@cffffff@cc33333@cY@cVfffff@cVfffff@cI@c&fffff@b@b33333@bp     @bi@bffffff@bP     @b<@b333333@b333333@b\@b@b     @bc33333@bI@b9@b     @a     @a@ay@ay@a|@al@a6fffff@`33333@`     @_Ffffff@_      @_fffff@^ٙ@^@^fffff@^Y@^@     @^33333@]@]@]@]@]fffff@]33333@]fffff@]s33333@]`     @]@     @]@]@]      @\fffff@\fffff@\@\@\     @\     @\     @\fffff@\@\     @\@\@\@\     @\@\33333@\33333@\33333@\     @\s33333@\`     @\Y@\L@\333333@\,@\@\fffff@\      @\33333@\      @\      @\fffff@[33333@[     @[fffff@[33333@[fffff@[33333@[fffff@[fffff@[fffff@[     @[     @[@[@[fffff@[ffffff@[@     @[&fffff@[      @[      @Z@Z33333@Z33333@Z@Zٙ@Z     @Z@Z@Z33333@Z@ZS33333@Z&fffff@Z&fffff@Z&fffff@Z33333@Y@Y@Y     @Y     @Y33333@Y     @Y     @Y     @Ys33333@Y`     @YL@Y,@Y&fffff@Y      @Y      @Y@X@X33333@X@X33333@X`     @XL@X333333@X      @X@Xfffff@W@W@Wfffff@Wfffff@W     @Wy@W     @Ws33333@WS33333@W&fffff@V33333@V@V@V33333@Vٙ@V33333@V33333@Vfffff@Vfffff@Vfffff@Vfffff@V@V@V@V33333@Vs33333@Vy@VY@VL@V333333@V33333@U@Uٙ@Ufffff@U@U@Uy@U`     @U@     @U9@UFfffff@U9@U,@U&fffff@U@U      @U33333@T@Tٙ@Tٙ@Tٙ@T@T33333@T@Tfffff@Tfffff@T@T@T@Ty@TY@TY@TFfffff@T@     @TS33333@TL@TS33333@T`     @TY@TL@TFfffff@TL@T@     @TFfffff@TL@TL@TFfffff@TFfffff@TFfffff@TFfffff@T9@T9@T9@T333333@T,@TFfffff@TFfffff@T@     @T9@T9@T333333@T,@T&fffff@T333333@T,@T,@T,@T&fffff@T,@T9@Tfffff@S33333@S@Sfffff@S33333@Sfffff@S33333@S@S@Sfffff@Sy@Sfffff@Sl@Sffffff@Ss33333@Sffffff@S`     @Sl@Sl@Sffffff@S`     @SY@SY@SFfffff@S333333@S333333@S@Sfffff@S@S      @Rfffff@R@RY@R9@R9@R,@R@Q@Qٙ@Q@Q`     @Q,@Qfffff@Pfffff@P@P     @P@P     @Py@Py@Pl@P`     @P`     @P@Py@Pl@PY@PY@Pffffff@PS33333@P&fffff@O     @OL@Nfffff@Nfffff@N     @Nffffff@NY@N333333@N333333@N@     @N&fffff@Mٙ@M@M333333@M      @Lٙ@L@Ls33333@LY@LY@LY@LY@L&fffff@K     @Kffffff@K@Jfffff@J333333@Iٙ@I     @IL@H@H&fffff@H      @H      @H      @H      @H&fffff@H@H      @H@H      @H&fffff@Gfffff@G     @G33333@G33333@G@G@G@G@Gfffff@G33333@G@Gs33333@GL@G333333@G333333@G333333@G333333@G@     @G333333@G@     @GL@GL@G      @F     @Fٙ@F33333@Ffffff@Ffffff@Fs33333@Fs33333@FL@F@E@EY@D     @D@D@D@     @D     @D     @D@Ds33333@D     @Dffffff@DL@D333333@D@D@D@D      @C33333@D      @Cfffff@C@C33333@Cfffff@Cfffff@Cfffff@Cfffff@C@C     @C     @CL@C&fffff@C333333@C@Bfffff@B     @B@B     @Bs33333@BL@B@A@A@     @A&fffff@@33333@@33333@@     @@ffffff@@&fffff@?     @>fffff@>@>@>     @>      @=33333@=ffffff@=L@=      @<     @<@<     @<     @<@<333333@<@<      @;fffff@;fffff@;@;L@;      @:33333@:33333@:33333@:@:@:@:@:ffffff@:      @9ffffff@9      @8@8333333@8      @7@7@7ffffff@7L@7@6@6     @6@6L@6ffffff@6L@6      @6@6      @6@6L@6      @5fffff@5     @5L@5333333@5@5@5333333@5      @5@5@5333333@4@5      @4fffff@4@433333@433333@433333@4L@4     @4ffffff@4L@4L@4@4L@4L@4@4      @4      @333333@3fffff@3@3@333333@3@3ffffff@3     @3     @3L@3@3@233333@3@3@3333333@3L@3L@233333@2fffff@2fffff@233333@2@3      @2@2@2@2@2@2@2@2     @2     @2@2@2     @2L@2@2      @2      @2@1fffff@2      @2      @1@1@1@133333@1@1333333@1333333@1      @1333333@1L@1333333@1@0@0@0@033333@0@0     @0L@0@0333333@0333333@0@0@0@/@/@0      @0      @/ffffff@/@/@/333333@.@.@.@.@.@/      @.@.@.@.      @.ffffff@.ffffff@.333333@.333333@.333333@.      @-@-ffffff@-@-333333@-ffffff@-@-333333@-      @,@-333333@-      @,@,@-      @,@,@,ffffff@-      @,@,@,@,@,@,@,@,@,@,@,@,ffffff@,@,333333@,ffffff@,ffffff@,      @,ffffff@,      @+@,333333@,      @+@,      @,ffffff@,      @,      @+@+333333@+333333@+333333@+      @*@*@+333333@+333333@*@*333333@*@*ffffff@*ffffff@*333333@*333333@*ffffff@)@*333333@*      @*      @)@*      @)@)@)ffffff@)ffffff@)      @)333333@)333333@)      @)333333@)      @(@(@(@(@(@(333333@(ffffff@(ffffff@(ffffff@(@(@(ffffff@(@(      @'@'@'@'ffffff@'ffffff@'333333@'333333@'333333@'      @'      @'333333@'      @&@&@&@&      @&      @&333333@&      @&      @%@%@&      @&ffffff@&ffffff@&      @%333333@%@%@&      @%@%333333@%ffffff@%@%ffffff@%@%ffffff@%333333@%333333@%      @$@%333333@%333333@%      @%      @%ffffff@$@$@%      @%      @$@$@$@$@$@$@$@$@$@$ffffff@$@$@$333333@$      @$@$@$ffffff@$@$@%      @$@$333333@$      @$ffffff@$@$333333@$ffffff@$ffffff@$@$ffffff@$333333@$      @$333333@$ffffff@$@$ffffff@$333333@$@$333333@$333333@$@$@$@$@$@$ffffff@$@$@$@$@%      @$@%333333@%      @$@$ffffff@$@%333333@%ffffff@%ffffff@%333333@$@$@%333333@%      @$@%333333@%333333@%ffffff@%      @%@%333333@%      @%      @%ffffff@%333333@%ffffff@%ffffff@%333333@%ffffff@%333333@%ffffff@%@%333333@%@%@%@%ffffff@&      @%@%@&      @%@&      @%@&      @&      @%@%@&      @%@&      @%@&ffffff@&      @%@&      @&333333@&@&@'      @&ffffff@&@&@'333333@'      @&ffffff@'      @'333333@&@'333333@'ffffff@'333333@'      @'      @'333333@'333333@'333333@'333333@'      @'333333@'      @'333333@'333333@'@'ffffff@'ffffff@'333333@'333333@'@'@'333333@'333333@'@'ffffff@'@'@'@'@'@'333333@'@'@'@'@'@'@(      @'@'@(333333@(@'@(333333@(@(333333@(333333@(@(@(ffffff@(@(      @(@(ffffff@'@(@)ffffff@(ffffff@(@(@(@)333333@)      @)      @)      @)333333@)ffffff@)@)@)ffffff@)ffffff@)@)ffffff@)ffffff@)333333@)@)333333@)@)@)@)@)@)333333@)@)@)@)@*      @*      @*      @*ffffff@*333333@+      @*@*ffffff@*@+      @*@*@*@+      @+333333@*@+333333@+      @+      @+      @+ffffff@+ffffff@+      @*@+ffffff@+@,333333@+@+ffffff@+@,      @,@+@+333333@+@,      @+@+@+@,      @+@,      @+@,333333@+@+ffffff@,      @,ffffff@+@+@,      @,      @,ffffff@,      @,@,@,333333@,ffffff@,@,333333@,@-ffffff@,@,@-      @,@,@,@-333333@,@,@-333333@-      @,@-333333@-333333@,@-@-333333@,@-      @-333333@-ffffff@-333333@-ffffff@-@-@-@.333333@.@-@-ffffff@.333333@.333333@-@.      @.333333@.333333@.      @-@.333333@.@.333333@.ffffff@.@.ffffff@.ffffff@.@.@.@.@.@/      @/@/      @/@0ffffff@0      @/@0L@0     @0@033333@0fffff@0fffff@0@0@1      @1      @1ffffff@1L@1@1@1L@1L@1333333@1333333@1ffffff@1@1L@1L@1     @1     @1     @1@1     @1ffffff@1@1@1@1@1@2      @1     @1fffff@2      @1@1fffff@1fffff@2      @2      @2@2@1fffff@2@2333333@2333333@2ffffff@2@2@2333333@2L@2L@2ffffff@2L@2333333@2@2L@2L@2333333@2      @2@2@1fffff@2      @2L@2@2L@2@2L@2@2ffffff@2@2     @2ffffff@2333333@2@2@2ffffff@2@2fffff@2@2@233333@2@2fffff@2fffff@3333333@2fffff@3L@3      @3333333@3ffffff@3L@3ffffff@3ffffff@3ffffff@3L@3@333333@3@3@3@3@3@333333@3@3fffff@3@3fffff@3fffff@4@4ffffff@4333333@4L@4L@4@4333333@4@4@4ffffff@433333@433333@4@4@4     @4                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ?E?bM?+?KƧ?\(\?ם-V?E?܋C%?/v?އ+I?߾vȴ9X?Z1'?&x?-V?=p
=?Gz?-?tj~?A7Kƨ?r ě?I^5?}?\(?$/?7KƧ?hr Ĝ???|hs?噙?^5?|?Q?Q?7KƧ?9XbN?nP?$/?+J?䛥S?nP?C%?I^5?}?E?zG?;dZ?vȴ9X?I^5?vȴ?lC?E?$/?7KƧ?E?E?E?9XbM?߾vȴ9X?lC?\(?`A7?n?؃nP?ȴ9Xb?ffffff?և+I?zG?ӥS?S?`A7L?vȴ?˅Q?ȓtj~?ǮzG?ěS?öE?`A7?-V?-V?$/?nP?vȴ9X?;dZ?E?hr!?p
=q?1&y?(\)?"`A?"`B?lC?^5?|?^5?|??KƧ?bM?bM?O;dZ?\(??|hs?E??|hs??|hs?9XbM?9XbM?9XbM?zG{?E?l?tj~?-V?Q?nO;?lD?Q? ě?&x?
=p? ěT?
=p? ěT?bM? ěT? ěT?
=p?;dZ?vȴ9X?;dZ?;dZ?bM?bM?bM?bM?vȴ9X?vȴ9X?vȴ9X?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?Q?Q?Q?;dZ?Q?Q?;dZ?;dZ?Q?5?|h?5?|h?Q?Q?5?|h?5?|h?Q?Q?Q?5?|h?Q?Q?Q?Q?;dZ?;dZ?Q?Q?Q?Q?5?|h?5?|h?Q?Q?Q?5?|h?Q?5?|h?Q?;dZ?Q?5?|h?Q?5?|h?Q?Q?;dZ?Q?;dZ?Q?;dZ?5?|h?5?|h?Q?5?|h?Q?Q?5?|h?5?|h?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?;dZ?Q?5?|h?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?5?|h?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?;dZ?Q?Q?Q?vȴ9X?Q?Q?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?Q?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?Q?5?|h?;dZ?Q?Q?vȴ9X?;dZ?Q?vȴ9X?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ? ěT?Q?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?vȴ9X?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?Q?;dZ?vȴ9X?vȴ9X?;dZ?Q?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X? ěT?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?Q?Q?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X? ěT? ěT?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X? ěT?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ? ěT? ěT? ěT? ěT?vȴ9X? ěT? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ? ěT? ěT?;dZ? ěT?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X? ěT?vȴ9X? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT?;dZ?vȴ9X? ěT?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X? ěT? ěT?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?Q?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ? ěT?vȴ9X?;dZ?;dZ?Q?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @\l@X      @Us33333@S,@Q@P     @O@L     @J@G      @E      @C     @BY@A     @@ٙ@@s33333@@      @?@?33333@?ffffff@>     @=fffff@=fffff@=L@<fffff@;33333@9333333@:      @>ffffff@@     @@Y@>fffff@<      @8fffff@6     @6@6fffff@7@5L@3333333@1L@0L@/@.@-      @*ffffff@)      @(@'@%@#ffffff@"ffffff@!@!333333@ 333333@@@ffffff@@      @      @@      @333333@      @@333333@
@@333333@@      @@      @333333@@ @       ?ffffff??333333??      ?      ?ffffff??333333?񙙙?񙙙?      ?      ???陙?陙?ffffff?ffffff?ffffff?333333?333333?333333?      ?      ?      ?      ?ٙ?ٙ?ٙ?ٙ?333333?333333?333333?333333?333333?ə?ə?ə?ə?ə?ə?ə?ə?ə??????????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	P4                                      7                                       *MBBT3=