CDF       
      pressure  !   time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20170205   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P4     CAST_NUMBER       2      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:34.625401Z    ORIGINAL_HEADER      6CTD,20250210CCHSIOWB
#Removed 'CTDFLUOR_TSG' as it's filled with -999
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2017-06-29. CTD data from cruise 18DD20170205, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20170205. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2017-001/index.php. 
#
# The information in this file for the cruise 2017-001 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-0036.ctd
#
# Start of originator file comment header
#
#*2017/06/29 15:26:50.02
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2017/02/10 06:17:38.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 198
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : CE9F1F72
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            0.3            202.1
#       2 Temperature:CTD               deg_C_(ITS90)   5.6248         6.8697
#       3 Salinity:CTD                  PSS-78          32.78          33.8432
#       4 Sigma-t:CTD                   kg/m^3          25.7461        26.7106
#       5 Oxygen:Dissolved:CTD:Volume   ml/l            3.4            6.87
#       6 Oxygen:Dissolved:CTD:Mass     µmol/kg         147.7          299
#       7 Fluorescence:CTD:Seapoint     mg/m^3          0.66E-01       1.162
#       8 PAR:CTD                       µE/m^2/sec      0              0.3
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        7  F       ' '     2
#       6  -99   ' '        6  F       ' '     1
#       7  -99   ' '        8  F       ' '     3
#       8  -99   ' '        7  F       ' '     1
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2017-001
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P21
#    EVENT NUMBER        : 36
#    LATITUDE            :  49  38.00000 N  ! (deg min)
#    LONGITUDE           : 139  39.97000 W  ! (deg min)
#    WATER DEPTH         : 3961
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    The descent rate of the CTD was very noisy with some complete reversals
#	of direction.
#    CTDEDIT was used to remove many records corrupted by shed wakes;
#	salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Fluorescence and PAR data are nominal and unedited except that some records were
#	removed in editing temperature and salinity and a large spike in
#	fluorescence was removed from file 0032.
#
#    The Transmissivity channel was removed because of frequent shifts in values during
#	casts and large variations between values during repeat casts.
#	The data are available, by request, from the chief scientist.
#
#    NOTE: While the Fluorescence:CTD data are expressed in concentration units, they
#	do not always compare well to extracted chlorophyll samples, particularly for
#	casts far from shore. It is recommended that users check extracted chlorophyll
#	values where available.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in Sea-Bird
#	Application Note #64-2, June 2012 revision (Sea-Bird_64-2_Jun2012.pdf), except 
#	that a small offset in the fit was allowed.
#
#    The Dissolved Oxygen sensor used in files 0001, 0002 and 0016 malfunctioned so the 
#	Oxygen:Dissolved:CTD channels were removed from those files.
#
#    The Oxygen:Dissolved:CTD sensor has a fairly long response time so data accuracy 
#	is not as high when it is in motion as it is during stops for bottles. This will be
#	especially true when vertical dissolved oxygen gradients are large. To get an estimate
#	of the accuracy of the Oxygen:Dissolved:CTD data during downcasts (after recalibration)
#	a rough comparison was made between downcast Oxygen:Dissolved:CTD data and upcast 
#	titrated samples. Some of the difference will be due to problems with flushing of 
#	Niskin bottles and/or analysis errors, so the following statement likely underestimates 
#	Oxygen:Dissolved:CTD accuracy.
#
#    Downcast (CTD files) Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.25 ml/l from 0 to 125 dbar.
#	±0.2 ml/l from 125 to 400 dbar.
#	±0.1 ml/l from 400 to 600 dbar.
#	±0.05 ml/l from 600 to 1500 dbar.
#	Low by up to 0.08 ml/l below 1500 dbar.
#
#    For details on the processing see document: 2017-001-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5--- --6-- ---7--- --8---
#!Pressu Temperat Salinity Sigma-t: Oxygen Oxyge Fluores PAR:  
#!re:CTD ure:CTD  :CTD     CTD      :Disso n:Dis cence:  CTD   
#!                                  lved:  solve CTD:          
#!                                  CTD:   d:CTD Seapoin       
#!                                  Volume :Mass t             
#!------ -------- -------- -------- ------ ----- ------- ------
#*END OF HEADER
     WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @2         data_max      @2         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     )  2   pressure                	long_name         pressure   positive      down   units         decibar    data_min      ?ffffff   data_max      @fffff   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      )  [   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      
D     temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      @$xF   data_max      @#sg   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       )  8   temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      
D  @   salinity                	long_name         salinity   units         PSS-78     data_min      @@,hr   data_max      @A<Z1   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      )     salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      
D     oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @$ffffff   data_max      @q|   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        )     	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      
D    CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?(\)   data_max      ?陙   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      ) )   CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      
D R$   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min                 data_max      @P   C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       ) \h   PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d      
D p   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min               data_max               C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     )    CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d      
D    station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         (     cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( (   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      )   data_max      )   C_format      %10d       P   latitude               	long_name         latitude   units         	degrees_N      data_min      @HS"`B   data_max      @HS"`B   C_format      %9.4f          T   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      _~   data_max      _~   C_format      %9.4f          X   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d        \   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d        `@2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      ?ffffff@       @333333@@       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @4@6ffffff@6fffff@8      @9      @:      @;@;fffff@=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D@E@E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`)@`<@``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d@e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f@fٙ@g      @g      @g@     @g\@g     @g     @g     @g     @h      @h      @hC33333@h\@h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @mc33333@m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r@r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @ta@tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u@u      @u0     @u@     @uP     @u`     @up     @u     @u33333@u@u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @vfffff@v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @w@x33333@x      @x0     @x@     @xP     @x`     @xp     @x     @x@x33333@x@x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z@zfffff@z     @z     @z     @z     @z     @z񙙙@{      @{     @{      @{0     @{@     @{P     @{`     @{q@{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|fffff@|6fffff@|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @1@>fffff@P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @T@bfffff@h     @p     @x     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@      @     @     @     @      @(     @333333@8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @@     @      @     @     @     @      @(     @0@8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @33333@33333@     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @33333@33333@     @     @     @     @     @     @      @     @     @@33333@(     @0     @8     @@     @H     @P     @X     @k33333@p     @x     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @<     @I@P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @t     @x     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @@ @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @s33333@y@|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @@@     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @%@(     @,     @0     @4     @8     @<     @@     @D     @H     @O@T     @X     @\     @`     @d     @h     @l     @r     @t     @x     @|     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @      @     @     @     @33333@     @     @     @      @$     @(     @,     @0     @4     @8     @;@A33333@D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @733333@=33333@@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @33333@     @      @     @     @     @     @     @     @     @@$fffff@(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @@@@fffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 @"C,z@"

qv@"@"Vu@"-V@"1@"H@"T@"iB@"sP@"PH@"W@"|@"Ʌoi@"?|h@"sPH@"-
@"+@"#%2@"*qiC@"6z@"?˒:)@"J#9@"ZG{@"j	 @"ush@"y~($@"}IQ@"b}V@"ěT@"u%F
@"TɆ@"1@"Fs@"&I@"8}H@"zxl"@"l@"֡a@"|@"vȴ9X@"$tS@"䎊r@"vȴ9@"	@"$tS@"[W>@"|hs@"U=@"NU@"Gz@"&IR@",zxl@"
=p@".H@"n.@"2W@"&I@"9@"p:@"\(@".H@"\(@"a@N@" hۋ@"D@"ٙ@"Վ!R@"33333@"@"lC@"/@"-V@"3@"Q@"@4@" hۋ@"ѷX@"1&y@"*0U@#TɆ@#
B@#sg@#n@#*0U@#\(@#2X@#!-w@#	^5?}@#	oiD@#	ԕ+@#K]d@#u%F@#
qiC@#I^@#)^	@#
~"@#
0U2a|@#Q@#	oiD@"	k~@".2@"Q@"Ƨ@"]cA@"y@"K]@"֔Fs@"-@"ĨTɆ@"-V@"C@"u@"p:@"}Vm@"rnO@"`d8@"Qu!S@"FIQ@"?$tS@"1N;5@"(TɅ@""`B@"iB@"
C\@"
0
@"e@"      @!o@!Q@!e@!nP@!cA @!ɅoiD@!Q@!@!d8@!2X@!}p
=@!o;dZ@!l@!g&@!eo i@!_حV@!X*0@!O͞@!Fs@!<64@!:vȴ@!9"`@!-C\@!)@!"e+@!Y@!)y@!Xy=@!t@!o hی@ F]d@ F
L0@ wkP@ ҕᰊ@ ԕ*@ Q@ }H@ +j@ Xe@ tj~@ .H@ ?|h@ V@ #9@ lC@ F
L0@ S@ ~ߤ?@ nt@ de@ fL/{J@ T,<@ Iԕ*@ @d8@ =b@ ??@ 5?@ )Q@ '+I@ *D@ 3PH@  IQ@ @ ]cf@D@W+j@Xe@Ft@׍O;d@ԯO
M@'/@ڹY@s@Ж@ϐ@^5?|@tj~@     @rs@lVϪ@x)@x73@_vȴ9@T`d@E@=<64@9rGE8@6}Vl@6ȴ9X@5?@*~"@%+a@*g	@9(@P`A7@^Ov_خ@de@~vȴ9X@wrG@p{@r{m@w+@v}Vl@][@K҈@P{@@IQ@(@#S@]ce@@Ʌoi@*0U@;5X@
@
=p
@YJ@,zxl@ n@vȴ9X@dZ@!R@@jf@Ϫ͟@{J#9@r@+a@o@|@@N@xF]@v+jg@^iB@\wkP@XU@RS&@P$tT@PbM@FFs@@     @,VϪ@Q@Ov_@Z@u%F@ 4m@b}V@F]d@hr!@'@;dZ@ԕ*1@а{@O;dZ@ ѷ@W@P{@Ov_خ@ᰉ@ڹY@xQ@e1@P*0U@CnP@@ѷX@>\N<@:>B@0D@+C,z@1'@҉@eO@@vȴ9X@b@lC@sg@6z@?@`d@@ʦL/{@F]c@)_@zxl"h@@^5?}@K]c@1&x@)^@s@Q@74@ѷX@@6@NU@|j~#@y~($@vFs@usg@tJ@s33333@t֡a@rm\@s33333@nt@cS@I ѷ@<Z@2{m@$tSM@O;d@$@|hs@A@!-w2@@E@ξߤ?@,zxl@9XbN@1&y@&@͞@$/@weں@mU=@cn.3@GE84@y@6@xF]@p:@˒:*@Q@4m9@6@     @6z@Q@PH@쿱[@A@n.@KƧ@#@IQ@cwk@NT@IQ@<hr@+C,z@'@($xG@*~"@,"h	ԕ@%@@,@T`d@As@˒:*@ěS@b@/V@rG@Vϫ@fA@vE@u\(@qo@sg	l@s|@sPH@sMjO@tm8@t֡a@v_ح@xl"h	@{m]@@ae@fffff@b}@҉@@@Y@;dZ@u@ ѷ@eS@S@MjOv@Iԕ*@EQ@:>B@o @zxl"@ݲ-V@ѷX@/{J#@A@+@?@wKƧ@sg@mhr!@_?@PH@:xl"h
@)lD@L_@a@N@H@C,z@`A@R@ȴ9Xb@1@+j@|@n@~
(@glC@^Ov_خ@Uᰉ@Oo @Hp:@B\(@;J#9@*g	@o i@dZ@jf@|Q@ќu@Xe@?@y(@m(@jd7@aae@`ěT@_vȴ9@<hr@2X@RT`e@	 @&IR@©@Q@/{J#@lC@1@&L/{J@(ۋq
@$xF@bM@sP@
(@	^5?}@޸Q@Ձ$/@Ʌoi@ө*0U2@v_ح@š@6@hۋq@nP@ƍ@k~(@@vȴ9X@$tS@I^5?@iB@>B@\(@8)@MO;dZ@LcA \@L~($x@O@JqiC@>ߤ?@',@"`B@@Y}@z@c	@0
@`A@ԯO
M@BZc @0U2a|@Ʌoi@n}Vl@Y_o@Q4J@U=K@XU@O'/W@Bu%F
@64K@/{J#:@'fA@;dZ@l!-@͞@m@*0U2@2W@2W@&@C,@IQ@"`B@=K^@_o@ؓtj@ؓtj@6C@,<@6C@䎊r@%1@sg@N;@4m8@2ᰊ@1o@(ۋq
@(@)ᰉ'@%ڹ@#n.3@1&@L_@m@p:~@u%F
@3@zG@@4@ae@!-w1@6C@`A7@Q@s@t@o@IQ@
qu@fB@SMj@n@@@ hۋ@N;@o hی@v}Vl@yD@pD@],=@ao@hTɅ@b@4@_o@Ik~(@=v@=!.H@;m]@:)_@:S&@9"`@9D@:)_@;/V@9#w@7eں@6C-@6E@64K@5%F
L@4SMj@3g@1iB@1o@/4֡a@)Dg8~@&A@%ڹ@%S@#
=p@ 
qu@>@_F@Ϫ͞@2a|@Vu@[W>@4K@C,z@lC@zxl"h@TɆ@҈p@T`d@)^	@_o@$/@āo h@g8}@ï@n.@hۋq@4m9@D@oiDg8@6z@ۋq
@>BZc@	ԕ+@A@M@䎊@˒:*@@o hۋ@cS&@]cA @RS&@O\(@Kq@I ѷ@HK]c@H1&x@H@FFs@EQ@D*0@Dg8}@CF]c@A$/@?[W>@=b@;dZ@5sg@-V@(Xy=@vȴ9@|@9Xb@6z@~$@64@/V@Xe@|@lC@c	@0
)@՛=K@յsh@o@zxl"h@/V@x@@tSM@>BZ@qu"@#@84֡@\N@a@N@ ѷ@&IR@@$t@n.@YJ@!.I@!-w2@
qv@1&y@'@@>BZ@U@+J@ݗ+k@n@s@E84@\N@7Kƨ@}H˒@xF@s33333@m\@kU=@glC@bM@^Q@]}H@\?@[q@Xy=c@NVu@E8YK@BZc@@hۋq@?@=ڹZ@<?@<n.@;~$@:>B@:C\@:C\@9"`@9rGE8@71@43@2GE85@1o@0 ě@-U=@*͞&@)y@'RT`e@&@&L/{J@&,<@&'@&IQ@&L/{J@%@%+a@#n.3@o@6C@+@@@sPH@8YJ@1&x@*0@a@N@74@ڹZ@\@䎊qj@ߤ?@څݘ@sPH@m@6@
(@u"@u%F@Xe,@*0@4J@qu"@@~($x@~($x@ڹY@#@ݗ+@&I@@$tS@{lC@f1.@`d8@\>@XD*@W>6z@Vl!-@U2a|@R<64@O͞@J#9@F-@@6@<Z@;5Xy@9~($@8}H@6C-@5'0@49XbN@1o@+U=@u@	ԕ*@S&@@ IQ@($x@lC@xl"h
@B@Ft@1'@JE@حU@>6z@̘_@A@m8@q@6z@TɅ@wk@-w1@ߤ@@N;6@eO@~"@y(@iᰉ'@c	@_;dZ@a|Q@aGz@`d8@\?@[$@GzH@D*0@?@9Y}@6C-@6z@/v@-U=@+U=@쿱[W@U=@}H@PH@n@Mj@qi@Vu@!R<@@
@
qu"@xF]@
=p
@@n.@n.@ 4m9@$/@
Q@
!R@
u!S@
A [@
 hۋ@
䎊qj@
e+@
ߤ?@
ۋq@
Q_@
1'@
>BZ@
y=c@
t@
2a|@
,<@
&@
;dZ@
:@
Q@
\N@
)@
9XbN@
TɅ@
S@
$/@
tj~@
jg	@
cS@
]/w@
Y|@
W>6z@
S&@
QX@
LcA \@
H9Xb@
BZc@
=p
=@
84֡b@
0
(@
*0
@
=K^@
u%@
kP|@
S&@
@
n/@Vl!@hr@#x@hr@#x@Q@~$@lC@?@#x@hr@!.H@H˒@($x@m\@\N<@E@Vl!@唯O
@u!@ߤ?@ ѷY@ܑN;@Q_@8YJ@`A7@Q@|hs@KƧ@ᰊ@{@-@2W@Vϫ@}Vl@w1@\)@-w1@wkP@R<6@)^@C%@vȴ9X@Xy=c@N_o @<Z@6C-@4J@#wk@kP|@nO@
qu"@YJ@@$tS@~$@=b@kP@Fs@PH@C,z@e@d8@l!-@ΤT@]cf@s@j~#@Q@3@>B[@L/{J@	k@0
)@@N@@C%@%2@ ѷ@˒:)@~m\@~\N<@|PH@{~$@yrGE8@xF@zC\@weں@vȴ9X@vȴ9X@vȴ9X@vFs@u!R@tj~@qA [@iᰉ'@h@h	ԕ+@g@e@e@e@dqj@bM@`A7K@^iB@\]ce@\>@\(\@Zc	@Z1'@V8YJ@OAs@P{@Np:~@K:)z@JW'@IoiD@IoiD@G@@B@7Xe@3ߤ@0'RT@-B@(@#wk@"3@,<@o @	7KƧ@YJ@
G{@
쿱[W?@
fA@
䎊qj@
S@
e+@
حV@
cA @
"`B@
Ϫ͟@
,<@
`A7@
@
ɺ^5?}@
@@
84֡@
*0@
@
@
a|Q@
v@
TɅ@
Ov_@
҉@
$tT@
'/W@
ڹY@
{J#9@
}E@
v!.I@
sg@
nt@
k~($@
j~"@
jfB@
hr Ĝ@
e@
_?@
[$@
[q@
Zݘ@
Xe+@
RT`d@
L_@
H9Xb@
F]cf@
E84֡@
@4m@
>vȴ9X@
=b@
=b@
=v@
<n.@
;5Xy@
:)_@
2m\@
,1&y@
&'@
!R<6@
-V@
u%F@
Mj@
S&@	H˒@	Q@	!.@	MjO@	l@	-V@	C@	C]@	fA@	e@	;dZ@	;5X@	cA \@	n@	W'@	ɺ^5?}@	Q@	ɺ^5?}@	ɺ^5?}@	@	ǮzH@	*0@	@	TɅo@	7Kƨ@	7Kƨ@	6z@	~($@	?|h@	m\@	/V@	쿱[W@	zG@	L/{@	@	JM@	u%F
@	zG{@	tj~@	r䎊q@	q@	oiDg8@	nt@	nt@	m(@	ix@	de@	`҈p@	_;dZ@	^@	ZQ_      @	E84֡@	:^5?|@	49XbN@	/Vϫ@	/r@	+I^@	'&@	#S&@	"3@	vȴ@	Ov_@	+J@	tj@	ݗ+k@	ݗ+@	      @G{@F@kP@_ح@rGE8@!R@%F
L@%F
L@@O;@rGE@o@ٳ|@sPH@/{J#@S&@3@[W>6@zxl"@
=p@@ݗ+@bC,@cS@\(\@Y|@Xy=c@WsPH@Jn@C$@9#w@2a|Q@0 ě@-U=@+U=@*0@K]d@G{@SMj@JL@@o@?@2a|@R@_p@|@*0U@_o @ȴ9Xb@[W>@A@KƧ@֡a@ߤ@
qv@y@RT`e@xF@'RT`@u@u"@=K^@u%F@u%F@*0@n@p:~ @g8}H@`
qu@^҈p;@j~"@Np:~@ATɅo@B@@NU@D2W@@n@BZc@B\(@Ca@N@BZc@As@B&IR@A@ATɅo@A [7@@n@?@>ߤ?@?H˒:@?[W>@?[W>@?[W>@>
(@=p
=@=<64@=<64@>
(@@C@<쿱[@9XbM@:S&@8Q@+jf@:^5?|@$xF@$/                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 @@-'0@@-K]@@-V@@,D@@-V@@,>@@,D@@,hr@@-!.H@@-/w@@-84֡@@-5Xy>@@-B@@-S&@@-ce@@-!R@@-@@-1@@.,<@@/'/W@@0-
q@@0\)@@2n@@3dZ@@4Fs@@6?@@6ߤ?@@7$tS@@7eں@@7$tS@@7˒:)@@8@@873@@8@@8@@8҈p@@9|@@:-V@@:u%F
@@:m\@@;wk@@;@@;g@@;s@@;@@;@@;C]@@;@@<tj@@<SMj@@<1&@@<e@@=<64@@=\(@@>t@@>@@>p:~@@?E84@@?\(@@@\)@@Do h@@HbM@@Io hی@@N($x@@S|@@TZ@@Yb}@@dC@@e/w@@efA@@en/@@e
qv@@f+jg@@fz@@io hی@@mVl!@@p:~ @@w\(@@|?@@}O
@@kP|@@RT`e@@|@@@@O
M@@ڹZ@@&I@@@@S&@@xF@@}H@@s@@M@@I^@@C,z@@S@@/{J#@@L_@@oiDg@@䎊q@@e+@@hr@@zG@@.2@@@@@@Ov`@@&@@@@c	@@d8@@)y@@kP|@@g@@}H@@2X@@7Kƨ@@W>6z@@*0@@?@@#@@x@@@@!.H@@͛=K@@E@@5?|@@;5X@@L/{J@@ξߤ?@@6@@ ě@@y=c@@6z@@ԥzxl"@@V@@p:~@@ا@@G{@@7@@F
L0@@8Y@@Ov_@@ހIQ@@4m9@@@N@@N;5@@Ⴉ@@p:@@]cA@@F]c@@C%@@Z@@ߤ@@q@@g@@q@@凓ݗ@@u@@
=p@@{J#:@@NU@@譫U@@hr @@l@@X@@s@@Ov`@@L/{@@>B@@)_@@nP@@tj~@@A@@믷@@5Xy@@뢜wk@@a@@@N;@@]ce@@zG@@}H@@
L/@@\N<@@L/{J@@H@@'@@U=@@:~ @@-V@@tj@@Q@@@@L/{J@@*1@@64@@,<@@Fs@@TɆ@@[@@(@@픯O
@@t@@8YJ@@8Y@@jOv@@5Xy>@@zxl"h@@fffff@@$tS@@Mj@@ߤ?@@m\@@ȴ9X@@Ϫ͟@@!.I@@ݗ+@@حV@@+@@-@@Q@@	k~@@:)y@@g	l@@Q@@Vl!@@m\@@}H@@ ѷY@@}Vl@@IQ@@iB@@@@@@$tS@@@@,@@!-w1@@.H@@1@@.H@@.H@@1@@4֡a@@@@)^@@@@ hۋ@@Fs@@1@@C-@@t@@qi@@z@@$t@@2X@@Q@@t@@ߤ?@@Ϫ͟@@@@1@@y@@?@@[W>@@+@@@@@@@U@@D@@	k@@_p@@0
)@@k~(@@o@@u@@'R@@^5?}@@ԕ*@@"`@@@@s@@Y}@@.H@@u%F@@s@@䎊@@䎊@@-V@@&IR@@JL@@u%F
@@S&@@L_@@S&@@S&@@͞&@@m@@䎊q@@m\@@I^@@S&@@S&@@S&@@u%@@nP@@nP@@C,z@@C,z@@'/@@&@@/V@@6z@@33333@@&@@)^	@@)^	@@,zxl@@	@@&@@/V@@J#9@@MjO@@P{@@dZ@@tj~@@~$@@A@@ߤ@@*0U2@@*0U2@@~($@@5Xy@@ݗ+k@@A [@@ߤ@@@,<@@C,zx@@SMj@@VϪ@@VϪ@@#@@q@@q@@q@@SMj@@,<@@@@J@@Q@@g@@A [@@E@@S@@q@@~($@@5Xy@@@@wk@@ ѷ@@JL@@1'@@s@@Ov`@@Ov`@@0U2a|@@@4n@@M@@Zc@@d7@@h	ԕ@@h	ԕ@@d7@@qiC@@Q_@@C\@@@@4֡b@@˒:*@@_F@@[6@@-
q@@$xG@@'RT`@@Q@@y=c@@eO@@:~ @@Vϫ@@o @@*0@@}H@@'RT`@@*0@@*0@@*0@@@@4m@@ߤ?@@KƧ@@͞@@[W>@@/V@@@@˒:)@@@@rGE9@@@@-
q@@H@@n@@k~(@@e@@N;6@@-@@-V@@ᰊ@@I^@@~($@@J@@ߤ@@@ߤ@@@
=p@@%2@@C]@@A [@@%2@@9XbN@@"h	ԕ@@n.@@9XbN@@C,zx@@SMj@@,<@@j~#@@q@@]ce@@`d@@M:@@m8@@#@@3@@[W?@@:@@Y|@@S&@@sh@@H@@;5X@@Ov_@@4K@@+jg@@H@@z@@T@@]cf@@Xe@@;dZ@@{J#:@@[W>@@@@vȴ9@@@@@حV@@rGE9@A 	ԕ+@A $xG@@-@@͞@@zH@@{J#:@@iDg8@@	k@@o @@حV@@KƧ@@R<6@@'@@T@@,@@RT`e@@!-w1@@Mj@@%@@M:@@?@@u@@t@@8YK@@
qv@@H@@ߤ?@@\N<@@?@@Ov_خ@@Ov_خ@@}Vl@@,@@@@	k@@r@A 73@ArGE@ADg8~@Au!S@An.@Ae+@A ě@Ajf@AxF@A`A7L@A+jg@A\N<@A%@AFs@A
M;@A@Aߤ?@A6z@A-@A($x@A+jg@AzG@A
(@AC\@A?@An/@A ѷY@Ap
=@AD@A#x@A@A@AE@A/@Aj~@AN;@Am8@AcA \@AC,zx@A,<@A9XbN@AZ1@A쿱[@Aj~@A7@A'0@AV@A5Xy>@A-V@A!R<@A\N<@Al!-@A@A2X@AE84@A	k@A@AF]d@AIQ@A	-@A
L/{@A
fB@As@AS@AxF]@Am]@A%2@AC]@AQ@A$@A\N@An.@Ag@A%2@A@AZ@A6@Aa@O@A~($@Aߤ@A{J#9@AZ@A~$@Aߤ@A5Xy@Ag8}@A
w1@AzG@Aqi@A6z@Avȴ9X@A6z@A6z@A%@A}Vl@AMj@A,@AXe@Aݗ+@A>BZc@ATɅ@A_p@AN;5@Au@A'RTa@A^5?}@Aԕ*@AR@A#9@AW'@Ag	@AZ@AE@AA [@AJ@AL_@A!-w2@A9XbN@Am8@A?@A֡a@Ao i@AB@Aݗ@A@Ash@A-V@An/@A8YK@A@A,=@At@A@Avȴ9X@Aߤ?@A.H@A&@A?@A3@A3@A@@Al"h	@Atj@A@A9Xb@A)@A)@ATɅ@AěT@A)^@Ap:@A\)@A\)@A$/@ArGE@A+@A@N@A+@A&x@Aae@A@AR<6@An@AI^5@A䎊@AT`d@A^5?|@Au%F
@AL_@A0
@Avȴ@A@A)_@AD@Am\@A҉@A'/@AnP@APH@APH@A"`B@APH@APH@A"`B@A/V@Aqu!@AU=@Am]@A
=p@A
=p@AlC@A1&y@A@AxF@AFs@AtSM@Ao h@Ahr@A}H@Av@A@A
(@AE@AR<6@A}Vl@A+@AFt@A+I@A4֡a@A8}H@AAs@AH˒:@A_o@Av_ح@A͞@A@@A 	ԕ+@A A7K@A u%F@A 
=q@A ѷX@A!@A!0
)@A!Dg8~@A!Q@A!^@A!o hی@A!'RTa@A!D@A!@A!>BZ@A"n@A"0U2a|@A"M@A"{m@A"L_@A"L/{@A")_@A" ѷ@A"fB@A"c	@A"74@A#PH@A#Z@A#A@A#q@A#E@A#a@O@A#a@@A#ݗ+k@A#ݗ+k@A#҈@A#@A#\N@A#A [@A#@A#s@A$ߤ@@A$%1@A$9XbN@A$<쿱@A$M:@A$`d@A$wkP@A$tSM@A$C@A$*1@A$*1@A$*1@A$_@A$_@A$쿱[@A$3@A$TɆ@A$@A$@A$hr@A$e@A$!-w@A$E@A%'0@A%m\@A%}H@A%M:@A%ݗ@A%@A%b@A%C\@A&t@A&u@A&($x@A&5?|@A&s@A&,<@A&C-@A&쿱[W@A&Fs@A' hۋ@A')^@A'$tS@A'!-w1@A''/W@A'4֡a@A''/W@A'.H@A'1@A';dZ@A'KƧ@A'Xe,@A'b}V@A'zH@A'/V@A'o @A'fA@A'@A'@A'@@A'Vϫ@A'+j@A(
qu@A(
qu@A( ě@A(4m9@A(73@A(A7K@A(A7K@A(D*@A(Q@A(Q@A(_F@A(|@A(tj@A(ѷX@A(@A(4֡b@A(\)@A(PH@A)$/@A)@N@A)7KƧ@A)ae@A)o hی@A)u!S@A)x@A)|Q@A)n.@A)"`@A)-@A*n@A*@A*1'@A*0U2a|@A*=p
@A*Zc@A*@4@A*vȴ@A*<64@A*n@A*)_@A*͞&@A*ڹY@A*,<@A*sP@A* ѷ@A*C,@A*D@A+6z@A+C%@A+W>6z@A+jf@A+xF]@A+{J#9@A+$@A+ߤ@A+U=@A+@A+5Xy@A+|@A+
=p@A+C]@A+$@A+s@A+@A+s@A+\N@A,J@A,1&y@A,xF@A,@A,L_@A,Q@A,Q@A,!-w2@A,Q@A,/{J#@A,M:@A,g8}@A,VϪ@A,]ce@A,C@A,_@A,쿱[@A,@A,?@A,#x@A,7@A,Ʌoi@A,j~@A,[W?@A,Ʌoi@A,*0@A,/@A,@A,hr@A,E@A-Q@A-+a@A-L_@A-w1@A-@A-@A-
qv@A-E@A-ڹ@A. ѷY@A._o @A.4K@A.+jg@A.zG@A.@A.$/@A.($x@A.5?|@A.E@A.R<6@A.fffff@A.YJ@A.Vu@A.fffff@A.p:~@A.$t@A.$t@A.O;@A.af@A.T@A.6z@A.'@A.ߤ?@A.2X@A.}Vl@A.Q@A.'@A.ߤ?@A.ȴ9X@A.A@A.]cf@A.ߤ?@A.ߤ?@A.x@A/8}H@A/O
M@A/RT`e@A/Xe,@A/\(@A/_o@A/o@A/4m@A/$tS@A/r@A/@A/;dZ@A/rG@A/@@A/@A/-@A/rG@A/䎊r@A0     @A0@A0 ě@A073@A0D*@A0U2a|@A0@A0e+@A0{@A1 [7@A17KƧ@A1N;5@A1e+a@A1@A1u@A1l@A1D@A1y@A1N;6@A1"`@A1iB@A1e@A1e@A1-@A2	 @A2I^5@A21'@A23@A2JL@A2Zc@A2h	ԕ@A2u%F
@A2{m@A2p:@A2vȴ@A2@A2@A2<64@A2`A@A2ڹY@A2ڹY@A2fB@A2D@A2m\@A3I^@A3S&@A3҉@A3'/@A3s@A3PH@A3nP@A3C,z@A3PH@A3s@A3C,z@A3PH@A3C,z@A3"`B@A3&@A3C%@A3C%@A3C%@A3C%@A3F]c@A3F]c@A3J#9@A3MjO@A3W>6z@A3a@N@A3S@A3W>6z@A3W>6z@A3]cA@A3g	l@A3dZ@A3Z@A3W>6z@A3tj~@A3Q@A3eO@A3q@A3Mj@A3eO@A3Mj@A3U=@A36@A3@A35Xy@A3
=p@A3C]@A3C]@A3s@A4tj@A49XbN@A4Fs@A4PH@A4g8}@A4N;@A4쿱[@A4zxl"@A4TɆ@A41&@A4?@A4#x@A47@A4*0@A4Z@A4Z@A4JM@A4e@A4e@A5o i@A4>@A5:@A5V@A52a|@A584֡@A5B@A5zxl"h@A5}H@A5$/@A5ڹZ@A5O
@A5@A5sh@A58Y@A5Ϫ͞@A58YK@A5?@A5ᰉ@A5
qv@A5,=@A5oiDg@A6 ѷY@A6_o @A6_o @A6_o @A6
(@A6@A6($x@A6;5X@A61.@A68YJ@A6BZc @A6E@A6L/{J@A6H@A6Ov_خ@A6R<6@A6R<6@A6Vu@A6fffff@A6s@A6IQ@A6+J@A6@A6af@A6}Vl@A6@A6҈p;@A6+@A6C-@A6x@A6@A6@A6"@A6"@A7@A7@A74֡a@A7>6z@A74֡a@A7;dZ@A7;dZ@A7As@A7As@A7E84@A7As@A7H˒:@A7H˒:@A7O
M@A7O
M@A7KƧ@A7KƧ@A7O
M@A7Xe,@A7\(@A7_o@A7b}V@A7o@A7y@A7&@A7$tS@A7-V@A7-V@A7	k@A7͞@A73@A7/V@A7vȴ9@A7@A7vȴ9@A7vȴ9@A7K]d@A7˒:)@A7حV@A7@A7;dZ@A7;dZ@A7rG      @A7#@A8*0U@A8 ě@A8$xG@A8$xG@A8-
q@A8*0@A84m9@A873@A8NU@A8y=c@A8Xy=@A8U2a|@A8u!@A8@A8tj@A8tj@A8tj@A8@A8
=q@A8-
@A8@A8u%F@A8@A8-
@A8-
@A8
=q@A8d8@A84m@A8
(@A8ěT@A8@@A8ěT@A8e+@A8҈p@A8`A7@A8	k@A9_p@A9oiD@A9x@A9~($@A9~($@A9~($@A9~($@A9l@A9^5?}@A9_o@A9"`@A9ᰉ'@A9R@A9Y}@A:3@A:Zc@A:{m@A:L_@A:vȴ@A:L/{@A:}Vm@A:<64@A:,<@A:ڹY@A:ڹY@A:ڹY@A: ѷ@A:䎊q@A:m@A;S&@A;҉@A;PH@A;"`B@A;	@A;/V@A;6z@A;6z@A;C%@A;J#9@A;S@A;S@A;Z@A;]cA@A;a@N@A;a@N@A;dZ@A;@A;Z@A;Ƨ@A;@A;~($@A;C]@A<xF@A<J@A<ߤ@@A;\N@A<xF@A<ߤ@@A<xF@A<xF@A<@A<L_@A<Q@A<tj@A<L_@A<tj@A<Q@A<Q@A<"h	ԕ@A<!-w2@A<"h	ԕ@A<"h	ԕ@A<!-w2@A<%1@A<(\@A<,<@A<,<@A<,<@A<(\@A<(\@A<64@A<2W@A<64@A<Z1@A<?@A<Z1@A<VϪ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 @qi@qt@q{33333@qt@qvfffff@q{33333@q{33333@q|@q{33333@qvfffff@qvfffff@qx     @qt@qs33333@qnfffff@qi@qi@ql@qi@qd@q`     @q[33333@qVfffff@qNfffff@qI@q9@q9@q333333@q.fffff@q.fffff@q.fffff@q.fffff@q.fffff@q.fffff@q6fffff@q9@q8     @q0     @q.fffff@q+33333@q(     @q!@q      @q!@q#33333@q(     @q(     @q,@q.fffff@q,@q)@q!@qfffff@qfffff@qfffff@q      @qfffff@q@q@pfffff@p33333@p^fffff@p     @oFfffff@n9@m33333@lfffff@l      @k@k33333@k@k@k     @k@kI@jə@j\@i33333@ifffff@i@     @h@h33333@h<@h     @h33333@h      @g陙@g     @g33333@gfffff@g     @g     @gfffff@gfffff@g     @g     @gfffff@g@gp     @gC33333@f@f333333@f      @e@e     @efffff@es33333@eI@e     @dٙ@dfffff@d33333@ds33333@d<@d	@c     @c@cs33333@cVfffff@c<@c33333@bٙ@b     @bfffff@by@b|@b     @b@b33333@b33333@b     @b     @bc33333@b&fffff@a@afffff@afffff@a@aL@a	@`     @`fffff@`@`@`@`ffffff@`S33333@`6fffff@`     @_33333@_     @_@_@_fffff@_33333@_s33333@_L@_,@_33333@^@^     @^     @^     @^s33333@^`     @^S33333@^@     @^Ffffff@^`     @^     @^@^fffff@^33333@^fffff@^@^     @_      @_@_      @_      @_@     @_33333@^33333@^fffff@^33333@^ٙ@^     @^l@^333333@^9@^&fffff@^      @_333333@`@ap     @aٙ@a33333@a陙@a33333@a@aY@a)@a      @a33333@a,@ac33333@afffff@a|@a6fffff@`fffff@`fffff@afffff@a,@a<@aFfffff@a9@afffff@a      @`@`     @`ə@`33333@`@_fffff@^9@]ffffff@\@\33333@\@\Y@\333333@\S33333@\`     @\      @[33333@[@[33333@[fffff@[33333@[y@[l@[S33333@[@     @[,@[@[      @Z@Z33333@Z     @Zfffff@Z33333@Zy@Z@     @Zfffff@Y@Y@Y@Y33333@Y@Ys33333@Y`     @Y9@Y333333@YL@YFfffff@Y9@Y@     @YL@Ys33333@Yfffff@Y     @Ys33333@YS33333@YFfffff@Y333333@Y333333@Y&fffff@Y      @Y33333@X33333@X@X     @Xٙ@X33333@X     @X     @X33333@X33333@Xfffff@X     @X     @Xs33333@XY@X9@X,@X,@X9@X@     @XFfffff@XFfffff@XL@X@     @X333333@X&fffff@X&fffff@X      @Xfffff@W@Wٙ@W     @W     @W33333@W@W`     @W,@Wfffff@V@Vٙ@V33333@V33333@Vfffff@V33333@Vs33333@VY@V@     @Vfffff@Ufffff@Ufffff@U     @Ufffff@U@U@Ufffff@U33333@V@VFfffff@Vs33333@V@V@V@Vfffff@V     @Vs33333@Vl@V`     @Vy@V@V@V     @V     @Vfffff@Vfffff@Vٙ@Vٙ@Vٙ@V33333@Vfffff@V     @Vfffff@W      @W     @W@Wfffff@W     @Wٙ@W     @W     @W33333@Wfffff@W     @W     @W@W@W33333@W33333@W@X&fffff@X33333@Y333333@Yfffff@Y@Y@Y33333@Y@Y@Ys33333@Yffffff@Ys33333@Yfffff@Y@Y@YY@Y333333@Y@Y33333@Yfffff@Y      @Y`     @Y@Y@Yffffff@Y9@Y      @Y@Yfffff@Y33333@X@X     @X33333@X33333@Xl@W@Wl@W@V@V     @V9@Uٙ@UY@T     @T@Tfffff@Tfffff@T33333@Tfffff@T     @Ty@Ty@TL@T&fffff@T33333@Tfffff@Sfffff@Sfffff@S@Sfffff@S@S     @S@Sy@S`     @S9@S      @R@R@Rfffff@RY@Qfffff@Qfffff@Q@Q     @Q@Q     @QL@Q      @P@Pfffff@P33333@P@PS33333@P9@P      @P      @O@O@O     @Offffff@Offffff@Os33333@Os33333@Offfff@O@Os33333@OY@O&fffff@O     @O@Oٙ@O@O     @O&fffff@O@N33333@O&fffff@O@O@O     @Offfff@O33333@Offfff@OL@O@O      @N@N@N@N33333@N@     @M@ML@M&fffff@L33333@L333333@Kfffff@K@     @K@J@J&fffff@I@Hfffff@H@GL@Fٙ@F     @F&fffff@Efffff@E@F      @F&fffff@FL@F     @Ffffff@F33333@Fٙ@F33333@F33333@Ffffff@Fٙ@G@GL@G     @Gfffff@Gfffff@Gs33333@GY@Gs33333@G     @Gfffff@G@G@Gٙ@G@Gfffff@Gs33333@GL@G@     @G@F33333@F     @F@     @F@E@E     @E     @EY@E@D@D     @DL@Cfffff@CY@B33333@B      @A@Afffff@A     @Affffff@A@     @A333333@A@     @A&fffff@A&fffff@A@A@A&fffff@A333333@A@     @AL@AY@A@     @Affffff@Affffff@A@A@Affffff@A@     @@ٙ@@ffffff@?ffffff@>@>@=33333@=@=33333@=fffff@=     @=@=@=      @<@;fffff@;ffffff@:@:      @9@933333@9     @9L@9ffffff@9     @9L@9333333@8@8      @733333@7     @7@6@7      @7      @633333@6333333@6      @5fffff@5@5@5333333@5L@5      @5      @5      @5      @5@5333333@4@4ffffff@3@333333@3@3L@3333333@2fffff@2@2L@1fffff@2      @2      @1fffff@2@1fffff@1fffff@1fffff@2333333@2@2      @133333@1@1@133333@1@1@1@1ffffff@1333333@0fffff@033333@0ffffff@0L@0     @033333@0@0L@0333333@0     @0     @0L@0ffffff@0@0     @0     @0ffffff@0333333@0@0333333@0333333@0L@/@/333333@/333333@/@/333333@/333333@/333333@/      @.@.@.333333@.      @-@-@-@-@.333333@-@-333333@-333333@,@,333333@,@,@,      @+ffffff@,      @,      @,333333@+@+ffffff@+@+333333@+@+ffffff@+333333@+333333@+333333@+333333@+      @*@*@*ffffff@*ffffff@*ffffff@*@*@*ffffff@*      @)@*      @*      @)ffffff@)333333@)@)@)@*      @)333333@)333333@)333333@(@(@)333333@(@(@(@)      @)      @(@(@(@(ffffff@(333333@(@(@(      @(ffffff@(333333@(      @(      @(      @(      @(      @(333333@(ffffff@(333333@(      @(@(333333@'@'ffffff@(ffffff@(ffffff@(      @(      @'@'@'ffffff@'@'@'@'333333@(      @&@'333333@'ffffff@'333333@'@'333333@'333333@'333333@'ffffff@'333333@'333333@'      @&ffffff@&@'      @&@&@&@&@&@&@&@&@&@&@&ffffff@'      @&@&@&@&333333@&@&ffffff@&333333@&ffffff@&@&@&@&@&@&ffffff@&@&@&ffffff@&@'      @&@&ffffff@&333333@&ffffff@&@&@&@&@&333333@&      @&333333@&ffffff@&ffffff@&ffffff@&      @%@&      @&      @%@%@%ffffff@%      @%333333@%ffffff@%333333@%333333@$@$ffffff@$@$@$@%      @$@%333333@%333333@%      @%      @%333333@%333333@$@$@%333333@%ffffff@$@%333333@%      @%333333@$ffffff@%333333@%ffffff@$@$ffffff@$@%333333@%@$@$@$@%333333@$@%333333@%333333@$@$@%      @%333333@%333333@%333333@%333333@$@%@%      @%ffffff@%333333@%333333@%333333@%      @$@&      @%@%ffffff@%333333@%      @%@%      @%333333@%333333@&      @%ffffff@$@%333333@%333333@%333333@$@%ffffff@%@%@%ffffff@%333333@%ffffff@$@%333333@%ffffff@%@%333333@%ffffff@%ffffff@&      @&      @%333333@%@&      @%333333@&      @%ffffff@%ffffff@%@%@%ffffff@%@%@%@%ffffff@&333333@&      @&      @&333333@&ffffff@&@&      @&333333@'      @&      @&      @&333333@&@&@&@&@&@&@&@&ffffff@&@&ffffff@&333333@&@&@'333333@'333333@&@&@'ffffff@'333333@'333333@'      @'      @'333333@'333333@&@'ffffff@'ffffff@'333333@'@'      @'      @'333333@'333333@'ffffff@'@'ffffff@'ffffff@'@'@'ffffff@'@'@'@(333333@'@'@(ffffff@(ffffff@(@(@(333333@(      @(@(ffffff@(@(ffffff@(@(@(ffffff@(333333@(@(@(@(@(333333@(333333@(ffffff@(ffffff@(@(@(@(@(@(@(@(@)      @(@(@(@(ffffff@(ffffff@(@)333333@(@(ffffff@)      @)      @(@(@)333333@(@(@)333333@)      @(@)      @)      @)ffffff@)      @(@)@(@(@)ffffff@)333333@)ffffff@)@)ffffff@)@)ffffff@)ffffff@)ffffff@)ffffff@)@)@)ffffff@)@)@)ffffff@)ffffff@*      @*      @)@)@)@*      @*      @)@*333333@*@*@*@*333333@*@*ffffff@*333333@*@*@+      @+333333@+      @*@*@+      @+333333@+      @*@+      @+333333@+333333@+333333@+333333@+333333@+333333@+      @+333333@+@+333333@+ffffff@+333333@+333333@+@+@+@,ffffff@,ffffff@,      @+ffffff@+@,@,@,333333@+@+@,      @,@,@,333333@-333333@,333333@+@,@-333333@,@,@,      @+@,@,ffffff@,@,@,ffffff@,ffffff@,@,@,ffffff@-      @,@,333333@,@-@,@,ffffff@-      @-      @-333333@-333333@-333333@-ffffff@.333333@-333333@,@-      @-333333@,@-ffffff      @-ffffff@-ffffff@-ffffff@-ffffff@-@-@-@-@-@-@.      @.333333@-@.333333@.ffffff@.@.@.ffffff@.333333@.@.ffffff@.      @.333333@.333333@.ffffff@.      @.@/333333@.@.ffffff@.@.@.@.@/      @.@.@.@/      @/@0@0333333@0333333@0333333@0L@0333333@0@/@0@0@0L@0fffff@0@1      @0@1@1@1     @1@1@1ffffff@1L@1     @133333@1@1fffff@1@1@1fffff@1fffff@1@1@2333333@133333@1fffff@2333333@2333333@1fffff@1fffff@1fffff@2333333@2      @2@2     @2@2     @2@2@233333@2@3@3L@2@2fffff@3333333@3333333@2fffff@3@3ffffff@3@3      @3@2fffff@3333333@3      @2fffff@3@3ffffff@3      @233333@3333333@2@2fffff@3L@3333333@2fffff@3333333@3@2fffff@3333333@2fffff@3     @2@2fffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 ?Q?+?lC?噙?lC?陙?7KƧ?C$?+?\(?"`B?^5?|?tj?\(?vȴ9X?ȴ9Xb?^5?|?E?GzH?ěS?9XbN?vȴ9X?|hr?$/?GzH?އ+I?I^5?}?tj~?=p
=?أ
=p?ěS?׾vȴ9X?;dZ?+?
=p
?1&x?ěS?ؓtj~?nO;?GzH?zG{?E?Ƨ-?Q?QR?ڟvȴ9?^5?|?r ě?      ?ؓtj~?+?և+I?ָQ?և+I?ffffff?zG?\(?hr!?Ԭ1&y?ԛS?ӅQ?ҏ\(?~"?+J?Vt?Ƨ-?=p
=?1&x?x?S??|hs?/w?+?9XbM?+?S?-V?Q?Q?ěS?7KƧ?
=p? ěT?|hr?|hr?"`?Q?"`?-V?E?vȴ9X?-V?1&y?hr!?E?;dZ?Q?"`?vȴ9X?A7Kƨ?nP?      ?"`?"`?vȴ9X?vȴ9X?vȴ9X?S?S?Gz?S?(\)?+J?+?O;dZ?
=p
?+I?O;dZ?ȴ9Xb?\(??|hs?j~#?9XbM?j~#?E? ě?333333?E?nO;?333333?tj~?nO;?-V?l?nO;?hr Ĝ?&x?`A7L?bM?
=p? ěT? ěT?vȴ9X?vȴ9X?;dZ? ěT?bM?;dZ?;dZ?;dZ?Q?5?|h?
=p?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?-V?Q?Q?-V?5?|h?/v?/v?/v?1&y?/v?-V?Q?/v?/v?5?|h?-V?1&y?1&y?1&y?5?|h?/v?1&y?1&y?/v?(\)?1&y?1&y?1&y?1&y?1&y?1&y?/v?/v?1&y?1&y?1&y?-V?(\)?(\)?/v?(\)?1&y?(\)?-V?1&y?/v?-V?1&y?-V?1&y?(\)?1&y?/v?/v?/v?1&y?-V?(\)?1&y?/v?-V?1&y?(\)?(\)?1&y?1&y?(\)?-V?5?|h?-V?-V?-V?1&y?-V?1&y?/v?/v?-V?1&y?5?|h?5?|h?5?|h?5?|h?/v?/v?1&y?-V?/v?-V?/v?-V?Q?-V?-V?-V?/v?-V?/v?-V?/v?/v?-V?/v?/v?-V?-V?5?|h?5?|h?;dZ?5?|h?-V?-V?Q?5?|h?/v?/v?/v?-V?5?|h?5?|h?5?|h?-V?Q?Q?Q?5?|h?5?|h?-V?-V?5?|h?5?|h?/v?/v?5?|h?5?|h?5?|h?-V?5?|h?-V?5?|h?Q?5?|h?Q?5?|h?-V?-V?5?|h?5?|h?-V?5?|h?Q?5?|h?5?|h?Q?Q?5?|h?-V?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?/v?5?|h?-V?5?|h?5?|h?5?|h?-V?5?|h?Q?Q?-V?5?|h?5?|h?-V?Q?5?|h?5?|h?5?|h?Q?5?|h?5?|h?-V?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?Q?;dZ?Q?Q?5?|h?Q?Q?5?|h?5?|h?-V?-V?5?|h?Q?;dZ?Q?Q?Q?-V?5?|h?5?|h?-V?Q?5?|h?5?|h?Q?/v?-V?;dZ?5?|h?Q?5?|h?Q?Q?5?|h?-V?Q?Q?Q?Q?Q?Q?5?|h?Q?5?|h?5?|h?5?|h?-V?5?|h?Q?5?|h?5?|h?Q?Q?-V?Q?5?|h?5?|h?Q?Q?Q?Q?Q?5?|h?5?|h?-V?Q?Q?;dZ?5?|h?Q?5?|h?Q?Q?5?|h?Q?5?|h?-V?5?|h?Q?5?|h?Q?5?|h?Q?Q?5?|h?Q?Q?5?|h?5?|h?Q?Q?Q?;dZ?5?|h?Q?Q?Q?5?|h?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?5?|h?Q?Q?Q?Q?Q?5?|h?Q?5?|h?Q?Q?Q?5?|h?5?|h?5?|h?Q?5?|h?Q?5?|h?Q?Q?Q?Q?Q?Q?5?|h?5?|h?5?|h?Q?Q?5?|h?5?|h?Q?Q?Q?;dZ?Q?Q?Q?5?|h?5?|h?Q?Q?Q?;dZ?;dZ?Q?Q?Q?Q?Q?;dZ?Q?;dZ?5?|h?5?|h?Q?Q?Q?5?|h?Q?Q?5?|h?5?|h?;dZ?Q?5?|h?5?|h?5?|h?Q?5?|h?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?;dZ?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?Q?Q?Q?Q?Q?;dZ?Q?5?|h?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?;dZ?;dZ?Q?Q?Q?5?|h?Q?;dZ?Q?Q?Q?5?|h?Q?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?Q?;dZ?Q?Q?Q?;dZ?Q?Q?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?Q?;dZ?Q?Q?Q?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?Q?Q?Q?;dZ?Q?;dZ?Q?Q?;dZ?Q?;dZ?Q?Q?Q?5?|h?Q?;dZ?Q?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?Q?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?
=p?vȴ9X?Q?;dZ?vȴ9X?;dZ?;dZ?5?|h?;dZ?;dZ?vȴ9X?vȴ9X?Q?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?Q?;dZ?;dZ?vȴ9X?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?vȴ9X?;dZ?Q?Q?Q?;dZ?;dZ?vȴ9X?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?vȴ9X?Q?Q?Q?Q?;dZ?Q?Q?;dZ?Q?Q?Q?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?Q?Q?;dZ?Q?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?5?|h?;dZ?;dZ?Q?Q?5?|h?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?vȴ9X?vȴ9X?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?Q?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?Q?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?Q?Q?Q?;dZ?5?|h?Q?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?;dZ?;dZ?Q?Q?;dZ?Q?Q?Q?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?5?|h?Q?;dZ?;dZ?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?Q?Q?;dZ?Q?5?|h?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?;dZ?;dZ?5?|h?Q?Q?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?5?|h?5?|h?Q?Q?;dZ?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?5?|h?Q?Q?Q?Q?Q?5?|h?;dZ?Q?Q?Q?Q?Q?Q?;dZ?;dZ?Q?Q?5?|h?5?|h?Q?;dZ?Q?;dZ?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?;dZ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 @E@O@P@Cfffff@B333333@@333333@=ffffff@;33333@9L@6fffff@5@3L@133333@0@/@-      @*ffffff@(@&333333@%ffffff@$      @"@!ffffff@ 333333@ffffff@      @      @ffffff@@333333@      @@      @@ffffff@333333@@
ffffff@@      @ffffff@@      @ffffff@@ @       ?ffffff??333333??      ?ffffff???333333?񙙙?񙙙?      ???陙?陙?ffffff?ffffff?ffffff?333333?333333?      ?      ?      ?ٙ?ٙ?333333?333333?333333?333333?333333?ə?ə?ə?ə?ə?????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	P4                                      2                                       )BBU3