CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20140212   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P4     CAST_NUMBER       4      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:40.684197Z    ORIGINAL_HEADER      CTD,20250204CCHSIOWB
#Renamed 'CTDFLUOR_TSG' to 'CTDFLUOR' with units 'MG/M^3'
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20210615CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2014-07-09. CTD data from cruise 18DD20140212, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20140212. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2014-01/donneesctddata/2014-01-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2014-01/index.php. 
#
# The information in this file for the cruise 2014-01 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2014-01/donneesctddata/2014-01-0082.ctd
#
# Start of originator file comment header
#
#*2014/07/09 16:08:49.62
#*IOS HEADER VERSION 1.10 2011/10/26 2011/10/26
#
#*FILE
#    START TIME          : UTC 2014/02/23 16:30:20.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 2081
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : ACD38923
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            3              2104
#       2 Temperature:CTD               deg_C_(ITS90)   1.8242         7.9261
#       3 Salinity:CTD                  PSS-78          32.3708        34.6182
#       4 Sigma-t:CTD                   kg/m^3          25.2476        27.7052
#       5 Transmissivity:CTD            %/m             61.5           68.4
#       6 Oxygen:Dissolved:CTD:Volume   ml/l            0.2            6.7
#       7 Oxygen:Dissolved:CTD:Mass     µmol/kg         8.5            291.8
#       8 Fluorescence:CTD:Wetlabs      mg/m^3          0.86E-01       1.414
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        6  F       ' '     1
#       6  -99   ' '        7  F       ' '     2
#       7  -99   ' '        6  F       ' '     1
#       8  -99   ' '        8  F       ' '     3
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2014-01
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P5
#    EVENT NUMBER        : 82
#    LATITUDE            :  48  41.45000 N  ! (deg min)
#    LONGITUDE           : 127  10.04000 W  ! (deg min)
#    WATER DEPTH         : 2098
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0550
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    CTDEDIT was used to remove some records near the surface and many
#	records corrupted by shed wakes; salinity was cleaned.
#
#    Data Processing Notes:
#    ----------------------
#    Transmissivity, Fluorescence and PAR data are nominal and unedited except that
#	some records were removed in editing temperature and salinity.
#
#    For details on how the transmissivity calibration parameters were calculated
#	see the document Transmissivity_Calculation.pdf.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in the Sea-Bird
#	Application Note #64-2 of June 2012 (Sea-Bird_64-2_Jun2012.pdf), except that 
#	a small offset in the fit was allowed.
#
#    The Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.8 ml/l from 0 to 100 dbar.
#	±0.6 ml/l from 100 dbar to 300 dbar.
#	±0.2 ml/l from 300 dbar to 800 dbar.
#	±0.05 ml/l below 800 dbar.
#
#    The primary Salinity:CTD channel was used for events 0041 and 0043, so 
#	it was recalibrated to match the secondary channel which was selected for
#	all other casts.
#
#    For details on the processing see the report: 2014-01-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5-- --6--- --7-- ---8---
#!Pressu Temperat Salinity Sigma-t: Trans Oxygen Oxyge Fluores
#!re:CTD ure:CTD  :CTD     CTD      missi :Disso n:Dis cence: 
#!                                  vity: lved:  solve CTD:   
#!                                  CTD   CTD:   d:CTD Wetlabs
#!                                        Volume :Mass        
#!------ -------- -------- -------- ----- ------ ----- -------
#*END OF HEADER
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @2         data_max      @2         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     (  .L   pressure                	long_name         pressure   positive      down   units         decibar    data_min      @          data_max      @        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      (  V   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      
(     temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      @<n.   data_max      @ @	k   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       (     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      
(  T   salinity                	long_name         salinity   units         PSS-78     data_min      @@-
   data_max      @A=   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      (  |   salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      
(     oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @!333333   data_max      @r!   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        (  D   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      
(    CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?+   data_max      ?-   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      ( "   CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      
( J   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       ( T   PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d      
( }t   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min      @NY   data_max      @Q         C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     (    CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d      
( <   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( d   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         (    time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min         data_max         C_format      %10d          latitude               	long_name         latitude   units         	degrees_N      data_min      @HRz9   data_max      @HRz9   C_format      %9.4f             	longitude                  	long_name         	longitude      units         	degrees_E      data_min      _\(   data_max      _\(   C_format      %9.4f             	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3P   data_max      3P   C_format      %8d           	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d        @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @2      @       @      @      @      @      @      @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @      @(     @0     @8     @@     @H     @P     @X     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @0     @4     @8     @<     @@     @D     @H     @L     @X     @\     @`     @d     @h     @l     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @d     @h     @l     @p     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         @Vl!@E@lC@hr@vȴ9X@쿱[@Q@6z@H˒:@˒:)@      @.H@@ 4m9@$/@ [7@:S@7Kƨ@o hی@ 4m@ IQ@ hۋq@:S@o hی@ ѷ@zH@Ƨ@)^@@(\@iB@!Gz@%S@.2X@;~$@>6z@>BZc @I@S@h@4m9@+@m8@;5X@ @ (r Ĝ@ >5?|@ @	k@ @[6@ >҈p;@ =,=@ =IQ@ <hr@ ;W>6z@ 6ȴ9X@ 0$tT@ ,q@ )k~(@ ($xG@ &,<@ %1@ $e@ #$@ "wkQ@  -
@ 쿱[@ R<6@ rGE9@ 
L/@PH@33333@ߤ@
=q@iB@4֡a@*0@u@@@$/@~"@b}V@[W>@D@+J@&@As@*0U@L_@u%F@7KƧ@(@*0U@@m8@M:@ěT@K]@ 3@ @ Q@ 	@ xF]@ ҈@ ~($@ VϪ@ 
Ov`@ JM@ }Vm@F]d@?|h@:~ @@߾vȴ9@K]c@XbM@Q_@ ѷ@N+@*1@
(@lC@fffff@TɆ@C,@e+@5?|@]ce@ۥS@C,zx@[@cA @䎊r@u!@u!@'RT`@[6@쿱[W@ۥS@ݗ+k@As@~($x@y@@p
=@^5?|@%F
L@͞&@'@eO@vȴ9@wkP@*0@L/{@4m@@xF]d@m\@_?@T`d@QX@N;5X@G_o@@4m@:~@4j~@,C@%u@IQ@e+@&@bM@'/W@cA \@$/@/V@Y}@	k~@)@E@E@ᰊ@A [@c	@@@\)@A@x@'RT`@wkP@@*0@O\(@9D@ߤ@@ڹZ@5Xy@/V@j~#@?@ڹZ@˒:)@ NU@ hۋq@g@ᰉ'@RT`e@唯O
@`A7L@x@@%1@
=p@S&@ěT@څݘ@Z@74@dZ@-V@%1@sP@ڹY@F]c@}K]@x4֡b@t!-w2@kI^@aae@WsPH@P|@N+@@hۋq@@IQ@@n@@NU@>ߤ?@<Q@9~($@73@)x@!R<6@@ C@H˒@/V@hr!@ᰉ@g8}@4m@3@2X@ᰉ'@S&@u@e+@@=p
@:S@~
(@yrGE8@p ě@ffffff@Y+@Nߤ?@K'/@I'RTa@F
L/@@4m@;dZ@5'0@-8Y@)rGE@"M@/w@bM@xF]@64@l@}Vl@B@S&@@Țu%F@s@˒:)@+@SMj@ߤ@ᰊ@A [@B@x@@;dZ@/w@@`A7@v_ح@Q@H˒:@~vȴ9X@~
(@|n.@u!.@o{J#:@mC\@kP{@_	@Qu@NMj@D*0@<PH@3E@t@Ƨ@
L/{@
=p
@	Q@s@%2@$tS@@64@D@2W@VϪ@<쿱@q@C@C]@0
@^@>BZc@/@.H@ߤ?@kP|@ԕ*1@ڹY@@4n@s@1&y@Xy=@A@'R@-V@qu!@@@͞@qiC@JM@ѷX@~\N<@w3@lzxl"@_?@[q@X_F@Vl!-@OrGE9@H1&x@F@B74@;~$@3ߤ@1A [@.2X@,[W?@+U=@*g	@&'@"wkQ@"wkQ@cA @Y@t@:)y@	ԕ*@xl"h
@~($@=b@+jg@O;@>B[@<쿱@C]@rGE@ěT@}H@ۥS@:)y@Ж@а{@R@bM@@3@'RT@O
M@2X@\@/V@wk@	k@Ov_خ@kP|@@N@_@K]c@{J#9@y"`@s|@r䎊q@a@N@O\(@JD@FFs@@ѷX@:C\@2{m@.O;@$e@ -
@af@u%F@GE85@%2@1&y@
=p@_o@|쿱[@n.2@fIQ@S@N@G+I@ATɅo@6ȴ9X@0oiDg8@,zxl"@+jf@*g	@(r Ĝ@qu!@_@)^@S&@84֡@,zxl@u%F
@@PH@_ح@iB@\)@
=p@ѷX@˒:)z@Ǔݗ+@
L/@\N@\N<@b@C\@-V@Ov_@'RTa@g8}@u?@kI^@jd7@h\)@g,@^쿱[W@T`d@Q4J@M@I@As@<64@4#@4J@2m\@0
=q@0U2a|@/ hۋ@4D@/-V@!-w1@qi@Ft@Ňݗ@@sg@H@+a@M@u!@ݘ@Ʌoi@;5X@o i@~m\@vȴ9X@q-@m
qv@lzxl"@glC@ezxl"h@be+@\?@V8YJ@O'/W@BZc@0 ě@,"h	ԕ@)B@(	ԕ+@%S@#9@kP|@sh@X@o @
#9@y@@p
=@E@a@@o@b}@ҽ<64@tj@E@I^@u%F@;5X@*0@n.@&IR@:S@4m@~vȴ9X@|Z@{J#9@y"`@v!.I@v+jg@u%F
L@u'0@tm8@sE@qA [@e+a@W+j@M%@Iԕ*@>BZc @5Y|@2s@+a@@sP@Xe@Fs@ݗ@~($x@!-w2@ܬ1&@Z@䎊@ќu@|@͞%@Ƨ-@$/@K]@GE85@u!S@{J#:@@r@PH@m\@p:@p:@1&x@š@$/@NU@<64@"h	ԕ@|64@oVϫ@jJL@ix@i@ix@f@eS@eu@dqj@de@dZ1@a'R@\N;@H9Xb@=p
=@:>B@1[W>6@*d7@+C,z@%+a@#S@ 	k@N;@O;d@Mj@p:@p:@E@u!@+j@ݗ+k@̘_@qiC@)y@ᰊ@-V@2X@zG@[W?@*0U2a@쿱[W@"`B@bM@䎊@4J@@@@~$t@{A@{A@p@jg	@ZY@SMj@I^5?}@@4m@:G{@873@5'0@.t@*JL@&A@&A@)rGE@(@'/V@E@ 4m@6z@@@zH@	7KƧ@X@Ʌoi@$@vȴ9@Q@ߤ@@"`B@S@=K^@@@Xe,@$/@*0U@
L_@b@J@
=q@H@zxl"@6z@͞&@I^@~"@ᰉ'@0U2a|@ᰉ'@	k@A [@	k@5?|@ݗ+j@$@ۋq@ۥS@ۥS@ۥS@@8YJ@E@҈p:@s@"@J#9@!.@@~($@?@쿱[W@C,zx@e+@n@F]c@uXy=@qu!S@p@o4֡a@n.2@mC\@k~($@g/V@fIQ@fL/{J@a.H@`-
@_حV@^Ov_خ@]IQ@\wkP@[qu!@Y@Ush@Q@A [7@-8Y@,VϪ@#
=p@`d@	^5?}@s@{J#9@Z@~($@1@MjO@Vϫ@~"@ᰉ'@`A7L@>@0
)@u%F@`d@C@F]d@?|h@{m@
(@.2@C@>B[@hr!@(@6z@@N@ce@(\@c	@u%F@b}@>BZ@kP|@kP|@*0@ݗ+k@hr @*0U@qiC@p:@n@}p
=@|Q@{s@y(@sg@q@m(@ae@WO;d@U2a|@RT`d@P{@P)^@Oo @Ov_ح@Nߤ?@M@M@Oo @M5Xy>@JD@I@H@KƧ@Iԕ*@IoiD@G@@H@Fs@Dtj@;~$@2{m@2m\@+C]@#wk@,<@8YJ@sP@T`d@n@_@
qiC@
	 @	7KƧ@9Xb@	'RTa@	@@74@=b@ۋq
@/{J#@S@ߤ@@R<6@I^@*0U2a@*0U2a@n@~\N<@l"h	ԕ@l"h	ԕ@sPH@zxl"h
@xl"h	@n.2@m8Y@$xF@j~@JL@$@Ϫ͟@`d@|@Ϫ͟@C@	@%@vȴ9@[6@ae@/V@/V@\)@*0U2a@U=@q@B@zG@
qv@V@B@H@2X@Vϫ@m8@Xy=@@As@@T`d@ٳ|@b}@1'@Q_@Q_@څݘ@ק&@ק&@bM@ٳ|@ce@Gz@eO@ᰉ'@B@Z1@eO@唯O
@S@C,@M@ⶮ}Vm@ⶮ}Vm@@4@	@M@e@	@A [@e+@҈p@u!@حV@@4@Gz@A7K@5?|@>@5?|@حU@Z@R@͞%@Q@84֡@6z@}H@m\@o@
qv@a@@`A@IQ@nO@I^5?@ԕ*@ݗ@F]c@n.@x-
@n.2@dZ1@XD*@R䎊@KƧ@G@@E@=v@+U=@O;d@@	'RTa@
ڹZ@
.2@
@4@
҈p:@
KƧ@
3@
|@
[W>6@
}Vl@

qv@
a@@
xF@
'RT`@
'/W@
u%F
@
~($x@
sPH@
h@
eڹ@
e`A7L@
b@4@
\]ce@
ZY@
["`B@
Vaf@
T,<@
N_o @
M:@
L@
JW'@
HK]c@
I@
H@
H˒:*@
G)^@
F?@
Em\@
C,zxl@
@NU@
>
(@
9D@
:S&@
;/V@
4J@
,zxl"@
*0U2a|@
*d7@
(TɅ@
#9@
!-w1@
Xe,@

O;dZ@
tj@
      @G{@l"h	@@7@҈p@5?|@ݗ+j@W>6z@حU@ק&@Ϫ͟@ԕ*1@Z@Z@N;5@*0U@v_ح@Ƨ@W'@]cf@2W@7Kƨ@
(@}H@m8@a|Q@U=@-
@	@-
@-w1@쿱[W@tj~@o h@kC,z@j~"@irGE@j~"@j~"@hۋq
@Q@=p
=@:)y@9XbM@7rG@5Xy=@Q@*0@$tT@@K]d@n.@ ѷX@E@(@GE85@䎊q@A [@8}H@W>6z@D*@т@p:~@/{J#@TɅo@1@0
@Ov_خ@bM@L_@y=b@jOv`@a|Q@Y>BZ@Y+@UfA@L_@H@E84֡@Dg8}@C@C,zxl@Ca@N@C,zxl@>
(@=<64@;A@9~($@64K@12W@.H@-U=@,<쿱@}H@vȴ@@@Ov_@'/W@
	 @K]d@
qiC@S&@n.@
#x@
Y|@
c	@
빌~($@
ݗ+j@
>@
b}@
҈p:@
+@
n@
74@
H˒:@
D@
|@
ᰊ@
Vϫ@
S@
R<6@
S@
4J@
'/@
n/@
|?@
u\(@
r ě@
oiDg8@
iB@
^5?|@
W@
R䎊@
O
M;@
K:)z@
F]cf@
C\N@
@6@
>6z@
9#w@
-V@
*0U2a|@
*0U2a|@
'RT`e@
!o@
䎊r@
IQ@
+j@

(@
xF]@
'/@
~($x@

@

(@
~($x@
nP@	73@	A [@	څݘ@	
=p@	䎊@	*0@	33333@	}Vl@	B@	zxl"@	6z@	I^@	^@	0U2a|@	'@	9@	/@	S&@		k@	S@	$tS@	 ѷ@	tj@	$/@	~\N<@	}!.H@	{~$@	rs@	bM@	M:@	A7Kƨ@	=b@	=v@	<n.@	8Q@	-V@	@	I^5@	 hۋq@	$/@E@J#9@-
@73@!.@!-w2@A [@{m@쿱[W?@~"@1.@	@@N@5?|@ܑN;@>BZ@ק&@>6z@՛=K@,<@m@H@_o @K]c@@5Xy@#w@z@J@-V@U2a|@O
M@2X@1&y@@h	ԕ@-
@!-w1@u@@@YJ@z>B@}ڹZ@{~$@y=b@sPH@mhr!@^@TɅoi@SMj@W@N;5X@B74@4J@%zxl"h@ߤ@@,<@IQ@@+@E@iDg8@.2@"`B@T`d@_o @Ƨ@E84@74@BZc @#w@ᰊ@y@tSM@o@-V@sP@Q@@}ڹZ@|#x@n.2@hr Ĝ@Xy=c@SZ@PH@KƧ@F-@A [7@<n.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @@-
@@IQ@@d8@@U@@@@@
(@@U@@U@@IQ@@-
@@u%F@@{@@4m@@TɅ@@D@@C@@PH@@	@@@@ѷX@@p:@@	A [@@	-@@	R<6@@
u%F@@\N@@
}H@@;dZ@@*0@@G{@@:)z@@/{J#@@[@@
=p@@|Q@@䎊@@#9@@?@@u@@!o@@%[@@(l"h	@@+a@@@/$tS@@=w1@@O@@@h	k@@m5Xy>@@nMj@@p)@@rQ_@@t9XbN@@u5Xy>@@y'RTa@@Q@@q@@҈p@@~$@@j~#@@O;dZ@@8YK@@%@@Xe,@@-@@@@@N@@6z@@@@zG@@$tT@@nP@@҈@@Z@@D*@@\(@@=p
@@~@@<쿱@@ce@@ڹ@@qi@@t@@ѷX@@64@@őhr!@@vȴ9X@@!.I@@@@bM@@u!@@ [7@@Y}@@@@̹#x@@L_@@ϊ	@@GE85@@Ӂ@@ߤ@@@Ձ$/@@E84@@bM@@NU@@bM@@)^@@=p
@@҈@@܄?@@L/{J@@Ϫ͟@@E84@@ߍO;d@@fA@@
(@@hr @@)_@@/V@@
=p@@L_@@_ح@@}H@@)^@@&x@@JE@@e+a@@#9@@꩓@@sP@@~@@C,z@@&@@tj~@@eO@@eO@@믷@@Ƨ@@tj@@M:@@N;@@7@@JM@@qu"@@\@@퇓ݗ@@-V@@(@@fffff@@@@6z@@t@@Mj@@8}H@@kP@@@@-@@D*@@4m@@Q@@>BZ@@	 @@0U2a|@@xl"h
@@n@@u%@@F]c@@:)z@@@@1&y@@,<@@PH@@`d@@j~#@@?@@@@+a@@+a@@5Xy>@@84֡@@O;dZ@@jOv@@p
=@@w1@@ݗ@@=K@@%@@v@@U=@@U=@@\(@@@@,=@@@@?@@H@@&I@@y@@O;d@@$tS@@[W>@@@@@@*0@@NU@@˒:*@@ [7@@u@@l@@N;6@@iB@@e@@>BZ@@R@@@@R@@@@@@)y@@^5?|@@p:@@D@@C,@@D@@6z@@Z@@eO@@U=@@q@@҈@@\N@@ߤ@@@@@tj@@!-w2@@tj@@tj@@Q@@/{J#@@?@@PH@@VϪ@@]ce@@VϪ@@M:@@`d@@g8}@@g8}@@qj@@[W?@@u"@@@@Q@@%F
L@@84֡@@F
L0@@B@@S&@@O;dZ@@ce@@`A7L@@`A7L@@m\@@M:@@ڹZ@@%@@Xy=@@v@@v@@1@@sh@@H˒@@cA @@b@@,=@@C\@@ڹ@@ ѷY@@4K@@($x@@BZc @@?@@8YJ@@H@@Vu@@l!-@@p:~@@vȴ9X@@%@@+J@@+J@@@@@@@@,<@@@@}Vl@@}Vl@@Q@@ߤ?@@m\@@A@@+@@+@@Ϫ͟@@ߤ?@@1@@"@@"@@Ft@@$tS@@4֡a@@;dZ@@O
M@@RT`e@@_o@@@@-V@@kP@@	k@@zH@@3@@r@@@@K]d@@+@@˒:)@@;dZ@@rG@@rG@@;dZ@@@@@rG@@Vϫ@@-@@rGE9@A      @A @A 	ԕ+@A bM@A @A -
q@A >BZc@A Q@A _F@A eO@A eO@A u!@A ˒:*@A YJ@A @A @A 
=q@A d8@A 9Xb@A 
(@A ěT@A F@A {@A	k~@A$/@ArGE@A+@A@A-w1@A-w1@A4J@AN;5@AXbM@A^@Aae@Ae+a@Ae+a@Ahr @Au!S@A@Ab}@AoiD@A~($@Au@A(@A|@A"`@Aᰉ'@A"`@Ae@A-@AlD@A.H@Au%F@AI^5@A#9@A&IR@A0U2a|@AGE85@AJL@AQ_@AM@AW'@AL_@AS&@AS&@AS&@AwkQ@AS&@AY@AY@An@A@AsP@Ac	@Am\@As@AC,z@A,zxl@A33333@A9@AxF]@AMj@AeO@Aq@Aߤ@A@A6@Aa@O@AC]@Aݗ+k@A҈@AQ@A҈@ASMj@A_@A/@Au@A5Xy>@A\@Azxl"h@Av@A@A8YK@Aڹ@A
L/@Au@AOv_@A!R<@A.2@Ac	@A@AQ@Am\@Am\@AA@AA@A+@A1@A"@A)^@A;dZ@AO;d@A-V@AzH@A@A@AK]d@A@AحV@A@@A䎊r@A}H@A>BZc@AQ@AYJ@A@A@A
=q@Ad8@A)@AD@Aۋq
@A@A4֡b@A	$/@A	@A	rGE@A	@N@A	rGE@A	@A	_p@A	_p@A	+@A	@A	A [@A	rGE8@A	R@A
0U2a|@A
@4n@A
^5?|@A
xl"h
@A
vȴ@A
g	@A
Y@A
W@A
fB@AI^@A&@A@N@Aa@N@A~$@AeO@AMj@AS@Am]@A6@AQ@A$@Aߤ@@ASMj@A[W?@A?@A?@A*0@A/@A!-w@A
Q@A
(@A
?|h@A
?|h@A
Vl!@A
Y|@A
fA@A
w1@A
ڹZ@A
v@A
cA @A
,=@A
ڹ@AOv_@A.2@A5?|@Ac	@AT@A}Vl@A@A'@A@Aߤ?@AA@A+@AC-@A@A hۋ@A@A@AFt@A
=p@A
M;@AXe@A>6z@Ay@A-V@AzH@Ar@Ar@A˒:)@A@A$tS@AU=@A	@AbM@A@AA7K@A ě@A>BZc@AA7K@A_F@Al"h	@AYJ@A
=q@A9Xb@ATɅ@AGz@A^@A7Kƨ@Aԕ*@A>BZ@A)y@Aݘ@A@A͞&@AڹY@AfB@Am\@As@A҉@AI^@Aqu!@Aa@N@A~$@AS@AE@Aݗ+k@Atj@A64@AwkP@Au"@AE@Aqu"@A(@AO;dZ@A-V@AH˒@AcA @AS@Ab@At@ABZc @AE@ABZc @AVu@AOv_خ@A1.@ABZc @A+J@A6z@A&I@Aȴ9X@Am\@Aߤ?@A@A;dZ@AlC@AsPH@AsPH@Ay@A|hs@AO;d@A˒:)@A@A@@AF]d@AbM@A*0U@A'RT`@ANU@Ahۋq@An@A@ATɅ@AѷX@A)@A)@Ad8@AIQ@Atj@Atj@A'RT@AYJ@A'RT@A@AěT@A҈p@A+@A0
)@A7KƧ@A+@A&x@AGz@AJE@A7Kƨ@A^5?}@A1'@A=p
@A{m@Ag	@An@Ag	@A ѷ@A'/@A"`B@A33333@A6z@AJ#9@AW>6z@A{J#9@AS@Aa@O@A5Xy@A
=p@A҈@A$@AC]@AA [@A\N@A1&y@A\N@An.@Atj@A64@AI^5?@AZ1@AZ1@Ag8}@AcA \@Aj~#@Aq@AtSM@Aqj@A쿱[@A3@A@AE@AQ@A+a@A<64@AS&@Am\@A$/@AO
@Av@AU=@A@A
(@A_ح@Ap:~@Avȴ9X@A}Vl@A@A@AO;@A2X@A'@A@Am\@At@A҈p;@A҈p;@Aߤ?@Aߤ?@A쿱[W@AFs@A@A1@AsPH@A$tS@A?@A/V@A-@A @A 	ԕ+@A 
qu@A @A }H@A }H@A *0@A -
q@A 4m9@A 4m9@A :~ @A 4m9@A 1&x@A A7K@A H@A hۋq@A y=c@A YJ@A {@A ěT@A D@A {@A!	k~@A! [7@A!4J@A!Q@A!e@A"u%F@A"Ov`@A"&IR@A"6C@A":)y@A":)y@A"6C@A":)y@A"u%F
@A"G{@A#s@A#jf@A#6@A#C]@A$<쿱@A$VϪ@A$`d@A$q@A$o h@A$?@A$@A$hr@A%S&@A%@A%,=@A& ѷY@A&!R<@A&+jg@A&($x@A&1.@A&5?|@A&8YJ@A&BZc @A&?@A&Ov_خ@A&Vu@A&fffff@A&iB@A&c	@A&p:~@A&s@A&z@A&z@A&@A&T@A&m\@A&+@A&ߤ?@A&"@A'Ft@A'!-w1@A'1@A'>6z@A'E84@A'Xe,@A'iDg8@A'4m@A'4m@A'O;d@A'@A'kP@A'-V@A'zH@A';dZ@A(     @A'rGE9@A'Vϫ@A'@A'䎊r@A(@A(r Ĝ@A(bM@A('RT@A(y=c@A(-
@A(-
@A(4m@A(ۋq
@A)$/@A)+@A)JE@A)Dg8~@A)[W>6@A)Gz@A)4J@A)&x@A) [7@A) [7@A)0
)@A)Dg8~@A)k~(@A)hr @A)^@A)ae@A)u!S@A)o@A)@A)ԕ*@A)e@A)@A)e@A)ᰉ'@A)-@A)@A)lD@A*u%F@A*	 @A*s@A*s@A*1'@A*:)y@A*Q_@A*n@A+&@A+S@A+S@A+U=@A+A@A+A@A+ߤ@A+*0U2@A+@A+q@A+*0U2@A+*0U2@A+E@A+@A+C]@A,1&y@A,g8}@A,tSM@A,C@A,N;@A,o h@A,N;@A,*1@A,*1@A,_@A,*1@A,*1@A,*1@A,S@A,쿱[@A,S@A,S@A,3@A,1&@A,TɆ@A,TɆ@A,쿱[@A,TɆ@A,TɆ@A,1&@A,?@A,1&@A,[W?@A,*0@A,Z@A,/@A,JM@A,!-w@A-K]@A-qu"@A-/w@A-5Xy>@A-F
L0@A-O;dZ@A-ce@A-sg@A-hr!@A-Xy=@A-@A-Xy=@A-1@A-sh@A-n/@A-8Y@A-sh@A-Xy=@A-@A-%@A-1@A-H˒@A-Ϫ͞@A-8YK@A-,=@A-ᰉ@A-oiDg@A.
(@A.;5X@A.YJ@A.,<@A.]cf@A.1@A.C-@A.x@A.Mj@A.!.I@A/
=p@A/,@A/.H@A/O
M@A/\(@A/b}V@A/ݗ+@A/vȴ9@A/o @A/o @A/@A/@A/fA@A/rG@A/rG@A/-@A0
qu@A0	ԕ+@A0@A0bM@A06@A0bM@A0bM@A0*0U@A0}H@A0$xG@A0'RT`@A0A7K@A0K]c@A0Xy=@A0r Ĝ@A0-
@A0@@A0D@A0@A0\)@A0$tT@A1#w@A1*0U2a@A10
)@A1N;5@A1x@A1o@A1o@A1o@A1u      @A1ԕ*@A1iB@A1ᰉ'@A1iB@A1R@A1@A1s@A1Y}@A1.H@A1lD@A1Y}@A1lD@A2n@A2n@A2@A2s@A2#9@A20U2a|@A2@4n@A2JL@A2^5?|@A2d7@A2nO@A2xl"h
@A2vȴ@A2@A2L/{@A2L/{@A2>B@A2<64@A2}Vm@A2g	@A2@A2 ě@A2>B@A2g	@A2g	@A2 ě@A2}Vm@A2<64@A2}Vm@A2<64@A2W@A2 ѷ@A2 ѷ@A2fB@A2C,@A2m\@A3S&@A3'/@A3PH@A3&@A3"`B@A3,zxl@A3/V@A3C%@A3Z@A3~($@A3a@@A3ݗ+k@A3҈@A3A [@A4ߤ@@A41&y@A4tj@A4!-w2@A4(\@A464@A464@A4I^5?@A4S@A4쿱[@A4쿱[@A4TɆ@A4j~@A4Ʌoi@A4֡a@A4@A4E@A5!.H@A5IQ@A5zxl"h@A5$/@A5}H@A5ݗ@A5=K@A5@A58YK@A5
qv@A5ᰉ@A5!.@A5C\@A6 ѷY@A5ڹ@A6
(@A6@A6!R<@A6.2@A6H@A6\N<@A6l!-@A6%@A6Fs@A6@A6ߤ?@A6m\@A6ȴ9X@A6+@A6+@A6C-@A6Mj@A6Fs@A7Ft@A7)^@A7)^@A7v@A7'/W@A7$tS@A7'/W@A7As@A7O
M@A7eں@A7	@A7-V@A7&@A7zH@A7˒:)@A7حV@A7;dZ@A7-@A7-@A7䎊r@A7#@A8F]d@A8@A8$xG@A8$xG@A81&x@A873@A873@A873@A8A7K@A8D*@A8NU@A8Xy=@A8_F@A8_F@A8hۋq@A8oiDg8@A8u!@A8u!@A8|@A8-
@A8d8@A8{@A8ѷX@A8ѷX@A8F@A8\)@A9@A9#w@A9+@A9 [7@A9&x@A9*0U2a@A9=b@A9=b@A9JE@A9XbM@A9JE@A9Q@A9XbM@A9ae@A9e+a@A9x@A9oiD@A9~($@A9o@A9o@A9R<6@A9n.@A9D@A9>BZ@A9lD@A:u%F@A:u%F@A:	 @A:1'@A::)y@A:xl"h
@A:{m@A:~"@A:{m@A:@4@A:L_@A:L_@A:\(@A:S&@A:ᰊ@A:vȴ@A:vȴ@A:g	@A:Y@A:Y@A:n@A:n@A:)_@A:W@A:͞&@A:`A@A:`A@A:,<@A:,<@A: ѷ@A:G{@A:fB@A:c	@A:~@A;I^@A;҉@A;'/@A;nP@A;nP@A;s@A;C,z@A;"`B@A;"`B@A;)^	@A;6z@A;/V@A;6z@A;6z@A;J#9@A;dZ@A;{J#9@A;q@A;~$@A;eO@A;:)z@A;S@A;6@A;@A;Ƨ@A;5Xy@A;ݗ+k@A;g@A<n.@A<!-w2@A<,<@A</{J#@A</{J#@A<]ce@A<zG@A<?@A<#@A<N;@A<?@A<[W?@A<7@A<?@A<@A</@A</@A<JM@A<e@A=K]@A=u@A=*0@A=!.H@A=<64@A=L_@A=L_@A=Y|@A=Y|@A=p
=@A=M:@A==K@A=Xy=@A=-V@A=@A=\(@A=cA @A=                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @r33333@r     @r33333@r@r@r!@r     @r@r     @r     @r@r@r@r@r	@r@r@r@r      @r@r     @r     @rfffff@r@q@q@q33333@qfffff@q     @q     @q@q@q|@qx     @q33333@q33333@qy@q      @p@p@p^fffff@oC33333@l33333@m@n33333@n\@g&fffff@f     @g     @gs33333@h@i@i33333@dfffff@dY@d333333@d)@dI@d     @e@ey@c@c陙@c@c@c<@bə@b`     @bVfffff@b33333@bvfffff@as33333@`     @`33333@`fffff@`@`vfffff@`     @`@`@`33333@`@``     @`C33333@`S33333@`\@``     @`@`fffff@`@`fffff@`,@`#33333@`,@`Ffffff@`333333@`33333@_@_@_33333@_fffff@`33333@^@_333333@^33333@^33333@_      @_fffff@]     @]33333@]@]@]     @]9@\fffff@[@Yfffff@Xl@X@XFfffff@Xy@XS33333@X&fffff@Xfffff@W33333@X      @W@Wٙ@W@W@W@W@W     @W@Ws33333@W9@V@W333333@W,@W      @V33333@V@V@Wfffff@Vfffff@Vfffff@V@V@V@V@Vٙ@Wfffff@Vfffff@Vfffff@Wfffff@Vٙ@Vfffff@Vٙ@V     @Vfffff@Vfffff@V33333@Vٙ@V@V     @Vfffff@V@V     @V@V@V@V33333@V@V33333@Vfffff@V@V@Vٙ@Vfffff@V@V33333@V@Vfffff@Vfffff@V     @V@Vfffff@V     @Vfffff@Ws33333@X33333@X@Y@Xٙ@X@X`     @Xy@XY@Xfffff@Wfffff@W     @W     @W@Ufffff@U@Ul@U`     @U`     @UL@UL@UL@US33333@UL@UFfffff@U333333@U      @UY@U333333@UY@T@T@Tٙ@U@Tfffff@T     @Ufffff@Tٙ@T33333@Tfffff@T@Tٙ@T     @T@Ts33333@T@T33333@T     @T33333@T33333@T@T@Tfffff@T@Ts33333@Tl@T9@TS33333@TFfffff@TS33333@T333333@S@S     @S@Sfffff@S33333@S33333@Sfffff@S     @S33333@S33333@S@Sfffff@S     @Ss33333@Sfffff@S@S@Sffffff@Ss33333@S@Sffffff@SY@S9@SFfffff@S@SS33333@S&fffff@S33333@Rfffff@S@R@Rfffff@R@Rfffff@R@Rfffff@R@R@R@R33333@R33333@R@Ry@Rfffff@R     @Rffffff@RY@RY@R@     @Rffffff@R333333@R@     @R9@R9@Rfffff@R9@Rfffff@Q@Q     @Q@Qٙ@Q     @Q@Q33333@Qfffff@Qfffff@Q@Qs33333@Q@Q`     @Qy@QFfffff@QS33333@Qy@Q333333@QFfffff@Qffffff@Q@Q9@P@Q@     @Q      @QFfffff@Q@     @Q@     @Qfffff@Q&fffff@Q33333@Q@Q@P33333@P@P@P     @P@P@Pfffff@P33333@P33333@P@Py@Pfffff@P33333@P     @P     @P333333@PY@P,@P,@P@P@     @P      @P@P      @P      @Os33333@Pfffff@Pfffff@OY@Oٙ@O@O@Oٙ@P      @OY@O     @OL@OL@N33333@O333333@O@O@N     @Nٙ@Nffffff@N33333@Nfffff@N33333@N     @NY@N@     @NY@N     @Mٙ@NL@Nffffff@M     @M@Mٙ@M@N@M33333@N@M@MY@Mffffff@M@M@Lٙ@L@Lfffff@M      @L333333@M@M      @L@     @L@L      @LL@Kfffff@K@K33333@K     @K     @K@K@     @J@JY@J33333@J33333@Hfffff@H@HY@HY@H      @H     @H33333@Hffffff@Gfffff@G@H      @G33333@G@G@Gs33333@G333333@G333333@G     @GY@F@Ffffff@G@F     @F@F&fffff@Fffffff@FL@F@Dfffff@E     @Efffff@E33333@E     @F      @E@D@Dٙ@D     @D@Dٙ@E@EL@DY@D     @D@D@D333333@C33333@DL@D&fffff@Cٙ@C     @Cfffff@C@D@C33333@D333333@Cfffff@C@Bfffff@B@Bs33333@B&fffff@B333333@B&fffff@B@B@A33333@A@A@A@A@Afffff@A@@ffffff@@33333@AL@@33333@A333333@@333333@@ٙ@@fffff@?fffff@@fffff@@     @@@@@     @?fffff@?@@@     @?ffffff@?@?      @?@>33333@?@?333333@>@>@>      @=     @>L@>@>L@>L@<fffff@=ffffff@>      @>@=L@<      @=L@<fffff@<ffffff@<fffff@=      @<fffff@<ffffff@<      @<@<fffff@<@<      @<ffffff@<ffffff@;ffffff@<      @<333333@;@;ffffff@;@:     @:@:     @:333333@:@:33333@;@8      @:L@9fffff@9@9@8fffff@9@9@9      @9@9@8      @733333@7@733333@7333333@7@7L@7     @7     @6fffff@6@7      @633333@6333333@6      @5@533333@5@5@5     @4fffff@5@5L@4L@5@5L@3L@5      @3      @4ffffff@3@3@3fffff@2fffff@3@3333333@3     @3333333@3@3     @3@2@2ffffff@3      @3333333@2     @2L@1      @2@2     @2@2     @2@1@1@2@2      @2@0fffff@1fffff@0ffffff@1@0fffff@1      @0ffffff@0@1@0ffffff@0@.@0@0333333@0      @0L@0      @0ffffff@0L@/ffffff@/@/ffffff@0@.@0@-      @0@/      @/ffffff@.ffffff@/333333@.@.      @.@-@.      @2L@-333333@-ffffff@.ffffff@-ffffff@-@-333333@,ffffff@-333333@,333333@,@,333333@*@,ffffff@+@,      @+@+ffffff@,333333@,333333@+ffffff@,333333@*ffffff@,@*@*@+@+333333@+@+@+@+ffffff@+333333@+@*ffffff@)@+      @+      @+      @*@+ffffff@*@*      @)@+333333@)333333@(@)      @*      @(@*ffffff@)333333@(@)333333@)@)      @'333333@)      @(@)      @(ffffff@(ffffff@(      @&@)@'333333@'333333@'      @(ffffff@(333333@'ffffff@'@'@'@&      @%@(333333@'@'ffffff@'ffffff@&      @&ffffff@(      @&ffffff@%@$@&@&@&@'      @&@&@&@'333333@%@'      @%@&ffffff@&      @$ffffff@&      @&      @%@%333333@%ffffff@%      @&ffffff@$@%333333@$      @$@%333333@"@$333333@$@%      @$ffffff@#333333@#@%333333@#@#@$@$ffffff@$@"333333@#@#ffffff@$      @#333333@#@#@#@#@#333333@#@#@"@$      @!333333@$@"      @'@"@%@"      @$333333@#      @#333333@#333333@#      @#333333@#333333@#333333@"@$      @#333333@"@"      @"ffffff@#333333@"      @$333333@!333333@$333333@%      @"333333@#@"333333@"@#      @#333333@"@#@!@#333333@#333333@"333333@#ffffff@"ffffff@"@"@"@"@"@"@"@"@!333333@#      @#      @!@#@"@#ffffff@#ffffff@"ffffff@#@#      @!ffffff@$333333@"@#      @#      @#      @"@#333333@#      @"ffffff@"@#ffffff@#      @#333333@#      @"ffffff@$333333@%333333@$333333@"      @%333333@#@"@$333333@#@#@#@#@$ffffff@#@#@#333333@$ffffff@$@#@$333333@!ffffff@#ffffff@$      @%333333@"@%ffffff@$      @#@$@"@$      @$@#333333@$333333@$333333@"@$@$ffffff@#ffffff@$333333@$      @$@#ffffff@%ffffff@#333333@#@$ffffff@$ffffff@"      @&333333@"@$      @"@$      @$333333@$ffffff@#333333@$@#ffffff@"333333@%333333@#333333@#ffffff@#@#ffffff@$      @#@$      @#333333@$      @#333333@$333333@$333333@#ffffff@#333333@$333333@#@$      @#@#@$      @$ffffff@#@$      @#ffffff@$      @#@%@"@$@'333333@!@%333333@#      @&@!@&333333@$ffffff@%@#@$333333@$ffffff@$@$333333@$@$      @$@"333333@&333333@%333333@%      @$333333@%@$@%      @$333333@$@%@%@)333333@!@#      @)ffffff@#ffffff@%333333@%      @&@$ffffff      @%@%@'ffffff@#      @%333333@'@#@"ffffff@%333333@'@$333333@%@#      @#333333@$@(      @%ffffff@%      @&333333@%@&333333@%      @'@%333333@&333333@&ffffff@&ffffff@%@&@%ffffff@&      @&      @&      @&      @&333333@&      @&      @&      @&      @&      @&ffffff@%@&      @&      @&      @&      @&      @&      @&      @&      @&      @'      @&      @&@&333333@$333333@(      @%333333@'@'333333@'@&@'@'      @(ffffff@&      @'      @'@'ffffff@'@$ffffff@*ffffff@'ffffff@'ffffff@(      @(ffffff@&@(ffffff@(ffffff@)@(@)      @(ffffff@)@)@)333333@(@)      @)@)@)@,      @'333333@+333333@(@(@*      @1      @+      @*ffffff@&      @,ffffff@*@+333333@)@*333333@-333333@)@+@,@*@+ffffff@*@+333333@,333333@*ffffff@+@+@+      @+@+@*@+333333@,      @-@)@-      @,@-      @+333333@-333333@+333333@0      @+      @-333333@,@,@,@,@+@-      @,@,@,@,@,@,@-ffffff@,ffffff@.@*@.@.333333@-      @-@-@-ffffff@.      @/333333@.@,333333@/@/      @.      @.      @-@-@.333333@.ffffff@-333333@/      @.333333@/      @/      @/ffffff@.ffffff@.@.ffffff@.ffffff@.@/@/@0@-333333@033333@/333333@/333333@0333333@.@/@/@0fffff@0     @/@1@1L@/@0fffff@0L@0L@0     @0@0@0@0@/ffffff@1ffffff@1@0@1@0@0fffff@0@0@033333@0fffff@033333@0@0@2333333@1ffffff@033333@1L@1L@/333333@1      @1      @1      @033333@1L@1      @1@1@1L@1@0     @2@2@2fffff@3@0fffff@2L@0ffffff@2333333@2ffffff@2333333@2333333@2fffff@2@2@233333@2@1@2@4      @2L@3      @3      @2fffff@2fffff@3      @3ffffff@333333@3L@3@3      @333333@3@3@5ffffff@3333333@3333333@4@4fffff@433333@4@5      @4333333@4@4333333@4@4@433333                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ?;dZ?E?lC?E?ffffff??"`?vȴ?nO;?Q?5?|h?x?lC?-?Ƨ-?nO?$/?$/? ěT?QR?$/?-V?-V?-V?nP?bM?C%?ꗍO;d?5?|h?5?|h?+?|hr?E?\(?柾vȴ9?M?E?ěS?㕁$/?C$?E?I^5?}?n?߾vȴ9X?޸Q?vȴ?? ěT?(\)?(\)?1&x?ӕ$/?(\)?(\)?333333?1&?љ?Гtj~?O;dZ?m?1&x?1&?"`A?͑hr ?(\)?O;dZ?C$?I^5?ȴ9Xb?tj?tj?`A7K?l?333333?Q?Q?ěS?      ?hr Ĝ?      ?|hr?nP?      ?      ?`A7L?1&y?E?      ?
=p?E?vȴ9X?lC?E?/v?lC?lC?-V?lC?lC?lC?lC?S?+?XbM?lC?lC?lC?lC?vȴ9X?lC?lC?XbM?1&y?E?^5?|?lC?S?XbM?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?/v?lC?lC?lC?lC?j~"?j~"?lC?lC?lC?"`A?XbM?j~"?1&y?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?+?vȴ9?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC??^5?|?Gz?lC?lC?lC?lC?lC?+J?lC?"`A?Gz?1&?lC?^5?|?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?dZ1?XbM?+J?dZ1?lC?lC?j~"?p
=q?lC?lC?lC?/v?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?QR?S?lC?lC?lC?"`?lC?lC?lC?+J?^5?|?lC?lC?lC?lC?lC?1&y?lC?lC?lC?XbM?lC?lC?lC?lC?^5?|?+?lC?lC?lC?lC?vȴ9X?(\)?lC?/v?p
=q?lC?lC?E?lC?lC?lC?lC?lC?lC?lC?lC?1&??lC?p
=q?1&y?Gz??lC?lC?lC?lC?lC?j~"?1&y?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?hr!?dZ1?1&?lC?lC?lC?E?"`A?lC?lC?lC?E?lC?/v?bM?lC?p
=q?lC?"`?(\)?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?p
=q?(\)?Gz?"`A??lC?p
=q?1&y?vȴ9X?(\)?lC?lC?lC?lC?lC?1&y?/v?lC?vȴ9X?"`?lC?lC?lC?lC?lC?lC?p
=q?-V?5?|h?lC?lC?lC?5?|h?1&y?      ?E?p
=q?lC?5?|h?j~"?p
=q?lC?lC?lC?lC?lC?lC?1&y?5?|h?/v?lC?p
=q?lC?E?lC?lC?lC?5?|h?hr!?lC?lC?lC?lC?lC?lC?lC?p
=q?      ?hr!?lC?lC?vȴ9X?lC?lC?lC?lC?lC?lC?Q?      ?vȴ9X?lC?p
=q?p
=q?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?"`?      ?lC?^5?|?5?|h?-V?hr!?lC?lC?lC?lC?;dZ?lC?lC?lC?5?|h?lC?lC?-V?p
=q?lC?lC?1&y?vȴ9X?lC?lC?5?|h?(\)?E?-V?lC?lC?lC?lC?lC?lC?(\)?E?lC?lC?lC?lC?hr!?hr!?lC?1&y?vȴ9X?lC?lC?lC?lC?lC?p
=q?1&y?(\)?      ?5?|h?5?|h?1&y?p
=q?lC?lC?lC?lC?lC?lC?1&y?5?|h?lC?lC?lC?"`?lC?lC?lC?j~"?Q?lC?5?|h?lC?Gz?      ?Q?lC?p
=q?lC?lC?lC?1&y?p
=q?lC?lC?lC?5?|h?lC?p
=q?E?lC?lC?vȴ9X?7KƧ?-V?      ?5?|h?lC?-V?p
=q?lC?lC?lC?E?j~"?      ?vȴ9X?1&y?/v?lC?lC?5?|h?;dZ?      ?;dZ?-V?/v?p
=q?      ?S?lC?/v?5?|h?lC?lC?lC?1&y?      ?;dZ?lC?lC?lC?vȴ9X?1&y?E?lC?Q?lC?lC?(\)?5?|h?|hr?-V?hr!?lC?lC?lC?5?|h?lC?E?p
=q?-V?p
=q?      ?E?lC?5?|h?lC?lC?E?"`?lC?lC?lC?E?lC?-V?E?hr!?/v?j~"?Q?vȴ9X?E? ěT?p
=q?hr!?lC?lC?"`?lC?lC?E?lC?      ?1&y?;dZ?1&y?ěS?
=p?      ?lC?"`?1&y?lC?      ?vȴ9X?lC?5?|h?
=p?lC?-V?-V?hr!?5?|h?lC?E?-V?p
=q?Q?Q?;dZ?      ?1&y?lC?vȴ9X?E?-V?p
=q?      ?(\)?5?|h?lC?lC?lC?E?;dZ?lC?vȴ9X?lC?lC?lC?"`?GzH?-V?lC?p
=q?/v?vȴ9X?p
=q?hr!?-V?;dZ?-V?p
=q?vȴ9X?$/?"`?1&y?1&y?lC?|hr?lC?vȴ9X?5?|h?p
=q?vȴ9X?(\)?5?|h?vȴ9X?1&y?|hr?E?lC?/v?lC?5?|h?1&y?;dZ?lC?lC?lC?"`?ěS?lC?lC?lC?lC?vȴ9X?-V?      ?      ?lC?lC?lC?vȴ9X?lC?lC?lC?;dZ?j~"?      ?      ?lC?Q?lC?;dZ?Q?bM?lC?      ?      ?/v?lC?lC?lC?vȴ9X?lC?lC?j~"?vȴ9X?lC?lC?lC?Q?      ?|hr?lC?E?Q?E?-V?-V?/v?lC?lC?|hr?      ?E?-V?"`?      ?E?      ?      ?hr!?lC?"`?E?5?|h?vȴ9X?      ?j~"?      ?/v?p
=q?lC?p
=q?E?"`?5?|h?hr!?lC?-V?      ?|hr?p
=q?-V?`A7L?A7Kƨ?`A7L?$/?      ?      ?vȴ9X?lC?lC?      ?vȴ9X?5?|h?vȴ9X?lC?vȴ9X?vȴ9X?vȴ9X?      ?$/?vȴ9X?5?|h?"`?lC?nP?hr Ĝ?lC?lC?      ?      ?      ?      ?E?vȴ9X?lC?"`?lC?lC?|hr?      ?      ?      ?      ?1&y?lC?lC?lC?"`?      ?(\)?"`?      ?(\)?lC?lC?7KƧ?Q? ěT?      ?|hr?-V?lC?lC?lC?;dZ?lC?lC?j~"?;dZ?-V?      ?      ?(\)?(\)?      ?lC?A7Kƨ?hr!?      ?      ?      ?E?/v?      ?E?lC?lC?5?|h?(\)?`A7L?p
=q?E?p
=q?/v?1&y?p
=q?7KƧ?      ?      ?p
=q?      ?      ?      ?;dZ?lC?lC?;dZ?      ?Q?5?|h?/v?GzH?      ?      ?      ?E?(\)?      ?      ?      ?lC?      ?      ?      ?vȴ9X?(\)?      ?      ? ěT?      ?5?|h?E?lC?/v?|hr?j~"?;dZ?
=p?hr!?lC?      ?&x?bM?-V?Q?5?|h?      ?lC?E?lC?E?p
=q?-V?1&y?lC?;dZ?-V?lC?lC?
=p?Q?-V?hr!?lC?lC?lC?;dZ?      ?      ?      ?      ?-V?vȴ9X?      ?      ?1&y?      ?;dZ?lC?lC?vȴ9X?"`?lC?lC?nP?`A7L?      ?      ?      ?hr!?lC?"`?"`?;dZ?      ?/v?A7Kƨ?$/?      ?      ?      ?`A7L?(\)?"`?lC?lC?lC?      ?      ?      ?      ?      ?      ?Q?hr!?      ?      ?      ?      ?|hr?lC?lC?lC?lC?lC?lC?lC?lC?/v?      ?lC?lC?"`?-V?      ?      ?GzH?      ?E?/v?      ?E?j~"?A7Kƨ?;dZ?;dZ?      ?      ?E?;dZ?|hr?;dZ?p
=q?      ?      ?      ?/v?(\)?E?p
=q?      ?nP?hr Ĝ?      ?lC?lC?lC?1&y?;dZ?p
=q?      ?lC?;dZ?      ?(\)?Q?      ?      ?(\)?lC?vȴ9X?-V?/v?vȴ9X?E?lC?lC?p
=q?lC?vȴ9X?vȴ9X?1&y?      ?vȴ9X?lC?j~"?      ?E?/v?hr!?      ?-V?(\)?E?E?"`?|hr?1&y?      ?      ?      ?      ?      ?p
=q?      ?n?
=p?      ?5?|h?lC?vȴ9X?      ?      ?      ?5?|h?lC?lC?;dZ?lC?vȴ9X?lC?lC?vȴ9X?-V?vȴ9X?|hr?lC?hr!?      ?p
=q?vȴ9X?/v?lC?lC?lC?"`?-V?1&y?5?|h?-V?/v?vȴ9X?"`?      ?1&y?5?|h?vȴ9X?1&y?p
=q?      ?1&y?      ?      ?-V?A7Kƨ?      ?vȴ9X?lC?|hr?/v?-V?&x?      ?5?|h?/v?1&y?lC?1&y?      ?;dZ?lC?|hr?lC?E?j~"?lC?-V?      ?      ?;dZ?"`?5?|h?-V?Q?-V?(\)?Q?lC?lC?lC?      ?1&y?lC?-V?/v?      ?(\)?/v?      ?E?hr!?E?vȴ9X?j~"?lC?lC?vȴ9X?-V?      ?      ?vȴ9X?lC?p
=q?Q?lC?lC?vȴ9X?(\)?/v?      ?/v?5?|h?      ?p
=q?vȴ9X?lC?lC?lC?lC?vȴ9X?      ?      ?      ?p
=q?;dZ?lC?vȴ9X?lC?lC?lC?hr!?-V?lC?Q?|hr?lC?/v?|hr?lC?Q?      ?      ?      ?"`?lC?hr!?Q?-V?;dZ?nP?`A7L?vȴ9X?lC?/v?5?|h?;dZ?(\)?E?E?      ?1&y?|hr?1&y?E?lC?1&y?E?/v?      ?p
=q?lC?lC?E?(\)?-V?bM?1&y?hr!?;dZ?5?|h                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	@Nfffff@N33333@O      @O&fffff@O333333@O@     @O333333@O@     @O@     @O@     @O&fffff@O&fffff@O333333@O333333@O&fffff@O333333@O@     @O333333@O333333@O&fffff@O@     @O333333@O333333@O@     @O@     @OL@O333333@O&fffff@Os33333@O@O33333@O     @O@O@O33333@O33333@O33333@P      @P      @P@P      @P      @P      @P@P33333@Pfffff@O@O     @O     @O33333@O@Os33333@Os33333@Os33333@Offffff@OY@O@     @OL@OL@O@     @O@     @O333333@O333333@O@     @O@     @O&fffff@O@O333333@O@     @O@     @O333333@O@O      @N33333@Nٙ@Nٙ@Nٙ@Nٙ@Nfffff@Nٙ@Nfffff@Nfffff@Nfffff@O      @O&fffff@O@Nfffff@O@O@O      @O      @O@O@O@     @Offffff@O     @O33333@Offfff@P      @P@P@P      @P,@P,@P&fffff@P&fffff@P,@P333333@P333333@P333333@P9@P9@P9@PFfffff@PFfffff@PFfffff@P9@P      @Offfff@O333333@N     @NY@N@N@N     @N     @N@N@N@N     @N@N@N@Nfffff@Nfffff@Nfffff@N33333@Nfffff@N@N@N     @N     @N@Nfffff@Nfffff@N     @N@Nfffff@N33333@N33333@N33333@O      @O@O333333@O@     @O&fffff@OL@Offffff@O@O33333@Offfff@O33333@O@Offfff@O33333@P&fffff@P,@P@P&fffff@P333333@P@     @PFfffff@PFfffff@PFfffff@PL@PL@PL@PS33333@PY@PY@PS33333@PY@PS33333@P`     @P`     @P`     @P`     @PY@P`     @Pffffff@Pl@Pffffff@P     @P@P@P     @P33333@P33333@P33333@P@P33333@P33333@P@P@Pfffff@P@P@P33333@P     @P@P     @Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Py@Pfffff@P33333@P@P@P@P@P@P@P@P     @P@P     @P     @P@P     @P     @P@P     @Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@P     @P     @P     @Pfffff@Pfffff@Pfffff@P     @P@P     @Pfffff@P     @P@P     @P     @P@P@P@P@P@P@P33333@Pfffff@P     @P     @P@P     @P     @Pfffff@P     @P@Pfffff@Pfffff@P     @Pfffff@P     @Pfffff@Pfffff@Pfffff@P@P@P@P@P@P@P33333@P33333@P@P33333@P@P33333@P@Pfffff@P@P@P@Pfffff@P33333@P33333@P@P33333@Pfffff@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P@P@P33333@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P     @P@P@P@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P@P@P@P33333@P@P@P@P33333@P33333@P33333@P@P     @P33333@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@P     @P     @P     @P     @P     @Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@P     @Pfffff@P     @P     @P     @P     @P     @P     @P     @P     @P     @P@P     @P     @P     @P     @P     @P@P@P     @P     @P     @P     @Pfffff@P@P@P     @P     @P@P     @Pfffff@Pfffff@Pfffff@P@P     @Pfffff@P@P@P@P33333@P     @Pfffff@P@P@P@P@Pfffff@P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P     @P     @Pfffff@P@P@Pfffff@Pfffff@P@P@P@Pfffff@P     @P@Pfffff@P33333@P33333@P@P@P@P@P33333@P@P@P@P33333@P@P@P@Q      @Qfffff@Q      @Qfffff@P@Q      @Q@Q@Q@Qfffff@Q@P@Q      @Qfffff@Q@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q@Q33333@Q@Q33333@Q33333@Q33333@Q@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q33333@Q@Q33333@Q@Q@Q33333@Q@Q33333@Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Qfffff@Qfffff@Q      @Qfffff@Q      @P@P@P@P@P@P@P@P@P@P@P33333@P@P33333@P33333@P@P33333@P@Q      @Q      @Qfffff@P@P@P@Q      @Q      @Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Q      @P33333@P@P@P@P@P@P@P@P33333@P@Q      @P@P33333@Q      @Q      @Q      @Q      @Q      @Q      @Q      @P@P@P@P@P@P33333@P@Q      @P@Q      @P@P@P@P@P@P@P@P@P@P@P33333@P@P33333@P@P@P@P@P@P@Pfffff@P@P@P@Pfffff@Pfffff@P@P33333@P33333@P@P@P@P@P@P@Q      @P@P@Qfffff@Qfffff@Q@Q@Q@Q@Q@Qfffff@Qfffff@Qfffff@Q@Q33333@Q33333@Q@Q@Q@Q@Qfffff@Q      @Q      @P@Q      @Q      @Q      @Q      @P@P@P@P@Q      @Q      @Q      @Qfffff@Qfffff@Q@P@Q      @Q@Q@Qfffff@Qfffff@Q@Q@Q@Q@Qfffff@Q      @Q@Qfffff@Q@Q@Q@Q@Qfffff@Qfffff@Q@Qfffff@Qfffff@Q@Q@Qfffff@Qfffff@P@Qfffff@Qfffff@Qfffff@Qfffff@P@Qfffff@Qfffff@Q      @Qfffff@Qfffff@P@Q      @Qfffff@Q@Q@Q@Q@Q@Q@Q@Q@Qfffff@Q@Q33333@Q@Q@Q33333@Q@Q33333@Q33333@Q@Q33333@Q33333@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q33333@Q33333@Q33333@Q@Q@Q@Q@Q@Q@Q@Q      @Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q      @Q@Q@Q@Q@Q@Q@Q@Q      @Q      @Q@Q@Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q33333@Q@Q@Qfffff@Q@Q@Q@Q@Q@Q@Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Q      @Q      @P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P@P@P@P@P@P@P@Q      @P@P@Q      @Qfffff@Qfffff@P@P@Qfffff@Qfffff@Qfffff@Qfffff@Q@Q@Q@Qfffff@Qfffff@Qfffff@Qfffff@Q@Qfffff@Q@Qfffff@Qfffff@Q      @Q      @Q@Q@Q@Q@Q@Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Q@Q@Q@Qfffff@Qfffff@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Qfffff@Q@Q@Q@Q@Q@Qfffff@Qfffff@Qfffff@Q@Q@Q@Q@Q@Q@Qfffff@Qfffff@Qfffff@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Qfffff@Q@Q@Q@Q@Q@Q@Qfffff@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q33333@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q@Q33333@Q@Q33333@Q33333@Q33333@Q@Q33333@Q33333@Q@Q@Q@Q@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q@Q@Q33333@Q33333@Q@Q@Q@Q@Qfffff@Q@Q@Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Q      @Q      @Qfffff@Qfffff@Q      @Q      @P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P33333@P@P@P@Q      @Q      @Q      @Q      @Q      @Q      @Qfffff@Qfffff@P@Q      @Q      @Q      @Qfffff@Q      @P@Qfffff@Q      @P@Q@Q@Q@Q@Q@Q@Qfffff@Qfffff@Q@Q@Q@Qfffff@Qfffff@Qfffff@Q      @P@P33333@P@P@P@P@Pfffff@Pfffff@P     @Pٙ@Pٙ@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P@Pfffff@Pfffff@P     @P     @P     @Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pٙ@P     @Pٙ@Pٙ@P     @P     @P     @P     @P     @Pٙ@Pٙ@P33333@P33333@P33333@P@P33333@P@P@P@Pfffff@Pfffff@Pfffff@P@P@P     @P     @P@Pfffff@Pfffff@P     @P     @P@P@Pfffff@Pfffff@P     @P     @P@P     @P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    P4                                      4                                       BBT{3P