CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20170205   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P3     CAST_NUMBER       2      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:35.188500Z    ORIGINAL_HEADER      6CTD,20250210CCHSIOWB
#Removed 'CTDFLUOR_TSG' as it's filled with -999
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2017-06-29. CTD data from cruise 18DD20170205, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20170205. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2017-001/index.php. 
#
# The information in this file for the cruise 2017-001 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-0036.ctd
#
# Start of originator file comment header
#
#*2017/06/29 15:26:50.02
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2017/02/10 06:17:38.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 198
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : CE9F1F72
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            0.3            202.1
#       2 Temperature:CTD               deg_C_(ITS90)   5.6248         6.8697
#       3 Salinity:CTD                  PSS-78          32.78          33.8432
#       4 Sigma-t:CTD                   kg/m^3          25.7461        26.7106
#       5 Oxygen:Dissolved:CTD:Volume   ml/l            3.4            6.87
#       6 Oxygen:Dissolved:CTD:Mass     µmol/kg         147.7          299
#       7 Fluorescence:CTD:Seapoint     mg/m^3          0.66E-01       1.162
#       8 PAR:CTD                       µE/m^2/sec      0              0.3
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        7  F       ' '     2
#       6  -99   ' '        6  F       ' '     1
#       7  -99   ' '        8  F       ' '     3
#       8  -99   ' '        7  F       ' '     1
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2017-001
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P21
#    EVENT NUMBER        : 36
#    LATITUDE            :  49  38.00000 N  ! (deg min)
#    LONGITUDE           : 139  39.97000 W  ! (deg min)
#    WATER DEPTH         : 3961
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    The descent rate of the CTD was very noisy with some complete reversals
#	of direction.
#    CTDEDIT was used to remove many records corrupted by shed wakes;
#	salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Fluorescence and PAR data are nominal and unedited except that some records were
#	removed in editing temperature and salinity and a large spike in
#	fluorescence was removed from file 0032.
#
#    The Transmissivity channel was removed because of frequent shifts in values during
#	casts and large variations between values during repeat casts.
#	The data are available, by request, from the chief scientist.
#
#    NOTE: While the Fluorescence:CTD data are expressed in concentration units, they
#	do not always compare well to extracted chlorophyll samples, particularly for
#	casts far from shore. It is recommended that users check extracted chlorophyll
#	values where available.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in Sea-Bird
#	Application Note #64-2, June 2012 revision (Sea-Bird_64-2_Jun2012.pdf), except 
#	that a small offset in the fit was allowed.
#
#    The Dissolved Oxygen sensor used in files 0001, 0002 and 0016 malfunctioned so the 
#	Oxygen:Dissolved:CTD channels were removed from those files.
#
#    The Oxygen:Dissolved:CTD sensor has a fairly long response time so data accuracy 
#	is not as high when it is in motion as it is during stops for bottles. This will be
#	especially true when vertical dissolved oxygen gradients are large. To get an estimate
#	of the accuracy of the Oxygen:Dissolved:CTD data during downcasts (after recalibration)
#	a rough comparison was made between downcast Oxygen:Dissolved:CTD data and upcast 
#	titrated samples. Some of the difference will be due to problems with flushing of 
#	Niskin bottles and/or analysis errors, so the following statement likely underestimates 
#	Oxygen:Dissolved:CTD accuracy.
#
#    Downcast (CTD files) Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.25 ml/l from 0 to 125 dbar.
#	±0.2 ml/l from 125 to 400 dbar.
#	±0.1 ml/l from 400 to 600 dbar.
#	±0.05 ml/l from 600 to 1500 dbar.
#	Low by up to 0.08 ml/l below 1500 dbar.
#
#    For details on the processing see document: 2017-001-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5--- --6-- ---7--- --8---
#!Pressu Temperat Salinity Sigma-t: Oxygen Oxyge Fluores PAR:  
#!re:CTD ure:CTD  :CTD     CTD      :Disso n:Dis cence:  CTD   
#!                                  lved:  solve CTD:          
#!                                  CTD:   d:CTD Seapoin       
#!                                  Volume :Mass t             
#!------ -------- -------- -------- ------ ----- ------- ------
#*END OF HEADER
     WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @Y         data_max      @Y         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER       2   pressure                	long_name         pressure   positive      down   units         decibar    data_min      ?   data_max      @/33333   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC        I   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d        `T   temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      @h   data_max      @#Y   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC         f   temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d        |   salinity                	long_name         salinity   units         PSS-78     data_min      @@Ep
=   data_max      @A"Q_   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC        l   salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d        $   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @(   data_max      @qI   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC             	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d           CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?/v   data_max      ?I^5   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC        <   CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d           PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min                 data_max      @g333333   C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC         פ   PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d        \   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min               data_max               C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC          CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d       
   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( t   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         (    time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      *   data_max      *   C_format      %10d          latitude               	long_name         latitude   units         	degrees_N      data_min      @HOmǤ   data_max      @HOmǤ   C_format      %9.4f             	longitude                  	long_name         	longitude      units         	degrees_E      data_min      _RC   data_max      _RC   C_format      %9.4f             	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d           	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min        P   data_max        P   C_format      %4d        @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      @Y      ?@333333@@@@!@$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>@?      @?fffff@@     @A      @A     @B@B@C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @G33333@H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Qٙ@R      @R@     @R     @R     @S      @S@     @S     @S@T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @YFfffff@Y@Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]y@]@^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b@cfffff@c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @efffff@e333333@effffff@e     @e     @efffff@e@f      @f      @f@     @fp     @f     @f     @f     @f     @g      @g&fffff@g6fffff@g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i33333@i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @k@l      @l@     @l`     @l     @l     @lfffff@lfffff@m      @m      @m@     @m`     @m     @m     @m     @m     @m@n@n@     @n`     @n|@n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p~fffff@p33333@pfffff@p     @p     @p     @pᙙ@p陙@qfffff@q     @q      @q0     @q@     @qP     @q`     @qp     @q~fffff@q33333@q     @q     @q     @q     @q     @q     @r      @r@r&fffff@r0     @r@     @rP     @r\@rs33333@r     @r     @r     @r33333@r@r     @r     @r     @s      @s     @sfffff@s333333@s@     @sP     @s`     @sp     @s     @s     @s     @s33333@s     @s     @s     @s     @t      @t     @tfffff@t333333@t@     @tP     @t`     @tp     @t     @t     @tfffff@t     @tfffff@t     @t     @t     @u      @ufffff@u1@u@     @uP     @u`     @up     @u33333@u     @u     @u     @u     @u     @u     @u     @u@v@v      @v0     @v@     @vP     @v`     @vl@vfffff@v     @v     @v     @v     @v     @v     @v陙@w@w     @w      @w0     @w@     @wP     @w`     @wp     @w~fffff@w@w     @w     @w     @w     @w     @w     @xfffff@x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x陙@yfffff@y     @y      @y0     @y@     @yP     @y`     @yk33333@y@y     @y     @y     @y     @y     @yfffff@z@z     @z      @z0     @z@     @zNfffff@zp     @z     @z     @z     @zfffff@zљ@z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{33333@|@|     @|      @|0     @|@     @|P     @|`     @|nfffff@|     @|@|33333@|     @|     @|     @|     @|     @}      @}fffff@}0     @}@     @}P     @}`     @}p     @}     @}@}@}     @}fffff@}     @}     @}     @~      @~fffff@~#33333@~0     @~@     @~P     @~`     @~p     @~     @~     @~33333@~33333@~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @~fffff@     @     @     @@@     @     @      @     @@     @      @(     @0     @8     @@     @H     @P     @X     @h@p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @@@      @     @     @     @(@0     @8     @C33333@H     @P     @X     @`     @h     @p     @x     @@     @     @     @     @     @@     @     @     @     @@@     @     @     @      @     @     @     @      @(     @8     @@     @H     @M@Y@`     @h     @p     @x     @}@     @     @     @     @     @     @     @fffff@fffff@     @     @     @     @     @     @      @     @     @     @      @(     @-@8     @@     @H     @P     @X     @_33333@h     @p     @x     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @@      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @y@     @     @     @     @     @     @     @     @     @     @     @     @     @33333@@      @     @     @     @      @(     @0     @4@A@H     @P     @X     @`     @h     @p     @x     @     @@@     @     @     @     @     @@ə@     @     @     @33333@@     @ @
fffff@     @     @ @(@0     @8     @@     @G33333@P     @X     @`     @h     @p     @     @     @     @     @33333@33333@     @     @@     @     @     @     @     @     @@33333@33333@     @ @(     @/33333                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       @#TD@#U2a|@#SMj@#QN;5@#Kq@#Ix@#IDg8~@#Hr Ĝ@#G/V@#G+I@#FA@#E`A7L@#Eu@#DJM@#DJM@#D7@#D/@#D/@#DJM@#De@#DS@#Dqj@#De@#Eu@#EQ@#EQ@#Eu@#Em\@#E8YK@#F1.@#FYJ@#Ffffff@#FIQ@#FA@#G8}H@#G+I@#G@@#H˒:*@#Hu%F@#HTɅ@#Hۋq
@#I ѷ@#I7KƧ@#I@#IoiD@#MV@#N}Vl@#P ě@#QN;5@#Q-@#RGE85@#Qu@#R ě@#[S@#a@#fIQ@#gK]d@#heO@#mV@#p$tT@#sMjO@#v@#zG{@#|?@#[6@#,zxl@#u@#@#@#0U2a|@#zxl"@#v_ح@#3@#!.@#C-@#+j@#F@#1'@#~($@#rGE8@#e+a@#b}@#|@#u%F@#)y@#Y@#@#E@#4J@#Xy=@#-w1@#{qu!@#vC-@#l@#`IQ@#ZG{@#S|@#QiB@#P-
q@#MC\@#Ka@@#I^5?}@#I7KƧ@#Hۋq
@#J#9@#K]cA@#KP{@#N!R<@#MU=@#H1&x@#?U=@#7@#.qi@#(	ԕ+@#䎊r@#o @#74@"j~@"9Xb@"Gz@"Վ!R@"/{J#@"n@"ԕ*@""`B@"&@"I^5?@"P{@"H@"r@"R@"c	@"F]c@"S@"#x@"T@"@"zH@"TɆ@"$/@"Fs@"'RTa@"}<64@"zݘ@"z)_@"zC\@"j0
@"L!-w@";s@"873@"*D@""@4n@"@"Z@"D@"_o@"'&@".ߤ?@"4j~@"6+J@"5=K@"4,<@"-(@"E@!N;5@!-
q@!{S@!G,@!D7@!Cn.3@!@4m9@!*	 @ S&@ iB@ Ίqi@ 74@ `A@ M@ 4m9@ )_@ sPH@ w@ y	k~@ ov@ d?@ XF]d@ NO;@ G8}H@ C{J#9@ AGz@ AGz@ A|Q@ AGz@ >m\@ 7eں@ 2nO@ /O
M@ /\(@ 5?|h@ /4֡a@ ~($@ m8@ *0@\(@_ح@)@($x@E@ԕ*1@BZc @!-w@'R@wkP@@K]c@tj~@ka@@eu@\1&@[Q@[W>6z@Zvȴ@N+@F?@6_ح@%O
@҈p;@
ڹY@o hی@E@v@e@&@JM@1@b}@@(@|hs@x}H@jOv`@Ye+a@KƧ@A@?@:G{@/r@#	@>6z@
=p
@u%F
@=b@fA@żn/@x@E@L_@~"@y~($@xF]d@sMjO@oiDg8@ov@mU=@ka@@b3@UfA@P|@?@2W@'8}H@$tSM@ߤ@@҉@@X@cA \@E@'RT`@l!-@"`B@g8}@Y|@P{@-V@"`B@@?@~
(@h@_o@IQ@쿱[W@V@@䎊r@qu!@և+J@:S@Z1@l!-@;5X@q@=p
@$@w4m@pD@g/V@cZ@cS&@`u!@[S@N_o @.t@ 'RT`@Ov_@p
=@ᰊ@!-w@S@[6@+j@nO@bM@eO@m\@H˒@%F
L@H@/V@tj@~m\@w4m@or@<64@+@y@*0@\N@*0@M:@oiDg@K]c@s@$/@;dZ@sE@I^5?}@`A7@ݗ+k@R@ ě@B@rs@cS&@S*0U2@Sa@O@S@RnO@P)^@P$tT@P@P*0U@OAs@Kq@I@GK]d@G_o@GE84@F@F
L/@C%2@=E@;lC@5\(@..2@'&@#Z@#	@!@N@+@\(@
qu"@&IR@      @($x@vȴ9X@XbM@W@@V@ڹ@d8@ݗ+j@u"@2a|@ќu@@ěS@ [7@n@BZc @~$@	k~@F@)@=b@=b@}H@Xe@֡a@͞&@T@r{m@ZY@N_o @333333@&1.@:@@|j~#@a.H@]-V@V@L/{J#@4j~@>6z@K'/@S&@VOv_@eu@}Vl!@qu"@=p
@@#9@JM@}H˒@|64@|Q@{A@{dZ@{A@{A@uXy=@j~"@g@Zc	@8-
@2ᰊ@'/V@$%1@#	@!o@$tT@F@&x@x@}H@?@?@]ce@څݘ@ξߤ?@=b@@O
@1&@I^5@sMjO@n2X@e`A7L@^ ѷY@C$@ ěT@@Vu@ 6@'RT@'@!-w1@@ï@ hۋ@@wkQ@u"@,<@@@Mj@L_@Zc@{A@x73@rᰊ@l!-w@de@_o@XPH@QN;5@HeO@*Ov`@ ѷY@(\@Xe,@Xe,@L_@҉@
ڹY@ȴ9X@@ϐ@(\@GE85@Y|@1@!.I@kP@4m@!.@!R@!R@m\@d7@,<@7KƧ@o@ᰉ'@F
L0@|Q@eO@7@ěT@~$t@{dZ@{J#9@rW@h\)@QN;5@M:@J=p
@CnP@A [7@?|hs@>m\@<hr@;J#9@:>B@9"`@9XbM@8Q@6C-@6+jg@43@0D@0:~ @-U=@&'@ d8@o@+@X@
=p
@	7KƧ@@|hs@~@kP@9XbN@g	l@PH@s@@ڹ@-
@?@ߤ@@$tS@fA@a@O@nO@Ж@
M;@҈@K]c@$/@JM@ěS@ěS@s@NU@Fs@A [@@҈p;@ݘ@@*0U2@N;5@{@v_ح@p:~@_o @qu"@_@҈@C%@K]c@-@@m\@$/@|64@u?|h@p
=q@g&@\>@S&@I'RTa@F$/@E8YK@Do h@BI^5@?H˒:@;/V@4!-w2@/{J#:@.t@(r Ĝ@}H@hr @
	 @I^5@@#x@XbM@g@x@,@wkQ@S&@A7K@@h	ԕ@ce@PH@_F@&@l!-@l!-@*1@%@@n/@|hr@rGE85@g,@Uᰉ@N!R<@G_o@?˒:)@=Vl!@:)y@873@.2X@	@p:~@@
qiC@#@$@ IQ@[W>@>B@!.I@'0@ރ%@(\@ۋq@e+a@Ov_@҈p:@ќu@ΤT@@\(@lC@@"`@KƧ@}Vl@Fs@j~@g	l@oiDg8@C]@͞&@^@/V@,@L/{J@`A7L@/@e@-V@_o@jOv@]cA@)^	@L_@q@xF]@n@#@@@p:@@9Xb@Fs@g8}@o h@ ѷ@}v@o hۋ@kQ@iᰉ'@h                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       @@Ep
=@@Ep
=@@Ezxl"h@@E!R@@E@@E(@@Eᰉ@@EE@@EC\@@Eڹ@@Eڹ@@Ft@@F ѷY@@Ft@@F ѷY@@F
L/@@F
L/@@F
(@@F@@F$/@@F+jg@@F.2@@F8YJ@@FH@@F?@@FBZc @@FE@@FL/{J@@FR<6@@F_ح@@Ffffff@@FiB@@Fvȴ9X@@FIQ@@Fqi@@Fqi@@FT@@F}Vl@@F2X@@F2X@@F'@@F'@@F&I@@Fߤ?@@F+@@GE84@@G_o@@G	@@G?@@GK]d@@G-@@H1&x@@IXbM@@L`d@@Nqi@@PD*@@Pe+@@QDg8~@@RD@@Ttj@@TE@@VL/{J@@XbM@@[U=@@]$/@@^]cf@@_@@@aQ@@b=p
@@f
(@@h\)@@lFs@@q [7@@r&IR@@s)^	@@uzxl"h@@vx@@xoiDg8@@zڹY@@}o i@@}-V@@}\(@@~
L/@@~qi@@~Q@@Xe@@Q_@@hr!@@O;d@@T`d@@5Xy@@3@@5Xy>@@4m@@iB@@䎊q@@o h@@v@@H˒:@@#w@@MjO@@o h@@M:@@73@@qiC@@9XbN@@(@@?@@qi@@o @@G{@@N;@@$/@@҈p;@@[W>@@@@y@@W'@@m@@@@_@@
(@@Vu@@T@@{@@T`d@@|@@*0@@fA@@!R@@@@}Vl@@As@@-@@$tT@@D@@XbM@@74@@âwk@@1&y@@š@@$tS@@hۋq@@ȷ4m@@ȴ9Xb@@p:@@.H@@(\@@B@@Vl!@@_ح@@1@@KƧ@@@@Ќ@@F]c@@?@@
=p@@'RT`@@҈p@@o hی@@3@@ڣS&@@ڬ>B@@)^@@)^@@>6z@@1@@
=p@@>6z@@ק&@@^@@2W@@܄?@@ܕ*1@@ݫU=@@\@@IQ@@ݼn/@@iB@@䎊r@@n.@@s@@xl"h
@@u%F
@@u%F
@@ڹY@@qu!@@%2@@o h@@䲕@@D@@(@@2a|@@IQ@@@@Mj@@rGE9@@x@@0
@@@N@@]cA@@
=p@@(@@n/@@($x@@A@@!-w1@@Xe,@@K]c@@+@@Gz@@N;5@@-@@@4@@m@@~@@74@@tj~@@~($@@5Xy@@A [@@Fs@@Z1@@#@@Z@@Q@@sg@@ݗ@@sh@@@@ڹ@@u@@!R<@@!R<@@.2@@;5X@@u@@.2@@H@@l!-@@}Vl@@@@Q@@m\@@"@@H˒:@@sPH@@ݗ+@@vȴ9@@K]d@@-@@*0U@@˒:*@@ѷX@@$/@@_p@@@@#w@@*0U2a@@=b@@TɅo@@Q@@[W>6@@^@@b}@@B@@@@lD@@s@@#9@@#9@@)y@@6C@@T`d@@Zc@@@4@@L_@@T`d@@^5?|@@>B@@g	@@<64@@n@@W@@䎊q@@҉@@nP@@@N@@{J#9@@q@@|@@n.3@@	@@m\@@9@@)^	@@	@@ ѷ@@@@~@@$@@@@!-w2@@]ce@@@@֡a@@!-w@@[@@%F
L@@(@@+a@@'0@@3@@zG@@qj@@*1@@쿱[@@j~@@7@@#x@@?@@j~@@7@@?@@[W?@@Ʌoi@@@@Z@@*0@@/@@u"@@֡a@@e@@3@@_@@[@@!.H@@B@@Y|@@zxl"h@@U=@@8YK@@b@@@@%@@@@Mj@@͞@@ݗ+@@kP@@@@A 1&x@A ěT@A:S@AA [@AA [@AQ@Ae+a@A|Q@Ab}@AoiD@A@Au@Al@A'R@A|@A^5?}@AD@AD@Ay@AiB@AN;6@AiB@AR@An@AOv`@A䎊@A䎊@A&IR@A:)y@AC\@A@4n@AW'@Ad7@AqiC@A~"@Ap:@A\(@AwkQ@AS&@A@A@A ě@A)_@A)_@A`A@AsP@AG{@AG{@AڹY@A,<@A,<@A`A@A`A@AڹY@Am@A74@AI^@Au%@Au%@Au%@A`A@Aᰊ@AW'@A6C@A	 @A>BZ@A$/@A u!@A y=c@A l"h	@A _F@A l"h	@A YJ@A 
(@A2W@Ad7@A,<@A/V@Awk@Aqj@A}H@A%@Av@Ash@A?@A_o @At@AzG@A
(@A_o @A_o @At@A!.@A!.@A4K@A1.@AoiDg@A?@A1@A@A%@A@A!R@Av@AXy=@Ahr!@A=K@AU=@A\(@Aᰉ@A8YJ@A&I@A{J#:@A@A	k@A@AeO@A@Atj@A4m@A	$/@A	u@A	oiD@A	@A	@A	ԕ*@A	lD@A
䎊@A
)y@A
@4@A
 ě@A
c	@As@APH@A"`B@A6z@AF]c@AMjO@AdZ@A~$@AMj@A6@A҈@A|@AC]@A@A@A@AQ@An.@AC]@A҈@A5Xy@A|@A\N@AA [@A҈@A$@AQ@Aq@A,<@A@AE@A
IQ@A
ce@A
$/@A
+j@A
1@A
@A
@A
@A
!.@A.2@Ac	@Ap:~@Ap:~@Aaf@A҈p;@A@A8}H@Ao@A@A     @A@A6@A>BZc@APH@A+@A-w1@ATɅo@Ao hی@A7Kƨ@A@An.@A|@A^5?}@A@Ao@Ao@A"`@AiB@A>BZ@An@A.H@A@A=p
@Aa|Q@A^5?|@A{m@Ap:@A0
@AY@An@AڹY@A~@AS&@As@AC,z@A	@A)^	@A6z@An.3@AMj@AS@AS@A~($@AZ@Aa@O@Aa@@A
=p@A҈@AC]@An.@A@Aߤ@@AxF@A@AJ@A@AI^5?@AwkP@AN;@A!-w@A!.H@A[@A!.H@AF
L0@AIQ@AS&@AY|@AfA@A`A7L@AjOv@Am\@Ap
=@A}H@Aݗ@A}H@Aݗ@A@AH˒@A,=@Aڹ@At@A($x@Ac	@A}Vl@A@A@A&I@At@Aߤ?@A"@A$tS@AAs@AKƧ@A_o@A$tS@A@A     @A73@AK]c@ANU@AbM@Ay=c@A4m@ATɅ@AF@AѷX@A҈p@A"`@Aᰉ'@As@An@An@An@As@Ae+@A1'@A=p
@AW'@Ad7@AS&@A)_@Am\@A{J#9@A@A҈@Aߤ@@A@A/{J#@A9XbN@AzG@A'0@AY|@A\@Aw1@AڹZ@AU=@A8Y@A@AS@Aڹ@Au@AT@A}Vl@A}Vl@A}Vl@Aߤ?@AA@AϪ͟@AC-@AFt@A$tS@AO
M@AiDg8@Ab}V@AsPH@Ay@A|hs@AO;d@A?@A˒:)@A@ArG@A䎊r@ArGE9@A F]d@A F]d@A 
qu@A bM@A $xG@A >BZc@A hۋq@A D@A C@A \)@A {@A C@A 4֡b@A PH@A!_p@A!@A!@N@A!@N@A!+@A!*0U2a@A!A [@A!Dg8~@A!Q@A!@A"n@A"#9@A"6C@A"Q_                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       @qI@q4@q1@q&fffff@q(     @q@qfffff@qfffff@qfffff@q      @qfffff@qfffff@qfffff@q#33333@q$@q!@q!@q$@q      @q!@q#33333@q&fffff@q#33333@q#33333@qfffff@q     @q#33333@q+33333@q!@q@q      @q!@q$@q@qfffff@q!@q      @qfffff@q@q@q#33333@q!@q!@q!@q     @qfffff@q@q33333@q33333@q33333@q	@q@p񙙙@p33333@pfffff@p|@p33333@p33333@pnfffff@p[33333@pH     @p8     @p@p@o     @offfff@ovfffff@ol@o333333@n     @n6fffff@m     @m      @l     @lfffff@lL@l@k33333@k|@k6fffff@k333333@k333333@k)@k@k@k      @j@j@ifffff@ip     @i6fffff@i@i     @h陙@hfffff@h@h@h@hVfffff@h@g33333@g     @gs33333@g333333@f@f@f@fs33333@f`     @f#33333@efffff@efffff@effffff@eC33333@e@     @e@d@dٙ@dfffff@dfffff@d@d     @dfffff@d|@dP     @d@cfffff@cfffff@c33333@c     @c     @c     @c33333@c@c@c@cs33333@cP     @c<@c&fffff@c33333@b     @b     @b@bfffff@bfffff@b33333@bi@b)@bfffff@a33333@a@a@aə@a     @al@a#33333@`@`fffff@`fffff@`     @`@`33333@`@aY@a@b,@bl@bVfffff@bL@b)@b@b      @b0     @b6fffff@b&fffff@b)@b      @b      @a     @a33333@afffff@afffff@a@a33333@a33333@aə@a@afffff@a     @afffff@as33333@a`     @affffff@ap     @ac33333@a&fffff@`@`l@`#33333@`33333@`      @`&fffff@_@_Y@_33333@^33333@^fffff@^fffff@^@     @]@]33333@]fffff@]l@]33333@\fffff@\     @\ٙ@\fffff@\fffff@\s33333@\Ffffff@\      @\@\      @[33333@[33333@[y@[`     @[9@[      @[      @[&fffff@[,@[L@[l@[fffff@[@[@[@[fffff@[     @[`     @[@     @[&fffff@[fffff@Z     @Z@Zy@ZY@Z9@Z@Yfffff@Y     @YL@Y@X@Xfffff@Xfffff@X     @Xfffff@X@Xٙ@X     @Xfffff@X     @X33333@X33333@X@Xl@XS33333@X@     @XFfffff@X9@X333333@X&fffff@X,@X@W     @W     @W33333@W     @W@W@W     @Wfffff@Wl@Wffffff@WFfffff@W9@W333333@W`     @W     @Wfffff@W33333@W33333@W     @W@Wfffff@X@X      @Wfffff@W9@W@V33333@Vy@V@     @V      @V33333@V33333@V33333@V      @V9@VY@V`     @VY@V333333@V      @V33333@V      @U@U@Uٙ@U     @Uٙ@Ufffff@Ufffff@Ufffff@U33333@U@U@Uy@Uffffff@Uffffff@UY@U,@Tٙ@T     @T33333@T     @T`     @T9@T      @T&fffff@S@S@SFfffff@S      @R@     @R,@R33333@Qٙ@QY@Pfffff@P@P33333@Pffffff@PY@PL@PL@PS33333@PY@PS33333@PL@P9@P9@P&fffff@P333333@P,@P&fffff@P@P@P&fffff@P@O33333@Oٙ@Offfff@O@O@O@O     @OY@O&fffff@O@N33333@O      @Nٙ@N@N33333@Nfffff@N@N     @Nffffff@Nffffff@Ns33333@NY@N333333@N      @N      @N      @N      @Mfffff@Mٙ@N@N      @Mfffff@M@M33333@M33333@M@Mٙ@M@M@M@M@Mfffff@N      @N&fffff@Nffffff@Nٙ@O&fffff@O      @O@N33333@N     @NY@M     @L@K33333@Ks33333@K@J@Is33333@IY@IY@I333333@I@Hfffff@H33333@H33333@I@H@Hٙ@H     @H@Hٙ@H@Hٙ@H@H     @H@Hfffff@Hfffff@Hfffff@Hfffff@Hs33333@H     @HY@HL@H@     @H      @G33333@Gfffff@GL@F@Ffffff@F333333@Efffff@E     @E&fffff@D33333@D@D33333@D     @D@C     @C33333@C     @CL@C@B33333@B33333@B     @B&fffff@B      @Aٙ@Aٙ@A     @A@Aٙ@A@A@A     @Affffff@As33333@A@     @A&fffff@A&fffff@A&fffff@A&fffff@A@A333333@A333333@A@     @AL@Affffff@AL@AY@AY@A     @Afffff@Afffff@Affffff@@fffff@@     @@@@Y@@&fffff@@&fffff@@@@@?fffff@?fffff@?fffff@?L@>fffff@>@>L@>333333@=@=@=L@=      @=      @<ffffff@<@;fffff@;@;      @:ffffff@:L@:L@9fffff@:      @9@9@9@9@933333@933333@9@9     @9     @9L@9333333@9L@9333333@9      @8@8@8     @8@8     @8ffffff@8333333@8@8@8@733333@733333@7fffff@7fffff@733333@7@7     @7L@7333333@7      @6fffff@6@6fffff@6@7      @633333@6@7      @6@6ffffff@6@633333@633333@6L@6333333@6333333@533333@533333@5@5     @5ffffff@5@5      @5333333@5L@4fffff@5333333@5@5      @5      @5      @5@5      @5      @4@433333@4@4     @4@4333333@4      @3@3@3@333333@333333@3@3@3L@3ffffff@3L@3@3      @2fffff@233333@2ffffff@2     @2     @2L@2333333@2      @2      @2      @1fffff@1     @1@0@1@1      @033333@033333@0fffff@0@0@0@0@0@0     @0@0      @/ffffff@/@/      @/333333@.@.@.333333@.      @-@.      @-ffffff@-ffffff@-ffffff@-@-333333@-333333@-      @,@,@,ffffff@,333333@,      @+@+@+@,      @,      @+ffffff@+ffffff@+333333@+ffffff@+333333@+      @*@+333333@*@+      @*@+      @*@*@*@*@*@*@*      @*ffffff@*      @*      @)@)@*      @*      @*      @*      @*      @)@)ffffff@)@*      @*      @)@)@)@)@)ffffff@)ffffff@)333333@(                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       ?
=p??`A7L?&x?M?bM?n?tj~?+I?KƧ?Z1'?S?5?|h?C$?zG?-V?-V?-V?zG{?"`?hr!?
=p?I^5?Gz?~"?j~"?C%?tj~?vȴ9X?I^5?}?1&?tj?A7Kƨ?zG?vȴ9X?S?lC?+I^?I^5?}?nO?
=p?tj~?-V?;dZ?1&?zG{?1&x?+?Q? ě?I^5??\(?;dZ?GzH?KƧ?~"?Q?r ě?;dZ?޸Q?p
=q?9XbM?"`A?^5?|?Q?r ě?-V?׾vȴ9X?
=p
?m?Լj~#?333333?$/?+?Vu?^5?|?~"?QR?Ƈ+I?Q?Ł$/?/w?tj?+?S?S?nO;?&x?ěS?"`?vȴ9X?Q?vȴ9X?Q?vȴ9X?"`?|hr?|hr?"`?E?Q?5?|h?/v?1&y?lC?vȴ9?^5?|??QR?bM?QR?QR?KƧ?tj?
=p
?tj?E?\(?tj?+I??|hs?$/??|hs?zG{?j~#?E?+?9XbM?zG{?E?+?E?tj~?E?333333?E?333333?l?l?333333?l? ě? ě?l?nO;?l?zG{? ě?lD?Q?-V?Q?lD?lD?Q?&x?`A7L?
=p?
=p?bM?bM?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?bM?vȴ9X?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?Q?5?|h?-V?5?|h?5?|h?-V?5?|h?Q?Q?-V?-V?-V?-V?-V?/v?-V?/v?-V?5?|h?5?|h?-V?-V?-V?5?|h?-V?-V?5?|h?5?|h?-V?-V?5?|h?5?|h?-V?-V?5?|h?5?|h?-V?-V?-V?-V?5?|h?Q?-V?-V?-V?5?|h?-V?5?|h?Q?Q?5?|h?-V?5?|h?Q?-V?5?|h?Q?5?|h?-V?5?|h?Q?5?|h?Q?Q?5?|h?5?|h?-V?5?|h?Q?-V?Q?;dZ?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?5?|h?5?|h?5?|h?5?|h?Q?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?;dZ?Q?;dZ?Q?Q?Q?Q?5?|h?Q?5?|h?5?|h?Q?Q?Q?Q?Q?Q?;dZ?Q?;dZ?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?;dZ?Q?Q?;dZ?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?;dZ?5?|h?;dZ?;dZ?Q?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?Q?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ? ěT?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?bM?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?Q?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?Q?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ? ěT?;dZ? ěT?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ? ěT? ěT?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?bM?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X? ěT? ěT?bM?;dZ?vȴ9X?;dZ? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT? ěT? ěT?vȴ9X? ěT?vȴ9X?vȴ9X? ěT? ěT                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       @g333333@[     @X33333@T33333@R33333@PL@M     @K@Hffffff@F      @Dfffff@C@     @B      @@     @@@?33333@=fffff@<      @;@;      @:@8fffff@9333333@;333333@:ffffff@9@6@5     @5333333@333333@3333333@2@0@/      @-333333@+@)ffffff@%@#@#@#@!@       @333333@333333@ffffff@      @ffffff@@ffffff@333333@      @
@333333@@333333@@      @333333@ffffff@ ?ffffff??333333??      ?ffffff??333333?333333?񙙙?      ?      ??陙?陙?ffffff?ffffff?333333?333333?      ?      ?      ?ٙ?ٙ?ٙ?ٙ?333333?333333?333333?ə?ə?ə?ə?ə?ə?ə??????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	P3                                      2                                       *BB3P