CDF       
      pressure  R   time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20170205   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P13    CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:35.005593Z    ORIGINAL_HEADER      6CTD,20250210CCHSIOWB
#Removed 'CTDFLUOR_TSG' as it's filled with -999
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2017-06-29. CTD data from cruise 18DD20170205, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20170205. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2017-001/index.php. 
#
# The information in this file for the cruise 2017-001 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-0036.ctd
#
# Start of originator file comment header
#
#*2017/06/29 15:26:50.02
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2017/02/10 06:17:38.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 198
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : CE9F1F72
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            0.3            202.1
#       2 Temperature:CTD               deg_C_(ITS90)   5.6248         6.8697
#       3 Salinity:CTD                  PSS-78          32.78          33.8432
#       4 Sigma-t:CTD                   kg/m^3          25.7461        26.7106
#       5 Oxygen:Dissolved:CTD:Volume   ml/l            3.4            6.87
#       6 Oxygen:Dissolved:CTD:Mass     µmol/kg         147.7          299
#       7 Fluorescence:CTD:Seapoint     mg/m^3          0.66E-01       1.162
#       8 PAR:CTD                       µE/m^2/sec      0              0.3
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        7  F       ' '     2
#       6  -99   ' '        6  F       ' '     1
#       7  -99   ' '        8  F       ' '     3
#       8  -99   ' '        7  F       ' '     1
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2017-001
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P21
#    EVENT NUMBER        : 36
#    LATITUDE            :  49  38.00000 N  ! (deg min)
#    LONGITUDE           : 139  39.97000 W  ! (deg min)
#    WATER DEPTH         : 3961
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    The descent rate of the CTD was very noisy with some complete reversals
#	of direction.
#    CTDEDIT was used to remove many records corrupted by shed wakes;
#	salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Fluorescence and PAR data are nominal and unedited except that some records were
#	removed in editing temperature and salinity and a large spike in
#	fluorescence was removed from file 0032.
#
#    The Transmissivity channel was removed because of frequent shifts in values during
#	casts and large variations between values during repeat casts.
#	The data are available, by request, from the chief scientist.
#
#    NOTE: While the Fluorescence:CTD data are expressed in concentration units, they
#	do not always compare well to extracted chlorophyll samples, particularly for
#	casts far from shore. It is recommended that users check extracted chlorophyll
#	values where available.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in Sea-Bird
#	Application Note #64-2, June 2012 revision (Sea-Bird_64-2_Jun2012.pdf), except 
#	that a small offset in the fit was allowed.
#
#    The Dissolved Oxygen sensor used in files 0001, 0002 and 0016 malfunctioned so the 
#	Oxygen:Dissolved:CTD channels were removed from those files.
#
#    The Oxygen:Dissolved:CTD sensor has a fairly long response time so data accuracy 
#	is not as high when it is in motion as it is during stops for bottles. This will be
#	especially true when vertical dissolved oxygen gradients are large. To get an estimate
#	of the accuracy of the Oxygen:Dissolved:CTD data during downcasts (after recalibration)
#	a rough comparison was made between downcast Oxygen:Dissolved:CTD data and upcast 
#	titrated samples. Some of the difference will be due to problems with flushing of 
#	Niskin bottles and/or analysis errors, so the following statement likely underestimates 
#	Oxygen:Dissolved:CTD accuracy.
#
#    Downcast (CTD files) Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.25 ml/l from 0 to 125 dbar.
#	±0.2 ml/l from 125 to 400 dbar.
#	±0.1 ml/l from 400 to 600 dbar.
#	±0.05 ml/l from 600 to 1500 dbar.
#	Low by up to 0.08 ml/l below 1500 dbar.
#
#    For details on the processing see document: 2017-001-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5--- --6-- ---7--- --8---
#!Pressu Temperat Salinity Sigma-t: Oxygen Oxyge Fluores PAR:  
#!re:CTD ure:CTD  :CTD     CTD      :Disso n:Dis cence:  CTD   
#!                                  lved:  solve CTD:          
#!                                  CTD:   d:CTD Seapoin       
#!                                  Volume :Mass t             
#!------ -------- -------- -------- ------ ----- ------- ------
#*END OF HEADER
     WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @R        data_max      @R        C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     :  2   pressure                	long_name         pressure   positive      down   units         decibar    data_min      ?陙   data_max      @c33333   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      :  mt   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d           temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?$/   data_max      @Qhr    C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       :     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d        8   salinity                	long_name         salinity   units         PSS-78     data_min      @@M   data_max      @AL9XbN   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      :     salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d       :l   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @$   data_max      @r>fffff   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        : I   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d          CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?(\)   data_max      ?tj   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      : D   CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d          PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min                 data_max      @   C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       : x   PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d          	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min               data_max               C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     : $   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d       _<   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( m   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( n   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      )%   data_max      )%   C_format      %10d       n0   latitude               	long_name         latitude   units         	degrees_N      data_min      @HO;dZ   data_max      @HO;dZ   C_format      %9.4f          n4   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      `uO;dZ   data_max      `uO;dZ   C_format      %9.4f          n8   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d        n<   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min        }   data_max        }   C_format      %4d        n@@R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     ?陙@       @@ffffff@      @      @      @       @"      @$333333@%@'@*      @,      @.      @0      @1      @2      @3@4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>@?@@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @D33333@E     @F      @F     @G      @G     @G33333@Hfffff@I      @I     @J      @J     @K      @K@L      @L     @M      @M     @N      @N     @N33333@Offfff@P      @P@     @P     @P     @Q      @Q@     @Q     @Qfffff@R@R@     @R     @R     @S      @S@     @S     @Sٙ@S33333@TFfffff@T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W9@W     @W     @X      @X@     @X     @X     @Y      @Y9@Y33333@Y     @Z      @Z333333@Z     @Z     @Z@[S33333@[     @[     @\      @\@     @\y@]fffff@]@     @]     @]     @^      @^@     @^     @^     @_fffff@_`     @_y@_     @`      @`      @`@     @``     @`     @`     @`@a      @a&fffff@a@     @a`     @a     @a     @a     @afffff@bfffff@b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @cVfffff@c     @c     @c     @d      @d      @d@     @d`     @d33333@d     @d@d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f<@fi@f|@f     @f     @f     @g      @g@gL@g`     @g     @gfffff@g     @g     @h      @h#33333@h@     @h\@h     @h     @h     @h     @i      @i      @i@     @iS33333@ifffff@i     @i     @ifffff@j#33333@j@     @j`     @j     @j     @j     @j@k)@k@     @k`     @k     @k     @k     @k     @lC33333@l`     @l     @l     @l     @l@l@m      @m@     @m`     @m     @m     @n33333@n      @n@     @n`     @n     @n     @n@o#33333@o@     @o`     @o     @o     @o     @o     @p      @p@p33333@p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @pfffff@pfffff@p     @q      @q     @q      @q0     @q@     @qP     @q`     @qfffff@q     @qfffff@q     @q     @q     @q     @q     @q33333@r$@r0     @r@     @rP     @r`     @rp     @r     @r     @rfffff@r     @r     @r     @r     @s      @s     @s6fffff@s@     @sP     @s`     @sp     @s     @s     @s     @s33333@s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tl@t@t     @t     @t     @tљ@t     @t     @u      @u     @u      @u0     @u@     @uP     @uX     @us33333@u     @u     @ufffff@u@u     @u     @u     @u     @v      @v     @v      @v0     @v<@vK33333@va@vp     @v     @v     @v     @v     @v@vfffff@v     @w      @w     @w@wFfffff@wP     @w`     @wp     @w     @w     @w     @w@wfffff@w     @w     @w     @x      @x     @x      @x0     @x@     @xNfffff@xt@x~fffff@x     @x     @x     @x     @xљ@x33333@y      @y     @y      @y0     @yA@yH     @yd@yp     @y     @y     @y     @y     @y     @y     @y񙙙@z      @z     @z      @z0     @z@     @zc33333@zp     @z     @z     @z     @z     @z     @zᙙ@z     @{      @{     @{      @{,@{Q@{`     @{p     @{     @{     @{     @{@{33333@{fffff@|@|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|@|@|     @|     @|     @|     @|@}fffff@}      @}0     @}@     @}K33333@}d@}p     @}     @}     @}     @}     @}     @}@}񙙙@~      @~     @~      @~0     @~@     @~Nfffff@~d@~p     @~     @~     @~     @~     @~     @~@~@~     @      @     @      @0     @@     @K33333@c33333@p     @     @     @     @     @@33333@     @     @      @     @     @     @      @(     @.fffff@;33333@@     @H     @P     @X     @`     @h     @p     @x     @33333@fffff@     @     @     @     @     @     @@     @     @     @     @     @     @      @     @     @ @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @fffff@33333@     @     @     @     @ř@@     @     @     @     @@      @     @     @     @      @&fffff@:fffff@@     @H     @P     @X     @`     @h     @p     @x     @     @33333@@     @33333@fffff@     @     @     @fffff@33333@      @     @     @     @      @(     @,@;33333@@     @H     @P     @X     @`     @h     @q@x     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@陙@     @     @      @     @
@@      @(     @0     @8     @@     @H     @P     @W33333@`     @h     @p     @x     @     @     @     @fffff@33333@     @     @     @     @     @     @     @     @33333@33333@     @      @     @     @     @      @'33333@2fffff@8     @@     @H     @P     @X     @`     @ffffff@t     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @@     @     @      @     @     @     @      @(     @0     @8     @H     @P     @X     @`     @k33333@p     @x     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @@      @     @     @     @      @(     @0     @@@H     @P     @X     @`     @h     @p     @x     @     @     @     @@@     @     @     @     @     @     @@񙙙@     @      @     @33333@"fffff@(     @0     @8     @@     @D@`     @h     @p     @x     @     @     @     @33333@@33333@     @     @     @     @fffff@fffff@     @     @      @     @     @     @      @(     @0     @8     @@     @D@Q@X     @`     @h     @p     @x     @}@@     @     @     @     @     @     @@fffff@     @     @     @     @     @     @      @     @     @     @@(@0     @8     @@     @H     @P     @X     @`     @d@zfffff@     @     @     @     @     @     @     @33333@fffff@     @     @     @@fffff@     @      @     @     @     @      @(     @,     @9@@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @͙@     @     @     @     @33333@      @     @     @     @      @(     @0     @8@@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @@     @     @홙@@     @     @     @      @(     @0     @733333@Q@X     @`     @h     @nfffff@@     @     @     @     @     @33333@@     @     @     @     @     @      @     @fffff@@      @(     @0     @8     @@     @E@Q@X     @`     @h     @p     @x     @     @     @@     @     @     @     @     @     @33333@33333@     @     @     @      @fffff@     @     @      @(     @0     @6fffff@I@P     @X     @`     @h     @p     @x     @}@fffff@     @     @     @     @fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @      @#33333@*     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @a@d     @h     @l     @p     @t     @x     @|     @fffff@33333@     @     @     @     @@fffff@     @     @     @     @     @     @     @     @     @33333@fffff@33333@@     @     @     @     @     @     @     @     @      @@     @     @     @     @     @     @      @$     @(     @,     @0     @4     @A33333@D     @H     @L     @P     @Z     @\     @`     @d     @g@lfffff@p     @t     @v@|fffff@     @     @     @     @@@     @     @     @     @     @     @     @@     @     @     @     @     @     @ә@33333@     @     @     @     @     @@fffff@     @      @     @     @     @     @     @     @fffff@     @(@+33333@1@4     @8     @<     @@     @D     @H     @L     @P     @T     @W@a@d     @hfffff@l     @p     @t     @x     @|     @     @@@     @     @     @     @     @     @     @33333@33333@     @     @     @     @     @     @     @@@     @33333@     @     @     @񙙙@     @     @     @      @     @     @33333@@     @     @      @$     @&@0fffff@4     @8     @:@@fffff@D     @H     @L     @P     @S33333@Y33333@\     @`     @d     @h     @l     @p     @t     @xfffff@z     @@     @     @fffff@fffff@fffff@     @     @     @     @     @     @@@     @     @     @     @     @     @     @     @@@     @     @     @33333@33333@     @     @      @     @     @     @@@     @      @$     @(     @,     @/@8fffff@<     @@     @D     @H     @L     @P     @S@X     @\     @`     @d     @h     @jfffff@q33333@t     @x     @|fffff@@     @     @     @     @     @     @     @     @     @     @     @     @33333@33333@     @     @     @     @     @fffff@fffff@ݙ@     @     @     @     @     @     @     @@      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @3@>     @@     @D     @H     @L     @P     @T     @X     @\     @^fffff@h@l     @p     @t     @x     @|     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @ə@     @     @     @     @@ߙ@     @     @     @     @     @@     @      @     @     @     @@33333@     @      @$     @(     @,     @0     @4     @8     @H     @L     @P     @T     @X     @\     @`     @d     @h     @jfffff@q33333@t     @x     @|     @     @@     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @@@      @     @     @     @     @     @fffff@@      @$     @(     @,     @0     @4     @8     @;33333@Dfffff@H     @L     @P     @T     @X     @\     @`     @d     @f     @pfffff@t     @x     @|     @~@fffff@     @     @     @     @     @     @     @33333@@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@@     @     @     @      @33333@	@     @     @     @     @     @      @$     @(     @,     @0     @4     @7@<@@     @D     @H     @L     @P     @R@\@`     @d     @h     @l     @o@y@|     @     @     @     @@33333@     @     @     @     @     @@@     @     @     @     @     @33333@     @     @     @     @fffff@fffff@     @@     @     @     @     @     @     @     @      @$     @'@0     @4     @8     @<     @@     @D     @H     @L     @N     @Y@\     @`     @d     @h     @l     @p     @r@|@     @33333@@     @     @     @     @     @     @@@     @     @     @33333@     @     @     @     @     @     @33333@fffff@     @     @     @     @     @     @     @@33333@     @     @     @fffff@     @     @      @$     @(     @,     @0     @8fffff@;@@@D     @H     @L     @Tfffff@X     @\     @`     @d     @h     @l     @u33333@x     @|     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @ᙙ@㙙@     @     @@@     @     @      @     @     @     @     @     @     @     @      @#33333@(@,     @0     @4     @8     @<     @@     @I33333@L     @P     @T     @W@a@d     @h     @l     @p     @t     @x     @{33333@fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @33333@     @      @     @     @     @@@      @$     @(     @,     @0     @4     @6@A33333@D     @H     @L     @P     @T     @W33333@`@d     @h     @j     @q33333@t     @x     @|     @     @     @     @     @@     @     @     @     @fffff@     @     @     @     @     @     @     @@     @     @     @     @     @     @     @@fffff@     @     @     @@33333@     @     @     @     @     @     @      @$     @(     @4@8     @<     @@     @D     @H     @L     @P     @R@\fffff@`     @d     @h     @j@q@t     @x     @|     @     @     @33333@fffff@     @     @     @     @     @     @fffff@33333@@     @     @@fffff@     @     @     @     @     @     @ߙ@33333@     @     @     @     @     @     @      @     @33333@fffff@     @     @     @     @      @$     @(     @,     @/@533333@8     @<     @@     @D     @H     @L     @N@T@X     @[@a@d     @h     @l     @p     @t     @x     @|     @     @     @@fffff@     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @33333@fffff@     @     @     @     @홙@     @     @     @     @      @     @33333@     @     @     @     @      @$     @(     @+@0     @4     @8     @<     @@     @E33333@H     @L     @P     @T     @X     @\     @c33333                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  @@qi@Vu@qi@'/W@͞@
M;@Mj@
M;@@T@T@͞@
M;@͞@bM@_p@5Xy>@cA \@s@L_@/{J#@/{J#@I^5?@~($x@I^5?@q@L_@L_@Ƨ@Ƨ@s@I^5?@I^5?@I^5?@I^5?@/{J#@cA \@_@_@@@O;dZ@jOv@jOv@O;dZ@@@@qu"@O;dZ@@Mj@8YJ@=K^@-V@'R@tSM@C@8Y@"h	ԕ@<쿱@<쿱@C@>B[@[W?@C@[W?@>B[@q@q@<쿱@zxl"@"h	ԕ@͞&@\)@RT`e@$xG@lC@>BZc@fA@>BZc@	ԕ+@fA@/V@	ԕ+@	ԕ+@>BZc@>BZc@@@TɅ@rGE@^@ᰉ'@0U2a|@0
@C,z@<쿱@(@V@[W?@V@s@!R@Q@     @7Kƨ@s@o i@'/@@N@*0@>6z@IQ@A7K@Xy=@䎊q@m8@+@L_@I'RTa@Qhr @Bu%F
@O
M;@Q_p@M(@JqiC@Dg8}@1&x@)rGE@*d7@)^@..2@8-
@DS@K:)z@N;5X@NMj@M:@L@;J#9@2 ě@1[W>6@5Y|@6+jg@73@:)y@8Q@*d7@Xe,@S@ڹZ@E@@{J#:@ڹY@#9@ [7@|hs@#x@j~#@v@ȴ9X@R<6@|@˒:)@sߤ@m(@j~"@c9@Rp:@E8YK@?@*JL@ ѷX@-@m\@u@jfB@P*0U@Rm@TZ@\1&@V@QX@P@MM:@Ks@A [7@7rG@1@(r Ĝ@Ov_خ@_o@o h@U=@Q@lC@ߊ	@~"@[6@Fs@*0U@L/{@S&@wXe@nt@ffffff@X@@TFs@GE84@=<64@+Q@"@4@Ϫ͟@!.I@߾vȴ9@S@0
(@Ov_خ@@
O;dZ@TɅo@j~#@iB@Xy=@[@]cf@a|Q@ql@R<64@>ߤ?@9(@.}Vl@,VϪ@ -
@3@e+a@H@&IR@@cA @C%@[W>@p@hr Ĝ@'RT`e@af@:)y@T@Ƨ@@d7@%1@ߤ?@Ov_@@Fs@ae@ݗ+k@n@@}K]@u\(@mV@Nߤ?@8)@u%F@,@ݲ-V@a@O@:)y@@ќu@҈@\N@:S@IQ@C\@Vϫ@حV@*0U2@l1&y@j~"@eO
@be+@]}H@]-V@^Q@`
qu@XPH@XD*@Vl!-@T@S*0U2@O@L/{J#@-V@#wk@e+a@v_ح@zH@Vl!@O;@҈p:@n.@Z1@@[@|n.@o hۋ@i@bC,@RS&@/-V@N;@e+a@حV@ɠ'RTa@&I@6@"`@z@@~($@Q@sh@zG@sh@a@O@=p
@y"`@h@f'@cwk@RnO@M@IoiD@>\N<@(TɅ@vȴ@6@+@y@@iB@s@NU@ ě@t@\)@[6@@N@tj@|Z@q2W@r{m@r-V@n2X@]IQ@L~($x@6}Vl@~$@E@1@~($@!R@{J#:@hr!@wkQ@d8@IQ@҉@qi@~($x@JM@@:S@|64@{A@{/V@zS&@jJL@_حV@Z1'@Xtj@TɅoi@I^5?}@B@<64@(TɅ@ -
@=K@@N@H@\(@	k~(@nP@?@Y}@C-@MjO@'RT@唯O
@[@kP|@ϐ@@&I@̈́M:@$tT@
M;@
L/@ ѷ@xl"h
@z@C@ڹ@O;d@Ʌoi@$tT@!R<@@xF]@-@o i@2W@@}Vl!@z)_@y=b@vFs@q2W@mU=@Zc	@V@Vaf@U*0@U2a|@T@Rm@Stj~@RT`d@O\(@K:)z@F]cf@B@>\N<@=b@=<64@:S&@4֡a@/Vϫ@,<쿱@(r Ĝ@%zxl"h@$xF@!.H@,=@ߤ@@>BZ@҉@+@!R<@'/@S@@\(@&IR@ 4m@#x@>B@XbM@F@}H@}H@3@\(@|@ ě@@:~ @O;@!-w@~"@/@M@Ձ$/@Z@ԕ*1@@&@|@;5X@˒:)z@y@b}V@SMj@
qv@ᰉ'@	k@`A7L@tSM@eO@Z@sPH@$/@u@rGE9@xF]@YJ@}E@x4֡b@v!.I@sg@ra|Q@pD@p:~ @o4֡a@pU2a|@n1@n2X@k6z@h$xG@dZ1@`	k@[Q@W@Gݗ+@E@@C@=ڹZ@8F@3|@-V@)y@(Xy=@'&@%S@%F
L0@$%1@	@R<6@
L_@\N@($x@l"h	@Xy=@iB@B@~"@@RT`e@u@M@6C@e+a@;dZ@ʦL/{@@@b@s@~($@)@-
@-V@r@
qv@C@U=@ᰉ'@	k@ڹ@Z@"`B@$tS@E@hr @-
q@As@jOv@L/{@$/@n.@4m9@{J#9@x}H@t֡a@rW@qiB@q&x@p:~ @oO
M@l1&y@fIQ@[=K^@`A7K@bwkQ@`
qu@]cA @]ce@\C,zx@["`B@Y|@XPH@VOv_@SZ@R<64@OAs@Kq@Hp:@B@7Xe@.1@.t@0
=q@1o@1[W>6@2䎊q@1u!S@0oiDg8@0 ě@/r@,<쿱@+U=@+Q@,VϪ@,<쿱@%ڹ@Fs@<64@䎊@
M;@ߤ?@ߤ?@qi@!R<@
5Xy>@Ƨ@
qiC@ݗ@7Kƨ@Y|@ hۋ@4֡a@ᰉ'R@䎊@͞%@n@Q@@Ƨ-@\N@^5?|@C-@a|Q@q@F
L0@3@ae@'RT`@qu!@_o@*0@@N@hr @\(@xF]@ԕ*@eO@o hی@yrGE8@sPH@hۋq
@`A7K@_o@\]ce@Xy=c@WsPH@W
=p@Vaf@UϪ͞@U2a|@Rm@Q@L@I@I@=<64@43@1[W>6@/r@0U2a|@/O
M@.1@(TɅ@	@vȴ@N;6@?@g	@ڹ@M@7@C,@҈p;@@,zxl@ [7@vȴ9X@֡a@IQ@N;6@L_@ڹY@S&@y	k~@t!-w2@l[W?@ix@]+j@W@Ov_ح@M5Xy>@IQ@C\N@?[W>@<n.@9#w@7KƧ@5?@,1&y@'-@$TɆ@%@S@@@@Xe,@@
qiC@ݗ@@@4n@
m]@
u!S@
A7K@
?@
b}@
֡af@
т@
;dZ@
_o @
)^	@
D@
,zxl@
4m@
J@
W@
r@
O
M@
{J#:@
{J#:@
H@
zxl"@
d7@
B@
u@
,<@
*0@
@
u%F
@
|#x@
{lC@
vFs@
tj~@
u\(@
rGE85@
lC@
ix@
dqj@
_?@
["`B@
RT`d@
N_o @
MjOv@
=K]@
0'RT@
*d7@
&'@
#n.3@
!.H@
Q@
6C@
ᰉ@hr@8Y@8}H@e+@;5X@@vȴ9X@<64@
(@4m@J@'RT@q@y@@~($x@o4֡a@irGE@kQ@tSMj@sg@ql@o hۋ@kP{@cS@_حV@\(\@Zc	@TE@S@SZ@Q_p@ATɅo@8Q@6z@5?|h@2a|Q@0'RT@.H@+U=@)^@'-@',@%zxl"h@#S&@!-w1@!.H@IQ@@@$tS@L_@hr @
@
	 @&I@&I@@4n@Fs@fffff@/w@@҈p:@@)^@vȴ9X@S&@?@O
M@^@eO@^ ѷY@0{@!ae@u%@&I@u%F
@
\N<@
l"h	@
GE85@
C,@
5Xy>@
ߤ?@
~($@
E@
2W@
{@
Q@
,<@
@
L_@
I^5@
hۋq@
}!.H@
x73@
sE@
sMjO@
sPH@
poiDg8@
ae@
U2a|@
Rm@
U2a|@
U2a|@
Rm@
N;5X@
JL_@
ATɅo@
Ca@N@
B74@
G)^@
Y>BZ@
\N;@
ceO@
l"h	ԕ@
l!-w@
kC]@
jJL@
j~"@
kP{@
l"h	ԕ@
kC]@
`A7K@
<n.@
%@
$tS@
*0U2@
o h@	s@	s@	lC@	
qu@	ۋq@	څݘ@	1'@	ٳ|@	bM@	҈p:@	ΤT@	@	n@	&IR@	NU@	?@	U=@	S@	Q@	0
)@	@	zG@	nO@	F]c@	}E@	|?@	y(@	w+@	weں@	sMjO@	o4֡a@	m8Y@	jJL@	ae@	U=K@	E84֡@	0U2a|@	 	k@	6C@	
M:@		'RTa@		k~(@	~($x@	Ov_@	C,zx@	u%F@	rGE9@	L_@		ԕ*@	%2@$t@!.I@oiDg8@"h	ԕ@B@Z@ᰉ'R@e+@+@т@Ƨ@E84@TɅo@K]@D@rG@z@r@
=p@!-w1@qu!@$/@u@-
q@@qi@Vu@I^5?@C%@eO@+I@$/@ ѷ@zxl"h
@qu!S@kQ@ix@gfA@f1.@b@4@`u!@_?@_حV@`d8@`u!@b}Vm@dZ1@ZQ_@W
=p@Vt@P*0U@H@Ca@N@9~($@5'0@4J@,1&y@$?@$?@u"@,<@1&x@u%F
@#@@Ʌoi@N;5@̘_@)@?@m8@{@TɅ@䎊r@Xe,@nO@rGE9@'/W@	 @Q@~\N<@sg@p
=q@k~($@iDg8~@iDg8~@ix@m\@l"h	ԕ@h@]/w@^5?|@^҈p;@ZY@Rp:@Q@S@T,<@N_o @IoiD@IoiD@GE84@F?@?|hs@/Vϫ@$tSM@ ěT@Q@1&@@@$tS@=b@_ح@4֡a@VϪ@A@ce@1'@l!-@ԕ*1@ӎMj@;dZ@K]c@Ƨ-@@~@^5?|@rG@<쿱@Q@!-w1@vȴ9@䎊r@	@IQ@C,zx@@I^5?@IQ@x-
@mhr!@f1.@cZ@a'R@_o@[W>6z@Y|@WsPH@T,<@RT`d@PH@M@JL_@?|hs@7rG@%u@vȴ9@-V@ߤ@@kP|@O
M@nO@u@o @
@
ڹY@n/@b}V@\(@@(@C,z@|Q@(\@+@)^@b@^5?|@rG@m8@-V@a|Q@z@J@W@
(@U=@y@,@@h	ԕ@wkQ@	k@+j@ߤ?@C%@=p
@_o@ ѷ@}!.H@x-
@s@p
=q@nc	@k~($@j~"@hۋq
@f,<@[6@S@Q@Ov_ح@Ov_ح@N+@N;5X@NT@N+@N+@Np:~@M@Ks@KƧ@K:)z@K)^	@JW'@GE84@As@8)@1[W>6@/Vϫ@+I^@$tSM@!ae@ [6@ [6@@@kP|@vȴ@=K^@C,zx@C,zx@IQ@u@%@!-w1@%@-V@,<@u%F@#x@Vl!@hr@.H@n.@$t@m]@C\@J#9@eں@iDg8@@fffff@ᰉ'R@D*@;dZ@As@͞%@s@]cA@Ƨ@Ƨ@)^	@#9@ȴ9Xb@ɅoiD@ȴ9Xb@y@8YK@?@2W@@@4m@<64@Y}@4֡b@KƧ@}Vl@Xy=@
qv@&@'RT`@,=@u"@vȴ@@@)^@@b}V@pD@oiDg8@l!-w@lC@de@`d8@^5?|@[6@P`A7@Jn@F-@C@A7Kƨ@?@=K]@;/V@:)y@8YJ@43@,>B[@%1@%u@"`A@"3@}H@qu!@R<6@@N@\(@
ڹY@nP@PH@MjO@4֡a@\@VϪ@	k@fffff@+a@ⶮ}Vm@
qu@]ce@Ϫ͟@2a|@`d@а{@?@@|hs@|hs@#w@}Vl@m8@$xG@Q@}H@%@ߤ@@ݗ+@S&@o h@F]c@u%F
@@hۋq@}H˒@u!R@s@q@nt@k~($@iB@hۋq
@g8}H@eO
@eO
@de@e+a@d7@bC,@ae@a'R@ae@a@N@`A7K@^҈p;@ZY@S&@RT`d@L@I@I@H˒:*@GzH@HK]c@Eo i@As@?@:S&@7Xe@49XbN@1-@/{J#:@-U=@,zxl"@+I^@(@&'@$/@ 	k@	@u"@u%@ᰉ@'/W@I^5?@u%F@oiDg@u%F
@$t@!.H@J#9@G{@C\@!.@A [@쿱[W?@빌~($@|Q@6@+@E@R@]cA@@@@@@Õ$@p
=@b@XbM@Q@sg@q@lD@^@F
L0@
=p@R<6@@@tj~@sP@N;6@Vu@qu"@@L_@ڹY@k~(@1&x@+I@Fs@ݗ+@tj@b}V@}!.H@{J#9@y(@x-
@v_ح@oiDg8@k~($@kC,z@iᰉ'@iB@j~"@kP{@kP{@iᰉ'@hr Ĝ@e`A7L@ae@]/w@Z1'@Q@M5Xy>@K:)z@Jn@I@GzH@F-@D*0@Ca@N@B74@A@As@=v@9Y}@4֡a@1-@1[W>6@0'RT@/Vϫ@.2X@.}Vl@-
qv@-V@/Vϫ@.}Vl@.zG@-U=@-V@,q@,<쿱@*͞&@)^@'&@䎊r@u"@e+a@rGE9@
	 @nP@PH@rGE8@+@F]d@!R@B@cA @Q_@+@֡af@a@O@*0U@p:~@]cA@n@W'@@@Ƨ-@]cf@)^@š@š@84֡@&IR@7Kƨ@@E@}Vl@$xG@F
L0@
=p@0
)@+J@ᰉ@$/@L_@Fs@@@S&@n@4J@$tT@Mj@!R<@O;dZ@@=p
@ ѷ@.H@~"@}Vl!@{~$@weں@sE@nc	@lC@hr Ĝ@^҈p;@Xy=c@XD*@XD*@W
=p@W
=p@TE@QN;5@N+@M5Xy>@I^5?}@H˒:*@<쿱[@;/V@8)@5?@2m\@2-V@1o@-B@(Xy=@"3@-V@1&@@_F@+j@@)^@q@YJ@:S@ "@ H˒@ @ Y|@ iB@ !-w@ B@ @ `A7L@ eO@ A7K@ ;dZ@ ҈p;@ cA @ ce@ ce@ Q_@ >6z@ t@ ԕ*1@ ҽ<64@ v_ح@ cA \@ ǮzH@ a@N@ H˒:@ @ 5Xy@ A@ )y@ rG@ {@ H@ 
qv@ zG@ w1@ zxl"@ 1&y@ 0U2a|@ y@ lD@ lD@ y@ S&@ wkQ@ h	ԕ@ o@ Ov_خ@ wkP@ 1&@ S@ O
M@ tj~@ sP@ 4J@ '/W@ Vu@ !R<@ M:@ M:@ O;dZ@ ~($x@ ҈@ O;dZ@ qiC@ b}V@ v!.I@ tSMj@ r ě@ qiB@ qA [@ poiDg8@ qu!S@ q@ poiDg8@ o@ oiDg8@ o hۋ@ o hۋ@ nO;@ m\@ l!-w@ kQ@ jg	@ g	k@ gfA@ g8}H@ g@ f,<@ bM@ ^iB@ ]+j@ \>@ ^ ѷY@ \(\@ S&@ P*0U@ O͞@ Ov_ح@ N+@ OAs@ N;5X@ L@ KƧ@ KƧ@ M%@ LcA \@ J#9@ G)^@ E8YK@ D2W@ C@ D2W@ ?|hs@ >6z@ >6z@ >vȴ9X@ ?H˒:@ @NU@ ?[W>@ ?|hs@ ?|hs@ ?@ =v@ <n.@ ;5Xy@ <쿱[@ ;A@ :)y@ 6}Vl@ 5sg@ 3|@ 0 ě@ .zG@ ,q@ +I^@ '-@ &IQ@ %1@  'RT`@ Ov_خ@ [@ C,zx@ C,zx@ Q@ S@ u%F@ Xe,@ *0@ C%@ 
	 @ K]d@ Fs@ &I@ YJ@ n/@ ݗ@ M:@ $/?	k~?+?A [?ᰉ'?Q_?`A7?W'?K]c?&IR?<64?v?)_?sg?B?O
M?'RT?}Vl?U=?1&y?1&y?u?o?U=?-
?S?u%F?@?ݗ+?|Q?s?qu!S?lC?kP{?iDg8~?g	k?c	?`d8?_o?]ce?Y|?S?RT`d?RT`d?QR?QR?QR?QR?Q?QR?PH?O
M;?Ov_ح?QR?Q?Q?P{?O
M;?L_?I^5?}?H?H?B?8YJ?1&x?.H?!-w1?@N?_o?n/?S&?JM?u%F
?      ?      ?n.?.H?\N<?ڹZ?~$?>B?~$?~$?lC?PH?+?MjO?oiDg8?-V?t?쿱[W??JL?S?e+?҈p?;dZ?҈p;?;dZ?|??@?m\?o i?\(?74?9XbN?ᰊ?-V?[W>6?[W>6?O
M? ě?O
M?Xy=?S?zxl"h?u???????TɆ?n.3?쿱[W?0
)?$/?0
)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  @@M@@MϪ͞@@M8YK@@M?@@Mb@@Mb@@Mb@@Mb@@Mb@@M,=@@M
qv@@M,=@@Mᰉ@@MS@@MS@@M
qv@@M
qv@@M(@@MoiDg@@MoiDg@@M,=@@Mᰉ@@MoiDg@@MoiDg@@M!.@@M!.@@N ѷY@@N ѷY@@Mڹ@@N ѷY@@N_o @@N4K@@N
(@@N4K@@N
(@@N@@Nu@@N
L/@@Nt@@N_o @@N
(@@N@@N!R<@@N+jg@@NE@@NL/{J@@Nc	@@Nvȴ9X@@NFs@@N6z@@N'@@O8}H@@PѷX@@Q[W>6@@Q'RTa@@Qo@@Q.H@@R&IR@@R\(@@Rvȴ@@RS&@@RS&@@R ě@@R>B@@R>B@@R ě@@R ě@@R>B@@R>B@@R@@R@@RwkQ@@Rvȴ@@R@@RL/{@@Rvȴ@@RS&@@R0
@@Rvȴ@@RwkQ@@Rvȴ@@RS&@@RS&@@RL/{@@R>B@@R}Vm@@R>B@@Rg	@@R ě@@R>B@@R ě@@Rg	@@R<64@@R@@R,<@@R,<@@R ѷ@@RfB@@R~@@Ss@@S	@@SC,z@@S"`B@@Uu@@U?@@VϪ͟@@W$tS@@WrGE9@@X}H@@XIQ@@Yo@@[g	l@@\Z@@\_@@_E84@@_rGE9@@a	k~@@be+@@cJ#9@@e!R@@nu@@}U=@@jf@@sP@@P{@@@@'R@@@@kP@@5Xy@@?@@ ě@@PH@@)^@@@@āo h@@4m9@@"`@@{m@@74@@dZ@@?@@_o @@ε'@@
=p@@'/W@@O
M@@ϱ[W>@@0
)@@~$@@ԁo h@@Z@@Z@@[@@B@@jOv@@֚,<@@fA@@تd8@@F@@*0U2a@@A [@@&x@@ُo@@xl"h
@@F]c@@a@O@@Fs@@wkP@@܇#@@*0@@p
=@@Ov_خ@@ޤT@@
=p@@eں@@ߍO;d@@-@@˒:*@@x@@䎊@@T`d@@S&@@a@N@@6@@VϪ@@wkP@@*0@@!-w@@-V@@c	@@1@@_o@@睲-V@@/V@@跀4m@@>BZ@@1'@@u%F
@@ ě@@q@@
=p@@g@@s@@64@@/{J#@@g8}@@~($x@@*1@@Z@@D@@%F
L@@L_@@=K@@Xy=@@@@Ov_@@af@@v_ح@@4m@@zH@@K]d@@+@@1&x@@6@@-
q@@A7K@@NU@@bM@@oiDg8@@e+a@@TɅo@@7KƧ@@-w1@@4J@@$tT@@@@o@@R<6@@@@2W@@iB@@I^5@@6C@@6C@@W'@@qiC@@ ѷ@@74@@G{@@G{@@c	@@	@@PH@@"`B@@,zxl@@=K^@@W>6z@@F]c@@a@N@@qu!@@xF]@@{J#9@@Q@@Q@@q@@@@C]@@@@<쿱@@Z1@@wkP@@#@@_@@*0@@1@@iB@@ߤ?@@!.I@@$tS@@!-w1@@@@>6z@@kP@@ݗ+@@4m@@sPH@@kP@@͞@@ ě@@>BZc@@|@@|@@@@-
@@IQ@@4m@@ۋq
@@Gz@@A [@@4J@@@@	k~@@D@@{@@r Ĝ@@y=c@@4m@@IQ@@4m@@4m@@D@@$/@@4J@@u%@@&@@PH@@@N@@h	ԕ@@<64@@	@@6z@@n.3@@~($@@64@@_@@@@V@@ce@@\(@@_o @@;5X@@R<6@@+J@@ȴ9X@@ hۋ@@.H@@\(@@[W>@@-@A }H@A @A }H@A -
q@A 6@A 6@A ѷ@A_p@A@N@A@N@A#w@Ax@Al@Ae@AS&@A0
@Ag	@Ac	@AZ@A@AQ@AZ1@A_@A?@A[W?@A3@AzG@A쿱[@A!-w@A@AcA @Ash@An/@AS@A
qv@AS@A.2@A1.@A5?|@A8YJ@A.2@A8YJ@Ap:~@A+J@Aߤ?@AϪ͟@AA@A1@Av@AH˒:@A@A*0U@AA7K@AoiDg8@Ar Ĝ@A|@A|@Ad8@AD@A$tT@A	@N@A	_p@A	 [7@A	4J@A	~($@A	D@A	N;6@A
Ov`@A
@4n@A
M@A
6C@A
1'@A
-V@A
Zc@A
^5?|@A
h	ԕ@A
u%F
@A
L/{@A
͞&@Au%@APH@A=K^@AMjO@AP{@AdZ@Awk@Aa@O@A6@Aa@@Aߤ@@A!-w2@A"h	ԕ@A64@AVϪ@AwkP@A/@A
K]@A
V@A
u@A
V@A
!.H@A
84֡@A
2a|@A
B@A
Vl!@A
m\@A
hr!@A
sh@A
Ϫ͞@A
8YK@A

qv@A
(@A@A8YJ@AiB@A%@AFs@Aaf@A}Vl@At@AϪ͟@AC-@A!-w1@A>6z@AAs@A\(@A@A	k@A	k@A	k@A[W>@AfA@A@A-@ArGE9@ArGE9@ArGE9@A
qu@A	ԕ+@A}H@A'RT`@A1&x@A73@AD*@AXy=@AeO@A-
@A@ATɅ@A
(@A
(@AěT@Ap:@Aۋq
@A`A7@A{@A@AJE@A(@Ay@Aԕ*@Ao@AN;6@Aԕ*@Aᰉ'@A>BZ@A@4@A0
@Ag	@A<64@Ac	@A,zxl@A~$@Aq@A6@AA [@AC]@An.@A1&y@Atj@Aߤ@@A!-w2@A"h	ԕ@AVϪ@Aq@A*1@AO
M@A֡a@A[@A@A-V@A
qv@AC\@A!R<@AYJ@AO;@A}Vl@A@A&I@A҈p;@A҈p;@Aߤ?@AMj@A)^@A1@AH˒:@Av_ح@A&@A/V@A@A6@A73@AD*@AQ@Ar Ĝ@A'RT@AěT@AěT@A_p@A0
)@AJE@A~($@A@AR<6@A@A@AN;6@AI^5@A#9@A0U2a|@A@4n@AT`d@AnO@AL_@Aᰊ@Ac	@A'/@AnP@AC,z@A	@A6z@A@N@AC%@AMjO@A{J#9@Am]@AC]@A@An.@AxF@A@A@AQ@A(\@A%1@APH@Ao h@AO
M@Au"@AQ@A(@A+a@A<64@AIQ@AIQ@AIQ@A<64@A5Xy>@A+a@A(@A+a@A*0@Ao i@A!-w@A>@A!-w@Ao i@Aqu"@A%F
L@A[@A%F
L@A<64@AF
L0@AIQ@AS&@AY|@Ash@A?@A($x@AE@A}Vl@A,<@A2X@A!.I@AXe@Av@AXe@A!-w1@A'/W@A8}H@A;dZ@ART`e@AiDg8@A&@A	k@AkP@AzH@A;dZ@AVϫ@ArGE9@A#@A @A+j@A      @A @A *0@A D*@A Q@A y=c@A 'RT@A IQ@A u%F@A {@A 
(@A ěT@A e+@A `A7@A 	k@A! [7@A!-w1@A!4J@A!ae@A!@A!l@A!N;6@A!-@A!Y}@A"u%F@A"e+@A"#9@A"#9@A"&IR@A"-V@A")y@A":)y@A"C\@A"M@A"T`d@A"Zc@A"qiC@A"0
@A">B@A"<64@A"@A"͞&@A",<@A"fB@A#S&@A#nP@A#)^	@A#=K^@A#qu!@A#tj~@A#{J#9@A#qu!@A#{J#9@A#tj~@A#~$@A#E@A#@A#|@A#
=p@A$n.@A$2W@A$tSM@A$q@A$?@A$3@A$7@A$Z@A$>B[@A%%F
L@A%?|h@A%w1@A%ݗ@A%v@A%Ϫ͞@A%?@A%!.@A%ڹ@A& ѷY@A&_o @A&H@A&YJ@A&fffff@A&s@A&IQ@A&+J@A&$t@A&@A&2X@A'Ft@A&!.I@A&Mj@A&Mj@A&!.I@A'$tS@A'4m@A'$tS@A'͞@A'͞@A'͞@A'@A'K]d@A'@A'حV@A'@@A'rG@A'rGE9@A(bM@A'#@A(F]d@A(@A(*0U@A(*0@A(1&x@A(1&x@A(}H@A('RT`@A( ě@A( ě@A($xG@A(-
q@A(>BZc@A(A7K@A(_F@A(@A()^@A(ۋq
@A(@A({@A)@N@A)*0U2a@A)0
)@A)A [@A)N;5@A)Q@A)7Kƨ@A)'RTa@A)B@A)X@A)_o@A)N;6@A)@A)ᰉ'@A)Y}@A)s@A)s@A*I^5@A*1'@A*6C@A*~"@A*S&@A*ᰊ@A*S&@A*,<@A*䎊q@A*䎊q@A*c	@A+u%@A+,zxl@A+@N@A+F]c@A+S@A+xF]@A+@A+m]@A+Z@A+Ƨ@A+a@O@A+ݗ+k@A+\N@A,L_@A,"h	ԕ@A,9XbN@A,?@A,C,zx@A,Fs@A,wkP@A,qj@A,*1@A,@A,?@A,j~@A,?@A,*0@A,Z@A,֡a@A,u"@A,/@A,JM@A,D@A,hr@A-:@A-u@A-qu"@A-!.H@A-%F
L@A-84֡@A-L_@A-`A7L@A-fA@A-$/@A--V@A-S@A-E@A._o @A.$/@A.($x@A.5?|@A.H@A.Ov_خ@A._ح@A.fffff@A.l!-@A.8YJ@A-!.@A-H˒@A-+j@A-8Y@A-,=@A-b@A-?@A-!.@A._o @A.5?|@A.fffff@A.IQ@A.+J@A.qi@A.qi@A.qi@A.2X@A.'@A.6z@A.ߤ?@A.ȴ9X@A/$tS@A/8}H@A/KƧ@A/RT`e@A/U=@A/Xe,@A/eں@A/O;d@A/$tS@A/?@A/͞@A/o @A/˒:)@A/@@A/@A0@A0$xG@A0*0@A0H@A0'RT@A0u%F@A0
(@A0҈p@A0@A0\)@A0$tT@A1 ѷ@A1	k~@A1rGE@A1+@A1@N@A0`A7      @A0C@A0	k@A1$/@A1+@A1&x@A1:S@A1Q@A1^@A1ae@A1ae@A1k~(@A1u!S@A1R<6@A1n.@A1'R@A1^5?}@A1@A1ᰉ'@A2#9@A2@4n@A2Q_@A2Zc@A2nO@A2u%F
@A2nO@A2~"@A2@A2n@A2䎊q@A2m\@A3I^@A3'/@A3s@A3"`B@A3/V@A3@N@A3W>6z@A3dZ@A3g	l@A3jf@A3Q@A3Q@A3q@A3$@A3S@A3Z@A3$@A3s@A4@A4!-w2@A4"h	ԕ@A4(\@A4"h	ԕ@A4(\@A4`d@A4tSM@A4o h@A4C@A4O
M@A4#x@A4j~@A4֡a@A4u"@A4@A4!-w@A4!-w@A4e@A4>@A4D@A4E@A5V@A5Q@A5qu"@A5!.H@A5<64@A5L_@A5O;dZ@A5O;dZ@A5Vl!@A5S&@A5Y|@A5Y|@A5ce@A5`A7L@A5ce@A5sg@A5$/@A5hr!@A5Xy=@A5@A58Y@A5cA @A5b@A5,=@A5(@A5ᰉ@A5(@A5oiDg@A5,=@A5S@A5E@A5E@A5ڹ@A6_o @A6zG@A6$/@A6;5X@A6?@A6E@A6YJ@A6_ح@A6z@A6z@A6vȴ9X@A6_ح@A6_ح@A6c	@A6%@A6+J@A6vȴ9X@A6z@A6af@A6@A6}Vl@A6$t@A6qi@A6af@A6'@A6ߤ?@A6&I@A6&I@A6A@A6+@A6쿱[W@A7@A7Ft@A7
M;@A7@A7
M;@A7@A7;dZ@A7E84@A7lC@A7{J#:@A7kP@A7-V@A7/V@A7@A7vȴ9@A7K]d@A7fA@A7حV@A7Vϫ@A7䎊r@A8     @A8     @A8@A8@A86@A86@A86@A8@A8
qu@A8@A8}H@A8     @A8     @A8	ԕ+@A8     @A7#@A7rGE9@A8	ԕ+@A86@A8*0@A84m9@A873@A8A7K@A8K]c@A8U2a|@A8bM@A8l"h	@A8u!@A8'RT@A8@A8@A8u%F@A8IQ@A8d8@A8@A8U@A89Xb@A8@@A8ѷX@A8e+@A84֡b@A84֡b@A8{@A9 ѷ@A9 ѷ@A9rGE@A9@A9@N@A9#w@A9&x@A9-w1@A9A [@A9=b@A9JE@A9XbM@A9x@A9b}@A9@A9|Q@A9@A9~($@A9@A9o@A9@A9u@A9n.@A9(@A9B@A9^5?}@A9@A9^5?}@A92W@A9iB@A9ᰉ'@A9Y}@A9lD@A:n@A:I^5@A:Ov`@A:1'@A:e+@A:䎊@A:䎊@A:䎊@A:1'@A:#9@A:#9@A:#9@A:&IR@A:)y@A:0U2a|@A:3@A:0U2a|@A:C\@A:T`d@A:a|Q@A:~"@A:@4@A:S&@A:S&@A: ě@A:}Vm@A:)_@A:͞&@A:,<@A:͞&@A:sP@A:ڹY@A:c	@A:~@A;I^@A;S&@A;S&@A;S&@A;҉@A;'/@A;҉@A;҉@A;'/@A;'/@A;C,z@A;PH@A;PH@A;	@A;	@A;&@A;/V@A;9@A;C%@A;MjO@A;g	l@A;{J#9@A;Mj@A;eO@A;$@A;a@@A;Q@A;ݗ+k@A;҈@A;%2@A;%2@A;ݗ+k@A;҈@A;%2@A;%2@A;g@A;C]@A;@A<"h	ԕ@A<C,zx@A<C,zx@A<Fs@A<?@A<<쿱@A<C,zx@A<PH@A<SMj@A<SMj@A<Z1@A<tSM@A<o h@A<#@A<*1@A<?@A<Z@A<Z@A<!-w@A=o i@A=u@A=V@A=u@A=V@A='0@A=u@A=u@A=*0@A=%F
L@A=(@A=+a@A=(@A=+a@A=+a@A=2a|@A=<64@A=B@A=L_@A=O;dZ@A=O;dZ@A=L_@A=ce@A=zxl"h@A=+j@A=%@A=@A=@A=U=@A=1@A=-V@A=H˒@A=@A=ᰉ@A=ᰉ@A=(@A=E@A>_o @A>Ov_@A>.2@A>BZc @A>R<6@A>YJ@A>_ح@A>c	@A>iB@A>iB@A>s@A>s@A>vȴ9X@A>}Vl@A>%@A>Fs@A>-@A>af@A>-@A>6z@A>-@A>2X@A>A@A>҈p;@A>ߤ?@A>x@A>@A>!.I@A?Xe@A?$tS@A?'/W@A?8}H@A?.H@A?4֡a@A?>6z@A?As@A?E84@A?\(@A?\(@A?b}V@A?iDg8@A?v_ح@A?O;d@A?-V@A?	k@A?3@A?3@A?r@A?o @A?@A?䎊r@A?䎊r@A?@@A?rGE9@A@4m9@A@4m9@A@73@A@73@A@:~ @A@>BZc@A@>BZc@A@H@A@[6@A@eO@A@eO@A@oiDg8@A@y=c@A@|@A@n@A@@A@n@A@'RT@A@-
@A@-
@A@-
@A@tj@A@u%F@A@IQ@A@@A@tj@A@u%F@A@IQ@A@U@A@
(@A@
(@A@p:@A@D@A@ۋq
@A@ۋq
@A@e+@A@e+@A@҈p@A@4֡b@A@{@A@$tT@AA@AA_p@AA_p@AA [7@AA#w@AA-w1@AA-w1@AA4J@AA:S@AADg8~@AAQ@AATɅo@AAQ@AAXbM@AAo hی@AAb}@AA@AAo@AA@AAu@AAn.@AA(@AA|@AAX@AAX@AA@AA2W@AAԕ*@AA"`@AA@AA-@AAlD@ABn@ABe+@ABOv`@AB#9@AB#9@AB䎊@AB#9@AB&IR@AB3@AB=p
@ABC\@ABJL@ABM@ABT`d@ABd7@ABh	ԕ@AB{m@AB{m@ABxl"h
@AB~"@AB0
@ABvȴ@ABS&@ABL/{@ABL/{@AB ě@AB}Vm@ABY@AB}Vm@AB}Vm@AB@AB)_@AB)_@ABW@ABW@AB,<@ABG{@AB䎊q@ABfB@ABc	@AB74@ACI^@ACS&@AC'/@AC҉@ACnP@ACPH@AC҉@AC'/@AC'/@ACPH@ACPH@AC"`B@AC/V@AC9@ACC%@ACa@N@ACdZ@ACjf@ACn.3@ACn.3@AC~$@AC{J#9@ACQ@ACeO@ACq@ACMj@ACMj@ACU=@ACwk@ACq@ACm]@ACE@ACa@O@AC6@ACƧ@ACa@O@ACa@O@AC|@AC|@AC|@AC5Xy@AC5Xy@AC@ACa@@AC
=p@ACQ@AC%2@AC%2@AC@ADJ@AD1&y@AD"h	ԕ@AD2W@ADFs@ADVϪ@AD]ce@ADj~#@ADm8@ADq@AD_@AD?@AD#x@ADj~@AD#x@ADɅoi@AD>B[@AD>B[@AD@AD@ADZ@ADD@AD!-w@ADD@ADE@ADE@AD>@AE:@AEo i@AEo i@AEV@AE/w@AEF
L0@AEO;dZ@AEO;dZ@AEY|@AE}H@AEM:@AEM:@AEڹZ@AEO
@AEݗ@AEhr!@AE!R@AEO
@AE=K@AE+j@AE%@AE@AE@AEXy=@AEU=@AE1@AE@AEϪ͞@AE@AE?@AE?@AE,=@AEE@AF ѷY@AFzG@AF4K@AF+jg@AF?@AF?@AF8YJ@AF?@AF?@AFE@AFOv_خ@AF\N<@AF\N<@AFfffff@AFp:~@AF+J@AFqi@AFFs@AFaf@AFT@AF-@AF}Vl@AFQ@AFt@AF]cf@AF1@AFx@AFFs@AFFs@AFFs@AF"@AGFt@AGv@AG$tS@AG1@AG;dZ@AGAs@AGH˒:@AGU=@AGeں@AG|hs@AGv_ح@AG4m@AG&@AGO;d@AG$tS@AGkP@AGkP@AG-V@AGkP@AG	k@AG͞@AG3@AG[W>@AG/V@AGvȴ9@AGK]d@AG+@AG@@AG-@AG-@AG+j@AH     @AH     @AH@AH6@AH}H@AH$xG@AH'RT`@AH'RT`@AH-
q@AH*0@AH-
q@AH-
q@AH73@AH:~ @AH73@AH:~ @AHK]c@AHQ@AHU2a|@AHU2a|@AH[6@AHhۋq@AHhۋq@AHoiDg8@AH˒:*@AHn@AHn@AH-
@AH@AHtj@AH-
@AHtj@AHtj@AHu%F@AHu%F@AH@AHtj@AH-
@AH)@AHp:@AHD@AH҈p@AHe+@AHe+@AHC@AH`A7@AH`A7@AH@AH4֡b@AH{@AH	k@AH4֡b@AH4֡b@AH{@AHPH@AH$tT@AH	k@AI ѷ@AI$/@AI$/@AH$tT@AI@AI@N@AI@AI@N@AI@AI_p@AI@AI-w1@AI*0U2a@AI-w1@AI*0U2a@AI-w1@AI#w@AI [7@AI&x@AI&x@AI*0U2a@AI&x@AI*0U2a@AI*0U2a@AI:S@AI=b@AIDg8~@AIJE@AIDg8~@AI[W>6@AIae@AIo hی@AIu!S@AIo hی@AIk~(@AIo hی@AIu!S@AIx@AIx@AIb}@AI7Kƨ@AIo@AIoiD@AI~($@AIo@AIR<6@AIR<6@AI'RTa@AI(@AIB@AI'R@AIX@AI@AI2W@AIo@AIN;6@AIԕ*@AI@AIiB@AI"`@AI"`@AI"`@AIᰉ'@AI>BZ@AIR@AJu%F@AI.H@AJu%F@AJu%F@AJn@AJn@AJ	 @AJ	 @AJ@AJ@AJ1'@AJ1'@AJ)y@AJ:)y@AJ@4n@AJW'@AJa|Q@AJZc@AJd7@AJkP|@AJqiC@AJnO@AJqiC@AJp:@AJݘ@AJݘ@AJݘ@AJp:@AJS&@AJS&@AJ0
@AJS&@AJ ě@AJ>B@AJ>B@AJ}Vm@AJ<64@AJ,<@AJG{@AJc	@AJc	@AJ74@AJm@AJ74@AJm\@AKI^@AKu%@AK҉@AKu%@AKnP@AKPH@AKC,z@AKPH@AK	@AK	@AK	@AKC,z@AK"`B@AK	@AK	@AK&@AK&@AKC,z@AK	@AK"`B@AK"`B@AK&@AK)^	@AK/V@AK,zxl@AK)^	@AK33333@AKF]c@AKC%@AKMjO@AKdZ@AKtj~@AK@AK@AK@AK@AKQ@AKMj@AK:)z@AKMj@AK$@AKMj@AK:)z@AK$@AKߤ@AK$@AK:)z@AK$@AKA@AKU=@AK*0U2@AK*0U2@AK@AKq@AK@AKE@AKZ@AKa@O@AKƧ@AKƧ@AK5Xy@AKƧ@AK
=p@AK҈@AKlC@AKlC@AKg@AKC]@AKg@ALJ@AL1&y@ALJ@AL1&y@AL1&y@AL@ALߤ@@ALxF@ALL_@ALQ@AL!-w2@AL!-w2@AL"h	ԕ@ALtj@ALQ@AL"h	ԕ@AL!-w2@AL,<@AL2W@AL64@AL9XbN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  @r333333@r.fffff@r$@r$@rfffff@r33333@r@rfffff@r@r      @r&fffff@r!@r@r      @r!@r#33333@r(     @r0     @r<@r>fffff@r0     @r,@r333333@r,@r1@r6fffff@r4@r.fffff@r)@r.fffff@r333333@r.fffff@r.fffff@r.fffff@r.fffff@r1@r1@r333333@r4@r.fffff@r9@r;33333@r0     @r)@r(     @r+33333@r.fffff@r0     @r>fffff@r8     @r4@r1@r0     @r0     @r0     @r.fffff@r.fffff@r333333@r.fffff@rfffff@r#33333@r1@r,@r.fffff@r(     @r$@r(     @r,@r0     @r1@r.fffff@r      @r      @r#33333@r#33333@r!@rfffff@r@r&fffff@r(     @r0     @r(     @r@rfffff@rfffff@r33333@r!@r)@r$@r33333@r     @r33333@r     @r@rfffff@rfffff@r33333@r     @r33333@r@r33333@r33333@r33333@qfffff@q@qٙ@q@q@q     @q@qfffff@qfffff@q{33333@qvfffff@q^fffff@qC33333@q+33333@q@q      @pљ@pNfffff@offfff@m33333@n33333@mY@k@jvfffff@i@i#33333@hfffff@hVfffff@h<@h     @hI@g     @g0     @fٙ@ffffff@f     @f@ffffff@f@f33333@fs33333@fi@fc33333@fY@fP     @f&fffff@efffff@efffff@efffff@ffffff@e@efffff@e33333@e     @efffff@eٙ@eə@efffff@e@e     @e@efffff@efffff@efffff@efffff@e33333@e     @e@e@e@efffff@e@e@e@e@efffff@eə@e     @efffff@e     @efffff@es33333@eY@eL@e9@e)@e)@e#33333@e      @dٙ@də@d@dfffff@d@d     @d33333@d@d     @d33333@d|@dvfffff@dp     @d\@dFfffff@d333333@d)@dfffff@d@c     @cfffff@c     @c33333@c@cs33333@cFfffff@bl@b)@b      @afffff@aٙ@a     @a@a     @a     @a     @a@a33333@a\@a0     @afffff@`     @`     @`@`fffff@`Ffffff@`@_@_@_fffff@_Ffffff@_fffff@^ٙ@^     @^33333@^l@^fffff@]33333@]33333@]@]fffff@]ffffff@]L@]L@]@     @],@]fffff@\     @\33333@\@\fffff@\y@\ffffff@\Y@\9@[@[s33333@[@Zٙ@Z33333@Zfffff@Zffffff@ZS33333@Y33333@Y9@Xfffff@Xfffff@W@W33333@Wy@W     @Wy@W@     @W@W      @V@Vٙ@V     @Vfffff@V33333@VS33333@V      @U33333@Uٙ@Ufffff@Ufffff@U@UY@U,@U,@U333333@U@     @UFfffff@Ul@Us33333@U@     @U@U@U      @Tٙ@T@T33333@S33333@R@R33333@Rl@Rffffff@R@     @R@Q@Q33333@Qٙ@Q33333@Qs33333@Q      @P     @P@PFfffff@O33333@O33333@Offffff@O@N@N     @N@     @NL@Nffffff@M     @M     @M@L@L@LY@Lffffff@LL@L      @K33333@KY@K&fffff@Ks33333@K@Js33333@I@IL@Hfffff@H@H@H     @HL@Gfffff@G333333@Fٙ@Ffffff@Fffffff@F@     @F@     @FL@F@F     @F&fffff@Eٙ@Efffff@Effffff@E&fffff@EY@E&fffff@E      @D@Dfffff@E@E@D33333@D@Dfffff@D@Ds33333@D&fffff@C@C     @Cfffff@C&fffff@Bfffff@B     @B33333@B@B     @Bfffff@BY@BY@B333333@B@B      @B@A     @Affffff@A&fffff@A&fffff@A@Afffff@A     @AY@A&fffff@A@A      @A      @@@@fffff@@s33333@@Y@@L@@333333@@&fffff@@@?fffff@?33333@?@?@?     @?L@?333333@?@>@>     @>333333@>      @=@=@=L@=     @=L@=L@=333333@=@=333333@=      @<@<@<L@<ffffff@<     @<333333@;fffff@;@;     @;ffffff@;     @;     @;@;333333@;333333@:fffff@:33333@:@:@:@9fffff@933333@933333@9@9@9     @9ffffff@9ffffff@9ffffff@9L@9L@9@9ffffff@9      @9@9@9@9      @8@8@8fffff@8@8     @8@8ffffff@8L@8     @8ffffff@8L@8333333@8@7@7@7ffffff@7L@7@7L@7      @7@6@6ffffff@6L@6@6      @5fffff@533333@5ffffff@5333333@5      @4fffff@4@4@4@4@4@4@4     @4@4L@4L@4@3fffff@3@3333333@3      @3      @3@2fffff@2@2ffffff@2@2@2@2      @2@2      @2      @1fffff@2      @2      @1@1@1@1L@1L@1L@1@1      @1      @0fffff@1      @0@0@0@0@0     @0L@0333333@0     @0L@0      @0      @0@/@/      @/333333@/@/333333@/333333@.@.@.@.ffffff@.@.ffffff@.@.ffffff@.@.ffffff@-ffffff@.      @.      @.      @-ffffff@-@-@-@.      @-ffffff@-@-@-      @,@,@,ffffff@,      @,      @,ffffff@,      @,      @,ffffff@-      @,@,@,@-      @-333333@-@-ffffff@-@-@-ffffff@-333333@-      @-      @-      @-333333@-333333@,@,@,ffffff@,@,333333@,      @+333333@+      @+333333@+      @+      @+      @+      @+      @*@+      @+      @+333333@*@*333333@+      @*@*@*333333@*333333@*333333@*ffffff@*ffffff@*@*333333@*ffffff@*ffffff@*333333@*ffffff@)@*      @)@*      @)@)@*      @*      @)@)333333@)333333@)@)ffffff@)333333@)      @(@(@)      @(@)      @)333333@)      @(ffffff@(333333@(@(@(      @(@(@(ffffff@(333333@(      @(@)ffffff@)333333@'@(333333@'@(333333@'@'@(ffffff@(      @(      @(      @(333333@(      @(333333@(333333@(      @(333333@(ffffff@(333333@'@'@'@'ffffff@'@'@'@'ffffff@'ffffff@'@'@'333333@&@'      @'@'ffffff@'333333@&@&@'      @&@&333333@&333333@&ffffff@&@&@&ffffff@&333333@&@&@&@&333333@&      @&333333@&333333@%@&ffffff@&333333@&      @&333333@%@&      @&ffffff@&ffffff@&      @&      @&      @&      @&333333@%@%@&      @&      @%@&      @&      @&333333@&      @%@&      @&333333@&@&@&333333@&      @%ffffff@%@&333333@&      @%@%ffffff@%@%@%@%@%@&      @&      @%@%ffffff@%@%@%ffffff@%333333@%@%@%@&      @&      @&      @%@%@%@%@%@&      @%@%@%@%@&      @&      @%@%@&      @%@%      @%ffffff@%333333@%ffffff@%@%@%@%333333@%@%333333@%@%@%333333@%@%333333@%333333@%      @%@&      @%333333@%      @%      @%ffffff@%333333@%ffffff@%@%@%333333@%      @%333333@%ffffff@%ffffff@%ffffff@%@%ffffff@$@%ffffff@&      @&      @$@%ffffff@%@%ffffff@&      @%      @%333333@&      @&ffffff@&ffffff@&      @&ffffff@'333333@&@&ffffff@&@&@&@'ffffff@'@&@&@'      @'ffffff@'333333@'333333@'      @&@'      @'333333@'333333@'ffffff@'333333@'333333@'      @'333333@'333333@&@&@'ffffff@'@'      @'333333@'ffffff@'333333@'333333@&@&@'ffffff@'@'      @'      @&@&ffffff@&@&@'      @&ffffff@&ffffff@&@&ffffff@&      @'333333@&@'      @'ffffff@'ffffff@'      @(ffffff@'@'ffffff@&@'ffffff@'@'@'ffffff@'333333@'ffffff@'@(      @'@'@'      @'333333@'ffffff@'@'@'ffffff@'@'@'@'@'@'@'@'@'@'@'@(ffffff@)      @(      @(333333@(ffffff@(ffffff@(ffffff@(@(ffffff@(@(ffffff@(@(@(@(ffffff@(@(@)333333@)      @(@(ffffff@(@)      @(@(@)      @)      @(@(@(@(@(@(@)333333@)@)@)333333@)333333@)333333@)ffffff@*      @)ffffff@)ffffff@)@)333333@)@)@)333333@)ffffff@)@)@)@*      @*ffffff@)@)@*      @*333333@*      @)@*333333@*      @)@*333333@*333333@)@*333333@*      @*      @*ffffff@*ffffff@*ffffff@*      @*ffffff@*@*@*@*@*@*@*@*ffffff@*@+333333@+      @*@+      @+333333@+      @+      @+ffffff@+ffffff@+ffffff@+@+333333@+@+ffffff@+      @+      @+ffffff@+@+@,333333@+      @+ffffff@+@,333333@,ffffff@,333333@,      @,@,@,ffffff@,@,@,ffffff@,@,@,@,@,@,@,ffffff@,ffffff@-333333@-333333@-      @-      @-ffffff@-@-@-333333@-333333@,@,@-333333@-ffffff@,@-333333@-333333@,@-333333@-ffffff@-@-@-      @-333333@.ffffff@-@-@.333333@-@.ffffff@-@-333333@.      @.333333@.      @-@-@.@.@.333333@.ffffff@.333333@.333333@.@/333333@.@.@.@/ffffff@.@/      @/ffffff@/      @/333333@/333333@/ffffff@/ffffff@/ffffff@/@/333333@/@/@/@/ffffff@/333333@/@/333333@/@0      @0      @0@0L@0333333@0      @/@0333333@0333333@0333333@0333333@/@/@/@0333333@0     @0ffffff@0@0333333@0@0ffffff@0L@0@0@0     @0@0@033333@0@0@0fffff@033333@033333@1      @1      @1333333@1@0fffff@033333@1333333@1ffffff@1@1333333@1      @1      @1L@1333333@1@1333333@1333333@1@1333333@1333333@0fffff@1333333@1      @1333333@1ffffff@1     @1ffffff@1@1@2      @1     @2ffffff@2@133333@2@1fffff@1fffff@1fffff@1fffff@1fffff@2@2333333@2     @2ffffff@2     @2     @2     @2333333@2L@2@2L@2ffffff@2     @2ffffff@2@3@233333@3      @3L@3L@3     @3L@3      @3L@3ffffff@3@3ffffff@3@3@3@3     @3@3     @3ffffff@3     @333333@3@3@333333@3fffff@3@3fffff@3fffff@4      @3@4      @4      @4333333@4333333@4     @4     @4333333@433333@4@4     @4     @5      @4@5      @5@4fffff@5@4fffff@5ffffff@5     @5ffffff@5333333@5@533333@533333@533333@5     @5L@5L@5@5fffff@5fffff@6      @5fffff@5fffff@5fffff@6@6ffffff@6L@6L@6ffffff@633333@7      @7      @6@7@7      @6fffff@6fffff@7      @6@7     @7333333@6fffff@7@7@7333333@7@733333@733333@733333@7@7@7fffff@8333333@7fffff@8@8333333@8ffffff@8@833333@9      @9@8@8@9      @9      @8fffff@9333333@8fffff@9L@9@9ffffff@9ffffff@9333333@9@9@9L@933333@9@9     @9     @9     @9     @9ffffff@9     @9fffff@933333@933333@9fffff@:@9fffff@:333333@:@9fffff@:      @:@:@:     @:@:     @:     @:     @:     @:@:33333@;      @:fffff@:@;@;      @;     @;ffffff@:fffff@;@;L@;L@;33333@;@;fffff@<@<333333@;@;33333@;fffff@<@<      @<ffffff@<ffffff@<     @<     @<@<@<@<@<@<fffff@<@<@<33333@<33333@<@=ffffff@=333333@=      @=ffffff@=L@=     @=@=     @=@=@=fffff@=@=fffff@>333333@>@>333333@>@>      @>@>333333@>333333@>      @>333333@>333333@>333333@>@>@>     @>@>fffff@>@>fffff@?@?      @>33333@?      @>fffff@>@>fffff@?      @?      @>@?      @?     @?fffff@?ffffff@?fffff@?@@      @?fffff@?@?33333@?fffff@?@@@@&fffff@@@@&fffff@@@@&fffff@@@@&fffff@@@     @@L@@L@@Y@@Y@@Y@@Y@@Y@@Y@@L@@Y@@@@L@@@@@@@@33333@@ٙ@@ٙ@@fffff@@fffff@A@     @A&fffff@A      @A&fffff@A@A@     @AY@Afffff@A     @Afffff@Afffff@AL@A@Afffff@Aٙ@A     @Afffff@B      @B      @A33333@Afffff@A33333@B@B333333@B@B      @B&fffff@B&fffff@BY@B@Bs33333@B@B     @B33333@Bٙ@Bٙ@B     @B     @Bfffff@B     @B@B33333@Bfffff@C@B33333@B     @B@C@C333333@C@C&fffff@C@C333333@C333333@C@     @C     @Cs33333@C     @C@C33333@C33333@C@Cٙ@C@Cٙ@D@Cfffff@D      @D@D@     @D333333@D&fffff@Dffffff@D@Ds33333@Dffffff@D     @D@Dfffff@D@D     @Dٙ@E      @D33333@Dٙ@D@E@E&fffff@E@     @EL@Effffff@Es33333@E     @Efffff@E     @Eٙ@E33333@Eٙ@E33333@F      @F&fffff@Efffff@F      @F      @E33333@Efffff@F@F333333@F&fffff@F@FL@F@     @FL@Fs33333@F@F@F     @F33333@Ffffff@F@Fٙ@F     @F     @Ffffff@F33333@Ffffff@G@Ffffff@Ffffff@Ffffff@F33333@G@G333333@F33333@G      @G@G@     @GY@G     @G333333@Gffffff@G     @Gs33333@G@G@G@G33333@G@G@G33333@G     @G@G@G@G@G33333@G33333@H333333@H333333@H      @H@H@H&fffff@H@H@     @Hffffff@H@     @H333333@H@     @H@H      @H@H333333@HY@H@     @H333333@H333333@H&fffff@H333333@H333333@HL@Hffffff@Hs33333@HL@HY@H     @Hfffff@H     @H     @H     @Hs33333@Hffffff@HY@H@Hfffff@H     @Hffffff@Hs33333@H     @H33333@H33333@H     @Hfffff@Hٙ@H33333@Hٙ@H33333@I@I@Hٙ@I@IL@IY@I&fffff@H33333@I@     @IY@I&fffff@IY@I@     @IL@IY@Iffffff@Iffffff@IY@I@Ifffff@I@I     @Ifffff@Ifffff@I33333@J@Iٙ@I@Iٙ@J&fffff@I33333@Ifffff@J      @Ifffff@I33333@Ifffff@J      @J      @J      @J@J@J      @J333333@J333333@J&fffff@J@     @JY@Js33333@J     @J     @J     @Jfffff@J@J@Jٙ@Jfffff@Jٙ@Jٙ@J33333@K@K@K      @K&fffff@K333333@K&fffff@K@     @Kffffff@Ks33333@KY@K333333@Ks33333@K@K@K@K33333@Kfffff@L      @L      @Kٙ@L      @L      @L&fffff@L333333@Kfffff@K33333@L@Kfffff@LL@LY@L      @L      @L@     @L@L333333@LL@L&fffff@K33333@L      @L&fffff@L      @L@L&fffff@Ls33333@LY@L&fffff@L@     @L     @L@Lffffff@LY@Lfffff@L33333@M      @L33333@M@L@Lٙ@Lfffff@L@Lfffff@M333333@M      @M@Lfffff@Lٙ@M@L33333@M      @M333333@M@     @ML@M333333@M333333@ML@MY@M     @M     @Ms33333@Mffffff@M@     @ML@Mfffff@M@Mfffff@Mٙ@M@Mٙ@Mٙ@N@M33333@N@N@N@N@N      @N      @N      @N&fffff@N&fffff@N333333@N@NL@N&fffff@N@NL@NL                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ?׍O;dZ?E?֗O;d?E?և+I?ָQ?׮zG?xF?1&x?$/?ى7KƧ?S?ffffff?tj~?hr Ĝ?hr Ĝ?1&?n?      ?Q?\(?M?-V?\(?^5?|?柾vȴ9?$/?1&?n?Q?tj?nO?I^5??1&?n? ě?M?M?~"?vȴ?;dZ?睲-V?+I^?\(\?+?nO?zG?
=p
?柾vȴ9?-?Q?nO;?KƧ? ě?\(?`A7K?/v?`A7L?hr!?j~"??E?;dZ?(\)?Q?\(\?+?O;dZ?Gz?vȴ?"`?dZ1?x?
=p
?x?E?ffffff?⟾vȴ9?vȴ9X?^5?|?E?$/?Vt?-V?~"?vȴ9X?-V?-V?-V?tj?n?Vt?zG?\(?hr Ĝ?hr Ĝ?`A7K?GzH?^5?|?O;dZ?&x?hr Ĝ?XbM?nP?;dZ?vȴ?ȴ9Xb?ffffff?Vu?`A7K?޸Q?`A7K?ۥS?"`A?"`B?n?ؓtj~?ؓtj~?KƧ?և+I?ԋC%?"`B?vȴ?$/?zG?bM?9XbM?
=p?\(?`A7L?-V?(\)?"`A?tj~?
=p
?ȴ9Xb?+I?E?j~#?$/?+? ě?nO;?l?-V? ě?nO;?nO;?-V?lD?&x?&x?hr Ĝ?-V?Q?-V?Q?-V?&x?&x?hr Ĝ?hr Ĝ?`A7L?&x?hr Ĝ?Q?`A7L?bM?`A7L?&x?bM?
=p?&x?
=p?`A7L? ěT?hr Ĝ? ěT?
=p?vȴ9X?bM?bM?bM?
=p?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?
=p?vȴ9X?Q?;dZ?;dZ?bM?
=p?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?vȴ9X?bM?;dZ?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?vȴ9X?Q?;dZ?Q?Q?Q?Q?;dZ?;dZ?;dZ? ěT?vȴ9X? ěT?;dZ?;dZ?bM?
=p?vȴ9X?vȴ9X?;dZ?;dZ?Q?vȴ9X?vȴ9X? ěT?;dZ?;dZ?vȴ9X?
=p?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?Q?;dZ?;dZ?;dZ? ěT? ěT?;dZ? ěT?vȴ9X?
=p?`A7L?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ? ěT?vȴ9X?bM?;dZ?;dZ?vȴ9X?vȴ9X?bM? ěT?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?
=p? ěT?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ? ěT?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ? ěT?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?vȴ9X?vȴ9X?vȴ9X?;dZ?Q?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X? ěT?vȴ9X?;dZ?;dZ?Q?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X? ěT? ěT?vȴ9X?vȴ9X? ěT? ěT? ěT?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X? ěT?;dZ?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?Q?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X? ěT? ěT? ěT?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X? ěT?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ? ěT? ěT?vȴ9X?;dZ?;dZ? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X? ěT? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X? ěT?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?;dZ?vȴ9X? ěT? ěT?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?Q?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?Q?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ? ěT?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?Q?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?Q?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?Q?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?Q?;dZ?;dZ?Q?Q?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?Q?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?Q?Q?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?;dZ?Q?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?5?|h?Q?Q?Q?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?5?|h?Q?;dZ?;dZ?Q?Q?Q?5?|h?Q?Q?Q?;dZ?;dZ?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?;dZ?Q?Q?Q?Q?Q?5?|h?Q?;dZ?Q?Q?5?|h?Q?5?|h?Q?5?|h?-V?5?|h?Q?Q?Q?;dZ?Q?5?|h?Q?Q?Q?Q?Q?Q?5?|h?5?|h?5?|h?Q?5?|h?5?|h?Q?Q?Q?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?Q?Q?5?|h?5?|h?Q?Q?5?|h?Q?Q?5?|h?5?|h?Q?Q?Q?Q?Q?Q?Q?5?|h?-V?-V?5?|h?5?|h?5?|h?5?|h?Q?Q?5?|h?Q?5?|h?5?|h?5?|h?5?|h?Q?5?|h?Q?Q?5?|h?Q?5?|h?5?|h?Q?Q?5?|h?5?|h?5?|h?Q?5?|h?5?|h?Q?5?|h?5?|h?5?|h?-V?-V?5?|h?5?|h?5?|h?Q?5?|h?/v?5?|h?5?|h?-V?/v?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?Q?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?1&y?-V?5?|h?Q?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?Q?Q?Q?-V?/v?/v?/v?-V?5?|h?5?|h?5?|h?5?|h?/v?/v?5?|h?5?|h?5?|h?/v?-V?5?|h?-V?/v?-V?5?|h?Q?-V?/v?5?|h?-V?5?|h?5?|h?-V?5?|h?5?|h?Q?5?|h?5?|h?5?|h?-V?-V?5?|h?5?|h?5?|h?/v?-V?/v?5?|h?5?|h?-V?5?|h?-V?5?|h?5?|h?5?|h?/v?/v?5?|h?Q?-V?5?|h?/v?5?|h?/v?-V?-V?5?|h?-V?-V?5?|h?-V?5?|h?-V?-V?5?|h?-V?/v?/v?1&y?-V?5?|h?5?|h?-V?-V?/v?/v?1&y?-V?5?|h?-V?/v?-V?/v?-V?5?|h?/v?-V?/v?/v?/v?5?|h?-V?-V?-V?/v?/v?/v?/v?-V?/v?/v?-V?5?|h?-V?/v?-V?-V?1&y?/v?/v?/v?/v?-V?/v?-V?Q?/v?/v?/v?/v?/v?/v?-V?-V?/v?-V?/v?/v?/v?1&y?/v?1&y?/v?/v?/v?/v?1&y?/v?-V?1&y?/v?/v?1&y?1&y?1&y?1&y?/v?-V?/v?/v?1&y?/v?/v?/v?/v?/v?-V?/v?/v?-V?/v?/v?-V?-V?1&y?1&y?/v?/v?-V?/v?/v?1&y?/v?1&y?1&y?/v?/v?/v?1&y?/v?/v?/v?/v?/v?-V?-V?1&y?1&y?/v?1&y?/v?5?|h?/v?/v?1&y?5?|h?-V?1&y?1&y?-V?1&y?1&y?/v?/v?1&y?1&y?1&y?/v?1&y?/v?-V?-V?1&y?1&y?1&y?/v?/v?1&y?/v?/v?/v?1&y?/v?-V?/v?/v?/v?-V?/v?/v?1&y?/v?/v?/v?/v?/v?/v?5?|h?1&y?-V?/v?/v?1&y?1&y?/v?1&y?1&y?1&y?-V?1&y?/v?1&y?/v?/v?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?/v?1&y?1&y?1&y?(\)?1&y?(\)?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?/v?1&y?1&y?1&y?1&y?/v?1&y?1&y?1&y?/v?1&y?/v?1&y?1&y?1&y?1&y?1&y?1&y?(\)?1&y?1&y?1&y?-V?1&y?1&y?/v?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?(\)?(\)?1&y?1&y?(\)?1&y?/v?(\)?1&y?1&y?1&y?1&y?(\)?(\)?/v?(\)?1&y?1&y?1&y?/v?1&y?1&y?(\)?(\)?1&y?1&y?/v?1&y?1&y?(\)?1&y?1&y?1&y?1&y?/v?1&y?1&y?(\)?1&y?1&y?1&y?1&y?1&y?/v?/v?(\)?1&y?1&y?1&y?1&y?(\)?1&y?1&y?1&y?(\)?1&y?1&y?1&y?1&y?1&y?/v?1&y?(\)?1&y?(\)?(\)?(\)?1&y?1&y?1&y?1&y                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  @@33333@}33333@sٙ@kfffff@f     @hp     @f333333@gFfffff@e@b@^@W@V      @TFfffff@R33333@Q     @P@L@Jfffff@H33333@Gfffff@F      @Eٙ@E33333@DL@C333333@C@BY@B      @Ds33333@D@CL@BY@Affffff@@L@>L@:@833333@9     @:@:333333@8     @7333333@5@4@2ffffff@1      @.      @-333333@,      @*@)@(@(ffffff@&@$ffffff@"@!ffffff@       @      @ffffff@333333@@@ffffff@333333@      @@@@333333@
@      @	@      @ffffff@@ffffff@@ @ @       @       ?ffffff??333333??      ?ffffff??333333?333333?񙙙?񙙙?񙙙?      ?      ??陙?陙?陙?ffffff?ffffff?ffffff?ffffff?333333?333333?      ?      ?      ?ٙ?ٙ?ٙ?ٙ?333333?333333?333333?333333?333333?ə?ə?ə?ə?ə?ə?ə?ə?ə?????????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	P13                                     1                                       )%BD*3}