CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20170205   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P12    CAST_NUMBER       2      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:35.033266Z    ORIGINAL_HEADER      6CTD,20250210CCHSIOWB
#Removed 'CTDFLUOR_TSG' as it's filled with -999
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2017-06-29. CTD data from cruise 18DD20170205, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20170205. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2017-001/index.php. 
#
# The information in this file for the cruise 2017-001 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-0036.ctd
#
# Start of originator file comment header
#
#*2017/06/29 15:26:50.02
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2017/02/10 06:17:38.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 198
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : CE9F1F72
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            0.3            202.1
#       2 Temperature:CTD               deg_C_(ITS90)   5.6248         6.8697
#       3 Salinity:CTD                  PSS-78          32.78          33.8432
#       4 Sigma-t:CTD                   kg/m^3          25.7461        26.7106
#       5 Oxygen:Dissolved:CTD:Volume   ml/l            3.4            6.87
#       6 Oxygen:Dissolved:CTD:Mass     µmol/kg         147.7          299
#       7 Fluorescence:CTD:Seapoint     mg/m^3          0.66E-01       1.162
#       8 PAR:CTD                       µE/m^2/sec      0              0.3
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        7  F       ' '     2
#       6  -99   ' '        6  F       ' '     1
#       7  -99   ' '        8  F       ' '     3
#       8  -99   ' '        7  F       ' '     1
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2017-001
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P21
#    EVENT NUMBER        : 36
#    LATITUDE            :  49  38.00000 N  ! (deg min)
#    LONGITUDE           : 139  39.97000 W  ! (deg min)
#    WATER DEPTH         : 3961
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    The descent rate of the CTD was very noisy with some complete reversals
#	of direction.
#    CTDEDIT was used to remove many records corrupted by shed wakes;
#	salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Fluorescence and PAR data are nominal and unedited except that some records were
#	removed in editing temperature and salinity and a large spike in
#	fluorescence was removed from file 0032.
#
#    The Transmissivity channel was removed because of frequent shifts in values during
#	casts and large variations between values during repeat casts.
#	The data are available, by request, from the chief scientist.
#
#    NOTE: While the Fluorescence:CTD data are expressed in concentration units, they
#	do not always compare well to extracted chlorophyll samples, particularly for
#	casts far from shore. It is recommended that users check extracted chlorophyll
#	values where available.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in Sea-Bird
#	Application Note #64-2, June 2012 revision (Sea-Bird_64-2_Jun2012.pdf), except 
#	that a small offset in the fit was allowed.
#
#    The Dissolved Oxygen sensor used in files 0001, 0002 and 0016 malfunctioned so the 
#	Oxygen:Dissolved:CTD channels were removed from those files.
#
#    The Oxygen:Dissolved:CTD sensor has a fairly long response time so data accuracy 
#	is not as high when it is in motion as it is during stops for bottles. This will be
#	especially true when vertical dissolved oxygen gradients are large. To get an estimate
#	of the accuracy of the Oxygen:Dissolved:CTD data during downcasts (after recalibration)
#	a rough comparison was made between downcast Oxygen:Dissolved:CTD data and upcast 
#	titrated samples. Some of the difference will be due to problems with flushing of 
#	Niskin bottles and/or analysis errors, so the following statement likely underestimates 
#	Oxygen:Dissolved:CTD accuracy.
#
#    Downcast (CTD files) Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.25 ml/l from 0 to 125 dbar.
#	±0.2 ml/l from 125 to 400 dbar.
#	±0.1 ml/l from 400 to 600 dbar.
#	±0.05 ml/l from 600 to 1500 dbar.
#	Low by up to 0.08 ml/l below 1500 dbar.
#
#    For details on the processing see document: 2017-001-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5--- --6-- ---7--- --8---
#!Pressu Temperat Salinity Sigma-t: Oxygen Oxyge Fluores PAR:  
#!re:CTD ure:CTD  :CTD     CTD      :Disso n:Dis cence:  CTD   
#!                                  lved:  solve CTD:          
#!                                  CTD:   d:CTD Seapoin       
#!                                  Volume :Mass t             
#!------ -------- -------- -------- ------ ----- ------- ------
#*END OF HEADER
     WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @S@        data_max      @S@        C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     _  2   pressure                	long_name         pressure   positive      down   units         decibar    data_min      ?ffffff   data_max      @fffff   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      _     pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d           temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?lD   data_max      @PH   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       _    temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d       g   salinity                	long_name         salinity   units         PSS-78     data_min      @@GlC   data_max      @ASC,z   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      _    salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d          oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @(         data_max      @rs33333   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        _    	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d       U   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?1&   data_max      ?+   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      _ m|   CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d       ̔   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       _ \   PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d       Ct   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min               data_max               C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     _ [<   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d       T   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         (    cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( D   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      )   data_max      )   C_format      %10d       l   latitude               	long_name         latitude   units         	degrees_N      data_min      @H|(\   data_max      @H|(\   C_format      %9.4f          p   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      `UVE   data_max      `UVE   C_format      %9.4f          t   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d        x   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min            data_max            C_format      %4d        |@S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     @S@     ?ffffff?ffffff@@      @@      @      @       @"      @$      @&      @(      @*333333@+@.      @0      @1      @1@4333333@4fffff@6333333@7      @8      @9ffffff@;L@<      @=      @>      @>@@      @@     @A      @A     @B      @Bffffff@C&fffff@C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @Hs33333@H33333@I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @Oٙ@PS33333@P     @P     @Q      @QFfffff@Qffffff@Qٙ@R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @Vfffff@V@W33333@W@     @W     @W     @X      @X@     @Xy@X@YL@Y     @Y     @Z      @Z@     @Z     @Z@[Ffffff@[     @[     @\      @\@     @\y@\fffff@]      @]@     @]ffffff@]@^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`Ffffff@``     @`     @`     @`     @`     @a      @a      @a9@a33333@a     @a     @a@b      @b@     @b`     @bvfffff@b@b     @b     @c      @c      @c@     @c33333@c     @c     @c33333@d      @d      @d@     @d`     @d     @d     @d     @d     @e	@e      @e@     @e`     @e     @e     @e     @e     @f      @f      @fffffff@f     @f     @f     @f     @g      @g0     @g<@g`     @g     @g     @g@hfffff@h      @h@     @h33333@h     @h     @h@ifffff@i      @i@     @i`     @i     @i     @i     @i     @j@j      @j@     @j`     @j     @j     @j@j33333@k,@k@     @k`     @k     @k     @k@l@l      @l@     @lP     @l     @l     @l     @l     @m      @m      @m@     @mY@m|@m     @m     @m33333@n@n      @n@     @n`     @n     @n     @n     @n     @n@o)@o@     @o`     @o     @o     @o33333@o@p      @p     @p      @p0     @p@     @pL@pffffff@pp     @p     @p     @p     @p@p33333@p     @p񙙙@q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q{33333@q     @q     @q     @q     @q     @q@r33333@r      @r0     @r@     @rP     @r`     @rnfffff@r{33333@r@r     @r     @r     @rfffff@s@s     @s      @s0     @s@     @sP     @s`     @sp     @s~fffff@s@s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t9@tc33333@tp     @t     @t     @t@t@t     @t     @t     @t陙@u      @u     @u      @u0     @u>fffff@uP     @u`     @up     @u     @u     @u     @u33333@u33333@u     @u     @u     @v      @v     @vfffff@v333333@v@     @vP     @v`     @vp     @v|@v     @vfffff@v     @v     @v     @v     @v     @v@w&fffff@w,@wC33333@wP     @w`     @wp     @w     @w     @wfffff@w@w     @w     @w     @w33333@x      @x     @x      @x0     @x@     @xP     @x`     @xp     @xy@xfffff@x     @x     @x     @x     @x     @y      @y     @yfffff@y0     @y@     @yP     @y`     @yp     @y~fffff@y@y     @y@y33333@y     @y     @y     @z      @z@z33333@z1@z@     @zI@z`     @zp     @z     @z     @z     @zfffff@zfffff@z     @zᙙ@zfffff@{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{y@{     @{     @{     @{     @{     @{fffff@{     @|      @|     @|!@|0     @|@     @|P     @|`     @|p     @|@|     @|fffff@|     @|     @|     @|     @|     @}@}      @}0     @};33333@}a@}p     @}     @}     @}     @}     @}     @}     @}fffff@}fffff@~      @~     @~!@~1@~@     @~P     @~`     @~p     @~     @~     @~33333@~@~     @~     @~     @~     @      @     @fffff@0     @@     @P     @`     @p     @     @     @fffff@     @     @     @     @     @@@     @      @(     @0     @8     @@     @D     @X@`     @h     @p     @x     @33333@     @     @     @     @     @     @     @     @     @ՙ@     @     @     @     @      @     @     @     @      @(     @.fffff@C33333@H     @P     @X     @`     @h     @p     @u@@     @     @     @@     @     @     @     @     @ՙ@     @     @     @      @     @     @@33333@(     @0     @8     @@     @H     @P     @W33333@`     @ffffff@p     @x     @     @     @     @     @     @fffff@@     @     @     @     @     @     @fffff@񙙙@     @      @@     @     @      @(     @0     @8     @@     @H     @P     @T@`@h     @p     @x     @     @     @     @     @@     @     @     @     @     @@     @fffff@     @      @     @@     @      @(     @,@8     @@     @H     @O33333@X     @`     @h     @p     @x     @     @33333@     @     @     @     @     @fffff@fffff@     @     @     @     @@33333@
fffff@     @     @      @(     @0     @8@@     @H     @P     @X     @`     @d@x     @     @33333@fffff@     @     @     @     @     @fffff@33333@     @     @     @     @     @@@@     @     @      @(     @0     @9@@     @H     @O33333@`     @h     @p     @x     @     @     @33333@fffff@     @     @     @     @     @     @ՙ@     @     @홙@@      @     @     @     @      @(     @,@8@@     @H     @P     @X     @`     @g33333@q@y@33333@     @     @     @     @     @     @     @33333@33333@     @     @     @     @     @      @     @@     @      @(     @0     @8     @@     @Ffffff@[33333@_33333@h     @p     @x     @     @@@33333@@33333@     @     @     @     @     @     @@񙙙@     @      @     @     @     @      @$@8     @@     @H     @P     @X@\@i@p     @x     @     @33333@     @     @@@     @     @     @     @     @     @     @     @     @     @      @     @33333@     @      @(     @0     @8     @@     @E@Y@`     @h     @p     @x     @     @     @     @@     @     @     @     @     @     @     @     @@     @     @      @     @     @     @      @(     @0@5@Q@X     @`     @k33333@p     @x     @     @     @@     @     @     @     @     @     @33333@@     @     @     @      @     @fffff@33333@      @(     @0     @8     @@     @H     @Zfffff@`     @h     @p     @x     @     @     @     @@fffff@     @     @     @     @     @@33333@     @     @      @!@(     @0     @8     @H@P     @X@_33333@h     @p     @x     @     @     @     @@fffff@     @     @     @     @     @     @33333@     @     @      @     @     @     @33333@1@8     @@     @H     @P     @X@`     @h     @p     @w33333@     @     @     @     @     @     @     @     @     @     @@fffff@33333@fffff@     @     @      @     @     @     @      @(     @.fffff@8@@     @H     @L     @[33333@`     @h     @p     @x     @     @     @     @fffff@fffff@     @     @     @     @     @33333@33333@     @     @     @      @     @     @
@@     @     @     @      @$     @(     @+@133333@333333@8     @<     @>fffff@Dfffff@H     @L     @T@X     @\fffff@_@d     @h     @l     @p     @t     @v@@     @     @     @     @     @     @     @@     @     @     @     @     @     @@ř@     @     @33333@33333@     @     @     @     @     @fffff@     @     @      @     @fffff@     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @R@Y33333@\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @@     @     @     @     @     @     @     @뙙@fffff@     @     @      @     @fffff@@     @     @     @      @$     @(     @,     @0     @4     @733333@Lfffff@P     @T     @X     @[@d     @h     @l     @p     @t     @v@     @     @     @     @     @@fffff@     @33333@@fffff@fffff@     @     @33333@     @     @     @     @     @     @     @뙙@     @     @fffff@@      @     @     @
@     @     @     @     @      @$     @'33333@0     @4     @8     @<     @@     @D     @G33333@Tfffff@X     @[33333@d@h     @l     @p     @t     @x     @|@33333@33333@     @     @     @     @     @     @     @fffff@     @@     @     @     @     @     @     @     @ϙ@@     @     @     @     @     @     @     @     @     @@33333@     @     @     @      @$     @(     @*@4     @8     @<     @?33333@H     @L     @P     @T     @X     @\     @_@hfffff@l     @p     @t     @x     @|fffff@~     @@     @     @     @     @@     @     @     @     @     @fffff@@     @     @     @͙@     @     @     @     @     @     @癙@     @     @     @fffff@     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @:@A33333@D     @H     @L     @P     @T     @X     @Z@`fffff@d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @@@     @     @     @     @     @     @@     @     @     @     @     @     @     @     @@fffff@     @     @     @     @     @@	33333@     @     @     @     @@$fffff@(     @,fffff@.fffff@4@8     @<     @>@D@H     @L     @P     @Tfffff@X     @\     @`     @d     @h     @l     @p     @t     @w33333@}33333@     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @33333@     @     @     @     @     @@홙@     @     @     @     @33333@fffff@     @     @     @     @     @fffff@!33333@$     @(     @,     @0     @3@8fffff@<     @@     @D     @H     @L     @P     @S@Y@\     @`     @d     @h     @j@q@t     @x     @|     @     @     @fffff@     @fffff@     @     @fffff@@     @     @     @     @fffff@@     @     @     @     @@@     @ۙ@fffff@     @     @     @@@     @      @     @     @33333@fffff@     @     @@ @$     @(     @,     @0     @4fffff@8     @<     @@     @D     @H     @L     @P@T     @X     @\     @`     @d     @h     @l     @o33333@xfffff@|     @     @     @     @     @33333@33333@     @     @     @     @33333@33333@     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @33333@     @     @      @     @@@     @     @     @      @$     @(     @,     @.fffff@6     @8     @<     @@     @D     @G@P     @Tfffff@W@\     @`     @d     @h     @l     @p     @t     @x     @z     @@     @fffff@     @     @     @     @     @fffff@@     @     @     @     @     @@33333@     @     @     @     @     @     @     @     @     @     @󙙙@@      @     @     @     @     @@fffff@@ fffff@$     @(     @,fffff@0     @4     @8     @<     @@     @D     @Ffffff@L@P     @T     @X     @\     @^fffff@e@h     @l     @p     @s@x@|     @     @     @     @     @     @     @fffff@33333@     @     @33333@     @     @     @fffff@fffff@     @     @     @     @33333@     @     @     @     @     @癙@     @     @     @     @     @      @     @     @     @     @     @     @     @@$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @Q@T     @X     @\     @`     @d     @f@pfffff@t     @x     @|     @@@fffff@     @     @     @     @     @     @33333@@     @     @     @     @     @     @˙@ՙ@     @     @     @     @     @fffff@fffff@     @     @      @     @     @
@@     @     @      @#@-@0     @4fffff@7@<     @@     @D     @H     @L     @P     @T     @X     @Z     @b     @d     @h     @k33333@q33333@t     @x     @|     @     @     @     @     @     @     @@     @     @     @     @     @     @     @@@     @     @     @     @     @     @fffff@ݙ@     @     @     @fffff@񙙙@     @     @     @      @fffff@@     @     @     @     @      @$     @(     @4fffff@8     @<     @@     @D     @H     @Q@T     @X     @\     @`     @d     @h     @k33333@tfffff@x     @|     @     @     @33333@fffff@     @     @     @     @@@     @     @     @     @     @@fffff@     @     @     @ߙ@33333@     @     @@     @@fffff@     @     @     @      @$     @&fffff@0fffff@4     @8     @<     @@     @D     @F@T     @X     @\     @`     @d     @g33333@r     @t     @x     @|     @     @     @     @33333@@     @     @     @     @     @@     @     @     @fffff@     @     @     @@@     @     @     @     @     @     @     @     @     @     @@@     @     @     @     @@&     @(     @,     @0     @4     @7@A@D     @H     @L     @P     @S@a33333@d     @h     @l     @p     @t     @x     @|     @33333@     @     @     @     @     @     @     @@fffff@     @     @     @     @     @     @     @fffff@fffff@33333@     @     @     @     @     @     @     @33333@     @      @     @     @33333@
     @     @     @@33333@@33333@     @     @     @      @"     @$     @&     @(     @)@,     @.     @0     @2     @4     @8@:     @<     @>     @@     @B     @D     @E@H     @J     @L     @N     @P     @R     @T     @V     @Z@\     @^     @`     @b     @c@h     @j     @k@n     @p     @r33333@s@v     @x     @z     @|     @~     @fffff@     @33333@     @     @     @fffff@     @     @33333@     @@@     @     @     @@     @     @     @@@     @     @     @@fffff@     @     @@33333@     @     @     @@     @     @     @     @     @fffff@ܙ@     @     @     @     @     @ꙙ@     @     @     @񙙙@@     @     @     @     @@@     @     @     @     @
     @fffff@     @     @     @     @     @@      @"     @$     @&     @(     @*     @+     @0@2     @4     @6     @8     @:     @<     @>     @?@Dfffff@F     @H     @J     @L     @N     @O@T@V     @X     @Z     @\     @^     @`     @a@ffffff@g@j     @l     @n     @p     @v33333@x     @z     @|     @~     @fffff@@     @     @     @     @     @     @@     @     @     @     @33333@     @@     @     @     @     @fffff@     @     @     @     @fffff@     @     @     @     @     @33333@     @     @     @     @     @     @@     @     @     @     @ߙ@33333@     @@     @     @     @fffff@33333@     @     @     @     @fffff@ @     @     @     @
     @     @     @     @     @     @@fffff@     @     @      @"     @#     @&fffff@(     @)@,33333@.     @033333@2     @4     @6     @8     @:     @<     @>     @?33333@B@D     @F     @H     @J     @L     @N     @P     @R     @S@V     @X     @Z     @\     @^     @`     @b     @d33333@e@h     @j     @l     @n     @offfff@rfffff@t     @v     @x     @z     @|     @fffff@     @     @     @     @fffff@fffff@     @     @     @     @     @     @     @     @     @@@fffff@     @     @     @     @     @     @     @33333@     @     @     @     @@     @fffff@Й@     @     @     @     @     @     @ݙ@33333@     @     @癙@33333@     @     @     @     @     @fffff@     @     @      @     @33333@33333@	@@     @     @     @     @     @     @33333@@      @!fffff@$@&     @(     @*     @,     @.     @033333@1@333333@6fffff@8     @:     @<     @>     @@     @Afffff@F     @H     @J     @L33333@M     @P@R     @T     @V     @X     @Y33333@^     @`     @a@d@f     @h     @j     @l     @n     @p     @r     @v@x     @z     @|     @~     @@fffff@33333@@     @     @     @     @     @     @     @@@     @     @     @     @     @33333@@     @fffff@fffff@     @     @     @     @@fffff@     @     @     @͙@     @     @     @     @     @33333@33333@     @33333@fffff@     @     @     @     @     @     @@@     @33333@@     @     @@fffff@     @     @
     @@@     @@     @     @     @     @     @fffff@#     @$     @&     @(     @*     @+fffff@0     @2     @4     @533333@9     @:     @<     @>     @@     @B     @D     @F     @H33333@J33333@L     @N     @P     @R     @T     @V33333@W33333@Zfffff@\     @^     @`     @b     @d     @h@j     @l     @m33333@p@r     @t     @v     @x     @z     @|     @}33333@33333@     @     @     @@@     @     @     @     @     @     @fffff@     @     @     @33333@     @@     @     @     @33333@     @     @     @     @     @@@     @     @@     @     @     @     @     @     @     @@     @     @     @     @33333@33333@33333@     @     @     @     @     @@@     @     @     @     @33333@@     @     @     @	33333@fffff@     @@33333@     @     @     @     @33333@     @"     @$     @&     @(     @*     @+33333@.@0     @2     @4     @6     @833333@:@<     @>     @@     @B     @D     @F33333@G@J     @K@N     @P     @R     @T     @V     @X     @Y@^fffff@`     @b     @d     @f     @h     @j     @l33333@m@p     @r     @t     @v     @wfffff@z33333@|     @~     @@     @     @     @     @     @33333@fffff@     @     @     @33333@33333@     @     @     @     @@fffff@     @     @@@     @     @     @     @@@     @     @     @     @@fffff@     @     @33333@     @     @     @     @     @     @     @     @     @33333@     @     @33333@     @     @     @     @     @     @33333@     @     @      @     @     @     @     @
     @     @
@     @     @     @     @@33333@     @      @!@$     @&     @(     @)@,     @.     @0     @2     @4     @6     @<     @>     @@     @B     @C@J@L     @N     @P     @R     @S@Z33333@\     @^     @_33333@d33333@f     @h     @j     @k@p@r     @t     @v     @x     @z     @{@33333@     @     @     @     @     @     @     @     @     @     @     @33333@33333@33333@@     @     @     @     @33333@     @     @     @     @     @@     @     @33333@     @     @     @     @     @     @     @֙@     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @	@     @     @@@     @     @     @      @"     @$     @%@'@*     @,33333@-@0     @2     @4     @6     @833333@9@<     @>     @@     @B     @D     @F33333@L     @N     @P     @R33333@S33333@X33333@Z     @\     @]@`     @b     @d     @f     @h     @j33333@l     @n     @p     @r     @t     @v     @x     @yfffff@}     @~     @     @     @     @     @33333@@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @@33333@     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @@     @     @     @     @@     @     @     @      @33333@     @     @     @
     @     @     @@     @     @     @     @33333@@@      @"     @$     @&     @(     @*     @,     @.     @0     @2     @4     @6     @7@:     @<     @>     @@     @B     @D     @F     @H     @J     @K@N     @P     @R     @T     @V     @X     @Yfffff@]@`     @b     @d     @e33333@j33333@l     @n     @p     @r     @t     @v     @x     @z     @|     @~     @     @     @     @     @33333@@     @     @     @33333@@     @     @     @     @     @33333@     @     @33333@     @     @     @     @     @     @33333@@     @     @     @     @     @@@     @     @     @     @     @@     @     @     @     @     @33333@@     @     @     @     @     @     @     @     @@@     @     @     @     @     @     @      @     @     @     @     @
     @     @33333@@     @     @     @     @     @33333@33333@      @"     @$     @&     @(     @*     @,33333@.     @/@2     @4     @6     @8     @:     @<     @>     @@     @B     @D     @Efffff@H@I@L     @N     @P     @R     @T     @U@X     @Z     @\     @^     @`     @b     @d33333@f     @h     @j     @l     @n     @p     @r     @s@v     @x     @z     @|     @~     @     @     @     @fffff@@     @     @     @33333@@     @     @fffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @33333@E@MjO@m\@MjO@g@!-w2@֡a@Y|@Y|@'0@!R@'0@?|h@sg@j~@ ě@-V@a|Q@ᰊ@-V@{@ ě@ hۋ@[W?@<쿱@U=@6z@͞&@C,z@6z@fB@~"@d7@Ov`@d7@0U2a|@d7@~"@0
@fB@JL@*0U2a@\)@rGE@rGE@rGE@B@B@lD@Ov`@0
@~"@Ov`@Ov`@0U2a|@JL@JL@~"@0
@0
@JL@g	@͞&@fB@g	@d7@JL@g	@g	@0
@g	@g	@fB@͞&@͞&@fB@fB@C,z@6z@6z@6z@P{@jf@~($@1&y@a@@U=@jf@C]@C@zxl"@(@ hۋ@2W@'0@+@2a|@U=@SMj@%F
L@"`@
ڹY@m@WO;d@$/@@
=p@@PH@&x@@nP@or@HeO@0 ě@tj@K]c@ȴ9X@D@.2@R<6@8YJ@˒:)z@ۋq
@vȴ@L_@TɅo@s|@eF
L0@]cA @XU@Sa@O@=v@4m8@(@m@	k~(@oiDg@F]c@ [7@~$@zG@)^@-
@W@zG@u@b}V@vC-@tm8@r-V@ZY@8F]d@(TɅ@ [6@R@~($x@ڹZ@\)@ڹY@Ňݗ@u!@$/@mV@b3@][@X@@RnO@1o@N;@1&x@@o@_o@҈p:@H@!.I@	k@'RT`@ᰉ@I ѷ@@hۋq@;5Xy@;s@:S&@:)y@9XbM@8l"h	@-V@(\)@'lC@-V@ ѷY@a@O@E@_o@m\@Z@/w@p:@(@&I@zC\@g,@Vaf@KC%@F&I@@ѷX@=H˒@1&@
qu@,zxl@rG@Zc@|PH@y"`@x)@vE@tJ@o{J#:@l>B[@`ěT@C@5%F
L@.}Vl@x@ěT@̘_@hr@}H@0
@sPH@mB@TFs@4#@#S&@(\@Ϫ͟@O
M@Z@u"@qu"@7Kƨ@#x@}H@@cA @W>6z@+J@k~(@}H˒@jJL@TzG@71@	@K]d@O;@fffff@A [@C,@䎊r@a@O@͸@Q@p
=@e@
=p@p:~@E84@@x73@WXe,@JڹY@>($x@6Fs@2ᰊ@2a|Q@1-@2s@wkP@Q@Ov`@>6z@F]c@*0U@@}ڹZ@q-@h@aR<6@\>@Z6C@WXe,@9"`@#	@!-w1@$/@
W'@      @4K@B@	ԕ+@ֻ@˒:)@#w@33333@ ě@3@}H@YJ@rG@Fs@A [@JL@A@>@X@!R<@Fs@@{lC@k~($@`
qu@Qu@L@@hۋq@7kP@7KƧ@4!-w2@4m8@4SMj@7Xe@:>B@:~@8Q@(>BZc@ [6@u%@@2a|@ݗ+k@K]c@
(@S&@ȴ9X@U=@	ԕ+@'@H@;5X@ɺ^5?}@8YK@4m@#x@!.I@o@}Vl@33333@n.@BZc @kP@	k~@'0@@ߤ@@S@	ԕ+@JL@'@&@jf@<쿱@/@حV@u@ڹ@?@n.3@.H@쿱[W@Q@҈p;@C,zx@q@>@҈@]}H@u!R@p
=q@zH@bM@҉@<64@n@T@@zH@-@m\@~BZc @yrGE8@x)@sߤ@or@lC@f,<@cwk@^5?|@W+j@JW'@E@=H˒@,1&y@حV@v_ح@E84@@nP@PH@b}V@$/@&IR@BZc @rGE8@}H@!.I@s@&x@ hۋ@Z1@ޞ@ce@ڟvȴ@c	@kP|@JE@bM@Ov_@Ж@5Xy>@oiDg@b@XbM@G{@lC@
(@@'0@-@	ԕ+@o@@wkP@q@(\@b}@e+@+j@<64@'/@7Kƨ@xF@tj~@p{@n1@r ě@p:~ @dtSM@`d8@_!-w1@\wkP@X*0@T@KƧ@<?@4SMj@?|hs@Fs@?[W>@>\N<@?b}V@8-
@0'RT@,C@&x@'8}H@#
=p@}H@vȴ9X@\@VϪ@ᰉ'@$xG@	ԕ+@@'@	k@u%@zG@W'@o i@āo h@a@N@s@4m9@64@G{@D@)y@n.@5Xy@v@@cA \@k~(@{@JL@tSM@e@@N@N;@@`d@Ʌoi@\(@ߤ?@qi@L_@	 @@7KƧ@8YK@?@@@$/@x)@uY|@tJ@r{m@lq@j0
@i*0U2a@jfB@jfB@jd7@iᰉ'@i^@ix@jg	@irGE@d?@cZ@b`A@bh	ԕ@cwk@c	@\N;@UfA@K)^	@Bu%F
@>ߤ?@=p
=@;/V@84֡b@74m@6z@6+jg@5'0@4SMj@3E@2W@0@+C]@(>BZc@wkP@,<@0
)@2a|@<64@T@zH@84֡@I^5@$/@ C@ڹZ@Q@s@kP@E@SMj@g@iB@ᰉ'@ⶮ}Vm@|Q@A7K@>@څݘ@ěS@}Vl@E@'0@r@>B[@v@{J#:@*0U2a@*0@sh@-
q@ߤ?@'/W@	 @+I@Q@&I@u%F@o h@y"`@mhr!@l!-w@l[W?@m8Y@jfB@e`A7L@["`B@WsPH@Vaf@UϪ͞@Zݘ@W>6z@S&@O
M;@A@9Y}@8)@73@73@8)@:)y@>BZc @>
(@<쿱[@>BZc @U=@N;6@*0U2@$tT@N;6@I^5@?@J#9@~$@>B@	k~@F]d@%F
L@䎊q@GE85@.2@	k@iB@*0U@@,zxl@vȴ9X@D@|@-w1@Ov_@~($x@u!.@r䎊q@g8}H@m\@nt@lC@o-V@mC\@l"h	ԕ@g	k@]cA @\?@ZY@YJE@WsPH@LcA \@JL_@D*0@?H˒:@8}H@6C-@)lD@O
M@@	ԕ*@	 ѷ@#@o h@S&@tj@@o hی@n.@o hی@
$t@
?@
~$@
F]d@
fB      @
@
&x@
O
M@
V@
͞&@
I^@
I^@
0
@
lD@
y@
@
wk@
u@
@
$tS@
*0@
@N@
:)y@
@
L_@
tj~@
bM@
C%@
}ڹZ@
{J#9@
yrGE8@
wkP@
w1@
w+@
pD@
kQ@
[W>6z@
Jn@
6E@
2m\@
-B@
)*0U2a@
&@
#n.3@
vȴ9@
,=@
[@
C,zx@
Q@
*0@
@
'/W@
@
ڹY@
	ԕ*@
{J#9@
n.@C\@!.@u!S@"h	ԕ@1.@7@eO@ܑN;@>6z@fA@҈p:@)^	@rG@W@V@1&y@U=@/V@wkQ@-
@e+a@L_@qiC@oiDg@u%F
@.H@|?@{m]@poiDg8@g@bM@`d8@[$@PH@ATɅo@1o@&'@vȴ9@}H@S@rGE9@tj@.H@l@~"@fffff@e@M@iB@/w@1'@>BZ@ڹY@u!@c	@D*@sPH@
M;@2W@^5?|@֡a@q@d7@9@[6@U=@u@@\(@1&x@S&@$/@$/@~"@{m]@zC\@tSMj@lC@g@\(\@Y>BZ@W>6z@UfA@SZ@NT@Fs@7KƧ@-B@*d7@)*0U2a@(Xy=@%1@ 	k@PH@PH@@@$tS@sh@'/W@	ԕ*@	 ѷ@$/@҈@n.@
	k~@
D@
A@
e@
|Q@
Zc@
n.@
5Xy@
4m@
u%@
tj@
S&@
qi@
+I@
y"`@
sg@
jfB@
_;dZ@
\>@
]/w@
\N;@
Xe+@
SMj@
QR@
R䎊@
QR@
P{@
Q_p@
Jn@
Gy@
B@
@6@
7Xe@
.}Vl@
"3@
ߤ@@
0
)@
L_@
tj~@
nO@
Vu@

@
҈@
	7KƧ@
ݗ+@

L/{@
@
I^5@	(@	lC@	Gz@	$@	fA@	>6z@	D*@	>@	ݗ+j@	t@	l!-@	՛=K@	m@	ěS@	sP@	Ov_@	*0@	tj@	vȴ@	q@	
=p@	_o @	84֡@	
(@	Xy=@	%@	)^@	-
q@	o @	_o@	F]c@	$/@	b}V@	|hr@	{J#9@	weں@	r䎊q@	nO;@	^@	F
L/@	=b@	8YJ@	&IQ@	 	k@	@	?@$t@@ⶮ}Vm@@N@ߤ?@ ѷY@C,@حV@Ϫ͞@v_ح@@v_ح@E@8YJ@1'@/w@Dg8~@!-w@c	@PH@kP@	$/@	1&x@	
	 @	
ڹY@	
	 @	$tT@	@	*0U2@	Fs@E@Fs@Fs@ۋq@͞%@Q@@@84֡@s@6z@͞%@\(@}Vl@}Vl@	k@N;6@I^5?@qu"@O;dZ@@I^5@IQ@:S@~$t@{lC@kQ@S&@IQ@C,zxl@=p
=@7Xe@BZc@F]cf@E84֡@6z@!-w1@\N<@Y|@c	@P{@c	@E@#@vȴ@'RT`e@)y@&x@%zxl"h@%F
L0@#9@PH@	ԕ*@u%F
@t@C@ hۋ@GE85@Y|@eں@G{@\N<@(@j~@PH@!-w2@!R@PH@-V@r Ĝ@Dg8~@빌~($@fA@ⶮ}Vm@҈p;@"`B@fA@H@ӎMj@y@~@Xy=@g	l@J@ߤ@ᰊ@[W>6@q@zxl"h@n.3@1@N;6@Mj@)^@:)y@)^@rGE9@eO@Fs@eO@'/@ԕ*@iᰉ'@a'R@\(\@Zݘ@`
qu@_;dZ@L_@A@;5Xy@5Xy=@333333@"h	ԕ@R<6@!R<@)^@oiDg@	k~@A@Z1@	@
qu@JE@Ϫ͞@ק&@bM@Ϫ͟@jOv@H@)y@W@v@zxl"@RT`e@/V@-@&@/V@x@u@x@IQ@+j@sh@p:@+I@ݗ@@@˒:)@~m\@{m]@y	k~@l"h	ԕ@e@ae@a|Q@[q@U=K@Rm@G)^@@4m@?[W>@/Vϫ@*͞&@qu!@
(@S&@ ѷX@b}V@J#9@=b@+@#@(@g	@rGE@Ft@ٳ|@bM@>6z@>6z@8YJ@fA@@ѷX@H@
M;@K]c@s@2W@ߤ?@<64@֡a@V@Xy=@TɆ@쿱[W@=K^@sh@@I^5?@_o@M:@w1@w1@w1@vFs@vȴ9X@u!.@sE@o-V@Rm@Ks@GE84@@NU@8}H@2m\@.}Vl@0
(@/{J#:@.H@,>B[@u%@,<@1&@-V@}H@}H@U=@	@쿱[W@u"@Xe,@xF]@+I@$t@s@+@Y|@@.2@x@䎊qj@|Q@u!@ ѷY@ݗ+j@ݗ+j@ݗ+j@cA @ݗ+j@ܑN;@/w@ٳ|@l!-@m@v_ح@:@@5Xy>@/{J#@n@o i@ěS@m\@\N@NU@K]@3@ ě@a@@/V@S&@u%F@sP@-
q@q@ݗ@JM@ ѷ@ѷX@~"@b}V@$tS@.H@~m\@~"@~"@}!.H@zG{@x-
@v+jg@u!.@u\(@tD@sg@qiB@mC\@l[W?@kQ@a|Q@Y>BZ@Y+@W
=p@U=K@R䎊@N;5X@Jn@F
L/@=p
=@84֡b@2m\@/Vϫ@-V@,zxl"@)^@&x@*0@@N@bM@p:@$/@\N<@Q@>B@1@@A [@҈p;@+@>6z@Ϫ͞@E@`d@ҽ<64@҈p:@䎊@a@O@T`d@ѷX@_p@+@:@˒:)z@Ƨ@@s@6@쿱[@Q@sg@o@w1@\)@TɅ@TɅ@?@}H@$/@@N@:)y@N;6@nO@)^@Mj@L_@Fs@S&@o h@%2@@4n@~"@}Vl!@|hr@|hr@|Q@|Q@ѷX@{~$@zC\@y(@y=b@w+@tj~@qA [@qu!S@o@l[W?@g8}H@eڹ@c	@Zݘ@W&@UϪ͞@SMj@Rp:@R䎊@PH@NT@JW'@B74@>
(@:~@6z@1-@-V@&x@#
=p@%@qu!@O;d@u@-
q@rGE9@\(@'/W@
M:@
M:@Vu@
qiC@ݗ@:S@@=b@j~@{m@@@C\@Ft@ѷX@:@/{J#@˒:)z@̘_@@š@o i@[W>@p
=@)y@#w@Xe@33333@w1@&@u@n.3@[6@,=@u"@u"@,=@-V@IQ@}H@}H@-V@	@%@,=@-V@ߤ@@$tS@*0@L_@-
q@@q@	 @'RTa@p:@#@{J#9@sPH@rs@p
=q@jfB@cS@bM@d7@]+j@XU@Vl!-@S@Rp:@N_o @L@K]cA@JD@IQ@G)^@D*0@B\(@<j~#@;A@6C-@2m\@1-@+a@@%S@%zxl"h@$/@$?@#
=p@#wk@#9@"wkQ@ ěT@%@1&@C,zx@qu!@PH@Fs@$tT@
(@
	 @@tj@@4n@o hی@ hۋq@>B@l"h	@eں@A [@C@Z1@d8@iB@]ce@"`B@b}@ٳ|@څݘ@,<@т@š@o i@g8}@&IR@6@@v@S&@-@a@@0
@lD@@6z@*0U2a@$xG@,@'@L/{J@F
L0@F
L0@.H@-
@!-w1@0
)@$/@$/@ᰉ@R<6@+J@R<6@+J@$tS@Z@ݗ+k@҉@:)y@)^@hr @Mj@@k~(@ѷX@{s@y(@|?@xl"h	@u!R@tSMj@rs@qiB@u%F
L@p@nO;@m(@kC]@h>BZc@dZ1@`A7K@_;dZ@]+j@]ce@]+j@\]ce@["`B@Zݘ@UfA@Sa@O@SMj@R<64@P`A7@MjOv@LcA \@D*0@A@?|hs@>vȴ9X@>BZc @=v@<64@9#w@4m8@2W@2-V@2ᰊ@2a|Q@.}Vl@)lD@'&@&'@$TɆ@"`A@䎊r@-V@ߤ@@u%@kP|@@6C@_o@O;d@@L_@*0U2@u@!R<@
L/{@#@YJ@&I@%2@I^5@ .H@ "@ m\@ hr@ F@ 73@ kP@ Fs@ \(@ l@ 8Y@ "h	ԕ@ Ov`@ JL@ ᰉ'@ ۋq
@ `A7L@ 	@ e@ @4@ حV@ حV@ W>6z@ ٳ|@ D*@ Ϫ͞@ ӎMj@ &@ ӎMj@ ӎMj@ ҽ<64@ 䎊@ N;5@ `A7@ As@ :@ )^@ m\@ a@N@ @ ߤ?@ /V@ )_@ Q@ 4K@ 1@ >B[@ 1&y@ 0U2a|@ F
L0@ tSM@ TɆ@ /@ xF@ 	k@ Ov_خ@ ߤ@@ 6C@ *0U2@ Mj@ =p
@ +I@ n.@ b}V@ ~m\@ }ڹZ@ |#x@ {m]@ zxl"h
@ yrGE8@ w+@ x-
@ w1@ u%F
L@ r ě@ r{m@ qiB@ o4֡a@ m8Y@ lVϪ@ l!-w@ rs@ nt@ l[W?@ k~($@ kC,z@ e@ ^5?|@ ^5?|@ a@N@ \>@ YJE@ W@ UfA@ QX@ M5Xy>@ I@ Em\@ BZc@ @6@ <64@ 8YJ@ 6}Vl@ 6}Vl@ 6C-@ 5sg@ 2W@ 1o@ 1[W>6@ ,<쿱@ +U=@ )^@ &L/{J@ #
=p@ %S@  	k@ 䎊r@ u@ wkP@ qu!@ 0
)@ _F@ Xe,@ Ov_@ sh@ zG@ zG@ Fs@ tj~@ -
q@ 
L/{@ +I@ F]c@  IQ@ @ n.?$tS?>B?Fs?s?4֡a?t?VϪ?JL??e?C,? ѷY?8YJ?5Xy>?@?@?8YK?m\??{?1?1?'RT?
=p?
=p?'?*0U2a?'???Xy=?o?vȴ9?,<?tj~?O;dZ?	 ?eO?|Q?xF]d?n.2?iDg8~?h	ԕ+?a|Q?`d8?]cA ?TɅoi?RT`d?R<64?Q?P{?O;dZ?Ov_ح?O
M;?IQ?F]cf?=K]?9XbM?2a|Q?1&x?+a@?)^?(\)?(\)?(\)?(?'RT`e?'/V?[?nO?ߤ??҈??'/?	 ѷ?S&?ڹZ?eں?C]?҈p?fA?`A7?*0U?5Xy>?\(?Z?4m?|?r?1&y?u?S??_F?@?$tS?$tS?ᰉ?@?$/?-
q??O;dZ?!R<?!R<??q?#?o hی?}Vl!?|Q?{J#9?{J#9?y=b?wkP?v_ح?v_ح?vȴ9X?oiDg8?e+a?]ce?Zݘ?Xe+?W>6z?VϪ͟?S?S&?S&?R<64?SMj?PH?RT`d?Q_p?M:?JD?GzH?GE84?E?D*0?C\N?As?As?BZc?BZc?C\N?C$?C\N?D*0?<64?2a|Q?/v?+jf?)^?&? ěT?}H?C,zx?u%?6C?_o?n?I^5?s?+?eں?Fs?\(?#?(?Q?ᰉ'?e?@4?ᰉ'R????֡af?5Xy>?)^	?@?K]c?ȴ9Xb?K]c?Ƨ-?ěS?\(?m\?2W??\(?6?A?Xe?Xe?E?'0?|?r?d7?
=p?u?=K^?,<?,<??$tS?O
M?Fs?҉?hr ?-
q?~($x?L_?C%?	 ?eO?ݗ+?ݗ+?YJ?YJ?o hی?$/?˒:)?~"?}H˒?{J#9?y=b?u!.?tSMj?p
=q?kP{?iDg8~?hr Ĝ?ceO?dZ1?a|Q?_حV?a@N?a|Q?_حV?_o?\N;?\>?]cA ?[W>6z?W&?W>6z?W&?W>6z?Vl!-?Vl!-?SMj?O
M;?L/{J#?I^5?}?I^5?}?F]cf?H?E84֡?E?Dg8}?B?>BZc ?=p
=?=p
=?9D?6z?5?|h?3ߤ?333333?2W?0
(?/Vϫ?1o?0
(?/{J#:?/{J#:?.H?,<쿱?(\)?'/V?$/?"h	ԕ?Q?1&?qu!?qu!?qu!?+J?zG?'/W?҈?'/?	k~(?	ԕ*?	ԕ*?u%F?1&x?Fs??      ?ڹZ?~$?C\?	k~?-
?!.I?D?#?!-w2?E?D?oiDg8?      ?VϪ?JL????Z?Gz?ߤ??҈p;?;dZ?>BZ?
=p?m?*0U?ȴ9Xb?ɅoiD?ɅoiD??ɅoiD?ěS?n?H˒:?6?&IR?&IR?n?vȴ9X?Z?~($?4m?sg?9XbN?{?U=?*0U2a?6z?d7?lD?*0U2a?-?,?TɅ?'???o?%?-V?u?%?u?kP|?_F?O;d?$tS?ᰉ?hr ?qi?~($x?+I???%2??@4n?@4n?@4n?$/?|Q?zxl"h
?xF?xF]d?wkP?w1?y(?xF?xF?y=b?y(?y(?xF?y=b?zG{?{m]?}Vl!?}H˒?~"?~"?b}V?}Vl!?{m]?zxl"h
?~$t?IQ?~$t?|??{J#9?{J#9?|hr?u!.?k~($?j~"?cA [?_o?_o?_o?`A7K?_حV?_Ft?]cA ?^?^?^?]cA ?Y|?\>?[W>6z?XbM?U=K?Q?R<64?Vt?R<64?R<64?R<64?NT?L/{J#?O
M;?Q_p?O;dZ?JL_?H˒:*?F]cf?F]cf?Dg8}?B?A [7?9D?6C-?4m8?3ߤ?2a|Q?0
(?0U2a|?/{J#:?/{J#:?1o?/v?-w1?*0
?+I^?*0U2a|?*0U2a|?)y?*0U2a|?*0U2a|?(?"`A? ěT?	?[?C,zx?u%?n?'/W?҈?K]d?$/?:S?!.H?PH?#x?PH?s?>B?#x?lC?lC?#x?#x?~$?s?>B?"`?73?+?+?!.I?\(?!-w2?Y|?Fs?+jg?+jg?!-w2?D?+jg?MjO??C\?g	?lC?iB?sPH?䎊?䎊?m?E??D*?`A7?˒:)z?8YK?m\??n?n?6?vȴ9X?)?}Vl?E?|?{?U=?>B[?*0U2a?S?TɆ?S&?S?zxl"h?TɆ?S&?o?vȴ9?-V?-V?ߤ@?S?S?ߤ@?wkP?wkP?=K^?kP|?@?*0?S&?\(?qi?hr ?Mj?!R<??O;dZ?L_?q?p:?&I?nP?o hی?nP?M:?%2?%2?{J#9?@4n?M:?$/?|Q?|Q?y=b?u!.?u!.?xF]d?wkP?wkP?vȴ9X?vȴ9X?wkP?tj~?sPH?p
=q?q?m\?l!-w?lC?l"h	ԕ?n.2?m8Y?lC?kP{?jOv`?iB?m\?lC?jOv`?iB?jOv`?h	ԕ+?hr Ĝ?hr Ĝ?g	k?g8}H?h	ԕ+?g	k?g	k?iDg8~?hr Ĝ?fA?cA [?bM?a@N?a@N?ae?_o?_حV?_حV?]cA ?Z1'?Xe+?W>6z?U=K?RT`d?Q_p?VϪ͟?Vt?T`d?SMj?RT`d?Q_p?Q_p?Q?Q_p?MjOv?JL_?IQ?F
L/?GzH?H?GzH?GzH?GzH?GzH?Fs?F]cf?I^5?}?IQ?H?GzH?H?H?GE84?H?GzH?GE84?H˒:*?B?BZc?As?@4m?A [7?A7Kƨ???@4m?A [7?A7Kƨ?A7Kƨ?@NU?@4m?As?A7Kƨ?@4m?As?B?B?BZc?@4m?????@4m???>BZc ?=b?;5Xy?;5Xy?;5Xy?=K]?=p
=?;5Xy?:S&?8YJ?73?:~?84֡b?7KƧ?5Xy=?4J?5Xy=?4֡a?4m8?5?|h?5Xy=?64K?64K?5?|h?4J?3ߤ?5Xy=?333333?1o?/Vϫ?.2X?.H?1&x?/{J#:?/{J#:?/v?.H?.H?/v?-V?,<쿱?,<쿱?,zxl"?,<쿱?,<쿱?,zxl"?,<쿱?,zxl"?/{J#:?/Vϫ?/Vϫ?/Vϫ?-w1?,<쿱?-V?,<쿱?,<쿱?-V?-w1?-V?($xG?&x?%1?(?-w1?)^?&IQ?$/?$tSM?$/?%F
L0?%1?'/V?*0
?)y?)y?(?&?$tSM?$/?"`A?!R<6?!-w1?,=?}H?C,zx?Q?qu!?u%?vȴ?vȴ?_o?*0?*0??sP?4J?)^?bM?bM?*0U2?sP?u?rGE9?ߤ??
(?rGE9?
(?
M:??Vu??҈?I^5???҈?҈?
L/{?JM?tj?JM?S&? ѷ?I^5?      ?E?PH?~$?lC?lC?#x?!.H?#x?~$?~$?s?PH?ڹZ?E?.H?:S? hۋq?      ?.H?m\? hۋq?$tS?$tS?      ?m\?ڹZ?m\?$tS?\N<?PH?s?>B?rGE8?+?>B?-
?+jg?!-w2?l?D?-V?C\?g	?rGE?>BZc?`A7L?%1?Gz?
qu?҈p;?]ce?ۋq?$?/w?/w?Q_?
=p?֡af?Ϫ͞?fA?ԕ*1?䎊?͞%?5Xy>?)^	?K]c??n?ȴ9Xb?y?Ƨ-?)^	?)^	?ɅoiD?ȴ9Xb?@?n??K]c?)^?@?ɅoiD?K]c??K]c??K]c?ɅoiD?cA \?n?ȴ9Xb?˒:)z?n??ȴ9Xb?@???8YK??\(?\(?a@N????a@N?\(?n?[W>?v?[W>?ߤ??A?)_?)_?j~#?Z?/V?Y}?#w?#w?#w?~($?^5?|?j~#?A?/V?v?j~#?j~#?A?A?A?A?n.?Z?j~#?^5?|?)_?/V?j~#?Z?A?A?Z?C?n?C?n?6?6?Z?/V?)?rG?#w?)?rG?4m?Q?)?#w?)?#w?~($?~($?/V?#w?Q?#w?)?Q?rG?)?~($?)?Q?)?Y}?)_?~($?n.?j~#?j~#?n.?/V?)_?A?n.?j~#?Z?j~#?<64?6?TɅo?&IR?\(?C?ߤ??n?a@N?H˒:?^5?|?m\?-V?ᰊ?2W?'0?3?'0?|?g	l?9XbN?9XbN?m\?m\?[W>6?[W>6?[W>6?lD?6z? ě?2W?{?[W>6?2W? ě?B?B?r? ě?{?m\?g	l?g	l?g	l?Xe?4m?4m?Xe?E?Xe?4m?Q?4m?)?#w?)_?)_?~($?}Vl?|?m\?'0?m\?{?'RT?{?2W?-V?2W?-V?ᰊ?m\?g	l?m\?g	l?|?|?|?|?sg?Xe?rG?~($?Q?rG?~($?A?A?Z?v?v?v?v?ߤ??ߤ??<64?Z?n.?C?C?vȴ9X?v?
(?<64?Z?vȴ9X?\(?TɅo?6?[W>?H˒:?ߤ??ߤ??6?C?C?C?TɅo?C?a@N?2W?ěS?ěS?o i?2W?2W?o i?Ƨ-?Ƨ-?y?y?ȴ9Xb?K]c?)^?Ƨ-?@?y?ȴ9Xb????ȴ9Xb?ɅoiD?˒:)z?s??͞%??s?_o ?N;5?ѷX?䎊?ѷX?`A7?N;5?Z?a@O?䎊?䎊?N;5?*0U?`A7?䎊?ѷX?䎊?Z?Z?a@O?ԕ*1?E?fA?Ϫ͞?fA?8YJ?>BZ?+?+?حU??D*?ڹY?ڹY?Q_?ڹY?ڹY?Q_?Q_?"`B?"`B?"`B?ۋq?]ce?/w?/w?ݗ+j? ѷY?ߤ??u!?Gz?Gz?u!?Gz?`A7L?,<?`A7L?e?䎊qj?%1??,<?lC?,<?lC??1.?fA?Q?C,z?ᰉ'?ᰉ'?rGE?x?Q?Q?g	?C,z?C,z?C]?C]?VϪ?c	?hr!?C\?c	?4֡a?-V?-V?oiDg8?A [?D?l?l?s?䎊q?{m?#?E?!-w2?D                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @@Gy@@Gy@@G	@@G@@GO;d@@Gݗ+@@G@@G@@G@@G@@G@@G@@G@@G@@G	@@G&@@G{J#:@@G	@@G{J#:@@G|hs@@G{J#:@@G4m@@Gy@@G|hs@@Go@@Go@@Go@@GsPH@@GsPH@@Go@@GlC@@GlC@@GsPH@@Gv_ح@@Gy@@Gv_ح@@Gv_ح@@GsPH@@Gv_ح@@GsPH@@GsPH@@GsPH@@Gv_ح@@G|hs@@G|hs@@G{J#:@@G{J#:@@Gy@@G|hs@@G|hs@@G|hs@@Gy@@G|hs@@G&@@G{J#:@@G{J#:@@GO;d@@GkP@@G&@@GzH@@Gr@@G@@G@@G+@@G;dZ@@G#@@H	ԕ+@@H	ԕ+@@H ě@@HD*@@Hr Ĝ@@Hu%F@@H{@@HTɅ@@H҈p@@H{@@H$tT@@I#w@@I=b@@IDg8~@@IN;5@@IQ@@ITɅo@@Iae@@IrGE8@@I@@I@@J@@JQ_@@JC,@@KC%@@Km]@@Lߤ@@@L#x@@Mzxl"h@@N+jg@@NIQ@@SU=@@XH@@[nP@@[U=@@]V@@`IQ@@aR<6@@rI^5@@~
(@@Dg8~@@,<@@lC@@Vl!@@r Ĝ@@fA@@+j@@6C@@s@@x@@@@F
L0@@K]c@@	k~@@XbM@@MjO@@/@@ή}Vl@@S&@@ԕ*1@@Vu@@\(@@ѷX@@ڌL_@@J#9@@Q@@VϪ@@+jg@@Ϫ͟@@@@7KƧ@@ԕ*@@	 @@0U2a|@@a|Q@@͞&@@㋬q@@jOv@@,=@@
L/@@R<6@@>6z@@@@rG@@rGE9@@*0U@@譫U@@7Kƨ@@ᰉ'@@@@T`d@@~"@@G{@@&@@W>6z@@eO@@lC@@Z1@@섵?@@zxl"@@O
M@@j~@@!-w@@zxl"h@@@@@@.2@@Ov_خ@@vȴ9X@@af@@@@Fs@@$tS@@.H@@8}H@@;dZ@@䎊r@@;dZ@@fA@@@@@@;dZ@@حV@@@@fA@@@@حV@@*0@@73@@˒:*@@oiDg8@@𖻘@@tj@@'RT@@eO@@Q@@D*@@U2a|@@u%F@@IQ@@u%F@@˒:*@@u!@@˒:*@@@@@`A7@@9Xb@@u%F@@e+@@
(@@d8@@4m@@4m@@TɅ@@)@@TɅ@@@@@)^@@)@@@@C@@D@@)^@@ۋq
@@ѷX@@@@@
(@@
(@@`A7@@:S@@ [7@@PH@@PH@@	k@@ ѷ@@{@@	k~@@ ѷ@@$tT@@`A7@@`A7@@$tT@@@@@@#w@@*0U2a@@@N@@+@@:S@@-w1@@-w1@@[W>6@@N;5@@^@@[W>6@@TɅo@@^@@k~(@@k~(@@o hی@@񰉠'R@@^5?}@@X@@B@@u@@񙙙@@.H@@lD@@Y}@@s@@s@@R@@n@@1'@@h	ԕ@@ᰊ@@L/{@@Y@@sP@@J#9@@W>6z@@]cA@@5Xy@@5Xy@@6@@Q@@%2@@n.@@tSM@@wkP@@o h@@#@@S@@Z@@'0@@%F
L@@5Xy>@@ce@@ڹZ@@sg@@sh@@@@Ϫ͞@@Ov_@@H@@\N<@@IQ@@6z@@҈p;@@Mj@@$tS@@1@@As@@iDg8@@v_ح@@͞@@@@r@@?@@3@@r@@@@@ ě@@:~ @@NU@@_F@@u%F@@p:@@҈p@@#w@@@@+@@@N@@rGE@@@@_p@@*0U2a@@|Q@@2W@@ᰉ'@@@@(@@l@@R@@-@@@@lD@@^5?|@@ݘ@@ڹY@@m\@@PH@@9@@{J#9@@U=@@eO@@xF]@@$@@*0U2@@wk@@ߤ@@@j~#@@3@@Ʌoi@@'0@@IQ@@%@@@@,=@@.2@@5?|@@E@@_ح@@z@@qi@@@@$t@@+J@@%@@qi@@5?|@@@@T@@Q@@$tS@@b}V@@{J#:@@	k@@&@@3@@+@@حV@@;dZ@@-@A K]c@A y=c@A |@A @A d8@A )^@A+@A@N@AGz@ADg8~@A[W>6@Aae@A[W>6@AJE@A@A@N@A#w@AGz@Ax@AOv`@A ě@AڹY@Au%@AJ#9@Aq@A$@A$@AU=@Am]@A~($@AA@AMj@A:)z@A*0U2@A\N@A!-w2@A%1@AFs@AS@A[@AL_@Ash@A$/@AVu@AFs@AT@A@A|hs@A?@A3@A>BZc@Au!@A'RT@Atj@Au%F@Au%F@Ad8@A9Xb@A@@A$tT@A	N;5@A	b}@A	'RTa@A	l@A	y@A	>BZ@A
0U2a|@A
@A
 ě@A
L/{@A
vȴ@A
L/{@A
 ě@A
W@A
)_@A)^	@AMjO@AS@AA [@A@A@A?@A~($x@A/@A
%F
L@A
F
L0@A
w1@A
!R@A
hr!@A
n/@At@A ѷY@A
L/@A@A4K@AOv_@A.2@AL/{J@Avȴ9X@A6z@A@A
M;@Av@A4֡a@A;dZ@AKƧ@AsPH@A4m@A@A	k@A/V@A@ArG@A>BZc@AěT@A)^@A@A'RT@Au!@Ay=c@Ay=c@Al"h	@AU2a|@Au!@Au%F@A4m@A4m@A{@A҈p@A\)@A	k~@A@A=b@AQ@A^@Au!S@A@A@A=p
@AJL@AZc@A0
@A>B@AW@A@A)_@A͞&@A͞&@A,<@A,<@A`A@AfB@A'/@AnP@A҉@A҉@AnP@A҉@A	@AW>6z@A@Aq@A:)z@Aߤ@Am]@Aa@O@Aa@@Aݗ+k@AA [@AC]@A@An.@AxF@A/{J#@APH@AwkP@A֡a@A/@Ahr@A[@A!.H@AB@Asg@AM:@A@A1@A-V@A8Y@A8YK@A,=@A!.@A
L/@A
(@A@A$/@AH@Ac	@As@A%@Aqi@A,<@AϪ͟@A@A@A"@A)^@AXe@A
M;@A
=p@A1@Ay@A4m@A$tS@A	k@A&@AzH@Avȴ9@Ao @Avȴ9@A/V@A+@A
qu@A73@A:~ @A4m9@A1&x@A>BZc@AU2a|@Ay=c@Atj@A@Atj@A'RT@Atj@A-
@A{@A@ArGE@A+@A@N@ArGE@A@N@ArGE@A$/@A@N@A@N@A@Ab}@A'RTa@A@A'RTa@AB@A.H@A䎊@A0U2a|@A0U2a|@A:)y@Aa|Q@AqiC@Ap:@Aᰊ@AL/{@An@AfB@A6z@A=K^@A9@A33333@A=K^@AS@Ajf@A*0U2@AJ@Aj~#@Aq@A_@A>B[@A>@AK]@A[@A84֡@A`A7L@A}H@A=K@A8Y@A8Y@AϪ͞@A
qv@A,=@AE@A!.@A
(@AzG@Au@A5?|@ABZc @A%@A,<@A@A-@A6z@A'@A2X@A'@Aߤ?@A&I@Aߤ?@A&I@Aȴ9X@AA@A҈p;@AϪ͟@A hۋ      @AO;d@Ao @AحV@AحV@ArG@ArG@ArG@A-@ArGE9@ArGE9@A bM@A *0@A >BZc@A K]c@A NU@A NU@A U2a|@A Xy=@A Xy=@A Q@A [6@A |@A d8@A ҈p@A 4֡b@A \)@A!+@A!@A!&x@A!Dg8~@A!e+a@A!@A!|@A!_o@A!ԕ*@A!lD@A"u%F@A"Ov`@A"&IR@A"C\@A"JL@A"T`d@A"W'@A"^5?|@A"p:@A")_@A"`A@A"C,@A#I^@A#'/@A#J#9@A#a@N@A#~$@A#:)z@A#q@A#@A#%2@A#A [@A#@A$L_@A$2W@A$64@A$<쿱@A$VϪ@A$zxl"@A$Ʌoi@A$/@A$u"@A$Z@A$e@A%V@A%*0@A%<64@A%}H@A%$/@A%hr!@A%v@A%1@A%@A%\(@A%S@A%C\@A&t@A& ѷY@A&_o @A&_o @A&zG@A&.2@A&?@A&;5X@A&E@A&R<6@A&iB@A&$t@A&@A&2X@A&ߤ?@A&t@A&҈p;@A&]cf@A&ߤ?@A&1@A&1@A&x@A&쿱[W@A&ߤ?@A&Fs@A'@A')^@A'+I@A'O
M@A'U=@A'sPH@A'v_ح@A'	@A'-V@A'	k@A'?@A'[W>@A'r@A'˒:)@A'fA@A';dZ@A'@A';dZ@A'rGE9@A(@A(	ԕ+@A($xG@A(73@A(>BZc@A(_F@A(eO@A(l"h	@A(r Ĝ@A(y=c@A(YJ@A(-
@A(p:@A(҈p@A(҈p@A(҈p@A(e+@A(\)@A({@A) [7@A)@A)@A)&x@A)*0U2a@A)Dg8~@A)XbM@A)[W>6@A)k~(@A)^@A)@A)@A)(@A)y@A)ԕ*@A*s@A*h	ԕ@A*a|Q@A*W'@A*a|Q@A*C,@A*c	@A+	@A+tj~@A+Q@A+A@A+6@A+a@@A+A [@A+s@A+s@A,xF@A,%1@A,I^5?@A,PH@A,SMj@A,Z1@A,cA \@A,S@A,*0@A,֡a@A,hr@A-K]@A,E@A,D@A,hr@A,JM@A,!-w@A,!-w@A,E@A-K]@A-o i@A-K]@A-V@A-[@A-*0@A-*0@A-*0@A-Q@A-L_@A-p
=@A-}H@A-\(@A.1.@A.8YJ@A.s@A.@A.]cf@A/+I@A/4֡a@A/;dZ@A/4֡a@A/8}H@A/O
M@A/_o@A/sPH@A/{J#:@A/	k@A/fA@A0hۋq@A0y=c@A0r Ĝ@A0l"h	@A0A7K@A0D*@A0[6@A0U2a|@A0Xy=@A0hۋq@A0l"h	@A0u!@A0y=c@A0˒:*@A0n@A0n@A0YJ@A0˒:*@A0'RT@A0)@A09Xb@A0U@A0u%F@A0IQ@A0d8@A0tj@A0@A0@A0u%F@A0u%F@A0IQ@A0
=q@A0@A0ѷX@A1k~(@A1u!S@A1u!S@A1~($@A12W@A1@A1ԕ*@A1Y}@A2^5?|@A2{m@A2@4@A20
@A2 ě@A2`A@A2c	@A3I^@A2~@A274@A3u%@A3s@A3"`B@A3"`B@A3&@A39@A3n.3@A3q@A3~($@A3m]@A3~($@A3E@A3@A3q@A3ߤ@A3*0U2@A3~($@A3a@O@A35Xy@A3ݗ+k@A3ݗ+k@A3@A4tj@A4(\@A4<쿱@A4Fs@A4]ce@A4g8}@A4j~#@A4wkP@A4~($x@A4zG@A4q@A4tSM@A4zG@A4Z@A5Q@A5+a@A5%F
L@A5Q@A4@A4Z@A4Ʌoi@A4[W?@A4?@A4*0@A4>@A5ڹZ@A5@A58YK@A5b@A5?@A5
qv@A5?@A5b@A5ᰉ@A5\(@A5\(@A5@A58Y@A58YK@A5,=@A5b@A5ᰉ@A6
(@A6Ov_@A6$/@A6.2@A61.@A6+jg@A6R<6@A6l!-@A6l!-@A6l!-@A6c	@A6vȴ9X@A6%@A6}Vl@A6}Vl@A6}Vl@A6%@A6IQ@A6$t@A6@A6Ϫ͟@A6+@A6+@A6ߤ?@A61@A6x@A6Mj@A6"@A6"@A6Fs@A7 hۋ@A7
M;@A7v@A7+I@A7;dZ@A74֡a@A7As@A7H˒:@A7\(@A7U=@A7_o@A7+I@A7v@A7v@A7'/W@A7>6z@A7;dZ@A7fA@A7o @A7vȴ9@A7@A7o @A7@@A7rGE9@A7+j@A7#@A7@@A7fA@A7vȴ9@A7r@A7[W>@A7/V@A7+@A7@A7K]d@A7+@A7K]d@A8A7K@A8:~ @A8>BZc@A8A7K@A8[6@A8eO@A8oiDg8@A8l"h	@A8oiDg8@A8r Ĝ@A8r Ĝ@A8r Ĝ@A8|@A8u!@A8tj@A8u%F@A8IQ@A8{@A8
(@A8ěT@A8p:@A8҈p@A8ۋq
@A8҈p@A8@A84֡b@A9_p@A9-w1@A9:S@A94J@A9JE@A9^@A9e+a@A9@A9o@A9@A9|@A9|@A9|@A9ԕ*@A9ᰉ'@A9Y}@A9lD@A:I^5@A:e+@A:#9@A:1'@A:1'@A:)y@A:0U2a|@A::)y@A:@4n@A:@4n@A:JL@A:Q_@A:T`d@A:d7@A:kP|@A:a|Q@A:h	ԕ@A:u%F
@A:@4@A:p:@A:L_@A:ᰊ@A:wkQ@A:S&@A:@A:n@A:Y@A:`A@A:G{@A: ѷ@A:fB@A:D@A:~@A:m\@A;C%@A;F]c@A;P{@A;S@A;a@N@A;n.3@A;$@A;q@A;Ƨ@A;Q@A;
=p@A;g@A;$@A;$@A;$@A;s@A;\N@A<1&y@A<@A<2W@A<2W@A<64@A<9XbN@A<?@A<<쿱@A<64@A<C,zx@A<I^5?@A<PH@A<VϪ@A<`d@A<q@A<tSM@A<~($x@A<C@A<qj@A<3@A<1&@A<*0@A<?@A<7@A<?@A<[W?@A<#x@A<j~@A<j~@A<j~@A<[W?@A<[W?@A<j~@A<@A<֡a@A<u"@A<JM@A<E@A<D@A<>@A<E@A<e@A<E@A=o i@A=o i@A='0@A='0@A='0@A=[@A=+a@A=5Xy>@A=?|h@A=IQ@A=fA@A=sg@A=w1@A=$/@A=%@A=@A=%@A=v@A=U=@A=U=@A=Xy=@A=v@A=U=@A=U=@A=U=@A=-V@A=@A=H˒@A=\(@A=\(@A=8Y@A=@A=cA @A=8YK@A=b@A=?@A=8YK@A>t@A>@A>zG@A>u@A>$/@A>+jg@A>BZc @A>\N<@A>_ح@A>p:~@A>z@A>IQ@A>%@A>$t@A>,<@A>af@A>O;@A>}Vl@A>&I@A>҈p;@A>]cf@A>x@A>Fs@A>쿱[W@A>Mj@A>Mj@A?@A?!-w1@A?1@A?4֡a@A?8}H@A?>6z@A?KƧ@A?E84@A?Xe,@A?\(@A?_o@A?b}V@A?iDg8@A?o@A?v_ح@A?&@A?&@A?	@A?&@A?O;d@A?@A?zH@A?r@A?o @A?+@A?@A?@@A?-@A?䎊r@A?#@A@	ԕ+@A@ ě@A@4m9@A@73@A@>BZc@A@A7K@A@H@A@H@A@K]c@A@NU@A@Xy=@A@[6@A@_F@A@eO@A@eO@A@u!@A@r Ĝ@A@˒:*@A@YJ@A@'RT@A@'RT@A@˒:*@A@u%F@A@@A@@A@U@A@4m@A@
(@A@p:@A@ѷX@A@ѷX@A@ۋq
@A@C@AA$/@A@{@AA ѷ@AA	k~@AA@AA@N@AA@AA+@AA [7@AA-w1@AAGz@AAe+a@AAk~(@AAu!S@AA@AAR<6@AA@AAB@AA'R@AAD@AAo@AAN;6@AAiB@AAᰉ'@AAᰉ'@AAᰉ'@AAe@AA@ABu%F@AAe@AAs@AAlD@ABI^5@AB	 @AB@ABe+@AB#9@AB&IR@AB&IR@AB3@ABQ_@AB~"@ABp:@ABݘ@ABݘ@ABݘ@ABS&@ABwkQ@AB0
@AB@AB ě@ABY@ABn@AB)_@AB`A@AB䎊q@ABm@AB74@ACI^@ACI^@ACu%@AC҉@AC'/@ACu%@ACu%@AC'/@ACnP@ACs@ACPH@AC'/@ACC,z@AC&@AC)^	@AC)^	@AC@N@AC6z@AC=K^@ACP{@ACZ@AC]cA@ACdZ@ACdZ@ACg	l@ACqu!@AC:)z@AC*0U2@ACS@AC@ACa@O@ACa@@AC
=p@AC|@ACݗ+k@ACC]@ACA [@AC@AC\N@ADxF@AD@ADL_@ADL_@ADQ@AD"h	ԕ@AD,<@AD,<@AD9XbN@AD9XbN@ADC,zx@ADC,zx@ADFs@ADSMj@ADZ1@ADZ1@ADVϪ@ADZ1@ADZ1@ADZ1@AD`d@ADcA \@ADg8}@ADj~#@ADq@ADq@ADtSM@AD~($x@AD#@ADN;@AD3@ADTɆ@AD1&@AD?@AD@ADj~@AD7@AD?@AD@AD>B[@ADZ@ADu"@ADD@AD>@AD>@ADE@AE:@AE'0@AEu@AE'0@AE*0@AEqu"@AE/w@AE+a@AE/w@AE2a|@AE2a|@AE5Xy>@AE84֡@AEB@AEL_@AES&@AES&@AEO;dZ@AEY|@AE\@AE`A7L@AEjOv@AEm\@AEsg@AEw1@AE$/@AEM:@AEڹZ@AEO
@AE+j@AEsh@AE@AEcA @AE8Y@AE@AE@AEcA @AE@AEcA @AE
qv@AE
qv@AE(@AEE@AEC\@AE!.@AEڹ@AF
L/@AFu@AF8YJ@AF;5X@AFL/{J@AF;5X@AFE@AFOv_خ@AFOv_خ@AFVu@AFR<6@AFOv_خ@AFYJ@AF\N<@AFfffff@AFl!-@AFs@AFvȴ9X@AFIQ@AF%@AF+J@AF+J@AFqi@AF$t@AF$t@AFO;@AFT@AF6z@AF-@AF6z@AF}Vl@AF@AFߤ?@AFA@AFϪ͟@AFߤ?@AFx@AF1@AFMj@AF쿱[W@AF@AG hۋ@AG@AGFt@AG
M;@AGFt@AG)^@AG,@AG.H@AG$tS@AG+I@AG.H@AG8}H@AGAs@AGAs@AGAs@AGKƧ@AGO
M@AGKƧ@AGH˒:@AGRT`e@AGRT`e@AGU=@AGXe,@AG_o@AGiDg8@AGsPH@AGy@AG{J#:@AG&@AG&@AG@AGO;d@AG@AGݗ+@AG-V@AG?@AG	k@AG?@AG&@AG͞@AGr@AG@AGK]d@AGo @AGK]d@AG˒:)@AG˒:)@AGحV@AG@AGfA@AG@@AGrG@AGrG@AG+j@AGrGE9@AG#@AH	ԕ+@AHF]d@AH
qu@AH
qu@AH
qu@AH
qu@AHbM@AH@AH@AH ě@AH ě@AH-
q@AH1&x@AH:~ @AHA7K@AHNU@AHQ@AHK]c@AHXy=@AH[6@AHoiDg8@AHu!@AHy=c@AH|@AHYJ@AH'RT@AH'RT@AH'RT@AH@AH@AHu%F@AH
=q@AH@AH
(@AH@@AHp:@AHۋq
@AH҈p@AHC@AH{@AH{@AH\)@AH	k@AHPH@AHPH@AI	k~@AI ѷ@AI	k~@AI	k~@AI+@AI@N@AI@N@AI_p@AI [7@AI&x@AI*0U2a@AI@AI#w@AI*0U2a@AI*0U2a@AI*0U2a@AI:S@AIJE@AIGz@AIA [@AIQ@AI^@AI[W>6@AIo hی@AI|Q@AIb}@AIoiD@AI@AIR<6@AI'RTa@AIl@AIX@AI^5?}@AI^5?}@AIX@AI^5?}@AIy@AIy@AI_o@AI@AI"`@AIiB@AIR@AIY}@AIs@AI.H@AJn@AJu%F@AJn@AJ@AJs@AJe+@AJ1'@AJ1'@AJ1'@AJ&IR@AJ&IR@AJ&IR@AJ)y@AJ3@AJ@4n@AJM@AJT`d@AJ^5?|@AJ^5?|@AJW'@AJd7@AJd7@AJnO@AJxl"h
@AJ~"@AJݘ@AJ@4@AJ~"@AJݘ@AJL_@AJ\(@AJ0
@AJvȴ@AJ}Vm@AJY@AJ@AJn@AJn@AJ@AJ ѷ@AJG{@AJ ѷ@AJڹY@AJc	@AJm@AJC,@AJ䎊q@AJC,@AJD@AJc	@AJ74@AJ74@AKI^@AKu%@AKs@AKPH@AK)^	@AK,zxl@AK,zxl@AK9@AK@N@AK@N@AKMjO@AKP{@AKW>6z@AKg	l@AKdZ@AK]cA@AKdZ@AKg	l@AKjf@AKa@N@AKg	l@AKtj~@AKxF]@AKQ@AKeO@AK$@AKU=@AKߤ@AKwk@AKwk@AKwk@AKS@AKwk@AK*0U2@AKwk@AK@AKƧ@AK@AK5Xy@AK@AKa@@AKa@@AKQ@AK҈@AKC]@AK@ALxF@AL!-w2@AL"h	ԕ@AL%1@AL(\@AL<쿱@AL<쿱@ALC,zx@ALFs@ALM:@ALZ1@ALq@ALwkP@ALtSM@ALtSM@ALq@ALwkP@ALwkP@AL~($x@ALo h@AL~($x@AL#@AL#@AL#@ALC@ALqj@ALqj@ALN;@AL*1@AL쿱[@ALzxl"@ALTɆ@ALTɆ@AL3@ALzxl"@AL1&@AL@AL@AL3@ALj~@AL?@AL֡a@AL>B[@AL/@ALZ@ALZ@ALZ@ALZ@AL@AL@AL@AL@AL@ALJM@AL!-w@ALe@AL!-w@ALE@AL!-w@AL>@ALE@AM:@AMo i@AMo i@AM:@AL>@AM:@ALE@AM:@AMV@AMqu"@AMQ@AM%F
L@AM%F
L@AM/w@AM5Xy>@AM?|h@AM?|h@AM<64@AM?|h@AMB@AMF
L0@AM`A7L@AMfA@AMsg@AMp
=@AMsg@AMw1@AMw1@AM$/@AM$/@AMݗ@AM!R@AMhr!@AM=K@AM+j@AM%@AMXy=@AM-V@AM1@AM@AM@AMsh@AM@AMH˒@AMH˒@AM8Y@AMH˒@AMH˒@AM\(@AM\(@AM8Y@AM@AMb@AM8YK@AM?@AM?@AM
qv@AMᰉ@AM,=@AMoiDg@AMڹ@AN ѷY@AMڹ@ANt@AN ѷY@AN_o @AN4K@AN
(@AN4K@AN4K@ANzG@ANu@ANu@ANOv_@AN!R<@AN$/@AN!R<@AN!R<@AN$/@AN!R<@AN$/@AN.2@AN.2@AN1.@AN1.@AN;5X@AN?@AN?@AN?@ANE@ANOv_خ@ANR<6@AN_ح@AN\N<@AN_ح@AN\N<@ANc	@ANc	@AN_ح@AN_ح@ANfffff@ANiB@ANiB@AN_ح@ANfffff@ANl!-@ANs@ANp:~@ANs@ANvȴ9X@ANvȴ9X@ANvȴ9X@ANIQ@ANIQ@AN%@ANqi@AN@AN$t@ANqi@ANqi@AN@ANFs@ANaf@AN@AN@ANaf@AN6z@AN6z@AN}Vl@AN}Vl@AN}Vl@AN'@ANQ@AN@AN@ANm\@ANm\@ANm\@ANt@AN҈p;@ANA@AN҈p;@ANϪ͟@AN+@AN]cf@AN]cf@ANߤ?@ANC-@AN1@AN쿱[W@AN@ANMj@ANMj@AN"@AN"@AN"@AO hۋ@AO hۋ@AOFt@AN!.I@AOFt@AO
M;@AO
=p@AO
M;@AO
M;@AO
M;@AO)^@AO@AO@AO@AO@AOXe@AO,@AO!-w1      @AO,@AOv@AO'/W@AO.H@AO'/W@AO'/W@AO+I@AO1@AO4֡a@AO.H@AO4֡a@AO;dZ@AO>6z@AOE84@AORT`e@AOKƧ@AOH˒:@AOO
M@AOO
M@AO\(@AOb}V@AOeں@AOb}V@AO_o@AO_o@AOeں@AOlC@AOo@AOo@AOv_ح@AOsPH@AOv_ح@AO|hs@AO&@AO{J#:@AO	@AO	@AO&@AO@AO$tS@AO$tS@AOݗ+@AO$tS@AO-V@AO	k@AO?@AO?@AO&@AO&@AO͞@AO3@AOr@AO/V@AOvȴ9@AOvȴ9@AOo @AOK]d@AO+@AO˒:)@AO+@AOfA@AO˒:)@AO@AO@AO@AO@AO@AO@AO;dZ@AO;dZ@AO@AOVϫ@AO@@AO@@AOrG@AOVϫ@AOrG@AOVϫ@AO䎊r@AO-@AOVϫ@AOVϫ@AOrG@AO@AOVϫ@AO@@AO@AOrG@AO-@AOrGE9@AO-@AOrG@AO䎊r@AO䎊r@AOrGE9@AO+j@AO䎊r@AO#@AP
qu@AP@AP ě@AP}H@AP ě@AP ě@AP6@AP ě@AP ě@AP$xG@AP}H@AP}H@AP6@AP}H@AP*0@AP}H@AP$xG@AP ě@AP ě@AP-
q@AP4m9@AP*0@AP4m9@AP4m9@AP73@APA7K@APD*@APD*@AP>BZc@APD*@APXy=@APbM@APbM@APbM@APeO@APl"h	@APhۋq@APy=c@APy=c@AP˒:*@APn@AP˒:*@APn@AP'RT@AP-
@AP'RT@AP'RT@AP'RT@AP-
@AP-
@APtj@APtj@AP@AP@APtj@AP@AP-
@APIQ@AP-
@AP
=q@APd8@APU@APd8@AP9Xb@AP4m@AP)@AP
(@AP
(@AP)^@APѷX@APѷX@AP`A7@AP@@APѷX@APѷX@APTɅ@APѷX@APѷX@APp:@APp:@APF@APD@APF@APD@APۋq
@APF@APF@APD@AP҈p@AP҈p@APD@APF@APF@APۋq
@AP҈p@APD@APp:@APD@AP҈p@AP҈p@AP`A7@APC@AP4֡b@AP\)@AP$tT@AP\)@AP{@AP\)@AP4֡b@AP{@AP\)@AP	k@AQ ѷ@AQ ѷ@AP$tT@APPH@AP$tT@AQ ѷ@AQ@AQ	k~@AQ@AQ@AQ	k~@AQrGE@AQ@N@AQ+@AQrGE@AQ_p@AQ_p@AQ#w@AQ@AQ@AQ+@AQ [7@AQ&x@AQ-w1@AQ*0U2a@AQ0
)@AQ4J@AQ:S@AQ4J@AQ7KƧ@AQ:S@AQ7KƧ@AQ:S@AQ:S@AQ:S@AQ:S@AQ=b@AQ=b@AQA [@AQ7KƧ@AQ:S@AQ=b@AQ=b@AQ=b@AQA [@AQDg8~@AQ=b@AQ=b@AQDg8~@AQA [@AQA [@AQDg8~@AQA [@AQGz@AQGz@AQJE@AQA [@AQN;5@AQ[W>6@AQQ@AQQ@AQXbM@AQ[W>6@AQXbM@AQXbM@AQ[W>6@AQ^@AQ[W>6@AQGz@AQ^@AQae@AQae@AQe+a@AQhr @AQhr @AQhr @AQo hی@AQhr @AQk~(@AQe+a@AQo hی@AQu!S@AQrGE8@AQhr @AQk~(@AQu!S@AQ|Q@AQk~(@AQu!S@AQu!S@AQu!S@AQu!S@AQrGE8@AQrGE8@AQu!S@AQx@AQrGE8@AQx@AQu!S@AQx@AQ|Q@AQ@AQb}@AQoiD@AQb}@AQb}@AQ@AQ@AQ7Kƨ@AQo@AQ7Kƨ@AQ~($@AQo@AQ@AQo@AQo@AQo@AQo@AQo@AQ@AQ@AQR<6@AQR<6@AQ@AQu@AQn.@AQl@AQ(@AQn.@AQ(@AQ(@AQl@AQl@AQ(@AQl@AQl@AQl@AQl@AQB@AQB@AQ(@AQB@AQB@AQl@AQ'R@AQl@AQB@AQ|@AQX@AQX@AQ^5?}@AQ'R@AQ^5?}@AQX@AQ|@AQ@AQX@AQ^5?}@AQ@AQX@AQ^5?}@AQD@AQ^5?}@AQX@AQX@AQ@AQ@AQ2W@AQy@AQ@AQ@AQy@AQ2W@AQy@AQy@AQy@AQD@AQD@AQy@AQy@AQN;6@AQN;6@AQo@AQo@AQo@AQN;6@AQ_o@AQN;6@AQԕ*@AQN;6@AQN;6@AQN;6@AQԕ*@AQԕ*@AQ@AQ"`@AQN;6@AQ@AQ"`@AQ@AQ"`@AQᰉ'@AQiB@AQiB@AQiB@AQiB@AQᰉ'@AQe@AQe@AQiB@AQᰉ'@AQ>BZ@AQe@AQ>BZ@AQe@AQR@AQe@AQ>BZ@AQ>BZ@AQiB@AQᰉ'@AQᰉ'@AQᰉ'@AQR@AQ@AQ>BZ@AQ>BZ@AQR@AQR@AQR@AQ>BZ@AQR@AQ@AQ-@AQ@AQ>BZ@AQ@AQs@AQY}@AQlD@AQs@AQY}@AQY}@AQY}@AQY}@AQs@AQ@AQ@AQ-@AQ.H@AQlD@AQ.H@ARu%F@ARn@ARu%F@ARu%F@ARn@AR	 @AR	 @AR	 @ARI^5@ARn@AR	 @AR@AR@AR	 @AROv`@ARe+@ARe+@ARe+@ARe+@AROv`@AROv`@AROv`@AR䎊@AR䎊@AR#9@AR1'@AR䎊@AR#9@AR#9@AR&IR@AR#9@AR&IR@AR#9@AR#9@AR)y@AR)y@AR)y@AR3@AR6C@AR3@AR-V@AR6C@AR6C@AR6C@AR@4n@ARC\@ARC\@ARC\@AR@4n@AR@4n@AR=p
@AR@4n@ARGE85@ARC\@ARC\@ARC\@ARGE85@ARGE85@AR@4n@AR=p
@ARC\@ARC\@ARGE85@ARGE85@ARGE85@ARGE85@ARGE85@ARC\@ARGE85@ARM@ARJL@ARC\@ARM@ARQ_@ARJL@ART`d@ARQ_@ARW'@ARJL@ARQ_@ART`d@ARZc@ARd7@AR^5?|@ARa|Q@ARh	ԕ@ARh	ԕ@ARkP|@ARkP|@ARqiC@ARkP|@ARu%F
@AR{m@ARxl"h
@AR{m@AR~"@AR~"@AR{m@ARxl"h
@AR~"@AR@4@ARݘ@ARp:@ARݘ@ARp:@ARݘ@AR\(@AR\(@AR\(@ARS&@ARᰊ@ARS&@ARᰊ@AR0
@ARS&@AR0
@ARS&@ARwkQ@ARS&@ARvȴ@AR\(@ARwkQ@ARwkQ@ARvȴ@ARvȴ@ARwkQ@ARvȴ@ARvȴ@ARwkQ@ARvȴ@ARL/{@ARS&@ARvȴ@ARS&@ARS&@ARwkQ@ARvȴ@ARS&@AR@ARL/{@AR@AR@AR>B@AR ě@AR ě@AR ě@ARg	@AR>B@AR ě@AR}Vm@ARg	@AR}Vm@AR}Vm@AR}Vm@AR}Vm@AR}Vm@ARY@ARY@AR<64@AR}Vm@ARg	@AR<64@AR<64@ARn@ARn@ARn@AR@ARn@ARn@AR)_@ARn@AR<64@ARn@AR@AR@AR)_@AR)_@AR)_@AR)_@AR@AR)_@ARW@AR)_@AR)_@ARW@AR)_@AR͞&@AR͞&@ARW@AR<64@AR@AR@AR)_@ARW@ARW@AR͞&@ARW@AR`A@ARsP@AR)_@AR`A@ARsP@ARڹY@ARsP@AR`A@AR,<@ARsP@AR,<@ARsP@ARsP@AR,<@ARsP@ARڹY@AR,<@ARsP@ARڹY@AR ѷ@AR ѷ@ARڹY@AR ѷ@ARG{@ARsP@AR ѷ@ARڹY@AR ѷ@ARڹY@ARڹY@ARڹY@ARڹY@AR ѷ@ARG{@AR ѷ@ARsP@AR ѷ@AR ѷ@AR ѷ@ARڹY@AR,<@AR,<@ARڹY@AR,<@AR ѷ@ARG{@AR ѷ@ARsP@AR ѷ@ARfB@ARm@ARm@ARc	@ARm@ARc	@ARc	@ARm@ARD@ARD@ARm@ARm@ARm@ARD@AR~@AR~@ARD@ASS&@ASI^@AR74@AR74@AR74@AR74@AR~@ASI^@ASI^@AR~@ARm\@AR74@ARm\@AR~@AR~@ARm\@AR~@ARD@AR74@AR74@AR~@ARm\@ARm\@AR74@AR~@AR~@AR~@AR~@ARD@AR74@AR~@ARm\@ASI^@ASS&@ASS&@ASS&@AS҉@AS҉@ASS&@ASS&@ASu%@AS҉@ASu%@ASu%@ASu%@AS҉@AS'/@ASu%@ASS&@ASu%@AS҉@AS'/@ASu%@ASS&@ASu%@ASu%@ASu%@AS҉@ASu%@ASS&@ASS&@ASu%@ASS&@ASu%@ASS&@ASu%@ASu%@ASI^@AS҉@ASI^@AS'/@ASu%@ASu%@AS҉@AS҉@AS҉@AS'/@ASnP@AS҉@AS҉@ASS&@AS҉@AS'/@AS'/@ASs@AS'/@AS'/@AS'/@ASu%@AS'/@ASnP@ASs@ASu%@ASu%@AS҉@AS'/@AS'/@ASs@ASnP@AS'/@ASu%@AS'/@AS҉@AS'/@AS҉@AS҉@AS'/@ASs@ASnP@AS'/@AS'/@AS'/@ASnP@ASnP@ASnP@ASnP@ASu%@AS'/@ASnP@AS'/@AS'/@ASs@AS'/@AS҉@AS҉@AS҉@AS'/@ASs@ASs@ASu%@AS'/@AS'/@ASnP@AS'/@ASs@ASs@ASs@ASs@ASnP@AS҉@ASnP@ASnP@AS'/@ASnP@AS'/@AS'/@ASs@ASnP@AS҉@ASs@AS҉@AS'/@ASs@ASs@AS'/@ASnP@AS'/@ASnP@ASnP@ASPH@ASs@ASnP@ASnP@ASPH@ASs@ASnP@ASnP@ASs@ASs@ASnP@ASnP@AS'/@AS'/@ASs@ASs@ASs@AS'/@AS҉@ASu%@AS҉@ASnP@ASnP@ASnP@AS҉@AS'/@ASnP@ASnP@ASnP@ASPH@ASnP@ASu%@AS҉@AS'/@ASnP@ASC,z@ASs@AS'/@AS'/@ASnP@ASs@ASs@ASPH@ASPH@ASPH@AS҉@ASs@ASs@ASnP@AS҉@ASnP@ASs@AS'/@ASnP@ASs@AS҉@ASs@ASnP@AS'/@ASs@ASnP@ASs@ASs@ASs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @rs33333@rnfffff@ri@rd@rX     @rK33333@rP     @rT@rK33333@rA@rD@rD@rC33333@rD@r.fffff@r&fffff@r4@r;33333@r<@r6fffff@r333333@r4@r9@r9@r333333@r333333@r4@r9@r;33333@rL@rI@rI@rNfffff@rQ@rP     @rP     @rI@rL@rK33333@rNfffff@rP     @rL@rNfffff@rK33333@rNfffff@rQ@rNfffff@rK33333@r@     @r@     @rI@rP     @rFfffff@rC33333@rI@rFfffff@rI@rNfffff@rT@rVfffff@rP     @rL@rFfffff@rD@rA@r@     @r@     @r@     @rL@rH     @rI@rD@rH     @rD@r@     @r@     @rD@rH     @rC33333@rFfffff@rL@rH     @r9@r333333@r<@r>fffff@r8     @r333333@r333333@r6fffff@r)@r#33333@r!@rfffff@r@r33333@r@q@q33333@qT@q+33333@q33333@p񙙙@p@pA@o      @m陙@lfffff@lfffff@k33333@jfffff@i@il@iC33333@i@hp     @h@g陙@g33333@g     @g@g     @g33333@gp     @g&fffff@f陙@f@f     @f     @fffffff@fS33333@fP     @fL@f<@f33333@e@e@efffff@e33333@efffff@e33333@e@efffff@e     @el@ei@el@eS33333@e6fffff@e&fffff@e,@e0     @e#33333@e@d     @d33333@dfffff@d33333@dfffff@d@d     @dvfffff@dFfffff@d      @cfffff@c33333@cfffff@c33333@c     @c33333@c     @ci@cVfffff@cC33333@c<@c@     @c,@cfffff@cfffff@b@b@b@b33333@b@b@b     @b33333@b@b@b@b@bvfffff@bi@bc33333@bP     @bFfffff@bI@b333333@b@a@afffff@a     @aٙ@afffff@aə@a     @a     @a@a@afffff@a|@affffff@aP     @aFfffff@a33333@a      @`     @`陙@`@`@`陙@`陙@`33333@`33333@`@`@`6fffff@`33333@_33333@_fffff@_33333@_33333@_fffff@_y@_333333@^L@^@     @^Ffffff@^L@^`     @^l@^fffff@]     @]fffff@]     @]y@]l@]S33333@]     @]s33333@]l@]y@]l@]`     @\@\@\fffff@\S33333@\Ffffff@\Ffffff@\,@\@\@[@[@\fffff@[fffff@[@[33333@[l@[L@[@     @[@     @[      @Z     @Zfffff@Z33333@Zfffff@Z33333@Z33333@Z`     @Z333333@Y33333@Y     @Yffffff@Y&fffff@Xfffff@XFfffff@X@W@W33333@W     @W@W@W`     @Wfffff@V     @V     @Vfffff@V@Vffffff@V      @U33333@Uٙ@Ufffff@Ufffff@U@Uy@U@     @Ufffff@T@T33333@Tfffff@T     @TY@TY@T333333@S@Sfffff@Sfffff@S33333@S     @Sy@Sl@Sy@Ss33333@Sy@Sffffff@Sffffff@S333333@R@Rٙ@R     @R     @Rfffff@Rfffff@RY@RFfffff@R@     @R@     @RFfffff@RFfffff@R9@R33333@Qfffff@Q33333@Qfffff@Q     @Q     @Q33333@Q     @Q@Q     @Qffffff@Q9@Q33333@P     @P33333@P     @P@P     @Pfffff@P@P33333@Pfffff@Pffffff@PL@P33333@O     @Os33333@O333333@O@Nfffff@N@N@     @Mٙ@M@ML@M@     @M&fffff@M333333@M&fffff@M&fffff@M333333@M333333@M@     @M     @M33333@Mfffff@ML@Lfffff@L&fffff@Kٙ@Kٙ@K33333@Kfffff@K33333@Kfffff@K@K     @Kffffff@K&fffff@J33333@Jٙ@J@J@Js33333@Jffffff@JL@J333333@JL@J&fffff@J&fffff@JY@J@Jfffff@J     @Jfffff@J@J      @I33333@I333333@Hٙ@H@HL@H&fffff@H@H      @H333333@H333333@HL@HY@Hffffff@HL@H@Gfffff@G@G@Gffffff@G@F33333@F@Fffffff@F@Efffff@E     @Es33333@E@Dfffff@Dffffff@D@     @C@C     @CY@Cs33333@Cfffff@Cfffff@Cffffff@CL@CY@C      @B@Bfffff@Bfffff@B@Bs33333@BL@A     @A@A@A33333@Aٙ@A@Afffff@A33333@Aٙ@A@A&fffff@@33333@@@@fffff@@33333@@s33333@@&fffff@@      @?@?@?333333@?@?@?ffffff@?@>33333@>@>fffff@>fffff@>fffff@?@>33333@>L@>L@>L@=fffff@>L@=33333@=     @=     @=333333@=ffffff@=@=      @=      @<@<     @;@;333333@;     @;fffff@<333333@<L@<L@<L@<ffffff@<@<@<@<      @<      @;fffff@;@;@;@;     @;L@;L@;333333@;L@:@:L@:333333@9fffff@933333@9@9@9L@9@9@9     @9@9     @9     @9     @9     @9L@9@9333333@9@9L@9L@9L@9L@9333333@8fffff@8fffff@9@9@8fffff@833333@8fffff@833333@8fffff@833333@8@8     @8     @8@8ffffff@8@7fffff@7@7fffff@7     @733333@7@7     @7L@7ffffff@7L@7333333@7L@7ffffff@7ffffff@7@6@6@7      @6@6     @633333@6@6     @6ffffff@6     @6@6ffffff@6ffffff@6L@6@6333333@6ffffff@6      @6      @5@6      @6      @5@5@5fffff@5@5fffff@5fffff@5fffff@533333@5@5L@5L@533333@5ffffff@5ffffff@5L@5333333@5L@5ffffff@5L@5@5@5@5      @4fffff@5@4@4fffff@5      @4@4@433333@4fffff@4@433333@4     @4L@4     @4ffffff@4     @4L@4333333@3fffff@3fffff@3fffff@3@3@3@4      @3@3L@3L@3ffffff@3L@3@3L@3ffffff@3     @3      @2     @2@2@2333333@2333333@2L@1fffff@2L@2L@1fffff@1@1     @1ffffff@1     @2      @1@1L@1ffffff@1ffffff@1     @1ffffff@1ffffff@1L@1     @1     @1333333@1ffffff@1ffffff@1L@1L@1ffffff@1ffffff@1     @1L@1ffffff@1333333@1L@1ffffff@1333333@0fffff      @1L@1      @1      @0fffff@0fffff@0fffff@0fffff@0@033333@033333@0@0@0@033333@033333@0@0@0L@0fffff@0@0     @0     @0@0L@0@0      @0L@0@/@/@/@0@0333333@/@/@/ffffff@/@/@/@/ffffff@/      @.@/      @/      @/333333@/      @/333333@.@.      @-@-@.      @.333333@-@-ffffff@-ffffff@-      @-333333@-333333@-333333@-333333@-      @-@-      @,ffffff@,@,@,ffffff@,333333@,333333@,ffffff@,@,      @+@,      @+@+@+@+@+ffffff@+@+@+@+@+@+@+@+@+@+@,      @,333333@+@+@,      @+@,ffffff@,333333@+@,      @+@+@,      @+@+@+@,ffffff@,ffffff@,      @+@+@+@,      @,      @+@+@,      @+@+@+ffffff@+333333@+@+ffffff@,ffffff@+@+333333@+333333@+ffffff@+ffffff@+@+ffffff@+ffffff@+@+ffffff@+ffffff@+333333@+ffffff@+ffffff@+333333@+@+333333@+      @+ffffff@+ffffff@+ffffff@*ffffff@+ffffff@+@+@+333333@*@+      @*@+333333@+333333@+333333@+333333@+      @*@*ffffff@+      @*@*@*@*@*      @*ffffff@*@)@*      @*      @*333333@)@)@)@)ffffff@)@)@*      @*333333@)@)@)@)333333@(@)333333@)333333@)ffffff@)333333@)@)@)@)ffffff@)ffffff@)@)@)@)@)@)333333@)@)@)@)@)@)@)333333@)333333@)ffffff@)@)ffffff@)333333@(@(      @(ffffff@(@(@(@(@(@)333333@(@(@(@(ffffff@(      @(333333@(ffffff@(@(@(ffffff@(333333@(@(ffffff@(ffffff@(@(@(@(@(@)      @(@(@)      @(@(ffffff@(@)      @)333333@)ffffff@)      @)ffffff@)@)@)@)@*      @)@)@)@)@)ffffff@)      @)333333@)333333@)ffffff@*      @)ffffff@(@)ffffff@)@)ffffff@)ffffff@)333333@)333333@)ffffff@)333333@)      @)ffffff@)@)ffffff@)333333@)@)333333@)ffffff@)333333@)@)@)ffffff@)333333@)@*333333@)ffffff@)ffffff@)ffffff@)333333@)@*      @)ffffff@)@)@)@)ffffff@)ffffff@)@*      @*333333@*ffffff@*ffffff@*333333@*      @*      @*333333@*      @*ffffff@+333333@+      @*333333@*      @*      @+      @*@*@*@*@+      @+333333@+333333@+@+333333@+      @+333333@*@*@+      @+333333@+ffffff@+333333@+      @+333333@+333333@+@+ffffff@+333333@+ffffff@+ffffff@+333333@+@+@+@+@+@+@+@,      @+@+      @,      @+@+@+@,333333@,      @,ffffff@+@,ffffff@,      @,ffffff@-333333@,      @,ffffff@,@,      @,      @,ffffff@,      @,@,ffffff@,@,ffffff@-      @-333333@,@,ffffff@,ffffff@-      @,@-@-@-      @-@-@-ffffff@-@-@-ffffff@-ffffff@-ffffff@-@-@-333333@-ffffff@-ffffff@-@-ffffff@-@-@-@-@-@.@.      @.333333@.@.333333@.333333@.@.@.@.ffffff@.ffffff@.ffffff@.ffffff@.@/      @.ffffff@.@/333333@/      @.@.@/      @/333333@/333333@/ffffff@/@/333333@/@/@/@0      @/@/@/@0      @0L@0L@0333333@0     @0     @0ffffff@0@0ffffff@0ffffff@0@0@0@0@0ffffff@0L@033333@1      @033333@0@0fffff@0fffff@0@0fffff@0fffff@1      @1@0fffff@0fffff@1@1@1333333@1L@1L@1333333@1333333@1L@1L@1ffffff@1L@1L@1     @1@1@133333@1fffff@1fffff@1@2333333@2      @1fffff@2333333@2@2     @2@2@2ffffff@2ffffff@2@2@2     @2@2fffff@2@2fffff@3      @3@2@3@233333@2@3      @3333333@2fffff@2fffff@3@3@3@3     @3L@3L@3@3     @3     @3@3@3@3ffffff@3@333333@3@333333@3@3@3@3@333333@3fffff@4@333333@3fffff@4      @4L@3@4ffffff@4      @4ffffff@4L@4333333@4     @4L@4     @4@4fffff@5@4@4fffff@5333333@5@433333@4@5ffffff@5      @4fffff@5L@5L@4fffff@5@5333333@5ffffff@5333333@5@5@5333333@5ffffff@5333333@5333333@5L@5     @533333@5fffff@533333@533333@5@5@5fffff@6333333@6ffffff@6333333@5fffff@6333333@6L@6     @6@6ffffff@6@7333333@7      @6@7      @7L@7@7     @7333333@7333333@7ffffff@7L@7ffffff@7     @7     @7L@7L@8      @8      @733333@733333@7ffffff@7fffff@8@8333333@8333333@8333333@8333333@8ffffff@8@833333@833333@8@8@8ffffff@8     @8@8fffff@8@9333333@9L@9      @9     @9@9ffffff@9333333@9333333@9ffffff@9     @9     @9     @933333@9     @9     @933333@:      @:      @933333@9@9fffff@9fffff@:      @:@9fffff@:L@9@:@:ffffff@:@9fffff@:ffffff@:@:L@:@:fffff@;      @:33333@:@:33333@;333333@:@;      @;333333@;ffffff@;     @;33333@;@;@<      @;fffff@<@<@<333333@<@<@<ffffff@<L@<333333@<33333@<@<L@<ffffff@<@<     @<33333@=@=ffffff@=@=333333@<@=333333@=      @=@=fffff@>333333@>      @=@=@>@>333333@>333333@>333333@>ffffff@>ffffff@>333333@>     @>@>@>33333@?333333@?      @?@?@?@?333333@?333333@?     @?333333@?333333@?@?333333@?L@?333333@?     @?ffffff@?     @?ffffff@?L@?     @?fffff@?@?@?@?fffff@?@?@@@@@     @@&fffff@@Y@@ffffff@@Y@@s33333@@ffffff@@ffffff@@fffff@@     @@     @@     @@     @@@@ٙ@@fffff@@fffff@@fffff@A@@fffff@A@A@A@     @A&fffff@@33333@A&fffff@AL@A333333@A333333@A@     @AY@A&fffff@A&fffff@A@     @A@     @A     @Affffff@A     @Affffff@AL@A@A@Affffff@A     @A     @Afffff@A@A33333@A@Afffff@Afffff@A@A33333@B@B@B333333@B333333@B333333@BL@Bffffff@B@BL@BL@BL@B     @B     @Bffffff@Bffffff@Bffffff@Bffffff@B@     @B     @B@Bs33333@Bs33333@Bs33333@B@B     @B     @B33333@B33333@B33333@Bٙ@C@B@B33333@Bٙ@B33333@C@     @C333333@C333333@C@     @CL@Cffffff@Cs33333@CY@Cs33333@Cffffff@Cffffff@Cfffff@C@C@C     @C     @Cfffff@C@C33333@Cfffff@Cfffff@C@C33333@C33333@Cfffff@Cfffff@D      @Cٙ@Cfffff@D      @D@D@D333333@D333333@DY@DY@D333333@D&fffff@D&fffff@D&fffff@D&fffff@DL@D     @D@Dfffff@D     @D     @D@D@D@D@D33333@E      @D33333@D     @Dٙ@E@E      @Dٙ@E@E@E@E&fffff@E@EY@Effffff@E@     @EL@Effffff@E     @EY@Es33333@Effffff@Effffff@E     @Es33333@EY@E@E@E@E@Efffff@E     @E     @Es33333@E@Efffff@E     @E     @Efffff@F@E@E@Efffff@E33333@F      @F@F@F@F@     @F333333@Fs33333@FY@F@     @FL@F@     @FY@F     @F     @Fffffff@FY@F     @F@F@Ffffff@F@Ffffff@Ffffff@F     @F33333@F@F33333@F33333@F     @F     @Ffffff@Ffffff@Ffffff@Fٙ@G      @F33333@G&fffff@G@G333333@Gs33333@Gffffff@Gs33333@G     @Gffffff@G@G     @G     @G     @G@G     @G33333@G33333@Gfffff@G     @G33333@H@H@     @H333333@H333333@H333333@Hffffff@HY@H@     @H@     @H@     @H333333@H@     @Hffffff@HL@HL@H     @H     @Hffffff@Hffffff@H     @H     @H     @H     @Hfffff@H@H@Hfffff@Hfffff@H     @H33333@H33333@Hٙ@H     @H@H33333@Iffffff@IY@I&fffff@IL@I     @I@Ifffff@I@I     @I@I@I@I33333@Ifffff@I33333@I     @I     @Iٙ@J@J@J      @J@J      @J@J@J@     @J@     @JY@J333333@J@J333333@J&fffff@J@     @Js33333@JY@J     @Js33333@J     @J33333@J@J     @Jfffff@J33333@Jfffff@Jfffff@J33333@Jٙ@J33333@Jٙ@Jfffff@K      @K      @K      @K@KY@Kffffff@Kffffff@Ks33333@K@Ks33333@KY@K     @K     @Ks33333@Ks33333@K     @Kfffff@L      @K     @Kfffff@Kfffff@K@K33333@K@K@Kfffff@Kٙ@K33333@L&fffff@LY@L&fffff@LL@L      @Ls33333@Lffffff@L@L     @LY@L@L33333@Lfffff@Ls33333@L@Lfffff@Lٙ@Lٙ@L@Lٙ@Lfffff@M@Lfffff@L33333@M@ML@M@M@M      @M&fffff@M333333@M@     @M&fffff@M@M@M@Mffffff@Ms33333@M     @M     @Mٙ@Mfffff@M33333@M33333@N@N@N@N      @N&fffff@N@NY@NL@N333333@NL@N@Nfffff@N33333@Nfffff@Nfffff@N@N@N@Nٙ@Nfffff@N     @N     @N     @N33333@N@N@O      @O&fffff@N33333@Nfffff@O&fffff@O&fffff@O@O&fffff@O333333@O@Nٙ@O      @OY@OY@OY@O     @OY@Offfff@O     @O     @Os33333@Os33333@Offfff@O@Os33333@O@O33333@O@O33333@Oٙ@O@O@O@Oٙ@O33333@Offfff@O@O     @O@Offfff@O     @Offfff@P      @P      @Pfffff@P      @P&fffff@P@P@P333333@P      @P,@P9@PL@P`     @P@     @P`     @P9@PS33333@P`     @PY@Pffffff@Py@Pl@Py@P33333@P@Pfffff@Pfffff@Pfffff@Pfffff@P@P33333@P@P@P@P@Pfffff@Pfffff@P@P@P@P     @P@P@P@P@P@P33333@Q      @Pfffff@Pfffff@Pfffff@P@Q      @P@P33333@Pٙ@P@P@P33333@P@Qfffff@Q33333@Q@Q@Q@Q@Q@Qfffff@Q33333@Q33333@Q      @Q@Q,@Q9@Q@Q      @Q@Q@QFfffff@Qs33333@Q9@QFfffff@QS33333@QL@Q9@Q`     @Q`     @Q@     @Q`     @QY@Q@     @QL@Qs33333@Q`     @Q@     @QL@Qs33333@Q`     @Qffffff@Ql@Q`     @Ql@Qy@Ql@Qy@Q33333@Q     @Q@Q     @Qffffff@Q`     @Q     @Q33333@Q33333@Qfffff@Q33333@Q33333@Q33333@Q33333@Q@Q@Q@Q@Qfffff@Q33333@Q@Q33333@Q@Q@Q     @Qٙ@Q33333@Q@Q     @Qfffff@Q33333@Q33333@Q@Q33333@Q@Rfffff@Q@Q@Q33333@Qfffff@Q33333@Q@Qfffff@R@Rfffff@R@Rfffff@R@R333333@R@R33333@R@R&fffff@R      @R33333@R      @R@R      @R333333@R333333@R9@RL@RFfffff@R9@RFfffff@RS33333@R@     @R333333@R9@RL@Rl@Rs33333@R     @R`     @R`     @Rfffff@Rs33333@R@Rl@Rl@R`     @Ry@Rfffff@Rfffff@R@R@Ry@R33333@Rfffff@R33333@R     @R@R@R33333@Rfffff@Rfffff@R     @R@Rfffff@R33333@Rfffff@R@R33333@Rٙ@R     @R     @Rfffff@R@Rfffff@R33333@R33333@Rfffff@R@R@R33333@R     @R@R33333@R33333@R33333@S      @S@R@R@Rfffff@S33333@S      @S@S@S@S@S33333@R@R33333@S      @S      @S@S@R@R33333@Sfffff@S      @Sfffff@S      @R33333@R33333@Sfffff@Sfffff@R@R@R@S@S33333@S@Sfffff@S&fffff@S@S@     @S@     @S,@S      @S333333@S,@S      @S333333@S333333@SFfffff@SY@S&fffff@S333333@S333333@SFfffff@S@     @S@     @SFfffff@S`     @S`     @Sl@Sl@SL@SS33333@Sffffff@SL@Sl@Sy@Sffffff@Sl@Sffffff@S`     @S`     @Ss33333@S`     @Sfffff@S     @Ss33333@Sfffff@S33333@Sy@Sy@S     @S     @S@S33333@S@Sfffff@Sfffff@S@S33333@S     @S33333@S     @S@S33333@Sfffff@S@S33333@Sfffff@Sfffff@S     @S     @S@S@T@S@S@S33333@S33333@T      @T@T@S33333@T33333@T,@Tfffff@Sfffff@T@T      @T@T@Tfffff@T@T33333@Tfffff@T@T&fffff@S@T@T33333@T      @T      @T9@T333333@T33333@T333333@T9@T9@TFfffff@TFfffff@Tl@Tffffff@T`     @Tfffff@Ts33333@Ts33333@Tffffff@Tffffff@Ts33333@T     @Ty@Ty@Ts33333@T     @T     @T     @T@T33333@T@T@Tfffff@Tfffff@T     @Tfffff@T33333@T33333@T@T33333@T     @T33333@T@T@Tٙ@T@Tٙ@T     @Tfffff@T     @T@T33333@Tfffff@Tٙ@T@U      @T@T33333@U      @Ufffff@Ufffff@U@U333333@U333333@U@U&fffff@U333333@U,@U@U333333@U333333@U333333@U@U@U,@U@     @UL@U&fffff@U@     @UL@U333333@UY@UL@UY@UY@US33333@U@     @U`     @U333333@UFfffff@U`     @Us33333@UY@UY@Uffffff@Us33333@U`     @U     @Uy@Ul@UY@U`     @Ufffff@U`     @U`     @UY@Uffffff@Ufffff@Uy@Uy@U@U     @U@Ul@U@U@U@Ufffff@Ufffff@U@U@U@U@Ufffff@U@U@U@U     @U@U@U@U@U33333@U@U@U33333@Ufffff@U@Ufffff@U     @U     @U33333@Ufffff@Ufffff@U@Ufffff@U@V      @U@U@Uٙ@V      @Ufffff@U@Ufffff@Ufffff@Uٙ@Ufffff@U@Ufffff@U33333@Uٙ@U@U@Ufffff@U@U     @U@Ufffff@U@U33333@U@V      @U33333@Vfffff@U@Ufffff@V@V      @Uٙ@U@V@V      @U33333@V      @Vfffff@U33333@U@U@U@U@U@V@V@V&fffff@V33333@V@U     @U@V@V33333@U@V      @V33333@Vfffff@V@V9@V,@V@V@V&fffff@V333333@V      @V33333@V,@V9@U@V@V@V&fffff@V,@V@     @VFfffff@V&fffff@V,@V&fffff@V,@V@     @VFfffff@V      @V9@VFfffff@VY@VS33333@V`     @VFfffff@VY@VL@VFfffff@VY@VFfffff@V,@V9@VY@VL@VS33333@VY@Vffffff@VS33333@V333333@VFfffff@V`     @VL@VS33333@VY@VY@VL@VFfffff@Vffffff@Vs33333@VY@Vl@V     @V`     @VY@VY@VY@VY@V`     @VY@Vs33333@Vffffff@VY@V     @V@V     @Vy@Vfffff@V     @V@V@Vy@Vs33333@V@V@V     @V33333@V@Vfffff@V@V@Vfffff@V     @V@V33333@V     @V     @V     @V     @V@V     @Vfffff@V@V     @V33333@V@V     @V@V     @V     @V@V@Vfffff@Vٙ@V@V@V@Vٙ@Vfffff@V@V     @V@Vfffff@Vfffff@V@V@Vfffff@V     @Wfffff@Vٙ@V@Vfffff@V@Wfffff@Vٙ@V@Vfffff@Vٙ@V@W@V     @V@V@Wfffff@V@Vٙ@V@V@V33333@V@Vfffff@V@Vٙ@W      @Wfffff@W      @Wfffff@V@W@W&fffff@Vfffff@W@Wfffff@W@W      @W,@W9@W@     @W9@WL@W,@W,@W,@W9@W@     @WY@W`     @WFfffff@W`     @WY@WY@WS33333@Wffffff@Wffffff@WY@Wl@WY@Wl@Wl@W@W     @Wffffff@Wl@Wl@Wl@W`     @WY@W     @Wfffff@Wfffff@W@Wl@WY@Ws33333@W     @Wy@Ws33333@Wfffff@Wy@W     @W     @Wfffff@W     @Wl@W@Wfffff@W@Wfffff@W@W     @Wffffff@W@W@W@W@W33333@W33333@W@W@W     @W33333@W@Wfffff@W@W     @W@Wfffff@W33333@W@W@W     @W@W@Wfffff@W@W33333@W     @W@Wfffff@W     @W     @W     @W     @W     @W@W     @W     @Wfffff@W33333@W@W@W     @Wfffff@W@W33333@W@W     @W33333@W@W33333@W     @Wٙ@Wٙ@Wٙ@W     @W33333@Wٙ@Wٙ@W@W@W@W33333@W33333@W@W     @Wٙ@W@W@W@Wٙ@W@W     @W     @W@Wٙ@Wٙ@W@W     @W@W33333@W     @W@W@W     @Wfffff@W@W@W33333@W@W33333@X33333@W33333@W@Wٙ@W@Wٙ@W33333@W@X      @W@W     @X      @X@X33333@Xfffff@Xfffff@W@W@Xfffff@X@X33333@Xfffff@Xfffff@Xfffff@X33333@X@Xfffff@X@X@Xfffff@X,@X@     @X@X33333@Xfffff@X      @X@X@X33333@X,@X33333@X,@X333333@Xfffff@Xfffff@X@X33333@X33333@X,@X33333@X33333@X,@Xfffff@X@X33333@X@X      @X33333@X@X,@X33333@Xfffff@X      @X@     @XL@X33333@X33333@X333333@X@     @X9@X9@X@X9@X      @X,@X333333@X,@X9@X9@X      @XS33333@X@X      @X&fffff@X,@X      @W@X@X@X33333@X9@X,@X@X      @Xfffff@X@X@     @X33333@X@X,@X9@X33333@Xfffff@X333333@X333333@X,@X,@X&fffff@X&fffff@X@X,@XFfffff@X9@X9@X      @XL@X@X@X333333@XS33333@X333333@X9@X9@X      @X,@X@     @X333333@X333333@X@     @X&fffff@X,@X,@X333333@X333333@X@     @X333333@X9@X@     @X@     @X,@X@     @X9@X333333@XFfffff@X&fffff@Xfffff@X,@X333333@X@X      @X9@X&fffff@X33333@XL@XY@X      @X      @X@     @XL@X9@X333333@X,@X,@X@     @X33333@X`     @XFfffff@X&fffff@XFfffff@X333333@X&fffff@X      @X@     @X,@X,@X9@X333333@X9@X,@X9@X      @X@     @XS33333@X&fffff@Xfffff@XFfffff@X      @X`     @X      @X,@XL@X333333@X33333@XFfffff@X@     @X@     @X@     @X9@X333333@X9@X@     @XY@XFfffff@XFfffff@X@     @X&fffff@X,@Xffffff@X&fffff@X33333@XL@Xs33333@XL@X&fffff@X,@X@     @XS33333@X,@X@     @XL@X&fffff@XFfffff@X333333@X,@X`     @X333333@X      @XFfffff@X@     @X@     @X9@XY@X@     @X333333@X@XFfffff@XFfffff@XL@X@     @X,@X@     @X333333@XFfffff@XFfffff@X@     @X@X@     @XFfffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ?^5?|?\(?+?^5?|?S? ě?^5?|?^5?|?^5?|?&x?m?o?O;dZ?XbM?Vu?xF?\(?tj~?j~#?+J?$/?hr Ĝ?Vu?$/?Vu?$/?Q?\(?`A7L?`A7K?7KƧ?7KƧ?Q?zG{?tj~?`A7L?nP?/v?9XbN?nP?p
=q?+J?I^5?}?(\)?;dZ?+?O;dZ?(\)?      ?bM?tj~?dZ1?      ?E?E?tj~?KƧ?vȴ?Gz?\(?+I?"`?\(\?O;dZ?n?1&?vȴ9X?E?n?7KƧ?^5?|?o?n??|hs?hr!?+J?/w?j~#?1&y??zG{?E?tj~?bM?C%?A7Kƨ?"`?+?S?O;dZ?\(?Ƨ-?tj~?Q?xF?&x?؃nP?٩lD?|hr?5?|h?ԋC%?I^5?}?ӕ$/?`A7?tj~?bM?/v?1&?ǮzG?Ƈ+I?9XbM?hr Ĝ?vȴ9X?j~"?"`A?Gz?ȴ9Xb?$/?+?+?+?tj~?-V?Q?-V?Q?lD?`A7L?
=p?&x?hr Ĝ?&x?
=p?hr Ĝ?E?`A7L?`A7L?`A7L?
=p?Q?lD?
=p?vȴ9X? ěT?
=p?
=p? ěT?`A7L?vȴ9X?Q?;dZ?`A7L? ěT?;dZ?vȴ9X? ěT?;dZ?vȴ9X?Q?vȴ9X?Q?;dZ?vȴ9X?
=p? ěT?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?Q?;dZ?Q?;dZ?Q?Q?5?|h?5?|h?Q? ěT?vȴ9X?;dZ?Q?;dZ? ěT? ěT?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?bM?vȴ9X? ěT?;dZ?vȴ9X?vȴ9X?
=p?bM? ěT?Q?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ? ěT? ěT? ěT? ěT?vȴ9X?;dZ?;dZ?vȴ9X? ěT?bM?vȴ9X? ěT?vȴ9X?bM?bM?vȴ9X?;dZ?vȴ9X?
=p?;dZ? ěT? ěT?
=p?;dZ?
=p? ěT?bM?bM?
=p?;dZ?vȴ9X?vȴ9X? ěT? ěT?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?bM?bM?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ? ěT?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?bM?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?Q? ěT?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?Q?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X? ěT? ěT?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ? ěT?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?Q?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?bM?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?vȴ9X? ěT?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ? ěT?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?;dZ?;dZ?vȴ9X?;dZ?;dZ? ěT? ěT?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X? ěT?vȴ9X?;dZ?;dZ?vȴ9X? ěT? ěT? ěT? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X? ěT?vȴ9X? ěT?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X? ěT?;dZ?;dZ?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?bM?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X? ěT? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?Q?;dZ?;dZ?vȴ9X?;dZ?Q?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?Q?;dZ?;dZ?Q?;dZ?Q?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?Q?Q?Q?Q?;dZ?Q?5?|h?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?;dZ?Q?Q?Q?Q?;dZ?Q?Q?Q?5?|h?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?;dZ?5?|h?5?|h?Q?5?|h?Q?Q?Q?5?|h?5?|h?Q?Q?Q?5?|h?5?|h?5?|h?Q?Q?Q?;dZ?5?|h?Q?Q?Q?Q?5?|h?Q?Q?Q?5?|h?5?|h?;dZ?;dZ?;dZ?5?|h?Q?5?|h?;dZ?;dZ?Q?Q?Q?Q?5?|h?Q?Q?Q?;dZ?Q?Q?Q?5?|h?5?|h?Q?Q?Q?;dZ?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?;dZ?5?|h?;dZ?;dZ?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?5?|h?5?|h?Q?5?|h?5?|h?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?5?|h?5?|h?Q?5?|h?Q?Q?Q?5?|h?Q?Q?Q?;dZ?Q?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?Q?5?|h?5?|h?Q?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?Q?5?|h?Q?5?|h?5?|h?Q?Q?Q?5?|h?Q?5?|h?Q?5?|h?5?|h?-V?5?|h?/v?Q?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?/v?5?|h?Q?5?|h?Q?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?Q?Q?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?-V?-V?5?|h?-V?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?-V?5?|h?5?|h?-V?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?-V?-V?5?|h?Q?5?|h?-V?5?|h?/v?/v?/v?5?|h?Q?5?|h?Q?5?|h?-V?-V?-V?5?|h?Q?5?|h?-V?1&y?-V?-V?-V?5?|h?5?|h?-V?5?|h?-V?/v?-V?5?|h?5?|h?5?|h?5?|h?5?|h?-V?/v?5?|h?/v?-V?-V?/v?5?|h?5?|h?5?|h?/v?/v?5?|h?5?|h?5?|h?/v?1&y?5?|h?5?|h?5?|h?5?|h?-V?5?|h?-V?/v?-V?/v?-V?-V?1&y?/v?5?|h?-V?-V?5?|h?-V?/v?-V?5?|h?-V?-V?-V?/v?-V?-V?5?|h?5?|h?/v?5?|h?/v?/v?-V?-V?-V?-V?5?|h?-V?-V?Q?5?|h?-V?/v?-V?/v?5?|h?5?|h?-V?1&y?/v?5?|h?5?|h?5?|h?/v?-V?/v?-V?/v?-V?/v?/v?/v?/v?-V?/v?-V?-V?-V?-V?-V?5?|h?5?|h?-V?/v?1&y?1&y?/v?-V?/v?/v?5?|h?/v?-V?/v?/v?1&y?/v?/v?/v?1&y?/v?-V?1&y?-V?-V?-V?-V?-V?/v?/v?-V?/v?/v?-V?-V?-V?-V?1&y?1&y?/v?/v?/v?5?|h?-V?/v?-V?-V?5?|h?/v?1&y?/v?-V?/v?/v?5?|h?1&y?-V?1&y?1&y?-V?/v?-V?5?|h?-V?/v?-V?1&y?/v?1&y?1&y?-V?/v?1&y?/v?-V?/v?/v?/v?/v?/v?1&y?1&y?-V?/v?1&y?1&y?/v?1&y?1&y?/v?/v?/v?1&y?1&y?1&y?/v?1&y?1&y?1&y?/v?1&y?1&y?1&y?1&y?/v?1&y?/v?1&y?/v?/v?/v?1&y?/v?1&y?1&y?/v?/v?(\)?/v?1&y?/v?1&y?/v?1&y?/v?/v?/v?1&y?1&y?/v?/v?1&y?-V?/v?1&y?/v?1&y?1&y?1&y?1&y?1&y?/v?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?/v?/v?/v?1&y?/v?1&y?-V?/v?1&y?/v?1&y?/v?1&y?1&y?(\)?1&y?1&y?/v?1&y?(\)?1&y?(\)?1&y?1&y?1&y?1&y?1&y?(\)?1&y?1&y?1&y?1&y?1&y?1&y?(\)?1&y?(\)?1&y?1&y?1&y?1&y?/v?/v?1&y?/v?1&y?1&y?(\)?(\)?(\)?1&y?1&y?1&y?1&y?(\)?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?(\)?1&y?1&y?1&y?1&y?1&y?(\)?1&y?(\)?(\)?1&y?1&y?1&y?1&y?1&y?1&y?(\)?1&y?1&y?1&y?1&y?1&y?(\)?(\)?S?1&y?(\)?1&y?(\)?1&y?1&y?1&y?1&y?1&y?1&y?1&y?(\)?(\)?(\)?1&y?1&y?1&y?1&y?1&y?(\)?(\)?1&y?1&y?1&y?1&y?(\)?(\)?(\)?(\)?(\)?1&y?1&y?(\)?1&y?(\)?(\)?(\)?(\)?/v?1&y?(\)?1&y?(\)?1&y?(\)?1&y?1&y?1&y?1&y?(\)?1&y?1&y?1&y?1&y?1&y?(\)?(\)?1&y?S?S?(\)?1&y?(\)?1&y?(\)?1&y?(\)?(\)?1&y?1&y?(\)?(\)?(\)?(\)?(\)?(\)?1&y?1&y?1&y?(\)?(\)?1&y?(\)?(\)?(\)?1&y?(\)?1&y?(\)?(\)?(\)?1&y?1&y?(\)?(\)?(\)?(\)?(\)?(\)?1&y?1&y?(\)?(\)?(\)?/v?1&y?(\)?(\)?1&y?1&y?(\)?1&y?1&y?(\)?1&y?1&y?(\)?(\)?1&y?(\)?S?(\)?1&y?(\)?(\)?1&y?1&y?(\)?(\)?(\)?(\)?1&y?(\)?1&y?(\)?(\)?(\)?(\)?(\)?S?(\)?S?(\)?(\)?(\)?(\)?S?1&y?(\)?(\)?1&y?(\)?(\)?(\)?(\)?S?S?S?(\)?(\)?(\)?(\)?(\)?(\)?(\)?(\)?(\)?1&y?1&y?(\)?(\)?(\)?(\)?S?(\)?(\)?(\)?(\)?(\)?(\)?(\)?(\)?(\)?(\)?1&y?(\)?1&y?1&y?1&y?(\)?1&y?1&y?S?(\)?(\)?1&y?(\)?1&y?1&y?(\)?(\)?(\)?(\)?S?(\)?(\)?S?(\)?1&y?(\)?1&y?(\)?(\)?S?(\)?(\)?1&y?(\)?(\)?(\)?(\)?S?1&y?1&y?(\)?(\)?(\)?1&y?(\)?(\)?(\)?(\)?(\)?(\)?1&y?(\)?(\)?1&y?(\)?S?1&y?S?S?(\)?(\)?(\)?(\)?(\)?S?(\)?(\)?S?(\)?(\)?(\)?(\)?(\)?(\)?(\)?(\)?1&y?S?S?(\)?1&y?1&y?(\)?S?(\)?(\)?S?(\)?1&y?1&y?S?(\)?S?(\)?(\)?1&y?(\)?(\)?1&y?1&y?(\)?(\)?(\)?(\)?1&y?(\)?(\)?(\)?1&y?(\)?1&y?(\)?1&y?(\)?(\)?1&y?(\)?(\)?(\)?(\)?(\)?(\)?1&y?(\)?(\)?(\)?(\)?(\)?(\)?(\)?(\)?(\)?1&y?(\)?1&y?1&y?(\)?S?(\)?1&y?(\)?(\)?S?S?(\)?(\)?S?(\)?1&y?(\)?(\)?(\)?S?(\)?(\)?(\)?(\)?(\)?(\)?1&y?(\)?1&y?(\)?(\)?(\)?(\)?(\)?(\)?(\)?S?S?(\)?(\)?S?S?1&y?S?S?(\)?(\)?(\)?S?S?(\)?S?(\)?S?S?(\)?(\)?S?S?(\)?(\)?(\)?(\)?(\)?(\)?S?S?(\)?S?(\)?S?S?S?S?S?(\)?(\)?(\)?(\)?(\)?S?S?S?(\)?S?S?S?S?S?(\)?S?(\)?(\)?S?"`A?S?S?S?(\)?S?S?"`A?S?S?S?(\)?S?S?(\)?S?S?S?S?S?S?S?S?S?S?S?(\)?S?S?S?S?(\)?(\)?S?S?S?S?S?"`A?"`A?"`A?S?S?S?"`A?S?"`A?S?S?S?S?S?S?S?S?S?S?S?S?(\)?S?S?"`A?(\)?S?S?S?S?S?(\)?S?S?S?S?S?S?(\)?S?S?S?S?S?S?S?S?S?S?S?S?S?"`A?S?S?S?S?S?S?S?(\)?S?(\)?"`A?"`A?S?S?S?S?S?S?(\)?S?S?S?S?S?S?S?"`A?"`A?S?"`A?S?S?S?S?S?S?S?S?S?"`A?S?S?S?S?S?S?S?S?S?S?S?S?"`A?S?S?S?S?"`A?S?"`A?S?S?S?(\)?S?S?S?"`A?S?S?S?S?(\)?S?S?"`A?S?S?S?S?S?S?S?S?S?S?S?S?S?S?S?"`A?S?S?S?S?S?S?S?S?"`A?"`A?S?(\)?S?S?S?S?"`A?"`A?S?S?S?S?"`A?S?S?S?S?S?S?S?S?S?S?S?"`A?vȴ9?"`A?"`A?S?S?"`A?"`A?S?"`A?"`A?"`A?S?S?"`A?S?S?S?S?S?"`A?S?S?S?"`A?S?"`A?"`A?"`A?S?S?S?S?"`A?"`A?S?S?S?S?"`A?"`A?S?S?S?S?S?"`A?S?S?S?"`A?S?S?S?S?"`A?"`A?S?S?S?"`A?S?S?S?S?"`A?S?S?"`A?"`A?"`A?"`A?S?S?"`A?S?"`A?"`A?"`A?S?S?S?S?"`A?S?S?"`A?"`A?S?"`A?S?S?vȴ9?"`A?vȴ9?"`A?S?S?S?S?S?S?"`A?"`A?vȴ9?"`A?vȴ9?"`A?"`A?"`A?S?S?vȴ9?"`A?S?S?S?S?S?S?"`A?"`A?"`A?"`A?"`A?S?"`A?S?vȴ9?"`A?S?"`A?vȴ9?"`A?S?S?S?S?"`A?S?vȴ9?"`A?"`A?"`A?1&?"`A?"`A?"`A?S?vȴ9?"`A?S?S?S?S?"`A?S?"`A?S?"`A?"`A?vȴ9?"`A?S?"`A?"`A?S?S?S?S?"`A?S?S?S?S?"`A?"`A?"`A?"`A?"`A?"`A?"`A?"`A?S?"`A?"`A?S?S?"`A?"`A?"`A?"`A?"`A?S?"`A?"`A?"`A?"`A?"`A?"`A?"`A?"`A?S?"`A?"`A?S?"`A?S?S?vȴ9?"`A?S?"`A?"`A?vȴ9?S?S?"`A?vȴ9?1&?vȴ9?S?S?vȴ9?"`A?"`A?"`A?"`A?vȴ9?"`A?"`A?"`A?vȴ9?"`A?S?"`A?"`A?"`A?S?S?"`A?"`A?S?vȴ9?"`A?"`A?"`A?vȴ9?1&?"`A?vȴ9?S?"`A?"`A?"`A?S?"`A?"`A?S?"`A?"`A?1&?1&?vȴ9?"`A?S?"`A?"`A?vȴ9?"`A?S?S?S?vȴ9?vȴ9?vȴ9?"`A?"`A?"`A?"`A?"`A?vȴ9?S?"`A?"`A?"`A?"`A?"`A?"`A?S?"`A?vȴ9?"`A?"`A?"`A?"`A?"`A?"`A?S?vȴ9?"`A?"`A?S?S?S?"`A?vȴ9?1&?1&?vȴ9?"`A?S?1&?1&?vȴ9?S?(\)?"`A?"`A?vȴ9?"`A?"`A?S?"`A?"`A?S?"`A?"`A?"`A?"`A?"`A?S?vȴ9?"`A?S?vȴ9?S?S?S?1&?"`A?"`A?S?S?"`A?vȴ9?"`A?vȴ9?"`A?1&?vȴ9?"`A?S?S?"`A?"`A?vȴ9?"`A?S?"`A?"`A?S?"`A?1&?vȴ9?"`A?"`A?(\)?vȴ9?1&?S?"`A?"`A?"`A?vȴ9?"`A?S?"`A?vȴ9?"`A?S?S?S?vȴ9?vȴ9?"`A?"`A?S?"`A?S?"`A?1&?"`A?"`A?"`A?vȴ9?"`A?vȴ9?"`A?vȴ9?vȴ9?vȴ9?"`A?"`A?S?"`A?"`A?"`A?vȴ9?"`A?S?"`A?"`A?"`A?S?S?"`A?"`A?vȴ9?S?vȴ9?1&?"`A?S?"`A?"`A?S?"`A?1&?"`A?"`A?vȴ9?vȴ9?"`A?"`A?"`A?vȴ9?vȴ9?"`A?vȴ9?vȴ9?S?S?"`A?S?"`A?"`A?"`A?"`A?"`A?"`A?"`A?S?"`A?"`A?"`A?"`A?"`A?"`A?"`A?vȴ9?S?"`A?S?"`A?"`A                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	P12                                     2                                       )BCH3 ̀