CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20170205   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P9     CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:35.104166Z    ORIGINAL_HEADER      6CTD,20250210CCHSIOWB
#Removed 'CTDFLUOR_TSG' as it's filled with -999
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2017-06-29. CTD data from cruise 18DD20170205, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20170205. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2017-001/index.php. 
#
# The information in this file for the cruise 2017-001 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-0036.ctd
#
# Start of originator file comment header
#
#*2017/06/29 15:26:50.02
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2017/02/10 06:17:38.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 198
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : CE9F1F72
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            0.3            202.1
#       2 Temperature:CTD               deg_C_(ITS90)   5.6248         6.8697
#       3 Salinity:CTD                  PSS-78          32.78          33.8432
#       4 Sigma-t:CTD                   kg/m^3          25.7461        26.7106
#       5 Oxygen:Dissolved:CTD:Volume   ml/l            3.4            6.87
#       6 Oxygen:Dissolved:CTD:Mass     µmol/kg         147.7          299
#       7 Fluorescence:CTD:Seapoint     mg/m^3          0.66E-01       1.162
#       8 PAR:CTD                       µE/m^2/sec      0              0.3
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        7  F       ' '     2
#       6  -99   ' '        6  F       ' '     1
#       7  -99   ' '        8  F       ' '     3
#       8  -99   ' '        7  F       ' '     1
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2017-001
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P21
#    EVENT NUMBER        : 36
#    LATITUDE            :  49  38.00000 N  ! (deg min)
#    LONGITUDE           : 139  39.97000 W  ! (deg min)
#    WATER DEPTH         : 3961
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    The descent rate of the CTD was very noisy with some complete reversals
#	of direction.
#    CTDEDIT was used to remove many records corrupted by shed wakes;
#	salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Fluorescence and PAR data are nominal and unedited except that some records were
#	removed in editing temperature and salinity and a large spike in
#	fluorescence was removed from file 0032.
#
#    The Transmissivity channel was removed because of frequent shifts in values during
#	casts and large variations between values during repeat casts.
#	The data are available, by request, from the chief scientist.
#
#    NOTE: While the Fluorescence:CTD data are expressed in concentration units, they
#	do not always compare well to extracted chlorophyll samples, particularly for
#	casts far from shore. It is recommended that users check extracted chlorophyll
#	values where available.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in Sea-Bird
#	Application Note #64-2, June 2012 revision (Sea-Bird_64-2_Jun2012.pdf), except 
#	that a small offset in the fit was allowed.
#
#    The Dissolved Oxygen sensor used in files 0001, 0002 and 0016 malfunctioned so the 
#	Oxygen:Dissolved:CTD channels were removed from those files.
#
#    The Oxygen:Dissolved:CTD sensor has a fairly long response time so data accuracy 
#	is not as high when it is in motion as it is during stops for bottles. This will be
#	especially true when vertical dissolved oxygen gradients are large. To get an estimate
#	of the accuracy of the Oxygen:Dissolved:CTD data during downcasts (after recalibration)
#	a rough comparison was made between downcast Oxygen:Dissolved:CTD data and upcast 
#	titrated samples. Some of the difference will be due to problems with flushing of 
#	Niskin bottles and/or analysis errors, so the following statement likely underestimates 
#	Oxygen:Dissolved:CTD accuracy.
#
#    Downcast (CTD files) Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.25 ml/l from 0 to 125 dbar.
#	±0.2 ml/l from 125 to 400 dbar.
#	±0.1 ml/l from 400 to 600 dbar.
#	±0.05 ml/l from 600 to 1500 dbar.
#	Low by up to 0.08 ml/l below 1500 dbar.
#
#    For details on the processing see document: 2017-001-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5--- --6-- ---7--- --8---
#!Pressu Temperat Salinity Sigma-t: Oxygen Oxyge Fluores PAR:  
#!re:CTD ure:CTD  :CTD     CTD      :Disso n:Dis cence:  CTD   
#!                                  lved:  solve CTD:          
#!                                  CTD:   d:CTD Seapoin       
#!                                  Volume :Mass t             
#!------ -------- -------- -------- ------ ----- ------- ------
#*END OF HEADER
     WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @U@        data_max      @U@        C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     <  2   pressure                	long_name         pressure   positive      down   units         decibar    data_min      @    data_max      @c33333   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      <  od   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d            temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?zxl"h   data_max      @ \N   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       <     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d            salinity                	long_name         salinity   units         PSS-78     data_min      @@ArGE   data_max      @ALtSM   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      <    salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d        C$   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @%333333   data_max      @r4   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        < RD   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d           CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?(\)   data_max      ?Vt   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      <    CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d        d   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min                 data_max      @   C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       <    PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d        &   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min               data_max               C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     < 5$   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d        q   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         (    cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         (    time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      *   data_max      *   C_format      %10d          latitude               	long_name         latitude   units         	degrees_N      data_min      @Hmhr!   data_max      @Hmhr!   C_format      %9.4f             	longitude                  	long_name         	longitude      units         	degrees_E      data_min      `%S   data_max      `%S   C_format      %9.4f             	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d            	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min        ?   data_max        ?   C_format      %4d        $@U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @U@     @ @333333@      @      @      @      @       @"      @#@&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @6@8@9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @As33333@B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G@G     @H      @H     @I      @I     @Ifffff@J     @K      @K     @L      @L     @L33333@M33333@M33333@N     @O      @O     @Pfffff@P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @X@YY@Y     @Y     @Z      @Z@     @Z     @Z     @[fffff@[      @[fffff@[     @\      @\@     @\     @\     @]      @]@     @]l@]     @^      @^@     @^     @^     @_fffff@_Ffffff@_fffff@_     @`      @`      @`@     @``     @`     @`33333@`fffff@`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b@b@b@     @b`     @b     @b     @b@c      @c      @c@     @c`     @c     @c@cfffff@d      @d      @dC33333@dP     @d33333@d     @d     @d     @d@e)@e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f|@f33333@f     @g      @g      @g@     @g`     @g33333@g33333@gfffff@g     @h      @h      @h@     @hp     @h     @h     @h     @h     @i      @i      @i6fffff@i`     @i|@i     @i     @i     @j      @j      @j333333@jc33333@j     @j     @j33333@j陙@k      @k      @k@     @k`     @k     @k     @k     @k33333@l      @l      @l@     @l`     @l33333@l33333@l33333@m      @m      @m6fffff@mffffff@m     @m     @m     @m     @n33333@nc33333@n     @n     @n     @n     @o      @o#33333@o@     @oc33333@o     @o     @o     @pfffff@p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @qfffff@qA@qP     @q`     @qnfffff@q@qfffff@q     @q     @q     @q     @q     @q񙙙@qfffff@r     @r      @r0     @r>fffff@rS33333@r`     @rp     @r     @r     @r     @r     @r@rљ@r     @r     @s      @s     @s      @s0     @s@     @sP     @s[33333@sp     @s     @s     @s     @s     @s     @sə@s@s     @t      @t     @t      @t0     @t@     @tI@tc33333@tp     @t     @t     @t     @t     @t@tfffff@t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @uq@u~fffff@u     @u     @u     @u     @u     @u     @u     @v@v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v@vfffff@v     @v     @v     @w      @wfffff@w      @w0     @w@     @wP     @w`     @wq@w~fffff@w     @w     @w     @w     @w     @w     @w     @x@x     @x      @x0     @x@     @xP     @x`     @xq@x     @x     @x     @x     @x     @xљ@xfffff@x     @y      @y     @y!@y1@yA@yNfffff@y`     @yp     @y     @y@y     @y     @y     @yљ@y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z@z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{q@{~fffff@{     @{     @{     @{@{     @{     @{     @|      @|     @|!@|1@|@     @|P     @|`     @|p     @|     @|@|fffff@|fffff@|     @|     @|     @|     @|fffff@}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}ᙙ@}fffff@~      @~     @~      @~0     @~@     @~L@~c33333@~p     @~     @~fffff@~@~     @~     @~     @~33333@~     @      @33333@#33333@0     @@     @P     @`     @l@     @     @     @     @     @     @     @     @      @     @     @     @33333@(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @fffff@@     @     @     @     @     @     @     @     @     @     @     @     @      @33333@@     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @33333@     @     @     @     @     @     @     @     @ՙ@ᙙ@     @     @     @      @     @     @     @     @0     @8     @@     @H     @P     @X     @\@h@p     @x     @     @     @@     @     @     @     @33333@@33333@fffff@     @     @     @     @      @     @     @     @*fffff@/33333@8     @@     @H     @P     @X     @\@rfffff@x     @     @     @     @     @@fffff@     @     @     @     @     @     @fffff@33333@     @     @      @     @     @     @      @(     @0     @4@@     @H     @P     @X     @`     @h     @p     @u@@     @     @     @     @     @fffff@     @     @     @     @     @fffff@      @     @     @     @ @$     @1@8     @@     @H     @P     @X     @jfffff@p     @x     @     @     @@     @     @33333@     @     @     @     @     @     @     @     @     @fffff@@     @     @      @(     @0     @8     @=@P@X     @`     @h     @p     @x     @     @@33333@     @     @     @     @     @     @     @     @     @     @     @     @33333@
fffff@     @     @      @(     @0     @8     @@@H     @P     @X     @`     @h@p     @x     @     @     @     @fffff@     @     @     @     @     @     @33333@     @     @     @     @      @@@@      @(     @0     @8     @@@H     @P     @X     @`     @h     @p     @u@@     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @      @     @     @     @fffff@)@0     @8     @@     @H     @Q@X     @`     @h     @p     @x     @33333@     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@@      @     @     @     @      @(     @0     @8     @>fffff@G33333@P     @X     @`     @h     @p     @x     @}@@     @     @     @     @     @     @     @     @     @ՙ@ᙙ@     @     @     @      @     @     @@      @(     @0     @8     @@     @H     @Nfffff@`@h     @p     @x     @     @@@     @     @     @fffff@33333@     @     @     @     @     @@@     @     @     @      @(     @0     @4     @A@H     @P     @X     @`     @ffffff@p@x     @     @     @     @     @     @     @@@     @     @     @     @     @fffff@@33333@@      @(     @0     @8     @@     @H     @Nfffff@X     @`     @h     @p@t     @     @     @     @     @     @33333@33333@     @@fffff@     @     @     @     @     @fffff@      @     @     @     @      @(     @,     @8     @@     @H     @P     @X     @`     @ffffff@q@x     @     @33333@     @     @     @     @fffff@33333@     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @"@)@,     @0     @4     @8     @<     @@     @D     @H     @K@Q@T     @X     @\     @`fffff@d     @g33333@k@p     @t     @x     @|     @     @fffff@33333@     @     @     @33333@     @@     @     @     @     @@@     @fffff@@     @     @     @     @     @     @@@     @     @     @     @     @      @@@     @     @     @     @      @$     @(     @,     @0     @4     @8     @:@@fffff@D     @H     @Lfffff@P@T     @X     @\     @`     @d     @g@l@p     @t     @x     @|     @     @33333@fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @@@     @     @     @fffff@     @     @     @     @     @     @@$@(     @+33333@0fffff@4     @8     @<     @?@Hfffff@L     @P     @T     @X     @\     @_33333@i33333@l     @p     @t     @x     @|     @     @33333@fffff@     @     @     @     @@     @     @     @     @     @     @     @fffff@     @33333@     @     @     @     @     @     @33333@񙙙@     @     @     @      @     @     @
fffff@     @     @     @33333@%@(     @,     @0     @4     @933333@:@@fffff@Bfffff@Hfffff@L     @P     @Tfffff@X     @\     @`     @d     @h     @k33333@pfffff@t     @x     @|     @     @     @     @     @     @     @@     @     @     @     @     @@     @     @     @     @Ù@     @     @     @     @     @     @     @     @     @     @fffff@     @     @      @     @     @     @fffff@     @     @fffff@ fffff@$     @(     @,     @0     @2@933333@<     @@     @B@H     @L     @P     @T     @X     @[33333@d     @h     @k@q33333@t     @x     @|     @     @     @     @fffff@@     @     @@     @     @     @     @     @     @33333@fffff@     @     @     @     @     @@33333@     @     @     @     @     @fffff@     @      @     @     @
fffff@@     @     @     @      @$     @(     @,     @0     @4     @7@<@@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @pfffff@r     @y33333@|     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @@fffff@     @     @     @     @     @     @      @     @     @     @fffff@@     @     @      @$     @(     @,     @0     @333333@<     @@     @D     @H     @R     @T     @X     @\     @`     @b@l@p     @t     @x     @fffff@     @     @     @     @     @     @     @@     @     @     @     @     @     @     @@@     @     @     @     @     @     @@@     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @33333@(@,     @0     @4     @8     @<     @>@F     @H     @L     @P     @T     @X     @\     @^fffff@e@h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @@33333@     @     @     @     @     @33333@33333@     @     @     @33333@fffff@      @     @     @     @     @@fffff@33333@      @$     @(     @,     @.fffff@4fffff@8     @;@@     @D     @H     @L     @P     @U@X     @\     @`     @d     @h     @l     @p     @r@x@|     @     @     @     @     @33333@@@     @     @     @@@     @     @fffff@fffff@     @     @     @     @     @     @fffff@33333@     @     @     @     @     @     @      @     @fffff@     @     @     @     @@,     @0     @4     @8     @@@D     @H     @L     @P     @T     @X     @a33333@d     @h     @l     @p     @tfffff@y33333@{@     @     @     @@fffff@     @     @     @     @     @33333@     @     @33333@     @     @     @     @     @     @fffff@     @     @㙙@     @     @     @     @     @     @      @     @     @
@     @     @     @     @@%33333@(     @,     @0     @4     @8     @<     @@     @D     @Hfffff@Lfffff@P     @T     @X     @\     @`     @b@i33333@l     @p     @t     @x     @z@33333@     @     @     @     @     @     @@@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@33333@     @     @     @     @      @@	@     @     @     @     @     @      @$     @&@0@4     @8     @<     @@     @B@I@L     @P     @T     @W@\@`     @d     @h     @l     @p     @t     @w@@     @     @     @     @     @@fffff@@     @     @     @     @     @@     @     @     @     @@     @     @     @     @     @     @     @fffff@     @fffff@     @     @      @     @@@     @     @     @     @      @$     @)@,     @0     @4     @8     @;33333@A33333@D     @H     @L     @P     @T     @W@]33333@`     @d     @h     @l     @p     @r@|fffff@     @     @     @     @     @33333@     @@     @     @     @     @fffff@     @     @     @@     @     @     @     @@     @     @     @     @     @     @     @      @     @     @     @     @     @     @ fffff@$     @(     @+@0@4     @8     @<     @@     @D     @H     @K33333@Q@T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @@@     @     @     @     @33333@33333@     @     @     @     @     @י@33333@     @     @     @     @     @33333@ fffff@     @     @     @     @@fffff@      @$     @(     @,     @0     @2fffff@<@@     @D     @H     @L     @N@T     @X     @\     @`     @d     @h     @l     @nfffff@s@x@|     @@     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @fffff@fffff@@     @fffff@     @     @     @     @@ @     @     @     @@@     @     @      @$     @(     @,     @0     @2     @8@<     @@     @D     @H     @L     @Q@T     @X     @\     @`fffff@c33333                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                @h	ԕ+@fA@cA [@bwkQ@`[6@_o@`҈p@_䎊r@^Ov_خ@]/w@]/w@\>@][@],=@]cA @]IQ@]IQ@]/w@],=@],=@XbM@Qu@Nqi@L@L_@J=p
@I^5?}@I7KƧ@H@Hu%F@HK]c@G@@HeO@HK]c@G@@GE84@GE84@G+I@G)^@F]cf@EoiDg@D2W@CnP@C$@C%2@Dtj@DJM@Fs@I'RTa@Ik~(@I@Ik~(@IoiD@I'RTa@I@JqiC@L/{J#@Sa@O@Z6C@Zu%F@Y0
)@XPH@_vȴ9@|hs@㢜wk@V@KƧ@lC@ڹZ@  4m@ \N@ $@ }Vm@ u%F
@ 9@  C@Q@䎊r@v+jg@dtSM@XPH@S@P`A7@OAs@MO;dZ@L~($x@K:)z@Jn@FYJ@9XbM@.1@sPH@ C@Y|@Ov`@Q@ۋq
@,<@N;5@4m@z)y@q[W>6@q@iy@h$xG@Ye+a@F@EQ@B@4n@@6@>
(@5'0@-U=@@Ov_@!R<@p:@m\@ hۋq@Vl!@4֡b@C]@_o@\N<@xF@+j@>BZ@䎊@\(@eu@F$/@>\N<@'lC@]ce@_o@a@O@
%@S&@Q@@zxl"h@_F@©@ߤ?@1@ߤ@B@W>6z@z~@YJE@LI^5?@;s@0{@$?@b}@	 ѷ@@C\@c	@ɠ'RTa@%1@W>6z@?$tS@)^@ -
@/{J#@JM@@rG@m\@H@$xG@9@5?|@T`d@֡a@IQ@0
)@R<6@E@_p@(@Ƨ@p@b3@<#x@=K^@"@@\)@kP|@T`d@ԕ*@#@G{@PH@\@~"@qi@yXbM@tJ@ao@Rp:@1[W>6@*0@\(@ C@Vϫ@,@x@ ѷ@}Vl@B@C,@9@-w1@JE@rGE9@As@v_ح@@C@z)_@vz@nzG@]ce@T*1@QR@OrGE9@G_o@B74@A@A7Kƨ@6+jg@)^@xF@2W@U2a|@O
@ae@u%@2a|@@\1&@Zc	@YJE@VOv_@)B@$/@!@N@!ae@"@4@"@4@!@N@Q_@Mj@g8}@#x@O;@v_ح@M:@쿱[W@Z@䎊r@R<64@|n.@l[W?@sߤ@|?@z@t9XbN@sg	l@p
(@o@mC\@m\@oiDg8@poiDg8@oVϫ@][@L~($x@C,zxl@84֡b@&@	ԕ*@0
@҉@~@=K^@7Kƨ@{~$@p
(@nO;@h@XU@NMj@JڹY@An.@8YJ@0'RT@-w1@&fffff@]ce@:)z@~$@y@̈́M:@2X                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        @G_o@G)^@F                                                                                                                                                                                                                                                                                                                                                                        @l"h	ԕ@cS@TZ@F
L/@FFs@8YJ@)Dg8~@U@ݗ@!-w2@.2@@iB@m\@o@"h	ԕ@x@lC@	k@fffff@$xG@ᰉ'@iDg8@L_@S&@E@V@RT`e@	ԕ+@*0U2a@r Ĝ@,@@R<6@-
@5?|@@@sh@@{m]@y	k~@uXy=@vz@t3@sg@sE@l>B[@`[6@Y|@W
=p@PH@J=p
@C$@A@>m\@;m]@9(@2ᰊ@+P{@'	k@%1@#	@5?|@0
)@+j@ᰉ@sP@rGE9@\(@+@	'RTa@]cf@\(@@Q@z@O
M@lD@㢜wk@]ce@qu!@1'@1'@>BZ@_o@JE@*0@֡af@n@;dZ@̘_@k~(@#@YJ@@,zxl@     @s@	k~@YJ@Xe@j~@g	l@l@:~ @(@0
@@^@I^@~"@Ov`@lD@@`A7L@.H@A7K@6@,<@6C@@Ov_@X@qu"@xF]@ ѷ@,zxl@~ߤ?@~($x@~BZc @}b@}!.H@r䎊q@pD@l!-w@e`A7L@\wkP@Xe+@XU@Stj~@P|@PH@NMj@N!R<@LI^5?@Gݗ+@Ao hی@:>B@1-@.zG@.}Vl@,"h	ԕ@cA @6C@Ov_@Mj@n@҉@=K@sPH@O;d@*0@䎊@'/W@
@As@o @_o @@r Ĝ@e@W>6z@Ϫ͟@a@O@а{@@ [7@$xG@tSM@ae@Q@Ov_خ@vȴ@Ov_@$/@K]d@}ڹZ@v+jg@sMjO@r ě@qA [@o4֡a@m8Y@kC,z@hۋq
@c	@W>6z@N;5X@H@C@@4m@3ߤ@.}Vl@C,zx@Xe,@sh@zG@Vu@($x@D@4֡a@.2@!-w@唯O
@$@Ϫ͞@]cA@š@s@^5?|@o@2W@u"@S@-V@,=@쿱[W@䎊r@/@tSM@ae@ěT@䎊r@%@1&@kP|@@@tj@+j@tj~@(@@zC\@wkP@{~$@}E@}Vl!@sMjO@nO;@irGE@dqj@ae@Y|@TE@TE@R䎊@P|@QN;5@M%@Ks@JL_@H@F-@?|hs@<n.@8Q@2-V@-B@(TɅ@&'@U=@u"@=K^@@L_@:)y@@
b}V@
eں@
1.@
iB@
ק&@
T`d@
#9@
\(@
~@
#w@
g	l@
S@
U=@
=K^@
@N@
q@
b}V@
{s@
x73@
pD@
o@
nO;@
m8Y@
k~($@
e@
]cA @
B74@
ATɅo@
?@
9XbM@
,<쿱@
 ěT@
_o@
zG@
N;6@
bM@

(@
L_@
~($x@
ݗ+@
      @$tS@
:S@lC@Y|@VϪ@u!@sPH@Z@`A7@*0U@ڹY@	k@x@C,@4֡a@\(@s@PH@hr@Vl!@
=p
@

M:@!-w2@+@Ʌoi@As@]cA@n@]cf@A@-V@KƧ@33333@9XbN@A@vȴ9X@b@A@Vϫ@wkP@+j@@R<6@$/@Vu@ ѷ@}H˒@x73@u\(@t!-w2@qu!S@poiDg8@kP{@l"h	ԕ@n.2@nO;@hۋq
@M%@E8YK@A7Kƨ@E@R<64@[$@\>@bM@kP{@iB@g8}H@e@dZ1@cZ@\?@E@#S&@,q@9~($@<쿱[@7rG@$TɆ@\(@#@eO@'/@	 ѷ@bM@$tS@_o@_o@ᰉ@*0@҈@oiDg@?@Q@PH@#x@˒:)@$/@ 4m9@o hی@o hی@ ѷX@SMj@(@C]@(@!-w@ۋq
@䎊qj@䎊qj@S@$@8YJ@ӎMj@͞%@@#w@<쿱@Q@IQ@O
M@!R<@}H˒@lC@f,<@_o@ZY@Z1'@^5?|@kC,z@qu!S@qu!S@m8Y@j~"@f1.@dZ1@ae@YJE@VϪ͟@O͞@M@Ks@H@B\(@:)y@;5Xy@;dZ@,1&y@Ov_@҉@p:@q@Fs@u%F
@
b}V@
m\@
!.H@
=b@
>B@
MjO@
u!S@
\@
䎊qj@
S@
o@
:@
n@
ȴ9Xb@
:@
:@
n@
@@
,zxl@
@
@
n@
n@
6@
j~#@
9XbN@
U=@
xF@
@
O;d@
S&@
҈@
L_@
n/@
@4n@
n.@
4m9@
}E@
}Vl!@
~\N<@
~$t@
}ڹZ@
|hr@
|#x@
|?@
zC\@
wkP@
pD@
kQ@
h	ԕ+@
d7@
a|Q@
aGz@
`҈p@
_;dZ@
_;dZ@
\>@
Sa@O@
LcA \@
Dg8}@
=p
=@
:)_@
:)y@
6z@
5?|h@
333333@
2W@
1-@
0{@
-
qv@
+U=@
'/V@
!-w1@
qu!@
*0@
Vu@
+I@	!R@	fffff@	ߤ?@	/w@	+@	@	̘_@	ěS@	j~#@	)@	H@	$xG@	'@	n.3@	vȴ9@	,=@	Xe,@	bM@	M:@	=p
@	+I@	%2@	hr Ĝ@	e`A7L@	bM@	c	@	b}Vm@	bC,@	b}Vm@	b}Vm@	a'R@	`u!@	_o@	,<쿱@	%zxl"h@	䎊r@	qi@		'RTa@	1&x@	oiDg@	?@	o hی@($x@@j~@\@8}H@%1@e+@e+@ѷX@@Õ$@5Xy@'0@-V@6z@@TɅ@@'@?@`A@,=@ߤ@@4J@ݗ+@@4n@wkP@vȴ9X@sMjO@p:~ @eڹ@[q@O
M;@GzH@D*0@<j~#@7rG@49XbN@12W@/{J#:@,zxl"@,>B[@,q@,<쿱@,1&y@+a@@+a@@+jf@*͞&@)lD@+jf@.zG@&IQ@C,zx@*0U2@
qiC@&I@{J#9@@$t@H˒@\N<@($x@\N<@H˒@?@-
@{m@:~ @҈p;@ٳ|@Ʌoi@`A7@H@͞%@@쿱[@ߤ@B@<쿱@a@@jf@I^@^@?@h	ԕ@-V@@@@$tS@Xe,@O;d@+j@+j@Xe,@ᰉ@Z@ԕ*@{lC@bM@Y>BZ@R䎊@Ov_ح@L@Gy@F
L/@D2W@0'RT@.1@/Vϫ@1&x@/r@.H@+a@@'-@!-w1@_o@L_@N;6@
ڹY@_o@u%F
@:S@@m\@ڹZ@!.H@@Q@A@ޞ@"`B@ӎMj@&@s@W'@ɺ^5?}@#9@Ƨ@͞%@)^	@)^	@ɺ^5?}@s@
L/@?@C@s@D@т@N;5@jOv@]cA@n@ɺ^5?}@)^@ [7@A@H@I^@tSM@'RT`@ߤ@@@@zG@sP@'/W@p:@%2@u%F
@{J#9@x73@qA [@p
=q@q@oiDg8@nt@nt@gfA@bC,@^@\(\@XU@SMj@N_o @J#9@Gy@Dg8}@B&IR@@6@<쿱[@6C-@.H@',@ 	k@,<@Fs@\(@qi@
M:@
M:@@Fs@o hی@$tS@"`@A [@7@Ϫ͞@2W@)@ߤ@'RT@B@1&y@lD@
=p@ěT@9@h	ԕ@䎊r@Q@}H@=K^@e+a@n@\(@'/@I^5@xF]d@tSMj@glC@a@N@[$@P`A7@Ov_ح@Np:~@Np:~@MjOv@L@Ks@@6@8)@1o@0{@1[W>6@/{J#:@+I^@)^@"`A@䎊r@%@PH@L_@Q@      @\N<@~$@ȴ9X@E@oiDg8@\@C]@Ov`@ۋq
@ߤ?@/w@څݘ@2a|@҈p:@_p@䎊@As@jOv@̘_@ʌL_@@]cf@]cf@74@C@n@n@@A@/V@rG@w1@wk@-
@ěT@@|?@sE@poiDg8@p@p:~ @f1.@aGz@\>@V8YJ@Q@O;dZ@P|@QX@JD@;/V@73@5'0      @ߤ@@_o@@@@ᰉ@L_@Z@R<6@@@O;d@@u      @!.I@MjO@s@C\@g	@@Gz@حV@ߤ?@حU@JE@ٳ|@y=c@Ϫ͞@`d@N;5@ɺ^5?}@*0@쿱[@}H@3@o@ ě@1&y@.H@	@U=@	@1&@6C@hr @n/@{J#9@F]c@I^5@hۋq@xl"h	@m\@iᰉ'@bC,@bM@be+@Y+@Rp:@O
M;@N;5X@N;5X@JD@D*0@B@<Z@9XbM@7KƧ@3|@12W@)lD@$xF@Ov_خ@$tS@R<6@҉@\(@
@	'RTa@eO@ݗ+@$/@n/@JM@@.H@-
@c	@o@ڹY@Ϫ͟@fA@Ʌoi@T`d@*0U@ʌL_@)^@b@z@9XbN@{@2X@0
@^@zxl"h@[@_F@N;6@@+I@u%F
@IQ@|#x@z>B@y	k~@r ě@nc	@m(@kC]@hۋq
@h>BZc@g8}H@g@e@ffffff@fA@f1.@e`A7L@e`A7L@a|Q@]/w@Zc	@W@W
=p@VϪ͟@V8YJ@UfA@UϪ͞@Rm@P{@O
M;@L@Gy@@4m@>6z@=K]@8Q@3ߤ@/v@,zxl"@*0
@(TɅ@'/V@'/V@'/V@%zxl"h@#S&@vȴ9@u"@u%@O;d@zG@u@
M:@
O;dZ@@u%F@{J#9@˒:)@PH@(@ȴ9X@@ ě@-V@c	@(@Q@ۋq
@A [@ᰉ'R@ce@ڹY@+@y=c@@Ϫ͞@fA@,<@&@Ϫ͞@̘_@E84@\(@C@H˒:@BZc @64@~@S&@^5?|@XbM@YJ@)@}H@KƧ@}Vl@Xy=@'0@֡a@ᰊ@U=@RT`e@ae@=K^@O
M@o @1&x@I^5@yrGE8@yrGE8@xF@t!-w2@o-V@mhr!@kQ@kP{@kC]@irGE@fA@ae@]ce@\N;@[6@[q@Zc	@Y|@Y+@W>6z@UϪ͞@UfA@S@Q@OAs@C@333333@.}Vl@,zxl"@,<쿱@+a@@+jf@*͞&@)lD@)lD@)@)lD@+I^@*0U2a|@*d7@(Xy=@'RT`e@(@'-@&'@ -
@!-w1@	@@@sh@Fs@$tT@q@1&x@K]d@Fs@+I@JM@%2@@u%F
@@4n@ IQ@ IQ@ IQ@      @ hr@ #x@ hr@ PH@ xl"h
@ F@ _ح@ C@ u!@ ҈p;@ cA @ ٳ|@ |@ p:~@ D@ K]c@ 
L/@ \N@ &IR@ H˒:@ n.@ rG@ 2W@ Vϫ@ 2X@ zG@ }Vl@ H@ }Vl@ w1@ >B[@ jf@ d7@ lD@ y@ $xG@ x@ ?@ n.3@ -w1@ Ov_خ@ u"@ 1&@ vȴ@ 0
)@ O;d@ O;d@ $tS@ @ Ov_@ n@ bM@ ߤ?@ @ @ 	 @ ԕ*@ 'RTa@ eO@ #@ YJ@ Q@ _o@ %2@ F]c@      @ |Q@ y"`@ v!.I@ sMjO@ s@ r ě@ p
=q@ m\@ de@ \]ce@ [W>6z@ VϪ͟@ Vl!-@ V8YJ@ Vt@ Vt@ TE@ T`d@ Sa@O@ SZ@ L_@ GzH@ F]cf@ E@ Dg8}@ D2W@ D2W@ Eo i@ DS@ =v@ 9Y}@ 7rG@ 73@ 9#w@ 73@ 5'0@ 3ߤ@ 2W@ /O
M@ /{J#:@ /Vϫ@ /{J#:@ ,>B[@ ,1&y@ )@ *0U2a|@ +U=@ ,1&y@ ,q@ +I^@ *0
@ %u@ !ae@  ěT@ vȴ9@ IQ@ kP|@ +j@ O
M@ -
q@ Vu@ ݗ+@ YJ@ Q@ ?@ Q@ S&@ tj?	k~?\(?Y|?D?Y|?D?#?Q?e?ᰉ'R?ۋq?As??ěS?\(?6?6?n?[W>?H˒:?vȴ9X?v?Z?n.?n.?n.?n.?A?n.?Y}?Xe?rG?4m?}Vl?rG?}Vl?g	l?q?1&y?6z?1&y?>B[?U=?>B[?͞&????-
?U=?wkP?O;d?tj~?ݗ+???b}V?|??y=b?xF]d?u%F
L?jfB?cA [?`d8?^5?|?[W>6z?XbM?O
M;?KƧ?M:?I^5?}?F
L/?C,zxl?A [7?9D?9XbM?5?|h?2a|Q?/v?.H?*0
?%1?#wk? ěT?sh?rGE9??)^?I^5??K]d?1&x?	 ѷ?'/?
M:?
(??xF]?
L/{?	 ѷ?
=p
?xF]?'/?	ԕ*?	ԕ*?Vu?
qu"??I^5???
(?
M:??xF]?҈?Fs?S&??!.H?s?C\?hr!?C,z?>BZc?ᰉ'?䎊qj?ڹY?b}?حU?fA?As?͞%?˒:)z?ɅoiD?o i?a@N?74?H˒:?Z?^5?|?E?'?zxl"h?S?L/{J?,?'?&?-                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                @@A@N@@A_p@@A@N@@ArGE@@A+@@A_p@@A+@@A@@A@@A@@A#w@@A&x@@A*0U2a@@A&x@@A*0U2a@@AGz@@AQ@@ADg8~@@AGz@@ATɅo@@AD@@B#9@@B:)y@@BC\@@BT`d@@BZc@@B^5?|@@Bh	ԕ@@BnO@@BqiC@@Bxl"h
@@B~"@@B\(@@BL_@@BL_@@BL_@@Bp:@@BS&@@B\(@@Bᰊ@@BS&@@BS&@@B͞&@@C'/@@CPH@@CPH@@C,zxl@@Cn.3@@D"h	ԕ@@DI^5?@@DM:@@D*1@@D*0@@E[@@Esg@@E!.@@F@@JT`d@@M@@R{m@@TL_@@Tzxl"@@U@@Zxl"h
@@j䎊q@@x     @@2X@@?@@\N<@@u%F@@&@@64@@[@@p:~@@@N@@j~@@*0@@jOv@@L_@@Q@@_F@@#w@@@@e@@3@@W'@@\(@@@@Ëq@@Ϫ͞@@ǐ@@u%@@Ov_@@
qu@@o@@,=@@؃n@@hr @@I^5@@a@N@@C]@@7@@K]@@ݑhr!@@߃{J#:@@JL@@)_@@G{@@jf@@a@@@1&y@@Z@@`A7L@@Vu@@'@@ hۋ@@H˒:@@v_ح@@?@@vȴ9@@@@@H@@{@@䎊@@m@@"`B@@C%@@{J#9@@@@tj@@]ce@@?@@>B[@@e@@E@@u@@(@@IQ@@$/@@=K@@8Y@@!R<@@}Vl@@}Vl@@$t@@,<@@Q@@ߤ?@@Mj@@;dZ@@;dZ@@>6z@@E84@@E84@@KƧ@@v_ح@@{J#:@@sPH@@	@@阮&@@o @@-
@@)@@ѷX@@C@@#w@@#w@@ [7@@4J@@Gz@@N;5@@TɅo@@u!S@@k~(@@x@@~($@@u@@X@@^5?}@@^5?}@@D@@_o@@ԕ*@@0U2a|@@kP|@@>B@@	@@:)z@@m]@@Ƨ@@$@@g@@lC@@lC@@@@n.@@J@@!-w2@@PH@@?@@C,zx@@Z1@@wkP@@?@@u"@@:@@!.H@@Q@@2a|@@F
L0@@ce@@m\@@sg@@ce@@fA@@Vl!@@Vl!@@B@@IQ@@O;dZ@@`A7L@@ڹZ@@!R@@O
@@sh@@cA @@@@@@@@@@@@@@cA @@oiDg@@1.@@u@@t@@?@@ ѷY@@u@@vȴ9X@@O;@@'@@Fs@@qi@@qi@@qi@@s@@l!-@@l!-@@IQ@@,<@@'@@ȴ9X@@C-@@ߤ?@@ߤ?@@2X@@,<@@}Vl@@z@@y@@͞@@u@@u%@@xF@@9XbN@@Z@@zxl"h@@1@@v@@@@@@@@Ϫ͞@@?@@ ѷY@@
L/@@!.@@1.@@($x@@4K@@4K@@(@@%@@F
L0@@[@@Ʌoi@@m8@@"h	ԕ@@S@@<쿱@@2W@@9XbN@@2W@@?@@VϪ@@?@@I^5?@@Fs@@Z1@@]ce@@9XbN@@(\@@L_@@ݗ+k@@
=p@@A                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  @ASMj@AcA \@ASMj@APH@AC,zx@A<쿱@Atj@AQ@Aߤ@AMj@AS@A6@Aa@O@A҈@A$@AA [@A$@AJ@Aߤ@@Aߤ@@A(\@AFs@AwkP@A_@Ao h@AzG@Aj~#@Aj~#@A~($x@AS@Azxl"@A@AɅoi@AZ@A
:@A
'0@A
%F
L@A
<64@A
S&@A
fA@A
jOv@A
m\@A
sg@A
zxl"h@A
}H@A
M:@A
hr!@A
=K@A
!R@A
!R@A
M:@A
!R@A
v@A
=K@A
@A
U=@A
n/@A
Ϫ͞@A
(@A
C\@A_o @A@A;5X@AiB@Az@A%@AT@Am\@AA@Aߤ?@A
=p@A,@A>6z@A	@AkP@A3@A䎊r@A$xG@Ahۋq@A4m@A4m@A`A7@A@@A)^@Ap:@AF@A`A7@A	k@A&x@A=b@A[W>6@Ab}@A7Kƨ@A@A'R@A|@A"`@A.H@AI^5@AOv`@A䎊@A0U2a|@A@4n@AJL@AT`d@Au%F
@AL_@AS&@AS&@Ap:@Ap:@A\(@AS&@A0
@A}Vm@AsP@Ac	@A&@A33333@A9@A]cA@AQ@Aa@O@A
=p@Aݗ+k@A$@A<쿱@AtSM@AzG@Aq@AzG@A?@A@A>@A[@AL_@AO
@AU=@A@A(@At@A_o @A4K@A@A.2@A\N<@A%@A&I@A
M;@A\(@A4m@A3@A6@A>BZc@A˒:*@A@ATɅ@AD@A	k~@A7KƧ@A[W>6@Ao hی@Ao@AR<6@An.@A@A0U2a|@A@4n@A=p
@AJL@AM@AW'@AqiC@AL_@A0
@A@AsP@A҉@AnP@AnP@AC,z@AC,z@A33333@AF]c@A]cA@AU=@AZ@Aݗ+k@A%2@AlC@AA [@A@A\N@A1&y@AL_@A/{J#@A]ce@Ao h@A*1@A3@AO
M@AZ@Ae@A2a|@AF
L0@AF
L0@AO;dZ@Ace@Av@Ab@A
L/@A@A!R<@AH@A_ح@AIQ@A}Vl@Aߤ?@At@A1@A!.I@A@AKƧ@AiDg8@A[W>@A[W>@A[W>@Ao @A@A+j@A @A 6@A }H@A *0@A 1&x@A A7K@A NU@A U2a|@A Q@A NU@A H@A 73@A NU@A Q@A eO@A r Ĝ@A |@A YJ@A 'RT@A -
@A @A @A )^@A C@A {@A! ѷ@A!@A!#w@A!=b@A!Gz@A!Q@A!TɅo@A!^@A!hr @A!u!S@A!R<6@A!'RTa@A!B@A!@A!y@A!Y}@A"I^5@A"#9@A"C\@A"qiC@A"ݘ@A"ᰊ@A"}Vm@A"`A@A#'/@A#)^	@A#33333@A#9@A#W>6z@A#~$@A#Q@A#eO@A#S@A#҈@A$n.@A$xF@A$2W@A$SMj@A$q@A$#@A$3@A$7@A$?@A$@A$*0@A$>B[@A$JM@A%[@A%M:@A%ݗ@A%O
@A%-V@A%b@A&zG@A&?@A&5?|@A&?@A&Ov_خ@A&IQ@A&+J@A&IQ@A&qi@A&$t@A&,<@A&6z@A&2X@A&&I@A&+@A&1@A&"@A&"@A'@A''/W@A'@A'@A'+j@A(@A(U2a|@A(r Ĝ@A(-
@A('RT@A(tj@A(U@A)	k~@A)7KƧ@A)+@A)	k~@A)_p@A)&x@A)+@A)+@A)+@A)rGE@A)@A)A [@A)JE@A)XbM@A)x@A)o@A)'RTa@A)(@A).H@A*GE85@A*W'@A*Q_@A*JL@A*M@A*M@A*Q_@A*^5?|@A*^5?|@A*Zc@A*W'@A*W'@A*a|Q@A*nO@A*ݘ@A*S&@A*͞&@A*,<@A*͞&@A*͞&@A*`A@A*C,@A+,zxl@A+g	l@A+eO@A+*0U2@A+C]@A,1&y@A,@A,%1@A,2W@A,/{J#@A,j~#@A,_@A,j~#@A,#x@A,>B[@A,!-w@A-+a@A-qu"@A-Q@A-jOv@A-(@A-5Xy>@A-+a@A-F
L0@A-`A7L@A-m\@A-zxl"h@A-jOv@A-S&@A-\@A-m\@A-m\@A-!R@A-1@A-cA @A-S@A-(@A-E@A.4K@A.!R<@A.($x@A.L/{J@A.YJ@A.iB@A.}Vl@A.@A.Fs@A.ߤ?@A.t@A.҈p;@A.쿱[W@A.!.I@A/Ft@A/Xe@A/$tS@A/KƧ@A/KƧ@A/KƧ@A/E84@A/E84@A/>6z@A/O
M@A/O
M@A/RT`e@A/RT`e@A/Xe,@A/\(@A/v_ح@A/?@A/o @A/@A/@A/@A/Vϫ@A/䎊r@A/+j@A0	ԕ+@A0	ԕ+@A0bM@A0@A0@A0bM@A06@A0}H@A0 ě@A0$xG@A0*0@A0A7K@A0bM@A0y=c@A0
(@A0F@A0`A7@A0`A7@A0C@A0{@A0$tT@A1@A1	k~@A1@A1 [7@A1:S@A17KƧ@A17KƧ@A14J@A1=b@A1=b@A1A [@A1JE@A1Q@A1TɅo@A1b}@A1R<6@A1R<6@A1'RTa@A1'RTa@A1B@A1|@A1'R@A1'R@A1@A1|@A1^5?}@A1@A1D@A1y@A1ᰉ'@A1Y}@A2@A2Ov`@A2)y@A2:)y@A2Q_@A2h	ԕ@A2S&@A2ᰊ@A2ᰊ@A20
@A2>B@A2}Vm@A2͞&@A2 ѷ@A2c	@A274@A3u%@A3u%@A3҉@A3s@A3'/@A3s@A3&@A36z@A3=K^@A3@N@A3C%@A3J#9@A3J#9@A3S@A3W>6z@A3W>6z@A3Z@A3]cA@A3dZ@A3g	l@A3n.3@A3~$@A3tj~@A3{J#9@A3@A3$@A3U=@A3q@A36@A3E@A3Z@A3a@O@A3|@A3
=p@A3
=p@A3C]@A3g@A3@A4n.@A4!-w2@A4,<@A4?@A4Fs@A4]ce@A4`d@A4`d@A4`d@A4j~#@A4g8}@A4VϪ@A4]ce@A4]ce@A4]ce@A4VϪ@A4]ce@A4]ce@A4g8}@A4zG@A4zG@A4zxl"@A4zxl"@A4쿱[@A4j~@A47@A47@A4Ʌoi@A4Z@A4>B[@A4@A4JM@A4e@A5o i@A5o i@A5u@A5V@A5qu"@A5!.H@A5(@A55Xy>@A5Vl!@A5Vl!@A5S&@A5`A7L@A5m\@A5ce@A5fA@A5jOv@A5w1@A5}H@A5!R@A5O
@A5hr!@A5U=@A5Ϫ͞@A5b@A58YK@A5b@A5
qv@A5S@A5(@A6_o @A6@A6Ov_@A6?@A6H@A6YJ@A6vȴ9X@A6Fs@A6-@A66z@A6}Vl@A6}Vl@A62X@A6Q@A6'@A6Q@A6Q@A6m\@A6x@A7$tS@A7+I@A74֡a@A7E84@A7Xe,@A7b}V@A7Xe,@A7Xe,@A7lC@A7&@A7	@A7O;d@A7@A7kP@A7-V@A7	k@A7	k@A7?@A7͞@A7͞@A7/V@A73@A7r@A7vȴ9@A7vȴ9@A7fA@A8	ԕ+@A8 ě@A8'RT`@A8*0@A8*0@A8-
q@A873@A8K]c@A8K]c@A8[6@A8u!@A8YJ@A8YJ@A8'RT@A8'RT@A8tj@A8-
@A8-
@A8tj@A8@A8
=q@A8TɅ@A8)^@A8D@A8҈p@A8{@A8\)@A8{@A8{@A9+@A9 ѷ@A9$/@A9	k~@A9+@A9#w@A9*0U2a@A9-w1@A9:S@A9TɅo@A9ae@A9e+a@A9e+a@A9b}@A9@A9l@A9@A9Y}@A:@A:3@A::)y@A:Q_@A:JL@A:JL@A:=p
@A::)y@A:-V@A:)y@A:d7@A:kP|@A:kP|@A:u%F
@A:L_@A: ě@A:sP@A:䎊q@A:G{@A: ѷ@A:䎊q@A:c	@A:G{@A:m@A:m\@A;C,z@A;,zxl@A;=K^@A;C%@A;C%@A;@N@A;J#9@A;MjO@A;P{@A;qu!@A;xF]@A;Q@A;q@A;:)z@A;$@A;U=@A;U=@A;S@A;m]@A;Ƨ@A;
=p@A;a@@A;%2@A;s@A;C]@A;C]@A;A [@A;$@A;s@A<J@A<ߤ@@A<(\@A<<쿱@A<PH@A<VϪ@A<`d@A<~($x@A<tSM@A<o h@A<qj@A<#@A<_@A<zxl"@A<?@A<j~@A<*0@A</@A<@A<@A<!-w@A<hr@A<D@A<!-w@A<>@A=o i@A=Q@A=(@A=?|h@A=IQ@A=`A7L@A=m\@A=M:@A==K@A=Xy=@A=sh@A=-V@A=H˒@A=H˒@A=H˒@A=\(@A=8Y@A=\(@A=\(@A=\(@A=H˒@A=H˒@A=8Y@A=8YK@A>_o @A>.2@A>?@A>BZc @A>H@A>z@A>@A>-@A>6z@A>2X@A>2X@A>2X@A>Q@A>}Vl@A>&I@A>t@A>+@A>]cf@A>]cf@A>1@A>x@A>@A?
=p@A?,@A?,@A?1@A?b}V@A?iDg8@A?{J#:@A?&@A?ݗ+@A?͞@A?/V@A?vȴ9@A?@A?fA@A?fA@A?fA@A?Vϫ@A?#@A@@A@
qu@A@bM@A@*0U@A@
qu@A@*0U@A@*0U@A@@A@6@A@ ě@A@$xG@A@4m9      @A@4m9@A@73@A@:~ @A@>BZc@A@NU@A@NU@A@[6@A@l"h	@A@y=c@A@n@A@u!@A@@A@@A@d8@A@9Xb@A@{@A@{@A@TɅ@A@p:@A@@AA$/@AA@N@AA@AA*0U2a@AA=b@AAXbM@AAo hی@AAu!S@AAb}      @AAo hی@AArGE8@AAo hی@AArGE8@AA7Kƨ@AA7Kƨ@AA@AAo@AA'RTa@AA'RTa@AA(@AA'R      @AAR@AA@AA>BZ@AAR@ABs@AB	 @AB&IR@AB-V@AB3@AB:)y@AB6C@AB:)y@AB6C@AB=p
@AB@4n@ABGE85@ABd7@AB~"@ABݘ@ABS&@ABS&@AB>B@AB>B@AB ě@AB@AB͞&@AB@AB@AB͞&@AB`A@AB`A@ABڹY@AB ѷ@ABfB@ABG{@AB䎊q@AB74@ACnP@ACPH@AC,zxl@AC=K^@AC9@AC=K^@ACJ#9@ACW>6z@ACW>6z@ACZ@ACdZ@ACn.3@ACtj~@ACqu!@AC{J#9@AC~$@AC@ACQ@ACeO@ACߤ@ACMj@ACS@AC~($@ACZ@ACa@O@ACa@O@AC@AC5Xy@AC@ACa@@ACa@@ACQ@AClC@ACC]@AC$@ACg@AC҈@ACQ@ACQ@ACQ@ACݗ+k@ACݗ+k@AC҈@AC҈@AC%2@AC$@ACs@ADn.@ADJ@ADL_@AD!-w2@AD@AD@AD(\@AD64@ADFs@ADM:@AD]ce@AD`d@ADj~#@ADq@ADq@AD~($x@AD#@ADqj@ADN;@ADN;@ADS@AD쿱[@ADTɆ@AD3@AD[W?@AD@ADZ@AD/@AD@AD/@AEo i@AEQ@AE%F
L@AE(@AE/w@AE2a|@AE5Xy>@AE<64@AE/w@AE?|h@AEL_@AES&@AEL_@AE\@AEfA@AEm\@AEsg@AEp
=@AEzxl"h@AEݗ@AEڹZ@AEݗ@AE!R@AE!R@AEhr!@AE!R@AEO
@AE+j@AE%@AEv@AE@AEXy=@AE1@AEsh@AE@AE@AEn/@AEH˒@AE\(@AEϪ͞@AE@AE?@AE@AE@AE?@AE
qv@AES@AEᰉ@AEᰉ@AE,=@AE!.@AEڹ@AF ѷY@AFt@AFt@AF_o @AF
(@AF4K@AF4K@AFzG@AFzG@AFOv_@AFOv_@AF+jg@AF8YJ@AF;5X@AF;5X@AFH@AFE@AFH@AFE@AFH@AFL/{J@AFR<6@AFOv_خ@AFOv_خ@AFOv_خ@AFOv_خ@AFR<6@AFVu@AFVu@AFVu@AF_ح@AFl!-@AFl!-@AFz@AF}Vl@AFIQ@AFqi@AFFs@AFT@AFT@AF}Vl@AF&I@AFt@AF҈p;@AFߤ?@AFߤ?@AF]cf@AFߤ?@AFMj@AG hۋ@AG
=p@AG
=p@AG)^@AG@AGXe@AG!-w1@AG,@AG$tS@AG'/W@AG$tS@AG+I@AG1@AGE84@AGKƧ@AGsPH@AG	@AG&@AG{J#:@AG{J#:@AG{J#:@AG&@AGO;d@AG@AG	@AG&@AG	@AG	@AG	@AGO;d@AGkP@AG	@AG@AG$tS@AG&@AGzH@AGzH@AG/V@AGo @AGo @AGK]d@AGfA@AG@@AG@@AGrG@AG@@AGVϫ@AG-@AG-@AG䎊r@AG+j@AG+j@AG+j@AGrGE9@AG#@AH     @AG#@AGrGE9@AG#@AHF]d@AH	ԕ+@AHbM@AH*0@AH'RT`@AH*0@AH*0@AH-
q@AH>BZc@AHNU@AHA7K@AHQ@AH_F@AHbM@AHhۋq@AHy=c@AH'RT@AHIQ@AH
(@AH@@AH@@AH@@AHp:@AHF@AHD@AHD@AHۋq
@AHۋq
@AHe+@AHC@AHD@AH@AH4֡b@AH\)@AH	k@AHPH@AI ѷ@AI@AI	k~@AIrGE@AI@AI@N@AI+@AI+@AI@N@AI_p@AI [7@AI&x@AI-w1@AI-w1@AI*0U2a@AI4J@AI4J@AI0
)@AI:S@AI:S@AI=b@AIGz@AI=b@AIGz@AIN;5@AIQ@AI[W>6@AIae@AIe+a@AIk~(@AIk~(@AIo hی@AI|Q@AIb}@AI~($@AI'RTa@AIB@AIn.@AIB@AIB@AIB@AI|@AI|@AIX@AIX@AI^5?}@AID@AIo@AIy@AI_o@AIN;6@AI_o@AI_o@AI_o@AI_o@AIiB@AI>BZ@AI>BZ@AIR@AIe@AIR@AIs@AIY}@AJu%F@AI.H@AI.H@AJu%F@AJu%F@AJ	 @AJI^5@AJs@AJs@AJ@AJs@AJ@AJs@AJ@AJ䎊@AJ䎊@AJ#9@AJ#9@AJ#9@AJ)y@AJ-V@AJ3@AJ=p
@AJC\@AJW'@AJZc@AJd7@AJ^5?|@AJa|Q@AJa|Q@AJh	ԕ@AJu%F
@AJ{m@AJ~"@AJxl"h
@AJ~"@AJ~"@AJݘ@AJ@4@AJ\(@AJS&@AJwkQ@AJL/{@AJ ě@AJg	@AJ}Vm@AJY@AJn@AJn@AJn@AJY@AJn@AJn@AJ@AJ@AJ)_@AJ)_@AJW@AJ͞&@AJW@AJW@AJ͞&@AJ͞&@AJ`A@AJ,<@AJ`A@AJ͞&@AJ,<@AJG{@AJG{@AJC,@AJfB@AJ䎊q@AJ ѷ@AJ ѷ@AJ䎊q@AJC,@AJm@AJD@AJm@AJ74@AKS&@AKS&@AKC,z@AK"`B@AK&@AK6z@AK6z@AK=K^@AK9@AKC%@AKMjO@AK]cA@AKdZ@AKdZ@AKg	l@AKn.3@AK{J#9@AK{J#9@AK{J#9@AK@AK@AKeO@AKq@AK$@AKA@AKߤ@AKwk@AKS@AK*0U2@AK*0U2@AKm]@AK~($@AKZ@AKƧ@AK5Xy@AK5Xy@AK|@AK|@AKݗ+k@AKQ@AK
=p@AKa@@AK
=p@AK|@AKQ@AKQ@AKQ@AKݗ+k@AKݗ+k@AKݗ+k@AKQ@AKݗ+k@AK҈@AK
=p@AK
=p@AKQ@AKݗ+k@AKݗ+k@AKݗ+k@AK҈@AKQ@AK%2@AK%2@AKlC@AKlC@AKC]@AK$@ALJ@ALxF@ALxF@AL@AL@ALߤ@@ALL_@AL%1@AL(\@AL(\@AL(\@AL64@AL9XbN@AL9XbN@AL<쿱@ALC,zx@ALC,zx@ALFs@ALM:@ALM:@ALSMj@ALZ1@ALm8@ALtSM@ALq@ALq@ALm8@ALtSM@ALtSM@ALtSM                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                @r@r     @r@r#33333@r(     @r,@r0     @r1@r333333@r,@r&fffff@r#33333@r0     @r333333@r,@r,@r333333@r333333@r1@r333333@r4@r333333@r      @r&fffff@r+33333@r&fffff@r+33333@r,@r1@r+33333@r+33333@r.fffff@r(     @rfffff@r!@r      @r      @r$@r$@r(     @r&fffff@r@r@r!@r@rfffff@r     @q@q@r33333@r@r     @r      @q33333@qfffff@q@q     @q@q~fffff@q<@q33333@qfffff@q      @p     @ovfffff@m@kfffff@k)@k33333@jfffff@j33333@j33333@jfffff@j@jL@i@h@gC33333@f`     @e@e陙@e     @e@f	@ffffff@f@f@f33333@f@efffff@e@efffff@e33333@el@e\@eFfffff@e<@e<@e<@e)@e33333@efffff@e33333@d33333@d33333@dٙ@dfffff@dfffff@dfffff@dfffff@d@d33333@d@d     @d33333@dfffff@dfffff@dy@dp     @dffffff@dc33333@di@dl@dy@d33333@d|@d|@dp     @dc33333@dS33333@d9@d)@d      @c@c33333@c     @c陙@c33333@c@c@c@c@c     @cl@cc33333@c`     @cP     @cC33333@c333333@c      @bٙ@b     @b@b     @b     @b33333@b     @bl@bS33333@b@     @a@afffff@a@a@a@afffff@ap     @a`     @aY@aL@aI@aI@aL@aC33333@a,@a@a33333@`@`fffff@`     @`fffff@`ٙ@`ə@`33333@`@`@_`     @^y@]33333@]fffff@^@]fffff@]l@]L@]Ffffff@]      @]@]33333@\fffff@\     @\fffff@\S33333@\@[@[fffff@[`     @[9@Z@Zfffff@Zfffff@Zٙ@Z@Zfffff@Zs33333@Zy@Zl@Zl@Z     @Z`     @ZY@ZS33333@ZFfffff@Z,@Z@Zfffff@Y33333@Yfffff@Y@Y@Y     @Y@Yfffff@Yl@YL@Y@Xfffff@X     @Xfffff@X     @XY@X33333@W     @W@Wfffff@W@W@W@W@W@W     @Wl@Wl@W@     @W,@W@W@W      @W,@WFfffff@Wl@WY@V@V@US33333@Tffffff@S33333@S      @R33333@Rl@R@     @Rffffff@R@     @R&fffff@R@R33333@R@R      @Q33333@Rfffff@Q@Qfffff@Q     @Q     @Qٙ@Q     @Q@R      @R,@RFfffff@Rl@Rl@Rffffff@R`     @RL@R9@R,@R33333@R&fffff@R@Rfffff@Rfffff@R      @R                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @@33333@@ffffff@@@@@@      @@@@&fffff@@L@@s33333@@@@@@@@s33333@@Y@@Y@@@     @@&fffff@@Y@@333333@@&fffff@@333333@@&fffff@@      @?@?fffff@?fffff@?fffff@?fffff@?@?@?@?@?ffffff@?333333@?@?      @?      @?      @>33333@>     @>@>@>ffffff@>     @>     @>L@>ffffff@>L@>ffffff@>ffffff@>ffffff@>ffffff@>@>L@>L@>333333@=fffff@>L@>      @=fffff@=fffff@=33333@=@=ffffff@=     @=333333@=333333@<fffff@<fffff@<fffff@<     @<     @<ffffff@<@;fffff@;@;@;     @;      @:     @:ffffff@:ffffff@:33333@:@:L@:ffffff@:L@:333333@:@9@:      @933333@9     @9ffffff@9     @9L@9@9@9@9      @8fffff@833333@833333@8@8@833333@8333333@8L@8     @8@8L@8@8L@8@8333333@8L@8@7@7@733333@7     @7L@7333333@7     @7@7      @6@6@6     @6ffffff@6333333@6@6ffffff@6@5fffff@5@5     @5ffffff@5L@5     @5333333@5@5@5      @5333333@5@4fffff@433333@4ffffff@4L@4      @3@3fffff@3     @3L@3L@3@3@3      @2@2L@2     @2L@2     @2L@2     @2333333@133333@1@2      @1fffff@1@1     @1@1@133333@1L@1ffffff@1ffffff@1ffffff@1L@1@1ffffff@1L@1@1L@0fffff@0@0fffff@0@033333@0@0@0@0@0fffff@0fffff@0@0     @0L@0ffffff@0ffffff@0333333@0L@0@0333333@0333333@0333333@0      @0      @0      @/@/333333@.@/      @/      @/333333@/ffffff@.@/      @/      @.333333@.@.@.ffffff@.      @-ffffff@-ffffff@-@.      @.      @-ffffff@-333333@-333333@-ffffff@-ffffff@-333333@-ffffff@-333333@-      @-      @-@-@-333333@-333333@-ffffff@-333333@-333333@-ffffff@-333333@-ffffff@-333333@,@,ffffff@-      @-      @,ffffff@,@,@,ffffff@,333333@,ffffff@,      @,ffffff@,      @,ffffff@,ffffff@,ffffff@,      @,      @+@+@,      @+@+333333@+      @+ffffff@+ffffff@+ffffff@+      @+333333@+      @*@*@*@*@*@*@*ffffff@*ffffff@*@*      @*      @*      @)@*      @)@)@)@)@)@)@)ffffff@*333333@)@)ffffff@)ffffff@)ffffff@(@(@)      @(@)333333@(@(@(ffffff@)      @)      @(@(@)333333@(@(ffffff@(333333@(@)      @(@(      @(@(      @'@'333333@'@'@'ffffff@'ffffff@'333333@'      @&@&@&@&@&@&@'      @'333333@&@'      @'      @'333333@'333333@&@&@'      @'333333@'      @&@&@&ffffff@&@&@&333333@&ffffff@&@&@&ffffff@&@&@&@&@&@&@&@&@&@&333333@&@&@&@&@&333333@&      @&      @&ffffff@&      @%333333@%@&ffffff@&      @%@&      @&333333@&ffffff@&333333@&      @&      @%ffffff@%@&@%ffffff@&      @&@&333333@&      @&      @%@%@%@&ffffff@&@&      @%333333@%@&@&333333@&      @%ffffff@%ffffff@&      @&ffffff@&      @&      @%@%@&333333@%@%@%@&      @%@%@&      @&      @%@%@%@&      @&333333@&333333@%@&333333@&@&      @&      @&ffffff@&@&333333@&333333@&      @&      @&      @&333333@&333333@&      @&@&@&333333@&@&333333@&      @&333333@&ffffff@&ffffff@&@&ffffff@&ffffff@&@&ffffff@&333333@&@&@&@&@&@&@&@&@&ffffff@&333333@&@'      @'      @'333333@'@'      @&@'      @'333333@&ffffff@'      @'@&@'ffffff@'      @'333333@&@'      @&@'      @'      @'333333@'ffffff@'ffffff@'333333@'      @'333333@'ffffff@(      @'333333@'333333@'ffffff@'@'@'@'333333@'@'ffffff@'@'333333@(      @'ffffff@'@'333333@'@'@(      @'@'@'@'@'@'@'@'@(      @'@'@(      @'@(333333@(333333@'@(      @'@(ffffff@'@(      @(333333@(@(@(@(ffffff@(@(@(@)333333@)333333@(333333@(      @)      @)      @(@)      @)      @)ffffff@)      @)      @)333333@)333333@(@)      @)333333@)      @(@)333333@)333333@)333333@)@)@)333333@(@)ffffff@)@)ffffff@*      @)@)ffffff@)@)@)333333@)ffffff@)@*ffffff@)@)@*      @*@)@)@)@*      @*      @*333333@*      @*333333@*@*333333@*ffffff@*@+333333@+      @)@*      @+333333@*333333@*@+ffffff@*@*333333@*@+@+333333@+@+333333@+      @+333333@+333333@+ffffff@+@+@+@+@,333333@,333333@+333333@+@,ffffff@+@+@,      @,333333@,333333@+@,      @,@,333333@,ffffff@,@,@,@,@,@,@,@,@,@-      @-333333@,333333@,333333@-      @-      @,@-ffffff@-@-333333@,@,@-333333@-ffffff@-ffffff@.      @.      @-333333@-ffffff@-@-@-@-@.      @-@-@.@.      @.@.      @-@.      @.      @/333333@.333333@.      @.@/      @/      @.@/      @/333333@.@/      @.@.@/333333@/ffffff@.@/      @/ffffff@/333333@/@/ffffff@/ffffff@0      @0@0L@/@/@0L@0     @0     @033333@033333@0@0@0@0@033333@0@033333@0@1      @1      @1@1333333@1ffffff@1333333@1333333@1@0fffff@1@1333333@1333333@1333333@1@1fffff@1     @1@1@1@1@1ffffff@133333@1fffff@1fffff@1@1fffff@1fffff@2      @2333333@1fffff@2@2      @2@2L@2     @2ffffff@2L@2ffffff@2L@2@2333333@2L@2fffff@2@2L@2@3      @2@3      @3      @3@3      @3L@3ffffff@3333333@2fffff@3ffffff@3@333333@3ffffff@333333@3     @3@3@333333@3fffff@4@4      @4@4      @4      @4333333@4ffffff@4@4@4@4fffff@4@4@4fffff@5      @433333@5      @4@4fffff@4fffff@433333@4fffff@5@5      @5@5@5333333@5@6333333@6@6      @6@6L@6     @6333333@6L@6333333@6     @6ffffff@6L@6333333@6     @633333@6     @6ffffff@6@6fffff@6@7      @7333333@7ffffff@7     @733333@7     @7@7fffff@7fffff@8@8@8      @8@8@8333333@8@9      @8ffffff@8ffffff@8@833333@8@8     @8     @8@833333@8           @8@8     @8@9L@9333333@9      @8@8fffff@9@9L@9ffffff@9L@9333333@9333333@9L@933333@9@9@9fffff@:      @:     @:ffffff@:@;      @:@;      @;ffffff@;333333@;           @;@;L@;     @;333333@:@;333333@;@;@;     @;@;@;      @;33333@<@<L@<@<L@<@<@<     @<@<fffff@=      @=@=333333@<@=@=L@=333333@=@=     @>      @>      @>@=fffff@>      @>L@>333333@>     @>L@>     @>ffffff@>L@>@>     @>ffffff@>@>33333@>@>ffffff@?@?ffffff@?@?@?@?L@?33333@?@?33333@?33333@?ffffff@?@?fffff@@      @?@?fffff@@@@&fffff@@@?fffff@@      @@L@@L@@@     @@@@     @@Y@@Y@@@     @@Y@@ffffff@@@@@@@@@@     @@@@ffffff@@33333@@33333@@s33333@@@@     @@fffff@@s33333@@     @@@@     @@@@     @@     @@     @@fffff@@ٙ@@fffff@A@A@A@A&fffff@A@     @A@     @AY@AL@AY@Affffff@A     @A@A@A     @A@     @Afffff@A33333@A@Afffff@A@A33333@Afffff@B&fffff@B&fffff@B333333@B@B@B333333@BL@BY@B@     @BL@Bs33333@Bffffff@B@     @B     @B@Bfffff@B@B     @B@B     @B@B33333@B33333@Bfffff@B33333@B@B@B@B@C@B@Bfffff@Bfffff@B33333@Bfffff@C333333@C&fffff@C@C      @C@C&fffff@C333333@C&fffff@C333333@CL@C@     @CL@C333333@CL@CL@CY@C@     @CY@C@Cs33333@C     @C@C@Cffffff@C@C     @Cfffff@C33333@C     @C33333@C     @Cٙ@C     @C@Cfffff@C33333@Cٙ@Cfffff@Cfffff@Cٙ@D@D@Cٙ@C     @Cfffff@Cfffff@D      @D&fffff@D&fffff@D&fffff@Dffffff@DY@D@     @Ds33333@Dfffff@Dfffff@D     @D33333@D@D     @Dfffff@D33333@Dfffff@D@D33333@E&fffff@E@E      @E@D33333@EL@E333333@EY@EL@E333333@E@E@E333333@EL@EY@Es33333@E@Eٙ@Eٙ@F@Eٙ@F      @Eٙ@Efffff@Efffff@E@Eٙ@F      @Eٙ@E@Eٙ@Eٙ@F      @Efffff@E33333@F      @E33333@E@F333333@F333333@F333333@F333333@F333333@FY@Fs33333@FL@F@     @Fffffff@F33333@F     @Fffffff@Fs33333@F     @F@F@F@Fs33333@FY@F@F@F     @F@Ffffff@Ffffff@Fٙ@Ffffff@Ffffff@G      @G@G@G333333@G@     @G@     @GL@GL@Gffffff@G33333@G@G     @G33333@G33333@G@Gٙ@Gٙ@G@Gٙ@G@G33333@H      @H      @Gٙ@G33333@H      @Gfffff@Gfffff@H&fffff@H333333@H@H@H@H&fffff@HL@HL@H@H&fffff@HY@Hffffff@HL@Hfffff@H@     @Hs33333@HY@H     @H@Hffffff@HL@H     @H@H@H@H@H     @H@H     @H33333@H@Hٙ@H33333@H     @Hٙ@I      @I333333@H33333@IY@I@     @IY@Iffffff@I     @I333333@I@I     @Iffffff@IL@IY@I     @I@I@Ifffff@I@Iffffff@I@I33333@Ifffff@Ifffff@Ifffff@Iٙ@Iٙ@I33333@I@Ifffff@Iٙ@Iٙ@I33333@Ifffff@J      @J@J      @J@J@J      @J@J&fffff@I33333@J@J@     @J@J333333@J      @J@Jffffff@Js33333@Jffffff@Js33333@J@J33333@J@J     @J@Jfffff@J33333@J33333@J     @J     @J33333@J@J@Jfffff@K      @Jfffff@K@K@K&fffff@K@K@     @KL@K333333@KY@KY@K&fffff@KY@KY@KL@K     @KL@Kffffff@Kffffff@K     @K@K333333@Ks33333@K@K     @Kffffff@K     @K     @Ks33333@Ks33333@K@K@Kfffff@K@K     @KY@K     @K@Kfffff@Kffffff@K     @K@K@Kfffff@K     @K33333@Kfffff@Kٙ@L      @Kٙ@L      @L@L@     @LY@L@     @LY@Lffffff@Ls33333@LY@L     @Lfffff@Ls33333@Lfffff@L@L33333@L@L@L33333@Lٙ@M@L@L@M@M&fffff@L33333@L33333@M333333@ML@M@     @M@     @Ms33333@MY@ML@M&fffff@M&fffff@Ms33333@M@     @M&fffff@M&fffff@M@Ms33333@Mffffff@M@     @M333333@Mffffff@M@     @L33333@Mffffff@Mfffff@MY@ML@MY@MY@M&fffff@M333333@M&fffff@M      @M     @M@M     @Mfffff@M@M     @M     @M@M33333@Mٙ@M@M@M33333@N      @N@M33333@Mfffff@N@N@     @N@N&fffff@N333333@N@     @N@     @N@     @Nffffff@NL@N@NL@NL@Ns33333@N                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ?Vt?m?̋C%?5?|h??O;dZ? ěT?|hr?r ě?"`B?lC?M?l?lC?+?\(\?׮zG?7KƧ?(\)?ȴ9Xb?5?|h?(\)?ȴ9Xb?lC?333333?dZ1?
=p?$/??|hs?&x?S?Vt?ěS?+J?\(?j~#??9XbM?I^5?}?9XbM??bM?\(\?I^5?;dZ?S?vȴ?tj?5?|h?m?xF?zG?^5?|?^5?|?$/?9XbN?bM?݁$/?l?bM?5?|h??j~"?^5?|?ΗO;d?I^5?}?ɺ^5?|?ffffff?/w?+?tj~?l?\(?Q?lD?l?7KƧ?vȴ9X?/v?j~"?"`A?1&?"`B?bM?bM?+J?XbM?XbM?tj~?KƧ?
=p
?\(?j~#??|hs?+?zG{?-V? ě?-V?Q?hr Ĝ? ě? ě?bM?`A7L?hr Ĝ?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?Q?5?|h?Q?5?|h?5?|h?;dZ?vȴ9X?Q?Q?;dZ? ěT?vȴ9X?Q?Q?5?|h?-V?5?|h?-V?Q?-V?Q?Q?;dZ?;dZ?Q?5?|h?-V?5?|h?Q?/v?5?|h?5?|h?Q?;dZ?;dZ?Q?Q?;dZ?5?|h?5?|h?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?5?|h?Q?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?vȴ9X? ěT?vȴ9X? ěT?Q?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ? ěT?vȴ9X?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?vȴ9X? ěT?;dZ?Q?;dZ?;dZ?;dZ?;dZ?bM?
=p?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ? ěT? ěT?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?Q?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ?vȴ9X?Q?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?bM?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ? ěT?;dZ?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?bM?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ? ěT? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?;dZ? ěT? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X? ěT? ěT?vȴ9X?;dZ?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X? ěT? ěT?vȴ9X?vȴ9X? ěT?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?bM?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X? ěT? ěT?vȴ9X? ěT?bM? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?vȴ9X?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?Q?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?;dZ?Q?5?|h?Q?Q?;dZ?Q?;dZ?Q?Q?Q?;dZ?Q?Q?;dZ?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?;dZ?Q?5?|h?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?Q?Q?;dZ?Q?5?|h?Q?Q?5?|h?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?5?|h?;dZ?Q?5?|h?Q?Q?5?|h?5?|h?Q?Q?;dZ?Q?Q?Q?Q?;dZ?;dZ?5?|h?5?|h?Q?Q?Q?5?|h?Q?Q?5?|h?Q?5?|h?Q?Q?5?|h?5?|h?5?|h?5?|h?Q?Q?5?|h?5?|h?Q?Q?Q?;dZ?;dZ?Q?5?|h?Q?5?|h?Q?5?|h?Q?5?|h?Q?Q?Q?Q?Q?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?Q?Q?5?|h?Q?Q?5?|h?5?|h?5?|h?Q?Q?Q?5?|h?5?|h?5?|h?Q?Q?Q?Q?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?Q?Q?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?Q?-V?Q?5?|h?5?|h?Q?Q?Q?5?|h?Q?Q?-V?-V?5?|h?Q?5?|h?-V?Q?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?Q?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?-V?-V?5?|h?5?|h?5?|h?5?|h?-V?/v?Q?Q?5?|h?5?|h?5?|h?5?|h?-V?-V?-V?5?|h?5?|h?5?|h?-V?-V?5?|h?-V?/v?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?/v?5?|h?-V?5?|h?5?|h?-V?5?|h?5?|h?5?|h?/v?-V?/v?/v?-V?-V?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?-V?5?|h?5?|h?5?|h?-V?5?|h?5?|h?-V?-V?-V?-V?/v?-V?/v?/v?/v?/v?/v?-V?-V?5?|h?5?|h?-V?-V?5?|h?5?|h?5?|h?-V?-V?/v?/v?5?|h?5?|h?5?|h?/v?-V?5?|h?5?|h?5?|h?-V?5?|h?/v?5?|h?5?|h?/v?5?|h?5?|h?5?|h?/v?5?|h?-V?5?|h?5?|h?/v?vȴ9X?`A7L?lD?lD?lD?`A7L?`A7L?`A7L?
=p?&x?-V?l?Q?tj~?+?;dZ?vȴ9X? ě?hr Ĝ?nO;?-V?&x? ěT?vȴ9X?lD?-V?&x?Q?/v?5?|h?5?|h?-V?-V?5?|h?-V?5?|h?5?|h?/v?/v?/v?-V?/v?/v?-V?-V?/v?5?|h?-V?/v?/v?-V?-V?5?|h?5?|h?5?|h?-V?/v?-V?-V?1&y?/v?-V?5?|h?/v?/v?-V?/v?/v?/v?/v?/v?/v?-V?5?|h?/v?/v?-V?-V?-V?1&y?/v?/v?1&y?/v?/v?/v?/v?5?|h?-V?/v?-V?/v?/v?/v?/v?/v?/v?-V?-V?5?|h?-V?-V?-V?/v?/v?-V?/v?1&y?/v?1&y?/v?-V?-V?-V?/v?1&y?/v?/v?/v?/v?5?|h?-V?-V?/v?1&y?/v?-V?1&y?-V?/v?/v?-V?-V?1&y?1&y?/v?/v?/v?5?|h?/v?1&y?/v?/v?/v?-V?-V?/v?/v?1&y?/v?1&y?1&y?-V?1&y?/v?-V?1&y?1&y?1&y?-V?-V?/v?/v?/v?1&y?/v?/v?/v?/v?/v?1&y?1&y?/v?/v?/v?5?|h?/v?1&y?/v?5?|h?/v?/v?1&y?/v?1&y?/v?1&y?/v?/v?1&y?-V?1&y?(\)?1&y?1&y?1&y?/v?1&y?1&y?1&y?/v?1&y?-V?-V?/v?/v?1&y?1&y?/v?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?/v?1&y?1&y?/v?1&y?/v?1&y?1&y?/v?/v?1&y?/v?/v?1&y?/v?/v?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?/v?/v?1&y?1&y?1&y?1&y?1&y?/v?/v?1&y?1&y?1&y?/v?/v?(\)?1&y?1&y?1&y?1&y?1&y?(\)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                @@d@A@fffff@yFfffff@vX     @snfffff@r.fffff@s     @p33333@r@o@j33333@f@dL@d@dfffff@bP     @`)@^@     @Z     @Yl@X@XFfffff@Vfffff@Sl@Q     @Pٙ@P@OY@L@I@G@E@Dٙ@C33333@B333333@A@@@     @>L@;L@9      @8      @7ffffff@6      @4@3@1@0ffffff@.333333@,333333@*@)ffffff@'@&ffffff@%      @#@!@!ffffff@ ffffff@333333@@      @ffffff@333333@      @@      @@@      @@      @ffffff@@333333@	@      @ffffff@@      @ffffff@@ @       ?ffffff??333333??      ?ffffff???333333?񙙙?񙙙?      ???陙?陙?陙?ffffff?ffffff?ffffff?333333?333333?333333?333333?333333?333333?      ?      ?      ?      ?ٙ?ٙ?ٙ?ٙ?ٙ?ٙ?ٙ?333333?333333?333333?333333?333333?333333?333333?ə?ə?ə?ə?ə?ə?ə?ə?ə????????????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	P9                                      1                                       *BCl*3?