CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20120522   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P15    CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:48.122978Z    ORIGINAL_HEADER      sCTD,20250210CCHSIOWB
#Renamed 'CTDFLUOR_TSG' to 'CTDFLUOR_ALT_1' with units 'MG/M^3'
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2018-11-29. CTD data from cruise 18DD20120522, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20120522. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2012-12/index.php. 
#
# The information in this file for the cruise 2012-12 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-0072.ctd
#
# Start of originator file comment header
#
#*2018/11/29 14:22:51.16
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2012/06/01 08:02:46.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 2006
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : C44EDC1F
#    NUMBER OF CHANNELS  : 9
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            2.3            2006.7
#       2 Temperature:CTD               deg_C_(ITS90)   1.9166         6.6907
#       3 Salinity:CTD                  PSS-78          32.6639        34.5892
#       4 Sigma-t:CTD                   kg/m^3          25.6458        27.6748
#       5 Transmissivity:CTD            %/m             61.4           67.9
#       6 Oxygen:Dissolved:CTD:Volume   ml/l            0.41           7.23
#       7 Oxygen:Dissolved:CTD:Mass     µmol/kg         17.9           314.7
#       8 Fluorescence:CTD:Seapoint     mg/m^3          0.24E-01       0.74
#       9 Fluorescence:CTD:Wetlabs      mg/m^3          0.102          1.096
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        6  F       ' '     1
#       6  -99   ' '        7  F       ' '     2
#       7  -99   ' '        6  F       ' '     1
#       8  -99   ' '        8  F       ' '     3
#       9  -99   ' '        8  F       ' '     3
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2012-12
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P24
#    EVENT NUMBER        : 72
#    LATITUDE            :  49  50.17000 N  ! (deg min)
#    LONGITUDE           : 142  40.04000 W  ! (deg min)
#    WATER DEPTH         : 3989
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    CTDEDIT was used to remove surface records and records corrupted by shed
#	wakes; salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Transmissivity, Fluorescence and PAR data are nominal and unedited except
#	that some records were removed in editing temperature and salinity.
#
#    For details on how the transmissivity calibration parameters were calculated
#	see the document Transmissivity_Calculation.pdf.
#
#    The Oxygen:Dissolved:CTD calibration was done using the method described in 
#	the Sea-Bird Application Note #64-2 (Sea-Bird_64-2_Jun2012.pdf).
#
#    The Oxygen:Dissolved:CTD data are considered, roughly, to be:
#	±0.1 ml/l from 0 to 125 dbar.
#	±0.06 ml/l from 125 to 500 dbar.
#	±0.04 ml/l from 500 to 2000 dbar.
#	±0.02 ml/l below 2000 dbar.
#
#    For details on the processing see processing report: 2012-12-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5-- --6--- --7-- ---8--- ---9---
#!Pressu Temperat Salinity Sigma-t: Trans Oxygen Oxyge Fluores Fluores
#!re:CTD ure:CTD  :CTD     CTD      missi :Disso n:Dis cence:  cence: 
#!                                  vity: lved:  solve CTD:    CTD:   
#!                                  CTD   CTD:   d:CTD Seapoin Wetlabs
#!                                        Volume :Mass t              
#!------ -------- -------- -------- ----- ------ ----- ------- -------
#*END OF HEADER
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @D         data_max      @D         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     >  .    pressure                	long_name         pressure   positive      down   units         decibar    data_min      @333333   data_max      @`        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      >  l   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d        p   temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?B   data_max      @ +)^	   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       >     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d           salinity                	long_name         salinity   units         PSS-78     data_min      @@Y   data_max      @AKlC   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      > 	p   salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d       H   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @'ffffff   data_max      @sVfffff   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        > W   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d       l   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?1&   data_max      @"`   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      >    CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d          PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       > l   PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d       3   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min      @M@        data_max      @Q         C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     > B   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d       h   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         (    cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( <   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min         data_max         C_format      %10d       d   latitude               	long_name         latitude   units         	degrees_N      data_min      @H   data_max      @H   C_format      %9.4f          h   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      `U\R.   data_max      `U\R.   C_format      %9.4f          l   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d        p   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d        t@D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @D      @333333@333333@      @ffffff@@      @       @"      @$      @(ffffff@*      @,      @.      @0      @1      @2@2fffff@4      @5      @6      @7      @8      @9      @:333333@;      @<@=      @>      @?      @@      @@     @A      @A     @A33333@B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @I33333@K@K     @L      @L     @M@M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W9@W     @W     @X      @X9@X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_fffff@_33333@`@`@     @``     @`     @`     @`     @`     @a      @a@a@     @a`     @a     @a     @a     @afffff@bfffff@b      @b@     @b`     @b     @b@bfffff@b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @ec33333@evfffff@e     @e     @e     @f      @f      @f<@fc33333@f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pQ@p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p񙙙@pfffff@q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q@qfffff@qfffff@q     @q     @q     @q     @r      @r@r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v@v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z񙙙@{      @{fffff@{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @w33333@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0@733333@@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @@33333@     @     @     @     @      @     @33333@33333@      @(     @0     @8     @@     @H     @P     @X@`     @g33333@p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @@@33333@(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @Nfffff@X     @`     @h     @p     @x     @     @     @fffff@@     @     @     @     @     @     @     @33333@@     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @      @     @     @     @      @&fffff@0@8     @@     @H     @P     @X     @`@i@p     @x     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @ @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @U@`     @h     @p     @x     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @     @@@     @     @     @      @(     @0     @8     @@     @H     @Nfffff@X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @w@|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@fffff@     @     @     @     @     @     @     @      @@	33333@     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @33333@@     @     @     @     @     @     @     @     @     @     @     @     @י@     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @י@     @     @     @     @     @fffff@     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4fffff@8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @b@g@l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @@     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @W@\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @癙@33333@     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @Jfffff@Q33333@T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @ fffff@@     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8fffff@<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,fffff@0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @癙@     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@@     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          @ 'zH@ 'fA@ (@ (Xy=@ (>BZc@ (1&x@ )rGE@ )*0U2a@ )Q@ )ᰉ'@ )oiD@ )@ )oiD@ )^5?}@ *	 @ )@ )ԕ*@ +)^	@ )ᰉ'@ iDg8@ @Q@!-w@>BZ@6@     @kU=@be+@\(\@X*0@Stj~@Fs@4֡a@$xF@y=c@Mj@qi@@4n@!-w@O
@>@eS@ ѷX@)y@D@{m]@tm8@o@c9@Yb}@5!R@=K^@m8@~@(@iB@RnO@?˒:)@+P{@	@}H@K]c@e@@mB@M5Xy>@6+jg@JE@YJ@oiDg@&I@@{J#9@5Xy@2X@iB@;dZ@Y}@:~ @%1@s@v}Vl@PH@<#x@,C@(>BZc@&,<@U=@+j@U@@~($x@2W@l!-@䎊r@1&x@@4n@}p
=@u!.@u%F
L@h$xG@Zݘ@XU@XU@X@@ZY@Z,<@Z6C@R:)y@H@A@;dZ@71@:~@8YJ@>$t@>$t@O\(@["`B@eF
L0@l<쿱@lzxl"@vȴ9X@!.@a@O@Xe,@	k@E@R@%1@4!-w2@L_@\1&@p ě@y	k~@nP@-@^5?}@	 @@L_@+I@$@z^5?|@m(@lVϪ@kC,z@g-@["`B@C%2@'fA@%1@$7@"wkQ@!Gz@!R<6@cA @@
@2W@@#x@l"h	@1.@xF]@0U2a|@{J#9@}<64@yD@sg@c
=p@a@N@^쿱[W@Xy=c@B ѷ@+Q@S@@N@H@tj@>B[@d7@Xy=@e@Q@*0@YJ@S@t@/{J#@nP@˒:)@~BZc @iᰉ'@J#9@7KƧ@)ᰉ'@ 
qu@C%@g8}@"@(@:~ @eO@յsh@@#@eO@Q@q@kQ@XbM@8F]d@+U=@S@-
q@Q@hۋq@ ě@>BZ@
M;@I^5?@+I@@tj@}p
=@x}H@kC,z@b3@Y|@R<64@H˒:*@>BZc @1u!S@(\)@#S@ [6@1&@wkP@E@ݗ+@C,z@ʌL_@\(@PH@zG@@zxl"h@u%@}H˒@o hۋ@`	k@[q@T`d@KC%@BI^5@=E@3|@74@V@e+@L_@'/W@L_@#9@[W>@g	l@1.@R<6@u%F@ݗ+k@*0U@҈@S&@I^5@$tS@~"@z~@u\(@usg@u!R@l!-w@I@5Y|@u%F@ IQ@ߤ?@A@Fs@4֡a@x@,<@[@ԕ*1@@Q@H˒@ ě@P{@@@N@af@@_o @ԕ*@&IR@vC-@u'0@t3@s|@sg	l@q2W@nc	@gfA@]-V@VOv_@RnO@Q_p@P@PH@N+@J#9@E@Bu%F
@?˒:)@;m]@8F@64K@.t@(	ԕ+@$%1@u@6C@e+a@e+@bM@
=p@$/@@N@
jOv@:)z@p:@oiDg@\N@D@O
M@*0U2a@,@8}H@Dg8~@e@Q_@ڹY@=K^@m@/{J#@7KƧ@Ňݗ@n.@=b@3@Ov`@n.3@W>6z@*0@p:@!R<@'/@9Xb@@~\N<@yY}@u%F
L@sg@q2W@oiDg8@m(@i@g,@e`A7L@d7@dxF@bh	ԕ@aGz@`-
@^҈p;@\N;@VR<6@S*0U2@O͞@NVu@L~($x@J#9@FFs@B@BI^5@@C@?H˒:@<Q@:>B@8)@6C-@2W@/v@,zxl"@,q@,<쿱@+6z@)B@(@%@#S@!e@o@?@1'@y=c@sPH@R<6@@+@]cA@ ѷ@Vl!@ȴ9X@j~@l@q@1&y@ۋq
@eO@S&@M@҈p@ޞ@e+@hr @v_ح@̲@ԕ*@1&x@]cf@Q@n.@#x@^5?|@)@!R@[W>6@lD@r Ĝ@F
L0@M@'R@@N@-w1@-w1@-
@A7K@حV@حV@o@ ѷY@Y@+J@@u@_o @]cA@ݗ+@o hی@}b@z>B@wrG@w4m@vFs@q&x@l1&y@fL/{J@ao@^҈p;@]+j@[Q@Y@QR@LL_@H˒:*@HeO@HK]c@H@GK]d@GE84@F&I@CF]c@>BZc @<PH@:>B@9Y}@8Q@6Fs@3g@0
=q@.O;@.H@-
qv@,zxl"@*JL@($xG@'&@'&@'RT`e@&1.@#9@N;@,<@>BZ@|@@0
)@tj@O;d@Ov_@L_@a@O@
jOv@$/@\N@ 4m@@_ح@#@s@ᰉ'@C,@"`B@՛=K@Z@͞%@)^	@\N@3@tSM@O
M@o @O;dZ@$/@$/@sg@jfB@de@aGz@_;dZ@]/w@Xe+@U2a|@T`d@R䎊@PH@NT@M5Xy>@JL_@F]cf@C$@B&IR@ATɅo@?@>BZc @=<64@<n.@0 ě@(TɅ@#wk@+J@Mj@Vu@
O;dZ@@C%@K]d@ hۋq@!.H@Q@~$@s@>B@"`@Fs@JL@e+@u!@(\@p:~@m\@TɅo@v@)_@XbM@}H@3@>B[@-@S&@-
@!-w1@}H@ߤ@@PH@@O;d@O
M@Mj@ݗ+@@~\N<@|?@{lC@z>B@e@a|Q@`A7K@]ce@ZQ_@XD*@Vl!-@T*1@T*1@O͞@F]cf@C@>
(@=p
=@<Z@<j~#@7KƧ@1-@0 ě@.1@-
qv@'-@wkP@$/@:)y@u@!R<@
M:@
qu"@eO@ ѷX@
$t@
ڹZ@
hr@
~$@
-
@
\(@
@
빌~($@
Q@
Ov`@
7@
&@
N;5@
@
?@

(@
Q@
֡a@
[W>6@
B@
͞&@
@
\)@
Xy=@
'@
ěT@
,=@
C,zx@
$tS@
zG@
N;6@
L_@
#@
%2@
:S@
z@
s@
r{m@
l"h	ԕ@
d7@
_;dZ@
Z1'@
VϪ͟@
O͞@
Ks@
IoiD@
H˒:*@
Em\@
A7Kƨ@
=<64@
<n.@
9Y}@
7rG@
4J@
2W@
.H@
-w1@
,>B[@
+jf@
*͞&@
*d7@
(@
 -
@
҉@
N;6@
u@
	 @
@m\@rGE8@E@oiDg8@C@fffff@Gz@A7K@҈p;@(\@b}@Ϫ͟@*0U@+@ΤT@s@Q@@@~@Xe@g	l@B@d7@&@IQ@tSM@-
@S@$tS@@.H@yrGE8@y	k~@xl"h	@sPH@e`A7L@YJE@Vt@T,<@QR@Q_p@O͞@O͞@O
M;@M%@L@?@8)@4m8@2a|Q@-U=@)^@ ěT@tj~@o @I^5?@K]d@YJ@u%F
@rGE8@!-w2@
=q@4֡a@B@iB@+@Ϫ͟@T`d@:@/{J#@y@\N@\(@64@S&@sg@&x@1&y@x@tSM@wk@IQ@qu!@u%@sh@ݗ+@?@I^5@˒:)@}!.H@z@x-
@weں@v!.I@sE@m8Y@b}Vm@\N;@Q@F?@=<64@:)y@49XbN@3ߤ@3g	l@3g	l@3ߤ@/Vϫ@&L/{J@"h	ԕ@	@C,zx@e+a@$tS@Fs@҉@S&@S&@:S@n.@ IQ@
$t@
E@
l"h	@
+jg@
PH@
s@
@
iDg8@
C]@
8}H@
iB@
2a|@
@
E84@
7Kƨ@
sg@
w1@
TɅ@
wk@
IQ@
_o@
tj@
O;d@
+J@
4J@
K]d@
u%F
@
IQ@
{lC@
xl"h	@
weں@
r{m@
jg	@
iᰉ'@
hۋq
@
d%1@
\?@
PH@
IQ@
H@
Fs@
D2W@
D2W@
C@
C,zxl@
B74@
As@
?|hs@
=<64@
;/V@
:)y@
73@
3g	l@
2-V@
1&x@
-
qv@
%F
L0@
IQ@
*0U2@
bM@

qiC@
$/@
{J#9@
 4m9@	ڹZ@	lC@	Q@	Q@	m]@	xl"h
@	F]d@	(@	@	+a@	D*@	˒:)z@	7Kƨ@	쿱[@	^5?|@	}Vl@	$xG@		k@	}H@	e+a@	@N@	u@	ߤ?@	y=b@	h	ԕ+@	e+a@	cA [@	bC,@	`d8@	\>@	UfA@	QX@	Q@	O͞@	B74@	>6z@	:)y@	-B@	)*0U2a@	'RT`e@	!R<6@	S&@	tj@.H@?@F@!R@g@Dg8~@ⶮ}Vm@@4@e+@+@As@Ƨ@K]c@
L/@\N@C@Y}@C-@'0@W@jf@&@$xG@/@,=@-V@Ov_خ@-V@-V@O
M@Fs@ ѷ@n.@     @{s@yrGE8@zC\@{J#9@{m]@qA [@d%1@^iB@\]ce@Zc	@Vt@Vl!-@W
=p@R䎊@MjOv@KƧ@E@?|hs@=K]@:)y@8)@8}H@6E@/Vϫ@ ěT@S@vȴ@,<@vȴ@kP|@@@@+J@n@
qu"@
L/{@	7KƧ@1&x@Fs@nP@m\@!.H@
=q@	@6@ק&@Ϫ͞@,<@ӎMj@&@T`d@ѷX@N;5@|@p:~@s@K]c@[W>@C-@2W@U=@$xG@쿱[W@=K^@_F@zG@҉@:)y@)^@rGE9@o @'/@#@Fs@JM@@4m9@{J#9@v+jg@sPH@q@o@o@o@o-V@o hۋ@nt@mC\@m8Y@kC]@jOv`@iDg8~@h	ԕ+@e+a@a'R@N_o @F
L/@Dg8}@>ߤ?@*0
@(Xy=@'-@',@&@%1@	@qu!@R<6@sP@-
q@!R<@~($x@I^5?@~($x@$/@ hۋq@Vl!@>B@F]d@D@{m@:~ @@@
=q@c	@r Ĝ@|Q@
qu@Ft@]ce@Q_@D*@D*@@sPH@8YJ@̘_@@\(@j~#@}Vl@ߤ@}Vl@$xG@IQ@o@,=@kP|@@+J@sh@O
M@ݗ+k@@'/W@Mj@@҈@p:@@˒:)@xl"h	@weں@r{m@d%1@[$@VϪ͟@TɅoi@P{@DS@>ߤ?@?H˒:@=p
=@<j~#@9Y}@84֡b@6C-@5sg@3|@3ߤ@1-@0 ě@0 ě@.}Vl@)^@%1@$/@#
=p@ -
@IQ@u%@u%F@_o@+J@@N;6@qi@p:@n.@o hی@n.@˒:)@E@J#9@SMj@@4֡a@C]@唯O
@ٳ|@E@T`d@ѷX@т@`A7@+@*0U@ѷX@N;5@;dZ@ΤT@@@XbM@)@}H@Xe@C-@z@?|h@o@0
@n.3@1&@$tS@@N@o @M:@I^5?@C%@eO@$/@b}V@b}V@.H@}H˒@|PH@{lC@{lC@{J#9@zC\@y"`@y(@y	k~@x-
@w+@qiB@nc	@l"h	ԕ@kC,z@h>BZc@ceO@be+@aGz@`d8@`d8@`u!@`
qu@^҈p;@]+j@["`B@XbM@R<64@M5Xy>@K)^	@I@GzH@E84֡@C\N@C\N@B@>vȴ9X@9#w@4J@0'RT@-U=@*d7@vȴ9@U=@!-w1@-V@ߤ@@u%F@$tS@Z@@N@
@ ѷX@	k~@l"h	@eں@_ح@!R@Y|@SMj@PH@
=q@t@C\@C@x@䎊qj@
qu@ߤ?@ ѷY@JE@ק&@Ϫ͞@҈p:@;dZ@/{J#@ʌL_@W'@s@n@vȴ9X@p
=@쿱[@/V@4֡b@Xe@sg@g	l@U2a|@I^@TɅ@@/V@zxl"h@S&@䎊r@wkP@,<@@zG@$tT@O;dZ@ ѷ@oiDg@ݗ@tj@}ڹZ@y	k~@t!-w2@n.2@kC]@jOv`@h	ԕ+@f1.@dqj@bM@`A7K@^ ѷY@\N;@W>6z@QX@N;5X@M@L@K)^	@H@F]cf@Eo i@C@>vȴ9X@;A@9#w@1o@-V@,q@)*0U2a@ 'RT`@Q@0
)@Ov_@R<6@@*0U2@ݗ+k@:)y@@
=p
@p:@+I@tj@ ѷ@$/@Vl!@D@!-w@ᰉ'@lC@C,@ޞ@iB@ce@]ce@]ce@6@ҽ<64@;5X@͞%@5Xy>@@cA \@E84@K]@~@4m@'RT@Xy=@L/{J@/@S&@ߤ@@@@@R<6@L_@sP@)^@qu"@L/{@#@M:@~m\@xF@x-
@w+@tD@t#@l!-w@f1.@e+a@e+a@cA [@b@4@b@4@bM@`A7K@_حV@^@]/w@YJE@Rm@R<64@RT`d@Q_p@Ov_ح@L@F]cf@Fs@D*0@ATɅo@?H˒:@>BZc @=b@<n.@6z@.}Vl@(@%S@"h	ԕ@-V@u"@ߤ@@u%F@PH@+j@$tS@R<6@O
M@bM@_o@ ѷX@Vl!@"`@%F
L@䎊q@C\@r Ĝ@Z1@
qu@cA @]ce@+@Ϫ͟@2a|@ԕ*1@Z@҈p:@䎊@ѷX@т@R@т@т@
M;@@W'@ɅoiD@ɺ^5?}@E84@o i@Õ$@<64@C-@g	l@[W>6@ ě@2X@zxl"@͞&@lD@*0U2a@x@R<6@[6@'RT`@	@	@	@Q@Q@e+a@O
M@sP@nO@hr @ߤ?@'/@_o@YJ@ݗ@o h@o h@S&@Q@?@o h@@~m\@|Q@zC\@y(@xl"h	@u\(@s@p:~ @nt@iDg8~@gfA@fA@^҈p;@[W>6z@Y>BZ@YJE@W&@VϪ͟@W
=p@Vt@S@R<64@O;dZ@JD@G@@Eo i@C,zxl@?|hs@<64@6C-@2ᰊ@/r@.}Vl@.2X@.H@.}Vl@-U=@,zxl"@,zxl"@,q@+U=@*͞&@)y@'-@kP|@@N@hr @-
q@o @\(@~($x@M:@I^5@˒:)@b}V@~$@	k~@l"h	@73@73@F]d@!.I@SMj@MjO@s@A [@:~ @D@-V@Q@fA@+a@M@;dZ@>@ٳ|@m@_o @cA \@ɅoiD@@6@p
=@A@)_@Y}@XbM@}H@9XbN@o@'RT@Vϫ@v@2X@}Vl@H@
qv@U=@d7@TɅ@,@'@IQ@xF@-w1@wkP@PH@u@@M:@ڹY@eO@YJ@JM@@4n@˒:)@|#x@x-
@sg@qiB@o-V@nO;@lC@kC]@kC,z@iB@g8}H@e+a@bM@`d8@]ce@Y>BZ@XbM@VϪ͟@U=K@R䎊@Np:~@IQ@F-@C$@>ߤ?@<j~#@;/V@9~($@8Q@6}Vl@5'0@4֡a@2m\@0 ě@+jf@&IQ@vȴ9@qu!@u%F@@S&@o @
=p
@ ѷ@@$/@ H˒@ G{@ +@ @ @ \@ C@ C,z@ g	@ @ 7@ %1@ ⶮ}Vm@ Gz@ d8@ ޞ@ cA @ (\@ $@ $@ $@ ۋq@ $@ ۋq@ $@ c	@ "`B@ ڹY@ "`B@ W>6z@ +@ D*@ @ @ sPH@ >6z@ ֡af@ bM@ y=c@ حU@ D*@ @ bM@ @ sPH@ bM@ >6z@ l!-@ Ϫ͞@ 2a|@ 2a|@ ,<@ ҈p:@ ҈p:@ m@ &@ m@ ҽ<64@ m@ ҈p:@ R@ As@ ͞%@ ̘_@ ˒:)z@ @ g8}@ @ |hs@ p
=@ 3@ ᰊ@ &x@  ě@ O
M@ 2X@ zG@ w1@ zxl"@ >B[@ I^@ y@ y@ @ *0U2a@ *0U2a@ $xG@ RT`e@ '@ tSM@ o@ -w1@ 䎊r@ Ov_خ@ u"@ 0
)@ $/@ )^@ o @ (@ ҈@ 7KƧ@ n/@ Q@ tj@ F]c@ }H˒@ zG{@ z>B@ zC\@ s@ oiDg8@ m(@ jJL@ ix@ h>BZc@ dZ1@ ^@ ^iB@ ]cA @ ]cA @ ^ ѷY@ ]cA @ ^iB@ ["`B@ W@ WsPH@ XbM@ W@ W@ T`d@ M:@ H˒:*@ Eo i@ C\N@ Ca@N@ B74@ @4m@ >BZc @ ;A@ ;A@ 8}H@ /r@ +a@@ '-@ $xF@ #wk@ #S&@ !o@  	k@ 	@ %@ [@ ߤ@@ qu!@ tj@ $tS@ +J@ zG@ hr @ )^@ -
q@ 
M:@ u%F@ $/@ @ @ :S@  4m9?PH?{m?c	?C,z?x?rGE?>BZc?,<?`A7L?@4?u!?ۋq?E?`A7?cA \?74?n?)_?Q?rG?4m?E?'0?|?m\?g	l?O
M?͞&????vȴ9?=K^?,<?R<6?!R<?@4n?xF?tSMj?p:~ ?n.2?m\?m\?h	ԕ+?ceO?cA [?dZ1?`d8?^?]ce?[6?XbM?Q?S&?PH?Ov_ح?L_?H?E84֡?C\N?C,zxl?B?BZc?As?A7Kƨ?A7Kƨ?@4m??|hs?=b?=p
=?=b?;5Xy?9D?8}H?73?6z?4m8?/Vϫ?-w1?(?#wk?䎊r?u%?sh?sh??sP?sP?n?4J?'/W?Vu?ߤ??
(??I^5??xF]?'/?
L/{?
L/{?
L/{?
L/{?	 ѷ?_o?o h??      ?lC?"`?+jg?MjO?l?c	?(?(?hr!?c	?-V?C\?C]??>BZc?>BZc?fA?䎊qj?C,?Q_?حU??
=p?֡af?8YJ?҈p:?͞%?cA \?ȴ9Xb??j~#?Q?3?9XbN?g	l?-V?B                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     @@Y@@Ys@@Ys@@Ys@@Ys@@YY}@@YY}@@YY}@@YY}@@Y-@@Y-@@YY}@@Y-@@YY}@@Y-@@Y-@@Y-@@YY}@@Z	 @@Z3@@ZW'@@ZW'@@ZQ_@@ZnO@@ZqiC@@Z0
@@Zp:@@Zݘ@@Z~"@@Z@4@@Zp:@@ZL_@@ZL_@@Z\(@@Zvȴ@@ZwkQ@@ZL/{@@Zg	@@ZW@@[/V@@[{J#9@@[P{@@[@N@@[W>6z@@[]cA@@[tj~@@[jf@@[tj~@@[n.3@@[qu!@@[~$@@[{J#9@@[tj~@@[~$@@[P{@@[qu!@@[qu!@@[~$@@[@@[xF]@@[qu!@@[{J#9@@[ߤ@@[g	l@@[g	l@@[m]@@[
=p@@\I^5?@@\S@@\TɆ@@\*0@@\E@@][@@]O;dZ@@]}H@@]1@@]b@@^u@@^.2@@^R<6@@^}Vl@@^2X@@_@@_Xe@@_+I@@_!-w1@@_.H@@_sPH@@_@@`F]d@@`*0@@`-
@@`@@arGE@@aiB@@b@@b1'@@bM@@b ě@@bD@@c|@@cq@@cQ@@cA [@@dJ@@dQ@@dcA \@@d*0@@ece@@fp:~@@gݗ+@@hD*@@io@@k|@@m`A7L@@o/V@@qᰉ'@@uL_@@w-V@@x4֡b@@z#9@@zGE85@@{a@O@@U@@@@e+@@33333@@oiD@@!.@@~$@@iDg8@@-@@w1@@C]@@Q@@>@@;dZ@@C,z@@˕$@@|@@ϐ@@JE@@Z@@(@@ѷX@@$tT@@*0U2a@@ڶ}Vm@@V@@@@g	l@@eO@@:)z@@E@@a@@@5Xy@@tj@@1&@@L_@@
qv@@@@?@@l!-@@_o@@_F@@XbM@@@4n@@T`d@@a|Q@@S&@@䎊q@@C,@@D@@nP@@MjO@@:)z@@U=@@E@@빌~($@@lC@@C]@@lC@@lC@@A [@@A [@@s@@ߤ@@@L_@@L_@@L_@@tj@@@@@@!-w2@@%1@@!-w2@@(\@@(\@@tj@@@@ߤ@@@L_@@Q@@tj@@L_@@1&y@@1&y@@@@J@@J@@\N@@s@@$@@@@1&y@@s@@s@@\N@@s@@\N@@s@@\N@@\N@@n.@@n.@@n.@@J@@ߤ@@@ߤ@@@@@L_@@tj@@Q@@"h	ԕ@@!-w2@@Q@@Q@@Q@@Q@@%1@@<쿱@@PH@@]ce@@cA \@@]ce@@SMj@@PH@@Z1@@j~#@@C@@웥S@@TɆ@@1&@@첕@@?@@Ʌoi@@?@@u"@@2a|@@2a|@@IQ@@fA@@fA@@fA@@jOv@@M:@@=K@@sh@@H˒@@b@@S@@(@@C\@@_o @@
L/@@
L/@@t@@
(@@zG@@@@u@@s@@t@@@@eں@@_o@@b}V@@o@@4m@@@@$tS@@kP@@o @@@@F]d@@
qu@@:~ @@oiDg8@@u!@@n@@YJ@@
=q@@𭫟U@@4m@@p:@@4֡b@@@@#w@@*0U2a@@4J@@=b@@Dg8~@@^@@|Q@@'RTa@@@@o@@_o@@@@e@@-@@0U2a|@@W'@@u%F
@@L_@@@@<64@@sP@@s@@C%@@a@N@@Mj@@*0U2@@q@@@@E@@Z@@@@ݗ+k@@J@@ߤ@@@%1@@C,zx@@tSM@@Z@@Z@@+a@@B@@IQ@@`A7L@@\(@@?@@t@@+jg@@IQ@@&I@@@@v@@E84@@@@r@@H@@@@`A7@@&x@@=b@@rGE8@@o@@(@@iB@@s@@@4n@@kP|@@u%F
@@ᰊ@@ ě@@`A@@҉@@6z@@MjO@@Z@@a@N@@tj~@@Q@@eO@@wk@@a@O@@I^5?@@wkP@@@@[W?@@֡a@@D@@!.H@@fA@@zxl"h@@hr!@@sh@@?@@
qv@@!.@@@@p:~@@@@Q@@&I@@ȴ9X@@+@@Fs@@
=p@@;dZ@@b}V@@	@@vȴ9@@rG@A *0U@A 1&x@A A7K@A U2a|@A y=c@A TɅ@A {@AGz@A@AiB@Au%F@A#9@AW'@Aa|Q@A<64@A	@A&@A9@AJ#9@An.3@AE@A1&y@AQ@AI^5?@Aj~#@AC@ATɆ@A@Au@AjOv@A%@A@At@A8YJ@AFs@A}Vl@Ax@A
M;@A@A,@A,@A,@A'/W@A'/W@A1@A8}H@AAs@AU=@A{J#:@A͞@AK]d@A@@A	ԕ+@A ě@ANU@A-
@A{@AѷX@AC@A4֡b@A\)@A	-w1@A	ae@A	@A	n.@A	X@A	2W@A
@A
:)y@A
~"@A
S&@A
<64@A
<64@A
<64@A
n@A
)_@A
W@A
,<@A
74@A,zxl@A@N@AW>6z@Aa@N@A{J#9@A$@A6@Ag@An.@AJ@AJ@Aߤ@@A,<@AFs@APH@ASMj@AVϪ@Aj~#@A쿱[@Ahr@A>@A
:@A
o i@A
'0@A
[@A
*0@A
+a@A
<64@A
IQ@A
\@A
sh@A4K@A($x@AVu@A}Vl@A@AFs@A,<@Aȴ9X@Ax@Av@A8}H@AE84@AiDg8@A|hs@A[W>@A*0U@Al"h	@A9Xb@ATɅ@Ap:@A4֡b@A$tT@AA [@Ak~(@AoiD@A@A@An.@A^5?}@Ay@AD@AN;6@AiB@A>BZ@AR@AY}@AI^5@Ae+@A䎊@A䎊@A#9@A-V@A0U2a|@A=p
@Axl"h
@Aᰊ@A ě@AfB@Am\@A~@AI^@AS&@A'/@A"`B@AF]c@AS@AW>6z@A]cA@A]cA@Aa@N@AdZ@AxF]@AZ@A%2@Ag@A\N@A?@Ag8}@A~($x@AC@AS@A3@Azxl"@Aj~@AZ@A>@AV@A*0@AQ@A!.H@A/w@A<64@AB@AB@AO;dZ@A`A7L@A$/@Ahr!@A%@AXy=@A1@A@A$/@A1.@A;5X@AL/{J@AYJ@A_ح@AiB@AiB@AiB@A%@A2X@AA@A+@A+@A+@A+@A!.I@A@A
=p@A)^@A@A4֡a@AlC@A@A	k@A͞@Avȴ9@Ao @AحV@AF]d@A ě@A1&x@A4m9@A73@AD*@AXy=@AeO@An@Au%F@Au%F@A
=q@A@@A_p@A#w@A7KƧ@A[W>6@A7Kƨ@A(@A^5?}@AN;6@Ae@A@AlD@Au%F@A@A䎊@AM@A^5?|@AkP|@AL_@AwkQ@A}Vm@AsP@AfB@A~@Au%@A33333@AW>6z@Ag	l@AA@A@AC]@Aߤ@@A(\@AM:@AcA \@AzG@A~($x@AN;@Aj~@A/@AZ@AD@A:@A*0@Aqu"@A?|h@AIQ@AO;dZ@A\@Ace@AjOv@Aw1@A@Ab@A?@A(@AzG@A.2@A;5X@AYJ@A\N<@AiB@Az@Aaf@Am\@AA@AC-@A"@A
=p@A!-w1@A\(@Aeں@Ao@AO;d@AkP@A@A 	ԕ+@A }H@A 73@A U2a|@A ˒:*@A -
@A @A 
=q@A {@A 
(@A p:@A @A!_p@A![W>6@A!x@A!|Q@A!oiD@A!l@A!lD@A"&IR@A"&IR@A"-V@A"@4n@A"JL@A"W'@A"T`d@A"Zc@A"kP|@A"u%F
@A"S&@A"g	@A"<64@A"@A",<@A"c	@A#)^	@A#n.3@A#xF]@A#Q@A#Mj@A#Mj@A#q@A#a@O@A#
=p@A#%2@A#g@A$J@A$/{J#@A$?@A$PH@A$j~#@A$o h@A$?@A$S@A$1&@A$?@A$*0@A$֡a@A$hr@A%K]@A%Q@A%5Xy>@A%5Xy>@A%84֡@A%Vl!@A%ce@A%ce@A%ݗ@A%n/@A%n/@A%8Y@A%Ϫ͞@A%?@A%(@A%!.@A%C\@A%!.@A&_o @A&Ov_@A&?@A&Vu@A&+J@A&Q@A&+@A&1@A&"@A&Fs@A&"@A&"@A&Mj@A'
=p@A';dZ@A'E84@A'RT`e@A'Xe,@A'eں@A'o@A'y@A'|hs@A'y@A'3@A'K]d@A'o @A'+@A'fA@A'حV@A'@A'Vϫ@A(     @A(F]d@A(	ԕ+@A(
qu@A(6@A(*0@A(NU@A(u!@A(IQ@A(-
@A(TɅ@A(`A7@A(	k@A)	k~@A)@A)7KƧ@A)=b@A)A [@A)A [@A)A [@A)^@A)u!S@A)~($@A)o@A)'RTa@A)l@A)|@A)o@A)iB@A)iB@A)e@A)-@A*s@A*@4n@A*Q_@A*W'@A*a|Q@A*h	ԕ@A*kP|@A*kP|@A*kP|@A*nO@A*nO@A*xl"h
@A*p:@A*\(@A*ᰊ@A*vȴ@A*L/{@A*@A*>B@A*Y@A*`A@A*fB@A*74@A*m\@A+҉@A+'/@A+nP@A+s@A+C,z@A+"`B@A+	@A+"`B@A+"`B@A+&@A+,zxl@A+&@A+=K^@A+W>6z@A+~$@A+A@A+ߤ@A+A@A+U=@A+U=@A+wk@A+m]@A+Z@A+a@O@A+Ƨ@A+@A+|@A,n.@A,ߤ@@A,@A,@A,L_@A,!-w2@A,/{J#@A,Fs@A,M:@A,PH@A,VϪ@A,쿱[@A,@A,@A,*0@A,Ʌoi@A,֡a@A,JM@A-V@A-!.H@A-2a|@A-<64@A-IQ@A-Vl!@A-ce@A-ݗ@A-O
@A-hr!@A-O
@A-U=@A-@A-@A-@A-?@A-S@A-oiDg@A.
L/@A.@A.u@A.($x@A.8YJ@A.;5X@A.?@A.L/{J@A.c	@A._ح@A._ح@A.c	@A._ح@A.qi@A.2X@A.Q@A.Q@A.&I@A.҈p;@A.]cf@A.]cf@A.1@A/ hۋ@A/,@A/>6z@A/>6z@A/As@A/H˒:@A/b}V@A/sPH@A/y@A/{J#:@A/4m@A/	@A/[W>@A/o @A/K]d@A/@A/حV@A/@A/@A0     @A0'RT`@A01&x@A04m9@A04m9@A0:~ @A073@A0>BZc@A0:~ @A0A7K@A0Q@A0[6@A0_F@A0bM@A0eO@A0l"h	@A0u!@A0n@A0YJ@A04m@A0`A7@A0$tT@A1rGE@A1@N@A1+@A1_p@A1_p@A1 [7@A1&x@A1*0U2a@A1*0U2a@A14J@A17KƧ@A1Gz@A1hr @A1@A1o@A1@A1'R@A1ԕ*@A1ᰉ'@A1R@A1-@A1lD@A2u%F@A2u%F@A2u%F@A2u%F@A21'@A2#9@A23@A2:)y@A2=p
@A2GE85@A2Zc@A2nO@A2xl"h
@A2~"@A2~"@A2{m@A2ݘ@A2ݘ@A2p:@A2p:@A2\(@A2\(@A2ᰊ@A2wkQ@A2wkQ@A2vȴ@A2 ě@A2)_@A3҉@A3C,z@A3	@A3=K^@A3@A3Q@A3Q@A3Q@A3q@A3eO@A3U=@A3S@A3Z@A3a@O@A3|@A3
=p@A3Q@A3ݗ+k@A3ݗ+k@A3s@A41&y@A4ߤ@@A4tj@A4!-w2@A4/{J#@A42W@A464@A4<쿱@A4<쿱@A49XbN@A4Fs@A4]ce@A4tSM@A4tSM@A4zG@A4~($x@A4#@A4#@A4#@A4?@A4#@A4N;@A4O
M@A4#x@A4*0@A4u"@A4e@A4>@A5K]@A5*0@A5[@A5!.H@A5/w@A5?|h@A5B@A5IQ@A5IQ@A5L_@A5O;dZ@A5\@A5`A7L@A5`A7L@A5fA@A5fA@A5m\@A5ݗ@A5+j@A5-V@A51@A58Y@A5oiDg@A6 ѷY@A6_o @A6_o @A6@A6;5X@A6E@A6BZc @A6E@A6H@A6Vu@A6R<6@A6\N<@A6_ح@A6fffff@A6iB@A6p:~@A6vȴ9X@A6z@A6}Vl@A6$t@A6O;@A6Fs@A6O;@A6@A66z@A62X@A62X@A6Q@A6m\@A6m\@A6ȴ9X@A6҈p;@A61@A6"@A6!.I@A6"@A7 hۋ@A7@A7Ft@A7v@A7!-w1@A7+I@A74֡a@A7RT`e@A7lC@A7v_ح@A7v_ح@A74m@A7{J#:@A7{J#:@A7&@A74m@A7y@A74m@A7&@A7	@A7	k@A7/V@A7K]d@A7K]d@A7+@A7˒:)@A7˒:)@A7+@A7fA@A7@@A7+j@A8
qu@A8}H@A8-
q@A873@A8D*@A8H@A8H@A8K]c@A8Xy=@A8r Ĝ@A8r Ĝ@A8u!@A8r Ĝ@A8u!@A8˒:*@A8˒:*@A8˒:*@A8n@A8YJ@A8n@A8'RT@A8@A8-
@A8@A8
=q@A8d8@A8{@A89Xb@A8)@A8)^@A8ѷX@A8F@A8ѷX@A8F@A8F@A8҈p@A8҈p@A8e+@A8@A8\)@A9$/@A9+@A9_p@A9@A9#w@A9*0U2a@A9*0U2a@A9-w1@A94J@A9Gz@A9Q@A9^@A9ae@A9e+a@A9rGE8@A9R<6@A9R<6@A9R<6@A9@A9u@A9u@A9(@A9'R@A9|@A9y@A9-@A:n@A:u%F@A:	 @A:@A:䎊@A:䎊@A:&IR@A:-V@A::)y@A:=p
@A:JL@A:GE85@A:M@A:a|Q@A:kP|@A:nO@A:{m@A:ݘ@A:p:@A:L_@A:S&@A:wkQ@A:vȴ@A:vȴ@A:L/{@A:g	@A:n@A:W@A:)_@A:͞&@A:sP@A:G{@A:fB@A:C,@A:D@A;I^@A;s@A;nP@A;s@A;PH@A;	@A;&@A;/V@A;/V@A;)^	@A;/V@A;9@A;@N@A;MjO@A;a@N@A;a@N@A;dZ@A;jf@A;@A;eO@A;:)z@A;ߤ@A;U=@A;*0U2@A;m]@A;~($@A;Ƨ@A;|@A;
=p@A;҈@A;lC@A;@A<J@A<@A<ߤ@@A<ߤ@@A<L_@A<tj@A<!-w2@A<%1@A<(\@A<<쿱@A<Fs@A<SMj@A<zG@A<qj@A<qj@A<S@A<O
M@A<O
M@A<j~@A<*0@A<>B[@A<@A<Z@A<@A<D@A<E@A=K]@A='0@A=u@A=[@A=qu"@A=%F
L@A=(@A=IQ@A=Y|@A=ce@A=ce@A=w1@A=zxl"h@A=zxl"h@A=$/@A=}H@A=zxl"h@A=$/@A=U=@A=sh@A=@A=n/@A=n/@A=H˒@A=b@A=
qv@A=b@A=?@A=!.@A>
L/@A>4K@A>zG@A>u@A>5?|@A>;5X@A>?@A>BZc @A>E@A>H@A>R<6@A>YJ@A>c	@A>l!-@A>z@A>@A>,<@A>,<@A>af@A>-@A>}Vl@A>m\@A>҈p;@A>A@A>Ϫ͟@A>+@A>]cf@A>+@A>]cf@A>1@A>x@A>쿱[W@A>Mj@A>!.I@A?Ft@A?
=p@A?)^@A?@A?v@A?!-w1@A?4֡a@A?.H@A?4֡a@A?>6z@A?H˒:@A?KƧ@A?KƧ@A?RT`e@A?eں@A?|hs@A?	@A?ݗ+@A??@A?zH@A?͞@A?&@A?[W>@A?r@A?r@A?@A?@A?K]d@A?fA@A?Vϫ@A?#@A@@A@*0U@A@}H@A@$xG@A@73@A@H@A@U2a|@A@bM@A@bM@A@hۋq@A@r Ĝ@A@|@A@YJ@A@'RT@A@'RT@A@@A@-
@A@@A@@A@-
@A@tj@A@@A@u%F@A@d8@A@U@A@U@A@U@A@)@A@TɅ@A@ěT@A@D@A@e+@A@@A@4֡b@A@{@A@PH@A@PH@AA ѷ@AA ѷ@AA	k~@AA@N@AA [7@AA#w@AA#w@AA&x@AA&x@AA&x@AA*0U2a@AA0
)@AA:S@AAN;5@AAQ@AATɅo@AATɅo@AAe+a@AAk~(@AA|Q@AA|Q@AA|Q@AA@AAb}@AA@AA@AAoiD@AAoiD@AA@AAR<6@AAu@AA'RTa@AAn.@AA(@AA|@AA^5?}@AA2W@AAo@AAԕ*@AA@AAᰉ'@AA-@AAlD@AA.H@AA-@AAlD@AA.H@ABu%F@AB	 @AB@ABs@AB䎊@AB0U2a|@AB0U2a|@AB=p
@AB@4n@ABM@ABW'@ABnO@ABxl"h
@AB@4@AB~"@AB~"@AB@4@AB@4@ABݘ@ABS&@AB\(@ABᰊ@ABS&@AB0
@ABwkQ@ABL/{@ABW@AB ѷ@AB ѷ@AB䎊q@ABfB@AB䎊q@ABc	@AC҉@AC'/@ACPH@ACPH@AC)^	@AC/V@AC6z@AC6z@AC9@AC6z@AC@N@ACC%@ACF]c@ACJ#9@ACMjO@ACP{@ACP{@AC]cA@ACg	l@AC{J#9@AC~$@ACq@ACA@ACߤ@ACS@ACZ@ACa@O@AC5Xy@AC
=p@ACC]@AC\N@ADn.@AD1&y@AD1&y@ADxF@ADxF@ADxF@ADtj@AD%1@AD(\@AD,<@AD,<@AD,<@AD/{J#@AD/{J#@AD2W@AD64@AD9XbN@AD<쿱@AD?@ADFs@ADI^5?@ADVϪ@AD`d@ADm8@ADwkP@ADC@AD*1@AD_@AD3@ADzxl"@ADzxl"@ADTɆ@AD1&@AD?@AD?@ADZ@ADZ@AD@ADD@AD!-w@ADE@AD>@ADE@AEo i@AE'0@AE'0@AE*0@AEQ@AE2a|@AE5Xy>@AE<64@AE?|h@AEF
L0@AEL_@AES&@AE`A7L@AEjOv@AEsg@AE}H@AEM:@AEڹZ@AEhr!@AEO
@AE+j@AE%@AE=K@AE@AEU=@AEH˒@AEcA @AE?@AE,=@AE(@AEE@AF ѷY@AF
L/@AF!R<@AF5?|@AF8YJ@AF;5X@AFBZc @AFL/{J@AFYJ@AFiB@AFs@AF%@AFqi@AF$t@AF,<@AFaf@AFT@AFaf@AFaf@AFT@AFT@AF}Vl@AF}Vl@AF'@AFQ@AFQ@AF'@AF'@AF'@AF@AF@AF&I@AF&I@AFȴ9X@AFm\@AF&I@AFA@AFA@AF҈p;@AF҈p;@AFϪ͟@AF҈p;@AFC-@AFMj@AF쿱[W@AFMj@AF!.I@AG@AGFt@AGFt@AG
=p@AG
=p@AG
M;@AG@AGXe@AGv@AG@AGv@AG$tS@AG$tS@AG$tS@AG!-w1@AG'/W@AG+I@AG'/W@AG.H@AG4֡a@AG>6z@AG;dZ@AGE84@AGO
M@AGeں@AGo@AGo@AG|hs@AG{J#:@AGkP@AG&@AG&@AGzH@AG&@AG͞@AGzH@AGzH@AGzH@AG3@AG@AG@AGo @AG@AGo @AGo @AGK]d@AG˒:)@AG˒:)@AG+@AG@AG@AG@AGحV@AGحV@AGVϫ@AH     @AH
qu@AHbM@AH}H@AH$xG@AH1&x@AH4m9@AH73@AH4m9@AH:~ @AHQ@AHXy=@AH_F@AH_F@AHy=c@AHn@AHYJ@AH@AH@AHtj@AH
=q@AH9Xb@AH{@AH4m@AH9Xb@AH4m@AH9Xb@AH{@AHTɅ@AH@@AH@@AH@@AH@@AH)^@AHF@AHe+@AH\)@AH\)@AH	k@AH$tT@AH$tT@AI$/@AIrGE@AIrGE@AIrGE@AI#w@AIDg8~@AIJE@AITɅo@AI^@AIae@AIhr @AIk~(@AIk~(@AIo hی@AIo hی@AIk~(@AIrGE8@AIx@AI|Q@AIoiD@AIoiD@AI@AIR<6@AI@AI@AIn.@AI'R@AI|@AIX@AID@AIy@AI2W@AI_o@AIe@AI>BZ@AIR@AI@AIs@AI-@AIY}@AIY}@AI-@AIlD@AJu%F@AJI^5@AJs@AJ䎊@AJ)y@AJ-V@AJ6C@AJ3@AJ3@AJ6C@AJ3@AJ3@AJ0U2a|@AJ3@AJ:)y@AJ@4n@AJGE85@AJJL@AJQ_@AJW'@AJ^5?|@AJh	ԕ@AJh	ԕ@AJ{m@AJ\(@AJᰊ@AJ0
@AJwkQ@AJwkQ@AJS&@AJL/{@AJg	@AJ}Vm@AJ ě@AJ<64@AJ<64@AJ@AJ@AJ)_@AJ͞&@AJ͞&@AJ)_@AJ`A@AJsP@AJڹY@AJC,@AJC,@AJm@AJc	@AJm@AJm@AJD@AJm@AJm@AJm@AJD@AJ74@AJ~@AJ~@AJm\@AKu%@AKS&@AKu%@AKu%@AK҉@AKnP@AKPH@AK	@AK)^	@AK,zxl@AK33333@AK=K^@AK@N@AKF]c@AKC%@AKF]c@AKF]c@AKF]c@AKJ#9@AKJ#9@AKJ#9@AKMjO@AKS@AKS@AKS@AKW>6z@AKZ@AKW>6z@AKS@AKW>6z@AKZ@AK]cA@AK]cA@AK]cA@AKg	l@AKjf@AKqu!@AK{J#9@AK~$@AK~$@AK@AKeO@AK@AK@AKQ@AK{J#9@AKQ@AKQ@AKq@AKeO@AKq@AKMj@AK:)z@AK$@AKwk@AKU=@AKS@AKS@AK*0U2@AK*0U2@AKm]@AKZ@AKZ@AKƧ@AK5Xy@AK
=p@AKݗ+k@AKݗ+k@AK҈@AK҈@AKlC@AKlC                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     @r@rfffff@r@rٙ@r     @r     @rٙ@rٙ@rٙ@r     @rfffff@r@rfffff@rfffff@r33333@r33333@rə@rٙ@r@rᙙ@r33333@r@r@r@r@r@s@rfffff@r33333@rfffff@s33333@s@s@s@s33333@s      @rfffff@rᙙ@r@s     @s9@sC33333@sH     @sI@sL@sFfffff@sNfffff@sVfffff@sVfffff@sC33333@sfffff@s33333@s	@s@sfffff@s@rfffff@r33333@rfffff@r     @rfffff@r33333@rᙙ@r     @r@r     @r     @rfffff@r33333@r     @r@rfffff@r     @r     @r     @r33333@rfffff@r     @r@r33333@r     @r@rfffff@r33333@r33333@r     @r@rfffff@r     @r@r     @r@r     @r@rfffff@r@r33333@r~fffff@rx     @rx     @rvfffff@rx     @rs33333@rt@rl@ra@rS33333@rC33333@r1@r      @r33333@q@q33333@q@q33333@qh     @q1@q      @q     @pfffff@p@pT@p     @pљ@p	@m     @m     @l@l@     @k@kfffff@kS33333@j|@i@i#33333@i      @i\@ifffff@jL@j&fffff@g33333@gi@gvfffff@g@g@g33333@fc33333@ffffff@efffff@e33333@efffff@e     @e@e33333@efffff@efffff@e@ey@el@ec33333@eS33333@e&fffff@dfffff@d     @dfffff@dfffff@d@dfffff@d     @d0     @d0     @d0     @d,@d      @d     @c     @c     @cfffff@c@c@cfffff@c     @c@cfffff@c33333@cvfffff@c\@cL@cFfffff@c<@c0     @c#33333@c     @c      @b陙@bfffff@b@bfffff@b@b     @b     @b     @b33333@by@bp     @bc33333@bFfffff@b@a@a33333@a33333@afffff@a     @aVfffff@aI@a9@a&fffff@a@a	@a33333@`fffff@`fffff@`@`陙@`33333@`fffff@`fffff@`@`@`@`@`y@`vfffff@`p     @`i@`i@`ffffff@`Vfffff@`333333@`      @_@_fffff@_     @_@_33333@_fffff@_`     @_@^@^fffff@^l@^S33333@^9@^&fffff@^33333@]@]@]L@\@\     @\fffff@\33333@\     @\`     @\Ffffff@\,@\      @\@[ٙ@[33333@[     @[33333@[@[fffff@[     @[y@[s33333@[`     @[&fffff@Zl@Y@Y@Y@Y33333@Y@Y33333@YY@Y&fffff@Yfffff@X@X     @X33333@X33333@X33333@Xffffff@X333333@X@W33333@W33333@W33333@W     @W     @Wffffff@W@     @W&fffff@W33333@W@W33333@W      @V33333@Vfffff@V33333@V33333@Vfffff@Vffffff@V`     @V`     @VS33333@VFfffff@V9@V&fffff@V33333@U33333@U     @U     @U@U     @Ul@US33333@U9@U      @U33333@U33333@U@U      @T33333@T@T33333@T     @T@T33333@Tffffff@T9@T33333@Sfffff@S33333@S@Sfffff@Sfffff@Ss33333@SL@S,@R33333@Rfffff@Rfffff@Rfffff@R`     @R9@R@R      @Q@Qfffff@QS33333@Q9@Q      @Qfffff@P     @P@P@Py@Pl@P`     @PS33333@PFfffff@P,@P      @O33333@Offfff@O@O@Os33333@Os33333@Os33333@OY@O@NY@N&fffff@N@Mfffff@Mٙ@M@M33333@Ms33333@M@     @M&fffff@M      @M      @L33333@L     @L@Ls33333@LL@L333333@L&fffff@L@L      @Kٙ@K@Kfffff@K@KY@K&fffff@K      @Jٙ@J@Jfffff@J@J@Jffffff@J@J      @I@I@Is33333@Iffffff@Is33333@I     @Iffffff@H@H@     @H333333@H      @Gfffff@Gٙ@G     @Gfffff@G@Gs33333@GL@G&fffff@F@Fffffff@F&fffff@Eٙ@Efffff@Es33333@EL@E&fffff@E      @Dfffff@D     @D33333@D@Dfffff@D@D@D@D@D     @Ds33333@DL@D@     @D&fffff@D@C33333@Cfffff@Cfffff@C@Cfffff@C@C     @Cs33333@C     @Cs33333@CY@CL@C@     @CY@C@     @B33333@B33333@B@B@B     @Bs33333@B     @Bs33333@Bs33333@Bs33333@Bs33333@BY@BL@B@     @B&fffff@B@B@A33333@A@Afffff@Afffff@Afffff@Afffff@A@A     @A     @As33333@Affffff@AY@AL@A@@33333@@fffff@@ٙ@@fffff@@ٙ@@ٙ@@@@@@     @@     @@33333@@@@s33333@@L@@333333@@@@      @?33333@?@?     @?L@?333333@?      @>@>     @>L@>@=@=     @=333333@=333333@=      @<fffff@<33333@<33333@<ffffff@<333333@;fffff@;fffff@;fffff@;@;@;fffff@;@;33333@;@;@;ffffff@;L@;ffffff@;     @;L@;333333@;L@;L@;@;@:fffff@:33333@:     @:L@:L@:     @:ffffff@:L@:L@:333333@:333333@:@9fffff@:      @:      @:      @9fffff@9@9@9ffffff@9ffffff@9ffffff@9333333@9      @8fffff@8fffff@8fffff@833333@8@833333@8@8@8ffffff@8     @8ffffff@8L@8L@8L@8L@8L@8333333@8333333@8@8      @7fffff@7fffff@7fffff@7@733333@7@733333@7@7@7ffffff@7ffffff@7ffffff@7ffffff@7L@7L@7@7333333@7@7@7@7@7      @7@6@6fffff@633333@6@633333@633333@6@633333@633333@6@6@6     @6ffffff@6ffffff@6ffffff@6L@6333333@6333333@6333333@6@6333333@6      @5fffff@533333@5@5@5@5ffffff@5L@5L@5L@5333333@5@5@5      @4fffff@4@4@4@4@4@4ffffff@4333333@4@4333333@4@4      @3@333333@3@3     @3333333@3333333@3@2fffff@2fffff@2@233333@2@2@2     @2L@2L@2333333@2333333@2L@2L@2     @2     @1fffff@1@133333@1@1@1@1@133333@1@1     @1L@1L@1333333@1L@1@1@1@0fffff@0fffff@0@0@0@033333@0ffffff@0L@0L@0333333@0@0333333@0L@0@0333333@/ffffff@/333333@/333333@.@.@.@.@/      @.@.@.ffffff@.      @-@-@-@-@-@-@-@-@,@-333333@-      @-333333@-      @,@,@,@,@,@,@,@,333333@,      @,      @,      @+@,333333@,333333@,      @+@,      @+@+ffffff@+@+@+@+@+333333@+333333@+      @+      @*@+      @+      @*@*@*@*@*@*@*ffffff@*@*333333@*      @*333333@*333333@*333333@*      @*333333@*      @*      @*      @*      @*      @)@*      @*      @)@)ffffff@)@)333333@)ffffff@)ffffff@)ffffff@)@)333333@)ffffff@)ffffff@)333333@)333333@)333333@)333333@)ffffff@)333333@)333333@)333333@)ffffff@)333333@)      @(@(@)      @(@(@)      @(@(@(@(@(@(@(@(@(@(ffffff@(@(@(@(ffffff@(ffffff@(ffffff@(333333@(333333@(333333@(333333@(333333@(333333@(333333@(333333@(      @(      @(ffffff@(      @'@(      @(      @(      @(      @(      @'@(      @'@'@(      @'@(      @(      @'@'@'@(      @'@'ffffff@'@'@'@'@'ffffff@'@(      @'@(      @'@(      @(      @(      @(      @(      @'@'@(      @(      @(      @(      @(      @(      @(333333@(333333@(333333@(ffffff@(ffffff@(@(333333@(ffffff@(@(@(ffffff@(@(@(@(@(@(@(@(@(@(@(@(@(@(ffffff@(ffffff@(@(ffffff@(333333@(333333@(ffffff@(ffffff@(ffffff@(@(ffffff@(333333@(333333@(333333@(333333@(@(333333@(      @(ffffff@(333333@(333333@(333333@(      @'@'@(      @(ffffff@(      @'@(333333@(333333@(      @'@'@'@(      @(      @(      @(      @(      @'@(      @'@'@'@'@'@(      @'@'@(      @'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'ffffff@'@'@'@'@'@'@'@'@(      @'@'@'@'@(      @'@'@'@'@'@'@'@(      @(      @(      @'@'@'@'@'@'@(      @(ffffff@'@'@(      @'@'@(      @(      @(      @'@(      @'@'@(333333@(333333@'@(      @(333333@(      @(      @(      @(333333@(333333@(333333@(333333@(ffffff@(333333@(333333@(ffffff@(ffffff@(333333@(ffffff@(@(ffffff@(333333@(333333@(@(333333@(@(@(ffffff@(@(@(@(@(ffffff@(@(ffffff@)      @(@(@(@(@(@)      @(@(@(@(@(@(@)      @)      @)333333@)333333@)333333@)      @)      @)333333@)ffffff@)333333@)ffffff@)333333@)333333@)@)333333@)333333@)ffffff@)@)ffffff@)ffffff@)ffffff@)ffffff@)@)@)@)@)@*333333@)@*      @*333333@)@*      @*@*      @*333333@*333333@*ffffff@*ffffff@*333333@*333333@*333333@*333333@*333333@*333333@*ffffff@*@*ffffff@*@*@*333333@*@*@*@*ffffff@*ffffff@*@*@*@*@*@*@*@*@+      @*@*@*@*@*@+333333@+333333@*@+ffffff@+333333@+333333@+333333@+333333@+ffffff@+333333@+333333@+333333@+333333@+ffffff@+333333@+ffffff@+ffffff@+333333@+@+@+ffffff@+@+@+@+@+@+@,      @+@,      @,      @+@,ffffff@,      @,      @,333333@,333333@,ffffff@,333333@,      @,333333@,333333@,333333@,333333@,333333@,ffffff@,      @,333333@,ffffff@,ffffff@,ffffff@,333333@,@,@,@,@,ffffff@,@-      @,@,@,@,@,@,@,@-      @-333333@-      @-      @-333333@-333333@-333333@-      @-333333@-@-ffffff@-333333@-333333@-@-ffffff@-@-@-@-@.      @-@-@-@.333333@.ffffff@.ffffff@.@.333333@.@.@.@.@.@.@.@.@/      @/333333@/333333@/333333@/333333@/333333@/333333@/ffffff@/ffffff@/ffffff@/ffffff@/333333@/ffffff@/ffffff@/@/@/@/@/@/@/@0      @0@0@0@0@0333333@0@0333333@0L@0333333@0333333@0333333@0333333@0ffffff@0333333@0ffffff@0ffffff@0ffffff@0     @0     @0     @0@033333@033333@033333@033333@0fffff@0fffff@0fffff@0fffff@0fffff@1@1333333@1@1      @1ffffff@1333333@1333333@1ffffff@1333333@1333333@1ffffff@1ffffff@1@1     @1@1@1fffff@1fffff@1fffff@2      @1fffff@2      @2333333@2333333@2L@2L@2ffffff@2     @2     @2@2     @2     @2     @2@2@233333@2@2fffff@2fffff@3      @3@3@3@3@3333333@3333333@3333333@3L@3ffffff@3@3ffffff@3ffffff@3@333333@3@3@3@3@333333@4      @4      @4      @4@4L@4L@4333333@4L@4ffffff@4ffffff@4     @4ffffff@4L@4@4@4@4@4fffff@5      @5      @4fffff@4@4@4fffff@5      @5@5@5L@5L@5     @5333333@5L@5L@5L@5ffffff@5ffffff@5     @5     @533333@5@533333@5@533333@5fffff@5@5fffff@5fffff@6      @6L@6333333@6     @6     @6ffffff@6     @6ffffff@6     @6@6     @6@6fffff@6fffff@6@6fffff@6fffff@7333333@7@7333333@7ffffff@7     @7@7@7@7@8      @7fffff@7fffff@8@8333333@8@8@8      @8L@8L@8@8333333@8333333@8ffffff@8L@8L@8ffffff@8ffffff@8     @8@8     @833333@9      @8fffff@833333@9      @9@9      @9      @9@9L@9333333@9333333@9L@9L@9333333@9ffffff@9ffffff@9     @9     @9     @9@9@9@9fffff@9fffff@:      @:      @:333333@:@:L@:333333@:@:@:333333@:333333@:L@:     @:ffffff@:ffffff@:ffffff@:     @:@:33333@:33333@:@:33333@:fffff@;333333@;@;333333@;333333@;@;@;333333@;@;L@;ffffff@;     @;@;33333@;@;@;33333@<      @<@<      @<333333@<ffffff@<L@<ffffff@<ffffff@<L@<ffffff@<ffffff@<     @<@<     @<33333@<     @<@=      @=@=333333@=L@=333333@=     @=L@=     @=     @=@=fffff@>      @=@>@>      @=fffff@=fffff@>@>@>333333@>@>333333@>333333@>L@>     @>     @>@>fffff@>@>33333@?      @?L@?ffffff@?L@?     @?     @?33333@?fffff@?fffff@@      @@@@      @@@@@@@@@@@@333333@@333333@@333333@@333333@@&fffff@@@     @@Y@@L@@@     @@@     @@L@@ffffff@@ffffff@@@@@@33333@@fffff@@@@     @@ٙ@@@@fffff@@fffff@@ٙ@A      @A      @A@A@A@     @A@     @A@     @A@     @AY@AY@A     @Affffff@Affffff@Affffff@As33333@A@A@Afffff@A@A33333@Afffff@Aٙ@Afffff@Afffff@A33333@B@B@B@B&fffff@B&fffff@B&fffff@B333333@B333333@BY@Bffffff@Bffffff@Bs33333@B@Bfffff@B33333@Bfffff@B@B@Bٙ@C@C@C333333@C333333@C@     @Cffffff@C     @C     @C     @C@C33333@Cfffff@C     @C33333@C33333@C     @C@Cٙ@Cfffff@Cfffff@C33333@Cfffff@Cٙ@C33333@C33333@Cfffff@C33333@D      @C33333@Cfffff@C33333@D      @D&fffff@D@D@D@D&fffff@D@D333333@D333333@D333333@D333333@DY@D@     @D@     @DY@DL@DL@Dffffff@Dffffff@DY@Dffffff@D@D     @Ds33333@D@D@D     @D@D     @D     @D@D@Dfffff@D33333@Dfffff@D33333@D@D     @Dfffff@D33333@E@E333333@E333333@E333333@EL@EY@Effffff@EY@EY@EY@E     @Effffff@Effffff@E@E@E     @Efffff@E@E@E@E@E@E@Efffff@E33333@Efffff@E     @Eٙ@Efffff@F      @E33333@F&fffff@FL@F333333@F@     @F@     @FL@FY@Fffffff@Fs33333@F@Ffffff@F     @F@F     @F@F@F33333@G      @G      @G      @G@G&fffff@G@G333333@G@     @G@G&fffff@G333333@G333333@GY@GY@G@     @GY@G@G@Gfffff@G33333@Gfffff@G33333@G33333@G     @G@H      @H      @H@H333333@H@     @HY@HY@Hffffff@HY@Hs33333@Hffffff@Hs33333@Hffffff@H     @H     @H@H@H33333@H33333@H     @Hٙ@Hٙ@H33333@Hfffff@H33333@I      @I@I@I&fffff@I333333@I@     @I@     @IL@Is33333@IY@Iffffff@Is33333@I     @I     @I     @I@I@I33333@I     @Ifffff@J      @Iٙ@Iٙ@Iٙ@Iٙ@I33333@J      @J      @J      @J      @J&fffff@J@J@J333333@J@     @JY@Js33333@J@J     @Jfffff@J@J@Jٙ@J@J@J33333@Jٙ@Jfffff@J33333@K      @K&fffff@K333333@K333333@K&fffff@K&fffff@K&fffff@K&fffff@KL@KL@KY@K     @Ks33333@Ks33333@K     @Ks33333@Kffffff@K@K@K     @K@Kfffff@K     @K33333@K33333@K33333@K33333@K33333@K     @K     @K     @Kٙ@K33333@K33333@L@L      @L&fffff@L333333@L@L@L333333@LL@LY@LL@L&fffff@L@     @L333333@LL@L333333@LY@LY@L@     @LL@Lffffff@LL@LL@LY@Lffffff@L     @Ls33333@Ls33333@Lfffff@Lfffff@L@L@L@L33333@L     @L33333@L@Lfffff@Lfffff@Lfffff@Lfffff@L33333@Lfffff@Lfffff@L@L@Lfffff@Lfffff@Lٙ@Lfffff@L@L33333@M      @M@M@M@M@M@     @M@     @ML@Mffffff@ML@MY@Mffffff@ML@ML                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     ?KƧ?Q?;dZ?E?j~"?Ƨ-? ě?Q?-V?M?~"?+I^?n?ȴ9Xb?M?+I?zG{?vȴ9?zG?-V?9XbM?Gz?O;dZ?(\)?\(?"`B?KƧ?"`A?C%?O;dZ?+I?Ƨ-?-V?j~"?$/?Q?"`?O;dZ?$/?hr!?$/@+I^@-V@bM@"`@xF@ȴ9Xb@+I^@+@nO;@$/@I^5@C%@ E?/v?"`A?lC?-V?S?^5?|?bM?&x?xF?=p
=?ffffff?n?vȴ?/v??Q?lD?$/?bM?\(?ěS?tj~?웥S?S?S?"`A?O;dZ?&x?-??nP??$/?I^5??"`B?ᙙ?p
=q?lC?zG?C%?Z1'?1&x?Vt?ߝ-V?r ě?ěS?+?+?+?ڰ ě?^5?|?ڰ ě?GzH?E?XbM?QR?lC?׾vȴ9X?֗O;d?lC?GzH?\(\?j~"?I^5?hr Ĝ?ӕ$/?tj?/w?1&x?/w?I^5?1&x?`A7L?;dZ?vȴ9X?p
=q?5?|h?E? ěT?(\)?XbM?ȴ9Xb?E?7KƧ?KƧ?ə?ǮzG?+I^?+I^?ěS?KƧ?Ł$/?šo?Ƈ+I?ļj~#?9XbM?ěS?l?ļj~#?ļj~#?+?ěS?S?-V?ļj~#?7KƧ?° ě?Z1'?nO?$/?
=p?
=p?ěS?n?\(?lD?A7Kƨ?`A7L?`A7L?I^5??n?M?$/?-V?M?I^5??n?$/?hr Ĝ?n?$/?&x?bM?hr Ĝ?
=p?ěS?`A7L? ěT?ěS?I^5??"`?-V?bM?ěS?ěS?n?\(?nP?|hr?M?bM?hr Ĝ?nP?A7Kƨ?ěS?/v?A7Kƨ? ěT?nO;?      ?7KƧ?A7Kƨ?vȴ9X?I^5??&x?7KƧ?n?|hr?° ě?° ě?A7Kƨ?+?n?&x?$/?$/?
=p?lD?$/?vȴ9X?M? ěT?
=p?ěS?I^5??hr Ĝ?lD?hr Ĝ?l?GzH?bM?&x?° ě?nP?lD?GzH?;dZ?lD?Q?E?n?\(?\(?n?ěS?&x?Q?Q?ěS?nP?vȴ9X?`A7L?GzH?nP?nP?lD?Q?/w?nP?-V?ěS?&x?-V?\(?nO;?bM?\(?$/?$/?öE?
=p?lD?7KƧ?`A7L?333333?hr Ĝ?$/?nP?7KƧ?|hr?$/?      ?
=p? ěT?vȴ9X?bM?ěS?GzH?öE?Q?GzH?$/?lD?ěS?° ě?öE?"`?A7Kƨ?-V?`A7L?nO?E?1&?A7Kƨ?Q?;dZ?&x?vȴ9X?Q?`A7L? ěT?\(?
=p?öE?nO?nO?Q?nO;?nO;?Q?M?n?l?hr Ĝ?vȴ9X?I^5??n?M?-V?nO?nO;?\(?\(?hr Ĝ?333333?bM?;dZ?nP?`A7L?7KƧ?lD?Q?I^5??lD?9XbM?lD?
=p?l?Õ$/?`A7L?`A7?Õ$/?$/?-V?Õ$/?-V?333333?tj~?7KƧ?ěS?M?l?+?lD?nO;?I^5??I^5??n?-V?-V?-V?lD?&x?vȴ9X?`A7L?Q?$/?lD?öE?° ě?S?\(?Q?`A7L?ěS?M?&x?vȴ9X?-V?;dZ?M?ěS?`A7?GzH?7KƧ?7KƧ?`A7L?A7Kƨ?5?|h?$/?n?&x?`A7L?`A7?hr Ĝ?-V?7KƧ?A7Kƨ?S?S?&x?+?M?$/?M?bM?° ě?M?hr Ĝ?-V?-V?333333?vȴ9X?-V?
=p?ěS?zG{?`A7?n?lD?hr Ĝ?+?I^5??-V?$/?M?l?lD?"`?7KƧ?-V?+?nO;?7KƧ?$/?-V?bM?-V?-V?A7Kƨ?lD?`A7?\(?/w?M?S?&x?öE?7KƧ?&x?7KƧ?I^5??zG{?-V?9XbM?+?nO;?Q?S?GzH?nO;?`A7L?šo?tj~?GzH?ěS?° ě?hr Ĝ?\(?I^5??$/?M?`A7L?n?333333?° ě?I^5??° ě?-V?-V?tj~?`A7L?nO?333333?M?`A7?öE?ěS?\(?Q?GzH?Z1'?lD?nO?ěS?`A7L?l?M?`A7?Z1'?tj?tj~?/w?333333?$/?S?Õ$/?\(?nP?Q?7KƧ?nO?lD?7KƧ?-V?`A7?tj~?S?lD?Õ$/?n?\(?\(?n?333333?-V?Q?\(?tj?M?nO?Q?7KƧ?9XbM?lD? ěT?lD?nO;?tj?tj?-V?nO;?`A7?S?M?I^5??nO;?&x?öE?Q?Q?nO?+?-V? ěT?Q?$/?333333?Ł$/?333333?&x?333333?7KƧ?7KƧ?GzH?7KƧ?7KƧ?GzH?nO?n?M?
=p?nO;?`A7?nO;?tj?
=p?333333?hr Ĝ?-V?7KƧ?° ě?+?\(?l?lD?&x?S?° ě?tj~?öE?$/?ļj~#?nO?n?
=p?l?S?ěS?`A7K?`A7?Q?7KƧ?`A7L?M?nO;?nO?A7Kƨ?tj~?-V?M?333333?S?Z1'?7KƧ?-V?&x?öE?Z1'?$/?l?I^5??+?öE?-V?-V?Q??|hs?&x?
=p?333333?Q?M?öE?° ě?E?-V?hr Ĝ?nO?tj~?-V?&x?nO;?I^5??
=p?333333?nO;?öE?&x?Z1'?7KƧ?l?nO?n?hr Ĝ?° ě?A7Kƨ?nO?l?hr Ĝ?`A7?`A7?tj?ěS?7KƧ?tj?&x?n?tj?öE?l?I^5??tj~?\(?Ł$/?tj?ěS?$/?M?-V?333333?
=p?M?\(?nO?Q?hr Ĝ?l?-V?\(?`A7?333333?
=p?tj~?
=p?-V?n?n?M?-V?9XbM?S?7KƧ?I^5??I^5??`A7L?šo?Q?$/?Q?9XbM?Õ$/?333333?I^5??"`?7KƧ?E?Ł$/?Q?
=p?333333?nO;?öE?zG{?333333?öE?I^5??I^5??-V??|hs?l?ěS?nO?+?l?nO;?-V?ěS?333333?
=p?M?Q?n?7KƧ?tj~?l?+?E?S?n?\(?9XbM?Õ$/?hr Ĝ?9XbM?GzH?Q?Q?I^5??-V?A7Kƨ?° ě?° ě?nO;?Q?333333?nO;?tj?$/?7KƧ?l?$/?I^5??I^5??M?l?333333?\(?zG{?\(?9XbM?nO?I^5??&x?ěS?Q?+?7KƧ?+?zG{?9XbM?7KƧ?-V?l?lD?`A7L?Q?Q?-V?$/?Õ$/?öE?-V?Õ$/?n?&x?l?hr Ĝ?nO?nO;?tj~?I^5??-V?&x?S?GzH?333333?Q?tj?öE?lD?Õ$/?öE?öE?hr Ĝ?7KƧ?l?A7Kƨ?GzH?l?S?tj~?öE?+?`A7K?`A7?l?l?Q?öE?
=p?lD?l?I^5??333333?+?Q?\(?+?"`?
=p?nO?S?° ě?ļj~#?Õ$/?nO;?9XbM?GzH?Q?Z1'?333333?333333?n?E?+?nO;?-V?tj~?
=p?tj?-V?M?
=p?° ě?tj~?&x?lD?Q?I^5??° ě?
=p?n?bM?+?öE?n?`A7?GzH?$/?nO;?&x?-V?-V?9XbM?9XbM?`A7?$/?lD?nO;?-V?tj~?
=p?nO?S?° ě?tj~?nO?n?° ě?ěS?Z1'?M?9XbM?ļj~#?ěS?Õ$/?GzH?Q?M?nO?GzH?\(?\(?° ě?7KƧ?tj~?9XbM?hr Ĝ?tj~?\(?tj?nO;?nO?
=p?-V?-V?ěS?° ě?l?E?öE?tj?-V?333333?ļj~#?hr Ĝ?\(?333333?nO?I^5??ěS?Õ$/?ěS?I^5??tj?S?S?ěS?Q?lD?l?9XbM?333333?9XbM?S?Õ$/?9XbM?+?333333?+?7KƧ?nO;?S?tj?333333?-V?Q?nO;?7KƧ?\(?nO?I^5??x?Z1'?Õ$/?S?nO;?`A7K?-V?n?\(?zG{?\(?9XbM?° ě?nO?nO?
=p?tj?l??|hs?Q?lD?° ě?`A7?nO?M?nO;?\(?I^5??7KƧ?`A7K?\(?öE?° ě?\(?nO;?-V?$/?nO?Q?nO?`A7?S?333333?Z1'?Ƈ+I?9XbM?M?+?GzH?S?tj??|hs?I^5??n?GzH?Q?Z1'?Q?lD?nO;?I^5??S?&x?n?7KƧ?tj~?&x?° ě?Õ$/?° ě?M?Ƈ+I?
=p?
=p?\(?ěS?I^5??`A7L?7KƧ?Ł$/?\(?GzH?tj~?ěS?n?-V?E?\(?&x?Ł$/?M?\(?-V?l?`A7L?`A7?tj?tj~?° ě?hr Ĝ?S?ļj~#?Õ$/?\(?nO?+?
=p?Ł$/?I^5??`A7?GzH?bM?GzH?GzH? ěT?A7Kƨ?nO;?
=p?nO;?`A7?\(?Õ$/?nP?tj?nO;?Q?7KƧ?tj~?nP?GzH?+?nO?Õ$/?9XbM?l?
=p?ļj~#?Õ$/?tj?7KƧ?lD?Q?bM?`A7?-V?&x?Õ$/?zG{?333333?l?hr Ĝ?M?I^5??\(?/w?šo?\(?hr Ĝ?$/?GzH?M?$/?Õ$/?S?nO?° ě?I^5??`A7?\(?7KƧ?-V?`A7?Q?° ě?Q?nP?tj?lD?nO;?öE?zG{?öE?\(?I^5??tj?zG{?° ě?nO?/w?S?I^5??Õ$/?Z1'?333333?l?|hr?7KƧ?hr Ĝ?lD?-V?lD?öE?Z1'??|hs??|hs?\(?`A7?9XbM?`A7?hr Ĝ?\(?9XbM?S?+?hr Ĝ?`A7L?° ě?tj?nO?p
=q?Q?ěS?° ě?
=p?n?-V?Q?ěS?° ě?333333?333333?vȴ9X?nP?GzH?ěS?-V?Q?lD?lD?nO?-V?nO?`A7K?E?S?n?öE?`A7?Q?öE?hr Ĝ?333333?tj~?I^5??-V?S?`A7?I^5??Q?-V?S?-V?M?-V?S?nO;?\(?zG{?zG{?Q?Õ$/?S?333333?GzH?-V?
=p?I^5??M?zG{??|hs?9XbM?tj?tj~?
=p?ěS?$/?Q?-V?&x?&x?S?Õ$/?333333?l?° ě?zG{?333333?l?&x?`A7?nO;?Q?tj~?333333?M?Õ$/?Õ$/?Q?l?+?l?$/?$/?1&y?Q?S?`A7?+?nO;?° ě?`A7L?n?öE?bM?l?`A7L?lD?333333?GzH?\(?tj?333333?tj~?-V?GzH?nO?Q?M?öE?`A7?GzH?A7Kƨ?l?lD?Q?S?I^5??M?nO?öE?GzH?
=p?7KƧ?`A7?nO?\(?/w?öE?`A7L?Q?333333?vȴ9X?n?\(?A7Kƨ?9XbM?nO;?l?`A7?M?Z1'?7KƧ?
=p?nP?lD?$/?M?tj~?hr Ĝ?I^5??`A7?S?° ě?° ě?lD?7KƧ?I^5??-V?l?$/?° ě?-V?\(?S?E?tj~?tj?ļj~#?
=p?GzH?+?l?
=p?nO?hr Ĝ?M?
=p?n?&x?nP?° ě?nO?\(?I^5??GzH?I^5??&x?
=p?-V?&x?nO;?\(?nP?GzH?9XbM?zG{?I^5??-V?l?nP?
=p?9XbM?l?n?lD?GzH?tj~?-V?° ě?`A7?Q?° ě?zG{?vȴ9X?M?M?öE?Õ$/?I^5??nO?
=p?7KƧ?
=p?zG{?Õ$/?-V?9XbM?`A7?$/?hr Ĝ?Õ$/?
=p?`A7L?M?zG{?hr Ĝ?nO;?M?/w?9XbM?GzH?-V?+??|hs?-V?I^5??+?l?S?n?&x?`A7?nO;?M?A7Kƨ?I^5??S?nO;?n?$/?lD?\(?nO;?\(?nO?7KƧ?M?vȴ9X?hr Ĝ?l?S?
=p?vȴ9X?&x?
=p?-V?\(?lD?333333?-V?nO?hr Ĝ?
=p?Q?tj~?n?-V?hr!?tj~?nO;?7KƧ?lD?A7Kƨ?nP? ěT?GzH?Q?nO;??|hs?° ě?I^5??\(?/v?Õ$/?Õ$/?M?tj?GzH?Q?lD?`A7?tj?M?`A7?M?hr Ĝ?&x?Õ$/?GzH?nP?$/?I^5??öE?öE?333333?7KƧ?l?Õ$/?Õ$/?GzH?
=p?\(?-V?`A7?lD?ěS?° ě?bM?A7Kƨ?-V?n?l?n?333333?`A7?n?Q?Õ$/?vȴ9X?Q?Q?Q?lD?$/?7KƧ?GzH?ěS?° ě?lD?7KƧ?5?|h?GzH?n?° ě?n?vȴ9X?vȴ9X?GzH?Q?$/?n?lD?nO?-V?tj?Õ$/?Õ$/?-V?nO;?° ě?n?n?$/?nO;?7KƧ?`A7?M?° ě?zG{?° ě?ěS?l?I^5??M?n?nP?hr Ĝ?Q?7KƧ?j~"? ěT?nP?A7Kƨ?hr Ĝ? ěT?l?\(?Q?GzH?7KƧ?M?tj~?hr Ĝ?tj~?n?|hr?ěS?&x?Q?bM?&x?A7Kƨ?7KƧ?lD?I^5??`A7L?`A7L?ěS?lD?nP?öE?M?M?7KƧ?hr Ĝ?n?M?
=p?l?hr Ĝ?l?GzH?vȴ9X?7KƧ?nP?Q?Õ$/?&x?Q?-V? ěT?I^5??\(?7KƧ?n?lD?9XbM?M?      ?      ?lD?A7Kƨ?`A7L?nO;?° ě?n?bM?7KƧ?° ě?S?lD?Õ$/?vȴ9X?S?-V?-V?I^5??$/?l?&x?hr Ĝ?;dZ?;dZ?`A7?Z1'?nP?      ? ěT?|hr?hr Ĝ?GzH?nP?Õ$/?`A7L?hr Ĝ?lD?Õ$/?|hr?`A7?`A7L?\(?hr Ĝ?GzH?`A7L?vȴ9X?I^5??nP?Q?`A7?
=p?I^5??bM?7KƧ?`A7?Q?GzH?ěS?tj~?I^5??GzH?+?GzH?l?7KƧ?(\)?I^5??hr Ĝ?vȴ9X?-V?I^5??;dZ?-V?hr!?bM?A7Kƨ?Q?&x?(\)?`A7?tj?nO?hr Ĝ?n?bM?
=p?&x?lD?Õ$/?I^5??lD?GzH?Q?nO;?&x?
=p?&x?GzH?S?`A7?$/?nO;?-V?nO;?hr!?hr Ĝ?-V?° ě?333333?\(?\(?A7Kƨ?"`?&x?Q?GzH?lD?-V?&x?Q?
=p?lD?&x?lD?GzH?tj~?I^5??M?hr!?ěS?;dZ?\(?$/?I^5??nO;?333333?GzH?7KƧ?bM?&x?vȴ9X?M?&x?A7Kƨ?n?-V?`A7L?A7Kƨ?
=p?bM?lD?I^5??7KƧ?&x?n?A7Kƨ?`A7?vȴ9X?A7Kƨ?vȴ9X?$/?
=p?\(?333333?
=p?lD?l?nO;?$/?n?zG{?l?ěS?nP?n?&x?nP?A7Kƨ?"`?nO;?-V?nO?$/?$/?
=p?GzH?hr Ĝ?S?n?nP?n?$/?n?`A7L?p
=q?vȴ9X?GzH?
=p?-V?9XbM?M?
=p?Q?      ?\(?
=p?I^5??ěS?GzH?nP?333333?-V?I^5??A7Kƨ?7KƧ?&x?Q?n?`A7?ěS?`A7L?bM?nP?
=p?n?$/?Q?öE?nO?;dZ?`A7L? ěT?nO;?-V?lD?n?E?j~"?nP?333333?&x?p
=q?(\)?      ?;dZ?`A7L?/v?$/?|hr?^5?|?nP?ěS?
=p?-V?M?$/?Q?nP?/v?ěS?Q?bM?nO?&x? ěT?j~"?5?|h?hr!?;dZ?
=p?`A7L?n?n?      ?GzH?GzH?nP?
=p?lD?I^5??/v?"`?&x?`A7L?-V?tj~?Q?n?|hr?7KƧ?lD?A7Kƨ?n?I^5??      ?nP?I^5??nP?nP?"`?"`A?° ě?bM?vȴ9X?      ?vȴ9X?bM?vȴ9X?7KƧ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	@M33333@N@     @Ns33333@Nffffff@NY@Ns33333@NY@NL@NY@Ns33333@Ns33333@Nffffff@NL@Nffffff@Ns33333@Nffffff@N     @Ns33333@N     @NY@N&fffff@N@N@     @Nffffff@Mfffff@N&fffff@N@     @N@N      @N      @Mٙ@Mٙ@M@M@Mfffff@Mfffff@M     @M     @M@M     @M@Mffffff@Mffffff@M@     @ML@Ms33333@M33333@M@Mٙ@Mٙ@M33333@N@N&fffff@N     @Nٙ@O      @O&fffff@O@     @OL@Offffff@O@Offfff@O@Oٙ@Offfff@O33333@Pfffff@P@P@P      @P      @P      @P&fffff@P      @P,@P333333@P333333@P9@PFfffff@PFfffff@PL@PS33333@PY@P`     @P`     @P`     @P`     @Pffffff@Pl@Ps33333@Pl@Py@Py@Py@P     @P     @Pl@Py@Pfffff@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P     @P     @P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P@Pfffff@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P@P@P@P@P@P33333@P33333@P@P33333@Pfffff@P33333@P@P@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P@P@P@P@P@P@P@P33333@P@P@P33333@P@P@P@P@P@P     @P@P@P@P@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@P     @P     @P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@P@P     @P@P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P33333@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@Pٙ@P33333@P33333@Pٙ@Pٙ@P@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @P     @P     @Pٙ@Pٙ@Pٙ@P     @Pٙ@P     @P     @P     @P     @P     @Pٙ@P     @P     @P     @Pٙ@P     @P     @Pfffff@P     @Pfffff@P     @P     @Pfffff@Pfffff@P     @Pfffff@Pfffff@P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P33333@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@Pfffff@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P@P@P@P@Pfffff@Pfffff@P@Pfffff@P@Pfffff@Pfffff@Pfffff@P@P@Pfffff@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@Pfffff@P@P@P@P@Pfffff@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@P@Pٙ@P@P@Pfffff@Pfffff@Pfffff@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P     @Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P33333@P@P@P@P@P33333@P33333@P@P33333@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P33333@P@Pfffff@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@Pfffff@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P@P@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P33333@P33333@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P33333@P@P@P33333@P@P@P@P33333@P33333@P@P@P@P@P33333@P@P33333@P@P@P33333@P33333@P@P33333@P33333@P33333@P@P@P33333@P@P@P@P@P@P33333@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P@P@P@P33333@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P@P@P@P33333@P33333@P33333@P33333@P@P33333@P@P33333@P@P33333@P33333@Pfffff@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P@P33333@P33333@P@P@P@P33333@P@P33333@P33333@P33333@P@P@P33333@P33333@P@P@P@P33333@P33333@P@P33333@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@Q      @Q      @Q      @Q      @P@Q      @P@P@Q      @Q      @Q      @P@P@P@P@P@P@P@P@P@P@Q      @P@P@P@P@Q      @Q      @P@Q      @Q      @P@P@P@P@P@Q      @Q      @Q      @Q      @Q      @Q      @P@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @P@Q      @Q      @Q      @P@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @P@Q      @Q      @Q      @Q      @Q      @P@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @P@Q      @Q      @P@Q      @P33333@Q      @Q      @Q      @Q      @Q      @Q      @Q      @P@Q      @Q      @Q      @P@P@Q      @P@P@P@Q      @Q      @P@P@P@P@Q      @Q      @Q      @Q      @P@P@P@P@Q      @Q      @P@P@P@P@P@P@P@P@P@P@P@Q      @Q      @P@P@P@Q      @P@P@Q      @P@Q      @Q      @P@P@Q      @P@P@P33333@P@P@P@P@P@Q      @P@Q      @P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Q      @P@P@Q      @Q      @P@Q      @Q      @Q      @Q      @P@Q      @Q      @P@Q      @Q      @Q      @P@Q      @P@Q      @Q      @Q      @P@Q      @Q      @Q      @Q      @Q      @P@Q      @P@Q      @Q      @P@Q      @Q      @Q      @Q      @Q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           P15                                     1                                       BD3