CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20120522   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P6     CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:47.932927Z    ORIGINAL_HEADER      sCTD,20250210CCHSIOWB
#Renamed 'CTDFLUOR_TSG' to 'CTDFLUOR_ALT_1' with units 'MG/M^3'
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2018-11-29. CTD data from cruise 18DD20120522, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20120522. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2012-12/index.php. 
#
# The information in this file for the cruise 2012-12 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-0072.ctd
#
# Start of originator file comment header
#
#*2018/11/29 14:22:51.16
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2012/06/01 08:02:46.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 2006
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : C44EDC1F
#    NUMBER OF CHANNELS  : 9
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            2.3            2006.7
#       2 Temperature:CTD               deg_C_(ITS90)   1.9166         6.6907
#       3 Salinity:CTD                  PSS-78          32.6639        34.5892
#       4 Sigma-t:CTD                   kg/m^3          25.6458        27.6748
#       5 Transmissivity:CTD            %/m             61.4           67.9
#       6 Oxygen:Dissolved:CTD:Volume   ml/l            0.41           7.23
#       7 Oxygen:Dissolved:CTD:Mass     µmol/kg         17.9           314.7
#       8 Fluorescence:CTD:Seapoint     mg/m^3          0.24E-01       0.74
#       9 Fluorescence:CTD:Wetlabs      mg/m^3          0.102          1.096
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        6  F       ' '     1
#       6  -99   ' '        7  F       ' '     2
#       7  -99   ' '        6  F       ' '     1
#       8  -99   ' '        8  F       ' '     3
#       9  -99   ' '        8  F       ' '     3
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2012-12
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P24
#    EVENT NUMBER        : 72
#    LATITUDE            :  49  50.17000 N  ! (deg min)
#    LONGITUDE           : 142  40.04000 W  ! (deg min)
#    WATER DEPTH         : 3989
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    CTDEDIT was used to remove surface records and records corrupted by shed
#	wakes; salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Transmissivity, Fluorescence and PAR data are nominal and unedited except
#	that some records were removed in editing temperature and salinity.
#
#    For details on how the transmissivity calibration parameters were calculated
#	see the document Transmissivity_Calculation.pdf.
#
#    The Oxygen:Dissolved:CTD calibration was done using the method described in 
#	the Sea-Bird Application Note #64-2 (Sea-Bird_64-2_Jun2012.pdf).
#
#    The Oxygen:Dissolved:CTD data are considered, roughly, to be:
#	±0.1 ml/l from 0 to 125 dbar.
#	±0.06 ml/l from 125 to 500 dbar.
#	±0.04 ml/l from 500 to 2000 dbar.
#	±0.02 ml/l below 2000 dbar.
#
#    For details on the processing see processing report: 2012-12-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5-- --6--- --7-- ---8--- ---9---
#!Pressu Temperat Salinity Sigma-t: Trans Oxygen Oxyge Fluores Fluores
#!re:CTD ure:CTD  :CTD     CTD      missi :Disso n:Dis cence:  cence: 
#!                                  vity: lved:  solve CTD:    CTD:   
#!                                  CTD   CTD:   d:CTD Seapoin Wetlabs
#!                                        Volume :Mass t              
#!------ -------- -------- -------- ----- ------ ----- ------- -------
#*END OF HEADER
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @4         data_max      @4         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     <P  .    pressure                	long_name         pressure   positive      down   units         decibar    data_min      @   data_max      @h        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      <P  jp   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d           temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?(\)   data_max      @$W   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       <P     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d        $   salinity                	long_name         salinity   units         PSS-78     data_min      @?1&y   data_max      @AL,<   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      <P 8   salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d       =   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @"ffffff   data_max      @sI   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        <P L   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d          CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?^5?|   data_max      @nO   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      <P     CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d       P   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       <P d   PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d          	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min      @G33333   data_max      @P33333   C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     <P .   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d       k   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( z,   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( zT   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      h   data_max      h   C_format      %10d       z|   latitude               	long_name         latitude   units         	degrees_N      data_min      @H_
=p   data_max      @H_
=p   C_format      %9.4f          z   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      _ꟾvȴ   data_max      _ꟾvȴ   C_format      %9.4f          z   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d        z   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d        z@4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @4      @@      @@       @!@$      @&      @'@*      @,      @-@0      @0     @2      @3      @4      @4@6ffffff@7      @8      @8fffff@;      @<      @=      @=fffff@@      @@     @A      @As33333@B&fffff@B     @C      @C     @D      @D     @D33333@Efffff@E33333@F     @G      @G     @H@I@I     @J      @JY@K@L      @Ls33333@M333333@M     @N      @N     @N33333@O     @P      @P@     @Py@P33333@Q      @Q9@Qfffff@Q     @R      @R@     @R     @R@S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @Vfffff@V     @W      @W@     @W     @W     @W33333@X@     @X     @X     @Y      @Y@     @Y     @Y33333@Zfffff@Z@     @Z     @Z     @[      @[@     @[y@[@\      @\@     @\     @\     @]      @]9@]fffff@]     @^      @^@     @^     @^     @_      @_9@_fffff@`      @`      @`@     @``     @`     @`@`@`     @a      @a      @a@     @a`     @a     @a     @a@a     @b      @b      @b@     @b`     @b@b     @b     @c      @c      @c@     @c\@c|@c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d33333@d     @e      @e@e@     @e`     @e     @e     @e     @e     @e@f      @f@     @f`     @f33333@f33333@f     @f     @g      @g      @g9@g`     @g     @g     @g     @g     @h      @h#33333@h9@h\@h     @h     @h33333@h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j@k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @lC33333@l`     @l     @l     @l     @lfffff@m      @m      @m@     @m`     @m     @m     @m33333@m     @n      @n      @n@     @n`     @n     @n33333@n33333@n     @o      @o#33333@o@     @o`     @o|@o@o     @o     @p@p     @p      @p1@p@     @pP     @p`     @pp     @p     @p     @p     @p@p     @p33333@p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r1@r@     @rP     @r`     @rp     @r     @r     @r@rfffff@r     @r     @r     @r     @s      @s     @s      @s1@s@     @sP     @s^fffff@sp     @s     @s     @s     @s     @s@s     @s     @s     @t      @t     @t      @t.fffff@t>fffff@tP     @t`     @tp     @t     @t33333@tfffff@t33333@t     @t     @t     @t     @u      @u@u!@u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @ufffff@u     @u     @u@v33333@v      @v0     @v@     @vP     @v^fffff@vp     @v     @v     @vfffff@v     @v     @v     @v     @v     @v@w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w@wfffff@w     @w     @w     @x      @x     @x      @x0     @xA@xL@xd@xp     @x     @x     @x     @x     @xfffff@x     @x     @x     @y      @y     @y      @y.fffff@yC33333@yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @zfffff@z0     @z@     @zP     @z^fffff@z     @z     @z     @z     @z@z@zfffff@z     @{      @{     @{      @{0     @{>fffff@{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|fffff@|333333@|@     @|P     @|`     @|p     @|y@|33333@|     @|     @|     @|     @|     @|     @}      @}@}!@}0     @}@     @}P     @}`     @}p     @}     @}33333@}     @}     @}     @}     @}     @~!@~0     @~@     @~P     @~a@~p     @~@~     @~     @~     @~     @~񙙙@~@@      @0     @@     @Q@Y@p     @     @     @     @@     @     @     @     @      @     @@@      @(     @0     @8     @@     @H     @P     @X     @`@h     @p     @x     @     @     @     @@     @33333@     @     @     @     @     @33333@@     @     @      @@@     @      @(     @0     @8     @@@S33333@X     @`     @h     @o33333@@     @     @     @     @     @     @     @     @@     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @G33333@Y@`     @h     @p@@     @     @     @     @@@@33333@     @     @     @fffff@陙@     @     @      @     @@     @      @(     @0     @8     @@     @H     @M@X     @`     @h     @p     @x     @|@     @     @     @     @fffff@33333@     @     @     @     @fffff@@     @     @     @      @     @     @@      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @fffff@@     @     @     @33333@     @     @     @     @홙@@      @     @@@$     @(     @0     @8     @@     @I@P     @X     @`     @h@o33333@x     @     @33333@     @     @     @     @     @     @@     @     @     @     @33333@񙙙@     @      @     @     @@      @(     @0     @8@@@H@P     @X     @`     @h@p     @w33333@     @     @     @@     @@     @     @     @     @33333@@     @     @     @33333@	@     @     @      @(     @0     @6fffff@@     @H     @P     @X     @`@g33333@p     @x     @     @fffff@@     @     @     @     @33333@@     @     @     @     @     @33333@ @     @     @     @      @%@8@@     @H     @P     @Y@^fffff@h     @p     @x     @     @     @     @@     @     @     @@@@     @     @     @fffff@     @     @     @      @(     @0     @4@H@P     @X     @`     @d     @rfffff@x     @     @     @     @@fffff@     @     @     @@33333@     @     @@fffff@      @fffff@     @     @      @(     @0     @6fffff@C33333@H     @P     @X     @`     @h     @nfffff@@     @     @     @33333@@33333@     @     @     @     @     @ݙ@fffff@     @     @      @@     @     @33333@)@0     @8     @@     @H     @P     @Zfffff@`     @h     @p     @x     @     @     @     @     @     @33333@     @     @     @     @     @     @@     @     @     @      @33333@     @     @ @(     @0     @8     @@     @H     @P     @W33333@i@p     @x     @     @@     @     @     @@     @     @     @fffff@     @     @     @33333@     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @w33333@33333@     @     @33333@33333@     @     @     @     @fffff@@     @     @     @     @      @     @     @     @33333@333333@8     @@     @H     @P     @U@c33333@h     @p     @x     @     @@fffff@     @     @     @     @     @     @fffff@     @     @     @     @     @     @      @@@     @      @(     @0@8     @@     @H     @P     @X     @`     @h     @p     @x@     @     @     @     @     @     @@33333@     @     @     @     @     @     @     @     @      @     @     @@     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @E@H     @L     @P     @T     @X     @a33333@d     @hfffff@l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @fffff@fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@fffff@     @      @     @@@     @     @     @     @      @$     @(@,     @0     @4     @8     @<     @@fffff@D@H     @L     @P     @T     @X     @\     @`     @c33333@g@l     @p     @t     @w@|     @     @fffff@fffff@     @     @     @     @     @@     @     @     @     @     @33333@@     @     @     @     @     @     @@@     @     @     @     @     @     @     @     @      @     @33333@
33333@     @     @     @fffff@fffff@$fffff@(     @,     @0     @4     @8     @<     @?@D     @H     @L     @P     @T     @X     @\     @`     @d     @hfffff@lfffff@p     @t     @x     @|     @     @@@     @     @     @33333@fffff@     @     @@     @     @@     @     @fffff@fffff@33333@     @ә@@     @fffff@㙙@     @     @     @33333@33333@     @      @     @@     @     @     @     @     @      @$     @(     @+33333@0@4     @8     @<     @@     @D     @H@L     @O@T     @X     @\     @`     @dfffff@h     @l     @p     @t     @x     @|     @33333@     @     @     @     @     @     @     @     @@     @     @     @     @     @@     @     @     @     @     @     @     @fffff@fffff@     @     @     @     @     @      @	@     @     @     @     @fffff@$     @(     @,     @0     @4     @8     @;@B     @D     @H     @L     @P     @S33333@\     @`     @d     @h     @jfffff@p     @t     @x     @|     @     @33333@fffff@     @     @     @@@     @     @     @     @33333@     @     @     @     @     @     @     @ә@     @     @     @     @     @     @33333@     @     @     @      @@     @     @     @fffff@@     @      @$     @(     @,     @0     @4fffff@8     @<     @@     @D     @H     @L     @O@U33333@X     @\     @`     @d     @h     @k@t     @x     @|     @     @     @     @     @@     @     @     @     @33333@33333@     @     @     @     @@     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @fffff@      @@     @     @     @     @fffff@@      @$     @(     @,     @0fffff@4     @7@<     @@     @Dfffff@H     @L     @P     @T     @X     @[33333@`     @d     @g33333@lfffff@p     @t     @x     @|     @     @     @     @     @     @     @     @@@     @     @     @     @     @     @     @     @     @     @     @     @     @ۙ@     @     @     @fffff@@     @     @     @      @     @     @     @     @     @     @     @      @$     @'@,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @Ù@     @     @     @     @     @33333@fffff@     @     @     @     @     @@      @     @     @     @     @     @     @     @&     @(     @,     @0     @4     @733333@@fffff@D     @H     @L     @P     @T     @X     @\     @_@c@h     @l     @p     @t     @x     @|fffff@~fffff@fffff@     @     @     @     @     @33333@     @     @     @     @     @     @fffff@     @     @     @     @     @     @@33333@     @     @     @     @     @@ @     @     @     @     @     @     @$fffff@(     @,     @0     @3@=@@     @D     @H     @L     @Pfffff@Rfffff@Y@\     @`     @d     @h     @l     @p     @s33333@}33333@     @     @     @     @     @     @33333@@     @     @     @     @     @     @@@     @     @     @     @     @     @@     @     @     @癙@     @     @     @fffff@     @ @     @     @     @     @fffff@     @33333@      @$     @(     @,     @.fffff@4     @8fffff@;@@     @D     @H     @L     @Pfffff@Rfffff@Y33333@\     @`     @dfffff@g@l     @n@t@x     @|     @     @fffff@@     @     @@     @     @     @     @fffff@     @     @     @     @@     @     @     @     @     @@     @     @     @fffff@     @     @     @      @     @     @     @     @     @     @     @      @$     @,     @0     @4     @6@<fffff@@fffff@D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @pfffff@s@x     @|     @~@     @     @     @     @     @@     @     @     @     @     @fffff@fffff@     @     @Ù@fffff@     @     @     @     @     @ߙ@fffff@     @     @     @     @     @     @     @     @33333@     @     @(fffff@,     @0     @4fffff@6fffff@=33333@@     @D     @H     @J@T     @X     @\     @`@d     @h     @p     @t     @vfffff@|fffff@fffff@@     @     @     @     @     @@fffff@     @     @     @fffff@     @     @     @33333@     @Ǚ@     @     @     @@@     @     @fffff@     @     @     @     @     @      @fffff@     @     @     @     @     @33333@      @$     @(     @+33333@0fffff@4     @8     @<     @@     @D     @G33333@Lfffff@P     @T     @X     @\     @`     @d     @g33333@n     @p     @t     @x     @|     @fffff@33333@     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @33333@@     @     @     @     @33333@@     @     @뙙@@     @     @     @ fffff@@
33333@     @     @     @     @(@,     @0     @4     @8     @<     @@     @H@L     @P     @T     @X     @\     @^@h@l     @p     @t     @x     @|     @~fffff@33333@     @     @     @fffff@@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @/@3@8     @<     @@     @D     @H     @L     @O33333@U@X     @\     @`     @d     @h                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @$o @$2W@$H@$W@$jOv@$y@$u@$+a@$S@$Z@$IQ@$tj@$TɆ@$u%@$\N<@$ֻ@$8YK@$C,z@$A@$%+a@$_o@#fA@#%@"?	@!ᰉ'@!C\@!>BZc@!zݘ@!`u!@!
\@ @ nO@ [W>6@ Ϸr@ (@ T`d@ !.@ _p@ |u"@ fL/{J@ T*1@ ?b}V@ 6@ #wk@ @ l"h	@ 
	 @ K]c@C]@_o @@Gz@Q@Y@N;@Z1@a@O@_@_o @q@͞@:)z@$tS@v}Vl@o@l<쿱@kQ@l"h	ԕ@jJL@d/@a-w1@_	@]}H@]ce@`
qu@_o@Iԕ*@;m]@4m8@-w1@&IQ@wkP@T`d@ 4m@@'RT`@ңS&@ěS@a|Q@wkP@Ʌoi@}Vl!@oiDg8@ffffff@]+j@K҈@<64@6E@&@!o@-V@Z@s@kP@h	ԕ@āo h@\(@Vϫ@\@U=@fB@@d8@@@~vȴ9X@{A@qo@l!-w@iB@g,@[6@Sݗ+k@O'/W@DJM@?b}V@:S&@+jf@2a|@ۋq
@T`d@s@Ƨ@]cA@@ [7@"`@-V@O;d@a@O@D@I^5@@@C@|쿱[@usg@oO
M@lq@iᰉ'@iy@Y_o@73@t@5Xy@l@-@`A@䎊qj@g8}@e@Ϫ͞@@As@o h@yrGE8@s@mB@ka@@kC]@l>B[@o{J#:@nzG@ix@g-@f,<@dZ1@_o@U2a|@?˒:)@873@2ᰊ@)B@Ov_@I^5@eں@hr!@*0U2a@@ރ%@@N@@A [@Xe,@-w1@@N@TɅ@lD@ۋq
@@M@L_@s@\N@&IR@~ߤ?@wrG@oO
M@g8}H@cZ@\C,zx@W&@R:)y@As@6!.I@+a@@+C,z@&fffff@;dZ@u%@@sP@)^@o @!R<@
=p
@tj@빌~($@u%F@*0U@ʌL_@š@M:@ȴ9Xb@a@N@Q@'RT@;dZ@jOv`@[u%@G+I@B&IR@*~"@y@@B@-V@xQ@RsP@HK]c@G)^@I'RTa@GE84@@IQ@/v@T@jOv@($x@T@wKƧ@\N;@P$tT@F?@`-
@*0U@D@!.H@I^5?@y=c@$TɆ@%`A7L@%O
@N;@sP@ u!@>BZc @g8}@E@PH@!.@Fs@:~ @}v@{~$@d7@oO
M@3@7KƧ@,<@ߤ@@ⶮ}Vm@Xy=@zG@r@g	@'@y=c@v_ح@5Xy>@	 @8YK@BZc @?@n@lVϪ@D?@7KƧ@"`A@I^5?@bh	ԕ@WO;d@X@@Zvȴ@Z6C@\wkP@[6@m8Y@ěT@̘_@ce@],=@p'RT@IQ@r Ĝ@v@֡a@m8@\@r@D@dZ@*0@)_@qj@@jfB@WO;d@A:S@
O;dZ@;dZ@?@Ft@
=p@Ϫ͟@ֻ@ק&@+@ק&@A7K@ރ%@d8@䎊qj@$t@4J@,"h	ԕ@1-@)*0U2a@PH@$/@M@DJM@;5Xy@3g	l@(TɅ@ߤ?@Xy=@`A@~"@M@d8@l!-@Zc@'0@Q@_o @&IR@4m@~\N<@v+jg@eu@ao@cS&@aGz@[S@P)^@G#@F?@C%2@CnP@B74@>ߤ?@>
(@A@L@c
=p@M%@@NU@4D@,>B[@$%1@"wkQ@!'R@!@N@*g	@2W@$e@Q@B@p:@O;dZ@D*@3@"`@73@$/@irGE@ڹ@*0@O;@2a|@Q_@S@1'@e+@>BZ@=K^@䎊r@e@,=@#9@S@@tj@hۋq@}p
=@z)_@w3@sߤ@rs@q2W@qA [@mhr!@kP{@jJL@jJL@f'@b`A@_?@^5?|@^Ov_خ@^Q@\>@[=K^@V+J@QX@Nqi@K:)z@A@<PH@2-V@%zxl"h@"`A@u"@
L_@G{@Vϫ@kP@n.@+@v@&@յsh@ξߤ?@L_@Ƨ-@,zxl@{J#9@NU@!.H@PH@l"h	@ȴ9X@m\@D@U2a|@GE85@oiDg8@zG@ᰉ'@O
@+a@1.@~"@1@/V@y@D@ߤ@v@H@^@wk@A7K@u%@>6z@=p
@|hs@\(@TɅo@@M:@xF]@zH@@@1&x@1&x@]cA@vȴ9X@l"h	ԕ@iᰉ'@i*0U2a@g,@c	@aae@`u!@`A7K@_vȴ9@_?@^iB@]+j@YJE@RS&@O'/W@MjOv@6!.I@5sg@2䎊q@0:~ @.c	@*0U2a|@#S&@ d8@U=@S@>BZ@*1@nO@N;5@@\(@
(@s@u%F@+I@:S@J#9@4m@E@W@U=@+a@}H@ڟvȴ@y=c@@fA@ҽ<64@p:~@̲@jOv@:@Q@p:@eO@ĵ?@y@*0@{J#9@@($x@!.H@dZ@kP@ڹ@U=@Ov_خ@%@Ov_خ@5?|@}H@vȴ@D*@s@Zc@6@|hs@@4n@[W>@wKƧ@kQ@d7@],=@TO
M@K:)z@JڹY@H1&x@DJM@?|hs@0'RT@-\@+U=@)B@)*0U2a@'&@#Z@6@Ʌoi@S&@ݗ+k@*0U2@)^@{@I^5?@C%@JM@@@
:@	@
O;dZ@kP|@/Vϫ@@n@DJM@GzH@HeO@K҈@U$/@]+j@]}H@],=@;A@=ڹZ@CnP@DS@Dtj@C@?@9D@6+jg@3|@3ߤ@*JL@(Xy=@&'@%ڹ@"}Vm@!@N@쿱[W@ߤ@@<64@bM@ߤ?@
jOv@
jOv@
M:@C%@	7KƧ@@p
=@G{@E@[W>6@33333@8Y@lC@Z@R<6@iB@]ce@=K^@kP|@b}@_o@e+@ؓtj@*0@حU@*0@$tS@2a|@@N@n@$tT@cA \@ƍ@IQ@"@p
=@v@쿱[@D@4K@&x@q@B@*0U2a@\)@@fffff@TɆ@
=p@W>6z@e+@sh@Ϫ͞@m@tj~@o @:@_@L_@]cA@D@=p
@@%2@@}b@u!R@mV@i@i@ix@ix@g@`-
@\(\@Vl!-@T*1@PbM@H@>($x@333333@'-@"3@!Gz@حV@%@5?|@>@_o@,<@As@
M:@	@m\@I^5@eں@e@҈p;@Q_@ӎMj@@]cA@?@6@@r@U=@0
@'@vȴ9@R<6@k~(@|hr@x-
@jJL@jOv`@hr Ĝ@dqj@b}Vm@c	@_o@a|Q@hۋq
@kQ@jJL@nc	@kC,z@dqj@dZ1@cA [@ae@_?@\?@Zݘ@Xe+@XD*@W
=p@R<64@N+@@C@1o@1&x@0
(@2a|Q@0 ě@)lD@(Xy=@%u@#9@䎊r@Xe,@
O;dZ@	'RTa@@$/@F]c@E@Y|@oiDg8@hr!@Q@Dg8~@	k@䎊qj@حV@ڹY@JE@Ʌoi@@^@o@C,zx@\(@'/W@M:@S&@~\N<@u!R@w1@yrGE8@qiB@ix@d7@aGz@_?@Z1'@UϪ͞@A [7@8)@84֡b@<64@9XbM@2ᰊ@,q@*0U2a|@'-@"3@ߤ@@sh@sP@n@
(@#@ݗ@F]c@
1@
l@
	ԕ+@
%1@
e+@
ޞ@
ٳ|@
ԕ*1@
|@
/{J#@
n.@
Xy=@
J@
J@
}Vl@
a@@
͞&@
TɅ@
zxl"h@
	k@
쿱[W@
%@
u@
[@
u"@
IQ@
-V@
_o@
Xe,@
Z@
@N@
F]c@
~\N<@
x-
@
u%F
L@
u\(@
oiDg8@
d7@
]/w@
SZ@
N+@
IoiD@
B\(@
;5Xy@
7rG@
.1@
#wk@
tj~@
I^5?@
ڹY@
'/@
	 @
n.@!.@GE85@	@M@Ft@6@jOv@ǮzH@64@Vϫ@lD@'@^@wk@ae@[6@-
@-
@O
M@Mj@u%F@@~"@weں@sMjO@mhr!@l!-w@eO
@\N;@W@Jn@8}H@/r@+jf@+I^@)^@#
=p@ 'RT`@u%@$tS@$tT@q@u%F@&I@m\@73@kP@SMj@s@C@fffff@e+@/w@@2a|@_p@*0U@ΤT@Ƨ@a@N@W@=K^@=K^@U=@u%@vȴ@Xe,@bM@(@I^5@n.@I^5@ѷX@YJ@o @n.3@}H@@oiDg@~m\@~"@{J#9@y"`@weں@sPH@o4֡a@p:~ @hۋq
@de@YJE@J#9@G@@C,zxl@;A@(\)@[@@sh@R<6@PH@O;d@'/@
xl"h
@
Ov`@
A [@
5?|@
a@O@
s@
]cf@
s@
jOv@
E@
ߤ?@
ۋq@
sPH@
*0U@
͞%@
쿱[@
a|Q@
zG@
lD@
IQ@
,<@
xF]@
'RTa@
n/@
~"@
}ڹZ@
{lC@
{lC@
|#x@
{J#9@
xF@
sE@
t#@
w1@
tj~@
iᰉ'@
Y|@
V8YJ@
Sa@O@
`u!@
_?@
`A7K@
`d8@
`
qu@
^iB@
T*1@
M@
Ks@
G@@
;dZ@
4֡a@
-B@
#wk@
!R<6@
ߤ?@
p:@
K]d@
1&x@
_o@
n/@
tj@
F]c@
n.@
o hی@
nP@
:S@
 4m9@	˒:)@	"@	G{@	PH@	{m@	fffff@	D*@	Z@		 @	|#x@	y(@	tSMj@	q@	l[W?@	ffffff@	^5?|@	Vt@	P`A7@	RT`d@	M:@	H˒:*@	C$@	A [7@	?[W>@	2ᰊ@	,1&y@	'-@	&@	#
=p@	 ěT@	
@\(@C,z@څݘ@2a|@m@ҽ<64@,<@ҽ<64@N;5@*0U@p:~@)^@74@&IR@C@vȴ9X@BZc @j~#@[W>6@RT`e@C,zx@@n@L/{@k~(@u%F@?@%2@JM@nP@@4n@:S@x73@sg@jg	@c	@[q@O;dZ@K)^	@F-@C@B&IR@A [7@<n.@5Xy=@0{@+6z@%F
L0@Q@L_@.H@!R@#@SMj@g@#@Y|@+jg@	k~@j~@
=q@rGE@7@C,@e+@Gz@҈p@ߤ?@ݗ+j@W>6z@$@ٳ|@sPH@T`d@cA \@@ěS@Zc@E84@)@ᰊ@zG@TɅ@'RT`@6C@vȴ@qu!@Q@wkP@C,zx@@eO@{lC@y"`@vFs@p:~ @mC\@kQ@hۋq
@glC@jOv`@f1.@bM@^5?|@Xe+@R<64@L_@I@4m8@IQ@tj~@'/W@
M:@
	 @	 ѷ@oiDg@?@@Q@Ov`@%1@A [@唯O
@B@x@8}H@e@A [@rGE@+a@ݗ+j@E@]cA@)^@ߤ?@)_@#w@?|h@3@O
M@@x@S@o@qu!@u@u@u@hr @Vu@ݗ+@oiDg@%2@     @{~$@y(@y=b@xl"h	@wkP@vFs@u\(@tD@sPH@ql@p:~ @kC,z@Y>BZ@P`A7@H@D2W@BZc@>ߤ?@<Z@:^5?|@64K@4֡a@"`A@!-w1@u@wkP@Q@Xe,@n@
=p
@C\@SMj@g	@JL@%1@ݗ+j@Q_@1'@حU@>6z@8YJ@+@E@т@˒:)z@@ěS@@A@C-@a|Q@v@*0U2a@zxl"h@n.3@-
@U=@!-w1@-V@Q@S&@q@'/@=p
@ ѷ@@u%F
@~m\@|?@zC\@u\(@r䎊q@l[W?@jJL@iᰉ'@irGE@g	k@fA@f1.@dqj@a|Q@^҈p;@^5?|@]cA @\(\@YJE@Rm@M@IoiD@C@@NU@>ߤ?@=b@;5Xy@;dZ@84֡b@5?|h@0{@0 ě@0
(@/O
M@0{@0
(@-B@)@$/@$TɆ@#wk@"3@}H@N;6@@
@	 ѷ@$/@?@{J#9@#x@kP@!-w2@@\@fB@lC@A7K@ܑN;@@@Z@҈p:@)^	@@&IR@s@TɅo@n@6@[W>@|hs@@쿱[@~@^5?|@#w@)@}H@Xe@
(@x@tSM@U=@+J@@N@o @҈@b}V@kQ@aGz@Yb}@Vl!-@Y+@Z1'@[W>6z@ZY@S&@Sa@O@SZ@RT`d@N+@K)^	@GzH@F?@E8YK@5'0@(@!o@ 'RT`@,=@-V@Ov_خ@}H@[@}H@[@=K^@@@O
M@nO@bM@
qu"@Fs@JM@@!R@ ě@A [@쿱[W?@fB@唯O
@;dZ@+@E@ѷX@N;5@N;5@䎊@͞%@Ƨ@ʌL_@@m\@\N@&IR@ [7@|hs@BZc @n.@~($@rG@v@lD@S@u@$tT@L_@_o@?@@4n@˒:)@}Vl!@|#x@|?@xl"h	@ql@q@pD@q@p@lC@l[W?@irGE@bM@\>@W>6z@M@F]cf@As@=K]@9XbM@6E@5?@3ߤ@12W@1-@4m8@-w1@',@$TɆ@$xF@vȴ9@$tS@*0@҉@Vu@@.H@J#9@xl"h
@l"h	@_ح@Y|@䎊q@ᰉ'@,<@Z@حV@A7K@ޞ@fA@|@;dZ@5Xy>@K]c@4m@Z@'0@W@rG@m\@2X@a@@S@[6@}H@1&@O
M@qu"@ڹY@ ѷ@Q@@o hی@:S@     @}ڹZ@z@w+@v_ح@tj~@qiB@q@qiB@d7@`d8@_?@^҈p;@\N;@[W>6z@["`B@Zݘ@O͞@K)^	@I@GE84@F]cf@F-@F?@E84֡@G)^@GE84@Ca@N@A7Kƨ@@C@@NU@@n@@C@?@?@=<64@:^5?|@9~($@8}H@6z@2m\@.1@.2X@+U=@)@',@&@#9@ ěT@Q@u%F@ᰉ@҉@Mj@
=p
@	k~(@oiDg@o hی@b}V@E@s@ȴ9X@u!S@hr!@@u!@6@sPH@;dZ@n@E84@ [7@n@@vȴ9X@b@p
=@)_@E@9XbN@a|Q@r@r@ ě@Vϫ@1&y@$xG@&@L/{J@zxl"h@@o@C,zx@,<@e+a@@*0@Ov_@sP@u@sP@bM@qi@Mj@ݗ+@~\N<@}Vl!@zG{@z>B@z@vȴ9X@u%F
L@r ě@poiDg8@n.2@jfB@e@e`A7L@dZ1@a'R@`d8@_Ft@^iB@^҈p;@_Ft@^@]/w@ZQ_@VϪ͟@T`d@Rm@R䎊@QN;5@P{@O;dZ@M%@I^5?}@B74@BZc@A [7@<쿱[@6}Vl@5?@4֡a@3ߤ@1o@.}Vl@0
(@.zG@+a@@*d7@,=@Q@sP@hr @'/W@
L/{@	ԕ*@
	 @n/@:S@ $tS@ .H@ $t@ ($x@ E@ H˒@ +jg@ u!S@ 4֡a@ Ov`@ ۋq
@ lC@ 1.@ lC@ 唯O
@ 䎊qj@ 7@ Z1@ eO@ ⶮ}Vm@ ᰉ'R@ 
qu@ حV@ A7K@ (\@ ۋq@ а{@ cA \@ @ /{J#@ s@ D@ W'@ ɅoiD@ K]c@ ˒:*@ m\@ &IR@ b@ BZc @ ~@ )_@ ^5?|@ Y}@ #w@ 3@ KƧ@ Xe@ sg@ {@ {J#:@ }Vl@ F
L0@ !-w1@ u@ }H@ -V@ [@ @ Ov_@ )^@ qu"@ C%@ 'RTa@ n/@ JM@ n.@ }ڹZ@ {s@ wkP@ sPH@ t!-w2@ sPH@ rGE85@ qu!S@ q@ o@ o4֡a@ m(@ iDg8~@ cZ@ b@4@ `҈p@ `҈p@ _حV@ _o@ _;dZ@ ]+j@ ZQ_@ Y+@ Xy=c@ XbM@ Sa@O@ N+@ K)^	@ G@@ F?@ D*0@ C$@ BZc@ A [7@ ?|hs@ >
(@ <64@ ;dZ@ :)_@ 9Y}@ 84֡b@ 84֡b@ 73@ 6z@ 5sg@ 4֡a@ 2-V@ .}Vl@ )*0U2a@ &L/{J@ $xF@ "wkQ@  ěT@ Q@  'RT`@ 쿱[W@ Q@ Ov_خ@ }H@ vȴ@ PH@ @ @ @ '/@ 	 ѷ@ %2@ @  hۋq?ڹZ?>B?!.I?(?C,z?x?҈p?
qu?;dZ???b}?D*?fA?N;5??W'?ȴ9Xb?m\?2W?o i?a@N??[W>?vȴ9X?/V?'0? ě?*0U2a?n.3?o?u?0
)?$tT?~($x?eO?$/?|??y(?oiDg8?hr Ĝ?eڹ?a|Q?Xe+?R<64?O
M;?M?Fs?=p
=?=p
=??|hs?=b?:)y?1o?,zxl"?(\)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          @?hr@?5Xy>@?:@?B@?[@?zxl"@?<쿱@?1&y@?PH@?]ce@?"h	ԕ@?j~#@?1&y@?<쿱@?U=@?	@?£S&@?5Xy@?M:@?0U2a|@?!-w@@)_@@
v@@"Zc@@'kP@@/o@@0YJ@@1@@4xF@@<E@@@n@@B=p
@@Ba|Q@@B0
@@B ѷ@@Eݗ@@GfA@@H:~ @@JC\@@L#x@@MoiDg@@OK]d@@Qy@@SA [@@Thr@@V$t@@X@@Yy@@[%2@@^,<@@b͞&@@dZ@@eH˒@@f1@@g#@@jOv`@@mb@@p_F@@o䎊r@@rsP@@wO
M@@yoiD@@}ce@@;dZ@@PH@@@@!.I@@xF]@@[@@,<@@hr @@j~#@@/w@@     @@*0U2a@@)_@@e+a@@Z@@Ov_خ@@r Ĝ@@~($@@vȴ9X@@@@K]@@/V@@:)y@@`d@@IQ@@Gz@@ÅQ@@C,zx@@6@@u!S@@{m@@C%@@8YK@@[6@@o@@P{@@?@@@@c	@@ٙ@@ڹY@@%2@@7@@/w@@ce@@݄M:@@ݼn/@@Mj@@l"h	@@@@R<6@@3@@{m@@L_@@9@@m]@@҈@@Q@@@@B@@m\@@Ϫ͞@@(@@u@@捸@@As@@跀4m@@A [@@hr @@rGE8@@|Q@@陙@@2W@@ᰉ'@@)y@@`A@@G{@@"`B@@dZ@@ߤ@@a@O@@ߤ@@@wkP@@*0@@V@@%F
L@@84֡@@84֡@@zxl"h@@l!-@@4֡a@@1@@v@@!-w1@@>6z@@y@@|@@TɅ@@e+@@PH@@+@@Gz@@b}@@R<6@@B@@@@y@@N;6@@@@-V@@^5?|@@@4@@L_@@@@ ѷ@@=K^@@5Xy@@$@@@@tj@@j~#@@N;@@>B[@@84֡@@L_@@n/@@iB@@Ft@@8}H@@>6z@@As@@bM@@$xG@@eO@@
=q@@{@@TɅ@@`A7@@&x@@Q@@TɅo@@TɅo@@x@@oiD@@l@@n@@)y@@6C@@a|Q@@\(@@͞&@@䎊q@@S&@@҉@@	@@)^	@@33333@@@N@@F]c@@MjO@@MjO@@S@@a@N@@{J#9@@ߤ@@S@@$@@q@@m]@@~($@@C]@@lC@@Q@@҈@@(\@@2W@@Fs@@]ce@@zG@@%1@@5Xy@@|@@Q@@>B@@D@@7Kƨ@@rGE8@@rGE8@@7Kƨ@@@@@@@@o hی@@bM@@73@@-@@@@lC@@>6z@@;dZ@@     @@Dg8~@@0U2a|@@M:@@u"@@Q@@}H@@!R@@!R@@ڹZ@@zxl"h@@8Y@@1@@($x@@ڹ@@ᰉ@@ᰉ@@Ϫ͞@@
qv@@~($x@@q@@64@@zG@@1@@,<@@Mj@@v@@E84@@o@A 'RT`@A l"h	@A y=c@A n@A {@A 9Xb@A 4m@A )^@A F@A 4֡b@A e+@A 4m9@@@@@As@@
=p@@af@@BZc @@C]@@@@ߤ@@U=@@ߤ@@m]@@Z@@2W@@U=@@ߤ?@@,<@@E@@p:~@@[W>@A $xG@A u!@A )^@A ۋq
@A IQ@A )^@A p:@A@AQ@ADg8~@A7KƧ@A ѷX@A ˒:*@A K]c@@-@@Xe@@fffff@@_ح@@p:~@@"@@
M;@@@@Xe@@$tS@@,@@_o@@\(@@sPH@@{J#:@A *0U@A 
=q@A~($@As@Aԕ*@Ak~(@@zH@@ߤ?@@m\@@T@@@@p:~@@;5X@@
qv@@,=@@BZc @@1.@@\N<@@s@@c	@@s@@l!-@@z@@T@@}Vl@@Mj@@
=p@@v@@v@@8}H@@@A F]d@A @A l"h	@A n@A 4m@A TɅ@A ѷX@A PH@A+@AGz@A@Au%F
@Axl"h
@A^5?|@A@4n@A-V@A3@A3@A6C@AQ_@A>B@Ajf@AW>6z@A@N@A/{J#@A@A5?|@A%@AKƧ@ART`e@Ao@A
M;@AIQ@A]ce@AƧ@A{J#9@Aqu!@A5Xy@AlC@A@A\N@A1&y@A<쿱@AtSM@A#x@AZ@Ahr@A/@Au"@A@Ae@A+a@AY|@Ap
=@AڹZ@Ab@A(@A_o @A?@Ac	@A$t@A@AXe@ART`e@AXe,@Aeں@Av_ح@A{J#:@Avȴ9@A˒:)@ArGE9@A}H@A*0@A>BZc@AYJ@An@A-
@A	@A	TɅo@A	o hی@A	o hی@A	e+a@A	@A	lD@A
d7@A
<64@A
Y@A
n@A
@A
fB@A
D@A
C,@A
G{@A
 ѷ@A
fB@A
sP@AI^@A	@A)^	@Ag	l@Atj~@AQ@A~($@AQ@A%2@A@A"h	ԕ@A(\@A,<@AFs@AwkP@Aq@AC@AD@A
o i@AE@A
[@A
(@A
<64@A
F
L0@A
IQ@A
Vl!@A
p
=@A
=K@A
L/@A5?|@A}Vl@A@Aߤ?@Ax@A"@A!.I@A@AK]d@A'RT`@A$xG@A ě@AXy=@Ahۋq@AIQ@A9Xb@ATɅ@AěT@ATɅ@AěT@AѷX@A@A+@A:S@A=b@A:S@ArGE8@A@Ab}@AoiD@A@A_o@As@An@AOv`@AW'@Au%F
@A ě@AW@AsP@AsP@Ac	@A҉@A,zxl@AC%@AxF]@AE@AQ@Ag@A$@An.@AJ@AxF@A!-w2@AM:@AZ1@AcA \@A?@AC@AtSM@Am8@AwkP@AzG@Ao h@A@AJM@Ae@Ace@A+j@A@A@AϪ͞@Aᰉ@AE@A!R<@AR<6@A\N<@AiB@Ap:~@A%@AT@A@A+@A"@Ab}V@Av_ح@Ay@A|hs@A@A?@A	k@A@A@@A	ԕ+@A-
q@AU2a|@A˒:*@A-
@AIQ@A@A@Atj@A9Xb@A)^@AD@A ѷ@A*0U2a@A:S@ADg8~@Ahr @A|@A@AI^5@A1'@Ae+@A&IR@A3@A-V@A6C@AnO@Ad7@A~"@AW@AxF]@An.@A2W@A`d@Am8@AzG@Au"@AY|@Asg@Aݗ@An/@A(@A?@Ap:~@A+J@A$t@A2X@A&I@A1@Ax@AFs@A쿱[W@A@A@A@AFt@Av@A1@AKƧ@A$tS@A	k@A3@Avȴ9@A@Avȴ9@A@A-@A 
qu@A _F@A u!@A @@A!$/@A! [7@A!^@A!XbM@A!N;5@A!^@A!R<6@A!ᰉ'@A!.H@A"	 @A"1'@A"#9@A"6C@A":)y@A":)y@A"3@A":)y@A"JL@A"T`d@A"a|Q@A"^5?|@A"h	ԕ@A"ݘ@A" ě@A"sP@A"䎊q@A#'/@A#PH@A#=K^@A#@N@A#MjO@A#]cA@A#g	l@A#a@N@A#dZ@A#g	l@A#g	l@A#q@A#q@A#E@A#@A#\N@A$ߤ@@A$@A$!-w2@A$@A$9XbN@A$Fs@A$M:@A$SMj@A$VϪ@A$]ce@A$m8@A$o h@A$N;@A$_@A$zxl"@A$*0@A$hr@A%:@A%K]@A%K]@A%'0@A%[@A%2a|@A%IQ@A%sg@A%sg@A%M:@A%Xy=@A%n/@A%@A&@A&@A&4K@A&?@A&Ov_خ@A&L/{J@A&R<6@A&c	@A&vȴ9X@A&}Vl@A&IQ@A&$t@A&,<@A&@A&'@A&쿱[W@A&Fs@A')^@A',@A'8}H@A'As@A'y@A'zH@A'@A'+@A'rGE9@A(>BZc@A(D*@A(Q@A(_F@A(r Ĝ@A(˒:*@A(˒:*@A()@A(@@A(e+@A)@A)_p@A)4J@A)Dg8~@A)Q@A)rGE8@A)~($@A)^5?}@A*n@A*&IR@A*&IR@A*#9@A*&IR@A*:)y@A*Zc@A*u%F
@A*~"@A*0
@A*L/{@A*Y@A*74@A+nP@A+&@A+C,z@A+9@A+S@A+tj~@A+Q@A+wk@A+S@A+E@A+~($@A+6@A+ݗ+k@A+C]@A+@A,n.@A,J@A,Q@A,(\@A,9XbN@A,Fs@A,M:@A,PH@A,VϪ@A,Z1@A,cA \@A,tSM@A,?@A,?@A,N;@A,O
M@A,Ʌoi@A,@A,֡a@A,Ʌoi@A,Ʌoi@A,/@A,/@A,/@A,JM@A-o i@A-!.H@A-5Xy>@A-<64@A-L_@A-IQ@A-Y|@A-ڹZ@A-=K@A-ݗ@A-1@A-Ϫ͞@A-ڹ@A.Ov_@A.BZc @A.R<6@A.Vu@A.\N<@A._ح@A.fffff@A.iB@A.vȴ9X@A.qi@A.O;@A.T@A.6z@A.}Vl@A.t@A.҈p;@A.]cf@A.Mj@A/
=p@A/!-w1@A/+I@A/E84@A/KƧ@A/RT`e@A/_o@A/o@A/o@A/y@A/y@A/y@A/v_ح@A/4m@A/&@A/	@A/O;d@A/@A/ݗ+@A/$tS@A/$tS@A/	k@A/?@A/vȴ9@A/o @A/˒:)@A/@A/@A/@A/@A/rG@A/䎊r@A0     @A0bM@A0bM@A0*0U@A0@A0}H@A0'RT`@A0-
q@A073@A0>BZc@A0_F@A0l"h	@A0oiDg8@A0oiDg8@A0oiDg8@A0|@A0-
@A04m@A0D@A0D@A0C@A1rGE@A1@N@A17KƧ@A1A [@A1ae@A1o hی@A1rGE8@A1x@A1@A1@A1~($@A1o@A1@A1R<6@A1^5?}@A1D@A1@A1y@A1o@A1s@A2u%F@A2&IR@A23@A2GE85@A2@4n@A2JL@A2GE85@A2GE85@A2Q_@A2Zc@A2d7@A2kP|@A2u%F
@A2p:@A2vȴ@A2 ě@A2Y@A2@A2`A@A2sP@A2䎊q@A2䎊q@A2G{@A2C,@A2C,@A2c	@A2m\@A3PH@A39@A3P{@A3a@N@A3tj~@A3@A3eO@A3q@A3:)z@A3$@A3~$@A3~$@A3Mj@A3Q@A3eO@A3eO@A3Mj@A3$@A3$@A3ߤ@A3S@A3*0U2@A3S@A3ߤ@A464@A4SMj@A4q@A4m8@A4o h@A4*1@A4_@A4S@A4zxl"@A4O
M@A4O
M@A4j~@A4?@A4O
M@A4O
M@A4?@A4*0@A4>B[@A4@A4JM@A4>@A5[@A5!.H@A5+a@A5IQ@A5ce@A5fA@A5}H@A5w1@A5m\@A5m\@A5Y|@A5IQ@A5B@A5\@A5zxl"h@A5hr!@A58Y@A5@A5
qv@A5
qv@A5
qv@A58YK@A5ڹ@A6u@A6+jg@A6BZc @A6H@A6H@A6L/{J@A6c	@A6fffff@A6c	@A6p:~@A6iB@A6iB@A6l!-@A6iB@A6iB@A6fffff@A6l!-@A6l!-@A6+J@A6%@A6IQ@A6z@A6Q@A6Q@A6t@A6Ϫ͟@A6+@A61@A6C-@A6]cf@A61@A6쿱[W@A7@A7@A6"@A6!.I@A7Xe@A7;dZ@A78}H@A74֡a@A78}H@A7O
M@A7{J#:@A7@A7-V@A7͞@A7&@A7͞@A7zH@A7[W>@A7[W>@A7r@A7/V@A7[W>@A7˒:)@A7䎊r@A84m9@A8U2a|@A8@A7rG@A7Vϫ@A8F]d@A8	ԕ+@A8@A86@A8 ě@A8*0@A8*0@A8>BZc@A8D*@A8NU@A8Q@A8K]c@A8bM@A8|@A8'RT@A8@A8-
@A8@A8U@A8U@A89Xb@A8TɅ@A8@A8\)@A8$tT@A9@A9#w@A9:S@A9Dg8~@A9Dg8~@A9N;5@A9e+a@A9rGE8@A9o hی@A9u!S@A9|Q@A9|Q@A9@A9B@A9_o@A9@A9ԕ*@A9"`@A9@A9@A9s@A:u%F@A:n@A:I^5@A:s@A:@A:s@A:1'@A:-V@A::)y@A::)y@A:Q_@A:Q_@A:T`d@A:^5?|@A:^5?|@A:^5?|@A:a|Q@A:kP|@A:nO@A:u%F
@A:{m@A:p:@A:S&@A:0
@A: ě@A:g	@A:g	@A: ě@A:}Vm@A:}Vm@A:<64@A:n@A:sP@A:c	@A:~@A:D@A:c	@A:m@A:74@A;I^@A;I^@A;'/@A;nP@A;PH@A;	@A;&@A;33333@A;MjO@A;g	l@A;n.3@A;~$@A;~$@A;xF]@A;q@A;lC@A;$@A;$@A;@A;s@A<"h	ԕ@A</{J#@A<9XbN@A<<쿱@A<M:@A<VϪ@A<?@A<qj@A<*1@A<TɆ@A<?@A<#x@A<#x@A<@A<O
M@A<?@A<?@A<@A<?@A<#x@A<#x@A<j~@A<?@A<Z@A</@A</@A<>B[@A</@A<֡a@A<Z@A<!-w@A<!-w@A<!-w@A<!-w@A<E@A=[@A=IQ@A=\@A=m\@A=}H@A=$/@A=M:@A=ݗ@A=M:@A=U=@A=@A=8Y@A=@A=\(@A=
qv@A=,=@A=ᰉ@A=oiDg@A=ᰉ@A=C\@A=ڹ@A> ѷY@A> ѷY@A>
L/@A>zG@A>H@A>H@A>H@A>H@A>H@A>\N<@A>\N<@A>_ح@A>fffff@A>p:~@A>z@A>vȴ9X@A>vȴ9X@A>z@A>IQ@A>}Vl@A>IQ@A>%@A>qi@A>qi@A>,<@A>ߤ?@A>A@A>ߤ?@A>ߤ?@A>C-@A>쿱[W@A>@A>Mj@A>Fs@A>"@A>Fs@A>@A>@A>x@A>쿱[W@A>"@A?@A?)^@A>"@A>!.I@A?Ft@A?
=p@A?
=p@A?,@A?'/W@A?.H@A?'/W@A?+I@A?'/W@A?+I@A?1@A?;dZ@A?_o@A?o@A?v_ح@A?|hs@A?@A?	k@A??@A?͞@A?/V@A?vȴ9@A?@A?o @A?˒:)@A?@A?fA@A?@@A?-@A?+j@A?#@A@	ԕ+@A@F]d@A@	ԕ+@A@}H@A@$xG@A@'RT`@A@-
q@A@H@A@Q@A@_F@A@eO@A@hۋq@A@l"h	@A@l"h	@A@u!@A@u!@A@|@A@YJ@A@@A@YJ@A@'RT@A@-
@A@IQ@A@@A@U@A@@A@
=q@A@d8@A@{@A@)@A@TɅ@A@ěT@A@p:@A@D@A@҈p@A@ۋq
@A@҈p@A@`A7@A@`A7@A@C@A@\)@AA ѷ@AA	k~@A@$tT@AA@N@AA_p@AA*0U2a@AA [7@AA&x@AA&x@AA-w1@AA4J@AA4J@AA:S@AAN;5@AATɅo@AAae@AAe+a@AAae@AAae@AAhr @AAk~(@AAo hی@AA|Q@AAoiD@AAoiD@AA7Kƨ@AAu@AAB@AAB@AA'R@AAB@AA'R@AA'R@AA'R@AAX@AA^5?}@AA^5?}@AA^5?}@AA^5?}@AA@AA@AAD@AAo@AAiB@AA>BZ@AAs@ABu%F@AB	 @ABu%F@AAlD@AA-@AA>BZ@AAԕ*@AA@AAԕ*@AAe@AA.H@ABn@AB	 @AB@ABs@AB䎊@AB#9@AB#9@AB1'@ABOv`@ABOv`@ABe+@AB&IR@AB6C@AB6C@ABGE85@ABM@ABT`d@ABW'@ABW'@ABa|Q@ABd7@ABh	ԕ@ABh	ԕ@ABh	ԕ@ABkP|@ABxl"h
@AB@4@ABp:@ABᰊ@ABL/{@ABL/{@ABL/{@ABY@AB<64@AB@AB͞&@AB,<@AB,<@AB ѷ@ABfB@AB䎊q@ABc	@ABc	@ABc	@ABm\@ABm\@AB~@AB~@ABm\@AB~@ABm\@ABm\@AB74@AB~@ABm\@AB~@ACu%@ACs@AC	@ACPH@ACs@ACs@AC,zxl@AC/V@AC33333@AC9@AC=K^@ACC%@ACF]c@ACF]c@ACF]c@ACW>6z@ACa@N@ACa@N@ACa@N@AC]cA@ACdZ@ACjf@ACa@N@ACeO@ACq@ACwk@ACm]@ACƧ@AC5Xy@AC҈@AC҈@AC҈@ACݗ+k@ACݗ+k@AC%2@ACg@ACC]@ADJ@ADxF@ADJ@ADxF@AC\N@AD@AD@AD"h	ԕ@AD"h	ԕ@AD2W@ADPH@ADPH@ADZ1@ADVϪ@ADcA \@AD`d@AD`d@ADq@ADC@AD#@ADqj@AD1&@ADO
M@AD#x@AD*0@AD@ADu"@AD@ADD@AD@ADZ@ADhr@ADJM@AEu@AEK]@AE'0@AEK]@AEV@AE[@AE*0@AEu@AE5Xy>@AE+a@AE/w@AE/w@AE/w@AE/w@AE5Xy>@AE2a|@AE5Xy>@AE<64@AE?|h@AEF
L0@AEIQ@AEIQ@AEY|@AEY|@AEVl!@AEp
=@AEm\@AEsg@AEw1@AEM:@AEM:@AE$/@AEM:@AEݗ@AEݗ@AEڹZ@AE!R@AE!R@AEhr!@AEO
@AEhr!@AE=K@AE1@AE\(@AE\(@AE\(@AEn/@AE@AE8Y@AE@AE@AE@AE8Y@AE\(@AEcA @AEϪ͞@AEb@AE?@AES@AEᰉ@AEᰉ@AEᰉ@AE(@AEڹ@AF ѷY@AF ѷY@AF ѷY@AF ѷY@AFt@AF
L/@AF@AFzG@AFzG@AF@AF@AFOv_@AF$/@AF+jg@AF8YJ@AF;5X@AFH@AFR<6@AFVu@AFc	@AFiB@AFs@AF}Vl@AFqi@AF+J@AFqi@AF%@AF%@AF%@AF@AF-@AF2X@AF'@AFQ@AF'@AF2X@AF'@AF&I@AFm\@AFm\@AFm\@AF&I@AFm\@AF҈p;@AFϪ͟@AF]cf@AFߤ?@AFC-@AFx@AFFs@AG hۋ@AF!.I@AF!.I@AG@AGFt@AG
=p@AGv@AG!-w1@AG$tS@AG+I@AG'/W@AG+I@AG1@AG8}H@AG;dZ@AG;dZ@AG>6z@AGKƧ@AGO
M@AGKƧ@AGXe,@AG_o@AG_o@AG_o@AGeں@AGb}V@AGiDg8@AGo@AGo@AGsPH@AGy@AGy@AG|hs@AG|hs@AG|hs@AG|hs@AG{J#:@AG	@AG@AG͞@AG͞@AGzH@AG3@AG˒:)@AGo @AG˒:)@AG˒:)@AG˒:)@AG+@AGحV@AG@AGfA@AG@AGrGE9@AGrGE9@AH
qu@AH*0U@AH ě@AH'RT`@AH}H@AH-
q@AH:~ @AHD*@AHH@AHD*@AHH@AHK]c@AHH@AHQ@AH_F@AHeO@AHl"h	@AHu!@AHr Ĝ@AHy=c@AH|@AH|@AHn@AH'RT@AHn@AH'RT@AH@AH'RT@AHIQ@AHu%F@AHu%F@AHIQ@AHd8@AHU@AHD@AHe+@AHۋq
@AHۋq
@AHD@AHe+@AH`A7@AH`A7@AH`A7@AH`A7@AH4֡b@AH	k@AI	k~@AI@AI@AI_p@AI@AI [7@AI*0U2a@AI*0U2a@AI&x@AI4J@AI:S@AI:S@AI=b@AI:S@AIQ@AIQ@AI[W>6@AIQ@AITɅo@AI[W>6@AI^@AIk~(@AIo hی@AIx@AI|Q@AIb}@AI7Kƨ@AI7Kƨ@AIR<6@AIn.@AIn.@AI'R@AIX@AID@AI2W@AIy@AIo@AIo@AI_o@AI2W@AI@AIᰉ'@AIs@AIs@AIs@AI@AI@AI@AIY}@AI-@AIlD@AIlD@AI.H@AJu%F@AJ	 @AJ䎊@AJ0U2a|@AJ@4n@AJGE85@AJM@AJQ_@AJa|Q@AJ^5?|@AJh	ԕ@AJd7@AJnO@AJu%F
@AJu%F
@AJxl"h
@AJ{m@AJqiC@AJL_@AJp:@AJL_@AJL_@AJS&@AJvȴ@AJS&@AJ@AJ@AJ>B@AJ ě@AJg	@AJY@AJ<64@AJ<64@AJ<64@AJn@AJ@AJ@AJ ѷ@AJc	@AJC,@AJm@AJc	@AJ~@AJ~@AK'/@AK'/@AKs@AKPH@AK"`B@AKPH@AK)^	@AK,zxl@AK)^	@AK,zxl@AK/V@AK6z@AK6z@AK=K^@AK=K^@AKC%@AKJ#9@AKJ#9@AKMjO@AKP{@AKW>6z@AKW>6z@AKW>6z@AKZ@AKW>6z@AKa@N@AKn.3@AKn.3@AKxF]@AK~$@AK~$@AKQ@AKq@AKA@AKU=@AKS@AKm]@AKE@AK~($@AK5Xy@AK|@AK5Xy@AKQ@AKg@AK$@AKA [@AKA [@ALn.@AL1&y@ALn.@ALߤ@@ALߤ@@AL!-w2@AL"h	ԕ@AL,<@AL(\                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          @r@r@r@rfffff@r     @r@r     @r@r@r@r     @r33333@r33333@rfffff@r     @r33333@r@s9@sI@s1@s     @r(     @r{33333@rfffff@r33333@qy@qp     @q\@qFfffff@qfffff@q33333@q@p     @pљ@p@p@ps33333@pt@p     @pfffff@p     @p@p4@p>fffff@p;33333@p0     @o33333@o33333@o     @n33333@nfffff@n@n@nfffff@m33333@m33333@n     @n	@l      @l@k@jfffff@j@j,@i@i@i	@hfffff@hfffff@h333333@g陙@gfffff@g`     @f33333@f	@e@ei@e)@e0     @e&fffff@d@cC33333@c	@c      @cFfffff@cY@c6fffff@b     @afffff@ay@as33333@a     @a@a     @as33333@`@`     @`@`     @`fffff@`fffff@`fffff@`<@`<@`@     @`I@`Ffffff@`@     @`6fffff@`<@`)@`#33333@`)@`6fffff@`9@`<@`6fffff@_@_     @_     @_@_@_@_l@^@^ٙ@^@^     @^@^33333@^@^fffff@^33333@^@^@^33333@^fffff@^     @^y@^l@^l@^     @^@^l@^@]33333@]ٙ@]fffff@]fffff@]ٙ@]&fffff@\fffff@\@\@\33333@\33333@\fffff@[@\33333@\@\      @\&fffff@\@\      @\&fffff@\&fffff@\&fffff@\&fffff@\,@\      @\      @\fffff@\fffff@\      @[33333@[33333@[fffff@[l@[ffffff@[ffffff@[ffffff@[ffffff@[L@[      @Z@Z@Zffffff@Z      @Y`     @Xfffff@X     @Xs33333@X      @X      @W     @W@Wfffff@Wl@WFfffff@W@V33333@Vfffff@V     @Vfffff@V@Vl@V333333@U@U     @Ufffff@UL@T@Tٙ@T     @T@T@Tfffff@Tfffff@T@T     @Ty@Ts33333@Tl@TY@T@     @T9@T333333@T333333@T      @T@S@S@Sfffff@Sfffff@Sfffff@S@S     @Sl@SS33333@SY@Sl@S     @Sfffff@T9@Tfffff@U@     @UY@U`     @U`     @UFfffff@U@     @U,@Ul@Uٙ@U33333@U@U33333@Ufffff@V@V     @V@Ufffff@U333333@Tfffff@S@     @Rfffff@R@     @Q@Q     @Q33333@Q@Q@Q     @Q9@Qfffff@Q@     @QS33333@Q`     @QY@QY@Q33333@R@Q@QS33333@P@Pfffff@Pfffff@P33333@O     @OY@Nfffff@Nfffff@Ns33333@NL@N@N@M33333@M@Mfffff@Mfffff@N@N@N@N333333@O      @P33333@P@Q,@Ql@Q     @Q     @Q     @Qs33333@P33333@P      @OY@O&fffff@OY@O     @Oٙ@M      @Lfffff@L@Lfffff@L33333@MY@M@Kٙ@K@K@K     @K     @K     @L&fffff@L     @M@Mfffff@N&fffff@N333333@M33333@M     @Mffffff@ML@ML@M&fffff@M@M@M@M      @M      @L333333@Jfffff@J@J@J@J@J     @L     @Lfffff@L33333@L33333@L33333@M&fffff@ML@M@M@L33333@Lٙ@L     @L33333@L@L@Ls33333@L333333@L      @L      @L      @L@L@Jfffff@J@J     @JL@J@Iٙ@I@Is33333@IY@I&fffff@I      @H33333@Hٙ@Hfffff@G@G     @G@G@G     @G33333@Gfffff@G@G      @Ffffff@Ffffff@F@F&fffff@EL@Dffffff@D@D&fffff@DL@DL@D@D@     @D@Dٙ@E33333@E     @E@E     @E     @Es33333@E     @EY@D     @Dfffff@D@D@Dfffff@Dfffff@D@D&fffff@D@D@D333333@D333333@D@     @D@     @C@C&fffff@C333333@CL@CL@C@     @B@B@B      @A33333@A@A@A     @A     @A     @A&fffff@A@A@A&fffff@A@     @A@     @AL@@L@@L@@s33333@@@@fffff@@@>33333@>@?      @?      @?@?@>      @>      @=fffff@>      @>      @>@>      @=333333@=333333@=L@=333333@=L@=@<      @;fffff@;@;@;33333@;@;L@;333333@;      @:@:@:@:ffffff@:L@:333333@:      @:@:      @:      @933333@9ffffff@9@8@8@7fffff@8      @8      @8      @8      @7@6@6L@6ffffff@6     @6@6@633333@5@5@533333@5@533333@5     @5L@5L@5L@5L@5ffffff@5ffffff@4@5@5      @5333333@5333333@4333333@4@4333333@4@4@3@3ffffff@3@3ffffff@3ffffff@3L@3@3      @233333@2     @2     @2@2@2ffffff@2ffffff@2L@2@2L@2L@2L@2L@2@2@2@2@2      @1@133333@1@1@1L@1333333@0@0@1      @1      @1      @0@0ffffff@0L@0ffffff@0L@0L@0333333@0@/@/@/@/ffffff@/ffffff@/@/@/      @.@.@/333333@/333333@/      @-@.      @.333333@.      @.      @.      @-@-@.      @-@-@-333333@-333333@-333333@-333333@,@,@,@,@,@,@,@,@,@,@,@,333333@+@+333333@+333333@+      @+333333@+333333@+333333@*      @*333333@)@*333333@*@(@(@)333333@)333333@)333333@(      @(333333@(ffffff@(@(ffffff@'@'@(      @'@'@'@'ffffff@'333333@'333333@'      @&@'      @'      @&@&@&333333@&ffffff@&ffffff@&ffffff@&333333@%ffffff@%ffffff@%333333@%ffffff@%@%@%      @%      @%      @%333333@%333333@%333333@%      @$@$@$@$@$@$@$@$@$ffffff@$ffffff@$ffffff@$      @$ffffff@$333333@$ffffff@$@$      @$333333@$333333@$      @$333333@$333333@$      @#@#@$      @$      @#@#@#@#@#@#@#@#@#@#@#@#@#@#ffffff@#@#ffffff@#@#333333@#333333@#333333@#333333@#ffffff@#333333@"@#      @#      @#      @#      @#      @#333333@#      @#333333@#333333@#333333@#333333@#333333@#      @#333333@#333333@#      @#333333@#      @"@"@"@"@#333333@#333333@"@"@#      @#      @#      @"@"@"@"@"@"@"@"@#      @"@"@"@"@#      @#      @"@"@"ffffff@#      @#333333@"@"@#      @#      @#      @#      @#      @#      @#      @"@#333333@#      @#333333@#333333@#      @#333333@#333333@#333333@#ffffff@#333333@#333333@#      @#ffffff@#333333@#333333@#ffffff@#333333@#333333@#ffffff@#333333@#ffffff@#ffffff@#ffffff@#ffffff@#333333@#ffffff@#333333@#@#@#ffffff@#ffffff@#333333@#@#@#ffffff@#333333@#@#333333@#@#ffffff@#ffffff@#333333@#333333@#      @#333333@#ffffff@#333333@#@#333333@#@#ffffff@#ffffff@#@#ffffff@#@#333333@#ffffff@#@#@$      @$      @$      @$      @$      @#@$      @$      @$      @$333333@$      @$      @$      @$333333@$      @$333333@$333333@$      @$      @$      @$      @$      @$      @$      @$      @$      @$333333@$      @$333333@$333333@$ffffff@$333333@$333333@$ffffff@$333333@$ffffff@$333333@$ffffff@$333333@$333333@$333333@$ffffff@$      @$333333@$333333@$333333@$ffffff@$333333@$ffffff@$@$ffffff@$333333@$@$@$ffffff@$ffffff@$@$@$@$@$@%      @$@$@$@$@$@$@$@$@$@$@$@%      @%333333@%333333@%333333@%333333@%      @%333333@%333333@%333333@%333333@%333333@%ffffff@%ffffff@%      @%333333@%@%ffffff@%@%@%@%ffffff@%@%@&      @&333333@&      @&333333@&      @&333333@&ffffff@&333333@&333333@&333333@&333333@&333333@&ffffff@&ffffff@&333333@&@&ffffff@&@&ffffff@&ffffff@&@&@&@&@&@'      @&@&@&@'      @&@'      @'333333@'      @'333333@'      @'      @'333333@'      @'333333@'      @'333333@'      @'333333@'333333@'333333@'@'@'@'ffffff@'ffffff@'@(      @(      @(333333@(      @'@'@(      @(      @(333333@(333333@(ffffff@(@(ffffff@(@(@(@)333333@)      @(@)      @)333333@)      @)333333@)333333@)      @(@(@)      @)333333@)333333@)ffffff@)@)@)@)@)@)@)@)@*@)@*      @*333333@*@*@*ffffff@*ffffff@*ffffff@*@*ffffff@*@*ffffff@*ffffff@*@*@*@*@*@*@*@*@*@+      @+333333@*@+      @*@+333333@+333333@+333333@+      @+333333@+333333@+333333@+333333@+ffffff@+@+ffffff@+@+@,      @,      @,      @,ffffff@,      @+@,ffffff@,333333@,      @,333333@,333333@,333333@,@,@,ffffff@,ffffff@,@,333333@,@,@,ffffff@,ffffff@,@,333333@,333333@,333333@,333333@,333333@,@,@,@,@-333333@-ffffff@-ffffff@-      @,@-      @-333333@-333333@-333333@-@-ffffff@-@-@.ffffff@.ffffff@.ffffff@.ffffff@.ffffff@.@.@/      @.@.@/      @/      @/333333@/ffffff@/@/@/333333@/333333@/@/@/@/@/@0      @0      @0333333@0      @0333333@0@0333333@0@0L@0333333@0@0333333@0333333@0333333@0     @0L@0ffffff@0ffffff@0ffffff@0ffffff@0     @0ffffff@0ffffff@0     @0@0@0     @0@0@033333@033333@033333@033333@0@0fffff@0@0fffff@0fffff@0fffff@0fffff@1      @1      @1@1333333@1333333@1L@1     @1     @1ffffff@1L@1fffff@2      @2333333@2333333@2      @2333333@2@2     @2     @2@2fffff@2@2fffff@2@233333@2@3      @3      @3@3@3@2fffff@2fffff@3@3      @3333333@3333333@3@3333333@3333333@3@3      @3333333@3@3333333@3333333@3333333@3     @3ffffff@3L@3L@3ffffff@3333333@4333333@4L@4333333@4      @4      @4      @3fffff@4@4@4@4ffffff@4ffffff@4     @4fffff@4@4@4@4@4fffff@5@5      @4fffff@4fffff@5      @5ffffff@5L@5     @5     @5ffffff@533333@5@5@533333@533333@5@5@533333@533333@533333@5fffff@5fffff@5@5fffff@6333333@6ffffff@6L@6333333@6L@6L@6@6ffffff@6     @6     @6     @6     @6     @6     @6@6     @6     @6@6     @6     @6L@6     @6@6@633333@6@6fffff@6fffff@633333@6@6@7L@7L@7L@7333333@7L@7333333@7@7@7fffff@8      @7fffff@7fffff@8@8      @8@8333333@8333333@8@8@8333333@8ffffff@833333@8     @8     @833333@833333@8@8fffff@9      @9@9333333@9333333@9333333@9333333@9L@9333333@9     @9L@9L@9ffffff@9ffffff@9ffffff@9     @9@933333@9@9@9@9@9fffff@9fffff@:      @:      @:@:      @:@:@:      @:      @:333333@:L@:L@:     @:     @:ffffff@:L@:@:33333@:33333@:@:33333@:fffff@:fffff@:fffff@:@:@;@;333333@;333333@;333333@;@;@;     @;     @;     @;33333@;     @;@;@;33333@;fffff@;@<      @<@<      @;fffff@<      @<      @;fffff@<      @<      @<      @<333333@<333333@<333333@<ffffff@<ffffff@<ffffff@<@<@<@<     @<     @<     @<     @<     @<@<@<33333@=      @=      @<fffff@=      @=333333@=@<fffff@=@=@=@=@=@=L@=ffffff@=     @=     @=33333@=33333@=@=33333@=@=@=@=33333@=@=@>333333@>L@>@>333333@>L@>ffffff@>     @>     @>@>@>@>fffff@>@>fffff@>33333@>@?333333@?@?      @?@?@?333333@?@?@?333333@?333333@?@?@>fffff@?      @?333333@?@?     @?ffffff@?L@?ffffff@?333333@?@?33333@?@?@?@?fffff@@      @?@?fffff@@      @@@@@@@@@@@@      @@@@s33333@@@@s33333@@Y@@L@@L@@fffff@@fffff@@fffff@@33333@@fffff@@fffff@@@@@@ٙ@@ٙ@@fffff@@fffff@@ٙ@@     @@     @A@     @A333333@A@A333333@A&fffff@A&fffff@A@A     @As33333@Affffff@Affffff@As33333@A     @A     @A     @A     @A     @A@A@B      @B@B@B@A33333@Afffff@Afffff@B@     @BL@BY@BL@BL@B@     @B333333@B&fffff@Bffffff@Bffffff@Bs33333@B@Bs33333@B     @B     @B     @B@B@Bfffff@B@B@B@B@B33333@Bfffff@Bfffff@Bfffff@Bfffff@Bfffff@Bfffff@Bٙ@Bٙ@C      @C      @C@C&fffff@C&fffff@C@C@C@C@C@     @CL@CL@C@     @C@     @C333333      @CL@CY@C@     @C@     @CL@C@     @Cffffff@Cffffff@Cs33333@C     @C@C@C@Cs33333@Cs33333@C@Cfffff@C33333@Cfffff@C33333@C     @Cfffff@Cٙ@Cfffff@D@C33333@Cfffff@D      @D@D&fffff@D333333@D@     @D@     @D&fffff@D&fffff@D     @D@D     @Dfffff@D@Dffffff@D33333@D     @D     @Dfffff@Dfffff@E      @D33333@E@E      @D33333@E      @E@E@E@E@E@E@E333333@E&fffff@EL@E&fffff@E&fffff@E333333@EY@EY@E@     @EL@Es33333@Es33333@E     @Es33333@E     @E@Efffff@E@Efffff@E33333@E33333@E     @E     @Eٙ@E@Efffff@Eٙ@Eٙ@Efffff@F      @F@F@F      @F      @F@F&fffff@F333333@F@F@F333333@F&fffff@F333333@F333333@F333333@FY@FL@F     @F@F@F@F@Ffffff@Ffffff@F33333@F@F@F@F33333@F     @F33333@F33333@Ffffff@F@G&fffff@G333333@G333333@G@G&fffff@GY@GL@GY@GY@G333333@G     @Gffffff@GY@G     @G@G@G33333@G33333@G33333@G@G@G     @Gٙ@G@Gٙ@Gٙ@Gfffff@Gٙ@G33333@G33333@G33333@H      @H      @H@     @H@     @H333333@H333333@HL@HY@HY@HY@HY@H333333@H     @Hffffff@H@H     @Hfffff@H33333@H     @Hfffff@H33333@H     @H33333@H@Hٙ@Hfffff@Hٙ@H@Hfffff@I@I@I      @I      @I      @I@     @I@     @IY@IL@I333333@I&fffff@Is33333@I     @I     @Ifffff@Ifffff@Ifffff@Is33333@Is33333@Iٙ@Iٙ@I@I@I@I     @I     @J      @J      @J      @J@J&fffff@J&fffff@J@J@J@J&fffff@J@     @J333333@J333333@J333333@J&fffff@Js33333@J     @J@J@J     @JY@J@Jfffff@Jfffff@J33333@J@J     @Jٙ@Jٙ@J     @Jfffff@J33333@Jfffff@J33333@Jfffff@Jfffff@K@K&fffff@K&fffff@KY@KY@K&fffff@K&fffff@Kffffff@KY@Ks33333@K@     @KL@K&fffff@KY@K@K@K@K     @Kfffff@Ks33333@K     @K33333@Kfffff@K@K@K@K33333@L&fffff@L@L@L@L&fffff@L&fffff@L&fffff@LL@L@     @LL@LL@LY@L@     @LY@Lffffff@Ls33333@L     @Lffffff@L     @L     @L     @L@Lfffff@L@L     @L     @L     @L@L33333@M      @M      @M@M333333@M@M@M333333@ML@Ms33333@M     @M     @M     @M     @ML@ML@M@M     @M     @M33333@Mfffff@Mfffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ?m?7KƧ?㕁$/?Gz?A7Kƨ?-V?j~#?p
=q?$/?=p
=?+??~"?xF?񙙙?-V?Ƨ-?+I?\(?;dZ?j~"?nO;?E@+@
bM@7KƧ@
`A7@hr @vȴ9@E@
Q@
=p@1&x@nO@r Ĝ@+I^@"`B@1&@\(@"`B@
tj@Z1'@	j~#@5?|h@I^5?}@1&@ (\)?lC?$/?zG?XbM?/v?ěS?+?^5?|?1&?-V?r ě?C$?+?zG?E?+J?nP? ěT?Ձ$/?/w?ҟvȴ9?n?=p
=?Ѻ^5?|?n?$/?hr Ĝ?&x?&x?bM?I^5??;dZ?5?|h?j~"?ə?ȓtj~?(\)?ȴ9XbN?C$?/v?I^5?}?Ƨ-?"`B?ȓtj~?+?ȴ9Xb?ǮzG?n?C$?ffffff?+I^?E?ěS?ěS?
=p
?333333?hr Ĝ?nO?E?nO?Õ$/?Ł$/?Ƈ+I?
=p?\(?Ł$/?S?tj?`A7L?"`?hr Ĝ?tj~?tj?Q?/w?M?M?hr Ĝ?I^5??\(?M?ļj~#?\(?I^5??Õ$/?\(?nP?      ?7KƧ?`A7?bM?Q?Z1'?l?bM?n?-V?M?Q?vȴ9X?333333?GzH?M?GzH?
=p?A7Kƨ?&x?S?nO;?bM?I^5??$/?`A7?`A7L?GzH?M?ěS?$/?nO?S?I^5??öE?nO;?-V?l?tj~?Q?l?lD?&x?M?333333?tj?tj?I^5??\(?° ě?I^5??I^5??M?öE?nP?M?\(?S?° ě?A7Kƨ?I^5??Õ$/?S?`A7?+?Q?-V?GzH?n?7KƧ?I^5??l?° ě?`A7?7KƧ?Q?-V?lD?-V?A7Kƨ?° ě?tj~?-V?333333?lD?° ě?vȴ9X?Q?hr Ĝ?nO;?nO;?\(?`A7L?lD?A7Kƨ?lD?° ě?hr Ĝ?S?Õ$/?S?-V?nO?`A7?tj~?l?333333?\(?n?S?I^5??GzH?l?M?S?° ě?nO;?öE?° ě?M?n?A7Kƨ?7KƧ?9XbM?ěS?M?nO;?l?l?-V?M?-V?-V?7KƧ?hr Ĝ?l?hr Ĝ?nO;?-V?tj?
=p?M?
=p?ěS?hr Ĝ?I^5??öE?-V?° ě?7KƧ?9XbM?° ě?333333?M?nO?E?ļj~#?nO;?I^5??S?$/??|hs?&x?l?Q? ěT?7KƧ?nO;?nO?7KƧ?nP?-V?-V?° ě?nO?nO?S?
=p?n?nO;?bM?M?öE?tj~?-V?l?;dZ?`A7?nO?Gz?|hr?tj~?ěS?M?° ě?GzH?n?nO?I^5??l?M?M?M?nO;?7KƧ?n?Õ$/?nO?`A7?7KƧ?      ?ļj~#?\(?`A7K?\(?GzH?Q?$/?`A7?/w?l?`A7K?Õ$/?Q?Ł$/?\(?`A7?$/?333333?tj~?\(?tj~?° ě?7KƧ?Õ$/?`A7?° ě?-V?n?7KƧ?`A7L?`A7?tj~?7KƧ?nO;?^5?|?nO;?S?vȴ9X?"`?I^5??S?Õ$/?\(?S?ļj~#?Q?      ?l?nO?lD?tj~?Q?`A7?Õ$/?S?&x?nO;?Z1'?nO?+?`A7?I^5??Q?Q?M?° ě?ěS?° ě?/w?° ě?&x?n?5?|h?&x?333333?° ě?Q?Q?7KƧ?I^5??n?
=p?+?Q?Q?Q?`A7L?`A7?&x?lD?lD?GzH?$/?S?-V?Õ$/?S?šo?9XbM?öE?Z1'?\(?nO?&x?° ě?l?I^5??nP?Q?nO;?333333?Q?ļj~#?M?° ě?-V?bM?Q?l?`A7?GzH?hr Ĝ?+?9XbM?-V?I^5??A7Kƨ?A7Kƨ?öE?+?
=p?\(?M?&x?`A7?-V?° ě?
=p?ļj~#?nO;?° ě?Q?$/?&x?
=p?GzH?Õ$/?öE?`A7?$/?vȴ9X?° ě?333333?E?7KƧ?-V?S?7KƧ?
=p?zG{?nO?-V?I^5??tj~?S?;dZ?`A7?7KƧ?I^5??M?n?\(?      ?M?I^5??\(?&x?tj~?333333?S?tj?`A7K?\(?+?I^5??-V?333333?&x?GzH?9XbM?nO?Q?Õ$/?l?`A7?
=p?tj~?333333?zG{?&x?° ě?tj~?I^5??M?ěS?ļj~#?Ł$/?n?Z1'?nO?`A7?n?-V?zG{?° ě?tj~?° ě?M?333333?
=p?/w?`A7L?A7Kƨ?GzH?öE?nO;?M?333333?/w?S?GzH?hr Ĝ?nO?-V?öE?Õ$/?° ě?tj?9XbM?tj~?$/?+?zG{?l?Q?/w?nO;?nO;?333333?E?tj?tj~?l?Õ$/?Q?\(?nO?-V?
=p?l?I^5??333333?tj~?tj~?ļj~#?`A7?nO;?bM?`A7L?-V?333333?nO?tj~?° ě?\(?`A7?zG{?7KƧ?S?-V?`A7L?\(?zG{?° ě?S?-V?tj~?333333?I^5??nO;?ěS?&x?M?Q?tj~?° ě?ěS?Z1'?$/?ļj~#?nO;?l?
=p?9XbM?tj~?lD?7KƧ?\(?öE?Õ$/?l?nO?\(?šo?`A7?`A7?l?ěS?nP?tj?öE?öE?S?nO?lD?9XbM?Q?+?333333?`A7?tj?bM?\(?333333?+?333333?tj~?nO;?vȴ9X?`A7?
=p?l?+?S?° ě?`A7L?-V?9XbM?\(?Õ$/?S?zG{?tj?$/?7KƧ?9XbM?Z1'?lD?nO;?lD?I^5??nO;?Õ$/?tj?\(?GzH?333333?Z1'?zG{?Ł$/?S?
=p?zG{?`A7L?tj~?öE?S?° ě?+?7KƧ?tj~?lD?° ě?Z1'?S?M?333333?vȴ9X?9XbM?`A7?Z1'?Õ$/?+?Õ$/?° ě?Ł$/?`A7K?9XbM?-V?nO?bM?7KƧ?šo?`A7K?9XbM?nO;?lD?Õ$/?ěS?° ě?
=p?-V?333333?`A7?`A7?GzH?-V?tj~?tj~?Q?öE?tj~?ěS?9XbM?S?nO?Õ$/?S?
=p?+?l?-V?Q?tj~?GzH?
=p?-V?-V?-V?° ě?GzH??|hs?S?šo?`A7?šo?-V?\(?A7Kƨ?9XbM?öE?E?l?333333?M?S?/w??|hs?S?+??|hs?Ł$/?° ě?`A7K?9XbM?`A7?333333?+?M?9XbM?
=p?&x?° ě?ļj~#?tj~?
=p?ěS?x?E?S?+?\(?Õ$/?
=p?ěS?Z1'?S?333333?tj~?Z1'?\(?zG{?Q?333333?° ě?-V?tj?lD?öE?`A7K?E?tj?Z1'?S?/w?9XbM?9XbM?öE?-V?l?Q?tj?nO;?l?Q?° ě?`A7K?tj?Õ$/?nO;?+?9XbM?\(??|hs?l?Ł$/?Õ$/?M?9XbM?9XbM?+?/w?-V?7KƧ?Q?tj?
=p?333333?333333?S?l?S?° ě?+?S?-V?tj~?ěS?Z1'?M?lD?lD?Õ$/?/w?nO;?nO?zG{?I^5??nO;?zG{?öE?tj?lD?I^5??Ł$/?\(?lD?zG{?9XbM?`A7?+?
=p?I^5??`A7K?tj~?nO;?tj?\(?E?-V?nO;?/w?333333?GzH?GzH?+?\(?\(?A7Kƨ?hr Ĝ?M?
=p?° ě?M?° ě?333333?      ?S?I^5??
=p?S?\(?-V?-V?° ě?tj?tj?
=p?/w?Q?-V?° ě?Õ$/?9XbM?M?° ě?zG{?M?-V?+?tj?-V?Õ$/?GzH?S?öE?öE?/w?S?\(?M?nO?lD?/w?9XbM?Õ$/?tj?333333?nO;?+?l?nO?-V?`A7?nO;?I^5??nO;?7KƧ?° ě?ļj~#?Õ$/?nO?S?333333?$/?\(?`A7?ļj~#?E?E?tj?&x?-V?nO?zG{?° ě?tj~?nO?`A7?tj~?333333?
=p?Z1'?lD?\(?+?hr Ĝ?\(?n?\(?`A7?GzH?nO?ěS?I^5??333333?Õ$/?ěS?
=p?\(?Q?&x?nO?`A7K?+?ļj~#?Q?E?° ě?tj~?I^5??+?333333?S?Z1'?333333?\(?333333?+?n?-V?\(?S?+?-V?nO?333333?\(?° ě?tj?öE?
=p?nO;?`A7?333333?tj?
=p?\(?ļj~#?tj?333333?l?° ě?`A7K?tj~?hr Ĝ?`A7?
=p?
=p?+?S?nO;?öE?S?333333?tj?333333?9XbM?I^5??`A7?$/?° ě?-V?ļj~#?tj~?ěS?9XbM?nO;?M?333333?
=p?° ě?-V?9XbM?šo?I^5??/w?Õ$/?`A7?S?
=p?/w?nO;?nO;?S?zG{?nO?nO?I^5??nO?S?S?-V?GzH?E?tj?9XbM?tj?zG{??|hs?tj?M?tj?Q?lD?S?+?hr Ĝ?nO;?-V?lD?l?E?l?7KƧ?/w?
=p?zG{?tj?n?A7Kƨ?
=p?GzH?Q?9XbM?
=p?ļj~#?Q?tj?nO?ěS?`A7?`A7?
=p?Z1'?M?333333?9XbM?`A7L?lD?S?hr Ĝ?+?nO;?hr Ĝ?S?nO;?nO?° ě?zG{?
=p?\(?lD?lD?9XbM?\(?333333?öE?M?ěS?`A7?ěS?+?ěS?`A7?Q?`A7L?S?
=p?M?7KƧ?ěS?nO;?$/? ěT?nO;?\(?n?\(?tj?bM?-V?S?7KƧ?l?&x?-V?M?E?E?\(?° ě?lD?A7Kƨ?7KƧ?Õ$/?`A7?-V?S?Ł$/?öE?333333?l?
=p?M?
=p?l?I^5??`A7?Õ$/?tj~?hr Ĝ?Q?$/?-V?° ě?-V?öE?° ě?° ě?bM?Q?lD?\(?
=p?n?7KƧ?nO?Z1'?9XbM?ěS?Õ$/?333333?° ě?
=p?ļj~#?S?öE?-V??|hs?`A7?-V?nO;?\(?tj~?ěS?E??|hs?tj?`A7?E?M?\(?tj~?M?lD?tj?l?l?333333?° ě?M?333333?M?\(?lD?nO;?n?GzH?9XbM?-V?nO?hr Ĝ?nO;?Õ$/?9XbM?Q?S?öE?Õ$/?
=p?`A7K?-V?nP?° ě?l?-V?nO?tj~?hr Ĝ?tj?ěS?7KƧ?öE?GzH?\(?$/?7KƧ?7KƧ?Q?\(?n?`A7?I^5??Õ$/?`A7?nO;?° ě?-V?A7Kƨ?7KƧ?7KƧ?nO?$/?hr!?7KƧ?Õ$/?ļj~#?I^5??nO;?M?
=p?M?-V?
=p?Õ$/?-V?Q?Õ$/?nO;?-V?I^5??Q?-V?\(?`A7?° ě?Q?ěS?nO;?l?-V?`A7?ěS?nO?l?tj?Z1'?/w?+?`A7L?n?nO;?nO;?Q?Õ$/?9XbM?Q?`A7L?lD?Q?bM?Q?A7Kƨ?ěS?ěS?° ě?\(?n?hr Ĝ?bM?l?° ě?I^5??
=p?tj?bM?nO;?333333?l?-V?M?333333?-V?$/?-V?ěS?öE?nO?7KƧ?`A7?`A7?
=p?nO;?I^5??nO;?I^5??`A7?\(?&x?nP?Z1'?tj~?° ě?Z1'?S?
=p?n?GzH?Õ$/?M?l?S?S?nP?S?I^5??S?Q?
=p?ěS?öE?
=p?I^5??° ě?lD?nO;?A7Kƨ?nO;??|hs?nO?S?`A7?I^5??nO;?GzH?l?\(?\(?
=p?GzH?GzH?tj~?lD?hr!?&x?A7Kƨ?|hr?Q?
=p?-V?tj~?9XbM?S?nO?M?lD?-V?-V?n?vȴ9X?nO?bM?vȴ9X?I^5??lD??|hs?-V?lD?M?tj~?° ě?333333?333333?7KƧ?M?      ?A7Kƨ?nP?hr Ĝ?      ?7KƧ?šo?nO;?tj?333333?A7Kƨ?Q? ěT?$/?-V?
=p?&x?|hr?A7Kƨ?n?Õ$/?;dZ?Q?333333?Z1'?-V?I^5??-V?-V?`A7L?7KƧ?9XbM?l?nO?Z1'?"`? ěT?7KƧ?`A7K?nO;?
=p?I^5??Q?Õ$/?-V?ěS?A7Kƨ?bM?I^5??° ě?E?333333?M?-V?7KƧ?`A7?-V?nO;?hr Ĝ?-V?GzH?I^5??tj~?\(?I^5??-V?&x?l?tj~?bM?A7Kƨ?-V?$/? ěT?GzH?I^5??7KƧ?-V?Q?-V?n?I^5??hr Ĝ?nO;?hr Ĝ?GzH?hr Ĝ?$/?nP?-V?° ě?vȴ9X?-V?nO;?+?nO;?hr Ĝ?Õ$/?-V?° ě??|hs?-V?-V?7KƧ?zG{?nO;?`A7?nO;?Q?hr Ĝ?ěS?nO?ěS?&x?Õ$/?\(?tj?l?nO?Z1'?+?
=p?I^5??
=p?tj?hr Ĝ?nO;?lD?
=p?l?bM?`A7L?
=p?Q??|hs?° ě?
=p?nO?-V?Q?lD?"`? ěT?Q?7KƧ?lD?Q? ěT?hr Ĝ?M?I^5??&x?A7Kƨ?\(?tj?l?nO;?Q?° ě?lD?333333?I^5??lD?tj?\(?GzH?vȴ9X?° ě?tj?`A7?lD?`A7?ěS?7KƧ?\(?M?hr Ĝ?hr Ĝ?;dZ?ěS?S?I^5??-V?nO;?9XbM?Q?Õ$/?Q?`A7L?I^5??I^5??M?nP?° ě?A7Kƨ?I^5??A7Kƨ?hr Ĝ?lD?hr Ĝ?Q?      ?I^5??n?7KƧ?7KƧ?nO;?\(?vȴ9X?-V?Q?ěS?nO?-V?-V?n?"`?$/?"`?-V?n?hr Ĝ?öE?nO;?n?vȴ9X?bM?° ě?E?n?Q?$/?hr Ĝ?vȴ9X?Q?&x?n?lD?9XbM?-V?$/?nO?n?zG{?7KƧ?S?hr Ĝ? ěT?$/?n?Q?-V?$/?`A7L?lD?bM?|hr?Q?n?I^5??bM?GzH?p
=q?° ě?nP?° ě?7KƧ?nO;?I^5??nO;?I^5??
=p?hr Ĝ?I^5??nO;?nO?Q?333333?Q?nP?bM?`A7?vȴ9X?$/?7KƧ?vȴ9X?E?nO;?Q?ěS?-V?Õ$/?GzH?`A7?GzH?bM?Q?\(?M?9XbM?nO?nO;?bM?333333?n?° ě?tj~?nO?lD?-V?333333?° ě?ěS?-V?&x?° ě?Q?1&y?&x? ěT?E?333333?9XbM?l?\(?;dZ?A7Kƨ?A7Kƨ?A7Kƨ?nO;?ěS?-V?lD?5?|h?n?I^5??Q?7KƧ?&x?+?lD?Z1'?GzH?n?&x?Q?+?I^5??&x?-V?`A7L?&x?n?/w?nP?vȴ9X?Q?-V?S?\(?333333?hr Ĝ?-V?-V?7KƧ?° ě?&x?Õ$/?° ě?7KƧ?
=p?hr Ĝ?° ě?7KƧ?nP?
=p?GzH?7KƧ?lD?`A7L?bM?E?&x?lD?l?l?° ě?-V?Q?hr Ĝ?&x?nO?$/?lD?Q?;dZ?lD?Q?A7Kƨ?nO?n?A7Kƨ?5?|h?`A7?I^5??lD?"`?`A7?ěS?A7Kƨ?l?7KƧ?j~"?-V?$/?\(?`A7L?ěS?|hr                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	@Jffffff@JY@J     @J     @J     @J     @J333333@J@J@Jfffff@Js33333@Js33333@J     @J33333@K      @K@Kffffff@L@L@L33333@L@L33333@L@Kfffff@J33333@J     @J@     @JL@J@K      @Jfffff@G33333@I33333@IY@I&fffff@I@I@     @I@     @H@I@I33333@JY@K     @Kffffff@K     @L@Ms33333@Ms33333@ML@N@N&fffff@N     @N33333@Nfffff@N33333@N@N@N     @N33333@O      @O333333@O      @Offfff@Oٙ@Oٙ@P      @Offfff@P      @Pfffff@P      @Pfffff@Offfff@Pfffff@P      @Pfffff@P      @P      @Pfffff@P@P@P      @P@P@P@O33333@P@Pfffff@P      @P      @P      @P      @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P33333@P      @P@P33333@P      @P&fffff@P&fffff@P      @P,@P,@P&fffff@P,@P9@P@     @PFfffff@P9@P@     @PL@P9@P@     @PFfffff@P@     @PFfffff@PL@PFfffff@PL@PFfffff@P9@P9@PL@PL@PS33333@PS33333@PS33333@PS33333@PS33333@PS33333@PS33333@PS33333@PL@PY@PY@PS33333@PY@P`     @P`     @P`     @P`     @PY@PY@P`     @P`     @PY@PS33333@PS33333@PS33333@PS33333@PL@PL@P@     @PFfffff@PS33333@PS33333@PY@P`     @PY@P`     @P`     @P`     @Pffffff@P`     @Pl@Pl@Pffffff@PS33333@Ps33333@Py@Ps33333@Py@Py@P     @Pfffff@Pfffff@Pfffff@P@P@P@P33333@P@P33333@P@P33333@P     @P@P     @Pfffff@P@P     @Pfffff@Pfffff@P@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@P@Pfffff@P     @Pfffff@P33333@P     @Pfffff@Pfffff@P@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@P33333@P33333@P     @P@Pfffff@Pfffff@P@P@P33333@P33333@P@P@P@P33333@P33333@Pfffff@P33333@P33333@P33333@P33333@P@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P@P@P@P@P@P@P     @P@P     @P     @P@P@Pfffff@P     @P@P     @P     @P@P     @P     @P     @Pfffff@P     @P@P     @P33333@P@P@P     @P33333@P@P33333@P     @Pfffff@P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@P     @P     @P     @P     @P     @Pfffff@Pfffff@P     @P@P     @Pfffff@P@P@P@Pfffff@Pfffff@P@P@P@P@P@Pfffff@Pfffff@Pfffff@P33333@P@P@P@Pfffff@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@Pfffff@P     @Pfffff@P@P33333@P@P@P33333@P33333@Pfffff@P33333@P@Pfffff@P@P33333@Pfffff@Pfffff@P@P33333@P33333@P@P33333@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@P33333@P33333@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P@Pfffff@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @Pٙ@P     @Pٙ@P33333@Pٙ@Pٙ@P     @Pٙ@Pٙ@P@P     @P     @P     @P     @Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pٙ@P     @P     @Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P33333@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@Pfffff@P     @Pfffff@P@P@P@P@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@Pfffff@Pٙ@Pfffff@Pfffff@P@P@P@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P@Pfffff@P@P@P@Pfffff@P@P@P@P@P@P@P@P@Pfffff@P@P@Pfffff@Pfffff@P@P@Pfffff@P@P@Pfffff@Pfffff@P@P@P@P@P@P@Pfffff@P@P@Pfffff@P@P@Pfffff@P@P@P@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P33333@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @P     @P     @P     @Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @Pٙ@P     @Pٙ@P     @P     @P     @P     @P     @Pٙ@P     @P     @P33333@Pٙ@Pٙ@P     @P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pٙ@Pٙ@P     @Pٙ@P     @P     @P     @Pfffff@Pfffff@P     @P     @P     @P     @P     @P     @P     @Pfffff@Pfffff@Pٙ@Pfffff@Pfffff@P     @P     @P     @P     @P     @P     @Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pٙ@Pfffff@Pfffff@Pfffff@Pfffff@Pٙ@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pٙ@P     @P     @P     @Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pٙ@P     @Pfffff@P     @Pfffff@P     @P     @Pfffff@P     @P     @P     @P     @P     @Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P@P@P33333@P33333@P@P@P@P@P@P@Pfffff@P@P@P     @Pfffff@P@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P@P     @P     @P     @P     @P@P     @Pfffff@Pfffff@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P@P@P@P@P@P@P33333@P@Pfffff@P     @P     @P     @P@Pfffff@P@P     @P     @P     @P     @P@P@P33333@P@P33333@P@P@P     @P     @P     @Pfffff@P@P@Pfffff@P     @P@P@P     @Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P33333@Pfffff@P     @P@P33333@P33333@P@P@P@P33333@P@P@P@P@P@Pfffff@P@P@Pfffff@P@P@P33333@P@P@P@P@P@P@P33333@P@P33333@P33333@P33333@Pٙ@P33333@P33333@Pٙ@Pٙ@Pٙ@Pٙ@P@P33333@Pٙ@P33333@P33333@P     @P33333@P@P33333@Pٙ@Pٙ@Pٙ@Pٙ@P@P@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@P33333@P33333@P33333@Pfffff@P33333@P33333@Pٙ@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P     @P@P@P@P33333@P33333@P33333@P33333@P@P33333@P33333@P@P@P33333@P     @Pٙ@P@P33333@P33333@Pfffff@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@P33333@P@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @Pٙ@P     @P     @Pfffff@P     @Pfffff@Pfffff@P     @P     @P     @Pfffff@P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pٙ@P     @Pٙ@Pٙ@P     @P     @P     @Pٙ@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@P     @P     @Pٙ@Pٙ@P     @P     @Pٙ@Pٙ@Pٙ@P     @P     @Pٙ@Pٙ@P     @P     @Pٙ@P     @P     @P     @Pfffff@Pfffff@Pfffff@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pٙ@P     @P     @Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@Pٙ@P     @P     @P     @P     @P     @Pٙ@Pٙ@P     @Pٙ@P     @P     @P     @P     @P     @P     @Pٙ@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @P     @P     @P33333@P33333@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@Pٙ@Pٙ@P     @Pfffff@P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@P     @Pfffff@Pfffff@P     @Pfffff@P33333@P33333@Pٙ@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@P     @P     @P     @P     @P     @P     @Pfffff@Pfffff@Pٙ@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@P     @Pfffff@Pfffff@Pfffff@P     @Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@P     @P33333@P@Pfffff@P     @P     @P     @P     @P     @P     @Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P@P@P33333@P@P@P@P@P@P@P@P@P33333@P@P@Pfffff@Pfffff@Pfffff@P@P@P@P@Pfffff@Pfffff@P@P@P@P@P@Pfffff@Pfffff@P@Pfffff@P@P@Pfffff@Pfffff@Pfffff@P@P@P@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@Pfffff@Pfffff@P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P@Pٙ@Pfffff@P@P@Pfffff@P@P@P@P@P@P@P33333@P33333@P@P@P@P@P@P33333@P33333@P@P@P@P33333@P33333@P33333@P@P33333@P@P@P33333@P33333@P     @P@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P@P@P@P@P@P@P@P33333@P@P@Pfffff@P@P33333@P33333@P@P@Pfffff@P@P@P@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@Pٙ@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@P@P@Pfffff@Pfffff@P@P@P@Pfffff@P     @P@Pfffff@Pfffff@Pfffff@P@P@P@P@P@Pfffff@P@P@P@Pfffff@P@P@Pfffff@P@P@P@P@P@P@Pfffff@Pfffff@P@P@Pfffff@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P33333@P33333@P33333@P@P@P@P@P@Pfffff@P@P@P@P@P@P33333@P@P@P33333@P@P@P@P33333@P33333@P@Pfffff@P@P@P@P@P@Pfffff@P@P33333@P@P33333@P@P@P@P@P33333@P@P@P@P@P@Pfffff@P@P@P@P@P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P@P@P@Pfffff@Pfffff@P@P@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@Pfffff@P@P@P@P@P@Pfffff@P@P@P@P@P@Pfffff@Pfffff@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P@P@P@P@P@P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          P6                                      1                                       hBBRT3