CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20120522   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P35    CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:48.363550Z    ORIGINAL_HEADER      sCTD,20250210CCHSIOWB
#Renamed 'CTDFLUOR_TSG' to 'CTDFLUOR_ALT_1' with units 'MG/M^3'
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2018-11-29. CTD data from cruise 18DD20120522, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20120522. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2012-12/index.php. 
#
# The information in this file for the cruise 2012-12 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-0072.ctd
#
# Start of originator file comment header
#
#*2018/11/29 14:22:51.16
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2012/06/01 08:02:46.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 2006
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : C44EDC1F
#    NUMBER OF CHANNELS  : 9
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            2.3            2006.7
#       2 Temperature:CTD               deg_C_(ITS90)   1.9166         6.6907
#       3 Salinity:CTD                  PSS-78          32.6639        34.5892
#       4 Sigma-t:CTD                   kg/m^3          25.6458        27.6748
#       5 Transmissivity:CTD            %/m             61.4           67.9
#       6 Oxygen:Dissolved:CTD:Volume   ml/l            0.41           7.23
#       7 Oxygen:Dissolved:CTD:Mass     µmol/kg         17.9           314.7
#       8 Fluorescence:CTD:Seapoint     mg/m^3          0.24E-01       0.74
#       9 Fluorescence:CTD:Wetlabs      mg/m^3          0.102          1.096
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        6  F       ' '     1
#       6  -99   ' '        7  F       ' '     2
#       7  -99   ' '        6  F       ' '     1
#       8  -99   ' '        8  F       ' '     3
#       9  -99   ' '        8  F       ' '     3
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2012-12
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P24
#    EVENT NUMBER        : 72
#    LATITUDE            :  49  50.17000 N  ! (deg min)
#    LONGITUDE           : 142  40.04000 W  ! (deg min)
#    WATER DEPTH         : 3989
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    CTDEDIT was used to remove surface records and records corrupted by shed
#	wakes; salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Transmissivity, Fluorescence and PAR data are nominal and unedited except
#	that some records were removed in editing temperature and salinity.
#
#    For details on how the transmissivity calibration parameters were calculated
#	see the document Transmissivity_Calculation.pdf.
#
#    The Oxygen:Dissolved:CTD calibration was done using the method described in 
#	the Sea-Bird Application Note #64-2 (Sea-Bird_64-2_Jun2012.pdf).
#
#    The Oxygen:Dissolved:CTD data are considered, roughly, to be:
#	±0.1 ml/l from 0 to 125 dbar.
#	±0.06 ml/l from 125 to 500 dbar.
#	±0.04 ml/l from 500 to 2000 dbar.
#	±0.02 ml/l below 2000 dbar.
#
#    For details on the processing see processing report: 2012-12-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5-- --6--- --7-- ---8--- ---9---
#!Pressu Temperat Salinity Sigma-t: Trans Oxygen Oxyge Fluores Fluores
#!re:CTD ure:CTD  :CTD     CTD      missi :Disso n:Dis cence:  cence: 
#!                                  vity: lved:  solve CTD:    CTD:   
#!                                  CTD   CTD:   d:CTD Seapoin Wetlabs
#!                                        Volume :Mass t              
#!------ -------- -------- -------- ----- ------ ----- ------- -------
#*END OF HEADER
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @R        data_max      @R        C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     >x  .    pressure                	long_name         pressure   positive      down   units         decibar    data_min      @	   data_max      @^   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      >x  l   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d           temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?n   data_max      @wk   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       >x     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d        (   salinity                	long_name         salinity   units         PSS-78     data_min      @@Y^   data_max      @AJC,   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      >x    salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d       G@   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @4         data_max      @s   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        >x V   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d       X   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?vȴ9   data_max      ?nP   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      >x    CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d       p   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       >x    PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d       1   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min      @M   data_max      @P   C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     >x A(   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d          station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( @   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( h   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      ,   data_max      ,   C_format      %10d          latitude               	long_name         latitude   units         	degrees_N      data_min      @H/ek   data_max      @H/ek   C_format      %9.4f             	longitude                  	long_name         	longitude      units         	degrees_E      data_min      b	{   data_max      b	{   C_format      %9.4f             	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d           	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d        @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @	@      @ffffff@      @      @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @7fffff@9@:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @X@Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @a@b)@b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d33333@d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g@g33333@h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i33333@i@i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @ny@n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u@ufffff@u     @u     @u     @u     @u     @v      @v     @v      @v1@v>fffff@vP     @v`     @vp     @v     @v     @v     @vfffff@v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w\@wnfffff@w@w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @za@zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{@{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}33333@}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}񙙙@~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @fffff@      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @_33333@h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @@@     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @33333@(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @@@     @     @     @     @     @@@      @     @     @     @      @(     @0     @6fffff@@@H     @P     @X@]@g33333@p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P@U@`@h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @/33333@8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @@@     @     @33333@     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h@p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @      @     @fffff@     @      @(     @0     @8     @@     @H     @P@X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @@     @      @(     @0     @8     @@     @H     @P     @X     @`     @ffffff@p     @x     @     @     @fffff@@     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @M@X@`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @@     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @Pfffff@T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @fffff@fffff@     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @fffff@癙@     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @Tfffff@Xfffff@\     @`     @d     @h     @l     @p     @rfffff@xfffff@|     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @33333@     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0fffff@3@8     @<     @@     @D     @Hfffff@L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @@     @     @     @     @     @fffff@뙙@     @     @     @     @      @     @     @@     @     @     @     @@$fffff@(     @,     @0     @4     @8     @<     @@     @H     @L     @P     @T     @X     @\     @`fffff@h     @l     @p     @t     @x     @|     @     @     @     @fffff@@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<fffff@@     @C@H     @L     @P     @Tfffff@W@\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @fffff@@     @     @     @     @     @      @$     @(     @,     @0     @8     @<     @@     @D     @H     @L     @O@Tfffff@X     @\     @`     @d     @h     @k33333@p     @t     @x     @|     @     @@     @     @     @     @@@     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @ @     @     @     @     @     @     @33333@      @$     @'33333@,@0     @4     @8     @<     @@     @E@H     @L     @P     @Tfffff@W33333@\     @`     @d     @hfffff@k@o@t     @x     @|     @     @@     @     @     @     @     @     @@fffff@     @     @     @     @     @     @     @33333@@     @     @     @     @     @ߙ@fffff@     @     @     @     @     @     @33333@33333@     @     @     @     @     @fffff@@$@(     @,     @0     @4     @8     @;@@     @D     @H     @L     @P     @S@X     @\     @`     @dfffff@h     @l     @p     @t     @x     @|     @     @     @fffff@@     @     @     @     @33333@     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @@fffff@      @     @     @     @@@     @     @      @$     @(fffff@,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @b@h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@@     @     @     @     @     @     @     @     @33333@     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @7@<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @ә@     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@fffff@Dfffff@H     @L     @P     @T     @X     @\     @_@d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@33333@     @     @     @     @     @     @     @fffff@fffff@fffff@     @     @     @     @     @      @     @fffff@     @     @     @     @     @      @$     @(     @,     @0     @4     @8@<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @33333@fffff@     @     @     @     @@$     @(     @,     @0     @4     @733333@<     @@     @D     @H     @L     @N@Tfffff@X     @\     @`     @d     @h     @k@q33333@t     @x     @|     @     @     @     @     @     @     @     @@@     @     @     @     @     @fffff@     @     @     @     @     @fffff@י@     @     @     @     @33333@@     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@fffff@C@H     @L     @P     @T     @W33333@\fffff@`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @@     @     @     @     @33333@@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @fffff@     @     @     @     @      @$     @'@,@0     @4     @8     @<     @@     @D     @H     @L     @P     @S33333@X     @\     @`     @d     @h     @l     @p     @t     @w33333@|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @ϙ@ә@     @     @     @     @33333@@     @     @     @     @      @     @fffff@     @     @     @     @     @      @"@(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @^                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @5?|@iB@u@'RT`@	k@҈p;@o@d8@}Vm@-
@'R@S@wk@9@;dZ@
qu@Gz@vȴ9@H@L_@}H˒@mB@2䎊q@&,<@$/@+@g@t@빌~($@JL@-@x@TɆ@h	ԕ@Gz@[6@wkP@ٙ@>BZ@+@_p@`A7@"C,@eں@#w@o-V@@N@㢜wk@SMj@$/@n@˒:*@\(@{s@rm\@oO
M@hۋq
@bC,@Z,<@Uᰉ@JW'@5!R@c	@K]@}H@s@PH@Ʌoi@}ڹZ@lVϪ@a-w1@["`B@RsP@DS@4֡a@y=c@G{@2X@sP@ ѷ@g	l@O
M@c	@\)@p:@hXy=@En/@9~($@(Xy=@@TɅo@zG@n@I^@;5X@)*0U2a@D@Z@fffff@M@䎊r@@oO
M@mB@e+a@Oo @?@F-@WXe,@^5?|@h@t3@xl"h	@9Xb@Mj@IQ@Ft@_F@"`B@ce@ce@tj@yrGE8@g@X_F@KC%@F]cf@<j~#@6E@/w@쿱[@~"@IQ@ԯO
M@ѷX@)^@o @˒:)z@JM@Xe,@@]cA@q@jOv@qi@84֡@I^5@|Q@tm8@iB@fx@de@]ce@V@N+@H@333333@+j@Fs@
:@K]d@XbM@g	l@:~ @䎊r@s@ˬq@ ѷ@J#9@?|h@{@fffff@/@u@ěT@u%@>6z@ѷX@Z1'@N+@IoiD@J#9@L@O
M;@=v@*d7@$TɆ@"M@?@,<@+J@xF]@9Xb@F]d@8}H@	@حV@ ѷY@6@JE@t@a@O@`d@m@#9@˒:*@H˒:@)y@sg@?|h@dZ@)_@U=@C,zx@$tS@bM@+I@ ѷ@o hی@}Vl!@weں@sPH@r䎊q@lVϪ@iDg8~@hr Ĝ@eڹ@]+j@T`d@P`A7@UϪ͞@Ks@XU@tSMj@|Q@$/@{lC@iB@iDg8~@ffffff@`
qu@W
=p@/v@"`A@PH@Mj@	k~(@JM@~$@F]d@kP@F]d@xl"h
@xl"h
@D@(@VϪ@g	@	ԕ+@fffff@>@sPH@ҽ<64@ΤT@p:~@y@m8@{J#:@V@zxl"@^@^@a@@-@wkP@u%@e+a@O;d@$/@rGE9@@qu"@	 @#@k~(@	 @ԕ*@	 @ԕ*@	 @qiC@҈@(@@xF]@L/{@҈@@@@R<6@@O;d@u%F@,<@=K^@6C@0
)@0
)@u%F@vȴ@,<@u%@=K^@=K^@u%@O;d@bM@qu"@O;dZ@M:@ߤ?@rGE9@4J@4J@M:@u%F@#@+I@YJ@JM@nP@u%F
@o hی@     @}E@}ڹZ@|Q@{~$@{m]@{m]@{~$@z>B@y"`@y(@y(@x73@v!.I@vFs@u!.@u%F
L@tSMj@u!.@xF@~m\@$/@@F]c@&I@@@A [@-
q@
	 @ IQ@$t@Z@?@	ԕ+@fB@g	@#@n.@	ԕ*@
qu"@
qu"@҈@\(@+J@kP|@!-w1@䎊r@	@!-w1@'&@)^@',@,>B[@3g	l@4J@0U2a|@2m\@6C-@9#w@8YJ@8Q@7Xe@84֡b@:^5?|@5'0@'&@䎊r@!-w1@#S&@"h	ԕ@vȴ9@,<@+J@@	 ѷ@+I@@n/@JM@nP@@4n@{J#9@S&@Fs@&I@oiDg@@n.@@@S&@ݗ@F]c@ڹZ@GE85@c	@ۋq
@Z@Ϫ͟@v_ح@@̘_@Ƨ@˒:)z@_o @Z@Ƨ@8YK@84֡@Zc@NU@@@~($@E@?|h@'0@֡a@33333@-V@ᰊ@33333@m\@[W>6@r@'RT@'RT@&x@2W@o@g	l@2W@H@<쿱@*0U2a@-@TɆ@IQ@Z@:)y@@@4J@n@n@:)y@)^@Vu@L_@@ ѷ@@$/@b}V@hۋq@u%F
@:S@~m\@}ڹZ@tj~@kQ@glC@cZ@aGz@_o@^@W
=p@O
M;@M%@LcA \@H@G@@A7Kƨ@74m@4J@2m\@2W@0 ě@/{J#:@/{J#:@.H@-B@*d7@'-@$TɆ@,=@Q@_F@*0U2@
O;dZ@@
m\@
hr@
kP@
8Y@
fB@
x@
A@
Z@
ܑN;@
|@
ɺ^5?}@
˒:*@
@@
š@
ěS@
\(@
ߤ?@
v@
<64@
64@
}H@

(@
<쿱@
y@
&@
'@
1@
h	ԕ@
u%F@
N;6@
bM@
@
M:@
qi@
S&@
ᰉ@
@
O;d@
+j@
$/@
:)y@
I^5?@
@
M:@
$/@
b}V@
~"@
}Vl!@
x-
@
u!R@
lC@
eڹ@
bC,@
`u!@
_Ft@
Y|@
RT`d@
P`A7@
QN;5@
Q@
QX@
Q@
P{@
M5Xy>@
H˒:*@
>vȴ9X@
6}Vl@
84֡b@
1o@
&L/{J@
$tSM@
#9@
-V@
_F@
+j@
_o@
Q@
U=@
!-w1@
쿱[W@
+J@

M:@
 hۋq@
I^5@˒:)@b}V@lC@#@GE85@@(@lC@>@䎊@:@]cA@W'@ʌL_@2W@4K@}Vl@y@/V@3@,=@ߤ@@Q@Q@u%@_F@ݗ+k@=p
@+I@YJ@ݗ@u%F
@{s@nc	@dqj@cZ@`u!@UϪ͞@O
M;@K:)z@G)^@Eo i@B\(@?[W>@<쿱[@:)y@8}H@5?@1&x@.1@.zG@-w1@*͞&@Ov_خ@PH@sh@Fs@ݗ+k@tj~@S&@qi@	7KƧ@\N<@+@#@t@Q@e@@N@Ft@ ѷY@Q_@ѷX@W'@C@)@o@O
M@͞&@S@tSM@ae@Ov_خ@u"@0
)@@O
M@'/W@Vu@L_@K]d@o h@u%F
@n.@~($x@xl"h	@tj~@oiDg8@glC@_?@Yb}@W&@UϪ͞@SZ@M5Xy>@H@E@E8YK@D*0@Eo i@As@?H˒:@5?|h@0U2a|@/r@/O
M@/{J#:@/v@*d7@!-w1@ᰉ@S&@@
(@@
l"h	@
!R@
GE85@
A@
cA @
>6z@
`d@
ҽ<64@
p:~@
o i@
4֡b@
'RT@
͞&@
@
-
@
%@
=K^@
@
 ѷ@
YJ@
?@
%2@
tj@
u%F
@
$/@
~$t@
u!R@
m(@
cZ@
`A7K@
\N;@
V8YJ@
SZ@
P`A7@
MjOv@
H@
G@@
F?@
Dg8}@
A7Kƨ@
<64@
9Y}@
9~($@
9#w@
6E@
3|@
,>B[@
+I^@
(TɅ@
&x@
$tSM@
!R<6@
_o@
u@
@
xF]@
C%@
'/@
	ԕ*@
	k~(@
+I@
o h@
%2@	.H@	Y|@	D@	@	O;@	C\@	C]@	B@		@	JE@	՛=K@	2a|@	ԕ*1@	т@	ǮzH@	p
=@	64@	)@	Xe@	-V@	lD@	'@	`A@	Ov_خ@	-
q@	xF]@	oiDg@	@4n@	     @	}H˒@	{lC@	z@	u!R@	s@	sPH@	qiB@	rs@	ql@	o@	m(@	h>BZc@	b}Vm@	_o@	TE@	OAs@	E8YK@	?H˒:@	8)@	3ߤ@	.2X@	'&@	,=@	vȴ@	vȴ@	_F@	$tS@	L_@	tj~@	n@	bM@	@		ԕ*@	ݗ+@	o h@	 IQ@	      @($x@>B@D@MjO@A [@hr!@JL@>BZc@fffff@,<@1.@@唯O
@	@e+@ڹY@jOv@n@W'@ɅoiD@Q@ɅoiD@@\(@n.@)y@YJ@4m@4K@?@?|h@-@w1@$xG@/V@&@9@u%@Xe,@zG@o @=p
@ݗ@~\N<@zC\@u%F
L@t!-w2@o@l[W?@f,<@`d8@XD*@S&@JD@Eo i@A7Kƨ@>6z@<Z@8Q@3|@1&x@/{J#:@/{J#:@.}Vl@,q@-V@)^@&'@"h	ԕ@}H@u%@O;d@O
M@nO@@qi@xF]@+I@nP@:S@E@hr@kP@g@s@@B@%1@5?|@/w@ٳ|@@՛=K@@a@O@҈p:@N;5@
M;@]cA@˒:*@g8}@C@|hs@
(@A@4֡b@W@jf@-@/V@&@L/{J@
=p@3@-
@%@-V@IQ@@*0U2@'/W@'RTa@ ѷ@.H@{~$@x-
@r䎊q@qA [@ix@e`A7L@cS@b}Vm@[q@Rp:@PH@M%@K]cA@I@GE84@B&IR@9Y}@5Xy=@3g	l@2m\@0U2a|@.2X@+a@@)lD@$?@IQ@$tS@tj~@ߤ?@u%F@M:@@@.H@lC@J#9@+@g@{m@@-V@4֡a@4֡a@O;@C]@8}H@C,@Q_@҈p:@Ϫ͞@@)^	@@@2W@5Xy@XbM@4֡b@3@a|Q@w1@͞&@Xy=@TɆ@`A@䎊r@Ov_خ@_F@҉@-
q@xF]@+I@S&@IQ@~m\@}H˒@}!.H@{m]@y"`@uY|@n.2@k~($@jfB@eڹ@_حV@]+j@\N;@Zc	@Zc	@Zc	@ZY@XbM@U2a|@S@Rm@M@GzH@F]cf@D*0@C,zxl@@NU@=p
=@:S&@8)@74m@7KƧ@6z@3|@2-V@/v@+U=@',@$?@!.H@ ěT@vȴ9@ [6@!-w1@!ae@!R<6@䎊r@ 'RT`@!-w1@,=@wkP@tj@ᰉ@N;6@qi@@
qiC@ ѷ@ 4m9@      @\N<@?@@D@@{m@u!S@@.2@Q@A@+a@@4@A7K@o@҈p;@;dZ@/w@W>6z@څݘ@1'@sPH@l!-@`d@v_ح@Q@?@@ߤ?@}H@|@'RT@@`A@R<6@!-w1@@Fs@nO@Mj@qiC@YJ@%2@b}V@~$t@|hr@|Q@|Q@{J#9@zxl"h
@yrGE8@vFs@u%F
L@r䎊q@r ě@pD@nO;@l"h	ԕ@fA@`A7K@^ ѷY@\>@[6@Y>BZ@Rm@P|@L@Gy@C\N@B&IR@@NU@9~($@5?@5'0@4m8@2ᰊ@/Vϫ@.zG@(TɅ@$xF@!o@	@u@,=@-V@}H@1&@=K^@u%F@_F@@Xe,@R<6@N;6@
qu"@o h@M:@@ ѷX@\N<@xl"h
@ȴ9X@Y|@%F
L@D@#@g@@"h	ԕ@e@Z1@Z1@䎊qj@
qu@>@ٳ|@E@@ɺ^5?}@ȴ9Xb@]cf@Õ$@[W>@6z@33333@}Vl@U=@V@<쿱@&@S@9@쿱[W@vȴ@u%F@e+a@@L_@qi@҈@ڹY@K]d@nP@{s@u!R@tSMj@sPH@rGE85@rs@qiB@q@pD@p
=q@p@o hۋ@l!-w@jfB@de@b@4@^iB@[$@Xe+@T,<@PH@Np:~@JL_@IQ@H9Xb@H@Gy@Dg8}@C,zxl@>vȴ9X@;/V@:S&@:)y@7Xe@5?|h@3g	l@0 ě@,>B[@*d7@(Xy=@%S@#S&@	@쿱[W@Ov_خ@,=@S@e+a@$tS@ݗ+k@n@o @Mj@
(@L_@	7KƧ@oiDg@%2@I^5@ ѷX@!.H@G{@"`@!.I@!R@D@#@!-w2@!-w2@E@s@.2@x@eO@@4@|Q@d8@҈p;@6@ٳ|@bM@t@ӎMj@а{@@Ƨ@)^	@#9@Q@˒:*@E84@m\@84֡@š@84֡@&IR@@4m@쿱[@S&@^5?|@XbM@sg@ߤ@ᰊ@o@o@&x@U2a|@w1@6z@y@Xy=@&@IQ@u@o@[@vȴ@R<6@@N@nO@hr @~($x@p:@u%F@#@$/@o h@@ ѷ@o hی@     @~$t@zxl"h
@z@zC\@y	k~@t!-w2@mC\@kC]@h>BZc@`҈p@]cA @[$@Y|@YJE@Xy=c@V8YJ@S&@P{@PH@P*0U@P|@N;5X@JL_@H9Xb@Fs@Fs@DS@D*0@DS@B74@B@B&IR@A [7@?@>BZc @<쿱[@<n.@9XbM@4J@2ᰊ@0
(@.zG@*͞&@*0U2a|@&L/{J@%u@#S&@䎊r@Ov_خ@C,zx@qu!@_o@$tS@*0U2@)^@C%@	 ѷ@_o@oiDg@Q@tj@@o hی@˒:)@˒:)@b}V@H˒@J#9@>B@@1@oiDg8@hr!@!-w@x@	ԕ+@e@Z@ⶮ}Vm@Gz@ޞ@ ѷY@+@l!-@Ʌoi@ԕ*1@`d@,<@m@ѷX@H@W'@\N@Zc@ߤ?@v@5Xy@XbM@Xy=@&x@2X@
qv@w1@^@/V@S@TɆ@wk@n.3@-w1@u@wkP@_F@L_@S&@4J@)^@@!R<@@qiC@~m\@{lC@{s@xl"h	@vȴ9X@vFs@u\(@uY|@tj~@qiB@lVϪ@jJL@h>BZc@g	k@g@f1.@dZ1@`d8@]cA @Z1'@W&@Vl!-@R䎊@O͞@N;5X@M:@K:)z@H@GzH@Em\@@C@<j~#@9~($@6E@3ߤ@12W@0'RT@.zG@,<쿱@+I^@)@%zxl"h@#wk@!.H@!R<6@	@쿱[W@%@u@u"@u%@_o@*0U2@
(@
M:@
O;dZ@~($x@xF]@
qiC@	ԕ*@p:@eO@+I@$/@tj@I^5@ IQ@$tS@\N<@H˒@H˒@E@ڹZ@PH@"`@eں@#@u!S@A [@A [@-V@!-w@fB@	k@fffff@ڹ@唯O
@A [@M@A7K@ ѷY@"`B@
=p@E@@R@т@_p@As@W'@E84@m\@Õ$@ [7@NU@@@/V@)_@Y}@4֡b@z@-V@{@Vϫ@O
M@1&y@0
@^@xF@3@o@	k@U=@,=@1&@u"@e+a@O
M@O
M@O
M@Z@Z@O
M@O
M@ݗ+k@S&@$tT@@Mj@(@M:@I^5?@ڹY@	 @=p
@ԕ*@eO@ݗ@:S@~"@}E@y(@wkP@uY|@r䎊q@poiDg8@oiDg8@n.2@k~($@jOv`@iDg8~@cZ@_o@]/w@]ce@]/w@YJE@Vt@UfA@TE@T`d@P{@OAs@OAs@OAs@N_o @H@F]cf@F
L/@DS@B&IR@A [7@?@>6z@=b@:~@9XbM@9#w@84֡b@8)@74m@43@.1@,q@+jf@&x@$/@$?@$xF@$xF@"`A@!ae@-V@_o@_F@+j@O;d@Fs@hr @)^@Mj@
@q@
L/{@
L/{@ݗ+@{J#9@o hی@ 4m9@ ڹZ@ >B@ eں@ _ح@ Y|@ !-w2@ @ PH@ {m@ u!S@ 
=q@ @ hr!@ hr!@ hr!@ (@ !-w@ 쿱[W?@ 쿱[W?@ 쿱[W?@ VϪ@ C,z@ @ 唯O
@ M@ C,@ ߤ?@ ]ce@ c	@ b}@ e+@ bM@ 8YJ@ Ʌoi@ &@ а{@ _o @ W'@ ˒:*@ ǮzH@ )^@ m\@ ,zxl@ s@ |hs@ n.@ )@ rG@ z@ sg@ ֡a@ 9XbN@ ߤ@ ᰊ@ 2W@ o@ U2a|@ r@ B@ U=@ /V@ L/{J@ IQ@ L/{J@ 1@ ?@ ae@ 	@ Q@ IQ@ u"@ C,zx@ C,zx@ S@ _o@ O;d@ ᰉ@ *0@ ҉@ Mj@ (@ (@ (@ !R<@ Vu@ !R<@ @ C%@  ѷ@ ݗ+@ o h@ F]c@ $/@ hۋq@ IQ@ IQ@ 4m9@ $tS@ ~m\@ |hr@ z>B@ w1@ r{m@ mhr!@ l"h	ԕ@ kP{@ jfB@ jfB@ jg	@ jJL@ iᰉ'@ iB@ hr Ĝ@ e@ cA [@ ae@ _حV@ \(\@ Zc	@ Zݘ@ Y>BZ@ Xe+@ W>6z@ U=K@ T*1@ S&@ P|@ O;dZ@ Np:~@ G@@ C$@ C$@ BZc@ A [7@ ?H˒:@ =K]@ :~@ :S&@ 9XbM@ 7rG@ 2W@ /v@ -U=@ -w1@ ,1&y@ *͞&@ )y@ (TɅ@ '-@ &'@ %u@ !ae@ ,=@ u"@ Q@ qu!@ qu!@ qu!@ =K^@ 6C@ O;d@ nO@ -
q@ '/W@ qi@ 
@ 
M:@ 
M:@ 
@ 
@ 
qu"@ 	ԕ*@ _o@ o h@ {J#9@ $/?PH?	k~?#?Q??,<?,<?1.?`A7L?@4????fA?|?s?˒:)z??8YK?a@N??H˒:?v?#w?4m?ᰊ?'RT? ě? ě?1&y?TɅ?u?ae?-V?S?0
)?ݗ+k?\(?qiC?%2?~"?|??y=b?u!R?qiB?m\?iDg8~?eڹ?ceO?c	?`A7K?_o?\N;?Z1'?XbM?W>6z?W&?TɅoi?S&?R<64?Q?O;dZ?J#9?Fs?F
L/?Dg8}?C$?BZc?@NU?=b?=b?:S&?9D?5Xy=?2a|Q?.H?+a@?*0U2a|?($xG?"`A? ěT?}H?qu!?Ov_?*0U2?n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @@Ye+a@@Yae@@Yae@@Y^@@Ye+a@@Yk~(@@Yhr @@Yhr @@Yhr @@Yk~(@@Yhr @@Ye+a@@Ye+a@@Ye+a@@Yhr @@Ye+a@@Ye+a@@Yo hی@@Y'RTa@@Y(@@Y@@Ze+@@ZڹY@@ZG{@@[P{@@[S@@[J#9@@[F]c@@[MjO@@[S@@[S@@[S@@[S@@[W>6z@@[Z@@[]cA@@[a@N@@[]cA@@[]cA@@[]cA@@[qu!@@[Ƨ@@\,<@@\?@@\u"@@]Q@@]%F
L@@](@@]+j@@]1@@]1@@]b@@]
qv@@]ᰉ@@],=@@^_o @@^
L/@@^$/@@^.2@@^?@@^?@@^+jg@@]oiDg@@]@@]ݗ@@]L_@@\>@@\S@@\g8}@@\C,zx@@\(\@@\Fs@@\#x@@]o i@@]?|h@@]sg@@]1@@]\(@@^!R<@@^E@@^fffff@@^iB@@^iB@@^$t@@^m\@@^@@^쿱[W@@^쿱[W@@_Ft@@_'/W@@_4֡a@@_8}H@@_As@@^"@@^}Vl@@^R<6@@]b@@]cA @@]p
=@@]jOv@@]S@@^;5X@@]!.@@^!R<@@^;5X@@^Fs@@_&@@bn@@f ѷY@@h@@kE@@o+@@q@N@@vzG@@ye@@}n/@@`A@@K]c@@@@
qv@@@@ ѷ@@8Y@@U=@@Xe@@@@nO@@O
M@@@@kP|@@Xe@@N;6@@Ę_@@ǝ-V@@$tT@@XbM@@@@S&@@̹#x@@ή}Vl@@A@@t@@Ft@@rG@@:S@@Y}@@:)y@@ҦL/{@@'/@@=K^@@@N@@jf@@xF@@ԥzxl"@@@@(@@\(@@$/@@fffff@@֮}Vl@@Fs@@lC@@ח$tS@@+@@؆YJ@@o@@R@@6C@@ڹY@@c	@@PH@@xF]@@
=p@@lC@@g@@?@@ܨTɆ@@D@@*0@@*0@@\@@ᰉ@@
L/@@Ov_خ@@ޮ}Vl@@޾ߤ?@@޸Q@@ޱ2X@@&I@@m\@@1@@
=p@@v@@@@1&x@@NU@@oiDg8@@n@@-
@@
=q@@
(@@F@@	k@@A [@@rGE8@@l@@ὥ@@ԕ*@@ᰉ'@@-@@@4n@@p:@@sP@@&@@g	l@@@@\N@@ߤ@@@"h	ԕ@@M:@@zG@@䎊qj@@*1@@1&@@䲕@@#x@@@@K]@@L_@@+j@@$/@@1.@@z@@
=p@@H˒:@@+@@4m9@@K]c@@bM@@|@@r Ĝ@@y=c@@@@@D@@e+@@	k@@$/@@:S@@@@鰉'R@@^5?}@@o@@@@xl"h
@@g	@@c	@@nP@@,zxl@@S@@jf@@믷@@
=p@@ߤ@@@Fs@@VϪ@@3@@%F
L@@?|h@@L_@@L_@@m\@@!R@@1@@
qv@@@@fffff@@O;@@}Vl@@m\@@E84@@vȴ9@@@@bM@@ěT@@TɅo@@@@n.@@^5?}@@lD@@@@&IR@@Zc@@33333@@a@O@@@@"h	ԕ@@cA \@@j~@@D@@=K@@
qv@@!.@@Ov_@@O;@@@@]cf@@Ft@@!-w1@@4֡a@@O
M@@lC@@zH@@     @@*0U@@ ě@@D*@@tj@@
(@@F@@ ѷ@@Gz@@o hی@@x@@@@'RTa@@>BZ@@@4n@@^5?|@@ᰊ@@g	@@ڹY@@I^@@'/@@,zxl@@Z@@~$@@eO@@E@@5Xy@@
=p@@g@@$@@J@@Q@@(\@@2W@@Z1@@tSM@@#@@j~@@[@@L_@@M:@@8Y@@
L/@@Vu@@@@T@@A@@ hۋ@@kP@A  ě@A C@A @A ۋq
@A e+@A ۋq
@A F@ArGE@A0
)@A4J@A[W>6@A'R@A1'@AT`d@AnO@A@4@Aᰊ@A@AfB@A,zxl@AF]c@Ag	l@AQ@Ag@AJ@AL_@A?@AwkP@A_@AɅoi@Ace@A@AS@A ѷY@A
L/@AOv_@A?@Afffff@Aߤ?@Av@A!-w1@A'/W@AKƧ@Ab}V@AiDg8@Av_ح@A|hs@AkP@A+@A@AfA@A#@Al"h	@A
=q@AѷX@A	k@A	@A	*0U2a@A	-w1@A	7KƧ@A	Dg8~@A	ae@A	7Kƨ@A	u@A	'RTa@A	2W@A	o@A	@A	.H@A
s@A
I^5@A
@A
)y@A
Q_@A
d7@A
p:@A
S&@A
>B@A
͞&@AI^@A6z@AF]c@AP{@Ajf@A@Aq@A$@AZ@A
=p@A҈@A%2@AlC@As@A\N@AxF@A@AQ@A<쿱@AVϪ@AzG@AN;@AS@Azxl"@A#x@AɅoi@A
V@A
/w@A
B@A
O;dZ@A
Y|@A
}H@A
@A
,=@A
!.@A ѷY@A
L/@AOv_@A1.@A8YJ@A?@AOv_خ@A_ح@Ap:~@A@A+@AϪ͟@A1@A@A$tS@A4֡a@A>6z@AXe,@AlC@A-V@A@A@@A$xG@A>BZc@ANU@AU2a|@A_F@AbM@Al"h	@A˒:*@A{@AF@A$/@A*0U2a@A^@Ax@A@AB@A2W@Ae@AY}@A-@A	 @A1'@A6C@Aa|Q@Axl"h
@Aᰊ@A ě@A͞&@Am\@A҉@AC,z@AF]c@Ajf@An.3@Aqu!@AQ@AU=@A@A(\@AM:@AVϪ@A]ce@AwkP@AC@A쿱[@AZ@AD@AE@Ao i@AQ@Ap
=@A@A1@A@A,=@A!.@A
L/@A.2@AR<6@Afffff@Aqi@Aaf@Aaf@Aȴ9X@Ax@A"@A
=p@A1@AH˒:@AU=@A_o@A|hs@AzH@AfA@A@A@A-@A	ԕ+@A$xG@AbM@A
=q@A
(@AF@A@A_p@A:S@A=b@A7KƧ@A:S@ADg8~@AGz@AQ@Aae@Ax@AX@An@AOv`@A:)y@AM@AW'@AkP|@AqiC@Axl"h
@A~"@Ap:@Ag	@A<64@A`A@AfB@AS&@A/V@AMjO@Aa@N@Aqu!@A~$@AMj@A$@AU=@AS@AS@A~($@AQ@An.@A@AL_@AL_@A@A!-w2@AVϪ@Am8@Ao h@Ao h@A_@A3@Azxl"@AO
M@ATɆ@AO
M@Aj~@AZ@AZ@AJM@A@Ahr@Ae@AV@A<64@AVl!@A\@Am\@A!R@Av@A1@A@AH˒@A8Y@A@A
qv@A(@A!.@Aڹ@AzG@A@Au@AOv_@A($x@AYJ@Ap:~@A@AFs@AO;@AO;@A@A-@A@A]cf@A@A쿱[W@A@A@A+I@A4֡a@A;dZ@A;dZ@AAs@Aeں@A4m@A&@A@ArG@A-@A#@A @A 	ԕ+@A @A 'RT`@A 4m9@A A7K@A D*@A K]c@A NU@A Q@A bM@A |@A -
@A @A IQ@A U@A @@A )^@A `A7@A! ѷ@A! [7@A!Q@A!XbM@A!e+a@A!u!S@A!~($@A!n.@A!(@A!(@A!(@A!n.@A!X@A!2W@A!R@A!-@A!.H@A!lD@A!lD@A!lD@A"I^5@A"3@A"GE85@A"JL@A"Q_@A"Q_@A"nO@A"\(@A"\(@A"L/{@A"ڹY@A"D@A#'/@A#҉@A#s@A#&@A#MjO@A#dZ@A#eO@A#wk@A#Ƨ@A#҈@A#g@A#\N@A$"h	ԕ@A$C,zx@A$I^5?@A$PH@A$PH@A$]ce@A$q@A$wkP@A$o h@A$쿱[@A$#x@A$JM@A$!-w@A%[@A%%F
L@A%2a|@A%84֡@A%IQ@A%Y|@A%`A7L@A%Y|@A%ce@A%sg@A%!R@A%hr!@A%hr!@A%+j@A%-V@A%n/@A%@A%
qv@A%ᰉ@A%oiDg@A& ѷY@A&
(@A&5?|@A&\N<@A&z@A&IQ@A&+J@A&+J@A&$t@A&O;@A&6z@A&'@A&Q@A&ߤ?@A&C-@A&Fs@A&!.I@A'Ft@A'
M;@A',@A'.H@A'O
M@A'o@A'sPH@A'y@A'y@A'{J#:@A'[W>@A'fA@A'fA@A'@@A'rG@A(     @A('RT`@A(4m9@A(>BZc@A(U2a|@A(-
@A(u%F@A(d8@A(9Xb@A(TɅ@A(@@A()^@A(F@A(@A(C@A(4֡b@A({@A({@A({@A(PH@A)@A)_p@A)#w@A)&x@A)=b@A)Dg8~@A)[W>6@A)hr @A)b}@A)R<6@A)X@A)y@A)iB@A)e@A)R@A)Y}@A*n@A*e+@A*&IR@A*3@A*:)y@A*C\@A*GE85@A*JL@A*T`d@A*kP|@A*nO@A*qiC@A*{m@A*S&@A*0
@A*vȴ@A*@A*}Vm@A*n@A*͞&@A*W@A*)_@A*W@A*`A@A*sP@A*G{@A+S&@A+&@A+"`B@A+	@A+)^	@A+)^	@A+)^	@A+,zxl@A+F]c@A+Z@A+dZ@A+dZ@A+jf@A+g	l@A+jf@A+n.3@A+tj~@A+q@A+A@A+A@A+ߤ@A+S@A+Ƨ@A+|@A+ݗ+k@A+C]@A,n.@A,1&y@A,"h	ԕ@A,64@A,?@A,?@A,C,zx@A,M:@A,j~#@A,~($x@A,S@A,S@A,Z@A,u"@A,JM@A,hr@A,@A,e@A-K]@A-u@A-[@A-[@A-Q@A-%F
L@A-%F
L@A-?|h@A-L_@A-Y|@A-ce@A-jOv@A-w1@A-M:@A-hr!@A-O
@A-+j@A-%@A-@A-8Y@A-cA @A-b@A-?@A-oiDg@A-!.@A-ڹ@A._o @A.$/@A.8YJ@A.L/{J@A.L/{J@A.YJ@A._ح@A.l!-@A.iB@A.p:~@A.vȴ9X@A.z@A.+J@A.@A.O;@A.T@A.2X@A.'@A.@A.m\@A.ȴ9X@A.1@A/@A/
=p@A/
=p@A/ hۋ@A/Ft@A/Xe@A/v@A/,@A/$tS@A/$tS@A/+I@A/;dZ@A/RT`e@A/Xe,@A/o@A/&@A/ݗ+@A/kP@A/	k@A/r@A//V@A/;dZ@A/Vϫ@A/Vϫ@A/䎊r@A0*0U@A0*0@A0$xG@A0:~ @A0A7K@A0D*@A0NU@A0bM@A0y=c@A0˒:*@A0@A0'RT@A0@A0-
@A0@A0U@A0TɅ@A0ۋq
@A0C@A0	k@A1	k~@A1_p@A1&x@A1*0U2a@A1-w1@A1A [@A1Gz@A1JE@A1Q@A1e+a@A1hr @A1o hی@A1o hی@A1o hی@A1k~(@A1rGE8@A1|Q@A17Kƨ@A1R<6@A1^5?}@A1_o@A1iB@A1e@A1R@A1@A1Y}@A2s@A2s@A21'@A2&IR@A2:)y@A2JL@A2M@A2T`d@A2a|Q@A2kP|@A2u%F
@A2xl"h
@A2L_@A2vȴ@A2@A2n@A2)_@A2W@A2 ѷ@A2fB@A2fB@A2C,@A2C,@A2c	@A3S&@A3"`B@A3)^	@A3&@A36z@A3F]c@A3P{@A3W>6z@A3]cA@A3]cA@A3Z@A3]cA@A3g	l@A3tj~@A3{J#9@A3{J#9@A3Mj@A3wk@A3*0U2@A3q@A3@A3~($@A3a@O@A3|@A3
=p@A3Q@A3ݗ+k@A3ݗ+k@A3lC@A3C]@A3@A4n.@A4tj@A4"h	ԕ@A4%1@A4,<@A4/{J#@A4,<@A4,<@A4%1@A4%1@A42W@A42W@A49XbN@A4<쿱@A4?@A4PH@A4Z1@A4cA \@A4m8@A4zG@A4o h@A4*1@A4_@A43@A4zxl"@A4TɆ@A4O
M@A4?@A4@A4Z@A4Z@A4Z@A4/@A4@A4e@A4E@A5'0@A5*0@A5*0@A5u@A5*0@A5Q@A5%F
L@A5+a@A5+a@A55Xy>@A52a|@A5B@A5O;dZ@A5jOv@A5p
=@A5w1@A5ݗ@A5@A5U=@A5sh@A5cA @A5S@A5ᰉ@A5!.@A6
(@A6@A6Ov_@A6$/@A61.@A6H@A6R<6@A6fffff@A6fffff@A6c	@A6c	@A6iB@A6p:~@A6vȴ9X@A6vȴ9X@A6%@A6%@A6qi@A6+J@A6Fs@A6,<@A6T@A6Q@A6t@A6]cf@A6ߤ?@A6C-@A61@A6!.I@A7Ft@A7@A7$tS@A7.H@A7;dZ@A7As@A7Xe,@A7Xe,@A7b}V@A7iDg8@A7sPH@A7y@A7{J#:@A7ݗ+@A7-V@A7͞@A73@A7vȴ9@A7vȴ9@A7/V@A7r@A7/V@A7@A7o @A7K]d@A7@A7حV@A7@A7rG@A7䎊r@A8@A86@A8}H@A8'RT`@A8*0@A8:~ @A8K]c@A8NU@A8U2a|@A8Q@A8U2a|@A8Xy=@A8hۋq@A8˒:*@A8u%F@A8tj@A8u%F@A8@A8@A8U@A8)@A8)^@A8`A7@A8{@A8	k@A8$tT@A9@A9_p@A9@A9A [@A9JE@A9Q@A9XbM@A9XbM@A9k~(@A9rGE8@A9|Q@A97Kƨ@A9R<6@A9R<6@A9@A9n.@A9X@A9o@A9o@A9_o@A9ᰉ'@A9Y}@A:@A:䎊@A:#9@A:-V@A:0U2a|@A:0U2a|@A:0U2a|@A:6C@A:6C@A:6C@A:6C@A::)y@A:C\@A:Q_@A:kP|@A:nO@A:~"@A:@4@A:\(@A:vȴ@A:@A: ě@A:@A:W@A:͞&@A:W@A:)_@A:,<@A: ѷ@A:c	@A:74@A:74@A:74@A;u%@A;҉@A;nP@A;C,z@A;"`B@A;,zxl@A;6z@A;=K^@A;F]c@A;W>6z@A;W>6z@A;W>6z@A;W>6z@A;dZ@A;n.3@A;xF]@A;~$@A;Q@A;$@A;A@A;ߤ@A;ߤ@A;S@A;E@A;6@A;a@O@A;Ƨ@A;
=p@A;ݗ+k@A;҈@A;g@A;A [@A;@A;$@A;$@A;$@A;s@A<n.@A<L_@A<,<@A<9XbN@A<9XbN@A<9XbN@A<?@A<I^5?@A<SMj@A<]ce@A<g8}@A<j~#@A<tSM@A<~($x@A<C@A<qj@A<C@A<S@A<3@A<3@A<zxl"@A<TɆ@A<TɆ@A<zxl"@A<TɆ@A<#x@A<j~@A<7@A<*0@A<Z@A<Ʌoi@A<֡a@A<hr@A<!-w@A<e@A<!-w@A<!-w@A<>@A=:@A='0@A=u@A=V@A=*0@A=!.H@A=%F
L@A=(@A=84֡@A=B@A=F
L0@A=`A7L@A=fA@A=jOv@A=jOv@A=M:@A=!R@A=ڹZ@A=ڹZ@A==K@A=%@A=@A=v@A=U=@A=1@A=sh@A=8Y@A=8Y@A=8Y@A=Ϫ͞@A=ᰉ@A> ѷY@A>_o @A>4K@A>!R<@A>.2@A>5?|@A>?@A>;5X@A>E@A>R<6@A>\N<@A>iB@A>fffff@A>\N<@A>_ح@A>l!-@A>z@A>IQ@A>%@A>IQ@A>@A>$t@A>$t@A>Fs@A>Fs@A>,<@A>af@A>T@A>6z@A>}Vl@A>}Vl@A>ߤ?@A>҈p;@A>Ϫ͟@A>]cf@A>C-@A>쿱[W@A>1@A>"@A>!.I@A?@A?@A?,@A?$tS@A?'/W@A?+I@A?.H@A?As@A?RT`e@A?_o@A?eں@A?iDg8@A?iDg8@A?iDg8@A?sPH@A?y@A?4m@A?&@A?&@A?&@A?O;d@A?@A?$tS@A?kP@A?&@A?@A?K]d@A?o @A?@A?+@A?@@A?@A?Vϫ@A?䎊r@A?+j@A?䎊r@A@@A@*0U@A@6@A@@A@@A@6@A@}H@A@'RT`@A@*0@A@D*@A@Q@A@U2a|@A@eO@A@hۋq@A@l"h	@A@u!@A@YJ@A@@A@IQ@A@u%F@A@u%F@A@{@A@9Xb@A@
(@A@TɅ@A@TɅ@A@TɅ@A@ѷX@A@D@A@e+@A@4֡b@A@{@A@	k@A@	k@A@$tT@AA	k~@AA	k~@AA@N@AA+@AAGz@AAJE@AAN;5@AA[W>6@AA^@AA[W>6@AA[W>6@AAQ@AA[W>6@AAk~(@AA|Q@AA@AAoiD@AA@AA7Kƨ@AA@AAR<6@AA(@AA'R@AAX@AA@AA2W@AA@AA"`@AAᰉ'@AAiB@AAᰉ'@AA>BZ@AAR@AA.H@ABs@AB䎊@AB)y@AB-V@AB3@AB:)y@AB=p
@ABJL@ABJL@ABQ_@ABZc@ABh	ԕ@ABh	ԕ@ABkP|@ABkP|@ABqiC@ABu%F
@ABxl"h
@ABu%F
@AB~"@AB@4@ABݘ@ABᰊ@AB@AB>B@AB>B@AB>B@AB}Vm@AB<64@AB<64@AB<64@AB<64@AB@AB)_@AB͞&@ABڹY@AB ѷ@AB䎊q@AB䎊q@AB䎊q@ABG{@AB䎊q@ABC,@ABc	@ABD@AB74@ACu%@AC'/@ACnP@AC'/@ACnP@ACC,z@AC&@AC6z@AC9@AC9@AC6z@AC=K^@ACC%@ACP{@ACW>6z@ACZ@ACg	l@ACqu!@ACxF]@AC{J#9@AC{J#9@ACxF]@AC@AC:)z@ACߤ@ACS@ACq@AC@AC@AC@ACm]@AC@ACƧ@AC5Xy@AC|@AC
=p@AC҈@AC%2@AC%2@ACg@AC@AC\N@ADn.@AD@ADtj@AD@ADL_@AD!-w2@AD!-w2@AD"h	ԕ@AD(\@AD64@ADC,zx@ADI^5?@ADC,zx@AD<쿱@AD?@AD<쿱@AD<쿱@ADC,zx@ADM:@ADZ1@AD]ce@AD`d@ADcA \@AD`d@ADg8}@ADj~#@ADq@ADq@ADtSM@ADtSM@ADzG@ADqj@ADS@AD3@AD1&@ADTɆ@AD1&@ADj~@AD?@AD@ADZ@AD>B[@AD>B[@AD>B[@ADhr@AD>@ADE@AE:@ADe@AE'0@AE*0@AEqu"@AE*0@AEqu"@AE(@AE+a@AE/w@AE(@AE/w@AEB@AEIQ@AEIQ@AEVl!@AE\@AEce@AEfA@AEce@AEm\@AEw1@AEw1@AEw1@AE}H@AE}H@AE$/@AE!R@AE%@AE=K@AEv@AE1@AE@AEH˒@AEn/@AE\(@AE@AE@AE@AE?@AE
qv@AE,=@AEᰉ@AEE@AE!.@AEC\@AFt@AF_o @AF
(@AF4K@AF4K@AFu@AF.2@AF1.@AF8YJ@AF?@AFE@AFOv_خ@AFOv_خ@AFVu@AFVu@AFVu@AF_ح@AFc	@AFfffff@AFfffff@AFl!-@AFvȴ9X@AFvȴ9X@AFs@AFs@AFs@AFvȴ9X@AFvȴ9X@AFz@AF}Vl@AFIQ@AF%@AF@AFO;@AF,<@AFT@AF6z@AF}Vl@AF2X@AFQ@AF@AF&I@AFm\@AFt@AFA@AF+@AF1@AF1@AF1@AF쿱[W@AF@AF!.I@AG@AG
M;@AGv@AG,@AGv@AG,@AG'/W@AG'/W@AG'/W@AG'/W@AG+I@AG4֡a@AG8}H@AG8}H@AG>6z@AGE84@AGE84@AGO
M@AGU=@AGU=@AGXe,@AGXe,@AGXe,@AGb}V@AGlC@AGsPH@AGy@AGy@AGv_ح@AGsPH@AG|hs@AG{J#:@AG	@AGO;d@AG@AG$tS@AG?@AG?@AG?@AG?@AG	k@AG-V@AG&@AG3@AGr@AG/V@AGo @AG+@AG˒:)@AG@AGحV@AG@AGfA@AG@AG@AG@AG@AGVϫ@AGrGE9@AH	ԕ+@AH
qu@AH}H@AH ě@AH ě@AH$xG@AH'RT`@AH'RT`@AH ě@AH$xG@AH*0@AH4m9@AH73@AH>BZc@AHA7K@AHQ@AHQ@AHU2a|@AHU2a|@AH[6@AH_F@AHbM@AH_F@AHhۋq@AHu!@AHu!@AH|@AHtj@AHtj@AHIQ@AHIQ@AH@AH{@AH4m@AH)@AH4m@AH
(@AHTɅ@AHF@AH҈p@AHe+@AH҈p@AHC@AHC@AH4֡b@AH\)@AH{@AHPH@AI ѷ@AI@AIrGE@AI@N@AI@N@AI+@AI+@AI_p@AI@AI_p@AI [7@AI0
)@AI7KƧ@AI=b@AI:S@AIA [@AI:S@AI:S@AIA [@AIA [@AIDg8~@AIQ@AI[W>6@AIae@AI^@AIk~(@AIu!S@AIrGE8@AIb}@AIo@AI@AIo@AIo@AIo@AI@AI@AIn.@AI(@AIB@AI^5?}@AID@AID@AID@AID@AIy@AI_o@AIԕ*@AI@AIᰉ'@AIᰉ'@AI>BZ@AI>BZ@AIe@AIR@AIY}@AIlD@AI.H@AJn@AJ	 @AJI^5@AJ@AJ1'@AJ䎊@AJ)y@AJ3@AJ:)y@AJ@4n@AJC\@AJJL@AJJL@AJQ_@AJ^5?|@AJa|Q@AJh	ԕ@AJ^5?|@AJh	ԕ@AJkP|@AJqiC@AJ{m@AJxl"h
@AJu%F
@AJxl"h
@AJ@4@AJݘ@AJ~"@AJ@4@AJp:@AJS&@AJS&@AJS&@AJᰊ@AJwkQ@AJL/{@AJL/{@AJL/{@AJvȴ@AJ@AJ ě@AJ}Vm@AJY@AJ<64@AJ<64@AJ@AJ)_@AJ`A@AJ,<@AJG{@AJ䎊q@AJfB@AJ䎊q@AJC,                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @sL@sP     @sP     @sI@sNfffff@sP     @sP     @sK33333@sNfffff@sQ@sQ@sP     @sNfffff@sNfffff@sNfffff@sNfffff@sI@sK33333@sK33333@sC33333@sH     @sP     @sY@sY@s[33333@s`     @s`     @s\@s^fffff@s\@s^fffff@s^fffff@s^fffff@sX     @s[33333@s[33333@sY@sS33333@s;33333@s     @s33333@s#33333@s8     @sL@s`     @sh     @sp     @st@st@ss33333@sy@s@s33333@s~fffff@sy@st@snfffff@snfffff@snfffff@sk33333@sd@sc33333@sh     @sk33333@snfffff@sq@sx     @s     @s{33333@sp     @sh     @s\@sT@sS33333@sP     @sNfffff@sP     @sP     @sL@sH     @s<@s<@s8     @s6fffff@s;33333@sA@s<@s.fffff@s$@s      @sfffff@s     @s      @s(     @s,@s6fffff@s;33333@s6fffff@s4@s6fffff@s4@s333333@s0     @s)@s     @r     @rfffff@rp     @r4@r33333@qfffff@q     @q.fffff@p     @p<@p33333@o     @o@     @n     @mٙ@l33333@l@kfffff@ki@k6fffff@j@j     @j	@iC33333@h@hFfffff@g@gfffff@g33333@gp     @g33333@f@f33333@f     @ffffff@f陙@ffffff@e33333@e@ey@ec33333@eS33333@eC33333@e6fffff@e#33333@d     @d@d@d|@dC33333@d      @c@c33333@c33333@cp     @cffffff@cS33333@c      @bfffff@bvfffff@bL@b)@b     @a@aə@a@a@a@a     @aVfffff@a      @`陙@`@`@`fffff@`i@`C33333@`)@`      @`      @`)@`@`33333@_33333@_333333@^ٙ@^33333@^33333@^y@^l@^S33333@^@     @^      @^33333@^33333@^      @]@]33333@]ffffff@]Y@]Ffffff@]9@],@]      @\@\S33333@\,@\fffff@[ٙ@[33333@[33333@[     @[S33333@[&fffff@[33333@[33333@[      @Z33333@Z@Z     @Z33333@Z@     @Z@Yfffff@Yٙ@Y33333@Yfffff@Y@Y33333@Y9@X33333@Xٙ@Xfffff@X33333@Xfffff@X9@X      @W     @W     @Wfffff@Wl@W9@W      @W33333@W      @Vٙ@V     @Vy@VS33333@V@     @V,@V@Ufffff@U@Ul@UY@UL@U333333@Ufffff@Tfffff@Ts33333@Tffffff@Tffffff@TS33333@T@     @T&fffff@S33333@S33333@S@Sl@SY@S@     @S33333@R     @Rfffff@Ry@R@     @Q33333@Qٙ@Qfffff@Q@Qfffff@Q33333@Q@Qffffff@Q&fffff@Pٙ@P@P     @P@P     @PY@P,@P@P33333@P@O33333@O@O33333@O     @Os33333@OY@O@     @O333333@O@Nfffff@Nfffff@N@N33333@Nffffff@N@Mfffff@M@M33333@M33333@M33333@Mfffff@Mfffff@Ms33333@M&fffff@M      @L@L@L     @L     @LL@LL@L&fffff@L      @K33333@Kٙ@K     @Kfffff@K@Kfffff@K@K     @Ks33333@KL@K&fffff@K@J33333@J@Jfffff@J     @Js33333@JY@J@     @J@I33333@J@J&fffff@JY@J33333@K@K333333@K@J33333@J     @Jffffff@JY@Jffffff@Js33333@J@J@Js33333@Jffffff@JY@J&fffff@J&fffff@J@J@J@Ifffff@Ifffff@I@I33333@I@I     @IY@IY@I@     @I@H@H     @H33333@Hs33333@Hs33333@HY@H@     @H&fffff@Gfffff@G@Gs33333@Gffffff@GY@GL@GL@G333333@G@F33333@F     @F@F@Fffffff@FY@F@     @F@F      @Efffff@E@E@E@E@E     @E@E     @E@E     @Es33333@Effffff@E@     @E@Dfffff@D33333@D@DL@D@D@D      @C33333@C33333@C33333@C33333@C     @C@C@C     @C     @C     @Cffffff@C@     @C333333@C333333@C&fffff@C@C@C      @C@C@C@B33333@B33333@C      @B33333@Bfffff@B33333@B33333@B33333@B33333@Bٙ@B@B33333@B@B     @BL@B@     @B@     @BL@B@     @B@     @B333333@B333333@B&fffff@B@B@A33333@Afffff@Aٙ@Aٙ@A@Aٙ@Afffff@Afffff@Afffff@A@A     @A@Affffff@AL@A@     @A@     @A&fffff@A      @@fffff@@ٙ@@     @@     @@33333@@fffff@@s33333@@L@@ffffff@@ffffff@@ffffff@@ffffff@@s33333@@Y@@L@@L@@@     @@@     @@&fffff@@&fffff@@@@@?fffff@?33333@?     @?L@?333333@?      @>@>@>     @>@>@>L@>333333@>      @=fffff@>@>      @>@>@>      @>      @>      @>      @=fffff@=fffff@=fffff@=fffff@=fffff@=fffff@=33333@=@=33333@=     @=     @=     @=@=@=33333@=fffff@>333333@>@>333333@>@>@>@>      @=fffff@=fffff@=fffff@=fffff@>      @>      @=fffff@=fffff@=@=33333@=33333@=33333@=33333@=@=33333@=@=@=@=33333@=@=@=@=     @=ffffff@=ffffff@=ffffff@=333333@=333333@=333333@=333333@=@=      @=333333@=L@=ffffff@=     @=ffffff@=L@=L@=@=333333@=@=@=@=      @=      @<fffff@<fffff@<fffff@<@<     @<ffffff@<ffffff@<     @<ffffff@<L@<333333@<      @;fffff@;@;33333@;33333@;fffff@;@;33333@;@;@;@;ffffff@;     @;L@;L@;L@;333333@;      @;      @:@:33333@:@:@:33333@:     @:@:@:     @:ffffff@:ffffff@:ffffff@:L@:L@:333333@:333333@:L@:333333@:@:333333@:@:@:      @:333333@:333333@9fffff@9fffff@9@933333@933333@933333@9     @9@9     @9     @9     @9ffffff@9ffffff@9333333@9L@9L@9333333@9@9      @9@9@9@9      @9      @8fffff@8fffff@8fffff@9      @8fffff@8@8fffff@8fffff@8fffff@8fffff@8@8fffff@8@8@8@833333@8fffff@8fffff@8fffff@8@8@8fffff@8@8@8fffff@8fffff@8@8@8@833333@8@833333@8@8@8@8@8     @8ffffff@8333333@8333333@8@8@8      @8333333@8      @7@7fffff@7fffff@7fffff@7@7@733333@7@7@733333@733333@733333@733333@733333@7@733333@733333@733333@733333@733333@733333@7@7@733333@733333@7@733333@7@733333@733333@7@7@733333@733333@7@7@733333@7@7     @7@733333@733333@7@7@733333@733333@733333@7@7@7fffff@7fffff@7@7@8      @7fffff@8      @7fffff@8      @7fffff@7fffff@7fffff@7fffff@7fffff@7fffff@7fffff@7fffff@7fffff@8      @8      @7fffff@7fffff@8      @7fffff@7fffff@7fffff@7fffff@7fffff@7fffff@7fffff@8      @8      @7fffff@8      @7fffff@7fffff@8      @8      @7fffff@7fffff@7fffff@7@7fffff@7@7fffff@8      @7fffff@7@7fffff@7@7fffff@733333@733333@733333@7     @7@7ffffff@7ffffff@7ffffff@7ffffff@7ffffff@7L@7ffffff@7ffffff@7L@7     @7@7     @7@7@7@7@7     @7@7     @7     @7     @7     @7@7ffffff@7     @7ffffff@7     @7     @7     @7@7ffffff@7ffffff@7     @7     @7L@7L@7     @7     @7ffffff@7ffffff@7ffffff@7     @7333333@7L@7ffffff@7333333@7333333@7L@7L@7L@7333333@7333333@7333333@7333333@7333333@7@7@7@7@7@7      @7333333@7@7333333@7@7      @7@7333333@6fffff@7      @7      @7      @7      @7      @7      @6@6@6fffff@6@6fffff@633333@6@6fffff@6@6@6@6fffff@6@6fffff@6@6@633333@633333@633333@6@633333@6@6@6@6@6@6@633333@6@6@6@6@6     @6     @6     @6     @6     @6     @6     @6     @6ffffff@6L@6L@6ffffff@6     @6ffffff@6L@6L@6333333@6ffffff@6333333@6L@6L@6333333@6L@6333333@6333333@6L@6333333@6333333@6@6333333@6333333@6@6333333@6@6@6333333@6      @6333333@6@6      @6@6@5@6333333@6@6      @6      @6333333@6      @5fffff@5fffff@5fffff@5fffff@5fffff@5fffff@5fffff@5fffff@5fffff@5fffff@5fffff@5fffff@5fffff@5@5fffff@533333@5fffff@5@5@5@5@5@5@5fffff@5fffff@5@533333@5@5@5fffff@5fffff@533333@5@5@5@5@533333@533333@5fffff@5fffff@5@5@533333@5@5@533333@533333@533333@5@5@5@533333@533333@5@5@533333@5@5@533333@533333@533333@533333@5@5@533333@533333@533333@5@5@5@533333@533333@533333@5@5@533333@533333@5@5@533333@5@5@5@5@5@5ffffff@5@5@5     @5@5     @5@5@5     @5@5     @5     @5     @5@5     @5ffffff@5@5ffffff@5ffffff@5@5     @5     @5     @5     @5     @5ffffff@5@5     @5ffffff@5ffffff@5L@5ffffff@5ffffff@5ffffff@5ffffff@5     @5ffffff@5L@5ffffff@5     @5ffffff@5ffffff@5     @5ffffff@5L@5ffffff@5L@5L@5ffffff@5L@5ffffff@5     @5ffffff@5ffffff@5@5L@5     @5L@5333333@5L@5     @5L@5333333@5333333@5L@5L@5333333@5L@5L@5333333@5ffffff@5L@5333333@5L@5L@5ffffff@5L@5333333@5333333@5L@5333333@5333333@5L@5333333@5333333@5L@5@5333333@5333333@5333333@5L@5333333@5333333@5333333@5ffffff@5333333@5@5333333@5333333@5333333@5333333@5@5333333@5333333@5333333@5      @5333333@5@5L@5333333@5@5333333@5333333@5333333@5@5@5      @5@5      @5@5333333@5@5      @5@5@5@5      @5@5333333@5@4fffff@5@5      @5      @4fffff@5@4fffff@4fffff@4@4fffff@4fffff@4fffff@4fffff@5      @4fffff@4fffff@4@4@4@4fffff@4@4@433333@433333@433333@4@433333@433333@433333@4@4@433333@433333@4@4@4@4@4@4@4@4@433333@4     @4     @4     @4@433333@4ffffff@4     @4L@4ffffff@4L@4ffffff@4ffffff@4333333@4L@4333333@4L@4     @4L@4L@4ffffff@4333333@4L@4L@4L@4333333@4L@4L@4333333@4L@4333333@4L@4L@4333333@4L@4333333@4ffffff@4L@4ffffff@4ffffff@4L@4ffffff@4L@4L@4ffffff@4ffffff@4     @4ffffff@4L@4ffffff@4ffffff@4ffffff@4     @4     @4L@4ffffff@4ffffff@4ffffff@4ffffff@4ffffff@4     @4ffffff@4ffffff@4     @4     @4ffffff@4L@4L@4L@4L@4L@4ffffff@4333333@4L@4ffffff@4L@4L@4333333@4ffffff@4L@4333333@4L@4L@4333333@4L@4L@4333333@4L@4L@4333333@4333333@4L@4333333@4ffffff@4L@4     @4L@4333333@4333333@4333333@4L@4ffffff@4L@4L@4L@4333333@4@4L@4L@4333333@4333333@4333333@4@4333333@4333333@4333333@4333333@4333333@4333333@4333333@4333333@4L@4333333@4L@4L@4L@4333333@4333333@4333333@4333333@4ffffff@4ffffff@4333333@4333333@4ffffff@4L@4L@4333333@4333333@4333333@4L@4333333@4333333@4L@4L@4333333@4      @4@4      @4@4333333@4@4      @4L@4@4333333@4333333@4      @4@4L@4333333@4@4333333@4L@4333333@4      @4333333@4333333@4L@4@4333333@4333333@4333333@4333333@4333333@4333333@4L@4333333@4333333@4333333@4333333@4ffffff@4L@4L@4L@4333333@4333333@4     @4L@4ffffff@4ffffff@4@4     @4ffffff@4L@4ffffff@4     @4@4@4@4@4@433333@4@433333@4@433333@433333@4fffff@4@4@4@4fffff@4fffff@4fffff@5@4fffff@4fffff@4fffff@5@5@5333333@5333333@5      @5333333@5333333@5L@5L@5L@5ffffff@5L@5ffffff@5@5     @5ffffff@5     @5     @5     @5     @5     @5@5@5fffff@5@5fffff@5fffff@6@6      @5fffff@6      @5fffff@6@6@6333333@6333333@6333333@6ffffff@6ffffff@6L@6L@6     @6@6ffffff@6L@6fffff@6@6fffff@7      @6fffff@6fffff@6fffff@6@7333333@7333333@7333333@7L@7333333@7L@7     @7     @7@733333@733333@7     @7@7fffff@8      @8@8@8@8@8333333@8ffffff@8ffffff@8ffffff@8@8@8     @8@833333@8@8@9@9      @9      @9333333@9L@9L@9ffffff@9     @9     @9     @9     @933333@9fffff@9@:@:      @:@:@:@:333333@:L@:333333@:@:333333@:     @:L@:     @:ffffff@:ffffff@:@:@:     @:     @:@:@:@:33333@:@:fffff@;      @;      @;@;      @;333333@;333333@;L@;333333@;ffffff@;ffffff@;     @;     @;     @;@;fffff@;@<@<      @<      @<      @<L@<333333@<     @<ffffff@<@<     @<@<33333@<33333@<33333@<33333@<fffff@=      @<@=      @=      @=@=L@=     @=@=33333@=33333@=@=fffff@=fffff@>      @>      @=fffff@>333333@>333333@>ffffff@>     @>ffffff@>ffffff@>     @>ffffff@>     @>     @>     @>333333@>L@>ffffff@>ffffff@>ffffff@>     @>ffffff@>@>33333@>@>@>33333@>fffff@?@?333333@?@?      @?333333@?ffffff@?@?@?     @?     @?33333@?fffff@@      @@&fffff@@@     @@Y@@L@@L@@ffffff@@ffffff@@s33333@@     @@ffffff@@@@     @@     @@@@fffff@@fffff@@     @@     @@@@     @@     @@@@@@fffff@@fffff@@33333@A      @A@A@A@A&fffff@A@A@A@     @AL@AY@Affffff@Affffff@Affffff@Affffff@As33333@As33333@A@Afffff@Afffff@A33333@A     @A     @A@Afffff@Afffff@Afffff@Afffff@B      @B@B@B333333@B@B333333@BL@BL@B@     @BL@BL@BY@Bffffff@Bffffff@BY@Bs33333@B     @Bffffff@B@B@B     @B     @B     @B@B     @Bfffff@B33333@Bfffff@Bٙ@B@Bٙ@Bfffff@Bfffff@Bfffff@C@C@C@C&fffff@C333333@C333333@Cffffff@CY@Cffffff@Cs33333@Cs33333@C@C@Cfffff@C33333@C     @C     @C33333@C33333@Cfffff@Cfffff@Cfffff@D      @Cfffff@D@D@D@D@D@D@D333333@DY@DL@DY@DL@D@     @DL@D@D     @D     @D@D@D@D     @D33333@Dٙ@D     @Dٙ@D33333@Dٙ@Dfffff@E      @D33333@Dfffff@Dfffff@D33333@E@E      @E@E@E&fffff@E@E@E333333@E&fffff@E333333@E333333@E@E333333@E@     @E     @E@E     @E@E@E33333@Efffff@E@E@E33333@E@Efffff@Efffff@Eٙ@E     @E     @E33333@F@F      @F@F@F@F@     @F@     @F333333@FL@FY@F     @F@F     @Fffffff@FY@F@F33333@F@F     @F33333@F@Fٙ@F33333@G      @G&fffff@G@G      @G333333@G@     @G333333@G@G&fffff@G333333@G     @G     @Gfffff@G@Gfffff@G33333@G33333@G@G@G     @Gfffff@H      @H@H      @H&fffff@H333333@H&fffff@H@H333333@H333333@H&fffff@HL@H@     @HL@HL@HY@H@Hfffff@H33333@H     @Hٙ@H33333@Hٙ@H@Hٙ@H33333@I@I@I@I&fffff@I&fffff@I@     @I333333@I&fffff@I&fffff@I@     @IY@IY@Iffffff@I     @Is33333@Is33333@I     @IL@I@I@Ifffff@Ifffff@I33333@I33333@I@I@Ifffff@I33333@J@J@J@J&fffff@J@     @J&fffff@JY@JL@Jffffff@Js33333@JY@Jffffff@J     @Jfffff@J@J     @J     @J     @Jfffff@Jfffff@Jfffff@J33333@J33333@J     @J@Jٙ@J@Jfffff@J33333@Jfffff@Jٙ@J33333@K      @K&fffff@K@K&fffff@K&fffff@K&fffff@K&fffff@K333333@K333333@K@     @K@     @KY@Ks33333@K@     @KL@Kffffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               ?bM?lC?9XbM?XbM?ꗍO;d??|hs?m?E?7KƧ?ěS?l?+J?=p
=?S?^5?|?5?|h?=p
=?^5?|?bM?I^5??~"?1&x?+?tj~?GzH?~"?;dZ?$/?tj~?vȴ9?dZ1?Vt?Ƨ-?"`B?I^5?}?tj?=p
=?vȴ9X?nP?lD?Q?+I^?nO?\(?Q?Q?+?j~"?m?ȴ9Xb?hr Ĝ?
=p
?bM?      ?1&x?n?`A7?M?E?Q?7KƧ?"`?S?Vu?1&?(\)?
=p?p
=q?Q?vȴ?$/?9XbM?nO?=p
=?p
=q?+?ffffff?x??^5?|?~"?XbM?Gz?E?ۅQ?333333?ى7KƧ?x??|hs?$/?\(?O;dZ?ղ-V?S?ffffff?E?(\)?tj~?1&x?I^5?^5?|?XbM?+J?д9XbN?Гtj~?m?˅Q?=p
=?+?-V?KƧ?+I^?$/?zG{?\(?\(?9XbM?+?Õ$/?tj~?9XbM?nP?Q?ěS?ěS?$/?&x?333333?bM?-V?bM?l?hr Ĝ?lD?/v?Õ$/?Q?&x?nP?`A7L?nP? ěT?GzH?&x?nO;?j~"?hr Ĝ?
=p?vȴ9X?ěS?M?&x?+?
=p?hr Ĝ?|hr?vȴ9X?`A7L?hr Ĝ?bM?j~"?n?7KƧ?|hr?      ?hr!?"`? ěT?vȴ9X?nP?nP?E?Q?nO?I^5??Q?`A7L?bM?-V?E?n?$/?ěS?I^5??Q?° ě?\(?7KƧ?ěS?;dZ?      ?$/?A7Kƨ?`A7L?$/?`A7L?"`?`A7L?&x?nO;?Q?`A7L?M?l?vȴ9X?I^5??n?hr Ĝ?-V?"`?-V?Q?M?n?`A7L?&x?
=p?vȴ9X?Q?9XbM?° ě?nO;?      ?bM?A7Kƨ?I^5??+?$/?7KƧ?7KƧ?n?öE?l?\(?-V?333333?tj~?7KƧ?M?9XbM?S?° ě?      ?+?hr Ĝ?nO;?n?7KƧ?7KƧ?333333?-V?I^5??n?öE?ěS?$/?n?M? ěT?bM?I^5??GzH?Z1'?333333?Õ$/?-V?l?ļj~#?-V?ěS?\(?n?7KƧ?Q?nO;?zG{?hr Ĝ?S?öE?\(?\(?GzH?tj?\(?tj~?Õ$/?\(?M?GzH?hr Ĝ?S?`A7?nO?nP?I^5??nO?
=p?tj~?Z1'?9XbM?nO;?"`?I^5??Õ$/?-V?I^5??A7Kƨ?Q?nO;?lD?-V?tj?hr Ĝ?9XbM?ěS?° ě?nO;?
=p?tj~?\(?M?öE?nO;?`A7?+?zG{?ěS?`A7?
=p?n?nP?I^5??tj?GzH?° ě?`A7L?tj~?nO?I^5??E?
=p?Õ$/?\(?M?-V?|hr?S?öE?nO;?9XbM?/v?nO;?lD?&x?lD?tj~?ļj~#?Q?7KƧ?333333?GzH?M?S?S?nO;?`A7?A7Kƨ?hr Ĝ?Q?-V?333333?-V?GzH?"`?
=p?l?tj?° ě?hr!?ěS?lD?GzH?I^5??Õ$/?Q?Z1'?-V?ļj~#?`A7L?l?&x?Q?lD?M?Õ$/?nO;?ěS?S?I^5??lD?I^5??n?öE?\(?° ě?lD?I^5??ěS?tj~?-V?$/?I^5??I^5??&x?\(?-V?lD?M?GzH?7KƧ?nO;?A7Kƨ?ěS?GzH?`A7L?&x?nO;?GzH?M?`A7?&x?-V?hr Ĝ?A7Kƨ?I^5??-V?° ě?l?M?&x?      ?7KƧ?M?l?° ě?S?nO?Q?lD?lD?      ?$/?-V?S?hr Ĝ?l?$/?nP?GzH?nO?n?\(?n?M?I^5??l?Z1'?Q?`A7?ěS?;dZ?n? ěT?$/?`A7L?$/?nO;?nP?l?lD?Q?9XbM?° ě?7KƧ?333333?hr Ĝ?S?Q?S?333333?nO?\(?-V?S?S?S?nO?-V?l?&x?Õ$/?7KƧ?GzH?hr Ĝ?\(?ěS?GzH?\(?
=p?I^5??° ě?$/?n?hr Ĝ?9XbM?l?n?nO?Z1'?\(?nO;?M?333333?GzH?$/?zG{?$/?$/?n?ěS?l?M?tj~?tj~?hr Ĝ?M?S?l?S?-V?hr Ĝ?Õ$/?
=p?/w?nP?n?S?tj~?tj?Õ$/?zG{?M?° ě?`A7?Z1'?öE?`A7?Z1'?      ?`A7?GzH?Ł$/?nO?vȴ9X?333333?&x?nO;?&x?333333?E?l?nO;?nO?l?7KƧ?n?9XbM?Q?° ě?zG{?hr Ĝ?7KƧ?öE?nO;?lD?n?Q?-V?nO;?I^5??hr Ĝ?$/?ěS?7KƧ?`A7?šo?tj~?ěS?$/?Z1'?7KƧ?GzH?A7Kƨ?333333?S?öE?n?tj~?M?GzH?° ě?M?-V?nO;?-V?\(?\(?I^5??Q?S?`A7L?-V?&x?GzH?GzH?lD?lD?nP?nO?° ě?° ě?333333?° ě?hr Ĝ?\(?tj~?
=p?ěS?I^5??GzH?n?° ě?-V?nO;?$/?lC?/w?\(?-V?-V?S?GzH?I^5??nO?° ě?`A7K?S?333333?Q?tj?nO?`A7L?M?7KƧ?9XbM?
=p?-V?+?l?l?tj?-V?nO?`A7?öE?tj~?333333?7KƧ?\(?333333?`A7?$/?5?|h?`A7L?M?333333?hr Ĝ?Q?tj~?GzH?\(?Q?`A7?333333?-V?333333?\(?° ě?nO?`A7?Q?nO;?9XbM?l?-V?nO;?S?S?nO?° ě?n?nO?nO?nO;?A7Kƨ?`A7?nO?/w?9XbM?l?$/?
=p?
=p?ěS?l?Z1'?
=p?l?
=p?M?zG{?ļj~#?Õ$/?7KƧ?öE?tj~?&x?° ě?Q?E?nO;?S?ěS?`A7?S?333333?nO;?nO?A7Kƨ?\(?\(?`A7?7KƧ?n?zG{?nO?l?Q?tj?7KƧ?
=p?&x?Õ$/?-V?tj?`A7?7KƧ?7KƧ?S?M?lD?nO?S?° ě?333333?öE?$/?nO?° ě?S?tj~?lD?`A7L?I^5??lD?ļj~#? ěT?S?Q?ļj~#?`A7?S?Q?
=p?E?nO?-V?7KƧ?&x?GzH?M?ěS?Q?Q?hr Ĝ?7KƧ?° ě?-V?nP?zG{?333333?bM?333333?tj~?tj~?`A7L?&x?l?M?öE?M?nO?`A7?tj?333333?S?Z1'?-V?
=p?öE?nO?nO?-V?nO;?l?$/?tj~?hr Ĝ?n?
=p?-V?nP?ěS?S?° ě?333333?7KƧ?tj~?nO;?nO?hr Ĝ?$/?ěS?tj?tj~?9XbM? ěT?nO;?S?\(?M?lD?bM?
=p?M?I^5??nO;?nO;?l?nO?öE?`A7?n?S?
=p?
=p?Õ$/?`A7?nO;?9XbM?l?tj~?n?Õ$/?ěS?&x?n?+?nO;?
=p?-V?hr Ĝ?\(?+?-V?bM?&x?`A7?zG{?\(?S?-V?lD?lD?
=p?l?-V?S?Q?\(?`A7?nO;?333333?öE?M?Q?
=p?nO;?/w?° ě?nP?tj~?$/?M?`A7L?lD?Q?nO;?Z1'?ěS?ěS?l?Q?M?öE?ěS?333333?
=p?+?
=p?M?° ě?lD?ěS?Z1'?`A7?`A7?&x?M?GzH?A7Kƨ?hr Ĝ?lD?Q?° ě?`A7L?n?Q?M?öE?nO?7KƧ?
=p?nP?vȴ9X?\(?/w?
=p?I^5??Õ$/?&x?lD?$/?tj?
=p?Q?nO;?M?zG{?l?-V?l?S?333333?333333?Ł$/?      ?\(?9XbM?I^5??Q?n?öE?lD?GzH?`A7?° ě?lD?-V?ļj~#?° ě?&x?nO;?M?tj?7KƧ?Q?° ě?tj~?tj~?Õ$/?Z1'?nO?$/?Z1'?
=p?Õ$/?I^5??S?9XbM?
=p?-V?hr Ĝ?tj~?-V? ěT?&x?ěS?Ł$/?+?GzH?Q?I^5??° ě?lD?-V?ļj~#?M?M?GzH?nO;?öE?Q?`A7L?tj~?ěS?-V?hr Ĝ?`A7L?S?-V?S?-V?nO;?tj?333333?bM?lD?Õ$/?ěS?l?hr Ĝ?I^5??tj~?bM?9XbM?
=p?n?$/?\(?&x?hr Ĝ?öE?-V?`A7?tj~?nO?&x?° ě?
=p?M?\(?° ě?° ě?$/?
=p?Q?Q?333333?° ě?l?ěS?`A7?hr Ĝ?9XbM?nO;?`A7?Õ$/?M?nO?333333?I^5??5?|h?Q?
=p?\(?`A7L?Õ$/?° ě?`A7?nO?/w?E?-V?nO?l?° ě?`A7?zG{?333333?M?nO;?nO;?GzH?-V?ěS?\(?7KƧ?\(?nO?S?tj?333333?\(?S?° ě?9XbM?öE?šo?333333?nO?tj~?\(?A7Kƨ?      ?-V?
=p?`A7?° ě?ěS?`A7?Q?M?`A7?l?&x?
=p?hr Ĝ?$/?n?+?ļj~#?+?zG{?° ě?nO?tj?° ě?Q?nO;?tj?lD?ěS?M?`A7?333333?
=p? ěT?nO;?`A7?Q?n?GzH?M?I^5??\(?-V?\(?Q?° ě?`A7L?Z1'?333333?7KƧ?lD?lD?Q?l?n?tj~?zG{?\(?Q?`A7L?S?hr Ĝ?tj?Q?lD?nO;?ļj~#?`A7?lD?
=p?7KƧ?hr Ĝ?lD?nO;?nO;?333333?I^5??nO?Õ$/?lD?° ě?nP?GzH?      ?ěS?Õ$/?$/?-V?-V?M?lD?ěS?7KƧ?Z1'?n?nO;?-V?M?Q?zG{?7KƧ?9XbM?&x?-V?333333?`A7L?Q?Q?l?`A7?nO?$/?      ?tj~?/w?S?E?Õ$/?\(?tj~?GzH?hr Ĝ?`A7?lD?`A7?`A7?Q?\(?ěS?7KƧ?I^5??° ě?Q?9XbM?-V?
=p?-V?333333?° ě?-V?GzH?-V?
=p?333333?tj?7KƧ?nO?7KƧ?n?I^5??l?-V?nO?-V?-V?° ě?zG{?$/?tj~?tj~?Q?S?lD?nO;?$/?Q?E?&x?-V?n?n?vȴ9X?E?tj?Z1'?l?tj?° ě?7KƧ?bM?hr Ĝ?öE?zG{?° ě?S?tj~?`A7?S?+?zG{?I^5??-V?nO;?nO;?Õ$/?`A7?7KƧ?GzH?7KƧ?Q?7KƧ?
=p?öE?333333?nO?&x?&x?S?-V?lD?`A7?"`?nO;?Q?nO?nO?`A7L?hr Ĝ?tj~?&x?S?M?° ě?ļj~#?nO;?Õ$/?\(?-V?;dZ?GzH?&x?\(?M? ěT?\(?tj~?/w?Q?öE?-V?-V?vȴ9X?nO?`A7?M?Q?ļj~#?
=p?l?9XbM?ļj~#?hr!?-V?`A7?
=p?° ě?$/?333333?I^5??\(?S?nO?ěS?I^5??° ě?zG{?hr Ĝ?nO;?333333?-V?zG{?ěS?`A7?Õ$/?I^5??Q?Õ$/?l?ěS?öE?
=p?tj?E?S?nO?9XbM?E?S?E?ěS?7KƧ?E?
=p?M?M?I^5??nP?I^5??&x?A7Kƨ?Q?`A7?\(?ěS?7KƧ?+?ěS?I^5??° ě?
=p?+?9XbM?° ě?9XbM?l?lD?$/? ěT?hr Ĝ?Õ$/?j~"?S?° ě?Q?-V?\(?`A7?I^5??`A7?nP?      ?Õ$/?lD?7KƧ?-V?tj?öE?öE?+?tj~?`A7?ļj~#?l?Õ$/?-V?$/?`A7?I^5??S?333333?l?`A7?lD?GzH?nO;?tj?
=p?A7Kƨ?hr Ĝ?
=p?A7Kƨ?l?`A7L?`A7?öE?nO;?nO?GzH?hr Ĝ?tj?l?`A7?&x?/v?-V?lD?I^5??öE?-V?tj?-V?`A7?nO;?M?nO?\(?tj?ěS?nP?° ě?`A7?A7Kƨ?Õ$/?S?nP?Q?n?\(?$/?° ě?-V?° ě?hr Ĝ?GzH?333333?I^5??7KƧ?`A7?M?\(?&x?333333?Õ$/?l?GzH?`A7?hr Ĝ?lD?hr Ĝ?lD?nO;?-V?ěS?GzH?Q?333333?GzH?`A7?l?333333?I^5??+?`A7L?`A7?° ě?nO?
=p?öE?zG{?-V?7KƧ?nO?nO;?tj~?hr Ĝ?° ě?l?9XbM?
=p?nO;?bM?
=p?A7Kƨ?hr Ĝ?n?333333?lD?lD?hr Ĝ?l?/w?nO;?333333?A7Kƨ?I^5??\(?S?`A7L?$/?Õ$/?ěS?GzH? ěT?n?`A7L?`A7?M?\(?M?Õ$/?nO;?l?333333?nO?öE?tj~?$/?nO?A7Kƨ?-V?Q?;dZ?A7Kƨ?+?S?`A7?Õ$/?-V?n?ěS?n?ěS?nO?GzH?n?-V?bM?n?-V?nO?nO;?333333?ěS?n?Q?333333?n?ěS?I^5??hr Ĝ?GzH?nO?bM?l?Õ$/?
=p?° ě?`A7L?9XbM?Q?Q?-V?nP?7KƧ?      ?&x?° ě?hr Ĝ?&x?nO;?7KƧ?° ě?lD?nP?-V?ěS?ěS?-V?° ě?I^5??° ě?tj~?7KƧ?-V?`A7L?nP?333333?ěS?9XbM?A7Kƨ?lD?hr Ĝ?A7Kƨ?bM?GzH?
=p?bM?-V?ěS?7KƧ?\(?I^5??n?lD?nP?Q?GzH?Q?bM?ěS?`A7?&x?$/?7KƧ?$/?\(?S?° ě?nO;?Õ$/?$/?vȴ9X?lD?n?tj?\(?&x?GzH? ěT?lD?öE?7KƧ?&x?n?Q?GzH?S?nO;?nO;?I^5??Q?`A7L?I^5??`A7L?n?&x?° ě?bM?&x?A7Kƨ?lD?n?° ě?l?GzH?S?lD?I^5??\(?ěS?I^5??nO;?7KƧ?
=p?GzH?-V?|hr?nO?333333?vȴ9X?`A7L?$/?7KƧ?-V?GzH?&x?Õ$/?$/?`A7L?&x?n?
=p?Q?      ?vȴ9X?
=p?
=p?l?n?$/?A7Kƨ?° ě?S?333333?"`?$/?&x?tj~?n?I^5??nO;?ěS?I^5??-V?I^5??lD?GzH?I^5??n?n?7KƧ?M?° ě?hr Ĝ?-V?lD?M?ěS?-V?;dZ?n?lD?hr Ĝ?`A7?ěS?n?ěS?° ě?l?nO;?-V?nO;?l?n?
=p?"`?7KƧ?nO;?333333?nP?"`?vȴ9X?Q?Q?I^5??Q?nO;?A7Kƨ?$/?333333?E?7KƧ?vȴ9X?ěS?7KƧ?nO;?vȴ9X?-V?A7Kƨ?vȴ9X?Q?
=p?lD?$/?Q?lD?
=p?lD?\(?9XbM?&x?A7Kƨ?nP?`A7L?GzH?bM?lD?-V?A7Kƨ?-V?A7Kƨ?-V?&x?&x?7KƧ? ěT?bM?5?|h?GzH?A7Kƨ?&x?nP?&x?I^5??`A7L?E?GzH?l?ěS?nO?nP?7KƧ?tj~?öE?hr Ĝ?hr Ĝ?A7Kƨ?;dZ?GzH?
=p?vȴ9X?$/?9XbM?nO?nO;?7KƧ?$/?nO;?7KƧ?GzH?° ě?-V?hr Ĝ?
=p?hr Ĝ?M?M?j~"?vȴ9X?$/?° ě?bM?Q?Q?A7Kƨ?|hr?`A7?&x?nP?nP?|hr?$/?I^5??ěS?
=p?/v?      ?&x?(\)?
=p?Q?öE?&x?A7Kƨ?ěS?l?      ?nP? ěT?&x?&x?l?ěS?hr Ĝ?`A7?333333?Q?&x?-V?vȴ9?ěS?n?vȴ9X?nP?
=p?Q?nP?
=p?\(?nP?ěS?$/?hr Ĝ?\(                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	@M@M&fffff@M@M333333@M&fffff@M&fffff@M&fffff@M@M&fffff@M@M&fffff@M@M@M@M@M@M@M@M@M&fffff@M&fffff@M@     @M@Ms33333@Mfffff@M33333@M@Mٙ@M     @M33333@M33333@M@M@M@Mfffff@Mfffff@M@M@Mfffff@M33333@M@N      @N@N333333@Ns33333@N33333@OL@O     @O33333@O33333@Oٙ@Offfff@O33333@Offfff@Offfff@O@Oٙ@O33333@P      @P      @O33333@P      @Pfffff@P@P33333@P@P@P      @P,@P333333@P9@P9@P@     @PFfffff@PL@PS33333@P`     @Pffffff@Pffffff@Pl@Ps33333@Ps33333@Ps33333@Ps33333@Ps33333@Pl@P     @P     @Py@Pfffff@Pfffff@Py@Pfffff@Pfffff@P@P@P33333@P@P@P@P@P     @P     @Pfffff@Pfffff@P@P33333@P33333@P33333@P@P@P@P@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P@P     @P     @P     @P     @P     @P     @P     @Pfffff@P@P@P@P@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P@P     @P     @P     @Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@P@P@P@P     @Pfffff@P@Pfffff@P@P@P33333@P@P33333@P33333@P33333@P33333@P33333@Pٙ@P33333@P33333@P33333@Pٙ@Pٙ@P33333@P33333@P33333@Pٙ@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@Pfffff@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P@P@P33333@P@P@P@P@Pfffff@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@Pfffff@P@P33333@P33333@P@P@P33333@P@P@P@P     @P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P@P@Pfffff@P     @Pfffff@P@Pfffff@Pfffff@P@P@P@Pfffff@Pfffff@Pfffff@P     @Pfffff@P@Pfffff@Pfffff@P@Pfffff@Pfffff@P@P33333@Pfffff@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P     @P@P@P@P@P@P@P@P     @P@P@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@Pٙ@P33333@Pٙ@Pٙ@P33333@Pٙ@P@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@P@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @P     @Pٙ@P     @Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @P     @Pٙ@P     @P     @Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @P     @P@Pfffff@Pٙ@Pٙ@Pٙ@P33333@Pٙ@P     @P     @Pٙ@Pٙ@Pfffff@Pٙ@P     @Pٙ@P     @P     @P     @Pٙ@P     @P     @P     @P     @Pٙ@P     @P     @P     @P     @P     @P     @P     @Pٙ@P     @P     @P     @Pٙ@P     @P     @P     @P     @Pٙ@P     @P     @P     @Pٙ@P     @P     @P     @P     @Pٙ@P     @P     @P     @Pٙ@P     @P     @P     @P     @P     @Pٙ@P     @P     @P     @P     @Pٙ@P     @P     @P     @P     @P     @Pٙ@P     @P     @P     @P     @P     @P     @P     @Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pٙ@P     @P     @P     @P     @P     @Pٙ@P     @Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@P     @Pٙ@Pٙ@P     @P     @Pfffff@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@P     @P     @Pٙ@P     @P     @P     @P     @P     @Pfffff@P     @Pfffff@P     @P     @P     @P     @Pٙ@P     @P     @Pٙ@P     @Pfffff@P     @P     @P     @P     @Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@P     @P     @P     @P     @Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@P     @Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @P     @Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P33333@Pfffff@Pٙ@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@P@P@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@Pfffff@P@P@P@Pfffff@Pfffff@P@Pfffff@P@P@P@P@P@P@Pfffff@P@P@P@P@P@Pfffff@Pfffff@P@P@P@P@P@P@P@Pfffff@P@P@P@P@Pfffff@P@P@P@P@P@Pfffff@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@Pfffff@P@P@Pfffff@Pfffff@P@P@Pfffff@P@P@P@Pfffff@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P@P33333@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P33333@P33333@P@P@P@P33333@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@Pfffff@P@P33333@P33333@P33333@P@Pfffff@P@P@P@P@P@P33333@P33333@P33333@P@P@P@P@P33333@P@P@P@P@P@P33333@P@P33333@P33333@P33333@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@Pfffff@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P@P@P33333@P@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P@P@P@P@P33333@P@P@P@P@P@P33333@P33333@P@P33333@P@P33333@P@P33333@P@P@P33333@P33333@P@P@P@P@P33333@P33333@P33333@P@P33333@P33333@P@P33333@P33333@P33333@P@P@P33333@P@P@P@P33333@P@P@P@P@P@P@P@P@P33333@P33333@P@P@P@P@P33333@P33333@P@P@P@P@P@P@P33333@P33333@P@P@P@P33333@P33333@P33333@P33333@P@P@P@P@P33333@P@P@P33333@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P33333@P33333@P33333@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P@P@P@P@P33333@P@P@P@P@P@P@P@P33333@P@P@P33333@P33333@P33333@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P@P@P@P@P33333@P@P@P33333@P33333@P33333@P33333@P@P33333@P@P@P@P@P@P@P33333@P@P33333@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               P35                                     1                                       ,BGM3À