CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20120522   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P24    CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:48.334689Z    ORIGINAL_HEADER      sCTD,20250210CCHSIOWB
#Renamed 'CTDFLUOR_TSG' to 'CTDFLUOR_ALT_1' with units 'MG/M^3'
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2018-11-29. CTD data from cruise 18DD20120522, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20120522. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2012-12/index.php. 
#
# The information in this file for the cruise 2012-12 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-0072.ctd
#
# Start of originator file comment header
#
#*2018/11/29 14:22:51.16
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2012/06/01 08:02:46.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 2006
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : C44EDC1F
#    NUMBER OF CHANNELS  : 9
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            2.3            2006.7
#       2 Temperature:CTD               deg_C_(ITS90)   1.9166         6.6907
#       3 Salinity:CTD                  PSS-78          32.6639        34.5892
#       4 Sigma-t:CTD                   kg/m^3          25.6458        27.6748
#       5 Transmissivity:CTD            %/m             61.4           67.9
#       6 Oxygen:Dissolved:CTD:Volume   ml/l            0.41           7.23
#       7 Oxygen:Dissolved:CTD:Mass     µmol/kg         17.9           314.7
#       8 Fluorescence:CTD:Seapoint     mg/m^3          0.24E-01       0.74
#       9 Fluorescence:CTD:Wetlabs      mg/m^3          0.102          1.096
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        6  F       ' '     1
#       6  -99   ' '        7  F       ' '     2
#       7  -99   ' '        6  F       ' '     1
#       8  -99   ' '        8  F       ' '     3
#       9  -99   ' '        8  F       ' '     3
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2012-12
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P24
#    EVENT NUMBER        : 72
#    LATITUDE            :  49  50.17000 N  ! (deg min)
#    LONGITUDE           : 142  40.04000 W  ! (deg min)
#    WATER DEPTH         : 3989
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    CTDEDIT was used to remove surface records and records corrupted by shed
#	wakes; salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Transmissivity, Fluorescence and PAR data are nominal and unedited except
#	that some records were removed in editing temperature and salinity.
#
#    For details on how the transmissivity calibration parameters were calculated
#	see the document Transmissivity_Calculation.pdf.
#
#    The Oxygen:Dissolved:CTD calibration was done using the method described in 
#	the Sea-Bird Application Note #64-2 (Sea-Bird_64-2_Jun2012.pdf).
#
#    The Oxygen:Dissolved:CTD data are considered, roughly, to be:
#	±0.1 ml/l from 0 to 125 dbar.
#	±0.06 ml/l from 125 to 500 dbar.
#	±0.04 ml/l from 500 to 2000 dbar.
#	±0.02 ml/l below 2000 dbar.
#
#    For details on the processing see processing report: 2012-12-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5-- --6--- --7-- ---8--- ---9---
#!Pressu Temperat Salinity Sigma-t: Trans Oxygen Oxyge Fluores Fluores
#!re:CTD ure:CTD  :CTD     CTD      missi :Disso n:Dis cence:  cence: 
#!                                  vity: lved:  solve CTD:    CTD:   
#!                                  CTD   CTD:   d:CTD Seapoin Wetlabs
#!                                        Volume :Mass t              
#!------ -------- -------- -------- ----- ------ ----- ------- -------
#*END OF HEADER
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @R         data_max      @R         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     >  .    pressure                	long_name         pressure   positive      down   units         decibar    data_min      @ffffff   data_max      @Z   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      >  l   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d           temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?d7   data_max      @F]c   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       >  ,   temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d           salinity                	long_name         salinity   units         PSS-78     data_min      @@T>   data_max      @AKjf   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      > 	   salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d       H8   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @1fffff   data_max      @s33333   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        > W   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d          CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?1&   data_max      ?7KƧ   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      > @   CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d          PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       >    PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d       3L   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min      @N33333   data_max      @P   C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     > B   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d          station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( T   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( |   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      )   data_max      )   C_format      %10d          latitude               	long_name         latitude   units         	degrees_N      data_min      @HY   data_max      @HY   C_format      %9.4f             	longitude                  	long_name         	longitude      units         	degrees_E      data_min      aZqx   data_max      aZqx   C_format      %9.4f             	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d           	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min        "   data_max        "   C_format      %4d        @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @ffffff@      @      @      @      @      @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A@AL@A33333@B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @Vy@Vٙ@W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[y@[ٙ@\fffff@\@     @\     @\     @]      @]@     @]fffff@]     @]@^@     @^     @^     @_      @_@     @_     @_fffff@`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e33333@e@e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f\@f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i\@i33333@i     @i     @i     @j      @j      @j@     @j`     @j     @j@j     @j     @k      @k      @kC33333@k\@k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @mC33333@m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o#33333@o9@offffff@o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q<@qL@q`     @qp     @q     @q     @q     @q     @q     @qfffff@q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r@r     @r     @r     @s      @s     @s      @s0     @sA@sP     @s`     @sp     @s@s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @tfffff@t33333@u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vQ@v^fffff@vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @wfffff@w!@w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @wᙙ@wfffff@x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x@xfffff@x     @x     @x     @x     @x     @x񙙙@y      @y     @y      @y0     @y@     @yNfffff@y^fffff@yp     @y     @y     @y     @y     @y     @y     @y     @y񙙙@yfffff@z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z@z     @z     @z     @z     @z     @{      @{@{fffff@{0     @{@     @{P     @{`     @{q@{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|Nfffff@|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~@~fffff@~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @Q@`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @d@p     @x     @     @     @@     @     @     @     @     @@     @     @     @     @     @     @     @      @     @     @@      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @@     @@     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X@`     @h     @p     @x     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @.fffff@8     @@     @H     @P     @X     @`@h@p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @      @(     @0     @8     @@     @H@P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@	@     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @@@     @     @     @     @     @     @     @     @     @     @噙@33333@     @      @     @     @     @      @(     @0@8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @@@@     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @g33333@p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h@o33333@x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @@33333@     @     @     @     @     @     @     @@     @33333@      @     @     @     @      @(     @0     @8     @@     @H     @P     @X@_33333@h     @p     @x     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @@     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @fffff@33333@     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$fffff@&fffff@,     @0     @4     @8     @<     @@     @D     @H     @J     @Q33333@T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @ fffff@$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @Ù@     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@噙@     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @~@fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @뙙@@     @     @     @      @     @     @     @     @     @     @     @ fffff@%33333@(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @Z                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @C@$/@ѷX@$/@ѷX@4m@n.@Zc@©@F]c@ ѷ@ ѷ@$/@!.I@1&y@&@y(@mhr!@kQ@h\)@g&@e1@dqj@cA [@c9@b`A@aR<6@`d8@`
qu@^Ov_خ@]+j@\ߤ@@ZY@ZQ_@XPH@Xtj@W@Vaf@TO
M@SMj@RsP@QX@QN;5@PbM@Nqi@Ks@F@@n@:xl"h
@	 @ᰉ'@䎊q@g@3@vȴ9@,=@?@1'@f1.@A:S@71@,>B[@&@!e@Y@xF]@>B@u"@m8@$tT@RT`d@8)@	 ѷ@p:@-w1@+C,z@ 6@#@-V@d7@lC@@F
L0@\(@?@9XbN@m\@O;@n@XD*@P|@KC%@HeO@3|@3MjO@&A@vȴ9@"}Vm@"M@;dZ@5?|@cA \@@	'RTa@M:@*0@bM@*0U2@$tS@B@mC\@M(@xl"h	@Ov_خ@,@4m@@˒:*@7rG@yY}@a.H@:S@@Fs@e@B&IR@#S@)ᰉ'@<Q@X_F@C%@,<@-
@+J@o@ï@U@6E@8YJ@<n.@:)_@;J#9@@6@Dtj@
=q@䎊@=p
@̘_@Ʌoi@O;dZ@䎊q@kP|@Z@p:@n@qu"@k~(@+I@@$tS@{lC@z^5?|@v}Vl@rs@n}Vl@ffffff@ZQ_@M%@F]cf@;5Xy@4#@-8Y@)ᰉ'@#Z@o @2W@~$@3@4m@4K@m\@͞&@e+@@҉@ɠ'RTa@ hۋ@kP|@@)^@!R<@I^5?@D@ ѷ@t9XbN@[W>6z@D2W@6Fs@!|Q@]ce@0
)@bM@҈@@b}V@4m@MjO@Xy=@>6z@As@7KƧ@ѷX@#w@Ov`@9@5?|@wkP@L/{@tSMj@nO;@`ěT@[=K^@UϪ͞@RS&@Jn@@4m9@0
(@)ᰉ'@$TɆ@!e@!-w1@@n@`A7@_o @~$@6z@Vϫ@*0U2@}Vl!@sPH@rs@o hۋ@ffffff@Z1'@P{@Ks@Ca@N@?@D*0@GzH@K]cA@@6@74m@43@2W@/Vϫ@0U2a|@/Vϫ@&@C,zx@Q@#S&@%u@49XbN@74m@2m\@0
(@$TɆ@Mj@%2@M:@Q@*0@1&@8Q@Q@I@SMj@~"@U=@\N@@˒:)z@<쿱@xF@y(@n.@F]c@nP@ݗ+@6z@+@˒:*@՛=K@K]c@/V@Mj@4m9@ql@ql@\(@{J#:@<쿱@?@	ԕ+@˒:)@IQ@}!.H@ݗ@g	l@Ϫ͟@)^	@@Z@B@	k~@Vl!@:S@ݗ+@˒:*@	@
D@@
:@p:~@p:@+j@bM@_F@@0
)@حV@%O
@+Q@3MjO@49XbN@:xl"h
@?H˒:@<j~#@2䎊q@/iDg8@.c	@',@-\@74m@6z@5sg@43@2GE85@3E@4D@5!.@7KƧ@8F]d@7kP@7KƧ@6z@64K@:)y@>ߤ?@CF]c@DS@Ik~(@ATɅo@1o@'	k@&IQ@.c	@%1@!.H@2a|Q@3|@2䎊q@.H@#A [@!-w1@+@U@b}@Q_@(\@Ov_خ@-V@*0@zG@p:~@
W'@˒:*@)^@*0@F]c@@ ѷ@@u%F
@Zc@s@I^5@&IR@@4n@Zc@s@TɅo@ n@ 4m9@b}V@.H@m\@\N<@\N<@$t@$t@\N<@E@?@J#9@>B@C\@@"`@@rGE8@-
@kP@Fs@GE85@r Ĝ@֡af@D@@@n.@sg@
(@r@r@O
M@1@v@v@O
M@U=@q@0
@*0U2a@/V@@wkP@hr @xF]@tj@|#x@z@v!.I@u%F
L@tj~@tD@u!R@ql@nc	@`
qu@V8YJ@Rp:@N;5X@M5Xy>@L_@I@GE84@G)^@M%@L/{J#@K]cA@E@A@C\N@Ca@N@?|hs@>ߤ?@>ߤ?@3ߤ@1&x@/v@,zxl"@#S&@'&@($xG@($xG@6C@u@L_@
L/{@	'RTa@?@Vl!@+jg@,<@Ϫ͟@@v_ح@NU@6z@쿱[@XbM@D@4֡b@vȴ9X@쿱[@)_@~($@KƧ@|@1@0
)@+j@$tS@*0@M:@?@4m9@}Vl!@{s@zC\@z@y"`@o4֡a@glC@d%1@a|Q@]/w@UϪ͞@Ov_ح@IQ@=b@333333@1[W>6@'/V@wkP@@I^5@
m\@
ڹZ@
PH@
F@
l@
@
Ov`@
+a@
d8@
8YJ@
m@
т@
#9@
4m@
NU@
Q@

(@
@
?@
tSM@
TɆ@
/@
=p@
-
@
Q@
u@
[@
C,zx@
S&@
@
O;dZ@
L/{@
k~(@
@
:S@
@
=p
@
7KƧ@
@4n@
wkP@
q@
o@
mC\@
k~($@
kP{@
kP{@
kC,z@
g8}H@
_?@
_;dZ@
R<64@
JL_@
8}H@
+a@@
(\)@
)*0U2a@
($xG@
%1@
 'RT`@
}H@
,<@
ݗ+k@
I^5?@
Q@($x@@	k~@!.I@!-w2@ ě@䎊q@PH@䎊q@GE85@l@-V@쿱[W?@ڹ@S@M@M@ᰉ'R@
qu@ce@$@`d@g8}@,zxl@@<64@S&@C-@m\@2W@{@r@@lD@>B[@
qv@{@}Vl@@.H@,=@@#@nP@~$t@zxl"h
@yrGE8@w1@nt@irGE@f,<@ffffff@eڹ@bC,@`
qu@\?@XU@U2a|@M%@H9Xb@Dg8}@<n.@9XbM@7Xe@5'0@2a|Q@0{@(TɅ@U=@Ov_@)^@
qu"@_o@@ ѷ@o hی@ڹZ@iDg8@lC@1.@e@ܑN;@l!-@@E84@
L/@ěS@&IR@NU@ߤ?@/V@3@'0@'RT@2X@w1@͞&@wkQ@vȴ@sh@ᰉ@$/@O
M@S&@u@qi@L_@'RTa@$/@     @u%F
L@ix@a|Q@]ce@\?@\>@Y+@Q@LcA \@E84֡@;A@0 ě@(@	@@qi@#@M:@
lC@
j~@
@
Q@
ڹ@
ޞ@

=p@
+@
D@
Q@
E84@
š@
o i@
Zc@
ߤ?@
j~#@
Y}@
Xe@
J@
O
M@
@
@
,=@
e+a@
@
+I@
nP@
4m9@
     @
˒:)@
|?@
rs@
o4֡a@
kC,z@
h@
_;dZ@
\(\@
Zݘ@
ZY@
Zݘ@
VϪ͟@
U2a|@
RT`d@
M:@
H9Xb@
E@
@6@
=p
=@
<64@
:)_@
9D@
12W@
'RT`e@
Ov_خ@
wkP@
qu!@
vȴ@
@
Mj@
	7KƧ@
u%F
@	.H@	Fs@	u!S@	4֡a@	C\@	\@	Q@	g	@	>BZc@	e@	ⶮ}Vm@	o@	>@	ۋq@	c	@	1'@	䎊@	8YK@	NU@	n.@	)@	?|h@	1@	*0U2a@	x@	IQ@	@	@	Fs@	)^@	L_@	JM@	     @	{~$@	x-
@	r{m@	mhr!@	k~($@	g	k@	c	@	_?@	^҈p;@	[W>6z@	V8YJ@	Rm@	Ks@	Fs@	B74@	=b@	<j~#@	;A@	9XbM@	0{@	-w1@	'RT`e@	"wkQ@	=K^@	ߤ?@	҈@	+I@	o h@	nP@	 IQ@H˒@G{@Y|@-V@\@C]@	ԕ+@7@	@e@?@,<@|@ΤT@#9@s@8YK@g8}@a@N@ߤ?@)y@#w@zG@*0U2a@?@	k@0
)@sh@zG@~($x@1&x@YJ@@     @yrGE8@r{m@qA [@poiDg8@o4֡a@mhr!@ix@g	k@glC@glC@f1.@de@be+@^@R䎊@K)^	@I@H˒:*@GzH@Em\@?[W>@8Q@3ߤ@12W@.H@+6z@(Xy=@%zxl"h@#S&@ -
@u@Q@@@Fs@n@$tT@
O;dZ@	7KƧ@+I@{J#9@n.@ hۋq@"@hr@GE85@t@O;@g	@`A7L@҈p;@ڹY@e+@ԕ*1@_o @@@
(@D@3@?|h@'0@?|h@ߤ@1@0
@$xG@/@%@u"@,<@*0@@ᰉ@sh@$/@$/@@)^@M:@'/@tj@4m9@hۋq@~($x@{J#9@yrGE8@xF]d@v+jg@r{m@nc	@iDg8~@e+a@b@4@^ ѷY@\>@Xy=c@R䎊@M@L_@LcA \@K:)z@I@DS@C,zxl@B&IR@@4m@>
(@<n.@9Y}@6C-@4m8@1-@.}Vl@.zG@-V@,zxl"@,1&y@*0
@)*0U2a@&L/{J@#n.3@!-w1@qu!@Ov_@o @҈@q@'/@	ԕ*@&I@M:@F]c@@:S@"@m]@l"h	@PH@C\@(@~"@%1@e+@W>6z@ٳ|@1'@>BZ@ٳ|@bM@m@;dZ@p:~@ǮzH@8YK@8YK@o i@7Kƨ@<64@}H@-V@>B[@I^@-@S&@R<6@ߤ@@@N;6@4J@bM@-
q@I^5?@ݗ+@o h@IQ@~"@}ڹZ@|#x@{m]@y	k~@sPH@r{m@ql@o@kC,z@h@e@b}Vm@`A7K@\]ce@["`B@Y+@V8YJ@Vt@TɅoi@Rm@Np:~@Dg8}@B&IR@<Z@:)_@9XbM@7KƧ@43@0'RT@,q@(\)@%zxl"h@$TɆ@#wk@ 	k@IQ@+j@Ov_@nO@!R<@q@	k~(@p:@eO@$/@nP@ ѷX@$tS@b}V@.H@E@~$@F]d@!.@䎊q@
=q@.2@8Y@P{@䎊qj@ߤ?@ ѷY@(\@+@8YJ@ӎMj@`A7@5Xy>@@@o i@[W>@S&@C-@sg@?|h@Xy=@|@Vϫ@y@/@.H@ěT@	@쿱[W@,=@ߤ@@u%F@tj@+J@n@@ԕ*@eO@ݗ+@@oiDg@{J#9@I^5@I^5@@IQ@~$t@}Vl!@|#x@{J#9@y	k~@w1@nO;@g8}H@ceO@`
qu@]/w@YJE@S&@P{@O;dZ@N_o @L@KƧ@JD@IoiD@F-@DS@D2W@Eo i@E84֡@A [7@9XbM@6z@3g	l@0'RT@/Vϫ@/O
M@.zG@+a@@+6z@)y@%1@ ěT@	@u"@tj~@
O;dZ@҈@C%@C%@
L/{@'/@'/@
ڹY@ ѷX@F]d@Fs@E@D@hr!@fB@Ov`@@Z@o@]ce@+@ӎMj@
M;@/{J#@@@s@
(@~($@}Vl@z@?@9XbN@a|Q@2X@jf@\)@,@S@n.3@ěT@!-w1@S@6C@@@@ᰉ@$/@sP@@@L_@q@xF]@ԕ*@+I@Q@@~$t@y	k~@ql@nO;@mC\@m\@l"h	ԕ@jJL@`d8@Z1'@Xe+@UϪ͞@T,<@R䎊@P|@O;dZ@N;5X@Ks@K)^	@Jn@J#9@Fs@C\N@ATɅo@@n@?@=p
=@:~@:)_@:)_@:S&@2-V@-U=@,q@*0
@($xG@',@&x@',@%1@$/@#
=p@ 'RT`@e+a@ᰉ@*0U2@:)y@hr @hr @4J@)^@Vu@&I@:S@b}V@Vl!@-
@Y|@!-w2@@MjO@GE85@@4֡a@@S@|Q@Gz@ᰉ'R@u!@W>6z@c	@>BZ@ק&@E@a@O@m@N;5@Ϫ͞@@@
L/@\N@Zc@@Z@5Xy@#w@|@ᰊ@{@U2a|@1@U=@<쿱@-@R<6@[6@!-w1@-V@ߤ@@=K^@@e+a@PH@R<6@*0@҉@nO@u@n@N;6@qi@=p
@#@@tj@:S@x73@p
=q@m8Y@k~($@eڹ@a|Q@_حV@_;dZ@\?@ZQ_@XU@WsPH@XD*@XU@Xe+@W@Vt@T*1@SZ@R<64@R䎊@P`A7@N;5X@L/{J#@IQ@GE84@Fs@F?@E8YK@E8YK@F
L/@E8YK@C\N@BZc@?[W>@=<64@9#w@5'0@2m\@0
(@+I^@(Xy=@&'@%zxl"h@!-w1@U=@쿱[W@U=@	@	@쿱[W@qu!@@@N@u@-
q@'/W@!R<@
@q@#@ݗ@nP@:S@      @lC@"`@kP@F]d@+@MjO@@.2@(@C]@Dg8~@唯O
@Ft@D*@l!-@т@*0U@ΤT@]cA@@˒:*@@@84֡@NU@)_@o@}Vl@>B[@0
@d7@d7@@/V@@zxl"h@TɆ@?@?@
=p@
=p@n.3@wkQ@3@.H@-V@IQ@1&@Q@S@$tS@-
q@I^5?@ԕ*@1&x@ݗ+@&I@S&@:S@}Vl!@y"`@wkP@u!.@uY|@tD@t#@t!-w2@tSMj@sE@sMjO@o@m\@hۋq
@g@f,<@f,<@f,<@f,<@f1.@de@c	@b}Vm@be+@be+@`d8@^ ѷY@S@P|@NT@M:@J#9@I@H@HK]c@F?@C,zxl@>6z@;dZ@:^5?|@9~($@73@333333@/Vϫ@,>B[@,1&y@+6z@($xG@$TɆ@#
=p@!o@ [6@u"@vȴ@+j@L_@bM@	 ѷ@Q@@$/@.H@~$@1@MjO@iB@oiDg8@@4֡a@O;@\@"h	ԕ@빌~($@~"@Dg8~@r Ĝ@lC@䎊qj@@N@;dZ@iB@ݗ+j@ce@>@>@$@Q_@bM@Ϫ͞@a@O@`A7@H@;5X@s@]cf@@&IR@@j~#@dZ@#w@Xe@Xy=@sg@'0@ߤ@O
M@y@zxl"h@?@S&@ae@U=@u@C,zx@vȴ@vȴ@_o@e+a@@+J@҉@o @~($x@ݗ+@@4n@IQ@hۋq@hۋq@     @b}V@}E@zG{@xF@v!.I@vFs@r ě@l[W?@ix@h	ԕ+@h	ԕ+@g8}H@f1.@ceO@a@N@^҈p;@]+j@Y>BZ@U=K@RT`d@O͞@M%@K]cA@J#9@GzH@D*0@A@>ߤ?@=<64@;A@:~@:S&@8)@6E@3g	l@0 ě@-w1@+6z@*d7@)@(Xy=@(Xy=@%zxl"h@#S&@!.H@!-w1@ [6@%@IQ@qu!@u%F@O;d@L_@҉@-
q@Mj@
O;dZ@@I^5?@xF]@C%@
L/{@	'RTa@	'RTa@	'RTa@u%F@&I@n/@ݗ@?@@o hی@ E@ ?@ m]@ xl"h
@ 73@ eں@ 1@ {m@ @ 4֡a@ t@ 8Y@ C@ ~"@ @ rGE@ @ @ Z@ e@ ᰉ'R@ Gz@ حV@ ҈p;@ iB@  ѷY@  ѷY@ ce@ JE@ ,<@ N;5@ +@ ;5X@ jOv@ 5Xy>@ 5Xy>@ jOv@ D@ ɅoiD@ ȴ9Xb@ @@ Ƨ-@ m\@ Zc@ [W>@ 
(@ v@ p
=@ <64@ Z@ 4֡b@ )@ Q@ -V@ 
qv@ 0
@ *0U2a@ 1@ TɆ@ ?@ xF@ n.3@ n.3@ 9@ wkQ@ R<6@ !-w1@ -V@ =K^@ tj@ O
M@ 4J@ -
q@ rGE9@ '/W@ M:@ ԕ*@ ԕ*@ @  ѷ@      @ }Vl!@ z>B@ z>B@ zxl"h
@ zC\@ y(@ wkP@ vFs@ t#@ qu!S@ nt@ lC@ iᰉ'@ h@ hr Ĝ@ h	ԕ+@ gfA@ fA@ e`A7L@ be+@ _o@ ^ ѷY@ ]ce@ ]ce@ \?@ \N;@ \]ce@ [q@ Y>BZ@ Vaf@ S@ R䎊@ Q_p@ P`A7@ P|@ PH@ O;dZ@ O;dZ@ OAs@ O
M;@ O
M;@ O
M;@ LcA \@ K]cA@ K)^	@ I@ F-@ E84֡@ C$@ A7Kƨ@ ?|hs@ =v@ =<64@ <Z@ ;/V@ 7KƧ@ 5?|h@ /Vϫ@ ,q@ +U=@ '-@ '&@ &'@ %S@ %F
L0@ %1@ &@ &'@ &IQ@ &IQ@ &L/{J@ &@ %1@ &x@ %S@ #wk@ !o@ 䎊r@ %@ IQ@ C,zx@ 6C@ @@ @ sP@ $tT@ '/W@ @ 
ڹY@ 	k~(@ S&@ u%F
?#x?䎊q?t??"`B?Ϫ͞?fA?,<?҈p:?As?)^	?@??Z?~($?sg?{?{?{? ě? ě?r?1?B?U=?,?,<?O
M?ᰉ?S&?o ?\(?qi?'RTa?oiDg?&I?+I???~"?z?z?xF?vȴ9X?rGE85?q?p:~ ?nO;?h	ԕ+?bM?[W>6z?U=K?PH?IQ?H?H˒:*?E?D*0?E84֡?D*0?9XbM?4m8?2W?1-?0U2a|?-w1?($xG?!R<6?,=?vȴ?6C?PH?PH?tj??+J?Ov_?u?
L/{?1&x?      ?lC?eں?Y|?E?s??c	?Q?Q?쿱[W??VϪ?fA?e?ᰉ'R?Gz?ߤ????E?p:~?͞%?5Xy>?cA \?cA \?cA \?s?cA \?˒:)z?)^	?@?ěS??74?C?TɅo?C?n?ߤ??rG?B?>B[?1&y?͞&?d7?͞&                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @@T>@@T>@@TE@@TE@@T>@@TE@@U:@@U:@@U:@@UK]@@UK]@@UV@@U*0@@U(@@U?|h@@UfA@@Usg@@UfA@@Uce@@U\@@U`A7L@@U\@@US&@@US&@@UVl!@@UY|@@U`A7L@@U`A7L@@Uce@@UfA@@Uce@@Uce@@U`A7L@@UVl!@@Uce@@Uce@@UfA@@UjOv@@UfA@@U`A7L@@U`A7L@@Uce@@Uce@@UfA@@UfA@@Um\@@Up
=@@Uw1@@Uzxl"h@@Wv@@XA7K@@XYJ@@XXy=@@X'RT`@@XbM@@X@@X'RT`@@XD*@@Y_p@@YXbM@@Y|Q@@Y|Q@@Yo hی@@Yx@@Y@@Y@@Y.H@@Zh	ԕ@@Z)_@@[u%@@[9@@[F]c@@[Mj@@[Q@@[A@@\,<@@\qj@@\q@@\g8}@@\N;@@\@@\Z@@]'0@@\JM@@\#x@@\7@@\>B[@@\u"@@\@@\*1@@\C@@\wkP@@\tSM@@\Z1@@\hr@@]+a@@](@@]Vl!@@]sg@@]ݗ@@^af@@_@@`)^@@an.@@aD@@b#9@@b͞&@@b@@c6z@@bd7@@a'RTa@@aR@@c33333@@d?@@f.2@@f+@@g>6z@@g4m@@i-w1@@kdZ@@m[@@nvȴ9X@@p}H@@qQ@@r&IR@@s%2@@sA [@@ufA@@v&I@@xl"h	@@{@N@@}(@@+I@@,=@@!.@@*1@@xl"h
@@N;@@O;dZ@@fffff@@U=@@YJ@@a|Q@@fA@@֡a@@v@@@@(@@g8}@@Xy=@@:@@3@@&@@Q@@sg@@z@@As@@o @@|@@TɅo@@	 @@C\@@u%@@ݗ+k@@Ԙ_@@b@@E84@@ؓtj@@Q@@6C@@ڏ\(@@G{@@҉@@ے:)z@@]ce@@ܬ1&@@D@@[@@*0@@%F
L@@S&@@ݔO
@@ݼn/@@E@@ڹ@@($x@@ޞ@@+@@\(@@߻/V@@@@@@@@@Vϫ@@     @@1&x@@bM@@ࠐ-
@@@@$tT@@+@@&x@@x@@ᙙ@@|@@D@@^5?}@@Ov`@@Ov`@@#9@@)y@@:)y@@JL@@d7@@xl"h
@@L_@@ⅇݘ@@W@@c	@@u%@@F]c@@MjO@@]cA@@]cA@@tj~@@U=@@C]@@xF@@2W@@PH@@SMj@@䛥S@@j~@@j~@@?@@:@@e@@'0@@p
=@@n/@@b@@ᰉ@@ڹ@@;5X@@}Vl@@qi@@af@@t@@+@@As@@eں@@@@@>BZc@@譫U@@p:@@e+@@@@@@:S@@^@@7Kƨ@@齥@@n@@6C@@꩓@@m@@I^@@S&@@s@@,zxl@@P{@@~$@@*0U2@@!-w2@@?@@?@@5Xy>@@(@@2a|@@!R@@($x@@T@@A@@1@@"@@)^@@eں@@[W>@@+j@@+j@@rGE9@@TɅ@@@N@@:S@@7Kƨ@@(@@~($@@|Q@@oiD@@o@@^5?}@@:)y@@`A@@c	@@m@@@@tj@@*0U2@@]cA@@~$@@ߤ@@@>B[@@E@@IQ@@M:@@!.@@\N<@@%@@&I@@E84@@eں@@zH@@-@@ ě@@'RT`@@73@@l"h	@@p:@@	k@@@@XbM@@u@@Ov`@@JL@@qiC@@W@@C,@@,zxl@@@@Mj@@Q@@@@~$@@g	l@@~$@@Q@@ݗ+k@@lC@@tj@@@@u@@L_@@m\@@ڹZ@@@@=K@@=K@@%@@Xy=@@
L/@@Ov_خ@@&I@@E84@@o@@O;d@@lC@@v_ح@@&@A 73@A hۋq@A u!@A ҈p@A {@A	k~@A@A=b@ATɅo@A:S@Ae+a@A@A'RTa@Aԕ*@A@A:)y@AnO@A<64@Au%@A'/@A҉@AnP@A,zxl@A]cA@A~$@Aq@A:)z@AU=@AZ@Aݗ+k@A҈@A1&y@A,<@Aj~#@A_@Aj~@Au"@AD@AV@A84֡@Am\@A+j@AXy=@A-V@An/@A8Y@A@A ѷY@A$/@A;5X@AL/{J@A\N<@Al!-@A+J@A@Am\@Aȴ9X@At@AFs@Aeں@A@A@AD*@Ahۋq@A|@A)^@A	$/@A	rGE@A	#w@A	-w1@A	0
)@A	4J@A	4J@A	=b@A	Q@A	ae@A	x@A	oiD@A	~($@A	u@A	ᰉ'@A
1'@A
3@A
W'@A
u%F
@A
{m@A
p:@A
\(@A
p:@A
p:@A
p:@A
S&@A
n@A
~@AS&@APH@A9@AZ@Aqu!@Atj~@A{J#9@A@AƧ@A%2@A$@A/{J#@AwkP@A3@A@Ahr@A>@A
o i@A
fA@A
%@A
@A
@AOv_@AYJ@Ac	@As@Aaf@AQ@A҈p;@A
=p@A$tS@A;dZ@AiDg8@A-V@Ao @AحV@A@AA7K@Au!@Atj@Atj@Atj@A@AѷX@A#w@ArGE8@Ab}@A~($@AR<6@An.@AI^5@AkP|@AqiC@Axl"h
@Ap:@A͞&@A'/@A"`B@A,zxl@A9@A6z@A/V@AP{@Aq@AU=@A*0U2@AE@A@A2W@A`d@A?@A?@AZ@AZ@A>@A%F
L@AVl!@Aݗ@Ahr!@AO
@A+j@AU=@AH˒@An/@A?@A_o @AOv_@A5?|@A?@A?@AYJ@A}Vl@A%@AT@Am\@A hۋ@A
M;@A@Av@A!-w1@A1@AE84@AO
M@ART`e@AXe,@AU=@Ao@AiDg8@AiDg8@AO;d@A3@A&@A͞@Ar@AVϫ@AbM@A'RT`@A4m9@AA7K@ANU@AXy=@A[6@A[6@AU2a|@A_F@AbM@AoiDg8@A|@AѷX@AD@A{@A_p@A#w@A*0U2a@A0
)@A=b@A[W>6@Aae@Ao hی@AR<6@AX@AR@AOv`@A#9@A)y@A3@A:)y@A:)y@A6C@A:)y@A=p
@A@4n@AC\@Aa|Q@AY@A,<@A ѷ@Ac	@Ac	@A74@Am\@A~@Am\@A74@A'/@A6z@AJ#9@AJ#9@AZ@An.3@Aqu!@A{J#9@AMj@A*0U2@A|@A@A\N@An.@A@A64@AZ1@A#@AN;@A1&@A7@A֡a@AD@AV@AQ@A/w@A<64@AL_@AS&@AS&@AS&@Ace@Am\@AڹZ@A%@Ash@A(@A
L/@A!R<@AE@AL/{J@AR<6@A\N<@A_ح@Ap:~@A,<@Aߤ?@Aߤ?@A"@A hۋ@AXe@A'/W@A+I@A.H@AAs@AO;d@AzH@A[W>@A˒:)@AVϫ@A      @A 'RT`@A 1&x@A 4m9@A >BZc@A A7K@A NU@A NU@A l"h	@A u!@A @A 
=q@A U@A 9Xb@A )@A ҈p@A PH@A!rGE@A!rGE@A!@N@A!_p@A! [7@A!#w@A!0
)@A!4J@A!:S@A!Dg8~@A!ae@A!o@A!@A!@A!iB@A!ԕ*@A!_o@A!R@A"I^5@A"#9@A"C\@A"nO@A"ᰊ@A"}Vm@A"sP@A"74@A#PH@A#)^	@A#/V@A#Z@A#qu!@A#@A#:)z@A#*0U2@A#a@O@A#ݗ+k@A#@A#@A#\N@A$1&y@A$xF@A$1&y@A$Q@A$,<@A$64@A$9XbN@A$?@A$PH@A$g8}@A$zG@A$#@A$쿱[@A$쿱[@A$@A$hr@A$>@A$>@A$>@A%:@A%u@A%5Xy>@A%84֡@A%?|h@A%IQ@A%p
=@A%}H@A%$/@A%zxl"h@A%}H@A%!R@A%=K@A%v@A%n/@A%\(@A%@A%@A%
qv@A%(@A%E@A%!.@A&zG@A&8YJ@A&Ov_خ@A&Vu@A&\N<@A&_ح@A&l!-@A&+J@A&,<@A&2X@A&m\@A&1@A&Fs@A&"@A&"@A&"@A'
=p@A')^@A'Xe@A'!-w1@A'$tS@A'4֡a@A';dZ@A'E84@A'E84@A'KƧ@A'o@A'kP@A'?@A'zH@A'vȴ9@A'@A'Vϫ@A'#@A(@A('RT`@A(-
q@A(73@A(K]c@A(U2a|@A(_F@A(u!@A('RT@A(@A(IQ@A(4m@A(
(@A(TɅ@A(ѷX@A(@A({@A({@A) ѷ@A)+@A) [7@A):S@A)JE@A)TɅo@A)k~(@A)o hی@A)u!S@A)|Q@A)@A)(@A)D@A)@A)s@A*s@A*Ov`@A*3@A*=p
@A*C\@A*M@A*Zc@A*^5?|@A*u%F
@A*~"@A*ݘ@A*L_@A*S&@A* ě@A*Y@A*@A* ѷ@A*~@A*74@A*~@A+u%@A+C,z@A+C,z@A+	@A+	@A+=K^@A+J#9@A+P{@A+q@A+Mj@A+wk@A+*0U2@A+Ƨ@A+@A+@A+҈@A+C]@A+\N@A,ߤ@@A,tj@A,?@A,M:@A,PH@A,PH@A,SMj@A,M:@A,]ce@A,g8}@A,j~#@A,j~#@A,q@A,wkP@A,o h@A,C@A,[W?@A,*0@A,Z@A,/@A,>B[@A,@A,e@A-'0@A-qu"@A-%F
L@A-+a@A-84֡@A-F
L0@A-O;dZ@A-\@A-ce@A-p
=@A-sg@A-$/@A-ڹZ@A-!R@A-O
@A-v@A--V@A-@A-@A-cA @A-8YK@A-b@A-,=@A.
L/@A.
L/@A.
(@A.Ov_@A..2@A.L/{J@A.Ov_خ@A.R<6@A.iB@A.%@A.@A.af@A.@A.&I@A.ȴ9X@A.҈p;@A.+@A.Ϫ͟@A.ߤ?@A.쿱[W@A.Fs@A/ hۋ@A/
=p@A/$tS@A/'/W@A/.H@A/;dZ@A/>6z@A/As@A/E84@A/E84@A/KƧ@A/O
M@A/U=@A/b}V@A/lC@A/{J#:@A/	@A/&@A/ݗ+@A/	k@A/͞@A/[W>@A/r@A/@A/@A/;dZ@A/@A/Vϫ@A0     @A/rGE9@A0
qu@A0'RT`@A073@A0:~ @A0>BZc@A0H@A0Q@A0[6@A0bM@A0bM@A0hۋq@A0r Ĝ@A0y=c@A0y=c@A0n@A0-
@A0IQ@A0U@A0U@A0{@A0{@A04m@A04m@A0)@A0TɅ@A0p:@A0D@A0C@A1 ѷ@A1+@A1 [7@A1#w@A1&x@A1*0U2a@A1-w1@A17KƧ@A1:S@A1Dg8~@A1Gz@A1N;5@A1[W>6@A1ae@A1|Q@A1~($@A1o@A1@A1l@A1l@A1_o@A1N;6@A1N;6@A1N;6@A1ԕ*@A1iB@A1s@A1s@A1@A2Ov`@A2Ov`@A2Ov`@A2e+@A2&IR@A2:)y@A2JL@A2d7@A2u%F
@A2nO@A2xl"h
@A2L_@A2ᰊ@A2>B@A2@A2W@A2W@A2͞&@A2`A@A2䎊q@A2D@A274@A3u%@A3҉@A3nP@A3s@A3nP@A3"`B@A39@A39@A3=K^@A3J#9@A3W>6z@A3a@N@A3g	l@A3qu!@A3@A3eO@A3q@A3:)z@A3U=@A3ߤ@A3wk@A3*0U2@A3~($@A3ݗ+k@A3%2@A3\N@A3\N@A4n.@A4xF@A4@A4"h	ԕ@A42W@A4?@A4M:@A4M:@A4M:@A4Z1@A4j~#@A4o h@A4o h@A4*1@A4S@A43@A4O
M@A41&@A4@A4#x@A4?@A4@A4Z@A4Z@A4Z@A4>B[@A4u"@A4hr@A4!-w@A4E@A5K]@A5V@A5V@A5qu"@A584֡@A5IQ@A5IQ@A5L_@A5\@A5fA@A5jOv@A5sg@A5M:@A5%@A5v@A5@A5@A5cA @A5Ϫ͞@A5@A58YK@A5S@A5oiDg@A6_o @A6zG@A6@A6@A6!R<@A6$/@A6($x@A65?|@A6?@A6E@A6L/{J@A6Vu@A6c	@A6vȴ9X@A6p:~@A6s@A6}Vl@A6}Vl@A6qi@A6@A6@A6Fs@A6Fs@A6,<@A6@A6@A6T@A62X@A6Q@A6ߤ?@A6Fs@A6!.I@A7@A7
M;@A7,@A71@A7;dZ@A7>6z@A7H˒:@A7KƧ@A7O
M@A7O
M@A7RT`e@A7_o@A7_o@A7eں@A7eں@A7iDg8@A7{J#:@A7kP@A7-V@A7͞@A7[W>@A7[W>@A7zH@A7[W>@A7/V@A7@A7˒:)@A7حV@A7Vϫ@A7䎊r@A7#@A8 ě@A81&x@A81&x@A84m9@A8*0@A8-
q@A81&x@A81&x@A84m9@A8bM@A8u!@A8y=c@A8'RT@A8tj@A8
=q@A8
=q@A8@A89Xb@A8TɅ@A8)^@A8ۋq
@A8ۋq
@A84֡b@A9 ѷ@A9@A9@A9 [7@A9*0U2a@A9JE@A9TɅo@A9TɅo@A9XbM@A9[W>6@A9^@A9e+a@A9rGE8@A9@A97Kƨ@A9o@A9@A9'RTa@A9B@A9'R@A9D@A9D@A92W@A9y@A9o@A9_o@A9ԕ*@A9"`@A9>BZ@A9s@A9@A9Y}@A:u%F@A:n@A:@A:䎊@A:&IR@A:C\@A:T`d@A:Zc@A:T`d@A:d7@A:a|Q@A:nO@A:S&@A:@A:>B@A:g	@A:}Vm@A:n@A:)_@A:@A:W@A:`A@A:͞&@A:͞&@A:,<@A:fB@A:c	@A:~@A:~@A;I^@A;u%@A;'/@A;҉@A;'/@A;nP@A;9@A;=K^@A;@N@A;F]c@A;P{@A;P{@A;P{@A;P{@A;W>6z@A;]cA@A;]cA@A;tj~@A;eO@A;Mj@A;A@A;ߤ@A;A@A;A@A;ߤ@A;U=@A;@A;@A;
=p@A;ݗ+k@A;%2@A;@A;\N@A<n.@A<n.@A<J@A<xF@A<ߤ@@A<Q@A</{J#@A<?@A<Fs@A<C,zx@A<C,zx@A<I^5?@A<Z1@A<Z1@A<]ce@A<g8}@A<tSM@A<wkP@A<wkP@A<o h@A<#@A<N;@A<3@A<1&@A<O
M@A<?@A<#x@A<j~@A<#x@A<*0@A<Z@A<Z@A<hr@A<D@A<e@A<>@A=:@A=[@A=!.H@A=(@A=(@A=+a@A=5Xy>@A=2a|@A=<64@A=?|h@A=F
L0@A=O;dZ@A=O;dZ@A=O;dZ@A=L_@A=S&@A=S&@A=Vl!@A=p
=@A=w1@A=$/@A=$/@A=!R@A=+j@A=@A=8Y@A=Ϫ͞@A=@A=ᰉ@A=!.@A=C\@A=C\@A>t@A>
(@A>4K@A>@A>zG@A>4K@A>4K@A>@A>!R<@A>$/@A>+jg@A>($x@A>+jg@A>5?|@A>;5X@A>H@A>L/{J@A>Vu@A>R<6@A>R<6@A>R<6@A>Vu@A>Vu@A>Vu@A>_ح@A>iB@A>s@A>z@A>qi@A>@A>,<@A>-@A>ߤ?@A>&I@A>&I@A>m\@A>҈p;@A>]cf@A>ߤ?@A>]cf@A>]cf@A>C-@A>1@A>!.I@A?
=p@A?
M;@A?v@A?,@A?Xe@A?v@A?!-w1@A?+I@A?;dZ@A?E84@A?KƧ@A?RT`e@A?RT`e@A?_o@A?eں@A?o@A?lC@A?o@A?4m@A?ݗ+@A?ݗ+@A?$tS@A?kP@A??@A?r@A?@A?@@A?rG@A?#@A?rGE9@A@     @A@	ԕ+@A@@A@@A@
qu@A@}H@A@-
q@A@D*@A@Xy=@A@_F@A@bM@A@l"h	@A@eO@A@hۋq@A@oiDg8@A@r Ĝ@A@r Ĝ@A@r Ĝ@A@|@A@˒:*@A@n@A@YJ@A@@A@tj@A@u%F@A@tj@A@@A@@A@d8@A@9Xb@A@9Xb@A@)@A@@@A@`A7@A@`A7@A@4֡b@A@{@A@{@A@\)@A@	k@AA	k~@AA_p@AA#w@AA*0U2a@AA0
)@AA0
)@AA4J@AA0
)@AA7KƧ@AA7KƧ@AA7KƧ@AA:S@AADg8~@AAN;5@AAXbM@AA^@AA^@AAae@AAe+a@AAe+a@AAhr @AAo hی@AAo hی@AAo hی@AAo hی@AAo hی@AArGE8@AA@AAu@AAu@AA@AA(@AA|@AA@AAy@AA_o@AAiB@AA>BZ@AAlD@AB	 @AB	 @ABn@AB	 @ABs@ABOv`@AB#9@AB&IR@AB0U2a|@AB=p
@AB@4n@ABC\@ABM@ABQ_@ABW'@ABZc@ABd7@ABnO@ABݘ@AB\(@ABwkQ@ABwkQ@ABS&@AB@ABY@AB@AB`A@AB ѷ@ABڹY@AB ѷ@AB ѷ@AB ѷ@ABG{@AB䎊q@ABG{@ABc	@ABm@AB~@AB~@ACu%@ACs@ACnP@ACs@ACPH@ACC,z@AC"`B@AC	@AC"`B@AC/V@AC33333@AC=K^@AC@N@ACJ#9@ACJ#9@ACS@ACZ@ACn.3@ACn.3@ACqu!@AC@ACeO@ACq@ACߤ@ACU=@ACwk@ACU=@ACS@ACwk@ACE@AC@AC
=p@AC
=p@ACݗ+k@AClC@ACg@ACC]@ACs@AC@AC@AC\N@AC\N@ADJ@ADxF@ADtj@ADQ@AD(\@AD9XbN@ADI^5?@ADSMj@ADSMj@ADSMj@ADSMj@ADZ1@AD`d@ADj~#@ADm8@ADq@ADj~#@ADzG@ADqj@AD쿱[@ADzxl"@AD3@ADTɆ@AD@AD#x@AD7@AD?@AD*0@AD>B[@ADu"@ADZ@AD@ADhr@ADe@ADE@AE'0@AE*0@AEqu"@AE(@AE+a@AE+a@AE+a@AE5Xy>@AE84֡@AE?|h@AEO;dZ@AEY|@AEce@AEce@AEjOv@AEm\@AEp
=@AEsg@AE}H@AEM:@AEݗ@AEݗ@AEڹZ@AE!R@AE!R@AE+j@AEv@AEU=@AEsh@AEn/@AE\(@AE8Y@AEϪ͞@AEϪ͞@AEϪ͞@AE@AE@AE8YK@AE?@AE?@AEb@AE?@AES@AE,=@AEᰉ@AE(@AEoiDg@AEC\@AFt@AF_o @AF
(@AF4K@AF@AF@AFOv_@AF1.@AF1.@AF5?|@AF5?|@AF8YJ@AF?@AF?@AFE@AFH@AFOv_خ@AFR<6@AFc	@AFfffff@AFc	@AFc	@AFp:~@AFl!-@AFp:~@AFp:~@AFp:~@AFp:~@AF}Vl@AF@AF,<@AF@AFaf@AFT@AFaf@AFT@AF6z@AF2X@AF'@AFߤ?@AF@AFm\@AFȴ9X@AFȴ9X@AFA@AF҈p;@AF+@AFϪ͟@AF+@AFߤ?@AFx@AF@AFFs@AG
=p@AGXe@AGv@AG$tS@AG.H@AG.H@AG.H@AG.H@AG.H@AG.H@AG.H@AG4֡a@AG8}H@AGAs@AGH˒:@AGU=@AG\(@AGeں@AGo@AGsPH@AGv_ح@AGv_ح@AG4m@AGO;d@AG&@AG$tS@AG	k@AG	k@AG&@AG[W>@AG3@AGr@AGvȴ9@AG@AGo @AG+@AG@AG@AG;dZ@AG@AG䎊r@AGrGE9@AG+j@AG+j@AG䎊r@AG+j@AH     @AHbM@AH*0U@AH@AH6@AH6@AH}H@AH}H@AH ě@AH ě@AH$xG@AH-
q@AH1&x@AH>BZc@AH>BZc@AHH@AHD*@AHH@AHH@AHD*@AHK]c@AHK]c@AHK]c@AHNU@AHU2a|@AHXy=@AH[6@AHbM@AHl"h	@AHl"h	@AHu!@AHu!@AHu!@AH˒:*@AHYJ@AH'RT@AHu%F@AHIQ@AHd8@AH4m@AH4m@AH4m@AHTɅ@AH@@AHѷX@AH@@AHp:@AH)^@AHp:@AHp:@AHp:@AHѷX@AHF@AHF@AHp:@AHp:@AHۋq
@AH҈p@AHC@AH@AH4֡b@AH	k@AH\)@AHPH@AHPH@AI ѷ@AI@AIrGE@AI+@AI [7@AI*0U2a@AI0
)@AIDg8~@AIGz@AI[W>6@AIae@AIae@AIk~(@AIb}@AIoiD@AI~($@AIo@AIo@AI@AI@AI'RTa@AIl@AI|@AI^5?}@AI2W@AI2W@AI2W@AID@AI2W@AI2W@AIy@AIy@AIo@AIo@AIԕ*@AIR@AIs@AI@AIlD@AIlD@AIlD@AI-@AJn@AJn@AJI^5@AJ	 @AJI^5@AJs@AJ䎊@AJ1'@AJ#9@AJ#9@AJ-V@AJ0U2a|@AJ-V@AJ3@AJ@4n@AJJL@AJT`d@AJZc@AJa|Q@AJkP|@AJh	ԕ@AJkP|@AJnO@AJqiC@AJu%F
@AJqiC@AJL_@AJ\(@AJ\(@AJ\(@AJ0
@AJwkQ@AJS&@AJ>B@AJ}Vm@AJ<64@AJY@AJY@AJ<64@AJ<64@AJY@AJ<64@AJn@AJ͞&@AJsP@AJڹY@AJfB@AJc	@AJm@AJD@AJm@AJ~@AJ~@AJ74@AJ~@AKS&@AJm\@AK'/@AK҉@AKs@AKs@AKPH@AKPH@AKC,z@AK"`B@AK/V@AK33333@AK33333@AK33333@AK6z@AK33333@AK6z@AK6z@AK@N@AK=K^@AK@N@AKF]c@AKC%@AKF]c@AKJ#9@AKJ#9@AKMjO@AKMjO@AKS@AKa@N@AKjf@AKdZ@AKg	l@AKdZ@AKg	l@AKg	l                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @s<@s@     @s@     @s<@s;33333@s9@s9@s;33333@s4@s8     @s4@s1@s333333@s333333@s8     @s<@s>fffff@sD@sI@sK33333@sK33333@sFfffff@s@     @s;33333@s<@s@     @sC33333@sD@sFfffff@sFfffff@sFfffff@sD@sC33333@sD@sD@sA@s@     @sD@sI@sFfffff@sC33333@sC33333@s@     @s>fffff@s1@r@r@r33333@s33333@sL@sfffff@s33333@s33333@s33333@s@s@s     @sfffff@sfffff@s@s@s33333@s@s     @sh     @sVfffff@sA@s.fffff@s      @sfffff@s@s@s@sfffff@s     @s@sfffff@s@s33333@s@s@s     @s@sfffff@s33333@s@s@s@sfffff@s@s     @s33333@s@s33333@s@s@s33333@s33333@s33333@rfffff@r33333@r     @r33333@rfffff@rfffff@rٙ@r33333@r@r     @s&fffff@sfffff@r@r陙@r     @rٙ@r     @r     @rp     @r!@q33333@q@q33333@q     @qfffff@q33333@q     @q@q@q(     @ps33333@offfff@offfff@n33333@mfffff@mY@l     @l|@lL@l)@k@kfffff@jfffff@jfffff@i@i@iffffff@i33333@hfffff@g@g6fffff@f     @ffffff@f33333@fc33333@fI@f0     @f33333@e@e     @efffff@eS33333@e#33333@d@dٙ@d@d@dc33333@d33333@c@c     @cp     @cS33333@cC33333@c6fffff@c&fffff@c@cfffff@b陙@b@bfffff@b     @b@bvfffff@bY@b9@b@a     @a33333@a@a33333@afffff@afffff@ay@a@     @afffff@`33333@`     @`ə@`33333@`ٙ@`fffff@`@`9@`#33333@`@`fffff@`      @`&fffff@`0     @`,@`33333@_L@_9@_&fffff@_@^ٙ@^@^333333@]@]ٙ@]fffff@]@]@]33333@]@]9@\@\fffff@\ffffff@\L@\@     @\,@[@[33333@[&fffff@Zٙ@Z33333@Z33333@Z     @Z`     @Z&fffff@Y33333@Y33333@Y@Y33333@Y     @Y     @Y@Y33333@X     @X@XY@XL@X333333@X&fffff@X@X      @W     @W     @W@Wl@W9@W@W@V@Vfffff@V33333@V     @VS33333@V@     @V9@V9@V9@V,@V@U33333@U33333@Ufffff@Uٙ@U33333@Uٙ@U33333@U     @U@T@Tfffff@Tٙ@Tٙ@Tٙ@T@T@T@Ty@TFfffff@T333333@T33333@S33333@S     @Sfffff@S@Sfffff@S     @S33333@S33333@S@Sffffff@S333333@S@R33333@R33333@R@Rfffff@Rfffff@R33333@R     @Rffffff@RFfffff@R,@R@Q@Q33333@Qfffff@Qfffff@Q33333@Q@Q33333@Q     @Q`     @QL@QL@QS33333@QL@Q@     @Qfffff@P@Pٙ@P33333@Pfffff@P     @P@P33333@P@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pffffff@P333333@P      @P@P33333@P@P@P33333@P@O33333@O@O33333@O     @Os33333@O333333@N33333@Nfffff@Ns33333@N@     @N@M33333@Mfffff@M33333@Mٙ@M@M@MY@M&fffff@M@M      @M      @M      @Lٙ@L     @Ls33333@L      @K@K33333@K@Kfffff@Kfffff@K@Ks33333@KL@K&fffff@K@K@K@K      @J33333@Jٙ@J@Jfffff@J@J@Js33333@JL@J&fffff@J      @Ifffff@I33333@I33333@Ifffff@Ifffff@Ifffff@I@I     @I@I@I@Iffffff@IY@IL@IL@I333333@I&fffff@I@I@Hs33333@G     @G@G@G     @Gffffff@G&fffff@F33333@Ffffff@F33333@Fٙ@Fٙ@Fٙ@Fٙ@F     @F33333@F@F@F     @F     @FY@F333333@F@F@Eٙ@Efffff@E@E@E@E     @E     @E     @Es33333@EL@E@D33333@Dٙ@D33333@Dfffff@D@D@D@Dfffff@D@D@D     @Ds33333@DL@DY@D@     @D333333@D333333@D&fffff@C33333@Cٙ@C@C@C@C@C@C@Cfffff@CL@CL@C&fffff@C&fffff@C@B33333@B@B@B@B@Bs33333@Bffffff@B&fffff@B@B@B&fffff@B&fffff@B&fffff@B&fffff@B@B@B@B@A33333@Aٙ@A@A33333@A@A@A     @A     @As33333@A@A@A@A@A@A333333@A333333@A&fffff@A@A@@fffff@@@@     @@     @@     @@fffff@@@@L@@333333@@@@@@@@@@      @@      @?fffff@?@?33333@?L@?L@?333333@?@>fffff@>fffff@>33333@>@>@>@>@>     @>@>     @>     @>ffffff@>333333@>333333@>L@>L@>L@>L@>L@>333333@=fffff@>@>      @>@>333333@>      @=fffff@=33333@=33333@=33333@=33333@=@=@=     @=L@=ffffff@=333333@=      @<fffff@<33333@<     @<L@<333333@<333333@<@<333333@<      @<      @;fffff@<      @;fffff@;33333@;@;@;@;33333@;     @;@;@;     @;@;@;33333@;@;@;@;@;@;33333@;33333@;33333@;     @;L@;@;      @:fffff@:fffff@;      @:fffff@:@:fffff@:fffff@:fffff@;@;333333@;333333@;L@;ffffff@;     @;     @;ffffff@;ffffff@;L@;333333@:fffff@;      @;      @:fffff@;      @:fffff@:@:@:33333@:33333@:33333@:@:fffff@:33333@:33333@:33333@:@:33333@:@:@:@:@:@:     @:ffffff@:L@:L@:333333@:333333@:@:@:333333@:333333@:@:333333@:      @:      @9fffff@9fffff@9fffff@933333@933333@9fffff@9@9@9@933333@933333@933333@9@9@933333@9@9@9     @9     @9     @9     @9ffffff@9ffffff@9     @9ffffff@9L@9ffffff@9ffffff@9333333@9333333@9      @9333333@9      @9333333@9333333@9333333@9@9@8fffff@8fffff@833333@8@8@8fffff@8@8@833333@833333@833333@833333@8     @8     @8L@8333333@8333333@8L@8L@8333333@8333333@8333333@8333333@8333333@8333333@8@8333333@8@7fffff@7fffff@7fffff@7fffff@7fffff@7fffff@8      @7fffff@733333@7@7@7@7@7@7@7@7@7     @7ffffff@7     @7     @7     @7@7ffffff@7L@7L@7333333@7ffffff@7ffffff@7L@7333333@7333333@7@7@7@7      @7@7@6fffff@7      @7      @7      @6fffff@6fffff@6fffff@7      @6@633333@6fffff@6fffff@6fffff@6fffff@6@6@633333@633333@6@633333@633333@633333@633333@633333@633333@6@6@6ffffff@6     @6@6@6@6@6@6     @6L@6L@6333333@6      @6@6      @5fffff@5@5@5fffff@5@5@5@533333@5@5@5@5     @5@5@5@5ffffff@5     @5@5ffffff@5ffffff@5ffffff@5L@5ffffff@5@5333333@5@5@5333333@5@5      @5333333@5333333@5@5      @4fffff@4fffff@4fffff@5      @4fffff@433333@433333@4fffff@433333@4fffff@4fffff@433333@4@4@4@4@4@4     @4@433333@433333@4@4     @4     @4     @4L@4333333@4333333@4@4@4333333@4333333@4@4@4      @4@4@4@4@4@4@4      @4      @4@3fffff@3fffff@3fffff@3fffff@3fffff@3fffff@3fffff@3fffff@3fffff@3fffff@3fffff@3fffff@3fffff@3fffff@4      @3@3@4      @3@3@3@3fffff@333333@3@3@333333@3@333333@333333@3@333333@3@3@3@3@3@3     @3     @3@3L@3ffffff@3     @3     @3     @3     @3     @3     @3@3     @3     @3     @3     @3     @3     @3     @3ffffff@3ffffff@3     @3     @3ffffff@3ffffff@3     @3ffffff@3ffffff@3     @3L@3     @3ffffff@3ffffff@3@3@3@3@333333@333333@3@3fffff@3@3fffff@3@3@3     @3@3ffffff@3L@3      @3      @3@3      @3      @3333333@3      @2fffff@3      @2fffff@2fffff@3      @2fffff@2@2fffff@2fffff@2fffff@3      @2fffff@2fffff@2fffff@233333@233333@2@2@2@233333@233333@233333@2@2@2@2@233333@2@2@233333@2@233333@2     @2     @2@2@2@2@2ffffff@2@2@2@2     @2     @2     @2     @2ffffff@2333333@2L@2L@2L@2L@2333333@2@2      @2L@2@2333333@2333333@2333333@2@2@2333333@2333333@2@2@2333333@2@2333333@2@2@2333333@2333333@2333333@2333333@2@2L@2L@2333333@2L@2333333@2333333@2ffffff@2L@2L@2ffffff@2ffffff@2L@2L@2333333@2333333@2L@2333333@2L@2L@2L@2L@2L@2L@2333333@2333333@2333333@2333333@2333333@2333333@2     @2ffffff@2333333@2333333@2L@2@2@2333333@2333333@2333333@2333333@2333333@2333333@2333333@2333333@2333333@2333333@2333333@2333333@2333333@2333333@2@2@2333333@2@2@2333333@2L@2333333@2@2333333@2@2      @2333333@2L@2      @2@2@2333333@2333333@2333333@2L@2L@2333333@2L@2L@2L@2L@2333333@2L@2L@2ffffff@2333333@2@2333333@2ffffff@2333333@2333333@2333333@2333333@2@2333333@2333333@2333333@2333333@2L@2333333@2333333@2@2@2333333@2333333@2@2333333@2333333@2333333@2@2@2333333@2333333@2      @2@2@2@2L@2      @2333333@2333333@2      @2@2333333@2333333@2@1fffff@2@2333333@2@2@2      @2@2333333@2@1fffff@2      @2      @2333333@2@2@2@2333333@2@2      @2      @2@2      @2@2@1fffff@2      @2      @2@2333333@2333333@2333333@2      @2@2@2      @2333333@1fffff@2      @2333333@2@2333333@2333333@2      @1fffff@2333333@2333333@2@2      @2      @2333333@2@2@2@2333333@2333333@1fffff@2@2L@2333333@2@2      @2333333@2@2333333@2      @2      @2333333@2333333@2333333@2333333@2      @2L@2333333@2333333@2333333@2L@2333333@2333333@2333333@2333333@2333333@2333333@2333333@2L@2L@2L@2ffffff@2333333@2ffffff@2333333@2333333@2ffffff@2ffffff@2ffffff@2L@2L@2ffffff@2L@2L@2     @2     @2ffffff@2ffffff@2     @2     @2L@2     @2     @2     @2@2@2     @2@2@2@2@2@2@233333@233333@233333@233333@2@233333@233333@2fffff@2fffff@2@2@2@2@2fffff@233333@3@3      @3      @3      @3      @3@3@3      @3333333@3      @3      @3333333@3333333@3L@3333333@3333333@3333333@3333333@3333333@3L@3L@3L@3333333@3L@3ffffff@3L@3L@3@3     @3@3     @3     @3@333333@3@3@333333@3     @3@4      @3fffff@333333@3@333333@333333@333333@333333@4      @4@4      @4@4@4333333@4333333@4L@4L@4ffffff@4     @4     @4@433333@4@4@4@4@4@4@433333@433333@4@4fffff@4@433333@4@5@5      @5      @4fffff@5@5@5@5@5@5@5333333@5@5333333@5333333@5L@5L@5333333@5333333@5333333@5333333@5L@5ffffff@5@5@5ffffff@5@5     @5     @5     @5     @5@5fffff@533333@533333@533333@5@5@5@533333@533333@533333@5@5@5@533333@5@5@6      @6      @6      @6333333@6      @6      @6      @6@6@6      @6333333@6L@6     @6@6@6@633333@6@6@633333@7      @7L@7@733333@7@7fffff@7fffff@7fffff@7@8      @8      @733333@8      @8      @733333@733333@7ffffff@7     @7L@7     @7333333@7L@7333333@7333333@7ffffff@7ffffff@7     @7@733333@733333@7fffff@7fffff@7fffff@7fffff@7fffff@8      @8333333@8@8333333@8L@8ffffff@8ffffff@8L@8ffffff@8ffffff@8     @8     @8     @8@8fffff@8fffff@8@833333@8@8fffff@8fffff@9@9333333@9ffffff@9ffffff@9     @933333@9fffff@:@:333333@:333333@:      @:      @9fffff@9@9     @9L@9ffffff@9     @9     @9     @9@933333@9fffff@:      @:333333@:ffffff@:ffffff@:@:33333@:@:@;      @;      @;      @;L@;@;@<@<333333@<L@<     @<     @<@=      @=@=@=@=L@=ffffff@=L@=L@=L@=333333@=ffffff@=     @=ffffff@=ffffff@=     @=     @=@=@=@=     @=@=@=@=33333@=fffff@>@>333333@>@>333333@>ffffff@>ffffff@>     @>33333@>33333@>@?      @?      @?@?333333@?333333@?333333@?@?333333@?     @?33333@?     @?@?33333@@      @@@@      @?fffff@@@@@@@@&fffff@@&fffff@@&fffff@@@     @@ffffff@@ffffff@@ffffff@@     @@@@fffff@@33333@@@@@@@@@@33333@@     @@     @@33333@@@@ٙ@A@@33333@@fffff@@33333@A@A333333@A@     @A333333@A@     @AL@A     @A@Afffff@Afffff@Afffff@Afffff@A@Aٙ@Afffff@Afffff@Aٙ@Aٙ@B      @B@B@B&fffff@B@B333333@B@     @BL@BL@B@     @B333333@BY@Bffffff@B     @B     @Bffffff@Bffffff@B     @B@B@B@Bfffff@B33333@B     @B@Bfffff@Bٙ@B     @B@B@B@Bfffff@Bfffff@B33333@Bfffff@Bfffff@C      @C      @B33333@C@C@C@C&fffff@C@     @C333333@C@     @CL@Cffffff@Cffffff@Cffffff@Cffffff@Cffffff@C     @C     @Cs33333@C     @C@C@C@C@C33333@C33333@C@C     @C33333@C     @Cٙ@Cٙ@Cٙ@Cٙ@Cfffff@D      @D@D@D@D@D@D@D333333@D@     @DY@D333333@DL@DL@Dffffff@Dffffff@Ds33333@D     @Dffffff@D@D@D@Dfffff@Dfffff@D     @D33333@D     @D@Dfffff@D33333@D33333@D33333@E      @D33333@Dfffff@E      @E      @E@E&fffff@E@E@     @E@     @E@     @EL@EY@Effffff@E     @E     @E@E@E@Efffff@E     @E33333@E@E     @E     @Eٙ@F      @F      @E33333@E33333@F@F@F333333@F333333@F333333@F333333@F@     @F333333@F@     @FY@FY@F     @Fs33333@Fs33333@Fs33333@F     @Ffffff@F33333@Ffffff@F@F33333@F33333@F33333@F33333@F@Ffffff@Fٙ@Fٙ@Fٙ@Fٙ@Fٙ@Fٙ@Ffffff@Ffffff@G      @Ffffff@F33333@G&fffff@G@     @G333333@G@G&fffff@GL@GL@Gs33333@Gs33333@G     @G     @G@Gfffff@G@G@G     @G     @G     @G@G@G@Gٙ@Gٙ@Gٙ@Gٙ@Gٙ@G33333@G     @G33333@H      @G33333@H      @H      @H&fffff@H333333@H&fffff@H333333@H@     @H@     @HY@Hffffff@Hs33333@H     @H33333@H     @Hٙ@Hfffff@Hfffff@I      @I@I      @I@     @I333333@I&fffff@IY@IY@IL@IY@Is33333@I     @I     @I     @Ifffff@Ifffff@Ifffff@I@Ifffff@I     @I@I33333@I@Ifffff@J      @I33333@I33333@J      @J      @J      @J      @J333333@J@     @J&fffff@J&fffff@J333333@JL@JY@JY@JY@Jffffff@Js33333@J     @JY@J     @Jfffff@Jfffff@Jfffff@J     @J@Jٙ@Jfffff@Jٙ@Jfffff@K      @K      @J33333@K      @K@K      @K@K@K&fffff@K@     @KY@KL@KL@Kffffff@Ks33333@K     @KY@KY@K     @K     @K@Kfffff@K     @K     @K33333@Kٙ@Kٙ@K@L      @L@L      @K33333@K33333@K33333@L@L&fffff@L@L@L&fffff@LL@L@     @L@     @LL@Lffffff@Lffffff@LY@Lffffff@Lffffff@Ls33333@L     @LY@L     @L@L@Lffffff@L@L@L@L@Lfffff@L     @L     @Lfffff@Lٙ@Lٙ@L33333@Lfffff@Lfffff@Lfffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ?j~#?Z1'?      ?ěS?QR?蛥S?1&x?+I^?蛥S?Ƨ-?lC?bM?bM?j~"?(\)?畁$/?"`A?lD?"`?旍O;d?E?9XbM?E?畁$/?A7Kƨ? ěT?x?`A7?vȴ9X?l?;dZ?O;dZ?E?^5?|?QR?ěS??|hs?zG?^5?|?+?lC?S?I^5??"`?Q?ȴ9Xb?ꗍO;d?n?zG?E?Q?-?|hr?$/?1&?M?1&x?-V?^5?|?+I?=p
=?A7Kƨ?7KƧ?lC?~"?
=p?lC?bM?nO?E?Z1'?+I^?E?"`A?Vu?+J?`A7K?Ԭ1&y?Ԭ1&y?ҟvȴ9?"`B?щ7KƧ?ЃnP?-V?n?щ7KƧ?n?1&?ЃnP?7KƧ?E? ěT?ěS?      ?p
=q?vȴ?\(\?bM? ěT?ϝ-V?5?|h?~"?xF?E?r ě?\(?̬1&y?ʟvȴ9?ɺ^5?|?vȴ9X?;dZ?Ͳ-V?Ƨ-?ǍO;dZ?ȓtj~?1&x?^5?|?ɺ^5?|?`A7K?E?
=p?/w?Z1'?+?$/?ffffff?Ƨ-?9XbM?E?ļj~#?öE?-V?7KƧ?nO?nO;?
=p?Q?tj?/w?nO?&x?\(?
=p?tj~?`A7L?p
=q?nP?lD?vȴ9X?`A7L?5?|h?;dZ?nO;?;dZ?hr Ĝ?nP?vȴ9X?Q?5?|h?333333?;dZ?(\)?-V?l?vȴ9X?M?      ?-V?nP?7KƧ?`A7L?      ?vȴ9X?`A7?Q?$/?`A7L?&x?E?nP?
=p?p
=q?
=p?p
=q?`A7?ěS?hr!?      ?hr Ĝ?hr Ĝ?nP?|hr?S?7KƧ?E?Q?lD?`A7L?nP?`A7?nO?`A7?I^5??A7Kƨ?S?      ?`A7L?A7Kƨ?bM?bM?`A7L?+?hr Ĝ?A7Kƨ?-V?-V?
=p?
=p?$/?+?M?tj~?bM?7KƧ?I^5??bM?I^5??vȴ9X?Gz?7KƧ?-V?$/?`A7L?Q?;dZ?A7Kƨ?ěS?nP?
=p?Q?ěS?I^5??n?nO?lD?
=p?° ě?M?hr Ĝ?`A7?GzH?nO;?Q?GzH?I^5??n?Q?l?333333?\(?
=p?Z1'?S?hr Ĝ?ěS?I^5??nO;? ěT?öE?l?-V?nO?
=p?`A7?&x?&x?nO?ěS?hr Ĝ?M?$/?Q?/v?hr Ĝ?E? ěT?+?`A7?nO;?S?-V?n?hr Ĝ?GzH?      ?`A7?S?M?7KƧ?nO;?333333?Q?$/?\(?M?`A7?I^5??zG{?° ě?l?° ě?`A7?7KƧ?7KƧ?nO;?A7Kƨ?tj?l?nO?-V?&x?S?&x?ěS?l?-V?I^5??$/?j~"?
=p?&x?vȴ9X?&x?hr Ĝ?GzH?      ?ěS?n?E?-V?nO?1&?      ?\(?333333?&x?$/?hr Ĝ?M?`A7L?"`?vȴ9X?-V?
=p?
=p?
=p?Q?
=p?A7Kƨ?Z1'?;dZ?nO;? ěT?l?I^5??7KƧ?&x?n?GzH?-V?Õ$/?n?öE?`A7L?nP?`A7?;dZ?n?ȴ9Xb?
=p?tj~?nO;?A7Kƨ?j~"?M?tj~?&x?l?l?\(?&x?M?|hr?A7Kƨ?A7Kƨ?GzH?tj~?ļj~#?`A7?-V?A7Kƨ?\(?n?ļj~#?\(?Q?&x?tj~?M?lD?bM?ěS?l?&x?`A7L?`A7?n?`A7?`A7?\(?M?tj~?n?tj~?&x?333333?n?S?ěS?E?\(?nO;?7KƧ?S?+?nO;?Q?nO;?nO;?nO;?`A7?A7Kƨ?$/?hr Ĝ?zG{?Q?n?$/?333333?`A7?nO?7KƧ?nO;?GzH?lD?$/?nO?nO?I^5??GzH?
=p?ěS?I^5??M?n?I^5??-V?\(?333333?A7Kƨ?-V?-V?M?hr Ĝ?
=p?p
=q?nO?GzH?333333?-V?nO;?E?Q?n?Ł$/?Q?tj?l?I^5??l?GzH?nO;?S?      ?zG{?nO?
=p? ěT?\(?M?9XbM?I^5??Q?$/? ěT?Õ$/?-V?`A7?l?\(?nO?öE?`A7?E?&x?öE?lD?$/?-V?Õ$/?M?bM?hr Ĝ?A7Kƨ?bM?5?|h?;dZ?hr Ĝ?n?tj~?vȴ9X?|hr?7KƧ?&x?nO?`A7?ěS?7KƧ?öE?vȴ9X?\(?\(?lD?$/? ěT?7KƧ?-V?nO;?9XbM?Z1'?S?šo?° ě?nP?M?tj~?`A7?
=p?tj~?333333?`A7?M?`A7?tj~?n?° ě?S?nO;?`A7L?° ě?A7Kƨ?Q?`A7?tj~?-V?° ě?lD?/w?-V?333333?M?ěS?GzH?\(?GzH?hr Ĝ?+?$/?\(?nO;?Õ$/?I^5??-V?ěS?`A7?`A7K?/w?E?Õ$/?M?nO;?öE?l?nO;?7KƧ?\(?nO?öE?ļj~#?-V?\(?ěS?-V?\(?nP?9XbM?bM?A7Kƨ?\(?tj~?333333?-V?Q?Q?öE?hr Ĝ?7KƧ?öE?Z1'?tj?tj~?I^5??`A7?n?7KƧ?ěS?vȴ9X?Q?n?I^5??ļj~#?tj~?$/?I^5??\(?I^5??Q?
=p?M?zG{?tj~?A7Kƨ?Q?l?\(?\(?`A7?tj~?tj~?l?\(?9XbM?Õ$/?7KƧ?9XbM?ļj~#?lD?`A7?° ě?S?S?E?S?M?nO;?öE?ěS?ļj~#?333333?nO;?GzH?9XbM?ěS?+?öE?ěS?-V?öE?lD?
=p?tj~?Q?öE?nO;?tj~?öE?M?tj?+?öE?-V?I^5??° ě?Õ$/?Q?`A7L?tj~?hr Ĝ?n?&x?n?S?I^5??n?333333?lD?$/?lD?-V?-V?tj~?Õ$/?zG{?lD?nO?öE?Õ$/?ěS?nO?-V?nO?(\)?nP?vȴ9X?n?Z1'?S?öE?S?333333?öE?l?-V?`A7?Õ$/?Q?9XbM?
=p?tj~?`A7?l?\(?I^5??šo?° ě?-V?
=p?&x?333333?M?333333?n?&x?Õ$/?&x?l?+?Õ$/?9XbM?nO?\(?öE?S?Q?nP?-V?&x?l?\(?-V?nO?S?Q?I^5??l?333333?tj?n?l?7KƧ?öE?l?tj~?ļj~#?Õ$/?nO?S?n?° ě?
=p?nO;?      ?I^5??
=p?
=p?GzH?+??|hs?
=p?S?\(?\(?I^5??
=p?333333?I^5??Q?n?hr Ĝ?nO?
=p?
=p?GzH?S?7KƧ?I^5??lD?M?`A7L?l?öE?n?nO?tj~?`A7?7KƧ?öE?° ě?&x??|hs?`A7L?GzH?7KƧ?
=p?zG{?tj~?-V?Q?333333?I^5??\(?n?l?5?|h?l?nO?\(?Õ$/?hr Ĝ?M?Q?n?+?GzH?$/?hr Ĝ?`A7L?n?ļj~#?7KƧ?7KƧ?$/?nO?
=p?nO;?nO?nP?Q?nO;?Õ$/?-V?M?tj~?&x?Õ$/?-V?-V?333333?nO;?`A7?S?`A7?nO?nO;?tj~?9XbM?bM?öE?l?-V?öE?l?n?M?&x?`A7?nO;?Z1'?l?`A7?GzH?zG{?nO;?nO?GzH?`A7L?E??|hs?tj?bM?x?/w?vȴ9X?
=p?`A7?I^5??Õ$/?333333?nO?I^5??l?
=p?
=p?nO;?tj~?Q?&x?nO;?`A7?`A7?bM?l?7KƧ?333333?
=p?9XbM?S?zG{?hr Ĝ?° ě?&x?bM?Õ$/?
=p?&x?ěS?Õ$/?\(?`A7?
=p?ěS?l?n?nO;?GzH?333333?n?\(?$/?öE?nP?M?nO?&x? ěT?&x?tj?S?`A7K?zG{?\(?+?nO?`A7K?Õ$/?Õ$/?\(?I^5??Õ$/?n?
=p?° ě?333333?nO;?hr Ĝ?/w?° ě?7KƧ?GzH?nO?
=p?lD?Õ$/?9XbM?S?S?+?nO;?
=p?
=p?Õ$/?tj~?n?l?$/?zG{?/w?l?333333?öE?nO?Õ$/?`A7?&x?Ł$/?
=p?7KƧ?M?nO?l?l?M?tj~?M?E?lD?-V?-V?\(?zG{?7KƧ?-V?ěS?zG{?ffffff?ěS?\(?nO?nP?
=p?tj?7KƧ?° ě?\(?zG{?l?S?`A7L?lD?nO;?9XbM?tj~?nO?-V?n?+??|hs?tj?/w?tj~?Õ$/?öE?333333?šo?
=p?-V?zG{?`A7?I^5??
=p?tj~?      ?M?9XbM?+?333333?
=p?M?hr Ĝ?ěS?n?\(?M?lD??|hs?9XbM?E?M? ěT?Q?nO;?`A7K?nO?nP?`A7?Q?lD?333333?
=p?333333?&x?öE?nO;?Q?nO;?l?Õ$/?öE?hr Ĝ?+?S?/w?-V?I^5??\(?n??|hs?I^5??333333?nP?lD?I^5??GzH?\(?Õ$/?+?-V?\(?7KƧ?\(?tj?/w?9XbM?Z1'?9XbM?hr Ĝ?S?l?I^5??Q?nO;?tj?Z1'?tj?333333?° ě?I^5??
=p?S?nP?Õ$/?`A7?`A7?\(?\(?7KƧ?vȴ9X?tj~?\(?öE?öE?Q?Q?S?ļj~#?Q?l?Z1'?tj~?M?I^5??tj?nO;?nO?° ě?° ě?hr Ĝ?n?l?tj~?M?S?Õ$/?/v?9XbM?Q?M?Õ$/?/w?333333?lD?333333?
=p?E?333333?S?öE?+?-V?Õ$/?zG{?
=p?/w?tj?9XbM?nO?M?l?&x?+?S?ěS?n?nP?333333?`A7K?333333?° ě?nO;?nO;??|hs?l?Õ$/?lD?Z1'?nO?`A7?\(?Õ$/?
=p?nO;?Õ$/?
=p?ěS?7KƧ?7KƧ?`A7?lD?° ě?&x?
=p?Z1'?Q?tj~?+?hr Ĝ?&x?\(?ļj~#?n?
=p?nO?\(?-V?
=p?I^5??l?n?333333?S?nP?vȴ9X?`A7?&x?-V?lD?      ?öE?-V?Q?-V?tj~?
=p?° ě?° ě?Õ$/?Q?° ě?\(?Õ$/?A7Kƨ?E?E?Õ$/?ěS?nO?+?° ě?nP?
=p?`A7?° ě?hr Ĝ?° ě?nP?Q?-V?+?`A7?\(?M?333333?
=p?Q?nO;?M?zG{?+?nO;?nO;?Õ$/?
=p?nO;?`A7L?l?+?nO?+?
=p?\(?9XbM?E?Z1'?`A7L?öE?I^5??A7Kƨ?333333?nO;?M?-V?nO;?9XbM?9XbM?A7Kƨ?
=p?333333?lD?öE?lD?öE?S?l?Q?ěS?S?hr Ĝ?-V?$/?-V?&x?\(?Q?
=p?zG{?333333?\(?tj~?$/?-V?A7Kƨ?bM?A7Kƨ?`A7L?-V?hr Ĝ?M?-V?
=p?333333?Õ$/?° ě?+?-V?7KƧ?lD?tj?S?7KƧ?7KƧ?nO;?° ě?333333?nO;?&x?lD?nO;?-V?&x?l?n?A7Kƨ?\(?tj~?S?nO?l?S?nO;?
=p?ěS?ěS?öE?lD?
=p?° ě?/v?tj~?l?-V?`A7?E?I^5??E?;dZ?-V?tj~?\(?lD?° ě?S?/w?nO?nO?I^5??`A7K?9XbM?° ě?+?333333?`A7?n?9XbM?GzH?nO;?-V?I^5??S?+?l?l?S?Q?vȴ9X?tj?9XbM?GzH?I^5??bM?I^5??ěS?M?\(?S?n?A7Kƨ?nO?`A7? ěT?`A7?nO;?A7Kƨ?šo?l?bM?GzH?tj~?$/?ěS?Z1'?$/?ěS?A7Kƨ?n?7KƧ?Q?GzH?
=p?nO?&x?7KƧ?333333?\(?`A7?M?n?öE?-V?n?M?n?l?ļj~#?9XbM?I^5??hr Ĝ?hr Ĝ?-V?333333?-V?nO?S?nO?-V?+?lD?lD?Q?A7Kƨ?"`?5?|h?
=p?° ě?$/?5?|h?tj~?° ě?n?bM?$/?`A7?° ě?n?vȴ9X?M?M?I^5??-V?Õ$/?lD?7KƧ?Z1'?\(?A7Kƨ?
=p?9XbM?öE?GzH?tj~?
=p?`A7?lD?Q?
=p?-V?lD?I^5??-V?M?Õ$/?ěS?`A7K?-V?
=p?hr Ĝ?n?`A7?Q?GzH?M?nO?nO?tj~?&x?nO?\(?-V?lD?hr Ĝ?lD?GzH?lD?`A7L?lD?Z1'?333333?9XbM?GzH?hr Ĝ?S?S?333333?bM?nO;?-V?`A7?M?tj~?`A7?Q?`A7L?° ě?Õ$/?lD?7KƧ?nO;?vȴ9X?hr Ĝ?7KƧ?l?hr Ĝ?&x?hr Ĝ?GzH?ěS?9XbM?nO?A7Kƨ?öE?° ě?`A7?nO;?&x?nO;?7KƧ?nO;?
=p?|hr?Q?GzH?&x?nO;?l?I^5??-V?-V?öE?-V?vȴ9X?A7Kƨ?Õ$/?° ě?° ě?333333?S?Õ$/?M?I^5??° ě?tj~?
=p?Õ$/?A7Kƨ?A7Kƨ?I^5??tj?I^5??tj?n?nO?`A7L?Q?`A7?
=p?Q?nO;?&x?`A7L?l?tj~?E?I^5??bM?`A7L?vȴ9X?|hr?tj~?\(?;dZ?Q?bM?-V?-V?lD?\(?E?nP?hr Ĝ?tj?7KƧ?333333?A7Kƨ?Q?
=p?E?hr!?A7Kƨ?n?hr Ĝ?-V?5?|h?&x?7KƧ?hr Ĝ?GzH?hr Ĝ?I^5??-V?+?I^5??p
=q?;dZ?-V?`A7L?nO;?7KƧ?A7Kƨ?tj?GzH?333333?`A7?\(?l?I^5??A7Kƨ?`A7L?\(?-V?n?\(?&x?-V?n?bM?`A7L?Q?nO?° ě?\(?`A7?lD?S?-V?9XbM?n? ěT?E?ěS?
=p?Q?-V?S?° ě?M?hr Ĝ?$/?nP?n?zG{?`A7L?p
=q? ěT?ěS?9XbM?
=p?
=p?n?      ?ěS?ěS?&x?hr Ĝ?`A7?`A7L?A7Kƨ?n?&x?      ?A7Kƨ?° ě?GzH?333333?nO?Q?öE?nO;?n?`A7L?I^5??M?Õ$/?7KƧ?S?n?lD?GzH?Õ$/?Z1'?\(?l?&x?7KƧ?333333?|hr?° ě?l?lD?Q?GzH?ěS?ļj~#?bM?Õ$/?`A7?I^5??|hr?l?nO?nO?nP?n?
=p?Q?`A7L?M?7KƧ?;dZ?I^5??\(?hr Ĝ?ěS?A7Kƨ?bM?7KƧ?&x?-V?hr Ĝ?Q? ěT?Q?lD?hr Ĝ?vȴ9X?7KƧ?Q?A7Kƨ?S?`A7?nO?|hr?lD?-V?
=p?M?
=p?ěS?A7Kƨ?Õ$/?E?
=p?° ě?ěS?|hr?nO;?tj?|hr?      ?ļj~#?ļj~#?tj?+?nO;?Q?
=p?n?n?`A7?\(?I^5??nP?$/?hr Ĝ?$/?I^5?? ěT?bM?      ?nP?ěS?|hr?|hr?&x?      ?S? ěT?
=p?nO;?$/?`A7L?ěS?;dZ?nO;?;dZ?vȴ9X?
=p?lD?`A7L?-V?7KƧ?Q?&x?Õ$/?lD?A7Kƨ?A7Kƨ?"`?$/?nO?+?I^5?? ěT?n?hr Ĝ?$/?$/?ěS?lD?GzH?ěS?hr Ĝ?vȴ9X?`A7L?$/?$/?hr Ĝ?GzH?7KƧ?M?-V?`A7L?$/?\(?hr Ĝ?hr Ĝ?`A7L?7KƧ?$/?n?
=p?° ě?n?vȴ9X?;dZ?$/?      ?Q?nO;?A7Kƨ?"`?      ?A7Kƨ?I^5??5?|h? ěT? ěT?|hr?-V?nP?ěS? ěT?`A7?-V?nO;?I^5??Õ$/?lD?E?&x?vȴ9X?GzH?7KƧ?"`?&x?bM?lD?Q?
=p?I^5??vȴ9X?\(?`A7L?$/?"`?
=p?nP?      ?"`?hr Ĝ? ěT?A7Kƨ?ěS? ěT? ěT?bM?ěS?5?|h                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	@N33333@N@O      @O@O&fffff@O&fffff@O333333@O333333@O&fffff@O333333@O@O333333@O&fffff@O&fffff@O333333@O333333@O@     @OY@OY@Os33333@Offffff@OY@OY@O@     @Offffff@Offffff@OY@OY@OY@OY@OY@OY@OL@OY@O333333@O333333@OL@OL@O@     @OY@OY@OY@OY@OL@Offffff@Os33333@O     @Os33333@Offffff@Offffff@O@Offffff@Offfff@Offfff@O33333@O33333@O     @O     @O     @O@Oٙ@Oٙ@Offfff@Oٙ@Offfff@O33333@P      @O33333@Pfffff@P33333@P&fffff@P333333@P9@PL@PY@Ps33333@P@P@P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P     @P     @P     @P@P@P     @P@P@P@P@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@P     @P@Pfffff@Pfffff@Pfffff@P     @Pfffff@P     @P     @Pfffff@P     @Pfffff@P     @P     @P     @Pfffff@P     @P     @P     @P     @P     @P     @P     @P     @P     @P@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P@P@P33333@P@P33333@P33333@Pٙ@Pٙ@Pٙ@Pٙ@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P@P@P@P@P@P@P@P@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@Pٙ@Pٙ@P33333@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P@P@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @Pٙ@Pٙ@P     @Pٙ@Pٙ@Pٙ@P33333@P@P     @P     @P     @P     @P@P     @P     @P     @Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @P33333@P     @P     @P     @P     @P     @P     @P     @P     @Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pٙ@Pٙ@P     @P     @P     @P     @P     @Pfffff@Pfffff@P     @Pٙ@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pٙ@Pٙ@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@P@P@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@Pfffff@P@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@Pfffff@P@Pfffff@P@P@P@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@P@P@P@P@Pfffff@P@P@P@P@P@Pfffff@P@P@Pfffff@P@P@Pfffff@P@P@P@P@P@Pfffff@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@Pٙ@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pٙ@Pfffff@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P33333@P@P@P@P@P@P@P@P@P33333@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P@P@P@P@P@P@P@P@P@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@Pfffff@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P33333@P@P@P@P@P@Pfffff@P@P@P@Pfffff@P33333@P33333@P@P@P33333@P33333@P33333@P@P33333@P33333@P33333@P@P@P@P@P33333@P@P33333@P@P33333@P@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P33333@P33333@P@P33333@P@P@P@P@P@P@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P@P@P@P33333@P@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P33333@P@P33333@P@P@P33333@P33333@P33333@P33333@P@P@P@P@P33333@P33333@P33333@P@P@Pfffff@P@P33333@P@P@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P@P@P@P33333@P@P33333@P33333@P33333@P@P33333@P@P@P33333@P@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P@P@P@P33333@P33333@P33333@P33333@P@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P@P33333@P33333@P@P33333@P@P@P@P@P@P33333@P33333@P@P@P33333@P@P@P@P33333@P@P@P33333@P@P33333@P@P@P@P@P@P33333@P@P@P@P33333@P@P@P33333@P33333@P@P@P33333@P33333@P@P@P@P@P33333@P33333@P@P@P@P@P33333@P33333@P33333@P33333@P@P@P@P33333@P33333@P@Pfffff@P33333@P33333@P33333@P@P@P@P@P@P33333@P33333@P33333@P@P33333@P33333@P@P33333@P@P33333@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P@P@P@P@P33333@P@P33333@P@P@P33333@P@P@P@P@P@P@P@P@P@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@Pfffff@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      P24                                     1                                       )BGX=3"