CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20170205   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P12    CAST_NUMBER       3      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:35.047733Z    ORIGINAL_HEADER      6CTD,20250210CCHSIOWB
#Removed 'CTDFLUOR_TSG' as it's filled with -999
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2017-06-29. CTD data from cruise 18DD20170205, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20170205. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2017-001/index.php. 
#
# The information in this file for the cruise 2017-001 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-0036.ctd
#
# Start of originator file comment header
#
#*2017/06/29 15:26:50.02
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2017/02/10 06:17:38.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 198
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : CE9F1F72
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            0.3            202.1
#       2 Temperature:CTD               deg_C_(ITS90)   5.6248         6.8697
#       3 Salinity:CTD                  PSS-78          32.78          33.8432
#       4 Sigma-t:CTD                   kg/m^3          25.7461        26.7106
#       5 Oxygen:Dissolved:CTD:Volume   ml/l            3.4            6.87
#       6 Oxygen:Dissolved:CTD:Mass     µmol/kg         147.7          299
#       7 Fluorescence:CTD:Seapoint     mg/m^3          0.66E-01       1.162
#       8 PAR:CTD                       µE/m^2/sec      0              0.3
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        7  F       ' '     2
#       6  -99   ' '        6  F       ' '     1
#       7  -99   ' '        8  F       ' '     3
#       8  -99   ' '        7  F       ' '     1
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2017-001
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P21
#    EVENT NUMBER        : 36
#    LATITUDE            :  49  38.00000 N  ! (deg min)
#    LONGITUDE           : 139  39.97000 W  ! (deg min)
#    WATER DEPTH         : 3961
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    The descent rate of the CTD was very noisy with some complete reversals
#	of direction.
#    CTDEDIT was used to remove many records corrupted by shed wakes;
#	salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Fluorescence and PAR data are nominal and unedited except that some records were
#	removed in editing temperature and salinity and a large spike in
#	fluorescence was removed from file 0032.
#
#    The Transmissivity channel was removed because of frequent shifts in values during
#	casts and large variations between values during repeat casts.
#	The data are available, by request, from the chief scientist.
#
#    NOTE: While the Fluorescence:CTD data are expressed in concentration units, they
#	do not always compare well to extracted chlorophyll samples, particularly for
#	casts far from shore. It is recommended that users check extracted chlorophyll
#	values where available.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in Sea-Bird
#	Application Note #64-2, June 2012 revision (Sea-Bird_64-2_Jun2012.pdf), except 
#	that a small offset in the fit was allowed.
#
#    The Dissolved Oxygen sensor used in files 0001, 0002 and 0016 malfunctioned so the 
#	Oxygen:Dissolved:CTD channels were removed from those files.
#
#    The Oxygen:Dissolved:CTD sensor has a fairly long response time so data accuracy 
#	is not as high when it is in motion as it is during stops for bottles. This will be
#	especially true when vertical dissolved oxygen gradients are large. To get an estimate
#	of the accuracy of the Oxygen:Dissolved:CTD data during downcasts (after recalibration)
#	a rough comparison was made between downcast Oxygen:Dissolved:CTD data and upcast 
#	titrated samples. Some of the difference will be due to problems with flushing of 
#	Niskin bottles and/or analysis errors, so the following statement likely underestimates 
#	Oxygen:Dissolved:CTD accuracy.
#
#    Downcast (CTD files) Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.25 ml/l from 0 to 125 dbar.
#	±0.2 ml/l from 125 to 400 dbar.
#	±0.1 ml/l from 400 to 600 dbar.
#	±0.05 ml/l from 600 to 1500 dbar.
#	Low by up to 0.08 ml/l below 1500 dbar.
#
#    For details on the processing see document: 2017-001-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5--- --6-- ---7--- --8---
#!Pressu Temperat Salinity Sigma-t: Oxygen Oxyge Fluores PAR:  
#!re:CTD ure:CTD  :CTD     CTD      :Disso n:Dis cence:  CTD   
#!                                  lved:  solve CTD:          
#!                                  CTD:   d:CTD Seapoin       
#!                                  Volume :Mass t             
#!------ -------- -------- -------- ------ ----- ------- ------
#*END OF HEADER
     WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @T@        data_max      @T@        C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     =   2   pressure                	long_name         pressure   positive      down   units         decibar    data_min      @333333   data_max      @L        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      =   p   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      H  $   temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?j~#   data_max      @c	   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       =   l   temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      H     salinity                	long_name         salinity   units         PSS-78     data_min      @@G$tS   data_max      @ALC,zx   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      =     salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      H E   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @'ffffff   data_max      @r\   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        =  U<   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      H \   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?(\)   data_max      ?o   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      =     CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      H    PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       =     PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d      H +,   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min               data_max               C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     =  :t   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d      H w   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         (    cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         (    time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      * 4   data_max      * 4   C_format      %10d       ,   latitude               	long_name         latitude   units         	degrees_N      data_min      @H|tj   data_max      @H|tj   C_format      %9.4f          0   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      `UKƧ   data_max      `UKƧ   C_format      %9.4f          4   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d        8   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min        4   data_max        4   C_format      %4d        <@T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @T@     @333333@@333333@      @      @      @       @"      @$      @&      @(333333@)@,      @.      @0      @1      @2      @3      @4      @5@6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @L33333@M@N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @Rl@R@S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V@W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Yfffff@Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b@c      @c      @c@     @c`     @c     @c     @c33333@cfffff@d      @d@d<@d`     @d     @d     @d     @d     @e      @e33333@eC33333@e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f33333@f     @f     @g      @g      @g@     @g`     @g     @g@g     @g     @h      @h      @h@     @h`     @hs33333@h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j\@j33333@j@j@j     @k      @k      @k@     @k`     @k|@kfffff@k     @k     @k@l)@l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @mfffff@m     @n      @n      @n@     @n`     @n     @n     @n     @n@o      @o      @o@     @o`     @o     @o@o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p@pfffff@p     @p     @p     @p     @p     @q      @q     @q!@q4@q@     @qP     @q`     @qp     @q     @q     @q     @q     @q@q     @q     @q     @r      @r     @r      @r1@rP     @r`     @rp     @r     @r     @r     @r     @r@r     @r     @s      @s     @s      @s0     @s@     @sI@s`     @snfffff@s     @s     @s     @s     @s     @sfffff@s     @s     @t      @t@t@t0     @t@     @tP     @t^fffff@tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u@ufffff@u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v@v@vfffff@v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @wfffff@wfffff@w     @x      @x     @x      @x0     @x@     @xP     @x`     @xl@x@x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yI@ya@yp     @y{33333@y     @y     @y     @y     @y     @y     @y񙙙@z      @z     @zfffff@z0     @z@     @zP     @z`     @znfffff@z33333@z     @z     @z     @z     @z     @z     @z     @{      @{fffff@{(     @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{@{fffff@{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}@}@}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~A@~Nfffff@~`     @~p     @~     @~     @~@~fffff@~     @~     @~     @~     @      @     @      @0     @@     @Nfffff@^fffff@p     @     @     @     @     @     @     @     @񙙙@fffff@     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0@8     @?33333@H     @P     @X     @`     @h     @p     @x     @     @33333@33333@     @     @     @     @@33333@     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @O33333@X     @`     @h     @p@w33333@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @@33333@      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @@33333@      @     @     @     @      @(     @0@8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @ @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8@@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x@     @     @     @     @     @     @     @     @     @     @     @ՙ@     @     @     @     @      @fffff@     @      @(     @0     @8     @@     @H@P     @X     @_33333@h     @p     @x     @     @     @     @33333@     @     @     @@@     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @fffff@@     @     @     @     @     @     @     @     @@      @     @     @     @      @(     @.fffff@9@@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @+33333@0     @8     @>fffff@L     @P     @X     @`     @h     @p     @x     @     @     @     @     @@33333@     @     @     @     @     @fffff@     @     @     @     @      @@@     @      @(     @0     @8     @?33333@Jfffff@P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @      @     @     @     @      @(     @0     @6fffff@I@P     @X     @`     @h     @m@@     @     @     @     @     @     @@     @     @     @     @     @     @     @     @      @     @     @     @33333@,     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @33333@33333@     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @/33333@5@@     @H     @P     @U@`@h@p     @x     @     @     @     @     @     @33333@fffff@     @     @     @     @     @     @@@      @     @     @     @     @fffff@     @     @      @$     @(     @,     @0     @3@<@@     @D     @H     @L     @P     @T     @Xfffff@\     @`     @f     @h     @l     @p     @t     @|fffff@     @     @     @@@     @     @     @     @@     @     @     @     @     @     @     @     @33333@@     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @      @"@(@,     @0     @4     @8     @<     @@     @D     @H     @Jfffff@T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @@ř@     @     @     @     @     @     @     @     @     @     @@     @     @     @      @     @     @     @     @     @     @@      @$     @(     @,     @0     @3@9@<     @@     @D     @H     @L     @P     @S33333@X     @\     @`     @d     @h     @l     @p     @t     @x     @33333@     @     @     @     @     @fffff@33333@     @     @     @     @     @33333@     @     @     @     @     @     @     @י@33333@     @     @     @     @     @     @     @      @     @fffff@     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @@@     @     @     @33333@     @     @     @@fffff@     @     @     @     @     @     @     @33333@     @     @     @     @33333@33333@     @     @     @     @fffff@fffff@33333@     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @F@L     @P     @T     @X     @\     @`     @d     @h     @l     @o@u33333@x     @|     @     @     @     @     @     @     @     @33333@33333@     @     @     @     @     @     @     @     @Ù@@     @     @     @     @     @33333@@     @     @     @     @     @      @     @     @     @@33333@     @     @      @$     @(     @,     @0     @3@8fffff@<     @@     @D     @H     @L     @P     @T     @X     @\     @dfffff@h     @l     @p     @t     @x     @{@@     @     @     @     @     @     @fffff@     @     @@     @     @     @     @     @     @     @     @@33333@     @     @     @     @     @     @     @     @     @     @     @      @     @@     @     @     @     @      @$     @(     @+@0@4     @8     @<     @@     @D     @Hfffff@L     @P     @T     @W@\     @`     @d     @h     @l     @p     @tfffff@v     @     @     @     @     @     @     @fffff@     @     @     @fffff@@     @     @     @     @     @     @     @fffff@     @     @     @     @㙙@     @     @     @     @@@     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @{@fffff@     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @@fffff@     @     @     @     @     @     @@     @     @     @      @     @     @     @     @     @fffff@!33333@$     @(     @,     @0     @4     @6fffff@<@@     @D     @H     @L     @O@Xfffff@\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @@33333@     @     @     @     @     @     @     @33333@@     @     @     @     @     @     @     @33333@fffff@     @     @     @     @     @33333@      @     @@     @     @     @     @@      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @W@]33333@`     @d     @h     @l     @p     @t     @x     @|     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @@@33333@     @      @     @     @     @     @     @     @@ @$     @(     @+@0@4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @k33333@p     @t     @x     @|     @     @     @fffff@     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @ϙ@     @     @     @     @     @     @     @     @     @@@      @     @     @     @     @     @     @     @      @$     @'33333@,     @0     @4     @8     @<     @>fffff@E@H     @L     @P     @T     @X     @\     @`     @b@lfffff@p     @t     @x     @|     @     @     @@@     @     @     @     @@@     @     @     @     @     @     @33333@@     @ϙ@     @     @     @     @     @     @@     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @:@@     @D     @H     @L     @P     @T     @X     @\     @_33333@d@h     @l     @p     @t     @x     @{@     @     @     @     @33333@fffff@     @     @     @@     @     @     @     @     @     @     @     @33333@fffff@     @     @     @     @     @     @     @     @     @ @     @     @     @     @     @     @@"     @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @ffffff@m33333@p     @t     @x     @{@     @     @     @     @     @@     @     @fffff@@     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @33333@     @     @     @      @$     @(     @.     @0     @4     @8     @<     @@     @D     @H     @L     @P     @Rfffff@X     @\     @`     @d     @h     @l     @p     @t     @vfffff@}33333@     @     @     @     @33333@fffff@     @     @     @     @fffff@33333@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @      @     @     @     @     @     @     @     @      @$     @&@1@4     @8     @<     @@     @D     @G@L                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         @ڹ@1.@,@$xG@	ԕ+@Xy=@@'@1@F
L0@u@`A7L@1@@1.@L/{J@L/{J@ڹ@F
L0@tSM@zxl"h@@@@@x@ڹ@1@@1.@L/{J@@@	k@	ԕ+@lC@RT`e@	ԕ+@lC@$xG@-@	ԕ+@Xy=@@@$xG@r Ĝ@@Xy=@Xy=@^@^@rGE@ۋq
@	ԕ+@,<@ڹ@@O
@O
@/@qj@tSM@7@+a@F
L0@zxl"h@@'@'@'@,<@,<@,@&@/V@	ԕ+@>BZc@@0U2a|@oiDg8@hr@ʌL_@bM@J@䎊@#Z@6z@\]ce@~ߤ?@&@Q@Z@sPH@c	@ٙ@2a|@䎊@ɠ'RTa@^5?|@E@zG@jf@fffff@;dZ@0
)@Mj@L_@}Vl!@lVϪ@_?@OAs@Gݗ+@9rGE8@y=c@S@<64@2W@u@Ϫ͞@|hs@MjO@<쿱@R<6@R@]cf@}H˒@kC]@`u!@WO;d@LcA \@+U=@2a|@Mj@-
q@)^@C\@}Vl@+a@ݲ-V@sP@y@oiDg@w1@T@3|@-V@
(@c	@@ѷX@!.@oiDg8@cA @@4n@sMjO@m\@]/w@Qu@C{J#9@'fA@"}Vm@ -
@e+@˒:)@GE85@쿱[W?@/V@t@+a@`d@E84@u\(@k~($@nH@o-V@l!-w@^5?|@TɅoi@N;5X@:)_@6C-@(@%@s@Gz@64@{J#:@}!.H@ka@@f,<@ZY@XbM@VϪ͟@Xy=c@P)^@O'/W@EoiDg@@NU@'/W@qiC@*0@-
@A@yrGE8@sg@sPH@qo@qA [@q[W>6@nt@g-@W&@M%@B@7eں@,"h	ԕ@ u!@N;6@33333@u%F@H@\(@?@D@<쿱@E@x-
@q[W>6@l"h	ԕ@g,@fL/{J@aR<6@[qu!@W&@H˒:*@6z@@
(@ NU@
qv@حV@҈p:@bM@/{J#@:S@o@d7@fA@1@S@ߤ@@oVϫ@ceO@Y+@Gy@D2W@;m]@8F@0'RT@)y@(ۋq
@$xF@JE@
qu"@@@lC@쿱[W?@빌~($@VϪ@B@"`B@ĵ?@E@(@~($@rGE@TɆ@=K^@@#@~vȴ9X@n2X@bwkQ@ZQ_@Uᰉ@S&@L_@Fs@<hr@3MjO@0@)lD@"C,@*0@@?@\N<@
=q@&@+a@tSM@%1@@4@N;5@{/V@rGE85@hTɅ@fA@b@4@^@Uᰉ@K)^	@$%1@p
=@
(@S@
:@+I@ 6@6z@~@C-@c	@޸Q@;5X@/{J#@Q@K]d@s@ȴ9X@Ov`@ ѷY@e+a@@C%@:S@˒:)@}v@{m]@z)y@wrG@rs@lC@_Ft@Xtj@WsPH@V+J@T*1@R䎊@O͞@OAs@N+@MM:@Ks@I^5?}@GK]d@?$tS@9Y}@0
(@)B@!R<6@@
D@L_@I^5?@@;5X@_o @	^5?}@E84@ hۋq@C\@:~ @fB@	@e+a@v_ح@Q@˒:*@@K]d@Ǔݗ+@Ƨ-@
L/@oiDg@"`@|@hr!@`A@Q_@@a@O@tj@u?@rs@lC@eF
L0@^쿱[W@LcA \@LcA \@Jn@@NU@?@<쿱[@>($x@>($x@=b@>vȴ9X@?b}V@?.H@@hۋq@B&IR@CF]c@B\(@;lC@:~@:G{@;~$@=ڹZ@A:S@B ѷ@As@ATɅo@@hۋq@>vȴ9X@=p
=@9~($@0oiDg8@)lD@(	ԕ+@'&@(\)@&A@$%1@+j@?@S                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          @
e@
`u!@
Yb}@
S&@
K]cA@
GzH@
H@
I@
A7Kƨ@
6E@
0{@
-w1@
(\)@
#S&@
,=@
0
)@
_o@
kP|@
tj@
@
nO@
)^@
o @
qi@
Vu@
ߤ?@
ߤ?@
@
q@
'/@
'/@
#@
Fs@
_o@
oiDg@($x@4֡a@@Z1@@4@Ft@cA @"`B@@l!-@҈p:@+@cA \@W'@8YK@*0@o i@s@m\@ߤ?@Y}@&x@/V@3@+j@O;dZ@%2@     @sPH@Z1'@Np:~@LcA \@K:)z@M5Xy>@M%@JL_@K:)z@L/{J#@E8YK@@n@>vȴ9X@=b@=p
=@<64@;dZ@4J@C,zx@_o@E@
=q@	k@Z1@C,@e@ޞ@]cA@?@m\@v@2X@V@*0U2a@TɆ@Q@-
q@u%F@oiDg@~\N<@vȴ9X@lVϪ@jJL@hۋq
@fA@glC@^iB@QX@Eo i@2ᰊ@0'RT@+I^@*d7@($xG@!-w1@tj@*0@$tT@'/W@I^5?@1&x@@
\N<@
xl"h
@
C\@
	k~@
kP@
oiDg8@
ᰉ'@
>@
ۋq@
>BZ@
ٳ|@
JE@
حU@
@
>6z@
t@
2a|@
,<@
҈p:@
҈p:@
&@
&@
H@
:@
)^	@
Q@
g8}@
@
ߤ?@
4m@
m\@
Xy=@
L/{J@
?@
ae@
䎊r@
wkP@
ߤ@@
qu!@
kP|@
6C@
6C@
6C@
@
Xe,@
Ov_@
@
ݗ+@
o h@
ݗ+@
@
IQ@
z@
u!.@
t#@
u\(@
~\N<@
n/@
Vu@
hr @
1&x@
u!R@
jJL@
g8}H@
`d8@
TE@
B@
6}Vl@
5sg@
3ߤ@
2m\@
1-@
0'RT@
C,zx@
$tS@
_F@
ߤ@@
1&@
N;6@
 ѷ@
 IQ@
$/@	b}V@	PH@	ڹZ@	.H@	\N<@	C\@	@	빌~($@	B@	fA@	e@	e+@	/w@	ۋq@	ۋq@	JE@	>6z@	,<@	_p@	n@	ɅoiD@	@	@	˒:*@	E84@	8YK@	o i@	a@N@	Zc@	[W>@	ᰊ@	O
M@	r@	2W@	՛=K@
5Xy=@
Eo i@
GzH@
DS@
T`d@
]+j@
Zݘ@
Yb}@
Z1'@
TE@
W
=p@
T`d@
F
L/@
;dZ@
8Q@
2m\@
,q@
)^@
($xG@
%1@
#wk@
!R<6@
U=@
 ěT@
&L/{J@
PH@	
M;@	˒:*@	-w1@	n/@	&I@	k~(@	.H@	u!.@	tj~@	w1@	w1@	weں@	sMjO@	xF]d@	{lC@	n.      @	ěS@	Ƨ-@	~($@	YJ@	m\@	}Vl@	0
)@	v+jg@	a@N@	_Ft@	kC]@	qu!S@	tj~@	x73@	v_ح@	u\(@	vȴ9X@	xF]d@	xF]d@	xl"h	@	y	k~@	x-
@	tD@	oiDg8@	kP{@	_;dZ@	Vl!-@	Vt@	TɅoi@	O
M;@	Np:~@	M%@	H˒:*@	Dg8}@	:^5?|@	73@	4J@	1o@	/r@	*d7@	,zxl"@	*0U2a|@	(TɅ@	($xG@	%S@	#
=p@	qu!@	S@	-
q@	u%F
@rGE@Q_@4m@/V@tj@(@M:@vȴ@@\N@m\@̘_@,<@fA@bM@@Ϫ͞@`A7@5Xy>@cA \@ΤT@As@cA \@˒:)z@s@KƧ@}!.H@_حV@R<64@E8YK@;dZ@0U2a|@($xG@-V@iDg8@>BZc@e@䎊qj@A [@|Q@iB@JE@
=p@֡af@fA@_p@5?|@P{@{m@%F
L@+jg@ȴ9X@D@:~ @빌~($@Dg8~@ѷX@cA \@Ƨ@#9@W'@K]c@84֡@?@vȴ9X@S&@3@J@v@B@H@
qv@ěT@@Z@qu"@K]d@|hr@p:~ @qiB@     @w+@\>@P*0U@K)^	@F?@Em\@Em\@8Q@2W@2-V@0{@8Q@,q@1@g	@	ԕ+@ᰉ'R@_p@ɅoiD@&IR@}H@Xe@E@Xe@#w@A@Y}@#w@33333@0U2a|@tSM@	@4J@?@~m\@y"`@qA [@p
=q@o hۋ@ffffff@bC,@^5?|@]+j@\(\@S@NT@I@Gy@Fs@Ca@N@A7Kƨ@@n@@n@>
(@9#w@43@*0U2a|@#wk@!.H@"h	ԕ@!-w1@䎊r@Q@Fs@
O;dZ@ݗ+@o h@%2@b}V@=b@!.I@\(@@D@O;@r Ĝ@>@c	@y=c@@]cf@74@64@S&@R<6@1&x@u!R@ql@mC\@m\@jfB@glC@g8}H@be+@_o@\>@Z1'@XU@WsPH@W
=p@W
=p@UϪ͞@Q@M5Xy>@HK]c@GzH@H@GE84@Dg8}@?@:)_@0 ě@"`A@vȴ@kP|@@N@N;6@-
q@@	ԕ*@	7KƧ@
	 @1&x@ݗ+@Fs@+I@n/@xl"h
@iB@8Y@r Ĝ@rGE@@fffff@fffff@fffff@ڹ@@>BZc@	k@lC@A@@N@c	@>6z@l!-@Ϫ͞@`d@R@@ǮzH@74@[W>@~@2W@1@U=@B@>B[@0U2a|@}H@Ov_@bM@!R<@=p
@@F]c@~"@xl"h	@n.2@h	ԕ+@f1.@ZY@LcA \@E@D*0@A7Kƨ@=K]@8}H@43@3|@3g	l@2W@1o@/Vϫ@*0U2a|@ 'RT`@L_@Fs@҉@-
q@$tS@eں@%F
L@MjO@!-w2@73@rGE8@	k~@	k~@73@SMj@8Y@8Y@\@"h	ԕ@fB@e@@4@ڹ@@ڹ@唯O
@Z1@ᰉ'R@D*@حU@t@ѷX@/{J#@@ǮzH@š@TɅo@A@sg@2W@H@1&y@lD@@'@S@TɆ@n.3@`A@.H@䎊r@Q@kP|@L_@@sP@-
q@Mj@(@!R<@Mj@Mj@Vu@!R<@L_@=p
@ݗ+@$/@Q@I^5@~\N<@{s@n.2@l"h	ԕ@iB@be+@Xe+@W&@S&@R䎊@Ov_ح@P|@NT@N_o @L_@B74@4֡a@0'RT@.1@-
qv@.H@-w1@(\)@'&@%1@!o@!-w1@쿱[W@%@Ov_خ@}H@[@1&@6C@@e+a@tj@@@0
)@ᰉ@O
M@*0U2@nO@n@-
q@
qu"@
qiC@	7KƧ@eO@@@(@eں@\(@Y|@!-w2@@t@"h	ԕ@	ԕ+@8}H@@ڹ@@ᰉ'R@ޞ@>@6@ڹY@b}@e+@fA@҈p:@R@|@ΤT@D@ǮzH@Õ$@7Kƨ@m8@@.H@Ov_خ@wkP@qu!@6C@@tj@*0U2@bM@o @qu"@'/@L_@L_@p:@nP@I^5@I^5@:S@b}V@:S@4m9@b}V@~$t@~$t@~\N<@~($x@|hr@{lC@zxl"h
@qiB@lVϪ@kC,z@^@[W>6z@Zc	@Y|@WsPH@VϪ͟@Vt@U=K@U2a|@Vt@SMj@R䎊@R䎊@P*0U@P|@OAs@I@G@@F]cf@;/V@74m@.1@(\)@%u@ 'RT`@[@u"@[@0
)@tj@0
)@PH@_F@*0@_F@_F@_F@@@O
M@nO@n@4J@)^@rGE9@n@bM@
L/{@%2@Q@_ح@ ě@䎊q@PH@PH@MjO@䎊q@GE85@j~@@8}H@حV@/w@c	@Ʌoi@@ʌL_@Q@ȴ9Xb@K]c@@y@&IR@H˒:@p
=@j~#@dZ@Y}@ߤ@r@lD@Xy=@@u@
=p@?@tSM@h	ԕ@R<6@-
@U=@u"@wkP@wkP@R<6@$tT@ߤ?@҈@k~(@JM@@}E@rs@mC\@m\@l[W?@kQ@j~"@cS@\>@Xy=c@XbM@W&@W>6z@W
=p@Vaf@Vaf@V8YJ@S&@LcA \@J#9@H˒:*@F]cf@Fs@?[W>@<64@;/V@:^5?|@9XbM@84֡b@:^5?|@:^5?|@84֡b@74m@12W@.1@.zG@-U=@-V@,zxl"@(TɅ@"h	ԕ@ [6@vȴ9@%@-V@wkP@ߤ@@S@u%@e+a@+J@O
M@tj~@hr @C%@@
qiC@	 ѷ@#@_o@YJ@n/@ݗ@nP@nP@@%2@o hی@ ?@ C\@ (@ 73@ +jg@ GE85@ O;@ fB@ ~"@ Ov`@ ᰉ'@ ,<@ |Q@ A7K@ JE@ `d@ Ϫ͞@ 5Xy>@ ʌL_@ K]c@ m\@ Zc@ @ @ A@ dZ@ ^5?|@ )@ ᰊ@ U2a|@ r@ v@ zG@ *0U2a@ *0U2a@ lD@ 0
@ ͞&@ ͞&@ d7@ lD@ 
=p@ R<6@ -
@ vȴ9@ !-w1@ Q@ u@ u@ C,zx@ kP|@ _F@ R<6@ sh@ L_@ @N@ S&@ \(@ @ C%@ '/@ ԕ*@ &I@ ݗ@ M:@ 4m9@ b}V@ }!.H@ z@ y=b@ y=b@ xF@ tSMj@ sMjO@ qiB@ q@ o-V@ nO;@ m\@ l!-w@ lC@ kC]@ iB@ gfA@ f,<@ cA [@ b@4@ ^@ Zݘ@ W>6z@ UϪ͞@ UϪ͞@ TɅoi@ P*0U@ JW'@ J#9@ IoiD@ I@ J#9@ IoiD@ GzH@ DS@ C$@ Ca@N@ B&IR@ A@ >vȴ9X@ ;dZ@ 9#w@ 6E@ 12W@ +a@@ )@ 'RT`e@ $/@  [6@ Ov_خ@ u@ u@ ,=@ -V@ ,=@ }H@ IQ@ S@ @ Z@ @ ҉@ n@ rGE9@ 
O;dZ@ '/@ 1&x@ Fs@ YJ@ ?@ @4n?ڹZ?\(?!-w2??쿱[W??>BZc?,<?Z?
qu? ѷY?ڹY?8YJ?`A7????y?W'?a@N?Q?[W>6?U=?ae?vȴ9?쿱[W?u%F?R<6?*0?tj~?S&?C%?M:?$/?xF?q?fA?ae?_Ft?\>?\(\?Zc	?XbM?U=K?P{?N;5X?L_?K]cA?H?@NU?9XbM?5Xy=?5?|h?*0U2a|?'RT`e?&IQ?'/V?&IQ?&IQ?'RT`e?"`A?䎊r?}H?qu!?_o??Z??'/W?
L/{?
=p
?
L/{?Fs??:S? ѷX?.H?~$?+jg?C]?JL?rGE?ᰉ'?lC??1.??1.?e+?
qu?iB?ݗ+j?/w?????/w?;dZ?
qu?
qu?҈p;?s?ɅoiD?y?Ƨ-?TɅo?n?[W>?H˒:?
(?<64?j~#?ߤ?                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @@G$tS@@GkP@@G$tS@@GkP@@G	k@@G	k@@G-V@@G	k@@G-V@@G?@@G?@@G-V@@G	k@@G?@@GkP@@GkP@@GkP@@G-V@@G?@@G͞@@G?@@G	k@@G&@@G&@@G&@@G?@@G&@@GzH@@G&@@G?@@G&@@G͞@@G͞@@G͞@@G&@@G&@@G&@@G͞@@GzH@@G͞@@G͞@@G͞@@G͞@@G&@@G&@@G&@@G͞@@G&@@G͞@@G&@@G?@@G&@@G͞@@G?@@Gr@@G-@@H     @@H@@H
qu@@HbM@@H*0@@HU2a|@@Hr Ĝ@@Hr Ĝ@@HeO@@Hy=c@@Hu!@@H
(@@I@N@@I@N@@I&x@@I7Kƨ@@I'RTa@@IX@@J0U2a|@@J@4n@@JS&@@J䎊q@@KnP@@L!-w2@@Nt@@O䎊r@@Ru%F@@TZ1@@Y@@_lC@@cC,z@@gXe@@oRT`e@@sMjO@@{J#9@@rGE9@@Q@@D@@!-w2@@	k@@5?|@@@N@@L_@@(@@0
@@n.@@IQ@@X@@=K^@@9XbN@@Q@@?@@)^@@䎊q@@:@@#@@JE@@h	ԕ@@/@@҈p;@@䎊r@@k~(@@]cA@@̇#@@Κ,<@@ϝ-V@@[6@@	@@Ԣ3@@և+J@@v_ح@@$tT@@>BZ@@ڟvȴ@@a@O@@&I@@ěT@@&x@@ᙙ@@e+@@<64@@tj~@@Q@@,<@@쿱[@@1.@@|hs@@fA@@`A7@@u%F@@kP|@@&@@n.3@@m]@@a@O@@C]@@s@@,<@@PH@@cA \@@*1@@@@?@@@@*0@@(@@/w@@B@@zxl"h@@ڹZ@@Xy=@@+jg@@_ح@@Ov_خ@@\N<@@O;@@@@@@@@+I@@sPH@@v_ح@@v_ح@@@@;dZ@@'RT`@@4m9@@*0@@ ě@@6@@-
q@@A7K@@eO@@l"h	@@oiDg8@@y=c@@r Ĝ@@@@d8@@@@tj@@-
@@tj@@oiDg8@@[6@@Q@@eO@@oiDg8@@n@@˒:*@@˒:*@@|@@n@@-
@@
(@@F@@D@@F@@e+@@҈p@@p:@@TɅ@@ѷX@@`A7@@)^@@ěT@@ěT@@ۋq
@@D@@e+@@ۋq
@@@@@TɅ@@F@@D@@@@@ѷX@@p:@@D@@@@	k~@@ ѷ@@	k@@ѷX@@4֡b@@@@	k@@\)@@\)@@@@0
)@@:S@@7KƧ@@:S@@:S@@TɅo@@x@@񂩓@@~($@@R<6@@񂩓@@|Q@@x@@R<6@@u@@R<6@@B@@B@@2W@@@@@@2W@@ԕ*@@N;6@@_o@@iB@@	 @@u%F@@u%F@@.H@@u%F@@.H@@-@@u%F@@e+@@:)y@@GE85@@Zc@@M@@@4n@@C\@@6C@@6C@@~"@@p:@@L_@@@4@@~"@@h	ԕ@@GE85@@JL@@M@@qiC@@S&@@͞&@@)_@@͞&@@I^@@)^	@@Mj@@{J#9@@eO@@S@@U=@@
=p@@҈@@lC@@$@@
=p@@:)z@@6@@"h	ԕ@@cA \@@*1@@?@@쿱[@@3@@zxl"@@@@Ʌoi@@*0@@S&@@jOv@@sg@@$/@@@@\N<@@-@@A@@]cf@@1@@v_ح@@kP@@͞@@[W>@@vȴ9@@K]d@@@@*0U@@*0@@H@@Xy=@@hۋq@@n@@U@@ѷX@@F@@e+@@4֡b@@ ѷ@@&x@@=b@@@@|@@-@@@@Ov`@@@4n@@p:@@Y@@G{@@'/@@S@@U=@@C]@@xF@@Fs@@cA \@@TɆ@@@@84֡@@$/@@sh@@oiDg@@ڹ@@ ѷY@@
L/@@@@$/@@+jg@@5?|@@?@@;5X@@;5X@@L/{J@@c	@@l!-@@+J@@1@@H˒:@@eں@@{J#:@@3@@#@A 6@A $xG@A *0@A F]d@A F]d@A *0U@A  ě@A }H@A -
q@A 4m9@A 73@A A7K@A D*@A U2a|@A [6@A r Ĝ@A ěT@A F@A ۋq
@A {@A#w@Ak~(@An.@Al@AB@AB@A|@A^5?}@Al@A|@A|@A>BZ@A0U2a|@Axl"h
@A0
@Avȴ@A)_@A䎊q@A~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          @A!4J@A!JE@A!u!S@A!oiD@A!R<6@A!u@A!'RTa@A!l@A!"`@A"1'@A"3@A":)y@A"JL@A"Zc@A"ݘ@A"S&@A"}Vm@A"n@A",<@A"G{@A#S&@A#҉@A#s@A#PH@A#PH@A#C,z@A#	@A#,zxl@A#,zxl@A#6z@A#33333@A#F]c@A#J#9@A#F]c@A#P{@A#{J#9@A#~($@A#ݗ+k@A#lC@A#@A$@A$!-w2@A$?@A$Z1@A$g8}@A$o h@A$3@A$zxl"@A$@A$u"@A$Z@A$Z@A$u"@A$JM@A%!.H@A%84֡@A%Y|@A%w1@A%p
=@A%zxl"h@A%!R@A%@A%U=@A%8YK@A&4K@A&($x@A&+jg@A&+jg@A&1.@A&5?|@A&8YJ@A&E@A&BZc @A&L/{J@A&R<6@A&R<6@A&Ov_خ@A&R<6@A&YJ@A&_ح@A&}Vl@A&z@A&IQ@A&T@A&t@A&ߤ?@A&C-@A&1@A&"@A&쿱[W@A'@A'>6z@A'As@A'As@A'E84@A'H˒:@A'RT`e@A'U=@A'_o@A'@A'͞@A'K]d@A';dZ@A'Vϫ@A(F]d@A(F]d@A(	ԕ+@A(bM@A(*0U@A(4m9@A(Q@A(y=c@A(@A({@A()^@A(p:@A(ۋq
@A(4֡b@A(	k@A)$/@A)+@A)&x@A)-w1@A)A [@A)^@A)k~(@A)|Q@A)|Q@A)|Q@A)7Kƨ@A)'RTa@A)X@A)N;6@A)y@A)ԕ*@A)@A)"`@A)@A)"`@A)"`@A)"`@A)ᰉ'@A)R@A)Y}@A)Y}@A*u%F@A*I^5@A*I^5@A*s@A*1'@A*#9@A*6C@A*T`d@A*Zc@A*{m@A*xl"h
@A*g	@A*}Vm@A*n@A*W@A*W@A*䎊q@A*D@A+nP@A+&@A+)^	@A+)^	@A+,zxl@A+MjO@A+J#9@A+F]c@A+S@A+Z@A+g	l@A+dZ@A+xF]@A+~$@A+~$@A+@A+q@A+A@A+a@@A+s@A,Q@A,,<@A,C,zx@A,64@A,2W@A,C,zx@A,2W@A,,<@A,64@A,64@A,<쿱@A,M:@A,]ce@A,wkP@A,쿱[@A,S@A,_@A,TɆ@A,?@A,/@A-:@A,E@A,E@A,!-w@A,!-w@A,>@A-'0@A-u@A-[@A-%F
L@A-/w@A-%F
L@A-%F
L@A-(@A-/w@A-5Xy>@A-O;dZ@A-Vl!@A-S&@A-ce@A-fA@A-zxl"h@A-ݗ@A-O
@A-+j@A-=K@A-=K@A-@A-@A-v@A-Xy=@A--V@A-H˒@A-b@A.8YJ@A.H@A.Vu@A.YJ@A.m\@A/Vϫ@A0'RT`@A0-
q@A0-
q@A0'RT@A0
(@A0ěT@A0ěT@A0{@A0'RT@A0U@A0)@A0{@A0-
@A0u%F@A0@A0
=q@A0tj@A0tj@A0@A0'RT@A0'RT@A0'RT@A0@A0n@A0@A01&x@A0}H@A/Vϫ@A/@A/͞@A/r@A/K]d@A/vȴ9@A//V@A/r@A/r@A/r@A/vȴ9@A/K]d@A/o @A06      @A17KƧ@A1JE@A1Dg8~@A1Dg8~@A1*0U2a@A10
)@A1#w@A1@A0PH@A1Gz@A17Kƨ@A1B@A1ᰉ'@A2e+@A2:)y@A2GE85@A2Zc@A2ݘ@A2~"@A2~"@A2ݘ@A2 ě@A2)_@A2 ѷ@A2sP@A2D@A3҉@A3҉@A3'/@A3	@A3	@A3	@A3&@A3,zxl@A3a@N@A3a@N@A3jf@A3eO@A3A@A3A@A3@A3~($@A3~($@A3E@A3Z@A36@A35Xy@A36@A3@A3a@O@A3S@A3q@A3dZ@A39@A3"`B@A2~@A3'/@A3dZ@A4@A4,<@A49XbN@A4Z1@A4zG@A4o h@A4C@A4qj@A4?@A4N;@A41&@A4D@A5'0@A5u@A5qu"@A5u@A5qu"@A5(@A4hr@A4?@A4?@A4TɆ@A4쿱[@A4*1@A4#@A4*1@A4O
M@A4O
M@A4?@A4?@A4?@A4*0@A4Z@A4@A4hr@A4D@A5:@A5(@A5}H@A5H˒@A5?@A5oiDg@A5ڹ@A6$/@A6Ov_خ@A6L/{J@A6Vu@A6\N<@A6?@A6H@A6fffff@A6fffff@A6_ح@A6fffff@A6vȴ9X@A6}Vl@A6O;@A6}Vl@A6ߤ?@A6ȴ9X@A6҈p;@A6C-@A6Fs@A6쿱[W@A6Mj@A7Ft@A71@A7H˒:@A7\(@A7_o@A7U=@A7y@A7	k@A7rGE9@A7䎊r@A7;dZ@A7+@A7˒:)@A7˒:)@A7fA@A7rG@A8$xG@A8'RT`@A84m9@A8hۋq@A8NU@A8     @A7䎊r@A7-@A7-@A7@A7@A7;dZ@A7Vϫ@A8K]c@A8eO@A8eO@A8y=c@A8YJ@A8@A8U@A84m@A8)@A8
(@A8@@A8ѷX@A8D@A8e+@A8{@A9@N@A9*0U2a@A9Q@A9hr @A9hr @A9o hی@A9^@A9^@A9rGE8@A9rGE8@A9x@A9b}@A9|Q@A9oiD@A9~($@A9@A9'RTa@A9'R@A9'R@A9X@A9^5?}@A9D@A92W@A9o@A9_o@A9_o@A9ԕ*@A9iB@A9R@A9lD@A:u%F@A:I^5@A:@A:#9@A:&IR@A:&IR@A:&IR@A:&IR@A:&IR@A:-V@A:@4n@A:@4n@A:M@A:d7@A:xl"h
@A:L_@A:ᰊ@A:S&@A:>B@A:n@A:c	@A:D@A;I^@A;I^@A;҉@A;	@A;,zxl@A;6z@A;F]c@A;F]c@A;]cA@A;jf@A;@A;:)z@A;:)z@A;wk@A;Ƨ@A;a@@A;Q@A;lC@A;s@A<xF@A<ߤ@@A<tj@A<64@A<,<@A</{J#@A<9XbN@A<9XbN@A<9XbN@A<64@A<2W@A<2W@A<9XbN@A<?@A<<쿱@A<?@A<?@A<?@A<?@A<C,zx@A<cA \@A<#@A<qj@A<1&@A<@A<#x@A<j~@A<7@A<[W?@A<?@A<Ʌoi@A<Z@A</@A</@A<@A<E@A=u@A=*0@A=qu"@A=qu"@A=Q@A=%F
L@A=2a|@A=F
L0@A=L_@A=F
L0@A=L_@A=jOv@A=zxl"h@A=$/@A=ݗ@A=M:@A=!R@A=hr!@A=!R@A=+j@A==K@A=U=@A=cA @A=@A=Ϫ͞@A=S@A=ᰉ@A=S@A=ᰉ@A>t@A>zG@A>!R<@A>$/@A>($x@A>($x@A>1.@A>8YJ@A>8YJ@A>;5X@A>5?|@A>?@A>BZc @A>YJ@A>l!-@A>s@A>z@A>vȴ9X@A>z@A>fffff@A>p:~@A>IQ@A>IQ@A>$t@A>O;@A>6z@A>2X@A>Q@A>@A>m\@A>x@A>@A>Mj@A?@A>Mj@A>"@A?Ft@A?@A?v@A?+I@A?+I@A?8}H@A?>6z@A?b}V@A?lC@A?b}V@A?o@A?4m@A?@A?ݗ+@A?$tS@A??@A?3@A?o @A?˒:)@A?@A?rG@A?@A?@A?-@A?-@A?+j@A?#@A?#@A?rGE9@A?rGE9@A@F]d@A@
qu@A@}H@A@*0@A@-
q@A@:~ @A@73@A@D*@A@D*@A@>BZc@A@H@A@H@A@H@A@K]c@A@Q@A@bM@A@l"h	@A@r Ĝ@A@˒:*@A@'RT@A@u%F@A@4m@A@TɅ@A@ěT@A@p:@A@҈p@A@`A7@A@@A@4֡b@A@$tT@A@{@A@{@A@\)@A@	k@AA ѷ@AA@AA#w@AA*0U2a@AA7KƧ@AA-w1@AA-w1@AA=b@AAA [@AAGz@AAQ@AAXbM@AA[W>6@AA[W>6@AAXbM@AAae@AAae@AA^@AAe+a@AAhr @AAo hی@AArGE8@AA|Q@AAoiD@AAo@AA'RTa@AAB@AA@AAy@AA_o@AAiB@AAs@AAs@AA@AA@AAY}@ABu%F@AB䎊@ABOv`@ABe+@ABe+@AB#9@AB0U2a|@AB0U2a|@AB6C@AB:)y@ABC\@ABC\@AB@4n@AB=p
@ABM@ABQ_@ABZc@ABZc@AB^5?|@ABh	ԕ@ABkP|@ABqiC@AB~"@AB{m@AB@4@ABݘ@AB\(@ABwkQ@AB ě@AB>B@AB,<@ABD@AC'/@ACC,z@AC"`B@AC&@AC)^	@AC)^	@AC33333@AC=K^@ACJ#9@ACF]c@ACW>6z@ACZ@ACW>6z@ACZ@AC]cA@ACn.3@ACtj~@ACxF]@ACtj~@AC@ACxF]@AC{J#9@AC~$@AC@ACQ@AC@AC~$@ACeO@ACeO@ACMj@ACwk@ACE@AC|@AC
=p@AC%2@AC҈@AC%2@AClC@ACg@ACA [@AC$@AC@ACs@AC@AC@AC\N@ADJ@ADn.@ADxF@ADL_@AD!-w2@AD"h	ԕ@AD9XbN@AD?@ADPH@ADM:@ADVϪ@ADcA \@ADg8}@ADg8}@ADq@ADm8@ADtSM@ADtSM@ADtSM@AD~($x@ADq@ADtSM@ADwkP@ADzG@ADzG@ADo h@AD#@ADqj@ADqj@ADqj@ADN;@AD*1@ADqj@AD*1@ADzxl"@AD@AD[W?@AD*0@AD֡a@ADZ@ADZ@ADZ@ADZ@AD֡a@AD>B[@ADZ@AD/@ADD@AE:@AEo i@AEK]@AE%F
L@AE%F
L@AE/w@AE2a|@AE5Xy>@AE84֡@AE5Xy>@AE<64@AEO;dZ@AEVl!@AEVl!@AE\@AEce@AEp
=@AEzxl"h@AEM:@AEO
@AE=K@AE@AE=K@AEv@AEXy=@AEXy=@AEU=@AE1@AEH˒@AE\(@AE8YK@AE@AEϪ͞@AES@AEE@AF_o @AFt@AF
L/@AFzG@AF!R<@AF+jg@AFL/{J@AFR<6@AFR<6@AFR<6@AFVu@AF\N<@AFl!-@AFz@AF+J@AF+J@AF+J@AF@AF@AF@AF$t@AFqi@AF,<@AFT@AF-@AF-@AF2X@AFQ@AFߤ?@AFȴ9X@AFȴ9X@AFt@AF҈p;@AF҈p;@AFA@AFA@AF+@AF]cf@AF@AF"@AF!.I@AG@AG@AGFt@AG)^@AG,@AG'/W@AG'/W@AG'/W@AG+I@AG.H@AG.H@AG4֡a@AG4֡a@AG;dZ@AGKƧ@AGH˒:@AGH˒:@AGRT`e@AG_o@AG\(@AGeں@AGlC@AGo@AGo@AGsPH@AGy@AGy@AG|hs@AG|hs@AG4m@AG|hs@AG	@AGݗ+@AGkP@AG-V@AG-V@AG?@AGzH@AG[W>@AGvȴ9@AGvȴ9@AGK]d@AGK]d@AG+@AG@AG;dZ@AG䎊r@AGrGE9@AH@AH*0U@AH6@AH6@AH$xG@AH*0@AH1&x@AH4m9@AH:~ @AH:~ @AHA7K@AHD*@AHXy=@AH[6@AH[6@AHbM@AHbM@AHoiDg8@AHhۋq@AHl"h	@AHl"h	@AHoiDg8@AHl"h	@AHoiDg8@AHr Ĝ@AHn@AH'RT@AH'RT@AH@AH@AH-
@AHtj@AH@AHtj@AHIQ@AH
=q@AH@AHd8@AHd8@AHU@AH{@AH
(@AHTɅ@AH)^@AHѷX@AH@@AHѷX@AHF@AHۋq
@AH`A7@AH`A7@AH4֡b@AH	k@AI$/@AH	k@AH{@AI$/@AI$/@AI@AI	k~@AI@N@AI+@AI@AI_p@AI [7@AI#w@AI#w@AI*0U2a@AI-w1@AI7KƧ@AIA [@AIA [@AIN;5@AIXbM@AIae@AIXbM@AI^@AIk~(@AI|Q@AI7Kƨ@AI|Q@AI|Q@AI|Q@AIb}@AIoiD@AI~($@AI@AIR<6@AI@AI'RTa@AIu@AIl@AI|@AI^5?}@AIy@AIN;6@AI@AIe@AIs@AIY}@AIY}@AI-@AI-@AI-@AIlD@AIlD@AIlD@AJu%F@AJn@AJ	 @AJOv`@AJOv`@AJ1'@AJ#9@AJ&IR@AJ0U2a|@AJ3@AJ=p
@AJ@4n@AJC\@AJJL@AJW'@AJW'@AJd7@AJh	ԕ@AJnO@AJu%F
@AJxl"h
@AJu%F
@AJ~"@AJp:@AJp:@AJL_@AJS&@AJwkQ@AJL/{@AJ>B@AJ>B@AJL/{@AJ}Vm@AJ)_@AJ͞&@AJ`A@AJG{@AJG{@AJ䎊q@AJm@AJD@AJm@AJ74@AJ74@AJm\@AKu%@AK'/@AKC,z@AK,zxl@AK/V@AK@N@AK@N@AKF]c@AKF]c@AKJ#9@AKP{@AKMjO@AKW>6z@AKW>6z@AK]cA@AKa@N@AKa@N@AKn.3@AKxF]@AK~$@AKMj@AKeO@AK:)z@AKA@AK:)z@AKA@AK$@AKߤ@AKwk@AK*0U2@AKS@AKS@AKq@AK@AKm]@AKE@AKZ@AK6@AKƧ@AK6@AK@AK5Xy@AK5Xy@AK5Xy@AK|@AK
=p@AK҈@AK$@AKs@ALJ@AK@AKs@AKs@AK\N@AK@AK$@ALn.@ALJ@ALxF@AL1&y@ALߤ@@ALߤ@@ALxF@AL1&y@AL1&y@ALJ@AL1&y@ALxF@AL(\@AL%1@AL(\@AL,<@AL9XbN@AL/{J#@AL64@AL2W@AL9XbN@AL?@ALC,zx@ALC,zx                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @rVfffff@rNfffff@rK33333@rI@rH     @rC33333@rA@r1@r1@r333333@r1@r;33333@rC33333@r>fffff@r6fffff@r333333@r6fffff@r@     @rI@rD@rQ@rI@rD@rD@rI@rL@rP     @r[33333@r\@rT@rL@rNfffff@rX     @rP     @rT@rS33333@rT@rX     @rT@rQ@rQ@rQ@r[33333@rY@rNfffff@rI@rI@rNfffff@rT@rP     @rNfffff@rNfffff@rK33333@rK33333@rK33333@rK33333@rQ@rD@r4@r333333@r<@rC33333@rD@rNfffff@rNfffff@rA@r@     @rC33333@rC33333@rA@r@     @r;33333@r6fffff@r8     @r9@r9@r6fffff@r0     @r&fffff@r@qfffff@q     @q@q33333@q6fffff@p33333@p@pNfffff@o@o&fffff@nC33333@m|@lfffff@k33333@kC33333@j@j     @j0     @i33333@i33333@i33333@is33333@i0     @hٙ@h33333@h@hfffff@h@hffffff@h9@h33333@g     @gə@gfffff@g@g33333@gə@g@g33333@g     @gl@gS33333@g333333@g33333@f33333@ffffff@ffffff@f|@fl@f\@f<@f	@e33333@e33333@e33333@efffff@e@e33333@e@e     @ec33333@eP     @e@     @e@d33333@d33333@dfffff@dfffff@dfffff@d33333@dy@di@dY@dI@d<@d)@d33333@c@c     @cfffff@c@c33333@c@c@cfffff@c     @c|@c     @cffffff@c,@c	@b33333@b33333@b33333@bə@b33333@b     @bfffff@b33333@b@b@bfffff@bfffff@b@bfffff@bp     @b@     @b33333@a@a     @a@a     @a@a@a@afffff@a     @afffff@a     @affffff@a)@`@`fffff@`33333@`33333@`     @`@`     @`fffff@`@`33333@`     @`ə@`     @`fffff@`@`@`y@`vfffff@`Vfffff@`6fffff@`      @`#33333@`,@`33333@_33333@_ٙ@_@_l@_Ffffff@_9@_Ffffff@_9@_333333@_&fffff@_@_      @^33333@^L@^@]     @]     @]@]fffff@]     @]fffff@]333333@]fffff@\@\@\ٙ@\ٙ@\@\fffff@\l@\ffffff@\Y@\`     @\S33333@\Ffffff@\@     @\,@\,@\Ffffff@\L@\9@\&fffff@\fffff@[     @[33333@[ٙ@[ٙ@[@[     @[333333@[@Z@Zٙ@Zٙ@Z33333@Z33333@Z@Zl@Z`     @ZY@ZS33333@ZL@ZFfffff@ZFfffff@Z333333@Z      @Yfffff@Yfffff@Y     @Y@Yfffff@Y33333@Y     @Y@     @Y@Xٙ@X@Xl@Xffffff@Xl@X333333@W33333@W33333@Wfffff@W     @Wy@WS33333@WFfffff@W333333@W33333@W33333@W      @V     @V@Vfffff@V     @V33333@V33333@Vfffff@Vy@V`     @V&fffff@Ufffff@U     @Ufffff@U33333@U`     @T@T@TY@T9@T33333@S     @S33333@S@S33333@S     @Sffffff@Sffffff@Sffffff@SS33333@S      @S      @R@R     @R     @R@Rfffff@R@R     @Rffffff@RS33333@R9@R      @Q33333@Q33333@Q@Ql@Q`     @Q`     @Q,@Pfffff@Pfffff@P@PY@P333333@Pfffff@Offfff@Os33333@OY@O&fffff@Nٙ@N33333@N@     @M@M     @Ms33333@M@Ms33333@Mffffff@MY@ML@M@M     @Ms33333@M     @M@Ms33333@ML@M@L@Lffffff@LL@L@Kٙ@K     @Kfffff@K     @K@L      @L      @Kfffff@K@K@K33333@K@K@Kfffff@K@Kffffff@KL@K333333@K@K      @Jٙ@Jfffff@JL@J@Ifffff@I@I33333@Ifffff@I@I33333@J@J      @I@Ifffff@IL@I&fffff@I@H@Hfffff@Hffffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                @0fffff@1333333@0@0L@0      @0333333@0L@0      @/@/@/@/333333@/@/@/@/333333@.@.@.@.@.@.333333@.      @.333333@.333333@.ffffff@.333333@.@.@.@.ffffff@.ffffff@.333333@.333333@.@.@.@.ffffff@-@-333333@-      @-333333@,@-333333@-      @-@-@-ffffff@-@,@,@,@,@,@,ffffff@,ffffff@,@,@,333333@,333333@,333333@,      @,ffffff@,ffffff@,333333@+@,      @,333333@,      @+@+@+@,      @,      @,333333@,333333@,ffffff@,      @,@,      @+@,@,ffffff@,@,ffffff@+@,ffffff@,ffffff@,333333@,ffffff@,ffffff@,@,333333@,ffffff@,ffffff@+@,      @,ffffff@,      @,      @,ffffff@,ffffff@,      @+@+ffffff@+333333@+@+@+@+@,      @+@,333333@+@+ffffff@+@+@+@+@+ffffff@+@+@+333333@+@+@+ffffff@+      @+333333@+333333@+333333@*@+      @+      @+@+      @*@+333333@+333333@+      @+333333@+333333@+333333@+333333@+333333@+333333@+      @+      @*@+333333@+333333@+      @+ffffff@*@*@*@+333333@+      @)@)@*@+333333@+333333@+      @*@*333333@*333333@)@*@*ffffff@*      @*      @*@*      @)@*333333@*      @*333333@*333333@*333333@*333333@*ffffff@*      @)@)@)333333@)@)ffffff@)      @*      @)@)@*ffffff@*@*ffffff@)@*333333@*      @)@)@)@)@*@*333333@)@)@*      @)@*      @)@)@*      @)@)@)@)@*      @*@*@*333333@)@)@*      @*ffffff@*      @*333333@*      @)@)@*ffffff@*333333@)@)@)@)@)@*      @)ffffff@)ffffff@)@)@)333333@)333333@(@'@'@(      @'@'@(ffffff@(333333@(      @'@'@'ffffff@'@'@'@'@'@'@'@'@'@'@(      @(@(333333@(      @(333333@(333333@(@)      @)ffffff@(@)333333@(@)      @)333333@)ffffff@)333333@(@(@)333333      @(@(      @(      @(ffffff@(@(@(@(@(@)333333@)      @(@(@(@(ffffff@(@(@(@)      @(@(@(@(ffffff@(@)      @(@(@(@(@)      @)      @(@(@)      @)333333@)      @)333333@)333333@(@)333333@)@)@)333333@(@)      @)@)ffffff@)ffffff@)ffffff@)ffffff@)ffffff@)@*      @)@)ffffff@)333333@)ffffff@)ffffff@)@)@)@)@)@)@*      @*333333@*333333@)@)@*333333@)@*333333@*333333@*      @*333333@*ffffff@*ffffff@)@*333333@*@*ffffff@*ffffff@*333333@*333333@)@)@*@*ffffff@+      @*@*ffffff@*@*@*@*@*@*@+333333@+@+ffffff@+ffffff@+333333@+@+@+@+@,      @+@+ffffff@+333333@,      @,      @+ffffff@+333333@+@,      @+      @+@,@,333333@,333333@,@,      @,@,@,333333@,@-333333@-      @,@,@-      @-@-@-@-@.      @-@-@-ffffff@-@.      @.      @.      @/      @-ffffff@-@.ffffff@-@-@.333333@-@.333333@.@.333333@-@.333333@/333333@.@/      @/333333@/333333@/333333@.@/      @/      @/      @/ffffff@/ffffff@/@0333333@/@0      @0333333@0333333@0@0      @/@/@0@0@0333333@/@0      @0L@0333333@0      @0     @0@0333333@0L@0333333@0333333@0     @0@0      @0ffffff@0@033333@0ffffff@0@0@0@0     @0@033333@0@0@033333@0@033333@033333@1      @0fffff@0fffff@1L@1333333@1ffffff@1333333@1ffffff@1ffffff@1ffffff@133333@1@133333@133333@1@2333333@1@1@1fffff@2@2      @2333333@2      @2ffffff@2L@2333333@2     @2     @2L@2     @2@2@2@2fffff@2fffff@2@2@3333333@3333333@3@2fffff@2fffff@3333333@3      @2fffff@2fffff@3333333@3ffffff@3333333@3     @3@3      @3ffffff@3@3@3ffffff@3@3@3@3@3@3@333333@3fffff@3fffff@4      @4@4      @3@4      @4fffff@4     @3fffff@4L@4     @4@4@4@4@433333@433333@4@4fffff@4@4@5@5333333@5ffffff@5     @5ffffff@5L@5ffffff@5     @5L@5     @5@5@533333@5@5@5L@5     @5@5@5@6@6      @5@6      @6      @5fffff@6@6      @5@5@6@6L@6333333@6333333@6L@6@6@6@7      @6@6@6fffff@7      @7      @7ffffff@7     @7@7L@7@8@8ffffff@8      @8333333@8L@8     @8ffffff@8     @8L@8L@8     @8@9@8fffff@8@8fffff@9@8@9      @9L@9@9@9333333@9333333@8fffff@9@9333333@9333333@9@9333333@9     @9ffffff@9     @9333333@9333333@9333333@9ffffff@9@9     @9333333@9L@:      @:      @9@:      @:@:333333@:L@:     @:     @:     @:@:33333@:333333@:@:@:33333@:33333@:fffff@;@;33333@;333333@;L@;L@;333333@;     @;@;33333@;33333@;@;@;@;@<      @;@;@;@;fffff@<      @<      @<      @;@<@;fffff@<333333@<L@<333333@<     @<     @<     @<L@<33333@<@<@=@<@<@=      @=      @=333333@=333333@<fffff@=@=     @=333333@=@=ffffff@=333333@=@=333333@=ffffff@=     @=     @=333333@=@=33333@=@=@=33333@=33333@>@>L@=fffff@>@>@>@>fffff@?L@?     @?L@?     @?     @?L@?     @?33333@?33333@?L@?     @?@?@?33333@@      @@@@@?@@      @@@?@@      @@@     @@@@@     @@@@      @@@     @@&fffff@@L@@ffffff@@Y@@ffffff@@ffffff@@Y@@@@33333@@fffff@@     @@     @@fffff@@fffff@@fffff@@33333@@@@     @@     @@     @@@@ٙ@@     @@fffff@A@A@A&fffff@A333333@A&fffff@A@     @AY@Affffff@Affffff@AY@Affffff@As33333@Affffff@As33333@AY@A@As33333@Afffff@Affffff@A@Afffff@A     @As33333@A@A@Afffff@A     @Afffff@Afffff@A     @Aٙ@B      @B@B@A33333@B      @A33333@A33333@B@B      @Afffff@A33333@B@BL@BY@Bffffff@B     @B@B     @B@B33333@Bs33333@B@B@Bfffff@B     @B@Bfffff@B33333@B33333@Bٙ@Bfffff@C@C333333@C@CL@C333333@C333333@C@C&fffff@C333333@C333333@C333333@CL@Cffffff@Cs33333@C@     @Cffffff@C@C     @Cfffff@C33333@C33333@Cٙ@D@D      @D@D333333@D333333@Dffffff@D333333@Dffffff@Dffffff@Dffffff@D     @Ds33333@DY@D333333@D     @D@Dffffff@D@D@D33333@D33333@D33333@D33333@Dfffff@D33333@Dٙ@D33333@D@Dfffff@Dٙ@Dfffff@E@E333333@E@E      @E&fffff@E@E333333@EY@Effffff@EL@E333333@Effffff@E     @E     @Es33333@E@     @Es33333@E     @Es33333@Es33333@Efffff@E33333@Efffff@E     @E33333@E@Eٙ@E     @E@E33333@E33333@E33333@E     @E     @E33333@Efffff@F&fffff@F      @E     @F@F333333@F@F@     @F@F&fffff@F@F&fffff@Fffffff@F@F@F@Fffffff@F@F     @F     @Ffffff@Ffffff@G&fffff@G      @G@     @G      @Ffffff@G@G333333@G@Gffffff@G@     @G@GL@GY@G333333@G&fffff@GL@Gffffff@G333333@GY@G@Gs33333@G     @G     @Gffffff@G@G     @Gs33333@Gfffff@Gٙ@G     @G     @G@G33333@G@Gfffff@Gٙ@Gٙ@G33333@H      @G33333@H&fffff@H      @H@H@H@HY@H@H333333@HL@Hffffff@Hs33333@HY@H@     @HL@H333333@Hs33333@Hfffff@Hfffff@Hfffff@H     @H     @H     @Hs33333@H@H33333@H@Hٙ@H@Hfffff@I      @I      @I&fffff@I@I&fffff@I333333@I@I      @IY@IL@I&fffff@Iffffff@Iffffff@I@     @I@     @IY@I     @I     @I@I@I@I     @I33333@Iٙ@J      @J@Ifffff@J@J@J@I33333@J      @J&fffff@J&fffff@JL@J@     @J&fffff@J&fffff@J&fffff@J      @J&fffff@J333333@Js33333@J     @Js33333@J@Jfffff@K      @Jٙ@Jfffff@Jfffff@J     @K      @K@K      @K@Jfffff@Jfffff@J33333@K333333@K@     @K@     @K@K333333@Kffffff@K     @Kffffff@KL@K     @K     @Kfffff@Kٙ@Kfffff@K@K@K     @L@L      @L      @K33333@Kfffff@K33333@L@L@     @Lffffff@L@Lffffff@L@     @L333333@L@Lfffff@L@L@L@L@L33333@L@Lٙ@M      @Lٙ@Lfffff@Lٙ@L@L33333@Lfffff@L33333@Lfffff@Lfffff@M@M&fffff@M      @M333333@M333333@M@M&fffff@Ms33333@Mffffff@M&fffff@ML@ML@ML@MY@Ms33333@ML@ML@Mffffff@Mffffff@Mfffff@M33333@M     @M     @Mfffff@M@M@M@Mٙ@M33333@M33333@M33333@M     @Mٙ@Mfffff@M@Mfffff@Mfffff@M33333@M33333@M@Mfffff@M33333@N&fffff@N333333@N@N@N@                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         ?hr Ĝ?+J?䛥S?+J?nP?9XbN?C%?j~"?9XbM?lC?bM?A7Kƨ?9XbM?9XbM?o?ěS?+?C%? ěT?㝲-V?
=p?-V?1&x?S?zG?\(\?+I^?lC?bM?1&x?Q?+?O;dZ?zG?;dZ?bM?O;dZ?vȴ?I^5?dZ1?;dZ?O;dZ?lC?O;dZ?|hr?I^5?}?dZ1?
=p?E?+?+I^?lC?nO?㕁$/?㝲-V?~"?ffffff?^5?|?$/?Q??|hs??tj~?bM?tj~?E?tj~?j~#?-V?+I^?޸Q?E???|hs?I^5?}?۶E?333333?ڟvȴ9?Q?bM?ָQ?E?/w?+?ҟvȴ9?&x?\(?nO;?vȴ9X?I^5?}?ȴ9XbN?+?ļj~#?333333?M?`A7L?vȴ9X?vȴ9X?dZ1?^5?|?E?E?tj~?
=p
?
=p
?
=p
?tj?E??|hs?\(?9XbM?E?333333?zG{?tj~? ě? ě?333333?-V?lD?lD?Q?&x?Q?&x?&x?&x?`A7L?bM?
=p?`A7L?hr Ĝ?bM?&x?
=p?
=p? ěT?`A7L?`A7L?vȴ9X?;dZ?bM? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?Q?5?|h?vȴ9X?;dZ?vȴ9X? ěT?;dZ?Q?;dZ?vȴ9X?vȴ9X?-V?Q?Q?-V?Q?5?|h?5?|h?Q?Q?Q?Q?;dZ?Q?Q?;dZ?Q?5?|h?;dZ?Q?Q?Q?;dZ?5?|h?Q?Q?bM? ěT?;dZ?;dZ?Q?vȴ9X? ěT?Q?Q?bM?Q?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?bM?vȴ9X?vȴ9X?bM?;dZ?Q?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?Q?;dZ? ěT?bM?bM?bM?
=p?;dZ?;dZ?vȴ9X?vȴ9X?;dZ? ěT? ěT?vȴ9X? ěT? ěT?;dZ? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?Q?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?bM? ěT?vȴ9X?vȴ9X?;dZ? ěT?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?Q?;dZ?;dZ?Q?Q?vȴ9X?vȴ9X?vȴ9X? ěT?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?Q?Q?Q?;dZ?Q?vȴ9X?;dZ?;dZ?vȴ9X?Q?Q?vȴ9X?Q?Q? ěT?vȴ9X?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?Q?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?vȴ9X?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?Q?Q?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?;dZ?;dZ? ěT?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ? ěT? ěT?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ? ěT?bM?;dZ?vȴ9X?;dZ?;dZ?vȴ9X? ěT?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?Q?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X? ěT?;dZ?vȴ9X?;dZ?Q?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?Q?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?5?|h?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?Q?;dZ?Q?Q?Q?;dZ?vȴ9X?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?Q?Q?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?Q?Q?Q?Q?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?;dZ?Q?;dZ?Q?Q?;dZ?Q?Q?Q?Q?5?|h?Q?Q?Q?5?|h?Q?Q?;dZ?Q?Q?Q?Q?;dZ?Q?5?|h?Q?Q?Q?;dZ?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?Q?Q?5?|h?Q?Q?Q?5?|h?5?|h?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?5?|h?-V?Q?;dZ?Q?Q?Q?;dZ?Q?Q?Q?Q?5?|h?Q?Q?5?|h?Q?Q?Q?;dZ?Q?Q?;dZ?Q?Q?5?|h?Q?5?|h?Q?Q?Q?5?|h?5?|h?Q?Q?Q?5?|h?Q?Q?Q?Q?5?|h?Q?Q?Q?5?|h?5?|h?5?|h?Q?5?|h?Q?Q?5?|h?Q?5?|h?5?|h?Q?Q?Q?5?|h?5?|h?Q?5?|h?Q?Q?Q?Q?Q?;dZ?Q?5?|h?Q?5?|h?Q?Q?Q?-V?Q?Q?5?|h?Q?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?Q?5?|h?Q?5?|h?Q?5?|h?Q?5?|h?5?|h?5?|h?5?|h?/v?-V?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?/v?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?Q?5?|h?5?|h?Q?Q?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?-V?5?|h?Q?-V?Q?Q?5?|h?5?|h?5?|h?5?|h?-V?Q?Q?-V?5?|h?5?|h?5?|h?Q?Q?5?|h?5?|h?-V?5?|h?5?|h?5?|h?-V?5?|h?-V?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?-V?5?|h?-V?-V?/v?-V?-V?5?|h?5?|h?-V?5?|h?5?|h?Q?5?|h?5?|h?5?|h?Q?5?|h?5?|h?-V?5?|h?-V?5?|h?5?|h?-V?5?|h?Q?-V?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?/v?-V?5?|h?-V?-V?5?|h?5?|h?5?|h?5?|h?5?|h?-V?-V?/v?-V?5?|h?-V?5?|h?5?|h?/v?5?|h?-V?5?|h?/v?/v?/v?/v?1&y?-V?5?|h?-V?1&y?/v?/v?-V?/v?/v?5?|h?/v?5?|h?5?|h?5?|h?/v?/v?/v?-V?5?|h?5?|h?-V?-V?5?|h?-V?/v?-V?-V?5?|h?5?|h?-V?/v?-V?-V?-V?5?|h?-V?5?|h?5?|h?5?|h?-V?5?|h?/v?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?-V?/v?/v?1&y?-V?-V?5?|h?/v?/v?/v?-V?5?|h?/v?-V?-V?-V?5?|h?-V?/v?-V?5?|h?-V?-V?5?|h?5?|h?-V?/v?/v?5?|h?-V?5?|h?-V?/v?1&y?-V?/v?-V?/v?/v?-V?-V?-V?/v?/v?-V?/v?/v?/v?/v?1&y?/v?-V?-V?/v?/v?/v?1&y?-V?/v?1&y?/v?5?|h?-V?/v?/v?/v?1&y?1&y?/v?/v?/v?/v?5?|h?-V?/v?-V?/v?1&y?1&y?-V?/v?/v?/v?-V?/v?/v?1&y?/v?/v?-V?-V?/v?/v?-V?5?|h?/v?/v?/v?-V?/v?/v?-V?-V?1&y?-V?-V?1&y?-V?/v?-V?1&y?/v?/v?/v?/v?1&y?/v?1&y?1&y?/v?-V?-V?/v?1&y?1&y?1&y?(\)?1&y?/v?/v?(\)?/v?-V?/v?/v?1&y?/v?-V?/v?/v?/v?-V?/v?/v?/v?/v?/v?1&y?1&y?1&y?/v?/v?1&y?1&y?/v?/v?/v?/v?1&y?1&y?1&y?1&y?/v?/v?/v?/v?1&y?/v?/v?/v?/v?/v?/v?1&y?1&y?/v?1&y?1&y?/v?/v?1&y?1&y?1&y?1&y?/v?1&y?1&y?1&y?1&y?(\)?1&y?/v?1&y?1&y?/v?/v?/v?-V?1&y?/v?-V?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?/v?/v?1&y?/v?/v?/v?1&y?(\)?/v?/v?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?/v?(\)?1&y?1&y?1&y?(\)?-V?/v?1&y?1&y?1&y?(\)?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?/v?1&y?1&y?1&y?1&y?1&y?/v?/v?1&y?/v?1&y?1&y?1&y?1&y?(\)?1&y?(\)?1&y?1&y?/v?1&y?1&y?1&y?1&y?1&y?1&y?/v?1&y?1&y?/v?1&y?1&y?1&y?1&y?1&y?1&y?(\)?1&y?1&y?1&y?1&y?1&y?(\)?(\)?1&y?1&y?1&y?(\)?1&y?(\)?1&y?(\)?(\)?(\)?1&y?(\)?(\)?1&y?1&y?1&y?(\)?(\)?1&y?(\)?(\)?1&y?1&y?(\)?(\)?1&y?1&y?(\)?1&y?1&y?(\)?1&y?1&y?1&y?1&y?(\)?1&y?1&y?(\)?(\)?(\)?1&y?(\)?(\)?(\)?(\)?1&y?(\)?(\)?(\)?(\)?(\)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	P12                                     3                                       * 4BC^34