CDF       
      time      pressure     latitude      	longitude         string_dimension   (         EXPOCODE      29AJ20160818   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    WOCE_ID       TAlPro     	DATA_TYPE         WOCE CTD   STATION_NUMBER        12     CAST_NUMBER       1      BOTTOM_DEPTH_METERS          
Creation_Time         2020-03-19T19:50:18.291896Z    ORIGINAL_HEADER      CTD,20200319CCHSIO
# Converted CTDOXY from ML/L to UMOL/KG using the following:
#     https://github.com/TEOS-10/GSW-Python, downloaded 2019-06-26
#     gsw.sigma0:  Calculates potential density anomaly with reference pressure of 0
#     dbar, this being this particular potential density minus 1000 kg/m^3.
#     This function has inputs of Absolute Salinity and Conservative
#     Temperature.  This function uses the computationally-efficient
#     75-term expression for specific volume in terms of SA, CT
#     and p (Roquet et al., 2015).
#     http://www.teos-10.org/pubs/gsw/html/gsw_sigma0.html 
#     Python equation used:
#         oxy_UMOL_per_KG = oxy_ML_per_L * 44.660 / ( (1000 +  gsw.sigma0(SA,CT)) / 1000. ) 
# Data source:  https://doi.pangaea.de/10.1594/PANGAEA.902330
# SHIP: RV Angeles Alvarino
# Cruise: MedSHIP cruise TalPro
# Region: Mediterranean Sea and Catalan Basin
# Ports: Palermo, Italy to Barcelona, Spain
# DATES: 20160818 - 20160829
# Chief Scientist: L.Jullion
# 43 stations
# Original file in AWI format. CCHDO Converted to Exchange format
# EVENT_CODE=unknown
# DATE: YYYYMMDD
# TIME: HHMM
# LATITUDE: degrees_North
# LONGITUDE: degrees_East
# STNNBR:  removed leading 0s from STNNBR
# CASTNO: not supplied by originator - CCHDO assigned all CASTNO=1 or CASTNO=2 for stations 11, 29
# CTDSAL: changed units from Practical to PSS-78.  Data values remain unchanged.
# CTDFLUOR: changed units from UG/L to MG/M3 as they are they are equivalent
# CCHDO added flags=2 for all parameters, as T.Tanhua notes all params are calibrated and CTDOXY calibrated with bottle samples
# Removed two test sample depths from event/station 004, dTalpro_Stn04_test_1db
# Data precision preserved as submitted.
# CTD: Who - T.Tanhua; Status - calibrated,final
#     Includes: CTDSAL, CTDOXY
#     CTDTMP NOTE: Used first occurrence of primary temperature sensor in original data file
#     CTDSAL NOTE: Used first occurrence of primary salinity sensor in original data
#     NOTE: Physical parameters temperature, salinity, oxygen, density, turbidity, chlorophyll, fluorescence are published on PANGAEA, DOI above.
# Fluorescence (CTDFLUOR): Who - T.Tanhua; Status -final
#        Instrument: WET Labs ECO-AFL/FL, FLNTURTD-2526
#        ScaleFactor: 1.00000000e+001
#        Dark Output: 0.0760
# Turbidity (CTDTURBDTY): Who - T.Tanhua; Status - final
#        Instrument: FLNTURTD-2526
#        ScaleFactor: 5.000000
#        Dark output Voltage: 0.070000
#
# Reference: Cruise report: https://epic.awi.de/id/eprint/49725/1/TAlPro_EUROFLEETS_cruise_report_V2.pdf
# CCHDO page: https://cchdo.ucsd.edu/cruise/29AJ20160818
# Metadata from original file
#     Event(s):     TAlPro-2016_012 (12) * LATITUDE: 41.600000 * LONGITUDE: 10.080000 * DATE/TIME: 2016-08-21T00:00:00 * CAMPAIGN: TAlPro-2016 * BASIS: Angeles Alvarino (URI: http://www.eurofleets.eu/np4/285.html) * DEVICE: CTD/Rosette (CTD-RO)
#     Citation: Tanhua, Toste (2019): Physical oceanography during MedSHIP cruise Talpro. PANGAEA, https://doi.org/10.1594/PANGAEA.902330
#     Abstract: The TAlPro cruise (Palermo - Barcelona, RV Angeles AlvariÃ±o, 18/-8/2016 - 29/08/2-16) occupied three hydrographic transects across the Tyrrhenian Sea, the western Mediterranean Sea and the Catalan Basin (Fig. 1) as part of the MedSHIP programme (Mediterranean Ship-based Hydrographic Investigations Program). A total of 43 stations were occupied during which physical (temperature, salinity, pressure, velocity), biogeochemical (oxygen, nutrients, carbonate system, dissolved Barium, oxygen and nitrogen isotopes) and anthropic (CFCs, SF6) parameters were measured in order to monitor the physical and biogeochemical state of the Mediterranean Sea.
#     Related to: Jullion, Loic (2016): TAlPro-2016: A Tyrrhenian Sea & Alger- provencal component of the MedSHIP Programme. hdl:10013/epic.5a866780-1f8a-45cf-8111-47b2b5dc29db
#     Parameter(s):
#         Event label (Event) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Sample code/label (Sample label) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Date/Time of event (Date/Time) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Latitude of event (Latitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Longitude of event (Longitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Pressure, water [dbar] (Press) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Digiquartz
#         Temperature, water [Â°C] (Temp) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: ITS-90
#         Oxygen, dissolved [ml/l] (DO) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 43
#         Turbidity (Nephelometric turbidity unit) [NTU] (Turbidity) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO
#         Fluorescence, chlorophyll [Âµg/l] (Fluores) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO-AFL/FL
#         Salinity (Sal) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Practical
#     License: Creative Commons Attribution 4.0 International (CC-BY-4.0)
   WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            pressure               	long_name         pressure   positive      down   units         decibar    data_min      @          data_max      @        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC        '   pressure_QC                	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      (  ;   temperature                	long_name         temperature    units         ?C (ITS-90)    data_min      @+W4m   data_max      @8tqj   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC         @   temperature_QC                 	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      (  Uh   salinity               	long_name         salinity   units         PSS-78     data_min      @C:n   data_max      @C]<64   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC        Z   salinity_QC                	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      (  o(   oxygen                 	long_name         oxygen     units         ?mol/kg    data_min      @d?   data_max      @q.H   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC          tP   	oxygen_QC                  	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      (     CTDFLUOR               	long_name         CTDFLUOR   units         MG/M^3     data_min      6C-   data_max      @
ߤ@   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC           CTDFLUOR_QC                	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      (     	CTDTRBDTY                  	long_name         	CTDTRBDTY      units         NTU    data_min      ?   data_max      ?ə   C_format      %f     WHPO_Variable_Name        	CTDTRBDTY      OBS_QC_VARIABLE       CTDTRBDTY_QC          CTDTRBDTY_QC               	long_name         CTDTRBDTY_QC_flag      units         
woce_flags     C_format      %1d      (  h   time                	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      &	   data_max      &	   C_format      %10d           latitude               	long_name         latitude   units         	degrees_N      data_min      @D   data_max      @D   C_format      %9.4f              	longitude                  	long_name         	longitude      units         	degrees_E      data_min      @$(\)   data_max      @$(\)   C_format      %9.4f              	woce_date                   	long_name         	WOCE date      units         yyyymmdd UTC   data_min      35   data_max      35   C_format      %8d            	woce_time                   	long_name         	WOCE time      units         hhmm UTC   data_min             data_max             C_format      %4d            station                	long_name         STATION    units         unspecified    C_format      %s        (     cast               	long_name         CAST   units         unspecified    C_format      %s        (  @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        @8tqj@8,Q@7CPH@4G{@2@2{@2C,z@247@1_p@1MjO@1kP{@0 hۋ@0ߤ@@0F]d@0^m\@01e@0C@/_ح@/zH@/F,<@/Zc@.t@.%2@.S*0U2@. ѷX@-C\@-'R@-zH@-R<6@-?@-p*0U@-PH@-JڹY@-/;dZ@-W>6z@-䎊q@-
%@-e@,dZ@,%F
L@,/{J#@,ߊ	@,_o@,6z@,y@,Ȍ@,O;dZ@,յsh@,܄?@,Vl!@,
=p@,@,1@,C]@,Dg8~@,ƍ@,u%F
@,?@,_F@,&x@,!-w@,p:@,I^5@,	k@,[W>@,-V@,PH@,Q@,G{@,rG@,Fs@,+jg@,4K@,ݗ+k@,sP@,&@,z@,F]d@,bM@,bM@,@,}H@,#w@,R<6@,?@,
qu@,hr@,b}@,1'@,vȴ@,1'@,)y@,>B@,J#9@,j~#@,I^5@,e+@,䎊r@,Ft@,Ft@,+j@,~$@,~@,G{@,0
)@,4m@,-
@,YJ@,3@,@,rG@,+jg@,|@,\@,Ƨ@,C\@,w1@,~($x@,C%@,ԕ*@,@,Fs@,Z1@,Z@,a@N@,Zc@,C@,@,NU@,}v@,zvȴ@,yrGE8@,w@,sMj@,ql@,p*0U@,n2X@,n!R<@,mhr!@,mV@,lVϪ@,k:)z@,g-@,g/V@,gRT`e@,f-@,f,<@,f-@,fYJ@,d2W@,ao hی@,\?@,YXbM@,W4m@,XF]d@,Y+@,UfA@,Stj~@,P
(@,OO
M@,N.2@,NO;@,MU=@,K҈@,Ik~(@,DM:@,C	@,C{J#9@,B}Vm@,A [7@,>m\@,>m\@,>쿱[W@,=-V@,;/V@,:vȴ@,9>BZ@,9#w@,873@,8YJ@,7O;d@,6t@,6R<6@,6+jg@,5?|h@,49XbN@,49XbN@,4@,2䎊q@,*	 @,*0U2a|@,,VϪ@,+U=@,)^5?}@,)rGE@,(˒:*@,(@,'-@,'	k@,&
L/@,%`A7L@,%u@,$tSM@,#eO@,!o@,! [7@, IQ@, -
@, ҈p@,!e@,!e@,"I^5@,"3@,"&IR@,!ae@,!$/@,!Gz@,!:S@,!-w1@,!TɅo@,!7Kƨ@,!'R@,!@,!e@,!.H@,"e+@,"@4n@,"Zc@,"@4@,"\(@,"wkQ@,"`A@,#S&@,#S@,#a@N@,#n.3@,#wk@,#
=p@,#A [@,#\N@,$tj@,$2W@,$tSM@,$e@,%n/@,&?@,&fffff@,&fffff@,&@,&&I@,')^@,(˒:*@,(TɅ@,(p:@,)Dg8~@,._o @,/͞@,0 ě@,0-
q@,0-
q@,0U2a|@,0oiDg8@,0'RT@,0{@,0$tT@,1N;6@,2:)y@,3Z@,3E@,3tj~@,3tj~@,2<64@,2:)y@,2-V@,2nO@,2S&@,2䎊q@,3@N@,1-@,0H@,/rGE9@,0@,0*0U@,0 ě@,0H@,0-
q@,/-V@,/r@,0D@,1N;5@,1hr @,1N;5@,1@,1N;6@,1-@,2䎊@,2ᰊ@,2 ě@,2S&@,2:)y@,2s@,0
=q@,0U2a|@,0
(@,.Mj@,-%@,,@,,<쿱@,,L_@,,1&y@,+a@@,+q@,+Ƨ@,+q@,+q@,+:)z@,+)^	@,+6z@,+)^	@,*n@,*g	@,*g	@,*n@,*L/{@,*L/{@,*n@,*fB@,*͞&@,*W'@,)lD@,)y@,)B@,)Q@,(eO@,'/V@,%oiDg@,%u@,$JM@,$*0@,$?@,$o h@,#A [@,#@,#wk@,#@,"wkQ@,!@, n@,|hs@,;dZ@,"@,H˒@,Q@,1'@,JE@,Ϫ͟@,!R@,fA@,Ʌoi@,j~@,zG@,SMj@,9XbN@,S&@,
(@,@,v@,}Vl@,.2@,
8Y@,
5Xy>@,C@,L_@,
n@,	B@,>BZc@,&@,)^@,'@,$/@,oiDg@,O
@,Q@,e@,o h@,A [@,@4@,M@,ae@, ҈p@, n@, NU@, 6@+U=@+b}V@+;dZ@+H˒:@+!-w1@+@+.H@+b}V@+@+쿱[W@+!-w1@+Ft@+vȴ9X@+@+5?|@+ ѷY@+u@+Ov_خ@+u@+ڹZ@+ce@+p
=@+ڹZ@+ڹZ@+/w@+lC@+J#9@+=K^@+ݘ@+)y@+(@+JE@+F@+)@+-
@+YJ@+F]d@+&@++@++j@++j@++j@+&@+sPH@+>6z@+8YJ@+2a|@+ߤ@+Z@+nO@+H@+@++@+hr!@+@+D@+ԕ*@+7KƧ@+@+rGE@+Xy=@+	ԕ+@+fA@+E84@+,@+唯O
@+䎊qj@+M:@+tj@+㕁$@+eO@+n.3@+S&@+ⶮ}Vm@+s@+:S@+$/@+"@+҈p;@+Ov_خ@+!.H@+ڬ>B@+u%F@+u%F@+1'@+Y}@+#w@+e+@+e+@+حU@+@++j@++@+@+!.@+Ϫ͞@+L_@+fA@+?|h@+E@+!-w2@+m@+nO@+䎊@+iB@+N;5@+hr @+[W>6@+`A7@+bM@+-
q@+U2a|@+Ϫ͞@+1@+t@+α2X@+Vu@+H@+\@+:@+>B[@+̲@+̿[W?@+C]@+xF]@+6z@+͞&@+7KƧ@+K]c@+	ԕ+@+ǻ/V@+lC@+Ǡ	k@+,@++I@++I@+]cf@+ƚ,<@+Ƨ-@+ƀIQ@+YJ@+8YK@+Q@+7@+%2@+C,@+Zc@+'R@+ae@+     @+[W>@+m\@+>@+)y@+&@+D@+<64@+iDg8@+t@+@+@+%@+@+y@+ԕ*@+?@+%1@+M@+Q@+Xe,@+@+D@+@+@+҉@+a|Q@+m\@+m\@+䎊q@+m@+ ě@+S&@+҉@+{m@+!R<@+cA \@+a@@+L_@+"h	ԕ@+jf@+0U2a|@+P{@+W'@+-@+o h@+S@+wk@+	@+S&@+ ѷ@+@+}Vm@+4m@+~$t@+~($x@+~
(@+~
(@+}p
=@+}ڹZ@+}}H@+}b@+~ ѷY@+}-V@+|wkP@+|]ce@+|?@+{m]@+{qu!@+{"`B@+zc	@+yD@+y	k~@+xYJ@+w4m@+v!.I@+v_ح@+t#@+t#@+tO
M@+tm8@+t֡a@+tm8@+sݗ+k@+s@+sa@O@+t@+s@+s҉@+sMjO@+s@N@+rnO@+q&x@+p`A7@+q4J@+q[W>6@+p@+o\(@+m\@+iy@+dZ1@+d%1@+dZ1@+dxF@+bh	ԕ@+_?@+\]ce@+ZG{@+ZG{@+Z)_@+Zc	@+ZG{@+Z6C@+XF]d@+W4m@+Xl"h	@+]H˒                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @C:n@C;5Xy@CC$@CC6z@C?+I@C<g8}@C;:)z@C?'/W@C>+jg@C=cA @C<[W?@C=Ϫ͞@C>af@C<hr@C?!-w1@C@$tT@CAA [@CB)_@CCg@CD[W?@CE%@CE!.@CFz@CGb}V@CHeO@CI [7@CI	k~@CIrGE8@CIN;6@CIlD@CJ@4n@CJC,@CJ䎊q@CKjf@CLL_@CLM:@CL`d@CL1&@CM*0@CMjOv@CMS@CNiB@CN,<@COH˒:@CP     @CP$xG@CP-
@CQl@CRS&@CRD@CSMjO@CSS@CSMjO@CSF]c@CS9@CS)^	@CSS&@CR䎊q@CR)_@CRwkQ@CR\(@CRW'@CRJL@CRd7@CRW'@CRGE85@CR0U2a|@CR&IR@CR1'@CRe+@CR&IR@CR:)y@CRT`d@CRS&@CR74@CS҉@CS$@CTxF@CT%1@CTC,zx@CT~($x@CTZ@CU2a|@CU2a|@CU\(@CVOv_@CV8YJ@CVOv_@CV5?|@CVE@CVE@CVE@CV_ح@CVaf@CV+@CW&@CX*0U@CX:~ @CXD*@CXH@CXD*@CX[6@CXbM@CX@CX4m@CXTɅ@CX$tT@CY_p@CY@N@CY@N@CY+@CXPH@CXe+@CXѷX@CX	k@CY4J@CYTɅo@CY[W>6@CYXbM@CYXbM@CY[W>6@CYe+a@CYo hی@CY@CYb}@CYb}@CYn.@CYiB@CY@CYy@CYX@CY'R@CY(@CYR<6@CYo@CY@CY|Q@CY@CY@CY@CYl@CY"`@CYX@CYX@CYB@CYl@CY'RTa@CYu@CY@CYb}@CYk~(@CY4J@CY@CYrGE@CY [7@CYA [@CY@N@CX	k@CXD@CX)^@CX)^@CXD@CXF@CXěT@CX-
@CXl"h	@CXbM@CXoiDg8@CXr Ĝ@CXU2a|@CXU2a|@CXU2a|@CXXy=@CXQ@CX>BZc@CX>BZc@CX1&x@CX*0@CX$xG@CX4m9@CX4m9@CX73@CX:~ @CX4m9@CX-
q@CX*0@CX:~ @CXD*@CX>BZc@CW@CXF]d@CX-
q@CX ě@CX*0U@CX
qu@CXF]d@CX@CXF]d@CX     @CW䎊r@CWrG@CW@@CW;dZ@CW@@CW-@CWVϫ@CW-@CW䎊r@CX@CX-
q@CX>BZc@CXD*@CXXy=@CXl"h	@CX˒:*@CX-
@CX-
@CX{@CX
(@CXD@CXC@CX	k@CY$/@CY*0U2a@CYGz@CYTɅo@CY^@CYhr @CYhr @CYhr @CYo hی@CY|Q@CYoiD@CYu@CYn.@CY^5?}@CY2W@CYiB@CYR@CY-@CY.H@CZI^5@CZe+@CZ:)y@CZM@CZa|Q@CZh	ԕ@CZqiC@CZ{m@CZ@4@CZ\(@CZ}Vm@CZ)_@CZG{@CZ~@C[W>6z@C[~$@C[q@C[:)z@C[$@C[A@C[wk@C[S@C[m]@C[m]@C[
=p@C[g@C\"h	ԕ@C\Fs@C\I^5?@C\M:@C\I^5?@C\Fs@C\M:@C\Z1@C\]ce@C\g8}@C\tSM@C\j~#@C\cA \@C\cA \@C\g8}@C\cA \@C\wkP@C\~($x@C\C@C\C@C\N;@C\j~@C\@C\*0@C\Z@C\u"@C\Z@C\@C\@C\>@C]K]@C]'0@C]*0@C][@C]*0@C]*0@C][@C]*0@C][@C]*0@C][@C][@C][@C]u@C]V@C]Q@C]%F
L@C]%F
L@C]%F
L@C]+a@C]/w@C]+a@C]+a@C]/w@C]+a@C]+a@C]/w@C]+a@C]+a@C]5Xy>@C]5Xy>@C]5Xy>@C]84֡@C]<64@C]5Xy>@C]/w@C]+a@C](@C]Q@C]qu"@C][@C]u@C][@C]u@C]V@C]'0@C]'0@C]'0@C]:@C\E@C\e@C\E@C\>@C\>@C\!-w@C\JM@C\/@C\>B[@C\*0@C\@C\?@C\7@C\j~@C\#x@C\?@C\@C\3@C\*1@C\C@C\o h@C\~($x@C\wkP@C\q@C\j~#@C\g8}@C\]ce@C\VϪ@C\M:@C\?@C\<쿱@C\2W@C\2W@C\/{J#@C\(\@C\"h	ԕ@C\"h	ԕ@C\!-w2@C\Q@C\L_@C\xF@C\J@C\n.@C[@C[@C[$@C[A [@C[C]@C[g@C[g@C[lC@C[g@C[%2@C[%2@C[҈@C[҈@C[ݗ+k@C[҈@C[ݗ+k@C[ݗ+k@C[Q@C[a@@C[a@@C[a@@C[Q@C[
=p@C[5Xy@C[a@@C[5Xy@C[|@C[a@@C[a@@C[@C[a@O@C[6@C[~($@C[m]@C[q@C[*0U2@C[S@C[S@C[wk@C[wk@C[ߤ@C[A@C[$@C[A@C[$@C[$@C[:)z@C[Mj@C[q@C[Q@C[{J#9@C[qu!@C[n.3@C[a@N@C[P{@C[J#9@C[C%@C[6z@C[/V@C[PH@C[҉@C[҉@C[I^@C[I^@CZm\@CZ74@CZ74@CZc	@CZc	@CZ ѷ@CZsP@CZ,<@CZ`A@CZW@CZ)_@CZ)_@CZn@CZn@CZ}Vm@CZ>B@CZ@CZ\(@CZL_@CZp:@CZu%F
@CZa|Q@CZZc@CZW'@CZW'@CZW'@CZJL@CZM@CZJL@CZC\@CZ@4n@CZ@4n@CZ@4n@CZ3@CZ)y@CZ)y@CZ&IR@CZ&IR@CZ#9@CZ䎊@CZOv`@CZn@CY.H@CY.H@CY-@CYY}@CYs@CY@CYR@CYᰉ'@CYᰉ'@CYiB@CY@CY_o@CY_o@CY_o@CYy@CYy@CY^5?}@CY|@CYB@CY'R@CY|@CY'RTa@CYu@CY@CY@CY@CYu!S@CYrGE8@CYhr @CYae@CY^@CY^@CY^@CY[W>6@CY[W>6@CYQ@CYQ@CYQ@CYJE@CYDg8~@CY=b@CY4J@CY*0U2a@CY_p@CY+@CY	k~@CY$/@CXC@CX@CXD@CX)^@CXIQ@CXNU@CX73@CX>BZc@CX}H@CX
qu@CXF]d@CW#@CWrGE9@CW@CWo @CW@CW$tS@CWy@CWXe,@CWFt@CV҈p;@CVQ@CV-@CVFs@CV@CV%@CV}Vl@CVIQ@CVIQ@CVz@CVz@CVs@CVs@CVs@CVl!-@CV.2@CVu@CV@CV
(@CV4K@CVt@CUE@CVt@CUᰉ@CU\(@CU%@CU!R@CUhr!@CUڹZ@CUM:@CU}H@CU}H@CUzxl"h@CUY|@CUB@CU5Xy>@CU5Xy>@CU2a|@CU+a@CU%F
L@CU!.H@CU+a@CU+a@CU(@CU[@CUu@CU[@CUK]@CUo i@CTE@CT!-w@CTu"@CT>B[@CT֡a@CT7@CT#x@CTO
M@CT_@CT*1@CTN;@CTN;@CT*1@CTqj@CTo h@CT~($x@CTo h@CTo h@CTwkP@CTtSM@CTtSM@CTtSM@CTcA \@CTVϪ@CTPH@CTSMj@CTSMj@CT<쿱@CT64@CTxF@CS҈@CSߤ@CSA@CS$@CSeO@CStj~@CSF]c@CS"`B@CS҉@CSS&@CSI^@CSS&@CRm\@CRm@CR`A@CRW@CR`A@CSnP                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @jkP|@k͜u@liB@q@q.H@q)E84@qMY|@q*0U2@q5?|@q@N@qo@qiB@q$t@q[W?@q?!-w1@qEb@qL'@q6=K^@pz@p)^@p74@pW>6z@pe+@p BZc @niB@m@mmu!S@m쿱[@lߤ?@l0U2a|@l<hr@k-
@kTA@j?@js+j@jVcA \@j:O;@iae@iqv@he+a@h+a@g|D@gߤ?@f-
q@fA7K@f$/@g%O;dZ@gccA @g~,<@g{b}V@gqwk@gc^5?}@g\@@g\m\@gW6z@g\7@gp3@gt[6@ge@N@gYE@gTc	@gTbM@g>$/@gL_o @gN͞&@gP1&x@gYᰉ@g[MjO@gJ3@g<j~@g7-w1@g?@g?4m@g)B@g%[@gwk@gn@g
d8@g
p
=@gSMj@f	@f@fY|@fsP@fH@f     @f񙙙@fB@f4J@f	 @fO;dZ@f^5?|@f+@f߅oiD@f!.@fs@fZ@fzxl"@f"@fK]@fݗ@fFs@fL/{J@f!-w2@fIQ@f@f҈p;@fn.3@f@f4֡a@f(@fQ_@f?@fM:@f<쿱@fn/@fe@frGE8@f+I@fu@fᰉ'@fc	@fzG@fm]@fT@f|n@f~!R<@f<64@f;dZ@fH@f4m@f~1'@f
M;@fy@fw&x@fBZc @f@fp3@f@4n@f_o@fn@fi=K^@fp-
q@fp-V@fsP@f-
@fsg@f{IQ@fw	@feO@f8YK@f~"@fa|Q@f@f2W@fC@fm8@f^@fBZc @fTɅ@f$xG@fO
M@f-@f1&x@fS&@fv_ح@ft@ffB@f䎊@fj~@feO@fbM@f%@fU=@fZ@f hۋ@f hۋ@fԕ*@fS@f4m@fS@fC@fRT`e@f?@fo hی@fn.3@f	ԕ+@fL/{@fp:@f"h	ԕ@fe@fw$/@f"h	ԕ@faf@fFs@f@f)^@fZ@f'RTa@fXy=@fحV@f-
q@f	@fu%F@fIQ@f|qj@f}s@f|qj@f}A [@fn@f_ae@f`m\@fY@fK-@fGa@O@fC+j@fC+j@fNg	@f>1&y@f%K]@f-\@f'_o@fL_@fvȴ9@fJ@ft@fnP@fb@f:)z@fYJ@fnP@e<쿱@eXe,@e@e;5X@etSM@e@e,@e㹌~($@e ѷY@eѫU=@ecA \@eMj@ece@e@@e@e~"@eSMj@ev@eX@e7KƧ@eE@eᰉ'@eDg8~@esh@es5Xy>@ex7@e3@e{m@e~PH@e*0@elC@e|@eiB@e"@eA [@eq+@ea#w@eS?|h@e\e@eeL_@e[ݗ+@e^Z1@eZ/{J#@eO@N@eVJ@eVt@ePu!@eM1@eTvȴ@eXɅoi@ePtSM@eJ1@eQ
=p@eOrGE@eJ`A7@eH}H@eC䎊r@e>cA \@e7rGE8@eEU=@eMl@eFQ@e;ߤ@eB@eS8}H@eQa@@eHu@eHu@eA(@e4TɆ@e(($x@e8҈p;@e8҈p;@e<~@e;+j@e6	 @e8A@e:2W@eEO
M@e>]ce@e*C@e&TɅ@e:1.@eEN;5@e>\N<@e7jOv@e4S&@e4S&@e0xl"h
@e:1&x@eMwk@e;O
@e/[@e;O
@e8͞&@e>Zc@eCrG@e1"`@e%[W>6@e*@e1Q@e4af@e8)^@e6t@e3<64@e/u@e0u%F
@e0u%F
@e*@e/)^@e#$@e)@e7eں@e;@e6n.@e#E@e%Vl!@e-͞@e!+I@eߤ@@e&Q@e%S@e73@eE@e@eA@e!&x@e5?|@e_ح@eѷX@eA@e
L/@em\@e3@e
|@eXe@eXe@e%1@e&I@eݗ+k@eT@e1&y@e
=q@e@N@d?@dg@dFt@d_o@ewkP@e@e-@eߤ?@e>6z@ewkP@eFs@dcA @dhۋq@e	M:@e	M:@e+j@d	k@d?@d>B[@dh	ԕ@dO
M@d˒:)@e
zH@eD@eD@e ě@eS&@d	k@d>B[@d	k@do@d+@do@eحV@eu@eXe,@dg8}@eY}@eXbM@e@e!-w2@e@e;dZ@e@erGE@es@erGE@e
q@e	$/@eY@e䎊r@e}H@eY@e}H@e
䎊q@e
͞@e'/@e䎊r@e}H@eqiC@e
͞@eGE85@eqiC@e
͞@eq@e,<@e@ep:~@e҉@eR<6@e"|@e0
@enO@e	@e&L/{@e**0@eQ_@e_@e%1@e%1@ePH@e|@e&I@e@e!+@e-$@e5g@e3#w@e)jf@e-V@e-V@e*p:@e1H˒@e*͞&@e5ᰉ@e(@eM@e[W>@e-ݗ+@e:s@e7KƧ@e)hr @e#Q@e!R<@e@e0Z1@e;u!S@e><쿱@e3 [7@e7JE@e?'RTa@e><쿱@e;tj~@eE-w1@eL!-w2@e4n@e7J#9@eN`A7@eJ)@e7IQ@eC@eTr Ĝ@eGE@eIVl!@eTr Ĝ@eM$/@eIVl!@eL}H@eN䎊q@eL}H@eA:@eA:@eNZ@ePGE85@eQ͞@eL1'@eJ#x@eL1'@ePGE85@eM4m@eGs@eL1'@e[b}V@eY.H@eW8}H@eUԕ*@eS
M;@eX,<@e\m\@e[ae@eNC-@eQ*0U2@eQ*0U2@eW7KƧ@e^(\@eev@eS@eIS@eJ4m@eX,<@eY\N@e_~($@ef}Vl@e[a@N@eU@eXu%F@ecE@ee_p@enѷX@ebR<6@el
L/@eiB@et]ce@euD@eiAs@e~L_@eFt@e|2X@e|2X@e~L_@e|2X@e|2X@eyg@eۋq
@eZ@ew1@e~s@eo@eXe,@eg8}@eI^5?@eXbM@e<쿱@e ѷ@eXbM@e@eN;@e.H@eg8}@eo@e{J#:@eXbM@efffff@e;5X@e)@erGE@e`A7@eW>6z@e@e@e@e~($@e}H@e}H@eVl!@e'/@edZ@eU=@e:@eY@e8YK@e     @e͞@e#x@e#x@e*0@e)_@eU=@e4m@eU=@e+I@e4m@em@efA@e1'@eԕ*@e@e@@eqiC@eq@e.H@e)y@e)y@eTɆ@eZ@e@e6C@eZ@ev@eae@eS@ea@@e~($@eTɆ@ev@eX@em\@em\@eE84@e~($@e@e~($@eE84@e~($x@e4֡b@em\@e4֡b@eP{@e_F@e
qv@ea@O@e9Xb@e9Xb@ezxl"@eAs@eg	@e33333@eǥv@eg	@eǥv@e ѷ@ekP|@eu%@e&                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ?l?*0U?iB?9D?-?qiC?;dZ?*0
?|Q?S&?s?%1?ƚ,<?Ʈ}Vl?˶E?lC?Fs?xl"h	?-V?]cA ?L/{J#?t?Z?4m9?D?#?(?Vu?9XbM?Z?C?,=?IQ?TɆ?ᰉ'?.H?C,z@RT`d@
ߤ@@	fA@ɺ^5?}@I@ o?$tS?u?A7Kƨ?fA?e+?\N<?L/{J#???xF]d?҈p;?,?+?MjO?qu!S?~"?B?VϪ͟?Ќ?π4m9?iB?Q?`A7?L/{J#???D?d7?}Vl!?v_ح?H?m\?fA?`A7K?wkQ?@N?ѷX?A7Kƨ?QR?*0?q?
(?ѷX?u%F
L?}H˒??|hs?+J?zG{?
(?C\N?+j?rGE85?-w1?PH?A [?
=p?z?6C-?ݗ?-
?*0U2a?!-w1?Z?R<64?
=p
?6?>6z?W>6z?Ϫ͞??|hs?a@N?y_o ?wXe+?tj~?eL_?ye+a?:)y?*0U2a?S&?*0U2a?*0U2a?sg?tZ?qu"?Ov_ح?*0U2a?g?@?qu!S?ku%F?bn/?qu"?kQ_?*0U2?:)y`bM?o䎊q?fOv_خw?p:?$tSM?wXe+?Q?O
M?hr Ĝ?S&?bMku%F~QV?0
(`bMp)^	?rn/?bM?$/?Q_?zG{?3*0U2a?hr Ĝ?},<?N;5X?쿱[W??m}H˒?s@NU?$/?a@N?u%?tzG{?v?6C-?},<wm}H˒?e+a?L_?fA?4J?~Q?`A7L?+I?M}H˒usg]}H˒?xtj~?u%?Xe?fOv_خ?_Ft??dzG{uL_m}H˒?rsPH?vOv_خ?tn?usgZ6C-?wXe+?{u%F?y_o ?{u%F?}}H˒?}Z?Q_?PbM?`bM?{Q_?}}H˒?	 ?4J??l?z6C-?}Z?u%?Fsrn/?w?zvȴ9?xtj~?n/?R<64?Ϫ͞?U=K?-
qv?|1&y?}Zc*0U2a?!-w1?Ϫ͞?fA?Z?_Ft?|C,zxll1&yv+Ip)^	M}H˒?y_o ?|1&y?~Q?}}H˒?4J?u"?ie+atnbn/?xtj~PbM?u%rnO;{Q_?}}H˒?ǿF?c*0U2a?*0U2a?|C,zxl?Z?qu!S?|C,zxl??xPH?]}H˒?fA?ᰉ'?fA?$/?-
qv?@c*0U2a?wnOv_حxtj~:6C-?Xe+?>6z?2a|Q?e+a?wkP?bsPH_!-w1?!-w1?䎊q?u"?$tS?bM?{qu!S?䎊q?	 ?usg?N;5?+I?vȴ9X?IQ?rsPH?!-w1ſrsPHkQ_@bM?w?},<?{u%FgtZ?u%?*0?w?[Q_?|C,zxlie+a?m}H˒?$tSM?=K]̿eL_?=K]?=K^?O
M?sg?-
qv:6C-?l1&y?!-w1?|C,zxl?s*0U2a?z6C-?C*0U2a?&?u"?:)y??p)^	?)^	?sg?$tSM?!-w1?S&?[Q_?|1&y?xtj~?x*0
?L_?l        ?-VF?tZm}H˒?N;5?=K^?l?!-w1?6C-*6C-?IQ?$/?PbM?o!-w1ſS*0U2a?O;dZ?ᰉ'?p:?|C,zxl?Rn/?v?@NU@bM?zG{[Q_[Q_?y_o ie+akQ_?e+a??~Ov_ح?{Q_?fǿvOv_خ@bM?},<?u"?L_?ߤ??Rn/?n/?{qu!S?j6C-usg?o!-w1?|1&y?}Z?N;5?p)^	o䎊q?eL_?|C,zxl??hr Ĝ?{qu!Sie+a?!-w1?L_?$/?`d8?Xe+Կ:6C-?eL_tzG{ie+arn/ku%F?tn6C-?`d8?$/?ye+a?v?tn?ZC*0U2a?|1&y?qu"vOv_خye+atzG{?_Ft?=K^?tj~?A?{Q_?S?҈?PbM?bM?u%F
?vȴ9X?~Q?o䎊q?tn?ku%F?pbM?qu!S?o䎊q?{qu!S?$tS?O
M?`d8?Fs?6C-?sg?$/?$/?L_?s*0U2a?z6C-htj~uL_rn/?bsPH?q4J?*0U2a?Xe?{u%Fl1&yusgpbM?tzG{?nf?n/?1&y?Ov_خ?*0?"`A?IQ?xtj~?-
qv?~Ov_ح?bM?O;dZ?䎊q?,<쿱?$/?{qu!S?	 ?pbM?䎊q?䎊q?n/?tj~?~Ov_ح?}Z?4J?<646C-htj~?uL_ku%Fy_o ?N;5X?&htj~?Xtj~?Xtj~?n/?C*0U2abMkP{wo!-w1?p:?n/?tZ?_!-w1ſ|C,zxl?+jg?ku%FvOv_خuL_        ?l1&y??$/o!-w1?ie+a?ye+a?uL_?*0?+I?IQ?,<l1&y?)^	S*0U2a?Q_?3*0U2a?*0U2?tj~?n?!-w1?$tS?`bM?䎊q?|1&y?Z6C-?zvȴ9?o!-w1?n?s@NU?eL_[Q_??v?ߤ?PbMeL_?fǿy_o ?v?E?Fs?zvȴ9?:)y?L_PbM?zG{?u%?Zݘ?M}H˒?s*0U2a?v+I        tn?Fs?ku%F?@bM?v?-
qv?wkPM}H˒?`bM?y_o ?xtj~?J6C-:6C-bn/?l1&y?v+I?o䎊q?S*0U2a?y_o ku%Fvǿ]}H˒?}}H˒?sPH?ɅoiD?䎊q?C*0U2aq4J?!-w1?}}H˒?$tS?ye+a?s*0U2aF?O;dZ?,<쿱?PbM?xtj~?*0?Ov_خ?ᰉ'?zG{?ye+a?C,zxl?0
(?y_o ?*0
?䎊r?},<{qu!S?wXe+?O;dZ?-
qv?tZZ6C-?kQ_?m}H˒dzG{C*0U2a?}Z?$tS?}Z?y_o ?p:?)^	?tzG{j6C-?PbM?x*0
?@NU?Fs?v+IwXe+?C*0U2a?fA?ᰉ'?Ϫ͞?vȴ9?u%F?!-w1?{Q_?>6z?*0U2N;5                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ??????????????ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə???????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   &	B&ffA!G35  12                                      1                                       