CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20170205   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P15    CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:34.977494Z    ORIGINAL_HEADER      6CTD,20250210CCHSIOWB
#Removed 'CTDFLUOR_TSG' as it's filled with -999
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2017-06-29. CTD data from cruise 18DD20170205, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20170205. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2017-001/index.php. 
#
# The information in this file for the cruise 2017-001 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-0036.ctd
#
# Start of originator file comment header
#
#*2017/06/29 15:26:50.02
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2017/02/10 06:17:38.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 198
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : CE9F1F72
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            0.3            202.1
#       2 Temperature:CTD               deg_C_(ITS90)   5.6248         6.8697
#       3 Salinity:CTD                  PSS-78          32.78          33.8432
#       4 Sigma-t:CTD                   kg/m^3          25.7461        26.7106
#       5 Oxygen:Dissolved:CTD:Volume   ml/l            3.4            6.87
#       6 Oxygen:Dissolved:CTD:Mass     µmol/kg         147.7          299
#       7 Fluorescence:CTD:Seapoint     mg/m^3          0.66E-01       1.162
#       8 PAR:CTD                       µE/m^2/sec      0              0.3
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        7  F       ' '     2
#       6  -99   ' '        6  F       ' '     1
#       7  -99   ' '        8  F       ' '     3
#       8  -99   ' '        7  F       ' '     1
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2017-001
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P21
#    EVENT NUMBER        : 36
#    LATITUDE            :  49  38.00000 N  ! (deg min)
#    LONGITUDE           : 139  39.97000 W  ! (deg min)
#    WATER DEPTH         : 3961
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    The descent rate of the CTD was very noisy with some complete reversals
#	of direction.
#    CTDEDIT was used to remove many records corrupted by shed wakes;
#	salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Fluorescence and PAR data are nominal and unedited except that some records were
#	removed in editing temperature and salinity and a large spike in
#	fluorescence was removed from file 0032.
#
#    The Transmissivity channel was removed because of frequent shifts in values during
#	casts and large variations between values during repeat casts.
#	The data are available, by request, from the chief scientist.
#
#    NOTE: While the Fluorescence:CTD data are expressed in concentration units, they
#	do not always compare well to extracted chlorophyll samples, particularly for
#	casts far from shore. It is recommended that users check extracted chlorophyll
#	values where available.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in Sea-Bird
#	Application Note #64-2, June 2012 revision (Sea-Bird_64-2_Jun2012.pdf), except 
#	that a small offset in the fit was allowed.
#
#    The Dissolved Oxygen sensor used in files 0001, 0002 and 0016 malfunctioned so the 
#	Oxygen:Dissolved:CTD channels were removed from those files.
#
#    The Oxygen:Dissolved:CTD sensor has a fairly long response time so data accuracy 
#	is not as high when it is in motion as it is during stops for bottles. This will be
#	especially true when vertical dissolved oxygen gradients are large. To get an estimate
#	of the accuracy of the Oxygen:Dissolved:CTD data during downcasts (after recalibration)
#	a rough comparison was made between downcast Oxygen:Dissolved:CTD data and upcast 
#	titrated samples. Some of the difference will be due to problems with flushing of 
#	Niskin bottles and/or analysis errors, so the following statement likely underestimates 
#	Oxygen:Dissolved:CTD accuracy.
#
#    Downcast (CTD files) Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.25 ml/l from 0 to 125 dbar.
#	±0.2 ml/l from 125 to 400 dbar.
#	±0.1 ml/l from 400 to 600 dbar.
#	±0.05 ml/l from 600 to 1500 dbar.
#	Low by up to 0.08 ml/l below 1500 dbar.
#
#    For details on the processing see document: 2017-001-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5--- --6-- ---7--- --8---
#!Pressu Temperat Salinity Sigma-t: Oxygen Oxyge Fluores PAR:  
#!re:CTD ure:CTD  :CTD     CTD      :Disso n:Dis cence:  CTD   
#!                                  lved:  solve CTD:          
#!                                  CTD:   d:CTD Seapoin       
#!                                  Volume :Mass t             
#!------ -------- -------- -------- ------ ----- ------- ------
#*END OF HEADER
     WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @R         data_max      @R         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     <`  2   pressure                	long_name         pressure   positive      down   units         decibar    data_min      ?ə   data_max      @   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      <`  oD   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d           temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ? ě   data_max      @*0   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       <`     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d           salinity                	long_name         salinity   units         PSS-78     data_min      @@Fȴ9X   data_max      @AKg   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      <` 4   salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d       B   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @(   data_max      @r   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        <` Q   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d          CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?(\)   data_max      ?lC   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      <` $   CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d       ل   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min                 data_max      ?   C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       <`    PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d       $   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min               data_max               C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     <` 4   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d       pt   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         (    cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         (    time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      )   data_max      )   C_format      %10d          latitude               	long_name         latitude   units         	degrees_N      data_min      @Hl   data_max      @Hl   C_format      %9.4f             	longitude                  	long_name         	longitude      units         	degrees_E      data_min      `X%[\   data_max      `X%[\   C_format      %9.4f             	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d           	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min        =   data_max        =   C_format      %4d        @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      ?ə?      @ @333333@ffffff@ffffff@      @      @       @"333333@#@&      @(      @*      @,      @.      @0      @0@1     @4@5      @6      @7      @8      @9      @:@;      @;fffff@=      @>      @?      @@      @@@A&fffff@As33333@B      @B     @C      @C@D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @Mٙ@N     @O      @O     @P      @P@     @P     @P     @Qfffff@Q@     @Q     @Q@Rfffff@R&fffff@R     @R     @S      @S@     @S     @S     @T      @T&fffff@T     @T     @U      @U@     @U     @U     @V@V@     @V     @V     @Wfffff@WS33333@W     @W     @X      @X@     @X     @X     @Y      @Y@     @Ys33333@Yfffff@Z      @Z@     @Z     @Z     @[      @[@     @[     @[@\      @\@     @\     @\fffff@]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @bfffff@b      @b@     @b`     @b     @b     @b     @b     @c      @c@cL@c`     @c     @cfffff@c@c     @d      @d      @d@     @d`     @d     @d33333@d33333@d     @e33333@e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f\@f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h|@h     @h@h     @i      @i      @i6fffff@iffffff@i     @i33333@i@i     @j      @j      @j@     @jVfffff@j@j     @j     @j     @k      @k      @kC33333@k`     @k     @k@k33333@k     @l      @l      @l@     @lY@l     @l     @l     @l     @m33333@m      @m@     @m`     @m     @m     @m     @m     @n      @n@nL@n`     @n|@n@n     @n@o33333@o      @o9@oc33333@o|@o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p|@p@p     @p     @p     @p     @p     @p     @p     @q33333@q      @q0     @q@     @qP     @q`     @qp     @q~fffff@qfffff@qfffff@q     @q     @q     @q     @qfffff@q33333@r     @r     @r0     @r@     @rP     @r`     @rnfffff@r@r     @r     @rfffff@r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s@s     @s     @s     @s     @s񙙙@sfffff@tfffff@t      @t0     @t@     @t`     @tp     @ty@t     @t     @t     @t     @t     @t     @t33333@u     @u@u      @u0     @u@     @uP     @uX     @uvfffff@u     @u     @u     @u     @u@u@u     @u     @v      @v     @vfffff@vC33333@vP     @v`     @vp     @v     @v     @v     @v@vfffff@v     @v     @v陙@w33333@w     @w      @w1@wH     @wNfffff@wp     @w@wfffff@w     @w     @w     @w     @w     @w     @x      @xfffff@x1@x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y@y     @y     @z      @z     @z      @z0     @zS33333@z\@zs33333@z     @z     @z     @z     @z     @zљ@zᙙ@z     @{      @{     @{      @{0     @{@     @{P     @{[33333@{p     @{     @{     @{     @{     @{fffff@{@{     @|      @|     @|      @|0     @|@     @|Nfffff@|ffffff@|p     @|     @|     @|     @|     @|     @|     @|fffff@|@}      @}     @}      @}0     @}@     @}P     @}a@}i@}@}     @}     @}     @}     @}     @}     @}     @~@~     @~!@~0     @~>fffff@~P     @~`     @~p     @~     @~     @~     @~     @~@~fffff@~     @~     @      @     @      @0     @@     @Nfffff@s33333@     @     @     @     @     @     @@      @     @     @     @      @(     @0     @@@H     @P     @X     @^fffff@h     @zfffff@33333@     @     @     @     @     @@     @@     @     @     @     @     @     @      @     @@@      @(     @0     @8     @@     @H     @P     @W33333@`@h     @p     @x     @     @     @     @     @@     @     @     @     @     @     @     @@     @     @     @      @	@     @     @      @(     @-@8@@     @H     @P     @a@h     @p     @x     @~fffff@33333@     @     @     @     @     @     @     @     @@     @     @     @     @     @      @     @     @      @(     @0     @8     @@     @H     @O33333@h     @p     @x     @     @     @     @     @@@     @     @     @     @     @     @33333@陙@     @     @      @     @     @     @      @(     @/33333@8@@     @H     @P     @X     @`     @h     @p     @u@|@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @33333@     @     @      @(     @333333@8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @fffff@     @     @     @     @ř@fffff@     @     @     @     @33333@33333@	@     @     @      @(     @0     @5@@     @H     @P     @X     @`     @h     @p     @u@@     @     @     @     @     @     @@     @     @     @     @     @     @33333@      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @m@x     @     @     @     @     @fffff@     @     @     @     @     @@     @     @     @     @      @     @     @     @33333@+33333@0     @8     @@     @H     @P     @X     @\     @h     @p     @x     @     @     @@     @     @     @     @     @     @ř@љ@     @33333@@     @     @      @     @33333@     @      @(     @0     @8     @@     @H     @P     @Vfffff@d     @h     @p     @x     @     @     @     @     @     @     @@     @     @     @     @     @     @     @33333@ @     @fffff@@      @(     @0     @8     @@     @E@T     @X     @`     @h     @p     @vfffff@@     @     @     @     @     @@     @     @     @     @fffff@     @     @     @      @     @@@$     @(     @0     @733333@I@P     @X     @`     @h     @m@zfffff@     @     @     @     @     @     @33333@@     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @=@H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @@     @     @     @     @     @fffff@     @     @     @@     @     @33333@(@0     @8     @@     @H     @L@Zfffff@`     @h     @p     @x     @}@@@     @@fffff@     @     @     @     @     @     @     @fffff@@      @     @     @     @      @(     @0     @8     @>fffff@K33333@P     @U@a@h     @p     @x     @33333@     @     @     @     @@     @@     @     @     @     @     @     @     @     @      @     @     @     @33333@2fffff@8     @@     @H     @P     @X     @`     @h     @p     @x     @~fffff@     @     @     @     @     @@33333@fffff@@     @     @     @     @fffff@     @      @     @     @     @     @     @     @@      @$     @(     @+33333@133333@4     @8     @=33333@@     @D     @H     @K@Q@T     @X     @\     @`     @d     @h     @l     @pfffff@t     @x     @|     @@     @     @     @     @     @     @fffff@     @     @     @     @     @@     @     @     @     @33333@@     @     @     @     @     @󙙙@33333@     @      @     @fffff@     @     @     @     @     @      @$     @(     @,     @0     @5@8     @<     @@     @D     @H     @L     @N     @T@X     @\     @`     @d     @h     @m33333@p     @t     @w@@     @     @     @     @     @     @     @@     @     @     @     @33333@     @     @     @     @     @33333@@@     @     @     @     @     @33333@@     @      @     @33333@fffff@     @     @@     @      @$     @(     @,     @0     @4     @8     @;33333@D@H     @L     @O@T     @X     @[@a33333@bfffff@l     @p     @t     @x     @|     @     @     @@fffff@     @     @     @@@     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @33333@33333@     @     @     @     @     @@@     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @;@@     @D     @H     @L     @O@Xfffff@\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @33333@     @@     @     @     @     @     @33333@fffff@     @     @     @     @     @fffff@33333@     @     @     @     @     @     @     @      @     @	@@     @     @     @     @%@(     @+33333@0@4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @{@fffff@     @     @     @     @     @33333@@     @     @@     @33333@33333@     @     @     @     @     @     @     @     @ۙ@fffff@     @     @     @     @     @      @@     @     @     @     @     @     @      @$     @(     @,     @0     @4     @6@<fffff@@     @D     @H     @K@P     @T     @V@\fffff@`     @d     @h     @l     @nfffff@t@w@33333@     @     @@     @     @     @     @     @     @     @@     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @     @@     @     @     @      @     @     @     @33333@@     @      @$     @(     @,     @0     @4     @6fffff@<@@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @k@t@x     @|     @~@fffff@     @     @     @     @@     @33333@@     @fffff@@     @     @     @@@     @     @     @     @@     @     @     @     @fffff@     @     @      @@	33333@     @     @     @     @     @      @$     @'33333@0@4     @8fffff@;@@     @D     @H     @L     @P     @T     @X     @\     @`     @dfffff@f     @n     @p     @t     @x     @|     @     @     @     @     @     @fffff@33333@     @     @     @     @     @     @33333@@     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @      @fffff@fffff@
@     @     @@      @$     @(     @,     @0     @2@933333@<     @@     @D     @H     @Lfffff@Xfffff@\     @`     @d     @p     @t     @x     @|     @~     @fffff@33333@     @     @     @     @     @33333@     @     @     @     @     @     @fffff@@     @     @fffff@     @     @     @     @     @     @     @33333@fffff@      @     @     @     @     @     @     @      @$     @-33333@0     @4     @=@@     @D     @H     @L     @U33333@X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @33333@@     @     @     @     @     @     @@     @     @     @@33333@     @     @fffff@fffff@     @     @     @     @     @     @fffff@     @     @     @     @      @33333@     @     @     @     @     @33333@      @$     @(     @,     @0     @4     @6     @<fffff@@     @D     @H     @L     @Nfffff@T     @X     @\     @`     @d     @ffffff@l@p     @t     @x     @|     @33333@     @33333@@     @     @     @     @     @     @     @@     @     @     @     @     @fffff@ә@     @     @     @     @     @@     @33333@     @      @     @     @     @33333@     @     @@(fffff@,     @.@4     @8     @<     @@     @D     @H@L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @{@33333@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @噙@     @     @@@     @     @      @     @@     @     @     @33333@ fffff@$     @(     @,     @0     @3@<@@     @C@Pfffff@T     @X     @\     @d@h     @l     @p     @s33333@|@     @     @     @     @@@     @     @     @33333@33333@     @     @     @     @     @     @fffff@     @     @     @     @ߙ@㙙@     @     @     @     @     @     @      @@@     @     @fffff@!33333@$     @(     @,     @0     @4     @8     @<     @E@H     @L     @P     @T     @X     @\     @^fffff@h     @l     @nfffff@u33333@x     @|     @     @     @     @     @@     @     @     @     @     @     @     @     @@@     @     @     @     @     @@33333@     @     @33333@fffff@     @     @     @     @     @@	33333@     @@33333@     @     @      @$     @(     @,     @0     @3@8     @<     @>@D     @H     @L     @P     @T     @W@\     @`     @dfffff@h     @l     @p     @t     @v@}@     @     @     @     @     @     @fffff@     @     @     @fffff@     @     @     @     @     @     @33333@     @     @ϙ@ՙ@     @     @     @     @@     @     @     @     @33333@     @     @     @     @     @     @     @     @      @#@)33333@,@0     @4     @8     @<     @@     @D     @H     @P     @T     @X     @^     @`     @d     @h     @k@r     @t     @x     @|     @     @     @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            @<Z@=<64@<쿱[@<쿱[@<Z@<hr@=b@=Vl!@=v@=E@>
(@>6z@?|hs@?$tS@@n@An.@@C@@C@A:S@B@C@C@B ѷ@Bu%F
@BI^5@B&IR@Bu%F
@B@ATɅo@An.@As@A7Kƨ@As@@C@?@=E@<hr@<쿱[@=K]@<#x@<hr@<?@;A@:G{@;lC@=<64@=p
=@=p
=@=v@@4m9@G)^@M5Xy>@JD@Hp:@JW'@L@Ov_ح@I@F-@E8YK@CF]c@C\N@Hu%F@Gݗ+@H@Ik~(@Q_p@SZ@Sݗ+k@Stj~@Stj~@W
=p@XPH@]ce@ceO@n1@m\@bC,@?H˒:@&'@%ڹ@$%1@$TɆ@%`A7L@%O
@&L/{J@)lD@0:~ @:C\@Nqi@UfA@[u%@bM@lC@TɅo@E@@D*@PH@	k@
qv@XbM@Ձ$/@@F]d@.H@*0@\(@/V@!.I@Z1@͸@H˒:@9XbN@<쿱@@@=K@a@O@H@@84֡@u%F
L@ra|Q@q@oO
M@m
qv@lq@S*0U2@As@5Xy=@%O
@o i@3@fffff@D*@hr @>B@a@O@GK]d@D*@
(@F
L0@*0@.H@A@af@     @mhr!@fIQ@Zݘ@Q_p@+Q@I^5?@C\@/V@Ϫ͞@+a@84֡@nH@[Q@P|@?H˒:@2a|Q@)ᰉ'@+@:~ @ө*0U2@.H@ ě@/V@@4@kP|@@_p@]cA@ڹY@y@o h@}Vl!@q@]IQ@C\N@5!R@+U=@0
)@
O;dZ@ NU@#w@쿱[W?@*0U@(@W@[W?@S@tj@xF@a|Q@]}H@RT`d@Jn@<#x@Mj@JM@~$@D@V@`A@
=p@Vu@]cf@^5?|@9XbN@I^@o@e+@ݗ+k@\(@o@]ce@O͞@2ᰊ@0U2a|@ d8@ߤ?@1@oiDg8@y@C\@-V@iDg8@V@rGE@RT`e@ڹ@x@@M@҈p;@kP|@I^5?@w4m@p'RT@p ě@pU2a|@kP{@b}Vm@Xy=c@BI^5@.2X@N;@:)z@g	l@m\@iDg8@䎊r@,<@ʌL_@S&@$tS@?@s@~($@z@,@Q@Ϫ͟@7KƧ@r-V@a-w1@ZQ_@<?@W>6z@e+a@@l!-@$/@Fs@@&@E@XbM@SMj@g	@h	ԕ@ө*0U2@)^@74@9@Y@$/@jJL@c
=p@Z,<@Q4J@-U=@$Z1@Q@+j@>BZ@Ϫ͞@u@9Xb@4֡b@-@|Q@wkP@+j@tj~@͞%@żn/@b}V@q@eO@Mj@_@o hی@zG{@w4m@tJ@mV@ezxl"h@\]ce@UϪ͞@NVu@F&I@F-@;J#9@.c	@+I^@(@%S@ u!@Ov_خ@hr @ hۋq@+jg@v@Ov`@R<6@iB@ק&@*0@@T`d@hr @H@:@K]d@
(@q@	k@O
@ߤ@@@@+j@>6z@$tS@$/@zG@T@n@9Xb@ [7@z~@u?@h@]IQ@N_o @Em\@@C@:S&@6+jg@2 ě@/-V@/v@.2X@,q@)B@%S@#wk@"3@-V@Y@@R@
#9@ IQ@(@!.I@%F
L@PH@}Vl@Dg8~@iB@
(@.2@0U2a|@	ԕ+@@B@B@Xy=@fA@L/{J@o@Ov_خ@(\@u%@y=c@>6z@fA@_o @ěS@$/@E@Xy=@+@jOv@&IR@{5Xy@w3@u!R@u!R@tj~@qA [@m8Y@l1&y@gfA@f'@g8}H@g8}H@f'@h$xG@jJL@mw1@mw1@iDg8~@e+a@_;dZ@Y0
)@SZ@S&@P)^@F-@?@:^5?|@6ȴ9X@74m@8}H@9=b@9"`@9rGE8@:)_@>\N<@>$t@?$tS@?$tS@?$tS@?H˒:@?@>\N<@<Z@:G{@8}H@حV@1&@Ft@U=@U=@ߤ@@+@*0U2@`A7@!R<@
M:@K]c@\N@{J#9@ n@5Xy@ 4m9@.H@S&@l"h	@73@1@sg@ߤ@A [@O
M@jf@n.3@߾vȴ9@]ce@յsh@ѷX@'/W@̲@̘_@#9@+I@āo h@@\N<@^5?|@4K@䎊q@A [@{J#:@6z@@8}H@9@-
@U=@@af@sh@`d@`A7@qi@Ƨ@'RTa@@$/@n.@~ߤ?@{5Xy@t#@pD@g,@cS@_;dZ@]+j@Zc	@TE@NVu@Mqu"@I ѷ@Eݗ@C%2@@IQ@=!.H@9rGE8@7Xe@5'0@49XbN@1-@0oiDg8@.2X@($xG@%ڹ@#9@ 
qu@}H@&@
%@	k~(@ hۋq@(@fB@ᰉ'@>BZc@Ov`@c	@@^5?|@XbM@C-@&x@S&@u%F@+j@+j@_F@Xe,@*0U2@bM@'RTa@eO@p@e+a@`҈p@\(\@ZY@XU@V8YJ@UϪ͞@P`A7@O;dZ@Ks@ATɅo@9Y}@,1&y@ 'RT`@~($x@K]d@o hی@b}V@Vl!@G{@Q@l!-@+@)^@s@\(@Z@Y}@}H@4K@W@TɅ@}H@@$tT@     @z>B@zC\@p:~ @d%1@ceO@dZ1@bM@_Ft@[W>6z@Vaf@S&@P{@O͞@QX@HK]c@<j~#@.H@&x@"3@ 	k@vȴ9@u"@,<@!R<@@~($x@xF]@
qiC@	'RTa@Fs@
˒:)@
F]d@
eں@
!.@
j~@
D@
g@
iB@
x@
fffff@
e+@
حU@
`d@
҈p:@
Ϫ͞@
@
n.@
TɅ@
'@
wk@
!-w1@
=K^@
@
@@
sh@
ݗ+k@
hr @
Vu@
L/{@
b}V@
p:~ @
o hۋ@
j~"@
ae@
\>@
Yb}@
Rp:@
K)^	@
H@
Fs@
C$@
;/V@
6}Vl@
2m\@
333333@
0'RT@
-U=@
)y@
!R<6@
 [6@
vȴ9@
Ov_خ@
u@
u%@
O;d@
'/W@
u%F@
?@˒:)@!-w2@hr!@빌~($@,<@8YJ@;dZ@v_ح@Ϫ͞@\(@64@)@H@lD@RT`e@tSM@@ݗ+k@rGE9@ߤ?@qu"@&I@~($x@zG{@vFs@qA [@k~($@jg	@eڹ@be+@\>@Z1'@W@VϪ͟@T`d@I@Ca@N@A@?@:)y@333333@12W@0'RT@.1@-B@,<쿱@*d7@ 'RT`@@@Fs@MjO@@唯O
@S@o@&@jOv@@҉@L/{@$/@@F]c@hۋq@}ڹZ@xl"h	@w1@v_ح@tD@tSMj@sE@sMjO@sPH@nc	@h	ԕ+@h>BZc@gfA@hr Ĝ@g	k@f,<@dqj@a'R@Y+@I@?@9Y}@9D@3g	l@,>B[@'/V@&x@ ěT@C,zx@ߤ@@Q@PH@$/@@$tS@+j@*0@*0@_F@tj@)^@I^5?@xF]@o hی@
b}V@
H˒@
J#9@
kP@
Fs@
{m@
@
fB@
Z@
حV@
ۋq@
,<@
`A7@

M;@
5Xy>@
@
n@
S&@
U2a|@
*0U2a@
TɆ@
ěT@
e+a@
Z@
n@
M:@
u%F@
o h@
n.@
|?@
t#@
n.2@
jOv`@
iDg8~@
ZQ_@
U2a|@
Rm@
Q@
ATɅo@
8YJ@
.1@
.}Vl@
+jf@
!o@
O;d@
)^@	ڹZ@	s@	73@	+jg@	@	D@	Ft@	t@	`A7@	5Xy>@	ʌL_@	˒:*@	?@	TɅo@	K]@	?|h@	o@	0
)@	sh@	*0U2@	n@	'/W@	qu"@	u%F@	#@	@	Fs@	Fs@	$/@	oiDg@	n/@	ݗ@	Q@	o h@	M:@	o h@	tj@	@	 ѷ@	@4n@	ѷX@	$/@	$tS@	zG{@	y(@	zxl"h
@	|Q@	{~$@	v!.I@	vȴ9X@	r ě@	qu!S@	l!-w@	glC@	g8}H@	hۋq
@	gfA@	ffffff@	dZ1@	aGz@	]+j@	TE@	RT`d@	C@	@n@	>vȴ9X@	<64@	9#w@	5?|h@	1-@	0'RT@	.1@	+6z@	)@	u"@	tj~@	!R<@	'/@		 ѷ@	@	%2@	@	 IQ@	      @"`@+jg@\(@_ح@\(@#@g@@4֡a@!-w@"h	ԕ@ۋq
@7@eO@?@Q_@"`B@"`B@"`B@8YJ@D@@n.@~($@g	l@,@쿱[W@vȴ@@@+J@@N@@I^5?@.H@{J#9@yrGE8@vȴ9X@r ě@nO;@kQ@ix@de@c	@be+@^ ѷY@Yb}@T`d@SZ@R䎊@P|@OAs@K]cA@F
L/@BZc@@NU@9~($@-w1@&L/{J@"wkQ@!-w1@䎊r@1&@u%@_F@$/@@N@:)y@u@Mj@
O;dZ@Fs@ 4m9@m\@b}V@$t@PH@m]@A [@唯O
@fA@rGE@]ce@t@a@O@As@]cA@ȴ9Xb@@8YK@,zxl@C@v@dZ@sg@|@{@}Vl@<쿱@I^@[6@ߤ@@kP|@+j@$/@@1&x@oiDg@tj@:S@~($x@z>B@v!.I@vFs@u!.@t!-w2@sg@u\(@r ě@j~"@cS@ae@Y>BZ@P`A7@L_@HK]c@F?@Eo i@Dg8}@B74@BZc@@4m@;/V@6z@6}Vl@64K@5?@5Xy=@4J@0 ě@&IQ@$tS@)^@$/@ hۋq@H˒@Q@"`@73@{m@C@ۋq
@eO@|Q@@4@ߤ?@6@Z@ɺ^5?}@j~#@ߤ@?|h@g	l@o@{@0
@?@-w1@%@=K^@kP|@ᰉ@)^@q@ڹY@7KƧ@oiDg@$/@n/@ ѷ@@ѷX@~$t@zxl"h
@xF]d@vȴ9X@r{m@kC]@iᰉ'@iB@iDg8~@iᰉ'@ix@irGE@g	k@cZ@^iB@XU@T`d@P{@M@KƧ@K:)z@K]cA@JL_@IoiD@H9Xb@G@@B@@6@?H˒:@>
(@9Y}@.H@,q@*d7@)y@)y@)^@(\)@'&@&IQ@%1@$xF@wkP@$tS@Z@tj~@n@@
	 @YJ@$/@F]c@rGE8@F@SMj@iB@iB@iB@D@8Y@C@C]@C]@빌~($@C,z@C,z@+a@>@ڹY@>BZ@y=c@l!-@&@҈p:@ѷX@;dZ@
M;@;5X@#9@m\@~@m\@v@I^@TɅ@S@ae@PH@Z@nO@bM@Mj@_o@nP@I^5@$/@4m9@~$t@}ڹZ@oiDg8@aGz@_o@_o@^iB@]ce@\?@Y|@Q@M:@KƧ@JD@IoiD@HK]c@GE84@E8YK@A7Kƨ@=K]@<j~#@;5Xy@:)y@9Y}@84֡b@3|@2a|Q@.}Vl@-w1@,zxl"@,<쿱@+I^@+6z@(Xy=@&'@%u@%@e+a@ᰉ@ݗ+k@
@'/@u%F@JM@{J#9@ ѷX@E@J#9@@ߤ?@Q_@Ϫ͟@fA@T`d@@@˒:*@Ƨ-@š@84֡@,zxl@\N@@,zxl@\(@C@ߤ?@v@64@n.@n.@/V@D@YJ@rG@C-@?|h@m\@-@ ě@@zxl"h@?@h	ԕ@ae@-w1@-
@-
@䎊r@	@vȴ9@Ov_خ@e+a@)^@@~($x@M:@ѷX@|#x@y	k~@w1@u!.@sE@r䎊q@o@oiDg8@kC]@ceO@UfA@Sa@O@Rm@RT`d@RT`d@Q_p@P`A7@OAs@L@K:)z@KƧ@JL_@H9Xb@Em\@B@?|hs@9Y}@8YJ@*0
@#
=p@ ěT@}H@Q@@@+J@҉@$tT@@?@hr@@F]d@!.@{m@Dg8~@䎊qj@d8@҈p;@ݗ+j@cA @>@ܑN;@"`B@b}@حU@څݘ@JE@e+@+@y=c@bM@@sPH@t@䎊@+@s@Q@*0@Zc@ߤ?@dZ@'RT@o@@4J@@p:@F]c@     @˒:)@~\N<@z>B@v!.I@o4֡a@j~"@g	k@d%1@a|Q@_حV@]cA @ZY@XbM@TɅoi@R䎊@P`A7@N;5X@MjOv@M5Xy>@L@Jn@H@HK]c@F
L/@DS@D2W@<쿱[@2W@0
(@',@"wkQ@ 'RT`@u"@ߤ@@ߤ@@Q@u%@6C@6C@6C@_o@tj@O
M@S&@-
q@
O;dZ@@'/W@I^5?@	'RTa@@:S@$/@$/@      @$t@!.H@~$@=b@+@kP@Fs@Fs@\(@s@8Y@	k@حV@ܑN;@W>6z@b}@JE@`d@a@O@@,<@т@ΤT@_o @;5X@_o @;5X@;5X@͞%@s@D@n@Ƨ@n@#9@a@N@|hs@<64@n.@A@A@)y@4֡b@rG@z@4K@W@1@a@@@RT`e@IQ@.H@vȴ9@,=@IQ@u"@Q@,<@zG@zG@zG@@N@sP@'/W@(@@ڹY@F]c@z@tj~@r ě@pD@p
=q@p
=q@p:~ @p@o4֡a@nO;@nc	@m(@k~($@kP{@j~"@g	k@b}Vm@`u!@_?@]+j@Z1'@Vt@S@M5Xy>@K)^	@Ks@I@H9Xb@Dg8}@Dg8}@B\(@A@@C@=p
=@=K]@<64@9~($@8YJ@74m@6C-@7rG@;5Xy@8Q@5Xy=@0'RT@)^@$/@쿱[W@%@-V@-V@,=@-V@u"@%@쿱[W@-V@u"@ߤ@@wkP@e+a@sh@*0U2@@N@nO@'/W@L_@
qiC@	'RTa@oiDg@F]c@.H@Vl!@?@?@s@C\@(@F]d@j~@䎊q@iB@@iDg8@빌~($@ᰉ'@ۋq
@唯O
@d8@ce@ѷX@_o @Ƨ@@š@\(@)y@4K@U=@0
@Xy=@-@0
@\)@x@@/@?@u%F@@ݗ+k@$tT@=p
@@}E@sg@r䎊q@q@iB@hۋq
@g	k@ffffff@f1.@eڹ@eO
@e`A7L@b}Vm@`A7K@^@]+j@Yb}@XD*@R䎊@M%@LcA \@G@@DS@A [7@>BZc @<n.@;A@9Y}@84֡b@64K@5?@6E@5?@5?|h@4֡a@49XbN@2a|Q@2ᰊ@1&x@.2X@)@"`A@}H@wkP@qu!@6C@R<6@nO@o @
(@!R<@
qiC@1&x@tj@ ($x@ 	k~@ Fs@ +jg@ j~@ g@ 䎊q@ @  ě@ \@ Ov`@ Dg8~@ rGE@ r Ĝ@ B@ >BZc@ fffff@ 7@ Z1@ %1@ Gz@ A7K@ 5?|@ ܑN;@ W>6z@ b}@ b}@ D*@ @ Ϫ͟@ 2a|@ H@ ˒:)z@ n@ /{J#@ ʌL_@ Q@ K]c@ E84@ )^@ m\@ '0@ <쿱@ S&@ .H@ 	k@ [6@ 䎊r@ 䎊r@ vȴ9@ Q@ IQ@ Xe,@ ҉@ '/W@ '/@ _o@ nP@ n.@ 4m9@ ~\N<@ }!.H@ |Q@ {m]@ {m]@ zG{@ vȴ9X@ u\(@ tD@ sE@ r䎊q@ qiB@ qu!S@ poiDg8@ p@ o@ nt@ m\@ l"h	ԕ@ kQ@ kC,z@ jfB@ jfB@ j~"@ iᰉ'@ g8}H@ f1.@ de@ ceO@ \>@ ["`B@ Y>BZ@ Y|@ Xy=c@ W&@ Vl!-@ TE@ P`A7@ O;dZ@ Ov_ح@ MjOv@ K]cA@ H˒:*@ F-@ E8YK@ F?@ Em\@ D*0@ C@ C,zxl@ B&IR@ A7Kƨ@ @NU@ ?@ =b@ :)_@ 9#w@ 8YJ@ 6z@ 5?@ 5Xy=@ 49XbN@ 1[W>6@ -V@ )*0U2a@ '/V@ '&@ &x@ &'@ &'@ &L/{J@ &IQ@ $/@ #9@ !ae@ 쿱[W@ Q@ =K^@ tj@ R<6@ sP@ )^@ -
q@ ߤ?@ !R<@ 
@ 
@ !R<@ 
(@ @ 
qiC@ ?@ u%F
@  hۋq?\N<?PH?	k~?eں?c	?VϪ?4֡a?C\?rGE?rGE?ᰉ'??1.?lC?Z?2W?n?/V?Z?n.?n.?^5?|?rG?rG?rG?}Vl?g	l?&?u?ߤ@?$tT?p:??xl"h	?s?qiB?q?qiB?hۋq
?d7?\(\?W&?U2a|?SMj?SMj?S&?S?SMj?PH?I^5?}?<쿱[?;5Xy?.H?$tSM?!.H?
(?	ԕ*?	ԕ*?_o?$/?JM?o h?.H?!.H?#x?"`?!-w2??;dZ?]ce?حU?a@O?p:~?`A7?͞%?@?ěS?\(?74?ߤ??j~#?'0?2W?{? ě                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            @@Fȴ9X@@FA@@FϪ͟@@F҈p;@@FA@@F҈p;@@FϪ͟@@FA@@FA@@F҈p;@@FA@@FA@@Fx@@F@@G@@G!-w1@@G.H@@G.H@@G8}H@@G>6z@@G4֡a@@G;dZ@@G>6z@@GAs@@GH˒:@@GH˒:@@GH˒:@@GKƧ@@GsPH@@GsPH@@Go@@GsPH@@G_o@@GiDg8@@G@@G+@@H6@@HK]c@@HD*@@Htj@@I@@Ib}@@I[W>6@@IA [@@Ik~(@@I'RTa@@I'R@@I|@@I|@@IiB@@JW'@@Jc	@@K9@@KMj@@KZ@@K@@MV@@McA @@MS@@M(@@N;5X@@Nx@@O>6z@@OE84@@OO
M@@OlC@@O+j@@P}H@@P ě@@P@@P6@@PH@@PbM@@P@@Pe+@@QoiD@@QN;6@@Qy@@Qk~(@@Q*0U2a@@Qae@@Qk~(@@Q@@QR<6@@Qu@@QY}@@R=p
@@RqiC@@RsP@@SlC@@TwkP@@TZ@@V5?|@@W˒:)@@[Z@@^T@@_
=p@@_lC@@`@@cPH@@g3@@jQ_@@p\)@@uhr!@@yu!S@@}!.H@@	k~@@1.@@6z@@L_@@2a|@@tSM@@_F@@&@@[W?@@	@@$/@@JE@@l@@h	ԕ@@c	@@(\@@iB@@ȴ9X@@"@@8}H@@sPH@@zH@@C%@@+j@@As@@@N@@@@%@@     @@XbM@@-@@n.@@eں@@!R<@@т@@~($x@@p
=@@֧-@@#@@TɅo@@@@m@@@@9XbN@@!-w@@S&@@
=p@@bM@@
=q@@4J@@o@@D@@|@@Z1@@1&@@>B[@@+a@@jOv@@@@5?|@@椨T@@,@@4m@@{J#:@@͞@@@@-@@#@@bM@@*0@@-
q@@>BZc@@Xy=@@r Ĝ@@艠'RT@@ěT@@+@@^@@@@陙@@陙@@齥@@o@@@@u%F@@GE85@@3@@@4n@@Q_@@a|Q@@S&@@D@@C,@@D@@~@@Z@@eO@@:)z@@빌~($@@Z@@|@@
=p@@Q@@a@@@xF@@@@ߤ@@@!-w2@@64@@/{J#@@/{J#@@9XbN@@C,zx@@xF@@64@@(\@@(\@@64@@xF@@@@j~#@@Z@@K]@@*0@@(@@?|h@@L_@@Y|@@`A7L@@jOv@@p
=@@}H@@}H@@M:@@hr!@@+j@@1@@cA @@-V@@@@Xy=@@힃%@@퇓ݗ@@픯O
@@픯O
@@@@sh@@Xy=@@@@-V@@Ϫ͞@@,=@@_o @@1.@@R<6@@s@@Fs@@af@@'@@'@@&I@@m\@@2X@@-@@Fs@@@@x@@쿱[W@@쿱[W@@Fs@@!.I@@Xe@@$tS@@>6z@@ݗ+@@@@ݗ+@@4m@@y@@	k@@O;d@@?@@K]d@@r@@[W>@@r@@r@@@@}H@@y=c@@u!@@oiDg8@@l"h	@@-
@@𖻘@@-
@@𭫟U@@F@@	k@@+@@ [7@@-w1@@Gz@@o hی@@񂩓@@n.@@N;6@@Y}@@&IR@@1'@@=p
@@JL@@T`d@@xl"h
@@򅇓ݘ@@@@W@@䎊q@@s@@33333@@9@@]cA@@$@@@@Z@@Ƨ@@ݗ+k@@g@@"h	ԕ@@2W@@VϪ@@zG@@*1@@Ʌoi@@@@2a|@@B@@L_@@Y|@@ce@@p
=@@}H@@!R@@\(@@zG@@($x@@;5X@@%@@O;@@O;@@,<@@@@-@@2X@@1@@"@@
=p@@KƧ@@b}V@@zH@@@@@$xG@@Q@@4m9@@H@@4m@@ѷX@@ѷX@@@@@N@@4J@@Q@@hr @@b}@@~($@@@@^5?}@@D@@@@ᰉ'@@Y}@@1'@@6C@@@4n@@JL@@T`d@@kP|@@L/{@@"`B@@a@N@@q@@wk@@E@@5Xy@@s@@,<@@<쿱@@I^5?@@]ce@@?@@S@@1&@@7@@֡a@@/@@/@@@@JM@@JM@@>B[@@?@@$/@@Xy=@@
(@@($x@@8YJ@@R<6@@fffff@@}Vl@@6z@@ߤ?@@ hۋ@@$tS@@8}H@@8}H@@;dZ@@As@@E84@@\(@@sPH@@{J#:@@3@@@@+j@A 73@A 4m@A PH@A#w@A[W>6@Ab}@AX@A@A-V@A=p
@AC\@AJL@AM@AW'@A{m@A@4@A\(@A@A>B@Ag	@AY@A)_@A`A@A䎊q@AI^@AƧ@A҈@Aߤ@@A(\@A<쿱@A`d@Aq@A#@A3@A[W?@AJM@Aqu"@A%F
L@A2a|@A2a|@AB@Aݗ@A@A\(@A?@AC\@A
L/@A@A5?|@AR<6@A+J@At@AO
M@AsPH@A-V@A@@A	ԕ+@A}H@A4m9@A73@AQ@A|@A-
@A@@A	k@A	&x@A	[W>6@A	x@A	@A	R<6@A	'R@A	>BZ@A
u%F@A
#9@A
:)y@A
d7@A
\(@A
S&@A
g	@A
@A
c	@As@A/V@AF]c@AW>6z@AxF]@A*0U2@Aa@O@A
=p@Ag@Atj@A,<@A9XbN@AFs@A`d@AcA \@AzG@A*1@AN;@A#x@Ahr@A
%F
L@A
}H@A
@A
\(@A
b@A
ᰉ@A
oiDg@A
L/@A($x@A8YJ@A_ح@Ac	@A+J@A2X@Aȴ9X@A)^@A.H@A8}H@ART`e@AlC@A@AO;d@A	k@A;dZ@A+j@A@A+j@AbM@A'RT`@A:~ @A[6@Al"h	@A|@A|@AěT@AѷX@APH@A_p@A:S@Ak~(@A1'@AZc@AnO@A\(@A@AY@AڹY@Am@AnP@A/V@Aqu!@Aq@AƧ@An.@A(\@A#@AN;@Aj~@AɅoi@AZ@A>B[@A'0@A<64@AVl!@A}H@Azxl"h@AO
@An/@A@A@Ab@AoiDg@A
L/@A;5X@AE@AH@A$t@A1@A
=p@ART`e@AsPH@A|hs@AO;d@AO;d@Aݗ+@Aݗ+@Ar@A;dZ@A@A#@ArGE9@A6@AK]c@Ar Ĝ@A@AIQ@A
=q@A{@AěT@A҈p@A	k~@A_p@A [7@A-w1@A:S@AN;5@Ao@A>BZ@A3@A=p
@Ad7@Aݘ@AL/{@A,<@AC,@A'/@A&@A6z@An.3@AQ@AMj@A:)z@Aq@A6@Ag@AJ@A?@Am8@A#@Aqj@AN;@A_@A_@ATɆ@A1&@A?@AZ@AE@Ao i@AK]@A+a@AB@AIQ@AY|@Asg@AM:@A!R@Ash@Ab@Aᰉ@A!.@Aڹ@A_o @A@A+jg@AR<6@A_ح@Afffff@Ap:~@Ap:~@A}Vl@AO;@Am\@AϪ͟@A+@Aߤ?@A쿱[W@AMj@AMj@A
=p@A)^@Av@A,@A$tS@AAs@A>6z@AE84@Aeں@A&@A&@Ao @A䎊r@A+j@A @A 
qu@A 6@A K]c@A y=c@A n@A u%F@A 4m@A )^@A )^@A e+@A \)@A! [7@A!7KƧ@A!Dg8~@A!JE@A!XbM@A!o@A!(@A!(@A!l@A!2W@A!iB@A!>BZ@A!R@A!Y}@A"u%F@A"n@A"@A"6C@A"T`d@A"~"@A"L/{@A"S&@A"S&@A"@A"}Vm@A"sP@A" ѷ@A#S&@A#"`B@A#&@A#,zxl@A#9@A#C%@A#S@A#a@N@A#*0U2@A#6@A#5Xy@A#|@A#C]@A$@A$tj@A$64@A$tSM@A$?@A$@A$#x@A$#x@A$#x@A$7@A$?@A$Ʌoi@A$֡a@A%o i@A%+a@A%84֡@A%5Xy>@A%B@A%L_@A%Vl!@A%\@A%sg@A%}H@A%}H@A%w1@A%zxl"h@A%M:@A%M:@A%}H@A%}H@A%}H@A%$/@A%$/@A%$/@A%m\@A%m\@A%w1@A%cA @A%@A%S@A%
qv@A%oiDg@A%E@A&t@A&_o @A&u@A&8YJ@A&L/{J@A&R<6@A&c	@A&c	@A&iB@A&c	@A&%@A&%@A&$t@A&T@A&Q@A&m\@A&t@A&҈p;@A&1@A&쿱[W@A&!.I@A')^@A'@A'v@A'1@A'As@A'KƧ@A'O
M@A'eں@A'o@A'4m@A'&@A'	@A'/V@A'@A'@@A'حV@A'fA@A(@A(-
q@A(NU@A(y=c@A(YJ@A(@A(u%F@A(-
@A(d8@A(4֡b@A)@A)@A)*0U2a@A)0
)@A):S@A)Gz@A)[W>6@A)ae@A)~($@A)@A)>BZ@A)-@A).H@A*u%F@A*@A*s@A*#9@A*-V@A*-V@A*)y@A*0U2a|@A*0U2a|@A*6C@A*6C@A*:)y@A*=p
@A*=p
@A*=p
@A*:)y@A*=p
@A*C\@A*GE85@A*JL@A*M@A*JL@A*M@A*h	ԕ@A*h	ԕ@A*d7@A*d7@A*d7@A*u%F
@A*u%F
@A*ݘ@A*p:@A*0
@A* ě@A*g	@A*L/{@A* ě@A* ě@A*Y@A*@A*,<@A*m@A*~@A+,zxl@A+=K^@A+MjO@A+F]c@A+W>6z@A+g	l@A+n.3@A+xF]@A+~$@A+q@A+Mj@A+Z@A+%2@A+@A+\N@A,1&y@A,@A,L_@A,"h	ԕ@A,(\@A,/{J#@A,C,zx@A,SMj@A,VϪ@A,PH@A,VϪ@A,]ce@A,`d@A,]ce@A,q@A,zG@A,o h@A,*1@A,TɆ@A,1&@A,j~@A,7@A,7@A,?@A,7@A,֡a@A-o i@A-2a|@A-?|h@A-Vl!@A-Vl!@A-M:@A-@A-@A-n/@A-cA @A-8Y@A-b@A-,=@A-E@A.+jg@A.1.@A.;5X@A.H@A._ح@A.fffff@A.l!-@A.s@A.+J@A.Fs@A.T@A.T@A.6z@A.ȴ9X@A.ȴ9X@A.t@A.҈p;@A.ߤ?@A.1@A.Mj@A/
=p@A/)^@A/'/W@A/Xe,@A/sPH@A/4m@A/O;d@A/{J#:@A/@A/	k@A/͞@A//V@A/vȴ9@A/@A/o @A/+@A/@A/Vϫ@A0F]d@A0bM@A0@A0
qu@A0}H@A0 ě@A0K]c@A0l"h	@A0hۋq@A0eO@A0@A0-
@A0@A0)@A0)^@A0ѷX@A0D@A0@A0C@A0{@A1$/@A1rGE@A1#w@A10
)@A14J@A1=b@A1Gz@A1Gz@A1o hی@A1@A1oiD@A1o@A1'RTa@A1^5?}@A1o@A1ԕ*@A1iB@A1iB@A1@A1.H@A2u%F@A2I^5@A2I^5@A2e+@A2e+@A2@A2䎊@A2:)y@A2Q_@A2^5?|@A2qiC@A2\(@A2vȴ@A2@A2g	@A2@A2<64@A2n@A2@A2͞&@A2ڹY@A2m@A2~@A2m@A2D@A274@A2~@A3҉@A3/V@A3]cA@A3tj~@A3$@A3@A3Z@A3~($@A3Ƨ@A35Xy@A3ݗ+k@A3$@A4n.@A4@A4!-w2@A4ߤ@@A4"h	ԕ@A4/{J#@A4I^5?@A4q@A4S@A4?@A4zxl"@A41&@A4?@A4#x@A4֡a@A4>@A4hr@A4e@A5K]@A5'0@A5[@A5/w@A5<64@A5<64@A5B@A5L_@A5L_@A5L_@A5Y|@A5\@A5`A7L@A5ce@A5w1@A5zxl"h@A5$/@A5hr!@A5@A5Xy=@A51@A5U=@A5U=@A5U=@A51@A51@A5H˒@A58YK@A5S@A5!.@A6 ѷY@A6
L/@A6@A6zG@A6@A6@A6Ov_@A6!R<@A6!R<@A61.@A6;5X@A6?@A6E@A6_ح@A6}Vl@A6%@A6qi@A6$t@A6@A6Fs@A6O;@A6@A6O;@A6T@A6-@A6ߤ?@A6Ϫ͟@A6+@A6ߤ?@A6C-@A6쿱[W@A6"@A7
M;@A7
=p@A7)^@A71@A74֡a@A7E84@A7RT`e@A7RT`e@A7O
M@A7RT`e@A7_o@A7b}V@A7iDg8@A7b}V@A7iDg8@A7iDg8@A7iDg8@A7{J#:@A7kP@A7?@A7-V@A7͞@A7[W>@A7/V@A7@A7@A7K]d@A7˒:)@A7˒:)@A7حV@A7@A8	ԕ+@A8'RT`@A8*0@A8:~ @A8D*@A8H@A8[6@A8y=c@A8˒:*@A8'RT@A8u%F@A8u%F@A8U@A84m@A84m@A8)@A8
(@A8ěT@A8)^@A84֡b@A9 [7@A9#w@A9 [7@A9&x@A9*0U2a@A90
)@A94J@A9Q@A9^@A9^@A9e+a@A9k~(@A9o hی@A9u!S@A9u!S@A9oiD@A9~($@A9o@A9@A9u@A9u@A9n.@A9|@A9^5?}@A9y@A9o@A9y@A9o@A9_o@A9ԕ*@A9"`@A9iB@A9R@A:n@A:@A:s@A:1'@A:)y@A:6C@A::)y@A:GE85@A:JL@A:M@A:Zc@A:nO@A:>B@A:)_@A:`A@A:G{@A:G{@A:fB@A:74@A;I^@A;S&@A;'/@A;s@A;'/@A;C,z@A;C,z@A;"`B@A;	@A;&@A;)^	@A;/V@A;33333@A;6z@A;9@A;=K^@A;@N@A;F]c@A;J#9@A;MjO@A;MjO@A;P{@A;W>6z@A;a@N@A;dZ@A;xF]@A;@A;Q@A;eO@A;$@A;:)z@A;Mj@A;$@A;A@A;A@A;A@A;U=@A;*0U2@A;a@O@A;5Xy@A;
=p@A;lC@A;$@A;\N@A<@A<J@A<L_@A<Q@A<!-w2@A<%1@A</{J#@A<2W@A<g8}@A<~($x@A<~($x@A<~($x@A<#@A<?@A<C@A<C@A<qj@A<쿱[@A<쿱[@A<S@A<S@A<zxl"@A<@A<j~@A<7@A<Z@A</@A<E@A=[@A=qu"@A=/w@A=2a|@A=/w@A=<64@A=B@A=IQ@A=O;dZ@A=p
=@A=M:@A=ݗ@A=hr!@A=+j@A=@A=n/@A=b@A=8YK@A=
qv@A=
qv@A=
qv@A=ᰉ@A=,=@A=ᰉ@A=(@A=oiDg@A=E@A=E@A=!.@A=E@A=C\@A=!.@A=!.@A=C\@A=C\@A>_o @A>
(@A>@A>Ov_@A>.2@A>5?|@A>;5X@A>L/{J@A>c	@A>$t@A>2X@A>&I@A>t@A>ߤ?@A>Mj@A>Fs@A>쿱[W@A>!.I@A?
M;@A?
M;@A?!-w1@A?8}H@A?;dZ@A?H˒:@A?E84@A?RT`e@A?\(@A?_o@A?\(@A?sPH@A?4m@A?|hs@A?&@A?&@A?	@A?	@A?@A?kP@A?-V@A?&@A?&@A?͞@A?/V@A?@A?@A@     @A@	ԕ+@A@bM@A@6@A@}H@A@ ě@A@}H@A@}H@A@$xG@A@'RT`@A@$xG@A@'RT`@A@-
q@A@73@A@A7K@A@A7K@A@Q@A@_F@A@K]c@A@Q@A@Xy=@A@r Ĝ@A@u!@A@oiDg8@A@oiDg8@A@u!@A@|@A@|@A@'RT@A@YJ@A@tj@A@tj@A@tj@A@@A@u%F@A@-
@A@4m@A@
(@A@ѷX@A@҈p@A@`A7@A@C@A@@A@	k@A@PH@AA ѷ@A@	k@AA ѷ@AA@AArGE@AArGE@AArGE@AA	k~@AArGE@AA+@AA@AA@AA+@AA@AA [7@AA&x@AA-w1@AA=b@AADg8~@AAN;5@AAJE@AAGz@AATɅo@AADg8~@AAJE@AAQ@AATɅo@AA[W>6@AAhr @AArGE8@AAu!S@AAu!S@AA@AAR<6@AA@AA@AA'RTa@AAu@AAl@AAB@AA2W@AAD@AAD@AAy@AAN;6@AAo@AA"`@AA"`@AAiB@AAs@ABI^5@AB1'@AB)y@AB#9@AB&IR@AB)y@AB-V@AB)y@AB-V@AB3@AB3@AB6C@AB=p
@AB:)y@ABC\@ABC\@ABT`d@AB^5?|@AB^5?|@ABd7@ABnO@ABxl"h
@AB~"@ABp:@ABS&@ABᰊ@AB0
@ABwkQ@ABS&@AB@AB@AB@AB}Vm@AB<64@ABn@AB@ABW@AB͞&@AB͞&@AB,<@AB`A@AB)_@AB`A@ABڹY@ABC,@AB~@ACu%@ACPH@ACs@ACC,z@ACC,z@ACC,z@AC	@AC"`B@ACC,z@AC	@AC"`B@AC&@AC)^	@AC&@AC,zxl@AC=K^@AC@N@AC@N@ACC%@ACP{@ACZ@ACZ@AC]cA@ACjf@ACtj~@AC~$@ACQ@ACeO@ACeO@ACMj@AC:)z@ACMj@AC$@ACU=@ACS@ACS@AC@AC@ACZ@AC6@ACa@O@AC@ACݗ+k@ACs@ADJ@ADߤ@@ADL_@ADQ@AD%1@AD64@ADI^5?@ADPH@ADm8@ADwkP@AD~($x@ADo h@AD?@AD#@AD#@ADqj@ADqj@ADN;@AD@AD#x@AD?@AD*0@AD@ADD@AE'0@AE+a@AE(@AE2a|@AEO;dZ@AES&@AEVl!@AEY|@AE\@AE\@AE`A7L@AE\@AEfA@AEsg@AEzxl"h@AEw1@AEڹZ@AEhr!@AEv@AE1@AE-V@AE8Y@AEϪ͞@AEb@AE?@AE,=@AEᰉ@AEE@AE(@AEڹ@AEC\@AF ѷY@AEE@AEڹ@AF ѷY@AF_o @AF_o @AF ѷY@AF
L/@AFzG@AF$/@AF5?|@AFH@AFE@AFH@AFOv_خ@AFYJ@AFiB@AFp:~@AFs@AFz@AF%@AF@AFO;@AF6z@AF@AFߤ?@AFߤ?@AFȴ9X@AFA@AF҈p;@AFA@AFA@AF1@AFx@AF쿱[W@AF쿱[W@AFMj@AF쿱[W@AFMj@AFFs@AF"@AG hۋ@AGFt@AG@AG)^@AG@AG,@AGv@AG$tS@AG$tS@AG.H@AG.H@AG1@AG4֡a@AGE84@AGU=@AGXe,@AGU=@AGXe,@AG_o@AG_o@AGeں@AG_o@AGv_ح@AG?@AGr@AGfA@AG+@AGfA@AG@@AG;dZ@AG;dZ@AG@AG@AGrG@AG#@AH	ԕ+@AH*0U@AH6@AH'RT`@AH73@AH:~ @AHD*@AHK]c@AHNU@AHU2a|@AHXy=@AHU2a|@AH_F@AHl"h	@AHl"h	@AHr Ĝ@AHu!@AH˒:*@AH˒:*@AH|@AH˒:*@AHn@AHn@AHn@AH'RT@AH@AH-
@AH@AH@AH@AHu%F@AHu%F@AHIQ@AH
=q@AH@AH{@AHěT@AHěT@AH@@AH)^@AH)^@AHp:@AHѷX@AHD@AH`A7@AHC@AHC@AH{@AH	k@AH$tT@AI ѷ@AI	k~@AI	k~@AI@AI@N@AIrGE@AI+@AI_p@AI@AI@AI&x@AI-w1@AI*0U2a@AI4J@AI7KƧ@AIA [@AIA [@AIA [@AIA [@AIJE@AI^@AI[W>6@AIe+a@AIrGE8@AIk~(@AIrGE8@AIrGE8@AIu!S@AIu!S@AIx@AIb}@AIoiD@AI7Kƨ@AI@AIR<6@AIn.@AI'RTa@AI|@AI|@AI@AID@AI2W@AI2W@AI@AI@AID@AI2W@AIo@AIiB@AIe@AIs@AI@AI@AIlD@AI.H@AI.H@AJI^5@AJn@AJI^5@AJs@AJI^5@AJI^5@AJs@AJe+@AJs@AJ0U2a|@AJGE85@AJJL@AJW'@AJQ_@AJT`d@AJW'@AJW'@AJ^5?|@AJa|Q@AJa|Q@AJa|Q@AJd7@AJxl"h
@AJp:@AJL_@AJᰊ@AJL/{@AJ@AJ<64@AJn@AJ@AJ@AJ@AJ͞&@AJsP@AJ ѷ@AJG{@AJC,@AJC,@AJc	@AJD@AJC,@AJc	@AJD@AJ~@AKnP@AK'/@AK"`B@AK33333@AKF]c@AKP{@AKW>6z@AKZ@AKZ@AKZ@AKa@N@AKa@N@AKjf@AKn.3@AKjf@AKqu!@AK{J#9@AKMj@AKA@AKU=@AKwk@AK*0U2@AK~($@AK*0U2@AKm]@AKZ@AKa@O@AK@AKZ@AK@AKa@@AK҈@AKlC@AK%2@AKg                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            @r@rfffff@r     @rs33333@rd@rk33333@rd@rffffff@ri@rp     @rh     @rY@r^fffff@rl@ra@r\@rffffff@ra@r`     @ra@rk33333@rp     @rl@r|@rvfffff@rs33333@rx     @rt@rvfffff@rs33333@rq@rk33333@rh     @rq@rp     @ry@r33333@r@r33333@r@r{33333@rx     @ry@r|@r@r~fffff@ry@ry@r33333@r     @r33333@r|@ry@ry@ry@r|@rx     @ry@rvfffff@rx     @rk33333@ri@rh     @rnfffff@rnfffff@rnfffff@ri@ra@r^fffff@ra@rh     @rh     @rh     @r`     @rh     @rffffff@r^fffff@rVfffff@rVfffff@rX     @rX     @rS33333@rNfffff@rI@rFfffff@rFfffff@rFfffff@rA@r6fffff@r1@r(     @r33333@r33333@qfffff@q33333@q|@qnfffff@qnfffff@ql@qL@q@p@p     @o@n@     @m33333@mfffff@l33333@lfffff@l33333@kfffff@j&fffff@i@iFfffff@i333333@h@h     @hp     @hffffff@hc33333@hY@hL@hFfffff@h9@h6fffff@h0     @h,@h      @g33333@g@     @f@f33333@f)@e33333@e@efffff@e     @e`     @e     @d33333@dp     @dY@dp     @dvfffff@dVfffff@d333333@d@c@c@c     @cs33333@cY@cffffff@cvfffff@cP     @c#33333@c	@bfffff@b`     @b9@b#33333@b33333@b@b      @a@b	@b33333@b0     @bI@b@     @b6fffff@b&fffff@b&fffff@b&fffff@b&fffff@b0     @b333333@b)@b#33333@b33333@a@a@a@a     @afffff@afffff@a\@a,@a      @`     @`@`     @`@`@`     @`@`@`@`ffffff@`\@`\@`\@`&fffff@`@_@_     @_fffff@_fffff@_     @_fffff@_     @_@_s33333@_Y@_@     @_9@_333333@_Ffffff@_S33333@_L@_9@_&fffff@_fffff@^@^fffff@^ٙ@^33333@^333333@^      @]ٙ@]33333@]fffff@]33333@]fffff@]@]@]fffff@]fffff@]l@]ffffff@]ffffff@]@\@\@\@\@\33333@\@\33333@\@\s33333@\ffffff@\L@\L@\S33333@\      @\      @[ٙ@[33333@[fffff@[ffffff@[S33333@[L@[L@[333333@[@[@Z@Z     @Z@Z     @Z     @Z333333@Z@Zfffff@Z33333@Zfffff@Z      @Y@Yfffff@Yfffff@YY@YL@YFfffff@Y@     @YS33333@YS33333@YL@Y@X@X33333@Xl@Xl@XY@X@Wfffff@W@W@W@W@W@Wy@Wl@W333333@W@V@V33333@V33333@V     @V@V@Vffffff@V333333@V@U@U@U33333@U     @U@Ufffff@Us33333@UL@U,@Ufffff@T33333@Tfffff@T@T     @T`     @TFfffff@T&fffff@T33333@T@T@T33333@Sfffff@S@Ss33333@SS33333@S333333@S&fffff@Sfffff@R@R33333@R@R     @R@R@R@Rfffff@R     @R`     @RFfffff@R9@R      @R      @Qfffff@Qٙ@Qfffff@Q@Qfffff@Qٙ@Q     @Q@Qfffff@Qs33333@QFfffff@Q@P     @P33333@Pfffff@Ps33333@Pffffff@P`     @PS33333@P9@P      @P@P33333@Pfffff@Oٙ@O@Offfff@Offfff@O@Offfff@O@O333333@O      @N33333@Nٙ@Nfffff@N@Nfffff@NY@Mٙ@Mfffff@Mfffff@Mffffff@Ms33333@MY@M&fffff@L33333@Lٙ@Lfffff@L33333@L@L@L@L@LL@L@     @L333333@L@     @L@     @LY@LY@L      @Kfffff@Kffffff@K      @Jfffff@Jٙ@J@J     @J33333@J@Jffffff@J&fffff@J@J&fffff@J@J@JL@J&fffff@J      @Ifffff@I@I33333@I@Is33333@I      @Hfffff@Hffffff@H333333@G33333@Gٙ@H@G@Gs33333@GL@G&fffff@G&fffff@G&fffff@G@G      @G@Fٙ@F@F     @F33333@F33333@F     @F     @Ffffff@FL@E33333@E33333@Es33333@E     @EY@E333333@E@E&fffff@E@D33333@D@Dfffff@D     @Dٙ@D33333@D     @DL@D&fffff@D      @D&fffff@D&fffff@D      @Cfffff@Cfffff@Cٙ@C@C@B@B33333@B@B@Bffffff@BL@B333333@B@B@B@     @B333333@Aٙ@A@As33333@Affffff@AL@A@     @AL@A@A&fffff@A&fffff@A      @@33333@@33333@@@@     @@@@     @@@@ffffff@@L@@Y@@s33333@@@     @@@?fffff@@333333@@&fffff@@333333@@&fffff@@      @@&fffff@@@@      @@      @@      @?@?@?L@?@>33333@?      @>     @>@>L@>@>      @>      @>      @>      @=fffff@=@=@=ffffff@=333333@<fffff@=      @=L@=@<33333@<fffff@<@<@<     @<@<333333@<L@<ffffff@<L@<@<      @;fffff@<@;33333@;33333@;     @;ffffff@;@:@:@:L@:333333@9@9fffff@9@9@933333@933333@9@9ffffff@9L@9333333@9333333@8fffff@8@8     @8L@8L@8L@8333333@7fffff@8@8      @7fffff@7fffff@7fffff@7@7@7@7@733333@7     @7     @7ffffff@7ffffff@7ffffff@6fffff@7      @6@6@6@633333@6@633333@6@6     @6     @6     @6@6     @6@6L@6L@6333333@6@5@5fffff@6333333@5fffff@5@5@533333@5@533333@5@5L@4fffff@433333@4fffff@4@433333@4     @4ffffff@4333333@4L@4@4@4333333@4      @4L@4      @4@4      @4@3fffff@3@3@3@3@3@3@3@333333@3@3@3@3@3@3@3     @3     @3ffffff@3     @3@3@3     @3L@3333333@3L@3333333@3L@3L@3333333@3      @3333333@3      @3@3      @2fffff@2fffff@2fffff@2@2fffff@2fffff@3      @3      @3      @2fffff@233333@3@3@3@3ffffff@3ffffff@3ffffff@3333333@3333333@3333333@3333333@3333333@2@3      @3@2fffff@3      @2@2@2@233333@2ffffff@2@2     @2     @2333333@2L@2L@2L@2333333@1fffff@1fffff@2@1@1fffff@1@1fffff@2@1fffff@1@1@133333@1@1@1@133333@1@1@1@2      @1@1@1@2     @2333333@2333333@2ffffff@2@2L@2@2      @2@2      @1@1@133333@1     @1L@1L@0fffff@033333@0@033333@0@0@0@0@0@0fffff@0@0@0@033333@0@0@0@0@033333@0@033333@1      @0@0@0@0@0@0fffff@033333@0@0fffff@0fffff@0@0@0@0ffffff@033333@0@0@0@0ffffff@0     @0@0L@0L@033333@0@0L@0L@0333333@0     @033333@0@0ffffff@0@0@033333@033333@0@0@0     @033333@0     @0@033333@0@0     @0333333@0L@0     @033333@0fffff@0ffffff@0@0@0@0fffff@0fffff@0@0@033333@033333@0L@0333333@0     @0@0     @0@0L@0333333@0@/@0     @0L@0L@0333333@0L@0333333@/ffffff@/@0@0@0@0@0@0      @0L@/@0      @0@/@/@0      @0L@/@0333333@0     @/@/ffffff@/@0333333@/@/@/@/@/@/@0      @0      @/@/@/@/@/ffffff@/@/@/ffffff@/ffffff@/      @/      @/ffffff@/333333@/@/ffffff@/333333@/333333@/ffffff@/333333@/333333@.@/333333@/@/      @.@/      @/333333@.@/333333@/      @/      @.@.ffffff@/      @.@.ffffff@.ffffff@/      @.@.@.@.@.@.333333@.333333@.@.ffffff@.333333@.      @.333333@.      @-@-@-@-@-@.      @-ffffff@-333333@-@-ffffff@-      @-333333@,@-333333@-      @,@,@-333333@,@-      @,ffffff@,ffffff@,@,ffffff@,@,@,333333@,ffffff@,@,      @+@,ffffff@,@,@+@,@-      @,@,333333@,      @+@,333333@+@+@+@+@+ffffff@+ffffff@+@+@+@+@+@+ffffff@+ffffff@+ffffff@+333333@+      @+@+333333@*@*ffffff@*@+333333@+      @*@*@+      @+333333@*@+      @+333333@*@*@*@*@*@*ffffff@*@*@*@*@+      @*ffffff@*      @)@*333333@*@*ffffff@)@)@*333333@*ffffff@)@*333333@)@)@)@)@*333333@)@)@)@)ffffff@*333333@)@*      @)@)ffffff@)@*ffffff@)@)@)@*ffffff@)333333@)@*      @)@)@)@*      @)@)@)@)@)@)ffffff@)ffffff@)ffffff@)@)@)ffffff@)333333@)ffffff@)ffffff@(@)@*      @)@)@)333333@)@)@)@)333333@(@)333333@)      @)@)@)ffffff@(@)333333@)ffffff@)@)ffffff@)ffffff@)ffffff@)      @)333333@)ffffff@)@)ffffff@)333333@)ffffff@)ffffff@)ffffff@)ffffff@)@)333333@)ffffff@)ffffff@)ffffff@)ffffff@)@)@)ffffff@)@)@)333333@)333333@)333333@)ffffff@)ffffff@)@)@)333333@)@)@)@)@)@)@*      @)ffffff@)333333@)@)333333@)@*      @)@)@)333333@*      @)@)333333@)@)@)@)@*      @)@)@*ffffff@*ffffff@)@)@)ffffff@)@*ffffff@)@*ffffff@*ffffff@)@)@*      @*      @)@)@*@*      @)@)ffffff@*      @)@)@)@*      @*      @*      @)333333@*@*      @*      @*333333@*@*333333@*ffffff@*333333@*ffffff@)@*ffffff@*ffffff@*ffffff@*@*ffffff@*@*@+333333@+ffffff@+      @+      @*@*@*@+333333@+333333@+      @+333333@+333333@+      @+@*@*@+ffffff@,      @+      @+@+333333@+ffffff@,      @+ffffff@+@+@+333333@+@+@+@+@+@+@,ffffff@+@+@+333333@+@,      @+@,      @,333333@+@,ffffff@,333333@,      @,      @,@+@,333333@,333333@,@,333333@,@-      @,ffffff@,@-@-333333@-ffffff@-333333@-ffffff@-333333@-@-ffffff@-ffffff@-@-      @,@-      @-@-@-333333@-333333@-333333@-333333@-ffffff@-@-333333@-333333@-@-ffffff@-ffffff@-@-@.ffffff@-ffffff@-@.333333@-@.333333@.      @-@.@-@-@.      @.333333@.@.ffffff@.@.@.@.@.@.@/      @.@.@/      @/333333@/ffffff@/@/ffffff@/      @/@0      @/@/@/      @0@/@/@0@/@0@0      @/@0@0333333@0ffffff@0ffffff@0L@0     @033333@0@0     @0@0@0     @0@0fffff@0@0@1333333@1333333@1333333@1@1333333@1ffffff@1@1     @1@1     @1ffffff@1     @1@1ffffff@1@1@1L@1@133333@1@1ffffff@1     @133333@1     @1     @1@1@1@1fffff@2@1fffff@2333333@2333333@2@2@2fffff@2@2fffff@2ffffff@2@3@2fffff@3      @3      @3@3@3ffffff@3333333@3@3ffffff@3@3@3@3fffff@333333@3fffff@3fffff@333333@4333333@4333333@3fffff@4333333@4@3fffff@3fffff@4333333@4     @4@433333@4fffff@4@4@5      @4fffff@5333333@433333@5333333@5333333@5@5      @5@5L@5      @5L@5@5333333@5L@5L@5L@5@5@5ffffff@5     @5@533333@5@5@5@5@6      @5fffff@5fffff@5fffff@6@5@6     @6L@6ffffff@6@6@6@6     @6fffff@6@6     @6fffff@7      @6fffff@6fffff@7@7      @633333@6@7      @6@6@7@7@7@7@7@7L@7     @7ffffff@7@7@7@7333333@7L@7     @7fffff@7@7@7fffff@7@7fffff@7@7@8     @8@8@8ffffff@8ffffff@8333333@8ffffff@8fffff@833333@8@833333@8@8fffff@9L@8fffff@9@933333@9333333@9ffffff@9@9fffff@9     @9@9     @9     @9@9fffff@9@9fffff@9@9@9fffff@:@:      @:@:333333@:333333@:     @:33333@:@:33333@:     @:33333@:@;      @;      @;@;@;333333@;@;@;     @;     @;     @;ffffff@;     @;L@;L@;@;fffff@<@<@;@<@<     @<     @<33333@<ffffff@<ffffff@<L@<333333@<ffffff@<     @<ffffff@<@<33333@<     @<     @<33333@<33333@<@=@=      @=      @=L@=333333@=ffffff@=ffffff@=333333@=L@=@=     @=33333@=     @=     @>      @>333333@=33333@=@=@>@>ffffff@>333333@>333333@>     @>     @>33333@>33333@?@?@?@?     @?@@@@&fffff@@@     @@      @@@?fffff@@      @@@@@@@     @@@@33333@@@@@@@@33333@@ٙ@@fffff@A@A      @A@AY@A@     @Affffff@A     @Affffff@AL@Affffff@As33333@A@     @A@     @Afffff@A     @A     @Afffff@Aٙ@A33333@A     @B@B333333@B&fffff@Afffff@B@B@     @B333333@B     @Bs33333@B&fffff@B&fffff@B@     @B@     @B     @Bffffff@Bs33333@BL@B@Bffffff@B@Bfffff@Bfffff@Bfffff@B33333@Bٙ@B33333@C@C@C      @C&fffff@C&fffff@C333333@Cffffff@CL@Cffffff@Cffffff@C@C@Cffffff@Cffffff@Cs33333@C@C@C     @D      @C@C33333@C33333@D      @Cfffff@Cٙ@C33333@C     @C     @Cٙ@C33333@C33333@D&fffff@D@D333333@D333333@D@D&fffff@D@     @DL@D333333@DY@DY@Dffffff@D     @DY@DY@Ds33333@D33333@D33333@D     @E&fffff@E@E@E@E333333@E333333@E@E@EY@EY@E     @Efffff@E@E@E@Efffff@F@Efffff@Efffff@Efffff@F      @F@F333333@FL@F&fffff@F@F333333@F333333@FL@F&fffff@FY@Fffffff@FY@Fs33333@F     @F@F     @FY@FY@FY@Fffffff@Fffffff@Fs33333@F@F@Fٙ@F@F33333@F@F@Fٙ@Ffffff@F33333@Fٙ@Ffffff@G@G&fffff@G@F33333@G@G@     @GL@Gffffff@G333333@G&fffff@GL@Gs33333@GY@Gffffff@Gffffff@G@G     @Gfffff@G@Gٙ@Gfffff@Gٙ@Gٙ@G33333@H      @Gٙ@G     @H@H      @G33333@H333333@H&fffff@Gٙ@H      @H333333@H333333@H@H@H@HY@HY@Hs33333@HY@H     @Hs33333@H@H     @H@H@Hfffff@Hfffff@H@H     @Hٙ@I@I      @Hfffff@I333333@I      @I@I      @I333333@I333333@I@     @I333333@I@     @Iffffff@IL@Is33333@IY@Iffffff@I@I@I@Ifffff@Iٙ@I     @Iٙ@I     @Ifffff@J      @I33333@Iٙ@J@J333333@J@     @J@J333333@Js33333@Jfffff@Jٙ@J     @Jfffff@J33333@J@Jfffff@Jfffff@Jٙ@J33333@K&fffff@K      @K      @K      @J33333@K333333@K@K@KY@K     @K     @Ks33333@K@Kfffff@K@Kfffff@Kٙ@Kٙ@L@L      @L      @L      @L&fffff@L@     @L@L@LL@Lfffff@L@Lffffff@Lfffff@L     @Lfffff@L33333@Lfffff@Lfffff@L     @L33333@Lfffff@M                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ?"`?$/?Gz?vȴ9X?I^5?}?bM?tj~?zG?zG{?+I? ě?nP?j~#?vȴ9X?9XbM?hr!?vȴ?I^5?Z1'?E?ȴ9Xb?^5?|? ě?ȴ9Xb?/w?
=p
?hr!?Gz?"`?9XbN?Vu?tj~?tj~?`A7?$/?Q?m?E?
=p?tj?Gz?&x?`A7?GzH?lC?Q?j~#?E?`A7L?C$?"`?ěS?-?I^5?}?1&x?1&x?hr ?1&y?zG?$/?tj~?S?o?Q?Gz?-V?ȴ9Xb?333333?
=p
?vȴ9X?Vt?vȴ9?m?$/?tj?lC?E?O;d?j~#?E?r ě?\(\?~"?hr!?hr!?j~"?      ?vȴ?-?\(?vȴ9X?\(?E?xF?zG{?1&x?޸Q?E?zG?p
=q?
=p?-V?E?ӥS?GzH?E?/v?xF?ffffff?E?Q?`A7?|hr?5?|h?p
=q?1&?QR?bM?KƧ?KƧ?KƧ?ȴ9Xb?+I?\(?E??|hs??|hs?$/??|hs?$/?zG{?zG{?j~#?E?l?+? ě?nO;?-V?l?-V?lD?hr Ĝ?&x?lD?lD?hr Ĝ?`A7L?`A7L?hr Ĝ?`A7L?hr Ĝ?`A7L?`A7L?bM?vȴ9X? ěT?vȴ9X?
=p? ěT?vȴ9X? ěT?bM?;dZ?Q?bM?bM?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?bM? ěT? ěT?;dZ?vȴ9X?;dZ? ěT? ěT?vȴ9X?vȴ9X? ěT?;dZ?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X? ěT?;dZ?vȴ9X? ěT? ěT?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?hr Ĝ?vȴ9X?vȴ9X?;dZ? ěT?;dZ?;dZ?;dZ?Q?;dZ? ěT? ěT?vȴ9X?;dZ?Q?;dZ?;dZ?bM?bM?vȴ9X?;dZ?vȴ9X? ěT?;dZ?;dZ? ěT?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X? ěT?;dZ? ěT?vȴ9X?;dZ?vȴ9X?;dZ?;dZ? ěT?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?bM?vȴ9X? ěT?bM?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X? ěT?vȴ9X?vȴ9X? ěT?;dZ?;dZ?vȴ9X?vȴ9X?
=p?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?`A7L?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?bM?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ? ěT?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X? ěT?vȴ9X? ěT?;dZ?;dZ?;dZ?vȴ9X? ěT?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X? ěT?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?&x?vȴ9X?vȴ9X? ěT?bM? ěT? ěT?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?Q?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?;dZ?;dZ? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X? ěT?vȴ9X? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?bM?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?bM?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X? ěT?vȴ9X?;dZ? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT? ěT? ěT? ěT? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?bM?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?Q?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?Q?Q?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?Q?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT? ěT? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?Q?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?Q?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ? ěT?vȴ9X?Q?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?Q?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?vȴ9X?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?;dZ?;dZ?Q?Q?5?|h?5?|h?;dZ?Q?Q?;dZ?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?vȴ9X?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?Q?5?|h?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?5?|h?Q?5?|h?;dZ?Q?Q?Q?Q?;dZ?Q?;dZ?Q?5?|h?5?|h?5?|h?;dZ?;dZ?5?|h?Q?;dZ?Q?Q?Q?5?|h?Q?Q?5?|h?Q?Q?Q?;dZ?Q?;dZ?5?|h?5?|h?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?5?|h?Q?5?|h?Q?Q?5?|h?Q?Q?Q?;dZ?Q?Q?Q?Q?5?|h?Q?Q?;dZ?;dZ?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?5?|h?Q?Q?5?|h?Q?5?|h?5?|h?Q?5?|h?5?|h?-V?5?|h?Q?5?|h?5?|h?;dZ?Q?5?|h?Q?Q?Q?Q?Q?5?|h?Q?5?|h?5?|h?Q?Q?5?|h?Q?5?|h?5?|h?Q?5?|h?Q?5?|h?5?|h?5?|h?5?|h?Q?Q?;dZ?Q?5?|h?5?|h?Q?5?|h?5?|h?Q?Q?Q?Q?Q?5?|h?Q?5?|h?Q?Q?5?|h?Q?5?|h?Q?Q?-V?Q?Q?5?|h?5?|h?Q?5?|h?-V?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?Q?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?Q?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?Q?Q?-V?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?-V?5?|h?/v?Q?-V?-V?-V?/v?5?|h?5?|h?-V?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?-V?5?|h?5?|h?-V?/v?5?|h?-V?5?|h?/v?/v?5?|h?-V?-V?-V?5?|h?5?|h?5?|h?-V?-V?-V?-V?1&y?/v?/v?5?|h?5?|h?5?|h?5?|h?5?|h?/v?/v?5?|h?5?|h?-V?/v?-V?/v?/v?/v?/v?5?|h?5?|h?-V?/v?5?|h?-V?5?|h?/v?-V?-V?-V?-V?5?|h?Q?-V?/v?/v?/v?5?|h?-V?/v?5?|h?/v?5?|h?-V?/v?1&y?-V?/v?/v?5?|h?-V?-V?-V?/v?-V?/v?-V?/v?/v?/v?1&y?/v?5?|h?/v?-V?-V?-V?/v?/v?/v?/v?1&y?1&y?-V?/v?1&y?/v?5?|h?-V?/v?/v?1&y?-V?/v?/v?5?|h?/v?-V?/v?1&y?1&y?/v?1&y?/v?-V?/v?/v?1&y?1&y?5?|h?/v?/v?-V?-V?/v?/v?/v?/v?-V?/v?1&y?/v?1&y?-V?-V?/v?1&y?/v?1&y?/v?-V?/v?/v?1&y?/v?1&y?-V?-V?/v?-V?1&y?/v?-V?/v?/v?/v?/v?-V?1&y?1&y?/v?/v?/v?/v?/v?1&y?/v?-V?1&y?1&y?/v?/v?1&y?/v?/v?/v?1&y?1&y?-V?/v?1&y?1&y?/v?1&y?1&y?/v?/v?1&y?1&y?1&y?1&y?1&y?1&y?1&y?/v?/v?-V?/v?/v?/v?/v?1&y?1&y?/v?1&y?/v?1&y?1&y?/v?(\)?1&y?/v?/v?/v?1&y?/v?/v?1&y?-V?/v?1&y?1&y?1&y?1&y?1&y?1&y?(\)?1&y?1&y?1&y?1&y?/v?1&y?1&y?1&y?1&y?1&y?1&y?1&y?/v?1&y?(\)?(\)?1&y?-V?/v?1&y?1&y?1&y?(\)?1&y                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ?                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	P15                                     1                                       )BDP3=