CDF       
      time      pressure  [   latitude      	longitude         string_dimension   (         EXPOCODE      29AJ20160818   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    WOCE_ID       TAlPro     	DATA_TYPE         WOCE CTD   STATION_NUMBER        15     CAST_NUMBER       1      BOTTOM_DEPTH_METERS          
Creation_Time         2020-03-19T19:50:18.523781Z    ORIGINAL_HEADER      CTD,20200319CCHSIO
# Converted CTDOXY from ML/L to UMOL/KG using the following:
#     https://github.com/TEOS-10/GSW-Python, downloaded 2019-06-26
#     gsw.sigma0:  Calculates potential density anomaly with reference pressure of 0
#     dbar, this being this particular potential density minus 1000 kg/m^3.
#     This function has inputs of Absolute Salinity and Conservative
#     Temperature.  This function uses the computationally-efficient
#     75-term expression for specific volume in terms of SA, CT
#     and p (Roquet et al., 2015).
#     http://www.teos-10.org/pubs/gsw/html/gsw_sigma0.html 
#     Python equation used:
#         oxy_UMOL_per_KG = oxy_ML_per_L * 44.660 / ( (1000 +  gsw.sigma0(SA,CT)) / 1000. ) 
# Data source:  https://doi.pangaea.de/10.1594/PANGAEA.902330
# SHIP: RV Angeles Alvarino
# Cruise: MedSHIP cruise TalPro
# Region: Mediterranean Sea and Catalan Basin
# Ports: Palermo, Italy to Barcelona, Spain
# DATES: 20160818 - 20160829
# Chief Scientist: L.Jullion
# 43 stations
# Original file in AWI format. CCHDO Converted to Exchange format
# EVENT_CODE=unknown
# DATE: YYYYMMDD
# TIME: HHMM
# LATITUDE: degrees_North
# LONGITUDE: degrees_East
# STNNBR:  removed leading 0s from STNNBR
# CASTNO: not supplied by originator - CCHDO assigned all CASTNO=1 or CASTNO=2 for stations 11, 29
# CTDSAL: changed units from Practical to PSS-78.  Data values remain unchanged.
# CTDFLUOR: changed units from UG/L to MG/M3 as they are they are equivalent
# CCHDO added flags=2 for all parameters, as T.Tanhua notes all params are calibrated and CTDOXY calibrated with bottle samples
# Removed two test sample depths from event/station 004, dTalpro_Stn04_test_1db
# Data precision preserved as submitted.
# CTD: Who - T.Tanhua; Status - calibrated,final
#     Includes: CTDSAL, CTDOXY
#     CTDTMP NOTE: Used first occurrence of primary temperature sensor in original data file
#     CTDSAL NOTE: Used first occurrence of primary salinity sensor in original data
#     NOTE: Physical parameters temperature, salinity, oxygen, density, turbidity, chlorophyll, fluorescence are published on PANGAEA, DOI above.
# Fluorescence (CTDFLUOR): Who - T.Tanhua; Status -final
#        Instrument: WET Labs ECO-AFL/FL, FLNTURTD-2526
#        ScaleFactor: 1.00000000e+001
#        Dark Output: 0.0760
# Turbidity (CTDTURBDTY): Who - T.Tanhua; Status - final
#        Instrument: FLNTURTD-2526
#        ScaleFactor: 5.000000
#        Dark output Voltage: 0.070000
#
# Reference: Cruise report: https://epic.awi.de/id/eprint/49725/1/TAlPro_EUROFLEETS_cruise_report_V2.pdf
# CCHDO page: https://cchdo.ucsd.edu/cruise/29AJ20160818
# Metadata from original file
#     Event(s):     TAlPro-2016_015 (15) * LATITUDE: 42.280000 * LONGITUDE: 9.900000 * DATE/TIME: 2016-08-22T23:49:00 * CAMPAIGN: TAlPro-2016 * BASIS: Angeles Alvarino (URI: http://www.eurofleets.eu/np4/285.html) * DEVICE: CTD/Rosette (CTD-RO)
#     Citation: Tanhua, Toste (2019): Physical oceanography during MedSHIP cruise Talpro. PANGAEA, https://doi.org/10.1594/PANGAEA.902330
#     Abstract: The TAlPro cruise (Palermo - Barcelona, RV Angeles AlvariÃ±o, 18/-8/2016 - 29/08/2-16) occupied three hydrographic transects across the Tyrrhenian Sea, the western Mediterranean Sea and the Catalan Basin (Fig. 1) as part of the MedSHIP programme (Mediterranean Ship-based Hydrographic Investigations Program). A total of 43 stations were occupied during which physical (temperature, salinity, pressure, velocity), biogeochemical (oxygen, nutrients, carbonate system, dissolved Barium, oxygen and nitrogen isotopes) and anthropic (CFCs, SF6) parameters were measured in order to monitor the physical and biogeochemical state of the Mediterranean Sea.
#     Related to: Jullion, Loic (2016): TAlPro-2016: A Tyrrhenian Sea & Alger- provencal component of the MedSHIP Programme. hdl:10013/epic.5a866780-1f8a-45cf-8111-47b2b5dc29db
#     Parameter(s):
#         Event label (Event) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Sample code/label (Sample label) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Date/Time of event (Date/Time) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Latitude of event (Latitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Longitude of event (Longitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Pressure, water [dbar] (Press) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Digiquartz
#         Temperature, water [Â°C] (Temp) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: ITS-90
#         Oxygen, dissolved [ml/l] (DO) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 43
#         Turbidity (Nephelometric turbidity unit) [NTU] (Turbidity) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO
#         Fluorescence, chlorophyll [Âµg/l] (Fluores) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO-AFL/FL
#         Salinity (Sal) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Practical
#     License: Creative Commons Attribution 4.0 International (CC-BY-4.0)
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            pressure               	long_name         pressure   positive      down   units         decibar    data_min      @"         data_max      @        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC        '   pressure_QC                	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d        A   temperature                	long_name         temperature    units         ?C (ITS-90)    data_min      @+GRT`e   data_max      @8Zc   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC         H   temperature_QC                 	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d        cx   salinity               	long_name         salinity   units         PSS-78     data_min      @Cn   data_max      @C[W>6z   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC        j0   salinity_QC                	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d           oxygen                 	long_name         oxygen     units         ?mol/kg    data_min      @e0
)   data_max      @p}|hs   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC             	oxygen_QC                  	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d           CTDFLUOR               	long_name         CTDFLUOR   units         MG/M^3     data_min      *6C-   data_max      ?!.H   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC        P   CTDFLUOR_QC                	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d        (   	CTDTRBDTY                  	long_name         	CTDTRBDTY      units         NTU    data_min      ?   data_max      ?ə   C_format      %f     WHPO_Variable_Name        	CTDTRBDTY      OBS_QC_VARIABLE       CTDTRBDTY_QC          CTDTRBDTY_QC               	long_name         CTDTRBDTY_QC_flag      units         
woce_flags     C_format      %1d           time                	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      &   data_max      &   C_format      %10d        p   latitude               	long_name         latitude   units         	degrees_N      data_min      @E#
=p   data_max      @E#
=p   C_format      %9.4f           t   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      @#   data_max      @#   C_format      %9.4f           x   	woce_date                   	long_name         	WOCE date      units         yyyymmdd UTC   data_min      36   data_max      36   C_format      %8d         |   	woce_time                   	long_name         	WOCE time      units         hhmm UTC   data_min        	-   data_max        	-   C_format      %4d            station                	long_name         STATION    units         unspecified    C_format      %s        (     cast               	long_name         CAST   units         unspecified    C_format      %s        (  @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                @8Zc@86@8 ě@8|Q@8Ov`@82X@8*0U@8@8pěT@8b䎊@8WRT`e@8KW>6z@80$tT@8$/@7I^5?@7'RTa@7&IR@7-V@7=K@7e+@7M@7BZc @6b}@6o@5MH˒@4A@4
[@3#9@3Um\@3!.H@2ᰊ@2e+@2s{J#9@2KQ@2/U=@2e@1Ƨ@1-w1@1XbM@1}hr!@1]B@1E84@0S@0Z@0@0vȴ9@0^;5X@0,쿱[@01&@/"@/	@/$@/sg@/Sߤ@/+Ƨ@/)^@.O;d@.
L/@.l"h	@. ѷY@.A@.-@.@.h$xG@.Rn@.3E@.m\@.Ƨ@-!-w2@-K]d@-Q@-MjO@-:S@-W@-zG@-D@-	 @-C@-Q@-qi@-,@-s@-o h@-@-{Q@-wrG@-uL_@-p ě@-lL_@-i^5?}@-kQ@-lI^5?@-i^5?}@-ffffff@-gy@-h@-ix@-kjf@-lVϪ@-n!R<@-pbM@-o͞@-jJL@-hXy=@-h\)@-hr Ĝ@-eQ@-`'RT`@-Z>B@-ZC\@-X*0@-[W>6z@-^"@-[dZ@-P{@-NMj@-N!R<@-L@-F
L/@-AR<6@-@hۋq@-<j~#@-7>6z@-6+jg@-43@-0D@-1A [@-1X@-5'0@-5sg@-6Ov_@-6!.I@-:kP|@-?	@-?[W>@-?.H@-@ѷX@-@hۋq@-A:S@-An.@-BM@-B`A@-Dtj@-A.H@-=,=@-6R<6@-2sP@-49XbN@-5=K@-6@-1N;6@--\@--(@-0|@-.+@-'E84@-$tS@-!o hی@-%oiDg@-)oiD@--jOv@-2:)y@-5!.@-2T`d@-4SMj@-2a|Q@-0$tT@-0 ě@-/ hۋ@-/r@-/͞@--(@--O;dZ@-,[W?@-+~($@-*0
@-)ᰉ'@-)ԕ*@-)^5?}@-)^@-'@-%o i@-#	@-}H@-!n.@-$TɆ@-$%1@- ěT@-S@-"`B@-lC@-~$@-Y}@-D*@-1&@-"h	ԕ@-#@-o@-6@-rGE8@-rG@-@-sPH@-O
M@-m@-@-
w1@-/{J#@-cA \@-*0U@-@-	oiD@-u%F@-p:@-1.@-M:@-C,@-h	ԕ@--w1@,䎊r@,vȴ9X@,H˒@,Vl!@,5Xy@,dZ@,=K^@,64@,)_@,b@,@,m]@,s@,v_ح@,M:@,^@,@,-@,9@,e@,M:@,TɆ@,Z@,)_@,[@,o@,\(@,}H@,ըXy=@,R<6@,zG@,sP@,ʳg	@,@,/w@,1'@,U@,O;d@,2a|@,l@,T@,H@,
M;@,]cA@,]cA@,eO@,oiDg@,@4@,>@,"`B@,+@,kP@,@,bM@,zG@,H@,zxl"@, ѷ@,o h@,/@,
=p@,\(@,:S@,o@,vȴ9@,o@,e@,n.@,n.@,~%@,~"@,~"@,}/w@,{/V@,y=b@,u2a|@,stj~@,rW@,r:)y@,qN;6@,qN;6@,qR@,ql@,qhr @,p`A7@,p:~ @,o hۋ@,mjOv@,l~($x@,gzH@,a@N@,_?@,^$t@,[qu!@,[u%@,\ߤ@@,_o@,ao hی@,b`A@,c,zxl@,bC,@,bZc@,ae@,a@N@,\n.@,K)^	@,F?@,H>BZc@,JfB@,MO;dZ@,KC]@,HXy=@,AGz@,?!-w1@,<>@,90
)@,7O;d@,8tj@,8y=c@,7$tS@,5fA@,4O
M@,3ߤ@,2䎊q@,3҉@,3&@,3|@,4#@,4zG@,4m8@,4J@,2䎊q@,2GE85@,14J@,0D@,0|@,0@,/ hۋ@,.}Vl@,.qi@,/O
M@,/iDg8@,.Mj@,..2@,-B@,,>B[@,,@,-M:@,.2X@,.t@,.t@,.H@,..2@,.!R<@,.c	@,.qi@,.}Vl@,._o @,-%@,-
qv@,-%@,-qu"@,,zxl"@,,L_@,)^@,(Xy=@,&-@,&'@,%`A7L@,%S&@,%S&@,'@,&L/{J@,#\N@,#	@,"}Vm@,!@N@,䎊r@,U=@,cA @,ߤ?@, hۋq@,H˒:@,v@,[@,v@, d8@,!TɅo@,!Gz@,!TɅo@,! [7@,!7Kƨ@, 	k@, [6@,H˒:@,m\@,v@,iB@,$t@,6z@,Vl!@,>@,p
=@,+j@,H˒@,cA @,H˒@,-V@,p
=@,>@,N;@,PH@,64@,5Xy@,~@,ݘ@,Q_@,rGE8@,#w@,4֡b@,-
@,eں@,R<6@,sh@,L_@,Z@,@, ě@,N;6@,@,hr @,`A7@,rGE9@,@,+@,;5X@,H@,p:~@,Vu@,
@,
M:@,
(@,zxl"@,҈@,Q@,
D@,	ԕ*@,	Q@,@,@,p:@,@,u%F@,>BZc@,A@,8YK@,F
L0@,o i@,Z1@,eO@,@,@4n@,n.@,$/@+H˒:@+Q@+@+u@+IQ@+쿱[@+lC@+u%@+@+tj@+}H@+F]d@+&@+KƧ@+ȴ9X@+R<6@+ᰉ@+Ʌoi@+@+@+@+@+E@+33333@+<64@+䎊@+䎊@+s@+2W@+hr @+
(@+@+4֡a@+ hۋ@+2X@+_o @+hr!@+M:@+jOv@+(@+B@+qu"@+쿱[W?@+cA \@+jf@+L/{@+#9@+'RTa@+ۋq
@+@+9Xb@+u%F@+1&x@+$xG@+-@+ݗ+@+8}H@+8YK@+/@+tj@+,zxl@+ ѷ@+wkQ@+\(@+\(@+I^5@+d8@+4m9@+
qu@+䎊r@+حV@+.H@+ޫ6z@+vȴ9X@+\N<@+b@+u"@+܄?@+(\@+W>6z@+_o@+0
)@+PH@+ؠ-
@+_F@+Xe@+$tS@+$tS@+z@+8YJ@+?|h@+֡a@+ԯO
M@+SMj@+ө*0U2@+33333@+:)y@+2W@+$tT@+U2a|@+;dZ@+@+@+Ϸr@+Ϫ͞@+Ϸr@+O
M@+ΤT@+c	@+w1@+@+̲@+cA \@+VϪ@+s@+C]@+L_@+/{J#@+I^5?@+~($x@+<쿱@+xF]@+D@+ʙ0
@+JL@+lD@+lD@+lD@+lD@+lD@+lD@+y@+@+k~(@+Țu%F@+1&x@+-@+y@+L/{J@+e@+âwk@+nP@+3@+$/@+ěT@+@+Ft@+@+}H@+hr@+(\@+Q@+m]@+)_@+@@+@+E@+2a|@+@+MjO@+䎊q@+T`d@+T`d@+a|Q@+4J@+U2a|@+o @+ߤ?@+(@+Q@+I^@+JL@+@+9Xb@+r Ĝ@+fA@+E84@+,<@+oiDg@+`A7L@+*0@+qj@+%1@+wk@+S&@+u%F
@+I^5@+4m@+˒:)@+|hs@+Q@+Ov_خ@+}H@+hr@+(\@+6@+Q@+Q@+5Xy@+~$@+~@+Y@+|@+_F@+F]d@+>6z@+z@+\(@+2a|@+D@+zG@+#@+`d@+|@+GE85@+l@+)^@+Vϫ@+4֡a@+;5X@+w1@+1&y@+6z@+L/{@+x@+ ѷ@+	ԕ+@+,@+x@+&I@+1.@+O
@+o i@+M:@+ ѷ@+o@+'R@+|Q@+d8@+U=@+~vȴ9X@+~BZc @+}+j@+|1&@+|PH@+|(\@+{6@+zݘ@+x}H@+u!.@+usg@+u?|h@+u2a|@+t!-w2@+q[W>6@+p ě@+oiDg8@+nVu@+mU=@+m\@+l>B[@+kP{@+h\)@+g	k@+fFs@+ffffff@+eS@+ezxl"h@+eS&@+eu@+d?@+ceO@+`ěT@+^Q@+^u@+^BZc @+^($x@+]v@+\N;@+\n.@+Z6C@+X@@+X73@+W+@+W>6z@+Vȴ9X@+Vaf@+V_ح@+UY|@+U'0@+Tj~@+T3@+Sg@+SZ@+Rᰊ@+R:)y@+RT`d@+Ra|Q@+Qu@+Qu@+PoiDg8@+P@+O;dZ@+OO
M@+O\(@+OiDg8@+OAs@+O'/W@+O'/W@+OAs@+O{J#:@+O@+Ov_ح@+OiDg8@+O{J#:@+Ov@+O
M;@+O'/W@+Ov@+O
M;@+Ov@+N1@+NO;@+Nߤ?@+Nt@+N+@+Nߤ?@+Nߤ?@+Nߤ?@+Nt@+NT@+NO;@+N}Vl@+Np:~@+Np:~@+N;5X@+Mhr!@+Mqu"@+MV@+Mqu"@+MO;dZ@+L@+L@+L>B[@+L@+Lq@+LL_@+L/{J#@+L"h	ԕ@+L/{J#@+L1&y@+L1&y@+K҈@+KƧ@+KU=@+KU=@+KC%@+Kjf@+KC,z@+Jd7@+IDg8~@+IDg8~@+IrGE@+GfA@+GK]d@+GfA@+Gy@+Gy@+Gݗ+@+GlC@+GRT`e@+G_o@+G&@+G&@+GfA@+G	k                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           @C)N;5@C)-w1@C)@C({@C(TɅ@C(|@C(r Ĝ@C(-
@C(YJ@C(-
@C(y=c@C'o @C'@C%ᰉ@C'-V@C(*0@C'KƧ@C&af@C&IQ@C$3@C!^@C}Vl@CO
M@C	k~@Ctj@CW'@C8Y@C
=p@C'@C?|h@Cg	l@CR@C)@CGz@Cs@C-@Ce+@C@C74@CZ@CwkQ@C@N@CI^5@C~($@C@N@Ctj@Cn@C`A7@Ce@C@C䎊@C7Kƨ@C@C=b@C@C7KƧ@Cu!S@COv`@CkP|@C,<@C>B@C}Vm@CL_@C33333@CE@C%2@C2W@C'0@CD@CQ@Caf@C6@C
qu@C>BZc@C@Cu%F@Cn@CdZ@C@Cm8@CY|@CϪ͞@Cl!-@C-@C@CAs@C 73@C!rGE@C!hr @C"I^5@C"n@C#nP@C#a@O@C%!.H@C&+@C( ě@C(IQ@C)-w1@C)x@C*-V@C+S&@C+@C+ߤ@C,<쿱@C,j~@C-L_@C.($x@C.BZc @C.O;@C."@C/4֡a@C//V@C0*0@C0@C/@@C0ěT@C1l@C2)y@C2JL@C3MjO@C4M:@C5o i@C5v@C58YK@C6
L/@C6Ov_خ@C7
M;@C7r@C8-
@C9:S@C9ᰉ'@C:u%F
@C:`A@C;~$@C;U=@C;$@C<zG@C<hr@C=5Xy>@C=$/@C=,=@C>L/{J@C>O;@C? hۋ@C?&@C?˒:)@C@4m9@C@u%F@CA@CAR<6@CAR<6@CAl@CB6C@CB@CCS&@CBvȴ@CBkP|@CC]cA@CD%1@CD?@CE!.H@CE$/@CFOv_@CFl!-@CG>6z@CGr@CGfA@CH$xG@CH|@CH҈p@CI$/@CI@CIᰉ'@CJM@CJg	@CKP{@CKjf@CKq@CKa@@CL1&y@CLSMj@CLzG@CL*0@CMqu"@CM1@CN_o @CN.2@CN;5X@CNE@CN@CNm\@CN1@CO@CO
=p@CO#@CP`A7@CQA [@CQ#w@CP$tT@CQGz@CQo@CQ@CQ@CQo@CQ-@CRC\@CRݘ@CRS&@CR䎊q@CSZ@CS{J#9@CSq@CSU=@CSA [@CSlC@CTߤ@@CT/{J#@CTcA \@CT_@CT@CTɅoi@CT/@CU!.H@CUB@CU\@CUݗ@CU@CUE@CV?@CVfffff@CVH@CV ѷY@CV4K@CV.2@CV+jg@CV_ح@CVqi@CVO;@CVA@CW'/W@CW>6z@CW@CW+I@CW@CW@CX4m9@CW+@CWrG@CX ě@CX*0@CX ě@CW͞@CW>6z@CW hۋ@CVMj@CV@CW hۋ@CWv@CW+I@CW'/W@CW͞@CWfA@CWvȴ9@CW˒:)@CW[W>@CWkP@CW{J#:@CWlC@CWsPH@CWiDg8@CWiDg8@CW{J#:@CW{J#:@CWU=@CWKƧ@CWXe,@CWO
M@CWU=@CW-V@CW3@CWo @CW@CW@CXbM@CXK]c@CXeO@CXhۋq@CXbM@CX_F@CXd8@CX4m@CX@CX@CXYJ@CX_F@CX[6@CXbM@CXl"h	@CX|@CX@CX@CXtj@CX{@CX)@CX)^@CY ѷ@CYrGE@CYrGE@CX`A7@CX)@CXU@CXIQ@CXy=c@CX
=q@CXěT@CYrGE@CY=b@CYo hی@CYx@CY@CYn.@CY'RTa@CY@CYJE@CXeO@CXNU@CXr Ĝ@CXU@CXe+@CXѷX@CX-
@CXXy=@CXD*@CX*0@CX     @CX     @CX ě@CX-
q@CX1&x@CX6@CX$xG@CX ě@CX-
q@CX>BZc@CXH@CXbM@CXy=c@CXn@CXu%F@CXU@CX9Xb@CX4m@CX)@CX)@CX)@CX
(@CXp:@CX@CX	k@CY_p@CY4J@CY=b@CY:S@CY4J@CY0
)@CY:S@CY[W>6@CYb}@CYb}@CY7Kƨ@CY7Kƨ@CYoiD@CYu@CY2W@CY@CY"`@CY@CYᰉ'@CYR@CY-@CZ	 @CZI^5@CZ1'@CZOv`@CZ䎊@CZ1'@CZ-V@CZ&IR@CZ-V@CZ0U2a|@CZZc@CZa|Q@CZW'@CZQ_@CZJL@CZ6C@CZ-V@CZ#9@CZOv`@CZ0U2a|@CZT`d@CZZc@CZT`d@CZM@CZ^5?|@CZ}Vm@CZ@CZ@CZW@CZ,<@CZC,@CZD@C[I^@C[I^@C[҉@C[u%@C[C,z@C[	@C[,zxl@C["`B@C[)^	@C[33333@C[33333@C[6z@C[6z@C[9@C[C%@C[C%@C[C%@C[F]c@C[F]c@C[F]c@C[J#9@C[P{@C[S@C[W>6z@C[S@C[W>6z@C[S@C[MjO@C[J#9@C[J#9@C[P{@C[MjO@C[J#9@C[J#9@C[C%@C[J#9@C[S@C[S@C[S@C[MjO@C[F]c@C[=K^@C[33333@C[C%@C[J#9@C[MjO@C[P{@C[J#9@C[MjO@C[F]c@C[J#9@C[F]c@C[C%@C[F]c@C[C%@C[C%@C[C%@C[=K^@C[@N@C[@N@C[9@C[/V@C[,zxl@C[)^	@C[&@C[&@C[C,z@C["`B@C[	@C[PH@C[s@C['/@C[҉@C[҉@C[u%@C[I^@CZm\@CZ~@CZ74@CZc	@CZfB@CZfB@CZ䎊q@CZG{@CZ ѷ@CZsP@CZsP@CZ,<@CZW@CZ)_@CZ@CZ@CZ@CZn@CZY@CZY@CZ}Vm@CZ}Vm@CZ ě@CZ>B@CZ@CZS&@CZvȴ@CZᰊ@CZᰊ@CZᰊ@CZ\(@CZp:@CZL_@CZL_@CZݘ@CZݘ@CZ@4@CZ@4@CZ{m@CZxl"h
@CZu%F
@CZnO@CZkP|@CZa|Q@CZa|Q@CZZc@CZZc@CZT`d@CZQ_@CZM@CZGE85@CZC\@CZ6C@CZ)y@CZ&IR@CZ1'@CZe+@CZOv`@CZOv`@CZs@CZ@CZn@CZu%F@CY.H@CYlD@CYY}@CYs@CYR@CYR@CYR@CYe@CY@CYN;6@CYN;6@CY2W@CY|@CY'R@CYl@CY(@CY(@CYR<6@CYR<6@CY@CY~($@CYoiD@CY|Q@CYx@CYu!S@CYo hی@CYhr @CYe+a@CYTɅo@CYQ@CYGz@CYDg8~@CY:S@CY:S@CY7KƧ@CY4J@CY4J@CY4J@CY0
)@CY*0U2a@CY#w@CY@CY+@CY@N@CY@N@CY@CY@CY@CY@CYrGE@CYrGE@CYrGE@CY@CY$/@CY$/@CY$/@CY ѷ@CY	k~@CY@CY	k~@CY	k~@CY@CYrGE@CY@CY@CY$/@CX$tT@CX	k@CX	k@CXC@CX҈p@CX@@CX
(@CX{@CX@CXu%F@CXtj@CXn@CX|@CXu!@CXeO@CX_F@CXU2a|@CXK]c@CXH@CX73@CX ě@CXF]d@CW#@CWrG@CW@CW@CW˒:)@CWvȴ9@CWvȴ9@CWr@CW&@CWkP@CW@CW&@CWlC@CW\(@CWU=@CWH˒:@CW;dZ@CW1@CW.H@CW!-w1@CWv@CW)^@CW
=p@CW hۋ@CV"@CVFs@CV쿱[W@CV1@CV]cf@CVA@CVȴ9X@CVQ@CV}Vl@CVT@CV@CVO;@CV+J@CV%@CVz@CVs@CVvȴ9X@CVs@CVvȴ9X@CVp:~@CVfffff@CVc	@CVR<6@CVE@CV?@CV5?|@CV($x@CV!R<@CV@CV4K@CV
L/@CV_o @CV ѷY@CUC\@CU,=@CU?@CUcA @CUn/@CUsh@CUXy=@CU%@CUݗ@CUzxl"h@CUm\@CUce@CUVl!@CUF
L0@CU<64@CU84֡@CU/w@CU(@CUQ@CU*0@CUK]@CTD@CTZ@CT/@CT>B[@CT?@CT?@CTTɆ@CT3@CT_@CT#@CT~($x@CT~($x@CTtSM@CTcA \@CTFs@CT(\@CT!-w2@CTtj@CT@CTn.@CS҈@CS|@CS6@CS@CSS@CSwk@CSA@CS{J#9@CS]cA@CSP{@CSC%@CS9@CS/V@CS)^	@CS	@CSC,z@CS'/@CSI^@CR ѷ@CR<64@CRg	@CR ě@CR>B@CRS&@CRS&@CRL_@CRnO@CRZc@CRQ_@CRJL@CR@4n@CR6C@CR3@CR)y@CR1'@CROv`@CR@CRI^5@CRu%F@CQ-@CQ>BZ@CQ>BZ@CQe@CQe@CQԕ*@CQԕ*@CQ2W@CQ^5?}@CQX@CQB@CQl@CQB@CQn.@CQn.@CQn.@CQ'RTa@CQu@CQ'RTa@CQ@CQu@CQ@CQ@CQo@CQ@CQ@CQ~($@CQ~($@CQ7Kƨ@CQ@CQoiD@CQ@CQ@CQb}@CQb}@CQb}@CQb}@CQ|Q@CQu!S@CQu!S@CQrGE8@CQrGE8@CQo hی@CQae@CQ[W>6@CQ[W>6@CQXbM@CQ[W>6@CQTɅo@CQQ@CQN;5@CQN;5@CQDg8~@CQA [@CQ:S@CQA [@CQ=b@CQ:S@CQ:S@CQ7KƧ@CQ4J@CQ0
)@CQ-w1@CQ*0U2a@CQ*0U2a@CQ#w@CQ+@CQ	k~@CQ ѷ@CP$tT@CPC@CPC@CPC@CPe+@CPe+@CPe+@CP҈p@CPۋq
@CPD@CPD@CPD@CPD@CPѷX                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           @jHnO@jlz@jikP@j^YJ@jL0U2a|@jm	@jp64@j{@N@j:)z@j@j^@j͞&@jhr @jYJ@j#x@jDg8~@j	 @k@k0'RT`@keO@lMjO@l|@mAL_@n&@mFt@o]5Xy>@pU@oB@oQ@o@oo@o<64@o@o]ce@ohr @o`A@pQ@p;vȴ@p}|hs@pjA@p1&@o>BZc@oܦL/{@oiB@p\(@pBZc @oЌ@oL/{J@o[!-w1@o:m@oO[W>@o%@@n&IR@nU=@ndR<6@n0
@n6z@o~$@nKƧ@nm]@n~*0@nu˒:)@n_Q@n53@nOv`@m!.H@meں@mߤ@my?@mrzxl"@mV[W?@m#=b@lkP@l[@lwkP@lyoiD@lGrGE8@l.a|Q@l!ԕ*@kzxl"h@k,=@kc	@kF]c@k+@km@ks,=@kAԕ*@kC\@ku%F@j?@j˒:*@jlD@j~@jR,<@j2ᰊ@jNU@j IQ@iQ@j*0@i\(@i־ߤ?@iֹY@i~@i,<@i4֡a@iXy=@i}B@iQ33333@iAS@i\D*@izѷX@i`iB@i@s@i@qiC@ioiD@h1@h
qv@hYJ@hGz@hY@h䄵?@h֖@hϚkP@h|@hȣS&@h ѷY@h
(@hya@N@hrhۋq@hp$tT@h&I@h_o@h?@h̠-
@hfA@hԕ*@h%F
L@h$@h1'@hT`d@h^@h5Xy@h@N@hC-@htj~@hN@hE͞@hR(\@hIϪ͞@h=JE@hL\(@hY҉@h[_o@hT>B[@hFm@h?ڹ@h;Ϫ͞@h9 hۋ@h;a@O@h7$@h;H˒@h7O
@h0쿱[@h&x@h䎊@h7KƧ@hC,zx@g"`B@hIQ@gO;d@ga@N@gS&@gE@g2W@g	k@gV@gE@g&x@gl!-@gІYJ@grGE@ge+@gO;@g$t@g9@gq@gn.3@gT@g!-w1@gVϪ@gce@ga@@g(@gA7K@gtj~@gᰉ'@gn.3@g*0@g_o @g ѷ@g73@g=K@gI^5@g~Ov_خ@gm@gt-
@gn!.I@gl4m9@gh_o @gZ!R<@gUE@g[b}@ga҉@gUVϫ@gS$tS@gIhr @g8@g4qj@g5-@g-$tS@g"z@g#@g.\)@g3Q@g;sPH@g,)y@g'ڹ@g-7Kƨ@g)]cA@gO
M@g%1@g3u@g,}H@g=K@g	ԕ+@gNU@gwkP@geں@gA [@fo@g
|hs@gA7K@giB@g	JE@f@fr Ĝ@f6@fئL/{@fO
M@fߔO
@fxF]@fS&@f.H@fOv_@fqj@f$tT@f8Y@f_ح@f-V@f"`@fq@fA [@fp:~@f6z@fe+@ftj@fO;dZ@fxF]@fZ1@f.2@fJ#9@fsg@f!-w@fպ^5?}@f@@fъڹZ@f+@fcA @fD@fsP@f6z@f~"@f-@f
=p@f~@f%F
L@fzxl"h@fϪ͞@f#w@fQ@f1@fF]d@fJ#9@f@fVu@f!R@fq@f|4m@f($x@f҈@fE@f@f{J#9@fr>@fiA [@f_oiD@fN>B[@fS@fbH@fk.H@f{F
L0@fbM@f|TɆ@fXqi@fBQ@fE*0@fF{m@f;]cA@f. ѷ@f&p:@f1n.@f;\(@fFwkP@fW!.H@fY,=@fW@fFr Ĝ@fC͞@f@Z@fCl@fBFs@f@u"@f>e+@f9C]@f8'RT@f?zxl"h@f.A@f&y=c@f01&x@f#[W>@f$/@fZ@f	KƧ@f@f'RTa@fn/@fXy=@eu%F@eq@eH@efA@eFs@eF]c@eD@ebM@eѷX@e6z@enO@eC,zx@es@ev@eD@eT@es@e#w@e	k@e-@ex@e3@e0U2a|@e/{J#@eL/{J@eM:@eJL@e$@e@e1@es@eE@ee@e~Vu@eC,z@epq@ef4m@eeS&@ea'/W@ecC]@eQ;dZ@eE_o@eSB@e^^5?|@eMm]@e:@4n@eBᰊ@eBᰊ@e8]cf@eH#9@e8]cf@e-H˒@e0YJ@e1rG@e-@e,YJ@e(.2@e/ [7@eA,zxl@eLH@eCE@eB-
@e;-V@e41&@e6ߤ@@e4d8@e,T`d@e0~($x@e-X@e(($x@e(($x@e,R<6@e|hs@eRT`e@enO@e4@e/PH@enO@e(@e(&IR@e&7@e!4J@e0zG@e(%1@e%]cA@e"@e$tS@e($xG@e*JM@e"*1@e#@e"Fs@e$/@e$/@erG@e	@eZ1@e>BZ@e}Vl@eJ#9@e%@eI^@e:~ @eH˒:@ee@eo h@e,<@eȴ9X@e6z@ec	@equ!@eF]c@eF@e=K@e,<@e~"@e	~($@e(\@eڹ@e($x@eC%@ePH@e
E@e
qv@e5?|@ePH@e*0@e
3@e		@ezG@eiB@ePH@ez@e1.@e?@e$xG@e\(@e	&@e
JM@e0
)@e[W>6@eL/{J@e!.@eZ@e)^@e<64@e
zH@evȴ@eW@eɅoi@e쿱[@e@e
B@e^5?}@eVϪ@erGE@en.@es@e:S@e
=p@e'/@e@@e@@e
䎊q@e
䎊q@e}H@eqiC@eqiC@ewkQ@e.H@e?@eԕ*@eq@eb}V@em\@eae@eae@e@e@e(\@eR<6@e!_p@eq@e҉@esh@e(
L/@e#@e5Xy>@e0
@e#@enO@eC\@e)n.3@e%B@eN;6@e&IR@e,3@e%As@el!-@e쿱[W@e&zxl"@e3$tS@e1D@e"z@eOv_خ@eC@e$/@e$/@eu%@eu%@e\@e*p:@e-$@e,1.@e8{@e.74@e&@e'R@e&@e1@ex@eiB@e"h	ԕ@e#"`@e)hr @e0Z1@e-@e&af@e%=b@e!R<@e@e#b@e,.2@e5lC@e7JE@e:4K@e?U=@e8U@e1n/@e%<64@e-hr!@e5,=@e5,=@e7J#9@e8U@e5@e5@e<sP@e?-V@e8>B@e>:)y@e>:)y@e<֡a@e81&@e7H˒:@e-@e(u%F@e7H˒:@eA hۋ@eBcA \@e>9XbN@e@$tT@eNC-@eMb}@eE*0U2a@e>8YJ@e5S@e1@e4˒:*@ePE@eNe+@eUa@@eIS@eBbM@eS@eNe+@eCo @eE(@eL6@eQ&@eS'0@eQ&@eTnO@eS'0@eJ?@e4}Vl@e:xF@eJ'@eQ(@eW4֡a@e\7@eLtj@eIP{@eCa@O@eN҈p@eU|@eTl!-@eQS@eW4J@eXO;@eU|@eYC\@e^$/@e`C@e\TɅ@e\n@eYrGE9@eW2a|@eSK]@eN/@eTkP|@ep1&x@et[6@efxl"h
@eX*1@e[\(@e_&@ee[@ei?|h@ej3@e_oiD@emiDg8@euvȴ9@eln@eY@eW0
)@elJ@erFs@emhr @ejaf@emhr @ent@etYJ@e~@e|}Vl@e@e.H@e+@eu!S@e;5X@efffff@e;5X@e ѷ@efffff@e,zxl@e;5X@e@e|U@e;5X@e@e~bM@e@e`A7@eOv_@eVl!@e䎊r@eY@eVl!@e䎊r@er Ĝ@eqiC@eK]d@e-V@e#x@eGE85@eZ@es@es@ecA \@e~ߤ@@eGE85@eQ@e hۋ@ey@ecA \@el ѷY@en@@e{Gz@e|6z@eTɅo@e*0U2a@eƧ@eƧ@eF@eF@e8Y@e)^	@e=K@e~
qu@ep
=@eo @euX@e6C@eD*@e@eD*@enO@enO@eu"@eN;6@elD@e?@e64@e64@e@e!.I@e4֡a@elD@eQ@eѷX@eA@eѷX@e{C%@e&x@e'@eC]@eP{@e9Xb@e'RT@eBZc @es@eP{@eP{@e@e	k~@eBZc @e{J#9@e4m9@e~@ev@ev@e ѷ@el"h	@e33333@e9Xb@ev@e ѷ@e@eu%@e@e@e ѷ@el"h	@el"h	@eu%@eu%@eP{@eu%@eu%@eA7K@e$/@eϪ͞@e_F@eO;dZ@e@el"h	@ev@eu%@eVϫ@eA7K@e]cA@eC\@eu%@el"h	@eA7K@ezxl"h@eu%@e ѷ@eO;dZ@ezxl"h@eA7K@el"h	@ev@eO;dZ@eA7K@e@eC\@eϪ͞@ev@eu%@el"h	@eϪ͞@eC,@e3@el"h	@e]cA@eC\@el"h	@el"h	@eC,@eݗ@eC,@e+@eA7K@eC,@e\@e2a|@e$xG@e$xG@e\@eK]@erGE9@eC,@es@erGE9@e2a|@e-V@e-V@ekP|@e@4n@erGE9@eNU                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           ?#?sg?S&?/Vϫ?lC?#?'RT`e?hr Ĝ?dZ1?
qu"?o ?u!.?ݗ+?S?QR?N;6?lD?E?$tSM?g8}H?TɅ?KƧ?9XbM?@4m?Z?xF]?.H?+jg???x?JD?Q?p:~?+jf?*0U?zG?$?rGE?eO
?#?H˒:*?*0?y?}H˒?4m8?
M:?Dg8}?=b?^?C\N?T`d?c	?s?JL?-V?=b?jOv`?ċC%?
M:?v_ح??ˎMj?u%F?͡o?̘_F?/{J#:?%1?>B?ѷX?JL?*0
?	k~(?`A7?!-w1?o?JL_?sP?˒:)z?QR?*0
????|hs?Ƨ-?୫U=?\N<?zxl"h
?;dZ?!.H?Q?As?ݗ+j?Z?t?ڙ0
)?qu!S?֚,<?m\??5Xy>?*0
?@NU?ۋq?)^	?>BZ?iDg8~?[?Ѽn.?lC?8}H?(?䎊?F
L/?wkP??wkP??Κ,<?}H˒?ˬq?Κ,<?Xe+?cA [?a@N?4m8?`A7K?+?g	k?˘@?@4?!R<6?Ϫ͞?Z?Y|?E??m?xF]?.H?BZc?s?K]cA?s?*0U2a|?,<?(?J#9?73?qiC?\N;?($xG?#wk?/V?E?	ԕ*?S&?JD?1o??S&?R<64?333333?Z?GzH??{m?,<?m8Y?*0U2?(\)?D*0?C,zxl?!-w1?Xe+?0
(?u%F?&?	 ?Z?ɅoiD?p:?:)y?<64?~Q?a@N?ᰉ'?*0?zvȴ9?y_o ?rsPH?C,zxl?L_?E?fA?Y}?䎊r?%2?ae?*0?҈?tj~?fA?tj~?ݗ+j?q?ᰉ'?zvȴ9?nO;?|1&y?`A7L?sg?ݗ+j?6C-?_Ft?=K^?tj~?$tSM?}Z?Ov_خ?u!?Zݘ_!-w1?|1&y?~Q?n/?ᰉ'?=K^?O
M?$tS?u%?=K]?U=K?sg?{?{Q_?u"?҈?)^	?$/?ݗ+j?*0U2a?Mj?:)y?n/?`d8?Ϫ͞??:6C-tn?!-w1?H?@?,<?{u%F?ie+ao!-w1ſc*0U2a?},<?|C,zxlZ6C-?u"?sg?Q_p?[Q_?ku%F?-
qv?sg?=K]?*0U2a?a@N?f?*6C-?L_??{Q_]}H˒?)^	?҈?4J?`d8?E˿C*0U2a?U=K?ie+a?S&?䎊q?y_o ?C,zxl?qu!S?$tS?|C,zxl?}}H˒?Z?Ϫ͞?_o bn/?|1&yo䎊q޿m}H˒?pbMF?tZ?䎊r?sPH?},<?~Ov_ح?bn/?Xtj~?N;5?	 ?!-w1?-
qv?-
qv?rsPH?J6C-?N;5Xtj~?w?zvȴ9rnO;vǿwXe+?f?	 ???z6C-?xPHhtj~?ye+a?u%F??6C-pbM?bsPH???sPH??>BZc?Z?Zݘ?z6C-rn/nO;q4J?wkP?*0?Z?쿱[W??ߤ??y_o ?Ov_ح?bMUL_?wXe+?~Q?z6C-?s@NU_!-w1?sPH?{qu!S?ye+aeL_?H?҈?},<[Q_?tZ?}H˒?tj~?o䎊q?쿱[W??zvȴ9?bM?~Ov_ح?xPH?zvȴ9?x*0
?xPH?4J?sPHc*0U2auL_?`bM?-V?tj~??wkP?tzG{?}}H˒?[Q_UL_?c*0U2awXe+Կ*6C-?Zݘ?S&?XenOv_ح?n/?ye+a?s@NUbsPH?6C-?w?}Z?u!?n/?m}H˒?$tS?tj~?@?N;5?sPH?)^	?q4J?{qu!S?@NU?4JfOv_خ?q4J?uL_?rnO;?3*0U2a?n??z6C-??	 ?!-w1?R<64?z6C-?4J?p:?Z?>B?sg?҈?!-w1ſZ6C-?S?$/ku%F        ?|1&y?6C-?SٿS*0U2a3*0U2a?_o?s@NUfOv_خ?	 ?~Ov_ح?N;5ku%F?uL_?l?Xe+Կ:6C-?$tSM?]}H˒wXe+?ye+a?Q?+I?L_?*0?%2?ye+a?kQ_?z6C-?l?bM?,<쿱?*0?*0U2aXtj~?c*0U2a?zvȴ9@bM@bM?v+I?PH?-V?{u%F?+I?O
M?tj?sgx*0
?o䎊q޿usg?uL_?&F?_o ?"`A??E?O;dZg?fOv_خ?Rn/fOv_خ?ie+a]}H˒?S&?4J??|1&y?ye+a?sPH?}Zhtj~tZ??쿱[W??ye+a?zvȴ9?$tS?w?tn?rn/?҈?N;5X?tn?n/?S&?-
qv?vOv_خ?w?y_o ?y_o ?	 ?,<?&?u%F
?rn/?UL_bMs*0U2a?|C,zxl?p:?uL_vOv_خxtj~?o䎊q?o䎊q?wXe+ԿdzG{?tzG{?z6C-`bMRn/?_o?4J?eL_?l1&y?tn?v+Im}H˒?}Z?|?s@NU?w??@NUbn/?Q?S&?ye+aUL_?:6C-?kQ_V?3*0U2a?*0?Mj?!-w1?*6C-?Fs?,<쿱?PH?tj~?Y}?Fs?v?z6C-?kQ_?tzG{?z6C-?tn?+I?@NU?qu"?xtj~?}H˒?zG{??vȴ9X?bn/!-w1ſm}H˒?`bM~Q?f?p)^	?{?}}H˒?o䎊q?o!-w1?Ov_ح?+I?n/?U=?C,zxl?x*0
?S*0U2a`bM?}}H˒?l?nO;?S&?rn/nOv_ح?`A7L?ye+a?w?rsPH?vȴ9?PbM{u%F?sPH?=K]?tj~??]}H˒?rn/?6C-?Z6C-|C,zxlzvȴ9?䎊r?@NU?tnqu"?@bM?C,zxl?htj~?N;5?+I?bn/eL_!-w1?:6C-?$tS?qu"?w?qu"?kQ_s*0U2a?o!-w1?ie+a?nOv_ح?rn/o!-w1?C*0U2aku%F:6C-?dzG{htj~҈?fOv_خ?,<쿱?U=KPbM?u"?{ſ_!-w1?S&?)^	g?%2?)^	rsPHv+I?nO;?O
M?Ov_ح?R<64?ᰉ'?+I?ɅoiD?n/?wXe+?ye+a?Z?L_?<64?xtj~tzG{?䎊q?hr Ĝ?$tS?Mj?䎊q?tn?M}H˒?Z6C-?-V?+I?Q_?-
qv?zG{?N;5Rn/?Z?U=?s*0U2a~Ov_ح?qu!S?v+I?$tS?6C-?1&y?L_?-
qvm}H˒?eL_?q4J?O;dZ?n{u%Fa4J?<64?{qu!S?usg?p:?䎊r?v+I?vȴ9X?ku%F?Q?ߤ??v?}Z?pbM?s*0U2a?qu"?l1&y?x*0
?vOv_خpbM?rsPH?*0?Mj?rnO;?xtj~?}}H˒?U=K?L_j6C-?Z?u"PbM?_Ft?2a|Q?y_o zvȴ9?v?@?tZ?q4J?htj~?v+I?N;5?Z?q4J?Rn/?|C,zxlie+a~Ov_ح},<rn/:6C-?Vǿ{Q_?s*0U2a?*0U2a??u%F?Xe+?o䎊q?u%F
?F?@bM?_o ?N;5X?O;dZs@NU?x*0
?sg?_o?Q_?ᰉ'q4J?usg?l1&y?dzG{?<64?o!-w1ſ]}H˒?tnku%F?zvȴ9?ye+a?N;5??a4J?c*0U2a?s@NU`bM?xtj~?!-w1?_!-w1?u"?Z?0
(?C,zxl?sg?zG{?hr Ĝ?S?usg?{?	 ?z6C-?@NU?sg?_Ft?bsPHpbM?IQ?F?bM?R<64|C,zxl?M}H˒?j6C-?hr Ĝ?ie+a?+?Ov_ح?xPH?Xe?҈?}H˒                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           ?????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????ə???????ə????????????????ə?ə??????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           &B)Aff36	-15                                      1                                       