CDF       
      time      pressure  	   latitude      	longitude         string_dimension   (         EXPOCODE      29AJ20160818   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    WOCE_ID       TAlPro     	DATA_TYPE         WOCE CTD   STATION_NUMBER        10     CAST_NUMBER       1      BOTTOM_DEPTH_METERS          
Creation_Time         2020-03-19T19:50:17.740906Z    ORIGINAL_HEADER      CTD,20200319CCHSIO
# Converted CTDOXY from ML/L to UMOL/KG using the following:
#     https://github.com/TEOS-10/GSW-Python, downloaded 2019-06-26
#     gsw.sigma0:  Calculates potential density anomaly with reference pressure of 0
#     dbar, this being this particular potential density minus 1000 kg/m^3.
#     This function has inputs of Absolute Salinity and Conservative
#     Temperature.  This function uses the computationally-efficient
#     75-term expression for specific volume in terms of SA, CT
#     and p (Roquet et al., 2015).
#     http://www.teos-10.org/pubs/gsw/html/gsw_sigma0.html 
#     Python equation used:
#         oxy_UMOL_per_KG = oxy_ML_per_L * 44.660 / ( (1000 +  gsw.sigma0(SA,CT)) / 1000. ) 
# Data source:  https://doi.pangaea.de/10.1594/PANGAEA.902330
# SHIP: RV Angeles Alvarino
# Cruise: MedSHIP cruise TalPro
# Region: Mediterranean Sea and Catalan Basin
# Ports: Palermo, Italy to Barcelona, Spain
# DATES: 20160818 - 20160829
# Chief Scientist: L.Jullion
# 43 stations
# Original file in AWI format. CCHDO Converted to Exchange format
# EVENT_CODE=unknown
# DATE: YYYYMMDD
# TIME: HHMM
# LATITUDE: degrees_North
# LONGITUDE: degrees_East
# STNNBR:  removed leading 0s from STNNBR
# CASTNO: not supplied by originator - CCHDO assigned all CASTNO=1 or CASTNO=2 for stations 11, 29
# CTDSAL: changed units from Practical to PSS-78.  Data values remain unchanged.
# CTDFLUOR: changed units from UG/L to MG/M3 as they are they are equivalent
# CCHDO added flags=2 for all parameters, as T.Tanhua notes all params are calibrated and CTDOXY calibrated with bottle samples
# Removed two test sample depths from event/station 004, dTalpro_Stn04_test_1db
# Data precision preserved as submitted.
# CTD: Who - T.Tanhua; Status - calibrated,final
#     Includes: CTDSAL, CTDOXY
#     CTDTMP NOTE: Used first occurrence of primary temperature sensor in original data file
#     CTDSAL NOTE: Used first occurrence of primary salinity sensor in original data
#     NOTE: Physical parameters temperature, salinity, oxygen, density, turbidity, chlorophyll, fluorescence are published on PANGAEA, DOI above.
# Fluorescence (CTDFLUOR): Who - T.Tanhua; Status -final
#        Instrument: WET Labs ECO-AFL/FL, FLNTURTD-2526
#        ScaleFactor: 1.00000000e+001
#        Dark Output: 0.0760
# Turbidity (CTDTURBDTY): Who - T.Tanhua; Status - final
#        Instrument: FLNTURTD-2526
#        ScaleFactor: 5.000000
#        Dark output Voltage: 0.070000
#
# Reference: Cruise report: https://epic.awi.de/id/eprint/49725/1/TAlPro_EUROFLEETS_cruise_report_V2.pdf
# CCHDO page: https://cchdo.ucsd.edu/cruise/29AJ20160818
# Metadata from original file
#     Event(s):     TAlPro-2016_010 (10) * LATITUDE: 40.880000 * LONGITUDE: 10.580000 * DATE/TIME: 2016-08-21T06:07:00 * CAMPAIGN: TAlPro-2016 * BASIS: Angeles Alvarino (URI: http://www.eurofleets.eu/np4/285.html) * DEVICE: CTD/Rosette (CTD-RO)
#     Citation: Tanhua, Toste (2019): Physical oceanography during MedSHIP cruise Talpro. PANGAEA, https://doi.org/10.1594/PANGAEA.902330
#     Abstract: The TAlPro cruise (Palermo - Barcelona, RV Angeles AlvariÃ±o, 18/-8/2016 - 29/08/2-16) occupied three hydrographic transects across the Tyrrhenian Sea, the western Mediterranean Sea and the Catalan Basin (Fig. 1) as part of the MedSHIP programme (Mediterranean Ship-based Hydrographic Investigations Program). A total of 43 stations were occupied during which physical (temperature, salinity, pressure, velocity), biogeochemical (oxygen, nutrients, carbonate system, dissolved Barium, oxygen and nitrogen isotopes) and anthropic (CFCs, SF6) parameters were measured in order to monitor the physical and biogeochemical state of the Mediterranean Sea.
#     Related to: Jullion, Loic (2016): TAlPro-2016: A Tyrrhenian Sea & Alger- provencal component of the MedSHIP Programme. hdl:10013/epic.5a866780-1f8a-45cf-8111-47b2b5dc29db
#     Parameter(s):
#         Event label (Event) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Sample code/label (Sample label) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Date/Time of event (Date/Time) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Latitude of event (Latitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Longitude of event (Longitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Pressure, water [dbar] (Press) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Digiquartz
#         Temperature, water [Â°C] (Temp) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: ITS-90
#         Oxygen, dissolved [ml/l] (DO) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 43
#         Turbidity (Nephelometric turbidity unit) [NTU] (Turbidity) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO
#         Fluorescence, chlorophyll [Âµg/l] (Fluores) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO-AFL/FL
#         Salinity (Sal) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Practical
#     License: Creative Commons Attribution 4.0 International (CC-BY-4.0)
   WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            pressure               	long_name         pressure   positive      down   units         decibar    data_min      @         data_max      @6        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      H  '   pressure_QC                	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      0  o   temperature                	long_name         temperature    units         ?C (ITS-90)    data_min      @*$xG   data_max      @9"   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       H      temperature_QC                 	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      0     salinity               	long_name         salinity   units         PSS-78     data_min      @BPH   data_max      @C^Fs   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      H     salinity_QC                	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      0 %   oxygen                 	long_name         oxygen     units         ?mol/kg    data_min      @d%   data_max      @oحV   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        H 7   	oxygen_QC                  	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      0    CTDFLUOR               	long_name         CTDFLUOR   units         MG/M^3     data_min      6C-   data_max      ?ݎ!R<   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      H    CTDFLUOR_QC                	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      0 ې   	CTDTRBDTY                  	long_name         	CTDTRBDTY      units         NTU    data_min      ?   data_max      ?   C_format      %f     WHPO_Variable_Name        	CTDTRBDTY      OBS_QC_VARIABLE       CTDTRBDTY_QC     H    CTDTRBDTY_QC               	long_name         CTDTRBDTY_QC_flag      units         
woce_flags     C_format      %1d      0 6   time                	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      &/   data_max      &/   C_format      %10d       H   latitude               	long_name         latitude   units         	degrees_N      data_min      @Dp
=q   data_max      @Dp
=q   C_format      %9.4f          H   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      @%(\)   data_max      @%(\)   C_format      %9.4f          H   	woce_date                   	long_name         	WOCE date      units         yyyymmdd UTC   data_min      35   data_max      35   C_format      %8d        H   	woce_time                   	long_name         	WOCE time      units         hhmm UTC   data_min        _   data_max        _   C_format      %4d        H   station                	long_name         STATION    units         unspecified    C_format      %s        ( H   cast               	long_name         CAST   units         unspecified    C_format      %s        ( H@      @      @      @      @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @
     @     @     @     @     @     @     @     @     @     @     @      @"     @$     @&     @(     @*     @,     @.     @0     @2     @4     @6     @8     @:     @<     @>     @@     @B     @D     @F     @H     @J     @L     @N     @P     @R     @T     @V     @X     @Z     @\     @^     @`     @b     @d     @f     @h     @j     @l     @n     @p     @r     @t     @v     @x     @z     @|     @~     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @
     @     @     @     @     @     @     @     @     @     @     @      @"     @$     @&     @(     @*     @,     @.     @0     @2     @4     @6     @8     @:     @<     @>     @@     @B     @D     @F     @H     @J     @L     @N     @P     @R     @T     @V     @X     @Z     @\     @^     @`     @b     @d     @f     @h     @j     @l     @n     @p     @r     @t     @v     @x     @z     @|     @~     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @
     @     @     @     @     @     @     @     @     @     @     @      @"     @$     @&     @(     @*     @,     @.     @0     @2     @4     @6                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             @9"@9*0U2a@9iB@9:)y@9YJ@9vt@9n
(@9f@9`4m@9YY}@9Ahr @9#9@8˒:)@8|Q@8$/@8ܬ1&@8YJ@8҈p:@8ĕ*1@8`A7@8vR<6@88bM@7?@7ө*0U2@7Q@7_Ft@6nO@6ZG{@5;5X@5)^@5\N@4`A@4䎊@4f@3n.@2'RT@2R<6@2m@2g@12W@1D3@1E@0@@0Fs@0M:@0q@0~"@0nzG@0hQ@0P-
q@0;J#9@04SMj@0!o@0Q@/҈p;@/ڹZ@0 'RT@0!.I@06@0g8}@0&@/[@/0
)@/Gz@/j~#@/ߊ	@/64@/qu!@/vaf@/S@N@/
(@.Xy=@.+j@.As@.&I@.kP|@.Ƨ-@.Ňݗ@.Ňݗ@.wkP@.@.r Ĝ@.8}H@.
L/@.{qu!@.fs@.N}Vl@.<쿱[@.-U=@.*=p
@.$qj@.|hs@.64@.sP@--
@-\)@-c	@-ʦL/{@-dZ@-@-|Q@-S&@-fA@-}ڹZ@-y#w@-{A@-mO;dZ@-[6@-S@-R䎊q@-;6@-(@- NU@-J#9@-y=c@-E@-iDg8@-	@-&IR@,~($@,䎊q@,<쿱@,'/@,҈@,@,6C@-9@-	7KƧ@-
fB@-u%F
@,j~#@,O;d@,3@,4֡b@,vȴ@- n@, ѷY@,3@,}H@,z@,j~@, hۋ@,:@,|@,|@,@,@,ÈeO@,u%@, ѷ@,@,xF@,U=@,#w@,%F
L@,
M;@,k~(@,;dZ@,S&@,|Q@,64@-S@-e@,$@-Q@-p:@-t@-
D@-
qu"@-
V@-
=q@-xl"h
@-G{@-5?|@-"@4n@-(K]c@-2ᰊ@-6Ov_@-0)^@-1@-4@-3&@-8F]d@-7@-3MjO@-/v@-/r@-'_o@-$tSM@-$M:@-$7@-%o i@-#S@-!o@-"@-#wk@-%`A7L@-(eO@-*~"@-)lD@-(\)@-#S@- 	k@-vȴ9X@-iB@- ҈p@-	@-
(@-~$@-a|Q@-'R@,Q@,>BZc@,͞&@,`A@,I^5@,K]c@,p:@,쿱[@-"h	ԕ@-qu!@- ѷX@-$e@-&]cf@-&]cf@-(ۋq
@-(@-(@-#@-b}V@-حV@- ѷY@-j~#@-"`B@-)@-sPH@-,<@-҉@-{m@-{@-@4@,)_@,Y@,Q@,@,=p
@,'RTa@,@,ߤ?@,+@,_F@,Vϫ@,C,@,p
=@,PH@,1@,sg@,a|Q@,U2a|@,}Vl@,C]@,'@,-@,Fs@,䎊r@,tj@,C-@,*0@,ݗ+k@,ᰊ@,D@,}Vl@,8Y@,(@,<쿱@,U=@,D@,ڹY@,C,z@,)^	@,L_@,<쿱@,L_@,1&y@,qu"@,͞@,u!S@,T`d@,ݗ+k@,YJ@,q@,!.H@,tj@,fffff@,_o@,zH@,&@,zH@,˒:*@,@,9Xb@,lD@,~($@,"h	ԕ@,I^5?@,P{@,{J#9@,o@,NU@,-w1@,v@,~$@,!R@,!R@,#@,5Xy>@,1&x@,fA@,1&x@,IQ@,]cf@,+a@,\N@, ѷ@,&IR@,TɅo@,˒:)@,},=@,|64@,{/V@,zc	@,z,<@,}IQ@,{~$@,z@,x73@,t֡a@,rm@,o@,l_@,mM:@,n.2@,jD@,fFs@,eڹ@,be+@,a|Q@,ao hی@,ao hی@,a|Q@,b`A@,ezxl"h@,fs@,eڹ@,e8YK@,e@,e1@,e8YK@,fYJ@,f@,f@,f,<@,g,@,gRT`e@,e`A7L@,dxF@,eo i@,do h@,bM@,ae@,bZc@,be+@,a7Kƨ@,`C@,a@,h$xG@,k]cA@,g-@,`-
@,]cA @,\hr@,`[6@,dTɆ@,eo i@,d7@,c@,_|hs@,V8YJ@,RsP@,R{m@,Sa@O@,X73@,_Ft@,cZ@,gK]d@,kxF]@,kƧ@,kC%@,ezxl"h@,cnP@,bZc@,bwkQ@,cwk@,`
qu@,^6z@,^@,^"@,_vȴ9@,`6@,d?@,dqj@,cF]c@,d?@,dg8}@,d*0@,ca@N@,\?@,^iB@,_o@,as@,c	@,cwk@,cwk@,bZc@,`n@,`hۋq@,`n@,a:S@,b@4@,cwk@,d/@,eF
L0@,eQ@,em\@,e`A7L@,dZ1@,cS@,bu%F
@,b3@,a@,`[6@,_b}V@,_?@,`A7K@,`	k@,as@,b@,c
=p@,dtj@,d?@,c9@,bwkQ@,as@,as@,a [7@,_حV@,\(\@,Y|@,T,<@,L"h	ԕ@,H$xG@,G@@,H	ԕ+@,HXy=@,H9Xb@,H9Xb@,Hۋq
@,Nqi@,Qu!S@,Ql@,Ql@,Q2W@,Qu@,Or@,NMj@,O hۋ@,Rp:@,TSMj@,TSMj@,TJ@,S@N@,Q_p@,K҈@,KU=@,JڹY@,J	 @,I^5?}@,Iy@,Iᰉ'@,I^5?}@,IQ@,JڹY@,K:)z@,KC%@,I@,IrGE@,Fx@,Fx@,GRT`e@,H@,Hۋq
@,Iᰉ'@,Iᰉ'@,I@,I^@,JOv`@,IDg8~@,F$/@,DJM@,Dtj@,Do h@,DTɆ@,DM:@,D2W@,Do h@,ES&@,F@,GK]d@,H@,I@,I@,IoiD@,Hp:@,IrGE@,E@,> ѷY@,;s@,9+@,8Q@,6Ϫ͟@,6_ح@,6Ov_@,5!R@,6+jg@,6+J@,4Z@,4Fs@,5Ϫ͞@,6+J@,6Ϫ͟@,7kP@,7+j@,7rG@,7O;d@,4D@,3g	l@,1X@,0@,/ hۋ@,.+@,.zG@,-:@,,~($x@,+]cA@,*͞&@,*W'@,)^5?}@,(p:@,'-@,&'@,%S&@,"}Vm@,!-w1@,s@,6C@,+@,O;d@,rG@,YJ@,-
@,XbM@,ȴ9X@,|@,m@,sP@,W@,p:@,n@,o@,N;5@,@,
8Y@,[W?@,C]@,1&y@,[W?@,@,
5Xy>@,
M:@,
U=@,
(@,
8Y@,a@@,@,E84@,ݗ+@,+I@,S&@,/@,ݗ@,ݗ+@,	@,	^5?}@,	k~(@,˒:*@,ݗ+@,fA@,	ԕ+@,_o@,+I@,Fs@,@,	 ѷ@,˒:*@,
qiC@,I^@,	@,$xG@,`A7L@,A [@, A7K@+ce@+[@,n.@,%1@,qj@,+a@,2W@,Z1@,tj@,{J#9@,wk@,
=p@,
=p@,
=p@,%1@,%1@,eO@+H˒@+e+@+#w@+@+@+3@+!-w2@+@+S&@+-V@+GE85@+u!S@+$tT@+@+4֡a@+C\@+zG@+2X@+;5X@+c	@+ hۋ@+v_ح@+Mj@+(@+5Xy>@+B@+_@+s@+唯O
@++a@+e@+TɆ@+㯷@+n.3@+F]c@+,zxl@+9@+ⶮ}Vm@+Gz@+Vl!@+5?|@+ޞ@+ߤ?@+ߤ?@+p
=@+ۥS@+]ce@+64@+u%@+ڟvȴ@+>BZ@+_F@+@+Ϫ͟@+R<6@+Ϫ͞@+՛=K@+sg@+ө*0U2@+W@+PH@+ըXy=@+C-@+
=p@+Xe@+@+?@+sg@+,<@+Z@+҈p:@+:)y@+@+Vu@+.2@+c	@++@+:~ @+&x@+ѩl@+ќu@+a|Q@+҈p:@+:)y@+4J@+ ě@+1@+Ίqi@+;5X@+@+
qv@+
qv@+p:~@+ϝ-V@+Vϫ@+H@+oiDg8@+Ж@+Ж@+а{@+`A7@+&x@+A [@+_p@+4J@+@+rGE9@+ξߤ?@+Vu@+C\@+~($x@+)^	@+0U2a|@+JL@+͞&@+ʌL_@+>BZc@+RT`e@+ƚ,<@+&I@+A@+x@+x@+e@+nP@+ [7@+4m@+-w1@+@+ae@+:S@+vȴ9@+˒:)@+     @+
qu@+䎊r@+m\@+-V@+Z@+j~#@+5Xy@+q@+c	@+vȴ@+D@+0
)@+bM@+sPH@+1@+@+Fs@+4K@+ᰉ@+$/@+*1@+`d@+ߤ@+@N@+䎊q@+W@+T`d@+As@+zxl"@+1&y@+D@+JL@+zG@+;dZ@+-V@+}Vl@+Dg8~@+YJ@+74@+o hی@+4m9@+;dZ@+o@+o@+H˒:@+H˒:@+	@+$tS@+v@+Q@+j~#@+1&@+C,zx@+4֡b@+4֡b@+}H@+1@+sPH@+@+_ح@+4K@+YJ@+hr@+m]@+	k~@+R<6@+8YJ@++J@+}H@+@@+=b@+~($@+Xe,@+䎊q@+*0U@+{J#:@+qi@+!R<@+w1@+O;dZ@+@+C]@+U=@+xF]@+Ƨ@+qu"@+!R<@+ hۋ@+iDg8@+@+ ě@+@+:~ @+bM@+͞@+@+C]@+1&y@+L_@+"h	ԕ@+VϪ@+4J@+sP@+PH@+2W@+)^@+A [@+o@+X@+X@+2W@+X@+@+-V@+O
M@+@+@+`A7@+)^@+{@+{@+)^@+{@+
=q@+Vϫ@+͞@+Vϫ@+r@+@+Mj@+(@+:@+L_@+@+B@+^5?}@+^5?}@+@+oiD@+@+	 @+JL@+u%F@+s@+TɆ@+tj@+
=p@+eO@+wk@+$@+Z@+$@+%2@+g8}@+qj@+qj@+o h@+2W@+2W@+Z@+nP@+@4@+Zc@+@4@+&IR@+n.@+TɅo@+҈p@+?@+@+~BZc @+}b@+}}H@+}[@+{Q@+{5Xy@+{5Xy@+{5Xy@+{lC@+{5Xy@+{5Xy@+{5Xy@+{Q@+{Q@+{$@+{Q@+{J#9@+zxl"h
@+xy=c@+w1@+uY|@+sg	l@+ra|Q@+ra|Q@+qR@+qhr @+qu!S@+q[W>6@+qu!S@+qhr @+qhr @+qo@+q@+qA [@+pD@+pbM@+oo @+nt@+n.2@+m@+mM:@+mjOv@+mw1@+l_@+kC]@+ks@+ks@+kC]@+l/{J#@+l"h	ԕ@+kU=@+k]cA@+jL_@+j~"@+iDg8~@+hK]c@+g&@+f1.@+e`A7L@+de@+dxF@+c	@+cnP@+ao@+a7Kƨ@+aae@+`A7K@+_@+_vȴ9@+_?@+_[W>@+_?@+_vȴ9@+_حV@+_?@+]}H@+Z@+Xtj@+Xy=c@+XYJ@+X@@+XU@+XPH@+Y#w@+Y+@+X4֡b@+XPH@+Y0
)@+Y~($@+YD@+YY}@+ZQ_@+Z)y@+Z^5?|@+[dZ@+\wkP@+\쿱[@+\j~#@+\(\@+\]ce@+\wkP@+\1&@+\쿱[@+YrGE8@+W4m@+W
=p@+V@+Vl!-@+Ush@+T3@+T*1@+TFs@+TO
M@+T֡a@+TD@+U'0@+U2a|@+T3@+T*1@+TO
M@+Sߤ@+R䎊q@+Q-@+Q&x@+PbM@+O@+OO
M@+O
M;@+NMj@+NO;@+Nqi@+Np:~@+N!R<@+N;5X@+Nc	@+N.2@+N.2@+N_o @+M(@+LL_@+KC%@+J͞&@+Jg	@+IoiD@+I@+I@+Hp:@+Hr Ĝ@+G+I@+F@+EoiDg@+ES@+E@+D7@+DTɆ@+D*0@+C@+BZc@+A'R@+@IQ@+@     @+?U=@+>Q@+>vȴ9X@+>iB@+=E@+=-V@+=-V@+=H˒@+=}H@+=IQ@+=[@+<Z@+<wkP@+<wkP@+<?@+<wkP@+<ߤ@@+<Q@+<(\@+<Q@+<C,zx@+<Q@+<ߤ@@+<(\@+<wkP@+<PH@+;/V@+:kP|@+8e+@+8U@+8}H@+8F]d@+8*0@+8D*@+8Q@+7@+74m@+7O;d@+7Xe,@+6@+6@+6@+6Fs@+6E@+6E@+6E@+5!.@+49XbN@+3ߤ@+3Mj@+3*0U2@+2m@+2-V@+2n@+1hr @+/v_ح@+-\@+,!-w@++Ƨ@+*͞&@+*n@+)ᰉ'@+)Q@+($xG@+'8}H@+',@+'RT`e@+'ݗ+@+'ݗ+@+(@+(1&x@+')^@+%n/@+#%2@+"C,@+"@+!.H@+!|Q@+! [7@+!$/@+ 	k@+ ѷX@+ d8@+ hۋq@+ NU@+䎊r@+$tS@+@+"@+ߤ?@+vȴ9X@+ ѷY@++j@+/w@+?@+$@+6@+S@+S@+S@+S@+A@+A@+m]@+5Xy@+Q@+n.@+m]@+G{@+S&@+u%F@+"`@+>BZ@+u%F@+u%F@+_o@+XbM@+JE@+e+@+U@+F]d@+eں@+$tS@+z@+Ov_@+t@+Xy=@+L_@+O
M@+@+@+J@+J@+ݗ+k@+Mj@+҉@+sP@+䎊q@+W@+PH@+ ě@+ᰊ@+<64@+䎊q@+S&@+T`d@+:)y@+-V@+䎊@+-@+hr @+&x@+`A7@+D@+`A7@+`A7@+@+
=q@+:~ @+͞@+{J#:@+\(@+T@+
%@+
qu"@+>B[@+!-w@+
5Xy>@+
O;dZ@+
\@+
jOv@+@+s@+/{J#@+"h	ԕ@+I^5?@+VϪ@+C@+zxl"@+I^5?@+~($@+:)z@+C%@+C,z@+
L_@+
qiC@+	y@+	oiD@+	x@+	*0U2a@+	rGE@+	 ѷ@+	rGE@+	rGE@+TɅ@+TɅ@+Xy=@+	ԕ+@+	ԕ+@+@+	ԕ+@+$xG@+@@+RT`e@+8}H@+RT`e@+E84@++I@+]cf@+&I@+@+?@+1.@+$/@+ڹ@+ڹ@+
L/@+1.@+@+oiDg@+@+O
@+O
@+zxl"h@+zxl"h@+ݗ@+S&@+F
L0@+u@+e@+JM@+/@+M:@+\N@+{J#9@+ ѷ@+wkQ@+\(@+wkQ@+@4@+\(@+wkQ@+}Vm@+}Vm@+M@+@+n.@+|Q@+TɅo@+ ěT@+ IQ@+ 4m@+ IQ@+ A7K@*䎊r@*@*˒:)@*[W>@*@*@*%@*BZc @*u@*($x@*($x@*BZc @*\N<@*iB@*vȴ9X@*iB@*\N<@*u@*,=@*cA @*v@*ce@*IQ@*Vl!@*[@*?@*N;@*wkP@*PH@*Q@*ߤ@@*lC@*6@*q@*q@*q@*qu!@*~@*G{@*G{@*,<@*,<@*G{@*vȴ@*^5?|@*C\@*xl"h
@*>B@*)_@*Q_@*6C@*1'@*u%F@*>BZ@*"`@*(@*=b@*)@*@@*y=c@*3@*Xe,@*eں@*
=p@*@*Ϫ͟@*C-@*Ϫ͟@*@*+J@*8YJ@*Ov_@*+jg@*4K@*Ov_@*sh@*Y|@*fA@*Y|@*sg@*L_@*%F
L@*D@*Ʌoi@*3@*SMj@*Fs@*m8@**1@*3@*#@*`d@*9XbN@*,<@*,<@*9XbN@*`d@*m8@*,<@*Fs@*,<@*!-w2@*@*@*@*@*J@*@*@*!-w2@*!-w2@*,<@*!-w2@*Fs@*@*|@*g	l@*33333@*33333@**0U2@*g	l@*&@*䎊q@*䎊q@*{m@*nO@*GE85@*GE85@*u@*𖻘@*'RT@*{@*
=q@* ě@*Vϫ@*@*4֡a@*v@*O
M@*v_ح@*iDg8@*1@*1@*c	@*H@*;5X@*zG@*C\@*_o @*_o @*zG@*(@*
qv@*(@*C\@*힃%@*O;dZ@*jOv@*jOv@*qu"@*>B[@*@*첕@*zxl"@*VϪ@*1&y@*C]@*q@*D@*D@*'/@*ڹY@*L/{@*~"@*=p
@*	 @*Ov`@*0U2a|@*JL@*d7@*0U2a|@*y@*rGE@*rGE@* ѷ@*rGE@*\)@*@*7KƧ@**0U2a@*TɅ@*TɅ@*TɅ@*9Xb@*p:@*@*rGE@*\)@*>BZc@*	k@*lC@*E84@*,@*Fs@*]cf@*x@*Fs@*@*1@*@*zxl"h@*+a@*Q@*u@*o i@*u@*/@*M:@*\N@*@*
=p@*
=p@*%2@*A [@*xF@*@*㢜wk@*㕁$@*a@N@*F]c@*F]c@*,zxl@*9@*9@*,zxl@*	@*@*⩓@*M@*e+@*&IR@*@4n@*@4n@*s@*o hی@*-w1@*@N@*@N@*$/@*@N@*@N@*ěT@*IQ@*-
@*[6@*[6@*u!@*NU@*4m9@*hۋq@*d8@*ව4m@*ěT@*҈p@*C@*-
@*d8@*ѷX@*     @*˒:)@*@*o@*o@*|hs@*b}V@*o@*U=@*;dZ@*.H@*.H@*"@*޸Q@*ޫ6z@*iB@*Ov_خ@*\N<@* ѷY@*cA @*ݥv@*ݥv@*}H@*݊ڹZ@*p
=@*p
=@*Vl!@*IQ@*/w@*>@*܄?@*j~#@*ߤ@@*n.@*ߤ@@*ۥS@*ۋq@*~$@*qu!@*qu!@*qu!@*~$@*6@*Q@*ۥS@*/V@*s@*c	@*ڬ>B@*ڒS&@*ڬ>B@*)_@*څݘ@*)y@*@*)y@*)y@*6C@*C\@*6C@*Q_@*kP|@*ڒS&@*ڒS&@*څݘ@*kP|@*^5?|@*C\@*6C@*C\@*^5?|@*6C@*1'@*)y@*6C@*1'@*@*ٌ~($@*#w@*0
)@*#w@*+@*PH@*4֡b@*@@*ؠ-
@*Q@*ק&@*@*״3@*@*״3@*eں@*Xe,@*eں@*׀4m@*sPH@*ךkP@*׍O;d@*״3@*@*@*+j@*F]d@**0@*y=c@*ؓtj@*_F@*D*@*D*@*Q@*_F@*y=c@*؆YJ@*حU@*غ)@*4֡b@*PH@*	k~@*e+@*e+@*ؠ-
@*_F@*״3@*ךkP@*׍O;d@*׀4m@*׍O;d@*ק&@*rG@*ךkP@*$tS@*ֻ@*֔Fs@*z@*z@*z@*֔Fs@*z@*և+J@*և+J@*֔Fs@*֔Fs@*֮}Vl@*l!-@*և+J@*R<6@*t@*Ձ$/@*Fs@*SMj@*Fs@*|@*a@O@*ݗ+k@*g@*|@*|@*|@*g@*@*@*J@*@*@*J@*!-w2@*9XbN@*9XbN@*SMj@*`d@*`d@*J@*|@*ݗ+k@*a@O@*|@*g@*@*ݗ+k@*g@*ݗ+k@*tj~@*&@*PH@*m\@*m\@*@N@*MjO@*ӎMj@*Ӝߤ@*|@*ݗ+k@*g@*g@*|@*ӎMj@*Z@*g	l@*ӎMj@*g	l@*g	l@*ӎMj@*Ӂ@*Z@*m\@*m\@*m\@*&@*@N@*&@*PH@*&@*&@*䎊q@*{m@*{m@*ҕᰊ@*Ұ ě@*ҕᰊ@*Ұ ě@*Ұ ě@*҈p:@*҈p:@*҈p:@*҈p:@*{m@*ҕᰊ@*{m@*nO@*T`d@*a|Q@*GE85@*:)y@*s@*N;6@*N;5@*@*а{@*а{@*|@*У
=q@*Љ'RT@*bM@*-
q@*:~ @*H@*-
q@*Ϫ͞@*Ϸr@*O
M@*As@*O
M@*σ{J#:@*Ϫ͞@*o @*Vϫ@*@*U2a|@*Љ'RT@*а{@*`A7@*D@*`A7@*{@*@*N;5@*ќu@*ѩl@*ѷX@*2W@*N;6@*iB@*-@*s@*䎊@*-V@*䎊@*n@*-@*-@*n@*s@*䎊@*s@*s@*:)y@*n@*iB@*R@*iB@*R@*n@*n@*-V@*s@*iB@*iB@*ѷX@*R@*n@*R@*2W@*2W@*ѷX@*ќu@*ѷX@*яo@*hr @*N;5@*hr @*_p@*$tT@*@*У
=q@*Ж@*Љ'RT@*Љ'RT@*Љ'RT@*U2a|@*H@*-
q@*H@* ě@*U2a|@*U2a|@*H@*:~ @*-
q@*:~ @*H@*:~ @* ě@*rGE9@*@*rGE9@*@*-
q@* ě@*:~ @**0U@**0U@*:~ @*U2a|@*bM@*bM@*|@*|@*Љ'RT@*У
=q@*|@*Љ'RT@*|@*;dZ@*σ{J#:@*O
M@*O
M@*v_ح@*iDg8@*\(@*\(@*4֡a@*
M;@*4֡a@*
M;@*
M;@*
M;@*Mj@*Ίqi@*ΤT@*ΗO;@*c	@*;5X@*H@*Vu@*Vu@*Vu@*.2@*zG@*;5X@*_o @*͸@*8Y@*\@*5Xy>@*:@*V@*qu"@*B@*(@*qu"@*!-w@*:@*:@*>B[@*̥zxl"@*~($x@*q@*I^5?@*̋C@*/{J#@*1&y@*s@*"h	ԕ@*/{J#@*I^5?@*I^5?@*I^5?@*VϪ@*q@*~($x@*~($x@*q@*cA \@*cA \@*̋C@*̲@*C]@*C,z@*6z@*]cA@*jf@*P{@*'/@*jf@*˅Q@*xF]@*C%@*'/@*I^@*]cA@*6z@*'/@*C,z@*C,z@*'/@*C,z@*'/@*D@*qiC@*JL@*W'@*d7@*d7@*d7@*d7@*d7@*d7@*~"@*ʌL_@*ʌL_@*qiC@*ʌL_@*~"@*qiC@*~"@*ʦL/{@*ʳg	@*͞&@*ڹY@*ڹY@*ڹY@*ڹY@*D@*D@*n@*ʳg	@*0U2a|@*lD@*@*	 @*Ov`@*	 @*Ov`@*	 @*0U2a|@*0U2a|@*W'@*d7@*W'@*0U2a|@*0U2a|@*JL@*W'@*qiC@*ʌL_@*ʦL/{@*ʦL/{@*n@*ʳg	@*ʌL_@*d7@*d7@*~"@*ʌL_@*ʌL_@*~"@*qiC@*JL@*W'@*d7@*d7@*~"@*qiC@*ʌL_@*ʦL/{@*qiC@*0U2a|@*Ov`@*Ov`@*0U2a|@*JL@*JL@*JL@*d7@*qiC@*ʙ0
@*fB@*I^@*I^@*I^@*I^@*'/@*)^	@*P{@*]cA@*jf@*˅Q@*˒:)z@*˟U=@*ˬq@*ˬq@*jf@*xF]@*xF]@*jf@*jf@*˅Q@*˒:)z@*ˬq@*Ƨ@*C]@*s@*a@@*҈@*҈@*҈@*˹~($@*Ƨ@*˹~($@*Ƨ@*a@@*C]@*L_@*L_@*"h	ԕ@*"h	ԕ@*L_@*1&y@*L_@*/{J#@*"h	ԕ@*"h	ԕ@*L_@*L_@*L_@*L_@*L_@*"h	ԕ@*˹~($@*˹~($@*Ƨ@*ˬq@*˹~($@*҈@*҈@*C]@*a@@*a@@*Ƨ@*a@@*a@@*a@@*C]@*s@*C]@*1&y@*"h	ԕ@*1&y@*"h	ԕ@*/{J#@*<쿱@*/{J#@*/{J#@*/{J#@*/{J#@*s@*s@*1&y@*"h	ԕ@*"h	ԕ@*s@*ˬq@*Ƨ@*Ƨ@*a@@*C]@*1&y@*s@*a@@*a@@*҈@*˹~($@*jf@*6z@*P{@*6z@*)^	@*C%@*6z@*C%@*jf@*˅Q@*xF]@*]cA@*I^@*'/@*I^@*ڹY@*ʦL/{@*qiC@*JL@*0U2a|@*W'@*qiC@*ʌL_@*ʙ0
@*ʳg	@*n@*͞&@*fB@*D@*͞&@*ʦL/{@*ʳg	@*ڹY@*D@*D@*I^@*ʙ0
@*qiC@*d7@*d7@*qiC@*qiC@*Ov`@*#9@*ɅoiD@*\)@*\)@*˒:*@*$xG@*>BZc@*$xG@*>BZc@*Xy=@*eO@*eO@*r Ĝ@*Țu%F@*ȧ@*p:@*ۋq
@*ۋq
@*\)@* ѷ@*rGE@*7KƧ@*Q@*k~(@*ɅoiD@*ɠ'RTa@*ɭB@*y@*ԕ*@*@*Ov`@*Ov`@*#9@*#9@*0U2a|@*JL@*d7@*ʌL_@*ʦL/{@*n@*͞&@*ڹY@*fB@*D@*'/@*C,z@*]cA                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        @C8YJ@C8@C8@C8-
@C84֡b@C9&x@C9@C8	k@C8TɅ@C8>BZc@C7rGE9@C6E@C4tSM@C3:)z@C4Q@C3a@O@C4ߤ@@C5L_@C4*0@C2m\@C0y=c@C-qu"@C*74@C*C\@C(1&x@C%8YK@C!@Cu"@CNU@CC,zx@C[W>6@C|@CN;6@CFs@BRT`e@BC,zx@B9@Bߊ	@B֮}Vl@B?@BįO
M@BPH@B,<@B3@B҈@B1.@B@Bҏ\(@B`d@B͞&@Bԕ*@B-w1@Bа{@B:)y@B	@Bԇ#@BiDg8@Bے:)z@B߱[W>@Bo i@B;5X@B ѷ@B*0U2@B!R@Bp:~@BڹY@Bqi@B`A7@B쿱[@B%F
L@B?@Bwk@BS@B%@Cs@C&IR@CA@C#@C
IQ@C=b@C@CiB@C:)y@C^5?|@C~$@CO
M@Cp
=@CϪ͞@C.2@CBZc @CIQ@CQ@C쿱[W@C8}H@C1@C-V@CXy=@C#w@C@C2W@C2W@CI^5@Cd7@Cᰊ@Cs@C5Xy>@C!-w@Co h@CcA \@Chr@CɅoi@C3@CɅoi@C*0@C?@C[W?@C>B[@CK]@C@C$/@CzG@C_o @C4K@CYJ@C,@C *0@C!b}@C"a|Q@C"@C"L/{@C"\(@C"d7@C"qiC@C#/V@C$1&y@C$>@C%ce@C%<64@C&;5X@C&L/{J@C&ߤ?@C&Mj@C'v_ح@C(bM@C)rGE@C+	@C+J#9@C*3@C)lD@C*@C+xF]@C+@C+jf@C+jf@C+:)z@C+~($@C+҈@C,E@C/iDg8@C2I^5@C4PH@C5K]@C5IQ@C5fA@C7_o@C9$/@C8p:@C8$tT@C9hr @C9k~(@C9iB@C;I^@C;S@C<L_@C<?@C=$/@C>1@C?&@C?䎊r@C@IQ@CA:S@CAo hی@CBd7@CCZ@CC$@CCS@CDL_@CD~($x@CEo i@CEqu"@CEIQ@CEzxl"h@CE@CF$/@CF@CG'/W@CG&@CHH@CHe+@CI [7@CIDg8~@CITɅo@CI[W>6@CIXbM@CI(@CJ3@CJT`d@CJT`d@CJa|Q@CJs@CI@N@CH*0U@CH@CH-
@CHeO@CHhۋq@CI@CJ#9@CKZ@CMVl!@CNϪ͟@CO>6z@CO+j@CP:~ @CPA7K@CPtj@CP@@CQ+@CP	k@CQ@CQ=b@CQ7KƧ@CQ-w1@CQN;5@CQ^5?}@CQ"`@CQ"`@CQ"`@CR1'@CR-V@CQR<6@CQ@CQ@CQe+a@CQ+@CQrGE@CQDg8~@CQXbM@CQ&x@CQ@CQrGE@CPp:@CP'RT@CP{@CP҈p@CPF@CPěT@CP@CPtj@CP|@CP_F@CPhۋq@CPU@CQ@N@CPD@CP@@CP`A7@CQ	k~@CQ0
)@CQDg8~@CQk~(@CQoiD@CQo@CQ@CQn.@CQl@CQ^5?}@CQ@CRI^5@CRh	ԕ@CR ѷ@CRm\@CSnP@CS"`B@CSg	l@CS@CSs@CT@CTPH@CT>@CUݗ@CUC\@CVm\@CW
M;@CW;dZ@CWE84@CWO
M@CW\(@CWv_ح@CW{J#:@CW&@CX1&x@CX˒:*@CX@@CX`A7@CXC@CXp:@CXѷX@CX@@CXPH@CX`A7@CXۋq
@CX9Xb@CX҈p@CXPH@CX)^@CX9Xb@CXd8@CXěT@CXTɅ@CX@CX4֡b@CX{@CY$/@CY	k~@CY ѷ@CXPH@CX{@CXC@CX`A7@CX`A7@CX	k@CYN;5@CYXbM@CYe+a@CYrGE8@CYTɅo@CY7KƧ@CY@N@CY$/@CY [7@CY-w1@CY@CY@CY	k~@CX@CXe+@CX҈p@CX@CXC@CY_p@CY[W>6@CYu!S@CYx@CYx@CYx@CY|Q@CY@CYu@CYX@CY^5?}@CY2W@CYiB@CY>BZ@CY"`@CYR@CZ@CZs@CYlD@CZu%F@CZ䎊@CZ-V@CZ-V@CZ)y@CZQ_@CZ74@C[9@C[PH@CZ@CZS&@CZ\(@CZD@C[W>6z@C[]cA@C[Z@C[F]c@C[s@CZwkQ@CZnO@CZd7@CZL_@CZfB@C[xF]@C[|@C\,<@C\zG@C\o h@C\wkP@C\,<@C\ߤ@@C\n.@C\J@C\Q@C\n.@C\n.@C\n.@C\ߤ@@C\(\@C\<쿱@C\쿱[@C\?@C\@C\hr@C\hr@C\!-w@C\Z@C\_@C\j~@C\*0@C]:@C]2a|@C]F
L0@C]IQ@C]<64@C]+a@C](@C](@C]?|h@C]Y|@C]}H@C]%@C]-V@C]n/@C]Ϫ͞@C]b@C]Ϫ͞@C]@C]cA @C]@C]Ϫ͞@C]cA @C]8Y@C]Ϫ͞@C]
qv@C]E@C^4K@C^$/@C^E@C^Vu@C^\N<@C^YJ@C^Vu@C^Vu@C^Vu@C^L/{J@C^1.@C^
L/@C]
qv@C]@C]<64@C]V@C]'0@C]o i@C]'0@C]V@C]'0@C][@C]hr!@C]@C]Ϫ͞@C]cA @C]Ϫ͞@C]8Y@C]1@C]v@C]v@C]ڹ@C^Ov_@C^!R<@C^@C^
(@C]ᰉ@C]@C]sh@C]U=@C]%@C]=K@C]O
@C]+j@C]hr!@C]ݗ@C]n/@C]@C]cA @C]@C]U=@C]hr!@C]!R@C]Xy=@C]sh@C]8YK@C]oiDg@C]E@C^4K@C^
(@C^!R<@C^u@C]!.@C]oiDg@C]S@C]C\@C^t@C^_o @C^zG@C^!R<@C^5?|@C^E@C^s@C^%@C^qi@C^Fs@C^$t@C^%@C^+J@C^E@C]
qv@C]n/@C]@C]hr!@C]w1@C]jOv@C]ce@C]Y|@C]fA@C]m\@C]`A7L@C]ce@C]}H@C]ݗ@C]+j@C]@C]
qv@C]S@C]b@C]8Y@C]-V@C]@C]hr!@C]!R@C]ڹZ@C]ݗ@C]}H@C]}H@C]jOv@C]fA@C]\@C]Vl!@C]B@C]<64@C]+a@C]*0@C\!-w@C\7@C\S@C\qj@C\~($x@C\j~#@C\wkP@C\~($x@C\zG@C\C@C\j~#@C\M:@C\I^5?@C\C,zx@C\<쿱@C\64@C\2W@C\(\@C\%1@C\ߤ@@C[@C[g@C[ݗ+k@C[ݗ+k@C[g@C[g@C[A [@C[$@C[$@C[s@C[@C[ݗ+k@C[~($@C[q@C[q@C[q@C[ߤ@C[:)z@C[ߤ@C[@C[$@C[$@C[A [@C[҈@C[
=p@C[Q@C[
=p@C[5Xy@C[@C[a@O@C[lC@C[C]@C[$@C\tj@C\"h	ԕ@C\@C[s@C[a@@C[~($@C[q@C[jf@C[g	l@C[Ƨ@C[g@C[$@C\n.@C[@C\n.@C[s@C[$@C[$@C[$@C[@C[A [@C[$@C[$@C[g@C[:)z@C[]cA@C[]cA@C[a@N@C[]cA@C[@N@C[	@C[nP@C[S&@CZ74@CZ74@CZC,@CZ ѷ@CZ͞&@CZ@CZg	@CZ ě@CZg	@CZ@CZ ě@CZY@CZ@CZ<64@CZ@CZL/{@CZS&@CZᰊ@CZJL@CZ@4n@CZ3@CZ0U2a|@CZ-V@CZ䎊@CZe+@CZOv`@CZe+@CZOv`@CZ@CYs@CYD@CYԕ*@CY"`@CYiB@CY"`@CYy@CYB@CY@CYX@CYl@CY(@CY@CYoiD@CYb}@CYrGE8@CYk~(@CYae@CY^@CYae@CYJE@CYDg8~@CYJE@CY@CYR<6@CYR<6@CYR<6@CYo@CYoiD@CYb}@CYhr @CYae@CYXbM@CYQ@CY:S@CY@CY_p@CY+@CY [7@CY7KƧ@CYJE@CYQ@CYQ@CYae@CYae@CYXbM@CYJE@CY=b@CY0
)@CY-w1@CY&x@CY&x@CY#w@CY#w@CY4J@CYN;5@CYTɅo@CY^@CY^@CYae@CY^@CY[W>6@CYe+a@CYhr @CYhr @CYae@CYae@CYae@CYQ@CY=b@CY:S@CY0
)@CY_p@CX$tT@CX4֡b@CXC@CX\)@CX\)@CXѷX@CXTɅ@CX9Xb@CX4m@CX4m@CX9Xb@CX{@CX@CX˒:*@CXbM@CX[6@CXeO@CXoiDg8@CXl"h	@CXhۋq@CXXy=@CX[6@CX_F@CX_F@CXU2a|@CXH@CX:~ @CX*0@CX'RT`@CX}H@CX@CX
qu@CXF]d@CW䎊r@CWVϫ@CW@CW+@CWK]d@CWo @CW/V@CW3@CW[W>@CW&@CWkP@CWݗ+@CW{J#:@CW4m@CWy@CWsPH@CWlC@CW;dZ@CWv@CW
M;@CV!.I@CV@CW>6z@CW\(@CWRT`e@CW;dZ@CV@CVߤ?@CV+J@CVl!-@CVVu@CVH@CVH@CVBZc @CVE@CVBZc @CVE@CVBZc @CV.2@CV@CVOv_@CVOv_@CVzG@CU
qv@CUb@CU8Y@CUn/@CUn/@CUn/@CU%@CU+j@CUcA @CV@CVt@CU8YK@CU-V@CUU=@CU1@CUcA @CU8YK@CU?@CUS@CUsh@CUp
=@CUIQ@CU84֡@CU(@CUqu"@CUu@CUV@CU:@CTe@CT!-w@CT!-w@CTe@CU[@CU+a@CU2a|@CU?|h@CUB@CUB@CUB@CUF
L0@CUF
L0@CU84֡@CUu@CUo i@CU:@CTE@CTe@CTE@CUp
=@CUڹZ@CU!R@CUw1@CUfA@CUjOv@CUsg@CUm\@CUp
=@CUsg@CUp
=@CUce@CUO;dZ@CUO;dZ@CUS&@CUY|@CUsg@CUsg@CUm\@CUp
=@CUsg@CUp
=@CUm\@CU`A7L@CU\@CU`A7L@CUY|@CUVl!@CUL_@CU84֡@CU+a@CTE@CTJM@CTJM@CT@CT@CTZ@CTZ@CTZ@CT@CTJM@CTɅoi@CTO
M@CTN;@CT?@CT~($x@CTzG@CT~($x@CT~($x@CT~($x@CTo h@CT#@CTqj@CTN;@CTqj@CTC@CT?@CTo h@CTwkP@CTq@CTg8}@CTg8}@CTg8}@CT`d@CTZ1@CTSMj@CTI^5?@CT64@CT/{J#@CT!-w2@CTL_@CTxF@CTJ@CS@CSA [@CSC]@CSC]@CSg@CSg@CSg@CSg@CSlC@CSlC@CS%2@CS%2@CSQ@CS5Xy@CSq@CSA@CS{J#9@CSZ@CSMjO@CSMjO@CSC%@CS6z@CS9@CS6z@CS6z@CS33333@CS33333@CS33333@CS/V@CS)^	@CS"`B@CSC,z@CS'/@CSI^@CRD@CRc	@CRfB@CR䎊q@CR䎊q@CR`A@CRW@CR)_@CR@CRn@CR@CRn@CR}Vm@CRg	@CRS&@CRS&@CRp:@CR~"@CRnO@CRW'@CRJL@CRGE85@CR6C@CR&IR@CR䎊@CRI^5@CRn@CRu%F@CQs@CQ>BZ@CQᰉ'@CQᰉ'@CQiB@CQ"`@CQ"`@CQiB@CQԕ*@CQl@CQb}@CQhr @CQe+a@CQae@CQe+a@CQ^@CQe+a@CQe+a@CQae@CQ^@CQ[W>6@CQae@CQe+a@CQhr @CQhr @CQhr @CQk~(@CQhr @CQ@CQ@CQ@CQo@CQ7Kƨ@CQ7Kƨ@CQ~($@CQo@CQo@CQ^@CQA [@CQ4J@CQ0
)@CQ*0U2a@CQ_p@CQrGE@CQ	k~@CQ ѷ@CQ	k~@CQ	k~@CQ	k~@CQ	k~@CQ	k~@CP	k@CP\)@CP	k@CP`A7@CPۋq
@CP)^@CP
(@CP{@CP-
@CPu%F@CPtj@CP-
@CPYJ@CPYJ@CP'RT@CP|@CP˒:*@CP|@CPy=c@CPu!@CPr Ĝ@CPbM@CPQ@CPA7K@CP:~ @CP4m9@CP ě@CP6@CP6@CPbM@CP	ԕ+@CO䎊r@COrG@CO;dZ@CO@COحV@COo @COo @CO@CO[W>@COkP@CO@CO|hs@COsPH@COlC@CO\(@COXe,@COO
M@COKƧ@COH˒:@COAs@COAs@CO>6z@CO8}H@CO4֡a@CO.H@CO'/W@CO$tS@CO$tS@CO$tS@CO!-w1@CO,@COv@COv@CO,@COXe@CO@CO@COXe@CO@COFt@CN@CNߤ?@CN+@CNt@CNȴ9X@CNt@CNt@CNt@CNm\@CN@CNQ@CN'@CN}Vl@CN6z@CN-@CNaf@CN@CN@CNO;@CN$t@CNvȴ9X@CNp:~@CNl!-@CNiB@CN_ح@CNOv_خ@CNL/{J@CN;5X@CN!R<@CMڹ@CME@CM
qv@CM@CMcA @CM-V@CMXy=@CMO
@CM$/@CM$/@CMM:@CMM:@CMM:@CM!R@CMݗ@CMw1@CM\@CMF
L0@CM2a|@CM(@CMqu"@CMu@CMV@CMK]@CMo i@CM:@CLe@CLe@CL!-w@CLhr@CLZ@CL/@CL>B[@CL>B[@CL@CL?@CL[W?@CL?@CL1&@CL쿱[@CL쿱[@CLS@CL_@CL_@CL*1@CLN;@CLN;@CLN;@CL*1@CL*1@CLN;@CLqj@CLo h@CLzG@CLq@CLm8@CLj~#@CLq@CLm8@CLcA \@CL]ce@CLZ1@CLVϪ@CLSMj@CLFs@CL<쿱@CL9XbN@CL,<@CL(\@CL"h	ԕ@CLQ@CLL_@CLxF@CK\N@CK\N@CK\N@CKs@CK$@CKC]@CK҈@CK҈@CKݗ+k@CKQ@CK҈@CK
=p@CK
=p@CK
=p@CK
=p@CK|@CK5Xy@CK@CKa@O@CKa@O@CKa@O@CKm]@CK@CKq@CKS@CK*0U2@CK*0U2@CK*0U2@CKU=@CK$@CKMj@CKq@CKQ@CKxF]@CKg	l@CK]cA@CKW>6z@CKW>6z@CKZ@CKZ@CKW>6z@CKW>6z@CKJ#9@CK=K^@CK@N@CK=K^@CK@N@CK@N@CK@N@CK@N@CK6z@CK,zxl@CK/V@CK&@CK	@CKPH@CKnP@CKu%@CKI^@CJm\@CJ~@CJD@CJD@CJm@CJD@CJC,@CJC,@CJG{@CJG{@CJڹY@CJڹY@CJ,<@CJڹY@CJ,<@CJW@CJW@CJ)_@CJ@CJn@CJ<64@CJY@CJ}Vm@CJg	@CJ>B@CJ>B@CJ@CJ@CJ@CJL/{@CJL/{@CJS&@CJ0
@CJᰊ@CJᰊ@CJS&@CJS&@CJ\(@CJp:@CJp:@CJݘ@CJݘ@CJ~"@CJ{m@CJu%F
@CJnO@CJd7@CJW'@CJQ_@CJQ_@CJQ_@CJM@CJJL@CJJL@CJM@CJJL@CJ@4n@CJ:)y@CJ6C@CJ0U2a|@CJ-V@CJ#9@CJ䎊@CJ1'@CJ1'@CJs@CJI^5@CJ	 @CJ	 @CJn@CI-@CI@CI@CIe@CIe@CIᰉ'@CIᰉ'@CIᰉ'@CIᰉ'@CIᰉ'@CIᰉ'@CI"`@CI"`@CI@CI_o@CI_o@CIy@CI2W@CID@CID@CI^5?}@CIX@CI'R@CIB@CIl@CIl@CIn.@CI'RTa@CI'RTa@CI@CIR<6@CIR<6@CIR<6@CI7Kƨ@CIoiD@CI@CIoiD@CI@CI@CIx@CI|Q@CIu!S@CIx@CI|Q@CIx@CIo hی@CIrGE8@CIk~(@CIhr @CIe+a@CIe+a@CI[W>6@CITɅo@CIN;5@CIN;5@CIA [@CI:S@CI0
)@CI0
)@CI*0U2a@CI&x@CI#w@CI#w@CI [7@CI [7@CI_p@CI@N@CIrGE@CIrGE@CIrGE@CI	k~@CH$tT@CHPH@CH	k@CHPH@CH	k@CH\)@CH4֡b@CHC@CH@CHe+@CH҈p@CHۋq
@CHۋq
@CHۋq
@CH҈p@CHD@CHѷX@CHD@CHѷX@CHѷX@CHѷX@CHѷX@CHѷX@CHp:@CHp:@CH)^@CH@@CHěT@CHěT@CHTɅ@CHTɅ@CHTɅ@CH
(@CHTɅ@CH
(@CH
(@CH)@CH
(@CH
(@CH4m@CH{@CHd8@CH@CH@CH@CH
=q@CHIQ@CHu%F@CHIQ@CHtj@CH@CH@CH'RT@CH|@CHl"h	@CHoiDg8@CHhۋq@CHl"h	@CH_F@CHXy=@CHU2a|@CHK]c@CHH@CHK]c@CHK]c@CHK]c@CH>BZc@CH>BZc@CH4m9@CH1&x@CH*0@CH*0@CH'RT`@CH'RT`@CH$xG@CH$xG@CH}H@CH}H@CH}H@CH}H@CH@CHbM@CHbM@CH
qu@CH	ԕ+@CH@CH     @CHF]d@CGrGE9@CG+j@CG-@CGVϫ@CGrG@CG@CGحV@CGحV@CGfA@CG@CG˒:)@CGK]d@CGo @CG@CG@CG@CG@CG/V@CG3@CG&@CG&@CG?@CG	k@CG	k@CG?@CG	k@CG-V@CG$tS@CGݗ+@CGݗ+@CGݗ+@CGݗ+@CGݗ+@CG@CGO;d@CG{J#:@CGv_ح@CGsPH@CGo@CGlC@CGeں@CGb}V@CGeں@CG_o@CGO
M@CGO
M@CGKƧ@CGH˒:@CGE84@CG>6z@CG;dZ@CG8}H@CG4֡a@CG1@CG$tS@CG$tS@CG,@CGv@CG,@CG,@CGXe@CGv@CG@CG)^@CG
M;@CG
M;@CG
=p@CG@CG hۋ@CGFt@CG hۋ@CF!.I@CF!.I@CFMj@CF@CF쿱[W@CF1@CF1@CFx@CF1@CFߤ?@CF҈p;@CFA@CFt@CFt@CFm\@CFm\@CFm\@CFߤ?@CFߤ?@CFQ@CF2X@CF'@CF2X@CF}Vl@CF}Vl@CF}Vl@CF2X@CF}Vl@CF6z@CF}Vl@CF}Vl@CF-@CFT@CF-@CF,<@CFFs@CFFs@CF@CFqi@CF+J@CF+J@CF+J@CF%@CFIQ@CF}Vl@CF}Vl@CFvȴ9X@CFvȴ9X@CFl!-@CFiB@CFiB@CFfffff@CF_ح@CFYJ@CFYJ@CFVu@CFVu@CFOv_خ@CFL/{J@CFOv_خ@CFH@CFE@CFE@CFBZc @CF5?|@CF1.@CF+jg@CF+jg@CF$/@CFOv_@CFu@CF@CF@CF@CFzG@CFzG@CF@CF@CF4K@CF
L/@CF_o @CFt@CEڹ@CEC\@CEڹ@CEC\@CEE@CE(@CE(@CEoiDg@CEᰉ@CEᰉ@CEᰉ@CE,=@CE,=@CE,=@CE,=@CES@CE,=@CES@CE
qv@CEb@CEb@CEb@CE?@CE8YK@CEϪ͞@CE@CEϪ͞@CEϪ͞@CEcA @CE\(@CEn/@CEn/@CE@CEsh@CE-V@CE-V@CEU=@CEXy=@CE%@CEhr!@CEhr!@CEhr!@CEO
@CE!R@CEݗ@CEݗ@CE$/@CEM:@CE$/@CEM:@CEM:@CEݗ@CEM:@CEM:@CE$/@CE$/@CEM:@CEݗ@CEݗ@CEM:@CE$/@CE}H@CE}H@CE}H@CE$/@CE}H@CE}H@CE}H@CEM:@CE$/@CEzxl"h@CEzxl"h@CEzxl"h@CEp
=@CEjOv@CE\@CE\@CEY|@CEVl!@CEVl!@CEY|@CEY|@CEVl!@CEIQ@CEB@CE<64@CE<64@CE84֡@CE84֡@CE5Xy>@CE5Xy>@CE2a|@CE/w@CE/w@CE+a@CE+a@CE%F
L@CE(@CE!.H@CEqu"@CE[@CDE@CE:@CD>@CDD@CDD@CDD@CDJM@CDhr@CDJM@CDJM@CD@CD@CD@CD@CDZ@CD@CDZ@CD@CDZ@CDZ@CD/@CDu"@CD/@CD>B[@CDZ@CDZ@CD*0@CD@CD@CD*0@CD*0@CDɅoi@CD?@CD[W?@CD#x@CD#x@CD?@CD@CD?@CD@CD?@CD#x@CD?@CD?@CD?@CD@CD@CD1&@CDzxl"@CDTɆ@CDzxl"@CD3@CD3@CD3@CD3@CDS@CDN;@CD*1@CDN;@CD*1@CD*1@CDN;@CDN;@CDqj@CDqj@CD#@CD~($x@CD~($x@CDo h@CD~($x@CDzG@CDzG@CD~($x@CDzG@CDtSM@CDq@CDq@CDm8@CDm8@CDj~#@CDg8}@CDg8}@CDg8}@CDcA \@CDcA \@CDZ1@CDSMj@CDM:@CDI^5?@CD?@CD<쿱@CD9XbN@CD9XbN@CD64@CD2W@CD,<@CD,<@CD,<@CD(\@CD"h	ԕ@CD!-w2@CDL_@CD@CD@CDL_@CDtj@CDL_@CDL_@CDL_@CD!-w2@CD!-w2@CD!-w2@CD"h	ԕ@CD!-w2@CD!-w2@CD!-w2@CD!-w2@CD"h	ԕ@CD"h	ԕ@CD%1@CD%1@CD%1@CD%1@CD"h	ԕ@CD"h	ԕ@CD%1@CD%1@CD%1@CD"h	ԕ@CD"h	ԕ@CDQ@CDQ@CDtj@CDQ@CDQ@CDtj@CDL_@CDL_@CD@CDxF@CDߤ@@CDxF@CD1&y@CD1&y@CD1&y@CDxF@CDxF@CD1&y@CDn.@CC\N@CDn.@CDn.@CC\N@CCs@CCs@CC$@CCA [@CCA [@CCC]@CClC@CC%2@CCg@CC҈@CCݗ+k@CCݗ+k@CCa@@CCa@@CC5Xy@CC5Xy@CC@CC@CCa@O@CC6@CC6@CCZ@CCZ@CC6@CCZ@CC~($@CCE@CCm]@CCE@CCm]@CC@CCq@CC*0U2@CCS@CCS@CCS@CCS@CCS@CCߤ@CCwk@CCwk@CCߤ@CCwk@CCwk@CCU=@CCU=@CCU=@CCU=@CCA@CCA@CCA@CCq@CCQ@CC~$@CC~$@CC~$@CC{J#9@CC{J#9@CCxF]@CCqu!@CCn.3@CCn.3@CCjf@CCjf@CCjf@CCg	l@CC]cA@CC]cA@CCZ@CCS@CCS@CCP{@CCMjO@CCMjO@CCMjO@CCJ#9@CCC%@CCJ#9@CC=K^@CC9@CC9@CC/V@CC,zxl@CC)^	@CC&@CC&@CC&@CC&@CC"`B@CC	@CCC,z@CCPH@CCPH@CCnP@CC҉@CC҉@CCu%@CCu%@CCI^@CBm\@CB~@CB74@CB74@CB~@CB~@CB~@CBD@CB~@CB~@CB74@CBm@CBm@CBm@CBm@CBD@CB䎊q@CB,<@CB,<@CBsP@CB,<@CB`A@CB͞&@CB`A@CB`A@CBW@CBW@CB@CB@CB@CBn@CBn@CBY@CBY@CB}Vm@CBY@CB}Vm@CBg	@CB@CBS&@CBS&@CBS&@CBvȴ@CBvȴ@CBwkQ@CBwkQ@CBwkQ@CBwkQ@CB0
@CBᰊ@CB0
@CB0
@CBᰊ@CBS&@CBS&@CBS&@CBS&@CB\(@CB\(@CB\(@CBL_@CBL_@CBL_@CBp:@CBݘ@CB@4@CBu%F
@CBu%F
@CBqiC@CBnO@CBnO@CBnO@CBkP|@CBkP|@CBkP|@CBh	ԕ@CBkP|@CBkP|@CBh	ԕ@CBd7@CBd7@CBa|Q@CBa|Q@CBd7@CBa|Q@CBd7@CBa|Q@CBa|Q@CBa|Q@CB^5?|@CBT`d@CBT`d@CBW'@CBT`d@CBT`d@CBT`d@CBJL@CBM@CBGE85@CBGE85@CBGE85@CBGE85@CBJL@CBC\@CBGE85@CBC\@CB:)y@CB6C@CB:)y@CB6C@CB6C@CB6C@CB3@CB0U2a|@CB3@CB6C@CB:)y@CB=p
@CB:)y@CB6C@CB6C@CB6C@CB6C@CB6C@CB6C@CB6C@CB6C@CB6C@CB3@CB6C@CB3@CB0U2a|@CB)y@CB-V@CB&IR@CB&IR@CB&IR@CB&IR@CB&IR@CB&IR@CB)y@CB)y@CB&IR@CB#9@CB#9@CB䎊@CB䎊@CB1'@CBOv`@CBOv`@CBOv`@CBe+@CBe+@CBe+@CBe+@CBe+@CBs@CB@CB@CBs@CB@CB@CBI^5@CBI^5@CB	 @CBn@CBu%F@CA.H@CAlD@CA-@CA-@CA-@CAY}@CAlD@CAY}@CAY}@CAs@CAs@CA@CAR@CAR@CAR@CAR@CA>BZ@CA>BZ@CA>BZ@CA>BZ@CAe@CAe@CAe@CAe@CAᰉ'@CAᰉ'@CAᰉ'@CAiB@CA"`@CA@CA"`@CA@CA@CAN;6@CAo@CAo@CAo@CAo@CAy@CAo@CAy@CAD@CA2W@CAD@CA@CAX@CA|@CA|@CA'R@CAB@CAB@CAl@CAl@CAB@CAl@CAl@CAn.@CA'RTa@CA'RTa@CA@CAR<6@CAo@CAo@CA7Kƨ@CAoiD@CAoiD@CA7Kƨ@CA7Kƨ@CA7Kƨ@CAoiD@CAoiD@CA@CA@CAoiD@CAb}@CA|Q@CA|Q@CAx@CA|Q@CA|Q@CA|Q@CAo hی@CAo hی@CAk~(@CAhr @CAhr @CAe+a@CA^@CA^@CAQ@CADg8~@CADg8~@CA:S@CA4J@CA0
)@CA-w1@CA-w1@CA-w1@CA0
)@CA*0U2a@CA-w1@CA-w1@CA-w1@CA0
)@CA0
)@CA-w1@CA-w1@CA-w1@CA-w1@CA*0U2a@CA*0U2a@CA*0U2a@CA-w1@CA0
)@CA0
)@CA-w1@CA*0U2a@CA-w1@CA-w1@CA0
)@CA*0U2a@CA*0U2a@CA&x@CA&x@CA*0U2a@CA*0U2a@CA*0U2a@CA-w1@CA*0U2a@CA&x@CA&x@CA*0U2a@CA&x@CA*0U2a@CA*0U2a                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        @hM:@iIU=@i\@i{JE@iS&@i ě@iFs@isP@ivȴ@iFs@iE@iu!@i&@j)$/@jU!.@j.fB@jn@jTɆ@jtQ@j	@ky=c@ku,zxl@k	k@kZ@lQݗ@l+jg@mfZ@mW@nQ@nYsg@n33333@o<64@o.Ov_@oU@o@oe!.H@oQ@oXNU@o|1.@oحV@o7@o+I@ol1@o [7@nخ}Vl@njf@n7Kƨ@nQ@nR<6@niB@ncA \@nvȴ9X@nk~(@nN	k@n)L_@n);dZ@n@n@nt
qu@n}H@nO;d@n"h	ԕ@n;5X@neXbM@nmM:@ng	@n=K@n'/W@n[W>6@n'RTa@nbᰊ@n5R@m@n	JE@nA [@n2W@n"`B@oW@o~PH@oqo @o_F@nbM@n+j@nE@nʊqi@nW@nQ@nd7@nZD@n\GE85@nV9Xb@nF     @n<>BZc@n(ěT@n5;dZ@n3D@n%2@mGz@m̰ ě@mӐ@mo@m(\(@lF]d@l@4@lu!S@kI^5?@kF@l$l"h	@lS@lhs@l7˒:)@lh[6@lC]@lpwkQ@lzQ@lv%1@lWhr!@lDtj@lKo i@l6 ě@l)@l;%@lTwkQ@l>_ح@lhۋq@l6z@kIQ@ky ѷ@k[|@klzG@kx\)@k1@k:S@kB@kZW'@k%M:@k-@k8C@k;zH@k&@kY|@kRT`e@k!1@j҉@ju!S@jO
@jD@jƱ2X@k#E@kݗ@jߜu@j^@jʿ[W?@jfB@j%@j64@jQ@ju@jo@j&d8@ik*0@i,@iF]c@ipvȴ@i)y@i]*0@iT@i}o i@i+I@i*0U2@i2W@i4ߤ?@i"6z@i)$tS@i@ieO@hu"@h ѷ@h@hR<6@h䎊q@hhr@h[W?@h6z@hY|@h     @h҈@h#9@hG{@hZ@h쿱[@h,<@h)_@h'RT`@hs@htwkQ@hj҈p@hS=b@hA+a@h,Q_@hx@hhۋq@hHbM@hEF]c@h;~($@h34J@h(*0U@h1o@hQn/@h\֡a@hL($x@h\ѷX@hiJE@he	@htcA \@hg
qv@h5ݗ+k@h%/V@h>B@gm8@gߤ@@g{(@gڹZ@g+J@gwk@gwk@gZ@gsg@g͞@gG{@g2W@gFs@gKƧ@gK]c@gU@g}Vl@gl!-@g_o@goiD@gحV@g
=p@g҉@g+@gn@g@N@g䎊@gߤ@@gᰉ'@gn.3@g͞&@g\)@g,=@gF]c@gy@gn/@gm\@gG{@g&@gQ_@g_F@g^5?|@g$/@gw!-w1@gi:S@gj,<@ggN;6@gYrG@gLF]d@g8\(@g58Y@g;RT`e@g&zG@g JM@g.@g?w1@g4YJ@g9,=@gEI^@g?rGE8@g*S@g&x@f#9@f0
)@fZ@g [7@g;;dZ@gi'/@gy@gvm@gt(\@gX_F@g5n.@g<64@g8YK@gwkQ@g#O;d@g&SMj@g"(\@ga@N@gڹ@g#@g_@g>BZc@g:)z@go@g~($@g
(@g;dZ@g7Kƨ@fl"h	@f*1@fL_@fv_ح@g )@g1'@f@@f7@f]cA@fA7K@fʇ#@fܕ*1@f!.@fʃ%@fXy=@frGE@fq@f{@fF]c@f)y@fÌ~($@f@fS&@f@f&IR@fl"h	@fj~#@f*0U@fKƧ@fo@fhr!@fe+a@fo@f^5?}@fm@fp:~@fu%F@fQ@fA@fwPH@f~
L/@fC]@f{J#9@fp:@f2W@fR@f"@fp$xG@f|
=q@fp:@fw[@fy"`@f{>6z@ftM:@fu@fqQ@fp ě@fffffff@fY@fe:@fp}H@fks@fqb}@fkoiDg@f`,<@fdE@f`҈p;@f[B@ff_F@fM^@fNn@fb1&x@f\S&@fK!.@fP ě@fYb@f[=K^@fN<64@fFg8}@fC%@f8o h@f<1&@fE:@fCu@fKA [@fGƧ@fI)^	@f1O;d@fƧ@f%
M;@f9҈@fB64@f>xF@f4R<6@f2c	@f-_o@f ҈p@f#S@f%u%@fVϫ@fR@f?@f@f@fFs@f?@fKƧ@fvȴ9X@eXbM@e@f
쿱[@f
eں@frGE@e$/@f'/@eVl!@ecA \@es@e6z@ec	@fԕ*@eA [@em\@e@eX@ea@N@e($x@e}Vl@eߊڹZ@eؘ_@e
=p@eؗO;@eC@eTɅ@e33333@eؕᰊ@ey@eOv`@e]cf@eʱ2X@eۋq
@eѢwk@e[6@e3@e@e3@eƄ?@eý@eu!@e˒:)@e.2@ewXbM@euE@ex)@ewW>6z@eq@en.@e{@eMj@ecA \@ecA \@e@eߤ@@e{@eGz@e*0@e{4m@e84֡@ep
=@e@e@@e@@el@epc	@ehI^5@ehI^5@eqo @e~C\@eio hی@efTɆ@es'/W@e~C\@ex}Vm@ef-@em@ex'@e^Q@e\c	@efL/{@eb{m@e_3@ec;dZ@el3@ewO
M@ex@el1.@ep\N<@emO
@ebxl"h
@ebwkP@ea@N@eMwk@eZ!R<@eWY|@e[M:@eau@eau@el-
q@eq/V@ezbM@e+a@epW'@ejɅoi@em@eieں@e_B@eQ@eF>B@e-q@e8ȴ9X@eBo h@e<Mj@e8ȴ9X@e;o@eEH˒:@eEGz@eIrGE8@ePcA \@eJF@e<m@e>U2a|@eT@eboiDg8@e[|hs@eZe+@e[|hs@ebm8@eX'@eC;dZ@e7_o@e;7Kƨ@eCiB@eJA@eIk~(@eCݗ+k@e5C\@e7\@eC?@eE@N@eAs@e:$xG@e<C,@e4*1@e	k@e
=q@e%L_@e& ě@e(*0U@e#>BZ@e%KƧ@e(s@e@e!!-w1@e%KƧ@e\)@en/@e#,=@e#,=@e.2@e-
q@eD@eD@eu@e
zH@e)^@e@eɅoi@eɅoi@e	@dU=@eɅoi@e*sP@e@e)^@d ѷ@d%@e
䎊q@eIQ@e9@e	$/@e)_@e*F@e.$tT@e3)^	@e#@@e"~"@eT`d@eD@e)p
=@e-=K@e%F
L0@e*,<@e5oiDg@e5-@e;}H@e<G{@e;}H@e5-@e:e+@e4C@e&-@eěT@e@e4֡a@e)m\@eCϪ͞@eUݗ+k@eXT@eGC\@ePNU@e^1.@e^1.@ePNU@eSs@eNC,@ePNU@eW@N@e\p:@eW@N@eQ-V@e>@4n@e,1&x@e3"`B@e<ۋq
@e;x@e4YJ@e3!.H@e,1&x@e(n@e*@e,0U2a|@e>>BZc@e>>BZc@e*@e#"`@e(n@e"wkP@e\(@e'R@e,0U2a|@e8 ě@eG+j@eL ě@e5>BZ@e7KƧ@e?	k@e;v_ح@e.\)@e!nP@e*)^@e-:)z@e.\)@e8U@e<D@e8U@eBfffff@eTtSM@eX@eA ѷ@e3Q@e0W'@eF-
@eIW>6z@eF-
@eG䎊r@eE+a@e81&@e>:)y@e>:)y@e?-V@eA:@ePGE85@eM4m@eL1'@eLQ@eLQ@e[b}V@ebT`d@e`@ef~($x@enZ@ep64@en҈p;@eq@et`d@er!.I@ep64@et`d@et`d@ecsh@eePH@ep5?|@eiC%@eg;dZ@et_F@et_F@er~@et_F@et_F@ey(@e	k~@e{P{@e~@e~@ev@eϪ͞@e|g	@e{O;dZ@el"h	@eK]@eᰊ@eᰊ@eݗ@e?|h@eO
@eᰉ@eYJ@eYJ@eO
@e1&x@e[6@eO
@e"`B@eMjO@e@eM@e[W>@ee@eL_@e0U2a|@eߤ?@ej~#@e_o@e_o@eߤ?@e0
)@eߤ?@ex@ewkP@e/{J#@e"h	ԕ@ex@e"h	ԕ@e@e@e@eL/{J@eYJ@e-
@eu!@eZ@en@eD@e;5X@en@eU@e;5X@ehr!@en@e>B@e@e-
q@e<64@en@e)@eE@e@4@eQ@e/V@e>B@esP@esP@e@4@e%@eeO@esP@e!-w@e@e-V@e@esg@esPH@e@e@e^5?}@e@eV@efA@e#x@ecA \@eVu@e+jg@er Ĝ@e ѷY@e ѷY@ewkQ@ece@e8YK@ewkQ@eU2a|@eC,z@e@em\@e
qu@e@@e73@eF
L0@eO;d@e~"@e*0@e.H@e!R@e)_@efA@ewkQ@ebM@eu@eS@e
qu@e6C@eF
L0@e}Vm@eΚu%F@e($x@e}H@e-@e,<@eae@e(\@eae@eE84@eTɆ@eae@e~($x@e6C@eZ@e2W@e2W@e|hs@e4֡a@eN;6@e@e
=p@e4֡a@eL/{@eL/{@eՊ	@eQ_@ehr@e
=p@eN;6@eΘ_@eN;6@e_o@eٴ3@ey@fC,@fn@f\@eK]@ekP|@e/@e2a|@e?@e$tS@eR<6@e#@ex@eN;5@e#w@e1.@e0
)@f"`@fx@f@f@f Fs@eiB@f[W>6@f'R@fZ1@f@f@f>6z@f"h	ԕ@fߤ?@f Fs@e?@e74@eYJ@ewk@eiB@ewk@f Fs@foiD@f>6z@fߤ?@eۋq
@exF]@ezG@f
L/{J@faf@fvȴ9X@f@fYJ@f)^@f-
@fYJ@f:)z@f!R<@eS&@f
L/{J@f.2@f)^@eS&@eڹY@f+j@fYJ@f#JE@fYJ@f)^@f:)z@f	@fD@f#J#9@fhr!@f:)z@fD@f n@f#J#9@fXy=@f<64@ffA@f
nP@f
K]c@fhr!@fn/@fu%F
@fW@f(D@f+U=@f#J#9@fW@fW@f-
q@fvȴ@f@fB@f@f#IQ@fɅoi@fW'@f#IQ@fW'@fQ@f+%@fu%F@fzH@f!-w@f#IQ@f(sP@f&bM@feں@f!-w@f @4@f @4@f#IQ@f&bM@fQ@f@f @4@f!-w@f@f@fɅoi@f/V@f!@fɅoi@eo@f@f쿱[@f o h@f,@f^5?}@fMj@f,<@f
)^@fs@fo@fe+a@f
=p@f:S@f
=p@f
=p@f^5?}@fVϪ@fVϪ@fVϪ@fVϪ@f^5?}@f,<@fe+a@fMj@fȴ9X@fe+a@fMj@f#Gz@f#Gz@f&ߤ@@f&ߤ@@fe+a@fȴ9X@fn.@f,<@f,<@f
H@f
=p@fMj@f+u@f=͞@f=͞@f81'@f5U=@f2qj@f<GE85@f6#x@f(Ϫ͟@f@f@f3A [@f*8YJ@f#Gz@f'rGE8@f+ߤ@f2@f3A [@f,$tT@f*8YJ@f5TɅo@f?
M;@f9b}@f+u@f~($@f$6z@f IQ@f ѷY@f ˒:*@f+ߤ@f#F]c@f'qu!@f'qu!@f&
(@f/Ƨ@f/Ƨ@f(F@f&
(@f(F@f#F]c@f{@fMj@f@@fVu@f$d8@f#F]c@f@f*0@f ѷY@f ˒:*@f$d8@f@f)_@fC,z@fm@f!S@f!S@f!S@f&
(@f#F]c@fce@f     @fwkQ@fce@fm@f@f ˒:*@f ~"@f'p
=@f(,<@f1)^	@f/8Y@f2@f*73@f(,<@f,m\@f/8Y@f,m\@f+=K@f$@f'p
=@f/8Y@f?@f5S@f'p
=@f'p
=@f&
qu@f1)^	@f64m@f=*0U2@fC7KƧ@f?@f3oiDg@f+=K@f?@f9}H@f86@fA@f64m@f(,<@f(,<@f3oiDg@fHěT@fJ($x@f@oiDg8@f=Xy=@f9}H@fC6z@fHěT@f8u@f:G{@f=Xy=@f<D*@fGa@N@f@oiDg8@f=Xy=@fJ($x@fGa@N@f9}H@f3-@f?҉@f=Xy=@f6}Vm@f,E@f*6C@f3-@f+kP@f.a|Q@f'p
=@f ~"@f)y@fD@f$@f ~"@f+kP@f86@f6}Vm@f(,<@f+kP@f,E@f'o@f$TɆ@f(Z@f*6C@f!@@fX@f,E@f/o @f,E@f86@f@oiDg8@f6}Vm@f3-@f3-@f+kP@f+kP@f=Xy=@f3-@fv@f/o @f2L_@f*6C@f:G{@f=&@f@nO@f=Xy=@f=Xy=@fH@f6}Vm@f6}Vm@f6}Vm@f=&@fD0
@fD0
@f1(@f2L_@f?'0@f=&@f=&@f86@fA@fE#@fD0
@fC5Xy>@f=&@f6?@f8e+@fJ'RT`@fZ`A@fOsh@fJ'RT`@fUB@fNQ@fG`A7L@fLhr@fQ*0@fVL/{@fYm\@fR{m@fC5Xy>@f?'0@fH@fNQ@fR{m@fO3@fH@fJ&IR@fQ*0@fH7@fS;dZ@fVL/{@fLhr@fO3@fVL/{@fH@fA@fAN;6@fQ*0@fQ*0@fLhr@fR{m@fR{m@fZ`A@f]+j@fUB@f^~@fQ*0@fLhr@fS;dZ@fG_o@fC4֡a@fQ*0@fS;dZ@fR{m@fVL/{@fK	@fH7@fJ&IR@fK	@f]+j@fS;dZ@fNQ_@fO3@fUB@fR{m@fNQ_@fLhr@fLhr@fJ&IR@fK	@fLhr@fK	@fQ*0@f`_F@fdp:@f^~@fO3@fX	ԕ+@fa\(@fVL/{@fC4֡a@fElD@fX	ԕ+@f\4m9@f`^5?|@fgO;dZ@f^~@fc&@f\4m9@fK	@fQ*0@f\3@fa@fc%F
L@fkzxl"h@fkzxl"h@f^>@fVL/{@f\3@fgO;dZ@fdp:@fdp:@f^>@fSiB@fZ*0@fc%F
L@fdp:@fkzxl"h@fj@fc%F
L@f\3@fdp:@fdp:@f^>@fVL/{@fc%F
L@fj@fu33333@fgO;dZ@f]$tS@feVϫ@f]$tS@f\3@fqu%@fqu%@fdp:@fdp:@f]$tS@fgO;dZ@fkzxl"h@fc%F
L@fYlC@fX	 @fYlC@fqu%@fqu%@fdp:@fdp:@fgO;dZ@frl"h	@fkzxl"h@f`^5?|@fnA7K@frl"h	@fa@fl ѷ@fnA7K@fj@fl ѷ@fdp:@f\3@fa@f`^5?|@fov@fl ѷ@fnA7K@fov@frl"h	@fhg	@fYlC@fYlC@fnA7K@frl"h	@fov@fqu%@fov@fov@fvᰊ@fu2a|@fj@feVϫ@fdp:@fl ѷ@fy\@fo?@frkP|@fl/@fdp:@fl ѷ@fzn@fzn@fvᰊ@fu2a|@fo?@fkzxl"h@fvᰊ@f?@fs@f~C,@f}ݗ@f|$xG@f}ݗ@f~C,@f}ݗ@fqK]@feR@fdp:@fu2a|@f͞&@fs@frkP|@fzn@f1&x@fy=c@fvᰊ@fy\@f-V@f~C,@fzn@fqK]@fqK]@fy\@fwrGE9@fNU@f[@f~C,@fs@fs@f-V@f~C,@f?@f~C,@f~C,@fy=c@fzn@fy=c@fS&@f|$xG@f|$xG@f͞&@fzG@f
=q@fy\@fvᰊ@f-V@f@f[@f@f[6@f1&x@fM@fM@fxl"h
@f@f[6@f{@f"`B@f͞&@fjOv@f͞&@f͞&@f"`B@f[6@fO
@f1&x@f[W>@f͞&@fS&@fjOv@fxl"h
@fᰉ@fwk@fwk@fH˒@f~JM@fM@f@f1&x@fH˒@f"`B@fᰉ@f@f{@fڹY@f74@fxl"h
@f͞&@fjOv@f͞&@f"`B@f ě@fL_@f*0U@fYJ@f@frG@ftj@f@fhۋq@fO
@fᰉ@f>BZc@fH˒@f͞&@fH˒@f*0U@fڹY@f[6@f1&x@fYJ@f>BZc@fڹY@fO
@f@fᰉ@fZ@fZ@f!R<@f@fS&@fcA @fw1@f!.H@f!.H@frG@f>BZc@fhۋq@f/V@fS&@f>BZc@f/V@fS&@f/V@f/V@fcA @f>BZc@f>BZc@fw1@fݘ@fڹY@f/V@f
(@f>BZc@f@fcA @fZ@f!R<@f!R<@fhۋq@fڹY@f!.@f/V@fcA @ftj@f!R<@fL/{J@f@fhۋq@f*0U@f ě@fb@f=K^@fY|@f!R<@fcA @f
(@fL/{J@fu!@fvȴ9X@f
(@f
(@f!R<@ffB@fZ@f@f@f
(@fK]c@fnP@fu!@ffB@fZ@fL/{J@f1@f=K^@f:)z@f)^@fg	l@ft@fK]c@f
(@fK]c@fhۋq@f/V@fb@f-
@f\)@f=K^@fM:@f!R<@fK]c@ft@fYJ@f=K^@f
(@f-
@f:)z@fYJ@f1@f1@fu!@fb@fg	l@f\)@flC@fYJ@fb@f=K^@f1@fJE@fJE@f\)@f)^@f=K^@fu!@f-
@f.2@f.2@f\)@fżZ@fb@f=K^@f̮}Vl@fJE@fnP@fK]c@fM:@ft@f̮}Vl@f)^@f.2@fYJ@fYJ@f)^@ft@fu!@f ě@ffB@fYJ@f+@f<쿱@fYJ@f)^@f\)@f [7@f [7@f.2@fYJ@f<쿱@f+@fJE@fJE@fżZ@flC@fJE@fȃ%@fYJ@fu!S@flC@fżZ@f:)z@f:)z@f@f̮}Vl@fżZ@f̮}Vl@f@fu!S@fJE@f̮}Vl@f<쿱@fJE@ft@fJE@fႩ@f!-w2@fӠ'RTa@fu!S@f̮}Vl@fYJ@fu!S@f@fżZ@fȃ%@fu!S@fu!S@fXbM@ffffff@fӟU=@fӟU=@fӟU=@f@f;5X@f+@f;5X@f@fu!S@fȃ%@f@fӟU=@fJE@f<쿱@fӟU=@fJE@f̮}Vl@fu!S@f̮}Vl@f@fXbM@fӟU=@fӟU=@fg8}@f+@fӟU=@fXbM@fڐ$t@f-w1@f1@f@f ѷ@f$@ffffff@f-w1@ffffff@f@f̭U@fӟU=@fXbM@f$@f$@f@f+@f+@f$@fႩ@f-w1@f޻@f$@fȃ%@f ѷ@fXbM@f޻@fXbM@f!-w2@f1@fႩ@f!-w2@f@f޻@f!-w2@f!-w2@f@f+@fo@f<쿱@f@fڑN;@f!-w2@fႩ@f-w1@fg8}@fXbM@fႩ@f!-w2@ftSM@ftSM@f$@fڐ$t@fڑN;@f޻@fI^5?@fB@fڑN;@f@f1@fB@f1@fI^5?@f{J#:@fY}@fႩ@f1@fg8}@fӠ'RTa@f+@fg8}@f)^@f@fI^5?@fႩ@ftSM@f쿱[@f)^@f1@ftSM@fo@f@f䎊@fႩ@fB@f1@f;dZ@f󐖻@f)^@f1@fڑN;@f)^@fႩ@f@f쿱[@fB@ftSM@f;dZ@f䎊@fg8}@fB@f)^@fႩ@f1@f@f-V@feں@f@ftSM@ftSM@fڑN;@fo@f)^@f쿱[@fɅoi@fɅoi@ftSM@f;dZ@f;dZ@fႩ@ftSM@f;dZ@f@fJL@f)^@f1@f)^@f)^@f.H@f{J#:@f!-w@f!-w@f쿱[@f@f󐖻@fɅoi@feں@f>B@f@4@fW'@feں@feں@fɅoi@feں@fɅoi@fB@feں@f@4@fu%F@fɅoi@fQ@fIQ@gd7@f>B@f󐖻@f󐖻@f@4@fQ@f@4@f/V@f@feں@f@f;dZ@fB@f;dZ@f󐖻@f/V@f!-w@f!-w@feں@f쿱[@fɅoi@f󐖻@f󐖻@fW'@f@f@fI^5?@feں@fɅoi@f!-w@fɅoi@feں@fQ@ftSM@fu%F@f-V@fIQ@g bM@g @f쿱[@f)^@f/V@g-V@g+a@f>B@feں@f󐖻@f@4@fIQ@f/V@f!-w@fɅoi@f;dZ@fɅoi@f@fIQ@fIQ@f@4@gsg@gsg@f@f>B@g bM@f@4@f-V@f!-w@fQ@g:~ @g%@g bM@f>B@gsP@gsP@f!-w@f@4@gVl!@g,zxl@f󐖻@f/V@f!-w@f-V@f!-w@f@4@fIQ@f>B@g:~ @f@ftSM@f/V@fIQ@gsP@fIQ@f@g bM@f>B@gsP@g bM@fIQ@g bM@g:~ @f@fIQ@fQ@gsg@geO@g bM@f>B@f>B@g	@g%@fIQ@fIQ@g%@g)@g
E@g-
@g	@fIQ@geO@g-
@g,zxl@gI^@gsP@g	@g`A7@g
E@g-
@g
E@g-
@g%@g	@gsg@g%@gI^@g,zxl@g-
@gI^@g%@geO@g	@g,zxl@g)@g	@f@4@f@fn/@fn@grGE@g:S@g@gW>6z@gI^@gsP@grGE@g`A7@g-
@fIQ@gsg@gW>6z@g-
@gH@gs@g)@g-
@f@g%@gq@gs@g`A7@g@g:~ @g	@g%@gI^@geO@g,zxl@g@gW>6z@g
E@gsg@g:~ @gq@gW>6z@gI^@g	@gq@g n.@g:S@g`A7@gW>6z@gW>6z@gq@gW>6z@gsP@g,zxl@g`A7@g:S@g:S@g
E@g-
@g
=p@gq@gW>6z@gq@gs@grGE@g
E@gtj~@g;5X@gH@g:S@gH@g-
@g`A7@g
=p@gOv_@g-
@gOv_@g
=p@g
=p@grGE@g
=p@g@g`A7@gq@gOv_@g)@g@g@g@g!e+a@g,o h@g"ȴ9X@gH@gW>6z@gOv_@gOv_@gq@gq@g@g(VϪ@gs@gH@g
=p@g:S@gq@g`A7@g`A7@gs@g!e+a@g n.@grGE@g
=p@gH@gW>6z@gq@grGE@gq@gs@gq@gH@g n.@g&Mj@g
=p@gW>6z@g@g+,@g n.@g
=p@gq@g
=p@g
=p@gs@g-
@g
E@grGE@g`A7@g:S@g%o@g$,<@g
=p@grGE@gW>6z@gOv_@grGE@g n.@g
E@g ѷ@g(VϪ@g2ߤ@@g(VϪ@g:S@gOv_@g`A7@g n.@g$,<@g$,<@g
=p@g:S@g$,<@g"ȴ9X@g!e+a@g$,<@g!e+a@g(VϪ@g(VϪ@g-e@g3sPH@g%o@g/H˒:@g&Mj@g2@g$,<@g01&@g)^5?}@g%o@g(VϪ@g01&@g&Mj@g&Mj@g)^5?}@g2@g/H˒:@g/H˒:@g,o h@g%o@g$,<@g)^5?}@g(VϪ@g01&@g01&@g3sPH@g(VϪ@g:S@g+,@g,o h@g01&@g=+I@g9 hۋ@g/H˒:@g7u@g+,@g/H˒:@g,o h@g
=p@g,o h@g3sPH@g/H˒:@g01&@g,o h@g4֡a@g9:@g69XbN@g,o h@g-e@g6:)y@g/H˒:@gAU=@g4֡a@g>qj@g:cA \@g=+I@g9 hۋ@g(VϪ@g01&@g>qj@g=+I@gE4m@g3sPH@g4֡a@g:cA \@gAU=@g7u@g9 hۋ@g:cA \@g?s@g9 hۋ@gAU=@g9 hۋ@g=+I@gFZ@g=+a@g;K]d@g;y@g7-V@g6:)y@gFZ@gE4m@g3sPH@g)^5?}@g7-V@g:d7@gD1'@gB#x@gD1'@g4֡a@g=+a@gLqiC@gE4m@gAVl!@g:d7@g>\(@gAVl!@gFZ@gHH@g:d7@g3sPH@g?䎊r@gE4m@gF䎊q@gMfA@gHH@g9:@g>\(@gD1'@g9:@gAVl!@gKV@gD}H@gAVl!@g>\(@gF䎊q@gI͞@gHGE85@gI͞@g>\(@g7-V@gD}H@g9:@gBY@gLr Ĝ@gD}H@gHH@g?䎊r@gO84֡@g?䎊r@gHH@g>\(@gE$/@gLr Ĝ@gE$/@g;K]d@gIU=@gAVl!@gE$/                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ?!-w1??n.?䎊qj?MjOv?PH???Q_?ڹY?@N???2a|Q?fA?fA?c	???حU?JD?Q_?64K? ěT?Fs?N;6?
(?4m8?m\?3?+?7KƧ?sPH?c	?l!-w?"`A?m\? ѷY?m\?{m?A [7?Xe?r?-
q?|??wkQ?74?Q?.H?,<쿱?o hی?74?
=p
?u?1&x?Gz?)?YJ?6z?
=p?9XbN?¬>B[?L_?dZ1?J#9?>B?IQ?Ł$/?䎊q?"`B?C,zx?jfB?2a|Q?ҜwkP?$tSM?ٷXe?]ce?PH?ݎ!R<?s?Zc	?ܓtj~?o i?ܲᰊ?333333?_حV?RT`d?ڕᰉ?74?@?8YK?ڟvȴ9?ؓtj~?խB?և+I??As?o hۋ?׾vȴ9X?5Xy=?l?һA?($xG?{m]?ҟvȴ9?ҦL/{J?wkP?ԓtj~?YJE?rGE85?
qu?Y|?u%?Y|?t?o hۋ?rGE85?ɠ'RT`?S&?C\?C,zx?#wk?ƍ?ŗ+j?ÅQ?m\?nO?䎊qj?òm\?-V?c	?҈p:?H?E?Q_p?1?kP{?W&?`A7K?)^?\(?Mj?8YJ?oiDg?'/W?=b?sPH?حU?u!R?'RTa?Q_?n.?W>6z?$?D*?sPH?!.I?5Xy>?N;6?:)y?-
qv?!-w1?
(?U=K?Fs?b}?4m9?حU?A [?{?=K]?eڹ?@?3?҈p;?j~"?c	?+?4m9?nO;?Xe,?y=b?-
?䎊r?N;5?ᰉ?4J?Xe+?1&?:~?Z?bM?%2?Z?~Q?҈?Ov_خ?&?Ϫ͞?L_?xtj~?wXe+?L_?tj~???cA \?Xe?Ov_خ?+jg?Z?R<64?Mj?sPH??tj~?tj?Z?H?ݗ+j?a@N?䎊r?쿱[W??쿱[W??)^	?n?sg?XedzG{?vOv_خl1&yj6C-?~Ov_ح?-
qv?Q_?c*0U2a?ye+a?1&?n/?nO;?wXe+?|??u%F?tj?}H˒ku%FF?bM?u"?}}H˒a4J?tn?)^	?hr Ĝ?Ϫ͞?kP{?$tS?zvȴ9?%2?}H˒?4J?w?nOv_ح]}H˒?v+I:6C-?:)yUL_?zvȴ9bn/?z6C-?`A7L?3*0U2am}H˒l1&ykQ_?*0?zG{pbM?usg?@?O;dZ?sg?Ov_ح?6C-?*0?zG{?bMbsPH?~Ov_ح?Mj?PH?	 ?*0
?	 ?a4J??tj?ᰉ'?ᰉ'?Q??sg?n?₿Z6C-?},<M}H˒?_o?Ov_خ?/v?q4J?@?2a|Q?$/?ᰉ'?PHj6C-o!-w1?p)^	?_o?A?u"?Fs?߿o䎊q?:)y?4J?	 ?e+a?n?Xe?sg?{?$/?tj?>B?)^	?M}H˒V?o!-w1ſm}H˒?Z6C-?u%F??n/??҈?ݗ+j?sPH?E?ᰉ'?L_?sPH?n/?A?{?*0
F?6C-?ߤ??ߤ??u%bsPH?!-w1?O;dZ?2a|Q?<64?ݗ+j?`d8?O
M?ݗ?PbM?䎊q?PbM?Q_?L_?}}H˒?}}H˒?=K^?$/?U=K?VǿuL_s@NUm}H˒??tj~?z6C-o!-w1ſm}H˒p)^	?j6C-?}}H˒?bM?S?u"?|C,zxl?	 ?$tS?!-w1?-
qv?tnf?{Q_?N;5?p:?x*0
?ye+a?}}H˒?{qu!S?|????0
(?N;5?wkP?E?=K^?C,zxl?쿱[W??np)^	Z6C-?*0U2a?ݗ+j?p:3*0U2a?s@NU?z6C-?	 ?{Q_?y_o Rn/*6C-?|C,zxl?-
qv?ie+ahtj~?,<?*0
ie+a?	 ?E?ݗ+j?҈?},<ku%FkQ_?4J?U=K?Mj?e+?vȴ9?zvȴ9?S*0U2aXtj~?xPH?Ov_خ?_o??nO;Xtj~?}}H˒?N;5?!-w1?{qu!S?n/?UL_pbM?o!-w1?䎊q?Q_?$tS?u%?C,zxl?-Vzvȴ9?6C-?=K^?fA?sPHhtj~nOv_ح?v?҈?2a|Q?wXe+?]}H˒?!-w1?a4Jj6C-?҈?sg?*0?-
qv?},<?s@NUm}H˒?tZ?$tS?tj~ۿS*0U2akQ_?H?F?kQ_?zvȴ9?$tS?쿱[W??!-w1?g?ku%F?u!?<64?zvȴ9?bM?O
M?fA?`d8?O
M?!-w1ſa4J?tzG{?	 ?H?Ϫ͞?=K]?6C-?Q_?{u%F?|1&y?S*0U2a@bM?p:?n/?xPH?T`dV?usg?}}H˒gie+ay_o tzG{?c*0U2a?wkP?L_?@?c*0U2a?E?䎊r?zvȴ9?~Ov_ح?hr Ĝ?N;6?Ϫ͞?ɅoiD?nO;htj~?n?zG{?=K]?{Q_Z6C-?J6C-??Zݘie+atnp)^	?o䎊q޿htj~?䎊r?:)y?p:?O
M?Xe?N;5?N;5X?L_?$tS?u"?|C,zxl?w?fOv_خpbMwo!-w1ſs*0U2arn/?bM?|1&y?tj~?a@N?O
M?<64?{?䎊q?M}H˒?u%F
?zG{?E?$tSM?0
(?䎊q?e+a?=K^?ᰉ'?zG{?u"?},<?ye+a?ye+a?v?<64?}ZfOv_خ?tn?usg?v+I?6C-?~Q?*0?e+?1&?bM?qu!S?fA?Ov_خ?C,zxl?hr Ĝ?}Z?ݗ+j?$/?},<?{u%F?N;5?fA?Z?fA?C,zxl?_o ?=K^?1&yeL_?v+I?:)y?*0?ᰉ'?*0?$/?O
M?ceO?A?R<64?{qu!S?UL_?!-w1?6C-?$tS?N;5?htj~?*0
?Q_p?4J?nO;?&?䎊q?w?y_o ?z6C-?Q?[Q_?l1&y?}Z?쿱[W??-V?]}H˒?F?Xtj~zvȴ9nOv_ح?{qu!S?{u%F?<64?N;5?E?+?:6C-?tZ?`A7L?sg?n?+I?xPH?wXe+?e+a??rnO;rn/l1&yUL_?y_o ?䎊q?҈?Fs?tn?N;5X?Z?hr Ĝ?wXe+?_Ft?vȴ9F?usg?*0?wkP?L_?,<rsPH?x*0
?Mj?u"?_o ?N;6?u"?{?*0?0
(?u"?!-w1?xtj~?C*0U2a{u%F?htj~?O;dZ?q?*0?`A7Lj6C-?}Z?tj~?y_o s*0U2a?tn?!-w1ſXtj~        ?{Q_?6C-?M}H˒?Xe+?	 ?x*0
?Z?N;5?@NU?sPH?{qu!S?<64?*0?`d8?fA?=K^?*0U2a?w?zvȴ9?qu!S?䎊q?ku%Fj6C-?qu"?|C,zxl?tZ?҈?p:V?l?fA?*0U2a?|C,zxl?{Q_?*0?|??}}H˒        tn?!-w1?+J?Z?~Q?xtj~eL_?nO;?~Ov_ح?	 ?	 ?l?*0?bsPH?6C-?O;dZ?~Q??Ov_خ?A]}H˒?Z?₿fOv_خq4J?S&?Mj?n/?{u%F?rnO;?*0
?Q?	 ?eL_?:6C-?`bM?䎊q?`bMC*0U2a?fǿPbM?R<64?|?|1&y??䎊rJ6C-htj~?<64?Ϫ͞?ɅoiD?R<64?䎊q?PH?_o ?sg?ᰉ'?kP{?tj?}}H˒?eL_S*0U2a?rnO;J6C-?S?>B?n?},<?S&?sPH?!-w1?sPHS*0U2atzG{?䎊q?fOv_خpbM?`bM?Ov_ح?쿱[W??{qu!S?},<?v+I?	 ?v+I_!-w1?p:?N;5?ߤ??Ϫ͞?hr Ĝ?*0
?N;6?u%F?6C-?[Q_?Xtj~?}}H˒?L_?u%?{Q_?htj~pbMUL_?䎊rbsPH?Q??4J?n/?-
qvku%FtZ?ku%F?{Q_?qu!S?qu!S?y_o ?uL_?pbM?m}H˒?*0?T`d?{u%F?	 ?$tS?&g?u%F
?Fs?o!-w1ſie+a?6C-?S?o䎊q޿@bM?htj~?2a|Q??o!-w1?6C-?Ov_ح?8YJ?2a|Q?zG{ku%F?$tSM?3*0U2a?+I?Ov_خUL_?6C-?A?Ov_خj6C-?rn/?},<?L_?Q_p?ɅoiD?vOv_خ?kP{?zG{?}Z?|C,zxll1&y?hr Ĝ?_o ?Z?~Ov_ح?Xtj~_!-w1?bn/tzG{p)^	?ku%Fqu"?ie+avOv_خ?S*0U2a?쿱[W??$tSM?!-w1?w?bsPH?U=K?R<64?|C,zxl?6C-rnO;?V?쿱[W??ie+a?~Ov_ح?a@N?4J?y_o ?v+I?w?nO;?*0U2aC*0U2a?ߤ??O;dZ?+I?ɅoiD?=K^?,<?tj~?p:?
=p
?>6z?hr Ĝ?|?sPH?z6C-?|??z6C-?IQ?*0?Z??zvȴ9?usgJ6C-?Z6C-??O;dZrn/?o!-w1?}}H˒?n/m}H˒xPH?m}H˒?{?-
qv?rsPHhtj~?Ov_خ?҈?0
(?rn/?y_o ?	 ?}}H˒?҈?Ov_خ?6?tj~?䎊rv+I?o!-w1?`A7L?tj~?xtj~?xPH?ߤ??ntZ4J{qu!S{u%F?S*0U2a?Ϫ͞?#?Fs?`A7L?wXe+?xtj~nOv_حtzG{?$tS?L_?hr ĜZ6C-?S*0U2a?rsPH?j6C-?rn/?ye+a?!-w1?hr Ĝ?{Q_?-
qv?p:?ye+a?l[Q_?g?v+I?,<?C*0U2a?y_o ?tj~?PH?_Ft}ZXtj~?O
M?#?E?}Z?]}H˒	 ?*0
?fA?*0
?vOv_خ?bM?_o?ᰉ'?Ϫ͞?6C-?qu"?{u%F?1&y?!-w1?u%F?zvȴ9?rnO;?c*0U2a?Xe?{qu!S?tn?@NU?O
M?@?>6z?-
qv?=K]?|C,zxl?o䎊q?hr Ĝ?F?w?0
(?Xe+?_o ?+?*0U2a?{Q_?JD?Xe+?|C,zxl?zvȴ9?N;5?{u%F?bM?vȴ9X?#?>B?$/?Q?S&?S&??䎊r?tn?n/?*0U2a?4J?S&?@?y_o ?{qu!S?	 ?VǿJ6C-Z6C-)^	{qu!SbsPH?y_o ?$/?S&¿dzG{?v?+I?Ϫ͞?sPH?rnO;?IQ?6C-?u!?x*0
?$tSM?=K^?*0U2?ye+a?zvȴ9?bM?p:?},<?!-w1?wkP?E?E?u"?T`d?`d8?ݗ+j?sg?0
(?U=K?ku%FC*0U2a?wXe+?a4J?]}H˒?L_?Z?*0?ݗ+jF?vȴ9X?*0
?uL_?tZ>?*0?R<64?zG{?ᰉ'?`d8?Ov_خ?hr Ĝ?z6C-ie+a?xtj~?S&?ݗ?tj?2a|Q?N;5?zvȴ93*0U2a?bsPH?_o ?,<?$tSM?$tSM?`bM?fA?zG{?E?8YJ?,<?Mjj6C-?uL_[Q_?j6C-??tj~?3*0U2arsPH?a4J?z6C-?w?x*0
?Fs?{ſXtj~?*0U2a?Fs_!-w1?$tS?sPH?<64?:6C-?htj~?J6C-?sPH?O
Mp)^	vOv_خRn/?wkP?W>6z?R<64?<64?wXe+Կq4Jc*0U2a?:)y?zG{?Xe?PH?䎊r?qu!S?	 ?Z?bM?qu!S?sg?fA?Zݘ?w?C*0U2a? ѷXC*0U2a?Q?Fs?&?O
M?$tS?x*0
s@NU?Rn/f?:6C-?v+I?x*0
?hr Ĝ?$/?Q?uL_o䎊q?Q?@NU?l?sg?:)ybsPH?g??},<?)^	?u%?R<64?R<64?*0UL_?l1&ybsPH?xPHf?uL_?w?xtj~?䎊q?)^	?tZ?gFǿS*0U2a?tzG{?+I??bn/M}H˒?kQ_{qu!Sww?m}H˒rn/?4Jhtj~?Zݘ?Z?:)y?s*0U2aS*0U2a?u%F
?A?|C,zxl?Ov_ح?|?vȴ9X?UL_?%2?vOv_خ?l1&y]}H˒?uL_fOv_خ?vǿxPH?F?N;5?bn/?1&y?#?,<?e+a?L_?@NU?tn?-
qv?4J??}ZUL_?S&?tj~?v+IdzG{?vOv_خ??sPH?{?C,zxl?_!-w1ſq4J?o!-w1?䎊r?~Ov_ح?4J?|1&y?~Q?{Q_?w?s*0U2aie+a?vȴ9X?D*0?kQ_M}H˒c*0U2a?!-w1?Q_[Q_?$tS?$tSM?䎊q?)^	?QbsPH?tZq4J?vOv_خ?vOv_خ?}}H˒?w?vOv_خF?L_?*0
:6C-dzG{??Z?sPH??Z?ᰉ'?,<쿱?tj~?a@N?n/?hr Ĝ?N;6?*0?{qu!S?hr Ĝ?|1&y?kP{?-
qv?A?bM?z6C-?_!-w1ſuL_o䎊q?v+I?}Z?)^	?UL_?wkP?@NU?ku%F?dzG{a4JZ6C-?q4J?xPH?*0?&?{u%F?{u%FnOv_ح?wo䎊q޿eL_??@NUV?҈?L_?U=K?nOv_ح?䎊q?sPHrnO;PbM?z6C-?	 ?$tS?xPHku%F?|C,zxl?<64?Z6C-?J6C-?w?{qu!S?@?e+a?xtj~?uL_?sg?Mj?@NU?a@N?u"nOv_ح?zvȴ9?nO;?fA?L_?bM?S?xPH??*0U2a?u%F
??p)^	p)^	rn/}}H˒x*0
?S*0U2a{u%F?H?s*0U2a[Q_?R<64?@?ߤ??usga4J?tj~?C,zxl?$tSM?Ϫ͞?T`d?y_o ?:)y?4J},<?-V?V?kQ_?z6C-?䎊r?Ϫ͞??bsPH?ye+a?:)y?Ov_حeL_?}Z?usg?y_o ?ݗ?|C,zxlkQ_?vOv_خ?Xe?ᰉ'?Z?vȴ9?,<?=K]?VǿbsPH?htj~?o!-w1?Q_uL_rnO;p)^	rnO;?pbM?~Q?}}H˒?w?y_o ??)^	?6C-kQ_?,<?u%F?ᰉ'?ᰉ'?)^	?6C-?u%F?PH?₿ku%F?{u%F?2a|Q?Ov_خ?ceO?$?fǿp)^	?c*0U2a?	 ?)^	?hr Ĝ?u!?$tS?O;dZ?쿱[W?6C-?Mj?:)y?nO;?l?L_?T`d?$/??hr Ĝ?rsPH?eL_?htj~?wXe+?*0f?S&?E?ᰉ'?+I?_o Xtj~?o䎊q޿fOv_خp)^	?Z?ߤ??bM?|1&y?e+a?bM?bM?z6C-?a4J?m}H˒? ě?҈?|C,zxlbn/?fǿ_!-w1?PH?Ov_خ?w?!-w1?vȴ9?u!?+IbsPH?}Z?fA?`d8?)^	?ݗ+j?n?*0U2a?zG{?*0?*0?{?ᰉ'?fA?bM?3*0U2a?{Q_?+I?Ϫ͞?IQXtj~?u"?u"gwv?p)^	?}Z@bM?tj~?}}H˒?S*0U2aPbM?䎊q?䎊q?-
qv?l1&yXtj~?sPH?!-w1?$tS?sPH_!-w1?w?{Q_??ݗ+j?},<?	 ?|C,zxl?bn/M}H˒?hr Ĝ?n?Xe?nO;?҈?:)y?}ZrsPHtzG{tnrn/?j6C-?Rn/?c*0U2a?},<?@NU?,<?tj?Q?gq4JZ6C-?Q3*0U2a?nO;?$tSM?~Ov_ح?$tS?u"?A?|1&y?Z6C-?},<?u%??Zqu":6C-?҈?}}H˒?|1&y?bM?},<?4J?}}H˒?{Q_?*0
?U=?O;dZ?䎊q?!-w1?},<?tj~?Ov_خ?Xtj~?l?y_o ?zvȴ9?-
qv?},<?z6C-?sPH?nO;M}H˒zvȴ9{Q_UL_?_Ft?E?sg?U=?1&?$tS?},<?},<nOv_حs*0U2akQ_?U=K?R<64?&?$tS?c*0U2a?Ov_ح?u"?}}H˒?bM??ݗ+j?$tSfǿku%F?|1&y?ݗ+j?nO;kQ_?usg?)^	?4J?ߤ??Fǿl1&y?`bM?S&?u%F
?nO;?~Ov_ح?s*0U2apbM?UL_?QUL_?4J?n/?҈p:?H?R<64?	 ?sPH?zG{?`bMw?n/?u!?V?R<64?>6z?},<?@NU?E?Zݘ`bM?wXe+?u"?2a|Q?(\)?eL_?f?	 ?Q_p??=K^?ᰉ'?,<?bn/?IQc*0U2a?bM?vOv_خXtj~?wXe+Կ_!-w1?ye+a?$tS?kP{?*0U2?qu!S?xPH?vOv_خ?z6C-?6C-?L_?fA?n/?O
M?a@N?@NU?tj~?l?fOv_خj6C-?vȴ9?bsPH?_!-w1?{Q_?bM?-
qv?bM?pbM?3*0U2a?{ſUL_?~Ov_ح?䎊q?{u%F?Zݘ?zvȴ9?6C-?ᰉ'?R<64??,<?sg?bM?䎊q?~Q?xPH?ie+aUL_?}Z?|1&ybn/?x*0
?4J?:)y?$tSM?y_o ?}}H˒?䎊q?nO;?$tSM?Z6C-?쿱[W??Q?Rn/?*0?,<쿱Rn/??$/?Mj?Z?u"?hr Ĝ?O;dZ?+jg?6C-?]ce?E?IQ?J6C-?`A7La4J?-
qv?ݗ+j?hr ĜfOv_خ?|1&y?tj~        ?_Ft?+?S?bn/?O
M?vȴ9X@bM?*0
?bM?kQ_?Xtj~?n?sg?FsXtj~?-V?R<64?bM?$?{?6C-pbM?`bM?eL_[Q_?N;5?PH?qu"bn/?bMfOv_خ?<64?*0?a@N?n/?N;5?n/?Q?Ov_ح?+I?Xe?*0U2a?1&y{Q_q4Jc*0U2a?m}H˒~Q{Q_?nOv_ح?{qu!S?rnO;?wXe+ԿF?c*0U2a?u!?*0U2a?Z?,<?Xtj~	 ҿS*0U2a?p:?=K^?N;5?wXe+?N;5X?fA?L_?,<쿱?N;5?zG{?䎊r?Q_?Ϫ͞?ɅoiD?Xe?ye+a?)^	?fA?*0?4J?Mj?,<쿱*6C-?g?S&?@?	 ?*0
?*0
Z6C-?$tSM?{?	 ?y_o ?zvȴ9?$tS?(\)?n?)^	?*0?+jg?+jg?4J?Xe?]}H˒?rnO;?|C,zxl?~Ov_ح?u%F
?|??n?L_?T`d?䎊q?$tS?n/?z6C-m}H˒o!-w1?_o?$/?}}H˒?zvȴ9?gvOv_خ?	 ?|?䎊q?`bMa4J?N;5?2a|Q?+?4JeL_?fOv_خ?Ov_خ??qu!S?3*0U2a?eL_?1&y?2a|Q?-V?O
M?n/?tn?zvȴ9?xtj~?vOv_خ?z6C-?usg?|??҈?z6C-??}H˒?ߤ??kQ_?htj~?L_?l?O
M?@NU?bM?~Ov_ح?n?a@N?E˿Fǿ~QrsPH?S*0U2a?_Ft?u!?dzG{UL_???o䎊q?sPH?Q?=K^?₿V?o!-w1?z6C-?|??0
(?Z?Ov_ح?x*0
?}H˒??l1&y?*0
?xtj~ie+a?:)yRn/?~Ov_ح?䎊q?|1&y?|1&y?l?_Ft?$tS?2a|Q?Xe+?
=p
?p)^	Z6C-?	 ?+I?$/?<64?$tS?!-w1ſdzG{?vȴ9X?Xe+?IQ?$tS?bn/?ߤ??u"v?|C,zxl?Ov_ح?Z?n/?	 ?Xe?_o ?+I?N;5?bsPH?kQ_?ye+a?s@NU?{?e+a?wXe+?n?{qu!S??Z?*0?u%F?_Ft?sPH?+jg?tzG{?+J?Q?eL_?ie+a?z6C-:6C-?*0?䎊q?u!?R<64?U=K?-
qv?Mj?n/?zG{?*0U2a?)^	?Rn/?-
qv?䎊q?&*6C-?bM?!-w1?{qu!S?4J?~Q?n/?Ov_خ?	 ?M}H˒?}}H˒?$tS?$tS?hr Ĝ?u%F?Ϫ͞?:)y?qu!S?a@N?nO;?cA \?Q_??}}H˒?bM?N;5X?D*0?IQ?zG{?dzG{?ie+a?S?tn?Ov_خ?@NU?$/?*0?q4J3*0U2a?bM?Ov_ح?+jg?hr Ĝ?<64?쿱[W??J6C-?~Q?Q_?$?{?*0
?ku%F?Q_?+?Xtj~?ߤ??䎊q?!-w1?|??Q?vȴ9?tn?}}H˒?Ov_ح?ku%F?q4J?{qu!S?䎊r?L_?|C,zxl?n/?Z?{u%F?O
M?)^	?*0?Rn/?=K]?e+?*0U2?3*0U2a?~Q?S?䎊r?E?ɅoiD?wkP?+I?u"?Ov_ح?@?	 ?Q_?-
qv?Ov_خ?zvȴ9?bsPH?	 ?u%?Xtj~?nO;?tj~?n?{Q_?$tS`bM?{u%F                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        &/B#A)G35_10                                      1                                       