CDF       
      time      pressure  !   latitude      	longitude         string_dimension   (         EXPOCODE      29AJ20160818   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    WOCE_ID       TAlPro     	DATA_TYPE         WOCE CTD   STATION_NUMBER        42     CAST_NUMBER       1      BOTTOM_DEPTH_METERS          
Creation_Time         2020-03-19T19:50:22.700914Z    ORIGINAL_HEADER      CTD,20200319CCHSIO
# Converted CTDOXY from ML/L to UMOL/KG using the following:
#     https://github.com/TEOS-10/GSW-Python, downloaded 2019-06-26
#     gsw.sigma0:  Calculates potential density anomaly with reference pressure of 0
#     dbar, this being this particular potential density minus 1000 kg/m^3.
#     This function has inputs of Absolute Salinity and Conservative
#     Temperature.  This function uses the computationally-efficient
#     75-term expression for specific volume in terms of SA, CT
#     and p (Roquet et al., 2015).
#     http://www.teos-10.org/pubs/gsw/html/gsw_sigma0.html 
#     Python equation used:
#         oxy_UMOL_per_KG = oxy_ML_per_L * 44.660 / ( (1000 +  gsw.sigma0(SA,CT)) / 1000. ) 
# Data source:  https://doi.pangaea.de/10.1594/PANGAEA.902330
# SHIP: RV Angeles Alvarino
# Cruise: MedSHIP cruise TalPro
# Region: Mediterranean Sea and Catalan Basin
# Ports: Palermo, Italy to Barcelona, Spain
# DATES: 20160818 - 20160829
# Chief Scientist: L.Jullion
# 43 stations
# Original file in AWI format. CCHDO Converted to Exchange format
# EVENT_CODE=unknown
# DATE: YYYYMMDD
# TIME: HHMM
# LATITUDE: degrees_North
# LONGITUDE: degrees_East
# STNNBR:  removed leading 0s from STNNBR
# CASTNO: not supplied by originator - CCHDO assigned all CASTNO=1 or CASTNO=2 for stations 11, 29
# CTDSAL: changed units from Practical to PSS-78.  Data values remain unchanged.
# CTDFLUOR: changed units from UG/L to MG/M3 as they are they are equivalent
# CCHDO added flags=2 for all parameters, as T.Tanhua notes all params are calibrated and CTDOXY calibrated with bottle samples
# Removed two test sample depths from event/station 004, dTalpro_Stn04_test_1db
# Data precision preserved as submitted.
# CTD: Who - T.Tanhua; Status - calibrated,final
#     Includes: CTDSAL, CTDOXY
#     CTDTMP NOTE: Used first occurrence of primary temperature sensor in original data file
#     CTDSAL NOTE: Used first occurrence of primary salinity sensor in original data
#     NOTE: Physical parameters temperature, salinity, oxygen, density, turbidity, chlorophyll, fluorescence are published on PANGAEA, DOI above.
# Fluorescence (CTDFLUOR): Who - T.Tanhua; Status -final
#        Instrument: WET Labs ECO-AFL/FL, FLNTURTD-2526
#        ScaleFactor: 1.00000000e+001
#        Dark Output: 0.0760
# Turbidity (CTDTURBDTY): Who - T.Tanhua; Status - final
#        Instrument: FLNTURTD-2526
#        ScaleFactor: 5.000000
#        Dark output Voltage: 0.070000
#
# Reference: Cruise report: https://epic.awi.de/id/eprint/49725/1/TAlPro_EUROFLEETS_cruise_report_V2.pdf
# CCHDO page: https://cchdo.ucsd.edu/cruise/29AJ20160818
# Metadata from original file
#     Event(s):     TAlPro-2016_042 (42) * LATITUDE: 40.906167 * LONGITUDE: 2.140500 * DATE/TIME: 2016-08-27T14:30:32 * CAMPAIGN: TAlPro-2016 * BASIS: Angeles Alvarino (URI: http://www.eurofleets.eu/np4/285.html) * DEVICE: CTD/Rosette (CTD-RO)
#     Citation: Tanhua, Toste (2019): Physical oceanography during MedSHIP cruise Talpro. PANGAEA, https://doi.org/10.1594/PANGAEA.902330
#     Abstract: The TAlPro cruise (Palermo - Barcelona, RV Angeles AlvariÃ±o, 18/-8/2016 - 29/08/2-16) occupied three hydrographic transects across the Tyrrhenian Sea, the western Mediterranean Sea and the Catalan Basin (Fig. 1) as part of the MedSHIP programme (Mediterranean Ship-based Hydrographic Investigations Program). A total of 43 stations were occupied during which physical (temperature, salinity, pressure, velocity), biogeochemical (oxygen, nutrients, carbonate system, dissolved Barium, oxygen and nitrogen isotopes) and anthropic (CFCs, SF6) parameters were measured in order to monitor the physical and biogeochemical state of the Mediterranean Sea.
#     Related to: Jullion, Loic (2016): TAlPro-2016: A Tyrrhenian Sea & Alger- provencal component of the MedSHIP Programme. hdl:10013/epic.5a866780-1f8a-45cf-8111-47b2b5dc29db
#     Parameter(s):
#         Event label (Event) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Sample code/label (Sample label) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Date/Time of event (Date/Time) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Latitude of event (Latitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Longitude of event (Longitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Pressure, water [dbar] (Press) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Digiquartz
#         Temperature, water [Â°C] (Temp) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: ITS-90
#         Oxygen, dissolved [ml/l] (DO) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 43
#         Turbidity (Nephelometric turbidity unit) [NTU] (Turbidity) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO
#         Fluorescence, chlorophyll [Âµg/l] (Fluores) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO-AFL/FL
#         Salinity (Sal) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Practical
#     License: Creative Commons Attribution 4.0 International (CC-BY-4.0)
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            pressure               	long_name         pressure   positive      down   units         decibar    data_min      @         data_max      @        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      )  '   pressure_QC                	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      
D  P   temperature                	long_name         temperature    units         ?C (ITS-90)    data_min      @*G	k   data_max      @9<Z   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       )  Z\   temperature_QC                 	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      
D  d   salinity               	long_name         salinity   units         PSS-78     data_min      @C	TɅo   data_max      @CH*0U   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      )     salinity_QC                	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      
D     oxygen                 	long_name         oxygen     units         ?mol/kg    data_min      @e_   data_max      @qRT`e   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        )     	oxygen_QC                  	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      
D     CTDFLUOR               	long_name         CTDFLUOR   units         MG/M^3     data_min      6C-   data_max      ?`A7K   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      )  @   CTDFLUOR_QC                	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      
D H   	CTDTRBDTY                  	long_name         	CTDTRBDTY      units         NTU    data_min      ?   data_max      ?333333   C_format      %f     WHPO_Variable_Name        	CTDTRBDTY      OBS_QC_VARIABLE       CTDTRBDTY_QC     ) '   CTDTRBDTY_QC               	long_name         CTDTRBDTY_QC_flag      units         
woce_flags     C_format      %1d      
D P   time                	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      &.   data_max      &.   C_format      %10d       Z   latitude               	long_name         latitude   units         	degrees_N      data_min      @Ds\N   data_max      @Ds\N   C_format      %9.4f          Z   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      @vȴ9   data_max      @vȴ9   C_format      %9.4f          Z   	woce_date                   	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3;   data_max      3;   C_format      %8d        Z   	woce_time                   	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d        Z   station                	long_name         STATION    units         unspecified    C_format      %s        ( Z   cast               	long_name         CAST   units         unspecified    C_format      %s        ( [@      @      @      @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @9<Z@884֡@8ob}V@8R@8:0U2a|@7ۘA@7q.H@7/V@6>@6g@6;dZ@6ߤ?@6<쿱@6
=p@6VϪ@6Xe,@6wkQ@6@6O;dZ@6S&@6vs@6f_ح@6DTɆ@6.zG@6&'@6 H@5xl"h
@5t@55Xy@5m@5@5@5]E@53wk@5wk@4@4>B[@4ɅoiD@4@4XU@4 hۋ@4@4"wkQ@4E@4 D@3@3E84@3.2@3րIQ@3,<@36@2E84@2uO
@2u@1TɆ@1bh	ԕ@1$D@0_o @0n/@0-
@0zC\@0Ln.@0eں@/i@//4֡a@.?|h@.P
(@-Ʌoi@-o@-af@-x_F@-$7@-p:@,"`B@,!R<@,t@,q@,@@,JM@,u!@,B@,K]c@,,@,|wkP@,sg	l@,k҈@,_䎊r@,KC,z@,3&@,wkP@,u@,
d7@,.H@+D@+>BZc@+F]c@+KƧ@+n@+_o@+@+H˒@+쿱[@+,<@+}H@+{m@+H@+0
@+ݗ+@+2W@+o@+ߤ@@+=b@+Xe@+u@+9@+|N;@+sg@+p
(@+p@+oiDg8@+o hۋ@+l@+f$/@+Vt@+J0U2a|@+FA@+DtSM@+@	k@+;s@+64K@++C]@+(K]c@+$7@+%ڹ@+䎊r@+~@+)_@+J#9@+qu!@+j~#@+wkP@+%@+'+I@+&-@+(>BZc@+"C,@+!.I@+ݗ+@+ 
qu@*xl"h
@*E@*p:~@*5Xy>@*cA \@*I^5?@*I^5?@*O;dZ@*jOv@*As@*{@*r@**0U2a@*8YK@*⩓@*ߤ?@*J#9@*؆YJ@*!.I@*z@*!.@*Ԣ3@*ѷX@*D@*iDg8@*
qv@*O;dZ@*a@@*Ƨ@*"h	ԕ@*C]@*ɠ'RTa@*oiDg@*u@*%1@*2W@*\N@*üZ@*F]c@*nP@*nP@*\(@*R<6@*Gz@*IQ@*U=@*[W>@*     @*@N@*hۋq@*حV@*[W>@*$tS@*vȴ9@*䎊r@*
qu@*6@*ěT@*@N@*R<6@*s@*&IR@*h	ԕ@*S@*xF@*Z1@*āo h@*ĨTɆ@*Ďqj@*?@*xF@*\N@*{J#9@*Zc@*e+@*@4n@*4m@*hۋq@*4m9@*?@*$/@*e@*¶}Vm@*74@*M@*@*ae@*Gz@*n@*$tS@*䎊r@*?@*@*n@*n@*@N@*7Kƨ@*`A@* ѷ@*C,@*M@*7Kƨ@* [7@*@*'R@*:S@*䎊r@*o@*Ft@*!-w1@*Ft@*\N<@*"@*
qu@*s@*{J#9@*u%F
@*@*@*?@*/@*ĨTɆ@*8YK@*Ǡ	k@*Fs@*ƍ@*fffff@*Ƨ-@*y@*	ԕ+@*ʙ0
@*s@*1&y@*҈@*jOv@*͸@*ͫU=@*͞%@*(@*ͫU=@*!-w@*s@*˅Q@*L_@*
qv@*As@*rGE9@*v_ح@*!-w@*1&y@*C\@*N;5@*ѷX@*n@*zG@*4K@*@*׀4m@*y=c@*؆YJ@*}H@**0@*+@*Xe,@*!.I@*@*Xe@*l!-@*Ϫ͟@*>BZ@*ٙ@*ٳ|@*W>6z@*/w@*E@*߾vȴ9@*@4@*@*
M;@*J@*Ov_@*\(@*Y|@*E@*Mj@*N;6@*N;5@*4J@*:)y@*S&@*a|Q@**1@*g@*&@*iB@*l@*2W@*iB@*u!S@*{@*-
q@*@*r@*r@*@*rGE9@**0U@*:~ @*iDg8@*As@*v@*2X@*p:~@*!R<@*
qv@*w1@*5Xy>@*M:@*
qv@*.2@*p:~@*H@*C\@*@*(@*qu"@*(@*qu"@*!-w@*_@*"h	ԕ@*~"@*lD@*=p
@*'RTa@*Dg8~@*Q@*L_@*}Vl@*@*U=@*\@*:@*<쿱@*U=@*)^	@*L/{@*JL@* ѷ@*$xG@*$xG@*	k@*E84@*+I@*_o@*8}H@*)^@*Fs@*x@*A@*s@*S&@*o h@*Z1@*%1@*xF@*tj@*%1@*%1@*2W@*?@*xF@*
=p@*	@*&IR@*s@*n.@*ae@*ae@*ae@*	k@*@*o@*Ft@*b@*ܑN;@*/V@*,<@*6C@*rGE8@*bM@*sPH@*ךkP@*}H@*Q@*}H@*Q@**0@*؆YJ@*4֡b@*	k~@*#w@*#w@*ؓtj@*ק&@*ȴ9X@*t@*E@*|@*&@*ҕᰊ@*:)y@*hr @*N;5@*4J@*A [@*A [@*_p@*_p@*@*D@*D@*D@*)^@*Љ'RT@*bM@* ě@*-
q@*rGE9@*o @*Ϸr@*ϝ-V@*σ{J#:@*\(@*v@*Mj@* hۋ@*v@*4֡a@*O
M@*\(@*v_ح@*ϝ-V@*ϝ-V@*\(@*v@*v@*v@*v@*'/W@*'/W@*v@*
M;@*t@*+@*ΤT@*}Vl@*p:~@*p:~@*}Vl@*}Vl@*p:~@*p:~@*}Vl@*Ίqi@*ΗO;@*ΤT@*t@*Mj@* hۋ@*v@*4֡a@*\(@*ϐ@*ϐ@*iDg8@*As@*ΤT@*
qv@*w1@*>B[@*VϪ@*s@*˹~($@*xF]@*'/@*qiC@*Ov`@*	 @*ᰉ'@*Q@*eO@*eO@*Xy=@*$xG@*@*ǻ/V@*_o@*lC@*fA@*1&x@*>BZc@*$xG@*@*@*K]c@*Xy=@*r Ĝ@*Ȍ@*Țu%F@*r Ĝ@*K]c@*>BZc@*1&x@*K]c@*Xy=@*K]c@*K]c@*K]c@*K]c@*@*ǆ&@*&I@*Ƨ-@*fffff@*1.@*1.@*
L/@*Ů1@*Ňݗ@*m\@*S&@**0@**0@*\N@*n.3@*	@*S&@*C,@*C,@*@*\(@*@4n@*I^5@*s@*R<6@*|Q@*o hی@*o hی@*ae@*ae@*ae@*:S@*
qu@*	@*	@*?@*m\@*cA @*!.H@*Z@*N;@*C,zx@*Q@*q@*dZ@*dZ@*=K^@*J#9@*=K^@*/V@*J#9@*s@*ݘ@*kP|@*>BZ@*rGE8@*rGE8@*e+@*bM@*ȴ9X@*af@*z@*Ϫ͞@*%F
L@*3@*PH@*hr @*4J@*$tT@*{@*
(@*)^@*@*D@* ě@*@*-V@*{J#:@*iDg8@*v@*1@*T@*
qv@*U=@*(@*;5X@*H@*H@*
qv@*(@*!-w@*C@*C@*_@*VϪ@*Ƨ@*I^@*y@*@*TɅ@*eO@*-@*_o@*,@*Fs@*@*@*@*ݗ@*+a@*o h@*Z@*wk@*
=p@*@*S&@*wkQ@*@*nP@*@*C,@*	@*S@*a@N@*wkQ@*hۋq@*|hs@*	@*|hs@*.H@*"@*"@*ߤ?@*\N<@*5?|@*($x@*E@*ڹZ@*ce@*}H@*/w@*?@*wkP@*ߤ@@*6@*6@*dZ@*>B@*^5?|@*)y@*@*1'@*1'@*1'@*@*Y}@*@*@*u%F@*_o@*~($@*XbM@*e+a@*0
)@*#w@*PH@*F@*YJ@**0@*F]d@*+@*O;d@*@*l!-@*t@*\(@*L_@**0@*֡a@*Fs@*Mj@*&@* ě@*T`d@*R@*l@*
(@*`A7@*$tT@*_p@*{@*{@*{@*D@*{@*U2a|@*;dZ@*-V@*4֡a@*4֡a@*As@*4֡a@*As@*t@*C\@*%@*M:@*O;dZ@*q@*/{J#@*/{J#@*L_@*a@@*C,z@*ڹY@*n@*0
@*~"@*d7@*d7@*JL@*0U2a|@*ᰉ'@*x@*\)@*TɅ@*˒:*@*eO@*Xy=@*1&x@*fA@*K]d@*&@*_o@*_o@*+I@*Fs@*A@*-@*s@*?@*?@*@*1.@*S@*@*@*@*m\@*84֡@*e@*S@*?@*xF@*xF@*Z@*nP@*@*@*\(@*@*7Kƨ@*o hی@*TɅo@*:S@*C@*IQ@*4m9@*[W>@*vȴ9@*˒:)@*@*@*
qu@*˒:)@*|hs@*|hs@*	@*|hs@*|hs@*|hs@*;dZ@*~ߤ?@*~Q@*~Ov_خ@*}H˒@*|>@*|hr@*|hr@*|u"@*|#x@*|ߤ@@*{m]@*{J#9@*{J#9@*{"`B@*z>B@*zxl"h
@*zkP|@*y@*yrGE8@*ye+a@*yrGE8@*ye+a@*yXbM@*y+@*xy=c@*xbM@*w+@*w+@*w+j@*wkP@*wkP@*wkP@*wkP@*wKƧ@*weں@*wsPH@*w4m@*wO;d@*v!.I@*vFs@*vl!-@*vl!-@*vE@*u!R@*u2a|@*tm8@*t9XbN@*t`d@*tzG@*t`d@*tSMj@*sݗ+k@*sߤ@*sg	l@*sMjO@*sMjO@*rm@*sPH@*rS&@*rnO@*rn@*qu@*q@*p
(@*p{@*poiDg8@*pbM@*or@*oiDg8@*n1@*nO;@*nc	@*n;5X@*n_o @*m@*mw1@*m(@*l!-w@*l@*lq@*l~($x@*lq@*l/{J#@*l1&y@*k:)z@*kxF]@*kP{@*kC,z@*jL_@*jW'@*j0U2a|@*i@*i'RTa@*i@*i@*ioiD@*iDg8~@*hۋq
@*h9Xb@*h@*h@*h@*h9Xb@*h@*h@*h	ԕ+@*gfA@*g	k@*g8}H@*gE84@*g)^@*f'@*f?@*eڹ@*e@*eݗ@*ezxl"h@*eݗ@*e`A7L@*eo i@*d*0@*dM:@*dM:@*dZ1@*d%1@*dxF@*dtj@*dtj@*dtj@*c%2@*c{J#9@*ca@N@*cS@*cS&@*bC,@*b}Vm@*b@*b@*b}Vm@*bu%F
@*bZc@*a.H@*a@*ao@*a@*a'R@*a|Q@*a-w1@*a@N@*a@N@*a [7@*a-w1@*`4m@*`NU@*`'RT`@*_حV@*_[W>@*_?@*_U=@*_U=@*_;dZ@*_.H@*^쿱[W@*^@*^$t@*^vȴ9X@*^iB@*^\N<@*^5?|@*^u@*^
(@*^u@*^ ѷY@*]cA @*]cA @*]H˒@*]cA @*]v@*]Vl!@*\Z@*\wkP@*\j~#@*\j~#@*\]ce@*\PH@*\j~#@*\j~#@*\wkP@*\?@*\j~#@*\C,zx@*[m]@*[A@*[W>6z@*[/V@*[/V@*[/V@*["`B@*["`B@*[/V@*[s@*Z,<@*ZS&@*ZC\@*Z6C@*Z1'@*YY}@*Y_o@*Y(@*Ye+a@*YXbM@*Y#w@*X@@*XU@*XYJ@*W+j@*W&@*WO;d@*W4m@*W4m@*WXe,@*W1@*W
=p@*WXe@*W
=p@*W
=p@*V!.I@*V@*VE@*U=K@*U!R@*U=K@*U!R@*U$/@*U*0@*TD@*T֡a@*TZ@*Tj~@*T֡a@*TɅoi@*Tj~@*Tj~@*T֡a@*T֡a@*T֡a@*T֡a@*T֡a@*T*1@*T9XbN@*T!-w2@*Sݗ+k@*Sߤ@*Sߤ@*SMj@*SMj@*Sg	l@*Sg	l@*S33333@*R<64@*R ě@*R ě@*R ě@*R ě@*R ě@*R<64@*R ě@*Rᰊ@*Rᰊ@*RS&@*R ě@*R ě@*RT`d@*RGE85@*R:)y@*R:)y@*R:)y@*R䎊@*R-V@*Q-@*Q2W@*Q2W@*QN;6@*Ql@*Qu!S@*Q[W>6@*QN;5@*QA [@*Q4J@*QA [@*Q_p@*P{@*PD@*P
=q@*PoiDg8@*P|@*PoiDg8@*P:~ @*P-
q@*P ě@*OVϫ@*O@*Ov_ح@*OiDg8@*OiDg8@*O\(@*O\(@*OAs@*O
M;@*NMj@*Nߤ?@*Nߤ?@*N2X@*N}Vl@*Nqi@*NT@*N2X@*NT@*NO;@*N}Vl@*Nqi@*NO;@*NT@*NT@*N2X@*NO;@*NVu@*NH@*N!R<@*NzG@*N!R<@*N!R<@*N!R<@*M
qv@*M%@*MB@*MB@*M(@*M5Xy>@*M\@*MjOv@*MjOv@*MjOv@*MjOv@*MM:@*Mhr!@*Mhr!@*Mw1@*MO;dZ@*MO;dZ@*M5Xy>@*M(@*M(@*Mqu"@*L!-w@*L@*L!-w@*M:@*L!-w@*L@*L@*L>B[@*L[W?@*L>B[@*L@*L!-w@*L>B[@*L@*L_@*LC@*LVϪ@*L/{J#@*KC]@*K~($@*KƧ@*Ka@@*K҈@*KC]@*L1&y@*L1&y@*LL_@*L/{J#@*L1&y@*K:)z@*KxF]@*KxF]@*KQ@*K:)z@*K:)z@*Kq@*KƧ@*KƧ@*KU=@*KI^@*JD@*JڹY@*Jn@*Jn@*JL_@*J0
@*JL/{@*J=p
@*J#9@*J#9@*I'RTa@*IoiD@*IoiD@*Ik~(@*Ix@*IoiD@*I^@*Ix@*Ix@*IoiD@*I@*IoiD@*IDg8~@*I7KƧ@*I*0U2a@*I7KƧ@*IDg8~@*IrGE@*I ѷ@*I ѷ@*I ѷ@*I@*I*0U2a@*I*0U2a@*I7KƧ@*I^@*Ix@*Ix@*Ix@*I^@*I7KƧ@*I@*I*0U2a@*I@*I@*I@*IrGE@*H@*H@*Hp:@*Hp:@*Hp:@*HTɅ@*H9Xb@*H˒:*@*H	ԕ+@*G	k@*G	k@*GzH@*G/V@*GfA@*G@@*G#@*H@*H$xG@*H>BZc@*HeO                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 @C?@C
qv@C?@CS@CT`d@C ě@Cy@CA [@C	TɅo@Cm\@C'R@C'R@Cy@CD@Co hی@CDg8~@C:S@C*0U2a@C4֡b@Cr Ĝ@CbM@C+j@C@C@C"@C.2@C
?@C
hr!@C4K@C$/@C!R<@C
C\@C
<64@C
n/@Co hی@Cu%F@CѷX@Cۋq
@Cl!-@Cqu!@C	o@CK]c@C@CkP@C+@C.H@C\N<@Cl!-@C@C2W@CE@C?@Chr@C
ᰉ@Cȴ9X@C$tS@CXe,@CsPH@CFt@Cȴ9X@C-
@Cb}V@C"`B@CU2a|@C_o@Ct@C*0U@Cu!@C@N@C6z@CI^5?@CxF@C6@C*0U2@Cq@CPH@CڹY@CxF]@CƧ@C,<@CjOv@C/V@C      @C _F@C!.H@C"e+@C#:)z@C$Fs@C$N;@C%IQ@C%H˒@C%ڹ@C&Vu@C'+@C)@C)x@C*e+@C*)_@C+I^@C+Z@C+q@C+eO@C+tj~@C+:)z@C+Q@C+s@C,!-w2@C,2W@C,I^5?@C,g8}@C,`d@C,PH@C,Fs@C,?@C,쿱[@C,e@C-!.H@C-/w@C-+a@C-5Xy>@C-5Xy>@C-m\@C-O
@C-[@C-(@C-}H@C-cA @C-C\@C-8Y@C-$/@C-ce@C-ڹ@C.+J@C.m\@C.vȴ9X@C.YJ@C.vȴ9X@C.$t@C.x@C/K]d@C0bM@C1oiD@C2䎊@C2M@C2@C2>B@C2qiC@C1R@C1B@C1x@C1[W>6@C1A [@C1e+a@C1~($@C2n@C2~"@C2ڹY@C2c	@C3@N@C3S@C36@C3@C3a@@C3lC@C3s@C4!-w2@C4Q@C4(\@C4]ce@C4j~#@C4zG@C4O
M@C4D@C4E@C4D@C4D@C5+a@C5<64@C5`A7L@C5zxl"h@C5}H@C5zxl"h@C5}H@C5!R@C5=K@C5Xy=@C5\(@C5@C5ᰉ@C5ڹ@C6zG@C6?@C6fffff@C6qi@C6ȴ9X@C6x@C7@C7KƧ@C7{J#:@C7˒:)@C7-@C7-@C7-@C7+j@C7#@C8'RT`@C8oiDg8@C8YJ@C8d8@C8@@C8)^@C8\)@C9=b@C9b}@C9'RTa@C9@C9o@C9e@C9R@C9Y}@C:	 @C:e+@C:#9@C:)y@C:3@C:C\@C:W'@C:a|Q@C:nO@C:L_@C:wkQ@C:g	@C:@C:W@C:W@C:)_@C:,<@C:sP@C:G{@C:m\@C;PH@C;)^	@C;=K^@C;a@N@C;~$@C;wk@C;5Xy@C;5Xy@C;a@@C;|@C;|@C;ݗ+k@C;A [@C;C]@C;$@C;A [@C;g@C;g@C<ߤ@@C<!-w2@C<(\@C<C,zx@C<j~#@C<_@C<[W?@C<Ʌoi@C<!-w@C=<64@C=?|h@C=2a|@C=5Xy>@C=m\@C=Xy=@C=v@C=U=@C=sh@C=\(@C=b@C=
qv@C>Ov_@C>E@C>YJ@C>@C>Ϫ͟@C>x@C>Mj@C>Fs@C?@C?$tS@C?8}H@C?4֡a@C?1@C?H˒:@C?sPH@C?kP@C?[W>@C?fA@C?@C?+@C@
qu@C@hۋq@C@r Ĝ@C@|@C@)@C@ۋq
@C@	k@CA@CA&x@CA4J@CA=b@CA=b@CADg8~@CAN;5@CA^@CA7Kƨ@CA'RTa@CA|@CAᰉ'@CB0U2a|@CB&IR@CB&IR@CBa|Q@CB>B@CB͞&@CBm\@CC33333@CCQ@CDC,zx@CD1&@CDhr@CDe@CD>@CDe@CD!-w@CDJM@CDhr@CD!-w@CE%F
L@CE+a@CE<64@CE$/@CE!R@CEݗ@CEݗ@CEO
@CE%@CE@CEv@CE1@CEsh@CEH˒@CE8Y@CEb@CEᰉ@CEE@CFt@CF!R<@CF1.@CF5?|@CF1.@CF8YJ@CF;5X@CF;5X@CFBZc @CFE@CFfffff@CFp:~@CFIQ@CFFs@CFaf@CF}Vl@CFߤ?@CFm\@CF]cf@CF쿱[W@CFMj@CFMj@CFMj@CF!.I@CG@CF"@CFFs@CG@CG@CG@CGFt@CG+I@CG@CG-V@CG?@CG	k@CG&@CG&@CG&@CG&@CG[W>@CG/V@CG@CGo @CGo @CG+@CGfA@CG;dZ@CG@CGrGE9@CH     @CHF]d@CH@CHF]d@CH@CH
qu@CH
qu@CH
qu@CH*0U@CH*0U@CHbM@CHbM@CH*0U@CH*0U@CH*0U@CH*0U@CH*0U@CHbM@CH@CH@CH	ԕ+@CH	ԕ+@CH
qu@CH	ԕ+@CH
qu@CHbM@CHbM@CH*0U@CH*0U@CHbM@CGrGE9@CG䎊r@CGVϫ@CG@@CG@CG+@CGfA@CGfA@CG@CG@CG;dZ@CG@@CG@@CG-@CG䎊r@CG䎊r@CG+j@CG-@CGrG@CG@CG+@CGo @CG/V@CG[W>@CG͞@CG&@CG&@CG?@CG?@CG&@CG&@CG&@CG&@CG&@CG&@CG&@CG&@CG&@CG&@CG?@CG&@CG?@CG?@CG?@CG	k@CG	k@CG	k@CG-V@CG-V@CG	k@CG-V@CG-V@CG-V@CG-V@CG-V@CG-V@CG	k@CG	k@CG-V@CGkP@CGkP@CGkP@CGkP@CGkP@CGkP@CGkP@CG-V@CG	k@CG?@CG&@CG͞@CG[W>@CG/V@CG/V@CGvȴ9@CG˒:)@CG@CGحV@CGfA@CG@CG;dZ@CGrG@CGVϫ@CGVϫ@CG-@CG+j@CGrGE9@CH     @CH@CHbM@CH
qu@CH
qu@CH
qu@CH	ԕ+@CHF]d@CH     @CGrGE9@CG䎊r@CG䎊r@CG-@CG@CG@@CG;dZ@CG@CGfA@CG@CG˒:)@CGK]d@CG˒:)@CG˒:)@CG˒:)@CGK]d@CG3@CG@CG;dZ@CGrG@CGVϫ@CG-@CGrGE9@CG#@CH     @CHF]d@CHF]d@CHF]d@CHF]d@CH	ԕ+@CH	ԕ+@CH@CH@CH@CH
qu@CH@CH	ԕ+@CH@CHF]d@CG#@CG+j@CG䎊r@CG-@CG-@CG-@CG-@CG@CGrG@CG@CGrG@CG@@CG;dZ@CGحV@CG+@CG˒:)@CG˒:)@CGo @CGK]d@CGo @CGo @CGvȴ9@CGvȴ9@CGvȴ9@CG/V@CG3@CG3@CG3@CG3@CG3@CG3@CGzH@CG	k@CG-V@CG-V@CGkP@CG@CG&@CG4m@CGy@CGv_ح@CGo@CGlC@CGiDg8@CGeں@CGb}V@CGeں@CGb}V@CG\(@CG_o@CG\(@CGXe,@CGRT`e@CGU=@CGH˒:@CGE84@CGAs@CG;dZ@CG+I@CG!-w1@CG,@CGv@CG
M;@CG hۋ@CF!.I@CF1@CF҈p;@CFt@CFȴ9X@CFm\@CFm\@CFt@CFA@CFA@CFt@CFt@CF&I@CFߤ?@CF@CFQ@CF'@CF'@CF6z@CF6z@CF}Vl@CF'@CF'@CF2X@CF-@CFT@CF@CFO;@CFO;@CFO;@CF$t@CF+J@CF}Vl@CFiB@CF_ح@CF\N<@CFVu@CFOv_خ@CFH@CFBZc @CF;5X@CF;5X@CF1.@CF+jg@CF$/@CFu@CFzG@CF
(@CF_o @CF
L/@CFt@CF ѷY@CEڹ@CEC\@CEC\@CE!.@CE!.@CEڹ@CEڹ@CEC\@CE(@CEϪ͞@CE\(@CE\(@CEH˒@CEn/@CE@CE@CE@CE1@CEU=@CEv@CEv@CE%@CE=K@CE=K@CEO
@CEڹZ@CEݗ@CEݗ@CE$/@CE$/@CEw1@CEfA@CEfA@CEfA@CEY|@CE`A7L@CE\@CE\@CE\@CEVl!@CEY|@CEY|@CEVl!@CES&@CEL_@CEL_@CEIQ@CEF
L0@CEF
L0@CEB@CE<64@CE84֡@CE5Xy>@CE/w@CE2a|@CE%F
L@CEqu"@CE*0@CEV@CE'0@CEo i@CDE@CD>@CDD@CD@CDu"@CD֡a@CDZ@CDɅoi@CD7@CD#x@CD?@CDj~@CD#x@CD?@CD?@CD?@CDO
M@CDTɆ@CDzxl"@CD3@CDS@CDN;@CDN;@CDN;@CDqj@CDN;@CD#@CD~($x@CDwkP@CDtSM@CDm8@CDcA \@CD`d@CDZ1@CDZ1@CDSMj@CDI^5?@CDFs@CD?@CD<쿱@CD<쿱@CD<쿱@CD9XbN@CD64@CD2W@CD/{J#@CD(\@CD"h	ԕ@CD!-w2@CDtj@CD@CD@CDߤ@@CD1&y@CD1&y@CDn.@CC\N@CC\N@CCs@CC@CCA [@CCg@CCg@CClC@CC%2@CC҈@CC҈@CCݗ+k@CCQ@CC
=p@CCa@@CC|@CC5Xy@CCƧ@CCa@O@CC~($@CC~($@CC~($@CC@CC*0U2@CCwk@CCU=@CCߤ@CCMj@CC:)z@CCeO@CCq@CCQ@CC~$@CC{J#9@CCqu!@CCg	l@CCg	l@CCg	l@CCjf@CCdZ@CCg	l@CCa@N@CC]cA@CCZ@CCZ@CCZ@CCW>6z@CCW>6z@CCMjO@CCMjO@CCF]c@CC@N@CC9@CC,zxl@CC)^	@CC)^	@CC&@CC"`B@CCPH@CCnP@CC҉@CC҉@CCS&@CBm\@CB~@CBD@CBC,@CBC,@CB䎊q@CB䎊q@CB䎊q@CB ѷ@CBڹY@CB,<@CBW@CB)_@CB)_@CB@CB<64@CBY@CB<64@CBY@CB}Vm@CB}Vm@CBg	@CBg	@CBg	@CB@CBS&@CBvȴ@CBwkQ@CB0
@CB\(@CBp:@CB{m@CB~"@CB{m@CB{m@CBxl"h
@CBxl"h
@CBnO@CBkP|@CBd7@CBa|Q@CBd7@CBZc@CB^5?|@CBW'@CBT`d@CBJL@CBC\@CB:)y@CB6C@CB3@CB3@CB)y@CB䎊@CB1'@CBOv`@CB@CBI^5@CBn@CA.H@CAlD@CA-@CAs@CAR@CA>BZ@CA>BZ@CAe@CAᰉ'@CAiB@CA@CAN;6@CA_o@CAo@CAo@CA@CA@CA|@CA|@CAB@CAl@CA(@CAl@CAn.@CAu@CA@CA@CAR<6@CA@CA@CA@CA~($@CA7Kƨ@CAb}@CAb}@CAx@CAu!S@CArGE8@CAhr @CAhr @CAae@CA[W>6@CATɅo@CATɅo@CAQ@CAJE@CAGz@CAGz@CA=b@CA=b@CA:S@CA7KƧ@CA7KƧ@CA4J@CA4J@CA0
)@CA0
)@CA&x@CA&x@CA&x@CA@CA_p@CA_p@CA+@CA@N@CA@N@CA@CA@CA$/@CA ѷ@CA ѷ@C@$tT@C@$tT@C@	k@C@\)@C@{@C@4֡b@C@4֡b@C@4֡b@C@`A7@C@҈p@C@ۋq
@C@D@C@D@C@ѷX@C@)^@C@)^@C@@@C@@@C@TɅ@C@
(@C@
(@C@4m@C@4m@C@9Xb@C@U@C@{@C@d8@C@U@C@@C@@C@@C@
=q@C@
=q@C@IQ@C@u%F@C@-
@C@@C@@C@YJ@C@'RT@C@YJ@C@'RT@C@YJ@C@n@C@n@C@˒:*@C@|@C@u!@C@r Ĝ@C@oiDg8@C@hۋq@C@hۋq@C@eO@C@eO@C@bM@C@eO@C@_F@C@[6@C@U2a|@C@NU@C@NU@C@NU@C@K]c@C@H@C@D*@C@>BZc@C@A7K@C@:~ @C@4m9@C@1&x@C@-
q@C@'RT`@C@$xG@C@ ě@C@}H@C@ ě@C@}H@C@@C@*0U@C@bM@C@bM@C@bM@C@
qu@C@@C?#@C?䎊r@C?䎊r@C?-@C?-@C?-@C?Vϫ@C?@C?@C?@@C?;dZ@C?@@C?@C?@C?حV@C?@C?@C?@C?حV@C?fA@C?@C?˒:)@C?˒:)@C?o @C?vȴ9@C?@C?vȴ9@C?/V@C?r@C?r@C?3@C?zH@C?zH@C?͞@C?͞@C?͞@C?&@C?&@C?&@C??@C?	k@C?	k@C?-V@C?	k@C?-V@C?$tS@C?$tS@C?ݗ+@C?ݗ+@C?ݗ+@C?@C?O;d@C?	@C?	@C?	@C?{J#:@C?4m@C?{J#:@C?|hs@C?|hs@C?y@C?|hs@C?sPH@C?v_ح@C?sPH@C?lC@C?o@C?iDg8@C?iDg8@C?eں@C?b}V@C?eں@C?_o@C?Xe,@C?U=@C?U=@C?U=@C?O
M@C?RT`e@C?O
M@C?KƧ@C?H˒:@C?E84@C?As@C?>6z@C?>6z@C?>6z@C?>6z@C?;dZ@C?;dZ@C?;dZ@C?8}H@C?8}H@C?4֡a@C?8}H@C?4֡a@C?1@C?.H@C?.H@C?.H@C?+I@C?'/W@C?'/W@C?'/W@C?!-w1@C?!-w1@C?!-w1@C?v@C?v@C?Xe@C?@C?)^@C?@C?@C?)^@C?)^@C?@C?@C?@C?)^@C?
M;@C?
M;@C?
=p@C?
M;@C?
=p@C?
=p@C?Ft@C?Ft@C?@C? hۋ@C? hۋ@C>!.I@C>!.I@C? hۋ@C>!.I@C>"@C>!.I@C>"@C>"@C>Fs@C>Mj@C>Mj@C>쿱[W@C>쿱[W@C>1@C>C-@C>C-@C>C-@C>ߤ?@C>C-@C>C-@C>ߤ?@C>ߤ?@C>ߤ?@C>ߤ?@C>+@C>Ϫ͟@C>Ϫ͟@C>Ϫ͟@C>Ϫ͟@C>Ϫ͟@C>Ϫ͟@C>Ϫ͟@C>Ϫ͟@C>҈p;@C>ȴ9X@C>t@C>m\@C>m\@C>&I@C>&I@C>&I@C>&I@C>ߤ?@C>@C>@C>2X@C>2X@C>}Vl@C>6z@C>6z@C>-@C>T@C>-@C>6z@C>-@C>-@C>T@C>af@C>@C>af@C>@C>@C>@C>,<@C>O;@C>,<@C>,<@C>O;@C>,<@C>,<@C>O;@C>,<@C>O;@C>,<@C>,<@C>Fs@C>Fs@C>Fs@C>$t@C>$t@C>$t@C>$t@C>@C>qi@C>qi@C>+J@C>+J@C>%@C>IQ@C>IQ@C>vȴ9X@C>p:~@C>p:~@C>p:~@C>p:~@C>l!-@C>p:~@C>p:~@C>l!-@C>p:~@C>l!-@C>l!-                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 @iMj@j`o h@jj~#@j鹌~($@jfB@k?,zxl@kT-@kk~(@k%2@kZ!R<@k5,=@k7J#9@kJ&I@kQzH@k5a@O@k^Q@kk.H@kX|@kU[W>@kk~(@k4m@kywk@kZ@kaf@k|@kZc@kQ_@kL_@klC@k@@kϱ[W>@kiDg8@lh#@lY}@lʗO;@lzxl"h@l?@mTɅ@man.3@mu@m܋C@mfA@m`A7@ma@O@mJE@m@m33333@n\N@mDg8~@n"NU@n@n@N@no @o @o,Xy=@ocS@oIԕ*@ndZ@ne+@nD@p=,<@qRT`e@psP@of?@n.2@o7Q@o^W@oa [7@o6C@oc	@n;dZ@m0iB@lZ@lu%F@ldJ@lO;@lxF]@lmeO@l.!.I@k{m@k~fffff@kV     @kf-@k?@k6@kZ1@kuB@k+jg@jb@j?@jNU@j~I^5@jJwkQ@jC\@jg@j.@j_.H@j`o h@jS#@j5e+a@j.nO@j<Q@jCC%@j3-@jS&@ijf@ivȴ@i84֡@i'@i$/@jrG@j<0U2a|@jQo i@jg:S@jcI^@jg$tS@jvcA \@j6@jw2W@je3@jr4m9@jhwkP@jϪ͟@jXe@jIQ@jzxl"h@jD@jqu"@j-@jn.3@j?@jm8@jMj@j6z@jQ@jRT`e@j`A@j	 @jz>BZc@jjc	@jP?@jᰉ'@j\@jKƧ@i-V@j@jUrGE9@ju%F
@jGz@jp
=@jE@j[W?@jh	ԕ@jo@jtnO@jqwk@jfn@jX쿱[@jQ͞@jIRT`e@jX_@jc@jerGE@jcl@jj_@jm[W>6@jwnP@jq@jcߤ@j\@j[Dg8~@jqy@jy˒:)@j1@j;dZ@j{,zxl@jy8Y@jxa|Q@j{'/W@j_@j@j'R@j@jb@jحV@j!-w@jn.@jr Ĝ@jA [@jS@j4֡b@js@jrGE9@j>BZc@j/V@j-V@jߤ@@jE84@jlD@jtL_@j/V@jL/{J@j!R<@j|h	ԕ@j{o i@jrU@jnIQ@jg!R@jXE@jR}Vm@jQS&@jKa@O@jR@jH74@j)S&@j'	k@j?<64@j;)^@j;rGE@j5$/@j1U=@j1TɅo@j;@j@u%F@j=@j4@j.p:@jC\@j=_o@j 
=q@j&@jJM@j$@j.ݘ@j/>BZ@j af@j<64@jzH@j"u%F@j&,<@j$)_@j8}H@j
*0U2a@jkP@j|hs@jn.3@iPH@i쿱[W@i%1@iiB@j/@j6@j1&x@j	k@j{@jڹY@j ě@j@j:)z@j
Xy=@jȴ9X@iH@iu@i@@ifA@ip
=@i73@i~$@i@ilD@i
=p@iPH@il"h	@i2a|@i-V@i1&x@iM:@i[W>6@izG@i|3@ieS&@i_v_ح@i[IQ@i^ߤ@@iTVu@i\d8@i`F@idm\@i\TɆ@ib5?|@i_m\@i^	ԕ+@i\zxl"@iP%1@iGϪ͞@i9Vϫ@i9ᰉ@iB>BZc@iI/w@i.W@i;5X@i,=@htSM@hH@h-
@hK]d@he@hrGE@h͎Mj@hS@hQ@h*0U2@h(@h?@hP{@hXe@hTɅ@h1.@h&@h@h1@hv@hpvȴ9X@honP@hmzH@hQlC@g˒:)@gvȴ9X@gy>6z@gvu!@g	@g!-w@gйY@g1'@gߤ@@g@g,<@g~($x@gae@gD*@g҈@gqi@gl!-@gC@grGE9@gy@grGE9@g@g&@g5Xy@g!.@g>BZc@g?@g}Vl@gg8}@gJ#9@gu%F@gIQ@gdZ@g6z@gF]c@gU2a|@g*0@g)y@g?@ga@N@g҉@gv`d@gy'/W@gC,zx@gkC%@ga	@gkAs@gbC@gn_o @gs$@gl
=q@ghxl"h
@gi@ge'R@gaQ@giQ@g+@g$t@g4K@g{,=@gpW@ga@gHo h@gHo h@gIe@gG@gZ@gg
M;@g[oiDg@gP,<@gH~($x@gW2W@gN
L/@gH|@gY&@gS$tS@g>&I@g+P{@g 3@g	 @g!R<6@g2@4n@g@$xG@gV[6@g`*0U@gY!-w1@gNJ@g9/V@g:tj@gPt@g`@gb+@gK=K^@gP)^@gVYJ@gT\)@gTD@gWn/@gShr!@gEzH@g>@g,}Vl@g .2@g),=@g/sg@g)@g"Mj@g`A7@g+a@gY@gU=@g͞@gfA@g84֡@gC-@fϪ͟@gu@g hۋ@gQ@gl@gߤ@fqu!@g 8YJ@g$tT@gTɅo@g~$@gp:~@g~$@f,<@fb}V@f@@fae@fu@f*0U2@foiDg@f~"@f
qu@f֌L_@fD*@f}H@fo @fI^5@f6C@fϚkP@fڵ?@fe+@fE84@fE@f'/W@f'/W@fR<6@f҈@f҈p;@f64@fn.3@f|@f5?|@fQ@fڴ9Xb@fn.3@fϘA@f_ح@f
L/@fPH@fPH@fѷX@fڵ'@fn.3@fȧ@f
qv@fڹZ@fB@fsh@f;dZ@fϗ+j@fm\@f*0@f_o@f(@fC%@fL/{@fL/{@f_o@f|C,zx@fsC]@fgm\@fo\(@fr'RT@fy{J#9@fr'RT@f_*0@fY	@fZhr@fY	@fRO;@fFtj@f#`A7L@fu"@fC]@fqi@f
_ح@f4m9@e*0@e_@f L/{@fu%@f @f ѷ@f
%F
L@fO;dZ@f ѷ@f'ݗ@f@+J@fX"h	ԕ@fht@fa"`@fkݗ+@f|=p
@f4K@gd8@gA [@fւ@4@fg8}@fc=K^@f_nP@fnYJ@f@frGE@f@f,@fIQ@f%2@f^5?}@fW>6z@f|:~ @fH@fH@f䎊q@f䎊r@f\(@f'/@f䎊q@f'/@fY@f'/@f˒:*@f*0@f     @f84֡@f1'@f͞@f     @f.H@f1'@fqj@fc	@fnVu@fh@@fkMj@flm@ff     @fZ䎊q@fr˒:*@f~$tT@flm@fr˒:*@f)^	@f)^	@fyp
=@foiDg@fyp
=@fqqu"@f@f)^	@fz,<@f8Y@f}=K@fxI^5@fj)y@fkO;d@fsᰉ'@fe\N@f\E@fk~($@fuE84@f~!.I@f'/W@f2W@f2W@f}@fz҈p;@f`d@f`d@f~!.I@f~!.I@fuDg8~@fc6z@fdu%F@fxxF@fr}Vl@feڹ@fX6@fLE@fFI^5@fQ(@f]&@fZu"@fCE84@f6m\@f*E@f&u@f*E@f/@f*E@f5a@N@f/@f+Xy=@f3ڹ@fGn.3@f<Q@fCC%@fF
L/@f?PH@f@|@fCC%@fA;dZ@fF	ԕ+@fZ҈p@frz@fuA [@fx1&y@flC@frz@frz@fom]@frz@fq+@fnOv_خ@fnOv_خ@fzp:@fnNU@fZ ѷ@fa+@fnNU@f~	k@f~	k@fdᰊ@fXOv`@ferGE9@fs?@fzp:@fry=c@fvS&@f}O
@fq[@fg\(@f`kP|@fXOv`@fd*1@fs@f!.H@frG@frxl"h
@fs@fu?|h@fe-@fa_o@fnM@fq[@fnM@fc1@fe@fu>6z@fxn@fݘ@fZc@fs"`@fs"`@fyiDg8@fv3@f@f>B[@f	k@fKƧ@f>BZ@f?@fq@fkQ@f~Fs@f!-w1@f?@f?@f!-w1@fZ1@f@f!-w1@f~Fs@f~Fs@fO
M@fzt@fsQ@f~Fs@f<쿱@f?@fZ1@f|/{J#@fxJ@f|/{J#@f~Fs@fJE@f<쿱@fzt@f}:)z@fZ@f [7@fJE@f [7@fz)^@f+@f+@fu!S@fu!S@fU=@f;5X@ftj~@fXy=@f}:)z@fJ#9@f|-
q@fD@frGE@fU=@fD@f-w1@ftj~@f;5X@fH@f1@f@f@fOv_@f@f@fn.@fOv_@fE@feO@ftj~@f@f,zxl@f@f@f@f@fMj@f%2@f@@fIQ@fIQ@fq@fOv_@f'/@fIQ@fMj@f}H@fU=@fMj@fIQ@f9@fY@f8YK@fIQ@fdZ@f+jg@fMj@fdZ@f+jg@f+jg@f!R@fU2a|@fS@f$tT@f˒:*@f9@f*0@fce@f$/@f'/@f!R@fU2a|@f8YJ@fF]c@f˒:*@fC,z@f˒:*@f8YJ@fȍ@f)^	@f=K@f8YJ@f,<@f8Y@f)^	@f)^	@f̷4m@fS@f73@fp
=@f73@f̷4m@f~$@fu@f~$@fm\@f)^	@fӨXy=@fp:~@f~$@fu@f}H@f̷4m@f=K@f73@f~$@f6z@fE@f-@fm\@f̶}Vm@fڹ@fa@N@fȌL_@fӨXy=@fR<6@fa@N@fӨXy=@fa@N@foiDg8@f6@fӨXy=@f#@fsh@f
qv@f|@fPH@f'RT`@f5Xy>@f5Xy>@fC%@f|@fnO@fQ@fPH@fc	@f5Xy>@f|@f|@f|@fc	@fڙ0
@f|@f'RT@f
L/@f|@f#@f@f'RT@f(@f`A@f	ԕ+@f'RT@gBZc @g ѷ@fm\@f(@gl!-@g @f(@f+j@f`A@f`A@fg	@gA7K@gzxl"h@f_F@f@f~@fp:@g @g @gu%@g @fp:@gl"h	@g
C\@gn@g$xG@gݗ@gNU@g$/@g\@g@N@g$1.@g\@g ѷ@g	+@g$xG@gy=c@gNU@g
=q@g&	k@g _o @g-V@gC,@gs@g&74@g!jf@g+"`B@g"͞&@g$xG@gNU@g)H˒@g3xF]@g+"`B@g!jOv@g&74@g/MjO@g([6@g0{@g/MjO@g-ᰉ@g$1&x@g,YJ@g7wk@g @g([6@g:hۋq@g9$/@g%O
@g/L_@gAZ@gHL/{J@gHL/{J@gB
(@gAZ@gEQ@gShr @gO=b@gB
(@g9S&@g,ݘ@g7@gF@gHL/{J@gI@gB
(@g>tj@gKnP@gX\)@gKnP@gEQ@gO=K^@gP-
@gF@gO=K^@gT)^@gT)^@gO=K^@gHK]c@gD ě@gO=K^@gHK]c@gEM:@gI1@gKnP@g_lC@giU=@gT)^@gI1@gEM:@gP-
@gV.2@g[n/@gZYJ@gZYJ@gFfB@gHK]c@gbU@getj~@gbU@getj~@gh;5X@gk ѷ@glfffff@gk ѷ@gh;5X@gaJ#9@gfD@gk ѷ@gfD@glfffff@giU=@go-w1@gh;5X@gXD@gh;5X@gw@g:S@g{q@go,zxl@gkI^@gleO@gp-
@gvOv_@g:S@gvOv_@gkI^@gfsP@gm@gvOv_@gvOv_@gsW>6z@gsW>6z@gkI^@go,zxl@gp-
@gkI^@gm@g:S@g@gt)@gw@gx`A7@gzH@gIQ@g9@gIQ@g~($@g%2@gVu@gdZ@g8YK@g{U=@g8YK@g ѷY@g@@g@@gVu@gC,z@gd8@gF@gd8@gqu!@gb}@g@g˒:*@gC,z@g~($@gF]c@gc	@gc	@g8YJ@g$tT@gc	@g8YJ@gS@gS@g8YJ@gA [@gF@g@ge+@gߤ@g*0U2a@gu@gE@ge+@ge+@gae@g~$@g=K@g8YJ@g$tT@gbM@gu@goiDg@g4m@gae@g}Vl@g\N@g4m@gu@g@gae@gm\@gq@g@g~$@gu%F@gq@gE@ga@N@ga@@gR<6@gE@gq@g($x@ga@N@gq@gE@g($x@g4֡b@gq@goiDg8@g4֡b@gR<6@gR<6@g4֡b@gěT@gq@g|@gn.3@gC%@gC%@ga@O@gԊqi@g&x@ga@O@gQ@g_ح@g5?|@gPH@gsh@g͘A@gѷX@gn.3@gԊqi@ga@O@gص'@g旍O;@gߥS@gP{@gص'@gߥS@gP{@gش9Xb@gش9Xb@g&x@g{J#9@gs@gص'@gQ@g҈p@g	k~@gs@g4J@g@gBZc @g@g	k~@gC\@g\(@gP{@gC@gC@g&I@gA [@g4J@gl!-@g|@gC\@gT@gl"h	@gl"h	@geO@geO@gC\@g$/@gz@gA@g1&y@g斻@gC@gA [@g+@gA@g+@gC@g
=q@gT@gOv_خ@gOv_خ@g
=q@gs@hg@gC@gTɅ@g퇓ݗ@g斻@gC,@h+J@hg@g_o @gC,@g$@h+J@gjf@h 	k@h 	k@g1.@h+J@hzG@h 	k@g1.@gp:@g_o @gy=c@g@N@g
=q@hH˒@hYJ@hYJ@h
{@hFs@h
xF]@g͞&@hiB@hZ@htj@hcA @h/V@hQ@h!R<@h@h!.@h!R<@h!.@h @hZ@hZ@h#@h!R<@h!R<@hZ@h
(@h!.@h"L/{J@h!.@hZ@h/V@h/V@hM:@h"K]c@h#1@h.)^@h)=K^@h&u!@h4YJ@h*-
@h"K]c@h ě@h˒:)@h ě@h-g	l@h*-
@h.)^@h&u!@h%nP@h ě@hY|@h&u!@h'b@hS&@h=p
@h
v_ح@g0U2a|@g0
)@gwkP@hZ1@g@h
O
M@g"`@h@h	KƧ@h@g@h
v_ح                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 ?lC?g	l?@4?*0
?kP{?>6z?,<?F]c?$?$?oiDg?1&y?~($x?]ce?Z?#9?rGE9?u%?}Vl!?,<?=K]?"`A?@N??{?ۋq?m\?åS?
=p?t?-V?6?|?(\)??Ʊ2W?MjO?ffffff?Ǡ	k?Ǵ3?e+?#wk?a@N?s?jfB?9D?ɅoiD? hۋq?vȴ?:S&?Ўqi?B?E84֡?-V?eO
?[?֍?JL_?䎊qj?@NU?qu!?ae?}H?QR?ݷXe?ܹ#w?1&?)_?⍸?`A7K?ڹY?lC?6z?m\?h	ԕ+?*0
?S?N;6?I^5?Y|?As?n?VϪ?$tSM?׼Z?Y|?'RT`e?sh?ҤTɆ?74?ѥu?fA?o?Q?Fs?C\?\N<?W>6z?:S&?䎊?ѷX?ȃnP?ǃ{J#9?eO
?b}?ŊڹY?ĵ??n.?
=p??YJ?° ě?Üߤ@?'/W?|?6C?vȴ9X??d7?'RTa?+?nP?Vt?\N;?cA \?xF]d?ڹY?ڹY?U=?&?XbM?|?-V?Q?'RT`?ᰉ'?Zc	?JM?ěS?bM?=K]?iB?lC?쿱[W?qu!S?
=p
?&x?Vl!-?1o?
=p
?wkP?u!?-
qv?Q?o?ᰉ?)y?+I????Ϫ͞?Ov_خ?H??E?-
?;dZ?e+a?Ϫ͞?C,zxl?l1&y?a4J?e+? ěT?5?|h?tj?n?$/?la4J?|C,zxl?҈?ᰉ'?{m?u%F???b}V?tj?q?6C-?_o ??+jg?L_?fA?*0U2a?4J?&?Mj`bM?vOv_خ?},<o!-w1?tZ?$tS?_Ft?L_?%2?Q_?zG{o䎊q޿@bM?u%F
??S?PH:6C-?N;5]}H˒?	 ?tj~?*6C-?p)^	?䎊q޿V?m}H˒_!-w1ſrn/?!-w1?}H˒?}}H˒?s*0U2a?xPH?{Q_?ye+a?bsPH[Q_?Q_p:6C-rnO;?z6C-?-
qv?䎊q?*6C-?sg?6C-Rn/?[Q_?wXe+?o!-w1?tZ?s*0U2a?]}H˒g?y_o ?|1&y?z6C-?҈οdzG{?䎊q?a@N?e+a?sg?$?ݗ+j?{Q_?pbM?@?tj~ۿuL_Xtj~?z6C-?ye+a?|1&y?ᰉ'?@NU?s*0U2a?xPHc*0U2a?	 ?4Jg?kQ_?C*0U2a?n?$tSM3*0U2a?:)y?C,zxl?bM?-
qv?e+a?:)y?䎊q?nO;?y_o ?xPH?v+I?N;5?S&?S&?xPH?$tS??O;dZ?F?S*0U2a?6C-?V?O;dZ?`A7L?|1&y?sg?,<uL_rsPHhtj~?{u%F?},<?~Q?nO;?*0?S&??sg?PH?2a|Q?tj~?S*0U2apbM?}Z?-
qv??SٿS*0U2a?]}H˒a4J?n??ku%F?5?|h?*0?nO;?{qu!S?*0U2a?&?)^	?xPH?䎊r?e+a3*0U2a?w?L_V?6C-?qu!S*6C-?$/?Xe?~Ov_ح?rnO;s*0U2a?v+I?{u%F?JD?O
M??qu!S?_o ?@?},<?z6C-?w?fOv_خUL_?wXe+?ᰉ'?Q_p?x*0
?xPH?wXe+?zvȴ9?	 ?|C,zxlj6C-?쿱[W??҈?{?*0?u%F
?)^	?)^	rsPH?Rn/?{qu!S?},<?q4J?6C-?ɅoiD?*0?u"?,<쿱?IQ?cA \?+I?2a|Q?m}H˒?-V?*0?J6C-tn*6C-?}Z??)^	?v+Ia4J?$tS?n?nO;s@NU?rsPH?x*0
?}Zl1&yqu"?htj~?䎊q?)^	?f?[Q_?{u%F?x*0
?)^	?|C,zxl?o!-w1?a4J?Z?ᰉ'?L_?S&¿]}H˒?wkP?*0?Xe+?zvȴ9?u%F?,<?,<?u"?rsPH?	 ?Xtj~ye+a?ie+a?_Ft?xPH?o䎊q?p:?x*0
?sPH?=K^?Fs?rsPH[Q_xPH?~Ov_ح?E?Ϫ͞?*0U2?a4Jo!-w1ſbn/?uL_v+IM}H˒?bM?},<?zvȴ9bn/?s@NU?|1&y?p:?+jg?:)y?Q_?Ϫ͞?u%?PH?Ϫ͞?Xe?xtj~?@NU?|??uL_o䎊q޿tntn?kQ_?ye+a?wXe+ԿUL_p)^	?Xtj~?!-w1?C*0U2a@bM?bn/3*0U2a??L_?l?rn/pbM?!-w1?Q_p?3*0U2a?4J?sg??F?+I?*0?S?PbM?C*0U2a?	 ?j6C-a4J?zvȴ9?ye+a?z6C-htj~?$tS??{Q_?:)y?Ov_خ?p)^	?x*0
?|C,zxl?uL_?1&y?$/?,<*6C-?!-w1?S&?vOv_خpbMs*0U2a?4J?IQ?+I?Z?&?tj~?N;5?$tS?*0U2?-V?hr Ĝ?+jg?Z?Ov_ح?ku%Fa4J?n/?@NU?~Ov_حf?u"UL_?y_o ?!-w1ſ6C-?qu!S?O;dZ?䎊q?wkP??PH?-
qv?[Q_?!-w1ſc*0U2a?y_o ?~Q?xPH?rsPH?Q_!-w1?rnO;?<64?`d83*0U2aq4Js*0U2ausg?*0?0
(?}Z?_o ?	 ?zvȴ9?n?䎊q?F?p:?䎊q?4J??{qu!SfOv_خ?uL_?)^	?$tSM?4J?IQ?|C,zxl?+jg?D*0?*0
?L_?Q_bn/?@NU?S&?},<?tj~?,<쿱ie+as*0U2awXe+Կs*0U2a?pbM?䎊q?ߤ??*0
?u%?	 ?@?|??n?쿱[W?J6C-?ᰉ'?+j?䎊q?{u%FS*0U2ao䎊q?쿱[W??Z?:6C-?N;5?=K^?zG{?O;dZ?Mj?}Z?䎊q?{u%F?)^	?n/?rsPH?tj~??n/o䎊q޿wzvȴ9?kP{?htj~?Z6C-?u%F
?fA?}H˒?|1&y?sg?+?Ϫ͞?*0U2Z6C-?lhtj~htj~?xPH?nO;?ᰉ'*6C-??sg?x*0
?~Q?$/?tj~ۿC*0U2a?o!-w1ſXtj~?usgf?hr Ĝ?nO;f?u"?	 ?|1&y?{?Xtj~?eL_?u%?	 ?S&?y_o ?{u%F?Ov_ح?s*0U2a?|C,zxl?p:??ɅoiD?n?}}H˒?T`d?},<ie+a??sPH?q4J?Q?N;5?z6C-?tj~?ᰉ'vOv_خy_o s@NU_!-w1?y_o ?},<?~Q?N;5Z6C-?g?z6C-?Xe?L_??usg?O;dZ?zG{?vȴ9X?O
M?L_?Zݘ?fǿS*0U2a?hr ĜkQ_?ie+a?s@NUm}H˒xPH?eL_?y_o ?ie+aS*0U2afOv_خ?rnO;?+I?vȴ9?*0U2a?@NU?*0U2?o䎊q?*6C-{u%F₿kQ_?_o?zvȴ9?kP{?f?[Q_rsPH?C*0U2a?{u%F?e+a?IQ?bn/a4J?Fs?|?bsPH?`A7L?䎊q?҈?rsPHpbM?bsPH??)^	?!-w1?*0?tj~?j6C-?$tSM?1&y?{u%F?xtj~?w?gy_o tzG{??v?&?-
qv?T`d?tj~ۿqu"?`bM?pbM?xtj~?rsPH?g?n/?kP{}}H˒~Qbn/?p)^	ye+a?rn/?x*0
?o!-w1?N;5?,<쿱?{u%F?vȴ9X?e+?tj~?x*0
q4J?J6C-?}Z?~Q?-V?}Z@bM?xtj~?Fs?tj~eL_?xPH?4J?䎊r?ie+a?c*0U2a?wXe+?xtj~o䎊q?Rn/?쿱[W??nOv_حv?J6C-?bn/?sg?2a|Q??ye+a?xtj~?$/?<64?ye+a?{qu!S?y_o ?zvȴ9?vOv_خ?&?2a|Q?҈?!-w1?y_o usgPbM?	 ?R<64?Fs?$tS?~Ov_ح?y_o ?~Q?o䎊q޿pbM?l?zG{?zG{?}}H˒?x*0
?q4J?C,zxl?PH?rnO;UL_|C,zxlj6C-?v+I?xPH?p)^	}Zz6C-x*0
?m}H˒m}H˒?쿱[W?eL_?fOv_خ?vOv_خ?uL_?usg?Q?O
M?$?A?`bM?{?o!-w1ſ`bM?bsPHxPH|C,zxl?p)^	tzG{s*0U2a?u!?O;dZ?	 ?_FtC*0U2a6C-?~Q?3*0U2a_!-w1?rsPH?rn/?s*0U2a?w?Z6C-x*0
?ku%F?o䎊q?rn/?hr Ĝ?R<64?䎊r?R<64?%2?2a|Q?xPHeL_?fOv_خws*0U2a?z6C-?!-w1?~Ov_ح?tj~?1&y6C-?tZ?}Z?p:?2a|Q?S&?tn?a4J?3*0U2a?_!-w1ſF?$/?-
qv?qu"?x*0
qu"m}H˒?xtj~?&?C,zxl?n?|??_!-w1?bsPH?,<?_Ft?_!-w1?{u%F?_Fts@NUnOv_ح?,<qu"?Mj?S&?zvȴ9?|C,zxl?Zݘ?~Ov_حpbM?g?|??usg?_!-w1?o䎊q?q4J?u%F?|?sPH?ku%FwXe+Կo!-w1?䎊rdzG{?rn/??vǿhtj~?fǿPbM?_Ft?ɅoiD?*0?xPH?v+I?xPH?UL_kQ_?s@NUkQ_htj~?tZkQ_?zvȴ9bn/?v+I?	 ?Ov_ح?{u%F?V?|1&y?tj~?*0
?UL_?C,zxl?0
(?*0?sPH?$tS?xtj~?x*0
?qu"eL_?Ov_خ?S*0U2ausg?[Q_*6C-?)^	?Z?Q_?q4J?kQ_fOv_خ?vǿo䎊q?htj~o䎊q?kQ_q4J?l1&ypbM?nOv_حeL_?n?zG{?Q_?0
(??tn?*0U2?m}H˒?`bM?O
M?$/?&?xPHvOv_خdzG{?1&?҈?uL_pbM?pbM?Xe?*0U2a?xtj~?ߤ??IQ?Z?E?O
M?䎊q޿f?{u%F?|1&y?vOv_خnOv_ح?xPHa4J?q4J?)^	?FǿrsPHFǿC*0U2a?}}H˒?8YJ?Z?u!?PH?v+Iqu"?usg?|C,zxlc*0U2a?vOv_خ?y_o V?ߤ??sg?fA?6C-?}H˒?Z?	 ?m}H˒:6C-?vȴ9XeL_?:)y?)^	pbM?H?}Z?|1&y`bM?rnO;?:6C-?a4J?vȴ9X?e+a?w?},<?)^	?)^	?htj~uL_?w?wXe+?x*0
?@NU?zG{?S&?hr Ĝa4J?g?|1&y?쿱[W??6C-?x*0
?C,zxl?,<?@bM}}H˒xPH?bsPH?g?q4J?tZ?O
M?sPH?uL_p)^	?	 ?bsPHie+a?{u%F?wkP?Ov_خ?hr Ĝ?z6C-?F?_Ft?R<64?4J?n/?*0U2?]ce?ɅoiD?Ov_خ?쿱[W??-
qv?bM?sPH?{ſ*6C-?p)^	?}Z?ku%F?*6C-?z6C-Z6C-?wXe+?a4J?$/?pbM?J6C-?u"?A?%2        ?	 ?|1&y?	 ?-
qv?nO;?:6C-?IQ??Ov_خ?u"?-
qv?1&y?|1&y?-
qv?}Z?}Z?[Q_wXe+?Q_?4J?zG{?%2?N;5?wkP?htj~?hr Ĝ?kQ_?{u%F?N;5X?sg?)^	?[Q_?=K]?*0U2?rn/?C,zxl?&?_Ft]}H˒?~Ov_ح?}}H˒?䎊q?-
qv?ᰉ'?%2?!-w1?Xe+ԿS*0U2a?u%F?Ϫ͞?~Ov_حo䎊q?e+a?-
qvnOv_ح?tnm}H˒?kQ_?kP{??rnO;?m}H˒?}H˒?)^	?p)^	:6C-??$tSS*0U2a?pbM?S?~Ov_ح???fOv_خ?N;5?n/o!-w1?*0U2a?-
qv                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 ?????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????333333????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 &.B#@3;42                                      1                                       