CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20120522   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P19    CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:48.222267Z    ORIGINAL_HEADER      sCTD,20250210CCHSIOWB
#Renamed 'CTDFLUOR_TSG' to 'CTDFLUOR_ALT_1' with units 'MG/M^3'
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2018-11-29. CTD data from cruise 18DD20120522, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20120522. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2012-12/index.php. 
#
# The information in this file for the cruise 2012-12 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-0072.ctd
#
# Start of originator file comment header
#
#*2018/11/29 14:22:51.16
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2012/06/01 08:02:46.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 2006
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : C44EDC1F
#    NUMBER OF CHANNELS  : 9
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            2.3            2006.7
#       2 Temperature:CTD               deg_C_(ITS90)   1.9166         6.6907
#       3 Salinity:CTD                  PSS-78          32.6639        34.5892
#       4 Sigma-t:CTD                   kg/m^3          25.6458        27.6748
#       5 Transmissivity:CTD            %/m             61.4           67.9
#       6 Oxygen:Dissolved:CTD:Volume   ml/l            0.41           7.23
#       7 Oxygen:Dissolved:CTD:Mass     µmol/kg         17.9           314.7
#       8 Fluorescence:CTD:Seapoint     mg/m^3          0.24E-01       0.74
#       9 Fluorescence:CTD:Wetlabs      mg/m^3          0.102          1.096
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        6  F       ' '     1
#       6  -99   ' '        7  F       ' '     2
#       7  -99   ' '        6  F       ' '     1
#       8  -99   ' '        8  F       ' '     3
#       9  -99   ' '        8  F       ' '     3
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2012-12
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P24
#    EVENT NUMBER        : 72
#    LATITUDE            :  49  50.17000 N  ! (deg min)
#    LONGITUDE           : 142  40.04000 W  ! (deg min)
#    WATER DEPTH         : 3989
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    CTDEDIT was used to remove surface records and records corrupted by shed
#	wakes; salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Transmissivity, Fluorescence and PAR data are nominal and unedited except
#	that some records were removed in editing temperature and salinity.
#
#    For details on how the transmissivity calibration parameters were calculated
#	see the document Transmissivity_Calculation.pdf.
#
#    The Oxygen:Dissolved:CTD calibration was done using the method described in 
#	the Sea-Bird Application Note #64-2 (Sea-Bird_64-2_Jun2012.pdf).
#
#    The Oxygen:Dissolved:CTD data are considered, roughly, to be:
#	±0.1 ml/l from 0 to 125 dbar.
#	±0.06 ml/l from 125 to 500 dbar.
#	±0.04 ml/l from 500 to 2000 dbar.
#	±0.02 ml/l below 2000 dbar.
#
#    For details on the processing see processing report: 2012-12-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5-- --6--- --7-- ---8--- ---9---
#!Pressu Temperat Salinity Sigma-t: Trans Oxygen Oxyge Fluores Fluores
#!re:CTD ure:CTD  :CTD     CTD      missi :Disso n:Dis cence:  cence: 
#!                                  vity: lved:  solve CTD:    CTD:   
#!                                  CTD   CTD:   d:CTD Seapoin Wetlabs
#!                                        Volume :Mass t              
#!------ -------- -------- -------- ----- ------ ----- ------- -------
#*END OF HEADER
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @K        data_max      @K        C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     =0  .    pressure                	long_name         pressure   positive      down   units         decibar    data_min      @   data_max      @c   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      =0  kP   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      L     temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?Z1'   data_max      @^5?}   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       =0     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      L     salinity                	long_name         salinity   units         PSS-78     data_min      @@U`A7L   data_max      @AKC]   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      =0 H   salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      L Ax   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @(   data_max      @s`        C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        =0 P   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      L    CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?E   data_max      ?zG{   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      =0 @   CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      L p   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       =0    PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d      L &   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min      @M33333   data_max      @P   C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     =0 68   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d      L sh   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         (    cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         (    time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min         data_max         C_format      %10d          latitude               	long_name         latitude   units         	degrees_N      data_min      @H2m   data_max      @H2m   C_format      %9.4f             	longitude                  	long_name         	longitude      units         	degrees_E      data_min      a5GX   data_max      a5GX   C_format      %9.4f             	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d           	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min        L   data_max        L   C_format      %4d        @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @K     @@      @@333333@      @       @"      @$      @&333333@(      @*      @,      @.      @0      @1      @2      @3@3fffff@5      @6      @7      @8      @9@:@;      @<      @=      @>      @?      @@      @@s33333@A      @A     @B      @B     @C      @C     @D      @D     @E      @Effffff@F@Ffffff@G@H      @H     @I      @I     @J      @J     @K@Ks33333@L      @L     @M      @M     @N@N@O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @RFfffff@Ry@R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @Z@[L@[     @[     @\      @\@     @\     @\@]@]@     @]     @]     @^      @^@     @^     @^     @_      @_9@_y@_     @`      @`      @`@     @``     @`     @`33333@`fffff@`     @a      @a      @a@     @a`     @ay@a     @a     @b      @b      @b@     @bVfffff@b33333@b     @b     @c      @c      @c<@cffffff@c     @c     @c     @c     @c@d)@d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @es33333@eə@e@f@f      @f@     @f`     @f     @f     @f     @f     @g      @g      @gFfffff@g`     @g     @g@g     @g     @h      @h      @hC33333@hVfffff@h33333@h     @h     @h     @i      @i      @i9@ip     @i     @i     @i     @i     @j      @j@ji@j     @j     @j     @jٙ@k,@k@     @k`     @k     @k     @k@k陙@l      @l      @l@     @l`     @lvfffff@l     @l     @l     @m      @m      @m@     @m@m     @m     @m     @n      @n@ni@n     @n     @n     @n     @o      @o@oC33333@o`     @o     @o     @o     @o     @p      @p@p      @p0     @p@     @pP     @pa@pp     @p     @p     @p     @p@p33333@p     @p     @p     @q      @q@q@     @qP     @qa@qp     @q     @q     @q     @q@q     @q     @q     @r      @r     @r!@r.fffff@r@     @rP     @r`     @rp     @r     @r     @r     @r@rfffff@r     @r     @r     @s      @s@s     @s1@s@     @sP     @s`     @sp     @s     @s     @sfffff@s     @s     @s     @s     @s     @t      @t     @t      @t333333@t@     @tP     @t`     @tp     @t     @tfffff@t     @t     @t     @t     @t     @t@u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u@u     @u33333@u     @ufffff@v      @v     @v      @v.fffff@vS33333@v`     @vp     @v     @v     @v     @v@v     @v     @w      @w     @w33333@wFfffff@wP     @w`     @wp     @w     @w@w@w     @w     @w     @w     @x      @x     @x      @x0     @x;33333@xT@x`     @xp     @x     @x     @x@x33333@x@x     @x     @x     @y      @y     @y      @y.fffff@yD@yP     @y`     @yp     @y     @y@yfffff@y     @y     @y     @y񙙙@yfffff@z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @zљ@z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{@{     @{     @{     @{     @{     @{     @{񙙙@{fffff@|     @|      @|0     @|@     @|P     @|`     @|p     @|@|@|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}Nfffff@}^fffff@}p     @}     @}     @}     @}     @}@}     @}     @}     @}@~     @~      @~0     @~@     @~T@~`     @~p     @~     @~     @~     @~33333@~     @~     @      @     @      @0     @@     @P     @`     @p     @33333@     @     @     @     @     @     @񙙙@33333@     @     @     @      @(     @-@733333@@@H     @P     @X     @`     @h     @p     @x     @     @     @     @@     @33333@     @     @     @     @@@     @     @     @     @ @     @33333@@      @(     @0     @8     @@     @Ffffff@P     @X     @`     @h     @p     @x     @~fffff@@     @     @     @     @     @@@@     @     @     @     @     @@      @     @@33333@      @(     @0     @8@D     @H     @P     @X     @`     @g33333@q@x     @     @     @     @     @33333@@     @     @     @     @     @     @     @     @     @     @      @     @     @!@(     @0     @8     @@     @Ffffff@X@`     @h     @p     @x     @@     @@     @@     @     @     @33333@33333@     @     @     @噙@񙙙@     @      @     @     @33333@      @(     @0     @8     @@@H     @P     @X     @`     @h@o33333@x     @     @     @     @     @     @fffff@@     @     @     @     @     @     @     @     @fffff@ @     @     @@      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p@w33333@     @     @     @     @     @@33333@     @     @     @     @     @     @     @     @     @fffff@     @     @     @      @(     @,@9@@     @H     @P     @X     @`@h     @p     @x     @     @     @33333@33333@     @     @     @@     @     @     @     @     @     @     @     @@	@     @     @      @(     @,@:fffff@@     @H     @P     @X     @`     @h     @p     @x     @     @fffff@     @     @     @     @     @@@ə@     @     @     @@񙙙@     @      @     @@33333@      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x@33333@     @     @     @     @     @     @33333@@33333@     @     @     @     @fffff@     @      @     @@@"fffff@(     @0     @733333@@     @H     @P     @X@`     @h     @p     @x     @@@     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @33333@     @      @(     @0@8     @@     @H     @P     @X     @`     @h@o33333@x     @     @     @@     @     @33333@     @     @     @     @fffff@     @     @     @@@      @     @     @     @      @$@1@8     @@@H     @P     @Vfffff@`@h     @p     @x     @     @@     @@     @     @     @@     @     @     @     @     @     @     @     @33333@     @     @     @      @(@0     @8     @@     @H     @P     @X     @`@h     @p     @x     @     @     @     @     @@     @@     @     @     @     @     @33333@     @@     @      @     @     @     @@0     @8     @@     @H     @Nfffff@Zfffff@`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @33333@      @     @33333@@      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @w33333@     @     @     @33333@     @     @33333@@     @     @     @33333@@     @33333@     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @33333@     @     @     @     @     @     @     @     @     @     @홙@ fffff@     @     @@     @     @     @     @      @$     @(     @,     @0     @4     @8     @;@@     @D     @H     @Lfffff@P     @S@X     @\     @`     @d     @i@l     @pfffff@s@x     @|     @     @     @     @     @     @     @     @     @@@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @㙙@     @     @     @     @     @33333@      @     @     @     @     @@     @      @$     @(     @,     @0fffff@2     @8fffff@<     @@     @D     @H     @L     @P     @X     @\     @`     @d     @h     @l     @n@u33333@x     @|     @     @     @@fffff@     @     @     @     @     @     @@     @     @     @     @     @     @33333@     @     @fffff@ߙ@     @     @     @     @33333@     @     @      @     @     @     @fffff@fffff@     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @33333@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@Ǚ@     @     @     @י@     @     @fffff@fffff@     @     @     @     @     @      @     @     @33333@@     @     @      @$     @'33333@,@0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @_33333@d     @h     @l     @p     @t     @x     @|     @fffff@     @     @     @     @@     @     @     @     @@@     @     @     @     @     @     @     @33333@     @     @     @     @     @33333@     @     @     @fffff@fffff@     @      @     @     @     @     @33333@     @     @      @$     @(     @,     @.@5@8     @<     @@     @D     @H     @L     @O@X     @\     @`     @d     @g@q33333@t     @x     @|     @fffff@@     @     @     @@33333@     @     @     @     @     @fffff@fffff@     @     @     @     @@     @     @     @     @@     @     @     @fffff@     @     @     @      @     @     @
     @@     @     @     @      @#33333@(     @,     @0     @4     @8     @<     @A@C@H     @L     @P     @T     @Vfffff@]33333@`     @d     @h     @l     @o33333@u33333@x     @|     @     @     @     @33333@     @     @     @     @     @@@33333@     @     @     @     @33333@     @     @     @fffff@fffff@@     @     @     @     @     @     @fffff@fffff@ @     @     @     @     @     @     @      @$     @(     @,     @/@4fffff@8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @_@d     @h     @l     @p     @s33333@xfffff@|     @     @     @     @@     @     @     @     @@     @     @fffff@fffff@     @     @     @     @     @@fffff@     @     @     @fffff@33333@     @33333@@     @     @     @@     @     @     @     @fffff@@@      @$     @(     @,     @0@4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @@     @     @     @@fffff@     @     @33333@     @     @     @fffff@     @     @fffff@     @     @     @     @     @     @     @@@     @     @     @     @     @     @      @(@,     @0     @4     @8     @:@D@H     @L     @P     @T     @X     @\     @a@d     @h     @l     @p     @t     @vfffff@fffff@     @     @     @     @fffff@@     @     @     @@     @fffff@@     @     @33333@fffff@     @     @     @@     @     @     @     @     @     @fffff@󙙙@     @     @      @     @     @@     @     @     @     @      @$     @(fffff@-@0     @4     @8     @<     @@fffff@B     @H@L     @P     @S@Xfffff@\     @`     @dfffff@g@l     @p     @t     @w@|@     @     @     @     @     @     @     @     @fffff@     @     @     @     @fffff@     @fffff@     @fffff@     @     @     @     @     @     @     @     @     @fffff@     @     @@     @      @     @     @
fffff@@     @     @     @      @$     @'@,fffff@0     @4     @8     @<     @@     @D     @H     @P     @T     @X     @\     @`     @d     @g@lfffff@p     @t     @x     @|     @     @     @@     @     @     @     @     @@     @     @@     @     @     @     @     @     @     @@@     @     @     @     @     @뙙@33333@     @     @     @      @fffff@@     @     @     @     @33333@$@'@,     @0     @4     @8     @:@@fffff@D     @H     @L     @Pfffff@Tfffff@X     @\     @`     @d     @h     @l     @p     @s33333@w@|     @     @     @     @     @fffff@     @     @33333@fffff@fffff@     @     @     @     @     @     @@33333@     @     @     @     @fffff@fffff@@     @     @     @fffff@@     @     @     @     @     @     @@%33333@(     @,     @0     @4     @8     @<     @?@D@H     @L     @P     @T     @X     @\     @^fffff@e@h     @l     @p     @t     @x     @zfffff@@     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @@     @     @     @33333@     @      @     @fffff@     @     @33333@fffff@     @      @$     @(     @,fffff@0@4fffff@7@<     @@     @D     @H     @K@T     @X     @\fffff@`fffff@d     @hfffff@lfffff@p     @t     @x     @|     @     @@@     @     @     @     @@     @     @     @@@     @33333@     @     @     @     @ϙ@fffff@     @     @     @     @     @񙙙@     @     @     @      @fffff@@fffff@@     @     @     @      @#@,     @0     @4     @7@=33333@@     @D     @H     @L     @P     @Tfffff@V     @]33333@`     @d     @h     @l     @pfffff@r     @y@|     @     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @@fffff@     @     @י@ݙ@     @     @     @     @     @33333@     @     @      @     @     @     @@33333@     @     @      @$     @(     @,     @0     @333333@:     @<     @@     @D     @H     @Lfffff@N@T     @X     @\     @`     @c                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @^5?}@K]d@n/@?@n/@S&@84֡@o h@\N@JM@M:@\N@\N@\N@S@ݗ@n/@n/@?@$/@$/@@?@$/@?@$/@$/@n/@n/@Fs@Fs@8YK@?@~($x@C@ ѷ@YJ@?@˒:)@]-V@*~"@sP@	ԕ*@9Xb@@$tS@$@}Vl@쿱[W?@t@uY|@ [7@q@EQ@&@*0@Mj@	Q@ C@\(@R<6@'0@T`d@lq@^ ѷY@@     @&@H˒:@m\@cA @"@@'RT`@L/{@xl"h	@Nߤ?@@y@c	@b@4@'RT`e@q@M:@oiDg8@q@|쿱[@^u@Do h@"C,@T@r@&I@`A@ce@dTɆ@+C,z@C{J#9@G)^@Q4J@_?@r{m@l!-@@ڟvȴ@%F
L0@XU@k~($@u"@=K^@_ح@ߤ@@m\@W@>B@ʦL/{@L_@g@R<6@'/@z@@)*0U2a@;dZ@CF]c@!ae@
ڹY@
n@/w@'&@+jf@1A [@+U=@]ce@cA \@8YK@ݗ+@s@2X@ߊ	@kP|@e+a@,=@U=@T`d@]cA@I^5?@rGE9@Z@K]d@{m@zxl"h@s@p
(@cS@[=K^@`
qu@Y@0{@)lD@o@Ft@C,zx@#x@[@nP@Xe@[W>6@tSM@ݘ@}p
=@\C,zx@Ks@Em\@@NU@Yb}@l>B[@{/V@{A@|?@}E@tSMj@n.2@P)^@B@($xG@p
=@~($@-w1@QR@_vȴ9@]}H@Y|@M(@I@I@Gy@FYJ@Dtj@?.H@6+jg@.zG@)@u"@?@u"@[W>@4֡a@a|Q@	@ilD@[$@fL/{J@ov@kI^@^ ѷY@U$/@cZ@`	k@حV@|@͸@ⶮ}Vm@䎊q@-
@Q@,<@#9@aae@T@J#9@>vȴ9X@6+jg@˒:*@>B@a|Q@U=@fA@3@h	ԕ@nO@*0@T`d@p:~@lVϪ@UfA@L@<Z@:>B@>ߤ?@;~$@@4m@irGE@Q@5?|@ޞ@$/@g	@&@
=p@lC@P{@m@f1.@1l@+J@V@ܬ1&@(@©@64@.2@C%@{lC@qiB@p
=q@jd7@e@eu@cS@V+J@KxF]@Ik~(@J	 @N;5X@X@@nt@qo@mw1@aGz@Rm@=Vl!@IoiD@Mqu"@L~($x@7KƧ@n@&IR@6z@5Xy@hr@~$@E@
=p@Mj@|@rGE@hr!@O;@҈p:@ϐ@ξߤ?@p:@>B@@C\@(@VϪ@C,z@*0U2a@8}H@-w1@쿱[W@vȴ9@u"@b}@y=c@kP|@U=@+j@cA @cA @hr @~($x@cA \@}H@lD@"@qu!@8YJ@jg	@sg	l@qo@mC\@f'@a@N@^@Y0
)@Stj~@P|@<hr@4j~@)rGE@ 	k@Z@_p@/{J#@	Q@K]c@K]d@@@1@3@m\@,zxl@s@\@
=q@iB@ߤ@3@a@@JE@~($x@84֡@IQ@S&@g	l@F@&x@M@q@3@ߤ?@y=c@:S@uXy=@ra|Q@qiB@l<쿱@]-V@L~($x@B\(@:G{@+a@@Mj@@_o@
D@_@Fs@@ 4m@/V@F@-
@@n.@p:@	 ѷ@@!.H@@ݗ@$/@_ح@@@6@jf@6@쿱[W@I^5@ C@ C@D@d8@ݗ+j@Z@,<@ڹ@@'@ߤ@l!-@y=c@0
)@u%@Mj@$t@2X@1.@5Xy@g@Vl!@@R@u%@ce@&@m\@ NU@Zc@@@Zc@s@g8}@nP@73@)_@$/@.H@}Vl@ߤ@1&y@ٳ|@\(@Zc@BZc @XbM@3@4֡a@~6z@u!R@l!-w@iB@hXy=@oVϫ@r{m@ql@o@t!-w2@eF
L0@R:)y@M:@L@M:@LcA \@G@@CF]c@D?@B@4n@E84֡@Eo i@<#x@4SMj@4SMj@1@ݘ@)^@
=p
@1&x@&I@@@{J#9@$@?@&I@ 4m@s@o hی@hr @)^@*fB@,VϪ@*g	@(@'lC@%S@$e@#
=p@"e+@!Gz@@/w@-V@	@ -
@!-w1@ [6@!o@&,<@/iDg8@1-@2s@-w1@(Xy=@%O
@&fffff@%1@?@(@ ѷY@$/@@
=p@F]c@-
@ȴ9X@-
@C@
qu@(\@1'@Ϫ͟@E@]cA@Ƨ-@C@Vϫ@x@`A@[@Z@n.@p:~ @ix@cA [@W&@U2a|@RT`d@O;dZ@LcA \@F-@A [7@>BZc @<j~#@;A@;5Xy@<64@<n.@B&IR@K)^	@Sa@O@Sa@O@RT`d@QX@\]ce@["`B@["`B@ZY@[q@Yb}@Ov_ح@K:)z@C$@=b@5?@*0
@!-w1@쿱[W@,=@@	ԕ*@~($x@
@	'RTa@tj~@	'RTa@6z@U2a|@-
q@o@{s@|hr@Õ$@,zxl@rG@x@RT`e@e+a@@I^5?@@N@ԕ*@@y	k~@r ě@+I@I^5?@u!.@WsPH@K:)z@Eo i@>ߤ?@9XbM@2m\@'-@#9@#9@'-@-
qv@,zxl"@5'0@>
(@As@=<64@,1&y@%F
L0@&L/{J@Fs@
$t@
ܑN;@
`d@
jOv@
1.@ݗ@
s@
GE85@
=q@
73@
eں@
t@
Gz@
e@
ٳ|@
ѷX@
\(@
dZ@
4֡b@
a|Q@
IQ@
,=@
@@
tj~@
nO@
@N@
{J#9@
o hۋ@
o4֡a@
jfB@
a@N@
\>@
TɅoi@
P*0U@
N+@
QN;5@
A@
6}Vl@
3ߤ@
.zG@
+U=@
 -
@
qu!@
Xe,@
:)y@
Mj@
	7KƧ@b}V@@!-w2@O;@~"@P{@M@Ϫ͞@;dZ@ɅoiD@쿱[@g	l@V@Xy=@@@=p
@t!-w2@eڹ@P{@?[W>@&x@PH@
qu"@p:@'-@+6z@64K@@n@IQ@B@7rG@eں@#@E@eO
@jJL@l"h	ԕ@l!-w@kC,z@Xy=c@G)^@=b@?@:)y@.zG@@
(@Z@ʌL_@m@Ft@c	@حU@C@'RT@@dqj@_Ft@Y+@O͞@K:)z@JW'@DS@:)_@+J@
M:@	'RTa@Fs@
+@
ڹY@
H˒@
Dg8~@
@
Q@
7@
䎊qj@
(\@
֡af@
W'@
#w@

(@
V@
<쿱@
d7@
Xy=@
	@
=K^@
@
ᰉ@
O
M@
9@
ěT@
%@
u%F@
Z@
xF]@
ݗ+@
M:@
zG@
$/@
eO@
eO@
7KƧ@
o @
?@
C-@
~@
3@
lD@
Q@
Q@
+j@
*0U2@
+J@
N;6@
&I@
 ѷ@
zG{@
j~"@
jJL@
mhr!@
be+@
E84֡@
:)y@
-V@
u"@
Q@
&IQ@
'RT`e@
 [6@
@
u%F@
U=@
$tSM@
%F
L0@
$tSM@
"3@
 -
@
 [6@
 'RT`@
U=@
wkP@
u"@
,=@
wkP@
+J@
Fs@
R<6@
Ov_@

	 @	J#9@	C,z@	rGE@	x@	rGE@	x@	@	O;@	fB@	B@	ce@	>6z@	Ϫ͟@	5Xy>@	o i@	|hs@	|hs@	33333@	-V@	r@	TɅ@	vȴ@	@@	_F@	$/@	tj~@	qi@	 ѷ@	Fs@	@	$/@	S&@	$tS@	{lC@	r䎊q@	p
=q@	o@	p@	p:~ @	oiDg8@	nt@	jg	@	]ce@	WsPH@	W>6z@	Yb}@	W
=p@	T,<@	Fs@	L_@	T*1@	W@	R䎊@	K:)z@	K]cA@	L/{J#@	N;5X@	Ks@	H@	F-@	?@	<j~#@	6}Vl@	,q@	,1&y@	,zxl"@	*0
@	(\)@	&IQ@	#9@	!.H@	䎊r@	@		'RTa@	JM@	@	u%F
@	$/@"@Q@kP@
=q@7@҈p@Ϫ͞@,<@~($@
(@1&y@6z@`A@tj@PH@u%F@oiDg@~\N<@}Vl!@weں@q@g	k@d7@ceO@]+j@Xe+@U2a|@P{@IQ@D*0@>
(@:~@:~@:^5?|@7rG@5'0@)@!R<6@Ov_خ@0
)@_F@@+J@$/@ݗ+k@hr @
@
=p
@n/@ IQ@Q@	k~@E@:~ @ᰉ'@M@ޞ@/w@ڹY@څݘ@bM@a@O@ΤT@/{J#@n@ȴ9Xb@?@g8}@a@N@7Kƨ@|hs@4m@
(@6z@@-@@S&@_o@$tS@R<6@zG@4J@Mj@~($x@=p
@Fs@@{~$@xF]d@u%F
L@t!-w2@ix@Y>BZ@SZ@N_o @H@H@Ca@N@>6z@<쿱[@;dZ@9~($@9#w@:S&@64K@-B@$/@6C@zG@	 ѷ@kP@1@F@!.H@m\@˒:)@ IQ@u%F
@?@:~ @O;@x@>BZc@@ڹ@M@
qu@5?|@o@A7K@Gz@A7K@Ft@iB@حU@т@ʌL_@?@g8}@p
=@)_@Q@U2a|@0U2a|@RT`e@tSM@?@9@wkQ@-w1@[6@Q@C,zx@@ԕ*@tj@$/@~"@}ڹZ@|PH@y"`@v+jg@r{m@o@l!-w@j~"@iᰉ'@bM@\]ce@Z1'@XD*@Vt@T*1@P|@J#9@E84֡@=K]@7Xe@43@0
(@.zG@$tSM@"`A@!.H@!ae@ 'RT`@u%@0
)@*0@*0U2@4J@҈@&I@oiDg@ݗ@S&@:S@#x@!.H@Q@C\@1@D@s@D@C\@C@Q@JL@>BZc@%1@@N@iB@?@ۋq@b}@8YJ@@m@|@/{J#@s@@n@<64@~($@}Vl@J@W@-V@Vϫ@1&y@$xG@n.3@ěT@Q@C,zx@u%F@+J@n@O;dZ@L/{@ݗ@b}V@~\N<@}Vl!@y"`@xF]d@xF@v!.I@sE@tj~@r ě@pD@qA [@o hۋ@l[W?@aGz@]ce@Xe+@V8YJ@GE84@=b@7KƧ@5'0@3ߤ@2a|Q@0U2a|@/{J#:@.2X@-
qv@-B@,1&y@)y@#S&@-V@S@@R<6@
L/{@eO@&I@tj@ IQ@($x@PH@@rGE8@l"h	@kP@\(@oiDg8@\@Ov`@Dg8~@唯O
@e@ܑN;@ڹY@JE@ԕ*1@а{@@E84@K]@~($@KƧ@֡a@jf@F
L0@`A@o@䎊r@vȴ9@[@_o@+j@Ov_@sh@ݗ+k@ߤ?@p:@oiDg@Q@}E@wkP@v+jg@mhr!@kQ@ix@e@bM@`A7K@]cA @[W>6z@Y|@T,<@PH@M5Xy>@Ks@KƧ@K:)z@I@H9Xb@H˒:*@G@@I^5?}@GE84@F?@E@C$@>
(@4֡a@3|@3|@2-V@1&x@0'RT@/Vϫ@/v@.zG@+a@@*0
@*͞&@&x@&L/{J@$tSM@ ěT@ [6@ -
@Q@C,zx@,<@@4J@@'/@
qiC@S&@$/@ hۋq@˒:)@m]@F]d@\(@MjO@D@oiDg8@oiDg8@@4֡a@hr!@VϪ@fB@唯O
@حU@T`d@_p@H@@NU@H˒:@vȴ9X@
(@Z@KƧ@W@{@U2a|@O
M@6z@*0U2a@-@
=p@}H@@@@Mj@!R<@O;dZ@qu"@ ѷ@&I@o h@o hی@~"@}H˒@|hr@{s@{m]@u!.@tSMj@s@r ě@mhr!@kC]@gfA@dqj@cZ@be+@`u!@_;dZ@^ ѷY@Zݘ@XU@UϪ͞@S@QR@O;dZ@K:)z@F]cf@C,zxl@B&IR@?[W>@<Z@9XbM@6}Vl@49XbN@1&x@0 ě@/Vϫ@/{J#:@-U=@+a@@*d7@(Xy=@',@#n.3@䎊r@1&@6C@PH@sh@@N@nO@\(@
(@
O;dZ@
qiC@	'RTa@YJ@ 4m9@ IQ@b}V@E@(@ȴ9X@g@A [@.2@C@@䎊qj@+a@@N@ ѷY@"`B@՛=K@ԕ*1@䎊@N;5@H@Ϫ͞@As@ΤT@@̘_@ʌL_@ȴ9Xb@)^@2W@s@[W>@Z@)y@3@KƧ@4K@{J#:@\)@n.3@IQ@vȴ@+j@ݗ+k@\(@L/{@n/@u%F
@:S@$tS@}H˒@xF@t#@ql@ql@p
=q@o-V@lVϪ@glC@dqj@]/w@[q@[W>6z@ZY@WsPH@QN;5@L/{J#@K]cA@J#9@H@D2W@@n@>
(@<64@:^5?|@8}H@4J@0'RT@/O
M@.2X@,>B[@-w1@*͞&@%zxl"h@#wk@"3@ [6@u%@vȴ@,<@kP|@qu!@6C@R<6@@$tT@!R<@q@K]d@@Q@@ 4m9@E@hr@PH@Q@lC@>B@@"`@(@rGE8@-
@SMj@@.2@>BZc@@+a@e@A [@ⶮ}Vm@@4@d8@"`B@ק&@fA@ӎMj@R@`A7@v_ح@;5X@͞%@:@K]c@
L/@2W@\N@C@n.@~@}H@?@3@g	l@W@-V@-V@2W@ ě@v@}Vl@zxl"@F
L0@@*0@sP@S&@hr @sP@bM@C%@YJ@JM@tj@%2@IQ@b}V@~$t@}Vl!@{s@v!.I@uY|@sE@ql@o-V@mhr!@hۋq
@f1.@de@b@4@_o@\]ce@XU@SZ@Rp:@QX@Q_p@P`A7@P{@P{@P`A7@P*0U@OAs@O;dZ@MjOv@L/{J#@JW'@IoiD@F]cf@Dg8}@A@@6@>6z@=v@<64@:^5?|@8Q@6z@2W@0
(@-B@+6z@+I^@)^@'/V@&x@$?@#S&@"wkQ@!.H@u@[@@Fs@S&@:)y@rGE9@L_@	'RTa@+I@:S@      @ b}V@ Vl!@ xl"h
@ l"h	@ \(@ MjO@ A [@ 
=q@ 
=q@ D@ oiDg8@ @ .2@ g	@ x@ 	k@ `A7L@ A [@ 䎊qj@ @N@ /w@ څݘ@ JE@ t@ N;5@ As@ Ƨ@ @ š@ g8}@ 74@ n@ 5Xy@ E@ J@ ߤ@ m\@ {@ q@ d7@ TɅ@ '@ S@ n.3@ h	ԕ@ 䎊r@ 쿱[W@ Ov_خ@ IQ@ C,zx@ O;d@ +J@ @ @N@ bM@ ߤ?@ Mj@ !R<@ @ k~(@ $/@ oiDg@ S&@ @4n@      @ }H˒@ }!.H@ {~$@ yrGE8@ x-
@ v!.I@ u!R@ sE@ r ě@ poiDg8@ nc	@ g8}H@ d7@ d%1@ cZ@ dZ1@ cA [@ cZ@ a'R@ ^ ѷY@ [$@ Zݘ@ XbM@ WsPH@ Vl!-@ SMj@ R䎊@ OAs@ M5Xy>@ L/{J#@ LcA \@ L@ KƧ@ J#9@ Gy@ A@ :~@ 8YJ@ 6z@ 4m8@ 49XbN@ 3g	l@ 2ᰊ@ 1&x@ 0U2a|@ .1@ .zG@ -
qv@ ,<쿱@ *d7@ (Xy=@ &'@ $?@ "`A@ "3@  ěT@  'RT`@ %@ 1&@ Q@ u%@ *0@ ҉@ hr @ )^@ \(@ ߤ?@ Vu@ 	7KƧ@ ݗ+@ Fs@ Fs@ M:@ @4n@ :S@  4m9@       ?>B?\(?MjO?䎊q??-V?C\?C]???fA?e?҈p?ߤ??$?+?fA?,<?,<?҈p:?N;5?͞%??)^??A?)?zG?6z?͞&?q?>B[?B?>B[?*0U2a?U=?S?ߤ@?S??O;d?$/?qi?q?+I??4m9?zxl"h
?w1?tj~?qu!S?nO;?cA [?\N;?YJE?Xy=c?T`d?N;5X?E??|hs?=p
=?:S&?7KƧ?5?|h?333333?0U2a|?/v?.2X?.H?-
qv?*0U2a|?%F
L0?$xF?$tSM?#wk?"h	ԕ?Ov_خ?C,zx?tj??rGE9?I^5??
=p
?1&x?1&x?	k~(?_o?Fs??u%F
?n.? hۋq? hۋq? hۋq?!.H?>B?rGE8?rGE8?	k~?-
?Fs?MjO?s?A [??C,z?ᰉ'?>BZc?e?e+?iB?҈p;?]ce?֡af?ԕ*1?|??y?Ƨ-??n?)_?)?4m?}Vl?9XbN?-V?{? ě?͞&?'?
=p?n.3?
=p?-
?=K^?Fs?_F?ݗ+k?tj~?N;6?-
q?!R<?~($x?7KƧ??o hی?˒:)?}Vl!?zG{?y(?xl"h	?tSMj?qiB?qiB?p
=q?o?oiDg8?lC?k~($?m8Y?j~"?hۋq
?g	k?ffffff?dZ1?b}Vm?`A7K?^?]ce?[6?Z1'                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @@U`A7L@@UjOv@@U`A7L@@Uce@@Uce@@UjOv@@Uce@@Uce@@UfA@@UfA@@UjOv@@UfA@@UjOv@@UfA@@UfA@@UfA@@Uce@@UfA@@UjOv@@UjOv@@UjOv@@UfA@@UfA@@UfA@@UjOv@@UjOv@@UjOv@@Up
=@@UjOv@@UjOv@@UjOv@@Um\@@Um\@@Uw1@@Up
=@@Um\@@UfA@@Um\@@Uw1@@U-V@@U@@U
qv@@U8YK@@Ub@@U
qv@@U?@@U(@@U!.@@VzG@@VVu@@V$t@@VFs@@WO;d@@WkP@@W	@@Wo@@W_o@@Wv_ح@@W{J#:@@WkP@@WrG@@X$xG@@X@@W+@@W@@X
qu@@XNU@@X'RT@@XF@@Yu@@YY}@@Z1'@@ZnO@@ZfB@@[@@]w1@@_RT`e@@`:~ @@`-
@@ay@@c@@g4֡a@@lL_@@mϪ͞@@n6z@@n҈p;@@o@@oo@@o͞@@p}H@@p˒:*@@qo@@tL_@@y^@@~&I@@<쿱@@&@@e+@@wkQ@@z@@u%F@@+I@@@@K]@@4m@@ڹY@@g	l@@Q@@-
@@3@@cA @@$t@@[6@@qu!@@Ų-V@@+jg@@oiDg8@@ʂ@4@@˶E@@xF@@JE@@Թ#x@@
qv@@֊qi@@Q@@&@@fA@@䎊r@@-w1@@7Kƨ@@6z@@3@@%F
L@@?|h@@+j@@H@@-@@v_ح@@     @@薻@@ѷX@@&x@@k~(@@Q_@@W'@@{m@@ᰊ@@6z@@@N@@@N@@Mj@@땁$@@tj~@@g	l@@J#9@@tj~@@$@@\N@@C]@@n.@@Q@@!-w2@@%1@@Q@@%2@@@@m]@@%2@@s@@:)z@@C,z@@~@@C,@@c	@@Z@@wkP@@@@F
L0@@w1@@8Y@@Xy=@@@@sg@@`A7L@@?|h@@쿱[@@<64@@
M;@@䎊r@@|@@tj@@ѷX@@C@@$/@@+@@ [7@@0
)@@:S@@Q@@TɅo@@Q@@Q@@A [@@@@TɅo@@B@@o@@n@@-@@JE@@-w1@@|Q@@iB@@>BZ@@nO@@qiC@@m@@PH@@nO@@|@@Q@@	 @@򅇓ݘ@@W@@}Vm@@0
@@3@@oiD@@=b@@@@e+@@)@@YJ@@[6@@K]c@@[6@@73@@o @@v_ح@@\(@@-V@@?@@ݗ+@@O
M@@v@@v@@'/W@@E84@@zH@@@@o @@l"h	@@,<@@$@@|@@@@lC@@\N@@C]@@%1@@j~#@@~($x@@Z1@@ߤ@@@$@@Mj@@S@@9@@6z@@6z@@"`B@@C,z@@,zxl@@@N@@n.3@@{J#9@@{J#9@@m]@@a@@@ݗ+k@@ߤ@@@9XbN@@`d@@D@@L_@@oiDg@@+J@@%@@s@@c	@@1.@@-@@A@@2X@@@@@@IQ@@$t@@Fs@@'@@t@@C-@@o @@*0@@}H@@@@@@
=q@@U2a|@@eO@@9Xb@@ [7@@Gz@@x@@@@R<6@@B@@y@@R@@	 @@C\@@JL@@W'@@kP|@@ ě@@J#9@@@@a@@@Q@@$@@PH@@cA \@@*1@@S@@*0@@t@@4m@A K]c@A p:@A	 @AS&@A)_@AC,@A~@AS&@AS&@APH@APH@A/V@A]cA@A]cA@A]cA@AZ@AJ#9@A@A~$@Ajf@A]cA@A]cA@AZ@A{J#9@Awk@AFs@A쿱[@Aj~@AS@AɅoi@Au"@AE@A+a@An/@A
(@A!R<@A$/@Au@A4K@A_o @A
(@Afffff@Avȴ9X@AA@A$tS@AO
M@AAs@A!.I@AFt@A)^@A4֡a@A!-w1@A,@Am\@A&I@Aȴ9X@Aߤ?@A҈p;@A@A@AϪ͟@A)^@A
=p@A@A$tS@A>6z@AKƧ@AsPH@Aݗ+@A+j@A-
q@A[6@ANU@AK]c@A˒:*@A4m@A9Xb@A9Xb@AIQ@A'RT@A@A`A7@A	R@A
JL@A	2W@A	N;6@A
	 @A	"`@A	@A	@A	ᰉ'@A	.H@A
e+@A
3@A
@4n@A
ᰊ@A@A(\@A2W@AVϪ@A?@AJ@A|@AE@A2W@A"h	ԕ@AtSM@AJM@A
[@A
Y|@A
}H@A
=K@A
`A7L@A
fA@A
ڹZ@A
@A
-V@A
n/@A
@A
hr!@A
,=@Au@AR<6@AC-@A1@ART`e@AKƧ@AH˒:@A$tS@A,@AXe@A@A!.I@Ax@A+@Am\@A쿱[W@A!.I@A
=p@A!-w1@Av_ح@A+@AfA@AحV@A+j@A@Ar@A[W>@Ar@A˒:)@A;dZ@A-@AF]d@A}H@A*0@Ay=c@AIQ@A҈p@AD@A`A7@A`A7@Ap:@AěT@Ap:@Ae+@A҈p@A`A7@A	k@A+@A_p@A#w@A|Q@A(@An.@A	 @A0
@A6z@Aa@N@AeO@AU=@AU=@AS@A@AZ@AƧ@AƧ@Aa@O@A6@Aa@@AlC@A@A@A/{J#@A<쿱@AI^5?@Aqj@Ae@AS&@Aw1@Azxl"h@AO
@A+j@A\(@A4K@A@A%@Az@Ac	@A'@A҈p;@AA@AϪ͟@A]cf@A"@A,@A'/W@A4֡a@AXe,@Aeں@Aeں@Ay@A&@A@A&@A?@A/V@A/V@AK]d@AحV@A@A;dZ@A@AF]d@A	ԕ+@A6@A73@Al"h	@AYJ@AěT@Ae+@A4֡b@APH@A$tT@A$/@A+@ATɅo@AR<6@AN;6@A"`@Au%F@As@A0
@APH@AJ#9@AW>6z@AxF]@A:)z@AA@AE@A
=p@AQ@A(\@A64@A9XbN@A9XbN@AVϪ@A`d@AcA \@A~($x@A#@A?@Au"@A!.H@AZ@A@Azxl"@A~($x@A쿱[@AO
M@Ap
=@A-V@An/@AH˒@Aڹ@A ѷY@Aڹ@At@At@A$/@A($x@A+jg@AE@A@Aȴ9X@Ax@A&I@Ax@A)^@A'/W@A!-w1@A,@AKƧ@AAs@AKƧ@AXe,@AlC@Ab}V@A&@A-@A @A }H@A :~ @A D*@A [6@A D*@A 1&x@A 
qu@A 6@A  ě@A eO@A ۋq
@A @A `A7@A {@A!*0U2a@A!o hی@A!^5?}@A!_o@A!R@A!>BZ@A!-@A"I^5@A"e+@A"e+@A"0U2a|@A"@4n@A"Q_@A"Zc@A"T`d@A"T`d@A"{m@A"@A"}Vm@A"<64@A"`A@A"G{@A"fB@A"C,@A"C,@A"䎊q@A"C,@A"m\@A#҉@A#&@A#,zxl@A#6z@A#dZ@A#n.3@A#xF]@A#~$@A#Q@A#Mj@A#@A#6@A#Ƨ@A#5Xy@A#|@A#Ƨ@A#
=p@A#҈@A#%2@A#%2@A#lC@A#ݗ+k@A#
=p@A#@A#a@O@A#Ƨ@A#Ƨ@A#q@A#q@A#eO@A#@A#g	l@A#xF]@A#S@A$!-w2@A$%1@A$VϪ@A$~($x@A$@A$@A$Z@A$o h@A$S@A%/w@A%v@A%@A%oiDg@A%(@A%ڹ@A%ڹ@A%E@A%S@A%C\@A%ڹ@A%(@A%@A%\(@A%ڹZ@A%sg@A%!R@A%-V@A%H˒@A%
qv@A%@A%U=@A%ݗ@A%Y|@A%\@A%fA@A%jOv@A%Vl!@A%\@A%jOv@A%w1@A%zxl"h@A%!R@A%%@A%U=@A%1@A%oiDg@A%S@A%@A%b@A&4K@A&!R<@A&
L/@A&+jg@A&5?|@A&c	@A&l!-@A&fffff@A&}Vl@A&vȴ9X@A&%@A&Fs@A&ȴ9X@A&]cf@A&1@A&x@A&1@A'Xe@A'Xe,@A'b}V@A'b}V@A'lC@A'@A'kP@A'zH@A(73@A(73@A(*0@A(1&x@A(73@A(H@A(YJ@A(D@A($tT@A)-w1@A)7KƧ@A)4J@A)0
)@A):S@A)Q@A)x@A)o@A)@A)|Q@A)oiD@A)o@A)n.@A)ԕ*@A)ԕ*@A)B@A)@A)'RTa@A)o@A)(@A)@A)@A)-@A)lD@A*&IR@A*C\@A*a|Q@A*{m@A*\(@A*ᰊ@A*wkQ@A*S&@A*S&@A*}Vm@A*fB@A*~@A+'/@A+PH@A+nP@A+nP@A+PH@A+F]c@A+F]c@A+Z@A+C%@A+9@A+F]c@A+P{@A+dZ@A+:)z@A+S@A+U=@A+$@A+~($@A+Ƨ@A+g@A,n.@A,1&y@A,ߤ@@A,!-w2@A,64@A,SMj@A,cA \@A,cA \@A,SMj@A,VϪ@A,]ce@A,m8@A,wkP@A,*1@A,TɆ@A,@A,j~@A,7@A,@A,Z@A,Z@A-:@A-K]@A-'0@A-V@A-[@A-qu"@A-5Xy>@A-\@A-fA@A-Y|@A-IQ@A-Y|@A-m\@A-zxl"h@A-jOv@A-hr!@A-8Y@A-8YK@A-,=@A-S@A-ᰉ@A-(@A._o @A.;5X@A.Ov_خ@A._ح@A.vȴ9X@A.z@A.qi@A.O;@A.Fs@A.}Vl@A.Q@A.@A.&I@A.Ϫ͟@A.+@A.]cf@A/ hۋ@A/@A/)^@A/
M;@A/Xe@A/v@A/!-w1@A/!-w1@A/'/W@A/E84@A/iDg8@A/lC@A/Xe,@A/sPH@A/lC@A/eں@A/b}V@A/lC@A/4m@A/$tS@A/͞@A/@A/حV@A/@A/fA@A/Vϫ@A/+j@A0@A0     @A0F]d@A06@A0'RT`@A01&x@A073@A0NU@A0Xy=@A0eO@A0oiDg8@A0oiDg8@A0oiDg8@A0|@A0|@A0-
@A0@A09Xb@A0)^@A0)^@A0p:@A0p:@A0F@A0ۋq
@A0e+@A0@A0\)@A1@A1#w@A1*0U2a@A14J@A1Dg8~@A1TɅo@A1hr @A1x@A1|Q@A1|Q@A1x@A1|Q@A1~($@A1'RTa@A1l@A1B@A1'R@A1X@A1o@A1ԕ*@A1@A1>BZ@A1s@A1lD@A2s@A2䎊@A2e+@A2䎊@A2-V@A23@A2JL@A2Q_@A2Q_@A2^5?|@A2h	ԕ@A2kP|@A2qiC@A2xl"h
@A2S&@A2 ě@A2W@A2`A@A2 ѷ@A2䎊q@A2~@A3u%@A2m\@A3S&@A3I^@A3'/@A3PH@A3&@A3,zxl@A36z@A3F]c@A3F]c@A3=K^@A3S@A3xF]@A3Mj@A3A@A3Mj@A3$@A3U=@A3*0U2@A3m]@A3Ƨ@A35Xy@A35Xy@A3Q@A3g@A3g@A3Q@A3%2@A3lC@A3@A3s@A4@A4@A4%1@A4?@A4]ce@A4g8}@A4q@A4q@A4o h@A4C@A4zxl"@A43@A43@A4?@A4[W?@A4#x@A4Ʌoi@A4>B[@A4hr@A4>@A5o i@A5o i@A4e@A5V@A5'0@A5qu"@A5+a@A55Xy>@A5F
L0@A5O;dZ@A5}H@A5ݗ@A5hr!@A5O
@A5+j@A5+j@A5O
@A51@A5sh@A5\(@A5Ϫ͞@A58YK@A5Ϫ͞@A5!.@A6
(@A6zG@A6Ov_@A6($x@A6+jg@A68YJ@A6?@A6fffff@A6}Vl@A6+J@A6qi@A6$t@A6@A6}Vl@A6}Vl@A66z@A6-@A66z@A6&I@A6m\@A6A@A6҈p;@A6҈p;@A6ߤ?@A6@A6@A6@A6Fs@A7Ft@A7Ft@A7
=p@A7@A7)^@A7!-w1@A7$tS@A7$tS@A7'/W@A74֡a@A7>6z@A7As@A7H˒:@A7KƧ@A7U=@A7\(@A7\(@A7eں@A7sPH@A7y@A7&@A7	@A7&@A7$tS@A7?@A73@A7vȴ9@A7@A7+@A7حV@A7@@A7rG@A7rG@A7rG@A7䎊r@A8     @A8@A8@A86@A8$xG@A8*0@A84m9@A84m9@A8A7K@A8NU@A8Q@A8U2a|@A8eO@A8eO@A8l"h	@A8y=c@A8y=c@A8u!@A8n@A8'RT@A8'RT@A8-
@A8u%F@A8
=q@A8-
@A8ěT@A8F@A8D@A8҈p@A8ۋq
@A9rGE@A9#w@A90
)@A9:S@A9:S@A9=b@A9Gz@A9Gz@A9Gz@A9JE@A9Dg8~@A9N;5@A9Q@A9hr @A9u!S@A9|Q@A9b}@A9@A9l@A9(@A9|@A9^5?}@A9D@A9y@A9_o@A9ԕ*@A9_o@A9@A9"`@A9>BZ@A9s@A9lD@A9lD@A:n@A:s@A:e+@A:#9@A:䎊@A:#9@A:6C@A:=p
@A:M@A:Zc@A:kP|@A:xl"h
@A:{m@A:ݘ@A:S&@A: ě@A:}Vm@A:Y@A:Y@A:@A:W@A:`A@A:,<@A:`A@A:`A@A:sP@A:fB@A:~@A;S&@A;u%@A;	@A;,zxl@A;dZ@A;C%@A;MjO@A;J#9@A;Z@A;a@N@A;a@N@A;tj~@A;xF]@A;{J#9@A;Mj@A;$@A;ߤ@A;A@A;ߤ@A;q@A;@A;E@A;m]@A;m]@A;E@A;~($@A;m]@A;q@A;~($@A;5Xy@A;g@A;C]@A;A [@A;C]@A;$@A;$@A;s@A;s@A;\N@A<J@A<J@A<ߤ@@A<L_@A<@A<tj@A<Q@A<%1@A<"h	ԕ@A<(\@A</{J#@A<2W@A<<쿱@A<PH@A<]ce@A<]ce@A<VϪ@A<m8@A<wkP@A<zG@A<zG@A<qj@A<N;@A<qj@A<3@A<쿱[@A<3@A<3@A<3@A<3@A<1&@A<?@A<#x@A<Z@A<!-w@A<E@A<>@A<E@A=(@A=84֡@A=84֡@A=<64@A=84֡@A=F
L0@A=Vl!@A=`A7L@A=ce@A=`A7L@A=fA@A=sg@A=w1@A=$/@A=!R@A=%@A=Xy=@A=v@A=8Y@A=Ϫ͞@A=Ϫ͞@A=Ϫ͞@A=Ϫ͞@A=?@A=S@A=(@A=!.@A> ѷY@A>t@A>_o @A> ѷY@A>+jg@A>!R<@A>$/@A>Ov_@A>!R<@A>.2@A>.2@A>?@A>H@A>R<6@A>Vu@A>YJ@A>\N<@A>R<6@A>fffff@A>l!-@A>vȴ9X@A>IQ@A>qi@A>$t@A>@A>}Vl@A>2X@A>Q@A>@A>&I@A>A@A>Ϫ͟@A>ߤ?@A>C-@A>1@A>x@A>@A>Mj@A>Mj@A>"@A?@A?
=p@A?v@A?'/W@A?1@A?4֡a@A?1@A?>6z@A?E84@A?KƧ@A?Xe,@A?Xe,@A?\(@A?eں@A?lC@A?|hs@A?	@A?O;d@A?@A?@A?-V@A?&@A?[W>@A?3@A?@A?K]d@A?fA@A?@A?+j@A?rGE9@A@F]d@A@	ԕ+@A@@A@ ě@A@ ě@A@6@A@$xG@A@'RT`@A@'RT`@A@*0@A@$xG@A@-
q@A@>BZc@A@A7K@A@H@A@K]c@A@Q@A@[6@A@eO@A@r Ĝ@A@y=c@A@r Ĝ@A@y=c@A@tj@A@@A@9Xb@A@TɅ@A@p:@A@F@A@e+@A@\)@A@$tT@AArGE@AA_p@AA@AA#w@AA-w1@AA=b@AAA [@AAN;5@AAJE@AAN;5@AATɅo@AAae@AAk~(@AAu!S@AA7Kƨ@AA@AA@AAR<6@AA(@AA^5?}@AAo@AAy@AAN;6@AA_o@AA"`@AAR@AAY}@AA-@ABn@ABI^5@ABe+@AB䎊@AB䎊@AB&IR@AB)y@AB-V@AB=p
@ABC\@ABJL@ABGE85@ABM@AB^5?|@ABZc@AB^5?|@AB^5?|@ABZc@ABh	ԕ@ABu%F
@AB{m@ABp:@ABp:@ABvȴ@ABL/{@AB@AB ě@AB}Vm@AB ě@AB@AB@ABn@AB@AB@AB)_@AB)_@AB`A@AB`A@ABsP@ABڹY@ABc	@ABm@ABD@ACnP@ACnP@ACnP@ACnP@ACPH@ACs@AC,zxl@AC,zxl@AC9@ACC%@AC@N@ACJ#9@ACJ#9@ACP{@ACZ@AC]cA@AC]cA@ACdZ@ACxF]@AC{J#9@AC~$@ACxF]@ACeO@ACA@ACU=@AC*0U2@ACq@AC*0U2@ACq@ACm]@AC~($@ACZ@AC6@ACƧ@ACa@O@AC6@AC5Xy@ACg@AD@ADL_@AD!-w2@AD"h	ԕ@AD"h	ԕ@AD"h	ԕ@AD(\@ADFs@ADM:@ADPH@ADI^5?@ADFs@ADj~#@ADcA \@ADcA \@AD`d@ADg8}@ADwkP@ADzG@ADzG@AD?@ADN;@ADS@AD1&@AD1&@AD@ADj~@AD?@AD@AD>B[@ADJM@AD@ADhr@AD!-w@ADhr@AD!-w@ADe@ADe@ADe@ADe@ADD@AE:@AEV@AE'0@AE'0@AE*0@AE!.H@AE/w@AE+a@AE+a@AE2a|@AE<64@AEF
L0@AEL_@AEL_@AEY|@AE\@AEsg@AEzxl"h@AE}H@AEM:@AEzxl"h@AEڹZ@AEڹZ@AE!R@AEhr!@AE+j@AEv@AE%@AEU=@AE\(@AE8Y@AE\(@AEcA @AEb@AES@AEᰉ@AFt@AFt@AEڹ@AF
L/@AF@AFu@AFOv_@AF$/@AF+jg@AF1.@AF8YJ@AF8YJ@AF8YJ@AF;5X@AF5?|@AFR<6@AFOv_خ@AFR<6@AFc	@AF\N<@AFfffff@AFp:~@AFs@AFz@AF%@AF@AF@AF@AF6z@AF'@AF@AFߤ?@AFt@AFϪ͟@AFx@AFMj@AFFs@AFMj@AFMj@AG)^@AGv@AGv@AG,@AG$tS@AG,@AG4֡a@AG4֡a@AG>6z@AG>6z@AGAs@AG;dZ@AGAs@AGKƧ@AGXe,@AGU=@AGeں@AGlC@AGiDg8@AGo@AGo@AGv_ح@AG4m@AG&@AG{J#:@AGO;d@AGݗ+@AG-V@AG?@AG	k@AG͞@AG[W>@AG͞@AGr@AG@AG˒:)@AG@AG@AGfA@AHF]d@AG#@AGrGE9@AGrGE9@AGrGE9@AG+j@AG䎊r@AH@AHbM@AH@AH}H@AH$xG@AH}H@AH>BZc@AH73@AH>BZc@AHK]c@AHK]c@AHK]c@AH>BZc@AHNU@AHU2a|@AH_F@AHbM@AHhۋq@AHYJ@AH'RT@AH@AH-
@AHtj@AHtj@AHu%F@AHu%F@AHd8@AHd8@AH{@AH9Xb@AH4m@AH
(@AHTɅ@AHTɅ@AHp:@AHF@AHF@AHe+@AHe+@AH`A7@AH@AHe+@AH	k@AI ѷ@AI ѷ@AI@AI@AI@AI	k~@AI@AI#w@AI#w@AI&x@AI [7@AI*0U2a@AI-w1@AI4J@AI=b@AI=b@AIDg8~@AIJE@AIN;5@AIQ@AIXbM@AIXbM@AI^@AI^@AI^@AI^@AIae@AIk~(@AIrGE8@AIu!S@AI|Q@AI|Q@AIb}@AIoiD@AIoiD@AI7Kƨ@AIoiD@AIR<6@AIu@AIn.@AIn.@AIl@AI|@AID@AIo@AIo@AIy@AIo@AI2W@AI2W@AIy@AI@AIᰉ'@AIiB@AIe@AIR@AI>BZ@AIe@AI-@AIlD@AI.H@AJu%F@AJ	 @AJ@AJOv`@AJ䎊@AJ&IR@AJ)y@AJ:)y@AJGE85@AJC\@AJT`d@AJT`d@AJa|Q@AJkP|@AJh	ԕ@AJ{m@AJ~"@AJݘ@AJ@4@AJ{m@AJݘ@AJ@4@AJݘ@AJp:@AJL_@AJS&@AJ0
@AJᰊ@AJwkQ@AJvȴ@AJ0
@AJvȴ@AJL/{@AJ>B@AJY@AJ<64@AJ@AJ@AJ@AJ@AJ)_@AJn@AJ@AJ͞&@AJ`A@AJ,<@AJڹY@AJ,<@AJ ѷ@AJ ѷ@AJG{@AJ ѷ@AJڹY@AJG{@AJ䎊q@AJfB@AJc	@AJC,@AJC,@AJfB@AKI^@AKu%@AKu%@AK҉@AK'/@AKs@AK҉@AK"`B@AK	@AK	@AK"`B@AK,zxl@AK/V@AK/V@AK6z@AK=K^@AKJ#9@AKMjO@AKMjO@AKMjO@AKP{@AKP{@AKW>6z@AKa@N@AKjf@AKqu!@AKtj~@AKn.3@AKxF]@AK{J#9@AKQ@AK@AKeO@AKq@AKq@AKq@AKMj@AK:)z@AKA@AKA@AKwk@AKS@AK@AK@AKm]@AK@AK~($@AKZ@AK6@AK6@AKa@O@AKa@O@AKa@O@AK@AKƧ@AK
=p@AKa@@AK
=p@AK
=p@AKݗ+k@AKQ@AK
=p@AK%2@AKlC@AKg@AKC]@AKlC                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @s,@s+33333@s,@s0     @s0     @s1@s1@s0     @s1@s6fffff@s6fffff@s333333@s1@s4@s1@s333333@s.fffff@s0     @s6fffff@s8     @s6fffff@s8     @s4@s0     @s333333@s333333@s333333@s4@s4@s1@s0     @s6fffff@s;33333@s;33333@s;33333@s;33333@s;33333@s&fffff@s.fffff@s6fffff@s<@s6fffff@s8     @s6fffff@s0     @s0     @s8     @s4@s&fffff@s     @s@s333333@sP     @s`     @sY@sP     @sK33333@s333333@s4@sC33333@sNfffff@sY@s[33333@sS33333@s>fffff@s333333@s)@s&fffff@sfffff@s@s     @s@rfffff@rfffff@rfffff@r33333@r{33333@rs33333@r^fffff@r<@q     @q     @q@qfffff@q@q@qfffff@q@q     @qd@p33333@p@py@pL@p9@p0     @p@o      @m     @m9@l     @lVfffff@k33333@l	@k@j     @jfffff@j     @j6fffff@js33333@j@j@h@h`     @h@gٙ@g33333@g@gfffff@gVfffff@gVfffff@fs33333@e     @e@e33333@e@e     @e陙@f@fS33333@di@dffffff@d33333@d@də@d@dfffff@d@c@c@c陙@cfffff@c33333@aVfffff@a333333@aVfffff@avfffff@as33333@ap     @afffff@a33333@afffff@a@a33333@a     @`@`33333@`33333@`     @`y@`33333@`fffff@`33333@`33333@`ə@`@`l@a|@a     @a     @afffff@a     @a|@`#33333@_Y@_@_s33333@_@^fffff@^33333@^33333@_,@_ٙ@^fffff@]fffff@\33333@]&fffff@]l@\Ffffff@Yٙ@Y     @Yٙ@Z@ZY@Zfffff@Zfffff@YS33333@YY@Yffffff@Ys33333@Yfffff@Y33333@Y@X33333@Y@Y&fffff@Y,@Y,@XY@XY@Xs33333@X33333@X     @Xfffff@W33333@W@W@X@Xffffff@Xl@Wffffff@WFfffff@Wl@W     @Wfffff@W33333@X@Xfffff@X33333@X@X@Xl@Yfffff@Y     @Z@Z333333@Zfffff@Y@Y33333@Z,@Zffffff@Z33333@Z@Z@Zfffff@Z@Z&fffff@Y33333@Y@Yfffff@Y33333@V33333@U     @U33333@Vfffff@V@     @Vy@VS33333@Ufffff@V@V      @Ufffff@U     @V@     @Vl@V@Vfffff@Vٙ@Vfffff@V     @V@V33333@V33333@V@V@V@Vfffff@Vfffff@VL@U33333@Uy@U`     @U33333@U33333@V      @U33333@TS33333@TY@Tffffff@Tfffff@T@T     @T@T@T@T@Tٙ@T33333@T33333@Tfffff@Ty@S33333@Sfffff@Sٙ@S33333@S33333@S@S@Sfffff@RFfffff@R@Q33333@Q@R      @R@Q     @Qffffff@Qffffff@Ql@Qy@Q@Q     @Q33333@Q@Q33333@Qfffff@Qfffff@Q     @Q@     @Q&fffff@Q&fffff@Q333333@Q9@Q&fffff@N333333@Hs33333@Ffffff@Ffffff@GY@H&fffff@I&fffff@I@E@E@Efffff@E@Efffff@F@F      @Es33333@E     @E@Efffff@Efffff@EY@E@     @E@     @E@     @EL@EL@Dffffff@DL@DL@Dffffff@D@     @D@D@D333333@DL@DL@CL@C@     @CY@CY@Cs33333@C@C     @Bs33333@B@     @B&fffff@BY@B@Bfffff@B     @B@C&fffff@C@C      @B33333@B33333@B33333@C33333@Cfffff@C@C33333@C33333@C33333@C@C     @Cs33333@Cs33333@Cs33333@Cs33333@C@Bfffff@Bfffff@B     @B@Bfffff@BL@B333333@B333333@BL@Bffffff@B@BL@A@A&fffff@A     @Afffff@A@A333333@Affffff@As33333@Affffff@AL@A333333@A@@33333@@fffff@@@>fffff@=33333@=33333@>333333@>L@=fffff@>@>L@>     @>L@=fffff@<33333@<      @;ffffff@;L@;@;@<@;33333@:fffff@;      @;@;333333@;333333@;333333@:      @:L@:L@9fffff@9@9@9333333@9@9L@9@9@9@:@;ffffff@<      @;@;L@;ffffff@;@:33333@:      @933333@933333@933333@9fffff@:L@;     @;     @;     @;     @;     @;     @;ffffff@;333333@:L@:333333@:@:333333@:L@:ffffff@:ffffff@;fffff@;fffff@;fffff@<      @;fffff@<      @;@;@;L@:fffff@:fffff@:fffff@:@9ffffff@7ffffff@6333333@6333333@6L@6L@6      @5@533333@5@5@5@5@5fffff@533333@5ffffff@5ffffff@5     @5ffffff@5ffffff@5     @5     @3fffff@3@3@3@3fffff@4@4      @3@3@3      @2@2@2fffff@233333@233333@2@2@2@2@2@2     @2     @2ffffff@2L@2L@2L@2333333@2L@2ffffff@2ffffff@2@2L@2ffffff@2ffffff@2L@2ffffff@2L@2L@2@2      @2@2333333@2@1fffff@1@1@133333@1@1@1     @1L@1@0fffff@1      @1@1L@1333333@0      @0      @0@0L@0L@0L@/@0333333@0333333@0@0@0      @0333333@0333333@0L@0333333@0      @0      @/@0      @1@1333333@1@1L@1ffffff@0      @/@/@/@/@/@0      @0      @/@/@/@/333333@/      @.@.      @.333333@.@.@.@.@.ffffff@.@.ffffff@.ffffff@.@.333333@.ffffff@.@.333333@-      @-333333@-      @-333333@,@,@,@-      @-ffffff@.      @-@-      @,333333@+@,      @+@+ffffff@+333333@+333333@*@*@*@*@*@*@*@*@*@*@*@*@*@*@*@*@*@*@*@*@+      @*@*@*@+      @*@*@*@+      @*@*@*@*@*@*@*@*@*@+      @+      @*@*@+      @+      @+333333@+333333@+ffffff@+ffffff@+333333@+333333@+333333@-      @,@,@,333333@,ffffff@,@-@-333333@,@,ffffff@,333333@,      @+@+@+@,      @,333333@*ffffff@*      @*      @*@*@*@*@*      @*      @*      @*333333@*ffffff@+      @+333333@+@+@+@+@+333333@+ffffff@+@,      @,@-333333@-ffffff@-@-@-@-@-@.333333@.333333@.ffffff@.333333@.ffffff@.ffffff@.      @.      @.ffffff@.333333@.ffffff@.ffffff@.333333@.ffffff@.@.ffffff@.@.333333@.333333@.ffffff@.ffffff@.ffffff@.ffffff@.333333@.      @.      @.      @.      @-@-333333@-333333@-333333@-333333@-      @,@,ffffff@,      @,ffffff@,ffffff@,333333@,333333@+@+333333@*ffffff@*@*@*@*ffffff@*@*@*333333@*@*ffffff@*ffffff@*@*ffffff@*ffffff@*ffffff@*@*@+      @+333333@+ffffff@+      @+333333@+      @+333333@+      @*@*333333@*      @*@*@*ffffff@*      @)@*333333@*333333@*      @)ffffff@)@*333333@)@)@)@*      @)@)@)@)@)@)@)@)@)@)@)@)@)@)@)@)ffffff@)@)@)ffffff@)333333@)333333@)@)@)@)ffffff@)ffffff@)ffffff@)ffffff@)333333@)      @)333333@)ffffff@)ffffff@)333333@)      @)333333@)333333@)333333@)333333@)333333@)      @)333333@)333333@)333333@)333333@(@)      @)333333@)      @)      @)333333@(@)      @)333333@(@)      @(@(@(@(@(@(@(@(@)      @(@(@(@(@(@)      @(@(@(@(@(@(@(@(@(@(@(@(@(@(@)      @)333333@)      @)333333@)333333@)ffffff@)333333@)333333@)ffffff@)ffffff@)ffffff@)ffffff@)ffffff@)ffffff@)ffffff@)@)@)@)ffffff@)@)@)@)@)@)@)@)@)@)@)@*      @)@)@)@)@)@*333333@)@)@)@)@*      @)@)@*333333@)@)@*      @)@*      @*333333@)@*      @)@*      @*      @*333333@*333333@)@)@*      @*333333@)@)@)@*      @)@)@*      @*      @)@*ffffff@*      @*      @*      @*ffffff@*333333@*333333@*333333@)@*      @*333333@*333333@*      @*ffffff@)@*      @*ffffff@*ffffff@*@*333333@*ffffff@*ffffff@*@*ffffff@*@*@*ffffff@*@*@*@*@*@*@*@*@+      @*@+      @*@*@*@+      @*@+      @+333333@+      @+333333@+333333@+333333@+      @+333333@+333333@*@+333333@*@+      @+333333@*@*@+333333@*@+333333@+333333@+333333@+@+333333@+ffffff@+ffffff@+@+ffffff@+ffffff@+333333@+ffffff@+ffffff@+ffffff@+@+@+@+@+@+@+@,      @,      @+@+@,      @+@+@,      @,333333@,      @+@,333333@,ffffff@,333333@,ffffff@,333333@,      @,@,ffffff@,@,@,@,ffffff@,ffffff@,ffffff@,@,@-      @,@,@,@-333333@-      @-      @-      @-333333@-333333@-333333@-ffffff@-333333@-333333@-333333@-ffffff@-ffffff@-333333@-ffffff@-ffffff@-333333@-@-ffffff@-@-@-@-ffffff@-@-@-@-@-@.      @-@-@-@.      @.      @.333333@.333333@.333333@.333333@.@.ffffff@.ffffff@.ffffff@.ffffff@.ffffff@.@.ffffff@.@.@.@.@/      @.@/      @.@.@.@.@/      @/333333@/      @/      @/333333@.@/333333@/ffffff@/@/      @/      @/      @/ffffff@/ffffff@/ffffff@/ffffff@/@0      @/@/@0      @0@0      @0@0333333@0@0@0      @0333333@0333333@0333333@0L@0L@0@0333333@0ffffff@0ffffff@0ffffff@0     @0     @0@0     @0@0@033333@033333@0@0@0@033333@033333@0@0fffff@033333@0@0fffff@0fffff@0fffff@1      @1      @1333333@1@1333333@1L@1ffffff@1L@1     @1L@1333333@1ffffff@1ffffff@1ffffff@1L@1L@1ffffff@1     @1     @1@133333@133333@1@1     @2      @1fffff@1fffff@2@2@1fffff@133333@2333333@2333333@2333333@2L@2333333@2L@2333333@2@2333333@2L@2333333@2L@2L@2ffffff@2L@2L@2ffffff@2L@2@233333@2@2@2@2@2@233333@233333@233333@233333@233333@2fffff@2@233333@2fffff@233333@2@2@2@2fffff@2@3@3      @3@3      @3@3L@3L@3333333@3333333@3L@3L@3ffffff@3ffffff@3L@3     @3ffffff@3ffffff@3ffffff@3@3@333333@3@3@3@4      @4333333@4333333@4333333@4333333@4@4@4ffffff@4     @4     @4ffffff@4ffffff@4L@4@433333@4@4fffff@433333@433333@433333@5      @4fffff@4fffff@4fffff@5@5@5      @5L@5L@5333333@5333333@5333333@5333333@5     @5333333@5333333@5333333@5333333@5     @5@533333@5@533333@5@5     @5@5@6      @6      @5fffff@6@5fffff@5fffff@6L@6L@6333333@6L@6L@6333333@6     @6     @6     @6     @6@6     @633333@6@633333@633333@633333@633333@7      @7@6fffff@7      @7      @7333333@7333333@7333333@7333333@7333333@7333333@7     @7     @7ffffff@7ffffff@733333@7@7     @733333@7fffff@7fffff@8      @7fffff@8      @8      @733333@8L@8333333@8333333@8ffffff@8ffffff@8@8@833333@8@8@8@833333@8@9@8fffff@9@9@8fffff@9333333@9L@9333333@9ffffff@9     @9ffffff@9@933333@9fffff@:@9fffff@:L@:333333@:ffffff@:ffffff@:     @:@:33333@:33333@:33333@:fffff@:fffff@:fffff@;@;@;@;333333@;333333@;     @;ffffff@;     @;@;     @;@;     @;@<      @<@;@<      @<ffffff@<333333@<ffffff@<333333@<     @<33333@<@<@<@<@<@<@=      @=      @=      @=@=333333@=      @=@=333333@=333333@=333333@=L@=ffffff@=ffffff@=333333@=L@=@=@=33333@=@=@=33333@>      @>      @>      @>      @>      @>      @=fffff@>@>     @>L@>L@>L@>@>333333@>33333@>fffff@>fffff@>@>     @>ffffff@?333333@?333333@?333333@?@?333333@?ffffff@?L@?     @?@?     @?ffffff@?     @?@?@?33333@?@@@@@@@@&fffff@@333333@@&fffff@@333333@@333333@@@     @@@     @@L@@@     @@@     @@@     @@@@fffff@@@@fffff@@fffff@@fffff@@33333@@fffff@@fffff@@fffff@@fffff@@fffff@@@@fffff@A      @@33333@A@A@A&fffff@A333333@A&fffff@A@     @AY@Affffff@Affffff@AY@Affffff@A@A@A@A     @A@A@A     @Aٙ@A@A@Aٙ@A@Aٙ@Aٙ@A@Aٙ@Afffff@Afffff@B      @B@B@B@B333333@B&fffff@B333333@B333333@BL@B@     @BL@BY@Bffffff@Bs33333@B@B     @B     @Bs33333@B     @Bfffff@Bfffff@Bfffff@B33333@B     @B     @B     @Bfffff@C      @B33333@C@C@C@B33333@C@C@     @CY@CL@CY@Cffffff@C     @Cs33333@C@Cs33333@C@C@C@C@C@C@C33333@C@C@C@Cfffff@C@C@Cfffff@D@D&fffff@D&fffff@D@D@     @Dffffff@Dffffff@D@     @D333333@D@D33333@Dfffff@D33333@D@D@D     @D33333@D33333@Dٙ@Dfffff@E      @D@E&fffff@E@E&fffff@E@E@E      @E@     @EL@EY@EL@E@     @EL@EL@E@E@Efffff@E@E@Efffff@E@E33333@E     @Eٙ@Eٙ@Efffff@E@Eٙ@F      @F@F&fffff@F&fffff@E33333@F      @FL@F@     @F&fffff@F333333@FY@F@     @FY@Fs33333@F@Ffffff@F@F@F     @F33333@F33333@F33333@F     @F     @F@F@Ffffff@Ffffff@G      @Ffffff@Fٙ@G@     @GY@GL@GY@GL@Gffffff@Gs33333@G@     @GY@GY@G     @G     @G     @G@G@G@G     @G33333@Gٙ@Gٙ@G@G@G     @G33333@H@H@H333333@H&fffff@H&fffff@H      @G33333@H333333@H333333@HL@Hffffff@Hffffff@H     @H     @H     @H     @H@H33333@Hfffff@H@Hfffff@H33333@H     @H33333@H     @H@H     @H@Hfffff@Hfffff@I      @I      @H33333@I      @I      @I@I      @I      @I333333@I&fffff@I@     @IY@IY@IY@IL@I     @Is33333@I@I@I     @I@I     @Ifffff@I33333@I     @Iٙ@I@I33333@I33333@Ifffff@I33333@I33333@J      @J&fffff@J@J333333@Jffffff@JY@Js33333@JY@JL@JY@Jfffff@Jfffff@J@J@Jfffff@J33333@Jfffff@Jٙ@Jٙ@J     @K      @J33333@K@K@K@K&fffff@K@K      @K@K333333@KL@KY@KL@K333333@KY@K     @K@Ks33333@K     @K@K@K@K@K33333@K33333@Kfffff@Kfffff@K@K     @K33333@Kfffff@K33333@K@K     @K@Kfffff@Kfffff@Kٙ@Kٙ@Kfffff@L@L      @L      @L@L      @L      @K33333@L333333@LL@L333333@LY@Lffffff@L@     @LY@L     @Ls33333@L@L@L@L@L@L     @L@Lfffff@L     @L@L@L33333@M      @Lfffff@Lfffff@L@M@M@M@M@M&fffff@M@M&fffff@M333333@M@     @MY@ML@ML@ML@M@     @M     @Mffffff@Ms33333@M@Mfffff@Mfffff@M     @M@M     @M     @Mfffff@Mfffff@M33333@M     @M33333@M@M@M@Mfffff@Mfffff@M                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ?5?|h?-V? ě?陙?S?tj~?Z1'?5?|h?vȴ9?^5?|?zG?lC?tj~?1&x?+?hr ?O;d? ě?`A7?-V?-V?^5?|?&x?7KƧ?j~#?-V?C%?$/?E?I^5?`A7?      ?lD?E?ȴ9Xb?n?1&x?Q??|hs?lC?I^5?m?n?Ƨ-?1&x?+?$/?|hr?7KƧ?zG?zG{?n?l?-V?zG?I^5??vȴ9X?/v?Vt?
=p?\(?Gz?lC?+?lD?+I?tj?Z1'?333333?Vt?-V?Ƨ-?+?QR?nO;?Q?1&x?A7Kƨ?1&x?O;dZ?
=p?ߍO;dZ?-V?"`A?tj?E?ܬ1&y?ܼj~#?E?zG{?tj~?-V?^5?|?$/?S?Ԭ1&y?x?l?n?nO;?XbM?XbM?Q?ѩlD?I^5??ěS?д9XbN?љ?xF?ěS?Гtj~?A7Kƨ?m?"`A?"`B?ɺ^5?|?r ě?ǍO;dZ?\(?lC?tj?+I^?ļj~#?nO;?zG{?9XbM?öE?l?M?`A7?tj?7KƧ?öE?lD?l?\(?öE?5?|h?Q?`A7?öE?-V?
=p?nP?`A7L?vȴ9X?n?Q?nP?M?`A7?7KƧ?
=p?7KƧ?lD?ěS?S?ěS?`A7L?`A7L?&x?ěS?ěS?7KƧ?öE?;dZ?dZ1?j~"?lC?|hr?&x?-V?
=p?lD? ěT?`A7L?"`?bM?$/?7KƧ? ěT?ěS?n?I^5??7KƧ?GzH?nO;?bM?dZ1?p
=q?S?+?nP?vȴ9X?-V?nO?-V?7KƧ?hr Ĝ?öE?\(?
=p?-V?
=p?A7Kƨ?bM?$/?Õ$/?-V?GzH?nO;?`A7L?`A7L?ěS?`A7K?-V?n?A7Kƨ?|hr?nP?
=p?M?$/?GzH?bM?&x?A7Kƨ?hr Ĝ?-V?333333?nO?n?-V?S?° ě?n?hr Ĝ?M?333333?öE?lD?-V?tj~?Q?tj~?7KƧ?333333?\(?tj~?`A7?+?S?$/?\(?+?S?-V?l?nP?° ě?|hr?      ?&x?bM?-V?hr Ĝ?7KƧ?nO;?I^5??nP?nO?hr Ĝ?nO?
=p?`A7L?nO;?333333?333333?\(?333333?\(?Q?E?ļj~#?$/?$/?-V?&x?-V?      ?l?333333?A7Kƨ?`A7L?Q?Õ$/?+?`A7?Q?Q?S?Q?333333?$/?I^5??;dZ?I^5??\(?lD?ļj~#?nO?-V?-V?9XbM?-V?lD?7KƧ?° ě?9XbM?
=p?n?GzH?
=p?hr Ĝ?`A7?7KƧ?-V?zG{?n?Z1'?Q?Ł$/?&x?E?\(?S?hr Ĝ?"`?`A7?Q?ěS?\(?9XbM?$/?hr Ĝ?"`?hr Ĝ?nP?° ě?`A7?$/?`A7L?\(?nO?`A7?nO;?M?° ě?&x?ěS??|hs?lD?M?° ě?Q?S?Z1'?`A7?Z1'?$/?-V?/w?&x?šo?+?I^5??tj?&x?Q?GzH?S?° ě?n?\(?`A7?öE?hr Ĝ?öE?9XbM?° ě?Z1'?-V?ļj~#?`A7?-V?A7Kƨ?\(?tj?\(?Õ$/?vȴ9X?Õ$/?-V?I^5??bM?S?-V?l?I^5??
=p?bM?&x?ěS?I^5??lD?\(?S?nO?`A7?Õ$/?GzH?j~"?A7Kƨ?Q?      ?ěS?nO;?`A7L?öE?nO?öE?GzH?`A7L?nO?Z1'?tj?öE?`A7L?333333?9XbM?tj?ěS?lD?Z1'?n?&x?Q?ļj~#?Z1'?tj~?-V?hr Ĝ?M?;dZ?lD?"`?;dZ?hr Ĝ?\(?lD?-V?-V?öE?zG{?n?333333?M? ěT?7KƧ?öE?&x?`A7K?\(?ěS?j~"?ěS?nP?I^5??hr Ĝ?ļj~#??|hs?nO?+?M?Q?
=p?\(?\(?l?`A7?ļj~#?öE?
=p?
=p?9XbM?+?šo?
=p?I^5??° ě?$/?Õ$/?nO;?\(?tj?`A7?-V?M?I^5??ěS?`A7L?A7Kƨ?-V?&x?&x?nO;?+?`A7?$/?+?ěS?Q?333333?
=p?tj~?+?
=p?-V?öE?vȴ9X?n?Õ$/?GzH?I^5??lD?333333?hr Ĝ?öE?lD?° ě?° ě?Õ$/?Q?E?Õ$/?tj~?
=p?l?nO?S?öE?tj~?Õ$/?n?hr Ĝ?nO?I^5??&x?+?n?n?+?E?
=p?Q?Õ$/??|hs?/w?
=p?7KƧ?° ě?tj?zG{?`A7L?nO?Q?-V?ļj~#?Q?Õ$/?E?n?° ě?tj~?Q?Z1'?öE?nO?9XbM?šo?Ƨ-?tj?E?333333?M?S?ěS?tj?
=p?9XbM?S?Õ$/?-V?&x?nO?lD?nO;?
=p
?n?tj~??|hs?nO;?ļj~#?333333?tj~?öE?Z1'?333333?l?&x?`A7K?333333?
=p?tj?M?nO?M?M?tj~?öE?`A7?M?+?nO;?-V?n?tj~?tj~?tj?-V?333333?Q?nO;?öE?zG{?Õ$/?I^5??S?zG{?tj?ěS?`A7?333333?Õ$/?hr Ĝ?`A7?Õ$/?`A7?`A7?333333?Õ$/?M?\(?nO?tj?ěS?S?I^5??tj~?ļj~#?S?+?+?M?lD?Õ$/?333333?+?S?+?hr Ĝ?M?I^5??šo?9XbM?lD?-V?nO;?333333?+?
=p?Z1'?
=p?9XbM?-V?I^5??M?tj~?tj~?E?E?-V?`A7?öE?Ł$/?I^5??E?S?Q?-V?S?Ƨ-?      ?
=p?° ě?\(?-V?9XbM?-V?S?tj?l?ěS?Õ$/?333333?öE?
=p?GzH?Õ$/?/w?Z1'?$/?Õ$/?/w?tj?° ě?9XbM?nO?° ě?\(?zG{?zG{?n?
=p?\(?° ě?7KƧ?° ě?öE?S?-V?lD?öE?333333?+?n?-V?-V?Ł$/?nO;?-V?nO;?S?333333?E?Õ$/?Ł$/?S?333333?l?/w?`A7?l?9XbM??|hs?`A7K?nO?zG{?GzH?° ě?9XbM?7KƧ?šo?Õ$/?S?n?lD??|hs?-V?M?l?öE?`A7?M?n?333333?° ě?-V?-V?tj?
=p?Z1'?/w?-V?`A7?ļj~#?nO?öE?Õ$/?I^5??M?l?333333??|hs?zG{?° ě?nO;?ļj~#?M?nO?333333?+?öE?ěS?nP?5?|h?Z1'?° ě?tj?
=p?Õ$/?ěS?M?-V?ěS?$/?Q?öE?nO;?zG{?l?° ě?\(?S?lD?\(?A7Kƨ?333333?nO?S?öE?l?ěS?lD?\(?333333?9XbM?l?9XbM?° ě?I^5??° ě?l?Õ$/?9XbM?Z1'?`A7?\(?n?ffffff?l?tj~?nO?nO;?Q?zG{?Õ$/?tj?`A7?tj~?l?öE?nO;?° ě?zG{?nO?M?ffffff?nO?333333?`A7K?šo?nO;?9XbM?9XbM?Z1'?9XbM?-V?`A7?nO;?M?ěS?öE?nO;?l?$/?° ě?Õ$/?9XbM?333333?hr Ĝ?+?+?`A7?`A7??|hs?nO?333333?I^5??ļj~#?9XbM?+?l?l?M?zG{?333333?ļj~#?-V?`A7?Q?M?I^5??Õ$/?&x?S?l?-V?l?Q?° ě?Z1'?nO;?M?° ě?
=p?Õ$/?nO?S?9XbM?
=p?Õ$/?lD?nO;?Õ$/?tj?$/?l?ļj~#?S?\(?lD?tj~?lD?
=p?333333?S?° ě?tj?+?-V?nO;?333333?öE?° ě?Z1'?
=p?\(?S?nO?`A7?tj?l?l?-V?l?9XbM?ļj~#?M?+?° ě?nO?\(?-V?zG{?$/?l?E?9XbM?S?`A7?n?M?`A7?tj?M?nO?S?hr Ĝ?ěS?\(?öE?\(?Ł$/?nO;?tj?
=p?nO;?° ě?ěS?9XbM?\(?tj~?tj?öE?
=p?9XbM?tj?ļj~#?tj?nO?Õ$/?l?9XbM?nO?`A7?tj~?nO?zG{?S?nO;?
=p?Õ$/?-V?ěS?+?/w?\(?-V?M?l?Z1'?7KƧ?Õ$/?tj~?l?`A7?\(?I^5??Õ$/?nO;?A7Kƨ?Q?ļj~#?`A7L?-V?ļj~#?333333?zG{?S?Q?I^5??° ě?Q?QR?
=p?\(?öE?l?nO?
=p?Õ$/?`A7??|hs??|hs?\(?`A7?333333?hr Ĝ?n?tj?
=p?Õ$/?Ł$/?Ł$/?tj~?$/?nP?Z1'?öE?
=p?I^5??`A7?9XbM?M?
=p?ěS?-V?9XbM?tj?° ě?&x?GzH?tj~?lD?-V?\(?Z1'?hr Ĝ?Õ$/?ěS?ěS?Z1'?nO?lD?+?vȴ9X?333333?ļj~#?tj~?hr Ĝ?7KƧ?l?ļj~#?zG{?Z1'?lD?nO?`A7?`A7?333333?9XbM?\(?l?333333?I^5??GzH?nO?öE?ěS?GzH?nO;?tj~?° ě?n?333333?-V?S?ěS?I^5??l?M?\(?\(?7KƧ?Z1'?nO?/w?$/??|hs?
=p?öE?tj??|hs?tj~?tj?tj?nO?nO;?`A7?-V?-V?l?9XbM?
=p?333333?šo?nO?-V?nO?Q?p
=q?öE?Q?
=p?"`?I^5??nO;?l?M?`A7?333333?Õ$/?333333?&x?zG{?S?
=p?I^5??`A7?I^5??GzH?
=p?° ě?ffffff?`A7?nO?
=p?|hr?nO?l?$/?nO;?tj?Q?333333?
=p?\(?tj?$/?ěS?-V?hr Ĝ?n?Q?S?333333?Q?tj~?`A7?hr Ĝ?ěS?n?\(?7KƧ?öE?`A7?&x?E?° ě?M?\(?Õ$/?öE?333333?I^5??/w?tj~?+?ffffff?I^5??A7Kƨ?ěS?-V?Q?nO?$/?
=p?l?n?nO;?M?9XbM?7KƧ?\(?\(?`A7?-V?\(?9XbM?\(?Z1'?\(?\(?GzH?n?l?7KƧ?öE?Z1'?Q?\(?ěS?-V?šo?/w?+?tj~?
=p?$/?lD?M?333333?Õ$/?Q?S?öE?`A7?Q?n?ěS?$/?-V?      ?l?333333?bM?M?n?M?öE?&x?-V?M?S?tj~?° ě?ļj~#?Õ$/?7KƧ?+?
=p?Ł$/?Õ$/?-V?/w?° ě?° ě?333333?hr Ĝ?9XbM?-V?l?S?GzH?zG{?9XbM?GzH?+?9XbM?/w?/w?tj~?$/?nO;?l?tj?&x?j~"? ěT?lD?&x?nP?öE?M?nO;?-V?`A7?tj~?S?333333?`A7?-V?&x?n?n?n?° ě?M?nO;?tj?nO;?&x?° ě?7KƧ?Z1'?M?l?° ě?333333?\(?n?`A7?M?tj?-V?ļj~#?
=p?9XbM?° ě?5?|h?Q?7KƧ?M?Q?+?nO?tj~?tj~?S?GzH?A7Kƨ?S?nO;?tj~?-V?333333?ļj~#?° ě?1&?bM??|hs?x?ļj~#?`A7L?$/?333333?-V?S?l?nO;?l?+?Z1'?öE?
=p?tj?ěS?hr Ĝ?\(?ěS?GzH?bM?tj?ěS?-V?GzH?`A7?`A7?n?tj~?I^5??`A7L?333333?I^5??lD?\(?
=p?\(?l?I^5??
=p?Q?-V?I^5??+?zG{?tj~?$/?nO;?ěS?`A7?I^5??
=p?`A7?`A7K?Q?\(?-V?`A7?`A7L?nO?I^5??
=p?n?\(?7KƧ?ěS?lD?tj~?Q?-V?&x?"`?Q?nP?vȴ9X?öE?\(?öE?\(?Q?Õ$/?333333?lD?ěS?Q?|hr?Q?-V?l?tj?n?+?333333?M?+?-V?E?I^5??-V?öE?l?ěS?GzH?lD?° ě?Õ$/?° ě?&x?I^5??`A7?tj~?-V?n?\(?ěS?l?hr Ĝ?nO;?I^5??I^5??I^5??
=p?l?Õ$/?M?-V?ěS?`A7?lD?Q?n?nO;?nP?ěS?`A7?nO?7KƧ?+?`A7?333333?Õ$/?lD?tj?tj~?I^5??I^5??E?n?`A7?n?`A7?ěS?M?      ?A7Kƨ?ěS?° ě?l?`A7?I^5??-V?+?l?hr Ĝ?5?|h?ļj~#?I^5??nO;?ěS?333333?GzH?tj?
=p?nP?l?nO?I^5??Õ$/?I^5??n?° ě?
=p?`A7?-V?l?-V?M?+?\(?lD?7KƧ?7KƧ?\(?$/?
=p?&x?nO?-V?nP?hr Ĝ?
=p?GzH?° ě?hr Ĝ?+?5?|h?A7Kƨ?GzH?I^5??7KƧ?M?5?|h?`A7L?`A7L?&x?° ě?-V?tj?lD?nO;?&x?Q?$/?-V?7KƧ?M?`A7L? ěT?I^5??`A7?
=p?+?n?Q?ěS?n?lD?
=p?vȴ9X?lD?tj~?nO;?M?bM?$/?GzH?l?hr Ĝ?nO?I^5??&x?n?l?n?+?M?nP?lD?GzH?333333?`A7?      ?vȴ9X?"`?
=p?&x?-V?9XbM?öE?vȴ9X?vȴ9X?-V?nP?lD?ěS?
=p?GzH?A7Kƨ?\(?333333?$/?vȴ9X?Q?GzH?tj~?lD?tj~?7KƧ?n?° ě?&x?I^5??
=p?Q?° ě?A7Kƨ?Q?-V?-V?-V?I^5??
=p?-V?ěS?S?öE?333333?lD?nP?7KƧ?M?-V?-V?\(?bM?GzH?S?A7Kƨ?&x?`A7L?A7Kƨ?|hr?n?I^5??ěS?A7Kƨ?° ě?`A7L?bM?Q?Q?lD?nO?|hr?`A7L?A7Kƨ?l?Q?nP?\(?333333?$/?$/?A7Kƨ?M?GzH?tj~?-V?7KƧ?"`?nP? ěT?nP?l?7KƧ?vȴ9X?ěS?n?I^5??7KƧ?-V?M?7KƧ?nO?$/?&x?GzH?`A7L?\(?GzH?M?$/?hr Ĝ?lD?hr Ĝ?n?"`?S?I^5??bM?bM?A7Kƨ?Q?M?`A7?hr Ĝ?S?-V?ěS?GzH?° ě?A7Kƨ?`A7L?I^5??333333?nO;?Q?M?
=p?&x?ěS?lD?&x?GzH?l?      ?`A7L?`A7L?$/?lD?I^5??bM?A7Kƨ?|hr?&x?hr Ĝ?Õ$/?M?      ?A7Kƨ?l?-V?A7Kƨ?Q?A7Kƨ?° ě?l?bM?GzH?hr Ĝ?Q?n?5?|h?&x?Q?hr Ĝ?A7Kƨ?ěS?$/?7KƧ?7KƧ?A7Kƨ?-V?A7Kƨ?bM?A7Kƨ?p
=q?333333?bM?tj?|hr?° ě?-V?`A7L?|hr?nO?I^5??ěS?n?-V?hr!?° ě?GzH?;dZ?\(?l?ěS?1&y?A7Kƨ?-V?-V?bM?° ě?
=p?nP?-V?&x?n?$/?bM?      ?hr Ĝ?° ě?lD?      ?      ?
=p?ěS?vȴ9X?E?\(?nO;?      ?bM?GzH?nO;?n?`A7L?Q?A7Kƨ? ěT?E?A7Kƨ?nP?`A7L?"`?vȴ9X?      ?nP?&x?vȴ9X?nP?ěS?$/?333333?ěS?
=p?"`?nP?\(?`A7L?\(?Q?p
=q?j~"?hr Ĝ?-V? ěT?l?Q?A7Kƨ?$/?Q?lD? ěT?
=p                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	@N      @N      @M33333@N      @M33333@N      @N      @N@N@N@N      @M33333@N      @N      @N@N      @Mٙ@M33333@N@N      @N@N      @N      @M33333@N@N@N      @N      @N@N@N@N@N      @N      @N      @N@N@N@N      @N      @N      @N333333@N@     @N@     @N@     @N&fffff@N@     @NL@NY@Nffffff@Ns33333@N@Nٙ@O@O333333@OY@Offffff@Offffff@Os33333@Offffff@O     @O@Offfff@O33333@O33333@O33333@O@Oٙ@O33333@P@P,@P333333@P9@P@     @PFfffff@PFfffff@PL@PY@P`     @P`     @P`     @P`     @Pl@Pl@Pl@Ps33333@Ps33333@Py@Py@Py@Py@Py@Py@Pfffff@Pfffff@P33333@P     @P@P33333@P     @Pfffff@Pfffff@Pfffff@P33333@Pfffff@P     @P@P@P     @P@P@P     @P@Pfffff@P@P@P@P33333@P@P@Pfffff@P33333@P@P33333@P@P@P@Pfffff@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@Pfffff@P@P33333@P33333@P33333@P     @Pfffff@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P@P@P@P33333@P@P33333@P@P@P@P@P33333@P@P@P@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@Pfffff@P33333@P33333@P33333@P     @P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@Pfffff@P@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P@P@P33333@P@P@P33333@P33333@P@P33333@P33333@P@P@P33333@P@P     @P     @P@P@P@P@P     @P     @P     @P     @P     @P     @P     @P33333@P33333@P@P     @P     @P     @Pfffff@P     @P     @Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@P     @Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@Pٙ@P33333@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pfffff@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pfffff@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @Pٙ@Pٙ@P33333@Pٙ@Pٙ@P     @Pٙ@P     @Pٙ@Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@P     @P     @Pfffff@Pfffff@P     @Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@P     @P     @Pfffff@P     @Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@P     @P     @Pfffff@Pfffff@P33333@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pٙ@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@P     @Pٙ@Pfffff@P33333@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @Pٙ@P     @P     @Pfffff@P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pٙ@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pٙ@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pٙ@P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@P33333@Pfffff@Pfffff@Pٙ@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P33333@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@PFfffff@P33333@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pٙ@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pٙ@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pٙ@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@Pfffff@P@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@Pfffff@P@P@P@Pfffff@P@Pfffff@P@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@Pfffff@Pfffff@P@P@P@Pfffff@P@Pfffff@P@P@Pfffff@P@Pfffff@Pfffff@Pfffff@P@P@P@Pfffff@P@P@Pfffff@Pfffff@P@P@P@P@Pfffff@P@P@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@Pfffff@P@Pfffff@P@P@Pfffff@Pfffff@P@P@Pfffff@P@P@Pfffff@Pfffff@P@P@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P@P@P@P@P@P@Pfffff@Pfffff@P@Pfffff@P@Pfffff@P@P@P@P@P@P@P@Pfffff@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@P@P@Pfffff@Pfffff@Pfffff@Pٙ@P     @P@P@Pfffff@P@Pٙ@Pfffff@P@Pfffff@Pfffff@Pfffff@P@P@P@P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@Pfffff@P@Pfffff@P@P@P@P@P33333@P33333@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P@P@P33333@P@P33333@P@P@P@P33333@P33333@P@P@P@P@P@P33333@P@P@P33333@P33333@P33333@P33333@P@Pfffff@P33333@P@P@P@P@P33333@P33333@P@P@P33333@P@P@P@P33333@P@P33333@P@P@P@P@P@P@P33333@P@P@P33333@P@P@P@P@P@P@P@P33333@P@P@P@P33333@P33333@P@P@P@P@P@P@P@P33333@P@P@Pfffff@Pfffff@P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@Pfffff@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@Pfffff@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P@P@P33333@P@P33333@P33333@P@P33333@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@Pfffff@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@Pfffff@Pfffff@P@P@P@P@P@P@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@Pfffff@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P@P@P     @P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@Pfffff@P     @P@P@P@P@P@P33333@P33333@P@P@P@P@P33333@P33333@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      P19                                     1                                       BF 	=3L