CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20170205   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P7     CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:35.132303Z    ORIGINAL_HEADER      6CTD,20250210CCHSIOWB
#Removed 'CTDFLUOR_TSG' as it's filled with -999
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2017-06-29. CTD data from cruise 18DD20170205, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20170205. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2017-001/index.php. 
#
# The information in this file for the cruise 2017-001 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-0036.ctd
#
# Start of originator file comment header
#
#*2017/06/29 15:26:50.02
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2017/02/10 06:17:38.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 198
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : CE9F1F72
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            0.3            202.1
#       2 Temperature:CTD               deg_C_(ITS90)   5.6248         6.8697
#       3 Salinity:CTD                  PSS-78          32.78          33.8432
#       4 Sigma-t:CTD                   kg/m^3          25.7461        26.7106
#       5 Oxygen:Dissolved:CTD:Volume   ml/l            3.4            6.87
#       6 Oxygen:Dissolved:CTD:Mass     µmol/kg         147.7          299
#       7 Fluorescence:CTD:Seapoint     mg/m^3          0.66E-01       1.162
#       8 PAR:CTD                       µE/m^2/sec      0              0.3
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        7  F       ' '     2
#       6  -99   ' '        6  F       ' '     1
#       7  -99   ' '        8  F       ' '     3
#       8  -99   ' '        7  F       ' '     1
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2017-001
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P21
#    EVENT NUMBER        : 36
#    LATITUDE            :  49  38.00000 N  ! (deg min)
#    LONGITUDE           : 139  39.97000 W  ! (deg min)
#    WATER DEPTH         : 3961
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    The descent rate of the CTD was very noisy with some complete reversals
#	of direction.
#    CTDEDIT was used to remove many records corrupted by shed wakes;
#	salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Fluorescence and PAR data are nominal and unedited except that some records were
#	removed in editing temperature and salinity and a large spike in
#	fluorescence was removed from file 0032.
#
#    The Transmissivity channel was removed because of frequent shifts in values during
#	casts and large variations between values during repeat casts.
#	The data are available, by request, from the chief scientist.
#
#    NOTE: While the Fluorescence:CTD data are expressed in concentration units, they
#	do not always compare well to extracted chlorophyll samples, particularly for
#	casts far from shore. It is recommended that users check extracted chlorophyll
#	values where available.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in Sea-Bird
#	Application Note #64-2, June 2012 revision (Sea-Bird_64-2_Jun2012.pdf), except 
#	that a small offset in the fit was allowed.
#
#    The Dissolved Oxygen sensor used in files 0001, 0002 and 0016 malfunctioned so the 
#	Oxygen:Dissolved:CTD channels were removed from those files.
#
#    The Oxygen:Dissolved:CTD sensor has a fairly long response time so data accuracy 
#	is not as high when it is in motion as it is during stops for bottles. This will be
#	especially true when vertical dissolved oxygen gradients are large. To get an estimate
#	of the accuracy of the Oxygen:Dissolved:CTD data during downcasts (after recalibration)
#	a rough comparison was made between downcast Oxygen:Dissolved:CTD data and upcast 
#	titrated samples. Some of the difference will be due to problems with flushing of 
#	Niskin bottles and/or analysis errors, so the following statement likely underestimates 
#	Oxygen:Dissolved:CTD accuracy.
#
#    Downcast (CTD files) Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.25 ml/l from 0 to 125 dbar.
#	±0.2 ml/l from 125 to 400 dbar.
#	±0.1 ml/l from 400 to 600 dbar.
#	±0.05 ml/l from 600 to 1500 dbar.
#	Low by up to 0.08 ml/l below 1500 dbar.
#
#    For details on the processing see document: 2017-001-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5--- --6-- ---7--- --8---
#!Pressu Temperat Salinity Sigma-t: Oxygen Oxyge Fluores PAR:  
#!re:CTD ure:CTD  :CTD     CTD      :Disso n:Dis cence:  CTD   
#!                                  lved:  solve CTD:          
#!                                  CTD:   d:CTD Seapoin       
#!                                  Volume :Mass t             
#!------ -------- -------- -------- ------ ----- ------- ------
#*END OF HEADER
     WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @W         data_max      @W         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     =  2   pressure                	long_name         pressure   positive      down   units         decibar    data_min      @
ffffff   data_max      @Z   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      =  p|   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      h     temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?'/W   data_max      @!~m\   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       =  |   temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      h     salinity                	long_name         salinity   units         PSS-78     data_min      @@C$   data_max      @AKa@   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      = 
|   salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      h H   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @$   data_max      @r   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        = W|   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      h    CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?(\)   data_max      ?Q   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      = |   CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      h    PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min                 data_max                 C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       = |   PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d      h /   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min               data_max               C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     = >|   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d      h |   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( |   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         (    time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      *   data_max      *   C_format      %10d          latitude               	long_name         latitude   units         	degrees_N      data_min      @Hc   data_max      @Hc   C_format      %9.4f             	longitude                  	long_name         	longitude      units         	degrees_E      data_min      `Jb#   data_max      `Jb#   C_format      %9.4f             	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d           	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d        @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @W      @
ffffff@      @      @      @ @"      @$      @&      @(      @)ffffff@,333333@.      @0      @1      @2      @2fffff@4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @A33333@B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @IL@J      @J     @K      @K     @L      @L     @M      @M     @N@N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Qfffff@R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Zfffff@Zfffff@Z@[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @_@`&fffff@`<@``     @`     @`     @`     @`ٙ@afffff@a      @a@     @a`     @a     @a     @a     @a     @b      @b&fffff@b9@b\@b     @b     @b     @b     @c      @c      @c@     @c`     @c|@c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e@efffff@e     @f      @f      @f@     @f`     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @g@h#33333@h@     @h`     @h     @h     @h     @h     @i#33333@i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @ls33333@lfffff@l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @m@n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o33333@o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @pfffff@p@p     @p     @q      @q     @q      @q0     @q@     @qP     @q^fffff@qvfffff@q     @q     @q     @q     @q     @q@qᙙ@q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r|@r@r     @r     @r     @rfffff@rfffff@r     @s      @s     @s      @s0     @s@     @sP     @s`     @sq@s~fffff@s     @s     @s     @s@s33333@s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t陙@u@u     @u      @u0     @u@     @uP     @ua@ui@u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v@v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @wfffff@w     @w     @w     @w     @w     @x      @x     @x      @x0     @x;33333@xS33333@x`     @xp     @x     @x     @x     @x     @xfffff@xfffff@x     @x     @y      @y@y!@y0     @y>fffff@yP     @y`     @yp     @y@y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z1@z>fffff@zP     @z`     @zp     @z     @z     @z     @zfffff@zfffff@z     @z     @z     @{      @{     @{      @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|4@|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}>fffff@}P     @}`     @}p     @}     @}     @}     @}     @}33333@}fffff@}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~t@~fffff@~fffff@~     @~     @~     @~     @~     @~     @@@#33333@0     @@     @P     @`     @p     @     @fffff@fffff@fffff@     @     @     @     @      @@     @      @(     @0     @4@A@H     @P     @X     @`     @h     @p     @x     @     @     @     @     @33333@@     @     @     @     @     @     @     @     @33333@@@     @     @      @(     @0     @4@@     @H     @P     @X     @`     @h     @p     @vfffff@33333@@33333@@     @     @     @ə@     @     @     @     @     @@@     @     @     @      @(     @.fffff@8@@     @H     @P     @X     @`     @h     @l@y@     @     @     @     @     @     @@@     @     @     @     @     @fffff@     @     @      @     @     @     @      @(     @1@8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @33333@     @     @     @     @     @fffff@fffff@     @     @     @     @fffff@     @     @     @      @(     @0     @8     @@     @I@P     @X     @`     @e@p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @@     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@fffff@      @     @     @     @33333@(@0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @@33333@     @     @33333@@     @     @     @     @     @     @     @ @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @,@5@@     @H@P     @X     @`     @h     @p     @x     @     @33333@     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @fffff@)@0     @8     @@     @H     @P     @W33333@`     @h     @p     @x     @     @     @     @fffff@     @     @     @     @     @     @@@33333@     @     @     @      @@     @      @(     @0     @8     @>fffff@L     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @33333@fffff@     @      @@33333@     @      @(     @0     @8     @@     @H     @P     @X     @k33333@p     @x     @     @     @     @     @     @     @     @     @     @     @fffff@fffff@     @     @     @     @      @     @@@      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @@      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p@x     @     @     @@     @     @     @fffff@@     @     @     @     @     @     @     @     @      @     @fffff@      @(@0     @8     @@     @H     @O33333@Y@`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @6fffff@H@P     @X     @\@h@p     @x     @     @fffff@33333@     @     @     @     @     @     @fffff@     @     @     @     @     @     @@fffff@     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @xfffff@|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @љ@     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<fffff@@     @D     @H     @L     @P     @S33333@X     @\     @`     @d     @h     @l     @p     @r@x     @|     @     @     @     @     @     @     @     @     @     @fffff@33333@     @@     @     @     @     @     @     @     @     @     @     @     @     @33333@@     @     @     @     @     @      @     @	@@     @     @     @     @      @$     @'33333@,     @0     @4     @8     @<     @@     @C33333@H@L     @P     @T     @X     @\     @`     @c33333@hfffff@l     @p     @t     @x     @|     @~@     @     @     @     @     @     @     @     @     @     @fffff@33333@     @     @     @     @     @˙@     @     @     @     @     @     @     @@     @     @     @     @      @     @fffff@     @     @     @     @     @      @$     @(     @,     @0     @4     @7@<     @@     @D     @F@Lfffff@P     @T     @X     @\     @`     @d     @g@lfffff@p     @s@x     @|     @     @     @@33333@     @     @     @@fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @      @@	33333@     @     @     @     @     @      @$     @&fffff@133333@4     @8     @<     @@     @D     @H     @Q33333@T     @X     @\     @`     @d     @h     @l     @o@x@|     @     @     @     @     @     @@     @@     @     @     @     @     @     @     @33333@     @     @     @     @     @     @fffff@     @     @     @     @fffff@     @     @     @      @fffff@fffff@     @     @     @     @     @      @%@(     @,     @0     @4     @8     @<     @>@H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @@     @     @     @     @     @     @     @     @     @@@     @     @     @     @     @fffff@@     @     @     @     @     @     @     @     @     @     @     @      @33333@@     @     @     @     @     @      @$     @(     @+@0     @4     @8     @<     @@     @D     @G33333@P     @T     @X     @\     @`     @b     @hfffff@l     @p     @t     @x     @{33333@@     @     @fffff@     @     @     @33333@@     @     @     @     @     @     @     @33333@@     @     @     @     @י@33333@     @     @     @     @     @󙙙@@     @      @     @     @     @     @@@     @      @$     @(     @*@0@4     @8     @<     @>@E@H     @L     @P     @T     @X     @\     @`     @e33333@h@l     @p     @t     @w33333@|@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@@     @     @     @     @     @fffff@     @     @     @     @     @     @      @     @     @     @     @     @     @33333@!@$     @(     @,     @0     @4     @8     @<     @@     @H     @L     @P     @T     @X     @\     @`     @d@h     @l     @p     @r@x     @|     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @Ù@     @     @     @     @י@ݙ@ߙ@     @     @     @fffff@     @     @     @      @     @     @     @     @     @33333@     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @33333@     @     @     @     @@     @     @     @     @@     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @      @@     @     @     @fffff@@     @      @$     @(     @,     @0     @333333@933333@<     @@     @D     @H     @L     @O@S@X     @\     @`     @d     @h     @l     @p     @t     @x     @z@fffff@     @     @     @     @     @@     @     @     @     @     @     @@@     @     @     @     @fffff@33333@     @     @     @@     @     @     @     @     @     @fffff@      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @B@I33333@L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @@@     @     @     @     @     @     @     @@@     @     @     @     @     @     @fffff@љ@     @     @     @     @     @     @     @@     @     @      @     @     @     @@     @     @      @$     @'@,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @      @     @     @     @fffff@fffff@     @     @      @$     @(     @,     @0     @4     @7@@fffff@D     @H     @L     @P     @T     @X     @]33333@`     @d     @h     @l     @p     @t     @x     @{@     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@33333@     @     @     @     @     @     @fffff@     @     @     @     @33333@     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(@,     @0     @4     @8     @<     @@     @D     @H@L     @P     @T     @X     @\     @`     @bfffff@h     @l     @p     @t     @x     @|     @     @@     @     @     @     @@fffff@     @     @     @     @     @     @fffff@@     @     @     @     @ә@ٙ@     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @      @$     @(     @,     @0     @2@9@<     @@     @D     @H     @L     @P     @S33333@X@Z                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @ Mj@ v_ح@ '/W@ O
M@ @ \(@ U2a|@ bM@ N;5@ `A7@ @ @ !-w@ 1&y@ 
ڹY@ 
D@ C%@ ]cA@ jf@ ~($@ "h	ԕ@ 
5Xy>@ 
(@ 
hr!@ 1&y@ ~($@ ~($x@ C@ L_@ 6z@ @ zxl"@ q@ !R<@ }Vl@ U2a|@ o@ 4֡a@ 
U=@ 
qu"@ VϪ@ q@ <쿱@ @ /w@  A7K@  C@ !'R@ #9@ #	@ "`A@ #a@N@ &,<@ ,_@ -w1@ /{J#:@ 4`d@ 5*0@ 5fA@ 3MjO@ -(@ )rGE@ 8-
@ l@ xl"h
@ +a@ 
M;@ -V@ v@!=b@!3@!Gݗ+@!W$tS@!X*0@!^5?|@!a@!fA@!~m\@!z@!H@!,q@!bM@!rG@!4֡b@!!n.@!Hۋq
@!glC@!RW@!@-
@!S&@!
M:@!r Ĝ@!qj@! ѷX@ iB@ U=@ 	 @ V@ c	@ bM@ 	 @ o i@ d8@ |>@ {"`B@ lI^5?@ hp:@ fx@ dg8}@ an.@ _U=@ W>6z@ OiDg8@ J0
@ ATɅo@ 9D@ 7@ 4#@ 2T`d@ /O
M@ ,VϪ@ '@ "@4n@ _o @ h	ԕ@t@-w1@2a|@
M;@ѷX@4֡a@u"@~$t@kQ@[Q@Qhr @;lC@:C\@8YJ@-w1@+I@{@	ԕ+@}H@ѷX@]cA@@@Fs@U2a|@zxl"@C,z@y@*0U2a@8}H@TɆ@wkQ@U=@Ϫ͟@o i@p ě@\]ce@QX@HK]c@6+jg@1'@~$@֡a@\(@`A7L@v@L/{J@cA @2a|@fA@+J@weں@WXe,@Bu%F
@?H˒:@84֡b@3@$7@E@
=p
@q@8YK@{J#9@a@N@$@S&@oiDg@ n@ߤ@@hr@RT`e@o@>BZ@8YJ@zG@@4n@d?@]}H@l!-w@zxl"h
@o hی@X@&@~($x@o-V@F$/@-B@+6z@;dZ@A@ރ%@@s@hr@'RT`@:)y@
M;@L/{@^5?}@@@4n@{J#9@#@s@hۋq@}K]@sE@`
qu@Zݘ@QN;5@Ik~(@En/@F-@G_o@@IQ@<64@8}H@$qj@|@bM@Mj@xF]@F]c@)y@&x@@-V@rGE@cA @Ձ$/@7KƧ@YJ@g	@$tS@@p:@o hی@~
(@z~@fA@`҈p@_;dZ@[u%@Nqi@=H˒@+6z@C,zx@L_@K]d@lC@!.I@VϪ@&@tSM@Ϫ͞@n.@fB@qu!@vC-@h\)@f1.@`'RT`@]}H@V@Q@4m8@+P{@$xF@y=c@Mj@TɅo@@_@$/@3@-V@
qv@@JL@/V@|Q@Ϫ͞@n@a@N@D@֡a@@1.@eO@M@iB@E84@k~($@B&IR@(	ԕ+@+j@!.H@1.@e@:@'/@y(@hr Ĝ@c	@DJM@1A [@-(@'/V@ d8@,1&y@2䎊q@5'0@H˒:*@C@43@(@"}Vm@
=p@[W>@n.@?@lC@4֡b@3@'0@y@ۋq@@!R<@ƍ@rG@\(@l@1@ěT@6@@@hr @'/@˒:*@~($x@x)@w1@s33333@lq@_U=@Zu%F@S҉@L@D?@7Xe@.1@$e@Mj@	oiD@zH@ hۋq@5Xy@Xe@m8@A [@VϪ@Ft@Vu@iB@c	@8Y@1&y@͞&@*0U2a@9@Z1@䎊@}<64@uXy=@ov@nH@qiB@s|@vz@u?@sߤ@mV@j0U2a|@jfB@jOv`@glC@`҈p@QX@JL_@JڹY@I@<Q@;5Xy@As@F
L/@@NU@;lC@5sg@2䎊q@0'RT@-\@%+a@$Z1@C,zx@m8@حV@ ѷ@*0U2a@Mj@?@hۋq@~
(@}Vl!@y(@t!-w2@h>BZc@a@N@[$@[=K^@UL_@P*0U@F@Ao hی@C{J#9@As@B@ES&@F
L/@F@O
M;@Vaf@WO;d@V@P)^@9"`@m8@_F@`A@oiD@\(\@7KƧ@+a@@u%@12W@Np:~@JD@5?|@$@sP@(@=p
@˒:*@iB@@N@$xG@Xy=@@@4n@%2@ ѷX@Y}@73@~@Vϫ@{@?@C,z@@)^	@̲@o i@
qu@Q@y~($@u!.@tD@s@!-w1@N_o @NMj@G#@)B@xF]@7Kƨ@Q@@쿱[W@\(@m\@4m@C-@ ě@\@͞&@-@x@Q@@A7K@!-w1@}Vm@,@3@[6@@v_ح@i@gfA@h>BZc@hXy=@nH@u'0@tJ@wkP@vz@~"@|@$tT@v_ح@kU=@>\N<@'/V@
jOv@+I@ u!@,<쿱@@IQ@Zݘ@jfB@eO@"`@BZc @k~(@ʦL/{@O;dZ@Z@ԯO
M@֡af@\(@p:@żn/@F]c@ [7@ڹZ@{@͞&@1.@_o@~ߤ?@hۋq
@]+j@[Q@NVu@M:@I'RTa@FYJ@DJM@Dtj@B@A7Kƨ@@hۋq@>6z@<?@<j~#@;J#9@:)y@7rG@4m8@/Vϫ@,!-w@+Q@*͞&@)rGE@(Xy=@%ڹ@ 	k@iB@vȴ@@y=c@$/@-
q@cA \@
#9@ 6@kP@hr!@>BZc@+a@ae@1'@T`d@@kP@kP|@v_ح@:@@qu"@'/@~($x@Z@nO@$/@x73@l<쿱@h	ԕ+@c
=p@_	@_!-w1@\N;@Z1'@P@Jn@6+jg@2ᰊ@,"h	ԕ@)x@*g	@+~($@+Q@+C,z@,VϪ@.2X@0:~ @1@1u!S@1-@2a|Q@2W@3@6+jg@7+@7+@73@8-
@873@6Fs@43@3MjO@2W@2m\@333333@1A [@0{@-C\@)y@!@N@-V@҈p;@@fA@$tT@ߤ?@
	 @2W@&IR@@K]@A@^5?|@Y}@YJ@8}H@҈p;@,=@(\@qu!@@@o @L_@#@6z@}Vl@Q@wk@qu!@Xe,@Z@N;5@͞@Vu@~($x@u%F@
L/@\N@@4n@H˒:@tD@or@l!-w@h$xG@ezxl"h@ao@^%@[6@W&@Vl!-@UfA@T`d@TzG@S*0U2@LcA \@B74@?˒:)@7Xe@7KƧ@6_ح@5Y|@4D@4J@3PH@3MjO@3g	l@3ߤ@2m\@2s@2GE85@.t@,q@(@'8}H@ [6@%@@}H@U@
5Xy>@@lC@hr!@ce@4֡b@_F@4J@n.@t#@iDg8~@f,<@\?@W@Q_p@GzH@@C@:)y@6z@,>B[@(@R<6@o @
M:@~($x@L_@'/@u%F@ ѷX@s@j~@PH@oiDg8@ۋq
@҈p@ٳ|@
=p@^5?|@g	l@{J#:@0
@!-w1@nO@ ѷ@~m\@u!R@qA [@ae@\>@XbM@Vl!-@Rm@PH@KƧ@HK]c@B@<64@1-@(@	@C,zx@ᰉ@&I@
$t@
J#9@
Y|@
E@
 ě@
rGE@
]ce@
t@
N;5@
@
n.@
/V@
64@
b@
NU@
4m@
@
6@
BZc @
쿱[@
/V@
)y@
?|h@
33333@
W@
q@
^@
wkP@
nO@
qiC@
o hۋ@
`d8@
W@
N+@
9D@
7rG@
6}Vl@
/Vϫ@
+a@@
)^@
R<6@
qiC@
oiDg@
JM@
n.@"@m]@(@D@@GE85@䎊q@@JL@8}H@+a@S@M@A [@Gz@d8@A7K@ߤ?@iB@?@(\@Q_@sPH@@Z@m@҈p:@ҽ<64@m@H@ΤT@ΤT@+@+@ΤT@ΤT@_o @#9@š@H˒:@^5?|@4K@w1@lD@3@	k@@zG@I^5?@uY|@pD@lC@jJL@h>BZc@e@bM@aGz@_o@[6@Vl!-@Vaf@XD*@UfA@K]cA@K)^	@I^5?}@E@7Xe@/{J#:@&@"3@!ae@u"@u"@@N@*0@~($x@oiDg@\N<@+@!-w2@VϪ@
qu@_p@?@r@TɅ@TɆ@h	ԕ@䎊r@%@6C@$tS@u@qi@xF]@Fs@o h@$/@}Vl!@zG{@y(@yrGE8@uY|@r ě@m\@fA@bC,@aGz@UϪ͞@H@@C@4֡a@(@U=@u%F@1&x@
~"@
;dZ@
+@
T`d@
@
@
:~ @	k~(@rGE9@nO@)^@ߤ?@҈@'/@҈@
qiC@1&x@{J#9@
C\@
x@
Dg8~@
Ov`@
A@
Ft@
1'@
p:~@
Ƨ-@
4K@
vȴ9X@
,zxl@
ȴ9Xb@
W'@
䎊@
a@O@
˒:*@
m8@
Ov_خ@
:)y@
rGE9@
oiDg@
|?@
wkP@
a'R@
:)_@
.zG@
%1@
($xG@
+a@@
&'@
+J@	J#9@	l@	>BZ@	ҽ<64@	T`d@	_o @	/{J#@	@	jOv@	@	
(@	<64@	64@	S&@	)y@	S&@	dZ@	)_@	D@	z@	V@	@	@	tSM@	&I@	     @	n.@	u%F
@	@4n@	I^5@	u%F
@	@4n@	n.@	hۋq@	@	I^5@	y=b@	v_ح@	q@	UfA@	E8YK@	>6z@	+I^@	쿱[W@	q@%F
L@O;@쿱[W?@7@&@p:~@@E84@E84@ǮzH@2W@C@[W>@Z@S&@z@0
@IQ@1@tSM@n.3@.H@	k@'RT`@sh@u%F@oiDg@{J#9@zG{@wkP@v+jg@r ě@pD@oiDg8@iB@Yb}@SMj@R<64@QR@Rp:@Rp:@Q_p@NT@GzH@>BZc @;/V@.2X@.}Vl@.H@-V@,>B[@,1&y@(Xy=@'/V@'RT`e@($xG@&L/{J@%zxl"h@%u@%1@$tSM@#n.3@!.H@ 	k@ ěT@ [6@	@-V@[@,<@Fs@
M:@u%F@YJ@M:@nP@I^5@@:S@#x@C\@F]d@1@!.I@!R@:~ @.2@(@C]@~"@Ov`@	k@e@حV@҈p;@c	@Q_@Q_@Q_@1'@1'@JE@֡af@Ϫ͞@8YJ@fA@fA@`d@ҽ<64@ѷX@Ϫ͞@@K]c@y@ɺ^5?}@W'@@b@U2a|@U2a|@ ě@O
M@a@@TɅ@vȴ@$tT@҈@u%F@+I@ݗ@@@4n@4m9@|hr@|Q@p
=q@[W>6z@W
=p@NT@L@JL_@G@@G)^@GE84@G)^@F-@F-@E8YK@E8YK@B74@?|hs@.1@+6z@(TɅ@%u@%F
L0@"h	ԕ@	@u@IQ@[@tj@+J@@qi@
@
ڹY@o hی@E@?@lC@F@!.I@g@iB@oiDg8@O;@VϪ@fB@rGE@lC@`A7L@Z1@S@@4@ᰉ'R@҈p@ ѷY@D*@ԕ*1@Ƨ@6@Xy=@U2a|@[W>6@jf@@'@xF@U=@}H@e+a@ݗ+k@@q@7KƧ@ݗ+@Fs@4m9@|?@zC\@u\(@mC\@fA@eO
@bC,@["`B@W>6z@S&@QN;5@N+@JW'@?@7rG@6E@3|@*0
@'/V@O;d@
@p:@K]d@&I@@YJ@$/@Q@nP@      @$t@lC@\(@u!S@VϪ@e@حV@]ce@Ƨ@o i@\N@\(@ [7@4m@H˒:@K]@dZ@~@)y@'0@|@-V@jf@!-w1@ᰉ@Fs@'/W@I^5?@҈@	 @K]d@:S@ѷX@~"@~"@{lC@sMjO@l"h	ԕ@e@_Ft@Zݘ@XU@Vl!-@V8YJ@U2a|@TE@T*1@SZ@LcA \@IQ@C\N@>vȴ9X@5Xy=@2a|Q@1&x@+I^@(\)@$TɆ@#S&@ 'RT`@1&@qu!@vȴ@PH@*0@u@qi@'/@1&x@@4n@ IQ@$t@($x@J#9@F]d@+@eں@ȴ9X@Fs@䎊q@:~ @Q@fA@ߤ?@>6z@8YJ@,<@N;5@`A7@Ƨ@&IR@ [7@)_@E@'0@'RT@lD@@/V@zxl"h@3@	@,<@Ov_@@@I^5@˒:)@~($x@y"`@weں@uY|@r ě@o hۋ@jOv`@be+@aGz@_o@\N;@Xy=c@QN;5@M%@KƧ@IoiD@DS@BZc@@C@>ߤ?@;/V@7KƧ@4m8@2a|Q@0 ě@-
qv@,<쿱@+a@@vȴ@*0@@N;6@ߤ?@
O;dZ@p:@Fs@ݗ@{J#9@o hی@J#9@D@s@ hۋ@!-w@쿱[W?@"h	ԕ@빌~($@@	@u!@o@cA @]ce@>@(\@b}@_o @)^	@ɺ^5?}@Ƨ-@Õ$@ [7@|hs@b@v@^5?|@~($@m8@r@@S@Q@@zG@@N@n@Mj@p:@M:@IQ@.H@}H˒@z>B@v+jg@rGE85@o-V@l"h	ԕ@jfB@irGE@f,<@_o@P*0U@Ks@I@GzH@F
L/@D*0@C$@C$@B74@A [7@?@<n.@:S&@:)y@:)_@:)y@9#w@9Y}@73@5?@3|@1-@.2X@&x@IQ@+j@zG@)^@o @q@
L/{@
	 @
	 @	k~(@u%F@ݗ+@n.@=b@@t@빌~($@ڹ@iB@6@b}@@՛=K@+@s@84֡@ߤ?@Z@Z@dZ@)y@YJ@KƧ@4K@?|h@3@'RT@U=@zxl"@$xG@S&@ěT@U=@U=@Q@u@,=@ߤ@@@bM@qu"@xF]@ڹY@L/{@ԕ*@7KƧ@K]d@@}Vl!@{lC@zG{@y	k~@xF]d@wkP@v!.I@v+jg@qiB@iᰉ'@hr Ĝ@f,<@e+a@d%1@^5?|@[6@Xy=c@Vaf@V8YJ@U=K@TE@TɅoi@T*1@T*1@S@Rm@R䎊@QX@P{@O͞@PH@QR@QR@O͞@I^5?}@E8YK@@n@64K@3g	l@2W@2ᰊ@2W@2a|Q@0
(@/O
M@+jf@%S@쿱[W@C,zx@u%@ᰉ@\(@
ڹY@#@ݗ+@YJ@ 4m9@(@E@@iDg8@c	@C]@JL@fA@S@"`B@e+@҈p;@o@ ѷY@҈p;@҈p;@ce@څݘ@Z@䎊@)^	@ɺ^5?}@Õ$@6@p
=@~($@YJ@4֡b@}H@}Vl@E@3@-V@ ě@I^@1@S&@쿱[W@'RT`@-w1@'RT`@	@%@1&@S@vȴ@*0@@*0U2@S&@@q@ԕ*@eO@+I@Fs@$/@n/@S&@?@nP@$/@     @}E@|#x@zC\@xF]d@v!.I@ql@nt@mhr!@kC]@irGE@gfA@g@dqj@c	@be+@^iB@YJE@W@W
=p@Vt@TɅoi@R<64@O;dZ@Ks@H9Xb@G)^@F
L/@Eo i@C$@?H˒:@73@4J@1&x@0U2a|@/r@.1@.H@-U=@-V@+jf@&'@$/@#n.3@"`A@!.H@"3@!.H@ 	k@	@rGE9@q@xF]@~($x@!R<@Vu@u%F@ m\@ lC@ !.I@ !R@ GE85@ P{@ B@ fA@ C,@ o@ ݗ+j@ >@ /w@ ?@ W>6z@ ٳ|@ D*@ ק&@ t@ Z@ H@ 
M;@ @ ɅoiD@ s@ @ 7Kƨ@  [7@ C@ v@ n.@ A@ )_@ z@ m8@ g	l@ -V@ H@ >B[@ zxl"@ 1&y@ 0
@ IQ@ 
=p@ h	ԕ@ vȴ9@ [@ ,<@ vȴ@ vȴ@ ,<@ qu!@ u%@ kP|@ _o@ O;d@ +J@ *0U2@ 4J@ (@ L_@ ڹY@ ԕ*@ p:@ eO@ _o@ {J#9@ .H@ z@ xl"h	@ u\(@ r䎊q@ p@ o4֡a@ mhr!@ l"h	ԕ@ kC]@ kQ@ jg	@ ix@ g	k@ fA@ dqj@ a@N@ _;dZ@ \>@ Zݘ@ Xy=c@ W
=p@ T,<@ RT`d@ P`A7@ P*0U@ NT@ LcA \@ JW'@ I@ F?@ C\N@ B\(@ A7Kƨ@ BZc@ B\(@ ?|hs@ >6z@ <n.@ ;A@ :)y@ 64K@ 3ߤ@ -B@ +jf@ )*0U2a@ ',@ $/@ !.H@ !ae@ 䎊r@ Ov_خ@ =K^@ @ n@ 
@ ~($x@ L_@ 
L/{@ oiDg@ {J#9@ @       ?	k~?!-w2?MjO?-V?ᰉ'?fA??S?ᰉ'R?ߤ??
qu?҈p?ߤ??ᰉ'R???`A7L?`A7L?C,?u!???cA \?W'?y?2W??[W>?~($?sg?-V? ě?1?d7?0
)?Mj?7KƧ?oiDg?4m9?zG{?u!R?o?lC?iDg8~?cA [?_Ft?S?P{?O
M;?O
M;?KƧ?H?Dg8}??|hs?9XbM?73?8YJ?9D?8}H?1&x?,<쿱?*0U2a|?'/V?&?&?#wk?,=?e+a?sh?*0U2?4J?'/W                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @@Cs@@C@@C@@C\N@@C\N@@Dn.@@C\N@@Cs@@Dn.@@Cs@@C\N@@C$@@Cs@@Cs@@DJ@@Cs@@C@@Cs@@C$@@C@@C@@Cs@@C@@C\N@@D1&y@@DL_@@Dn.@@C\N@@D1&y@@D,<@@DFs@@DPH@@DSMj@@DVϪ@@D]ce@@D`d@@Dg8}@@DPH@@D?@@DC,zx@@DM:@@DC,zx@@D<쿱@@D*0@@EB@@EO
@@E@@EXy=@@En/@@EϪ͞@@EϪ͞@@EC\@@FL/{J@@F쿱[W@@G@@GKƧ@@H*0U@@HD*@@Hu!@@Hۋq
@@I	k~@@IoiD@@M?|h@@Ze+@@^,<@@g#@@n
L/@@o@@t@@z@@s@@Xe,@@Q@@xF]@@~($@@!R<@@@@h	ԕ@@ ѷ@@`A@@h	ԕ@@33333@@tj@@2W@@JM@@_F@@	@@@@'/W@@2X@@
=q@@I^5@@tj@@5Xy>@@K]d@@u!@@e+@@W@@g8}@@Vl!@@1.@@E84@@[6@@N;6@@xF]@@ԯO
M@@b@@֐$t@@׾vȴ9@@ěT@@&x@@#9@@ڹY@@a@@@ܨTɆ@@E@@[@@F
L0@@fA@@݇ݗ@@ݛ=K@@\(@@?@@ޮ}Vl@@v_ح@@@@hۋq@@C@@@N@@ae@@ᰉ'R@@)y@@=K^@@m]@@wkP@@֡a@@YJ@@A@@_o@@Xy=@@oiD@@1'@@u%F
@@<64@@=K^@@:)z@@E@@g@@wkP@@JM@@?|h@@$/@@힃%@@@@
qv@@t@@!R<@@Vu@@@@;dZ@@     @@oiDg8@@˒:*@@u!@@#w@@Gz@@(@@u%F
@@fB@@n.3@@@N@@	@@u%@@~@@c	@@m@@g	@@ᰊ@@C,@@/V@@g	l@@]cA@@qu!@@*0U2@@%2@@PH@@tSM@@zG@@~($x@@~($x@@O
M@@D@@o i@@?|h@@<64@@ce@@O
@@=K@@U=@@H˒@@,=@@1.@@8YJ@@@@y@@F]d@@>BZc@@
(@@e+@@ ѷ@@@@ ě@@fA@@hۋq@@{@@
(@@hۋq@@oiDg8@@r Ĝ@@
=q@@ěT@@u%F@@@@@
(@@)@@4m@@4m@@{@@[W>6@@y@@ԕ*@@-@@=p
@@h	ԕ@@^5?|@@u%F
@@h	ԕ@@^5?|@@L_@@s@@)^	@@/V@@6z@@ߤ@@eO@@a@O@@1&y@@J@@ߤ@@@(\@@?@@Fs@@Fs@@Z1@@cA \@@zG@@?@@o h@@zG@@wkP@@zG@@zG@@o h@@#@@o h@@#@@N;@@쿱[@@3@@*0@@Z@@u"@@֡a@@o i@@K]@@qu"@@2a|@@?|h@@B@@\@@%@@+j@@O
@@M:@@\@@Y|@@O
@@Xy=@@,=@@oiDg@@t@@C\@@S@@(@@H@@z@@z@@,<@@!-w1@@&@@[W>@@͞@@/V@@vȴ9@@fA@@#@@#@A 6@A 4m9@A U2a|@A oiDg8@A YJ@A YJ@A IQ@A @A @A 4m@A_p@A [7@A ěT@A ˒:*@A u!@A [6@A 
qu@@ݗ+@A 6@A hۋq@A :~ @A 1&x@A oiDg8@A hۋq@A U2a|@A oiDg8@A oiDg8@A YJ@AGz@A7Kƨ@A7Kƨ@Au%F
@A ě@A>B@An@AY@A}Vm@AڹY@AC,@Ac	@Au%@AC,z@AC,z@A)^	@AC%@AW>6z@Aa@N@AW>6z@AZ@Ajf@A~$@AA@A@A~($@A5Xy@A%2@AQ@AI^5?@Aj~#@AwkP@A?@Aqj@A쿱[@AɅoi@AZ@A!-w@Ae@AE@A'0@Aqu"@AO;dZ@AO;dZ@AY|@Azxl"h@A!R@Ash@A@AoiDg@AE@A!.@AC\@Aڹ@A,=@AXy=@A+j@AO
@A!R@Ahr!@A@A\(@AoiDg@A
L/@A!.@A ѷY@Avȴ9X@Ap:~@A҈p;@A'/W@AU=@AiDg8@Ay@A$tS@A˒:)@A@A	ԕ+@A'RT`@A-
q@A6@A73@AK]c@AU2a|@A_F@AU2a|@A
=q@AD@A	 ѷ@A	@A	rGE@A	rGE@A		k~@A		k~@A	@A	Q@A	R<6@A	ae@A	@AѷX@AѷX@A@AoiDg8@Ay=c@A|@A˒:*@A|@A˒:*@A@Ae+@APH@A	 ѷ@A		k~@A	rGE@A	@A	rGE8@A	|@A	D@A	s@A
1'@A
#9@A
0U2a|@A
0
@AS&@A&@A&@A33333@A
m@A
-V@A	iB@A\)@AD@A1&x@AkP@A	@Av_ح@Ay=c@A	u!S@A	hr @A4m@A@A@A?@A@A͞@A[6@Atj@AѷX@A	Q@A	^5?}@A	@A
I^5@A
JL@A
T`d@A
h	ԕ@A
L_@A
wkQ@A
>B@A
 ѷ@A
n@A
xl"h
@A
T`d@A
h	ԕ@A
^5?|@A
M@A	b}@A	x@A	x@A	~($@A5Xy@Az@A4֡a@AlC@Av_ح@A'/W@A'@AQ@Al!-@AVu@A!R<@A
!.@A
ᰉ@A

qv@A
\(@A
sh@A
sh@A
1@A
U=@A
H˒@AzG@A\N<@AiB@AIQ@A'@AMj@AFt@AXe@A@A]cf@A"@A"@AFt@AFt@A.H@AU=@AXe,@A	@Avȴ9@Ahۋq@A-w1@A [7@A*0U2a@A˒:*@A&@AU=@Av@A4֡a@AzH@A-@A[6@A$tT@A7Kƨ@AI^@A]cA@AU=@A\N@AxF@A%1@Ag8}@AtSM@A3@AɅoi@AJM@Ae@A:@Ao i@A*0@A84֡@A<64@A84֡@AB@AVl!@AM:@AH˒@A8Y@A_o @A_o @A
(@A
(@AzG@A!R<@A+jg@A5?|@A8YJ@ABZc @AL/{J@AOv_خ@AOv_خ@AVu@Ac	@AiB@Avȴ9X@AIQ@A%@A%@A+J@A@A$t@Aaf@AT@A2X@AQ@Aߤ?@Aȴ9X@AA@A҈p;@A+@Aߤ?@A)^@A+I@AU=@AkP@Ar@A+@ArG@A	ԕ+@A
qu@AbM@AQ@AeO@A'RT@AIQ@A
=q@A
(@ArGE@A&x@A_p@A+@APH@APH@A\)@A+@A [7@A@A@AA [@Ak~(@A'RTa@A@A'RTa@Ay@Aᰉ'@AlD@AI^5@AOv`@A6C@AM@Ah	ԕ@AqiC@Axl"h
@A~"@A@4@Ap:@AS&@A>B@A<64@AY@A}Vm@A͞&@AfB@As@AC%@Ajf@AQ@Aq@A5Xy@A\N@A1&y@A@AL_@A<쿱@AVϪ@Aq@AC@AN;@A1&@A2a|@Aw1@AcA @AS@AoiDg@AE@AC\@AC\@Aڹ@At@A_o @A
L/@A4K@AzG@A
(@AzG@A
L/@At@A
(@A
L/@At@Aڹ@A_o @A ѷY@A@A!R<@A!R<@A+jg@A5?|@A8YJ@AYJ@A_ح@Al!-@A+J@A-@Aߤ?@A hۋ@A)^@A!-w1@A$tS@A1@A;dZ@AU=@AlC@AsPH@A{J#:@AO;d@A	@A@AzH@A@A 
qu@A  ě@A 'RT`@A -
q@A 1&x@A 4m9@A 73@A 73@A 73@A 73@A 73@A 73@A 73@A 73@A 1&x@A -
q@A $xG@A $xG@A 6@A  ě@A  ě@A $xG@A 'RT`@A H@A Q@A _F@A l"h	@A n@A IQ@A p:@A D@A!-w1@A!N;5@A!Q@A![W>6@A!@A!o@A!l@A!N;6@A!@A"u%F@A"e+@A"T`d@A"W'@A"vȴ@A"@A"͞&@A",<@A"sP@A"sP@A"m@A#S&@A#PH@A#/V@A#33333@A#9@A#dZ@A#Mj@A#*0U2@A#@A#\N@A$ߤ@@A$@A$(\@A$VϪ@A$qj@A$7@A$7@A$@A$@A%:@A%:@A%V@A%'0@A%qu"@A%!.H@A%(@A%2a|@A%<64@A%?|h@A%\@A%ݗ@A%jOv@A%jOv@A%p
=@A%M:@A%!R@A%hr!@A%v@A%v@A%Xy=@A%8Y@A&t@A&8YJ@A&p:~@A&}Vl@A&t@A&C-@A'@A'eں@A'O;d@A'-V@A'zH@A'vȴ9@A'˒:)@A'rG@A'Vϫ@A'-@A(     @A(F]d@A(
qu@A('RT`@A(73@A(tj@A(F@A(@A)Dg8~@A)^@A)u!S@A)@A)"`@A)iB@A)e@A)lD@A*	 @A*@A*W'@A*@4@A*ݘ@A*L_@A*L_@A*0
@A*ᰊ@A*wkQ@A*L/{@A*@A*g	@A*n@A*)_@A*W@A*`A@A* ѷ@A*fB@A*C,@A*fB@A*D@A*~@A*m\@A+I^@A+u%@A+s@A+C,z@A+	@A+=K^@A+jf@A+tj~@A+Q@A+Mj@A+Mj@A+$@A+m]@A+@A+@A+5Xy@A+ݗ+k@A,ߤ@@A,,<@A,cA \@A,쿱[@A,[W?@A,JM@A-'0@A-!.H@A-<64@A-B@A-\@A-`A7L@A-p
=@A-zxl"h@A-!R@A-Ϫ͞@A-@A-
qv@A-ᰉ@A-!.@A.t@A.4K@A.u@A.($x@A.1.@A.;5X@A.;5X@A.8YJ@A.E@A.R<6@A.R<6@A.Vu@A._ح@A.\N<@A.\N<@A.R<6@A.BZc @A.H@A.BZc @A.E@A.5?|@A.;5X@A.8YJ@A.8YJ@A..2@A.($x@A.+jg@A.5?|@A.BZc @A.\N<@A.Fs@A.2X@A.}Vl@A.@A.&I@A.ȴ9X@A.Ϫ͟@A.1@A.@A.!.I@A/Ft@A/@A/!-w1@A/'/W@A/1@A/8}H@A/As@A/E84@A/E84@A/O
M@A/U=@A/eں@A/sPH@A/{J#:@A/4m@A/ݗ+@A/[W>@A/[W>@A/@A0     @A0F]d@A0F]d@A/䎊r@A/Vϫ@A0*0U@A06@A0
=q@A1 ѷ@A1_p@A1&x@A1x@A1u@A1l@A1X@A1X@A1|@A1@A1^5?}@A1^5?}@A1X@A1@A12W@A1^5?}@A1^5?}@A12W@A1^5?}@A1'R@A1(@A1R<6@A1R<6@A1s@A2)y@A2:)y@A2Zc@A2nO@A2@A2<64@A2@A2ڹY@A2fB@A2W@A2)_@A2 ě@A2@A2ᰊ@A2{m@A2kP|@A2d7@A2d7@A2d7@A2^5?|@A2d7@A2u%F
@A2d7@A2W'@A26C@A23@A23@A2:)y@A2GE85@A2GE85@A2nO@A2kP|@A2h	ԕ@A2h	ԕ@A2kP|@A2kP|@A2nO@A2u%F
@A2{m@A2~"@A2{m@A2xl"h
@A2~"@A2u%F
@A2u%F
@A2qiC@A2S&@A2Y@A2`A@A2fB@A2C,@A2C,@A2C,@A2䎊q@A2fB@A2c	@A2m@A2fB@A2 ѷ@A2 ѷ@A2sP@A2fB@A2D@A2D@A2D@A2m\@A3C,z@A3PH@A3nP@A3s@A3)^	@A3F]c@A3S@A3a@N@A3n.3@A3{J#9@A3xF]@A3Mj@A3ߤ@A3wk@A3S@A3@A3|@A3A [@A3A [@A3A [@A3$@A3\N@A3\N@A4n.@A4ߤ@@A4"h	ԕ@A4?@A4Fs@A4I^5?@A4q@A4zG@A4?@A4*1@A4*1@A4쿱[@A4O
M@A4>@A5o i@A5:@A4E@A5:@A4E@A5:@A5'0@A5Q@A5B@A5F
L0@A5sg@A5}H@A5m\@A5w1@A5zxl"h@A5}H@A5ݗ@A5ݗ@A5ݗ@A5ݗ@A5!R@A5hr!@A5O
@A5O
@A5+j@A5=K@A5=K@A5@A5@A5@A5Xy=@A51@A5sh@A5@A5Ϫ͞@A5ᰉ@A5C\@A6t@A6
L/@A6@A6zG@A64K@A6@A6+jg@A61.@A68YJ@A6;5X@A6?@A6BZc @A6Vu@A6_ح@A6fffff@A6fffff@A6l!-@A6z@A6vȴ9X@A6$t@A6Fs@A6,<@A6m\@A6A@A6҈p;@A6҈p;@A6ߤ?@A61@A6@A7@A7,@A7v@A7'/W@A7$tS@A7$tS@A7;dZ@A7O
M@A7b}V@A7	k@A73@A7حV@A8 ě@A8D*@A8Xy=@A8|@A8{@A8{@A8{@A89Xb@A8ěT@A8p:@A9$/@A9_p@A9*0U2a@A90
)@A94J@A94J@A9A [@A9Dg8~@A9Gz@A9Q@A9ae@A9o hی@A9@A9'RTa@A9|@A9@A9^5?}@A9D@A92W@A9D@A9y@A9y@A9y@A9o@A9o@A9_o@A9_o@A9s@A9Y}@A9-@A:u%F@A9.H@A:	 @A:@A:Ov`@A:Ov`@A:Ov`@A:#9@A:&IR@A::)y@A:=p
@A:=p
@A:C\@A:Zc@A:Zc@A:h	ԕ@A:Zc@A:a|Q@A:h	ԕ@A:qiC@A:u%F
@A:xl"h
@A:xl"h
@A:@4@A:ݘ@A:ݘ@A:L_@A:\(@A:S&@A:ᰊ@A:ᰊ@A:vȴ@A:wkQ@A:0
@A:L/{@A:g	@A:@A:ڹY@A:m@A:m\@A:74@A;҉@A;PH@A;	@A;&@A;33333@A;=K^@A;J#9@A;a@N@A;qu!@A;{J#9@A;@A;eO@A;q@A;U=@A;*0U2@A;@A;~($@A;5Xy@A;ݗ+k@A;%2@A;g@A;@A<J@A<ߤ@@A<ߤ@@A<tj@A<!-w2@A<9XbN@A<M:@A<PH@A<SMj@A<j~#@A<q@A<_@A<O
M@A<O
M@A<?@A<#x@A<#x@A<j~@A<[W?@A<#x@A<[W?@A<Ʌoi@A<@A<@A<֡a@A<JM@A<hr@A=o i@A=u@A=V@A=84֡@A=F
L0@A=IQ@A=L_@A=O;dZ@A=Y|@A=Vl!@A=Y|@A=`A7L@A=`A7L@A=ce@A=sg@A=sg@A=zxl"h@A=ݗ@A=@A=sh@A=sh@A=\(@A=@A=@A=Ϫ͞@A=@A=oiDg@A=oiDg@A=,=@A=oiDg@A=!.@A>
(@A>Ov_@A>($x@A>?@A>Ov_خ@A>Ov_خ@A>R<6@A>Vu@A>YJ@A>\N<@A>\N<@A>c	@A>s@A>z@A>+J@A>Fs@A>6z@A>'@A>t@A>&I@A>m\@A>Ϫ͟@A>Ϫ͟@A>ߤ?@A>x@A>쿱[W@A>@A>Fs@A? hۋ@A?
=p@A?)^@A?v@A?!-w1@A?$tS@A?'/W@A?.H@A?.H@A?8}H@A?As@A?E84@A?As@A?H˒:@A?>6z@A?H˒:@A?O
M@A?Xe,@A?\(@A?v_ح@A?&@A?@A?&@A?@A?ݗ+@A?-V@A?zH@A?r@A?K]d@A?K]d@A?K]d@A?+@A?;dZ@A?rG@A?;dZ@A?@A?+j@A?+j@A?rGE9@A@	ԕ+@A@@A@*0@A@1&x@A@4m9@A@>BZc@A@D*@A@K]c@A@NU@A@[6@A@bM@A@oiDg8@A@l"h	@A@r Ĝ@A@u!@A@y=c@A@n@A@IQ@A@IQ@A@u%F@A@-
@A@d8@A@d8@A@{@A@)@A@)@A@
(@A@)^@A@ѷX@A@ѷX@A@F@A@e+@A@e+@A@4֡b@A@\)@A@	k@A@$tT@AA$/@AA@AA+@AA_p@AA [7@AA&x@AA4J@AA4J@AADg8~@AAJE@AAQ@AAXbM@AATɅo@AAXbM@AA^@AAae@AAe+a@AAu!S@AAu!S@AA|Q@AAoiD@AA@AAb}@AA~($@AAn.@AAl@AAX@AAD@AAD@AAy@AAo@AAN;6@AA_o@AAN;6@AAN;6@AA@AAᰉ'@AAs@AAs@ABI^5@ABe+@AB䎊@AB#9@AB&IR@AB-V@AB=p
@ABGE85@ABJL@ABQ_@ABQ_@ABZc@ABh	ԕ@ABqiC@ABxl"h
@AB~"@ABu%F
@AB~"@ABݘ@AB\(@AB ě@AB@AB<64@AB<64@AB@AB@ABW@AB͞&@ABW@AB͞&@AB,<@AB ѷ@AB ѷ@ABڹY@ABsP@AB ѷ@AB䎊q@ABڹY@AB ѷ@AB䎊q@ABc	@ABD@ABD@ABm\@ACnP@ACPH@AC	@AC,zxl@AC"`B@AC33333@AC9@ACF]c@AC/V@AC9@AC=K^@AC@N@ACJ#9@ACdZ@ACqu!@AC~$@AC:)z@ACMj@ACU=@ACS@ACq@AC@ACE@ACa@@ACƧ@AC
=p@AC%2@AClC@AClC@ACC]@AC$@ACs@AC\N@ADJ@ADJ@AD1&y@ADxF@AD@ADtj@AD!-w2@AD,<@AD2W@AD2W@AD64@AD9XbN@AD<쿱@AD9XbN@AD<쿱@ADI^5?@AD]ce@ADcA \@ADj~#@ADj~#@ADm8@ADm8@ADq@ADzG@ADo h@ADC@ADN;@ADN;@AD*1@AD_@AD쿱[@AD_@AD쿱[@ADTɆ@AD#x@AD[W?@AD7@AD?@ADɅoi@ADZ@AD/@ADZ@ADJM@ADJM@ADJM@ADJM@ADD@ADD@ADD@ADD@ADe@AD>@AD>@ADE@AE:@ADE@AD>@AD>@AE:@AEV@AE!.H@AE!.H@AE?|h@AEIQ@AE<64@AE?|h@AE?|h@AEB@AEF
L0@AEB@AEL_@AEVl!@AE`A7L@AEjOv@AEm\@AEp
=@AEM:@AEhr!@AE%@AEv@AEsh@AE8Y@AEϪ͞@AEb@AEϪ͞@AEcA @AE@AE8YK@AE@AE,=@AEE@AEE@AEڹ@AF+jg@AF.2@AF1.@AF;5X@AF;5X@AF?@AFBZc @AFH@AFYJ@AF_ح@AFc	@AFiB@AFp:~@AF+J@AFFs@AF@AFaf@AFT@AF}Vl@AF6z@AF}Vl@AF'@AF&I@AF&I@AFt@AF+@AFt@AF+@AF1@AF쿱[W@AF1@AF쿱[W@AF@AF@AFFs@AF!.I@AG@AG hۋ@AGFt@AG@AG$tS@AG'/W@AG.H@AG4֡a@AG4֡a@AG8}H@AG>6z@AGE84@AGH˒:@AGU=@AG\(@AGiDg8@AGb}V@AGiDg8@AGiDg8@AGlC@AGsPH@AGy@AG|hs@AG|hs@AG{J#:@AG&@AG	@AGO;d@AG	@AG@AG@AG$tS@AG-V@AGkP@AG-V@AG-V@AG?@AG	k@AG	k@AG&@AG&@AG[W>@AG[W>@AG3@AGr@AGvȴ9@AG@AGr@AGvȴ9@AG@AGfA@AG@AGfA@AGfA@AGfA@AGfA@AG+@AGfA@AGحV@AGfA@AG@AGfA@AG@AG-@AGrGE9@AGVϫ@AGVϫ@AGrGE9@AH@AH
qu@AH*0U@AH@AH@AH6@AH$xG@AH4m9@AH73@AH>BZc@AH:~ @AHH@AHNU@AHNU@AHU2a|@AH_F@AHXy=@AH[6@AHeO@AHl"h	@AHu!@AH|@AHn@AH'RT@AHtj@AHtj@AH@AHu%F@AHu%F@AH-
@AHIQ@AH@AH@AH{@AH9Xb@AH{@AH9Xb@AH{@AH4m@AHTɅ@AH
(@AH)^@AHѷX@AHp:@AHF@AHF@AHD@AHF@AHF@AHۋq
@AH`A7@AHC@AH4֡b@AH4֡b@AHC@AHC@AHC@AH4֡b@AH{@AH\)@AHPH@AH$tT@AI ѷ@AI	k~@AI	k~@AI@AI@AIrGE@AIrGE@AIrGE@AI@AI [7@AI-w1@AI0
)@AI7KƧ@AI:S@AI=b@AIDg8~@AIN;5@AIJE@AIJE@AIJE@AIJE@AIJE@AIXbM@AI^@AI[W>6@AIhr @AIrGE8@AIo hی@AIo hی@AIrGE8@AIu!S@AIu!S@AIx@AIx@AIx@AIb}@AI@AI@AI~($@AI@AIn.@AIn.@AIB@AI'R@AI^5?}@AI@AI2W@AIy@AI2W@AI@AIԕ*@AIᰉ'@AIs@AIs@AI-@AIlD@AJu%F@AJ	 @AJ@AJs@AJe+@AJ#9@AJ-V@AJ:)y@AJC\@AJC\@AJM@AJM@AJW'@AJa|Q@AJa|Q@AJh	ԕ@AJnO@AJu%F
@AJ{m@AJxl"h
@AJ~"@AJ~"@AJ~"@AJݘ@AJ\(@AJS&@AJᰊ@AJ0
@AJ>B@AJY@AJ`A@AJG{@AJc	@AJc	@AJm@AJD@AJ74@AK҉@AKS&@AKS&@AKS&@AK҉@AKu%@AKs@AKC,z@AK	@AK	@AK	@AK	@AK,zxl@AK33333@AK/V@AK/V@AK6z@AK=K^@AK6z@AKC%@AK@N@AK=K^@AKF]c@AKJ#9@AKW>6z@AK]cA@AKa@N@AKa@N@AKdZ@AKjf@AKqu!@AK{J#9@AKq@AKeO@AKeO@AKeO@AKq@AK$@AKU=@AKwk@AKU=@AK*0U2@AKq@AK@AK~($@AKa@O@AK5Xy@AK@AKa@@AKa@                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @q33333@q33333@q     @q33333@qfffff@q@q     @q񙙙@qfffff@q@q@q@r      @qfffff@q@q@q@qfffff@q@r@q@qfffff@q@r      @qfffff@q@qfffff@q     @qfffff@q33333@qfffff@q񙙙@q@qᙙ@q@q33333@q@q     @q33333@q񙙙@q33333@q񙙙@q@qᙙ@qљ@qfffff@q     @q@q@q     @qfffff@qə@q@q     @q@q33333@q     @q@qfffff@q     @qfffff@qfffff@qS33333@p33333@oٙ@n@n	@m     @mffffff@lfffff@k     @j     @j     @ip     @hfffff@hI@g33333@f@e@e     @e33333@eə@e@e33333@e@e33333@eP     @e      @dٙ@d@d@d@dfffff@d     @d     @d@dfffff@d@d@d33333@dp     @dY@dFfffff@d@c33333@cfffff@c33333@c     @cY@c333333@c33333@b33333@bfffff@b陙@b@b陙@b     @bfffff@bٙ@b陙@b33333@b@b33333@cfffff@c33333@cfffff@cfffff@bfffff@b@c33333@cfffff@c&fffff@c33333@c@b@bfffff@bfffff@b     @bc33333@b333333@bfffff@b@b	@b	@a33333@a33333@afffff@a     @a33333@ac33333@a6fffff@a,@a      @a@`@`     @`陙@`@`@`y@`9@`     @`      @_ٙ@_     @_     @_@     @^fffff@^fffff@^@_333333@_`     @_     @_     @_33333@_@`fffff@`<@`<@`     @_33333@_@_     @_y@_L@_fffff@^33333@^@^@^     @^33333@^@^`     @^&fffff@^@^      @]fffff@]33333@]l@]ffffff@]L@]33333@\     @\l@[@[@Zfffff@Z@     @Z@Y@Z333333@Z     @[33333@Z33333@Z@     @Z      @ZL@Zffffff@Z@     @Z@Yfffff@Y     @Yfffff@Y33333@Y@Yfffff@Y33333@Y     @YFfffff@Xfffff@X@Xl@X9@X      @X33333@W33333@W     @Wfffff@Wfffff@WY@W      @W@Wfffff@V@V     @V     @V      @Vfffff@Vfffff@Uٙ@U     @U@U33333@U@U33333@Ufffff@Us33333@U`     @UL@UL@U@     @U9@U333333@UFfffff@U333333@U      @U,@U@Ufffff@T@T@T33333@T     @T     @Tfffff@Ts33333@T`     @TFfffff@TFfffff@TFfffff@T&fffff@Tfffff@Sٙ@Sfffff@S@S33333@Sffffff@S@     @S,@S@S@Sfffff@Sfffff@S      @R     @R33333@R     @RS33333@Rfffff@Qٙ@Q@Q@Qfffff@Q33333@Q33333@Q@Qs33333@QY@Q9@Q&fffff@Q33333@Q      @P33333@P33333@Pٙ@P@P     @P@PY@PFfffff@Pffffff@Pffffff@Pffffff@Pl@Ps33333@P9@P      @Offfff@O@Offfff@O@OY@O@Nfffff@N@NL@Mfffff@M@M@Ls33333@L333333@L@     @LY@L&fffff@L@K33333@K@K@Kfffff@K     @Kfffff@K     @K333333@K&fffff@K@K@K      @Jٙ@Jfffff@J     @JY@J@     @JL@Ifffff@Ifffff@I     @IY@I333333@IY@I&fffff@I&fffff@Hٙ@Hfffff@H33333@Hfffff@H     @Hffffff@H333333@H      @H      @G     @Gfffff@Gs33333@GY@G@     @G@G@G@G@G&fffff@G&fffff@GL@GL@G333333@G333333@G@     @G&fffff@Fٙ@Ffffff@Ffffff@Ffffff@FY@F@     @Efffff@Efffff@EY@E333333@E333333@E@Dٙ@D     @Dfffff@D@D@D     @Ds33333@Dffffff@DL@D333333@D&fffff@D@D@Cٙ@C@C     @C     @C     @C     @C     @CL@C@B33333@C@C&fffff@CL@Cffffff@CY@CL@C@     @C333333@CL@CL@C&fffff@C      @B@B     @B     @B@Bfffff@Bffffff@B333333@B@B      @Aٙ@Aٙ@Afffff@A33333@As33333@A@     @A333333@A333333@AL@A     @B@B     @C      @Cffffff@C33333@D&fffff@D&fffff@C@C      @B@B@Cffffff@C@D      @D@D@C33333@Cffffff@C@     @B@B@B333333@A33333@A@Afffff@A@As33333@As33333@Affffff@A&fffff@A&fffff@AY@A@A@A     @A@A33333@B@     @B@B&fffff@A@>     @;      @;      @:33333@;      @;33333@;fffff@<33333@<@=333333@=L@=@=@=     @=@=@=33333@=@=     @=L@<@<@<@<333333@;fffff@;33333@;@;     @;33333@;@;@;     @;33333@;     @;L@;ffffff@;      @:33333@:L@9ffffff@9@8@9      @9@:fffff@;@;33333@;333333@:33333@9fffff@9L@833333@7@6      @5@5L@5333333@5      @5@5      @433333@4@4ffffff@4L@4333333@4@4333333@3@3fffff@3fffff@3@3     @3ffffff@3@3      @3@2@233333@3      @2fffff@3      @233333@2     @2@233333@233333@2     @2     @2@233333@2     @2@2L@2     @2     @2L@2L@2L@2ffffff@2L@2@2L@2L@2L@2L@2L@2@1@2@1fffff@133333@1@1     @1L@1L@1L@1@1@1      @1      @0@033333@0@033333@0     @0ffffff@0L@0     @0     @0L@0ffffff@0     @0@0     @0ffffff@0333333@0L@0L@0@0     @0@0@0      @0333333@0      @0      @0      @/ffffff@/ffffff@/@/333333@/@/ffffff@/333333@/333333@/      @/ffffff@/      @/333333@.@.@.      @.      @.      @.      @-@-@-      @-333333@-333333@-      @,@-      @-      @-      @,ffffff@+@,      @,      @+      @*@+      @+333333@+ffffff@+333333@+333333@+@+333333@+333333@+      @*@+      @+333333@+      @+333333@+@+333333@+333333@+@+      @+@+333333@+ffffff@+@+333333@+ffffff@+333333@+333333@+      @+333333@*@+333333@*@*ffffff@*@*@*@*ffffff@*ffffff@*333333@*@*      @*ffffff@)@*333333@*333333@*      @*      @*333333@)ffffff@*      @)ffffff@)@)@*      @)ffffff@)@)@)@*      @*      @)@)@*      @*333333@*      @*333333@*      @*      @*      @*      @)@*ffffff@*333333@)@*      @)@*      @)@)@)ffffff@)@)333333@)333333@)333333@)@)      @)333333@)333333@)333333@)333333@(@)      @(ffffff@(      @(333333@(@(ffffff@(@(ffffff@(@(333333@(      @(ffffff@(      @(      @'ffffff@(333333@(      @(      @(      @'ffffff@'@'@'333333@'ffffff@'@(      @(      @'@'ffffff@'@'@'@'@'@(      @'@'@(      @(      @'333333@'@(      @'@'@(333333@'@'@'@'333333@'333333@'333333@'333333@&@&@'ffffff@&@&333333@&ffffff@&@&@&@&333333@&@&333333@&@&333333@&333333@&ffffff@&333333@&      @&@&333333@&      @%@%@&      @&      @%@&      @&      @&      @%@%@%@%@%@&      @&      @&      @%@%ffffff@%@&      @&      @%@%333333@%@&      @&      @&      @%@%@%@%@%ffffff@%@&      @&      @%@&      @%@%ffffff@%@%@%@%ffffff@%ffffff@%333333@%@&      @%ffffff@%      @%@%@%      @$@%@%333333@%333333@%333333@%333333@%@%333333@%@%@%333333@%ffffff@%@%@%333333@%@%@%333333@%@%@%@%@%@%@%ffffff@%ffffff@&      @%ffffff@%@%@&      @%333333@%ffffff@&      @%ffffff@&      @%@%@&      @%@%@&ffffff@&@&      @%@&333333@&333333@&@&      @%@&      @&333333@&      @%@&ffffff@&ffffff@&333333@&ffffff@&      @&333333@&@&333333@&      @&      @&333333@&@&@&333333@&ffffff@&333333@&ffffff@&@&333333@&@&333333@&@&@&@&333333@&@&@'      @&@&@'      @'333333@'333333@&@&@&@&ffffff@'      @'      @&ffffff@&ffffff@&@&@&@'      @&@'      @&@'333333@&@&ffffff@'      @'333333@'      @'      @'333333@&@'@'      @'@'333333@'@'ffffff@'@'ffffff@'@'333333@'@(      @'@'@'@'@'@'@(333333@'@'@'@'@(      @'@'@'@'@(      @'@'@(333333@'@'@(333333@(      @'@(333333@'@(      @'@(333333@(      @(333333@)      @(ffffff@(      @(      @(333333@(@'@(ffffff@(ffffff@'@(ffffff@(ffffff@(ffffff@(@(333333@'@(@(@(ffffff@(@(@(@(333333@(@(@(@(@(@(@)      @)333333@)333333@(@(@)      @(ffffff@)ffffff@)333333@(@(@)333333@)@)333333@)333333@)333333@)333333@)@(@)333333@)333333@)      @)@)333333@)333333@)ffffff@)ffffff@)ffffff@)@)ffffff@(@)ffffff@)@)ffffff@)@)@)@)@)@)ffffff@)@)@)ffffff@)@)@*      @*333333@*      @)@)@)@)@*333333@*      @)@*      @*ffffff@*      @)@*ffffff@*333333@*333333@)@*ffffff@*@*333333@*ffffff@*333333@*ffffff@*@*@*ffffff@*ffffff@*333333@*ffffff@*@*@+      @*@*@+      @*@+      @+      @*@*@+333333@+      @*@+333333@+333333@+      @+333333@+@+333333@+      @+333333@+333333@+      @+333333@+ffffff@,      @,      @,      @+@+@+@,333333@,@,@,@-333333@,@-333333@,@-ffffff@-333333@-@.333333@-ffffff@,@.      @-@-@.333333@-@.ffffff@.333333@-@-@-@.ffffff@.@.@.@.@.ffffff@.      @/      @.@.@.@.@/      @.ffffff@/333333@.@.@.@/      @/333333@.@/      @/333333@/333333@/@/ffffff@/ffffff@/ffffff@/@0      @0      @/@/333333@/@0      @/@/@0@0      @/@/@0@0      @0@0333333@0      @0@0333333@0@0      @0L@0L@0@0L@0L@0@0ffffff@0     @033333@0@1      @0fffff@033333@0@0@1      @0@0@1@1333333@1333333@1      @1ffffff@1ffffff@1@1333333@1ffffff@1ffffff@1L@1     @1     @1@1fffff@1@1ffffff@2      @1fffff@1fffff@2@2333333@2@2     @2ffffff@2333333@2L@2L@2333333@2ffffff@2L@2@2fffff@2@2L@2333333@2@2@3      @2@3      @3L@3@3@3333333@3333333@3      @2fffff@3      @3333333@3333333@3      @3     @3@3@3@333333@3@3fffff@3@3@4333333@3fffff@4      @4L@3fffff@4ffffff@4     @4ffffff@4333333@4@5@4     @4     @4fffff@5      @4@4fffff@4@4@5      @4fffff@5333333@5     @5ffffff@5@5@5@5     @5fffff@5fffff@6333333@6      @6      @6      @6333333@6@6      @6@6     @6     @6     @6@6L@6     @6     @6     @633333@6ffffff@6     @6     @6     @6@6@6@633333@633333@6fffff@7      @7@7@7     @633333@6fffff@7L@7L@7     @7L@7     @7     @7ffffff@7ffffff@8      @8      @7fffff@8      @8      @8     @8L@8L@8ffffff@8L@8333333@8@8@8L@8@8fffff@8@8@9@9      @9      @9ffffff@8fffff@9@9ffffff@9L@9333333@9ffffff@9L@9L@9@9     @933333@9@9     @9     @9@9fffff@9fffff@:      @:      @:ffffff@9fffff@:333333@:@:     @:@:@:ffffff@;      @:fffff@:@:33333@:@:     @:@:@;      @:fffff@;333333@;333333@;333333@;L@;@;     @;     @<333333@;fffff@;     @;@<@;fffff@;fffff@;fffff@;@;@<     @<ffffff@<@<@<ffffff@<     @<     @<@=@=333333@=333333@=      @=333333@=333333@=     @=333333@=ffffff@=fffff@=ffffff@=L@=     @=fffff@>      @>      @>@=@>     @>333333@=fffff@>333333@>333333@>333333@>L@>@>ffffff@>333333@>@>L@>333333@>L@>ffffff@>     @>333333@>@>@>@>@?     @>fffff@?L@?L@?333333@?333333@?@?333333@?     @?@?ffffff@?33333@?     @?@?@?@@&fffff@@&fffff@@@@333333@@      @@&fffff@@Y@@Y@@ffffff@@@@Y@@ffffff@@@@33333@@@@     @@@@fffff@@33333@@@@@@     @@@@@@@A      @A      @@33333@@fffff@A      @@33333@A@A333333@A@A@A&fffff@AL@A&fffff@A333333@AY@As33333@AL@Affffff@Affffff@AY@A@Affffff@Affffff@A@Affffff@A@A     @A33333@A33333@A@A33333@Afffff@Afffff@Afffff@A     @A@Afffff@A33333@Afffff@Aٙ@A33333@A33333@B@Afffff@A33333@B      @B      @Afffff@Aٙ@Afffff@B&fffff@B@     @B@     @BY@Bffffff@B&fffff@B@     @Bffffff@B@     @Bffffff@BL@Bffffff@B33333@BY@B     @B@B@B33333@B     @B33333@B@C333333@C333333@C@C@C@C&fffff@C@     @C@C@CY@C     @Cffffff@C     @Cs33333@C@Cfffff@C@Cfffff@C33333@Cٙ@Cfffff@D@D@     @D&fffff@D@Dffffff@D     @DY@DL@DL@DY@Dffffff@Ds33333@D@D     @D@D@D@D@D33333@D@Dٙ@E@D     @D     @D@Dٙ@Dfffff@E@D     @D     @E&fffff@E@E&fffff@E@     @E333333@E&fffff@E@E333333@E333333@E@     @E@     @Es33333@Effffff@EY@EY@E@Effffff@EY@E@E33333@E     @E     @E@E33333@E33333@Efffff@E33333@E33333@E     @E     @E@E     @Efffff@Eٙ@Efffff@Eٙ@F      @Efffff@E33333@F      @F@Eٙ@F@F@F&fffff@F333333@F&fffff@F&fffff@FL@FL@F333333@F333333@Fffffff@F@     @F333333@F@F333333@F333333@F333333@Fs33333@F@Fs33333@Fs33333@FY@F@F@F33333@F     @F33333@Ffffff@G@F33333@G      @G      @G@G@G333333@GL@G@G@     @GL@G333333@G333333@GY@GY@G33333@G     @Gffffff@Gffffff@G     @G33333@Gfffff@G@G     @Gfffff@G33333@Gٙ@G33333@G33333@G@Gٙ@Gٙ@G@G33333@G@G33333@H@H      @Gfffff@Gٙ@H@     @H333333@Gfffff@H333333@H&fffff@H333333@H&fffff@H333333@HL@H333333@H@HY@HY@H@H@     @H333333@Hffffff@Hffffff@HY@H     @H333333@H     @H33333@Hs33333@H     @H@H@H33333@Hffffff@Hs33333@Hٙ@Hٙ@Hfffff@H@Hٙ@Hٙ@H33333@H33333@H@I@I@I@I@I333333@I&fffff@I333333@I@     @I333333@I@     @IY@IY@IL@IY@IL@Iffffff@I     @Is33333@I@I@I     @I@I     @I@I     @Ifffff@I33333@Iٙ@I33333@J@J      @I@J      @J&fffff@J@     @JY@J&fffff@J333333@J333333@JY@JY@J     @J@J33333@Jfffff@J@J     @Jfffff@Jfffff@K      @Jٙ@Jfffff@Jfffff@J     @Jfffff@K&fffff@K@Jfffff@K&fffff@K@     @K      @K&fffff@K@K@     @K@     @K333333@Ks33333@Kffffff@K     @K     @Ks33333@Kfffff@K@Ks33333@K     @K     @Kfffff@K33333@K@K33333@Kfffff@K     @Kfffff@Kٙ@K@K33333@K33333@L      @L      @LY@L@     @L@     @LL@L&fffff@Lffffff@L@LY@Lfffff@L@Lfffff@Lfffff@L33333@L33333@Lfffff@L33333@L33333@Lfffff@L33333@L@M      @L@Lٙ@Lfffff@M      @M&fffff@M@M      @M333333@M333333@M                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         ?lC?A7Kƨ?nP??Q?tj?      ?9XbM?bM?9XbM?zG{?1&x?\(?C%?      ?
=p?`A7L?1&x?r ě?(\)?j~"?ěS?S?      ?Ƨ-?9XbN?
=p?1&x?C%?1&y?-V?lC?tj~?zG?"`A?zG?bM?QR?Q?vȴ9X?I^5?E?I^5?睲-V?-?5?|h?噙?Vu??|hs?E?Vu?7KƧ?
=p?ěS?tj~?C%?r ě?㝲-V?dZ1?
=p?S?zG?◍O;d?7KƧ?
=p?$/?~"?-V?5?|h?`A7K?Ƨ-?Gz?lC?Гtj~?zG?Ƨ-?xF?ǍO;dZ?E?ļj~#?E?ěS?`A7K?`A7K?° ě?n?ěS?vȴ9X?5?|h?vȴ9X?S?dZ1?^5?|?tj~?O;dZ?
=p
?E??|hs?j~#?E?l?nO;?l?nO;?hr Ĝ?lD?lD?&x?`A7L?&x? ěT? ěT?`A7L?bM?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?bM?bM?;dZ? ěT?;dZ?;dZ?;dZ? ěT?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?5?|h?Q?-V?/v?5?|h?Q?5?|h?;dZ?5?|h?Q?5?|h?5?|h?(\)?-V?333333?-V?/v?-V?/v?/v?-V?-V?-V?-V?-V?1&y?/v?5?|h?-V?-V?-V?-V?5?|h?-V?-V?-V?/v?5?|h?/v?5?|h?Q?-V?-V?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?Q?Q?5?|h?Q?5?|h?Q?5?|h?5?|h?5?|h?Q?-V?-V?-V?5?|h?Q?Q?5?|h?5?|h?Q?5?|h? ěT?Q?Q?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?Q?Q?Q?5?|h?Q?5?|h?Q?Q?Q?;dZ?Q?Q?-V?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?Q?Q?Q?Q?Q?Q?;dZ?Q? ěT?Q?Q? ěT?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?Q?5?|h?Q?Q?;dZ?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?;dZ?;dZ?Q?Q?5?|h?Q?Q?;dZ?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?vȴ9X?Q?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ? ěT?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?Q?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?Q?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?5?|h?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?Q?Q?Q?;dZ?;dZ?Q?;dZ?Q?Q?Q?Q?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?;dZ?Q?Q?Q?Q?;dZ?5?|h?Q?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?;dZ?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?5?|h?Q?Q?5?|h?Q?Q?Q?;dZ?5?|h?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?;dZ?5?|h?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?5?|h?5?|h?Q?Q?5?|h?-V?Q?Q?5?|h?Q?Q?Q?Q?Q?5?|h?Q?;dZ?Q?Q?5?|h?5?|h?Q?Q?Q?;dZ?5?|h?5?|h?5?|h?Q?Q?5?|h?Q?5?|h?Q?5?|h?Q?Q?5?|h?Q?Q?Q?5?|h?5?|h?Q?5?|h?5?|h?Q?Q?5?|h?5?|h?Q?5?|h?5?|h?5?|h?Q?Q?5?|h?5?|h?;dZ?Q?Q?Q?Q?5?|h?5?|h?5?|h?5?|h?5?|h?Q?Q?5?|h?5?|h?Q?Q?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?Q?5?|h?Q?5?|h?5?|h?5?|h?Q?Q?Q?Q?5?|h?5?|h?5?|h?-V?5?|h?Q?5?|h?Q?5?|h?-V?5?|h?5?|h?Q?-V?-V?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?Q?Q?Q?5?|h?5?|h?5?|h?Q?5?|h?-V?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?-V?-V?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?-V?-V?5?|h?/v?5?|h?Q?-V?-V?-V?-V?-V?5?|h?/v?5?|h?-V?-V?5?|h?/v?-V?-V?/v?-V?-V?5?|h?5?|h?5?|h?-V?5?|h?-V?-V?/v?5?|h?-V?5?|h?-V?-V?5?|h?5?|h?5?|h?-V?-V?-V?/v?-V?5?|h?5?|h?5?|h?/v?5?|h?-V?5?|h?-V?5?|h?5?|h?5?|h?-V?5?|h?-V?5?|h?5?|h?-V?5?|h?-V?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?Q?-V?/v?5?|h?/v?5?|h?5?|h?-V?1&y?-V?-V?5?|h?-V?5?|h?5?|h?-V?5?|h?5?|h?-V?/v?5?|h?-V?/v?/v?-V?-V?-V?-V?-V?-V?5?|h?5?|h?-V?/v?/v?-V?/v?-V?5?|h?/v?5?|h?5?|h?-V?/v?5?|h?-V?-V?5?|h?-V?-V?5?|h?5?|h?-V?5?|h?-V?5?|h?/v?5?|h?5?|h?-V?-V?-V?/v?/v?-V?-V?5?|h?5?|h?5?|h?-V?5?|h?-V?-V?/v?/v?5?|h?/v?-V?-V?5?|h?5?|h?-V?/v?-V?-V?5?|h?5?|h?-V?-V?-V?-V?-V?/v?5?|h?/v?-V?-V?-V?-V?-V?5?|h?5?|h?/v?-V?/v?/v?-V?-V?-V?/v?-V?-V?-V?/v?-V?-V?-V?-V?/v?-V?-V?-V?5?|h?-V?-V?-V?/v?/v?/v?1&y?/v?/v?-V?-V?-V?/v?-V?-V?-V?5?|h?5?|h?-V?/v?/v?/v?-V?/v?-V?-V?-V?-V?/v?-V?-V?/v?-V?/v?5?|h?-V?/v?/v?/v?/v?-V?/v?/v?1&y?/v?/v?-V?/v?-V?1&y?/v?/v?-V?/v?/v?/v?/v?-V?/v?-V?5?|h?-V?5?|h?-V?-V?/v?-V?1&y?/v?/v?/v?1&y?/v?-V?/v?/v?-V?/v?5?|h?Q?Q?/v?/v?/v?5?|h?-V?/v?-V?/v?-V?5?|h?/v?/v?1&y?/v?-V?-V?/v?-V?/v?1&y?-V?1&y?/v?/v?/v?-V?1&y?1&y?/v?/v?/v?1&y?1&y?/v?-V?/v?1&y?/v?-V?-V?-V?/v?1&y?1&y?-V?/v?-V?/v?-V?/v?/v?1&y?/v?-V?/v?/v?1&y?1&y?/v?5?|h?1&y?/v?/v?/v?1&y?/v?-V?-V?/v?/v?1&y?-V?/v?/v?/v?1&y?1&y?/v?1&y?1&y?/v?/v?/v?1&y?1&y?/v?1&y?1&y?/v?1&y?1&y?(\)?1&y?1&y?-V?1&y?/v                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	P7                                      1                                       *BC *S3