CDF       
      time      pressure  4   latitude      	longitude         string_dimension   (         EXPOCODE      29AJ20160818   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    WOCE_ID       TAlPro     	DATA_TYPE         WOCE CTD   STATION_NUMBER        36     CAST_NUMBER       1      BOTTOM_DEPTH_METERS          
Creation_Time         2020-03-19T19:50:21.800881Z    ORIGINAL_HEADER      CTD,20200319CCHSIO
# Converted CTDOXY from ML/L to UMOL/KG using the following:
#     https://github.com/TEOS-10/GSW-Python, downloaded 2019-06-26
#     gsw.sigma0:  Calculates potential density anomaly with reference pressure of 0
#     dbar, this being this particular potential density minus 1000 kg/m^3.
#     This function has inputs of Absolute Salinity and Conservative
#     Temperature.  This function uses the computationally-efficient
#     75-term expression for specific volume in terms of SA, CT
#     and p (Roquet et al., 2015).
#     http://www.teos-10.org/pubs/gsw/html/gsw_sigma0.html 
#     Python equation used:
#         oxy_UMOL_per_KG = oxy_ML_per_L * 44.660 / ( (1000 +  gsw.sigma0(SA,CT)) / 1000. ) 
# Data source:  https://doi.pangaea.de/10.1594/PANGAEA.902330
# SHIP: RV Angeles Alvarino
# Cruise: MedSHIP cruise TalPro
# Region: Mediterranean Sea and Catalan Basin
# Ports: Palermo, Italy to Barcelona, Spain
# DATES: 20160818 - 20160829
# Chief Scientist: L.Jullion
# 43 stations
# Original file in AWI format. CCHDO Converted to Exchange format
# EVENT_CODE=unknown
# DATE: YYYYMMDD
# TIME: HHMM
# LATITUDE: degrees_North
# LONGITUDE: degrees_East
# STNNBR:  removed leading 0s from STNNBR
# CASTNO: not supplied by originator - CCHDO assigned all CASTNO=1 or CASTNO=2 for stations 11, 29
# CTDSAL: changed units from Practical to PSS-78.  Data values remain unchanged.
# CTDFLUOR: changed units from UG/L to MG/M3 as they are they are equivalent
# CCHDO added flags=2 for all parameters, as T.Tanhua notes all params are calibrated and CTDOXY calibrated with bottle samples
# Removed two test sample depths from event/station 004, dTalpro_Stn04_test_1db
# Data precision preserved as submitted.
# CTD: Who - T.Tanhua; Status - calibrated,final
#     Includes: CTDSAL, CTDOXY
#     CTDTMP NOTE: Used first occurrence of primary temperature sensor in original data file
#     CTDSAL NOTE: Used first occurrence of primary salinity sensor in original data
#     NOTE: Physical parameters temperature, salinity, oxygen, density, turbidity, chlorophyll, fluorescence are published on PANGAEA, DOI above.
# Fluorescence (CTDFLUOR): Who - T.Tanhua; Status -final
#        Instrument: WET Labs ECO-AFL/FL, FLNTURTD-2526
#        ScaleFactor: 1.00000000e+001
#        Dark Output: 0.0760
# Turbidity (CTDTURBDTY): Who - T.Tanhua; Status - final
#        Instrument: FLNTURTD-2526
#        ScaleFactor: 5.000000
#        Dark output Voltage: 0.070000
#
# Reference: Cruise report: https://epic.awi.de/id/eprint/49725/1/TAlPro_EUROFLEETS_cruise_report_V2.pdf
# CCHDO page: https://cchdo.ucsd.edu/cruise/29AJ20160818
# Metadata from original file
#     Event(s):     TAlPro-2016_036 (36) * LATITUDE: 40.300000 * LONGITUDE: 2.570000 * DATE/TIME: 2016-08-27T00:26:00 * CAMPAIGN: TAlPro-2016 * BASIS: Angeles Alvarino (URI: http://www.eurofleets.eu/np4/285.html) * DEVICE: CTD/Rosette (CTD-RO)
#     Citation: Tanhua, Toste (2019): Physical oceanography during MedSHIP cruise Talpro. PANGAEA, https://doi.org/10.1594/PANGAEA.902330
#     Abstract: The TAlPro cruise (Palermo - Barcelona, RV Angeles AlvariÃ±o, 18/-8/2016 - 29/08/2-16) occupied three hydrographic transects across the Tyrrhenian Sea, the western Mediterranean Sea and the Catalan Basin (Fig. 1) as part of the MedSHIP programme (Mediterranean Ship-based Hydrographic Investigations Program). A total of 43 stations were occupied during which physical (temperature, salinity, pressure, velocity), biogeochemical (oxygen, nutrients, carbonate system, dissolved Barium, oxygen and nitrogen isotopes) and anthropic (CFCs, SF6) parameters were measured in order to monitor the physical and biogeochemical state of the Mediterranean Sea.
#     Related to: Jullion, Loic (2016): TAlPro-2016: A Tyrrhenian Sea & Alger- provencal component of the MedSHIP Programme. hdl:10013/epic.5a866780-1f8a-45cf-8111-47b2b5dc29db
#     Parameter(s):
#         Event label (Event) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Sample code/label (Sample label) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Date/Time of event (Date/Time) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Latitude of event (Latitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Longitude of event (Longitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Pressure, water [dbar] (Press) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Digiquartz
#         Temperature, water [Â°C] (Temp) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: ITS-90
#         Oxygen, dissolved [ml/l] (DO) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 43
#         Turbidity (Nephelometric turbidity unit) [NTU] (Turbidity) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO
#         Fluorescence, chlorophyll [Âµg/l] (Fluores) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO-AFL/FL
#         Salinity (Sal) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Practical
#     License: Creative Commons Attribution 4.0 International (CC-BY-4.0)
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            pressure               	long_name         pressure   positive      down   units         decibar    data_min      @          data_max      @        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      9  '   pressure_QC                	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      h  `   temperature                	long_name         temperature    units         ?C (ITS-90)    data_min      @*>5?|   data_max      @:zG   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       9  o   temperature_QC                 	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      h     salinity               	long_name         salinity   units         PSS-78     data_min      @C 'RT`   data_max      @CI:S   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      9      salinity_QC                	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      h     oxygen                 	long_name         oxygen     units         ?mol/kg    data_min      @elC   data_max      @q   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        9  (   	oxygen_QC                  	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      h 8   CTDFLUOR               	long_name         CTDFLUOR   units         MG/M^3     data_min      6C-   data_max      ?E   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      9 G0   CTDFLUOR_QC                	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      h    	CTDTRBDTY                  	long_name         	CTDTRBDTY      units         NTU    data_min      ?   data_max      ?   C_format      %f     WHPO_Variable_Name        	CTDTRBDTY      OBS_QC_VARIABLE       CTDTRBDTY_QC     9 8   CTDTRBDTY_QC               	long_name         CTDTRBDTY_QC_flag      units         
woce_flags     C_format      %1d      h    time                	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      &+   data_max      &+   C_format      %10d       @   latitude               	long_name         latitude   units         	degrees_N      data_min      @D&fffff   data_max      @D&fffff   C_format      %9.4f          D   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      @\(   data_max      @\(   C_format      %9.4f          H   	woce_date                   	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3;   data_max      3;   C_format      %8d        L   	woce_time                   	long_name         	WOCE time      units         hhmm UTC   data_min            data_max            C_format      %4d        P   station                	long_name         STATION    units         unspecified    C_format      %s        ( T   cast               	long_name         CAST   units         unspecified    C_format      %s        ( |@       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         @:-@:R<6@:L/{J@:@:zG@:m\@:&@:Z@:@4n@:O;@:@:PH@:@:Xe,@:bM@:73@:$/@:ylD@:m(@:/$tS@:}Vl@9$tS@9I^5@8C,z@6ěT@6KxF]@5O
M@4@4$tT@4fs@4AA [@4)b}@4Z1@3@3rGE9@3j0
@368YJ@2ܞ쿱[@2!.@2x-
@2O.H@1ݥv@19@0qu!@0J@0]5Xy>@0<wkP@0'+@0O
M@/q@/׀4m@/}Vl@/1&@.حV@.\(@.>B[@.pbM@. n@-Y}@-GE85@-Q@-Q@-vaf@-S&@-/r@-/w@-!-w@,k~(@,@,%@,'/@,ߤ@@,7Kƨ@,nT@,b3@,V@,M5Xy>@,C@,7@,..2@,%S&@,)_@,j~@,`A7@,Xy=@,S@+ce@+3@+GE85@+8}H@+\N<@+غ)@+Vu@+^@+m]@+@+vȴ@+_ح@+v_ح@+RT`e@+~Ov_خ@+zvȴ@+w&@+r ě@+m:@+j0
@+j#9@+irGE@+cnP@+cA [@+g+I@+cZ@+]+j@+_@+l1&y@+gݗ+@+Zu%F@+SPH@+OiDg8@+J0U2a|@+CS&@+C$@+JD@+OVϫ@+Qo@+TSMj@+Uᰉ@+T֡a@+N!R<@+B&IR@+49XbN@+0:~ @+49XbN@+.+@+0'RT@+/͞@+/͞@+*W'@+)rGE@+)7KƧ@+*0U2a|@+%1@+@+PH@+%F
L@+v@+
~"@+&@*s@*Ϫ͟@*_ح@*sh@*Z@*@*	ԕ+@*ᰉ'R@*n@*s@*zxl"h@*1.@*&I@*@@*1&x@*	ԕ+@*&I@*Q@*g8}@*7@*Z1@*\N@*㕁$@*9@*C,@*wkQ@* [7@*|hs@*ce@*?@*b@*߱[W>@*4m9@*o@*U=@*ݿH˒@*BZc @*䎊r@*ѷX@*	k@*	k@*C@*-w1@*@4@*䛥S@*x@*u%F@*Fs@*wkQ@*zxl"h@*L_@*@@*JM@*n.3@* ѷ@*.H@*ae@*ව4m@*\(@*u@*凓ݗ@*S@*K]c@**0U2a@*zxl"@*.2@*(@*{J#:@*U2a|@*D@*tj~@*1@*D*@*b}@*(@*A@* ѷY@+ [6@+ -
@+ 6@+TɅo@+TɅo@*U=@*6z@*vȴ9X@* ѷY@*,=@*($x@*Ov_خ@*vȴ9X@*$t@*($x@*PH@*=K^@*6C@*PH@*_F@*73@*F@*>B@*~@*dZ@*wkP@*!.H@*W>6z@*PH@*5Xy@*+j@*$t@*BZc @*!-w1@*@*IQ@*~$@*/V@*Y}@*ߤ@*{m@*u@*;dZ@*r@*O
M@*\(@*iDg8@*'/W@*v@*Mj@*4֡a@*\(@*iDg8@*\(@*
M;@*v@*'/W@*iDg8@*@*o @*Vϫ@*͞@*@*@*O
M@*qi@*@*xF]@*6z@*}Vl@*4֡a@*t@*[W>6@*[W>6@*D@*:~ @*@*I^5?@*Ov`@*RT`e@*@*+I@*s@*唯O
@*F
L0@*唯O
@*凓ݗ@*u@*ݗ+@*-@*@*?@*捸@*-@*p:@*|@*A [@*v_ح@*N;5@*S&@*-V@*s@*iB@*|@*
=p@*|@*K]@*iB@*}H@*~$@*Q@*PH@*Vl!@*\N<@*Q@*$t@*cA @*6@*G{@*/V@*hr@*-V@*Vl!@*Q@*Q@*5Xy@*6@*5Xy@*S@*J#9@*G{@*^5?|@*@*rGE8@*0
)@*F@*}H@*z@*g	l@*Z@*-V@*2W@*D@*hr!@*q@*_o@*g8}@*a@N@*ⶮ}Vm@*s@*R<6@* [7@* [7@*@N@*$/@*$/@*@N@*	k@*ěT@*ěT@*$/@*`A@*eO@*wkQ@*C@*d8@*'RT`@*NU@*	k@*|hs@*/w@*ܬ1&@*ݥv@* ѷY@*iB@*!.H@*u@*҈p;@*m\@*iB@*ރ%@* ѷY@*u@*,=@*ce@*ܹ#x@*C,zx@*C,zx@*Q@*n.@*5Xy@*ڬ>B@*>BZ@*٦(@*=b@*+@*73@*rG@*sPH@*1@*Ϫ͟@*ᰉ@*Z@*!-w2@*ө*0U2@*tj~@*sP@*N;5@*{@*Ж@*Ϫ͞@*p:~@*8Y@*w1@*(@*!-w@*!-w@*:@*VϪ@*L_@*s@*Ƨ@*˒:)z@*jf@*C%@*jf@*'/@*#9@*ɠ'RTa@*x@* ѷ@*@*Țu%F@*p:@*TɅ@*K]d@*RT`e@*+I@*Fs@*)^@*A@*@*+a@*ĨTɆ@*g8}@*tj@*	@*n.@*	k@*     @*쿱[W@*u@*b@*H˒@*+j@*ڹZ@*p
=@*/w@*#x@*5Xy@*=K^@*~@*s@*>B@*1'@*(@*	k~@*}H@*E@*\(@*=K@*2a|@*J@*sP@*s@*-@*iB@*N;6@*X@*&x@*`A7@*'RT@*rGE9@*͞@*iDg8@*p:~@*@*jOv@*B@*V@*q@*1&y@*U=@*Ƨ@*q@*C%@*jf@*jf@*]cA@*]cA@*D@*ᰉ'@*\)@*˒:*@*$xG@*E84@*$/@*+a@*qj@*xF@*@*	@*Zc@*3@*e@*ae@* [7@*ěT@*[6@*'RT`@*䎊r@*䎊r@*䎊r@*@*     @*䎊r@*˒:)@*$tS@*;dZ@*6z@*%@*iB@*E@*[@*쿱[@*lC@*S@*S@*A@*J#9@*u%@*u%@*G{@*vȴ@*ݘ@*C\@*@*~($@*+@*U@*4m@*Xy=@*Y|@*D@*j~@*zG@*`d@*@*m\@*䎊@*hr @*{@*@*;dZ@*\(@*
M;@*c	@*@*8Y@*\@*_@*L_@*qiC@* ѷ@*$xG@*lC@*E84@*A@*
L/@*@*JM@*S@*TɆ@*TɆ@*eO@*wkQ@*Zc@*@4n@*'R@*7Kƨ@*o hی@*:S@* [7@*҈p@*ѷX@*hۋq@*6@*
qu@*?@*;dZ@*~m\@*~u@*}v@*}p
=@*}IQ@*}K]@*|?@*|C,zx@*{q@*{s@*zY@*zvȴ@*zݘ@*z^5?|@*zu%F@*z@*yD@*yrGE8@*y	k~@*x)@*x_F@*w+j@*w1@*vFs@*vFs@*v_ح@*v8YJ@*vOv_@*v+jg@*v8YJ@*v8YJ@*v8YJ@*v4K@*u?@*uᰉ@*uϪ͞@*u?@*u?@*uϪ͞@*u?|h@*tSMj@*s|@*sg	l@*r ě@*rT`d@*r䎊@*qX@*q@*qN;5@*p`A7@*p
=q@*p ě@*o@*o-V@*oAs@*n}Vl@*m
qv@*m8Y@*m@*m@*mhr!@*m\@*m:@*lcA \@*l/{J#@*l"h	ԕ@*ka@@*k:)z@*kxF]@*k6z@*k6z@*jg	@*iy@*ix@*iDg8~@*i^@*ik~(@*ik~(@*ioiD@*i7KƧ@*i ѷ@*h\)@*h\)@*hTɅ@*heO@*h	ԕ+@*g@@*glC@*g)^@*f]cf@*f]cf@*f@*fL/{J@*fL/{J@*f@*en/@*eS&@*eu@*d/@*d7@*dS@*dM:@*cA [@*cZ@*ca@N@*b74@*cS&@*c	@*b ѷ@*b\(@*b3@*be+@*be+@*ao@*as@*a@*a'R@*aR<6@*a7Kƨ@*a|Q@*aae@*a:S@*`	k@*`A7K@*`'RT`@*_˒:)@*_[W>@*_$tS@*_o@*_o@*_|hs@*_b}V@*_@*^@*^iB@*^u@*^u@*^ ѷY@*^ ѷY@*]b@*]p
=@*]IQ@*]<64@*\?@*\PH@*\PH@*\C,zx@*\(\@*\ߤ@@*\n.@*\(\@*\Q@*[6@*[S@*[6@*[lC@*[5Xy@*[5Xy@*[5Xy@*[5Xy@*[Q@*[qu!@*Z,<@*ZY@*ZY@*Zxl"h
@*Zݘ@*ZQ_@*ZC\@*Z1'@*Y>BZ@*Y(@*Yb}@*Yb}@*Y@*Yb}@*Ye+a@*YrGE8@*Y+@*XPH@*X-
@*XD*@*XbM@*W&@*WXe,@*V+J@*V_ح@*VR<6@*VE@*VE@*V+jg@*UϪ͞@*U$/@*Usg@*U2a|@*TE@*TɅoi@*TzG@*TzG@*T9XbN@*S|@*SMj@*SMjO@*SPH@*R䎊q@*RsP@*Rm@*RW@*Rp:@*R{m@*R䎊@*Q4J@*P$tT@*P)^@*P{@*P
(@*P)^@*P)^@*P)^@*P`A7@*P`A7@*PD@*P
=q@*PU2a|@*OVϫ@*O͞@*OiDg8@*O\(@*OiDg8@*O4֡a@*N1@*N2X@*Nc	@*M@*Mhr!@*Mhr!@*MO;dZ@*M\@*MO;dZ@*MV@*L@*L>B[@*Lzxl"@*LcA \@*Ks@*Ka@@*Ka@@*Kq@*Kq@*K:)z@*K:)z@*KU=@*KU=@*KxF]@*KC%@*K6z@*K6z@*JD@*Jn@*J0
@*J~"@*JqiC@*J~"@*JL/{@*Jg	@*J0
@*J~"@*J~"@*J0U2a|@*IlD@*Iԕ*@*Iy@*Iy@*I@*IDg8~@*H@*H@*H@*H@*H@*G@@*G@@*G/V@*GzH@*GK]d@*G/V@*Gݗ+@*G&@*GlC@*Gݗ+@*G	k@*G&@*GRT`e@*G)^@*G)^@*G@*F]cf@*FA@*F-@*Fs@*F?@*F
L/@*ES@*EF
L0@*EF
L0@*EF
L0@*E`A7L@*E`A7L@*Ezxl"h@*EO
@*E@*Eݗ@*Em\@*Em\@*Em\@*ES&@*E+a@*E+a@*E+a@*E+a@*Eo i@*D7@*DS@*DtSM@*DZ1@*DM:@*DZ1@*Dg8}@*DZ1@*D?@*Dtj@*C\N@*D%1@*D2W@*D%1@*DxF@*C%2@*C@*C
=p@*Cwk@*CeO@*CS@*C9@*CF]c@*CF]c@*C9@*CF]c@*CnP@*BC,@*B}Vm@*B@*B@*B}Vm@*B@4@*B@4@*B\(@*B\(@*B\(@*B@4@*B@4@*B@4@*B@4@*B\(@*B@4@*B\(@*B\(@*B\(@*B\(@*BZc@*BM@*Be+@*BI^5@*Be+@*BI^5@*Ae@*As@*Ae@*A'R@*An.@*A7Kƨ@*A7Kƨ@*AR<6@*@ѷX@*@[6@*@hۋq@*@n@*@n@*@A7K@*@4m9@*@4m9@*@NU@*@4m9@*?حV@*?حV@*?حV@*?حV@*?@*?@*?䎊r@*@     @*?@*?vȴ9@*?[W>@*?[W>@*?vȴ9@*?	@*?o@*?U=@*?b}V@*?b}V@*?|hs@*?;dZ@*?!-w1@*?Ft@*>"@*>m\@*>6z@*>%@*>%@*>%@*>@*>6z@*>6z@*>Q@*>m\@*>m\@*>m\@*>҈p;@*>쿱[W@*?Ft@*>쿱[W@*>ߤ?@*>"@*?@*?.H@*?;dZ@*?.H@*?@*?@*?Ft@*?!-w1@*?.H@*?.H@*?!-w1@*?@*>"@*>%@*>%@*>@*>$t@*>$t@*>$t@*>6z@*>m\@*>҈p;@*>m\@*>҈p;@*>m\@*>m\@*>ߤ?@*>ߤ?@*>쿱[W@*>"@*?Ft@*>쿱[W@*>҈p;@*>m\@*>@*>vȴ9X@*>vȴ9X@*>vȴ9X@*>@*>6z@*>$t@*>$t@*>%@*>%@*>vȴ9X@*>iB@*>5?|@*>BZc @*>Ov_خ@*>\N<@*>iB@*>iB@*>vȴ9X@*>%@*>$t@*>@*>@*>6z@*>Q@*>Q@*>6z@*>@*>Q@*>҈p;@*>҈p;@*>ߤ?@*>쿱[W@*>҈p;@*>҈p;@*>҈p;@*>ߤ?@*>"@*?Ft@*?Ft@*?@*?!-w1@*?!-w1@*?!-w1@*?.H@*?;dZ@*?H˒:@*?U=@*?b}V@*?o@*?|hs@*?	@*?	@*?$tS@*?[W>@*?˒:)@*?حV@*?˒:)@*?˒:)@*?˒:)@*?vȴ9@*?[W>@*?˒:)@*?حV@*?vȴ9@*?[W>@*?vȴ9@*?حV@*?@*?@*?حV@*?حV@*?حV@*?@*?䎊r@*@     @*@     @*@
qu@*@
qu@*@6@*@A7K@*@[6@*@hۋq@*@u!@*@n@*@[6@*@A7K@*@hۋq@*@hۋq@*@[6@*@hۋq@*@u!@*@-
@*@IQ@*@d8@*@ěT@*@ěT@*@ěT@*@ѷX@*@C@*@C@*@C@*@	k@*A$/@*A@N@*A:S@*A [7@*A:S@*ATɅo@*Aae@*Aae@*Ao hی@*Ao hی@*Aae@*Ao hی@*A|Q@*A|Q@*A7Kƨ@*AR<6@*AR<6@*A'R@*A@*A@*BI^5@*B&IR@*B@4n@*B@4n@*BZc@*B@4@*B\(@*BwkQ@*B@*BwkQ@*B@*B@*B@*B ѷ@*BC,@*CS&@*BC,@*B ѷ@*B74@*CnP@*C,zxl@*C9@*CF]c@*CF]c@*C9@*C,zxl@*C,zxl@*C9@*CF]c@*Ca@N@*Cn.3@*C{J#9@*CZ@*C\N@*DxF@*D%1@*D%1@*D2W@*D?@*DM:@*DM:@*DZ1@*Dg8}@*Dg8}@*Do h@*Do h@*DS@*DS@*DTɆ@*D?@*D?@*DTɆ@*Do h@*DtSM@*Dqj@*DS@*DS@*DTɆ@*D?@*D*0@*DJM@*De@*Eo i@*EQ@*EF
L0@*ES&@*ES&@*E`A7L@*Em\@*Ezxl"h@*Eݗ@*Ezxl"h@*Ezxl"h@*Em\@*Em\@*E`A7L@*Em\@*Eݗ@*Eݗ@*Ezxl"h@*EO
@*E1@*E@*ES@*EoiDg@*F@*F$/@*F1.@*FL/{J@*FYJ@*Ffffff@*Fs@*FIQ@*F@*F'@*Fx@*F]cf@*G)^@*G,@*G,@*G)^@*G,@*G+I@*G8}H@*GE84@*GlC@*Gy@*G&@*G	k@*GzH@*GK]d@*GfA@*G@@*G-@*G#@*H	ԕ+@*H@*H1&x@*H>BZc@*HK]c@*HXy=@*HeO@*H˒:*@*H˒:*@*H@*H@*H@*HTɅ@*Hp:@*H@*H\)@*I*0U2a@*I@*I@*I@*I@*I*0U2a@*I*0U2a@*I7KƧ@*IQ@*Ix@*I@*I@*I'RTa@*IB@*I^5?}@*Iᰉ'@*J~"@*JL_@*Jg	@*Jn@*JڹY@*JfB@*JD@*KI^@*KC,z@*K)^	@*K6z@*KC%@*KP{@*K]cA@*K]cA@*KxF]@*K:)z@*Kq@*KƧ@*Ks@*L"h	ԕ@*L1&y@*L1&y@*L"h	ԕ@*L/{J#@*L/{J#@*L<쿱@*L<쿱@*LVϪ@*LcA \@*Lq@*L~($x@*Lzxl"@*Lzxl"@*L[W?@*L>B[@*L>B[@*L!-w@*M:@*MV@*Mqu"@*Mqu"@*M(@*M(@*M5Xy>@*MO;dZ@*M\@*MjOv@*MM:@*Mhr!@*Mhr!@*M%@*M@*M8Y@*M@*M(@*MC\@*NzG@*N!R<@*N!R<@*N;5X@*NH@*Nc	@*Np:~@*Nqi@*NO;@*NT@*Nߤ?@*N+@*N1@*O hۋ@*O
M;@*O
M;@*Ov@*O'/W@*OAs@*OAs@*OO
M@*O\(@*OiDg8@*OO
M@*OAs@*O4֡a@*O\(@*OO
M@*OO
M@*OiDg8@*O{J#:@*Or@*O;dZ@*P@*P*0U@*P*0U@*OVϫ@*P@*P@*P*0U@*P*0U@*P*0U@*P ě@*P ě@*P-
q@*P:~ @*PH@*PbM@*PoiDg8@*P'RT@*P
=q@*P)^@*P{@*P$tT@*Q_p@*Q&x@*Q4J@*QA [@*QA [@*Q4J@*Q@*P`A7@*P$tT@*Q@*Q&x@*QA [@*QN;5@*Qu!S@*Qu!S@*Q@*Q@*Qhr @*Qhr @*Q@*Qu!S@*QN;5@*Q@*P`A7@*P{@*PoiDg8@*PoiDg8@*P|@*P@*P{@*P)^@*P{@*Q_p@*QN;5@*Q@*Qo@*QX@*Q2W@*QN;6@*QR@*QiB@*Q-@*Q-@*QiB@*QN;6@*Q-@*Q-@*Q-@*Rn@*Rn@*Rn@*Q-@*Rn@*R䎊@*R:)y@*R:)y@*RGE85@*RT`d@*RT`d@*RT`d@*RnO@*Rp:@*Rp:@*Rp:@*Rp:@*Rp:@*R{m@*R{m@*Ra|Q@*Ra|Q@*RnO@*R{m@*Rp:@*Rᰊ@*RS&@*RS&@*R ě@*R<64@*R<64@*RW@*RW@*RW@*RsP@*Rm\@*Rm\@*S&@*S33333@*S33333@*S@N@*SMjO@*SZ@*Stj~@*S@*Sߤ@*S*0U2@*Sa@O@*S|@*Sg@*S@*TJ@*T@*T@*T,<@*T9XbN@*TFs@*T`d@*Tm8@*TzG@*T#@*T3@*TO
M@*TɅoi@*T֡a@*TZ@*U'0@*U?|h@*UfA@*U!R@*U=K@*UXy=@*U\(@*U?@*Uᰉ@*Vt@*U!.@*Uᰉ@*Vt@*Uᰉ@*Uᰉ@*V4K@*Vt@*Vt@*V4K@*VOv_@*V+jg@*V8YJ@*VE@*VR<6@*V_ح@*Vl!-@*V+J@*V+J@*Vaf@*V}Vl@*Vȴ9X@*VϪ͟@*VϪ͟@*VϪ͟@*VϪ͟@*VC-@*VϪ͟@*VϪ͟@*VC-@*V@*V@*V!.I@*W
=p@*WXe@*WKƧ@*Weں@*WsPH@*W4m@*WO;d@*W&@*WkP@*W3@*W+@*W@*WrG@*XF]d@*XF]d@*WrG@*W+j@*XbM@*X*0@*X73@*XD*@*XQ@*XQ@*XQ@*XQ@*Xl"h	@*Xy=c@*Xtj@*Xtj@*X-
@*X)@*X)@*X@@*Xe+@*X4֡b@*XPH@*Y	k~@*Y+@*Y#w@*Y=b@*YXbM@*Ye+a@*YrGE8@*YrGE8@*YrGE8@*YrGE8@*Yb}@*Y~($@*Y(@*Y|@*Y_o@*Y>BZ@*YY}@*YY}@*Zu%F@*Zu%F@*Z@*Z@*Z)y@*Z6C@*ZC\@*Z^5?|@*Z^5?|@*ZkP|@*Zݘ@*Zvȴ@*ZY@*Z,<@*ZG{@*Z~@*[u%@*["`B@*[=K^@*[J#9@*[W>6z@*[~$@*[q@*[S@*[m]@*[5Xy@*[Q@*[$@*\n.@*\Q@*\(\@*\C,zx@*\PH@*\j~#@*\N;@*\쿱[@*\1&@*\#x@*\Z@*\hr@*]K]@*]!.H@*]/w@*]IQ@*]Vl!@*]p
=@*]ڹZ@*]+j@*]-V@*]H˒@*]b@*],=@*^ ѷY@*^u@*^($x@*^BZc @*^Ov_خ@*^iB@*^%@*^$t@*^6z@*^m\@*^҈p;@*^쿱[W@*^"@*_@*_!-w1@*_;dZ@*_H˒:@*_b}V@*_|hs@*_	@*_?@*_vȴ9@*_˒:)@*_حV@*_䎊r@*`
qu@*`'RT`@*`4m9@*`NU@*`[6@*`u!@*`n@*`IQ@*`4m@*`ěT@*`҈p@*`	k@*a$/@*a@N@*a-w1@*aGz@*aae@*ao hی@*a7Kƨ@*an.@*a'R@*ao@*a@*as@*bI^5@*be+@*b&IR@*b@4n@*bZc@*bh	ԕ@*b@4@*bwkQ@*b@*b@*b ѷ@*bC,@*cS&@*c	@*c,zxl@*cF]c@*ca@N@*cn.3@*ceO@*c$@*c@*cZ@*c
=p@*cA [@*dxF@*dtj@*d%1@*dM:@*dZ1@*dg8}@*do h@*dqj@*d?@*d7@*d/@*dJM@*eo i@*eu@*e+a@*eF
L0@*e`A7L@*em\@*eݗ@*e@*e1@*e@*e8YK@*eoiDg@*f
L/@*f@*f$/@*f?@*fYJ@*fs@*fIQ@*f@*f'@*fA@*f]cf@*g,                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @C ˒:*@C 'RT`@C 4m9@C l"h	@Cxl"h
@C3@Cu!@C-
@C	+@C	-@C
p:@C
M@C
ڹY@C_@C+jg@Ct@C@C(\@C%1@C"h	ԕ@Cn/@C_ح@C'/@CeO@C
S&@C*0@Cy@C	^5?}@Ctj@Co h@C
,=@CMj@CO;d@C:S@CƧ@Cm\@C~$@C?@CJL@CzG@C}Vl@C1@CS&@CC]@CjOv@C_ح@C@C,@C'@C6z@Caf@CE@Cp
=@Cݗ@CU=@Cu@C[W>@C!.H@C"vȴ@C")_@C#'/@C#	@C"~"@C">B@C"W@C"@C"c	@C#W>6z@C$1&@C%:@C%qu"@C%M:@C&t@C&zG@C%C\@C%C\@C%
qv@C%b@C&zG@C&E@C&IQ@C&-@C&}Vl@C&@C&ߤ?@C'@C&Fs@C&x@C'@C'$tS@C'3@C'@C'-@C(}H@C'+j@C'?@C'4m@C'iDg8@C'iDg8@C'KƧ@C';dZ@C'U=@C'&@C'+@C';dZ@C(@C(>BZc@C(u%F@C(-
@C)Q@C).H@C*I^5@C*u%F@C*@C+\N@C+Q@C+$@C+Z@C+a@O@C+E@C+
=p@C,!-w2@C-<64@C-(@C.\N<@C/,@C/+@C/@C/r@C/As@C.t@C.6z@C/	k@C/K]d@C0u%F@C0F@C1 ѷ@C1$/@C17KƧ@C1(@C2	 @C1.H@C1ᰉ'@C1@C1N;6@C1iB@C1ԕ*@C1ᰉ'@C1@C1R<6@C1'RTa@C1ԕ*@C2kP|@C2~"@C2Zc@C23@C2Zc@C2S&@C3PH@C3Z@C3m]@C4g8}@C4[W?@C4֡a@C5V@C5O;dZ@C5w1@C5n/@C5(@C6
(@C65?|@C6R<6@C6l!-@C6}Vl@C6@C71@C7H˒:@C7_o@C7$tS@C7-@C8>BZc@C8u!@C8n@C8@C8@C9-w1@C9k~(@C9u!S@C9b}@C9@C9~($@C9X@C9Y}@C:^5?|@C:>B@C:Y@C:L/{@C:C,@C;]cA@C;W>6z@C;S@C;W>6z@C;a@N@C;g	l@C;jf@C;xF]@C;Q@C<?@C<SMj@C<]ce@C<zxl"@C<j~@C=?|h@C=ce@C=m\@C=(@C>!R<@C>8YJ@C>vȴ9X@C>m\@C>x@C?v@C?O
M@C?{J#:@C?@C@4m9@C@NU@C@eO@C@9Xb@C@ěT@C@@C@PH@CA@N@CA@CADg8~@CAb}@CAR<6@CA'RTa@CAn.@CAl@CAN;6@CAY}@CBs@CB#9@CB&IR@CB#9@CB^5?|@CBwkQ@CBn@CBc	@CC&@CCa@N@CC]cA@CCdZ@CC@CDxF@CD"h	ԕ@CD<쿱@CDm8@CD?@CDtSM@CDZ1@CD`d@CD`d@CD2W@CD"h	ԕ@CDL_@CD@CDL_@CD(\@CD(\@CD/{J#@CD9XbN@CDC,zx@CDVϪ@CDm8@CDzG@CDC@CDN;@CD쿱[@CD1&@CD?@CD?@CD*0@CDZ@CDD@CE*0@CE(@CE(@CE%F
L@CE+a@CE/w@CE/w@CEF
L0@CEv@CE8Y@CEϪ͞@CFu@CF$/@CF($x@CF+jg@CF!R<@CF$/@CFOv_@CF
(@CF
L/@CF
L/@CFt@CF ѷY@CF_o @CF@CF.2@CF5?|@CFp:~@CFl!-@CFiB@CFp:~@CFs@CFvȴ9X@CF-@CG4֡a@CG;dZ@CG$tS@CGlC@CG{J#:@CG|hs@CGv_ح@CGo@CG&@CG䎊r@CH4m9@CH˒:*@CHd8@CH-
@CH-
@CH@CH9Xb@CHp:@CH{@CH$tT@CH$tT@CH{@CHF@CH@CH{@CI#w@CI7KƧ@CI7KƧ@CI-w1@CI0
)@CI*0U2a@CI*0U2a@CI0
)@CI0
)@CI4J@CI4J@CI:S@CI:S@CI:S@CI:S@CI:S@CI-w1@CI+@CH4֡b@CH4֡b@CHۋq
@CHF@CHTɅ@CH@CHn@CHNU@CH-
q@CH'RT`@CH ě@CH@CH	ԕ+@CHbM@CH*0U@CH@CH@CH6@CH6@CH ě@CH*0@CH-
q@CH4m9@CHhۋq@CHu!@CHl"h	@CHbM@CHbM@CH[6@CHhۋq@CHu!@CHl"h	@CHQ@CHU2a|@CHhۋq@CHoiDg8@CHy=c@CHr Ĝ@CH-
@CH-
@CH-
@CHu%F@CHd8@CHd8@CHU@CHU@CH@CH
=q@CH
=q@CH
=q@CH
=q@CH-
@CH-
@CH@CH@CHtj@CHtj@CH-
@CH@CH@CH@CH@CH'RT@CH|@CHr Ĝ@CHoiDg8@CHoiDg8@CHl"h	@CHbM@CHU2a|@CHQ@CHK]c@CHA7K@CH4m9@CH-
q@CH*0@CH$xG@CH$xG@CH$xG@CH ě@CH6@CH6@CH6@CHbM@CH*0U@CH
qu@CH*0U@CHbM@CH	ԕ+@CG#@CG#@CG+j@CG-@CG-@CGVϫ@CG-@CG-@CGrG@CG@@CG;dZ@CG@CG@CG@CG+@CGo @CG@CGr@CGr@CG&@CGkP@CGݗ+@CG	@CG4m@CGv_ح@CGo@CGb}V@CGlC@CGiDg8@CGiDg8@CGeں@CG_o@CGU=@CGO
M@CGH˒:@CGKƧ@CGH˒:@CG>6z@CG8}H@CG1@CG$tS@CG)^@CG
=p@CGFt@CG hۋ@CFMj@CFx@CFߤ?@CF+@CFϪ͟@CFϪ͟@CF҈p;@CFt@CFȴ9X@CF&I@CF@CFQ@CFQ@CF6z@CFaf@CF@CF@CF,<@CF$t@CF$t@CF$t@CFFs@CF@CFqi@CFqi@CFqi@CFqi@CF+J@CFIQ@CFvȴ9X@CFp:~@CFfffff@CF_ح@CFR<6@CFH@CF;5X@CF1.@CF($x@CF$/@CFu@CF4K@CF
L/@CF
L/@CFt@CEڹ@CEڹ@CE!.@CE(@CEᰉ@CEᰉ@CEoiDg@CE(@CE(@CE(@CEᰉ@CE,=@CES@CE8YK@CE@CEϪ͞@CE8Y@CE@CEsh@CE1@CEXy=@CEXy=@CEv@CE=K@CE=K@CE=K@CE+j@CEhr!@CEhr!@CEhr!@CEM:@CEݗ@CE}H@CEw1@CEfA@CES&@CEL_@CEB@CEB@CE<64@CE84֡@CE(@CE!.H@CE*0@CE'0@CE:@CD>@CDD@CDhr@CD@CD>B[@CDZ@CD*0@CD@CD[W?@CD?@CD쿱[@CDqj@CD~($x@CDwkP@CDtSM@CDj~#@CDZ1@CDVϪ@CDFs@CDC,zx@CDC,zx@CD?@CD/{J#@CD%1@CD"h	ԕ@CDQ@CDL_@CDߤ@@CD@CDxF@CD1&y@CDJ@CC\N@CC@CC$@CC$@CCC]@CC%2@CCݗ+k@CC
=p@CC|@CC@CC@CCa@O@CCZ@CCE@CCq@CC*0U2@CCU=@CCU=@CCߤ@CCA@CC:)z@CC:)z@CCMj@CCeO@CC@CC{J#9@CCqu!@CCn.3@CCa@N@CC]cA@CCZ@CCS@CCS@CCP{@CCP{@CCMjO@CCMjO@CCMjO@CCF]c@CCC%@CC@N@CCC%@CC@N@CC@N@CC=K^@CC6z@CC)^	@CC	@CCPH@CC'/@CCu%@CCS&@CBm\@CB74@CBD@CBc	@CBC,@CBG{@CB ѷ@CBڹY@CB`A@CBW@CBn@CB<64@CBY@CBY@CBg	@CB ě@CB>B@CBS&@CBvȴ@CBvȴ@CB0
@CBᰊ@CB\(@CBL_@CBL_@CB@4@CBxl"h
@CBnO@CBkP|@CBkP|@CBnO@CBkP|@CBkP|@CBh	ԕ@CBa|Q@CBa|Q@CB^5?|@CBZc@CBT`d@CBQ_@CBJL@CBC\@CB@4n@CB=p
@CB:)y@CB6C@CB3@CB0U2a|@CB)y@CB&IR@CB䎊@CBe+@CBOv`@CBe+@CB@CBI^5@CBn@CA.H@CA-@CAlD@CAY}@CAY}@CA@CAR@CA>BZ@CAe@CAᰉ'@CAiB@CAiB@CA@CA@CAԕ*@CAԕ*@CAN;6@CA_o@CA_o@CA2W@CA^5?}@CA^5?}@CA|@CA'R@CAB@CAB@CAl@CAl@CA(@CAn.@CA@CAR<6@CAo@CAo@CAo@CA~($@CA7Kƨ@CAb}@CAb}@CA|Q@CAu!S@CArGE8@CAo hی@CAk~(@CAhr @CAe+a@CAe+a@CAe+a@CAae@CA^@CA[W>6@CA[W>6@CA[W>6@CA[W>6@CA[W>6@CATɅo@CATɅo@CATɅo@CAJE@CAGz@CADg8~@CAA [@CA=b@CA=b@CA:S@CA7KƧ@CA4J@CA-w1@CA*0U2a@CA&x@CA*0U2a@CA&x@CA#w@CA [7@CA#w@CA@CA+@CA@N@CA@CA	k~@CA ѷ@C@	k@C@4֡b@C@C@C@C@C@C@C@@C@e+@C@҈p@C@D@C@F@C@ѷX@C@p:@C@)^@C@@@C@ěT@C@
(@C@4m@C@4m@C@U@C@{@C@@C@@C@@C@-
@C@-
@C@u%F@C@tj@C@YJ@C@n@C@n@C@|@C@|@C@y=c@C@|@C@y=c@C@y=c@C@u!@C@y=c@C@r Ĝ@C@l"h	@C@eO@C@bM@C@_F@C@[6@C@[6@C@Xy=@C@NU@C@NU@C@H@C@A7K@C@73@C@73@C@73@C@1&x@C@1&x@C@-
q@C@'RT`@C@$xG@C@$xG@C@}H@C@@C@@C@bM@C@bM@C@	ԕ+@C@
qu@C@	ԕ+@C@
qu@C@@C@@C@F]d@C@F]d@C@     @C?#@C?rGE9@C?䎊r@C?-@C?-@C?Vϫ@C?-@C?-@C?Vϫ@C?Vϫ@C?rG@C?@C?;dZ@C?حV@C?حV@C?fA@C?@C?+@C?o @C?o @C?o @C?vȴ9@C?/V@C?3@C?r@C?[W>@C?[W>@C?zH@C?zH@C?͞@C?͞@C?&@C?&@C?&@C?&@C?-V@C?-V@C?kP@C?$tS@C?ݗ+@C?ݗ+@C?O;d@C?O;d@C?	@C?{J#:@C?|hs@C?v_ح@C?v_ح@C?y@C?y@C?v_ح@C?v_ح@C?sPH@C?v_ح@C?sPH@C?o@C?o@C?o@C?lC@C?eں@C?iDg8@C?eں@C?b}V@C?_o@C?\(@C?\(@C?U=@C?U=@C?U=@C?RT`e@C?U=@C?RT`e@C?O
M@C?KƧ@C?KƧ@C?H˒:@C?O
M@C?E84@C?H˒:@C?E84@C?As@C?>6z@C?;dZ@C?;dZ@C?8}H@C?8}H@C?4֡a@C?4֡a@C?1@C?.H@C?+I@C?+I@C?'/W@C?$tS@C?$tS@C?$tS@C?,@C?,@C?,@C?,@C?,@C?v@C?,@C?Xe@C?Xe@C?Xe@C?@C?@C?@C?)^@C?)^@C?
=p@C?
M;@C?@C?@C?@C>!.I@C? hۋ@C>!.I@C>"@C>"@C>Fs@C>Mj@C>Mj@C>@C>1@C>C-@C>ߤ?@C>]cf@C>]cf@C>+@C>Ϫ͟@C>Ϫ͟@C>Ϫ͟@C>Ϫ͟@C>A@C>A@C>A@C>t@C>ȴ9X@C>t@C>t@C>ȴ9X@C>ȴ9X@C>m\@C>m\@C>&I@C>ߤ?@C>ߤ?@C>@C>@C>Q@C>@C>Q@C>'@C>'@C>2X@C>}Vl@C>-@C>T@C>T@C>T@C>T@C>@C>af@C>@C>af@C>af@C>af@C>@C>@C>@C>af@C>@C>@C>@C>,<@C>af@C>@C>@C>O;@C>O;@C>Fs@C>O;@C>O;@C>Fs@C>Fs@C>O;@C>$t@C>qi@C>qi@C>qi@C>qi@C>qi@C>qi@C>+J@C>+J@C>qi@C>+J@C>+J@C>+J@C>%@C>%@C>%@C>+J@C>+J@C>%@C>IQ@C>IQ@C>}Vl@C>}Vl@C>vȴ9X@C>vȴ9X@C>s@C>vȴ9X@C>s@C>s@C>s@C>p:~@C>p:~@C>l!-@C>iB@C>l!-@C>iB@C>l!-@C>iB@C>iB@C>fffff@C>iB@C>fffff@C>fffff@C>iB@C>c	@C>c	@C>c	@C>c	@C>c	@C>_ح@C>_ح@C>_ح@C>c	@C>c	@C>_ح@C>_ح@C>_ح@C>_ح@C>\N<@C>_ح@C>\N<@C>_ح@C>\N<@C>\N<@C>\N<@C>\N<@C>\N<@C>YJ@C>YJ@C>YJ@C>YJ@C>YJ@C>YJ@C>YJ@C>YJ@C>YJ@C>YJ@C>YJ@C>YJ@C>\N<@C>YJ@C>Vu@C>Vu@C>Vu@C>Vu@C>R<6@C>R<6@C>R<6@C>R<6@C>R<6@C>R<6@C>R<6@C>R<6@C>Ov_خ@C>R<6@C>Ov_خ@C>Ov_خ@C>L/{J@C>Ov_خ@C>Ov_خ@C>L/{J@C>L/{J@C>R<6@C>R<6@C>Ov_خ@C>Vu@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>L/{J@C>Ov_خ@C>L/{J@C>Ov_خ@C>Ov_خ@C>L/{J@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>R<6@C>Ov_خ@C>L/{J@C>L/{J@C>L/{J@C>H@C>L/{J@C>H@C>H@C>L/{J@C>L/{J@C>L/{J@C>L/{J@C>H@C>L/{J@C>L/{J@C>H@C>H@C>E@C>E@C>E@C>H@C>E@C>E@C>E@C>E@C>H@C>H@C>H@C>H@C>H@C>H@C>E@C>E@C>L/{J@C>H@C>L/{J@C>H@C>L/{J@C>H@C>H@C>L/{J@C>H@C>H@C>H@C>H@C>Ov_خ@C>H@C>H@C>H@C>L/{J@C>L/{J@C>E@C>H@C>E@C>E@C>E@C>E@C>E@C>H@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>R<6@C>R<6@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>L/{J@C>Ov_خ@C>L/{J@C>H@C>H@C>H@C>L/{J@C>E@C>E@C>E@C>BZc @C>BZc @C>BZc @C>?@C>?@C>?@C>?@C>?@C>BZc @C>?@C>BZc @C>?@C>BZc @C>E@C>E@C>BZc @C>BZc @C>E@C>BZc @C>E@C>?@C>BZc @C>?@C>E@C>?@C>?@C>;5X@C>?@C>?@C>;5X@C>?@C>?@C>?@C>BZc @C>BZc @C>E@C>E@C>H@C>BZc @C>E@C>E@C>E@C>BZc @C>E@C>H@C>H@C>H@C>L/{J@C>H@C>E@C>H@C>H@C>E@C>H@C>H@C>H@C>L/{J@C>E@C>H@C>L/{J@C>H@C>H@C>L/{J@C>L/{J@C>H@C>H@C>L/{J@C>H@C>L/{J@C>H@C>H@C>H@C>L/{J@C>L/{J@C>H@C>H@C>L/{J@C>H@C>H@C>L/{J@C>L/{J@C>L/{J@C>H@C>H@C>L/{J@C>H@C>L/{J@C>L/{J@C>L/{J@C>L/{J@C>L/{J@C>L/{J@C>L/{J@C>Ov_خ@C>L/{J@C>L/{J@C>YJ@C>YJ@C>YJ@C>YJ@C>\N<@C>\N<@C>YJ@C>YJ@C>\N<@C>\N<@C>_ح@C>\N<@C>\N<@C>_ح@C>\N<@C>\N<@C>_ح@C>\N<@C>_ح@C>c	@C>c	@C>c	@C>_ح@C>_ح@C>_ح@C>c	@C>_ح@C>c	@C>_ح@C>c	@C>fffff@C>fffff@C>c	@C>iB@C>c	@C>fffff@C>fffff@C>iB@C>iB@C>fffff@C>fffff@C>fffff@C>fffff@C>fffff@C>c	@C>fffff@C>fffff@C>fffff@C>c	@C>fffff@C>fffff@C>fffff@C>fffff@C>fffff@C>fffff@C>c	@C>fffff@C>fffff@C>c	@C>c	@C>c	@C>c	@C>c	@C>fffff@C>fffff@C>fffff@C>fffff@C>fffff@C>fffff@C>fffff@C>fffff@C>iB@C>iB@C>c	@C>fffff@C>c	@C>fffff@C>fffff@C>_ح@C>c	@C>_ح@C>\N<@C>YJ@C>\N<@C>YJ@C>\N<@C>\N<@C>\N<@C>_ح@C>_ح@C>_ح@C>\N<@C>_ح@C>\N<@C>YJ@C>\N<@C>_ح@C>YJ@C>YJ@C>YJ@C>\N<@C>YJ@C>\N<@C>YJ@C>YJ@C>Vu@C>YJ@C>YJ@C>YJ@C>\N<@C>\N<@C>\N<@C>_ح@C>\N<@C>\N<@C>\N<@C>Vu@C>Vu@C>R<6@C>Vu@C>R<6@C>Vu@C>R<6@C>Vu@C>R<6@C>Vu@C>Vu@C>R<6@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>E@C>E@C>BZc @C>;5X@C>8YJ@C>8YJ@C>8YJ@C>5?|@C>5?|@C>5?|@C>8YJ@C>;5X@C>?@C>?@C>BZc @C>BZc @C>BZc @C>?@C>?@C>?@C>;5X@C>;5X@C>;5X@C>8YJ@C>8YJ@C>;5X@C>8YJ@C>8YJ@C>8YJ@C>8YJ@C>5?|@C>5?|@C>5?|@C>5?|@C>1.@C>1.@C>5?|@C>1.@C>1.@C>1.@C>1.@C>1.@C>1.@C>5?|@C>.2@C>.2@C>.2@C>($x@C>+jg@C>+jg@C>($x@C>($x@C>($x@C>+jg@C>($x@C>($x@C>($x@C>($x@C>+jg@C>($x@C>$/@C>($x@C>($x@C>($x@C>($x@C>$/@C>$/@C>($x@C>$/@C>($x@C>($x@C>$/@C>$/@C>$/@C>$/@C>$/@C>$/@C>$/@C>$/@C>$/@C>($x@C>($x@C>($x@C>($x@C>$/@C>$/@C>($x@C>$/@C>($x@C>($x@C>($x@C>($x@C>($x@C>($x@C>.2@C>+jg@C>+jg@C>.2@C>.2@C>.2@C>.2@C>.2@C>.2@C>.2@C>.2@C>+jg@C>($x@C>+jg@C>+jg@C>($x@C>($x@C>$/@C>($x@C>$/@C>($x@C>($x@C>($x@C>$/@C>($x@C>($x@C>($x@C>($x@C>($x@C>($x@C>($x@C>($x@C>$/@C>$/@C>!R<@C>!R<@C>$/@C>!R<@C>!R<@C>!R<@C>!R<@C>!R<@C>Ov_@C>$/@C>$/@C>$/@C>$/@C>$/@C>!R<@C>$/@C>!R<@C>!R<@C>$/@C>$/@C>!R<@C>$/@C>Ov_@C>Ov_@C>!R<@C>Ov_@C>!R<@C>!R<@C>!R<@C>Ov_@C>Ov_@C>Ov_@C>u@C>Ov_@C>u@C>u@C>Ov_@C>u@C>u@C>Ov_@C>u@C>u@C>u@C>u@C>Ov_@C>Ov_@C>u@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>u@C>u@C>u@C>u@C>u@C>u@C>Ov_@C>u@C>u@C>u@C>Ov_@C>u@C>u@C>@C>u@C>u@C>@C>u@C>u@C>u@C>u@C>@C>@C>@C>@C>@C>@C>u@C>@C>@C>u@C>@C>u@C>@C>@C>u@C>u@C>u@C>u@C>u@C>u@C>Ov_@C>u@C>@C>Ov_@C>u@C>u@C>Ov_@C>u@C>u@C>u@C>Ov_@C>u@C>Ov_@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>@C>u@C>u@C>u@C>u@C>u@C>Ov_@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>Ov_@C>u@C>@C>@C>@C>@C>u@C>@C>u@C>u@C>u@C>u@C>@C>Ov_@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>Ov_@C>u@C>Ov_@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>@C>Ov_@C>u@C>Ov_@C>u@C>u@C>u@C>@C>u@C>Ov_@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>Ov_@C>u@C>u@C>Ov_@C>u@C>u@C>Ov_@C>u@C>Ov_@C>u@C>u@C>u@C>Ov_@C>u@C>u@C>u@C>u@C>Ov_@C>u@C>u@C>u@C>u                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @i5p
=@i!R@i!-w1@i?33333@ihm\@inI^5?@ib~@iZwkQ@ibMj@ibC-@ioeں@iy"`B@i*0U@i}8}H@i˒:*@iK]c@iu@iI^@j4Q@j+j@kXIQ@k߈eO@mO
@ob}@pCrGE8@p6D@p[lC@pt+I@pR84֡@on@o;5X@n;5X@m8Y@nH˒@o+@p0qu"@pE@qy@qvȴ9X@q@qjVϪ@pM:@ph[W>@pߤ?@p+YJ@p]e+a@p|#@p~p:@p1&y@pk~(@p_vȴ9@pu%F@pP{@p
RT`e@p-
@p(P{@p8&@p0NU@pfA@o^5?}@oxF@ooXy=@oᰉ@n[6@n8YK@nυQ@n!.@n`d@nn.@n6z@m)^@mb	k@lQ@l&@l,zxl@lKƧ@lWC\@lPH@kA [@k'RT`@kUo@k#ce@j[W>@j8}H@j<#x@jKC\@jqy@jB:)y@i*0U@i[W>6@iߤ@@j=-@jtzG@j|d7@jy$@jx&IR@jXy=@jeO@jRT`e@jrGE9@j,=@j荸@j@jtj~@jᰉ'@jeO@j@j:)y@j4J@jɅoi@jěT@j3@jrG@jrD*@jCS&@jx@jם-V@jO;@jۋq
@jJ#9@j
qv@jrGE9@jC,z@jEv@j4Fs@jTɆ@jxl"h
@j-@jzZ1@j-
@j($x@j&@j@j
qv@jXe,@j͞@ja@@jAs@joiD@j{o@jX@jߤ?@j$tS@j@j䎊r@jQ@jjf@j!-w1@jbM@jm\@jXe@j?@jqu"@j\@jcA @j$@j!R@j}H@j
=p@j|@jlt@jbD*@jr쿱[W@j{A [@jmY|@jU~($@j?~$@j-n.3@j?y@jJ*1@j*af@i<쿱@ieO@iqu!@i&IR@jxl"h
@ju!@iJ#9@iH@iqu"@i!.I@ilA7K@iZ2W@i-H˒@h@hZvȴ@h֡a@h1&@h:)y@h!U=@hHqj@h}TɅo@h}S@hU
=p@h'4J@h!?@h9=b@h+Y|@hlC@h@h{@h Fs@g4m@gE@g݋q@g҈@gz쿱[W@gr*1@g1&x@g[W>6@gaf@gs@g:S@h :)y@h	s@gn.3@g&IR@g4J@gu%@gᰊ@grGE9@g@gZ1@gY|@g;5X@ge@grGE8@gԕ*@g`d@g`A7L@gNU@g"`@g!R<@gY|@gD@g,@gdZ@g9@gGz@gFs@gӧ&@gu%@g?@gJ@gFs@g޾
(@gM:@gfA@g/V@g{@g8}H@g}Vl@g4֡a@gC\@g2a|@gn1&x@gn1&x@geQ@g]M:@gyJ#9@gE@g@g%2@g*0U2@h;|@hBT@hMD@ha1@hXۋq
@hV*0U@hJe@hF@h8@h3Z@h;1@h/.H@h6!-w2@h0$t@h/,zxl@h4Y@h6}H@h-y@h+ hۋ@h$
(@h84֡@gƧ@g~($@g@g`d@g64@g5?|@gB@g^@g@g\@g_o@g'R@g
(@gZ@gY|@gXe,@gD@gsP@gϪ͟@g$tT@gc	@g
(@g@@g
qu@g(@ge+@gߤ?@gڹZ@g{C]@gߤ?@gS@g~9Xb@gw\(@gom\@g#҉@fϷr@f73@fbM@fĚu%F@fa@N@fˋq@f҈@f֧-@fZ@fa\N@f$C-@e84֡@e8}H@f)҉@f<|@f/#@fC@f
|@enO@f&IR@f	ԕ+@fP{@f5eO@f++@f$/@elC@eR<6@eOv`@e_o@ej~#@eN;5@en.@ej~#@eL_@ewk@exF]@e!.H@eZc@eꅇݘ@ev_ح@e	k@f ě@f"4K@f&:~ @f.-
@f?:S@f6`A7@fDȴ9X@fnqiC@fL_@f5Xy>@f&IR@f3@fzG@fXe@f7@f(@f4m9@f'RT@fl"h	@fϪ͞@fg	@f$tS@f*0@fT@ff@f9S@f29Xb@fK|@f]D@fX2W@fT_o @f9?@f4Ov`@fO@fZe@fNwkP@f9wk@f/ᰉ@f'O
@f[W>@f@f {@e74@f {@eH˒@e>6z@e>6z@eݗ+@eiDg8@f>B[@f	k@fs@f	k@f O
M@e>BZ@eZ@e:)z@e,=@e	@en/@fsg@fsP@f@fU=@f䎊r@f-V@f\(@ffA@fU=@f 6z@e+jg@e)_@e˒:*@f d8@eS@eT`d@eO;d@e?@er@e.H@eS@eb}V@f6C@fkP@fE@f TɆ@e(\@eX@eX@eᰉ'@f
a|Q@fkP@e}Vl@eae@eDg8~@e_p@eE@eDg8~@f!.I@fPH@fߤ?@ftj@fѷX@fn.3@fn.3@fA@f9Xb@f+j@fm\@f`A@eB@f
%F
L@fVϫ@fO;dZ@fkP|@fy@fR@f
^5?|@f
]ce@eC@f T@fOv`@fOv`@f]cf@f
\N<@f_o @f
#w@f_o@fFt@f Fs@f#[W>6@fᰉ@fMjO@f/V@f'Q@f/Q@f4t@f4t@f& ě@f$<64@f-nP@f S&@f& ě@f4t@f4F]d@f/b@f-u@f.u%F
@f4F]d@f=/V@f<W'@f+zH@f1;dZ@f9@fHsP@fH֡a@fD1&@fF@fJ:)y@fJ:)y@fNd7@fD1&@f@o h@fD1&@f=^5?}@fCGz@fQ+I@fNcA \@fGrGE8@fVQ@fXQ@f_
M;@fOƧ@fKߤ@fL$tT@fHF@fSoiDg@fQ)^	@f`p:~@fZe+@faa@@fdu%F@fZe+@fV4m@fUS@fR@fS-@fc6z@fhěT@feڹ@f_҉@fX6@feڹ@fdu%F@feڹ@feڹ@f`oiDg8@fga@N@fkڹZ@fg`A7L@fnQ@fr|@fyn.3@fosh@fe#@f\C\@fS@fURT`e@fe#@fkڹZ@fh@fg_o@fs;dZ@fym\@fs;dZ@fvzxl"@fVϫ@f|3@fqXe@fnPH@fuAs@fvzxl"@fp:@fkP|@fkP|@fyk~(@fsݗ+k@fy@f2a|@frGE9@fn@fK]@fOv`@f1@f1@f\(@f[@f@fe@fZc@f@f"`@fn@f0U2a|@fn@fiDg8@f@f?@f=p
@f̼j~@f̼j~@fh	ԕ@f>BZ@f?@fs@ft@f=p
@fo@fv_ح@fg8}@fg8}@f}Vl@f}Vl@fo@fȑN;@fg8}@f+@fo@f)^@feں@ftSM@fXbM@f-w1@f!-w2@f!-w2@f1@fӭB@fӭB@fXbM@f ѷ@f
=p@fo@fn.@fI^5?@f)^@fȴ9X@fH˒:@f,@fӬq@fڞ@fߤ@@f:S@fs@fs@fs@fGz@f^5?}@fVϪ@fe@fo@fn.@fe+a@fMj@f幌~($@fGz@f9XbN@f9XbN@f9XbN@fϪ͟@fQ@g Q@gl@f@f@fƧ@f幌~($@f@gC-@gFs@g@fƧ@fA [@gFs@gae@g*0U2@gp:~@g@f@fS@fS@g	a@@gae@g
\N@g҈@gm\@g*0U2@goiDg8@g	a@@ga@N@g҈@gDg8~@gR<6@gE@g}Vl@g}Vl@gR<6@gE@g	@gu%F@g	@g4֡b@g xF@g%A@g$5?|@g-@gE@g!n.3@g
qv@g
qv@g$5?|@g+&x@g!n.3@g&PH@g-C]@g,qi@g&PH@g"ѷX@g"ѷX@g2tj@g/P{@g,'RT@g2@g&PH@g$5?|@g,'RT@g2@g(_F@g|@g)\(@g,'RT@g%+j@g/P{@g7S@g=4J@g>O;@g;|@g2@g+&@g?C\@gOA [@g=33333@g)\(@g;dZ@g(_F@g:l"h	@g>@gD$/@gFC@g>@g4 ѷ@g2@g4 ѷ@gA]cA@g6A7K@g?C\@g>@g3zxl"h@gLz@gSjf@gBTɅ@g>@g:l"h	@gD$/@gKs@gI-V@gEeO@gFC,@g=33333@gEݗ@gM?@g>@g>ᰊ@gLy=c@gV1.@gLy=c@gI-V@gP
=q@gBn@g>ᰊ@gKs@gM?@gP
=q@gI-V@g:kP|@gD$xG@gTp:@gO@N@gBn@gLy=c@gP
=q@gW$@gP
=q@gM?@gSjf@gZ[6@g?rGE9@gEݗ@g_ᰉ@gexF]@g_ᰉ@gfۋq
@glhۋq@gb{@gV1&x@gO?|h@gR@g^YJ@gaMjO@gb{@gaMjO@gew1@gi@gew1@gZ[6@gew1@gi@gb ě@gi@glhۋq@gfڹY@gptj@gt@gwM:@gkS&@gq!.@gzK]c@g{1@gpS&@gd*0U@gew1@go/V@g{1@g.2@gwM:@glhۋq@gq+j@gwM:@gv ě@gsY|@gq+j@gwM:@g~u!@g}nP@gb@gwM:@gxfB@gzK]c@gvȴ@gfA@g<64@g~u%F
@gD@gXy=@gF]d@gحV@gwM:@gحV@gW@gU@gD@g{zH@gW@gD@g{zH@gfA@geO@g;5X@g	@ghr!@gF]d@gحV@g-
q@g@g	@gD@g>B@gXy=@gF]d@gW@ghr!@gQ@gsP@gsP@g@4@gW@g/V@gIQ@gbM@g:~ @gI^@g:~ @gIQ@gQ@g:~ @gsg@g:~ @g\(@gsg@g@gI^@gK]d@g>B@gY@g'/@g:@g+a@gY@g9@gIQ@gU=@gd7@g:@gY@g$/@gH@gU=@gH@gdZ@gU=@gVl!@g:@g䎊r@gH@g@@gm@gVl!@gVl!@gU=@g     @gfA@g\(@gVl!@g     @gH@g䎊q@gqiC@gqiC@gfA@g     @gm@g!R@gF]c@g@gqiC@g84֡@gce@g*0@gm@g     @g)_@g@g,<@g8Y@g,<@g
qu@gp
=@gF
L0@g!R@g)y@g@@gF
L0@gT`d@gƩ@gbM@g@@gfA@g~"@g73@gS@gط4m@g͛=K@gƩ@gbM@gS&@gƩ@gF
L0@g@@g~"@gط4m@gG{@gu@g҉@gط4m@g,<@g~"@g)^	@g҉@g҉@g}H@gbM@g73@gԌL_@gS&@gm\@g
qu@g
qu@g(@gض}Vm@g@ga@N@g6z@gض}Vm@g6C@g(@gض}Vm@gߨXy=@g҉@g}H@g#@gu%F@gD*@gc	@g҉@g}H@g-@gS&@g@g@gض}Vm@gS&@gض}Vm@g5Xy>@g@gڹZ@g'0@g'RT`@g#@g@g@g0
@g`A7L@g#@g|hs@g5Xy>@g5?|@gPH@gsh@gPH@g#@g#@gQ@g@g4m9@h
9Xb@h(@g	ԕ+@g'RT`@g|@gm\@gm\@g{m@g;dZ@h_F@h ~@gL/{@g`A7L@g'RT`@g`A@h33333@h'RT@g*0@gN;6@gL/{@g+j@g	ԕ+@h@h]cA@h@hl"h	@g4m9@gL/{@h
g	@hA7K@g+j@g+j@hp:@hC\@hC\@h
g	@hv@hTɅ@h	O;dZ@gm\@glC@gm\@h ѷ@h
g	@h	O;dZ@h
g	@h
g	@h]cA@hl"h	@h^5?|@hVϫ@h ѷ@h
g	@h@hϪ͞@h]cA@hl"h	@hu%@h
zxl"h@hp:@hl"h	@h33333@h"NU@h C,@hݗ@hݗ@hݗ@hn@h"NU@hK]@h
g	@hkP|@hn@h)@N@h'?@h$xG@h2a|@hᰊ@hݗ@h#-V@h"NU@h%s@h C,@h C,@h)@N@h)@N@h'?@h'?@h)@N@h-jf@h,_o @h#-V@h2a|@hkP|@hkP|@h'@h-jOv@h C,@h#-V@h01&x@h7"`B@h@ۋq
@h?xF]@h*S&@h#9@h'@h,@h'@h-jOv@h.͞&@h8YJ@h?xF]@h274@h'@h274@h?w1@hB>BZc@h9ᰉ@h4Zc@h5vȴ9@h5H˒@h)?|h@h01&x@h*S&@h,n@h9rG@h;L_@h@ڹY@h;L_@h-iDg8@h9rG@hFhۋq@hB>BZc@hB>BZc@h9rG@h8ݘ@hB>BZc@h< ě@h< ě@h5vȴ9@hB>BZc@hFhۋq@h< ě@hFhۋq@h?w1@h8ݘ@hJS&@hK+j@h>*0U@h?w1@h?w1@hEo i@hB>BZc@hFh	ԕ@hFh	ԕ@hC	k@hP ě@hMY|@h?w1@h?v_ح@h-iDg8@h< ě@hU1@hJS&@h@>B[@hK+j@hI/w@hP ě@hRfB@hI/w@h>s@hMY|@hU1@hN<64@hG˒:)@hC	k@h8?@hEo i@h[<64@h>s@h7!-w1@hFh	ԕ@hXu!@hN<64@hWu@h^F]d@h`W@h\vȴ@hQ{J#:@hEo i@hI/w@hR@h_fA@hb-
q@hP䎊@hJN;@hQ{J#:@hdD@hchr!@h[<64@h_fA@h\vȴ@hb-
q@h_fA@hYحV@h^F]d@h\vȴ@hWu@hchr!@hchr!@h\vȴ@hchr!@hmJ#9@hi	@h\vȴ@h[<64@hb-
q@hchr!@hYحV@hYحV@h^F]d@h^F]d@h\vȴ@hYحV@hb-
q@h_fA@hXu%F
@hb-
q@hg/V@h^u%F@hc@hc@h`W@h`Ʌoi@h_eں@hY@h\쿱[@hc@hiQ@hg/V@hd!-w@hiQ@hc@hg/V@hg/V@hmIQ@hiQ@hW)^@h^u%F@hmH˒:@hb-V@hd!-w@hn1&@hke@hd!-w@hb-V@h`Ʌoi@hc@hn1&@hxd7@h}䎊r@hxd7@hu-V@hr֡a@hqsPH@ht:)y@hp@h\쿱[@hUB@hd!-w@h{+a@hp@hke@hmH˒:@hqsPH@hp@hn1&@ht:)y@hqsPH@hu-V@h{+a@h}H@hVl!@hw:@hxd7@h4m@hqsPH@hr֡a@ht:)y@hn1&@hn1&@hr֡a@h}s@h1'@hGE85@h|qj@hi,@hfVϪ@h|qj@hqiC@h}s@hyy@h{+I@hrϪ͟@hyy@h1'@hGE85@h}s@h1'@h#x@h1'@h1'@h}s@h
M;@h84֡@h8}H@hGE85@hZ@h
M;@h.H@h8}H@h|qj@hq@hS@hTɅo@h}s@h
M;@h.H@h?@hO;d@h
M;@hQ@hb}@hTɅo@hq@h.H@hԕ*@hS@hm\@hX@hD@hm\@h
M;@hS@h~($@hSMj@hm\@h8}H@hb}@ha@@h(\@hae@hm\@hE84@h6C@ho@hᰉ'@hE84@hᰉ'@hae@h7KƧ@h@ha@@hae@h(\@h@hQ@h|@h~($x@hE84@h7KƧ@h*0U2@hSMj@ha@@ha@@h~($@h~($@hX@h~($@hE@h@h~($@hae@hm\@h@hSMj@hm\@hp:~@h\N@hm\@hae@h(\@h(\@h@hSMj@hSMj@h@h@hTɆ@hkP@hE84@hSMj@h@h,<@h4֡b@h@h~($@h@h7KƧ@h~($@h64@hR<6@h(\@hm\@hE@hae@ha@@ha@@h,<@h~($@hxF@hm\@h(\@h($x@h(\@h,<@h,<@ha@N@h\N@hڹ@h($x@hq@ha@@ha@@h4֡b@hE@h64@hR<6@hE@hěT@h(\@h_p@h_p@hu@hS@hR<6@hq@h@h6z@h*0U2@hu%F@h_p@hěT@hq@hE@hoiDg8@h@hoiDg8@h~$@h}Vl@ho hی@hDg8~@h@hG{@hěT@hu%F@hu%F@hD*@hG{@h}-@h҉@ha@N@hěT@hěT@hěT@hڹ@h($x@h($x@ha@N@hěT@hěT@h($x@h}Vl@hPH@h@hG{@h}-@h@ha@N@ha@N@hu%F@hěT@hq@h6z@ha@N@hڹ@h6z@hc	@h@h#@ha@N@hڹZ@hڹZ@hQ@hڹZ@hc	@hsh@h@hD*@h0
@h@h@hQ@h@h|@hC%@h'RT`@h'RT`@h`A7L@hc	@h|@he+@h|hs@h`A7L@h0
@h#@hc	@h}H@h&@hsh@hsh@hڹZ@hڹZ@hQ@hC\@h'0@hڹZ@h@h5Xy>@hc	@hC\@h#@h#@h`A7L@hB@h4m9@h
qv@hQ@h#@h@h0
@hQ@hL/{@hsh@h3@h'RT`@h#@h5Xy>@h0
@hRT`e@h&@hhr@h'0@h'0@h_o@h7@h7@h7@h0
@h&IR@h_@hC\@hnO@hlD@hhr@hhr@h&IR@he+@h|hs@hN;6@h4֡a@hhr@h{m@h;dZ@h4m9@hN;6@hߤ?@h}C]@h?@htj@hN;6@h_@h3@hQ_@hB@hQ_@h4֡a@h4֡a@hN;6@h_o@h_@htj@h&IR@hN;6@hya@O@hC,zx@hQ_@h3@h|Q@hN;6@hlD@h_o@h(@h|qi@h
=p@h7@h4֡a@hߤ?@h|qi@hQ@h
=p@h_o@h4֡a@h_@hߤ?@h|Q@htj@h(@h|qi@huA@hqn.3@h|qi@hya@O@hqn.3@huA@hx_ح@h|qi@h|qi@hmC%@ht5?|@h{&x@hߤ?@htj@h|qi@huA@hrѷX@hrѷX@hvPH@h|qi@hQ@hvPH@hrѷX@huA@htj@hߤ?@ht5?|@hn@hj|@hp
L/@hx_ح@h{&x@hP{@hya@O@hvPH@hvPH@h'@huA@hya@O@h|qi@hrѷX@hqn.3@hj|@ht5?|@hvPH@h|qi@hvPH@hvPH@hx_ح@h}C]@hQ@h{&x@hk
qv@hqn.3@h|Q@ht5?|@huA@hmC%@hp
L/@h}C]@h'@h҈p@h}C]@hiPH@hp
L/@huA@h|Q@hQ@hQ@hvPH@hrѷX@ht5?|@h}C]@huA@huA@h
=p@h|qi@h|qi@hqn.3@h{&x@hQ@hQ@h}C]@h|qi@hmC%@h@h}C]@hqn.3@hqn.3@huA@hya@O@huA@hqn.3@hj|@h|qi@h{&x@hya@O@h|Q@hQ@hQ@hQ@h|Q@h9Xb@hQ@hvPH@h}C]@htj@hQ@hmC%@hrѷX@ht5?|@h'@h|Q@hya@O@hp
L/@huA@h'@htj@hvPH@huA@hdc	@hvPH@hx_ح@h{&x@h{&x@hQ@hx_ح@h|qi@hvPH@hya@O@hp
L/@huA@huA@huA@hqn.3@hvPH@hx_ح@hx_ح@ht5?|@h{&x@hx_ح@h}C]@hrѷX@hn@ht5?|@h|qi@hqn.3@huA@hqn.3@hya@O@hrѷX@huA@hya@O@hx_ح@huA@h'@h@h'@hQ@hn@hߤ?                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ?fA?a@N?sP?9XbM?N;5??<64??<64?8YJ?+?@NU?=K^?1?nO;?҈?zG{?>6z?'/W?)y?-
?쿱[W?)_?
(?\(?iB?.H?oiDg8?d7?)_?t?W&?@4m?d7?Ëq?Ģ3?6z?@4m?Vu?S?
(?Ǥ??Ȑ-
q?tj?"`A??2W?̘_F?.2X?|??й#w?ЭU=?Гtj~?Q?1&?}H?5Xy>?&IR?6?$tS?ԑN;6?:S?zG{?՗+j?C$?ՅoiDg?ֶ}Vl?y(?Xy=c?0
(?˒:)z?S&?ڮ}Vl?Xe+?ލ?ae?˒:)?nP?
qu?⩓?&x?($xG?b}Vm?A [7?!R<?_o?m\?D?E?掊qi?
M:?!R<6?L/{J?g	?xl"h	?rGE?sg?fA?׈eO?Q_?s?Ӭq?xl"h	?_o ??ΗO;d?ˈeO?Q_?䎊?ǮzG?{m??Vl!-?Vl!-?Fs?Z?c	?U=?YJ?	 ѷ?³g	l?W'?	 ?xl"h	?	ԕ*?PH?m?g	l?Y|?n/?o ?%1?      ?,<쿱?@?}H˒?bM?-V?C?,<?73?E?|??䎊q? ѷX?Ϫ͞?=K^?Ϫ͞????%2??e+?sg?PH?-
qv?:)y?C*0U2a?!-w1?S&?+*6C-?tn?`bM?Z?*0?-
qv?@NU?*0?#?+I?u"?ᰉ'?ᰉ'?=K]?쿱[W??쿱[W??wkP?Ϫ͞?,<?pbM?sg?Zݘ?bM?Fs?Ϫ͞?Fs?tj~ۿku%F?rnO;?~Ov_ح?~Ov_ح?M}H˒?fOv_خ?%2?S?N;5?n/?p)^	?pbM?=K^?$/?ae?!-w1?-V?u"a4J?|??$tSM?4J?@NU?Ϫ͞?vOv_خrn/?{qu!S?Z?bM?ku%F:6C-?~Ov_ح?!-w1?$tS?!-w1?zG{?>B?S*0U2a?Xe?sPHF?pbM?z6C-?|??S?,<?Rn/?6C-?L_??	 ?-
qv?A?<64?|1&y?{qu!S?a@N?sPH?},<?xtj~?-
qv?䎊r?ᰉ'?ᰉ'?쿱[W??dzG{?bM?E?kP{?=K]̿6C-?o!-w1ſXtj~?{Q_?S&?u"?{qu!S?!-w1?!-w1?{Q_3*0U2a?w?)^	?hr Ĝ?kP{?qu!S?%2?L_3*0U2a?wkP?&?Rn/?*0?R<64?cA \?*0?)^	?l?Z6C-?Ov_خ?Ov_ح?䎊q?*0?>BZc?u"?@bM?-
qv?l!-w?fǿc*0U2a?S&?L_?&?wXe+Կp)^	?},<?sPH?u!??ye+a?wXe+?~Ov_ح?@bM?:6C-?Z6C-l1&y?n/?q?y=b?Q_?zG{?Q?tzG{?rnO;{qu!SnOv_ح?:)y?*0U2a?4J?bM?4J?Q?Z?	 ?R<64?䎊q޿VǿrsPH?@bM?Z?sg?|C,zxl?=K]?hr Ĝ?vOv_خ?Rn/?$?q??-V?Fs?ɅoiD?6?[Q_?q4J?
=p
?qu!S?	 ?wXe+ԿJ6C-?`bM?Xtj~???dzG{?bM?L_?=K^?ndzG{?xPH?bM?zvȴ9?tZ?	 ?Xtj~?ku%F?x*0
?Rn/usg?*6C-?N;5?tZbn/?|C,zxl?~Q?)^	?usgj6C-?H?Mj?S&?Q?*0?+J?`A7L?v+I?:6C-        ?|1&y?,<?e+absPH?N;5?_o ?S&?-
qv?6?u%?ZRn/?-V?nc*0U2a?n?x*0
?~Q?zG{V?+I?2a|Q?䎊r?䎊q?tj~?Fs?҈οpbM?q4JfOv_خ?u%?fA?`d8?Ϫ͞?Q_?,<?n/?qu"?u%?!-w1?+I?U=KnOv_حo!-w1ſpbM?x*0
?w??S&?ᰉ'?Ϫ͞?@?zvȴ9?!-w1?_!-w1?	 ?$/S*0U2a?{u%F?w?v+IbsPH?{u%F?~Q?n/?-
qvZ6C-?H?F?o!-w1?bM?F?}Z?S&?4J?u%F?A??L_?n/?v+Irn/?x*0
?!-w1?)^	f?s@NU?zvȴ9?~Q?hr Ĝ?+I?{Q_?{qu!S?_o ?-V?s@NU?tzG{?z6C-?l1&yz6C-?*6C-?tj~?xtj~?{qu!S?uL_?xtj~?{Q_3*0U2a?g?z6C-?ߤ??qu!S?,<?H?	 ?e+a?#?:)y?zvȴ9?₿rnO;?qu"?zvȴ9fOv_خ?*0U2?Z?u%F?Q?PH?@?)^	?PbM?$tSM?U=K?o!-w1ſXtj~?zvȴ9?҈?$tS?z6C-qu"kQ_?N;5?tj~ۿc*0U2a?j6C-?{qu!S?|1&y?vȴ9X?N;5?ye+a?ᰉ'?6C-?3*0U2a?},<?*0U2a?Mj?sg?䎊reL_?tnC*0U2a?fǿeL_?bsPH?v?hr Ĝ?wkP?!-w1?xtj~?zG{?Zݘ?sPH?PH?u"?hr Ĝ?N;5?+?Z?sg?҈ο_!-w1?tj~?6C-?䎊q?U=K?kQ_?v?nO;kQ_rnO;        ?e+a?4J?L_?@NU?@NU?L_?zG{?tj~?tzG{?zvȴ9?l?*0U2a?u"?Xe+?u%?Q?wXe+?xtj~?{Q_?䎊q?n?$/?Xe?~Q?	 ?tj~?:)y?	 ?p:?tj~ۿRn/q4J?IQ?Xtj~?htj~?e+a?$tSM        ?bn/?Rn/?l!-w?"`A?x*0
ku%F?tzG{usgrn/q4Jp)^	?}H˒?$/?S&?Zݘ?bM6C-?eL_?`d8?AfOv_خ?@NU?Fs?fA?Z?<64q4J?tzG{?xPHf?o䎊q??_o?},<V?bM?~Ov_ح?tzG{?n/?%2uL_?pbM?x*0
??,<쿱?O
M?|C,zxl?z6C-_!-w1?l1&y?y_o ?|1&y?}}H˒?@bMvOv_خ?o䎊q?
=p
?O
M?ie+a?Qs@NUqu"?w?usghtj~?:)y?Fs?n?Fs?N;5X?z6C-?@bM?v+I?+I?fA?$/?L_?쿱[W?eL_?*0U2S*0U2a?&?~Ov_ح?n/?ɅoiD*6C-?PH?O
MUL_M}H˒?6C-*6C-?u%F
?2a|Q?-
qv?ᰉ'?l?䎊q?s@NU}}H˒?f?p)^	?v+I?l!-w?A?tj~?rnO;@bM?j6C-?y_o ?xPH?R<64?	 ?@NU?Q?xtj~?}}H˒?n/~Ov_حbM)^	?kQ_tZ?_Ft?zG{?Ov_خ?tzG{?u%F?wkP?@?!-w1?@?䎊q?htj~m}H˒?rsPHusg?wXe+?XernO;-
qvy_o ?S?ɅoiD?M}H˒?*0U2a?6C-?dzG{        zvȴ9?M}H˒?Q_!-w1?u"?tn?bn/~Ov_ح?J6C-?dzG{tn?6C-rn/dzG{?e+a?n?rsPH?rnO;?rnO;?usg?@NU?*0U2a?N;5X{qu!S?rnO;?y_o ?q4JvOv_خ?S*0U2ahtj~?_Ft?C*0U2a?~Ov_ح?qu"?:6C-?rn/?IQ?u%F
?A?Ov_خ?v+I?|??q4J~Q?l1&y?p:`bM},<?ku%F?qu"?gm}H˒C*0U2a?qu"?Z6C-?htj~bn/tzG{S*0U2ahtj~?bsPHXtj~?!-w1ſ|C,zxl{Q_?zvȴ9?T`d?rsPH?o!-w1ſhtj~??p)^	?N;5X?_Ft?L_?[Q_?pbMhtj~?3*0U2aPbM₿-
qv?qu"?zG{?:)y?x*0
?4J?z6C-?w?`d8?Z:6C-?vȴ9X?zG{?Ϫ͞?*0?*0?v?bM?*0?R<64?C*0U2a?U=K?[Q_c*0U2a?`A7L?x*0
?߿zvȴ9?m}H˒?xPH?u%tZ*6C-rn/]}H˒@bM?{qu!S?쿱[W??ye+a6C-x*0
|C,zxl},<s*0U2a?rsPH?p)^	tZ{u%FvOv_خ?u%F
?xPH?ie+a?%2?M}H˒hr Ĝ?Xtj~?wkP?V?:)y?bM?pbM?o!-w1?y_o ?`A7LtzG{|C,zxl?_!-w1?f?rnO;?	 ?+I?}H˒?eL_u"?wXe+?}H˒?tn?s@NU?tzG{?`bM?w?{Q_?p:o䎊q?rsPH?tj~?fA?a@N?htj~?x*0
?=K]?Rn/?N;5?҈οV?zvȴ9?s@NUbn/?wXe+?kQ_zvȴ9?!-w1ſnOv_ح?|??ɅoiD?Fs?o!-w1?n/?V?xPH?ᰉ'3*0U2ac*0U2a?rnO;?Xtj~vǿws*0U2a?nOv_ح~Q?o䎊q?grnO;?l1&y?s@NUc*0U2a*6C-?kP{?zG{?E?Ov_ح?Ov_خ?PHnOv_ح?dzG{?wXe+?l1&y?s@NU?w?{qu!S?{Q_??*0U2a?qu"?zvȴ9?{u%F?u!?v+Is@NUf?w?bM?zvȴ9?xPH?tn?	 ??xPH?ye+a?-
qv?w?{Q_?zvȴ9?},<?{Q_?s*0U2a?xtj~?]}H˒nOv_ح?҈?qu!S?*6C-?O
M?zG{?`d8?usg?N;5?|1&y?{qu!S?vOv_خ?rnO;bsPH6C-?zvȴ9??n?Fs?`A7L?vOv_خ?}}H˒?,<쿱?Mj?ye+a?o䎊q?v?{qu!S?hr Ĝ?O
M?]}H˒wXe+?Z6C-?Q_?ߤ??u%F?	 ?bn/Xtj~?{qu!S?v+I?tzG{?pbM?p:Xtj~₿qu"?&?~Ov_ح?UL_?M}H˒?dzG{?Xtj~q4J?~Ov_ح?c	?`A7L?sPH?p:?xtj~?j6C-pbM?+?IQ?n?N;5XC*0U2a?htj~?qu"bsPH?]}H˒?htj~f?M}H˒?zvȴ9?tZ?PbMrn/?ie+ag?usg?rsPH?zG{?fA?a@NS*0U2a?qu"?H?Z6C-w?UL_?vOv_خ?V?zvȴ9?+I?kQ_?=K]̿usgRn/?l?~QkQ_wXe+Կ~Ov_ح?`bM?_o?E?&?kQ_?|1&y?*0
?rsPH?qu":6C-eL_?fOv_خj6C-?vOv_خ?S&?vǿie+a?$tS?4Ja4JrsPH?0
(?PH?}}H˒?zvȴ9?}Z??zG{?PHZ6C-?gwXe+?s*0U2a?z6C-??}Z?|C,zxl?{Q_?ye+a?usg?~Ov_ح?{qu!S?)^	?kP{?Q?zvȴ9?kQ_eL_?rnO;j6C-?rn/?s@NU?xPH?$tS?,<?e+a?zvȴ9j6C-?Rn/        @bM?tZ?tj~?U=?L_?rsPH?wXe+?tzG{?kQ_rsPHqu"?-
qv?҈?xPHie+aye+a?*6C-j6C-?v?IQ??ߤ??nOv_ح?}}H˒?:)y?tn?`bM?fOv_خrsPH?ie+ax*0
?fǿ_!-w1?UL_j6C-C*0U2a?[Q_x*0
?{u%F?!-w1?hr Ĝ?l?u%F!-w1ſye+as@NUrnO;?tzG{?l?@NU        ?Rn/Z6C-vOv_خ?n/?ߤ??{qu!S?a4Jie+a?|C,zxl?䎊q޿M}H˒?߿qu"rnO;?Xe+?bsPH?kQ_?y_o ?hr Ĝ?~Q?!-w1?},<?ߤ??Ov_ح?A?{?bsPH4Jg?rn/tzG{?bM?n?L_?{u%F?xtj~?*0U2?zG{?ߤ??u"tzG{?v?x*0
?Xtj~?o!-w1?htj~?a4J?fOv_خ{u%Fzvȴ9?ku%F?l?!-w1ſXtj~?Ov_خ?_FtZ6C-xtj~UL_?tn?}H˒?R<64?qu"rn/l1&y?{u%F?zvȴ9?wXe+?T`d?n/c*0U2a?tj~?nF?PbM?@bM?w?E?쿱[W??{Q_?xtj~?fǿs@NU?z6C-?usg?~Q?*0U2a?n?sPH3*0U2arnO;?u%F
?O;dZ?*0U2?Z?y_o UL_        ?nOv_حfǿ!-w1ſUL_?nOv_ح?bn/?|1&y?쿱[W?}}H˒rsPH?uL_?xPH?ye+atzG{?]}H˒?xPHZ6C-?:6C-?rsPH??	 ҿC*0U2a?3*0U2ahtj~?p)^	?ye+a?{Q_?s@NU?uL_?usg?tzG{?uL_`bMwXe+Կs*0U2a?u!?f?tn?PH?usg?rsPH?tn?L_?!-w1ſrn/?Z6C-?rnO;?$/qu"?Q?:6C-tn?eL_?w?䎊q?V?qu"?:6C-c*0U2a?rsPH?ie+as*0U2atZ?uL_?z6C-??{Q_?w?v+I?_o?*0??tzG{?y_o ?3*0U2azvȴ9f?pbM?`bM?tZ?*0U2?~Ov_ح?rsPH?p)^	?qu"?tzG{?tzG{?u%?҈?s@NU?_o ?j6C-eL_?g?{qu!S?ݗ+j?ݗ+j?zG{?*0?lo!-w1?nOv_ح|1&y?ku%F?w?Q?*0?nOv_حy_o rsPHbn/?_!-w1?j6C-?,<쿱?wkPtZ?v?ye+a?n?MjPbM{Q_?3*0U2a?{qu!S?U=K?_o ?s@NU?0
(?Q_?c*0U2al1&y?hr Ĝ?D*0?hr Ĝ?bsPH|C,zxl?s*0U2a?$tS_!-w1?u!?S&?usgPbMwXe+Կz6C-s*0U2aPbM?ye+a?a4Jxtj~~Ov_حpbM?bsPH?ie+atn?s*0U2anOv_حww?M}H˒?ߤ??rsPH?$tSM?+J?ᰉ'?u%Fie+a?|1&y?u"?Z6C-}}H˒)^	~Q?a4Jv+Itj~?+I?:6C-?C*0U2a?x*0
Xtj~)^	kQ_?u"?@        ?UL_tzG{?a4Jzvȴ9v?`bM?usgs*0U2a?o!-w1?S?*0U2a?vȴ9@bMXtj~C*0U2arnO;?:)y?zG{?ݗ+j?!-w1?@NU?)^	?p)^	?nO;?zG{?eL_?Z6C-?wkP?O
M?u!?`bMvǿhtj~?:)y?nO;?~Ov_ح?l?`d8?	 ҿrnO;|1&y?M}H˒l1&y?ie+a@bM[Q_?xtj~?rn/?xPH?V?tZ?$?o䎊q޿J6C-?~Q?usg?n/?Z?nO;?}}H˒?	 ?Zݘ?M}H˒?kQ_?zvȴ9?y_o ?z6C-?IQ?fA?ᰉ'?fA?tj~`bM?wXe+Կo䎊q޿c*0U2a?rsPHpbM?U=KM}H˒?*0U2?S*0U2a?eL_3*0U2auL_6C-?,<?L_?S&?uL_?@bM?2a|Q?e+ÿ`bMku%F?s*0U2apbM?j6C-?$tS?n@bM?$tS?}}H˒Xtj~?v?y_o ?Fs?䎊r??u"?ݗ+j?~Ov_ح?v+I?z6C-?s@NUj6C-x*0
?htj~?},<S*0U2ao䎊q޿tzG{J6C-?nO;?~Ov_ح?-
qv?x*0
?w?rnO;?w?{qu!S?-
qv?~Ov_حZ6C-?pbMVǿq4J?!-w1?Ϫ͞?*0@bM?UL_m}H˒?y_o ?)^	?&?bM?pbMvOv_خ?Q_?N;5?4J?u%F
?v?z6C-?qu!S?$/?wkP?},<?fOv_خdzG{?y_o ?4J?ݗ+j?z6C-j6C-?s*0U2a?ݗ?ᰉ'?)^	??y_o ?}}H˒?~Ov_ح?{Q_?|1&y?}Z?O
M?u"?q4JUL_?bMs@NU?Zݘ?4J???o!-w1?A?z6C-?{qu!S?sg?vȴ9X?ye+a?uL_?ie+a]}H˒?zvȴ9l1&yo!-w1?v+I]}H˒?H?$/?tj?Z?H?_o ?u%F?v?{u%F?z6C-?{Q_?~Q?o䎊q޿wXe+Կtn?sPH??zvȴ9?nO;?sg?䎊r?e+a?s*0U2a?y_o ?kP{?n/S*0U2a?f?bsPH?zG{?m}H˒?Fs?L_?Fs?}Z?},<?N;5?N;5X?PbM?o䎊q?Zrn/?	 ?ɅoiD?$/?L_?,<?$tS?~Q?wnOv_ح?bsPH        ?*0?`bM?Q_?]}H˒?PbM`bM?u%F
?rsPHRn/?@NUUL_a4J?x*0
m}H˒?S*0U2a?*0
?]}H˒?qu"?fǿpbM?w?v?S&?SٿxPHv+I?sPH?$tSM?wkP?fA?pbM?zvȴ9?쿱[W??bsPH?tzG{tno䎊q?_Ft?V?}Z?<64?4J?@NU?sPH?҈p:?xtj~?~Ov_ح?tj~?	 ?xPH?쿱[W?        ?vȴ9?sgwXe+ԿZ6C-]}H˒?|1&y?wkP?-
qv?@bM?+I                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    &+B!33@$z3; 36                                      1                                       