CDF       
      time      pressure  #   latitude      	longitude         string_dimension   (         EXPOCODE      29AJ20160818   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    WOCE_ID       TAlPro     	DATA_TYPE         WOCE CTD   STATION_NUMBER        30     CAST_NUMBER       1      BOTTOM_DEPTH_METERS          
Creation_Time         2020-03-19T19:50:21.153764Z    ORIGINAL_HEADER      CTD,20200319CCHSIO
# Converted CTDOXY from ML/L to UMOL/KG using the following:
#     https://github.com/TEOS-10/GSW-Python, downloaded 2019-06-26
#     gsw.sigma0:  Calculates potential density anomaly with reference pressure of 0
#     dbar, this being this particular potential density minus 1000 kg/m^3.
#     This function has inputs of Absolute Salinity and Conservative
#     Temperature.  This function uses the computationally-efficient
#     75-term expression for specific volume in terms of SA, CT
#     and p (Roquet et al., 2015).
#     http://www.teos-10.org/pubs/gsw/html/gsw_sigma0.html 
#     Python equation used:
#         oxy_UMOL_per_KG = oxy_ML_per_L * 44.660 / ( (1000 +  gsw.sigma0(SA,CT)) / 1000. ) 
# Data source:  https://doi.pangaea.de/10.1594/PANGAEA.902330
# SHIP: RV Angeles Alvarino
# Cruise: MedSHIP cruise TalPro
# Region: Mediterranean Sea and Catalan Basin
# Ports: Palermo, Italy to Barcelona, Spain
# DATES: 20160818 - 20160829
# Chief Scientist: L.Jullion
# 43 stations
# Original file in AWI format. CCHDO Converted to Exchange format
# EVENT_CODE=unknown
# DATE: YYYYMMDD
# TIME: HHMM
# LATITUDE: degrees_North
# LONGITUDE: degrees_East
# STNNBR:  removed leading 0s from STNNBR
# CASTNO: not supplied by originator - CCHDO assigned all CASTNO=1 or CASTNO=2 for stations 11, 29
# CTDSAL: changed units from Practical to PSS-78.  Data values remain unchanged.
# CTDFLUOR: changed units from UG/L to MG/M3 as they are they are equivalent
# CCHDO added flags=2 for all parameters, as T.Tanhua notes all params are calibrated and CTDOXY calibrated with bottle samples
# Removed two test sample depths from event/station 004, dTalpro_Stn04_test_1db
# Data precision preserved as submitted.
# CTD: Who - T.Tanhua; Status - calibrated,final
#     Includes: CTDSAL, CTDOXY
#     CTDTMP NOTE: Used first occurrence of primary temperature sensor in original data file
#     CTDSAL NOTE: Used first occurrence of primary salinity sensor in original data
#     NOTE: Physical parameters temperature, salinity, oxygen, density, turbidity, chlorophyll, fluorescence are published on PANGAEA, DOI above.
# Fluorescence (CTDFLUOR): Who - T.Tanhua; Status -final
#        Instrument: WET Labs ECO-AFL/FL, FLNTURTD-2526
#        ScaleFactor: 1.00000000e+001
#        Dark Output: 0.0760
# Turbidity (CTDTURBDTY): Who - T.Tanhua; Status - final
#        Instrument: FLNTURTD-2526
#        ScaleFactor: 5.000000
#        Dark output Voltage: 0.070000
#
# Reference: Cruise report: https://epic.awi.de/id/eprint/49725/1/TAlPro_EUROFLEETS_cruise_report_V2.pdf
# CCHDO page: https://cchdo.ucsd.edu/cruise/29AJ20160818
# Metadata from original file
#     Event(s):     TAlPro-2016_030 (30) * LATITUDE: 42.180000 * LONGITUDE: 4.170000 * DATE/TIME: 2016-08-25T20:33:00 * CAMPAIGN: TAlPro-2016 * BASIS: Angeles Alvarino (URI: http://www.eurofleets.eu/np4/285.html) * DEVICE: CTD/Rosette (CTD-RO)
#     Citation: Tanhua, Toste (2019): Physical oceanography during MedSHIP cruise Talpro. PANGAEA, https://doi.org/10.1594/PANGAEA.902330
#     Abstract: The TAlPro cruise (Palermo - Barcelona, RV Angeles AlvariÃ±o, 18/-8/2016 - 29/08/2-16) occupied three hydrographic transects across the Tyrrhenian Sea, the western Mediterranean Sea and the Catalan Basin (Fig. 1) as part of the MedSHIP programme (Mediterranean Ship-based Hydrographic Investigations Program). A total of 43 stations were occupied during which physical (temperature, salinity, pressure, velocity), biogeochemical (oxygen, nutrients, carbonate system, dissolved Barium, oxygen and nitrogen isotopes) and anthropic (CFCs, SF6) parameters were measured in order to monitor the physical and biogeochemical state of the Mediterranean Sea.
#     Related to: Jullion, Loic (2016): TAlPro-2016: A Tyrrhenian Sea & Alger- provencal component of the MedSHIP Programme. hdl:10013/epic.5a866780-1f8a-45cf-8111-47b2b5dc29db
#     Parameter(s):
#         Event label (Event) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Sample code/label (Sample label) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Date/Time of event (Date/Time) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Latitude of event (Latitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Longitude of event (Longitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Pressure, water [dbar] (Press) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Digiquartz
#         Temperature, water [Â°C] (Temp) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: ITS-90
#         Oxygen, dissolved [ml/l] (DO) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 43
#         Turbidity (Nephelometric turbidity unit) [NTU] (Turbidity) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO
#         Fluorescence, chlorophyll [Âµg/l] (Fluores) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO-AFL/FL
#         Salinity (Sal) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Practical
#     License: Creative Commons Attribution 4.0 International (CC-BY-4.0)
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            pressure               	long_name         pressure   positive      down   units         decibar    data_min      @         data_max      @        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      9  '   pressure_QC                	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      H  `(   temperature                	long_name         temperature    units         ?C (ITS-90)    data_min      @*:C\   data_max      @7ݗ+k   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       9  np   temperature_QC                 	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      H     salinity               	long_name         salinity   units         PSS-78     data_min      @C)@N   data_max      @CJ-V   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      9     salinity_QC                	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      H     oxygen                 	long_name         oxygen     units         ?mol/kg    data_min      @ew"`B   data_max      @rU=   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        9  0   	oxygen_QC                  	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      H 6H   CTDFLUOR               	long_name         CTDFLUOR   units         MG/M^3     data_min      6C-   data_max      ?eO
   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      9 D   CTDFLUOR_QC                	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      H }   	CTDTRBDTY                  	long_name         	CTDTRBDTY      units         NTU    data_min      ?   data_max      ?ə   C_format      %f     WHPO_Variable_Name        	CTDTRBDTY      OBS_QC_VARIABLE       CTDTRBDTY_QC     9    CTDTRBDTY_QC               	long_name         CTDTRBDTY_QC_flag      units         
woce_flags     C_format      %1d      H    time                	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      &%   data_max      &%   C_format      %10d       P   latitude               	long_name         latitude   units         	degrees_N      data_min      @E
=p   data_max      @E
=p   C_format      %9.4f          T   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      @zG   data_max      @zG   C_format      %9.4f          X   	woce_date                   	long_name         	WOCE date      units         yyyymmdd UTC   data_min      39   data_max      39   C_format      %8d        \   	woce_time                   	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d        `   station                	long_name         STATION    units         unspecified    C_format      %s        ( d   cast               	long_name         CAST   units         unspecified    C_format      %s        ( ӌ@      @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        @7ݗ+k@7B@4@7,"h	ԕ@7ߤ?@6秆&@6{J#9@6Mj@6@6N;@6&IR@6>BZ@6~1@6uF
L0@6mM:@6d֡a@6M(@6;s@6.!R<@6$@6&@55?|@54J@5iB@5v@5J@4~($@3[$@1
qu@1lC@1SZ@0m]@0U1@0)rGE8@/p$tT@.@.@.K]d@.QN;5@.'@@.=K^@-ؓtj@-lq@->vȴ9X@- [6@,!.I@,@,=b@,H˒@,%F
L@,@,U'0@,1-@,(K]c@,j~#@+1'@+Ƨ@+K]c@+e+a@+[W?@+$/@+
(@+Z@+^5?|@+4֡a@+%1@+@+}cA @+}/w@+y~($@+v!.I@+nqi@+a$/@+\(\@+Y"`@+Sݗ+k@+J~"@+Gy@+De@+C@+DM:@+Bh	ԕ@+A@+@u!@+;/V@+7O;d@+3@N@+0
(@+-%@+,VϪ@++a@@+*W'@+(eO@+&
L/@+!@+U=@+>B@+3@+SMj@+@+a@O@+u!S@+As@+_@+a@@+	k~(@+eO@+M:@+`A@+o@+ n@*҈p;@*H˒@*W>6z@*^5?|@*fA@*@*C%@*$/@*S&@*%2@*h	ԕ@*@4@*߱[W>@*~$@*ڒS&@*ڟvȴ@*Q_@*=b@*l"h	@*sPH@*Վ!R@*Z@*䎊@*т@*_p@*{@*N;5@*[W>6@*bM@*O
M@*Mj@*ΤT@*!R<@*͑hr!@*\@*̥zxl"@*˹~($@*xF]@*a@@*.2@*_o @*!-w@*˅Q@*Dg8~@*Xy=@*ǮzH@*żn/@*e@*u@*F
L0@*zxl"h@*S@*Fs@*lC@*ǆ&@*TɅ@*D@*p:~@*"h	ԕ@*+I@*^@*Fs@*֡a@*Z@*ԕ*1@*䎊@*iDg8@*t@*t@*!R<@*cA \@*@*ϐ@*т@*ҕᰊ@*L_@*KƧ@*#w@*JE@*@*ֻ@*H˒:@*U=@*@*Fs@*zG@*!-w2@*'0@*$tS@*}H@*rG@*O;d@*Q@*_F@*y=c@*Q@*_F@*+@*$/@*m8@*sh@*!-w2@*_@*/V@*zxl"h@*㕁$@*.H@*ᰉ'R@*҈p;@*Vl!@*<64@*hr@*]ce@*W>6z@*6C@*٦(@*=b@*4֡b@*PH@*PH@*F@*ؠ-
@*؆YJ@*غ)@*#w@*0
)@*0
)@*XbM@*b}@*ڟvȴ@*/V@*cA @*F]c@*\N@*㕁$@*F
L0@*,zxl@*\(@*e+@*R<6@*ⶮ}Vm@*M:@*x@*ᰉ'@*U=@*I^5?@*:@*@*}Vl@*t@*(@*C\@*zG@*}Vl@*qi@*.2@*@*_@*O;dZ@*'/W@*
M;@*ߤ?@*2X@*T@*}Vl@*B@*cA \@*L_@*1&y@*빌~($@*xF]@*'/@*n@*qiC@*@*zH@*ڹ@*Q@*?@*@*@4@*o hی@*\N<@*ߤ@@*Z@*m\@*,=@*K]@*hr@*j~#@*C,zx@*Q@*lC@*Q@*(\@*!.H@*E@*\N<@*쿱[W@*H˒:@*U=@*b}V@*b}V@*BZc @*ܞ쿱[@*6C@*Xe,@*՛=K@*Ʌoi@*T`d@*iDg8@*ΤT@*4֡a@*ѩl@*n@*a|Q@*a|Q@*GE85@*яo@*N;6@*[W>6@*N;5@*s@*PH@*g	l@*Z@*MjO@*W@*N;6@*N;5@*D@*oiDg8@*H@*;dZ@*@* ě@* ě@*R@*PH@*Z@*҉@*Ұ ě@*a|Q@*iDg8@*(@*:@*@*̿[W?@*>B[@*@*Ƨ@*]cA@*ʳg	@*p:@*Ǡ	k@*&I@*Ƨ-@*ڹ@*?@*xF@*
=p@*S@*ĨTɆ@*ŔO
@*zxl"h@*ĨTɆ@*?@*\N@*@*{J#9@*¶}Vm@*74@*C,@*e+@*s@*I^5@*@4n@*\(@*nP@*%2@*Ďqj@*84֡@*$/@*?@*s@*ƀIQ@*A@*E84@*y@*ǆ&@*ǆ&@*ǮzH@*ǻ/V@*#@*eO@*ȧ@* ѷ@*k~(@*ɠ'RTa@*ɭB@*y@*@*=p
@*W'@*~"@*͞&@*'/@*jf@*ˬq@*s@*V@*c	@*Ϫ͞@*N;6@*N;5@*@*}Vl@*Ίqi@*t@*Vu@*(@*
qv@*(@*C\@*C\@*zG@*Vu@*H@*A [@*䎊@*ңS&@*ӎMj@*ө*0U2@*|@*zG@*8YJ@*@*ؠ-
@*؆YJ@*؆YJ@*e+a@*>BZ@*ٌ~($@*e+a@*XbM@*XbM@*غ)@*y=c@*y=c@*l"h	@*_F@*Q@*׀4m@*sPH@*״3@*׍O;d@*
=p@*֡af@*֡af@*և+J@*z@*R<6@*_ح@*z@*֔Fs@*֡af@*և+J@*֮}Vl@*Ϫ͟@*Ϫ͟@*ȴ9X@*ֻ@*ȴ9X@*֮}Vl@*֮}Vl@*ֻ@*֮}Vl@*Ϫ͟@*C-@*C-@*Ϫ͟@*@*tj~@*&@*W@*Ұ ě@*a|Q@*T`d@*GE85@*s@*N;6@*oiDg8@*;dZ@*O
M@*
M;@*ΤT@*Ίqi@*C\@*w1@*:@*/{J#@*҈@*˅Q@*C%@*C,z@*ԕ*@*\)@*>BZc@*ǆ&@*Ǔݗ+@*Ǔݗ+@*Ǡ	k@*Ǡ	k@*y@*RT`e@*+I@*ƚ,<@*Ƶ'@*A@*Fs@*Fs@*ƀIQ@*$/@*@*š@*u@*7@*ěS@**0@*e@*?@*
=p@*wkQ@*M@*@*o hی@*@N@*ѷX@*[6@*@*Vl!@*K]@*?@*j~#@*j~#@*ߤ@@*$@*qu!@*vȴ@*u%F@*	k~@*)@*YJ@*U@*F@*F@*YJ@*+j@*sPH@*KƧ@*!.I@*+J@*t@*fA@*D@*֡a@*O
M@*zG@*@*@*Z@*@N@*nO@*iB@*A [@*4J@*_p@*
=q@*H@* ě@*@*;dZ@*o @*{J#:@*Mj@*@*!-w@*VϪ@*~($@*U=@*C,z@*fB@*W'@*Ov`@*lD@*x@*\)@*u%F@*Xy=@*>BZc@*#@*@*	k@*@*n/@*7@*tSM@*o h@*a@N@*`A@*}Vm@*e+@*I^5@*e+@*.H@*d8@*hۋq@*     @*ߤ?@*($x@* ѷY@*,=@*}H@*IQ@*(\@*5Xy@*A@*W>6z@*u%@*c	@*)_@*>B@*6C@*Y}@*XbM@*l"h	@*+j@*&@*4K@*Y|@*g	l@*:)y@*[W>6@*
(@*U2a|@*U2a|@* ě@*o @*{J#:@*
M;@*2X@*ߤ?@*ߤ?@*qi@*Vu@*H@*O;dZ@*:@*[W?@*I^5?@*C]@*a@@*:)z@*6z@*͞&@*qiC@*ᰉ'@*Q@* ѷ@*>BZc@*$xG@*#@*@@*/V@*	k@*	k@*y@*x@*YJ@*YJ@*fffff@*YJ@*1.@*
L/@*n/@*1@*S&@*u@**0@*?@*S@*tj@*9@*\(@*u%F
@*3@*e+@*Zc@*.H@*@*o@*o@*ae@*C@*n@*'RT`@*     @*     @*حV@*?@*$tS@*$tS@*	@*H˒:@*~쿱[W@*~%@*}b@*|u"@*|#x@*|N;@*|쿱[@*|wkP@*|wkP@*|wkP@*|wkP@*|j~#@*|wkP@*|wkP@*|N;@*|wkP@*|]ce@*|C,zx@*|n.@*{q@*{A@*{A@*{$@*|(\@*|PH@*|C,zx@*|?@*{lC@*{q@*{=K^@*{u%@*z,<@*zS&@*y"`@*y_o@*y_o@*y@*y_o@*y	k~@*xF]d@*w+@*weں@*w
=p@*vaf@*v+J@*v+J@*vE@*v8YJ@*v4K@*vOv_@*vOv_@*vOv_@*vt@*u=K@*tE@*t9XbN@*tJ@*s@*rm\@*rᰊ@*rT`d@*rnO@*rnO@*ra|Q@*qN;6@*p`A7@*p|@*pbM@*p@*o-V@*o
M;@*nMj@*o hۋ@*o'/W@*ov@*mhr!@*l@*l<쿱@*l1&y@*k:)z@*jW'@*ix@*iDg8~@*h@*h9Xb@*h@*hr Ĝ@*h>BZc@*g	k@*g8}H@*gE84@*g8}H@*f@*f1.@*e@*d7@*d*0@*dJM@*dqj@*dxF@*dZ1@*dg8}@*dxF@*c	@*cS&@*cnP@*c	@*cF]c@*ca@N@*cn.3@*c{J#9@*c,zxl@*b74@*b@*b@4@*b&IR@*a@*`4m@*`u!@*`[6@*_vȴ9@*_?@*_[W>@*_˒:)@*_$tS@*_.H@*_;dZ@*_U=@*_|hs@*_H˒:@*_o@*_	@*^쿱[W@*^҈p;@*^쿱[W@*^m\@*^$t@*^5?|@*^BZc @*^5?|@*^ ѷY@*]E@*]v@*]-V@*]H˒@*]p
=@*\Z@*\PH@*\64@*\n.@*[$@*[lC@*\n.@*\n.@*[lC@*[S@*[W>6z@*[/V@*YY}@*Y|@*Y@*Y0
)@*XPH@*XPH@*Xe+@*XD*@*W@*W3@*W3@*W&@*WXe@*V8YJ@*U$/@*U2a|@*TO
M@*T`d@*TFs@*T,<@*T,<@*T9XbN@*T@*T@*S@*Sg@*Sݗ+k@*S*0U2@*SE@*SMj@*S@*Sg	l@*SMjO@*SZ@*S@N@*SMjO@*S҉@*Rm@*RW@*R<64@*R<64@*R<64@*R ě@*Rp:@*R ě@*Rp:@*Rᰊ@*Rᰊ@*Rᰊ@*RS&@*RnO@*RT`d@*R䎊@*Rn@*QX@*Qo@*Q[W>6@*QA [@*Q&x@*Q4J@*P
=q@*P-
q@*OVϫ@*OrGE9@*P@*P@*P@*O@*O@*O'/W@*NMj@*N2X@*Nc	@*Nc	@*N;5X@*N.2@*N;5X@*N.2@*N;5X@*NH@*NVu@*N_o @*N!R<@*N!R<@*M@*M@*Mhr!@*M%@*MC\@*M(@*M@*MU=@*M%@*MM:@*MB@*MB@*MB@*M\@*M5Xy>@*MV@*MV@*Mqu"@*Mqu"@*MV@*L@*L>B[@*L@*LC@*L<쿱@*KQ@*K6z@*KI^@*KC,z@*JD@*JfB@*J0
@*J#9@*Iy@*Ix@*I7KƧ@*Hۋq
@*HTɅ@*Hۋq
@*Hۋq
@*Hp:@*H˒:*@*HeO@*G8}H@*FIQ@*F-@*F'@*F-@*F@*Fs@*Ffffff@*Fs@*F?@*E8YK@*E@*E@*E`A7L@*EQ@*Eo i@*DS@*D%1@*D%1@*D%1@*C%2@*Cn.3@*C9@*C	@*CS&@*BC,@*B ѷ@*B`A@*BwkQ@*Bu%F
@*B@4n@*As@*Ae@*An.@*A'R@*Ao@*A@*Ae@*Ae@*A@*A7Kƨ@*A7Kƨ@*Ao hی@*ATɅo@*AGz@*A-w1@*@ѷX@*@-
@*@n@*@-
@*@     @*?H˒:@*>"@*>҈p;@*?!-w1@*?@*?Ft@*>쿱[W@*?Ft@*>@*>iB@*>$t@*>vȴ9X@*>%@*>%@*>%@*>iB@*>5?|@*>5?|@*>BZc @*>($x@*>u@*>
(@*> ѷY@*=b@*=v@*=}H@*=p
=@*=[@*<u"@*<쿱[@*<?@*<]ce@*<64@*;Q@*;lC@*<n.@*;5Xy@*;lC@*;lC@*;lC@*;6@*;A@*;q@*;dZ@*;~$@*;qu!@*;q@*;S@*;6@*;Q@*;6@*;A@*:)_@*:>B@*:>B@*:)_@*:G{@*:,<@*:)_@*:G{@*:,<@*:,<@*:>B@*:Y@*:vȴ@*:>B@*:)_@*:vȴ@*:>B@*:>B@*:)_@*:G{@*:c	@*;u%@*;u%@*:~@*:,<@*:)_@*:,<@*:G{@*:vȴ@*:xl"h
@*:ݘ@*:ݘ@*:S&@*:vȴ@*:S&@*:vȴ@*:)_@*:>B@*:Y@*:Y@*:,<@*:>B@*:Y@*:)_@*:)_@*:xl"h
@*:kP|@*:C\@*:C\@*:Q_@*:Q_@*:kP|@*:kP|@*:Q_@*:xl"h
@*:^5?|@*:kP|@*:xl"h
@*:ݘ@*:kP|@*:kP|@*:ݘ@*:S&@*:>B@*:ݘ@*:>B@*:)_@*:Y@*:Y@*:Y@*:)_@*:G{@*:c	@*:,<@*:~@*;u%@*;u%@*;s@*;s@*;"`B@*;s@*;"`B@*;/V@*;=K^@*;=K^@*;"`B@*;/V@*;/V@*;=K^@*;"`B@*;s@*;s@*;"`B@*;s@*;s@*;u%@*;"`B@*;/V@*;=K^@*;J#9@*;W>6z@*;qu!@*;~$@*;~$@*;q@*;S@*;S@*;S@*;A@*;S@*;S@*;6@*;Q@*;lC@*;$@*<n.@*<ߤ@@*<ߤ@@*<n.@*<n.@*<ߤ@@*<ߤ@@*<ߤ@@*<Q@*<(\@*<64@*<C,zx@*<]ce@*<j~#@*<wkP@*<j~#@*<wkP@*<?@*<?@*<쿱[@*<1&@*<#x@*<#x@*<?@*<u"@*<hr@*<hr@*<u"@*<u"@*<hr@*=K]@*=[@*=!.H@*=/w@*=IQ@*=ce@*=p
=@*=}H@*=ڹZ@*=v@*=-V@*=H˒@*=H˒@*=H˒@*=cA @*=-V@*=-V@*=-V@*=cA @*=cA @*=cA @*=,=@*=E@*> ѷY@*>
(@*>u@*>5?|@*>BZc @*>\N<@*>iB@*>vȴ9X@*>%@*>$t@*>@*>6z@*>Q@*>Q@*>҈p;@*>ߤ?@*>ߤ?@*>쿱[W@*>"@*?Ft@*?@*?@*?.H@*?.H@*?H˒:@*?U=@*?o@*?|hs@*?$tS@*??@*?[W>@*?vȴ9@*?˒:)@*?˒:)@*?حV@*?[W>@*?vȴ9@*?[W>@*?vȴ9@*?حV@*?حV@*?@*@     @*@     @*@6@*@     @*@     @*@
qu@*@     @*@6@*@4m9@*@A7K@*@A7K@*@hۋq@*@n@*@n@*@-
@*@IQ@*@IQ@*@d8@*@ěT@*@ѷX@*@҈p@*@҈p@*@C@*A$/@*A$/@*A [7@*Aae@*A7Kƨ@*Ao@*A.H@*Be+@*B3@*B&IR@*A.H@*BI^5@*B&IR@*BM@*BZc@*Bh	ԕ@*Bh	ԕ@*BM@*BZc@*Bu%F
@*Bu%F
@*Bu%F
@*Bu%F
@*B@4@*B@4@*B\(@*BwkQ@*B@*B}Vm@*B@*B`A@*B`A@*B`A@*B ѷ@*BC,@*CS&@*C	@*C,zxl@*CF]c@*Ca@N@*Cn.3@*CeO@*C$@*Cwk@*C@*CZ@*C@*C
=p@*CA [@*C\N@*Dtj@*Dtj@*D%1@*Dtj@*D2W@*D2W@*D2W@*D%1@*D2W@*D?@*D?@*D%1@*D?@*DM:@*DM:@*DZ1@*DtSM@*DtSM@*Dqj@*DTɆ@*D?@*D*0@*De@*De@*Eo i@*EQ@*E+a@*E84֡@*EF
L0@*ES&@*ES&@*E`A7L@*E`A7L@*E`A7L@*Em\@*Ezxl"h@*Eݗ@*Eݗ@*Eݗ@*EO
@*E1@*E1@*E1@*En/@*En/@*E8YK@*EoiDg@*Eڹ@*F
L/@*F@*F$/@*F1.@*F?@*FL/{J@*Ffffff@*Fs@*F@*F,<@*F-@*F'@*FA@*F]cf@*Fx@*G@*G)^@*G,@*G+I@*G8}H@*GE84@*GE84@*G_o@*G_o@*G_o@*GlC@*G&@*Gݗ+@*G	k@*GzH@*G/V@*GfA@*G@@*G-@*G#@*H	ԕ+@*H@*H>BZc@*HK]c@*HXy=@*Hr Ĝ@*H@*H@*H9Xb@*Hp:@*Hۋq
@*H@*I ѷ@*I@*I7KƧ@*IQ@*Ik~(@*Ix@*IoiD@*IoiD@*I@*I'RTa@*IB@*I'RTa@*I'RTa@*I'RTa@*I^5?}@*Iy@*Iԕ*@*Iԕ*@*Iᰉ'@*IlD@*J	 @*JOv`@*J0U2a|@*J0U2a|@*JJL@*Jd7@*JqiC@*JL_@*J0
@*Jg	@*Jn@*J͞&@*JڹY@*JfB@*JD@*JfB@*JD@*K'/@*KC,z@*K6z@*KC%@*KP{@*K]cA@*Kjf@*Kjf@*KxF]@*KQ@*K:)z@*KU=@*K~($@*KƧ@*K҈@*KC]@*Ks@*L1&y@*LL_@*L/{J#@*L<쿱@*L<쿱@*LVϪ@*LVϪ@*LVϪ@*LVϪ@*Lq@*L~($x@*Lq@*L_@*L_@*LC@*LC@*Lzxl"@*L@*L>B[@*L!-w@*M:@*Mqu"@*M5Xy>@*MB@*MjOv@*Mw1@*Mw1@*MM:@*Mhr!@*MU=@*M%@*M%@*M@*M@*M@*MU=@*M@*M@*M(@*N_o @*N!R<@*N!R<@*N.2@*NH@*NVu@*N}Vl@*Nqi@*NT@*N2X@*Nt@*N1@*O hۋ@*Ov@*O'/W@*O4֡a@*O4֡a@*OO
M@*OiDg8@*O{J#:@*O-V@*O@*O@*OrGE9@*P@*P*0U@*P*0U@*P ě@*P ě@*OrGE9@*O;dZ@*O;dZ@*OrGE9@*P@*P*0U@*P ě@*P:~ @*P:~ @*PU2a|@*PbM@*P|@*P'RT@*P'RT@*P@*P
=q@*P{@*P
(@*P)^@*P$tT@*Q&x@*Q[W>6@*Qhr @*Q@*Qu@*QX@*Q2W@*QN;6@*QiB@*Rn@*R䎊@*RGE85@*Ra|Q@*R{m@*Rp:@*RS&@*R<64@*RsP@*Rm@*S҉@*S&@*S@N@*SMjO@*SZ@*Sg	l@*S@*Sߤ@*SE@*S|@*Sݗ+k@*Sݗ+k@*Sg@*TJ@*T@*T,<@*T9XbN@*TFs@*T`d@*T`d@*Tm8@*T#@*T*1@*T3@*TO
M@*TɅoi@*T֡a@*TZ@*TD@*TE@*U*0@*U2a|@*U?|h@*UL_@*UY|@*UfA@*Usg@*U!R@*U$/@*U=K@*Uᰉ@*UXy=@*U=K@*Ush@*Ush@*U?@*U!.@*V4K@*V+jg@*VE@*Vl!-@*Vaf@*V}Vl@*Vȴ9X@*VϪ͟@*V@*VC-@*V@*V!.I@*WXe@*W1@*WXe,@*WsPH@*WO;d@*WkP@*W@*W@*WrG@*XF]d@*X*0@*XQ@*Xl"h	@*XYJ@*Xtj@*X-
@*XU@*X@@*Xe+@*XPH@*Y	k~@*Y+@*Y0
)@*Y=b@*YXbM@*YrGE8@*Yb}@*Yb}@*Y~($@*Y(@*YD@*Y"`@*Y>BZ@*Zu%F@*Z@*Z)y@*ZC\@*ZQ_@*ZkP|@*Zxl"h
@*Zݘ@*Zvȴ@*ZY@*ZG{@*Z~@*[u%@*[s@*[s@*["`B@*[=K^@*[W>6z@*[qu!@*[~$@*[A@*[m]@*[5Xy@*[5Xy@*[5Xy@*[6@*[6@*[5Xy@*[lC@*\n.@*\Q@*\64@*\C,zx@*\]ce@*\j~#@*\?@*\쿱[@*\#x@*\u"@*\>@*][@*]/w@*]IQ@*]ce@*]}H@*]+j@*]-V@*]cA @*]b@*]E@*^
(@*^($x@*^BZc @*^\N<@*^iB@*^%@*^@*^Q@*^҈p;@*^ߤ?@*^"@*_Ft@*_!-w1@*_;dZ@*_H˒:@*_b}V@*_|hs@*_$tS@*_?@*_[W>@*_˒:)@*_䎊r@*`     @*`6@*`4m9@*`NU@*`hۋq@*`u!@*`-
@*`IQ@*`4m@*`ѷX@*`C@*a$/                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @C;&@C;9@C:,<@C:GE85@C:GE85@C:6C@C:=p
@C:<64@C:@C:GE85@C8oiDg8@C8@C8*0U@C8'RT`@C873@C8
qu@C8@C7kP@C7$tS@C6O;@C6t@C6x@C6Fs@C2GE85@C2\(@C2Zc@C.Ov_@C,N;@C+s@C)Gz@C)@N@C)n.@C+'/@C/?@C1$/@C1Q@C0u%F@C0)@C0p:@C0A7K@C."@C.O;@C/_o@C2͞&@C1@C1JE@C1^@C3m]@C4S@C4D@C5fA@C5\(@C5ݗ@C5ݗ@C5n/@C5b@C6x@C7	@C8
qu@C8|@C8-
@C8ěT@C9=b@C9y@C:GE85@C:d7@C:T`d@C:GE85@C:W'@C:h	ԕ@C:m@C;	@C:D@C:ڹY@C:)_@C:@C;	@C;jf@C;Z@C;a@@C;@C<n.@C<1&y@C<L_@C<tj@C<tj@C<Fs@C<g8}@C<j~#@C<g8}@C<`d@C<g8}@C<j~#@C<cA \@C<C@C<qj@C<O
M@C<#x@C<֡a@C=:@C<E@C=B@C=!R@C=v@C=\(@C=Ϫ͞@C>t@C>
L/@C>
(@C>4K@C>@C>@C>$/@C>Ov_@C>@C>+jg@C>1.@C>Vu@C>\N<@C>H@C>R<6@C>p:~@C>}Vl@C>쿱[W@C>Fs@C>@C>Fs@C? hۋ@C?
=p@C?@C?$tS@C?4֡a@C?E84@C?RT`e@C?eں@C?lC@C?&@C?˒:)@C?rG@C@-
q@C@A7K@C@Q@C@hۋq@C@YJ@C@@C@d8@C@ۋq
@C@C@CA7KƧ@CAo@CAB@CA|@CAD@CAe@CA@CAY}@CBI^5@CBqiC@CB}Vm@CBW@CBڹY@CBfB@CCnP@CC,zxl@CC@N@CCdZ@CC@CD2W@CD(\@CDߤ@@CDSMj@CE<64@CEB@CEL_@CEO;dZ@CE5Xy>@CEQ@CEu@CE'0@CE:@CDD@CEK]@CEF
L0@CEm\@CEݗ@CE8YK@CF
(@CFBZc @CFL/{J@CF5?|@CF8YJ@CF+@CGo @CHH@CHQ@CH[6@CHXy=@CHl"h	@CHtj@CH
=q@CHd8@CH{@CHp:@CHp:@CHD@CHe+@CH@CHe+@CHěT@CHp:@CHe+@CHp:@CHr Ĝ@CH4m9@CH6@CHF]d@CGrGE9@CG#@CG@@CGfA@CG@CG+@CG@CGK]d@CGK]d@CGo @CGo @CG@CGo @CG@CG@CG@CG@CG@CG@CG@CG@CG;dZ@CG@@CGrGE9@CH	ԕ+@CHQ@CH@@CHF@CH҈p@CI@CH4֡b@CH{@CH@CHe+@CH$tT@CI@CIQ@CI@CIl@CI|@CI^5?}@CI_o@CIiB@CI>BZ@CIᰉ'@CIᰉ'@CIᰉ'@CIs@CI@CI@CIiB@CI@CI>BZ@CJ	 @CJI^5@CJ	 @CJ	 @CJn@CJ	 @CIlD@CIs@CI@CI>BZ@CIᰉ'@CIᰉ'@CIiB@CI"`@CIN;6@CID@CIB@CIu@CIo@CIo@CI@CIx@CIhr @CIA [@CI-w1@CIA [@CIk~(@CIae@CI[W>6@CIXbM@CIXbM@CI[W>6@CIXbM@CIQ@CIXbM@CITɅo@CIrGE8@CI@CI~($@CI@CIn.@CIn.@CI'RTa@CI'RTa@CIo@CIx@CIXbM@CI4J@CI+@CI@CH4֡b@CH@@CH
(@CH)^@CH{@CH	k@CH$tT@CHPH@CHPH@CH{@CH{@CH@CH@CH\)@CI@CI@N@CI+@CI@N@CI@CH$tT@CH\)@CH4֡b@CH@CHe+@CH҈p@CH҈p@CHۋq
@CH҈p@CHPH@CI@N@CI_p@CI@CI+@CI@N@CH@CHѷX@CH)^@CH@@CHěT@CH@@CHěT@CH9Xb@CH{@CH
=q@CH'RT@CHy=c@CHl"h	@CHl"h	@CHeO@CHNU@CHK]c@CHD*@CH73@CHQ@CH_F@CHbM@CHQ@CHQ@CHQ@CHQ@CHK]c@CH>BZc@CHD*@CHA7K@CH:~ @CH:~ @CH73@CH>BZc@CHH@CHQ@CHeO@CHr Ĝ@CHYJ@CHu%F@CHIQ@CHIQ@CH-
@CH
=q@CH{@CH4m@CH4m@CH
(@CH)@CHTɅ@CHěT@CHF@CHF@CHۋq
@CH`A7@CH@CH@CH@CH@CHC@CH{@CH4֡b@CH	k@CH	k@CI ѷ@CI ѷ@CI$/@CI [7@CI=b@CITɅo@CIb}@CIu!S@CIk~(@CI[W>6@CIXbM@CI[W>6@CITɅo@CIQ@CIN;5@CIJE@CIJE@CIN;5@CIJE@CIQ@CIu!S@CI7Kƨ@CI@CIn.@CI|@CI|@CIX@CI2W@CIe@CJn@CJ@CJ@CJ@CJ#9@CJ-V@CJ#9@CJ&IR@CJ䎊@CJ#9@CJ1'@CJe+@CJ1'@CJOv`@CJe+@CJOv`@CJ@CJI^5@CJs@CJI^5@CJ	 @CJu%F@CI.H@CJu%F@CI-@CIlD@CI-@CI-@CIY}@CIY}@CIY}@CI-@CIY}@CIY}@CIY}@CIY}@CI@CI@CI@CI@CIR@CI@CIR@CIR@CI>BZ@CID@CI@CI^5?}@CI|@CI|@CIl@CI(@CI(@CIn.@CIu@CI7Kƨ@CI@CI|Q@CIu!S@CIo hی@CIk~(@CIhr @CI[W>6@CITɅo@CIGz@CIDg8~@CI=b@CI7KƧ@CI4J@CI#w@CI+@CIrGE@CI$/@CI ѷ@CH$tT@CHPH@CHPH@CHPH@CH\)@CH{@CH@CH@CH@CHC@CH@CHe+@CH҈p@CHD@CHѷX@CH)^@CH@@CHTɅ@CHTɅ@CHTɅ@CH4m@CH9Xb@CH-
@CHIQ@CH@CH@CH'RT@CHYJ@CH˒:*@CHhۋq@CHQ@CHK]c@CHH@CHA7K@CH>BZc@CH73@CH4m9@CH-
q@CH ě@CH@CH	ԕ+@CHF]d@CH     @CH@CHF]d@CHF]d@CG#@CG+j@CGrG@CG@CG@@CGحV@CG+@CG˒:)@CG@CGvȴ9@CG/V@CGr@CG[W>@CG&@CG?@CG	k@CG$tS@CGO;d@CG{J#:@CG4m@CG4m@CGv_ح@CGo@CGiDg8@CGiDg8@CGeں@CGeں@CG_o@CGRT`e@CGAs@CG4֡a@CG.H@CG!-w1@CG!-w1@CGXe@CG)^@CG
=p@CG@CG@CF"@CFMj@CF쿱[W@CF1@CFC-@CFߤ?@CFߤ?@CFϪ͟@CFߤ?@CF@CF6z@CFT@CFT@CF$t@CFqi@CF+J@CFIQ@CF}Vl@CFz@CFvȴ9X@CFc	@CF_ح@CFYJ@CFH@CF;5X@CF8YJ@CF5?|@CF.2@CF($x@CF@CFzG@CF
(@CF_o @CF ѷY@CEڹ@CEڹ@CEC\@CEoiDg@CEᰉ@CES@CE@CEcA @CE\(@CEsh@CE@CEM:@CEsg@CEjOv@CE\@CES&@CEO;dZ@CEO;dZ@CEF
L0@CEB@CE84֡@CE2a|@CE2a|@CE2a|@CE+a@CE(@CE(@CE[@CEu@CE'0@CEo i@CDE@CDe@CD!-w@CDhr@CD@CD/@CD֡a@CD@CD?@CDj~@CD#x@CD?@CD@CD1&@CD1&@CDTɆ@CDzxl"@CD쿱[@CDN;@CDN;@CDN;@CDqj@CDqj@CD#@CDo h@CD~($x@CDzG@CDtSM@CDq@CDm8@CDj~#@CD`d@CDSMj@CDI^5?@CDFs@CD?@CD<쿱@CD?@CD9XbN@CD2W@CD2W@CD2W@CD(\@CD"h	ԕ@CDQ@CDL_@CD@CDߤ@@CDߤ@@CD1&y@CDJ@CDJ@CDn.@CCs@CC@CCA [@CC%2@CCa@@CCa@@CC|@CC5Xy@CC5Xy@CC@CCa@O@CCa@O@CCa@O@CC6@CC6@CCa@O@CCZ@CC~($@CCE@CCm]@CCq@CCq@CC*0U2@CC@CC@CCm]@CCm]@CCm]@CC*0U2@CCwk@CCߤ@CC$@CC:)z@CCeO@CC@CC@CC~$@CCxF]@CC{J#9@CCn.3@CC]cA@CC]cA@CCW>6z@CCP{@CCJ#9@CCF]c@CCC%@CC=K^@CC=K^@CC6z@CC6z@CC6z@CC33333@CC/V@CC)^	@CC"`B@CCPH@CCs@CC҉@CCI^@CB74@CB74@CBD@CBm@CBm@CB䎊q@CBsP@CB,<@CBW@CBn@CBn@CB}Vm@CB ě@CB ě@CB ě@CB>B@CB0
@CB\(@CB@4@CB~"@CBu%F
@CBa|Q@CBT`d@CBQ_@CBC\@CBC\@CBC\@CB=p
@CB:)y@CB-V@CB&IR@CB#9@CB#9@CBOv`@CBs@CBI^5@CAlD@CA-@CA-@CAs@CAR@CA@CA>BZ@CAe@CAԕ*@CA@CAԕ*@CA@CAԕ*@CAԕ*@CAN;6@CAN;6@CAo@CAo@CAD@CA@CAX@CA|@CA'RTa@CAu@CAu@CA@CAo@CAo@CA~($@CA7Kƨ@CA@CA@CA@CA@CA|Q@CAb}@CAb}@CAu!S@CArGE8@CArGE8@CAk~(@CAe+a@CAae@CAae@CA^@CAXbM@CAXbM@CATɅo@CAXbM@CAQ@CAN;5@CADg8~@CA:S@CA:S@CA4J@CA0
)@CA0
)@CA4J@CA-w1@CA*0U2a@CA&x@CA#w@CA_p@CA@CA$/@C@$tT@C@PH@C@\)@C@\)@C@{@C@@C@҈p@C@҈p@C@ۋq
@C@D@C@p:@C@TɅ@C@4m@C@9Xb@C@U@C@
=q@C@IQ@C@IQ@C@IQ@C@u%F@C@u%F@C@@C@-
@C@tj@C@@C@'RT@C@'RT@C@YJ@C@n@C@|@C@|@C@|@C@y=c@C@y=c@C@r Ĝ@C@r Ĝ@C@l"h	@C@l"h	@C@eO@C@hۋq@C@eO@C@bM@C@eO@C@_F@C@[6@C@[6@C@[6@C@[6@C@U2a|@C@U2a|@C@NU@C@K]c@C@H@C@A7K@C@A7K@C@>BZc@C@:~ @C@73@C@-
q@C@'RT`@C@ ě@C@$xG@C@$xG@C@}H@C@6@C@6@C@6@C@bM@C@
qu@C@F]d@C@     @C?#@C?#@C?rGE9@C?rGE9@C?䎊r@C?+j@C?䎊r@C?䎊r@C?-@C?-@C?Vϫ@C?rG@C?rG@C?@@C?@@C?@@C?@@C?;dZ@C?@C?@C?حV@C?fA@C?@C?@C?@C?˒:)@C?˒:)@C?K]d@C?K]d@C?˒:)@C?o @C?@C?o @C?@C?r@C?3@C?&@C?	k@C?	k@C?-V@C?-V@C?$tS@C?ݗ+@C?O;d@C?{J#:@C?|hs@C?y@C?sPH@C?sPH@C?sPH@C?o@C?lC@C?iDg8@C?eں@C?O
M@C?H˒:@C?E84@C?E84@C?E84@C?As@C?>6z@C?8}H@C?;dZ@C?8}H@C?.H@C?1@C?+I@C?$tS@C?!-w1@C?,@C?@C?)^@C?)^@C?
M;@C?Ft@C>!.I@C>"@C>Fs@C>Mj@C>Mj@C>@C>@C>x@C>1@C>ߤ?@C>C-@C>]cf@C>+@C>Ϫ͟@C>Ϫ͟@C>Ϫ͟@C>Ϫ͟@C>҈p;@C>҈p;@C>t@C>ȴ9X@C>m\@C>m\@C>m\@C>&I@C>Q@C>'@C>2X@C>2X@C>6z@C>@C>O;@C>O;@C>,<@C>O;@C>$t@C>@C>$t@C>qi@C>+J@C>qi@C>%@C>IQ@C>%@C>IQ@C>IQ@C>z@C>z@C>}Vl@C>z@C>vȴ9X@C>p:~@C>s@C>l!-@C>iB@C>fffff@C>fffff@C>\N<@C>YJ@C>Vu@C>Vu@C>Ov_خ@C>Ov_خ@C>H@C>E@C>E@C>BZc @C>BZc @C>BZc @C>BZc @C>8YJ@C>8YJ@C>5?|@C>8YJ@C>5?|@C>1.@C>1.@C>1.@C>5?|@C>5?|@C>1.@C>.2@C>$/@C>($x@C>$/@C>Ov_@C>!R<@C>!R<@C>Ov_@C>!R<@C>!R<@C>@C>@C>@C>zG@C>zG@C>@C>4K@C>zG@C>4K@C>4K@C>4K@C>4K@C>4K@C>
(@C>4K@C>
(@C>
L/@C>
(@C>
L/@C>
L/@C>t@C> ѷY@C> ѷY@C>t@C=ڹ@C> ѷY@C> ѷY@C> ѷY@C=ڹ@C=ڹ@C=ڹ@C=ڹ@C=C\@C=C\@C=C\@C=!.@C=!.@C=!.@C=oiDg@C=oiDg@C=oiDg@C=oiDg@C=(@C=(@C=ᰉ@C=(@C=(@C=ᰉ@C=ᰉ@C=ᰉ@C=,=@C=,=@C=ᰉ@C=S@C=ᰉ@C=,=@C=,=@C=,=@C=S@C=S@C=S@C=S@C=S@C=
qv@C=
qv@C=
qv@C=
qv@C=
qv@C=
qv@C=?@C=
qv@C=
qv@C=
qv@C=?@C=
qv@C=?@C=b@C=b@C=b@C=8YK@C=8YK@C=8YK@C=8YK@C=8YK@C=Ϫ͞@C=@C=@C=@C=@C=@C=@C=8YK@C=@C=@C=@C=Ϫ͞@C=Ϫ͞@C=@C=@C=Ϫ͞@C=Ϫ͞@C=Ϫ͞@C=@C=Ϫ͞@C=Ϫ͞@C=Ϫ͞@C=Ϫ͞@C=Ϫ͞@C=Ϫ͞@C=Ϫ͞@C=cA @C=cA @C=cA @C=Ϫ͞@C=cA @C=Ϫ͞@C=cA @C=cA @C=@C=cA @C=@C=@C=cA @C=@C=@C=@C=@C=@C=@C=@C=@C=8Y@C=@C=8Y@C=8Y@C=\(@C=\(@C=\(@C=\(@C=8Y@C=8Y@C=8Y@C=\(@C=\(@C=8Y@C=8Y@C=\(@C=\(@C=H˒@C=H˒@C=\(@C=\(@C=\(@C=\(@C=\(@C=H˒@C=H˒@C=H˒@C=H˒@C=\(@C=H˒@C=H˒@C=\(@C=\(@C=n/@C=H˒@C=n/@C=H˒@C=H˒@C=H˒@C=H˒@C=H˒@C=H˒@C=H˒@C=n/@C=H˒@C=n/@C=n/@C=@C=@C=@C=@C=n/@C=@C=n/@C=n/@C=n/@C=@C=n/@C=n/@C=@C=@C=n/@C=H˒@C=@C=@C=sh@C=sh@C=@C=@C=@C=sh@C=sh@C=sh@C=sh@C=-V@C=-V@C=-V@C=-V@C=-V@C=sh@C=-V@C=sh@C=-V@C=-V@C=1@C=-V@C=sh@C=sh@C=-V@C=sh@C=sh@C=-V@C=-V@C=1@C=-V@C=-V@C=-V@C=sh@C=n/@C=H˒@C=H˒@C=H˒@C=n/@C=n/@C=n/@C=n/@C=@C=H˒@C=n/@C=n/@C=n/@C=n/@C=n/@C=n/@C=n/@C=@C=n/@C=n/@C=n/@C=@C=@C=@C=@C=@C=@C=@C=sh@C=sh@C=@C=@C=@C=@C=n/@C=@C=@C=n/@C=@C=@C=@C=@C=n/@C=sh@C=@C=@C=@C=@C=sh@C=@C=sh@C=sh@C=sh@C=sh@C=-V@C=-V@C=-V@C=-V@C=-V@C=sh@C=-V@C=-V@C=-V@C=-V@C=-V@C=-V@C=sh@C=sh@C=sh@C=sh@C=sh@C=@C=@C=sh@C=sh@C=sh@C=sh@C=sh@C=sh@C=-V@C=-V@C=-V@C=-V@C=-V@C=-V@C=-V@C=1@C=U=@C=1@C=1@C=-V@C=1@C=sh@C=-V@C=-V@C=-V@C=-V@C=-V@C=-V@C=-V@C=-V@C=1@C=-V@C=sh@C=-V@C=1@C=sh@C=sh@C=-V@C=-V@C=-V@C=sh@C=@C=sh@C=-V@C=sh@C=-V@C=-V@C=-V@C=-V@C=-V@C=1@C=1@C=1@C=-V@C=-V@C=-V@C=-V@C=-V@C=-V@C=-V@C=-V@C=-V@C=-V@C=sh@C=-V@C=sh@C=-V@C=sh@C=-V@C=-V@C=@C=sh@C=@C=sh@C=-V@C=sh@C=-V@C=-V@C=-V@C=1@C=-V@C=-V@C=-V@C=1@C=-V@C=1@C=-V@C=1@C=1@C=-V@C=-V@C=-V@C=-V@C=1@C=-V@C=sh@C=-V@C=-V@C=sh@C=sh@C=-V@C=-V@C=-V@C=sh@C=sh@C=-V@C=sh@C=-V@C=-V@C=-V@C=-V@C=-V@C=sh@C=-V@C=-V@C=sh@C=-V@C=sh@C=-V@C=sh@C=sh@C=-V@C=sh@C=sh@C=sh@C=sh@C=sh@C=sh@C=sh@C=sh@C=@C=sh@C=@C=sh@C=@C=-V@C=sh@C=@C=sh@C=@C=sh@C=sh@C=sh@C=sh@C=@C=n/@C=@C=sh@C=sh@C=n/@C=sh@C=@C=n/@C=@C=@C=n/@C=n/@C=n/@C=sh@C=sh@C=@C=@C=n/@C=n/@C=n/@C=n/@C=n/@C=n/@C=n/@C=n/@C=n/@C=n/@C=H˒@C=H˒@C=\(@C=\(@C=\(@C=\(@C=\(@C=\(@C=\(@C=\(@C=\(@C=8Y@C=@C=8Y@C=@C=8Y@C=8Y@C=8Y@C=@C=\(@C=H˒@C=\(@C=\(@C=\(@C=H˒@C=\(@C=n/@C=\(@C=\(@C=8Y@C=\(@C=8Y@C=8Y@C=\(@C=8Y@C=@C=8Y@C=8Y@C=cA @C=Ϫ͞@C=8YK@C=@C=@C=@C=@C=Ϫ͞@C=@C=@C=8YK@C=b@C=8YK@C=b@C=b@C=?@C=?@C=b@C=b@C=
qv@C=?@C=?@C=b@C=?@C=?@C=S@C=
qv@C=
qv@C=?@C=?@C=
qv@C=?@C=
qv@C=
qv@C=S@C=
qv@C=
qv@C=
qv@C=
qv@C=
qv@C=S@C=S@C=
qv@C=S@C=S@C=
qv@C=S@C=S@C=S@C=S@C=
qv@C=
qv@C=
qv@C=
qv@C=S@C=S@C=S@C=
qv@C=
qv@C=?@C=?@C=
qv@C=?@C=?@C=?@C=?@C=?@C=
qv@C=
qv@C=
qv@C=S@C=S@C=,=@C=S@C=,=@C=,=@C=S@C=S@C=,=@C=S@C=,=@C=,=@C=,=@C=ᰉ@C=ᰉ@C=(@C=(@C=(@C=(@C=oiDg@C=oiDg@C=!.@C=oiDg@C=!.@C=E@C=E@C=E@C=E@C=!.@C=E@C=E@C=E@C=E@C=E@C=E@C=E@C=!.@C=E@C=E@C=E@C=!.@C=E@C=!.@C=!.@C=C\@C=C\@C=!.@C=!.@C=!.@C=!.@C=!.@C=!.@C=C\@C=ڹ@C=ڹ@C=ڹ@C=C\@C=ڹ@C=C\@C=C\@C=ڹ@C=C\@C=C\@C> ѷY@C=C\@C=ڹ@C=ڹ@C=ڹ@C=C\@C=C\@C=C\@C=C\@C=C\@C=C\@C=C\@C=ڹ@C=ڹ@C=ڹ@C=ڹ@C> ѷY@C> ѷY@C> ѷY@C> ѷY@C> ѷY@C> ѷY@C>t@C>_o @C>_o @C>_o @C>_o @C>_o @C>_o @C>
L/@C>
L/@C>
L/@C>
L/@C>
(@C>
(@C>
(@C>
(@C>
(@C>4K@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>4K@C>zG@C>4K@C>4K@C>zG@C>@C>zG@C>@C>zG@C>zG@C>zG@C>zG@C>zG@C>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @kt4֡b@k5Xy>@kԕ*@kӷr@k1&x@k+@k,@kNU@k$tS@l|@l%@l'O
@l+B@l(,<@l']cA@l3r@lDFs@lZu%F
@l_!.@l[zH@lrGE8@lʽ<64@m%*0@n?@oXy=@pvY|@q+$xG@q=b@q8}H@qO
@rU=@qj^5?}@pm\@pjf@p2a|@q-
@pce@p<64@pD@pfA@p?%1@o4m@n6@nJA@nÓݗ+@nW>6z@n*{@l²@k̿[W?@k*@jϜߤ@jp
=@jNU@jgC%@i	 @izxl"h@iM:@iYp
=@in9XbN@i ѷ@id8@jT`d@jX/@jmS@juC]@jne@jj@jz*0U@jXbM@jqj@jJE@j@j[fA@j
sP@iX@i?@i ѷY@jx|@k@k6ߤ?@k*<쿱@keں@j6z@jC]@i&C,@hb@hӎMj@ia6z@i`A7L@i&IR@i|@i-V@ia0
)@i{hr!@iqu!@j(@j?@j >B[@j2sP@j@Y@jJq@j3@jD@jϻ/V@jC-@j6C@j\(@jᰉ@jx/{J#@jr-
@jm)^@jUsg@jD)_@j+Ƨ@i҈p;@iÓݗ+@ifA@i՚kP@i@i}Vl@iǴ3@iS@i!R<@iy@iqu"@iT`d@iC-@i}H@i@i|@irC@ib?@iLn@iFvȴ9X@iJ-
@iY,=@ic%@iJwkQ@iI7KƧ@i`*0@i`A@iFkP|@iCwk@iFh	ԕ@i-hr @i䎊@i}H@i+I@hm\@h6z@h͊	@h>@hn@hhۋq@hʽ<64@hu@hѫU=@h҉@h*0@hp:@hg	@h]ce@hp:@h~NU@hl?@h_H˒@h>iB@h"-
@h$F]d@h,Vu@gIQ@gŎ!R@g䎊r@gce@gכ=K@gE@h&x@h
PH@h
a@O@h5?|@h5?|@g{m@gPH@gЧ@gŊ	@g+j@g4֡a@g4J@gݗ+k@g2W@gn1&y@f@fX@f
M;@fa|Q@fĚu%F@f($x@fc	@fˊڹZ@fę0
@fC\@fC,zx@ftj@fėO;@fϳ|@f$/@fz@fk~(@fL_@fxF]@f[6@fcA @g9;dZ@gOrGE8@gR9XbN@gIS@gH˒:*@gVbM@gdD*@gZC@gW2W@g]RT`e@gZqi@gbߤ?@geS@g^9Xb@gY%F
L@gV^5?|@g[Vϫ@g^g	@gdA7K@gev@gmrGE9@gi+@gPA@gR2W@gay@gp[W?@gb/@gKA [@g/zxl"h@fzxl"h@fk~(@f1&y@fϪ͞@f-V@fxF]@f{@f"`B@g@f*0U@fM:@f[6@f͞&@f[6@f?@fH˒@f?|h@fjOv@fn@f3@fn@f@fn@f>BZ@fo i@fs@f>BZ@fL/{J@f!R<@f@N@f1@fb@f1@fb@fn/@fȭU@fXy=@fhr!@fW@fJ#9@f,=@feO@fں)@fOv_@fں)@f8YK@fVu@f     @fZ@f84֡@f~"@ga|Q@g`d@f_p@fěT@fa@N@fPH@gPH@gPH@fL/{@fQ@fu"@f@f0
@f&x@f_p@fPH@f5?|@f|@fPH@f@f_ح@fBZc @f藍O;@f1&y@g2X@g2X@gN;5@gwk@g !R<@g/V@f@fL_@f-@fJM@f-@f-@f1@f_o@f#9@f쿱[W?@f&@f]cf@fۋq
@f74@fp:@f1&x@fMjO@foiD@fߤ?@f@fJ@fvȴ9X@fxF]@f?@fᢜwk@f?|h@f&@fFt@f"h	ԕ@f"`@fw1@f+j@fj~@f.H@f>B[@fӽ@fք?@fs@f+@fu!S@f'RTa@fj~@f쿱[@g!-w@fɅoi@fu%F@g ,<@g^5?}@g^5?}@go h@f-
@f4K@fឃ%@fsg@fsP@fI^@fI^@fsP@fbM@f֡a@f@f@fȴ9X@f,<@f@fn/@fu@fJL@fW'@fyu!S@fgg	l@fs,=@fx4K@f|;5X@fvU@fj-
q@f_u@fZ@f]zH@fZ@fX䎊@fK'RTa@f=Z@f4t@f1=K^@f8.2@f8.2@f9:)z@f:\)@f-nP@f.u!@f6)^@f9:)z@f6)^@f'M:@f#Y|@fo i@f
!.H@f@e
(@ezG@e"`B@e*0U@ew1@e>BZ@eo i@eK]c@eo i@eo i@eo i@es@e ě@eu!@e/w@es@eQ@eZ@eZ@ecA @e@e
(@e@N@e*0U@e*1@ej~#@eZc@eݘ@eݘ@e0U2a|@eM:@ewkP@en@e"h	ԕ@eiB@e>6z@eߤ?@e[W>6@ex@e?@ew"`B@e~*0U@e@eaf@eQ@exݘ@e>BZc@ecA @etj@etj@e@eZ@eL/{J@evȴ9X@e
(@ehۋq@e/V@evȴ9X@eL/{J@e@eK]c@ecA @e/V@e
(@ecA @etj@etj@e
(@etj@etj@e=K^@enP@e-
@en/@efA@efA@efB@e ě@eu%F
@eu%F
@evȴ@eF]d@e<64@eJL@eW@e@4@ebM@e@4@e쿱[@e;dZ@e/V@eIQ@esg@e/V@e@eo h@e\(@e䎊r@e֡a@eH˒:@e:)y@ed7@e+a@eK]d@e+a@eH˒:@e1&@esPH@eH˒:@esPH@e֡a@e+a@eVl!@e+a@esPH@eH˒:@e1&@esPH@e#x@efA@eǪ͞@eǪ͞@e     @eٷr@e84֡@eԕ*@e#x@eQ@e.H@ev@e)y@eՌ~($@eSMj@e?@e)y@eSMj@e~($x@ekP@eo@eI^5@eo@eᰉ'@eae@ep:~@e7KƧ@eՌ~($@e@e~($x@exF@e@ee+@e2W@eٶE@e҈@eo hی@e@e|hs@e'/W@e@e-@e癙@e&x@eA@eA@e&x@e'@e'@e|Q@eC,zx@eߤ?@f7@eqi@eC]@e(@eC,zx@el!-@f|@f|@fAs@f%1@f쿱[W@f쿱[W@f%1@e4J@e{J#9@eS@f
+@feO@e҈p@e	k~@f]cA@fs@f]ce@f#N;5@f +J@fR<6@f1&y@fA@f6@f6@fjf@f1.@f1.@f_o @f +J@f&L_@f6@f\N<@f\N<@f${@f10
)@f6ߤ?@f10
)@f*?@f&zG@f"`B@f${@f+wk@f:x@f8"h	ԕ@f10
)@f6ߤ?@f5[W>6@f8!R<@f=@f:@f?@N@f6
(@f3!.@fK:)z@f`g8}@fX@fUJE@fH)^@fOZ@fUJE@fNYJ@fR%@fYu!S@fFt@fFt@fNYJ@fAb@fGg	l@fL\)@fNYJ@f\;5X@fnI^5?@fe$@f]U=@f]U=@fVU@fS,=@fd$t@fh@fc-w1@fd$t@fgXbM@fl`A7@fl`A7@foq@fs
=p@frs@fu:S@fk@fh@foq@fk@fl`A7@fk@fl`A7@frs@fs
=p@fqrGE@f|,<@f}o@fgW>6z@f`eO@foq@fv@fu:S@fl`A7@fzȴ9X@f%2@f|,<@fk@fs
=p@f@fs
=p@fs
=p@fϪ͟@f hۋ@f%2@f6z@f@fcA \@fu@f~{@fIQ@fcA \@fIQ@fVu@f~{@f9XbN@fA [@fTɅo@fA [@fQ@fA [@fϪ͟@fd8@f8YJ@fGz@f@f$tT@f%2@f%2@f@fQ@f hۋ@fQ@f.H@fC-@fb}@f@f@f6z@fGz@f$tT@fb}@fS@fTɅo@fߤ@fƧ@fc	@f8YJ@fߤ@fA [@fq@fq@fQ@fb}@fae@fv@fSMj@fa@@f\N@f~($@f7KƧ@f@fu@fa@@fTɅo@f~$@fX@f(\@fe+@fp:~@fR<6@f}Vl@fv@f_p@fo hی@fq@f4m@f4֡b@f64@fDg8~@fxF@fxF@fDg8~@fo hی@fDg8~@fDg8~@f64@f҈p;@fxF@f64@f64@f̵'@fߤ?@f̵'@fߤ?@fߤ?@f|Q@fߤ?@fC,zx@fC,zx@fߤ?@fC,zx@fN;6@f̵'@f|Q@f4֡a@fPH@fC,zx@fӦ(@f&I@f7Kƨ@f&I@fXe@fPH@f^@f|@f^@f4J@fzxl"@fA@fiB@fiB@f&I@f|@fiB@flC@f%1@fPH@f	 @fzG@f#@f]ce@fR<6@f줨T@fOv_خ@fR@g Ov`@f@g@4n@f]ce@f1&y@f줨T@f줨T@fO
M@gK]@f@fR<6@fD@gy@fO
M@f"@fD@fO
M@g Ov`@fO
M@gy@f"@f1&y@f2X@g?@fO
M@f2X@g
-@g\(@f+J@gFt@gM@g\(@g
-@f2X@f2X@g[@gJM@g#9@g>6z@g[@g	_o@f6@gx@gJM@g3@g&e@gwkP@gx@g"`@g'R@g"@g"@g n@g'R@gwkP@g3@g3@g n@g$0U2a|@g$0U2a|@gwkP@g3@g,?@g3v_ح@g9o i@g+!-w1@g"@g"@g3@g+!-w1@g4>B[@g0O
M@g(Zc@g"`@goiD@g0
)@gx@g+!.H@g/KƧ@g,?@g+!-w1@g+!-w1@g:h	ԕ@g6=p
@g%ݗ+@g(Zc@g,?@g/KƧ@g3v_ح@g3v_ح@g%ݗ+@gwkP@g3@g0O
M@g+!-w1@g,?@g4>B[@g9o i@g;˒:)@gAY|@g6=p
@g4>B[@g->BZ@g2s@g/KƧ@g)@g;˒:)@gE{J#:@g=/w@g>S&@g>S&@gF@gE{J#:@g7	k@g7	k@g->BZ@g4>B[@gE{J#:@gLu%F
@g:h	ԕ@g:h	ԕ@gF@gLu%F
@gBj~@gIzH@g=/w@gAXe,@gBj~@gHJL@gIzH@gAXe,@gBj~@gIzH@gTW@gPvȴ@gWhr!@gF@g6=p
@g9@g3u!S@g3v_ح@gKu@gMحV@gWhr!@gIzH@gBj~@gF@gIzH@gX!-w@g[/V@gP쿱[@gIzH@gE{J#:@gX!-w@gdbM@g]Q@g_@gX!-w@gX!-w@gX!-w@gO;dZ@gW@gW@gb>B@gm@gZW'@gV-V@gkI^@gq䎊r@gesg@gq䎊r@gx䎊q@go+a@gmK]d@gq䎊r@gi-V@gq䎊r@gv}H@gld7@gesg@gsVl!@gk:@gv}H@g~r Ĝ@g{U=@gp\(@gq䎊r@go+a@gv}H@g{U=@g9@g*0@gx䎊q@gld7@go+a@gsVl!@g{U=@gw$/@g{U=@gU2a|@gm@g{U=@gx䎊q@g     @g!R@g9@g     @g*0@g     @g!R@g*0@gm@g
(@g!R@g)_@g@gU2a|@gU2a|@gd8@gqu!@g8YJ@gC,z@gF]c@g)^	@g)^	@g)^	@gm\@g$tT@g,<@g73@g)^	@gS@gp
=@gbM@g)^	@goiDg@gbM@g4m@g4m@gm\@g)^	@gE@gp:~@g*0U2@gڹ@ge+@g6z@gXy=@gS@goiDg8@goiDg8@g6z@gu%F@gěT@g@gu%F@g6z@ge+@gG{@goiDg8@gڹ@gxF@gE@gڹ@ga@N@gěT@g҈@gƧ@gQ@g|@g҈@g
L/@g
qv@gC%@gPH@g
qv@gڹ@g
qv@g͘A@gƧ@gѷX@gPH@gԊqi@gѷX@g5?|@gѷX@ga@O@gQ@gѷX@gC%@g|@g͘A@g&x@gQ@gߦ(@g	k~@ga@O@ga@O@gߥS@gBZc @gQ@gѷX@gƧ@ga@O@g	k~@gBZc @g@gߥS@g|@g旍O;@g旍O;@g@gP{@g͗+j@gP{@g|@g쿱[W@g	k~@gP{@gߥS@g4J@g|@gl!-@g4J@g旍O;@g{J#9@g҈p@gOv_خ@g+@g7Kƨ@g]cA@gTɅ@gz@g1&y@g|@g|@gOv_خ@g+@gOv_خ@gOv_خ@gm]@g+@gOv_خ@gOv_خ@gz@gOv_خ@g+@gz@gݗ+k@gz@gC\@gz@gz@gm]@gA [@gk~(@g2W@g1&y@gOv_خ@gOv_خ@gz@gC@g]cA@h\N<@h	N;5@gz@g$/@g$/@h	N;5@h&@hL_@h6@gjf@gC@g
=q@h]cf@hn.@h#w@h6@h+J@gjf@g_o @h
2X@h6@g1.@g1.@h#w@h	N;5@h	N;5@h
{@hg@hzG@h5Xy@hߤ?@hiB@h?@h
x@h	N;5@h
{@h$/@h0
)@hۋq
@g$@h\N<@g$@hH˒@h?@h5Xy@h$/@h5Xy@hYJ@gjf@hᰉ@hۋq
@h?@h
xF]@h?@h[6@h
xF]@hiB@hoiD@h5Xy@h"`B@h	MjO@hzG@h"`B@h?@hiB@h$/@h$/@h
(@h"h	ԕ@h!R<@hiB@hۋq
@h?@h$/@h?@hᰉ@hۋq
@h@hFs@h@hQ@h&vȴ9X@h&vȴ9X@hQ@hQ@hcA @h
xF]@h0
)@h
(@h"L/{J@h!.@hwk@hFs@h!.@h5Xy@hS&@h"L/{J@h#@hZ@htj@hZ@hQ@h!.@htj@h#@h*af@h&vȴ9X@h)=b@hQ@h#@h.t@h4YJ@h'Q@h&vȴ9X@h#@h*af@h&vȴ9X@h/V@hZ@h)=b@h5Z@h?u!S@h;JE@h)=K^@h!R<@h1:)z@h7 [7@h)=K^@h%@N@h&u!@h#1@h.)^@h1:)z@h'b@h&u!@h#1@h*-
@h.)^@h0.2@h1:)z@h2\)@h2\)@h.)^@h-g	l@h4YJ@hCU=@hCU=@h9,=@h*-
@h"K]c@h,t@h-g	l@h7 [7@h?tj~@hE ѷ@h?tj~@h<U@h?tj~@h2D@h5n/@h7	@h7	@h@D@hG@hN@h@D@h>4K@h?tj~@hCU=@hG@hB;5X@h<U@hCU=@hKE@h;J#9@h)<64@h-fA@h@D@hE ѷ@h8n@h1hr!@h9,=@hJ-
@hKE@hC%@hE ѷ@hFeO@h;J#9@h5n/@hG@h>4K@h?sg@hB:~ @h1hr!@h*vȴ@h>bM@hKE@h?sg@hG@hKE@hC%@hB:~ @h>bM@h5/V@h7Q@h8@4@h?sg@h?sg@h<>B@h;IQ@hB:~ @h;IQ@h>bM@hB:~ @hB:~ @h;IQ@h<>B@h9@hC%@hFeO@hTH@hTH@hI,zxl@h8@4@hB:~ @hP}H@hNY@hB:~ @hNY@h[9@hK䎊r@h<>B@h>bM@hC%@hI+a@hP}H@hMVl!@hE:@hI+a@hI+a@hP}H@hR䎊q@hP}H@hFd7@hC-V@h?sPH@hC-V@hI+a@h>@hFd7@hK䎊r@hI+a@hK䎊r@hJ\(@hI+a@hJ\(@hC-V@hUU=@hTH@hP}H@hI+a@hMVl!@hNY@hUU=@hb*0@hY8YK@hK䎊r@hB:)y@hNY@hR䎊q@hU͞@hWV@hU͞@hFd7@hC-V@hNY@hRZ@hTH@hP1'@hNY@hP1'@hFd7@hR䎊q@h^     @h[84֡@h@֡a@hNY@h\wkQ@hYfA@hRZ@hC-V@hNY@hTH@hRZ@hWV@hYfA@hWV@hI+I@hI+a@hXqiC@h^     @hKs@hTGE85@hWV@h[84֡@h_ce@h`)_@hXqiC@hRZ@hU͞@hKs@hN#x@hTGE85@hYfA@hYfA@h\wkQ@hYfA@hRZ@hKs@hb)y@h`?@hQ4m@hN#x@hFcA \@hMU=@h[8}H@hn@hdD@h_b}V@hb)y@h_b}V@hXq@hb)y@hj~"@hfT`d@hYԕ*@hPQ@h].H@hb)y@hb)y@h_b}V@hW
M;@hQb}@h[8}H@hcO;d@h[8}H@hMTɅo@hTFs@hYԕ*@h_b}V@h]\N@hgX@hxa|Q@hiv@hW
M;@hXq@hnTɆ@hfSMj@h[7KƧ@hfSMj@h`?@h\S@hd@hj~($x@h]\N@h_ae@h]\N@hfSMj@hqo@hqo@hu@hmE84@h`m\@hb(\@hmE84@hnTɆ@hc~($@hd@hd@hb(\@hXp:~@hb(\@hgX@hkᰉ'@hgX@hb(\@hfSMj@hd4֡b@h`m\@h]\N@hfR<6@hk҈@hYa@@hN4m@h`m\@hcq@hi_p@hn-@hu@hj}Vl@h`ěT@hd4֡b@hpxF@ht64@hmDg8~@hqo hی@hj}Vl@hj}Vl@hmDg8~@hr҈p;@hpxF@hgE@hY@hTD*@hgE@hi_p@hfR<6@hi_p@hmDg8~@hrѷX@hC,zx@h|Q@hya@O@hk
qv@huA@hvPH@hx_ح@hrѷX@h`@hcڹZ@hk
qv@hp
L/@hn@hqn.3@hgsh@hmC%@hp
L/@hiPH@hn@h҈p@h@hp
L/@h_`A7L@hj|@ht5?|@hdc	@hrѷX@hqn.3@hfQ@hk
qv@hmC%@hiPH@hx_F@h@ht4m9@hqm\@hfQ@h_`A7L@hqm\@hv~@hqm\@hy\(@hy\(@hk;dZ@hi*0@hp	ԕ+@hnL/{@hp	ԕ+@hv~@hy\(@hy\(@hy\(@ht4m9@hnL/{@h{&@h@hnL/{@hdhr@hx_F@hA7K@h{&@h9Xb@hP{@hx_F@hv@hy\(@hnL/{@hp	ԕ+@hx_F@h@hx_F@h{&@hg	@hv@hP{@hv~@hx_F@h ѷ@hO;dZ@hu%@h}Vϫ@ht3@hy\(@h{%F
L@hr`A@hx^5?|@h|p:@hO;dZ@h}Vϫ@h ѷ@hA7K@hr*0@hj{m@hu$tS@hO;dZ@hO;dZ@h}Vϫ@hr*0@hr*0@hv>@hu$tS@h{%F
L@h{%F
L@h ѷ@h|p:@h}Vϫ@ht3@h{%F
L@hu$tS@hjzG@hnzxl"@hg	@h ѷ@h?@hO;dZ@h@hx^5?|@hy@hK]@h?@ht3@hy@h}Vϫ@hkiB@ht3@hmAs@ht3@h/@h?@hOv`@hO
M@hOv`@hO
M@h@4n@h{%F
L@hnzxl"@hO
M@hnzxl"@h/@hy@hK]@hy@hO
M@h+@huR<6@h|#@h/@hy@h/@hkP|@hkP|@hyD@hrA@hO
M@hy@hOv`@h/@h/@h@4n@h@hqk~(@h?@h\(@h|#@hp1&y@h{$tS@h{$tS@hO
M@h/@h@hOv`@hnT@h|#@hOv`@h{$tS@h{$tS@hO
M@h?@huR<6@hv"@hO
M@h}R@huR<6@hv"@h?@h]cf@h2X@hyD@hyD@h|+J@hv	k@hFt@h}g@ht2W@h2X@huR<6@huR<6@h1@h                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ?R<64?SMj?tj?@4n?eں?o hی?u?&?}Vl?+?E84֡?O
M?+?JL_?vȴ9?L_?bM?6C-?p
=q?Vt?Vt?-w1?-
?73?4m8?RT`d?Gz?ҕᰉ?Ӂ?хoiDg?ӚkP|?BZc?ץS?j~"?As?䎊q?-V?नTɆ?@NU?O;dZ?|?&IR?u?Zݘ?NT?j~"??wkP?꭫U=?o ?
=p?6C?L/{J?a@N?^?ᰊ?W'?eO
?!-w2?N;5X?+?W>6z?*0
?*0
?wkP???rG?oiDg?4m9?C,z?:S&?S&?<쿱[?m\?+a@?C]??&IR?Q?MjO?eں?ҒS&?U=K???)^	?.2X?W'?-
?bM?Ϫ͞?ŨXy=?C\?Țu%F?r ě?ěS?ïr?h	ԕ+?qu!S?u?nO?4֡a?QR?U=???ěS?9XbM?hr Ĝ?e+?rGE85?4m?j~"?m\?=K]?}Vl?=K^?U2a|?%2???*0
?L_?E?qu!S?*0
?u%F
?,<쿱?`d8?3?U=K?,<?E?ᰉ'?l!-w?u!?l!-w?ᰉ'?tj?u!?m8Y?-V?|?ߤ??1&y?oiDg8?&x??#?=K^?ᰉ'?ᰉ'?ᰉ'?*0?Z?N;5?l?Z?ݗ+j?䎊q?ie+a?bn/?|C,zxl?-
qv?O
M?ɅoiD?kP{?SٿM}H˒?nO;?y=b?sP??lV?u%F
?$tSM?tj?qu!S?_Ft?+I?Mj?ceO?,<?Ov_ح?u%F?0
(?҈p:?=K]?Ov_خ?E?S&¿eL_?p:Xtj~?wXe+?{u%F?	 ?{Q_C*0U2a?tj~?Ϫ͞?-V?u%F?kQ_vǿm}H˒?tZq4Jrn/{qu!Sl1&y?Q?$/?:)y?}}H˒?N;5X?u%F
?qu!S?E?O
M?xtj~?%2?_Ft?{?Xe+?`A7L?C*0U2a?N;5XpbM?|C,zxl?zvȴ9?}ZZ6C-?-V?kP{??a4J:6C-v?tZ?6C-?3*0U2a?rn/?J6C-?T`d?+I?tj?Z?tj~ۿj6C-o!-w1ſvOv_خ?tn?tZJ6C-?L_?}H˒?vȴ9?	 ?bsPHtzG{nOv_حhtj~?ݗ+j?O;dZ?IQ?4J?{Q_?u"S*0U2ao䎊q?vȴ9?nOv_ح?+jg?o!-w1?ݗ+j?)^	?wXe+?L_?fA?,<?3*0U2a?E?sPH[Q_?}Z?n?䎊q?-
qv?n/?@bM?q4J?v?PbM?Xtj~?tn?FǿfOv_خ?Xtj~?bn/?*0U2?q4J?},<?a@N?bM?usg?|C,zxl?n/?-
qv`bM?qu!S?tj?Ϫ͞?qu!S?IQ?bM?l?Ϫ͞?䎊q?ye+a?S&?%2?Rn/?=K]?n?~Ov_حg?ku%Fku%F?wXe+?:)y?ɅoiD?pbM?q4J?tZ?v+I?tn?{?Xe+?rsPH?%2?N;5X?_Ft?bM?j6C-?:6C-?fA?2a|Q?n/M}H˒?Q_p?sPH?*0?sPH?-
qv?$tS?u%F?},<?}}H˒?C,zxl?,<?)^	?{u%F?$tS?j6C-c*0U2a?ݗ+j?q?6C-?N;5?~Ov_حUL_?o!-w1?ye+a?{u%F?|C,zxl?{qu!S?y_o ?z6C-??Ov_ح?{Q_?m}H˒kQ_?z6C-?	 ?~Ov_ح?n?a@N?n/?z6C-?:)y?$/?|??L_?w?F?_!-w1ſF?u%F?AV?y_o ?{u%F?hr Ĝ?tj?ceO?2a|QJ6C-?w??Fs?4J?*0U2?wxtj~~Ov_ح?{u%F?}H˒?v?bsPH_!-w1?҈?{ſnOv_حs*0U2afOv_خ?y_o ?vOv_خ?xPHVǿp)^	PbMie+aPbMie+aZ6C-?:)y?ɅoiD?}Z?-
qv?҈?8YJ?,<?E?䎊q?m}H˒?uL_?xPHM}H˒?vȴ9?m}H˒?c*0U2a?rsPH?Xtj~?n??sg?N;5?{u%F?xPH?sPH?a@N?S&?<64?$tS?n/?ݗ+jRn/?rsPH?:6C-?S&?!-w1ſtZ?UL_?-
qv??L_?N;5?ݗ+j?fA?ᰉ'?ᰉ'?*0U2aC*0U2a?	 ?$/?	 ??N;5X?vOv_خ?V?u%F?0
(usg@bM?|C,zxl?u"?}}H˒?|C,zxl?ye+arn/tZrn/?htj~?~Ov_حPbMye+arsPH?J6C-?a4Js*0U2a3*0U2a?-
qv?$tSM?N;5X?hr Ĝ?z6C-?ye+a?~Q?*0U2a?C*0U2a?rn/?y_o ?-
qv?*0U2?0
(?zvȴ9?w?uL_?sg?ᰉ'?u%Fzvȴ9p)^	V?䎊rc*0U2a?}Z?|1&y?4J?|C,zxlbsPH?g?F?S&?bM?ye+a?C,zxl?{u%F?kQ_?fOv_خ?bM?~Q?}}H˒?!-w1?Zݘ?!-w1?{Q_?xPHZ6C-?ie+a?z6C-?C,zxl?Z?,<?쿱[W??_Ft?2a|Q?u%FZ6C-?|C,zxl?{qu!S?!-w1?&?䎊q?z6C-Z6C-?-
qv?zG{??6C-?쿱[W??qu!S?~Q?PH?Ϫ͞?0
(?j6C-?kP{?bsPH?Fs?O
M?Mj?y_o bn/?wXe+?z6C-?$tS?zvȴ9Rn/?j6C-Vǿqu"?bsPH?qu"?kQ_?3*0U2a@bM?	 ?䎊q?bM?Z?*0?߿ye+arnO;?s*0U2af?*0U2?F?Xtj~?	 ?=K^?}H˒?u%F
?N;5xPHp)^	?`bMfOv_خ?n?>BZc?wXe+?p)^	?:)yUL_tZ?u%F
?Rn/?bn/?qu"?v+I?v+I?|1&y?]}H˒x*0
S*0U2a?zvȴ9?S&?a@N?bMrnO;q4J?tnnOv_حo!-w1?䎊q?:)yku%F?@bM?|C,zxl?v?xtj~?a4J?`bM??`d8_!-w1?[Q_?s*0U2a?sPH?tnkQ_?nOv_ح?~Q?},<*6C-rsPHtn?Rn/?|C,zxl?kQ_o䎊q?bsPH?!-w1ſbsPH?xtj~nOv_حnOv_ح?-
qv?{qu!S?|C,zxl?p:?_FtV?dzG{?Z?vȴ9?u%?!-w1?0
(?D*0?ᰉ'?	 ҿ`bM?}}H˒?{u%F?rnO;?v+I?{u%FdzG{?rnO;?$tS?:)y?쿱[W??}H˒?bM?Q_?vȴ9X??N;5?䎊q?{u%F?O;dZ?iB?Ϫ͞?Z?A?hr Ĝ?Ov_خ?xPH?v?},<?tj?R<64?bn/?~Q?{qu!S?pbMbn/?zG{?L_?nO;fOv_خ?wXe+?tzG{UL_?₿C*0U2arsPH?+jg?u%F
?y_o ?{Q_?g6C-?uL_?tj~?:)y?x*0
V?*0?Zݘ[Q_?kQ_?xPH?:)y?S*0U2a?c*0U2a?~Q?!-w1?S?|1&y?:)y?#?=K^?n/?-
qv?{Q_?o䎊q޿kQ_?w?!-w1?sPH?C*0U2a?c*0U2aq4J?6C-VǿRn/o䎊q޿@bM?s*0U2a?p)^	?n?6C-dzG{?m}H˒htj~?+?҈οf?-V?*6C-?ku%F?{qu!S?!-w1?`A7L?A?Rn/C*0U2a?R<64?Ov_خ?usg??v+I?wXe+Կhtj~?tZ?hr Ĝ?<64?nO;?Q?zG{?z6C-?}}H˒?}H˒?$/?j6C-?~Ov_ح??xPH?@NU?u"?rsPH`bM?m}H˒rn/?	 ?:)y?)^	?Zݘ?n/eL_?qu"?Q?]}H˒?g?p)^	`bM:6C-?ye+a?s@NU?z6C-?1&y?ߤ??v+I?Fs?u!g?rnO;?s*0U2a?pbM?w?nO;?u"?y_o ?+jg?+J?u%F?w?rnO;?o䎊q?kQ_?_o ?߿c*0U2a?nOv_حXtj~?|?rnO;?䎊r?sPH?xtj~?S&?UL_?]}H˒?nOv_ح?u%F?hr Ĝ?Xe+?v?rsPH?q4J?hr Ĝ?|??rn/?xPH??ɅoiD?E?Fsc*0U2a?rn/??Z[Q_dzG{?*0?ᰉ'?qu"?+jg?+IC*0U2a?Ov_حtZrsPHxPH?v+I?xPHfOv_خ?-V?@NU?v+IdzG{?Rn/?ye+a?rsPH?Xtj~_!-w1?sg?*0
o䎊q?&?tj?Q_pc*0U2a?u"?S&¿f?uL_?{u%FPbM?Z6C-?6C-tZUL_?y_o ?{u%F?v+I?vOv_خ?m}H˒m}H˒?!-w1?tj~?+?fA?ɅoiD?6C-??tj~?IQ@bMC*0U2a?_Ft?쿱[W??zvȴ9??L_?zG{?䎊r_!-w1?ku%F?}}H˒?Z?+I        ?l1&y?s@NU?-
qv?R<64?IQ?$tSbsPH?ie+a?kQ_?C,zxlq4J`bM?~Ov_ح?~Q?&?wXe+?
=p
?~Qq4Jusg?+I?}}H˒?fOv_خ?J6C-?:6C-?}Z?}}H˒?L_?u%M}H˒?hr ĜZ6C-?Mj?*0?O
M:6C-?fOv_خ?s*0U2a?kQ_M}H˒?:6C-?q4J?tZ?tZ?)^	?u%F
]}H˒?j6C-htj~?s@NU?!-w1?~Q?y_o ?n/?	 ?$tS??qu!S?N;5?$tS?L_?kQ_?*6C-s*0U2a?rn/`bM?䎊q޿xPH?j6C-?{Q_eL_?dzG{?)^	?:6C-p)^	?3*0U2a?p)^	?O;dZ?kQ__!-w1?tzG{?*0U2a?O
M?tj~ۿa4Jrn/ie+a?rn/m}H˒qu"nOv_حv+ItzG{rn/uL_F?fOv_خtZUL_?a@N?{Q_htj~?{u%F?}}H˒dzG{?c*0U2am}H˒?nOv_ح?{qu!S?vȴ9X?A?S?*0U2aeL_?j6C-PbMdzG{?m}H˒?3*0U2a*6C-?2a|Q?ᰉ'?Ϫ͞?L_?+?!-w1ſeL_nOv_ح?1&y?@??ߤ??hr Ĝ?x*0
?htj~?`bM?u!q4J?3*0U2a?u"*6C-?N;5XFǿ~Ov_حp)^	?tZ?)^	F?S*0U2a?3*0U2a?:6C-?C*0U2aM}H˒?fǿrn/_!-w1?y_o ?}}H˒?䎊rj6C-?xtj~ie+a?pbM?z6C-?N;5X?ᰉ'?fA?kP{?6C-?fA?,<Rn/?䎊q?~Q?ݗ+j?Zݘ?4J?bM??usgdzG{wXe+?Rn/?~Q?UL_uL_*6C-?}Z?rnO;nOv_ح?Rn/?$tSie+auL_usgs*0U2a?ye+a?{qu!S?$tS?	 ??1&??Ov_ح?wXe+??A?f?N;5X?s@NUrsPH?ku%F?tZie+a?:)y?ݗ+j?@bM?$tSM?nOv_ح?M}H˒?J6C-|1&yzvȴ9@bM?fOv_خV?{Q_?҈?*0U2a?vOv_خdzG{?vȴ9?O
M?nOv_حxtj~v+I?]}H˒:6C-zvȴ9tzG{?*6C-?ye+a?~Q?䎊q?Z?䎊q޿c*0U2a?{qu!S?}Zo䎊q?nOv_ح`bMpbM?wkP?l1&y?3*0U2a?|C,zxl?6C-?u%?Vǿie+a?v?usgtZpbM?o䎊q޿bn/?qu"?W>6z?zG{?wXe+?wXe+ԿbsPH?F?~Q?0
(?쿱[W???L_?҈?n/?4Jv+Iw?tzG{?&?hr Ĝ?{Q_?pbM?s@NU?j6C-?c*0U2a[Q_~Ov_حwxPHz6C-:6C-?$tS:6C-?p:?-
qv?{u%Fm}H˒v+I?o!-w1?vOv_خc*0U2auL_?a4J?@bM?PbM?$/?e+a?dzG{?SٿfOv_خ?qu"?wXe+ԿXtj~?nO;?}}H˒o䎊q޿q4J??bn/?dzG{J6C-?C*0U2a?C*0U2a{Q_m}H˒?Rn/y_o ?UL_?&??-
qvgrnO;?wXe+?N;5?*0U2a?y_o ?xtj~?tzG{?:6C-?N;5?ᰉ'?*0?y_o kQ_?eL_fOv_خ?!-w1?Fs?)^	?uL_?*0
eL_?s*0U2adzG{s*0U2a?ku%F?zvȴ9Z6C-q4J?+jg?=K]?0
(?%2??O;dZc*0U2a?htj~tzG{q4J?)^	?Mj?zvȴ9ie+a?䎊q?]}H˒rn/?o䎊q޿@bM?sPH?=K^?vȴ9X?a4Jbn/?uL_?m}H˒`bM?N;5XtZ|C,zxluL_v?ie+a?wXe+?{qu!SC*0U2a?S*0U2a@bMxtj~3*0U2a??qu!SV?pbMf?~Ov_ح?:)yf?tj~?ɅoiD?@bMtn?l1&y?sg?y=b?e+a?v?vȴ9?=K^?{?o䎊q?V?Hg?4Jxtj~qu"?)^	?O
Mu"dzG{?z6C-?)^	?C*0U2a?bsPH?N;5?S?vȴ9?eL_?$tS?xtj~?}Z?Zݘ?~Ov_ح?z6C-qu"{qu!S?qu!S?ᰉ'??-V?qu!S?F?C*0U2a?fǿusgdzG{?䎊q?uL_?v+If?vOv_خ?䎊q?p:?@bM?u%F?Xe+?v+I?qu!S?zvȴ9`bM?Ov_خ?,<rn/Xtj~?Z?nO;o䎊q޿rn/f?|C,zxl?S&?_!-w1ſie+aku%F?f?$tS?N;5?{u%F?tj~?tj?ᰉ'?ᰉ'?p:?$tS?j6C-o!-w1?v+I?bM?Zݘ?O
M?y_o kQ_s*0U2aC*0U2a?u%F?n?s*0U2a?u"?Xe+?T`d?n?$tShtj~?zvȴ9?wdzG{?o!-w1?<64?L_?tn?c*0U2a?tzG{?wkP?1&y?s*0U2a?o!-w1ſ]}H˒?fǿx*0
ye+arsPHtzG{s*0U2a?rnO;?䎊r?O
M?o䎊q޿6C-?PbM?{u%F?u%F?vȴ9m}H˒s@NUie+a?zvȴ9?n?:)ydzG{s@NU?bsPHgwXe+ԿvOv_خqu"?bn/?䎊q?xPH?e+a?Q?$tSM?E?sPH?ye+anOv_ح?xtj~?T`d?	 ҿtzG{?_!-w1?tn?-
qv?a4J6C-??*0
wusg?rnO;`bM?s@NUwXe+Կo䎊q?ku%Ffǿp)^	rnO;?a4J?tzG{bsPH?a4J?{u%F?}Z*6C-?Z6C-?u%F?䎊q?n?fA?*0?$/?sPH?y_o ?pbM?o䎊q?Xe+?*0U2a`bM?6C-?@?!-w1?},<?uL_?rnO;?s@NU?tzG{?wXe+?},<?Hj6C-?|?`d8a4J?vOv_خj6C-?bsPH?R<64?$/?N;5?$/?$/?eL_?Fs?H?ie+al1&yxPH{qu!S?l1&y?{Q_?|C,zxl?:)y?!-w1ſS*0U2a?c*0U2a?ye+a?@bM?UL_?a4Jx*0
l1&y?bn/x*0
uL_ie+a?wXe+?{Q_???-V?+IXtj~?c*0U2a?usg?vOv_خPbMUL_?|C,zxl?z6C-?}Z?pbM3*0U2a?hr Ĝ_!-w1?},<?`d8?$/?u"?wXe+ԿeL_?kP{?O;dZV?}Z?u!?dzG{tZv+I?]}H˒|1&yy_o }}H˒?rn/?|C,zxl?|1&yc*0U2atn?vȴ9?=K^?eL_?tj~ۿv?tj~?@NU?Fs?s*0U2a?UL_m}H˒?:6C-:6C-?xtj~?xPH?F?m}H˒?Z6C-6C-?{u%F?N;5?tj~?O;dZrsPH?usg?O
M?vȴ9?+jg?M}H˒?_o ?$tS?{Q_PbM?+?wXe+?w?zG{?{u%F?_o ?xPH?z6C-:6C-usg?fOv_خuL_?tj~3*0U2a?bM?m}H˒fOv_خ?}H˒?uL_S*0U2a:6C-?N;5X?vȴ9?IQ?C,zxl?Q?qu"?tj~?}Z?v?ie+aq4J?tzG{3*0U2a?Z?UL_kQ_?rnO;Xtj~?x*0
?{qu!S?u%F??bsPH?L_??}H˒?usgrn/?,<?U=K?~Q?rnO;?3*0U2aUL_bn/y_o ?Xtj~?p)^	?j6C-?tn?{qu!S*6C-?u%F
?n/?Q?Ov_ح?$/?L_?Z6C-?Xtj~?o!-w1?zvȴ9?z6C-?}Z?䎊r?w?Ov_ح6C-?	 ?zvȴ9:6C-?C*0U2a?ku%F?:6C-?xPH?4J?,<?s@NU?tzG{:6C-        ?A?tj~?p)^	?qu!S?qu"?pbM?@NU?$tSM?{u%F?tj~a4J?rsPHtZ?qu!S?qu"?pbM?n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ???????????????????????????ə???ə?ə???ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   &%B(R@p3930                                      1                                       