CDF       
      time      pressure     latitude      	longitude         string_dimension   (         EXPOCODE      29AJ20160818   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    WOCE_ID       TAlPro     	DATA_TYPE         WOCE CTD   STATION_NUMBER        2      CAST_NUMBER       1      BOTTOM_DEPTH_METERS          
Creation_Time         2020-03-19T19:50:16.143279Z    ORIGINAL_HEADER      CTD,20200319CCHSIO
# Converted CTDOXY from ML/L to UMOL/KG using the following:
#     https://github.com/TEOS-10/GSW-Python, downloaded 2019-06-26
#     gsw.sigma0:  Calculates potential density anomaly with reference pressure of 0
#     dbar, this being this particular potential density minus 1000 kg/m^3.
#     This function has inputs of Absolute Salinity and Conservative
#     Temperature.  This function uses the computationally-efficient
#     75-term expression for specific volume in terms of SA, CT
#     and p (Roquet et al., 2015).
#     http://www.teos-10.org/pubs/gsw/html/gsw_sigma0.html 
#     Python equation used:
#         oxy_UMOL_per_KG = oxy_ML_per_L * 44.660 / ( (1000 +  gsw.sigma0(SA,CT)) / 1000. ) 
# Data source:  https://doi.pangaea.de/10.1594/PANGAEA.902330
# SHIP: RV Angeles Alvarino
# Cruise: MedSHIP cruise TalPro
# Region: Mediterranean Sea and Catalan Basin
# Ports: Palermo, Italy to Barcelona, Spain
# DATES: 20160818 - 20160829
# Chief Scientist: L.Jullion
# 43 stations
# Original file in AWI format. CCHDO Converted to Exchange format
# EVENT_CODE=unknown
# DATE: YYYYMMDD
# TIME: HHMM
# LATITUDE: degrees_North
# LONGITUDE: degrees_East
# STNNBR:  removed leading 0s from STNNBR
# CASTNO: not supplied by originator - CCHDO assigned all CASTNO=1 or CASTNO=2 for stations 11, 29
# CTDSAL: changed units from Practical to PSS-78.  Data values remain unchanged.
# CTDFLUOR: changed units from UG/L to MG/M3 as they are they are equivalent
# CCHDO added flags=2 for all parameters, as T.Tanhua notes all params are calibrated and CTDOXY calibrated with bottle samples
# Removed two test sample depths from event/station 004, dTalpro_Stn04_test_1db
# Data precision preserved as submitted.
# CTD: Who - T.Tanhua; Status - calibrated,final
#     Includes: CTDSAL, CTDOXY
#     CTDTMP NOTE: Used first occurrence of primary temperature sensor in original data file
#     CTDSAL NOTE: Used first occurrence of primary salinity sensor in original data
#     NOTE: Physical parameters temperature, salinity, oxygen, density, turbidity, chlorophyll, fluorescence are published on PANGAEA, DOI above.
# Fluorescence (CTDFLUOR): Who - T.Tanhua; Status -final
#        Instrument: WET Labs ECO-AFL/FL, FLNTURTD-2526
#        ScaleFactor: 1.00000000e+001
#        Dark Output: 0.0760
# Turbidity (CTDTURBDTY): Who - T.Tanhua; Status - final
#        Instrument: FLNTURTD-2526
#        ScaleFactor: 5.000000
#        Dark output Voltage: 0.070000
#
# Reference: Cruise report: https://epic.awi.de/id/eprint/49725/1/TAlPro_EUROFLEETS_cruise_report_V2.pdf
# CCHDO page: https://cchdo.ucsd.edu/cruise/29AJ20160818
# Metadata from original file
#     Event(s):     TAlPro-2016_002 (2) * LATITUDE: 38.420000 * LONGITUDE: 13.370000 * DATE/TIME: 2016-08-19T13:07:00 * CAMPAIGN: TAlPro-2016 * BASIS: Angeles Alvarino (URI: http://www.eurofleets.eu/np4/285.html) * DEVICE: CTD/Rosette (CTD-RO)
#     Citation: Tanhua, Toste (2019): Physical oceanography during MedSHIP cruise Talpro. PANGAEA, https://doi.org/10.1594/PANGAEA.902330
#     Abstract: The TAlPro cruise (Palermo - Barcelona, RV Angeles AlvariÃ±o, 18/-8/2016 - 29/08/2-16) occupied three hydrographic transects across the Tyrrhenian Sea, the western Mediterranean Sea and the Catalan Basin (Fig. 1) as part of the MedSHIP programme (Mediterranean Ship-based Hydrographic Investigations Program). A total of 43 stations were occupied during which physical (temperature, salinity, pressure, velocity), biogeochemical (oxygen, nutrients, carbonate system, dissolved Barium, oxygen and nitrogen isotopes) and anthropic (CFCs, SF6) parameters were measured in order to monitor the physical and biogeochemical state of the Mediterranean Sea.
#     Related to: Jullion, Loic (2016): TAlPro-2016: A Tyrrhenian Sea & Alger- provencal component of the MedSHIP Programme. hdl:10013/epic.5a866780-1f8a-45cf-8111-47b2b5dc29db
#     Parameter(s):
#         Event label (Event) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Sample code/label (Sample label) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Date/Time of event (Date/Time) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Latitude of event (Latitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Longitude of event (Longitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Pressure, water [dbar] (Press) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Digiquartz
#         Temperature, water [Â°C] (Temp) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: ITS-90
#         Oxygen, dissolved [ml/l] (DO) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 43
#         Turbidity (Nephelometric turbidity unit) [NTU] (Turbidity) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO
#         Fluorescence, chlorophyll [Âµg/l] (Fluores) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO-AFL/FL
#         Salinity (Sal) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Practical
#     License: Creative Commons Attribution 4.0 International (CC-BY-4.0)
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            pressure               	long_name         pressure   positive      down   units         decibar    data_min      @          data_max      @        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      $  '   pressure_QC                	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      	4  K   temperature                	long_name         temperature    units         ?C (ITS-90)    data_min      @*о
(   data_max      @:^5?|   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       $  U   temperature_QC                 	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      	4  y   salinity               	long_name         salinity   units         PSS-78     data_min      @BO;dZ   data_max      @Cl1&   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      $     salinity_QC                	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      	4     oxygen                 	long_name         oxygen     units         ?mol/kg    data_min      @fsfA   data_max      @pMO
M   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        $     	oxygen_QC                  	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      	4     CTDFLUOR               	long_name         CTDFLUOR   units         MG/M^3     data_min      6C-   data_max      ?e+a   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      $      CTDFLUOR_QC                	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      	4    	CTDTRBDTY                  	long_name         	CTDTRBDTY      units         NTU    data_min      ?   data_max      ?ə   C_format      %f     WHPO_Variable_Name        	CTDTRBDTY      OBS_QC_VARIABLE       CTDTRBDTY_QC     $ 
$   CTDTRBDTY_QC               	long_name         CTDTRBDTY_QC_flag      units         
woce_flags     C_format      %1d      	4 1   time                	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      &   data_max      &   C_format      %10d       ;(   latitude               	long_name         latitude   units         	degrees_N      data_min      @C5\(   data_max      @C5\(   C_format      %9.4f          ;,   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      @*p
=   data_max      @*p
=   C_format      %9.4f          ;0   	woce_date                   	long_name         	WOCE date      units         yyyymmdd UTC   data_min      33   data_max      33   C_format      %8d        ;4   	woce_time                   	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d        ;8   station                	long_name         STATION    units         unspecified    C_format      %s        ( ;<   cast               	long_name         CAST   units         unspecified    C_format      %s        ( ;d@       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @:^5?|@:@:ԁo h@:҈p;@:YJ@:u@:^5?}@:Y^5?}@9XbM@8}E@7nO@6&I@6'$tS@5rS&@4c	@4v!.I@4
(@3ᰊ@3O
@3f+J@3@6@3*d7@3u@2ߤ@2[U=@2+'/@2(\@1Y@1>BZ@1$t@1Y|@1a@N@1Xy=@1h_F@1a|Q@1&C-@0ae@0.H@08Y@0ڹY@0{C,z@0uoiDg@0zC\@0jqiC@0R@0Z^5?|@0=-V@0I^@0>6z@0_ح@0/@0\(@/w1@/<쿱@/u%@/sE@/JL/{@/1_p@/%o i@/e+@/_o@.[W>@.t@.C@.
M;@.u=K@.ioiD@.V4K@.B\(@.9JE@.3MjO@.,zxl"@.%u@."h	ԕ@.,~($x@.CS&@.7rG@.$g8}@.#@.(@./@-1&x@-'R@-,=@-҈p@-(@-˟U=@-Z@-p:~@-N;@-@-x_F@-XD*@-H>BZc@-D2W@-@
qu@-=ce@-<hr@-<64@-84֡b@-9"`@-:c	@-;A@-<Q@-7rG@-3҉@-2:)y@-8_F@-;S@-=p
=@-<Q@-;"`B@-<?@-<]ce@-=E@-@hۋq@-CS&@-CnP@-BI^5@-@hۋq@-B`A@-Gy@-N}Vl@-RW@-Q4J@-TJ@-WXe,@-Zvȴ@-ZG{@-Zxl"h
@-Zvȴ@-[s@-\?@-^
(@-_;dZ@-`[6@-c\N@-g&@-h\)@-hTɅ@-j#9@-m:@-o4֡a@-p'RT@-s33333@-tzG@-u=K@-vaf@-xQ@-zQ_@-{~$@-}E@-~"@-
qu@-C@-o@-wkQ@-,zxl@-
=p@-Z1@-ڹ@-e@-nP@-	@-
=p@-xF@-S@-JM@-ڹ@-Fs@-ݗ+@-$xG@-d7@-Mj@-@-bM@-p:@-Ʌoi@-+jg@-O;d@-rGE8@-W>6z@-[@-Y}@-e+a@-C-@-@-Fs@-`d@-m8@-`d@-|@-MjO@-nO@-hr @-bM@-oiDg8@-
=q@-rGE9@-o @-`A7@-_p@-*0U@-r@-v_ح@-T@-_o @-!R<@-t@-2X@-_@-͞&@-~($x@-q@-L_@-s@-^@-TɅ@-1.@-a@N@-nP@-,zxl@-9@- ѷ@-.H@-@-:S@-~BZc @-z)y@-zY@-xF@-xl"h	@-v8YJ@-sݗ+k@-s|@-sZ@-s҉@-rm@-s҉@-rsP@-rS&@-rS&@-q-@-pH@-p
=q@-q-@-rm\@-p{@-oiDg8@-o'/W@-ov_ح@-p@-m@-jfB@-iQ@-h˒:*@-g&@-f@-a'R@-_@-^ ѷY@-\쿱[@-]K]@-]H˒@-^%@-^҈p;@-`
qu@-`6@-_.H@-_U=@-^%@-]b@-],=@-^vȴ9X@-^$t@-^
(@-[$@-^Ov_خ@-cS@-jJL@-n1@-o'/W@-o@-o-V@-o-V@-or@-o͞@-oVϫ@-p ě@-rS&@-s@-sݗ+k@-sݗ+k@-tJ@-s|@-stj~@-rm@-rm\@-sPH@-sPH@-rp:@-r ě@-r ě@-r䎊q@-r䎊q@-rp:@-rs@-p'RT@-pD@-qo@-rGE85@-r:)y@-rs@-qo@-p$tT@-pD@-q4J@-p)^@-o͞@-n}Vl@-l>B[@-i'RTa@-jD@-k)^	@-hTɅ@-f&I@-ceO@-h@-i7KƧ@-i ѷ@-h@-h	ԕ+@-fx@-en/@-cS&@-b@-b\(@-ae@-aae@-Z~@-O hۋ@-G)^@-Cn.3@-A [7@-=v@-;m]@-6@-3E@-2ᰊ@-.t@-.qi@-2䎊@-6+jg@-0-
q@-&YJ@-! [7@-1&@-u"@- u!@-!Gz@--U=@-5ᰉ@-68YJ@-7@-71@-5sg@-/@-(@-&Fs@-'E84@-)7KƧ@-/rGE9@-,@-+:)z@-*~"@-&@- n@-@-֡a@-_p@-u!S@-W@-u@-o@-`A7@-4֡a@-qi@-.2@-
jOv@-)^	@-	7KƧ@-zxl"@-
@-
(@-
#9@-K]d@-$/@-zxl"h@-Q@-ڹ@-zH@-$xG@-/V@-\N@-3@-o@-TɅo@-e+@-F]c@-ae@,u@,E@,%@,حV@- n@- 	k@-TɅo@-'R@-.H@-&IR@-e@-@4n@-*0@-@-zxl"h@- C@,?@,C\@,+@,PH@,4m@,@,!.@,|@,_p@,;dZ@,'/W@,O;@,V@,<쿱@,C]@,a@@,빌~($@,q@,q@,]cA@,L/{@,jf@,^@,1&x@,lC@,'@,1@,TɆ@,2W@,74@,C@,5?|@,ܬ1&@,6@,dZ@,dZ@,s@,/V@,"`B@,/V@,/V@,Y}@,1@,Ձ$/@,@,MjO@,s@,т@,{@,)^@,Ж@,σ{J#:@,ΗO;@,C\@,ͫU=@,˒:)z@,lD@,ɓ@,x@,lD@,y@,7KƧ@,@@,Ƶ'@,+a@,7@,ĵ?@,A [@, ѷ@,3@,IQ@,A7K@,-
@,?@,5?|@,E@,-V@,ڹZ@,v@,v@,ڹZ@,p
=@,Vl!@,Vl!@,/w@,K]@,K]@,u"@,N;@,C,zx@,$@,5Xy@,m]@,qu!@,~@,ݘ@,#w@,$tS@,t@,\(@,*1@,GE85@,{m@,u!S@,&x@,@,bM@,o @,{J#:@,1@,U=@,@,/{J#@,:)z@,ڹY@,D@,P{@,Q@,C%@,JL@,ᰉ'@,x@,@,oiD@,>BZc@,1.@,1@,o i@,,zxl@,@4@,\(@,e+@,TɅo@,o@,Ov_خ@,ڹZ@,ce@,K]@,?@,$@,rGE8@,!R@,W@,Vϫ@,jOv@,~($@,)^	@,]cA@,xF]@,~($@,a@@,҈@,Ƨ@,Ov`@,7KƧ@,84֡@,F]c@,,zxl@,F]c@,@,a@N@,u%F
@,'R@,;dZ@,|n.@,y|@,w@,u$/@,s@,pD@,o@,o hۋ@,n2X@,nVu@,m8Y@,mM:@,m5Xy>@,mqu"@,l@,lzxl"@,l<쿱@,lL_@,kQ@,jn@,jOv`@,i ѷ@,h>BZc@,g@@,g	k@,g&@,g,@,eO
@,b74@,b74@,an.@,_.H@,]}H@,][@,\N;@,ZY@,YXbM@,XPH@,WsPH@,Vt@,T3@,Or@,K]cA@,H	ԕ+@,Eu@,D%1@,B74@,A$/@,>Ov_خ@,<#x@,<C,zx@,;A@,;u%@,:)_@,:C\@,6C-@,1l@,,I^5?@,%1@,$xF@, NU@,Q@,$/@,
:@,@,zxl"@,[W?@,@,"h	ԕ@,q@,
hr!@,6z@,	k~(@,,<@,e@,o h@,Zc@, NU@+-V@+1&@+XbM@+1@+R<6@+l!-@+_ح@+l!-@+R<6@+=K@+sg@+,<@+nO@+o@+񂩓@+X@+񂩓@+-
q@+.2@+~($x@+P{@+oiD@+>BZc@+*0@+S&@+.H@+b}V@+쿱[W@+\N<@+m\@+IQ@+ٙ@+73@+R<6@+\(@+ӶE@+@+fB@+@+7KƧ@++I@+Ů1@+Q@+
=p@+74@+n.@+-V@+$@+qu!@+J#9@+(@+$tS@+ᰉ@+Xy=@+9XbN@+a@O@+`d@+PH@+-V@+-V@+u@+-V@+zG@+VϪ@+]cA@+=p
@+9Xb@+-@+A@+&I@+s@+$/@+@+F
L0@+@+}Vm@+@N@+4m9@+@+vȴ9X@+1&@+C,zx@+PH@+ߤ@@+dZ@+kP|@+Q_@+Y}@+e+@+Ϫ͟@+j~@+Z@+S&@+N;5@+t@+.2@+hr!@+_@+'RTa@+qj@+7Kƨ@+7Kƨ@+	@+~5?|@+~BZc @+zS&@+z@+x@@+wO;d@+vϪ͟@+v+J@+vz@+vl!-@+vaf@+ush@+rS&@+qA [@+qN;5@+qA [@+p`A7@+p)^@+p)^@+p
(@+p{@+p'RT@+o@+o4֡a@+k6z@+ilD@+iԕ*@+iᰉ'@+i^5?}@+iB@+ilD@+i^5?}@+iB@+h>BZc@+ffffff@+eS@+f
L/@+d%1@+a@+be+@+bM@+ao@+be+@+b3@+ao hی@+`4m9@+_Ft@+]E@+[W>6z@+Y|@+X4֡b@+XF@+UXy=@+S|@+T9XbN@+T!-w2@+R ě@+Q4J@+N!R<@+MO;dZ@+MB@+Lq@+JqiC@+J0U2a|@+JOv`@+JOv`@+J0U2a|@+JW'@+Jd7@+J~"@+JL/{@+Jn@+J͞&@+JJL@+J=p
@+Iy@+IQ@+IoiD@+GlC@+F-@+FL/{J@+An.@+As@+@ěT@+=ڹZ@+=!.H@+<1&@+;lC@+;~$@+;~$@+;m]@+;6@+:c	@+:6C@+8)@+6Fs@+6_ح@+6+J@+6l!-@+6R<6@+6E@+4@+3a@O@+3g	l@+3Z@+3҉@+14J@+0:~ @+0 ě@+.t@+.}Vl@+.}Vl@+.Vu@+.;5X@+..2@+..2@+.ߤ?@+.1@+.T@+.}Vl@+.!R<@+-hr!@+,q@++xF]@++:)z@+,1&y@++C%@++6z@++C,z@+*fB@+*n@+*D@+*͞&@+*qiC@+*W'@+*L_@+*g	@+*fB@+*L/{@+*n@+*L/{@+)ԕ*@+)B@+)7KƧ@+)Dg8~@+)*0U2a@+(K]c@+'/V@+'	k@+&@+&IQ@+&-@+'+I@+'_o@+'	k@+'lC@+',@+&&I@+&@+&
L/@+%n/@+%ݗ@+%84֡@+$*0@+$o h@+#{J#9@+"74@+"@+"@+"u%F
@+"&IR@+!Gz@+䎊r@+U=@+쿱[W@+ ѷY@+/w@+hr@+쿱[@+쿱[@+N;@+j~#@+m]@+dZ@+>B@+S&@+ݘ@+6C@+@+)y@+Y}@+#w@+#w@+4֡b@+rG@+@+@+֡a@+J@+ݗ+k@+ݗ+k@+@+Z@+@+S&@+-V@+@+{@+U2a|@+@+Mj@+
@+~($x@+
g	@+	x@+p:@+@@+'@+84֡@+$@+@+ C@+ hۋq@*$t@*!.H@*>@*G{@*>BZ@*rGE8@*Q@*y=c@*Xe@*l!-@*}Vl@*E@*ᰉ@*?@*%F
L@*zG@*@*Z@*m\@*PH@*_p@**0U@*\(@* hۋ@*zG@*5Xy>@*!-w@*쿱[W?@*C@*a@@*C%@*a@@*)^	@*y@*7KƧ@*Xy=@*Fs@*84֡@*⩓@*s@*7Kƨ@*TɅo@*ὥ@*TɅo@*o hی@*o hی@*:S@*҈p@*ව4m@*ae@*C@*
qu@*A7K@*'RT`@*4m9@*
qu@*'RT`@*;dZ@*ޞ@*dZ@*u%@*xl"h
@*Q_@*1'@*u%F@*_o@*ө*0U2@*ңS&@*ҕᰊ@*ңS&@*ҕᰊ@*:)y@*s@*GE85@*-V@*䎊@*n@*nO@*ңS&@*-@*R@*:)y@*a|Q@*ҽ<64@*sP@*W@*Ұ ě@*ҽ<64@*&@*tj~@*ӎMj@*D@*յsh@*ݗ+k@*ᰉ@*2a|@*MjO@*ҽ<64@*n@*ѷX@*2W@*N;6@*2W@*a|Q@*nO@*iB@*о
(@*т@*m\@*2W@*2W@*[W>6@*GE85@*`A7@*`A7@*4J@*_p@*s@*҈p:@*:)y@*ңS&@*ҕᰊ@*ңS&@*m@*҉@*MjO@*33333@*Z@*@N@*33333@*tj~@*Ӝߤ@*ӎMj@*@*9XbN@*,<@*@*g@*ݗ+k@*Ӝߤ@*Ӝߤ@*Ӝߤ@*!-w2@*֡a@*և+J@*Xe,@*_ح@*1@*֮}Vl@*t@*״3@*׍O;d@*Xe@*ךkP@*rG@*״3@*Xe,@*Xe,@*E@*ԯO
M@*ԇ#@*Ӂ@*Ӝߤ@*Ӝߤ@*Ӂ@*ө*0U2@*ө*0U2@*!-w2@*`d@*Fs@*Լj~@*֡a@*Վ!R@*Ձ$/@*2a|@*յsh@*Վ!R@*?@*E@*E@*Z@*2a|@*Վ!R@*?|h                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          @BJ@BV@Bu@B[@B?@Bqj@B֡a@B ѷY@B	k~@B)^@B҈@B#9@B8YJ@BFs@BTɅ@B_ح@BO;dZ@Bg	l@BZ@BҜwkQ@Bղ-V@B
(@BC]@B'RT`@BѦ(@BE@Bҏ\(@Bϻ/V@BZ@Bs@B@N@B7@BXe@B8YJ@Bd7@BC\@B'/@BD@BJ@B^5?|@Bܬ1&@B+@B@Bݗ+k@Bm\@BGz@B_p@BfA@B0U2a|@Bj~@Bv@B^@BD@Bu%F
@B33333@B҈@BA [@B+a@BKƧ@B^@BkP|@B#@B[W?@BE@B84֡@B<64@BE@Bn/@BT@B;dZ@BXe,@BzH@C  ě@C )@C'/@Cb}V@C	[W>6@C
74@C!-w@C@C@C
=p@C#@CYJ@CN;5@C<쿱@CO
@C@C hۋ@Cfffff@C'@C!-w1@C@C$tS@CoiDg8@CD@Cn@Cn.@C%F
L@C!.I@C _F@C!A [@C!'R@C"T`d@C#~($@C$*1@C%%F
L@C&t@C&+@C([6@C)k~(@C*u%F
@C+҉@C+
=p@C-u@C.5?|@C/@C/\(@C0@C0
=q@C2=p
@C3jf@C4zG@C5Y|@C5b@C7Ft@C8bM@C9rGE8@C9ᰉ'@C:@C;s@C;)^	@C;q@C<tj@C<S@C=84֡@C>%@C?$tS@C@hۋq@C@ѷX@CADg8~@CBOv`@CB ě@CCs@CC҈@CDq@CE'0@CE\(@CF%@CGKƧ@CG;dZ@CH\)@CIl@CJGE85@CJ ě@CKqu!@CLZ1@CLj~@CMB@CMsh@CNH@CN@CO1@CO+j@CPbM@CP@@CQGz@CQ@CQԕ*@CR@CR@4n@CR{m@CRm\@CS5Xy@CTC,zx@CT?@CUM:@CU!.@CVVu@CVQ@CWH˒:@CW@CWحV@CW@CX6@CX-
q@CX-
@CXěT@CX	k@CY:S@CYu!S@CZs@CZC\@CZqiC@CZ0
@CZ`A@C[6z@C[ߤ@C[Q@C\q@C\[W?@C\@C\e@C]ce@C]1@C]E@C^1.@C^H@C^-@C^x@C_
=p@C_As@C_@C_kP@C_+@C`1&x@C`-
q@C`>BZc@C`H@C`u%F@Ca	k~@Ca+@Ca@Ca*0U2a@CaGz@Cae+a@Cak~(@Cao hی@Cau!S@Cal@Ca@Cb^5?|@Cb{m@CbL_@Cb,<@Cb ѷ@Cc	@Cc33333@Cc9@Cc9@Cc=K^@Cc@N@CcMjO@Ccn.3@CceO@Cc~($@Cc҈@Cd1&y@Cdtj@CdL_@CdC,zx@Cd`d@CdVϪ@CdVϪ@Cd`d@Cdm8@CdN;@Cdu"@CeV@CeB@CeY|@CefA@CeڹZ@Ce-V@Ce
qv@Cf
(@CfR<6@Cfvȴ9X@Cf}Vl@CfIQ@Cfvȴ9X@Cf+J@Cf$t@CfMj@Cg'/W@Cgeں@Cg&@Cg@ChNU@Ch`A7@CiTɅo@Ciu!S@Ci(@CiB@CiD@CiD@Ci_o@Ci@Cj-V@Cj@Cjn@CjW@Cj`A@Cj ѷ@Cjc	@Cjc	@CjD@Cjm@Cjm@Cj74@CkS&@CkPH@CkPH@Ck,zxl@Ck=K^@Ck=K^@CkF]c@Ck@N@CkW>6z@Ckjf@Ck{J#9@Ck~$@Ck@CkMj@CkA@Ckߤ@Ck*0U2@CkS@Ckwk@Ckm]@Ck5Xy@Ck҈@Cl/{J#@ClC,zx@Cl/{J#@ClxF@CkC]@Cl]ce@Clj~#@Clj~#@Clg8}@Clg8}@Clq@Cl?@Cl_@Cl3@ClTɆ@Cl1&@Cl1&@ClPH@Ck~($@CkC%@CkPH@CkS&@Cj,<@Cj ě@Cjd7@Cj:)y@Cj䎊@CiiB@Ci@Cj)y@CjqiC@Cj1'@Ci@Ci0
)@ChPH@Ch$tT@CiDg8~@CiJE@Cj{m@Cj74@Ck҉@CkS@CkMjO@Ck33333@Cj`A@Cjxl"h
@Cjd7@Cjd7@Cjᰊ@Ck)^	@Cjm\@CjD@CjG{@Cjvȴ@CjM@CiR@Cin.@Cib}@Cio@Ci^5?}@Ci|@CiX@Cin.@Ci@CioiD@Ci@Cix@Ci^@Ci^@Cil@Ci|@CiX@Ci7Kƨ@Ciu!S@Ci[W>6@CiQ@CiXbM@Cio hی@Ci@Ciu@CiR<6@Ci^@CiDg8~@CiA [@CiJE@CirGE8@Ci@Ci|Q@Ciae@Ci|Q@Ci~($@Cil@Ci|@Ci@Ci2W@Ciԕ*@CiiB@Cie@Ci@Cju%F@CjM@Cja|Q@Cja|Q@Cj-V@Cjn@Ciᰉ'@Ciԕ*@Ci_o@Ci|@CiB@Cin.@Cio@Ci@Cib}@Ci|Q@Ci|Q@Cix@Ci|Q@Ci|Q@Ci|Q@Ci@CioiD@Cio@Ci@Cin.@Ci_o@Ci'R@Ci(@Ci'RTa@Cio@Ci@CioiD@Cib}@Ciu!S@Ci^@CiDg8~@Ci=b@Ci:S@Ci7KƧ@Ci4J@Ci4J@Ci0
)@Ci0
)@Ci4J@Ci0
)@Ci-w1@CirGE@Ci ѷ@Ch\)@Ch4֡b@Che+@Ch҈p@Chۋq
@Ch҈p@ChD@Ch@@ChěT@ChTɅ@Ch4m@Ch
=q@Chu%F@Chu%F@Ch-
@Ch
=q@Ch@ChIQ@Ch-
@Ch|@ChoiDg8@Chl"h	@Chhۋq@ChbM@ChU2a|@ChNU@Ch>BZc@Ch:~ @Ch73@Ch'RT`@Ch}H@Ch}H@Ch6@Ch@Ch*0U@Ch*0U@ChbM@Ch
qu@Ch	ԕ+@Ch	ԕ+@ChF]d@Ch@ChF]d@Ch     @Cg#@CgrGE9@CgrGE9@Cg䎊r@Cg䎊r@Cg-@CgrG@Cg@CgحV@Cgo @Cgvȴ9@Cg/V@Cg[W>@Cg	k@Cg-V@Cgݗ+@Cg	@Cg&@Cg|hs@Cgv_ح@Cgv_ح@Cgo@Cgb}V@CgU=@CgO
M@CgH˒:@Cg;dZ@Cg>6z@Cg>6z@Cg>6z@Cg;dZ@Cg.H@Cg.H@Cg$tS@Cg$tS@Cg!-w1@Cg)^@Cf"@Cf@Cfx@CfϪ͟@CfA@Cft@Cfm\@CfQ@CfT@CfFs@Cf@Cf+J@CfIQ@CfIQ@Cfp:~@CfOv_خ@CfOv_@Ce!.@Ce@Ce-V@Ce%@CeO
@CeO
@Cehr!@Cehr!@Ce!R@Ce!R@CeڹZ@Cesg@CefA@Ce2a|@CeQ@Cequ"@Ce*0@Ce*0@Ceu@CeK]@CdE@Cd>B[@Cd?@CdS@Cd?@CdcA \@CdM:@Cd%1@CdL_@CdxF@Cdn.@Ccs@CcA [@CcC]@CclC@Cc%2@Cc҈@CcQ@CcQ@Cc|@Cc@Cc6@CcE@CcS@CcU=@Ccߤ@Ccߤ@Cc$@CcMj@Cc{J#9@CcdZ@CcZ@CcMjO@Cc,zxl@CcPH@Cc'/@CcS&@Cbc	@CbG{@CbڹY@Cb@Cb}Vm@CbwkQ@CbZc@Cb0U2a|@CalD@Ca"`@Cay@CaX@Ca@CarGE8@Caae@CaQ@CaGz@CaA [@Ca:S@Ca0
)@Ca$/@C`4m@C`oiDg8@C`*0U@C_#@C_vȴ9@C_|hs@C_Xe@C^af@C^,<@C^Fs@C^@C^qi@C^z@C^IQ@C^qi@C^fffff@C^H@C^Ov_@C^_o @C]ڹ@C]b@C]H˒@C]O
@C]$/@C]L_@C]2a|@C]%F
L@C]!.H@C]Q@C]qu"@C]*0@C]V@C]K]@C\D@C\Z@C\?@C\7@C\[W?@C\[W?@C\O
M@C\qj@C\wkP@C\cA \@C\Fs@C\2W@C\n.@C[g@C[
=p@C[m]@C[*0U2@C[ߤ@C[U=@C[@C[P{@C[9@C[C,z@C['/@CZc	@CZwkQ@CZu%F
@CZh	ԕ@CZT`d@CZ0U2a|@CZ䎊@CZ@CY-@CYe@CY_o@CY~($@CYrGE8@CYe+a@CY^@CYDg8~@CY@CY	k~@CY ѷ@CXC@CX`A7@CX`A7@CXD@CX)^@CX@@CX)@CXIQ@CXYJ@CXoiDg8@CXbM@CXH@CX1&x@CX$xG@CX*0U@CXbM@CX	ԕ+@CXF]d@CWrGE9@CW+j@CW+j@CWK]d@CWzH@CW-V@CW	@CW4m@CWb}V@CWXe,@CWXe,@CWO
M@CWE84@CW1@CW1@CW+I@CWXe@CVFs@CVϪ͟@CV&I@CV'@CVO;@CVz@CViB@CV\N<@CVL/{J@CV@CU@CU%@CU=K@CUw1@CUce@CU\@CU%F
L@CU!.H@CUK]@CT!-w@CT@CT/@CT/@CT֡a@CT>B[@CT[W?@CT*1@CTo h@CTo h@CTzG@CTtSM@CTq@CTm8@CTj~#@CTg8}@CTg8}@CTVϪ@CTI^5?@CTߤ@@CS\N@CSs@CSs@CS$@CSC]@CS$@CSC]@CSg@CS|@CSE@CS*0U2@CS*0U2@CSeO@CSdZ@CSn.3@CSg	l@CSdZ@CSdZ@CSa@N@CSS@CS6z@CS6z@CS'/@CRD@CR,<@CR͞&@CR<64@CRS&@CRxl"h
@CRxl"h
@CRqiC@CRZc@CRC\@CRI^5@CR	 @CRu%F@CQ@CQԕ*@CQ_o@CQo@CQ2W@CQ2W@CQ2W@CQ2W@CQ2W@CQ2W@CQ2W@CQD@CQ^5?}@CQ|@CQB@CQ(@CQ(@CQb}@CQx@CQo hی@CQ-w1@CQ&x@CQ+@CP`A7@CPۋq
@CPp:@CPěT@CP)@CP4m@CP)@CP9Xb@CP
=q@CPu%F@CPn@CP_F@CP[6@CP[6@CPU2a|@CPQ@CPNU@CP-
q@CP'RT`@CP6@CP}H@CP*0U@CO䎊r@CO@CO@@CO˒:)@COK]d@COo @COvȴ9@CO@COvȴ9@COr@CO@COvȴ9@CO/V@CO3@COzH@CO	k@CO@CO{J#:@CO{J#:@CO&@COy@COy@COv_ح@COo@COlC@COiDg8@COiDg8@COb}V@CO_o@CO_o@COb}V@COeں@CO_o@CO_o@COXe,@COKƧ@COH˒:@COAs@COAs@CO;dZ@CO+I@CO$tS@CO!-w1@CO
=p@COFt@COFt@CO)^@CO@COXe@CO
M;@CO
M;@CO@CNFs@CNMj@CN쿱[W@CNx@CNC-@CN]cf@CNϪ͟@CNm\@CN@CNQ@CN2X@CN}Vl@CN-@CNO;@CNIQ@CNz@CNp:~@CN\N<@CNR<6@CNH@CNBZc @CNBZc @CN?@CN;5X@CN.2@CN!R<@CNu@CN@CNzG@CN
L/@CN
L/@CN_o @CN ѷY@CMoiDg@CME@CM(@CM?@CM8YK@CM8Y@CMU=@CM%@CMO
@CM+j@CM!R@CMݗ@CMڹZ@CMzxl"h@CMp
=@CM`A7L@CMY|@CMO;dZ@CMF
L0@CM84֡@CM%F
L@CM'0@CLD@CL>B[@CL@CLj~@CLzxl"@CLC@CLq@CL]ce@CLC,zx@CL64@CL@CK\N@CK$@CK5Xy@CK6@CKE@CKS@CKwk@CKeO@CK{J#9@CK~$@CKqu!@CKqu!@CKg	l@CKZ@CKP{@CKC%@CK9@CK/V@CK,zxl@CK'/@CJm\@CJc	@CJfB@CJ`A@CJ@CJ@CJ<64@CJg	@CJ@CJvȴ@CJL/{@CJᰊ@CJ@4@CJu%F
@CJd7@CJQ_@CJ0U2a|@CJ	 @CIlD@CI@CI@CI@CI>BZ@CI>BZ@CIe@CIᰉ'@CI"`@CIԕ*@CI"`@CIԕ*@CI2W@CIo@CIy@CID@CI@CI@CIB@CIu@CIo hی@CIe+a@CI[W>6@CITɅo@CIQ@CIN;5@CIDg8~@CH҈p@CHѷX@CHp:@CH)^@CH@@CHTɅ@CH
(@CH
(@CH)@CH4m@CH9Xb@CH4m@CH4m@CH{@CHU@CH{@CH{@CH{@CH9Xb@CH9Xb@CHU@CHU@CH4m@CH9Xb@CH)@CHp:@CHD@CH)@CHD@CHѷX@CH@CHIQ@CH-
@CH'RT@CH'RT@CHYJ@CHYJ@CH@CH@CHn@CHoiDg8@CH|@CH-
@CHy=c@CH|@CHu!@CH˒:*@CHhۋq@CHhۋq@CHoiDg8@CHl"h	@CHu!@CH˒:*@CHu!@CH|@CHy=c@CHy=c@CH˒:*@CH|@CH˒:*@CH˒:*@CH˒:*@CH|@CHy=c@CH|@CH|@CHy=c@CHn@CHn@CHn@CH˒:*@CHy=c@CH|@CHr Ĝ@CHr Ĝ@CHoiDg8@CHy=c@CH˒:*@CH-
@CH@CH@CH
=q@CHu%F@CH-
@CHd8@CH@CHu%F@CH-
@CHd8@CH
=q@CHu%F@CHu%F@CHYJ@CHl"h	@CHeO@CHU2a|@CHXy=@CHQ@CHQ@CHQ@CHQ@CHU2a|@CH[6@CHXy=@CH_F@CH[6@CHhۋq@CHeO@CH_F@CHeO@CHbM@CHbM@CHU2a|@CHQ@CHQ@CHU2a|@CHU2a|@CHNU                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          @g%ݗ+k@i#
=p@i#_o@iZ"h	ԕ@i~Xy=@j$I^5@j@kTɅo@mr~"@n#w@n/@oK-V@o($x@oC@o_o @pI^5@p_ح@px@og	l@p4m9@p+&IR@p#9@oA [@p+jg@p@O
@pMO
M@p'Y}@p"Fs@p&ۋq
@p6S@pD~($x@p8o@pBe+@pFFs@p3@oQ@o4֡b@p?|h@oU2a|@oڹY@oVϫ@oL/{J@o/{J#@psg@prGE9@o4m@o<쿱@oAhr @omv@olD@oD@oQ@o|@o qiC@o>4֡b@n@nxF@n@nͼn/@nA [@nM:@ny=c@n&cA \@n j~@m=K^@mT@m`d@m҈p;@mA@m@myjOv@ml҈p@m~䎊q@mڹY@n]&x@nZ@4n@n@n.@nw@N@nKS@mլq@mP,<@mH˒@m$䎊q@mR@n-@n&@nS:)z@m@l:~ @lub}V@kJ@jj[W?@jy!.@jh	ԕ@kO
M@k_ح@k_@j&I@jqiC@jqu!@j@N@jȴ9X@jy@j@jtSM@j~($x@j1@j~($@jWR@jDl"h	@jN6@j5@j2C\@j6z@i)_@i2a|@jwkP@jd8@j
(@i䎊@iײ-V@iu%F@iצ(@iD@iZc@ix@i$tT@i\(@i4m@itj@i{J#9@iwO
@if䎊q@ihC\@ib ě@iKK]@i;r@iD@iB쿱[@i,a|Q@i-H˒@i*Mj@iXy=@i$/@i@i7@i.H@iC@hFs@hC-@hZ1@h@hC,@h@h3@h:@hԕ*@h33333@hJE@h.H@hBZc @h,<@heO@h!R<@h+a@h'/W@h ѷ@hj~#@hFs@hh	ԕ@hIQ@h|m\@h~$/@hxS&@hc^5?}@hmk~(@hw!.H@htj~@hwC,z@hfm8@hUD@hT[6@heo i@h\>B@h^
(@hkR@hd74@hj?@ht:~ @hrϪ͟@hdC,@hKrG@h@Ʌoi@hMGz@hIv@hB$/@hFL/{J@hD`A7@h?Q@hQ]cA@hG?@h?L_@hG-V@h;v@h'S@h.Fs@h<wkP@h<tSM@h) hۋ@h+2W@h/Vϫ@h(74@h1MjO@h+Z@h&*0@h&(\@h|hs@h9Xb@h
Z1@h6z@hƧ@hF]c@h@ho hی@h	@h
PH@g?@gu!S@geO@g
qu@gA@g0U2a|@g [7@g{@gqiC@gu%F@gڹZ@gPH@g릵(@g'@gQ@g9Xb@gn.@giB@gZ@gh	ԕ@ge+a@gݸ@gc	@gkP@ga|Q@gQ@gOv_خ@g\(@gҔFs@gh	ԕ@gcA \@g~@gxl"h
@g!.@gğvȴ@g@g,<@gˎ!R@gv@g5Xy>@g{J#9@gl"h	@gTɅ@gzxl"h@g+@g-@g<쿱@gsg@g8YJ@go hی@g{J#9@g+@g\N<@gJM@g*0U@gh	ԕ@g.H@g֐$t@g֐$t@g֐$t@gW>6z@gc	@gn.3@g&x@gC]@gC,zx@g҈p@g@g ѷ@gR@gA [@gȤT@g]ce@gև+J@gڰ{@g"`B@ge@gӽ@gք?@g.2@gȟvȴ@gڬ>B@geO@gsP@gڬ1&@gn.@g@@gC,z@gfA@gl@g=K@gӷX@g5Xy>@gPH@g>6z@gZ1@g ě@gn@g@gQ@gMj@g,@gcA \@g̹#x@g%2@g8Y@g@g*0@g*0@g]cA@g?@gjf@gL_@g}M:@gso@goU=@gyW>6z@g~䎊q@gU=@g}$/@gn9XbN@gou@gn9XbN@g}4m@gq@gzQ@gRq@gH4m@gAo @g>!.I@gK|hs@g`Q@gsa@O@g*1@g$/@grGE9@giB@g?@gpe@g^x@gRh	ԕ@gO	k@gdu!@gfffff@g:~ @gwe@gke+a@gU,zxl@gEe@gH6z@gES@g9b}V@g57KƧ@g2oiDg8@g@Q@gN5?|@gHL/{@gJ
L/@gA3@g3N;6@g+|Q@g$qi@g*@gDy=c@gN1.@gDy=c@gCs@g6*1@gO
@g!H˒@g,ۋq
@g%rG@g+w1@g=M:@g:<64@g6S&@g+u!S@g:)z@g!Z@g-
q@g1I^@g:Y@g#,@gce@g'F
L0@g(@g+o@g,Z@g*I^5@g#v@g0E@gae@g($x@g,҈p;@g3a@O@g@A7K@g=zxl"h@g5%F
L@g+k~(@g\(@g*1@g M:@g![W>@g1@gxF]@g$/@gcA @g.H@g
@g,=@g
4K@g H@g!͞@gGz@gIQ@gIQ@gGz@gC,z@gS@g
I^5@g-@g҈p;@g@gC%@gQ@g&@gB@fN;6@f|@g Ov_خ@g@N@fJM@gwkP@g0U2a|@gvȴ9@gZc@g3@fx@foiD@giDg8@g
J@f ě@fs@f@f'RTa@f$@f1@g H@gq@fE@fbM@f:)y@f:@fH˒:@fy@fƧ@f8YJ@fF@fqu!@fF]c@f
qu@fp
=@f詓@fo@fE84@fSMj@f7KƧ@f}Vl@fE@f݊ڹZ@f
qv@fn.3@fC%@f~@fm\@fm\@fB@f֙0
@f֘_@f{m@fhr@fϧ&@f|hs@f݊	@fQ_@f7@f&IR@fN;6@f7@f*0@flC@f%F
L@f$tS@fPH@f֗O;@fBZc @fϪ͞@fkP|@f"@fD@f[W>6@f݅oiD@f74@fO
@f?@f0
)@fϢwk@f"`B@fcA @f݅Q@fS&@fȰ ě@fv_ح@f>BZ@fFs@f@fZc@f>BZ@f/{J#@faf@fFs@f=b@ft@flC@f [7@f [7@f:)z@fvȴ@fJL@f.H@f䎊@f䎊@fB@f쿱[@fȴ9X@f,@fn.@fs@f@f@@fU=@fy@f4m@f8}H@fe+@fa@@f7KƧ@f*0U2a@fQ@f.H@fq@fC-@fQ@fm\@f҉@f6@f@f҉@fG{@f6@fXy=@f&@fRT`e@f(@f4J@f҈p@f+j@f$tS@f@f@f@4n@fK]@f/@f?@fy@f@4n@fy@f@4n@fOv`@f]cf@f@f"@fA [@fA [@f#w@fg@f$/@fiB@fᰉ@f"`B@fYJ@f@fݗ+@fvȴ9@fKƧ@fFs@f=b@fJ@flC@f@f4K@f,=@fn/@fzH@f-w1@fs@f{@fm@fU2a|@f)_@fqiC@fԕ*@fFs@f.H@f)y@fb}V@fb}V@fl@fu@fS&@fRT`e@f|Q@fm8@fO;@f(@f_F@fR@fOv`@fOv`@f/@fᰊ@frGE9@f ѷ@fg	@f~>@f~>@fR@fy@fkP|@f/@fL_@fj~#@fx@f6@fH˒@fYJ@fxF]@fxF]@f0
)@fiB@f[6@fH˒@fzG@fMjO@f5Xy@f?@f$/@fiB@fYJ@fw1@fhۋq@fL_@f>BZc@f>B[@fv_ح@fv_ح@f@fYJ@fYJ@f}Vl@fu!S@f+@f;5X@f ѷ@f ѷ@f ѷ@fU@f>B@fIQ@f+a@f-V@f@f֡a@f:)y@f֡a@fyeں@f}o@f@fU=@f-V@fzȴ9X@f}o@fϪ͟@f#x@f+I@fu@fGz@f hۋ@fy@fu@f+I@fy@f~{@f%2@fc	@fc	@fS@fsfA@fF]c@f73@fqu!@f73@fS@fU2a|@fF
L0@f,<@f@f@@fr@f,<@f)^	@fm\@f6@f-@f
qu@fqu"@fbM@fG{@fp
=@f73@fo@fᰉ'@fa|Q@fE@fZ@f`d@fkP@fkP@f2W@f'/W@f҈p;@f_p@f-@fxF@f|Q@f|Q@f&x@f@fn.3@f&x@fQ@f|Q@f@f5?|@fA@fPH@fPH@f_F@f@f9Xb@f\(@fa@O@f9Xb@f@f	k~@f@f9Xb@fC]@f@f҈p@fv@f'RT@f`A@f4m9@fP{@f҈p@fS@fP{@fA7K@f]cA@f@fP{@f@f@f\(@fzxl"h@fVϫ@f@fg	@f'RT@fVϫ@f@fp:@fO;dZ@f>@fO;dZ@f2a|@fk~(@fiB@f$tS@f*0@fR@f+@f&@f@4n@f/@fOv`@f]ce@fD@fy@fy@fD@fy@f2a|@fkP|@fkP|@f#@frGE9@f2a|@f/@f#@fkP|@f+@fj~#@f@fg@f2X@fg@f1.@fL_@f-@fM:@f@f\(@f1@f_o@fN;5@fn.@f?@fg@fFt@f[W>6@fx@fg@f?@f@foiD@fߤ?@f0
)@f?@fFt@f5Xy@f@fM:@f@fFs@f@f[W>6@f@f0
)@f"h	ԕ@fwk@f[W>6@fx@f@fߤ?@f[W>6@f[W>6@f"h	ԕ@fMjO@fMjO@f5Xy@fߤ?@f"h	ԕ@f[W>6@f0
)@f@f?@f"h	ԕ@fx@fiB@f@f"h	ԕ@f@f@fwk@fxF]@f[W>6@fߤ?@foiD@f'R@f=b@fvȴ9X@f0
)@f{@fiB@f0
)@f@f[W>6@fiB@fߤ?@f'R@foiD@f5Xy@fx@fx@fiB@f?@fM:@fJ@fL/{J@fZ@fQ@f@N@fL/{J@f!R<@f
(@fL/{J@f!R<@f@f@N@faf@f@N@fcA @fwk@f@fvȴ9X@fQ@f@N@fhۋq@fzG@f@faf@fvȴ9X@fL/{J@f@f@N@f@f!.@f?@f
(@f@f@f@f@f
(@fvȴ9X@fvȴ9X@f
(@fvȴ9X@f=K^@fQ@f@fb@f-
@f=K^@ft@ft@f=K^@f-
@fb@f.2@f\)@fb@fb@fu!@fY|@f<64@fnP@fYJ@f̮}Vl@f;5X@f [7@f.2@f-
@fYJ@f [7@fJ#9@f+@f	@f.2@f\)@ft@f:)z@f\)@flC@fu!S@f:)z@fYJ@fJE@fYJ@f.2@f [7@fD@fӟU=@f [7@ftj~@ffffff@fXbM@fB@f-w1@fȃ%@f [7@f,=@f)^@fȃn@ffffff@f@f̭U@ftj~@f;5X@fڐ$t@f ѷ@fD@ftj~@fżn/@fJ#9@ffffff@fXy=@fhr!@fhr!@fD@fӟU=@f ѷ@f4K@flC@fJ#9@fӟU=@f1@fႩ@fڐ$t@f;5X@ftj~@f-w1@fڐ$t@f@fႩ@fڐ$t@f;5X@fD@ftj~@fq@fI^5?@fI^5?@f;5X@f4K@fڐ$t@f ѷ@ftj~@f;5X@ffffff@fXbM@f@f$@fڐ$t@f4K@fD@f-w1@fڐ$t@fڐ$t@f@f޻@frGE@fڐ$t@f1@fႩ@fB@f-w1@f!-w2@fႩ@f!-w2@fI^5?@ftSM@f!-w2@fXbM@f1@fB@f쿱[@fXbM@ffffff@f!-w2@f!-w2@f@fI^5?@fXbM@f޻@f!-w2@f;dZ@f!-w2@fӟU=@f޻@fXbM@f޻@fXbM@f!-w2@f!-w2@f1@f1@ftSM@f!-w2@f!-w2@fڐ$t@fႩ@f!-w2@fI^5?@fႩ@fI^5?@f,=@fXbM@fI^5?@f!-w2@fXbM@fڐ$t@fXbM@ftSM@fI^5?@fI^5?@ffffff@fڐ$t@fI^5?@fXbM@f)^@fB@ffffff@f$@fI^5?@f!-w2@ftSM@fႩ@fB@ftSM@f1@fXbM@f,<@fB@f޻@fI^5?@fI^5?@fB@f)^@f@f1@ffffff@fXbM@f1@f@f@f޻@f1@f1@fI^5?                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ??ݗ?KƧ?A?'??=K^?PH?u%F?+J?dZ1?
qu"?xl"h	??1&y?
=p?|hr?u"?nO;?M:?ߤ@?6z?JM?Xe?p
=q?n?_o??|hs?1o??PH?*0
?r ě?tj~?ěS?4m?#9?73?I^5??c	?C,zxl?ù~($?VϪ͟???Ǡ	k?$/?)^?#? hۋq?)^?̞쿱[W?!.H?ͨXy=?_Ft?ћ=K^?xF?w1?E?
=p
?Ӝߤ@?[6?&x?E?jOv`?֜wkP?֐$tT?_o?֞u?s?Q?D*0?<쿱[?Ϫ͞?e+a?(\)?l?պ^5?|?ֳg	l?]cA ?b}?K]cA?`A7K?+jf?Ԛu%F?H˒:*?
(?E?̬1&y?m\?'/?n/?Ұ ě?хoiDg?Ϫ͞?Z?As?̇#?˘@?	k~(?.2X?Ą??Ϫ͞?6C?Ǔݗ+k?҈p?7KƧ?©?]ce?g	k?;dZ?'RTa?m\?\N;?~$t?ۋq?u%F
?'/W?j~#??lD??YJ?z?+I?3?'RTa?H?>B?A?Fs??
=p
?}H˒?	 ?*0U2?y=b?tj?-
???&x?
(?o?֡af?u!?tj?U=?
=p???&?u%F?+jg?zG{?1&yXtj~?,<?$/?u"?>6z?$tS?Q_?fA?bM?O;dZ?Xe?hr Ĝ?S&?)^	?҈?2a|Q?-V?ᰉ'?	 ҿku%Fl1&y?u%F
?kP{?}}H˒?*0U2a?c	?-V?{Q_?{Q_??@?ᰉ'?`A7L6C-?҈?	 ҿ_!-w1?x*0
F?s@NU?~Ov_ح?6C-?`bM?{u%F?4J?:)y?hr Ĝ?=K]?Q?䎊q?$tS?O
M?<64?v+IpbMkQ_tnfOv_خ?@?tj~?u"?fA?u%F
?},<?l1&yqu"?tZ?{?N;5?}}H˒?tj~?Zݘ?-
qv?|C,zxl??y_o ?҈?Ov_خ?䎊q޿:6C-?htj~?|1&y?nO;?}}H˒?,<?*0U2?}}H˒?!-w1?n/?$tS?Z?=K^?<64[Q_?_oҿXtj~?vǿS*0U2a?_Ft?1&y?M}H˒?bn/?g?J6C-?~Q?a4JV?)^	?uL_rsPHj6C-?*0U2a?ɅoiD?O
M?n/?ݗ+j??bn/?c*0U2a?,<?u%?bM?҈?R<64?$tS?-
qv?T`d?O
M?qu!S?~Ov_ح?҈?]ce?PbMq4J?s@NU?䎊q?䎊q?PH?tj~_!-w1?$tSM?ᰉ'?PbM?Ov_خ?sg?a@N?$tS?	 ҿg?N;5?$tS?Zݘ?ɅoiD?O;dZ?n/?J6C-?J6C-?-
qv??htj~tZ]}H˒?$tSM?:)y?y_o ?@?+?4J_!-w1?}Z?Zݘ?Z?n/?Ϫ͞?vOv_خ?$tSM?1&y?UL_?g?!-w1?ye+a?S?ᰉ'?,<??Q?tj~?N;5X?|C,zxl?}Z?xtj~?*0U2a?u?R<64?ᰉ'?fA?@bM?u%F?J6C-?*0U2??xtj~?T`d?䎊r?|1&y?*0U2?bM?L_??q4J:6C-?p:?4J?l?{u%F?tZ?bM?ᰉ'??l1&y?Z6C-M}H˒?fOv_خ?*0?U=K?bM?dzG{?:6C-?+jg_!-w1?	 ?nO;?#*6C-?tzG{?y_o ?u"?zG{?|??E?_o ?y_o ?v+I?ku%F?nOv_ح?3*0U2am}H˒?fOv_خ?n/?nO;?y_o ?l1&y?fǿwXe+?[Q_q4J?,<?sPH?xPH?쿱[W??u%F?=K]?+I?q4J?*0
?c*0U2a?_o?vOv_خeL_?O
M?O
M?)^	?+?ᰉ'?L_?ɅoiD?A        ?nO;?v+I?xtj~?u%F
?~Ov_ح?{qu!S?j6C-?S*0U2a?l!-w?>B?T`dku%F?S&?@NU?@NUeL_pbMie+a?nOv_ح?IQ?tn        ?_!-w1ſ*6C-?gvǿ[Q_?N;5?HwXe+Կrn/?ɅoiD?O
M?:)y?n/?6C-?rnO;?-
qveL_?Ov_خ?Fs?{u%F?rnO;?Z?s*0U2a?ku%FnOv_ح?l1&ys@NUrnO;?{qu!S?v+IbsPH?:)y?Fs?|1&yku%F?qu"?tzG{?usg?tj~?0
(?<64?S?l!-w?kQ_Rn/?u%F
?6C-?s@NUbsPH?s@NUie+a?uL_?tzG{?xtj~?$tSM?~Ov_ح?A?xtj~uL_?V?nOv_حa4J?{qu!S?䎊q?v?$/?N;6?nO;?xPH?)^	kQ_?kQ_?bM?tj~?{u%F?zG{?p:?zvȴ9?qu!S?tj?Q?҈?$tS?tzG{f?<64?bM?{qu!S?xtj~htj~?tn?Xe?Ϫ͞?fA?=K]?PbM?:6C-?4J?	 ?+jg?}H˒J6C-?o䎊q޿nOv_حku%F?s*0U2ao䎊q?p)^	c*0U2a?kQ_?tZ?ye+a?q4J@bMrsPHie+a?@bM?rsPHPbM?pbMm}H˒?:)y?nO;q4Jm}H˒?*0U2a?zG{?u"?}}H˒V?j6C-?u%?sg?Z?qu!S?!-w1?vȴ9?sg?E?u"??Ϫ͞?L_?$/?E?L_?E?}Z?}}H˒?tj~?@NU?*0U2a?-
qv??쿱[W??ɅoiD?u%F?6C-?e+?&?$tSM?u"?uL_dzG{?bM?n/?*0?O
M?Zc*0U2a?u%?sPH??<64?tj~?qu!S?	 ?ᰉ'?u%F?D*0?xtj~?xtj~?tzG{eL_?}Z?T`die+a?>6z?vȴ9?},<?4J?)^	?[Q_6C-??H?bM?o!-w1ſtzG{eL_?ye+a]}H˒?tZo䎊q?{?Z?}}H˒?҈?Xe?-V?:6C-?O
M?Z?g?@bM?vȴ9C*0U2a?ie+a_!-w1?䎊rVǿa4J?u"?ݗ+j?Q_p?쿱[W??>BZc?dzG{?+I?!-w1?}}H˒?҈?	 ?{u%F?|C,zxl?xtj~?{Q_?{u%F?sPH?:)y?zvȴ9l1&y?{Q_?}}H˒?{Q_*6C-?f?}Z?|C,zxl?{qu!S?ߤ??4J?rsPHUL_?-
qv?nOv_حfOv_خ?xtj~?n?E?E?@NU?-
qv?{?Fs?xtj~@bM?a4J?-
qv?Z6C-        ?U=K?N;5XV?wXe+Կusgj6C-?z6C-?n?ᰉ'?䎊r?҈?҈?{?=K^?_Ft*6C-?[Q_?N;5?	 ?	 ?u"?x*0
?Xtj~?4JRn/?Zݘ?=K^?*0?fA?Ov_خ3*0U2arsPH?w?4J?C,zxl?ߤ??>BZc?Q_?sg?ᰉ'?䎊r?-
qv?n?+I?>BZcrsPH?m}H˒?<64?u%??@bM?bsPH?~Q?:6C-?PbM?j6C-?*6C-?_o ?%2[Q_?},<?sg?*0?2a|Q?O
M?Zݘ?zG{?N;5?n/?n?{?tn?Z6C-*6C-?Z6C-?{u%F?x*0
?ye+a?҈?@NU?{Q_bsPH?rn/s@NU?n/?ɅoiD?Fs?y_o [Q_?$/?$/?PH?S&?_Ft?䎊q?*0
?L_?Qc*0U2a?:)y?L_?R<64?>BZc?*6C-?rn/?҈?q?wXe+ԿrnO;o䎊q?IQ?䎊qj?o?tj?S&?nO;??,<?vȴ9X?>BZc?|1&y?{qu!S??{u%FpbMfOv_خ?wXe+ԿM}H˒?Zݘ?4J?{qu!S?zvȴ9?Q?fOv_خ?eL_?z6C-?{Q_?u%F?u"?-
qv?!-w1?ye+a?wXe+Կg?xPHqu"?~Ov_ح?+?ᰉ'?ᰉ'?tj?2W?wkP?e+a?V?Xtj~?	 ?bM?},<?qu"]}H˒?vǿf?~Ov_ح?S&?+j?Q?
=p
??4J?0
(?hr Ĝ?}H˒?Ϫ͞?fA?Z?sPH?L_?Ha4J?l?bM?4J?*0?ᰉ'?ᰉ'?ᰉ'?sg?qu"?e+a?e+a?%2?tj~?vOv_خ?H?+jg?ɅoiD?*0?N;5Xrn/vOv_خv+Iq4J?vOv_خ?l?+j?+J?fA?tnkQ_?$tS?_o ?ᰉ'?@?2a|Q?
=p
?1&M}H˒?Fs?O
M?҈?Mj?=K]?tj~?ye+a?zvȴ9?{?O
M?kP{?:6C-[Q_?PH?sg?p:?)^	?ie+au%F
?tzG{?z6C-?hr Ĝ?Zݘ?zG{?ᰉ'?Ϫ͞?6?4J?UL_p)^	J6C-?!-w1?eL_Rn/?@NU?S&?$tS?Ov_خ?}H˒?*0?ݗ+j?nO;?*0?l1&y?dzG{?ye+a?H?1&?Q_p?U=K?vȴ9X?&?xtj~?hr Ĝ?@NU?hr Ĝ?҈?҈?+?2a|Q?E?Ϫ͞?=K^??wkP?u!?1&y?u%?u%F
?}H˒ku%Fbn/?sg?S&?Fs?u%F?L_?n?+j?ᰉ'?nbsPH?䎊q?S&?ߤ??zG{?x*0
?O
M?O
M?E?Ϫ͞?S&?hr Ĝ?qu!S?*0?bM?xtj~?N;5X?n?&?_Ft?PH?hr Ĝ?}}H˒?~Q?eL_        ?䎊q?qu"l1&ykQ_?-
qv?}ZZ6C-?4J?	 ?}}H˒?)^	?fA?q4Jv+IvǿbsPH??l!-w?zvȴ9?xtj~?nOv_حkQ_?$tS?E?fA?*0?A?bM?Xe?Xe+?|C,zxl?䎊q?$/?vȴ9X?dzG{:6C-?N;5?N;5?N;5?+jg?+?6C-?tj~?1&y?S*0U2a?o!-w1?%2?Mj?n?n/?rsPH?-
qv?hr Ĝ?*0?f?Zݘ?>6z?N;5?b}V?N;5??$/?S*0U2a?u"?qu!S?쿱[W??U=?rnO;?4J?	 ?2a|Q?hr Ĝ?`d8?|C,zxl]}H˒?쿱[W???+I?H?A?+I?Xe+?x*0
?$tSM?|??zvȴ9?6C-?Z?@?zG{?ie+a?_o ?+I?@NU?0
(?ɅoiD?zG{?Rn/?O
M??6C-?=K]?}Z?	 ?u%F?C,zxl?},<?{Q_?S&?nO;?Xe+?~Q?IQ?T`d?Z?-V?	 ??sg?u"?bn/?tj~?_o ?tj~?Q?u"?䎊q?bM?$/                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ??????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????ə????????????????????????????????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          &BAU332                                       1                                       