CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20120522   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P5     CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:47.918675Z    ORIGINAL_HEADER      sCTD,20250210CCHSIOWB
#Renamed 'CTDFLUOR_TSG' to 'CTDFLUOR_ALT_1' with units 'MG/M^3'
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2018-11-29. CTD data from cruise 18DD20120522, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20120522. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2012-12/index.php. 
#
# The information in this file for the cruise 2012-12 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-0072.ctd
#
# Start of originator file comment header
#
#*2018/11/29 14:22:51.16
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2012/06/01 08:02:46.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 2006
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : C44EDC1F
#    NUMBER OF CHANNELS  : 9
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            2.3            2006.7
#       2 Temperature:CTD               deg_C_(ITS90)   1.9166         6.6907
#       3 Salinity:CTD                  PSS-78          32.6639        34.5892
#       4 Sigma-t:CTD                   kg/m^3          25.6458        27.6748
#       5 Transmissivity:CTD            %/m             61.4           67.9
#       6 Oxygen:Dissolved:CTD:Volume   ml/l            0.41           7.23
#       7 Oxygen:Dissolved:CTD:Mass     µmol/kg         17.9           314.7
#       8 Fluorescence:CTD:Seapoint     mg/m^3          0.24E-01       0.74
#       9 Fluorescence:CTD:Wetlabs      mg/m^3          0.102          1.096
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        6  F       ' '     1
#       6  -99   ' '        7  F       ' '     2
#       7  -99   ' '        6  F       ' '     1
#       8  -99   ' '        8  F       ' '     3
#       9  -99   ' '        8  F       ' '     3
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2012-12
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P24
#    EVENT NUMBER        : 72
#    LATITUDE            :  49  50.17000 N  ! (deg min)
#    LONGITUDE           : 142  40.04000 W  ! (deg min)
#    WATER DEPTH         : 3989
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    CTDEDIT was used to remove surface records and records corrupted by shed
#	wakes; salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Transmissivity, Fluorescence and PAR data are nominal and unedited except
#	that some records were removed in editing temperature and salinity.
#
#    For details on how the transmissivity calibration parameters were calculated
#	see the document Transmissivity_Calculation.pdf.
#
#    The Oxygen:Dissolved:CTD calibration was done using the method described in 
#	the Sea-Bird Application Note #64-2 (Sea-Bird_64-2_Jun2012.pdf).
#
#    The Oxygen:Dissolved:CTD data are considered, roughly, to be:
#	±0.1 ml/l from 0 to 125 dbar.
#	±0.06 ml/l from 125 to 500 dbar.
#	±0.04 ml/l from 500 to 2000 dbar.
#	±0.02 ml/l below 2000 dbar.
#
#    For details on the processing see processing report: 2012-12-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5-- --6--- --7-- ---8--- ---9---
#!Pressu Temperat Salinity Sigma-t: Trans Oxygen Oxyge Fluores Fluores
#!re:CTD ure:CTD  :CTD     CTD      missi :Disso n:Dis cence:  cence: 
#!                                  vity: lved:  solve CTD:    CTD:   
#!                                  CTD   CTD:   d:CTD Seapoin Wetlabs
#!                                        Volume :Mass t              
#!------ -------- -------- -------- ----- ------ ----- ------- -------
#*END OF HEADER
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @3         data_max      @3         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     >   .    pressure                	long_name         pressure   positive      down   units         decibar    data_min      @   data_max      @Xfffff   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      >   l@   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d        `   temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?ᰉ   data_max      @%e+   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       >      temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d           salinity                	long_name         salinity   units         PSS-78     data_min      @?A   data_max      @AKE   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      >     salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d       E   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @!   data_max      @sp        C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        >  U8   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d       X   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?S   data_max      @/S   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      >     CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d           PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       >     PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d       .   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min      @C   data_max      @P33333   C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     >  >0   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d       |P   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         (    cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         (     time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min         data_max         C_format      %10d       (   latitude               	long_name         latitude   units         	degrees_N      data_min      @HX~   data_max      @HX~   C_format      %9.4f          ,   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      _ʥP   data_max      _ʥP   C_format      %9.4f          0   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d        4   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min        b   data_max        b   C_format      %4d        8@3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @3      @@ffffff@@      @@!@$      @&333333@(      @*      @,      @.      @0      @1      @2      @3@3@5@6      @7      @8      @9      @:      @;      @<      @=      @=@?      @@      @@     @A      @As33333@B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @I33333@J@K      @K     @L      @Ls33333@L33333@M     @N      @Nffffff@O@O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @Rs33333@Rfffff@S      @S@     @S     @S     @T      @TFfffff@T     @T     @U      @U@     @U     @Ufffff@V      @V@     @V     @V     @W      @WFfffff@W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^y@^     @_      @_@     @_     @_     @_33333@`@`@     @``     @`     @`     @`ə@`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b@b@     @b`     @b     @b     @b     @b     @b@c@c@     @c`     @c     @c@c     @c     @d      @d      @d@     @dc33333@d     @d     @d     @d     @e      @e      @e@     @e`     @e|@e     @e     @e     @f      @f#33333@fC33333@f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i#33333@i<@i`     @i     @i     @i     @i     @ifffff@j,@j@     @j`     @j     @j     @j33333@j     @k@k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l33333@l@l@m      @m@     @m`     @m     @m     @m陙@n      @n      @n@     @n`     @n     @n     @n     @n@o      @o      @o@     @o`     @o     @offfff@o@o     @p      @p     @p      @p0     @p@     @pQ@pa@pp     @p     @p     @p     @p     @p     @p     @p     @p33333@q      @q     @q      @q0     @q@     @qP     @q\@qt@q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rq@rfffff@rfffff@r     @r     @r     @r     @rfffff@r@s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t.fffff@t@     @tP     @t`     @tp     @t     @t     @t@t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u33333@u     @u     @v      @v     @v      @v0     @vA@vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|@|33333@|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}A@}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~@~@~љ@~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @ffffff@p@x     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @u@@     @     @     @     @     @     @     @     @     @33333@33333@     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @@@     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @@     @     @      @     @     @     @      @(     @0     @8     @<@K33333@P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@@     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @@@@     @     @     @     @     @     @     @@     @     @     @     @     @      @     @     @     @      @(     @0     @8     @?33333@H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @ @(     @0     @8     @@     @H     @P     @X     @`     @i@p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @33333@33333@     @     @     @     @     @     @     @     @     @     @     @@33333@     @     @      @(     @0     @8     @@     @H     @Nfffff@Zfffff@a@h     @p     @x     @     @     @     @     @33333@@     @     @     @     @     @     @     @     @@     @     @     @     @      @(     @0     @8     @@     @H     @P     @[33333@`     @h     @p     @x     @     @     @     @     @     @@@     @     @     @     @     @     @     @     @     @33333@     @     @     @      @(     @0     @8     @@     @Q@X     @`     @h     @p     @x     @     @     @@@     @     @     @     @     @     @     @     @ݙ@fffff@     @     @      @     @     @     @      @(     @0     @6fffff@Bfffff@H     @P     @X     @`     @h     @p     @x     @     @     @33333@@     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @fffff@@      @$     @(     @,     @0     @4     @8     @<     @@fffff@D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@33333@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @dfffff@i@l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @#@(     @,     @0     @4     @8     @<     @@     @D     @H     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<fffff@?@D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @@@     @     @     @     @     @     @     @     @33333@33333@     @     @     @     @     @     @     @33333@33333@     @     @     @      @     @     @     @     @     @     @     @@#@(     @,     @0     @4     @8     @<     @@     @C@I33333@L     @P     @T     @X     @\     @`     @d     @hfffff@jfffff@pfffff@t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@fffff@     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @^fffff@dfffff@h     @l     @p     @t     @x     @|     @     @33333@33333@     @     @     @     @     @     @     @     @@33333@     @     @     @     @     @     @     @     @ә@33333@     @     @     @     @     @     @     @     @@fffff@     @     @     @     @     @     @      @$     @(fffff@0     @4     @8     @<     @@     @D     @H     @L     @P     @S33333@X@\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @@     @     @     @     @     @     @     @     @33333@@     @     @     @     @     @     @     @     @33333@fffff@     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @Tfffff@W33333@\fffff@`     @d     @h     @l     @p     @t     @x     @|     @@     @     @     @     @     @     @     @     @@@     @     @     @     @     @     @     @33333@@     @     @     @     @     @     @     @     @     @fffff@     @     @      @     @     @     @     @     @     @@!33333@$     @(     @,     @0     @4     @8     @;33333@A33333@D     @H     @L     @P     @T     @X     @\     @a33333@d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@˙@     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @fffff@      @$     @(     @,     @0     @4     @8     @<     @@     @D     @Hfffff@Jfffff@Q@T     @X     @\     @`     @dfffff@h     @l     @p     @y33333@|     @     @     @     @     @     @     @@fffff@     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @/33333@4fffff@8     @<     @@     @D     @H     @L     @P     @S@Xfffff@\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@@     @     @     @     @     @@ fffff@fffff@     @     @     @     @     @      @$     @'33333@4@8     @<     @@     @D     @H     @Lfffff@N     @Tfffff@X     @\     @`     @d     @h     @l     @p     @t     @w@|     @     @     @     @     @     @     @@33333@     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @@$fffff@(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @@     @     @     @      @     @     @     @@33333@     @     @      @$     @(     @,fffff@/33333@4@8     @<     @@     @D     @H     @L     @O33333@T     @X     @\     @`     @d     @h     @l     @pfffff@s@x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @fffff@     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @Pfffff@S@X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@33333@fffff@@     @     @     @      @     @     @     @     @@@     @      @$     @(     @,     @0     @4     @8     @<     @H     @L     @P     @T     @Xfffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @%e+@%cA @%Ʌoi@%
(@%H@%T@%C@%Dg8~@%S@%3@%IQ@%q@%v@%Z^5?|@%GK]d@%:vȴ@%4!-w2@%[@%-
q@$	k~@%-@$@$fA@$g+I@$H˒:*@$GK]d@$O@$|@#*0U2@#$@#V}Vl@#j~@"xbM@"m(@">҈p;@!`d@!l"h	@!cA \@!oiDg@!a|Q@!S@!0{@!bM@ 
qv@ Q@ M@ (\@ U2a|@ ʳg	@ 쿱[@ 4֡a@ @ x@ n@ {/V@ l[W?@ NMj@ Be+@ ,zxl"@ ($xG@ ߤ@@ m8@ fffff@H˒:@,@H˒:@zS&@oVϫ@5!.@4J@{J#9@<?@-\@ce@+@C@yD@'8}H@@
qv@TɅo@]ce@H˒:@m(@O
M;@)rGE@5Xy@C\@!-w@C\@\(@N;5@5'0@Eݗ@L_@l!-@"`@`ěT@+a@MjOv@@B@"`B@8)@L/{J#@U*0@	oiD@Vu@ [7@-
q@H@k~(@}H˒@&IR@H˒:@ATɅo@84֡@
M;@Ƨ-@O;@9Xb@MjO@hr@1@m\@1&y@׍O;d@&@K]c@Ov_@tSM@kP@+C,z@u"@
@%F
L@@R<6@vȴ9@o@Q@,=@5?|@Q@ߤ@@Vu@|쿱[@~6z@glC@Q4J@NT@Mqu"@Dg8}@EQ@Gݗ+@K:)z@Eݗ@=H˒@-C\@'RT`e@-V@	@%2@j~#@
=q@'@4m9@.2@L/{J@u!@sPH@@T@/{J#@q@{J#9@uXy=@l<쿱@dTɆ@_!-w1@Zvȴ@8YJ@+j@p:~@PH@nO@dZ@_ح@Z1@#9@?@7Kƨ@}!.H@vE@q-@]+j@Vl!-@TFs@RsP@KxF]@Eݗ@@C@=E@5\(@.c	@,[W?@)*0U2a@%O
@#9@@Mj@sP@N;6@rGE9@+@ߤ?@qi@;5X@
@
:@cA \@҈@
n@	'RTa@˒:*@s@Xy=@o@1@a@@@,@㢜wk@ރ%@Q@y=c@ěS@Xy=@/@+j@>6z@jOv@~m\@{s@{s@yrGE8@v}Vl@qA [@m
qv@ffffff@]-V@Yb}@N!R<@Eݗ@>6z@64K@1&@&IR@2W@Ϫ͟@1@S@>@#@SMj@*0
@Ov_خ@"@A [@/V@kP|@ˬq@/V@!R@Fs@TɅ@O;dZ@+I@o h@NU@|hr@xQ@sg@qiB@p:~ @l[W?@_حV@Vaf@Np:~@JD@HeO@E@C$@A [7@>vȴ9X@<Q@7kP@4#@2GE85@1&x@0D@0'RT@0'RT@0D@1&x@12W@2 ě@2m\@2䎊q@3PH@333333@.1@$7@Ov_خ@-V@tj@l!-@ᰉ@*1@-
q@
@
D@-@,zxl@~@'RT@U=@ܬ1&@ξߤ?@
L/@ ě@/@q@t@Mj@^5?}@zS&@x4֡b@wrG@vFs@nc	@h@[=K^@JL/{@C\N@2W@kP|@2W@ⶮ}Vm@䎊r@ٙ@ڹY@PH@]ce@-w1@e@1@唯O
@&@y@\)@-@F
L0@[@As@7KƧ@}H@r ě@G#@2s@$/@1&@!R<@~$@"h	ԕ@hr!@I^@!-w2@!R<@RT`e@H@}Vl@IQ@ߤ@(@S@o@hr @\(@w1@\C,zx@T,<@WsPH@l>B[@)^@o hۋ@F&I@:xl"h
@CF]c@Y>BZ@W@Qhr @LI^5?@JW'@Do h@:)y@5!.@,q@حV@$tT@eں@,=@t@ңS&@ѷX@v_ح@ˬq@cA \@Ϫ͞@,<@$tT@ˬq@@̈́M:@Fs@`A7L@0
@x@.H@`A7L@Z1@ڹY@āo h@!R@j~@SMj@E@2W@[W>6@u!S@A [@U2a|@-V@}Vl@
qv@&@Xe,@qiC@t֡a@U*0@;A@6ȴ9X@5Xy=@4J@1o@1iB@;/V@<?@=K]@B@4n@F&I@HK]c@Fs@&@',@C@KxF]@"wkQ@_o @_o@hr @@Fs@W'@qiC@7KƧ@JM@oiDg@YJ@F]c@ѷX@ʦL/{@Xe,@@Ж@L_@qiC@TɅo@)_@/V@sg@Xy=@YJ@!R@v@[W?@a@@͞&@^@A [@	@حV@R<6@xF]@6@uXy=@o@g8}H@Y_o@VOv_@R<64@Oo @N_o @N!R<@Oo @O@NT@K:)z@JL_@HK]c@Fs@FFs@H9Xb@G_o@@6@<#x@,"h	ԕ@!-w1@%@iB@(\@u%F@>BZ@_o@y=c@l!-@$tS@+@-
q@F]c@m\@+@xl"h
@o h@
5Xy>@ᰉ@O;d@ A7K@@     @E84֡@<?@@IQ@ao@\]ce@Q4J@L@Vt@XbM@QN;5@NMj@OrGE9@QN;6@RnO@S@UϪ͞@VOv_@TZ@P)^@JqiC@Hu%F@Gy@B\(@8F@4D@49XbN@0:~ @'	k@IQ@b}@_o @	oiD@@4K@ae@\N@>B@XbM@F]d@j~@U2a|@ ě@PH@ěS@Zc@]cf@C%@nP@[W>@:S@2W@g8}@F]c@NU@2X@(@U=@[W?@~"@1.@u"@=K@*1@Fs@a@O@v_ح@E84@rᰊ@g	k@b`A@`	k@a-w1@aGz@aR<6@ae@bh	ԕ@be+@bh	ԕ@c	@b}Vm@b3@ae@`u!@\1&@Y|@X*0@W@WO;d@W+j@WXe,@Uᰉ@M5Xy>@I@I^5?}@H@F-@A$/@>ߤ?@>vȴ9X@>BZc @<?@;J#9@9D@8F@7Xe@1[W>6@(r Ĝ@%zxl"h@ u!@-V@6@_o@@n@@s@Zc@b}V@Z@A@/V@xl"h
@D@73@+@1@E@%F
L@Y|@\(@?@\(@֡a@33333@l@Vϫ@ hۋ@zG@쿱[W?@Q@A@JE@֡af@l!-@fA@҉@|@L_@@g8}@p
=@/V@-
@C-@!.@MjO@I^@x@rGE@\)@@C,@Gz@U=@N;@=K^@1'@_o@Ov_@ݗ+k@{@]cA@@@JM@n.@{5Xy@t֡a@r ě@p
=q@n1@mV@j0U2a|@eڹ@c9@[$@V@S@Rn@QN;5@M5Xy>@H˒:*@FYJ@=v@5%F
L@2-V@1A [@/O
M@,C@($xG@'@"M@%@,=@Q@u%@>BZ@l!-@H@]cf@:S@ n@($x@S&@3@!-w@L/{J@9@҈p@U=@5?|@6@և+J@m@n@@@Q@\(@     @j~#@s@C\@Y}@)y@^5?|@-
@C-@֡a@
(@\@6z@fB@fB@0
@\)@RT`e@@%1@e@	k@'RT`@?@Ov_@=K@`d@N;5@
M;@I^5?@]cA@'RTa@S@[W>@|?@v4K@lzxl"@j0U2a|@e1@\ߤ@@Y0
)@S*0U2@MjOv@H˒:*@Fs@C@A:S@?|hs@>
(@=H˒@=v@=Vl!@:^5?|@8-
@6Fs@1iB@+a@@+a@@,1&y@,<쿱@,1&y@*͞&@)y@(r Ĝ@'&@&x@$7@"3@5?|@"`B@JE@O;d@
qu"@@zH@s@S@!-w@As@2W@Q@{J#:@6z@6z@TɅ@zxl"h@'RT`@0
)@o @@nP@~($x@xF@v!.I@r䎊q@cZ@XD*@R<64@O͞@D*0@?[W>@=K]@8)@6C-@1&x@',@u"@#@ ѷ@ IQ@l"h	@SMj@ hۋ@fA@@@4@
qu@6@1'@@>6z@ԕ*1@ěS@
(@<64@p
=@p
=@<64@p
=@<64@Z@)_@#w@3@z@g	l@
qv@@/V@n.3@-
q@}H˒@t!-w2@nc	@[$@XD*@RT`d@GE84@As@=b@8YJ@43@.}Vl@[@L_@
(@@
($x@
	k~@
(@
"`@
C\@
@
!.I@
{m@
	ԕ+@
ڹ@
ᰉ'R@
]ce@
ڹY@
H@
@
т@
ȴ9Xb@
,zxl@
Q@
'RT@
^@
&@
[@
_o@
@
Fs@
+I@
S&@
Q@
&I@
I^5@
}Vl!@
zC\@
x73@
vȴ9X@
t#@
o hۋ@
kP{@
de@
`u!@
\>@
Y|@
XU@
P{@
Ca@N@
?@
>6z@
=p
=@
6C-@
.2X@
*0U2a|@
(\)@
%F
L0@
#S&@
	@
@
Ov_@
*0U2@
N;6@
M:@"@@SMj@@	ԕ+@@쿱[W?@C,z@%1@҈p@o@2a|@jOv@g8}@3@1@&@'RT`@[@e+a@+J@)^@ߤ?@(@@$/@~"@vȴ9X@v+jg@v_ح@v!.I@qu!S@jOv`@`d8@Xy=c@Rp:@O͞@MjOv@E84֡@?[W>@?H˒:@9D@1o@#S&@ 'RT`@!-w1@쿱[W@Q@Ov_خ@u@IQ@IQ@,<@tj@@L_@)^@
=p
@tj@E@C\@D@빌~($@ⶮ}Vm@ݗ+j@t@@#w@m\@B@x@vȴ9@C%@ ѷ@{J#9@v!.I@t#@r䎊q@nO;@l"h	ԕ@hr Ĝ@de@[6@Y>BZ@W&@Vt@T,<@JD@Dg8}@A [7@=K]@=K]@<64@5?|h@1&x@0
(@0 ě@/r@)lD@'&@쿱[W@~($x@I^5?@!R<@'/W@qi@
qu"@
=p
@o h@
$t@
E@
-V@
iDg8@
(@
ᰉ'@
r Ĝ@
A@
C,@
5?|@
fA@
T`d@
@
Ƨ@
D@
˒:*@
m\@
@
s@
K]@
?@
33333@
H@
*0U2a@
TɆ@
3@
,=@
$/@
rGE9@
u%F@
|PH@
wkP@
tSMj@
kC,z@
aGz@
Y>BZ@
Y+@
W&@
W>6z@
W
=p@
W
=p@
WsPH@
W>6z@
Vl!-@
Vt@
TɅoi@
T,<@
Sa@O@
RT`d@
N+@
Ov_ح@
OAs@
M5Xy>@
LcA \@
GzH@
BZc@
<n.@
0U2a|@
!ae@
ߤ@@
'/W@

ڹY@
'/@
'/@

	 @
Q@
@	˒:)@	~$@	쿱[W?@	+a@	l!-@	а{@	W'@	7Kƨ@	Q@	Xy=@	?|h@	g	l@	&x@	O
M@	>B[@	d7@	'@	wk@	`A@	Ov_خ@	=K^@	u%F@	@	u%F@	?@	{m]@	oiDg8@	k~($@	ix@	d7@	`d8@	[W>6z@	UϪ͞@	P*0U@	J#9@	C\N@	;/V@	64K@	43@	/Vϫ@	)y@	&'@	&@	%F
L0@	"3@	qu!@	rGE9@	
=p
@	 ѷX@ڹZ@G{@Fs@D@u!S@x@lC@+a@`A7L@C,@Ft@+@Ϫ͟@՛=K@N;5@5Xy>@y@@#w@}Vl@'0@g	l@r@U=@q@0U2a|@@/V@x@?@9@ěT@U=@qu!@M:@?@~($x@}Vl!@xl"h	@u!R@tSMj@p@mC\@e@Zc	@W
=p@T,<@NT@I^5?}@G@@G)^@F-@Fs@F
L/@B&IR@:~@4J@-V@u"@qi@
(@҈@F@!R@D@{m@JL@$@ҽ<64@;dZ@5Xy>@Q@@@s@^5?|@'0@U2a|@q@@F
L0@[@O
M@o @qu"@1&x@ݗ@tj@~$t@t!-w2@o-V@k~($@h	ԕ+@d%1@^҈p;@Z1'@XbM@Vt@R<64@M5Xy>@JW'@H@HK]c@E8YK@A7Kƨ@?H˒:@>BZc @<쿱[@8}H@6}Vl@3|@/{J#:@)@)y@(Xy=@&IQ@#9@sh@ߤ?@@@4n@$/@Vl!@Y|@쿱[W?@ce@т@ [7@n@ߤ?@K]@p
=@vȴ9X@@6@NU@[W>@vȴ9X@XbM@'0@|@@'@L/{J@xF@	k@[6@'RT`@Ov_خ@Ov_خ@u@wkP@sP@Vu@K]d@ݗ@M:@{J#9@I^5@b}V@xF]d@sPH@poiDg8@p@l!-w@iDg8~@g8}H@f1.@e`A7L@dqj@e+a@d7@d7@e+a@e@f1.@dqj@ceO@`u!@^҈p;@_?@Zݘ@VϪ͟@UfA@P`A7@E8YK@=<64@6z@43@4m8@6E@64K@3|@2ᰊ@1o@/Vϫ@*͞&@($xG@'RT`e@'RT`e@&'@%S@$?@vȴ9@}H@u"@C,zx@kP|@tj@+J@@N@u@'/W@
@'/@	k~(@	7KƧ@	 ѷ@1&x@oiDg@ 4m9@-
@D@!-w2@oiDg8@!-w@ᰉ'@fA@A@A [@ߤ?@cA @>@b}@fA@W'@
(@XbM@YJ@#w@Q@4K@a|Q@'RT@y@-V@kP|@_o@Xe,@@-
q@4m9@wkP@v_ح@poiDg8@iDg8~@d7@Y|@RT`d@Ov_ح@O͞@MjOv@IQ@C\N@?@:~@9#w@64K@0'RT@L_@#x@Fs@@.2@
=q@c	@	k@eO@䎊qj@cA @+@;dZ@Q@U2a|@IQ@u@vȴ@@@N@@1&x@$/@oiDg@n/@?@o h@o h@tj@F]c@ѷX@yrGE8@s@iB@e`A7L@XU@U2a|@SZ@Ov_ح@L/{J#@K]cA@H@:)y@-V@*0U2a|@)y@%1@"wkQ@!R<6@ [6@Q@=K^@0
)@Z@ݗ+k@sP@n@)^@rGE9@YJ@Vl!@#@{m@u!S@oiDg8@c	@VϪ@Dg8~@Z@S@"`B@,<@m@т@`A7@ΤT@@o i@Õ$@@H˒:@~($@3@֡a@
(@/V@IQ@@IQ@xF]d@tD@rGE85@qiB@gfA@`A7K@VϪ͟@:)_@.H@&IQ@#wk@ 	k@6C@tj~@)^@4J@Mj@@~($x@
qiC@	 ѷ@_o@+I@+I@+I@&I@$/@n/@M:@ hۋq@~$@=b@
=q@ⶮ}Vm@2a|@jOv@n@š@@H˒:@b@K]@YJ@E@3@y@9@Q@6C@tj@$/@qu"@'RTa@@YJ@n/@n.@~"@$tS@     @r䎊q@sMjO@t!-w2@sE@sg@tSMj@p
=q@ae@\>@[W>6z@Z1'@Yb}@Xy=c@V8YJ@UfA@S@Rp:@Q@P{@C@=<64@;5Xy@<64@<64@;A@:)_@:S&@9Y}@9Y}@9~($@84֡b@7KƧ@7Xe@5Xy=@3ߤ@0 ě@/v@.zG@,>B[@+6z@'-@#wk@!R<6@Q@vȴ@,<@,<@Xe,@$/@ݗ+k@@N@n@u@)^@
@҈@xF]@	7KƧ@u%F@@@b}V@\N<@E@\N<@\N<@H˒@!.H@Q@G{@F@%F
L@SMj@A [@iDg8@VϪ@%1@ܑN;@)^@7Kƨ@6@2W@&IR@Q@Xy=@sg@֡a@4K@5Xy@j~#@n.@)y@Y}@#w@4֡b@D@S&@)y@^5?|@^5?|@S&@S&@S&@^5?|@)y@D@rG@֡a@'0@}H@rG@m8@a|Q@g	l@g	l@H@-@/@xF@S&@3@-w1@!-w1@!-w1@U=@vȴ9@䎊r@'RT`@䎊r@쿱[W@,=@wkP@=K^@vȴ@_o@Xe,@@qi@q@I^5?@L_@#@&I@?@@rGE85@p@d%1@a'R@QN;5@OAs@M%@F?@>vȴ9X@7Xe@3|@2m\@1o@/Vϫ@/r@/Vϫ@/Vϫ@/Vϫ@0 ě@0U2a|@.1@-B@,q@*0
@(TɅ@(@(Xy=@'&@$?@@ b}V@ m\@ ($x@ m]@ x@ ҈p;@ t@ _p@ Ϫ͞@ 
M;@ ΤT@ _o @ ̘_@ Ƨ@ ]cA@ ɺ^5?}@ ɅoiD@ #9@ #9@ ȴ9Xb@ ǮzH@ g8}@ &IR@ TɅo@ 64@ Z@ K]@ v@ <64@ 64@ ~($@ z@ ?@ |@ $xG@ @ @ S@ wkQ@ vȴ9@ C,zx@ S@ S@ kP|@ @ _F@ +J@ Z@ zG@ *0U2@ $tT@ ڹY@      @ weں@ uY|@ t!-w2@ sPH@ sPH@ sMjO@ rs@ rs@ rs@ qA [@ poiDg8@ oiDg8@ oiDg8@ o-V@ oiDg8@ mC\@ mC\@ mC\@ l"h	ԕ@ jJL@ ix@ iB@ ix@ iDg8~@ irGE@ h@ gfA@ g	k@ f,<@ c	@ b}Vm@ b@4@ a'R@ ae@ a|Q@ _;dZ@ ]ce@ \]ce@ \(\@ Y+@ W&@ Xe+@ XU@ UϪ͞@ Rm@ Sa@O@ U2a|@ T*1@ U2a|@ TɅoi@ TɅoi@ U2a|@ T`d@ TE@ TE@ TE@ Sa@O@ MjOv@ KƧ@ IQ@ H@ B\(@ @C@ A7Kƨ@ ?@ ?@ >BZc @ >BZc @ =b@ =b@ =<64@ =p
=@ =K]@ 84֡b@ 5'0@ 1o@ 0'RT@ ,<쿱@ +a@@ )@ ',@ #S&@ U=@ u"@ 4J@ 
qu"@ u%F@ S&@ ?@ ?@ o h@ tj@ M:@ F]c@ u%F
@ ?$tS?-
?73?MjO?-V?4֡a?C\?쿱[W??x??ڹY?Q_?p:~?m\?H˒:?Y}?[W>6?'RT?d7?'???	k?-V?-V?IQ?kP|?@?ᰉ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @?A@?@?!.I@?@?Fs@?Fs@?Fs@?lC@?K]d@?}H@?TɅ@?)^	@?R<6@?E@?s@?&@?	k~@?lC@?t@@~@@
nO@@+j@@1&@@`d@@%2@@ݗ@@JE@@RT`e@@%cA @@(ěT@@/rG@@?'/W@@Qo@@S=K^@@TSMj@@TC@@T]ce@@Tj~#@@To h@@Tj~#@@TwkP@@Tq@@T~($x@@T*1@@TC@@T*1@@T?@@T7@@T[W?@@T@@T#x@@TwkP@@TZ1@@TVϪ@@Tq@@TN;@@TTɆ@@TN;@@T[W?@@T7@@T>B[@@TJM@@TJM@@Te@@U/w@@Uu@@UV@@U?|h@@U@@UC\@@V$/@@Vc	@@V\N<@@V_ح@@V}Vl@@VFs@@Vaf@@V@@Vs@@VO;@@W
=p@@W hۋ@@WFt@@Wv@@WKƧ@@Wr@@Wݗ+@@W-@@Xۋq
@@Ys@@[nP@@_\(@@bW'@@dSMj@@j ѷ@@p$xG@@rnO@@xtj@@ae@@u%F@@*1@@[6@@PH@@@@6@@@@҈p@@H˒@@4J@@`A@@jf@@xF@@8YK@@rGE@@9@@Y|@@@@:S@@Ĺ#x@@Vϫ@@ ѷ@@ˋq@@ѷX@@n.3@@g@@ԥzxl"@@l!-@@ָQ@@ם-V@@-w1@@!-w@@cA @@	k~@@&IR@@a|Q@@S&@@Z@@C]@@J@@@@,<@@_@@'0@@垃%@@?@@v@@䎊r@@A [@@o@@y@@Ov`@@~"@@@4@@S&@@S&@@'/@@dZ@@g8}@@sg@@M:@@=K@@n/@@,=@@p:~@@T@@ߤ?@@+@@+I@@\(@@4m@@阮&@@˒:)@@rG@@@@}H@@@@@TɅo@@o@@y@@iB@@>BZ@@h	ԕ@@W@@fB@@@N@@%2@@Q@@%1@@m8@@7@@Ʌoi@@Z@@JM@@'0@@!.H@@}H@@M:@@M:@@ڹZ@@1@@@@
qv@@!.@@u@@.2@@Vu@@c	@@p:~@@+J@@6z@@}Vl@@'@@Q@@&I@@&I@@&I@@&I@@&I@@m\@@ȴ9X@@t@@҈p;@@Ϫ͟@@]cf@@C-@@
=p@@8}H@@KƧ@@U=@@iDg8@@sPH@@|hs@@{J#:@@kP@@&@@K]d@@bM@@Q@@y=c@@y=c@@˒:*@@u%F@@F@@e+@@`A7@@4֡b@@\)@@@N@@+@@:S@@4J@@7KƧ@@:S@@=b@@Dg8~@@JE@@JE@@A [@@N;5@@n.@@_o@@o@@@@Y}@@_o@@b}@@o hی@@|Q@@rGE8@@o@@^5?}@@D@@2W@@y@@o@@e@@ᰉ'@@>BZ@@e@@e@@e@@R@@Y}@@lD@@.H@@I^5@@)y@@GE85@@d7@@{m@@\(@@ ě@@n@@fB@@nP@@/V@@a@N@@q@@҈@@Q@@>B[@@>B[@@JM@@!-w@@qu"@@5Xy>@@O;dZ@@m\@@jOv@@ݗ@@Vl!@@
(@@)^@@As@@As@@RT`e@@O
M@@RT`e@@RT`e@@_o@@b}V@@eں@@o@@v_ح@@O;d@@[W>@@@@rGE9@A  ě@A 4m9@A A7K@A U2a|@A r Ĝ@A r Ĝ@A n@A u%F@A ҈p@A `A7@A$/@A_p@Aae@Ab}@A_o@AlD@Au%F@AlD@A-@AoiD@AXbM@A[W>6@ATɅo@AoiD@AR<6@Ay@A.H@AnO@Avȴ@AL/{@AY@AS&@A9@AdZ@A:)z@AZ@AƧ@AƧ@AMjO@AG{@A~"@A@A-@Aᰉ'@Ao@A'R@A@A@A)y@Ae+@Ax@As@A@A_@AE@A+jg@ABZc @A\N<@AOv_خ@A@A_o @A[@A@Azxl"@A1&@AL_@A.2@A4K@Am\@AO;dZ@A@AYJ@A6z@A6z@A@A,<@A@A6z@A hۋ@A.H@A8}H@A1@A!.I@A@A6z@A@AO;@A,<@AO;@A6z@A'/W@A>6z@ART`e@AlC@Ao@A{J#:@Avȴ9@A>BZc@APH@A	&x@A	^@A	7Kƨ@A	(@A	u@A	e+a@A	4J@A	:S@A	JE@A	XbM@A	^@A	e+a@A	k~(@A	k~(@A	k~(@A	k~(@A	hr @A	o hی@A	u!S@A	@A	oiD@A	y@A	@A	u!S@A	e+a@A	hr @A	u!S@A	@A	(@A
u%F@A
#9@A
6C@A
M@A
kP|@A
@4@A
@4@A
W'@A
u%F
@A"`B@A$@Ajf@A,zxl@A	@A]cA@An.3@A
䎊q@A
)_@A
W@A
)_@A
m@Aqu!@A~($@A@A6@Atj@Azxl"@AZ@AZ@A!-w@A
*0@A
K]@A>@A
'0@A@Ahr@Ahr@A@AɅoi@A֡a@AZ@A>@A
[@A
(@A
ce@A
\(@A
oiDg@A ѷY@A@AOv_@A!R<@A!R<@A!R<@A@A@A@A@A$/@ABZc @AOv_خ@A_ح@AiB@Avȴ9X@Ap:~@Ap:~@Aaf@A)^@A1@A1@A>6z@A.H@A'/W@A.H@A>6z@Ab}V@A{J#:@A&@Ar@Avȴ9@Avȴ9@AحV@A@AeO@Ay=c@A@AěT@Ae+@A@A[W>6@A@A'R@A|@Au%@AJ#9@An.3@Aqu!@A2W@AZ1@A9XbN@A!-w2@A]ce@AC@A?@A*1@AS@A1&@AO
M@A@A?@A֡a@A@A>@AE@AK]@A*0@Am\@Av@Ash@A-V@AH˒@A,=@A
(@A$/@A1.@A8YJ@AOv_خ@A\N<@Afffff@A4K@AE@Aᰉ@A(@A(@At@A
(@A.2@A hۋ@A$tS@ART`e@AzH@AحV@ArG@A4m9@AoiDg8@An@A-
@Ad8@AF@A&x@Ak~(@A@Ao@AB@AiB@A-@AY}@A-@A-@AI^5@A䎊@A&IR@A:)y@A~"@Avȴ@AL/{@A)_@A͞&@A`A@AG{@AG{@AG{@AD@As@APH@A&@A@N@A~$@A@AƧ@A|@A
=p@A|@A҈@As@A]ce@Aq@AwkP@A#@A_@A[W?@A7@A?@A?@AZ@A>B[@Au"@A@AD@A*0@A84֡@AL_@Asg@Ahr!@A@AU=@A8Y@AC\@A.2@AVu@Al!-@A+J@A$t@A$t@A$t@AO;@Aaf@A6z@A}Vl@A'@A@Aȴ9X@A&I@A&I@Am\@Aȴ9X@AA@A+@Ax@AMj@A!.I@A
=p@A)^@AXe@AE84@A-V@A[W>@A3@Ar@AK]d@AحV@A-@A      @A }H@A 73@A A7K@A hۋq@A r Ĝ@A |@A IQ@A p:@A p:@A ѷX@A ѷX@A {@A! ѷ@A!rGE@A!@A!&x@A!-w1@A!4J@A!4J@A!JE@A!TɅo@A!rGE8@A!@A!B@A!^5?}@A!"`@A"@A"=p
@A"JL@A"W'@A"d7@A"xl"h
@A"L_@A"0
@A"L/{@A"͞&@A"fB@A"D@A"D@A"~@A#PH@A#=K^@A#P{@A#ߤ@A#%2@A#g@A#$@A$n.@A$L_@A$%1@A$%1@A$M:@A$cA \@A$g8}@A$zG@A$wkP@A$?@A$zxl"@A$@A%*0@A%O;dZ@A%S&@A%fA@A%$/@A%v@A%@A%!.@A&t@A&zG@A&u@A&$/@A&1.@A&R<6@A&fffff@A&p:~@A&O;@A&}Vl@A&&I@A&A@A&ߤ?@A'@A'@A'Xe@A',@A',@A'v@A'.H@A';dZ@A'E84@A'Xe,@A'v_ح@A'{J#:@A'&@A'&@A'	@A'kP@A'	k@A'	k@A'@A'+@A'fA@A'حV@A'-@A(bM@A(
qu@A(6@A(1&x@A(D*@A(Q@A(U2a|@A(Xy=@A(l"h	@A(˒:*@A(@A()@A(e+@A(C@A)+@A)JE@A)N;5@A)o hی@A)7Kƨ@A)o@A)u@A)B@A)@A)2W@A)y@A)y@A)2W@A)_o@A)@A)e@A)R@A*@A*6C@A*6C@A*=p
@A*6C@A*C\@A*Q_@A*W'@A*d7@A*nO@A*qiC@A*ݘ@A*vȴ@A*g	@A*@A*fB@A*D@A+҉@A+'/@A+PH@A+)^	@A+=K^@A+W>6z@A+dZ@A+g	l@A+n.3@A+{J#9@A+~$@A+~$@A+@A+eO@A+ߤ@A+@A+|@A+lC@A+g@A+s@A,J@A,xF@A,Q@A,I^5?@A,q@A,~($x@A,#@A,TɆ@A,TɆ@A,1&@A,#x@A,?@A,/@A,>@A-V@A-L_@A-Vl!@A-\@A-w1@A-$/@A-O
@A-@A-@A-@A-\(@A-Ϫ͞@A-8YK@A-,=@A-,=@A-E@A..2@A.BZc @A.?@A.H@A.E@A.E@A.L/{J@A.E@A.E@A.R<6@A._ح@A.iB@A.iB@A.+J@A.O;@A.af@A.'@A.A@A/.H@A/RT`e@A/RT`e@A/\(@A/sPH@A/4m@A/?@A/+@A/@A/䎊r@A/rGE9@A/#@A0     @A0     @A/#@A/rGE9@A0bM@A0bM@A0@A06@A0}H@A0$xG@A01&x@A0H@A0[6@A0hۋq@A0l"h	@A0l"h	@A0eO@A0bM@A0_F@A0hۋq@A0IQ@A0p:@A0҈p@A1$/@A0PH@A0	k@A1 ѷ@A0	k@A0\)@A0PH@A1 ѷ@A1@N@A1	k~@A1$/@A1@A1 [7@A1&x@A17KƧ@A1=b@A1A [@A1=b@A1N;5@A1[W>6@A1u!S@A1oiD@A1o@A1R<6@A1@A12W@A1@A1@A1ԕ*@A1_o@A1@A1Y}@A2u%F@A2n@A2I^5@A2Ov`@A2䎊@A2-V@A23@A26C@A2:)y@A2a|Q@A2d7@A2xl"h
@A2@4@A2ᰊ@A2@A2<64@A2 ѷ@A2c	@A2c	@A2䎊q@A274@A2c	@A3S&@A3C,z@A3F]c@A3]cA@A3n.3@A3@A3q@A3:)z@A3ߤ@A3q@A3m]@A3E@A3~($@A3
=p@A3lC@A3$@A3A [@A3A [@A3g@A3\N@A4tj@A4(\@A49XbN@A4?@A4C,zx@A4I^5?@A4Z1@A4Z1@A4Z1@A4m8@A4o h@A4_@A4쿱[@A4쿱[@A4쿱[@A4S@A4쿱[@A43@A43@A43@A4zxl"@A4TɆ@A4TɆ@A4O
M@A4?@A4>B[@A4@A4D@A4e@A4E@A5'0@A5*0@A5!.H@A584֡@A5ce@A5zxl"h@A5ڹZ@A5=K@A5v@A5\(@A5
qv@A5oiDg@A5!.@A5C\@A5C\@A6t@A6
L/@A6
(@A6@A6$/@A6E@A6Ov_خ@A6Vu@A6_ح@A6fffff@A6O;@A62X@A6Q@A6&I@A6ߤ?@A6&I@A6҈p;@A6C-@A6쿱[W@A6Mj@A6!.I@A7@A6!.I@A7@A7$tS@A7+I@A74֡a@A7;dZ@A7H˒:@A7O
M@A7Xe,@A7eں@A7v_ح@A7&@A7{J#:@A7&@A7@A7ݗ+@A7@A7$tS@A7-V@A7&@A73@A7r@A7@A7o @A7˒:)@A7˒:)@A7@A7@A7حV@A7rG@A7-@A7䎊r@A7#@A8     @A8	ԕ+@A8bM@A8}H@A81&x@A8H@A8bM@A8l"h	@A8r Ĝ@A8|@A8@A8IQ@A8@A8@A8d8@A8@A8-
@A8
=q@A8
=q@A8@A8d8@A8@A8U@A8d8@A8{@A8{@A8{@A8{@A8{@A89Xb@A8)@A8TɅ@A8)^@A8D@A84֡b@A8\)@A8\)@A9@N@A9+@A9@N@A9@N@A9+@A9#w@A9#w@A9#w@A90
)@A9A [@A9JE@A9e+a@A9k~(@A9b}@A9@A9'RTa@A9'RTa@A9n.@A9n.@A9(@A9B@A9'R@A9X@A92W@A9_o@A9N;6@A9"`@A9iB@A9ᰉ'@A9Y}@A:	 @A:@A:)y@A:3@A:=p
@A:=p
@A:GE85@A:GE85@A:W'@A:Zc@A:h	ԕ@A:qiC@A:L_@A:vȴ@A:L/{@A:@A:g	@A:<64@A:n@A:n@A:@A:W@A:G{@A:m@A;S&@A;PH@A;PH@A;	@A;)^	@A;)^	@A;/V@A;@N@A;F]c@A;J#9@A;F]c@A;P{@A;Z@A;Z@A;Z@A;]cA@A;]cA@A;g	l@A;tj~@A;@A;:)z@A;$@A;$@A;ߤ@A;S@A;q@A;@A;m]@A;@A;m]@A;m]@A;~($@A;E@A;6@A;6@A;Q@A;Q@A;lC@A;g@A;lC@A;@A;\N@A;\N@A<J@A<ߤ@@A<"h	ԕ@A<64@A</{J#@A</{J#@A<<쿱@A<C,zx@A<C,zx@A<C,zx@A<C,zx@A<C,zx@A<Fs@A<PH@A<]ce@A<q@A<~($x@A<TɆ@A<@A<?@A<j~@A<Z@A<>B[@A<u"@A<Z@A<>@A=u@A=[@A=%F
L@A=%F
L@A=2a|@A=2a|@A=F
L0@A=O;dZ@A=Y|@A=\@A=jOv@A=jOv@A=w1@A=ݗ@A=+j@A==K@A=@A=Xy=@A=U=@A=U=@A=@A=@A=@A=?@A=ᰉ@A=(@A=!.@A=!.@A=!.@A=C\@A>t@A>
L/@A>
(@A>4K@A>zG@A>Ov_@A>!R<@A>Ov_@A>!R<@A>($x@A>.2@A>.2@A>8YJ@A>E@A>H@A>E@A>H@A>H@A>Ov_خ@A>iB@A>p:~@A>qi@A>qi@A>$t@A>,<@A>}Vl@A>ߤ?@A>҈p;@A>쿱[W@A?@A?@A?Ft@A?
M;@A?
=p@A? hۋ@A?@A?
=p@A?Ft@A?
M;@A?)^@A?v@A?,@A?,@A?>6z@A?>6z@A?As@A?O
M@A?O
M@A?KƧ@A?KƧ@A?KƧ@A?H˒:@A?KƧ@A?RT`e@A?eں@A?sPH@A?v_ح@A?y@A?4m@A?|hs@A?4m@A?4m@A?$tS@A?kP@A?	k@A??@A?[W>@A?zH@A?[W>@A?[W>@A?3@A?3@A?3@A?r@A?r@A?3@A?[W>@A?/V@A?r@A?vȴ9@A?@A?@A?@A?˒:)@A?fA@A?حV@A?@@A?rGE9@A@@A@bM@A@
qu@A@	ԕ+@A@	ԕ+@A@
qu@A@bM@A@bM@A@*0U@A@6@A@'RT`@A@*0@A@'RT`@A@'RT`@A@-
q@A@*0@A@-
q@A@:~ @A@:~ @A@:~ @A@:~ @A@>BZc@A@D*@A@H@A@K]c@A@NU@A@NU@A@U2a|@A@_F@A@[6@A@_F@A@bM@A@bM@A@eO@A@oiDg8@A@˒:*@A@˒:*@A@n@A@@A@tj@A@@A@u%F@A@IQ@A@
=q@A@@A@d8@A@@A@{@A@)@A@F@A@`A7@A@C@A@@A@e+@A@`A7@A@C@A@4֡b@A@\)@AA$/@AA+@AA [7@AA@AA [7@AA&x@AA@AAJE@AAJE@AAJE@AA[W>6@AAae@AAe+a@AAx@AAb}@AA@AA@AAoiD@AA~($@AAo@AA@AA@AA'RTa@AAn.@AA@AA>BZ@AAs@AAR@AA>BZ@AAe@AAR@AAR@AAs@AAR@AA@AA.H@AB	 @ABe+@AB-V@AB6C@ABGE85@AB=p
@AB@4n@ABC\@ABJL@ABQ_@ABT`d@ABQ_@ABM@ABQ_@ABQ_@ABQ_@ABQ_@ABT`d@ABT`d@ABa|Q@ABqiC@AB{m@AB\(@ABᰊ@AB>B@AB>B@AB}Vm@AB<64@AB<64@ABn@AB)_@ABm@ABm@ABD@AB~@AC҉@ACS&@ACu%@AC҉@AC'/@ACs@ACs@AC"`B@AC	@AC&@AC,zxl@AC/V@AC33333@ACP{@ACZ@ACn.3@ACqu!@ACqu!@ACxF]@AC{J#9@AC~$@ACQ@ACq@ACMj@ACwk@ACq@AC@ACm]@AC~($@ACm]@ACZ@AC6@AC6@ACƧ@ACƧ@AC|@AC|@AC
=p@ACQ@ACQ@ACݗ+k@ACݗ+k@ACݗ+k@ACQ@AC҈@AC҈@AC҈@AClC@AC%2@AC\N@AD/{J#@AD?@ADI^5?@ADFs@ADI^5?@AD]ce@ADcA \@ADj~#@ADcA \@ADm8@ADm8@ADj~#@ADq@ADtSM@ADwkP@ADzG@AD~($x@AD~($x@AD~($x@AD?@ADC@ADqj@AD쿱[@AD3@AD1&@AD֡a@ADhr@ADe@AD!-w@AE:@AE'0@AE!.H@AE(@AE!.H@AEB@AE84֡@AE?|h@AEL_@AEp
=@AEp
=@AE}H@AE=K@AE%@AEH˒@AE\(@AE\(@AE\(@AEH˒@AE\(@AEn/@AEn/@AEsh@AE@AEn/@AE\(@AEH˒@AEn/@AE@AEϪ͞@AE
qv@AEC\@AE!.@AE!.@AE!.@AE!.@AE!.@AEC\@AEC\@AEC\@AEڹ@AEڹ@AEC\@AF_o @AF_o @AF ѷY@AF_o @AF_o @AF_o @AFt@AFt@AFt@AF_o @AFt@AF
(@AF
L/@AF
(@AF4K@AF@AFu@AFOv_@AF$/@AF+jg@AF+jg@AF?@AFL/{J@AFL/{J@AFYJ@AFYJ@AFYJ@AF\N<@AF\N<@AFc	@AFc	@AFc	@AFc	@AFc	@AFiB@AFl!-@AFp:~@AFp:~@AFvȴ9X@AFvȴ9X@AF}Vl@AF%@AF+J@AF%@AFqi@AFqi@AF+J@AFqi@AF@AF@AF$t@AF$t@AFO;@AF,<@AFT@AF-@AF2X@AFȴ9X@AF+@AF"@AGFt@AGFt@AF!.I@AG)^@AG,@AGv@AG,@AG,@AGXe@AG
M;@AG)^@AG@AGXe@AGv@AGv@AGv@AG
M;@AG,@AG,@AG,@AG$tS@AG,@AG!-w1@AG!-w1@AG,@AG,@AG,@AG'/W@AG'/W@AG$tS@AG!-w1@AG'/W@AG+I@AG'/W@AG$tS@AG$tS@AG.H@AG>6z@AGAs@AGAs@AGAs@AGE84@AGAs@AGE84@AGKƧ@AGH˒:@AGH˒:@AGH˒:@AGH˒:@AGKƧ@AGKƧ@AGKƧ@AGKƧ@AGRT`e@AGRT`e@AGRT`e@AGXe,@AGb}V@AGlC@AGsPH@AGlC@AGo@AGy@AG4m@AG4m@AG@AG͞@AG͞@AGK]d@AGK]d@AGrG@AGVϫ@AG-@AH@AH'RT`@AH73@AHH@AHH@AHNU@AHQ@AHNU@AHNU@AHQ@AHQ@AHQ@AHU2a|@AHU2a|@AH_F@AH_F@AHbM@AHhۋq@AHoiDg8@AHr Ĝ@AHr Ĝ@AH|@AH`A7@AHe+@AH҈p@AHۋq
@AH4֡b@AI&x@AI4J@AIA [@AIJE@AIJE@AIQ@AIN;5@AIN;5@AITɅo@AIQ@AIQ@AITɅo@AIXbM@AIXbM@AI[W>6@AI[W>6@AIae@AIhr @AIhr @AIo hی@AIrGE8@AIrGE8@AIk~(@AIrGE8@AIrGE8@AIu!S@AIx@AIb}@AI|Q@AI@AIR<6@AI~($@AIo@AIo@AI@AIR<6@AIu@AIu@AIu@AI'RTa@AIn.@AIl@AIB@AI'R@AIB@AI'R@AI@AI_o@AIe@AIY}@AIlD@AI.H@AI.H@AIlD@AIlD@AJu%F@AJu%F@AJu%F@AJn@AJn@AJu%F@AJn@AJ	 @AJI^5@AJI^5@AJ	 @AJ	 @AJI^5@AJs@AJOv`@AJe+@AJOv`@AJe+@AJe+@AJOv`@AJOv`@AJe+@AJ䎊@AJ&IR@AJ&IR@AJ&IR@AJ)y@AJ&IR@AJ-V@AJ3@AJ3@AJ3@AJ6C@AJC\@AJ@4n@AJ=p
@AJ=p
@AJ@4n@AJM@AJJL@AJJL@AJJL@AJM@AJJL@AJJL@AJJL@AJJL@AJJL@AJJL@AJM@AJW'@AJa|Q@AJ^5?|@AJa|Q@AJd7@AJu%F
@AJu%F
@AJqiC@AJxl"h
@AJ{m@AJ{m@AJ{m@AJ~"@AJ~"@AJݘ@AJ{m@AJ@4@AJp:@AJ0
@AJS&@AJwkQ@AJS&@AJS&@AJL/{@AJ ě@AJY@AJY@AJ@AJ䎊q@AJm@AJ~@AKS&@AKS&@AKS&@AKu%@AKu%@AKu%@AK҉@AK'/@AK'/@AKPH@AK"`B@AK"`B@AK)^	@AK/V@AK9@AK9@AKC%@AKC%@AKW>6z@AK]cA@AK]cA@AKn.3@AK@AKQ@AK:)z@AKߤ@AKA@AKwk@AKU=@AKwk@AKwk@AKS@AK@AK@AKm]@AKE@AKE                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @r{33333@r{33333@r     @r@r@r@r     @rfffff@s#33333@s;33333@s!@rfffff@r33333@rٙ@rfffff@s@s8     @sQ@s^fffff@sp     @sp     @sl@sffffff@sFfffff@s     @r@r33333@r@r     @rs33333@rnfffff@rq@rd@rx     @r33333@r     @r@r@rfffff@r@r@rfffff@r@rfffff@r     @r33333@r     @r     @rfffff@rfffff@rٙ@r@rfffff@rљ@r33333@r33333@rfffff@r@r@r     @r@r@r@r@r     @r33333@rfffff@r33333@r|@r{33333@r|@rvfffff@rffffff@r^fffff@r\@rd@ri@ri@r^fffff@r[33333@ra@rd@rd@r^fffff@r`     @rY@rL@rD@r4@qfffff@q33333@q^fffff@p@p@p\@o9@m     @l6fffff@k33333@j@i)@h     @hs33333@h#33333@h33333@h,@g@g     @g33333@g33333@g`     @f     @gfffff@g@g33333@gvfffff@g     @f33333@e     @ec33333@eC33333@eFfffff@eS33333@eI@e)@dfffff@d	@c|@cfffff@bS33333@a<@a      @`陙@a0     @a     @afffff@afffff@a     @a@a@affffff@a#33333@a      @`33333@`fffff@`     @`33333@`33333@`fffff@`33333@`fffff@`fffff@`     @`@_     @_9@_,@_&fffff@_,@_S33333@_33333@^@^@^     @^l@^@     @^&fffff@]33333@]@]`     @]S33333@]S33333@]9@\@[fffff@[S33333@[9@[      @Z33333@Zffffff@Z      @Y     @Y333333@XL@Wٙ@Wfffff@W33333@Vfffff@V33333@V33333@V     @VY@U@U33333@U     @Ufffff@Ufffff@Ufffff@Uffffff@U`     @Ul@Uy@Ufffff@U@Ufffff@U,@U9@U@     @UFfffff@UL@UL@UFfffff@T@U      @U      @T@T@T@T@T@T33333@Tfffff@T     @Tfffff@T@T@T     @T@Tfffff@T33333@T@T@T@T33333@Tfffff@T@T     @T@T@T@T@T@T@T@T     @T@T     @T@T@T@T     @Ufffff@U333333@U333333@U333333@US33333@Uy@U     @Ufffff@Ufffff@U@U@U     @Ufffff@U@U@U33333@U@U     @Ufffff@U@U@Ufffff@U`     @U@U@U33333@U@U@Ufffff@U      @T@T@Tٙ@T33333@T@Ts33333@Ts33333@Ty@Tffffff@T@     @S33333@S@S@S@S33333@Sfffff@S9@RS33333@R@     @R,@R@R      @Q33333@Q     @Q     @Qfffff@Q@Q@Pfffff@P@     @P333333@P,@P      @P      @P      @P@P@Offfff@Oٙ@O     @O@Os33333@OY@O333333@O      @N@N@     @N@Mfffff@Mٙ@M     @M33333@M@MY@M@L33333@L@     @L      @K33333@L&fffff@LL@LY@L&fffff@Kٙ@K33333@Kfffff@K@K     @K     @Kffffff@K&fffff@J33333@Jffffff@JL@J@     @J      @Ifffff@Iffffff@I&fffff@I@H33333@H33333@H33333@I&fffff@Iffffff@I33333@I@Iٙ@Iٙ@I@I     @I@IL@IL@I333333@H@HL@Gffffff@F@     @E33333@Es33333@EL@Effffff@EY@E     @E33333@F@F@E33333@E@E333333@E      @E&fffff@E@     @Dfffff@D     @Dffffff@DL@DY@DY@DY@D@     @D@C33333@Cfffff@Cfffff@C33333@C     @C     @C     @C     @C     @C     @C@CY@C333333@C&fffff@C@C      @C      @Bٙ@B@B333333@Afffff@Afffff@As33333@As33333@AY@Affffff@A     @A     @As33333@Affffff@AY@AY@A@     @AY@AL@A@     @A@     @A@     @A@     @A@@33333@@@@ٙ@@ٙ@@ٙ@@ٙ@@ٙ@@@@@@L@@@     @@333333@@@@@@@@@@      @?fffff@?L@>@>@>33333@>33333@>@>ffffff@>@>@>33333@>@>     @>@=33333@=ffffff@=ffffff@<fffff@<ffffff@<@<@<@<L@<ffffff@<L@<      @;33333@;fffff@<      @<      @;fffff@;fffff@;fffff@;@;@;L@;      @:@:     @:L@:333333@:      @:      @9fffff@9@933333@9@933333@9@9@9@9     @9ffffff@9ffffff@9ffffff@9ffffff@9L@9L@9333333@9      @8L@8L@8L@8333333@8@8@8      @7@7@7@7@7     @7ffffff@7333333@7      @6@6@6ffffff@6L@6@6      @5@5@5333333@4@4L@4@3fffff@333333@333333@3@3@333333@3@3L@3333333@3@3@3@3@3@3@3333333@3L@3333333@2     @2ffffff@2333333@2@2@2@2@2      @1fffff@133333@1@1@1ffffff@1L@1ffffff@1ffffff@1L@1L@1ffffff@1L@1L@1L@1      @0@0@0333333@0@0      @/@/@/@/ffffff@/333333@/      @.@.ffffff@.      @.      @-@-ffffff@-333333@-333333@-ffffff@-ffffff@-333333@-      @-      @,@,@,@,333333@,      @,      @,      @,      @+@+@+@,      @,      @+@+333333@+      @*@+      @+333333@+333333@+      @*@*@*      @)@)@)@)@)@)ffffff@)333333@)333333@)ffffff@)333333@)333333@)333333@)333333@)      @(@(@(@(ffffff@(@(ffffff@(333333@(333333@(333333@(      @'@'@'@'@'ffffff@'333333@'ffffff@'333333@'ffffff@'333333@'333333@'ffffff@'ffffff@'333333@'333333@'333333@'333333@'333333@&@&@'      @'      @'      @'      @&@&@&@&@&@&ffffff@&ffffff@&ffffff@&333333@&333333@&ffffff@&333333@&      @%@%@%@%@%@%@%@%@%@%@%333333@%333333@%333333@%333333@%333333@%333333@%333333@%333333@%333333@%333333@%      @$@$@$@$@$ffffff@$ffffff@$@$@$@$@$ffffff@$ffffff@$333333@$      @$      @$      @$      @$      @$      @$      @#@#@#@#@#@#333333@#ffffff@#@#@#@#ffffff@#333333@#333333@#333333@#ffffff@#333333@#333333@#333333@#      @#333333@"@"@"@"@"@"@#      @"@"@"@"@"@"@"ffffff@"ffffff@"@"@"@"@"@"@"@"@"@"@"ffffff@"@"ffffff@"ffffff@"ffffff@"@"ffffff@"ffffff@"ffffff@"ffffff@"ffffff@"ffffff@"333333@"      @"333333@"333333@"333333@"333333@"333333@"333333@"333333@"      @"      @"333333@"      @"333333@"      @"      @"      @"      @"333333@"      @!@"      @"      @"      @"      @"      @"      @"      @"      @"      @"      @!@"      @"333333@"333333@"      @"      @"      @"      @"      @!@"      @"333333@"      @"      @"      @"333333@"      @"      @"333333@"ffffff@"      @"      @"333333@"      @"      @"333333@"      @"333333@"      @"333333@"333333@"333333@"      @"      @"333333@"      @"333333@"ffffff@"      @"333333@"ffffff@"ffffff@"333333@"ffffff@"ffffff@"ffffff@"ffffff@"ffffff@"@"@"ffffff@"ffffff@"@"@"@"ffffff@"@"@"@"@"@"ffffff@"@"@"@"@"@"@#      @"@"@#      @"@"@"@"@"@"@#      @#      @#      @#      @"@#      @#      @#      @#333333@#      @#333333@#ffffff@#333333@#333333@#333333@#333333@#333333@#333333@#ffffff@#ffffff@#@#@#@#ffffff@#@#@#ffffff@#@#@#@#@$      @$      @$333333@$      @$333333@$ffffff@$      @#@$      @$      @$333333@$ffffff@$ffffff@$ffffff@$@$@$ffffff@$ffffff@$@$@$@$@$@$@$@$@$@$@$@$@$@$@%      @$@$@$@%333333@%      @%      @%      @%      @%333333@%333333@%333333@%      @$@%333333@%ffffff@%ffffff@%ffffff@%@%ffffff@%ffffff@%ffffff@%ffffff@%ffffff@%ffffff@%@%@%@&      @&      @&      @%@%@%@%@%@&333333@&      @&      @&ffffff@&@&@&@&@&@&ffffff@&@&@&@'      @'      @&@'      @'      @'      @&@'333333@'333333@'333333@'@'@'333333@'333333@'333333@'ffffff@'ffffff@'@'@'@'@'@'@'@'@'@'@'@'@(      @'@(      @(333333@'@(333333@(333333@(333333@(333333@(ffffff@(@(@(@(ffffff@(ffffff@(      @)333333@)ffffff@)333333@)333333@)      @)333333@)333333@)@)333333@)@)ffffff@)@)@)@*      @*333333@*      @*333333@*@*ffffff@*ffffff@*@*@*ffffff@*@*@*@+      @+      @*@*@+      @+333333@+      @+      @+333333@+333333@+ffffff@+@+ffffff@+ffffff@+ffffff@+ffffff@+ffffff@+@+@,      @,      @+@,      @,      @,      @,333333@,333333@+@,      @,ffffff@,333333@,333333@,333333@,333333@,ffffff@,@,ffffff@,ffffff@,@-      @-      @-      @,@-333333@-333333@-ffffff@-333333@-ffffff@-@-@-ffffff@-@-@-@-ffffff@-@-@-ffffff@-@-@-@-@-@-@-@-@-@.      @.333333@.333333@.333333@-@.      @.333333@.333333@.ffffff@.@.ffffff@.@.@.@.@.@.@/333333@/333333@/333333@/333333@/333333@/@/@/@/@/@/ffffff@/@/@/@/@0      @0@0@0      @0      @0333333@0L@0ffffff@0ffffff@0L@0L@0ffffff@0ffffff@0     @0@033333@0@0@0fffff@0fffff@0@0fffff@0fffff@1      @0fffff@0fffff@1@1ffffff@1L@1333333@1ffffff@1ffffff@1ffffff@1ffffff@1ffffff@1L@1@1@1     @1@1@1@1@133333@133333@133333@1@1fffff@1fffff@2      @2      @1fffff@1fffff@1fffff@2      @2@2      @2      @2      @2@2333333@2333333@2L@2L@2333333@2333333@2ffffff@2L@2333333@2@233333@233333@2@233333@233333@2@2@233333@2@2fffff@3      @2fffff@3      @3@3333333@3333333@3333333@3ffffff@3L@3L@3ffffff@3@333333@333333@3@3fffff@4      @3fffff@333333@333333@4      @4333333@4ffffff@4     @4     @4L@4ffffff@4L@4L@4L@4@4@4@433333@4@4fffff@5      @5      @5      @5@5333333@5@5@5ffffff@5L@5L@5     @5     @5     @5     @5     @5@533333@533333@5@5@5@533333@5@5@5fffff@5fffff@6      @6      @6      @6      @6333333@6333333@6L@6L@6     @6     @633333@6@6fffff@7@7@6fffff@7333333@7      @7@7333333@6fffff@7      @7333333@7333333@7333333@7333333@7333333@7L@7L@7ffffff@7     @733333@7ffffff@7ffffff@7     @7     @7ffffff@7ffffff@7@7@7@7@7@7fffff@7fffff@7@733333@7@8@8@8333333@8333333@8333333@8L@8L@8333333@8L@8333333@8333333@8ffffff@8L@8L@8333333@8L@8L@8ffffff@8L@8333333@8     @8@8@8@833333@9      @9      @8fffff@8     @8@8fffff@8fffff@8fffff@9      @9      @9      @9      @9      @9333333@9      @9333333@9333333@9@9333333@9333333@9L@9ffffff@9ffffff@9333333@9ffffff@9     @9ffffff@9ffffff@9     @9     @9     @9@9     @9@9@9     @933333@933333@9fffff@9@9@9fffff@:333333@:@9fffff@:      @:333333@:@:ffffff@:@:     @:@:33333@:@:@:33333@:@:@:fffff@;      @:fffff@;      @;333333@;333333@;333333@;L@;     @;ffffff@;     @;     @;     @;     @;33333@;@;33333@<      @<@;33333@;33333@;@;fffff@<333333@<333333@<@<333333@<ffffff@<     @<     @<333333@<L@<ffffff@<@<33333@<@<@<     @<     @<@<33333@=      @=@=@=      @=333333@=333333@=333333@=333333@=333333@=333333@=L@=ffffff@=L@=ffffff@=@=33333@=     @=@=@=@>@>333333@>333333@>L@>     @>@>@>     @>@>L@>@>33333@?@?333333@?@>@>@>@?L@?L@?ffffff@?     @?     @?ffffff@?     @?     @?@?@@@@@@@@      @@&fffff@@@     @@@     @@@     @@L@@L@@L@@L@@ffffff@@Y@@ffffff@@Y@@ffffff@@ffffff@@ffffff@@@@@@s33333@@s33333@@s33333@@@@s33333@@@@     @@@@fffff@@     @@ٙ@A      @A@A@A@A&fffff@A@     @A333333@A@     @A@     @AY@AY@A@     @AY@AY@Affffff@AY@Affffff@Affffff@Affffff@As33333@As33333@A@A     @A     @Affffff@A@B      @B@A33333@B@B333333@B&fffff@B@Afffff@A33333@B@B@B@Bfffff@Bfffff@B33333@B@B@BY@C      @C      @C      @C@C@C@C@C      @C@C@C@C333333@C&fffff@C@     @CY@Cffffff@CL@CY@CY@Cs33333@Cs33333@Cffffff@Cs33333@Cffffff@Cs33333@C@C     @Cs33333@C     @C@C@C@C@C@C@Cs33333@C@C@C@C@C@Cfffff@C@C@C@C33333@C     @C@Cٙ@C33333@D      @Cfffff@D      @D@D      @D@D@D      @D      @D&fffff@D&fffff@D@D&fffff@D&fffff@D&fffff@D&fffff@D333333@D333333@DL@DL@DL@DL@DL@DY@Dffffff@DY@DY@DY@Dffffff@DL@DY@D     @D@Dfffff@D33333@D33333@D33333@D33333@Dfffff@E@E@E@E@E@     @E@     @E@E@E@E@E333333@E333333@E333333@E@E@E&fffff@E@E&fffff@E333333@E&fffff@E&fffff@E333333@E333333@E@     @E333333@E@E333333@E333333@E@     @E@     @EL@E@     @E@     @E333333@EL@EL@EY@Es33333@Effffff@Es33333@E     @Es33333@E     @E@Es33333@E     @E     @E@E     @Es33333@E@Efffff@E@E@E@E@E33333@E33333@E     @E33333@Eٙ@Eٙ@E     @E33333@Efffff@F      @F333333@FL@FL@Fs33333@F     @Ffffff@Fٙ@Ffffff@G      @G      @G@G@G@G@G@G@G@G@G@G333333@G333333@G333333@G333333@G333333@GL@G     @G33333@G@Gfffff@Gfffff@Gfffff@H      @H333333@Hs33333@H     @Hfffff@Hfffff@H33333@Hfffff@H@H     @H33333@H33333@H@H     @H33333@H@Hٙ@H@Hfffff@Hfffff@Hٙ@Hٙ@Hٙ@H@I@I@I@I      @Hfffff@Hfffff@Hfffff@I      @I@I&fffff@I333333@I&fffff@I&fffff@IL@I333333@I@     @I@     @IY@Iffffff@IL@IY@IY@Is33333@Is33333@Ifffff@Ifffff@I     @Ifffff@I33333@Ifffff@Iٙ@Ifffff@Iٙ@I33333@J      @Ifffff@J      @J      @I33333@J      @J      @J      @J@J@J      @J@J@J      @J@J333333@J&fffff@J@J      @J@J333333@J@J&fffff@J@     @J&fffff@JL@JY@Js33333@JY@J333333@J@JL@JY@JL@JY@Jffffff@J     @Js33333@Js33333@J@Js33333@Jffffff@J     @J     @Js33333@Js33333@J@J     @J@J@Jfffff@J@J@Jfffff@J     @J33333@Jfffff@Jٙ@Jٙ@Jٙ@Jٙ@Jٙ@Jٙ@Jfffff@Jfffff@Jٙ@Jfffff@K      @J33333@K      @K@K@K&fffff@K333333@K333333@KL@Ks33333@K     @K33333@K33333@K33333@K     @K33333@K@Kٙ@K@K@Kٙ@Kٙ@Kfffff@Kٙ@Kfffff@L      @L      @L@L333333@L@     @L&fffff@L333333@LL@LL@L&fffff@L@Lfffff@Lfffff@L33333@Lfffff@L@L@L@L33333@Lfffff@L33333@L@L@Lٙ@Lfffff@Lfffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ?~"?E?GzH?Q?
=p?Vu?m?XbM?٩lD?bM?hr Ĝ?lC?|hr?◍O;d?"`B?E?m?O;dZ?O;dZ?ffffff@nP@tj@!j~#@lD@+J@ NVu@%l@+ix@/S@+7Kƨ@-lC@.|hs@'y"`@$@"dZ@^5?|@	7KƧ@p
=@"`B@F-@G{@
=p
@tj@Vt@|hs@u\(@j~#@-V@
=p@
tj~@	=p
=@
=p?O;d?I^5?}?"`B@O;d?vȴ?lC?-V?/v?O;d??|hs?$/?Q?tj~?lD?vȴ9?A7Kƨ?/w? ěT?5?|h?+?      ?$/??|hs?      ?-V?~"?r ě?S?n?x?tj?-?hr!?n?tj~?+I^?l?O;dZ?ݡo?ؓtj~?ȴ9Xb?֗O;d?;dZ?Ԭ1&y?I^5?&x?`A7L?Ѻ^5?|?bM?=p
=?̋C%?O;dZ?˥S?"`B?^5?|?ʟvȴ9?ɺ^5?|?˅Q?xF?1&x?E?$/?ffffff?Q??|hs?S?S?l?Q?lD?GzH?° ě?-V?bM?lD?nO;?
=p?$/? ěT?-V?öE?l?
=p?M?ěS?nO?&x?\(?° ě?° ě?`A7K?lD?      ?lD?GzH?bM?$/?nO;?zG{?9XbM?tj?lD?l?nO;?-V?333333?S?Õ$/?Q?-V?&x?nO?&x?&x?vȴ9X?-V?
=p?° ě? ěT?"`?° ě?7KƧ?7KƧ?ěS?`A7?nO?l?GzH?7KƧ?° ě?`A7L?l?n?° ě?7KƧ?\(?Q?hr Ĝ?`A7L?`A7?$/?`A7L?tj~?\(?° ě?lD?-V?Q?\(?
=p?Õ$/?S?Õ$/?9XbM?
=p?;dZ?ěS? ěT?Q?9XbM?l?hr Ĝ? ěT?hr Ĝ?333333?n?+?`A7L?n?`A7?n?l?zG{?tj?GzH?7KƧ?bM?A7Kƨ?333333?S?
=p?$/?9XbM?I^5??nO;?bM?nO?nO;?
=p?hr Ĝ?I^5??\(?Õ$/?lD?n?M?bM?Q?° ě?nO;?Õ$/?bM?nO;?7KƧ?I^5??ěS?Q?M??|hs?`A7L?Q?`A7L?$/?zG{?`A7?° ě?7KƧ?tj?lD?I^5??Õ$/?\(?E?l?`A7L?tj~?+?
=p?&x?-V?`A7?l?öE?nO?öE?&x?-V?\(?öE?n?öE?° ě?tj?l?tj~?tj~?&x?\(?\(?l?nO?l?/w?öE?`A7L?Õ$/?-V?M?ěS?Q?9XbM?zG{?-V?tj~?nO;?
=p?tj~?zG{?M?
=p?9XbM?I^5??I^5??-V?vȴ9X?+?`A7?Q?
=p?-V?+?I^5??nP?I^5??Q?GzH?° ě?hr Ĝ?GzH?7KƧ?M?tj~?\(?A7Kƨ?lD?nO;?l?lD?öE?ěS?lD?333333?ěS?x?zG{?nO?Õ$/?I^5??° ě?9XbM?333333?zG{?ļj~#?9XbM?ļj~#?GzH?\(?E?zG{?tj?öE?`A7L?S?lD?M?Q?I^5??vȴ9X?`A7L?7KƧ?l?nO?nO?7KƧ?nO?nO;?$/?I^5??Q?ěS?I^5??l?hr Ĝ?&x?tj?Q?I^5??öE?lD?E?Q?333333?öE?tj~?Z1'?9XbM?Z1'?öE?° ě?l?S?l?333333?l?Q?I^5??Q?Q?ěS?`A7L?zG{?zG{?I^5??öE?bM?333333?° ě?333333?/w?
=p?nO?-V?Õ$/?333333?
=p?
=p?Ł$/?tj?n?-V?`A7?+?S?M?tj~?333333?9XbM?`A7?n?Z1'?tj~?S?öE?-V?° ě?öE?nO?GzH?ěS?lD?Q?9XbM?`A7?hr Ĝ?Õ$/?$/?° ě?M?Z1'?nP?° ě?M?&x?l?nO?nO;?S?° ě?bM?M?n?n?öE?ěS?S?tj~?\(?9XbM?+?\(?-V?lD?7KƧ?E?7KƧ?tj~?&x?ěS?tj~?tj~?nO;?Q?$/?GzH?`A7?ěS?öE?`A7?333333?`A7?tj~?° ě?bM?7KƧ?tj?`A7?M?ļj~#?9XbM?nO;?Õ$/?I^5??9XbM?Q?-V?lD?9XbM?tj~?lD?tj~?l?333333?tj?
=p?ļj~#?lD?-V?+?7KƧ?
=p?Q?nO;?n?|hr?lD?\(?ěS?
=p?ļj~#?
=p?tj~?öE?|hr?`A7?S?tj?M?M?lD?° ě?7KƧ?9XbM?tj?nO;?
=p?7KƧ?      ?`A7L?ļj~#?nO?öE?nO?I^5??ļj~#?Õ$/?tj?ěS?`A7?9XbM?`A7?° ě?M?&x?ěS?nO;?Q?l?$/?`A7?vȴ9X?° ě?Q?lD?nO?-V?° ě?\(?&x?Q?9XbM?`A7L?7KƧ?hr Ĝ?nP?nO?n?tj~?tj~?nO;?tj?E?+?&x?\(?S?Q?+?`A7?öE?öE?S?
=p?nO;?hr Ĝ?ěS?\(?/w?nO;?-V?I^5??9XbM?`A7L?`A7K?9XbM?zG{?nO;?\(?tj~?tj~?tj~?ěS?I^5??I^5??n?`A7?-V?tj?-V?° ě?öE?`A7K?Z1'?n?`A7L?`A7?Q?
=p?GzH?`A7?nO?ěS?I^5??nO?9XbM?`A7L?Õ$/?-V?öE?° ě?333333?\(?`A7?&x?333333?333333?M?E?M?lD?+?`A7?S?I^5??lD?
=p?333333?šo?öE?nO;?+?S?`A7K?tj~?Õ$/?tj~?öE?l?öE?ļj~#?öE?l?9XbM?tj?$/?\(?Õ$/?9XbM?Õ$/?nO;?tj?333333?7KƧ?l?šo?\(?`A7?l?S?E?GzH?öE?I^5??Q?S?° ě?-V?öE?+?\(?lD?-V?
=p?
=p?\(??|hs?333333?333333?\(?7KƧ?+?/w?9XbM?Õ$/?E?`A7?zG{?\(?-V?tj?`A7L?      ?lD?GzH?-V?Z1'?+?tj?
=p?S?333333?l?
=p?tj?E?Q?tj~?
=p?9XbM?lD?nO;?lD?nO?E?l?+?° ě?nO;?+?333333?+?`A7?333333?öE?° ě?tj?tj~?° ě?° ě?&x?Õ$/?-V?Z1'?nO;?
=p?9XbM?tj~?Õ$/?nO?I^5??+?S?/w?lD?nO;?`A7K?333333?Õ$/?nO;?M?öE?l?l?S?öE?Z1'?ļj~#?ěS?öE?333333?öE?° ě?GzH?`A7?ěS?ffffff?Ƈ+I?hr Ĝ?Ł$/?zG{?Ł$/?tj~?
=p?+?S?nO;?-V?bM?° ě?\(?`A7?Õ$/?GzH?Ł$/?`A7?Z1'?tj?öE?`A7K?+?M?° ě?zG{?öE?nO?
=p?l?n?° ě?l?-V?\(?$/?Q?n?° ě?\(?&x?nO;?/w?ěS?nO?° ě?&x?/w?`A7K?E?Õ$/?GzH?|hr?nO;?nO?I^5??+?E??|hs?S?
=p?tj?$/?`A7?ěS?Q?9XbM?`A7?nO?° ě?`A7?333333?
=p?E?+?Q?hr Ĝ?nO;?
=p?-V?tj~?-V?tj?333333?-V?
=p?l?333333?-V?-V?-V?tj~?bM?tj~?E?nO?M?S?öE?öE?Ƨ-?Q?l?
=p?\(?333333?`A7?nO;?M?vȴ9X?&x?-V?ěS?`A7?+?\(?-V?-V?&x?Õ$/?E??|hs?I^5??Õ$/?S?I^5??zG{?
=p?Õ$/?`A7?tj?`A7?S?° ě?`A7?E?`A7L?tj?hr Ĝ?`A7K?9XbM?\(?nO?333333?Z1'?7KƧ?/w?
=p?`A7L?ěS?n?l?n?A7Kƨ?$/?nO;?&x?l?S?ļj~#?M?ěS?/w?nO;?\(?l?9XbM?Õ$/?° ě?
=p?nO?S?nO;?E?tj?Q?GzH?333333?tj?E?/w?
=p?nO;?tj??|hs?Z1'?ļj~#?S?tj~?ļj~#?tj?`A7K?`A7K?7KƧ?nO;?-V?\(??|hs?`A7L?° ě?n?tj?Q?
=p?lD??|hs?Q?M?\(?° ě?Z1'?M?nO?
=p?-V?`A7?Q?E?Ł$/?\(?° ě?
=p?lD?/w?S?I^5??333333?I^5??° ě?° ě?\(?/w?ļj~#?9XbM?9XbM?nO?I^5??nO?ěS?nO?333333?9XbM?zG{?-V?S?\(?öE?M?`A7?nO;?
=p?° ě?tj~?
=p?7KƧ?333333?tj?ļj~#?+?/w?\(?7KƧ?n?7KƧ?ěS?° ě?Z1'?° ě?7KƧ?nO;?S?E?I^5??I^5??I^5??nO;?zG{?tj?S?Z1'?Q?\(?tj?Z1'?9XbM?l?zG{?nO?lD?bM?Q?lD?šo?Q?tj?Õ$/?$/?Õ$/?nO;?M?E?-V?333333?`A7?M?tj~?tj?Q?ļj~#?9XbM?
=p?tj~?
=p?S?
=p??|hs?GzH?&x?lD?A7Kƨ?° ě?öE?Z1'?S?Q?ļj~#?$/?° ě?M?n?A7Kƨ?l?M?S?Õ$/?zG{?Õ$/?-V?-V?ěS?\(?nO?öE?333333?öE?ļj~#?Q?nO;?-V?"`?M?`A7?nO;?I^5??`A7L?-V?ěS?\(?ěS?nO?n?nP?tj~?° ě?nO;?tj?tj~?l?`A7?9XbM?nO?I^5??Z1'?S?`A7?Q?333333?nO;?öE?333333?`A7K?+?&x?ěS?E?Ƈ+I?Z1'?|hr?+?ěS?-V?Z1'?S?Q?\(?° ě?tj~?&x?&x?tj~?tj~?M?Z1'?Õ$/?tj~?Õ$/?Q?tj?9XbM?zG{?nO?-V?-V?° ě?+?nO;?M?E?`A7L?nP?vȴ9X?ěS?p
=q?nO;?      ?\(?333333?° ě?-V?° ě?° ě?E?-V?\(?\(?Õ$/?`A7?`A7?      ?
=p?° ě?7KƧ?Õ$/?`A7?l?
=p?\(?
=p?333333?nO?S?vȴ9X?nO?l?
=p?9XbM?
=p?$/?ěS?
=p?tj~?-V?lD?lD?-V?šo?lD?`A7L?\(?-V?öE?&x?I^5??ěS?`A7?öE?
=p?n?S?Q?+?1&y?Q?Q?\(?Q?
=p?GzH?-V?Z1'?zG{?S?E?ǮzG?S?Z1'?$/?ěS?333333?l?Õ$/?GzH?S?
=p?`A7L?nO;?-V?$/?zG{?l?M?Q?° ě?l?vȴ9X?333333?n?nO;?M?nP?nO?E?ěS?7KƧ?
=p?Q?\(?vȴ9X?l?9XbM?`A7K?lD?E?-V?A7Kƨ? ěT?nO;?S?`A7?tj~?E?333333?öE?zG{?tj~?tj~?hr Ĝ?S?\(?lD?$/?`A7?lD?Q?\(?-V?`A7L?S?ěS?S?`A7?Z1'?I^5??S?I^5??`A7?9XbM?nO;?zG{?`A7L?I^5??GzH?vȴ9X?
=p?M?`A7L?tj??|hs?S?I^5??+?tj~?n?
=p?Õ$/?tj~?GzH?-V?S?&x?`A7K?+?tj~?nO?$/?nO;?`A7?Õ$/?/w?      ?\(?333333?-V?nO?
=p?šo?I^5??Õ$/?\(?zG{?7KƧ?M?E?Õ$/?`A7K?n?-V?ěS?nO?9XbM?I^5??333333?S?+?Z1'?-V?nO?hr Ĝ?-V?Õ$/?n?Q?nO?S?n?nO;?nO;?n?GzH?&x?-V?lD?° ě?nO;?n?\(?tj~?333333?tj?`A7L?hr Ĝ?|hr?\(?I^5??&x?+?l?M?-V?-V?\(?nO;?M?ěS?-V?nP?I^5??° ě?`A7L?E?333333?p
=q?
=p?öE?tj~?S?-V?
=p?`A7?n?lD?l?nP?I^5??`A7?öE?hr Ĝ?Q?nO?Õ$/?$/?nO?-V?hr Ĝ?\(??|hs??|hs?hr Ĝ?l?`A7?A7Kƨ?-V?+?A7Kƨ?ěS?&x?nO;?-V?&x?333333?I^5??A7Kƨ?vȴ9X?l?° ě?
=p?GzH?n?° ě?nO?9XbM?Z1'?ļj~#?Q?° ě?S?lD?ěS?7KƧ?l?
=p?Q?nP?Q?Q?Z1'?nO?S?M?ěS?M?-V?GzH?E?° ě?$/?bM?° ě?\(?`A7L?ěS?Õ$/?Q?-V?nO?Õ$/?-V?-V?Q?+?333333?nO?Q?9XbM?7KƧ?nP?
=p?7KƧ?nO?Q?tj~?lD?ěS?Õ$/?-V?nO;??|hs?S?A7Kƨ?7KƧ?-V?&x?nO?\(?n?bM?l?M?nO?-V?-V?-V?\(?9XbM?$/?333333?nO?M?&x?7KƧ?ěS?GzH?-V?-V?° ě?GzH?S?-V?7KƧ?M?n?GzH?hr Ĝ?-V?nP?nO;?M?hr Ĝ?-V?hr Ĝ?nO?öE?tj~?nO;?&x?hr Ĝ?lD?-V?ěS?° ě?° ě?I^5??Z1'?n?\(?nO;?333333?I^5??333333?° ě?Õ$/?tj~?333333?Õ$/?lD?öE?+?tj~?vȴ9X?vȴ9X?Q?Z1'?M?° ě?nO?$/?ěS?-V?nO;?`A7?M?hr Ĝ?      ?nO?`A7?nO;?7KƧ?nO;?nP?lD?$/?nO;?lD?M?GzH?`A7L?nO;?`A7L?      ?|hr?hr Ĝ?&x?lD?S?9XbM??|hs?hr Ĝ?tj?A7Kƨ?$/?° ě?° ě?&x?nO?nO?Q?hr Ĝ?hr Ĝ?
=p?-V?-V?S?333333?&x?A7Kƨ?+?Õ$/?-V?n?l?`A7?nO;?nP?lD?ěS?n?-V?$/?E?E?      ?&x?vȴ9X?\(?&x?ěS?-V?-V?l?nO?hr Ĝ?      ?GzH?hr Ĝ? ěT?ěS?tj?I^5??nO;?nO?\(?n?bM?I^5??nO;?l?M?`A7?vȴ9X?hr Ĝ?M?7KƧ?7KƧ?S?-V?l?nO?ěS?      ?7KƧ?° ě?° ě?n?nO?Q?nP?nP?ěS?nO;?nO;?|hr?Q?&x?S?-V?I^5??M?GzH?|hr?lD?vȴ9X?A7Kƨ?I^5??-V?Q?GzH?nO?M?-V?° ě?      ?7KƧ?
=p?l?-V?vȴ9X?
=p?nO;?tj~?ěS?nO;?GzH?`A7L?-V?tj~?ěS?° ě?hr Ĝ?-V?-V?tj?l?5?|h?vȴ9X?Õ$/?7KƧ?+?9XbM?-V?Q?`A7L?7KƧ?&x?-V?l?n?&x?
=p?I^5??GzH?I^5??GzH?bM?nO;?
=p?$/?bM?n?&x?I^5??Q?lD?7KƧ?
=p?Õ$/?ěS?&x?`A7L?$/?ěS?$/?$/?333333?nO;?lD?hr Ĝ?bM?`A7L?bM?S?vȴ9X?bM?GzH?333333?tj?`A7?`A7?tj?Õ$/?° ě?nP?nO;?nO;?&x?7KƧ?nO;?Q?&x?l?hr Ĝ?`A7L?hr Ĝ?-V?&x?I^5??Q?ěS?tj?n?`A7L?ěS?hr Ĝ?l?nO?      ?
=p?M?&x?bM?° ě?lD?&x?&x?nO;?n?$/?\(?S?Z1'?lD?nO;?9XbM?l?-V?7KƧ?nO;?7KƧ?hr Ĝ?Q?\(?nP?GzH? ěT?n?vȴ9X?333333?lD?öE?`A7? ěT?"`?7KƧ?lD?333333?`A7?nP?-V?M?lD?&x?7KƧ?n?M?\(?lD?hr Ĝ?bM?`A7L?hr Ĝ?° ě?
=p?n?
=p?`A7L?Q?-V?\(?|hr?n?-V                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	@N&fffff@N&fffff@M33333@N@N@N      @N@N@Mٙ@M@M     @M33333@N      @N@M@M33333@M@Mٙ@M@     @LL@Kٙ@Jfffff@I@D     @F@H@     @F     @CY@C@C@     @C     @D33333@E     @F     @G@     @I      @J33333@K333333@K     @L      @K@K@Kfffff@K33333@Lffffff@L@Lfffff@M333333@MY@M     @M@Ms33333@Nffffff@O@N33333@N@O      @O     @OY@Offffff@O     @Offfff@O     @O@Offffff@O@     @Offfff@O     @O@Offffff@O33333@P,@P&fffff@P333333@P333333@P333333@PY@PL@Pl@Py@Pl@P     @Pfffff@Pfffff@P     @Pl@Ps33333@P     @Ps33333@Pl@Py@Ps33333@Ps33333@Pl@Py@Py@Py@Py@Pfffff@Py@Py@Ps33333@Py@Pl@Py@P     @P`     @Pfffff@Pfffff@Pfffff@Pfffff@P@P33333@P33333@P33333@P@P@Pfffff@P@P33333@P33333@Pfffff@P@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@P@P@P@P@P@Pfffff@P     @P     @P     @Pfffff@Pfffff@P     @Pfffff@P     @P     @P     @Pfffff@Pfffff@P     @Pfffff@P     @P@P33333@P33333@P33333@P@P33333@P33333@P33333@Pfffff@P@P@P33333@P@P33333@P@Pfffff@Pfffff@P     @Pfffff@Py@Py@P     @P     @P     @Py@Py@Py@Ps33333@Py@Py@Py@Py@Ps33333@Ps33333@Pl@Pffffff@PY@PS33333@PS33333@PL@P@     @P9@P9@P333333@P333333@P333333@P&fffff@P      @P      @P@P      @P@P33333@P33333@Pfffff@P@P@P@P33333@P33333@Pfffff@Offfff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P      @P      @Pfffff@P      @Pfffff@P@P@P@P      @Pfffff@Pfffff@P@P33333@P33333@P@P33333@P      @P&fffff@P&fffff@P,@P,@P,@P&fffff@P333333@P      @P&fffff@P,@P333333@P333333@P9@P@     @PFfffff@PFfffff@PY@P`     @Pl@Py@P     @Pfffff@P@P33333@P33333@P33333@P@Pfffff@Pfffff@P     @P     @Pfffff@P@P     @Pfffff@P@P@Pfffff@Pfffff@P@Pfffff@P@P33333@P     @P@Pfffff@Pfffff@P@P@P@P33333@P33333@P33333@P33333@P33333@Pfffff@P@P@P33333@P33333@P33333@P     @P33333@P33333@P33333@P33333@P@P@Pfffff@P@P33333@P@P33333@P@P33333@P33333@P@P@P     @P@P33333@P@P     @P@P@P@P@P     @P33333@P33333@Pfffff@P@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P@P     @P     @P     @P     @P     @P     @Pfffff@P     @P@P     @P     @P     @P     @P     @P     @P     @P     @P@P@P     @P     @Pfffff@P@P@P@Pfffff@P@P@P@P33333@P33333@Pٙ@Pٙ@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@Pٙ@P33333@P33333@Pٙ@P@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @Pٙ@Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@P     @P     @P     @Pٙ@Pٙ@Pٙ@P     @P     @P     @P     @P33333@Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pٙ@Pٙ@P     @P     @Pfffff@Pfffff@P     @Pٙ@P33333@Pٙ@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @P     @Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @P     @P     @P     @Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @P     @P@P@Pٙ@P33333@P33333@P33333@Pٙ@Pٙ@P33333@Pfffff@P     @Pٙ@P     @P     @P@P@P     @P33333@P     @Pfffff@Pfffff@P     @Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pٙ@P     @P     @Pٙ@P     @P     @Pٙ@P33333@P33333@P33333@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @P     @P     @P     @P     @P     @P     @Pٙ@P     @P     @Pٙ@Pٙ@Pٙ@P     @Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@P33333@P33333@Pٙ@Pٙ@Pٙ@Pٙ@P     @Pٙ@Pٙ@P     @P     @P     @P33333@P@Pٙ@Pٙ@Pٙ@P     @P     @Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pٙ@Pٙ@Pٙ@P     @Pٙ@P     @Pٙ@P     @P     @P     @Pfffff@Pfffff@P     @P     @P     @P     @P     @Pٙ@P     @P     @Pfffff@P33333@P     @P     @P     @P     @P     @P     @Pfffff@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@Pfffff@P     @Pfffff@P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@P     @P     @P     @P     @Pٙ@Pٙ@P     @P     @P     @Pfffff@Pfffff@P     @P     @P     @P     @P     @Pfffff@P     @Pfffff@P     @P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pٙ@Pٙ@P     @P     @P     @P     @Pfffff@P     @P     @Pfffff@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@Pfffff@P     @P     @P     @Pfffff@P     @P     @P     @P     @P     @P     @Pfffff@P33333@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P33333@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @P     @P     @P     @P     @Pٙ@Pfffff@P33333@P33333@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pٙ@P     @Pfffff@P     @Pٙ@P     @P     @Pٙ@P     @P     @P     @Pfffff@Pfffff@Pfffff@P     @Pfffff@P     @P     @P     @P     @Pfffff@Pfffff@P     @Pٙ@Pfffff@Pfffff@Pٙ@P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@P     @Pٙ@P     @P     @P     @P     @Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @P     @Pٙ@P     @P     @P     @P     @P     @P     @Pٙ@Pٙ@P     @P     @P     @P     @Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @P     @Pٙ@P     @P     @P     @P     @Pٙ@P     @P     @P     @Pfffff@Pfffff@Pfffff@Pٙ@P     @Pٙ@P     @P     @Pfffff@P     @P     @P     @P     @Pfffff@P     @Pfffff@Pfffff@Pfffff@P     @P     @P     @Pfffff@P     @P     @P     @P     @Pٙ@P     @P     @P     @P     @P     @P     @P     @P33333@P     @P     @P     @Pfffff@P     @P     @Pfffff@P     @Pfffff@Pfffff@P     @Pٙ@Pٙ@P     @P     @P     @P     @Pfffff@P     @P     @P     @Pfffff@P     @P     @Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@P     @Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@P     @P     @Pfffff@P     @Pfffff@P     @P     @Pfffff@P     @P     @P     @Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@P     @Pٙ@P     @P     @P     @P     @Pfffff@Pfffff@P     @P     @P     @Pfffff@P     @Pfffff@P     @P     @Pfffff@Pfffff@P     @P     @P     @P     @P     @P     @P     @Pfffff@Pfffff@Pٙ@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @P     @P     @P     @Pٙ@P     @P     @P     @P     @P     @P     @P     @Pٙ@P33333@P     @P     @P     @P     @P     @P     @P     @P     @P     @Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@P33333@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P@P33333@P33333@P33333@Pfffff@P@P@P@P@P@P@P@P@P@Pfffff@P     @Pfffff@P     @P     @P     @P     @P     @P     @P     @P     @P@P     @P@P@P@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P@P33333@P33333@P@P@P33333@P33333@P@P     @P     @P     @P     @P     @P     @P     @P33333@P@P@P@P     @P     @P@P33333@P@P@P@P@P33333@P33333@P33333@P@P@P@P@P@P@P@P33333@P33333@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P     @P     @P     @P@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P@P@P@P@P@P@P@P@P     @P     @P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P@P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@P@P@P@P@P@Pfffff@P@P@P@P@P33333@Pٙ@Pٙ@P33333@P33333@P33333@P33333@Pٙ@Pٙ@Pٙ@P@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@Pfffff@P     @P     @P     @P     @P     @Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@P     @Pfffff@P     @Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pٙ@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@P     @Pٙ@Pfffff@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P@P@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@P@Pfffff@P@P@P@P@Pfffff@Pfffff@P@Pfffff@P@P@Pfffff@Pfffff@P@P@P@P@P@Pfffff@P@P@P@P33333@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P33333@P33333@P33333@P@Pfffff@P@Pfffff@P@P@P@P33333@P33333@P@P@P@P@P33333@P@P@P@P@P@P@P33333@P     @P@P@P@P33333@P@P@P@P@P@P@P@P@P     @P     @P@P33333@P@P@Pfffff@P@P@P@P@P33333@P@P@P@P33333@P@P33333@P@P@P@P33333@Pfffff@Pfffff@P@P@P@P@P@P@P@P33333@P@P@P@P@P33333@P33333@P33333@P33333@P@P33333@P33333@Pfffff@P@P@P33333@P33333@P@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P@P@P@P@P@P33333@P33333@P@P33333@Pfffff@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@Pfffff@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pٙ@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P33333@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@Pfffff@P@P@P@Pfffff@P@P@P@P@Pfffff@P@Pfffff@P@P@P@P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@Pfffff@Pfffff@P@P33333@P@P@P@Pfffff@P33333@P@P@P33333@P33333@P@P@P@P@P33333@P@P@P@P33333@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    P5                                      1                                       BBEU+3b