CDF       
      time      pressure  %   latitude      	longitude         string_dimension   (         EXPOCODE      29AJ20160818   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    WOCE_ID       TAlPro     	DATA_TYPE         WOCE CTD   STATION_NUMBER        34     CAST_NUMBER       1      BOTTOM_DEPTH_METERS          
Creation_Time         2020-03-19T19:50:21.546324Z    ORIGINAL_HEADER      CTD,20200319CCHSIO
# Converted CTDOXY from ML/L to UMOL/KG using the following:
#     https://github.com/TEOS-10/GSW-Python, downloaded 2019-06-26
#     gsw.sigma0:  Calculates potential density anomaly with reference pressure of 0
#     dbar, this being this particular potential density minus 1000 kg/m^3.
#     This function has inputs of Absolute Salinity and Conservative
#     Temperature.  This function uses the computationally-efficient
#     75-term expression for specific volume in terms of SA, CT
#     and p (Roquet et al., 2015).
#     http://www.teos-10.org/pubs/gsw/html/gsw_sigma0.html 
#     Python equation used:
#         oxy_UMOL_per_KG = oxy_ML_per_L * 44.660 / ( (1000 +  gsw.sigma0(SA,CT)) / 1000. ) 
# Data source:  https://doi.pangaea.de/10.1594/PANGAEA.902330
# SHIP: RV Angeles Alvarino
# Cruise: MedSHIP cruise TalPro
# Region: Mediterranean Sea and Catalan Basin
# Ports: Palermo, Italy to Barcelona, Spain
# DATES: 20160818 - 20160829
# Chief Scientist: L.Jullion
# 43 stations
# Original file in AWI format. CCHDO Converted to Exchange format
# EVENT_CODE=unknown
# DATE: YYYYMMDD
# TIME: HHMM
# LATITUDE: degrees_North
# LONGITUDE: degrees_East
# STNNBR:  removed leading 0s from STNNBR
# CASTNO: not supplied by originator - CCHDO assigned all CASTNO=1 or CASTNO=2 for stations 11, 29
# CTDSAL: changed units from Practical to PSS-78.  Data values remain unchanged.
# CTDFLUOR: changed units from UG/L to MG/M3 as they are they are equivalent
# CCHDO added flags=2 for all parameters, as T.Tanhua notes all params are calibrated and CTDOXY calibrated with bottle samples
# Removed two test sample depths from event/station 004, dTalpro_Stn04_test_1db
# Data precision preserved as submitted.
# CTD: Who - T.Tanhua; Status - calibrated,final
#     Includes: CTDSAL, CTDOXY
#     CTDTMP NOTE: Used first occurrence of primary temperature sensor in original data file
#     CTDSAL NOTE: Used first occurrence of primary salinity sensor in original data
#     NOTE: Physical parameters temperature, salinity, oxygen, density, turbidity, chlorophyll, fluorescence are published on PANGAEA, DOI above.
# Fluorescence (CTDFLUOR): Who - T.Tanhua; Status -final
#        Instrument: WET Labs ECO-AFL/FL, FLNTURTD-2526
#        ScaleFactor: 1.00000000e+001
#        Dark Output: 0.0760
# Turbidity (CTDTURBDTY): Who - T.Tanhua; Status - final
#        Instrument: FLNTURTD-2526
#        ScaleFactor: 5.000000
#        Dark output Voltage: 0.070000
#
# Reference: Cruise report: https://epic.awi.de/id/eprint/49725/1/TAlPro_EUROFLEETS_cruise_report_V2.pdf
# CCHDO page: https://cchdo.ucsd.edu/cruise/29AJ20160818
# Metadata from original file
#     Event(s):     TAlPro-2016_034 (34) * LATITUDE: 40.000000 * LONGITUDE: 2.770000 * DATE/TIME: 2016-08-26T18:58:00 * CAMPAIGN: TAlPro-2016 * BASIS: Angeles Alvarino (URI: http://www.eurofleets.eu/np4/285.html) * DEVICE: CTD/Rosette (CTD-RO)
#     Citation: Tanhua, Toste (2019): Physical oceanography during MedSHIP cruise Talpro. PANGAEA, https://doi.org/10.1594/PANGAEA.902330
#     Abstract: The TAlPro cruise (Palermo - Barcelona, RV Angeles AlvariÃ±o, 18/-8/2016 - 29/08/2-16) occupied three hydrographic transects across the Tyrrhenian Sea, the western Mediterranean Sea and the Catalan Basin (Fig. 1) as part of the MedSHIP programme (Mediterranean Ship-based Hydrographic Investigations Program). A total of 43 stations were occupied during which physical (temperature, salinity, pressure, velocity), biogeochemical (oxygen, nutrients, carbonate system, dissolved Barium, oxygen and nitrogen isotopes) and anthropic (CFCs, SF6) parameters were measured in order to monitor the physical and biogeochemical state of the Mediterranean Sea.
#     Related to: Jullion, Loic (2016): TAlPro-2016: A Tyrrhenian Sea & Alger- provencal component of the MedSHIP Programme. hdl:10013/epic.5a866780-1f8a-45cf-8111-47b2b5dc29db
#     Parameter(s):
#         Event label (Event) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Sample code/label (Sample label) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Date/Time of event (Date/Time) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Latitude of event (Latitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Longitude of event (Longitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Pressure, water [dbar] (Press) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Digiquartz
#         Temperature, water [Â°C] (Temp) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: ITS-90
#         Oxygen, dissolved [ml/l] (DO) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 43
#         Turbidity (Nephelometric turbidity unit) [NTU] (Turbidity) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO
#         Fluorescence, chlorophyll [Âµg/l] (Fluores) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO-AFL/FL
#         Salinity (Sal) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Practical
#     License: Creative Commons Attribution 4.0 International (CC-BY-4.0)
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            pressure               	long_name         pressure   positive      down   units         decibar    data_min      @         data_max      @        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      )(  '   pressure_QC                	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      
L  P8   temperature                	long_name         temperature    units         ?C (ITS-90)    data_min      @*B3   data_max      @9Ϫ͞   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       )(  Z   temperature_QC                 	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      
L     salinity               	long_name         salinity   units         PSS-78     data_min      @B&I   data_max      @CIX   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      )(     salinity_QC                	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      
L      oxygen                 	long_name         oxygen     units         ?mol/kg    data_min      @e	k~   data_max      @r:K]   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        )(  l   	oxygen_QC                  	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      
L     CTDFLUOR               	long_name         CTDFLUOR   units         MG/M^3     data_min      6C-   data_max      ?ۤ?   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      )(     CTDFLUOR_QC                	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      
L    	CTDTRBDTY                  	long_name         	CTDTRBDTY      units         NTU    data_min      ?   data_max      ?ə   C_format      %f     WHPO_Variable_Name        	CTDTRBDTY      OBS_QC_VARIABLE       CTDTRBDTY_QC     )( (T   CTDTRBDTY_QC               	long_name         CTDTRBDTY_QC_flag      units         
woce_flags     C_format      %1d      
L Q|   time                	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      &*R   data_max      &*R   C_format      %10d       [   latitude               	long_name         latitude   units         	degrees_N      data_min      @D         data_max      @D         C_format      %9.4f          [   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      @(\)   data_max      @(\)   C_format      %9.4f          [   	woce_date                   	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3:   data_max      3:   C_format      %8d        [   	woce_time                   	long_name         	WOCE time      units         hhmm UTC   data_min        B   data_max        B   C_format      %4d        [   station                	long_name         STATION    units         unspecified    C_format      %s        ( [   cast               	long_name         CAST   units         unspecified    C_format      %s        ( \@      @      @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          @9Ϫ͞@9@9𖻘@9҈p@9Ŏ!R@9'RT@9hr!@96@9|@9Fs@9+jg@9j~@9tj~@9@4@9n.@9hۋq@9\N<@9˒:*@9@9oiD@9{s@9jS&@9Lzxl"@8<쿱@7ͿH˒@7>;5X@6N;6@6EQ@5mE@4Zݘ@3_o @3fffff@3p:@3Cg	l@2eO@2TɅ@2}b@2Mj@1Ov_@1y@1_F@1cF]c@1'E84@1;dZ@08Y@0zxl"@0s@0ܲ@0-
@0e@0@0U=@0N;5@0sP@0~Ov_خ@0*0@0v@0{P{@0Y ѷ@0%!.@0m\@0S&@0%2@/ߤ@@/}H@/x@/_F@/Ƨ@/u$/@/:>B@.h	ԕ@.m\@.wk@.jOv@.~ ѷY@.iB@.Hu%F@.8-
@./{J#:@.@.s@.
d7@.y@-E@-m\@-C-@->BZc@- ě@-.H@-G{@-jOv@-	k@-},=@-xQ@-rnO@-irGE@-X_F@-R-V@-KC,z@->"@-5fA@-*n@-Q@-T@-TɅo@,/V@,+@,C]@,nP@,2a|@,#9@,v@,}H@,<쿱@,&@,u%F
@,yD@,v_ح@,sa@O@,u'0@,x-
@,vϪ͟@,ra|Q@,g	k@,^ߤ?@,Y	k~@,T@,T#@,RGE85@,GRT`e@,?@,5?@,0 ě@,0oiDg8@,+a@@,+I^@,+]cA@,*0U2a|@,(@,"h	ԕ@,!Gz@,[W>@,K]@,ݘ@,l"h	@,e@+*0U2@+1.@+e@+C-@,-
q@,
~"@+KƧ@+~($x@+~$@+$@+Q_@+Mj@+I^5@+
(@+~@+غ)@+Ձ$/@+:@+.H@+u@+L_@+H˒@+*0U2a@+C@+}cA @+w
=p@+q_p@+mM:@+iDg8~@+jn@+mB@+jL_@+h1&x@+f@+d/@+a-w1@+`A7K@+_H˒:@+]IQ@+Z)_@+V@+S@+RW@+QN;6@+Oo @+MO;dZ@+Kq@+Ka@@+X@@+~5?|@+|ߤ@@+h@+tSM@+iDg8@+_@+ݗ+@+Ft@+{s@+vFs@+t֡a@+qu@+nVu@+iᰉ'@+cwk@+:>B@++P{@+'&@+$o h@+"`A@+!.H@+!o@+ [6@+.H@+BZc @+Q@+6z@+>@+!Gz@+'K]d@+*L_@+-(@+.p:~@+2T`d@+6+J@+ ěT@+Z@+-
q@+qi@+~($x@+
0
@+	B@+TɅ@+6z@+C]@+
V@+
O;dZ@+
\@+
C\@+_o @+҈@+@@+&@+	k@+F
L0@+,zxl@+ ѷ@+`A@+Zc@+@+ae@+ ҈p@+ 'RT`@+      @*vȴ9@*?@*$tS@*o@*b}V@*|hs@*$tS@*|hs@*%@*E@*H˒@*+j@*}H@*hr@*)_@*73@*sg@*j~@*zG@*Fs@*@*R@*\(@*'/W@*Mj@*5Xy>@*<쿱@*빌~($@*)^	@*#9@*B@*^@**0U2a@**0U2a@*p:@*r Ĝ@*Xy=@*r Ĝ@*TɅ@*@*P{@*zxl"@*jOv@*C\@**0U@*u!S@*GE85@*-V@*A [@*𖻘@*:~ @*-
q@*-
q@*;dZ@*\(@*v@*
M;@*1@*qi@*qi@*p:~@*!R<@*.2@*T@*{J#:@*H@*D@*&x@*n@*䎊q@*@N@*tj~@*a@O@*9XbN@*2a|@*4K@*z@*Ϫ͟@*KƧ@*@*Q@*F@*JE@*|@*u%F@*)y@*Q_@*^5?|@*vȴ@*,<@*"`B@*J#9@*dZ@*q@*6@*lC@*ߤ@@*PH@*쿱[@*u"@*K]@*/w@*Vl!@*}H@*v@*,=@*\N<@*@*˒:)@+ 4m9@+ n@+$/@+e+@+}Vm@+,zxl@+$@+@+\N@+?@+tSM@+o i@+O
@+1.@+-@++I@+1&x@+Xy=@+r Ĝ@+TɅ@+	Q@+	@+	'RTa@+	^5?}@+	y@+	ᰉ'@+	lD@+
	 @+
d7@+
g	@+
n@+I^@+C%@+~($@+s@+s@+s@+"h	ԕ@+I^5?@+1&y@+a@@+U=@+q@+U=@+xF]@+xF]@+:)z@+q@+Ƨ@+҈@+s@+1&y@+L_@+1&y@+҈@+҈@+C]@+U=@+P{@+
g	@+	@+	*0U2a@+9Xb@+r Ĝ@+eO@+eO@+$xG@+ݗ+@+L/{J@+	@+&IR@+@+\(@+R<6@+ C@+ hۋq@+ 'RT`@*?@*o@*vȴ9@*@*vȴ9@+ 'RT`@+ u!@+ IQ@+ ѷX@+@N@+:S@+ae@+R<6@+s@+@4n@+&IR@+&IR@+e+@+@+.H@+@+ IQ@+@N@+Gz@+ae@+|Q@+s@+3@+@4@+@4@+e@+@+@+n.@+'R@+Gz@+ C@+ n@*cA @*u%@*>B@*vȴ@*ݘ@*kP|@*C\@*@*|@*rGE8@*JE@*>6z@*ȴ9X@*Xy=@*j~@*!-w2@*R@*'RT@*:~ @*-
q@*oiDg8@*'RT@*oiDg8@*'RT@*N;5@*䎊@*W@*Z@*Mj@*g	l@*PH@*䎊q@*䎊q@*m\@*䎊q@*䎊q@*@*Mj@*@*PH@* ě@*T`d@*n@*񂩓@*𖻘@*Vϫ@*-V@*iDg8@*+@*.2@*zG@*hr!@*s@*=p
@*TɅ@*u%F@*@*@*r Ĝ@*Xy=@*1&x@*E84@*YJ@**0@*㢜wk@*S@*F]c@* ѷ@*@4@*ᰉ'R@*Gz@*C@*ව4m@*[6@*
qu@*6@*
qu@*@*߾vȴ9@*U=@*5?|@*b@*}H@*Z@*C,zx@*$@*۲m]@*~$@*=K^@*Y}@*PH@*y=c@*Q@*73@**0@**0@*rG@*1@*!.I@*_ح@*E@*'0@*'0@*'0@*E@*֡a@*9XbN@*a@O@*҉@*ҕᰊ@*ңS&@*-V@*2W@*A [@*У
=q@*Ж@*Љ'RT@*а{@*о
(@*`A7@*{@*Ж@*U2a|@*bM@*Љ'RT@*-
q@*ϝ-V@*t@*jOv@*@*̿[W?@*̋C@*̋C@*~($x@*1&y@*C,z@*ڹY@*ʌL_@*	 @*1&x@*ǻ/V@*ǮzH@*Ǔݗ+@*Ǔݗ+@*Ǡ	k@*lC@*_o@*@*&I@*s@*oiDg@*Ňݗ@*zxl"h@*e@*āo h@*āo h@*g8}@*Z1@*g8}@*g8}@*āo h@*Ďqj@*ěS@*tSM@*ï@*74@*wkQ@*h	ԕ@*&IR@*7Kƨ@*n@*حV@*[W>@*[W>@*[W>@*|hs@*b}V@*"@*,=@*>@*?@*Q@*5Xy@*A@*/V@*>B@*xl"h
@*C\@*C\@*6C@*"`@*_o@*4֡b@*U@*)@*tj@*l"h	@*73@**0@*}H@*R<6@*Z@*@*GE85@*:)y@*iB@*
M;@*(@*jOv@*(@*q@*~($@*:)z@*~"@*@*7KƧ@*Dg8~@*k~(@*B@*B@*x@*x@*@*oiD@*Dg8~@*ۋq
@*eO@*>BZc@*fA@*_o@*Fs@*-@*,<@*fffff@*@*/@*M:@*\N@*%2@*@*eO@*{J#9@*n.3@*a@N@*,zxl@*wkQ@*h	ԕ@*@4n@*Gz@*C@*-
@*[W>@*Ft@*6z@*vȴ9X@*%@*%@*vȴ9X@*%@*6z@*҈p;@*Q@*b@*N;@*$@*m]@*A@*A@*A@*q@*q@*vȴ@*u%F@*|@*	k~@*e+@*PH@**0@*bM@*3@*1@*Xe,@*>6z@*_ح@*$/@*?|h@*Z@*O
M@*Fs@*g@*҉@*m@*sP@*W@*䎊q@*m@*sP@*p:@*{m@*a|Q@*䎊@*n@*s@*n@*N;6@*l@*l@*l@*u!S@*[W>6@*[W>6@*@*@*r@*v_ح@*v@*+@*+@*t@*t@*Vu@*.2@*Vu@*c	@*Vu@*H@*!R<@*!R<@*H@*H@*!R<@*U=@*I^5?@*0
@*ᰉ'@*'RTa@*x@*7KƧ@*TɅ@*#@*1&x@*Xy=@*-@*>BZc@*#@*&@*]cf@*1.@*1.@*n/@*n/@*S@*oiDg@*oiDg@*8YK@*1@*@*ݗ@*+a@*?@*@*	@*@*@*wkQ@*@4n@*3@*@4n@*Zc@*@4n@*.H@*-w1@*[W>@*Ft@*~Q@*~iB@*~($x@*}+j@*|>@*|#x@*|]ce@*{Q@*{5Xy@*{S@*{6@*{lC@*{lC@*{$@*{5Xy@*{q@*{qu!@*{/V@*zG{@*z>B@*zC\@*y>BZ@*yb}@*y=b@*xF@*x-
@*xQ@*x}H@*xbM@*wXe@*v}Vl@*tj~@*s*0U2@*stj~@*stj~@*sߤ@*sg	l@*s҉@*r<64@*rᰊ@*rGE85@*qR@*qN;6@*q4J@*pU2a|@*o@*o@*oiDg8@*o4֡a@*nc	@*l@*lcA \@*ks@*kC]@*kC]@*ks@*k~($@*kU=@*k~($@*kU=@*k6z@*k'/@*jڹY@*jg	@*jn@*jڹY@*jfB@*jfB@*jڹY@*jn@*jL/{@*j0
@*j~"@*iᰉ'@*ioiD@*iQ@*i7KƧ@*hۋq
@*h@*h9Xb@*hTɅ@*hTɅ@*h@*h@*g-@*g/V@*glC@*glC@*glC@*g+I@*g@*g@*fA@*f]cf@*f'@*fYJ@*f1.@*ezxl"h@*eQ@*dM:@*c\N@*c@*c@*c{J#9@*c9@*c9@*cS@*cS@*c	@*b@4n@*a@*`ѷX@*`4m9@*`[6@*`u!@*`NU@*`A7K@*`NU@*`-
@*`u!@*`-
@*`4m9@*]}H@*\hr@*\hr@*\#x@*\쿱[@*\N;@*\]ce@*\PH@*[S@*[5Xy@*[m]@*[S@*[J#9@*[=K^@*[~$@*[q@*[~$@*[~$@*[J#9@*Z)_@*Zvȴ@*ZkP|@*Z^5?|@*Z1'@*Z1'@*Zu%F@*Y"`@*YD@*Y+@*X73@*W@*W$tS@*Vȴ9X@*VFs@*Vl!-@*V+J@*VE@*V4K@*Ush@*U?|h@*TzG@*T9XbN@*T9XbN@*TFs@*SMj@*S@*Sg@*TJ@*S@*S@*SZ@*S&@*RsP@*R䎊q@*Rm\@*R<64@*RnO@*R:)y@*R:)y@*R䎊@*Rs@*QR@*QR@*QR@*Q-@*QR@*Rs@*R:)y@*QiB@*Q-@*QiB@*Q2W@*QX@*Qo@*QA [@*QA [@*Q[W>6@*Qhr @*Qu!S@*Qu!S@*Rs@*QR@*QX@*Qo@*Qu@*Q@*Qo@*Qu!S@*Q[W>6@*QN;5@*PD@*P@*PoiDg8@*P-
q@*O\(@*N+@*NT@*NO;@*NT@*NT@*N!R<@*MjOv@*MM:@*MM:@*M%@*M@*M
qv@*M8Y@*Mw1@*M5Xy>@*LC@*KxF]@*KU=@*JfB@*J~"@*KI^@*K'/@*JJL@*Iᰉ'@*IlD@*IlD@*JOv`@*J#9@*JW'@*JJL@*I^5?}@*J0U2a|@*JL/{@*J0U2a|@*Ik~(@*IoiD@*Ix@*H	ԕ+@*H@*HeO@*HeO@*Hr Ĝ@*H1&x@*G/V@*G/V@*G#@*GfA@*Gݗ+@*G#@*HK]c@*Hr Ĝ@*H˒:*@*Hr Ĝ@*H@*Hۋq
@*H@*H@*H\)@*I ѷ@*I ѷ@*I7KƧ@*IDg8~@*Ik~(@*I^@*I^@*Ix@*I'RTa@*I^5?}@*IB@*H@*H@*H@*H@*H@*Hp:@*G#@*GzH@*G	k@*GRT`e@*FL/{J@*F
L/@*F$/@*FL/{J@*Ffffff@*Ffffff@*Fs@*F@*FL/{J@*En/@*ES&@*ES&@*Eo i@*DS@*DTɆ@*DZ1@*D2W@*D2W@*D?@*D?@*DM:@*Dg8}@*DtSM@*Dqj@*Dqj@*DTɆ@*D?@*D*0@*DJM@*De@*Eo i@*Eu@*E+a@*EF
L0@*Ezxl"h@*Eݗ@*E@*En/@*E@*E@*E8YK@*EoiDg@*Eڹ@*EoiDg@*F
L/@*Eڹ@*Eڹ@*En/@*E@*EO
@*EO
@*E@*En/@*En/@*En/@*E@*En/@*EO
@*Eݗ@*ES&@*Eo i@*Eu@*E84֡@*DS@*DxF@*CA [@*CA [@*C%2@*CZ@*CeO@*CS@*C9@*CnP@*CnP@*CnP@*CS&@*CnP@*C,zxl@*C,zxl@*CZ@*CF]c@*CF]c@*C	@*B ѷ@*B@*B}Vm@*B ѷ@*B ѷ@*B ѷ@*B74@*BC,@*B ѷ@*B ѷ@*BC,@*B74@*B74@*B74@*CS&@*CS&@*CS&@*CnP@*CnP@*CnP@*C	@*C	@*C9@*CS@*CS@*CnP@*CnP@*BC,@*B@*B}Vm@*B@*B@*B ѷ@*B74@*CS&@*CnP@*C	@*C9@*CS@*Ca@N@*Cn.3@*C{J#9@*CeO@*Cwk@*C@*C@*C@*C
=p@*CA [@*C%2@*C%2@*C
=p@*CZ@*C$@*C{J#9@*C$@*C{J#9@*Cn.3@*C	@*C	@*C	@*BC,@*B}Vm@*B3@*B3@*B3@*BZc@*B@4@*B\(@*B@*B@*B@*B`A@*B74@*CS&@*CnP@*C	@*CnP@*C	@*C,zxl@*CS                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     @Bxl"h
@Bxl"h
@BkP|@B@4n@B#9@B:)y@B&IR@BOv`@Bu%F@B@BI^5@B䎊@BC\@Bh	ԕ@B~"@BkP|@B6C@B(@B*0U2a@BěT@B'RT`@BO;d@B@B'@BU@BzH@B8}H@B>@BVl!@BQ_@Bj~@B_o@Be@B@N@B&I@BwkP@B+jg@B@BwkQ@Bo@B;dZ@B@B1@BW'@BS&@B*0@B4m@BTɅo@B=K^@B_o @B-
@BZ1@B4m@B7Kƨ@Bm]@BA@Bȧ@Bə@BrG@By@B{m@BiB@Bԕ*@BE84@B܄?@BɅoi@Bޚ,<@BPH@BYJ@B+jg@B@BlD@Bn@B웥S@BE@B+@B
(@B|@B@4n@BOv`@B͞&@BW>6z@BK]@BF
L0@B8YK@B%@B\N<@B}Vl@B-
q@Bu%F@B\)@BL_@BU=@BwkP@B%F
L@BM:@BBZc @BT@BAs@C @C -
@C PH@Cu@CT`d@C@4@Cn.3@CxF@Cm8@Chr!@CH@CIQ@C-@Cݗ+@Chۋq@C4֡b@C	JE@C	'R@C	iB@C	s@C
@4@C*0U2@CI^5?@Cq@C@C
jOv@C
cA @Cvȴ9X@C1@CkP@C@C:~ @C@C:S@Cu%F
@Cxl"h
@C@Cu%@CF]c@Cg@C~($x@C[W?@CK]@CB@C$/@Cᰉ@COv_@C
(@C6z@C'/W@Cp:@CfA@Cce@CSMj@CFs@CڹZ@C+j@Cڹ@C@CT@CXe@C *0U@C 6@C#@C;dZ@C }H@C bM@C -
q@C+@C1@Cx@CC-@C,@C4֡a@CRT`e@C[W>@C U2a|@C )^@C!	k~@C!=b@C!^@C!@C!ᰉ'@C!lD@C"u%F@C"0U2a|@C"Zc@C"p:@C"@4@C"{m@C"qiC@C"W'@C"GE85@C"M@C"kP|@C#eO@C&;5X@C&$/@C%M:@C'#@C(C@C)@C)0
)@C($tT@C(p:@C(	k@C)$/@C(@C(`A7@C)A [@C)rGE8@C'-@C'?@C(@C(
(@C(e+@C)Gz@C)(@C)N;6@C)ᰉ'@C)s@C*T`d@C*}Vm@C*c	@C,xF@C,Z@C-$/@C. ѷY@C..2@C.ߤ?@C/4m@C.Ϫ͟@C.z@C.R<6@C.L/{J@C.BZc @C.R<6@C.fffff@C.Fs@C/	@C/˒:)@C0>BZc@C0{@C0
=q@C0F@C1[W>6@C1@C1@C1X@C21'@C2T`d@C2qiC@C2u%F
@C2xl"h
@C2qiC@C2xl"h
@C2p:@C2@C3)^	@C3@N@C3W>6z@C3g	l@C3qu!@C3wk@C3%2@C3\N@C41&y@C4PH@C5?|h@C5!R@C5v@C5n/@C5@C5C\@C61.@C6iB@C6+J@C6@C6Fs@C6@C66z@C61@C7Xe@C7v@C7!-w1@C7Xe,@C74m@C7kP@C7͞@C7K]d@C7@C7rG@C8     @C8$xG@C8'RT@C8TɅ@C8e+@C8C@C8$tT@C9@N@C9e+a@C9'RTa@C9"`@C:e+@C:\(@C;S&@C;P{@C;q@C<n.@C<C,zx@C<VϪ@C<]ce@C<`d@C<o h@C<7@C=:@C=2a|@C=}H@C=sh@C=@C=@C=8YK@C=ڹ@C>$/@C>YJ@C>z@C>qi@C>,<@C>m\@C?
=p@C?.H@C?H˒:@C?eں@C?zH@C@oiDg8@C@@CA@CAA [@CAhr @CA'RTa@CAԕ*@CBI^5@CB3@CBQ_@CBqiC@CB~"@CB~"@CBݘ@CB0
@CB>B@CBn@CBW@CB`A@CB ѷ@CB䎊q@CBm@CB74@CCS&@CCC,z@CC,zxl@CC9@CCC%@CCP{@CCW>6z@CCg	l@CC@CCS@CCg@CD@CD,<@CD<쿱@CD]ce@CD?@CDJM@CE'0@CE%F
L@CE5Xy>@CE<64@CEO;dZ@CEY|@CEM:@CEXy=@CEϪ͞@CEᰉ@CFzG@CFVu@CFVu@CF_ح@CFp:~@CF@CF$t@CFFs@CFFs@CFFs@CFFs@CFFs@CFFs@CF@CG@CG
=p@CGXe@CG.H@CGRT`e@CGeں@CGy@CG$tS@CG-V@CGkP@CG	k@CG	k@CG?@CGzH@CG3@CGo @CGحV@CGVϫ@CGVϫ@CGVϫ@CG-@CG-@CG䎊r@CG䎊r@CGrGE9@CG#@CGrGE9@CG#@CHF]d@CH@CHF]d@CH@CH	ԕ+@CH*0U@CH6@CH6@CH}H@CH6@CH6@CH6@CH}H@CH'RT`@CHK]c@CH[6@CHXy=@CHQ@CH[6@CHbM@CHhۋq@CHoiDg8@CH'RT@CH@CH4m@CHp:@CHD@CHe+@CH{@CI	k~@CI+@CI@CI#w@CI:S@CIN;5@CITɅo@CITɅo@CI[W>6@CIae@CIu!S@CIx@CI|Q@CIR<6@CIR<6@CI@CI@CIn.@CI(@CI'R@CI|@CI|@CIX@CIX@CI|@CI|@CI|@CIB@CI(@CIb}@CIae@CI[W>6@CIXbM@CITɅo@CIQ@CIQ@CIN;5@CIN;5@CI^@CIae@CIQ@CIJE@CI=b@CI7KƧ@CI0
)@CI@N@CIrGE@CI@CI@CI@N@CI@N@CI+@CI_p@CI4J@CIGz@CI[W>6@CIk~(@CIrGE8@CIb}@CI|Q@CI|Q@CI|Q@CI|Q@CI|Q@CI@CI'RTa@CIn.@CI'RTa@CI'RTa@CIu@CI@CIR<6@CIo@CI7Kƨ@CI@CIb}@CIb}@CIu!S@CIu!S@CIrGE8@CIhr @CITɅo@CIDg8~@CI0
)@CI-w1@CI-w1@CI*0U2a@CI#w@CI&x@CI [7@CI+@CI	k~@CHPH@CH{@CH\)@CH{@CHC@CH@CH҈p@CH҈p@CHD@CHF@CHѷX@CH)^@CH)^@CH)^@CHěT@CHTɅ@CH)@CH{@CHd8@CH@CH-
@CH@CHtj@CHtj@CH-
@CH'RT@CH˒:*@CHu!@CHoiDg8@CHl"h	@CHoiDg8@CHl"h	@CHl"h	@CHhۋq@CHbM@CH_F@CHU2a|@CHU2a|@CHK]c@CHH@CHH@CHK]c@CHK]c@CHA7K@CH73@CH1&x@CH'RT`@CH'RT`@CH}H@CH*0U@CH
qu@CH@CH@CH@CH@CH
qu@CH*0U@CHbM@CH
qu@CHF]d@CH	ԕ+@CH
qu@CH@CH@CGrGE9@CGrG@CG@CG;dZ@CG@@CG;dZ@CG@CGحV@CG+@CG@CG˒:)@CGK]d@CG[W>@CG͞@CG&@CG?@CG	k@CG	k@CG-V@CG	k@CGkP@CG$tS@CG@CGO;d@CGO;d@CG@CGO;d@CG	@CG	@CG	@CGO;d@CGO;d@CG	@CGO;d@CG	@CG	@CG&@CG4m@CGv_ح@CGsPH@CGlC@CGiDg8@CG\(@CGRT`e@CGKƧ@CGH˒:@CGH˒:@CGE84@CGAs@CG>6z@CG8}H@CG+I@CG!-w1@CGv@CG@CG)^@CG
M;@CGFt@CG hۋ@CF!.I@CF"@CFFs@CFMj@CF@CF쿱[W@CF]cf@CF]cf@CF]cf@CF+@CFϪ͟@CFϪ͟@CF҈p;@CFA@CF2X@CFaf@CFFs@CF}Vl@CFz@CFp:~@CFH@CF5?|@CF.2@CF+jg@CFOv_@CFzG@CFzG@CF ѷY@CEE@CEC\@CE!.@CEC\@CF ѷY@CEڹ@CEC\@CEC\@CEC\@CE!.@CEE@CEᰉ@CES@CE?@CE8YK@CEϪ͞@CE@CE8Y@CE\(@CE8Y@CE@CEU=@CEv@CE@CE%@CE+j@CE+j@CEO
@CEhr!@CEhr!@CEڹZ@CEM:@CE$/@CEzxl"h@CEm\@CEce@CEce@CEVl!@CEL_@CEF
L0@CEB@CEF
L0@CEB@CE?|h@CE?|h@CE<64@CE?|h@CE?|h@CE2a|@CE!.H@CE*0@CEu@CEu@CEV@CEV@CE'0@CE'0@CD>@CD!-w@CDhr@CD@CDu"@CDu"@CD֡a@CDZ@CDɅoi@CD?@CD?@CD7@CD?@CD1&@CDTɆ@CD쿱[@CDS@CD_@CDN;@CD?@CDo h@CD~($x@CDzG@CD~($x@CD~($x@CDwkP@CDtSM@CDtSM@CDq@CDj~#@CDg8}@CDg8}@CDg8}@CDcA \@CD`d@CD]ce@CD]ce@CDVϪ@CDSMj@CDSMj@CDPH@CDFs@CD<쿱@CD9XbN@CD2W@CD,<@CD,<@CD(\@CD(\@CD!-w2@CD!-w2@CD!-w2@CDQ@CDtj@CDtj@CDL_@CDL_@CDL_@CDL_@CD@CDxF@CCs@CCݗ+k@CC
=p@CCa@@CC|@CC5Xy@CCa@O@CCE@CCE@CCZ@CC@CCm]@CC@CC*0U2@CCߤ@CCߤ@CC$@CCq@CCq@CCMj@CCq@CCeO@CCeO@CC@CC~$@CC{J#9@CC{J#9@CCjf@CCg	l@CCZ@CCS@CCS@CCP{@CCMjO@CCJ#9@CCF]c@CCF]c@CCC%@CC=K^@CC33333@CCC,z@CCs@CCnP@CC҉@CCS&@CB~@CBD@CBm@CBC,@CB䎊q@CB ѷ@CBڹY@CB ѷ@CB ѷ@CBڹY@CB ѷ@CBڹY@CB,<@CB͞&@CB͞&@CB)_@CB@CBY@CB}Vm@CB>B@CB>B@CBL/{@CBS&@CBvȴ@CB0
@CB0
@CBݘ@CB~"@CBa|Q@CBT`d@CBQ_@CBM@CBM@CBJL@CBC\@CB@4n@CB=p
@CB3@CB-V@CB-V@CB&IR@CBs@CBI^5@CB	 @CBn@CA.H@CAY}@CAiB@CAԕ*@CAo@CAo@CAo@CAy@CAD@CA2W@CAD@CAD@CA^5?}@CAX@CAX@CA|@CA'R@CA'R@CA'R@CA'R@CA'R@CAB@CAl@CA(@CA(@CAu@CA@CAR<6@CAo@CA~($@CA~($@CA7Kƨ@CA~($@CA7Kƨ@CA7Kƨ@CA@CA|Q@CAu!S@CArGE8@CArGE8@CArGE8@CAo hی@CAe+a@CAhr @CAe+a@CAe+a@CAae@CA[W>6@CA[W>6@CAN;5@CADg8~@CA:S@CA7KƧ@CA4J@CA*0U2a@CA-w1@CA#w@CA#w@CA&x@CA#w@CA_p@CA+@CA	k~@C@PH@C@\)@C@\)@C@\)@C@{@C@4֡b@C@4֡b@C@{@C@4֡b@C@@C@`A7@C@TɅ@C@4m@C@4m@C@{@C@U@C@U@C@d8@C@@C@-
@C@IQ@C@IQ@C@u%F@C@tj@C@tj@C@tj@C@@C@tj@C@-
@C@-
@C@YJ@C@n@C@˒:*@C@˒:*@C@y=c@C@u!@C@r Ĝ@C@oiDg8@C@l"h	@C@bM@C@Xy=@C@NU@C@H@C@A7K@C@>BZc@C@73@C@>BZc@C@4m9@C@-
q@C@*0@C@$xG@C@6@C@*0U@C@bM@C@*0U@C@@C@F]d@C@@C@	ԕ+@C@@C?#@C?rGE9@C?䎊r@C?Vϫ@C?-@C?-@C?rG@C?rG@C?@@C?@@C?@@C?;dZ@C?;dZ@C?@C?حV@C?@C?حV@C?حV@C?حV@C?fA@C?fA@C?@C?+@C?+@C?K]d@C?K]d@C?o @C?K]d@C?o @C?K]d@C?o @C?˒:)@C?K]d@C?@C?@C?vȴ9@C?/V@C?/V@C?/V@C?r@C?3@C?zH@C?͞@C?͞@C?	k@C?kP@C?@C?O;d@C?&@C?	@C?{J#:@C?{J#:@C?y@C?v_ح@C?v_ح@C?v_ح@C?y@C?v_ح@C?sPH@C?sPH@C?lC@C?\(@C?RT`e@C?RT`e@C?E84@C?As@C?H˒:@C?E84@C?;dZ@C?8}H@C?4֡a@C?4֡a@C?4֡a@C?4֡a@C?8}H@C?1@C?.H@C?1@C?1@C?.H@C?!-w1@C?'/W@C?!-w1@C?)^@C?@C?@C?)^@C?)^@C?
M;@C?Ft@C?@C?Ft@C?@C? hۋ@C?@C?@C?Ft@C?@C?Ft@C?Ft@C?
=p@C?Ft@C?Ft@C?Ft@C?Ft@C?@C?Ft@C?Ft@C?@C? hۋ@C?@C?@C?@C?Ft@C?Ft@C>Fs@C>"@C>"@C>"@C>Fs@C>Mj@C>쿱[W@C>1@C>1@C>ߤ?@C>Ϫ͟@C>҈p;@C>A@C>A@C>҈p;@C>҈p;@C>A@C>҈p;@C>ȴ9X@C>ߤ?@C>ߤ?@C>@C>Q@C>2X@C>}Vl@C>}Vl@C>-@C>-@C>T@C>T@C>-@C>-@C>af@C>T@C>af@C>T@C>-@C>T@C>T@C>6z@C>6z@C>6z@C>6z@C>}Vl@C>6z@C>}Vl@C>6z@C>6z@C>6z@C>6z@C>}Vl@C>-@C>6z@C>6z@C>6z@C>-@C>-@C>T@C>T@C>T@C>T@C>T@C>T@C>af@C>@C>af@C>af@C>@C>af@C>,<@C>Fs@C>O;@C>Fs@C>@C>+J@C>+J@C>%@C>IQ@C>IQ@C>z@C>z@C>vȴ9X@C>s@C>vȴ9X@C>s@C>p:~@C>p:~@C>l!-@C>l!-@C>vȴ9X@C>p:~@C>p:~@C>l!-@C>iB@C>fffff@C>fffff@C>fffff@C>c	@C>c	@C>c	@C>c	@C>_ح@C>_ح@C>_ح@C>_ح@C>_ح@C>\N<@C>\N<@C>\N<@C>_ح@C>\N<@C>\N<@C>\N<@C>\N<@C>YJ@C>YJ@C>YJ@C>YJ@C>\N<@C>Vu@C>Vu@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>L/{J@C>Ov_خ@C>L/{J@C>L/{J@C>L/{J@C>Ov_خ@C>L/{J@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>L/{J@C>L/{J@C>Ov_خ@C>L/{J@C>L/{J@C>L/{J@C>H@C>E@C>E@C>E@C>E@C>E@C>BZc @C>?@C>?@C>8YJ@C>;5X@C>5?|@C>5?|@C>5?|@C>5?|@C>5?|@C>8YJ@C>8YJ@C>1.@C>5?|@C>8YJ@C>5?|@C>5?|@C>5?|@C>5?|@C>5?|@C>5?|@C>5?|@C>1.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     @i@iSMj@i6C@i}H@jAs@iF@izG@iL_@j-
@j
0
@jcA @i$@i?@jM:@j@jI^5?@j@js@j	ԕ+@jB/{J#@jb*0@j@l/e+a@n
(@pԕ*@pqu!@pмn/@pE@pߤ?@q,)_@q^lC@q\N@qu%@r hۋ@r
=p@qɎqj@qݗ+k@rzH@r:K]@r^5?}@q:S@qXy=@q1oiD@peO@pԓݗ+@p@pH˒:@p|Q@qHs@qT`d@qw33333@q'#w@pa@O@p[$xG@p~7Kƨ@p@p>BZ@pVq@p%@o+@p4֡a@pAߤ?@p)u!@ou@o~$@oXbM@o ѷ@o;5X@o?@n@4n@n2ݘ@nnP@nC@nI^5@mTɆ@mdZ@mPl!-@m_%@m:	ԕ+@l~"@lᰉ@mo@ma@N@ls@la@N@lPH@l!.@lbu%F@lae@lgk~(@lGE85@lg	@lis@l$@ľ@l	k@lf	k@lVBZc @l;+@l4Ʌoi@l7M:@l!;dZ@lE@l?@k
(@l*?@l<<64@lᰉ'@kh	ԕ@k(F]d@kS@k@k{m@l1C,z@lRl"h	@l5Xy@l)^@l˒:*@lbM@kl"h	@k1.@k:)y@kXe@kp:@k7@k.2@l쿱[@l
=q@l_iB@lXbM@kbM@k`@kM#@k]84֡@kb@khNU@ki@kIr@kO>6z@k^|@k{S@k}S&@kwrGE8@k^l"h	@kEce@k)	@k
hr@kϪ͞@kNJM@kMp
=@kBH@k<'@k>Ov`@k+.H@k+#@k)4֡a@j,zxl@jܹ#x@kO
@kOY}@kr
=q@km@N@kR>B@kGڹZ@kD*@k af@k]ce@kry=c@kJ#9@kU=@k~$@knP@k'RT`@koݗ+@k*@jU=@j2W@j>B[@j
=p@jҀIQ@j4֡b@jo i@j@4@je@j~($@j|@jϡ@jaf@j!-w1@k>6z@kDNU@k^5?|@k	ԕ+@kFt@k	A [@js@j(@jϏo@je@jNXy=@jE.H@jq
=p@jK]@j2a|@jI^5?@j@jc	@j}Vm@j-
@jh_@jRQ@jG-w1@jUo i@jhs@j$tT@je+@k%P{@kcϪ͞@kZzG@k,<쿱@k)^	@j$tS@j˒:)@j~@jt)^@jD(\@j3{J#9@j?C\@j@N@jwkQ@jLj~#@j-w1@jY@jbwkQ@jQoiDg@jL/{@iYJ@i@js8}H@jMsh@iJ@i`)y@i:@h
qv@hwkP@h-w1@hD@hv@hTɅ@h˒:)@hE@h֡a@h^5?}@hd7@hU=@hQ@h6z@hy=c@hS&@i	rG@is@i+j@i')^@i9C,z@iB,<@i)a@@i$BZc @ice@i|Q@iS@hO;dZ@hR<6@h3@hIQ@hp:~@h_F@hϪ͞@h33333@hp:@h#9@hJL@i8YJ@i˒:*@ibM@i%|Q@i#@i1@iXڹY@iT}Vl@iT>B@i{o@iIQ@iwb}V@iAs@izG@ivȴ9X@i=b@ifB@iY}@isP@i{4m@iWb}V@iC@i;R<6@i6t@h ѷ@hvU2a|@h+Q@h)R@hDM@h^{@hV[6@h6hۋq@h6eO@hG
M;@hk'/W@hm]@h>6z@h>6z@h!.H@hu!@hm,=@hbɅoi@hK+a@h>6z@hPQ@hL@h7X@h0@h(@hg	@h Ov`@hZc@hFs@gPH@g4J@g
=q@g1&x@g޾
(@g)^@g@g:@gqj@g$tT@gm\@gbM@g8Y@gTɆ@gv@gD*@g~G{@gc	@g5Xy>@g`A7L@g7@g~ߤ?@gBZc @gz9Xb@gwVϫ@gj	 @g^C@ghT@gn1.@gh
=q@gW-@g@[6@g+M:@gu!S@gn@g u%F
@f@f6z@f?@f7KƧ@fěT@f@fQ@fQ@fC,zx@f;dZ@f|@fC@fK]@f_o @fe@fw1@fO
M@fJ@fqY|@f|u!@f|u!@f=K^@ft@f{nP@f\)@f:)z@fo$@fb@f]%2@fV{@fP     @fI
M;@f?TɅo@f;)^	@f5@f@?@fJnO@fJnO@f@?@f<qi@f1n.3@f*|@f-B@f1lC@f.T@f*z@f#eO@f#eO@f.T@f'm]@f'm]@f+ݗ+k@f&NU@f-@N@f0_o @f+?@f"#9@f_o@fzG@fᰉ@f	!.H@fs@f=p
@eaf@e
(@e=b@e1@e$@eIQ@eяo@e؀IQ@eU2a|@eC,z@eշr@eʛS@eᰉ'@eR<6@e҉@eʙ0
@eB@e3@eщ7Kƨ@eC\@e33333@eղ-V@e+@eOv`@ej~#@eL_@eH˒@eMjO@eMjO@ew1@eá@eà	k@e>B[@e\)@e	@eJ#9@etj~@e	@en@eXy=@eXy=@eW>6z@eeO@e!-w@e>B@eÝ-V@e@eH˒:@ee@eH˒:@e@eMj@eMj@e9XbN@eߤ@@eIQ@eGz@e@eS@em\@ebM@e6C@eSMj@e~($@eᰉ'@eo hی@e64@e@esh@eѷX@en.3@en.3@e`A@e4m9@e4m9@e	@e	k~@e|@eAs@eʇ#@e1&y@e+@e+@el"h	@eϪ͞@exl"h
@ejOv@e͞&@eÔO
@e@e&@eM@eǾvȴ9@eZc@ee@eÓ@eaf@e@N@eaf@et@e)^@e\)@e\)@e	@eÑhr!@eXy=@eǼn/@eW@evȴ@eD@e-
q@e-
q@e@eIQ@e쿱[@e:S@eά1&@e՝-V@e:@e9XbN@ey@e+I@e܎qj@e@e hۋ@es@e hۋ@eU=@e܎qj@e hۋ@e$tT@eΪd8@e8YJ@e*0U2a@eව4m@e܌@e*0U2@e~$@eE@e@eXy=@e6z@eD*@e6@e-@e@e@e@eu"@e|hs@e܋C@eC,zx@e7@e7@eN;6@e禵(@em8@e_o@eߤ?@e禵(@em8@eiB@f3@f
%F
L@eAs@e^@e^@eO;@e쿱[W@e&I@ePH@fR<6@fR<6@em]@eTɅ@eTɅ@eOv_خ@ez@eݗ@ey=c@fg@f͞&@f 
=q@e@N@fO
@eJM@e[@fO
@fݘ@fڹY@fݘ@f0U2a|@e@e"`@fL_@fڹY@f	k@f=p
@fs@f>BZ@f?@f>B[@f.H@f&䎊@f#Xe,@f*I^5?@f'@ftj~@f;5X@f-w1@ffffff@fU=@f-w1@f#XbM@f@f$@f-rGE@f-rGE@f*H@f&Ov_@f+q@f4n.@f.s@f-rGE@f+q@f.s@f*H@f*H@f/8YK@f.r Ĝ@f5dZ@fHF@fF
(@f6)_@f?C,z@f?C,z@fDd8@fKߤ@fHF@f<U2a|@f*GE85@f2wkQ@f?C,z@fCF]c@f=@f=@fF
qu@fNbM@f?qu"@f?qu"@fCF
L0@fD@fNa|Q@f]Xy=@fa@f_҉@fd0
@fj'RT`@f_'0@fLE@fXe+@fnQ@fnQ@fnQ@flhr@flhr@fj&IR@fg_o@fc4֡a@fj&IR@fnQ_@flhr@fc4֡a@fd_@flhr@f^5?|@fVϫ@f}$tS@fr{m@frzG@fuAs@f~>@fg	@fz*0@fj%1@frzG@fsiB@fzA@f$tS@f~"@f$tS@f]ce@f$tS@fy@f/@f@4n@f?@fvT@fyk~(@fOv`@fFt@f-@f\(@fFt@fM@f*1@f?@fn.@f*1@f#9@f[W?@f#9@fM:@fiDg8@fFs@f5Xy@fM:@fx@f[W>6@f5Xy@f'R@fn@f>6z@f@fJ@fhr @fhr @f?@f@fL/{J@fhr @f<쿱@fv_ح@f'RTa@flC@fYJ@f%@f.2@fJE@fXe,@f<쿱@fg8}@f@f [7@f+@fȐ$t@fȑN;@f@f;5X@f ѷ@f1@f̻@f-w1@f}Vl@flC@f;5X@f̻@f;5X@ffffff@fȐ$t@f@f$@f@f;5X@fڞ@fn.@fӬq@fH@fς@f`A7@f:S@frGE@fH@f-w1@f̻@f̺)@f̺)@fE@fn.@fȴ9X@f:S@fڞ@fe+a@f{@f{@f{@f{@f耝IQ@fdZ@fdZ@f%2@f*0U2a@fTɅo@fTɅo@fߤ@fߤ@f@fqu!@fd8@f*0U2a@fƧ@f
(@f*0U2a@fTɅo@fF@fqu!@fqu!@f˒:*@fTɅo@g~$@g@fbM@fd8@fp
=@f@f4m@g,<@gm\@gSMj@ge+@f4m@g,<@gěT@g
ڹ@g($x@g-@g xF@g"҈p;@gC%@g 
L/@g%A@gc	@g
qv@g%A@gQ@gڹZ@gC%@g 
L/@g!n.3@g!n.3@gPH@gڹZ@g&PH@g)a@O@g(_ح@g$5?|@g(_ح@g(_F@g)\(@g+&@g(_F@g2@g6BZc @g)\(@g%+j@g(_F@g7v@g:l"h	@gA]cA@g6A7K@gB@g+&@gEeO@gLz@g?C\@g>@g4 ѷ@g3zxl"h@gD$/@gR_o @gM?@gI-V@gHNU@gEݗ@g?rGE9@gHNU@gA\@g7?@gFC,@gD$xG@g?rGE9@gBn@gEݗ@gBn@gKs@g^YJ@gX74@gT͞&@gO?|h@gSjOv@gT͞&@gI[W>@gT͞&@gb{@g_ᰉ@g[H˒@gSjOv@gO?|h@gZ[6@gfڹY@gq!.@go/V@gwQ@g{@gq!.@gq!.@gkS&@gq!.@gzK]c@gkS&@gi@gwM:@g~u!@gq+j@gptj@gsY|@gh>BZc@gd*0U@gv ě@gb@gb@gg	l@g~u!@gb@gwM:@g}u@gn/@gn/@g=K^@gW@gU@gU@g~u!@g{zH@gU@g	@gD@gn/@gXy=@g>B@g:~ @g{zH@g}u@g,=@g4K@g@gIQ@gIQ@g%@gW>6z@g-
@gsg@g-
@g}H@g+a@gVl!@g䎊r@g+a@gY@gK]d@g$/@g䎊r@gY@gI^@gsPH@g䎊r@gIQ@g ѷY@g9@gr Ĝ@gr Ĝ@gIQ@gU=@gr Ĝ@g\(@g\(@g䎊q@gGE85@g)_@g˒:*@gqu!@gp
=@g!R@gwkQ@gqiC@gZ@g)_@gr@g84֡@gce@gr@gO;d@g*0@gr@g@@g~"@g~"@g@@g@@g~"@gbM@g73@g8Y@gqu"@g73@gbM@gr@gƩ@gԌL_@g73@ga|Q@gض}Vm@g,<@g-@gT`d@gS@g73@gD*@g}H@gG{@gԌL_@g~"@gE84@g͚kP@g(@gZ@gƩ@gI^5@gԌL_@g-@gض}Vm@gE@ga|Q@g(@g6C@g~"@g͚kP@gE@g͚kP@gԌL_@gnO@gu"@gnO@g#@gC\@gC\@g'0@gu"@g'RT`@g`A7L@g0
@g3@gPH@g'RT`@ghr@ghr@gڹZ@gQ_@g_o@g'0@gN;6@gN;6@g*0@g	@g	@gm\@g	ԕ+@gm\@gB@g_o@gN;6@g7@g*0@ghr@g3@gL/{@g	 @g3@g*0@gzxl"@glC@h^5?|@gXe@gAs@g3@g$tS@glC@h
y@h@4n@gzxl"@giB@g7Kƨ@giB@glC@h >@gAs@g	 @h^5?|@h	O;dZ@h^5?|@h^5?|@h^5?|@glC@gzxl"@h%F
L@h%F
L@h^5?|@g*0@gzxl"@glC@h^5?|@hOv`@h$tS@glC@h
@h
y@hOv`@h\@h\(@hK]@h$tS@hg@h#@h[W?@h[W?@hFt@hj~#@hj~#@hFt@h[W?@h\(@h#9@h1@hFt@hL_@h?@h1@h*1@h[W?@h\(@h1@h[W>6@h[W?@hoiD@h#'R@h"h	ԕ@h
2X@h+J@h	N;5@h0
)@h"M:@h"h	ԕ@hiB@h"M:@hiB@h$/@h0
)@h0
)@hoiD@h#'R@h1ݗ+@h)>6z@hiB@h0
)@h0
)@hoiD@h"M:@h#'R@h5Xy@h?@h5Xy@h[W>6@h5Xy@h#'R@h1@h#'R@h@h#@h%@N@hQ@h'Q@h"L/{J@hQ@h&vȴ9X@h2Fs@h-hr @h5Z@h)=b@h @h!.@hQ@h)=K^@h8%@h8%@h*-
@h-g	l@h1:)z@h5Z@h5Z@h.)^@h'b@h9lC@h<}Vl@h-g	l@h8%@h,t@h8%@h1:)z@h-g	l@h5Z@h.)^@h5Z@h4YJ@h<U@h%nP@h)=K^@h>4K@h;J#9@h5Z@h<U@h<U@h4Xy=@h,t@h.)^@hB;5X@h5n/@h5n/@h1:)z@h9,=@h?tj~@hG@h>4K@h2D@h1hr!@h?tj~@hB;5X@h>4K@h>4K@h5n/@hCU=@h@D@h;J#9@h1hr!@h-fA@h5n/@hB;5X@hB;5X@h;J#9@h1hr!@hCU=@h<U@h9,=@h2D@h7	@h;J#9@hB;5X@hFeO@h?sg@h<>B@h8@4@h;IQ@h<>B@h5/V@h5/V@h<>B@h;IQ@h2!-w@h7Q@hB:)y@hI+a@hFd7@h8@4@h8@4@hEI^@hJ\(@hFd7@hC%@hFd7@hI+a@h<>B@hC-V@hGK]d@hB:)y@hC%                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     ?ݗ+j?Gz?4m9?+I?A?qu!S?)^	?6C?_o ?n?a@N?u%F
?hr!?F]c??\(?=K]?YJ?@?rGE?/v?e+a?sPH?2a|Q?&IQ?3?+jg?(?[6?ԕ*1?XbM?2W?g8}H?BZc?Z?ś=K^?o i?Ǿvȴ9X?#x?ɖR<6?xF]d?(\)?̄??
(?ύO;dZ?+J?Vl!-?ю!R<?u%F
L?%1?`A7K??5?|h?,<?D*0?_Ft?ק&?ټn.?حU?sg?ڀIQ?jfB?5Xy>?zG?s?䎊qj?p
=q?D?䎊?
L/{?I^5?}?Xe+?לߤ@?ٰ'RT?ۤ??@NU?Fs?ڍ?ٵsg?*0
?y?sh??x?׊	 ?nO?Xe,?Fs?o?-w1?nO;?҈p:?й#w?73?"`?
(?͞%?˘@?1&?!-w1?͔O
M?̘_F?~$?ƀIQ?҈p:?ۋq?IQ?!.I?:S?Q?,<?JL_?^?p:~?~($x?C]?:S?wkP?p
=q?/Vϫ?@?iB?%?TɅo?vȴ9?=K^?Q_p?tj~?2a|Q?74?JL???o hۋ?F]cf?iB?bM?p
=q?'RT`e?+?n.3?N;5?sP?JL???m8Y?u%F
L?+?,=??E?eں?Q?+I?A?E?Dg8}?]ce?vȴ9X?\N;?m\?'RTa?'/V?-
?ۋq?'RTa?lC?J#9?~$?\N<?+?Z?a@N?*0U2?C\N?	k~(?ߤ??      ?%F
L0?)^	?nO;?+jf?)^	?U=K?O;dZ?=K^???_Ft?1&y? ě?҈?$tS?_o??
=p?
=p? ě?D?U2a|?حU??tj?U=K?Xe+?҈p:?sPH?_Ft??ceO?|?ᰉ'?ᰉ'?ᰉ'?kP{?
(?&?S?2a|Q?@NU?u"?:)y?:)y?:)y?n?L_PbM?Q?tj~?PH?@?ᰉ'?ᰉ'?$/?_Ft?wkP?T`d?_Ft?$/?T`d?,<?U=K?R<64?ɅoiD?@bM?q??S&?Ϫ͞?kP{?Rn/?j6C-?n/?f?x*0
??e+a?Ϫ͞?ᰉ'?l?䎊q޿_!-w1?䎊q?~Ov_ح`bM?|1&y?n/?=K]?bM?bM?S?)^	?},<?=K]?hr Ĝ?rn/?3*0U2a?A?Mj?bMdzG{??sPH?+?+I@bM?Q_?6C-?N;5X?ᰉ'?Q?n/?kQ_?]}H˒?҈?o䎊q?Rn/?Zݘ?S&?ᰉ'?,<쿱?ݗ+j?4JF?usg?hr Ĝ:6C-?qu"?n/?Xtj~rnO;?Xtj~?rnO;g?@bM?hr Ĝ?sg?&?nO;?:)y?4J?a@N?tj~?sPH?E?*6C-?wXe+?-
qv?H?vȴ9?Q?vȴ9?bM?Ϫ͞?{?u"?Ov_ح?ᰉ'?$tS?v+I?fOv_خ?Q?qu"rsPHJ6C-?Fs?,<쿱?tj~?+?$tSF?Z?ᰉ'?~Ov_ح?4J?|??,<??6C-?hr Ĝ?tj~?nO;?Ov_خ?*0?Ϫ͞?ᰉ'?Ϫ͞?,<쿱?*6C-?u"?E?eL_?q4J?|??tj?qu!S?oiDg8?Q:6C-?htj~?nOv_ح?Q_!-w1?䎊q?{qu!S?䎊q?n/?Mj?ᰉ'?2a|Q?PH?{?L_?qu"pbM?V?!-w1?	 ?f?pbM?bM?vȴ9?Z?tj~?nO;htj~o!-w1?:)y?ᰉ'?Ϫ͞?u%F
?sPH?_o?sg?S?_o ?sg?Z?_o?4J?sPH??tj~?E?R<64?Q?_Ft?䎊r?a4J?_Ft?z6C-?o!-w1?䎊q?dzG{?bn/?Q_?`A7L?)^	?$tSM?$/?Fs?҈?4J?sPH?sPH?,<쿱?fA?sg?p)^	?n/?D*0?1&y?f?qu"?_o *6C-?tn?J6C-?L_?ᰉ'?+?~Qie+a?4J?sgF?pbMPbM?m}H˒?!-w1?fA?vȴ9X?:)y?p)^	?6C-?hr Ĝ?A?E?sg?$/?zG{?*0U2a?-
qv?n/?:)y?+jg?3*0U2a?1&?Ϫ͞?-V?,<?u"?A?vȴ9X?b}V?wc*0U2a?nO;?2a|Q?2a|Q?n?|1&yS*0U2a?wkP?O;dZ?y_o ?wkP?qu!S?bsPH?]}H˒?bsPH?o!-w1?Xe?N;5?tn?:6C-?Xec*0U2aq4J?tzG{?S&?sPH?Xe+?$tS?u"?PbM?bsPH?%2??=K]?@?ku%F?N;5?L_?Zݘ?҈?Q_?tj~?N;5?~Q?~Q*6C-?rnO;?N;5?eL_?dzG{?1&y?-V?qu!S?6C-?3*0U2a?tntnp)^	UL_?cA \?tj?sg?p:??҈?Xe?tj~?sg?_o ?{Q_?`bM?|1&y?o!-w1ſM}H˒?}Z?~Q?*0?+?ye+ag?҈?5?|h?O;dZ?~Q?-
qv?q4J??tj~?)^	?`bM?:6C-?nOv_حrsPH6C-?zvȴ9?}}H˒?$tS?~QdzG{?s*0U2a?xtj~??ZݘM}H˒rnO;pbM?qu"?J6C-nOv_ح?+jg?=K^?sg?$/UL_?zG{?+jg?kP{?*0U2a?~Ov_ح?z6C-f?$tS?n?=K^?sg?-
qv@bMm}H˒?bn/?C*0U2a?S&?U=K?{Q_??hr Ĝ?hr Ĝ?xPH@bM?Mj?},<ku%F?v+I?{Q_?z6C-?~Ov_ح?Ϫ͞?=K]?tn?{qu!S?]}H˒?@bM?},<?R<64?*0?$/?ᰉ'?Fs?|C,zxlrsPH?*0
?R<64?O
M??*0U2?_Ft?u%?S?qu!S?%2?xPH?+I?zG{?$tS?w?{u%F?T`d?},<?rn/?&V?,<?s*0U2a?nOv_ح?|1&y??tZ?x*0
?E?tj~M}H˒?eL_o!-w1?xPH?ie+a?l?vOv_خ?u"?l?*6C-?쿱[W??c	?	 ?y_o ?@bM?UL_?C,zxl?O
MV?$tSM?,<rsPH?w??{Q_?$tS?@NU?Fs?u"?zvȴ9_!-w1?3*0U2a?!-w1?|1&y?%2?)^	?s*0U2a?E?u%Fq4J]}H˒?bM?n/?Fs?N;5?	 ҿku%F?q4J?z6C-]}H˒ie+a?O;dZ?Fs?Q_?u%?L_?U=K?	 ?$/?҈?{qu!S?hr Ĝ?tj~?hr Ĝ?+?n?>BZc?xtj~?f?~Ov_ح?Q?q?u%F?Q?nO;?n/?s@NUC*0U2a?sg?*0?$/?+M}H˒?N;5X?O
M?L_?sg?{u%F?|??O
M?x*0
?ɅoiD?U=K?*0?c*0U2a?H?q4J?gusgfOv_خ?hr Ĝ?<64?o!-w1ſ|C,zxl?[Q_?{Q_?u!?p)^	?g?l?nO;uL_:6C-?{qu!S?N;5?$tS?p)^	?eL_}Z{Q_?_o?},<nOv_ح?|??@NU?%2?qu"?J6C-?v+I?|1&y?xPH?Z6C-?eL_?<64?}}H˒*6C-?:)y?N;5?l?҈?zvȴ9g?s@NU?Xe?2a|Q?0
(?䎊q?ᰉ'?_Ft?]}H˒?C*0U2a?zG{?=K^?ߤ?tZhtj~?l1&yye+aqu"?v?~Q?sPHV?q4Jc*0U2a?C,zxl?UL_?vȴ9X?R<64:6C-?g?,<?bM?)^	?z6C-?u!??{u%F?|C,zxlkQ_?vOv_خ?v?4J?҈?=K^?*0?]}H˒?q4J?N;5?L_?C,zxl?a4Jrn/?nOv_ح?vȴ9X?w?ku%Fl1&y?sPH?vȴ9bn/rsPH?tn`bM?bn/?-
qv?R<64S*0U2a:6C-bsPH?nO;?kP{bsPH?Ov_خ?fA׿nOv_حie+a?rsPH?|1&y?<64fǿx*0
?s*0U2a?_o?sg?*0U2?vOv_خ?c*0U2a??nuL_s@NU?n/?sg?+I?
=p
?w?zvȴ9?,<쿱?*0?*0U2a??*0U2a?}ZFǿx*0
}}H˒?nOv_ح?E?-V?j6C-_!-w1??!-w1?_oҿ`bM?wXe+?xtj~?S&?tj~?|C,zxl?$?p)^	m}H˒        ?o䎊q?R<64?%2?䎊q?Xe+Կ:6C-?`A7LZ6C-?nO;?rsPHqu"?usg??₿Z6C-?Rn/        ?S*0U2a?Q_?L_?!-w1??bM?n?Zݘ?|1&y?rsPHku%F?ye+a?~Q?sPH?*0?~Q?|1&y?IQ?tj?fA?`d8?}H˒?=K]??o!-w1?"`A?}}H˒?{qu!S?n?+?N;5[Q_?rn/?	 ҿM}H˒?tj?	 ?|1&y?!-w1?PH?*0U2?䎊q?bM?tnZ6C-?xPHl1&y?xPH?ݗ+j?₿j6C-?qu"?|C,zxlPbM?$tSM?Ϫ͞?Z?kP{?sPHtnrnO;V?T`d?!-w1?u"?lPbM?v+I`bM?ie+aeL_?bn/?xtj~?-
qv?䎊q?PH?=K^?vȴ9@bM?䎊q?zG{?u"_!-w1?hr Ĝ?vȴ9?@?-
qv?|1&y?{qu!S3*0U2a?[Q_?-
qv?=K]?u%?4J?vȴ9?N;5?$tS?y_o ?hr Ĝ?+?!-w1?|C,zxl?ɅoiD?sg?L_?	 ?䎊q?{?*0
?{u%F?{Q_?PbMZ6C-?y_o ?4J?Fs?҈?bM?-
qv?-
qv?|1&y?},<?Xe?Z?*0
??Ov_خ?zvȴ9?wXe+?-V?Q_?x*0
?]}H˒3*0U2a?~Ov_ح?tj~?Z?tj~?|C,zxl?~Q?sPH[Q_tnl1&y?qu"?4J??v?Z?U=K?+I??vOv_خ?ye+a?}}H˒?|C,zxlhtj~?x*0
?~Q?4J?4J?䎊r?_!-w1ſtZ?fOv_خ?J6C-?UL_?e+a?:)yF?-
qv?l1&yC*0U2a?Fs?*0?{Q_?uL_?䎊r?N;5?hr Ĝ?c*0U2a?c*0U2a?v?ᰉ'?u?tj~wXe+ԿvOv_خJ6C-?*0?N;5?䎊q?{u%Fie+a?z6C-PbM?	 ?`bMg?vȴ9?vȴ9?-
qv6C-?V?_o ?bM?c*0U2a?Xtj~?䎊r?},<?)^	?@NU?Fs?zG{?~Ov_ح?䎊q?xtj~?|1&y?)^	?|C,zxl?zvȴ9?}}H˒3*0U2a?g?2a|Q?Q?	 ?uL_nOv_ح?{u%F?sPH?@NUF?l1&y?|1&y?{u%F6C-ie+a?$tS?|??,<?4J?y_o ?~Ov_ح?S&?@NU?@NU?~Q?	 ?},<?vOv_خbsPH?*0U2a?-
qv?{u%F?J6C-?Z6C-?tZ?eL_qu"?rnO;?Q?{u%F?usg?!-w1?bM?`d8?Ov_خ?,<?䎊q?+jg?{Q_?|C,zxl?}H˒?Xtj~?y=b?1&y?u!?&?c*0U2a?u"?dzG{?uL_?T`d?$tSM?bsPH?u"?*0kQ_?!-w1?:)y?fOv_خ?e+a?0
(?0
(?-
qv?1&y?~Ov_ح?zvȴ9?@bM?tZ?[Q_?*0U2?o!-w1?xPH?4J?S?vȴ9?ie+a?o!-w1?nOv_ح?}}H˒M}H˒?}Z?q4J?fOv_خ?0
(?L_?V?1&y?N;5?V?S?ie+a?tj~?$tS?-
qv?{?@NU?䎊q?$tS?}Z?6C-?:)y?u!?uL_?eL_?䎊q?6C-?ߤ??%2?N;5?j6C-pbM?+jg?0
(?F?UL_?fOv_خ?u"                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     ?????????????????????????????????????????????????????????????????ə?????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????ə???????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     &*RB   @1G3:B34                                      1                                       